/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import koala.Koala;
import koala.KoalaLocation;
import koala.KoalaVector;
import koala.motion.MotionController;
import koala.motion.MotionSource;
import koala.motion.SearchPattern;
import koala.motion.VectorMotionController;
import koala.remote.LocationServer;
import koala.task.FailedEvent;
import koala.task.KoalaTaskEvent;
import koala.task.NetworkFailedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularSearchPattern
implements MotionSource,
SearchPattern,
TranquilComponent {
    @req(value="controller")
    public transient MotionController controller;
    @req(value="locator")
    public transient LocationServer locator;
    private boolean iAmRed;
    private String robotName;
    private volatile transient KoalaVector direction = new KoalaVector(0.0, 0.0);
    private ZThread zThread;
    private DynamicBackbone.RemoteDynamicBackbone failureHandler;
    private final int timeOut = 20000;
    private final int robotSize = 200;
    private final int angleStep = 45;
    private int spaceWidth;
    private KoalaLocation centre;
    private KoalaLocation currentWaypoint;

    public CircularSearchPattern() {
        try {
            this.iAmRed = System.getProperty("robotColour").equals("red");
            this.robotName = System.getProperty("java.rmi.server.hostname");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startComponent() {
        System.out.println("CircularSearchPattern: Registering with motion controller.");
        this.controller.registerMotionSource(this, 5);
        try {
            this.startSearch();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void stopComponent() {
        this.controller.deregisterMotionSource(this);
        try {
            this.stopSearch();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
        this.failureHandler = remoteDynamicBackbone;
    }

    public KoalaLocation nearestWaypoint(KoalaLocation koalaLocation) {
        KoalaVector koalaVector = this.centre.getVectorTo(koalaLocation);
        int n = koalaVector.direction() / 45 * 45;
        System.out.println("NEAREST ANGLE " + n);
        return this.angleToWaypoint(n);
    }

    public KoalaLocation angleToWaypoint(int n) {
        KoalaVector koalaVector = KoalaVector.createFromMagAndDir(this.spaceWidth / 6, n);
        return new KoalaLocation(this.centre.x + koalaVector.integerX(), this.centre.y + koalaVector.integerY());
    }

    public KoalaLocation nextWaypoint(KoalaLocation koalaLocation) {
        KoalaVector koalaVector = this.centre.getVectorTo(koalaLocation);
        int n = koalaVector.direction() / 45 * 45;
        n = (n + 45) % 360;
        System.out.println("NEXT ANGLE " + n);
        return this.angleToWaypoint(n);
    }

    public void eventHappened(KoalaTaskEvent koalaTaskEvent) {
        if (this.failureHandler != null) {
            System.out.println("CircularSearchPattern: Reporting failure");
            this.failureHandler.handleComponentFailure((Object)koalaTaskEvent, (TranquilComponent)this);
        }
    }

    @Override
    public void startSearch() throws RemoteException {
        if (this.zThread != null) {
            this.stopSearch();
        }
        System.out.println("CIRCLE POWER NOW");
        KoalaLocation koalaLocation = this.locator.getTopLeft();
        KoalaLocation koalaLocation2 = this.locator.getTopRight();
        KoalaLocation koalaLocation3 = this.locator.getBottomLeft();
        KoalaLocation koalaLocation4 = this.locator.getBottomRight();
        this.spaceWidth = koalaLocation4.x - koalaLocation3.x;
        System.out.println("Space is " + this.spaceWidth + " mm wide!");
        int n = koalaLocation.y - koalaLocation3.y;
        System.out.println("Space is " + n + " mm high!");
        this.centre = new KoalaLocation(koalaLocation3.x - 150 + this.spaceWidth / 2, koalaLocation3.y - 350 + n / 2);
        System.out.println("Root is " + this.centre + " (cX, cY)");
        try {
            KoalaLocation koalaLocation5 = this.locator.getRobotLocation(this.iAmRed);
            if (koalaLocation5 != null) {
                this.currentWaypoint = this.nearestWaypoint(koalaLocation5);
                System.out.println("CircularSearchPattern: Desired waypoint: " + this.currentWaypoint);
                if (this.zThread != null) {
                    this.zThread.halt();
                }
                this.zThread = new ZThread();
                this.zThread.start();
            } else {
                System.out.println("CircularSearchPattern cannot start: SkyCam cannot find me");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("CircularSearchPattern cannot start: SkyCam broken");
        }
    }

    @Override
    public void stopSearch() throws RemoteException {
        System.out.println("CIRCLE MUST STOP");
        this.zThread.halt();
        System.out.println("CIRCLE HAS STOPPED");
        Koala.getInstance().moveForward(-100.0);
        System.out.println("CIRCLE NUKING MOTION CONTROL");
        ((VectorMotionController)this.controller).stopComponent();
    }

    @Override
    public KoalaVector getDirection() {
        return this.direction;
    }

    public class ZThread
    extends Thread {
        private volatile boolean running = true;

        public void run() {
            long l = System.currentTimeMillis();
            while (this.running) {
                try {
                    KoalaLocation koalaLocation = CircularSearchPattern.this.locator.getRobotLocation(CircularSearchPattern.this.iAmRed);
                    if (koalaLocation == null || koalaLocation.heading == 999) {
                        System.out.println("CircularSearchPattern: LOST");
                        CircularSearchPattern.this.stopSearch();
                        CircularSearchPattern.this.eventHappened(new FailedEvent(null));
                    } else {
                        KoalaVector koalaVector = koalaLocation.getVectorTo(CircularSearchPattern.this.currentWaypoint);
                        if (this.running && koalaVector.magnitude() < 340.0) {
                            System.out.println("CircularSearchPattern: At waypoint: " + CircularSearchPattern.this.currentWaypoint);
                            l = System.currentTimeMillis();
                            CircularSearchPattern.this.currentWaypoint = CircularSearchPattern.this.nextWaypoint(CircularSearchPattern.this.currentWaypoint);
                            System.out.println("CircularSearchPattern: Next: " + CircularSearchPattern.this.currentWaypoint);
                            koalaVector = koalaLocation.getVectorTo(CircularSearchPattern.this.currentWaypoint);
                        } else if (!this.running) {
                            System.out.println("told to stop!");
                        }
                        if (this.running) {
                            int n = koalaVector.direction() - koalaLocation.heading;
                            CircularSearchPattern.this.direction = KoalaVector.createFromMagAndDir(5.0, n);
                        } else {
                            System.out.println("told to stop!");
                        }
                        if (System.currentTimeMillis() - l > 20000L) {
                            System.out.println("CircularSearchPattern: Not making progress");
                            CircularSearchPattern.this.eventHappened(new FailedEvent(null));
                        }
                    }
                    if (!this.running) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (RemoteException remoteException) {
                    System.out.println("CircularSearchPattern: SkyCam broken");
                    try {
                        CircularSearchPattern.this.stopSearch();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CircularSearchPattern.this.eventHappened(new NetworkFailedEvent(null, "LocationServer", remoteException.getClass().getName()));
                }
            }
        }

        public void halt() {
            this.running = false;
            if (Thread.currentThread() != CircularSearchPattern.this.zThread) {
                try {
                    CircularSearchPattern.this.zThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            CircularSearchPattern.this.direction = new KoalaVector(0.0, 0.0);
        }
    }

    public class RemoteProxy
    extends UnicastRemoteObject
    implements SearchPattern {
        public void startSearch() throws RemoteException {
            CircularSearchPattern.this.startSearch();
        }

        public void stopSearch() throws RemoteException {
            CircularSearchPattern.this.stopSearch();
        }
    }
}

