/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Vector;
import koala.KoalaLocation;
import koala.KoalaVector;
import koala.motion.MotionController;
import koala.motion.MotionSource;
import koala.motion.MultipleGoTo;
import koala.remote.LocationServer;
import koala.task.FailedEvent;
import koala.task.KoalaTaskEvent;
import koala.task.NetworkFailedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiGoToTask
implements MotionSource,
MultipleGoTo,
TranquilComponent {
    @req(value="controller")
    public transient MotionController controller;
    @req(value="locator")
    public transient LocationServer locator;
    private volatile transient Vector<KoalaLocation> waypoints = new Vector();
    private volatile transient HashMap<KoalaLocation, String> waypointNames = new HashMap();
    private volatile KoalaLocation currentWaypoint = null;
    private final String waypointLock = "LOCK";
    private boolean iAmRed;
    private String robotName;
    private final int robotSize = 200;
    private int threshold = 300;
    private transient ZThread zThread;
    private transient DynamicBackbone.RemoteDynamicBackbone failureHandler;
    private volatile transient KoalaVector direction = new KoalaVector(0.0, 0.0);

    public MultiGoToTask() {
        try {
            this.iAmRed = System.getProperty("robotColour").equals("red");
            this.robotName = System.getProperty("java.rmi.server.hostname");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startComponent() {
        System.out.println("MultiGoToTask: Registering with motion controller.");
        this.controller.registerMotionSource(this, 5);
        if (this.zThread != null) {
            this.zThread.halt();
        }
        this.zThread = new ZThread();
        this.zThread.start();
    }

    public void stopComponent() {
        if (this.zThread != null) {
            this.zThread.halt();
        }
        this.controller.deregisterMotionSource(this);
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
        this.failureHandler = remoteDynamicBackbone;
    }

    @Override
    public boolean goTo(String string) throws RemoteException {
        System.out.println("CALLED BY THE POWER OF GREYSKULL");
        KoalaLocation koalaLocation = this.locator.getLocation(string);
        this.waypointNames.put(koalaLocation, string);
        this.goTo(koalaLocation);
        return true;
    }

    @Override
    public void goTo(KoalaLocation koalaLocation) throws RemoteException {
        if (!this.locator.canSee(koalaLocation)) {
            System.out.println("MultiGoToTask: Out of range: " + koalaLocation);
        } else {
            System.out.println("MultiGoToTask: Added " + koalaLocation + " to queue.");
            this.waypoints.add(koalaLocation);
        }
    }

    @Override
    public int nWaypoints() throws RemoteException {
        return this.waypoints.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCurrentWaypoint() throws RemoteException {
        KoalaLocation koalaLocation = this.currentWaypoint;
        synchronized (koalaLocation) {
            if (this.currentWaypoint != null) {
                this.waypoints.remove(this.currentWaypoint);
                this.currentWaypoint = null;
                if (this.waypoints.size() > 0) {
                    this.currentWaypoint = this.waypoints.elementAt(0);
                }
            }
        }
    }

    @Override
    public void removeAllWaypoints() throws RemoteException {
        this.currentWaypoint = null;
        this.waypoints.clear();
    }

    private void eventHappened(KoalaTaskEvent koalaTaskEvent) {
        if (this.failureHandler != null) {
            System.out.println("MultiGoToTask: Reporting failure");
            this.failureHandler.handleComponentFailure((Object)koalaTaskEvent, (TranquilComponent)this);
        }
    }

    public void setDefaultWaypointThreshold(int n) {
        this.threshold = n;
    }

    @Override
    public KoalaVector getDirection() {
        return this.direction;
    }

    public class ZThread
    extends Thread {
        private volatile boolean running = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (this.running) {
                if (MultiGoToTask.this.waypoints.size() > 0) {
                    Object object = "LOCK";
                    // MONITORENTER : "LOCK"
                    if (MultiGoToTask.this.currentWaypoint == null) {
                        System.out.println("MultiGoToTask: Going to first waypoint");
                        MultiGoToTask.this.currentWaypoint = (KoalaLocation)MultiGoToTask.this.waypoints.elementAt(0);
                    }
                    // MONITOREXIT : object
                    try {
                        object = MultiGoToTask.this.locator.getRobotLocation(MultiGoToTask.this.iAmRed);
                        if (object == null || ((KoalaLocation)object).heading == 999) {
                            System.out.println("MultiGoToTask: LOST");
                            MultiGoToTask.this.eventHappened(new FailedEvent(null));
                        } else {
                            KoalaVector koalaVector = ((KoalaLocation)object).getVectorTo(MultiGoToTask.this.currentWaypoint);
                            String string = (String)MultiGoToTask.this.waypointNames.get(MultiGoToTask.this.currentWaypoint);
                            if (string != null && MultiGoToTask.this.locator.robotInLocation(MultiGoToTask.this.robotName, string) || koalaVector.magnitude() < (double)MultiGoToTask.this.threshold) {
                                System.out.println("MultiGoToTask: At waypoint: " + MultiGoToTask.this.currentWaypoint);
                                String string2 = "LOCK";
                                // MONITORENTER : "LOCK"
                                MultiGoToTask.this.waypoints.remove(MultiGoToTask.this.currentWaypoint);
                                MultiGoToTask.this.currentWaypoint = null;
                                if (MultiGoToTask.this.waypoints.size() > 0) {
                                    MultiGoToTask.this.currentWaypoint = (KoalaLocation)MultiGoToTask.this.waypoints.elementAt(0);
                                    System.out.println("MultiGoToTask: Next: " + MultiGoToTask.this.currentWaypoint);
                                }
                                // MONITOREXIT : string2
                            }
                            if (MultiGoToTask.this.currentWaypoint != null) {
                                koalaVector = ((KoalaLocation)object).getVectorTo(MultiGoToTask.this.currentWaypoint);
                                int n = koalaVector.direction() - ((KoalaLocation)object).heading;
                                MultiGoToTask.this.direction = KoalaVector.createFromMagAndDir(5.0, n);
                            } else {
                                System.out.println("MultiGoToTask: No more waypoints.");
                                MultiGoToTask.this.direction = new KoalaVector(0.0, 0.0);
                            }
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (RemoteException remoteException) {
                        System.out.println("MultiGoToTask: SkyCam broken");
                        MultiGoToTask.this.eventHappened(new NetworkFailedEvent(null, "LocationServer", remoteException.getClass().getName()));
                    }
                    continue;
                }
                MultiGoToTask.this.direction = new KoalaVector(0.0, 0.0);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void halt() {
            this.running = false;
            if (Thread.currentThread() != MultiGoToTask.this.zThread) {
                try {
                    MultiGoToTask.this.zThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            MultiGoToTask.this.direction = new KoalaVector(0.0, 0.0);
        }
    }

    public class RemoteProxy
    extends UnicastRemoteObject
    implements MultipleGoTo {
        public boolean goTo(String string) throws RemoteException {
            return MultiGoToTask.this.goTo(string);
        }

        public void goTo(KoalaLocation koalaLocation) throws RemoteException {
            MultiGoToTask.this.goTo(koalaLocation);
        }

        public int nWaypoints() throws RemoteException {
            return MultiGoToTask.this.nWaypoints();
        }

        public void removeCurrentWaypoint() throws RemoteException {
            MultiGoToTask.this.removeCurrentWaypoint();
        }

        public void removeAllWaypoints() throws RemoteException {
            MultiGoToTask.this.removeAllWaypoints();
        }
    }
}

