/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.Vector;
import koala.KoalaLocation;
import koala.KoalaVector;
import koala.motion.MotionController;
import koala.motion.MotionSource;
import koala.remote.LocationServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldEdgeAvoider
implements MotionSource,
TranquilComponent {
    @req(value="controller")
    public MotionController controller;
    private transient LocationServer locator;
    private boolean iAmRed;
    private final transient String locatorName = System.getProperty("centralControl") == null ? "madeira" : System.getProperty("centralControl");
    private final int BORDER_SIZE = 500;
    private KoalaLocation topLeft;
    private KoalaLocation topRight;
    private KoalaLocation bottomLeft;
    private KoalaLocation bottomRight;

    public WorldEdgeAvoider() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.locator = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
            this.iAmRed = System.getProperty("robotColour").equals("red");
            this.topLeft = this.locator.getTopLeft();
            this.topRight = this.locator.getTopRight();
            this.bottomLeft = this.locator.getBottomLeft();
            this.bottomRight = this.locator.getBottomRight();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startComponent() {
        System.out.println("WorldEdgeAvoider: Registering with motion controller.");
        this.controller.registerMotionSource(this, 30);
    }

    public void stopComponent() {
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
    }

    @Override
    public KoalaVector getDirection() {
        try {
            KoalaLocation koalaLocation = this.locator.getRobotLocation(this.iAmRed);
            int n = 0;
            int n2 = 0;
            if (koalaLocation != null && koalaLocation.heading != 999) {
                if (koalaLocation.y > this.topLeft.y - 1000) {
                    System.out.println("WorldEdgeAvoider: Too close to top");
                    n2 = this.topLeft.y - 500 - koalaLocation.y;
                } else if (koalaLocation.y < this.bottomLeft.y + 500) {
                    System.out.println("WorldEdgeAvoider: Too close to bottom");
                    n2 = this.topLeft.y - 500 - koalaLocation.y;
                }
                if (koalaLocation.x > this.bottomRight.x - 500) {
                    System.out.println("WorldEdgeAvoider: Too close to right");
                    n = this.bottomRight.x - 500 - koalaLocation.x;
                } else if (koalaLocation.x < this.bottomLeft.x + 500) {
                    System.out.println("WorldEdgeAvoider: Too close to left");
                    n = this.bottomLeft.x - 500 - koalaLocation.x;
                    n *= n;
                }
                if (n != 0 || n2 != 0) {
                    KoalaVector koalaVector = new KoalaVector(n, n2);
                    int n3 = koalaVector.direction() - koalaLocation.heading;
                    return KoalaVector.createFromMagAndDir(5.0, n3);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return new KoalaVector(0.0, 0.0);
    }
}

