/*
 * Decompiled with CFR 0.152.
 */
package koala.remote;

import com.hopstepjump.backbone.Backbone;
import com.hopstepjump.backbone.api.IRun;
import com.hopstepjump.backbone.api.req;
import com.hopstepjump.backbone.constructor.RuntimePart;
import com.hopstepjump.backbone.exceptions.BackboneException;
import com.hopstepjump.backbone.metamodel.BBComponent;
import com.hopstepjump.backbone.metamodel.BBConnector;
import com.hopstepjump.backbone.metamodel.BBConnectorEnd;
import com.hopstepjump.backbone.metamodel.BBInterface;
import com.hopstepjump.backbone.metamodel.BBLayer;
import com.hopstepjump.backbone.metamodel.BBMetaModel;
import com.hopstepjump.backbone.metamodel.BBPart;
import com.hopstepjump.backbone.metamodel.BBPort;
import com.hopstepjump.backbone.metamodel.BBPortType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import koala.remote.ArchitectureException;
import koala.remote.KoalaProxy;
import koala.remote.NullTask;
import koala.remote.RemoteArchitect;
import koala.task.ArchitectureCompleteEvent;
import koala.task.KoalaTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KoalaArchitect
extends KoalaProxy
implements IRun,
RemoteArchitect {
    @req(value="task")
    public KoalaTask task;
    private volatile boolean mustTerminate = false;
    private boolean boundOnce = false;
    private static Vector<Component> components = new Vector();
    private static Vector<String> interfaces = new Vector();

    public KoalaArchitect() throws RemoteException {
        KoalaArchitect.loadComponentDescriptions();
    }

    @Override
    public String getCurrentStratum() {
        return Backbone.getTopLevelName();
    }

    @Override
    public void runStratum(String string) throws RemoteException, ArchitectureException {
        try {
            Backbone.runModel((String)string, (String[])new String[]{"arch/load-list.combine", "arch"});
            this.mustTerminate = true;
        }
        catch (BackboneException backboneException) {
            System.err.println("Stratum construction failed:");
            backboneException.printStackTrace();
            throw new ArchitectureException("Stratum construction failed: " + backboneException.getMessage());
        }
    }

    private static void loadComponentDescriptions() {
        if (components.size() == 0) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(new File("components.txt")));
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    Component component = new Component(stringTokenizer.nextToken(), stringTokenizer.nextToken().equals("true"), stringTokenizer.nextToken());
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2.substring(0, 1).equals("+")) {
                            component.prov.add(string2.substring(1));
                            if (interfaces.contains(string2.substring(1))) continue;
                            interfaces.add(string2.substring(1));
                            continue;
                        }
                        if (!string2.substring(0, 1).equals("-")) continue;
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2.substring(1), ":");
                        component.reqPorts.add(stringTokenizer2.nextToken());
                        component.req.add(stringTokenizer2.nextToken());
                    }
                    components.add(component);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println("IO exception while loading components.txt!");
            }
        }
    }

    private boolean containsProvider(Vector<Component> vector, String string) {
        for (Component component : vector) {
            if (!component.prov.contains(string)) continue;
            return true;
        }
        return false;
    }

    private Vector<Component> copy(Vector<Component> vector) {
        Vector<Component> vector2 = new Vector<Component>();
        vector2.addAll(vector);
        return vector2;
    }

    private Vector<Component> constructArchitecture(Vector<Component> vector, String string) {
        if (this.containsProvider(vector, string)) {
            return vector;
        }
        for (Component component : components) {
            if (!component.usable() || !component.prov.contains(string)) continue;
            Vector<Component> vector2 = this.copy(vector);
            vector2.add(component);
            Vector<Component> vector3 = this.copy(vector2);
            for (String string2 : component.req) {
                vector3 = this.constructArchitecture(vector3, string2);
            }
            if (vector3 == null) continue;
            return vector3;
        }
        return null;
    }

    @Override
    public void runArchitecture(String string) throws RemoteException, ArchitectureException {
        try {
            Iterator<Object> iterator;
            BBPort bBPort;
            Object object;
            BBComponent bBComponent;
            Component component32;
            Object object3;
            String string222;
            Component component2 = new Component("koala.remote.KoalaArchitect", true, "any");
            component2.prov.add("IRun");
            component2.req.add("koala.task.KoalaTask");
            component2.reqPorts.add("task");
            component2.req.add("koala.KoalaMotors");
            component2.reqPorts.add("motors");
            component2.req.add("koala.KoalaSensors");
            component2.reqPorts.add("sensors");
            Vector<Component> vector = new Vector<Component>();
            vector.add(component2);
            Vector<Component> vector2 = this.constructArchitecture(vector, string);
            if (vector2 == null) {
                throw new ArchitectureException("No architecture can be generated: one or more requirements were not satisfied.");
            }
            BBMetaModel bBMetaModel = new BBMetaModel();
            BBLayer bBLayer = new BBLayer(bBMetaModel);
            bBLayer.setName("backbone");
            bBLayer.setGlobal(true);
            bBMetaModel.addLayer(bBLayer);
            BBInterface bBInterface = new BBInterface();
            bBInterface.setName("IRun");
            bBInterface.setRelatedClass(IRun.class);
            bBLayer.addDefinesInterface(bBInterface);
            BBPortType bBPortType = new BBPortType();
            bBPortType.addProvide(bBLayer.getInterfaceByName("IRun"));
            BBLayer bBLayer2 = new BBLayer(bBMetaModel);
            bBLayer2.setName("top");
            bBLayer2.setGlobal(false);
            bBMetaModel.addLayer(bBLayer2);
            for (String string222 : interfaces) {
                if (string222.equals("IRun")) continue;
                System.out.println("Architect:Creating interface " + string222);
                object3 = new BBInterface();
                object3.setName(string222);
                object3.setRelatedClass(Class.forName(string222));
                bBLayer2.addDefinesInterface((BBInterface)object3);
            }
            BBComponent bBComponent2 = new BBComponent();
            bBComponent2.setName("System");
            string222 = new BBPort();
            string222.setName("run");
            string222.setType(bBPortType);
            bBComponent2.addPort((BBPort)string222);
            bBLayer2.addDefinesComponent(bBComponent2);
            for (Component component32 : vector2) {
                System.out.println("Architect:Creating component " + component32.name);
                bBComponent = new BBComponent();
                bBComponent.setName(component32.name);
                bBComponent.setRelated(true);
                bBComponent.setRelatedClass(Class.forName(component32.name));
                for (String string2 : component32.prov) {
                    System.out.println("Architect:... with provision " + string2);
                    object = new BBPortType();
                    if (string2.equals("IRun")) {
                        object.addProvide(bBLayer.getInterfaceByName(string2));
                    } else {
                        object.addProvide(bBLayer2.getInterfaceByName(string2));
                    }
                    bBPort = new BBPort();
                    bBPort.setName("prov_" + string2);
                    bBPort.setType((BBPortType)object);
                    bBComponent.addPort(bBPort);
                }
                for (int i = 0; i < component32.req.size(); ++i) {
                    String string3 = component32.req.elementAt(i);
                    System.out.println("Architect:... with requirement " + string3);
                    object = new BBPortType();
                    object.addRequire(bBLayer2.getInterfaceByName(string3));
                    bBPort = new BBPort();
                    bBPort.setName(component32.reqPorts.elementAt(i));
                    bBPort.setType((BBPortType)object);
                    bBComponent.addPort(bBPort);
                }
                bBLayer2.addDefinesComponent(bBComponent);
                System.out.println("Architect:... and instance_" + component32.name);
                iterator = new BBPart();
                iterator.setName("instance_" + component32.name);
                iterator.setType(bBComponent);
                bBComponent2.addPart(iterator);
            }
            for (Component component32 : bBComponent2.getParts()) {
                bBComponent = component32.getType();
                for (BBPort bBPort2 : bBComponent.getPorts()) {
                    if (bBPort2.getType().getRequires().size() != 1) continue;
                    object = (BBInterface)bBPort2.getType().getRequires().get(0);
                    for (Object object2 : bBComponent2.getParts()) {
                        BBComponent bBComponent3 = object2.getType();
                        for (BBPort bBPort3 : bBComponent3.getPorts()) {
                            if (bBPort3.getType().getProvides().size() != 1 || !((BBInterface)bBPort3.getType().getProvides().get(0)).getName().equals(object.getName())) continue;
                            System.out.println("Architect:Creating connector " + component32.getName() + "." + bBPort2.getName() + " -- " + object2.getName() + "." + bBPort3.getName());
                            BBConnector bBConnector = new BBConnector();
                            bBConnector.setName("conn_" + bBPort2.getName() + "_" + bBPort3.getName());
                            bBComponent2.addConnector(bBConnector);
                            BBConnectorEnd bBConnectorEnd = new BBConnectorEnd();
                            bBConnectorEnd.setPart((BBPart)component32);
                            bBConnectorEnd.setPort(bBPort2);
                            bBConnector.addEnd(bBConnectorEnd);
                            BBConnectorEnd bBConnectorEnd2 = new BBConnectorEnd();
                            bBConnectorEnd2.setPart((BBPart)object2);
                            bBConnectorEnd2.setPort(bBPort3);
                            bBConnector.addEnd(bBConnectorEnd2);
                        }
                    }
                }
            }
            System.out.println("Architect:Creating run connector ");
            object3 = new BBConnector();
            object3.setName("RUNCONN");
            component32 = new BBConnectorEnd();
            bBComponent = bBComponent2.getPartByName("instance_koala.remote.KoalaArchitect");
            component32.setPart((BBPart)bBComponent);
            component32.setPort(bBComponent.getType().getPortByName("prov_IRun"));
            object3.addEnd((BBConnectorEnd)component32);
            iterator = new BBConnectorEnd();
            iterator.setPort((BBPort)string222);
            object3.addEnd(iterator);
            bBComponent2.addConnector((BBConnector)object3);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("koala.remote.KoalaArchitect", this);
            object = this.getComponentInstances(Backbone.getRuntime());
            bBPort = ((Vector)object).iterator();
            while (bBPort.hasNext()) {
                Object object2;
                object2 = bBPort.next();
                hashMap.put(object2.getClass().getName(), object2);
            }
            Backbone.runModel((String)"top.System.run", (BBMetaModel)bBMetaModel, hashMap);
            this.mustTerminate = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new ArchitectureException("Architecture generation failed: " + classNotFoundException.getMessage());
        }
    }

    private Vector<Object> getComponentInstances(RuntimePart runtimePart) {
        Vector<Object> vector = new Vector<Object>();
        Object object = runtimePart.getRelatedInstance();
        if (object == null) {
            for (RuntimePart runtimePart2 : runtimePart.getParts()) {
                vector.addAll(this.getComponentInstances(runtimePart2));
            }
        } else {
            vector.add(object);
        }
        return vector;
    }

    @Override
    public void startTask(Serializable[] serializableArray) throws RemoteException {
        if (!(this.task instanceof NullTask)) {
            this.task.initialise(serializableArray);
            this.startTask(this.task);
        }
    }

    public void run(String[] stringArray) {
        System.out.println("ARCHITECT RUNNING");
        System.out.println(": " + this.getCurrentStratum());
        this.notifyListeners(new ArchitectureCompleteEvent(null));
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            if (!this.boundOnce) {
                System.out.println("Binding ...");
                Naming.rebind("control", this);
                System.out.println("Bound");
                this.boundOnce = true;
            }
            if (System.getProperty("runTask") != null) {
                this.startTask(this.task);
            }
            this.mustTerminate = false;
            while (!this.mustTerminate) {
                Thread.sleep(200L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private static class Component {
        public final Vector<String> prov = new Vector();
        public final Vector<String> req = new Vector();
        public final Vector<String> reqPorts = new Vector();
        public final String name;
        public final boolean available;
        public final String platform;

        public Component(String string, boolean bl, String string2) {
            this.name = string;
            this.available = bl;
            this.platform = string2;
        }

        public boolean usable() {
            String string = System.getProperty("os.name");
            return this.available && (string.contains("Windows") && this.platform.equals("windows") || this.platform.equals("any"));
        }

        public String toString() {
            return this.name;
        }
    }
}

