/*
 * Decompiled with CFR 0.152.
 */
package koala.remote;

import com.hopstepjump.backbone.api.req;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import koala.Koala;
import koala.KoalaCamera;
import koala.KoalaLongRangeSensors;
import koala.KoalaMotors;
import koala.KoalaSensorReading;
import koala.KoalaSensors;
import koala.KoreCamera;
import koala.KoreMotors;
import koala.remote.RemoteKoala;
import koala.task.AchievedGoalEvent;
import koala.task.FailedEvent;
import koala.task.KoalaTask;
import koala.task.KoalaTaskEvent;
import koala.task.KoalaTaskListener;

public class KoalaProxy
extends UnicastRemoteObject
implements RemoteKoala,
KoalaTaskListener {
    @req(value="motors")
    public transient KoalaMotors motors;
    @req(value="sensors")
    public transient KoalaSensors sensors;
    @req(value="lrsensors")
    public transient KoalaLongRangeSensors lrSensors;
    @req(value="camera")
    public transient KoalaCamera cam;
    @req(value="cammotors")
    public transient KoreMotors camMotors;
    private Vector<KoalaTask> tasks = new Vector();
    private Vector<KoalaTaskListener> listeners;

    public void initialise() {
        Koala koala = Koala.getInstance();
        this.motors = koala;
        this.sensors = koala;
        this.lrSensors = koala;
        KoreCamera koreCamera = KoreCamera.getInstance();
        this.cam = koreCamera;
        this.camMotors = koreCamera;
        if (!koala.isInitialised() || !koreCamera.isInitialised()) {
            System.err.println("Robot failed to initialise.");
            koala.disconnect();
            System.exit(-1);
        }
    }

    public void initialise(String string) {
        Koala koala = Koala.getInstance(string);
        this.motors = koala;
        this.sensors = koala;
        this.lrSensors = koala;
        this.cam = null;
        if (!koala.isInitialised()) {
            System.err.println("Robot failed to initialise.");
            koala.disconnect();
            System.exit(-1);
        }
    }

    public int setSpeed(int n, int n2) throws RemoteException {
        return this.motors.setSpeed(n, n2);
    }

    public KoalaSensorReading readProximitySensors() throws RemoteException {
        return this.sensors.readProximitySensors();
    }

    public int rotate(int n) throws RemoteException {
        return this.motors.rotate(n);
    }

    public int moveForward(int n) throws RemoteException {
        return this.motors.moveForward(n);
    }

    public void setCameraSpeed(int n, int n2) throws RemoteException {
        this.camMotors.setSpeed(n, n2);
    }

    public int getBatteryTimeLeft() throws RemoteException {
        return this.sensors.getBatteryTimeLeft();
    }

    public int getTemperature() throws RemoteException {
        return this.sensors.getTemperature();
    }

    public int getLeftMotorSpeed() throws RemoteException {
        return this.motors.getLeftMotorSpeed();
    }

    public int getRightMotorSpeed() throws RemoteException {
        return this.motors.getRightMotorSpeed();
    }

    public int getBatteryCharge() throws RemoteException {
        return this.sensors.getBatteryCharge();
    }

    public int getBatteryTemperature() throws RemoteException {
        return this.sensors.getBatteryTemperature();
    }

    public int getBatteryVoltage() throws RemoteException {
        return this.sensors.getBatteryVoltage();
    }

    public int getConsumptionCurrent() throws RemoteException {
        return this.sensors.getConsumptionCurrent();
    }

    public int getLeftMotorPosition() throws RemoteException {
        return this.motors.getLeftMotorPosition();
    }

    public int getRightMotorPosition() throws RemoteException {
        return this.motors.getRightMotorPosition();
    }

    public int getLeftMotorCurrent() throws RemoteException {
        return this.motors.getLeftMotorCurrent();
    }

    public int getRightMotorCurrent() throws RemoteException {
        return this.motors.getRightMotorCurrent();
    }

    public String getSoftwareVersion() throws RemoteException {
        return this.sensors.getSoftwareVersion();
    }

    public boolean leftMotorError() throws RemoteException {
        return this.motors.leftMotorError();
    }

    public boolean rightMotorError() throws RemoteException {
        return this.motors.rightMotorError();
    }

    public KoalaSensorReading readAmbientSensors() throws RemoteException {
        return this.sensors.readAmbientSensors();
    }

    public int readAnalogueInput(int n) throws RemoteException {
        return this.sensors.readAnalogueInput(n);
    }

    public int readDigitalInput(int n) throws RemoteException {
        return this.sensors.readDigitalInput(n);
    }

    public int setDigitalOutput(int n, int n2) throws RemoteException {
        return this.sensors.setDigitalOutput(n, n2);
    }

    public int setMotorPosition(int n, int n2) throws RemoteException {
        return this.motors.setMotorPosition(n, n2);
    }

    public int setLEDState(int n, int n2) throws RemoteException {
        return this.sensors.setLEDState(n, n2);
    }

    public int turnLEDOn(int n) throws RemoteException {
        return this.sensors.turnLEDOn(n);
    }

    public int turnLEDOff(int n) throws RemoteException {
        return this.sensors.turnLEDOff(n);
    }

    public KoalaSensorReading readLongRangeSensors() throws RemoteException {
        return this.lrSensors.readLongRangeSensors();
    }

    public int readFrontLeftLRSensor() throws RemoteException {
        return this.lrSensors.readFrontLeftLRSensor();
    }

    public int readFrontRightLRSensor() throws RemoteException {
        return this.lrSensors.readFrontRightLRSensor();
    }

    public int readLeftSideLRSensor() throws RemoteException {
        return this.lrSensors.readLeftSideLRSensor();
    }

    public int readRightSideLRSensor() throws RemoteException {
        return this.lrSensors.readRightSideLRSensor();
    }

    public boolean hasLongRangeSensors() throws RemoteException {
        if (this.lrSensors == null) {
            this.lrSensors = Koala.getInstance();
        }
        return this.lrSensors.hasLongRangeSensors();
    }

    public int getPanMotorPosition() throws RemoteException {
        return this.camMotors.getPanMotorPosition();
    }

    public int getTiltMotorPosition() throws RemoteException {
        return this.camMotors.getTiltMotorPosition();
    }

    public void setCameraMotorPosition(int n, int n2) throws RemoteException {
        this.camMotors.setMotorPosition(n, n2);
    }

    public boolean isPanMotorBlocked() throws RemoteException {
        return this.camMotors.isPanMotorBlocked();
    }

    public boolean isTiltMotorBlocked() throws RemoteException {
        return this.camMotors.isTiltMotorBlocked();
    }

    public int[] getCameraImage() throws RemoteException {
        return this.cam.getImage();
    }

    public void startTask(String string) throws RemoteException {
        try {
            Class<?> clazz = RMIClassLoader.loadClass(System.getProperty("java.rmi.server.codebase"), string);
            KoalaTask koalaTask = null;
            for (Constructor<?> executable : clazz.getConstructors()) {
                if (executable.getParameterTypes().length != 0) continue;
                koalaTask = (KoalaTask)executable.newInstance(new Object[0]);
            }
            for (Executable executable : clazz.getMethods()) {
                if (!((Method)executable).getName().equals("setRobot") || ((Method)executable).getParameterTypes().length != 3) continue;
                ((Method)executable).invoke(koalaTask, this.motors, this.sensors, this.lrSensors);
            }
            this.startTask(koalaTask);
        }
        catch (Exception exception) {
            System.err.println("Cannot instantiate task " + string + ": " + exception.getClass());
            exception.printStackTrace();
        }
    }

    public void startTask(KoalaTask koalaTask) throws RemoteException {
        koalaTask.setRobot(this.motors, this.sensors, this.lrSensors);
        koalaTask.addListener(this);
        this.tasks.add(koalaTask);
        koalaTask.start();
    }

    public void stopTask(String string) throws RemoteException {
        int n;
        for (n = 0; n < this.tasks.size() && !this.tasks.elementAt(n).getClass().getName().equals(string); ++n) {
        }
        if (n < this.tasks.size()) {
            KoalaTask koalaTask = this.tasks.elementAt(n);
            koalaTask.halt();
            this.tasks.remove(koalaTask);
        }
    }

    public String listTasks() throws RemoteException {
        String string = "";
        for (KoalaTask koalaTask : this.tasks) {
            string = string + koalaTask.getClass().getName() + " ";
        }
        return string;
    }

    public void addListener(KoalaTaskListener koalaTaskListener) throws RemoteException {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(koalaTaskListener);
    }

    public void quit() throws RemoteException {
        System.exit(0);
    }

    public void eventHappened(KoalaTaskEvent koalaTaskEvent) throws RemoteException {
        System.out.println(koalaTaskEvent.source.getClass().getName() + " event: " + koalaTaskEvent);
        if (koalaTaskEvent instanceof AchievedGoalEvent || koalaTaskEvent instanceof FailedEvent) {
            koalaTaskEvent.source.halt();
            this.tasks.remove(koalaTaskEvent.source);
        }
        this.notifyListeners(koalaTaskEvent);
    }

    protected void notifyListeners(KoalaTaskEvent koalaTaskEvent) {
        if (this.listeners != null) {
            for (KoalaTaskListener koalaTaskListener : this.listeners) {
                try {
                    koalaTaskListener.eventHappened(koalaTaskEvent);
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    public static void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            KoalaProxy koalaProxy = new KoalaProxy();
            if (stringArray.length == 1) {
                koalaProxy.initialise(stringArray[0]);
            } else {
                koalaProxy.initialise();
            }
            Naming.rebind("control", koalaProxy);
            System.out.println("Running koala remote proxy...");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }
}

