/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import java.awt.Point;
import koala.Koala;
import koala.KoreCamera;
import koala.task.KoalaTask;

public class WatchTask
extends KoalaTask {
    private KoreCamera camera;

    public WatchTask() {
    }

    public WatchTask(Koala koala) {
        super(koala);
        this.camera = KoreCamera.getInstance();
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
        this.camera = KoreCamera.getInstance();
    }

    public void run() {
        try {
            while (this.running) {
                Point point = this.camera.getSpotPosition(true);
                if (point == null) {
                    System.out.println("not found");
                } else {
                    System.out.println("(" + point.x + ", " + point.y + ")");
                    double d = (double)(point.x - 176) / 352.0;
                    double d2 = (double)(point.y - 144) / 288.0;
                    int n = (int)((double)this.camera.getPanMotorPosition() + d * 20.0);
                    int n2 = (int)((double)this.camera.getTiltMotorPosition() + d2 * 16.0);
                    System.out.println("Going to (" + n + ", " + n2 + ")");
                    this.camera.setMotorPosition(n, n2);
                }
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException interruptedException) {
            this.running = false;
        }
    }
}

