/*
 * Decompiled with CFR 0.152.
 */
package koala.virtual;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import koala.KoalaLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainManager {
    private String robotFile;
    private String locFile;
    private Vector<RobotInfo> robots;
    private Vector<LocationInfo> locations;

    public DomainManager(String string, String string2) throws IOException {
        Object object;
        Object object2;
        String string3;
        this.robotFile = string;
        this.locFile = string2;
        this.robots = new Vector();
        this.locations = new Vector();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
        while ((string3 = bufferedReader.readLine()) != null) {
            object2 = new StringTokenizer(string3, ",");
            object = new RobotInfo(((StringTokenizer)object2).nextToken(), ((StringTokenizer)object2).nextToken(), ((StringTokenizer)object2).nextToken());
            this.robots.add((RobotInfo)object);
        }
        bufferedReader.close();
        object2 = new BufferedReader(new FileReader(new File(string2)));
        while ((string3 = ((BufferedReader)object2).readLine()) != null) {
            object = new StringTokenizer(string3, ",");
            LocationInfo locationInfo = new LocationInfo(((StringTokenizer)object).nextToken(), new KoalaLocation(Integer.parseInt(((StringTokenizer)object).nextToken()), Integer.parseInt(((StringTokenizer)object).nextToken())));
            if (((StringTokenizer)object).hasMoreTokens()) {
                locationInfo.threshold = Integer.parseInt(((StringTokenizer)object).nextToken());
            }
            this.locations.add(locationInfo);
        }
        ((BufferedReader)object2).close();
    }

    public String getRobotHostname(String string) {
        for (RobotInfo robotInfo : this.robots) {
            if (!robotInfo.symbolicName.equals(string)) continue;
            return robotInfo.hostname;
        }
        return null;
    }

    public String getRobotColour(String string) {
        for (RobotInfo robotInfo : this.robots) {
            if (!robotInfo.symbolicName.equals(string)) continue;
            return robotInfo.colour;
        }
        return null;
    }

    public KoalaLocation getLocation(String string) {
        for (LocationInfo locationInfo : this.locations) {
            if (!locationInfo.symbolicName.equals(string)) continue;
            return locationInfo.location;
        }
        return null;
    }

    public int getLocationThreshold(String string) {
        for (LocationInfo locationInfo : this.locations) {
            if (!locationInfo.symbolicName.equals(string)) continue;
            return locationInfo.threshold;
        }
        return -1;
    }

    public void setLocationThreshold(String string, int n) {
        for (LocationInfo locationInfo : this.locations) {
            if (!locationInfo.symbolicName.equals(string)) continue;
            locationInfo.threshold = n;
        }
    }

    public boolean isNear(KoalaLocation koalaLocation, String string) {
        KoalaLocation koalaLocation2 = this.getLocation(string);
        if (koalaLocation2 != null) {
            return koalaLocation2.getVectorTo(koalaLocation).magnitude() < (double)this.getLocationThreshold(string);
        }
        return false;
    }

    public String findClosestLocation(KoalaLocation koalaLocation) {
        for (LocationInfo locationInfo : this.locations) {
            if (!(locationInfo.location.getVectorTo(koalaLocation).magnitude() < (double)locationInfo.threshold)) continue;
            return locationInfo.symbolicName;
        }
        return null;
    }

    public void addLocation(String string, KoalaLocation koalaLocation) {
        this.locations.add(new LocationInfo(string, koalaLocation));
    }

    public void replaceLocation(String string, KoalaLocation koalaLocation) {
        for (LocationInfo locationInfo : this.locations) {
            if (!locationInfo.symbolicName.equals(string)) continue;
            locationInfo.location = koalaLocation;
        }
    }

    public Vector<LocationInfo> getLocations() {
        return this.locations;
    }

    public static class LocationInfo {
        public final String symbolicName;
        public KoalaLocation location;
        public int threshold = 300;

        public LocationInfo(String string, KoalaLocation koalaLocation) {
            this.symbolicName = string;
            this.location = koalaLocation;
        }
    }

    private static class RobotInfo {
        public final String symbolicName;
        public String hostname;
        public String colour;

        public RobotInfo(String string, String string2, String string3) {
            this.symbolicName = string;
            this.hostname = string2;
            this.colour = string3;
        }
    }
}

