// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F1_P3_Q4_TENSOR_H
#define __LAPLACIAN_F1_P3_Q4_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f1_p3_q4_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f1_p3_q4_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f1_p3_q4_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f1_p3_q4_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class laplacian_f1_p3_q4_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f1_p3_q4_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f1_p3_q4_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f1_p3_q4_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f1_p3_q4_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f1_p3_q4_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f1_p3_q4_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f1_p3_q4_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f1_p3_q4_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f1_p3_q4_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f1_p3_q4_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3*m.num_entities[1] + 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f1_p3_q4_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f1_p3_q4_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f1_p3_q4_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f1_p3_q4_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    100
    // Number of operations (multiply-add pairs) for tensor contraction: 5315
    // Total number of operations (multiply-add pairs):                  5426
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0 = det*(w[0][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1 = det*(w[0][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0 = det*(w[0][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_0_1_1 = det*(w[0][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_0_0 = det*(w[0][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_1_0_1 = det*(w[0][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_1_0 = det*(w[0][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_1 = det*(w[0][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_2_0_0 = det*(w[0][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_2_0_1 = det*(w[0][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_2_1_0 = det*(w[0][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_2_1_1 = det*(w[0][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_3_0_0 = det*(w[0][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_3_0_1 = det*(w[0][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_3_1_0 = det*(w[0][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_3_1_1 = det*(w[0][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_4_0_0 = det*(w[0][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_4_0_1 = det*(w[0][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_4_1_0 = det*(w[0][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_4_1_1 = det*(w[0][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_5_0_0 = det*(w[0][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_5_0_1 = det*(w[0][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_5_1_0 = det*(w[0][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_5_1_1 = det*(w[0][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_6_0_0 = det*(w[0][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_6_0_1 = det*(w[0][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_6_1_0 = det*(w[0][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_6_1_1 = det*(w[0][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_7_0_0 = det*(w[0][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_7_0_1 = det*(w[0][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_7_1_0 = det*(w[0][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_7_1_1 = det*(w[0][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_8_0_0 = det*(w[0][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_8_0_1 = det*(w[0][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_8_1_0 = det*(w[0][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_8_1_1 = det*(w[0][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_9_0_0 = det*(w[0][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_9_0_1 = det*(w[0][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_9_1_0 = det*(w[0][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_9_1_1 = det*(w[0][9]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[108] = 0.00815776815776807*G0_0_0_0 + 0.00286034952701614*G0_0_0_1 + 0.00161616161616148*G0_0_1_0 - 0.0067596600929935*G0_0_1_1 - 0.0100817700817701*G0_1_0_0 - 0.00897867564534297*G0_1_0_1 - 0.0047715247715248*G0_1_1_0 + 0.074651274651274*G0_2_0_0 + 0.0096200096200093*G0_2_0_1 + 0.0494853294853291*G0_2_1_0 + 0.00675966009299316*G0_2_1_1 + 0.0387878787878791*G0_3_0_0 - 0.00161616161616151*G0_3_0_1 + 0.00415584415584436*G0_3_1_0 - 0.00900432900432892*G0_3_1_1 - 0.0505627705627703*G0_4_0_0 + 0.00150072150072129*G0_4_0_1 - 0.024242424242424*G0_4_1_0 + 0.00138528138528125*G0_4_1_1 - 0.0567965367965363*G0_5_0_0 - 0.00531024531024525*G0_5_0_1 + 0.0685714285714278*G0_5_1_0 + 0.0225108225108225*G0_5_1_1 - 0.198787878787878*G0_6_0_0 - 0.0278210678210679*G0_6_0_1 - 0.141991341991341*G0_6_1_0 - 0.0225108225108225*G0_6_1_1 - 0.00831168831168832*G0_7_0_0 + 0.000115440115440341*G0_7_0_1 - 0.00484848484848498*G0_7_1_0 - 0.0013852813852813*G0_7_1_1 + 0.0117748917748916*G0_8_0_0 + 0.00738816738816669*G0_8_0_1 + 0.0090043290043285*G0_8_1_1 + 0.0387878787878792*G0_9_0_0 - 0.02008658008658*G0_9_0_1 + 0.00969696969696983*G0_9_1_0;
    A[181] = -0.0142632675966008*G0_0_0_0 - 0.000795254128587482*G0_0_1_0 + 0.0279621612954947*G0_1_0_0 + 0.014083694083694*G0_2_0_0 + 0.00829886163219493*G0_2_1_0 + 0.0750360750360747*G0_3_0_0 + 0.0386724386724386*G0_3_1_0 - 0.0389033189033188*G0_4_0_0 - 0.0195093795093795*G0_4_1_0 - 0.125598845598845*G0_5_0_0 + 0.00507936507936499*G0_5_1_0 - 0.0185858585858587*G0_6_0_0 - 0.0125829725829726*G0_6_1_0 - 0.0174314574314574*G0_7_0_0 + 0.0451370851370847*G0_7_1_0 + 0.0421356421356421*G0_8_0_0 - 0.0386724386724383*G0_8_1_0 - 0.0290909090909088*G0_9_0_0 - 0.0256277056277054*G0_9_1_0;
    A[176] = 0.0940965207631872*G0_0_0_0 + 0.0277056277056276*G0_0_0_1 + 0.0277056277056276*G0_0_1_0 + 0.0795254128587459*G0_0_1_1 + 0.527433060766392*G0_1_0_0 + 0.638255571588902*G0_1_0_1 + 0.638255571588902*G0_1_1_0 + 0.878371011704341*G0_1_1_1 + 0.0646464646464642*G0_2_0_0 + 0.0397627064293728*G0_2_0_1 + 0.0397627064293728*G0_2_1_0 + 0.0795254128587456*G0_2_1_1 + 0.470995670995668*G0_3_0_0 + 0.480230880230877*G0_3_0_1 + 0.480230880230877*G0_3_1_0 + 0.798845598845594*G0_3_1_1 - 0.222568542568541*G0_4_0_0 - 0.187012987012986*G0_4_0_1 - 0.187012987012986*G0_4_1_0 - 0.346320346320344*G0_4_1_1 + 0.179163059163058*G0_5_0_0 - 0.0115440115440116*G0_5_0_1 - 0.0115440115440116*G0_5_1_0 - 0.0277056277056275*G0_5_1_1 - 0.0526406926406924*G0_6_0_0 - 0.0277056277056275*G0_6_1_1 - 0.00092352092352093*G0_7_0_0 - 0.122366522366522*G0_7_0_1 - 0.122366522366522*G0_7_1_0 - 0.346320346320345*G0_7_1_1 + 0.452525252525251*G0_8_0_0 + 0.161616161616161*G0_8_0_1 + 0.161616161616161*G0_8_1_0 + 0.798845598845594*G0_8_1_1 + 0.315844155844155*G0_9_0_0 + 0.0230880230880232*G0_9_0_1 + 0.0230880230880232*G0_9_1_0 + 0.212409812409812*G0_9_1_1;
    A[21] = 0.0132178932178932*G0_0_0_0 - 0.0222478755812089*G0_0_0_1 - 0.00580407247073906*G0_1_0_0 + 0.00201378868045531*G0_2_0_0 - 0.00014750681417347*G0_2_0_1 - 0.0103896103896104*G0_3_0_0 - 0.00519480519480516*G0_3_0_1 + 0.00455988455988459*G0_4_0_0 + 0.00155844155844162*G0_4_0_1 + 0.0623376623376618*G0_5_0_0 + 0.0173737373737371*G0_5_0_1 - 0.00721500721500719*G0_6_0_0 + 0.00502164502164503*G0_6_0_1 - 0.00738816738816738*G0_7_0_0 + 5.77200577199343e-05*G0_7_0_1 - 0.00288600288600277*G0_8_0_0 + 0.00519480519480527*G0_8_0_1 - 0.00611832611832611*G0_9_0_0 - 0.00161616161616166*G0_9_0_1;
    A[52] = A[108] - 0.00124418791085466*G0_0_0_1 + 0.00124418791085466*G0_0_1_0 + 0.00420715087381817*G0_1_0_1 - 0.00420715087381817*G0_1_1_0 + 0.0398653198653198*G0_2_0_1 - 0.0398653198653198*G0_2_1_0 + 0.00577200577200587*G0_3_0_1 - 0.00577200577200586*G0_3_1_0 - 0.0257431457431453*G0_4_0_1 + 0.0257431457431452*G0_4_1_0 + 0.073881673881673*G0_5_0_1 - 0.073881673881673*G0_5_1_0 - 0.114170274170273*G0_6_0_1 + 0.114170274170274*G0_6_1_0 - 0.00496392496392533*G0_7_0_1 + 0.00496392496392533*G0_7_1_0 - 0.00738816738816677*G0_8_0_1 + 0.00738816738816678*G0_8_1_0 + 0.0297835497835498*G0_9_0_1 - 0.0297835497835498*G0_9_1_0;
    A[35] = 0.0276735610068943*G0_0_1_0 + 0.00526535193201859*G0_0_1_1 + 0.0276735610068942*G0_1_1_0 + 0.000602853936187167*G0_1_1_1 + 0.38524931858265*G0_2_1_0 + 0.0951418951418945*G0_2_1_1 - 0.124098124098123*G0_3_1_0 - 0.087445887445887*G0_3_1_1 + 0.275036075036073*G0_4_1_0 + 0.154689754689754*G0_4_1_1 - 0.124098124098123*G0_5_1_0 - 0.0386724386724384*G0_5_1_1 + 0.275036075036074*G0_6_1_0 + 0.0773448773448769*G0_6_1_1 - 0.00865800865800858*G0_7_1_0 - 0.00992784992784978*G0_7_1_1 - 0.00865800865800855*G0_8_1_0 - 0.0498124098124097*G0_8_1_1 + 0.0536796536796534*G0_9_1_0 - 0.0202020202020202*G0_9_1_1;
    A[26] = -0.027070707070707*G0_0_0_0 - 0.0276735610068942*G0_0_0_1 - 0.290107423440756*G0_1_0_0 - 0.38524931858265*G0_1_0_1 - 0.0224082090748756*G0_2_0_0 - 0.0276735610068941*G0_2_0_1 - 0.197691197691197*G0_3_0_0 - 0.275036075036073*G0_3_0_1 + 0.0854256854256849*G0_4_0_0 + 0.124098124098123*G0_4_0_1 - 0.0411544011544008*G0_5_0_0 + 0.00865800865800861*G0_5_0_1 - 0.00126984126984126*G0_6_0_0 + 0.00865800865800856*G0_6_0_1 + 0.0366522366522365*G0_7_0_0 + 0.124098124098123*G0_7_0_1 - 0.12034632034632*G0_8_0_0 - 0.275036075036074*G0_8_0_1 - 0.0738816738816738*G0_9_0_0 - 0.0536796536796535*G0_9_0_1;
    A[135] = A[26] - 0.263036716370049*G0_0_0_0 - 0.262433862433861*G0_0_0_1 + 0.0951418951418946*G0_0_1_0 + 0.0951418951418946*G0_0_1_1 + 0.263036716370049*G0_1_0_0 + 0.358178611511943*G0_1_0_1 + 0.000602853936187292*G0_1_1_0 + 0.000602853936187336*G0_1_1_1 + 0.00526535193201852*G0_2_0_1 + 0.00526535193201857*G0_2_1_0 + 0.00526535193201857*G0_2_1_1 + 0.156536796536796*G0_3_0_0 + 0.233881673881673*G0_3_0_1 - 0.0498124098124095*G0_3_1_0 - 0.0498124098124094*G0_3_1_1 - 0.086695526695526*G0_4_0_0 - 0.125367965367964*G0_4_0_1 - 0.00992784992784989*G0_4_1_0 - 0.00992784992784994*G0_4_1_1 - 0.156536796536796*G0_5_0_0 - 0.206349206349205*G0_5_0_1 + 0.0773448773448768*G0_5_1_0 + 0.0773448773448768*G0_5_1_1 + 0.0866955266955262*G0_6_0_0 + 0.0767676767676764*G0_6_0_1 - 0.0386724386724384*G0_6_1_0 - 0.0386724386724384*G0_6_1_1 - 0.156998556998556*G0_7_0_0 - 0.244444444444443*G0_7_0_1 + 0.154689754689754*G0_7_1_0 + 0.154689754689754*G0_7_1_1 + 0.156998556998557*G0_8_0_0 + 0.31168831168831*G0_8_0_1 - 0.0874458874458871*G0_8_1_0 - 0.0874458874458869*G0_8_1_1 - 0.0202020202020204*G0_9_0_1 - 0.0202020202020202*G0_9_1_0 - 0.0202020202020201*G0_9_1_1;
    A[211] = A[181] + 0.0200481000480999*G0_0_0_0 - 0.00750360750360743*G0_0_1_0 - 0.0275517075517073*G0_2_0_0 - 0.00750360750360747*G0_2_1_0 + 0.00577200577200553*G0_3_0_0 - 0.0236652236652232*G0_4_0_0 - 0.0256277056277051*G0_4_1_0 + 0.119595959595959*G0_5_0_0 + 0.00750360750360761*G0_5_1_0 - 0.112092352092351*G0_6_0_0 + 0.00750360750360748*G0_6_1_0 - 0.00196248196248193*G0_7_0_0 - 0.0256277056277052*G0_7_1_0 - 0.00577200577200596*G0_8_0_0 + 0.0256277056277054*G0_9_0_0 + 0.0512554112554108*G0_9_1_0;
    A[202] = -0.0372101972101971*G0_0_0_0 - 0.0233573833573832*G0_0_0_1 - 0.0155844155844156*G0_0_1_0 + 0.0475228475228468*G0_0_1_1 + 0.0175084175084175*G0_1_0_0 + 0.00731120731120729*G0_1_0_1 + 0.007311207311207*G0_1_1_0 + 0.0146224146224143*G0_1_1_1 + 0.0492544492544486*G0_2_0_0 + 0.0708802308802302*G0_2_0_1 + 0.0631072631072622*G0_2_1_0 + 0.0475228475228467*G0_2_1_1 - 0.0838095238095239*G0_3_0_0 - 0.0287445887445888*G0_3_0_1 - 0.0727272727272731*G0_3_1_0 - 0.0117748917748921*G0_3_1_1 - 0.0422510822510826*G0_4_0_0 - 0.0921212121212122*G0_4_0_1 - 0.0633766233766235*G0_4_1_0 - 0.0470995670995669*G0_4_1_1 + 0.202943722943722*G0_5_0_0 - 0.244155844155842*G0_5_0_1 - 0.0446753246753248*G0_5_1_1 + 0.402424242424242*G0_6_0_0 + 0.199480519480519*G0_6_0_1 - 0.0446753246753242*G0_6_1_0 - 0.044675324675324*G0_6_1_1 + 0.0661471861471859*G0_7_0_0 + 0.0450216450216454*G0_7_0_1 + 0.0162770562770565*G0_7_1_0 - 0.0470995670995669*G0_7_1_1 + 0.00588744588744586*G0_8_0_0 + 0.0169696969696968*G0_8_0_1 + 0.0609523809523797*G0_8_1_0 - 0.0117748917748922*G0_8_1_1 - 0.174545454545454*G0_9_0_0 - 0.00207792207792285*G0_9_0_1 - 0.00207792207792251*G0_9_1_0 - 0.0041558441558441*G0_9_1_1;
    A[16] = 0.0141814975148308*G0_0_0_0 + 0.172286355619688*G0_1_0_0 + 0.0141814975148308*G0_2_0_0 + 0.10777417027417*G0_3_0_0 - 0.0453282828282825*G0_4_0_0 + 0.00661976911976906*G0_5_0_0 + 0.0066197691197691*G0_6_0_0 - 0.0453282828282826*G0_7_0_0 + 0.10777417027417*G0_8_0_0 + 0.0342352092352092*G0_9_0_0;
    A[36] = -0.0010966810966811*G0_0_1_0 - 0.0365624498957831*G0_0_1_1 - 0.0101907968574635*G0_1_1_0 - 0.0123520923520923*G0_1_1_1 - 0.093185826519159*G0_2_1_0 - 0.0873817540484203*G0_2_1_1 + 0.0378643578643575*G0_3_1_0 + 0.0348629148629146*G0_3_1_1 - 0.0787878787878782*G0_4_1_0 - 0.0735930735930732*G0_4_1_1 - 0.0267821067821066*G0_5_1_0 - 0.0193362193362192*G0_5_1_1 - 0.0014430014430012*G0_6_1_0 + 0.00663780663780661*G0_6_1_1 - 0.00738816738816738*G0_7_1_0 - 0.0523520923520921*G0_7_1_1 + 0.0102741702741702*G0_8_1_0 + 0.0225108225108224*G0_8_1_1 - 0.0324386724386723*G0_9_1_0 - 0.0279365079365079*G0_9_1_1;
    A[122] = -0.0276735610068943*G0_0_0_1 - 0.027070707070707*G0_0_1_1 - 0.0276735610068942*G0_1_0_1 - 0.0224082090748757*G0_1_1_1 - 0.38524931858265*G0_2_0_1 - 0.290107423440755*G0_2_1_1 + 0.124098124098123*G0_3_0_1 + 0.0854256854256848*G0_3_1_1 - 0.275036075036073*G0_4_0_1 - 0.197691197691197*G0_4_1_1 + 0.124098124098123*G0_5_0_1 + 0.0366522366522364*G0_5_1_1 - 0.275036075036073*G0_6_0_1 - 0.12034632034632*G0_6_1_1 + 0.00865800865800857*G0_7_0_1 - 0.041154401154401*G0_7_1_1 + 0.00865800865800855*G0_8_0_1 - 0.00126984126984128*G0_8_1_1 - 0.0536796536796534*G0_9_0_1 - 0.0738816738816736*G0_9_1_1;
    A[191] = -A[108] + 0.0816802950136278*G0_0_0_0 - 0.00488696488696504*G0_0_0_1 - 0.0156742023408689*G0_0_1_0 - 0.00681096681096701*G0_0_1_1 - 0.052204585537919*G0_1_0_0 - 0.0962000962000969*G0_1_0_1 - 0.037094757094757*G0_1_1_0 + 0.047561327561327*G0_2_0_0 - 0.0036171236171239*G0_2_0_1 + 0.0158281224947889*G0_2_1_0 + 0.00311688311688283*G0_2_1_1 - 0.277979797979796*G0_3_0_0 - 0.236652236652236*G0_3_0_1 - 0.240577200577199*G0_3_1_0 - 0.142914862914863*G0_3_1_1 + 0.0925829725829723*G0_4_0_0 + 0.0670707070707065*G0_4_0_1 + 0.0870418470418469*G0_4_1_0 + 0.0170851370851369*G0_4_1_1 + 0.420663780663778*G0_5_0_0 - 0.0473304473304471*G0_5_0_1 + 0.0537950937950933*G0_5_1_0 + 0.0174314574314574*G0_5_1_1 - 0.159076479076478*G0_6_0_0 - 0.0130447330447332*G0_6_0_1 - 0.0778066378066374*G0_6_1_0 - 0.0137373737373737*G0_6_1_1 + 0.0724963924963921*G0_7_0_0 - 0.00911976911976869*G0_7_0_1 - 0.154920634920634*G0_7_1_0 - 0.0503318903318897*G0_7_1_1 - 0.242655122655122*G0_8_0_0 + 0.0300144300144289*G0_8_0_1 + 0.0369408369408368*G0_8_1_0 + 0.142914862914861*G0_8_1_1 - 0.0671861471861478*G0_9_0_1 - 0.0484848484848481*G0_9_1_0 + 0.033246753246752*G0_9_1_1;
    A[212] = 0.0124803591470258*G0_0_0_1 - 0.00421997755331084*G0_0_1_1 - 0.0124803591470258*G0_1_0_1 - 0.0167003367003366*G0_1_1_1 - 0.11729998396665*G0_2_1_1 + 0.0582972582972582*G0_3_0_1 + 0.121789321789321*G0_3_1_1 - 0.102741702741703*G0_4_0_1 - 0.219336219336218*G0_4_1_1 - 0.0582972582972578*G0_5_0_1 + 0.0634920634920632*G0_5_1_1 + 0.102741702741702*G0_6_0_1 - 0.116594516594516*G0_6_1_1 - 0.00242424242424226*G0_7_0_1 + 0.0731890331890328*G0_7_1_1 + 0.00242424242424243*G0_8_0_1 + 0.0756132756132753*G0_8_1_1 + 0.055411255411255*G0_9_1_1;
    A[1] = 0.0169472502805836*G0_0_0_0 + 0.0169472502805836*G0_0_1_0 + 0.0169472502805836*G0_1_0_0 + 0.0169472502805835*G0_1_1_0 + 0.00253166586499918*G0_2_0_0 + 0.00253166586499917*G0_2_1_0 + 0.0152417027417027*G0_3_0_0 + 0.0152417027417026*G0_3_1_0 - 0.00656204906204906*G0_4_0_0 - 0.00656204906204905*G0_4_1_0 + 0.0152417027417027*G0_5_0_0 + 0.0152417027417027*G0_5_1_0 - 0.00656204906204905*G0_6_0_0 - 0.00656204906204906*G0_6_1_0 - 0.000342712842712815*G0_7_0_0 - 0.000342712842712808*G0_7_1_0 - 0.00034271284271283*G0_8_0_0 - 0.000342712842712838*G0_8_1_0 + 0.00351370851370854*G0_9_0_0 + 0.00351370851370853*G0_9_1_0;
    A[27] = A[181] - 0.000795254128587467*G0_0_0_1 + 0.000795254128587465*G0_0_1_0 + 0.00829886163219493*G0_2_0_1 - 0.00829886163219493*G0_2_1_0 + 0.0386724386724386*G0_3_0_1 - 0.0386724386724386*G0_3_1_0 - 0.0195093795093795*G0_4_0_1 + 0.0195093795093795*G0_4_1_0 + 0.00507936507936501*G0_5_0_1 - 0.005079365079365*G0_5_1_0 - 0.0125829725829725*G0_6_0_1 + 0.0125829725829725*G0_6_1_0 + 0.0451370851370848*G0_7_0_1 - 0.0451370851370848*G0_7_1_0 - 0.0386724386724383*G0_8_0_1 + 0.0386724386724383*G0_8_1_0 - 0.0256277056277054*G0_9_0_1 + 0.0256277056277054*G0_9_1_0;
    A[132] = A[191] - 0.0735738335738331*G0_0_0_0 + 0.0735738335738333*G0_0_1_1 + 0.0384800384800386*G0_1_0_0 + 0.0739842873176207*G0_1_0_1 - 0.001333974667308*G0_1_1_0 - 0.0270899470899469*G0_1_1_1 + 0.0270899470899464*G0_2_0_0 - 0.0739842873176205*G0_2_0_1 + 0.00133397466730749*G0_2_1_0 - 0.0384800384800385*G0_2_1_1 + 0.332467532467531*G0_3_0_0 + 0.300606060606059*G0_3_0_1 + 0.356017316017314*G0_3_1_0 + 0.277056277056276*G0_3_1_1 - 0.277056277056277*G0_4_0_0 - 0.30060606060606*G0_4_0_1 - 0.356017316017315*G0_4_1_0 - 0.332467532467531*G0_4_1_1 - 0.526406926406922*G0_5_0_0 + 0.0327849927849929*G0_5_0_1 - 0.135295815295815*G0_5_1_0 + 0.0858874458874456*G0_5_1_1 + 0.0941991341991326*G0_6_0_0 + 0.00784992784992759*G0_6_0_1 - 0.0272438672438671*G0_6_1_0 - 0.263203463203462*G0_6_1_1 - 0.0858874458874454*G0_7_0_0 - 0.0327849927849923*G0_7_0_1 + 0.135295815295814*G0_7_1_0 + 0.526406926406924*G0_7_1_1 + 0.263203463203462*G0_8_0_0 - 0.0078499278499275*G0_8_0_1 + 0.0272438672438671*G0_8_1_0 - 0.0941991341991332*G0_8_1_1 + 0.0720346320346315*G0_9_0_0 - 0.0720346320346311*G0_9_1_1;
    A[46] = 0.00526535193201853*G0_0_0_0 + 0.0276735610068942*G0_0_1_0 + 0.0951418951418942*G0_1_0_0 + 0.38524931858265*G0_1_1_0 + 0.000602853936187231*G0_2_0_0 + 0.0276735610068942*G0_2_1_0 + 0.154689754689754*G0_3_0_0 + 0.275036075036073*G0_3_1_0 - 0.0874458874458868*G0_4_0_0 - 0.124098124098123*G0_4_1_0 - 0.00992784992784979*G0_5_0_0 - 0.00865800865800862*G0_5_1_0 - 0.0498124098124095*G0_6_0_0 - 0.00865800865800857*G0_6_1_0 - 0.0386724386724384*G0_7_0_0 - 0.124098124098123*G0_7_1_0 + 0.0773448773448766*G0_8_0_0 + 0.275036075036073*G0_8_1_0 - 0.0202020202020202*G0_9_0_0 + 0.0536796536796535*G0_9_1_0;
    A[89] = 0.0154433221099886*G0_0_0_0 - 0.0427384960718294*G0_0_0_1 - 0.0420202020202021*G0_0_1_0 - 0.0657239057239058*G0_0_1_1 - 0.0154433221099889*G0_1_0_0 - 0.058181818181818*G0_1_0_1 - 0.00923520923520923*G0_1_1_0 - 0.0591053391053391*G0_1_1_1 - 0.309892576559242*G0_2_0_1 - 0.0815776815776816*G0_2_1_0 - 0.185473785473784*G0_2_1_1 + 0.115440115440115*G0_3_0_0 + 0.277979797979797*G0_3_0_1 + 0.0845021645021645*G0_3_1_0 + 0.0858874458874455*G0_3_1_1 - 0.521789321789321*G0_4_0_0 - 0.828860028860026*G0_4_0_1 - 1.17748917748917*G0_4_1_0 - 1.23844155844155*G0_4_1_1 - 0.115440115440114*G0_5_0_0 + 0.162539682539682*G0_5_0_1 + 0.126060606060606*G0_5_1_0 + 0.181471861471861*G0_5_1_1 + 0.521789321789319*G0_6_0_0 - 0.307070707070706*G0_6_0_1 - 0.236883116883117*G0_6_1_1 + 0.0013852813852815*G0_7_0_0 + 0.0198556998557*G0_7_0_1 + 0.0609523809523807*G0_7_1_0 - 0.0249350649350643*G0_7_1_1 - 0.00138528138528134*G0_8_0_0 + 0.0184704184704188*G0_8_0_1 + 0.0041558441558441*G0_8_1_0 - 0.274285714285713*G0_8_1_1 - 0.218874458874458*G0_9_0_1 - 0.252121212121212*G0_9_1_0 - 0.620606060606059*G0_9_1_1;
    A[164] = A[202] + 0.0847330447330446*G0_0_0_0 - 0.0847330447330438*G0_0_1_1 + 0.0300144300144299*G0_1_0_0 + 0.0635690235690231*G0_1_0_1 + 0.0557960557960558*G0_1_1_0 + 0.0346320346320345*G0_1_1_1 - 0.0346320346320341*G0_2_0_0 - 0.0635690235690227*G0_2_0_1 - 0.0557960557960549*G0_2_1_0 - 0.0300144300144294*G0_2_1_1 + 0.0367099567099572*G0_3_0_0 - 0.0633766233766226*G0_3_0_1 + 0.00935064935065011*G0_3_1_0 - 0.0304761904761897*G0_3_1_1 + 0.0304761904761915*G0_4_0_0 + 0.0633766233766241*G0_4_0_1 - 0.00935064935064865*G0_4_1_0 - 0.0367099567099562*G0_4_1_1 - 0.250043290043289*G0_5_0_0 + 0.289177489177488*G0_5_0_1 + 0.0162770562770561*G0_5_1_0 + 0.110822510822511*G0_5_1_1 - 0.414199134199133*G0_6_0_0 - 0.182510822510822*G0_6_0_1 + 0.105627705627706*G0_6_1_0 + 0.0505627705627699*G0_6_1_1 - 0.110822510822511*G0_7_0_0 - 0.289177489177488*G0_7_0_1 - 0.0162770562770563*G0_7_1_0 + 0.250043290043289*G0_7_1_1 - 0.0505627705627701*G0_8_0_0 + 0.182510822510822*G0_8_0_1 - 0.105627705627704*G0_8_1_0 + 0.414199134199133*G0_8_1_1 + 0.17038961038961*G0_9_0_0 - 0.17038961038961*G0_9_1_1;
    A[195] = A[181] + 0.0422254288920954*G0_0_0_0 + 0.0279621612954946*G0_0_0_1 + 0.0287574154240816*G0_0_1_0 + 0.0279621612954942*G0_0_1_1 - 0.0422254288920956*G0_1_0_0 - 0.0142632675966008*G0_1_0_1 - 0.0134680134680135*G0_1_1_0 - 0.0134680134680134*G0_1_1_1 + 0.014083694083694*G0_2_0_1 - 0.00251402918069588*G0_2_1_0 + 0.00578483245149907*G0_2_1_1 - 0.200634920634919*G0_3_0_0 - 0.125598845598844*G0_3_0_1 - 0.169350649350648*G0_3_1_0 - 0.130678210678209*G0_3_1_1 + 0.0203174603174602*G0_4_0_0 - 0.0185858585858586*G0_4_0_1 + 0.0135064935064935*G0_4_1_0 - 0.00600288600288603*G0_4_1_1 + 0.200634920634919*G0_5_0_0 + 0.0750360750360746*G0_5_0_1 + 0.031284271284271*G0_5_1_0 + 0.036363636363636*G0_5_1_1 - 0.0203174603174602*G0_6_0_0 - 0.0389033189033188*G0_6_0_1 - 0.00681096681096664*G0_6_1_0 - 0.0193939393939392*G0_6_1_1 + 0.0595670995670995*G0_7_0_0 + 0.0421356421356421*G0_7_0_1 + 0.0356709956709954*G0_7_1_0 + 0.0808080808080802*G0_7_1_1 - 0.0595670995670995*G0_8_0_0 - 0.0174314574314573*G0_8_0_1 - 0.0238961038961038*G0_8_1_0 - 0.0625685425685419*G0_8_1_1 - 0.0290909090909088*G0_9_0_1 + 0.022164502164502*G0_9_1_0 - 0.00346320346320324*G0_9_1_1;
    A[188] = A[132] - 0.00954304954304967*G0_0_0_1 + 0.00954304954304967*G0_0_1_0 - 0.020420073753407*G0_1_0_1 + 0.020420073753407*G0_1_1_0 + 0.054898188231521*G0_2_0_1 - 0.054898188231521*G0_2_1_0 + 0.0457142857142853*G0_3_0_1 - 0.0457142857142853*G0_3_1_0 - 0.00969696969696959*G0_4_0_1 + 0.00969696969696957*G0_4_1_0 - 0.14083694083694*G0_5_0_1 + 0.14083694083694*G0_5_1_0 + 0.0143145743145746*G0_6_0_1 - 0.0143145743145746*G0_6_1_0 + 0.0272438672438665*G0_7_0_1 - 0.0272438672438665*G0_7_1_0 + 0.0494083694083693*G0_8_0_1 - 0.0494083694083693*G0_8_1_0 - 0.0110822510822511*G0_9_0_1 + 0.0110822510822512*G0_9_1_0;
    A[14] = A[195] + 0.0200481000481*G0_1_0_0 + 0.0283469616802949*G0_1_0_1 + 0.0192528459195125*G0_1_1_0 + 0.0275517075517074*G0_1_1_1 - 0.0275517075517075*G0_2_0_0 - 0.0283469616802949*G0_2_0_1 - 0.0192528459195125*G0_2_1_0 - 0.0200481000481*G0_2_1_1 + 0.119595959595959*G0_3_0_0 + 0.107012987012986*G0_3_0_1 + 0.124675324675324*G0_3_1_0 + 0.112092352092351*G0_3_1_1 - 0.112092352092351*G0_4_0_0 - 0.107012987012986*G0_4_0_1 - 0.124675324675324*G0_4_1_0 - 0.119595959595959*G0_4_1_1 + 0.00577200577200593*G0_5_0_0 - 0.0329004329004325*G0_5_0_1 + 0.0444444444444446*G0_5_1_0 + 0.00577200577200619*G0_5_1_1 - 0.0236652236652234*G0_6_0_0 + 0.0214718614718614*G0_6_0_1 - 0.0431746031746031*G0_6_1_0 + 0.00196248196248177*G0_6_1_1 - 0.00577200577200564*G0_7_0_0 + 0.032900432900433*G0_7_0_1 - 0.0444444444444437*G0_7_1_0 - 0.00577200577200511*G0_7_1_1 - 0.00196248196248204*G0_8_0_0 - 0.0214718614718616*G0_8_0_1 + 0.0431746031746026*G0_8_1_0 + 0.0236652236652228*G0_8_1_1 + 0.0256277056277056*G0_9_0_0 - 0.0256277056277055*G0_9_1_1;
    A[56] = -A[176] + 0.0921981721981721*G0_0_0_0 - 0.0120570787237453*G0_0_0_1 + 0.351964085297418*G0_1_0_0 + 0.398140131473464*G0_1_0_1 + 0.0506910373577038*G0_2_0_0 - 0.0120570787237452*G0_2_0_1 + 0.143145743145743*G0_3_0_0 - 0.156998556998556*G0_3_0_1 - 0.113131313131313*G0_4_0_0 + 0.0369408369408365*G0_4_0_1 + 0.238268398268396*G0_5_0_0 + 0.016161616161616*G0_5_0_1 - 0.00507936507936512*G0_6_0_0 + 0.0161616161616162*G0_6_0_1 + 0.0438672438672436*G0_7_0_0 + 0.0369408369408362*G0_7_0_1 + 0.443290043290042*G0_8_0_0 - 0.156998556998555*G0_8_0_1 + 0.447907647907647*G0_9_0_0 - 0.166233766233765*G0_9_0_1;
    A[99] = A[56] - 0.173570626903959*G0_0_0_0 + 0.104409171075837*G0_0_0_1 + 0.490492223825555*G0_0_1_0 - 0.0959435626102285*G0_0_1_1 + 0.173570626903959*G0_1_0_0 + 0.277979797979796*G0_1_0_1 + 0.664062850729515*G0_1_1_0 + 0.86441558441558*G0_1_1_1 + 0.0896841430174757*G0_2_0_1 + 0.0655699855699851*G0_2_1_0 + 0.0776270642937304*G0_2_1_1 + 0.386955266955264*G0_3_0_0 + 0.668629148629145*G0_3_0_1 + 0.527792207792205*G0_3_1_0 + 0.846406926406922*G0_3_1_1 - 0.0618759018759014*G0_4_0_0 - 0.192554112554111*G0_4_0_1 - 0.139451659451659*G0_4_1_0 - 0.287215007215005*G0_4_1_1 - 0.386955266955264*G0_5_0_0 + 0.28167388167388*G0_5_0_1 + 0.14083694083694*G0_5_1_0 - 0.0369408369408363*G0_5_1_1 + 0.0618759018759016*G0_6_0_0 - 0.13067821067821*G0_6_0_1 - 0.0775757575757571*G0_6_1_0 + 0.017085137085137*G0_6_1_1 - 0.054025974025974*G0_7_0_0 + 0.150072150072149*G0_7_0_1 + 0.03001443001443*G0_7_1_0 - 0.674170274170271*G0_7_1_1 + 0.0540259740259737*G0_8_0_0 + 0.204098124098122*G0_8_0_1 + 0.0840404040404038*G0_8_1_0 + 0.908282828282823*G0_8_1_1 + 0.510707070707069*G0_9_0_1 + 0.178239538239538*G0_9_1_0 + 0.344473304473303*G0_9_1_1;
    A[125] = A[56] - 0.0776270642937309*G0_0_0_0 + 0.0776270642937306*G0_0_1_1 + 0.095943562610228*G0_1_0_0 + 0.18829565496232*G0_1_0_1 + 0.598492865159529*G0_1_1_0 + 0.86441558441558*G0_1_1_1 - 0.864415584415579*G0_2_0_0 - 0.18829565496232*G0_2_0_1 - 0.598492865159528*G0_2_1_0 - 0.0959435626102287*G0_2_1_1 + 0.674170274170269*G0_3_0_0 + 0.861183261183256*G0_3_0_1 + 0.667243867243863*G0_3_1_0 + 0.908282828282823*G0_3_1_1 - 0.908282828282823*G0_4_0_0 - 0.861183261183256*G0_4_0_1 - 0.667243867243863*G0_4_1_0 - 0.67417027417027*G0_4_1_1 + 0.287215007215006*G0_5_0_0 + 0.131601731601731*G0_5_0_1 + 0.11082251082251*G0_5_1_0 + 0.0170851370851369*G0_5_1_1 - 0.846406926406922*G0_6_0_0 - 0.334776334776333*G0_6_0_1 - 0.16161616161616*G0_6_1_0 - 0.036940836940836*G0_6_1_1 - 0.017085137085137*G0_7_0_0 - 0.131601731601731*G0_7_0_1 - 0.110822510822511*G0_7_1_0 - 0.287215007215006*G0_7_1_1 + 0.0369408369408365*G0_8_0_0 + 0.334776334776333*G0_8_0_1 + 0.161616161616161*G0_8_1_0 + 0.846406926406922*G0_8_1_1 - 0.344473304473303*G0_9_0_0 + 0.344473304473304*G0_9_1_1;
    A[83] = A[125] + 0.0120570787237454*G0_0_0_1 - 0.0120570787237454*G0_0_1_0 + 0.0120570787237453*G0_1_0_1 - 0.0120570787237453*G0_1_1_0 - 0.398140131473463*G0_2_0_1 + 0.398140131473463*G0_2_1_0 - 0.036940836940837*G0_3_0_1 + 0.036940836940837*G0_3_1_0 + 0.156998556998557*G0_4_0_1 - 0.156998556998557*G0_4_1_0 - 0.0369408369408371*G0_5_0_1 + 0.0369408369408371*G0_5_1_0 + 0.156998556998557*G0_6_0_1 - 0.156998556998557*G0_6_1_0 - 0.0161616161616162*G0_7_0_1 + 0.0161616161616162*G0_7_1_0 - 0.0161616161616164*G0_8_0_1 + 0.0161616161616164*G0_8_1_0 + 0.166233766233766*G0_9_0_1 - 0.166233766233766*G0_9_1_0;
    A[80] = -A[125] + 0.0120570787237454*G0_0_1_0 + 0.0627481160814494*G0_0_1_1 + 0.0120570787237454*G0_1_1_0 + 0.104255250921918*G0_1_1_1 - 0.398140131473463*G0_2_1_0 - 0.0461760461760459*G0_2_1_1 - 0.0369408369408371*G0_3_1_0 + 0.00692640692640706*G0_3_1_1 + 0.156998556998557*G0_4_1_0 + 0.600288600288598*G0_4_1_1 - 0.0369408369408372*G0_5_1_0 - 0.15007215007215*G0_5_1_1 + 0.156998556998557*G0_6_1_0 + 0.3001443001443*G0_6_1_1 - 0.0161616161616162*G0_7_1_0 - 0.0212409812409818*G0_7_1_1 - 0.0161616161616164*G0_8_1_0 + 0.222106782106781*G0_8_1_1 + 0.166233766233766*G0_9_1_0 + 0.614141414141412*G0_9_1_1;
    A[31] = -0.00253166586499919*G0_0_1_0 - 0.0169472502805836*G0_1_1_0 - 0.0169472502805835*G0_2_1_0 + 0.000342712842712797*G0_3_1_0 + 0.000342712842712848*G0_4_1_0 + 0.00656204906204905*G0_5_1_0 - 0.0152417027417027*G0_6_1_0 + 0.00656204906204907*G0_7_1_0 - 0.0152417027417027*G0_8_1_0 - 0.00351370851370853*G0_9_1_0;
    A[72] = A[202] + 0.0547186147186146*G0_0_0_0 + 0.0335545935545936*G0_0_0_1 + 0.025781625781626*G0_0_1_0 - 0.030014430014429*G0_0_1_1 - 0.0547186147186145*G0_1_0_0 - 0.0289369889369888*G0_1_0_1 - 0.0211640211640211*G0_1_1_0 + 0.0346320346320347*G0_1_1_1 - 0.0847330447330438*G0_2_0_1 - 0.0847330447330437*G0_2_1_0 - 0.0847330447330437*G0_2_1_1 + 0.286753246753245*G0_3_0_0 + 0.23168831168831*G0_3_0_1 + 0.519826839826837*G0_3_1_0 + 0.414199134199132*G0_3_1_1 + 0.444675324675323*G0_4_0_0 + 0.539220779220777*G0_4_0_1 + 0.266320346320346*G0_4_1_0 + 0.250043290043289*G0_4_1_1 - 0.286753246753246*G0_5_0_0 + 0.233073593073591*G0_5_0_1 - 0.0550649350649359*G0_5_1_0 + 0.0505627705627709*G0_5_1_1 - 0.444675324675324*G0_6_0_0 - 0.178354978354978*G0_6_0_1 + 0.0945454545454537*G0_6_1_0 + 0.11082251082251*G0_6_1_1 - 0.06025974025974*G0_7_0_0 - 0.100086580086579*G0_7_0_1 - 0.0273593073593075*G0_7_1_0 - 0.0367099567099554*G0_7_1_1 + 0.0602597402597398*G0_8_0_0 + 0.0329004329004326*G0_8_0_1 - 0.0398268398268389*G0_8_1_0 - 0.0304761904761903*G0_8_1_1 - 0.170389610389608*G0_9_0_1 - 0.170389610389609*G0_9_1_0 - 0.170389610389609*G0_9_1_1;
    A[42] = -0.000795254128587423*G0_0_1_0 - 0.0142632675966009*G0_0_1_1 + 0.0082988616321949*G0_1_1_0 + 0.014083694083694*G0_1_1_1 + 0.0279621612954946*G0_2_1_1 - 0.0195093795093794*G0_3_1_0 - 0.0389033189033186*G0_3_1_1 + 0.0386724386724388*G0_4_1_0 + 0.0750360750360749*G0_4_1_1 + 0.0451370851370846*G0_5_1_0 - 0.0174314574314574*G0_5_1_1 - 0.0386724386724383*G0_6_1_0 + 0.042135642135642*G0_6_1_1 + 0.00507936507936503*G0_7_1_0 - 0.125598845598845*G0_7_1_1 - 0.0125829725829725*G0_8_1_0 - 0.0185858585858584*G0_8_1_1 - 0.0256277056277052*G0_9_1_0 - 0.0290909090909087*G0_9_1_1;
    A[107] = 0.0059050825717492*G0_0_0_1 + 0.0325044091710757*G0_0_1_1 + 0.018385441718775*G0_1_0_1 + 0.018047138047138*G0_1_1_1 + 0.214381914381913*G0_2_0_1 + 0.188255571588904*G0_2_1_1 - 0.0819624819624814*G0_3_0_1 - 0.0683982683982679*G0_3_1_1 + 0.180591630591629*G0_4_0_1 + 0.148268398268397*G0_4_1_1 - 0.0236652236652234*G0_5_0_1 + 0.0283549783549782*G0_5_1_1 + 0.0778499278499273*G0_6_0_1 + 0.00627705627705616*G0_6_1_1 - 0.00542568542568545*G0_7_0_1 + 0.0716450216450213*G0_7_1_1 - 0.00784992784992776*G0_8_0_1 - 0.0212987012987012*G0_8_1_1 + 0.0471861471861471*G0_9_0_1 + 0.0640692640692638*G0_9_1_1;
    A[7] = A[107] - 0.0261263427930095*G0_0_0_0 + 0.182350489017155*G0_0_0_1 - 0.0261263427930095*G0_0_1_0 + 0.155751162417828*G0_0_1_1 - 0.000338303671637027*G0_1_0_0 - 0.000338303671637077*G0_1_0_1 - 0.000338303671637015*G0_1_1_0 + 0.0265993265993265*G0_2_0_0 - 0.181877505210837*G0_2_0_1 + 0.0265993265993266*G0_2_1_0 - 0.155751162417828*G0_2_1_1 - 0.0134487734487733*G0_3_0_0 + 0.0606637806637802*G0_3_0_1 - 0.0134487734487734*G0_3_1_0 + 0.0470995670995667*G0_3_1_1 + 0.0770707070707066*G0_4_0_0 - 0.108946608946608*G0_4_0_1 + 0.0770707070707067*G0_4_1_0 - 0.0766233766233761*G0_4_1_1 - 0.0715728715728713*G0_5_0_0 + 0.0299422799422796*G0_5_0_1 - 0.0715728715728715*G0_5_1_0 - 0.022077922077922*G0_5_1_1 + 0.0520202020202018*G0_6_0_0 - 0.049494949494949*G0_6_0_1 + 0.0520202020202019*G0_6_1_0 + 0.0220779220779222*G0_6_1_1 - 0.0323232323232323*G0_7_0_0 + 0.153694083694083*G0_7_0_1 - 0.0323232323232323*G0_7_1_0 + 0.0766233766233762*G0_7_1_1 + 0.0135642135642136*G0_8_0_0 - 0.0605483405483403*G0_8_0_1 + 0.0135642135642136*G0_8_1_0 - 0.0470995670995669*G0_8_1_1 + 0.0168831168831168*G0_9_0_0 + 0.0168831168831169*G0_9_0_1 + 0.0168831168831168*G0_9_1_0;
    A[182] = A[42] - 0.00079525412858743*G0_0_0_1 + 0.000795254128587431*G0_0_1_0 + 0.0082988616321949*G0_1_0_1 - 0.0082988616321949*G0_1_1_0 - 0.0195093795093794*G0_3_0_1 + 0.0195093795093794*G0_3_1_0 + 0.0386724386724388*G0_4_0_1 - 0.0386724386724388*G0_4_1_0 + 0.0451370851370846*G0_5_0_1 - 0.0451370851370846*G0_5_1_0 - 0.0386724386724383*G0_6_0_1 + 0.0386724386724383*G0_6_1_0 + 0.00507936507936504*G0_7_0_1 - 0.00507936507936503*G0_7_1_0 - 0.0125829725829725*G0_8_0_1 + 0.0125829725829725*G0_8_1_0 - 0.0256277056277053*G0_9_0_1 + 0.0256277056277053*G0_9_1_0;
    A[198] = A[89] - 0.0811672278338943*G0_0_0_0 + 0.0811672278338944*G0_0_1_1 - 0.170030463363795*G0_1_0_0 - 0.251710758377423*G0_1_0_1 - 0.0723424723424721*G0_1_1_0 + 0.0591053391053388*G0_1_1_1 - 0.0591053391053373*G0_2_0_0 + 0.251710758377424*G0_2_0_1 + 0.0723424723424722*G0_2_1_0 + 0.170030463363796*G0_2_1_1 - 1.35388167388167*G0_3_0_0 - 1.10683982683982*G0_3_0_1 - 1.26199134199134*G0_3_1_0 - 0.607676767676765*G0_3_1_1 + 0.607676767676766*G0_4_0_0 + 1.10683982683982*G0_4_0_1 + 1.26199134199134*G0_4_1_0 + 1.35388167388167*G0_4_1_1 + 0.0905050505050499*G0_5_0_0 - 0.142683982683982*G0_5_0_1 - 0.0651082251082253*G0_5_1_0 - 0.18008658008658*G0_5_1_1 - 0.796075036075032*G0_6_0_0 + 0.325541125541124*G0_6_0_1 + 0.00415584415584378*G0_6_1_0 + 0.235497835497835*G0_6_1_1 + 0.180086580086579*G0_7_0_0 + 0.142683982683982*G0_7_0_1 + 0.0651082251082253*G0_7_1_0 - 0.0905050505050503*G0_7_1_1 - 0.235497835497834*G0_8_0_0 - 0.325541125541124*G0_8_0_1 - 0.00415584415584512*G0_8_1_0 + 0.796075036075031*G0_8_1_1 - 0.620606060606059*G0_9_0_0 + 0.620606060606058*G0_9_1_1;
    A[32] = 0.0141814975148308*G0_0_1_1 + 0.0141814975148308*G0_1_1_1 + 0.172286355619688*G0_2_1_1 - 0.0453282828282825*G0_3_1_1 + 0.10777417027417*G0_4_1_1 - 0.0453282828282826*G0_5_1_1 + 0.10777417027417*G0_6_1_1 + 0.00661976911976909*G0_7_1_1 + 0.00661976911976913*G0_8_1_1 + 0.0342352092352091*G0_9_1_1;
    A[25] = 0.0325044091710758*G0_0_0_0 + 0.00590508257174922*G0_0_0_1 + 0.188255571588904*G0_1_0_0 + 0.214381914381913*G0_1_0_1 + 0.018047138047138*G0_2_0_0 + 0.0183854417187749*G0_2_0_1 + 0.148268398268398*G0_3_0_0 + 0.180591630591629*G0_3_0_1 - 0.068398268398268*G0_4_0_0 - 0.0819624819624814*G0_4_0_1 + 0.0716450216450211*G0_5_0_0 - 0.00542568542568542*G0_5_0_1 - 0.0212987012987012*G0_6_0_0 - 0.00784992784992788*G0_6_0_1 + 0.0283549783549781*G0_7_0_0 - 0.0236652236652236*G0_7_0_1 + 0.00627705627705644*G0_8_0_0 + 0.0778499278499276*G0_8_0_1 + 0.064069264069264*G0_9_0_0 + 0.0471861471861472*G0_9_0_1;
    A[61] = -0.00033830367163698*G0_0_0_0 - 0.018385441718775*G0_0_1_0 - 0.0261263427930091*G0_1_0_0 - 0.214381914381914*G0_1_1_0 + 0.0265993265993264*G0_2_0_0 - 0.00590508257174922*G0_2_1_0 - 0.0715728715728711*G0_3_0_0 - 0.0778499278499275*G0_3_1_0 + 0.0520202020202016*G0_4_0_0 + 0.0236652236652235*G0_4_1_0 - 0.0134487734487734*G0_5_0_0 + 0.00784992784992785*G0_5_1_0 + 0.0770707070707066*G0_6_0_0 + 0.00542568542568539*G0_6_1_0 + 0.0135642135642134*G0_7_0_0 + 0.0819624819624816*G0_7_1_0 - 0.0323232323232319*G0_8_0_0 - 0.18059163059163*G0_8_1_0 + 0.0168831168831168*G0_9_0_0 - 0.0471861471861471*G0_9_1_0;
    A[15] = 0.0169472502805836*G0_0_0_0 + 0.0169472502805836*G0_0_0_1 + 0.0169472502805836*G0_1_0_0 + 0.0169472502805835*G0_1_0_1 + 0.00253166586499918*G0_2_0_0 + 0.00253166586499917*G0_2_0_1 + 0.0152417027417027*G0_3_0_0 + 0.0152417027417026*G0_3_0_1 - 0.00656204906204906*G0_4_0_0 - 0.00656204906204904*G0_4_0_1 + 0.0152417027417027*G0_5_0_0 + 0.0152417027417027*G0_5_0_1 - 0.00656204906204905*G0_6_0_0 - 0.00656204906204906*G0_6_0_1 - 0.000342712842712813*G0_7_0_0 - 0.000342712842712809*G0_7_0_1 - 0.000342712842712828*G0_8_0_0 - 0.000342712842712838*G0_8_0_1 + 0.00351370851370854*G0_9_0_0 + 0.00351370851370854*G0_9_0_1;
    A[37] = 0.0059050825717492*G0_0_1_0 + 0.0325044091710757*G0_0_1_1 + 0.018385441718775*G0_1_1_0 + 0.018047138047138*G0_1_1_1 + 0.214381914381913*G0_2_1_0 + 0.188255571588904*G0_2_1_1 - 0.0819624819624813*G0_3_1_0 - 0.0683982683982679*G0_3_1_1 + 0.180591630591629*G0_4_1_0 + 0.148268398268397*G0_4_1_1 - 0.0236652236652234*G0_5_1_0 + 0.0283549783549782*G0_5_1_1 + 0.0778499278499273*G0_6_1_0 + 0.00627705627705616*G0_6_1_1 - 0.00542568542568545*G0_7_1_0 + 0.0716450216450213*G0_7_1_1 - 0.00784992784992776*G0_8_1_0 - 0.0212987012987012*G0_8_1_1 + 0.0471861471861471*G0_9_1_0 + 0.0640692640692638*G0_9_1_1;
    A[168] = -A[176] + 0.0921981721981721*G0_0_0_0 - 0.0120570787237453*G0_0_1_0 + 0.351964085297418*G0_1_0_0 + 0.398140131473464*G0_1_1_0 + 0.0506910373577038*G0_2_0_0 - 0.0120570787237452*G0_2_1_0 + 0.143145743145743*G0_3_0_0 - 0.156998556998556*G0_3_1_0 - 0.113131313131313*G0_4_0_0 + 0.0369408369408365*G0_4_1_0 + 0.238268398268396*G0_5_0_0 + 0.016161616161616*G0_5_1_0 - 0.00507936507936511*G0_6_0_0 + 0.0161616161616162*G0_6_1_0 + 0.0438672438672436*G0_7_0_0 + 0.0369408369408362*G0_7_1_0 + 0.443290043290042*G0_8_0_0 - 0.156998556998555*G0_8_1_0 + 0.447907647907647*G0_9_0_0 - 0.166233766233765*G0_9_1_0;
    A[184] = A[72] + 0.00777296777296738*G0_1_0_1 - 0.00777296777296738*G0_1_1_0 - 0.00777296777296793*G0_2_0_1 + 0.00777296777296793*G0_2_1_0 + 0.244155844155843*G0_3_0_1 - 0.244155844155843*G0_3_1_0 - 0.244155844155843*G0_4_0_1 + 0.244155844155843*G0_4_1_0 - 0.0439826839826846*G0_5_0_1 + 0.0439826839826846*G0_5_1_0 + 0.0287445887445884*G0_6_0_1 - 0.0287445887445884*G0_6_1_0 + 0.0439826839826823*G0_7_0_1 - 0.0439826839826823*G0_7_1_0 - 0.0287445887445885*G0_8_0_1 + 0.0287445887445885*G0_8_1_0;
    A[213] = -A[191] + 0.0896841430174759*G0_0_0_0 + 0.00184704184704169*G0_0_0_1 + 0.0127240660573996*G0_0_1_0 - 0.00369408369408382*G0_0_1_1 + 0.035299021965688*G0_1_0_0 + 0.0714189514189507*G0_2_0_0 - 0.0055411255411256*G0_2_0_1 - 0.0164181497514829*G0_2_1_0 - 0.00369408369408359*G0_2_1_1 - 0.496854256854254*G0_3_0_0 - 0.123751803751803*G0_3_0_1 - 0.147763347763346*G0_3_1_0 + 0.334314574314573*G0_4_0_0 + 0.0258585858585862*G0_4_0_1 + 0.212409812409812*G0_4_1_0 - 0.0332467532467525*G0_4_1_1 + 0.446984126984123*G0_5_0_0 - 0.0480230880230878*G0_5_0_1 - 0.0701875901875901*G0_5_1_0 + 0.00369408369408353*G0_5_1_1 + 0.568888888888886*G0_6_0_0 + 0.0517171717171716*G0_6_0_1 + 0.0738816738816739*G0_6_1_0 + 0.00369408369408379*G0_6_1_1 + 0.0627994227994226*G0_7_0_0 - 0.0591053391053387*G0_7_0_1 - 0.245656565656564*G0_7_1_0 - 0.0332467532467528*G0_7_1_1 - 0.225339105339105*G0_8_0_0 + 0.123751803751803*G0_8_0_1 + 0.147763347763348*G0_8_1_0 + 0.0609523809523801*G0_9_0_0 + 0.0332467532467522*G0_9_0_1 + 0.0332467532467531*G0_9_1_0 + 0.0664935064935049*G0_9_1_1;
    A[104] = A[213] + 0.0612602212602211*G0_0_0_0 + 0.0355042488375822*G0_0_0_1 - 0.0398140131473469*G0_0_1_0 - 0.0384800384800389*G0_0_1_1 - 0.0612602212602208*G0_1_0_0 - 0.101074234407567*G0_1_0_1 - 0.0257559724226389*G0_1_1_0 - 0.0270899470899467*G0_1_1_1 + 0.073573833573833*G0_2_0_1 + 0.0735738335738335*G0_2_1_0 + 0.0735738335738331*G0_2_1_1 + 0.149610389610389*G0_3_0_0 - 0.086349206349206*G0_3_0_1 - 0.121443001443002*G0_3_1_0 - 0.0941991341991339*G0_3_1_1 + 0.338008658008657*G0_4_0_0 + 0.559191919191916*G0_4_0_1 + 0.391111111111109*G0_4_1_0 + 0.526406926406923*G0_4_1_1 - 0.14961038961039*G0_5_0_0 - 0.27105339105339*G0_5_0_1 - 0.235959595959595*G0_5_1_0 - 0.263203463203462*G0_5_1_1 - 0.338008658008655*G0_6_0_0 + 0.0531024531024531*G0_6_0_1 + 0.221183261183261*G0_6_1_0 + 0.0858874458874457*G0_6_1_1 + 0.0470995670995668*G0_7_0_0 - 0.0318614718614722*G0_7_0_1 + 0.0235497835497831*G0_7_1_0 - 0.332467532467532*G0_7_1_1 - 0.0470995670995668*G0_8_0_0 - 0.0235497835497835*G0_8_0_1 - 0.0789610389610386*G0_8_1_0 + 0.277056277056276*G0_8_1_1 - 0.072034632034632*G0_9_0_1 - 0.072034632034632*G0_9_1_0 - 0.0720346320346317*G0_9_1_1;
    A[216] = A[104] - 0.054898188231522*G0_0_0_1 + 0.054898188231522*G0_0_1_0 + 0.0204200737534071*G0_1_0_1 - 0.0204200737534071*G0_1_1_0 + 0.00954304954305006*G0_2_0_1 - 0.00954304954305005*G0_2_1_0 - 0.0494083694083692*G0_3_0_1 + 0.0494083694083692*G0_3_1_0 - 0.0272438672438673*G0_4_0_1 + 0.0272438672438673*G0_4_1_0 - 0.0143145743145743*G0_5_0_1 + 0.0143145743145743*G0_5_1_0 + 0.140836940836941*G0_6_0_1 - 0.140836940836941*G0_6_1_0 + 0.00969696969696955*G0_7_0_1 - 0.00969696969696958*G0_7_1_0 - 0.045714285714285*G0_8_0_1 + 0.045714285714285*G0_8_1_0 + 0.011082251082251*G0_9_0_1 - 0.011082251082251*G0_9_1_0;
    A[148] = A[216] - 0.119544652877986*G0_0_0_0 + 0.119544652877986*G0_0_1_1 + 0.0573609106942437*G0_1_0_0 + 0.0842456309122972*G0_1_0_1 + 0.0951226551226546*G0_1_1_0 + 0.125598845598845*G0_1_1_1 - 0.125598845598845*G0_2_0_0 - 0.0842456309122974*G0_2_0_1 - 0.0951226551226545*G0_2_1_0 - 0.0573609106942437*G0_2_1_1 + 0.507936507936505*G0_3_0_0 + 0.516709956709954*G0_3_0_1 + 0.494545454545452*G0_3_1_0 + 0.489466089466087*G0_3_1_1 - 0.489466089466087*G0_4_0_0 - 0.516709956709954*G0_4_0_1 - 0.494545454545452*G0_4_1_0 - 0.507936507936505*G0_4_1_1 - 0.136681096681095*G0_5_0_0 + 0.219336219336219*G0_5_0_1 + 0.195324675324675*G0_5_1_0 + 0.283520923520923*G0_5_1_1 - 0.0480230880230889*G0_6_0_0 - 0.199018759018759*G0_6_0_1 - 0.0124675324675328*G0_6_1_0 - 0.0988167388167386*G0_6_1_1 - 0.283520923520922*G0_7_0_0 - 0.219336219336217*G0_7_0_1 - 0.195324675324673*G0_7_1_0 + 0.136681096681097*G0_7_1_1 + 0.0988167388167384*G0_8_0_0 + 0.199018759018758*G0_8_0_1 + 0.0124675324675325*G0_8_1_0 + 0.0480230880230876*G0_8_1_1 - 0.138528138528138*G0_9_0_0 + 0.138528138528139*G0_9_1_1;
    A[204] = A[148] + 0.0548981882315208*G0_0_0_1 - 0.0548981882315208*G0_0_1_0 - 0.00954304954304971*G0_1_0_1 + 0.00954304954304971*G0_1_1_0 - 0.0204200737534071*G0_2_0_1 + 0.0204200737534071*G0_2_1_0 + 0.0272438672438673*G0_3_0_1 - 0.0272438672438672*G0_3_1_0 + 0.0494083694083696*G0_4_0_1 - 0.0494083694083696*G0_4_1_0 - 0.0096969696969699*G0_5_0_1 + 0.00969696969696994*G0_5_1_0 + 0.0457142857142856*G0_6_0_1 - 0.0457142857142856*G0_6_1_0 + 0.0143145743145742*G0_7_0_1 - 0.0143145743145743*G0_7_1_0 - 0.14083694083694*G0_8_0_1 + 0.14083694083694*G0_8_1_0 - 0.0110822510822503*G0_9_0_1 + 0.0110822510822504*G0_9_1_0;
    A[18] = -A[26] - 0.0218053551386885*G0_0_0_0 - 0.194965528298861*G0_1_0_0 - 0.0218053551386884*G0_2_0_0 - 0.043001443001443*G0_3_0_0 - 0.00202020202020192*G0_4_0_0 - 0.0510822510822506*G0_5_0_0 - 0.0510822510822508*G0_6_0_0 - 0.00202020202020186*G0_7_0_0 - 0.0430014430014432*G0_8_0_0 - 0.0940836940836939*G0_9_0_0;
    A[133] = A[132] + 0.0036940836940838*G0_0_0_0 - 0.0018470418470417*G0_0_0_1 + 0.0424819624819625*G0_0_1_0 - 0.10097162097162*G0_0_1_1 + 0.00369408369408372*G0_1_0_0 + 0.00554112554112574*G0_1_0_1 + 0.0369408369408368*G0_1_1_0 + 0.0332467532467534*G0_1_1_1 - 0.0116979316979306*G0_2_1_1 + 0.0332467532467529*G0_3_0_0 - 0.0258585858585858*G0_3_0_1 - 0.0775757575757565*G0_3_1_0 - 0.114516594516593*G0_3_1_1 + 0.123751803751805*G0_4_0_1 + 0.221645021645022*G0_4_1_0 + 0.234574314574315*G0_4_1_1 + 0.0332467532467524*G0_5_0_0 + 0.0591053391053381*G0_5_0_1 + 0.12190476190476*G0_5_1_0 - 0.0461760461760463*G0_5_1_1 - 0.123751803751802*G0_6_0_1 - 0.221645021645021*G0_6_1_0 + 0.247503607503607*G0_6_1_1 - 0.00369408369408367*G0_7_0_0 + 0.0480230880230872*G0_7_0_1 - 0.0258585858585861*G0_7_1_0 - 0.422972582972581*G0_7_1_1 - 0.00369408369408361*G0_8_0_0 - 0.0517171717171706*G0_8_0_1 - 0.0535642135642134*G0_8_1_0 + 0.136681096681097*G0_8_1_1 - 0.0664935064935055*G0_9_0_0 - 0.0332467532467522*G0_9_0_1 - 0.0443290043290037*G0_9_1_0 + 0.0443290043290045*G0_9_1_1;
    A[38] = -A[35] - 0.0218053551386884*G0_0_1_1 - 0.0218053551386885*G0_1_1_1 - 0.194965528298861*G0_2_1_1 - 0.00202020202020213*G0_3_1_1 - 0.0430014430014427*G0_4_1_1 - 0.00202020202020203*G0_5_1_1 - 0.0430014430014428*G0_6_1_1 - 0.0510822510822507*G0_7_1_1 - 0.051082251082251*G0_8_1_1 - 0.0940836940836938*G0_9_1_1;
    A[160] = A[38] + 0.339009139009138*G0_0_0_0 + 0.0227994227994229*G0_0_0_1 + 0.0504729838063172*G0_0_1_0 + 0.0449639249639248*G0_0_1_1 + 0.339009139009138*G0_1_0_0 + 0.316209716209715*G0_1_0_1 + 0.343883277216609*G0_1_1_0 + 0.333711720378385*G0_1_1_1 + 0.112746512746512*G0_2_0_0 + 0.056373256373256*G0_2_0_1 + 0.441622574955906*G0_2_1_0 + 0.382267115600447*G0_2_1_1 + 0.536450216450214*G0_3_0_0 + 0.587705627705624*G0_3_0_1 + 0.463607503607501*G0_3_1_0 + 0.589033189033185*G0_3_1_1 - 0.265627705627704*G0_4_0_0 - 0.229437229437228*G0_4_0_1 + 0.0455988455988452*G0_4_1_0 - 0.115901875901875*G0_4_1_1 + 0.536450216450213*G0_5_0_0 - 0.051255411255411*G0_5_0_1 - 0.175353535353534*G0_5_1_0 - 0.00115440115440096*G0_5_1_1 - 0.265627705627704*G0_6_0_0 - 0.0361904761904761*G0_6_0_1 + 0.238845598845597*G0_6_1_0 + 0.485887445887443*G0_7_0_0 - 0.209523809523809*G0_7_0_1 - 0.218181818181817*G0_7_1_0 + 0.150072150072149*G0_7_1_1 + 0.485887445887444*G0_8_0_0 + 0.695411255411253*G0_8_0_1 + 0.686753246753244*G0_8_1_0 + 1.01512265512265*G0_8_1_1 + 0.654545454545453*G0_9_0_0 + 0.327272727272726*G0_9_0_1 + 0.38095238095238*G0_9_1_0 + 0.704531024531022*G0_9_1_1;
    A[88] = -A[133] + 0.0552060285393617*G0_0_1_0 - 0.0112874779541443*G0_0_1_1 + 0.0205226871893535*G0_1_1_0 + 0.104665704665704*G0_1_1_1 + 0.0236010902677572*G0_2_1_1 + 0.134834054834055*G0_3_1_0 + 0.21979797979798*G0_3_1_1 + 0.073881673881674*G0_4_1_0 - 0.262279942279941*G0_4_1_1 - 0.123751803751804*G0_5_1_0 + 0.0166233766233766*G0_5_1_1 - 0.0738816738816743*G0_6_1_0 + 0.0221645021645019*G0_6_1_1 - 0.0960461760461763*G0_7_1_0 + 0.0240115440115434*G0_7_1_1 + 0.0203174603174603*G0_8_1_0 + 0.705569985569983*G0_8_1_1 - 0.011082251082251*G0_9_1_0 + 0.105281385281384*G0_9_1_1;
    A[116] = -A[108] + 0.030463363796697*G0_0_0_0 - 0.0411095077761746*G0_0_1_0 - 0.00641333974667261*G0_1_0_0 + 0.071572871572871*G0_2_0_0 + 0.0411095077761741*G0_2_1_0 + 0.0521789321789323*G0_3_0_0 + 0.0131601731601732*G0_3_1_0 - 0.0555266955266951*G0_4_0_0 - 0.0207792207792203*G0_4_1_0 - 0.108282828282827*G0_5_0_0 + 0.188051948051946*G0_5_1_0 - 0.296334776334775*G0_6_0_0 - 0.188051948051947*G0_6_1_0 - 0.0347474747474747*G0_7_0_0 + 0.02077922077922*G0_7_1_0 + 0.0390187590187587*G0_8_0_0 - 0.013160173160173*G0_8_1_0 + 0.0879653679653684*G0_9_0_0;
    A[139] = A[116] - 0.0186371653038317*G0_0_0_0 + 0.0017572550905889*G0_0_0_1 + 0.0374154240820907*G0_0_1_0 - 0.0168414301747638*G0_0_1_1 + 0.0186371653038313*G0_1_0_0 + 0.0560525893859221*G0_1_0_1 + 0.0203944203944198*G0_1_1_0 + 0.0746512746512737*G0_1_1_1 + 0.0149174282507614*G0_2_0_1 + 0.0149174282507613*G0_2_1_0 + 0.0149174282507614*G0_2_1_1 - 0.0648773448773439*G0_3_0_0 - 0.172582972582971*G0_3_0_1 - 0.0658008658008651*G0_3_1_0 - 0.207792207792207*G0_3_1_1 - 0.0925829725829719*G0_4_0_0 - 0.0499855699855696*G0_4_0_1 - 0.128831168831169*G0_4_1_0 - 0.0554112554112552*G0_4_1_1 + 0.0648773448773445*G0_5_0_0 - 0.000923520923520811*G0_5_0_1 - 0.107705627705626*G0_5_1_0 + 0.034285714285714*G0_5_1_1 + 0.0925829725829718*G0_6_0_0 - 0.0362481962481961*G0_6_0_1 + 0.0425974025974019*G0_6_1_0 - 0.0308225108225105*G0_6_1_1 + 0.0536796536796531*G0_7_0_0 + 0.0405194805194804*G0_7_0_1 + 0.00900432900432859*G0_7_1_0 + 0.0374025974025967*G0_7_1_1 - 0.0536796536796534*G0_8_0_0 - 0.0446753246753252*G0_8_0_1 - 0.0131601731601731*G0_8_1_0 - 0.0415584415584419*G0_8_1_1 + 0.0387878787878789*G0_9_0_1 + 0.0387878787878786*G0_9_1_0 + 0.0387878787878785*G0_9_1_1;
    A[157] = -A[139] - 0.0372166105499437*G0_0_0_0 + 0.115299021965689*G0_0_0_1 + 0.0093121693121691*G0_0_1_0 - 0.0509668109668106*G0_0_1_1 + 0.0156677890011219*G0_1_0_0 + 0.0567580567580566*G0_1_0_1 + 0.017566137566137*G0_1_1_0 + 0.0673400673400668*G0_1_1_1 - 0.0103896103896108*G0_2_0_0 - 0.00297578964245648*G0_2_0_1 - 0.00105820105820119*G0_2_1_0 + 0.00151996151996156*G0_2_1_1 - 0.0391919191919181*G0_3_0_0 - 0.166291486291485*G0_3_0_1 - 0.0399999999999991*G0_3_1_0 - 0.202597402597401*G0_3_1_1 - 0.101356421356421*G0_4_0_0 - 0.0468109668109669*G0_4_0_1 - 0.108571428571428*G0_4_1_0 - 0.0445021645021647*G0_4_1_1 + 0.0481962481962479*G0_5_0_0 - 0.153708513708512*G0_5_0_1 + 0.0850216450216453*G0_5_1_1 + 0.0106204906204901*G0_6_0_0 - 0.00860028860028906*G0_6_0_1 - 0.0438095238095245*G0_6_1_0 - 0.0368831168831174*G0_6_1_1 + 0.100490620490619*G0_7_0_0 - 0.117691197691197*G0_7_0_1 + 0.0228571428571418*G0_7_1_0 + 0.0735930735930731*G0_7_1_1 - 0.0550072150072144*G0_8_0_0 - 0.0522366522366521*G0_8_0_1 - 0.0666666666666658*G0_8_1_0 - 0.0349783549783548*G0_8_1_1 + 0.0512554112554112*G0_9_0_0 + 0.12017316017316*G0_9_0_1 - 0.0457142857142859*G0_9_1_0 + 0.040865800865801*G0_9_1_1;
    A[70] = A[157] + 0.0342472342472342*G0_0_0_0 - 0.115440115440115*G0_0_0_1 - 0.0129870129870132*G0_0_1_0 + 0.0428090428090424*G0_0_1_1 - 0.0342472342472336*G0_1_0_0 - 0.0472342472342465*G0_1_0_1 - 0.149687349687349*G0_1_1_0 - 0.205483405483405*G0_1_1_1 + 0.0085618085618086*G0_2_0_1 + 0.00856180856180846*G0_2_1_0 + 0.00856180856180838*G0_2_1_1 + 0.0225108225108214*G0_3_0_0 + 0.0419047619047609*G0_3_0_1 + 0.176103896103894*G0_3_1_0 + 0.2817316017316*G0_3_1_1 + 0.0193939393939394*G0_4_0_0 + 0.0512554112554113*G0_4_0_1 - 0.00103896103896089*G0_4_1_0 + 0.0152380952380955*G0_4_1_1 - 0.0225108225108223*G0_5_0_0 + 0.153593073593072*G0_5_0_1 + 0.0193939393939397*G0_5_1_0 - 0.0862337662337666*G0_5_1_1 - 0.0193939393939389*G0_6_0_0 - 0.0204329004329002*G0_6_0_1 + 0.0318614718614725*G0_6_1_0 + 0.0155844155844162*G0_6_1_1 - 0.101818181818181*G0_7_0_0 + 0.169870129870128*G0_7_0_1 - 0.0166233766233761*G0_7_1_0 - 0.00727272727272778*G0_7_1_1 + 0.101818181818181*G0_8_0_0 + 0.0851948051948042*G0_8_0_1 + 0.27168831168831*G0_8_1_0 + 0.262337662337661*G0_8_1_1 + 0.015584415584415*G0_9_0_1 + 0.0155844155844154*G0_9_1_0 + 0.0155844155844148*G0_9_1_1;
    A[154] = A[70] + 0.000673400673400295*G0_0_0_1 - 0.000673400673400294*G0_0_1_0 - 0.101779701779702*G0_1_0_1 + 0.101779701779702*G0_1_1_0 + 0.000673400673400766*G0_2_0_1 - 0.000673400673400765*G0_2_1_0 + 0.146320346320345*G0_3_0_1 - 0.146320346320345*G0_3_1_0 - 0.0401731601731599*G0_4_0_1 + 0.0401731601731599*G0_4_1_0 + 0.0121212121212122*G0_5_0_1 - 0.0121212121212122*G0_5_1_0 + 0.0121212121212124*G0_6_0_1 - 0.0121212121212124*G0_6_1_0 - 0.0401731601731595*G0_7_0_1 + 0.0401731601731595*G0_7_1_0 + 0.146320346320346*G0_8_0_1 - 0.146320346320346*G0_8_1_0 - 0.136103896103896*G0_9_0_1 + 0.136103896103896*G0_9_1_0;
    A[109] = A[70] + 0.00856180856180883*G0_0_0_0 - 0.00856180856180897*G0_0_1_1 + 0.0428090428090426*G0_1_0_0 + 0.0557960557960559*G0_1_0_1 + 0.158249158249158*G0_1_1_0 + 0.205483405483405*G0_1_1_1 - 0.205483405483404*G0_2_0_0 - 0.055796055796055*G0_2_0_1 - 0.158249158249157*G0_2_1_0 - 0.0428090428090421*G0_2_1_1 - 0.00727272727272698*G0_3_0_0 + 0.00935064935065025*G0_3_0_1 - 0.177142857142856*G0_3_1_0 - 0.26233766233766*G0_3_1_1 + 0.262337662337662*G0_4_0_0 - 0.00935064935064854*G0_4_0_1 + 0.177142857142856*G0_4_1_0 + 0.0072727272727276*G0_4_1_1 + 0.0152380952380947*G0_5_0_0 + 0.0162770562770562*G0_5_0_1 - 0.0360173160173164*G0_5_1_0 - 0.0155844155844163*G0_5_1_1 + 0.281731601731602*G0_6_0_0 + 0.105627705627706*G0_6_0_1 + 0.23982683982684*G0_6_1_0 + 0.0862337662337667*G0_6_1_1 + 0.015584415584415*G0_7_0_0 - 0.0162770562770562*G0_7_0_1 + 0.0360173160173149*G0_7_1_0 - 0.0152380952380958*G0_7_1_1 - 0.0862337662337653*G0_8_0_0 - 0.105627705627704*G0_8_0_1 - 0.239826839826838*G0_8_1_0 - 0.2817316017316*G0_8_1_1 + 0.0155844155844156*G0_9_0_0 - 0.0155844155844154*G0_9_1_1;
    A[29] = A[27] + 0.0200481000480999*G0_0_0_0 - 0.00750360750360743*G0_0_0_1 - 0.0275517075517074*G0_2_0_0 - 0.00750360750360747*G0_2_0_1 + 0.00577200577200553*G0_3_0_0 - 0.0236652236652232*G0_4_0_0 - 0.0256277056277051*G0_4_0_1 + 0.119595959595959*G0_5_0_0 + 0.00750360750360761*G0_5_0_1 - 0.112092352092351*G0_6_0_0 + 0.00750360750360748*G0_6_0_1 - 0.00196248196248193*G0_7_0_0 - 0.0256277056277052*G0_7_0_1 - 0.00577200577200596*G0_8_0_0 + 0.0256277056277054*G0_9_0_0 + 0.0512554112554108*G0_9_0_1;
    A[43] = A[42] - 0.00750360750360752*G0_0_1_0 + 0.0200481000480999*G0_0_1_1 - 0.00750360750360741*G0_1_1_0 - 0.0275517075517075*G0_1_1_1 - 0.0256277056277055*G0_3_1_0 - 0.0236652236652237*G0_3_1_1 + 0.0057720057720051*G0_4_1_1 - 0.025627705627705*G0_5_1_0 - 0.00196248196248174*G0_5_1_1 - 0.00577200577200623*G0_6_1_1 + 0.00750360750360756*G0_7_1_0 + 0.119595959595959*G0_7_1_1 + 0.00750360750360744*G0_8_1_0 - 0.112092352092352*G0_8_1_1 + 0.0512554112554105*G0_9_1_0 + 0.0256277056277051*G0_9_1_1;
    A[183] = -A[191] + 0.0841430174763504*G0_0_0_0 - 0.0205226871893535*G0_0_1_0 + 0.0236010902677565*G0_1_0_0 - 0.0664935064935061*G0_2_0_0 - 0.0552060285393616*G0_2_1_0 + 0.0960461760461755*G0_3_0_0 + 0.0738816738816738*G0_3_1_0 + 0.14037518037518*G0_4_0_0 + 0.123751803751803*G0_4_1_0 + 0.68525252525252*G0_5_0_0 - 0.0203174603174599*G0_5_1_0 + 0.12005772005772*G0_6_0_0 + 0.0960461760461758*G0_6_1_0 + 0.0849639249639245*G0_7_0_0 - 0.134834054834054*G0_7_1_0 - 0.336161616161615*G0_8_0_0 - 0.0738816738816732*G0_8_1_0 + 0.116363636363636*G0_9_0_0 + 0.0110822510822517*G0_9_1_0;
    A[57] = A[183] - 0.0109796376463042*G0_0_0_1 + 0.0109796376463042*G0_0_1_0 - 0.0548981882315216*G0_1_0_1 + 0.0548981882315216*G0_1_1_0 - 0.0347859547859547*G0_2_0_1 + 0.0347859547859547*G0_2_1_0 + 0.0835786435786432*G0_3_0_1 - 0.0835786435786432*G0_3_1_0 + 0.0780375180375178*G0_4_0_1 - 0.0780375180375178*G0_4_1_0 - 0.0475613275613275*G0_5_0_1 + 0.0475613275613275*G0_5_1_0 + 0.0466378066378065*G0_6_0_1 - 0.0466378066378065*G0_6_1_0 + 0.00600288600288588*G0_7_0_1 - 0.00600288600288587*G0_7_1_0 - 0.088196248196248*G0_8_0_1 + 0.088196248196248*G0_8_1_0 + 0.0221645021645019*G0_9_0_1 - 0.0221645021645019*G0_9_1_0;
    A[220] = A[164] + 0.00777296777296732*G0_0_0_1 - 0.00777296777296732*G0_0_1_0 - 0.0077729677729676*G0_1_0_1 + 0.0077729677729676*G0_1_1_0 + 0.0287445887445884*G0_3_0_1 - 0.0287445887445884*G0_3_1_0 - 0.0439826839826841*G0_4_0_1 + 0.043982683982684*G0_4_1_0 - 0.0287445887445887*G0_5_0_1 + 0.0287445887445887*G0_5_1_0 + 0.0439826839826847*G0_6_0_1 - 0.0439826839826847*G0_6_1_0 + 0.244155844155843*G0_7_0_1 - 0.244155844155843*G0_7_1_0 - 0.244155844155843*G0_8_0_1 + 0.244155844155843*G0_8_1_0;
    A[197] = A[182] - 0.00750360750360752*G0_0_0_1 + 0.0200481000480999*G0_0_1_1 - 0.00750360750360741*G0_1_0_1 - 0.0275517075517075*G0_1_1_1 - 0.0256277056277055*G0_3_0_1 - 0.0236652236652237*G0_3_1_1 + 0.0057720057720051*G0_4_1_1 - 0.025627705627705*G0_5_0_1 - 0.00196248196248173*G0_5_1_1 - 0.00577200577200623*G0_6_1_1 + 0.00750360750360756*G0_7_0_1 + 0.119595959595959*G0_7_1_1 + 0.00750360750360744*G0_8_0_1 - 0.112092352092352*G0_8_1_1 + 0.0512554112554105*G0_9_0_1 + 0.0256277056277051*G0_9_1_1;
    A[19] = -A[25] + 0.0321661054994388*G0_0_0_0 - 0.0124803591470258*G0_0_0_1 + 0.162129228795895*G0_1_0_0 + 0.0446464646464644*G0_2_0_0 + 0.0124803591470257*G0_2_0_1 + 0.0766955266955264*G0_3_0_0 + 0.102741702741702*G0_3_0_1 - 0.0163780663780665*G0_4_0_0 - 0.0582972582972579*G0_4_0_1 + 0.0581962481962477*G0_5_0_0 + 0.00242424242424243*G0_5_0_1 + 0.0557720057720054*G0_6_0_0 - 0.00242424242424249*G0_6_0_1 + 0.0419191919191916*G0_7_0_0 + 0.0582972582972581*G0_7_0_1 - 0.0260461760461755*G0_8_0_0 - 0.102741702741702*G0_8_0_1 + 0.0809523809523808*G0_9_0_0;
    A[33] = -A[36] + 0.00909411576078238*G0_0_1_0 - 0.0387237453904119*G0_0_1_1 - 0.00909411576078238*G0_1_1_0 - 0.0478178611511945*G0_1_1_1 - 0.0815776815776814*G0_2_1_1 + 0.0646464646464643*G0_3_1_0 + 0.042308802308802*G0_3_1_1 - 0.0773448773448768*G0_4_1_0 - 0.0655122655122652*G0_4_1_1 - 0.0646464646464643*G0_5_1_0 - 0.0223376623376621*G0_5_1_1 + 0.0773448773448771*G0_6_1_0 + 0.0118326118326117*G0_6_1_1 - 0.0176623376623376*G0_7_1_0 - 0.0401154401154399*G0_7_1_1 + 0.0176623376623375*G0_8_1_0 - 0.0224531024531025*G0_8_1_1 - 0.0234343434343435*G0_9_1_1;
    A[41] = -A[33] + 0.0103383036716369*G0_0_1_0 + 0.0233445566778901*G0_1_1_0 + 0.0931858265191593*G0_2_1_0 + 0.0267243867243868*G0_3_1_0 - 0.00375180375180379*G0_4_1_0 - 0.0394227994227993*G0_5_1_0 + 0.0839826839826835*G0_6_1_0 - 0.0152958152958153*G0_7_1_0 - 0.00998556998556994*G0_8_1_0 + 0.0340548340548339*G0_9_1_0;
    A[62] = -A[107] - 0.0124803591470258*G0_0_0_1 + 0.0321661054994387*G0_0_1_1 + 0.0124803591470258*G0_1_0_1 + 0.0446464646464647*G0_1_1_1 + 0.162129228795895*G0_2_1_1 - 0.0582972582972581*G0_3_0_1 - 0.0163780663780661*G0_3_1_1 + 0.102741702741703*G0_4_0_1 + 0.0766955266955264*G0_4_1_1 + 0.0582972582972579*G0_5_0_1 + 0.0419191919191916*G0_5_1_1 - 0.102741702741702*G0_6_0_1 - 0.0260461760461758*G0_6_1_1 + 0.00242424242424227*G0_7_0_1 + 0.0581962481962477*G0_7_1_1 - 0.00242424242424243*G0_8_0_1 + 0.0557720057720057*G0_8_1_1 + 0.0809523809523807*G0_9_1_1;
    A[44] = A[212] - 0.0124803591470258*G0_0_0_1 + 0.0124803591470258*G0_0_1_0 + 0.0124803591470258*G0_1_0_1 - 0.0124803591470258*G0_1_1_0 - 0.0582972582972582*G0_3_0_1 + 0.0582972582972582*G0_3_1_0 + 0.102741702741703*G0_4_0_1 - 0.102741702741703*G0_4_1_0 + 0.0582972582972578*G0_5_0_1 - 0.0582972582972578*G0_5_1_0 - 0.102741702741702*G0_6_0_1 + 0.102741702741702*G0_6_1_0 + 0.00242424242424227*G0_7_0_1 - 0.00242424242424227*G0_7_1_0 - 0.00242424242424244*G0_8_0_1 + 0.00242424242424244*G0_8_1_0;
    A[141] = A[99] + 0.398140131473463*G0_0_0_1 - 0.398140131473463*G0_0_1_0 - 0.0120570787237454*G0_1_0_1 + 0.0120570787237454*G0_1_1_0 - 0.0120570787237453*G0_2_0_1 + 0.0120570787237453*G0_2_1_0 + 0.0161616161616158*G0_3_0_1 - 0.0161616161616158*G0_3_1_0 + 0.0161616161616158*G0_4_0_1 - 0.0161616161616158*G0_4_1_0 - 0.156998556998556*G0_5_0_1 + 0.156998556998556*G0_5_1_0 + 0.0369408369408367*G0_6_0_1 - 0.0369408369408367*G0_6_1_0 - 0.156998556998555*G0_7_0_1 + 0.156998556998555*G0_7_1_0 + 0.0369408369408364*G0_8_0_1 - 0.0369408369408365*G0_8_1_0 - 0.166233766233766*G0_9_0_1 + 0.166233766233766*G0_9_1_0;
    A[172] = -A[52] + 0.030463363796697*G0_0_0_0 - 0.0411095077761746*G0_0_0_1 - 0.00641333974667261*G0_1_0_0 + 0.071572871572871*G0_2_0_0 + 0.0411095077761741*G0_2_0_1 + 0.0521789321789323*G0_3_0_0 + 0.0131601731601732*G0_3_0_1 - 0.0555266955266951*G0_4_0_0 - 0.0207792207792203*G0_4_0_1 - 0.108282828282827*G0_5_0_0 + 0.188051948051946*G0_5_0_1 - 0.296334776334775*G0_6_0_0 - 0.188051948051947*G0_6_0_1 - 0.0347474747474747*G0_7_0_0 + 0.02077922077922*G0_7_0_1 + 0.0390187590187587*G0_8_0_0 - 0.013160173160173*G0_8_0_1 + 0.0879653679653684*G0_9_0_0;
    A[158] = A[172] - 0.0155459355459355*G0_0_0_0 + 0.0155459355459352*G0_0_1_1 - 0.0104280904280908*G0_1_0_0 - 0.0131473464806799*G0_1_0_1 - 0.0185986852653524*G0_1_1_0 - 0.00307840307840335*G0_1_1_1 + 0.00307840307840351*G0_2_0_0 + 0.0131473464806801*G0_2_0_1 + 0.0185986852653516*G0_2_1_0 + 0.0104280904280902*G0_2_1_1 - 0.0147763347763348*G0_3_0_0 - 0.00554112554112572*G0_3_0_1 - 0.00311688311688312*G0_3_1_0 - 0.0139682539682541*G0_3_1_1 + 0.0139682539682541*G0_4_0_0 + 0.00554112554112558*G0_4_0_1 + 0.00311688311688308*G0_4_1_0 + 0.0147763347763348*G0_4_1_1 + 0.0528715728715724*G0_5_0_0 - 0.093852813852813*G0_5_0_1 - 0.00542568542568522*G0_5_1_0 - 0.0039249639249642*G0_5_1_1 + 0.0885425685425681*G0_6_0_0 + 0.0329004329004328*G0_6_0_1 - 0.0352092352092352*G0_6_1_0 + 0.00473304473304528*G0_6_1_1 + 0.0039249639249642*G0_7_0_0 + 0.0938528138528137*G0_7_0_1 + 0.00542568542568556*G0_7_1_0 - 0.0528715728715726*G0_7_1_1 - 0.00473304473304504*G0_8_0_0 - 0.032900432900433*G0_8_0_1 + 0.0352092352092339*G0_8_1_0 - 0.0885425685425685*G0_8_1_1 - 0.0491774891774892*G0_9_0_0 + 0.049177489177489*G0_9_1_1;
    A[155] = -A[158] - 0.0411095077761744*G0_0_0_1 + 0.0304633637966968*G0_0_1_1 + 0.041109507776175*G0_1_0_1 + 0.0715728715728719*G0_1_1_1 - 0.00641333974667305*G0_2_1_1 - 0.0207792207792209*G0_3_0_1 - 0.0555266955266955*G0_3_1_1 + 0.013160173160173*G0_4_0_1 + 0.0521789321789319*G0_4_1_1 + 0.0207792207792202*G0_5_0_1 - 0.0347474747474749*G0_5_1_1 - 0.0131601731601728*G0_6_0_1 + 0.0390187590187594*G0_6_1_1 + 0.188051948051947*G0_7_0_1 - 0.108282828282828*G0_7_1_1 - 0.188051948051947*G0_8_0_1 - 0.296334776334775*G0_8_1_1 + 0.087965367965368*G0_9_1_1;
    A[85] = A[155] + 0.00124418791085447*G0_0_0_1 - 0.00124418791085447*G0_0_1_0 - 0.0398653198653202*G0_1_0_1 + 0.0398653198653202*G0_1_1_0 - 0.00420715087381733*G0_2_0_1 + 0.00420715087381733*G0_2_1_0 + 0.0257431457431456*G0_3_0_1 - 0.0257431457431456*G0_3_1_0 - 0.00577200577200524*G0_4_0_1 + 0.00577200577200524*G0_4_1_0 + 0.00496392496392485*G0_5_0_1 - 0.00496392496392484*G0_5_1_0 + 0.00738816738816775*G0_6_0_1 - 0.00738816738816776*G0_6_1_0 - 0.0738816738816731*G0_7_0_1 + 0.0738816738816731*G0_7_1_0 + 0.114170274170274*G0_8_0_1 - 0.114170274170274*G0_8_1_0 - 0.0297835497835493*G0_9_0_1 + 0.0297835497835493*G0_9_1_0;
    A[130] = -A[85] - 0.0411095077761744*G0_0_1_0 + 0.0304633637966968*G0_0_1_1 + 0.0411095077761749*G0_1_1_0 + 0.0715728715728719*G0_1_1_1 - 0.00641333974667305*G0_2_1_1 - 0.0207792207792209*G0_3_1_0 - 0.0555266955266955*G0_3_1_1 + 0.013160173160173*G0_4_1_0 + 0.0521789321789319*G0_4_1_1 + 0.0207792207792202*G0_5_1_0 - 0.0347474747474749*G0_5_1_1 - 0.0131601731601728*G0_6_1_0 + 0.0390187590187594*G0_6_1_1 + 0.188051948051947*G0_7_1_0 - 0.108282828282828*G0_7_1_1 - 0.188051948051947*G0_8_1_0 - 0.296334776334775*G0_8_1_1 + 0.0879653679653681*G0_9_1_1;
    A[105] = A[7] - 0.214381914381913*G0_0_0_1 + 0.214381914381913*G0_0_1_0 - 0.018385441718775*G0_1_0_1 + 0.018385441718775*G0_1_1_0 - 0.00590508257174907*G0_2_0_1 + 0.00590508257174907*G0_2_1_0 + 0.00784992784992779*G0_3_0_1 - 0.00784992784992779*G0_3_1_0 + 0.00542568542568558*G0_4_0_1 - 0.00542568542568557*G0_4_1_0 - 0.0778499278499276*G0_5_0_1 + 0.0778499278499276*G0_5_1_0 + 0.0236652236652236*G0_6_0_1 - 0.0236652236652236*G0_6_1_0 - 0.18059163059163*G0_7_0_1 + 0.18059163059163*G0_7_1_0 + 0.0819624819624817*G0_8_0_1 - 0.0819624819624817*G0_8_1_0 - 0.0471861471861472*G0_9_0_1 + 0.0471861471861472*G0_9_1_0;
    A[10] = A[105] + 0.214381914381914*G0_0_0_0 - 0.214381914381913*G0_0_1_1 + 0.0328427128427128*G0_1_0_0 + 0.0269376302709635*G0_1_0_1 + 0.0144572711239378*G0_1_1_0 + 0.00855218855218852*G0_1_1_1 - 0.00855218855218851*G0_2_0_0 - 0.0269376302709636*G0_2_0_1 - 0.0144572711239377*G0_2_1_0 - 0.0328427128427128*G0_2_1_1 + 0.0850937950937945*G0_3_0_0 + 0.0905194805194799*G0_3_0_1 + 0.0929437229437222*G0_3_1_0 + 0.0983694083694076*G0_3_1_1 - 0.0983694083694079*G0_4_0_0 - 0.0905194805194801*G0_4_0_1 - 0.0929437229437224*G0_4_1_0 - 0.0850937950937946*G0_4_1_1 + 0.219841269841269*G0_5_0_0 + 0.0392496392496394*G0_5_0_1 + 0.141991341991341*G0_5_1_0 - 0.0386002886002883*G0_5_1_1 - 0.12041847041847*G0_6_0_0 - 0.0384559884559885*G0_6_0_1 - 0.0967532467532464*G0_6_1_0 - 0.014790764790765*G0_6_1_1 + 0.0386002886002888*G0_7_0_0 - 0.0392496392496388*G0_7_0_1 - 0.141991341991341*G0_7_1_0 - 0.219841269841269*G0_7_1_1 + 0.0147907647907644*G0_8_0_0 + 0.0384559884559881*G0_8_0_1 + 0.096753246753246*G0_8_1_0 + 0.12041847041847*G0_8_1_1 + 0.0471861471861473*G0_9_0_0 - 0.0471861471861473*G0_9_1_1;
    A[150] = A[10] + 0.214381914381914*G0_0_0_1 - 0.214381914381914*G0_0_1_0 + 0.00590508257174918*G0_1_0_1 - 0.00590508257174918*G0_1_1_0 + 0.0183854417187749*G0_2_0_1 - 0.0183854417187749*G0_2_1_0 - 0.00542568542568549*G0_3_0_1 + 0.00542568542568547*G0_3_1_0 - 0.00784992784992785*G0_4_0_1 + 0.00784992784992785*G0_4_1_0 + 0.18059163059163*G0_5_0_1 - 0.18059163059163*G0_5_1_0 - 0.0819624819624815*G0_6_0_1 + 0.0819624819624815*G0_6_1_0 + 0.0778499278499276*G0_7_0_1 - 0.0778499278499276*G0_7_1_0 - 0.0236652236652238*G0_8_0_1 + 0.0236652236652238*G0_8_1_0 + 0.0471861471861472*G0_9_0_1 - 0.0471861471861472*G0_9_1_0;
    A[173] = -0.00205226871893538*G0_0_0_0 + 0.0107744107744109*G0_0_0_1 + 0.00482283148949811*G0_0_1_0 - 0.00205226871893547*G0_0_1_1 + 0.0126727593394258*G0_1_0_0 + 0.00477152477152437*G0_1_0_1 + 0.0174442841109504*G0_1_1_0 + 0.00477152477152473*G0_2_0_1 + 0.0174442841109506*G0_2_1_0 + 0.0126727593394258*G0_2_1_1 - 0.00184704184704187*G0_3_0_0 + 0.0106204906204905*G0_3_1_0 + 0.0217027417027416*G0_3_1_1 + 0.0217027417027416*G0_4_0_0 + 0.0106204906204906*G0_4_1_0 - 0.00184704184704174*G0_4_1_1 + 0.000923520923520865*G0_5_0_0 - 0.00600288600288565*G0_5_0_1 - 0.0106204906204905*G0_5_1_0 + 0.00184704184704181*G0_5_1_1 - 0.0217027417027414*G0_6_0_0 + 0.0466378066378063*G0_6_0_1 + 0.0217027417027415*G0_6_1_0 - 0.0124675324675324*G0_6_1_1 + 0.00184704184704181*G0_7_0_0 - 0.00600288600288576*G0_7_0_1 - 0.0106204906204904*G0_7_1_0 + 0.000923520923520999*G0_7_1_1 - 0.0124675324675322*G0_8_0_0 + 0.0466378066378062*G0_8_0_1 + 0.0217027417027412*G0_8_1_0 - 0.021702741702742*G0_8_1_1 + 0.00092352092352103*G0_9_0_0 + 0.0184704184704183*G0_9_1_0 + 0.000923520923520826*G0_9_1_1;
    A[170] = -A[173] - 0.00312970979637637*G0_0_0_1 - 0.016264229597563*G0_0_1_1 - 0.127086740420074*G0_1_0_1 - 0.201122334455668*G0_1_1_1 + 0.00205226871893527*G0_2_1_1 + 0.0230880230880228*G0_3_0_1 + 0.0678787878787875*G0_3_1_1 - 0.0249350649350648*G0_4_0_1 + 0.00184704184704205*G0_4_1_1 + 0.0138528138528143*G0_5_0_1 + 0.00323232323232313*G0_5_1_1 + 0.0249350649350646*G0_6_0_1 - 0.0249350649350647*G0_6_1_1 + 0.0327849927849931*G0_7_0_1 + 0.0692640692640691*G0_7_1_1 + 0.0974314574314565*G0_8_0_1 - 0.243347763347763*G0_8_1_1 - 0.0369408369408371*G0_9_0_1 + 0.00277056277056261*G0_9_1_1;
    A[86] = A[170] + 0.00908128908128915*G0_0_0_1 - 0.00908128908128915*G0_0_1_0 + 0.114413981080648*G0_1_0_1 - 0.114413981080648*G0_1_1_0 - 0.0126727593394258*G0_2_0_1 + 0.0126727593394258*G0_2_1_0 - 0.0337085137085133*G0_3_0_1 + 0.0337085137085133*G0_3_1_0 + 0.0143145743145741*G0_4_0_1 - 0.0143145743145741*G0_4_1_0 - 0.00923520923520938*G0_5_0_1 + 0.00923520923520939*G0_5_1_0 - 0.0281673881673884*G0_7_0_1 + 0.0281673881673884*G0_7_1_0 - 0.0724963924963914*G0_8_0_1 + 0.0724963924963914*G0_8_1_0 + 0.0184704184704187*G0_9_0_1 - 0.0184704184704187*G0_9_1_0;
    A[129] = -A[86] - 0.0106204906204906*G0_0_0_0 + 0.105281385281385*G0_0_1_0 - 0.0787045053711717*G0_0_1_1 - 0.0106204906204905*G0_1_0_0 - 0.010569183902517*G0_1_0_1 - 0.115901875901876*G0_1_1_0 - 0.194555074555074*G0_1_1_1 + 0.000974827641494223*G0_2_1_1 + 0.000923520923521159*G0_3_0_0 - 0.0221645021645019*G0_3_0_1 + 0.00230880230880232*G0_3_1_0 + 0.0161616161616162*G0_3_1_1 + 0.0327849927849927*G0_4_0_1 + 0.0184704184704183*G0_4_1_0 + 0.0563347763347762*G0_4_1_1 + 0.000923520923521031*G0_5_0_0 + 0.0230880230880229*G0_5_0_1 - 0.00138528138528107*G0_5_1_0 + 0.036940836940837*G0_5_1_1 - 0.0327849927849927*G0_6_0_1 - 0.0184704184704186*G0_6_1_0 + 0.00507936507936499*G0_6_1_1 + 0.0106204906204904*G0_7_0_0 + 0.0447907647907641*G0_7_0_1 + 0.000461760461760885*G0_7_1_0 - 0.169927849927849*G0_7_1_1 + 0.0106204906204905*G0_8_0_0 - 0.0341702741702735*G0_8_0_1 + 0.0101587301587298*G0_8_1_0 - 0.204559884559884*G0_8_1_1 - 0.001847041847042*G0_9_0_0 - 0.000923520923520816*G0_9_0_1 - 0.000923520923520958*G0_9_1_0 + 0.0581818181818181*G0_9_1_1;
    A[51] = -A[173] - 0.0115953182619849*G0_0_0_0 + 0.0186756453423122*G0_0_0_1 + 0.0106204906204906*G0_0_1_1 + 0.00312970979637627*G0_1_0_0 - 0.0197017797017794*G0_2_0_0 - 0.00805515472182135*G0_2_0_1 + 0.0105691839025172*G0_2_1_0 + 0.0106204906204906*G0_2_1_1 - 0.104357864357864*G0_3_0_0 - 0.0683405483405479*G0_3_0_1 - 0.0327849927849929*G0_3_1_0 + 0.041096681096681*G0_4_0_0 + 0.00692640692640666*G0_4_0_1 + 0.0221645021645022*G0_4_1_0 - 0.000923520923520757*G0_4_1_1 - 0.101587301587301*G0_5_0_0 - 0.0651082251082241*G0_5_0_1 - 0.0447907647907646*G0_5_1_0 - 0.0106204906204906*G0_5_1_1 - 0.00230880230880199*G0_6_0_0 + 0.054487734487734*G0_6_0_1 + 0.0341702741702739*G0_6_1_0 - 0.0106204906204905*G0_6_1_1 + 0.0110822510822511*G0_7_0_0 - 0.00784992784992745*G0_7_0_1 - 0.0230880230880229*G0_7_1_0 - 0.000923520923520757*G0_7_1_1 - 0.00323232323232306*G0_8_0_0 + 0.0683405483405478*G0_8_0_1 + 0.0327849927849926*G0_8_1_0 - 0.0156998556998556*G0_9_0_0 + 0.000923520923520891*G0_9_0_1 + 0.000923520923520819*G0_9_1_0 + 0.0018470418470418*G0_9_1_1;
    A[193] = -A[51] - 0.0840404040404038*G0_0_0_0 - 0.0382748116081445*G0_0_0_1 - 0.0484848484848486*G0_0_1_0 - 0.101228154561487*G0_0_1_1 - 0.0840404040404039*G0_1_0_0 - 0.0355555555555554*G0_1_0_1 - 0.045765592432259*G0_1_1_0 - 0.0985088985088979*G0_1_1_1 - 0.0448420715087378*G0_2_0_1 + 0.044842071508738*G0_2_1_0 + 0.0182651915985249*G0_2_1_1 - 0.939220779220774*G0_3_0_0 - 1.00479076479076*G0_3_0_1 - 0.780375180375176*G0_3_1_0 - 0.847330447330442*G0_3_1_1 - 0.152380952380951*G0_4_0_0 - 0.0651082251082249*G0_4_0_1 - 0.226724386724385*G0_4_1_0 - 0.159769119769119*G0_4_1_1 - 0.939220779220774*G0_5_0_0 - 0.158845598845598*G0_5_0_1 + 0.065569985569985*G0_5_1_0 - 0.00138528138528136*G0_5_1_1 - 0.152380952380953*G0_6_0_0 + 0.0743434343434339*G0_6_0_1 - 0.0872727272727267*G0_6_1_0 - 0.0203174603174602*G0_6_1_1 - 0.0683405483405479*G0_7_0_0 - 0.0683405483405479*G0_7_0_1 + 0.24242424242424*G0_7_1_0 + 0.369408369408367*G0_7_1_1 - 0.0683405483405478*G0_8_0_0 - 0.31076479076479*G0_8_0_1 + 0.126984126984127*G0_8_1_1 - 1.77870129870129*G0_9_0_0 - 0.4811544011544*G0_9_0_1 - 1.29754689754689*G0_9_1_0 - 0.0988167388167392*G0_9_1_1;
    A[192] = A[193] + 0.323848003848002*G0_0_0_0 + 0.197017797017796*G0_0_0_1 + 0.194555074555074*G0_0_1_0 + 0.363251563251562*G0_0_1_1 + 0.148994708994709*G0_1_0_0 + 0.0504858104858104*G0_1_0_1 + 0.0480230880230882*G0_1_1_0 + 0.177316017316017*G0_1_1_1 + 0.0591053391053388*G0_2_0_0 + 0.0517171717171715*G0_2_0_1 - 0.0320153920153916*G0_2_1_0 + 0.054179894179894*G0_2_1_1 + 1.28554112554112*G0_3_0_0 + 1.44069264069263*G0_3_0_1 + 1.24121212121211*G0_3_1_0 + 1.27445887445887*G0_3_1_1 + 0.620606060606057*G0_4_0_0 + 0.576277056277054*G0_4_0_1 + 0.742510822510819*G0_4_1_0 + 0.609523809523807*G0_4_1_1 + 2.70406926406925*G0_5_0_0 + 0.0664935064935064*G0_5_0_1 - 0.132987012987013*G0_5_1_0 + 0.299220779220777*G0_5_1_1 + 0.177316017316019*G0_6_0_0 + 0.166233766233766*G0_6_1_0 + 0.387878787878786*G0_7_0_0 + 0.033246753246753*G0_7_0_1 - 0.288138528138526*G0_7_1_0 + 1.49610389610389*G0_7_1_1 + 0.0554112554112546*G0_8_0_0 + 0.398961038961037*G0_8_0_1 + 0.0775757575757573*G0_8_1_0 - 0.0997402597402606*G0_8_1_1 + 3.98961038961038*G0_9_0_0 + 2.06129870129869*G0_9_0_1 + 2.85922077922077*G0_9_1_0 + 2.32727272727272*G0_9_1_1;
    A[208] = -A[193] + 0.00861952861952895*G0_0_0_1 + 0.0110822510822509*G0_0_1_0 + 0.174853294853294*G0_1_0_0 + 0.0677248677248673*G0_1_0_1 + 0.0701875901875895*G0_1_1_0 + 0.0985088985088975*G0_1_1_1 + 0.0985088985088978*G0_2_0_0 + 0.0270899470899469*G0_2_0_1 + 0.11082251082251*G0_2_1_0 + 0.134218374218373*G0_2_1_1 + 1.03064935064934*G0_3_0_0 + 0.964155844155839*G0_3_0_1 + 1.16363636363636*G0_3_1_0 + 1.41852813852813*G0_3_1_1 - 0.166233766233765*G0_4_0_0 - 0.132987012987012*G0_4_0_1 - 0.299220779220777*G0_4_1_0 - 0.310303030303028*G0_4_1_1 - 0.387878787878786*G0_5_0_0 - 0.155151515151515*G0_5_0_1 + 0.0443290043290043*G0_5_1_0 - 0.0997402597402591*G0_5_1_1 + 0.277056277056276*G0_6_0_0 + 0.0110822510822515*G0_6_0_1 - 0.155151515151514*G0_6_1_0 - 0.132987012987012*G0_6_1_1 - 0.0997402597402594*G0_7_0_0 - 0.155151515151515*G0_7_0_1 + 0.166233766233764*G0_7_1_0 + 0.22164502164502*G0_7_1_1 + 0.232727272727272*G0_8_0_0 + 0.0110822510822509*G0_8_0_1 + 0.332467532467531*G0_8_1_0 + 2.34943722943722*G0_8_1_1 + 0.465454545454544*G0_9_0_0 + 0.166233766233766*G0_9_0_1 - 0.631688311688309*G0_9_1_0 + 1.19688311688311*G0_9_1_1;
    A[50] = -A[170] + 0.0162642295975629*G0_0_0_0 - 0.0348372615039282*G0_0_0_1 - 0.0020522687189353*G0_1_0_0 - 0.127240660573994*G0_1_0_1 + 0.201122334455667*G0_2_0_0 - 0.000153920153920282*G0_2_0_1 - 0.00184704184704143*G0_3_0_0 - 0.12005772005772*G0_3_0_1 - 0.0678787878787879*G0_4_0_0 - 0.168080808080807*G0_4_0_1 - 0.0692640692640688*G0_5_0_0 + 0.0715728715728717*G0_5_0_1 + 0.243347763347762*G0_6_0_0 - 0.0447907647907649*G0_6_0_1 - 0.00323232323232314*G0_7_0_0 + 0.0905050505050506*G0_7_0_1 + 0.0249350649350646*G0_8_0_0 + 0.0277056277056269*G0_8_0_1 - 0.00277056277056297*G0_9_0_0 - 0.236421356421356*G0_9_0_1;
    A[222] = A[193] - 0.0394035594035593*G0_0_0_0 + 0.0394035594035583*G0_0_1_1 + 0.0948148148148145*G0_1_0_0 - 0.0012313612313615*G0_1_0_1 + 0.0800384800384798*G0_1_1_0 + 0.118210678210677*G0_1_1_1 - 0.118210678210678*G0_2_0_0 + 0.00123136123136062*G0_2_0_1 - 0.0800384800384799*G0_2_1_0 - 0.0948148148148146*G0_2_1_1 + 0.676017316017312*G0_3_0_0 + 0.864415584415579*G0_3_0_1 + 0.498701298701296*G0_3_1_0 + 0.653852813852811*G0_3_1_1 - 0.653852813852812*G0_4_0_0 - 0.864415584415582*G0_4_0_1 - 0.498701298701297*G0_4_1_0 - 0.676017316017313*G0_4_1_1 + 1.20796536796536*G0_5_0_0 + 0.0332467532467541*G0_5_0_1 + 0.155151515151516*G0_5_1_0 - 0.0886580086580076*G0_5_1_1 + 0.277056277056278*G0_6_0_0 - 0.398961038961038*G0_6_0_1 + 0.0886580086580075*G0_6_1_0 - 0.0554112554112558*G0_6_1_1 + 0.0886580086580084*G0_7_0_0 - 0.0332467532467545*G0_7_0_1 - 0.155151515151513*G0_7_1_0 - 1.20796536796536*G0_7_1_1 + 0.055411255411255*G0_8_0_0 + 0.398961038961038*G0_8_0_1 - 0.0886580086580083*G0_8_1_0 - 0.277056277056276*G0_8_1_1 + 1.66233766233766*G0_9_0_0 - 1.66233766233766*G0_9_1_1;
    A[143] = A[129] + 0.114413981080647*G0_0_0_1 - 0.114413981080647*G0_0_1_0 + 0.00908128908128899*G0_1_0_1 - 0.00908128908128899*G0_1_1_0 - 0.012672759339426*G0_2_0_1 + 0.0126727593394259*G0_2_1_0 - 0.00923520923520906*G0_3_0_1 + 0.00923520923520906*G0_3_1_0 - 0.0337085137085134*G0_5_0_1 + 0.0337085137085134*G0_5_1_0 + 0.0143145743145743*G0_6_0_1 - 0.0143145743145743*G0_6_1_0 - 0.0724963924963916*G0_7_0_1 + 0.0724963924963916*G0_7_1_0 - 0.0281673881673881*G0_8_0_1 + 0.0281673881673881*G0_8_1_0 + 0.0184704184704186*G0_9_0_1 - 0.0184704184704186*G0_9_1_0;
    A[207] = A[193] + 0.00246272246272195*G0_0_0_1 - 0.00246272246272194*G0_0_1_0 + 0.00246272246272223*G0_1_0_1 - 0.00246272246272221*G0_1_1_0 + 0.0837325637325631*G0_2_0_1 - 0.0837325637325631*G0_2_1_0 + 0.199480519480518*G0_3_0_1 - 0.199480519480518*G0_3_1_0 - 0.166233766233765*G0_4_0_1 + 0.166233766233765*G0_4_1_0 + 0.199480519480519*G0_5_0_1 - 0.199480519480519*G0_5_1_0 - 0.166233766233765*G0_6_0_1 + 0.166233766233765*G0_6_1_0 + 0.321385281385279*G0_7_0_1 - 0.321385281385279*G0_7_1_0 + 0.32138528138528*G0_8_0_1 - 0.32138528138528*G0_8_1_0 - 0.797922077922075*G0_9_0_1 + 0.797922077922075*G0_9_1_0;
    A[194] = A[222] + 0.00246272246272274*G0_0_0_1 - 0.00246272246272274*G0_0_1_0 + 0.0837325637325635*G0_1_0_1 - 0.0837325637325635*G0_1_1_0 + 0.0024627224627226*G0_2_0_1 - 0.00246272246272259*G0_2_1_0 - 0.166233766233765*G0_3_0_1 + 0.166233766233765*G0_3_1_0 + 0.19948051948052*G0_4_0_1 - 0.19948051948052*G0_4_1_0 + 0.32138528138528*G0_5_0_1 - 0.32138528138528*G0_5_1_0 + 0.32138528138528*G0_6_0_1 - 0.32138528138528*G0_6_1_0 + 0.19948051948052*G0_7_0_1 - 0.19948051948052*G0_7_1_0 - 0.166233766233766*G0_8_0_1 + 0.166233766233766*G0_8_1_0 - 0.797922077922074*G0_9_0_1 + 0.797922077922074*G0_9_1_0;
    A[78] = -A[86] + 0.0162642295975629*G0_0_0_0 - 0.0348372615039282*G0_0_1_0 - 0.0020522687189353*G0_1_0_0 - 0.127240660573994*G0_1_1_0 + 0.201122334455667*G0_2_0_0 - 0.000153920153920281*G0_2_1_0 - 0.00184704184704144*G0_3_0_0 - 0.12005772005772*G0_3_1_0 - 0.0678787878787879*G0_4_0_0 - 0.168080808080807*G0_4_1_0 - 0.0692640692640688*G0_5_0_0 + 0.0715728715728717*G0_5_1_0 + 0.243347763347762*G0_6_0_0 - 0.0447907647907648*G0_6_1_0 - 0.00323232323232314*G0_7_0_0 + 0.0905050505050505*G0_7_1_0 + 0.0249350649350646*G0_8_0_0 + 0.0277056277056268*G0_8_1_0 - 0.00277056277056297*G0_9_0_0 - 0.236421356421356*G0_9_1_0;
    A[138] = -A[78] + 0.0258072791406125*G0_0_0_0 + 0.0116466249799583*G0_0_0_1 - 0.0267821067821069*G0_0_1_0 + 0.00359147025813684*G0_0_1_1 - 0.0538720538720536*G0_1_0_0 - 0.166233766233766*G0_1_0_1 - 0.0646464646464643*G0_1_1_0 + 0.20768959435626*G0_2_0_0 + 0.00805515472182095*G0_2_0_1 + 0.00430976430976431*G0_2_1_0 - 0.00359147025813696*G0_2_1_1 - 0.24196248196248*G0_3_0_0 - 0.189321789321788*G0_3_0_1 - 0.415584415584414*G0_3_1_0 - 0.267821067821066*G0_3_1_1 - 0.0290909090909094*G0_4_0_0 + 0.0683405483405477*G0_4_0_1 - 0.113593073593073*G0_4_1_0 + 0.0646464646464638*G0_4_1_1 - 0.0156998556998556*G0_5_0_0 - 0.0013852813852811*G0_5_0_1 + 0.060952380952381*G0_5_1_0 - 0.0138528138528137*G0_5_1_1 + 0.19163059163059*G0_6_0_0 + 0.0124675324675321*G0_6_0_1 - 0.0415584415584415*G0_6_1_0 + 0.0138528138528137*G0_6_1_1 + 0.0161616161616163*G0_7_0_0 + 0.00369408369408409*G0_7_0_1 + 0.0803463203463203*G0_7_1_0 - 0.0646464646464644*G0_7_1_1 + 0.0480230880230877*G0_8_0_0 + 0.0784992784992775*G0_8_0_1 + 0.267821067821067*G0_8_1_1 + 0.0544877344877341*G0_9_0_0 + 0.0387878787878784*G0_9_0_1 - 0.160692640692641*G0_9_1_0;
    A[144] = -A[138] + 0.539028379028378*G0_0_0_0 - 0.10399871733205*G0_0_0_1 - 0.116671476671476*G0_0_1_0 + 0.118672438672438*G0_0_1_1 + 0.029603976270643*G0_1_0_0 - 0.117287157287157*G0_1_0_1 - 0.00287317620650926*G0_1_1_0 - 0.0829116562449891*G0_1_1_1 + 0.0712137245470576*G0_2_0_0 + 0.0154946288279621*G0_2_0_1 + 0.0245759179092512*G0_2_1_0 + 0.0504345037678369*G0_2_1_1 - 0.0591053391053387*G0_3_0_0 - 0.00923520923520943*G0_3_0_1 - 0.0817316017316014*G0_3_1_0 - 0.0470995670995669*G0_3_1_1 - 0.0355555555555558*G0_4_0_0 + 0.00507936507936509*G0_4_0_1 - 0.0230880230880231*G0_4_1_0 - 0.012005772005772*G0_4_1_1 + 0.523636363636361*G0_5_0_0 + 0.296911976911975*G0_5_1_1 - 0.252582972582971*G0_6_0_0 - 0.0447907647907645*G0_6_0_1 - 0.0540259740259736*G0_6_1_0 - 0.193477633477632*G0_6_1_1 + 0.470072150072148*G0_7_0_0 + 0.305223665223664*G0_7_0_1 + 0.319538239538238*G0_7_1_0 + 0.931832611832607*G0_7_1_1 + 0.0346320346320342*G0_8_0_0 + 0.178239538239537*G0_8_0_1 + 0.144531024531024*G0_8_1_0 - 0.0563347763347763*G0_8_1_1 + 0.372178932178931*G0_9_0_0 + 0.313073593073592*G0_9_0_1 + 0.33154401154401*G0_9_1_0 + 0.483924963924962*G0_9_1_1;
    A[146] = -A[138] + 0.201276254609588*G0_0_0_0 + 0.00015392015392003*G0_0_1_0 + 0.125188391855058*G0_1_0_0 + 0.127240660573993*G0_1_1_0 + 0.051101491101491*G0_2_0_0 + 0.0348372615039281*G0_2_1_0 - 0.00277056277056262*G0_3_0_0 - 0.0277056277056279*G0_3_1_0 - 0.0937373737373735*G0_4_0_0 - 0.0905050505050501*G0_4_1_0 + 0.288138528138526*G0_5_0_0 + 0.0447907647907647*G0_5_1_0 - 0.14083694083694*G0_6_0_0 - 0.0715728715728711*G0_6_1_0 + 0.10020202020202*G0_7_0_0 + 0.168080808080807*G0_7_1_0 + 0.118210678210678*G0_8_0_0 + 0.120057720057719*G0_8_1_0 + 0.233650793650793*G0_9_0_0 + 0.236421356421356*G0_9_1_0;
    A[126] = A[146] - 0.179060445727112*G0_0_0_0 + 0.179060445727112*G0_0_1_1 - 0.175468975468975*G0_1_0_0 - 0.174288920955587*G0_1_0_1 - 0.161359628026294*G0_1_1_0 - 0.156588103254769*G0_1_1_1 + 0.156588103254768*G0_2_0_0 + 0.174288920955587*G0_2_0_1 + 0.161359628026293*G0_2_1_0 + 0.175468975468975*G0_2_1_1 - 0.303838383838382*G0_3_0_0 - 0.257662337662336*G0_3_0_1 - 0.364790764790762*G0_3_1_0 - 0.33246753246753*G0_3_1_1 + 0.33246753246753*G0_4_0_0 + 0.257662337662336*G0_4_0_1 + 0.364790764790763*G0_4_1_0 + 0.303838383838382*G0_4_1_1 - 0.239191919191918*G0_5_0_0 - 0.00507936507936483*G0_5_0_1 + 0.103896103896103*G0_5_1_0 + 0.0701875901875897*G0_5_1_1 + 0.0646464646464637*G0_6_0_0 - 0.0660317460317459*G0_6_0_1 + 0.150072150072149*G0_6_1_0 + 0.084040404040404*G0_6_1_1 - 0.0701875901875899*G0_7_0_0 + 0.00507936507936545*G0_7_0_1 - 0.103896103896103*G0_7_1_0 + 0.239191919191918*G0_7_1_1 - 0.0840404040404037*G0_8_0_0 + 0.0660317460317454*G0_8_0_1 - 0.150072150072149*G0_8_1_0 - 0.0646464646464645*G0_8_1_1 - 0.179163059163059*G0_9_0_0 + 0.179163059163059*G0_9_1_1;
    A[54] = A[138] - 0.0126727593394261*G0_0_0_1 + 0.0126727593394261*G0_0_1_0 + 0.114413981080648*G0_1_0_1 - 0.114413981080648*G0_1_1_0 + 0.00908128908128913*G0_2_0_1 - 0.00908128908128913*G0_2_1_0 - 0.0724963924963919*G0_3_0_1 + 0.072496392496392*G0_3_1_0 - 0.0281673881673882*G0_4_0_1 + 0.0281673881673882*G0_4_1_0 - 0.0092352092352091*G0_6_0_1 + 0.00923520923520909*G0_6_1_0 + 0.0143145743145741*G0_7_0_1 - 0.0143145743145741*G0_7_1_0 - 0.0337085137085133*G0_8_0_1 + 0.0337085137085134*G0_8_1_0 + 0.0184704184704184*G0_9_0_1 - 0.0184704184704184*G0_9_1_0;
    A[174] = -A[54] + 0.201276254609588*G0_0_0_0 + 0.000153920153920023*G0_0_0_1 + 0.125188391855058*G0_1_0_0 + 0.127240660573993*G0_1_0_1 + 0.0511014911014909*G0_2_0_0 + 0.0348372615039281*G0_2_0_1 - 0.00277056277056262*G0_3_0_0 - 0.0277056277056279*G0_3_0_1 - 0.0937373737373735*G0_4_0_0 - 0.0905050505050501*G0_4_0_1 + 0.288138528138526*G0_5_0_0 + 0.0447907647907647*G0_5_0_1 - 0.14083694083694*G0_6_0_0 - 0.0715728715728712*G0_6_0_1 + 0.10020202020202*G0_7_0_0 + 0.168080808080807*G0_7_0_1 + 0.118210678210678*G0_8_0_0 + 0.120057720057719*G0_8_0_1 + 0.233650793650793*G0_9_0_0 + 0.236421356421356*G0_9_0_1;
    A[98] = A[126] + 0.0128266794933462*G0_0_0_1 - 0.0128266794933462*G0_0_1_0 + 0.025755972422639*G0_1_0_1 - 0.025755972422639*G0_1_1_0 + 0.0128266794933458*G0_2_0_1 - 0.0128266794933457*G0_2_1_0 - 0.0623376623376619*G0_3_0_1 + 0.0623376623376619*G0_3_1_0 + 0.0447907647907645*G0_4_0_1 - 0.0447907647907645*G0_4_1_0 + 0.153766233766233*G0_5_0_1 - 0.153766233766233*G0_5_1_0 + 0.153766233766233*G0_6_0_1 - 0.153766233766233*G0_6_1_0 + 0.0447907647907649*G0_7_0_1 - 0.0447907647907649*G0_7_1_0 - 0.0623376623376622*G0_8_0_1 + 0.0623376623376622*G0_8_1_0 + 0.217950937950937*G0_9_0_1 - 0.217950937950937*G0_9_1_0;
    A[95] = -A[98] + 0.000153920153920376*G0_0_0_1 + 0.201276254609587*G0_0_1_1 + 0.0348372615039282*G0_1_0_1 + 0.051101491101491*G0_1_1_1 + 0.127240660573993*G0_2_0_1 + 0.125188391855058*G0_2_1_1 - 0.0905050505050497*G0_3_0_1 - 0.0937373737373732*G0_3_1_1 - 0.0277056277056277*G0_4_0_1 - 0.00277056277056226*G0_4_1_1 + 0.168080808080807*G0_5_0_1 + 0.100202020202019*G0_5_1_1 + 0.12005772005772*G0_6_0_1 + 0.118210678210678*G0_6_1_1 + 0.0447907647907651*G0_7_0_1 + 0.288138528138527*G0_7_1_1 - 0.0715728715728711*G0_8_0_1 - 0.14083694083694*G0_8_1_1 + 0.236421356421356*G0_9_0_1 + 0.233650793650793*G0_9_1_1;
    A[118] = A[202] + 0.00777296777296755*G0_0_0_1 - 0.00777296777296755*G0_0_1_0 - 0.007772967772968*G0_2_0_1 + 0.007772967772968*G0_2_1_0 - 0.0439826839826843*G0_3_0_1 + 0.0439826839826843*G0_3_1_0 + 0.0287445887445887*G0_4_0_1 - 0.0287445887445887*G0_4_1_0 + 0.244155844155843*G0_5_0_1 - 0.244155844155843*G0_5_1_0 - 0.244155844155843*G0_6_0_1 + 0.244155844155843*G0_6_1_0 - 0.0287445887445889*G0_7_0_1 + 0.0287445887445889*G0_7_1_0 + 0.043982683982683*G0_8_0_1 - 0.043982683982683*G0_8_1_0;
    A[200] = A[88] + 0.0204200737534071*G0_0_0_1 - 0.0204200737534071*G0_0_1_0 + 0.00954304954304951*G0_1_0_1 - 0.0095430495430495*G0_1_1_0 - 0.0548981882315205*G0_2_0_1 + 0.0548981882315205*G0_2_1_0 + 0.140836940836941*G0_3_0_1 - 0.140836940836941*G0_3_1_0 - 0.0143145743145735*G0_4_0_1 + 0.0143145743145735*G0_4_1_0 - 0.0457142857142862*G0_5_0_1 + 0.0457142857142862*G0_5_1_0 + 0.00969696969697045*G0_6_0_1 - 0.00969696969697045*G0_6_1_0 - 0.0494083694083696*G0_7_0_1 + 0.0494083694083696*G0_7_1_0 - 0.0272438672438663*G0_8_0_1 + 0.0272438672438662*G0_8_1_0 + 0.0110822510822516*G0_9_0_1 - 0.0110822510822516*G0_9_1_0;
    A[22] = A[21] - 0.0186644219977553*G0_0_0_0 + 0.02993265993266*G0_0_0_1 + 0.00396825396825358*G0_1_0_0 - 0.0151451018117684*G0_2_0_0 - 0.00753727753727751*G0_2_0_1 + 0.00115440115440115*G0_3_0_0 + 0.00598845598845584*G0_4_0_0 + 0.00316017316017299*G0_4_0_1 - 0.0428860028860025*G0_5_0_0 - 0.0515295815295809*G0_5_0_1 + 0.0608225108225106*G0_6_0_0 + 0.029134199134199*G0_6_0_1 + 0.0132178932178933*G0_7_0_0 - 0.00477633477633444*G0_7_0_1 - 0.00115440115440147*G0_8_0_0 - 0.00730158730158734*G0_9_0_0 + 0.00161616161616165*G0_9_0_1;
    A[60] = A[22] + 0.00361071027737679*G0_0_0_0 - 0.0095206028539364*G0_0_0_1 - 0.00183581850248547*G0_0_1_0 - 0.00183581850248555*G0_0_1_1 - 0.00361071027737661*G0_1_0_0 - 0.00544652877986184*G0_1_0_1 - 0.0131313131313132*G0_1_1_0 - 0.0131313131313132*G0_1_1_1 - 0.00544652877986218*G0_2_0_1 - 0.00544652877986214*G0_2_1_0 - 0.00544652877986215*G0_2_1_1 + 0.0286868686868684*G0_3_0_0 + 0.0246464646464644*G0_3_0_1 + 0.0536075036075031*G0_3_1_0 + 0.053607503607503*G0_3_1_1 + 0.0430591630591627*G0_4_0_0 + 0.0488888888888884*G0_4_0_1 + 0.0194516594516594*G0_4_1_0 + 0.0194516594516594*G0_4_1_1 - 0.0286868686868685*G0_5_0_0 + 0.0249206349206346*G0_5_0_1 - 0.00404040404040413*G0_5_1_0 - 0.00404040404040415*G0_5_1_1 - 0.0430591630591629*G0_6_0_0 - 0.0236075036075036*G0_6_0_1 + 0.00582972582972578*G0_6_1_0 + 0.00582972582972583*G0_6_1_1 - 0.00987012987013006*G0_7_0_0 + 0.000678210678210352*G0_7_0_1 - 0.00923520923520934*G0_7_1_0 - 0.0092352092352094*G0_7_1_1 + 0.0098701298701301*G0_8_0_0 + 0.000634920634920886*G0_8_0_1 + 0.0105483405483405*G0_8_1_0 + 0.0105483405483405*G0_8_1_1 - 0.0134199134199135*G0_9_0_1 - 0.0134199134199135*G0_9_1_0 - 0.0134199134199135*G0_9_1_1;
    A[4] = A[60] - 0.0076847843514511*G0_1_0_1 + 0.0076847843514511*G0_1_1_0 + 0.00768478435145108*G0_2_0_1 - 0.00768478435145108*G0_2_1_0 + 0.0341558441558439*G0_3_0_1 - 0.0341558441558439*G0_3_1_0 - 0.0341558441558436*G0_4_0_1 + 0.0341558441558436*G0_4_1_0 + 0.00519480519480504*G0_5_0_1 - 0.00519480519480504*G0_5_1_0 - 0.00471861471861453*G0_6_0_1 + 0.00471861471861453*G0_6_1_0 - 0.0051948051948052*G0_7_0_1 + 0.0051948051948052*G0_7_1_0 + 0.00471861471861467*G0_8_0_1 - 0.00471861471861467*G0_8_1_0;
    A[106] = A[22] - 0.00768478435145107*G0_0_0_1 + 0.00768478435145107*G0_0_1_0 + 0.00768478435145105*G0_2_0_1 - 0.00768478435145105*G0_2_1_0 + 0.00519480519480517*G0_3_0_1 - 0.00519480519480517*G0_3_1_0 - 0.00471861471861457*G0_4_0_1 + 0.00471861471861458*G0_4_1_0 + 0.0341558441558437*G0_5_0_1 - 0.0341558441558437*G0_5_1_0 - 0.0341558441558439*G0_6_0_1 + 0.0341558441558439*G0_6_1_0 + 0.00471861471861449*G0_7_0_1 - 0.00471861471861449*G0_7_1_0 - 0.00519480519480494*G0_8_0_1 + 0.00519480519480494*G0_8_1_0;
    A[91] = A[106] + 0.0186644219977553*G0_0_0_0 - 0.02993265993266*G0_0_1_0 - 0.00396825396825358*G0_1_0_0 + 0.0151451018117684*G0_2_0_0 + 0.00753727753727751*G0_2_1_0 - 0.00115440115440115*G0_3_0_0 - 0.00598845598845584*G0_4_0_0 - 0.00316017316017299*G0_4_1_0 + 0.0428860028860025*G0_5_0_0 + 0.0515295815295809*G0_5_1_0 - 0.0608225108225106*G0_6_0_0 - 0.029134199134199*G0_6_1_0 - 0.0132178932178933*G0_7_0_0 + 0.00477633477633443*G0_7_1_0 + 0.00115440115440147*G0_8_0_0 + 0.00730158730158733*G0_9_0_0 - 0.00161616161616164*G0_9_1_0;
    A[9] = A[135] + 0.38524931858265*G0_0_0_1 - 0.38524931858265*G0_0_1_0 + 0.0276735610068942*G0_1_0_1 - 0.0276735610068942*G0_1_1_0 + 0.0276735610068942*G0_2_0_1 - 0.0276735610068942*G0_2_1_0 - 0.0086580086580087*G0_3_0_1 + 0.0086580086580087*G0_3_1_0 - 0.00865800865800874*G0_4_0_1 + 0.00865800865800874*G0_4_1_0 + 0.275036075036074*G0_5_0_1 - 0.275036075036074*G0_5_1_0 - 0.124098124098123*G0_6_0_1 + 0.124098124098123*G0_6_1_0 + 0.275036075036074*G0_7_0_1 - 0.275036075036074*G0_7_1_0 - 0.124098124098124*G0_8_0_1 + 0.124098124098124*G0_8_1_0 + 0.0536796536796538*G0_9_0_1 - 0.0536796536796538*G0_9_1_0;
    A[90] = A[9] + 0.38524931858265*G0_0_0_0 - 0.38524931858265*G0_0_1_1 + 0.0323360590027255*G0_1_0_0 + 0.00466249799583127*G0_1_0_1 + 0.00466249799583131*G0_1_1_0 - 0.0230110630110629*G0_1_1_1 + 0.0230110630110629*G0_2_0_0 - 0.00466249799583136*G0_2_0_1 - 0.00466249799583131*G0_2_1_0 - 0.0323360590027255*G0_2_1_1 + 0.031226551226551*G0_3_0_0 + 0.0398845598845596*G0_3_0_1 + 0.0398845598845596*G0_3_1_0 + 0.0485425685425682*G0_3_1_1 - 0.0485425685425683*G0_4_0_0 - 0.0398845598845596*G0_4_0_1 - 0.0398845598845596*G0_4_1_0 - 0.0312265512265509*G0_4_1_1 + 0.35238095238095*G0_5_0_0 + 0.0773448773448767*G0_5_0_1 + 0.077344877344877*G0_5_1_0 - 0.197691197691197*G0_5_1_1 - 0.172871572871572*G0_6_0_0 - 0.0487734487734486*G0_6_0_1 - 0.0487734487734486*G0_6_1_0 + 0.0753246753246748*G0_6_1_1 + 0.197691197691197*G0_7_0_0 - 0.0773448773448771*G0_7_0_1 - 0.0773448773448769*G0_7_1_0 - 0.352380952380951*G0_7_1_1 - 0.0753246753246751*G0_8_0_0 + 0.0487734487734486*G0_8_0_1 + 0.0487734487734484*G0_8_1_0 + 0.172871572871572*G0_8_1_1 + 0.0536796536796538*G0_9_0_0 - 0.0536796536796538*G0_9_1_1;
    A[6] = A[90] - 0.38524931858265*G0_0_0_1 + 0.38524931858265*G0_0_1_0 - 0.0276735610068942*G0_1_0_1 + 0.0276735610068942*G0_1_1_0 - 0.0276735610068941*G0_2_0_1 + 0.0276735610068942*G0_2_1_0 + 0.00865800865800863*G0_3_0_1 - 0.00865800865800863*G0_3_1_0 + 0.00865800865800875*G0_4_0_1 - 0.00865800865800875*G0_4_1_0 - 0.275036075036073*G0_5_0_1 + 0.275036075036073*G0_5_1_0 + 0.124098124098123*G0_6_0_1 - 0.124098124098123*G0_6_1_0 - 0.275036075036074*G0_7_0_1 + 0.275036075036074*G0_7_1_0 + 0.124098124098124*G0_8_0_1 - 0.124098124098124*G0_8_1_0 - 0.0536796536796537*G0_9_0_1 + 0.0536796536796537*G0_9_1_0;
    A[34] = -A[37] - 0.0124803591470258*G0_0_1_0 + 0.0321661054994387*G0_0_1_1 + 0.0124803591470258*G0_1_1_0 + 0.0446464646464647*G0_1_1_1 + 0.162129228795895*G0_2_1_1 - 0.058297258297258*G0_3_1_0 - 0.0163780663780661*G0_3_1_1 + 0.102741702741703*G0_4_1_0 + 0.0766955266955264*G0_4_1_1 + 0.0582972582972579*G0_5_1_0 + 0.0419191919191916*G0_5_1_1 - 0.102741702741702*G0_6_1_0 - 0.0260461760461758*G0_6_1_1 + 0.00242424242424227*G0_7_1_0 + 0.0581962481962477*G0_7_1_1 - 0.00242424242424243*G0_8_1_0 + 0.0557720057720057*G0_8_1_1 + 0.0809523809523807*G0_9_1_1;
    A[84] = -A[129] + 0.127086740420073*G0_0_1_0 - 0.0740355940355936*G0_0_1_1 + 0.00312970979637615*G0_1_1_0 - 0.0131345198011866*G0_1_1_1 + 0.00205226871893533*G0_2_1_1 - 0.0138528138528136*G0_3_1_0 - 0.0106204906204903*G0_3_1_1 - 0.0249350649350645*G0_4_1_0 - 0.0498701298701298*G0_4_1_1 - 0.0230880230880229*G0_5_1_0 + 0.044790764790765*G0_5_1_1 + 0.0249350649350649*G0_6_1_0 + 0.0267821067821065*G0_6_1_1 - 0.0974314574314566*G0_7_1_0 - 0.340779220779219*G0_7_1_1 - 0.0327849927849926*G0_8_1_0 + 0.0364790764790763*G0_8_1_1 + 0.0369408369408372*G0_9_1_0 + 0.0397113997113998*G0_9_1_1;
    A[67] = A[109] + 0.000673400673400354*G0_0_0_1 - 0.000673400673400355*G0_0_1_0 + 0.000673400673400119*G0_1_0_1 - 0.000673400673400123*G0_1_1_0 - 0.101779701779701*G0_2_0_1 + 0.101779701779701*G0_2_1_0 - 0.0401731601731607*G0_3_0_1 + 0.0401731601731606*G0_3_1_0 + 0.146320346320345*G0_4_0_1 - 0.146320346320345*G0_4_1_0 - 0.0401731601731604*G0_5_0_1 + 0.0401731601731604*G0_5_1_0 + 0.146320346320346*G0_6_0_1 - 0.146320346320346*G0_6_1_0 + 0.0121212121212117*G0_7_0_1 - 0.0121212121212117*G0_7_1_0 + 0.0121212121212117*G0_8_0_1 - 0.0121212121212117*G0_8_1_0 - 0.136103896103897*G0_9_0_1 + 0.136103896103897*G0_9_1_0;
    A[96] = A[144] - 0.398140131473464*G0_0_0_0 + 0.398140131473463*G0_0_1_1 - 0.0294500561167226*G0_1_0_0 - 0.0415071348404678*G0_1_0_1 - 0.0415071348404678*G0_1_1_0 - 0.0535642135642131*G0_1_1_1 + 0.053564213564213*G0_2_0_0 + 0.0415071348404679*G0_2_0_1 + 0.041507134840468*G0_2_1_0 + 0.0294500561167227*G0_2_1_1 - 0.259509379509378*G0_3_0_0 - 0.243347763347762*G0_3_0_1 - 0.243347763347762*G0_3_1_0 - 0.227186147186146*G0_3_1_1 + 0.227186147186146*G0_4_0_0 + 0.243347763347762*G0_4_0_1 + 0.243347763347762*G0_4_1_0 + 0.259509379509378*G0_4_1_1 + 0.457142857142855*G0_5_0_0 + 0.300144300144299*G0_5_0_1 + 0.300144300144299*G0_5_1_0 + 0.143145743145743*G0_5_1_1 + 0.12005772005772*G0_6_0_0 + 0.156998556998556*G0_6_0_1 + 0.156998556998556*G0_6_1_0 + 0.193939393939393*G0_6_1_1 - 0.143145743145742*G0_7_0_0 - 0.300144300144298*G0_7_0_1 - 0.300144300144298*G0_7_1_0 - 0.457142857142854*G0_7_1_1 - 0.193939393939393*G0_8_0_0 - 0.156998556998557*G0_8_0_1 - 0.156998556998557*G0_8_1_0 - 0.120057720057719*G0_8_1_1 + 0.166233766233766*G0_9_0_0 - 0.166233766233765*G0_9_1_1;
    A[81] = A[95] + 0.0126727593394258*G0_0_0_1 - 0.0126727593394258*G0_0_1_0 - 0.00908128908128912*G0_1_0_1 + 0.00908128908128913*G0_1_1_0 - 0.114413981080647*G0_2_0_1 + 0.114413981080647*G0_2_1_0 + 0.0281673881673878*G0_3_0_1 - 0.0281673881673878*G0_3_1_0 + 0.0724963924963921*G0_4_0_1 - 0.0724963924963921*G0_4_1_0 - 0.014314574314574*G0_5_0_1 + 0.014314574314574*G0_5_1_0 + 0.0337085137085136*G0_6_0_1 - 0.0337085137085135*G0_6_1_0 + 0.00923520923520894*G0_8_0_1 - 0.00923520923520893*G0_8_1_0 - 0.0184704184704185*G0_9_0_1 + 0.0184704184704185*G0_9_1_0;
    A[112] = A[160] - 0.32111592111592*G0_0_0_0 + 0.321115921115919*G0_0_1_1 - 0.246849446849446*G0_1_0_0 - 0.259836459836459*G0_1_0_1 - 0.259836459836459*G0_1_1_0 - 0.198556998556997*G0_1_1_1 + 0.198556998556997*G0_2_0_0 + 0.259836459836458*G0_2_0_1 + 0.259836459836458*G0_2_1_0 + 0.246849446849445*G0_2_1_1 - 0.850043290043285*G0_3_0_0 - 0.817142857142853*G0_3_0_1 - 0.817142857142853*G0_3_1_0 - 0.940086580086574*G0_3_1_1 + 0.940086580086575*G0_4_0_0 + 0.817142857142853*G0_4_0_1 + 0.817142857142853*G0_4_1_0 + 0.850043290043285*G0_4_1_1 - 0.427532467532465*G0_5_0_0 - 0.158268398268398*G0_5_0_1 - 0.158268398268398*G0_5_1_0 + 0.450389610389608*G0_5_1_1 + 1.27948051948052*G0_6_0_0 + 0.73160173160173*G0_6_0_1 + 0.731601731601731*G0_6_1_0 + 0.606233766233765*G0_6_1_1 - 0.450389610389608*G0_7_0_0 + 0.158268398268397*G0_7_0_1 + 0.158268398268397*G0_7_1_0 + 0.427532467532465*G0_7_1_1 - 0.606233766233764*G0_8_0_0 - 0.731601731601729*G0_8_0_1 - 0.731601731601729*G0_8_1_0 - 1.27948051948051*G0_8_1_1 - 0.0238961038961037*G0_9_0_0 + 0.0238961038961039*G0_9_1_1;
    A[223] = -A[213] + 0.0364790764790763*G0_0_0_0 + 0.0619272085938752*G0_0_0_1 - 0.00138528138528118*G0_0_1_0 + 0.01667468334135*G0_0_1_1 - 0.0364790764790764*G0_1_0_0 + 0.0194965528298863*G0_1_0_1 - 0.0378643578643575*G0_1_1_0 - 0.0985088985088982*G0_1_1_1 - 0.0600288600288601*G0_2_0_1 - 0.0529485329485322*G0_2_1_0 - 0.113952220618886*G0_2_1_1 + 0.19116883116883*G0_3_0_0 + 0.549033189033186*G0_3_0_1 + 0.213333333333331*G0_3_1_0 + 0.239191919191916*G0_3_1_1 + 0.296450216450215*G0_4_0_0 + 0.398037518037518*G0_4_0_1 + 0.217489177489177*G0_4_1_0 + 0.322308802308802*G0_4_1_1 - 0.191168831168831*G0_5_0_0 - 0.0946608946608943*G0_5_0_1 + 0.0221645021645017*G0_5_1_0 - 0.0133910533910536*G0_5_1_1 - 0.296450216450217*G0_6_0_0 + 0.147763347763346*G0_6_0_1 - 0.0789610389610384*G0_6_1_0 + 0.00600288600288624*G0_6_1_1 - 0.0401731601731601*G0_7_0_0 - 0.138528138528138*G0_7_0_1 - 0.0180086580086574*G0_7_1_0 - 0.144992784992784*G0_7_1_1 + 0.0401731601731599*G0_8_0_0 + 0.21194805194805*G0_8_0_1 + 0.0221645021645023*G0_8_1_0 - 0.959538239538235*G0_8_1_1 + 0.462683982683981*G0_9_0_1 + 1.27168831168831*G0_9_1_0 - 0.0664935064935055*G0_9_1_1;
    A[185] = -A[188] - 0.020522687189354*G0_0_0_1 + 0.0841430174763504*G0_0_1_1 - 0.0552060285393615*G0_1_0_1 - 0.0664935064935062*G0_1_1_1 + 0.0236010902677567*G0_2_1_1 + 0.123751803751803*G0_3_0_1 + 0.140375180375179*G0_3_1_1 + 0.0738816738816733*G0_4_0_1 + 0.0960461760461754*G0_4_1_1 - 0.134834054834054*G0_5_0_1 + 0.0849639249639244*G0_5_1_1 - 0.073881673881673*G0_6_0_1 - 0.336161616161615*G0_6_1_1 - 0.0203174603174604*G0_7_0_1 + 0.685252525252521*G0_7_1_1 + 0.0960461760461758*G0_8_0_1 + 0.120057720057719*G0_8_1_1 + 0.011082251082251*G0_9_0_1 + 0.116363636363636*G0_9_1_1;
    A[210] = A[14] - 0.00829886163219494*G0_1_0_1 + 0.00829886163219493*G0_1_1_0 + 0.000795254128587374*G0_2_0_1 - 0.000795254128587372*G0_2_1_0 + 0.0125829725829726*G0_3_0_1 - 0.0125829725829726*G0_3_1_0 - 0.00507936507936518*G0_4_0_1 + 0.00507936507936518*G0_4_1_0 + 0.0386724386724384*G0_5_0_1 - 0.0386724386724385*G0_5_1_0 - 0.0451370851370849*G0_6_0_1 + 0.0451370851370849*G0_6_1_0 - 0.0386724386724386*G0_7_0_1 + 0.0386724386724386*G0_7_1_0 + 0.0195093795093795*G0_8_0_1 - 0.0195093795093795*G0_8_1_0 + 0.0256277056277055*G0_9_0_1 - 0.0256277056277056*G0_9_1_0;
    A[203] = -A[200] + 0.0552060285393617*G0_0_0_1 - 0.0112874779541442*G0_0_1_1 + 0.0205226871893535*G0_1_0_1 + 0.104665704665704*G0_1_1_1 + 0.0236010902677572*G0_2_1_1 + 0.134834054834055*G0_3_0_1 + 0.21979797979798*G0_3_1_1 + 0.073881673881674*G0_4_0_1 - 0.262279942279941*G0_4_1_1 - 0.123751803751804*G0_5_0_1 + 0.0166233766233766*G0_5_1_1 - 0.0738816738816743*G0_6_0_1 + 0.0221645021645019*G0_6_1_1 - 0.0960461760461763*G0_7_0_1 + 0.0240115440115434*G0_7_1_1 + 0.0203174603174603*G0_8_0_1 + 0.705569985569983*G0_8_1_1 - 0.011082251082251*G0_9_0_1 + 0.105281385281384*G0_9_1_1;
    A[17] = -0.00253166586499919*G0_0_0_1 - 0.0169472502805836*G0_1_0_1 - 0.0169472502805835*G0_2_0_1 + 0.000342712842712794*G0_3_0_1 + 0.000342712842712848*G0_4_0_1 + 0.00656204906204905*G0_5_0_1 - 0.0152417027417027*G0_6_0_1 + 0.00656204906204907*G0_7_0_1 - 0.0152417027417027*G0_8_0_1 - 0.00351370851370853*G0_9_0_1;
    A[2] = -A[17] + 0.0144155844155844*G0_0_0_1 + 0.0169472502805836*G0_0_1_1 - 0.0144155844155845*G0_1_0_1 + 0.00253166586499918*G0_1_1_1 + 0.0169472502805837*G0_2_1_1 - 0.00621933621933622*G0_3_0_1 - 0.00656204906204907*G0_3_1_1 + 0.0155844155844155*G0_4_0_1 + 0.0152417027417028*G0_4_1_1 + 0.00621933621933622*G0_5_0_1 - 0.00034271284271287*G0_5_1_1 - 0.0155844155844155*G0_6_0_1 - 0.000342712842712753*G0_6_1_1 + 0.0218037518037518*G0_7_0_1 + 0.0152417027417027*G0_7_1_1 - 0.0218037518037518*G0_8_0_1 - 0.00656204906204908*G0_8_1_1 + 0.00351370851370853*G0_9_1_1;
    A[134] = -A[89] - 0.0482283148949816*G0_0_1_0 - 0.0728555395222064*G0_0_1_1 + 0.0482283148949816*G0_1_1_0 - 0.0246272246272248*G0_1_1_1 + 0.0205226871893538*G0_2_1_1 - 0.156998556998556*G0_3_1_0 - 0.136681096681096*G0_3_1_1 - 0.655699855699853*G0_4_1_0 - 0.646464646464644*G0_4_1_1 + 0.156998556998556*G0_5_1_0 + 0.0203174603174605*G0_5_1_1 + 0.655699855699856*G0_6_1_0 + 0.00923520923520846*G0_6_1_1 + 0.0554112554112547*G0_7_1_0 - 0.323232323232321*G0_7_1_1 - 0.0554112554112552*G0_8_1_0 - 0.378643578643577*G0_8_1_1 - 0.770216450216448*G0_9_1_1;
    A[186] = A[134] - 0.170030463363796*G0_0_0_0 + 0.0816802950136271*G0_0_0_1 - 0.0976879910213238*G0_0_1_0 + 0.213128106461439*G0_0_1_1 - 0.0811672278338945*G0_1_0_0 - 0.0811672278338944*G0_1_0_1 - 0.0811672278338945*G0_1_1_0 - 0.0591053391053406*G0_2_0_0 - 0.310816097482763*G0_2_0_1 - 0.131447811447812*G0_2_1_0 - 0.213128106461439*G0_2_1_1 + 0.0905050505050506*G0_3_0_0 + 0.233189033189032*G0_3_0_1 + 0.155613275613275*G0_3_1_0 + 0.118210678210678*G0_3_1_1 - 0.796075036075034*G0_4_0_0 - 1.12161616161616*G0_4_0_1 - 0.800230880230878*G0_4_1_0 - 0.890274170274166*G0_4_1_1 - 1.35388167388167*G0_5_0_0 - 0.247041847041847*G0_5_0_1 - 0.0918903318903303*G0_5_1_0 + 0.407272727272725*G0_5_1_1 + 0.607676767676763*G0_6_0_0 - 0.499163059163057*G0_6_0_1 - 0.654314574314575*G0_6_1_0 - 0.407272727272726*G0_6_1_1 - 0.235497835497834*G0_7_0_0 + 0.0900432900432894*G0_7_0_1 - 0.231341991341989*G0_7_1_0 + 0.890274170274167*G0_7_1_1 + 0.180086580086579*G0_8_0_0 + 0.0374025974025978*G0_8_0_1 + 0.114978354978354*G0_8_1_0 - 0.118210678210678*G0_8_1_1 - 0.62060606060606*G0_9_0_0 - 0.620606060606059*G0_9_0_1 - 0.620606060606059*G0_9_1_0;
    A[218] = A[134] - 0.0489466089466088*G0_0_0_1 + 0.0489466089466088*G0_0_1_0 - 0.000718294051627211*G0_1_0_1 + 0.000718294051627211*G0_1_1_0 - 0.228314894981559*G0_2_0_1 + 0.228314894981559*G0_2_1_0 + 0.0364790764790758*G0_3_0_1 - 0.0364790764790759*G0_3_1_0 - 0.307070707070705*G0_4_0_1 + 0.307070707070705*G0_4_1_0 + 0.193477633477632*G0_5_0_1 - 0.193477633477632*G0_5_1_0 + 0.34862914862915*G0_6_0_1 - 0.34862914862915*G0_6_1_0 + 0.014314574314574*G0_7_0_1 - 0.014314574314574*G0_7_1_0 - 0.0410966810966805*G0_8_0_1 + 0.0410966810966805*G0_8_1_0 + 0.0332467532467535*G0_9_0_1 - 0.0332467532467535*G0_9_1_0;
    A[215] = -A[218] - 0.0482283148949816*G0_0_0_1 - 0.0728555395222064*G0_0_1_1 + 0.0482283148949816*G0_1_0_1 - 0.0246272246272248*G0_1_1_1 + 0.0205226871893538*G0_2_1_1 - 0.156998556998556*G0_3_0_1 - 0.136681096681096*G0_3_1_1 - 0.655699855699853*G0_4_0_1 - 0.646464646464644*G0_4_1_1 + 0.156998556998556*G0_5_0_1 + 0.0203174603174605*G0_5_1_1 + 0.655699855699856*G0_6_0_1 + 0.00923520923520846*G0_6_1_1 + 0.0554112554112547*G0_7_0_1 - 0.323232323232321*G0_7_1_1 - 0.0554112554112552*G0_8_0_1 - 0.378643578643577*G0_8_1_1 - 0.770216450216448*G0_9_1_1;
    A[69] = A[139] - 0.00420715087381822*G0_0_0_1 + 0.00420715087381822*G0_0_1_0 - 0.0398653198653201*G0_1_0_1 + 0.0398653198653201*G0_1_1_0 + 0.00124418791085439*G0_2_0_1 - 0.00124418791085439*G0_2_1_0 + 0.114170274170273*G0_3_0_1 - 0.114170274170273*G0_3_1_0 - 0.0738816738816737*G0_4_0_1 + 0.0738816738816737*G0_4_1_0 + 0.00738816738816725*G0_5_0_1 - 0.00738816738816725*G0_5_1_0 + 0.0049639249639249*G0_6_0_1 - 0.0049639249639249*G0_6_1_0 - 0.00577200577200653*G0_7_0_1 + 0.00577200577200652*G0_7_1_0 + 0.0257431457431459*G0_8_0_1 - 0.0257431457431459*G0_8_1_0 - 0.02978354978355*G0_9_0_1 + 0.02978354978355*G0_9_1_0;
    A[94] = A[69] - 0.0137502004168674*G0_0_0_0 + 0.0137502004168678*G0_0_1_1 - 0.0141478274811607*G0_1_0_0 - 0.0186243386243386*G0_1_0_1 - 0.0597338464005131*G0_1_1_0 - 0.0777296777296775*G0_1_1_1 + 0.0777296777296768*G0_2_0_0 + 0.0186243386243385*G0_2_0_1 + 0.0597338464005126*G0_2_1_0 + 0.0141478274811606*G0_2_1_1 - 0.00531024531024535*G0_3_0_0 - 0.0685714285714288*G0_3_0_1 + 0.119480519480519*G0_3_1_0 + 0.101240981240981*G0_3_1_1 - 0.101240981240982*G0_4_0_0 + 0.0685714285714281*G0_4_0_1 - 0.119480519480519*G0_4_1_0 + 0.00531024531024524*G0_4_1_1 + 0.0253968253968256*G0_5_0_0 + 0.0228571428571434*G0_5_0_1 + 0.036017316017316*G0_5_1_0 + 0.0154689754689761*G0_5_1_1 - 0.045598845598846*G0_6_0_0 - 0.0228571428571429*G0_6_0_1 - 0.0436363636363636*G0_6_1_0 - 0.0181240981240984*G0_6_1_1 - 0.0154689754689752*G0_7_0_0 - 0.0228571428571417*G0_7_0_1 - 0.0360173160173153*G0_7_1_0 - 0.0253968253968241*G0_7_1_1 + 0.018124098124098*G0_8_0_0 + 0.0228571428571419*G0_8_0_1 + 0.0436363636363633*G0_8_1_0 + 0.0455988455988449*G0_8_1_1 - 0.0103896103896105*G0_9_0_0 + 0.0103896103896106*G0_9_1_1;
    A[66] = A[94] + 0.00420715087381802*G0_0_0_1 - 0.00420715087381802*G0_0_1_0 - 0.0012441879108544*G0_1_0_1 + 0.0012441879108544*G0_1_1_0 + 0.0398653198653197*G0_2_0_1 - 0.0398653198653197*G0_2_1_0 + 0.0738816738816741*G0_3_0_1 - 0.0738816738816741*G0_3_1_0 - 0.114170274170273*G0_4_0_1 + 0.114170274170273*G0_4_1_0 + 0.0057720057720053*G0_5_0_1 - 0.0057720057720053*G0_5_1_0 - 0.0257431457431456*G0_6_0_1 + 0.0257431457431456*G0_6_1_0 - 0.0073881673881671*G0_7_0_1 + 0.0073881673881671*G0_7_1_0 - 0.00496392496392455*G0_8_0_1 + 0.00496392496392455*G0_8_1_0 + 0.02978354978355*G0_9_0_1 - 0.02978354978355*G0_9_1_0;
    A[48] = -A[56] + 0.0627481160814494*G0_0_0_0 + 0.0120570787237453*G0_0_1_0 - 0.0461760461760456*G0_1_0_0 - 0.398140131473464*G0_1_1_0 + 0.104255250921917*G0_2_0_0 + 0.0120570787237452*G0_2_1_0 + 0.600288600288599*G0_3_0_0 + 0.156998556998556*G0_3_1_0 + 0.00692640692640696*G0_4_0_0 - 0.0369408369408365*G0_4_1_0 - 0.0212409812409816*G0_5_0_0 - 0.0161616161616159*G0_5_1_0 + 0.222106782106781*G0_6_0_0 - 0.0161616161616161*G0_6_1_0 - 0.15007215007215*G0_7_0_0 - 0.0369408369408364*G0_7_1_0 + 0.300144300144299*G0_8_0_0 + 0.156998556998555*G0_8_1_0 + 0.614141414141412*G0_9_0_0 + 0.166233766233765*G0_9_1_0;
    A[39] = A[41] - 0.0223953823953823*G0_0_1_0 + 0.0110565977232643*G0_0_1_1 - 0.0223953823953824*G0_1_1_0 - 0.0334519801186468*G0_1_1_1 + 0.00161616161616147*G0_3_1_0 + 0.0120057720057718*G0_3_1_1 - 0.00230880230880227*G0_4_1_1 + 0.0016161616161616*G0_5_1_0 - 0.0103896103896104*G0_5_1_1 + 0.00230880230880235*G0_6_1_1 + 0.0223953823953823*G0_7_1_0 + 0.0745743145743144*G0_7_1_1 + 0.0223953823953822*G0_8_1_0 - 0.0521789321789322*G0_8_1_1 - 0.00323232323232328*G0_9_1_0 - 0.00161616161616171*G0_9_1_1;
    A[121] = A[91] - 0.0110565977232643*G0_0_0_0 + 0.0223953823953824*G0_0_1_0 + 0.0334519801186467*G0_2_0_0 + 0.0223953823953823*G0_2_1_0 + 0.0023088023088024*G0_3_0_0 - 0.012005772005772*G0_4_0_0 - 0.00161616161616166*G0_4_1_0 - 0.074574314574314*G0_5_0_0 - 0.0223953823953822*G0_5_1_0 + 0.0521789321789319*G0_6_0_0 - 0.0223953823953824*G0_6_1_0 + 0.0103896103896103*G0_7_0_0 - 0.0016161616161616*G0_7_1_0 - 0.00230880230880228*G0_8_0_0 + 0.00161616161616165*G0_9_0_0 + 0.00323232323232331*G0_9_1_0;
    A[76] = -A[121] + 0.0103383036716369*G0_0_1_0 + 0.09318582651916*G0_1_1_0 + 0.0233445566778899*G0_2_1_0 - 0.00375180375180359*G0_3_1_0 + 0.0267243867243865*G0_4_1_0 - 0.0152958152958153*G0_5_1_0 - 0.00998556998557001*G0_6_1_0 - 0.0394227994227994*G0_7_1_0 + 0.0839826839826839*G0_8_1_0 + 0.034054834054834*G0_9_1_0;
    A[136] = -A[76] - 0.038723745390412*G0_0_0_0 + 0.00909411576078244*G0_0_1_0 - 0.0815776815776814*G0_1_0_0 - 0.0478178611511943*G0_2_0_0 - 0.00909411576078237*G0_2_1_0 - 0.0655122655122653*G0_3_0_0 - 0.0773448773448768*G0_3_1_0 + 0.0423088023088021*G0_4_0_0 + 0.0646464646464641*G0_4_1_0 - 0.0401154401154399*G0_5_0_0 - 0.0176623376623376*G0_5_1_0 - 0.0224531024531023*G0_6_0_0 + 0.0176623376623376*G0_6_1_0 - 0.0223376623376622*G0_7_0_0 - 0.0646464646464644*G0_7_1_0 + 0.0118326118326116*G0_8_0_0 + 0.0773448773448771*G0_8_1_0 - 0.0234343434343435*G0_9_0_0;
    A[87] = -A[132] - 0.020522687189354*G0_0_1_0 + 0.0841430174763504*G0_0_1_1 - 0.0552060285393615*G0_1_1_0 - 0.0664935064935062*G0_1_1_1 + 0.0236010902677567*G0_2_1_1 + 0.123751803751803*G0_3_1_0 + 0.140375180375179*G0_3_1_1 + 0.0738816738816733*G0_4_1_0 + 0.0960461760461754*G0_4_1_1 - 0.134834054834054*G0_5_1_0 + 0.0849639249639244*G0_5_1_1 - 0.073881673881673*G0_6_1_0 - 0.336161616161615*G0_6_1_1 - 0.0203174603174604*G0_7_1_0 + 0.685252525252521*G0_7_1_1 + 0.0960461760461758*G0_8_1_0 + 0.120057720057719*G0_8_1_1 + 0.0110822510822511*G0_9_1_0 + 0.116363636363636*G0_9_1_1;
    A[64] = A[160] - 0.246849446849446*G0_0_0_0 + 0.0129870129870128*G0_0_0_1 + 0.0129870129870128*G0_0_1_0 + 0.0742664742664743*G0_0_1_1 - 0.32111592111592*G0_1_0_0 - 0.32111592111592*G0_1_0_1 - 0.32111592111592*G0_1_1_0 + 0.198556998556996*G0_2_0_0 - 0.0612794612794615*G0_2_0_1 - 0.0612794612794615*G0_2_1_0 - 0.074266474266474*G0_2_1_1 - 0.427532467532465*G0_3_0_0 - 0.269264069264068*G0_3_0_1 - 0.269264069264068*G0_3_1_0 + 0.339393939393939*G0_3_1_1 + 1.27948051948051*G0_4_0_0 + 0.547878787878786*G0_4_0_1 + 0.547878787878786*G0_4_1_0 + 0.422510822510821*G0_4_1_1 - 0.850043290043285*G0_5_0_0 - 0.0329004329004326*G0_5_0_1 - 0.0329004329004326*G0_5_1_0 - 0.155844155844155*G0_5_1_1 + 0.940086580086575*G0_6_0_0 + 0.122943722943722*G0_6_0_1 + 0.122943722943722*G0_6_1_0 + 0.155844155844155*G0_6_1_1 - 0.606233766233763*G0_7_0_0 + 0.125367965367965*G0_7_0_1 + 0.125367965367965*G0_7_1_0 - 0.422510822510821*G0_7_1_1 - 0.450389610389609*G0_8_0_0 - 0.608658008658007*G0_8_0_1 - 0.608658008658007*G0_8_1_0 - 0.339393939393938*G0_8_1_1 - 0.0238961038961044*G0_9_0_0 - 0.0238961038961046*G0_9_0_1 - 0.0238961038961046*G0_9_1_0;
    A[166] = -A[46] - 0.0218053551386885*G0_0_0_0 - 0.194965528298861*G0_1_0_0 - 0.0218053551386884*G0_2_0_0 - 0.043001443001443*G0_3_0_0 - 0.00202020202020192*G0_4_0_0 - 0.0510822510822506*G0_5_0_0 - 0.0510822510822508*G0_6_0_0 - 0.00202020202020186*G0_7_0_0 - 0.0430014430014432*G0_8_0_0 - 0.094083694083694*G0_9_0_0;
    A[115] = A[157] - 0.101779701779702*G0_0_0_1 + 0.101779701779702*G0_0_1_0 + 0.000673400673400504*G0_1_0_1 - 0.000673400673400503*G0_1_1_0 + 0.0006734006734009*G0_2_0_1 - 0.000673400673400899*G0_2_1_0 + 0.0121212121212122*G0_3_0_1 - 0.0121212121212122*G0_3_1_0 + 0.0121212121212122*G0_4_0_1 - 0.0121212121212122*G0_4_1_0 + 0.146320346320345*G0_5_0_1 - 0.146320346320345*G0_5_1_0 - 0.0401731601731603*G0_6_0_1 + 0.0401731601731604*G0_6_1_0 + 0.146320346320345*G0_7_0_1 - 0.146320346320345*G0_7_1_0 - 0.0401731601731597*G0_8_0_1 + 0.0401731601731597*G0_8_1_0 - 0.136103896103896*G0_9_0_1 + 0.136103896103896*G0_9_1_0;
    A[224] = A[208] + 0.0394035594035599*G0_0_0_0 - 0.0394035594035585*G0_0_1_1 - 0.135449735449734*G0_1_0_0 - 0.0394035594035587*G0_1_0_1 - 0.0394035594035587*G0_1_1_0 - 0.118210678210677*G0_1_1_1 + 0.118210678210678*G0_2_0_0 + 0.0394035594035603*G0_2_0_1 + 0.0394035594035603*G0_2_1_0 + 0.135449735449736*G0_2_1_1 - 2.01696969696969*G0_3_0_0 - 1.96155844155843*G0_3_0_1 - 1.96155844155843*G0_3_1_0 - 2.23861471861471*G0_3_1_1 + 2.23861471861471*G0_4_0_0 + 1.96155844155843*G0_4_0_1 + 1.96155844155843*G0_4_1_0 + 2.01696969696969*G0_4_1_1 - 0.598441558441556*G0_5_0_0 - 0.0332467532467544*G0_5_0_1 - 0.0332467532467544*G0_5_1_0 + 0.0886580086580075*G0_5_1_1 + 1.79532467532467*G0_6_0_0 + 0.398961038961038*G0_6_0_1 + 0.398961038961038*G0_6_1_0 + 0.42112554112554*G0_6_1_1 - 0.088658008658008*G0_7_0_0 + 0.0332467532467539*G0_7_0_1 + 0.0332467532467539*G0_7_1_0 + 0.598441558441555*G0_7_1_1 - 0.421125541125539*G0_8_0_0 - 0.398961038961037*G0_8_0_1 - 0.398961038961037*G0_8_1_0 - 1.79532467532467*G0_8_1_1 - 0.930909090909088*G0_9_0_0 + 0.930909090909087*G0_9_1_1;
    A[206] = -A[198] - 0.0728555395222062*G0_0_0_0 - 0.0482283148949815*G0_0_1_0 + 0.0205226871893538*G0_1_0_0 - 0.0246272246272246*G0_2_0_0 + 0.0482283148949811*G0_2_1_0 - 0.646464646464644*G0_3_0_0 - 0.655699855699854*G0_3_1_0 - 0.136681096681096*G0_4_0_0 - 0.156998556998556*G0_4_1_0 - 0.323232323232321*G0_5_0_0 + 0.0554112554112553*G0_5_1_0 - 0.378643578643577*G0_6_0_0 - 0.0554112554112558*G0_6_1_0 + 0.0203174603174605*G0_7_0_0 + 0.156998556998557*G0_7_1_0 + 0.00923520923520918*G0_8_0_0 + 0.655699855699852*G0_8_1_0 - 0.770216450216448*G0_9_0_0;
    A[178] = A[206] - 0.0489466089466087*G0_0_0_1 + 0.0489466089466087*G0_0_1_0 - 0.22831489498156*G0_1_0_1 + 0.22831489498156*G0_1_1_0 - 0.000718294051627315*G0_2_0_1 + 0.000718294051627315*G0_2_1_0 - 0.307070707070706*G0_3_0_1 + 0.307070707070706*G0_3_1_0 + 0.0364790764790759*G0_4_0_1 - 0.0364790764790758*G0_4_1_0 + 0.0143145743145742*G0_5_0_1 - 0.0143145743145742*G0_5_1_0 - 0.041096681096681*G0_6_0_1 + 0.041096681096681*G0_6_1_0 + 0.193477633477633*G0_7_0_1 - 0.193477633477633*G0_7_1_0 + 0.348629148629147*G0_8_0_1 - 0.348629148629147*G0_8_1_0 + 0.0332467532467521*G0_9_0_1 - 0.0332467532467521*G0_9_1_0;
    A[0] = A[16] + 0.158104858104857*G0_0_0_0 + 0.172286355619688*G0_0_0_1 + 0.172286355619688*G0_0_1_0 + 0.172286355619688*G0_0_1_1 - 0.158104858104857*G0_1_0_0 + 0.0141814975148308*G0_1_0_1 + 0.0141814975148308*G0_1_1_0 + 0.0141814975148308*G0_1_1_1 + 0.0141814975148308*G0_2_0_1 + 0.0141814975148308*G0_2_1_0 + 0.0141814975148308*G0_2_1_1 - 0.101154401154401*G0_3_0_0 + 0.006619769119769*G0_3_0_1 + 0.006619769119769*G0_3_1_0 + 0.00661976911976899*G0_3_1_1 + 0.0519480519480515*G0_4_0_0 + 0.00661976911976904*G0_4_0_1 + 0.00661976911976904*G0_4_1_0 + 0.00661976911976904*G0_4_1_1 + 0.101154401154401*G0_5_0_0 + 0.10777417027417*G0_5_0_1 + 0.10777417027417*G0_5_1_0 + 0.10777417027417*G0_5_1_1 - 0.0519480519480517*G0_6_0_0 - 0.0453282828282826*G0_6_0_1 - 0.0453282828282826*G0_6_1_0 - 0.0453282828282826*G0_6_1_1 + 0.153102453102452*G0_7_0_0 + 0.10777417027417*G0_7_0_1 + 0.10777417027417*G0_7_1_0 + 0.10777417027417*G0_7_1_1 - 0.153102453102452*G0_8_0_0 - 0.0453282828282827*G0_8_0_1 - 0.0453282828282827*G0_8_1_0 - 0.0453282828282827*G0_8_1_1 + 0.0342352092352093*G0_9_0_1 + 0.0342352092352093*G0_9_1_0 + 0.0342352092352093*G0_9_1_1;
    A[58] = -A[178] - 0.0728555395222062*G0_0_0_0 - 0.0482283148949815*G0_0_0_1 + 0.0205226871893539*G0_1_0_0 - 0.0246272246272246*G0_2_0_0 + 0.0482283148949811*G0_2_0_1 - 0.646464646464644*G0_3_0_0 - 0.655699855699854*G0_3_0_1 - 0.136681096681096*G0_4_0_0 - 0.156998556998556*G0_4_0_1 - 0.323232323232321*G0_5_0_0 + 0.0554112554112553*G0_5_0_1 - 0.378643578643577*G0_6_0_0 - 0.0554112554112558*G0_6_0_1 + 0.0203174603174605*G0_7_0_0 + 0.156998556998557*G0_7_0_1 + 0.00923520923520912*G0_8_0_0 + 0.655699855699852*G0_8_0_1 - 0.770216450216448*G0_9_0_0;
    A[28] = -0.00421997755331084*G0_0_0_0 + 0.0124803591470257*G0_0_0_1 - 0.11729998396665*G0_1_0_0 - 0.0167003367003366*G0_2_0_0 - 0.0124803591470257*G0_2_0_1 - 0.219336219336218*G0_3_0_0 - 0.102741702741702*G0_3_0_1 + 0.121789321789321*G0_4_0_0 + 0.058297258297258*G0_4_0_1 + 0.0731890331890326*G0_5_0_0 - 0.00242424242424241*G0_5_0_1 + 0.0756132756132754*G0_6_0_0 + 0.00242424242424259*G0_6_0_1 + 0.0634920634920632*G0_7_0_0 - 0.058297258297258*G0_7_0_1 - 0.116594516594516*G0_8_0_0 + 0.102741702741702*G0_8_0_1 + 0.0554112554112551*G0_9_0_0;
    A[12] = A[28] - 0.113080006413339*G0_0_0_0 - 0.129780343113676*G0_0_0_1 - 0.11729998396665*G0_0_1_0 - 0.11729998396665*G0_0_1_1 + 0.113080006413339*G0_1_0_0 - 0.0167003367003365*G0_1_0_1 - 0.00421997755331079*G0_1_1_0 - 0.0167003367003366*G0_1_1_1 + 0.00826038159371488*G0_2_0_1 - 0.0167003367003366*G0_2_1_0 - 0.00421997755331084*G0_2_1_1 + 0.292525252525251*G0_3_0_0 + 0.178354978354977*G0_3_0_1 + 0.0731890331890324*G0_3_1_0 + 0.0756132756132749*G0_3_1_1 - 0.0461760461760459*G0_4_0_0 + 0.0148917748917747*G0_4_0_1 + 0.0756132756132752*G0_4_1_0 + 0.0731890331890328*G0_4_1_1 - 0.29252525252525*G0_5_0_0 - 0.114170274170274*G0_5_0_1 - 0.219336219336218*G0_5_1_0 - 0.116594516594516*G0_5_1_1 + 0.0461760461760458*G0_6_0_0 + 0.0610678210678206*G0_6_0_1 + 0.121789321789321*G0_6_1_0 + 0.0634920634920632*G0_6_1_1 - 0.180086580086579*G0_7_0_0 - 0.16103896103896*G0_7_0_1 - 0.116594516594516*G0_7_1_0 - 0.219336219336218*G0_7_1_1 + 0.180086580086579*G0_8_0_0 + 0.0190476190476194*G0_8_0_1 + 0.0634920634920631*G0_8_1_0 + 0.121789321789321*G0_8_1_1 + 0.0554112554112552*G0_9_0_1 + 0.0554112554112551*G0_9_1_0 + 0.055411255411255*G0_9_1_1;
    A[180] = A[12] + 0.0124803591470258*G0_1_0_1 - 0.0124803591470258*G0_1_1_0 - 0.0124803591470257*G0_2_0_1 + 0.0124803591470257*G0_2_1_0 - 0.00242424242424265*G0_3_0_1 + 0.00242424242424263*G0_3_1_0 + 0.00242424242424243*G0_4_0_1 - 0.00242424242424244*G0_4_1_0 - 0.102741702741702*G0_5_0_1 + 0.102741702741702*G0_5_1_0 + 0.058297258297258*G0_6_0_1 - 0.058297258297258*G0_6_1_0 + 0.102741702741702*G0_7_0_1 - 0.102741702741702*G0_7_1_0 - 0.0582972582972581*G0_8_0_1 + 0.0582972582972581*G0_8_1_0;
    A[131] = -A[86] - 0.00312970979637636*G0_0_1_0 - 0.016264229597563*G0_0_1_1 - 0.127086740420074*G0_1_1_0 - 0.201122334455668*G0_1_1_1 + 0.00205226871893528*G0_2_1_1 + 0.0230880230880228*G0_3_1_0 + 0.0678787878787875*G0_3_1_1 - 0.0249350649350648*G0_4_1_0 + 0.00184704184704204*G0_4_1_1 + 0.0138528138528143*G0_5_1_0 + 0.00323232323232313*G0_5_1_1 + 0.0249350649350646*G0_6_1_0 - 0.0249350649350647*G0_6_1_1 + 0.0327849927849931*G0_7_1_0 + 0.0692640692640691*G0_7_1_1 + 0.0974314574314565*G0_8_1_0 - 0.243347763347763*G0_8_1_1 - 0.0369408369408371*G0_9_1_0 + 0.00277056277056261*G0_9_1_1;
    A[123] = -A[131] - 0.0162642295975629*G0_0_0_0 - 0.00312970979637622*G0_0_1_0 + 0.0020522687189353*G0_1_0_0 - 0.201122334455666*G0_2_0_0 - 0.127086740420073*G0_2_1_0 + 0.00184704184704147*G0_3_0_0 - 0.0249350649350653*G0_3_1_0 + 0.0678787878787879*G0_4_0_0 + 0.0230880230880229*G0_4_1_0 + 0.0692640692640687*G0_5_0_0 + 0.032784992784993*G0_5_1_0 - 0.243347763347761*G0_6_0_0 + 0.0974314574314571*G0_6_1_0 + 0.00323232323232314*G0_7_0_0 + 0.0138528138528141*G0_7_1_0 - 0.0249350649350646*G0_8_0_0 + 0.0249350649350646*G0_8_1_0 + 0.00277056277056303*G0_9_0_0 - 0.0369408369408371*G0_9_1_0;
    A[40] = A[41] + 0.00753727753727757*G0_0_1_0 - 0.0076078242744909*G0_0_1_1 - 0.0299326599326601*G0_1_1_0 - 0.0485970819304154*G0_1_1_1 + 0.00396825396825393*G0_2_1_1 + 0.00477633477633481*G0_3_1_0 + 0.0179942279942278*G0_3_1_1 - 0.00115440115440105*G0_4_1_1 - 0.00316017316017293*G0_5_1_0 + 0.0028282828282828*G0_5_1_1 + 0.00115440115440116*G0_6_1_1 - 0.029134199134199*G0_7_1_0 + 0.0316883116883116*G0_7_1_1 + 0.0515295815295815*G0_8_1_0 + 0.00864357864357853*G0_8_1_1 - 0.00161616161616161*G0_9_1_0 - 0.0089177489177489*G0_9_1_1;
    A[151] = -A[61] + 0.0321661054994388*G0_0_0_0 - 0.0124803591470258*G0_0_1_0 + 0.162129228795895*G0_1_0_0 + 0.0446464646464644*G0_2_0_0 + 0.0124803591470257*G0_2_1_0 + 0.0766955266955264*G0_3_0_0 + 0.102741702741702*G0_3_1_0 - 0.0163780663780665*G0_4_0_0 - 0.0582972582972579*G0_4_1_0 + 0.0581962481962477*G0_5_0_0 + 0.00242424242424243*G0_5_1_0 + 0.0557720057720054*G0_6_0_0 - 0.00242424242424249*G0_6_1_0 + 0.0419191919191916*G0_7_0_0 + 0.0582972582972581*G0_7_1_0 - 0.0260461760461755*G0_8_0_0 - 0.102741702741702*G0_8_1_0 + 0.0809523809523808*G0_9_0_0;
    A[102] = A[186] - 0.22831489498156*G0_0_0_1 + 0.22831489498156*G0_0_1_0 - 0.000718294051627291*G0_1_0_1 + 0.000718294051627287*G0_1_1_0 - 0.0489466089466085*G0_2_0_1 + 0.0489466089466085*G0_2_1_0 - 0.0410966810966812*G0_3_0_1 + 0.0410966810966812*G0_3_1_0 + 0.0143145743145738*G0_4_0_1 - 0.0143145743145737*G0_4_1_0 + 0.348629148629148*G0_5_0_1 - 0.348629148629148*G0_5_1_0 + 0.193477633477632*G0_6_0_1 - 0.193477633477632*G0_6_1_0 - 0.307070707070704*G0_7_0_1 + 0.307070707070704*G0_7_1_0 + 0.0364790764790758*G0_8_0_1 - 0.0364790764790758*G0_8_1_0 + 0.0332467532467534*G0_9_0_1 - 0.0332467532467535*G0_9_1_0;
    A[189] = A[102] + 0.391470258136922*G0_0_0_0 - 0.391470258136923*G0_0_1_1 + 0.058592271925605*G0_1_0_0 - 0.0261664261664261*G0_1_0_1 + 0.0220618887285554*G0_1_1_0 - 0.0935834535834531*G0_1_1_1 + 0.0935834535834533*G0_2_0_0 + 0.026166426166426*G0_2_0_1 - 0.022061888728555*G0_2_1_0 - 0.0585922719256048*G0_2_1_1 - 0.273362193362191*G0_3_0_0 - 0.192554112554111*G0_3_0_1 - 0.247965367965367*G0_3_1_0 - 0.169927849927849*G0_3_1_1 + 0.169927849927849*G0_4_0_0 + 0.192554112554112*G0_4_0_1 + 0.247965367965367*G0_4_1_0 + 0.273362193362192*G0_4_1_1 + 1.83041847041846*G0_5_0_0 - 0.175930735930736*G0_5_0_1 + 0.479769119769119*G0_5_1_0 - 0.48300144300144*G0_5_1_1 - 0.308455988455986*G0_6_0_0 + 0.0540259740259743*G0_6_0_1 + 0.21102453102453*G0_6_1_0 + 0.342626262626261*G0_6_1_1 + 0.483001443001441*G0_7_0_0 + 0.175930735930734*G0_7_0_1 - 0.479769119769116*G0_7_1_0 - 1.83041847041846*G0_7_1_1 - 0.342626262626262*G0_8_0_0 - 0.0540259740259736*G0_8_0_1 - 0.21102453102453*G0_8_1_0 + 0.308455988455987*G0_8_1_1 + 0.47099567099567*G0_9_0_0 - 0.47099567099567*G0_9_1_1;
    A[147] = A[189] + 0.22831489498156*G0_0_0_1 - 0.22831489498156*G0_0_1_0 + 0.0489466089466088*G0_1_0_1 - 0.0489466089466088*G0_1_1_0 + 0.000718294051627499*G0_2_0_1 - 0.000718294051627506*G0_2_1_0 - 0.0143145743145742*G0_3_0_1 + 0.0143145743145742*G0_3_1_0 + 0.0410966810966812*G0_4_0_1 - 0.0410966810966812*G0_4_1_0 + 0.307070707070706*G0_5_0_1 - 0.307070707070706*G0_5_1_0 - 0.0364790764790765*G0_6_0_1 + 0.0364790764790765*G0_6_1_0 - 0.348629148629146*G0_7_0_1 + 0.348629148629146*G0_7_1_0 - 0.193477633477632*G0_8_0_1 + 0.193477633477633*G0_8_1_0 - 0.0332467532467522*G0_9_0_1 + 0.0332467532467522*G0_9_1_0;
    A[177] = -A[57] + 0.0841430174763504*G0_0_0_0 - 0.0205226871893535*G0_0_0_1 + 0.0236010902677565*G0_1_0_0 - 0.0664935064935061*G0_2_0_0 - 0.0552060285393616*G0_2_0_1 + 0.0960461760461754*G0_3_0_0 + 0.0738816738816738*G0_3_0_1 + 0.14037518037518*G0_4_0_0 + 0.123751803751803*G0_4_0_1 + 0.68525252525252*G0_5_0_0 - 0.0203174603174599*G0_5_0_1 + 0.12005772005772*G0_6_0_0 + 0.0960461760461758*G0_6_0_1 + 0.0849639249639245*G0_7_0_0 - 0.134834054834054*G0_7_0_1 - 0.336161616161615*G0_8_0_0 - 0.0738816738816732*G0_8_0_1 + 0.116363636363636*G0_9_0_0 + 0.0110822510822517*G0_9_0_1;
    A[221] = -A[213] - 0.0112874779541445*G0_0_0_0 + 0.0552060285393616*G0_0_1_0 + 0.0236010902677567*G0_1_0_0 + 0.104665704665704*G0_2_0_0 + 0.0205226871893539*G0_2_1_0 - 0.262279942279941*G0_3_0_0 + 0.0738816738816743*G0_3_1_0 + 0.219797979797979*G0_4_0_0 + 0.134834054834054*G0_4_1_0 + 0.0240115440115437*G0_5_0_0 - 0.0960461760461764*G0_5_1_0 + 0.705569985569981*G0_6_0_0 + 0.0203174603174605*G0_6_1_0 + 0.0166233766233767*G0_7_0_0 - 0.123751803751804*G0_7_1_0 + 0.0221645021645018*G0_8_0_0 - 0.0738816738816729*G0_8_1_0 + 0.105281385281384*G0_9_0_0 - 0.0110822510822509*G0_9_1_0;
    A[149] = A[221] - 0.02637165303832*G0_0_0_0 - 0.0119031585698257*G0_0_0_1 + 0.00820907487574193*G0_0_1_0 + 0.0620811287477954*G0_0_1_1 + 0.0263716530383196*G0_1_0_0 + 0.0345807279140612*G0_1_0_1 + 0.0144684944684942*G0_1_1_0 - 0.0394035594035594*G0_1_1_1 + 0.010569183902517*G0_2_0_1 + 0.0105691839025173*G0_2_1_0 + 0.0105691839025171*G0_2_1_1 + 0.136681096681096*G0_3_0_0 + 0.206406926406925*G0_3_0_1 + 0.071572871572871*G0_3_1_0 + 0.214256854256853*G0_3_1_1 + 0.147763347763347*G0_4_0_0 + 0.126060606060605*G0_4_0_1 + 0.179624819624819*G0_4_1_0 + 0.158845598845599*G0_4_1_1 - 0.136681096681096*G0_5_0_0 - 0.0651082251082251*G0_5_0_1 + 0.0697258297258296*G0_5_1_0 - 0.0729581529581531*G0_5_1_1 - 0.147763347763347*G0_6_0_0 + 0.0318614718614717*G0_6_0_1 - 0.0217027417027413*G0_6_1_0 - 0.000923520923520629*G0_6_1_1 - 0.0415584415584413*G0_7_0_0 + 0.127907647907647*G0_7_0_1 + 0.122366522366523*G0_7_1_0 + 0.428513708513706*G0_7_1_1 + 0.0415584415584416*G0_8_0_0 + 0.163924963924963*G0_8_0_1 + 0.169466089466088*G0_8_1_0 - 0.136681096681096*G0_8_1_1 + 0.188398268398267*G0_9_0_1 + 0.188398268398268*G0_9_1_0 + 0.188398268398267*G0_9_1_1;
    A[179] = A[221] + 0.0347859547859544*G0_0_0_1 - 0.0347859547859544*G0_0_1_0 + 0.0548981882315216*G0_1_0_1 - 0.0548981882315216*G0_1_1_0 + 0.0109796376463042*G0_2_0_1 - 0.0109796376463042*G0_2_1_0 + 0.0881962481962476*G0_3_0_1 - 0.0881962481962476*G0_3_1_0 - 0.00600288600288611*G0_4_0_1 + 0.00600288600288611*G0_4_1_0 - 0.0466378066378068*G0_5_0_1 + 0.0466378066378068*G0_5_1_0 + 0.0475613275613272*G0_6_0_1 - 0.0475613275613271*G0_6_1_0 - 0.078037518037518*G0_7_0_1 + 0.078037518037518*G0_7_1_0 - 0.083578643578643*G0_8_0_1 + 0.083578643578643*G0_8_1_0 - 0.0221645021645021*G0_9_0_1 + 0.0221645021645021*G0_9_1_0;
    A[219] = A[149] + 0.0548981882315221*G0_0_0_1 - 0.0548981882315221*G0_0_1_0 + 0.0347859547859547*G0_1_0_1 - 0.0347859547859547*G0_1_1_0 + 0.0109796376463046*G0_2_0_1 - 0.0109796376463046*G0_2_1_0 - 0.0466378066378063*G0_3_0_1 + 0.0466378066378062*G0_3_1_0 + 0.0475613275613284*G0_4_0_1 - 0.0475613275613284*G0_4_1_0 + 0.088196248196248*G0_5_0_1 - 0.088196248196248*G0_5_1_0 - 0.00600288600288581*G0_6_0_1 + 0.00600288600288582*G0_6_1_0 - 0.0835786435786414*G0_7_0_1 + 0.0835786435786414*G0_7_1_0 - 0.078037518037518*G0_8_0_1 + 0.078037518037518*G0_8_1_0 - 0.0221645021645016*G0_9_0_1 + 0.0221645021645016*G0_9_1_0;
    A[103] = A[219] + 0.119544652877986*G0_0_0_0 - 0.119544652877985*G0_0_1_1 + 0.0380695847362514*G0_1_0_0 + 0.0317075517075517*G0_1_0_1 + 0.0555138688472019*G0_1_1_0 + 0.0455603655603653*G0_1_1_1 - 0.0455603655603652*G0_2_0_0 - 0.0317075517075514*G0_2_0_1 - 0.0555138688472016*G0_2_1_0 - 0.0380695847362509*G0_2_1_1 + 0.153304473304473*G0_3_0_0 + 0.164848484848485*G0_3_0_1 + 0.0706493506493501*G0_3_1_0 + 0.0960461760461754*G0_3_1_1 - 0.0960461760461749*G0_4_0_0 - 0.164848484848484*G0_4_0_1 - 0.0706493506493495*G0_4_1_0 - 0.153304473304473*G0_4_1_1 + 0.495007215007212*G0_5_0_0 + 0.0651082251082249*G0_5_0_1 + 0.236883116883116*G0_5_1_0 + 0.0748051948051954*G0_5_1_1 - 0.0313997113997112*G0_6_0_0 - 0.0041558441558444*G0_6_0_1 + 0.0678787878787876*G0_6_1_0 + 0.0304761904761898*G0_6_1_1 - 0.0748051948051946*G0_7_0_0 - 0.0651082251082261*G0_7_0_1 - 0.236883116883115*G0_7_1_0 - 0.495007215007212*G0_7_1_1 - 0.0304761904761904*G0_8_0_0 + 0.00415584415584557*G0_8_0_1 - 0.0678787878787876*G0_8_1_0 + 0.0313997113997115*G0_8_1_1 + 0.14961038961039*G0_9_0_0 - 0.149610389610389*G0_9_1_1;
    A[201] = A[103] - 0.0548981882315213*G0_0_0_1 + 0.0548981882315213*G0_0_1_0 - 0.0109796376463044*G0_1_0_1 + 0.0109796376463044*G0_1_1_0 - 0.0347859547859548*G0_2_0_1 + 0.0347859547859548*G0_2_1_0 - 0.0475613275613283*G0_3_0_1 + 0.0475613275613283*G0_3_1_0 + 0.0466378066378066*G0_4_0_1 - 0.0466378066378066*G0_4_1_0 + 0.083578643578643*G0_5_0_1 - 0.083578643578643*G0_5_1_0 + 0.0780375180375178*G0_6_0_1 - 0.0780375180375178*G0_6_1_0 - 0.0881962481962478*G0_7_0_1 + 0.0881962481962478*G0_7_1_0 + 0.00600288600288488*G0_8_0_1 - 0.00600288600288487*G0_8_1_0 + 0.0221645021645018*G0_9_0_1 - 0.0221645021645018*G0_9_1_0;
    A[59] = -A[179] - 0.0112874779541445*G0_0_0_0 + 0.0552060285393616*G0_0_0_1 + 0.0236010902677567*G0_1_0_0 + 0.104665704665704*G0_2_0_0 + 0.0205226871893539*G0_2_0_1 - 0.262279942279941*G0_3_0_0 + 0.0738816738816743*G0_3_0_1 + 0.219797979797979*G0_4_0_0 + 0.134834054834054*G0_4_0_1 + 0.0240115440115437*G0_5_0_0 - 0.0960461760461764*G0_5_0_1 + 0.705569985569981*G0_6_0_0 + 0.0203174603174605*G0_6_0_1 + 0.0166233766233767*G0_7_0_0 - 0.123751803751804*G0_7_0_1 + 0.0221645021645018*G0_8_0_0 - 0.0738816738816729*G0_8_0_1 + 0.105281385281384*G0_9_0_0 - 0.0110822510822509*G0_9_0_1;
    A[196] = A[28] - 0.0124803591470257*G0_0_0_1 + 0.0124803591470257*G0_0_1_0 + 0.0124803591470257*G0_2_0_1 - 0.0124803591470257*G0_2_1_0 + 0.102741702741702*G0_3_0_1 - 0.102741702741702*G0_3_1_0 - 0.058297258297258*G0_4_0_1 + 0.058297258297258*G0_4_1_0 + 0.00242424242424242*G0_5_0_1 - 0.00242424242424242*G0_5_1_0 - 0.00242424242424254*G0_6_0_1 + 0.00242424242424254*G0_6_1_0 + 0.058297258297258*G0_7_0_1 - 0.058297258297258*G0_7_1_0 - 0.102741702741702*G0_8_0_1 + 0.102741702741702*G0_8_1_0;
    A[209] = A[223] - 0.0837325637325635*G0_0_0_1 + 0.0837325637325635*G0_0_1_0 - 0.00246272246272236*G0_1_0_1 + 0.00246272246272236*G0_1_1_0 - 0.00246272246272179*G0_2_0_1 + 0.00246272246272179*G0_2_1_0 - 0.321385281385281*G0_3_0_1 + 0.321385281385281*G0_3_1_0 - 0.321385281385281*G0_4_0_1 + 0.321385281385281*G0_4_1_0 + 0.166233766233766*G0_5_0_1 - 0.166233766233766*G0_5_1_0 - 0.199480519480518*G0_6_0_1 + 0.199480519480518*G0_6_1_0 + 0.166233766233767*G0_7_0_1 - 0.166233766233767*G0_7_1_0 - 0.199480519480518*G0_8_0_1 + 0.199480519480518*G0_8_1_0 + 0.797922077922075*G0_9_0_1 - 0.797922077922075*G0_9_1_0;
    A[117] = A[209] + 0.0760750360750359*G0_0_0_0 + 0.0673785473785474*G0_0_0_1 - 0.0413660413660408*G0_0_1_0 - 0.168273208273207*G0_0_1_1 + 0.13079365079365*G0_1_0_0 + 0.123828763828763*G0_1_0_1 + 0.1202886002886*G0_1_1_0 + 0.0937373737373733*G0_1_1_1 + 0.147763347763347*G0_2_0_0 + 0.114824434824434*G0_2_0_1 + 0.117671957671958*G0_2_1_0 + 0.139413179413179*G0_2_1_1 - 0.413506493506491*G0_3_0_0 - 0.247272727272725*G0_3_0_1 - 0.557922077922075*G0_3_1_0 - 0.180779220779218*G0_3_1_1 + 0.317922077922077*G0_4_0_0 + 0.372987012987012*G0_4_0_1 - 0.0145454545454555*G0_4_1_0 + 0.0955844155844146*G0_4_1_1 - 0.126753246753247*G0_5_0_0 + 0.822510822510819*G0_5_1_0 - 0.17073593073593*G0_5_1_1 + 0.7625974025974*G0_6_0_0 + 0.4*G0_6_0_1 - 0.0387878787878777*G0_6_1_0 + 0.298874458874458*G0_6_1_1 + 0.00519480519480527*G0_7_0_0 + 0.0772294372294361*G0_7_0_1 + 0.144761904761905*G0_7_1_0 - 0.563809523809521*G0_7_1_1 - 0.0550649350649347*G0_8_0_0 - 0.0277056277056275*G0_8_0_1 - 0.244848484848483*G0_8_1_0 + 0.905281385281381*G0_8_1_1 + 0.374025974025973*G0_9_0_0 - 0.525714285714283*G0_9_0_1 + 0.0477922077922091*G0_9_1_0 + 0.261818181818181*G0_9_1_1;
    A[110] = -A[117] + 0.112720859387526*G0_0_0_0 + 0.0472150072150074*G0_0_0_1 + 0.0099791566458238*G0_0_1_0 - 0.157113997113996*G0_0_1_1 + 0.0486644219977551*G0_1_0_0 + 0.0657239057239054*G0_1_0_1 + 0.0718807118807117*G0_1_1_0 + 0.528715728715726*G0_2_0_0 + 0.204329004329003*G0_2_0_1 + 0.451165624498955*G0_2_1_0 + 0.157113997113996*G0_2_1_1 - 0.200404040404039*G0_3_0_0 - 0.204329004329003*G0_3_0_1 - 0.228571428571427*G0_3_1_0 - 0.107359307359307*G0_3_1_1 + 0.891890331890327*G0_4_0_0 + 0.967272727272723*G0_4_0_1 + 0.783376623376619*G0_4_1_0 + 0.815930735930731*G0_4_1_1 - 0.330158730158729*G0_5_0_0 + 0.0422510822510816*G0_5_0_1 + 0.729350649350646*G0_5_1_0 - 0.213679653679652*G0_5_1_1 - 0.116132756132757*G0_6_0_0 + 0.255930735930735*G0_6_0_1 - 0.0907359307359315*G0_6_1_0 + 0.213679653679652*G0_6_1_1 - 0.0147763347763348*G0_7_0_0 + 0.151341991341991*G0_7_0_1 + 0.0491774891774896*G0_7_1_0 - 0.815930735930731*G0_7_1_1 - 0.0404040404040402*G0_8_0_0 - 0.0969696969696969*G0_8_0_1 - 0.119134199134199*G0_8_1_0 + 0.107359307359307*G0_8_1_1 + 0.288138528138527*G0_9_0_0 + 0.607445887445885*G0_9_0_1 + 0.383722943722944*G0_9_1_0;
    A[65] = -A[110] - 0.0154433221099887*G0_0_0_0 + 0.0420202020202021*G0_0_0_1 - 0.0134423601090267*G0_0_1_0 - 0.0334776334776332*G0_0_1_1 + 0.0154433221099887*G0_1_0_0 + 0.00923520923520917*G0_1_0_1 + 0.00200096200096211*G0_1_1_0 - 0.168388648388648*G0_1_1_1 + 0.0815776815776813*G0_2_0_1 + 0.322975789642455*G0_2_1_0 + 0.0642616642616639*G0_2_1_1 - 0.115440115440115*G0_3_0_0 - 0.0845021645021641*G0_3_0_1 - 0.0701875901875895*G0_3_1_0 - 0.172467532467532*G0_3_1_1 + 0.52178932178932*G0_4_0_0 + 1.17748917748917*G0_4_0_1 + 0.250505050505049*G0_4_1_0 + 0.490389610389608*G0_4_1_1 + 0.115440115440115*G0_5_0_0 - 0.126060606060606*G0_5_0_1 + 0.045252525252525*G0_5_1_0 + 0.0055411255411258*G0_5_1_1 - 0.52178932178932*G0_6_0_0 - 0.271284271284271*G0_6_1_0 - 0.137142857142857*G0_6_1_1 - 0.00138528138528146*G0_7_0_0 - 0.0609523809523806*G0_7_0_1 + 0.00438672438672437*G0_7_1_0 - 0.00415584415584344*G0_7_1_1 + 0.00138528138528137*G0_8_0_0 - 0.00415584415584403*G0_8_0_1 + 0.00577200577200615*G0_8_1_0 - 0.302683982683982*G0_8_1_1 + 0.252121212121211*G0_9_0_1 - 0.106666666666666*G0_9_1_0 - 0.30060606060606*G0_9_1_1;
    A[113] = -A[110] - 0.00224466891133567*G0_0_0_1 - 0.178483245149911*G0_0_1_1 - 0.0504729838063174*G0_1_0_1 - 0.0696488696488697*G0_1_1_1 - 0.24165464165464*G0_2_0_1 - 0.258842392175724*G0_2_1_1 + 0.175468975468975*G0_3_0_1 + 0.193593073593073*G0_3_1_1 - 0.0461760461760465*G0_4_0_1 - 0.107359307359308*G0_4_1_1 + 0.0184704184704186*G0_5_0_1 - 0.145800865800865*G0_5_1_1 - 0.701875901875901*G0_6_0_1 - 0.491774891774892*G0_6_1_1 + 0.017893217893218*G0_7_0_1 - 0.391341991341989*G0_7_1_1 + 0.0733044733044727*G0_8_0_1 + 0.157575757575757*G0_8_1_1 - 0.36017316017316*G0_9_0_1 - 0.553419913419912*G0_9_1_1;
    A[97] = A[113] - 0.0510117043450376*G0_0_0_0 + 0.0242552509219171*G0_0_0_1 + 0.00991502324835675*G0_0_1_0 - 0.221119127785793*G0_0_1_1 + 0.007452300785634*G0_1_0_0 + 0.00745230078563412*G0_1_0_1 + 0.00745230078563399*G0_1_1_0 + 0.306301106301104*G0_2_0_0 + 0.23103415103415*G0_2_0_1 + 0.24537437870771*G0_2_1_0 + 0.221119127785793*G0_2_1_1 - 0.0708802308802302*G0_3_0_0 - 0.104126984126984*G0_3_0_1 - 0.0324386724386719*G0_3_1_0 - 0.0955844155844151*G0_3_1_1 + 0.138297258297257*G0_4_0_0 + 0.217258297258297*G0_4_0_1 + 0.0389033189033181*G0_4_1_0 + 0.156536796536796*G0_4_1_1 + 0.0985858585858588*G0_5_0_0 - 0.612063492063489*G0_5_0_1 + 0.246464646464646*G0_5_1_0 - 0.270476190476189*G0_5_1_1 - 0.193708513708515*G0_6_0_0 + 0.516940836940836*G0_6_0_1 - 0.341587301587301*G0_6_1_0 + 0.27047619047619*G0_6_1_1 - 0.0386724386724384*G0_7_0_0 - 0.117633477633478*G0_7_0_1 + 0.0607215007215008*G0_7_1_0 - 0.156536796536796*G0_7_1_1 + 0.0298989898989898*G0_8_0_0 + 0.0631457431457433*G0_8_0_1 - 0.00854256854256865*G0_8_1_0 + 0.0955844155844151*G0_8_1_1 - 0.124675324675325*G0_9_0_0 - 0.124675324675324*G0_9_0_1 - 0.124675324675324*G0_9_1_0;
    A[111] = A[97] + 0.000128266794934129*G0_0_0_1 - 0.000128266794934139*G0_0_1_0 + 0.0432387365720698*G0_1_0_1 - 0.0432387365720698*G0_1_1_0 + 0.0144684944684942*G0_2_0_1 - 0.0144684944684942*G0_2_1_0 - 0.0688023088023083*G0_3_0_1 + 0.0688023088023083*G0_3_1_0 - 0.0144300144300147*G0_4_0_1 + 0.0144300144300147*G0_4_1_0 + 0.809235209235206*G0_5_0_1 - 0.809235209235206*G0_5_1_0 - 0.0492929292929294*G0_6_0_1 + 0.0492929292929294*G0_6_1_0 + 0.163924963924964*G0_7_0_1 - 0.163924963924964*G0_7_1_0 - 0.14049062049062*G0_8_0_1 + 0.14049062049062*G0_8_1_0 + 0.359480519480519*G0_9_0_1 - 0.359480519480519*G0_9_1_0;
    A[159] = A[97] - 0.323104056437389*G0_0_0_0 + 0.323104056437388*G0_0_1_1 - 0.145005611672278*G0_1_0_0 - 0.115209235209234*G0_1_0_1 - 0.14397947731281*G0_1_1_0 - 0.0987397787397779*G0_1_1_1 + 0.0987397787397778*G0_2_0_0 + 0.115209235209234*G0_2_0_1 + 0.14397947731281*G0_2_1_0 + 0.145005611672278*G0_2_1_1 - 0.387186147186145*G0_3_0_0 - 0.451601731601729*G0_3_0_1 - 0.397229437229435*G0_3_1_0 - 0.460259740259737*G0_3_1_1 + 0.460259740259738*G0_4_0_0 + 0.451601731601729*G0_4_0_1 + 0.397229437229435*G0_4_1_0 + 0.387186147186145*G0_4_1_1 - 0.597748917748915*G0_5_0_0 + 0.46199134199134*G0_5_0_1 - 0.183318903318903*G0_5_1_0 + 0.354632034632033*G0_5_1_1 + 0.366060606060605*G0_6_0_0 + 0.246580086580085*G0_6_0_1 + 0.155382395382395*G0_6_1_0 + 0.151341991341991*G0_6_1_1 - 0.354632034632033*G0_7_0_0 - 0.461991341991338*G0_7_0_1 + 0.183318903318902*G0_7_1_0 + 0.597748917748915*G0_7_1_1 - 0.151341991341991*G0_8_0_0 - 0.246580086580086*G0_8_0_1 - 0.155382395382395*G0_8_1_0 - 0.366060606060604*G0_8_1_1 - 0.252813852813852*G0_9_0_0 + 0.252813852813852*G0_9_1_1;
    A[79] = A[65] - 0.0432387365720699*G0_0_0_1 + 0.0432387365720699*G0_0_1_0 - 0.0144684944684945*G0_1_0_1 + 0.0144684944684945*G0_1_1_0 - 0.000128266794933191*G0_2_0_1 + 0.000128266794933204*G0_2_1_0 + 0.0492929292929292*G0_3_0_1 - 0.0492929292929292*G0_3_1_0 - 0.809235209235206*G0_4_0_1 + 0.809235209235206*G0_4_1_0 + 0.14049062049062*G0_5_0_1 - 0.14049062049062*G0_5_1_0 - 0.163924963924963*G0_6_0_1 + 0.163924963924963*G0_6_1_0 + 0.0688023088023084*G0_7_0_1 - 0.0688023088023084*G0_7_1_0 + 0.0144300144300144*G0_8_0_1 - 0.0144300144300144*G0_8_1_0 - 0.359480519480519*G0_9_0_1 + 0.359480519480519*G0_9_1_0;
    A[187] = A[117] - 0.0250120250120247*G0_0_0_1 + 0.0250120250120247*G0_0_1_0 - 0.00107744107744114*G0_1_0_1 + 0.00107744107744114*G0_1_1_0 + 0.00531024531024547*G0_2_0_1 - 0.00531024531024547*G0_2_1_0 + 0.0107359307359308*G0_3_0_1 - 0.0107359307359308*G0_3_1_0 - 0.0661471861471865*G0_4_0_1 + 0.0661471861471865*G0_4_1_0 + 0.656277056277054*G0_5_0_1 - 0.656277056277054*G0_5_1_0 - 0.239307359307359*G0_6_0_1 + 0.239307359307359*G0_6_1_0 - 0.0987012987012977*G0_7_0_1 + 0.0987012987012977*G0_7_1_0 - 0.0176623376623378*G0_8_0_1 + 0.0176623376623377*G0_8_1_0 - 0.224415584415583*G0_9_0_1 + 0.224415584415583*G0_9_1_0;
    A[82] = A[110] - 0.0122238255571588*G0_0_0_1 + 0.0122238255571588*G0_0_1_0 + 0.00723424723424742*G0_1_0_1 - 0.00723424723424743*G0_1_1_0 + 0.241526374859707*G0_2_0_1 - 0.241526374859707*G0_2_1_0 - 0.0349783549783545*G0_3_0_1 + 0.0349783549783545*G0_3_1_0 - 0.117748917748917*G0_4_0_1 + 0.117748917748917*G0_4_1_0 + 0.0308225108225107*G0_5_0_1 - 0.0308225108225107*G0_5_1_0 - 0.107359307359307*G0_6_0_1 + 0.107359307359307*G0_6_1_0 - 0.00346320346320343*G0_7_0_1 + 0.00346320346320344*G0_7_1_0 - 0.0045021645021642*G0_8_0_1 + 0.0045021645021642*G0_8_1_0 + 0.000692640692641085*G0_9_0_1 - 0.000692640692641126*G0_9_1_0;
    A[153] = A[82] - 0.0254866121532787*G0_0_0_0 + 0.0254866121532786*G0_0_1_1 + 0.0998300464967124*G0_1_0_0 + 0.381901555234887*G0_1_0_1 + 0.147609427609427*G0_1_1_0 + 0.474689754689752*G0_1_1_1 - 0.474689754689752*G0_2_0_0 - 0.381901555234886*G0_2_0_1 - 0.147609427609427*G0_2_1_0 - 0.0998300464967124*G0_2_1_1 + 0.507243867243864*G0_3_0_0 + 0.468571428571426*G0_3_0_1 + 0.551341991341988*G0_3_1_0 + 0.500548340548337*G0_3_1_1 - 0.500548340548337*G0_4_0_0 - 0.468571428571426*G0_4_0_1 - 0.551341991341988*G0_4_1_0 - 0.507243867243864*G0_4_1_1 - 0.0487157287157287*G0_5_0_0 - 0.00242424242424275*G0_5_0_1 + 0.0318614718614717*G0_5_1_0 + 0.0229725829725825*G0_5_1_1 + 0.0808080808080817*G0_6_0_0 + 0.177662337662338*G0_6_0_1 + 0.0748051948051956*G0_6_1_0 + 0.0998556998557001*G0_6_1_1 - 0.022972582972583*G0_7_0_0 + 0.00242424242424191*G0_7_0_1 - 0.0318614718614718*G0_7_1_0 + 0.0487157287157281*G0_7_1_1 - 0.0998556998556992*G0_8_0_0 - 0.177662337662336*G0_8_0_1 - 0.0748051948051942*G0_8_1_0 - 0.0808080808080797*G0_8_1_1 - 0.175930735930735*G0_9_0_0 + 0.175930735930736*G0_9_1_1;
    A[68] = -A[65] + 0.0504729838063172*G0_0_0_1 - 0.0191758858425523*G0_0_1_1 + 0.00224466891133576*G0_1_0_1 - 0.176238576238576*G0_1_1_1 + 0.24165464165464*G0_2_0_1 - 0.0171877505210841*G0_2_1_1 - 0.0184704184704181*G0_3_0_1 - 0.164271284271284*G0_3_1_1 + 0.701875901875899*G0_4_0_1 + 0.21010101010101*G0_4_1_1 - 0.175468975468975*G0_5_0_1 + 0.0181240981240983*G0_5_1_1 + 0.0461760461760452*G0_6_0_1 - 0.0611832611832617*G0_6_1_1 - 0.0733044733044727*G0_7_0_1 + 0.0842712842712848*G0_7_1_1 - 0.0178932178932174*G0_8_0_1 - 0.409235209235208*G0_8_1_1 + 0.36017316017316*G0_9_0_1 - 0.193246753246752*G0_9_1_1;
    A[169] = A[68] - 0.0266281866281864*G0_0_0_0 + 0.0266281866281864*G0_0_1_1 + 0.0338239538239534*G0_1_0_0 + 0.314676928010261*G0_1_0_1 + 0.0609267275933936*G0_1_1_0 + 0.482539682539681*G0_1_1_1 - 0.482539682539679*G0_2_0_0 - 0.314676928010259*G0_2_0_1 - 0.0609267275933933*G0_2_1_0 - 0.0338239538239531*G0_2_1_1 + 0.11151515151515*G0_3_0_0 + 0.00969696969696993*G0_3_0_1 + 0.147878787878787*G0_3_1_0 - 0.0294372294372289*G0_3_1_1 + 0.0294372294372308*G0_4_0_0 - 0.00969696969696889*G0_4_0_1 - 0.147878787878786*G0_4_1_0 - 0.11151515151515*G0_4_1_1 + 0.155151515151514*G0_5_0_0 + 0.0689177489177479*G0_5_0_1 + 0.038441558441558*G0_5_1_0 + 0.0117748917748913*G0_5_1_1 - 0.547532467532464*G0_6_0_0 + 0.0148917748917761*G0_6_0_1 - 0.0993939393939386*G0_6_1_0 + 0.0225108225108233*G0_6_1_1 - 0.0117748917748918*G0_7_0_0 - 0.0689177489177492*G0_7_0_1 - 0.0384415584415582*G0_7_1_0 - 0.155151515151515*G0_7_1_1 - 0.0225108225108223*G0_8_0_0 - 0.0148917748917744*G0_8_0_1 + 0.0993939393939387*G0_8_1_0 + 0.547532467532465*G0_8_1_1 - 0.0685714285714278*G0_9_0_0 + 0.0685714285714287*G0_9_1_1;
    A[71] = A[169] - 0.00723424723424741*G0_0_0_1 + 0.00723424723424741*G0_0_1_0 - 0.241526374859708*G0_1_0_1 + 0.241526374859708*G0_1_1_0 + 0.0122238255571587*G0_2_0_1 - 0.0122238255571587*G0_2_1_0 + 0.107359307359306*G0_3_0_1 - 0.107359307359306*G0_3_1_0 - 0.0308225108225105*G0_4_0_1 + 0.0308225108225105*G0_4_1_0 + 0.00450216450216461*G0_5_0_1 - 0.00450216450216461*G0_5_1_0 + 0.00346320346320344*G0_6_0_1 - 0.00346320346320344*G0_6_1_0 + 0.0349783549783552*G0_7_0_1 - 0.0349783549783552*G0_7_1_0 + 0.117748917748916*G0_8_0_1 - 0.117748917748916*G0_8_1_0 - 0.000692640692640932*G0_9_0_1 + 0.000692640692640974*G0_9_1_0;
    A[55] = A[153] + 0.0122238255571588*G0_0_0_1 - 0.0122238255571588*G0_0_1_0 - 0.241526374859708*G0_1_0_1 + 0.241526374859708*G0_1_1_0 - 0.00723424723424722*G0_2_0_1 + 0.00723424723424722*G0_2_1_0 + 0.117748917748916*G0_3_0_1 - 0.117748917748916*G0_3_1_0 + 0.0349783549783551*G0_4_0_1 - 0.0349783549783551*G0_4_1_0 + 0.0034632034632037*G0_5_0_1 - 0.0034632034632037*G0_5_1_0 + 0.00450216450216467*G0_6_0_1 - 0.00450216450216467*G0_6_1_0 - 0.0308225108225103*G0_7_0_1 + 0.0308225108225103*G0_7_1_0 + 0.107359307359306*G0_8_0_1 - 0.107359307359306*G0_8_1_0 - 0.000692640692640877*G0_9_0_1 + 0.000692640692640877*G0_9_1_0;
    A[175] = -A[55] - 0.178483245149911*G0_0_0_0 - 0.00224466891133563*G0_0_0_1 - 0.258842392175725*G0_1_0_0 - 0.241654641654641*G0_1_0_1 - 0.0696488696488694*G0_2_0_0 - 0.0504729838063168*G0_2_0_1 - 0.107359307359307*G0_3_0_0 - 0.0461760461760458*G0_3_0_1 + 0.193593073593073*G0_4_0_0 + 0.175468975468975*G0_4_0_1 - 0.391341991341989*G0_5_0_0 + 0.0178932178932179*G0_5_0_1 + 0.157575757575757*G0_6_0_0 + 0.0733044733044732*G0_6_0_1 - 0.145800865800865*G0_7_0_0 + 0.0184704184704184*G0_7_0_1 - 0.49177489177489*G0_8_0_0 - 0.701875901875899*G0_8_0_1 - 0.553419913419912*G0_9_0_0 - 0.360173160173159*G0_9_0_1;
    A[127] = A[113] + 0.0144684944684945*G0_0_0_1 - 0.0144684944684945*G0_0_1_0 + 0.0432387365720699*G0_1_0_1 - 0.0432387365720699*G0_1_1_0 + 0.000128266794933551*G0_2_0_1 - 0.000128266794933662*G0_2_1_0 - 0.14049062049062*G0_3_0_1 + 0.14049062049062*G0_3_1_0 + 0.163924963924964*G0_4_0_1 - 0.163924963924964*G0_4_1_0 - 0.0492929292929294*G0_5_0_1 + 0.0492929292929294*G0_5_1_0 + 0.809235209235208*G0_6_0_1 - 0.809235209235208*G0_6_1_0 - 0.0144300144300146*G0_7_0_1 + 0.0144300144300146*G0_7_1_0 - 0.0688023088023084*G0_8_0_1 + 0.0688023088023084*G0_8_1_0 + 0.359480519480518*G0_9_0_1 - 0.359480519480519*G0_9_1_0;
    A[49] = -A[169] - 0.0191758858425525*G0_0_0_0 + 0.0504729838063173*G0_0_0_1 - 0.0171877505210841*G0_1_0_0 + 0.241654641654642*G0_1_0_1 - 0.176238576238575*G0_2_0_0 + 0.00224466891133572*G0_2_0_1 + 0.210101010101008*G0_3_0_0 + 0.7018759018759*G0_3_0_1 - 0.164271284271283*G0_4_0_0 - 0.0184704184704184*G0_4_0_1 + 0.084271284271284*G0_5_0_0 - 0.0733044733044732*G0_5_0_1 - 0.409235209235207*G0_6_0_0 - 0.0178932178932179*G0_6_0_1 + 0.0181240981240981*G0_7_0_0 - 0.175468975468975*G0_7_0_1 - 0.0611832611832607*G0_8_0_0 + 0.0461760461760471*G0_8_0_1 - 0.193246753246753*G0_9_0_0 + 0.36017316017316*G0_9_0_1;
    A[124] = -A[79] + 0.0504729838063172*G0_0_1_0 - 0.0191758858425523*G0_0_1_1 + 0.00224466891133576*G0_1_1_0 - 0.176238576238576*G0_1_1_1 + 0.24165464165464*G0_2_1_0 - 0.017187750521084*G0_2_1_1 - 0.0184704184704181*G0_3_1_0 - 0.164271284271284*G0_3_1_1 + 0.701875901875899*G0_4_1_0 + 0.21010101010101*G0_4_1_1 - 0.175468975468975*G0_5_1_0 + 0.0181240981240983*G0_5_1_1 + 0.0461760461760452*G0_6_1_0 - 0.0611832611832617*G0_6_1_1 - 0.0733044733044727*G0_7_1_0 + 0.0842712842712848*G0_7_1_1 - 0.0178932178932174*G0_8_1_0 - 0.409235209235208*G0_8_1_1 + 0.36017316017316*G0_9_1_0 - 0.193246753246752*G0_9_1_1;
    A[161] = -A[153] - 0.178483245149911*G0_0_0_0 - 0.00224466891133563*G0_0_1_0 - 0.258842392175725*G0_1_0_0 - 0.241654641654641*G0_1_1_0 - 0.0696488696488694*G0_2_0_0 - 0.0504729838063168*G0_2_1_0 - 0.107359307359307*G0_3_0_0 - 0.0461760461760457*G0_3_1_0 + 0.193593073593073*G0_4_0_0 + 0.175468975468975*G0_4_1_0 - 0.391341991341989*G0_5_0_0 + 0.0178932178932179*G0_5_1_0 + 0.157575757575757*G0_6_0_0 + 0.0733044733044732*G0_6_1_0 - 0.145800865800865*G0_7_0_0 + 0.0184704184704183*G0_7_1_0 - 0.49177489177489*G0_8_0_0 - 0.701875901875899*G0_8_1_0 - 0.553419913419912*G0_9_0_0 - 0.360173160173159*G0_9_1_0;
    A[162] = A[187] - 0.244348244348243*G0_0_0_0 + 0.244348244348243*G0_0_1_1 + 0.00861952861952884*G0_1_0_0 - 0.00261664261664281*G0_1_0_1 - 0.00900432900432897*G0_1_1_0 + 0.0540259740259736*G0_1_1_1 - 0.0540259740259742*G0_2_0_0 + 0.00261664261664205*G0_2_0_1 + 0.00900432900432872*G0_2_1_0 - 0.00861952861952881*G0_2_1_1 + 0.509090909090906*G0_3_0_0 + 0.54337662337662*G0_3_0_1 + 0.620259740259737*G0_3_1_0 + 0.498701298701296*G0_3_1_1 - 0.498701298701297*G0_4_0_0 - 0.543376623376621*G0_4_0_1 - 0.620259740259738*G0_4_1_0 - 0.509090909090907*G0_4_1_1 - 0.437056277056273*G0_5_0_0 - 0.677748917748915*G0_5_0_1 + 0.0772294372294384*G0_5_1_0 + 0.175930735930735*G0_5_1_1 + 0.142683982683982*G0_6_0_0 - 0.206060606060605*G0_6_0_1 - 0.427705627705627*G0_6_1_0 - 0.353939393939393*G0_6_1_1 - 0.175930735930735*G0_7_0_0 + 0.677748917748913*G0_7_0_1 - 0.0772294372294369*G0_7_1_0 + 0.437056277056274*G0_7_1_1 + 0.353939393939393*G0_8_0_0 + 0.206060606060605*G0_8_0_1 + 0.427705627705626*G0_8_1_0 - 0.142683982683982*G0_8_1_1 - 0.112207792207792*G0_9_0_0 + 0.112207792207791*G0_9_1_1;
    A[214] = A[162] + 0.0538720538720527*G0_0_0_0 - 0.0477152477152477*G0_0_0_1 - 0.0716498316498316*G0_0_1_0 - 0.079499759499759*G0_0_1_1 - 0.0453294853294856*G0_1_0_0 - 0.0453294853294854*G0_1_0_1 - 0.0453294853294856*G0_1_1_0 - 0.0937373737373726*G0_2_0_0 + 0.00784992784992808*G0_2_0_1 + 0.0317845117845111*G0_2_1_0 + 0.0794997594997588*G0_2_1_1 - 0.603290043290039*G0_3_0_0 - 0.797575757575753*G0_3_0_1 - 0.62441558441558*G0_3_1_0 - 0.486233766233762*G0_3_1_1 - 1.21627705627705*G0_4_0_0 - 0.244848484848485*G0_4_0_1 - 0.890389610389607*G0_4_1_0 - 0.245194805194805*G0_4_1_1 + 1.01056277056276*G0_5_0_0 + 0.0162770562770565*G0_5_0_1 - 0.0647619047619049*G0_5_1_0 - 0.0270129870129869*G0_5_1_1 - 1.03203463203463*G0_6_0_0 - 0.0377489177489187*G0_6_0_1 + 0.0432900432900422*G0_6_1_0 + 0.027012987012987*G0_6_1_1 + 0.326233766233765*G0_7_0_0 - 0.645194805194801*G0_7_0_1 + 0.000346320346319942*G0_7_1_0 + 0.245194805194804*G0_7_1_1 - 0.332467532467531*G0_8_0_0 - 0.138181818181817*G0_8_0_1 - 0.311341991341991*G0_8_1_0 + 0.486233766233764*G0_8_1_1 - 0.810389610389608*G0_9_0_0 - 0.810389610389608*G0_9_0_1 - 0.810389610389609*G0_9_1_0;
    A[100] = -A[162] - 0.016354016354016*G0_0_0_0 - 0.017123617123617*G0_0_0_1 - 0.2336379669713*G0_0_1_0 + 0.146544813211479*G0_0_1_1 + 0.0163540163540165*G0_1_0_0 + 0.0295526695526694*G0_1_0_1 + 0.0364662497995832*G0_1_1_0 + 0.046176046176046*G0_1_1_1 + 0.0452525252525248*G0_2_0_1 + 0.039095719095719*G0_2_1_0 + 0.0220362353695686*G0_2_1_1 + 0.375411255411253*G0_3_0_0 + 0.335238095238093*G0_3_0_1 + 0.404848484848482*G0_3_1_0 + 0.344357864357862*G0_3_1_1 - 0.0477922077922075*G0_4_0_0 - 0.111861471861471*G0_4_0_1 - 0.118095238095238*G0_4_1_0 - 0.0452525252525251*G0_4_1_1 - 0.375411255411253*G0_5_0_0 - 0.0727272727272733*G0_5_0_1 + 0.143722943722943*G0_5_1_0 - 0.0372871572871579*G0_5_1_1 + 0.0477922077922076*G0_6_0_0 - 0.0924675324675317*G0_6_0_1 - 0.0398268398268394*G0_6_1_0 - 0.0521789321789319*G0_6_1_1 - 0.289177489177487*G0_7_0_0 + 0.692987012987009*G0_7_0_1 + 0.144069264069263*G0_7_1_0 - 0.218643578643578*G0_7_1_1 + 0.289177489177488*G0_8_0_0 + 0.0865800865800853*G0_8_0_1 + 0.295064935064934*G0_8_1_0 - 0.0866955266955264*G0_8_1_1 + 0.315151515151514*G0_9_0_1 + 0.538874458874457*G0_9_1_0 + 0.219567099567099*G0_9_1_1;
    A[163] = A[162] + 0.173468013468012*G0_0_0_0 - 0.0354016354016355*G0_0_0_1 - 0.0551034151034148*G0_0_1_0 - 0.116209716209715*G0_0_1_1 - 0.173468013468013*G0_1_0_0 - 0.208869648869648*G0_1_0_1 - 0.228571428571427*G0_1_1_0 - 0.147763347763347*G0_1_1_1 - 0.109898989898989*G0_2_0_1 - 0.112053872053871*G0_2_1_0 - 0.11097643097643*G0_2_1_1 - 1.19134199134198*G0_3_0_0 - 1.20380952380952*G0_3_0_1 - 1.368658008658*G0_3_1_0 - 1.37558441558441*G0_3_1_1 + 0.155151515151514*G0_4_0_0 + 0.333852813852812*G0_4_0_1 + 0.326926406926405*G0_4_1_0 + 0.328311688311687*G0_4_1_1 + 1.19134199134198*G0_5_0_0 - 0.0124675324675322*G0_5_0_1 - 0.177316017316018*G0_5_1_0 - 0.00554112554112551*G0_5_1_1 - 0.155151515151514*G0_6_0_0 + 0.178701298701298*G0_6_0_1 + 0.171774891774891*G0_6_1_0 + 0.177316017316017*G0_6_1_1 + 0.50285714285714*G0_7_0_0 - 0.495930735930733*G0_7_0_1 - 0.0789610389610385*G0_7_1_0 + 0.15099567099567*G0_7_1_1 - 0.502857142857141*G0_8_0_0 - 0.998787878787874*G0_8_0_1 - 0.581818181818179*G0_8_1_0 - 1.22874458874458*G0_8_1_1 - 0.698181818181816*G0_9_0_1 - 1.14701298701298*G0_9_1_0 - 0.922597402597399*G0_9_1_1;
    A[205] = A[163] + 0.00531024531024563*G0_0_0_1 - 0.00531024531024563*G0_0_1_0 - 0.0250120250120247*G0_1_0_1 + 0.0250120250120247*G0_1_1_0 - 0.00107744107744093*G0_2_0_1 + 0.00107744107744095*G0_2_1_0 - 0.0987012987012977*G0_3_0_1 + 0.0987012987012977*G0_3_1_0 - 0.0176623376623378*G0_4_0_1 + 0.0176623376623379*G0_4_1_0 - 0.0661471861471861*G0_5_0_1 + 0.066147186147186*G0_5_1_0 + 0.0107359307359303*G0_6_0_1 - 0.0107359307359302*G0_6_1_0 - 0.239307359307358*G0_7_0_1 + 0.239307359307358*G0_7_1_0 + 0.656277056277053*G0_8_0_1 - 0.656277056277053*G0_8_1_0 - 0.224415584415584*G0_9_0_1 + 0.224415584415584*G0_9_1_0;
    A[119] = A[205] - 0.0453294853294856*G0_0_0_0 + 0.0453294853294854*G0_0_1_1 + 0.0538720538720531*G0_1_0_0 + 0.125521885521885*G0_1_0_1 + 0.101587301587301*G0_1_1_0 + 0.0937373737373732*G0_1_1_1 - 0.0937373737373744*G0_2_0_0 - 0.125521885521885*G0_2_0_1 - 0.101587301587302*G0_2_1_0 - 0.0538720538720537*G0_2_1_1 + 1.01056277056276*G0_3_0_0 + 1.07532467532467*G0_3_0_1 + 0.994285714285709*G0_3_1_0 + 1.03203463203463*G0_3_1_1 - 1.03203463203463*G0_4_0_0 - 1.07532467532467*G0_4_0_1 - 0.99428571428571*G0_4_1_0 - 1.01056277056276*G0_4_1_1 - 0.603290043290039*G0_5_0_0 + 0.0211255411255417*G0_5_0_1 + 0.194285714285714*G0_5_1_0 + 0.332467532467532*G0_5_1_1 - 1.21627705627705*G0_6_0_0 - 0.325887445887444*G0_6_0_1 - 0.97142857142857*G0_6_1_0 - 0.326233766233765*G0_6_1_1 - 0.332467532467531*G0_7_0_0 - 0.0211255411255412*G0_7_0_1 - 0.194285714285712*G0_7_1_0 + 0.603290043290041*G0_7_1_1 + 0.326233766233765*G0_8_0_0 + 0.325887445887445*G0_8_0_1 + 0.971428571428567*G0_8_1_0 + 1.21627705627705*G0_8_1_1 - 0.810389610389607*G0_9_0_0 + 0.810389610389607*G0_9_1_1;
    A[217] = A[119] - 0.00531024531024483*G0_0_0_1 + 0.00531024531024483*G0_0_1_0 + 0.00107744107744086*G0_1_0_1 - 0.00107744107744087*G0_1_1_0 + 0.025012025012024*G0_2_0_1 - 0.0250120250120241*G0_2_1_0 + 0.0176623376623379*G0_3_0_1 - 0.0176623376623379*G0_3_1_0 + 0.0987012987012977*G0_4_0_1 - 0.0987012987012976*G0_4_1_0 + 0.239307359307359*G0_5_0_1 - 0.239307359307359*G0_5_1_0 - 0.656277056277056*G0_6_0_1 + 0.656277056277056*G0_6_1_0 + 0.0661471861471866*G0_7_0_1 - 0.0661471861471866*G0_7_1_0 - 0.0107359307359313*G0_8_0_1 + 0.0107359307359313*G0_8_1_0 + 0.224415584415583*G0_9_0_1 - 0.224415584415583*G0_9_1_0;
    A[156] = A[100] - 0.241526374859708*G0_0_0_1 + 0.241526374859708*G0_0_1_0 + 0.0122238255571589*G0_1_0_1 - 0.0122238255571589*G0_1_1_0 - 0.00723424723424707*G0_2_0_1 + 0.00723424723424707*G0_2_1_0 + 0.00346320346320381*G0_3_0_1 - 0.00346320346320382*G0_3_1_0 + 0.00450216450216448*G0_4_0_1 - 0.00450216450216448*G0_4_1_0 + 0.117748917748917*G0_5_0_1 - 0.117748917748917*G0_5_1_0 + 0.0349783549783548*G0_6_0_1 - 0.0349783549783548*G0_6_1_0 + 0.107359307359306*G0_7_0_1 - 0.107359307359306*G0_7_1_0 - 0.03082251082251*G0_8_0_1 + 0.03082251082251*G0_8_1_0 - 0.000692640692640675*G0_9_0_1 + 0.000692640692640661*G0_9_1_0;
    A[142] = A[156] - 0.0814494147827473*G0_0_0_0 + 0.0814494147827478*G0_0_1_1 + 0.0143017476350811*G0_1_0_0 - 0.00637485970819297*G0_1_0_1 + 0.0130832130832131*G0_1_1_0 + 0.00784992784992778*G0_1_1_1 - 0.00784992784992772*G0_2_0_0 + 0.00637485970819307*G0_2_0_1 - 0.0130832130832129*G0_2_1_0 - 0.0143017476350809*G0_2_1_1 + 0.088427128427128*G0_3_0_0 + 0.0973160173160166*G0_3_0_1 + 0.0962770562770559*G0_3_1_0 + 0.106551226551226*G0_3_1_1 - 0.106551226551226*G0_4_0_0 - 0.0973160173160168*G0_4_0_1 - 0.0962770562770562*G0_4_1_0 - 0.0884271284271281*G0_4_1_1 - 0.280288600288598*G0_5_0_0 + 0.0775757575757576*G0_5_0_1 + 0.0879653679653681*G0_5_1_0 - 0.0759595959595955*G0_5_1_1 + 0.0081962481962479*G0_6_0_0 - 0.0928138528138526*G0_6_0_1 - 0.0270129870129872*G0_6_1_0 - 0.0125829725829727*G0_6_1_1 + 0.0759595959595953*G0_7_0_0 - 0.077575757575757*G0_7_0_1 - 0.0879653679653676*G0_7_1_0 + 0.280288600288599*G0_7_1_1 + 0.012582972582973*G0_8_0_0 + 0.0928138528138523*G0_8_0_1 + 0.0270129870129875*G0_8_1_0 - 0.00819624819624791*G0_8_1_1 + 0.107359307359307*G0_9_0_0 - 0.107359307359307*G0_9_1_1;
    A[190] = A[162] + 0.0250120250120249*G0_0_0_1 - 0.0250120250120249*G0_0_1_0 - 0.00531024531024502*G0_1_0_1 + 0.00531024531024504*G0_1_1_0 + 0.0010774410774412*G0_2_0_1 - 0.0010774410774412*G0_2_1_0 + 0.0661471861471857*G0_3_0_1 - 0.0661471861471856*G0_3_1_0 - 0.0107359307359308*G0_4_0_1 + 0.0107359307359308*G0_4_1_0 + 0.0987012987012995*G0_5_0_1 - 0.0987012987012995*G0_5_1_0 + 0.0176623376623374*G0_6_0_1 - 0.0176623376623374*G0_6_1_0 - 0.656277056277052*G0_7_0_1 + 0.656277056277052*G0_7_1_0 + 0.239307359307359*G0_8_0_1 - 0.239307359307359*G0_8_1_0 + 0.224415584415584*G0_9_0_1 - 0.224415584415584*G0_9_1_0;
    A[74] = A[214] + 0.00107744107744095*G0_0_0_1 - 0.00107744107744095*G0_0_1_0 - 0.00531024531024521*G0_1_0_1 + 0.00531024531024522*G0_1_1_0 + 0.0250120250120242*G0_2_0_1 - 0.0250120250120242*G0_2_1_0 + 0.239307359307359*G0_3_0_1 - 0.239307359307359*G0_3_1_0 - 0.656277056277053*G0_4_0_1 + 0.656277056277053*G0_4_1_0 + 0.0176623376623382*G0_5_0_1 - 0.0176623376623382*G0_5_1_0 + 0.0987012987012983*G0_6_0_1 - 0.0987012987012983*G0_6_1_0 - 0.0107359307359312*G0_7_0_1 + 0.0107359307359312*G0_7_1_0 + 0.0661471861471851*G0_8_0_1 - 0.0661471861471851*G0_8_1_0 + 0.224415584415583*G0_9_0_1 - 0.224415584415583*G0_9_1_0;
    A[199] = A[74] + 0.110976430976431*G0_0_0_0 - 0.110976430976431*G0_0_1_1 + 0.116209716209716*G0_1_0_0 + 0.0861183261183261*G0_1_0_1 + 0.055796055796056*G0_1_1_0 - 0.147763347763347*G0_1_1_1 + 0.147763347763347*G0_2_0_0 - 0.086118326118325*G0_2_0_1 - 0.0557960557960549*G0_2_1_0 - 0.116209716209715*G0_2_1_1 - 0.150995670995669*G0_3_0_0 - 0.886233766233762*G0_3_0_1 + 0.00935064935065072*G0_3_1_0 - 1.22874458874458*G0_3_1_1 + 1.22874458874458*G0_4_0_0 + 0.886233766233763*G0_4_0_1 - 0.0093506493506485*G0_4_1_0 + 0.150995670995671*G0_4_1_1 - 0.328311688311687*G0_5_0_0 - 0.0121212121212123*G0_5_0_1 + 0.0162770562770561*G0_5_1_0 + 0.177316017316017*G0_5_1_1 + 1.37558441558441*G0_6_0_0 + 0.0730735930735939*G0_6_0_1 + 0.105627705627707*G0_6_1_0 - 0.00554112554112549*G0_6_1_1 - 0.177316017316016*G0_7_0_0 + 0.0121212121212128*G0_7_0_1 - 0.0162770562770564*G0_7_1_0 + 0.328311688311688*G0_7_1_1 + 0.00554112554112549*G0_8_0_0 - 0.0730735930735922*G0_8_0_1 - 0.105627705627704*G0_8_1_0 - 1.37558441558441*G0_8_1_1 + 0.922597402597399*G0_9_0_0 - 0.922597402597399*G0_9_1_1;
    A[73] = A[199] - 0.00107744107744097*G0_0_0_1 + 0.00107744107744097*G0_0_1_0 - 0.0250120250120249*G0_1_0_1 + 0.0250120250120248*G0_1_1_0 + 0.00531024531024591*G0_2_0_1 - 0.00531024531024591*G0_2_1_0 + 0.656277056277054*G0_3_0_1 - 0.656277056277054*G0_3_1_0 - 0.239307359307359*G0_4_0_1 + 0.239307359307359*G0_4_1_0 + 0.0107359307359302*G0_5_0_1 - 0.0107359307359302*G0_5_1_0 - 0.0661471861471855*G0_6_0_1 + 0.0661471861471855*G0_6_1_0 - 0.0176623376623379*G0_7_0_1 + 0.0176623376623379*G0_7_1_0 - 0.0987012987012967*G0_8_0_1 + 0.0987012987012968*G0_8_1_0 - 0.224415584415583*G0_9_0_1 + 0.224415584415583*G0_9_1_0;
    A[145] = A[159] + 0.000128266794933104*G0_0_0_1 - 0.000128266794933104*G0_0_1_0 + 0.0144684944684942*G0_1_0_1 - 0.0144684944684942*G0_1_1_0 + 0.0432387365720696*G0_2_0_1 - 0.0432387365720696*G0_2_1_0 - 0.0144300144300144*G0_3_0_1 + 0.0144300144300144*G0_3_1_0 - 0.0688023088023084*G0_4_0_1 + 0.0688023088023084*G0_4_1_0 + 0.163924963924963*G0_5_0_1 - 0.163924963924963*G0_5_1_0 - 0.14049062049062*G0_6_0_1 + 0.14049062049062*G0_6_1_0 + 0.809235209235204*G0_7_0_1 - 0.809235209235204*G0_7_1_0 - 0.0492929292929293*G0_8_0_1 + 0.0492929292929293*G0_8_1_0 + 0.359480519480518*G0_9_0_1 - 0.359480519480518*G0_9_1_0;
    A[114] = A[142] + 0.241526374859707*G0_0_0_1 - 0.241526374859707*G0_0_1_0 + 0.0072342472342472*G0_1_0_1 - 0.0072342472342472*G0_1_1_0 - 0.0122238255571589*G0_2_0_1 + 0.0122238255571589*G0_2_1_0 - 0.00450216450216452*G0_3_0_1 + 0.00450216450216452*G0_3_1_0 - 0.00346320346320386*G0_4_0_1 + 0.00346320346320386*G0_4_1_0 - 0.107359307359307*G0_5_0_1 + 0.107359307359307*G0_5_1_0 + 0.0308225108225106*G0_6_0_1 - 0.0308225108225106*G0_6_1_0 - 0.117748917748917*G0_7_0_1 + 0.117748917748917*G0_7_1_0 - 0.0349783549783548*G0_8_0_1 + 0.0349783549783548*G0_8_1_0 + 0.000692640692640842*G0_9_0_1 - 0.000692640692640814*G0_9_1_0;
    A[13] = A[195] + 0.000795254128587428*G0_1_0_1 - 0.000795254128587424*G0_1_1_0 - 0.00829886163219497*G0_2_0_1 + 0.00829886163219497*G0_2_1_0 - 0.00507936507936532*G0_3_0_1 + 0.00507936507936532*G0_3_1_0 + 0.0125829725829726*G0_4_0_1 - 0.0125829725829726*G0_4_1_0 - 0.0386724386724386*G0_5_0_1 + 0.0386724386724386*G0_5_1_0 + 0.0195093795093797*G0_6_0_1 - 0.0195093795093796*G0_6_1_0 + 0.0386724386724381*G0_7_0_1 - 0.0386724386724381*G0_7_1_0 - 0.0451370851370847*G0_8_0_1 + 0.0451370851370847*G0_8_1_0 + 0.0256277056277054*G0_9_0_1 - 0.0256277056277054*G0_9_1_0;
    A[53] = A[123] - 0.00908128908128903*G0_0_0_1 + 0.00908128908128903*G0_0_1_0 + 0.0126727593394257*G0_1_0_1 - 0.0126727593394257*G0_1_1_0 - 0.114413981080647*G0_2_0_1 + 0.114413981080647*G0_2_1_0 - 0.0143145743145747*G0_3_0_1 + 0.0143145743145747*G0_3_1_0 + 0.0337085137085133*G0_4_0_1 - 0.0337085137085133*G0_4_1_0 + 0.0281673881673883*G0_5_0_1 - 0.0281673881673882*G0_5_1_0 + 0.0724963924963922*G0_6_0_1 - 0.0724963924963922*G0_6_1_0 + 0.00923520923520946*G0_7_0_1 - 0.00923520923520946*G0_7_1_0 - 0.0184704184704187*G0_9_0_1 + 0.0184704184704187*G0_9_1_0;
    A[30] = -A[31] + 0.0144155844155844*G0_0_1_0 + 0.0169472502805836*G0_0_1_1 - 0.0144155844155845*G0_1_1_0 + 0.00253166586499918*G0_1_1_1 + 0.0169472502805837*G0_2_1_1 - 0.00621933621933622*G0_3_1_0 - 0.00656204906204907*G0_3_1_1 + 0.0155844155844155*G0_4_1_0 + 0.0152417027417028*G0_4_1_1 + 0.00621933621933622*G0_5_1_0 - 0.00034271284271287*G0_5_1_1 - 0.0155844155844155*G0_6_1_0 - 0.000342712842712754*G0_6_1_1 + 0.0218037518037518*G0_7_1_0 + 0.0152417027417027*G0_7_1_1 - 0.0218037518037518*G0_8_1_0 - 0.00656204906204908*G0_8_1_1 + 0.00351370851370853*G0_9_1_1;
    A[23] = A[21] - 0.0110565977232643*G0_0_0_0 + 0.0223953823953824*G0_0_0_1 + 0.0334519801186467*G0_2_0_0 + 0.0223953823953823*G0_2_0_1 + 0.0023088023088024*G0_3_0_0 - 0.012005772005772*G0_4_0_0 - 0.00161616161616166*G0_4_0_1 - 0.074574314574314*G0_5_0_0 - 0.0223953823953822*G0_5_0_1 + 0.0521789321789319*G0_6_0_0 - 0.0223953823953824*G0_6_0_1 + 0.0103896103896103*G0_7_0_0 - 0.0016161616161616*G0_7_0_1 - 0.00230880230880228*G0_8_0_0 + 0.00161616161616164*G0_9_0_0 + 0.00323232323232331*G0_9_0_1;
    A[20] = -A[23] + 0.0103383036716369*G0_0_0_1 + 0.09318582651916*G0_1_0_1 + 0.0233445566778899*G0_2_0_1 - 0.00375180375180358*G0_3_0_1 + 0.0267243867243865*G0_4_0_1 - 0.0152958152958153*G0_5_0_1 - 0.00998556998557002*G0_6_0_1 - 0.0394227994227994*G0_7_0_1 + 0.0839826839826839*G0_8_0_1 + 0.034054834054834*G0_9_0_1;
    A[5] = -A[20] - 0.00796536796536792*G0_0_0_0 + 0.00438672438672452*G0_0_0_1 - 0.00580407247073906*G0_0_1_0 - 0.00580407247073899*G0_0_1_1 + 0.00796536796536781*G0_1_0_0 + 0.0951996151996151*G0_1_0_1 + 0.00216129549462883*G0_1_1_0 + 0.00201378868045542*G0_1_1_1 + 0.0143145743145742*G0_2_0_1 + 0.0354657687991023*G0_2_1_0 + 0.0132178932178932*G0_2_1_1 - 0.00415584415584414*G0_3_0_0 - 0.00577200577200558*G0_3_0_1 - 0.0122366522366522*G0_3_1_0 - 0.00721500721500709*G0_3_1_1 + 0.052409812409812*G0_4_0_0 + 0.0891197691197682*G0_4_0_1 + 0.0449639249639249*G0_4_1_0 + 0.0623376623376617*G0_4_1_1 + 0.00415584415584418*G0_5_0_0 - 0.013160173160173*G0_5_0_1 - 0.00808080808080808*G0_5_1_0 - 0.00288600288600279*G0_5_1_1 - 0.0524098124098122*G0_6_0_0 - 0.00744588744588728*G0_6_1_0 - 0.00738816738816743*G0_6_1_1 - 0.0081962481962481*G0_7_0_0 - 0.0482539682539681*G0_7_0_1 - 0.00519480519480515*G0_7_1_0 - 0.0103896103896103*G0_7_1_1 + 0.00819624819624805*G0_8_0_0 + 0.0833477633477631*G0_8_0_1 + 0.003001443001443*G0_8_1_0 + 0.00455988455988468*G0_8_1_1 + 0.0263203463203462*G0_9_0_1 - 0.00450216450216449*G0_9_1_0 - 0.00611832611832614*G0_9_1_1;
    A[8] = -A[5] - 0.0931858265191594*G0_0_0_1 - 0.0931858265191594*G0_0_1_1 - 0.0103383036716369*G0_1_0_1 - 0.0103383036716369*G0_1_1_1 - 0.0233445566778899*G0_2_0_1 - 0.02334455667789*G0_2_1_1 + 0.0152958152958152*G0_3_0_1 + 0.0152958152958153*G0_3_1_1 + 0.00998556998556971*G0_4_0_1 + 0.0099855699855696*G0_4_1_1 + 0.00375180375180383*G0_5_0_1 + 0.00375180375180387*G0_5_1_1 - 0.0267243867243867*G0_6_0_1 - 0.0267243867243868*G0_6_1_1 - 0.0839826839826837*G0_7_0_1 - 0.0839826839826836*G0_7_1_1 + 0.0394227994227993*G0_8_0_1 + 0.0394227994227994*G0_8_1_1 - 0.0340548340548341*G0_9_0_1 - 0.0340548340548341*G0_9_1_1;
    A[45] = A[5] + 0.0110565977232643*G0_1_0_0 + 0.0112041045374377*G0_1_0_1 + 0.0333044733044732*G0_1_1_0 + 0.0334519801186466*G0_1_1_1 - 0.0334519801186466*G0_2_0_0 - 0.0112041045374378*G0_2_0_1 - 0.0333044733044734*G0_2_1_0 - 0.0110565977232644*G0_2_1_1 + 0.0745743145743139*G0_3_0_0 + 0.0695526695526688*G0_3_0_1 + 0.0572005772005769*G0_3_1_0 + 0.0521789321789317*G0_3_1_1 - 0.0521789321789317*G0_4_0_0 - 0.0695526695526688*G0_4_0_1 - 0.057200577200577*G0_4_1_0 - 0.0745743145743139*G0_4_1_1 - 0.00230880230880235*G0_5_0_0 - 0.00750360750360756*G0_5_0_1 + 0.00288600288600283*G0_5_1_0 - 0.00230880230880242*G0_5_1_1 + 0.012005772005772*G0_6_0_0 + 0.0119480519480521*G0_6_0_1 + 0.0104473304473303*G0_6_1_0 + 0.0103896103896104*G0_6_1_1 + 0.00230880230880221*G0_7_0_0 + 0.00750360750360739*G0_7_0_1 - 0.00288600288600301*G0_7_1_0 + 0.00230880230880214*G0_7_1_1 - 0.0103896103896103*G0_8_0_0 - 0.0119480519480519*G0_8_0_1 - 0.0104473304473303*G0_8_1_0 - 0.0120057720057719*G0_8_1_1 - 0.0016161616161616*G0_9_0_0 + 0.00161616161616169*G0_9_1_1;
    A[165] = -A[45] - 0.0931858265191597*G0_0_0_0 - 0.0931858265191598*G0_0_0_1 - 0.02334455667789*G0_1_0_0 - 0.02334455667789*G0_1_0_1 - 0.010338303671637*G0_2_0_0 - 0.0103383036716369*G0_2_0_1 + 0.00998556998556981*G0_3_0_0 + 0.00998556998556976*G0_3_0_1 + 0.0152958152958154*G0_4_0_0 + 0.0152958152958154*G0_4_0_1 - 0.0839826839826836*G0_5_0_0 - 0.0839826839826836*G0_5_0_1 + 0.0394227994227994*G0_6_0_0 + 0.0394227994227994*G0_6_0_1 + 0.0037518037518035*G0_7_0_0 + 0.0037518037518035*G0_7_0_1 - 0.0267243867243865*G0_8_0_0 - 0.0267243867243864*G0_8_0_1 - 0.0340548340548341*G0_9_0_0 - 0.0340548340548341*G0_9_0_1;
    A[75] = A[5] + 0.000147506814173429*G0_1_0_1 - 0.00014750681417343*G0_1_1_0 + 0.022247875581209*G0_2_0_1 - 0.022247875581209*G0_2_1_0 - 0.00502164502164507*G0_3_0_1 + 0.00502164502164507*G0_3_1_0 - 0.017373737373737*G0_4_0_1 + 0.017373737373737*G0_4_1_0 - 0.00519480519480526*G0_5_0_1 + 0.00519480519480526*G0_5_1_0 + 0.00519480519480516*G0_7_0_1 - 0.00519480519480515*G0_7_1_0 - 0.00155844155844156*G0_8_0_1 + 0.00155844155844156*G0_8_1_0 + 0.00161616161616165*G0_9_0_1 - 0.00161616161616165*G0_9_1_0;
    A[120] = -A[75] - 0.0931858265191594*G0_0_1_0 - 0.0931858265191594*G0_0_1_1 - 0.0103383036716369*G0_1_1_0 - 0.0103383036716369*G0_1_1_1 - 0.0233445566778899*G0_2_1_0 - 0.02334455667789*G0_2_1_1 + 0.0152958152958152*G0_3_1_0 + 0.0152958152958153*G0_3_1_1 + 0.00998556998556972*G0_4_1_0 + 0.0099855699855696*G0_4_1_1 + 0.00375180375180383*G0_5_1_0 + 0.00375180375180386*G0_5_1_1 - 0.0267243867243867*G0_6_1_0 - 0.0267243867243868*G0_6_1_1 - 0.0839826839826836*G0_7_1_0 - 0.0839826839826836*G0_7_1_1 + 0.0394227994227993*G0_8_1_0 + 0.0394227994227994*G0_8_1_1 - 0.0340548340548341*G0_9_1_0 - 0.0340548340548341*G0_9_1_1;
    A[24] = -A[20] - 0.038723745390412*G0_0_0_0 + 0.00909411576078244*G0_0_0_1 - 0.0815776815776814*G0_1_0_0 - 0.0478178611511943*G0_2_0_0 - 0.00909411576078237*G0_2_0_1 - 0.0655122655122653*G0_3_0_0 - 0.0773448773448768*G0_3_0_1 + 0.0423088023088021*G0_4_0_0 + 0.0646464646464641*G0_4_0_1 - 0.0401154401154399*G0_5_0_0 - 0.0176623376623376*G0_5_0_1 - 0.0224531024531023*G0_6_0_0 + 0.0176623376623376*G0_6_0_1 - 0.0223376623376622*G0_7_0_0 - 0.0646464646464644*G0_7_0_1 + 0.0118326118326116*G0_8_0_0 + 0.0773448773448771*G0_8_0_1 - 0.0234343434343435*G0_9_0_0;
    A[3] = A[45] + 0.0222478755812089*G0_1_0_1 - 0.0222478755812089*G0_1_1_0 + 0.000147506814173414*G0_2_0_1 - 0.000147506814173414*G0_2_1_0 - 0.017373737373737*G0_3_0_1 + 0.017373737373737*G0_3_1_0 - 0.00502164502164516*G0_4_0_1 + 0.00502164502164516*G0_4_1_0 + 0.00519480519480513*G0_5_0_1 - 0.00519480519480513*G0_5_1_0 - 0.00155844155844163*G0_6_0_1 + 0.00155844155844162*G0_6_1_0 - 0.00519480519480525*G0_7_0_1 + 0.00519480519480524*G0_7_1_0 + 0.00161616161616165*G0_9_0_1 - 0.00161616161616165*G0_9_1_0;
    A[11] = -A[3] - 0.0931858265191598*G0_0_0_0 - 0.0931858265191598*G0_0_1_0 - 0.02334455667789*G0_1_0_0 - 0.02334455667789*G0_1_1_0 - 0.010338303671637*G0_2_0_0 - 0.0103383036716369*G0_2_1_0 + 0.00998556998556981*G0_3_0_0 + 0.00998556998556976*G0_3_1_0 + 0.0152958152958154*G0_4_0_0 + 0.0152958152958154*G0_4_1_0 - 0.0839826839826836*G0_5_0_0 - 0.0839826839826836*G0_5_1_0 + 0.0394227994227994*G0_6_0_0 + 0.0394227994227994*G0_6_1_0 + 0.00375180375180352*G0_7_0_0 + 0.0037518037518035*G0_7_1_0 - 0.0267243867243865*G0_8_0_0 - 0.0267243867243864*G0_8_1_0 - 0.0340548340548341*G0_9_0_0 - 0.034054834054834*G0_9_1_0;
    A[128] = -A[125] - 0.0120570787237454*G0_0_0_1 + 0.0921981721981719*G0_0_1_1 - 0.0120570787237453*G0_1_0_1 + 0.0506910373577041*G0_1_1_1 + 0.398140131473463*G0_2_0_1 + 0.351964085297417*G0_2_1_1 + 0.0369408369408371*G0_3_0_1 - 0.113131313131313*G0_3_1_1 - 0.156998556998557*G0_4_0_1 + 0.143145743145743*G0_4_1_1 + 0.0369408369408372*G0_5_0_1 + 0.0438672438672436*G0_5_1_1 - 0.156998556998557*G0_6_0_1 + 0.443290043290043*G0_6_1_1 + 0.0161616161616162*G0_7_0_1 + 0.238268398268397*G0_7_1_1 + 0.0161616161616164*G0_8_0_1 - 0.0050793650793651*G0_8_1_1 - 0.166233766233766*G0_9_0_1 + 0.447907647907647*G0_9_1_1;
    A[63] = -A[71] - 0.0191758858425525*G0_0_0_0 + 0.0504729838063173*G0_0_1_0 - 0.0171877505210841*G0_1_0_0 + 0.241654641654642*G0_1_1_0 - 0.176238576238575*G0_2_0_0 + 0.00224466891133571*G0_2_1_0 + 0.210101010101008*G0_3_0_0 + 0.7018759018759*G0_3_1_0 - 0.164271284271283*G0_4_0_0 - 0.0184704184704184*G0_4_1_0 + 0.084271284271284*G0_5_0_0 - 0.0733044733044732*G0_5_1_0 - 0.409235209235207*G0_6_0_0 - 0.0178932178932179*G0_6_1_0 + 0.0181240981240981*G0_7_0_0 - 0.175468975468975*G0_7_1_0 - 0.0611832611832607*G0_8_0_0 + 0.046176046176047*G0_8_1_0 - 0.193246753246753*G0_9_0_0 + 0.36017316017316*G0_9_1_0;
    A[140] = -A[143] + 0.127086740420073*G0_0_0_1 - 0.0740355940355936*G0_0_1_1 + 0.00312970979637616*G0_1_0_1 - 0.0131345198011866*G0_1_1_1 + 0.00205226871893533*G0_2_1_1 - 0.0138528138528136*G0_3_0_1 - 0.0106204906204903*G0_3_1_1 - 0.0249350649350645*G0_4_0_1 - 0.0498701298701298*G0_4_1_1 - 0.0230880230880229*G0_5_0_1 + 0.044790764790765*G0_5_1_1 + 0.0249350649350649*G0_6_0_1 + 0.0267821067821065*G0_6_1_1 - 0.0974314574314566*G0_7_0_1 - 0.340779220779219*G0_7_1_1 - 0.0327849927849926*G0_8_0_1 + 0.0364790764790763*G0_8_1_1 + 0.0369408369408372*G0_9_0_1 + 0.0397113997113999*G0_9_1_1;
    A[77] = -A[122] - 0.0218053551386884*G0_0_1_1 - 0.0218053551386885*G0_1_1_1 - 0.194965528298861*G0_2_1_1 - 0.00202020202020213*G0_3_1_1 - 0.0430014430014427*G0_4_1_1 - 0.00202020202020204*G0_5_1_1 - 0.0430014430014428*G0_6_1_1 - 0.0510822510822508*G0_7_1_1 - 0.051082251082251*G0_8_1_1 - 0.0940836940836938*G0_9_1_1;
    A[171] = -A[51] - 0.0740355940355936*G0_0_0_0 + 0.127086740420074*G0_0_0_1 + 0.00205226871893533*G0_1_0_0 - 0.0131345198011862*G0_2_0_0 + 0.00312970979637647*G0_2_0_1 - 0.04987012987013*G0_3_0_0 - 0.0249350649350648*G0_3_0_1 - 0.0106204906204907*G0_4_0_0 - 0.0138528138528141*G0_4_0_1 - 0.340779220779218*G0_5_0_0 - 0.097431457431456*G0_5_0_1 + 0.0364790764790763*G0_6_0_0 - 0.0327849927849929*G0_6_0_1 + 0.0447907647907646*G0_7_0_0 - 0.0230880230880224*G0_7_0_1 + 0.026782106782107*G0_8_0_0 + 0.0249350649350647*G0_8_0_1 + 0.0397113997113996*G0_9_0_0 + 0.0369408369408371*G0_9_0_1;
    A[101] = A[171] - 0.114413981080648*G0_0_0_1 + 0.114413981080648*G0_0_1_0 + 0.0126727593394259*G0_1_0_1 - 0.0126727593394259*G0_1_1_0 - 0.00908128908128908*G0_2_0_1 + 0.00908128908128908*G0_2_1_0 + 0.00923520923520933*G0_4_0_1 - 0.00923520923520933*G0_4_1_0 + 0.0724963924963915*G0_5_0_1 - 0.0724963924963915*G0_5_1_0 + 0.0281673881673883*G0_6_0_1 - 0.0281673881673883*G0_6_1_0 + 0.0337085137085132*G0_7_0_1 - 0.0337085137085132*G0_7_1_0 - 0.0143145743145745*G0_8_0_1 + 0.0143145743145745*G0_8_1_0 - 0.0184704184704187*G0_9_0_1 + 0.0184704184704187*G0_9_1_0;
    A[93] = -A[101] - 0.0740355940355936*G0_0_0_0 + 0.127086740420074*G0_0_1_0 + 0.00205226871893533*G0_1_0_0 - 0.0131345198011862*G0_2_0_0 + 0.00312970979637646*G0_2_1_0 - 0.04987012987013*G0_3_0_0 - 0.0249350649350648*G0_3_1_0 - 0.0106204906204906*G0_4_0_0 - 0.0138528138528141*G0_4_1_0 - 0.340779220779218*G0_5_0_0 - 0.097431457431456*G0_5_1_0 + 0.0364790764790762*G0_6_0_0 - 0.0327849927849929*G0_6_1_0 + 0.0447907647907646*G0_7_0_0 - 0.0230880230880224*G0_7_1_0 + 0.026782106782107*G0_8_0_0 + 0.0249350649350647*G0_8_1_0 + 0.0397113997113996*G0_9_0_0 + 0.0369408369408371*G0_9_1_0;
    A[152] = A[40] + 0.00768478435145101*G0_0_0_1 - 0.00768478435145101*G0_0_1_0 - 0.00768478435145112*G0_1_0_1 + 0.00768478435145112*G0_1_1_0 + 0.00471861471861479*G0_3_0_1 - 0.00471861471861479*G0_3_1_0 - 0.00519480519480527*G0_4_0_1 + 0.00519480519480527*G0_4_1_0 - 0.00471861471861456*G0_5_0_1 + 0.00471861471861456*G0_5_1_0 + 0.00519480519480502*G0_6_0_1 - 0.00519480519480502*G0_6_1_0 - 0.034155844155844*G0_7_0_1 + 0.034155844155844*G0_7_1_0 + 0.0341558441558441*G0_8_0_1 - 0.0341558441558441*G0_8_1_0;
    A[137] = A[152] - 0.0299326599326598*G0_0_0_1 + 0.0186644219977552*G0_0_1_1 + 0.0075372775372777*G0_1_0_1 + 0.0151451018117686*G0_1_1_1 - 0.00396825396825391*G0_2_1_1 - 0.00316017316017335*G0_3_0_1 - 0.00598845598845604*G0_3_1_1 - 0.00115440115440122*G0_4_1_1 + 0.00477633477633452*G0_5_0_1 - 0.0132178932178932*G0_5_1_1 + 0.00115440115440119*G0_6_1_1 + 0.0515295815295813*G0_7_0_1 + 0.0428860028860027*G0_7_1_1 - 0.0291341991341992*G0_8_0_1 - 0.0608225108225107*G0_8_1_1 - 0.00161616161616167*G0_9_0_1 + 0.00730158730158718*G0_9_1_1;
    A[167] = A[137] + 0.0223953823953823*G0_0_0_1 - 0.0110565977232643*G0_0_1_1 + 0.0223953823953824*G0_1_0_1 + 0.0334519801186468*G0_1_1_1 - 0.00161616161616147*G0_3_0_1 - 0.0120057720057718*G0_3_1_1 + 0.00230880230880227*G0_4_1_1 - 0.0016161616161616*G0_5_0_1 + 0.0103896103896104*G0_5_1_1 - 0.00230880230880235*G0_6_1_1 - 0.0223953823953823*G0_7_0_1 - 0.0745743145743144*G0_7_1_1 - 0.0223953823953822*G0_8_0_1 + 0.0521789321789322*G0_8_1_1 + 0.00323232323232328*G0_9_0_1 + 0.00161616161616172*G0_9_1_1;
    A[47] = -A[167] + 0.0103383036716369*G0_0_0_1 + 0.0233445566778901*G0_1_0_1 + 0.0931858265191593*G0_2_0_1 + 0.0267243867243868*G0_3_0_1 - 0.00375180375180379*G0_4_0_1 - 0.0394227994227993*G0_5_0_1 + 0.0839826839826835*G0_6_0_1 - 0.0152958152958153*G0_7_0_1 - 0.00998556998556994*G0_8_0_1 + 0.0340548340548339*G0_9_0_1;
    A[92] = -A[47] + 0.00909411576078238*G0_0_0_1 - 0.0387237453904119*G0_0_1_1 - 0.00909411576078238*G0_1_0_1 - 0.0478178611511945*G0_1_1_1 - 0.0815776815776814*G0_2_1_1 + 0.0646464646464643*G0_3_0_1 + 0.042308802308802*G0_3_1_1 - 0.0773448773448768*G0_4_0_1 - 0.0655122655122652*G0_4_1_1 - 0.0646464646464643*G0_5_0_1 - 0.0223376623376621*G0_5_1_1 + 0.0773448773448771*G0_6_0_1 + 0.0118326118326117*G0_6_1_1 - 0.0176623376623376*G0_7_0_1 - 0.0401154401154399*G0_7_1_1 + 0.0176623376623375*G0_8_0_1 - 0.0224531024531025*G0_8_1_1 - 0.0234343434343435*G0_9_1_1;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class laplacian_f1_p3_q4_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  laplacian_f1_p3_q4_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f1_p3_q4_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2}))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f1_p3_q4_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new laplacian_f1_p3_q4_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new laplacian_f1_p3_q4_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f1_p3_q4_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new laplacian_f1_p3_q4_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new laplacian_f1_p3_q4_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f1_p3_q4_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
