// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F2_P1_Q4_TENSOR_H
#define __LAPLACIAN_F2_P1_Q4_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f2_p1_q4_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p1_q4_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q4_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 3;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p1_q4_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class laplacian_f2_p1_q4_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p1_q4_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q4_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p1_q4_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p1_q4_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p1_q4_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q4_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 3;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 2;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p1_q4_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p1_q4_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p1_q4_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q4_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3*m.num_entities[1] + 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p1_q4_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f2_p1_q4_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f2_p1_q4_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q4_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    108
    // Number of operations (multiply-add pairs) for tensor contraction: 4525
    // Total number of operations (multiply-add pairs):                  4644
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[108] = -0.037248677248677*G0_0_0_0_0 + 0.00507936507936508*G0_0_0_0_1 - 0.0524867724867722*G0_0_0_0_2 + 0.00507936507936508*G0_0_0_1_0 + 0.0101587301587303*G0_0_0_1_1 + 0.00169312169312186*G0_0_0_1_2 - 0.0524867724867722*G0_0_0_2_0 + 0.00169312169312186*G0_0_0_2_1 - 0.0338624338624339*G0_0_0_2_2 - 0.00395061728395062*G0_0_1_0_0 - 0.000564373897707327*G0_0_1_0_1 - 0.00959435626102292*G0_0_1_0_2 - 0.000564373897707327*G0_0_1_1_0 - 0.00846560846560937*G0_0_1_1_1 - 0.00225749559082894*G0_0_1_1_2 - 0.00959435626102291*G0_0_1_2_0 - 0.00225749559082894*G0_0_1_2_1 - 0.00507936507936548*G0_0_1_2_2 + 0.0152380952380948*G0_1_0_0_0 - 0.0152380952380953*G0_1_0_0_2 - 0.00507936507936501*G0_1_0_1_1 - 0.00338624338624326*G0_1_0_1_2 - 0.0152380952380953*G0_1_0_2_0 - 0.00338624338624326*G0_1_0_2_1 - 0.0152380952380953*G0_1_0_2_2 + 0.00112874779541434*G0_1_1_0_0 + 0.00169312169312159*G0_1_1_0_1 + 0.00169312169312159*G0_1_1_1_0 - 0.00169312169312172*G0_1_1_1_2 - 0.00169312169312172*G0_1_1_2_1 - 0.00112874779541478*G0_1_1_2_2;
    A[176] = 0.252839506172839*G0_0_0_0_0 + 0.135449735449735*G0_0_0_0_1 + 0.0632098765432095*G0_0_0_0_2 + 0.135449735449735*G0_0_0_1_0 + 0.948148148148144*G0_0_0_1_1 + 0.0902998236331565*G0_0_0_1_2 + 0.0632098765432095*G0_0_0_2_0 + 0.0902998236331565*G0_0_0_2_1 + 0.049664902998236*G0_0_0_2_2 - 0.0112874779541447*G0_0_1_0_0 + 0.0112874779541446*G0_0_1_0_1 + 0.0112874779541446*G0_0_1_1_0 + 0.891710758377421*G0_0_1_1_1 + 0.0677248677248673*G0_0_1_1_2 + 0.0677248677248673*G0_0_1_2_1 + 0.0112874779541446*G0_0_1_2_2 - 0.0112874779541447*G0_1_0_0_0 + 0.0112874779541446*G0_1_0_0_1 + 0.0112874779541446*G0_1_0_1_0 + 0.891710758377421*G0_1_0_1_1 + 0.0677248677248673*G0_1_0_1_2 + 0.0677248677248673*G0_1_0_2_1 + 0.0112874779541446*G0_1_0_2_2 + 0.0225749559082891*G0_1_1_0_0 + 0.12416225749559*G0_1_1_0_1 + 0.0112874779541446*G0_1_1_0_2 + 0.12416225749559*G0_1_1_1_0 + 1.53509700176366*G0_1_1_1_1 + 0.12416225749559*G0_1_1_1_2 + 0.0112874779541446*G0_1_1_2_0 + 0.12416225749559*G0_1_1_2_1 + 0.0225749559082891*G0_1_1_2_2;
    A[52] = A[108] + 0.0191887125220454*G0_0_1_0_0 + 0.000564373897707292*G0_0_1_0_1 - 0.00564373897707235*G0_0_1_0_2 + 0.000564373897707292*G0_0_1_1_0 + 0.00338624338624436*G0_0_1_1_1 - 0.00112874779541433*G0_0_1_1_2 - 0.00564373897707235*G0_0_1_2_0 - 0.00112874779541433*G0_0_1_2_1 - 0.0101587301587298*G0_0_1_2_2 - 0.0191887125220454*G0_1_0_0_0 - 0.000564373897707292*G0_1_0_0_1 + 0.00564373897707235*G0_1_0_0_2 - 0.000564373897707293*G0_1_0_1_0 - 0.00338624338624436*G0_1_0_1_1 + 0.00112874779541433*G0_1_0_1_2 + 0.00564373897707235*G0_1_0_2_0 + 0.00112874779541433*G0_1_0_2_1 + 0.0101587301587298*G0_1_0_2_2;
    A[35] = 0.00423280423280423*G0_1_0_0_0 + 0.00211640211640213*G0_1_0_0_1 + 0.039506172839506*G0_1_0_0_2 + 0.00211640211640213*G0_1_0_1_0 + 0.00423280423280425*G0_1_0_1_1 + 0.039506172839506*G0_1_0_1_2 + 0.039506172839506*G0_1_0_2_0 + 0.039506172839506*G0_1_0_2_1 + 0.608112874779538*G0_1_0_2_2 - 0.0155202821869488*G0_1_1_0_0 - 0.0155202821869488*G0_1_1_0_1 + 0.00634920634920631*G0_1_1_0_2 - 0.0155202821869488*G0_1_1_1_0 - 0.0465608465608465*G0_1_1_1_1 + 0.0126984126984126*G0_1_1_1_2 + 0.00634920634920631*G0_1_1_2_0 + 0.0126984126984126*G0_1_1_2_1 + 0.182010582010581*G0_1_1_2_2;
    A[26] = -0.0507936507936506*G0_0_0_0_0 - 0.0268077601410934*G0_0_0_0_1 - 0.0176366843033509*G0_0_0_0_2 - 0.0268077601410934*G0_0_0_1_0 - 0.426102292768958*G0_0_0_1_1 - 0.0331569664902997*G0_0_0_1_2 - 0.0176366843033509*G0_0_0_2_0 - 0.0331569664902997*G0_0_0_2_1 - 0.019753086419753*G0_0_0_2_2 - 0.00423280423280418*G0_0_1_0_0 - 0.039506172839506*G0_0_1_0_1 - 0.0021164021164021*G0_0_1_0_2 - 0.039506172839506*G0_0_1_1_0 - 0.608112874779538*G0_0_1_1_1 - 0.0395061728395059*G0_0_1_1_2 - 0.0021164021164021*G0_0_1_2_0 - 0.0395061728395059*G0_0_1_2_1 - 0.00423280423280421*G0_0_1_2_2;
    A[135] = A[26] - 0.375308641975307*G0_0_0_0_0 - 0.0155202821869488*G0_0_0_0_2 + 0.375308641975307*G0_0_0_1_1 + 0.0155202821869488*G0_0_0_1_2 - 0.0155202821869488*G0_0_0_2_0 + 0.0155202821869488*G0_0_0_2_1 - 0.421869488536154*G0_0_1_0_0 + 0.0126984126984126*G0_0_1_0_1 - 0.0310405643738976*G0_0_1_0_2 + 0.0126984126984126*G0_0_1_1_0 + 0.557319223985888*G0_0_1_1_1 + 0.0218694885361551*G0_0_1_1_2 - 0.0310405643738976*G0_0_1_2_0 + 0.0218694885361551*G0_0_1_2_1 - 0.0155202821869487*G0_0_1_2_2 + 0.182010582010581*G0_1_0_0_0 + 0.0126984126984126*G0_1_0_0_1 + 0.00634920634920629*G0_1_0_0_2 + 0.0126984126984126*G0_1_0_1_0 - 0.0465608465608463*G0_1_0_1_1 - 0.0155202821869488*G0_1_0_1_2 + 0.00634920634920629*G0_1_0_2_0 - 0.0155202821869488*G0_1_0_2_1 - 0.0155202821869488*G0_1_0_2_2 + 0.182010582010581*G0_1_1_0_0 + 0.0126984126984126*G0_1_1_0_1 + 0.00634920634920629*G0_1_1_0_2 + 0.0126984126984126*G0_1_1_1_0 - 0.0465608465608461*G0_1_1_1_1 - 0.0155202821869488*G0_1_1_1_2 + 0.00634920634920629*G0_1_1_2_0 - 0.0155202821869488*G0_1_1_2_1 - 0.0155202821869488*G0_1_1_2_2;
    A[211] = -0.0163668430335096*G0_0_0_0_0 + 0.00338624338624337*G0_0_0_0_1 - 0.0307583774250439*G0_0_0_0_2 + 0.00338624338624337*G0_0_0_1_0 + 0.0705467372134036*G0_0_0_1_1 + 0.00366843033509702*G0_0_0_1_2 - 0.0307583774250439*G0_0_0_2_0 + 0.00366843033509702*G0_0_0_2_1 - 0.0914285714285708*G0_0_0_2_2 + 0.00395061728395068*G0_1_0_0_0 - 0.00141093474426809*G0_1_0_0_1 + 0.00451499118165783*G0_1_0_0_2 - 0.00141093474426809*G0_1_0_1_0 + 0.00141093474426808*G0_1_0_1_2 + 0.00451499118165783*G0_1_0_2_0 + 0.00141093474426808*G0_1_0_2_1 - 0.0129805996472662*G0_1_0_2_2;
    A[181] = A[211] - 0.062081128747795*G0_0_0_0_0 - 0.0011287477954144*G0_0_0_0_1 - 0.00451499118165777*G0_0_0_0_2 - 0.0011287477954144*G0_0_0_1_0 + 0.00112874779541443*G0_0_0_1_2 - 0.00451499118165776*G0_0_0_2_0 + 0.00112874779541443*G0_0_0_2_1 + 0.0711111111111105*G0_0_0_2_2 + 0.00902998236331547*G0_1_0_0_0 - 0.00902998236331566*G0_1_0_0_2 - 0.00902998236331566*G0_1_0_2_0 + 0.00902998236331553*G0_1_0_2_2;
    A[16] = 0.0134920634920634*G0_0_0_0_0 + 0.0176807760141093*G0_0_0_0_1 + 0.0067460317460317*G0_0_0_0_2 + 0.0176807760141093*G0_0_0_1_0 + 0.261816578483244*G0_0_0_1_1 + 0.0176807760141092*G0_0_0_1_2 + 0.0067460317460317*G0_0_0_2_0 + 0.0176807760141092*G0_0_0_2_1 + 0.0134920634920634*G0_0_0_2_2;
    A[36] = -0.0189065255731921*G0_1_0_0_0 - 0.00296296296296297*G0_1_0_0_1 - 0.00987654320987645*G0_1_0_0_2 - 0.00296296296296297*G0_1_0_1_0 - 0.00197530864197538*G0_1_0_1_1 - 0.0126984126984126*G0_1_0_1_2 - 0.00987654320987645*G0_1_0_2_0 - 0.0126984126984126*G0_1_0_2_1 - 0.13121693121693*G0_1_0_2_2 - 0.0682892416225746*G0_1_1_0_0 - 0.0097354497354497*G0_1_1_0_1 - 0.00592592592592589*G0_1_1_0_2 - 0.0097354497354497*G0_1_1_1_0 - 0.00395061728395065*G0_1_1_1_1 - 0.011710758377425*G0_1_1_1_2 - 0.00592592592592589*G0_1_1_2_0 - 0.011710758377425*G0_1_1_2_1 - 0.118518518518518*G0_1_1_2_2;
    A[122] = -0.00423280423280423*G0_0_1_0_0 - 0.00211640211640212*G0_0_1_0_1 - 0.039506172839506*G0_0_1_0_2 - 0.00211640211640212*G0_0_1_1_0 - 0.00423280423280425*G0_0_1_1_1 - 0.039506172839506*G0_0_1_1_2 - 0.039506172839506*G0_0_1_2_0 - 0.039506172839506*G0_0_1_2_1 - 0.608112874779537*G0_0_1_2_2 - 0.0507936507936506*G0_1_1_0_0 - 0.0176366843033509*G0_1_1_0_1 - 0.0268077601410934*G0_1_1_0_2 - 0.0176366843033509*G0_1_1_1_0 - 0.0197530864197531*G0_1_1_1_1 - 0.0331569664902997*G0_1_1_1_2 - 0.0268077601410934*G0_1_1_2_0 - 0.0331569664902997*G0_1_1_2_1 - 0.426102292768957*G0_1_1_2_2;
    A[212] = -0.00282186948853607*G0_0_1_0_0 + 0.00987654320987637*G0_0_1_0_2 + 0.00282186948853606*G0_0_1_1_1 - 0.00987654320987662*G0_0_1_1_2 + 0.00987654320987637*G0_0_1_2_0 - 0.00987654320987661*G0_0_1_2_1 + 0.0581305114638446*G0_1_1_0_0 + 0.0392239858906524*G0_1_1_0_1 - 0.00564373897707232*G0_1_1_0_2 + 0.0392239858906524*G0_1_1_1_0 + 0.0609523809523807*G0_1_1_1_1 - 0.0155202821869489*G0_1_1_1_2 - 0.00564373897707232*G0_1_1_2_0 - 0.0155202821869489*G0_1_1_2_1 - 0.239858906525572*G0_1_1_2_2;
    A[1] = 0.0231922398589065*G0_0_0_0_0 + 0.000238095238095249*G0_0_0_0_1 + 0.00231922398589064*G0_0_0_0_2 + 0.000238095238095248*G0_0_0_1_0 + 0.0231922398589065*G0_0_0_1_1 + 0.00231922398589064*G0_0_0_1_2 + 0.00231922398589064*G0_0_0_2_0 + 0.00231922398589064*G0_0_0_2_1 + 0.000476190476190453*G0_0_0_2_2 + 0.0231922398589065*G0_1_0_0_0 + 0.000238095238095248*G0_1_0_0_1 + 0.00231922398589064*G0_1_0_0_2 + 0.000238095238095248*G0_1_0_1_0 + 0.0231922398589064*G0_1_0_1_1 + 0.00231922398589063*G0_1_0_1_2 + 0.00231922398589064*G0_1_0_2_0 + 0.00231922398589063*G0_1_0_2_1 + 0.000476190476190441*G0_1_0_2_2;
    A[27] = A[181] + 0.0129805996472662*G0_0_1_0_0 - 0.00141093474426805*G0_0_1_0_1 - 0.00451499118165782*G0_0_1_0_2 - 0.00141093474426805*G0_0_1_1_0 + 0.00141093474426808*G0_0_1_1_2 - 0.00451499118165783*G0_0_1_2_0 + 0.00141093474426808*G0_0_1_2_1 - 0.00395061728395062*G0_0_1_2_2 - 0.0129805996472662*G0_1_0_0_0 + 0.00141093474426805*G0_1_0_0_1 + 0.00451499118165782*G0_1_0_0_2 + 0.00141093474426805*G0_1_0_1_0 - 0.00141093474426808*G0_1_0_1_2 + 0.00451499118165783*G0_1_0_2_0 - 0.00141093474426808*G0_1_0_2_1 + 0.00395061728395063*G0_1_0_2_2;
    A[21] = -A[27] - 0.0426102292768957*G0_0_0_0_0 - 0.000705467372133972*G0_0_0_0_1 - 0.0237037037037036*G0_0_0_0_2 - 0.000705467372133973*G0_0_0_1_0 + 0.0578483245149913*G0_0_0_1_1 + 0.00282186948853615*G0_0_0_1_2 - 0.0237037037037036*G0_0_0_2_0 + 0.00282186948853615*G0_0_0_2_1 - 0.0143915343915344*G0_0_0_2_2 - 0.000564373897707568*G0_0_1_0_0 - 0.000423280423280414*G0_0_1_0_1 + 0.000282186948853576*G0_0_1_0_2 - 0.000423280423280416*G0_0_1_1_0 + 0.00042328042328044*G0_0_1_1_2 + 0.000282186948853577*G0_0_1_2_0 + 0.000423280423280439*G0_0_1_2_1;
    A[46] = -0.0155202821869488*G0_0_0_0_0 + 0.00634920634920626*G0_0_0_0_1 - 0.0155202821869488*G0_0_0_0_2 + 0.00634920634920626*G0_0_0_1_0 + 0.18201058201058*G0_0_0_1_1 + 0.0126984126984126*G0_0_0_1_2 - 0.0155202821869488*G0_0_0_2_0 + 0.0126984126984126*G0_0_0_2_1 - 0.0465608465608463*G0_0_0_2_2 + 0.00423280423280419*G0_1_0_0_0 + 0.039506172839506*G0_1_0_0_1 + 0.0021164021164021*G0_1_0_0_2 + 0.039506172839506*G0_1_0_1_0 + 0.608112874779538*G0_1_0_1_1 + 0.0395061728395059*G0_1_0_1_2 + 0.0021164021164021*G0_1_0_2_0 + 0.0395061728395059*G0_1_0_2_1 + 0.00423280423280422*G0_1_0_2_2;
    A[144] = A[176] + 0.695308641975306*G0_0_0_0_0 + 0.0270899470899471*G0_0_0_0_2 - 0.695308641975306*G0_0_0_1_1 - 0.0270899470899469*G0_0_0_1_2 + 0.0270899470899471*G0_0_0_2_0 - 0.0270899470899469*G0_0_0_2_1 + 0.0677248677248675*G0_0_1_0_0 + 0.112874779541446*G0_0_1_0_1 + 0.0225749559082892*G0_0_1_0_2 + 0.112874779541446*G0_0_1_1_0 - 0.627583774250438*G0_0_1_1_1 - 0.00451499118165777*G0_0_1_1_2 + 0.0225749559082892*G0_0_1_2_0 - 0.00451499118165777*G0_0_1_2_1 + 0.027089947089947*G0_0_1_2_2 + 0.0677248677248675*G0_1_0_0_0 + 0.112874779541446*G0_1_0_0_1 + 0.0225749559082892*G0_1_0_0_2 + 0.112874779541446*G0_1_0_1_0 - 0.627583774250438*G0_1_0_1_1 - 0.00451499118165777*G0_1_0_1_2 + 0.0225749559082892*G0_1_0_2_0 - 0.00451499118165775*G0_1_0_2_1 + 0.027089947089947*G0_1_0_2_2 + 0.677248677248674*G0_1_1_0_0 + 0.112874779541446*G0_1_1_0_1 + 0.0677248677248675*G0_1_1_0_2 + 0.112874779541446*G0_1_1_1_0 - 1.23710758377424*G0_1_1_1_1 - 0.0496649029982359*G0_1_1_1_2 + 0.0677248677248675*G0_1_1_2_0 - 0.0496649029982359*G0_1_1_2_1 + 0.0270899470899471*G0_1_1_2_2;
    A[89] = 0.0225749559082891*G0_0_0_0_0 + 0.0902998236331564*G0_0_0_0_2 - 0.0225749559082893*G0_0_0_1_1 - 0.0902998236331568*G0_0_0_1_2 + 0.0902998236331564*G0_0_0_2_0 - 0.0902998236331568*G0_0_0_2_1 - 0.0180599647266312*G0_0_1_0_0 - 0.0158024691358023*G0_0_1_0_1 - 0.0564373897707229*G0_0_1_0_2 - 0.0158024691358023*G0_0_1_1_0 - 0.0406349206349203*G0_0_1_1_1 - 0.14673721340388*G0_0_1_1_2 - 0.0564373897707229*G0_0_1_2_0 - 0.14673721340388*G0_0_1_2_1 - 0.79012345679012*G0_0_1_2_2 + 0.0135449735449735*G0_1_0_0_0 - 0.0135449735449736*G0_1_0_0_1 - 0.0135449735449736*G0_1_0_1_0 - 0.121904761904761*G0_1_0_1_1 - 0.27089947089947*G0_1_0_1_2 - 0.27089947089947*G0_1_0_2_1 - 0.609523809523807*G0_1_0_2_2 - 0.121904761904761*G0_1_1_0_0 - 0.135449735449735*G0_1_1_0_1 - 0.0812698412698411*G0_1_1_0_2 - 0.135449735449735*G0_1_1_1_0 - 0.352169312169311*G0_1_1_1_1 - 0.325079365079364*G0_1_1_1_2 - 0.0812698412698411*G0_1_1_2_0 - 0.325079365079364*G0_1_1_2_1 - 0.880423280423276*G0_1_1_2_2;
    A[195] = A[181] + 0.148994708994708*G0_0_0_0_0 + 0.0400705467372131*G0_0_0_0_2 - 0.148994708994708*G0_0_0_1_1 - 0.0400705467372131*G0_0_0_1_2 + 0.0400705467372131*G0_0_0_2_0 - 0.0400705467372131*G0_0_0_2_1 + 0.0705467372134037*G0_0_1_0_0 + 0.00225749559082897*G0_0_1_0_1 + 0.00479717813051142*G0_0_1_0_2 + 0.00225749559082897*G0_0_1_1_0 - 0.0784479717813044*G0_0_1_1_1 - 0.0352733686067016*G0_0_1_1_2 + 0.00479717813051142*G0_0_1_2_0 - 0.0352733686067016*G0_0_1_2_1 - 0.0203174603174602*G0_0_1_2_2 + 0.0575661375661369*G0_1_0_0_0 + 0.00507936507936504*G0_1_0_0_1 + 0.00790123456790118*G0_1_0_0_2 + 0.00507936507936504*G0_1_0_1_0 - 0.091428571428571*G0_1_0_1_1 - 0.0321693121693119*G0_1_0_1_2 + 0.00790123456790119*G0_1_0_2_0 - 0.0321693121693119*G0_1_0_2_1 - 0.012416225749559*G0_1_0_2_2 + 0.0705467372134032*G0_1_1_0_0 + 0.00366843033509705*G0_1_1_0_1 + 0.00338624338624336*G0_1_1_0_2 + 0.00366843033509705*G0_1_1_1_0 - 0.0914285714285705*G0_1_1_1_1 - 0.0307583774250438*G0_1_1_1_2 + 0.00338624338624336*G0_1_1_2_0 - 0.0307583774250438*G0_1_1_2_1 - 0.0163668430335095*G0_1_1_2_2;
    A[14] = A[195] + 0.00112874779541447*G0_0_0_0_1 - 0.00112874779541437*G0_0_0_0_2 + 0.00112874779541447*G0_0_0_1_0 + 0.062081128747795*G0_0_0_1_1 + 0.00451499118165783*G0_0_0_1_2 - 0.00112874779541437*G0_0_0_2_0 + 0.00451499118165783*G0_0_0_2_1 - 0.0711111111111106*G0_0_0_2_2 + 0.00253968253968254*G0_0_1_0_1 - 0.00253968253968246*G0_0_1_0_2 + 0.00253968253968254*G0_0_1_1_0 + 0.0581305114638442*G0_0_1_1_1 - 0.00253968253968246*G0_0_1_2_0 - 0.0581305114638443*G0_0_1_2_2 - 0.00028218694885357*G0_1_0_0_1 + 0.000282186948853673*G0_1_0_0_2 - 0.00028218694885357*G0_1_0_1_0 + 0.0750617283950612*G0_1_0_1_1 + 0.000282186948853674*G0_1_0_2_0 - 0.0750617283950613*G0_1_0_2_2 + 0.00112874779541443*G0_1_1_0_1 - 0.00112874779541441*G0_1_1_0_2 + 0.00112874779541444*G0_1_1_1_0 + 0.0711111111111102*G0_1_1_1_1 - 0.00451499118165789*G0_1_1_1_2 - 0.00112874779541441*G0_1_1_2_0 - 0.00451499118165789*G0_1_1_2_1 - 0.0620811287477951*G0_1_1_2_2;
    A[56] = -A[176] + 0.316049382716048*G0_0_0_0_0 + 0.158024691358024*G0_0_0_0_1 + 0.101587301587301*G0_0_0_0_2 + 0.158024691358024*G0_0_0_1_0 + 0.654673721340386*G0_0_0_1_1 + 0.056437389770723*G0_0_0_1_2 + 0.101587301587301*G0_0_0_2_0 + 0.056437389770723*G0_0_0_2_1 + 0.0902998236331565*G0_0_0_2_2 - 0.0225749559082893*G0_0_1_0_0 - 0.0451499118165781*G0_0_1_0_1 - 0.0112874779541446*G0_0_1_0_2 - 0.0451499118165781*G0_0_1_1_0 + 0.248324514991182*G0_0_1_1_1 - 0.0451499118165783*G0_0_1_1_2 - 0.0112874779541446*G0_0_1_2_0 - 0.0451499118165783*G0_0_1_2_1 - 0.0225749559082891*G0_0_1_2_2;
    A[125] = A[56] - 0.0857848324514986*G0_0_0_0_0 - 0.0338624338624338*G0_0_0_0_1 - 0.162539682539682*G0_0_0_0_2 - 0.0338624338624338*G0_0_0_1_0 + 0.270899470899468*G0_0_0_1_1 - 0.0902998236331567*G0_0_0_1_2 - 0.162539682539682*G0_0_0_2_0 - 0.0902998236331567*G0_0_0_2_1 - 1.57573192239858*G0_0_0_2_2 + 0.0451499118165782*G0_0_1_0_1 - 0.0451499118165783*G0_0_1_0_2 + 0.0451499118165782*G0_0_1_1_0 + 0.609523809523805*G0_0_1_1_1 - 0.0451499118165783*G0_0_1_2_0 - 0.609523809523806*G0_0_1_2_2 + 0.0112874779541446*G0_1_0_0_1 - 0.0112874779541445*G0_1_0_0_2 + 0.0112874779541446*G0_1_0_1_0 + 0.880423280423276*G0_1_0_1_1 - 0.0112874779541445*G0_1_0_2_0 - 0.880423280423275*G0_1_0_2_2 + 0.0857848324514986*G0_1_1_0_0 + 0.162539682539682*G0_1_1_0_1 + 0.0338624338624338*G0_1_1_0_2 + 0.162539682539682*G0_1_1_1_0 + 1.57573192239858*G0_1_1_1_1 + 0.0902998236331566*G0_1_1_1_2 + 0.0338624338624338*G0_1_1_2_0 + 0.0902998236331566*G0_1_1_2_1 - 0.270899470899469*G0_1_1_2_2;
    A[83] = A[125] + 0.0225749559082891*G0_0_1_0_0 + 0.0112874779541445*G0_0_1_0_1 + 0.0451499118165785*G0_0_1_0_2 + 0.0112874779541445*G0_0_1_1_0 + 0.0225749559082889*G0_0_1_1_1 + 0.0451499118165783*G0_0_1_1_2 + 0.0451499118165785*G0_0_1_2_0 + 0.0451499118165783*G0_0_1_2_1 - 0.248324514991179*G0_0_1_2_2 - 0.0225749559082891*G0_1_0_0_0 - 0.0112874779541445*G0_1_0_0_1 - 0.0451499118165785*G0_1_0_0_2 - 0.0112874779541445*G0_1_0_1_0 - 0.0225749559082889*G0_1_0_1_1 - 0.0451499118165783*G0_1_0_1_2 - 0.0451499118165785*G0_1_0_2_0 - 0.0451499118165783*G0_1_0_2_1 + 0.248324514991179*G0_1_0_2_2;
    A[80] = -A[125] + 0.0225749559082891*G0_1_0_0_0 + 0.0112874779541445*G0_1_0_0_1 + 0.0451499118165785*G0_1_0_0_2 + 0.0112874779541445*G0_1_0_1_0 + 0.0225749559082889*G0_1_0_1_1 + 0.0451499118165783*G0_1_0_1_2 + 0.0451499118165785*G0_1_0_2_0 + 0.0451499118165784*G0_1_0_2_1 - 0.248324514991179*G0_1_0_2_2 + 0.112874779541446*G0_1_1_0_0 + 0.112874779541446*G0_1_1_0_1 + 0.101587301587301*G0_1_1_0_2 + 0.112874779541446*G0_1_1_1_0 + 0.338624338624338*G0_1_1_1_1 + 0.203174603174603*G0_1_1_1_2 + 0.101587301587301*G0_1_1_2_0 + 0.203174603174603*G0_1_1_2_1 + 0.406349206349205*G0_1_1_2_2;
    A[31] = -0.000476190476190454*G0_1_0_0_0 - 0.00231922398589065*G0_1_0_0_1 - 0.00231922398589064*G0_1_0_0_2 - 0.00231922398589065*G0_1_0_1_0 - 0.0231922398589066*G0_1_0_1_1 - 0.00023809523809525*G0_1_0_1_2 - 0.00231922398589064*G0_1_0_2_0 - 0.000238095238095249*G0_1_0_2_1 - 0.0231922398589064*G0_1_0_2_2;
    A[107] = 0.00599647266313931*G0_0_1_0_0 + 0.00229276895943564*G0_0_1_0_1 + 0.0172839506172839*G0_0_1_0_2 + 0.00229276895943564*G0_0_1_1_0 + 0.00317460317460327*G0_0_1_1_1 + 0.0271604938271604*G0_0_1_1_2 + 0.0172839506172839*G0_0_1_2_0 + 0.0271604938271604*G0_0_1_2_1 + 0.322751322751321*G0_0_1_2_2 + 0.0823985890652553*G0_1_1_0_0 + 0.0183068783068782*G0_1_1_0_1 + 0.0148148148148147*G0_1_1_0_2 + 0.0183068783068782*G0_1_1_1_0 + 0.00973544973544976*G0_1_1_1_1 + 0.0248677248677248*G0_1_1_1_2 + 0.0148148148148147*G0_1_1_2_0 + 0.0248677248677248*G0_1_1_2_1 + 0.259611992945325*G0_1_1_2_2;
    A[7] = A[107] - 0.0631393298059965*G0_0_0_0_0 - 0.00229276895943563*G0_0_0_0_1 - 0.00246913580246913*G0_0_0_0_2 - 0.00229276895943562*G0_0_0_1_0 + 0.00656084656084653*G0_0_0_1_1 + 0.0160141093474426*G0_0_0_1_2 - 0.00246913580246913*G0_0_0_2_0 + 0.0160141093474426*G0_0_0_2_1 + 0.076402116402116*G0_0_0_2_2 + 0.253615520282186*G0_0_1_0_0 + 0.0225749559082891*G0_0_1_0_1 - 0.00246913580246914*G0_0_1_0_2 + 0.0225749559082891*G0_0_1_1_0 + 0.00656084656084643*G0_0_1_1_1 - 0.00885361552028216*G0_0_1_1_2 - 0.00246913580246913*G0_0_1_2_0 - 0.00885361552028217*G0_0_1_2_1 - 0.240352733686065*G0_0_1_2_2 - 0.0631393298059965*G0_1_0_0_0 - 0.00229276895943562*G0_1_0_0_1 - 0.00246913580246914*G0_1_0_0_2 - 0.00229276895943562*G0_1_0_1_0 + 0.00656084656084653*G0_1_0_1_1 + 0.0160141093474426*G0_1_0_1_2 - 0.00246913580246914*G0_1_0_2_0 + 0.0160141093474426*G0_1_0_2_1 + 0.0764021164021162*G0_1_0_2_2 + 0.17721340388007*G0_1_1_0_0 + 0.00656084656084655*G0_1_1_0_1 + 0.00656084656084656*G0_1_1_1_0 - 0.00656084656084652*G0_1_1_1_2 - 0.00656084656084652*G0_1_1_2_1 - 0.177213403880069*G0_1_1_2_2;
    A[198] = A[89] - 0.14447971781305*G0_0_0_0_0 - 0.0812698412698409*G0_0_0_0_1 - 0.225749559082891*G0_0_0_0_2 - 0.0812698412698409*G0_0_0_1_0 - 0.857848324514987*G0_0_0_1_1 - 0.234779541446207*G0_0_0_1_2 - 0.225749559082891*G0_0_0_2_0 - 0.234779541446207*G0_0_0_2_1 - 0.352169312169309*G0_0_0_2_2 - 0.0406349206349206*G0_0_1_0_1 + 0.0406349206349204*G0_0_1_0_2 - 0.0406349206349206*G0_0_1_1_0 - 0.749488536155199*G0_0_1_1_1 + 0.0406349206349204*G0_0_1_2_0 + 0.749488536155199*G0_0_1_2_2 + 0.0135449735449734*G0_1_0_0_1 - 0.0135449735449737*G0_1_0_0_2 + 0.0135449735449734*G0_1_0_1_0 - 0.487619047619046*G0_1_0_1_1 - 0.0135449735449737*G0_1_0_2_0 + 0.487619047619046*G0_1_0_2_2 + 0.14447971781305*G0_1_1_0_0 + 0.225749559082891*G0_1_1_0_1 + 0.081269841269841*G0_1_1_0_2 + 0.225749559082891*G0_1_1_1_0 + 0.35216931216931*G0_1_1_1_1 + 0.234779541446207*G0_1_1_1_2 + 0.081269841269841*G0_1_1_2_0 + 0.234779541446207*G0_1_1_2_1 + 0.857848324514987*G0_1_1_2_2;
    A[214] = A[198] + 0.0338624338624336*G0_0_0_0_0 + 0.0338624338624337*G0_0_0_0_1 - 0.0846560846560843*G0_0_0_0_2 + 0.0338624338624337*G0_0_0_1_0 + 0.589206349206346*G0_0_0_1_1 - 0.0643386243386242*G0_0_0_1_2 - 0.0846560846560843*G0_0_0_2_0 - 0.0643386243386241*G0_0_0_2_1 - 0.799153439153435*G0_0_0_2_2 - 0.0158024691358024*G0_0_1_0_0 + 0.0191887125220458*G0_0_1_0_1 - 0.0485361552028218*G0_0_1_0_2 + 0.0191887125220458*G0_0_1_1_0 + 0.525996472663136*G0_0_1_1_1 - 0.0598236331569665*G0_0_1_1_2 - 0.0485361552028218*G0_0_1_2_0 - 0.0598236331569665*G0_0_1_2_1 - 0.213333333333333*G0_0_1_2_2 + 0.426666666666665*G0_1_0_1_1 - 0.00338624338624344*G0_1_0_1_2 - 0.00338624338624344*G0_1_0_2_1 - 0.301375661375661*G0_1_0_2_2 + 0.0316049382716045*G0_1_1_0_0 + 0.0248324514991182*G0_1_1_0_1 + 0.0169312169312168*G0_1_1_0_2 + 0.0248324514991182*G0_1_1_1_0 + 0.203174603174604*G0_1_1_1_1 + 0.0428924162257494*G0_1_1_1_2 + 0.0169312169312168*G0_1_1_2_0 + 0.0428924162257493*G0_1_1_2_1 + 0.00225749559082816*G0_1_1_2_2;
    A[149] = -A[198] - 0.20768959435626*G0_0_0_0_0 - 0.0744973544973542*G0_0_0_0_1 - 0.146737213403879*G0_0_0_0_2 - 0.0744973544973542*G0_0_0_1_0 - 0.848818342151671*G0_0_0_1_1 - 0.273156966490299*G0_0_0_1_2 - 0.146737213403879*G0_0_0_2_0 - 0.273156966490299*G0_0_0_2_1 - 0.257354497354497*G0_0_0_2_2 + 0.0316049382716035*G0_0_1_0_0 + 0.0090299823633154*G0_0_1_0_1 - 0.0180599647266315*G0_0_1_0_2 + 0.0090299823633154*G0_0_1_1_0 - 0.722398589065252*G0_0_1_1_1 - 0.0767548500881833*G0_0_1_1_2 - 0.0180599647266315*G0_0_1_2_0 - 0.0767548500881833*G0_0_1_2_1 + 0.0496649029982355*G0_0_1_2_2 + 0.108359788359788*G0_1_0_0_0 + 0.027089947089947*G0_1_0_0_1 + 0.027089947089947*G0_1_0_1_0 - 0.568888888888887*G0_1_0_1_1 - 0.203174603174602*G0_1_0_1_2 - 0.203174603174602*G0_1_0_2_1 + 0.252839506172838*G0_1_1_0_0 + 0.198659611992944*G0_1_1_0_1 + 0.198659611992944*G0_1_1_1_0 + 0.0812698412698399*G0_1_1_1_1 - 0.00902998236331562*G0_1_1_1_2 - 0.00902998236331561*G0_1_1_2_1 + 0.0993298059964723*G0_1_1_2_2;
    A[32] = 0.0134920634920634*G0_1_1_0_0 + 0.00674603174603172*G0_1_1_0_1 + 0.0176807760141093*G0_1_1_0_2 + 0.00674603174603172*G0_1_1_1_0 + 0.0134920634920635*G0_1_1_1_1 + 0.0176807760141093*G0_1_1_1_2 + 0.0176807760141093*G0_1_1_2_0 + 0.0176807760141093*G0_1_1_2_1 + 0.261816578483244*G0_1_1_2_2;
    A[25] = 0.0823985890652554*G0_0_0_0_0 + 0.0148148148148148*G0_0_0_0_1 + 0.0183068783068782*G0_0_0_0_2 + 0.0148148148148148*G0_0_0_1_0 + 0.259611992945325*G0_0_0_1_1 + 0.0248677248677248*G0_0_0_1_2 + 0.0183068783068782*G0_0_0_2_0 + 0.0248677248677248*G0_0_0_2_1 + 0.0097354497354497*G0_0_0_2_2 + 0.00599647266313933*G0_0_1_0_0 + 0.0172839506172839*G0_0_1_0_1 + 0.00229276895943561*G0_0_1_0_2 + 0.0172839506172839*G0_0_1_1_0 + 0.322751322751321*G0_0_1_1_1 + 0.0271604938271604*G0_0_1_1_2 + 0.00229276895943561*G0_0_1_2_0 + 0.0271604938271604*G0_0_1_2_1 + 0.00317460317460313*G0_0_1_2_2;
    A[61] = 0.00656084656084654*G0_0_0_0_0 - 0.00229276895943557*G0_0_0_0_1 + 0.0160141093474426*G0_0_0_0_2 - 0.00229276895943557*G0_0_0_1_0 - 0.0631393298059958*G0_0_0_1_1 - 0.00246913580246913*G0_0_0_1_2 + 0.0160141093474426*G0_0_0_2_0 - 0.00246913580246913*G0_0_0_2_1 + 0.0764021164021159*G0_0_0_2_2 - 0.00317460317460317*G0_1_0_0_0 - 0.0271604938271604*G0_1_0_0_1 - 0.00229276895943561*G0_1_0_0_2 - 0.0271604938271604*G0_1_0_1_0 - 0.322751322751322*G0_1_0_1_1 - 0.0172839506172839*G0_1_0_1_2 - 0.00229276895943561*G0_1_0_2_0 - 0.0172839506172839*G0_1_0_2_1 - 0.00599647266313932*G0_1_0_2_2;
    A[106] = 0.00980599647266306*G0_0_0_0_0 - 0.00109347442680779*G0_0_0_0_1 + 0.0147442680776013*G0_0_0_0_2 - 0.00109347442680779*G0_0_0_1_0 - 0.00740740740740782*G0_0_0_1_1 - 0.00119929453262789*G0_0_0_1_2 + 0.0147442680776013*G0_0_0_2_0 - 0.00119929453262789*G0_0_0_2_1 + 0.015026455026455*G0_0_0_2_2 - 0.00522045855379163*G0_1_0_0_0 + 0.000105820105820099*G0_1_0_0_1 + 0.000105820105820099*G0_1_0_1_0 - 0.000105820105820129*G0_1_0_1_2 - 0.000105820105820129*G0_1_0_2_1 + 0.00522045855379187*G0_1_0_2_2;
    A[60] = A[106] - 0.0172134038800707*G0_0_0_0_0 - 0.0159435626102292*G0_0_0_0_2 + 0.0172134038800708*G0_0_0_1_1 + 0.0159435626102292*G0_0_0_1_2 - 0.0159435626102292*G0_0_0_2_0 + 0.0159435626102292*G0_0_0_2_1 - 0.00740740740740764*G0_0_1_0_0 - 0.00109347442680779*G0_0_1_0_1 - 0.00119929453262792*G0_0_1_0_2 - 0.00109347442680779*G0_0_1_1_0 + 0.00980599647266299*G0_0_1_1_1 + 0.0147442680776012*G0_0_1_1_2 - 0.00119929453262792*G0_0_1_2_0 + 0.0147442680776012*G0_0_1_2_1 + 0.0150264550264545*G0_0_1_2_2 - 0.0021869488536162*G0_1_0_0_0 - 0.001305114638448*G0_1_0_0_1 - 0.00109347442680783*G0_1_0_0_2 - 0.00130511463844801*G0_1_0_1_0 + 0.0150264550264551*G0_1_0_1_1 + 0.0148500881834214*G0_1_0_1_2 - 0.00109347442680783*G0_1_0_2_0 + 0.0148500881834214*G0_1_0_2_1 + 0.00458553791887125*G0_1_0_2_2 - 0.00740740740740794*G0_1_1_0_0 - 0.00119929453262793*G0_1_1_0_1 - 0.0010934744268078*G0_1_1_0_2 - 0.00119929453262793*G0_1_1_1_0 + 0.0150264550264546*G0_1_1_1_1 + 0.0147442680776012*G0_1_1_1_2 - 0.0010934744268078*G0_1_1_2_0 + 0.0147442680776012*G0_1_1_2_1 + 0.00980599647266295*G0_1_1_2_2;
    A[4] = A[60] - 0.000105820105820112*G0_0_1_0_1 + 0.000105820105820117*G0_0_1_0_2 - 0.000105820105820113*G0_0_1_1_0 + 0.00522045855379173*G0_0_1_1_1 + 0.000105820105820117*G0_0_1_2_0 - 0.00522045855379155*G0_0_1_2_2 + 0.000105820105820112*G0_1_0_0_1 - 0.000105820105820118*G0_1_0_0_2 + 0.000105820105820113*G0_1_0_1_0 - 0.00522045855379174*G0_1_0_1_1 - 0.000105820105820118*G0_1_0_2_0 + 0.00522045855379154*G0_1_0_2_2;
    A[15] = 0.0231922398589065*G0_0_0_0_0 + 0.000238095238095248*G0_0_0_0_1 + 0.00231922398589064*G0_0_0_0_2 + 0.000238095238095248*G0_0_0_1_0 + 0.0231922398589065*G0_0_0_1_1 + 0.00231922398589064*G0_0_0_1_2 + 0.00231922398589064*G0_0_0_2_0 + 0.00231922398589064*G0_0_0_2_1 + 0.000476190476190453*G0_0_0_2_2 + 0.0231922398589065*G0_0_1_0_0 + 0.000238095238095248*G0_0_1_0_1 + 0.00231922398589064*G0_0_1_0_2 + 0.000238095238095248*G0_0_1_1_0 + 0.0231922398589064*G0_0_1_1_1 + 0.00231922398589063*G0_0_1_1_2 + 0.00231922398589064*G0_0_1_2_0 + 0.00231922398589063*G0_0_1_2_1 + 0.000476190476190442*G0_0_1_2_2;
    A[37] = 0.00599647266313931*G0_1_0_0_0 + 0.00229276895943564*G0_1_0_0_1 + 0.0172839506172839*G0_1_0_0_2 + 0.00229276895943564*G0_1_0_1_0 + 0.00317460317460327*G0_1_0_1_1 + 0.0271604938271604*G0_1_0_1_2 + 0.0172839506172839*G0_1_0_2_0 + 0.0271604938271604*G0_1_0_2_1 + 0.32275132275132*G0_1_0_2_2 + 0.0823985890652553*G0_1_1_0_0 + 0.0183068783068782*G0_1_1_0_1 + 0.0148148148148147*G0_1_1_0_2 + 0.0183068783068782*G0_1_1_1_0 + 0.00973544973544976*G0_1_1_1_1 + 0.0248677248677248*G0_1_1_1_2 + 0.0148148148148147*G0_1_1_2_0 + 0.0248677248677248*G0_1_1_2_1 + 0.259611992945325*G0_1_1_2_2;
    A[91] = -A[181] - 0.0426102292768957*G0_0_0_0_0 - 0.000705467372133971*G0_0_0_0_1 - 0.0237037037037036*G0_0_0_0_2 - 0.000705467372133972*G0_0_0_1_0 + 0.0578483245149913*G0_0_0_1_1 + 0.00282186948853615*G0_0_0_1_2 - 0.0237037037037036*G0_0_0_2_0 + 0.00282186948853615*G0_0_0_2_1 - 0.0143915343915344*G0_0_0_2_2 - 0.00056437389770758*G0_1_0_0_0 - 0.000423280423280419*G0_1_0_0_1 + 0.000282186948853573*G0_1_0_0_2 - 0.000423280423280418*G0_1_0_1_0 + 0.000423280423280443*G0_1_0_1_2 + 0.000282186948853574*G0_1_0_2_0 + 0.000423280423280441*G0_1_0_2_1;
    A[168] = -A[176] + 0.316049382716048*G0_0_0_0_0 + 0.158024691358024*G0_0_0_0_1 + 0.101587301587301*G0_0_0_0_2 + 0.158024691358024*G0_0_0_1_0 + 0.654673721340386*G0_0_0_1_1 + 0.056437389770723*G0_0_0_1_2 + 0.101587301587301*G0_0_0_2_0 + 0.056437389770723*G0_0_0_2_1 + 0.0902998236331565*G0_0_0_2_2 - 0.0225749559082893*G0_1_0_0_0 - 0.0451499118165781*G0_1_0_0_1 - 0.0112874779541446*G0_1_0_0_2 - 0.0451499118165781*G0_1_0_1_0 + 0.248324514991182*G0_1_0_1_1 - 0.0451499118165783*G0_1_0_1_2 - 0.0112874779541446*G0_1_0_2_0 - 0.0451499118165783*G0_1_0_2_1 - 0.0225749559082891*G0_1_0_2_2;
    A[18] = -A[26] - 0.0663139329805993*G0_0_0_0_0 - 0.0204585537918871*G0_0_0_0_1 - 0.0331569664902996*G0_0_0_0_2 - 0.0204585537918871*G0_0_0_1_0 - 0.244091710758377*G0_0_0_1_1 - 0.0204585537918871*G0_0_0_1_2 - 0.0331569664902996*G0_0_0_2_0 - 0.0204585537918871*G0_0_0_2_1 - 0.0663139329805993*G0_0_0_2_2;
    A[38] = -A[35] - 0.0663139329805993*G0_1_1_0_0 - 0.0331569664902997*G0_1_1_0_1 - 0.020458553791887*G0_1_1_0_2 - 0.0331569664902997*G0_1_1_1_0 - 0.0663139329805996*G0_1_1_1_1 - 0.0204585537918871*G0_1_1_1_2 - 0.020458553791887*G0_1_1_2_0 - 0.0204585537918871*G0_1_1_2_1 - 0.244091710758376*G0_1_1_2_2;
    A[116] = -A[108] - 0.0519223985890648*G0_0_0_0_0 + 0.0107231040564374*G0_0_0_0_1 - 0.0801410934744263*G0_0_0_0_2 + 0.0107231040564374*G0_0_0_1_0 + 0.0338624338624344*G0_0_0_1_1 + 0.00902998236331586*G0_0_0_1_2 - 0.0801410934744263*G0_0_0_2_0 + 0.00902998236331586*G0_0_0_2_1 - 0.0812698412698409*G0_0_0_2_2 + 0.0293474426807747*G0_1_0_0_0 + 0.00169312169312156*G0_1_0_0_1 + 0.00169312169312156*G0_1_0_1_0 - 0.00169312169312157*G0_1_0_1_2 - 0.00169312169312158*G0_1_0_2_1 - 0.0293474426807759*G0_1_0_2_2;
    A[219] = A[149] + 0.04514991181658*G0_0_1_0_0 - 0.0383774250440912*G0_0_1_0_1 + 0.0158024691358025*G0_0_1_0_2 - 0.0383774250440912*G0_0_1_1_0 - 0.0270899470899466*G0_0_1_1_1 - 0.00225749559082862*G0_0_1_1_2 + 0.0158024691358025*G0_0_1_2_0 - 0.00225749559082862*G0_0_1_2_1 + 0.0316049382716057*G0_0_1_2_2 - 0.04514991181658*G0_1_0_0_0 + 0.0383774250440912*G0_1_0_0_1 - 0.0158024691358025*G0_1_0_0_2 + 0.0383774250440912*G0_1_0_1_0 + 0.0270899470899466*G0_1_0_1_1 + 0.00225749559082861*G0_1_0_1_2 - 0.0158024691358025*G0_1_0_2_0 + 0.00225749559082861*G0_1_0_2_1 - 0.0316049382716057*G0_1_0_2_2;
    A[103] = A[219] + 0.316049382716048*G0_0_0_0_0 - 0.0067724867724867*G0_0_0_0_1 + 0.119647266313932*G0_0_0_0_2 - 0.00677248677248669*G0_0_0_1_0 + 0.0902998236331571*G0_0_0_1_1 + 0.0293474426807762*G0_0_0_1_2 + 0.119647266313932*G0_0_0_2_0 + 0.0293474426807762*G0_0_0_2_1 - 0.0135449735449729*G0_0_0_2_2 - 0.0135449735449734*G0_0_1_0_1 + 0.0135449735449734*G0_0_1_0_2 - 0.0135449735449734*G0_0_1_1_0 + 0.0812698412698418*G0_0_1_1_1 + 0.0135449735449734*G0_0_1_2_0 - 0.0812698412698409*G0_0_1_2_2 - 0.0677248677248673*G0_1_0_0_1 + 0.0677248677248675*G0_1_0_0_2 - 0.0677248677248673*G0_1_0_1_0 + 0.0225749559082892*G0_1_0_1_1 + 0.0677248677248675*G0_1_0_2_0 - 0.0225749559082884*G0_1_0_2_2 - 0.316049382716047*G0_1_1_0_0 - 0.119647266313932*G0_1_1_0_1 + 0.0067724867724868*G0_1_1_0_2 - 0.119647266313932*G0_1_1_1_0 + 0.0135449735449735*G0_1_1_1_1 - 0.029347442680776*G0_1_1_1_2 + 0.00677248677248679*G0_1_1_2_0 - 0.029347442680776*G0_1_1_2_1 - 0.0902998236331566*G0_1_1_2_2;
    A[57] = -A[103] + 0.35216931216931*G0_0_0_0_0 + 0.189629629629629*G0_0_0_0_2 + 0.352169312169311*G0_0_0_1_1 + 0.189629629629629*G0_0_0_1_2 + 0.189629629629629*G0_0_0_2_0 + 0.189629629629629*G0_0_0_2_1 + 0.162539682539682*G0_0_0_2_2 + 0.0948148148148144*G0_0_1_0_0 + 0.0406349206349206*G0_0_1_0_2 + 0.257354497354498*G0_0_1_1_1 + 0.148994708994709*G0_0_1_1_2 + 0.0406349206349206*G0_0_1_2_0 + 0.148994708994709*G0_0_1_2_1 + 0.0812698412698414*G0_0_1_2_2 + 0.0812698412698409*G0_1_0_0_0 + 0.0767548500881833*G0_1_0_0_2 + 0.27089947089947*G0_1_0_1_1 + 0.112874779541446*G0_1_0_1_2 + 0.0767548500881833*G0_1_0_2_0 + 0.112874779541446*G0_1_0_2_1 + 0.0812698412698412*G0_1_0_2_2 - 0.0812698412698397*G0_1_1_0_0 - 0.0338624338624334*G0_1_1_0_1 + 0.00225749559082905*G0_1_1_0_2 - 0.0338624338624334*G0_1_1_1_0 + 0.0948148148148152*G0_1_1_1_1 + 0.0744973544973541*G0_1_1_1_2 + 0.00225749559082905*G0_1_1_2_0 + 0.0744973544973541*G0_1_1_2_1 + 0.0361199294532627*G0_1_1_2_2;
    A[201] = A[103] - 0.0451499118165784*G0_0_1_0_0 - 0.0158024691358027*G0_0_1_0_1 + 0.0383774250440915*G0_0_1_0_2 - 0.0158024691358027*G0_0_1_1_0 - 0.031604938271606*G0_0_1_1_1 + 0.00225749559082872*G0_0_1_1_2 + 0.0383774250440915*G0_0_1_2_0 + 0.0022574955908287*G0_0_1_2_1 + 0.0270899470899468*G0_0_1_2_2 + 0.0451499118165785*G0_1_0_0_0 + 0.0158024691358027*G0_1_0_0_1 - 0.0383774250440915*G0_1_0_0_2 + 0.0158024691358027*G0_1_0_1_0 + 0.031604938271606*G0_1_0_1_1 - 0.00225749559082872*G0_1_0_1_2 - 0.0383774250440915*G0_1_0_2_0 - 0.00225749559082872*G0_1_0_2_1 - 0.0270899470899468*G0_1_0_2_2;
    A[29] = A[27] + 0.062081128747795*G0_0_0_0_0 + 0.0011287477954144*G0_0_0_0_1 + 0.00451499118165777*G0_0_0_0_2 + 0.0011287477954144*G0_0_0_1_0 - 0.00112874779541443*G0_0_0_1_2 + 0.00451499118165776*G0_0_0_2_0 - 0.00112874779541443*G0_0_0_2_1 - 0.0711111111111105*G0_0_0_2_2 - 0.00902998236331549*G0_0_1_0_0 + 0.00902998236331566*G0_0_1_0_2 + 0.00902998236331566*G0_0_1_2_0 - 0.00902998236331553*G0_0_1_2_2;
    A[19] = -A[25] + 0.0889594356261019*G0_0_0_0_0 + 0.0125220458553792*G0_0_0_0_1 + 0.0343209876543208*G0_0_0_0_2 + 0.0125220458553792*G0_0_0_1_0 + 0.19647266313933*G0_0_0_1_1 + 0.0223985890652556*G0_0_0_1_2 + 0.0343209876543208*G0_0_0_2_0 + 0.0223985890652556*G0_0_0_2_1 + 0.0861375661375656*G0_0_0_2_2 + 0.00282186948853616*G0_0_1_0_0 - 0.00987654320987646*G0_0_1_0_1 - 0.00987654320987647*G0_0_1_1_0 + 0.00987654320987645*G0_0_1_1_2 + 0.00987654320987646*G0_0_1_2_1 - 0.00282186948853619*G0_0_1_2_2;
    A[33] = -A[36] - 0.0169312169312169*G0_1_0_0_0 + 0.00282186948853616*G0_1_0_0_2 + 0.0169312169312168*G0_1_0_1_1 - 0.00282186948853611*G0_1_0_1_2 + 0.00282186948853616*G0_1_0_2_0 - 0.00282186948853611*G0_1_0_2_1 - 0.0702645502645499*G0_1_1_0_0 - 0.0165079365079365*G0_1_1_0_1 - 0.00493827160493826*G0_1_1_0_2 - 0.0165079365079365*G0_1_1_1_0 - 0.0533333333333334*G0_1_1_1_1 - 0.00776014109347444*G0_1_1_1_2 - 0.00493827160493826*G0_1_1_2_0 - 0.00776014109347443*G0_1_1_2_1 - 0.105820105820106*G0_1_1_2_2;
    A[41] = -A[33] - 0.00197530864197541*G0_1_0_0_0 - 0.0018342151675485*G0_1_0_0_1 + 0.0136860670194003*G0_1_0_0_2 - 0.0018342151675485*G0_1_0_1_0 + 0.0324514991181659*G0_1_0_1_1 + 0.00888888888888888*G0_1_0_1_2 + 0.0136860670194003*G0_1_0_2_0 + 0.00888888888888888*G0_1_0_2_1 + 0.13121693121693*G0_1_0_2_2;
    A[62] = -A[107] + 0.00282186948853607*G0_0_1_0_0 - 0.00987654320987642*G0_0_1_0_2 - 0.00282186948853609*G0_0_1_1_1 + 0.00987654320987656*G0_0_1_1_2 - 0.00987654320987642*G0_0_1_2_0 + 0.00987654320987656*G0_0_1_2_1 + 0.0889594356261017*G0_1_1_0_0 + 0.0343209876543208*G0_1_1_0_1 + 0.0125220458553791*G0_1_1_0_2 + 0.0343209876543208*G0_1_1_1_0 + 0.0861375661375662*G0_1_1_1_1 + 0.0223985890652557*G0_1_1_1_2 + 0.0125220458553791*G0_1_1_2_0 + 0.0223985890652557*G0_1_1_2_1 + 0.196472663139329*G0_1_1_2_2;
    A[44] = A[212] + 0.00282186948853608*G0_0_1_0_0 - 0.00987654320987637*G0_0_1_0_2 - 0.00282186948853609*G0_0_1_1_1 + 0.0098765432098766*G0_0_1_1_2 - 0.00987654320987637*G0_0_1_2_0 + 0.00987654320987659*G0_0_1_2_1 - 0.00282186948853608*G0_1_0_0_0 + 0.00987654320987637*G0_1_0_0_2 + 0.00282186948853609*G0_1_0_1_1 - 0.00987654320987659*G0_1_0_1_2 + 0.00987654320987637*G0_1_0_2_0 - 0.00987654320987659*G0_1_0_2_1;
    A[172] = -A[52] - 0.0519223985890647*G0_0_0_0_0 + 0.0107231040564374*G0_0_0_0_1 - 0.0801410934744263*G0_0_0_0_2 + 0.0107231040564374*G0_0_0_1_0 + 0.0338624338624344*G0_0_0_1_1 + 0.00902998236331586*G0_0_0_1_2 - 0.0801410934744263*G0_0_0_2_0 + 0.00902998236331586*G0_0_0_2_1 - 0.0812698412698409*G0_0_0_2_2 + 0.0293474426807747*G0_0_1_0_0 + 0.00169312169312156*G0_0_1_0_1 + 0.00169312169312156*G0_0_1_1_0 - 0.00169312169312158*G0_0_1_1_2 - 0.00169312169312158*G0_0_1_2_1 - 0.0293474426807759*G0_0_1_2_2;
    A[158] = A[172] + 0.0135449735449734*G0_0_0_0_0 - 0.00564373897707233*G0_0_0_0_1 + 0.0259611992945324*G0_0_0_0_2 - 0.00564373897707233*G0_0_0_1_0 - 0.0225749559082897*G0_0_0_1_1 - 0.0056437389770723*G0_0_0_1_2 + 0.0259611992945324*G0_0_0_2_0 - 0.0056437389770723*G0_0_0_2_1 + 0.0474074074074076*G0_0_0_2_2 + 0.0135449735449735*G0_0_1_0_1 - 0.0135449735449734*G0_0_1_0_2 + 0.0135449735449735*G0_0_1_1_0 - 0.0191887125220461*G0_0_1_1_1 - 0.0135449735449734*G0_0_1_2_0 + 0.0191887125220462*G0_0_1_2_2 + 0.00902998236331543*G0_1_0_0_1 - 0.00902998236331568*G0_1_0_0_2 + 0.00902998236331544*G0_1_0_1_0 - 0.00338624338624441*G0_1_0_1_1 - 0.00902998236331568*G0_1_0_2_0 + 0.00338624338624305*G0_1_0_2_2 - 0.0135449735449739*G0_1_1_0_0 - 0.0259611992945326*G0_1_1_0_1 + 0.00564373897707236*G0_1_1_0_2 - 0.0259611992945326*G0_1_1_1_0 - 0.0474074074074077*G0_1_1_1_1 + 0.00564373897707227*G0_1_1_1_2 + 0.00564373897707236*G0_1_1_2_0 + 0.00564373897707227*G0_1_1_2_1 + 0.0225749559082893*G0_1_1_2_2;
    A[155] = -A[158] + 0.0293474426807754*G0_0_1_0_0 + 0.00169312169312164*G0_0_1_0_2 - 0.0293474426807754*G0_0_1_1_1 - 0.00169312169312179*G0_0_1_1_2 + 0.00169312169312164*G0_0_1_2_0 - 0.00169312169312178*G0_0_1_2_1 - 0.0519223985890652*G0_1_1_0_0 - 0.0801410934744263*G0_1_1_0_1 + 0.0107231040564375*G0_1_1_0_2 - 0.0801410934744263*G0_1_1_1_0 - 0.0812698412698401*G0_1_1_1_1 + 0.00902998236331567*G0_1_1_1_2 + 0.0107231040564375*G0_1_1_2_0 + 0.00902998236331566*G0_1_1_2_1 + 0.033862433862434*G0_1_1_2_2;
    A[85] = A[155] - 0.0191887125220456*G0_0_1_0_0 + 0.00564373897707247*G0_0_1_0_1 - 0.000564373897707128*G0_0_1_0_2 + 0.00564373897707247*G0_0_1_1_0 + 0.0101587301587298*G0_0_1_1_1 + 0.0011287477954146*G0_0_1_1_2 - 0.00056437389770713*G0_0_1_2_0 + 0.00112874779541459*G0_0_1_2_1 - 0.00338624338624276*G0_0_1_2_2 + 0.0191887125220456*G0_1_0_0_0 - 0.00564373897707249*G0_1_0_0_1 + 0.000564373897707128*G0_1_0_0_2 - 0.00564373897707248*G0_1_0_1_0 - 0.0101587301587299*G0_1_0_1_1 - 0.00112874779541459*G0_1_0_1_2 + 0.00056437389770713*G0_1_0_2_0 - 0.00112874779541459*G0_1_0_2_1 + 0.00338624338624276*G0_1_0_2_2;
    A[139] = A[85] + 0.0225749559082893*G0_0_0_0_0 + 0.00564373897707222*G0_0_0_0_1 + 0.00564373897707232*G0_0_0_0_2 + 0.00564373897707222*G0_0_0_1_0 - 0.0135449735449734*G0_0_0_1_1 - 0.0259611992945323*G0_0_0_1_2 + 0.00564373897707232*G0_0_0_2_0 - 0.0259611992945323*G0_0_0_2_1 - 0.0474074074074065*G0_0_0_2_2 + 0.0225749559082896*G0_0_1_0_0 + 0.0135449735449733*G0_0_1_0_1 + 0.00620811287477948*G0_0_1_0_2 + 0.0135449735449733*G0_0_1_1_0 - 0.0237037037037033*G0_0_1_1_1 - 0.0406349206349204*G0_0_1_1_2 + 0.00620811287477948*G0_0_1_2_0 - 0.0406349206349204*G0_0_1_2_1 - 0.0248324514991183*G0_0_1_2_2 + 0.0203174603174601*G0_1_0_0_1 + 0.00507936507936505*G0_1_0_0_2 + 0.0203174603174601*G0_1_0_1_0 - 0.00338624338624387*G0_1_0_1_1 - 0.0338624338624336*G0_1_0_1_2 + 0.00507936507936505*G0_1_0_2_0 - 0.0338624338624336*G0_1_0_2_1 - 0.0474074074074072*G0_1_0_2_2 + 0.0474074074074067*G0_1_1_0_0 + 0.0541798941798937*G0_1_1_0_1 + 0.0541798941798937*G0_1_1_1_0 - 0.054179894179894*G0_1_1_1_2 - 0.054179894179894*G0_1_1_2_1 - 0.0474074074074074*G0_1_1_2_2;
    A[130] = -A[85] + 0.0293474426807753*G0_1_0_0_0 + 0.00169312169312164*G0_1_0_0_2 - 0.0293474426807754*G0_1_0_1_1 - 0.00169312169312178*G0_1_0_1_2 + 0.00169312169312164*G0_1_0_2_0 - 0.00169312169312178*G0_1_0_2_1 - 0.0519223985890652*G0_1_1_0_0 - 0.0801410934744263*G0_1_1_0_1 + 0.0107231040564375*G0_1_1_0_2 - 0.0801410934744263*G0_1_1_1_0 - 0.0812698412698402*G0_1_1_1_1 + 0.00902998236331567*G0_1_1_1_2 + 0.0107231040564375*G0_1_1_2_0 + 0.00902998236331566*G0_1_1_2_1 + 0.033862433862434*G0_1_1_2_2;
    A[100] = A[130] + 0.221234567901233*G0_0_0_0_0 - 0.0440211640211638*G0_0_0_0_1 + 0.0541798941798937*G0_0_0_0_2 - 0.0440211640211638*G0_0_0_1_0 - 0.085784832451499*G0_0_0_1_1 - 0.0338624338624337*G0_0_0_1_2 + 0.0541798941798937*G0_0_0_2_0 - 0.0338624338624337*G0_0_0_2_1 + 0.0135449735449729*G0_0_0_2_2 - 0.11400352733686*G0_0_1_0_0 - 0.0282186948853615*G0_0_1_0_1 - 0.0327336860670193*G0_0_1_0_2 - 0.0282186948853615*G0_0_1_1_0 - 0.0744973544973545*G0_0_1_1_1 - 0.0327336860670192*G0_0_1_1_2 - 0.0327336860670193*G0_0_1_2_0 - 0.0327336860670192*G0_0_1_2_1 - 0.03047619047619*G0_0_1_2_2 - 0.265255731922398*G0_1_0_0_0 - 0.0169312169312169*G0_1_0_0_1 - 0.0169312169312169*G0_1_0_1_0 - 0.0428924162257494*G0_1_0_1_1 - 0.0304761904761903*G0_1_0_1_2 - 0.0304761904761903*G0_1_0_2_1 - 0.00338624338624376*G0_1_0_2_2 + 0.0767548500881823*G0_1_1_0_0 + 0.0316049382716046*G0_1_1_0_1 - 0.0180599647266315*G0_1_1_0_2 + 0.0316049382716046*G0_1_1_1_0 - 0.0316049382716047*G0_1_1_1_2 - 0.0180599647266315*G0_1_1_2_0 - 0.0316049382716047*G0_1_1_2_1 - 0.0406349206349205*G0_1_1_2_2;
    A[12] = -A[139] - 0.216155202821868*G0_0_0_0_0 - 0.00818342151675469*G0_0_0_0_2 + 0.0434567901234567*G0_0_0_1_1 + 0.0115696649029983*G0_0_0_1_2 - 0.00818342151675468*G0_0_0_2_0 + 0.0115696649029983*G0_0_0_2_1 + 0.0135449735449735*G0_0_0_2_2 - 0.221234567901233*G0_0_1_0_0 - 0.0115696649029982*G0_0_1_0_1 - 0.0115696649029982*G0_0_1_1_0 + 0.0321693121693123*G0_0_1_1_1 - 0.0036684303350969*G0_0_1_1_2 - 0.00366843033509689*G0_0_1_2_1 + 0.0248324514991181*G0_0_1_2_2 - 0.224620811287477*G0_1_0_0_0 - 0.000564373897707364*G0_1_0_0_1 - 0.0104409171075836*G0_1_0_0_2 - 0.000564373897707363*G0_1_0_1_0 + 0.0395061728395057*G0_1_0_1_1 + 0.00197530864197522*G0_1_0_1_2 - 0.0104409171075836*G0_1_0_2_0 + 0.00197530864197522*G0_1_0_2_1 + 0.0084656084656081*G0_1_0_2_2 - 0.229700176366842*G0_1_1_0_0 - 0.0138271604938272*G0_1_1_0_1 - 0.000564373897707198*G0_1_1_0_2 - 0.0138271604938272*G0_1_1_1_0 + 0.0270899470899467*G0_1_1_1_1 - 0.01326278659612*G0_1_1_1_2 - 0.000564373897707196*G0_1_1_2_0 - 0.01326278659612*G0_1_1_2_1 + 0.0208818342151674*G0_1_1_2_2;
    A[105] = A[7] - 0.322751322751322*G0_0_1_0_0 - 0.0271604938271604*G0_0_1_0_1 - 0.0172839506172839*G0_0_1_0_2 - 0.0271604938271604*G0_0_1_1_0 - 0.00317460317460316*G0_0_1_1_1 - 0.00229276895943561*G0_0_1_1_2 - 0.0172839506172839*G0_0_1_2_0 - 0.00229276895943561*G0_0_1_2_1 - 0.00599647266313909*G0_0_1_2_2 + 0.322751322751322*G0_1_0_0_0 + 0.0271604938271604*G0_1_0_0_1 + 0.0172839506172839*G0_1_0_0_2 + 0.0271604938271604*G0_1_0_1_0 + 0.00317460317460317*G0_1_0_1_1 + 0.00229276895943561*G0_1_0_1_2 + 0.0172839506172839*G0_1_0_2_0 + 0.00229276895943561*G0_1_0_2_1 + 0.00599647266313909*G0_1_0_2_2;
    A[10] = A[105] + 0.322751322751322*G0_0_0_0_0 + 0.0171075837742504*G0_0_0_0_1 + 0.0273368606701939*G0_0_0_0_2 + 0.0171075837742504*G0_0_0_1_0 + 0.0758377425044088*G0_0_0_1_1 + 0.0022927689594356*G0_0_0_1_2 + 0.0273368606701939*G0_0_0_2_0 + 0.0022927689594356*G0_0_0_2_1 - 0.0666666666666663*G0_0_0_2_2 - 0.000176366843033476*G0_0_1_0_1 + 0.000176366843033533*G0_0_1_0_2 - 0.000176366843033478*G0_0_1_1_0 + 0.0698412698412695*G0_0_1_1_1 + 0.000176366843033533*G0_0_1_2_0 - 0.0698412698412697*G0_0_1_2_2 - 0.01005291005291*G0_1_0_0_1 + 0.01005291005291*G0_1_0_0_2 - 0.01005291005291*G0_1_0_1_0 + 0.0726631393298055*G0_1_0_1_1 + 0.01005291005291*G0_1_0_2_0 - 0.0726631393298056*G0_1_0_2_2 - 0.322751322751321*G0_1_1_0_0 - 0.0273368606701939*G0_1_1_0_1 - 0.0171075837742504*G0_1_1_0_2 - 0.0273368606701939*G0_1_1_1_0 + 0.0666666666666661*G0_1_1_1_1 - 0.00229276895943569*G0_1_1_1_2 - 0.0171075837742504*G0_1_1_2_0 - 0.0022927689594357*G0_1_1_2_1 - 0.075837742504409*G0_1_1_2_2;
    A[150] = A[10] + 0.322751322751321*G0_0_1_0_0 + 0.0172839506172839*G0_0_1_0_1 + 0.0271604938271603*G0_0_1_0_2 + 0.0172839506172839*G0_0_1_1_0 + 0.00599647266313921*G0_0_1_1_1 + 0.0022927689594356*G0_0_1_1_2 + 0.0271604938271603*G0_0_1_2_0 + 0.0022927689594356*G0_0_1_2_1 + 0.00317460317460313*G0_0_1_2_2 - 0.322751322751321*G0_1_0_0_0 - 0.0172839506172839*G0_1_0_0_1 - 0.0271604938271603*G0_1_0_0_2 - 0.0172839506172839*G0_1_0_1_0 - 0.0059964726631392*G0_1_0_1_1 - 0.0022927689594356*G0_1_0_1_2 - 0.0271604938271603*G0_1_0_2_0 - 0.0022927689594356*G0_1_0_2_1 - 0.00317460317460313*G0_1_0_2_2;
    A[180] = A[12] + 0.00987654320987654*G0_0_1_0_1 - 0.00987654320987639*G0_0_1_0_2 + 0.00987654320987654*G0_0_1_1_0 - 0.0028218694885362*G0_0_1_1_1 - 0.00987654320987639*G0_0_1_2_0 + 0.0028218694885362*G0_0_1_2_2 - 0.00987654320987654*G0_1_0_0_1 + 0.00987654320987639*G0_1_0_0_2 - 0.00987654320987654*G0_1_0_1_0 + 0.00282186948853621*G0_1_0_1_1 + 0.00987654320987639*G0_1_0_2_0 - 0.00282186948853617*G0_1_0_2_2;
    A[173] = -A[181] - 0.0829629629629624*G0_0_0_0_0 - 0.0397883597883595*G0_0_0_0_2 + 0.0795767195767195*G0_0_0_1_1 + 0.00931216931216929*G0_0_0_1_2 - 0.0397883597883595*G0_0_0_2_0 + 0.00931216931216929*G0_0_0_2_1 - 0.0203174603174602*G0_0_0_2_2 + 0.0158024691358027*G0_0_1_0_0 + 0.00902998236331565*G0_0_1_0_1 + 0.00902998236331567*G0_0_1_0_2 + 0.00902998236331565*G0_0_1_1_0 + 0.0248324514991176*G0_0_1_1_1 + 0.00902998236331568*G0_0_1_2_0 + 0.024832451499118*G0_0_1_2_2 + 0.0152380952380951*G0_1_0_0_0 + 0.0031040564373897*G0_1_0_0_1 + 0.0031040564373897*G0_1_0_1_0 + 0.0338624338624334*G0_1_0_1_1 + 0.0081834215167548*G0_1_0_1_2 + 0.00818342151675479*G0_1_0_2_1 + 0.0299118165784829*G0_1_0_2_2 - 0.00451499118165803*G0_1_1_0_0 - 0.00451499118165791*G0_1_1_0_1 - 0.00225749559082892*G0_1_1_0_2 - 0.00451499118165791*G0_1_1_1_0 + 0.00451499118165783*G0_1_1_1_2 - 0.00225749559082892*G0_1_1_2_0 + 0.00451499118165783*G0_1_1_2_1 + 0.00902998236331561*G0_1_1_2_2;
    A[170] = -A[173] + 0.0270899470899473*G0_0_1_0_0 + 0.024832451499118*G0_0_1_0_1 + 0.00451499118165784*G0_0_1_0_2 + 0.024832451499118*G0_0_1_1_0 - 0.0767548500881843*G0_0_1_1_1 - 0.00451499118165789*G0_0_1_1_2 + 0.00451499118165784*G0_0_1_2_0 - 0.00451499118165789*G0_0_1_2_1 - 0.0135449735449736*G0_1_1_0_0 - 0.0383774250440917*G0_1_1_0_1 - 0.00451499118165783*G0_1_1_0_2 - 0.0383774250440917*G0_1_1_1_0 - 0.270899470899471*G0_1_1_1_1 + 0.0158024691358024*G0_1_1_1_2 - 0.00451499118165783*G0_1_1_2_0 + 0.0158024691358024*G0_1_1_2_1;
    A[86] = A[170] - 0.0135449735449735*G0_0_1_0_0 - 0.0203174603174601*G0_0_1_0_1 - 0.0203174603174601*G0_0_1_1_0 + 0.0677248677248687*G0_0_1_1_1 - 0.00225749559082884*G0_0_1_1_2 - 0.00225749559082885*G0_0_1_2_1 - 0.00902998236331543*G0_0_1_2_2 + 0.0135449735449735*G0_1_0_0_0 + 0.0203174603174601*G0_1_0_0_1 + 0.0203174603174601*G0_1_0_1_0 - 0.0677248677248687*G0_1_0_1_1 + 0.00225749559082884*G0_1_0_1_2 + 0.00225749559082884*G0_1_0_2_1 + 0.00902998236331543*G0_1_0_2_2;
    A[138] = A[86] + 0.0451499118165784*G0_0_0_0_0 + 0.0158024691358025*G0_0_0_0_1 + 0.00677248677248677*G0_0_0_0_2 + 0.0158024691358025*G0_0_0_1_0 - 0.135449735449735*G0_0_0_1_1 - 0.0383774250440915*G0_0_0_1_2 + 0.00677248677248677*G0_0_0_2_0 - 0.0383774250440915*G0_0_0_2_1 - 0.0135449735449733*G0_0_0_2_2 + 0.0270899470899471*G0_0_1_0_0 + 0.0225749559082891*G0_0_1_0_1 + 0.00677248677248674*G0_0_1_0_2 + 0.0225749559082891*G0_0_1_1_0 - 0.203174603174603*G0_0_1_1_1 - 0.0225749559082891*G0_0_1_1_2 + 0.00677248677248674*G0_0_1_2_0 - 0.0225749559082891*G0_0_1_2_1 + 0.0270899470899468*G0_0_1_2_2 + 0.00451499118165784*G0_1_0_0_0 + 0.00677248677248677*G0_1_0_0_2 - 0.0677248677248663*G0_1_0_1_1 - 0.0451499118165782*G0_1_0_1_2 + 0.00677248677248678*G0_1_0_2_0 - 0.0451499118165782*G0_1_0_2_1 + 0.004514991181658*G0_1_0_2_2 + 0.0451499118165783*G0_1_1_0_1 + 0.0451499118165783*G0_1_1_1_0 - 0.0451499118165782*G0_1_1_1_2 - 0.0451499118165782*G0_1_1_2_1;
    A[51] = -A[173] - 0.0541798941798937*G0_0_0_0_0 - 0.0248324514991179*G0_0_0_0_2 - 0.0406349206349208*G0_0_0_1_1 - 0.0158024691358025*G0_0_0_1_2 - 0.0248324514991179*G0_0_0_2_0 - 0.0158024691358025*G0_0_0_2_1 - 0.0270899470899466*G0_0_0_2_2 + 0.0135449735449735*G0_0_1_0_1 - 0.00225749559082882*G0_0_1_0_2 + 0.0135449735449735*G0_0_1_1_0 - 0.0135449735449735*G0_0_1_1_2 - 0.00225749559082881*G0_0_1_2_0 - 0.0135449735449735*G0_0_1_2_1 + 0.00451499118165775*G0_0_1_2_2 - 0.0225749559082892*G0_1_0_0_0 + 0.00225749559082892*G0_1_0_0_1 - 0.00225749559082896*G0_1_0_0_2 + 0.00225749559082892*G0_1_0_1_0 - 0.00225749559082895*G0_1_0_1_2 - 0.00225749559082896*G0_1_0_2_0 - 0.00225749559082895*G0_1_0_2_1 + 0.0270899470899469*G0_1_0_2_2 + 0.00451499118165789*G0_1_1_0_0 - 0.00451499118165783*G0_1_1_0_2 - 0.00451499118165783*G0_1_1_2_0 + 0.00451499118165791*G0_1_1_2_2;
    A[50] = -A[170] + 0.0135449735449734*G0_0_0_0_0 + 0.00451499118165777*G0_0_0_0_1 + 0.0383774250440914*G0_0_0_0_2 + 0.00451499118165777*G0_0_0_1_0 - 0.0158024691358024*G0_0_0_1_2 + 0.0383774250440914*G0_0_0_2_0 - 0.0158024691358024*G0_0_0_2_1 + 0.270899470899469*G0_0_0_2_2 + 0.00902998236331568*G0_0_1_0_0 - 0.0203174603174603*G0_0_1_0_2 - 0.203174603174604*G0_0_1_1_1 - 0.0902998236331568*G0_0_1_1_2 - 0.0203174603174603*G0_0_1_2_0 - 0.0902998236331568*G0_0_1_2_1 - 0.12641975308642*G0_0_1_2_2;
    A[99] = -A[50] - 0.284444444444443*G0_0_0_0_0 + 0.024832451499118*G0_0_0_0_1 + 0.024832451499118*G0_0_0_1_0 + 0.0722398589065254*G0_0_0_1_1 + 0.027089947089947*G0_0_0_1_2 + 0.027089947089947*G0_0_0_2_1 + 0.311534391534389*G0_0_0_2_2 + 0.347654320987652*G0_0_1_0_0 + 0.0632098765432094*G0_0_1_0_1 + 0.0632098765432096*G0_0_1_0_2 + 0.0632098765432094*G0_0_1_1_0 - 0.0270899470899473*G0_0_1_1_1 - 0.0361199294532627*G0_0_1_1_2 + 0.0632098765432096*G0_0_1_2_0 - 0.0361199294532627*G0_0_1_2_1 - 0.0270899470899472*G0_0_1_2_2 + 0.600493827160492*G0_1_0_0_0 + 0.0383774250440916*G0_1_0_0_1 + 0.0383774250440916*G0_1_0_0_2 + 0.0383774250440916*G0_1_0_1_0 + 0.0857848324514983*G0_1_0_1_1 + 0.0451499118165782*G0_1_0_1_2 + 0.0383774250440916*G0_1_0_2_0 + 0.0451499118165782*G0_1_0_2_1 + 0.0857848324514979*G0_1_0_2_2 - 0.284444444444443*G0_1_1_0_0 + 0.0248324514991181*G0_1_1_0_2 + 0.311534391534391*G0_1_1_1_1 + 0.0270899470899469*G0_1_1_1_2 + 0.0248324514991181*G0_1_1_2_0 + 0.0270899470899469*G0_1_1_2_1 + 0.0722398589065249*G0_1_1_2_2;
    A[146] = -A[138] + 0.397319223985889*G0_0_0_0_0 + 0.0744973544973542*G0_0_0_0_1 + 0.0586948853615517*G0_0_0_0_2 + 0.0744973544973542*G0_0_0_1_0 + 0.203174603174603*G0_0_0_1_1 + 0.00451499118165783*G0_0_0_1_2 + 0.0586948853615517*G0_0_0_2_0 + 0.00451499118165782*G0_0_0_2_1 + 0.00451499118165783*G0_0_0_2_2 + 0.126419753086419*G0_1_0_0_0 + 0.0902998236331565*G0_1_0_0_1 + 0.0203174603174603*G0_1_0_0_2 + 0.0902998236331565*G0_1_0_1_0 + 0.203174603174602*G0_1_0_1_1 + 0.0203174603174603*G0_1_0_2_0 - 0.00902998236331556*G0_1_0_2_2;
    A[54] = A[138] - 0.00902998236331583*G0_0_1_0_0 - 0.00225749559082891*G0_0_1_0_1 - 0.0022574955908289*G0_0_1_1_0 + 0.067724867724868*G0_0_1_1_1 - 0.0203174603174602*G0_0_1_1_2 - 0.0203174603174602*G0_0_1_2_1 - 0.0135449735449734*G0_0_1_2_2 + 0.00902998236331584*G0_1_0_0_0 + 0.00225749559082891*G0_1_0_0_1 + 0.00225749559082891*G0_1_0_1_0 - 0.067724867724868*G0_1_0_1_1 + 0.0203174603174602*G0_1_0_1_2 + 0.0203174603174602*G0_1_0_2_1 + 0.0135449735449734*G0_1_0_2_2;
    A[174] = -A[54] + 0.397319223985889*G0_0_0_0_0 + 0.0744973544973542*G0_0_0_0_1 + 0.0586948853615517*G0_0_0_0_2 + 0.0744973544973542*G0_0_0_1_0 + 0.203174603174603*G0_0_0_1_1 + 0.00451499118165784*G0_0_0_1_2 + 0.0586948853615517*G0_0_0_2_0 + 0.00451499118165783*G0_0_0_2_1 + 0.00451499118165783*G0_0_0_2_2 + 0.126419753086419*G0_0_1_0_0 + 0.0902998236331565*G0_0_1_0_1 + 0.0203174603174603*G0_0_1_0_2 + 0.0902998236331565*G0_0_1_1_0 + 0.203174603174602*G0_0_1_1_1 + 0.0203174603174603*G0_0_1_2_0 - 0.00902998236331555*G0_0_1_2_2;
    A[141] = A[99] + 0.248324514991181*G0_0_1_0_0 - 0.0451499118165781*G0_0_1_0_1 - 0.0451499118165783*G0_0_1_0_2 - 0.0451499118165781*G0_0_1_1_0 - 0.0225749559082893*G0_0_1_1_1 - 0.0112874779541447*G0_0_1_1_2 - 0.0451499118165783*G0_0_1_2_0 - 0.0112874779541447*G0_0_1_2_1 - 0.0225749559082893*G0_0_1_2_2 - 0.248324514991181*G0_1_0_0_0 + 0.0451499118165781*G0_1_0_0_1 + 0.0451499118165783*G0_1_0_0_2 + 0.0451499118165781*G0_1_0_1_0 + 0.0225749559082893*G0_1_0_1_1 + 0.0112874779541447*G0_1_0_1_2 + 0.0451499118165783*G0_1_0_2_0 + 0.0112874779541447*G0_1_0_2_1 + 0.0225749559082893*G0_1_0_2_2;
    A[95] = A[54] - 0.0586948853615516*G0_0_0_0_0 - 0.0203174603174602*G0_0_0_0_1 - 0.0203174603174602*G0_0_0_1_0 + 0.135449735449735*G0_0_0_1_1 + 0.00902998236331568*G0_0_0_1_2 + 0.00902998236331568*G0_0_0_2_1 - 0.257354497354495*G0_0_0_2_2 - 0.0135449735449734*G0_0_1_0_1 + 0.0135449735449735*G0_0_1_0_2 - 0.0135449735449734*G0_0_1_1_0 + 0.148994708994708*G0_0_1_1_1 + 0.0135449735449735*G0_0_1_2_0 - 0.148994708994708*G0_0_1_2_2 - 0.0158024691358024*G0_1_0_0_1 + 0.0158024691358024*G0_1_0_0_2 - 0.0158024691358024*G0_1_0_1_0 + 0.230264550264549*G0_1_0_1_1 + 0.0158024691358024*G0_1_0_2_0 - 0.230264550264549*G0_1_0_2_2 + 0.0586948853615515*G0_1_1_0_0 + 0.0203174603174602*G0_1_1_0_2 + 0.257354497354496*G0_1_1_1_1 - 0.00902998236331554*G0_1_1_1_2 + 0.0203174603174602*G0_1_1_2_0 - 0.00902998236331552*G0_1_1_2_1 - 0.135449735449734*G0_1_1_2_2;
    A[78] = -A[86] + 0.0135449735449734*G0_0_0_0_0 + 0.00451499118165777*G0_0_0_0_1 + 0.0383774250440914*G0_0_0_0_2 + 0.00451499118165777*G0_0_0_1_0 - 0.0158024691358024*G0_0_0_1_2 + 0.0383774250440914*G0_0_0_2_0 - 0.0158024691358024*G0_0_0_2_1 + 0.270899470899469*G0_0_0_2_2 + 0.00902998236331568*G0_1_0_0_0 - 0.0203174603174603*G0_1_0_0_2 - 0.203174603174604*G0_1_0_1_1 - 0.0902998236331568*G0_1_0_1_2 - 0.0203174603174603*G0_1_0_2_0 - 0.0902998236331568*G0_1_0_2_1 - 0.12641975308642*G0_1_0_2_2;
    A[123] = -A[78] + 0.00902998236331582*G0_1_0_0_0 - 0.0203174603174603*G0_1_0_0_1 - 0.0203174603174603*G0_1_0_1_0 - 0.12641975308642*G0_1_0_1_1 - 0.0902998236331568*G0_1_0_1_2 - 0.0902998236331568*G0_1_0_2_1 - 0.203174603174602*G0_1_0_2_2 + 0.0135449735449736*G0_1_1_0_0 + 0.0383774250440916*G0_1_1_0_1 + 0.00451499118165785*G0_1_1_0_2 + 0.0383774250440916*G0_1_1_1_0 + 0.270899470899471*G0_1_1_1_1 - 0.0158024691358025*G0_1_1_1_2 + 0.00451499118165785*G0_1_1_2_0 - 0.0158024691358025*G0_1_1_2_1;
    A[98] = -A[95] + 0.12641975308642*G0_0_1_0_0 + 0.0203174603174604*G0_0_1_0_1 + 0.0902998236331567*G0_0_1_0_2 + 0.0203174603174604*G0_0_1_1_0 - 0.0090299823633152*G0_0_1_1_1 + 0.0902998236331567*G0_0_1_2_0 + 0.203174603174602*G0_0_1_2_2 + 0.397319223985889*G0_1_1_0_0 + 0.0586948853615518*G0_1_1_0_1 + 0.0744973544973542*G0_1_1_0_2 + 0.0586948853615518*G0_1_1_1_0 + 0.00451499118165812*G0_1_1_1_1 + 0.00451499118165801*G0_1_1_1_2 + 0.0744973544973542*G0_1_1_2_0 + 0.00451499118165802*G0_1_1_2_1 + 0.203174603174603*G0_1_1_2_2;
    A[22] = A[106] - 0.00522045855379163*G0_0_1_0_0 + 0.000105820105820098*G0_0_1_0_1 + 0.000105820105820097*G0_0_1_1_0 - 0.000105820105820133*G0_0_1_1_2 - 0.000105820105820133*G0_0_1_2_1 + 0.00522045855379173*G0_0_1_2_2 + 0.00522045855379163*G0_1_0_0_0 - 0.000105820105820098*G0_1_0_0_1 - 0.000105820105820098*G0_1_0_1_0 + 0.000105820105820133*G0_1_0_1_2 + 0.000105820105820133*G0_1_0_2_1 - 0.00522045855379174*G0_1_0_2_2;
    A[9] = A[135] + 0.608112874779539*G0_0_1_0_0 + 0.039506172839506*G0_0_1_0_1 + 0.039506172839506*G0_0_1_0_2 + 0.039506172839506*G0_0_1_1_0 + 0.00423280423280417*G0_0_1_1_1 + 0.00211640211640208*G0_0_1_1_2 + 0.039506172839506*G0_0_1_2_0 + 0.00211640211640208*G0_0_1_2_1 + 0.00423280423280418*G0_0_1_2_2 - 0.608112874779539*G0_1_0_0_0 - 0.039506172839506*G0_1_0_0_1 - 0.039506172839506*G0_1_0_0_2 - 0.039506172839506*G0_1_0_1_0 - 0.00423280423280417*G0_1_0_1_1 - 0.00211640211640208*G0_1_0_1_2 - 0.039506172839506*G0_1_0_2_0 - 0.00211640211640208*G0_1_0_2_1 - 0.00423280423280418*G0_1_0_2_2;
    A[90] = A[9] + 0.608112874779539*G0_0_0_0_0 + 0.0331569664902997*G0_0_0_0_1 + 0.0458553791887122*G0_0_0_0_2 + 0.0331569664902997*G0_0_0_1_0 + 0.0352733686067017*G0_0_0_1_1 + 0.00211640211640209*G0_0_0_1_2 + 0.0458553791887123*G0_0_0_2_0 + 0.00211640211640209*G0_0_0_2_1 - 0.0268077601410933*G0_0_0_2_2 - 0.00634920634920636*G0_0_1_0_1 + 0.00634920634920625*G0_0_1_0_2 - 0.00634920634920636*G0_0_1_1_0 + 0.0310405643738975*G0_0_1_1_1 + 0.00634920634920625*G0_0_1_2_0 - 0.0310405643738976*G0_0_1_2_2 - 0.00634920634920631*G0_1_0_0_1 + 0.00634920634920631*G0_1_0_0_2 - 0.00634920634920631*G0_1_0_1_0 + 0.0310405643738975*G0_1_0_1_1 + 0.00634920634920631*G0_1_0_2_0 - 0.0310405643738976*G0_1_0_2_2 - 0.608112874779539*G0_1_1_0_0 - 0.0458553791887123*G0_1_1_0_1 - 0.0331569664902997*G0_1_1_0_2 - 0.0458553791887123*G0_1_1_1_0 + 0.0268077601410933*G0_1_1_1_1 - 0.00211640211640211*G0_1_1_1_2 - 0.0331569664902997*G0_1_1_2_0 - 0.00211640211640211*G0_1_1_2_1 - 0.0352733686067018*G0_1_1_2_2;
    A[6] = A[90] - 0.608112874779538*G0_0_1_0_0 - 0.039506172839506*G0_0_1_0_1 - 0.0395061728395059*G0_0_1_0_2 - 0.039506172839506*G0_0_1_1_0 - 0.00423280423280418*G0_0_1_1_1 - 0.00211640211640209*G0_0_1_1_2 - 0.0395061728395059*G0_0_1_2_0 - 0.00211640211640209*G0_0_1_2_1 - 0.00423280423280412*G0_0_1_2_2 + 0.608112874779538*G0_1_0_0_0 + 0.039506172839506*G0_1_0_0_1 + 0.0395061728395059*G0_1_0_0_2 + 0.039506172839506*G0_1_0_1_0 + 0.00423280423280418*G0_1_0_1_1 + 0.00211640211640209*G0_1_0_1_2 + 0.0395061728395059*G0_1_0_2_0 + 0.00211640211640209*G0_1_0_2_1 + 0.00423280423280412*G0_1_0_2_2;
    A[34] = -A[37] + 0.00282186948853607*G0_1_0_0_0 - 0.00987654320987642*G0_1_0_0_2 - 0.00282186948853609*G0_1_0_1_1 + 0.00987654320987656*G0_1_0_1_2 - 0.00987654320987642*G0_1_0_2_0 + 0.00987654320987656*G0_1_0_2_1 + 0.0889594356261017*G0_1_1_0_0 + 0.0343209876543208*G0_1_1_0_1 + 0.0125220458553791*G0_1_1_0_2 + 0.0343209876543208*G0_1_1_1_0 + 0.0861375661375662*G0_1_1_1_1 + 0.0223985890652557*G0_1_1_1_2 + 0.0125220458553791*G0_1_1_2_0 + 0.0223985890652557*G0_1_1_2_1 + 0.196472663139329*G0_1_1_2_2;
    A[96] = A[144] - 0.248324514991181*G0_0_0_0_0 - 0.0564373897707228*G0_0_0_0_1 + 0.14673721340388*G0_0_0_0_2 - 0.0564373897707228*G0_0_0_1_0 - 0.203174603174602*G0_0_0_1_1 + 0.0112874779541446*G0_0_0_1_2 + 0.14673721340388*G0_0_0_2_0 + 0.0112874779541446*G0_0_0_2_1 + 0.24832451499118*G0_0_0_2_2 - 0.101587301587301*G0_0_1_0_1 + 0.101587301587301*G0_0_1_0_2 - 0.101587301587301*G0_0_1_1_0 - 0.225749559082891*G0_0_1_1_1 + 0.101587301587301*G0_0_1_2_0 + 0.225749559082891*G0_0_1_2_2 - 0.101587301587301*G0_1_0_0_1 + 0.101587301587301*G0_1_0_0_2 - 0.101587301587301*G0_1_0_1_0 - 0.225749559082891*G0_1_0_1_1 + 0.101587301587301*G0_1_0_2_0 + 0.225749559082891*G0_1_0_2_2 + 0.248324514991181*G0_1_1_0_0 - 0.146737213403879*G0_1_1_0_1 + 0.0564373897707229*G0_1_1_0_2 - 0.146737213403879*G0_1_1_1_0 - 0.24832451499118*G0_1_1_1_1 - 0.0112874779541446*G0_1_1_1_2 + 0.0564373897707229*G0_1_1_2_0 - 0.0112874779541446*G0_1_1_2_1 + 0.203174603174602*G0_1_1_2_2;
    A[81] = A[95] + 0.00902998236331553*G0_0_1_0_0 + 0.00225749559082894*G0_0_1_0_2 + 0.0135449735449731*G0_0_1_1_1 + 0.0203174603174601*G0_0_1_1_2 + 0.00225749559082894*G0_0_1_2_0 + 0.0203174603174601*G0_0_1_2_1 - 0.0677248677248676*G0_0_1_2_2 - 0.00902998236331552*G0_1_0_0_0 - 0.00225749559082894*G0_1_0_0_2 - 0.0135449735449732*G0_1_0_1_1 - 0.0203174603174602*G0_1_0_1_2 - 0.00225749559082894*G0_1_0_2_0 - 0.0203174603174602*G0_1_0_2_1 + 0.0677248677248676*G0_1_0_2_2;
    A[126] = -A[81] + 0.12641975308642*G0_1_0_0_0 + 0.0203174603174604*G0_1_0_0_1 + 0.0902998236331567*G0_1_0_0_2 + 0.0203174603174604*G0_1_0_1_0 - 0.00902998236331521*G0_1_0_1_1 + 0.0902998236331567*G0_1_0_2_0 + 0.203174603174602*G0_1_0_2_2 + 0.397319223985889*G0_1_1_0_0 + 0.0586948853615518*G0_1_1_0_1 + 0.0744973544973542*G0_1_1_0_2 + 0.0586948853615518*G0_1_1_1_0 + 0.00451499118165812*G0_1_1_1_1 + 0.00451499118165802*G0_1_1_1_2 + 0.0744973544973542*G0_1_1_2_0 + 0.00451499118165802*G0_1_1_2_1 + 0.203174603174603*G0_1_1_2_2;
    A[156] = A[100] - 0.141093474426808*G0_0_1_0_0 + 0.0169312169312169*G0_0_1_0_1 + 0.0338624338624337*G0_0_1_0_2 + 0.0169312169312169*G0_0_1_1_0 + 0.0124162257495595*G0_0_1_1_1 + 0.00169312169312176*G0_0_1_1_2 + 0.0338624338624337*G0_0_1_2_0 + 0.00169312169312176*G0_0_1_2_1 + 0.0237037037037037*G0_0_1_2_2 + 0.141093474426808*G0_1_0_0_0 - 0.0169312169312169*G0_1_0_0_1 - 0.0338624338624337*G0_1_0_0_2 - 0.0169312169312169*G0_1_0_1_0 - 0.0124162257495595*G0_1_0_1_1 - 0.00169312169312175*G0_1_0_1_2 - 0.0338624338624337*G0_1_0_2_0 - 0.00169312169312177*G0_1_0_2_1 - 0.0237037037037037*G0_1_0_2_2;
    A[142] = A[156] - 0.158024691358023*G0_0_0_0_0 + 0.0316049382716048*G0_0_0_0_1 - 0.0485361552028215*G0_0_0_0_2 + 0.0316049382716048*G0_0_0_1_0 + 0.0677248677248678*G0_0_0_1_1 + 0.00790123456790121*G0_0_0_1_2 - 0.0485361552028215*G0_0_0_2_0 + 0.00790123456790121*G0_0_0_2_1 - 0.0609523809523805*G0_0_0_2_2 + 0.00338624338624337*G0_0_1_0_1 - 0.00338624338624334*G0_0_1_0_2 + 0.00338624338624337*G0_0_1_1_0 + 0.0586948853615517*G0_0_1_1_1 - 0.00338624338624334*G0_0_1_2_0 - 0.0586948853615517*G0_0_1_2_2 - 0.0135449735449734*G0_1_0_0_1 + 0.0135449735449736*G0_1_0_0_2 - 0.0135449735449734*G0_1_0_1_0 + 0.0474074074074076*G0_1_0_1_1 + 0.0135449735449736*G0_1_0_2_0 - 0.0474074074074073*G0_1_0_2_2 + 0.158024691358024*G0_1_1_0_0 + 0.0485361552028216*G0_1_1_0_1 - 0.0316049382716048*G0_1_1_0_2 + 0.0485361552028216*G0_1_1_1_0 + 0.0609523809523806*G0_1_1_1_1 - 0.00790123456790132*G0_1_1_1_2 - 0.0316049382716048*G0_1_1_2_0 - 0.00790123456790132*G0_1_1_2_1 - 0.0677248677248675*G0_1_1_2_2;
    A[210] = A[14] - 0.00141093474426808*G0_0_1_0_1 + 0.00141093474426808*G0_0_1_0_2 - 0.00141093474426808*G0_0_1_1_0 + 0.00395061728395066*G0_0_1_1_1 + 0.00451499118165784*G0_0_1_1_2 + 0.00141093474426808*G0_0_1_2_0 + 0.00451499118165782*G0_0_1_2_1 - 0.0129805996472664*G0_0_1_2_2 + 0.00141093474426808*G0_1_0_0_1 - 0.00141093474426808*G0_1_0_0_2 + 0.00141093474426808*G0_1_0_1_0 - 0.00395061728395065*G0_1_0_1_1 - 0.00451499118165783*G0_1_0_1_2 - 0.00141093474426808*G0_1_0_2_0 - 0.00451499118165782*G0_1_0_2_1 + 0.0129805996472664*G0_1_0_2_2;
    A[17] = -0.000476190476190455*G0_0_1_0_0 - 0.00231922398589065*G0_0_1_0_1 - 0.00231922398589064*G0_0_1_0_2 - 0.00231922398589065*G0_0_1_1_0 - 0.0231922398589066*G0_0_1_1_1 - 0.000238095238095249*G0_0_1_1_2 - 0.00231922398589064*G0_0_1_2_0 - 0.000238095238095249*G0_0_1_2_1 - 0.0231922398589064*G0_0_1_2_2;
    A[2] = -A[17] + 0.022716049382716*G0_0_1_0_0 - 0.0020811287477954*G0_0_1_0_2 - 0.0227160493827161*G0_0_1_1_1 + 0.0020811287477954*G0_0_1_1_2 - 0.0020811287477954*G0_0_1_2_0 + 0.0020811287477954*G0_0_1_2_1 + 0.0231922398589064*G0_1_1_0_0 + 0.00231922398589064*G0_1_1_0_1 + 0.000238095238095254*G0_1_1_0_2 + 0.00231922398589064*G0_1_1_1_0 + 0.000476190476190448*G0_1_1_1_1 + 0.00231922398589066*G0_1_1_1_2 + 0.000238095238095254*G0_1_1_2_0 + 0.00231922398589066*G0_1_1_2_1 + 0.0231922398589066*G0_1_1_2_2;
    A[134] = -A[89] + 0.112874779541445*G0_1_0_0_0 + 0.180599647266314*G0_1_0_0_2 - 0.112874779541446*G0_1_0_1_1 - 0.180599647266313*G0_1_0_1_2 + 0.180599647266314*G0_1_0_2_0 - 0.180599647266313*G0_1_0_2_1 - 0.33410934744268*G0_1_1_0_0 - 0.241552028218694*G0_1_1_0_1 - 0.0790123456790122*G0_1_1_0_2 - 0.241552028218694*G0_1_1_1_0 - 0.446984126984125*G0_1_1_1_1 - 0.259611992945325*G0_1_1_1_2 - 0.0790123456790122*G0_1_1_2_0 - 0.259611992945325*G0_1_1_2_1 - 0.361199294532627*G0_1_1_2_2;
    A[186] = A[134] - 0.857848324514987*G0_0_0_0_0 - 0.0812698412698411*G0_0_0_0_1 - 0.234779541446207*G0_0_0_0_2 - 0.0812698412698411*G0_0_0_1_0 - 0.144479717813051*G0_0_0_1_1 - 0.225749559082892*G0_0_0_1_2 - 0.234779541446207*G0_0_0_2_0 - 0.225749559082892*G0_0_0_2_1 - 0.352169312169313*G0_0_0_2_2 - 0.108359788359789*G0_0_1_0_0 - 0.0406349206349205*G0_0_1_0_1 - 0.234779541446207*G0_0_1_0_2 - 0.0406349206349205*G0_0_1_1_0 - 0.14447971781305*G0_0_1_1_1 - 0.266384479717812*G0_0_1_1_2 - 0.234779541446207*G0_0_1_2_0 - 0.266384479717812*G0_0_1_2_1 - 1.10165784832451*G0_0_1_2_2 - 0.370229276895941*G0_1_0_0_0 - 0.0948148148148142*G0_1_0_0_1 - 0.234779541446208*G0_1_0_0_2 - 0.0948148148148142*G0_1_0_1_0 - 0.144479717813051*G0_1_0_1_1 - 0.212204585537918*G0_1_0_1_2 - 0.234779541446208*G0_1_0_2_0 - 0.212204585537918*G0_1_0_2_1 - 0.839788359788359*G0_1_0_2_2 + 0.731428571428568*G0_1_1_0_0 + 0.171569664902997*G0_1_1_0_1 + 0.171569664902997*G0_1_1_1_0 - 0.171569664902997*G0_1_1_1_2 - 0.171569664902997*G0_1_1_2_1 - 0.731428571428568*G0_1_1_2_2;
    A[218] = A[134] + 0.0812698412698408*G0_0_1_0_0 - 0.00225749559082887*G0_0_1_0_1 + 0.124162257495591*G0_0_1_0_2 - 0.00225749559082887*G0_0_1_1_0 - 0.0316049382716046*G0_0_1_1_1 - 0.0564373897707227*G0_0_1_1_2 + 0.124162257495591*G0_0_1_2_0 - 0.0564373897707227*G0_0_1_2_1 - 0.18059964726631*G0_0_1_2_2 - 0.0812698412698408*G0_1_0_0_0 + 0.00225749559082887*G0_1_0_0_1 - 0.124162257495591*G0_1_0_0_2 + 0.00225749559082887*G0_1_0_1_0 + 0.0316049382716046*G0_1_0_1_1 + 0.0564373897707227*G0_1_0_1_2 - 0.124162257495591*G0_1_0_2_0 + 0.0564373897707227*G0_1_0_2_1 + 0.18059964726631*G0_1_0_2_2;
    A[215] = -A[218] + 0.112874779541445*G0_0_1_0_0 + 0.180599647266314*G0_0_1_0_2 - 0.112874779541446*G0_0_1_1_1 - 0.180599647266313*G0_0_1_1_2 + 0.180599647266314*G0_0_1_2_0 - 0.180599647266313*G0_0_1_2_1 - 0.33410934744268*G0_1_1_0_0 - 0.241552028218694*G0_1_1_0_1 - 0.0790123456790122*G0_1_1_0_2 - 0.241552028218694*G0_1_1_1_0 - 0.446984126984125*G0_1_1_1_1 - 0.259611992945325*G0_1_1_1_2 - 0.0790123456790122*G0_1_1_2_0 - 0.259611992945325*G0_1_1_2_1 - 0.361199294532626*G0_1_1_2_2;
    A[69] = A[139] - 0.00338624338624445*G0_0_1_0_0 + 0.00112874779541432*G0_0_1_0_1 - 0.000564373897707302*G0_0_1_0_2 + 0.00112874779541432*G0_0_1_1_0 + 0.0101587301587296*G0_0_1_1_1 + 0.00564373897707215*G0_0_1_1_2 - 0.000564373897707302*G0_0_1_2_0 + 0.00564373897707214*G0_0_1_2_1 - 0.0191887125220461*G0_0_1_2_2 + 0.00338624338624445*G0_1_0_0_0 - 0.00112874779541432*G0_1_0_0_1 + 0.000564373897707305*G0_1_0_0_2 - 0.00112874779541432*G0_1_0_1_0 - 0.0101587301587296*G0_1_0_1_1 - 0.00564373897707214*G0_1_0_1_2 + 0.000564373897707306*G0_1_0_2_0 - 0.00564373897707213*G0_1_0_2_1 + 0.0191887125220461*G0_1_0_2_2;
    A[94] = A[69] - 0.0135449735449737*G0_0_0_0_0 - 0.000564373897707215*G0_0_0_0_1 - 0.00564373897707238*G0_0_0_0_2 - 0.000564373897707213*G0_0_0_1_0 - 0.0225749559082893*G0_0_0_1_1 - 0.0248324514991183*G0_0_0_1_2 - 0.00564373897707238*G0_0_0_2_0 - 0.0248324514991183*G0_0_0_2_1 + 0.0135449735449723*G0_0_0_2_2 - 0.0338624338624342*G0_0_1_1_1 + 0.0338624338624335*G0_0_1_2_2 + 0.00169312169312179*G0_1_0_0_1 - 0.0016931216931217*G0_1_0_0_2 + 0.00169312169312179*G0_1_0_1_0 - 0.00451499118165807*G0_1_0_1_1 - 0.0016931216931217*G0_1_0_2_0 + 0.00451499118165763*G0_1_0_2_2 + 0.013544973544975*G0_1_1_0_0 + 0.00564373897707248*G0_1_1_0_1 + 0.000564373897707341*G0_1_1_0_2 + 0.00564373897707248*G0_1_1_1_0 - 0.0135449735449735*G0_1_1_1_1 + 0.0248324514991181*G0_1_1_1_2 + 0.000564373897707341*G0_1_1_2_0 + 0.0248324514991181*G0_1_1_2_1 + 0.022574955908289*G0_1_1_2_2;
    A[66] = A[94] + 0.00338624338624387*G0_0_1_0_0 + 0.000564373897707402*G0_0_1_0_1 - 0.00112874779541452*G0_0_1_0_2 + 0.000564373897707402*G0_0_1_1_0 + 0.0191887125220465*G0_0_1_1_1 - 0.00564373897707197*G0_0_1_1_2 - 0.00112874779541453*G0_0_1_2_0 - 0.00564373897707197*G0_0_1_2_1 - 0.0101587301587297*G0_0_1_2_2 - 0.00338624338624386*G0_1_0_0_0 - 0.000564373897707402*G0_1_0_0_1 + 0.00112874779541453*G0_1_0_0_2 - 0.000564373897707402*G0_1_0_1_0 - 0.0191887125220465*G0_1_0_1_1 + 0.005643738977072*G0_1_0_1_2 + 0.00112874779541453*G0_1_0_2_0 + 0.005643738977072*G0_1_0_2_1 + 0.0101587301587298*G0_1_0_2_2;
    A[48] = -A[56] + 0.112874779541446*G0_0_0_0_0 + 0.101587301587301*G0_0_0_0_1 + 0.112874779541446*G0_0_0_0_2 + 0.101587301587301*G0_0_0_1_0 + 0.406349206349206*G0_0_0_1_1 + 0.203174603174603*G0_0_0_1_2 + 0.112874779541446*G0_0_0_2_0 + 0.203174603174603*G0_0_0_2_1 + 0.338624338624337*G0_0_0_2_2 + 0.0225749559082892*G0_1_0_0_0 + 0.0451499118165781*G0_1_0_0_1 + 0.0112874779541446*G0_1_0_0_2 + 0.045149911816578*G0_1_0_1_0 - 0.248324514991182*G0_1_0_1_1 + 0.0451499118165783*G0_1_0_1_2 + 0.0112874779541446*G0_1_0_2_0 + 0.0451499118165783*G0_1_0_2_1 + 0.0225749559082891*G0_1_0_2_2;
    A[39] = A[41] - 0.00959435626102287*G0_1_0_0_0 + 0.00959435626102287*G0_1_0_0_1 + 0.00959435626102287*G0_1_0_1_0 - 0.00959435626102308*G0_1_0_1_1 + 0.0338624338624337*G0_1_1_0_0 + 0.00479717813051139*G0_1_1_0_1 - 0.0019753086419753*G0_1_1_0_2 + 0.00479717813051139*G0_1_1_1_0 - 0.043456790123457*G0_1_1_1_1 + 0.00197530864197526*G0_1_1_1_2 - 0.0019753086419753*G0_1_1_2_0 + 0.00197530864197526*G0_1_1_2_1;
    A[42] = -A[39] - 0.000564373897707342*G0_1_0_0_0 + 0.000282186948853624*G0_1_0_0_1 - 0.000423280423280415*G0_1_0_0_2 + 0.000282186948853624*G0_1_0_1_0 + 0.000423280423280514*G0_1_0_1_2 - 0.000423280423280417*G0_1_0_2_0 + 0.000423280423280516*G0_1_0_2_1 - 0.0426102292768958*G0_1_1_0_0 - 0.0237037037037036*G0_1_1_0_1 - 0.000705467372133972*G0_1_1_0_2 - 0.0237037037037036*G0_1_1_1_0 - 0.0143915343915342*G0_1_1_1_1 + 0.00282186948853623*G0_1_1_1_2 - 0.000705467372133973*G0_1_1_2_0 + 0.00282186948853623*G0_1_1_2_1 + 0.0578483245149913*G0_1_1_2_2;
    A[182] = A[42] + 0.0129805996472662*G0_0_1_0_0 - 0.0045149911816578*G0_0_1_0_1 - 0.00141093474426807*G0_0_1_0_2 - 0.0045149911816578*G0_0_1_1_0 - 0.00395061728395056*G0_0_1_1_1 + 0.00141093474426815*G0_0_1_1_2 - 0.00141093474426807*G0_0_1_2_0 + 0.00141093474426816*G0_0_1_2_1 - 0.0129805996472662*G0_1_0_0_0 + 0.0045149911816578*G0_1_0_0_1 + 0.00141093474426807*G0_1_0_0_2 + 0.0045149911816578*G0_1_0_1_0 + 0.00395061728395056*G0_1_0_1_1 - 0.00141093474426815*G0_1_0_1_2 + 0.00141093474426807*G0_1_0_2_0 - 0.00141093474426816*G0_1_0_2_1;
    A[137] = A[39] - 0.0135449735449735*G0_0_1_0_0 + 0.00479717813051142*G0_0_1_0_1 + 0.000987654320987658*G0_0_1_0_2 + 0.00479717813051143*G0_0_1_1_0 + 0.00395061728395061*G0_0_1_1_1 - 0.000987654320987653*G0_0_1_1_2 + 0.000987654320987658*G0_0_1_2_0 - 0.000987654320987652*G0_0_1_2_1 + 0.0135449735449735*G0_1_0_0_0 - 0.00479717813051142*G0_1_0_0_1 - 0.000987654320987658*G0_1_0_0_2 - 0.00479717813051142*G0_1_0_1_0 - 0.00395061728395061*G0_1_0_1_1 + 0.000987654320987652*G0_1_0_1_2 - 0.000987654320987658*G0_1_0_2_0 + 0.000987654320987652*G0_1_0_2_1;
    A[43] = A[42] - 0.00902998236331552*G0_1_0_0_0 + 0.00902998236331562*G0_1_0_0_1 + 0.00902998236331562*G0_1_0_1_0 - 0.00902998236331573*G0_1_0_1_1 + 0.0620811287477951*G0_1_1_0_0 + 0.00451499118165774*G0_1_1_0_1 + 0.00112874779541435*G0_1_1_0_2 + 0.00451499118165774*G0_1_1_1_0 - 0.0711111111111111*G0_1_1_1_1 - 0.00112874779541467*G0_1_1_1_2 + 0.00112874779541435*G0_1_1_2_0 - 0.00112874779541466*G0_1_1_2_1;
    A[197] = A[182] - 0.00902998236331552*G0_0_1_0_0 + 0.00902998236331562*G0_0_1_0_1 + 0.00902998236331562*G0_0_1_1_0 - 0.00902998236331574*G0_0_1_1_1 + 0.0620811287477951*G0_1_1_0_0 + 0.00451499118165774*G0_1_1_0_1 + 0.00112874779541435*G0_1_1_0_2 + 0.00451499118165774*G0_1_1_1_0 - 0.0711111111111111*G0_1_1_1_1 - 0.00112874779541467*G0_1_1_1_2 + 0.00112874779541435*G0_1_1_2_0 - 0.00112874779541467*G0_1_1_2_1;
    A[167] = A[137] + 0.00959435626102286*G0_0_1_0_0 - 0.00959435626102287*G0_0_1_0_1 - 0.00959435626102288*G0_0_1_1_0 + 0.00959435626102307*G0_0_1_1_1 - 0.0338624338624337*G0_1_1_0_0 - 0.00479717813051139*G0_1_1_0_1 + 0.0019753086419753*G0_1_1_0_2 - 0.00479717813051139*G0_1_1_1_0 + 0.043456790123457*G0_1_1_1_1 - 0.00197530864197526*G0_1_1_1_2 + 0.0019753086419753*G0_1_1_2_0 - 0.00197530864197526*G0_1_1_2_1;
    A[47] = -A[167] - 0.00197530864197541*G0_0_1_0_0 - 0.00183421516754851*G0_0_1_0_1 + 0.0136860670194002*G0_0_1_0_2 - 0.00183421516754851*G0_0_1_1_0 + 0.0324514991181659*G0_0_1_1_1 + 0.00888888888888888*G0_0_1_1_2 + 0.0136860670194002*G0_0_1_2_0 + 0.00888888888888888*G0_0_1_2_1 + 0.13121693121693*G0_0_1_2_2;
    A[92] = -A[47] - 0.0169312169312169*G0_0_1_0_0 + 0.00282186948853616*G0_0_1_0_2 + 0.0169312169312168*G0_0_1_1_1 - 0.00282186948853611*G0_0_1_1_2 + 0.00282186948853616*G0_0_1_2_0 - 0.00282186948853611*G0_0_1_2_1 - 0.0702645502645499*G0_1_1_0_0 - 0.0165079365079365*G0_1_1_0_1 - 0.00493827160493826*G0_1_1_0_2 - 0.0165079365079365*G0_1_1_1_0 - 0.0533333333333334*G0_1_1_1_1 - 0.00776014109347443*G0_1_1_1_2 - 0.00493827160493826*G0_1_1_2_0 - 0.00776014109347443*G0_1_1_2_1 - 0.105820105820106*G0_1_1_2_2;
    A[121] = A[91] - 0.0338624338624336*G0_0_0_0_0 + 0.00197530864197531*G0_0_0_0_1 - 0.0047971781305114*G0_0_0_0_2 + 0.00197530864197531*G0_0_0_1_0 - 0.00197530864197528*G0_0_0_1_2 - 0.00479717813051139*G0_0_0_2_0 - 0.00197530864197528*G0_0_0_2_1 + 0.0434567901234566*G0_0_0_2_2 + 0.00959435626102303*G0_1_0_0_0 - 0.00959435626102288*G0_1_0_0_2 - 0.00959435626102288*G0_1_0_2_0 + 0.00959435626102282*G0_1_0_2_2;
    A[76] = -A[121] - 0.00197530864197541*G0_1_0_0_0 + 0.0136860670194003*G0_1_0_0_1 - 0.00183421516754853*G0_1_0_0_2 + 0.0136860670194003*G0_1_0_1_0 + 0.131216931216931*G0_1_0_1_1 + 0.00888888888888886*G0_1_0_1_2 - 0.00183421516754853*G0_1_0_2_0 + 0.00888888888888886*G0_1_0_2_1 + 0.0324514991181655*G0_1_0_2_2;
    A[136] = -A[76] - 0.07026455026455*G0_0_0_0_0 - 0.00493827160493828*G0_0_0_0_1 - 0.0165079365079364*G0_0_0_0_2 - 0.00493827160493828*G0_0_0_1_0 - 0.105820105820106*G0_0_0_1_1 - 0.00776014109347441*G0_0_0_1_2 - 0.0165079365079364*G0_0_0_2_0 - 0.00776014109347441*G0_0_0_2_1 - 0.0533333333333331*G0_0_0_2_2 - 0.0169312169312168*G0_1_0_0_0 + 0.00282186948853617*G0_1_0_0_1 + 0.00282186948853617*G0_1_0_1_0 - 0.00282186948853613*G0_1_0_1_2 - 0.00282186948853613*G0_1_0_2_1 + 0.0169312169312168*G0_1_0_2_2;
    A[166] = -A[46] - 0.0663139329805993*G0_0_0_0_0 - 0.0204585537918871*G0_0_0_0_1 - 0.0331569664902996*G0_0_0_0_2 - 0.0204585537918871*G0_0_0_1_0 - 0.244091710758377*G0_0_0_1_1 - 0.0204585537918871*G0_0_0_1_2 - 0.0331569664902996*G0_0_0_2_0 - 0.0204585537918871*G0_0_0_2_1 - 0.0663139329805993*G0_0_0_2_2;
    A[206] = -A[198] - 0.334109347442679*G0_0_0_0_0 - 0.0790123456790121*G0_0_0_0_1 - 0.241552028218694*G0_0_0_0_2 - 0.0790123456790121*G0_0_0_1_0 - 0.361199294532627*G0_0_0_1_1 - 0.259611992945325*G0_0_0_1_2 - 0.241552028218694*G0_0_0_2_0 - 0.259611992945325*G0_0_0_2_1 - 0.446984126984125*G0_0_0_2_2 + 0.112874779541446*G0_1_0_0_0 + 0.180599647266313*G0_1_0_0_1 + 0.180599647266313*G0_1_0_1_0 - 0.180599647266313*G0_1_0_1_2 - 0.180599647266313*G0_1_0_2_1 - 0.112874779541446*G0_1_0_2_2;
    A[178] = A[206] + 0.081269841269841*G0_0_1_0_0 + 0.12416225749559*G0_0_1_0_1 - 0.00225749559082905*G0_0_1_0_2 + 0.12416225749559*G0_0_1_1_0 - 0.180599647266313*G0_0_1_1_1 - 0.0564373897707231*G0_0_1_1_2 - 0.00225749559082906*G0_0_1_2_0 - 0.0564373897707231*G0_0_1_2_1 - 0.0316049382716051*G0_0_1_2_2 - 0.081269841269841*G0_1_0_0_0 - 0.12416225749559*G0_1_0_0_1 + 0.00225749559082906*G0_1_0_0_2 - 0.12416225749559*G0_1_0_1_0 + 0.180599647266313*G0_1_0_1_1 + 0.0564373897707231*G0_1_0_1_2 + 0.00225749559082906*G0_1_0_2_0 + 0.0564373897707231*G0_1_0_2_1 + 0.0316049382716051*G0_1_0_2_2;
    A[0] = A[16] + 0.248324514991181*G0_0_0_0_0 + 0.0109347442680776*G0_0_0_0_2 - 0.24832451499118*G0_0_0_1_1 - 0.0109347442680775*G0_0_0_1_2 + 0.0109347442680776*G0_0_0_2_0 - 0.0109347442680775*G0_0_0_2_1 + 0.261816578483244*G0_0_1_0_0 + 0.0176807760141093*G0_0_1_0_1 + 0.0176807760141093*G0_0_1_0_2 + 0.0176807760141093*G0_0_1_1_0 + 0.0134920634920634*G0_0_1_1_1 + 0.0067460317460317*G0_0_1_1_2 + 0.0176807760141093*G0_0_1_2_0 + 0.0067460317460317*G0_0_1_2_1 + 0.0134920634920634*G0_0_1_2_2 + 0.261816578483244*G0_1_0_0_0 + 0.0176807760141093*G0_1_0_0_1 + 0.0176807760141093*G0_1_0_0_2 + 0.0176807760141093*G0_1_0_1_0 + 0.0134920634920634*G0_1_0_1_1 + 0.0067460317460317*G0_1_0_1_2 + 0.0176807760141093*G0_1_0_2_0 + 0.0067460317460317*G0_1_0_2_1 + 0.0134920634920634*G0_1_0_2_2 + 0.261816578483244*G0_1_1_0_0 + 0.0176807760141093*G0_1_1_0_1 + 0.0176807760141093*G0_1_1_0_2 + 0.0176807760141093*G0_1_1_1_0 + 0.0134920634920634*G0_1_1_1_1 + 0.0067460317460317*G0_1_1_1_2 + 0.0176807760141093*G0_1_1_2_0 + 0.0067460317460317*G0_1_1_2_1 + 0.0134920634920634*G0_1_1_2_2;
    A[58] = -A[178] - 0.334109347442679*G0_0_0_0_0 - 0.0790123456790121*G0_0_0_0_1 - 0.241552028218694*G0_0_0_0_2 - 0.0790123456790121*G0_0_0_1_0 - 0.361199294532627*G0_0_0_1_1 - 0.259611992945325*G0_0_0_1_2 - 0.241552028218694*G0_0_0_2_0 - 0.259611992945325*G0_0_0_2_1 - 0.446984126984125*G0_0_0_2_2 + 0.112874779541446*G0_0_1_0_0 + 0.180599647266313*G0_0_1_0_1 + 0.180599647266313*G0_0_1_1_0 - 0.180599647266313*G0_0_1_1_2 - 0.180599647266313*G0_0_1_2_1 - 0.112874779541446*G0_0_1_2_2;
    A[28] = 0.0581305114638445*G0_0_0_0_0 - 0.00564373897707229*G0_0_0_0_1 + 0.0392239858906524*G0_0_0_0_2 - 0.00564373897707229*G0_0_0_1_0 - 0.239858906525572*G0_0_0_1_1 - 0.0155202821869487*G0_0_0_1_2 + 0.0392239858906524*G0_0_0_2_0 - 0.0155202821869487*G0_0_0_2_1 + 0.0609523809523807*G0_0_0_2_2 - 0.00282186948853619*G0_0_1_0_0 + 0.00987654320987643*G0_0_1_0_1 + 0.00987654320987643*G0_0_1_1_0 - 0.00987654320987648*G0_0_1_1_2 - 0.00987654320987648*G0_0_1_2_1 + 0.00282186948853625*G0_0_1_2_2;
    A[131] = -A[86] + 0.0270899470899473*G0_1_0_0_0 + 0.024832451499118*G0_1_0_0_1 + 0.00451499118165785*G0_1_0_0_2 + 0.024832451499118*G0_1_0_1_0 - 0.0767548500881843*G0_1_0_1_1 - 0.0045149911816579*G0_1_0_1_2 + 0.00451499118165785*G0_1_0_2_0 - 0.0045149911816579*G0_1_0_2_1 - 0.0135449735449736*G0_1_1_0_0 - 0.0383774250440917*G0_1_1_0_1 - 0.00451499118165783*G0_1_1_0_2 - 0.0383774250440917*G0_1_1_1_0 - 0.270899470899471*G0_1_1_1_1 + 0.0158024691358024*G0_1_1_1_2 - 0.00451499118165783*G0_1_1_2_0 + 0.0158024691358024*G0_1_1_2_1;
    A[84] = -A[131] + 0.00451499118165787*G0_0_0_0_0 - 0.00451499118165775*G0_0_0_0_1 - 0.00451499118165775*G0_0_0_1_0 + 0.00451499118165771*G0_0_0_1_1 - 0.0225749559082889*G0_0_1_0_0 - 0.00225749559082892*G0_0_1_0_1 + 0.00225749559082894*G0_0_1_0_2 - 0.00225749559082892*G0_0_1_1_0 + 0.0270899470899465*G0_0_1_1_1 - 0.00225749559082897*G0_0_1_1_2 + 0.00225749559082894*G0_0_1_2_0 - 0.00225749559082897*G0_0_1_2_1 - 0.00225749559082884*G0_1_0_0_1 + 0.0135449735449736*G0_1_0_0_2 - 0.00225749559082883*G0_1_0_1_0 + 0.00451499118165731*G0_1_0_1_1 - 0.0135449735449734*G0_1_0_1_2 + 0.0135449735449736*G0_1_0_2_0 - 0.0135449735449734*G0_1_0_2_1 - 0.0541798941798937*G0_1_1_0_0 - 0.024832451499118*G0_1_1_0_1 - 0.024832451499118*G0_1_1_1_0 - 0.0270899470899477*G0_1_1_1_1 - 0.0158024691358024*G0_1_1_1_2 - 0.0158024691358024*G0_1_1_2_1 - 0.0406349206349205*G0_1_1_2_2;
    A[129] = -A[84] + 0.0767548500881833*G0_1_0_0_0 - 0.0248324514991179*G0_1_0_0_1 + 0.00451499118165789*G0_1_0_0_2 - 0.0248324514991179*G0_1_0_1_0 - 0.027089947089947*G0_1_0_1_1 - 0.00451499118165766*G0_1_0_1_2 + 0.00451499118165789*G0_1_0_2_0 - 0.00451499118165766*G0_1_0_2_1 - 0.194144620811286*G0_1_1_0_0 - 0.0632098765432094*G0_1_1_0_1 + 0.0203174603174603*G0_1_1_0_2 - 0.0632098765432094*G0_1_1_1_0 - 0.0406349206349204*G0_1_1_1_1 - 0.0090299823633156*G0_1_1_1_2 + 0.0203174603174603*G0_1_1_2_0 - 0.0090299823633156*G0_1_1_2_1;
    A[143] = A[129] + 0.0677248677248678*G0_0_1_0_0 - 0.0203174603174601*G0_0_1_0_1 - 0.00225749559082886*G0_0_1_0_2 - 0.0203174603174601*G0_0_1_1_0 - 0.0135449735449734*G0_0_1_1_1 - 0.00225749559082886*G0_0_1_2_0 - 0.0090299823633157*G0_0_1_2_2 - 0.0677248677248678*G0_1_0_0_0 + 0.0203174603174601*G0_1_0_0_1 + 0.00225749559082886*G0_1_0_0_2 + 0.0203174603174601*G0_1_0_1_0 + 0.0135449735449734*G0_1_0_1_1 + 0.00225749559082886*G0_1_0_2_0 + 0.0090299823633157*G0_1_0_2_2;
    A[74] = A[214] + 0.047407407407407*G0_0_1_0_0 + 0.0372486772486767*G0_0_1_0_1 + 0.0507936507936506*G0_0_1_0_2 + 0.0372486772486767*G0_0_1_1_0 + 0.0812698412698409*G0_0_1_1_1 - 0.0677248677248673*G0_0_1_1_2 + 0.0507936507936506*G0_0_1_2_0 - 0.0677248677248673*G0_0_1_2_1 - 0.169312169312169*G0_0_1_2_2 - 0.047407407407407*G0_1_0_0_0 - 0.0372486772486767*G0_1_0_0_1 - 0.0507936507936506*G0_1_0_0_2 - 0.0372486772486767*G0_1_0_1_0 - 0.0812698412698409*G0_1_0_1_1 + 0.0677248677248673*G0_1_0_1_2 - 0.0507936507936506*G0_1_0_2_0 + 0.0677248677248673*G0_1_0_2_1 + 0.169312169312169*G0_1_0_2_2;
    A[199] = A[74] + 0.142222222222222*G0_0_0_0_0 + 0.0643386243386242*G0_0_0_0_1 + 0.335238095238094*G0_0_0_0_2 + 0.0643386243386242*G0_0_0_1_0 + 0.27089947089947*G0_0_0_1_1 + 0.342010582010581*G0_0_0_1_2 + 0.335238095238094*G0_0_0_2_0 + 0.342010582010581*G0_0_0_2_1 + 1.35449735449735*G0_0_0_2_2 - 0.013544973544973*G0_0_1_0_1 + 0.0135449735449739*G0_0_1_0_2 - 0.013544973544973*G0_0_1_1_0 - 0.240423280423279*G0_0_1_1_1 + 0.0135449735449739*G0_0_1_2_0 + 0.240423280423281*G0_0_1_2_2 - 0.0270899470899466*G0_1_0_0_1 + 0.0270899470899474*G0_1_0_0_2 - 0.0270899470899466*G0_1_0_1_0 + 0.0101587301587318*G0_1_0_1_1 + 0.0270899470899474*G0_1_0_2_0 - 0.0101587301587281*G0_1_0_2_2 - 0.142222222222221*G0_1_1_0_0 - 0.335238095238093*G0_1_1_0_1 - 0.0643386243386239*G0_1_1_0_2 - 0.335238095238093*G0_1_1_1_0 - 1.35449735449735*G0_1_1_1_1 - 0.34201058201058*G0_1_1_1_2 - 0.0643386243386239*G0_1_1_2_0 - 0.34201058201058*G0_1_1_2_1 - 0.270899470899469*G0_1_1_2_2;
    A[117] = A[199] - 0.0744973544973546*G0_0_0_0_0 - 0.162539682539682*G0_0_0_0_2 + 0.0744973544973539*G0_0_0_1_1 + 0.162539682539682*G0_0_0_1_2 - 0.162539682539682*G0_0_0_2_0 + 0.162539682539682*G0_0_0_2_1 + 0.220105820105819*G0_0_1_0_0 + 0.0948148148148144*G0_0_1_0_1 + 0.159153439153438*G0_0_1_0_2 + 0.0948148148148144*G0_0_1_1_0 + 0.511322751322749*G0_0_1_1_1 + 0.426666666666665*G0_0_1_1_2 + 0.159153439153438*G0_0_1_2_0 + 0.426666666666665*G0_0_1_2_1 + 0.650158730158727*G0_0_1_2_2 + 0.436825396825395*G0_1_0_0_0 + 0.0948148148148143*G0_1_0_0_1 + 0.264126984126983*G0_1_0_0_2 + 0.0948148148148143*G0_1_0_1_0 + 0.294603174603172*G0_1_0_1_1 + 0.32169312169312*G0_1_0_1_2 + 0.264126984126983*G0_1_0_2_0 + 0.32169312169312*G0_1_0_2_1 + 0.650158730158726*G0_1_0_2_2 - 0.406349206349204*G0_1_1_0_0 + 0.0948148148148145*G0_1_1_0_1 + 0.0914285714285713*G0_1_1_0_2 + 0.0948148148148146*G0_1_1_1_0 + 1.13777777777777*G0_1_1_1_1 + 0.494391534391532*G0_1_1_1_2 + 0.0914285714285713*G0_1_1_2_0 + 0.494391534391532*G0_1_1_2_1 + 0.650158730158727*G0_1_1_2_2;
    A[202] = A[199] + 0.054179894179894*G0_0_0_0_0 - 0.0203174603174604*G0_0_0_0_1 - 0.0203174603174604*G0_0_0_1_0 - 0.0135449735449745*G0_0_0_1_1 - 0.101587301587301*G0_0_1_0_0 + 0.0270899470899469*G0_0_1_0_1 - 0.0101587301587302*G0_0_1_0_2 + 0.0270899470899469*G0_0_1_1_0 + 0.419894179894177*G0_0_1_1_1 + 0.247195767195766*G0_0_1_1_2 - 0.0101587301587301*G0_0_1_2_0 + 0.247195767195766*G0_0_1_2_1 + 0.270899470899469*G0_0_1_2_2 + 0.0270899470899469*G0_1_0_0_0 + 0.0812698412698404*G0_1_0_0_1 + 0.0270899470899469*G0_1_0_0_2 + 0.0812698412698404*G0_1_0_1_0 + 0.250582010582007*G0_1_0_1_1 + 0.176084656084655*G0_1_0_1_2 + 0.0270899470899469*G0_1_0_2_0 + 0.176084656084655*G0_1_0_2_1 + 0.270899470899468*G0_1_0_2_2 + 0.0880423280423269*G0_1_1_0_0 + 0.206560846560845*G0_1_1_0_1 + 0.027089947089947*G0_1_1_0_2 + 0.206560846560845*G0_1_1_1_0 + 1.14455026455026*G0_1_1_1_1 + 0.375873015873014*G0_1_1_1_2 + 0.027089947089947*G0_1_1_2_0 + 0.375873015873014*G0_1_1_2_1 + 0.291216931216929*G0_1_1_2_2;
    A[163] = A[199] + 0.304761904761903*G0_0_0_0_0 + 0.0270899470899468*G0_0_0_0_1 - 0.0101587301587305*G0_0_0_0_2 + 0.0270899470899467*G0_0_0_1_0 - 0.474074074074072*G0_0_0_1_1 - 0.0778835978835977*G0_0_0_1_2 - 0.0101587301587304*G0_0_0_2_0 - 0.0778835978835977*G0_0_0_2_1 - 0.216719576719577*G0_0_0_2_2 - 0.0406349206349213*G0_0_1_0_0 - 0.169312169312169*G0_0_1_0_1 - 0.0101587301587303*G0_0_1_0_2 - 0.169312169312169*G0_0_1_1_0 - 0.474074074074072*G0_0_1_1_1 + 0.118518518518518*G0_0_1_1_2 - 0.0101587301587303*G0_0_1_2_0 + 0.118518518518518*G0_0_1_2_1 + 0.128677248677248*G0_0_1_2_2 - 0.0744973544973546*G0_1_0_0_0 - 0.0507936507936509*G0_1_0_0_1 - 0.0101587301587305*G0_1_0_0_2 - 0.0507936507936509*G0_1_0_1_0 - 0.474074074074072*G0_1_0_1_1 - 0.0101587301587305*G0_1_0_2_0 + 0.162539682539681*G0_1_0_2_2 - 0.203174603174602*G0_1_1_0_0 - 0.169312169312169*G0_1_1_0_1 - 0.169312169312169*G0_1_1_1_0 + 0.169312169312169*G0_1_1_1_2 + 0.169312169312169*G0_1_1_2_1 + 0.203174603174602*G0_1_1_2_2;
    A[205] = A[163] - 0.0812698412698406*G0_0_1_0_0 + 0.0677248677248675*G0_0_1_0_1 - 0.0372486772486773*G0_0_1_0_2 + 0.0677248677248675*G0_0_1_1_0 + 0.169312169312169*G0_0_1_1_1 - 0.0507936507936505*G0_0_1_1_2 - 0.0372486772486773*G0_0_1_2_0 - 0.0507936507936506*G0_0_1_2_1 - 0.0474074074074074*G0_0_1_2_2 + 0.0812698412698406*G0_1_0_0_0 - 0.0677248677248676*G0_1_0_0_1 + 0.0372486772486773*G0_1_0_0_2 - 0.0677248677248676*G0_1_0_1_0 - 0.169312169312169*G0_1_0_1_1 + 0.0507936507936505*G0_1_0_1_2 + 0.0372486772486773*G0_1_0_2_0 + 0.0507936507936506*G0_1_0_2_1 + 0.0474074074074074*G0_1_0_2_2;
    A[164] = A[202] - 0.108359788359788*G0_0_0_0_0 - 0.0169312169312168*G0_0_0_0_1 - 0.128677248677248*G0_0_0_0_2 - 0.0169312169312168*G0_0_0_1_0 + 0.0338624338624344*G0_0_0_1_1 + 0.0338624338624342*G0_0_0_1_2 - 0.128677248677248*G0_0_0_2_0 + 0.0338624338624342*G0_0_0_2_1 - 0.209947089947088*G0_0_0_2_2 - 0.0237037037037035*G0_0_1_0_1 + 0.0237037037037035*G0_0_1_0_2 - 0.0237037037037034*G0_0_1_1_0 + 0.0914285714285713*G0_0_1_1_1 + 0.0237037037037035*G0_0_1_2_0 - 0.0914285714285701*G0_0_1_2_2 - 0.0270899470899466*G0_1_0_0_1 + 0.0270899470899472*G0_1_0_0_2 - 0.0270899470899466*G0_1_0_1_0 + 0.0101587301587314*G0_1_0_1_1 + 0.0270899470899472*G0_1_0_2_0 - 0.0101587301587287*G0_1_0_2_2 + 0.108359788359789*G0_1_1_0_0 + 0.128677248677248*G0_1_1_0_1 + 0.0169312169312168*G0_1_1_0_2 + 0.128677248677248*G0_1_1_1_0 + 0.209947089947089*G0_1_1_1_1 - 0.0338624338624336*G0_1_1_1_2 + 0.0169312169312168*G0_1_1_2_0 - 0.0338624338624336*G0_1_1_2_1 - 0.0338624338624332*G0_1_1_2_2;
    A[72] = A[117] - 0.0135449735449732*G0_0_0_0_0 - 0.0203174603174603*G0_0_0_0_1 - 0.0203174603174603*G0_0_0_1_0 + 0.0541798941798933*G0_0_0_1_1 - 0.264126984126982*G0_0_1_0_0 - 0.101587301587301*G0_0_1_0_1 - 0.176084656084655*G0_0_1_0_2 - 0.101587301587301*G0_0_1_1_0 + 0.0270899470899464*G0_0_1_1_1 - 0.0270899470899473*G0_0_1_1_2 - 0.176084656084655*G0_0_1_2_0 - 0.0270899470899473*G0_0_1_2_1 - 0.27089947089947*G0_0_1_2_2 - 0.433439153439153*G0_1_0_0_0 - 0.0474074074074075*G0_1_0_0_1 - 0.247195767195766*G0_1_0_0_2 - 0.0474074074074075*G0_1_0_1_0 + 0.155767195767194*G0_1_0_1_1 + 0.0101587301587297*G0_1_0_1_2 - 0.247195767195766*G0_1_0_2_0 + 0.0101587301587297*G0_1_0_2_1 - 0.27089947089947*G0_1_0_2_2 + 0.460529100529098*G0_1_1_0_0 + 0.0778835978835974*G0_1_1_0_1 - 0.0474074074074074*G0_1_1_0_2 + 0.0778835978835974*G0_1_1_1_0 + 0.216719576719575*G0_1_1_1_1 + 0.0101587301587299*G0_1_1_1_2 - 0.0474074074074074*G0_1_1_2_0 + 0.0101587301587299*G0_1_1_2_1 - 0.25058201058201*G0_1_1_2_2;
    A[187] = A[117] + 0.169312169312169*G0_0_1_0_0 - 0.0507936507936505*G0_0_1_0_1 + 0.0677248677248674*G0_0_1_0_2 - 0.0507936507936505*G0_0_1_1_0 - 0.0474074074074073*G0_0_1_1_1 - 0.0372486772486772*G0_0_1_1_2 + 0.0677248677248674*G0_0_1_2_0 - 0.0372486772486771*G0_0_1_2_1 - 0.0812698412698413*G0_0_1_2_2 - 0.169312169312169*G0_1_0_0_0 + 0.0507936507936505*G0_1_0_0_1 - 0.0677248677248674*G0_1_0_0_2 + 0.0507936507936505*G0_1_0_1_0 + 0.0474074074074073*G0_1_0_1_1 + 0.0372486772486772*G0_1_0_1_2 - 0.0677248677248674*G0_1_0_2_0 + 0.0372486772486772*G0_1_0_2_1 + 0.0812698412698413*G0_1_0_2_2;
    A[160] = A[164] + 0.890582010582007*G0_0_0_0_0 + 0.308994708994708*G0_0_0_0_1 + 0.146455026455026*G0_0_0_0_2 + 0.308994708994708*G0_0_0_1_0 + 0.890582010582007*G0_0_0_1_1 + 0.146455026455026*G0_0_0_1_2 + 0.146455026455026*G0_0_0_2_0 + 0.146455026455026*G0_0_0_2_1 + 0.0753439153439145*G0_0_0_2_2 + 0.104550264550264*G0_0_1_0_0 + 0.154497354497354*G0_0_1_0_1 + 0.00338624338624331*G0_0_1_0_2 + 0.154497354497354*G0_0_1_1_0 + 0.786031746031742*G0_0_1_1_1 + 0.143068783068782*G0_0_1_1_2 + 0.0033862433862433*G0_0_1_2_0 + 0.143068783068782*G0_0_1_2_1 + 0.037671957671957*G0_0_1_2_2 + 0.0232804232804231*G0_1_0_0_0 + 0.154497354497354*G0_1_0_0_1 + 0.154497354497354*G0_1_0_1_0 + 0.867301587301583*G0_1_0_1_1 + 0.146455026455026*G0_1_0_1_2 + 0.146455026455026*G0_1_0_2_1 + 0.0376719576719568*G0_1_0_2_2 + 0.143068783068782*G0_1_1_0_0 + 0.204444444444444*G0_1_1_0_1 + 0.0546031746031744*G0_1_1_0_2 + 0.204444444444444*G0_1_1_1_0 + 0.905820105820101*G0_1_1_1_1 + 0.197671957671957*G0_1_1_1_2 + 0.0546031746031744*G0_1_1_2_0 + 0.197671957671957*G0_1_1_2_1 + 0.0821164021164017*G0_1_1_2_2;
    A[184] = A[72] + 0.00338624338624296*G0_0_1_0_1 - 0.00338624338624371*G0_0_1_0_2 + 0.00338624338624296*G0_0_1_1_0 + 0.0812698412698405*G0_0_1_1_1 - 0.00338624338624371*G0_0_1_2_0 - 0.0812698412698413*G0_0_1_2_2 - 0.00338624338624296*G0_1_0_0_1 + 0.00338624338624371*G0_1_0_0_2 - 0.00338624338624296*G0_1_0_1_0 - 0.0812698412698404*G0_1_0_1_1 + 0.0033862433862437*G0_1_0_2_0 + 0.0812698412698413*G0_1_0_2_2;
    A[73] = A[199] - 0.0474074074074072*G0_0_1_0_0 - 0.0507936507936503*G0_0_1_0_1 - 0.0372486772486771*G0_0_1_0_2 - 0.0507936507936503*G0_0_1_1_0 + 0.16931216931217*G0_0_1_1_1 + 0.0677248677248675*G0_0_1_1_2 - 0.0372486772486771*G0_0_1_2_0 + 0.0677248677248675*G0_0_1_2_1 - 0.0812698412698402*G0_0_1_2_2 + 0.0474074074074072*G0_1_0_0_0 + 0.0507936507936503*G0_1_0_0_1 + 0.0372486772486771*G0_1_0_0_2 + 0.0507936507936503*G0_1_0_1_0 - 0.16931216931217*G0_1_0_1_1 - 0.0677248677248675*G0_1_0_1_2 + 0.0372486772486771*G0_1_0_2_0 - 0.0677248677248675*G0_1_0_2_1 + 0.0812698412698402*G0_1_0_2_2;
    A[119] = A[205] - 0.650158730158727*G0_0_0_0_0 - 0.091428571428571*G0_0_0_0_1 - 0.494391534391533*G0_0_0_0_2 - 0.091428571428571*G0_0_0_1_0 + 0.406349206349204*G0_0_0_1_1 - 0.0948148148148149*G0_0_0_1_2 - 0.494391534391533*G0_0_0_2_0 - 0.094814814814815*G0_0_0_2_1 - 1.13777777777778*G0_0_0_2_2 + 0.0677248677248674*G0_0_1_0_1 - 0.0677248677248672*G0_0_1_0_2 + 0.0677248677248674*G0_0_1_1_0 + 0.626455026455023*G0_0_1_1_1 - 0.0677248677248672*G0_0_1_2_0 - 0.626455026455023*G0_0_1_2_2 + 0.172698412698412*G0_1_0_0_1 - 0.172698412698412*G0_1_0_0_2 + 0.172698412698412*G0_1_0_1_0 + 0.843174603174599*G0_1_0_1_1 - 0.172698412698412*G0_1_0_2_0 - 0.843174603174601*G0_1_0_2_2 + 0.650158730158728*G0_1_1_0_0 + 0.494391534391532*G0_1_1_0_1 + 0.091428571428571*G0_1_1_0_2 + 0.494391534391532*G0_1_1_1_0 + 1.13777777777777*G0_1_1_1_1 + 0.0948148148148142*G0_1_1_1_2 + 0.091428571428571*G0_1_1_2_0 + 0.0948148148148142*G0_1_1_2_1 - 0.406349206349204*G0_1_1_2_2;
    A[110] = -A[119] - 0.296860670194003*G0_0_0_0_0 - 0.0445855379188712*G0_0_0_0_1 - 0.409171075837742*G0_0_0_0_2 - 0.0445855379188712*G0_0_0_1_0 - 0.071111111111111*G0_0_0_1_1 - 0.149559082892416*G0_0_0_1_2 - 0.409171075837742*G0_0_0_2_0 - 0.149559082892416*G0_0_0_2_1 - 0.50793650793651*G0_0_0_2_2 - 0.123597883597883*G0_0_1_0_0 - 0.049100529100529*G0_0_1_0_1 - 0.1405291005291*G0_0_1_0_2 - 0.049100529100529*G0_0_1_1_0 - 0.066031746031746*G0_0_1_1_1 - 0.121904761904761*G0_0_1_1_2 - 0.1405291005291*G0_0_1_2_0 - 0.121904761904761*G0_0_1_2_1 - 0.397883597883597*G0_0_1_2_2 - 0.0547442680776005*G0_1_0_0_0 - 0.0135449735449734*G0_1_0_0_1 - 0.225185185185185*G0_1_0_0_2 - 0.0135449735449734*G0_1_0_1_0 - 0.0423280423280421*G0_1_0_1_1 - 0.104973544973545*G0_1_0_1_2 - 0.225185185185185*G0_1_0_2_0 - 0.104973544973545*G0_1_0_2_1 - 0.426102292768961*G0_1_0_2_2 + 0.274285714285714*G0_1_1_0_0 + 0.0728042328042325*G0_1_1_0_1 + 0.0728042328042325*G0_1_1_1_0 - 0.0728042328042326*G0_1_1_1_2 - 0.0728042328042326*G0_1_1_2_1 - 0.274285714285714*G0_1_1_2_2;
    A[65] = -A[110] - 0.0225749559082892*G0_0_0_0_0 - 0.0902998236331566*G0_0_0_0_2 + 0.0225749559082893*G0_0_0_1_1 + 0.0902998236331567*G0_0_0_1_2 - 0.0902998236331566*G0_0_0_2_0 + 0.0902998236331567*G0_0_0_2_1 - 0.0135449735449735*G0_0_1_0_0 + 0.0135449735449736*G0_0_1_0_1 + 0.0135449735449736*G0_0_1_1_0 + 0.121904761904761*G0_0_1_1_1 + 0.27089947089947*G0_0_1_1_2 + 0.27089947089947*G0_0_1_2_1 + 0.609523809523806*G0_0_1_2_2 - 0.0327336860670192*G0_1_0_0_0 - 0.00959435626102277*G0_1_0_0_1 - 0.0620811287477953*G0_1_0_0_2 - 0.00959435626102277*G0_1_0_1_0 - 0.0101587301587296*G0_1_0_1_1 + 0.0282186948853615*G0_1_0_1_2 - 0.0620811287477953*G0_1_0_2_0 + 0.0282186948853615*G0_1_0_2_1 + 0.299118165784831*G0_1_0_2_2 - 0.115132275132274*G0_1_1_0_0 - 0.101587301587301*G0_1_1_0_1 - 0.0626455026455024*G0_1_1_0_2 - 0.101587301587301*G0_1_1_1_0 - 0.358941798941798*G0_1_1_1_1 + 0.037248677248677*G0_1_1_1_2 - 0.0626455026455024*G0_1_1_2_0 + 0.037248677248677*G0_1_1_2_1 + 0.169312169312168*G0_1_1_2_2;
    A[113] = -A[110] - 0.0959435626102291*G0_0_1_0_0 - 0.0197530864197532*G0_0_1_0_1 - 0.191887125220458*G0_0_1_0_2 - 0.0197530864197532*G0_0_1_1_0 + 0.0169312169312162*G0_0_1_1_1 - 0.0112874779541449*G0_0_1_1_2 - 0.191887125220458*G0_0_1_2_0 - 0.0112874779541449*G0_0_1_2_1 - 0.592592592592591*G0_0_1_2_2 - 0.515837742504406*G0_1_1_0_0 - 0.113439153439153*G0_1_1_0_1 - 0.203174603174603*G0_1_1_0_2 - 0.113439153439153*G0_1_1_1_0 - 0.0304761904761907*G0_1_1_1_1 - 0.0423280423280424*G0_1_1_1_2 - 0.203174603174603*G0_1_1_2_0 - 0.0423280423280424*G0_1_1_2_1 - 0.581305114638446*G0_1_1_2_2;
    A[97] = A[113] - 0.0564373897707228*G0_0_0_0_0 - 0.0158024691358024*G0_0_0_0_1 - 0.0349911816578484*G0_0_0_0_2 - 0.0158024691358024*G0_0_0_1_0 - 0.0135449735449736*G0_0_0_1_1 + 0.00112874779541433*G0_0_0_1_2 - 0.0349911816578484*G0_0_0_2_0 + 0.00112874779541433*G0_0_0_2_1 + 0.270899470899468*G0_0_0_2_2 - 0.249453262786596*G0_0_1_0_0 - 0.0259611992945326*G0_0_1_0_1 - 0.0349911816578479*G0_0_1_0_2 - 0.0259611992945326*G0_0_1_1_0 - 0.0135449735449735*G0_0_1_1_1 + 0.0112874779541446*G0_0_1_1_2 - 0.0349911816578478*G0_0_1_2_0 + 0.0112874779541446*G0_0_1_2_1 + 0.463915343915342*G0_0_1_2_2 + 0.0936860670194005*G0_1_0_0_0 - 0.00225749559082887*G0_1_0_0_1 - 0.0349911816578483*G0_1_0_0_2 - 0.00225749559082887*G0_1_0_1_0 - 0.0135449735449735*G0_1_0_1_1 - 0.0124162257495591*G0_1_0_1_2 - 0.0349911816578484*G0_1_0_2_0 - 0.0124162257495591*G0_1_0_2_1 + 0.120776014109345*G0_1_0_2_2 - 0.370229276895941*G0_1_1_0_0 - 0.0135449735449735*G0_1_1_0_1 - 0.0135449735449735*G0_1_1_1_0 + 0.0135449735449735*G0_1_1_1_2 + 0.0135449735449735*G0_1_1_2_1 + 0.370229276895942*G0_1_1_2_2;
    A[111] = A[97] + 0.451499118165784*G0_0_1_0_0 + 0.0451499118165785*G0_0_1_0_1 + 0.208818342151675*G0_0_1_0_2 + 0.0451499118165785*G0_0_1_1_0 + 0.00677248677248677*G0_0_1_1_1 + 0.0214462081128747*G0_0_1_1_2 + 0.208818342151675*G0_0_1_2_0 + 0.0214462081128747*G0_0_1_2_1 + 0.108359788359787*G0_0_1_2_2 - 0.451499118165784*G0_1_0_0_0 - 0.0451499118165785*G0_1_0_0_1 - 0.208818342151675*G0_1_0_0_2 - 0.0451499118165785*G0_1_0_1_0 - 0.00677248677248677*G0_1_0_1_1 - 0.0214462081128747*G0_1_0_1_2 - 0.208818342151675*G0_1_0_2_0 - 0.0214462081128747*G0_1_0_2_1 - 0.108359788359787*G0_1_0_2_2;
    A[159] = A[97] - 0.750617283950615*G0_0_0_0_0 - 0.1405291005291*G0_0_0_0_1 - 0.0795767195767191*G0_0_0_0_2 - 0.1405291005291*G0_0_0_1_0 - 0.400705467372132*G0_0_0_1_1 - 0.0118518518518517*G0_0_0_1_2 - 0.0795767195767191*G0_0_0_2_0 - 0.0118518518518517*G0_0_0_2_1 + 0.328465608465606*G0_0_0_2_2 - 0.157460317460316*G0_0_1_0_1 + 0.157460317460317*G0_0_1_0_2 - 0.157460317460316*G0_0_1_1_0 - 0.426666666666664*G0_0_1_1_1 + 0.157460317460317*G0_0_1_2_0 + 0.426666666666664*G0_0_1_2_2 + 0.00620811287477939*G0_1_0_0_1 - 0.00620811287477945*G0_1_0_0_2 + 0.00620811287477939*G0_1_0_1_0 - 0.325079365079364*G0_1_0_1_1 - 0.00620811287477944*G0_1_0_2_0 + 0.325079365079364*G0_1_0_2_2 + 0.750617283950613*G0_1_1_0_0 + 0.0795767195767192*G0_1_1_0_1 + 0.1405291005291*G0_1_1_0_2 + 0.0795767195767192*G0_1_1_1_0 - 0.328465608465606*G0_1_1_1_1 + 0.0118518518518518*G0_1_1_1_2 + 0.1405291005291*G0_1_1_2_0 + 0.0118518518518518*G0_1_1_2_1 + 0.400705467372132*G0_1_1_2_2;
    A[79] = A[65] - 0.00677248677248681*G0_0_1_0_0 - 0.0214462081128748*G0_0_1_0_1 - 0.0451499118165784*G0_0_1_0_2 - 0.0214462081128748*G0_0_1_1_0 - 0.108359788359788*G0_0_1_1_1 - 0.208818342151675*G0_0_1_1_2 - 0.0451499118165784*G0_0_1_2_0 - 0.208818342151675*G0_0_1_2_1 - 0.451499118165783*G0_0_1_2_2 + 0.00677248677248681*G0_1_0_0_0 + 0.0214462081128748*G0_1_0_0_1 + 0.0451499118165784*G0_1_0_0_2 + 0.0214462081128748*G0_1_0_1_0 + 0.108359788359788*G0_1_0_1_1 + 0.208818342151675*G0_1_0_1_2 + 0.0451499118165784*G0_1_0_2_0 + 0.208818342151675*G0_1_0_2_1 + 0.451499118165783*G0_1_0_2_2;
    A[82] = A[110] - 0.0124162257495589*G0_0_1_0_0 - 0.00169312169312158*G0_0_1_0_1 - 0.0169312169312168*G0_0_1_0_2 - 0.00169312169312158*G0_0_1_1_0 - 0.0237037037037031*G0_0_1_1_1 - 0.0338624338624336*G0_0_1_1_2 - 0.0169312169312168*G0_0_1_2_0 - 0.0338624338624336*G0_0_1_2_1 + 0.141093474426807*G0_0_1_2_2 + 0.0124162257495589*G0_1_0_0_0 + 0.00169312169312158*G0_1_0_0_1 + 0.0169312169312168*G0_1_0_0_2 + 0.00169312169312157*G0_1_0_1_0 + 0.0237037037037031*G0_1_0_1_1 + 0.0338624338624336*G0_1_0_1_2 + 0.0169312169312168*G0_1_0_2_0 + 0.0338624338624336*G0_1_0_2_1 - 0.141093474426807*G0_1_0_2_2;
    A[153] = A[82] - 0.0790123456790119*G0_0_0_0_0 - 0.0468430335097*G0_0_0_0_1 - 0.0124162257495588*G0_0_0_0_2 - 0.0468430335097*G0_0_0_1_0 + 0.203174603174602*G0_0_0_1_1 - 0.0180599647266313*G0_0_0_1_2 - 0.0124162257495588*G0_0_0_2_0 - 0.0180599647266313*G0_0_0_2_1 - 0.629841269841265*G0_0_0_2_2 - 0.0389417989417987*G0_0_1_0_1 + 0.0389417989417989*G0_0_1_0_2 - 0.0389417989417986*G0_0_1_1_0 + 0.459400352733685*G0_0_1_1_1 + 0.0389417989417989*G0_0_1_2_0 - 0.459400352733682*G0_0_1_2_2 - 0.0237037037037035*G0_1_0_0_1 + 0.0237037037037039*G0_1_0_0_2 - 0.0237037037037035*G0_1_0_1_0 + 0.294603174603173*G0_1_0_1_1 + 0.0237037037037039*G0_1_0_2_0 - 0.294603174603172*G0_1_0_2_2 + 0.0790123456790118*G0_1_1_0_0 + 0.0124162257495592*G0_1_1_0_1 + 0.0468430335097001*G0_1_1_0_2 + 0.0124162257495592*G0_1_1_1_0 + 0.629841269841267*G0_1_1_1_1 + 0.0180599647266315*G0_1_1_1_2 + 0.0468430335097001*G0_1_1_2_0 + 0.0180599647266315*G0_1_1_2_1 - 0.203174603174601*G0_1_1_2_2;
    A[68] = -A[65] - 0.0169312169312164*G0_0_1_0_0 + 0.0197530864197533*G0_0_1_0_1 + 0.0112874779541445*G0_0_1_0_2 + 0.0197530864197533*G0_0_1_1_0 + 0.0959435626102295*G0_0_1_1_1 + 0.191887125220458*G0_0_1_1_2 + 0.0112874779541445*G0_0_1_2_0 + 0.191887125220458*G0_0_1_2_1 + 0.592592592592589*G0_0_1_2_2 - 0.0474074074074067*G0_1_1_0_0 - 0.0936860670193999*G0_1_1_0_1 - 0.0310405643738976*G0_1_1_0_2 - 0.0936860670193999*G0_1_1_1_0 - 0.419894179894179*G0_1_1_1_1 - 0.0112874779541447*G0_1_1_1_2 - 0.0310405643738976*G0_1_1_2_0 - 0.0112874779541447*G0_1_1_2_1 + 0.011287477954144*G0_1_1_2_2;
    A[169] = A[68] - 0.0338624338624336*G0_0_0_0_0 - 0.0152380952380951*G0_0_0_0_1 - 0.0948148148148142*G0_0_0_0_2 - 0.0152380952380951*G0_0_0_1_0 + 0.0677248677248673*G0_0_0_1_1 + 0.0237037037037038*G0_0_0_1_2 - 0.0948148148148142*G0_0_0_2_0 + 0.0237037037037038*G0_0_0_2_1 - 0.690793650793645*G0_0_0_2_2 - 0.0186243386243386*G0_0_1_0_1 + 0.0186243386243387*G0_0_1_0_2 - 0.0186243386243386*G0_0_1_1_0 + 0.30363315696649*G0_0_1_1_1 + 0.0186243386243387*G0_0_1_2_0 - 0.303633156966487*G0_0_1_2_2 + 0.0135449735449735*G0_1_0_0_1 - 0.0135449735449734*G0_1_0_0_2 + 0.0135449735449735*G0_1_0_1_0 + 0.150123456790122*G0_1_0_1_1 - 0.0135449735449734*G0_1_0_2_0 - 0.150123456790122*G0_1_0_2_2 + 0.0338624338624333*G0_1_1_0_0 + 0.0948148148148144*G0_1_1_0_1 + 0.0152380952380953*G0_1_1_0_2 + 0.0948148148148144*G0_1_1_1_0 + 0.690793650793649*G0_1_1_1_1 - 0.0237037037037034*G0_1_1_1_2 + 0.0152380952380953*G0_1_1_2_0 - 0.0237037037037034*G0_1_1_2_1 - 0.0677248677248662*G0_1_1_2_2;
    A[71] = A[169] + 0.0237037037037035*G0_0_1_0_0 + 0.0338624338624335*G0_0_1_0_1 + 0.00169312169312168*G0_0_1_0_2 + 0.0338624338624335*G0_0_1_1_0 - 0.141093474426809*G0_0_1_1_1 + 0.0169312169312167*G0_0_1_1_2 + 0.00169312169312168*G0_0_1_2_0 + 0.0169312169312167*G0_0_1_2_1 + 0.0124162257495588*G0_0_1_2_2 - 0.0237037037037035*G0_1_0_0_0 - 0.0338624338624335*G0_1_0_0_1 - 0.00169312169312168*G0_1_0_0_2 - 0.0338624338624335*G0_1_0_1_0 + 0.141093474426809*G0_1_0_1_1 - 0.0169312169312167*G0_1_0_1_2 - 0.00169312169312168*G0_1_0_2_0 - 0.0169312169312167*G0_1_0_2_1 - 0.0124162257495588*G0_1_0_2_2;
    A[55] = A[153] + 0.0124162257495592*G0_0_1_0_0 + 0.0169312169312167*G0_0_1_0_1 + 0.00169312169312176*G0_0_1_0_2 + 0.0169312169312167*G0_0_1_1_0 - 0.141093474426809*G0_0_1_1_1 + 0.0338624338624335*G0_0_1_1_2 + 0.00169312169312175*G0_0_1_2_0 + 0.0338624338624336*G0_0_1_2_1 + 0.0237037037037037*G0_0_1_2_2 - 0.0124162257495592*G0_1_0_0_0 - 0.0169312169312167*G0_1_0_0_1 - 0.00169312169312176*G0_1_0_0_2 - 0.0169312169312167*G0_1_0_1_0 + 0.141093474426809*G0_1_0_1_1 - 0.0338624338624336*G0_1_0_1_2 - 0.00169312169312175*G0_1_0_2_0 - 0.0338624338624336*G0_1_0_2_1 - 0.0237037037037037*G0_1_0_2_2;
    A[175] = -A[55] - 0.515837742504407*G0_0_0_0_0 - 0.203174603174602*G0_0_0_0_1 - 0.113439153439153*G0_0_0_0_2 - 0.203174603174602*G0_0_0_1_0 - 0.581305114638446*G0_0_0_1_1 - 0.0423280423280422*G0_0_0_1_2 - 0.113439153439153*G0_0_0_2_0 - 0.0423280423280422*G0_0_0_2_1 - 0.0304761904761904*G0_0_0_2_2 - 0.0959435626102289*G0_0_1_0_0 - 0.191887125220458*G0_0_1_0_1 - 0.0197530864197529*G0_0_1_0_2 - 0.191887125220458*G0_0_1_1_0 - 0.592592592592591*G0_0_1_1_1 - 0.0112874779541446*G0_0_1_1_2 - 0.0197530864197529*G0_0_1_2_0 - 0.0112874779541446*G0_0_1_2_1 + 0.0169312169312169*G0_0_1_2_2;
    A[220] = A[164] + 0.0812698412698406*G0_0_1_0_0 + 0.00338624338624364*G0_0_1_0_2 - 0.0812698412698408*G0_0_1_1_1 - 0.00338624338624342*G0_0_1_1_2 + 0.00338624338624363*G0_0_1_2_0 - 0.00338624338624341*G0_0_1_2_1 - 0.0812698412698405*G0_1_0_0_0 - 0.00338624338624363*G0_1_0_0_2 + 0.0812698412698408*G0_1_0_1_1 + 0.00338624338624343*G0_1_0_1_2 - 0.00338624338624362*G0_1_0_2_0 + 0.00338624338624342*G0_1_0_2_1;
    A[127] = A[113] + 0.108359788359788*G0_0_1_0_0 + 0.0214462081128747*G0_0_1_0_1 + 0.208818342151675*G0_0_1_0_2 + 0.0214462081128747*G0_0_1_1_0 + 0.00677248677248684*G0_0_1_1_1 + 0.0451499118165785*G0_0_1_1_2 + 0.208818342151675*G0_0_1_2_0 + 0.0451499118165785*G0_0_1_2_1 + 0.451499118165784*G0_0_1_2_2 - 0.108359788359788*G0_1_0_0_0 - 0.0214462081128747*G0_1_0_0_1 - 0.208818342151675*G0_1_0_0_2 - 0.0214462081128747*G0_1_0_1_0 - 0.00677248677248684*G0_1_0_1_1 - 0.0451499118165785*G0_1_0_1_2 - 0.208818342151675*G0_1_0_2_0 - 0.0451499118165785*G0_1_0_2_1 - 0.451499118165784*G0_1_0_2_2;
    A[118] = A[202] + 0.0812698412698405*G0_0_1_0_0 + 0.00338624338624318*G0_0_1_0_1 + 0.00338624338624318*G0_0_1_1_0 - 0.00338624338624344*G0_0_1_1_2 - 0.00338624338624344*G0_0_1_2_1 - 0.0812698412698413*G0_0_1_2_2 - 0.0812698412698405*G0_1_0_0_0 - 0.00338624338624317*G0_1_0_0_1 - 0.00338624338624317*G0_1_0_1_0 + 0.00338624338624344*G0_1_0_1_2 + 0.00338624338624344*G0_1_0_2_1 + 0.0812698412698413*G0_1_0_2_2;
    A[217] = A[119] + 0.0812698412698417*G0_0_1_0_0 + 0.0372486772486771*G0_0_1_0_1 - 0.0677248677248679*G0_0_1_0_2 + 0.0372486772486771*G0_0_1_1_0 + 0.047407407407407*G0_0_1_1_1 + 0.0507936507936505*G0_0_1_1_2 - 0.0677248677248679*G0_0_1_2_0 + 0.0507936507936505*G0_0_1_2_1 - 0.169312169312171*G0_0_1_2_2 - 0.0812698412698417*G0_1_0_0_0 - 0.0372486772486772*G0_1_0_0_1 + 0.0677248677248679*G0_1_0_0_2 - 0.0372486772486772*G0_1_0_1_0 - 0.047407407407407*G0_1_0_1_1 - 0.0507936507936505*G0_1_0_1_2 + 0.0677248677248679*G0_1_0_2_0 - 0.0507936507936505*G0_1_0_2_1 + 0.169312169312171*G0_1_0_2_2;
    A[49] = -A[169] - 0.0474074074074072*G0_0_0_0_0 - 0.0310405643738976*G0_0_0_0_1 - 0.0936860670193999*G0_0_0_0_2 - 0.0310405643738976*G0_0_0_1_0 + 0.0112874779541441*G0_0_0_1_1 - 0.0112874779541447*G0_0_0_1_2 - 0.0936860670193999*G0_0_0_2_0 - 0.0112874779541447*G0_0_0_2_1 - 0.419894179894177*G0_0_0_2_2 - 0.0169312169312168*G0_0_1_0_0 + 0.0112874779541448*G0_0_1_0_1 + 0.019753086419753*G0_0_1_0_2 + 0.0112874779541448*G0_0_1_1_0 + 0.592592592592592*G0_0_1_1_1 + 0.191887125220458*G0_0_1_1_2 + 0.019753086419753*G0_0_1_2_0 + 0.191887125220458*G0_0_1_2_1 + 0.0959435626102291*G0_0_1_2_2;
    A[124] = -A[79] - 0.0169312169312164*G0_1_0_0_0 + 0.0197530864197533*G0_1_0_0_1 + 0.0112874779541445*G0_1_0_0_2 + 0.0197530864197533*G0_1_0_1_0 + 0.0959435626102295*G0_1_0_1_1 + 0.191887125220458*G0_1_0_1_2 + 0.0112874779541445*G0_1_0_2_0 + 0.191887125220458*G0_1_0_2_1 + 0.592592592592589*G0_1_0_2_2 - 0.0474074074074067*G0_1_1_0_0 - 0.0936860670193999*G0_1_1_0_1 - 0.0310405643738976*G0_1_1_0_2 - 0.0936860670193999*G0_1_1_1_0 - 0.419894179894179*G0_1_1_1_1 - 0.0112874779541447*G0_1_1_1_2 - 0.0310405643738976*G0_1_1_2_0 - 0.0112874779541447*G0_1_1_2_1 + 0.011287477954144*G0_1_1_2_2;
    A[161] = -A[153] - 0.515837742504407*G0_0_0_0_0 - 0.203174603174602*G0_0_0_0_1 - 0.113439153439153*G0_0_0_0_2 - 0.203174603174602*G0_0_0_1_0 - 0.581305114638446*G0_0_0_1_1 - 0.0423280423280422*G0_0_0_1_2 - 0.113439153439153*G0_0_0_2_0 - 0.0423280423280422*G0_0_0_2_1 - 0.0304761904761904*G0_0_0_2_2 - 0.0959435626102289*G0_1_0_0_0 - 0.191887125220458*G0_1_0_0_1 - 0.0197530864197529*G0_1_0_0_2 - 0.191887125220458*G0_1_0_1_0 - 0.592592592592591*G0_1_0_1_1 - 0.0112874779541446*G0_1_0_1_2 - 0.0197530864197529*G0_1_0_2_0 - 0.0112874779541446*G0_1_0_2_1 + 0.0169312169312169*G0_1_0_2_2;
    A[112] = A[160] - 0.639153439153436*G0_0_0_0_0 - 0.237460317460316*G0_0_0_0_1 + 0.186666666666667*G0_0_0_0_2 - 0.237460317460316*G0_0_0_1_0 - 0.842328042328039*G0_0_0_1_1 + 0.0173544973544975*G0_0_0_1_2 + 0.186666666666667*G0_0_0_2_0 + 0.0173544973544975*G0_0_0_2_1 + 1.04042328042328*G0_0_0_2_2 - 0.127407407407407*G0_0_1_0_1 + 0.127407407407407*G0_0_1_0_2 - 0.127407407407407*G0_0_1_1_0 - 0.839788359788356*G0_0_1_1_1 + 0.127407407407407*G0_0_1_2_0 + 0.839788359788356*G0_0_1_2_2 - 0.127407407407407*G0_1_0_0_1 + 0.127407407407407*G0_1_0_0_2 - 0.127407407407407*G0_1_0_1_0 - 0.839788359788356*G0_1_0_1_1 + 0.127407407407407*G0_1_0_2_0 + 0.839788359788356*G0_1_0_2_2 + 0.639153439153435*G0_1_1_0_0 - 0.186666666666666*G0_1_1_0_1 + 0.237460317460317*G0_1_1_0_2 - 0.186666666666666*G0_1_1_1_0 - 1.04042328042328*G0_1_1_1_1 - 0.0173544973544971*G0_1_1_1_2 + 0.237460317460317*G0_1_1_2_0 - 0.0173544973544972*G0_1_1_2_1 + 0.842328042328038*G0_1_1_2_2;
    A[64] = A[160] - 0.842328042328039*G0_0_0_0_0 - 0.237460317460316*G0_0_0_0_1 + 0.0173544973544974*G0_0_0_0_2 - 0.237460317460316*G0_0_0_1_0 - 0.639153439153437*G0_0_0_1_1 + 0.186666666666666*G0_0_0_1_2 + 0.0173544973544974*G0_0_0_2_0 + 0.186666666666666*G0_0_0_2_1 + 1.04042328042327*G0_0_0_2_2 - 0.00253968253968281*G0_0_1_0_0 - 0.11005291005291*G0_0_1_0_1 + 0.0173544973544973*G0_0_1_0_2 - 0.11005291005291*G0_0_1_1_0 - 0.639153439153437*G0_0_1_1_1 + 0.059259259259259*G0_0_1_1_2 + 0.0173544973544973*G0_0_1_2_0 + 0.059259259259259*G0_0_1_2_1 + 0.200634920634919*G0_0_1_2_2 - 0.00253968253968283*G0_1_0_0_0 - 0.11005291005291*G0_1_0_0_1 + 0.0173544973544973*G0_1_0_0_2 - 0.11005291005291*G0_1_0_1_0 - 0.639153439153437*G0_1_0_1_1 + 0.059259259259259*G0_1_0_1_2 + 0.0173544973544973*G0_1_0_2_0 + 0.059259259259259*G0_1_0_2_1 + 0.200634920634919*G0_1_0_2_2 - 0.203174603174602*G0_1_1_0_0 - 0.169312169312169*G0_1_1_0_1 - 0.169312169312169*G0_1_1_1_0 + 0.169312169312169*G0_1_1_1_2 + 0.169312169312169*G0_1_1_2_1 + 0.203174603174602*G0_1_1_2_2;
    A[162] = A[187] - 0.474074074074071*G0_0_0_0_0 + 0.0270899470899471*G0_0_0_0_1 - 0.077883597883597*G0_0_0_0_2 + 0.0270899470899471*G0_0_0_1_0 + 0.304761904761903*G0_0_0_1_1 - 0.0101587301587304*G0_0_0_1_2 - 0.077883597883597*G0_0_0_2_0 - 0.0101587301587304*G0_0_0_2_1 - 0.216719576719576*G0_0_0_2_2 + 0.196402116402115*G0_0_1_0_1 - 0.196402116402116*G0_0_1_0_2 + 0.196402116402115*G0_0_1_1_0 + 0.345396825396823*G0_0_1_1_1 - 0.196402116402116*G0_0_1_2_0 - 0.345396825396824*G0_0_1_2_2 + 0.0778835978835975*G0_1_0_0_1 - 0.0778835978835975*G0_1_0_0_2 + 0.0778835978835975*G0_1_0_1_0 + 0.379259259259257*G0_1_0_1_1 - 0.0778835978835975*G0_1_0_2_0 - 0.379259259259258*G0_1_0_2_2 + 0.474074074074071*G0_1_1_0_0 + 0.0778835978835972*G0_1_1_0_1 - 0.0270899470899474*G0_1_1_0_2 + 0.0778835978835972*G0_1_1_1_0 + 0.216719576719575*G0_1_1_1_1 + 0.0101587301587298*G0_1_1_1_2 - 0.0270899470899473*G0_1_1_2_0 + 0.0101587301587298*G0_1_1_2_1 - 0.304761904761904*G0_1_1_2_2;
    A[190] = A[162] - 0.169312169312167*G0_0_1_0_0 - 0.0677248677248669*G0_0_1_0_1 + 0.0507936507936509*G0_0_1_0_2 - 0.0677248677248669*G0_0_1_1_0 + 0.0812698412698414*G0_0_1_1_1 + 0.0372486772486771*G0_0_1_1_2 + 0.0507936507936509*G0_0_1_2_0 + 0.0372486772486771*G0_0_1_2_1 + 0.0474074074074074*G0_0_1_2_2 + 0.169312169312167*G0_1_0_0_0 + 0.0677248677248669*G0_1_0_0_1 - 0.0507936507936509*G0_1_0_0_2 + 0.0677248677248669*G0_1_0_1_0 - 0.0812698412698414*G0_1_0_1_1 - 0.0372486772486771*G0_1_0_1_2 - 0.0507936507936509*G0_1_0_2_0 - 0.0372486772486771*G0_1_0_2_1 - 0.0474074074074074*G0_1_0_2_2;
    A[40] = -0.00522045855379177*G0_1_0_0_0 + 0.000105820105820104*G0_1_0_0_2 + 0.00522045855379184*G0_1_0_1_1 - 0.000105820105820103*G0_1_0_1_2 + 0.000105820105820105*G0_1_0_2_0 - 0.000105820105820102*G0_1_0_2_1 + 0.00980599647266316*G0_1_1_0_0 + 0.0147442680776014*G0_1_1_0_1 - 0.00109347442680775*G0_1_1_0_2 + 0.0147442680776014*G0_1_1_1_0 + 0.0150264550264549*G0_1_1_1_1 - 0.00119929453262784*G0_1_1_1_2 - 0.00109347442680775*G0_1_1_2_0 - 0.00119929453262784*G0_1_1_2_1 - 0.00740740740740728*G0_1_1_2_2;
    A[145] = A[159] + 0.451499118165782*G0_0_1_0_0 + 0.208818342151674*G0_0_1_0_1 + 0.0451499118165783*G0_0_1_0_2 + 0.208818342151674*G0_0_1_1_0 + 0.108359788359788*G0_0_1_1_1 + 0.0214462081128747*G0_0_1_1_2 + 0.0451499118165783*G0_0_1_2_0 + 0.0214462081128747*G0_0_1_2_1 + 0.00677248677248677*G0_0_1_2_2 - 0.451499118165782*G0_1_0_0_0 - 0.208818342151674*G0_1_0_0_1 - 0.0451499118165783*G0_1_0_0_2 - 0.208818342151674*G0_1_0_1_0 - 0.108359788359788*G0_1_0_1_1 - 0.0214462081128747*G0_1_0_1_2 - 0.0451499118165783*G0_1_0_2_0 - 0.0214462081128747*G0_1_0_2_1 - 0.00677248677248677*G0_1_0_2_2;
    A[151] = -A[61] + 0.0889594356261019*G0_0_0_0_0 + 0.0125220458553792*G0_0_0_0_1 + 0.0343209876543208*G0_0_0_0_2 + 0.0125220458553792*G0_0_0_1_0 + 0.19647266313933*G0_0_0_1_1 + 0.0223985890652556*G0_0_0_1_2 + 0.0343209876543208*G0_0_0_2_0 + 0.0223985890652556*G0_0_0_2_1 + 0.0861375661375656*G0_0_0_2_2 + 0.00282186948853616*G0_1_0_0_0 - 0.00987654320987647*G0_1_0_0_1 - 0.00987654320987647*G0_1_0_1_0 + 0.00987654320987646*G0_1_0_1_2 + 0.00987654320987646*G0_1_0_2_1 - 0.00282186948853619*G0_1_0_2_2;
    A[102] = A[186] - 0.180599647266311*G0_0_1_0_0 - 0.0564373897707225*G0_0_1_0_1 + 0.12416225749559*G0_0_1_0_2 - 0.0564373897707225*G0_0_1_1_0 - 0.031604938271605*G0_0_1_1_1 - 0.00225749559082904*G0_0_1_1_2 + 0.12416225749559*G0_0_1_2_0 - 0.00225749559082904*G0_0_1_2_1 + 0.0812698412698408*G0_0_1_2_2 + 0.180599647266311*G0_1_0_0_0 + 0.0564373897707225*G0_1_0_0_1 - 0.12416225749559*G0_1_0_0_2 + 0.0564373897707225*G0_1_0_1_0 + 0.031604938271605*G0_1_0_1_1 + 0.00225749559082906*G0_1_0_1_2 - 0.12416225749559*G0_1_0_2_0 + 0.00225749559082906*G0_1_0_2_1 - 0.0812698412698407*G0_1_0_2_2;
    A[189] = A[102] + 1.39964726631393*G0_0_0_0_0 + 0.0835273368606698*G0_0_0_0_1 + 0.390546737213402*G0_0_0_0_2 + 0.0835273368606698*G0_0_0_1_0 - 0.0902998236331564*G0_0_0_1_1 + 0.029347442680776*G0_0_0_1_2 + 0.390546737213402*G0_0_0_2_0 + 0.0293474426807761*G0_0_0_2_1 + 0.257354497354497*G0_0_0_2_2 + 0.0270899470899467*G0_0_1_0_1 - 0.027089947089947*G0_0_1_0_2 + 0.0270899470899467*G0_0_1_1_0 - 0.0948148148148144*G0_0_1_1_1 - 0.0270899470899471*G0_0_1_2_0 + 0.0948148148148144*G0_0_1_2_2 - 0.153509700176366*G0_1_0_0_1 + 0.153509700176366*G0_1_0_0_2 - 0.153509700176366*G0_1_0_1_0 - 0.20768959435626*G0_1_0_1_1 + 0.153509700176366*G0_1_0_2_0 + 0.20768959435626*G0_1_0_2_2 - 1.39964726631393*G0_1_1_0_0 - 0.390546737213402*G0_1_1_0_1 - 0.0835273368606697*G0_1_1_0_2 - 0.390546737213402*G0_1_1_1_0 - 0.257354497354496*G0_1_1_1_1 - 0.029347442680776*G0_1_1_1_2 - 0.0835273368606697*G0_1_1_2_0 - 0.029347442680776*G0_1_1_2_1 + 0.0902998236331565*G0_1_1_2_2;
    A[147] = A[189] + 0.180599647266314*G0_0_1_0_0 - 0.12416225749559*G0_0_1_0_1 + 0.056437389770723*G0_0_1_0_2 - 0.12416225749559*G0_0_1_1_0 - 0.0812698412698405*G0_0_1_1_1 + 0.00225749559082906*G0_0_1_1_2 + 0.056437389770723*G0_0_1_2_0 + 0.00225749559082906*G0_0_1_2_1 + 0.0316049382716051*G0_0_1_2_2 - 0.180599647266314*G0_1_0_0_0 + 0.12416225749559*G0_1_0_0_1 - 0.056437389770723*G0_1_0_0_2 + 0.12416225749559*G0_1_0_1_0 + 0.0812698412698405*G0_1_0_1_1 - 0.00225749559082906*G0_1_0_1_2 - 0.056437389770723*G0_1_0_2_0 - 0.00225749559082906*G0_1_0_2_1 - 0.0316049382716051*G0_1_0_2_2;
    A[177] = -A[57] + 0.415379188712519*G0_0_0_0_0 - 0.0428924162257494*G0_0_0_0_1 + 0.191887125220457*G0_0_0_0_2 - 0.0428924162257494*G0_0_0_1_0 - 0.0451499118165787*G0_0_0_1_1 + 0.0654673721340386*G0_0_0_1_2 + 0.191887125220457*G0_0_0_2_0 + 0.0654673721340386*G0_0_0_2_1 + 0.148994708994709*G0_0_0_2_2 - 0.0857848324514981*G0_0_1_0_0 - 0.045149911816578*G0_0_1_0_1 + 0.0180599647266315*G0_0_1_0_2 - 0.045149911816578*G0_0_1_1_0 + 0.0451499118165784*G0_0_1_1_2 + 0.0180599647266315*G0_0_1_2_0 + 0.0451499118165784*G0_0_1_2_1 + 0.0496649029982363*G0_0_1_2_2;
    A[191] = A[177] + 0.0541798941798932*G0_0_1_0_0 + 0.0293474426807756*G0_0_1_0_1 - 0.0158024691358026*G0_0_1_0_2 + 0.0293474426807756*G0_0_1_1_0 - 0.0451499118165792*G0_0_1_1_1 - 0.00677248677248696*G0_0_1_1_2 - 0.0158024691358026*G0_0_1_2_0 - 0.00677248677248696*G0_0_1_2_1 - 0.0225749559082894*G0_0_1_2_2 - 0.0541798941798932*G0_1_0_0_0 - 0.0293474426807756*G0_1_0_0_1 + 0.0158024691358026*G0_1_0_0_2 - 0.0293474426807756*G0_1_0_1_0 + 0.0451499118165791*G0_1_0_1_1 + 0.00677248677248694*G0_1_0_1_2 + 0.0158024691358026*G0_1_0_2_0 + 0.00677248677248696*G0_1_0_2_1 + 0.0225749559082894*G0_1_0_2_2;
    A[132] = A[191] - 0.297989417989416*G0_0_0_0_0 + 0.0474074074074073*G0_0_0_0_1 - 0.0880423280423275*G0_0_0_0_2 + 0.0474074074074073*G0_0_0_1_0 + 0.27089947089947*G0_0_0_1_1 + 0.02031746031746*G0_0_0_1_2 - 0.0880423280423275*G0_0_0_2_0 + 0.02031746031746*G0_0_0_2_1 - 0.0677248677248686*G0_0_0_2_2 - 0.00902998236331544*G0_0_1_0_1 + 0.00902998236331571*G0_0_1_0_2 - 0.00902998236331543*G0_0_1_1_0 + 0.16705467372134*G0_0_1_1_1 + 0.00902998236331571*G0_0_1_2_0 - 0.16705467372134*G0_0_1_2_2 + 0.0361199294532624*G0_1_0_0_1 - 0.0361199294532626*G0_1_0_0_2 + 0.0361199294532624*G0_1_0_1_0 + 0.14447971781305*G0_1_0_1_1 - 0.0361199294532626*G0_1_0_2_0 - 0.144479717813051*G0_1_0_2_2 + 0.297989417989417*G0_1_1_0_0 + 0.0880423280423277*G0_1_1_0_1 - 0.0474074074074072*G0_1_1_0_2 + 0.0880423280423277*G0_1_1_1_0 + 0.0677248677248679*G0_1_1_1_1 - 0.0203174603174603*G0_1_1_1_2 - 0.0474074074074072*G0_1_1_2_0 - 0.0203174603174603*G0_1_1_2_1 - 0.27089947089947*G0_1_1_2_2;
    A[188] = A[132] - 0.0541798941798942*G0_0_1_0_0 + 0.0158024691358023*G0_0_1_0_1 - 0.0293474426807757*G0_0_1_0_2 + 0.0158024691358023*G0_0_1_1_0 + 0.0225749559082891*G0_0_1_1_1 + 0.00677248677248672*G0_0_1_1_2 - 0.0293474426807758*G0_0_1_2_0 + 0.00677248677248671*G0_0_1_2_1 + 0.0451499118165782*G0_0_1_2_2 + 0.0541798941798942*G0_1_0_0_0 - 0.0158024691358023*G0_1_0_0_1 + 0.0293474426807757*G0_1_0_0_2 - 0.0158024691358023*G0_1_0_1_0 - 0.0225749559082891*G0_1_0_1_1 - 0.00677248677248673*G0_1_0_1_2 + 0.0293474426807757*G0_1_0_2_0 - 0.00677248677248671*G0_1_0_2_1 - 0.0451499118165782*G0_1_0_2_2;
    A[213] = -A[191] + 0.361199294532626*G0_0_0_0_0 - 0.029347442680776*G0_0_0_0_1 + 0.232522045855378*G0_0_0_0_2 - 0.029347442680776*G0_0_0_1_0 - 0.234779541446208*G0_0_0_1_1 - 0.0293474426807758*G0_0_0_1_2 + 0.232522045855378*G0_0_0_2_0 - 0.0293474426807758*G0_0_0_2_1 + 0.474074074074071*G0_0_0_2_2 - 0.0225749559082894*G0_0_1_0_0 + 0.0180599647266312*G0_0_1_0_1 + 0.00451499118165776*G0_0_1_0_2 + 0.0180599647266311*G0_0_1_1_0 - 0.0180599647266314*G0_0_1_1_2 + 0.00451499118165776*G0_0_1_2_0 - 0.0180599647266314*G0_0_1_2_1 + 0.0135449735449735*G0_0_1_2_2 - 0.0993298059964719*G0_1_0_0_0 - 0.0180599647266311*G0_1_0_0_1 + 0.00451499118165788*G0_1_0_0_2 - 0.0180599647266311*G0_1_0_1_0 + 0.0180599647266316*G0_1_0_1_2 + 0.00451499118165787*G0_1_0_2_0 + 0.0180599647266316*G0_1_0_2_1 + 0.090299823633157*G0_1_0_2_2 - 0.00902998236331595*G0_1_1_0_0 + 0.0090299823633155*G0_1_1_0_2 + 0.0090299823633155*G0_1_1_2_0 - 0.00902998236331544*G0_1_1_2_2;
    A[133] = A[132] + 0.00902998236331568*G0_0_0_0_0 - 0.00902998236331556*G0_0_0_0_1 - 0.00902998236331556*G0_0_0_1_0 + 0.0090299823633159*G0_0_0_1_1 + 0.022574955908289*G0_0_1_0_0 - 0.00451499118165768*G0_0_1_0_1 - 0.0180599647266311*G0_0_1_0_2 - 0.00451499118165768*G0_0_1_1_0 - 0.0135449735449727*G0_0_1_1_1 + 0.0180599647266317*G0_0_1_1_2 - 0.0180599647266311*G0_0_1_2_0 + 0.0180599647266317*G0_0_1_2_1 + 0.0496649029982357*G0_1_0_0_0 - 0.0225749559082892*G0_1_0_0_1 - 0.0270899470899473*G0_1_0_0_2 - 0.0225749559082892*G0_1_0_1_0 - 0.00451499118165742*G0_1_0_1_1 + 0.0270899470899474*G0_1_0_1_2 - 0.0270899470899473*G0_1_0_2_0 + 0.0270899470899474*G0_1_0_2_1 - 0.261869488536154*G0_1_1_0_0 - 0.0586948853615516*G0_1_1_0_1 + 0.0496649029982362*G0_1_1_0_2 - 0.0586948853615517*G0_1_1_1_0 + 0.0270899470899478*G0_1_1_1_1 + 0.0316049382716053*G0_1_1_1_2 + 0.0496649029982362*G0_1_1_2_0 + 0.0316049382716053*G0_1_1_2_1 + 0.189629629629631*G0_1_1_2_2;
    A[88] = -A[133] - 0.0496649029982368*G0_1_0_0_0 - 0.0180599647266315*G0_1_0_0_1 - 0.0451499118165787*G0_1_0_0_2 - 0.0180599647266315*G0_1_0_1_0 + 0.0857848324514989*G0_1_0_1_1 + 0.0451499118165786*G0_1_0_1_2 - 0.0451499118165787*G0_1_0_2_0 + 0.0451499118165786*G0_1_0_2_1 + 0.0993298059964723*G0_1_1_0_0 + 0.173827160493826*G0_1_1_0_1 + 0.0203174603174601*G0_1_1_0_2 + 0.173827160493826*G0_1_1_1_0 + 0.501164021164019*G0_1_1_1_1 + 0.002257495590829*G0_1_1_1_2 + 0.0203174603174601*G0_1_1_2_0 + 0.00225749559082901*G0_1_1_2_1 - 0.0451499118165781*G0_1_1_2_2;
    A[193] = -A[88] - 0.70885361552028*G0_0_0_0_0 - 0.225749559082892*G0_0_0_0_1 - 0.442469135802468*G0_0_0_0_2 - 0.225749559082892*G0_0_0_1_0 - 0.708853615520279*G0_0_0_1_1 - 0.397319223985889*G0_0_0_1_2 - 0.442469135802468*G0_0_0_2_0 - 0.397319223985889*G0_0_0_2_1 - 0.514708994708994*G0_0_0_2_2 - 0.194144620811287*G0_0_1_0_0 - 0.12641975308642*G0_0_1_0_1 - 0.0406349206349208*G0_0_1_0_2 - 0.12641975308642*G0_0_1_1_0 - 0.636613756613754*G0_0_1_1_1 - 0.252839506172838*G0_0_1_1_2 - 0.0406349206349208*G0_0_1_2_0 - 0.252839506172838*G0_0_1_2_1 - 0.0225749559082908*G0_0_1_2_2 - 0.0541798941798951*G0_1_0_0_0 - 0.0880423280423282*G0_1_0_0_1 - 0.128677248677249*G0_1_0_0_2 - 0.0880423280423282*G0_1_0_1_0 - 0.419894179894178*G0_1_0_1_1 - 0.304761904761903*G0_1_0_1_2 - 0.128677248677249*G0_1_0_2_0 - 0.304761904761903*G0_1_0_2_1 - 0.176084656084656*G0_1_0_2_2 + 0.121904761904761*G0_1_1_0_0 + 0.216719576719576*G0_1_1_0_1 + 0.216719576719576*G0_1_1_1_0 - 0.216719576719576*G0_1_1_1_2 - 0.216719576719576*G0_1_1_2_1 - 0.121904761904762*G0_1_1_2_2;
    A[222] = A[193] + 0.758518518518516*G0_0_0_0_0 + 0.216719576719576*G0_0_0_0_1 + 0.514708994708993*G0_0_0_0_2 + 0.216719576719576*G0_0_0_1_0 + 0.541798941798939*G0_0_0_1_1 + 0.189629629629629*G0_0_0_1_2 + 0.514708994708993*G0_0_0_2_0 + 0.189629629629629*G0_0_0_2_1 + 0.108359788359788*G0_0_0_2_2 + 0.0812698412698406*G0_0_1_0_1 - 0.0812698412698409*G0_0_1_0_2 + 0.0812698412698406*G0_0_1_1_0 + 0.460529100529098*G0_0_1_1_1 - 0.0812698412698409*G0_0_1_2_0 - 0.4605291005291*G0_0_1_2_2 - 0.0541798941798936*G0_1_0_0_1 + 0.0541798941798942*G0_1_0_0_2 - 0.0541798941798936*G0_1_0_1_0 + 0.189629629629629*G0_1_0_1_1 + 0.0541798941798941*G0_1_0_2_0 - 0.189629629629629*G0_1_0_2_2 - 0.758518518518516*G0_1_1_0_0 - 0.514708994708993*G0_1_1_0_1 - 0.216719576719576*G0_1_1_0_2 - 0.514708994708993*G0_1_1_1_0 - 0.108359788359788*G0_1_1_1_1 - 0.189629629629629*G0_1_1_1_2 - 0.216719576719576*G0_1_1_2_0 - 0.189629629629629*G0_1_1_2_1 - 0.54179894179894*G0_1_1_2_2;
    A[207] = A[193] + 0.162539682539681*G0_0_1_0_0 + 0.0541798941798936*G0_0_1_0_1 - 0.081269841269841*G0_0_1_0_2 + 0.0541798941798936*G0_0_1_1_0 + 0.162539682539681*G0_0_1_1_1 - 0.0812698412698411*G0_0_1_1_2 - 0.081269841269841*G0_0_1_2_0 - 0.0812698412698411*G0_0_1_2_1 - 0.108359788359788*G0_0_1_2_2 - 0.162539682539681*G0_1_0_0_0 - 0.0541798941798936*G0_1_0_0_1 + 0.081269841269841*G0_1_0_0_2 - 0.0541798941798936*G0_1_0_1_0 - 0.162539682539681*G0_1_0_1_1 + 0.0812698412698412*G0_1_0_1_2 + 0.081269841269841*G0_1_0_2_0 + 0.0812698412698412*G0_1_0_2_1 + 0.108359788359788*G0_1_0_2_2;
    A[183] = -A[191] + 0.415379188712519*G0_0_0_0_0 - 0.0428924162257494*G0_0_0_0_1 + 0.191887125220457*G0_0_0_0_2 - 0.0428924162257494*G0_0_0_1_0 - 0.0451499118165787*G0_0_0_1_1 + 0.0654673721340386*G0_0_0_1_2 + 0.191887125220457*G0_0_0_2_0 + 0.0654673721340386*G0_0_0_2_1 + 0.148994708994709*G0_0_0_2_2 - 0.0857848324514981*G0_1_0_0_0 - 0.045149911816578*G0_1_0_0_1 + 0.0180599647266315*G0_1_0_0_2 - 0.045149911816578*G0_1_0_1_0 + 0.0451499118165784*G0_1_0_1_2 + 0.0180599647266315*G0_1_0_2_0 + 0.0451499118165784*G0_1_0_2_1 + 0.0496649029982363*G0_1_0_2_2;
    A[194] = A[222] + 0.162539682539683*G0_0_1_0_0 - 0.0812698412698407*G0_0_1_0_1 + 0.054179894179894*G0_0_1_0_2 - 0.0812698412698406*G0_0_1_1_0 - 0.108359788359788*G0_0_1_1_1 - 0.0812698412698406*G0_0_1_1_2 + 0.0541798941798941*G0_0_1_2_0 - 0.0812698412698406*G0_0_1_2_1 + 0.162539682539683*G0_0_1_2_2 - 0.162539682539683*G0_1_0_0_0 + 0.0812698412698407*G0_1_0_0_1 - 0.0541798941798941*G0_1_0_0_2 + 0.0812698412698407*G0_1_0_1_0 + 0.108359788359788*G0_1_0_1_1 + 0.0812698412698406*G0_1_0_1_2 - 0.054179894179894*G0_1_0_2_0 + 0.0812698412698406*G0_1_0_2_1 - 0.162539682539683*G0_1_0_2_2;
    A[200] = A[88] - 0.0225749559082892*G0_0_1_0_0 - 0.0158024691358022*G0_0_1_0_1 - 0.00677248677248666*G0_0_1_0_2 - 0.0158024691358022*G0_0_1_1_0 + 0.0541798941798946*G0_0_1_1_1 + 0.0293474426807762*G0_0_1_1_2 - 0.00677248677248666*G0_0_1_2_0 + 0.0293474426807762*G0_0_1_2_1 - 0.0451499118165767*G0_0_1_2_2 + 0.0225749559082892*G0_1_0_0_0 + 0.0158024691358022*G0_1_0_0_1 + 0.00677248677248666*G0_1_0_0_2 + 0.0158024691358022*G0_1_0_1_0 - 0.0541798941798946*G0_1_0_1_1 - 0.0293474426807762*G0_1_0_1_2 + 0.00677248677248666*G0_1_0_2_0 - 0.0293474426807762*G0_1_0_2_1 + 0.0451499118165767*G0_1_0_2_2;
    A[223] = -A[213] - 0.0948148148148149*G0_0_0_0_0 - 0.108359788359788*G0_0_0_0_2 + 0.0948148148148141*G0_0_0_1_1 + 0.108359788359788*G0_0_0_1_2 - 0.108359788359788*G0_0_0_2_0 + 0.108359788359788*G0_0_0_2_1 + 0.0496649029982357*G0_0_1_0_0 + 0.0677248677248672*G0_0_1_0_1 + 0.0632098765432093*G0_0_1_0_2 + 0.0677248677248672*G0_0_1_1_0 + 0.437954144620809*G0_0_1_1_1 + 0.261869488536154*G0_0_1_1_2 + 0.0632098765432093*G0_0_1_2_0 + 0.261869488536154*G0_0_1_2_1 + 0.284444444444443*G0_0_1_2_2 + 0.135449735449735*G0_1_0_0_0 + 0.142222222222222*G0_1_0_0_1 + 0.128677248677248*G0_1_0_0_2 + 0.142222222222222*G0_1_0_1_0 + 0.230264550264549*G0_1_0_1_1 + 0.237037037037036*G0_1_0_1_2 + 0.128677248677248*G0_1_0_2_0 + 0.237037037037036*G0_1_0_2_1 + 0.176084656084656*G0_1_0_2_2 - 0.16705467372134*G0_1_1_0_0 - 0.252839506172838*G0_1_1_0_1 - 0.00902998236331555*G0_1_1_0_2 - 0.252839506172838*G0_1_1_1_0 - 0.406349206349205*G0_1_1_1_1 + 0.117389770723103*G0_1_1_1_2 - 0.00902998236331554*G0_1_1_2_0 + 0.117389770723103*G0_1_1_2_1 + 0.0496649029982372*G0_1_1_2_2;
    A[208] = A[223] + 0.758518518518516*G0_0_0_0_0 + 0.325079365079364*G0_0_0_0_1 + 0.677248677248675*G0_0_0_0_2 + 0.325079365079364*G0_0_0_1_0 + 1.40867724867724*G0_0_0_1_1 + 0.568888888888886*G0_0_0_1_2 + 0.677248677248675*G0_0_0_2_0 + 0.568888888888886*G0_0_0_2_1 + 1.19195767195767*G0_0_0_2_2 + 0.0541798941798946*G0_0_1_0_0 + 0.0812698412698412*G0_0_1_0_1 + 0.0812698412698412*G0_0_1_1_0 + 0.893968253968249*G0_0_1_1_1 + 0.243809523809522*G0_0_1_1_2 + 0.243809523809522*G0_0_1_2_1 + 0.0270899470899474*G0_0_1_2_2 - 0.0541798941798942*G0_1_0_0_0 - 0.0812698412698407*G0_1_0_0_2 + 1.05650793650793*G0_1_0_1_1 + 0.297989417989416*G0_1_0_1_2 - 0.0812698412698407*G0_1_0_2_0 + 0.297989417989416*G0_1_0_2_1 + 0.189629629629628*G0_1_0_2_2 + 0.541798941798939*G0_1_1_0_0 + 0.839788359788356*G0_1_1_0_1 + 0.108359788359788*G0_1_1_0_2 + 0.839788359788356*G0_1_1_1_0 + 2.7089947089947*G0_1_1_1_1 + 0.514708994708992*G0_1_1_1_2 + 0.108359788359788*G0_1_1_2_0 + 0.514708994708992*G0_1_1_2_1 + 0.325079365079362*G0_1_1_2_2;
    A[192] = A[208] + 0.866878306878302*G0_0_0_0_0 + 0.216719576719576*G0_0_0_0_2 - 0.866878306878302*G0_0_0_1_1 - 0.216719576719575*G0_0_0_1_2 + 0.216719576719576*G0_0_0_2_0 - 0.216719576719575*G0_0_0_2_1 + 0.216719576719575*G0_0_1_0_0 + 0.0541798941798941*G0_0_1_0_1 + 0.135449735449735*G0_0_1_0_2 + 0.0541798941798941*G0_0_1_1_0 - 0.650158730158726*G0_0_1_1_1 - 0.0812698412698405*G0_0_1_1_2 + 0.135449735449735*G0_0_1_2_0 - 0.0812698412698405*G0_0_1_2_1 + 0.216719576719576*G0_0_1_2_2 + 0.216719576719575*G0_1_0_0_0 + 0.0541798941798941*G0_1_0_0_1 + 0.135449735449735*G0_1_0_0_2 + 0.0541798941798941*G0_1_0_1_0 - 0.650158730158726*G0_1_0_1_1 - 0.0812698412698405*G0_1_0_1_2 + 0.135449735449735*G0_1_0_2_0 - 0.0812698412698405*G0_1_0_2_1 + 0.216719576719576*G0_1_0_2_2 + 1.08359788359788*G0_1_1_0_0 + 0.0541798941798939*G0_1_1_0_1 + 0.216719576719576*G0_1_1_0_2 + 0.0541798941798938*G0_1_1_1_0 - 1.51703703703703*G0_1_1_1_1 - 0.162539682539681*G0_1_1_1_2 + 0.216719576719576*G0_1_1_2_0 - 0.162539682539681*G0_1_1_2_1 + 0.216719576719577*G0_1_1_2_2;
    A[185] = -A[188] - 0.0857848324514987*G0_0_1_0_0 + 0.0180599647266313*G0_0_1_0_1 - 0.045149911816578*G0_0_1_0_2 + 0.0180599647266313*G0_0_1_1_0 + 0.0496649029982361*G0_0_1_1_1 + 0.0451499118165781*G0_0_1_1_2 - 0.045149911816578*G0_0_1_2_0 + 0.0451499118165781*G0_0_1_2_1 + 0.41537918871252*G0_1_1_0_0 + 0.191887125220457*G0_1_1_0_1 - 0.0428924162257495*G0_1_1_0_2 + 0.191887125220458*G0_1_1_1_0 + 0.148994708994708*G0_1_1_1_1 + 0.0654673721340383*G0_1_1_1_2 - 0.0428924162257495*G0_1_1_2_0 + 0.0654673721340383*G0_1_1_2_1 - 0.0451499118165788*G0_1_1_2_2;
    A[203] = -A[200] - 0.0496649029982368*G0_0_1_0_0 - 0.0180599647266315*G0_0_1_0_1 - 0.0451499118165786*G0_0_1_0_2 - 0.0180599647266315*G0_0_1_1_0 + 0.085784832451499*G0_0_1_1_1 + 0.0451499118165786*G0_0_1_1_2 - 0.0451499118165787*G0_0_1_2_0 + 0.0451499118165786*G0_0_1_2_1 + 0.0993298059964723*G0_1_1_0_0 + 0.173827160493826*G0_1_1_0_1 + 0.0203174603174601*G0_1_1_0_2 + 0.173827160493826*G0_1_1_1_0 + 0.501164021164019*G0_1_1_1_1 + 0.00225749559082901*G0_1_1_1_2 + 0.0203174603174601*G0_1_1_2_0 + 0.00225749559082901*G0_1_1_2_1 - 0.045149911816578*G0_1_1_2_2;
    A[87] = -A[132] - 0.0857848324514987*G0_1_0_0_0 + 0.0180599647266313*G0_1_0_0_1 - 0.045149911816578*G0_1_0_0_2 + 0.0180599647266313*G0_1_0_1_0 + 0.0496649029982361*G0_1_0_1_1 + 0.0451499118165781*G0_1_0_1_2 - 0.045149911816578*G0_1_0_2_0 + 0.0451499118165781*G0_1_0_2_1 + 0.41537918871252*G0_1_1_0_0 + 0.191887125220457*G0_1_1_0_1 - 0.0428924162257495*G0_1_1_0_2 + 0.191887125220457*G0_1_1_1_0 + 0.148994708994708*G0_1_1_1_1 + 0.0654673721340383*G0_1_1_1_2 - 0.0428924162257495*G0_1_1_2_0 + 0.0654673721340383*G0_1_1_2_1 - 0.0451499118165787*G0_1_1_2_2;
    A[224] = A[208] - 0.216719576719576*G0_0_0_0_0 - 0.216719576719576*G0_0_0_0_1 + 0.162539682539682*G0_0_0_0_2 - 0.216719576719576*G0_0_0_1_0 - 1.08359788359788*G0_0_0_1_1 - 0.054179894179893*G0_0_0_1_2 + 0.162539682539682*G0_0_0_2_0 - 0.054179894179893*G0_0_0_2_1 + 1.51703703703703*G0_0_0_2_2 - 0.0812698412698406*G0_0_1_0_1 + 0.0812698412698408*G0_0_1_0_2 - 0.0812698412698407*G0_0_1_1_0 - 0.866878306878302*G0_0_1_1_1 + 0.0812698412698408*G0_0_1_2_0 + 0.866878306878305*G0_0_1_2_2 - 0.0812698412698407*G0_1_0_0_1 + 0.0812698412698408*G0_1_0_0_2 - 0.0812698412698407*G0_1_0_1_0 - 0.866878306878302*G0_1_0_1_1 + 0.0812698412698408*G0_1_0_2_0 + 0.866878306878305*G0_1_0_2_2 + 0.216719576719576*G0_1_1_0_0 - 0.162539682539682*G0_1_1_0_1 + 0.216719576719576*G0_1_1_0_2 - 0.162539682539682*G0_1_1_1_0 - 1.51703703703703*G0_1_1_1_1 + 0.0541798941798942*G0_1_1_1_2 + 0.216719576719576*G0_1_1_2_0 + 0.0541798941798942*G0_1_1_2_1 + 1.08359788359788*G0_1_1_2_2;
    A[114] = A[142] + 0.141093474426807*G0_0_1_0_0 - 0.0338624338624336*G0_0_1_0_1 - 0.0169312169312168*G0_0_1_0_2 - 0.0338624338624336*G0_0_1_1_0 - 0.0237037037037036*G0_0_1_1_1 - 0.00169312169312176*G0_0_1_1_2 - 0.0169312169312168*G0_0_1_2_0 - 0.00169312169312176*G0_0_1_2_1 - 0.0124162257495593*G0_0_1_2_2 - 0.141093474426807*G0_1_0_0_0 + 0.0338624338624336*G0_1_0_0_1 + 0.0169312169312168*G0_1_0_0_2 + 0.0338624338624336*G0_1_0_1_0 + 0.0237037037037036*G0_1_0_1_1 + 0.00169312169312176*G0_1_0_1_2 + 0.0169312169312168*G0_1_0_2_0 + 0.00169312169312176*G0_1_0_2_1 + 0.0124162257495593*G0_1_0_2_2;
    A[221] = -A[213] + 0.0993298059964719*G0_0_0_0_0 + 0.0203174603174602*G0_0_0_0_1 + 0.173827160493826*G0_0_0_0_2 + 0.0203174603174602*G0_0_0_1_0 - 0.0451499118165788*G0_0_0_1_1 + 0.00225749559082884*G0_0_0_1_2 + 0.173827160493826*G0_0_0_2_0 + 0.00225749559082885*G0_0_0_2_1 + 0.501164021164018*G0_0_0_2_2 - 0.0496649029982366*G0_1_0_0_0 - 0.0451499118165783*G0_1_0_0_1 - 0.0180599647266314*G0_1_0_0_2 - 0.0451499118165783*G0_1_0_1_0 + 0.0451499118165784*G0_1_0_1_2 - 0.0180599647266314*G0_1_0_2_0 + 0.0451499118165785*G0_1_0_2_1 + 0.085784832451499*G0_1_0_2_2;
    A[179] = A[221] - 0.0270899470899474*G0_0_1_0_0 - 0.0383774250440916*G0_0_1_0_1 - 0.00225749559082903*G0_0_1_0_2 - 0.0383774250440916*G0_0_1_1_0 + 0.0451499118165785*G0_0_1_1_1 + 0.0158024691358023*G0_0_1_1_2 - 0.00225749559082903*G0_0_1_2_0 + 0.0158024691358023*G0_0_1_2_1 + 0.0316049382716046*G0_0_1_2_2 + 0.0270899470899474*G0_1_0_0_0 + 0.0383774250440916*G0_1_0_0_1 + 0.00225749559082903*G0_1_0_0_2 + 0.0383774250440916*G0_1_0_1_0 - 0.0451499118165785*G0_1_0_1_1 - 0.0158024691358023*G0_1_0_1_2 + 0.00225749559082903*G0_1_0_2_0 - 0.0158024691358023*G0_1_0_2_1 - 0.0316049382716046*G0_1_0_2_2;
    A[59] = -A[179] + 0.0993298059964719*G0_0_0_0_0 + 0.0203174603174602*G0_0_0_0_1 + 0.173827160493826*G0_0_0_0_2 + 0.0203174603174602*G0_0_0_1_0 - 0.0451499118165788*G0_0_0_1_1 + 0.00225749559082883*G0_0_0_1_2 + 0.173827160493826*G0_0_0_2_0 + 0.00225749559082884*G0_0_0_2_1 + 0.501164021164018*G0_0_0_2_2 - 0.0496649029982366*G0_0_1_0_0 - 0.0451499118165783*G0_0_1_0_1 - 0.0180599647266314*G0_0_1_0_2 - 0.0451499118165783*G0_0_1_1_0 + 0.0451499118165784*G0_0_1_1_2 - 0.0180599647266314*G0_0_1_2_0 + 0.0451499118165784*G0_0_1_2_1 + 0.085784832451499*G0_0_1_2_2;
    A[196] = A[28] + 0.0028218694885362*G0_0_1_0_0 - 0.00987654320987643*G0_0_1_0_1 - 0.00987654320987643*G0_0_1_1_0 + 0.00987654320987648*G0_0_1_1_2 + 0.00987654320987648*G0_0_1_2_1 - 0.00282186948853623*G0_0_1_2_2 - 0.0028218694885362*G0_1_0_0_0 + 0.00987654320987643*G0_1_0_0_1 + 0.00987654320987643*G0_1_0_1_0 - 0.00987654320987648*G0_1_0_1_2 - 0.00987654320987648*G0_1_0_2_1 + 0.00282186948853623*G0_1_0_2_2;
    A[209] = A[223] + 0.108359788359789*G0_0_1_0_0 + 0.0812698412698414*G0_0_1_0_1 + 0.0812698412698413*G0_0_1_0_2 + 0.0812698412698414*G0_0_1_1_0 - 0.162539682539682*G0_0_1_1_1 - 0.0541798941798942*G0_0_1_1_2 + 0.0812698412698413*G0_0_1_2_0 - 0.0541798941798942*G0_0_1_2_1 - 0.162539682539681*G0_0_1_2_2 - 0.108359788359789*G0_1_0_0_0 - 0.0812698412698414*G0_1_0_0_1 - 0.0812698412698413*G0_1_0_0_2 - 0.0812698412698414*G0_1_0_1_0 + 0.162539682539682*G0_1_0_1_1 + 0.0541798941798943*G0_1_0_1_2 - 0.0812698412698413*G0_1_0_2_0 + 0.0541798941798944*G0_1_0_2_1 + 0.162539682539681*G0_1_0_2_2;
    A[13] = A[195] + 0.00141093474426803*G0_0_1_0_1 - 0.00141093474426806*G0_0_1_0_2 + 0.00141093474426803*G0_0_1_1_0 - 0.0129805996472663*G0_0_1_1_1 + 0.00451499118165779*G0_0_1_1_2 - 0.00141093474426805*G0_0_1_2_0 + 0.00451499118165779*G0_0_1_2_1 + 0.00395061728395065*G0_0_1_2_2 - 0.00141093474426803*G0_1_0_0_1 + 0.00141093474426805*G0_1_0_0_2 - 0.00141093474426803*G0_1_0_1_0 + 0.0129805996472663*G0_1_0_1_1 - 0.00451499118165779*G0_1_0_1_2 + 0.00141093474426805*G0_1_0_2_0 - 0.00451499118165779*G0_1_0_2_1 - 0.00395061728395065*G0_1_0_2_2;
    A[53] = A[123] + 0.0135449735449736*G0_0_1_0_0 + 0.0203174603174602*G0_0_1_0_2 + 0.00902998236331499*G0_0_1_1_1 + 0.00225749559082872*G0_0_1_1_2 + 0.0203174603174602*G0_0_1_2_0 + 0.00225749559082872*G0_0_1_2_1 - 0.0677248677248678*G0_0_1_2_2 - 0.0135449735449736*G0_1_0_0_0 - 0.0203174603174602*G0_1_0_0_2 - 0.00902998236331499*G0_1_0_1_1 - 0.00225749559082872*G0_1_0_1_2 - 0.0203174603174602*G0_1_0_2_0 - 0.00225749559082872*G0_1_0_2_1 + 0.0677248677248678*G0_1_0_2_2;
    A[30] = -A[31] + 0.022716049382716*G0_1_0_0_0 - 0.0020811287477954*G0_1_0_0_2 - 0.0227160493827161*G0_1_0_1_1 + 0.0020811287477954*G0_1_0_1_2 - 0.0020811287477954*G0_1_0_2_0 + 0.0020811287477954*G0_1_0_2_1 + 0.0231922398589064*G0_1_1_0_0 + 0.00231922398589064*G0_1_1_0_1 + 0.000238095238095254*G0_1_1_0_2 + 0.00231922398589064*G0_1_1_1_0 + 0.000476190476190448*G0_1_1_1_1 + 0.00231922398589066*G0_1_1_1_2 + 0.000238095238095254*G0_1_1_2_0 + 0.00231922398589066*G0_1_1_2_1 + 0.0231922398589066*G0_1_1_2_2;
    A[23] = A[21] - 0.0338624338624336*G0_0_0_0_0 + 0.00197530864197531*G0_0_0_0_1 - 0.0047971781305114*G0_0_0_0_2 + 0.00197530864197531*G0_0_0_1_0 - 0.00197530864197528*G0_0_0_1_2 - 0.00479717813051139*G0_0_0_2_0 - 0.00197530864197528*G0_0_0_2_1 + 0.0434567901234566*G0_0_0_2_2 + 0.00959435626102304*G0_0_1_0_0 - 0.00959435626102288*G0_0_1_0_2 - 0.00959435626102288*G0_0_1_2_0 + 0.00959435626102282*G0_0_1_2_2;
    A[20] = -A[23] - 0.00197530864197541*G0_0_1_0_0 + 0.0136860670194003*G0_0_1_0_1 - 0.00183421516754853*G0_0_1_0_2 + 0.0136860670194003*G0_0_1_1_0 + 0.131216931216931*G0_0_1_1_1 + 0.00888888888888886*G0_0_1_1_2 - 0.00183421516754853*G0_0_1_2_0 + 0.00888888888888886*G0_0_1_2_1 + 0.0324514991181655*G0_0_1_2_2;
    A[70] = A[20] - 0.00395061728395048*G0_0_0_0_0 + 0.00917107583774251*G0_0_0_0_1 + 0.00888888888888883*G0_0_0_0_2 + 0.00917107583774251*G0_0_0_1_0 - 0.00677248677248678*G0_0_0_1_1 + 0.0074779541446206*G0_0_0_1_2 + 0.00888888888888883*G0_0_0_2_0 + 0.0074779541446206*G0_0_0_2_1 + 0.052768959435626*G0_0_0_2_2 + 0.0179188712522044*G0_0_1_0_0 + 0.0173544973544971*G0_0_1_0_1 + 0.0173544973544971*G0_0_1_1_0 - 0.112169312169312*G0_0_1_1_1 + 0.0214462081128745*G0_0_1_1_2 + 0.0214462081128746*G0_0_1_2_1 + 0.0102998236331567*G0_0_1_2_2 + 0.0105820105820104*G0_1_0_0_0 + 0.0385185185185184*G0_1_0_0_1 - 0.00677248677248675*G0_1_0_0_2 + 0.0385185185185184*G0_1_0_1_0 + 0.0232804232804222*G0_1_0_1_1 + 0.0397883597883594*G0_1_0_1_2 - 0.00677248677248675*G0_1_0_2_0 + 0.0397883597883594*G0_1_0_2_1 + 0.0198941798941795*G0_1_0_2_2 + 0.0397883597883595*G0_1_1_0_0 + 0.0698412698412694*G0_1_1_0_1 - 0.00380952380952387*G0_1_1_0_2 + 0.0698412698412694*G0_1_1_1_0 + 0.0423280423280413*G0_1_1_1_1 + 0.0698412698412693*G0_1_1_1_2 - 0.00380952380952387*G0_1_1_2_0 + 0.0698412698412693*G0_1_1_2_1 + 0.0397883597883594*G0_1_1_2_2;
    A[157] = A[70] + 0.0118518518518514*G0_0_0_0_0 + 0.00931216931216917*G0_0_0_0_2 - 0.0118518518518516*G0_0_0_1_1 - 0.00931216931216907*G0_0_0_1_2 + 0.00931216931216918*G0_0_0_2_0 - 0.00931216931216907*G0_0_0_2_1 - 0.037248677248676*G0_0_1_0_0 - 0.0584126984126977*G0_0_1_0_1 - 0.031322751322751*G0_0_1_0_2 - 0.0584126984126977*G0_0_1_1_0 - 0.0355555555555552*G0_0_1_1_1 - 0.0224338624338621*G0_0_1_1_2 - 0.031322751322751*G0_0_1_2_0 - 0.0224338624338621*G0_0_1_2_1 - 0.0457142857142855*G0_0_1_2_2 - 0.0237037037037036*G0_1_0_0_0 - 0.0584126984126981*G0_1_0_0_1 - 0.0131216931216933*G0_1_0_0_2 - 0.0584126984126981*G0_1_0_1_0 - 0.049100529100528*G0_1_0_1_1 - 0.0406349206349202*G0_1_0_1_2 - 0.0131216931216933*G0_1_0_2_0 - 0.0406349206349202*G0_1_0_2_1 - 0.0457142857142857*G0_1_0_2_2 - 0.0338624338624328*G0_1_1_0_0 - 0.0584126984126979*G0_1_1_0_1 + 0.013968253968254*G0_1_1_0_2 - 0.0584126984126979*G0_1_1_1_0 - 0.0389417989417981*G0_1_1_1_1 - 0.0677248677248672*G0_1_1_1_2 + 0.013968253968254*G0_1_1_2_0 - 0.0677248677248672*G0_1_1_2_1 - 0.0457142857142855*G0_1_1_2_2;
    A[154] = A[70] - 0.0093121693121693*G0_0_1_0_0 + 0.00846560846560862*G0_0_1_0_1 - 0.00973544973544961*G0_0_1_0_2 + 0.00846560846560861*G0_0_1_1_0 + 0.00423280423280341*G0_0_1_1_1 + 0.00846560846560836*G0_0_1_1_2 - 0.00973544973544961*G0_0_1_2_0 + 0.00846560846560834*G0_0_1_2_1 - 0.00931216931216905*G0_0_1_2_2 + 0.0093121693121693*G0_1_0_0_0 - 0.00846560846560862*G0_1_0_0_1 + 0.00973544973544961*G0_1_0_0_2 - 0.00846560846560862*G0_1_0_1_0 - 0.00423280423280349*G0_1_0_1_1 - 0.00846560846560836*G0_1_0_1_2 + 0.00973544973544961*G0_1_0_2_0 - 0.00846560846560835*G0_1_0_2_1 + 0.00931216931216904*G0_1_0_2_2;
    A[5] = -A[20] - 0.0146737213403879*G0_0_0_0_0 - 0.0107231040564373*G0_0_0_0_2 + 0.0146737213403878*G0_0_0_1_1 + 0.0107231040564373*G0_0_0_1_2 - 0.0107231040564373*G0_0_0_2_0 + 0.0107231040564373*G0_0_0_2_1 - 0.0107231040564372*G0_0_1_0_0 + 0.0107231040564374*G0_0_1_0_1 + 0.0107231040564374*G0_0_1_1_0 + 0.137142857142857*G0_0_1_1_1 + 0.0214462081128746*G0_0_1_1_2 + 0.0214462081128746*G0_0_1_2_1 + 0.0547442680776009*G0_0_1_2_2 - 0.0126984126984126*G0_1_0_0_0 - 0.000987654320987642*G0_1_0_0_1 - 0.00395061728395058*G0_1_0_0_2 - 0.000987654320987642*G0_1_0_1_0 + 0.00197530864197531*G0_1_0_1_1 + 0.00677248677248675*G0_1_0_1_2 - 0.00395061728395058*G0_1_0_2_0 + 0.00677248677248675*G0_1_0_2_1 + 0.0493827160493829*G0_1_0_2_2 - 0.0126984126984125*G0_1_1_0_0 - 0.00197530864197526*G0_1_1_0_1 - 0.00296296296296295*G0_1_1_0_2 - 0.00197530864197526*G0_1_1_1_0 + 0.00592592592592605*G0_1_1_1_1 + 0.0115696649029981*G0_1_1_1_2 - 0.00296296296296295*G0_1_1_2_0 + 0.0115696649029981*G0_1_1_2_1 + 0.0358377425044089*G0_1_1_2_2;
    A[8] = -A[5] - 0.131216931216931*G0_0_1_0_0 - 0.0136860670194003*G0_0_1_0_1 - 0.00888888888888886*G0_0_1_0_2 - 0.0136860670194003*G0_0_1_1_0 + 0.00197530864197535*G0_0_1_1_1 + 0.00183421516754843*G0_0_1_1_2 - 0.00888888888888886*G0_0_1_2_0 + 0.00183421516754843*G0_0_1_2_1 - 0.0324514991181658*G0_0_1_2_2 - 0.131216931216931*G0_1_1_0_0 - 0.0136860670194003*G0_1_1_0_1 - 0.00888888888888888*G0_1_1_0_2 - 0.0136860670194003*G0_1_1_1_0 + 0.00197530864197538*G0_1_1_1_1 + 0.00183421516754841*G0_1_1_1_2 - 0.00888888888888888*G0_1_1_2_0 + 0.00183421516754841*G0_1_1_2_1 - 0.032451499118166*G0_1_1_2_2;
    A[109] = A[70] + 0.0457142857142855*G0_0_0_0_0 - 0.0139682539682539*G0_0_0_0_1 + 0.0677248677248676*G0_0_0_0_2 - 0.0139682539682539*G0_0_0_1_0 + 0.033862433862434*G0_0_0_1_1 + 0.0584126984126984*G0_0_0_1_2 + 0.0677248677248676*G0_0_0_2_0 + 0.0584126984126984*G0_0_0_2_1 + 0.0389417989418006*G0_0_0_2_2 - 0.0270899470899466*G0_0_1_0_1 + 0.0270899470899473*G0_0_1_0_2 - 0.0270899470899466*G0_0_1_1_0 + 0.0101587301587315*G0_0_1_1_1 + 0.0270899470899473*G0_0_1_2_0 - 0.0101587301587284*G0_0_1_2_2 - 0.0452910052910052*G0_1_0_0_1 + 0.0452910052910051*G0_1_0_0_2 - 0.0452910052910052*G0_1_0_1_0 - 0.00338624338624253*G0_1_0_1_1 + 0.0452910052910051*G0_1_0_2_0 + 0.00338624338624464*G0_1_0_2_2 - 0.0457142857142863*G0_1_1_0_0 - 0.0677248677248674*G0_1_1_0_1 + 0.0139682539682539*G0_1_1_0_2 - 0.0677248677248674*G0_1_1_1_0 - 0.0389417989417973*G0_1_1_1_1 - 0.0584126984126979*G0_1_1_1_2 + 0.0139682539682539*G0_1_1_2_0 - 0.0584126984126979*G0_1_1_2_1 - 0.0338624338624326*G0_1_1_2_2;
    A[45] = A[5] - 0.00197530864197531*G0_0_0_0_1 + 0.00197530864197531*G0_0_0_0_2 - 0.00197530864197531*G0_0_0_1_0 + 0.0338624338624336*G0_0_0_1_1 + 0.00479717813051143*G0_0_0_1_2 + 0.00197530864197531*G0_0_0_2_0 + 0.00479717813051143*G0_0_0_2_1 - 0.0434567901234565*G0_0_0_2_2 - 0.000987654320987667*G0_0_1_0_1 + 0.000987654320987666*G0_0_1_0_2 - 0.000987654320987668*G0_0_1_1_0 + 0.0299118165784829*G0_0_1_1_1 + 0.000987654320987665*G0_0_1_2_0 - 0.0299118165784828*G0_0_1_2_2 - 0.00296296296296295*G0_1_0_0_1 + 0.00296296296296293*G0_1_0_0_2 - 0.00296296296296295*G0_1_0_1_0 + 0.0474074074074073*G0_1_0_1_1 + 0.00296296296296293*G0_1_0_2_0 - 0.0474074074074074*G0_1_0_2_2 - 0.00197530864197531*G0_1_1_0_1 + 0.0019753086419753*G0_1_1_0_2 - 0.00197530864197531*G0_1_1_1_0 + 0.0434567901234565*G0_1_1_1_1 - 0.00479717813051142*G0_1_1_1_2 + 0.0019753086419753*G0_1_1_2_0 - 0.00479717813051142*G0_1_1_2_1 - 0.0338624338624336*G0_1_1_2_2;
    A[165] = -A[45] - 0.131216931216931*G0_0_0_0_0 - 0.00888888888888889*G0_0_0_0_1 - 0.0136860670194003*G0_0_0_0_2 - 0.00888888888888889*G0_0_0_1_0 - 0.0324514991181658*G0_0_0_1_1 + 0.00183421516754849*G0_0_0_1_2 - 0.0136860670194003*G0_0_0_2_0 + 0.00183421516754849*G0_0_0_2_1 + 0.00197530864197539*G0_0_0_2_2 - 0.131216931216931*G0_0_1_0_0 - 0.00888888888888886*G0_0_1_0_1 - 0.0136860670194003*G0_0_1_0_2 - 0.00888888888888886*G0_0_1_1_0 - 0.0324514991181657*G0_0_1_1_1 + 0.00183421516754847*G0_0_1_1_2 - 0.0136860670194003*G0_0_1_2_0 + 0.00183421516754847*G0_0_1_2_1 + 0.00197530864197544*G0_0_1_2_2;
    A[75] = A[5] + 0.000987654320987648*G0_0_1_0_1 - 0.000987654320987633*G0_0_1_0_2 + 0.000987654320987648*G0_0_1_1_0 - 0.00395061728395065*G0_0_1_1_1 - 0.00479717813051138*G0_0_1_1_2 - 0.000987654320987634*G0_0_1_2_0 - 0.00479717813051138*G0_0_1_2_1 + 0.0135449735449739*G0_0_1_2_2 - 0.000987654320987648*G0_1_0_0_1 + 0.000987654320987632*G0_1_0_0_2 - 0.000987654320987648*G0_1_0_1_0 + 0.00395061728395065*G0_1_0_1_1 + 0.00479717813051138*G0_1_0_1_2 + 0.000987654320987634*G0_1_0_2_0 + 0.00479717813051138*G0_1_0_2_1 - 0.0135449735449739*G0_1_0_2_2;
    A[120] = -A[75] - 0.131216931216931*G0_1_0_0_0 - 0.0136860670194003*G0_1_0_0_1 - 0.00888888888888886*G0_1_0_0_2 - 0.0136860670194003*G0_1_0_1_0 + 0.00197530864197535*G0_1_0_1_1 + 0.00183421516754843*G0_1_0_1_2 - 0.00888888888888886*G0_1_0_2_0 + 0.00183421516754843*G0_1_0_2_1 - 0.0324514991181658*G0_1_0_2_2 - 0.131216931216931*G0_1_1_0_0 - 0.0136860670194003*G0_1_1_0_1 - 0.00888888888888888*G0_1_1_0_2 - 0.0136860670194003*G0_1_1_1_0 + 0.00197530864197538*G0_1_1_1_1 + 0.00183421516754841*G0_1_1_1_2 - 0.00888888888888888*G0_1_1_2_0 + 0.00183421516754841*G0_1_1_2_1 - 0.032451499118166*G0_1_1_2_2;
    A[24] = -A[20] - 0.07026455026455*G0_0_0_0_0 - 0.00493827160493828*G0_0_0_0_1 - 0.0165079365079364*G0_0_0_0_2 - 0.00493827160493828*G0_0_0_1_0 - 0.105820105820106*G0_0_0_1_1 - 0.00776014109347441*G0_0_0_1_2 - 0.0165079365079364*G0_0_0_2_0 - 0.00776014109347441*G0_0_0_2_1 - 0.0533333333333331*G0_0_0_2_2 - 0.0169312169312168*G0_0_1_0_0 + 0.00282186948853617*G0_0_1_0_1 + 0.00282186948853617*G0_0_1_1_0 - 0.00282186948853613*G0_0_1_1_2 - 0.00282186948853613*G0_0_1_2_1 + 0.0169312169312168*G0_0_1_2_2;
    A[67] = A[109] - 0.00931216931217012*G0_0_1_0_0 - 0.00973544973544998*G0_0_1_0_1 + 0.00846560846560821*G0_0_1_0_2 - 0.00973544973544998*G0_0_1_1_0 - 0.00931216931217054*G0_0_1_1_1 + 0.008465608465608*G0_0_1_1_2 + 0.0084656084656082*G0_0_1_2_0 + 0.008465608465608*G0_0_1_2_1 + 0.00423280423280406*G0_0_1_2_2 + 0.00931216931217013*G0_1_0_0_0 + 0.00973544973544998*G0_1_0_0_1 - 0.00846560846560821*G0_1_0_0_2 + 0.00973544973544998*G0_1_0_1_0 + 0.00931216931217053*G0_1_0_1_1 - 0.008465608465608*G0_1_0_1_2 - 0.00846560846560819*G0_1_0_2_0 - 0.008465608465608*G0_1_0_2_1 - 0.00423280423280403*G0_1_0_2_2;
    A[3] = A[45] - 0.00098765432098764*G0_0_1_0_1 + 0.000987654320987631*G0_0_1_0_2 - 0.000987654320987638*G0_0_1_1_0 + 0.0135449735449737*G0_0_1_1_1 - 0.0047971781305114*G0_0_1_1_2 + 0.000987654320987631*G0_0_1_2_0 - 0.0047971781305114*G0_0_1_2_1 - 0.00395061728395073*G0_0_1_2_2 + 0.000987654320987638*G0_1_0_0_1 - 0.000987654320987631*G0_1_0_0_2 + 0.000987654320987638*G0_1_0_1_0 - 0.0135449735449738*G0_1_0_1_1 + 0.0047971781305114*G0_1_0_1_2 - 0.000987654320987631*G0_1_0_2_0 + 0.00479717813051141*G0_1_0_2_1 + 0.00395061728395073*G0_1_0_2_2;
    A[11] = -A[3] - 0.131216931216931*G0_0_0_0_0 - 0.00888888888888889*G0_0_0_0_1 - 0.0136860670194003*G0_0_0_0_2 - 0.00888888888888889*G0_0_0_1_0 - 0.0324514991181658*G0_0_0_1_1 + 0.00183421516754849*G0_0_0_1_2 - 0.0136860670194003*G0_0_0_2_0 + 0.00183421516754849*G0_0_0_2_1 + 0.00197530864197539*G0_0_0_2_2 - 0.131216931216931*G0_1_0_0_0 - 0.00888888888888886*G0_1_0_0_1 - 0.0136860670194003*G0_1_0_0_2 - 0.00888888888888886*G0_1_0_1_0 - 0.0324514991181657*G0_1_0_1_1 + 0.00183421516754847*G0_1_0_1_2 - 0.0136860670194003*G0_1_0_2_0 + 0.00183421516754848*G0_1_0_2_1 + 0.00197530864197544*G0_1_0_2_2;
    A[115] = A[157] + 0.00423280423280309*G0_0_1_0_0 + 0.00846560846560824*G0_0_1_0_1 + 0.00846560846560807*G0_0_1_0_2 + 0.00846560846560824*G0_0_1_1_0 - 0.0093121693121694*G0_0_1_1_1 - 0.00973544973544971*G0_0_1_1_2 + 0.00846560846560807*G0_0_1_2_0 - 0.00973544973544971*G0_0_1_2_1 - 0.0093121693121693*G0_0_1_2_2 - 0.00423280423280303*G0_1_0_0_0 - 0.00846560846560824*G0_1_0_0_1 - 0.00846560846560805*G0_1_0_0_2 - 0.00846560846560823*G0_1_0_1_0 + 0.0093121693121694*G0_1_0_1_1 + 0.00973544973544972*G0_1_0_1_2 - 0.00846560846560806*G0_1_0_2_0 + 0.00973544973544971*G0_1_0_2_1 + 0.00931216931216931*G0_1_0_2_2;
    A[128] = -A[125] - 0.0225749559082891*G0_0_1_0_0 - 0.0112874779541445*G0_0_1_0_1 - 0.0451499118165784*G0_0_1_0_2 - 0.0112874779541445*G0_0_1_1_0 - 0.0225749559082889*G0_0_1_1_1 - 0.0451499118165783*G0_0_1_1_2 - 0.0451499118165784*G0_0_1_2_0 - 0.0451499118165783*G0_0_1_2_1 + 0.248324514991179*G0_0_1_2_2 + 0.316049382716048*G0_1_1_0_0 + 0.101587301587301*G0_1_1_0_1 + 0.158024691358024*G0_1_1_0_2 + 0.101587301587301*G0_1_1_1_0 + 0.0902998236331569*G0_1_1_1_1 + 0.056437389770723*G0_1_1_1_2 + 0.158024691358024*G0_1_1_2_0 + 0.056437389770723*G0_1_1_2_1 + 0.654673721340386*G0_1_1_2_2;
    A[104] = -A[128] + 0.0632098765432094*G0_0_0_0_0 + 0.0248324514991181*G0_0_0_0_1 + 0.137707231040564*G0_0_0_0_2 + 0.0248324514991181*G0_0_0_1_0 + 0.0902998236331566*G0_0_0_1_1 + 0.246067019400352*G0_0_0_1_2 + 0.137707231040564*G0_0_0_2_0 + 0.246067019400352*G0_0_0_2_1 + 1.94144620811286*G0_0_0_2_2 - 0.106102292768959*G0_0_1_0_0 - 0.029347442680776*G0_0_1_0_2 + 0.0925573192239851*G0_0_1_1_1 + 0.189629629629629*G0_0_1_1_2 - 0.029347442680776*G0_0_1_2_0 + 0.189629629629629*G0_0_1_2_1 + 1.21679012345678*G0_0_1_2_2 - 0.151252204585538*G0_1_0_0_0 - 0.0067724867724868*G0_1_0_0_1 - 0.0067724867724868*G0_1_0_1_0 + 0.0699823633156962*G0_1_0_1_1 + 0.173827160493826*G0_1_0_1_2 + 0.173827160493826*G0_1_0_2_1 + 1.27097001763668*G0_1_0_2_2 - 0.0225749559082901*G0_1_1_0_0 + 0.0203174603174601*G0_1_1_0_1 + 0.0925573192239858*G0_1_1_0_2 + 0.0203174603174601*G0_1_1_1_0 + 0.117389770723103*G0_1_1_1_1 + 0.200917107583773*G0_1_1_1_2 + 0.0925573192239858*G0_1_1_2_0 + 0.200917107583773*G0_1_1_2_1 + 1.2416225749559*G0_1_1_2_2;
    A[216] = A[104] - 0.045149911816579*G0_0_1_0_0 - 0.00677248677248667*G0_0_1_0_1 + 0.0293474426807759*G0_0_1_0_2 - 0.00677248677248666*G0_0_1_1_0 - 0.0225749559082889*G0_0_1_1_1 - 0.0158024691358025*G0_0_1_1_2 + 0.029347442680776*G0_0_1_2_0 - 0.0158024691358025*G0_0_1_2_1 + 0.0541798941798947*G0_0_1_2_2 + 0.045149911816579*G0_1_0_0_0 + 0.00677248677248667*G0_1_0_0_1 - 0.029347442680776*G0_1_0_0_2 + 0.00677248677248667*G0_1_0_1_0 + 0.0225749559082889*G0_1_0_1_1 + 0.0158024691358025*G0_1_0_1_2 - 0.029347442680776*G0_1_0_2_0 + 0.0158024691358025*G0_1_0_2_1 - 0.0541798941798945*G0_1_0_2_2;
    A[148] = A[216] - 0.316049382716048*G0_0_0_0_0 - 0.0564373897707228*G0_0_0_0_1 - 0.0564373897707229*G0_0_0_0_2 - 0.0564373897707228*G0_0_0_1_0 + 0.225749559082891*G0_0_0_1_1 - 0.0112874779541448*G0_0_0_1_2 - 0.0564373897707229*G0_0_0_2_0 - 0.0112874779541448*G0_0_0_2_1 - 0.338624338624338*G0_0_0_2_2 - 0.00451499118165761*G0_0_1_0_1 + 0.00451499118165783*G0_0_1_0_2 - 0.00451499118165761*G0_0_1_1_0 + 0.320564373897706*G0_0_1_1_1 + 0.00451499118165783*G0_0_1_2_0 - 0.320564373897706*G0_0_1_2_2 - 0.0406349206349201*G0_1_0_0_1 + 0.0406349206349206*G0_1_0_0_2 - 0.0406349206349201*G0_1_0_1_0 + 0.243809523809523*G0_1_0_1_1 + 0.0406349206349206*G0_1_0_2_0 - 0.243809523809522*G0_1_0_2_2 + 0.316049382716049*G0_1_1_0_0 + 0.056437389770723*G0_1_1_0_1 + 0.0564373897707229*G0_1_1_0_2 + 0.056437389770723*G0_1_1_1_0 + 0.338624338624337*G0_1_1_1_1 + 0.0112874779541447*G0_1_1_1_2 + 0.0564373897707229*G0_1_1_2_0 + 0.0112874779541447*G0_1_1_2_1 - 0.225749559082891*G0_1_1_2_2;
    A[204] = A[148] + 0.0451499118165779*G0_0_1_0_0 - 0.0293474426807758*G0_0_1_0_1 + 0.0067724867724868*G0_0_1_0_2 - 0.0293474426807758*G0_0_1_1_0 - 0.0541798941798939*G0_0_1_1_1 + 0.0158024691358026*G0_0_1_1_2 + 0.00677248677248679*G0_0_1_2_0 + 0.0158024691358026*G0_0_1_2_1 + 0.0225749559082893*G0_0_1_2_2 - 0.0451499118165779*G0_1_0_0_0 + 0.0293474426807758*G0_1_0_0_1 - 0.0067724867724868*G0_1_0_0_2 + 0.0293474426807758*G0_1_0_1_0 + 0.0541798941798939*G0_1_0_1_1 - 0.0158024691358026*G0_1_0_1_2 - 0.00677248677248679*G0_1_0_2_0 - 0.0158024691358026*G0_1_0_2_1 - 0.0225749559082893*G0_1_0_2_2;
    A[63] = -A[71] - 0.0474074074074072*G0_0_0_0_0 - 0.0310405643738976*G0_0_0_0_1 - 0.0936860670193999*G0_0_0_0_2 - 0.0310405643738976*G0_0_0_1_0 + 0.0112874779541441*G0_0_0_1_1 - 0.0112874779541447*G0_0_0_1_2 - 0.0936860670193999*G0_0_0_2_0 - 0.0112874779541447*G0_0_0_2_1 - 0.419894179894177*G0_0_0_2_2 - 0.0169312169312168*G0_1_0_0_0 + 0.0112874779541448*G0_1_0_0_1 + 0.019753086419753*G0_1_0_0_2 + 0.0112874779541448*G0_1_0_1_0 + 0.592592592592592*G0_1_0_1_1 + 0.191887125220458*G0_1_0_1_2 + 0.019753086419753*G0_1_0_2_0 + 0.191887125220458*G0_1_0_2_1 + 0.0959435626102291*G0_1_0_2_2;
    A[140] = -A[143] + 0.0767548500881832*G0_0_1_0_0 - 0.0248324514991179*G0_0_1_0_1 + 0.00451499118165789*G0_0_1_0_2 - 0.0248324514991179*G0_0_1_1_0 - 0.027089947089947*G0_0_1_1_1 - 0.00451499118165766*G0_0_1_1_2 + 0.00451499118165789*G0_0_1_2_0 - 0.00451499118165766*G0_0_1_2_1 - 0.194144620811286*G0_1_1_0_0 - 0.0632098765432094*G0_1_1_0_1 + 0.0203174603174603*G0_1_1_0_2 - 0.0632098765432094*G0_1_1_1_0 - 0.0406349206349205*G0_1_1_1_1 - 0.0090299823633156*G0_1_1_1_2 + 0.0203174603174603*G0_1_1_2_0 - 0.0090299823633156*G0_1_1_2_1;
    A[77] = -A[122] - 0.0663139329805993*G0_1_1_0_0 - 0.0331569664902997*G0_1_1_0_1 - 0.020458553791887*G0_1_1_0_2 - 0.0331569664902997*G0_1_1_1_0 - 0.0663139329805996*G0_1_1_1_1 - 0.0204585537918871*G0_1_1_1_2 - 0.020458553791887*G0_1_1_2_0 - 0.0204585537918871*G0_1_1_2_1 - 0.244091710758376*G0_1_1_2_2;
    A[171] = -A[51] - 0.194144620811286*G0_0_0_0_0 + 0.0203174603174603*G0_0_0_0_1 - 0.0632098765432093*G0_0_0_0_2 + 0.0203174603174603*G0_0_0_1_0 - 0.00902998236331574*G0_0_0_1_2 - 0.0632098765432093*G0_0_0_2_0 - 0.00902998236331574*G0_0_0_2_1 - 0.0406349206349201*G0_0_0_2_2 + 0.0767548500881844*G0_0_1_0_0 + 0.00451499118165796*G0_0_1_0_1 - 0.0248324514991179*G0_0_1_0_2 + 0.00451499118165796*G0_0_1_1_0 - 0.00451499118165784*G0_0_1_1_2 - 0.0248324514991179*G0_0_1_2_0 - 0.00451499118165784*G0_0_1_2_1 - 0.027089947089947*G0_0_1_2_2;
    A[101] = A[171] - 0.0677248677248683*G0_0_1_0_0 + 0.00225749559082874*G0_0_1_0_1 + 0.0203174603174601*G0_0_1_0_2 + 0.00225749559082875*G0_0_1_1_0 + 0.00902998236331558*G0_0_1_1_1 + 0.0203174603174601*G0_0_1_2_0 + 0.0135449735449735*G0_0_1_2_2 + 0.0677248677248683*G0_1_0_0_0 - 0.00225749559082875*G0_1_0_0_1 - 0.0203174603174601*G0_1_0_0_2 - 0.00225749559082875*G0_1_0_1_0 - 0.00902998236331558*G0_1_0_1_1 - 0.0203174603174601*G0_1_0_2_0 - 0.0135449735449735*G0_1_0_2_2;
    A[93] = -A[101] - 0.194144620811286*G0_0_0_0_0 + 0.0203174603174603*G0_0_0_0_1 - 0.0632098765432093*G0_0_0_0_2 + 0.0203174603174603*G0_0_0_1_0 - 0.00902998236331574*G0_0_0_1_2 - 0.0632098765432093*G0_0_0_2_0 - 0.00902998236331574*G0_0_0_2_1 - 0.0406349206349201*G0_0_0_2_2 + 0.0767548500881844*G0_1_0_0_0 + 0.00451499118165796*G0_1_0_0_1 - 0.0248324514991179*G0_1_0_0_2 + 0.00451499118165795*G0_1_0_1_0 - 0.00451499118165784*G0_1_0_1_2 - 0.0248324514991179*G0_1_0_2_0 - 0.00451499118165785*G0_1_0_2_1 - 0.027089947089947*G0_1_0_2_2;
    A[152] = A[40] - 0.00522045855379179*G0_0_1_0_0 + 0.000105820105820098*G0_0_1_0_2 + 0.00522045855379182*G0_0_1_1_1 - 0.00010582010582011*G0_0_1_1_2 + 0.000105820105820099*G0_0_1_2_0 - 0.00010582010582011*G0_0_1_2_1 + 0.00522045855379178*G0_1_0_0_0 - 0.000105820105820098*G0_1_0_0_2 - 0.00522045855379182*G0_1_0_1_1 + 0.000105820105820111*G0_1_0_1_2 - 0.0001058201058201*G0_1_0_2_0 + 0.00010582010582011*G0_1_0_2_1;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class laplacian_f2_p1_q4_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  laplacian_f2_p1_q4_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q4_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p1_q4_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p1_q4_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p1_q4_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p1_q4_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p1_q4_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p1_q4_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p1_q4_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p1_q4_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p1_q4_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
