// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F3_P1_Q4_TENSOR_H
#define __LAPLACIAN_F3_P1_Q4_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f3_p1_q4_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f3_p1_q4_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p1_q4_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 3;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f3_p1_q4_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class laplacian_f3_p1_q4_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f3_p1_q4_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p1_q4_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f3_p1_q4_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f3_p1_q4_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f3_p1_q4_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f3_p1_q4_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 3;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 2;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f3_p1_q4_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f3_p1_q4_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f3_p1_q4_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f3_p1_q4_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3*m.num_entities[1] + 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f3_p1_q4_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f3_p1_q4_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f3_p1_q4_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p1_q4_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    378
    // Number of operations (multiply-add pairs) for tensor contraction: 13986
    // Total number of operations (multiply-add pairs):                  14375
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[108] = -0.0166233766233765*G0_0_0_0_0_0 + 0.00107744107744108*G0_0_0_0_0_1 - 0.0217027417027416*G0_0_0_0_0_2 + 0.00107744107744108*G0_0_0_0_1_0 + 0.00256533589866922*G0_0_0_0_1_1 + 0.00143658810325478*G0_0_0_0_1_2 - 0.0217027417027416*G0_0_0_0_2_0 + 0.00143658810325478*G0_0_0_0_2_1 - 0.0322206188872854*G0_0_0_0_2_2 + 0.00107744107744108*G0_0_0_1_0_0 + 0.00256533589866922*G0_0_0_1_0_1 + 0.00143658810325478*G0_0_0_1_0_2 + 0.00256533589866922*G0_0_0_1_1_0 + 0.00415584415584425*G0_0_0_1_1_1 + 0.00343755010421686*G0_0_0_1_1_2 + 0.00143658810325478*G0_0_0_1_2_0 + 0.00343755010421686*G0_0_0_1_2_1 - 0.00318101651434978*G0_0_0_1_2_2 - 0.0217027417027416*G0_0_0_2_0_0 + 0.00143658810325478*G0_0_0_2_0_1 - 0.0322206188872854*G0_0_0_2_0_2 + 0.00143658810325478*G0_0_0_2_1_0 + 0.00343755010421686*G0_0_0_2_1_1 - 0.00318101651434978*G0_0_0_2_1_2 - 0.0322206188872854*G0_0_0_2_2_0 - 0.00318101651434978*G0_0_0_2_2_1 + 0.00153920153920122*G0_0_0_2_2_2 - 0.000179573512906838*G0_0_1_0_0_0 - 0.000179573512906862*G0_0_1_0_0_1 - 0.00359147025813692*G0_0_1_0_0_2 - 0.000179573512906862*G0_0_1_0_1_0 + 0.000359147025813609*G0_0_1_0_1_1 - 0.000743947410614075*G0_0_1_0_1_2 - 0.00359147025813692*G0_0_1_0_2_0 - 0.000743947410614075*G0_0_1_0_2_1 - 0.00525893859227193*G0_0_1_0_2_2 - 0.000179573512906862*G0_0_1_1_0_0 + 0.000359147025813609*G0_0_1_1_0_1 - 0.000743947410614075*G0_0_1_1_0_2 + 0.000359147025813609*G0_0_1_1_1_0 - 0.00795254128587544*G0_0_1_1_1_1 - 0.000872214205547534*G0_0_1_1_1_2 - 0.000743947410614075*G0_0_1_1_2_0 - 0.000872214205547534*G0_0_1_1_2_1 - 0.000641333974667327*G0_0_1_1_2_2 - 0.00359147025813692*G0_0_1_2_0_0 - 0.000743947410614075*G0_0_1_2_0_1 - 0.00525893859227192*G0_0_1_2_0_2 - 0.000743947410614075*G0_0_1_2_1_0 - 0.000872214205547534*G0_0_1_2_1_1 - 0.000641333974667327*G0_0_1_2_1_2 - 0.00525893859227193*G0_0_1_2_2_0 - 0.000641333974667327*G0_0_1_2_2_1 + 0.000820907487573767*G0_0_1_2_2_2 + 0.0155972422639086*G0_1_0_0_0_0 - 0.000359147025813714*G0_1_0_0_0_1 - 0.000359147025813714*G0_1_0_0_1_0 + 0.000359147025813693*G0_1_0_0_1_2 + 0.000359147025813693*G0_1_0_0_2_1 - 0.0155972422639089*G0_1_0_0_2_2 - 0.000359147025813713*G0_1_0_1_0_0 + 0.000359147025813693*G0_1_0_1_0_2 - 0.00425845759179089*G0_1_0_1_1_1 - 0.000820907487574096*G0_1_0_1_1_2 + 0.000359147025813693*G0_1_0_1_2_0 - 0.000820907487574095*G0_1_0_1_2_1 - 0.00292448292448286*G0_1_0_1_2_2 + 0.000359147025813693*G0_1_0_2_0_1 - 0.0155972422639089*G0_1_0_2_0_2 + 0.000359147025813693*G0_1_0_2_1_0 - 0.000820907487574096*G0_1_0_2_1_1 - 0.00292448292448286*G0_1_0_2_1_2 - 0.0155972422639089*G0_1_0_2_2_0 - 0.00292448292448286*G0_1_0_2_2_1 + 0.00328362995029643*G0_1_0_2_2_2 - 0.00100048100048108*G0_1_1_0_0_0 + 0.000461760461760432*G0_1_1_0_0_1 + 0.00166746833413499*G0_1_1_0_0_2 + 0.000461760461760432*G0_1_1_0_1_0 + 0.00123136123136116*G0_1_1_0_1_1 + 0.00166746833413499*G0_1_1_0_2_0 - 0.001667468334135*G0_1_1_0_2_2 + 0.000461760461760432*G0_1_1_1_0_0 + 0.00123136123136116*G0_1_1_1_0_1 + 0.00123136123136116*G0_1_1_1_1_0 - 0.00123136123136123*G0_1_1_1_1_2 - 0.00123136123136123*G0_1_1_1_2_1 - 0.00046176046176048*G0_1_1_1_2_2 + 0.00166746833413499*G0_1_1_2_0_0 - 0.001667468334135*G0_1_1_2_0_2 - 0.00123136123136123*G0_1_1_2_1_1 - 0.000461760461760479*G0_1_1_2_1_2 - 0.001667468334135*G0_1_1_2_2_0 - 0.000461760461760479*G0_1_1_2_2_1 + 0.0010004810004807*G0_1_1_2_2_2;
    A[181] = -0.0568478435145098*G0_0_0_0_0_0 - 0.00053872053872052*G0_0_0_0_0_1 - 0.0210614077280743*G0_0_0_0_0_2 - 0.00053872053872052*G0_0_0_0_1_0 + 0.00387365720699055*G0_0_0_0_1_1 - 0.00107744107744107*G0_0_0_0_1_2 - 0.0210614077280743*G0_0_0_0_2_0 - 0.00107744107744107*G0_0_0_0_2_1 - 0.0131345198011864*G0_0_0_0_2_2 - 0.00053872053872052*G0_0_0_1_0_0 + 0.00387365720699055*G0_0_0_1_0_1 - 0.00107744107744107*G0_0_0_1_0_2 + 0.00387365720699055*G0_0_0_1_1_0 + 0.0595157928491262*G0_0_0_1_1_1 + 0.00715728715728713*G0_0_0_1_1_2 - 0.00107744107744107*G0_0_0_1_2_0 + 0.00715728715728713*G0_0_0_1_2_1 - 0.00128266794933462*G0_0_0_1_2_2 - 0.0210614077280743*G0_0_0_2_0_0 - 0.00107744107744107*G0_0_0_2_0_1 - 0.0131345198011864*G0_0_0_2_0_2 - 0.00107744107744107*G0_0_0_2_1_0 + 0.00715728715728713*G0_0_0_2_1_1 - 0.00128266794933462*G0_0_0_2_1_2 - 0.0131345198011864*G0_0_0_2_2_0 - 0.00128266794933462*G0_0_0_2_2_1 - 0.00590027256693927*G0_0_0_2_2_2 + 0.0112361712361711*G0_1_0_0_0_0 + 0.00287317620650952*G0_1_0_0_0_1 - 0.00112874779541446*G0_1_0_0_0_2 + 0.00287317620650952*G0_1_0_0_1_0 - 0.00333493666826997*G0_1_0_0_1_1 - 0.000949174282507608*G0_1_0_0_1_2 - 0.00112874779541446*G0_1_0_0_2_0 - 0.000949174282507608*G0_1_0_0_2_1 - 0.00243706910373576*G0_1_0_0_2_2 + 0.00287317620650952*G0_1_0_1_0_0 - 0.00333493666826997*G0_1_0_1_0_1 - 0.000949174282507608*G0_1_0_1_0_2 - 0.00333493666826997*G0_1_0_1_1_0 + 0.00333493666827*G0_1_0_1_1_2 - 0.000949174282507608*G0_1_0_1_2_0 + 0.00333493666827*G0_1_0_1_2_1 - 0.000974827641494311*G0_1_0_1_2_2 - 0.00112874779541446*G0_1_0_2_0_0 - 0.000949174282507608*G0_1_0_2_0_1 - 0.00243706910373576*G0_1_0_2_0_2 - 0.000949174282507608*G0_1_0_2_1_0 + 0.00333493666827*G0_1_0_2_1_1 - 0.000974827641494311*G0_1_0_2_1_2 - 0.00243706910373576*G0_1_0_2_2_0 - 0.000974827641494311*G0_1_0_2_2_1 - 0.000538720538720568*G0_1_0_2_2_2;
    A[176] = 0.173416706750039*G0_0_0_0_0_0 + 0.0450815028592805*G0_0_0_0_0_1 + 0.0343412965635186*G0_0_0_0_0_2 + 0.0450815028592805*G0_0_0_0_1_0 + 0.0786703008925228*G0_0_0_0_1_1 + 0.0116979316979316*G0_0_0_0_1_2 + 0.0343412965635186*G0_0_0_0_2_0 + 0.0116979316979316*G0_0_0_0_2_1 + 0.0171706482817593*G0_0_0_0_2_2 + 0.0450815028592805*G0_0_0_1_0_0 + 0.0786703008925228*G0_0_0_1_0_1 + 0.0116979316979316*G0_0_0_1_0_2 + 0.0786703008925228*G0_0_0_1_1_0 + 0.804489337822668*G0_0_0_1_1_1 + 0.0649885094329535*G0_0_0_1_1_2 + 0.0116979316979316*G0_0_0_1_2_0 + 0.0649885094329535*G0_0_0_1_2_1 + 0.0136133825022713*G0_0_0_1_2_2 + 0.0343412965635186*G0_0_0_2_0_0 + 0.0116979316979316*G0_0_0_2_0_1 + 0.0171706482817593*G0_0_0_2_0_2 + 0.0116979316979316*G0_0_0_2_1_0 + 0.0649885094329535*G0_0_0_2_1_1 + 0.0136133825022713*G0_0_0_2_1_2 + 0.0171706482817593*G0_0_0_2_2_0 + 0.0136133825022713*G0_0_0_2_2_1 + 0.0188808722142054*G0_0_0_2_2_2 - 0.00513067179733856*G0_0_1_0_0_0 - 0.00530169419058306*G0_0_1_0_0_1 - 0.000855111966223082*G0_0_1_0_0_2 - 0.00530169419058306*G0_0_1_0_1_0 + 0.0157340601785046*G0_0_1_0_1_1 + 0.000855111966223072*G0_0_1_0_1_2 - 0.000855111966223082*G0_0_1_0_2_0 + 0.000855111966223072*G0_0_1_0_2_1 - 0.00530169419058306*G0_0_1_1_0_0 + 0.0157340601785046*G0_0_1_1_0_1 + 0.000855111966223072*G0_0_1_1_0_2 + 0.0157340601785046*G0_0_1_1_1_0 + 0.817829084495747*G0_0_1_1_1_1 + 0.0581476137031689*G0_0_1_1_1_2 + 0.000855111966223072*G0_0_1_1_2_0 + 0.0581476137031689*G0_0_1_1_2_1 + 0.00872214205547533*G0_0_1_1_2_2 - 0.000855111966223082*G0_0_1_2_0_0 + 0.000855111966223071*G0_0_1_2_0_1 + 0.000855111966223071*G0_0_1_2_1_0 + 0.0581476137031689*G0_0_1_2_1_1 + 0.00872214205547533*G0_0_1_2_1_2 + 0.00872214205547533*G0_0_1_2_2_1 + 0.00256533589866922*G0_0_1_2_2_2 - 0.00513067179733856*G0_1_0_0_0_0 - 0.00530169419058306*G0_1_0_0_0_1 - 0.000855111966223082*G0_1_0_0_0_2 - 0.00530169419058306*G0_1_0_0_1_0 + 0.0157340601785046*G0_1_0_0_1_1 + 0.000855111966223072*G0_1_0_0_1_2 - 0.000855111966223082*G0_1_0_0_2_0 + 0.000855111966223071*G0_1_0_0_2_1 - 0.00530169419058306*G0_1_0_1_0_0 + 0.0157340601785046*G0_1_0_1_0_1 + 0.000855111966223071*G0_1_0_1_0_2 + 0.0157340601785046*G0_1_0_1_1_0 + 0.817829084495747*G0_1_0_1_1_1 + 0.0581476137031689*G0_1_0_1_1_2 + 0.000855111966223071*G0_1_0_1_2_0 + 0.0581476137031689*G0_1_0_1_2_1 + 0.00872214205547533*G0_1_0_1_2_2 - 0.000855111966223082*G0_1_0_2_0_0 + 0.000855111966223071*G0_1_0_2_0_1 + 0.000855111966223071*G0_1_0_2_1_0 + 0.0581476137031689*G0_1_0_2_1_1 + 0.00872214205547533*G0_1_0_2_1_2 + 0.00872214205547533*G0_1_0_2_2_1 + 0.00256533589866922*G0_1_0_2_2_2 + 0.00513067179733845*G0_1_1_0_0_0 + 0.0157340601785045*G0_1_1_0_0_1 + 0.00171022393244614*G0_1_1_0_0_2 + 0.0157340601785045*G0_1_1_0_1_0 + 0.100561167227833*G0_1_1_0_1_1 + 0.00786703008925227*G0_1_1_0_1_2 + 0.00171022393244614*G0_1_1_0_2_0 + 0.00786703008925226*G0_1_1_0_2_1 + 0.00171022393244614*G0_1_1_0_2_2 + 0.0157340601785045*G0_1_1_1_0_0 + 0.100561167227833*G0_1_1_1_0_1 + 0.00786703008925227*G0_1_1_1_0_2 + 0.100561167227833*G0_1_1_1_1_0 + 1.33397466730799*G0_1_1_1_1_1 + 0.100561167227833*G0_1_1_1_1_2 + 0.00786703008925227*G0_1_1_1_2_0 + 0.100561167227833*G0_1_1_1_2_1 + 0.0157340601785045*G0_1_1_1_2_2 + 0.00171022393244614*G0_1_1_2_0_0 + 0.00786703008925226*G0_1_1_2_0_1 + 0.00171022393244614*G0_1_1_2_0_2 + 0.00786703008925226*G0_1_1_2_1_0 + 0.100561167227833*G0_1_1_2_1_1 + 0.0157340601785045*G0_1_1_2_1_2 + 0.00171022393244614*G0_1_1_2_2_0 + 0.0157340601785045*G0_1_1_2_2_1 + 0.00513067179733843*G0_1_1_2_2_2;
    A[21] = 0.0288985088985087*G0_0_0_0_0_0 - 0.00153492597937041*G0_0_0_0_0_1 + 0.00847415958527063*G0_0_0_0_0_2 - 0.00153492597937041*G0_0_0_0_1_0 - 0.00120143231254341*G0_0_0_0_1_1 - 0.000226604671049116*G0_0_0_0_1_2 + 0.00847415958527063*G0_0_0_0_2_0 - 0.000226604671049116*G0_0_0_0_2_1 + 0.00332210998877662*G0_0_0_0_2_2 - 0.00153492597937042*G0_0_0_1_0_0 - 0.00120143231254341*G0_0_0_1_0_1 - 0.000226604671049116*G0_0_0_1_0_2 - 0.00120143231254341*G0_0_0_1_1_0 - 0.0100689434022766*G0_0_0_1_1_1 - 0.00142803698359253*G0_0_0_1_1_2 - 0.000226604671049116*G0_0_0_1_2_0 - 0.00142803698359253*G0_0_0_1_2_1 - 0.000320666987333647*G0_0_0_1_2_2 + 0.00847415958527063*G0_0_0_2_0_0 - 0.000226604671049116*G0_0_0_2_0_1 + 0.00332210998877662*G0_0_0_2_0_2 - 0.000226604671049116*G0_0_0_2_1_0 - 0.00142803698359253*G0_0_0_2_1_1 - 0.000320666987333647*G0_0_0_2_1_2 + 0.00332210998877662*G0_0_0_2_2_0 - 0.000320666987333647*G0_0_0_2_2_1 + 0.00292448292448288*G0_0_0_2_2_2 - 0.0167644700978036*G0_0_1_0_0_0 + 0.000333493666826986*G0_0_1_0_0_1 + 0.00288600288600285*G0_0_1_0_0_2 + 0.000333493666826986*G0_0_1_0_1_0 + 0.000714018491796271*G0_0_1_0_1_1 - 5.98578376356166e-05*G0_0_1_0_1_2 + 0.00288600288600285*G0_0_1_0_2_0 - 5.98578376356167e-05*G0_0_1_0_2_1 + 0.00197103308214417*G0_0_1_0_2_2 + 0.000333493666826986*G0_0_1_1_0_0 + 0.000714018491796271*G0_0_1_1_0_1 - 5.98578376356166e-05*G0_0_1_1_0_2 + 0.000714018491796271*G0_0_1_1_1_0 - 0.000714018491796262*G0_0_1_1_1_2 - 5.98578376356166e-05*G0_0_1_1_2_0 - 0.000714018491796262*G0_0_1_1_2_1 - 0.000213777991555759*G0_0_1_1_2_2 + 0.00288600288600285*G0_0_1_2_0_0 - 5.98578376356167e-05*G0_0_1_2_0_1 + 0.00197103308214417*G0_0_1_2_0_2 - 5.98578376356167e-05*G0_0_1_2_1_0 - 0.000714018491796262*G0_0_1_2_1_1 - 0.000213777991555759*G0_0_1_2_1_2 + 0.00197103308214417*G0_0_1_2_2_0 - 0.000213777991555759*G0_0_1_2_2_1 + 0.00219336219336221*G0_0_1_2_2_2;
    A[52] = A[108] + 0.0157768157768154*G0_0_1_0_0_0 - 0.000179573512906852*G0_0_1_0_0_1 + 0.00359147025813685*G0_0_1_0_0_2 - 0.000179573512906851*G0_0_1_0_1_0 - 0.000359147025813626*G0_0_1_0_1_1 + 0.00110309443642777*G0_0_1_0_1_2 + 0.00359147025813685*G0_0_1_0_2_0 + 0.00110309443642777*G0_0_1_0_2_1 - 0.010338303671637*G0_0_1_0_2_2 - 0.000179573512906851*G0_0_1_1_0_0 - 0.000359147025813626*G0_0_1_1_0_1 + 0.00110309443642777*G0_0_1_1_0_2 - 0.000359147025813626*G0_0_1_1_1_0 + 0.00369408369408455*G0_0_1_1_1_1 + 0.00110309443642777*G0_0_1_1_2_0 - 0.00228314894981554*G0_0_1_1_2_2 + 0.00359147025813685*G0_0_1_2_0_0 + 0.00110309443642777*G0_0_1_2_0_1 - 0.010338303671637*G0_0_1_2_0_2 + 0.00110309443642777*G0_0_1_2_1_0 - 0.00228314894981554*G0_0_1_2_1_2 - 0.010338303671637*G0_0_1_2_2_0 - 0.00228314894981554*G0_0_1_2_2_1 + 0.00246272246272266*G0_0_1_2_2_2 - 0.0157768157768154*G0_1_0_0_0_0 + 0.000179573512906852*G0_1_0_0_0_1 - 0.00359147025813685*G0_1_0_0_0_2 + 0.000179573512906852*G0_1_0_0_1_0 + 0.000359147025813625*G0_1_0_0_1_1 - 0.00110309443642777*G0_1_0_0_1_2 - 0.00359147025813685*G0_1_0_0_2_0 - 0.00110309443642777*G0_1_0_0_2_1 + 0.010338303671637*G0_1_0_0_2_2 + 0.000179573512906851*G0_1_0_1_0_0 + 0.000359147025813625*G0_1_0_1_0_1 - 0.00110309443642777*G0_1_0_1_0_2 + 0.000359147025813625*G0_1_0_1_1_0 - 0.00369408369408455*G0_1_0_1_1_1 - 0.00110309443642777*G0_1_0_1_2_0 + 0.00228314894981554*G0_1_0_1_2_2 - 0.00359147025813685*G0_1_0_2_0_0 - 0.00110309443642777*G0_1_0_2_0_1 + 0.010338303671637*G0_1_0_2_0_2 - 0.00110309443642777*G0_1_0_2_1_0 + 0.00228314894981554*G0_1_0_2_1_2 + 0.010338303671637*G0_1_0_2_2_0 + 0.00228314894981554*G0_1_0_2_2_1 - 0.00246272246272266*G0_1_0_2_2_2;
    A[35] = 0.000192400192400197*G0_1_0_0_0_0 + 6.4133397466737e-05*G0_1_0_0_0_1 + 0.00397627064293729*G0_1_0_0_0_2 + 6.4133397466737e-05*G0_1_0_0_1_0 + 6.41333974667396e-05*G0_1_0_0_1_1 + 0.00198813532146865*G0_1_0_0_1_2 + 0.00397627064293729*G0_1_0_0_2_0 + 0.00198813532146865*G0_1_0_0_2_1 + 0.0335417668751*G0_1_0_0_2_2 + 6.4133397466737e-05*G0_1_0_1_0_0 + 6.41333974667396e-05*G0_1_0_1_0_1 + 0.00198813532146865*G0_1_0_1_0_2 + 6.41333974667396e-05*G0_1_0_1_1_0 + 0.000192400192400221*G0_1_0_1_1_1 + 0.00397627064293729*G0_1_0_1_1_2 + 0.00198813532146865*G0_1_0_1_2_0 + 0.00397627064293729*G0_1_0_1_2_1 + 0.0335417668751*G0_1_0_1_2_2 + 0.00397627064293729*G0_1_0_2_0_0 + 0.00198813532146865*G0_1_0_2_0_1 + 0.0335417668751*G0_1_0_2_0_2 + 0.00198813532146865*G0_1_0_2_1_0 + 0.0039762706429373*G0_1_0_2_1_1 + 0.0335417668751*G0_1_0_2_1_2 + 0.0335417668751*G0_1_0_2_2_0 + 0.0335417668751*G0_1_0_2_2_1 + 0.541029341029338*G0_1_0_2_2_2 - 0.00886323552990213*G0_1_1_0_0_0 - 0.00590882368660143*G0_1_1_0_0_1 - 0.00074822297044519*G0_1_1_0_0_2 - 0.00590882368660143*G0_1_1_0_1_0 - 0.00886323552990216*G0_1_1_0_1_1 - 0.000748222970445189*G0_1_1_0_1_2 - 0.00074822297044519*G0_1_1_0_2_0 - 0.000748222970445189*G0_1_1_0_2_1 + 0.00784565229009669*G0_1_1_0_2_2 - 0.00590882368660143*G0_1_1_1_0_0 - 0.00886323552990216*G0_1_1_1_0_1 - 0.000748222970445189*G0_1_1_1_0_2 - 0.00886323552990216*G0_1_1_1_1_0 - 0.0354529421196088*G0_1_1_1_1_1 - 0.00224466891133557*G0_1_1_1_1_2 - 0.00074822297044519*G0_1_1_1_2_0 - 0.00224466891133558*G0_1_1_1_2_1 + 0.0156913045801934*G0_1_1_1_2_2 - 0.00074822297044519*G0_1_1_2_0_0 - 0.000748222970445189*G0_1_1_2_0_1 + 0.00784565229009669*G0_1_1_2_0_2 - 0.000748222970445189*G0_1_1_2_1_0 - 0.00224466891133557*G0_1_1_2_1_1 + 0.0156913045801934*G0_1_1_2_1_2 + 0.00784565229009669*G0_1_1_2_2_0 + 0.0156913045801934*G0_1_1_2_2_1 + 0.158473625140291*G0_1_1_2_2_2;
    A[26] = -0.0356453423120088*G0_0_0_0_0_0 - 0.00622093955427287*G0_0_0_0_0_1 - 0.00892736892736887*G0_0_0_0_0_2 - 0.00622093955427287*G0_0_0_0_1_0 - 0.0178504622949067*G0_0_0_0_1_1 - 0.00273635829191384*G0_0_0_0_1_2 - 0.00892736892736887*G0_0_0_0_2_0 - 0.00273635829191384*G0_0_0_0_2_1 - 0.00597295708406815*G0_0_0_0_2_2 - 0.00622093955427287*G0_0_0_1_0_0 - 0.0178504622949067*G0_0_0_1_0_1 - 0.00273635829191384*G0_0_0_1_0_2 - 0.0178504622949067*G0_0_0_1_1_0 - 0.382555715889047*G0_0_0_1_1_1 - 0.0256961145850033*G0_0_0_1_1_2 - 0.00273635829191384*G0_0_0_1_2_0 - 0.0256961145850033*G0_0_0_1_2_1 - 0.00472449361338248*G0_0_0_1_2_2 - 0.00892736892736887*G0_0_0_2_0_0 - 0.00273635829191384*G0_0_0_2_0_1 - 0.00597295708406815*G0_0_0_2_0_2 - 0.00273635829191384*G0_0_0_2_1_0 - 0.0256961145850033*G0_0_0_2_1_1 - 0.00472449361338248*G0_0_0_2_1_2 - 0.00597295708406815*G0_0_0_2_2_0 - 0.00472449361338248*G0_0_0_2_2_1 - 0.00905563572230233*G0_0_0_2_2_2 - 0.000192400192400167*G0_0_1_0_0_0 - 0.00397627064293728*G0_0_1_0_0_1 - 6.41333974667284e-05*G0_0_1_0_0_2 - 0.00397627064293728*G0_0_1_0_1_0 - 0.0335417668751*G0_0_1_0_1_1 - 0.00198813532146864*G0_0_1_0_1_2 - 6.41333974667285e-05*G0_0_1_0_2_0 - 0.00198813532146864*G0_0_1_0_2_1 - 6.41333974667308e-05*G0_0_1_0_2_2 - 0.00397627064293728*G0_0_1_1_0_0 - 0.0335417668751*G0_0_1_1_0_1 - 0.00198813532146864*G0_0_1_1_0_2 - 0.0335417668751*G0_0_1_1_1_0 - 0.541029341029338*G0_0_1_1_1_1 - 0.0335417668751*G0_0_1_1_1_2 - 0.00198813532146864*G0_0_1_1_2_0 - 0.0335417668751*G0_0_1_1_2_1 - 0.00397627064293729*G0_0_1_1_2_2 - 6.41333974667285e-05*G0_0_1_2_0_0 - 0.00198813532146864*G0_0_1_2_0_1 - 6.41333974667308e-05*G0_0_1_2_0_2 - 0.00198813532146864*G0_0_1_2_1_0 - 0.0335417668751*G0_0_1_2_1_1 - 0.00397627064293728*G0_0_1_2_1_2 - 6.41333974667309e-05*G0_0_1_2_2_0 - 0.00397627064293728*G0_0_1_2_2_1 - 0.000192400192400197*G0_0_1_2_2_2;
    A[158] = -A[52] - 0.0156228956228954*G0_0_0_0_0_0 - 0.000590027256693905*G0_0_0_0_0_1 - 0.022164502164502*G0_0_0_0_0_2 - 0.000590027256693906*G0_0_0_0_1_0 + 0.00423280423280418*G0_0_0_0_1_1 + 0.00143658810325478*G0_0_0_0_1_2 - 0.022164502164502*G0_0_0_0_2_0 + 0.00143658810325478*G0_0_0_0_2_1 - 0.0334519801186466*G0_0_0_0_2_2 - 0.000590027256693905*G0_0_0_1_0_0 + 0.00423280423280418*G0_0_0_1_0_1 + 0.00143658810325478*G0_0_0_1_0_2 + 0.00423280423280418*G0_0_0_1_1_0 + 0.0031553631553632*G0_0_0_1_1_1 + 0.0038993105659773*G0_0_0_1_1_2 + 0.00143658810325478*G0_0_0_1_2_0 + 0.0038993105659773*G0_0_0_1_2_1 - 0.00194965528298852*G0_0_0_1_2_2 - 0.022164502164502*G0_0_0_2_0_0 + 0.00143658810325478*G0_0_0_2_0_1 - 0.0334519801186466*G0_0_0_2_0_2 + 0.00143658810325478*G0_0_0_2_1_0 + 0.0038993105659773*G0_0_0_2_1_1 - 0.00194965528298852*G0_0_0_2_1_2 - 0.0334519801186466*G0_0_0_2_2_0 - 0.00194965528298852*G0_0_0_2_2_1 + 0.00153920153920182*G0_0_0_2_2_2 + 0.0133140933140926*G0_0_1_0_0_0 + 0.0135706269039601*G0_0_1_0_0_1 + 0.00246272246272235*G0_0_1_0_0_2 + 0.0135706269039601*G0_0_1_0_1_0 + 0.00166746833413494*G0_0_1_0_1_1 + 0.00246272246272235*G0_0_1_0_2_0 - 0.0160076960076959*G0_0_1_0_2_2 + 0.0135706269039601*G0_0_1_1_0_0 + 0.00166746833413494*G0_0_1_1_0_1 + 0.00166746833413494*G0_0_1_1_1_0 - 0.0208561808561806*G0_0_1_1_1_1 - 0.00169312169312163*G0_0_1_1_2_2 + 0.00246272246272235*G0_0_1_2_0_0 - 0.0160076960076959*G0_0_1_2_0_2 - 0.00169312169312163*G0_0_1_2_1_2 - 0.0160076960076959*G0_0_1_2_2_0 - 0.00169312169312163*G0_0_1_2_2_1 + 0.0075420875420878*G0_0_1_2_2_2 + 0.00341189674523*G0_1_0_0_0_1 - 0.00341189674523009*G0_1_0_0_0_2 + 0.00341189674523*G0_1_0_0_1_0 + 0.00561808561808543*G0_1_0_0_1_1 - 0.00341189674523009*G0_1_0_0_2_0 - 0.00561808561808566*G0_1_0_0_2_2 + 0.00341189674523*G0_1_0_1_0_0 + 0.00561808561808543*G0_1_0_1_0_1 + 0.00561808561808543*G0_1_0_1_1_0 - 0.00877344877344963*G0_1_0_1_1_1 - 0.000230880230880254*G0_1_0_1_1_2 - 0.000230880230880253*G0_1_0_1_2_1 + 0.000230880230880176*G0_1_0_1_2_2 - 0.00341189674523009*G0_1_0_2_0_0 - 0.00561808561808566*G0_1_0_2_0_2 - 0.000230880230880254*G0_1_0_2_1_1 + 0.000230880230880175*G0_1_0_2_1_2 - 0.00561808561808566*G0_1_0_2_2_0 + 0.000230880230880175*G0_1_0_2_2_1 + 0.00877344877344809*G0_1_0_2_2_2 - 0.00256533589866952*G0_1_1_0_0_0 - 0.0125701459034792*G0_1_1_0_0_1 + 0.00159050825717493*G0_1_1_0_0_2 - 0.0125701459034792*G0_1_1_0_1_0 - 0.0152124418791085*G0_1_1_0_1_1 + 0.00182138848805515*G0_1_1_0_1_2 + 0.00159050825717493*G0_1_1_0_2_0 + 0.00182138848805515*G0_1_1_0_2_1 + 0.00223184223184227*G0_1_1_0_2_2 - 0.0125701459034792*G0_1_1_1_0_0 - 0.0152124418791085*G0_1_1_1_0_1 + 0.00182138848805515*G0_1_1_1_0_2 - 0.0152124418791085*G0_1_1_1_1_0 - 0.03304152637486*G0_1_1_1_1_1 + 0.000846560846560809*G0_1_1_1_1_2 + 0.00182138848805515*G0_1_1_1_2_0 + 0.000846560846560809*G0_1_1_1_2_1 + 0.00297578964245627*G0_1_1_1_2_2 + 0.00159050825717493*G0_1_1_2_0_0 + 0.00182138848805515*G0_1_1_2_0_1 + 0.00223184223184227*G0_1_1_2_0_2 + 0.00182138848805515*G0_1_1_2_1_0 + 0.000846560846560809*G0_1_1_2_1_1 + 0.00297578964245627*G0_1_1_2_1_2 + 0.00223184223184227*G0_1_1_2_2_0 + 0.00297578964245627*G0_1_1_2_2_1 + 0.0173673240339904*G0_1_1_2_2_2;
    A[135] = A[26] - 0.346910373577039*G0_0_0_0_0_0 - 0.0116295227406338*G0_0_0_0_0_1 - 0.0167687456576345*G0_0_0_0_0_2 - 0.0116295227406338*G0_0_0_0_1_0 + 0.0116295227406338*G0_0_0_0_1_1 - 0.0167687456576345*G0_0_0_0_2_0 + 0.00124846347068567*G0_0_0_0_2_2 - 0.0116295227406338*G0_0_0_1_0_0 + 0.0116295227406338*G0_0_0_1_0_1 + 0.0116295227406338*G0_0_0_1_1_0 + 0.346910373577039*G0_0_0_1_1_1 + 0.0167687456576345*G0_0_0_1_1_2 + 0.0167687456576345*G0_0_0_1_2_1 - 0.00124846347068567*G0_0_0_1_2_2 - 0.0167687456576345*G0_0_0_2_0_0 + 0.00124846347068567*G0_0_0_2_0_2 + 0.0167687456576345*G0_0_0_2_1_1 - 0.00124846347068567*G0_0_0_2_1_2 + 0.00124846347068567*G0_0_0_2_2_0 - 0.00124846347068567*G0_0_0_2_2_1 - 0.382363315696648*G0_0_1_0_0_0 - 0.0138741916519694*G0_0_1_0_0_1 - 0.0256319811875366*G0_0_1_0_0_2 - 0.0138741916519694*G0_0_1_0_1_0 + 0.0273208273208272*G0_0_1_0_1_1 - 0.000748222970445196*G0_0_1_0_1_2 - 0.0256319811875366*G0_0_1_0_2_0 - 0.000748222970445196*G0_0_1_0_2_1 - 0.00466036021591575*G0_0_1_0_2_2 - 0.0138741916519694*G0_0_1_1_0_0 + 0.0273208273208272*G0_0_1_1_0_1 - 0.000748222970445196*G0_0_1_1_0_2 + 0.0273208273208272*G0_0_1_1_1_0 + 0.505383998717329*G0_0_1_1_1_1 + 0.0246143979477312*G0_0_1_1_1_2 - 0.000748222970445196*G0_0_1_1_2_0 + 0.0246143979477312*G0_0_1_1_2_1 - 0.00199668644113086*G0_0_1_1_2_2 - 0.0256319811875366*G0_0_1_2_0_0 - 0.000748222970445196*G0_0_1_2_0_1 - 0.00466036021591575*G0_0_1_2_0_2 - 0.000748222970445196*G0_0_1_2_1_0 + 0.0246143979477312*G0_0_1_2_1_1 - 0.00199668644113087*G0_0_1_2_1_2 - 0.00466036021591575*G0_0_1_2_2_0 - 0.00199668644113087*G0_0_1_2_2_1 - 0.00886323552990212*G0_0_1_2_2_2 + 0.158473625140291*G0_1_0_0_0_0 + 0.0156913045801934*G0_1_0_0_0_1 + 0.00784565229009668*G0_1_0_0_0_2 + 0.0156913045801934*G0_1_0_0_1_0 - 0.00224466891133558*G0_1_0_0_1_1 - 0.000748222970445195*G0_1_0_0_1_2 + 0.00784565229009668*G0_1_0_0_2_0 - 0.000748222970445195*G0_1_0_0_2_1 - 0.000748222970445194*G0_1_0_0_2_2 + 0.0156913045801934*G0_1_0_1_0_0 - 0.00224466891133558*G0_1_0_1_0_1 - 0.000748222970445195*G0_1_0_1_0_2 - 0.00224466891133558*G0_1_0_1_1_0 - 0.0354529421196086*G0_1_0_1_1_1 - 0.00886323552990215*G0_1_0_1_1_2 - 0.000748222970445195*G0_1_0_1_2_0 - 0.00886323552990215*G0_1_0_1_2_1 - 0.00590882368660143*G0_1_0_1_2_2 + 0.00784565229009668*G0_1_0_2_0_0 - 0.000748222970445195*G0_1_0_2_0_1 - 0.000748222970445194*G0_1_0_2_0_2 - 0.000748222970445195*G0_1_0_2_1_0 - 0.00886323552990215*G0_1_0_2_1_1 - 0.00590882368660143*G0_1_0_2_1_2 - 0.000748222970445194*G0_1_0_2_2_0 - 0.00590882368660143*G0_1_0_2_2_1 - 0.00886323552990214*G0_1_0_2_2_2 + 0.158473625140291*G0_1_1_0_0_0 + 0.0156913045801934*G0_1_1_0_0_1 + 0.00784565229009667*G0_1_1_0_0_2 + 0.0156913045801934*G0_1_1_0_1_0 - 0.00224466891133555*G0_1_1_0_1_1 - 0.000748222970445194*G0_1_1_0_1_2 + 0.00784565229009667*G0_1_1_0_2_0 - 0.000748222970445194*G0_1_1_0_2_1 - 0.000748222970445198*G0_1_1_0_2_2 + 0.0156913045801934*G0_1_1_1_0_0 - 0.00224466891133555*G0_1_1_1_0_1 - 0.000748222970445194*G0_1_1_1_0_2 - 0.00224466891133555*G0_1_1_1_1_0 - 0.0354529421196084*G0_1_1_1_1_1 - 0.00886323552990213*G0_1_1_1_1_2 - 0.000748222970445194*G0_1_1_1_2_0 - 0.00886323552990213*G0_1_1_1_2_1 - 0.00590882368660143*G0_1_1_1_2_2 + 0.00784565229009667*G0_1_1_2_0_0 - 0.000748222970445194*G0_1_1_2_0_1 - 0.000748222970445198*G0_1_1_2_0_2 - 0.000748222970445194*G0_1_1_2_1_0 - 0.00886323552990213*G0_1_1_2_1_1 - 0.00590882368660143*G0_1_1_2_1_2 - 0.000748222970445197*G0_1_1_2_2_0 - 0.00590882368660143*G0_1_1_2_2_1 - 0.00886323552990215*G0_1_1_2_2_2;
    A[211] = A[181] + 0.0514862914862911*G0_0_0_0_0_0 + 0.000230880230880212*G0_0_0_0_0_1 + 0.0103639570306236*G0_0_0_0_0_2 + 0.000230880230880212*G0_0_0_0_1_0 + 0.000949174282507604*G0_0_0_0_1_2 + 0.0103639570306236*G0_0_0_0_2_0 + 0.000949174282507604*G0_0_0_0_2_1 - 0.00679814013147344*G0_0_0_0_2_2 + 0.000230880230880211*G0_0_0_1_0_0 + 0.000949174282507604*G0_0_0_1_0_2 + 0.000949174282507604*G0_0_0_1_2_0 - 0.00212922879589542*G0_0_0_1_2_2 + 0.0103639570306236*G0_0_0_2_0_0 + 0.000949174282507604*G0_0_0_2_0_1 - 0.00679814013147344*G0_0_0_2_0_2 + 0.000949174282507604*G0_0_0_2_1_0 - 0.00212922879589542*G0_0_0_2_1_2 - 0.00679814013147344*G0_0_0_2_2_0 - 0.00212922879589542*G0_0_0_2_2_1 - 0.0621837421837417*G0_0_0_2_2_2 - 0.0106974506974505*G0_1_0_0_0_0 - 0.00189834856501521*G0_1_0_0_0_1 + 0.00356581689915023*G0_1_0_0_0_2 - 0.00189834856501521*G0_1_0_0_1_0 + 0.00189834856501522*G0_1_0_0_1_2 + 0.00356581689915023*G0_1_0_0_2_0 + 0.00189834856501521*G0_1_0_0_2_1 + 0.00356581689915022*G0_1_0_0_2_2 - 0.00189834856501521*G0_1_0_1_0_0 + 0.00189834856501522*G0_1_0_1_0_2 + 0.00189834856501522*G0_1_0_1_2_0 - 0.0018983485650152*G0_1_0_1_2_2 + 0.00356581689915023*G0_1_0_2_0_0 + 0.00189834856501521*G0_1_0_2_0_1 + 0.00356581689915022*G0_1_0_2_0_2 + 0.00189834856501522*G0_1_0_2_1_0 - 0.0018983485650152*G0_1_0_2_1_2 + 0.00356581689915022*G0_1_0_2_2_0 - 0.0018983485650152*G0_1_0_2_2_1 - 0.0106974506974506*G0_1_0_2_2_2;
    A[16] = 0.00821709155042485*G0_0_0_0_0_0 + 0.0025359414248303*G0_0_0_0_0_1 + 0.00273903051680828*G0_0_0_0_0_2 + 0.0025359414248303*G0_0_0_0_1_0 + 0.0138768638768638*G0_0_0_0_1_1 + 0.00126797071241515*G0_0_0_0_1_2 + 0.00273903051680828*G0_0_0_0_2_0 + 0.00126797071241515*G0_0_0_0_2_1 + 0.00273903051680828*G0_0_0_0_2_2 + 0.0025359414248303*G0_0_0_1_0_0 + 0.0138768638768638*G0_0_0_1_0_1 + 0.00126797071241515*G0_0_0_1_0_2 + 0.0138768638768638*G0_0_0_1_1_0 + 0.234062850729516*G0_0_0_1_1_1 + 0.0138768638768638*G0_0_0_1_1_2 + 0.00126797071241515*G0_0_0_1_2_0 + 0.0138768638768638*G0_0_0_1_2_1 + 0.0025359414248303*G0_0_0_1_2_2 + 0.00273903051680828*G0_0_0_2_0_0 + 0.00126797071241515*G0_0_0_2_0_1 + 0.00273903051680828*G0_0_0_2_0_2 + 0.00126797071241515*G0_0_0_2_1_0 + 0.0138768638768638*G0_0_0_2_1_1 + 0.0025359414248303*G0_0_0_2_1_2 + 0.00273903051680828*G0_0_0_2_2_0 + 0.0025359414248303*G0_0_0_2_2_1 + 0.00821709155042483*G0_0_0_2_2_2;
    A[36] = -0.0120955587622254*G0_1_0_0_0_0 - 0.00153492597937042*G0_1_0_0_0_1 - 0.00527604083159634*G0_1_0_0_0_2 - 0.00153492597937042*G0_1_0_0_1_0 - 0.000226604671049128*G0_1_0_0_1_1 - 0.00120143231254342*G0_1_0_0_1_2 - 0.00527604083159634*G0_1_0_0_2_0 - 0.00120143231254342*G0_1_0_0_2_1 - 0.00339907006573669*G0_1_0_0_2_2 - 0.00153492597937042*G0_1_0_1_0_0 - 0.000226604671049128*G0_1_0_1_0_1 - 0.00120143231254342*G0_1_0_1_0_2 - 0.000226604671049128*G0_1_0_1_1_0 - 0.000320666987333709*G0_1_0_1_1_1 - 0.00142803698359254*G0_1_0_1_1_2 - 0.00120143231254342*G0_1_0_1_2_0 - 0.00142803698359254*G0_1_0_1_2_1 - 0.0100689434022767*G0_1_0_1_2_2 - 0.00527604083159634*G0_1_0_2_0_0 - 0.00120143231254342*G0_1_0_2_0_1 - 0.00339907006573669*G0_1_0_2_0_2 - 0.00120143231254342*G0_1_0_2_1_0 - 0.00142803698359254*G0_1_0_2_1_1 - 0.0100689434022767*G0_1_0_2_1_2 - 0.00339907006573669*G0_1_0_2_2_0 - 0.0100689434022767*G0_1_0_2_2_1 - 0.117748917748917*G0_1_0_2_2_2 - 0.0577585377585375*G0_1_1_0_0_0 - 0.0071230826786382*G0_1_1_0_0_1 - 0.00340762118539894*G0_1_1_0_0_2 - 0.0071230826786382*G0_1_1_0_1_0 - 0.00157768157768158*G0_1_1_0_1_1 - 0.00103468547912992*G0_1_1_0_1_2 - 0.00340762118539894*G0_1_1_0_2_0 - 0.00103468547912992*G0_1_1_0_2_1 - 0.00148361926139703*G0_1_1_0_2_2 - 0.0071230826786382*G0_1_1_1_0_0 - 0.00157768157768158*G0_1_1_1_0_1 - 0.00103468547912992*G0_1_1_1_0_2 - 0.00157768157768158*G0_1_1_1_1_0 - 0.00105178771845442*G0_1_1_1_1_1 - 0.00132114798781466*G0_1_1_1_1_2 - 0.00103468547912992*G0_1_1_1_2_0 - 0.00132114798781466*G0_1_1_1_2_1 - 0.00935492491048043*G0_1_1_1_2_2 - 0.00340762118539894*G0_1_1_2_0_0 - 0.00103468547912992*G0_1_1_2_0_1 - 0.00148361926139703*G0_1_1_2_0_2 - 0.00103468547912992*G0_1_1_2_1_0 - 0.00132114798781466*G0_1_1_2_1_1 - 0.00935492491048043*G0_1_1_2_1_2 - 0.00148361926139703*G0_1_1_2_2_0 - 0.00935492491048043*G0_1_1_2_2_1 - 0.10767997434664*G0_1_1_2_2_2;
    A[122] = -0.000192400192400201*G0_0_1_0_0_0 - 6.41333974667374e-05*G0_0_1_0_0_1 - 0.00397627064293729*G0_0_1_0_0_2 - 6.41333974667374e-05*G0_0_1_0_1_0 - 6.41333974667395e-05*G0_0_1_0_1_1 - 0.00198813532146865*G0_0_1_0_1_2 - 0.00397627064293729*G0_0_1_0_2_0 - 0.00198813532146865*G0_0_1_0_2_1 - 0.0335417668751*G0_0_1_0_2_2 - 6.41333974667373e-05*G0_0_1_1_0_0 - 6.41333974667395e-05*G0_0_1_1_0_1 - 0.00198813532146865*G0_0_1_1_0_2 - 6.41333974667395e-05*G0_0_1_1_1_0 - 0.000192400192400221*G0_0_1_1_1_1 - 0.00397627064293729*G0_0_1_1_1_2 - 0.00198813532146865*G0_0_1_1_2_0 - 0.00397627064293729*G0_0_1_1_2_1 - 0.0335417668751*G0_0_1_1_2_2 - 0.00397627064293729*G0_0_1_2_0_0 - 0.00198813532146865*G0_0_1_2_0_1 - 0.0335417668751*G0_0_1_2_0_2 - 0.00198813532146865*G0_0_1_2_1_0 - 0.00397627064293729*G0_0_1_2_1_1 - 0.0335417668751*G0_0_1_2_1_2 - 0.0335417668751*G0_0_1_2_2_0 - 0.0335417668751*G0_0_1_2_2_1 - 0.541029341029337*G0_0_1_2_2_2 - 0.0356453423120088*G0_1_1_0_0_0 - 0.00892736892736889*G0_1_1_0_0_1 - 0.00622093955427287*G0_1_1_0_0_2 - 0.00892736892736889*G0_1_1_0_1_0 - 0.00597295708406817*G0_1_1_0_1_1 - 0.00273635829191384*G0_1_1_0_1_2 - 0.00622093955427287*G0_1_1_0_2_0 - 0.00273635829191384*G0_1_1_0_2_1 - 0.0178504622949067*G0_1_1_0_2_2 - 0.00892736892736889*G0_1_1_1_0_0 - 0.00597295708406817*G0_1_1_1_0_1 - 0.00273635829191384*G0_1_1_1_0_2 - 0.00597295708406817*G0_1_1_1_1_0 - 0.0090556357223024*G0_1_1_1_1_1 - 0.00472449361338249*G0_1_1_1_1_2 - 0.00273635829191384*G0_1_1_1_2_0 - 0.00472449361338249*G0_1_1_1_2_1 - 0.0256961145850033*G0_1_1_1_2_2 - 0.00622093955427287*G0_1_1_2_0_0 - 0.00273635829191384*G0_1_1_2_0_1 - 0.0178504622949067*G0_1_1_2_0_2 - 0.00273635829191384*G0_1_1_2_1_0 - 0.00472449361338249*G0_1_1_2_1_1 - 0.0256961145850033*G0_1_1_2_1_2 - 0.0178504622949067*G0_1_1_2_2_0 - 0.0256961145850034*G0_1_1_2_2_1 - 0.382555715889047*G0_1_1_2_2_2;
    A[191] = -A[108] + 0.212922879589545*G0_0_0_0_0_0 - 0.00723424723424725*G0_0_0_0_0_1 + 0.0505371172037835*G0_0_0_0_0_2 - 0.00723424723424725*G0_0_0_0_1_0 - 0.0305788039121372*G0_0_0_0_1_1 + 0.0505371172037835*G0_0_0_0_2_0 + 0.00759339426006085*G0_0_0_0_2_2 - 0.00723424723424724*G0_0_0_1_0_0 - 0.0305788039121372*G0_0_0_1_0_1 - 0.0305788039121372*G0_0_0_1_1_0 - 0.200352733686066*G0_0_0_1_1_1 - 0.034324194324194*G0_0_0_1_1_2 - 0.034324194324194*G0_0_0_1_2_1 - 0.0068751002084334*G0_0_0_1_2_2 + 0.0505371172037835*G0_0_0_2_0_0 + 0.00759339426006085*G0_0_0_2_0_2 - 0.034324194324194*G0_0_0_2_1_1 - 0.0068751002084334*G0_0_0_2_1_2 + 0.00759339426006085*G0_0_0_2_2_0 - 0.0068751002084334*G0_0_0_2_2_1 + 0.0331441398108061*G0_0_0_2_2_2 - 0.0234728234728235*G0_0_1_0_0_0 - 0.00161616161616166*G0_0_1_0_0_1 - 0.0104665704665705*G0_0_1_0_0_2 - 0.00161616161616166*G0_0_1_0_1_0 + 0.00128266794933446*G0_0_1_0_1_1 - 0.00248837582170917*G0_0_1_0_1_2 - 0.0104665704665705*G0_0_1_0_2_0 - 0.00248837582170917*G0_0_1_0_2_1 - 0.00792688792688795*G0_0_1_0_2_2 - 0.00161616161616166*G0_0_1_1_0_0 + 0.00128266794933446*G0_0_1_1_0_1 - 0.00248837582170917*G0_0_1_1_0_2 + 0.00128266794933446*G0_0_1_1_1_0 - 0.157768157768159*G0_0_1_1_1_1 - 0.0325797659130991*G0_0_1_1_1_2 - 0.00248837582170917*G0_0_1_1_2_0 - 0.0325797659130991*G0_0_1_1_2_1 - 0.0100817700817701*G0_0_1_1_2_2 - 0.0104665704665705*G0_0_1_2_0_0 - 0.00248837582170917*G0_0_1_2_0_1 - 0.00792688792688795*G0_0_1_2_0_2 - 0.00248837582170917*G0_0_1_2_1_0 - 0.0325797659130991*G0_0_1_2_1_1 - 0.0100817700817701*G0_0_1_2_1_2 - 0.00792688792688795*G0_0_1_2_2_0 - 0.0100817700817701*G0_0_1_2_2_1 - 0.000615680615681081*G0_0_1_2_2_2 - 0.0489466089466087*G0_1_0_0_0_0 - 0.0220105820105818*G0_1_0_0_0_1 + 0.000410453743787048*G0_1_0_0_0_2 - 0.0220105820105818*G0_1_0_0_1_0 - 0.00779862113195439*G0_1_0_0_1_1 - 0.00179573512906844*G0_1_0_0_1_2 + 0.000410453743787047*G0_1_0_0_2_0 - 0.00179573512906844*G0_1_0_0_2_1 - 0.00933782267115596*G0_1_0_0_2_2 - 0.0220105820105818*G0_1_0_1_0_0 - 0.00779862113195439*G0_1_0_1_0_1 - 0.00179573512906844*G0_1_0_1_0_2 - 0.0077986211319544*G0_1_0_1_1_0 - 0.101741221741221*G0_1_0_1_1_1 - 0.0309892576559241*G0_1_0_1_1_2 - 0.00179573512906845*G0_1_0_1_2_0 - 0.0309892576559241*G0_1_0_1_2_1 - 0.00672118005451326*G0_1_0_1_2_2 + 0.000410453743787047*G0_1_0_2_0_0 - 0.00179573512906845*G0_1_0_2_0_1 - 0.00933782267115596*G0_1_0_2_0_2 - 0.00179573512906845*G0_1_0_2_1_0 - 0.0309892576559241*G0_1_0_2_1_1 - 0.00672118005451326*G0_1_0_2_1_2 - 0.00933782267115596*G0_1_0_2_2_0 - 0.00672118005451326*G0_1_0_2_2_1 + 0.00985088985088971*G0_1_0_2_2_2 - 0.0105435305435307*G0_1_1_0_0_0 + 0.00436107102773761*G0_1_1_0_0_1 + 0.00279621612954941*G0_1_1_0_0_2 + 0.00436107102773761*G0_1_1_0_1_0 + 0.0186756453423117*G0_1_1_0_1_1 + 0.00123136123136119*G0_1_1_0_1_2 + 0.00279621612954941*G0_1_1_0_2_0 + 0.00123136123136119*G0_1_1_0_2_1 + 0.000487413820747104*G0_1_1_0_2_2 + 0.00436107102773761*G0_1_1_1_0_0 + 0.0186756453423117*G0_1_1_1_0_1 + 0.00123136123136119*G0_1_1_1_0_2 + 0.0186756453423117*G0_1_1_1_1_0 - 0.018675645342312*G0_1_1_1_1_2 + 0.00123136123136119*G0_1_1_1_2_0 - 0.018675645342312*G0_1_1_1_2_1 - 0.00682379349046019*G0_1_1_1_2_2 + 0.00279621612954941*G0_1_1_2_0_0 + 0.00123136123136119*G0_1_1_2_0_1 + 0.000487413820747104*G0_1_1_2_0_2 + 0.00123136123136119*G0_1_1_2_1_0 - 0.018675645342312*G0_1_1_2_1_1 - 0.00682379349046019*G0_1_1_2_1_2 + 0.000487413820747105*G0_1_1_2_2_0 - 0.00682379349046019*G0_1_1_2_2_1 + 0.000692640692640323*G0_1_1_2_2_2;
    A[110] = A[191] - 0.226544813211478*G0_0_0_0_0_0 + 0.00941478274811608*G0_0_0_0_0_1 - 0.0819881353214681*G0_0_0_0_0_2 + 0.00941478274811608*G0_0_0_0_1_0 + 0.0343498476831809*G0_0_0_0_1_1 + 0.00194965528298861*G0_0_0_0_1_2 - 0.0819881353214681*G0_0_0_0_2_0 + 0.00194965528298861*G0_0_0_0_2_1 - 0.0503318903318902*G0_0_0_0_2_2 + 0.00941478274811608*G0_0_0_1_0_0 + 0.0343498476831809*G0_0_0_1_0_1 + 0.00194965528298861*G0_0_0_1_0_2 + 0.0343498476831809*G0_0_0_1_1_0 + 0.208433541766875*G0_0_0_1_1_1 + 0.0495622895622893*G0_0_0_1_1_2 + 0.00194965528298861*G0_0_0_1_2_0 + 0.0495622895622893*G0_0_0_1_2_1 + 0.0619272085938749*G0_0_0_1_2_2 - 0.0819881353214681*G0_0_0_2_0_0 + 0.00194965528298861*G0_0_0_2_0_1 - 0.0503318903318902*G0_0_0_2_0_2 + 0.00194965528298861*G0_0_0_2_1_0 + 0.0495622895622893*G0_0_0_2_1_1 + 0.0619272085938748*G0_0_0_2_1_2 - 0.0503318903318902*G0_0_0_2_2_0 + 0.0619272085938748*G0_0_0_2_2_1 + 0.564066057399386*G0_0_0_2_2_2 + 0.0199583132916466*G0_0_1_0_0_0 + 0.000615680615680622*G0_0_1_0_0_1 - 0.00420715087381757*G0_0_1_0_0_2 + 0.000615680615680622*G0_0_1_0_1_0 - 0.00420715087381757*G0_0_1_0_2_0 - 0.00990219656886331*G0_0_1_0_2_2 + 0.000615680615680622*G0_0_1_1_0_0 + 0.161718775052108*G0_0_1_1_1_1 + 0.0544877344877342*G0_0_1_1_1_2 + 0.0544877344877342*G0_0_1_1_2_1 + 0.0730607663940993*G0_0_1_1_2_2 - 0.00420715087381757*G0_0_1_2_0_0 - 0.00990219656886331*G0_0_1_2_0_2 + 0.0544877344877342*G0_0_1_2_1_1 + 0.0730607663940993*G0_0_1_2_1_2 - 0.00990219656886331*G0_0_1_2_2_0 + 0.0730607663940993*G0_0_1_2_2_1 + 0.280545133878465*G0_0_1_2_2_2 + 0.0529741863075191*G0_1_0_0_0_0 + 0.0200096200096198*G0_1_0_0_0_1 - 0.0148532948532949*G0_1_0_0_0_2 + 0.0200096200096198*G0_1_0_0_1_0 + 0.00777296777296769*G0_1_0_0_1_1 + 0.000436107102773753*G0_1_0_0_1_2 - 0.0148532948532949*G0_1_0_0_2_0 + 0.000436107102773754*G0_1_0_0_2_1 - 0.0324258457591791*G0_1_0_0_2_2 + 0.0200096200096198*G0_1_0_1_0_0 + 0.00777296777296769*G0_1_0_1_0_1 + 0.000436107102773754*G0_1_0_1_0_2 + 0.00777296777296769*G0_1_0_1_1_0 + 0.100458553791887*G0_1_0_1_1_1 + 0.0390700657367322*G0_1_0_1_1_2 + 0.000436107102773755*G0_1_0_1_2_0 + 0.0390700657367322*G0_1_0_1_2_1 + 0.0474074074074071*G0_1_0_1_2_2 - 0.0148532948532949*G0_1_0_2_0_0 + 0.000436107102773754*G0_1_0_2_0_1 - 0.0324258457591791*G0_1_0_2_0_2 + 0.000436107102773754*G0_1_0_2_1_0 + 0.0390700657367322*G0_1_0_2_1_1 + 0.0474074074074071*G0_1_0_2_1_2 - 0.0324258457591791*G0_1_0_2_2_0 + 0.0474074074074071*G0_1_0_2_2_1 + 0.44724066057399*G0_1_0_2_2_2 - 0.0414045214045209*G0_1_1_0_0_0 - 0.0213949013949012*G0_1_1_0_0_1 - 0.0173416706750039*G0_1_1_0_0_2 - 0.0213949013949012*G0_1_1_0_1_0 - 0.0261151194484526*G0_1_1_0_1_1 - 0.00723424723424718*G0_1_1_0_1_2 - 0.0173416706750039*G0_1_1_0_2_0 - 0.00723424723424718*G0_1_1_0_2_1 - 0.0239602372935706*G0_1_1_0_2_2 - 0.0213949013949012*G0_1_1_1_0_0 - 0.0261151194484526*G0_1_1_1_0_1 - 0.00723424723424718*G0_1_1_1_0_2 - 0.0261151194484526*G0_1_1_1_1_0 + 0.00708032708032735*G0_1_1_1_1_1 + 0.0325797659130991*G0_1_1_1_1_2 - 0.00723424723424718*G0_1_1_1_2_0 + 0.0325797659130991*G0_1_1_1_2_1 + 0.0497162097162094*G0_1_1_1_2_2 - 0.0173416706750039*G0_1_1_2_0_0 - 0.00723424723424718*G0_1_1_2_0_1 - 0.0239602372935706*G0_1_1_2_0_2 - 0.00723424723424718*G0_1_1_2_1_0 + 0.0325797659130991*G0_1_1_2_1_1 + 0.0497162097162094*G0_1_1_2_1_2 - 0.0239602372935706*G0_1_1_2_2_0 + 0.0497162097162094*G0_1_1_2_2_1 + 0.198864838864837*G0_1_1_2_2_2;
    A[117] = -A[110] + 0.0153920153920151*G0_0_0_0_0_0 + 0.00548981882315213*G0_0_0_0_0_1 - 0.0468430335097001*G0_0_0_0_0_2 + 0.00548981882315212*G0_0_0_0_1_0 + 0.00359147025813694*G0_0_0_0_1_1 + 0.010671797338464*G0_0_0_0_1_2 - 0.0468430335097001*G0_0_0_0_2_0 + 0.010671797338464*G0_0_0_0_2_1 - 0.0309892576559244*G0_0_0_0_2_2 + 0.00548981882315212*G0_0_0_1_0_0 + 0.00359147025813694*G0_0_0_1_0_1 + 0.010671797338464*G0_0_0_1_0_2 + 0.00359147025813694*G0_0_0_1_1_0 + 0.0204713804713805*G0_0_0_1_1_1 + 0.0470482603815936*G0_0_0_1_1_2 + 0.010671797338464*G0_0_0_1_2_0 + 0.0470482603815936*G0_0_0_1_2_1 + 0.127958954625621*G0_0_0_1_2_2 - 0.0468430335097001*G0_0_0_2_0_0 + 0.010671797338464*G0_0_0_2_0_1 - 0.0309892576559244*G0_0_0_2_0_2 + 0.010671797338464*G0_0_0_2_1_0 + 0.0470482603815936*G0_0_0_2_1_1 + 0.127958954625621*G0_0_0_2_1_2 - 0.0309892576559244*G0_0_0_2_2_0 + 0.127958954625621*G0_0_0_2_2_1 + 0.749591149591145*G0_0_0_2_2_2 + 0.132961359628026*G0_0_1_0_0_0 + 0.0377360910694243*G0_0_1_0_0_1 + 0.0477152477152474*G0_0_1_0_0_2 + 0.0377360910694242*G0_0_1_0_1_0 + 0.0193426326759659*G0_0_1_0_1_1 + 0.0224979958313291*G0_0_1_0_1_2 + 0.0477152477152474*G0_0_1_0_2_0 + 0.0224979958313291*G0_0_1_0_2_1 + 0.0635433702100365*G0_0_1_0_2_2 + 0.0377360910694243*G0_0_1_1_0_0 + 0.0193426326759659*G0_0_1_1_0_1 + 0.0224979958313291*G0_0_1_1_0_2 + 0.0193426326759659*G0_0_1_1_1_0 + 0.0403783870450533*G0_0_1_1_1_1 + 0.0638768638768636*G0_0_1_1_1_2 + 0.0224979958313291*G0_0_1_1_2_0 + 0.0638768638768636*G0_0_1_1_2_1 + 0.150662177328843*G0_0_1_1_2_2 + 0.0477152477152474*G0_0_1_2_0_0 + 0.0224979958313291*G0_0_1_2_0_1 + 0.0635433702100365*G0_0_1_2_0_2 + 0.0224979958313291*G0_0_1_2_1_0 + 0.0638768638768636*G0_0_1_2_1_1 + 0.150662177328843*G0_0_1_2_1_2 + 0.0635433702100365*G0_0_1_2_2_0 + 0.150662177328843*G0_0_1_2_2_1 + 0.583254769921433*G0_0_1_2_2_2 + 0.24709315375982*G0_1_0_0_0_0 + 0.0126727593394261*G0_1_0_0_0_1 + 0.115542728876062*G0_1_0_0_0_2 + 0.0126727593394261*G0_1_0_0_1_0 + 0.000205226871893606*G0_1_0_0_1_1 + 0.0142119608786275*G0_1_0_0_1_2 + 0.115542728876062*G0_1_0_0_2_0 + 0.0142119608786275*G0_1_0_0_2_1 + 0.0547955747955744*G0_1_0_0_2_2 + 0.0126727593394261*G0_1_0_1_0_0 + 0.000205226871893606*G0_1_0_1_0_1 + 0.0142119608786275*G0_1_0_1_0_2 + 0.000205226871893606*G0_1_0_1_1_0 + 0.0139041205707873*G0_1_0_1_1_1 + 0.0383774250440916*G0_1_0_1_1_2 + 0.0142119608786275*G0_1_0_1_2_0 + 0.0383774250440916*G0_1_0_1_2_1 + 0.113336540003206*G0_1_0_1_2_2 + 0.115542728876062*G0_1_0_2_0_0 + 0.0142119608786275*G0_1_0_2_0_1 + 0.0547955747955744*G0_1_0_2_0_2 + 0.0142119608786275*G0_1_0_2_1_0 + 0.0383774250440916*G0_1_0_2_1_1 + 0.113336540003206*G0_1_0_2_1_2 + 0.0547955747955744*G0_1_0_2_2_0 + 0.113336540003206*G0_1_0_2_2_1 + 0.689151835818498*G0_1_0_2_2_2 - 0.450293410293407*G0_1_1_0_0_0 - 0.112926086259419*G0_1_1_0_0_1 - 0.015828122494789*G0_1_1_0_0_2 - 0.112926086259419*G0_1_1_0_1_0 - 0.0445342312008976*G0_1_1_0_1_1 - 0.015828122494789*G0_1_1_0_2_0 + 0.0158281224947892*G0_1_1_0_2_2 - 0.112926086259419*G0_1_1_1_0_0 - 0.0445342312008976*G0_1_1_1_0_1 - 0.0445342312008976*G0_1_1_1_1_0 + 0.0445342312008977*G0_1_1_1_1_2 + 0.0445342312008977*G0_1_1_1_2_1 + 0.112926086259419*G0_1_1_1_2_2 - 0.015828122494789*G0_1_1_2_0_0 + 0.0158281224947892*G0_1_1_2_0_2 + 0.0445342312008977*G0_1_1_2_1_1 + 0.112926086259419*G0_1_1_2_1_2 + 0.0158281224947892*G0_1_1_2_2_0 + 0.112926086259419*G0_1_1_2_2_1 + 0.450293410293408*G0_1_1_2_2_2;
    A[65] = -A[110] - 0.000923520923520923*G0_0_0_0_0_0 - 0.000102613435946766*G0_0_0_0_0_1 - 0.0215488215488215*G0_0_0_0_0_2 - 0.000102613435946767*G0_0_0_0_1_0 + 0.000102613435946784*G0_0_0_0_1_1 - 0.0215488215488215*G0_0_0_0_2_0 - 0.0687510020843351*G0_0_0_0_2_2 - 0.000102613435946767*G0_0_0_1_0_0 + 0.000102613435946784*G0_0_0_1_0_1 + 0.000102613435946784*G0_0_0_1_1_0 + 0.000923520923520991*G0_0_0_1_1_1 + 0.0215488215488215*G0_0_0_1_1_2 + 0.0215488215488215*G0_0_0_1_2_1 + 0.0687510020843352*G0_0_0_1_2_2 - 0.0215488215488215*G0_0_0_2_0_0 - 0.0687510020843351*G0_0_0_2_0_2 + 0.0215488215488215*G0_0_0_2_1_1 + 0.0687510020843352*G0_0_0_2_1_2 - 0.0687510020843351*G0_0_0_2_2_0 + 0.0687510020843352*G0_0_0_2_2_1 - 0.00420715087381754*G0_0_1_0_0_0 - 0.00933782267115604*G0_0_1_0_0_2 + 0.00420715087381757*G0_0_1_0_1_1 + 0.00933782267115599*G0_0_1_0_1_2 - 0.00933782267115604*G0_0_1_0_2_0 + 0.00933782267115599*G0_0_1_0_2_1 + 0.00420715087381757*G0_0_1_1_0_1 + 0.00933782267115599*G0_0_1_1_0_2 + 0.00420715087381757*G0_0_1_1_1_0 + 0.0336572069905402*G0_0_1_1_1_1 + 0.0840404040404037*G0_0_1_1_1_2 + 0.00933782267115599*G0_0_1_1_2_0 + 0.0840404040404037*G0_0_1_1_2_1 + 0.17752124418791*G0_0_1_1_2_2 - 0.00933782267115604*G0_0_1_2_0_0 + 0.00933782267115599*G0_0_1_2_0_1 + 0.00933782267115599*G0_0_1_2_1_0 + 0.0840404040404037*G0_0_1_2_1_1 + 0.17752124418791*G0_0_1_2_1_2 + 0.17752124418791*G0_0_1_2_2_1 + 0.432002565335896*G0_0_1_2_2_2 - 0.0125188391855058*G0_1_0_0_0_0 - 0.00287317620650949*G0_1_0_0_0_1 - 0.017341670675004*G0_1_0_0_0_2 - 0.00287317620650949*G0_1_0_0_1_0 - 0.00277056277056269*G0_1_0_0_1_1 - 0.0039506172839506*G0_1_0_0_1_2 - 0.017341670675004*G0_1_0_0_2_0 - 0.0039506172839506*G0_1_0_0_2_1 - 0.0407888407888407*G0_1_0_0_2_2 - 0.00287317620650949*G0_1_0_1_0_0 - 0.00277056277056269*G0_1_0_1_0_1 - 0.0039506172839506*G0_1_0_1_0_2 - 0.00277056277056269*G0_1_0_1_1_0 - 0.0115953182619845*G0_1_0_1_1_1 + 0.00420715087381758*G0_1_0_1_1_2 - 0.0039506172839506*G0_1_0_1_2_0 + 0.00420715087381758*G0_1_0_1_2_1 + 0.0279621612954945*G0_1_0_1_2_2 - 0.017341670675004*G0_1_0_2_0_0 - 0.0039506172839506*G0_1_0_2_0_1 - 0.0407888407888407*G0_1_0_2_0_2 - 0.0039506172839506*G0_1_0_2_1_0 + 0.00420715087381758*G0_1_0_2_1_1 + 0.0279621612954945*G0_1_0_2_1_2 - 0.0407888407888407*G0_1_0_2_2_0 + 0.0279621612954945*G0_1_0_2_2_1 + 0.311944845278177*G0_1_0_2_2_2 - 0.0604906204906199*G0_1_1_0_0_0 - 0.0341702741702739*G0_1_1_0_0_1 - 0.0204713804713804*G0_1_1_0_0_2 - 0.0341702741702739*G0_1_1_0_1_0 - 0.0562834696168027*G0_1_1_0_1_1 - 0.0111335578002244*G0_1_1_0_1_2 - 0.0204713804713804*G0_1_1_0_2_0 - 0.0111335578002244*G0_1_1_0_2_1 - 0.0310405643738976*G0_1_1_0_2_2 - 0.0341702741702739*G0_1_1_1_0_0 - 0.0562834696168027*G0_1_1_1_0_1 - 0.0111335578002244*G0_1_1_1_0_2 - 0.0562834696168027*G0_1_1_1_1_0 - 0.302299182299182*G0_1_1_1_1_1 - 0.000359147025813767*G0_1_1_1_1_2 - 0.0111335578002244*G0_1_1_1_2_0 - 0.00035914702581377*G0_1_1_1_2_1 + 0.0487413820747151*G0_1_1_1_2_2 - 0.0204713804713804*G0_1_1_2_0_0 - 0.0111335578002244*G0_1_1_2_0_1 - 0.0310405643738976*G0_1_1_2_0_2 - 0.0111335578002244*G0_1_1_2_1_0 - 0.000359147025813774*G0_1_1_2_1_1 + 0.0487413820747151*G0_1_1_2_1_2 - 0.0310405643738976*G0_1_1_2_2_0 + 0.0487413820747151*G0_1_1_2_2_1 + 0.15161135161135*G0_1_1_2_2_2;
    A[212] = -0.00161616161616153*G0_0_1_0_0_0 - 0.000179573512906829*G0_0_1_0_0_1 - 0.00102613435946771*G0_0_1_0_0_2 - 0.00017957351290683*G0_0_1_0_1_0 + 0.00017957351290685*G0_0_1_0_1_1 - 0.00102613435946771*G0_0_1_0_2_0 + 0.0109026775693441*G0_0_1_0_2_2 - 0.00017957351290683*G0_0_1_1_0_0 + 0.00017957351290685*G0_0_1_1_0_1 + 0.00017957351290685*G0_0_1_1_1_0 + 0.00161616161616155*G0_0_1_1_1_1 + 0.00102613435946766*G0_0_1_1_1_2 + 0.00102613435946766*G0_0_1_1_2_1 - 0.0109026775693443*G0_0_1_1_2_2 - 0.00102613435946771*G0_0_1_2_0_0 + 0.0109026775693441*G0_0_1_2_0_2 + 0.00102613435946766*G0_0_1_2_1_1 - 0.0109026775693443*G0_0_1_2_1_2 + 0.0109026775693441*G0_0_1_2_2_0 - 0.0109026775693443*G0_0_1_2_2_1 + 0.0368125701459034*G0_1_1_0_0_0 + 0.0184960718294051*G0_1_1_0_0_1 + 0.00282186948853613*G0_1_1_0_0_2 + 0.0184960718294051*G0_1_1_0_1_0 + 0.0186756453423119*G0_1_1_0_1_1 + 0.00205226871893537*G0_1_1_0_1_2 + 0.00282186948853613*G0_1_1_0_2_0 + 0.00205226871893537*G0_1_1_0_2_1 - 0.0105178771845438*G0_1_1_0_2_2 + 0.0184960718294051*G0_1_1_1_0_0 + 0.0186756453423119*G0_1_1_1_0_1 + 0.00205226871893537*G0_1_1_1_0_2 + 0.0186756453423119*G0_1_1_1_1_0 + 0.038428731762065*G0_1_1_1_1_1 + 0.00384800384800381*G0_1_1_1_1_2 + 0.00205226871893537*G0_1_1_1_2_0 + 0.00384800384800381*G0_1_1_1_2_1 - 0.021420554753888*G0_1_1_1_2_2 + 0.00282186948853613*G0_1_1_2_0_0 + 0.00205226871893537*G0_1_1_2_0_1 - 0.0105178771845438*G0_1_1_2_0_2 + 0.00205226871893537*G0_1_1_2_1_0 + 0.00384800384800381*G0_1_1_2_1_1 - 0.021420554753888*G0_1_1_2_1_2 - 0.0105178771845438*G0_1_1_2_2_0 - 0.021420554753888*G0_1_1_2_2_1 - 0.20792047458714*G0_1_1_2_2_2;
    A[1] = 0.0212361712361712*G0_0_0_0_0_0 + 5.39789428678374e-05*G0_0_0_0_0_1 + 0.00190208967986745*G0_0_0_0_0_2 + 5.39789428678375e-05*G0_0_0_0_1_0 + 5.39789428678363e-05*G0_0_0_0_1_1 + 0.000130137352359575*G0_0_0_0_1_2 + 0.00190208967986745*G0_0_0_0_2_0 + 0.000130137352359575*G0_0_0_0_2_1 + 0.000286996953663617*G0_0_0_0_2_2 + 5.39789428678374e-05*G0_0_0_1_0_0 + 5.39789428678363e-05*G0_0_0_1_0_1 + 0.000130137352359574*G0_0_0_1_0_2 + 5.39789428678364e-05*G0_0_0_1_1_0 + 0.0212361712361712*G0_0_0_1_1_1 + 0.00190208967986745*G0_0_0_1_1_2 + 0.000130137352359574*G0_0_0_1_2_0 + 0.00190208967986745*G0_0_0_1_2_1 + 0.000286996953663615*G0_0_0_1_2_2 + 0.00190208967986745*G0_0_0_2_0_0 + 0.000130137352359575*G0_0_0_2_0_1 + 0.000286996953663617*G0_0_0_2_0_2 + 0.000130137352359574*G0_0_0_2_1_0 + 0.00190208967986745*G0_0_0_2_1_1 + 0.000286996953663615*G0_0_0_2_1_2 + 0.000286996953663617*G0_0_0_2_2_0 + 0.000286996953663615*G0_0_0_2_2_1 - 9.78034311367793e-05*G0_0_0_2_2_2 + 0.0212361712361712*G0_1_0_0_0_0 + 5.39789428678377e-05*G0_1_0_0_0_1 + 0.00190208967986745*G0_1_0_0_0_2 + 5.39789428678376e-05*G0_1_0_0_1_0 + 5.39789428678356e-05*G0_1_0_0_1_1 + 0.000130137352359574*G0_1_0_0_1_2 + 0.00190208967986745*G0_1_0_0_2_0 + 0.000130137352359574*G0_1_0_0_2_1 + 0.000286996953663616*G0_1_0_0_2_2 + 5.39789428678375e-05*G0_1_0_1_0_0 + 5.39789428678354e-05*G0_1_0_1_0_1 + 0.000130137352359574*G0_1_0_1_0_2 + 5.39789428678355e-05*G0_1_0_1_1_0 + 0.0212361712361711*G0_1_0_1_1_1 + 0.00190208967986744*G0_1_0_1_1_2 + 0.000130137352359574*G0_1_0_1_2_0 + 0.00190208967986744*G0_1_0_1_2_1 + 0.000286996953663615*G0_1_0_1_2_2 + 0.00190208967986745*G0_1_0_2_0_0 + 0.000130137352359574*G0_1_0_2_0_1 + 0.000286996953663616*G0_1_0_2_0_2 + 0.000130137352359574*G0_1_0_2_1_0 + 0.00190208967986744*G0_1_0_2_1_1 + 0.000286996953663615*G0_1_0_2_1_2 + 0.000286996953663616*G0_1_0_2_2_0 + 0.000286996953663615*G0_1_0_2_2_1 - 9.78034311367895e-05*G0_1_0_2_2_2;
    A[27] = A[181] + 0.0112361712361711*G0_0_1_0_0_0 + 0.00287317620650952*G0_0_1_0_0_1 - 0.00112874779541446*G0_0_1_0_0_2 + 0.00287317620650952*G0_0_1_0_1_0 - 0.00333493666826996*G0_0_1_0_1_1 - 0.000949174282507608*G0_0_1_0_1_2 - 0.00112874779541446*G0_0_1_0_2_0 - 0.000949174282507608*G0_0_1_0_2_1 - 0.00243706910373576*G0_0_1_0_2_2 + 0.00287317620650952*G0_0_1_1_0_0 - 0.00333493666826996*G0_0_1_1_0_1 - 0.000949174282507608*G0_0_1_1_0_2 - 0.00333493666826996*G0_0_1_1_1_0 + 0.00333493666827*G0_0_1_1_1_2 - 0.000949174282507608*G0_0_1_1_2_0 + 0.00333493666827*G0_0_1_1_2_1 - 0.00097482764149431*G0_0_1_1_2_2 - 0.00112874779541446*G0_0_1_2_0_0 - 0.000949174282507608*G0_0_1_2_0_1 - 0.00243706910373576*G0_0_1_2_0_2 - 0.000949174282507608*G0_0_1_2_1_0 + 0.00333493666827*G0_0_1_2_1_1 - 0.000974827641494309*G0_0_1_2_1_2 - 0.00243706910373576*G0_0_1_2_2_0 - 0.000974827641494308*G0_0_1_2_2_1 - 0.000538720538720557*G0_0_1_2_2_2 - 0.0112361712361711*G0_1_0_0_0_0 - 0.00287317620650952*G0_1_0_0_0_1 + 0.00112874779541446*G0_1_0_0_0_2 - 0.00287317620650952*G0_1_0_0_1_0 + 0.00333493666826996*G0_1_0_0_1_1 + 0.000949174282507608*G0_1_0_0_1_2 + 0.00112874779541446*G0_1_0_0_2_0 + 0.000949174282507608*G0_1_0_0_2_1 + 0.00243706910373576*G0_1_0_0_2_2 - 0.00287317620650952*G0_1_0_1_0_0 + 0.00333493666826996*G0_1_0_1_0_1 + 0.000949174282507608*G0_1_0_1_0_2 + 0.00333493666826996*G0_1_0_1_1_0 - 0.00333493666827*G0_1_0_1_1_2 + 0.000949174282507608*G0_1_0_1_2_0 - 0.00333493666827*G0_1_0_1_2_1 + 0.000974827641494308*G0_1_0_1_2_2 + 0.00112874779541446*G0_1_0_2_0_0 + 0.000949174282507608*G0_1_0_2_0_1 + 0.00243706910373576*G0_1_0_2_0_2 + 0.000949174282507608*G0_1_0_2_1_0 - 0.00333493666827*G0_1_0_2_1_1 + 0.000974827641494308*G0_1_0_2_1_2 + 0.00243706910373576*G0_1_0_2_2_0 + 0.000974827641494308*G0_1_0_2_2_1 + 0.000538720538720557*G0_1_0_2_2_2;
    A[132] = A[191] - 0.239089305755971*G0_0_0_0_0_0 + 0.00944043610710277*G0_0_0_0_0_1 - 0.0683405483405478*G0_0_0_0_0_2 + 0.00944043610710277*G0_0_0_0_1_0 + 0.0352990219656885*G0_0_0_0_1_1 + 0.00266794933461598*G0_0_0_0_1_2 - 0.0683405483405478*G0_0_0_0_2_0 + 0.00266794933461598*G0_0_0_0_2_1 - 0.0223697290363956*G0_0_0_0_2_2 + 0.00944043610710277*G0_0_0_1_0_0 + 0.0352990219656885*G0_0_0_1_0_1 + 0.00266794933461598*G0_0_0_1_0_2 + 0.0352990219656885*G0_0_0_1_1_0 + 0.20420073753407*G0_0_0_1_1_1 + 0.0313997113997112*G0_0_0_1_1_2 + 0.00266794933461598*G0_0_0_1_2_0 + 0.0313997113997112*G0_0_0_1_2_1 - 0.0137502004168672*G0_0_0_1_2_2 - 0.0683405483405478*G0_0_0_2_0_0 + 0.00266794933461598*G0_0_0_2_0_1 - 0.0223697290363956*G0_0_0_2_0_2 + 0.00266794933461598*G0_0_0_2_1_0 + 0.0313997113997112*G0_0_0_2_1_1 - 0.0137502004168672*G0_0_0_2_1_2 - 0.0223697290363956*G0_0_0_2_2_0 - 0.0137502004168672*G0_0_0_2_2_1 - 0.0316049382716058*G0_0_0_2_2_2 - 0.00543851210517864*G0_0_1_0_0_1 + 0.00543851210517879*G0_0_1_0_0_2 - 0.00543851210517864*G0_0_1_0_1_0 - 0.00359147025813682*G0_0_1_0_1_1 + 0.00543851210517879*G0_0_1_0_2_0 + 0.00359147025813691*G0_0_1_0_2_2 - 0.00543851210517864*G0_0_1_1_0_0 - 0.00359147025813682*G0_0_1_1_0_1 - 0.00359147025813682*G0_0_1_1_1_0 + 0.148379028379028*G0_0_1_1_1_1 + 0.0222671156004488*G0_0_1_1_1_2 + 0.0222671156004488*G0_0_1_1_2_1 - 0.0222671156004489*G0_0_1_1_2_2 + 0.00543851210517879*G0_0_1_2_0_0 + 0.00359147025813691*G0_0_1_2_0_2 + 0.0222671156004488*G0_0_1_2_1_1 - 0.0222671156004489*G0_0_1_2_1_2 + 0.00359147025813691*G0_0_1_2_2_0 - 0.0222671156004489*G0_0_1_2_2_1 - 0.148379028379028*G0_0_1_2_2_2 + 0.0220618887285552*G0_1_0_0_0_1 - 0.0220618887285553*G0_1_0_0_0_2 + 0.0220618887285552*G0_1_0_0_1_0 + 0.0140580407247073*G0_1_0_0_1_1 - 0.0220618887285553*G0_1_0_0_2_0 - 0.0140580407247073*G0_1_0_0_2_2 + 0.0220618887285552*G0_1_0_1_0_0 + 0.0140580407247073*G0_1_0_1_0_1 + 0.0140580407247073*G0_1_0_1_1_0 + 0.104050024050023*G0_1_0_1_1_1 + 0.0263716530383195*G0_1_0_1_1_2 + 0.0263716530383195*G0_1_0_1_2_1 - 0.0263716530383197*G0_1_0_1_2_2 - 0.0220618887285553*G0_1_0_2_0_0 - 0.0140580407247073*G0_1_0_2_0_2 + 0.0263716530383195*G0_1_0_2_1_1 - 0.0263716530383197*G0_1_0_2_1_2 - 0.0140580407247073*G0_1_0_2_2_0 - 0.0263716530383197*G0_1_0_2_2_1 - 0.104050024050024*G0_1_0_2_2_2 + 0.239089305755972*G0_1_1_0_0_0 + 0.0683405483405481*G0_1_1_0_0_1 - 0.00944043610710273*G0_1_1_0_0_2 + 0.0683405483405481*G0_1_1_0_1_0 + 0.0223697290363957*G0_1_1_0_1_1 - 0.00266794933461598*G0_1_1_0_1_2 - 0.00944043610710273*G0_1_1_0_2_0 - 0.00266794933461598*G0_1_1_0_2_1 - 0.0352990219656885*G0_1_1_0_2_2 + 0.0683405483405481*G0_1_1_1_0_0 + 0.0223697290363957*G0_1_1_1_0_1 - 0.00266794933461598*G0_1_1_1_0_2 + 0.0223697290363957*G0_1_1_1_1_0 + 0.0316049382716052*G0_1_1_1_1_1 + 0.013750200416867*G0_1_1_1_1_2 - 0.00266794933461598*G0_1_1_1_2_0 + 0.013750200416867*G0_1_1_1_2_1 - 0.0313997113997113*G0_1_1_1_2_2 - 0.00944043610710274*G0_1_1_2_0_0 - 0.00266794933461598*G0_1_1_2_0_1 - 0.0352990219656885*G0_1_1_2_0_2 - 0.00266794933461598*G0_1_1_2_1_0 + 0.013750200416867*G0_1_1_2_1_1 - 0.0313997113997113*G0_1_1_2_1_2 - 0.0352990219656885*G0_1_1_2_2_0 - 0.0313997113997113*G0_1_1_2_2_1 - 0.20420073753407*G0_1_1_2_2_2;
    A[46] = -0.00886323552990215*G0_0_0_0_0_0 - 0.000748222970445198*G0_0_0_0_0_1 - 0.00590882368660143*G0_0_0_0_0_2 - 0.000748222970445198*G0_0_0_0_1_0 + 0.00784565229009665*G0_0_0_0_1_1 - 0.000748222970445195*G0_0_0_0_1_2 - 0.00590882368660143*G0_0_0_0_2_0 - 0.000748222970445195*G0_0_0_0_2_1 - 0.00886323552990215*G0_0_0_0_2_2 - 0.000748222970445198*G0_0_0_1_0_0 + 0.00784565229009665*G0_0_0_1_0_1 - 0.000748222970445195*G0_0_0_1_0_2 + 0.00784565229009665*G0_0_0_1_1_0 + 0.15847362514029*G0_0_0_1_1_1 + 0.0156913045801934*G0_0_0_1_1_2 - 0.000748222970445195*G0_0_0_1_2_0 + 0.0156913045801934*G0_0_0_1_2_1 - 0.00224466891133558*G0_0_0_1_2_2 - 0.00590882368660143*G0_0_0_2_0_0 - 0.000748222970445195*G0_0_0_2_0_1 - 0.00886323552990215*G0_0_0_2_0_2 - 0.000748222970445195*G0_0_0_2_1_0 + 0.0156913045801934*G0_0_0_2_1_1 - 0.00224466891133558*G0_0_0_2_1_2 - 0.00886323552990215*G0_0_0_2_2_0 - 0.00224466891133558*G0_0_0_2_2_1 - 0.0354529421196086*G0_0_0_2_2_2 + 0.000192400192400178*G0_1_0_0_0_0 + 0.00397627064293729*G0_1_0_0_0_1 + 6.41333974667263e-05*G0_1_0_0_0_2 + 0.00397627064293729*G0_1_0_0_1_0 + 0.0335417668751*G0_1_0_0_1_1 + 0.00198813532146864*G0_1_0_0_1_2 + 6.41333974667262e-05*G0_1_0_0_2_0 + 0.00198813532146864*G0_1_0_0_2_1 + 6.41333974667282e-05*G0_1_0_0_2_2 + 0.00397627064293729*G0_1_0_1_0_0 + 0.0335417668751*G0_1_0_1_0_1 + 0.00198813532146864*G0_1_0_1_0_2 + 0.0335417668751*G0_1_0_1_1_0 + 0.541029341029338*G0_1_0_1_1_1 + 0.0335417668751*G0_1_0_1_1_2 + 0.00198813532146864*G0_1_0_1_2_0 + 0.0335417668751*G0_1_0_1_2_1 + 0.00397627064293729*G0_1_0_1_2_2 + 6.41333974667263e-05*G0_1_0_2_0_0 + 0.00198813532146864*G0_1_0_2_0_1 + 6.41333974667282e-05*G0_1_0_2_0_2 + 0.00198813532146864*G0_1_0_2_1_0 + 0.0335417668751*G0_1_0_2_1_1 + 0.00397627064293729*G0_1_0_2_1_2 + 6.41333974667283e-05*G0_1_0_2_2_0 + 0.00397627064293729*G0_1_0_2_2_1 + 0.000192400192400204*G0_1_0_2_2_2;
    A[144] = A[176] + 0.631072631072629*G0_0_0_0_0_0 + 0.0335887980332423*G0_0_0_0_0_1 + 0.030647212869435*G0_0_0_0_0_2 + 0.0335887980332423*G0_0_0_0_1_0 - 0.0335887980332424*G0_0_0_0_1_1 + 0.030647212869435*G0_0_0_0_2_0 - 0.00355726577948794*G0_0_0_0_2_2 + 0.0335887980332423*G0_0_0_1_0_0 - 0.0335887980332424*G0_0_0_1_0_1 - 0.0335887980332424*G0_0_0_1_1_0 - 0.631072631072628*G0_0_0_1_1_1 - 0.0306472128694349*G0_0_0_1_1_2 - 0.0306472128694349*G0_0_0_1_2_1 + 0.00355726577948798*G0_0_0_1_2_2 + 0.030647212869435*G0_0_0_2_0_0 - 0.00355726577948794*G0_0_0_2_0_2 - 0.0306472128694349*G0_0_0_2_1_1 + 0.00355726577948798*G0_0_0_2_1_2 - 0.00355726577948794*G0_0_0_2_2_0 + 0.00355726577948798*G0_0_0_2_2_1 - 0.00820907487574138*G0_0_1_0_0_0 + 0.0682379349046012*G0_0_1_0_0_1 + 0.00769600769600769*G0_0_1_0_0_2 + 0.0682379349046012*G0_0_1_0_1_0 + 0.0346491368713589*G0_0_1_0_1_1 + 0.00998770776548551*G0_0_1_0_1_2 + 0.00769600769600769*G0_0_1_0_2_0 + 0.00998770776548551*G0_0_1_0_2_1 + 0.00489124044679599*G0_0_1_0_2_2 + 0.0682379349046012*G0_0_1_1_0_0 + 0.0346491368713589*G0_0_1_1_0_1 + 0.00998770776548551*G0_0_1_1_0_2 + 0.0346491368713589*G0_0_1_1_1_0 - 0.63928170594837*G0_0_1_1_1_1 - 0.0229512051734272*G0_0_1_1_1_2 + 0.00998770776548551*G0_0_1_1_2_0 - 0.0229512051734272*G0_0_1_1_2_1 + 0.00844850622628398*G0_0_1_1_2_2 + 0.00769600769600769*G0_0_1_2_0_0 + 0.00998770776548551*G0_0_1_2_0_1 + 0.00489124044679599*G0_0_1_2_0_2 + 0.00998770776548551*G0_0_1_2_1_0 - 0.0229512051734272*G0_0_1_2_1_1 + 0.00844850622628398*G0_0_1_2_1_2 + 0.00489124044679599*G0_0_1_2_2_0 + 0.00844850622628398*G0_0_1_2_2_1 + 0.013750200416867*G0_0_1_2_2_2 - 0.00820907487574138*G0_1_0_0_0_0 + 0.0682379349046012*G0_1_0_0_0_1 + 0.00769600769600769*G0_1_0_0_0_2 + 0.0682379349046012*G0_1_0_0_1_0 + 0.0346491368713589*G0_1_0_0_1_1 + 0.00998770776548551*G0_1_0_0_1_2 + 0.00769600769600769*G0_1_0_0_2_0 + 0.00998770776548551*G0_1_0_0_2_1 + 0.00489124044679599*G0_1_0_0_2_2 + 0.0682379349046012*G0_1_0_1_0_0 + 0.0346491368713589*G0_1_0_1_0_1 + 0.00998770776548551*G0_1_0_1_0_2 + 0.0346491368713589*G0_1_0_1_1_0 - 0.63928170594837*G0_1_0_1_1_1 - 0.0229512051734272*G0_1_0_1_1_2 + 0.00998770776548551*G0_1_0_1_2_0 - 0.0229512051734272*G0_1_0_1_2_1 + 0.00844850622628398*G0_1_0_1_2_2 + 0.00769600769600769*G0_1_0_2_0_0 + 0.00998770776548551*G0_1_0_2_0_1 + 0.00489124044679599*G0_1_0_2_0_2 + 0.00998770776548551*G0_1_0_2_1_0 - 0.0229512051734272*G0_1_0_2_1_1 + 0.00844850622628398*G0_1_0_2_1_2 + 0.00489124044679599*G0_1_0_2_2_0 + 0.00844850622628398*G0_1_0_2_2_1 + 0.013750200416867*G0_1_0_2_2_2 + 0.497675164341829*G0_1_1_0_0_0 + 0.132029287584843*G0_1_1_0_0_1 + 0.0475442253220029*G0_1_1_0_0_2 + 0.132029287584843*G0_1_1_0_1_0 - 0.0291422158088823*G0_1_1_0_1_1 + 0.00998770776548551*G0_1_1_0_1_2 + 0.0475442253220029*G0_1_1_0_2_0 + 0.00998770776548552*G0_1_1_0_2_1 + 0.0101929346373791*G0_1_1_0_2_2 + 0.132029287584843*G0_1_1_1_0_0 - 0.0291422158088823*G0_1_1_1_0_1 + 0.00998770776548551*G0_1_1_1_0_2 - 0.0291422158088823*G0_1_1_1_1_0 - 1.14516594516594*G0_1_1_1_1_1 - 0.0627994227994224*G0_1_1_1_1_2 + 0.00998770776548552*G0_1_1_1_2_0 - 0.0627994227994224*G0_1_1_1_2_1 + 0.00314681203570095*G0_1_1_1_2_2 + 0.0475442253220029*G0_1_1_2_0_0 + 0.00998770776548552*G0_1_1_2_0_1 + 0.0101929346373791*G0_1_1_2_0_2 + 0.00998770776548552*G0_1_1_2_1_0 - 0.0627994227994224*G0_1_1_2_1_1 + 0.00314681203570095*G0_1_1_2_1_2 + 0.0101929346373791*G0_1_1_2_2_0 + 0.00314681203570094*G0_1_1_2_2_1 + 0.0137502004168671*G0_1_1_2_2_2;
    A[89] = 0.000923520923520921*G0_0_0_0_0_0 + 0.000102613435946764*G0_0_0_0_0_1 + 0.0215488215488215*G0_0_0_0_0_2 + 0.000102613435946764*G0_0_0_0_1_0 - 0.000102613435946787*G0_0_0_0_1_1 + 0.0215488215488215*G0_0_0_0_2_0 + 0.068751002084335*G0_0_0_0_2_2 + 0.000102613435946763*G0_0_0_1_0_0 - 0.000102613435946787*G0_0_0_1_0_1 - 0.000102613435946787*G0_0_0_1_1_0 - 0.000923520923520999*G0_0_0_1_1_1 - 0.0215488215488215*G0_0_0_1_1_2 - 0.0215488215488215*G0_0_0_1_2_1 - 0.0687510020843353*G0_0_0_1_2_2 + 0.0215488215488215*G0_0_0_2_0_0 + 0.068751002084335*G0_0_0_2_0_2 - 0.0215488215488215*G0_0_0_2_1_1 - 0.0687510020843353*G0_0_0_2_1_2 + 0.068751002084335*G0_0_0_2_2_0 - 0.0687510020843353*G0_0_0_2_2_1 - 0.00749078082411408*G0_0_1_0_0_0 - 0.0037966971300304*G0_0_1_0_0_1 - 0.00677248677248676*G0_0_1_0_0_2 - 0.0037966971300304*G0_0_1_0_1_0 - 0.00389931056597716*G0_0_1_0_1_1 - 0.00810646143979476*G0_0_1_0_1_2 - 0.00677248677248676*G0_0_1_0_2_0 - 0.00810646143979476*G0_0_1_0_2_1 - 0.0415584415584414*G0_0_1_0_2_2 - 0.0037966971300304*G0_0_1_1_0_0 - 0.00389931056597716*G0_0_1_1_0_1 - 0.00810646143979476*G0_0_1_1_0_2 - 0.00389931056597716*G0_0_1_1_1_0 - 0.00841430174763494*G0_0_1_1_1_1 - 0.0283213083213082*G0_0_1_1_1_2 - 0.00810646143979476*G0_0_1_1_2_0 - 0.0283213083213082*G0_0_1_1_2_1 - 0.110309443642777*G0_0_1_1_2_2 - 0.00677248677248676*G0_0_1_2_0_0 - 0.00810646143979476*G0_0_1_2_0_1 - 0.0415584415584414*G0_0_1_2_0_2 - 0.00810646143979476*G0_0_1_2_1_0 - 0.0283213083213082*G0_0_1_2_1_1 - 0.110309443642777*G0_0_1_2_1_2 - 0.0415584415584414*G0_0_1_2_2_0 - 0.110309443642777*G0_0_1_2_2_1 - 0.638255571588902*G0_0_1_2_2_2 + 0.00420715087381754*G0_1_0_0_0_0 + 0.00933782267115603*G0_1_0_0_0_2 - 0.00420715087381757*G0_1_0_0_1_1 - 0.009337822671156*G0_1_0_0_1_2 + 0.00933782267115603*G0_1_0_0_2_0 - 0.009337822671156*G0_1_0_0_2_1 - 0.00420715087381757*G0_1_0_1_0_1 - 0.009337822671156*G0_1_0_1_0_2 - 0.00420715087381757*G0_1_0_1_1_0 - 0.0336572069905401*G0_1_0_1_1_1 - 0.0840404040404037*G0_1_0_1_1_2 - 0.009337822671156*G0_1_0_1_2_0 - 0.0840404040404037*G0_1_0_1_2_1 - 0.17752124418791*G0_1_0_1_2_2 + 0.00933782267115603*G0_1_0_2_0_0 - 0.009337822671156*G0_1_0_2_0_1 - 0.009337822671156*G0_1_0_2_1_0 - 0.0840404040404037*G0_1_0_2_1_1 - 0.17752124418791*G0_1_0_2_1_2 - 0.17752124418791*G0_1_0_2_2_1 - 0.432002565335897*G0_1_0_2_2_2 - 0.0612602212602209*G0_1_1_0_0_0 - 0.0469969536636201*G0_1_1_0_0_1 - 0.0136475869809203*G0_1_1_0_0_2 - 0.0469969536636201*G0_1_1_0_1_0 - 0.0654673721340385*G0_1_1_0_1_1 - 0.0229854096520763*G0_1_1_0_1_2 - 0.0136475869809203*G0_1_1_0_2_0 - 0.0229854096520763*G0_1_1_0_2_1 - 0.0446368446368446*G0_1_1_0_2_2 - 0.0469969536636201*G0_1_1_1_0_0 - 0.0654673721340385*G0_1_1_1_0_1 - 0.0229854096520763*G0_1_1_1_0_2 - 0.0654673721340385*G0_1_1_1_1_0 - 0.184704184704184*G0_1_1_1_1_1 - 0.101997755331088*G0_1_1_1_1_2 - 0.0229854096520763*G0_1_1_1_2_0 - 0.101997755331088*G0_1_1_1_2_1 - 0.200096200096199*G0_1_1_1_2_2 - 0.0136475869809203*G0_1_1_2_0_0 - 0.0229854096520763*G0_1_1_2_0_1 - 0.0446368446368446*G0_1_1_2_0_2 - 0.0229854096520763*G0_1_1_2_1_0 - 0.101997755331088*G0_1_1_2_1_1 - 0.200096200096199*G0_1_1_2_1_2 - 0.0446368446368446*G0_1_1_2_2_0 - 0.200096200096199*G0_1_1_2_2_1 - 0.635690235690233*G0_1_1_2_2_2;
    A[113] = -A[110] - 0.028090428090428*G0_0_1_0_0_0 - 0.00525893859227194*G0_0_1_0_0_1 - 0.0625941959275292*G0_0_1_0_0_2 - 0.00525893859227194*G0_0_1_0_1_0 - 0.00115440115440122*G0_0_1_0_1_1 - 0.01333974667308*G0_0_1_0_1_2 - 0.0625941959275292*G0_0_1_0_2_0 - 0.01333974667308*G0_0_1_0_2_1 - 0.115953182619849*G0_0_1_0_2_2 - 0.00525893859227194*G0_0_1_1_0_0 - 0.00115440115440122*G0_0_1_1_0_1 - 0.01333974667308*G0_0_1_1_0_2 - 0.00115440115440122*G0_0_1_1_1_0 + 0.00885040885040834*G0_0_1_1_1_1 + 0.00923520923520911*G0_0_1_1_1_2 - 0.01333974667308*G0_0_1_1_2_0 + 0.00923520923520911*G0_0_1_1_2_1 - 0.00718294051627397*G0_0_1_1_2_2 - 0.0625941959275292*G0_0_1_2_0_0 - 0.01333974667308*G0_0_1_2_0_1 - 0.115953182619849*G0_0_1_2_0_2 - 0.01333974667308*G0_0_1_2_1_0 + 0.00923520923520911*G0_0_1_2_1_1 - 0.00718294051627397*G0_0_1_2_1_2 - 0.115953182619849*G0_0_1_2_2_0 - 0.00718294051627398*G0_0_1_2_2_1 - 0.469456469456468*G0_0_1_2_2_2 - 0.370511463844795*G0_1_1_0_0_0 - 0.0668013468013465*G0_1_1_0_0_1 - 0.078524931858265*G0_1_1_0_0_2 - 0.0668013468013465*G0_1_1_0_1_0 - 0.0261407728074394*G0_1_1_0_1_1 - 0.0204970338303671*G0_1_1_0_1_2 - 0.078524931858265*G0_1_1_0_2_0 - 0.0204970338303671*G0_1_1_0_2_1 - 0.104152637485971*G0_1_1_0_2_2 - 0.0668013468013465*G0_1_1_1_0_0 - 0.0261407728074394*G0_1_1_1_0_1 - 0.0204970338303671*G0_1_1_1_0_2 - 0.0261407728074394*G0_1_1_1_1_0 - 0.00456629789963152*G0_1_1_1_1_1 + 0.000230880230880149*G0_1_1_1_1_2 - 0.0204970338303671*G0_1_1_1_2_0 + 0.000230880230880149*G0_1_1_1_2_1 - 0.0220618887285555*G0_1_1_1_2_2 - 0.078524931858265*G0_1_1_2_0_0 - 0.0204970338303671*G0_1_1_2_0_1 - 0.104152637485971*G0_1_1_2_0_2 - 0.0204970338303671*G0_1_1_2_1_0 + 0.000230880230880146*G0_1_1_2_1_1 - 0.0220618887285555*G0_1_1_2_1_2 - 0.104152637485971*G0_1_1_2_2_0 - 0.0220618887285555*G0_1_1_2_2_1 - 0.45509058842392*G0_1_1_2_2_2;
    A[97] = A[113] - 0.0439442039442037*G0_0_0_0_0_0 - 0.00813211479878143*G0_0_0_0_0_1 - 0.00436107102773771*G0_0_0_0_0_2 - 0.00813211479878142*G0_0_0_0_1_0 - 0.00305274971941638*G0_0_0_0_1_1 - 0.00461760461760462*G0_0_0_0_1_2 - 0.00436107102773771*G0_0_0_0_2_0 - 0.00461760461760462*G0_0_0_0_2_1 - 0.0260125060125061*G0_0_0_0_2_2 - 0.00813211479878142*G0_0_0_1_0_0 - 0.00305274971941638*G0_0_0_1_0_1 - 0.00461760461760462*G0_0_0_1_0_2 - 0.00305274971941638*G0_0_0_1_1_0 - 0.00561808561808563*G0_0_0_1_1_1 - 0.00487413820747155*G0_0_0_1_1_2 - 0.00461760461760462*G0_0_0_1_2_0 - 0.00487413820747154*G0_0_0_1_2_1 + 0.0106204906204905*G0_0_0_1_2_2 - 0.00436107102773771*G0_0_0_2_0_0 - 0.00461760461760462*G0_0_0_2_0_1 - 0.0260125060125061*G0_0_0_2_0_2 - 0.00461760461760462*G0_0_0_2_1_0 - 0.00487413820747154*G0_0_0_2_1_1 + 0.0106204906204905*G0_0_0_2_1_2 - 0.0260125060125061*G0_0_0_2_2_0 + 0.0106204906204905*G0_0_0_2_2_1 + 0.286291486291483*G0_0_0_2_2_2 - 0.175084175084175*G0_0_1_0_0_0 - 0.0173673240339907*G0_0_1_0_0_1 - 0.05700176366843*G0_0_1_0_0_2 - 0.0173673240339907*G0_0_1_0_1_0 - 0.00397627064293731*G0_0_1_0_1_1 - 0.00461760461760459*G0_0_1_0_1_2 - 0.05700176366843*G0_0_1_0_2_0 - 0.00461760461760459*G0_0_1_0_2_1 + 0.0266281866281867*G0_0_1_0_2_2 - 0.0173673240339907*G0_0_1_1_0_0 - 0.00397627064293731*G0_0_1_1_0_1 - 0.00461760461760459*G0_0_1_1_0_2 - 0.00397627064293731*G0_0_1_1_1_0 - 0.00561808561808557*G0_0_1_1_1_1 - 0.00395061728395059*G0_0_1_1_1_2 - 0.00461760461760459*G0_0_1_1_2_0 - 0.00395061728395059*G0_0_1_1_2_1 + 0.0198556998556998*G0_0_1_1_2_2 - 0.05700176366843*G0_0_1_2_0_0 - 0.00461760461760459*G0_0_1_2_0_1 + 0.0266281866281868*G0_0_1_2_0_2 - 0.00461760461760458*G0_0_1_2_1_0 - 0.00395061728395059*G0_0_1_2_1_1 + 0.0198556998556998*G0_0_1_2_1_2 + 0.0266281866281868*G0_0_1_2_2_0 + 0.0198556998556998*G0_0_1_2_2_1 + 0.417431457431455*G0_0_1_2_2_2 + 0.0833477633477635*G0_1_0_0_0_0 + 0.00374539041205711*G0_1_0_0_0_1 + 0.00659291325957988*G0_1_0_0_0_2 + 0.00374539041205711*G0_1_0_0_1_0 - 0.00138528138528137*G0_1_0_0_1_1 - 0.00461760461760461*G0_1_0_0_1_2 + 0.00659291325957988*G0_1_0_0_2_0 - 0.00461760461760461*G0_1_0_0_2_1 - 0.0369664902998236*G0_1_0_0_2_2 + 0.00374539041205711*G0_1_0_1_0_0 - 0.00138528138528137*G0_1_0_1_0_1 - 0.00461760461760461*G0_1_0_1_0_2 - 0.00138528138528137*G0_1_0_1_1_0 - 0.00561808561808563*G0_1_0_1_1_1 - 0.00654160654160652*G0_1_0_1_1_2 - 0.00461760461760461*G0_1_0_1_2_0 - 0.00654160654160652*G0_1_0_1_2_1 - 0.001257014590348*G0_1_0_1_2_2 + 0.00659291325957988*G0_1_0_2_0_0 - 0.00461760461760461*G0_1_0_2_0_1 - 0.0369664902998236*G0_1_0_2_0_2 - 0.00461760461760461*G0_1_0_2_1_0 - 0.00654160654160652*G0_1_0_2_1_1 - 0.00125701459034799*G0_1_0_2_1_2 - 0.0369664902998236*G0_1_0_2_2_0 - 0.00125701459034799*G0_1_0_2_2_1 + 0.158999518999517*G0_1_0_2_2_2 - 0.334083694083692*G0_1_1_0_0_0 - 0.0161103094436427*G0_1_1_0_0_1 - 0.0200352733686065*G0_1_1_0_0_2 - 0.0161103094436427*G0_1_1_0_1_0 + 0.00256533589866921*G0_1_1_0_1_1 - 0.0200352733686065*G0_1_1_0_2_0 + 0.0200352733686068*G0_1_1_0_2_2 - 0.0161103094436427*G0_1_1_1_0_0 + 0.00256533589866921*G0_1_1_1_0_1 + 0.00256533589866921*G0_1_1_1_1_0 - 0.00256533589866921*G0_1_1_1_1_2 - 0.00256533589866921*G0_1_1_1_2_1 + 0.0161103094436428*G0_1_1_1_2_2 - 0.0200352733686065*G0_1_1_2_0_0 + 0.0200352733686068*G0_1_1_2_0_2 - 0.00256533589866921*G0_1_1_2_1_1 + 0.0161103094436428*G0_1_1_2_1_2 + 0.0200352733686068*G0_1_1_2_2_0 + 0.0161103094436428*G0_1_1_2_2_1 + 0.334083694083692*G0_1_1_2_2_2;
    A[111] = A[97] + 0.294757094757095*G0_0_1_0_0_0 + 0.0271925605258939*G0_0_1_0_0_1 + 0.129549462882796*G0_0_1_0_0_2 + 0.0271925605258939*G0_0_1_0_1_0 + 0.00464325797659132*G0_0_1_0_1_1 + 0.0133140933140933*G0_0_1_0_1_2 + 0.129549462882796*G0_0_1_0_2_0 + 0.0133140933140933*G0_0_1_0_2_1 + 0.0659547859547856*G0_0_1_0_2_2 + 0.0271925605258939*G0_0_1_1_0_0 + 0.00464325797659132*G0_0_1_1_0_1 + 0.0133140933140933*G0_0_1_1_0_2 + 0.00464325797659132*G0_0_1_1_1_0 + 0.00205226871893538*G0_0_1_1_1_2 + 0.0133140933140933*G0_0_1_1_2_0 + 0.00205226871893538*G0_0_1_1_2_1 + 0.00607984607984605*G0_0_1_1_2_2 + 0.129549462882796*G0_0_1_2_0_0 + 0.0133140933140933*G0_0_1_2_0_1 + 0.0659547859547856*G0_0_1_2_0_2 + 0.0133140933140933*G0_0_1_2_1_0 + 0.00205226871893538*G0_0_1_2_1_1 + 0.00607984607984605*G0_0_1_2_1_2 + 0.0659547859547856*G0_0_1_2_2_0 + 0.00607984607984605*G0_0_1_2_2_1 + 0.0363251563251558*G0_0_1_2_2_2 - 0.294757094757095*G0_1_0_0_0_0 - 0.0271925605258939*G0_1_0_0_0_1 - 0.129549462882796*G0_1_0_0_0_2 - 0.0271925605258939*G0_1_0_0_1_0 - 0.00464325797659132*G0_1_0_0_1_1 - 0.0133140933140933*G0_1_0_0_1_2 - 0.129549462882796*G0_1_0_0_2_0 - 0.0133140933140933*G0_1_0_0_2_1 - 0.0659547859547856*G0_1_0_0_2_2 - 0.0271925605258939*G0_1_0_1_0_0 - 0.00464325797659132*G0_1_0_1_0_1 - 0.0133140933140933*G0_1_0_1_0_2 - 0.00464325797659132*G0_1_0_1_1_0 - 0.00205226871893538*G0_1_0_1_1_2 - 0.0133140933140933*G0_1_0_1_2_0 - 0.00205226871893538*G0_1_0_1_2_1 - 0.00607984607984604*G0_1_0_1_2_2 - 0.129549462882796*G0_1_0_2_0_0 - 0.0133140933140933*G0_1_0_2_0_1 - 0.0659547859547856*G0_1_0_2_0_2 - 0.0133140933140933*G0_1_0_2_1_0 - 0.00205226871893538*G0_1_0_2_1_1 - 0.00607984607984603*G0_1_0_2_1_2 - 0.0659547859547856*G0_1_0_2_2_0 - 0.00607984607984603*G0_1_0_2_2_1 - 0.0363251563251557*G0_1_0_2_2_2;
    A[195] = A[181] + 0.116363636363636*G0_0_0_0_0_0 + 0.00441237774571106*G0_0_0_0_0_1 + 0.0282186948853614*G0_0_0_0_0_2 + 0.00441237774571106*G0_0_0_0_1_0 - 0.00441237774571108*G0_0_0_0_1_1 + 0.0282186948853614*G0_0_0_0_2_0 + 0.0118518518518518*G0_0_0_0_2_2 + 0.00441237774571106*G0_0_0_1_0_0 - 0.00441237774571108*G0_0_0_1_0_1 - 0.00441237774571108*G0_0_0_1_1_0 - 0.116363636363636*G0_0_0_1_1_1 - 0.0282186948853614*G0_0_0_1_1_2 - 0.0282186948853614*G0_0_0_1_2_1 - 0.0118518518518518*G0_0_0_1_2_2 + 0.0282186948853614*G0_0_0_2_0_0 + 0.0118518518518518*G0_0_0_2_0_2 - 0.0282186948853614*G0_0_0_2_1_1 - 0.0118518518518518*G0_0_0_2_1_2 + 0.0118518518518518*G0_0_0_2_2_0 - 0.0118518518518518*G0_0_0_2_2_1 + 0.059515792849126*G0_0_1_0_0_0 + 0.00387365720699055*G0_0_1_0_0_1 + 0.00715728715728711*G0_0_1_0_0_2 + 0.00387365720699055*G0_0_1_0_1_0 - 0.000538720538720515*G0_0_1_0_1_1 - 0.00107744107744107*G0_0_1_0_1_2 + 0.00715728715728711*G0_0_1_0_2_0 - 0.00107744107744107*G0_0_1_0_2_1 - 0.00128266794933463*G0_0_1_0_2_2 + 0.00387365720699055*G0_0_1_1_0_0 - 0.000538720538720515*G0_0_1_1_0_1 - 0.00107744107744107*G0_0_1_1_0_2 - 0.000538720538720516*G0_0_1_1_1_0 - 0.0568478435145097*G0_0_1_1_1_1 - 0.0210614077280742*G0_0_1_1_1_2 - 0.00107744107744107*G0_0_1_1_2_0 - 0.0210614077280742*G0_0_1_1_2_1 - 0.0131345198011864*G0_0_1_1_2_2 + 0.00715728715728711*G0_0_1_2_0_0 - 0.00107744107744107*G0_0_1_2_0_1 - 0.00128266794933463*G0_0_1_2_0_2 - 0.00107744107744107*G0_0_1_2_1_0 - 0.0210614077280742*G0_0_1_2_1_1 - 0.0131345198011864*G0_0_1_2_1_2 - 0.00128266794933463*G0_0_1_2_2_0 - 0.0131345198011864*G0_0_1_2_2_1 - 0.00590027256693925*G0_0_1_2_2_2 + 0.0482796216129543*G0_1_0_0_0_0 + 0.00433541766875097*G0_1_0_0_0_1 + 0.00495109828443158*G0_1_0_0_0_2 + 0.00433541766875097*G0_1_0_0_1_0 + 0.00082090748757415*G0_1_0_0_1_2 + 0.00495109828443158*G0_1_0_0_2_0 + 0.00082090748757415*G0_1_0_0_2_1 + 0.00212922879589546*G0_1_0_0_2_2 + 0.00433541766875097*G0_1_0_1_0_0 + 0.00082090748757415*G0_1_0_1_0_2 - 0.0680840147506811*G0_1_0_1_1_1 - 0.0232675966009298*G0_1_0_1_1_2 + 0.00082090748757415*G0_1_0_1_2_0 - 0.0232675966009298*G0_1_0_1_2_1 - 0.0097226230559563*G0_1_0_1_2_2 + 0.00495109828443158*G0_1_0_2_0_0 + 0.00082090748757415*G0_1_0_2_0_1 + 0.00212922879589546*G0_1_0_2_0_2 + 0.00082090748757415*G0_1_0_2_1_0 - 0.0232675966009298*G0_1_0_2_1_1 - 0.00972262305595631*G0_1_0_2_1_2 + 0.00212922879589546*G0_1_0_2_2_0 - 0.0097226230559563*G0_1_0_2_2_1 - 0.00482283148949812*G0_1_0_2_2_2 + 0.0595157928491255*G0_1_1_0_0_0 + 0.00720859387526052*G0_1_1_0_0_1 + 0.00382235048901712*G0_1_1_0_0_2 + 0.00720859387526052*G0_1_1_0_1_0 - 0.00341189674523002*G0_1_1_0_1_1 - 0.000128266794933453*G0_1_1_0_1_2 + 0.00382235048901712*G0_1_1_0_2_0 - 0.000128266794933453*G0_1_1_0_2_1 - 0.000307840307840303*G0_1_1_0_2_2 + 0.00720859387526052*G0_1_1_1_0_0 - 0.00341189674523001*G0_1_1_1_0_1 - 0.000128266794933453*G0_1_1_1_0_2 - 0.00341189674523001*G0_1_1_1_1_0 - 0.0680840147506807*G0_1_1_1_1_1 - 0.0199326599326597*G0_1_1_1_1_2 - 0.000128266794933453*G0_1_1_1_2_0 - 0.0199326599326597*G0_1_1_1_2_1 - 0.0106974506974506*G0_1_1_1_2_2 + 0.00382235048901712*G0_1_1_2_0_0 - 0.000128266794933453*G0_1_1_2_0_1 - 0.000307840307840303*G0_1_1_2_0_2 - 0.000128266794933453*G0_1_1_2_1_0 - 0.0199326599326597*G0_1_1_2_1_1 - 0.0106974506974506*G0_1_1_2_1_2 - 0.000307840307840303*G0_1_1_2_2_0 - 0.0106974506974506*G0_1_1_2_2_1 - 0.00536155202821865*G0_1_1_2_2_2;
    A[188] = A[132] - 0.0412506012506013*G0_0_1_0_0_0 + 0.00728555395222051*G0_0_1_0_0_1 - 0.0202148468815134*G0_0_1_0_0_2 + 0.00728555395222051*G0_0_1_0_1_0 + 0.00892736892736886*G0_0_1_0_1_1 - 0.000410453743787075*G0_0_1_0_1_2 - 0.0202148468815134*G0_0_1_0_2_0 - 0.000410453743787075*G0_0_1_0_2_1 - 0.00872214205547528*G0_0_1_0_2_2 + 0.00728555395222052*G0_0_1_1_0_0 + 0.00892736892736886*G0_0_1_1_0_1 - 0.000410453743787075*G0_0_1_1_0_2 + 0.00892736892736886*G0_0_1_1_1_0 + 0.00800384800384795*G0_0_1_1_1_1 + 0.00564373897707226*G0_0_1_1_1_2 - 0.000410453743787075*G0_0_1_1_2_0 + 0.00564373897707227*G0_0_1_1_2_1 + 0.00153920153920153*G0_0_1_1_2_2 - 0.0202148468815134*G0_0_1_2_0_0 - 0.000410453743787075*G0_0_1_2_0_1 - 0.00872214205547529*G0_0_1_2_0_2 - 0.000410453743787075*G0_0_1_2_1_0 + 0.00564373897707226*G0_0_1_2_1_1 + 0.00153920153920152*G0_0_1_2_1_2 - 0.00872214205547528*G0_0_1_2_2_0 + 0.00153920153920152*G0_0_1_2_2_1 + 0.0523328523328519*G0_0_1_2_2_2 + 0.0412506012506014*G0_1_0_0_0_0 - 0.00728555395222051*G0_1_0_0_0_1 + 0.0202148468815134*G0_1_0_0_0_2 - 0.00728555395222051*G0_1_0_0_1_0 - 0.00892736892736886*G0_1_0_0_1_1 + 0.000410453743787077*G0_1_0_0_1_2 + 0.0202148468815134*G0_1_0_0_2_0 + 0.000410453743787077*G0_1_0_0_2_1 + 0.00872214205547528*G0_1_0_0_2_2 - 0.00728555395222051*G0_1_0_1_0_0 - 0.00892736892736886*G0_1_0_1_0_1 + 0.000410453743787076*G0_1_0_1_0_2 - 0.00892736892736886*G0_1_0_1_1_0 - 0.00800384800384795*G0_1_0_1_1_1 - 0.00564373897707226*G0_1_0_1_1_2 + 0.000410453743787076*G0_1_0_1_2_0 - 0.00564373897707226*G0_1_0_1_2_1 - 0.00153920153920153*G0_1_0_1_2_2 + 0.0202148468815134*G0_1_0_2_0_0 + 0.000410453743787075*G0_1_0_2_0_1 + 0.00872214205547529*G0_1_0_2_0_2 + 0.000410453743787075*G0_1_0_2_1_0 - 0.00564373897707226*G0_1_0_2_1_1 - 0.00153920153920153*G0_1_0_2_1_2 + 0.00872214205547528*G0_1_0_2_2_0 - 0.00153920153920153*G0_1_0_2_2_1 - 0.0523328523328519*G0_1_0_2_2_2;
    A[14] = A[195] + 0.000230880230880229*G0_0_0_0_1_1 + 0.000949174282507614*G0_0_0_0_1_2 + 0.000949174282507614*G0_0_0_0_2_1 - 0.00212922879589541*G0_0_0_0_2_2 + 0.000230880230880228*G0_0_0_1_0_1 + 0.000949174282507614*G0_0_0_1_0_2 + 0.000230880230880228*G0_0_0_1_1_0 + 0.0514862914862911*G0_0_0_1_1_1 + 0.0103639570306236*G0_0_0_1_1_2 + 0.000949174282507615*G0_0_0_1_2_0 + 0.0103639570306236*G0_0_0_1_2_1 - 0.0067981401314734*G0_0_0_1_2_2 + 0.000949174282507614*G0_0_0_2_0_1 - 0.00212922879589541*G0_0_0_2_0_2 + 0.000949174282507615*G0_0_0_2_1_0 + 0.0103639570306236*G0_0_0_2_1_1 - 0.0067981401314734*G0_0_0_2_1_2 - 0.00212922879589541*G0_0_0_2_2_0 - 0.0067981401314734*G0_0_0_2_2_1 - 0.0621837421837417*G0_0_0_2_2_2 + 0.00328362995029662*G0_0_1_0_0_1 - 0.00328362995029656*G0_0_1_0_0_2 + 0.00328362995029662*G0_0_1_0_1_0 - 0.000743947410614085*G0_0_1_0_1_1 - 0.00328362995029656*G0_0_1_0_2_0 + 0.000743947410614101*G0_0_1_0_2_2 + 0.00328362995029663*G0_0_1_1_0_0 - 0.000743947410614084*G0_0_1_1_0_1 - 0.000743947410614084*G0_0_1_1_1_0 + 0.0509475709475705*G0_0_1_1_1_1 + 0.00792688792688783*G0_0_1_1_1_2 + 0.00792688792688783*G0_0_1_1_2_1 - 0.00792688792688787*G0_0_1_1_2_2 - 0.00328362995029656*G0_0_1_2_0_0 + 0.000743947410614101*G0_0_1_2_0_2 + 0.00792688792688784*G0_0_1_2_1_1 - 0.00792688792688787*G0_0_1_2_1_2 + 0.0007439474106141*G0_0_1_2_2_0 - 0.00792688792688787*G0_0_1_2_2_1 - 0.0509475709475705*G0_0_1_2_2_2 - 0.00338624338624332*G0_1_0_0_0_1 + 0.00338624338624342*G0_1_0_0_0_2 - 0.00338624338624332*G0_1_0_0_1_0 + 0.00310405643738975*G0_1_0_0_1_1 + 0.00338624338624342*G0_1_0_0_2_0 - 0.00310405643738975*G0_1_0_0_2_2 - 0.00338624338624332*G0_1_0_1_0_0 + 0.00310405643738975*G0_1_0_1_0_1 + 0.00310405643738975*G0_1_0_1_1_0 + 0.0627224627224623*G0_1_0_1_1_1 + 0.00923520923520917*G0_1_0_1_1_2 + 0.00923520923520917*G0_1_0_1_2_1 - 0.00923520923520917*G0_1_0_1_2_2 + 0.00338624338624342*G0_1_0_2_0_0 - 0.00310405643738975*G0_1_0_2_0_2 + 0.00923520923520917*G0_1_0_2_1_1 - 0.00923520923520917*G0_1_0_2_1_2 - 0.00310405643738975*G0_1_0_2_2_0 - 0.00923520923520917*G0_1_0_2_2_1 - 0.0627224627224624*G0_1_0_2_2_2 + 0.00212922879589539*G0_1_1_0_1_1 - 0.000949174282507614*G0_1_1_0_1_2 - 0.000949174282507614*G0_1_1_0_2_1 - 0.000230880230880229*G0_1_1_0_2_2 + 0.00212922879589539*G0_1_1_1_0_1 - 0.000949174282507614*G0_1_1_1_0_2 + 0.00212922879589539*G0_1_1_1_1_0 + 0.0621837421837415*G0_1_1_1_1_1 + 0.00679814013147336*G0_1_1_1_1_2 - 0.000949174282507614*G0_1_1_1_2_0 + 0.00679814013147336*G0_1_1_1_2_1 - 0.0103639570306236*G0_1_1_1_2_2 - 0.000949174282507614*G0_1_1_2_0_1 - 0.000230880230880228*G0_1_1_2_0_2 - 0.000949174282507614*G0_1_1_2_1_0 + 0.00679814013147337*G0_1_1_2_1_1 - 0.0103639570306236*G0_1_1_2_1_2 - 0.000230880230880228*G0_1_1_2_2_0 - 0.0103639570306236*G0_1_1_2_2_1 - 0.0514862914862912*G0_1_1_2_2_2;
    A[56] = -A[176] + 0.208613115279781*G0_0_0_0_0_0 + 0.0559243225909891*G0_0_0_0_0_1 + 0.0515119448452778*G0_0_0_0_0_2 + 0.0559243225909891*G0_0_0_0_1_0 + 0.0855111966223074*G0_0_0_0_1_1 + 0.0165891721447276*G0_0_0_0_1_2 + 0.0515119448452778*G0_0_0_0_2_0 + 0.0165891721447276*G0_0_0_0_2_1 + 0.0334861845972955*G0_0_0_0_2_2 + 0.0559243225909891*G0_0_0_1_0_0 + 0.0855111966223074*G0_0_0_1_0_1 + 0.0165891721447276*G0_0_0_1_0_2 + 0.0855111966223074*G0_0_0_1_1_0 + 0.539746673080005*G0_0_0_1_1_1 + 0.0294158516380738*G0_0_0_1_1_2 + 0.0165891721447276*G0_0_0_1_2_0 + 0.0294158516380738*G0_0_0_1_2_1 + 0.0104323659879215*G0_0_0_1_2_2 + 0.0515119448452778*G0_0_0_2_0_0 + 0.0165891721447276*G0_0_0_2_0_1 + 0.0334861845972955*G0_0_0_2_0_2 + 0.0165891721447276*G0_0_0_2_1_0 + 0.0294158516380738*G0_0_0_2_1_1 + 0.0104323659879215*G0_0_0_2_1_2 + 0.0334861845972955*G0_0_0_2_2_0 + 0.0104323659879215*G0_0_0_2_2_1 + 0.0463812730479394*G0_0_0_2_2_2 - 0.00769600769600778*G0_0_1_0_0_0 - 0.0123136123136122*G0_0_1_0_0_1 - 0.00256533589866923*G0_0_1_0_0_2 - 0.0123136123136122*G0_0_1_0_1_0 - 0.0266794933461598*G0_0_1_0_1_1 - 0.00615680615680612*G0_0_1_0_1_2 - 0.00256533589866923*G0_0_1_0_2_0 - 0.00615680615680612*G0_0_1_0_2_1 - 0.00256533589866921*G0_0_1_0_2_2 - 0.0123136123136122*G0_0_1_1_0_0 - 0.0266794933461598*G0_0_1_1_0_1 - 0.00615680615680612*G0_0_1_1_0_2 - 0.0266794933461598*G0_0_1_1_1_0 + 0.301683501683502*G0_0_1_1_1_1 - 0.0266794933461598*G0_0_1_1_1_2 - 0.00615680615680612*G0_0_1_1_2_0 - 0.0266794933461598*G0_0_1_1_2_1 - 0.0123136123136123*G0_0_1_1_2_2 - 0.00256533589866923*G0_0_1_2_0_0 - 0.00615680615680612*G0_0_1_2_0_1 - 0.00256533589866921*G0_0_1_2_0_2 - 0.00615680615680612*G0_0_1_2_1_0 - 0.0266794933461599*G0_0_1_2_1_1 - 0.0123136123136123*G0_0_1_2_1_2 - 0.00256533589866921*G0_0_1_2_2_0 - 0.0123136123136123*G0_0_1_2_2_1 - 0.00769600769600762*G0_0_1_2_2_2;
    A[99] = A[56] - 0.299939073272405*G0_0_0_0_0_0 - 0.004001924001924*G0_0_0_0_0_1 - 0.052743306076639*G0_0_0_0_0_2 - 0.004001924001924*G0_0_0_0_1_0 + 0.00400192400192397*G0_0_0_0_1_1 - 0.052743306076639*G0_0_0_0_2_0 - 0.019496552829886*G0_0_0_0_2_2 - 0.004001924001924*G0_0_0_1_0_0 + 0.00400192400192396*G0_0_0_1_0_1 + 0.00400192400192396*G0_0_0_1_1_0 + 0.299939073272404*G0_0_0_1_1_1 + 0.0527433060766391*G0_0_0_1_1_2 + 0.0527433060766391*G0_0_0_1_2_1 + 0.019496552829886*G0_0_0_1_2_2 - 0.052743306076639*G0_0_0_2_0_0 - 0.019496552829886*G0_0_0_2_0_2 + 0.0527433060766391*G0_0_0_2_1_1 + 0.019496552829886*G0_0_0_2_1_2 - 0.019496552829886*G0_0_0_2_2_0 + 0.019496552829886*G0_0_0_2_2_1 + 0.253968253968252*G0_0_1_0_0_0 + 0.0562663673774781*G0_0_1_0_0_1 + 0.0509646731868952*G0_0_1_0_0_2 + 0.0562663673774781*G0_0_1_0_1_0 + 0.0602682913794021*G0_0_1_0_1_1 + 0.0189150766928544*G0_0_1_0_1_2 + 0.0509646731868952*G0_0_1_0_2_0 + 0.0189150766928544*G0_0_1_0_2_1 + 0.020420073753407*G0_0_1_0_2_2 + 0.0562663673774781*G0_0_1_1_0_0 + 0.0602682913794021*G0_0_1_1_0_1 + 0.0189150766928544*G0_0_1_1_0_2 + 0.0602682913794021*G0_0_1_1_1_0 + 0.553907327240657*G0_0_1_1_1_1 + 0.103707979263534*G0_0_1_1_1_2 + 0.0189150766928544*G0_0_1_1_2_0 + 0.103707979263534*G0_0_1_1_2_1 + 0.0399166265832931*G0_0_1_1_2_2 + 0.0509646731868952*G0_0_1_2_0_0 + 0.0189150766928544*G0_0_1_2_0_1 + 0.020420073753407*G0_0_1_2_0_2 + 0.0189150766928544*G0_0_1_2_1_0 + 0.103707979263534*G0_0_1_2_1_1 + 0.0399166265832931*G0_0_1_2_1_2 + 0.020420073753407*G0_0_1_2_2_0 + 0.0399166265832931*G0_0_1_2_2_1 + 0.0480230880230878*G0_0_1_2_2_2 + 0.547955747955746*G0_1_0_0_0_0 + 0.0172732617177062*G0_1_0_0_0_1 + 0.0217198439420661*G0_1_0_0_0_2 + 0.0172732617177062*G0_1_0_0_1_0 + 0.0212751857196301*G0_1_0_0_1_1 + 0.00660146437924214*G0_1_0_0_1_2 + 0.0217198439420661*G0_1_0_0_2_0 + 0.00660146437924214*G0_1_0_0_2_1 + 0.00554112554112554*G0_1_0_0_2_2 + 0.0172732617177062*G0_1_0_1_0_0 + 0.0212751857196301*G0_1_0_1_0_1 + 0.00660146437924214*G0_1_0_1_0_2 + 0.0212751857196301*G0_1_0_1_1_0 + 0.847894821228151*G0_1_0_1_1_1 + 0.0744631500187052*G0_1_0_1_1_2 + 0.00660146437924214*G0_1_0_1_2_0 + 0.0744631500187052*G0_1_0_1_2_1 + 0.0250376783710115*G0_1_0_1_2_2 + 0.0217198439420661*G0_1_0_2_0_0 + 0.00660146437924214*G0_1_0_2_0_1 + 0.00554112554112554*G0_1_0_2_0_2 + 0.00660146437924214*G0_1_0_2_1_0 + 0.0744631500187052*G0_1_0_2_1_1 + 0.0250376783710115*G0_1_0_2_1_2 + 0.00554112554112554*G0_1_0_2_2_0 + 0.0250376783710115*G0_1_0_2_2_1 + 0.0326310726310724*G0_1_0_2_2_2 - 0.259611992945325*G0_1_1_0_0_0 - 0.0198385976163753*G0_1_1_0_0_1 + 0.0085511196622308*G0_1_1_0_0_2 - 0.0198385976163753*G0_1_1_0_1_0 + 0.0973801507134835*G0_1_1_0_1_1 + 0.0127582705360483*G0_1_1_0_1_2 + 0.0085511196622308*G0_1_1_0_2_0 + 0.0127582705360483*G0_1_1_0_2_1 + 0.0125530436641547*G0_1_1_0_2_2 - 0.0198385976163753*G0_1_1_1_0_0 + 0.0973801507134835*G0_1_1_1_0_1 + 0.0127582705360483*G0_1_1_1_0_2 + 0.0973801507134835*G0_1_1_1_1_0 + 1.36147506814173*G0_1_1_1_1_1 + 0.11687670354337*G0_1_1_1_1_2 + 0.0127582705360483*G0_1_1_1_2_0 + 0.11687670354337*G0_1_1_1_2_1 + 0.0329047084602639*G0_1_1_1_2_2 + 0.0085511196622308*G0_1_1_2_0_0 + 0.0127582705360483*G0_1_1_2_0_1 + 0.0125530436641547*G0_1_1_2_0_2 + 0.0127582705360483*G0_1_1_2_1_0 + 0.11687670354337*G0_1_1_2_1_1 + 0.0329047084602639*G0_1_1_2_1_2 + 0.0125530436641547*G0_1_1_2_2_0 + 0.0329047084602639*G0_1_1_2_2_1 + 0.0403270803270801*G0_1_1_2_2_2;
    A[125] = A[56] - 0.0403270803270801*G0_0_0_0_0_0 - 0.0125530436641547*G0_0_0_0_0_1 - 0.0329047084602638*G0_0_0_0_0_2 - 0.0125530436641547*G0_0_0_0_1_0 - 0.00855111966223076*G0_0_0_0_1_1 - 0.0127582705360483*G0_0_0_0_1_2 - 0.0329047084602638*G0_0_0_0_2_0 - 0.0127582705360483*G0_0_0_0_2_1 - 0.11687670354337*G0_0_0_0_2_2 - 0.0125530436641547*G0_0_0_1_0_0 - 0.00855111966223077*G0_0_0_1_0_1 - 0.0127582705360483*G0_0_0_1_0_2 - 0.00855111966223077*G0_0_0_1_1_0 + 0.259611992945324*G0_0_0_1_1_1 + 0.0198385976163752*G0_0_0_1_1_2 - 0.0127582705360483*G0_0_0_1_2_0 + 0.0198385976163752*G0_0_0_1_2_1 - 0.0973801507134836*G0_0_0_1_2_2 - 0.0329047084602638*G0_0_0_2_0_0 - 0.0127582705360483*G0_0_0_2_0_1 - 0.11687670354337*G0_0_0_2_0_2 - 0.0127582705360483*G0_0_0_2_1_0 + 0.0198385976163752*G0_0_0_2_1_1 - 0.0973801507134836*G0_0_0_2_1_2 - 0.11687670354337*G0_0_0_2_2_0 - 0.0973801507134836*G0_0_0_2_2_1 - 1.36147506814173*G0_0_0_2_2_2 + 0.00530169419058306*G0_0_1_0_0_1 - 0.00530169419058307*G0_0_1_0_0_2 + 0.00530169419058306*G0_0_1_0_1_0 + 0.0398482176259951*G0_0_1_0_1_1 - 0.00530169419058307*G0_0_1_0_2_0 - 0.0398482176259953*G0_0_1_0_2_2 + 0.00530169419058306*G0_0_1_1_0_0 + 0.0398482176259951*G0_0_1_1_0_1 + 0.0398482176259951*G0_0_1_1_1_0 + 0.505884239217569*G0_0_1_1_1_1 + 0.0637913526802412*G0_0_1_1_1_2 + 0.0637913526802412*G0_0_1_1_2_1 - 0.0637913526802413*G0_0_1_1_2_2 - 0.00530169419058307*G0_0_1_2_0_0 - 0.0398482176259953*G0_0_1_2_0_2 + 0.0637913526802412*G0_0_1_2_1_1 - 0.0637913526802413*G0_0_1_2_1_2 - 0.0398482176259953*G0_0_1_2_2_0 - 0.0637913526802412*G0_0_1_2_2_1 - 0.50588423921757*G0_0_1_2_2_2 - 0.00444658222435997*G0_1_0_0_0_1 + 0.00444658222436*G0_1_0_0_0_2 - 0.00444658222435997*G0_1_0_0_1_0 + 0.0157340601785046*G0_1_0_0_1_1 + 0.00444658222436*G0_1_0_0_2_0 - 0.0157340601785045*G0_1_0_0_2_2 - 0.00444658222435997*G0_1_0_1_0_0 + 0.0157340601785046*G0_1_0_1_0_1 + 0.0157340601785046*G0_1_0_1_1_0 + 0.815263748597078*G0_1_0_1_1_1 + 0.0494254716476936*G0_1_0_1_1_2 + 0.0494254716476936*G0_1_0_1_2_1 - 0.0494254716476936*G0_1_0_1_2_2 + 0.00444658222436*G0_1_0_2_0_0 - 0.0157340601785045*G0_1_0_2_0_2 + 0.0494254716476936*G0_1_0_2_1_1 - 0.0494254716476936*G0_1_0_2_1_2 - 0.0157340601785045*G0_1_0_2_2_0 - 0.0494254716476936*G0_1_0_2_2_1 - 0.815263748597077*G0_1_0_2_2_2 + 0.0403270803270801*G0_1_1_0_0_0 + 0.0329047084602638*G0_1_1_0_0_1 + 0.0125530436641548*G0_1_1_0_0_2 + 0.0329047084602638*G0_1_1_0_1_0 + 0.11687670354337*G0_1_1_0_1_1 + 0.0127582705360483*G0_1_1_0_1_2 + 0.0125530436641548*G0_1_1_0_2_0 + 0.0127582705360483*G0_1_1_0_2_1 + 0.00855111966223082*G0_1_1_0_2_2 + 0.0329047084602638*G0_1_1_1_0_0 + 0.11687670354337*G0_1_1_1_0_1 + 0.0127582705360483*G0_1_1_1_0_2 + 0.11687670354337*G0_1_1_1_1_0 + 1.36147506814173*G0_1_1_1_1_1 + 0.0973801507134835*G0_1_1_1_1_2 + 0.0127582705360483*G0_1_1_1_2_0 + 0.0973801507134835*G0_1_1_1_2_1 - 0.0198385976163752*G0_1_1_1_2_2 + 0.0125530436641548*G0_1_1_2_0_0 + 0.0127582705360483*G0_1_1_2_0_1 + 0.00855111966223082*G0_1_1_2_0_2 + 0.0127582705360483*G0_1_1_2_1_0 + 0.0973801507134835*G0_1_1_2_1_1 - 0.0198385976163752*G0_1_1_2_1_2 + 0.00855111966223082*G0_1_1_2_2_0 - 0.0198385976163752*G0_1_1_2_2_1 - 0.259611992945324*G0_1_1_2_2_2;
    A[83] = A[125] + 0.00769600769600763*G0_0_1_0_0_0 + 0.00256533589866918*G0_0_1_0_0_1 + 0.0123136123136123*G0_0_1_0_0_2 + 0.00256533589866918*G0_0_1_0_1_0 + 0.00256533589866917*G0_0_1_0_1_1 + 0.00615680615680614*G0_0_1_0_1_2 + 0.0123136123136123*G0_0_1_0_2_0 + 0.00615680615680614*G0_0_1_0_2_1 + 0.02667949334616*G0_0_1_0_2_2 + 0.00256533589866918*G0_0_1_1_0_0 + 0.00256533589866917*G0_0_1_1_0_1 + 0.00615680615680614*G0_0_1_1_0_2 + 0.00256533589866917*G0_0_1_1_1_0 + 0.00769600769600748*G0_0_1_1_1_1 + 0.0123136123136123*G0_0_1_1_1_2 + 0.00615680615680614*G0_0_1_1_2_0 + 0.0123136123136123*G0_0_1_1_2_1 + 0.0266794933461599*G0_0_1_1_2_2 + 0.0123136123136123*G0_0_1_2_0_0 + 0.00615680615680614*G0_0_1_2_0_1 + 0.02667949334616*G0_0_1_2_0_2 + 0.00615680615680614*G0_0_1_2_1_0 + 0.0123136123136123*G0_0_1_2_1_1 + 0.0266794933461599*G0_0_1_2_1_2 + 0.02667949334616*G0_0_1_2_2_0 + 0.0266794933461599*G0_0_1_2_2_1 - 0.301683501683499*G0_0_1_2_2_2 - 0.00769600769600763*G0_1_0_0_0_0 - 0.00256533589866918*G0_1_0_0_0_1 - 0.0123136123136123*G0_1_0_0_0_2 - 0.00256533589866918*G0_1_0_0_1_0 - 0.00256533589866917*G0_1_0_0_1_1 - 0.00615680615680614*G0_1_0_0_1_2 - 0.0123136123136123*G0_1_0_0_2_0 - 0.00615680615680614*G0_1_0_0_2_1 - 0.02667949334616*G0_1_0_0_2_2 - 0.00256533589866918*G0_1_0_1_0_0 - 0.00256533589866917*G0_1_0_1_0_1 - 0.00615680615680614*G0_1_0_1_0_2 - 0.00256533589866917*G0_1_0_1_1_0 - 0.00769600769600748*G0_1_0_1_1_1 - 0.0123136123136123*G0_1_0_1_1_2 - 0.00615680615680614*G0_1_0_1_2_0 - 0.0123136123136123*G0_1_0_1_2_1 - 0.0266794933461599*G0_1_0_1_2_2 - 0.0123136123136123*G0_1_0_2_0_0 - 0.00615680615680614*G0_1_0_2_0_1 - 0.02667949334616*G0_1_0_2_0_2 - 0.00615680615680614*G0_1_0_2_1_0 - 0.0123136123136123*G0_1_0_2_1_1 - 0.0266794933461599*G0_1_0_2_1_2 - 0.02667949334616*G0_1_0_2_2_0 - 0.0266794933461599*G0_1_0_2_2_1 + 0.301683501683499*G0_1_0_2_2_2;
    A[80] = -A[125] + 0.00769600769600763*G0_1_0_0_0_0 + 0.00256533589866918*G0_1_0_0_0_1 + 0.0123136123136123*G0_1_0_0_0_2 + 0.00256533589866918*G0_1_0_0_1_0 + 0.00256533589866917*G0_1_0_0_1_1 + 0.00615680615680615*G0_1_0_0_1_2 + 0.0123136123136123*G0_1_0_0_2_0 + 0.00615680615680615*G0_1_0_0_2_1 + 0.02667949334616*G0_1_0_0_2_2 + 0.00256533589866918*G0_1_0_1_0_0 + 0.00256533589866917*G0_1_0_1_0_1 + 0.00615680615680615*G0_1_0_1_0_2 + 0.00256533589866917*G0_1_0_1_1_0 + 0.00769600769600748*G0_1_0_1_1_1 + 0.0123136123136123*G0_1_0_1_1_2 + 0.00615680615680615*G0_1_0_1_2_0 + 0.0123136123136123*G0_1_0_1_2_1 + 0.0266794933461599*G0_1_0_1_2_2 + 0.0123136123136123*G0_1_0_2_0_0 + 0.00615680615680615*G0_1_0_2_0_1 + 0.0266794933461601*G0_1_0_2_0_2 + 0.00615680615680615*G0_1_0_2_1_0 + 0.0123136123136123*G0_1_0_2_1_1 + 0.0266794933461599*G0_1_0_2_1_2 + 0.02667949334616*G0_1_0_2_2_0 + 0.0266794933461599*G0_1_0_2_2_1 - 0.301683501683499*G0_1_0_2_2_2 + 0.054077280743947*G0_1_1_0_0_0 + 0.0360515204959647*G0_1_1_0_0_1 + 0.0227459783015338*G0_1_1_0_0_2 + 0.0360515204959647*G0_1_1_0_1_0 + 0.0540772807439472*G0_1_1_0_1_1 + 0.0227459783015338*G0_1_1_0_1_2 + 0.0227459783015338*G0_1_1_0_2_0 + 0.0227459783015338*G0_1_1_0_2_1 + 0.0560953449842338*G0_1_1_0_2_2 + 0.0360515204959647*G0_1_1_1_0_0 + 0.0540772807439472*G0_1_1_1_0_1 + 0.0227459783015338*G0_1_1_1_0_2 + 0.0540772807439472*G0_1_1_1_1_0 + 0.216309122975789*G0_1_1_1_1_1 + 0.0682379349046014*G0_1_1_1_1_2 + 0.0227459783015338*G0_1_1_1_2_0 + 0.0682379349046014*G0_1_1_1_2_1 + 0.112190689968467*G0_1_1_1_2_2 + 0.0227459783015338*G0_1_1_2_0_0 + 0.0227459783015338*G0_1_1_2_0_1 + 0.0560953449842338*G0_1_1_2_0_2 + 0.0227459783015338*G0_1_1_2_1_0 + 0.0682379349046014*G0_1_1_2_1_1 + 0.112190689968467*G0_1_1_2_1_2 + 0.0560953449842338*G0_1_1_2_2_0 + 0.112190689968467*G0_1_1_2_2_1 + 0.238063171396504*G0_1_1_2_2_2;
    A[31] = 9.78034311367816e-05*G0_1_0_0_0_0 - 0.00028699695366362*G0_1_0_0_0_1 - 0.000286996953663616*G0_1_0_0_0_2 - 0.00028699695366362*G0_1_0_0_1_0 - 0.00190208967986746*G0_1_0_0_1_1 - 0.000130137352359575*G0_1_0_0_1_2 - 0.000286996953663616*G0_1_0_0_2_0 - 0.000130137352359575*G0_1_0_0_2_1 - 0.00190208967986745*G0_1_0_0_2_2 - 0.00028699695366362*G0_1_0_1_0_0 - 0.00190208967986746*G0_1_0_1_0_1 - 0.000130137352359575*G0_1_0_1_0_2 - 0.00190208967986746*G0_1_0_1_1_0 - 0.0212361712361713*G0_1_0_1_1_1 - 5.39789428678382e-05*G0_1_0_1_1_2 - 0.000130137352359575*G0_1_0_1_2_0 - 5.39789428678384e-05*G0_1_0_1_2_1 - 5.39789428678356e-05*G0_1_0_1_2_2 - 0.000286996953663616*G0_1_0_2_0_0 - 0.000130137352359575*G0_1_0_2_0_1 - 0.00190208967986745*G0_1_0_2_0_2 - 0.000130137352359575*G0_1_0_2_1_0 - 5.39789428678384e-05*G0_1_0_2_1_1 - 5.39789428678356e-05*G0_1_0_2_1_2 - 0.00190208967986745*G0_1_0_2_2_0 - 5.39789428678357e-05*G0_1_0_2_2_1 - 0.0212361712361711*G0_1_0_2_2_2;
    A[42] = 0.0112361712361711*G0_1_0_0_0_0 - 0.00112874779541445*G0_1_0_0_0_1 + 0.0028731762065095*G0_1_0_0_0_2 - 0.00112874779541445*G0_1_0_0_1_0 - 0.00243706910373575*G0_1_0_0_1_1 - 0.000949174282507602*G0_1_0_0_1_2 + 0.00287317620650951*G0_1_0_0_2_0 - 0.000949174282507602*G0_1_0_0_2_1 - 0.00333493666826997*G0_1_0_0_2_2 - 0.00112874779541445*G0_1_0_1_0_0 - 0.00243706910373575*G0_1_0_1_0_1 - 0.000949174282507602*G0_1_0_1_0_2 - 0.00243706910373575*G0_1_0_1_1_0 - 0.000538720538720525*G0_1_0_1_1_1 - 0.000974827641494269*G0_1_0_1_1_2 - 0.000949174282507601*G0_1_0_1_2_0 - 0.000974827641494269*G0_1_0_1_2_1 + 0.00333493666827004*G0_1_0_1_2_2 + 0.0028731762065095*G0_1_0_2_0_0 - 0.000949174282507602*G0_1_0_2_0_1 - 0.00333493666826997*G0_1_0_2_0_2 - 0.000949174282507601*G0_1_0_2_1_0 - 0.000974827641494268*G0_1_0_2_1_1 + 0.00333493666827004*G0_1_0_2_1_2 - 0.00333493666826997*G0_1_0_2_2_0 + 0.00333493666827004*G0_1_0_2_2_1 - 0.05684784351451*G0_1_1_0_0_0 - 0.0210614077280743*G0_1_1_0_0_1 - 0.000538720538720523*G0_1_1_0_0_2 - 0.0210614077280743*G0_1_1_0_1_0 - 0.0131345198011864*G0_1_1_0_1_1 - 0.00107744107744106*G0_1_1_0_1_2 - 0.000538720538720523*G0_1_1_0_2_0 - 0.00107744107744106*G0_1_1_0_2_1 + 0.00387365720699055*G0_1_1_0_2_2 - 0.0210614077280743*G0_1_1_1_0_0 - 0.0131345198011864*G0_1_1_1_0_1 - 0.00107744107744106*G0_1_1_1_0_2 - 0.0131345198011864*G0_1_1_1_1_0 - 0.00590027256693915*G0_1_1_1_1_1 - 0.00128266794933457*G0_1_1_1_1_2 - 0.00107744107744106*G0_1_1_1_2_0 - 0.00128266794933457*G0_1_1_1_2_1 + 0.00715728715728718*G0_1_1_1_2_2 - 0.000538720538720523*G0_1_1_2_0_0 - 0.00107744107744106*G0_1_1_2_0_1 + 0.00387365720699055*G0_1_1_2_0_2 - 0.00107744107744106*G0_1_1_2_1_0 - 0.00128266794933457*G0_1_1_2_1_1 + 0.00715728715728718*G0_1_1_2_1_2 + 0.00387365720699055*G0_1_1_2_2_0 + 0.00715728715728718*G0_1_1_2_2_1 + 0.0595157928491261*G0_1_1_2_2_2;
    A[104] = A[132] + 0.0523328523328519*G0_0_0_0_0_0 + 0.00554112554112553*G0_0_0_0_0_1 - 0.0127240660573993*G0_0_0_0_0_2 + 0.00554112554112553*G0_0_0_0_1_0 + 0.00102613435946773*G0_0_0_0_1_1 + 0.00246272246272248*G0_0_0_0_1_2 - 0.0127240660573994*G0_0_0_0_2_0 + 0.00246272246272248*G0_0_0_0_2_1 + 0.00123136123136145*G0_0_0_0_2_2 + 0.00554112554112553*G0_0_0_1_0_0 + 0.00102613435946773*G0_0_0_1_0_1 + 0.00246272246272248*G0_0_0_1_0_2 + 0.00102613435946773*G0_0_0_1_1_0 + 0.0264742664742665*G0_0_0_1_1_1 + 0.0447394580727913*G0_0_0_1_1_2 + 0.00246272246272248*G0_0_0_1_2_0 + 0.0447394580727913*G0_0_0_1_2_1 + 0.097277537277537*G0_0_0_1_2_2 - 0.0127240660573994*G0_0_0_2_0_0 + 0.00246272246272248*G0_0_0_2_0_1 + 0.00123136123136145*G0_0_0_2_0_2 + 0.00246272246272248*G0_0_0_2_1_0 + 0.0447394580727913*G0_0_0_2_1_1 + 0.097277537277537*G0_0_0_2_1_2 + 0.00123136123136145*G0_0_0_2_2_0 + 0.097277537277537*G0_0_0_2_2_1 + 0.307840307840308*G0_0_0_2_2_2 - 0.0313997113997117*G0_0_1_0_0_0 + 0.000820907487573978*G0_0_1_0_0_1 - 0.0326310726310726*G0_0_1_0_0_2 + 0.00082090748757398*G0_0_1_0_1_0 + 0.00841430174763494*G0_0_1_0_1_1 + 0.00205226871893539*G0_0_1_0_1_2 - 0.0326310726310726*G0_0_1_0_2_0 + 0.00205226871893539*G0_0_1_0_2_1 - 0.0077986211319544*G0_0_1_0_2_2 + 0.000820907487573974*G0_0_1_1_0_0 + 0.00841430174763494*G0_0_1_1_0_1 + 0.00205226871893539*G0_0_1_1_0_2 + 0.00841430174763494*G0_0_1_1_1_0 + 0.0344781144781142*G0_0_1_1_1_1 + 0.051922398589065*G0_0_1_1_1_2 + 0.00205226871893539*G0_0_1_1_2_0 + 0.051922398589065*G0_0_1_1_2_1 + 0.11082251082251*G0_0_1_1_2_2 - 0.0326310726310726*G0_0_1_2_0_0 + 0.00205226871893539*G0_0_1_2_0_1 - 0.00779862113195439*G0_0_1_2_0_2 + 0.00205226871893539*G0_0_1_2_1_0 + 0.051922398589065*G0_0_1_2_1_1 + 0.11082251082251*G0_0_1_2_1_2 - 0.0077986211319544*G0_0_1_2_2_0 + 0.11082251082251*G0_0_1_2_2_1 + 0.402655122655121*G0_0_1_2_2_2 - 0.0424819624819631*G0_1_0_0_0_0 - 0.00800384800384805*G0_1_0_0_0_1 - 0.00369408369408378*G0_1_0_0_0_2 - 0.00800384800384805*G0_1_0_0_1_0 - 0.00615680615680613*G0_1_0_0_1_1 + 0.00287317620650954*G0_1_0_0_1_2 - 0.00369408369408377*G0_1_0_0_2_0 + 0.00287317620650954*G0_1_0_0_2_1 + 0.0211383678050344*G0_1_0_0_2_2 - 0.00800384800384806*G0_1_0_1_0_0 - 0.00615680615680613*G0_1_0_1_0_1 + 0.00287317620650954*G0_1_0_1_0_2 - 0.00615680615680613*G0_1_0_1_1_0 + 0.0184704184704185*G0_1_0_1_1_1 + 0.0373512906846239*G0_1_0_1_1_2 + 0.00287317620650954*G0_1_0_1_2_0 + 0.0373512906846239*G0_1_0_1_2_1 + 0.101997755331088*G0_1_0_1_2_2 - 0.00369408369408377*G0_1_0_2_0_0 + 0.00287317620650954*G0_1_0_2_0_1 + 0.0211383678050344*G0_1_0_2_0_2 + 0.00287317620650954*G0_1_0_2_1_0 + 0.0373512906846239*G0_1_0_2_1_1 + 0.101997755331088*G0_1_0_2_1_2 + 0.0211383678050344*G0_1_0_2_2_0 + 0.101997755331088*G0_1_0_2_2_1 + 0.391572871572871*G0_1_0_2_2_2 - 0.434054834054833*G0_1_1_0_0_0 - 0.110001603334936*G0_1_1_0_0_1 - 0.0248324514991181*G0_1_1_0_0_2 - 0.110001603334936*G0_1_1_0_1_0 - 0.04350809684143*G0_1_1_0_1_1 - 0.0248324514991181*G0_1_1_0_2_0 + 0.0248324514991182*G0_1_1_0_2_2 - 0.110001603334936*G0_1_1_1_0_0 - 0.04350809684143*G0_1_1_1_0_1 - 0.04350809684143*G0_1_1_1_1_0 + 0.04350809684143*G0_1_1_1_1_2 + 0.04350809684143*G0_1_1_1_2_1 + 0.110001603334936*G0_1_1_1_2_2 - 0.0248324514991181*G0_1_1_2_0_0 + 0.0248324514991182*G0_1_1_2_0_2 + 0.04350809684143*G0_1_1_2_1_1 + 0.110001603334936*G0_1_1_2_1_2 + 0.0248324514991182*G0_1_1_2_2_0 + 0.110001603334936*G0_1_1_2_2_1 + 0.434054834054832*G0_1_1_2_2_2;
    A[182] = A[42] + 0.0112361712361711*G0_0_1_0_0_0 - 0.00112874779541445*G0_0_1_0_0_1 + 0.0028731762065095*G0_0_1_0_0_2 - 0.00112874779541445*G0_0_1_0_1_0 - 0.00243706910373575*G0_0_1_0_1_1 - 0.000949174282507603*G0_0_1_0_1_2 + 0.0028731762065095*G0_0_1_0_2_0 - 0.000949174282507603*G0_0_1_0_2_1 - 0.00333493666826997*G0_0_1_0_2_2 - 0.00112874779541445*G0_0_1_1_0_0 - 0.00243706910373575*G0_0_1_1_0_1 - 0.000949174282507603*G0_0_1_1_0_2 - 0.00243706910373575*G0_0_1_1_1_0 - 0.000538720538720536*G0_0_1_1_1_1 - 0.000974827641494277*G0_0_1_1_1_2 - 0.000949174282507603*G0_0_1_1_2_0 - 0.000974827641494277*G0_0_1_1_2_1 + 0.00333493666827004*G0_0_1_1_2_2 + 0.0028731762065095*G0_0_1_2_0_0 - 0.000949174282507603*G0_0_1_2_0_1 - 0.00333493666826997*G0_0_1_2_0_2 - 0.000949174282507603*G0_0_1_2_1_0 - 0.000974827641494277*G0_0_1_2_1_1 + 0.00333493666827004*G0_0_1_2_1_2 - 0.00333493666826997*G0_0_1_2_2_0 + 0.00333493666827004*G0_0_1_2_2_1 - 0.0112361712361711*G0_1_0_0_0_0 + 0.00112874779541445*G0_1_0_0_0_1 - 0.0028731762065095*G0_1_0_0_0_2 + 0.00112874779541445*G0_1_0_0_1_0 + 0.00243706910373575*G0_1_0_0_1_1 + 0.000949174282507603*G0_1_0_0_1_2 - 0.0028731762065095*G0_1_0_0_2_0 + 0.000949174282507603*G0_1_0_0_2_1 + 0.00333493666826997*G0_1_0_0_2_2 + 0.00112874779541445*G0_1_0_1_0_0 + 0.00243706910373575*G0_1_0_1_0_1 + 0.000949174282507603*G0_1_0_1_0_2 + 0.00243706910373575*G0_1_0_1_1_0 + 0.00053872053872054*G0_1_0_1_1_1 + 0.000974827641494278*G0_1_0_1_1_2 + 0.000949174282507603*G0_1_0_1_2_0 + 0.000974827641494278*G0_1_0_1_2_1 - 0.00333493666827004*G0_1_0_1_2_2 - 0.0028731762065095*G0_1_0_2_0_0 + 0.000949174282507603*G0_1_0_2_0_1 + 0.00333493666826997*G0_1_0_2_0_2 + 0.000949174282507603*G0_1_0_2_1_0 + 0.000974827641494277*G0_1_0_2_1_1 - 0.00333493666827004*G0_1_0_2_1_2 + 0.00333493666826997*G0_1_0_2_2_0 - 0.00333493666827004*G0_1_0_2_2_1;
    A[198] = A[89] - 0.0621837421837419*G0_0_0_0_0_0 - 0.0137502004168671*G0_0_0_0_0_1 - 0.0685457752124416*G0_0_0_0_0_2 - 0.0137502004168671*G0_0_0_0_1_0 - 0.0445342312008977*G0_0_0_0_1_1 - 0.0229854096520762*G0_0_0_0_1_2 - 0.0685457752124416*G0_0_0_0_2_0 - 0.0229854096520762*G0_0_0_0_2_1 - 0.134218374218374*G0_0_0_0_2_2 - 0.0137502004168671*G0_0_0_1_0_0 - 0.0445342312008977*G0_0_0_1_0_1 - 0.0229854096520762*G0_0_0_1_0_2 - 0.0445342312008977*G0_0_0_1_1_0 - 0.634766714766711*G0_0_0_1_1_1 - 0.178547378547378*G0_0_0_1_1_2 - 0.0229854096520762*G0_0_0_1_2_0 - 0.178547378547378*G0_0_0_1_2_1 - 0.0332467532467529*G0_0_0_1_2_2 - 0.0685457752124416*G0_0_0_2_0_0 - 0.0229854096520762*G0_0_0_2_0_1 - 0.134218374218374*G0_0_0_2_0_2 - 0.0229854096520762*G0_0_0_2_1_0 - 0.178547378547378*G0_0_0_2_1_1 - 0.0332467532467529*G0_0_0_2_1_2 - 0.134218374218374*G0_0_0_2_2_0 - 0.0332467532467529*G0_0_0_2_2_1 - 0.184704184704182*G0_0_0_2_2_2 - 0.0029757896424564*G0_0_1_0_0_1 + 0.00297578964245625*G0_0_1_0_0_2 - 0.0029757896424564*G0_0_1_0_1_0 - 0.0376591309924642*G0_0_1_0_1_1 + 0.00297578964245625*G0_0_1_0_2_0 + 0.0376591309924642*G0_0_1_0_2_2 - 0.0029757896424564*G0_0_1_1_0_0 - 0.0376591309924642*G0_0_1_1_0_1 - 0.0376591309924642*G0_0_1_1_1_0 - 0.629841269841267*G0_0_1_1_1_1 - 0.0819881353214682*G0_0_1_1_1_2 - 0.0819881353214682*G0_0_1_1_2_1 + 0.0819881353214684*G0_0_1_1_2_2 + 0.00297578964245625*G0_0_1_2_0_0 + 0.0376591309924642*G0_0_1_2_0_2 - 0.0819881353214682*G0_0_1_2_1_1 + 0.0819881353214684*G0_0_1_2_1_2 + 0.0376591309924642*G0_0_1_2_2_0 + 0.0819881353214684*G0_0_1_2_2_1 + 0.629841269841267*G0_0_1_2_2_2 + 0.00933782267115595*G0_1_0_0_0_1 - 0.00933782267115607*G0_1_0_0_0_2 + 0.00933782267115595*G0_1_0_0_1_0 + 0.00420715087381743*G0_1_0_0_1_1 - 0.00933782267115607*G0_1_0_0_2_0 - 0.00420715087381761*G0_1_0_0_2_2 + 0.00933782267115595*G0_1_0_1_0_0 + 0.00420715087381744*G0_1_0_1_0_1 + 0.00420715087381744*G0_1_0_1_1_0 - 0.398345358345357*G0_1_0_1_1_1 - 0.0934808401475064*G0_1_0_1_1_2 - 0.0934808401475063*G0_1_0_1_2_1 + 0.0934808401475066*G0_1_0_1_2_2 - 0.00933782267115607*G0_1_0_2_0_0 - 0.00420715087381761*G0_1_0_2_0_2 - 0.0934808401475064*G0_1_0_2_1_1 + 0.0934808401475066*G0_1_0_2_1_2 - 0.00420715087381761*G0_1_0_2_2_0 + 0.0934808401475065*G0_1_0_2_2_1 + 0.398345358345357*G0_1_0_2_2_2 + 0.0621837421837418*G0_1_1_0_0_0 + 0.0685457752124414*G0_1_1_0_0_1 + 0.013750200416867*G0_1_1_0_0_2 + 0.0685457752124414*G0_1_1_0_1_0 + 0.134218374218373*G0_1_1_0_1_1 + 0.0229854096520762*G0_1_1_0_1_2 + 0.013750200416867*G0_1_1_0_2_0 + 0.0229854096520762*G0_1_1_0_2_1 + 0.0445342312008978*G0_1_1_0_2_2 + 0.0685457752124414*G0_1_1_1_0_0 + 0.134218374218373*G0_1_1_1_0_1 + 0.0229854096520762*G0_1_1_1_0_2 + 0.134218374218373*G0_1_1_1_1_0 + 0.184704184704183*G0_1_1_1_1_1 + 0.0332467532467531*G0_1_1_1_1_2 + 0.0229854096520762*G0_1_1_1_2_0 + 0.0332467532467531*G0_1_1_1_2_1 + 0.178547378547378*G0_1_1_1_2_2 + 0.013750200416867*G0_1_1_2_0_0 + 0.0229854096520762*G0_1_1_2_0_1 + 0.0445342312008978*G0_1_1_2_0_2 + 0.0229854096520762*G0_1_1_2_1_0 + 0.0332467532467531*G0_1_1_2_1_1 + 0.178547378547378*G0_1_1_2_1_2 + 0.0445342312008978*G0_1_1_2_2_0 + 0.178547378547378*G0_1_1_2_2_1 + 0.634766714766712*G0_1_1_2_2_2;
    A[32] = 0.00821709155042485*G0_1_1_0_0_0 + 0.00273903051680828*G0_1_1_0_0_1 + 0.0025359414248303*G0_1_1_0_0_2 + 0.00273903051680828*G0_1_1_0_1_0 + 0.00273903051680829*G0_1_1_0_1_1 + 0.00126797071241515*G0_1_1_0_1_2 + 0.0025359414248303*G0_1_1_0_2_0 + 0.00126797071241515*G0_1_1_0_2_1 + 0.0138768638768638*G0_1_1_0_2_2 + 0.00273903051680828*G0_1_1_1_0_0 + 0.00273903051680829*G0_1_1_1_0_1 + 0.00126797071241515*G0_1_1_1_0_2 + 0.00273903051680829*G0_1_1_1_1_0 + 0.00821709155042489*G0_1_1_1_1_1 + 0.0025359414248303*G0_1_1_1_1_2 + 0.00126797071241515*G0_1_1_1_2_0 + 0.0025359414248303*G0_1_1_1_2_1 + 0.0138768638768638*G0_1_1_1_2_2 + 0.0025359414248303*G0_1_1_2_0_0 + 0.00126797071241515*G0_1_1_2_0_1 + 0.0138768638768638*G0_1_1_2_0_2 + 0.00126797071241515*G0_1_1_2_1_0 + 0.0025359414248303*G0_1_1_2_1_1 + 0.0138768638768638*G0_1_1_2_1_2 + 0.0138768638768638*G0_1_1_2_2_0 + 0.0138768638768638*G0_1_1_2_2_1 + 0.234062850729516*G0_1_1_2_2_2;
    A[107] = A[32] + 0.0016257816257816*G0_0_1_0_0_0 + 0.00036235369568703*G0_0_1_0_0_1 + 0.00400833734167068*G0_0_1_0_0_2 + 0.00036235369568703*G0_0_1_0_1_0 + 0.000182780182780193*G0_0_1_0_1_1 + 0.00174763508096841*G0_0_1_0_1_2 + 0.00400833734167068*G0_0_1_0_2_0 + 0.00174763508096841*G0_0_1_0_2_1 + 0.0115279781946448*G0_0_1_0_2_2 + 0.00036235369568703*G0_0_1_1_0_0 + 0.000182780182780193*G0_0_1_1_0_1 + 0.00174763508096841*G0_0_1_1_0_2 + 0.000182780182780193*G0_0_1_1_1_0 + 0.00298220298220298*G0_0_1_1_1_2 + 0.00174763508096841*G0_0_1_1_2_0 + 0.00298220298220298*G0_0_1_1_2_1 + 0.022430655763989*G0_0_1_1_2_2 + 0.00400833734167067*G0_0_1_2_0_0 + 0.00174763508096841*G0_0_1_2_0_1 + 0.0115279781946448*G0_0_1_2_0_2 + 0.00174763508096841*G0_0_1_2_1_0 + 0.00298220298220298*G0_0_1_2_1_1 + 0.022430655763989*G0_0_1_2_1_2 + 0.0115279781946448*G0_0_1_2_2_0 + 0.022430655763989*G0_0_1_2_2_1 + 0.288792688792687*G0_0_1_2_2_2 + 0.0557335257335254*G0_1_1_0_0_0 + 0.00867030089252307*G0_1_1_0_0_1 + 0.00450269894714336*G0_1_1_0_0_2 + 0.00867030089252307*G0_1_1_0_1_0 + 0.00178558067446955*G0_1_1_0_1_1 + 0.00110496499385388*G0_1_1_0_1_2 + 0.00450269894714336*G0_1_1_0_2_0 + 0.00110496499385388*G0_1_1_0_2_1 - 0.00847362514029177*G0_1_1_0_2_2 + 0.00867030089252307*G0_1_1_1_0_0 + 0.00178558067446955*G0_1_1_1_0_1 + 0.00110496499385388*G0_1_1_1_0_2 + 0.00178558067446955*G0_1_1_1_1_0 - 0.00622895622895618*G0_1_1_1_1_1 + 0.000686761797872914*G0_1_1_1_1_2 + 0.00110496499385388*G0_1_1_1_2_0 + 0.000686761797872913*G0_1_1_1_2_1 + 0.0053952220618887*G0_1_1_1_2_2 + 0.00450269894714336*G0_1_1_2_0_0 + 0.00110496499385388*G0_1_1_2_0_1 - 0.00847362514029177*G0_1_1_2_0_2 + 0.00110496499385388*G0_1_1_2_1_0 + 0.000686761797872914*G0_1_1_2_1_1 + 0.0053952220618887*G0_1_1_2_1_2 - 0.00847362514029177*G0_1_1_2_2_0 + 0.00539522206188869*G0_1_1_2_2_1 + 0.00087381754048399*G0_1_1_2_2_2;
    A[25] = A[16] + 0.0557335257335256*G0_0_0_0_0_0 + 0.00450269894714338*G0_0_0_0_0_1 + 0.00867030089252306*G0_0_0_0_0_2 + 0.00450269894714338*G0_0_0_0_1_0 - 0.00847362514029174*G0_0_0_0_1_1 + 0.00110496499385388*G0_0_0_0_1_2 + 0.00867030089252306*G0_0_0_0_2_0 + 0.00110496499385388*G0_0_0_0_2_1 + 0.00178558067446955*G0_0_0_0_2_2 + 0.00450269894714338*G0_0_0_1_0_0 - 0.00847362514029174*G0_0_0_1_0_1 + 0.00110496499385388*G0_0_0_1_0_2 - 0.00847362514029174*G0_0_0_1_1_0 + 0.000873817540484545*G0_0_0_1_1_1 + 0.00539522206188872*G0_0_0_1_1_2 + 0.00110496499385388*G0_0_0_1_2_0 + 0.00539522206188872*G0_0_0_1_2_1 + 0.00068676179787291*G0_0_0_1_2_2 + 0.00867030089252306*G0_0_0_2_0_0 + 0.00110496499385388*G0_0_0_2_0_1 + 0.00178558067446955*G0_0_0_2_0_2 + 0.00110496499385388*G0_0_0_2_1_0 + 0.00539522206188872*G0_0_0_2_1_1 + 0.00068676179787291*G0_0_0_2_1_2 + 0.00178558067446955*G0_0_0_2_2_0 + 0.00068676179787291*G0_0_0_2_2_1 - 0.00622895622895617*G0_0_0_2_2_2 + 0.00162578162578163*G0_0_1_0_0_0 + 0.00400833734167068*G0_0_1_0_0_1 + 0.000362353695687023*G0_0_1_0_0_2 + 0.00400833734167068*G0_0_1_0_1_0 + 0.0115279781946448*G0_0_1_0_1_1 + 0.00174763508096841*G0_0_1_0_1_2 + 0.000362353695687023*G0_0_1_0_2_0 + 0.00174763508096841*G0_0_1_0_2_1 + 0.000182780182780174*G0_0_1_0_2_2 + 0.00400833734167068*G0_0_1_1_0_0 + 0.0115279781946448*G0_0_1_1_0_1 + 0.00174763508096841*G0_0_1_1_0_2 + 0.0115279781946448*G0_0_1_1_1_0 + 0.288792688792687*G0_0_1_1_1_1 + 0.022430655763989*G0_0_1_1_1_2 + 0.00174763508096841*G0_0_1_1_2_0 + 0.022430655763989*G0_0_1_1_2_1 + 0.00298220298220297*G0_0_1_1_2_2 + 0.000362353695687023*G0_0_1_2_0_0 + 0.00174763508096841*G0_0_1_2_0_1 + 0.000182780182780173*G0_0_1_2_0_2 + 0.00174763508096841*G0_0_1_2_1_0 + 0.022430655763989*G0_0_1_2_1_1 + 0.00298220298220297*G0_0_1_2_1_2 + 0.000182780182780173*G0_0_1_2_2_0 + 0.00298220298220297*G0_0_1_2_2_1;
    A[159] = A[97] - 0.606701940035271*G0_0_0_0_0_0 - 0.0731120731120727*G0_0_0_0_0_1 - 0.0708032708032705*G0_0_0_0_0_2 - 0.0731120731120727*G0_0_0_0_1_0 - 0.0580535513868845*G0_0_0_0_1_1 - 0.00936347603014264*G0_0_0_0_1_2 - 0.0708032708032705*G0_0_0_0_2_0 - 0.00936347603014264*G0_0_0_0_2_1 + 0.000590027256694008*G0_0_0_0_2_2 - 0.0731120731120727*G0_0_0_1_0_0 - 0.0580535513868845*G0_0_0_1_0_1 - 0.00936347603014264*G0_0_0_1_0_2 - 0.0580535513868845*G0_0_0_1_1_0 - 0.310020843354176*G0_0_0_1_1_1 - 0.0326310726310724*G0_0_0_1_1_2 - 0.00936347603014264*G0_0_0_1_2_0 - 0.0326310726310724*G0_0_0_1_2_1 + 0.0301426968093634*G0_0_0_1_2_2 - 0.0708032708032705*G0_0_0_2_0_0 - 0.00936347603014264*G0_0_0_2_0_1 + 0.000590027256694011*G0_0_0_2_0_2 - 0.00936347603014264*G0_0_0_2_1_0 - 0.0326310726310724*G0_0_0_2_1_1 + 0.0301426968093634*G0_0_0_2_1_2 + 0.000590027256694018*G0_0_0_2_2_0 + 0.0301426968093634*G0_0_0_2_2_1 + 0.297732884399549*G0_0_0_2_2_2 - 0.0867083533750194*G0_0_1_0_0_1 + 0.0867083533750197*G0_0_1_0_0_2 - 0.0867083533750194*G0_0_1_0_1_0 - 0.070751964085297*G0_0_1_0_1_1 + 0.0867083533750197*G0_0_1_0_2_0 + 0.0707519640852971*G0_0_1_0_2_2 - 0.0867083533750194*G0_0_1_1_0_0 - 0.070751964085297*G0_0_1_1_0_1 - 0.070751964085297*G0_0_1_1_1_0 - 0.322462722462721*G0_0_1_1_1_1 - 0.0334519801186466*G0_0_1_1_1_2 - 0.0334519801186466*G0_0_1_1_2_1 + 0.0334519801186466*G0_0_1_1_2_2 + 0.0867083533750197*G0_0_1_2_0_0 + 0.0707519640852971*G0_0_1_2_0_2 - 0.0334519801186466*G0_0_1_2_1_1 + 0.0334519801186466*G0_0_1_2_1_2 + 0.0707519640852971*G0_0_1_2_2_0 + 0.0334519801186466*G0_0_1_2_2_1 + 0.32246272246272*G0_0_1_2_2_2 + 0.0156485489818822*G0_1_0_0_0_1 - 0.0156485489818823*G0_1_0_0_0_2 + 0.0156485489818822*G0_1_0_0_1_0 - 0.00944043610710278*G0_1_0_0_1_1 - 0.0156485489818823*G0_1_0_0_2_0 + 0.00944043610710281*G0_1_0_0_2_2 + 0.0156485489818822*G0_1_0_1_0_0 - 0.00944043610710278*G0_1_0_1_0_1 - 0.00944043610710278*G0_1_0_1_1_0 - 0.286214526214525*G0_1_0_1_1_1 - 0.0294244027577359*G0_1_0_1_1_2 - 0.0294244027577359*G0_1_0_1_2_1 + 0.029424402757736*G0_1_0_1_2_2 - 0.0156485489818823*G0_1_0_2_0_0 + 0.00944043610710281*G0_1_0_2_0_2 - 0.0294244027577359*G0_1_0_2_1_1 + 0.029424402757736*G0_1_0_2_1_2 + 0.00944043610710282*G0_1_0_2_2_0 + 0.029424402757736*G0_1_0_2_2_1 + 0.286214526214525*G0_1_0_2_2_2 + 0.60670194003527*G0_1_1_0_0_0 + 0.0708032708032705*G0_1_1_0_0_1 + 0.0731120731120728*G0_1_1_0_0_2 + 0.0708032708032705*G0_1_1_0_1_0 - 0.000590027256693913*G0_1_1_0_1_1 + 0.00936347603014267*G0_1_1_0_1_2 + 0.0731120731120728*G0_1_1_0_2_0 + 0.00936347603014267*G0_1_1_0_2_1 + 0.0580535513868845*G0_1_1_0_2_2 + 0.0708032708032705*G0_1_1_1_0_0 - 0.000590027256693913*G0_1_1_1_0_1 + 0.00936347603014267*G0_1_1_1_0_2 - 0.000590027256693906*G0_1_1_1_1_0 - 0.297732884399549*G0_1_1_1_1_1 - 0.0301426968093633*G0_1_1_1_1_2 + 0.00936347603014267*G0_1_1_1_2_0 - 0.0301426968093633*G0_1_1_1_2_1 + 0.0326310726310725*G0_1_1_1_2_2 + 0.0731120731120728*G0_1_1_2_0_0 + 0.00936347603014267*G0_1_1_2_0_1 + 0.0580535513868845*G0_1_1_2_0_2 + 0.00936347603014267*G0_1_1_2_1_0 - 0.0301426968093633*G0_1_1_2_1_1 + 0.0326310726310725*G0_1_1_2_1_2 + 0.0580535513868845*G0_1_1_2_2_0 + 0.0326310726310725*G0_1_1_2_2_1 + 0.310020843354175*G0_1_1_2_2_2;
    A[79] = A[65] - 0.00205226871893541*G0_0_1_0_0_1 - 0.00464325797659129*G0_0_1_0_0_2 - 0.00205226871893541*G0_0_1_0_1_0 - 0.00607984607984609*G0_0_1_0_1_1 - 0.0133140933140933*G0_0_1_0_1_2 - 0.0046432579765913*G0_0_1_0_2_0 - 0.0133140933140933*G0_0_1_0_2_1 - 0.0271925605258938*G0_0_1_0_2_2 - 0.00205226871893541*G0_0_1_1_0_0 - 0.00607984607984609*G0_0_1_1_0_1 - 0.0133140933140933*G0_0_1_1_0_2 - 0.00607984607984609*G0_0_1_1_1_0 - 0.0363251563251562*G0_0_1_1_1_1 - 0.0659547859547857*G0_0_1_1_1_2 - 0.0133140933140933*G0_0_1_1_2_0 - 0.0659547859547857*G0_0_1_1_2_1 - 0.129549462882796*G0_0_1_1_2_2 - 0.0046432579765913*G0_0_1_2_0_0 - 0.0133140933140933*G0_0_1_2_0_1 - 0.0271925605258938*G0_0_1_2_0_2 - 0.0133140933140933*G0_0_1_2_1_0 - 0.0659547859547857*G0_0_1_2_1_1 - 0.129549462882796*G0_0_1_2_1_2 - 0.0271925605258938*G0_0_1_2_2_0 - 0.129549462882796*G0_0_1_2_2_1 - 0.294757094757093*G0_0_1_2_2_2 + 0.00205226871893541*G0_1_0_0_0_1 + 0.0046432579765913*G0_1_0_0_0_2 + 0.00205226871893541*G0_1_0_0_1_0 + 0.00607984607984609*G0_1_0_0_1_1 + 0.0133140933140933*G0_1_0_0_1_2 + 0.0046432579765913*G0_1_0_0_2_0 + 0.0133140933140933*G0_1_0_0_2_1 + 0.0271925605258938*G0_1_0_0_2_2 + 0.00205226871893541*G0_1_0_1_0_0 + 0.00607984607984609*G0_1_0_1_0_1 + 0.0133140933140933*G0_1_0_1_0_2 + 0.00607984607984609*G0_1_0_1_1_0 + 0.0363251563251562*G0_1_0_1_1_1 + 0.0659547859547857*G0_1_0_1_1_2 + 0.0133140933140933*G0_1_0_1_2_0 + 0.0659547859547857*G0_1_0_1_2_1 + 0.129549462882796*G0_1_0_1_2_2 + 0.0046432579765913*G0_1_0_2_0_0 + 0.0133140933140933*G0_1_0_2_0_1 + 0.0271925605258938*G0_1_0_2_0_2 + 0.0133140933140933*G0_1_0_2_1_0 + 0.0659547859547857*G0_1_0_2_1_1 + 0.129549462882796*G0_1_0_2_1_2 + 0.0271925605258938*G0_1_0_2_2_0 + 0.129549462882796*G0_1_0_2_2_1 + 0.294757094757093*G0_1_0_2_2_2;
    A[106] = 0.00338303671637*G0_0_0_0_0_0 + 6.7340067340061e-05*G0_0_0_0_0_1 + 0.00635561968895299*G0_0_0_0_0_2 + 6.73400673400612e-05*G0_0_0_0_1_0 - 0.000663780663780691*G0_0_0_0_1_1 - 0.000497033830367163*G0_0_0_0_1_2 + 0.00635561968895299*G0_0_0_0_2_0 - 0.000497033830367163*G0_0_0_0_2_1 + 0.00888568221901552*G0_0_0_0_2_2 + 6.73400673400612e-05*G0_0_0_1_0_0 - 0.000663780663780691*G0_0_0_1_0_1 - 0.000497033830367164*G0_0_0_1_0_2 - 0.000663780663780691*G0_0_0_1_1_0 - 0.00565977232643937*G0_0_0_1_1_1 - 0.00108385441718776*G0_0_0_1_1_2 - 0.000497033830367164*G0_0_0_1_2_0 - 0.00108385441718776*G0_0_0_1_2_1 + 0.000381593714927031*G0_0_0_1_2_2 + 0.00635561968895299*G0_0_0_2_0_0 - 0.000497033830367163*G0_0_0_2_0_1 + 0.00888568221901552*G0_0_0_2_0_2 - 0.000497033830367164*G0_0_0_2_1_0 - 0.00108385441718776*G0_0_0_2_1_1 + 0.000381593714927031*G0_0_0_2_1_2 + 0.00888568221901552*G0_0_0_2_2_0 + 0.000381593714927032*G0_0_0_2_2_1 + 0.00575917909251242*G0_0_0_2_2_2 - 0.00237614237614218*G0_1_0_0_0_0 - 0.000314253647586967*G0_1_0_0_0_1 - 0.00253006253006248*G0_1_0_0_0_2 - 0.000314253647586968*G0_1_0_0_1_0 + 0.000420073753407066*G0_1_0_0_1_1 - 0.00253006253006248*G0_1_0_0_2_0 + 0.00253006253006254*G0_1_0_0_2_2 - 0.000314253647586968*G0_1_0_1_0_0 + 0.000420073753407066*G0_1_0_1_0_1 + 0.000420073753407066*G0_1_0_1_1_0 - 0.000420073753407095*G0_1_0_1_1_2 - 0.000420073753407095*G0_1_0_1_2_1 + 0.000314253647586966*G0_1_0_1_2_2 - 0.00253006253006248*G0_1_0_2_0_0 + 0.00253006253006254*G0_1_0_2_0_2 - 0.000420073753407095*G0_1_0_2_1_1 + 0.000314253647586965*G0_1_0_2_1_2 + 0.00253006253006254*G0_1_0_2_2_0 + 0.000314253647586966*G0_1_0_2_2_1 + 0.00237614237614237*G0_1_0_2_2_2;
    A[60] = A[106] - 0.0090428090428092*G0_0_0_0_0_0 - 0.000731120731120743*G0_0_0_0_0_1 - 0.00743947410614075*G0_0_0_0_0_2 - 0.000731120731120743*G0_0_0_0_1_0 + 0.000731120731120752*G0_0_0_0_1_1 - 0.00743947410614075*G0_0_0_0_2_0 - 0.00850408850408848*G0_0_0_0_2_2 - 0.000731120731120743*G0_0_0_1_0_0 + 0.000731120731120752*G0_0_0_1_0_1 + 0.000731120731120752*G0_0_0_1_1_0 + 0.00904280904280937*G0_0_0_1_1_1 + 0.00743947410614072*G0_0_0_1_1_2 + 0.00743947410614072*G0_0_0_1_2_1 + 0.00850408850408844*G0_0_0_1_2_2 - 0.00743947410614075*G0_0_0_2_0_0 - 0.00850408850408848*G0_0_0_2_0_2 + 0.00743947410614072*G0_0_0_2_1_1 + 0.00850408850408844*G0_0_0_2_1_2 - 0.00850408850408848*G0_0_0_2_2_0 + 0.00850408850408844*G0_0_0_2_2_1 - 0.0056597723264392*G0_0_1_0_0_0 - 0.000663780663780683*G0_0_1_0_0_1 - 0.00108385441718776*G0_0_1_0_0_2 - 0.000663780663780683*G0_0_1_0_1_0 - 0.000497033830367167*G0_0_1_0_1_2 - 0.00108385441718776*G0_0_1_0_2_0 - 0.000497033830367167*G0_0_1_0_2_1 + 0.000381593714927014*G0_0_1_0_2_2 - 0.000663780663780683*G0_0_1_1_0_0 - 0.000497033830367167*G0_0_1_1_0_2 + 0.00338303671636999*G0_0_1_1_1_1 + 0.00635561968895295*G0_0_1_1_1_2 - 0.000497033830367167*G0_0_1_1_2_0 + 0.00635561968895295*G0_0_1_1_2_1 + 0.00888568221901545*G0_0_1_1_2_2 - 0.00108385441718776*G0_0_1_2_0_0 - 0.000497033830367167*G0_0_1_2_0_1 + 0.000381593714927014*G0_0_1_2_0_2 - 0.000497033830367167*G0_0_1_2_1_0 + 0.00635561968895295*G0_0_1_2_1_1 + 0.00888568221901545*G0_0_1_2_1_2 + 0.000381593714927014*G0_0_1_2_2_0 + 0.00888568221901545*G0_0_1_2_2_1 + 0.00575917909251208*G0_0_1_2_2_2 - 0.00328362995029721*G0_1_0_0_0_0 - 0.000769600769600806*G0_1_0_0_0_1 + 0.0018662818662818*G0_1_0_0_0_2 - 0.000769600769600805*G0_1_0_0_1_0 - 0.000497033830367166*G0_1_0_0_1_2 + 0.0018662818662818*G0_1_0_0_2_0 - 0.000497033830367166*G0_1_0_0_2_1 - 0.00246272246272247*G0_1_0_0_2_2 - 0.000769600769600805*G0_1_0_1_0_0 - 0.000497033830367166*G0_1_0_1_0_2 + 0.00575917909251254*G0_1_0_1_1_1 + 0.00930575597242257*G0_1_0_1_1_2 - 0.000497033830367166*G0_1_0_1_2_0 + 0.00930575597242257*G0_1_0_1_2_1 + 0.00604136604136601*G0_1_0_1_2_2 + 0.0018662818662818*G0_1_0_2_0_0 - 0.000497033830367167*G0_1_0_2_0_1 - 0.00246272246272247*G0_1_0_2_0_2 - 0.000497033830367166*G0_1_0_2_1_0 + 0.00930575597242257*G0_1_0_2_1_1 + 0.00604136604136601*G0_1_0_2_1_2 - 0.00246272246272247*G0_1_0_2_2_0 + 0.00604136604136601*G0_1_0_2_2_1 + 0.00100689434022771*G0_1_0_2_2_2 - 0.00565977232643947*G0_1_1_0_0_0 - 0.00108385441718779*G0_1_1_0_0_1 - 0.000663780663780686*G0_1_1_0_0_2 - 0.00108385441718779*G0_1_1_0_1_0 + 0.00038159371492702*G0_1_1_0_1_1 - 0.000497033830367168*G0_1_1_0_1_2 - 0.000663780663780686*G0_1_1_0_2_0 - 0.000497033830367168*G0_1_1_0_2_1 - 0.00108385441718779*G0_1_1_1_0_0 + 0.000381593714927021*G0_1_1_1_0_1 - 0.000497033830367168*G0_1_1_1_0_2 + 0.00038159371492702*G0_1_1_1_1_0 + 0.00575917909251218*G0_1_1_1_1_1 + 0.00888568221901545*G0_1_1_1_1_2 - 0.000497033830367168*G0_1_1_1_2_0 + 0.00888568221901545*G0_1_1_1_2_1 + 0.00635561968895295*G0_1_1_1_2_2 - 0.000663780663780686*G0_1_1_2_0_0 - 0.000497033830367168*G0_1_1_2_0_1 - 0.000497033830367168*G0_1_1_2_1_0 + 0.00888568221901545*G0_1_1_2_1_1 + 0.00635561968895295*G0_1_1_2_1_2 + 0.00635561968895295*G0_1_1_2_2_1 + 0.00338303671636995*G0_1_1_2_2_2;
    A[4] = A[60] - 0.000420073753407089*G0_0_1_0_0_1 + 0.000420073753407079*G0_0_1_0_0_2 - 0.000420073753407089*G0_0_1_0_1_0 + 0.000314253647586976*G0_0_1_0_1_1 + 0.000420073753407079*G0_0_1_0_2_0 - 0.000314253647586964*G0_0_1_0_2_2 - 0.000420073753407089*G0_0_1_1_0_0 + 0.000314253647586975*G0_0_1_1_0_1 + 0.000314253647586975*G0_0_1_1_1_0 + 0.00237614237614223*G0_0_1_1_1_1 + 0.00253006253006253*G0_0_1_1_1_2 + 0.00253006253006253*G0_0_1_1_2_1 - 0.00253006253006247*G0_0_1_1_2_2 + 0.000420073753407079*G0_0_1_2_0_0 - 0.000314253647586964*G0_0_1_2_0_2 + 0.00253006253006253*G0_0_1_2_1_1 - 0.00253006253006247*G0_0_1_2_1_2 - 0.000314253647586964*G0_0_1_2_2_0 - 0.00253006253006247*G0_0_1_2_2_1 - 0.00237614237614212*G0_0_1_2_2_2 + 0.000420073753407089*G0_1_0_0_0_1 - 0.000420073753407079*G0_1_0_0_0_2 + 0.000420073753407089*G0_1_0_0_1_0 - 0.000314253647586976*G0_1_0_0_1_1 - 0.000420073753407079*G0_1_0_0_2_0 + 0.000314253647586963*G0_1_0_0_2_2 + 0.000420073753407089*G0_1_0_1_0_0 - 0.000314253647586975*G0_1_0_1_0_1 - 0.000314253647586975*G0_1_0_1_1_0 - 0.00237614237614224*G0_1_0_1_1_1 - 0.00253006253006253*G0_1_0_1_1_2 - 0.00253006253006253*G0_1_0_1_2_1 + 0.00253006253006247*G0_1_0_1_2_2 - 0.000420073753407079*G0_1_0_2_0_0 + 0.000314253647586963*G0_1_0_2_0_2 - 0.00253006253006253*G0_1_0_2_1_1 + 0.00253006253006247*G0_1_0_2_1_2 + 0.000314253647586963*G0_1_0_2_2_0 + 0.00253006253006247*G0_1_0_2_2_1 + 0.00237614237614212*G0_1_0_2_2_2;
    A[187] = A[117] + 0.122366522366522*G0_0_1_0_0_0 - 0.0242424242424241*G0_0_1_0_0_1 + 0.0711880711880709*G0_0_1_0_0_2 - 0.0242424242424241*G0_0_1_0_1_0 - 0.0182395382395381*G0_0_1_0_1_1 - 0.00831168831168825*G0_0_1_0_1_2 + 0.0711880711880709*G0_0_1_0_2_0 - 0.00831168831168826*G0_0_1_0_2_1 + 0.00484848484848471*G0_0_1_0_2_2 - 0.0242424242424241*G0_0_1_1_0_0 - 0.0182395382395381*G0_0_1_1_0_1 - 0.00831168831168825*G0_0_1_1_0_2 - 0.0182395382395381*G0_0_1_1_1_0 - 0.0175468975468976*G0_0_1_1_1_1 - 0.0116209716209716*G0_0_1_1_1_2 - 0.00831168831168826*G0_0_1_1_2_0 - 0.0116209716209716*G0_0_1_1_2_1 - 0.0173160173160173*G0_0_1_1_2_2 + 0.0711880711880709*G0_0_1_2_0_0 - 0.00831168831168826*G0_0_1_2_0_1 + 0.00484848484848471*G0_0_1_2_0_2 - 0.00831168831168825*G0_0_1_2_1_0 - 0.0116209716209716*G0_0_1_2_1_1 - 0.0173160173160173*G0_0_1_2_1_2 + 0.0048484848484847*G0_0_1_2_2_0 - 0.0173160173160173*G0_0_1_2_2_1 - 0.0688023088023087*G0_0_1_2_2_2 - 0.122366522366522*G0_1_0_0_0_0 + 0.0242424242424241*G0_1_0_0_0_1 - 0.0711880711880709*G0_1_0_0_0_2 + 0.0242424242424241*G0_1_0_0_1_0 + 0.0182395382395381*G0_1_0_0_1_1 + 0.00831168831168825*G0_1_0_0_1_2 - 0.0711880711880709*G0_1_0_0_2_0 + 0.00831168831168826*G0_1_0_0_2_1 - 0.00484848484848471*G0_1_0_0_2_2 + 0.0242424242424241*G0_1_0_1_0_0 + 0.0182395382395381*G0_1_0_1_0_1 + 0.00831168831168825*G0_1_0_1_0_2 + 0.0182395382395381*G0_1_0_1_1_0 + 0.0175468975468976*G0_1_0_1_1_1 + 0.0116209716209716*G0_1_0_1_1_2 + 0.00831168831168825*G0_1_0_1_2_0 + 0.0116209716209716*G0_1_0_1_2_1 + 0.0173160173160173*G0_1_0_1_2_2 - 0.0711880711880709*G0_1_0_2_0_0 + 0.00831168831168826*G0_1_0_2_0_1 - 0.00484848484848471*G0_1_0_2_0_2 + 0.00831168831168825*G0_1_0_2_1_0 + 0.0116209716209716*G0_1_0_2_1_1 + 0.0173160173160173*G0_1_0_2_1_2 - 0.00484848484848471*G0_1_0_2_2_0 + 0.0173160173160173*G0_1_0_2_2_1 + 0.0688023088023088*G0_1_0_2_2_2;
    A[216] = A[104] - 0.0523328523328528*G0_0_1_0_0_0 - 0.00153920153920152*G0_0_1_0_0_1 + 0.00872214205547538*G0_0_1_0_0_2 - 0.00153920153920153*G0_0_1_0_1_0 - 0.00564373897707222*G0_0_1_0_1_1 + 0.000410453743787074*G0_0_1_0_1_2 + 0.00872214205547537*G0_0_1_0_2_0 + 0.000410453743787076*G0_0_1_0_2_1 + 0.0202148468815135*G0_0_1_0_2_2 - 0.00153920153920152*G0_0_1_1_0_0 - 0.00564373897707222*G0_0_1_1_0_1 + 0.000410453743787076*G0_0_1_1_0_2 - 0.00564373897707222*G0_0_1_1_1_0 - 0.00800384800384776*G0_0_1_1_1_1 - 0.00892736892736892*G0_0_1_1_1_2 + 0.000410453743787074*G0_0_1_1_2_0 - 0.00892736892736892*G0_0_1_1_2_1 - 0.00728555395222059*G0_0_1_1_2_2 + 0.00872214205547539*G0_0_1_2_0_0 + 0.000410453743787076*G0_0_1_2_0_1 + 0.0202148468815135*G0_0_1_2_0_2 + 0.000410453743787075*G0_0_1_2_1_0 - 0.00892736892736892*G0_0_1_2_1_1 - 0.00728555395222061*G0_0_1_2_1_2 + 0.0202148468815135*G0_0_1_2_2_0 - 0.00728555395222061*G0_0_1_2_2_1 + 0.0412506012506017*G0_0_1_2_2_2 + 0.0523328523328528*G0_1_0_0_0_0 + 0.00153920153920153*G0_1_0_0_0_1 - 0.00872214205547537*G0_1_0_0_0_2 + 0.00153920153920152*G0_1_0_0_1_0 + 0.00564373897707222*G0_1_0_0_1_1 - 0.000410453743787076*G0_1_0_0_1_2 - 0.00872214205547537*G0_1_0_0_2_0 - 0.000410453743787074*G0_1_0_0_2_1 - 0.0202148468815135*G0_1_0_0_2_2 + 0.00153920153920152*G0_1_0_1_0_0 + 0.00564373897707222*G0_1_0_1_0_1 - 0.000410453743787075*G0_1_0_1_0_2 + 0.00564373897707222*G0_1_0_1_1_0 + 0.00800384800384776*G0_1_0_1_1_1 + 0.00892736892736892*G0_1_0_1_1_2 - 0.000410453743787074*G0_1_0_1_2_0 + 0.00892736892736892*G0_1_0_1_2_1 + 0.00728555395222059*G0_1_0_1_2_2 - 0.00872214205547537*G0_1_0_2_0_0 - 0.000410453743787075*G0_1_0_2_0_1 - 0.0202148468815135*G0_1_0_2_0_2 - 0.000410453743787074*G0_1_0_2_1_0 + 0.00892736892736892*G0_1_0_2_1_1 + 0.00728555395222059*G0_1_0_2_1_2 - 0.0202148468815135*G0_1_0_2_2_0 + 0.00728555395222061*G0_1_0_2_2_1 - 0.0412506012506016*G0_1_0_2_2_2;
    A[15] = 0.0212361712361712*G0_0_0_0_0_0 + 5.39789428678374e-05*G0_0_0_0_0_1 + 0.00190208967986745*G0_0_0_0_0_2 + 5.39789428678375e-05*G0_0_0_0_1_0 + 5.3978942867836e-05*G0_0_0_0_1_1 + 0.000130137352359574*G0_0_0_0_1_2 + 0.00190208967986745*G0_0_0_0_2_0 + 0.000130137352359574*G0_0_0_0_2_1 + 0.000286996953663617*G0_0_0_0_2_2 + 5.39789428678375e-05*G0_0_0_1_0_0 + 5.39789428678362e-05*G0_0_0_1_0_1 + 0.000130137352359574*G0_0_0_1_0_2 + 5.39789428678364e-05*G0_0_0_1_1_0 + 0.0212361712361712*G0_0_0_1_1_1 + 0.00190208967986745*G0_0_0_1_1_2 + 0.000130137352359574*G0_0_0_1_2_0 + 0.00190208967986745*G0_0_0_1_2_1 + 0.000286996953663615*G0_0_0_1_2_2 + 0.00190208967986745*G0_0_0_2_0_0 + 0.000130137352359574*G0_0_0_2_0_1 + 0.000286996953663617*G0_0_0_2_0_2 + 0.000130137352359574*G0_0_0_2_1_0 + 0.00190208967986745*G0_0_0_2_1_1 + 0.000286996953663615*G0_0_0_2_1_2 + 0.000286996953663617*G0_0_0_2_2_0 + 0.000286996953663615*G0_0_0_2_2_1 - 9.78034311367794e-05*G0_0_0_2_2_2 + 0.0212361712361712*G0_0_1_0_0_0 + 5.39789428678378e-05*G0_0_1_0_0_1 + 0.00190208967986745*G0_0_1_0_0_2 + 5.39789428678376e-05*G0_0_1_0_1_0 + 5.39789428678358e-05*G0_0_1_0_1_1 + 0.000130137352359574*G0_0_1_0_1_2 + 0.00190208967986745*G0_0_1_0_2_0 + 0.000130137352359574*G0_0_1_0_2_1 + 0.000286996953663616*G0_0_1_0_2_2 + 5.39789428678376e-05*G0_0_1_1_0_0 + 5.39789428678358e-05*G0_0_1_1_0_1 + 0.000130137352359574*G0_0_1_1_0_2 + 5.39789428678359e-05*G0_0_1_1_1_0 + 0.0212361712361711*G0_0_1_1_1_1 + 0.00190208967986744*G0_0_1_1_1_2 + 0.000130137352359574*G0_0_1_1_2_0 + 0.00190208967986744*G0_0_1_1_2_1 + 0.000286996953663615*G0_0_1_1_2_2 + 0.00190208967986745*G0_0_1_2_0_0 + 0.000130137352359574*G0_0_1_2_0_1 + 0.000286996953663616*G0_0_1_2_0_2 + 0.000130137352359574*G0_0_1_2_1_0 + 0.00190208967986744*G0_0_1_2_1_1 + 0.000286996953663615*G0_0_1_2_1_2 + 0.000286996953663616*G0_0_1_2_2_0 + 0.000286996953663615*G0_0_1_2_2_1 - 9.78034311367894e-05*G0_0_1_2_2_2;
    A[37] = A[107] - 0.00162578162578158*G0_0_1_0_0_0 - 0.000362353695687029*G0_0_1_0_0_1 - 0.00400833734167067*G0_0_1_0_0_2 - 0.000362353695687029*G0_0_1_0_1_0 - 0.000182780182780193*G0_0_1_0_1_1 - 0.00174763508096841*G0_0_1_0_1_2 - 0.00400833734167067*G0_0_1_0_2_0 - 0.00174763508096841*G0_0_1_0_2_1 - 0.0115279781946448*G0_0_1_0_2_2 - 0.000362353695687029*G0_0_1_1_0_0 - 0.000182780182780193*G0_0_1_1_0_1 - 0.00174763508096841*G0_0_1_1_0_2 - 0.000182780182780193*G0_0_1_1_1_0 - 0.00298220298220298*G0_0_1_1_1_2 - 0.00174763508096841*G0_0_1_1_2_0 - 0.00298220298220298*G0_0_1_1_2_1 - 0.022430655763989*G0_0_1_1_2_2 - 0.00400833734167067*G0_0_1_2_0_0 - 0.00174763508096841*G0_0_1_2_0_1 - 0.0115279781946448*G0_0_1_2_0_2 - 0.00174763508096841*G0_0_1_2_1_0 - 0.00298220298220298*G0_0_1_2_1_1 - 0.022430655763989*G0_0_1_2_1_2 - 0.0115279781946448*G0_0_1_2_2_0 - 0.022430655763989*G0_0_1_2_2_1 - 0.288792688792687*G0_0_1_2_2_2 + 0.00162578162578158*G0_1_0_0_0_0 + 0.000362353695687029*G0_1_0_0_0_1 + 0.00400833734167067*G0_1_0_0_0_2 + 0.000362353695687029*G0_1_0_0_1_0 + 0.000182780182780193*G0_1_0_0_1_1 + 0.00174763508096841*G0_1_0_0_1_2 + 0.00400833734167067*G0_1_0_0_2_0 + 0.00174763508096841*G0_1_0_0_2_1 + 0.0115279781946448*G0_1_0_0_2_2 + 0.000362353695687029*G0_1_0_1_0_0 + 0.000182780182780193*G0_1_0_1_0_1 + 0.00174763508096841*G0_1_0_1_0_2 + 0.000182780182780193*G0_1_0_1_1_0 + 0.00298220298220298*G0_1_0_1_1_2 + 0.00174763508096841*G0_1_0_1_2_0 + 0.00298220298220298*G0_1_0_1_2_1 + 0.022430655763989*G0_1_0_1_2_2 + 0.00400833734167067*G0_1_0_2_0_0 + 0.00174763508096841*G0_1_0_2_0_1 + 0.0115279781946448*G0_1_0_2_0_2 + 0.00174763508096841*G0_1_0_2_1_0 + 0.00298220298220298*G0_1_0_2_1_1 + 0.022430655763989*G0_1_0_2_1_2 + 0.0115279781946448*G0_1_0_2_2_0 + 0.022430655763989*G0_1_0_2_2_1 + 0.288792688792687*G0_1_0_2_2_2;
    A[148] = A[216] - 0.247298380631713*G0_0_0_0_0_0 - 0.0398140131473462*G0_0_0_0_0_1 - 0.0289369889369887*G0_0_0_0_0_2 - 0.0398140131473462*G0_0_0_0_1_0 - 0.0114927048260381*G0_0_0_0_1_1 - 0.00513067179733843*G0_0_0_0_1_2 - 0.0289369889369887*G0_0_0_0_2_0 - 0.00513067179733843*G0_0_0_0_2_1 - 0.0223697290363957*G0_0_0_0_2_2 - 0.0398140131473462*G0_0_0_1_0_0 - 0.0114927048260381*G0_0_0_1_0_1 - 0.00513067179733843*G0_0_0_1_0_2 - 0.0114927048260381*G0_0_0_1_1_0 + 0.203379830046496*G0_0_0_1_1_1 + 0.0338624338624336*G0_0_0_1_1_2 - 0.00513067179733843*G0_0_0_1_2_0 + 0.0338624338624336*G0_0_0_1_2_1 - 0.0400192400192399*G0_0_0_1_2_2 - 0.0289369889369887*G0_0_0_2_0_0 - 0.00513067179733844*G0_0_0_2_0_1 - 0.0223697290363957*G0_0_0_2_0_2 - 0.00513067179733844*G0_0_0_2_1_0 + 0.0338624338624336*G0_0_0_2_1_1 - 0.0400192400192399*G0_0_0_2_1_2 - 0.0223697290363957*G0_0_0_2_2_0 - 0.0400192400192399*G0_0_0_2_2_1 - 0.276235369568702*G0_0_0_2_2_2 - 0.0177521244187908*G0_0_1_0_0_1 + 0.0177521244187911*G0_0_1_0_0_2 - 0.0177521244187908*G0_0_1_0_1_0 + 0.0132371332371332*G0_0_1_0_1_1 + 0.0177521244187911*G0_0_1_0_2_0 - 0.0132371332371333*G0_0_1_0_2_2 - 0.0177521244187908*G0_0_1_1_0_0 + 0.0132371332371332*G0_0_1_1_0_1 + 0.0132371332371332*G0_0_1_1_1_0 + 0.269052429052428*G0_0_1_1_1_1 + 0.0382748116081447*G0_0_1_1_1_2 + 0.0382748116081447*G0_0_1_1_2_1 - 0.0382748116081448*G0_0_1_1_2_2 + 0.0177521244187911*G0_0_1_2_0_0 - 0.0132371332371332*G0_0_1_2_0_2 + 0.0382748116081447*G0_0_1_2_1_1 - 0.0382748116081448*G0_0_1_2_1_2 - 0.0132371332371332*G0_0_1_2_2_0 - 0.0382748116081448*G0_0_1_2_2_1 - 0.269052429052428*G0_0_1_2_2_2 - 0.0280134680134677*G0_1_0_0_0_1 + 0.028013468013468*G0_1_0_0_0_2 - 0.0280134680134677*G0_1_0_0_1_0 - 0.0126214526214524*G0_1_0_0_1_1 + 0.028013468013468*G0_1_0_0_2_0 + 0.0126214526214526*G0_1_0_0_2_2 - 0.0280134680134677*G0_1_0_1_0_0 - 0.0126214526214524*G0_1_0_1_0_1 - 0.0126214526214524*G0_1_0_1_1_0 + 0.219797979797979*G0_1_0_1_1_1 + 0.0366329966329965*G0_1_0_1_1_2 + 0.0366329966329965*G0_1_0_1_2_1 - 0.0366329966329964*G0_1_0_1_2_2 + 0.028013468013468*G0_1_0_2_0_0 + 0.0126214526214526*G0_1_0_2_0_2 + 0.0366329966329965*G0_1_0_2_1_1 - 0.0366329966329964*G0_1_0_2_1_2 + 0.0126214526214526*G0_1_0_2_2_0 - 0.0366329966329964*G0_1_0_2_2_1 - 0.219797979797978*G0_1_0_2_2_2 + 0.247298380631714*G0_1_1_0_0_0 + 0.0289369889369889*G0_1_1_0_0_1 + 0.0398140131473463*G0_1_1_0_0_2 + 0.0289369889369889*G0_1_1_0_1_0 + 0.0223697290363956*G0_1_1_0_1_1 + 0.00513067179733844*G0_1_1_0_1_2 + 0.0398140131473463*G0_1_1_0_2_0 + 0.00513067179733844*G0_1_1_0_2_1 + 0.0114927048260381*G0_1_1_0_2_2 + 0.0289369889369889*G0_1_1_1_0_0 + 0.0223697290363956*G0_1_1_1_0_1 + 0.00513067179733844*G0_1_1_1_0_2 + 0.0223697290363956*G0_1_1_1_1_0 + 0.276235369568702*G0_1_1_1_1_1 + 0.0400192400192399*G0_1_1_1_1_2 + 0.00513067179733844*G0_1_1_1_2_0 + 0.0400192400192399*G0_1_1_1_2_1 - 0.0338624338624336*G0_1_1_1_2_2 + 0.0398140131473463*G0_1_1_2_0_0 + 0.00513067179733844*G0_1_1_2_0_1 + 0.0114927048260381*G0_1_1_2_0_2 + 0.00513067179733844*G0_1_1_2_1_0 + 0.0400192400192399*G0_1_1_2_1_1 - 0.0338624338624336*G0_1_1_2_1_2 + 0.0114927048260381*G0_1_1_2_2_0 - 0.0338624338624336*G0_1_1_2_2_1 - 0.203379830046495*G0_1_1_2_2_2;
    A[91] = A[21] + 0.0167644700978036*G0_0_1_0_0_0 - 0.000333493666826982*G0_0_1_0_0_1 - 0.00288600288600285*G0_0_1_0_0_2 - 0.000333493666826982*G0_0_1_0_1_0 - 0.00071401849179627*G0_0_1_0_1_1 - 0.00288600288600285*G0_0_1_0_2_0 - 0.00197103308214418*G0_0_1_0_2_2 - 0.000333493666826983*G0_0_1_1_0_0 - 0.00071401849179627*G0_0_1_1_0_1 - 0.00071401849179627*G0_0_1_1_1_0 + 0.000714018491796263*G0_0_1_1_1_2 + 0.000714018491796263*G0_0_1_1_2_1 + 0.000213777991555758*G0_0_1_1_2_2 - 0.00288600288600285*G0_0_1_2_0_0 - 0.00197103308214418*G0_0_1_2_0_2 + 0.000714018491796263*G0_0_1_2_1_1 + 0.000213777991555758*G0_0_1_2_1_2 - 0.00197103308214418*G0_0_1_2_2_0 + 0.000213777991555758*G0_0_1_2_2_1 - 0.00219336219336225*G0_0_1_2_2_2 - 0.0167644700978036*G0_1_0_0_0_0 + 0.000333493666826982*G0_1_0_0_0_1 + 0.00288600288600285*G0_1_0_0_0_2 + 0.000333493666826982*G0_1_0_0_1_0 + 0.00071401849179627*G0_1_0_0_1_1 + 0.00288600288600285*G0_1_0_0_2_0 + 0.00197103308214418*G0_1_0_0_2_2 + 0.000333493666826982*G0_1_0_1_0_0 + 0.00071401849179627*G0_1_0_1_0_1 + 0.00071401849179627*G0_1_0_1_1_0 - 0.000714018491796263*G0_1_0_1_1_2 - 0.000714018491796263*G0_1_0_1_2_1 - 0.000213777991555758*G0_1_0_1_2_2 + 0.00288600288600285*G0_1_0_2_0_0 + 0.00197103308214418*G0_1_0_2_0_2 - 0.000714018491796263*G0_1_0_2_1_1 - 0.000213777991555758*G0_1_0_2_1_2 + 0.00197103308214418*G0_1_0_2_2_0 - 0.000213777991555758*G0_1_0_2_2_1 + 0.00219336219336225*G0_1_0_2_2_2;
    A[82] = A[110] - 0.00823472823472812*G0_0_1_0_0_0 - 0.000820907487574111*G0_0_1_0_0_1 - 0.00336059002725665*G0_0_1_0_0_2 - 0.000820907487574111*G0_0_1_0_1_0 - 0.000897867564534169*G0_0_1_0_1_1 - 0.00336059002725665*G0_0_1_0_2_0 - 0.0135962802629468*G0_0_1_0_2_2 - 0.000820907487574111*G0_0_1_1_0_0 - 0.000897867564534169*G0_0_1_1_0_1 - 0.000897867564534169*G0_0_1_1_1_0 - 0.00892736892736847*G0_0_1_1_1_1 - 0.0138784672118004*G0_0_1_1_1_2 - 0.0138784672118004*G0_0_1_1_2_1 - 0.0200096200096199*G0_0_1_1_2_2 - 0.00336059002725665*G0_0_1_2_0_0 - 0.0135962802629468*G0_0_1_2_0_2 - 0.0138784672118004*G0_0_1_2_1_1 - 0.0200096200096199*G0_0_1_2_1_2 - 0.0135962802629468*G0_0_1_2_2_0 - 0.0200096200096199*G0_0_1_2_2_1 + 0.174699374699373*G0_0_1_2_2_2 + 0.00823472823472812*G0_1_0_0_0_0 + 0.000820907487574111*G0_1_0_0_0_1 + 0.00336059002725665*G0_1_0_0_0_2 + 0.000820907487574111*G0_1_0_0_1_0 + 0.000897867564534169*G0_1_0_0_1_1 + 0.00336059002725665*G0_1_0_0_2_0 + 0.0135962802629468*G0_1_0_0_2_2 + 0.000820907487574111*G0_1_0_1_0_0 + 0.000897867564534169*G0_1_0_1_0_1 + 0.000897867564534169*G0_1_0_1_1_0 + 0.00892736892736847*G0_1_0_1_1_1 + 0.0138784672118004*G0_1_0_1_1_2 + 0.0138784672118004*G0_1_0_1_2_1 + 0.0200096200096199*G0_1_0_1_2_2 + 0.00336059002725665*G0_1_0_2_0_0 + 0.0135962802629468*G0_1_0_2_0_2 + 0.0138784672118004*G0_1_0_2_1_1 + 0.0200096200096199*G0_1_0_2_1_2 + 0.0135962802629468*G0_1_0_2_2_0 + 0.0200096200096199*G0_1_0_2_2_1 - 0.174699374699373*G0_1_0_2_2_2;
    A[153] = A[82] - 0.0539490139490137*G0_0_0_0_0_0 - 0.0173160173160172*G0_0_0_0_0_1 - 0.00774731441398098*G0_0_0_0_0_2 - 0.0173160173160172*G0_0_0_0_1_0 - 0.0230110630110629*G0_0_0_0_1_1 - 0.00651595318261982*G0_0_0_0_1_2 - 0.00774731441398097*G0_0_0_0_2_0 - 0.00651595318261982*G0_0_0_0_2_1 + 0.00184704184704202*G0_0_0_0_2_2 - 0.0173160173160172*G0_0_0_1_0_0 - 0.0230110630110629*G0_0_0_1_0_1 - 0.00651595318261982*G0_0_0_1_0_2 - 0.0230110630110629*G0_0_0_1_1_0 + 0.194632034632033*G0_0_0_1_1_1 + 0.0315536315536313*G0_0_0_1_1_2 - 0.00651595318261982*G0_0_0_1_2_0 + 0.0315536315536313*G0_0_0_1_2_1 - 0.0430976430976429*G0_0_0_1_2_2 - 0.00774731441398097*G0_0_0_2_0_0 - 0.00651595318261982*G0_0_0_2_0_1 + 0.00184704184704201*G0_0_0_2_0_2 - 0.00651595318261982*G0_0_0_2_1_0 + 0.0315536315536313*G0_0_0_2_1_1 - 0.0430976430976428*G0_0_0_2_1_2 + 0.00184704184704201*G0_0_0_2_2_0 - 0.0430976430976429*G0_0_0_2_2_1 - 0.588590668590664*G0_0_0_2_2_2 - 0.0128010261343594*G0_0_1_0_0_1 + 0.0128010261343594*G0_0_1_0_0_2 - 0.0128010261343594*G0_0_1_0_1_0 - 0.0261407728074393*G0_0_1_0_1_1 + 0.0128010261343594*G0_0_1_0_2_0 + 0.0261407728074395*G0_0_1_0_2_2 - 0.0128010261343594*G0_0_1_1_0_0 - 0.0261407728074393*G0_0_1_1_0_1 - 0.0261407728074393*G0_0_1_1_1_0 + 0.450832130832129*G0_0_1_1_1_1 + 0.0347089947089946*G0_0_1_1_1_2 + 0.0347089947089946*G0_0_1_1_2_1 - 0.0347089947089945*G0_0_1_1_2_2 + 0.0128010261343594*G0_0_1_2_0_0 + 0.0261407728074395*G0_0_1_2_0_2 + 0.0347089947089946*G0_0_1_2_1_1 - 0.0347089947089945*G0_0_1_2_1_2 + 0.0261407728074395*G0_0_1_2_2_0 - 0.0347089947089945*G0_0_1_2_2_1 - 0.450832130832127*G0_0_1_2_2_2 - 0.0102613435946768*G0_1_0_0_0_1 + 0.010261343594677*G0_1_0_0_0_2 - 0.0102613435946768*G0_1_0_0_1_0 - 0.0134423601090267*G0_1_0_0_1_1 + 0.010261343594677*G0_1_0_0_2_0 + 0.0134423601090269*G0_1_0_0_2_2 - 0.0102613435946768*G0_1_0_1_0_0 - 0.0134423601090267*G0_1_0_1_0_1 - 0.0134423601090267*G0_1_0_1_1_0 + 0.267205387205386*G0_1_0_1_1_1 + 0.0408401475068139*G0_1_0_1_1_2 + 0.0408401475068139*G0_1_0_1_2_1 - 0.0408401475068139*G0_1_0_1_2_2 + 0.010261343594677*G0_1_0_2_0_0 + 0.0134423601090269*G0_1_0_2_0_2 + 0.0408401475068139*G0_1_0_2_1_1 - 0.0408401475068139*G0_1_0_2_1_2 + 0.0134423601090269*G0_1_0_2_2_0 - 0.0408401475068139*G0_1_0_2_2_1 - 0.267205387205385*G0_1_0_2_2_2 + 0.0539490139490135*G0_1_1_0_0_0 + 0.00774731441398108*G0_1_1_0_0_1 + 0.0173160173160173*G0_1_1_0_0_2 + 0.00774731441398108*G0_1_1_0_1_0 - 0.00184704184704174*G0_1_1_0_1_1 + 0.00651595318261984*G0_1_1_0_1_2 + 0.0173160173160173*G0_1_1_0_2_0 + 0.00651595318261985*G0_1_1_0_2_1 + 0.023011063011063*G0_1_1_0_2_2 + 0.00774731441398108*G0_1_1_1_0_0 - 0.00184704184704174*G0_1_1_1_0_1 + 0.00651595318261985*G0_1_1_1_0_2 - 0.00184704184704175*G0_1_1_1_1_0 + 0.588590668590666*G0_1_1_1_1_1 + 0.0430976430976429*G0_1_1_1_1_2 + 0.00651595318261985*G0_1_1_1_2_0 + 0.0430976430976429*G0_1_1_1_2_1 - 0.0315536315536313*G0_1_1_1_2_2 + 0.0173160173160173*G0_1_1_2_0_0 + 0.00651595318261985*G0_1_1_2_0_1 + 0.023011063011063*G0_1_1_2_0_2 + 0.00651595318261985*G0_1_1_2_1_0 + 0.0430976430976429*G0_1_1_2_1_1 - 0.0315536315536313*G0_1_1_2_1_2 + 0.023011063011063*G0_1_1_2_2_0 - 0.0315536315536313*G0_1_1_2_2_1 - 0.194632034632033*G0_1_1_2_2_2;
    A[100] = A[153] + 0.249504569504568*G0_0_0_0_0_0 - 0.00559243225909887*G0_0_0_0_0_1 + 0.0608497675164337*G0_0_0_0_0_2 - 0.00559243225909887*G0_0_0_0_1_0 + 0.00559243225909883*G0_0_0_0_1_1 + 0.0608497675164337*G0_0_0_0_2_0 + 0.0238063171396503*G0_0_0_0_2_2 - 0.00559243225909886*G0_0_0_1_0_0 + 0.00559243225909883*G0_0_0_1_0_1 + 0.00559243225909883*G0_0_0_1_1_0 - 0.249504569504568*G0_0_0_1_1_1 - 0.0608497675164339*G0_0_0_1_1_2 - 0.0608497675164339*G0_0_0_1_2_1 - 0.0238063171396503*G0_0_0_1_2_2 + 0.0608497675164337*G0_0_0_2_0_0 + 0.0238063171396503*G0_0_0_2_0_2 - 0.0608497675164339*G0_0_0_2_1_1 - 0.0238063171396503*G0_0_0_2_1_2 + 0.0238063171396503*G0_0_0_2_2_0 - 0.0238063171396503*G0_0_0_2_2_1 - 0.0689818823152153*G0_0_1_0_0_0 + 0.00520763187429845*G0_0_1_0_0_1 - 0.0186243386243386*G0_0_1_0_0_2 + 0.00520763187429845*G0_0_1_0_1_0 + 0.0210357543690874*G0_0_1_0_1_1 - 0.00253968253968255*G0_0_1_0_1_2 - 0.0186243386243386*G0_0_1_0_2_0 - 0.00253968253968255*G0_0_1_0_2_1 - 0.00761904761904761*G0_0_1_0_2_2 + 0.00520763187429845*G0_0_1_1_0_0 + 0.0210357543690874*G0_0_1_1_0_1 - 0.00253968253968255*G0_0_1_1_0_2 + 0.0210357543690874*G0_0_1_1_1_0 - 0.501420554753887*G0_0_1_1_1_1 - 0.0602853936187267*G0_0_1_1_1_2 - 0.00253968253968255*G0_0_1_1_2_0 - 0.0602853936187267*G0_0_1_1_2_1 - 0.0184447651114317*G0_0_1_1_2_2 - 0.0186243386243386*G0_0_1_2_0_0 - 0.00253968253968255*G0_0_1_2_0_1 - 0.00761904761904761*G0_0_1_2_0_2 - 0.00253968253968255*G0_0_1_2_1_0 - 0.0602853936187267*G0_0_1_2_1_1 - 0.0184447651114317*G0_0_1_2_1_2 - 0.00761904761904761*G0_0_1_2_2_0 - 0.0184447651114317*G0_0_1_2_2_1 - 0.0077986211319544*G0_0_1_2_2_2 - 0.251915985249318*G0_1_0_0_0_0 + 0.0154433221099886*G0_1_0_0_0_1 + 0.000564373897707121*G0_1_0_0_0_2 + 0.0154433221099886*G0_1_0_0_1_0 + 0.0108000641333974*G0_1_0_0_1_1 - 0.00253968253968254*G0_1_0_0_1_2 + 0.00056437389770713*G0_1_0_0_2_0 - 0.00253968253968254*G0_1_0_0_2_1 + 0.00536155202821861*G0_1_0_0_2_2 + 0.0154433221099886*G0_1_0_1_0_0 + 0.0108000641333974*G0_1_0_1_0_1 - 0.00253968253968254*G0_1_0_1_0_2 + 0.0108000641333974*G0_1_0_1_1_0 - 0.318486451819783*G0_1_0_1_1_1 - 0.0794741061407723*G0_1_0_1_1_2 - 0.00253968253968254*G0_1_0_1_2_0 - 0.0794741061407723*G0_1_0_1_2_1 - 0.0314253647586979*G0_1_0_1_2_2 + 0.000564373897707123*G0_1_0_2_0_0 - 0.00253968253968254*G0_1_0_2_0_1 + 0.00536155202821861*G0_1_0_2_0_2 - 0.00253968253968254*G0_1_0_2_1_0 - 0.0794741061407723*G0_1_0_2_1_1 - 0.0314253647586979*G0_1_0_2_1_2 + 0.00536155202821861*G0_1_0_2_2_0 - 0.0314253647586979*G0_1_0_2_2_1 - 0.00779862113195436*G0_1_0_2_2_2 + 0.0583100849767505*G0_1_1_0_0_0 + 0.0161616161616159*G0_1_1_0_0_1 - 0.00674683341350016*G0_1_1_0_0_2 + 0.0161616161616159*G0_1_1_0_1_0 + 0.0100817700817699*G0_1_1_0_1_1 - 0.00253968253968255*G0_1_1_0_1_2 - 0.00674683341350016*G0_1_1_0_2_0 - 0.00253968253968255*G0_1_1_0_2_1 - 0.00595157928491262*G0_1_1_0_2_2 + 0.0161616161616159*G0_1_1_1_0_0 + 0.0100817700817699*G0_1_1_1_0_1 - 0.00253968253968256*G0_1_1_1_0_2 + 0.0100817700817699*G0_1_1_1_1_0 - 0.628712522045852*G0_1_1_1_1_1 - 0.0721628988295651*G0_1_1_1_1_2 - 0.00253968253968255*G0_1_1_1_2_0 - 0.0721628988295651*G0_1_1_1_2_1 - 0.0201122334455667*G0_1_1_1_2_2 - 0.00674683341350016*G0_1_1_2_0_0 - 0.00253968253968255*G0_1_1_2_0_1 - 0.00595157928491262*G0_1_1_2_0_2 - 0.00253968253968255*G0_1_1_2_1_0 - 0.0721628988295651*G0_1_1_2_1_1 - 0.0201122334455667*G0_1_1_2_1_2 - 0.00595157928491262*G0_1_1_2_2_0 - 0.0201122334455667*G0_1_1_2_2_1 - 0.0077986211319544*G0_1_1_2_2_2;
    A[163] = -A[153] + 0.20078884078884*G0_0_0_0_0_0 + 0.0214205547538879*G0_0_0_0_0_1 + 0.0520763187429851*G0_0_0_0_0_2 + 0.0214205547538879*G0_0_0_0_1_0 - 0.021420554753888*G0_0_0_0_1_1 + 0.0520763187429851*G0_0_0_0_2_0 + 0.0207279140612473*G0_0_0_0_2_2 + 0.0214205547538879*G0_0_0_1_0_0 - 0.021420554753888*G0_0_0_1_0_1 - 0.021420554753888*G0_0_0_1_1_0 - 0.20078884078884*G0_0_0_1_1_1 - 0.0520763187429851*G0_0_0_1_1_2 - 0.0520763187429851*G0_0_0_1_2_1 - 0.0207279140612472*G0_0_0_1_2_2 + 0.0520763187429851*G0_0_0_2_0_0 + 0.0207279140612473*G0_0_0_2_0_2 - 0.0520763187429851*G0_0_0_2_1_1 - 0.0207279140612472*G0_0_0_2_1_2 + 0.0207279140612473*G0_0_0_2_2_0 - 0.0207279140612472*G0_0_0_2_2_1 + 0.00482283148949752*G0_0_1_0_0_0 - 0.057771364438031*G0_0_1_0_0_1 - 0.00179573512906847*G0_0_1_0_0_2 - 0.057771364438031*G0_0_1_0_1_0 - 0.155767195767195*G0_0_1_0_1_1 - 0.0116466249799582*G0_0_1_0_1_2 - 0.00179573512906847*G0_0_1_0_2_0 - 0.0116466249799582*G0_0_1_0_2_1 - 0.000102613435946754*G0_0_1_0_2_2 - 0.057771364438031*G0_0_1_1_0_0 - 0.155767195767195*G0_0_1_1_0_1 - 0.0116466249799582*G0_0_1_1_0_2 - 0.155767195767195*G0_0_1_1_1_0 - 0.204200737534069*G0_0_1_1_1_1 - 0.0661343594676923*G0_0_1_1_1_2 - 0.0116466249799582*G0_0_1_1_2_0 - 0.0661343594676923*G0_0_1_1_2_1 - 0.0271925605258936*G0_0_1_1_2_2 - 0.00179573512906847*G0_0_1_2_0_0 - 0.0116466249799582*G0_0_1_2_0_1 - 0.000102613435946753*G0_0_1_2_0_2 - 0.0116466249799582*G0_0_1_2_1_0 - 0.0661343594676923*G0_0_1_2_1_1 - 0.0271925605258936*G0_0_1_2_1_2 - 0.000102613435946753*G0_0_1_2_2_0 - 0.0271925605258936*G0_0_1_2_2_1 - 0.0150328683662016*G0_0_1_2_2_2 - 0.0557447490780823*G0_1_0_0_0_0 - 0.0495622895622893*G0_1_0_0_0_1 - 0.0182908449575116*G0_1_0_0_0_2 - 0.0495622895622893*G0_1_0_0_1_0 - 0.0709828443161773*G0_1_0_0_1_1 - 0.0199839666506332*G0_1_0_0_1_2 - 0.0182908449575116*G0_1_0_0_2_0 - 0.0199839666506332*G0_1_0_0_2_1 - 0.0108257174923842*G0_1_0_0_2_2 - 0.0495622895622893*G0_1_0_1_0_0 - 0.0709828443161773*G0_1_0_1_0_1 - 0.0199839666506332*G0_1_0_1_0_2 - 0.0709828443161773*G0_1_0_1_1_0 - 0.256533589866922*G0_1_0_1_1_1 - 0.0703671637004966*G0_1_0_1_1_2 - 0.0199839666506332*G0_1_0_1_2_0 - 0.0703671637004966*G0_1_0_1_2_1 - 0.0315536315536313*G0_1_0_1_2_2 - 0.0182908449575116*G0_1_0_2_0_0 - 0.0199839666506332*G0_1_0_2_0_1 - 0.0108257174923842*G0_1_0_2_0_2 - 0.0199839666506332*G0_1_0_2_1_0 - 0.0703671637004966*G0_1_0_2_1_1 - 0.0315536315536313*G0_1_0_2_1_2 - 0.0108257174923842*G0_1_0_2_2_0 - 0.0315536315536313*G0_1_0_2_2_1 - 0.0236523969857302*G0_1_0_2_2_2 - 0.13083213083213*G0_1_1_0_0_0 - 0.149661696328362*G0_1_1_0_0_1 - 0.0163668430335096*G0_1_1_0_0_2 - 0.149661696328362*G0_1_1_0_1_0 - 0.236010902677568*G0_1_1_0_1_1 - 0.02349847683181*G0_1_1_0_1_2 - 0.0163668430335096*G0_1_1_0_2_0 - 0.02349847683181*G0_1_1_0_2_1 - 0.00472021805355135*G0_1_1_0_2_2 - 0.149661696328362*G0_1_1_1_0_0 - 0.236010902677568*G0_1_1_1_0_1 - 0.02349847683181*G0_1_1_1_0_2 - 0.236010902677568*G0_1_1_1_1_0 - 0.186243386243385*G0_1_1_1_1_1 - 0.0856822190155518*G0_1_1_1_1_2 - 0.02349847683181*G0_1_1_1_2_0 - 0.0856822190155518*G0_1_1_1_2_1 - 0.0403783870450534*G0_1_1_1_2_2 - 0.0163668430335096*G0_1_1_2_0_0 - 0.0234984768318101*G0_1_1_2_0_1 - 0.00472021805355135*G0_1_1_2_0_2 - 0.0234984768318101*G0_1_1_2_1_0 - 0.0856822190155518*G0_1_1_2_1_1 - 0.0403783870450534*G0_1_1_2_1_2 - 0.00472021805355135*G0_1_1_2_2_0 - 0.0403783870450534*G0_1_1_2_2_1 - 0.0260125060125058*G0_1_1_2_2_2;
    A[205] = A[163] - 0.0688023088023081*G0_0_1_0_0_0 + 0.00484848484848492*G0_0_1_0_0_1 - 0.0173160173160173*G0_0_1_0_0_2 + 0.00484848484848492*G0_0_1_0_1_0 + 0.0711880711880709*G0_0_1_0_1_1 - 0.00831168831168829*G0_0_1_0_1_2 - 0.0173160173160173*G0_0_1_0_2_0 - 0.00831168831168828*G0_0_1_0_2_1 - 0.0116209716209717*G0_0_1_0_2_2 + 0.00484848484848492*G0_0_1_1_0_0 + 0.0711880711880709*G0_0_1_1_0_1 - 0.00831168831168829*G0_0_1_1_0_2 + 0.0711880711880709*G0_0_1_1_1_0 + 0.122366522366522*G0_0_1_1_1_1 - 0.0242424242424241*G0_0_1_1_1_2 - 0.00831168831168828*G0_0_1_1_2_0 - 0.0242424242424241*G0_0_1_1_2_1 - 0.0182395382395382*G0_0_1_1_2_2 - 0.0173160173160173*G0_0_1_2_0_0 - 0.00831168831168829*G0_0_1_2_0_1 - 0.0116209716209717*G0_0_1_2_0_2 - 0.00831168831168829*G0_0_1_2_1_0 - 0.0242424242424241*G0_0_1_2_1_1 - 0.0182395382395382*G0_0_1_2_1_2 - 0.0116209716209717*G0_0_1_2_2_0 - 0.0182395382395382*G0_0_1_2_2_1 - 0.0175468975468975*G0_0_1_2_2_2 + 0.0688023088023081*G0_1_0_0_0_0 - 0.00484848484848492*G0_1_0_0_0_1 + 0.0173160173160173*G0_1_0_0_0_2 - 0.00484848484848492*G0_1_0_0_1_0 - 0.071188071188071*G0_1_0_0_1_1 + 0.00831168831168829*G0_1_0_0_1_2 + 0.0173160173160173*G0_1_0_0_2_0 + 0.00831168831168829*G0_1_0_0_2_1 + 0.0116209716209717*G0_1_0_0_2_2 - 0.00484848484848492*G0_1_0_1_0_0 - 0.071188071188071*G0_1_0_1_0_1 + 0.00831168831168829*G0_1_0_1_0_2 - 0.071188071188071*G0_1_0_1_1_0 - 0.122366522366522*G0_1_0_1_1_1 + 0.0242424242424241*G0_1_0_1_1_2 + 0.00831168831168829*G0_1_0_1_2_0 + 0.0242424242424241*G0_1_0_1_2_1 + 0.0182395382395382*G0_1_0_1_2_2 + 0.0173160173160173*G0_1_0_2_0_0 + 0.00831168831168829*G0_1_0_2_0_1 + 0.0116209716209717*G0_1_0_2_0_2 + 0.00831168831168829*G0_1_0_2_1_0 + 0.0242424242424241*G0_1_0_2_1_1 + 0.0182395382395382*G0_1_0_2_1_2 + 0.0116209716209717*G0_1_0_2_2_0 + 0.0182395382395382*G0_1_0_2_2_1 + 0.0175468975468975*G0_1_0_2_2_2;
    A[208] = -A[163] + 0.563270803270801*G0_0_0_0_0_0 + 0.139836459836459*G0_0_0_0_0_1 + 0.251813371813371*G0_0_0_0_0_2 + 0.139836459836459*G0_0_0_0_1_0 + 0.127215007215007*G0_0_0_0_1_1 + 0.0885040885040882*G0_0_0_0_1_2 + 0.251813371813371*G0_0_0_0_2_0 + 0.0885040885040882*G0_0_0_0_2_1 + 0.211640211640211*G0_0_0_0_2_2 + 0.139836459836459*G0_0_0_1_0_0 + 0.127215007215007*G0_0_0_1_0_1 + 0.0885040885040882*G0_0_0_1_0_2 + 0.127215007215007*G0_0_0_1_1_0 + 0.577123617123614*G0_0_0_1_1_1 + 0.264126984126983*G0_0_0_1_1_2 + 0.0885040885040882*G0_0_0_1_2_0 + 0.264126984126983*G0_0_0_1_2_1 + 0.185781625781625*G0_0_0_1_2_2 + 0.251813371813371*G0_0_0_2_0_0 + 0.0885040885040882*G0_0_0_2_0_1 + 0.211640211640211*G0_0_0_2_0_2 + 0.0885040885040882*G0_0_0_2_1_0 + 0.264126984126983*G0_0_0_2_1_1 + 0.185781625781625*G0_0_0_2_1_2 + 0.211640211640211*G0_0_0_2_2_0 + 0.185781625781625*G0_0_0_2_2_1 + 0.374641654641653*G0_0_0_2_2_2 + 0.0631842231842225*G0_0_1_0_0_0 - 0.00700336700336703*G0_0_1_0_0_1 + 0.0115440115440116*G0_0_1_0_0_2 - 0.00700336700336703*G0_0_1_0_1_0 - 0.061260221260221*G0_0_1_0_1_1 + 0.0140836940836941*G0_0_1_0_1_2 + 0.0115440115440116*G0_0_1_0_2_0 + 0.0140836940836941*G0_0_1_0_2_1 + 0.0116209716209717*G0_0_1_0_2_2 - 0.00700336700336703*G0_0_1_1_0_0 - 0.061260221260221*G0_0_1_1_0_1 + 0.0140836940836941*G0_0_1_1_0_2 - 0.061260221260221*G0_0_1_1_1_0 + 0.123905723905723*G0_0_1_1_1_1 + 0.19132275132275*G0_0_1_1_1_2 + 0.0140836940836941*G0_0_1_1_2_0 + 0.19132275132275*G0_0_1_1_2_1 + 0.119672919672919*G0_0_1_1_2_2 + 0.0115440115440116*G0_0_1_2_0_0 + 0.0140836940836941*G0_0_1_2_0_1 + 0.0116209716209717*G0_0_1_2_0_2 + 0.0140836940836941*G0_0_1_2_1_0 + 0.19132275132275*G0_0_1_2_1_1 + 0.119672919672919*G0_0_1_2_1_2 + 0.0116209716209717*G0_0_1_2_2_0 + 0.119672919672919*G0_0_1_2_2_1 + 0.0989706589706585*G0_0_1_2_2_2 - 0.00561808561808561*G0_1_0_0_0_0 - 0.0021548821548821*G0_1_0_0_0_1 - 0.00577200577200573*G0_1_0_0_0_2 - 0.0021548821548821*G0_1_0_0_1_0 + 0.00992784992784992*G0_1_0_0_1_1 + 0.00577200577200578*G0_1_0_0_1_2 - 0.00577200577200573*G0_1_0_0_2_0 + 0.00577200577200577*G0_1_0_0_2_1 - 0.0021548821548821*G0_1_0_1_0_0 + 0.00992784992784994*G0_1_0_1_0_1 + 0.00577200577200578*G0_1_0_1_0_2 + 0.00992784992784994*G0_1_0_1_1_0 + 0.246272246272245*G0_1_0_1_1_1 + 0.167080327080326*G0_1_0_1_1_2 + 0.00577200577200578*G0_1_0_1_2_0 + 0.167080327080326*G0_1_0_1_2_1 + 0.101433381433381*G0_1_0_1_2_2 - 0.00577200577200573*G0_1_0_2_0_0 + 0.00577200577200577*G0_1_0_2_0_1 + 0.00577200577200578*G0_1_0_2_1_0 + 0.167080327080326*G0_1_0_2_1_1 + 0.101433381433381*G0_1_0_2_1_2 + 0.101433381433381*G0_1_0_2_2_1 + 0.0814237614237609*G0_1_0_2_2_2 + 0.0299374699374697*G0_1_1_0_0_0 + 0.052178932178932*G0_1_1_0_0_1 + 0.00592592592592589*G0_1_1_0_0_2 + 0.052178932178932*G0_1_1_0_1_0 + 0.143915343915343*G0_1_1_0_1_1 + 0.0240115440115439*G0_1_1_0_1_2 + 0.00592592592592589*G0_1_1_0_2_0 + 0.0240115440115439*G0_1_1_0_2_1 + 0.0174699374699374*G0_1_1_0_2_2 + 0.052178932178932*G0_1_1_1_0_0 + 0.143915343915343*G0_1_1_1_0_1 + 0.0240115440115439*G0_1_1_1_0_2 + 0.143915343915343*G0_1_1_1_1_0 + 0.781914381914378*G0_1_1_1_1_1 + 0.225493025493024*G0_1_1_1_1_2 + 0.0240115440115439*G0_1_1_1_2_0 + 0.225493025493024*G0_1_1_1_2_1 + 0.139913419913419*G0_1_1_1_2_2 + 0.00592592592592589*G0_1_1_2_0_0 + 0.0240115440115439*G0_1_1_2_0_1 + 0.0174699374699374*G0_1_1_2_0_2 + 0.0240115440115439*G0_1_1_2_1_0 + 0.225493025493024*G0_1_1_2_1_1 + 0.139913419913419*G0_1_1_2_1_2 + 0.0174699374699374*G0_1_1_2_2_0 + 0.139913419913419*G0_1_1_2_2_1 + 0.133833573833573*G0_1_1_2_2_2;
    A[192] = A[208] + 0.664935064935062*G0_0_0_0_0_0 + 0.0246272246272245*G0_0_0_0_0_1 + 0.177316017316017*G0_0_0_0_0_2 + 0.0246272246272245*G0_0_0_0_1_0 - 0.0246272246272245*G0_0_0_0_1_1 + 0.177316017316017*G0_0_0_0_2_0 + 0.0394035594035593*G0_0_0_0_2_2 + 0.0246272246272245*G0_0_0_1_0_0 - 0.0246272246272244*G0_0_0_1_0_1 - 0.0246272246272244*G0_0_0_1_1_0 - 0.664935064935061*G0_0_0_1_1_1 - 0.177316017316016*G0_0_0_1_1_2 - 0.177316017316016*G0_0_0_1_2_1 - 0.0394035594035591*G0_0_0_1_2_2 + 0.177316017316017*G0_0_0_2_0_0 + 0.0394035594035593*G0_0_0_2_0_2 - 0.177316017316016*G0_0_0_2_1_1 - 0.0394035594035591*G0_0_0_2_1_2 + 0.0394035594035593*G0_0_0_2_2_0 - 0.0394035594035591*G0_0_0_2_2_1 + 0.147763347763347*G0_0_1_0_0_0 + 0.0221645021645021*G0_0_1_0_0_1 + 0.0467917267917265*G0_0_1_0_0_2 + 0.0221645021645021*G0_0_1_0_1_0 - 0.00246272246272237*G0_0_1_0_1_1 + 0.0344781144781144*G0_0_1_0_1_2 + 0.0467917267917265*G0_0_1_0_2_0 + 0.0344781144781144*G0_0_1_0_2_1 + 0.0541798941798939*G0_0_1_0_2_2 + 0.0221645021645021*G0_0_1_1_0_0 - 0.00246272246272239*G0_0_1_1_0_1 + 0.0344781144781144*G0_0_1_1_0_2 - 0.00246272246272239*G0_0_1_1_1_0 - 0.517171717171714*G0_0_1_1_1_1 - 0.13052429052429*G0_0_1_1_1_2 + 0.0344781144781144*G0_0_1_1_2_0 - 0.13052429052429*G0_0_1_1_2_1 + 0.0147763347763349*G0_0_1_1_2_2 + 0.0467917267917265*G0_0_1_2_0_0 + 0.0344781144781144*G0_0_1_2_0_1 + 0.0541798941798939*G0_0_1_2_0_2 + 0.0344781144781144*G0_0_1_2_1_0 - 0.13052429052429*G0_0_1_2_1_1 + 0.0147763347763349*G0_0_1_2_1_2 + 0.0541798941798939*G0_0_1_2_2_0 + 0.0147763347763349*G0_0_1_2_2_1 + 0.147763347763347*G0_0_1_2_2_2 + 0.147763347763347*G0_1_0_0_0_0 + 0.0221645021645021*G0_1_0_0_0_1 + 0.0467917267917265*G0_1_0_0_0_2 + 0.0221645021645021*G0_1_0_0_1_0 - 0.00246272246272237*G0_1_0_0_1_1 + 0.0344781144781144*G0_1_0_0_1_2 + 0.0467917267917265*G0_1_0_0_2_0 + 0.0344781144781144*G0_1_0_0_2_1 + 0.0541798941798939*G0_1_0_0_2_2 + 0.0221645021645021*G0_1_0_1_0_0 - 0.00246272246272239*G0_1_0_1_0_1 + 0.0344781144781144*G0_1_0_1_0_2 - 0.00246272246272239*G0_1_0_1_1_0 - 0.517171717171714*G0_1_0_1_1_1 - 0.13052429052429*G0_1_0_1_1_2 + 0.0344781144781144*G0_1_0_1_2_0 - 0.13052429052429*G0_1_0_1_2_1 + 0.0147763347763349*G0_1_0_1_2_2 + 0.0467917267917265*G0_1_0_2_0_0 + 0.0344781144781144*G0_1_0_2_0_1 + 0.0541798941798939*G0_1_0_2_0_2 + 0.0344781144781144*G0_1_0_2_1_0 - 0.13052429052429*G0_1_0_2_1_1 + 0.0147763347763349*G0_1_0_2_1_2 + 0.0541798941798939*G0_1_0_2_2_0 + 0.0147763347763349*G0_1_0_2_2_1 + 0.147763347763347*G0_1_0_2_2_2 + 0.812698412698409*G0_1_1_0_0_0 + 0.167465127465127*G0_1_1_0_0_1 + 0.103434343434343*G0_1_1_0_0_2 + 0.167465127465127*G0_1_1_0_1_0 - 0.147763347763347*G0_1_1_0_1_1 + 0.0344781144781144*G0_1_1_0_1_2 + 0.103434343434343*G0_1_1_0_2_0 + 0.0344781144781143*G0_1_1_0_2_1 + 0.0788071188071185*G0_1_1_0_2_2 + 0.167465127465127*G0_1_1_1_0_0 - 0.147763347763347*G0_1_1_1_0_1 + 0.0344781144781144*G0_1_1_1_0_2 - 0.147763347763347*G0_1_1_1_1_0 - 1.18210678210678*G0_1_1_1_1_1 - 0.187166907166906*G0_1_1_1_1_2 + 0.0344781144781143*G0_1_1_1_2_0 - 0.187166907166906*G0_1_1_1_2_1 - 0.00985088985088972*G0_1_1_1_2_2 + 0.103434343434343*G0_1_1_2_0_0 + 0.0344781144781144*G0_1_1_2_0_1 + 0.0788071188071185*G0_1_1_2_0_2 + 0.0344781144781144*G0_1_1_2_1_0 - 0.187166907166906*G0_1_1_2_1_1 - 0.00985088985088969*G0_1_1_2_1_2 + 0.0788071188071185*G0_1_1_2_2_0 - 0.00985088985088967*G0_1_1_2_2_1 + 0.147763347763348*G0_1_1_2_2_2;
    A[168] = -A[176] + 0.208613115279781*G0_0_0_0_0_0 + 0.0559243225909891*G0_0_0_0_0_1 + 0.0515119448452778*G0_0_0_0_0_2 + 0.0559243225909891*G0_0_0_0_1_0 + 0.0855111966223074*G0_0_0_0_1_1 + 0.0165891721447276*G0_0_0_0_1_2 + 0.0515119448452778*G0_0_0_0_2_0 + 0.0165891721447276*G0_0_0_0_2_1 + 0.0334861845972955*G0_0_0_0_2_2 + 0.0559243225909891*G0_0_0_1_0_0 + 0.0855111966223074*G0_0_0_1_0_1 + 0.0165891721447276*G0_0_0_1_0_2 + 0.0855111966223074*G0_0_0_1_1_0 + 0.539746673080005*G0_0_0_1_1_1 + 0.0294158516380738*G0_0_0_1_1_2 + 0.0165891721447276*G0_0_0_1_2_0 + 0.0294158516380738*G0_0_0_1_2_1 + 0.0104323659879215*G0_0_0_1_2_2 + 0.0515119448452778*G0_0_0_2_0_0 + 0.0165891721447276*G0_0_0_2_0_1 + 0.0334861845972955*G0_0_0_2_0_2 + 0.0165891721447276*G0_0_0_2_1_0 + 0.0294158516380738*G0_0_0_2_1_1 + 0.0104323659879215*G0_0_0_2_1_2 + 0.0334861845972955*G0_0_0_2_2_0 + 0.0104323659879215*G0_0_0_2_2_1 + 0.0463812730479394*G0_0_0_2_2_2 - 0.00769600769600779*G0_1_0_0_0_0 - 0.0123136123136122*G0_1_0_0_0_1 - 0.00256533589866923*G0_1_0_0_0_2 - 0.0123136123136122*G0_1_0_0_1_0 - 0.0266794933461598*G0_1_0_0_1_1 - 0.00615680615680612*G0_1_0_0_1_2 - 0.00256533589866923*G0_1_0_0_2_0 - 0.00615680615680612*G0_1_0_0_2_1 - 0.00256533589866921*G0_1_0_0_2_2 - 0.0123136123136122*G0_1_0_1_0_0 - 0.0266794933461598*G0_1_0_1_0_1 - 0.00615680615680612*G0_1_0_1_0_2 - 0.0266794933461598*G0_1_0_1_1_0 + 0.301683501683502*G0_1_0_1_1_1 - 0.0266794933461599*G0_1_0_1_1_2 - 0.00615680615680612*G0_1_0_1_2_0 - 0.0266794933461599*G0_1_0_1_2_1 - 0.0123136123136123*G0_1_0_1_2_2 - 0.00256533589866923*G0_1_0_2_0_0 - 0.00615680615680613*G0_1_0_2_0_1 - 0.00256533589866921*G0_1_0_2_0_2 - 0.00615680615680613*G0_1_0_2_1_0 - 0.0266794933461599*G0_1_0_2_1_1 - 0.0123136123136123*G0_1_0_2_1_2 - 0.00256533589866921*G0_1_0_2_2_0 - 0.0123136123136123*G0_1_0_2_2_1 - 0.00769600769600762*G0_1_0_2_2_2;
    A[204] = A[148] + 0.0523328523328516*G0_0_1_0_0_0 - 0.0087221420554753*G0_0_1_0_0_1 + 0.00153920153920153*G0_0_1_0_0_2 - 0.0087221420554753*G0_0_1_0_1_0 - 0.0202148468815134*G0_0_1_0_1_1 - 0.000410453743787047*G0_0_1_0_1_2 + 0.00153920153920154*G0_0_1_0_2_0 - 0.000410453743787045*G0_0_1_0_2_1 + 0.00564373897707232*G0_0_1_0_2_2 - 0.0087221420554753*G0_0_1_1_0_0 - 0.0202148468815134*G0_0_1_1_0_1 - 0.000410453743787047*G0_0_1_1_0_2 - 0.0202148468815134*G0_0_1_1_1_0 - 0.0412506012506012*G0_0_1_1_1_1 + 0.00728555395222066*G0_0_1_1_1_2 - 0.000410453743787047*G0_0_1_1_2_0 + 0.00728555395222066*G0_0_1_1_2_1 + 0.00892736892736899*G0_0_1_1_2_2 + 0.00153920153920153*G0_0_1_2_0_0 - 0.000410453743787047*G0_0_1_2_0_1 + 0.00564373897707231*G0_0_1_2_0_2 - 0.000410453743787047*G0_0_1_2_1_0 + 0.00728555395222066*G0_0_1_2_1_1 + 0.00892736892736899*G0_0_1_2_1_2 + 0.00564373897707231*G0_0_1_2_2_0 + 0.00892736892736899*G0_0_1_2_2_1 + 0.008003848003848*G0_0_1_2_2_2 - 0.0523328523328516*G0_1_0_0_0_0 + 0.0087221420554753*G0_1_0_0_0_1 - 0.00153920153920153*G0_1_0_0_0_2 + 0.0087221420554753*G0_1_0_0_1_0 + 0.0202148468815134*G0_1_0_0_1_1 + 0.000410453743787046*G0_1_0_0_1_2 - 0.00153920153920154*G0_1_0_0_2_0 + 0.000410453743787045*G0_1_0_0_2_1 - 0.00564373897707231*G0_1_0_0_2_2 + 0.0087221420554753*G0_1_0_1_0_0 + 0.0202148468815134*G0_1_0_1_0_1 + 0.000410453743787046*G0_1_0_1_0_2 + 0.0202148468815134*G0_1_0_1_1_0 + 0.0412506012506013*G0_1_0_1_1_1 - 0.00728555395222066*G0_1_0_1_1_2 + 0.000410453743787046*G0_1_0_1_2_0 - 0.00728555395222066*G0_1_0_1_2_1 - 0.00892736892736899*G0_1_0_1_2_2 - 0.00153920153920153*G0_1_0_2_0_0 + 0.000410453743787049*G0_1_0_2_0_1 - 0.00564373897707231*G0_1_0_2_0_2 + 0.000410453743787048*G0_1_0_2_1_0 - 0.00728555395222066*G0_1_0_2_1_1 - 0.00892736892736899*G0_1_0_2_1_2 - 0.00564373897707231*G0_1_0_2_2_0 - 0.00892736892736899*G0_1_0_2_2_1 - 0.00800384800384801*G0_1_0_2_2_2;
    A[18] = -A[26] - 0.044508577841911*G0_0_0_0_0_0 - 0.00696916252471807*G0_0_0_0_0_1 - 0.0148361926139703*G0_0_0_0_0_2 - 0.00696916252471807*G0_0_0_0_1_0 - 0.01000481000481*G0_0_0_0_1_1 - 0.00348458126235903*G0_0_0_0_1_2 - 0.0148361926139703*G0_0_0_0_2_0 - 0.00348458126235903*G0_0_0_0_2_1 - 0.0148361926139703*G0_0_0_0_2_2 - 0.00696916252471807*G0_0_0_1_0_0 - 0.01000481000481*G0_0_0_1_0_1 - 0.00348458126235903*G0_0_0_1_0_2 - 0.01000481000481*G0_0_0_1_1_0 - 0.224082090748757*G0_0_0_1_1_1 - 0.01000481000481*G0_0_0_1_1_2 - 0.00348458126235903*G0_0_0_1_2_0 - 0.01000481000481*G0_0_0_1_2_1 - 0.00696916252471806*G0_0_0_1_2_2 - 0.0148361926139703*G0_0_0_2_0_0 - 0.00348458126235903*G0_0_0_2_0_1 - 0.0148361926139703*G0_0_0_2_0_2 - 0.00348458126235903*G0_0_0_2_1_0 - 0.01000481000481*G0_0_0_2_1_1 - 0.00696916252471806*G0_0_0_2_1_2 - 0.0148361926139703*G0_0_0_2_2_0 - 0.00696916252471806*G0_0_0_2_2_1 - 0.0445085778419109*G0_0_0_2_2_2;
    A[68] = -A[65] - 0.0088504088504085*G0_0_1_0_0_0 + 0.00115440115440127*G0_0_1_0_0_1 - 0.0092352092352092*G0_0_1_0_0_2 + 0.00115440115440127*G0_0_1_0_1_0 + 0.00525893859227204*G0_0_1_0_1_1 + 0.01333974667308*G0_0_1_0_1_2 - 0.00923520923520921*G0_0_1_0_2_0 + 0.01333974667308*G0_0_1_0_2_1 + 0.00718294051627376*G0_0_1_0_2_2 + 0.00115440115440127*G0_0_1_1_0_0 + 0.00525893859227204*G0_0_1_1_0_1 + 0.01333974667308*G0_0_1_1_0_2 + 0.00525893859227204*G0_0_1_1_1_0 + 0.0280904280904284*G0_0_1_1_1_1 + 0.0625941959275291*G0_0_1_1_1_2 + 0.01333974667308*G0_0_1_1_2_0 + 0.0625941959275291*G0_0_1_1_2_1 + 0.115953182619849*G0_0_1_1_2_2 - 0.00923520923520921*G0_0_1_2_0_0 + 0.01333974667308*G0_0_1_2_0_1 + 0.00718294051627376*G0_0_1_2_0_2 + 0.01333974667308*G0_0_1_2_1_0 + 0.0625941959275291*G0_0_1_2_1_1 + 0.115953182619849*G0_0_1_2_1_2 + 0.00718294051627376*G0_0_1_2_2_0 + 0.115953182619849*G0_0_1_2_2_1 + 0.469456469456466*G0_0_1_2_2_2 - 0.0134167067500396*G0_1_1_0_0_0 - 0.0249863716530381*G0_1_1_0_0_1 - 0.00900432900432897*G0_1_1_0_0_2 - 0.0249863716530381*G0_1_1_0_1_0 - 0.0615424082090746*G0_1_1_0_1_1 - 0.00715728715728712*G0_1_1_0_1_2 - 0.00900432900432897*G0_1_1_0_2_0 - 0.00715728715728712*G0_1_1_0_2_1 - 0.0148789482122816*G0_1_1_0_2_2 - 0.0249863716530381*G0_1_1_1_0_0 - 0.0615424082090746*G0_1_1_1_0_1 - 0.00715728715728712*G0_1_1_1_0_2 - 0.0615424082090746*G0_1_1_1_1_0 - 0.342421035754369*G0_1_1_1_1_1 - 0.015930735930736*G0_1_1_1_1_2 - 0.00715728715728712*G0_1_1_1_2_0 - 0.015930735930736*G0_1_1_1_2_1 + 0.0118005451338784*G0_1_1_1_2_2 - 0.00900432900432897*G0_1_1_2_0_0 - 0.00715728715728712*G0_1_1_2_0_1 - 0.0148789482122816*G0_1_1_2_0_2 - 0.00715728715728712*G0_1_1_2_1_0 - 0.015930735930736*G0_1_1_2_1_1 + 0.0118005451338784*G0_1_1_2_1_2 - 0.0148789482122816*G0_1_1_2_2_0 + 0.0118005451338784*G0_1_1_2_2_1 + 0.0143658810325472*G0_1_1_2_2_2;
    A[169] = A[68] - 0.00779862113195439*G0_0_0_0_0_0 - 0.00595157928491258*G0_0_0_0_0_1 - 0.0201122334455667*G0_0_0_0_0_2 - 0.00595157928491258*G0_0_0_0_1_0 - 0.00674683341350001*G0_0_0_0_1_1 - 0.00253968253968252*G0_0_0_0_1_2 - 0.0201122334455667*G0_0_0_0_2_0 - 0.00253968253968252*G0_0_0_0_2_1 - 0.072162898829565*G0_0_0_0_2_2 - 0.00595157928491258*G0_0_0_1_0_0 - 0.00674683341350001*G0_0_0_1_0_1 - 0.00253968253968252*G0_0_0_1_0_2 - 0.00674683341350001*G0_0_0_1_1_0 + 0.0583100849767511*G0_0_0_1_1_1 + 0.0161616161616162*G0_0_0_1_1_2 - 0.00253968253968252*G0_0_0_1_2_0 + 0.0161616161616162*G0_0_0_1_2_1 + 0.0100817700817702*G0_0_0_1_2_2 - 0.0201122334455667*G0_0_0_2_0_0 - 0.00253968253968252*G0_0_0_2_0_1 - 0.072162898829565*G0_0_0_2_0_2 - 0.00253968253968252*G0_0_0_2_1_0 + 0.0161616161616162*G0_0_0_2_1_1 + 0.0100817700817702*G0_0_0_2_1_2 - 0.072162898829565*G0_0_0_2_2_0 + 0.0100817700817702*G0_0_0_2_2_1 - 0.628712522045849*G0_0_0_2_2_2 - 0.0113131313131313*G0_0_1_0_0_1 + 0.0113131313131313*G0_0_1_0_0_2 - 0.0113131313131313*G0_0_1_0_1_0 - 0.00731120731120726*G0_0_1_0_1_1 + 0.0113131313131313*G0_0_1_0_2_0 + 0.00731120731120741*G0_0_1_0_2_2 - 0.0113131313131313*G0_0_1_1_0_0 - 0.00731120731120726*G0_0_1_1_0_1 - 0.00731120731120726*G0_0_1_1_1_0 + 0.31022607022607*G0_0_1_1_1_1 + 0.000718294051627498*G0_0_1_1_1_2 + 0.000718294051627507*G0_0_1_1_2_1 - 0.000718294051627244*G0_0_1_1_2_2 + 0.0113131313131313*G0_0_1_2_0_0 + 0.00731120731120741*G0_0_1_2_0_2 + 0.000718294051627505*G0_0_1_2_1_1 - 0.000718294051627247*G0_0_1_2_1_2 + 0.00731120731120741*G0_0_1_2_2_0 - 0.000718294051627242*G0_0_1_2_2_1 - 0.310226070226067*G0_0_1_2_2_2 + 0.001667468334135*G0_1_0_0_0_1 - 0.00166746833413499*G0_1_0_0_0_2 + 0.001667468334135*G0_1_0_0_1_0 + 0.0118775052108385*G0_1_0_0_1_1 - 0.00166746833413499*G0_1_0_0_2_0 - 0.0118775052108385*G0_1_0_0_2_2 + 0.001667468334135*G0_1_0_1_0_0 + 0.0118775052108385*G0_1_0_1_0_1 + 0.0118775052108385*G0_1_0_1_1_0 + 0.127291967291966*G0_1_0_1_1_1 + 0.0109539842873176*G0_1_0_1_1_2 + 0.0109539842873176*G0_1_0_1_2_1 - 0.0109539842873174*G0_1_0_1_2_2 - 0.00166746833413499*G0_1_0_2_0_0 - 0.0118775052108385*G0_1_0_2_0_2 + 0.0109539842873176*G0_1_0_2_1_1 - 0.0109539842873174*G0_1_0_2_1_2 - 0.0118775052108385*G0_1_0_2_2_0 - 0.0109539842873174*G0_1_0_2_2_1 - 0.127291967291966*G0_1_0_2_2_2 + 0.00779862113195408*G0_1_1_0_0_0 + 0.0201122334455666*G0_1_1_0_0_1 + 0.00595157928491261*G0_1_1_0_0_2 + 0.0201122334455666*G0_1_1_0_1_0 + 0.0721628988295652*G0_1_1_0_1_1 + 0.00253968253968254*G0_1_1_0_1_2 + 0.00595157928491261*G0_1_1_0_2_0 + 0.00253968253968254*G0_1_1_0_2_1 + 0.00674683341350015*G0_1_1_0_2_2 + 0.0201122334455666*G0_1_1_1_0_0 + 0.0721628988295652*G0_1_1_1_0_1 + 0.00253968253968254*G0_1_1_1_0_2 + 0.0721628988295652*G0_1_1_1_1_0 + 0.628712522045854*G0_1_1_1_1_1 - 0.0100817700817699*G0_1_1_1_1_2 + 0.00253968253968254*G0_1_1_1_2_0 - 0.0100817700817699*G0_1_1_1_2_1 - 0.016161616161616*G0_1_1_1_2_2 + 0.00595157928491261*G0_1_1_2_0_0 + 0.00253968253968254*G0_1_1_2_0_1 + 0.00674683341350015*G0_1_1_2_0_2 + 0.00253968253968254*G0_1_1_2_1_0 - 0.0100817700817699*G0_1_1_2_1_1 - 0.016161616161616*G0_1_1_2_1_2 + 0.00674683341350015*G0_1_1_2_2_0 - 0.016161616161616*G0_1_1_2_2_1 - 0.0583100849767504*G0_1_1_2_2_2;
    A[71] = A[169] + 0.00892736892736876*G0_0_1_0_0_0 + 0.0138784672118005*G0_0_1_0_0_1 + 0.000897867564534235*G0_0_1_0_0_2 + 0.0138784672118005*G0_0_1_0_1_0 + 0.0200096200096198*G0_0_1_0_1_1 + 0.000897867564534235*G0_0_1_0_2_0 + 0.000820907487574149*G0_0_1_0_2_2 + 0.0138784672118005*G0_0_1_1_0_0 + 0.0200096200096198*G0_0_1_1_0_1 + 0.0200096200096198*G0_0_1_1_1_0 - 0.174699374699376*G0_0_1_1_1_1 + 0.0135962802629468*G0_0_1_1_1_2 + 0.0135962802629468*G0_0_1_1_2_1 + 0.00336059002725664*G0_0_1_1_2_2 + 0.000897867564534235*G0_0_1_2_0_0 + 0.000820907487574149*G0_0_1_2_0_2 + 0.0135962802629468*G0_0_1_2_1_1 + 0.00336059002725664*G0_0_1_2_1_2 + 0.000820907487574149*G0_0_1_2_2_0 + 0.00336059002725664*G0_0_1_2_2_1 + 0.00823472823472806*G0_0_1_2_2_2 - 0.00892736892736876*G0_1_0_0_0_0 - 0.0138784672118005*G0_1_0_0_0_1 - 0.000897867564534235*G0_1_0_0_0_2 - 0.0138784672118005*G0_1_0_0_1_0 - 0.0200096200096198*G0_1_0_0_1_1 - 0.000897867564534235*G0_1_0_0_2_0 - 0.000820907487574149*G0_1_0_0_2_2 - 0.0138784672118005*G0_1_0_1_0_0 - 0.0200096200096198*G0_1_0_1_0_1 - 0.0200096200096198*G0_1_0_1_1_0 + 0.174699374699376*G0_1_0_1_1_1 - 0.0135962802629468*G0_1_0_1_1_2 - 0.0135962802629468*G0_1_0_1_2_1 - 0.00336059002725664*G0_1_0_1_2_2 - 0.000897867564534235*G0_1_0_2_0_0 - 0.000820907487574149*G0_1_0_2_0_2 - 0.0135962802629468*G0_1_0_2_1_1 - 0.00336059002725664*G0_1_0_2_1_2 - 0.000820907487574149*G0_1_0_2_2_0 - 0.00336059002725664*G0_1_0_2_2_1 - 0.00823472823472806*G0_1_0_2_2_2;
    A[38] = -A[35] - 0.044508577841911*G0_1_1_0_0_0 - 0.0148361926139703*G0_1_1_0_0_1 - 0.00696916252471806*G0_1_1_0_0_2 - 0.0148361926139703*G0_1_1_0_1_0 - 0.0148361926139703*G0_1_1_0_1_1 - 0.00348458126235903*G0_1_1_0_1_2 - 0.00696916252471805*G0_1_1_0_2_0 - 0.00348458126235903*G0_1_1_0_2_1 - 0.01000481000481*G0_1_1_0_2_2 - 0.0148361926139703*G0_1_1_1_0_0 - 0.0148361926139703*G0_1_1_1_0_1 - 0.00348458126235903*G0_1_1_1_0_2 - 0.0148361926139703*G0_1_1_1_1_0 - 0.0445085778419112*G0_1_1_1_1_1 - 0.00696916252471806*G0_1_1_1_1_2 - 0.00348458126235903*G0_1_1_1_2_0 - 0.00696916252471806*G0_1_1_1_2_1 - 0.01000481000481*G0_1_1_1_2_2 - 0.00696916252471805*G0_1_1_2_0_0 - 0.00348458126235903*G0_1_1_2_0_1 - 0.01000481000481*G0_1_1_2_0_2 - 0.00348458126235903*G0_1_1_2_1_0 - 0.00696916252471806*G0_1_1_2_1_1 - 0.01000481000481*G0_1_1_2_1_2 - 0.01000481000481*G0_1_1_2_2_0 - 0.01000481000481*G0_1_1_2_2_1 - 0.224082090748756*G0_1_1_2_2_2;
    A[116] = -A[108] - 0.0181882315215646*G0_0_0_0_0_0 + 0.001000481000481*G0_0_0_0_0_1 - 0.0347346480679812*G0_0_0_0_0_2 + 0.001000481000481*G0_0_0_0_1_0 + 0.00646464646464644*G0_0_0_0_1_1 + 0.00325797659130993*G0_0_0_0_1_2 - 0.0347346480679812*G0_0_0_0_2_0 + 0.00325797659130993*G0_0_0_0_2_1 - 0.048664421997755*G0_0_0_0_2_2 + 0.001000481000481*G0_0_0_1_0_0 + 0.00646464646464644*G0_0_0_1_0_1 + 0.00325797659130993*G0_0_0_1_0_2 + 0.00646464646464644*G0_0_0_1_1_0 + 0.0205226871893543*G0_0_0_1_1_1 + 0.00687510020843361*G0_0_0_1_1_2 + 0.00325797659130993*G0_0_0_1_2_0 + 0.00687510020843361*G0_0_0_1_2_1 - 0.00110309443642769*G0_0_0_1_2_2 - 0.0347346480679812*G0_0_0_2_0_0 + 0.00325797659130993*G0_0_0_2_0_1 - 0.048664421997755*G0_0_0_2_0_2 + 0.00325797659130993*G0_0_0_2_1_0 + 0.00687510020843361*G0_0_0_2_1_1 - 0.00110309443642769*G0_0_0_2_1_2 - 0.048664421997755*G0_0_0_2_2_0 - 0.00110309443642769*G0_0_0_2_2_1 - 0.0315023248356582*G0_0_0_2_2_2 + 0.0133140933140923*G0_1_0_0_0_0 + 0.00210357543690866*G0_1_0_0_0_1 + 0.0139297739297737*G0_1_0_0_0_2 + 0.00210357543690866*G0_1_0_0_1_0 - 0.000410453743787108*G0_1_0_0_1_1 + 0.0139297739297737*G0_1_0_0_2_0 - 0.0139297739297739*G0_1_0_0_2_2 + 0.00210357543690866*G0_1_0_1_0_0 - 0.000410453743787108*G0_1_0_1_0_1 - 0.000410453743787109*G0_1_0_1_1_0 + 0.000410453743787123*G0_1_0_1_1_2 + 0.000410453743787124*G0_1_0_1_2_1 - 0.0021035754369087*G0_1_0_1_2_2 + 0.0139297739297737*G0_1_0_2_0_0 - 0.0139297739297739*G0_1_0_2_0_2 + 0.000410453743787124*G0_1_0_2_1_1 - 0.0021035754369087*G0_1_0_2_1_2 - 0.0139297739297739*G0_1_0_2_2_0 - 0.0021035754369087*G0_1_0_2_2_1 - 0.0133140933140933*G0_1_0_2_2_2;
    A[139] = A[116] + 0.0179316979316979*G0_0_0_0_0_0 + 0.00397627064293724*G0_0_0_0_0_1 + 0.0164694564694564*G0_0_0_0_0_2 + 0.00397627064293724*G0_0_0_0_1_0 - 0.00397627064293731*G0_0_0_0_1_1 + 0.0164694564694564*G0_0_0_0_2_0 + 0.0185217251883917*G0_0_0_0_2_2 + 0.00397627064293724*G0_0_0_1_0_0 - 0.00397627064293731*G0_0_0_1_0_1 - 0.00397627064293731*G0_0_0_1_1_0 - 0.0179316979316982*G0_0_0_1_1_1 - 0.0164694564694563*G0_0_0_1_1_2 - 0.0164694564694563*G0_0_0_1_2_1 - 0.0185217251883917*G0_0_0_1_2_2 + 0.0164694564694564*G0_0_0_2_0_0 + 0.0185217251883917*G0_0_0_2_0_2 - 0.0164694564694563*G0_0_0_2_1_1 - 0.0185217251883917*G0_0_0_2_1_2 + 0.0185217251883917*G0_0_0_2_2_0 - 0.0185217251883917*G0_0_0_2_2_1 + 0.0119288119288124*G0_0_1_0_0_0 + 0.00413019079685741*G0_0_1_0_0_1 - 0.00138528138528134*G0_0_1_0_0_2 + 0.00413019079685741*G0_0_1_0_1_0 - 0.00218053551386893*G0_0_1_0_1_1 + 0.00143658810325478*G0_0_1_0_1_2 - 0.00138528138528134*G0_0_1_0_2_0 + 0.00143658810325478*G0_0_1_0_2_1 - 0.00400192400192396*G0_0_1_0_2_2 + 0.00413019079685741*G0_0_1_1_0_0 - 0.00218053551386893*G0_0_1_1_0_1 + 0.00143658810325478*G0_0_1_1_0_2 - 0.00218053551386893*G0_0_1_1_1_0 - 0.00723424723424769*G0_0_1_1_1_1 - 0.0278338945005609*G0_0_1_1_1_2 + 0.00143658810325478*G0_0_1_1_2_0 - 0.0278338945005609*G0_0_1_1_2_1 - 0.0187526054192719*G0_0_1_1_2_2 - 0.00138528138528134*G0_0_1_2_0_0 + 0.00143658810325478*G0_0_1_2_0_1 - 0.00400192400192396*G0_0_1_2_0_2 + 0.00143658810325478*G0_0_1_2_1_0 - 0.0278338945005609*G0_0_1_2_1_1 - 0.0187526054192719*G0_0_1_2_1_2 - 0.00400192400192396*G0_0_1_2_2_0 - 0.0187526054192719*G0_0_1_2_2_1 - 0.0156228956228956*G0_0_1_2_2_2 + 0.0106974506974509*G0_1_0_0_0_0 + 0.00179573512906841*G0_1_0_0_0_1 - 0.0113644380311046*G0_1_0_0_0_2 + 0.00179573512906841*G0_1_0_0_1_0 + 0.000153920153920128*G0_1_0_0_1_1 + 0.00143658810325476*G0_1_0_0_1_2 - 0.0113644380311046*G0_1_0_0_2_0 + 0.00143658810325476*G0_1_0_0_2_1 - 0.000230880230880238*G0_1_0_0_2_2 + 0.00179573512906841*G0_1_0_1_0_0 + 0.000153920153920128*G0_1_0_1_0_1 + 0.00143658810325476*G0_1_0_1_0_2 + 0.000153920153920129*G0_1_0_1_1_0 - 0.0060028860028864*G0_1_0_1_1_1 - 0.0178547378547377*G0_1_0_1_1_2 + 0.00143658810325476*G0_1_0_1_2_0 - 0.0178547378547377*G0_1_0_1_2_1 - 0.0225236491903158*G0_1_0_1_2_2 - 0.0113644380311046*G0_1_0_2_0_0 + 0.00143658810325476*G0_1_0_2_0_1 - 0.000230880230880238*G0_1_0_2_0_2 + 0.00143658810325476*G0_1_0_2_1_0 - 0.0178547378547377*G0_1_0_2_1_1 - 0.0225236491903158*G0_1_0_2_1_2 - 0.00023088023088024*G0_1_0_2_2_0 - 0.0225236491903158*G0_1_0_2_2_1 - 0.0156228956228959*G0_1_0_2_2_2 + 0.0031553631553626*G0_1_1_0_0_0 + 0.0038993105659771*G0_1_1_0_0_1 + 0.00423280423280421*G0_1_1_0_0_2 + 0.0038993105659771*G0_1_1_0_1_0 - 0.00194965528298872*G0_1_1_0_1_1 + 0.00143658810325476*G0_1_1_0_1_2 + 0.00423280423280421*G0_1_1_0_2_0 + 0.00143658810325476*G0_1_1_0_2_1 - 0.000590027256693906*G0_1_1_0_2_2 + 0.0038993105659771*G0_1_1_1_0_0 - 0.00194965528298872*G0_1_1_1_0_1 + 0.00143658810325476*G0_1_1_1_0_2 - 0.00194965528298872*G0_1_1_1_1_0 + 0.00153920153920078*G0_1_1_1_1_1 - 0.0334519801186466*G0_1_1_1_1_2 + 0.00143658810325476*G0_1_1_1_2_0 - 0.0334519801186466*G0_1_1_1_2_1 - 0.0221645021645021*G0_1_1_1_2_2 + 0.00423280423280421*G0_1_1_2_0_0 + 0.00143658810325476*G0_1_1_2_0_1 - 0.000590027256693906*G0_1_1_2_0_2 + 0.00143658810325476*G0_1_1_2_1_0 - 0.0334519801186466*G0_1_1_2_1_1 - 0.0221645021645021*G0_1_1_2_1_2 - 0.000590027256693906*G0_1_1_2_2_0 - 0.0221645021645021*G0_1_1_2_2_1 - 0.0156228956228956*G0_1_1_2_2_2;
    A[55] = A[153] + 0.00823472823472834*G0_0_1_0_0_0 + 0.00336059002725669*G0_0_1_0_0_1 + 0.000820907487574192*G0_0_1_0_0_2 + 0.00336059002725669*G0_0_1_0_1_0 + 0.0135962802629468*G0_0_1_0_1_1 + 0.000820907487574192*G0_0_1_0_2_0 + 0.000897867564534264*G0_0_1_0_2_2 + 0.00336059002725669*G0_0_1_1_0_0 + 0.0135962802629468*G0_0_1_1_0_1 + 0.0135962802629468*G0_0_1_1_1_0 - 0.174699374699375*G0_0_1_1_1_1 + 0.0200096200096198*G0_0_1_1_1_2 + 0.0200096200096198*G0_0_1_1_2_1 + 0.0138784672118005*G0_0_1_1_2_2 + 0.000820907487574192*G0_0_1_2_0_0 + 0.000897867564534264*G0_0_1_2_0_2 + 0.0200096200096198*G0_0_1_2_1_1 + 0.0138784672118004*G0_0_1_2_1_2 + 0.000897867564534264*G0_0_1_2_2_0 + 0.0138784672118005*G0_0_1_2_2_1 + 0.00892736892736895*G0_0_1_2_2_2 - 0.00823472823472834*G0_1_0_0_0_0 - 0.00336059002725669*G0_1_0_0_0_1 - 0.000820907487574192*G0_1_0_0_0_2 - 0.00336059002725669*G0_1_0_0_1_0 - 0.0135962802629468*G0_1_0_0_1_1 - 0.000820907487574192*G0_1_0_0_2_0 - 0.000897867564534264*G0_1_0_0_2_2 - 0.00336059002725669*G0_1_0_1_0_0 - 0.0135962802629468*G0_1_0_1_0_1 - 0.0135962802629468*G0_1_0_1_1_0 + 0.174699374699375*G0_1_0_1_1_1 - 0.0200096200096198*G0_1_0_1_1_2 - 0.0200096200096198*G0_1_0_1_2_1 - 0.0138784672118004*G0_1_0_1_2_2 - 0.000820907487574192*G0_1_0_2_0_0 - 0.000897867564534263*G0_1_0_2_0_2 - 0.0200096200096198*G0_1_0_2_1_1 - 0.0138784672118004*G0_1_0_2_1_2 - 0.000897867564534263*G0_1_0_2_2_0 - 0.0138784672118004*G0_1_0_2_2_1 - 0.00892736892736895*G0_1_0_2_2_2;
    A[175] = -A[55] - 0.370511463844796*G0_0_0_0_0_0 - 0.0785249318582649*G0_0_0_0_0_1 - 0.0668013468013464*G0_0_0_0_0_2 - 0.0785249318582649*G0_0_0_0_1_0 - 0.10415263748597*G0_0_0_0_1_1 - 0.0204970338303671*G0_0_0_0_1_2 - 0.0668013468013464*G0_0_0_0_2_0 - 0.0204970338303671*G0_0_0_0_2_1 - 0.0261407728074393*G0_0_0_0_2_2 - 0.0785249318582649*G0_0_0_1_0_0 - 0.10415263748597*G0_0_0_1_0_1 - 0.0204970338303671*G0_0_0_1_0_2 - 0.10415263748597*G0_0_0_1_1_0 - 0.45509058842392*G0_0_0_1_1_1 - 0.0220618887285553*G0_0_0_1_1_2 - 0.0204970338303671*G0_0_0_1_2_0 - 0.0220618887285553*G0_0_0_1_2_1 + 0.000230880230880212*G0_0_0_1_2_2 - 0.0668013468013464*G0_0_0_2_0_0 - 0.0204970338303671*G0_0_0_2_0_1 - 0.0261407728074393*G0_0_0_2_0_2 - 0.0204970338303671*G0_0_0_2_1_0 - 0.0220618887285553*G0_0_0_2_1_1 + 0.000230880230880214*G0_0_0_2_1_2 - 0.0261407728074393*G0_0_0_2_2_0 + 0.000230880230880214*G0_0_0_2_2_1 - 0.00456629789963131*G0_0_0_2_2_2 - 0.028090428090428*G0_0_1_0_0_0 - 0.062594195927529*G0_0_1_0_0_1 - 0.00525893859227187*G0_0_1_0_0_2 - 0.062594195927529*G0_0_1_0_1_0 - 0.115953182619849*G0_0_1_0_1_1 - 0.01333974667308*G0_0_1_0_1_2 - 0.00525893859227188*G0_0_1_0_2_0 - 0.01333974667308*G0_0_1_0_2_1 - 0.00115440115440111*G0_0_1_0_2_2 - 0.062594195927529*G0_0_1_1_0_0 - 0.115953182619849*G0_0_1_1_0_1 - 0.01333974667308*G0_0_1_1_0_2 - 0.115953182619849*G0_0_1_1_1_0 - 0.469456469456468*G0_0_1_1_1_1 - 0.00718294051627383*G0_0_1_1_1_2 - 0.01333974667308*G0_0_1_1_2_0 - 0.00718294051627383*G0_0_1_1_2_1 + 0.00923520923520917*G0_0_1_1_2_2 - 0.00525893859227187*G0_0_1_2_0_0 - 0.01333974667308*G0_0_1_2_0_1 - 0.00115440115440111*G0_0_1_2_0_2 - 0.01333974667308*G0_0_1_2_1_0 - 0.00718294051627384*G0_0_1_2_1_1 + 0.00923520923520917*G0_0_1_2_1_2 - 0.00115440115440111*G0_0_1_2_2_0 + 0.00923520923520917*G0_0_1_2_2_1 + 0.00885040885040889*G0_0_1_2_2_2;
    A[29] = A[27] + 0.0514862914862912*G0_0_0_0_0_0 + 0.000230880230880212*G0_0_0_0_0_1 + 0.0103639570306236*G0_0_0_0_0_2 + 0.000230880230880212*G0_0_0_0_1_0 + 0.000949174282507604*G0_0_0_0_1_2 + 0.0103639570306236*G0_0_0_0_2_0 + 0.000949174282507604*G0_0_0_0_2_1 - 0.00679814013147344*G0_0_0_0_2_2 + 0.000230880230880211*G0_0_0_1_0_0 + 0.000949174282507604*G0_0_0_1_0_2 + 0.000949174282507604*G0_0_0_1_2_0 - 0.00212922879589542*G0_0_0_1_2_2 + 0.0103639570306236*G0_0_0_2_0_0 + 0.000949174282507604*G0_0_0_2_0_1 - 0.00679814013147344*G0_0_0_2_0_2 + 0.000949174282507604*G0_0_0_2_1_0 - 0.00212922879589542*G0_0_0_2_1_2 - 0.00679814013147344*G0_0_0_2_2_0 - 0.00212922879589542*G0_0_0_2_2_1 - 0.0621837421837417*G0_0_0_2_2_2 - 0.0106974506974505*G0_0_1_0_0_0 - 0.00189834856501521*G0_0_1_0_0_1 + 0.00356581689915023*G0_0_1_0_0_2 - 0.00189834856501521*G0_0_1_0_1_0 + 0.00189834856501521*G0_0_1_0_1_2 + 0.00356581689915023*G0_0_1_0_2_0 + 0.00189834856501521*G0_0_1_0_2_1 + 0.00356581689915022*G0_0_1_0_2_2 - 0.00189834856501521*G0_0_1_1_0_0 + 0.00189834856501522*G0_0_1_1_0_2 + 0.00189834856501522*G0_0_1_1_2_0 - 0.00189834856501519*G0_0_1_1_2_2 + 0.00356581689915023*G0_0_1_2_0_0 + 0.00189834856501521*G0_0_1_2_0_1 + 0.00356581689915022*G0_0_1_2_0_2 + 0.00189834856501521*G0_0_1_2_1_0 - 0.00189834856501519*G0_0_1_2_1_2 + 0.00356581689915022*G0_0_1_2_2_0 - 0.0018983485650152*G0_0_1_2_2_1 - 0.0106974506974506*G0_0_1_2_2_2;
    A[43] = A[42] - 0.0106974506974505*G0_1_0_0_0_0 + 0.00356581689915021*G0_1_0_0_0_1 - 0.00189834856501519*G0_1_0_0_0_2 + 0.00356581689915021*G0_1_0_0_1_0 + 0.0035658168991502*G0_1_0_0_1_1 + 0.0018983485650152*G0_1_0_0_1_2 - 0.00189834856501519*G0_1_0_0_2_0 + 0.0018983485650152*G0_1_0_0_2_1 + 0.00356581689915021*G0_1_0_1_0_0 + 0.0035658168991502*G0_1_0_1_0_1 + 0.0018983485650152*G0_1_0_1_0_2 + 0.0035658168991502*G0_1_0_1_1_0 - 0.0106974506974506*G0_1_0_1_1_1 - 0.00189834856501529*G0_1_0_1_1_2 + 0.0018983485650152*G0_1_0_1_2_0 - 0.00189834856501529*G0_1_0_1_2_1 - 0.00189834856501519*G0_1_0_2_0_0 + 0.0018983485650152*G0_1_0_2_0_1 + 0.0018983485650152*G0_1_0_2_1_0 - 0.00189834856501529*G0_1_0_2_1_1 + 0.0514862914862912*G0_1_1_0_0_0 + 0.0103639570306236*G0_1_1_0_0_1 + 0.000230880230880213*G0_1_1_0_0_2 + 0.0103639570306236*G0_1_1_0_1_0 - 0.00679814013147348*G0_1_1_0_1_1 + 0.000949174282507595*G0_1_1_0_1_2 + 0.000230880230880212*G0_1_1_0_2_0 + 0.000949174282507595*G0_1_1_0_2_1 + 0.0103639570306236*G0_1_1_1_0_0 - 0.00679814013147348*G0_1_1_1_0_1 + 0.000949174282507595*G0_1_1_1_0_2 - 0.00679814013147348*G0_1_1_1_1_0 - 0.0621837421837421*G0_1_1_1_1_1 - 0.00212922879589553*G0_1_1_1_1_2 + 0.000949174282507595*G0_1_1_1_2_0 - 0.00212922879589553*G0_1_1_1_2_1 + 0.000230880230880212*G0_1_1_2_0_0 + 0.000949174282507595*G0_1_1_2_0_1 + 0.000949174282507595*G0_1_1_2_1_0 - 0.00212922879589553*G0_1_1_2_1_1;
    A[183] = -A[191] + 0.30866121532788*G0_0_0_0_0_0 - 0.008003848003848*G0_0_0_0_0_1 + 0.114721821388487*G0_0_0_0_0_2 - 0.008003848003848*G0_0_0_0_1_0 - 0.0391983325316657*G0_0_0_0_1_1 + 0.0043097643097643*G0_0_0_0_1_2 + 0.114721821388487*G0_0_0_0_2_0 + 0.0043097643097643*G0_0_0_0_2_1 + 0.0728555395222058*G0_0_0_0_2_2 - 0.008003848003848*G0_0_0_1_0_0 - 0.0391983325316657*G0_0_0_1_0_1 + 0.0043097643097643*G0_0_0_1_0_2 - 0.0391983325316657*G0_0_0_1_1_0 - 0.0348885682219018*G0_0_0_1_1_1 + 0.0289369889369888*G0_0_0_1_1_2 + 0.0043097643097643*G0_0_0_1_2_0 + 0.0289369889369888*G0_0_0_1_2_1 + 0.0322206188872854*G0_0_0_1_2_2 + 0.114721821388487*G0_0_0_2_0_0 + 0.0043097643097643*G0_0_0_2_0_1 + 0.0728555395222058*G0_0_0_2_0_2 + 0.0043097643097643*G0_0_0_2_1_0 + 0.0289369889369888*G0_0_0_2_1_1 + 0.0322206188872855*G0_0_0_2_1_2 + 0.0728555395222058*G0_0_0_2_2_0 + 0.0322206188872854*G0_0_0_2_2_1 + 0.0439185505852173*G0_0_0_2_2_2 - 0.0652621452621445*G0_1_0_0_0_0 - 0.0250376783710115*G0_1_0_0_0_1 + 0.00451499118165792*G0_1_0_0_0_2 - 0.0250376783710115*G0_1_0_0_1_0 - 0.0205226871893537*G0_1_0_0_1_1 + 0.000410453743787109*G0_1_0_0_1_2 + 0.00451499118165792*G0_1_0_0_2_0 + 0.000410453743787108*G0_1_0_0_2_1 + 0.0131345198011865*G0_1_0_0_2_2 - 0.0250376783710115*G0_1_0_1_0_0 - 0.0205226871893537*G0_1_0_1_0_1 + 0.000410453743787108*G0_1_0_1_0_2 - 0.0205226871893537*G0_1_0_1_1_0 + 0.0205226871893538*G0_1_0_1_1_2 + 0.000410453743787108*G0_1_0_1_2_0 + 0.0205226871893538*G0_1_0_1_2_1 + 0.0242167708834375*G0_1_0_1_2_2 + 0.00451499118165792*G0_1_0_2_0_0 + 0.000410453743787106*G0_1_0_2_0_1 + 0.0131345198011865*G0_1_0_2_0_2 + 0.000410453743787107*G0_1_0_2_1_0 + 0.0205226871893538*G0_1_0_2_1_1 + 0.0242167708834375*G0_1_0_2_1_2 + 0.0131345198011865*G0_1_0_2_2_0 + 0.0242167708834375*G0_1_0_2_2_1 + 0.0123136123136123*G0_1_0_2_2_2;
    A[57] = A[183] - 0.024011544011544*G0_0_1_0_0_0 - 0.00482283148949816*G0_0_1_0_0_1 - 0.00277056277056278*G0_0_1_0_0_2 - 0.00482283148949816*G0_0_1_0_1_0 - 0.0118005451338784*G0_0_1_0_1_1 + 0.000820907487574146*G0_0_1_0_1_2 - 0.00277056277056278*G0_0_1_0_2_0 + 0.000820907487574145*G0_0_1_0_2_1 + 0.00420715087381752*G0_0_1_0_2_2 - 0.00482283148949816*G0_0_1_1_0_0 - 0.0118005451338784*G0_0_1_1_0_1 + 0.000820907487574146*G0_0_1_1_0_2 - 0.0118005451338784*G0_0_1_1_1_0 - 0.0523328523328524*G0_0_1_1_1_1 + 0.0189834856501523*G0_0_1_1_1_2 + 0.000820907487574146*G0_0_1_1_2_0 + 0.0189834856501523*G0_0_1_1_2_1 + 0.0185730319063652*G0_0_1_1_2_2 - 0.00277056277056278*G0_0_1_2_0_0 + 0.000820907487574146*G0_0_1_2_0_1 + 0.00420715087381751*G0_0_1_2_0_2 + 0.000820907487574148*G0_0_1_2_1_0 + 0.0189834856501523*G0_0_1_2_1_1 + 0.0185730319063652*G0_0_1_2_1_2 + 0.00420715087381751*G0_0_1_2_2_0 + 0.0185730319063652*G0_0_1_2_2_1 + 0.00430976430976429*G0_0_1_2_2_2 + 0.024011544011544*G0_1_0_0_0_0 + 0.00482283148949816*G0_1_0_0_0_1 + 0.00277056277056278*G0_1_0_0_0_2 + 0.00482283148949816*G0_1_0_0_1_0 + 0.0118005451338784*G0_1_0_0_1_1 - 0.000820907487574147*G0_1_0_0_1_2 + 0.00277056277056278*G0_1_0_0_2_0 - 0.000820907487574147*G0_1_0_0_2_1 - 0.00420715087381752*G0_1_0_0_2_2 + 0.00482283148949816*G0_1_0_1_0_0 + 0.0118005451338784*G0_1_0_1_0_1 - 0.000820907487574147*G0_1_0_1_0_2 + 0.0118005451338784*G0_1_0_1_1_0 + 0.0523328523328524*G0_1_0_1_1_1 - 0.0189834856501522*G0_1_0_1_1_2 - 0.000820907487574148*G0_1_0_1_2_0 - 0.0189834856501523*G0_1_0_1_2_1 - 0.0185730319063652*G0_1_0_1_2_2 + 0.00277056277056278*G0_1_0_2_0_0 - 0.000820907487574146*G0_1_0_2_0_1 - 0.00420715087381751*G0_1_0_2_0_2 - 0.000820907487574147*G0_1_0_2_1_0 - 0.0189834856501522*G0_1_0_2_1_1 - 0.0185730319063652*G0_1_0_2_1_2 - 0.00420715087381751*G0_1_0_2_2_0 - 0.0185730319063652*G0_1_0_2_2_1 - 0.00430976430976427*G0_1_0_2_2_2;
    A[213] = -A[183] + 0.105281385281385*G0_0_0_0_0_0 + 0.00348885682219015*G0_0_0_0_0_1 + 0.0808593875260537*G0_0_0_0_0_2 + 0.00348885682219015*G0_0_0_0_1_0 + 0.000615680615680611*G0_0_0_0_1_1 + 0.00944043610710275*G0_0_0_0_1_2 + 0.0808593875260537*G0_0_0_0_2_0 + 0.00944043610710275*G0_0_0_0_2_1 + 0.112874779541446*G0_0_0_0_2_2 + 0.00348885682219015*G0_0_0_1_0_0 + 0.00061568061568061*G0_0_0_1_0_1 + 0.00944043610710275*G0_0_0_1_0_2 + 0.000615680615680608*G0_0_0_1_1_0 + 0.212409812409811*G0_0_0_1_1_1 + 0.0578739778739775*G0_0_0_1_1_2 + 0.00944043610710275*G0_0_0_1_2_0 + 0.0578739778739775*G0_0_0_1_2_1 + 0.054590347923681*G0_0_0_1_2_2 + 0.0808593875260537*G0_0_0_2_0_0 + 0.00944043610710275*G0_0_0_2_0_1 + 0.112874779541446*G0_0_0_2_0_2 + 0.00944043610710275*G0_0_0_2_1_0 + 0.0578739778739776*G0_0_0_2_1_1 + 0.054590347923681*G0_0_0_2_1_2 + 0.112874779541446*G0_0_0_2_2_0 + 0.054590347923681*G0_0_0_2_2_1 + 0.320153920153918*G0_0_0_2_2_2 + 0.0244219977553311*G0_0_1_0_0_0 + 0.00451499118165787*G0_0_1_0_0_1 + 0.0116979316979317*G0_0_1_0_0_2 + 0.00451499118165787*G0_0_1_0_1_0 + 0.01333974667308*G0_0_1_0_1_1 + 0.0047202180535514*G0_0_1_0_1_2 + 0.0116979316979317*G0_0_1_0_2_0 + 0.0047202180535514*G0_0_1_0_2_1 + 0.010671797338464*G0_0_1_0_2_2 + 0.00451499118165787*G0_0_1_1_0_0 + 0.01333974667308*G0_0_1_1_0_1 + 0.0047202180535514*G0_0_1_1_0_2 + 0.01333974667308*G0_0_1_1_1_0 + 0.299631232964566*G0_0_1_1_1_1 + 0.0482283148949814*G0_0_1_1_1_2 + 0.0047202180535514*G0_0_1_1_2_0 + 0.0482283148949814*G0_0_1_1_2_1 + 0.0147763347763348*G0_0_1_1_2_2 + 0.0116979316979317*G0_0_1_2_0_0 + 0.0047202180535514*G0_0_1_2_0_1 + 0.010671797338464*G0_0_1_2_0_2 + 0.0047202180535514*G0_0_1_2_1_0 + 0.0482283148949814*G0_0_1_2_1_1 + 0.0147763347763348*G0_0_1_2_1_2 + 0.010671797338464*G0_0_1_2_2_0 + 0.0147763347763348*G0_0_1_2_2_1 + 0.0151867885201219*G0_0_1_2_2_2 - 0.00759339426006088*G0_1_0_0_0_0 - 0.00595157928491258*G0_1_0_0_0_1 - 0.00595157928491258*G0_1_0_0_1_0 + 0.00595157928491262*G0_1_0_0_1_2 + 0.00595157928491262*G0_1_0_0_2_1 + 0.00759339426006095*G0_1_0_0_2_2 - 0.00595157928491258*G0_1_0_1_0_0 + 0.00595157928491262*G0_1_0_1_0_2 + 0.194965528298861*G0_1_0_1_1_1 + 0.075933942600609*G0_1_0_1_1_2 + 0.00595157928491262*G0_1_0_1_2_0 + 0.075933942600609*G0_1_0_1_2_1 + 0.0535642135642134*G0_1_0_1_2_2 + 0.00595157928491262*G0_1_0_2_0_1 + 0.00759339426006094*G0_1_0_2_0_2 + 0.00595157928491262*G0_1_0_2_1_0 + 0.075933942600609*G0_1_0_2_1_1 + 0.0535642135642134*G0_1_0_2_1_2 + 0.00759339426006095*G0_1_0_2_2_0 + 0.0535642135642134*G0_1_0_2_2_1 + 0.0607471540804874*G0_1_0_2_2_2 + 0.00923520923520923*G0_1_1_0_0_0 - 0.0102613435946769*G0_1_1_0_0_1 + 0.00102613435946769*G0_1_1_0_0_2 - 0.0102613435946769*G0_1_1_0_1_0 - 0.0348885682219013*G0_1_1_0_1_1 + 0.00102613435946769*G0_1_1_0_2_0 - 0.00102613435946767*G0_1_1_0_2_2 - 0.0102613435946769*G0_1_1_1_0_0 - 0.0348885682219013*G0_1_1_1_0_1 - 0.0348885682219013*G0_1_1_1_1_0 + 0.0348885682219015*G0_1_1_1_1_2 + 0.0348885682219015*G0_1_1_1_2_1 + 0.0102613435946769*G0_1_1_1_2_2 + 0.00102613435946769*G0_1_1_2_0_0 - 0.00102613435946767*G0_1_1_2_0_2 + 0.0348885682219015*G0_1_1_2_1_1 + 0.0102613435946769*G0_1_1_2_1_2 - 0.00102613435946767*G0_1_1_2_2_0 + 0.0102613435946769*G0_1_1_2_2_1 - 0.00923520923520895*G0_1_1_2_2_2;
    A[119] = A[205] - 0.385569985569984*G0_0_0_0_0_0 - 0.0551034151034148*G0_0_0_0_0_1 - 0.209485329485329*G0_0_0_0_0_2 - 0.0551034151034148*G0_0_0_0_1_0 - 0.00631072631072628*G0_0_0_0_1_1 - 0.0300144300144299*G0_0_0_0_1_2 - 0.209485329485329*G0_0_0_0_2_0 - 0.0300144300144299*G0_0_0_0_2_1 - 0.254891774891774*G0_0_0_0_2_2 - 0.0551034151034148*G0_0_0_1_0_0 - 0.00631072631072628*G0_0_0_1_0_1 - 0.0300144300144299*G0_0_0_1_0_2 - 0.00631072631072628*G0_0_0_1_1_0 + 0.369408369408367*G0_0_0_1_1_1 + 0.0432515632515628*G0_0_0_1_1_2 - 0.0300144300144299*G0_0_0_1_2_0 + 0.0432515632515628*G0_0_0_1_2_1 - 0.108051948051948*G0_0_0_1_2_2 - 0.209485329485329*G0_0_0_2_0_0 - 0.0300144300144299*G0_0_0_2_0_1 - 0.254891774891774*G0_0_0_2_0_2 - 0.0300144300144299*G0_0_0_2_1_0 + 0.0432515632515628*G0_0_0_2_1_1 - 0.108051948051948*G0_0_0_2_1_2 - 0.254891774891774*G0_0_0_2_2_0 - 0.108051948051948*G0_0_0_2_2_1 - 0.774834054834053*G0_0_0_2_2_2 + 0.0210101010101009*G0_0_1_0_0_1 - 0.0210101010101008*G0_0_1_0_0_2 + 0.0210101010101009*G0_0_1_0_1_0 + 0.0467147667147665*G0_0_1_0_1_1 - 0.0210101010101008*G0_0_1_0_2_0 - 0.0467147667147664*G0_0_1_0_2_2 + 0.0210101010101009*G0_0_1_1_0_0 + 0.0467147667147665*G0_0_1_1_0_1 + 0.0467147667147665*G0_0_1_1_1_0 + 0.500086580086577*G0_0_1_1_1_1 + 0.0796536796536791*G0_0_1_1_1_2 + 0.0796536796536791*G0_0_1_1_2_1 - 0.0796536796536794*G0_0_1_1_2_2 - 0.0210101010101008*G0_0_1_2_0_0 - 0.0467147667147664*G0_0_1_2_0_2 + 0.0796536796536791*G0_0_1_2_1_1 - 0.0796536796536794*G0_0_1_2_1_2 - 0.0467147667147664*G0_0_1_2_2_0 - 0.0796536796536794*G0_0_1_2_2_1 - 0.500086580086577*G0_0_1_2_2_2 + 0.0431746031746032*G0_1_0_0_0_1 - 0.0431746031746031*G0_1_0_0_0_2 + 0.0431746031746032*G0_1_0_0_1_0 + 0.129523809523809*G0_1_0_0_1_1 - 0.0431746031746031*G0_1_0_0_2_0 - 0.129523809523809*G0_1_0_0_2_2 + 0.0431746031746032*G0_1_0_1_0_0 + 0.129523809523809*G0_1_0_1_0_1 + 0.129523809523809*G0_1_0_1_1_0 + 0.639999999999997*G0_1_0_1_1_1 + 0.0736507936507932*G0_1_0_1_1_2 + 0.0736507936507932*G0_1_0_1_2_1 - 0.0736507936507935*G0_1_0_1_2_2 - 0.0431746031746031*G0_1_0_2_0_0 - 0.129523809523809*G0_1_0_2_0_2 + 0.0736507936507932*G0_1_0_2_1_1 - 0.0736507936507935*G0_1_0_2_1_2 - 0.129523809523809*G0_1_0_2_2_0 - 0.0736507936507935*G0_1_0_2_2_1 - 0.639999999999998*G0_1_0_2_2_2 + 0.385569985569984*G0_1_1_0_0_0 + 0.209485329485329*G0_1_1_0_0_1 + 0.0551034151034149*G0_1_1_0_0_2 + 0.209485329485329*G0_1_1_0_1_0 + 0.254891774891774*G0_1_1_0_1_1 + 0.0300144300144299*G0_1_1_0_1_2 + 0.0551034151034149*G0_1_1_0_2_0 + 0.0300144300144299*G0_1_1_0_2_1 + 0.00631072631072625*G0_1_1_0_2_2 + 0.209485329485329*G0_1_1_1_0_0 + 0.254891774891774*G0_1_1_1_0_1 + 0.0300144300144299*G0_1_1_1_0_2 + 0.254891774891774*G0_1_1_1_1_0 + 0.774834054834051*G0_1_1_1_1_1 + 0.108051948051947*G0_1_1_1_1_2 + 0.0300144300144299*G0_1_1_1_2_0 + 0.108051948051947*G0_1_1_1_2_1 - 0.043251563251563*G0_1_1_1_2_2 + 0.0551034151034149*G0_1_1_2_0_0 + 0.0300144300144299*G0_1_1_2_0_1 + 0.00631072631072625*G0_1_1_2_0_2 + 0.0300144300144299*G0_1_1_2_1_0 + 0.108051948051947*G0_1_1_2_1_1 - 0.0432515632515631*G0_1_1_2_1_2 + 0.00631072631072625*G0_1_1_2_2_0 - 0.0432515632515631*G0_1_1_2_2_1 - 0.369408369408367*G0_1_1_2_2_2;
    A[197] = A[182] - 0.0106974506974505*G0_0_1_0_0_0 + 0.00356581689915021*G0_0_1_0_0_1 - 0.00189834856501519*G0_0_1_0_0_2 + 0.00356581689915021*G0_0_1_0_1_0 + 0.0035658168991502*G0_0_1_0_1_1 + 0.0018983485650152*G0_0_1_0_1_2 - 0.00189834856501519*G0_0_1_0_2_0 + 0.0018983485650152*G0_0_1_0_2_1 + 0.00356581689915021*G0_0_1_1_0_0 + 0.0035658168991502*G0_0_1_1_0_1 + 0.0018983485650152*G0_0_1_1_0_2 + 0.0035658168991502*G0_0_1_1_1_0 - 0.0106974506974506*G0_0_1_1_1_1 - 0.0018983485650153*G0_0_1_1_1_2 + 0.0018983485650152*G0_0_1_1_2_0 - 0.0018983485650153*G0_0_1_1_2_1 - 0.00189834856501519*G0_0_1_2_0_0 + 0.0018983485650152*G0_0_1_2_0_1 + 0.0018983485650152*G0_0_1_2_1_0 - 0.0018983485650153*G0_0_1_2_1_1 + 0.0514862914862912*G0_1_1_0_0_0 + 0.0103639570306236*G0_1_1_0_0_1 + 0.000230880230880213*G0_1_1_0_0_2 + 0.0103639570306236*G0_1_1_0_1_0 - 0.00679814013147348*G0_1_1_0_1_1 + 0.000949174282507595*G0_1_1_0_1_2 + 0.000230880230880212*G0_1_1_0_2_0 + 0.000949174282507595*G0_1_1_0_2_1 + 0.0103639570306236*G0_1_1_1_0_0 - 0.00679814013147348*G0_1_1_1_0_1 + 0.000949174282507595*G0_1_1_1_0_2 - 0.00679814013147348*G0_1_1_1_1_0 - 0.0621837421837421*G0_1_1_1_1_1 - 0.00212922879589553*G0_1_1_1_1_2 + 0.000949174282507595*G0_1_1_1_2_0 - 0.00212922879589553*G0_1_1_1_2_1 + 0.000230880230880211*G0_1_1_2_0_0 + 0.000949174282507595*G0_1_1_2_0_1 + 0.000949174282507595*G0_1_1_2_1_0 - 0.00212922879589553*G0_1_1_2_1_1;
    A[19] = -A[25] + 0.0659291325957991*G0_0_0_0_0_0 + 0.00727914061247393*G0_0_0_0_0_1 + 0.015751162417829*G0_0_0_0_0_2 + 0.00727914061247393*G0_0_0_0_1_0 + 0.00224466891133562*G0_0_0_0_1_1 + 0.00299823633156966*G0_0_0_0_1_2 + 0.015751162417829*G0_0_0_0_2_0 + 0.00299823633156966*G0_0_0_0_2_1 + 0.0155715889049221*G0_0_0_0_2_2 + 0.00727914061247393*G0_0_0_1_0_0 + 0.00224466891133562*G0_0_0_1_0_1 + 0.00299823633156966*G0_0_0_1_0_2 + 0.00224466891133562*G0_0_0_1_1_0 + 0.181080647747314*G0_0_0_1_1_1 + 0.0131473464806798*G0_0_0_1_1_2 + 0.00299823633156966*G0_0_0_1_2_0 + 0.0131473464806798*G0_0_0_1_2_1 + 0.00625300625300621*G0_0_0_1_2_2 + 0.015751162417829*G0_0_0_2_0_0 + 0.00299823633156966*G0_0_0_2_0_1 + 0.0155715889049221*G0_0_0_2_0_2 + 0.00299823633156966*G0_0_0_2_1_0 + 0.0131473464806798*G0_0_0_2_1_1 + 0.00625300625300621*G0_0_0_2_1_2 + 0.0155715889049221*G0_0_0_2_2_0 + 0.00625300625300621*G0_0_0_2_2_1 + 0.0643129709796372*G0_0_0_2_2_2 + 0.00161616161616161*G0_0_1_0_0_0 + 0.00102613435946771*G0_0_1_0_0_1 + 0.000179573512906848*G0_0_1_0_0_2 + 0.00102613435946771*G0_0_1_0_1_0 - 0.0109026775693442*G0_0_1_0_1_1 + 0.000179573512906848*G0_0_1_0_2_0 - 0.000179573512906848*G0_0_1_0_2_2 + 0.00102613435946771*G0_0_1_1_0_0 - 0.0109026775693442*G0_0_1_1_0_1 - 0.0109026775693442*G0_0_1_1_1_0 + 0.0109026775693441*G0_0_1_1_1_2 + 0.0109026775693441*G0_0_1_1_2_1 - 0.0010261343594677*G0_0_1_1_2_2 + 0.000179573512906848*G0_0_1_2_0_0 - 0.000179573512906849*G0_0_1_2_0_2 + 0.0109026775693441*G0_0_1_2_1_1 - 0.00102613435946769*G0_0_1_2_1_2 - 0.000179573512906849*G0_0_1_2_2_0 - 0.0010261343594677*G0_0_1_2_2_1 - 0.00161616161616164*G0_0_1_2_2_2;
    A[7] = A[19] - 0.0558345358345358*G0_0_0_0_0_0 - 0.00339907006573674*G0_0_0_0_0_1 - 0.0104665704665704*G0_0_0_0_0_2 - 0.00339907006573674*G0_0_0_0_1_0 + 0.00339907006573669*G0_0_0_0_1_1 - 0.0104665704665704*G0_0_0_0_2_0 - 0.00801667468334131*G0_0_0_0_2_2 - 0.00339907006573674*G0_0_0_1_0_0 + 0.00339907006573669*G0_0_0_1_0_1 + 0.00339907006573669*G0_0_0_1_1_0 + 0.0558345358345352*G0_0_0_1_1_1 + 0.0104665704665704*G0_0_0_1_1_2 + 0.0104665704665704*G0_0_0_1_2_1 + 0.00801667468334131*G0_0_0_1_2_2 - 0.0104665704665704*G0_0_0_2_0_0 - 0.00801667468334131*G0_0_0_2_0_2 + 0.0104665704665704*G0_0_0_2_1_1 + 0.00801667468334132*G0_0_0_2_1_2 - 0.00801667468334131*G0_0_0_2_2_0 + 0.00801667468334131*G0_0_0_2_2_1 + 0.23494628827962*G0_0_1_0_0_0 + 0.0222542889209555*G0_0_1_0_0_1 + 0.00558601891935223*G0_0_1_0_0_2 + 0.0222542889209555*G0_0_1_0_1_0 + 0.0256533589866922*G0_0_1_0_1_1 + 0.00412057078723744*G0_0_1_0_1_2 + 0.00558601891935223*G0_0_1_0_2_0 + 0.00412057078723744*G0_0_1_0_2_1 + 0.00740099406766071*G0_0_1_0_2_2 + 0.0222542889209555*G0_0_1_1_0_0 + 0.0256533589866922*G0_0_1_1_0_1 + 0.00412057078723744*G0_0_1_1_0_2 + 0.0256533589866922*G0_0_1_1_1_0 + 0.290780824114156*G0_0_1_1_1_1 + 0.0160525893859227*G0_0_1_1_1_2 + 0.00412057078723744*G0_0_1_1_2_0 + 0.0160525893859227*G0_0_1_1_2_1 + 0.015417668751002*G0_0_1_1_2_2 + 0.00558601891935223*G0_0_1_2_0_0 + 0.00412057078723744*G0_0_1_2_0_1 + 0.00740099406766071*G0_0_1_2_0_2 + 0.00412057078723744*G0_0_1_2_1_0 + 0.0160525893859227*G0_0_1_2_1_1 + 0.015417668751002*G0_0_1_2_1_2 + 0.00740099406766071*G0_0_1_2_2_0 + 0.015417668751002*G0_0_1_2_2_1 + 0.0655763989097319*G0_0_1_2_2_2 - 0.0538560205226872*G0_1_0_0_0_0 - 0.00315856982523649*G0_1_0_0_0_1 - 0.00612473945807278*G0_1_0_0_0_2 - 0.00315856982523649*G0_1_0_0_1_0 + 0.000240500240500248*G0_1_0_0_1_1 + 0.000625300625300626*G0_1_0_0_1_2 - 0.00612473945807278*G0_1_0_0_2_0 + 0.000625300625300626*G0_1_0_0_2_1 + 0.00303030303030303*G0_1_0_0_2_2 - 0.00315856982523649*G0_1_0_1_0_0 + 0.000240500240500248*G0_1_0_1_0_1 + 0.000625300625300625*G0_1_0_1_0_2 + 0.000240500240500248*G0_1_0_1_1_0 + 0.00197851531184865*G0_1_0_1_1_1 + 0.00434183100849766*G0_1_0_1_1_2 + 0.000625300625300625*G0_1_0_1_2_0 + 0.00434183100849766*G0_1_0_1_2_1 + 0.0110469777136443*G0_1_0_1_2_2 - 0.00612473945807278*G0_1_0_2_0_0 + 0.000625300625300625*G0_1_0_2_0_1 + 0.00303030303030303*G0_1_0_2_0_2 + 0.000625300625300625*G0_1_0_2_1_0 + 0.00434183100849766*G0_1_0_2_1_1 + 0.0110469777136443*G0_1_0_2_1_2 + 0.00303030303030303*G0_1_0_2_2_0 + 0.0110469777136443*G0_1_0_2_2_1 + 0.0623248356581689*G0_1_0_2_2_2 + 0.23493666827*G0_1_1_0_0_0 + 0.0192720859387525*G0_1_1_0_0_1 + 0.00540323873657206*G0_1_1_0_0_2 + 0.0192720859387525*G0_1_1_0_1_0 + 0.00322270322270324*G0_1_1_0_1_1 + 0.00237293570626904*G0_1_1_0_1_2 + 0.00540323873657206*G0_1_1_0_2_0 + 0.00237293570626904*G0_1_1_0_2_1 + 0.0070386403719737*G0_1_1_0_2_2 + 0.0192720859387525*G0_1_1_1_0_0 + 0.00322270322270324*G0_1_1_1_0_1 + 0.00237293570626904*G0_1_1_1_0_2 + 0.00322270322270324*G0_1_1_1_1_0 + 0.00198813532146875*G0_1_1_1_1_1 + 0.00452461119127785*G0_1_1_1_1_2 + 0.00237293570626904*G0_1_1_1_2_0 + 0.00452461119127785*G0_1_1_1_2_1 + 0.0114093314093314*G0_1_1_1_2_2 + 0.00540323873657206*G0_1_1_2_0_0 + 0.00237293570626904*G0_1_1_2_0_1 + 0.0070386403719737*G0_1_1_2_0_2 + 0.00237293570626904*G0_1_1_2_1_0 + 0.00452461119127785*G0_1_1_2_1_1 + 0.0114093314093314*G0_1_1_2_1_2 + 0.0070386403719737*G0_1_1_2_2_0 + 0.0114093314093314*G0_1_1_2_2_1 + 0.0639506172839504*G0_1_1_2_2_2;
    A[61] = A[19] + 0.00298220298220297*G0_0_1_0_0_1 + 0.000182780182780178*G0_0_1_0_0_2 + 0.00298220298220297*G0_0_1_0_1_0 + 0.022430655763989*G0_0_1_0_1_1 + 0.00174763508096841*G0_0_1_0_1_2 + 0.000182780182780178*G0_0_1_0_2_0 + 0.00174763508096841*G0_0_1_0_2_1 + 0.00036235369568702*G0_0_1_0_2_2 + 0.00298220298220297*G0_0_1_1_0_0 + 0.022430655763989*G0_0_1_1_0_1 + 0.00174763508096841*G0_0_1_1_0_2 + 0.022430655763989*G0_0_1_1_1_0 + 0.288792688792688*G0_0_1_1_1_1 + 0.0115279781946448*G0_0_1_1_1_2 + 0.00174763508096841*G0_0_1_1_2_0 + 0.0115279781946448*G0_0_1_1_2_1 + 0.00400833734167065*G0_0_1_1_2_2 + 0.000182780182780178*G0_0_1_2_0_0 + 0.00174763508096841*G0_0_1_2_0_1 + 0.00036235369568702*G0_0_1_2_0_2 + 0.00174763508096841*G0_0_1_2_1_0 + 0.0115279781946448*G0_0_1_2_1_1 + 0.00400833734167065*G0_0_1_2_1_2 + 0.00036235369568702*G0_0_1_2_2_0 + 0.00400833734167065*G0_0_1_2_2_1 + 0.00162578162578153*G0_0_1_2_2_2 - 0.00298220298220297*G0_1_0_0_0_1 - 0.000182780182780178*G0_1_0_0_0_2 - 0.00298220298220297*G0_1_0_0_1_0 - 0.022430655763989*G0_1_0_0_1_1 - 0.00174763508096841*G0_1_0_0_1_2 - 0.000182780182780178*G0_1_0_0_2_0 - 0.00174763508096841*G0_1_0_0_2_1 - 0.00036235369568702*G0_1_0_0_2_2 - 0.00298220298220297*G0_1_0_1_0_0 - 0.022430655763989*G0_1_0_1_0_1 - 0.00174763508096841*G0_1_0_1_0_2 - 0.022430655763989*G0_1_0_1_1_0 - 0.288792688792688*G0_1_0_1_1_1 - 0.0115279781946448*G0_1_0_1_1_2 - 0.00174763508096841*G0_1_0_1_2_0 - 0.0115279781946448*G0_1_0_1_2_1 - 0.00400833734167065*G0_1_0_1_2_2 - 0.000182780182780178*G0_1_0_2_0_0 - 0.00174763508096841*G0_1_0_2_0_1 - 0.00036235369568702*G0_1_0_2_0_2 - 0.00174763508096841*G0_1_0_2_1_0 - 0.0115279781946448*G0_1_0_2_1_1 - 0.00400833734167065*G0_1_0_2_1_2 - 0.00036235369568702*G0_1_0_2_2_0 - 0.00400833734167065*G0_1_0_2_2_1 - 0.00162578162578153*G0_1_0_2_2_2;
    A[33] = -A[36] - 0.0117748917748917*G0_1_0_0_0_0 - 0.00130832130832131*G0_1_0_0_0_1 - 0.00384800384800382*G0_1_0_0_0_2 - 0.00130832130832131*G0_1_0_0_1_0 + 0.00130832130832129*G0_1_0_0_1_1 - 0.00384800384800382*G0_1_0_0_2_0 + 0.00666987333653998*G0_1_0_0_2_2 - 0.00130832130832131*G0_1_0_1_0_0 + 0.00130832130832129*G0_1_0_1_0_1 + 0.00130832130832129*G0_1_0_1_1_0 + 0.0117748917748917*G0_1_0_1_1_1 + 0.00384800384800383*G0_1_0_1_1_2 + 0.00384800384800383*G0_1_0_1_2_1 - 0.00666987333653995*G0_1_0_1_2_2 - 0.00384800384800382*G0_1_0_2_0_0 + 0.00666987333653999*G0_1_0_2_0_2 + 0.00384800384800383*G0_1_0_2_1_1 - 0.00666987333653995*G0_1_0_2_1_2 + 0.00666987333653999*G0_1_0_2_2_0 - 0.00666987333653995*G0_1_0_2_2_1 - 0.0584896584896582*G0_1_1_0_0_0 - 0.00847415958527067*G0_1_1_0_0_1 - 0.00330073218962106*G0_1_1_0_0_2 - 0.00847415958527067*G0_1_1_0_1_0 - 0.00716583827694939*G0_1_1_0_1_1 - 0.000867938645716424*G0_1_1_0_1_2 - 0.00330073218962106*G0_1_1_0_2_0 - 0.000867938645716424*G0_1_1_0_2_1 - 0.000769600769600781*G0_1_1_0_2_2 - 0.00847415958527067*G0_1_1_1_0_0 - 0.00716583827694939*G0_1_1_1_0_1 - 0.000867938645716424*G0_1_1_1_0_2 - 0.00716583827694939*G0_1_1_1_1_0 - 0.0467147667147668*G0_1_1_1_1_1 + 0.000547271658382748*G0_1_1_1_1_2 - 0.000867938645716424*G0_1_1_1_2_0 + 0.000547271658382747*G0_1_1_1_2_1 - 0.00743947410614076*G0_1_1_1_2_2 - 0.00330073218962106*G0_1_1_2_0_0 - 0.000867938645716424*G0_1_1_2_0_1 - 0.000769600769600781*G0_1_1_2_0_2 - 0.000867938645716424*G0_1_1_2_1_0 + 0.000547271658382747*G0_1_1_2_1_1 - 0.00743947410614076*G0_1_1_2_1_2 - 0.000769600769600781*G0_1_1_2_2_0 - 0.00743947410614076*G0_1_1_2_2_1 - 0.097611030944364*G0_1_1_2_2_2;
    A[41] = -A[33] - 0.00187269520602862*G0_1_0_0_0_0 - 0.00174442841109508*G0_1_0_0_0_1 + 0.00164181497514828*G0_1_0_0_0_2 - 0.00174442841109508*G0_1_0_0_1_0 - 0.00135107690663246*G0_1_0_0_1_1 + 0.00126129015017903*G0_1_0_0_1_2 + 0.00164181497514828*G0_1_0_0_2_0 + 0.00126129015017903*G0_1_0_0_2_1 + 0.0107829618940729*G0_1_0_0_2_2 - 0.00174442841109508*G0_1_0_1_0_0 - 0.00135107690663246*G0_1_0_1_0_1 + 0.00126129015017903*G0_1_0_1_0_2 - 0.00135107690663246*G0_1_0_1_1_0 + 0.0288600288600289*G0_1_0_1_1_1 + 0.00494254716476939*G0_1_0_1_1_2 + 0.00126129015017903*G0_1_0_1_2_0 + 0.00494254716476938*G0_1_0_1_2_1 + 0.00268505157394046*G0_1_0_1_2_2 + 0.00164181497514828*G0_1_0_2_0_0 + 0.00126129015017903*G0_1_0_2_0_1 + 0.0107829618940729*G0_1_0_2_0_2 + 0.00126129015017903*G0_1_0_2_1_0 + 0.00494254716476938*G0_1_0_2_1_1 + 0.00268505157394046*G0_1_0_2_1_2 + 0.0107829618940729*G0_1_0_2_2_0 + 0.00268505157394046*G0_1_0_2_2_1 + 0.117748917748917*G0_1_0_2_2_2;
    A[127] = A[113] + 0.0363251563251561*G0_0_1_0_0_0 + 0.00607984607984605*G0_0_1_0_0_1 + 0.0659547859547858*G0_0_1_0_0_2 + 0.00607984607984605*G0_0_1_0_1_0 + 0.00205226871893539*G0_0_1_0_1_1 + 0.0133140933140933*G0_0_1_0_1_2 + 0.0659547859547858*G0_0_1_0_2_0 + 0.0133140933140933*G0_0_1_0_2_1 + 0.129549462882796*G0_0_1_0_2_2 + 0.00607984607984605*G0_0_1_1_0_0 + 0.00205226871893539*G0_0_1_1_0_1 + 0.0133140933140933*G0_0_1_1_0_2 + 0.00205226871893539*G0_0_1_1_1_0 + 0.00464325797659132*G0_0_1_1_1_2 + 0.0133140933140933*G0_0_1_1_2_0 + 0.00464325797659132*G0_0_1_1_2_1 + 0.0271925605258939*G0_0_1_1_2_2 + 0.0659547859547858*G0_0_1_2_0_0 + 0.0133140933140933*G0_0_1_2_0_1 + 0.129549462882796*G0_0_1_2_0_2 + 0.0133140933140933*G0_0_1_2_1_0 + 0.00464325797659132*G0_0_1_2_1_1 + 0.0271925605258939*G0_0_1_2_1_2 + 0.129549462882796*G0_0_1_2_2_0 + 0.0271925605258939*G0_0_1_2_2_1 + 0.294757094757094*G0_0_1_2_2_2 - 0.0363251563251561*G0_1_0_0_0_0 - 0.00607984607984604*G0_1_0_0_0_1 - 0.0659547859547858*G0_1_0_0_0_2 - 0.00607984607984605*G0_1_0_0_1_0 - 0.00205226871893539*G0_1_0_0_1_1 - 0.0133140933140933*G0_1_0_0_1_2 - 0.0659547859547858*G0_1_0_0_2_0 - 0.0133140933140933*G0_1_0_0_2_1 - 0.129549462882796*G0_1_0_0_2_2 - 0.00607984607984605*G0_1_0_1_0_0 - 0.00205226871893539*G0_1_0_1_0_1 - 0.0133140933140933*G0_1_0_1_0_2 - 0.00205226871893539*G0_1_0_1_1_0 - 0.00464325797659132*G0_1_0_1_1_2 - 0.0133140933140933*G0_1_0_1_2_0 - 0.00464325797659132*G0_1_0_1_2_1 - 0.0271925605258939*G0_1_0_1_2_2 - 0.0659547859547858*G0_1_0_2_0_0 - 0.0133140933140933*G0_1_0_2_0_1 - 0.129549462882796*G0_1_0_2_0_2 - 0.0133140933140933*G0_1_0_2_1_0 - 0.00464325797659132*G0_1_0_2_1_1 - 0.0271925605258939*G0_1_0_2_1_2 - 0.129549462882796*G0_1_0_2_2_0 - 0.0271925605258939*G0_1_0_2_2_1 - 0.294757094757094*G0_1_0_2_2_2;
    A[62] = -A[107] + 0.00161616161616153*G0_0_1_0_0_0 + 0.000179573512906829*G0_0_1_0_0_1 + 0.00102613435946771*G0_0_1_0_0_2 + 0.000179573512906829*G0_0_1_0_1_0 - 0.000179573512906852*G0_0_1_0_1_1 + 0.00102613435946771*G0_0_1_0_2_0 - 0.0109026775693441*G0_0_1_0_2_2 + 0.000179573512906829*G0_0_1_1_0_0 - 0.000179573512906852*G0_0_1_1_0_1 - 0.000179573512906852*G0_0_1_1_1_0 - 0.00161616161616157*G0_0_1_1_1_1 - 0.00102613435946767*G0_0_1_1_1_2 - 0.00102613435946767*G0_0_1_1_2_1 + 0.0109026775693442*G0_0_1_1_2_2 + 0.0010261343594677*G0_0_1_2_0_0 - 0.0109026775693441*G0_0_1_2_0_2 - 0.00102613435946767*G0_0_1_2_1_1 + 0.0109026775693442*G0_0_1_2_1_2 - 0.0109026775693441*G0_0_1_2_2_0 + 0.0109026775693442*G0_0_1_2_2_1 + 0.0659291325957988*G0_1_1_0_0_0 + 0.015751162417829*G0_1_1_0_0_1 + 0.0072791406124739*G0_1_1_0_0_2 + 0.015751162417829*G0_1_1_0_1_0 + 0.0155715889049222*G0_1_1_0_1_1 + 0.00299823633156965*G0_1_1_0_1_2 + 0.0072791406124739*G0_1_1_0_2_0 + 0.00299823633156965*G0_1_1_0_2_1 + 0.00224466891133559*G0_1_1_0_2_2 + 0.015751162417829*G0_1_1_1_0_0 + 0.0155715889049222*G0_1_1_1_0_1 + 0.00299823633156965*G0_1_1_1_0_2 + 0.0155715889049222*G0_1_1_1_1_0 + 0.0643129709796377*G0_1_1_1_1_1 + 0.00625300625300626*G0_1_1_1_1_2 + 0.00299823633156965*G0_1_1_1_2_0 + 0.00625300625300626*G0_1_1_1_2_1 + 0.0131473464806798*G0_1_1_1_2_2 + 0.0072791406124739*G0_1_1_2_0_0 + 0.00299823633156965*G0_1_1_2_0_1 + 0.00224466891133559*G0_1_1_2_0_2 + 0.00299823633156965*G0_1_1_2_1_0 + 0.00625300625300626*G0_1_1_2_1_1 + 0.0131473464806798*G0_1_1_2_1_2 + 0.00224466891133559*G0_1_1_2_2_0 + 0.0131473464806798*G0_1_1_2_2_1 + 0.181080647747313*G0_1_1_2_2_2;
    A[44] = A[212] + 0.00161616161616154*G0_0_1_0_0_0 + 0.000179573512906829*G0_0_1_0_0_1 + 0.00102613435946771*G0_0_1_0_0_2 + 0.000179573512906829*G0_0_1_0_1_0 - 0.000179573512906852*G0_0_1_0_1_1 + 0.00102613435946771*G0_0_1_0_2_0 - 0.0109026775693441*G0_0_1_0_2_2 + 0.000179573512906829*G0_0_1_1_0_0 - 0.000179573512906852*G0_0_1_1_0_1 - 0.000179573512906852*G0_0_1_1_1_0 - 0.00161616161616156*G0_0_1_1_1_1 - 0.00102613435946767*G0_0_1_1_1_2 - 0.00102613435946767*G0_0_1_1_2_1 + 0.0109026775693443*G0_0_1_1_2_2 + 0.00102613435946771*G0_0_1_2_0_0 - 0.0109026775693441*G0_0_1_2_0_2 - 0.00102613435946767*G0_0_1_2_1_1 + 0.0109026775693443*G0_0_1_2_1_2 - 0.0109026775693441*G0_0_1_2_2_0 + 0.0109026775693443*G0_0_1_2_2_1 - 0.00161616161616154*G0_1_0_0_0_0 - 0.000179573512906829*G0_1_0_0_0_1 - 0.00102613435946771*G0_1_0_0_0_2 - 0.000179573512906829*G0_1_0_0_1_0 + 0.000179573512906852*G0_1_0_0_1_1 - 0.00102613435946771*G0_1_0_0_2_0 + 0.0109026775693441*G0_1_0_0_2_2 - 0.000179573512906829*G0_1_0_1_0_0 + 0.000179573512906852*G0_1_0_1_0_1 + 0.000179573512906852*G0_1_0_1_1_0 + 0.00161616161616156*G0_1_0_1_1_1 + 0.00102613435946767*G0_1_0_1_1_2 + 0.00102613435946767*G0_1_0_1_2_1 - 0.0109026775693443*G0_1_0_1_2_2 - 0.00102613435946771*G0_1_0_2_0_0 + 0.0109026775693441*G0_1_0_2_0_2 + 0.00102613435946767*G0_1_0_2_1_1 - 0.0109026775693443*G0_1_0_2_1_2 + 0.0109026775693441*G0_1_0_2_2_0 - 0.0109026775693443*G0_1_0_2_2_1;
    A[141] = A[99] + 0.301683501683501*G0_0_1_0_0_0 - 0.0266794933461598*G0_0_1_0_0_1 - 0.0266794933461599*G0_0_1_0_0_2 - 0.0266794933461598*G0_0_1_0_1_0 - 0.0123136123136122*G0_0_1_0_1_1 - 0.00615680615680613*G0_0_1_0_1_2 - 0.0266794933461599*G0_0_1_0_2_0 - 0.00615680615680612*G0_0_1_0_2_1 - 0.0123136123136123*G0_0_1_0_2_2 - 0.0266794933461598*G0_0_1_1_0_0 - 0.0123136123136122*G0_0_1_1_0_1 - 0.00615680615680613*G0_0_1_1_0_2 - 0.0123136123136122*G0_0_1_1_1_0 - 0.00769600769600781*G0_0_1_1_1_1 - 0.00256533589866928*G0_0_1_1_1_2 - 0.00615680615680612*G0_0_1_1_2_0 - 0.00256533589866928*G0_0_1_1_2_1 - 0.00256533589866928*G0_0_1_1_2_2 - 0.0266794933461599*G0_0_1_2_0_0 - 0.00615680615680612*G0_0_1_2_0_1 - 0.0123136123136123*G0_0_1_2_0_2 - 0.00615680615680612*G0_0_1_2_1_0 - 0.00256533589866928*G0_0_1_2_1_1 - 0.00256533589866928*G0_0_1_2_1_2 - 0.0123136123136123*G0_0_1_2_2_0 - 0.00256533589866928*G0_0_1_2_2_1 - 0.00769600769600777*G0_0_1_2_2_2 - 0.301683501683501*G0_1_0_0_0_0 + 0.0266794933461598*G0_1_0_0_0_1 + 0.0266794933461599*G0_1_0_0_0_2 + 0.0266794933461598*G0_1_0_0_1_0 + 0.0123136123136122*G0_1_0_0_1_1 + 0.00615680615680612*G0_1_0_0_1_2 + 0.0266794933461599*G0_1_0_0_2_0 + 0.00615680615680612*G0_1_0_0_2_1 + 0.0123136123136123*G0_1_0_0_2_2 + 0.0266794933461598*G0_1_0_1_0_0 + 0.0123136123136122*G0_1_0_1_0_1 + 0.00615680615680612*G0_1_0_1_0_2 + 0.0123136123136122*G0_1_0_1_1_0 + 0.00769600769600781*G0_1_0_1_1_1 + 0.00256533589866928*G0_1_0_1_1_2 + 0.00615680615680612*G0_1_0_1_2_0 + 0.00256533589866928*G0_1_0_1_2_1 + 0.00256533589866928*G0_1_0_1_2_2 + 0.0266794933461599*G0_1_0_2_0_0 + 0.00615680615680612*G0_1_0_2_0_1 + 0.0123136123136123*G0_1_0_2_0_2 + 0.00615680615680612*G0_1_0_2_1_0 + 0.00256533589866928*G0_1_0_2_1_1 + 0.00256533589866928*G0_1_0_2_1_2 + 0.0123136123136123*G0_1_0_2_2_0 + 0.00256533589866928*G0_1_0_2_2_1 + 0.00769600769600777*G0_1_0_2_2_2;
    A[172] = -A[52] - 0.0181882315215646*G0_0_0_0_0_0 + 0.001000481000481*G0_0_0_0_0_1 - 0.0347346480679812*G0_0_0_0_0_2 + 0.001000481000481*G0_0_0_0_1_0 + 0.00646464646464644*G0_0_0_0_1_1 + 0.00325797659130993*G0_0_0_0_1_2 - 0.0347346480679812*G0_0_0_0_2_0 + 0.00325797659130993*G0_0_0_0_2_1 - 0.048664421997755*G0_0_0_0_2_2 + 0.001000481000481*G0_0_0_1_0_0 + 0.00646464646464644*G0_0_0_1_0_1 + 0.00325797659130993*G0_0_0_1_0_2 + 0.00646464646464644*G0_0_0_1_1_0 + 0.0205226871893543*G0_0_0_1_1_1 + 0.00687510020843361*G0_0_0_1_1_2 + 0.00325797659130993*G0_0_0_1_2_0 + 0.00687510020843361*G0_0_0_1_2_1 - 0.00110309443642769*G0_0_0_1_2_2 - 0.0347346480679812*G0_0_0_2_0_0 + 0.00325797659130993*G0_0_0_2_0_1 - 0.048664421997755*G0_0_0_2_0_2 + 0.00325797659130993*G0_0_0_2_1_0 + 0.00687510020843361*G0_0_0_2_1_1 - 0.00110309443642769*G0_0_0_2_1_2 - 0.048664421997755*G0_0_0_2_2_0 - 0.00110309443642769*G0_0_0_2_2_1 - 0.0315023248356582*G0_0_0_2_2_2 + 0.0133140933140923*G0_0_1_0_0_0 + 0.00210357543690866*G0_0_1_0_0_1 + 0.0139297739297737*G0_0_1_0_0_2 + 0.00210357543690866*G0_0_1_0_1_0 - 0.000410453743787109*G0_0_1_0_1_1 + 0.0139297739297737*G0_0_1_0_2_0 - 0.0139297739297739*G0_0_1_0_2_2 + 0.00210357543690866*G0_0_1_1_0_0 - 0.000410453743787109*G0_0_1_1_0_1 - 0.000410453743787108*G0_0_1_1_1_0 + 0.000410453743787122*G0_0_1_1_1_2 + 0.000410453743787121*G0_0_1_1_2_1 - 0.0021035754369087*G0_0_1_1_2_2 + 0.0139297739297737*G0_0_1_2_0_0 - 0.0139297739297739*G0_0_1_2_0_2 + 0.000410453743787122*G0_0_1_2_1_1 - 0.0021035754369087*G0_0_1_2_1_2 - 0.0139297739297739*G0_0_1_2_2_0 - 0.0021035754369087*G0_0_1_2_2_1 - 0.0133140933140933*G0_0_1_2_2_2;
    A[155] = -A[158] + 0.0133140933140929*G0_0_1_0_0_0 + 0.0139297739297738*G0_0_1_0_0_1 + 0.00210357543690871*G0_0_1_0_0_2 + 0.0139297739297738*G0_0_1_0_1_0 - 0.0139297739297739*G0_0_1_0_1_1 + 0.00210357543690871*G0_0_1_0_2_0 - 0.000410453743787064*G0_0_1_0_2_2 + 0.0139297739297738*G0_0_1_1_0_0 - 0.0139297739297739*G0_0_1_1_0_1 - 0.0139297739297739*G0_0_1_1_1_0 - 0.0133140933140927*G0_0_1_1_1_1 - 0.00210357543690881*G0_0_1_1_1_2 - 0.00210357543690881*G0_0_1_1_2_1 + 0.000410453743787035*G0_0_1_1_2_2 + 0.00210357543690871*G0_0_1_2_0_0 - 0.000410453743787064*G0_0_1_2_0_2 - 0.0021035754369088*G0_0_1_2_1_1 + 0.000410453743787035*G0_0_1_2_1_2 - 0.000410453743787063*G0_0_1_2_2_0 + 0.000410453743787036*G0_0_1_2_2_1 - 0.018188231521565*G0_1_1_0_0_0 - 0.0347346480679812*G0_1_1_0_0_1 + 0.00100048100048103*G0_1_1_0_0_2 - 0.0347346480679812*G0_1_1_0_1_0 - 0.048664421997755*G0_1_1_0_1_1 + 0.00325797659130993*G0_1_1_0_1_2 + 0.00100048100048103*G0_1_1_0_2_0 + 0.00325797659130993*G0_1_1_0_2_1 + 0.00646464646464653*G0_1_1_0_2_2 - 0.0347346480679812*G0_1_1_1_0_0 - 0.048664421997755*G0_1_1_1_0_1 + 0.00325797659130993*G0_1_1_1_0_2 - 0.048664421997755*G0_1_1_1_1_0 - 0.0315023248356573*G0_1_1_1_1_1 - 0.00110309443642777*G0_1_1_1_1_2 + 0.00325797659130993*G0_1_1_1_2_0 - 0.00110309443642777*G0_1_1_1_2_1 + 0.00687510020843352*G0_1_1_1_2_2 + 0.00100048100048103*G0_1_1_2_0_0 + 0.00325797659130993*G0_1_1_2_0_1 + 0.00646464646464653*G0_1_1_2_0_2 + 0.00325797659130993*G0_1_1_2_1_0 - 0.00110309443642778*G0_1_1_2_1_1 + 0.00687510020843351*G0_1_1_2_1_2 + 0.00646464646464653*G0_1_1_2_2_0 + 0.00687510020843352*G0_1_1_2_2_1 + 0.0205226871893539*G0_1_1_2_2_2;
    A[85] = A[155] - 0.0157768157768157*G0_0_1_0_0_0 - 0.00359147025813681*G0_0_1_0_0_1 + 0.000179573512906871*G0_0_1_0_0_2 - 0.00359147025813681*G0_0_1_0_1_0 + 0.010338303671637*G0_0_1_0_1_1 - 0.00110309443642775*G0_0_1_0_1_2 + 0.000179573512906871*G0_0_1_0_2_0 - 0.00110309443642775*G0_0_1_0_2_1 + 0.000359147025813753*G0_0_1_0_2_2 - 0.00359147025813681*G0_0_1_1_0_0 + 0.010338303671637*G0_0_1_1_0_1 - 0.00110309443642775*G0_0_1_1_0_2 + 0.010338303671637*G0_0_1_1_1_0 - 0.00246272246272287*G0_0_1_1_1_1 + 0.00228314894981565*G0_0_1_1_1_2 - 0.00110309443642775*G0_0_1_1_2_0 + 0.00228314894981565*G0_0_1_1_2_1 + 0.00017957351290687*G0_0_1_2_0_0 - 0.00110309443642775*G0_0_1_2_0_1 + 0.000359147025813752*G0_0_1_2_0_2 - 0.00110309443642775*G0_0_1_2_1_0 + 0.00228314894981565*G0_0_1_2_1_1 + 0.000359147025813753*G0_0_1_2_2_0 - 0.00369408369408321*G0_0_1_2_2_2 + 0.0157768157768157*G0_1_0_0_0_0 + 0.00359147025813681*G0_1_0_0_0_1 - 0.000179573512906871*G0_1_0_0_0_2 + 0.00359147025813681*G0_1_0_0_1_0 - 0.010338303671637*G0_1_0_0_1_1 + 0.00110309443642775*G0_1_0_0_1_2 - 0.000179573512906871*G0_1_0_0_2_0 + 0.00110309443642775*G0_1_0_0_2_1 - 0.000359147025813753*G0_1_0_0_2_2 + 0.00359147025813681*G0_1_0_1_0_0 - 0.010338303671637*G0_1_0_1_0_1 + 0.00110309443642775*G0_1_0_1_0_2 - 0.010338303671637*G0_1_0_1_1_0 + 0.00246272246272283*G0_1_0_1_1_1 - 0.00228314894981565*G0_1_0_1_1_2 + 0.00110309443642775*G0_1_0_1_2_0 - 0.00228314894981565*G0_1_0_1_2_1 - 0.00017957351290687*G0_1_0_2_0_0 + 0.00110309443642775*G0_1_0_2_0_1 - 0.000359147025813752*G0_1_0_2_0_2 + 0.00110309443642775*G0_1_0_2_1_0 - 0.00228314894981565*G0_1_0_2_1_1 - 0.000359147025813752*G0_1_0_2_2_0 + 0.00369408369408321*G0_1_0_2_2_2;
    A[130] = -A[85] + 0.0133140933140929*G0_1_0_0_0_0 + 0.0139297739297738*G0_1_0_0_0_1 + 0.00210357543690871*G0_1_0_0_0_2 + 0.0139297739297738*G0_1_0_0_1_0 - 0.0139297739297739*G0_1_0_0_1_1 + 0.00210357543690871*G0_1_0_0_2_0 - 0.000410453743787064*G0_1_0_0_2_2 + 0.0139297739297738*G0_1_0_1_0_0 - 0.0139297739297739*G0_1_0_1_0_1 - 0.0139297739297739*G0_1_0_1_1_0 - 0.0133140933140927*G0_1_0_1_1_1 - 0.00210357543690881*G0_1_0_1_1_2 - 0.00210357543690881*G0_1_0_1_2_1 + 0.000410453743787036*G0_1_0_1_2_2 + 0.00210357543690871*G0_1_0_2_0_0 - 0.000410453743787064*G0_1_0_2_0_2 - 0.00210357543690881*G0_1_0_2_1_1 + 0.000410453743787036*G0_1_0_2_1_2 - 0.000410453743787065*G0_1_0_2_2_0 + 0.000410453743787036*G0_1_0_2_2_1 - 0.018188231521565*G0_1_1_0_0_0 - 0.0347346480679812*G0_1_1_0_0_1 + 0.00100048100048103*G0_1_1_0_0_2 - 0.0347346480679812*G0_1_1_0_1_0 - 0.048664421997755*G0_1_1_0_1_1 + 0.00325797659130993*G0_1_1_0_1_2 + 0.00100048100048103*G0_1_1_0_2_0 + 0.00325797659130993*G0_1_1_0_2_1 + 0.00646464646464653*G0_1_1_0_2_2 - 0.0347346480679812*G0_1_1_1_0_0 - 0.048664421997755*G0_1_1_1_0_1 + 0.00325797659130993*G0_1_1_1_0_2 - 0.048664421997755*G0_1_1_1_1_0 - 0.0315023248356574*G0_1_1_1_1_1 - 0.00110309443642778*G0_1_1_1_1_2 + 0.00325797659130993*G0_1_1_1_2_0 - 0.00110309443642778*G0_1_1_1_2_1 + 0.00687510020843351*G0_1_1_1_2_2 + 0.00100048100048103*G0_1_1_2_0_0 + 0.00325797659130993*G0_1_1_2_0_1 + 0.00646464646464653*G0_1_1_2_0_2 + 0.00325797659130993*G0_1_1_2_1_0 - 0.00110309443642778*G0_1_1_2_1_1 + 0.00687510020843351*G0_1_1_2_1_2 + 0.00646464646464653*G0_1_1_2_2_0 + 0.00687510020843351*G0_1_1_2_2_1 + 0.0205226871893539*G0_1_1_2_2_2;
    A[105] = A[7] - 0.288792688792688*G0_0_1_0_0_0 - 0.022430655763989*G0_0_1_0_0_1 - 0.0115279781946448*G0_0_1_0_0_2 - 0.022430655763989*G0_0_1_0_1_0 - 0.00298220298220297*G0_0_1_0_1_1 - 0.00174763508096841*G0_0_1_0_1_2 - 0.0115279781946448*G0_0_1_0_2_0 - 0.00174763508096841*G0_0_1_0_2_1 - 0.00400833734167066*G0_0_1_0_2_2 - 0.022430655763989*G0_0_1_1_0_0 - 0.00298220298220297*G0_0_1_1_0_1 - 0.00174763508096841*G0_0_1_1_0_2 - 0.00298220298220297*G0_0_1_1_1_0 - 0.000182780182780181*G0_0_1_1_1_2 - 0.00174763508096841*G0_0_1_1_2_0 - 0.000182780182780182*G0_0_1_1_2_1 - 0.000362353695687012*G0_0_1_1_2_2 - 0.0115279781946448*G0_0_1_2_0_0 - 0.00174763508096841*G0_0_1_2_0_1 - 0.00400833734167066*G0_0_1_2_0_2 - 0.00174763508096841*G0_0_1_2_1_0 - 0.000182780182780182*G0_0_1_2_1_1 - 0.000362353695687012*G0_0_1_2_1_2 - 0.00400833734167066*G0_0_1_2_2_0 - 0.000362353695687014*G0_0_1_2_2_1 - 0.00162578162578143*G0_0_1_2_2_2 + 0.288792688792688*G0_1_0_0_0_0 + 0.022430655763989*G0_1_0_0_0_1 + 0.0115279781946448*G0_1_0_0_0_2 + 0.022430655763989*G0_1_0_0_1_0 + 0.00298220298220297*G0_1_0_0_1_1 + 0.00174763508096841*G0_1_0_0_1_2 + 0.0115279781946448*G0_1_0_0_2_0 + 0.00174763508096841*G0_1_0_0_2_1 + 0.00400833734167066*G0_1_0_0_2_2 + 0.022430655763989*G0_1_0_1_0_0 + 0.00298220298220297*G0_1_0_1_0_1 + 0.00174763508096841*G0_1_0_1_0_2 + 0.00298220298220297*G0_1_0_1_1_0 + 0.000182780182780181*G0_1_0_1_1_2 + 0.00174763508096841*G0_1_0_1_2_0 + 0.000182780182780182*G0_1_0_1_2_1 + 0.000362353695687012*G0_1_0_1_2_2 + 0.0115279781946448*G0_1_0_2_0_0 + 0.00174763508096841*G0_1_0_2_0_1 + 0.00400833734167066*G0_1_0_2_0_2 + 0.00174763508096841*G0_1_0_2_1_0 + 0.000182780182780182*G0_1_0_2_1_1 + 0.000362353695687012*G0_1_0_2_1_2 + 0.00400833734167066*G0_1_0_2_2_0 + 0.000362353695687014*G0_1_0_2_2_1 + 0.00162578162578144*G0_1_0_2_2_2;
    A[10] = A[105] + 0.288792688792688*G0_0_0_0_0_0 + 0.00856180856180857*G0_0_0_0_0_1 + 0.0253968253968253*G0_0_0_0_0_2 + 0.00856180856180857*G0_0_0_0_1_0 + 0.00679814013147343*G0_0_0_0_1_1 + 0.00174763508096841*G0_0_0_0_1_2 + 0.0253968253968253*G0_0_0_0_2_0 + 0.00174763508096841*G0_0_0_0_2_1 + 0.000192400192400193*G0_0_0_0_2_2 + 0.00856180856180857*G0_0_0_1_0_0 + 0.00679814013147343*G0_0_0_1_0_1 + 0.00174763508096841*G0_0_0_1_0_2 + 0.00679814013147343*G0_0_0_1_1_0 + 0.0619721019721017*G0_0_0_1_1_1 + 0.00706750040083368*G0_0_0_1_1_2 + 0.00174763508096841*G0_0_0_1_2_0 + 0.00706750040083368*G0_0_0_1_2_1 - 0.00652236652236649*G0_0_0_1_2_2 + 0.0253968253968253*G0_0_0_2_0_0 + 0.00174763508096841*G0_0_0_2_0_1 + 0.000192400192400194*G0_0_0_2_0_2 + 0.00174763508096841*G0_0_0_2_1_0 + 0.00706750040083368*G0_0_0_2_1_1 - 0.00652236652236649*G0_0_0_2_1_2 + 0.000192400192400194*G0_0_0_2_2_0 - 0.00652236652236649*G0_0_0_2_2_1 - 0.0603367003367*G0_0_0_2_2_2 - 0.00296616963283625*G0_0_1_0_0_1 + 0.00296616963283632*G0_0_1_0_0_2 - 0.00296616963283625*G0_0_1_0_1_0 + 0.00278980278980278*G0_0_1_0_1_1 + 0.00296616963283632*G0_0_1_0_2_0 - 0.00278980278980279*G0_0_1_0_2_2 - 0.00296616963283625*G0_0_1_1_0_0 + 0.00278980278980278*G0_0_1_1_0_1 + 0.00278980278980278*G0_0_1_1_1_0 + 0.06034632034632*G0_0_1_1_1_1 + 0.00670514670514665*G0_0_1_1_1_2 + 0.00670514670514665*G0_0_1_1_2_1 - 0.00670514670514669*G0_0_1_1_2_2 + 0.00296616963283632*G0_0_1_2_0_0 - 0.00278980278980279*G0_0_1_2_0_2 + 0.00670514670514665*G0_0_1_2_1_1 - 0.00670514670514669*G0_0_1_2_1_2 - 0.00278980278980279*G0_0_1_2_2_0 - 0.00670514670514669*G0_0_1_2_2_1 - 0.0603463203463202*G0_0_1_2_2_2 - 0.0138688472021804*G0_1_0_0_0_1 + 0.0138688472021805*G0_1_0_0_0_2 - 0.0138688472021804*G0_1_0_0_1_0 + 0.00381593714927044*G0_1_0_0_1_1 + 0.0138688472021805*G0_1_0_0_2_0 - 0.00381593714927048*G0_1_0_0_2_2 - 0.0138688472021804*G0_1_0_1_0_0 + 0.00381593714927044*G0_1_0_1_0_1 + 0.00381593714927044*G0_1_0_1_1_0 + 0.0619624819624815*G0_1_0_1_1_1 + 0.00688472021805348*G0_1_0_1_1_2 + 0.00688472021805348*G0_1_0_1_2_1 - 0.00688472021805352*G0_1_0_1_2_2 + 0.0138688472021805*G0_1_0_2_0_0 - 0.00381593714927048*G0_1_0_2_0_2 + 0.00688472021805348*G0_1_0_2_1_1 - 0.00688472021805352*G0_1_0_2_1_2 - 0.00381593714927048*G0_1_0_2_2_0 - 0.00688472021805352*G0_1_0_2_2_1 - 0.0619624819624816*G0_1_0_2_2_2 - 0.288792688792687*G0_1_1_0_0_0 - 0.0253968253968253*G0_1_1_0_0_1 - 0.00856180856180852*G0_1_1_0_0_2 - 0.0253968253968253*G0_1_1_0_1_0 - 0.000192400192400224*G0_1_1_0_1_1 - 0.00174763508096842*G0_1_1_0_1_2 - 0.00856180856180852*G0_1_1_0_2_0 - 0.00174763508096842*G0_1_1_0_2_1 - 0.00679814013147346*G0_1_1_0_2_2 - 0.0253968253968253*G0_1_1_1_0_0 - 0.000192400192400223*G0_1_1_1_0_1 - 0.00174763508096842*G0_1_1_1_0_2 - 0.000192400192400224*G0_1_1_1_1_0 + 0.0603367003366999*G0_1_1_1_1_1 + 0.00652236652236644*G0_1_1_1_1_2 - 0.00174763508096842*G0_1_1_1_2_0 + 0.00652236652236644*G0_1_1_1_2_1 - 0.00706750040083372*G0_1_1_1_2_2 - 0.00856180856180852*G0_1_1_2_0_0 - 0.00174763508096842*G0_1_1_2_0_1 - 0.00679814013147346*G0_1_1_2_0_2 - 0.00174763508096842*G0_1_1_2_1_0 + 0.00652236652236645*G0_1_1_2_1_1 - 0.00706750040083372*G0_1_1_2_1_2 - 0.00679814013147346*G0_1_1_2_2_0 - 0.00706750040083372*G0_1_1_2_2_1 - 0.0619721019721018*G0_1_1_2_2_2;
    A[150] = A[10] + 0.288792688792688*G0_0_1_0_0_0 + 0.0115279781946448*G0_0_1_0_0_1 + 0.022430655763989*G0_0_1_0_0_2 + 0.0115279781946448*G0_0_1_0_1_0 + 0.00400833734167064*G0_0_1_0_1_1 + 0.00174763508096841*G0_0_1_0_1_2 + 0.022430655763989*G0_0_1_0_2_0 + 0.00174763508096841*G0_0_1_0_2_1 + 0.00298220298220296*G0_0_1_0_2_2 + 0.0115279781946448*G0_0_1_1_0_0 + 0.00400833734167064*G0_0_1_1_0_1 + 0.00174763508096841*G0_0_1_1_0_2 + 0.00400833734167064*G0_0_1_1_1_0 + 0.00162578162578153*G0_0_1_1_1_1 + 0.000362353695687016*G0_0_1_1_1_2 + 0.00174763508096841*G0_0_1_1_2_0 + 0.000362353695687016*G0_0_1_1_2_1 + 0.000182780182780178*G0_0_1_1_2_2 + 0.022430655763989*G0_0_1_2_0_0 + 0.00174763508096841*G0_0_1_2_0_1 + 0.00298220298220296*G0_0_1_2_0_2 + 0.00174763508096841*G0_0_1_2_1_0 + 0.000362353695687016*G0_0_1_2_1_1 + 0.000182780182780179*G0_0_1_2_1_2 + 0.00298220298220296*G0_0_1_2_2_0 + 0.000182780182780179*G0_0_1_2_2_1 - 0.288792688792688*G0_1_0_0_0_0 - 0.0115279781946448*G0_1_0_0_0_1 - 0.022430655763989*G0_1_0_0_0_2 - 0.0115279781946448*G0_1_0_0_1_0 - 0.00400833734167064*G0_1_0_0_1_1 - 0.00174763508096841*G0_1_0_0_1_2 - 0.022430655763989*G0_1_0_0_2_0 - 0.00174763508096841*G0_1_0_0_2_1 - 0.00298220298220296*G0_1_0_0_2_2 - 0.0115279781946448*G0_1_0_1_0_0 - 0.00400833734167064*G0_1_0_1_0_1 - 0.00174763508096841*G0_1_0_1_0_2 - 0.00400833734167064*G0_1_0_1_1_0 - 0.00162578162578153*G0_1_0_1_1_1 - 0.000362353695687016*G0_1_0_1_1_2 - 0.00174763508096841*G0_1_0_1_2_0 - 0.000362353695687016*G0_1_0_1_2_1 - 0.000182780182780179*G0_1_0_1_2_2 - 0.022430655763989*G0_1_0_2_0_0 - 0.00174763508096841*G0_1_0_2_0_1 - 0.00298220298220296*G0_1_0_2_0_2 - 0.00174763508096841*G0_1_0_2_1_0 - 0.000362353695687016*G0_1_0_2_1_1 - 0.000182780182780179*G0_1_0_2_1_2 - 0.00298220298220296*G0_1_0_2_2_0 - 0.000182780182780179*G0_1_0_2_2_1;
    A[173] = -0.00246272246272246*G0_0_0_0_0_0 - 0.0006156806156806*G0_0_0_0_0_1 - 0.00143658810325476*G0_0_0_0_0_2 - 0.0006156806156806*G0_0_0_0_1_0 - 0.0016760194537972*G0_0_0_0_1_1 + 3.42044786489267e-05*G0_0_0_0_1_2 - 0.00143658810325476*G0_0_0_0_2_0 + 3.42044786489267e-05*G0_0_0_0_2_1 - 0.00311260755705196*G0_0_0_0_2_2 - 0.0006156806156806*G0_0_0_1_0_0 - 0.0016760194537972*G0_0_0_1_0_1 + 3.42044786489267e-05*G0_0_0_1_0_2 - 0.0016760194537972*G0_0_0_1_1_0 + 0.00933782267115583*G0_0_0_1_1_1 + 0.00136817914595692*G0_0_0_1_1_2 + 3.42044786489267e-05*G0_0_0_1_2_0 + 0.00136817914595692*G0_0_0_1_2_1 + 0.00311260755705199*G0_0_0_1_2_2 - 0.00143658810325476*G0_0_0_2_0_0 + 3.42044786489268e-05*G0_0_0_2_0_1 - 0.00311260755705196*G0_0_0_2_0_2 + 3.42044786489268e-05*G0_0_0_2_1_0 + 0.00136817914595692*G0_0_0_2_1_1 + 0.00311260755705199*G0_0_0_2_1_2 - 0.00311260755705196*G0_0_0_2_2_0 + 0.00311260755705199*G0_0_0_2_2_1 + 0.0106717973384642*G0_0_1_0_0_0 + 0.00256533589866924*G0_0_1_0_0_1 + 0.00256533589866925*G0_0_1_0_0_2 + 0.00256533589866924*G0_0_1_0_1_0 + 0.00646464646464642*G0_0_1_0_1_1 + 0.00256533589866925*G0_0_1_0_2_0 + 0.00646464646464643*G0_0_1_0_2_2 + 0.00256533589866924*G0_0_1_1_0_0 + 0.00646464646464642*G0_0_1_1_0_1 + 0.00646464646464642*G0_0_1_1_1_0 + 0.0183678050344712*G0_0_1_1_1_1 + 0.00256533589866925*G0_0_1_2_0_0 + 0.00646464646464643*G0_0_1_2_0_2 + 0.00646464646464643*G0_0_1_2_2_0 + 0.0183678050344715*G0_0_1_2_2_2 + 0.000820907487574149*G0_1_0_0_0_0 + 0.000718294051627369*G0_1_0_0_0_1 + 0.000718294051627378*G0_1_0_0_0_2 + 0.000718294051627369*G0_1_0_0_1_0 + 0.00311260755705193*G0_1_0_0_1_1 + 0.000684089572978455*G0_1_0_0_1_2 + 0.000718294051627378*G0_1_0_0_2_0 + 0.000684089572978455*G0_1_0_0_2_1 + 0.00311260755705197*G0_1_0_0_2_2 + 0.000718294051627369*G0_1_0_1_0_0 + 0.00311260755705193*G0_1_0_1_0_1 + 0.000684089572978455*G0_1_0_1_0_2 + 0.00311260755705193*G0_1_0_1_1_0 + 0.0277056277056271*G0_1_0_1_1_1 + 0.00304419859975413*G0_1_0_1_1_2 + 0.000684089572978455*G0_1_0_1_2_0 + 0.00304419859975413*G0_1_0_1_2_1 + 0.00304419859975413*G0_1_0_1_2_2 + 0.000718294051627378*G0_1_0_2_0_0 + 0.000684089572978455*G0_1_0_2_0_1 + 0.00311260755705197*G0_1_0_2_0_2 + 0.000684089572978455*G0_1_0_2_1_0 + 0.00304419859975413*G0_1_0_2_1_1 + 0.00304419859975413*G0_1_0_2_1_2 + 0.00311260755705197*G0_1_0_2_2_0 + 0.00304419859975413*G0_1_0_2_2_1 + 0.0277056277056274*G0_1_0_2_2_2 - 0.00246272246272254*G0_1_1_0_0_0 - 0.00143658810325478*G0_1_1_0_0_1 - 0.000615680615680617*G0_1_1_0_0_2 - 0.00143658810325478*G0_1_1_0_1_0 - 0.00311260755705204*G0_1_1_0_1_1 + 3.42044786489188e-05*G0_1_1_0_1_2 - 0.000615680615680617*G0_1_1_0_2_0 + 3.42044786489187e-05*G0_1_1_0_2_1 - 0.00167601945379722*G0_1_1_0_2_2 - 0.00143658810325478*G0_1_1_1_0_0 - 0.00311260755705204*G0_1_1_1_0_1 + 3.42044786489189e-05*G0_1_1_1_0_2 - 0.00311260755705204*G0_1_1_1_1_0 + 0.00311260755705199*G0_1_1_1_1_2 + 3.42044786489187e-05*G0_1_1_1_2_0 + 0.00311260755705199*G0_1_1_1_2_1 + 0.00136817914595693*G0_1_1_1_2_2 - 0.000615680615680617*G0_1_1_2_0_0 + 3.42044786489188e-05*G0_1_1_2_0_1 - 0.00167601945379722*G0_1_1_2_0_2 + 3.42044786489188e-05*G0_1_1_2_1_0 + 0.00311260755705199*G0_1_1_2_1_1 + 0.00136817914595692*G0_1_1_2_1_2 - 0.00167601945379722*G0_1_1_2_2_0 + 0.00136817914595692*G0_1_1_2_2_1 + 0.00933782267115589*G0_1_1_2_2_2;
    A[170] = -A[173] + 0.0138528138528141*G0_0_1_0_0_0 + 0.0107060018171129*G0_0_1_0_0_1 + 0.00253113142002033*G0_0_1_0_0_2 + 0.0107060018171129*G0_0_1_0_1_0 + 0.015494628827962*G0_0_1_0_1_1 - 0.00136817914595693*G0_0_1_0_1_2 + 0.00253113142002034*G0_0_1_0_2_0 - 0.00136817914595693*G0_0_1_0_2_1 + 0.00335203890759444*G0_0_1_0_2_2 + 0.0107060018171129*G0_0_1_1_0_0 + 0.015494628827962*G0_0_1_1_0_1 - 0.00136817914595693*G0_0_1_1_0_2 + 0.015494628827962*G0_0_1_1_1_0 - 0.0924547057880399*G0_0_1_1_1_1 + 0.000205226871893501*G0_0_1_1_1_2 - 0.00136817914595693*G0_0_1_1_2_0 + 0.000205226871893502*G0_0_1_1_2_1 - 0.00335203890759447*G0_0_1_1_2_2 + 0.00253113142002034*G0_0_1_2_0_0 - 0.00136817914595693*G0_0_1_2_0_1 + 0.00335203890759444*G0_0_1_2_0_2 - 0.00136817914595693*G0_0_1_2_1_0 + 0.000205226871893506*G0_0_1_2_1_1 - 0.00335203890759447*G0_0_1_2_1_2 + 0.00335203890759444*G0_0_1_2_2_0 - 0.00335203890759447*G0_0_1_2_2_1 - 0.00461760461760469*G0_1_1_0_0_0 - 0.00766180321735877*G0_1_1_0_0_1 - 0.00126556571001016*G0_1_1_0_0_2 - 0.00766180321735877*G0_1_1_0_1_0 - 0.0308182352626797*G0_1_1_0_1_1 + 0.000102613435946763*G0_1_1_0_1_2 - 0.00126556571001016*G0_1_1_0_2_0 + 0.000102613435946763*G0_1_1_0_2_1 - 0.00335203890759444*G0_1_1_0_2_2 - 0.00766180321735877*G0_1_1_1_0_0 - 0.0308182352626797*G0_1_1_1_0_1 + 0.000102613435946763*G0_1_1_1_0_2 - 0.0308182352626797*G0_1_1_1_1_0 - 0.250376783710117*G0_1_1_1_1_1 + 0.0102955480733258*G0_1_1_1_1_2 + 0.000102613435946763*G0_1_1_1_2_0 + 0.0102955480733258*G0_1_1_1_2_1 + 0.00540430762652984*G0_1_1_1_2_2 - 0.00126556571001016*G0_1_1_2_0_0 + 0.000102613435946763*G0_1_1_2_0_1 - 0.00335203890759444*G0_1_1_2_0_2 + 0.000102613435946763*G0_1_1_2_1_0 + 0.0102955480733258*G0_1_1_2_1_1 + 0.00540430762652984*G0_1_1_2_1_2 - 0.00335203890759444*G0_1_1_2_2_0 + 0.00540430762652984*G0_1_1_2_2_1 - 0.0020522687189354*G0_1_1_2_2_2;
    A[86] = A[170] - 0.00400192400192398*G0_0_1_0_0_0 - 0.00885895997007103*G0_0_1_0_0_1 - 0.000684089572978462*G0_0_1_0_0_2 - 0.00885895997007103*G0_0_1_0_1_0 - 0.0121425899203675*G0_0_1_0_1_1 + 0.000684089572978472*G0_0_1_0_1_2 - 0.000684089572978461*G0_0_1_0_2_0 + 0.000684089572978472*G0_0_1_0_2_1 - 0.00885895997007103*G0_0_1_1_0_0 - 0.0121425899203675*G0_0_1_1_0_1 + 0.000684089572978472*G0_0_1_1_0_2 - 0.0121425899203675*G0_0_1_1_1_0 + 0.0831168831168839*G0_0_1_1_1_1 - 0.00324942547164764*G0_0_1_1_1_2 + 0.000684089572978472*G0_0_1_1_2_0 - 0.00324942547164764*G0_0_1_1_2_1 + 0.000307840307840322*G0_0_1_1_2_2 - 0.000684089572978462*G0_0_1_2_0_0 + 0.000684089572978472*G0_0_1_2_0_1 + 0.000684089572978472*G0_0_1_2_1_0 - 0.00324942547164764*G0_0_1_2_1_1 + 0.000307840307840321*G0_0_1_2_1_2 + 0.000307840307840322*G0_0_1_2_2_1 - 0.00933782267115578*G0_0_1_2_2_2 + 0.00400192400192398*G0_1_0_0_0_0 + 0.00885895997007103*G0_1_0_0_0_1 + 0.000684089572978462*G0_1_0_0_0_2 + 0.00885895997007103*G0_1_0_0_1_0 + 0.0121425899203675*G0_1_0_0_1_1 - 0.000684089572978472*G0_1_0_0_1_2 + 0.000684089572978462*G0_1_0_0_2_0 - 0.000684089572978472*G0_1_0_0_2_1 + 0.00885895997007103*G0_1_0_1_0_0 + 0.0121425899203675*G0_1_0_1_0_1 - 0.000684089572978472*G0_1_0_1_0_2 + 0.0121425899203675*G0_1_0_1_1_0 - 0.0831168831168839*G0_1_0_1_1_1 + 0.00324942547164763*G0_1_0_1_1_2 - 0.000684089572978472*G0_1_0_1_2_0 + 0.00324942547164764*G0_1_0_1_2_1 - 0.000307840307840323*G0_1_0_1_2_2 + 0.000684089572978462*G0_1_0_2_0_0 - 0.000684089572978472*G0_1_0_2_0_1 - 0.000684089572978471*G0_1_0_2_1_0 + 0.00324942547164764*G0_1_0_2_1_1 - 0.000307840307840322*G0_1_0_2_1_2 - 0.000307840307840322*G0_1_0_2_2_1 + 0.00933782267115577*G0_1_0_2_2_2;
    A[50] = -A[170] + 0.00461760461760457*G0_0_0_0_0_0 + 0.00126556571001013*G0_0_0_0_0_1 + 0.00766180321735871*G0_0_0_0_0_2 + 0.00126556571001014*G0_0_0_0_1_0 + 0.00335203890759441*G0_0_0_0_1_1 - 0.000102613435946775*G0_0_0_0_1_2 + 0.00766180321735871*G0_0_0_0_2_0 - 0.000102613435946775*G0_0_0_0_2_1 + 0.0308182352626795*G0_0_0_0_2_2 + 0.00126556571001013*G0_0_0_1_0_0 + 0.00335203890759441*G0_0_0_1_0_1 - 0.000102613435946775*G0_0_0_1_0_2 + 0.00335203890759441*G0_0_0_1_1_0 + 0.00205226871893545*G0_0_0_1_1_1 - 0.00540430762652981*G0_0_0_1_1_2 - 0.000102613435946775*G0_0_0_1_2_0 - 0.00540430762652981*G0_0_0_1_2_1 - 0.0102955480733258*G0_0_0_1_2_2 + 0.00766180321735871*G0_0_0_2_0_0 - 0.000102613435946775*G0_0_0_2_0_1 + 0.0308182352626795*G0_0_0_2_0_2 - 0.000102613435946775*G0_0_0_2_1_0 - 0.00540430762652981*G0_0_0_2_1_1 - 0.0102955480733258*G0_0_0_2_1_2 + 0.0308182352626795*G0_0_0_2_2_0 - 0.0102955480733258*G0_0_0_2_2_1 + 0.250376783710115*G0_0_0_2_2_2 + 0.00379669713003047*G0_0_1_0_0_0 + 0.00670407781518889*G0_0_1_0_0_1 - 0.00147079258190367*G0_0_1_0_0_2 + 0.00670407781518888*G0_0_1_0_1_0 + 0.00205226871893528*G0_0_1_0_1_1 - 0.0087563465341243*G0_0_1_0_1_2 - 0.00147079258190367*G0_0_1_0_2_0 - 0.0087563465341243*G0_0_1_0_2_1 - 0.0100903212014323*G0_0_1_0_2_2 + 0.00670407781518888*G0_0_1_1_0_0 + 0.00205226871893528*G0_0_1_1_0_1 - 0.0087563465341243*G0_0_1_1_0_2 + 0.00205226871893528*G0_0_1_1_1_0 - 0.166233766233767*G0_0_1_1_1_1 - 0.0389931056597723*G0_0_1_1_1_2 - 0.0087563465341243*G0_0_1_1_2_0 - 0.0389931056597723*G0_0_1_1_2_1 - 0.0425503714392602*G0_0_1_1_2_2 - 0.00147079258190367*G0_0_1_2_0_0 - 0.0087563465341243*G0_0_1_2_0_1 - 0.0100903212014323*G0_0_1_2_0_2 - 0.0087563465341243*G0_0_1_2_1_0 - 0.0389931056597723*G0_0_1_2_1_1 - 0.0425503714392602*G0_0_1_2_1_2 - 0.0100903212014323*G0_0_1_2_2_0 - 0.0425503714392602*G0_0_1_2_2_1 - 0.073779060445727*G0_0_1_2_2_2;
    A[78] = -A[86] + 0.00461760461760457*G0_0_0_0_0_0 + 0.00126556571001013*G0_0_0_0_0_1 + 0.00766180321735871*G0_0_0_0_0_2 + 0.00126556571001014*G0_0_0_0_1_0 + 0.00335203890759441*G0_0_0_0_1_1 - 0.000102613435946775*G0_0_0_0_1_2 + 0.00766180321735871*G0_0_0_0_2_0 - 0.000102613435946775*G0_0_0_0_2_1 + 0.0308182352626795*G0_0_0_0_2_2 + 0.00126556571001014*G0_0_0_1_0_0 + 0.00335203890759441*G0_0_0_1_0_1 - 0.000102613435946775*G0_0_0_1_0_2 + 0.00335203890759441*G0_0_0_1_1_0 + 0.00205226871893545*G0_0_0_1_1_1 - 0.00540430762652981*G0_0_0_1_1_2 - 0.000102613435946775*G0_0_0_1_2_0 - 0.00540430762652981*G0_0_0_1_2_1 - 0.0102955480733258*G0_0_0_1_2_2 + 0.00766180321735871*G0_0_0_2_0_0 - 0.000102613435946775*G0_0_0_2_0_1 + 0.0308182352626795*G0_0_0_2_0_2 - 0.000102613435946775*G0_0_0_2_1_0 - 0.00540430762652981*G0_0_0_2_1_1 - 0.0102955480733258*G0_0_0_2_1_2 + 0.0308182352626795*G0_0_0_2_2_0 - 0.0102955480733258*G0_0_0_2_2_1 + 0.250376783710115*G0_0_0_2_2_2 + 0.00379669713003047*G0_1_0_0_0_0 + 0.00670407781518889*G0_1_0_0_0_1 - 0.00147079258190367*G0_1_0_0_0_2 + 0.00670407781518888*G0_1_0_0_1_0 + 0.00205226871893528*G0_1_0_0_1_1 - 0.0087563465341243*G0_1_0_0_1_2 - 0.00147079258190367*G0_1_0_0_2_0 - 0.0087563465341243*G0_1_0_0_2_1 - 0.0100903212014323*G0_1_0_0_2_2 + 0.00670407781518888*G0_1_0_1_0_0 + 0.00205226871893528*G0_1_0_1_0_1 - 0.0087563465341243*G0_1_0_1_0_2 + 0.00205226871893528*G0_1_0_1_1_0 - 0.166233766233767*G0_1_0_1_1_1 - 0.0389931056597723*G0_1_0_1_1_2 - 0.0087563465341243*G0_1_0_1_2_0 - 0.0389931056597723*G0_1_0_1_2_1 - 0.0425503714392602*G0_1_0_1_2_2 - 0.00147079258190367*G0_1_0_2_0_0 - 0.0087563465341243*G0_1_0_2_0_1 - 0.0100903212014323*G0_1_0_2_0_2 - 0.0087563465341243*G0_1_0_2_1_0 - 0.0389931056597723*G0_1_0_2_1_1 - 0.0425503714392602*G0_1_0_2_1_2 - 0.0100903212014323*G0_1_0_2_2_0 - 0.0425503714392602*G0_1_0_2_2_1 - 0.073779060445727*G0_1_0_2_2_2;
    A[138] = -A[78] + 0.0368382235048901*G0_0_0_0_0_0 + 0.00796964352519906*G0_0_0_0_0_1 + 0.0138870183314627*G0_0_0_0_0_2 + 0.00796964352519906*G0_0_0_0_1_0 + 0.0103297525519747*G0_0_0_0_1_1 + 0.00201806424028645*G0_0_0_0_1_2 + 0.0138870183314627*G0_0_0_0_2_0 + 0.00201806424028645*G0_0_0_0_2_1 + 0.0292448292448291*G0_0_0_0_2_2 + 0.00796964352519906*G0_0_0_1_0_0 + 0.0103297525519747*G0_0_0_1_0_1 + 0.00201806424028645*G0_0_0_1_0_2 + 0.0103297525519747*G0_0_0_1_1_0 - 0.109796376463042*G0_0_0_1_1_1 - 0.0359831115386669*G0_0_0_1_1_2 + 0.00201806424028645*G0_0_0_1_2_0 - 0.0359831115386669*G0_0_0_1_2_1 - 0.0202148468815135*G0_0_0_1_2_2 + 0.0138870183314627*G0_0_0_2_0_0 + 0.00201806424028645*G0_0_0_2_0_1 + 0.0292448292448291*G0_0_0_2_0_2 + 0.00201806424028645*G0_0_0_2_1_0 - 0.0359831115386669*G0_0_0_2_1_1 - 0.0202148468815135*G0_0_0_2_1_2 + 0.0292448292448291*G0_0_0_2_2_0 - 0.0202148468815135*G0_0_0_2_2_1 + 0.24832451499118*G0_0_0_2_2_2 + 0.0171364438031106*G0_0_1_0_0_0 + 0.00779862113195443*G0_0_1_0_0_1 + 0.00215488215488216*G0_0_1_0_0_2 + 0.00779862113195444*G0_0_1_0_1_0 + 0.0133397466730799*G0_0_1_0_1_1 + 0.00143658810325476*G0_0_1_0_1_2 + 0.00215488215488216*G0_0_1_0_2_0 + 0.00143658810325476*G0_0_1_0_2_1 + 0.0031810165143498*G0_0_1_0_2_2 + 0.00779862113195444*G0_0_1_1_0_0 + 0.0133397466730799*G0_0_1_1_0_1 + 0.00143658810325476*G0_0_1_1_0_2 + 0.0133397466730799*G0_0_1_1_1_0 - 0.194965528298861*G0_0_1_1_1_1 - 0.0215488215488215*G0_0_1_1_1_2 + 0.00143658810325476*G0_0_1_1_2_0 - 0.0215488215488215*G0_0_1_1_2_1 - 0.00246272246272249*G0_0_1_1_2_2 + 0.00215488215488216*G0_0_1_2_0_0 + 0.00143658810325476*G0_0_1_2_0_1 + 0.0031810165143498*G0_0_1_2_0_2 + 0.00143658810325476*G0_0_1_2_1_0 - 0.0215488215488215*G0_0_1_2_1_1 - 0.00246272246272249*G0_0_1_2_1_2 + 0.0031810165143498*G0_0_1_2_2_0 - 0.00246272246272249*G0_0_1_2_2_1 + 0.026371653038319*G0_0_1_2_2_2 + 0.00759339426006091*G0_1_0_0_0_0 + 0.00595157928491259*G0_1_0_0_0_1 + 0.00595157928491259*G0_1_0_0_1_0 - 0.00595157928491261*G0_1_0_0_1_2 - 0.00595157928491261*G0_1_0_0_2_1 - 0.00759339426006091*G0_1_0_0_2_2 + 0.00595157928491259*G0_1_0_1_0_0 - 0.00595157928491261*G0_1_0_1_0_2 - 0.194965528298861*G0_1_0_1_1_1 - 0.075933942600609*G0_1_0_1_1_2 - 0.00595157928491261*G0_1_0_1_2_0 - 0.075933942600609*G0_1_0_1_2_1 - 0.0535642135642134*G0_1_0_1_2_2 - 0.00595157928491261*G0_1_0_2_0_1 - 0.00759339426006091*G0_1_0_2_0_2 - 0.00595157928491261*G0_1_0_2_1_0 - 0.075933942600609*G0_1_0_2_1_1 - 0.0535642135642134*G0_1_0_2_1_2 - 0.00759339426006091*G0_1_0_2_2_0 - 0.0535642135642134*G0_1_0_2_2_1 - 0.0607471540804872*G0_1_0_2_2_2 - 0.00923520923520925*G0_1_1_0_0_0 + 0.0102613435946769*G0_1_1_0_0_1 - 0.00102613435946769*G0_1_1_0_0_2 + 0.0102613435946769*G0_1_1_0_1_0 + 0.0348885682219014*G0_1_1_0_1_1 - 0.00102613435946769*G0_1_1_0_2_0 + 0.00102613435946767*G0_1_1_0_2_2 + 0.0102613435946769*G0_1_1_1_0_0 + 0.0348885682219014*G0_1_1_1_0_1 + 0.0348885682219014*G0_1_1_1_1_0 - 0.0348885682219014*G0_1_1_1_1_2 - 0.0348885682219014*G0_1_1_1_2_1 - 0.0102613435946769*G0_1_1_1_2_2 - 0.00102613435946769*G0_1_1_2_0_0 + 0.00102613435946767*G0_1_1_2_0_2 - 0.0348885682219014*G0_1_1_2_1_1 - 0.0102613435946769*G0_1_1_2_1_2 + 0.00102613435946767*G0_1_1_2_2_0 - 0.0102613435946769*G0_1_1_2_2_1 + 0.00923520923520895*G0_1_1_2_2_2;
    A[146] = -A[138] + 0.324155844155843*G0_0_0_0_0_0 + 0.0322548233659344*G0_0_0_0_0_1 + 0.0409085564641118*G0_0_0_0_0_2 + 0.0322548233659344*G0_0_0_0_1_0 + 0.0335887980332424*G0_0_0_0_1_1 + 0.00865373309817751*G0_0_0_0_1_2 + 0.0409085564641118*G0_0_0_0_2_0 + 0.00865373309817751*G0_0_0_0_2_1 + 0.0091325957992624*G0_0_0_0_2_2 + 0.0322548233659344*G0_0_0_1_0_0 + 0.0335887980332424*G0_0_0_1_0_1 + 0.00865373309817751*G0_0_0_1_0_2 + 0.0335887980332424*G0_0_0_1_1_0 + 0.168286034952701*G0_0_0_1_1_1 + 0.00129977018865908*G0_0_0_1_1_2 + 0.00865373309817751*G0_0_0_1_2_0 + 0.00129977018865908*G0_0_0_1_2_1 - 0.00543851210517876*G0_0_0_1_2_2 + 0.0409085564641118*G0_0_0_2_0_0 + 0.00865373309817751*G0_0_0_2_0_1 + 0.0091325957992624*G0_0_0_2_0_2 + 0.00865373309817751*G0_0_0_2_1_0 + 0.00129977018865907*G0_0_0_2_1_1 - 0.00543851210517875*G0_0_0_2_1_2 + 0.0091325957992624*G0_0_0_2_2_0 - 0.00543851210517875*G0_0_0_2_2_1 + 0.000820907487574179*G0_0_0_2_2_2 + 0.0737790604457267*G0_1_0_0_0_0 + 0.0425503714392601*G0_1_0_0_0_1 + 0.0100903212014323*G0_1_0_0_0_2 + 0.0425503714392601*G0_1_0_0_1_0 + 0.0389931056597721*G0_1_0_0_1_1 + 0.00875634653412427*G0_1_0_0_1_2 + 0.0100903212014323*G0_1_0_0_2_0 + 0.00875634653412428*G0_1_0_0_2_1 + 0.0014707925819037*G0_1_0_0_2_2 + 0.0425503714392601*G0_1_0_1_0_0 + 0.0389931056597721*G0_1_0_1_0_1 + 0.00875634653412427*G0_1_0_1_0_2 + 0.0389931056597721*G0_1_0_1_1_0 + 0.166233766233765*G0_1_0_1_1_1 - 0.00205226871893543*G0_1_0_1_1_2 + 0.00875634653412427*G0_1_0_1_2_0 - 0.00205226871893542*G0_1_0_1_2_1 - 0.00670407781518891*G0_1_0_1_2_2 + 0.0100903212014323*G0_1_0_2_0_0 + 0.00875634653412427*G0_1_0_2_0_1 + 0.0014707925819037*G0_1_0_2_0_2 + 0.00875634653412427*G0_1_0_2_1_0 - 0.00205226871893542*G0_1_0_2_1_1 - 0.00670407781518891*G0_1_0_2_1_2 + 0.0014707925819037*G0_1_0_2_2_0 - 0.00670407781518891*G0_1_0_2_2_1 - 0.00379669713003035*G0_1_0_2_2_2;
    A[126] = A[146] - 0.278082411415744*G0_0_0_0_0_0 - 0.0232590454812676*G0_0_0_0_0_1 - 0.037282881727326*G0_0_0_0_0_2 - 0.0232590454812676*G0_0_0_0_1_0 - 0.0242851798407353*G0_0_0_0_1_1 - 0.00663566885789105*G0_0_0_0_1_2 - 0.037282881727326*G0_0_0_0_2_0 - 0.00663566885789105*G0_0_0_0_2_1 - 0.0147763347763348*G0_0_0_0_2_2 - 0.0232590454812676*G0_0_0_1_0_0 - 0.0242851798407353*G0_0_0_1_0_1 - 0.00663566885789105*G0_0_0_1_0_2 - 0.0242851798407353*G0_0_0_1_1_0 - 0.287317620650953*G0_0_0_1_1_1 - 0.0270215381326491*G0_0_0_1_1_2 - 0.00663566885789106*G0_0_0_1_2_0 - 0.0270215381326491*G0_0_0_1_2_1 + 0.0201122334455666*G0_0_0_1_2_2 - 0.037282881727326*G0_0_0_2_0_0 - 0.00663566885789105*G0_0_0_2_0_1 - 0.0147763347763348*G0_0_0_2_0_2 - 0.00663566885789105*G0_0_0_2_1_0 - 0.0270215381326491*G0_0_0_2_1_1 + 0.0201122334455666*G0_0_0_2_1_2 - 0.0147763347763348*G0_0_0_2_2_0 + 0.0201122334455666*G0_0_0_2_2_1 + 0.247503607503605*G0_0_0_2_2_2 + 0.00564373897707232*G0_0_1_0_0_1 - 0.00564373897707227*G0_0_1_0_0_2 + 0.00564373897707232*G0_0_1_0_1_0 + 0.0101587301587301*G0_0_1_0_1_1 - 0.00564373897707227*G0_0_1_0_2_0 - 0.0101587301587301*G0_0_1_0_2_2 + 0.00564373897707232*G0_0_1_1_0_0 + 0.0101587301587301*G0_0_1_1_0_1 + 0.0101587301587301*G0_0_1_1_1_0 - 0.22133718133718*G0_0_1_1_1_1 - 0.019086099086099*G0_0_1_1_1_2 - 0.019086099086099*G0_0_1_1_2_1 + 0.019086099086099*G0_0_1_1_2_2 - 0.00564373897707227*G0_0_1_2_0_0 - 0.0101587301587301*G0_0_1_2_0_2 - 0.019086099086099*G0_0_1_2_1_1 + 0.019086099086099*G0_0_1_2_1_2 - 0.0101587301587301*G0_0_1_2_2_0 + 0.019086099086099*G0_0_1_2_2_1 + 0.22133718133718*G0_0_1_2_2_2 - 0.0265084709529152*G0_1_0_0_0_1 + 0.0265084709529153*G0_1_0_0_0_2 - 0.0265084709529152*G0_1_0_0_1_0 - 0.0299289188178075*G0_1_0_0_1_1 + 0.0265084709529153*G0_1_0_0_2_0 + 0.0299289188178076*G0_1_0_0_2_2 - 0.0265084709529152*G0_1_0_1_0_0 - 0.0299289188178075*G0_1_0_1_0_1 - 0.0299289188178075*G0_1_0_1_1_0 - 0.304248837582169*G0_1_0_1_1_1 - 0.027021538132649*G0_1_0_1_1_2 - 0.027021538132649*G0_1_0_1_2_1 + 0.0270215381326491*G0_1_0_1_2_2 + 0.0265084709529153*G0_1_0_2_0_0 + 0.0299289188178076*G0_1_0_2_0_2 - 0.027021538132649*G0_1_0_2_1_1 + 0.0270215381326491*G0_1_0_2_1_2 + 0.0299289188178076*G0_1_0_2_2_0 + 0.0270215381326491*G0_1_0_2_2_1 + 0.304248837582169*G0_1_0_2_2_2 + 0.278082411415744*G0_1_1_0_0_0 + 0.037282881727326*G0_1_1_0_0_1 + 0.0232590454812676*G0_1_1_0_0_2 + 0.037282881727326*G0_1_1_0_1_0 + 0.0147763347763347*G0_1_1_0_1_1 + 0.00663566885789106*G0_1_1_0_1_2 + 0.0232590454812676*G0_1_1_0_2_0 + 0.00663566885789106*G0_1_1_0_2_1 + 0.0242851798407353*G0_1_1_0_2_2 + 0.037282881727326*G0_1_1_1_0_0 + 0.0147763347763347*G0_1_1_1_0_1 + 0.00663566885789106*G0_1_1_1_0_2 + 0.0147763347763347*G0_1_1_1_1_0 - 0.247503607503606*G0_1_1_1_1_1 - 0.0201122334455666*G0_1_1_1_1_2 + 0.00663566885789106*G0_1_1_1_2_0 - 0.0201122334455666*G0_1_1_1_2_1 + 0.0270215381326491*G0_1_1_1_2_2 + 0.0232590454812676*G0_1_1_2_0_0 + 0.00663566885789106*G0_1_1_2_0_1 + 0.0242851798407353*G0_1_1_2_0_2 + 0.00663566885789106*G0_1_1_2_1_0 - 0.0201122334455666*G0_1_1_2_1_1 + 0.0270215381326491*G0_1_1_2_1_2 + 0.0242851798407353*G0_1_1_2_2_0 + 0.0270215381326491*G0_1_1_2_2_1 + 0.287317620650953*G0_1_1_2_2_2;
    A[54] = A[138] - 0.00933782267115614*G0_0_1_0_0_0 + 0.000307840307840299*G0_0_1_0_0_1 + 0.000307840307840296*G0_0_1_0_1_0 - 0.00324942547164766*G0_0_1_0_1_1 + 0.00068408957297846*G0_0_1_0_1_2 + 0.00068408957297846*G0_0_1_0_2_1 - 0.000684089572978449*G0_0_1_0_2_2 + 0.000307840307840296*G0_0_1_1_0_0 - 0.00324942547164766*G0_0_1_1_0_1 + 0.000684089572978461*G0_0_1_1_0_2 - 0.00324942547164766*G0_0_1_1_1_0 + 0.0831168831168832*G0_0_1_1_1_1 - 0.0121425899203676*G0_0_1_1_1_2 + 0.00068408957297846*G0_0_1_1_2_0 - 0.0121425899203676*G0_0_1_1_2_1 - 0.00885895997007104*G0_0_1_1_2_2 + 0.00068408957297846*G0_0_1_2_0_1 - 0.000684089572978449*G0_0_1_2_0_2 + 0.000684089572978461*G0_0_1_2_1_0 - 0.0121425899203676*G0_0_1_2_1_1 - 0.00885895997007104*G0_0_1_2_1_2 - 0.000684089572978449*G0_0_1_2_2_0 - 0.00885895997007104*G0_0_1_2_2_1 - 0.00400192400192389*G0_0_1_2_2_2 + 0.00933782267115614*G0_1_0_0_0_0 - 0.000307840307840299*G0_1_0_0_0_1 - 0.000307840307840294*G0_1_0_0_1_0 + 0.00324942547164766*G0_1_0_0_1_1 - 0.000684089572978461*G0_1_0_0_1_2 - 0.000684089572978461*G0_1_0_0_2_1 + 0.000684089572978449*G0_1_0_0_2_2 - 0.000307840307840296*G0_1_0_1_0_0 + 0.00324942547164766*G0_1_0_1_0_1 - 0.000684089572978461*G0_1_0_1_0_2 + 0.00324942547164767*G0_1_0_1_1_0 - 0.0831168831168833*G0_1_0_1_1_1 + 0.0121425899203676*G0_1_0_1_1_2 - 0.000684089572978461*G0_1_0_1_2_0 + 0.0121425899203676*G0_1_0_1_2_1 + 0.00885895997007104*G0_1_0_1_2_2 - 0.000684089572978461*G0_1_0_2_0_1 + 0.00068408957297845*G0_1_0_2_0_2 - 0.000684089572978461*G0_1_0_2_1_0 + 0.0121425899203676*G0_1_0_2_1_1 + 0.00885895997007104*G0_1_0_2_1_2 + 0.000684089572978449*G0_1_0_2_2_0 + 0.00885895997007104*G0_1_0_2_2_1 + 0.00400192400192389*G0_1_0_2_2_2;
    A[174] = -A[54] + 0.324155844155843*G0_0_0_0_0_0 + 0.0322548233659344*G0_0_0_0_0_1 + 0.0409085564641118*G0_0_0_0_0_2 + 0.0322548233659344*G0_0_0_0_1_0 + 0.0335887980332424*G0_0_0_0_1_1 + 0.00865373309817751*G0_0_0_0_1_2 + 0.0409085564641118*G0_0_0_0_2_0 + 0.00865373309817751*G0_0_0_0_2_1 + 0.0091325957992624*G0_0_0_0_2_2 + 0.0322548233659344*G0_0_0_1_0_0 + 0.0335887980332424*G0_0_0_1_0_1 + 0.00865373309817751*G0_0_0_1_0_2 + 0.0335887980332424*G0_0_0_1_1_0 + 0.168286034952701*G0_0_0_1_1_1 + 0.00129977018865907*G0_0_0_1_1_2 + 0.00865373309817751*G0_0_0_1_2_0 + 0.00129977018865908*G0_0_0_1_2_1 - 0.00543851210517875*G0_0_0_1_2_2 + 0.0409085564641118*G0_0_0_2_0_0 + 0.00865373309817751*G0_0_0_2_0_1 + 0.0091325957992624*G0_0_0_2_0_2 + 0.00865373309817751*G0_0_0_2_1_0 + 0.00129977018865908*G0_0_0_2_1_1 - 0.00543851210517876*G0_0_0_2_1_2 + 0.0091325957992624*G0_0_0_2_2_0 - 0.00543851210517875*G0_0_0_2_2_1 + 0.000820907487574181*G0_0_0_2_2_2 + 0.0737790604457267*G0_0_1_0_0_0 + 0.0425503714392601*G0_0_1_0_0_1 + 0.0100903212014323*G0_0_1_0_0_2 + 0.0425503714392601*G0_0_1_0_1_0 + 0.0389931056597721*G0_0_1_0_1_1 + 0.00875634653412427*G0_0_1_0_1_2 + 0.0100903212014323*G0_0_1_0_2_0 + 0.00875634653412428*G0_0_1_0_2_1 + 0.0014707925819037*G0_0_1_0_2_2 + 0.0425503714392601*G0_0_1_1_0_0 + 0.0389931056597721*G0_0_1_1_0_1 + 0.00875634653412427*G0_0_1_1_0_2 + 0.0389931056597721*G0_0_1_1_1_0 + 0.166233766233765*G0_0_1_1_1_1 - 0.00205226871893542*G0_0_1_1_1_2 + 0.00875634653412427*G0_0_1_1_2_0 - 0.00205226871893542*G0_0_1_1_2_1 - 0.00670407781518891*G0_0_1_1_2_2 + 0.0100903212014323*G0_0_1_2_0_0 + 0.00875634653412427*G0_0_1_2_0_1 + 0.0014707925819037*G0_0_1_2_0_2 + 0.00875634653412427*G0_0_1_2_1_0 - 0.00205226871893542*G0_0_1_2_1_1 - 0.00670407781518891*G0_0_1_2_1_2 + 0.0014707925819037*G0_0_1_2_2_0 - 0.00670407781518891*G0_0_1_2_2_1 - 0.00379669713003035*G0_0_1_2_2_2;
    A[98] = A[126] + 0.083116883116883*G0_0_1_0_0_0 + 0.0100903212014323*G0_0_1_0_0_1 + 0.0422425311314199*G0_0_1_0_0_2 + 0.0100903212014323*G0_0_1_0_1_0 + 0.00215488215488217*G0_0_1_0_1_1 + 0.00807225696114583*G0_0_1_0_1_2 + 0.0422425311314199*G0_0_1_0_2_0 + 0.00807225696114583*G0_0_1_0_2_1 + 0.0422425311314199*G0_0_1_0_2_2 + 0.0100903212014323*G0_0_1_1_0_0 + 0.00215488215488217*G0_0_1_1_0_1 + 0.00807225696114583*G0_0_1_1_0_2 + 0.00215488215488217*G0_0_1_1_1_0 + 0.000205226871893597*G0_0_1_1_1_1 + 0.00215488215488217*G0_0_1_1_1_2 + 0.00807225696114583*G0_0_1_1_2_0 + 0.00215488215488217*G0_0_1_1_2_1 + 0.0100903212014323*G0_0_1_1_2_2 + 0.0422425311314199*G0_0_1_2_0_0 + 0.00807225696114583*G0_0_1_2_0_1 + 0.0422425311314199*G0_0_1_2_0_2 + 0.00807225696114583*G0_0_1_2_1_0 + 0.00215488215488217*G0_0_1_2_1_1 + 0.0100903212014323*G0_0_1_2_1_2 + 0.0422425311314199*G0_0_1_2_2_0 + 0.0100903212014323*G0_0_1_2_2_1 + 0.0831168831168823*G0_0_1_2_2_2 - 0.083116883116883*G0_1_0_0_0_0 - 0.0100903212014323*G0_1_0_0_0_1 - 0.0422425311314199*G0_1_0_0_0_2 - 0.0100903212014323*G0_1_0_0_1_0 - 0.00215488215488217*G0_1_0_0_1_1 - 0.00807225696114583*G0_1_0_0_1_2 - 0.0422425311314199*G0_1_0_0_2_0 - 0.00807225696114583*G0_1_0_0_2_1 - 0.0422425311314199*G0_1_0_0_2_2 - 0.0100903212014323*G0_1_0_1_0_0 - 0.00215488215488218*G0_1_0_1_0_1 - 0.00807225696114583*G0_1_0_1_0_2 - 0.00215488215488217*G0_1_0_1_1_0 - 0.000205226871893598*G0_1_0_1_1_1 - 0.00215488215488217*G0_1_0_1_1_2 - 0.00807225696114583*G0_1_0_1_2_0 - 0.00215488215488217*G0_1_0_1_2_1 - 0.0100903212014323*G0_1_0_1_2_2 - 0.0422425311314199*G0_1_0_2_0_0 - 0.00807225696114583*G0_1_0_2_0_1 - 0.0422425311314199*G0_1_0_2_0_2 - 0.00807225696114583*G0_1_0_2_1_0 - 0.00215488215488217*G0_1_0_2_1_1 - 0.0100903212014323*G0_1_0_2_1_2 - 0.0422425311314199*G0_1_0_2_2_0 - 0.0100903212014323*G0_1_0_2_2_1 - 0.0831168831168823*G0_1_0_2_2_2;
    A[95] = -A[98] + 0.0737790604457271*G0_0_1_0_0_0 + 0.0100903212014324*G0_0_1_0_0_1 + 0.0425503714392602*G0_0_1_0_0_2 + 0.0100903212014324*G0_0_1_0_1_0 + 0.00147079258190377*G0_0_1_0_1_1 + 0.0087563465341243*G0_0_1_0_1_2 + 0.0425503714392602*G0_0_1_0_2_0 + 0.0087563465341243*G0_0_1_0_2_1 + 0.0389931056597722*G0_0_1_0_2_2 + 0.0100903212014324*G0_0_1_1_0_0 + 0.00147079258190377*G0_0_1_1_0_1 + 0.00875634653412429*G0_0_1_1_0_2 + 0.00147079258190377*G0_0_1_1_1_0 - 0.00379669713003014*G0_0_1_1_1_1 - 0.00670407781518883*G0_0_1_1_1_2 + 0.0087563465341243*G0_0_1_1_2_0 - 0.00670407781518883*G0_0_1_1_2_1 - 0.00205226871893533*G0_0_1_1_2_2 + 0.0425503714392602*G0_0_1_2_0_0 + 0.00875634653412429*G0_0_1_2_0_1 + 0.0389931056597722*G0_0_1_2_0_2 + 0.0087563465341243*G0_0_1_2_1_0 - 0.00670407781518883*G0_0_1_2_1_1 - 0.00205226871893533*G0_0_1_2_1_2 + 0.0389931056597722*G0_0_1_2_2_0 - 0.00205226871893533*G0_0_1_2_2_1 + 0.166233766233765*G0_0_1_2_2_2 + 0.324155844155842*G0_1_1_0_0_0 + 0.0409085564641118*G0_1_1_0_0_1 + 0.0322548233659343*G0_1_1_0_0_2 + 0.0409085564641118*G0_1_1_0_1_0 + 0.00913259579926246*G0_1_1_0_1_1 + 0.00865373309817752*G0_1_1_0_1_2 + 0.0322548233659343*G0_1_1_0_2_0 + 0.00865373309817752*G0_1_1_0_2_1 + 0.0335887980332424*G0_1_1_0_2_2 + 0.0409085564641118*G0_1_1_1_0_0 + 0.00913259579926246*G0_1_1_1_0_1 + 0.00865373309817752*G0_1_1_1_0_2 + 0.00913259579926246*G0_1_1_1_1_0 + 0.000820907487574334*G0_1_1_1_1_1 - 0.00543851210517868*G0_1_1_1_1_2 + 0.00865373309817752*G0_1_1_1_2_0 - 0.00543851210517868*G0_1_1_1_2_1 + 0.00129977018865918*G0_1_1_1_2_2 + 0.0322548233659343*G0_1_1_2_0_0 + 0.00865373309817752*G0_1_1_2_0_1 + 0.0335887980332424*G0_1_1_2_0_2 + 0.00865373309817752*G0_1_1_2_1_0 - 0.00543851210517869*G0_1_1_2_1_1 + 0.00129977018865918*G0_1_1_2_1_2 + 0.0335887980332424*G0_1_1_2_2_0 + 0.00129977018865918*G0_1_1_2_2_1 + 0.168286034952701*G0_1_1_2_2_2;
    A[217] = A[119] + 0.0688023088023093*G0_0_1_0_0_0 + 0.0173160173160173*G0_0_1_0_0_1 - 0.00484848484848495*G0_0_1_0_0_2 + 0.0173160173160173*G0_0_1_0_1_0 + 0.0116209716209716*G0_0_1_0_1_1 + 0.00831168831168827*G0_0_1_0_1_2 - 0.00484848484848495*G0_0_1_0_2_0 + 0.00831168831168827*G0_0_1_0_2_1 - 0.0711880711880712*G0_0_1_0_2_2 + 0.0173160173160173*G0_0_1_1_0_0 + 0.0116209716209716*G0_0_1_1_0_1 + 0.00831168831168827*G0_0_1_1_0_2 + 0.0116209716209716*G0_0_1_1_1_0 + 0.0175468975468973*G0_0_1_1_1_1 + 0.0182395382395382*G0_0_1_1_1_2 + 0.00831168831168826*G0_0_1_1_2_0 + 0.0182395382395382*G0_0_1_1_2_1 + 0.0242424242424241*G0_0_1_1_2_2 - 0.00484848484848494*G0_0_1_2_0_0 + 0.00831168831168827*G0_0_1_2_0_1 - 0.0711880711880712*G0_0_1_2_0_2 + 0.00831168831168826*G0_0_1_2_1_0 + 0.0182395382395382*G0_0_1_2_1_1 + 0.0242424242424241*G0_0_1_2_1_2 - 0.0711880711880712*G0_0_1_2_2_0 + 0.0242424242424241*G0_0_1_2_2_1 - 0.122366522366523*G0_0_1_2_2_2 - 0.0688023088023093*G0_1_0_0_0_0 - 0.0173160173160173*G0_1_0_0_0_1 + 0.00484848484848494*G0_1_0_0_0_2 - 0.0173160173160173*G0_1_0_0_1_0 - 0.0116209716209716*G0_1_0_0_1_1 - 0.00831168831168827*G0_1_0_0_1_2 + 0.00484848484848492*G0_1_0_0_2_0 - 0.00831168831168827*G0_1_0_0_2_1 + 0.0711880711880712*G0_1_0_0_2_2 - 0.0173160173160173*G0_1_0_1_0_0 - 0.0116209716209716*G0_1_0_1_0_1 - 0.00831168831168827*G0_1_0_1_0_2 - 0.0116209716209716*G0_1_0_1_1_0 - 0.0175468975468973*G0_1_0_1_1_1 - 0.0182395382395382*G0_1_0_1_1_2 - 0.00831168831168827*G0_1_0_1_2_0 - 0.0182395382395382*G0_1_0_1_2_1 - 0.0242424242424241*G0_1_0_1_2_2 + 0.00484848484848494*G0_1_0_2_0_0 - 0.00831168831168827*G0_1_0_2_0_1 + 0.0711880711880712*G0_1_0_2_0_2 - 0.00831168831168827*G0_1_0_2_1_0 - 0.0182395382395382*G0_1_0_2_1_1 - 0.0242424242424241*G0_1_0_2_1_2 + 0.0711880711880712*G0_1_0_2_2_0 - 0.0242424242424241*G0_1_0_2_2_1 + 0.122366522366523*G0_1_0_2_2_2;
    A[22] = A[106] - 0.00237614237614217*G0_0_1_0_0_0 - 0.000314253647586967*G0_0_1_0_0_1 - 0.00253006253006249*G0_0_1_0_0_2 - 0.000314253647586967*G0_0_1_0_1_0 + 0.000420073753407065*G0_0_1_0_1_1 - 0.00253006253006249*G0_0_1_0_2_0 + 0.00253006253006252*G0_0_1_0_2_2 - 0.000314253647586967*G0_0_1_1_0_0 + 0.000420073753407065*G0_0_1_1_0_1 + 0.000420073753407065*G0_0_1_1_1_0 - 0.000420073753407094*G0_0_1_1_1_2 - 0.000420073753407094*G0_0_1_1_2_1 + 0.000314253647586961*G0_0_1_1_2_2 - 0.00253006253006249*G0_0_1_2_0_0 + 0.00253006253006252*G0_0_1_2_0_2 - 0.000420073753407094*G0_0_1_2_1_1 + 0.000314253647586961*G0_0_1_2_1_2 + 0.00253006253006253*G0_0_1_2_2_0 + 0.000314253647586961*G0_0_1_2_2_1 + 0.00237614237614225*G0_0_1_2_2_2 + 0.00237614237614217*G0_1_0_0_0_0 + 0.000314253647586966*G0_1_0_0_0_1 + 0.00253006253006249*G0_1_0_0_0_2 + 0.000314253647586967*G0_1_0_0_1_0 - 0.000420073753407065*G0_1_0_0_1_1 + 0.00253006253006249*G0_1_0_0_2_0 - 0.00253006253006252*G0_1_0_0_2_2 + 0.000314253647586967*G0_1_0_1_0_0 - 0.000420073753407065*G0_1_0_1_0_1 - 0.000420073753407065*G0_1_0_1_1_0 + 0.000420073753407094*G0_1_0_1_1_2 + 0.000420073753407094*G0_1_0_1_2_1 - 0.000314253647586961*G0_1_0_1_2_2 + 0.00253006253006249*G0_1_0_2_0_0 - 0.00253006253006252*G0_1_0_2_0_2 + 0.000420073753407094*G0_1_0_2_1_1 - 0.000314253647586961*G0_1_0_2_1_2 - 0.00253006253006252*G0_1_0_2_2_0 - 0.000314253647586961*G0_1_0_2_2_1 - 0.00237614237614225*G0_1_0_2_2_2;
    A[9] = A[135] + 0.541029341029339*G0_0_1_0_0_0 + 0.0335417668751001*G0_0_1_0_0_1 + 0.0335417668751*G0_0_1_0_0_2 + 0.0335417668751001*G0_0_1_0_1_0 + 0.00397627064293729*G0_0_1_0_1_1 + 0.00198813532146864*G0_0_1_0_1_2 + 0.0335417668751*G0_0_1_0_2_0 + 0.00198813532146864*G0_0_1_0_2_1 + 0.00397627064293729*G0_0_1_0_2_2 + 0.0335417668751001*G0_0_1_1_0_0 + 0.00397627064293729*G0_0_1_1_0_1 + 0.00198813532146864*G0_0_1_1_0_2 + 0.00397627064293729*G0_0_1_1_1_0 + 0.000192400192400168*G0_0_1_1_1_1 + 0.00198813532146864*G0_0_1_1_2_0 + 0.0335417668751*G0_0_1_2_0_0 + 0.00198813532146864*G0_0_1_2_0_1 + 0.00397627064293729*G0_0_1_2_0_2 + 0.00198813532146864*G0_0_1_2_1_0 + 0.00397627064293729*G0_0_1_2_2_0 + 0.000192400192400168*G0_0_1_2_2_2 - 0.541029341029339*G0_1_0_0_0_0 - 0.0335417668751001*G0_1_0_0_0_1 - 0.0335417668751*G0_1_0_0_0_2 - 0.0335417668751001*G0_1_0_0_1_0 - 0.00397627064293729*G0_1_0_0_1_1 - 0.00198813532146864*G0_1_0_0_1_2 - 0.0335417668751*G0_1_0_0_2_0 - 0.00198813532146864*G0_1_0_0_2_1 - 0.00397627064293729*G0_1_0_0_2_2 - 0.0335417668751001*G0_1_0_1_0_0 - 0.00397627064293729*G0_1_0_1_0_1 - 0.00198813532146864*G0_1_0_1_0_2 - 0.00397627064293729*G0_1_0_1_1_0 - 0.000192400192400168*G0_1_0_1_1_1 - 0.00198813532146864*G0_1_0_1_2_0 - 0.0335417668751*G0_1_0_2_0_0 - 0.00198813532146864*G0_1_0_2_0_1 - 0.00397627064293729*G0_1_0_2_0_2 - 0.00198813532146864*G0_1_0_2_1_0 - 0.00397627064293729*G0_1_0_2_2_0 - 0.000192400192400168*G0_1_0_2_2_2;
    A[90] = A[9] + 0.541029341029339*G0_0_0_0_0_0 + 0.0256961145850034*G0_0_0_0_0_1 + 0.0413874191651967*G0_0_0_0_0_2 + 0.0256961145850034*G0_0_0_0_1_0 + 0.00547271658382766*G0_0_0_0_1_1 + 0.00198813532146864*G0_0_0_0_1_2 + 0.0413874191651967*G0_0_0_0_2_0 + 0.00198813532146864*G0_0_0_0_2_1 + 0.0024798247020469*G0_0_0_0_2_2 + 0.0256961145850034*G0_0_0_1_0_0 + 0.00547271658382766*G0_0_0_1_0_1 + 0.00198813532146864*G0_0_0_1_0_2 + 0.00547271658382766*G0_0_0_1_1_0 + 0.0267821067821066*G0_0_0_1_1_1 + 0.00301854524076744*G0_0_0_1_1_2 + 0.00198813532146864*G0_0_0_1_2_0 + 0.00301854524076744*G0_0_0_1_2_1 - 0.00289027844583399*G0_0_0_1_2_2 + 0.0413874191651967*G0_0_0_2_0_0 + 0.00198813532146864*G0_0_0_2_0_1 + 0.0024798247020469*G0_0_0_2_0_2 + 0.00198813532146864*G0_0_0_2_1_0 + 0.00301854524076744*G0_0_0_2_1_1 - 0.00289027844583399*G0_0_0_2_1_2 + 0.0024798247020469*G0_0_0_2_2_0 - 0.00289027844583399*G0_0_0_2_2_1 - 0.0263973063973062*G0_0_0_2_2_2 - 0.00784565229009673*G0_0_1_0_0_1 + 0.00784565229009665*G0_0_1_0_0_2 - 0.00784565229009673*G0_0_1_0_1_0 + 0.00149644594089037*G0_0_1_0_1_1 + 0.00784565229009665*G0_0_1_0_2_0 - 0.0014964459408904*G0_0_1_0_2_2 - 0.00784565229009673*G0_0_1_1_0_0 + 0.00149644594089037*G0_0_1_1_0_1 + 0.00149644594089037*G0_0_1_1_1_0 + 0.0265897065897064*G0_0_1_1_1_1 + 0.00295441184330072*G0_0_1_1_1_2 + 0.00295441184330072*G0_0_1_1_2_1 - 0.00295441184330072*G0_0_1_1_2_2 + 0.00784565229009665*G0_0_1_2_0_0 - 0.0014964459408904*G0_0_1_2_0_2 + 0.00295441184330072*G0_0_1_2_1_1 - 0.00295441184330071*G0_0_1_2_1_2 - 0.0014964459408904*G0_0_1_2_2_0 - 0.00295441184330071*G0_0_1_2_2_1 - 0.0265897065897065*G0_0_1_2_2_2 - 0.00784565229009668*G0_1_0_0_0_1 + 0.0078456522900967*G0_1_0_0_0_2 - 0.00784565229009668*G0_1_0_0_1_0 + 0.00149644594089037*G0_1_0_0_1_1 + 0.00784565229009669*G0_1_0_0_2_0 - 0.00149644594089039*G0_1_0_0_2_2 - 0.00784565229009668*G0_1_0_1_0_0 + 0.00149644594089037*G0_1_0_1_0_1 + 0.00149644594089037*G0_1_0_1_1_0 + 0.0265897065897064*G0_1_0_1_1_1 + 0.0029544118433007*G0_1_0_1_1_2 + 0.00295441184330071*G0_1_0_1_2_1 - 0.00295441184330072*G0_1_0_1_2_2 + 0.00784565229009669*G0_1_0_2_0_0 - 0.00149644594089039*G0_1_0_2_0_2 + 0.00295441184330071*G0_1_0_2_1_1 - 0.00295441184330072*G0_1_0_2_1_2 - 0.00149644594089039*G0_1_0_2_2_0 - 0.00295441184330072*G0_1_0_2_2_1 - 0.0265897065897065*G0_1_0_2_2_2 - 0.541029341029339*G0_1_1_0_0_0 - 0.0413874191651968*G0_1_1_0_0_1 - 0.0256961145850033*G0_1_1_0_0_2 - 0.0413874191651968*G0_1_1_0_1_0 - 0.00247982470204692*G0_1_1_0_1_1 - 0.00198813532146865*G0_1_1_0_1_2 - 0.0256961145850033*G0_1_1_0_2_0 - 0.00198813532146865*G0_1_1_0_2_1 - 0.00547271658382768*G0_1_1_0_2_2 - 0.0413874191651968*G0_1_1_1_0_0 - 0.00247982470204692*G0_1_1_1_0_1 - 0.00198813532146865*G0_1_1_1_0_2 - 0.00247982470204692*G0_1_1_1_1_0 + 0.0263973063973062*G0_1_1_1_1_1 + 0.00289027844583398*G0_1_1_1_1_2 - 0.00198813532146865*G0_1_1_1_2_0 + 0.00289027844583398*G0_1_1_1_2_1 - 0.00301854524076744*G0_1_1_1_2_2 - 0.0256961145850033*G0_1_1_2_0_0 - 0.00198813532146865*G0_1_1_2_0_1 - 0.00547271658382768*G0_1_1_2_0_2 - 0.00198813532146865*G0_1_1_2_1_0 + 0.00289027844583398*G0_1_1_2_1_1 - 0.00301854524076745*G0_1_1_2_1_2 - 0.00547271658382768*G0_1_1_2_2_0 - 0.00301854524076745*G0_1_1_2_2_1 - 0.0267821067821067*G0_1_1_2_2_2;
    A[6] = A[90] - 0.541029341029338*G0_0_1_0_0_0 - 0.0335417668751*G0_0_1_0_0_1 - 0.0335417668751*G0_0_1_0_0_2 - 0.0335417668751*G0_0_1_0_1_0 - 0.00397627064293729*G0_0_1_0_1_1 - 0.00198813532146864*G0_0_1_0_1_2 - 0.0335417668751*G0_0_1_0_2_0 - 0.00198813532146864*G0_0_1_0_2_1 - 0.00397627064293728*G0_0_1_0_2_2 - 0.0335417668751*G0_0_1_1_0_0 - 0.00397627064293729*G0_0_1_1_0_1 - 0.00198813532146864*G0_0_1_1_0_2 - 0.00397627064293729*G0_0_1_1_1_0 - 0.000192400192400168*G0_0_1_1_1_1 - 0.00198813532146864*G0_0_1_1_2_0 - 0.0335417668751*G0_0_1_2_0_0 - 0.00198813532146864*G0_0_1_2_0_1 - 0.00397627064293728*G0_0_1_2_0_2 - 0.00198813532146864*G0_0_1_2_1_0 - 0.00397627064293727*G0_0_1_2_2_0 - 0.000192400192400133*G0_0_1_2_2_2 + 0.541029341029338*G0_1_0_0_0_0 + 0.0335417668751*G0_1_0_0_0_1 + 0.0335417668751*G0_1_0_0_0_2 + 0.0335417668751*G0_1_0_0_1_0 + 0.00397627064293729*G0_1_0_0_1_1 + 0.00198813532146864*G0_1_0_0_1_2 + 0.0335417668751*G0_1_0_0_2_0 + 0.00198813532146864*G0_1_0_0_2_1 + 0.00397627064293727*G0_1_0_0_2_2 + 0.0335417668751*G0_1_0_1_0_0 + 0.00397627064293729*G0_1_0_1_0_1 + 0.00198813532146864*G0_1_0_1_0_2 + 0.00397627064293729*G0_1_0_1_1_0 + 0.000192400192400169*G0_1_0_1_1_1 + 0.00198813532146864*G0_1_0_1_2_0 + 0.0335417668751*G0_1_0_2_0_0 + 0.00198813532146864*G0_1_0_2_0_1 + 0.00397627064293728*G0_1_0_2_0_2 + 0.00198813532146864*G0_1_0_2_1_0 + 0.00397627064293728*G0_1_0_2_2_0 + 0.000192400192400133*G0_1_0_2_2_2;
    A[49] = -A[169] - 0.01341670675004*G0_0_0_0_0_0 - 0.00900432900432896*G0_0_0_0_0_1 - 0.0249863716530382*G0_0_0_0_0_2 - 0.00900432900432896*G0_0_0_0_1_0 - 0.0148789482122815*G0_0_0_0_1_1 - 0.00715728715728715*G0_0_0_0_1_2 - 0.0249863716530382*G0_0_0_0_2_0 - 0.00715728715728715*G0_0_0_0_2_1 - 0.0615424082090745*G0_0_0_0_2_2 - 0.00900432900432896*G0_0_0_1_0_0 - 0.0148789482122815*G0_0_0_1_0_1 - 0.00715728715728715*G0_0_0_1_0_2 - 0.0148789482122815*G0_0_0_1_1_0 + 0.0143658810325473*G0_0_0_1_1_1 + 0.0118005451338783*G0_0_0_1_1_2 - 0.00715728715728715*G0_0_0_1_2_0 + 0.0118005451338783*G0_0_0_1_2_1 - 0.0159307359307359*G0_0_0_1_2_2 - 0.0249863716530382*G0_0_0_2_0_0 - 0.00715728715728715*G0_0_0_2_0_1 - 0.0615424082090745*G0_0_0_2_0_2 - 0.00715728715728715*G0_0_0_2_1_0 + 0.0118005451338783*G0_0_0_2_1_1 - 0.0159307359307359*G0_0_0_2_1_2 - 0.0615424082090745*G0_0_0_2_2_0 - 0.0159307359307359*G0_0_0_2_2_1 - 0.342421035754367*G0_0_0_2_2_2 - 0.00885040885040872*G0_0_1_0_0_0 - 0.00923520923520917*G0_0_1_0_0_1 + 0.00115440115440112*G0_0_1_0_0_2 - 0.00923520923520917*G0_0_1_0_1_0 + 0.00718294051627396*G0_0_1_0_1_1 + 0.01333974667308*G0_0_1_0_1_2 + 0.00115440115440112*G0_0_1_0_2_0 + 0.01333974667308*G0_0_1_0_2_1 + 0.00525893859227189*G0_0_1_0_2_2 - 0.00923520923520917*G0_0_1_1_0_0 + 0.00718294051627395*G0_0_1_1_0_1 + 0.01333974667308*G0_0_1_1_0_2 + 0.00718294051627395*G0_0_1_1_1_0 + 0.469456469456469*G0_0_1_1_1_1 + 0.115953182619849*G0_0_1_1_1_2 + 0.01333974667308*G0_0_1_1_2_0 + 0.115953182619849*G0_0_1_1_2_1 + 0.0625941959275291*G0_0_1_1_2_2 + 0.00115440115440112*G0_0_1_2_0_0 + 0.01333974667308*G0_0_1_2_0_1 + 0.00525893859227189*G0_0_1_2_0_2 + 0.01333974667308*G0_0_1_2_1_0 + 0.115953182619849*G0_0_1_2_1_1 + 0.0625941959275291*G0_0_1_2_1_2 + 0.00525893859227189*G0_0_1_2_2_0 + 0.0625941959275291*G0_0_1_2_2_1 + 0.0280904280904281*G0_0_1_2_2_2;
    A[34] = -A[37] + 0.00161616161616154*G0_1_0_0_0_0 + 0.000179573512906829*G0_1_0_0_0_1 + 0.00102613435946771*G0_1_0_0_0_2 + 0.000179573512906829*G0_1_0_0_1_0 - 0.000179573512906852*G0_1_0_0_1_1 + 0.00102613435946771*G0_1_0_0_2_0 - 0.0109026775693441*G0_1_0_0_2_2 + 0.000179573512906829*G0_1_0_1_0_0 - 0.000179573512906852*G0_1_0_1_0_1 - 0.000179573512906852*G0_1_0_1_1_0 - 0.00161616161616157*G0_1_0_1_1_1 - 0.00102613435946767*G0_1_0_1_1_2 - 0.00102613435946767*G0_1_0_1_2_1 + 0.0109026775693442*G0_1_0_1_2_2 + 0.0010261343594677*G0_1_0_2_0_0 - 0.0109026775693441*G0_1_0_2_0_2 - 0.00102613435946767*G0_1_0_2_1_1 + 0.0109026775693442*G0_1_0_2_1_2 - 0.0109026775693441*G0_1_0_2_2_0 + 0.0109026775693442*G0_1_0_2_2_1 + 0.0659291325957988*G0_1_1_0_0_0 + 0.015751162417829*G0_1_1_0_0_1 + 0.0072791406124739*G0_1_1_0_0_2 + 0.015751162417829*G0_1_1_0_1_0 + 0.0155715889049222*G0_1_1_0_1_1 + 0.00299823633156965*G0_1_1_0_1_2 + 0.0072791406124739*G0_1_1_0_2_0 + 0.00299823633156965*G0_1_1_0_2_1 + 0.00224466891133559*G0_1_1_0_2_2 + 0.015751162417829*G0_1_1_1_0_0 + 0.0155715889049222*G0_1_1_1_0_1 + 0.00299823633156965*G0_1_1_1_0_2 + 0.0155715889049222*G0_1_1_1_1_0 + 0.0643129709796377*G0_1_1_1_1_1 + 0.00625300625300626*G0_1_1_1_1_2 + 0.00299823633156965*G0_1_1_1_2_0 + 0.00625300625300626*G0_1_1_1_2_1 + 0.0131473464806798*G0_1_1_1_2_2 + 0.0072791406124739*G0_1_1_2_0_0 + 0.00299823633156965*G0_1_1_2_0_1 + 0.00224466891133559*G0_1_1_2_0_2 + 0.00299823633156965*G0_1_1_2_1_0 + 0.00625300625300626*G0_1_1_2_1_1 + 0.0131473464806798*G0_1_1_2_1_2 + 0.00224466891133559*G0_1_1_2_2_0 + 0.0131473464806798*G0_1_1_2_2_1 + 0.181080647747313*G0_1_1_2_2_2;
    A[124] = -A[79] - 0.0088504088504085*G0_1_0_0_0_0 + 0.00115440115440127*G0_1_0_0_0_1 - 0.00923520923520921*G0_1_0_0_0_2 + 0.00115440115440127*G0_1_0_0_1_0 + 0.00525893859227204*G0_1_0_0_1_1 + 0.01333974667308*G0_1_0_0_1_2 - 0.00923520923520921*G0_1_0_0_2_0 + 0.01333974667308*G0_1_0_0_2_1 + 0.00718294051627376*G0_1_0_0_2_2 + 0.00115440115440127*G0_1_0_1_0_0 + 0.00525893859227204*G0_1_0_1_0_1 + 0.01333974667308*G0_1_0_1_0_2 + 0.00525893859227204*G0_1_0_1_1_0 + 0.0280904280904284*G0_1_0_1_1_1 + 0.0625941959275291*G0_1_0_1_1_2 + 0.01333974667308*G0_1_0_1_2_0 + 0.0625941959275291*G0_1_0_1_2_1 + 0.115953182619849*G0_1_0_1_2_2 - 0.00923520923520921*G0_1_0_2_0_0 + 0.01333974667308*G0_1_0_2_0_1 + 0.00718294051627376*G0_1_0_2_0_2 + 0.01333974667308*G0_1_0_2_1_0 + 0.0625941959275291*G0_1_0_2_1_1 + 0.115953182619849*G0_1_0_2_1_2 + 0.00718294051627376*G0_1_0_2_2_0 + 0.115953182619849*G0_1_0_2_2_1 + 0.469456469456466*G0_1_0_2_2_2 - 0.0134167067500396*G0_1_1_0_0_0 - 0.0249863716530381*G0_1_1_0_0_1 - 0.00900432900432897*G0_1_1_0_0_2 - 0.0249863716530381*G0_1_1_0_1_0 - 0.0615424082090746*G0_1_1_0_1_1 - 0.00715728715728712*G0_1_1_0_1_2 - 0.00900432900432897*G0_1_1_0_2_0 - 0.00715728715728712*G0_1_1_0_2_1 - 0.0148789482122816*G0_1_1_0_2_2 - 0.0249863716530381*G0_1_1_1_0_0 - 0.0615424082090746*G0_1_1_1_0_1 - 0.00715728715728712*G0_1_1_1_0_2 - 0.0615424082090746*G0_1_1_1_1_0 - 0.342421035754369*G0_1_1_1_1_1 - 0.0159307359307359*G0_1_1_1_1_2 - 0.00715728715728712*G0_1_1_1_2_0 - 0.015930735930736*G0_1_1_1_2_1 + 0.0118005451338784*G0_1_1_1_2_2 - 0.00900432900432897*G0_1_1_2_0_0 - 0.00715728715728712*G0_1_1_2_0_1 - 0.0148789482122816*G0_1_1_2_0_2 - 0.00715728715728712*G0_1_1_2_1_0 - 0.015930735930736*G0_1_1_2_1_1 + 0.0118005451338784*G0_1_1_2_1_2 - 0.0148789482122816*G0_1_1_2_2_0 + 0.0118005451338784*G0_1_1_2_2_1 + 0.0143658810325472*G0_1_1_2_2_2;
    A[161] = -A[153] - 0.370511463844796*G0_0_0_0_0_0 - 0.0785249318582649*G0_0_0_0_0_1 - 0.0668013468013464*G0_0_0_0_0_2 - 0.0785249318582649*G0_0_0_0_1_0 - 0.10415263748597*G0_0_0_0_1_1 - 0.0204970338303671*G0_0_0_0_1_2 - 0.0668013468013464*G0_0_0_0_2_0 - 0.0204970338303671*G0_0_0_0_2_1 - 0.0261407728074393*G0_0_0_0_2_2 - 0.0785249318582649*G0_0_0_1_0_0 - 0.10415263748597*G0_0_0_1_0_1 - 0.0204970338303671*G0_0_0_1_0_2 - 0.10415263748597*G0_0_0_1_1_0 - 0.455090588423921*G0_0_0_1_1_1 - 0.0220618887285553*G0_0_0_1_1_2 - 0.0204970338303671*G0_0_0_1_2_0 - 0.0220618887285553*G0_0_0_1_2_1 + 0.00023088023088021*G0_0_0_1_2_2 - 0.0668013468013464*G0_0_0_2_0_0 - 0.0204970338303671*G0_0_0_2_0_1 - 0.0261407728074393*G0_0_0_2_0_2 - 0.0204970338303671*G0_0_0_2_1_0 - 0.0220618887285553*G0_0_0_2_1_1 + 0.000230880230880212*G0_0_0_2_1_2 - 0.0261407728074393*G0_0_0_2_2_0 + 0.000230880230880212*G0_0_0_2_2_1 - 0.00456629789963131*G0_0_0_2_2_2 - 0.028090428090428*G0_1_0_0_0_0 - 0.062594195927529*G0_1_0_0_0_1 - 0.00525893859227187*G0_1_0_0_0_2 - 0.062594195927529*G0_1_0_0_1_0 - 0.115953182619849*G0_1_0_0_1_1 - 0.01333974667308*G0_1_0_0_1_2 - 0.00525893859227187*G0_1_0_0_2_0 - 0.01333974667308*G0_1_0_0_2_1 - 0.00115440115440111*G0_1_0_0_2_2 - 0.062594195927529*G0_1_0_1_0_0 - 0.115953182619849*G0_1_0_1_0_1 - 0.01333974667308*G0_1_0_1_0_2 - 0.115953182619849*G0_1_0_1_1_0 - 0.469456469456468*G0_1_0_1_1_1 - 0.00718294051627383*G0_1_0_1_1_2 - 0.01333974667308*G0_1_0_1_2_0 - 0.00718294051627383*G0_1_0_1_2_1 + 0.00923520923520917*G0_1_0_1_2_2 - 0.00525893859227187*G0_1_0_2_0_0 - 0.01333974667308*G0_1_0_2_0_1 - 0.00115440115440111*G0_1_0_2_0_2 - 0.01333974667308*G0_1_0_2_1_0 - 0.00718294051627384*G0_1_0_2_1_1 + 0.00923520923520917*G0_1_0_2_1_2 - 0.00115440115440111*G0_1_0_2_2_0 + 0.00923520923520917*G0_1_0_2_2_1 + 0.00885040885040889*G0_1_0_2_2_2;
    A[96] = A[144] - 0.301683501683501*G0_0_0_0_0_0 - 0.0294158516380737*G0_0_0_0_0_1 + 0.0827748383303936*G0_0_0_0_0_2 - 0.0294158516380737*G0_0_0_0_1_0 - 0.0331783442894552*G0_0_0_0_1_1 + 0.00615680615680614*G0_0_0_0_1_2 + 0.0827748383303936*G0_0_0_0_2_0 + 0.00615680615680614*G0_0_0_0_2_1 + 0.0578055689166798*G0_0_0_0_2_2 - 0.0294158516380737*G0_0_0_1_0_0 - 0.0331783442894552*G0_0_0_1_0_1 + 0.00615680615680614*G0_0_0_1_0_2 - 0.0331783442894552*G0_0_0_1_1_0 - 0.154535834535834*G0_0_0_1_1_1 - 0.0154604243493131*G0_0_0_1_1_2 + 0.00615680615680615*G0_0_0_1_2_0 - 0.0154604243493131*G0_0_0_1_2_1 + 0.0205910961466516*G0_0_0_1_2_2 + 0.0827748383303936*G0_0_0_2_0_0 + 0.00615680615680615*G0_0_0_2_0_1 + 0.0578055689166798*G0_0_0_2_0_2 + 0.00615680615680614*G0_0_0_2_1_0 - 0.0154604243493131*G0_0_0_2_1_1 + 0.0205910961466516*G0_0_0_2_1_2 + 0.0578055689166798*G0_0_0_2_2_0 + 0.0205910961466516*G0_0_0_2_2_1 + 0.169927849927849*G0_0_0_2_2_2 - 0.0560953449842335*G0_0_1_0_0_1 + 0.0560953449842337*G0_0_1_0_0_2 - 0.0560953449842335*G0_0_1_0_1_0 - 0.0454919566030675*G0_0_1_0_1_1 + 0.0560953449842337*G0_0_1_0_2_0 + 0.0454919566030675*G0_0_1_0_2_2 - 0.0560953449842335*G0_0_1_1_0_0 - 0.0454919566030675*G0_0_1_1_0_1 - 0.0454919566030675*G0_0_1_1_1_0 - 0.162231842231841*G0_0_1_1_1_1 - 0.0180257602479824*G0_0_1_1_1_2 - 0.0180257602479824*G0_0_1_1_2_1 + 0.0180257602479824*G0_0_1_1_2_2 + 0.0560953449842337*G0_0_1_2_0_0 + 0.0454919566030675*G0_0_1_2_0_2 - 0.0180257602479824*G0_0_1_2_1_1 + 0.0180257602479824*G0_0_1_2_1_2 + 0.0454919566030675*G0_0_1_2_2_0 + 0.0180257602479824*G0_0_1_2_2_1 + 0.162231842231841*G0_0_1_2_2_2 - 0.0560953449842335*G0_1_0_0_0_1 + 0.0560953449842337*G0_1_0_0_0_2 - 0.0560953449842335*G0_1_0_0_1_0 - 0.0454919566030675*G0_1_0_0_1_1 + 0.0560953449842337*G0_1_0_0_2_0 + 0.0454919566030675*G0_1_0_0_2_2 - 0.0560953449842335*G0_1_0_1_0_0 - 0.0454919566030675*G0_1_0_1_0_1 - 0.0454919566030675*G0_1_0_1_1_0 - 0.162231842231841*G0_1_0_1_1_1 - 0.0180257602479824*G0_1_0_1_1_2 - 0.0180257602479824*G0_1_0_1_2_1 + 0.0180257602479824*G0_1_0_1_2_2 + 0.0560953449842337*G0_1_0_2_0_0 + 0.0454919566030675*G0_1_0_2_0_2 - 0.0180257602479824*G0_1_0_2_1_1 + 0.0180257602479824*G0_1_0_2_1_2 + 0.0454919566030675*G0_1_0_2_2_0 + 0.0180257602479824*G0_1_0_2_2_1 + 0.162231842231841*G0_1_0_2_2_2 + 0.3016835016835*G0_1_1_0_0_0 - 0.0827748383303934*G0_1_1_0_0_1 + 0.0294158516380737*G0_1_1_0_0_2 - 0.0827748383303934*G0_1_1_0_1_0 - 0.0578055689166797*G0_1_1_0_1_1 - 0.00615680615680612*G0_1_1_0_1_2 + 0.0294158516380737*G0_1_1_0_2_0 - 0.00615680615680612*G0_1_1_0_2_1 + 0.0331783442894553*G0_1_1_0_2_2 - 0.0827748383303934*G0_1_1_1_0_0 - 0.0578055689166797*G0_1_1_1_0_1 - 0.00615680615680612*G0_1_1_1_0_2 - 0.0578055689166797*G0_1_1_1_1_0 - 0.169927849927849*G0_1_1_1_1_1 - 0.0205910961466516*G0_1_1_1_1_2 - 0.00615680615680612*G0_1_1_1_2_0 - 0.0205910961466516*G0_1_1_1_2_1 + 0.0154604243493131*G0_1_1_1_2_2 + 0.0294158516380737*G0_1_1_2_0_0 - 0.00615680615680612*G0_1_1_2_0_1 + 0.0331783442894553*G0_1_1_2_0_2 - 0.00615680615680612*G0_1_1_2_1_0 - 0.0205910961466516*G0_1_1_2_1_1 + 0.0154604243493131*G0_1_1_2_1_2 + 0.0331783442894553*G0_1_1_2_2_0 + 0.0154604243493131*G0_1_1_2_2_1 + 0.154535834535834*G0_1_1_2_2_2;
    A[81] = A[95] + 0.00933782267115585*G0_0_1_0_0_0 - 0.00030784030784028*G0_0_1_0_0_2 + 0.000684089572978407*G0_0_1_0_1_1 - 0.000684089572978461*G0_0_1_0_1_2 - 0.00030784030784028*G0_0_1_0_2_0 - 0.000684089572978462*G0_0_1_0_2_1 + 0.00324942547164769*G0_0_1_0_2_2 + 0.000684089572978406*G0_0_1_1_0_1 - 0.000684089572978461*G0_0_1_1_0_2 + 0.000684089572978407*G0_0_1_1_1_0 + 0.00400192400192374*G0_0_1_1_1_1 + 0.008858959970071*G0_0_1_1_1_2 - 0.000684089572978462*G0_0_1_1_2_0 + 0.008858959970071*G0_0_1_1_2_1 + 0.0121425899203676*G0_0_1_1_2_2 - 0.00030784030784028*G0_0_1_2_0_0 - 0.000684089572978461*G0_0_1_2_0_1 + 0.00324942547164768*G0_0_1_2_0_2 - 0.000684089572978462*G0_0_1_2_1_0 + 0.008858959970071*G0_0_1_2_1_1 + 0.0121425899203676*G0_0_1_2_1_2 + 0.00324942547164769*G0_0_1_2_2_0 + 0.0121425899203676*G0_0_1_2_2_1 - 0.0831168831168829*G0_0_1_2_2_2 - 0.00933782267115585*G0_1_0_0_0_0 + 0.000307840307840282*G0_1_0_0_0_2 - 0.000684089572978407*G0_1_0_0_1_1 + 0.000684089572978461*G0_1_0_0_1_2 + 0.00030784030784028*G0_1_0_0_2_0 + 0.000684089572978461*G0_1_0_0_2_1 - 0.00324942547164769*G0_1_0_0_2_2 - 0.000684089572978406*G0_1_0_1_0_1 + 0.000684089572978462*G0_1_0_1_0_2 - 0.000684089572978407*G0_1_0_1_1_0 - 0.00400192400192374*G0_1_0_1_1_1 - 0.008858959970071*G0_1_0_1_1_2 + 0.000684089572978462*G0_1_0_1_2_0 - 0.008858959970071*G0_1_0_1_2_1 - 0.0121425899203676*G0_1_0_1_2_2 + 0.00030784030784028*G0_1_0_2_0_0 + 0.000684089572978462*G0_1_0_2_0_1 - 0.00324942547164768*G0_1_0_2_0_2 + 0.000684089572978462*G0_1_0_2_1_0 - 0.008858959970071*G0_1_0_2_1_1 - 0.0121425899203676*G0_1_0_2_1_2 - 0.00324942547164769*G0_1_0_2_2_0 - 0.0121425899203676*G0_1_0_2_2_1 + 0.0831168831168829*G0_1_0_2_2_2;
    A[156] = A[100] - 0.174699374699375*G0_0_1_0_0_0 + 0.0135962802629469*G0_0_1_0_0_1 + 0.0200096200096199*G0_0_1_0_0_2 + 0.0135962802629469*G0_0_1_0_1_0 + 0.00336059002725674*G0_0_1_0_1_1 + 0.0200096200096199*G0_0_1_0_2_0 + 0.0138784672118005*G0_0_1_0_2_2 + 0.0135962802629469*G0_0_1_1_0_0 + 0.00336059002725674*G0_0_1_1_0_1 + 0.00336059002725674*G0_0_1_1_1_0 + 0.00823472823472852*G0_0_1_1_1_1 + 0.000820907487574195*G0_0_1_1_1_2 + 0.000820907487574199*G0_0_1_1_2_1 + 0.000897867564534248*G0_0_1_1_2_2 + 0.0200096200096199*G0_0_1_2_0_0 + 0.0138784672118005*G0_0_1_2_0_2 + 0.000820907487574199*G0_0_1_2_1_1 + 0.000897867564534251*G0_0_1_2_1_2 + 0.0138784672118005*G0_0_1_2_2_0 + 0.000897867564534249*G0_0_1_2_2_1 + 0.008927368927369*G0_0_1_2_2_2 + 0.174699374699375*G0_1_0_0_0_0 - 0.0135962802629468*G0_1_0_0_0_1 - 0.0200096200096199*G0_1_0_0_0_2 - 0.0135962802629468*G0_1_0_0_1_0 - 0.00336059002725674*G0_1_0_0_1_1 - 0.0200096200096199*G0_1_0_0_2_0 - 0.0138784672118005*G0_1_0_0_2_2 - 0.0135962802629468*G0_1_0_1_0_0 - 0.00336059002725674*G0_1_0_1_0_1 - 0.00336059002725674*G0_1_0_1_1_0 - 0.00823472823472852*G0_1_0_1_1_1 - 0.000820907487574195*G0_1_0_1_1_2 - 0.000820907487574195*G0_1_0_1_2_1 - 0.000897867564534249*G0_1_0_1_2_2 - 0.0200096200096199*G0_1_0_2_0_0 - 0.0138784672118005*G0_1_0_2_0_2 - 0.000820907487574195*G0_1_0_2_1_1 - 0.000897867564534253*G0_1_0_2_1_2 - 0.0138784672118005*G0_1_0_2_2_0 - 0.000897867564534251*G0_1_0_2_2_1 - 0.00892736892736899*G0_1_0_2_2_2;
    A[142] = A[156] - 0.137245470578803*G0_0_0_0_0_0 + 0.0161616161616161*G0_0_0_0_0_1 - 0.0369408369408366*G0_0_0_0_0_2 + 0.0161616161616161*G0_0_0_0_1_0 + 0.0114670514670515*G0_0_0_0_1_1 + 0.0039762706429373*G0_0_0_0_1_2 - 0.0369408369408366*G0_0_0_0_2_0 + 0.0039762706429373*G0_0_0_0_2_1 - 0.0155715889049221*G0_0_0_0_2_2 + 0.0161616161616161*G0_0_0_1_0_0 + 0.0114670514670515*G0_0_0_1_0_1 + 0.00397627064293729*G0_0_0_1_0_2 + 0.0114670514670515*G0_0_0_1_1_0 + 0.0470739137405805*G0_0_0_1_1_1 + 0.00918390251723582*G0_0_0_1_1_2 + 0.0039762706429373*G0_0_0_1_2_0 + 0.00918390251723582*G0_0_0_1_2_1 - 0.0052589385922719*G0_0_0_1_2_2 - 0.0369408369408366*G0_0_0_2_0_0 + 0.0039762706429373*G0_0_0_2_0_1 - 0.0155715889049221*G0_0_0_2_0_2 + 0.0039762706429373*G0_0_0_2_1_0 + 0.00918390251723582*G0_0_0_2_1_1 - 0.0052589385922719*G0_0_0_2_1_2 - 0.0155715889049221*G0_0_0_2_2_0 - 0.0052589385922719*G0_0_0_2_2_1 - 0.0401218534551865*G0_0_0_2_2_2 - 0.00461760461760459*G0_0_1_0_0_1 + 0.00461760461760464*G0_0_1_0_0_2 - 0.00461760461760459*G0_0_1_0_1_0 + 0.00800384800384796*G0_0_1_0_1_1 + 0.00461760461760463*G0_0_1_0_2_0 - 0.00800384800384797*G0_0_1_0_2_2 - 0.00461760461760459*G0_0_1_1_0_0 + 0.00800384800384796*G0_0_1_1_0_1 + 0.00800384800384796*G0_0_1_1_1_0 + 0.0434824434824432*G0_0_1_1_1_1 + 0.00720859387526048*G0_0_1_1_1_2 + 0.00720859387526048*G0_0_1_1_2_1 - 0.00720859387526052*G0_0_1_1_2_2 + 0.00461760461760464*G0_0_1_2_0_0 - 0.00800384800384797*G0_0_1_2_0_2 + 0.00720859387526048*G0_0_1_2_1_1 - 0.00720859387526052*G0_0_1_2_1_2 - 0.00800384800384797*G0_0_1_2_2_0 - 0.00720859387526052*G0_0_1_2_2_1 - 0.0434824434824432*G0_0_1_2_2_2 - 0.0110309443642776*G0_1_0_0_0_1 + 0.0110309443642777*G0_1_0_0_0_2 - 0.0110309443642776*G0_1_0_0_1_0 - 0.00251402918069575*G0_1_0_0_1_1 + 0.0110309443642777*G0_1_0_0_2_0 + 0.00251402918069583*G0_1_0_0_2_2 - 0.0110309443642776*G0_1_0_1_0_0 - 0.00251402918069575*G0_1_0_1_0_1 - 0.00251402918069575*G0_1_0_1_1_0 + 0.0427898027898029*G0_1_0_1_1_1 + 0.00713163379830042*G0_1_0_1_1_2 + 0.00713163379830042*G0_1_0_1_2_1 - 0.00713163379830048*G0_1_0_1_2_2 + 0.0110309443642777*G0_1_0_2_0_0 + 0.00251402918069583*G0_1_0_2_0_2 + 0.00713163379830042*G0_1_0_2_1_1 - 0.00713163379830048*G0_1_0_2_1_2 + 0.00251402918069583*G0_1_0_2_2_0 - 0.00713163379830048*G0_1_0_2_2_1 - 0.0427898027898026*G0_1_0_2_2_2 + 0.137245470578803*G0_1_1_0_0_0 + 0.0369408369408367*G0_1_1_0_0_1 - 0.0161616161616161*G0_1_1_0_0_2 + 0.0369408369408368*G0_1_1_0_1_0 + 0.0155715889049222*G0_1_1_0_1_1 - 0.00397627064293731*G0_1_1_0_1_2 - 0.0161616161616161*G0_1_1_0_2_0 - 0.00397627064293731*G0_1_1_0_2_1 - 0.0114670514670514*G0_1_1_0_2_2 + 0.0369408369408368*G0_1_1_1_0_0 + 0.0155715889049222*G0_1_1_1_0_1 - 0.00397627064293731*G0_1_1_1_0_2 + 0.0155715889049222*G0_1_1_1_1_0 + 0.0401218534551866*G0_1_1_1_1_1 + 0.00525893859227185*G0_1_1_1_1_2 - 0.00397627064293731*G0_1_1_1_2_0 + 0.00525893859227185*G0_1_1_1_2_1 - 0.00918390251723587*G0_1_1_1_2_2 - 0.0161616161616161*G0_1_1_2_0_0 - 0.00397627064293731*G0_1_1_2_0_1 - 0.0114670514670514*G0_1_1_2_0_2 - 0.00397627064293731*G0_1_1_2_1_0 + 0.00525893859227185*G0_1_1_2_1_1 - 0.00918390251723587*G0_1_1_2_1_2 - 0.0114670514670514*G0_1_1_2_2_0 - 0.00918390251723587*G0_1_1_2_2_1 - 0.0470739137405802*G0_1_1_2_2_2;
    A[223] = -A[213] - 0.0415584415584417*G0_0_0_0_0_0 - 0.00297578964245634*G0_0_0_0_0_1 - 0.0502805836139169*G0_0_0_0_0_2 - 0.00297578964245634*G0_0_0_0_1_0 + 0.00297578964245627*G0_0_0_0_1_1 - 0.0502805836139169*G0_0_0_0_2_0 - 0.0580792047458714*G0_0_0_0_2_2 - 0.00297578964245634*G0_0_0_1_0_0 + 0.00297578964245627*G0_0_0_1_0_1 + 0.00297578964245627*G0_0_0_1_1_0 + 0.0415584415584412*G0_0_0_1_1_1 + 0.0502805836139167*G0_0_0_1_1_2 + 0.0502805836139166*G0_0_0_1_2_1 + 0.0580792047458711*G0_0_0_1_2_2 - 0.0502805836139169*G0_0_0_2_0_0 - 0.0580792047458714*G0_0_0_2_0_2 + 0.0502805836139167*G0_0_0_2_1_1 + 0.0580792047458711*G0_0_0_2_1_2 - 0.0580792047458714*G0_0_0_2_2_0 + 0.0580792047458711*G0_0_0_2_2_1 + 0.0232932499599164*G0_0_1_0_0_0 + 0.0123136123136122*G0_0_1_0_0_1 + 0.0140580407247072*G0_0_1_0_0_2 + 0.0123136123136122*G0_0_1_0_1_0 + 0.0382748116081447*G0_0_1_0_1_1 + 0.0171364438031104*G0_0_1_0_1_2 + 0.0140580407247072*G0_0_1_0_2_0 + 0.0171364438031104*G0_0_1_0_2_1 + 0.0320153920153917*G0_0_1_0_2_2 + 0.0123136123136122*G0_0_1_1_0_0 + 0.0382748116081447*G0_0_1_1_0_1 + 0.0171364438031104*G0_0_1_1_0_2 + 0.0382748116081447*G0_0_1_1_1_0 + 0.271720378387044*G0_0_1_1_1_1 + 0.127958954625621*G0_0_1_1_1_2 + 0.0171364438031104*G0_0_1_1_2_0 + 0.127958954625621*G0_0_1_1_2_1 + 0.116774090107423*G0_0_1_1_2_2 + 0.0140580407247072*G0_0_1_2_0_0 + 0.0171364438031104*G0_0_1_2_0_1 + 0.0320153920153917*G0_0_1_2_0_2 + 0.0171364438031104*G0_0_1_2_1_0 + 0.127958954625621*G0_0_1_2_1_1 + 0.116774090107423*G0_0_1_2_1_2 + 0.0320153920153917*G0_0_1_2_2_0 + 0.116774090107423*G0_0_1_2_2_1 + 0.135654962321628*G0_0_1_2_2_2 + 0.0448420715087382*G0_1_0_0_0_0 + 0.0460734327400993*G0_1_0_0_0_1 + 0.0445342312008977*G0_1_0_0_0_2 + 0.0460734327400993*G0_1_0_0_1_0 + 0.0490492223825557*G0_1_0_0_1_1 + 0.0470995670995669*G0_1_0_0_1_2 + 0.0445342312008977*G0_1_0_0_2_0 + 0.0470995670995669*G0_1_0_0_2_1 + 0.0370434503767836*G0_1_0_0_2_2 + 0.0460734327400993*G0_1_0_1_0_0 + 0.0490492223825557*G0_1_0_1_0_1 + 0.0470995670995669*G0_1_0_1_0_2 + 0.0490492223825557*G0_1_0_1_1_0 + 0.0864005130671795*G0_1_0_1_1_1 + 0.0948148148148143*G0_1_0_1_1_2 + 0.0470995670995669*G0_1_0_1_2_0 + 0.0948148148148143*G0_1_0_1_2_1 + 0.0951226551226547*G0_1_0_1_2_2 + 0.0445342312008977*G0_1_0_2_0_0 + 0.0470995670995669*G0_1_0_2_0_1 + 0.0370434503767836*G0_1_0_2_0_2 + 0.0470995670995669*G0_1_0_2_1_0 + 0.0948148148148143*G0_1_0_2_1_1 + 0.0951226551226547*G0_1_0_2_1_2 + 0.0370434503767836*G0_1_0_2_2_0 + 0.0951226551226547*G0_1_0_2_2_1 + 0.0439185505852176*G0_1_0_2_2_2 - 0.0680327080327077*G0_1_1_0_0_0 - 0.0950200416867079*G0_1_1_0_0_1 - 0.00400192400192397*G0_1_1_0_0_2 - 0.0950200416867079*G0_1_1_0_1_0 - 0.155356742023408*G0_1_1_0_1_1 - 0.00246272246272243*G0_1_1_0_1_2 - 0.00400192400192397*G0_1_1_0_2_0 - 0.00246272246272243*G0_1_1_0_2_1 - 0.00256533589866915*G0_1_1_0_2_2 - 0.0950200416867079*G0_1_1_1_0_0 - 0.155356742023408*G0_1_1_1_0_1 - 0.00246272246272243*G0_1_1_1_0_2 - 0.155356742023408*G0_1_1_1_1_0 - 0.307840307840307*G0_1_1_1_1_1 + 0.0568478435145098*G0_1_1_1_1_2 - 0.00246272246272242*G0_1_1_1_2_0 + 0.0568478435145098*G0_1_1_1_2_1 + 0.0630046496713161*G0_1_1_1_2_2 - 0.00400192400192397*G0_1_1_2_0_0 - 0.00246272246272242*G0_1_1_2_0_1 - 0.00256533589866915*G0_1_1_2_0_2 - 0.00246272246272242*G0_1_1_2_1_0 + 0.0568478435145098*G0_1_1_2_1_1 + 0.0630046496713161*G0_1_1_2_1_2 - 0.00256533589866915*G0_1_1_2_2_0 + 0.0630046496713161*G0_1_1_2_2_1 - 0.0107744107744098*G0_1_1_2_2_2;
    A[185] = -A[188] - 0.065262145262145*G0_0_1_0_0_0 + 0.00451499118165784*G0_0_1_0_0_1 - 0.0250376783710115*G0_0_1_0_0_2 + 0.00451499118165784*G0_0_1_0_1_0 + 0.0131345198011864*G0_0_1_0_1_1 + 0.000410453743787079*G0_0_1_0_1_2 - 0.0250376783710115*G0_0_1_0_2_0 + 0.00041045374378708*G0_0_1_0_2_1 - 0.0205226871893536*G0_0_1_0_2_2 + 0.00451499118165784*G0_0_1_1_0_0 + 0.0131345198011864*G0_0_1_1_0_1 + 0.000410453743787078*G0_0_1_1_0_2 + 0.0131345198011864*G0_0_1_1_1_0 + 0.0123136123136123*G0_0_1_1_1_1 + 0.0242167708834374*G0_0_1_1_1_2 + 0.000410453743787079*G0_0_1_1_2_0 + 0.0242167708834374*G0_0_1_1_2_1 + 0.0205226871893537*G0_0_1_1_2_2 - 0.0250376783710115*G0_0_1_2_0_0 + 0.000410453743787078*G0_0_1_2_0_1 - 0.0205226871893536*G0_0_1_2_0_2 + 0.000410453743787078*G0_0_1_2_1_0 + 0.0242167708834374*G0_0_1_2_1_1 + 0.0205226871893537*G0_0_1_2_1_2 - 0.0205226871893536*G0_0_1_2_2_0 + 0.0205226871893537*G0_0_1_2_2_1 + 0.30866121532788*G0_1_1_0_0_0 + 0.114721821388487*G0_1_1_0_0_1 - 0.00800384800384804*G0_1_1_0_0_2 + 0.114721821388487*G0_1_1_0_1_0 + 0.0728555395222058*G0_1_1_0_1_1 + 0.00430976430976426*G0_1_1_0_1_2 - 0.00800384800384804*G0_1_1_0_2_0 + 0.00430976430976426*G0_1_1_0_2_1 - 0.0391983325316658*G0_1_1_0_2_2 + 0.114721821388487*G0_1_1_1_0_0 + 0.0728555395222058*G0_1_1_1_0_1 + 0.00430976430976427*G0_1_1_1_0_2 + 0.0728555395222058*G0_1_1_1_1_0 + 0.0439185505852169*G0_1_1_1_1_1 + 0.0322206188872853*G0_1_1_1_1_2 + 0.00430976430976427*G0_1_1_1_2_0 + 0.0322206188872853*G0_1_1_1_2_1 + 0.0289369889369887*G0_1_1_1_2_2 - 0.00800384800384804*G0_1_1_2_0_0 + 0.00430976430976427*G0_1_1_2_0_1 - 0.0391983325316658*G0_1_1_2_0_2 + 0.00430976430976427*G0_1_1_2_1_0 + 0.0322206188872853*G0_1_1_2_1_1 + 0.0289369889369887*G0_1_1_2_1_2 - 0.0391983325316658*G0_1_1_2_2_0 + 0.0289369889369887*G0_1_1_2_2_1 - 0.0348885682219017*G0_1_1_2_2_2;
    A[210] = A[14] - 0.00333493666827*G0_0_1_0_0_1 + 0.00333493666826999*G0_0_1_0_0_2 - 0.00333493666827*G0_0_1_0_1_0 + 0.000974827641494305*G0_0_1_0_1_1 + 0.000949174282507613*G0_0_1_0_1_2 + 0.00333493666826999*G0_0_1_0_2_0 + 0.000949174282507612*G0_0_1_0_2_1 - 0.00287317620650952*G0_0_1_0_2_2 - 0.00333493666827*G0_0_1_1_0_0 + 0.000974827641494305*G0_0_1_1_0_1 + 0.000949174282507612*G0_0_1_1_0_2 + 0.000974827641494305*G0_0_1_1_1_0 + 0.000538720538720582*G0_0_1_1_1_1 + 0.00243706910373577*G0_0_1_1_1_2 + 0.000949174282507612*G0_0_1_1_2_0 + 0.00243706910373577*G0_0_1_1_2_1 + 0.00112874779541445*G0_0_1_1_2_2 + 0.00333493666826999*G0_0_1_2_0_0 + 0.000949174282507612*G0_0_1_2_0_1 - 0.00287317620650952*G0_0_1_2_0_2 + 0.000949174282507612*G0_0_1_2_1_0 + 0.00243706910373577*G0_0_1_2_1_1 + 0.00112874779541445*G0_0_1_2_1_2 - 0.00287317620650952*G0_0_1_2_2_0 + 0.00112874779541445*G0_0_1_2_2_1 - 0.0112361712361713*G0_0_1_2_2_2 + 0.00333493666827*G0_1_0_0_0_1 - 0.00333493666826999*G0_1_0_0_0_2 + 0.00333493666827*G0_1_0_0_1_0 - 0.000974827641494304*G0_1_0_0_1_1 - 0.000949174282507612*G0_1_0_0_1_2 - 0.00333493666826999*G0_1_0_0_2_0 - 0.000949174282507612*G0_1_0_0_2_1 + 0.00287317620650952*G0_1_0_0_2_2 + 0.00333493666827*G0_1_0_1_0_0 - 0.000974827641494303*G0_1_0_1_0_1 - 0.000949174282507612*G0_1_0_1_0_2 - 0.000974827641494304*G0_1_0_1_1_0 - 0.000538720538720578*G0_1_0_1_1_1 - 0.00243706910373577*G0_1_0_1_1_2 - 0.000949174282507612*G0_1_0_1_2_0 - 0.00243706910373577*G0_1_0_1_2_1 - 0.00112874779541445*G0_1_0_1_2_2 - 0.00333493666826999*G0_1_0_2_0_0 - 0.000949174282507612*G0_1_0_2_0_1 + 0.00287317620650952*G0_1_0_2_0_2 - 0.000949174282507612*G0_1_0_2_1_0 - 0.00243706910373576*G0_1_0_2_1_1 - 0.00112874779541445*G0_1_0_2_1_2 + 0.00287317620650952*G0_1_0_2_2_0 - 0.00112874779541445*G0_1_0_2_2_1 + 0.0112361712361713*G0_1_0_2_2_2;
    A[17] = 9.78034311367808e-05*G0_0_1_0_0_0 - 0.00028699695366362*G0_0_1_0_0_1 - 0.000286996953663616*G0_0_1_0_0_2 - 0.00028699695366362*G0_0_1_0_1_0 - 0.00190208967986746*G0_0_1_0_1_1 - 0.000130137352359575*G0_0_1_0_1_2 - 0.000286996953663616*G0_0_1_0_2_0 - 0.000130137352359575*G0_0_1_0_2_1 - 0.00190208967986745*G0_0_1_0_2_2 - 0.00028699695366362*G0_0_1_1_0_0 - 0.00190208967986746*G0_0_1_1_0_1 - 0.000130137352359575*G0_0_1_1_0_2 - 0.00190208967986746*G0_0_1_1_1_0 - 0.0212361712361713*G0_0_1_1_1_1 - 5.39789428678382e-05*G0_0_1_1_1_2 - 0.000130137352359575*G0_0_1_1_2_0 - 5.39789428678384e-05*G0_0_1_1_2_1 - 5.39789428678356e-05*G0_0_1_1_2_2 - 0.000286996953663616*G0_0_1_2_0_0 - 0.000130137352359575*G0_0_1_2_0_1 - 0.00190208967986745*G0_0_1_2_0_2 - 0.000130137352359575*G0_0_1_2_1_0 - 5.39789428678384e-05*G0_0_1_2_1_1 - 5.39789428678356e-05*G0_0_1_2_1_2 - 0.00190208967986745*G0_0_1_2_2_0 - 5.39789428678357e-05*G0_0_1_2_2_1 - 0.0212361712361711*G0_0_1_2_2_2;
    A[2] = -A[17] + 0.0213339746673079*G0_0_1_0_0_0 + 0.00161509272620383*G0_0_1_0_0_1 - 0.000233018010795783*G0_0_1_0_0_2 + 0.00161509272620383*G0_0_1_0_1_0 - 0.00161509272620384*G0_0_1_0_1_1 - 0.000233018010795783*G0_0_1_0_2_0 - 0.00184811073699961*G0_0_1_0_2_2 + 0.00161509272620383*G0_0_1_1_0_0 - 0.00161509272620384*G0_0_1_1_0_1 - 0.00161509272620384*G0_0_1_1_1_0 - 0.021333974667308*G0_0_1_1_1_1 + 0.000233018010795783*G0_0_1_1_1_2 + 0.000233018010795783*G0_0_1_1_2_1 + 0.00184811073699961*G0_0_1_1_2_2 - 0.000233018010795783*G0_0_1_2_0_0 - 0.00184811073699961*G0_0_1_2_0_2 + 0.000233018010795783*G0_0_1_2_1_1 + 0.00184811073699961*G0_0_1_2_1_2 - 0.00184811073699961*G0_0_1_2_2_0 + 0.00184811073699961*G0_0_1_2_2_1 + 0.0212361712361712*G0_1_1_0_0_0 + 0.00190208967986745*G0_1_1_0_0_1 + 0.00190208967986745*G0_1_1_0_1_0 + 0.000286996953663616*G0_1_1_0_1_1 + 0.000130137352359575*G0_1_1_0_1_2 + 0.000130137352359575*G0_1_1_0_2_1 + 0.00190208967986745*G0_1_1_1_0_0 + 0.000286996953663616*G0_1_1_1_0_1 + 0.000130137352359575*G0_1_1_1_0_2 + 0.000286996953663616*G0_1_1_1_1_0 + 0.000286996953663621*G0_1_1_1_1_2 + 0.000130137352359575*G0_1_1_1_2_0 + 0.000286996953663621*G0_1_1_1_2_1 + 0.00190208967986746*G0_1_1_1_2_2 + 0.000130137352359575*G0_1_1_2_0_1 + 0.000130137352359575*G0_1_1_2_1_0 + 0.000286996953663621*G0_1_1_2_1_1 + 0.00190208967986746*G0_1_1_2_1_2 + 0.00190208967986746*G0_1_1_2_2_1 + 0.0212361712361713*G0_1_1_2_2_2;
    A[134] = -A[89] + 0.0369408369408365*G0_1_0_0_0_0 + 0.00410453743787067*G0_1_0_0_0_1 + 0.0718294051627384*G0_1_0_0_0_2 + 0.00410453743787067*G0_1_0_0_1_0 - 0.00410453743787082*G0_1_0_0_1_1 + 0.0718294051627384*G0_1_0_0_2_0 + 0.108770242103575*G0_1_0_0_2_2 + 0.00410453743787067*G0_1_0_1_0_0 - 0.00410453743787082*G0_1_0_1_0_1 - 0.00410453743787082*G0_1_0_1_1_0 - 0.0369408369408367*G0_1_0_1_1_1 - 0.0718294051627382*G0_1_0_1_1_2 - 0.0718294051627382*G0_1_0_1_2_1 - 0.108770242103575*G0_1_0_1_2_2 + 0.0718294051627384*G0_1_0_2_0_0 + 0.108770242103575*G0_1_0_2_0_2 - 0.0718294051627382*G0_1_0_2_1_1 - 0.108770242103575*G0_1_0_2_1_2 + 0.108770242103575*G0_1_0_2_2_0 - 0.108770242103575*G0_1_0_2_2_1 - 0.204816418149751*G0_1_1_0_0_0 - 0.104460477793811*G0_1_1_0_0_1 - 0.0248324514991181*G0_1_1_0_0_2 - 0.104460477793811*G0_1_1_0_1_0 - 0.108565015231681*G0_1_1_0_1_1 - 0.0285265351932018*G0_1_1_0_1_2 - 0.0248324514991181*G0_1_1_0_2_0 - 0.0285265351932018*G0_1_1_0_2_1 - 0.0256533589866923*G0_1_1_0_2_2 - 0.104460477793811*G0_1_1_1_0_0 - 0.108565015231681*G0_1_1_1_0_1 - 0.0285265351932018*G0_1_1_1_0_2 - 0.108565015231681*G0_1_1_1_1_0 - 0.241757255090588*G0_1_1_1_1_1 - 0.0966618566618563*G0_1_1_1_1_2 - 0.0285265351932018*G0_1_1_1_2_0 - 0.0966618566618563*G0_1_1_1_2_1 - 0.134423601090267*G0_1_1_1_2_2 - 0.0248324514991181*G0_1_1_2_0_0 - 0.0285265351932018*G0_1_1_2_0_1 - 0.0256533589866923*G0_1_1_2_0_2 - 0.0285265351932018*G0_1_1_2_1_0 - 0.0966618566618563*G0_1_1_2_1_1 - 0.134423601090267*G0_1_1_2_1_2 - 0.0256533589866923*G0_1_1_2_2_0 - 0.134423601090267*G0_1_1_2_2_1 - 0.201122334455667*G0_1_1_2_2_2;
    A[186] = A[134] - 0.634766714766712*G0_0_0_0_0_0 - 0.0445342312008977*G0_0_0_0_0_1 - 0.178547378547378*G0_0_0_0_0_2 - 0.0445342312008977*G0_0_0_0_1_0 - 0.0137502004168671*G0_0_0_0_1_1 - 0.0229854096520763*G0_0_0_0_1_2 - 0.178547378547378*G0_0_0_0_2_0 - 0.0229854096520763*G0_0_0_0_2_1 - 0.0332467532467534*G0_0_0_0_2_2 - 0.0445342312008977*G0_0_0_1_0_0 - 0.0137502004168671*G0_0_0_1_0_1 - 0.0229854096520763*G0_0_0_1_0_2 - 0.0137502004168671*G0_0_0_1_1_0 - 0.0621837421837422*G0_0_0_1_1_1 - 0.0685457752124417*G0_0_0_1_1_2 - 0.0229854096520763*G0_0_0_1_2_0 - 0.0685457752124417*G0_0_0_1_2_1 - 0.134218374218374*G0_0_0_1_2_2 - 0.178547378547378*G0_0_0_2_0_0 - 0.0229854096520763*G0_0_0_2_0_1 - 0.0332467532467534*G0_0_0_2_0_2 - 0.0229854096520763*G0_0_0_2_1_0 - 0.0685457752124417*G0_0_0_2_1_1 - 0.134218374218374*G0_0_0_2_1_2 - 0.0332467532467534*G0_0_0_2_2_0 - 0.134218374218374*G0_0_0_2_2_1 - 0.184704184704186*G0_0_0_2_2_2 - 0.00492544492544585*G0_0_1_0_0_0 - 0.00687510020843354*G0_0_1_0_0_1 - 0.0965592432259096*G0_0_1_0_0_2 - 0.00687510020843355*G0_0_1_0_1_0 - 0.0107744107744107*G0_0_1_0_1_1 - 0.0229854096520763*G0_0_1_0_1_2 - 0.0965592432259096*G0_0_1_0_2_0 - 0.0229854096520763*G0_0_1_0_2_1 - 0.115234888568222*G0_0_1_0_2_2 - 0.00687510020843354*G0_0_1_1_0_0 - 0.0107744107744107*G0_0_1_1_0_1 - 0.0229854096520763*G0_0_1_1_0_2 - 0.0107744107744107*G0_0_1_1_1_0 - 0.0621837421837418*G0_0_1_1_1_1 - 0.0715215648548979*G0_0_1_1_1_2 - 0.0229854096520763*G0_0_1_1_2_0 - 0.0715215648548979*G0_0_1_1_2_1 - 0.171877505210838*G0_0_1_1_2_2 - 0.0965592432259096*G0_0_1_2_0_0 - 0.0229854096520763*G0_0_1_2_0_1 - 0.115234888568222*G0_0_1_2_0_2 - 0.0229854096520763*G0_0_1_2_1_0 - 0.0715215648548979*G0_0_1_2_1_1 - 0.171877505210838*G0_0_1_2_1_2 - 0.115234888568222*G0_0_1_2_2_0 - 0.171877505210838*G0_0_1_2_2_1 - 0.81454545454545*G0_0_1_2_2_2 - 0.236421356421354*G0_1_0_0_0_0 - 0.048741382074715*G0_1_0_0_0_1 - 0.0850665383998715*G0_1_0_0_0_2 - 0.048741382074715*G0_1_0_0_1_0 - 0.0230880230880229*G0_1_0_0_1_1 - 0.0229854096520763*G0_1_0_0_1_2 - 0.0850665383998715*G0_1_0_0_2_0 - 0.0229854096520763*G0_1_0_0_2_1 - 0.12672759339426*G0_1_0_0_2_2 - 0.048741382074715*G0_1_0_1_0_0 - 0.0230880230880229*G0_1_0_1_0_1 - 0.0229854096520763*G0_1_0_1_0_2 - 0.0230880230880229*G0_1_0_1_1_0 - 0.0621837421837421*G0_1_0_1_1_1 - 0.0592079525412857*G0_1_0_1_1_2 - 0.0229854096520763*G0_1_0_1_2_0 - 0.0592079525412857*G0_1_0_1_2_1 - 0.130011223344556*G0_1_0_1_2_2 - 0.0850665383998715*G0_1_0_2_0_0 - 0.0229854096520763*G0_1_0_2_0_1 - 0.12672759339426*G0_1_0_2_0_2 - 0.0229854096520763*G0_1_0_2_1_0 - 0.0592079525412857*G0_1_0_2_1_1 - 0.130011223344556*G0_1_0_2_1_2 - 0.12672759339426*G0_1_0_2_2_0 - 0.130011223344556*G0_1_0_2_2_1 - 0.583049543049543*G0_1_0_2_2_2 + 0.578124098124096*G0_1_1_0_0_0 + 0.123136123136123*G0_1_1_0_0_1 + 0.03016835016835*G0_1_1_0_0_2 + 0.123136123136123*G0_1_1_0_1_0 + 0.0484335417668749*G0_1_1_0_1_1 + 0.03016835016835*G0_1_1_0_2_0 - 0.0301683501683501*G0_1_1_0_2_2 + 0.123136123136123*G0_1_1_1_0_0 + 0.0484335417668749*G0_1_1_1_0_1 + 0.0484335417668749*G0_1_1_1_1_0 - 0.0484335417668749*G0_1_1_1_1_2 - 0.0484335417668749*G0_1_1_1_2_1 - 0.123136123136123*G0_1_1_1_2_2 + 0.03016835016835*G0_1_1_2_0_0 - 0.0301683501683501*G0_1_1_2_0_2 - 0.0484335417668749*G0_1_1_2_1_1 - 0.123136123136123*G0_1_1_2_1_2 - 0.0301683501683501*G0_1_1_2_2_0 - 0.123136123136123*G0_1_1_2_2_1 - 0.578124098124095*G0_1_1_2_2_2;
    A[218] = A[134] + 0.0252429052429049*G0_0_1_0_0_0 + 0.000307840307840302*G0_0_1_0_0_1 + 0.0557190957190956*G0_0_1_0_0_2 + 0.000307840307840301*G0_0_1_0_1_0 - 0.00379669713003041*G0_0_1_0_1_1 + 0.00123136123136125*G0_0_1_0_1_2 + 0.0557190957190956*G0_0_1_0_2_0 + 0.00123136123136125*G0_0_1_0_2_1 + 0.067211800545134*G0_0_1_0_2_2 + 0.000307840307840302*G0_0_1_1_0_0 - 0.00379669713003041*G0_0_1_1_0_1 + 0.00123136123136125*G0_0_1_1_0_2 - 0.00379669713003041*G0_0_1_1_1_0 - 0.0116979316979315*G0_0_1_1_1_1 - 0.0161103094436427*G0_0_1_1_1_2 + 0.00123136123136125*G0_0_1_1_2_0 - 0.0161103094436427*G0_0_1_1_2_1 - 0.0415584415584412*G0_0_1_1_2_2 + 0.0557190957190956*G0_0_1_2_0_0 + 0.00123136123136125*G0_0_1_2_0_1 + 0.067211800545134*G0_0_1_2_0_2 + 0.00123136123136125*G0_0_1_2_1_0 - 0.0161103094436427*G0_0_1_2_1_1 - 0.0415584415584412*G0_0_1_2_1_2 + 0.067211800545134*G0_0_1_2_2_0 - 0.0415584415584412*G0_0_1_2_2_1 - 0.206253006253003*G0_0_1_2_2_2 - 0.0252429052429049*G0_1_0_0_0_0 - 0.000307840307840302*G0_1_0_0_0_1 - 0.0557190957190956*G0_1_0_0_0_2 - 0.000307840307840302*G0_1_0_0_1_0 + 0.00379669713003041*G0_1_0_0_1_1 - 0.00123136123136125*G0_1_0_0_1_2 - 0.0557190957190956*G0_1_0_0_2_0 - 0.00123136123136125*G0_1_0_0_2_1 - 0.067211800545134*G0_1_0_0_2_2 - 0.000307840307840302*G0_1_0_1_0_0 + 0.00379669713003041*G0_1_0_1_0_1 - 0.00123136123136125*G0_1_0_1_0_2 + 0.00379669713003041*G0_1_0_1_1_0 + 0.0116979316979315*G0_1_0_1_1_1 + 0.0161103094436427*G0_1_0_1_1_2 - 0.00123136123136125*G0_1_0_1_2_0 + 0.0161103094436427*G0_1_0_1_2_1 + 0.0415584415584413*G0_1_0_1_2_2 - 0.0557190957190956*G0_1_0_2_0_0 - 0.00123136123136125*G0_1_0_2_0_1 - 0.067211800545134*G0_1_0_2_0_2 - 0.00123136123136125*G0_1_0_2_1_0 + 0.0161103094436427*G0_1_0_2_1_1 + 0.0415584415584413*G0_1_0_2_1_2 - 0.067211800545134*G0_1_0_2_2_0 + 0.0415584415584413*G0_1_0_2_2_1 + 0.206253006253003*G0_1_0_2_2_2;
    A[215] = -A[218] + 0.0369408369408365*G0_0_1_0_0_0 + 0.00410453743787067*G0_0_1_0_0_1 + 0.0718294051627384*G0_0_1_0_0_2 + 0.00410453743787067*G0_0_1_0_1_0 - 0.00410453743787082*G0_0_1_0_1_1 + 0.0718294051627384*G0_0_1_0_2_0 + 0.108770242103575*G0_0_1_0_2_2 + 0.00410453743787067*G0_0_1_1_0_0 - 0.00410453743787082*G0_0_1_1_0_1 - 0.00410453743787082*G0_0_1_1_1_0 - 0.0369408369408367*G0_0_1_1_1_1 - 0.0718294051627382*G0_0_1_1_1_2 - 0.0718294051627382*G0_0_1_1_2_1 - 0.108770242103575*G0_0_1_1_2_2 + 0.0718294051627384*G0_0_1_2_0_0 + 0.108770242103575*G0_0_1_2_0_2 - 0.0718294051627382*G0_0_1_2_1_1 - 0.108770242103575*G0_0_1_2_1_2 + 0.108770242103575*G0_0_1_2_2_0 - 0.108770242103575*G0_0_1_2_2_1 - 0.204816418149751*G0_1_1_0_0_0 - 0.104460477793811*G0_1_1_0_0_1 - 0.0248324514991181*G0_1_1_0_0_2 - 0.104460477793811*G0_1_1_0_1_0 - 0.108565015231681*G0_1_1_0_1_1 - 0.0285265351932018*G0_1_1_0_1_2 - 0.0248324514991181*G0_1_1_0_2_0 - 0.0285265351932018*G0_1_1_0_2_1 - 0.0256533589866923*G0_1_1_0_2_2 - 0.104460477793811*G0_1_1_1_0_0 - 0.108565015231681*G0_1_1_1_0_1 - 0.0285265351932018*G0_1_1_1_0_2 - 0.108565015231681*G0_1_1_1_1_0 - 0.241757255090588*G0_1_1_1_1_1 - 0.0966618566618563*G0_1_1_1_1_2 - 0.0285265351932018*G0_1_1_1_2_0 - 0.0966618566618563*G0_1_1_1_2_1 - 0.134423601090267*G0_1_1_1_2_2 - 0.0248324514991181*G0_1_1_2_0_0 - 0.0285265351932018*G0_1_1_2_0_1 - 0.0256533589866923*G0_1_1_2_0_2 - 0.0285265351932018*G0_1_1_2_1_0 - 0.0966618566618563*G0_1_1_2_1_1 - 0.134423601090267*G0_1_1_2_1_2 - 0.0256533589866923*G0_1_1_2_2_0 - 0.134423601090267*G0_1_1_2_2_1 - 0.201122334455667*G0_1_1_2_2_2;
    A[69] = A[139] - 0.00369408369408463*G0_0_1_0_0_0 + 0.000359147025813658*G0_0_1_0_0_2 + 0.00228314894981558*G0_0_1_0_1_1 - 0.00110309443642778*G0_0_1_0_1_2 + 0.000359147025813658*G0_0_1_0_2_0 - 0.00110309443642778*G0_0_1_0_2_1 + 0.000179573512906818*G0_0_1_0_2_2 + 0.00228314894981558*G0_0_1_1_0_1 - 0.00110309443642778*G0_0_1_1_0_2 + 0.00228314894981558*G0_0_1_1_1_0 - 0.00246272246272288*G0_0_1_1_1_1 + 0.0103383036716369*G0_0_1_1_1_2 - 0.00110309443642778*G0_0_1_1_2_0 + 0.0103383036716369*G0_0_1_1_2_1 - 0.00359147025813697*G0_0_1_1_2_2 + 0.000359147025813658*G0_0_1_2_0_0 - 0.00110309443642778*G0_0_1_2_0_1 + 0.000179573512906817*G0_0_1_2_0_2 - 0.00110309443642778*G0_0_1_2_1_0 + 0.0103383036716369*G0_0_1_2_1_1 - 0.00359147025813697*G0_0_1_2_1_2 + 0.000179573512906817*G0_0_1_2_2_0 - 0.00359147025813698*G0_0_1_2_2_1 - 0.015776815776816*G0_0_1_2_2_2 + 0.00369408369408463*G0_1_0_0_0_0 - 0.000359147025813658*G0_1_0_0_0_2 - 0.00228314894981558*G0_1_0_0_1_1 + 0.00110309443642778*G0_1_0_0_1_2 - 0.000359147025813658*G0_1_0_0_2_0 + 0.00110309443642778*G0_1_0_0_2_1 - 0.000179573512906818*G0_1_0_0_2_2 - 0.00228314894981558*G0_1_0_1_0_1 + 0.00110309443642778*G0_1_0_1_0_2 - 0.00228314894981558*G0_1_0_1_1_0 + 0.00246272246272286*G0_1_0_1_1_1 - 0.0103383036716369*G0_1_0_1_1_2 + 0.00110309443642778*G0_1_0_1_2_0 - 0.0103383036716369*G0_1_0_1_2_1 + 0.00359147025813697*G0_1_0_1_2_2 - 0.000359147025813658*G0_1_0_2_0_0 + 0.00110309443642778*G0_1_0_2_0_1 - 0.000179573512906818*G0_1_0_2_0_2 + 0.00110309443642778*G0_1_0_2_1_0 - 0.0103383036716369*G0_1_0_2_1_1 + 0.00359147025813697*G0_1_0_2_1_2 - 0.000179573512906817*G0_1_0_2_2_0 + 0.00359147025813698*G0_1_0_2_2_1 + 0.015776815776816*G0_1_0_2_2_2;
    A[94] = A[69] - 0.0122109988776657*G0_0_0_0_0_0 - 0.00133397466730797*G0_0_0_0_0_1 - 0.00133397466730797*G0_0_0_0_1_0 + 0.00115440115440115*G0_0_0_0_1_1 - 0.000384800384800394*G0_0_0_0_1_2 - 0.000384800384800394*G0_0_0_0_2_1 - 0.00525893859227198*G0_0_0_0_2_2 - 0.00133397466730797*G0_0_0_1_0_0 + 0.00115440115440115*G0_0_0_1_0_1 - 0.000384800384800394*G0_0_0_1_0_2 + 0.00115440115440115*G0_0_0_1_1_0 - 0.0150585217251884*G0_0_0_1_1_1 - 0.00867083533750204*G0_0_0_1_1_2 - 0.000384800384800393*G0_0_0_1_2_0 - 0.00867083533750204*G0_0_0_1_2_1 - 0.0157768157768158*G0_0_0_1_2_2 - 0.000384800384800394*G0_0_0_2_0_1 - 0.00525893859227198*G0_0_0_2_0_2 - 0.000384800384800394*G0_0_0_2_1_0 - 0.00867083533750204*G0_0_0_2_1_1 - 0.0157768157768158*G0_0_0_2_1_2 - 0.00525893859227198*G0_0_0_2_2_0 - 0.0157768157768158*G0_0_0_2_2_1 + 0.0345807279140601*G0_0_0_2_2_2 - 0.00169312169312159*G0_0_1_0_0_1 + 0.00169312169312178*G0_0_1_0_0_2 - 0.00169312169312159*G0_0_1_0_1_0 + 0.00169312169312165*G0_0_1_0_1_1 + 0.00169312169312178*G0_0_1_0_2_0 - 0.00169312169312165*G0_0_1_0_2_2 - 0.00169312169312159*G0_0_1_1_0_0 + 0.00169312169312165*G0_0_1_1_0_1 + 0.00169312169312165*G0_0_1_1_1_0 - 0.0304761904761907*G0_0_1_1_1_1 - 0.00507936507936515*G0_0_1_1_1_2 - 0.00507936507936515*G0_0_1_1_2_1 + 0.005079365079365*G0_0_1_1_2_2 + 0.00169312169312178*G0_0_1_2_0_0 - 0.00169312169312165*G0_0_1_2_0_2 - 0.00507936507936516*G0_0_1_2_1_1 + 0.00507936507936499*G0_0_1_2_1_2 - 0.00169312169312165*G0_0_1_2_2_0 + 0.005079365079365*G0_0_1_2_2_1 + 0.0304761904761902*G0_0_1_2_2_2 - 0.00210357543690868*G0_1_0_0_0_1 + 0.00210357543690877*G0_1_0_0_0_2 - 0.00210357543690868*G0_1_0_0_1_0 + 0.00379669713003048*G0_1_0_0_1_1 + 0.00210357543690877*G0_1_0_0_2_0 - 0.00379669713003046*G0_1_0_0_2_2 - 0.00210357543690868*G0_1_0_1_0_0 + 0.00379669713003047*G0_1_0_1_0_1 + 0.00379669713003047*G0_1_0_1_1_0 - 0.0171620971620974*G0_1_0_1_1_1 + 0.00885040885040881*G0_1_0_1_1_2 + 0.0088504088504088*G0_1_0_1_2_1 - 0.00885040885040879*G0_1_0_1_2_2 + 0.00210357543690877*G0_1_0_2_0_0 - 0.00379669713003046*G0_1_0_2_0_2 + 0.0088504088504088*G0_1_0_2_1_1 - 0.00885040885040879*G0_1_0_2_1_2 - 0.00379669713003046*G0_1_0_2_2_0 - 0.0088504088504088*G0_1_0_2_2_1 + 0.0171620971620969*G0_1_0_2_2_2 + 0.0122109988776668*G0_1_1_0_0_0 + 0.00133397466730808*G0_1_1_0_0_2 + 0.00525893859227194*G0_1_1_0_1_1 + 0.000384800384800394*G0_1_1_0_1_2 + 0.00133397466730808*G0_1_1_0_2_0 + 0.000384800384800394*G0_1_1_0_2_1 - 0.00115440115440113*G0_1_1_0_2_2 + 0.00525893859227194*G0_1_1_1_0_1 + 0.000384800384800393*G0_1_1_1_0_2 + 0.00525893859227193*G0_1_1_1_1_0 - 0.0345807279140612*G0_1_1_1_1_1 + 0.0157768157768157*G0_1_1_1_1_2 + 0.000384800384800393*G0_1_1_1_2_0 + 0.0157768157768157*G0_1_1_1_2_1 + 0.00867083533750198*G0_1_1_1_2_2 + 0.00133397466730808*G0_1_1_2_0_0 + 0.000384800384800393*G0_1_1_2_0_1 - 0.00115440115440113*G0_1_1_2_0_2 + 0.000384800384800393*G0_1_1_2_1_0 + 0.0157768157768157*G0_1_1_2_1_1 + 0.00867083533750198*G0_1_1_2_1_2 - 0.00115440115440113*G0_1_1_2_2_0 + 0.00867083533750198*G0_1_1_2_2_1 + 0.0150585217251881*G0_1_1_2_2_2;
    A[66] = A[94] + 0.00369408369408415*G0_0_1_0_0_0 - 0.000359147025813611*G0_0_1_0_0_1 - 0.000359147025813611*G0_0_1_0_1_0 - 0.000179573512906758*G0_0_1_0_1_1 + 0.00110309443642777*G0_0_1_0_1_2 + 0.00110309443642777*G0_0_1_0_2_1 - 0.00228314894981563*G0_0_1_0_2_2 - 0.00035914702581361*G0_0_1_1_0_0 - 0.000179573512906757*G0_0_1_1_0_1 + 0.00110309443642777*G0_0_1_1_0_2 - 0.000179573512906756*G0_0_1_1_1_0 + 0.0157768157768162*G0_0_1_1_1_1 + 0.00359147025813706*G0_0_1_1_1_2 + 0.00110309443642777*G0_0_1_1_2_0 + 0.00359147025813706*G0_0_1_1_2_1 - 0.0103383036716368*G0_0_1_1_2_2 + 0.00110309443642777*G0_0_1_2_0_1 - 0.00228314894981563*G0_0_1_2_0_2 + 0.00110309443642777*G0_0_1_2_1_0 + 0.00359147025813706*G0_0_1_2_1_1 - 0.0103383036716368*G0_0_1_2_1_2 - 0.00228314894981563*G0_0_1_2_2_0 - 0.0103383036716368*G0_0_1_2_2_1 + 0.00246272246272268*G0_0_1_2_2_2 - 0.00369408369408415*G0_1_0_0_0_0 + 0.000359147025813611*G0_1_0_0_0_1 + 0.000359147025813611*G0_1_0_0_1_0 + 0.000179573512906759*G0_1_0_0_1_1 - 0.00110309443642777*G0_1_0_0_1_2 - 0.00110309443642777*G0_1_0_0_2_1 + 0.00228314894981563*G0_1_0_0_2_2 + 0.000359147025813611*G0_1_0_1_0_0 + 0.000179573512906758*G0_1_0_1_0_1 - 0.00110309443642777*G0_1_0_1_0_2 + 0.000179573512906758*G0_1_0_1_1_0 - 0.0157768157768162*G0_1_0_1_1_1 - 0.00359147025813705*G0_1_0_1_1_2 - 0.00110309443642777*G0_1_0_1_2_0 - 0.00359147025813705*G0_1_0_1_2_1 + 0.0103383036716368*G0_1_0_1_2_2 - 0.00110309443642777*G0_1_0_2_0_1 + 0.00228314894981563*G0_1_0_2_0_2 - 0.00110309443642777*G0_1_0_2_1_0 - 0.00359147025813705*G0_1_0_2_1_1 + 0.0103383036716368*G0_1_0_2_1_2 + 0.00228314894981563*G0_1_0_2_2_0 + 0.0103383036716368*G0_1_0_2_2_1 - 0.00246272246272268*G0_1_0_2_2_2;
    A[48] = -A[56] + 0.0540772807439471*G0_0_0_0_0_0 + 0.0227459783015338*G0_0_0_0_0_1 + 0.0360515204959647*G0_0_0_0_0_2 + 0.0227459783015338*G0_0_0_0_1_0 + 0.0560953449842336*G0_0_0_0_1_1 + 0.0227459783015338*G0_0_0_0_1_2 + 0.0360515204959647*G0_0_0_0_2_0 + 0.0227459783015338*G0_0_0_0_2_1 + 0.0540772807439471*G0_0_0_0_2_2 + 0.0227459783015338*G0_0_0_1_0_0 + 0.0560953449842336*G0_0_0_1_0_1 + 0.0227459783015338*G0_0_0_1_0_2 + 0.0560953449842336*G0_0_0_1_1_0 + 0.238063171396505*G0_0_0_1_1_1 + 0.112190689968467*G0_0_0_1_1_2 + 0.0227459783015338*G0_0_0_1_2_0 + 0.112190689968467*G0_0_0_1_2_1 + 0.0682379349046014*G0_0_0_1_2_2 + 0.0360515204959647*G0_0_0_2_0_0 + 0.0227459783015338*G0_0_0_2_0_1 + 0.0540772807439471*G0_0_0_2_0_2 + 0.0227459783015338*G0_0_0_2_1_0 + 0.112190689968467*G0_0_0_2_1_1 + 0.0682379349046014*G0_0_0_2_1_2 + 0.0540772807439471*G0_0_0_2_2_0 + 0.0682379349046014*G0_0_0_2_2_1 + 0.216309122975788*G0_0_0_2_2_2 + 0.00769600769600771*G0_1_0_0_0_0 + 0.0123136123136122*G0_1_0_0_0_1 + 0.00256533589866924*G0_1_0_0_0_2 + 0.0123136123136122*G0_1_0_0_1_0 + 0.0266794933461597*G0_1_0_0_1_1 + 0.00615680615680612*G0_1_0_0_1_2 + 0.00256533589866924*G0_1_0_0_2_0 + 0.00615680615680613*G0_1_0_0_2_1 + 0.00256533589866923*G0_1_0_0_2_2 + 0.0123136123136122*G0_1_0_1_0_0 + 0.0266794933461597*G0_1_0_1_0_1 + 0.00615680615680612*G0_1_0_1_0_2 + 0.0266794933461597*G0_1_0_1_1_0 - 0.301683501683502*G0_1_0_1_1_1 + 0.0266794933461599*G0_1_0_1_1_2 + 0.00615680615680613*G0_1_0_1_2_0 + 0.0266794933461599*G0_1_0_1_2_1 + 0.0123136123136123*G0_1_0_1_2_2 + 0.00256533589866924*G0_1_0_2_0_0 + 0.00615680615680612*G0_1_0_2_0_1 + 0.00256533589866923*G0_1_0_2_0_2 + 0.00615680615680613*G0_1_0_2_1_0 + 0.0266794933461599*G0_1_0_2_1_1 + 0.0123136123136123*G0_1_0_2_1_2 + 0.00256533589866923*G0_1_0_2_2_0 + 0.0123136123136123*G0_1_0_2_2_1 + 0.00769600769600758*G0_1_0_2_2_2;
    A[39] = A[41] - 0.0145711079044412*G0_1_0_0_0_0 + 0.00485703596814706*G0_1_0_0_0_1 + 0.000119715675271235*G0_1_0_0_0_2 + 0.00485703596814706*G0_1_0_0_1_0 + 0.00485703596814705*G0_1_0_0_1_1 - 0.000119715675271232*G0_1_0_0_1_2 + 0.000119715675271235*G0_1_0_0_2_0 - 0.000119715675271232*G0_1_0_0_2_1 + 0.00485703596814706*G0_1_0_1_0_0 + 0.00485703596814705*G0_1_0_1_0_1 - 0.000119715675271232*G0_1_0_1_0_2 + 0.00485703596814705*G0_1_0_1_1_0 - 0.0145711079044413*G0_1_0_1_1_1 + 0.000119715675271214*G0_1_0_1_1_2 - 0.000119715675271232*G0_1_0_1_2_0 + 0.000119715675271214*G0_1_0_1_2_1 + 0.000119715675271235*G0_1_0_2_0_0 - 0.000119715675271232*G0_1_0_2_0_1 - 0.000119715675271232*G0_1_0_2_1_0 + 0.000119715675271214*G0_1_0_2_1_1 + 0.028167388167388*G0_1_1_0_0_0 + 0.00712308267863819*G0_1_1_0_0_1 - 0.00142803698359253*G0_1_1_0_0_2 + 0.00712308267863819*G0_1_1_0_1_0 - 0.00226604671049119*G0_1_1_0_1_1 - 0.00142803698359253*G0_1_1_0_2_0 - 0.000487413820747149*G0_1_1_0_2_2 + 0.00712308267863819*G0_1_1_1_0_0 - 0.00226604671049118*G0_1_1_1_0_1 - 0.00226604671049118*G0_1_1_1_1_0 - 0.0427384960718295*G0_1_1_1_1_1 + 0.00154775265886374*G0_1_1_1_1_2 + 0.00154775265886374*G0_1_1_1_2_1 + 0.000487413820747142*G0_1_1_1_2_2 - 0.00142803698359254*G0_1_1_2_0_0 - 0.00048741382074715*G0_1_1_2_0_2 + 0.00154775265886374*G0_1_1_2_1_1 + 0.000487413820747142*G0_1_1_2_1_2 - 0.000487413820747149*G0_1_1_2_2_0 + 0.000487413820747142*G0_1_1_2_2_1;
    A[137] = A[39] - 0.0167644700978034*G0_0_1_0_0_0 + 0.00288600288600287*G0_0_1_0_0_1 + 0.000333493666826997*G0_0_1_0_0_2 + 0.00288600288600287*G0_0_1_0_1_0 + 0.00197103308214417*G0_0_1_0_1_1 + 0.000333493666826997*G0_0_1_0_2_0 + 0.000714018491796277*G0_0_1_0_2_2 + 0.00288600288600287*G0_0_1_1_0_0 + 0.00197103308214417*G0_0_1_1_0_1 + 0.00197103308214417*G0_0_1_1_1_0 + 0.00219336219336221*G0_0_1_1_1_1 - 0.000213777991555775*G0_0_1_1_1_2 - 0.000213777991555775*G0_0_1_1_2_1 - 0.000714018491796262*G0_0_1_1_2_2 + 0.000333493666826997*G0_0_1_2_0_0 + 0.000714018491796277*G0_0_1_2_0_2 - 0.000213777991555775*G0_0_1_2_1_1 - 0.000714018491796262*G0_0_1_2_1_2 + 0.000714018491796277*G0_0_1_2_2_0 - 0.000714018491796262*G0_0_1_2_2_1 + 0.0167644700978034*G0_1_0_0_0_0 - 0.00288600288600287*G0_1_0_0_0_1 - 0.000333493666826997*G0_1_0_0_0_2 - 0.00288600288600287*G0_1_0_0_1_0 - 0.00197103308214417*G0_1_0_0_1_1 - 0.000333493666826997*G0_1_0_0_2_0 - 0.000714018491796277*G0_1_0_0_2_2 - 0.00288600288600287*G0_1_0_1_0_0 - 0.00197103308214417*G0_1_0_1_0_1 - 0.00197103308214417*G0_1_0_1_1_0 - 0.00219336219336221*G0_1_0_1_1_1 + 0.000213777991555775*G0_1_0_1_1_2 + 0.000213777991555775*G0_1_0_1_2_1 + 0.000714018491796262*G0_1_0_1_2_2 - 0.000333493666826996*G0_1_0_2_0_0 - 0.000714018491796277*G0_1_0_2_0_2 + 0.000213777991555775*G0_1_0_2_1_1 + 0.000714018491796261*G0_1_0_2_1_2 - 0.000714018491796277*G0_1_0_2_2_0 + 0.000714018491796262*G0_1_0_2_2_1;
    A[167] = A[137] + 0.0145711079044412*G0_0_1_0_0_0 - 0.00485703596814706*G0_0_1_0_0_1 - 0.000119715675271235*G0_0_1_0_0_2 - 0.00485703596814706*G0_0_1_0_1_0 - 0.00485703596814705*G0_0_1_0_1_1 + 0.000119715675271232*G0_0_1_0_1_2 - 0.000119715675271235*G0_0_1_0_2_0 + 0.000119715675271232*G0_0_1_0_2_1 - 0.00485703596814706*G0_0_1_1_0_0 - 0.00485703596814705*G0_0_1_1_0_1 + 0.000119715675271232*G0_0_1_1_0_2 - 0.00485703596814705*G0_0_1_1_1_0 + 0.0145711079044413*G0_0_1_1_1_1 - 0.000119715675271214*G0_0_1_1_1_2 + 0.000119715675271232*G0_0_1_1_2_0 - 0.000119715675271214*G0_0_1_1_2_1 - 0.000119715675271236*G0_0_1_2_0_0 + 0.000119715675271232*G0_0_1_2_0_1 + 0.000119715675271232*G0_0_1_2_1_0 - 0.000119715675271214*G0_0_1_2_1_1 - 0.028167388167388*G0_1_1_0_0_0 - 0.00712308267863819*G0_1_1_0_0_1 + 0.00142803698359253*G0_1_1_0_0_2 - 0.00712308267863819*G0_1_1_0_1_0 + 0.00226604671049118*G0_1_1_0_1_1 + 0.00142803698359253*G0_1_1_0_2_0 + 0.00048741382074715*G0_1_1_0_2_2 - 0.00712308267863819*G0_1_1_1_0_0 + 0.00226604671049118*G0_1_1_1_0_1 + 0.00226604671049118*G0_1_1_1_1_0 + 0.0427384960718295*G0_1_1_1_1_1 - 0.00154775265886374*G0_1_1_1_1_2 - 0.00154775265886374*G0_1_1_1_2_1 - 0.000487413820747142*G0_1_1_1_2_2 + 0.00142803698359254*G0_1_1_2_0_0 + 0.00048741382074715*G0_1_1_2_0_2 - 0.00154775265886374*G0_1_1_2_1_1 - 0.000487413820747142*G0_1_1_2_1_2 + 0.00048741382074715*G0_1_1_2_2_0 - 0.000487413820747141*G0_1_1_2_2_1;
    A[47] = -A[167] - 0.00187269520602862*G0_0_1_0_0_0 - 0.00174442841109508*G0_0_1_0_0_1 + 0.00164181497514828*G0_0_1_0_0_2 - 0.00174442841109508*G0_0_1_0_1_0 - 0.00135107690663246*G0_0_1_0_1_1 + 0.00126129015017904*G0_0_1_0_1_2 + 0.00164181497514828*G0_0_1_0_2_0 + 0.00126129015017903*G0_0_1_0_2_1 + 0.0107829618940729*G0_0_1_0_2_2 - 0.00174442841109508*G0_0_1_1_0_0 - 0.00135107690663246*G0_0_1_1_0_1 + 0.00126129015017903*G0_0_1_1_0_2 - 0.00135107690663246*G0_0_1_1_1_0 + 0.0288600288600289*G0_0_1_1_1_1 + 0.00494254716476939*G0_0_1_1_1_2 + 0.00126129015017903*G0_0_1_1_2_0 + 0.00494254716476938*G0_0_1_1_2_1 + 0.00268505157394046*G0_0_1_1_2_2 + 0.00164181497514828*G0_0_1_2_0_0 + 0.00126129015017903*G0_0_1_2_0_1 + 0.0107829618940729*G0_0_1_2_0_2 + 0.00126129015017903*G0_0_1_2_1_0 + 0.00494254716476938*G0_0_1_2_1_1 + 0.00268505157394046*G0_0_1_2_1_2 + 0.0107829618940729*G0_0_1_2_2_0 + 0.00268505157394046*G0_0_1_2_2_1 + 0.117748917748917*G0_0_1_2_2_2;
    A[92] = -A[47] - 0.0117748917748917*G0_0_1_0_0_0 - 0.00130832130832131*G0_0_1_0_0_1 - 0.00384800384800382*G0_0_1_0_0_2 - 0.00130832130832131*G0_0_1_0_1_0 + 0.00130832130832129*G0_0_1_0_1_1 - 0.00384800384800382*G0_0_1_0_2_0 + 0.00666987333653998*G0_0_1_0_2_2 - 0.00130832130832131*G0_0_1_1_0_0 + 0.00130832130832129*G0_0_1_1_0_1 + 0.00130832130832129*G0_0_1_1_1_0 + 0.0117748917748917*G0_0_1_1_1_1 + 0.00384800384800383*G0_0_1_1_1_2 + 0.00384800384800383*G0_0_1_1_2_1 - 0.00666987333653995*G0_0_1_1_2_2 - 0.00384800384800382*G0_0_1_2_0_0 + 0.00666987333653999*G0_0_1_2_0_2 + 0.00384800384800383*G0_0_1_2_1_1 - 0.00666987333653995*G0_0_1_2_1_2 + 0.00666987333653999*G0_0_1_2_2_0 - 0.00666987333653995*G0_0_1_2_2_1 - 0.0584896584896582*G0_1_1_0_0_0 - 0.00847415958527067*G0_1_1_0_0_1 - 0.00330073218962106*G0_1_1_0_0_2 - 0.00847415958527067*G0_1_1_0_1_0 - 0.00716583827694939*G0_1_1_0_1_1 - 0.000867938645716424*G0_1_1_0_1_2 - 0.00330073218962106*G0_1_1_0_2_0 - 0.000867938645716424*G0_1_1_0_2_1 - 0.000769600769600781*G0_1_1_0_2_2 - 0.00847415958527067*G0_1_1_1_0_0 - 0.00716583827694939*G0_1_1_1_0_1 - 0.000867938645716424*G0_1_1_1_0_2 - 0.00716583827694939*G0_1_1_1_1_0 - 0.0467147667147668*G0_1_1_1_1_1 + 0.000547271658382748*G0_1_1_1_1_2 - 0.000867938645716424*G0_1_1_1_2_0 + 0.000547271658382748*G0_1_1_1_2_1 - 0.00743947410614076*G0_1_1_1_2_2 - 0.00330073218962106*G0_1_1_2_0_0 - 0.000867938645716424*G0_1_1_2_0_1 - 0.000769600769600781*G0_1_1_2_0_2 - 0.000867938645716424*G0_1_1_2_1_0 + 0.000547271658382747*G0_1_1_2_1_1 - 0.00743947410614076*G0_1_1_2_1_2 - 0.000769600769600781*G0_1_1_2_2_0 - 0.00743947410614076*G0_1_1_2_2_1 - 0.097611030944364*G0_1_1_2_2_2;
    A[121] = A[91] - 0.028167388167388*G0_0_0_0_0_0 + 0.00142803698359253*G0_0_0_0_0_1 - 0.00712308267863817*G0_0_0_0_0_2 + 0.00142803698359253*G0_0_0_0_1_0 + 0.000487413820747155*G0_0_0_0_1_1 - 0.00712308267863817*G0_0_0_0_2_0 + 0.00226604671049116*G0_0_0_0_2_2 + 0.00142803698359253*G0_0_0_1_0_0 + 0.000487413820747155*G0_0_0_1_0_1 + 0.000487413820747155*G0_0_0_1_1_0 - 0.000487413820747139*G0_0_0_1_1_2 - 0.000487413820747139*G0_0_0_1_2_1 - 0.00154775265886376*G0_0_0_1_2_2 - 0.00712308267863817*G0_0_0_2_0_0 + 0.00226604671049116*G0_0_0_2_0_2 - 0.000487413820747139*G0_0_0_2_1_1 - 0.00154775265886376*G0_0_0_2_1_2 + 0.00226604671049116*G0_0_0_2_2_0 - 0.00154775265886376*G0_0_0_2_2_1 + 0.0427384960718292*G0_0_0_2_2_2 + 0.0145711079044413*G0_1_0_0_0_0 - 0.00011971567527122*G0_1_0_0_0_1 - 0.00485703596814705*G0_1_0_0_0_2 - 0.00011971567527122*G0_1_0_0_1_0 + 0.000119715675271233*G0_1_0_0_1_2 - 0.00485703596814705*G0_1_0_0_2_0 + 0.000119715675271233*G0_1_0_0_2_1 - 0.00485703596814706*G0_1_0_0_2_2 - 0.000119715675271221*G0_1_0_1_0_0 + 0.000119715675271233*G0_1_0_1_0_2 + 0.000119715675271233*G0_1_0_1_2_0 - 0.00011971567527123*G0_1_0_1_2_2 - 0.00485703596814705*G0_1_0_2_0_0 + 0.000119715675271233*G0_1_0_2_0_1 - 0.00485703596814706*G0_1_0_2_0_2 + 0.000119715675271233*G0_1_0_2_1_0 - 0.00011971567527123*G0_1_0_2_1_2 - 0.00485703596814706*G0_1_0_2_2_0 - 0.00011971567527123*G0_1_0_2_2_1 + 0.0145711079044411*G0_1_0_2_2_2;
    A[70] = A[121] - 0.00954304954304944*G0_0_0_0_0_0 + 0.0013767302656192*G0_0_0_0_0_1 + 0.000265084709529149*G0_0_0_0_0_2 + 0.0013767302656192*G0_0_0_0_1_0 + 0.009525947303725*G0_0_0_0_1_1 + 0.00024370691037357*G0_0_0_0_1_2 + 0.00026508470952915*G0_0_0_0_2_0 + 0.00024370691037357*G0_0_0_0_2_1 - 0.00516487627598736*G0_0_0_0_2_2 + 0.0013767302656192*G0_0_0_1_0_0 + 0.009525947303725*G0_0_0_1_0_1 + 0.000243706910373569*G0_0_0_1_0_2 + 0.009525947303725*G0_0_0_1_1_0 + 0.000795254128587213*G0_0_0_1_1_1 + 0.00830313719202592*G0_0_0_1_1_2 + 0.000243706910373569*G0_0_0_1_2_0 + 0.00830313719202592*G0_0_0_1_2_1 + 0.00683234461012226*G0_0_0_1_2_2 + 0.000265084709529151*G0_0_0_2_0_0 + 0.000243706910373569*G0_0_0_2_0_1 - 0.00516487627598736*G0_0_0_2_0_2 + 0.00024370691037357*G0_0_0_2_1_0 + 0.00830313719202593*G0_0_0_2_1_1 + 0.00683234461012226*G0_0_0_2_1_2 - 0.00516487627598736*G0_0_0_2_2_0 + 0.00683234461012226*G0_0_0_2_2_1 - 0.0476639409972739*G0_0_0_2_2_2 + 0.00835016835016828*G0_0_1_0_0_0 + 0.0108898508898508*G0_0_1_0_0_1 + 0.000654160654160622*G0_0_1_0_0_2 + 0.0108898508898508*G0_0_1_0_1_0 + 0.0163155363155362*G0_0_1_0_1_1 + 0.00284752284752283*G0_0_1_0_1_2 + 0.000654160654160623*G0_0_1_0_2_0 + 0.00284752284752283*G0_0_1_0_2_1 - 0.000538720538720578*G0_0_1_0_2_2 + 0.0108898508898508*G0_0_1_1_0_0 + 0.0163155363155362*G0_0_1_1_0_1 + 0.00284752284752283*G0_0_1_1_0_2 + 0.0163155363155362*G0_0_1_1_1_0 - 0.0111592111592111*G0_0_1_1_1_1 + 0.0138912938912937*G0_0_1_1_1_2 + 0.00284752284752283*G0_0_1_1_2_0 + 0.0138912938912937*G0_0_1_1_2_1 + 0.0145839345839345*G0_0_1_1_2_2 + 0.000654160654160622*G0_0_1_2_0_0 + 0.00284752284752283*G0_0_1_2_0_1 - 0.000538720538720579*G0_0_1_2_0_2 + 0.00284752284752283*G0_0_1_2_1_0 + 0.0138912938912938*G0_0_1_2_1_1 + 0.0145839345839345*G0_0_1_2_1_2 - 0.000538720538720578*G0_0_1_2_2_0 + 0.0145839345839345*G0_0_1_2_2_1 + 0.015161135161135*G0_0_1_2_2_2 + 0.0037325637325636*G0_1_0_0_0_0 + 0.010522152744375*G0_1_0_0_0_1 + 0.000277911389022522*G0_1_0_0_0_2 + 0.010522152744375*G0_1_0_0_1_0 + 0.0292619314841536*G0_1_0_0_1_1 - 0.00225322003099781*G0_1_0_0_1_2 + 0.000277911389022522*G0_1_0_0_2_0 - 0.00225322003099781*G0_1_0_0_2_1 + 0.010522152744375*G0_1_0_1_0_0 + 0.0292619314841536*G0_1_0_1_0_1 - 0.00225322003099781*G0_1_0_1_0_2 + 0.0292619314841536*G0_1_0_1_1_0 - 0.0342472342472352*G0_1_0_1_1_1 + 0.0282657260435036*G0_1_0_1_1_2 - 0.00225322003099781*G0_1_0_1_2_0 + 0.0282657260435036*G0_1_0_1_2_1 + 0.0147635080968413*G0_1_0_1_2_2 + 0.000277911389022522*G0_1_0_2_0_0 - 0.00225322003099781*G0_1_0_2_0_1 - 0.00225322003099781*G0_1_0_2_1_0 + 0.0282657260435035*G0_1_0_2_1_1 + 0.0147635080968413*G0_1_0_2_1_2 + 0.0147635080968413*G0_1_0_2_2_1 - 0.00841430174763503*G0_1_0_2_2_2 + 0.0167003367003367*G0_1_1_0_0_0 + 0.0253198653198652*G0_1_1_0_0_1 - 0.00223184223184225*G0_1_1_0_0_2 + 0.0253198653198652*G0_1_1_0_1_0 + 0.0438672438672436*G0_1_1_0_1_1 + 0.000654160654160637*G0_1_1_0_1_2 - 0.00223184223184225*G0_1_1_0_2_0 + 0.000654160654160636*G0_1_1_0_2_1 - 0.00223184223184224*G0_1_1_0_2_2 + 0.0253198653198652*G0_1_1_1_0_0 + 0.0438672438672436*G0_1_1_1_0_1 + 0.000654160654160637*G0_1_1_1_0_2 + 0.0438672438672436*G0_1_1_1_1_0 - 0.0454064454064458*G0_1_1_1_1_1 + 0.0438672438672436*G0_1_1_1_1_2 + 0.000654160654160636*G0_1_1_1_2_0 + 0.0438672438672436*G0_1_1_1_2_1 + 0.0253198653198651*G0_1_1_1_2_2 - 0.00223184223184225*G0_1_1_2_0_0 + 0.000654160654160636*G0_1_1_2_0_1 - 0.00223184223184224*G0_1_1_2_0_2 + 0.000654160654160636*G0_1_1_2_1_0 + 0.0438672438672436*G0_1_1_2_1_1 + 0.0253198653198651*G0_1_1_2_1_2 - 0.00223184223184224*G0_1_1_2_2_0 + 0.0253198653198651*G0_1_1_2_2_1 + 0.0167003367003367*G0_1_1_2_2_2;
    A[157] = A[70] - 0.000461760461760777*G0_0_0_0_0_0 + 0.00754208754208745*G0_0_0_0_0_1 + 0.00477152477152471*G0_0_0_0_0_2 + 0.00754208754208745*G0_0_0_0_1_0 - 0.00754208754208745*G0_0_0_0_1_1 + 0.00477152477152471*G0_0_0_0_2_0 + 0.00454064454064446*G0_0_0_0_2_2 + 0.00754208754208745*G0_0_0_1_0_0 - 0.00754208754208745*G0_0_0_1_0_1 - 0.00754208754208745*G0_0_0_1_1_0 + 0.000461760461760431*G0_0_0_1_1_1 - 0.00477152477152461*G0_0_0_1_1_2 - 0.00477152477152461*G0_0_0_1_2_1 - 0.00454064454064446*G0_0_0_1_2_2 + 0.00477152477152471*G0_0_0_2_0_0 + 0.00454064454064446*G0_0_0_2_0_2 - 0.00477152477152462*G0_0_0_2_1_1 - 0.00454064454064446*G0_0_0_2_1_2 + 0.00454064454064446*G0_0_0_2_2_0 - 0.00454064454064446*G0_0_0_2_2_1 + 0.0166233766233773*G0_0_1_0_0_0 - 0.0320538720538717*G0_0_1_0_0_1 - 0.0218181818181816*G0_0_1_0_0_2 - 0.0320538720538717*G0_0_1_0_1_0 - 0.0257816257816255*G0_0_1_0_1_1 - 0.000577200577200549*G0_0_1_0_1_2 - 0.0218181818181816*G0_0_1_0_2_0 - 0.000577200577200549*G0_0_1_0_2_1 - 0.00892736892736882*G0_0_1_0_2_2 - 0.0320538720538717*G0_0_1_1_0_0 - 0.0257816257816255*G0_0_1_1_0_1 - 0.000577200577200549*G0_0_1_1_0_2 - 0.0257816257816255*G0_0_1_1_1_0 + 0.000808080808080744*G0_0_1_1_1_1 - 0.0105820105820104*G0_0_1_1_1_2 - 0.000577200577200549*G0_0_1_1_2_0 - 0.0105820105820104*G0_0_1_1_2_1 - 0.0112746512746512*G0_0_1_1_2_2 - 0.0218181818181816*G0_0_1_2_0_0 - 0.00057720057720055*G0_0_1_2_0_1 - 0.00892736892736882*G0_0_1_2_0_2 - 0.000577200577200551*G0_0_1_2_1_0 - 0.0105820105820104*G0_0_1_2_1_1 - 0.0112746512746512*G0_0_1_2_1_2 - 0.00892736892736882*G0_0_1_2_2_0 - 0.0112746512746512*G0_0_1_2_2_1 - 0.0255122655122655*G0_0_1_2_2_2 + 0.000346320346320462*G0_1_0_0_0_0 - 0.0182395382395382*G0_1_0_0_0_1 - 0.00581048581048589*G0_1_0_0_0_2 - 0.0182395382395382*G0_1_0_0_1_0 - 0.0395959595959594*G0_1_0_0_1_1 - 0.000577200577200573*G0_1_0_0_1_2 - 0.00581048581048589*G0_1_0_0_2_0 - 0.000577200577200572*G0_1_0_0_2_1 - 0.00673400673400684*G0_1_0_0_2_2 - 0.0182395382395382*G0_1_0_1_0_0 - 0.0395959595959594*G0_1_0_1_0_1 - 0.000577200577200572*G0_1_0_1_0_2 - 0.0395959595959594*G0_1_0_1_1_0 + 0.0170851370851376*G0_1_0_1_1_1 - 0.0265897065897063*G0_1_0_1_1_2 - 0.000577200577200572*G0_1_0_1_2_0 - 0.0265897065897063*G0_1_0_1_2_1 - 0.0134680134680133*G0_1_0_1_2_2 - 0.00581048581048589*G0_1_0_2_0_0 - 0.000577200577200572*G0_1_0_2_0_1 - 0.00673400673400684*G0_1_0_2_0_2 - 0.000577200577200571*G0_1_0_2_1_0 - 0.0265897065897063*G0_1_0_2_1_1 - 0.0134680134680133*G0_1_0_2_1_2 - 0.00673400673400684*G0_1_0_2_2_0 - 0.0134680134680133*G0_1_0_2_2_1 - 0.0255122655122656*G0_1_0_2_2_2 - 0.0259740259740252*G0_1_1_0_0_0 - 0.0189321789321787*G0_1_1_0_0_1 + 0.0110437710437711*G0_1_1_0_0_2 - 0.0189321789321787*G0_1_1_0_1_0 - 0.0389033189033186*G0_1_1_0_1_1 - 0.00057720057720055*G0_1_1_0_1_2 + 0.0110437710437711*G0_1_1_0_2_0 - 0.000577200577200548*G0_1_1_0_2_1 + 0.00350168350168347*G0_1_1_0_2_2 - 0.0189321789321787*G0_1_1_1_0_0 - 0.0389033189033186*G0_1_1_1_0_1 - 0.00057720057720055*G0_1_1_1_0_2 - 0.0389033189033186*G0_1_1_1_1_0 + 0.0434054834054837*G0_1_1_1_1_1 - 0.0434439634439631*G0_1_1_1_1_2 - 0.000577200577200548*G0_1_1_1_2_0 - 0.0434439634439631*G0_1_1_1_2_1 - 0.0237037037037035*G0_1_1_1_2_2 + 0.0110437710437711*G0_1_1_2_0_0 - 0.000577200577200548*G0_1_1_2_0_1 + 0.00350168350168347*G0_1_1_2_0_2 - 0.000577200577200548*G0_1_1_2_1_0 - 0.0434439634439631*G0_1_1_2_1_1 - 0.0237037037037035*G0_1_1_2_1_2 + 0.00350168350168347*G0_1_1_2_2_0 - 0.0237037037037035*G0_1_1_2_2_1 - 0.0255122655122654*G0_1_1_2_2_2;
    A[76] = -A[121] - 0.00187269520602862*G0_1_0_0_0_0 + 0.0016418149751483*G0_1_0_0_0_1 - 0.00174442841109509*G0_1_0_0_0_2 + 0.0016418149751483*G0_1_0_0_1_0 + 0.010782961894073*G0_1_0_0_1_1 + 0.00126129015017904*G0_1_0_0_1_2 - 0.00174442841109509*G0_1_0_0_2_0 + 0.00126129015017904*G0_1_0_0_2_1 - 0.00135107690663248*G0_1_0_0_2_2 + 0.0016418149751483*G0_1_0_1_0_0 + 0.010782961894073*G0_1_0_1_0_1 + 0.00126129015017904*G0_1_0_1_0_2 + 0.010782961894073*G0_1_0_1_1_0 + 0.117748917748918*G0_1_0_1_1_1 + 0.00268505157394047*G0_1_0_1_1_2 + 0.00126129015017904*G0_1_0_1_2_0 + 0.00268505157394047*G0_1_0_1_2_1 + 0.00494254716476936*G0_1_0_1_2_2 - 0.00174442841109509*G0_1_0_2_0_0 + 0.00126129015017904*G0_1_0_2_0_1 - 0.00135107690663247*G0_1_0_2_0_2 + 0.00126129015017904*G0_1_0_2_1_0 + 0.00268505157394047*G0_1_0_2_1_1 + 0.00494254716476936*G0_1_0_2_1_2 - 0.00135107690663247*G0_1_0_2_2_0 + 0.00494254716476936*G0_1_0_2_2_1 + 0.0288600288600286*G0_1_0_2_2_2;
    A[154] = A[70] - 0.00681096681096695*G0_0_1_0_0_0 - 0.000153920153920052*G0_0_1_0_0_1 - 0.0023472823472823*G0_0_1_0_0_2 - 0.000153920153920047*G0_0_1_0_1_0 + 0.0136604136604137*G0_0_1_0_1_1 - 0.00504088504088502*G0_0_1_0_1_2 - 0.0023472823472823*G0_0_1_0_2_0 - 0.00504088504088502*G0_0_1_0_2_1 - 0.00234728234728229*G0_0_1_0_2_2 - 0.000153920153920049*G0_0_1_1_0_0 + 0.0136604136604137*G0_0_1_1_0_1 - 0.00504088504088502*G0_0_1_1_0_2 + 0.0136604136604137*G0_0_1_1_1_0 - 0.0230880230880238*G0_0_1_1_1_1 + 0.0136604136604136*G0_0_1_1_1_2 - 0.00504088504088502*G0_0_1_1_2_0 + 0.0136604136604136*G0_0_1_1_2_1 - 0.000153920153920177*G0_0_1_1_2_2 - 0.0023472823472823*G0_0_1_2_0_0 - 0.00504088504088502*G0_0_1_2_0_1 - 0.00234728234728229*G0_0_1_2_0_2 - 0.00504088504088503*G0_0_1_2_1_0 + 0.0136604136604135*G0_0_1_2_1_1 - 0.000153920153920184*G0_0_1_2_1_2 - 0.00234728234728229*G0_0_1_2_2_0 - 0.000153920153920179*G0_0_1_2_2_1 - 0.00681096681096659*G0_0_1_2_2_2 + 0.00681096681096695*G0_1_0_0_0_0 + 0.000153920153920052*G0_1_0_0_0_1 + 0.0023472823472823*G0_1_0_0_0_2 + 0.000153920153920047*G0_1_0_0_1_0 - 0.0136604136604137*G0_1_0_0_1_1 + 0.00504088504088502*G0_1_0_0_1_2 + 0.0023472823472823*G0_1_0_0_2_0 + 0.00504088504088502*G0_1_0_0_2_1 + 0.00234728234728229*G0_1_0_0_2_2 + 0.000153920153920049*G0_1_0_1_0_0 - 0.0136604136604137*G0_1_0_1_0_1 + 0.00504088504088502*G0_1_0_1_0_2 - 0.0136604136604137*G0_1_0_1_1_0 + 0.0230880230880238*G0_1_0_1_1_1 - 0.0136604136604136*G0_1_0_1_1_2 + 0.00504088504088502*G0_1_0_1_2_0 - 0.0136604136604136*G0_1_0_1_2_1 + 0.000153920153920175*G0_1_0_1_2_2 + 0.0023472823472823*G0_1_0_2_0_0 + 0.00504088504088502*G0_1_0_2_0_1 + 0.00234728234728229*G0_1_0_2_0_2 + 0.00504088504088503*G0_1_0_2_1_0 - 0.0136604136604136*G0_1_0_2_1_1 + 0.000153920153920179*G0_1_0_2_1_2 + 0.00234728234728229*G0_1_0_2_2_0 + 0.000153920153920174*G0_1_0_2_2_1 + 0.00681096681096659*G0_1_0_2_2_2;
    A[109] = A[70] + 0.0255122655122654*G0_0_0_0_0_0 - 0.00350168350168353*G0_0_0_0_0_1 + 0.0237037037037036*G0_0_0_0_0_2 - 0.00350168350168353*G0_0_0_0_1_0 - 0.011043771043771*G0_0_0_0_1_1 + 0.000577200577200586*G0_0_0_0_1_2 + 0.0237037037037036*G0_0_0_0_2_0 + 0.000577200577200585*G0_0_0_0_2_1 + 0.0434439634439634*G0_0_0_0_2_2 - 0.00350168350168353*G0_0_0_1_0_0 - 0.011043771043771*G0_0_0_1_0_1 + 0.000577200577200586*G0_0_0_1_0_2 - 0.011043771043771*G0_0_0_1_1_0 + 0.025974025974026*G0_0_0_1_1_1 + 0.018932178932179*G0_0_0_1_1_2 + 0.000577200577200585*G0_0_0_1_2_0 + 0.018932178932179*G0_0_0_1_2_1 + 0.0389033189033189*G0_0_0_1_2_2 + 0.0237037037037036*G0_0_0_2_0_0 + 0.000577200577200585*G0_0_0_2_0_1 + 0.0434439634439634*G0_0_0_2_0_2 + 0.000577200577200585*G0_0_0_2_1_0 + 0.018932178932179*G0_0_0_2_1_1 + 0.0389033189033189*G0_0_0_2_1_2 + 0.0434439634439634*G0_0_0_2_2_0 + 0.0389033189033189*G0_0_0_2_2_1 - 0.0434054834054816*G0_0_0_2_2_2 - 0.0102356902356901*G0_0_1_0_0_1 + 0.0102356902356903*G0_0_1_0_0_2 - 0.0102356902356901*G0_0_1_0_1_0 - 0.0168542568542566*G0_0_1_0_1_1 + 0.0102356902356903*G0_0_1_0_2_0 + 0.016854256854257*G0_0_1_0_2_2 - 0.0102356902356901*G0_0_1_1_0_0 - 0.0168542568542566*G0_0_1_1_0_1 - 0.0168542568542566*G0_0_1_1_1_0 + 0.0263203463203471*G0_0_1_1_1_1 + 0.000692640692640903*G0_0_1_1_1_2 + 0.000692640692640906*G0_0_1_1_2_1 - 0.000692640692640484*G0_0_1_1_2_2 + 0.0102356902356903*G0_0_1_2_0_0 + 0.016854256854257*G0_0_1_2_0_2 + 0.000692640692640901*G0_0_1_2_1_1 - 0.000692640692640488*G0_0_1_2_1_2 + 0.016854256854257*G0_0_1_2_2_0 - 0.000692640692640486*G0_0_1_2_2_1 - 0.0263203463203449*G0_0_1_2_2_2 - 0.0124290524290525*G0_1_0_0_0_1 + 0.0124290524290524*G0_1_0_0_0_2 - 0.0124290524290525*G0_1_0_0_1_0 - 0.0328619528619527*G0_1_0_0_1_1 + 0.0124290524290524*G0_1_0_0_2_0 + 0.0328619528619528*G0_1_0_0_2_2 - 0.0124290524290525*G0_1_0_1_0_0 - 0.0328619528619528*G0_1_0_1_0_1 - 0.0328619528619527*G0_1_0_1_1_0 + 0.0425974025974032*G0_1_0_1_1_1 - 0.013121693121693*G0_1_0_1_1_2 - 0.013121693121693*G0_1_0_1_2_1 + 0.0131216931216931*G0_1_0_1_2_2 + 0.0124290524290524*G0_1_0_2_0_0 + 0.0328619528619528*G0_1_0_2_0_2 - 0.013121693121693*G0_1_0_2_1_1 + 0.0131216931216931*G0_1_0_2_1_2 + 0.0328619528619528*G0_1_0_2_2_0 + 0.0131216931216931*G0_1_0_2_2_1 - 0.0425974025974012*G0_1_0_2_2_2 - 0.0255122655122662*G0_1_1_0_0_0 - 0.0237037037037036*G0_1_1_0_0_1 + 0.00350168350168345*G0_1_1_0_0_2 - 0.0237037037037036*G0_1_1_0_1_0 - 0.0434439634439632*G0_1_1_0_1_1 - 0.000577200577200569*G0_1_1_0_1_2 + 0.00350168350168345*G0_1_1_0_2_0 - 0.000577200577200569*G0_1_1_0_2_1 + 0.0110437710437711*G0_1_1_0_2_2 - 0.0237037037037036*G0_1_1_1_0_0 - 0.0434439634439632*G0_1_1_1_0_1 - 0.00057720057720057*G0_1_1_1_0_2 - 0.0434439634439632*G0_1_1_1_1_0 + 0.0434054834054844*G0_1_1_1_1_1 - 0.0389033189033186*G0_1_1_1_1_2 - 0.000577200577200569*G0_1_1_1_2_0 - 0.0389033189033186*G0_1_1_1_2_1 - 0.0189321789321787*G0_1_1_1_2_2 + 0.00350168350168345*G0_1_1_2_0_0 - 0.000577200577200569*G0_1_1_2_0_1 + 0.0110437710437711*G0_1_1_2_0_2 - 0.000577200577200569*G0_1_1_2_1_0 - 0.0389033189033186*G0_1_1_2_1_1 - 0.0189321789321787*G0_1_1_2_1_2 + 0.0110437710437711*G0_1_1_2_2_0 - 0.0189321789321787*G0_1_1_2_2_1 - 0.025974025974025*G0_1_1_2_2_2;
    A[67] = A[109] - 0.00681096681096741*G0_0_1_0_0_0 - 0.00234728234728246*G0_0_1_0_0_1 - 0.000153920153920253*G0_0_1_0_0_2 - 0.00234728234728246*G0_0_1_0_1_0 - 0.00234728234728246*G0_0_1_0_1_1 - 0.00504088504088506*G0_0_1_0_1_2 - 0.000153920153920255*G0_0_1_0_2_0 - 0.00504088504088506*G0_0_1_0_2_1 + 0.0136604136604135*G0_0_1_0_2_2 - 0.00234728234728246*G0_0_1_1_0_0 - 0.00234728234728246*G0_0_1_1_0_1 - 0.00504088504088506*G0_0_1_1_0_2 - 0.00234728234728246*G0_0_1_1_1_0 - 0.00681096681096773*G0_0_1_1_1_1 - 0.000153920153920347*G0_0_1_1_1_2 - 0.00504088504088506*G0_0_1_1_2_0 - 0.000153920153920347*G0_0_1_1_2_1 + 0.0136604136604134*G0_0_1_1_2_2 - 0.000153920153920257*G0_0_1_2_0_0 - 0.00504088504088506*G0_0_1_2_0_1 + 0.0136604136604135*G0_0_1_2_0_2 - 0.00504088504088506*G0_0_1_2_1_0 - 0.000153920153920347*G0_0_1_2_1_1 + 0.0136604136604134*G0_0_1_2_1_2 + 0.0136604136604135*G0_0_1_2_2_0 + 0.0136604136604134*G0_0_1_2_2_1 - 0.0230880230880228*G0_0_1_2_2_2 + 0.00681096681096741*G0_1_0_0_0_0 + 0.00234728234728246*G0_1_0_0_0_1 + 0.000153920153920253*G0_1_0_0_0_2 + 0.00234728234728246*G0_1_0_0_1_0 + 0.00234728234728246*G0_1_0_0_1_1 + 0.00504088504088506*G0_1_0_0_1_2 + 0.000153920153920255*G0_1_0_0_2_0 + 0.00504088504088506*G0_1_0_0_2_1 - 0.0136604136604135*G0_1_0_0_2_2 + 0.00234728234728246*G0_1_0_1_0_0 + 0.00234728234728246*G0_1_0_1_0_1 + 0.00504088504088506*G0_1_0_1_0_2 + 0.00234728234728246*G0_1_0_1_1_0 + 0.00681096681096773*G0_1_0_1_1_1 + 0.000153920153920344*G0_1_0_1_1_2 + 0.00504088504088506*G0_1_0_1_2_0 + 0.000153920153920345*G0_1_0_1_2_1 - 0.0136604136604134*G0_1_0_1_2_2 + 0.000153920153920259*G0_1_0_2_0_0 + 0.00504088504088506*G0_1_0_2_0_1 - 0.0136604136604135*G0_1_0_2_0_2 + 0.00504088504088506*G0_1_0_2_1_0 + 0.000153920153920349*G0_1_0_2_1_1 - 0.0136604136604134*G0_1_0_2_1_2 - 0.0136604136604135*G0_1_0_2_2_0 - 0.0136604136604134*G0_1_0_2_2_1 + 0.0230880230880229*G0_1_0_2_2_2;
    A[136] = -A[76] - 0.0584896584896583*G0_0_0_0_0_0 - 0.00330073218962107*G0_0_0_0_0_1 - 0.00847415958527065*G0_0_0_0_0_2 - 0.00330073218962107*G0_0_0_0_1_0 - 0.00076960076960079*G0_0_0_0_1_1 - 0.000867938645716421*G0_0_0_0_1_2 - 0.00847415958527065*G0_0_0_0_2_0 - 0.000867938645716421*G0_0_0_0_2_1 - 0.00716583827694935*G0_0_0_0_2_2 - 0.00330073218962107*G0_0_0_1_0_0 - 0.00076960076960079*G0_0_0_1_0_1 - 0.000867938645716421*G0_0_0_1_0_2 - 0.000769600769600787*G0_0_0_1_1_0 - 0.0976110309443641*G0_0_0_1_1_1 - 0.00743947410614075*G0_0_0_1_1_2 - 0.000867938645716421*G0_0_0_1_2_0 - 0.00743947410614075*G0_0_0_1_2_1 + 0.00054727165838276*G0_0_0_1_2_2 - 0.00847415958527065*G0_0_0_2_0_0 - 0.000867938645716421*G0_0_0_2_0_1 - 0.00716583827694935*G0_0_0_2_0_2 - 0.000867938645716421*G0_0_0_2_1_0 - 0.00743947410614075*G0_0_0_2_1_1 + 0.000547271658382759*G0_0_0_2_1_2 - 0.00716583827694935*G0_0_0_2_2_0 + 0.000547271658382759*G0_0_0_2_2_1 - 0.0467147667147665*G0_0_0_2_2_2 - 0.0117748917748917*G0_1_0_0_0_0 - 0.00384800384800382*G0_1_0_0_0_1 - 0.00130832130832131*G0_1_0_0_0_2 - 0.00384800384800382*G0_1_0_0_1_0 + 0.00666987333653999*G0_1_0_0_1_1 - 0.00130832130832131*G0_1_0_0_2_0 + 0.00130832130832129*G0_1_0_0_2_2 - 0.00384800384800382*G0_1_0_1_0_0 + 0.00666987333654*G0_1_0_1_0_1 + 0.00666987333654*G0_1_0_1_1_0 - 0.00666987333653995*G0_1_0_1_1_2 - 0.00666987333653995*G0_1_0_1_2_1 + 0.00384800384800382*G0_1_0_1_2_2 - 0.00130832130832131*G0_1_0_2_0_0 + 0.0013083213083213*G0_1_0_2_0_2 - 0.00666987333653995*G0_1_0_2_1_1 + 0.00384800384800382*G0_1_0_2_1_2 + 0.0013083213083213*G0_1_0_2_2_0 + 0.00384800384800382*G0_1_0_2_2_1 + 0.0117748917748917*G0_1_0_2_2_2;
    A[87] = -A[132] - 0.0652621452621451*G0_1_0_0_0_0 + 0.00451499118165783*G0_1_0_0_0_1 - 0.0250376783710115*G0_1_0_0_0_2 + 0.00451499118165783*G0_1_0_0_1_0 + 0.0131345198011864*G0_1_0_0_1_1 + 0.000410453743787077*G0_1_0_0_1_2 - 0.0250376783710115*G0_1_0_0_2_0 + 0.000410453743787077*G0_1_0_0_2_1 - 0.0205226871893536*G0_1_0_0_2_2 + 0.00451499118165783*G0_1_0_1_0_0 + 0.0131345198011864*G0_1_0_1_0_1 + 0.000410453743787077*G0_1_0_1_0_2 + 0.0131345198011864*G0_1_0_1_1_0 + 0.0123136123136123*G0_1_0_1_1_1 + 0.0242167708834373*G0_1_0_1_1_2 + 0.000410453743787077*G0_1_0_1_2_0 + 0.0242167708834374*G0_1_0_1_2_1 + 0.0205226871893537*G0_1_0_1_2_2 - 0.0250376783710115*G0_1_0_2_0_0 + 0.000410453743787079*G0_1_0_2_0_1 - 0.0205226871893536*G0_1_0_2_0_2 + 0.000410453743787078*G0_1_0_2_1_0 + 0.0242167708834373*G0_1_0_2_1_1 + 0.0205226871893537*G0_1_0_2_1_2 - 0.0205226871893536*G0_1_0_2_2_0 + 0.0205226871893537*G0_1_0_2_2_1 + 0.30866121532788*G0_1_1_0_0_0 + 0.114721821388487*G0_1_1_0_0_1 - 0.00800384800384804*G0_1_1_0_0_2 + 0.114721821388487*G0_1_1_0_1_0 + 0.0728555395222058*G0_1_1_0_1_1 + 0.00430976430976427*G0_1_1_0_1_2 - 0.00800384800384804*G0_1_1_0_2_0 + 0.00430976430976426*G0_1_1_0_2_1 - 0.0391983325316658*G0_1_1_0_2_2 + 0.114721821388487*G0_1_1_1_0_0 + 0.0728555395222058*G0_1_1_1_0_1 + 0.00430976430976427*G0_1_1_1_0_2 + 0.0728555395222058*G0_1_1_1_1_0 + 0.0439185505852169*G0_1_1_1_1_1 + 0.0322206188872853*G0_1_1_1_1_2 + 0.00430976430976427*G0_1_1_1_2_0 + 0.0322206188872853*G0_1_1_1_2_1 + 0.0289369889369887*G0_1_1_1_2_2 - 0.00800384800384804*G0_1_1_2_0_0 + 0.00430976430976427*G0_1_1_2_0_1 - 0.0391983325316658*G0_1_1_2_0_2 + 0.00430976430976426*G0_1_1_2_1_0 + 0.0322206188872853*G0_1_1_2_1_1 + 0.0289369889369887*G0_1_1_2_1_2 - 0.0391983325316658*G0_1_1_2_2_0 + 0.0289369889369887*G0_1_1_2_2_1 - 0.0348885682219018*G0_1_1_2_2_2;
    A[202] = A[87] + 0.0416354016354017*G0_0_0_0_0_0 + 0.0048997915664582*G0_0_0_0_0_1 + 0.0573096039762705*G0_0_0_0_0_2 + 0.0048997915664582*G0_0_0_0_1_0 + 0.0014622414622414*G0_0_0_0_1_1 - 0.00523328523328524*G0_0_0_0_1_2 + 0.0573096039762705*G0_0_0_0_2_0 - 0.00523328523328524*G0_0_0_0_2_1 + 0.0856309122975787*G0_0_0_0_2_2 + 0.0048997915664582*G0_0_0_1_0_0 + 0.0014622414622414*G0_0_0_1_0_1 - 0.00523328523328524*G0_0_0_1_0_2 + 0.0014622414622414*G0_0_0_1_1_0 - 0.0114670514670517*G0_0_0_1_1_1 - 0.0283726150392818*G0_0_0_1_1_2 - 0.00523328523328524*G0_0_0_1_2_0 - 0.0283726150392818*G0_0_0_1_2_1 - 0.0363764630431298*G0_0_0_1_2_2 + 0.0573096039762705*G0_0_0_2_0_0 - 0.00523328523328524*G0_0_0_2_0_1 + 0.0856309122975786*G0_0_0_2_0_2 - 0.00523328523328524*G0_0_0_2_1_0 - 0.0283726150392818*G0_0_0_2_1_1 - 0.0363764630431298*G0_0_0_2_1_2 + 0.0856309122975786*G0_0_0_2_2_0 - 0.0363764630431298*G0_0_0_2_2_1 + 0.153920153920152*G0_0_0_2_2_2 - 0.09771364438031*G0_0_1_0_0_0 + 0.000974827641494432*G0_0_1_0_0_1 - 0.022908449575116*G0_0_1_0_0_2 + 0.000974827641494432*G0_0_1_0_1_0 + 0.00310405643738978*G0_0_1_0_1_1 - 0.00182138848805518*G0_0_1_0_1_2 - 0.022908449575116*G0_0_1_0_2_0 - 0.00182138848805518*G0_0_1_0_2_1 + 0.0123136123136123*G0_0_1_0_2_2 + 0.000974827641494432*G0_0_1_1_0_0 + 0.00310405643738978*G0_0_1_1_0_1 - 0.00182138848805518*G0_0_1_1_0_2 + 0.00310405643738978*G0_0_1_1_1_0 + 0.00056437389770702*G0_0_1_1_1_1 - 0.020599647266314*G0_0_1_1_1_2 - 0.00182138848805518*G0_0_1_1_2_0 - 0.020599647266314*G0_0_1_1_2_1 - 0.0475613275613275*G0_0_1_1_2_2 - 0.022908449575116*G0_0_1_2_0_0 - 0.00182138848805518*G0_0_1_2_0_1 + 0.0123136123136123*G0_0_1_2_0_2 - 0.00182138848805518*G0_0_1_2_1_0 - 0.020599647266314*G0_0_1_2_1_1 - 0.0475613275613275*G0_0_1_2_1_2 + 0.0123136123136123*G0_0_1_2_2_0 - 0.0475613275613275*G0_0_1_2_2_1 - 0.0573096039762712*G0_0_1_2_2_2 - 0.00951739618406273*G0_1_0_0_0_0 + 0.00274490941157602*G0_1_0_0_0_1 + 0.00274490941157602*G0_1_0_0_1_0 + 0.00328362995029645*G0_1_0_0_1_1 - 0.00264229597562933*G0_1_0_0_1_2 - 0.00264229597562933*G0_1_0_0_2_1 + 0.00602853936187264*G0_1_0_0_2_2 + 0.00274490941157602*G0_1_0_1_0_0 + 0.00328362995029645*G0_1_0_1_0_1 - 0.00264229597562933*G0_1_0_1_0_2 + 0.00328362995029645*G0_1_0_1_1_0 - 0.00374539041205805*G0_1_0_1_1_1 - 0.0435594035594035*G0_1_0_1_1_2 - 0.00264229597562933*G0_1_0_1_2_0 - 0.0435594035594035*G0_1_0_1_2_1 - 0.0655443322109987*G0_1_0_1_2_2 - 0.00264229597562933*G0_1_0_2_0_1 + 0.00602853936187264*G0_1_0_2_0_2 - 0.00264229597562933*G0_1_0_2_1_0 - 0.0435594035594035*G0_1_0_2_1_1 - 0.0655443322109987*G0_1_0_2_1_2 + 0.00602853936187265*G0_1_0_2_2_0 - 0.0655443322109987*G0_1_0_2_2_1 - 0.0691614558281232*G0_1_0_2_2_2 - 0.0610293410293411*G0_1_1_0_0_0 - 0.0504858104858102*G0_1_1_0_0_1 - 0.0103896103896103*G0_1_1_0_0_2 - 0.0504858104858102*G0_1_1_0_1_0 - 0.0384287317620649*G0_1_1_0_1_1 - 0.00590027256693921*G0_1_1_0_1_2 - 0.0103896103896103*G0_1_1_0_2_0 - 0.00590027256693921*G0_1_1_0_2_1 - 0.00402757736091063*G0_1_1_0_2_2 - 0.0504858104858102*G0_1_1_1_0_0 - 0.038428731762065*G0_1_1_1_0_1 - 0.00590027256693921*G0_1_1_1_0_2 - 0.038428731762065*G0_1_1_1_1_0 - 0.0083116883116888*G0_1_1_1_1_1 - 0.0413019079685745*G0_1_1_1_1_2 - 0.00590027256693921*G0_1_1_1_2_0 - 0.0413019079685745*G0_1_1_1_2_1 - 0.0747025813692477*G0_1_1_1_2_2 - 0.0103896103896103*G0_1_1_2_0_0 - 0.00590027256693921*G0_1_1_2_0_1 - 0.00402757736091063*G0_1_1_2_0_2 - 0.00590027256693921*G0_1_1_2_1_0 - 0.0413019079685745*G0_1_1_2_1_1 - 0.0747025813692477*G0_1_1_2_1_2 - 0.00402757736091063*G0_1_1_2_2_0 - 0.0747025813692478*G0_1_1_2_2_1 - 0.151534391534391*G0_1_1_2_2_2;
    A[149] = A[87] - 0.0872214205547538*G0_0_0_0_0_0 + 0.00287317620650956*G0_0_0_0_0_1 - 0.00595157928491255*G0_0_0_0_0_2 + 0.00287317620650956*G0_0_0_0_1_0 + 0.00697771364438028*G0_0_0_0_1_1 + 0.00143658810325475*G0_0_0_0_1_2 - 0.00595157928491255*G0_0_0_0_2_0 + 0.00143658810325475*G0_0_0_0_2_1 + 0.0158024691358023*G0_0_0_0_2_2 + 0.00287317620650956*G0_0_0_1_0_0 + 0.00697771364438028*G0_0_0_1_0_1 + 0.00143658810325475*G0_0_0_1_0_2 + 0.00697771364438028*G0_0_0_1_1_0 + 0.00513067179733828*G0_0_0_1_1_1 + 0.0149815616482281*G0_0_0_1_1_2 + 0.00143658810325475*G0_0_0_1_2_0 + 0.0149815616482281*G0_0_0_1_2_1 + 0.0129292929292927*G0_0_0_1_2_2 - 0.00595157928491256*G0_0_0_2_0_0 + 0.00143658810325475*G0_0_0_2_0_1 + 0.0158024691358023*G0_0_0_2_0_2 + 0.00143658810325475*G0_0_0_2_1_0 + 0.0149815616482281*G0_0_0_2_1_1 + 0.0129292929292927*G0_0_0_2_1_2 + 0.0158024691358023*G0_0_0_2_2_0 + 0.0129292929292927*G0_0_0_2_2_1 + 0.066083052749718*G0_0_0_2_2_2 - 0.00348885682219081*G0_0_1_0_0_0 + 0.0281160814494146*G0_0_1_0_0_1 - 0.00656725990059322*G0_0_1_0_0_2 + 0.0281160814494146*G0_0_1_0_1_0 + 0.0238063171396504*G0_0_1_0_1_1 + 0.00225749559082891*G0_0_1_0_1_2 - 0.00656725990059323*G0_0_1_0_2_0 + 0.00225749559082891*G0_0_1_0_2_1 - 0.000205226871893563*G0_0_1_0_2_2 + 0.0281160814494146*G0_0_1_1_0_0 + 0.0238063171396504*G0_0_1_1_0_1 + 0.00225749559082891*G0_0_1_1_0_2 + 0.0238063171396504*G0_0_1_1_1_0 + 0.00944043610710261*G0_0_1_1_1_1 + 0.0209331409331407*G0_0_1_1_1_2 + 0.00225749559082891*G0_0_1_1_2_0 + 0.0209331409331407*G0_0_1_1_2_1 + 0.003899310565977*G0_0_1_1_2_2 - 0.00656725990059323*G0_0_1_2_0_0 + 0.00225749559082891*G0_0_1_2_0_1 - 0.000205226871893565*G0_0_1_2_0_2 + 0.00225749559082891*G0_0_1_2_1_0 + 0.0209331409331407*G0_0_1_2_1_1 + 0.003899310565977*G0_0_1_2_1_2 - 0.000205226871893565*G0_0_1_2_2_0 + 0.003899310565977*G0_0_1_2_2_1 - 0.093993907327241*G0_0_1_2_2_2 + 0.0728555395222064*G0_1_0_0_0_0 + 0.0119031585698253*G0_1_0_0_0_1 + 0.0100561167227833*G0_1_0_0_0_2 + 0.0119031585698253*G0_1_0_0_1_0 + 0.00102613435946772*G0_1_0_0_1_1 + 0.000615680615680615*G0_1_0_0_1_2 + 0.0100561167227833*G0_1_0_0_2_0 + 0.000615680615680614*G0_1_0_0_2_1 + 0.016418149751483*G0_1_0_0_2_2 + 0.0119031585698253*G0_1_0_1_0_0 + 0.00102613435946772*G0_1_0_1_0_1 + 0.000615680615680615*G0_1_0_1_0_2 + 0.00102613435946772*G0_1_0_1_1_0 + 0.000820907487574047*G0_1_0_1_1_1 - 0.00184704184704179*G0_1_0_1_1_2 + 0.000615680615680615*G0_1_0_1_2_0 - 0.00184704184704179*G0_1_0_1_2_1 - 0.0123136123136122*G0_1_0_1_2_2 + 0.0100561167227833*G0_1_0_2_0_0 + 0.000615680615680615*G0_1_0_2_0_1 + 0.016418149751483*G0_1_0_2_0_2 + 0.000615680615680615*G0_1_0_2_1_0 - 0.00184704184704179*G0_1_0_2_1_1 - 0.0123136123136122*G0_1_0_2_1_2 + 0.016418149751483*G0_1_0_2_2_0 - 0.0123136123136122*G0_1_0_2_2_1 - 0.0176495109828442*G0_1_0_2_2_2 + 0.0905050505050506*G0_1_1_0_0_0 + 0.0242167708834375*G0_1_1_0_0_1 - 0.00636203302869965*G0_1_1_0_0_2 + 0.0242167708834375*G0_1_1_0_1_0 + 0.00287317620650958*G0_1_1_0_1_1 - 0.00636203302869966*G0_1_1_0_2_0 + 0.00636203302869968*G0_1_1_0_2_2 + 0.0242167708834375*G0_1_1_1_0_0 + 0.00287317620650954*G0_1_1_1_0_1 + 0.00287317620650955*G0_1_1_1_1_0 - 0.0028731762065095*G0_1_1_1_1_2 - 0.0028731762065095*G0_1_1_1_2_1 - 0.0242167708834374*G0_1_1_1_2_2 - 0.00636203302869965*G0_1_1_2_0_0 + 0.00636203302869968*G0_1_1_2_0_2 - 0.0028731762065095*G0_1_1_2_1_1 - 0.0242167708834374*G0_1_1_2_1_2 + 0.00636203302869968*G0_1_1_2_2_0 - 0.0242167708834374*G0_1_1_2_2_1 - 0.0905050505050501*G0_1_1_2_2_2;
    A[164] = A[202] - 0.0330928330928329*G0_0_0_0_0_0 - 0.0138528138528138*G0_0_0_0_0_1 - 0.0614141414141412*G0_0_0_0_0_2 - 0.0138528138528138*G0_0_0_0_1_0 - 0.00938912938912931*G0_0_0_0_1_1 + 0.00631072631072631*G0_0_0_0_1_2 - 0.0614141414141412*G0_0_0_0_2_0 + 0.00631072631072631*G0_0_0_0_2_1 - 0.0735738335738333*G0_0_0_0_2_2 - 0.0138528138528138*G0_0_0_1_0_0 - 0.00938912938912931*G0_0_0_1_0_1 + 0.00631072631072631*G0_0_0_1_0_2 - 0.00938912938912931*G0_0_0_1_1_0 + 0.0292448292448295*G0_0_0_1_1_1 + 0.0140067340067342*G0_0_0_1_1_2 + 0.00631072631072631*G0_0_0_1_2_0 + 0.0140067340067342*G0_0_0_1_2_1 + 0.0135449735449737*G0_0_0_1_2_2 - 0.0614141414141412*G0_0_0_2_0_0 + 0.00631072631072631*G0_0_0_2_0_1 - 0.0735738335738333*G0_0_0_2_0_2 + 0.00631072631072631*G0_0_0_2_1_0 + 0.0140067340067342*G0_0_0_2_1_1 + 0.0135449735449737*G0_0_0_2_1_2 - 0.0735738335738333*G0_0_0_2_2_0 + 0.0135449735449737*G0_0_0_2_2_1 - 0.149918229918229*G0_0_0_2_2_2 - 0.0293217893217891*G0_0_1_0_0_1 + 0.0293217893217892*G0_0_1_0_0_2 - 0.0293217893217891*G0_0_1_0_1_0 + 0.00561808561808565*G0_0_1_0_1_1 + 0.0293217893217891*G0_0_1_0_2_0 - 0.00561808561808565*G0_0_1_0_2_2 - 0.0293217893217891*G0_0_1_1_0_0 + 0.00561808561808565*G0_0_1_1_0_1 + 0.00561808561808565*G0_0_1_1_1_0 + 0.0905050505050502*G0_0_1_1_1_1 - 0.00469456469456451*G0_0_1_1_1_2 - 0.00469456469456451*G0_0_1_1_2_1 + 0.00469456469456488*G0_0_1_1_2_2 + 0.0293217893217892*G0_0_1_2_0_0 - 0.00561808561808566*G0_0_1_2_0_2 - 0.00469456469456451*G0_0_1_2_1_1 + 0.00469456469456488*G0_0_1_2_1_2 - 0.00561808561808566*G0_0_1_2_2_0 + 0.00469456469456488*G0_0_1_2_2_1 - 0.0905050505050494*G0_0_1_2_2_2 - 0.0102356902356901*G0_1_0_0_0_1 + 0.0102356902356903*G0_1_0_0_0_2 - 0.0102356902356901*G0_1_0_0_1_0 - 0.0168542568542566*G0_1_0_0_1_1 + 0.0102356902356903*G0_1_0_0_2_0 + 0.0168542568542569*G0_1_0_0_2_2 - 0.0102356902356901*G0_1_0_1_0_0 - 0.0168542568542566*G0_1_0_1_0_1 - 0.0168542568542566*G0_1_0_1_1_0 + 0.0263203463203471*G0_1_0_1_1_1 + 0.000692640692640885*G0_1_0_1_1_2 + 0.000692640692640889*G0_1_0_1_2_1 - 0.000692640692640504*G0_1_0_1_2_2 + 0.0102356902356903*G0_1_0_2_0_0 + 0.0168542568542569*G0_1_0_2_0_2 + 0.000692640692640887*G0_1_0_2_1_1 - 0.000692640692640504*G0_1_0_2_1_2 + 0.0168542568542569*G0_1_0_2_2_0 - 0.000692640692640507*G0_1_0_2_2_1 - 0.026320346320345*G0_1_0_2_2_2 + 0.0330928330928337*G0_1_1_0_0_0 + 0.0614141414141412*G0_1_1_0_0_1 + 0.0138528138528138*G0_1_1_0_0_2 + 0.0614141414141412*G0_1_1_0_1_0 + 0.0735738335738332*G0_1_1_0_1_1 - 0.0063107263107263*G0_1_1_0_1_2 + 0.0138528138528138*G0_1_1_0_2_0 - 0.0063107263107263*G0_1_1_0_2_1 + 0.0093891293891293*G0_1_1_0_2_2 + 0.0614141414141412*G0_1_1_1_0_0 + 0.0735738335738332*G0_1_1_1_0_1 - 0.0063107263107263*G0_1_1_1_0_2 + 0.0735738335738332*G0_1_1_1_1_0 + 0.14991822991823*G0_1_1_1_1_1 - 0.0135449735449734*G0_1_1_1_1_2 - 0.0063107263107263*G0_1_1_1_2_0 - 0.0135449735449734*G0_1_1_1_2_1 - 0.0140067340067339*G0_1_1_1_2_2 + 0.0138528138528138*G0_1_1_2_0_0 - 0.0063107263107263*G0_1_1_2_0_1 + 0.0093891293891293*G0_1_1_2_0_2 - 0.0063107263107263*G0_1_1_2_1_0 - 0.0135449735449734*G0_1_1_2_1_1 - 0.0140067340067339*G0_1_1_2_1_2 + 0.0093891293891293*G0_1_1_2_2_0 - 0.0140067340067339*G0_1_1_2_2_1 - 0.0292448292448287*G0_1_1_2_2_2;
    A[72] = A[202] - 0.0623376623376621*G0_0_0_0_0_0 - 0.00446368446368444*G0_0_0_0_0_1 - 0.0754208754208752*G0_0_0_0_0_2 - 0.00446368446368444*G0_0_0_0_1_0 + 0.00446368446368446*G0_0_0_0_1_1 - 0.0754208754208752*G0_0_0_0_2_0 - 0.0871188071188069*G0_0_0_0_2_2 - 0.00446368446368444*G0_0_0_1_0_0 + 0.00446368446368446*G0_0_0_1_0_1 + 0.00446368446368446*G0_0_0_1_1_0 + 0.062337662337662*G0_0_0_1_1_1 + 0.0754208754208751*G0_0_0_1_1_2 + 0.0754208754208751*G0_0_0_1_2_1 + 0.0871188071188067*G0_0_0_1_2_2 - 0.0754208754208752*G0_0_0_2_0_0 - 0.0871188071188069*G0_0_0_2_0_2 + 0.0754208754208751*G0_0_0_2_1_1 + 0.0871188071188067*G0_0_0_2_1_2 - 0.0871188071188069*G0_0_0_2_2_0 + 0.0871188071188067*G0_0_0_2_2_1 + 0.0612602212602212*G0_0_1_0_0_0 - 0.0187012987012985*G0_0_1_0_0_1 + 0.0150072150072149*G0_0_1_0_0_2 - 0.0187012987012985*G0_0_1_0_1_0 - 0.00885040885040871*G0_0_1_0_1_1 - 0.00631072631072624*G0_0_1_0_1_2 + 0.0150072150072149*G0_0_1_0_2_0 - 0.00631072631072623*G0_0_1_0_2_1 - 0.0154689754689755*G0_0_1_0_2_2 - 0.0187012987012985*G0_0_1_1_0_0 - 0.00885040885040871*G0_0_1_1_0_1 - 0.00631072631072623*G0_0_1_1_0_2 - 0.00885040885040871*G0_0_1_1_1_0 + 0.059413179413179*G0_0_1_1_1_1 + 0.0679557479557476*G0_0_1_1_1_2 - 0.00631072631072624*G0_0_1_1_2_0 + 0.0679557479557477*G0_0_1_1_2_1 + 0.0907359307359304*G0_0_1_1_2_2 + 0.0150072150072149*G0_0_1_2_0_0 - 0.00631072631072623*G0_0_1_2_0_1 - 0.0154689754689755*G0_0_1_2_0_2 - 0.00631072631072624*G0_0_1_2_1_0 + 0.0679557479557476*G0_0_1_2_1_1 + 0.0907359307359304*G0_0_1_2_1_2 - 0.0154689754689755*G0_0_1_2_2_0 + 0.0907359307359304*G0_0_1_2_2_1 + 0.0330928330928335*G0_0_1_2_2_2 - 0.00292448292448312*G0_1_0_0_0_0 - 0.0133140933140932*G0_1_0_0_0_1 - 0.00746512746512764*G0_1_0_0_0_2 - 0.0133140933140932*G0_1_0_0_1_0 - 0.0142376142376141*G0_1_0_0_1_1 - 0.00631072631072628*G0_1_0_0_1_2 - 0.00746512746512764*G0_1_0_0_2_0 - 0.00631072631072628*G0_1_0_0_2_1 + 0.00361712361712344*G0_1_0_0_2_2 - 0.0133140933140932*G0_1_0_1_0_0 - 0.0142376142376141*G0_1_0_1_0_1 - 0.00631072631072628*G0_1_0_1_0_2 - 0.0142376142376141*G0_1_0_1_1_0 + 0.123597883597883*G0_1_0_1_1_1 + 0.0904280904280901*G0_1_0_1_1_2 - 0.00631072631072628*G0_1_0_1_2_0 + 0.0904280904280901*G0_1_0_1_2_1 + 0.0716498316498314*G0_1_0_1_2_2 - 0.00746512746512763*G0_1_0_2_0_0 - 0.00631072631072628*G0_1_0_2_0_1 + 0.00361712361712344*G0_1_0_2_0_2 - 0.00631072631072628*G0_1_0_2_1_0 + 0.0904280904280901*G0_1_0_2_1_1 + 0.0716498316498314*G0_1_0_2_1_2 + 0.00361712361712344*G0_1_0_2_2_0 + 0.0716498316498314*G0_1_0_2_2_1 + 0.0330928330928335*G0_1_0_2_2_2 - 0.0292448292448278*G0_1_1_0_0_0 - 0.0140067340067338*G0_1_1_0_0_1 + 0.00938912938912941*G0_1_1_0_0_2 - 0.0140067340067338*G0_1_1_0_1_0 - 0.0135449735449734*G0_1_1_0_1_1 - 0.00631072631072627*G0_1_1_0_1_2 + 0.00938912938912941*G0_1_1_0_2_0 - 0.00631072631072627*G0_1_1_0_2_1 + 0.0138528138528138*G0_1_1_0_2_2 - 0.0140067340067338*G0_1_1_1_0_0 - 0.0135449735449734*G0_1_1_1_0_1 - 0.00631072631072627*G0_1_1_1_0_2 - 0.0135449735449734*G0_1_1_1_1_0 + 0.14991822991823*G0_1_1_1_1_1 + 0.0735738335738333*G0_1_1_1_1_2 - 0.00631072631072627*G0_1_1_1_2_0 + 0.0735738335738333*G0_1_1_1_2_1 + 0.0614141414141412*G0_1_1_1_2_2 + 0.00938912938912941*G0_1_1_2_0_0 - 0.00631072631072627*G0_1_1_2_0_1 + 0.0138528138528138*G0_1_1_2_0_2 - 0.00631072631072627*G0_1_1_2_1_0 + 0.0735738335738333*G0_1_1_2_1_1 + 0.0614141414141412*G0_1_1_2_1_2 + 0.0138528138528138*G0_1_1_2_2_0 + 0.0614141414141412*G0_1_1_2_2_1 + 0.0330928330928336*G0_1_1_2_2_2;
    A[184] = A[72] + 0.00438672438672413*G0_0_1_0_0_1 - 0.00438672438672454*G0_0_1_0_0_2 + 0.00438672438672413*G0_0_1_0_1_0 - 0.00100048100048112*G0_0_1_0_1_1 - 0.00438672438672454*G0_0_1_0_2_0 + 0.00100048100048087*G0_0_1_0_2_2 + 0.00438672438672413*G0_0_1_1_0_0 - 0.00100048100048112*G0_0_1_1_0_1 - 0.00100048100048112*G0_0_1_1_1_0 + 0.0641847041847036*G0_0_1_1_1_1 + 0.018085618085618*G0_0_1_1_1_2 + 0.018085618085618*G0_0_1_1_2_1 - 0.018085618085618*G0_0_1_1_2_2 - 0.00438672438672454*G0_0_1_2_0_0 + 0.00100048100048087*G0_0_1_2_0_2 + 0.018085618085618*G0_0_1_2_1_1 - 0.018085618085618*G0_0_1_2_1_2 + 0.00100048100048087*G0_0_1_2_2_0 - 0.018085618085618*G0_0_1_2_2_1 - 0.0641847041847042*G0_0_1_2_2_2 - 0.00438672438672413*G0_1_0_0_0_1 + 0.00438672438672454*G0_1_0_0_0_2 - 0.00438672438672413*G0_1_0_0_1_0 + 0.00100048100048112*G0_1_0_0_1_1 + 0.00438672438672454*G0_1_0_0_2_0 - 0.00100048100048087*G0_1_0_0_2_2 - 0.00438672438672413*G0_1_0_1_0_0 + 0.00100048100048112*G0_1_0_1_0_1 + 0.00100048100048112*G0_1_0_1_1_0 - 0.0641847041847036*G0_1_0_1_1_1 - 0.018085618085618*G0_1_0_1_1_2 - 0.018085618085618*G0_1_0_1_2_1 + 0.018085618085618*G0_1_0_1_2_2 + 0.00438672438672453*G0_1_0_2_0_0 - 0.00100048100048087*G0_1_0_2_0_2 - 0.018085618085618*G0_1_0_2_1_1 + 0.018085618085618*G0_1_0_2_1_2 - 0.00100048100048087*G0_1_0_2_2_0 + 0.018085618085618*G0_1_0_2_2_1 + 0.0641847041847042*G0_1_0_2_2_2;
    A[219] = A[149] + 0.0523328523328535*G0_0_1_0_0_0 - 0.018983485650152*G0_0_1_0_0_1 + 0.0118005451338785*G0_0_1_0_0_2 - 0.018983485650152*G0_0_1_0_1_0 - 0.0185730319063651*G0_0_1_0_1_1 - 0.000820907487574137*G0_0_1_0_1_2 + 0.0118005451338785*G0_0_1_0_2_0 - 0.000820907487574137*G0_0_1_0_2_1 + 0.00482283148949819*G0_0_1_0_2_2 - 0.018983485650152*G0_0_1_1_0_0 - 0.018573031906365*G0_0_1_1_0_1 - 0.000820907487574136*G0_0_1_1_0_2 - 0.0185730319063651*G0_0_1_1_1_0 - 0.00430976430976417*G0_0_1_1_1_1 - 0.00420715087381742*G0_0_1_1_1_2 - 0.000820907487574137*G0_0_1_1_2_0 - 0.00420715087381741*G0_0_1_1_2_1 + 0.00277056277056293*G0_0_1_1_2_2 + 0.0118005451338785*G0_0_1_2_0_0 - 0.000820907487574136*G0_0_1_2_0_1 + 0.00482283148949819*G0_0_1_2_0_2 - 0.000820907487574137*G0_0_1_2_1_0 - 0.00420715087381741*G0_0_1_2_1_1 + 0.00277056277056294*G0_0_1_2_1_2 + 0.00482283148949819*G0_0_1_2_2_0 + 0.00277056277056293*G0_0_1_2_2_1 + 0.0240115440115446*G0_0_1_2_2_2 - 0.0523328523328535*G0_1_0_0_0_0 + 0.018983485650152*G0_1_0_0_0_1 - 0.0118005451338785*G0_1_0_0_0_2 + 0.018983485650152*G0_1_0_0_1_0 + 0.018573031906365*G0_1_0_0_1_1 + 0.000820907487574135*G0_1_0_0_1_2 - 0.0118005451338785*G0_1_0_0_2_0 + 0.000820907487574135*G0_1_0_0_2_1 - 0.00482283148949819*G0_1_0_0_2_2 + 0.018983485650152*G0_1_0_1_0_0 + 0.018573031906365*G0_1_0_1_0_1 + 0.000820907487574136*G0_1_0_1_0_2 + 0.018573031906365*G0_1_0_1_1_0 + 0.00430976430976415*G0_1_0_1_1_1 + 0.00420715087381741*G0_1_0_1_1_2 + 0.000820907487574135*G0_1_0_1_2_0 + 0.0042071508738174*G0_1_0_1_2_1 - 0.00277056277056295*G0_1_0_1_2_2 - 0.0118005451338785*G0_1_0_2_0_0 + 0.000820907487574136*G0_1_0_2_0_1 - 0.00482283148949819*G0_1_0_2_0_2 + 0.000820907487574135*G0_1_0_2_1_0 + 0.00420715087381741*G0_1_0_2_1_1 - 0.00277056277056296*G0_1_0_2_1_2 - 0.00482283148949819*G0_1_0_2_2_0 - 0.00277056277056295*G0_1_0_2_2_1 - 0.0240115440115446*G0_1_0_2_2_2;
    A[103] = A[219] + 0.247298380631713*G0_0_0_0_0_0 - 0.00779862113195443*G0_0_0_0_0_1 + 0.0765496232162895*G0_0_0_0_0_2 - 0.00779862113195442*G0_0_0_0_1_0 - 0.00451499118165782*G0_0_0_0_1_1 + 0.00554112554112554*G0_0_0_0_1_2 + 0.0765496232162895*G0_0_0_0_2_0 + 0.00554112554112554*G0_0_0_0_2_1 + 0.0375565175565174*G0_0_0_0_2_2 - 0.00779862113195442*G0_0_0_1_0_0 - 0.00451499118165782*G0_0_0_1_0_1 + 0.00554112554112554*G0_0_0_1_0_2 - 0.00451499118165782*G0_0_0_1_1_0 + 0.0736764470097803*G0_0_0_1_1_1 + 0.0211383678050345*G0_0_0_1_1_2 + 0.00554112554112554*G0_0_0_1_2_0 + 0.0211383678050345*G0_0_0_1_2_1 + 0.00266794933461616*G0_0_0_1_2_2 + 0.0765496232162896*G0_0_0_2_0_0 + 0.00554112554112554*G0_0_0_2_0_1 + 0.0375565175565174*G0_0_0_2_0_2 + 0.00554112554112554*G0_0_0_2_1_0 + 0.0211383678050345*G0_0_0_2_1_1 + 0.00266794933461615*G0_0_0_2_1_2 + 0.0375565175565174*G0_0_0_2_2_0 + 0.00266794933461616*G0_0_0_2_2_1 - 0.0537694404361065*G0_0_0_2_2_2 - 0.00933782267115605*G0_0_1_0_0_1 + 0.00933782267115596*G0_0_1_0_0_2 - 0.00933782267115605*G0_0_1_0_1_0 - 0.0042071508738174*G0_0_1_0_1_1 + 0.00933782267115596*G0_0_1_0_2_0 + 0.00420715087381749*G0_0_1_0_2_2 - 0.00933782267115605*G0_0_1_1_0_0 - 0.0042071508738174*G0_0_1_1_0_1 - 0.0042071508738174*G0_0_1_1_1_0 + 0.0732659932659936*G0_0_1_1_1_1 + 0.0122109988776656*G0_0_1_1_1_2 + 0.0122109988776655*G0_0_1_1_2_1 - 0.0122109988776655*G0_0_1_1_2_2 + 0.00933782267115596*G0_0_1_2_0_0 + 0.00420715087381749*G0_0_1_2_0_2 + 0.0122109988776656*G0_0_1_2_1_1 - 0.0122109988776655*G0_0_1_2_1_2 + 0.00420715087381749*G0_0_1_2_2_0 - 0.0122109988776655*G0_0_1_2_2_1 - 0.0732659932659929*G0_0_1_2_2_2 - 0.0401218534551865*G0_1_0_0_0_1 + 0.0401218534551867*G0_1_0_0_0_2 - 0.0401218534551865*G0_1_0_0_1_0 - 0.0276030142696808*G0_1_0_0_1_1 + 0.0401218534551867*G0_1_0_0_2_0 + 0.0276030142696808*G0_1_0_0_2_2 - 0.0401218534551865*G0_1_0_1_0_0 - 0.0276030142696808*G0_1_0_1_0_1 - 0.0276030142696808*G0_1_0_1_1_0 + 0.0449446849446847*G0_1_0_1_1_1 + 0.00523328523328524*G0_1_0_1_1_2 + 0.00523328523328524*G0_1_0_1_2_1 - 0.00523328523328509*G0_1_0_1_2_2 + 0.0401218534551867*G0_1_0_2_0_0 + 0.0276030142696808*G0_1_0_2_0_2 + 0.00523328523328524*G0_1_0_2_1_1 - 0.00523328523328509*G0_1_0_2_1_2 + 0.0276030142696808*G0_1_0_2_2_0 - 0.00523328523328509*G0_1_0_2_2_1 - 0.0449446849446841*G0_1_0_2_2_2 - 0.247298380631712*G0_1_1_0_0_0 - 0.0765496232162894*G0_1_1_0_0_1 + 0.00779862113195451*G0_1_1_0_0_2 - 0.0765496232162894*G0_1_1_0_1_0 - 0.0375565175565173*G0_1_1_0_1_1 - 0.00554112554112553*G0_1_1_0_1_2 + 0.00779862113195452*G0_1_1_0_2_0 - 0.00554112554112553*G0_1_1_0_2_1 + 0.00451499118165781*G0_1_1_0_2_2 - 0.0765496232162894*G0_1_1_1_0_0 - 0.0375565175565173*G0_1_1_1_0_1 - 0.00554112554112553*G0_1_1_1_0_2 - 0.0375565175565173*G0_1_1_1_1_0 + 0.0537694404361069*G0_1_1_1_1_1 - 0.00266794933461606*G0_1_1_1_1_2 - 0.00554112554112553*G0_1_1_1_2_0 - 0.00266794933461606*G0_1_1_1_2_1 - 0.0211383678050345*G0_1_1_1_2_2 + 0.00779862113195451*G0_1_1_2_0_0 - 0.00554112554112553*G0_1_1_2_0_1 + 0.00451499118165781*G0_1_1_2_0_2 - 0.00554112554112553*G0_1_1_2_1_0 - 0.00266794933461606*G0_1_1_2_1_1 - 0.0211383678050345*G0_1_1_2_1_2 + 0.00451499118165781*G0_1_1_2_2_0 - 0.0211383678050345*G0_1_1_2_2_1 - 0.0736764470097799*G0_1_1_2_2_2;
    A[201] = A[103] - 0.0523328523328521*G0_0_1_0_0_0 - 0.0118005451338785*G0_0_1_0_0_1 + 0.0189834856501522*G0_0_1_0_0_2 - 0.0118005451338785*G0_0_1_0_1_0 - 0.00482283148949831*G0_0_1_0_1_1 + 0.000820907487574148*G0_0_1_0_1_2 + 0.0189834856501522*G0_0_1_0_2_0 + 0.000820907487574147*G0_0_1_0_2_1 + 0.0185730319063652*G0_0_1_0_2_2 - 0.0118005451338785*G0_0_1_1_0_0 - 0.00482283148949831*G0_0_1_1_0_1 + 0.000820907487574148*G0_0_1_1_0_2 - 0.00482283148949831*G0_0_1_1_1_0 - 0.0240115440115447*G0_0_1_1_1_1 - 0.0027705627705629*G0_0_1_1_1_2 + 0.000820907487574147*G0_0_1_1_2_0 - 0.0027705627705629*G0_0_1_1_2_1 + 0.00420715087381746*G0_0_1_1_2_2 + 0.0189834856501522*G0_0_1_2_0_0 + 0.000820907487574148*G0_0_1_2_0_1 + 0.0185730319063652*G0_0_1_2_0_2 + 0.000820907487574148*G0_0_1_2_1_0 - 0.0027705627705629*G0_0_1_2_1_1 + 0.00420715087381746*G0_0_1_2_1_2 + 0.0185730319063652*G0_0_1_2_2_0 + 0.00420715087381747*G0_0_1_2_2_1 + 0.00430976430976417*G0_0_1_2_2_2 + 0.0523328523328522*G0_1_0_0_0_0 + 0.0118005451338785*G0_1_0_0_0_1 - 0.0189834856501522*G0_1_0_0_0_2 + 0.0118005451338785*G0_1_0_0_1_0 + 0.00482283148949831*G0_1_0_0_1_1 - 0.000820907487574146*G0_1_0_0_1_2 - 0.0189834856501522*G0_1_0_0_2_0 - 0.000820907487574148*G0_1_0_0_2_1 - 0.0185730319063652*G0_1_0_0_2_2 + 0.0118005451338785*G0_1_0_1_0_0 + 0.00482283148949831*G0_1_0_1_0_1 - 0.000820907487574146*G0_1_0_1_0_2 + 0.00482283148949831*G0_1_0_1_1_0 + 0.0240115440115447*G0_1_0_1_1_1 + 0.0027705627705629*G0_1_0_1_1_2 - 0.000820907487574148*G0_1_0_1_2_0 + 0.0027705627705629*G0_1_0_1_2_1 - 0.00420715087381747*G0_1_0_1_2_2 - 0.0189834856501522*G0_1_0_2_0_0 - 0.000820907487574147*G0_1_0_2_0_1 - 0.0185730319063652*G0_1_0_2_0_2 - 0.000820907487574147*G0_1_0_2_1_0 + 0.0027705627705629*G0_1_0_2_1_1 - 0.00420715087381746*G0_1_0_2_1_2 - 0.0185730319063652*G0_1_0_2_2_0 - 0.00420715087381747*G0_1_0_2_2_1 - 0.00430976430976416*G0_1_0_2_2_2;
    A[220] = A[164] + 0.0641847041847035*G0_0_1_0_0_0 + 0.018085618085618*G0_0_1_0_0_1 - 0.00100048100048091*G0_0_1_0_0_2 + 0.018085618085618*G0_0_1_0_1_0 - 0.018085618085618*G0_0_1_0_1_1 - 0.00100048100048091*G0_0_1_0_2_0 + 0.00438672438672453*G0_0_1_0_2_2 + 0.018085618085618*G0_0_1_1_0_0 - 0.018085618085618*G0_0_1_1_0_1 - 0.018085618085618*G0_0_1_1_1_0 - 0.0641847041847037*G0_0_1_1_1_1 + 0.00100048100048097*G0_0_1_1_1_2 + 0.00100048100048097*G0_0_1_1_2_1 - 0.0043867243867244*G0_0_1_1_2_2 - 0.00100048100048091*G0_0_1_2_0_0 + 0.00438672438672453*G0_0_1_2_0_2 + 0.00100048100048097*G0_0_1_2_1_1 - 0.0043867243867244*G0_0_1_2_1_2 + 0.00438672438672453*G0_0_1_2_2_0 - 0.0043867243867244*G0_0_1_2_2_1 - 0.0641847041847034*G0_1_0_0_0_0 - 0.018085618085618*G0_1_0_0_0_1 + 0.00100048100048091*G0_1_0_0_0_2 - 0.018085618085618*G0_1_0_0_1_0 + 0.018085618085618*G0_1_0_0_1_1 + 0.00100048100048091*G0_1_0_0_2_0 - 0.00438672438672453*G0_1_0_0_2_2 - 0.018085618085618*G0_1_0_1_0_0 + 0.018085618085618*G0_1_0_1_0_1 + 0.018085618085618*G0_1_0_1_1_0 + 0.0641847041847038*G0_1_0_1_1_1 - 0.00100048100048096*G0_1_0_1_1_2 - 0.00100048100048097*G0_1_0_1_2_1 + 0.00438672438672441*G0_1_0_1_2_2 + 0.00100048100048091*G0_1_0_2_0_0 - 0.00438672438672453*G0_1_0_2_0_2 - 0.00100048100048097*G0_1_0_2_1_1 + 0.00438672438672441*G0_1_0_2_1_2 - 0.00438672438672453*G0_1_0_2_2_0 + 0.00438672438672441*G0_1_0_2_2_1;
    A[118] = A[202] + 0.0641847041847036*G0_0_1_0_0_0 - 0.00100048100048108*G0_0_1_0_0_1 + 0.018085618085618*G0_0_1_0_0_2 - 0.00100048100048108*G0_0_1_0_1_0 + 0.00438672438672425*G0_0_1_0_1_1 + 0.018085618085618*G0_0_1_0_2_0 - 0.018085618085618*G0_0_1_0_2_2 - 0.00100048100048108*G0_0_1_1_0_0 + 0.00438672438672425*G0_0_1_1_0_1 + 0.00438672438672425*G0_0_1_1_1_0 - 0.00438672438672442*G0_0_1_1_1_2 - 0.00438672438672442*G0_0_1_1_2_1 + 0.00100048100048098*G0_0_1_1_2_2 + 0.018085618085618*G0_0_1_2_0_0 - 0.018085618085618*G0_0_1_2_0_2 - 0.00438672438672443*G0_0_1_2_1_1 + 0.00100048100048098*G0_0_1_2_1_2 - 0.018085618085618*G0_0_1_2_2_0 + 0.00100048100048098*G0_0_1_2_2_1 - 0.0641847041847042*G0_0_1_2_2_2 - 0.0641847041847036*G0_1_0_0_0_0 + 0.00100048100048108*G0_1_0_0_0_1 - 0.018085618085618*G0_1_0_0_0_2 + 0.00100048100048108*G0_1_0_0_1_0 - 0.00438672438672425*G0_1_0_0_1_1 - 0.018085618085618*G0_1_0_0_2_0 + 0.018085618085618*G0_1_0_0_2_2 + 0.00100048100048108*G0_1_0_1_0_0 - 0.00438672438672425*G0_1_0_1_0_1 - 0.00438672438672425*G0_1_0_1_1_0 + 0.00438672438672443*G0_1_0_1_1_2 + 0.00438672438672443*G0_1_0_1_2_1 - 0.00100048100048098*G0_1_0_1_2_2 - 0.018085618085618*G0_1_0_2_0_0 + 0.018085618085618*G0_1_0_2_0_2 + 0.00438672438672443*G0_1_0_2_1_1 - 0.00100048100048098*G0_1_0_2_1_2 + 0.018085618085618*G0_1_0_2_2_0 - 0.00100048100048098*G0_1_0_2_2_1 + 0.0641847041847042*G0_1_0_2_2_2;
    A[64] = A[99] + 0.277979797979796*G0_0_0_0_0_0 + 0.00131687242798353*G0_0_0_0_0_1 + 0.0624317246539465*G0_0_0_0_0_2 + 0.00131687242798353*G0_0_0_0_1_0 + 0.00885895997007102*G0_0_0_0_1_1 + 0.0184661429105873*G0_0_0_0_1_2 + 0.0624317246539465*G0_0_0_0_2_0 + 0.0184661429105873*G0_0_0_0_2_1 + 0.103229116562449*G0_0_0_0_2_2 + 0.00131687242798353*G0_0_0_1_0_0 + 0.00885895997007102*G0_0_0_1_0_1 + 0.0184661429105873*G0_0_0_1_0_2 + 0.00885895997007102*G0_0_0_1_1_0 + 0.0819368286034946*G0_0_0_1_1_1 + 0.0974229063117947*G0_0_0_1_1_2 + 0.0184661429105873*G0_0_0_1_2_0 + 0.0974229063117947*G0_0_0_1_2_1 + 0.165310245310245*G0_0_0_1_2_2 + 0.0624317246539465*G0_0_0_2_0_0 + 0.0184661429105873*G0_0_0_2_0_1 + 0.103229116562449*G0_0_0_2_0_2 + 0.0184661429105873*G0_0_0_2_1_0 + 0.0974229063117947*G0_0_0_2_1_1 + 0.165310245310245*G0_0_0_2_1_2 + 0.103229116562449*G0_0_0_2_2_0 + 0.165310245310245*G0_0_0_2_2_1 + 0.799820426487088*G0_0_0_2_2_2 - 0.24782427449094*G0_0_1_0_0_0 - 0.0440596440596438*G0_0_1_0_0_1 - 0.0440596440596439*G0_0_1_0_0_2 - 0.0440596440596438*G0_0_1_0_1_0 - 0.00066698733365401*G0_0_1_0_1_2 - 0.0440596440596439*G0_0_1_0_2_0 - 0.000666987333654008*G0_0_1_0_2_1 - 0.0440596440596438*G0_0_1_1_0_0 - 0.000666987333654011*G0_0_1_1_0_2 + 0.0973031906365226*G0_0_1_1_1_1 + 0.0631200897867561*G0_0_1_1_1_2 - 0.000666987333654006*G0_0_1_1_2_0 + 0.0631200897867561*G0_0_1_1_2_1 + 0.0631200897867562*G0_0_1_1_2_2 - 0.0440596440596439*G0_0_1_2_0_0 - 0.00066698733365401*G0_0_1_2_0_1 - 0.000666987333654008*G0_0_1_2_1_0 + 0.0631200897867561*G0_0_1_2_1_1 + 0.0631200897867562*G0_0_1_2_1_2 + 0.0631200897867562*G0_0_1_2_2_1 + 0.0973031906365231*G0_0_1_2_2_2 - 0.549507776174441*G0_1_0_0_0_0 - 0.0173801507134841*G0_1_0_0_0_1 - 0.017380150713484*G0_1_0_0_0_2 - 0.0173801507134841*G0_1_0_0_1_0 + 0.0123136123136121*G0_1_0_0_1_1 + 0.00548981882315211*G0_1_0_0_1_2 - 0.017380150713484*G0_1_0_0_2_0 + 0.00548981882315211*G0_1_0_0_2_1 + 0.0123136123136122*G0_1_0_0_2_2 - 0.0173801507134841*G0_1_0_1_0_0 + 0.0123136123136121*G0_1_0_1_0_1 + 0.00548981882315211*G0_1_0_1_0_2 + 0.0123136123136121*G0_1_0_1_1_0 + 0.10499919833253*G0_1_0_1_1_1 + 0.0656854256854253*G0_1_0_1_1_2 + 0.00548981882315212*G0_1_0_1_2_0 + 0.0656854256854253*G0_1_0_1_2_1 + 0.0656854256854254*G0_1_0_1_2_2 - 0.017380150713484*G0_1_0_2_0_0 + 0.00548981882315211*G0_1_0_2_0_1 + 0.0123136123136122*G0_1_0_2_0_2 + 0.00548981882315212*G0_1_0_2_1_0 + 0.0656854256854253*G0_1_0_2_1_1 + 0.0656854256854254*G0_1_0_2_1_2 + 0.0123136123136122*G0_1_0_2_2_0 + 0.0656854256854254*G0_1_0_2_2_1 + 0.104999198332531*G0_1_0_2_2_2 + 0.277979797979796*G0_1_1_0_0_0 + 0.0624317246539466*G0_1_1_0_0_1 + 0.00131687242798349*G0_1_1_0_0_2 + 0.0624317246539466*G0_1_1_0_1_0 + 0.103229116562449*G0_1_1_0_1_1 + 0.0184661429105873*G0_1_1_0_1_2 + 0.00131687242798348*G0_1_1_0_2_0 + 0.0184661429105873*G0_1_1_0_2_1 + 0.00885895997007103*G0_1_1_0_2_2 + 0.0624317246539466*G0_1_1_1_0_0 + 0.103229116562449*G0_1_1_1_0_1 + 0.0184661429105873*G0_1_1_1_0_2 + 0.103229116562449*G0_1_1_1_1_0 + 0.799820426487091*G0_1_1_1_1_1 + 0.165310245310245*G0_1_1_1_1_2 + 0.0184661429105873*G0_1_1_1_2_0 + 0.165310245310245*G0_1_1_1_2_1 + 0.0974229063117948*G0_1_1_1_2_2 + 0.00131687242798349*G0_1_1_2_0_0 + 0.0184661429105873*G0_1_1_2_0_1 + 0.00885895997007103*G0_1_1_2_0_2 + 0.0184661429105873*G0_1_1_2_1_0 + 0.165310245310245*G0_1_1_2_1_1 + 0.0974229063117948*G0_1_1_2_1_2 + 0.00885895997007103*G0_1_1_2_2_0 + 0.0974229063117948*G0_1_1_2_2_1 + 0.0819368286034948*G0_1_1_2_2_2;
    A[160] = A[64] + 0.661087061087058*G0_0_0_0_0_0 + 0.124059644059643*G0_0_0_0_0_1 + 0.0571813371813368*G0_0_0_0_0_2 + 0.124059644059643*G0_0_0_0_1_0 + 0.112515632515632*G0_0_0_0_1_1 + 0.000885040885040857*G0_0_0_0_1_2 + 0.0571813371813368*G0_0_0_0_2_0 + 0.000885040885040857*G0_0_0_0_2_1 - 0.075420875420875*G0_0_0_0_2_2 + 0.124059644059643*G0_0_0_1_0_0 + 0.112515632515632*G0_0_0_1_0_1 + 0.00088504088504086*G0_0_0_1_0_2 + 0.112515632515632*G0_0_0_1_1_0 + 0.557190957190955*G0_0_0_1_1_1 - 0.0305531505531504*G0_0_0_1_1_2 + 0.00088504088504086*G0_0_0_1_2_0 - 0.0305531505531504*G0_0_0_1_2_1 - 0.156998556998556*G0_0_0_1_2_2 + 0.0571813371813368*G0_0_0_2_0_0 + 0.000885040885040857*G0_0_0_2_0_1 - 0.075420875420875*G0_0_0_2_0_2 + 0.00088504088504086*G0_0_0_2_1_0 - 0.0305531505531504*G0_0_0_2_1_1 - 0.156998556998556*G0_0_0_2_1_2 - 0.075420875420875*G0_0_0_2_2_0 - 0.156998556998556*G0_0_0_2_2_1 - 0.808003848003842*G0_0_0_2_2_2 - 0.0215103415103412*G0_0_1_0_0_0 + 0.0273977873977874*G0_0_1_0_0_1 - 0.00334776334776335*G0_0_1_0_0_2 + 0.0273977873977874*G0_0_1_0_1_0 + 0.0817700817700816*G0_0_1_0_1_1 + 0.000885040885040898*G0_0_1_0_1_2 - 0.00334776334776335*G0_0_1_0_2_0 + 0.000885040885040898*G0_0_1_0_2_1 - 0.0148917748917748*G0_0_1_0_2_2 + 0.0273977873977874*G0_0_1_1_0_0 + 0.0817700817700816*G0_0_1_1_0_1 + 0.0008850408850409*G0_0_1_1_0_2 + 0.0817700817700816*G0_0_1_1_1_0 + 0.557190957190955*G0_0_1_1_1_1 + 0.000192400192400174*G0_0_1_1_1_2 + 0.000885040885040897*G0_0_1_1_2_0 + 0.000192400192400174*G0_0_1_1_2_1 - 0.0603367003367001*G0_0_1_1_2_2 - 0.00334776334776334*G0_0_1_2_0_0 + 0.0008850408850409*G0_0_1_2_0_1 - 0.0148917748917748*G0_0_1_2_0_2 + 0.000885040885040898*G0_0_1_2_1_0 + 0.000192400192400188*G0_0_1_2_1_1 - 0.0603367003367001*G0_0_1_2_1_2 - 0.0148917748917748*G0_0_1_2_2_0 - 0.0603367003367001*G0_0_1_2_2_1 - 0.125406445406444*G0_0_1_2_2_2 - 0.0215103415103412*G0_1_0_0_0_0 + 0.0273977873977874*G0_1_0_0_0_1 - 0.00334776334776334*G0_1_0_0_0_2 + 0.0273977873977874*G0_1_0_0_1_0 + 0.0817700817700816*G0_1_0_0_1_1 + 0.0008850408850409*G0_1_0_0_1_2 - 0.00334776334776334*G0_1_0_0_2_0 + 0.000885040885040898*G0_1_0_0_2_1 - 0.0148917748917748*G0_1_0_0_2_2 + 0.0273977873977874*G0_1_0_1_0_0 + 0.0817700817700816*G0_1_0_1_0_1 + 0.0008850408850409*G0_1_0_1_0_2 + 0.0817700817700816*G0_1_0_1_1_0 + 0.557190957190955*G0_1_0_1_1_1 + 0.000192400192400188*G0_1_0_1_1_2 + 0.000885040885040898*G0_1_0_1_2_0 + 0.000192400192400202*G0_1_0_1_2_1 - 0.0603367003367001*G0_1_0_1_2_2 - 0.00334776334776334*G0_1_0_2_0_0 + 0.000885040885040898*G0_1_0_2_0_1 - 0.0148917748917748*G0_1_0_2_0_2 + 0.000885040885040898*G0_1_0_2_1_0 + 0.000192400192400202*G0_1_0_2_1_1 - 0.0603367003367001*G0_1_0_2_1_2 - 0.0148917748917748*G0_1_0_2_2_0 - 0.0603367003367001*G0_1_0_2_2_1 - 0.125406445406444*G0_1_0_2_2_2 + 0.103896103896103*G0_1_1_0_0_0 + 0.0877344877344874*G0_1_1_0_0_1 + 0.0115440115440115*G0_1_1_0_0_2 + 0.0877344877344874*G0_1_1_0_1_0 + 0.0815776815776812*G0_1_1_0_1_1 + 0.0115440115440115*G0_1_1_0_2_0 - 0.0115440115440115*G0_1_1_0_2_2 + 0.0877344877344874*G0_1_1_1_0_0 + 0.0815776815776812*G0_1_1_1_0_1 + 0.0815776815776812*G0_1_1_1_1_0 - 0.0815776815776814*G0_1_1_1_1_2 - 0.0815776815776815*G0_1_1_1_2_1 - 0.0877344877344875*G0_1_1_1_2_2 + 0.0115440115440115*G0_1_1_2_0_0 - 0.0115440115440115*G0_1_1_2_0_2 - 0.0815776815776814*G0_1_1_2_1_1 - 0.0877344877344875*G0_1_1_2_1_2 - 0.0115440115440115*G0_1_1_2_2_0 - 0.0877344877344875*G0_1_1_2_2_1 - 0.103896103896103*G0_1_1_2_2_2;
    A[112] = A[160] - 0.557190957190955*G0_0_0_0_0_0 - 0.112515632515632*G0_0_0_0_0_1 + 0.0305531505531507*G0_0_0_0_0_2 - 0.112515632515632*G0_0_0_0_1_0 - 0.124059644059644*G0_0_0_0_1_1 - 0.000885040885040819*G0_0_0_0_1_2 + 0.0305531505531507*G0_0_0_0_2_0 - 0.000885040885040815*G0_0_0_0_2_1 + 0.156998556998557*G0_0_0_0_2_2 - 0.112515632515632*G0_0_0_1_0_0 - 0.124059644059644*G0_0_0_1_0_1 - 0.000885040885040822*G0_0_0_1_0_2 - 0.124059644059644*G0_0_0_1_1_0 - 0.661087061087059*G0_0_0_1_1_1 - 0.0571813371813368*G0_0_0_1_1_2 - 0.000885040885040822*G0_0_0_1_2_0 - 0.0571813371813368*G0_0_0_1_2_1 + 0.0754208754208752*G0_0_0_1_2_2 + 0.0305531505531507*G0_0_0_2_0_0 - 0.000885040885040819*G0_0_0_2_0_1 + 0.156998556998557*G0_0_0_2_0_2 - 0.000885040885040822*G0_0_0_2_1_0 - 0.0571813371813368*G0_0_0_2_1_1 + 0.0754208754208752*G0_0_0_2_1_2 + 0.156998556998557*G0_0_0_2_2_0 + 0.0754208754208752*G0_0_0_2_2_1 + 0.808003848003844*G0_0_0_2_2_2 - 0.0307455507455507*G0_0_1_0_0_1 + 0.0307455507455508*G0_0_1_0_0_2 - 0.0307455507455507*G0_0_1_0_1_0 - 0.0966618566618563*G0_0_1_0_1_1 + 0.0307455507455508*G0_0_1_0_2_0 + 0.0966618566618566*G0_0_1_0_2_2 - 0.0307455507455507*G0_0_1_1_0_0 - 0.0966618566618563*G0_0_1_1_0_1 - 0.0966618566618563*G0_0_1_1_1_0 - 0.6825974025974*G0_0_1_1_1_1 - 0.0605291005291002*G0_0_1_1_1_2 - 0.0605291005291002*G0_0_1_1_2_1 + 0.0605291005291003*G0_0_1_1_2_2 + 0.0307455507455508*G0_0_1_2_0_0 + 0.0966618566618566*G0_0_1_2_0_2 - 0.0605291005291002*G0_0_1_2_1_1 + 0.0605291005291003*G0_0_1_2_1_2 + 0.0966618566618566*G0_0_1_2_2_0 + 0.0605291005291003*G0_0_1_2_2_1 + 0.682597402597399*G0_0_1_2_2_2 - 0.0307455507455507*G0_1_0_0_0_1 + 0.0307455507455508*G0_1_0_0_0_2 - 0.0307455507455507*G0_1_0_0_1_0 - 0.0966618566618563*G0_1_0_0_1_1 + 0.0307455507455508*G0_1_0_0_2_0 + 0.0966618566618566*G0_1_0_0_2_2 - 0.0307455507455507*G0_1_0_1_0_0 - 0.0966618566618563*G0_1_0_1_0_1 - 0.0966618566618563*G0_1_0_1_1_0 - 0.6825974025974*G0_1_0_1_1_1 - 0.0605291005291002*G0_1_0_1_1_2 - 0.0605291005291002*G0_1_0_1_2_1 + 0.0605291005291003*G0_1_0_1_2_2 + 0.0307455507455508*G0_1_0_2_0_0 + 0.0966618566618566*G0_1_0_2_0_2 - 0.0605291005291002*G0_1_0_2_1_1 + 0.0605291005291003*G0_1_0_2_1_2 + 0.0966618566618566*G0_1_0_2_2_0 + 0.0605291005291003*G0_1_0_2_2_1 + 0.682597402597399*G0_1_0_2_2_2 + 0.557190957190954*G0_1_1_0_0_0 - 0.0305531505531506*G0_1_1_0_0_1 + 0.112515632515632*G0_1_1_0_0_2 - 0.0305531505531506*G0_1_1_0_1_0 - 0.156998556998556*G0_1_1_0_1_1 + 0.000885040885040916*G0_1_1_0_1_2 + 0.112515632515632*G0_1_1_0_2_0 + 0.000885040885040916*G0_1_1_0_2_1 + 0.124059644059644*G0_1_1_0_2_2 - 0.0305531505531506*G0_1_1_1_0_0 - 0.156998556998556*G0_1_1_1_0_1 + 0.000885040885040916*G0_1_1_1_0_2 - 0.156998556998556*G0_1_1_1_1_0 - 0.808003848003844*G0_1_1_1_1_1 - 0.075420875420875*G0_1_1_1_1_2 + 0.000885040885040916*G0_1_1_1_2_0 - 0.0754208754208749*G0_1_1_1_2_1 + 0.057181337181337*G0_1_1_1_2_2 + 0.112515632515632*G0_1_1_2_0_0 + 0.000885040885040916*G0_1_1_2_0_1 + 0.124059644059644*G0_1_1_2_0_2 + 0.000885040885040912*G0_1_1_2_1_0 - 0.075420875420875*G0_1_1_2_1_1 + 0.0571813371813369*G0_1_1_2_1_2 + 0.124059644059644*G0_1_1_2_2_0 + 0.0571813371813369*G0_1_1_2_2_1 + 0.661087061087058*G0_1_1_2_2_2;
    A[162] = A[187] - 0.411736411736409*G0_0_0_0_0_0 - 0.00400192400192392*G0_0_0_0_0_1 - 0.0583357383357378*G0_0_0_0_0_2 - 0.00400192400192391*G0_0_0_0_1_0 + 0.0352477152477151*G0_0_0_0_1_1 - 0.00415584415584412*G0_0_0_0_1_2 - 0.0583357383357378*G0_0_0_0_2_0 - 0.00415584415584412*G0_0_0_0_2_1 - 0.0153920153920152*G0_0_0_0_2_2 - 0.00400192400192392*G0_0_0_1_0_0 + 0.0352477152477151*G0_0_0_1_0_1 - 0.00415584415584412*G0_0_0_1_0_2 + 0.0352477152477151*G0_0_0_1_1_0 + 0.235189995189994*G0_0_0_1_1_1 + 0.034324194324194*G0_0_0_1_1_2 - 0.00415584415584412*G0_0_0_1_2_0 + 0.034324194324194*G0_0_0_1_2_1 - 0.0403270803270803*G0_0_0_1_2_2 - 0.0583357383357378*G0_0_0_2_0_0 - 0.00415584415584412*G0_0_0_2_0_1 - 0.0153920153920152*G0_0_0_2_0_2 - 0.00415584415584412*G0_0_0_2_1_0 + 0.034324194324194*G0_0_0_2_1_1 - 0.0403270803270803*G0_0_0_2_1_2 - 0.0153920153920152*G0_0_0_2_2_0 - 0.0403270803270803*G0_0_0_2_2_1 - 0.161000481000481*G0_0_0_2_2_2 + 0.115670995670995*G0_0_1_0_0_1 - 0.115670995670995*G0_0_1_0_0_2 + 0.115670995670995*G0_0_1_0_1_0 + 0.0807311207311202*G0_0_1_0_1_1 - 0.115670995670995*G0_0_1_0_2_0 - 0.0807311207311204*G0_0_1_0_2_2 + 0.115670995670995*G0_0_1_1_0_0 + 0.0807311207311202*G0_0_1_1_0_1 + 0.0807311207311202*G0_0_1_1_1_0 + 0.224415584415583*G0_0_1_1_1_1 + 0.0402501202501199*G0_0_1_1_1_2 + 0.0402501202501199*G0_0_1_1_2_1 - 0.0402501202501202*G0_0_1_1_2_2 - 0.115670995670995*G0_0_1_2_0_0 - 0.0807311207311204*G0_0_1_2_0_2 + 0.0402501202501199*G0_0_1_2_1_1 - 0.0402501202501202*G0_0_1_2_1_2 - 0.0807311207311204*G0_0_1_2_2_0 - 0.0402501202501202*G0_0_1_2_2_1 - 0.224415584415584*G0_0_1_2_2_2 + 0.0202405002405001*G0_1_0_0_0_1 - 0.0202405002405*G0_1_0_0_0_2 + 0.0202405002405002*G0_1_0_0_1_0 + 0.0576430976430974*G0_1_0_0_1_1 - 0.0202405002405*G0_1_0_0_2_0 - 0.0576430976430974*G0_1_0_0_2_2 + 0.0202405002405002*G0_1_0_1_0_0 + 0.0576430976430974*G0_1_0_1_0_1 + 0.0576430976430974*G0_1_0_1_1_0 + 0.275670995670994*G0_1_0_1_1_1 + 0.0459451659451656*G0_1_0_1_1_2 + 0.0459451659451655*G0_1_0_1_2_1 - 0.045945165945166*G0_1_0_1_2_2 - 0.0202405002405*G0_1_0_2_0_0 - 0.0576430976430974*G0_1_0_2_0_2 + 0.0459451659451655*G0_1_0_2_1_1 - 0.0459451659451659*G0_1_0_2_1_2 - 0.0576430976430974*G0_1_0_2_2_0 - 0.045945165945166*G0_1_0_2_2_1 - 0.275670995670995*G0_1_0_2_2_2 + 0.411736411736409*G0_1_1_0_0_0 + 0.0583357383357378*G0_1_1_0_0_1 + 0.00400192400192384*G0_1_1_0_0_2 + 0.0583357383357378*G0_1_1_0_1_0 + 0.0153920153920152*G0_1_1_0_1_1 + 0.00415584415584408*G0_1_1_0_1_2 + 0.00400192400192384*G0_1_1_0_2_0 + 0.00415584415584408*G0_1_1_0_2_1 - 0.0352477152477153*G0_1_1_0_2_2 + 0.0583357383357378*G0_1_1_1_0_0 + 0.0153920153920152*G0_1_1_1_0_1 + 0.00415584415584408*G0_1_1_1_0_2 + 0.0153920153920152*G0_1_1_1_1_0 + 0.16100048100048*G0_1_1_1_1_1 + 0.04032708032708*G0_1_1_1_1_2 + 0.00415584415584408*G0_1_1_1_2_0 + 0.04032708032708*G0_1_1_1_2_1 - 0.0343241943241943*G0_1_1_1_2_2 + 0.00400192400192385*G0_1_1_2_0_0 + 0.00415584415584408*G0_1_1_2_0_1 - 0.0352477152477153*G0_1_1_2_0_2 + 0.00415584415584408*G0_1_1_2_1_0 + 0.04032708032708*G0_1_1_2_1_1 - 0.0343241943241943*G0_1_1_2_1_2 - 0.0352477152477153*G0_1_1_2_2_0 - 0.0343241943241943*G0_1_1_2_2_1 - 0.235189995189995*G0_1_1_2_2_2;
    A[214] = A[162] + 0.369408369408367*G0_0_0_0_0_0 - 0.00631072631072636*G0_0_0_0_0_1 + 0.0432515632515629*G0_0_0_0_0_2 - 0.00631072631072636*G0_0_0_0_1_0 - 0.0551034151034149*G0_0_0_0_1_1 - 0.03001443001443*G0_0_0_0_1_2 + 0.0432515632515629*G0_0_0_0_2_0 - 0.03001443001443*G0_0_0_0_2_1 - 0.108051948051948*G0_0_0_0_2_2 - 0.00631072631072636*G0_0_0_1_0_0 - 0.0551034151034149*G0_0_0_1_0_1 - 0.03001443001443*G0_0_0_1_0_2 - 0.0551034151034149*G0_0_0_1_1_0 - 0.385569985569984*G0_0_0_1_1_1 - 0.209485329485328*G0_0_0_1_1_2 - 0.03001443001443*G0_0_0_1_2_0 - 0.209485329485328*G0_0_0_1_2_1 - 0.254891774891774*G0_0_0_1_2_2 + 0.0432515632515629*G0_0_0_2_0_0 - 0.03001443001443*G0_0_0_2_0_1 - 0.108051948051948*G0_0_0_2_0_2 - 0.03001443001443*G0_0_0_2_1_0 - 0.209485329485328*G0_0_0_2_1_1 - 0.254891774891774*G0_0_0_2_1_2 - 0.108051948051948*G0_0_0_2_2_0 - 0.254891774891774*G0_0_0_2_2_1 - 0.77483405483405*G0_0_0_2_2_2 - 0.270591630591629*G0_0_1_0_0_0 - 0.135834535834535*G0_0_1_0_0_1 - 0.0303992303992303*G0_0_1_0_0_2 - 0.135834535834535*G0_0_1_0_1_0 - 0.0982780182780177*G0_0_1_0_1_1 - 0.0300144300144299*G0_0_1_0_1_2 - 0.0303992303992303*G0_0_1_0_2_0 - 0.0300144300144299*G0_0_1_0_2_1 - 0.0344011544011544*G0_0_1_0_2_2 - 0.135834535834535*G0_0_1_1_0_0 - 0.0982780182780177*G0_0_1_1_0_1 - 0.0300144300144299*G0_0_1_1_0_2 - 0.0982780182780177*G0_0_1_1_1_0 - 0.385569985569984*G0_0_1_1_1_1 - 0.166310726310726*G0_0_1_1_1_2 - 0.0300144300144299*G0_0_1_1_2_0 - 0.166310726310726*G0_0_1_1_2_1 - 0.125367965367965*G0_0_1_1_2_2 - 0.0303992303992303*G0_0_1_2_0_0 - 0.0300144300144299*G0_0_1_2_0_1 - 0.0344011544011544*G0_0_1_2_0_2 - 0.0300144300144299*G0_0_1_2_1_0 - 0.166310726310726*G0_0_1_2_1_1 - 0.125367965367965*G0_0_1_2_1_2 - 0.0344011544011544*G0_0_1_2_2_0 - 0.125367965367965*G0_0_1_2_2_1 - 0.134834054834055*G0_0_1_2_2_2 - 0.130678210678211*G0_1_0_0_0_0 - 0.053025493025493*G0_1_0_0_0_1 - 0.0364021164021164*G0_1_0_0_0_2 - 0.053025493025493*G0_1_0_0_1_0 - 0.076113516113516*G0_1_0_0_1_1 - 0.03001443001443*G0_1_0_0_1_2 - 0.0364021164021164*G0_1_0_0_2_0 - 0.03001443001443*G0_1_0_0_2_1 - 0.0283982683982685*G0_1_0_0_2_2 - 0.053025493025493*G0_1_0_1_0_0 - 0.076113516113516*G0_1_0_1_0_1 - 0.03001443001443*G0_1_0_1_0_2 - 0.076113516113516*G0_1_0_1_1_0 - 0.385569985569984*G0_1_0_1_1_1 - 0.188475228475228*G0_1_0_1_1_2 - 0.03001443001443*G0_1_0_1_2_0 - 0.188475228475228*G0_1_0_1_2_1 - 0.208177008177007*G0_1_0_1_2_2 - 0.0364021164021164*G0_1_0_2_0_0 - 0.03001443001443*G0_1_0_2_0_1 - 0.0283982683982685*G0_1_0_2_0_2 - 0.03001443001443*G0_1_0_2_1_0 - 0.188475228475228*G0_1_0_2_1_1 - 0.208177008177007*G0_1_0_2_1_2 - 0.0283982683982685*G0_1_0_2_2_0 - 0.208177008177007*G0_1_0_2_2_1 - 0.274747474747474*G0_1_0_2_2_2 + 0.00415584415584415*G0_1_1_0_0_0 + 0.072342472342472*G0_1_1_0_0_1 - 0.00200096200096202*G0_1_1_0_0_2 + 0.072342472342472*G0_1_1_0_1_0 + 0.0901972101972098*G0_1_1_0_1_1 - 0.00200096200096202*G0_1_1_0_2_0 + 0.00200096200096196*G0_1_1_0_2_2 + 0.072342472342472*G0_1_1_1_0_0 + 0.0901972101972098*G0_1_1_1_0_1 + 0.0901972101972098*G0_1_1_1_1_0 - 0.0901972101972097*G0_1_1_1_1_2 - 0.0901972101972097*G0_1_1_1_2_1 - 0.072342472342472*G0_1_1_1_2_2 - 0.00200096200096202*G0_1_1_2_0_0 + 0.00200096200096196*G0_1_1_2_0_2 - 0.0901972101972097*G0_1_1_2_1_1 - 0.072342472342472*G0_1_1_2_1_2 + 0.00200096200096196*G0_1_1_2_2_0 - 0.072342472342472*G0_1_1_2_2_1 - 0.00415584415584468*G0_1_1_2_2_2;
    A[166] = -A[46] - 0.044508577841911*G0_0_0_0_0_0 - 0.00696916252471807*G0_0_0_0_0_1 - 0.0148361926139703*G0_0_0_0_0_2 - 0.00696916252471807*G0_0_0_0_1_0 - 0.01000481000481*G0_0_0_0_1_1 - 0.00348458126235903*G0_0_0_0_1_2 - 0.0148361926139703*G0_0_0_0_2_0 - 0.00348458126235903*G0_0_0_0_2_1 - 0.0148361926139703*G0_0_0_0_2_2 - 0.00696916252471807*G0_0_0_1_0_0 - 0.01000481000481*G0_0_0_1_0_1 - 0.00348458126235903*G0_0_0_1_0_2 - 0.01000481000481*G0_0_0_1_1_0 - 0.224082090748757*G0_0_0_1_1_1 - 0.01000481000481*G0_0_0_1_1_2 - 0.00348458126235903*G0_0_0_1_2_0 - 0.01000481000481*G0_0_0_1_2_1 - 0.00696916252471806*G0_0_0_1_2_2 - 0.0148361926139703*G0_0_0_2_0_0 - 0.00348458126235903*G0_0_0_2_0_1 - 0.0148361926139703*G0_0_0_2_0_2 - 0.00348458126235903*G0_0_0_2_1_0 - 0.01000481000481*G0_0_0_2_1_1 - 0.00696916252471806*G0_0_0_2_1_2 - 0.0148361926139703*G0_0_0_2_2_0 - 0.00696916252471806*G0_0_0_2_2_1 - 0.0445085778419109*G0_0_0_2_2_2;
    A[115] = A[157] - 0.0230880230880238*G0_0_1_0_0_0 + 0.0136604136604135*G0_0_1_0_0_1 + 0.0136604136604134*G0_0_1_0_0_2 + 0.0136604136604135*G0_0_1_0_1_0 - 0.000153920153920193*G0_0_1_0_1_1 - 0.00504088504088505*G0_0_1_0_1_2 + 0.0136604136604134*G0_0_1_0_2_0 - 0.00504088504088505*G0_0_1_0_2_1 - 0.000153920153920305*G0_0_1_0_2_2 + 0.0136604136604135*G0_0_1_1_0_0 - 0.000153920153920193*G0_0_1_1_0_1 - 0.00504088504088505*G0_0_1_1_0_2 - 0.000153920153920193*G0_0_1_1_1_0 - 0.00681096681096688*G0_0_1_1_1_1 - 0.00234728234728233*G0_0_1_1_1_2 - 0.00504088504088505*G0_0_1_1_2_0 - 0.00234728234728233*G0_0_1_1_2_1 - 0.00234728234728233*G0_0_1_1_2_2 + 0.0136604136604134*G0_0_1_2_0_0 - 0.00504088504088505*G0_0_1_2_0_1 - 0.000153920153920304*G0_0_1_2_0_2 - 0.00504088504088505*G0_0_1_2_1_0 - 0.00234728234728233*G0_0_1_2_1_1 - 0.00234728234728233*G0_0_1_2_1_2 - 0.000153920153920304*G0_0_1_2_2_0 - 0.00234728234728233*G0_0_1_2_2_1 - 0.00681096681096667*G0_0_1_2_2_2 + 0.0230880230880239*G0_1_0_0_0_0 - 0.0136604136604135*G0_1_0_0_0_1 - 0.0136604136604134*G0_1_0_0_0_2 - 0.0136604136604135*G0_1_0_0_1_0 + 0.000153920153920193*G0_1_0_0_1_1 + 0.00504088504088505*G0_1_0_0_1_2 - 0.0136604136604134*G0_1_0_0_2_0 + 0.00504088504088505*G0_1_0_0_2_1 + 0.000153920153920305*G0_1_0_0_2_2 - 0.0136604136604135*G0_1_0_1_0_0 + 0.000153920153920193*G0_1_0_1_0_1 + 0.00504088504088505*G0_1_0_1_0_2 + 0.000153920153920193*G0_1_0_1_1_0 + 0.00681096681096688*G0_1_0_1_1_1 + 0.00234728234728233*G0_1_0_1_1_2 + 0.00504088504088505*G0_1_0_1_2_0 + 0.00234728234728233*G0_1_0_1_2_1 + 0.00234728234728233*G0_1_0_1_2_2 - 0.0136604136604134*G0_1_0_2_0_0 + 0.00504088504088505*G0_1_0_2_0_1 + 0.000153920153920307*G0_1_0_2_0_2 + 0.00504088504088505*G0_1_0_2_1_0 + 0.00234728234728233*G0_1_0_2_1_1 + 0.00234728234728233*G0_1_0_2_1_2 + 0.000153920153920307*G0_1_0_2_2_0 + 0.00234728234728233*G0_1_0_2_2_1 + 0.00681096681096667*G0_1_0_2_2_2;
    A[224] = A[208] - 0.147763347763347*G0_0_0_0_0_0 - 0.0788071188071185*G0_0_0_0_0_1 + 0.00985088985088978*G0_0_0_0_0_2 - 0.0788071188071185*G0_0_0_0_1_0 - 0.103434343434343*G0_0_0_0_1_1 - 0.0344781144781143*G0_0_0_0_1_2 + 0.00985088985088978*G0_0_0_0_2_0 - 0.0344781144781143*G0_0_0_0_2_1 + 0.187166907166906*G0_0_0_0_2_2 - 0.0788071188071185*G0_0_0_1_0_0 - 0.103434343434343*G0_0_0_1_0_1 - 0.0344781144781143*G0_0_0_1_0_2 - 0.103434343434343*G0_0_0_1_1_0 - 0.812698412698408*G0_0_0_1_1_1 - 0.167465127465126*G0_0_0_1_1_2 - 0.0344781144781143*G0_0_0_1_2_0 - 0.167465127465126*G0_0_0_1_2_1 + 0.147763347763348*G0_0_0_1_2_2 + 0.0098508898508898*G0_0_0_2_0_0 - 0.0344781144781143*G0_0_0_2_0_1 + 0.187166907166906*G0_0_0_2_0_2 - 0.0344781144781143*G0_0_0_2_1_0 - 0.167465127465126*G0_0_0_2_1_1 + 0.147763347763348*G0_0_0_2_1_2 + 0.187166907166906*G0_0_0_2_2_0 + 0.147763347763348*G0_0_0_2_2_1 + 1.18210678210678*G0_0_0_2_2_2 - 0.0246272246272244*G0_0_1_0_0_1 + 0.0246272246272244*G0_0_1_0_0_2 - 0.0246272246272244*G0_0_1_0_1_0 - 0.0566426166426163*G0_0_1_0_1_1 + 0.0246272246272244*G0_0_1_0_2_0 + 0.0566426166426164*G0_0_1_0_2_2 - 0.0246272246272244*G0_0_1_1_0_0 - 0.0566426166426163*G0_0_1_1_0_1 - 0.0566426166426163*G0_0_1_1_1_0 - 0.664935064935061*G0_0_1_1_1_1 - 0.145300625300624*G0_0_1_1_1_2 - 0.145300625300624*G0_0_1_1_2_1 + 0.145300625300625*G0_0_1_1_2_2 + 0.0246272246272244*G0_0_1_2_0_0 + 0.0566426166426164*G0_0_1_2_0_2 - 0.145300625300624*G0_0_1_2_1_1 + 0.145300625300625*G0_0_1_2_1_2 + 0.0566426166426164*G0_0_1_2_2_0 + 0.145300625300625*G0_0_1_2_2_1 + 0.664935064935063*G0_0_1_2_2_2 - 0.0246272246272244*G0_1_0_0_0_1 + 0.0246272246272244*G0_1_0_0_0_2 - 0.0246272246272244*G0_1_0_0_1_0 - 0.0566426166426163*G0_1_0_0_1_1 + 0.0246272246272244*G0_1_0_0_2_0 + 0.0566426166426164*G0_1_0_0_2_2 - 0.0246272246272244*G0_1_0_1_0_0 - 0.0566426166426163*G0_1_0_1_0_1 - 0.0566426166426163*G0_1_0_1_1_0 - 0.664935064935061*G0_1_0_1_1_1 - 0.145300625300624*G0_1_0_1_1_2 - 0.145300625300624*G0_1_0_1_2_1 + 0.145300625300625*G0_1_0_1_2_2 + 0.0246272246272244*G0_1_0_2_0_0 + 0.0566426166426164*G0_1_0_2_0_2 - 0.145300625300624*G0_1_0_2_1_1 + 0.145300625300625*G0_1_0_2_1_2 + 0.0566426166426164*G0_1_0_2_2_0 + 0.145300625300625*G0_1_0_2_2_1 + 0.664935064935063*G0_1_0_2_2_2 + 0.147763347763348*G0_1_1_0_0_0 - 0.00985088985088992*G0_1_1_0_0_1 + 0.0788071188071185*G0_1_1_0_0_2 - 0.00985088985088992*G0_1_1_0_1_0 - 0.187166907166906*G0_1_1_0_1_1 + 0.0344781144781144*G0_1_1_0_1_2 + 0.0788071188071185*G0_1_1_0_2_0 + 0.0344781144781144*G0_1_1_0_2_1 + 0.103434343434343*G0_1_1_0_2_2 - 0.00985088985088992*G0_1_1_1_0_0 - 0.187166907166906*G0_1_1_1_0_1 + 0.0344781144781144*G0_1_1_1_0_2 - 0.187166907166906*G0_1_1_1_1_0 - 1.18210678210678*G0_1_1_1_1_1 - 0.147763347763347*G0_1_1_1_1_2 + 0.0344781144781144*G0_1_1_1_2_0 - 0.147763347763347*G0_1_1_1_2_1 + 0.167465127465127*G0_1_1_1_2_2 + 0.0788071188071185*G0_1_1_2_0_0 + 0.0344781144781144*G0_1_1_2_0_1 + 0.103434343434343*G0_1_1_2_0_2 + 0.0344781144781144*G0_1_1_2_1_0 - 0.147763347763347*G0_1_1_2_1_1 + 0.167465127465127*G0_1_1_2_1_2 + 0.103434343434343*G0_1_1_2_2_0 + 0.167465127465127*G0_1_1_2_2_1 + 0.812698412698409*G0_1_1_2_2_2;
    A[190] = A[162] - 0.122366522366521*G0_0_1_0_0_0 - 0.0711880711880706*G0_0_1_0_0_1 + 0.0242424242424244*G0_0_1_0_0_2 - 0.0711880711880706*G0_0_1_0_1_0 - 0.00484848484848463*G0_0_1_0_1_1 + 0.00831168831168831*G0_0_1_0_1_2 + 0.0242424242424244*G0_0_1_0_2_0 + 0.00831168831168831*G0_0_1_0_2_1 + 0.0182395382395383*G0_0_1_0_2_2 - 0.0711880711880706*G0_0_1_1_0_0 - 0.00484848484848463*G0_0_1_1_0_1 + 0.00831168831168831*G0_0_1_1_0_2 - 0.00484848484848463*G0_0_1_1_1_0 + 0.0688023088023089*G0_0_1_1_1_1 + 0.0173160173160172*G0_0_1_1_1_2 + 0.00831168831168831*G0_0_1_1_2_0 + 0.0173160173160172*G0_0_1_1_2_1 + 0.0116209716209716*G0_0_1_1_2_2 + 0.0242424242424243*G0_0_1_2_0_0 + 0.00831168831168831*G0_0_1_2_0_1 + 0.0182395382395383*G0_0_1_2_0_2 + 0.00831168831168831*G0_0_1_2_1_0 + 0.0173160173160172*G0_0_1_2_1_1 + 0.0116209716209716*G0_0_1_2_1_2 + 0.0182395382395383*G0_0_1_2_2_0 + 0.0116209716209716*G0_0_1_2_2_1 + 0.0175468975468976*G0_0_1_2_2_2 + 0.122366522366521*G0_1_0_0_0_0 + 0.0711880711880706*G0_1_0_0_0_1 - 0.0242424242424244*G0_1_0_0_0_2 + 0.0711880711880706*G0_1_0_0_1_0 + 0.00484848484848462*G0_1_0_0_1_1 - 0.00831168831168831*G0_1_0_0_1_2 - 0.0242424242424244*G0_1_0_0_2_0 - 0.00831168831168831*G0_1_0_0_2_1 - 0.0182395382395383*G0_1_0_0_2_2 + 0.0711880711880706*G0_1_0_1_0_0 + 0.00484848484848463*G0_1_0_1_0_1 - 0.00831168831168831*G0_1_0_1_0_2 + 0.00484848484848463*G0_1_0_1_1_0 - 0.0688023088023089*G0_1_0_1_1_1 - 0.0173160173160172*G0_1_0_1_1_2 - 0.00831168831168831*G0_1_0_1_2_0 - 0.0173160173160172*G0_1_0_1_2_1 - 0.0116209716209716*G0_1_0_1_2_2 - 0.0242424242424244*G0_1_0_2_0_0 - 0.00831168831168831*G0_1_0_2_0_1 - 0.0182395382395383*G0_1_0_2_0_2 - 0.00831168831168831*G0_1_0_2_1_0 - 0.0173160173160172*G0_1_0_2_1_1 - 0.0116209716209716*G0_1_0_2_1_2 - 0.0182395382395383*G0_1_0_2_2_0 - 0.0116209716209716*G0_1_0_2_2_1 - 0.0175468975468976*G0_1_0_2_2_2;
    A[206] = -A[198] - 0.20481641814975*G0_0_0_0_0_0 - 0.0248324514991181*G0_0_0_0_0_1 - 0.104460477793811*G0_0_0_0_0_2 - 0.0248324514991181*G0_0_0_0_1_0 - 0.0256533589866922*G0_0_0_0_1_1 - 0.0285265351932018*G0_0_0_0_1_2 - 0.104460477793811*G0_0_0_0_2_0 - 0.0285265351932018*G0_0_0_0_2_1 - 0.108565015231681*G0_0_0_0_2_2 - 0.0248324514991181*G0_0_0_1_0_0 - 0.0256533589866922*G0_0_0_1_0_1 - 0.0285265351932018*G0_0_0_1_0_2 - 0.0256533589866922*G0_0_0_1_1_0 - 0.201122334455667*G0_0_0_1_1_1 - 0.134423601090267*G0_0_0_1_1_2 - 0.0285265351932018*G0_0_0_1_2_0 - 0.134423601090267*G0_0_0_1_2_1 - 0.0966618566618563*G0_0_0_1_2_2 - 0.104460477793811*G0_0_0_2_0_0 - 0.0285265351932018*G0_0_0_2_0_1 - 0.108565015231681*G0_0_0_2_0_2 - 0.0285265351932018*G0_0_0_2_1_0 - 0.134423601090267*G0_0_0_2_1_1 - 0.0966618566618563*G0_0_0_2_1_2 - 0.108565015231681*G0_0_0_2_2_0 - 0.0966618566618563*G0_0_0_2_2_1 - 0.241757255090588*G0_0_0_2_2_2 + 0.0369408369408369*G0_1_0_0_0_0 + 0.0718294051627382*G0_1_0_0_0_1 + 0.0041045374378707*G0_1_0_0_0_2 + 0.0718294051627382*G0_1_0_0_1_0 + 0.108770242103575*G0_1_0_0_1_1 + 0.0041045374378707*G0_1_0_0_2_0 - 0.00410453743787088*G0_1_0_0_2_2 + 0.0718294051627382*G0_1_0_1_0_0 + 0.108770242103575*G0_1_0_1_0_1 + 0.108770242103575*G0_1_0_1_1_0 - 0.108770242103575*G0_1_0_1_1_2 - 0.108770242103575*G0_1_0_1_2_1 - 0.0718294051627383*G0_1_0_1_2_2 + 0.0041045374378707*G0_1_0_2_0_0 - 0.00410453743787088*G0_1_0_2_0_2 - 0.108770242103575*G0_1_0_2_1_1 - 0.0718294051627383*G0_1_0_2_1_2 - 0.00410453743787088*G0_1_0_2_2_0 - 0.0718294051627383*G0_1_0_2_2_1 - 0.0369408369408373*G0_1_0_2_2_2;
    A[178] = A[206] + 0.0252429052429052*G0_0_1_0_0_0 + 0.0557190957190955*G0_0_1_0_0_1 + 0.00030784030784026*G0_0_1_0_0_2 + 0.0557190957190955*G0_0_1_0_1_0 + 0.0672118005451336*G0_0_1_0_1_1 + 0.0012313612313612*G0_0_1_0_1_2 + 0.00030784030784026*G0_0_1_0_2_0 + 0.00123136123136119*G0_0_1_0_2_1 - 0.00379669713003051*G0_0_1_0_2_2 + 0.0557190957190955*G0_0_1_1_0_0 + 0.0672118005451336*G0_0_1_1_0_1 + 0.00123136123136119*G0_0_1_1_0_2 + 0.0672118005451336*G0_0_1_1_1_0 - 0.206253006253005*G0_0_1_1_1_1 - 0.0415584415584415*G0_0_1_1_1_2 + 0.00123136123136119*G0_0_1_1_2_0 - 0.0415584415584415*G0_0_1_1_2_1 - 0.0161103094436428*G0_0_1_1_2_2 + 0.00030784030784026*G0_0_1_2_0_0 + 0.00123136123136119*G0_0_1_2_0_1 - 0.00379669713003051*G0_0_1_2_0_2 + 0.00123136123136119*G0_0_1_2_1_0 - 0.0415584415584415*G0_0_1_2_1_1 - 0.0161103094436428*G0_0_1_2_1_2 - 0.00379669713003051*G0_0_1_2_2_0 - 0.0161103094436428*G0_0_1_2_2_1 - 0.0116979316979318*G0_0_1_2_2_2 - 0.0252429052429052*G0_1_0_0_0_0 - 0.0557190957190955*G0_1_0_0_0_1 - 0.000307840307840257*G0_1_0_0_0_2 - 0.0557190957190955*G0_1_0_0_1_0 - 0.0672118005451336*G0_1_0_0_1_1 - 0.00123136123136119*G0_1_0_0_1_2 - 0.000307840307840257*G0_1_0_0_2_0 - 0.00123136123136119*G0_1_0_0_2_1 + 0.00379669713003051*G0_1_0_0_2_2 - 0.0557190957190955*G0_1_0_1_0_0 - 0.0672118005451336*G0_1_0_1_0_1 - 0.00123136123136119*G0_1_0_1_0_2 - 0.0672118005451336*G0_1_0_1_1_0 + 0.206253006253005*G0_1_0_1_1_1 + 0.0415584415584415*G0_1_0_1_1_2 - 0.00123136123136119*G0_1_0_1_2_0 + 0.0415584415584415*G0_1_0_1_2_1 + 0.0161103094436428*G0_1_0_1_2_2 - 0.000307840307840257*G0_1_0_2_0_0 - 0.00123136123136119*G0_1_0_2_0_1 + 0.00379669713003051*G0_1_0_2_0_2 - 0.00123136123136119*G0_1_0_2_1_0 + 0.0415584415584415*G0_1_0_2_1_1 + 0.0161103094436428*G0_1_0_2_1_2 + 0.00379669713003051*G0_1_0_2_2_0 + 0.0161103094436428*G0_1_0_2_2_1 + 0.0116979316979318*G0_1_0_2_2_2;
    A[0] = A[16] + 0.225845759179092*G0_0_0_0_0_0 + 0.0113409224520335*G0_0_0_0_0_1 + 0.0111378333600555*G0_0_0_0_0_2 + 0.0113409224520335*G0_0_0_0_1_0 - 0.0113409224520335*G0_0_0_0_1_1 + 0.0111378333600555*G0_0_0_0_2_0 - 0.000203089091977975*G0_0_0_0_2_2 + 0.0113409224520335*G0_0_0_1_0_0 - 0.0113409224520335*G0_0_0_1_0_1 - 0.0113409224520335*G0_0_0_1_1_0 - 0.225845759179091*G0_0_0_1_1_1 - 0.0111378333600555*G0_0_0_1_1_2 - 0.0111378333600555*G0_0_0_1_2_1 + 0.000203089091977975*G0_0_0_1_2_2 + 0.0111378333600555*G0_0_0_2_0_0 - 0.000203089091977975*G0_0_0_2_0_2 - 0.0111378333600555*G0_0_0_2_1_1 + 0.000203089091977975*G0_0_0_2_1_2 - 0.000203089091977975*G0_0_0_2_2_0 + 0.000203089091977975*G0_0_0_2_2_1 + 0.234062850729517*G0_0_1_0_0_0 + 0.0138768638768638*G0_0_1_0_0_1 + 0.0138768638768638*G0_0_1_0_0_2 + 0.0138768638768638*G0_0_1_0_1_0 + 0.0025359414248303*G0_0_1_0_1_1 + 0.00126797071241515*G0_0_1_0_1_2 + 0.0138768638768638*G0_0_1_0_2_0 + 0.00126797071241515*G0_0_1_0_2_1 + 0.0025359414248303*G0_0_1_0_2_2 + 0.0138768638768638*G0_0_1_1_0_0 + 0.0025359414248303*G0_0_1_1_0_1 + 0.00126797071241515*G0_0_1_1_0_2 + 0.0025359414248303*G0_0_1_1_1_0 + 0.00821709155042479*G0_0_1_1_1_1 + 0.00273903051680827*G0_0_1_1_1_2 + 0.00126797071241515*G0_0_1_1_2_0 + 0.00273903051680827*G0_0_1_1_2_1 + 0.00273903051680827*G0_0_1_1_2_2 + 0.0138768638768638*G0_0_1_2_0_0 + 0.00126797071241515*G0_0_1_2_0_1 + 0.0025359414248303*G0_0_1_2_0_2 + 0.00126797071241515*G0_0_1_2_1_0 + 0.00273903051680827*G0_0_1_2_1_1 + 0.00273903051680827*G0_0_1_2_1_2 + 0.0025359414248303*G0_0_1_2_2_0 + 0.00273903051680827*G0_0_1_2_2_1 + 0.00821709155042485*G0_0_1_2_2_2 + 0.234062850729517*G0_1_0_0_0_0 + 0.0138768638768638*G0_1_0_0_0_1 + 0.0138768638768638*G0_1_0_0_0_2 + 0.0138768638768638*G0_1_0_0_1_0 + 0.0025359414248303*G0_1_0_0_1_1 + 0.00126797071241515*G0_1_0_0_1_2 + 0.0138768638768638*G0_1_0_0_2_0 + 0.00126797071241515*G0_1_0_0_2_1 + 0.0025359414248303*G0_1_0_0_2_2 + 0.0138768638768638*G0_1_0_1_0_0 + 0.0025359414248303*G0_1_0_1_0_1 + 0.00126797071241515*G0_1_0_1_0_2 + 0.0025359414248303*G0_1_0_1_1_0 + 0.00821709155042479*G0_1_0_1_1_1 + 0.00273903051680827*G0_1_0_1_1_2 + 0.00126797071241515*G0_1_0_1_2_0 + 0.00273903051680827*G0_1_0_1_2_1 + 0.00273903051680827*G0_1_0_1_2_2 + 0.0138768638768638*G0_1_0_2_0_0 + 0.00126797071241515*G0_1_0_2_0_1 + 0.0025359414248303*G0_1_0_2_0_2 + 0.00126797071241515*G0_1_0_2_1_0 + 0.00273903051680827*G0_1_0_2_1_1 + 0.00273903051680827*G0_1_0_2_1_2 + 0.0025359414248303*G0_1_0_2_2_0 + 0.00273903051680827*G0_1_0_2_2_1 + 0.00821709155042485*G0_1_0_2_2_2 + 0.234062850729517*G0_1_1_0_0_0 + 0.0138768638768638*G0_1_1_0_0_1 + 0.0138768638768638*G0_1_1_0_0_2 + 0.0138768638768638*G0_1_1_0_1_0 + 0.0025359414248303*G0_1_1_0_1_1 + 0.00126797071241515*G0_1_1_0_1_2 + 0.0138768638768638*G0_1_1_0_2_0 + 0.00126797071241515*G0_1_1_0_2_1 + 0.00253594142483031*G0_1_1_0_2_2 + 0.0138768638768638*G0_1_1_1_0_0 + 0.0025359414248303*G0_1_1_1_0_1 + 0.00126797071241515*G0_1_1_1_0_2 + 0.0025359414248303*G0_1_1_1_1_0 + 0.00821709155042481*G0_1_1_1_1_1 + 0.00273903051680827*G0_1_1_1_1_2 + 0.00126797071241515*G0_1_1_1_2_0 + 0.00273903051680827*G0_1_1_1_2_1 + 0.00273903051680827*G0_1_1_1_2_2 + 0.0138768638768638*G0_1_1_2_0_0 + 0.00126797071241515*G0_1_1_2_0_1 + 0.00253594142483031*G0_1_1_2_0_2 + 0.00126797071241515*G0_1_1_2_1_0 + 0.00273903051680827*G0_1_1_2_1_1 + 0.00273903051680827*G0_1_1_2_1_2 + 0.00253594142483031*G0_1_1_2_2_0 + 0.00273903051680827*G0_1_1_2_2_1 + 0.00821709155042486*G0_1_1_2_2_2;
    A[58] = -A[178] - 0.20481641814975*G0_0_0_0_0_0 - 0.0248324514991181*G0_0_0_0_0_1 - 0.104460477793811*G0_0_0_0_0_2 - 0.0248324514991181*G0_0_0_0_1_0 - 0.0256533589866922*G0_0_0_0_1_1 - 0.0285265351932018*G0_0_0_0_1_2 - 0.104460477793811*G0_0_0_0_2_0 - 0.0285265351932018*G0_0_0_0_2_1 - 0.108565015231681*G0_0_0_0_2_2 - 0.0248324514991181*G0_0_0_1_0_0 - 0.0256533589866922*G0_0_0_1_0_1 - 0.0285265351932018*G0_0_0_1_0_2 - 0.0256533589866922*G0_0_0_1_1_0 - 0.201122334455667*G0_0_0_1_1_1 - 0.134423601090267*G0_0_0_1_1_2 - 0.0285265351932018*G0_0_0_1_2_0 - 0.134423601090267*G0_0_0_1_2_1 - 0.0966618566618563*G0_0_0_1_2_2 - 0.104460477793811*G0_0_0_2_0_0 - 0.0285265351932018*G0_0_0_2_0_1 - 0.108565015231681*G0_0_0_2_0_2 - 0.0285265351932018*G0_0_0_2_1_0 - 0.134423601090267*G0_0_0_2_1_1 - 0.0966618566618563*G0_0_0_2_1_2 - 0.108565015231681*G0_0_0_2_2_0 - 0.0966618566618563*G0_0_0_2_2_1 - 0.241757255090588*G0_0_0_2_2_2 + 0.0369408369408369*G0_0_1_0_0_0 + 0.0718294051627382*G0_0_1_0_0_1 + 0.0041045374378707*G0_0_1_0_0_2 + 0.0718294051627382*G0_0_1_0_1_0 + 0.108770242103575*G0_0_1_0_1_1 + 0.0041045374378707*G0_0_1_0_2_0 - 0.00410453743787088*G0_0_1_0_2_2 + 0.0718294051627382*G0_0_1_1_0_0 + 0.108770242103575*G0_0_1_1_0_1 + 0.108770242103575*G0_0_1_1_1_0 - 0.108770242103575*G0_0_1_1_1_2 - 0.108770242103575*G0_0_1_1_2_1 - 0.0718294051627383*G0_0_1_1_2_2 + 0.0041045374378707*G0_0_1_2_0_0 - 0.00410453743787088*G0_0_1_2_0_2 - 0.108770242103575*G0_0_1_2_1_1 - 0.0718294051627383*G0_0_1_2_1_2 - 0.00410453743787088*G0_0_1_2_2_0 - 0.0718294051627383*G0_0_1_2_2_1 - 0.0369408369408373*G0_0_1_2_2_2;
    A[28] = 0.0368125701459033*G0_0_0_0_0_0 + 0.00282186948853613*G0_0_0_0_0_1 + 0.0184960718294051*G0_0_0_0_0_2 + 0.00282186948853613*G0_0_0_0_1_0 - 0.0105178771845438*G0_0_0_0_1_1 + 0.00205226871893538*G0_0_0_0_1_2 + 0.0184960718294051*G0_0_0_0_2_0 + 0.00205226871893538*G0_0_0_0_2_1 + 0.0186756453423119*G0_0_0_0_2_2 + 0.00282186948853613*G0_0_0_1_0_0 - 0.0105178771845438*G0_0_0_1_0_1 + 0.00205226871893538*G0_0_0_1_0_2 - 0.0105178771845438*G0_0_0_1_1_0 - 0.20792047458714*G0_0_0_1_1_1 - 0.0214205547538879*G0_0_0_1_1_2 + 0.00205226871893538*G0_0_0_1_2_0 - 0.0214205547538879*G0_0_0_1_2_1 + 0.00384800384800384*G0_0_0_1_2_2 + 0.0184960718294051*G0_0_0_2_0_0 + 0.00205226871893538*G0_0_0_2_0_1 + 0.0186756453423119*G0_0_0_2_0_2 + 0.00205226871893538*G0_0_0_2_1_0 - 0.0214205547538879*G0_0_0_2_1_1 + 0.00384800384800384*G0_0_0_2_1_2 + 0.0186756453423119*G0_0_0_2_2_0 + 0.00384800384800384*G0_0_0_2_2_1 + 0.0384287317620649*G0_0_0_2_2_2 - 0.00161616161616164*G0_0_1_0_0_0 - 0.00102613435946771*G0_0_1_0_0_1 - 0.000179573512906838*G0_0_1_0_0_2 - 0.00102613435946771*G0_0_1_0_1_0 + 0.0109026775693441*G0_0_1_0_1_1 - 0.000179573512906838*G0_0_1_0_2_0 + 0.000179573512906865*G0_0_1_0_2_2 - 0.00102613435946771*G0_0_1_1_0_0 + 0.0109026775693441*G0_0_1_1_0_1 + 0.0109026775693441*G0_0_1_1_1_0 - 0.0109026775693442*G0_0_1_1_1_2 - 0.0109026775693442*G0_0_1_1_2_1 + 0.0010261343594677*G0_0_1_1_2_2 - 0.000179573512906838*G0_0_1_2_0_0 + 0.000179573512906865*G0_0_1_2_0_2 - 0.0109026775693442*G0_0_1_2_1_1 + 0.0010261343594677*G0_0_1_2_1_2 + 0.000179573512906865*G0_0_1_2_2_0 + 0.0010261343594677*G0_0_1_2_2_1 + 0.00161616161616169*G0_0_1_2_2_2;
    A[12] = A[28] - 0.244733044733043*G0_0_0_0_0_0 - 0.0133397466730799*G0_0_0_0_0_1 - 0.039916626583293*G0_0_0_0_0_2 - 0.0133397466730799*G0_0_0_0_1_0 + 0.01333974667308*G0_0_0_0_1_1 - 0.039916626583293*G0_0_0_0_2_0 - 0.0148276414943081*G0_0_0_0_2_2 - 0.0133397466730799*G0_0_0_1_0_0 + 0.0133397466730799*G0_0_0_1_0_1 + 0.0133397466730799*G0_0_0_1_1_0 + 0.244733044733043*G0_0_0_1_1_1 + 0.039916626583293*G0_0_0_1_1_2 + 0.039916626583293*G0_0_0_1_2_1 + 0.014827641494308*G0_0_0_1_2_2 - 0.039916626583293*G0_0_0_2_0_0 - 0.0148276414943081*G0_0_0_2_0_2 + 0.039916626583293*G0_0_0_2_1_1 + 0.0148276414943081*G0_0_0_2_1_2 - 0.0148276414943081*G0_0_0_2_2_0 + 0.014827641494308*G0_0_0_2_2_1 - 0.206304312970979*G0_0_1_0_0_0 - 0.0203944203944203*G0_0_1_0_0_1 - 0.010338303671637*G0_0_1_0_0_2 - 0.0203944203944203*G0_0_1_0_1_0 - 0.00705467372134032*G0_0_1_0_1_1 + 0.00205226871893538*G0_0_1_0_1_2 - 0.010338303671637*G0_0_1_0_2_0 + 0.00205226871893538*G0_0_1_0_2_1 + 0.00264229597562928*G0_0_1_0_2_2 - 0.0203944203944203*G0_0_1_1_0_0 - 0.00705467372134032*G0_0_1_1_0_1 + 0.00205226871893538*G0_0_1_1_0_2 - 0.00705467372134031*G0_0_1_1_1_0 + 0.0384287317620651*G0_0_1_1_1_1 + 0.0295783229116561*G0_0_1_1_1_2 + 0.00205226871893538*G0_0_1_1_2_0 + 0.0295783229116561*G0_0_1_1_2_1 + 0.0174699374699374*G0_0_1_1_2_2 - 0.010338303671637*G0_0_1_2_0_0 + 0.00205226871893538*G0_0_1_2_0_1 + 0.00264229597562928*G0_0_1_2_0_2 + 0.00205226871893538*G0_0_1_2_1_0 + 0.0295783229116561*G0_0_1_2_1_1 + 0.0174699374699373*G0_0_1_2_1_2 + 0.00264229597562928*G0_0_1_2_2_0 + 0.0174699374699374*G0_0_1_2_2_1 + 0.0351964085297416*G0_0_1_2_2_2 - 0.20792047458714*G0_1_0_0_0_0 - 0.0105178771845438*G0_1_0_0_0_1 - 0.0214205547538879*G0_1_0_0_0_2 - 0.0105178771845438*G0_1_0_0_1_0 + 0.00282186948853614*G0_1_0_0_1_1 + 0.00205226871893538*G0_1_0_0_1_2 - 0.0214205547538879*G0_1_0_0_2_0 + 0.00205226871893538*G0_1_0_0_2_1 + 0.00384800384800386*G0_1_0_0_2_2 - 0.0105178771845438*G0_1_0_1_0_0 + 0.00282186948853614*G0_1_0_1_0_1 + 0.00205226871893538*G0_1_0_1_0_2 + 0.00282186948853614*G0_1_0_1_1_0 + 0.0368125701459032*G0_1_0_1_1_1 + 0.018496071829405*G0_1_0_1_1_2 + 0.00205226871893538*G0_1_0_1_2_0 + 0.018496071829405*G0_1_0_1_2_1 + 0.0186756453423119*G0_1_0_1_2_2 - 0.0214205547538879*G0_1_0_2_0_0 + 0.00205226871893538*G0_1_0_2_0_1 + 0.00384800384800386*G0_1_0_2_0_2 + 0.00205226871893538*G0_1_0_2_1_0 + 0.018496071829405*G0_1_0_2_1_1 + 0.0186756453423119*G0_1_0_2_1_2 + 0.00384800384800386*G0_1_0_2_2_0 + 0.0186756453423119*G0_1_0_2_2_1 + 0.0384287317620649*G0_1_0_2_2_2 - 0.20792047458714*G0_1_1_0_0_0 - 0.021420554753888*G0_1_1_0_0_1 - 0.0105178771845438*G0_1_1_0_0_2 - 0.021420554753888*G0_1_1_0_1_0 + 0.00384800384800378*G0_1_1_0_1_1 + 0.00205226871893538*G0_1_1_0_1_2 - 0.0105178771845438*G0_1_1_0_2_0 + 0.00205226871893538*G0_1_1_0_2_1 + 0.00282186948853615*G0_1_1_0_2_2 - 0.021420554753888*G0_1_1_1_0_0 + 0.00384800384800378*G0_1_1_1_0_1 + 0.00205226871893538*G0_1_1_1_0_2 + 0.00384800384800378*G0_1_1_1_1_0 + 0.0384287317620647*G0_1_1_1_1_1 + 0.0186756453423119*G0_1_1_1_1_2 + 0.00205226871893537*G0_1_1_1_2_0 + 0.0186756453423119*G0_1_1_1_2_1 + 0.018496071829405*G0_1_1_1_2_2 - 0.0105178771845438*G0_1_1_2_0_0 + 0.00205226871893538*G0_1_1_2_0_1 + 0.00282186948853615*G0_1_1_2_0_2 + 0.00205226871893537*G0_1_1_2_1_0 + 0.0186756453423119*G0_1_1_2_1_1 + 0.018496071829405*G0_1_1_2_1_2 + 0.00282186948853615*G0_1_1_2_2_0 + 0.018496071829405*G0_1_1_2_2_1 + 0.0368125701459033*G0_1_1_2_2_2;
    A[180] = A[12] + 0.0109026775693442*G0_0_1_0_0_1 - 0.0109026775693441*G0_0_1_0_0_2 + 0.0109026775693442*G0_0_1_0_1_0 - 0.00102613435946768*G0_0_1_0_1_1 - 0.0109026775693441*G0_0_1_0_2_0 + 0.00102613435946772*G0_0_1_0_2_2 + 0.0109026775693442*G0_0_1_1_0_0 - 0.00102613435946768*G0_0_1_1_0_1 - 0.00102613435946768*G0_0_1_1_1_0 - 0.00161616161616166*G0_0_1_1_1_1 - 0.000179573512906872*G0_0_1_1_1_2 - 0.000179573512906876*G0_0_1_1_2_1 + 0.000179573512906837*G0_0_1_1_2_2 - 0.0109026775693441*G0_0_1_2_0_0 + 0.00102613435946772*G0_0_1_2_0_2 - 0.000179573512906876*G0_0_1_2_1_1 + 0.000179573512906837*G0_0_1_2_1_2 + 0.00102613435946772*G0_0_1_2_2_0 + 0.000179573512906837*G0_0_1_2_2_1 + 0.00161616161616163*G0_0_1_2_2_2 - 0.0109026775693442*G0_1_0_0_0_1 + 0.0109026775693441*G0_1_0_0_0_2 - 0.0109026775693442*G0_1_0_0_1_0 + 0.00102613435946768*G0_1_0_0_1_1 + 0.0109026775693441*G0_1_0_0_2_0 - 0.00102613435946772*G0_1_0_0_2_2 - 0.0109026775693442*G0_1_0_1_0_0 + 0.00102613435946768*G0_1_0_1_0_1 + 0.00102613435946768*G0_1_0_1_1_0 + 0.00161616161616166*G0_1_0_1_1_1 + 0.000179573512906876*G0_1_0_1_1_2 + 0.000179573512906876*G0_1_0_1_2_1 - 0.000179573512906834*G0_1_0_1_2_2 + 0.0109026775693441*G0_1_0_2_0_0 - 0.00102613435946772*G0_1_0_2_0_2 + 0.000179573512906876*G0_1_0_2_1_1 - 0.000179573512906834*G0_1_0_2_1_2 - 0.00102613435946772*G0_1_0_2_2_0 - 0.000179573512906834*G0_1_0_2_2_1 - 0.00161616161616163*G0_1_0_2_2_2;
    A[131] = -A[86] + 0.0138528138528141*G0_1_0_0_0_0 + 0.0107060018171129*G0_1_0_0_0_1 + 0.00253113142002034*G0_1_0_0_0_2 + 0.0107060018171129*G0_1_0_0_1_0 + 0.015494628827962*G0_1_0_0_1_1 - 0.00136817914595693*G0_1_0_0_1_2 + 0.00253113142002034*G0_1_0_0_2_0 - 0.00136817914595693*G0_1_0_0_2_1 + 0.00335203890759444*G0_1_0_0_2_2 + 0.0107060018171129*G0_1_0_1_0_0 + 0.015494628827962*G0_1_0_1_0_1 - 0.00136817914595693*G0_1_0_1_0_2 + 0.015494628827962*G0_1_0_1_1_0 - 0.0924547057880399*G0_1_0_1_1_1 + 0.000205226871893498*G0_1_0_1_1_2 - 0.00136817914595693*G0_1_0_1_2_0 + 0.000205226871893501*G0_1_0_1_2_1 - 0.00335203890759447*G0_1_0_1_2_2 + 0.00253113142002034*G0_1_0_2_0_0 - 0.00136817914595693*G0_1_0_2_0_1 + 0.00335203890759444*G0_1_0_2_0_2 - 0.00136817914595693*G0_1_0_2_1_0 + 0.000205226871893501*G0_1_0_2_1_1 - 0.00335203890759447*G0_1_0_2_1_2 + 0.00335203890759444*G0_1_0_2_2_0 - 0.00335203890759447*G0_1_0_2_2_1 - 0.0046176046176047*G0_1_1_0_0_0 - 0.00766180321735877*G0_1_1_0_0_1 - 0.00126556571001016*G0_1_1_0_0_2 - 0.00766180321735877*G0_1_1_0_1_0 - 0.0308182352626797*G0_1_1_0_1_1 + 0.000102613435946763*G0_1_1_0_1_2 - 0.00126556571001016*G0_1_1_0_2_0 + 0.000102613435946763*G0_1_1_0_2_1 - 0.00335203890759444*G0_1_1_0_2_2 - 0.00766180321735877*G0_1_1_1_0_0 - 0.0308182352626797*G0_1_1_1_0_1 + 0.000102613435946763*G0_1_1_1_0_2 - 0.0308182352626797*G0_1_1_1_1_0 - 0.250376783710117*G0_1_1_1_1_1 + 0.0102955480733258*G0_1_1_1_1_2 + 0.000102613435946763*G0_1_1_1_2_0 + 0.0102955480733258*G0_1_1_1_2_1 + 0.00540430762652984*G0_1_1_1_2_2 - 0.00126556571001016*G0_1_1_2_0_0 + 0.000102613435946763*G0_1_1_2_0_1 - 0.00335203890759444*G0_1_1_2_0_2 + 0.000102613435946763*G0_1_1_2_1_0 + 0.0102955480733258*G0_1_1_2_1_1 + 0.00540430762652984*G0_1_1_2_1_2 - 0.00335203890759444*G0_1_1_2_2_0 + 0.00540430762652984*G0_1_1_2_2_1 - 0.00205226871893539*G0_1_1_2_2_2;
    A[123] = -A[131] - 0.00461760461760461*G0_0_0_0_0_0 - 0.00126556571001013*G0_0_0_0_0_1 - 0.00766180321735872*G0_0_0_0_0_2 - 0.00126556571001013*G0_0_0_0_1_0 - 0.0033520389075944*G0_0_0_0_1_1 + 0.000102613435946777*G0_0_0_0_1_2 - 0.00766180321735872*G0_0_0_0_2_0 + 0.000102613435946777*G0_0_0_0_2_1 - 0.0308182352626795*G0_0_0_0_2_2 - 0.00126556571001013*G0_0_0_1_0_0 - 0.0033520389075944*G0_0_0_1_0_1 + 0.000102613435946777*G0_0_0_1_0_2 - 0.0033520389075944*G0_0_0_1_1_0 - 0.00205226871893543*G0_0_0_1_1_1 + 0.00540430762652981*G0_0_0_1_1_2 + 0.000102613435946777*G0_0_0_1_2_0 + 0.00540430762652981*G0_0_0_1_2_1 + 0.0102955480733258*G0_0_0_1_2_2 - 0.00766180321735872*G0_0_0_2_0_0 + 0.000102613435946777*G0_0_0_2_0_1 - 0.0308182352626795*G0_0_0_2_0_2 + 0.000102613435946777*G0_0_0_2_1_0 + 0.00540430762652981*G0_0_0_2_1_1 + 0.0102955480733258*G0_0_0_2_1_2 - 0.0308182352626795*G0_0_0_2_2_0 + 0.0102955480733258*G0_0_0_2_2_1 - 0.250376783710115*G0_0_0_2_2_2 + 0.0138528138528142*G0_1_0_0_0_0 + 0.00253113142002032*G0_1_0_0_0_1 + 0.0107060018171129*G0_1_0_0_0_2 + 0.00253113142002032*G0_1_0_0_1_0 + 0.00335203890759443*G0_1_0_0_1_1 - 0.00136817914595692*G0_1_0_0_1_2 + 0.0107060018171129*G0_1_0_0_2_0 - 0.00136817914595692*G0_1_0_0_2_1 + 0.0154946288279621*G0_1_0_0_2_2 + 0.00253113142002032*G0_1_0_1_0_0 + 0.00335203890759443*G0_1_0_1_0_1 - 0.00136817914595692*G0_1_0_1_0_2 + 0.00335203890759443*G0_1_0_1_1_0 - 0.00335203890759452*G0_1_0_1_1_2 - 0.00136817914595692*G0_1_0_1_2_0 - 0.00335203890759452*G0_1_0_1_2_1 + 0.000205226871893492*G0_1_0_1_2_2 + 0.0107060018171129*G0_1_0_2_0_0 - 0.00136817914595692*G0_1_0_2_0_1 + 0.0154946288279621*G0_1_0_2_0_2 - 0.00136817914595692*G0_1_0_2_1_0 - 0.00335203890759452*G0_1_0_2_1_1 + 0.000205226871893491*G0_1_0_2_1_2 + 0.0154946288279621*G0_1_0_2_2_0 + 0.00020522687189349*G0_1_0_2_2_1 - 0.0924547057880384*G0_1_0_2_2_2;
    A[74] = A[214] + 0.0175468975468973*G0_0_1_0_0_0 + 0.0116209716209714*G0_0_1_0_0_1 + 0.0182395382395382*G0_0_1_0_0_2 + 0.0116209716209714*G0_0_1_0_1_0 + 0.0173160173160171*G0_0_1_0_1_1 + 0.00831168831168825*G0_0_1_0_1_2 + 0.0182395382395382*G0_0_1_0_2_0 + 0.00831168831168824*G0_0_1_0_2_1 + 0.0242424242424241*G0_0_1_0_2_2 + 0.0116209716209714*G0_0_1_1_0_0 + 0.0173160173160171*G0_0_1_1_0_1 + 0.00831168831168824*G0_0_1_1_0_2 + 0.0173160173160171*G0_0_1_1_1_0 + 0.0688023088023085*G0_0_1_1_1_1 - 0.00484848484848474*G0_0_1_1_1_2 + 0.00831168831168824*G0_0_1_1_2_0 - 0.00484848484848474*G0_0_1_1_2_1 - 0.0711880711880708*G0_0_1_1_2_2 + 0.0182395382395382*G0_0_1_2_0_0 + 0.00831168831168825*G0_0_1_2_0_1 + 0.0242424242424241*G0_0_1_2_0_2 + 0.00831168831168824*G0_0_1_2_1_0 - 0.00484848484848471*G0_0_1_2_1_1 - 0.0711880711880708*G0_0_1_2_1_2 + 0.0242424242424241*G0_0_1_2_2_0 - 0.0711880711880708*G0_0_1_2_2_1 - 0.122366522366522*G0_0_1_2_2_2 - 0.0175468975468973*G0_1_0_0_0_0 - 0.0116209716209714*G0_1_0_0_0_1 - 0.0182395382395382*G0_1_0_0_0_2 - 0.0116209716209714*G0_1_0_0_1_0 - 0.0173160173160171*G0_1_0_0_1_1 - 0.00831168831168825*G0_1_0_0_1_2 - 0.0182395382395382*G0_1_0_0_2_0 - 0.00831168831168824*G0_1_0_0_2_1 - 0.0242424242424242*G0_1_0_0_2_2 - 0.0116209716209714*G0_1_0_1_0_0 - 0.0173160173160171*G0_1_0_1_0_1 - 0.00831168831168824*G0_1_0_1_0_2 - 0.0173160173160171*G0_1_0_1_1_0 - 0.0688023088023085*G0_1_0_1_1_1 + 0.00484848484848471*G0_1_0_1_1_2 - 0.00831168831168824*G0_1_0_1_2_0 + 0.0048484848484847*G0_1_0_1_2_1 + 0.0711880711880708*G0_1_0_1_2_2 - 0.0182395382395382*G0_1_0_2_0_0 - 0.00831168831168825*G0_1_0_2_0_1 - 0.0242424242424242*G0_1_0_2_0_2 - 0.00831168831168824*G0_1_0_2_1_0 + 0.00484848484848471*G0_1_0_2_1_1 + 0.0711880711880708*G0_1_0_2_1_2 - 0.0242424242424242*G0_1_0_2_2_0 + 0.0711880711880708*G0_1_0_2_2_1 + 0.122366522366522*G0_1_0_2_2_2;
    A[199] = A[74] + 0.0464838864838864*G0_0_0_0_0_0 + 0.00831168831168831*G0_0_0_0_0_1 + 0.0874266474266471*G0_0_0_0_0_2 + 0.00831168831168831*G0_0_0_0_1_0 + 0.0218566618566618*G0_0_0_0_1_1 + 0.0341702741702741*G0_0_0_0_1_2 + 0.0874266474266471*G0_0_0_0_2_0 + 0.0341702741702741*G0_0_0_0_2_1 + 0.213641173641173*G0_0_0_0_2_2 + 0.00831168831168831*G0_0_0_1_0_0 + 0.0218566618566618*G0_0_0_1_0_1 + 0.0341702741702741*G0_0_0_1_0_2 + 0.0218566618566618*G0_0_0_1_1_0 + 0.146224146224146*G0_0_0_1_1_1 + 0.102818662818663*G0_0_0_1_1_2 + 0.0341702741702741*G0_0_0_1_2_0 + 0.102818662818663*G0_0_0_1_2_1 + 0.205021645021644*G0_0_0_1_2_2 + 0.0874266474266471*G0_0_0_2_0_0 + 0.0341702741702741*G0_0_0_2_0_1 + 0.213641173641173*G0_0_0_2_0_2 + 0.0341702741702741*G0_0_0_2_1_0 + 0.102818662818663*G0_0_0_2_1_1 + 0.205021645021644*G0_0_0_2_1_2 + 0.213641173641173*G0_0_0_2_2_0 + 0.205021645021644*G0_0_0_2_2_1 + 0.935834535834531*G0_0_0_2_2_2 - 0.00361712361712342*G0_0_1_0_0_1 + 0.00361712361712372*G0_0_1_0_0_2 - 0.00361712361712342*G0_0_1_0_1_0 - 0.00992784992784969*G0_0_1_0_1_1 + 0.00361712361712372*G0_0_1_0_2_0 + 0.0099278499278501*G0_0_1_0_2_2 - 0.00361712361712342*G0_0_1_1_0_0 - 0.0099278499278497*G0_0_1_1_0_1 - 0.00992784992784969*G0_0_1_1_1_0 - 0.164848484848484*G0_0_1_1_1_1 - 0.0656469456469452*G0_0_1_1_1_2 - 0.0656469456469452*G0_0_1_1_2_1 + 0.0656469456469456*G0_0_1_1_2_2 + 0.00361712361712372*G0_0_1_2_0_0 + 0.0099278499278501*G0_0_1_2_0_2 - 0.0656469456469453*G0_0_1_2_1_1 + 0.0656469456469456*G0_0_1_2_1_2 + 0.0099278499278501*G0_0_1_2_2_0 + 0.0656469456469455*G0_0_1_2_2_1 + 0.164848484848485*G0_0_1_2_2_2 - 0.0102356902356901*G0_1_0_0_0_1 + 0.0102356902356903*G0_1_0_0_0_2 - 0.0102356902356901*G0_1_0_0_1_0 - 0.0168542568542566*G0_1_0_0_1_1 + 0.0102356902356903*G0_1_0_0_2_0 + 0.016854256854257*G0_1_0_0_2_2 - 0.0102356902356901*G0_1_0_1_0_0 - 0.0168542568542566*G0_1_0_1_0_1 - 0.0168542568542566*G0_1_0_1_1_0 + 0.0263203463203475*G0_1_0_1_1_1 + 0.000692640692640981*G0_1_0_1_1_2 + 0.000692640692640981*G0_1_0_1_2_1 - 0.000692640692640439*G0_1_0_1_2_2 + 0.0102356902356903*G0_1_0_2_0_0 + 0.016854256854257*G0_1_0_2_0_2 + 0.000692640692640994*G0_1_0_2_1_1 - 0.000692640692640425*G0_1_0_2_1_2 + 0.016854256854257*G0_1_0_2_2_0 - 0.000692640692640425*G0_1_0_2_2_1 - 0.0263203463203446*G0_1_0_2_2_2 - 0.0464838864838859*G0_1_1_0_0_0 - 0.0874266474266469*G0_1_1_0_0_1 - 0.00831168831168821*G0_1_1_0_0_2 - 0.0874266474266469*G0_1_1_0_1_0 - 0.213641173641173*G0_1_1_0_1_1 - 0.034170274170274*G0_1_1_0_1_2 - 0.00831168831168821*G0_1_1_0_2_0 - 0.034170274170274*G0_1_1_0_2_1 - 0.0218566618566617*G0_1_1_0_2_2 - 0.0874266474266469*G0_1_1_1_0_0 - 0.213641173641173*G0_1_1_1_0_1 - 0.034170274170274*G0_1_1_1_0_2 - 0.213641173641173*G0_1_1_1_1_0 - 0.935834535834532*G0_1_1_1_1_1 - 0.205021645021644*G0_1_1_1_1_2 - 0.034170274170274*G0_1_1_1_2_0 - 0.205021645021644*G0_1_1_1_2_1 - 0.102818662818662*G0_1_1_1_2_2 - 0.00831168831168821*G0_1_1_2_0_0 - 0.034170274170274*G0_1_1_2_0_1 - 0.0218566618566617*G0_1_1_2_0_2 - 0.034170274170274*G0_1_1_2_1_0 - 0.205021645021644*G0_1_1_2_1_1 - 0.102818662818662*G0_1_1_2_1_2 - 0.0218566618566617*G0_1_1_2_2_0 - 0.102818662818662*G0_1_1_2_2_1 - 0.146224146224145*G0_1_1_2_2_2;
    A[73] = A[199] - 0.0175468975468975*G0_0_1_0_0_0 - 0.0182395382395381*G0_0_1_0_0_1 - 0.0116209716209716*G0_0_1_0_0_2 - 0.0182395382395381*G0_0_1_0_1_0 - 0.024242424242424*G0_0_1_0_1_1 - 0.00831168831168827*G0_0_1_0_1_2 - 0.0116209716209716*G0_0_1_0_2_0 - 0.00831168831168827*G0_0_1_0_2_1 - 0.0173160173160172*G0_0_1_0_2_2 - 0.0182395382395381*G0_0_1_1_0_0 - 0.024242424242424*G0_0_1_1_0_1 - 0.00831168831168827*G0_0_1_1_0_2 - 0.024242424242424*G0_0_1_1_1_0 + 0.122366522366523*G0_0_1_1_1_1 + 0.071188071188071*G0_0_1_1_1_2 - 0.00831168831168827*G0_0_1_1_2_0 + 0.071188071188071*G0_0_1_1_2_1 + 0.00484848484848481*G0_0_1_1_2_2 - 0.0116209716209716*G0_0_1_2_0_0 - 0.00831168831168827*G0_0_1_2_0_1 - 0.0173160173160172*G0_0_1_2_0_2 - 0.00831168831168827*G0_0_1_2_1_0 + 0.071188071188071*G0_0_1_2_1_1 + 0.00484848484848482*G0_0_1_2_1_2 - 0.0173160173160172*G0_0_1_2_2_0 + 0.00484848484848484*G0_0_1_2_2_1 - 0.0688023088023078*G0_0_1_2_2_2 + 0.0175468975468975*G0_1_0_0_0_0 + 0.0182395382395381*G0_1_0_0_0_1 + 0.0116209716209716*G0_1_0_0_0_2 + 0.0182395382395381*G0_1_0_0_1_0 + 0.024242424242424*G0_1_0_0_1_1 + 0.00831168831168827*G0_1_0_0_1_2 + 0.0116209716209716*G0_1_0_0_2_0 + 0.00831168831168827*G0_1_0_0_2_1 + 0.0173160173160172*G0_1_0_0_2_2 + 0.0182395382395381*G0_1_0_1_0_0 + 0.024242424242424*G0_1_0_1_0_1 + 0.00831168831168827*G0_1_0_1_0_2 + 0.024242424242424*G0_1_0_1_1_0 - 0.122366522366523*G0_1_0_1_1_1 - 0.071188071188071*G0_1_0_1_1_2 + 0.00831168831168827*G0_1_0_1_2_0 - 0.071188071188071*G0_1_0_1_2_1 - 0.0048484848484848*G0_1_0_1_2_2 + 0.0116209716209716*G0_1_0_2_0_0 + 0.00831168831168827*G0_1_0_2_0_1 + 0.0173160173160172*G0_1_0_2_0_2 + 0.00831168831168827*G0_1_0_2_1_0 - 0.071188071188071*G0_1_0_2_1_1 - 0.00484848484848481*G0_1_0_2_1_2 + 0.0173160173160172*G0_1_0_2_2_0 - 0.00484848484848482*G0_1_0_2_2_1 + 0.0688023088023078*G0_1_0_2_2_2;
    A[40] = -0.00237614237614229*G0_1_0_0_0_0 - 0.00253006253006251*G0_1_0_0_0_1 - 0.000314253647586969*G0_1_0_0_0_2 - 0.00253006253006251*G0_1_0_0_1_0 + 0.00253006253006254*G0_1_0_0_1_1 - 0.000314253647586969*G0_1_0_0_2_0 + 0.000420073753407072*G0_1_0_0_2_2 - 0.00253006253006251*G0_1_0_1_0_0 + 0.00253006253006254*G0_1_0_1_0_1 + 0.00253006253006254*G0_1_0_1_1_0 + 0.00237614237614231*G0_1_0_1_1_1 + 0.000314253647586988*G0_1_0_1_1_2 + 0.000314253647586988*G0_1_0_1_2_1 - 0.000420073753407092*G0_1_0_1_2_2 - 0.000314253647586968*G0_1_0_2_0_0 + 0.000420073753407073*G0_1_0_2_0_2 + 0.000314253647586988*G0_1_0_2_1_1 - 0.000420073753407092*G0_1_0_2_1_2 + 0.000420073753407073*G0_1_0_2_2_0 - 0.000420073753407092*G0_1_0_2_2_1 + 0.00338303671637008*G0_1_1_0_0_0 + 0.00635561968895301*G0_1_1_0_0_1 + 6.73400673400679e-05*G0_1_1_0_0_2 + 0.00635561968895301*G0_1_1_0_1_0 + 0.00888568221901554*G0_1_1_0_1_1 - 0.000497033830367159*G0_1_1_0_1_2 + 6.73400673400681e-05*G0_1_1_0_2_0 - 0.000497033830367159*G0_1_1_0_2_1 - 0.000663780663780657*G0_1_1_0_2_2 + 0.00635561968895301*G0_1_1_1_0_0 + 0.00888568221901554*G0_1_1_1_0_1 - 0.000497033830367159*G0_1_1_1_0_2 + 0.00888568221901554*G0_1_1_1_1_0 + 0.00575917909251233*G0_1_1_1_1_1 + 0.000381593714927055*G0_1_1_1_1_2 - 0.000497033830367159*G0_1_1_1_2_0 + 0.000381593714927054*G0_1_1_1_2_1 - 0.00108385441718773*G0_1_1_1_2_2 + 6.73400673400679e-05*G0_1_1_2_0_0 - 0.000497033830367159*G0_1_1_2_0_1 - 0.000663780663780657*G0_1_1_2_0_2 - 0.000497033830367159*G0_1_1_2_1_0 + 0.000381593714927055*G0_1_1_2_1_1 - 0.00108385441718773*G0_1_1_2_1_2 - 0.000663780663780657*G0_1_1_2_2_0 - 0.00108385441718773*G0_1_1_2_2_1 - 0.00565977232643889*G0_1_1_2_2_2;
    A[145] = A[159] + 0.294757094757093*G0_0_1_0_0_0 + 0.129549462882795*G0_0_1_0_0_1 + 0.0271925605258937*G0_0_1_0_0_2 + 0.129549462882795*G0_0_1_0_1_0 + 0.0659547859547856*G0_0_1_0_1_1 + 0.0133140933140932*G0_0_1_0_1_2 + 0.0271925605258937*G0_0_1_0_2_0 + 0.0133140933140932*G0_0_1_0_2_1 + 0.00464325797659129*G0_0_1_0_2_2 + 0.129549462882795*G0_0_1_1_0_0 + 0.0659547859547856*G0_0_1_1_0_1 + 0.0133140933140932*G0_0_1_1_0_2 + 0.0659547859547856*G0_0_1_1_1_0 + 0.036325156325156*G0_0_1_1_1_1 + 0.00607984607984605*G0_0_1_1_1_2 + 0.0133140933140932*G0_0_1_1_2_0 + 0.00607984607984606*G0_0_1_1_2_1 + 0.00205226871893539*G0_0_1_1_2_2 + 0.0271925605258937*G0_0_1_2_0_0 + 0.0133140933140932*G0_0_1_2_0_1 + 0.0046432579765913*G0_0_1_2_0_2 + 0.0133140933140932*G0_0_1_2_1_0 + 0.00607984607984605*G0_0_1_2_1_1 + 0.00205226871893539*G0_0_1_2_1_2 + 0.0046432579765913*G0_0_1_2_2_0 + 0.00205226871893539*G0_0_1_2_2_1 - 0.294757094757093*G0_1_0_0_0_0 - 0.129549462882795*G0_1_0_0_0_1 - 0.0271925605258937*G0_1_0_0_0_2 - 0.129549462882795*G0_1_0_0_1_0 - 0.0659547859547856*G0_1_0_0_1_1 - 0.0133140933140932*G0_1_0_0_1_2 - 0.0271925605258937*G0_1_0_0_2_0 - 0.0133140933140932*G0_1_0_0_2_1 - 0.0046432579765913*G0_1_0_0_2_2 - 0.129549462882795*G0_1_0_1_0_0 - 0.0659547859547856*G0_1_0_1_0_1 - 0.0133140933140932*G0_1_0_1_0_2 - 0.0659547859547856*G0_1_0_1_1_0 - 0.036325156325156*G0_1_0_1_1_1 - 0.00607984607984606*G0_1_0_1_1_2 - 0.0133140933140932*G0_1_0_1_2_0 - 0.00607984607984606*G0_1_0_1_2_1 - 0.00205226871893539*G0_1_0_1_2_2 - 0.0271925605258937*G0_1_0_2_0_0 - 0.0133140933140932*G0_1_0_2_0_1 - 0.0046432579765913*G0_1_0_2_0_2 - 0.0133140933140932*G0_1_0_2_1_0 - 0.00607984607984605*G0_1_0_2_1_1 - 0.00205226871893539*G0_1_0_2_1_2 - 0.0046432579765913*G0_1_0_2_2_0 - 0.00205226871893539*G0_1_0_2_2_1;
    A[151] = -A[61] + 0.065929132595799*G0_0_0_0_0_0 + 0.00727914061247393*G0_0_0_0_0_1 + 0.015751162417829*G0_0_0_0_0_2 + 0.00727914061247393*G0_0_0_0_1_0 + 0.00224466891133563*G0_0_0_0_1_1 + 0.00299823633156966*G0_0_0_0_1_2 + 0.015751162417829*G0_0_0_0_2_0 + 0.00299823633156966*G0_0_0_0_2_1 + 0.0155715889049222*G0_0_0_0_2_2 + 0.00727914061247393*G0_0_0_1_0_0 + 0.00224466891133563*G0_0_0_1_0_1 + 0.00299823633156966*G0_0_0_1_0_2 + 0.00224466891133563*G0_0_0_1_1_0 + 0.181080647747314*G0_0_0_1_1_1 + 0.0131473464806798*G0_0_0_1_1_2 + 0.00299823633156966*G0_0_0_1_2_0 + 0.0131473464806798*G0_0_0_1_2_1 + 0.00625300625300621*G0_0_0_1_2_2 + 0.015751162417829*G0_0_0_2_0_0 + 0.00299823633156966*G0_0_0_2_0_1 + 0.0155715889049222*G0_0_0_2_0_2 + 0.00299823633156966*G0_0_0_2_1_0 + 0.0131473464806798*G0_0_0_2_1_1 + 0.00625300625300621*G0_0_0_2_1_2 + 0.0155715889049221*G0_0_0_2_2_0 + 0.00625300625300621*G0_0_0_2_2_1 + 0.0643129709796372*G0_0_0_2_2_2 + 0.00161616161616161*G0_1_0_0_0_0 + 0.0010261343594677*G0_1_0_0_0_1 + 0.000179573512906848*G0_1_0_0_0_2 + 0.0010261343594677*G0_1_0_0_1_0 - 0.0109026775693442*G0_1_0_0_1_1 + 0.000179573512906848*G0_1_0_0_2_0 - 0.000179573512906848*G0_1_0_0_2_2 + 0.0010261343594677*G0_1_0_1_0_0 - 0.0109026775693442*G0_1_0_1_0_1 - 0.0109026775693442*G0_1_0_1_1_0 + 0.0109026775693441*G0_1_0_1_1_2 + 0.0109026775693441*G0_1_0_1_2_1 - 0.0010261343594677*G0_1_0_1_2_2 + 0.000179573512906848*G0_1_0_2_0_0 - 0.000179573512906849*G0_1_0_2_0_2 + 0.0109026775693441*G0_1_0_2_1_1 - 0.00102613435946769*G0_1_0_2_1_2 - 0.000179573512906848*G0_1_0_2_2_0 - 0.0010261343594677*G0_1_0_2_2_1 - 0.00161616161616164*G0_1_0_2_2_2;
    A[102] = A[186] - 0.206253006253004*G0_0_1_0_0_0 - 0.0415584415584411*G0_0_1_0_0_1 + 0.0672118005451337*G0_0_1_0_0_2 - 0.0415584415584411*G0_0_1_0_1_0 - 0.0161103094436426*G0_0_1_0_1_1 + 0.00123136123136125*G0_0_1_0_1_2 + 0.0672118005451337*G0_0_1_0_2_0 + 0.00123136123136125*G0_0_1_0_2_1 + 0.0557190957190955*G0_0_1_0_2_2 - 0.0415584415584411*G0_0_1_1_0_0 - 0.0161103094436426*G0_0_1_1_0_1 + 0.00123136123136125*G0_0_1_1_0_2 - 0.0161103094436426*G0_0_1_1_1_0 - 0.0116979316979318*G0_0_1_1_1_1 - 0.00379669713003053*G0_0_1_1_1_2 + 0.00123136123136125*G0_0_1_1_2_0 - 0.00379669713003053*G0_0_1_1_2_1 + 0.000307840307840229*G0_0_1_1_2_2 + 0.0672118005451337*G0_0_1_2_0_0 + 0.00123136123136125*G0_0_1_2_0_1 + 0.0557190957190955*G0_0_1_2_0_2 + 0.00123136123136125*G0_0_1_2_1_0 - 0.00379669713003053*G0_0_1_2_1_1 + 0.000307840307840243*G0_0_1_2_1_2 + 0.0557190957190955*G0_0_1_2_2_0 + 0.000307840307840229*G0_0_1_2_2_1 + 0.025242905242905*G0_0_1_2_2_2 + 0.206253006253004*G0_1_0_0_0_0 + 0.0415584415584411*G0_1_0_0_0_1 - 0.0672118005451337*G0_1_0_0_0_2 + 0.0415584415584411*G0_1_0_0_1_0 + 0.0161103094436426*G0_1_0_0_1_1 - 0.00123136123136125*G0_1_0_0_1_2 - 0.0672118005451337*G0_1_0_0_2_0 - 0.00123136123136125*G0_1_0_0_2_1 - 0.0557190957190954*G0_1_0_0_2_2 + 0.0415584415584411*G0_1_0_1_0_0 + 0.0161103094436426*G0_1_0_1_0_1 - 0.00123136123136125*G0_1_0_1_0_2 + 0.0161103094436426*G0_1_0_1_1_0 + 0.0116979316979318*G0_1_0_1_1_1 + 0.00379669713003052*G0_1_0_1_1_2 - 0.00123136123136125*G0_1_0_1_2_0 + 0.00379669713003053*G0_1_0_1_2_1 - 0.000307840307840236*G0_1_0_1_2_2 - 0.0672118005451337*G0_1_0_2_0_0 - 0.00123136123136125*G0_1_0_2_0_1 - 0.0557190957190954*G0_1_0_2_0_2 - 0.00123136123136125*G0_1_0_2_1_0 + 0.00379669713003052*G0_1_0_2_1_1 - 0.000307840307840236*G0_1_0_2_1_2 - 0.0557190957190954*G0_1_0_2_2_0 - 0.000307840307840236*G0_1_0_2_2_1 - 0.025242905242905*G0_1_0_2_2_2;
    A[189] = A[102] + 1.0702581369248*G0_0_0_0_0_0 + 0.0636203302869966*G0_0_0_0_0_1 + 0.265768799102131*G0_0_0_0_0_2 + 0.0636203302869966*G0_0_0_0_1_0 + 0.00246272246272244*G0_0_0_0_1_1 + 0.0174442841109507*G0_0_0_0_1_2 + 0.265768799102131*G0_0_0_0_2_0 + 0.0174442841109507*G0_0_0_0_2_1 + 0.10733365400032*G0_0_0_0_2_2 + 0.0636203302869966*G0_0_0_1_0_0 + 0.00246272246272244*G0_0_0_1_0_1 + 0.0174442841109507*G0_0_0_1_0_2 + 0.00246272246272244*G0_0_0_1_1_0 - 0.0822959756293085*G0_0_0_1_1_1 - 0.0104665704665703*G0_0_0_1_1_2 + 0.0174442841109507*G0_0_0_1_2_0 - 0.0104665704665703*G0_0_0_1_2_1 + 0.0223697290363957*G0_0_0_1_2_2 + 0.265768799102131*G0_0_0_2_0_0 + 0.0174442841109507*G0_0_0_2_0_1 + 0.10733365400032*G0_0_0_2_0_2 + 0.0174442841109507*G0_0_0_2_1_0 - 0.0104665704665703*G0_0_0_2_1_1 + 0.0223697290363957*G0_0_0_2_1_2 + 0.10733365400032*G0_0_0_2_2_0 + 0.0223697290363957*G0_0_0_2_2_1 + 0.127651114317781*G0_0_0_2_2_2 + 0.0220618887285551*G0_0_1_0_0_1 - 0.0220618887285554*G0_0_1_0_0_2 + 0.0220618887285551*G0_0_1_0_1_0 + 0.00502805836139159*G0_0_1_0_1_1 - 0.0220618887285554*G0_0_1_0_2_0 - 0.00502805836139166*G0_0_1_0_2_2 + 0.0220618887285551*G0_0_1_1_0_0 + 0.00502805836139159*G0_0_1_1_0_1 + 0.00502805836139158*G0_0_1_1_1_0 - 0.0855796055796051*G0_0_1_1_1_1 - 0.0142632675966008*G0_0_1_1_1_2 - 0.0142632675966008*G0_0_1_1_2_1 + 0.0142632675966009*G0_0_1_1_2_2 - 0.0220618887285554*G0_0_1_2_0_0 - 0.00502805836139166*G0_0_1_2_0_2 - 0.0142632675966008*G0_0_1_2_1_1 + 0.0142632675966009*G0_0_1_2_1_2 - 0.00502805836139166*G0_0_1_2_2_0 + 0.0142632675966009*G0_0_1_2_2_1 + 0.0855796055796052*G0_0_1_2_2_2 - 0.0867083533750194*G0_1_0_0_0_1 + 0.0867083533750198*G0_1_0_0_0_2 - 0.0867083533750194*G0_1_0_0_1_0 - 0.0668013468013464*G0_1_0_0_1_1 + 0.0867083533750198*G0_1_0_0_2_0 + 0.0668013468013465*G0_1_0_0_2_2 - 0.0867083533750194*G0_1_0_1_0_0 - 0.0668013468013464*G0_1_0_1_0_1 - 0.0668013468013464*G0_1_0_1_1_0 - 0.122520442520442*G0_1_0_1_1_1 - 0.0183678050344716*G0_1_0_1_1_2 - 0.0183678050344716*G0_1_0_1_2_1 + 0.0183678050344716*G0_1_0_1_2_2 + 0.0867083533750198*G0_1_0_2_0_0 + 0.0668013468013465*G0_1_0_2_0_2 - 0.0183678050344716*G0_1_0_2_1_1 + 0.0183678050344716*G0_1_0_2_1_2 + 0.0668013468013465*G0_1_0_2_2_0 + 0.0183678050344716*G0_1_0_2_2_1 + 0.122520442520442*G0_1_0_2_2_2 - 1.0702581369248*G0_1_1_0_0_0 - 0.265768799102131*G0_1_1_0_0_1 - 0.0636203302869966*G0_1_1_0_0_2 - 0.265768799102131*G0_1_1_0_1_0 - 0.10733365400032*G0_1_1_0_1_1 - 0.0174442841109507*G0_1_1_0_1_2 - 0.0636203302869966*G0_1_1_0_2_0 - 0.0174442841109507*G0_1_1_0_2_1 - 0.00246272246272243*G0_1_1_0_2_2 - 0.265768799102131*G0_1_1_1_0_0 - 0.10733365400032*G0_1_1_1_0_1 - 0.0174442841109507*G0_1_1_1_0_2 - 0.10733365400032*G0_1_1_1_1_0 - 0.12765111431778*G0_1_1_1_1_1 - 0.0223697290363956*G0_1_1_1_1_2 - 0.0174442841109507*G0_1_1_1_2_0 - 0.0223697290363957*G0_1_1_1_2_1 + 0.0104665704665703*G0_1_1_1_2_2 - 0.0636203302869966*G0_1_1_2_0_0 - 0.0174442841109507*G0_1_1_2_0_1 - 0.00246272246272243*G0_1_1_2_0_2 - 0.0174442841109507*G0_1_1_2_1_0 - 0.0223697290363957*G0_1_1_2_1_1 + 0.0104665704665704*G0_1_1_2_1_2 - 0.00246272246272243*G0_1_1_2_2_0 + 0.0104665704665703*G0_1_1_2_2_1 + 0.0822959756293086*G0_1_1_2_2_2;
    A[147] = A[189] + 0.206253006253006*G0_0_1_0_0_0 - 0.0672118005451334*G0_0_1_0_0_1 + 0.0415584415584415*G0_0_1_0_0_2 - 0.0672118005451334*G0_0_1_0_1_0 - 0.0557190957190953*G0_0_1_0_1_1 - 0.0012313612313612*G0_0_1_0_1_2 + 0.0415584415584415*G0_0_1_0_2_0 - 0.0012313612313612*G0_0_1_0_2_1 + 0.0161103094436427*G0_0_1_0_2_2 - 0.0672118005451334*G0_0_1_1_0_0 - 0.0557190957190953*G0_0_1_1_0_1 - 0.0012313612313612*G0_0_1_1_0_2 - 0.0557190957190953*G0_0_1_1_1_0 - 0.0252429052429049*G0_0_1_1_1_1 - 0.000307840307840257*G0_0_1_1_1_2 - 0.0012313612313612*G0_0_1_1_2_0 - 0.00030784030784025*G0_0_1_1_2_1 + 0.00379669713003052*G0_0_1_1_2_2 + 0.0415584415584415*G0_0_1_2_0_0 - 0.0012313612313612*G0_0_1_2_0_1 + 0.0161103094436427*G0_0_1_2_0_2 - 0.0012313612313612*G0_0_1_2_1_0 - 0.000307840307840243*G0_0_1_2_1_1 + 0.00379669713003053*G0_0_1_2_1_2 + 0.0161103094436427*G0_0_1_2_2_0 + 0.00379669713003053*G0_0_1_2_2_1 + 0.0116979316979318*G0_0_1_2_2_2 - 0.206253006253006*G0_1_0_0_0_0 + 0.0672118005451334*G0_1_0_0_0_1 - 0.0415584415584415*G0_1_0_0_0_2 + 0.0672118005451334*G0_1_0_0_1_0 + 0.0557190957190953*G0_1_0_0_1_1 + 0.0012313612313612*G0_1_0_0_1_2 - 0.0415584415584415*G0_1_0_0_2_0 + 0.0012313612313612*G0_1_0_0_2_1 - 0.0161103094436427*G0_1_0_0_2_2 + 0.0672118005451334*G0_1_0_1_0_0 + 0.0557190957190953*G0_1_0_1_0_1 + 0.0012313612313612*G0_1_0_1_0_2 + 0.0557190957190953*G0_1_0_1_1_0 + 0.025242905242905*G0_1_0_1_1_1 + 0.000307840307840257*G0_1_0_1_1_2 + 0.00123136123136119*G0_1_0_1_2_0 + 0.000307840307840243*G0_1_0_1_2_1 - 0.00379669713003053*G0_1_0_1_2_2 - 0.0415584415584415*G0_1_0_2_0_0 + 0.0012313612313612*G0_1_0_2_0_1 - 0.0161103094436427*G0_1_0_2_0_2 + 0.00123136123136119*G0_1_0_2_1_0 + 0.000307840307840243*G0_1_0_2_1_1 - 0.00379669713003053*G0_1_0_2_1_2 - 0.0161103094436428*G0_1_0_2_2_0 - 0.00379669713003053*G0_1_0_2_2_1 - 0.0116979316979318*G0_1_0_2_2_2;
    A[177] = -A[57] + 0.30866121532788*G0_0_0_0_0_0 - 0.008003848003848*G0_0_0_0_0_1 + 0.114721821388487*G0_0_0_0_0_2 - 0.008003848003848*G0_0_0_0_1_0 - 0.0391983325316657*G0_0_0_0_1_1 + 0.0043097643097643*G0_0_0_0_1_2 + 0.114721821388487*G0_0_0_0_2_0 + 0.0043097643097643*G0_0_0_0_2_1 + 0.0728555395222058*G0_0_0_0_2_2 - 0.008003848003848*G0_0_0_1_0_0 - 0.0391983325316657*G0_0_0_1_0_1 + 0.0043097643097643*G0_0_0_1_0_2 - 0.0391983325316657*G0_0_0_1_1_0 - 0.0348885682219018*G0_0_0_1_1_1 + 0.0289369889369888*G0_0_0_1_1_2 + 0.0043097643097643*G0_0_0_1_2_0 + 0.0289369889369888*G0_0_0_1_2_1 + 0.0322206188872854*G0_0_0_1_2_2 + 0.114721821388487*G0_0_0_2_0_0 + 0.0043097643097643*G0_0_0_2_0_1 + 0.0728555395222058*G0_0_0_2_0_2 + 0.0043097643097643*G0_0_0_2_1_0 + 0.0289369889369888*G0_0_0_2_1_1 + 0.0322206188872855*G0_0_0_2_1_2 + 0.0728555395222058*G0_0_0_2_2_0 + 0.0322206188872854*G0_0_0_2_2_1 + 0.0439185505852173*G0_0_0_2_2_2 - 0.0652621452621445*G0_0_1_0_0_0 - 0.0250376783710115*G0_0_1_0_0_1 + 0.00451499118165792*G0_0_1_0_0_2 - 0.0250376783710115*G0_0_1_0_1_0 - 0.0205226871893537*G0_0_1_0_1_1 + 0.000410453743787107*G0_0_1_0_1_2 + 0.00451499118165792*G0_0_1_0_2_0 + 0.000410453743787106*G0_0_1_0_2_1 + 0.0131345198011865*G0_0_1_0_2_2 - 0.0250376783710115*G0_0_1_1_0_0 - 0.0205226871893537*G0_0_1_1_0_1 + 0.000410453743787107*G0_0_1_1_0_2 - 0.0205226871893537*G0_0_1_1_1_0 + 0.0205226871893538*G0_0_1_1_1_2 + 0.000410453743787106*G0_0_1_1_2_0 + 0.0205226871893538*G0_0_1_1_2_1 + 0.0242167708834375*G0_0_1_1_2_2 + 0.00451499118165792*G0_0_1_2_0_0 + 0.000410453743787107*G0_0_1_2_0_1 + 0.0131345198011865*G0_0_1_2_0_2 + 0.000410453743787108*G0_0_1_2_1_0 + 0.0205226871893538*G0_0_1_2_1_1 + 0.0242167708834375*G0_0_1_2_1_2 + 0.0131345198011865*G0_0_1_2_2_0 + 0.0242167708834375*G0_0_1_2_2_1 + 0.0123136123136124*G0_0_1_2_2_2;
    A[114] = A[142] + 0.174699374699374*G0_0_1_0_0_0 - 0.0200096200096199*G0_0_1_0_0_1 - 0.0135962802629468*G0_0_1_0_0_2 - 0.0200096200096199*G0_0_1_0_1_0 - 0.0138784672118005*G0_0_1_0_1_1 - 0.0135962802629468*G0_0_1_0_2_0 - 0.00336059002725668*G0_0_1_0_2_2 - 0.0200096200096199*G0_0_1_1_0_0 - 0.0138784672118005*G0_0_1_1_0_1 - 0.0138784672118005*G0_0_1_1_1_0 - 0.00892736892736887*G0_0_1_1_1_1 - 0.000897867564534255*G0_0_1_1_1_2 - 0.000897867564534251*G0_0_1_1_2_1 - 0.000820907487574206*G0_0_1_1_2_2 - 0.0135962802629468*G0_0_1_2_0_0 - 0.00336059002725668*G0_0_1_2_0_2 - 0.000897867564534253*G0_0_1_2_1_1 - 0.000820907487574206*G0_0_1_2_1_2 - 0.00336059002725668*G0_0_1_2_2_0 - 0.000820907487574206*G0_0_1_2_2_1 - 0.00823472823472839*G0_0_1_2_2_2 - 0.174699374699374*G0_1_0_0_0_0 + 0.0200096200096199*G0_1_0_0_0_1 + 0.0135962802629468*G0_1_0_0_0_2 + 0.0200096200096199*G0_1_0_0_1_0 + 0.0138784672118005*G0_1_0_0_1_1 + 0.0135962802629468*G0_1_0_0_2_0 + 0.00336059002725668*G0_1_0_0_2_2 + 0.0200096200096199*G0_1_0_1_0_0 + 0.0138784672118005*G0_1_0_1_0_1 + 0.0138784672118005*G0_1_0_1_1_0 + 0.00892736892736887*G0_1_0_1_1_1 + 0.000897867564534255*G0_1_0_1_1_2 + 0.000897867564534253*G0_1_0_1_2_1 + 0.000820907487574206*G0_1_0_1_2_2 + 0.0135962802629468*G0_1_0_2_0_0 + 0.00336059002725668*G0_1_0_2_0_2 + 0.000897867564534255*G0_1_0_2_1_1 + 0.000820907487574206*G0_1_0_2_1_2 + 0.00336059002725668*G0_1_0_2_2_0 + 0.000820907487574206*G0_1_0_2_2_1 + 0.00823472823472839*G0_1_0_2_2_2;
    A[221] = -A[213] + 0.0316049382716046*G0_0_0_0_0_0 + 0.00800384800384795*G0_0_0_0_0_1 + 0.0597210197210194*G0_0_0_0_0_2 + 0.00800384800384795*G0_0_0_0_1_0 + 0.00841430174763499*G0_0_0_0_1_1 + 0.00389931056597721*G0_0_0_0_1_2 + 0.0597210197210194*G0_0_0_0_2_0 + 0.00389931056597721*G0_0_0_0_2_1 + 0.11020683020683*G0_0_0_0_2_2 + 0.00800384800384795*G0_0_0_1_0_0 + 0.00841430174763499*G0_0_0_1_0_1 + 0.00389931056597721*G0_0_0_1_0_2 + 0.00841430174763498*G0_0_0_1_1_0 - 0.0348885682219018*G0_0_0_1_1_1 - 0.018675645342312*G0_0_0_1_1_2 + 0.00389931056597721*G0_0_0_1_2_0 - 0.018675645342312*G0_0_0_1_2_1 + 0.0170338303671636*G0_0_0_1_2_2 + 0.0597210197210194*G0_0_0_2_0_0 + 0.00389931056597721*G0_0_0_2_0_1 + 0.11020683020683*G0_0_0_2_0_2 + 0.00389931056597721*G0_0_0_2_1_0 - 0.018675645342312*G0_0_0_2_1_1 + 0.0170338303671636*G0_0_0_2_1_2 + 0.11020683020683*G0_0_0_2_2_0 + 0.0170338303671636*G0_0_0_2_2_1 + 0.373923360590025*G0_0_0_2_2_2 - 0.0123136123136127*G0_1_0_0_0_0 - 0.0242167708834375*G0_1_0_0_0_1 - 0.0131345198011865*G0_1_0_0_0_2 - 0.0242167708834375*G0_1_0_0_1_0 - 0.0205226871893537*G0_1_0_0_1_1 - 0.000410453743787069*G0_1_0_0_1_2 - 0.0131345198011865*G0_1_0_0_2_0 - 0.000410453743787069*G0_1_0_0_2_1 - 0.00451499118165783*G0_1_0_0_2_2 - 0.0242167708834375*G0_1_0_1_0_0 - 0.0205226871893537*G0_1_0_1_0_1 - 0.00041045374378707*G0_1_0_1_0_2 - 0.0205226871893537*G0_1_0_1_1_0 + 0.0205226871893539*G0_1_0_1_1_2 - 0.000410453743787067*G0_1_0_1_2_0 + 0.0205226871893539*G0_1_0_1_2_1 + 0.0250376783710116*G0_1_0_1_2_2 - 0.0131345198011865*G0_1_0_2_0_0 - 0.000410453743787071*G0_1_0_2_0_1 - 0.00451499118165783*G0_1_0_2_0_2 - 0.00041045374378707*G0_1_0_2_1_0 + 0.0205226871893539*G0_1_0_2_1_1 + 0.0250376783710116*G0_1_0_2_1_2 - 0.00451499118165783*G0_1_0_2_2_0 + 0.0250376783710116*G0_1_0_2_2_1 + 0.0652621452621452*G0_1_0_2_2_2;
    A[133] = A[221] - 0.0051306717973383*G0_0_0_0_0_0 - 0.00697771364438025*G0_0_0_0_0_1 - 0.0149815616482282*G0_0_0_0_0_2 - 0.00697771364438025*G0_0_0_0_1_0 - 0.00287317620650948*G0_0_0_0_1_1 - 0.00143658810325475*G0_0_0_0_1_2 - 0.0149815616482282*G0_0_0_0_2_0 - 0.00143658810325475*G0_0_0_0_2_1 - 0.0129292929292927*G0_0_0_0_2_2 - 0.00697771364438025*G0_0_0_1_0_0 - 0.00287317620650948*G0_0_0_1_0_1 - 0.00143658810325475*G0_0_0_1_0_2 - 0.00287317620650948*G0_0_0_1_1_0 + 0.0872214205547536*G0_0_0_1_1_1 + 0.00595157928491267*G0_0_0_1_1_2 - 0.00143658810325475*G0_0_0_1_2_0 + 0.00595157928491267*G0_0_0_1_2_1 - 0.0158024691358022*G0_0_0_1_2_2 - 0.0149815616482282*G0_0_0_2_0_0 - 0.00143658810325475*G0_0_0_2_0_1 - 0.0129292929292927*G0_0_0_2_0_2 - 0.00143658810325475*G0_0_0_2_1_0 + 0.00595157928491267*G0_0_0_2_1_1 - 0.0158024691358022*G0_0_0_2_1_2 - 0.0129292929292927*G0_0_0_2_2_0 - 0.0158024691358022*G0_0_0_2_2_1 - 0.0660830527497177*G0_0_0_2_2_2 - 0.00174442841109501*G0_0_1_0_0_1 + 0.00174442841109508*G0_0_1_0_0_2 - 0.00174442841109501*G0_0_1_0_1_0 + 0.00625941959275302*G0_0_1_0_1_1 + 0.00174442841109508*G0_0_1_0_2_0 - 0.00625941959275279*G0_0_1_0_2_2 - 0.00174442841109501*G0_0_1_1_0_0 + 0.00625941959275302*G0_0_1_1_0_1 + 0.00625941959275302*G0_0_1_1_1_0 + 0.136065416065416*G0_0_1_1_1_1 + 0.0111848645181978*G0_0_1_1_1_2 + 0.0111848645181978*G0_0_1_1_2_1 - 0.0111848645181977*G0_0_1_1_2_2 + 0.00174442841109508*G0_0_1_2_0_0 - 0.00625941959275279*G0_0_1_2_0_2 + 0.0111848645181978*G0_0_1_2_1_1 - 0.0111848645181977*G0_0_1_2_1_2 - 0.00625941959275279*G0_0_1_2_2_0 - 0.0111848645181977*G0_0_1_2_2_1 - 0.136065416065414*G0_0_1_2_2_2 + 0.0126214526214525*G0_1_0_0_0_1 - 0.0126214526214527*G0_1_0_0_0_2 + 0.0126214526214525*G0_1_0_0_1_0 + 0.0280134680134679*G0_1_0_0_1_1 - 0.0126214526214527*G0_1_0_0_2_0 - 0.028013468013468*G0_1_0_0_2_2 + 0.0126214526214525*G0_1_0_1_0_0 + 0.0280134680134678*G0_1_0_1_0_1 + 0.0280134680134678*G0_1_0_1_1_0 + 0.107744107744107*G0_1_0_1_1_1 + 0.00420715087381764*G0_1_0_1_1_2 + 0.00420715087381764*G0_1_0_1_2_1 - 0.00420715087381738*G0_1_0_1_2_2 - 0.0126214526214527*G0_1_0_2_0_0 - 0.028013468013468*G0_1_0_2_0_2 + 0.00420715087381764*G0_1_0_2_1_1 - 0.00420715087381738*G0_1_0_2_1_2 - 0.028013468013468*G0_1_0_2_2_0 - 0.00420715087381738*G0_1_0_2_2_1 - 0.107744107744107*G0_1_0_2_2_2 + 0.00513067179733854*G0_1_1_0_0_0 + 0.0149815616482282*G0_1_1_0_0_1 + 0.00697771364438022*G0_1_1_0_0_2 + 0.0149815616482282*G0_1_1_0_1_0 + 0.0129292929292928*G0_1_1_0_1_1 + 0.00143658810325473*G0_1_1_0_1_2 + 0.00697771364438022*G0_1_1_0_2_0 + 0.00143658810325473*G0_1_1_0_2_1 + 0.00287317620650949*G0_1_1_0_2_2 + 0.0149815616482282*G0_1_1_1_0_0 + 0.0129292929292928*G0_1_1_1_0_1 + 0.00143658810325473*G0_1_1_1_0_2 + 0.0129292929292928*G0_1_1_1_1_0 + 0.0660830527497191*G0_1_1_1_1_1 + 0.0158024691358025*G0_1_1_1_1_2 + 0.00143658810325473*G0_1_1_1_2_0 + 0.0158024691358025*G0_1_1_1_2_1 - 0.0059515792849125*G0_1_1_1_2_2 + 0.00697771364438022*G0_1_1_2_0_0 + 0.00143658810325473*G0_1_1_2_0_1 + 0.00287317620650949*G0_1_1_2_0_2 + 0.00143658810325473*G0_1_1_2_1_0 + 0.0158024691358025*G0_1_1_2_1_1 - 0.0059515792849125*G0_1_1_2_1_2 + 0.00287317620650949*G0_1_1_2_2_0 - 0.0059515792849125*G0_1_1_2_2_1 - 0.0872214205547525*G0_1_1_2_2_2;
    A[88] = -A[133] - 0.0123136123136127*G0_1_0_0_0_0 - 0.0131345198011865*G0_1_0_0_0_1 - 0.0242167708834376*G0_1_0_0_0_2 - 0.0131345198011865*G0_1_0_0_1_0 - 0.00451499118165788*G0_1_0_0_1_1 - 0.000410453743787077*G0_1_0_0_1_2 - 0.0242167708834376*G0_1_0_0_2_0 - 0.000410453743787077*G0_1_0_0_2_1 - 0.020522687189354*G0_1_0_0_2_2 - 0.0131345198011865*G0_1_0_1_0_0 - 0.00451499118165788*G0_1_0_1_0_1 - 0.000410453743787077*G0_1_0_1_0_2 - 0.00451499118165788*G0_1_0_1_1_0 + 0.065262145262145*G0_1_0_1_1_1 + 0.0250376783710118*G0_1_0_1_1_2 - 0.000410453743787078*G0_1_0_1_2_0 + 0.0250376783710118*G0_1_0_1_2_1 + 0.0205226871893539*G0_1_0_1_2_2 - 0.0242167708834376*G0_1_0_2_0_0 - 0.000410453743787077*G0_1_0_2_0_1 - 0.020522687189354*G0_1_0_2_0_2 - 0.000410453743787078*G0_1_0_2_1_0 + 0.0250376783710118*G0_1_0_2_1_1 + 0.0205226871893539*G0_1_0_2_1_2 - 0.020522687189354*G0_1_0_2_2_0 + 0.0205226871893539*G0_1_0_2_2_1 + 0.031604938271605*G0_1_1_0_0_0 + 0.0597210197210194*G0_1_1_0_0_1 + 0.00800384800384793*G0_1_1_0_0_2 + 0.0597210197210194*G0_1_1_0_1_0 + 0.11020683020683*G0_1_1_0_1_1 + 0.00389931056597719*G0_1_1_0_1_2 + 0.00800384800384793*G0_1_1_0_2_0 + 0.00389931056597719*G0_1_1_0_2_1 + 0.00841430174763497*G0_1_1_0_2_2 + 0.0597210197210194*G0_1_1_1_0_0 + 0.11020683020683*G0_1_1_1_0_1 + 0.00389931056597719*G0_1_1_1_0_2 + 0.11020683020683*G0_1_1_1_1_0 + 0.373923360590026*G0_1_1_1_1_1 + 0.0170338303671637*G0_1_1_1_1_2 + 0.00389931056597719*G0_1_1_1_2_0 + 0.0170338303671637*G0_1_1_1_2_1 - 0.0186756453423119*G0_1_1_1_2_2 + 0.00800384800384793*G0_1_1_2_0_0 + 0.00389931056597719*G0_1_1_2_0_1 + 0.00841430174763497*G0_1_1_2_0_2 + 0.00389931056597719*G0_1_1_2_1_0 + 0.0170338303671637*G0_1_1_2_1_1 - 0.0186756453423119*G0_1_1_2_1_2 + 0.00841430174763497*G0_1_1_2_2_0 - 0.0186756453423119*G0_1_1_2_2_1 - 0.0348885682219011*G0_1_1_2_2_2;
    A[193] = -A[88] - 0.420202020202018*G0_0_0_0_0_0 - 0.0803463203463201*G0_0_0_0_0_1 - 0.208305274971941*G0_0_0_0_0_2 - 0.0803463203463201*G0_0_0_0_1_0 - 0.0813724547057878*G0_0_0_0_1_1 - 0.0640307840307838*G0_0_0_0_1_2 - 0.208305274971941*G0_0_0_0_2_0 - 0.0640307840307838*G0_0_0_0_2_1 - 0.170133076799743*G0_0_0_0_2_2 - 0.0803463203463201*G0_0_0_1_0_0 - 0.0813724547057878*G0_0_0_1_0_1 - 0.0640307840307838*G0_0_0_1_0_2 - 0.0813724547057878*G0_0_0_1_1_0 - 0.429437229437227*G0_0_0_1_1_1 - 0.198043931377264*G0_0_0_1_1_2 - 0.0640307840307838*G0_0_0_1_2_0 - 0.198043931377264*G0_0_0_1_2_1 - 0.135244508577841*G0_0_0_1_2_2 - 0.208305274971941*G0_0_0_2_0_0 - 0.0640307840307838*G0_0_0_2_0_1 - 0.170133076799743*G0_0_0_2_0_2 - 0.0640307840307838*G0_0_0_2_1_0 - 0.198043931377264*G0_0_0_2_1_1 - 0.135244508577841*G0_0_0_2_1_2 - 0.170133076799743*G0_0_0_2_2_0 - 0.135244508577841*G0_0_0_2_2_1 - 0.20933140933141*G0_0_0_2_2_2 - 0.122007375340708*G0_0_1_0_0_0 - 0.0475100208433541*G0_0_1_0_0_1 - 0.0246272246272246*G0_0_1_0_0_2 - 0.0475100208433541*G0_0_1_0_1_0 - 0.064030784030784*G0_0_1_0_1_1 - 0.0148789482122815*G0_0_1_0_1_2 - 0.0246272246272246*G0_0_1_0_2_0 - 0.0148789482122815*G0_0_1_0_2_1 - 0.00112874779541464*G0_0_1_0_2_2 - 0.0475100208433541*G0_0_1_1_0_0 - 0.064030784030784*G0_0_1_1_0_1 - 0.0148789482122815*G0_0_1_1_0_2 - 0.064030784030784*G0_0_1_1_1_0 - 0.415994869328201*G0_0_1_1_1_1 - 0.156588103254769*G0_0_1_1_1_2 - 0.0148789482122815*G0_0_1_1_2_0 - 0.156588103254769*G0_0_1_1_2_1 - 0.0813724547057876*G0_0_1_1_2_2 - 0.0246272246272246*G0_0_1_2_0_0 - 0.0148789482122815*G0_0_1_2_0_1 - 0.00112874779541464*G0_0_1_2_0_2 - 0.0148789482122815*G0_0_1_2_1_0 - 0.156588103254769*G0_0_1_2_1_1 - 0.0813724547057876*G0_0_1_2_1_2 - 0.00112874779541464*G0_0_1_2_2_0 - 0.0813724547057876*G0_0_1_2_2_1 + 0.0599262465929114*G0_0_1_2_2_2 + 0.00297578964245559*G0_1_0_0_0_0 - 0.0145711079044415*G0_1_0_0_0_1 - 0.0425845759179092*G0_1_0_0_0_2 - 0.0145711079044415*G0_1_0_0_1_0 - 0.0294500561167229*G0_1_0_0_1_1 - 0.0440211640211639*G0_1_0_0_1_2 - 0.0425845759179092*G0_1_0_0_2_0 - 0.0440211640211639*G0_1_0_0_2_1 - 0.0420715087381753*G0_1_0_0_2_2 - 0.0145711079044415*G0_1_0_1_0_0 - 0.0294500561167229*G0_1_0_1_0_1 - 0.0440211640211639*G0_1_0_1_0_2 - 0.0294500561167229*G0_1_0_1_1_0 - 0.241757255090587*G0_1_0_1_1_1 - 0.148686868686868*G0_1_0_1_1_2 - 0.0440211640211639*G0_1_0_1_2_0 - 0.148686868686868*G0_1_0_1_2_1 - 0.112053872053871*G0_1_0_1_2_2 - 0.0425845759179092*G0_1_0_2_0_0 - 0.0440211640211639*G0_1_0_2_0_1 - 0.0420715087381753*G0_1_0_2_0_2 - 0.0440211640211639*G0_1_0_2_1_0 - 0.148686868686868*G0_1_0_2_1_1 - 0.112053872053871*G0_1_0_2_1_2 - 0.0420715087381753*G0_1_0_2_2_0 - 0.112053872053871*G0_1_0_2_2_1 - 0.021959275292609*G0_1_0_2_2_2 + 0.0249350649350651*G0_1_1_0_0_0 + 0.0974827641494303*G0_1_1_0_0_1 - 0.000513067179733879*G0_1_1_0_0_2 + 0.0974827641494303*G0_1_1_0_1_0 + 0.119236812570145*G0_1_1_0_1_1 - 0.000513067179733878*G0_1_1_0_2_0 + 0.000513067179733764*G0_1_1_0_2_2 + 0.0974827641494303*G0_1_1_1_0_0 + 0.119236812570145*G0_1_1_1_0_1 + 0.119236812570145*G0_1_1_1_1_0 - 0.119236812570145*G0_1_1_1_1_2 - 0.119236812570145*G0_1_1_1_2_1 - 0.0974827641494304*G0_1_1_1_2_2 - 0.000513067179733878*G0_1_1_2_0_0 + 0.000513067179733763*G0_1_1_2_0_2 - 0.119236812570145*G0_1_1_2_1_1 - 0.0974827641494304*G0_1_1_2_1_2 + 0.000513067179733764*G0_1_1_2_2_0 - 0.0974827641494304*G0_1_1_2_2_1 - 0.0249350649350656*G0_1_1_2_2_2;
    A[222] = A[193] + 0.418662818662817*G0_0_0_0_0_0 + 0.0788071188071186*G0_0_0_0_0_1 + 0.26104858104858*G0_0_0_0_0_2 + 0.0788071188071186*G0_0_0_0_1_0 + 0.0763443963443961*G0_0_0_0_1_1 + 0.0615680615680614*G0_0_0_0_1_2 + 0.26104858104858*G0_0_0_0_2_0 + 0.0615680615680614*G0_0_0_0_2_1 + 0.192092352092352*G0_0_0_0_2_2 + 0.0788071188071186*G0_0_0_1_0_0 + 0.0763443963443961*G0_0_0_1_0_1 + 0.0615680615680614*G0_0_0_1_0_2 + 0.0763443963443961*G0_0_0_1_1_0 + 0.35216931216931*G0_0_0_1_1_1 + 0.113285233285233*G0_0_0_1_1_2 + 0.0615680615680614*G0_0_0_1_2_0 + 0.113285233285233*G0_0_0_1_2_1 + 0.0147763347763346*G0_0_0_1_2_2 + 0.26104858104858*G0_0_0_2_0_0 + 0.0615680615680614*G0_0_0_2_0_1 + 0.192092352092352*G0_0_0_2_0_2 + 0.0615680615680614*G0_0_0_2_1_0 + 0.113285233285233*G0_0_0_2_1_1 + 0.0147763347763346*G0_0_0_2_1_2 + 0.192092352092352*G0_0_0_2_2_0 + 0.0147763347763346*G0_0_0_2_2_1 - 0.0985088985088978*G0_0_0_2_2_2 + 0.0246272246272243*G0_0_1_0_0_1 - 0.0246272246272244*G0_0_1_0_0_2 + 0.0246272246272243*G0_0_1_0_1_0 + 0.0566426166426163*G0_0_1_0_1_1 - 0.0246272246272244*G0_0_1_0_2_0 - 0.0566426166426164*G0_0_1_0_2_2 + 0.0246272246272243*G0_0_1_1_0_0 + 0.0566426166426163*G0_0_1_1_0_1 + 0.0566426166426163*G0_0_1_1_1_0 + 0.339855699855698*G0_0_1_1_1_1 + 0.0640307840307835*G0_0_1_1_1_2 + 0.0640307840307835*G0_0_1_1_2_1 - 0.064030784030784*G0_0_1_1_2_2 - 0.0246272246272244*G0_0_1_2_0_0 - 0.0566426166426164*G0_0_1_2_0_2 + 0.0640307840307835*G0_0_1_2_1_1 - 0.064030784030784*G0_0_1_2_1_2 - 0.0566426166426164*G0_0_1_2_2_0 - 0.064030784030784*G0_0_1_2_2_1 - 0.339855699855699*G0_0_1_2_2_2 - 0.0295526695526692*G0_1_0_0_0_1 + 0.0295526695526696*G0_1_0_0_0_2 - 0.0295526695526692*G0_1_0_0_1_0 - 0.0246272246272244*G0_1_0_0_1_1 + 0.0295526695526696*G0_1_0_0_2_0 + 0.0246272246272245*G0_1_0_0_2_2 - 0.0295526695526692*G0_1_0_1_0_0 - 0.0246272246272244*G0_1_0_1_0_1 - 0.0246272246272244*G0_1_0_1_1_0 + 0.177316017316017*G0_1_0_1_1_1 + 0.0369408369408368*G0_1_0_1_1_2 + 0.0369408369408368*G0_1_0_1_2_1 - 0.0369408369408368*G0_1_0_1_2_2 + 0.0295526695526696*G0_1_0_2_0_0 + 0.0246272246272245*G0_1_0_2_0_2 + 0.0369408369408368*G0_1_0_2_1_1 - 0.0369408369408368*G0_1_0_2_1_2 + 0.0246272246272245*G0_1_0_2_2_0 - 0.0369408369408368*G0_1_0_2_2_1 - 0.177316017316017*G0_1_0_2_2_2 - 0.418662818662818*G0_1_1_0_0_0 - 0.26104858104858*G0_1_1_0_0_1 - 0.0788071188071184*G0_1_1_0_0_2 - 0.26104858104858*G0_1_1_0_1_0 - 0.192092352092351*G0_1_1_0_1_1 - 0.0615680615680613*G0_1_1_0_1_2 - 0.0788071188071184*G0_1_1_0_2_0 - 0.0615680615680613*G0_1_1_0_2_1 - 0.076344396344396*G0_1_1_0_2_2 - 0.26104858104858*G0_1_1_1_0_0 - 0.192092352092351*G0_1_1_1_0_1 - 0.0615680615680613*G0_1_1_1_0_2 - 0.192092352092351*G0_1_1_1_1_0 + 0.0985088985088976*G0_1_1_1_1_1 - 0.0147763347763348*G0_1_1_1_1_2 - 0.0615680615680613*G0_1_1_1_2_0 - 0.0147763347763348*G0_1_1_1_2_1 - 0.113285233285233*G0_1_1_1_2_2 - 0.0788071188071184*G0_1_1_2_0_0 - 0.0615680615680613*G0_1_1_2_0_1 - 0.076344396344396*G0_1_1_2_0_2 - 0.0615680615680613*G0_1_1_2_1_0 - 0.0147763347763348*G0_1_1_2_1_1 - 0.113285233285233*G0_1_1_2_1_2 - 0.0763443963443961*G0_1_1_2_2_0 - 0.113285233285233*G0_1_1_2_2_1 - 0.352169312169311*G0_1_1_2_2_2;
    A[179] = A[221] - 0.00430976430976466*G0_0_1_0_0_0 - 0.0185730319063652*G0_0_1_0_0_1 - 0.00420715087381758*G0_0_1_0_0_2 - 0.0185730319063652*G0_0_1_0_1_0 - 0.0189834856501522*G0_0_1_0_1_1 - 0.000820907487574152*G0_0_1_0_1_2 - 0.00420715087381759*G0_0_1_0_2_0 - 0.000820907487574151*G0_0_1_0_2_1 + 0.00277056277056271*G0_0_1_0_2_2 - 0.0185730319063652*G0_0_1_1_0_0 - 0.0189834856501522*G0_0_1_1_0_1 - 0.000820907487574151*G0_0_1_1_0_2 - 0.0189834856501522*G0_0_1_1_1_0 + 0.0523328523328523*G0_0_1_1_1_1 + 0.0118005451338784*G0_0_1_1_1_2 - 0.000820907487574151*G0_0_1_1_2_0 + 0.0118005451338784*G0_0_1_1_2_1 + 0.0048228314894981*G0_0_1_1_2_2 - 0.00420715087381758*G0_0_1_2_0_0 - 0.000820907487574151*G0_0_1_2_0_1 + 0.00277056277056271*G0_0_1_2_0_2 - 0.000820907487574151*G0_0_1_2_1_0 + 0.0118005451338784*G0_0_1_2_1_1 + 0.0048228314894981*G0_0_1_2_1_2 + 0.00277056277056271*G0_0_1_2_2_0 + 0.0048228314894981*G0_0_1_2_2_1 + 0.0240115440115438*G0_0_1_2_2_2 + 0.00430976430976466*G0_1_0_0_0_0 + 0.0185730319063652*G0_1_0_0_0_1 + 0.00420715087381758*G0_1_0_0_0_2 + 0.0185730319063652*G0_1_0_0_1_0 + 0.0189834856501522*G0_1_0_0_1_1 + 0.000820907487574151*G0_1_0_0_1_2 + 0.00420715087381758*G0_1_0_0_2_0 + 0.00082090748757415*G0_1_0_0_2_1 - 0.00277056277056271*G0_1_0_0_2_2 + 0.0185730319063652*G0_1_0_1_0_0 + 0.0189834856501522*G0_1_0_1_0_1 + 0.000820907487574151*G0_1_0_1_0_2 + 0.0189834856501522*G0_1_0_1_1_0 - 0.0523328523328524*G0_1_0_1_1_1 - 0.0118005451338784*G0_1_0_1_1_2 + 0.000820907487574149*G0_1_0_1_2_0 - 0.0118005451338784*G0_1_0_1_2_1 - 0.0048228314894981*G0_1_0_1_2_2 + 0.00420715087381758*G0_1_0_2_0_0 + 0.000820907487574151*G0_1_0_2_0_1 - 0.00277056277056271*G0_1_0_2_0_2 + 0.00082090748757415*G0_1_0_2_1_0 - 0.0118005451338784*G0_1_0_2_1_1 - 0.0048228314894981*G0_1_0_2_1_2 - 0.00277056277056271*G0_1_0_2_2_0 - 0.0048228314894981*G0_1_0_2_2_1 - 0.0240115440115438*G0_1_0_2_2_2;
    A[207] = A[193] + 0.132987012987012*G0_0_1_0_0_0 + 0.0418662818662815*G0_0_1_0_0_1 - 0.0123136123136123*G0_0_1_0_0_2 + 0.0418662818662815*G0_0_1_0_1_0 + 0.0418662818662816*G0_0_1_0_1_1 - 0.0295526695526695*G0_0_1_0_1_2 - 0.0123136123136123*G0_0_1_0_2_0 - 0.0295526695526695*G0_0_1_0_2_1 - 0.0394035594035592*G0_0_1_0_2_2 + 0.0418662818662815*G0_0_1_1_0_0 + 0.0418662818662816*G0_0_1_1_0_1 - 0.0295526695526695*G0_0_1_1_0_2 + 0.0418662818662816*G0_0_1_1_1_0 + 0.132987012987012*G0_0_1_1_1_1 - 0.0123136123136124*G0_0_1_1_1_2 - 0.0295526695526695*G0_0_1_1_2_0 - 0.0123136123136124*G0_0_1_1_2_1 - 0.0394035594035593*G0_0_1_1_2_2 - 0.0123136123136123*G0_0_1_2_0_0 - 0.0295526695526695*G0_0_1_2_0_1 - 0.0394035594035592*G0_0_1_2_0_2 - 0.0295526695526695*G0_0_1_2_1_0 - 0.0123136123136124*G0_0_1_2_1_1 - 0.0394035594035593*G0_0_1_2_1_2 - 0.0394035594035592*G0_0_1_2_2_0 - 0.0394035594035593*G0_0_1_2_2_1 - 0.0295526695526697*G0_0_1_2_2_2 - 0.132987012987012*G0_1_0_0_0_0 - 0.0418662818662815*G0_1_0_0_0_1 + 0.0123136123136123*G0_1_0_0_0_2 - 0.0418662818662815*G0_1_0_0_1_0 - 0.0418662818662816*G0_1_0_0_1_1 + 0.0295526695526695*G0_1_0_0_1_2 + 0.0123136123136123*G0_1_0_0_2_0 + 0.0295526695526695*G0_1_0_0_2_1 + 0.0394035594035592*G0_1_0_0_2_2 - 0.0418662818662815*G0_1_0_1_0_0 - 0.0418662818662816*G0_1_0_1_0_1 + 0.0295526695526695*G0_1_0_1_0_2 - 0.0418662818662816*G0_1_0_1_1_0 - 0.132987012987012*G0_1_0_1_1_1 + 0.0123136123136124*G0_1_0_1_1_2 + 0.0295526695526695*G0_1_0_1_2_0 + 0.0123136123136124*G0_1_0_1_2_1 + 0.0394035594035593*G0_1_0_1_2_2 + 0.0123136123136123*G0_1_0_2_0_0 + 0.0295526695526695*G0_1_0_2_0_1 + 0.0394035594035592*G0_1_0_2_0_2 + 0.0295526695526695*G0_1_0_2_1_0 + 0.0123136123136124*G0_1_0_2_1_1 + 0.0394035594035593*G0_1_0_2_1_2 + 0.0394035594035592*G0_1_0_2_2_0 + 0.0394035594035593*G0_1_0_2_2_1 + 0.0295526695526697*G0_1_0_2_2_2;
    A[194] = A[222] + 0.132987012987013*G0_0_1_0_0_0 - 0.0123136123136121*G0_0_1_0_0_1 + 0.0418662818662817*G0_0_1_0_0_2 - 0.0123136123136121*G0_0_1_0_1_0 - 0.0394035594035592*G0_0_1_0_1_1 - 0.0295526695526694*G0_0_1_0_1_2 + 0.0418662818662817*G0_0_1_0_2_0 - 0.0295526695526694*G0_0_1_0_2_1 + 0.0418662818662817*G0_0_1_0_2_2 - 0.0123136123136121*G0_0_1_1_0_0 - 0.0394035594035592*G0_0_1_1_0_1 - 0.0295526695526694*G0_0_1_1_0_2 - 0.0394035594035592*G0_0_1_1_1_0 - 0.0295526695526693*G0_0_1_1_1_1 - 0.0394035594035592*G0_0_1_1_1_2 - 0.0295526695526694*G0_0_1_1_2_0 - 0.0394035594035592*G0_0_1_1_2_1 - 0.0123136123136121*G0_0_1_1_2_2 + 0.0418662818662817*G0_0_1_2_0_0 - 0.0295526695526694*G0_0_1_2_0_1 + 0.0418662818662817*G0_0_1_2_0_2 - 0.0295526695526694*G0_0_1_2_1_0 - 0.0394035594035592*G0_0_1_2_1_1 - 0.0123136123136121*G0_0_1_2_1_2 + 0.0418662818662817*G0_0_1_2_2_0 - 0.0123136123136121*G0_0_1_2_2_1 + 0.132987012987013*G0_0_1_2_2_2 - 0.132987012987013*G0_1_0_0_0_0 + 0.0123136123136121*G0_1_0_0_0_1 - 0.0418662818662817*G0_1_0_0_0_2 + 0.0123136123136121*G0_1_0_0_1_0 + 0.0394035594035592*G0_1_0_0_1_1 + 0.0295526695526694*G0_1_0_0_1_2 - 0.0418662818662817*G0_1_0_0_2_0 + 0.0295526695526694*G0_1_0_0_2_1 - 0.0418662818662817*G0_1_0_0_2_2 + 0.0123136123136121*G0_1_0_1_0_0 + 0.0394035594035592*G0_1_0_1_0_1 + 0.0295526695526694*G0_1_0_1_0_2 + 0.0394035594035592*G0_1_0_1_1_0 + 0.0295526695526693*G0_1_0_1_1_1 + 0.0394035594035591*G0_1_0_1_1_2 + 0.0295526695526694*G0_1_0_1_2_0 + 0.0394035594035591*G0_1_0_1_2_1 + 0.0123136123136121*G0_1_0_1_2_2 - 0.0418662818662817*G0_1_0_2_0_0 + 0.0295526695526694*G0_1_0_2_0_1 - 0.0418662818662817*G0_1_0_2_0_2 + 0.0295526695526694*G0_1_0_2_1_0 + 0.0394035594035591*G0_1_0_2_1_1 + 0.0123136123136121*G0_1_0_2_1_2 - 0.0418662818662817*G0_1_0_2_2_0 + 0.0123136123136121*G0_1_0_2_2_1 - 0.132987012987013*G0_1_0_2_2_2;
    A[200] = A[88] - 0.00800384800384806*G0_0_1_0_0_0 - 0.00892736892736886*G0_0_1_0_0_1 - 0.00564373897707231*G0_0_1_0_0_2 - 0.00892736892736886*G0_0_1_0_1_0 - 0.00728555395222047*G0_0_1_0_1_1 + 0.000410453743787097*G0_0_1_0_1_2 - 0.00564373897707231*G0_0_1_0_2_0 + 0.000410453743787098*G0_0_1_0_2_1 - 0.00153920153920145*G0_0_1_0_2_2 - 0.00892736892736886*G0_0_1_1_0_0 - 0.00728555395222047*G0_0_1_1_0_1 + 0.000410453743787097*G0_0_1_1_0_2 - 0.00728555395222048*G0_0_1_1_1_0 + 0.0412506012506015*G0_0_1_1_1_1 + 0.0202148468815136*G0_0_1_1_1_2 + 0.000410453743787097*G0_0_1_1_2_0 + 0.0202148468815136*G0_0_1_1_2_1 + 0.00872214205547549*G0_0_1_1_2_2 - 0.00564373897707232*G0_0_1_2_0_0 + 0.000410453743787098*G0_0_1_2_0_1 - 0.00153920153920145*G0_0_1_2_0_2 + 0.000410453743787097*G0_0_1_2_1_0 + 0.0202148468815136*G0_0_1_2_1_1 + 0.0087221420554755*G0_0_1_2_1_2 - 0.00153920153920145*G0_0_1_2_2_0 + 0.0087221420554755*G0_0_1_2_2_1 - 0.0523328523328508*G0_0_1_2_2_2 + 0.00800384800384806*G0_1_0_0_0_0 + 0.00892736892736886*G0_1_0_0_0_1 + 0.00564373897707232*G0_1_0_0_0_2 + 0.00892736892736886*G0_1_0_0_1_0 + 0.00728555395222048*G0_1_0_0_1_1 - 0.000410453743787096*G0_1_0_0_1_2 + 0.00564373897707231*G0_1_0_0_2_0 - 0.000410453743787097*G0_1_0_0_2_1 + 0.00153920153920145*G0_1_0_0_2_2 + 0.00892736892736886*G0_1_0_1_0_0 + 0.00728555395222048*G0_1_0_1_0_1 - 0.000410453743787096*G0_1_0_1_0_2 + 0.00728555395222048*G0_1_0_1_1_0 - 0.0412506012506015*G0_1_0_1_1_1 - 0.0202148468815136*G0_1_0_1_1_2 - 0.000410453743787097*G0_1_0_1_2_0 - 0.0202148468815136*G0_1_0_1_2_1 - 0.00872214205547549*G0_1_0_1_2_2 + 0.00564373897707232*G0_1_0_2_0_0 - 0.000410453743787096*G0_1_0_2_0_1 + 0.00153920153920145*G0_1_0_2_0_2 - 0.000410453743787095*G0_1_0_2_1_0 - 0.0202148468815136*G0_1_0_2_1_1 - 0.00872214205547549*G0_1_0_2_1_2 + 0.00153920153920145*G0_1_0_2_2_0 - 0.00872214205547549*G0_1_0_2_2_1 + 0.0523328523328508*G0_1_0_2_2_2;
    A[203] = -A[200] - 0.0123136123136127*G0_0_1_0_0_0 - 0.0131345198011865*G0_0_1_0_0_1 - 0.0242167708834376*G0_0_1_0_0_2 - 0.0131345198011865*G0_0_1_0_1_0 - 0.00451499118165787*G0_0_1_0_1_1 - 0.000410453743787076*G0_0_1_0_1_2 - 0.0242167708834376*G0_0_1_0_2_0 - 0.000410453743787076*G0_0_1_0_2_1 - 0.020522687189354*G0_0_1_0_2_2 - 0.0131345198011865*G0_0_1_1_0_0 - 0.00451499118165787*G0_0_1_1_0_1 - 0.000410453743787076*G0_0_1_1_0_2 - 0.00451499118165788*G0_0_1_1_1_0 + 0.0652621452621451*G0_0_1_1_1_1 + 0.0250376783710118*G0_0_1_1_1_2 - 0.000410453743787078*G0_0_1_1_2_0 + 0.0250376783710118*G0_0_1_1_2_1 + 0.0205226871893539*G0_0_1_1_2_2 - 0.0242167708834376*G0_0_1_2_0_0 - 0.000410453743787076*G0_0_1_2_0_1 - 0.020522687189354*G0_0_1_2_0_2 - 0.000410453743787076*G0_0_1_2_1_0 + 0.0250376783710118*G0_0_1_2_1_1 + 0.0205226871893539*G0_0_1_2_1_2 - 0.020522687189354*G0_0_1_2_2_0 + 0.0205226871893539*G0_0_1_2_2_1 + 0.031604938271605*G0_1_1_0_0_0 + 0.0597210197210194*G0_1_1_0_0_1 + 0.00800384800384793*G0_1_1_0_0_2 + 0.0597210197210194*G0_1_1_0_1_0 + 0.11020683020683*G0_1_1_0_1_1 + 0.00389931056597719*G0_1_1_0_1_2 + 0.00800384800384793*G0_1_1_0_2_0 + 0.00389931056597719*G0_1_1_0_2_1 + 0.00841430174763497*G0_1_1_0_2_2 + 0.0597210197210194*G0_1_1_1_0_0 + 0.11020683020683*G0_1_1_1_0_1 + 0.00389931056597719*G0_1_1_1_0_2 + 0.11020683020683*G0_1_1_1_1_0 + 0.373923360590026*G0_1_1_1_1_1 + 0.0170338303671637*G0_1_1_1_1_2 + 0.00389931056597719*G0_1_1_1_2_0 + 0.0170338303671637*G0_1_1_1_2_1 - 0.0186756453423119*G0_1_1_1_2_2 + 0.00800384800384793*G0_1_1_2_0_0 + 0.00389931056597719*G0_1_1_2_0_1 + 0.00841430174763497*G0_1_1_2_0_2 + 0.00389931056597719*G0_1_1_2_1_0 + 0.0170338303671637*G0_1_1_2_1_1 - 0.0186756453423119*G0_1_1_2_1_2 + 0.00841430174763497*G0_1_1_2_2_0 - 0.0186756453423119*G0_1_1_2_2_1 - 0.0348885682219011*G0_1_1_2_2_2;
    A[59] = -A[179] + 0.0316049382716046*G0_0_0_0_0_0 + 0.00800384800384795*G0_0_0_0_0_1 + 0.0597210197210194*G0_0_0_0_0_2 + 0.00800384800384795*G0_0_0_0_1_0 + 0.00841430174763499*G0_0_0_0_1_1 + 0.00389931056597721*G0_0_0_0_1_2 + 0.0597210197210194*G0_0_0_0_2_0 + 0.00389931056597721*G0_0_0_0_2_1 + 0.11020683020683*G0_0_0_0_2_2 + 0.00800384800384795*G0_0_0_1_0_0 + 0.00841430174763499*G0_0_0_1_0_1 + 0.00389931056597721*G0_0_0_1_0_2 + 0.00841430174763498*G0_0_0_1_1_0 - 0.0348885682219018*G0_0_0_1_1_1 - 0.018675645342312*G0_0_0_1_1_2 + 0.00389931056597721*G0_0_0_1_2_0 - 0.018675645342312*G0_0_0_1_2_1 + 0.0170338303671636*G0_0_0_1_2_2 + 0.0597210197210194*G0_0_0_2_0_0 + 0.00389931056597721*G0_0_0_2_0_1 + 0.11020683020683*G0_0_0_2_0_2 + 0.00389931056597721*G0_0_0_2_1_0 - 0.018675645342312*G0_0_0_2_1_1 + 0.0170338303671636*G0_0_0_2_1_2 + 0.11020683020683*G0_0_0_2_2_0 + 0.0170338303671636*G0_0_0_2_2_1 + 0.373923360590025*G0_0_0_2_2_2 - 0.0123136123136127*G0_0_1_0_0_0 - 0.0242167708834375*G0_0_1_0_0_1 - 0.0131345198011865*G0_0_1_0_0_2 - 0.0242167708834375*G0_0_1_0_1_0 - 0.0205226871893537*G0_0_1_0_1_1 - 0.000410453743787069*G0_0_1_0_1_2 - 0.0131345198011865*G0_0_1_0_2_0 - 0.00041045374378707*G0_0_1_0_2_1 - 0.00451499118165783*G0_0_1_0_2_2 - 0.0242167708834375*G0_0_1_1_0_0 - 0.0205226871893537*G0_0_1_1_0_1 - 0.00041045374378707*G0_0_1_1_0_2 - 0.0205226871893537*G0_0_1_1_1_0 + 0.0205226871893539*G0_0_1_1_1_2 - 0.000410453743787069*G0_0_1_1_2_0 + 0.0205226871893539*G0_0_1_1_2_1 + 0.0250376783710116*G0_0_1_1_2_2 - 0.0131345198011865*G0_0_1_2_0_0 - 0.000410453743787072*G0_0_1_2_0_1 - 0.00451499118165783*G0_0_1_2_0_2 - 0.00041045374378707*G0_0_1_2_1_0 + 0.0205226871893539*G0_0_1_2_1_1 + 0.0250376783710116*G0_0_1_2_1_2 - 0.00451499118165783*G0_0_1_2_2_0 + 0.0250376783710116*G0_0_1_2_2_1 + 0.0652621452621452*G0_0_1_2_2_2;
    A[196] = A[28] + 0.00161616161616165*G0_0_1_0_0_0 + 0.00102613435946771*G0_0_1_0_0_1 + 0.000179573512906842*G0_0_1_0_0_2 + 0.00102613435946771*G0_0_1_0_1_0 - 0.0109026775693441*G0_0_1_0_1_1 + 0.000179573512906841*G0_0_1_0_2_0 - 0.000179573512906858*G0_0_1_0_2_2 + 0.00102613435946771*G0_0_1_1_0_0 - 0.0109026775693441*G0_0_1_1_0_1 - 0.0109026775693441*G0_0_1_1_1_0 + 0.0109026775693442*G0_0_1_1_1_2 + 0.0109026775693442*G0_0_1_1_2_1 - 0.0010261343594677*G0_0_1_1_2_2 + 0.000179573512906842*G0_0_1_2_0_0 - 0.000179573512906858*G0_0_1_2_0_2 + 0.0109026775693442*G0_0_1_2_1_1 - 0.0010261343594677*G0_0_1_2_1_2 - 0.000179573512906858*G0_0_1_2_2_0 - 0.00102613435946769*G0_0_1_2_2_1 - 0.00161616161616168*G0_0_1_2_2_2 - 0.00161616161616164*G0_1_0_0_0_0 - 0.00102613435946771*G0_1_0_0_0_1 - 0.000179573512906842*G0_1_0_0_0_2 - 0.00102613435946771*G0_1_0_0_1_0 + 0.0109026775693441*G0_1_0_0_1_1 - 0.000179573512906841*G0_1_0_0_2_0 + 0.000179573512906858*G0_1_0_0_2_2 - 0.00102613435946771*G0_1_0_1_0_0 + 0.0109026775693441*G0_1_0_1_0_1 + 0.0109026775693441*G0_1_0_1_1_0 - 0.0109026775693442*G0_1_0_1_1_2 - 0.0109026775693442*G0_1_0_1_2_1 + 0.0010261343594677*G0_1_0_1_2_2 - 0.000179573512906842*G0_1_0_2_0_0 + 0.000179573512906858*G0_1_0_2_0_2 - 0.0109026775693442*G0_1_0_2_1_1 + 0.0010261343594677*G0_1_0_2_1_2 + 0.000179573512906858*G0_1_0_2_2_0 + 0.00102613435946769*G0_1_0_2_2_1 + 0.00161616161616168*G0_1_0_2_2_2;
    A[209] = A[223] + 0.0295526695526699*G0_0_1_0_0_0 + 0.0394035594035595*G0_0_1_0_0_1 + 0.0394035594035594*G0_0_1_0_0_2 + 0.0394035594035595*G0_0_1_0_1_0 + 0.0123136123136125*G0_0_1_0_1_1 + 0.0295526695526695*G0_0_1_0_1_2 + 0.0394035594035594*G0_0_1_0_2_0 + 0.0295526695526695*G0_0_1_0_2_1 + 0.0123136123136125*G0_0_1_0_2_2 + 0.0394035594035595*G0_0_1_1_0_0 + 0.0123136123136125*G0_0_1_1_0_1 + 0.0295526695526695*G0_0_1_1_0_2 + 0.0123136123136125*G0_0_1_1_1_0 - 0.132987012987012*G0_0_1_1_1_1 - 0.0418662818662819*G0_0_1_1_1_2 + 0.0295526695526695*G0_0_1_1_2_0 - 0.0418662818662819*G0_0_1_1_2_1 - 0.0418662818662818*G0_0_1_1_2_2 + 0.0394035594035594*G0_0_1_2_0_0 + 0.0295526695526695*G0_0_1_2_0_1 + 0.0123136123136125*G0_0_1_2_0_2 + 0.0295526695526695*G0_0_1_2_1_0 - 0.0418662818662819*G0_0_1_2_1_1 - 0.0418662818662818*G0_0_1_2_1_2 + 0.0123136123136125*G0_0_1_2_2_0 - 0.0418662818662818*G0_0_1_2_2_1 - 0.132987012987012*G0_0_1_2_2_2 - 0.0295526695526699*G0_1_0_0_0_0 - 0.0394035594035595*G0_1_0_0_0_1 - 0.0394035594035594*G0_1_0_0_0_2 - 0.0394035594035595*G0_1_0_0_1_0 - 0.0123136123136125*G0_1_0_0_1_1 - 0.0295526695526695*G0_1_0_0_1_2 - 0.0394035594035594*G0_1_0_0_2_0 - 0.0295526695526695*G0_1_0_0_2_1 - 0.0123136123136125*G0_1_0_0_2_2 - 0.0394035594035595*G0_1_0_1_0_0 - 0.0123136123136125*G0_1_0_1_0_1 - 0.0295526695526695*G0_1_0_1_0_2 - 0.0123136123136125*G0_1_0_1_1_0 + 0.132987012987012*G0_1_0_1_1_1 + 0.0418662818662819*G0_1_0_1_1_2 - 0.0295526695526695*G0_1_0_1_2_0 + 0.0418662818662819*G0_1_0_1_2_1 + 0.0418662818662819*G0_1_0_1_2_2 - 0.0394035594035594*G0_1_0_2_0_0 - 0.0295526695526695*G0_1_0_2_0_1 - 0.0123136123136125*G0_1_0_2_0_2 - 0.0295526695526695*G0_1_0_2_1_0 + 0.0418662818662819*G0_1_0_2_1_1 + 0.0418662818662819*G0_1_0_2_1_2 - 0.0123136123136125*G0_1_0_2_2_0 + 0.0418662818662819*G0_1_0_2_2_1 + 0.132987012987012*G0_1_0_2_2_2;
    A[13] = A[195] + 0.00333493666826994*G0_0_1_0_0_1 - 0.00333493666826999*G0_0_1_0_0_2 + 0.00333493666826994*G0_0_1_0_1_0 - 0.00287317620650953*G0_0_1_0_1_1 + 0.00094917428250761*G0_0_1_0_1_2 - 0.00333493666826999*G0_0_1_0_2_0 + 0.000949174282507611*G0_0_1_0_2_1 + 0.000974827641494327*G0_0_1_0_2_2 + 0.00333493666826994*G0_0_1_1_0_0 - 0.00287317620650953*G0_0_1_1_0_1 + 0.00094917428250761*G0_0_1_1_0_2 - 0.00287317620650953*G0_0_1_1_1_0 - 0.0112361712361712*G0_0_1_1_1_1 + 0.00112874779541442*G0_0_1_1_1_2 + 0.000949174282507611*G0_0_1_1_2_0 + 0.00112874779541443*G0_0_1_1_2_1 + 0.00243706910373575*G0_0_1_1_2_2 - 0.00333493666826999*G0_0_1_2_0_0 + 0.00094917428250761*G0_0_1_2_0_1 + 0.000974827641494328*G0_0_1_2_0_2 + 0.00094917428250761*G0_0_1_2_1_0 + 0.00112874779541443*G0_0_1_2_1_1 + 0.00243706910373575*G0_0_1_2_1_2 + 0.000974827641494326*G0_0_1_2_2_0 + 0.00243706910373575*G0_0_1_2_2_1 + 0.000538720538720573*G0_0_1_2_2_2 - 0.00333493666826994*G0_1_0_0_0_1 + 0.00333493666826999*G0_1_0_0_0_2 - 0.00333493666826994*G0_1_0_0_1_0 + 0.00287317620650953*G0_1_0_0_1_1 - 0.00094917428250761*G0_1_0_0_1_2 + 0.00333493666826999*G0_1_0_0_2_0 - 0.000949174282507611*G0_1_0_0_2_1 - 0.000974827641494328*G0_1_0_0_2_2 - 0.00333493666826994*G0_1_0_1_0_0 + 0.00287317620650953*G0_1_0_1_0_1 - 0.000949174282507611*G0_1_0_1_0_2 + 0.00287317620650953*G0_1_0_1_1_0 + 0.0112361712361712*G0_1_0_1_1_1 - 0.00112874779541442*G0_1_0_1_1_2 - 0.000949174282507611*G0_1_0_1_2_0 - 0.00112874779541443*G0_1_0_1_2_1 - 0.00243706910373575*G0_1_0_1_2_2 + 0.00333493666826999*G0_1_0_2_0_0 - 0.00094917428250761*G0_1_0_2_0_1 - 0.000974827641494329*G0_1_0_2_0_2 - 0.00094917428250761*G0_1_0_2_1_0 - 0.00112874779541443*G0_1_0_2_1_1 - 0.00243706910373575*G0_1_0_2_1_2 - 0.000974827641494328*G0_1_0_2_2_0 - 0.00243706910373575*G0_1_0_2_2_1 - 0.000538720538720575*G0_1_0_2_2_2;
    A[53] = A[123] + 0.00400192400192409*G0_0_1_0_0_0 + 0.000684089572978452*G0_0_1_0_0_1 + 0.00885895997007106*G0_0_1_0_0_2 + 0.000684089572978452*G0_0_1_0_1_0 - 0.000684089572978469*G0_0_1_0_1_2 + 0.00885895997007106*G0_0_1_0_2_0 - 0.000684089572978468*G0_0_1_0_2_1 + 0.0121425899203676*G0_0_1_0_2_2 + 0.000684089572978452*G0_0_1_1_0_0 - 0.000684089572978468*G0_0_1_1_0_2 + 0.00933782267115545*G0_0_1_1_1_1 - 0.0003078403078404*G0_0_1_1_1_2 - 0.000684089572978469*G0_0_1_1_2_0 - 0.000307840307840401*G0_0_1_1_2_1 + 0.00324942547164759*G0_0_1_1_2_2 + 0.00885895997007106*G0_0_1_2_0_0 - 0.000684089572978469*G0_0_1_2_0_1 + 0.0121425899203676*G0_0_1_2_0_2 - 0.000684089572978469*G0_0_1_2_1_0 - 0.0003078403078404*G0_0_1_2_1_1 + 0.00324942547164759*G0_0_1_2_1_2 + 0.0121425899203676*G0_0_1_2_2_0 + 0.00324942547164759*G0_0_1_2_2_1 - 0.083116883116883*G0_0_1_2_2_2 - 0.0040019240019241*G0_1_0_0_0_0 - 0.000684089572978452*G0_1_0_0_0_1 - 0.00885895997007107*G0_1_0_0_0_2 - 0.000684089572978452*G0_1_0_0_1_0 + 0.000684089572978468*G0_1_0_0_1_2 - 0.00885895997007106*G0_1_0_0_2_0 + 0.000684089572978468*G0_1_0_0_2_1 - 0.0121425899203676*G0_1_0_0_2_2 - 0.000684089572978452*G0_1_0_1_0_0 + 0.000684089572978469*G0_1_0_1_0_2 - 0.00933782267115545*G0_1_0_1_1_1 + 0.000307840307840401*G0_1_0_1_1_2 + 0.000684089572978468*G0_1_0_1_2_0 + 0.000307840307840401*G0_1_0_1_2_1 - 0.00324942547164759*G0_1_0_1_2_2 - 0.00885895997007106*G0_1_0_2_0_0 + 0.000684089572978469*G0_1_0_2_0_1 - 0.0121425899203676*G0_1_0_2_0_2 + 0.000684089572978469*G0_1_0_2_1_0 + 0.000307840307840401*G0_1_0_2_1_1 - 0.00324942547164759*G0_1_0_2_1_2 - 0.0121425899203676*G0_1_0_2_2_0 - 0.00324942547164759*G0_1_0_2_2_1 + 0.083116883116883*G0_1_0_2_2_2;
    A[51] = -A[53] - 0.0388904922238252*G0_0_0_0_0_0 + 0.00078670300892525*G0_0_0_0_0_1 - 0.0205910961466515*G0_0_0_0_0_2 + 0.00078670300892525*G0_0_0_0_1_0 - 0.000239431350542434*G0_0_0_0_1_1 - 0.000547271658382762*G0_0_0_0_1_2 - 0.0205910961466515*G0_0_0_0_2_0 - 0.000547271658382763*G0_0_0_0_2_1 - 0.0330415263748594*G0_0_0_0_2_2 + 0.00078670300892525*G0_0_0_1_0_0 - 0.000239431350542434*G0_0_0_1_0_1 - 0.000547271658382762*G0_0_0_1_0_2 - 0.000239431350542434*G0_0_0_1_1_0 - 0.0481257014590347*G0_0_0_1_1_1 - 0.0103297525519748*G0_0_0_1_1_2 - 0.000547271658382762*G0_0_0_1_2_0 - 0.0103297525519748*G0_0_0_1_2_1 + 0.00184704184704183*G0_0_0_1_2_2 - 0.0205910961466515*G0_0_0_2_0_0 - 0.000547271658382763*G0_0_0_2_0_1 - 0.0330415263748594*G0_0_0_2_0_2 - 0.000547271658382763*G0_0_0_2_1_0 - 0.0103297525519748*G0_0_0_2_1_1 + 0.00184704184704183*G0_0_0_2_1_2 - 0.0330415263748594*G0_0_0_2_2_0 + 0.00184704184704183*G0_0_0_2_2_1 - 0.266794933461598*G0_0_0_2_2_2 - 0.00584896584896542*G0_0_1_0_0_0 + 0.00133397466730802*G0_0_1_0_0_1 + 0.00133397466730802*G0_0_1_0_1_0 - 0.001333974667308*G0_0_1_0_1_2 - 0.001333974667308*G0_0_1_0_2_1 + 0.00584896584896588*G0_0_1_0_2_2 + 0.00133397466730802*G0_0_1_1_0_0 - 0.001333974667308*G0_0_1_1_0_2 - 0.0367356100689433*G0_0_1_1_1_1 - 0.0129292929292929*G0_0_1_1_1_2 - 0.001333974667308*G0_0_1_1_2_0 - 0.0129292929292929*G0_0_1_1_2_1 - 0.0037966971300305*G0_0_1_1_2_2 - 0.001333974667308*G0_0_1_2_0_1 + 0.00584896584896587*G0_0_1_2_0_2 - 0.001333974667308*G0_0_1_2_1_0 - 0.0129292929292929*G0_0_1_2_1_1 - 0.0037966971300305*G0_0_1_2_1_2 + 0.00584896584896588*G0_0_1_2_2_0 - 0.0037966971300305*G0_0_1_2_2_1 - 0.123957030623696*G0_0_1_2_2_2 - 0.0191887125220458*G0_1_0_0_0_0 - 0.00239431350542457*G0_1_0_0_0_1 - 0.0055069210624766*G0_1_0_0_0_2 - 0.00239431350542457*G0_1_0_0_1_0 - 0.00304419859975403*G0_1_0_0_1_1 - 0.00133397466730799*G0_1_0_0_1_2 - 0.0055069210624766*G0_1_0_0_2_0 - 0.00133397466730799*G0_1_0_0_2_1 - 0.00444658222435995*G0_1_0_0_2_2 - 0.00239431350542457*G0_1_0_1_0_0 - 0.00304419859975403*G0_1_0_1_0_1 - 0.00133397466730799*G0_1_0_1_0_2 - 0.00304419859975403*G0_1_0_1_1_0 - 0.0554112554112546*G0_1_0_1_1_1 - 0.00926941371385812*G0_1_0_1_1_2 - 0.00133397466730799*G0_1_0_1_2_0 - 0.00926941371385812*G0_1_0_1_2_1 - 0.00519908075463623*G0_1_0_1_2_2 - 0.0055069210624766*G0_1_0_2_0_0 - 0.00133397466730799*G0_1_0_2_0_1 - 0.00444658222435995*G0_1_0_2_0_2 - 0.00133397466730799*G0_1_0_2_1_0 - 0.00926941371385812*G0_1_0_2_1_1 - 0.00519908075463623*G0_1_0_2_1_2 - 0.00444658222435995*G0_1_0_2_2_0 - 0.00519908075463623*G0_1_0_2_2_1 - 0.0309892576559234*G0_1_0_2_2_2 + 0.0118005451338786*G0_1_1_0_0_0 + 0.00280476724921172*G0_1_1_0_0_1 - 0.0010603388381166*G0_1_1_0_0_2 + 0.00280476724921172*G0_1_1_0_1_0 + 0.00622521511410405*G0_1_1_0_1_1 - 0.0010603388381166*G0_1_1_0_2_0 + 0.00106033883811664*G0_1_1_0_2_2 + 0.00280476724921172*G0_1_1_1_0_0 + 0.00622521511410405*G0_1_1_1_0_1 + 0.00622521511410405*G0_1_1_1_1_0 - 0.00622521511410396*G0_1_1_1_1_2 - 0.00622521511410396*G0_1_1_1_2_1 - 0.00280476724921164*G0_1_1_1_2_2 - 0.0010603388381166*G0_1_1_2_0_0 + 0.00106033883811664*G0_1_1_2_0_2 - 0.00622521511410396*G0_1_1_2_1_1 - 0.00280476724921164*G0_1_1_2_1_2 + 0.00106033883811664*G0_1_1_2_2_0 - 0.00280476724921164*G0_1_1_2_2_1 - 0.0118005451338778*G0_1_1_2_2_2;
    A[30] = -A[31] + 0.0213339746673079*G0_1_0_0_0_0 + 0.00161509272620383*G0_1_0_0_0_1 - 0.000233018010795783*G0_1_0_0_0_2 + 0.00161509272620383*G0_1_0_0_1_0 - 0.00161509272620384*G0_1_0_0_1_1 - 0.000233018010795783*G0_1_0_0_2_0 - 0.00184811073699961*G0_1_0_0_2_2 + 0.00161509272620383*G0_1_0_1_0_0 - 0.00161509272620384*G0_1_0_1_0_1 - 0.00161509272620384*G0_1_0_1_1_0 - 0.021333974667308*G0_1_0_1_1_1 + 0.000233018010795783*G0_1_0_1_1_2 + 0.000233018010795783*G0_1_0_1_2_1 + 0.00184811073699961*G0_1_0_1_2_2 - 0.000233018010795783*G0_1_0_2_0_0 - 0.00184811073699961*G0_1_0_2_0_2 + 0.000233018010795783*G0_1_0_2_1_1 + 0.00184811073699961*G0_1_0_2_1_2 - 0.00184811073699961*G0_1_0_2_2_0 + 0.00184811073699961*G0_1_0_2_2_1 + 0.0212361712361712*G0_1_1_0_0_0 + 0.00190208967986745*G0_1_1_0_0_1 + 0.00190208967986745*G0_1_1_0_1_0 + 0.000286996953663616*G0_1_1_0_1_1 + 0.000130137352359575*G0_1_1_0_1_2 + 0.000130137352359575*G0_1_1_0_2_1 + 0.00190208967986745*G0_1_1_1_0_0 + 0.000286996953663616*G0_1_1_1_0_1 + 0.000130137352359575*G0_1_1_1_0_2 + 0.000286996953663616*G0_1_1_1_1_0 + 0.000286996953663621*G0_1_1_1_1_2 + 0.000130137352359575*G0_1_1_1_2_0 + 0.000286996953663621*G0_1_1_1_2_1 + 0.00190208967986746*G0_1_1_1_2_2 + 0.000130137352359575*G0_1_1_2_0_1 + 0.000130137352359575*G0_1_1_2_1_0 + 0.000286996953663621*G0_1_1_2_1_1 + 0.00190208967986746*G0_1_1_2_1_2 + 0.00190208967986746*G0_1_1_2_2_1 + 0.0212361712361713*G0_1_1_2_2_2;
    A[23] = A[21] - 0.028167388167388*G0_0_0_0_0_0 + 0.00142803698359253*G0_0_0_0_0_1 - 0.00712308267863817*G0_0_0_0_0_2 + 0.00142803698359253*G0_0_0_0_1_0 + 0.000487413820747155*G0_0_0_0_1_1 - 0.00712308267863817*G0_0_0_0_2_0 + 0.00226604671049116*G0_0_0_0_2_2 + 0.00142803698359253*G0_0_0_1_0_0 + 0.000487413820747155*G0_0_0_1_0_1 + 0.000487413820747155*G0_0_0_1_1_0 - 0.000487413820747139*G0_0_0_1_1_2 - 0.000487413820747139*G0_0_0_1_2_1 - 0.00154775265886376*G0_0_0_1_2_2 - 0.00712308267863817*G0_0_0_2_0_0 + 0.00226604671049116*G0_0_0_2_0_2 - 0.000487413820747139*G0_0_0_2_1_1 - 0.00154775265886376*G0_0_0_2_1_2 + 0.00226604671049116*G0_0_0_2_2_0 - 0.00154775265886376*G0_0_0_2_2_1 + 0.0427384960718292*G0_0_0_2_2_2 + 0.0145711079044413*G0_0_1_0_0_0 - 0.00011971567527122*G0_0_1_0_0_1 - 0.00485703596814705*G0_0_1_0_0_2 - 0.00011971567527122*G0_0_1_0_1_0 + 0.000119715675271233*G0_0_1_0_1_2 - 0.00485703596814705*G0_0_1_0_2_0 + 0.000119715675271233*G0_0_1_0_2_1 - 0.00485703596814706*G0_0_1_0_2_2 - 0.00011971567527122*G0_0_1_1_0_0 + 0.000119715675271233*G0_0_1_1_0_2 + 0.000119715675271233*G0_0_1_1_2_0 - 0.00011971567527123*G0_0_1_1_2_2 - 0.00485703596814705*G0_0_1_2_0_0 + 0.000119715675271233*G0_0_1_2_0_1 - 0.00485703596814706*G0_0_1_2_0_2 + 0.000119715675271233*G0_0_1_2_1_0 - 0.00011971567527123*G0_0_1_2_1_2 - 0.00485703596814706*G0_0_1_2_2_0 - 0.00011971567527123*G0_0_1_2_2_1 + 0.0145711079044411*G0_0_1_2_2_2;
    A[20] = -A[23] - 0.00187269520602862*G0_0_1_0_0_0 + 0.0016418149751483*G0_0_1_0_0_1 - 0.00174442841109509*G0_0_1_0_0_2 + 0.0016418149751483*G0_0_1_0_1_0 + 0.010782961894073*G0_0_1_0_1_1 + 0.00126129015017904*G0_0_1_0_1_2 - 0.00174442841109509*G0_0_1_0_2_0 + 0.00126129015017904*G0_0_1_0_2_1 - 0.00135107690663247*G0_0_1_0_2_2 + 0.0016418149751483*G0_0_1_1_0_0 + 0.010782961894073*G0_0_1_1_0_1 + 0.00126129015017904*G0_0_1_1_0_2 + 0.010782961894073*G0_0_1_1_1_0 + 0.117748917748918*G0_0_1_1_1_1 + 0.00268505157394047*G0_0_1_1_1_2 + 0.00126129015017904*G0_0_1_1_2_0 + 0.00268505157394047*G0_0_1_1_2_1 + 0.00494254716476936*G0_0_1_1_2_2 - 0.00174442841109509*G0_0_1_2_0_0 + 0.00126129015017904*G0_0_1_2_0_1 - 0.00135107690663247*G0_0_1_2_0_2 + 0.00126129015017904*G0_0_1_2_1_0 + 0.00268505157394047*G0_0_1_2_1_1 + 0.00494254716476936*G0_0_1_2_1_2 - 0.00135107690663247*G0_0_1_2_2_0 + 0.00494254716476936*G0_0_1_2_2_1 + 0.0288600288600286*G0_0_1_2_2_2;
    A[5] = -A[20] - 0.0108000641333974*G0_0_0_0_0_0 - 0.000607129496018382*G0_0_0_0_0_1 - 0.00326652771097213*G0_0_0_0_0_2 - 0.000607129496018382*G0_0_0_0_1_0 + 0.00060712949601837*G0_0_0_0_1_1 - 0.00326652771097213*G0_0_0_0_2_0 - 0.00745657634546519*G0_0_0_0_2_2 - 0.000607129496018382*G0_0_0_1_0_0 + 0.00060712949601837*G0_0_0_1_0_1 + 0.00060712949601837*G0_0_0_1_1_0 + 0.0108000641333973*G0_0_0_1_1_1 + 0.00326652771097213*G0_0_0_1_1_2 + 0.00326652771097213*G0_0_0_1_2_1 + 0.00745657634546518*G0_0_0_1_2_2 - 0.00326652771097213*G0_0_0_2_0_0 - 0.00745657634546519*G0_0_0_2_0_2 + 0.00326652771097213*G0_0_0_2_1_1 + 0.00745657634546518*G0_0_0_2_1_2 - 0.00745657634546519*G0_0_0_2_2_0 + 0.00745657634546518*G0_0_0_2_2_1 - 0.0097482764149429*G0_0_1_0_0_0 - 0.000974827641494304*G0_0_1_0_0_2 + 0.00974827641494306*G0_0_1_0_1_1 + 0.000974827641494305*G0_0_1_0_1_2 - 0.000974827641494304*G0_0_1_0_2_0 + 0.000974827641494305*G0_0_1_0_2_1 + 0.00974827641494306*G0_0_1_1_0_1 + 0.000974827641494305*G0_0_1_1_0_2 + 0.00974827641494306*G0_0_1_1_1_0 + 0.120673400673401*G0_0_1_1_1_1 + 0.00672118005451335*G0_0_1_1_1_2 + 0.000974827641494305*G0_0_1_1_2_0 + 0.00672118005451335*G0_0_1_1_2_1 + 0.013750200416867*G0_0_1_1_2_2 - 0.000974827641494304*G0_0_1_2_0_0 + 0.000974827641494305*G0_0_1_2_0_1 + 0.000974827641494305*G0_0_1_2_1_0 + 0.00672118005451335*G0_0_1_2_1_1 + 0.013750200416867*G0_0_1_2_1_2 + 0.013750200416867*G0_0_1_2_2_1 + 0.0409940676607339*G0_0_1_2_2_2 - 0.0100689434022766*G0_1_0_0_0_0 - 0.000714018491796262*G0_1_0_0_0_1 - 0.00191545080433968*G0_1_0_0_0_2 - 0.000714018491796262*G0_1_0_0_1_0 - 0.00010688899577788*G0_1_0_0_1_1 - 0.000166746833413499*G0_1_0_0_1_2 - 0.00191545080433968*G0_1_0_0_2_0 - 0.000166746833413499*G0_1_0_0_2_1 - 0.0018684196461974*G0_1_0_0_2_2 - 0.000714018491796262*G0_1_0_1_0_0 - 0.000106888995777881*G0_1_0_1_0_1 - 0.000166746833413499*G0_1_0_1_0_2 - 0.00010688899577788*G0_1_0_1_1_0 + 0.000731120731120737*G0_1_0_1_1_1 + 0.00135107690663246*G0_1_0_1_1_2 - 0.000166746833413499*G0_1_0_1_2_0 + 0.00135107690663246*G0_1_0_1_2_1 + 0.00558815669926779*G0_1_0_1_2_2 - 0.00191545080433968*G0_1_0_2_0_0 - 0.000166746833413499*G0_1_0_2_0_1 - 0.0018684196461974*G0_1_0_2_0_2 - 0.000166746833413499*G0_1_0_2_1_0 + 0.00135107690663246*G0_1_0_2_1_1 + 0.0055881566992678*G0_1_0_2_1_2 - 0.0018684196461974*G0_1_0_2_2_0 + 0.0055881566992678*G0_1_0_2_2_1 + 0.0456629789963125*G0_1_0_2_2_2 - 0.0100689434022765*G0_1_1_0_0_0 - 0.00142803698359252*G0_1_1_0_0_1 - 0.00120143231254341*G0_1_1_0_0_2 - 0.00142803698359252*G0_1_1_0_1_0 - 0.000320666987333628*G0_1_1_0_1_1 - 0.000226604671049116*G0_1_1_0_1_2 - 0.00120143231254341*G0_1_1_0_2_0 - 0.000226604671049116*G0_1_1_0_2_1 - 0.00153492597937042*G0_1_1_0_2_2 - 0.00142803698359252*G0_1_1_1_0_0 - 0.000320666987333629*G0_1_1_1_0_1 - 0.000226604671049116*G0_1_1_1_0_2 - 0.000320666987333628*G0_1_1_1_1_0 + 0.00292448292448304*G0_1_1_1_1_1 + 0.00332210998877663*G0_1_1_1_1_2 - 0.000226604671049116*G0_1_1_1_2_0 + 0.00332210998877663*G0_1_1_1_2_1 + 0.00847415958527062*G0_1_1_1_2_2 - 0.00120143231254342*G0_1_1_2_0_0 - 0.000226604671049116*G0_1_1_2_0_1 - 0.00153492597937042*G0_1_1_2_0_2 - 0.000226604671049116*G0_1_1_2_1_0 + 0.00332210998877663*G0_1_1_2_1_1 + 0.00847415958527062*G0_1_1_2_1_2 - 0.00153492597937042*G0_1_1_2_2_0 + 0.00847415958527062*G0_1_1_2_2_1 + 0.0288985088985087*G0_1_1_2_2_2;
    A[8] = -A[5] - 0.117748917748917*G0_0_1_0_0_0 - 0.010782961894073*G0_0_1_0_0_1 - 0.00268505157394045*G0_0_1_0_0_2 - 0.010782961894073*G0_0_1_0_1_0 - 0.0016418149751483*G0_0_1_0_1_1 - 0.00126129015017904*G0_0_1_0_1_2 - 0.00268505157394045*G0_0_1_0_2_0 - 0.00126129015017904*G0_0_1_0_2_1 - 0.00494254716476937*G0_0_1_0_2_2 - 0.010782961894073*G0_0_1_1_0_0 - 0.0016418149751483*G0_0_1_1_0_1 - 0.00126129015017904*G0_0_1_1_0_2 - 0.0016418149751483*G0_0_1_1_1_0 + 0.0018726952060286*G0_0_1_1_1_1 + 0.00174442841109505*G0_0_1_1_1_2 - 0.00126129015017904*G0_0_1_1_2_0 + 0.00174442841109505*G0_0_1_1_2_1 + 0.00135107690663241*G0_0_1_1_2_2 - 0.00268505157394045*G0_0_1_2_0_0 - 0.00126129015017904*G0_0_1_2_0_1 - 0.00494254716476937*G0_0_1_2_0_2 - 0.00126129015017904*G0_0_1_2_1_0 + 0.00174442841109505*G0_0_1_2_1_1 + 0.00135107690663241*G0_0_1_2_1_2 - 0.00494254716476937*G0_0_1_2_2_0 + 0.00135107690663241*G0_0_1_2_2_1 - 0.0288600288600288*G0_0_1_2_2_2 - 0.117748917748917*G0_1_1_0_0_0 - 0.010782961894073*G0_1_1_0_0_1 - 0.00268505157394045*G0_1_1_0_0_2 - 0.010782961894073*G0_1_1_0_1_0 - 0.00164181497514829*G0_1_1_0_1_1 - 0.00126129015017904*G0_1_1_0_1_2 - 0.00268505157394045*G0_1_1_0_2_0 - 0.00126129015017904*G0_1_1_0_2_1 - 0.00494254716476939*G0_1_1_0_2_2 - 0.010782961894073*G0_1_1_1_0_0 - 0.00164181497514829*G0_1_1_1_0_1 - 0.00126129015017904*G0_1_1_1_0_2 - 0.00164181497514829*G0_1_1_1_1_0 + 0.00187269520602862*G0_1_1_1_1_1 + 0.00174442841109505*G0_1_1_1_1_2 - 0.00126129015017904*G0_1_1_1_2_0 + 0.00174442841109505*G0_1_1_1_2_1 + 0.0013510769066324*G0_1_1_1_2_2 - 0.00268505157394045*G0_1_1_2_0_0 - 0.00126129015017904*G0_1_1_2_0_1 - 0.00494254716476939*G0_1_1_2_0_2 - 0.00126129015017904*G0_1_1_2_1_0 + 0.00174442841109505*G0_1_1_2_1_1 + 0.0013510769066324*G0_1_1_2_1_2 - 0.00494254716476939*G0_1_1_2_2_0 + 0.0013510769066324*G0_1_1_2_2_1 - 0.028860028860029*G0_1_1_2_2_2;
    A[45] = A[5] - 0.000487413820747162*G0_0_0_0_0_1 + 0.00048741382074715*G0_0_0_0_0_2 - 0.000487413820747162*G0_0_0_0_1_0 - 0.00142803698359254*G0_0_0_0_1_1 + 0.000487413820747151*G0_0_0_0_2_0 + 0.00154775265886377*G0_0_0_0_2_2 - 0.000487413820747162*G0_0_0_1_0_0 - 0.00142803698359254*G0_0_0_1_0_1 - 0.00142803698359254*G0_0_0_1_1_0 + 0.028167388167388*G0_0_0_1_1_1 + 0.00712308267863818*G0_0_0_1_1_2 + 0.00712308267863818*G0_0_0_1_2_1 - 0.00226604671049113*G0_0_0_1_2_2 + 0.000487413820747151*G0_0_0_2_0_0 + 0.00154775265886377*G0_0_0_2_0_2 + 0.00712308267863818*G0_0_0_2_1_1 - 0.00226604671049113*G0_0_0_2_1_2 + 0.00154775265886377*G0_0_0_2_2_0 - 0.00226604671049113*G0_0_0_2_2_1 - 0.0427384960718291*G0_0_0_2_2_2 + 0.000226604671049103*G0_0_1_0_0_1 - 0.000226604671049115*G0_0_1_0_0_2 + 0.000226604671049103*G0_0_1_0_1_0 - 0.00121425899203677*G0_0_1_0_1_1 - 0.000226604671049115*G0_0_1_0_2_0 + 0.00121425899203678*G0_0_1_0_2_2 + 0.000226604671049103*G0_0_1_1_0_0 - 0.00121425899203677*G0_0_1_1_0_1 - 0.00121425899203677*G0_0_1_1_1_0 + 0.0259740259740256*G0_0_1_1_1_1 + 0.00515204959649399*G0_0_1_1_1_2 + 0.00515204959649399*G0_0_1_1_2_1 - 0.00515204959649398*G0_0_1_1_2_2 - 0.000226604671049115*G0_0_1_2_0_0 + 0.00121425899203678*G0_0_1_2_0_2 + 0.00515204959649399*G0_0_1_2_1_1 - 0.00515204959649398*G0_0_1_2_1_2 + 0.00121425899203678*G0_0_1_2_2_0 - 0.00515204959649398*G0_0_1_2_2_1 - 0.0259740259740256*G0_0_1_2_2_2 - 0.00120143231254343*G0_1_0_0_0_1 + 0.00120143231254341*G0_1_0_0_0_2 - 0.00120143231254343*G0_1_0_0_1_0 - 0.00176153065041952*G0_1_0_0_1_1 + 0.00120143231254341*G0_1_0_0_2_0 + 0.00176153065041952*G0_1_0_0_2_2 - 0.00120143231254343*G0_1_0_1_0_0 - 0.00176153065041953*G0_1_0_1_0_1 - 0.00176153065041953*G0_1_0_1_1_0 + 0.0449318582651915*G0_1_0_1_1_1 + 0.00423707979263532*G0_1_0_1_1_2 + 0.00423707979263532*G0_1_0_1_2_1 - 0.00423707979263534*G0_1_0_1_2_2 + 0.00120143231254341*G0_1_0_2_0_0 + 0.00176153065041952*G0_1_0_2_0_2 + 0.00423707979263532*G0_1_0_2_1_1 - 0.00423707979263534*G0_1_0_2_1_2 + 0.00176153065041952*G0_1_0_2_2_0 - 0.00423707979263534*G0_1_0_2_2_1 - 0.0449318582651916*G0_1_0_2_2_2 - 0.000487413820747166*G0_1_1_0_0_1 + 0.000487413820747144*G0_1_1_0_0_2 - 0.000487413820747165*G0_1_1_0_1_0 - 0.00154775265886376*G0_1_1_0_1_1 + 0.000487413820747144*G0_1_1_0_2_0 + 0.00142803698359254*G0_1_1_0_2_2 - 0.000487413820747165*G0_1_1_1_0_0 - 0.00154775265886376*G0_1_1_1_0_1 - 0.00154775265886376*G0_1_1_1_1_0 + 0.0427384960718291*G0_1_1_1_1_1 + 0.00226604671049114*G0_1_1_1_1_2 + 0.00226604671049114*G0_1_1_1_2_1 - 0.00712308267863817*G0_1_1_1_2_2 + 0.000487413820747144*G0_1_1_2_0_0 + 0.00142803698359254*G0_1_1_2_0_2 + 0.00226604671049114*G0_1_1_2_1_1 - 0.00712308267863817*G0_1_1_2_1_2 + 0.00142803698359254*G0_1_1_2_2_0 - 0.00712308267863817*G0_1_1_2_2_1 - 0.028167388167388*G0_1_1_2_2_2;
    A[165] = -A[45] - 0.117748917748918*G0_0_0_0_0_0 - 0.00268505157394048*G0_0_0_0_0_1 - 0.0107829618940729*G0_0_0_0_0_2 - 0.00268505157394048*G0_0_0_0_1_0 - 0.00494254716476937*G0_0_0_0_1_1 - 0.00126129015017904*G0_0_0_0_1_2 - 0.0107829618940729*G0_0_0_0_2_0 - 0.00126129015017904*G0_0_0_0_2_1 - 0.00164181497514829*G0_0_0_0_2_2 - 0.00268505157394048*G0_0_0_1_0_0 - 0.00494254716476937*G0_0_0_1_0_1 - 0.00126129015017904*G0_0_0_1_0_2 - 0.00494254716476937*G0_0_0_1_1_0 - 0.0288600288600288*G0_0_0_1_1_1 + 0.00135107690663245*G0_0_0_1_1_2 - 0.00126129015017904*G0_0_0_1_2_0 + 0.00135107690663245*G0_0_0_1_2_1 + 0.00174442841109508*G0_0_0_1_2_2 - 0.0107829618940729*G0_0_0_2_0_0 - 0.00126129015017904*G0_0_0_2_0_1 - 0.00164181497514829*G0_0_0_2_0_2 - 0.00126129015017904*G0_0_0_2_1_0 + 0.00135107690663245*G0_0_0_2_1_1 + 0.00174442841109508*G0_0_0_2_1_2 - 0.00164181497514828*G0_0_0_2_2_0 + 0.00174442841109508*G0_0_0_2_2_1 + 0.00187269520602859*G0_0_0_2_2_2 - 0.117748917748918*G0_0_1_0_0_0 - 0.00268505157394047*G0_0_1_0_0_1 - 0.0107829618940729*G0_0_1_0_0_2 - 0.00268505157394047*G0_0_1_0_1_0 - 0.00494254716476936*G0_0_1_0_1_1 - 0.00126129015017903*G0_0_1_0_1_2 - 0.0107829618940729*G0_0_1_0_2_0 - 0.00126129015017903*G0_0_1_0_2_1 - 0.00164181497514828*G0_0_1_0_2_2 - 0.00268505157394047*G0_0_1_1_0_0 - 0.00494254716476936*G0_0_1_1_0_1 - 0.00126129015017903*G0_0_1_1_0_2 - 0.00494254716476936*G0_0_1_1_1_0 - 0.0288600288600288*G0_0_1_1_1_1 + 0.00135107690663244*G0_0_1_1_1_2 - 0.00126129015017903*G0_0_1_1_2_0 + 0.00135107690663244*G0_0_1_1_2_1 + 0.00174442841109507*G0_0_1_1_2_2 - 0.0107829618940729*G0_0_1_2_0_0 - 0.00126129015017903*G0_0_1_2_0_1 - 0.00164181497514828*G0_0_1_2_0_2 - 0.00126129015017903*G0_0_1_2_1_0 + 0.00135107690663244*G0_0_1_2_1_1 + 0.00174442841109507*G0_0_1_2_1_2 - 0.00164181497514828*G0_0_1_2_2_0 + 0.00174442841109507*G0_0_1_2_2_1 + 0.00187269520602864*G0_0_1_2_2_2;
    A[75] = A[5] + 0.000714018491796264*G0_0_1_0_0_1 - 0.000714018491796267*G0_0_1_0_0_2 + 0.000714018491796264*G0_0_1_0_1_0 + 0.000213777991555767*G0_0_1_0_1_1 - 0.000714018491796267*G0_0_1_0_2_0 - 0.000333493666826981*G0_0_1_0_2_2 + 0.000714018491796264*G0_0_1_1_0_0 + 0.000213777991555767*G0_0_1_1_0_1 + 0.000213777991555768*G0_0_1_1_1_0 - 0.00219336219336224*G0_0_1_1_1_1 - 0.00197103308214417*G0_0_1_1_1_2 - 0.00197103308214417*G0_0_1_1_2_1 - 0.00288600288600283*G0_0_1_1_2_2 - 0.000714018491796267*G0_0_1_2_0_0 - 0.000333493666826982*G0_0_1_2_0_2 - 0.00197103308214417*G0_0_1_2_1_1 - 0.00288600288600283*G0_0_1_2_1_2 - 0.000333493666826982*G0_0_1_2_2_0 - 0.00288600288600283*G0_0_1_2_2_1 + 0.0167644700978037*G0_0_1_2_2_2 - 0.000714018491796265*G0_1_0_0_0_1 + 0.000714018491796267*G0_1_0_0_0_2 - 0.000714018491796265*G0_1_0_0_1_0 - 0.000213777991555768*G0_1_0_0_1_1 + 0.000714018491796267*G0_1_0_0_2_0 + 0.000333493666826982*G0_1_0_0_2_2 - 0.000714018491796264*G0_1_0_1_0_0 - 0.000213777991555767*G0_1_0_1_0_1 - 0.000213777991555768*G0_1_0_1_1_0 + 0.00219336219336224*G0_1_0_1_1_1 + 0.00197103308214417*G0_1_0_1_1_2 + 0.00197103308214417*G0_1_0_1_2_1 + 0.00288600288600283*G0_1_0_1_2_2 + 0.000714018491796267*G0_1_0_2_0_0 + 0.000333493666826982*G0_1_0_2_0_2 + 0.00197103308214417*G0_1_0_2_1_1 + 0.00288600288600283*G0_1_0_2_1_2 + 0.000333493666826982*G0_1_0_2_2_0 + 0.00288600288600283*G0_1_0_2_2_1 - 0.0167644700978037*G0_1_0_2_2_2;
    A[120] = -A[75] - 0.117748917748917*G0_1_0_0_0_0 - 0.010782961894073*G0_1_0_0_0_1 - 0.00268505157394045*G0_1_0_0_0_2 - 0.010782961894073*G0_1_0_0_1_0 - 0.0016418149751483*G0_1_0_0_1_1 - 0.00126129015017904*G0_1_0_0_1_2 - 0.00268505157394045*G0_1_0_0_2_0 - 0.00126129015017904*G0_1_0_0_2_1 - 0.00494254716476937*G0_1_0_0_2_2 - 0.010782961894073*G0_1_0_1_0_0 - 0.0016418149751483*G0_1_0_1_0_1 - 0.00126129015017904*G0_1_0_1_0_2 - 0.0016418149751483*G0_1_0_1_1_0 + 0.0018726952060286*G0_1_0_1_1_1 + 0.00174442841109505*G0_1_0_1_1_2 - 0.00126129015017904*G0_1_0_1_2_0 + 0.00174442841109505*G0_1_0_1_2_1 + 0.00135107690663241*G0_1_0_1_2_2 - 0.00268505157394045*G0_1_0_2_0_0 - 0.00126129015017904*G0_1_0_2_0_1 - 0.00494254716476937*G0_1_0_2_0_2 - 0.00126129015017904*G0_1_0_2_1_0 + 0.00174442841109505*G0_1_0_2_1_1 + 0.00135107690663241*G0_1_0_2_1_2 - 0.00494254716476937*G0_1_0_2_2_0 + 0.00135107690663242*G0_1_0_2_2_1 - 0.0288600288600288*G0_1_0_2_2_2 - 0.117748917748917*G0_1_1_0_0_0 - 0.010782961894073*G0_1_1_0_0_1 - 0.00268505157394045*G0_1_1_0_0_2 - 0.010782961894073*G0_1_1_0_1_0 - 0.00164181497514829*G0_1_1_0_1_1 - 0.00126129015017904*G0_1_1_0_1_2 - 0.00268505157394045*G0_1_1_0_2_0 - 0.00126129015017904*G0_1_1_0_2_1 - 0.00494254716476939*G0_1_1_0_2_2 - 0.010782961894073*G0_1_1_1_0_0 - 0.00164181497514829*G0_1_1_1_0_1 - 0.00126129015017904*G0_1_1_1_0_2 - 0.00164181497514829*G0_1_1_1_1_0 + 0.00187269520602862*G0_1_1_1_1_1 + 0.00174442841109505*G0_1_1_1_1_2 - 0.00126129015017904*G0_1_1_1_2_0 + 0.00174442841109505*G0_1_1_1_2_1 + 0.0013510769066324*G0_1_1_1_2_2 - 0.00268505157394045*G0_1_1_2_0_0 - 0.00126129015017904*G0_1_1_2_0_1 - 0.00494254716476939*G0_1_1_2_0_2 - 0.00126129015017904*G0_1_1_2_1_0 + 0.00174442841109505*G0_1_1_2_1_1 + 0.0013510769066324*G0_1_1_2_1_2 - 0.00494254716476939*G0_1_1_2_2_0 + 0.0013510769066324*G0_1_1_2_2_1 - 0.028860028860029*G0_1_1_2_2_2;
    A[24] = -A[20] - 0.0584896584896583*G0_0_0_0_0_0 - 0.00330073218962107*G0_0_0_0_0_1 - 0.00847415958527065*G0_0_0_0_0_2 - 0.00330073218962107*G0_0_0_0_1_0 - 0.00076960076960079*G0_0_0_0_1_1 - 0.000867938645716422*G0_0_0_0_1_2 - 0.00847415958527065*G0_0_0_0_2_0 - 0.000867938645716422*G0_0_0_0_2_1 - 0.00716583827694935*G0_0_0_0_2_2 - 0.00330073218962107*G0_0_0_1_0_0 - 0.00076960076960079*G0_0_0_1_0_1 - 0.000867938645716421*G0_0_0_1_0_2 - 0.000769600769600787*G0_0_0_1_1_0 - 0.0976110309443641*G0_0_0_1_1_1 - 0.00743947410614075*G0_0_0_1_1_2 - 0.000867938645716421*G0_0_0_1_2_0 - 0.00743947410614075*G0_0_0_1_2_1 + 0.000547271658382759*G0_0_0_1_2_2 - 0.00847415958527065*G0_0_0_2_0_0 - 0.000867938645716422*G0_0_0_2_0_1 - 0.00716583827694935*G0_0_0_2_0_2 - 0.000867938645716422*G0_0_0_2_1_0 - 0.00743947410614075*G0_0_0_2_1_1 + 0.000547271658382759*G0_0_0_2_1_2 - 0.00716583827694935*G0_0_0_2_2_0 + 0.000547271658382759*G0_0_0_2_2_1 - 0.0467147667147665*G0_0_0_2_2_2 - 0.0117748917748917*G0_0_1_0_0_0 - 0.00384800384800382*G0_0_1_0_0_1 - 0.00130832130832131*G0_0_1_0_0_2 - 0.00384800384800383*G0_0_1_0_1_0 + 0.00666987333654*G0_0_1_0_1_1 - 0.00130832130832131*G0_0_1_0_2_0 + 0.0013083213083213*G0_0_1_0_2_2 - 0.00384800384800383*G0_0_1_1_0_0 + 0.00666987333654*G0_0_1_1_0_1 + 0.00666987333654*G0_0_1_1_1_0 - 0.00666987333653995*G0_0_1_1_1_2 - 0.00666987333653995*G0_0_1_1_2_1 + 0.00384800384800382*G0_0_1_1_2_2 - 0.00130832130832131*G0_0_1_2_0_0 + 0.0013083213083213*G0_0_1_2_0_2 - 0.00666987333653995*G0_0_1_2_1_1 + 0.00384800384800382*G0_0_1_2_1_2 + 0.0013083213083213*G0_0_1_2_2_0 + 0.00384800384800382*G0_0_1_2_2_1 + 0.0117748917748917*G0_0_1_2_2_2;
    A[3] = A[45] - 0.000714018491796268*G0_0_1_0_0_1 + 0.000714018491796258*G0_0_1_0_0_2 - 0.000714018491796268*G0_0_1_0_1_0 - 0.000333493666826988*G0_0_1_0_1_1 + 0.000714018491796258*G0_0_1_0_2_0 + 0.000213777991555757*G0_0_1_0_2_2 - 0.000714018491796268*G0_0_1_1_0_0 - 0.000333493666826988*G0_0_1_1_0_1 - 0.000333493666826989*G0_0_1_1_1_0 + 0.0167644700978036*G0_0_1_1_1_1 - 0.00288600288600284*G0_0_1_1_1_2 - 0.00288600288600284*G0_0_1_1_2_1 - 0.00197103308214418*G0_0_1_1_2_2 + 0.000714018491796258*G0_0_1_2_0_0 + 0.000213777991555757*G0_0_1_2_0_2 - 0.00288600288600284*G0_0_1_2_1_1 - 0.00197103308214418*G0_0_1_2_1_2 + 0.000213777991555757*G0_0_1_2_2_0 - 0.00197103308214418*G0_0_1_2_2_1 - 0.0021933621933623*G0_0_1_2_2_2 + 0.000714018491796268*G0_1_0_0_0_1 - 0.000714018491796257*G0_1_0_0_0_2 + 0.000714018491796268*G0_1_0_0_1_0 + 0.000333493666826988*G0_1_0_0_1_1 - 0.000714018491796257*G0_1_0_0_2_0 - 0.000213777991555757*G0_1_0_0_2_2 + 0.000714018491796268*G0_1_0_1_0_0 + 0.000333493666826988*G0_1_0_1_0_1 + 0.000333493666826989*G0_1_0_1_1_0 - 0.0167644700978036*G0_1_0_1_1_1 + 0.00288600288600284*G0_1_0_1_1_2 + 0.00288600288600284*G0_1_0_1_2_1 + 0.00197103308214418*G0_1_0_1_2_2 - 0.000714018491796258*G0_1_0_2_0_0 - 0.000213777991555757*G0_1_0_2_0_2 + 0.00288600288600284*G0_1_0_2_1_1 + 0.00197103308214418*G0_1_0_2_1_2 - 0.000213777991555757*G0_1_0_2_2_0 + 0.00197103308214418*G0_1_0_2_2_1 + 0.0021933621933623*G0_1_0_2_2_2;
    A[11] = -A[3] - 0.117748917748918*G0_0_0_0_0_0 - 0.00268505157394048*G0_0_0_0_0_1 - 0.0107829618940729*G0_0_0_0_0_2 - 0.00268505157394048*G0_0_0_0_1_0 - 0.00494254716476937*G0_0_0_0_1_1 - 0.00126129015017904*G0_0_0_0_1_2 - 0.0107829618940729*G0_0_0_0_2_0 - 0.00126129015017904*G0_0_0_0_2_1 - 0.00164181497514828*G0_0_0_0_2_2 - 0.00268505157394048*G0_0_0_1_0_0 - 0.00494254716476937*G0_0_0_1_0_1 - 0.00126129015017904*G0_0_0_1_0_2 - 0.00494254716476937*G0_0_0_1_1_0 - 0.0288600288600288*G0_0_0_1_1_1 + 0.00135107690663245*G0_0_0_1_1_2 - 0.00126129015017904*G0_0_0_1_2_0 + 0.00135107690663245*G0_0_0_1_2_1 + 0.00174442841109508*G0_0_0_1_2_2 - 0.0107829618940729*G0_0_0_2_0_0 - 0.00126129015017904*G0_0_0_2_0_1 - 0.00164181497514828*G0_0_0_2_0_2 - 0.00126129015017904*G0_0_0_2_1_0 + 0.00135107690663245*G0_0_0_2_1_1 + 0.00174442841109508*G0_0_0_2_1_2 - 0.00164181497514828*G0_0_0_2_2_0 + 0.00174442841109508*G0_0_0_2_2_1 + 0.00187269520602859*G0_0_0_2_2_2 - 0.117748917748918*G0_1_0_0_0_0 - 0.00268505157394047*G0_1_0_0_0_1 - 0.0107829618940729*G0_1_0_0_0_2 - 0.00268505157394047*G0_1_0_0_1_0 - 0.00494254716476936*G0_1_0_0_1_1 - 0.00126129015017903*G0_1_0_0_1_2 - 0.0107829618940729*G0_1_0_0_2_0 - 0.00126129015017903*G0_1_0_0_2_1 - 0.00164181497514828*G0_1_0_0_2_2 - 0.00268505157394047*G0_1_0_1_0_0 - 0.00494254716476936*G0_1_0_1_0_1 - 0.00126129015017903*G0_1_0_1_0_2 - 0.00494254716476936*G0_1_0_1_1_0 - 0.0288600288600288*G0_1_0_1_1_1 + 0.00135107690663244*G0_1_0_1_1_2 - 0.00126129015017903*G0_1_0_1_2_0 + 0.00135107690663244*G0_1_0_1_2_1 + 0.00174442841109507*G0_1_0_1_2_2 - 0.0107829618940729*G0_1_0_2_0_0 - 0.00126129015017903*G0_1_0_2_0_1 - 0.00164181497514828*G0_1_0_2_0_2 - 0.00126129015017903*G0_1_0_2_1_0 + 0.00135107690663244*G0_1_0_2_1_1 + 0.00174442841109507*G0_1_0_2_1_2 - 0.00164181497514828*G0_1_0_2_2_0 + 0.00174442841109507*G0_1_0_2_2_1 + 0.00187269520602865*G0_1_0_2_2_2;
    A[128] = -A[125] - 0.0076960076960076*G0_0_1_0_0_0 - 0.00256533589866918*G0_0_1_0_0_1 - 0.0123136123136123*G0_0_1_0_0_2 - 0.00256533589866918*G0_0_1_0_1_0 - 0.00256533589866917*G0_0_1_0_1_1 - 0.00615680615680614*G0_0_1_0_1_2 - 0.0123136123136123*G0_0_1_0_2_0 - 0.00615680615680614*G0_0_1_0_2_1 - 0.02667949334616*G0_0_1_0_2_2 - 0.00256533589866918*G0_0_1_1_0_0 - 0.00256533589866917*G0_0_1_1_0_1 - 0.00615680615680614*G0_0_1_1_0_2 - 0.00256533589866917*G0_0_1_1_1_0 - 0.00769600769600748*G0_0_1_1_1_1 - 0.0123136123136123*G0_0_1_1_1_2 - 0.00615680615680614*G0_0_1_1_2_0 - 0.0123136123136123*G0_0_1_1_2_1 - 0.02667949334616*G0_0_1_1_2_2 - 0.0123136123136123*G0_0_1_2_0_0 - 0.00615680615680614*G0_0_1_2_0_1 - 0.02667949334616*G0_0_1_2_0_2 - 0.00615680615680614*G0_0_1_2_1_0 - 0.0123136123136123*G0_0_1_2_1_1 - 0.0266794933461599*G0_0_1_2_1_2 - 0.02667949334616*G0_0_1_2_2_0 - 0.0266794933461599*G0_0_1_2_2_1 + 0.301683501683499*G0_0_1_2_2_2 + 0.208613115279781*G0_1_1_0_0_0 + 0.0515119448452779*G0_1_1_0_0_1 + 0.0559243225909892*G0_1_1_0_0_2 + 0.0515119448452779*G0_1_1_0_1_0 + 0.0334861845972956*G0_1_1_0_1_1 + 0.0165891721447277*G0_1_1_0_1_2 + 0.0559243225909892*G0_1_1_0_2_0 + 0.0165891721447277*G0_1_1_0_2_1 + 0.0855111966223077*G0_1_1_0_2_2 + 0.0515119448452779*G0_1_1_1_0_0 + 0.0334861845972956*G0_1_1_1_0_1 + 0.0165891721447277*G0_1_1_1_0_2 + 0.0334861845972956*G0_1_1_1_1_0 + 0.0463812730479398*G0_1_1_1_1_1 + 0.0104323659879215*G0_1_1_1_1_2 + 0.0165891721447277*G0_1_1_1_2_0 + 0.0104323659879215*G0_1_1_1_2_1 + 0.0294158516380738*G0_1_1_1_2_2 + 0.0559243225909892*G0_1_1_2_0_0 + 0.0165891721447277*G0_1_1_2_0_1 + 0.0855111966223077*G0_1_1_2_0_2 + 0.0165891721447277*G0_1_1_2_1_0 + 0.0104323659879215*G0_1_1_2_1_1 + 0.0294158516380738*G0_1_1_2_1_2 + 0.0855111966223076*G0_1_1_2_2_0 + 0.0294158516380738*G0_1_1_2_2_1 + 0.539746673080004*G0_1_1_2_2_2;
    A[63] = -A[71] - 0.01341670675004*G0_0_0_0_0_0 - 0.00900432900432896*G0_0_0_0_0_1 - 0.0249863716530382*G0_0_0_0_0_2 - 0.00900432900432896*G0_0_0_0_1_0 - 0.0148789482122815*G0_0_0_0_1_1 - 0.00715728715728715*G0_0_0_0_1_2 - 0.0249863716530382*G0_0_0_0_2_0 - 0.00715728715728715*G0_0_0_0_2_1 - 0.0615424082090745*G0_0_0_0_2_2 - 0.00900432900432896*G0_0_0_1_0_0 - 0.0148789482122815*G0_0_0_1_0_1 - 0.00715728715728715*G0_0_0_1_0_2 - 0.0148789482122815*G0_0_0_1_1_0 + 0.0143658810325473*G0_0_0_1_1_1 + 0.0118005451338783*G0_0_0_1_1_2 - 0.00715728715728715*G0_0_0_1_2_0 + 0.0118005451338783*G0_0_0_1_2_1 - 0.0159307359307359*G0_0_0_1_2_2 - 0.0249863716530382*G0_0_0_2_0_0 - 0.00715728715728715*G0_0_0_2_0_1 - 0.0615424082090745*G0_0_0_2_0_2 - 0.00715728715728715*G0_0_0_2_1_0 + 0.0118005451338783*G0_0_0_2_1_1 - 0.0159307359307359*G0_0_0_2_1_2 - 0.0615424082090745*G0_0_0_2_2_0 - 0.0159307359307359*G0_0_0_2_2_1 - 0.342421035754367*G0_0_0_2_2_2 - 0.00885040885040872*G0_1_0_0_0_0 - 0.00923520923520917*G0_1_0_0_0_1 + 0.00115440115440112*G0_1_0_0_0_2 - 0.00923520923520917*G0_1_0_0_1_0 + 0.00718294051627396*G0_1_0_0_1_1 + 0.01333974667308*G0_1_0_0_1_2 + 0.00115440115440112*G0_1_0_0_2_0 + 0.01333974667308*G0_1_0_0_2_1 + 0.00525893859227189*G0_1_0_0_2_2 - 0.00923520923520917*G0_1_0_1_0_0 + 0.00718294051627396*G0_1_0_1_0_1 + 0.01333974667308*G0_1_0_1_0_2 + 0.00718294051627396*G0_1_0_1_1_0 + 0.469456469456469*G0_1_0_1_1_1 + 0.115953182619849*G0_1_0_1_1_2 + 0.01333974667308*G0_1_0_1_2_0 + 0.115953182619849*G0_1_0_1_2_1 + 0.0625941959275291*G0_1_0_1_2_2 + 0.00115440115440112*G0_1_0_2_0_0 + 0.01333974667308*G0_1_0_2_0_1 + 0.00525893859227189*G0_1_0_2_0_2 + 0.01333974667308*G0_1_0_2_1_0 + 0.115953182619849*G0_1_0_2_1_1 + 0.0625941959275291*G0_1_0_2_1_2 + 0.00525893859227189*G0_1_0_2_2_0 + 0.0625941959275291*G0_1_0_2_2_1 + 0.0280904280904281*G0_1_0_2_2_2;
    A[77] = -A[122] - 0.044508577841911*G0_1_1_0_0_0 - 0.0148361926139703*G0_1_1_0_0_1 - 0.00696916252471806*G0_1_1_0_0_2 - 0.0148361926139703*G0_1_1_0_1_0 - 0.0148361926139703*G0_1_1_0_1_1 - 0.00348458126235903*G0_1_1_0_1_2 - 0.00696916252471805*G0_1_1_0_2_0 - 0.00348458126235903*G0_1_1_0_2_1 - 0.01000481000481*G0_1_1_0_2_2 - 0.0148361926139703*G0_1_1_1_0_0 - 0.0148361926139703*G0_1_1_1_0_1 - 0.00348458126235903*G0_1_1_1_0_2 - 0.0148361926139703*G0_1_1_1_1_0 - 0.0445085778419112*G0_1_1_1_1_1 - 0.00696916252471806*G0_1_1_1_1_2 - 0.00348458126235903*G0_1_1_1_2_0 - 0.00696916252471806*G0_1_1_1_2_1 - 0.01000481000481*G0_1_1_1_2_2 - 0.00696916252471806*G0_1_1_2_0_0 - 0.00348458126235903*G0_1_1_2_0_1 - 0.01000481000481*G0_1_1_2_0_2 - 0.00348458126235903*G0_1_1_2_1_0 - 0.00696916252471806*G0_1_1_2_1_1 - 0.01000481000481*G0_1_1_2_1_2 - 0.01000481000481*G0_1_1_2_2_0 - 0.01000481000481*G0_1_1_2_2_1 - 0.224082090748756*G0_1_1_2_2_2;
    A[171] = -A[51] - 0.157922077922077*G0_0_0_0_0_0 + 0.0100903212014323*G0_0_0_0_0_1 - 0.0463128640906415*G0_0_0_0_0_2 + 0.0100903212014323*G0_0_0_0_1_0 + 0.00875634653412432*G0_0_0_0_1_1 + 0.00147079258190369*G0_0_0_0_1_2 - 0.0463128640906415*G0_0_0_0_2_0 + 0.00147079258190369*G0_0_0_0_2_1 - 0.0183678050344715*G0_0_0_0_2_2 + 0.0100903212014323*G0_0_0_1_0_0 + 0.00875634653412432*G0_0_0_1_0_1 + 0.00147079258190369*G0_0_0_1_0_2 + 0.00875634653412432*G0_0_0_1_1_0 - 0.00205226871893543*G0_0_0_1_1_1 - 0.00670407781518895*G0_0_0_1_1_2 + 0.00147079258190369*G0_0_0_1_2_0 - 0.00670407781518895*G0_0_0_1_2_1 - 0.00379669713003048*G0_0_0_1_2_2 - 0.0463128640906415*G0_0_0_2_0_0 + 0.00147079258190369*G0_0_0_2_0_1 - 0.0183678050344715*G0_0_0_2_0_2 + 0.00147079258190369*G0_0_0_2_1_0 - 0.00670407781518895*G0_0_0_2_1_1 - 0.00379669713003048*G0_0_0_2_1_2 - 0.0183678050344715*G0_0_0_2_2_0 - 0.00379669713003048*G0_0_0_2_2_1 - 0.0184704184704181*G0_0_0_2_2_2 + 0.0924547057880398*G0_0_1_0_0_0 - 0.000205226871893453*G0_0_1_0_0_1 - 0.0154946288279619*G0_0_1_0_0_2 - 0.000205226871893455*G0_0_1_0_1_0 + 0.00335203890759448*G0_0_1_0_1_1 + 0.00136817914595693*G0_0_1_0_1_2 - 0.0154946288279619*G0_0_1_0_2_0 + 0.00136817914595693*G0_0_1_0_2_1 - 0.0107060018171128*G0_0_1_0_2_2 - 0.000205226871893455*G0_0_1_1_0_0 + 0.00335203890759448*G0_0_1_1_0_1 + 0.00136817914595693*G0_0_1_1_0_2 + 0.00335203890759448*G0_0_1_1_1_0 - 0.00335203890759445*G0_0_1_1_1_2 + 0.00136817914595693*G0_0_1_1_2_0 - 0.00335203890759445*G0_0_1_1_2_1 - 0.00253113142002032*G0_0_1_1_2_2 - 0.0154946288279619*G0_0_1_2_0_0 + 0.00136817914595693*G0_0_1_2_0_1 - 0.0107060018171128*G0_0_1_2_0_2 + 0.00136817914595693*G0_0_1_2_1_0 - 0.00335203890759445*G0_0_1_2_1_1 - 0.00253113142002032*G0_0_1_2_1_2 - 0.0107060018171128*G0_0_1_2_2_0 - 0.00253113142002032*G0_0_1_2_2_1 - 0.0138528138528139*G0_0_1_2_2_2;
    A[101] = A[171] - 0.0831168831168835*G0_0_1_0_0_0 + 0.00324942547164759*G0_0_1_0_0_1 + 0.0121425899203676*G0_0_1_0_0_2 + 0.0032494254716476*G0_0_1_0_1_0 - 0.000307840307840383*G0_0_1_0_1_1 - 0.000684089572978468*G0_0_1_0_1_2 + 0.0121425899203676*G0_0_1_0_2_0 - 0.000684089572978468*G0_0_1_0_2_1 + 0.00885895997007101*G0_0_1_0_2_2 + 0.0032494254716476*G0_0_1_1_0_0 - 0.000307840307840382*G0_0_1_1_0_1 - 0.000684089572978468*G0_0_1_1_0_2 - 0.000307840307840382*G0_0_1_1_1_0 + 0.00933782267115592*G0_0_1_1_1_1 - 0.000684089572978468*G0_0_1_1_2_0 + 0.00068408957297849*G0_0_1_1_2_2 + 0.0121425899203676*G0_0_1_2_0_0 - 0.000684089572978468*G0_0_1_2_0_1 + 0.00885895997007101*G0_0_1_2_0_2 - 0.000684089572978468*G0_0_1_2_1_0 + 0.00068408957297849*G0_0_1_2_1_2 + 0.00885895997007101*G0_0_1_2_2_0 + 0.000684089572978489*G0_0_1_2_2_1 + 0.00400192400192401*G0_0_1_2_2_2 + 0.0831168831168835*G0_1_0_0_0_0 - 0.00324942547164759*G0_1_0_0_0_1 - 0.0121425899203676*G0_1_0_0_0_2 - 0.0032494254716476*G0_1_0_0_1_0 + 0.000307840307840382*G0_1_0_0_1_1 + 0.000684089572978468*G0_1_0_0_1_2 - 0.0121425899203676*G0_1_0_0_2_0 + 0.000684089572978467*G0_1_0_0_2_1 - 0.00885895997007102*G0_1_0_0_2_2 - 0.0032494254716476*G0_1_0_1_0_0 + 0.000307840307840381*G0_1_0_1_0_1 + 0.000684089572978467*G0_1_0_1_0_2 + 0.000307840307840382*G0_1_0_1_1_0 - 0.00933782267115592*G0_1_0_1_1_1 + 0.000684089572978468*G0_1_0_1_2_0 - 0.00068408957297849*G0_1_0_1_2_2 - 0.0121425899203676*G0_1_0_2_0_0 + 0.000684089572978467*G0_1_0_2_0_1 - 0.00885895997007102*G0_1_0_2_0_2 + 0.000684089572978467*G0_1_0_2_1_0 - 0.00068408957297849*G0_1_0_2_1_2 - 0.00885895997007101*G0_1_0_2_2_0 - 0.00068408957297849*G0_1_0_2_2_1 - 0.00400192400192401*G0_1_0_2_2_2;
    A[129] = A[101] + 0.111848645181978*G0_0_0_0_0_0 - 0.00697771364438032*G0_0_0_0_0_1 + 0.030578803912137*G0_0_0_0_0_2 - 0.00697771364438032*G0_0_0_0_1_0 - 0.00670407781518894*G0_0_0_0_1_1 - 0.00212067767623323*G0_0_0_0_1_2 + 0.030578803912137*G0_0_0_0_2_0 - 0.00212067767623323*G0_0_0_0_2_1 + 0.00991929880818758*G0_0_0_0_2_2 - 0.00697771364438032*G0_0_0_1_0_0 - 0.00670407781518894*G0_0_0_1_0_1 - 0.00212067767623323*G0_0_0_1_0_2 - 0.00670407781518894*G0_0_0_1_1_0 - 0.0322206188872855*G0_0_0_1_1_1 - 0.00622521511410399*G0_0_0_1_1_2 - 0.00212067767623323*G0_0_0_1_2_0 - 0.00622521511410399*G0_0_0_1_2_1 + 0.00157340601785043*G0_0_0_1_2_2 + 0.030578803912137*G0_0_0_2_0_0 - 0.00212067767623323*G0_0_0_2_0_1 + 0.00991929880818758*G0_0_0_2_0_2 - 0.00212067767623323*G0_0_0_2_1_0 - 0.00622521511410399*G0_0_0_2_1_1 + 0.00157340601785043*G0_0_0_2_1_2 + 0.00991929880818758*G0_0_0_2_2_0 + 0.00157340601785043*G0_0_0_2_2_1 + 0.00205226871893491*G0_0_0_2_2_2 + 0.00311260755705197*G0_0_1_0_0_1 - 0.00311260755705199*G0_0_1_0_0_2 + 0.00311260755705197*G0_0_1_0_1_0 + 0.00140238362460589*G0_0_1_0_1_1 - 0.00311260755705199*G0_0_1_0_2_0 - 0.00140238362460586*G0_0_1_0_2_2 + 0.00311260755705197*G0_0_1_1_0_0 + 0.00140238362460589*G0_0_1_1_0_1 + 0.00140238362460589*G0_0_1_1_1_0 - 0.0244219977553308*G0_0_1_1_1_1 - 0.00407033295922185*G0_0_1_1_1_2 - 0.00407033295922185*G0_0_1_1_2_1 + 0.00407033295922183*G0_0_1_1_2_2 - 0.00311260755705199*G0_0_1_2_0_0 - 0.00140238362460586*G0_0_1_2_0_2 - 0.00407033295922185*G0_0_1_2_1_1 + 0.00407033295922183*G0_0_1_2_1_2 - 0.00140238362460586*G0_0_1_2_2_0 + 0.00407033295922183*G0_0_1_2_2_1 + 0.0244219977553307*G0_0_1_2_2_2 - 0.00578055689166799*G0_1_0_0_0_1 + 0.00578055689166791*G0_1_0_0_0_2 - 0.00578055689166799*G0_1_0_0_1_0 - 0.0077644166533055*G0_1_0_0_1_1 + 0.00578055689166791*G0_1_0_0_2_0 + 0.00776441665330548*G0_1_0_0_2_2 - 0.00578055689166799*G0_1_0_1_0_0 - 0.0077644166533055*G0_1_0_1_0_1 - 0.0077644166533055*G0_1_0_1_1_0 - 0.0190860990860989*G0_1_0_1_1_1 - 0.00475442253220025*G0_1_0_1_1_2 - 0.00475442253220025*G0_1_0_1_2_1 + 0.0047544225322003*G0_1_0_1_2_2 + 0.00578055689166791*G0_1_0_2_0_0 + 0.00776441665330548*G0_1_0_2_0_2 - 0.00475442253220025*G0_1_0_2_1_1 + 0.0047544225322003*G0_1_0_2_1_2 + 0.00776441665330548*G0_1_0_2_2_0 + 0.0047544225322003*G0_1_0_2_2_1 + 0.0190860990860988*G0_1_0_2_2_2 - 0.111848645181978*G0_1_1_0_0_0 - 0.0305788039121371*G0_1_1_0_0_1 + 0.00697771364438034*G0_1_1_0_0_2 - 0.0305788039121371*G0_1_1_0_1_0 - 0.00991929880818761*G0_1_1_0_1_1 + 0.00212067767623324*G0_1_1_0_1_2 + 0.00697771364438034*G0_1_1_0_2_0 + 0.00212067767623324*G0_1_1_0_2_1 + 0.00670407781518891*G0_1_1_0_2_2 - 0.0305788039121371*G0_1_1_1_0_0 - 0.00991929880818761*G0_1_1_1_0_1 + 0.00212067767623324*G0_1_1_1_0_2 - 0.00991929880818761*G0_1_1_1_1_0 - 0.00205226871893517*G0_1_1_1_1_1 - 0.00157340601785042*G0_1_1_1_1_2 + 0.00212067767623324*G0_1_1_1_2_0 - 0.00157340601785042*G0_1_1_1_2_1 + 0.00622521511410399*G0_1_1_1_2_2 + 0.00697771364438034*G0_1_1_2_0_0 + 0.00212067767623324*G0_1_1_2_0_1 + 0.00670407781518891*G0_1_1_2_0_2 + 0.00212067767623324*G0_1_1_2_1_0 - 0.00157340601785042*G0_1_1_2_1_1 + 0.00622521511410399*G0_1_1_2_1_2 + 0.00670407781518891*G0_1_1_2_2_0 + 0.00622521511410399*G0_1_1_2_2_1 + 0.0322206188872853*G0_1_1_2_2_2;
    A[143] = A[129] + 0.0831168831168831*G0_0_1_0_0_0 - 0.0121425899203676*G0_0_1_0_0_1 - 0.00324942547164765*G0_0_1_0_0_2 - 0.0121425899203676*G0_0_1_0_1_0 - 0.008858959970071*G0_0_1_0_1_1 + 0.000684089572978467*G0_0_1_0_1_2 - 0.00324942547164765*G0_0_1_0_2_0 + 0.000684089572978469*G0_0_1_0_2_1 + 0.000307840307840324*G0_0_1_0_2_2 - 0.0121425899203676*G0_0_1_1_0_0 - 0.008858959970071*G0_0_1_1_0_1 + 0.000684089572978468*G0_0_1_1_0_2 - 0.008858959970071*G0_0_1_1_1_0 - 0.00400192400192399*G0_0_1_1_1_1 - 0.000684089572978447*G0_0_1_1_1_2 + 0.000684089572978469*G0_0_1_1_2_0 - 0.000684089572978447*G0_0_1_1_2_1 - 0.00324942547164765*G0_0_1_2_0_0 + 0.000684089572978468*G0_0_1_2_0_1 + 0.000307840307840322*G0_0_1_2_0_2 + 0.000684089572978468*G0_0_1_2_1_0 - 0.000684089572978447*G0_0_1_2_1_1 + 0.000307840307840324*G0_0_1_2_2_0 - 0.009337822671156*G0_0_1_2_2_2 - 0.0831168831168831*G0_1_0_0_0_0 + 0.0121425899203676*G0_1_0_0_0_1 + 0.00324942547164765*G0_1_0_0_0_2 + 0.0121425899203676*G0_1_0_0_1_0 + 0.008858959970071*G0_1_0_0_1_1 - 0.000684089572978468*G0_1_0_0_1_2 + 0.00324942547164765*G0_1_0_0_2_0 - 0.000684089572978468*G0_1_0_0_2_1 - 0.000307840307840324*G0_1_0_0_2_2 + 0.0121425899203676*G0_1_0_1_0_0 + 0.008858959970071*G0_1_0_1_0_1 - 0.000684089572978468*G0_1_0_1_0_2 + 0.008858959970071*G0_1_0_1_1_0 + 0.00400192400192399*G0_1_0_1_1_1 + 0.000684089572978447*G0_1_0_1_1_2 - 0.000684089572978469*G0_1_0_1_2_0 + 0.000684089572978447*G0_1_0_1_2_1 + 0.00324942547164765*G0_1_0_2_0_0 - 0.000684089572978468*G0_1_0_2_0_1 - 0.000307840307840323*G0_1_0_2_0_2 - 0.000684089572978468*G0_1_0_2_1_0 + 0.000684089572978447*G0_1_0_2_1_1 - 0.000307840307840324*G0_1_0_2_2_0 + 0.009337822671156*G0_1_0_2_2_2;
    A[84] = -A[129] + 0.0924547057880388*G0_1_0_0_0_0 - 0.015494628827962*G0_1_0_0_0_1 - 0.000205226871893515*G0_1_0_0_0_2 - 0.015494628827962*G0_1_0_0_1_0 - 0.0107060018171128*G0_1_0_0_1_1 + 0.00136817914595694*G0_1_0_0_1_2 - 0.000205226871893515*G0_1_0_0_2_0 + 0.00136817914595694*G0_1_0_0_2_1 + 0.00335203890759447*G0_1_0_0_2_2 - 0.015494628827962*G0_1_0_1_0_0 - 0.0107060018171128*G0_1_0_1_0_1 + 0.00136817914595694*G0_1_0_1_0_2 - 0.0107060018171128*G0_1_0_1_1_0 - 0.0138528138528139*G0_1_0_1_1_1 - 0.00253113142002023*G0_1_0_1_1_2 + 0.00136817914595694*G0_1_0_1_2_0 - 0.00253113142002023*G0_1_0_1_2_1 - 0.00335203890759437*G0_1_0_1_2_2 - 0.000205226871893513*G0_1_0_2_0_0 + 0.00136817914595694*G0_1_0_2_0_1 + 0.00335203890759447*G0_1_0_2_0_2 + 0.00136817914595694*G0_1_0_2_1_0 - 0.00253113142002023*G0_1_0_2_1_1 - 0.00335203890759437*G0_1_0_2_1_2 + 0.00335203890759447*G0_1_0_2_2_0 - 0.00335203890759437*G0_1_0_2_2_1 - 0.157922077922077*G0_1_1_0_0_0 - 0.0463128640906416*G0_1_1_0_0_1 + 0.0100903212014323*G0_1_1_0_0_2 - 0.0463128640906416*G0_1_1_0_1_0 - 0.0183678050344716*G0_1_1_0_1_1 + 0.0014707925819037*G0_1_1_0_1_2 + 0.0100903212014323*G0_1_1_0_2_0 + 0.0014707925819037*G0_1_1_0_2_1 + 0.00875634653412429*G0_1_1_0_2_2 - 0.0463128640906416*G0_1_1_1_0_0 - 0.0183678050344716*G0_1_1_1_0_1 + 0.0014707925819037*G0_1_1_1_0_2 - 0.0183678050344716*G0_1_1_1_1_0 - 0.0184704184704185*G0_1_1_1_1_1 - 0.00379669713003041*G0_1_1_1_1_2 + 0.0014707925819037*G0_1_1_1_2_0 - 0.00379669713003042*G0_1_1_1_2_1 - 0.00670407781518889*G0_1_1_1_2_2 + 0.0100903212014323*G0_1_1_2_0_0 + 0.0014707925819037*G0_1_1_2_0_1 + 0.00875634653412429*G0_1_1_2_0_2 + 0.0014707925819037*G0_1_1_2_1_0 - 0.00379669713003041*G0_1_1_2_1_1 - 0.00670407781518889*G0_1_1_2_1_2 + 0.00875634653412429*G0_1_1_2_2_0 - 0.00670407781518889*G0_1_1_2_2_1 - 0.00205226871893548*G0_1_1_2_2_2;
    A[93] = -A[101] - 0.157922077922077*G0_0_0_0_0_0 + 0.0100903212014323*G0_0_0_0_0_1 - 0.0463128640906415*G0_0_0_0_0_2 + 0.0100903212014323*G0_0_0_0_1_0 + 0.00875634653412432*G0_0_0_0_1_1 + 0.00147079258190369*G0_0_0_0_1_2 - 0.0463128640906415*G0_0_0_0_2_0 + 0.00147079258190369*G0_0_0_0_2_1 - 0.0183678050344715*G0_0_0_0_2_2 + 0.0100903212014323*G0_0_0_1_0_0 + 0.00875634653412432*G0_0_0_1_0_1 + 0.00147079258190369*G0_0_0_1_0_2 + 0.00875634653412432*G0_0_0_1_1_0 - 0.00205226871893543*G0_0_0_1_1_1 - 0.00670407781518895*G0_0_0_1_1_2 + 0.00147079258190369*G0_0_0_1_2_0 - 0.00670407781518895*G0_0_0_1_2_1 - 0.00379669713003048*G0_0_0_1_2_2 - 0.0463128640906415*G0_0_0_2_0_0 + 0.00147079258190369*G0_0_0_2_0_1 - 0.0183678050344715*G0_0_0_2_0_2 + 0.00147079258190369*G0_0_0_2_1_0 - 0.00670407781518895*G0_0_0_2_1_1 - 0.00379669713003048*G0_0_0_2_1_2 - 0.0183678050344715*G0_0_0_2_2_0 - 0.00379669713003048*G0_0_0_2_2_1 - 0.0184704184704181*G0_0_0_2_2_2 + 0.0924547057880398*G0_1_0_0_0_0 - 0.000205226871893453*G0_1_0_0_0_1 - 0.015494628827962*G0_1_0_0_0_2 - 0.000205226871893456*G0_1_0_0_1_0 + 0.00335203890759448*G0_1_0_0_1_1 + 0.00136817914595693*G0_1_0_0_1_2 - 0.015494628827962*G0_1_0_0_2_0 + 0.00136817914595693*G0_1_0_0_2_1 - 0.0107060018171128*G0_1_0_0_2_2 - 0.00020522687189346*G0_1_0_1_0_0 + 0.00335203890759448*G0_1_0_1_0_1 + 0.00136817914595693*G0_1_0_1_0_2 + 0.00335203890759448*G0_1_0_1_1_0 - 0.00335203890759445*G0_1_0_1_1_2 + 0.00136817914595693*G0_1_0_1_2_0 - 0.00335203890759445*G0_1_0_1_2_1 - 0.00253113142002032*G0_1_0_1_2_2 - 0.015494628827962*G0_1_0_2_0_0 + 0.00136817914595693*G0_1_0_2_0_1 - 0.0107060018171128*G0_1_0_2_0_2 + 0.00136817914595693*G0_1_0_2_1_0 - 0.00335203890759445*G0_1_0_2_1_1 - 0.00253113142002032*G0_1_0_2_1_2 - 0.0107060018171128*G0_1_0_2_2_0 - 0.00253113142002032*G0_1_0_2_2_1 - 0.0138528138528139*G0_1_0_2_2_2;
    A[140] = -A[143] + 0.0924547057880388*G0_0_1_0_0_0 - 0.015494628827962*G0_0_1_0_0_1 - 0.000205226871893515*G0_0_1_0_0_2 - 0.015494628827962*G0_0_1_0_1_0 - 0.0107060018171128*G0_0_1_0_1_1 + 0.00136817914595694*G0_0_1_0_1_2 - 0.000205226871893516*G0_0_1_0_2_0 + 0.00136817914595694*G0_0_1_0_2_1 + 0.00335203890759447*G0_0_1_0_2_2 - 0.015494628827962*G0_0_1_1_0_0 - 0.0107060018171128*G0_0_1_1_0_1 + 0.00136817914595694*G0_0_1_1_0_2 - 0.0107060018171128*G0_0_1_1_1_0 - 0.0138528138528139*G0_0_1_1_1_1 - 0.00253113142002023*G0_0_1_1_1_2 + 0.00136817914595694*G0_0_1_1_2_0 - 0.00253113142002023*G0_0_1_1_2_1 - 0.00335203890759437*G0_0_1_1_2_2 - 0.000205226871893516*G0_0_1_2_0_0 + 0.00136817914595694*G0_0_1_2_0_1 + 0.00335203890759447*G0_0_1_2_0_2 + 0.00136817914595694*G0_0_1_2_1_0 - 0.00253113142002023*G0_0_1_2_1_1 - 0.00335203890759437*G0_0_1_2_1_2 + 0.00335203890759447*G0_0_1_2_2_0 - 0.00335203890759437*G0_0_1_2_2_1 - 0.157922077922077*G0_1_1_0_0_0 - 0.0463128640906416*G0_1_1_0_0_1 + 0.0100903212014323*G0_1_1_0_0_2 - 0.0463128640906416*G0_1_1_0_1_0 - 0.0183678050344716*G0_1_1_0_1_1 + 0.0014707925819037*G0_1_1_0_1_2 + 0.0100903212014323*G0_1_1_0_2_0 + 0.0014707925819037*G0_1_1_0_2_1 + 0.00875634653412429*G0_1_1_0_2_2 - 0.0463128640906416*G0_1_1_1_0_0 - 0.0183678050344716*G0_1_1_1_0_1 + 0.0014707925819037*G0_1_1_1_0_2 - 0.0183678050344716*G0_1_1_1_1_0 - 0.0184704184704185*G0_1_1_1_1_1 - 0.00379669713003041*G0_1_1_1_1_2 + 0.0014707925819037*G0_1_1_1_2_0 - 0.00379669713003042*G0_1_1_1_2_1 - 0.00670407781518889*G0_1_1_1_2_2 + 0.0100903212014323*G0_1_1_2_0_0 + 0.0014707925819037*G0_1_1_2_0_1 + 0.00875634653412429*G0_1_1_2_0_2 + 0.0014707925819037*G0_1_1_2_1_0 - 0.00379669713003042*G0_1_1_2_1_1 - 0.00670407781518888*G0_1_1_2_1_2 + 0.00875634653412429*G0_1_1_2_2_0 - 0.00670407781518889*G0_1_1_2_2_1 - 0.00205226871893548*G0_1_1_2_2_2;
    A[152] = A[40] - 0.0023761423761423*G0_0_1_0_0_0 - 0.00253006253006251*G0_0_1_0_0_1 - 0.000314253647586972*G0_0_1_0_0_2 - 0.00253006253006251*G0_0_1_0_1_0 + 0.00253006253006254*G0_0_1_0_1_1 - 0.000314253647586973*G0_0_1_0_2_0 + 0.000420073753407071*G0_0_1_0_2_2 - 0.00253006253006251*G0_0_1_1_0_0 + 0.00253006253006254*G0_0_1_1_0_1 + 0.00253006253006254*G0_0_1_1_1_0 + 0.0023761423761423*G0_0_1_1_1_1 + 0.000314253647586985*G0_0_1_1_1_2 + 0.000314253647586984*G0_0_1_1_2_1 - 0.000420073753407094*G0_0_1_1_2_2 - 0.000314253647586972*G0_0_1_2_0_0 + 0.000420073753407071*G0_0_1_2_0_2 + 0.000314253647586984*G0_0_1_2_1_1 - 0.000420073753407094*G0_0_1_2_1_2 + 0.000420073753407071*G0_0_1_2_2_0 - 0.000420073753407094*G0_0_1_2_2_1 + 0.0023761423761423*G0_1_0_0_0_0 + 0.00253006253006251*G0_1_0_0_0_1 + 0.000314253647586972*G0_1_0_0_0_2 + 0.00253006253006251*G0_1_0_0_1_0 - 0.00253006253006254*G0_1_0_0_1_1 + 0.000314253647586972*G0_1_0_0_2_0 - 0.000420073753407071*G0_1_0_0_2_2 + 0.00253006253006251*G0_1_0_1_0_0 - 0.00253006253006254*G0_1_0_1_0_1 - 0.00253006253006254*G0_1_0_1_1_0 - 0.0023761423761423*G0_1_0_1_1_1 - 0.000314253647586984*G0_1_0_1_1_2 - 0.000314253647586983*G0_1_0_1_2_1 + 0.000420073753407094*G0_1_0_1_2_2 + 0.000314253647586971*G0_1_0_2_0_0 - 0.000420073753407071*G0_1_0_2_0_2 - 0.000314253647586983*G0_1_0_2_1_1 + 0.000420073753407094*G0_1_0_2_1_2 - 0.000420073753407071*G0_1_0_2_2_0 + 0.000420073753407094*G0_1_0_2_2_1;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class laplacian_f3_p1_q4_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  laplacian_f3_p1_q4_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p1_q4_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 2), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1)))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 3;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f3_p1_q4_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new laplacian_f3_p1_q4_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new laplacian_f3_p1_q4_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new laplacian_f3_p1_q4_tensor_finite_element_0();
        break;
      }
    case 4:
      {
        return new laplacian_f3_p1_q4_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f3_p1_q4_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new laplacian_f3_p1_q4_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new laplacian_f3_p1_q4_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new laplacian_f3_p1_q4_tensor_dofmap_0();
        break;
      }
    case 4:
      {
        return new laplacian_f3_p1_q4_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f3_p1_q4_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
