// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F3_P2_Q2_TENSOR_H
#define __LAPLACIAN_F3_P2_Q2_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f3_p2_q2_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f3_p2_q2_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q2_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f3_p2_q2_tensor_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f3_p2_q2_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f3_p2_q2_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q2_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f3_p2_q2_tensor_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f3_p2_q2_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f3_p2_q2_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q2_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    3024
    // Number of operations (multiply-add pairs) for tensor contraction: 13210
    // Total number of operations (multiply-add pairs):                  16245
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_3 = det*(w[2][0]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_4 = det*(w[2][0]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_5 = det*(w[2][0]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_3 = det*(w[2][0]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_4 = det*(w[2][0]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_5 = det*(w[2][0]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_3 = det*(w[2][0]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_4 = det*(w[2][0]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_5 = det*(w[2][0]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_0 = det*(w[2][0]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_1 = det*(w[2][0]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_2 = det*(w[2][0]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_3 = det*(w[2][0]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_4 = det*(w[2][0]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_5 = det*(w[2][0]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_0 = det*(w[2][0]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_1 = det*(w[2][0]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_2 = det*(w[2][0]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_3 = det*(w[2][0]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_4 = det*(w[2][0]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_5 = det*(w[2][0]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_0 = det*(w[2][0]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_1 = det*(w[2][0]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_2 = det*(w[2][0]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_3 = det*(w[2][0]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_4 = det*(w[2][0]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_5 = det*(w[2][0]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_3 = det*(w[2][1]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_4 = det*(w[2][1]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_5 = det*(w[2][1]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_3 = det*(w[2][1]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_4 = det*(w[2][1]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_5 = det*(w[2][1]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_3 = det*(w[2][1]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_4 = det*(w[2][1]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_5 = det*(w[2][1]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_0 = det*(w[2][1]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_1 = det*(w[2][1]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_2 = det*(w[2][1]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_3 = det*(w[2][1]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_4 = det*(w[2][1]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_5 = det*(w[2][1]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_0 = det*(w[2][1]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_1 = det*(w[2][1]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_2 = det*(w[2][1]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_3 = det*(w[2][1]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_4 = det*(w[2][1]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_5 = det*(w[2][1]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_0 = det*(w[2][1]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_1 = det*(w[2][1]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_2 = det*(w[2][1]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_3 = det*(w[2][1]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_4 = det*(w[2][1]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_5 = det*(w[2][1]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_3 = det*(w[2][2]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_4 = det*(w[2][2]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_5 = det*(w[2][2]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_3 = det*(w[2][2]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_4 = det*(w[2][2]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_5 = det*(w[2][2]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_3 = det*(w[2][2]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_4 = det*(w[2][2]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_5 = det*(w[2][2]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_0 = det*(w[2][2]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_1 = det*(w[2][2]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_2 = det*(w[2][2]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_3 = det*(w[2][2]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_4 = det*(w[2][2]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_5 = det*(w[2][2]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_0 = det*(w[2][2]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_1 = det*(w[2][2]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_2 = det*(w[2][2]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_3 = det*(w[2][2]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_4 = det*(w[2][2]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_5 = det*(w[2][2]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_0 = det*(w[2][2]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_1 = det*(w[2][2]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_2 = det*(w[2][2]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_3 = det*(w[2][2]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_4 = det*(w[2][2]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_5 = det*(w[2][2]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_0 = det*(w[2][3]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_1 = det*(w[2][3]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_2 = det*(w[2][3]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_3 = det*(w[2][3]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_4 = det*(w[2][3]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_5 = det*(w[2][3]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_0 = det*(w[2][3]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_1 = det*(w[2][3]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_2 = det*(w[2][3]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_3 = det*(w[2][3]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_4 = det*(w[2][3]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_5 = det*(w[2][3]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_0 = det*(w[2][3]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_1 = det*(w[2][3]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_2 = det*(w[2][3]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_3 = det*(w[2][3]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_4 = det*(w[2][3]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_5 = det*(w[2][3]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_0 = det*(w[2][3]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_1 = det*(w[2][3]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_2 = det*(w[2][3]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_3 = det*(w[2][3]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_4 = det*(w[2][3]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_5 = det*(w[2][3]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_0 = det*(w[2][3]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_1 = det*(w[2][3]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_2 = det*(w[2][3]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_3 = det*(w[2][3]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_4 = det*(w[2][3]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_5 = det*(w[2][3]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_0 = det*(w[2][3]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_1 = det*(w[2][3]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_2 = det*(w[2][3]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_3 = det*(w[2][3]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_4 = det*(w[2][3]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_5 = det*(w[2][3]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_0 = det*(w[2][4]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_1 = det*(w[2][4]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_2 = det*(w[2][4]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_3 = det*(w[2][4]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_4 = det*(w[2][4]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_5 = det*(w[2][4]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_0 = det*(w[2][4]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_1 = det*(w[2][4]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_2 = det*(w[2][4]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_3 = det*(w[2][4]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_4 = det*(w[2][4]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_5 = det*(w[2][4]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_0 = det*(w[2][4]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_1 = det*(w[2][4]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_2 = det*(w[2][4]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_3 = det*(w[2][4]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_4 = det*(w[2][4]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_5 = det*(w[2][4]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_0 = det*(w[2][4]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_1 = det*(w[2][4]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_2 = det*(w[2][4]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_3 = det*(w[2][4]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_4 = det*(w[2][4]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_5 = det*(w[2][4]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_0 = det*(w[2][4]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_1 = det*(w[2][4]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_2 = det*(w[2][4]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_3 = det*(w[2][4]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_4 = det*(w[2][4]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_5 = det*(w[2][4]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_0 = det*(w[2][4]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_1 = det*(w[2][4]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_2 = det*(w[2][4]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_3 = det*(w[2][4]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_4 = det*(w[2][4]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_5 = det*(w[2][4]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_0 = det*(w[2][5]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_1 = det*(w[2][5]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_2 = det*(w[2][5]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_3 = det*(w[2][5]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_4 = det*(w[2][5]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_5 = det*(w[2][5]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_0 = det*(w[2][5]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_1 = det*(w[2][5]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_2 = det*(w[2][5]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_3 = det*(w[2][5]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_4 = det*(w[2][5]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_5 = det*(w[2][5]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_0 = det*(w[2][5]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_1 = det*(w[2][5]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_2 = det*(w[2][5]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_3 = det*(w[2][5]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_4 = det*(w[2][5]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_5 = det*(w[2][5]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_0 = det*(w[2][5]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_1 = det*(w[2][5]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_2 = det*(w[2][5]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_3 = det*(w[2][5]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_4 = det*(w[2][5]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_5 = det*(w[2][5]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_0 = det*(w[2][5]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_1 = det*(w[2][5]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_2 = det*(w[2][5]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_3 = det*(w[2][5]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_4 = det*(w[2][5]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_5 = det*(w[2][5]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_0 = det*(w[2][5]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_1 = det*(w[2][5]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_2 = det*(w[2][5]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_3 = det*(w[2][5]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_4 = det*(w[2][5]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_5 = det*(w[2][5]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_3 = det*(w[2][0]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_4 = det*(w[2][0]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_5 = det*(w[2][0]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_3 = det*(w[2][0]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_4 = det*(w[2][0]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_5 = det*(w[2][0]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_3 = det*(w[2][0]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_4 = det*(w[2][0]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_5 = det*(w[2][0]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_0 = det*(w[2][0]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_1 = det*(w[2][0]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_2 = det*(w[2][0]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_3 = det*(w[2][0]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_4 = det*(w[2][0]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_5 = det*(w[2][0]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_0 = det*(w[2][0]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_1 = det*(w[2][0]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_2 = det*(w[2][0]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_3 = det*(w[2][0]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_4 = det*(w[2][0]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_5 = det*(w[2][0]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_0 = det*(w[2][0]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_1 = det*(w[2][0]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_2 = det*(w[2][0]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_3 = det*(w[2][0]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_4 = det*(w[2][0]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_5 = det*(w[2][0]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_3 = det*(w[2][1]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_4 = det*(w[2][1]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_5 = det*(w[2][1]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_3 = det*(w[2][1]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_4 = det*(w[2][1]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_5 = det*(w[2][1]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_3 = det*(w[2][1]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_4 = det*(w[2][1]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_5 = det*(w[2][1]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_0 = det*(w[2][1]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_1 = det*(w[2][1]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_2 = det*(w[2][1]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_3 = det*(w[2][1]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_4 = det*(w[2][1]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_5 = det*(w[2][1]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_0 = det*(w[2][1]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_1 = det*(w[2][1]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_2 = det*(w[2][1]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_3 = det*(w[2][1]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_4 = det*(w[2][1]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_5 = det*(w[2][1]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_0 = det*(w[2][1]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_1 = det*(w[2][1]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_2 = det*(w[2][1]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_3 = det*(w[2][1]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_4 = det*(w[2][1]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_5 = det*(w[2][1]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_3 = det*(w[2][2]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_4 = det*(w[2][2]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_5 = det*(w[2][2]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_3 = det*(w[2][2]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_4 = det*(w[2][2]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_5 = det*(w[2][2]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_3 = det*(w[2][2]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_4 = det*(w[2][2]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_5 = det*(w[2][2]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_0 = det*(w[2][2]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_1 = det*(w[2][2]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_2 = det*(w[2][2]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_3 = det*(w[2][2]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_4 = det*(w[2][2]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_5 = det*(w[2][2]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_0 = det*(w[2][2]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_1 = det*(w[2][2]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_2 = det*(w[2][2]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_3 = det*(w[2][2]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_4 = det*(w[2][2]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_5 = det*(w[2][2]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_0 = det*(w[2][2]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_1 = det*(w[2][2]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_2 = det*(w[2][2]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_3 = det*(w[2][2]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_4 = det*(w[2][2]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_5 = det*(w[2][2]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_0 = det*(w[2][3]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_1 = det*(w[2][3]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_2 = det*(w[2][3]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_3 = det*(w[2][3]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_4 = det*(w[2][3]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_5 = det*(w[2][3]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_0 = det*(w[2][3]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_1 = det*(w[2][3]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_2 = det*(w[2][3]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_3 = det*(w[2][3]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_4 = det*(w[2][3]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_5 = det*(w[2][3]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_0 = det*(w[2][3]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_1 = det*(w[2][3]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_2 = det*(w[2][3]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_3 = det*(w[2][3]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_4 = det*(w[2][3]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_5 = det*(w[2][3]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_0 = det*(w[2][3]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_1 = det*(w[2][3]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_2 = det*(w[2][3]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_3 = det*(w[2][3]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_4 = det*(w[2][3]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_5 = det*(w[2][3]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_0 = det*(w[2][3]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_1 = det*(w[2][3]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_2 = det*(w[2][3]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_3 = det*(w[2][3]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_4 = det*(w[2][3]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_5 = det*(w[2][3]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_0 = det*(w[2][3]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_1 = det*(w[2][3]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_2 = det*(w[2][3]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_3 = det*(w[2][3]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_4 = det*(w[2][3]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_5 = det*(w[2][3]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_0 = det*(w[2][4]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_1 = det*(w[2][4]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_2 = det*(w[2][4]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_3 = det*(w[2][4]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_4 = det*(w[2][4]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_5 = det*(w[2][4]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_0 = det*(w[2][4]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_1 = det*(w[2][4]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_2 = det*(w[2][4]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_3 = det*(w[2][4]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_4 = det*(w[2][4]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_5 = det*(w[2][4]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_0 = det*(w[2][4]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_1 = det*(w[2][4]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_2 = det*(w[2][4]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_3 = det*(w[2][4]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_4 = det*(w[2][4]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_5 = det*(w[2][4]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_0 = det*(w[2][4]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_1 = det*(w[2][4]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_2 = det*(w[2][4]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_3 = det*(w[2][4]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_4 = det*(w[2][4]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_5 = det*(w[2][4]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_0 = det*(w[2][4]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_1 = det*(w[2][4]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_2 = det*(w[2][4]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_3 = det*(w[2][4]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_4 = det*(w[2][4]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_5 = det*(w[2][4]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_0 = det*(w[2][4]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_1 = det*(w[2][4]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_2 = det*(w[2][4]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_3 = det*(w[2][4]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_4 = det*(w[2][4]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_5 = det*(w[2][4]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_0 = det*(w[2][5]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_1 = det*(w[2][5]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_2 = det*(w[2][5]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_3 = det*(w[2][5]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_4 = det*(w[2][5]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_5 = det*(w[2][5]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_0 = det*(w[2][5]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_1 = det*(w[2][5]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_2 = det*(w[2][5]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_3 = det*(w[2][5]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_4 = det*(w[2][5]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_5 = det*(w[2][5]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_0 = det*(w[2][5]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_1 = det*(w[2][5]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_2 = det*(w[2][5]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_3 = det*(w[2][5]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_4 = det*(w[2][5]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_5 = det*(w[2][5]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_0 = det*(w[2][5]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_1 = det*(w[2][5]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_2 = det*(w[2][5]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_3 = det*(w[2][5]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_4 = det*(w[2][5]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_5 = det*(w[2][5]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_0 = det*(w[2][5]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_1 = det*(w[2][5]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_2 = det*(w[2][5]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_3 = det*(w[2][5]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_4 = det*(w[2][5]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_5 = det*(w[2][5]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_0 = det*(w[2][5]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_1 = det*(w[2][5]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_2 = det*(w[2][5]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_3 = det*(w[2][5]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_4 = det*(w[2][5]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_5 = det*(w[2][5]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_3 = det*(w[2][0]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_4 = det*(w[2][0]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_5 = det*(w[2][0]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_3 = det*(w[2][0]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_4 = det*(w[2][0]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_5 = det*(w[2][0]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_3 = det*(w[2][0]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_4 = det*(w[2][0]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_5 = det*(w[2][0]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_0 = det*(w[2][0]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_1 = det*(w[2][0]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_2 = det*(w[2][0]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_3 = det*(w[2][0]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_4 = det*(w[2][0]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_5 = det*(w[2][0]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_0 = det*(w[2][0]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_1 = det*(w[2][0]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_2 = det*(w[2][0]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_3 = det*(w[2][0]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_4 = det*(w[2][0]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_5 = det*(w[2][0]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_0 = det*(w[2][0]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_1 = det*(w[2][0]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_2 = det*(w[2][0]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_3 = det*(w[2][0]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_4 = det*(w[2][0]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_5 = det*(w[2][0]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_3 = det*(w[2][1]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_4 = det*(w[2][1]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_5 = det*(w[2][1]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_3 = det*(w[2][1]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_4 = det*(w[2][1]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_5 = det*(w[2][1]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_3 = det*(w[2][1]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_4 = det*(w[2][1]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_5 = det*(w[2][1]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_0 = det*(w[2][1]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_1 = det*(w[2][1]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_2 = det*(w[2][1]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_3 = det*(w[2][1]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_4 = det*(w[2][1]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_5 = det*(w[2][1]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_0 = det*(w[2][1]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_1 = det*(w[2][1]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_2 = det*(w[2][1]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_3 = det*(w[2][1]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_4 = det*(w[2][1]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_5 = det*(w[2][1]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_0 = det*(w[2][1]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_1 = det*(w[2][1]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_2 = det*(w[2][1]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_3 = det*(w[2][1]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_4 = det*(w[2][1]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_5 = det*(w[2][1]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_3 = det*(w[2][2]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_4 = det*(w[2][2]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_5 = det*(w[2][2]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_3 = det*(w[2][2]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_4 = det*(w[2][2]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_5 = det*(w[2][2]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_3 = det*(w[2][2]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_4 = det*(w[2][2]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_5 = det*(w[2][2]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_0 = det*(w[2][2]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_1 = det*(w[2][2]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_2 = det*(w[2][2]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_3 = det*(w[2][2]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_4 = det*(w[2][2]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_5 = det*(w[2][2]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_0 = det*(w[2][2]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_1 = det*(w[2][2]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_2 = det*(w[2][2]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_3 = det*(w[2][2]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_4 = det*(w[2][2]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_5 = det*(w[2][2]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_0 = det*(w[2][2]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_1 = det*(w[2][2]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_2 = det*(w[2][2]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_3 = det*(w[2][2]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_4 = det*(w[2][2]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_5 = det*(w[2][2]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_0 = det*(w[2][3]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_1 = det*(w[2][3]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_2 = det*(w[2][3]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_3 = det*(w[2][3]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_4 = det*(w[2][3]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_5 = det*(w[2][3]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_0 = det*(w[2][3]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_1 = det*(w[2][3]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_2 = det*(w[2][3]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_3 = det*(w[2][3]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_4 = det*(w[2][3]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_5 = det*(w[2][3]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_0 = det*(w[2][3]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_1 = det*(w[2][3]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_2 = det*(w[2][3]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_3 = det*(w[2][3]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_4 = det*(w[2][3]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_5 = det*(w[2][3]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_0 = det*(w[2][3]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_1 = det*(w[2][3]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_2 = det*(w[2][3]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_3 = det*(w[2][3]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_4 = det*(w[2][3]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_5 = det*(w[2][3]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_0 = det*(w[2][3]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_1 = det*(w[2][3]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_2 = det*(w[2][3]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_3 = det*(w[2][3]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_4 = det*(w[2][3]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_5 = det*(w[2][3]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_0 = det*(w[2][3]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_1 = det*(w[2][3]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_2 = det*(w[2][3]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_3 = det*(w[2][3]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_4 = det*(w[2][3]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_5 = det*(w[2][3]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_0 = det*(w[2][4]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_1 = det*(w[2][4]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_2 = det*(w[2][4]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_3 = det*(w[2][4]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_4 = det*(w[2][4]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_5 = det*(w[2][4]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_0 = det*(w[2][4]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_1 = det*(w[2][4]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_2 = det*(w[2][4]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_3 = det*(w[2][4]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_4 = det*(w[2][4]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_5 = det*(w[2][4]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_0 = det*(w[2][4]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_1 = det*(w[2][4]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_2 = det*(w[2][4]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_3 = det*(w[2][4]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_4 = det*(w[2][4]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_5 = det*(w[2][4]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_0 = det*(w[2][4]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_1 = det*(w[2][4]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_2 = det*(w[2][4]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_3 = det*(w[2][4]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_4 = det*(w[2][4]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_5 = det*(w[2][4]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_0 = det*(w[2][4]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_1 = det*(w[2][4]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_2 = det*(w[2][4]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_3 = det*(w[2][4]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_4 = det*(w[2][4]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_5 = det*(w[2][4]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_0 = det*(w[2][4]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_1 = det*(w[2][4]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_2 = det*(w[2][4]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_3 = det*(w[2][4]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_4 = det*(w[2][4]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_5 = det*(w[2][4]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_0 = det*(w[2][5]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_1 = det*(w[2][5]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_2 = det*(w[2][5]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_3 = det*(w[2][5]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_4 = det*(w[2][5]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_5 = det*(w[2][5]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_0 = det*(w[2][5]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_1 = det*(w[2][5]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_2 = det*(w[2][5]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_3 = det*(w[2][5]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_4 = det*(w[2][5]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_5 = det*(w[2][5]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_0 = det*(w[2][5]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_1 = det*(w[2][5]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_2 = det*(w[2][5]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_3 = det*(w[2][5]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_4 = det*(w[2][5]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_5 = det*(w[2][5]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_0 = det*(w[2][5]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_1 = det*(w[2][5]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_2 = det*(w[2][5]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_3 = det*(w[2][5]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_4 = det*(w[2][5]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_5 = det*(w[2][5]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_0 = det*(w[2][5]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_1 = det*(w[2][5]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_2 = det*(w[2][5]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_3 = det*(w[2][5]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_4 = det*(w[2][5]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_5 = det*(w[2][5]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_0 = det*(w[2][5]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_1 = det*(w[2][5]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_2 = det*(w[2][5]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_3 = det*(w[2][5]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_4 = det*(w[2][5]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_5 = det*(w[2][5]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_3 = det*(w[2][0]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_4 = det*(w[2][0]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_5 = det*(w[2][0]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_3 = det*(w[2][0]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_4 = det*(w[2][0]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_5 = det*(w[2][0]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_3 = det*(w[2][0]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_4 = det*(w[2][0]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_5 = det*(w[2][0]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_0 = det*(w[2][0]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_1 = det*(w[2][0]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_2 = det*(w[2][0]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_3 = det*(w[2][0]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_4 = det*(w[2][0]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_5 = det*(w[2][0]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_0 = det*(w[2][0]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_1 = det*(w[2][0]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_2 = det*(w[2][0]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_3 = det*(w[2][0]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_4 = det*(w[2][0]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_5 = det*(w[2][0]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_0 = det*(w[2][0]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_1 = det*(w[2][0]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_2 = det*(w[2][0]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_3 = det*(w[2][0]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_4 = det*(w[2][0]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_5 = det*(w[2][0]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_3 = det*(w[2][1]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_4 = det*(w[2][1]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_5 = det*(w[2][1]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_3 = det*(w[2][1]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_4 = det*(w[2][1]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_5 = det*(w[2][1]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_3 = det*(w[2][1]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_4 = det*(w[2][1]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_5 = det*(w[2][1]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_0 = det*(w[2][1]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_1 = det*(w[2][1]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_2 = det*(w[2][1]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_3 = det*(w[2][1]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_4 = det*(w[2][1]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_5 = det*(w[2][1]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_0 = det*(w[2][1]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_1 = det*(w[2][1]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_2 = det*(w[2][1]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_3 = det*(w[2][1]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_4 = det*(w[2][1]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_5 = det*(w[2][1]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_0 = det*(w[2][1]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_1 = det*(w[2][1]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_2 = det*(w[2][1]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_3 = det*(w[2][1]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_4 = det*(w[2][1]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_5 = det*(w[2][1]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_3 = det*(w[2][2]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_4 = det*(w[2][2]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_5 = det*(w[2][2]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_3 = det*(w[2][2]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_4 = det*(w[2][2]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_5 = det*(w[2][2]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_3 = det*(w[2][2]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_4 = det*(w[2][2]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_5 = det*(w[2][2]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_0 = det*(w[2][2]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_1 = det*(w[2][2]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_2 = det*(w[2][2]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_3 = det*(w[2][2]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_4 = det*(w[2][2]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_5 = det*(w[2][2]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_0 = det*(w[2][2]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_1 = det*(w[2][2]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_2 = det*(w[2][2]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_3 = det*(w[2][2]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_4 = det*(w[2][2]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_5 = det*(w[2][2]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_0 = det*(w[2][2]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_1 = det*(w[2][2]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_2 = det*(w[2][2]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_3 = det*(w[2][2]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_4 = det*(w[2][2]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_5 = det*(w[2][2]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_0 = det*(w[2][3]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_1 = det*(w[2][3]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_2 = det*(w[2][3]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_3 = det*(w[2][3]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_4 = det*(w[2][3]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_5 = det*(w[2][3]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_0 = det*(w[2][3]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_1 = det*(w[2][3]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_2 = det*(w[2][3]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_3 = det*(w[2][3]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_4 = det*(w[2][3]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_5 = det*(w[2][3]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_0 = det*(w[2][3]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_1 = det*(w[2][3]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_2 = det*(w[2][3]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_3 = det*(w[2][3]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_4 = det*(w[2][3]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_5 = det*(w[2][3]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_0 = det*(w[2][3]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_1 = det*(w[2][3]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_2 = det*(w[2][3]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_3 = det*(w[2][3]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_4 = det*(w[2][3]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_5 = det*(w[2][3]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_0 = det*(w[2][3]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_1 = det*(w[2][3]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_2 = det*(w[2][3]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_3 = det*(w[2][3]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_4 = det*(w[2][3]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_5 = det*(w[2][3]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_0 = det*(w[2][3]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_1 = det*(w[2][3]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_2 = det*(w[2][3]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_3 = det*(w[2][3]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_4 = det*(w[2][3]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_5 = det*(w[2][3]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_0 = det*(w[2][4]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_1 = det*(w[2][4]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_2 = det*(w[2][4]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_3 = det*(w[2][4]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_4 = det*(w[2][4]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_5 = det*(w[2][4]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_0 = det*(w[2][4]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_1 = det*(w[2][4]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_2 = det*(w[2][4]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_3 = det*(w[2][4]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_4 = det*(w[2][4]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_5 = det*(w[2][4]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_0 = det*(w[2][4]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_1 = det*(w[2][4]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_2 = det*(w[2][4]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_3 = det*(w[2][4]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_4 = det*(w[2][4]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_5 = det*(w[2][4]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_0 = det*(w[2][4]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_1 = det*(w[2][4]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_2 = det*(w[2][4]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_3 = det*(w[2][4]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_4 = det*(w[2][4]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_5 = det*(w[2][4]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_0 = det*(w[2][4]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_1 = det*(w[2][4]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_2 = det*(w[2][4]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_3 = det*(w[2][4]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_4 = det*(w[2][4]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_5 = det*(w[2][4]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_0 = det*(w[2][4]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_1 = det*(w[2][4]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_2 = det*(w[2][4]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_3 = det*(w[2][4]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_4 = det*(w[2][4]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_5 = det*(w[2][4]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_0 = det*(w[2][5]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_1 = det*(w[2][5]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_2 = det*(w[2][5]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_3 = det*(w[2][5]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_4 = det*(w[2][5]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_5 = det*(w[2][5]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_0 = det*(w[2][5]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_1 = det*(w[2][5]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_2 = det*(w[2][5]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_3 = det*(w[2][5]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_4 = det*(w[2][5]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_5 = det*(w[2][5]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_0 = det*(w[2][5]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_1 = det*(w[2][5]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_2 = det*(w[2][5]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_3 = det*(w[2][5]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_4 = det*(w[2][5]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_5 = det*(w[2][5]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_0 = det*(w[2][5]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_1 = det*(w[2][5]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_2 = det*(w[2][5]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_3 = det*(w[2][5]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_4 = det*(w[2][5]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_5 = det*(w[2][5]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_0 = det*(w[2][5]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_1 = det*(w[2][5]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_2 = det*(w[2][5]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_3 = det*(w[2][5]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_4 = det*(w[2][5]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_5 = det*(w[2][5]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_0 = det*(w[2][5]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_1 = det*(w[2][5]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_2 = det*(w[2][5]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_3 = det*(w[2][5]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_4 = det*(w[2][5]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_5 = det*(w[2][5]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[9] = -0.00158730158730157*G0_0_0_0_0_0 + 0.000317460317460315*G0_0_0_0_0_1 - 0.00021164021164021*G0_0_0_0_0_2 + 0.000423280423280419*G0_0_0_0_0_3 - 0.00211640211640211*G0_0_0_0_0_4 + 0.000317460317460315*G0_0_0_0_1_0 - 0.000529100529100523*G0_0_0_0_1_1 - 0.000105820105820105*G0_0_0_0_1_2 - 0.00063492063492063*G0_0_0_0_1_3 - 0.00021164021164021*G0_0_0_0_1_4 - 0.000423280423280418*G0_0_0_0_1_5 - 0.00021164021164021*G0_0_0_0_2_0 - 0.000105820105820105*G0_0_0_0_2_1 + 0.00158730158730158*G0_0_0_0_2_2 + 0.00148148148148147*G0_0_0_0_2_3 + 0.00275132275132274*G0_0_0_0_2_4 + 0.000846560846560843*G0_0_0_0_2_5 + 0.00042328042328042*G0_0_0_0_3_0 - 0.00063492063492063*G0_0_0_0_3_1 + 0.00148148148148147*G0_0_0_0_3_2 - 0.00465608465608462*G0_0_0_0_3_3 - 0.000423280423280421*G0_0_0_0_3_4 - 0.00253968253968253*G0_0_0_0_3_5 - 0.00211640211640211*G0_0_0_0_4_0 - 0.00021164021164021*G0_0_0_0_4_1 + 0.00275132275132274*G0_0_0_0_4_2 - 0.000423280423280421*G0_0_0_0_4_3 + 0.00126984126984126*G0_0_0_0_4_4 - 0.00126984126984126*G0_0_0_0_4_5 - 0.000423280423280418*G0_0_0_0_5_1 + 0.000846560846560843*G0_0_0_0_5_2 - 0.00253968253968253*G0_0_0_0_5_3 - 0.00126984126984126*G0_0_0_0_5_4 - 0.00296296296296294*G0_0_0_0_5_5 + 0.000317460317460315*G0_0_0_1_0_0 - 0.000529100529100523*G0_0_0_1_0_1 - 0.000105820105820105*G0_0_0_1_0_2 - 0.00063492063492063*G0_0_0_1_0_3 - 0.00021164021164021*G0_0_0_1_0_4 - 0.000423280423280418*G0_0_0_1_0_5 - 0.000529100529100523*G0_0_0_1_1_0 + 0.00476190476190471*G0_0_0_1_1_1 - 0.00105820105820105*G0_0_0_1_1_2 + 0.00423280423280421*G0_0_0_1_1_3 + 0.0021164021164021*G0_0_0_1_1_5 - 0.000105820105820105*G0_0_0_1_2_0 - 0.00105820105820105*G0_0_0_1_2_1 + 0.00158730158730158*G0_0_0_1_2_2 - 0.000634920634920632*G0_0_0_1_2_3 + 0.000634920634920631*G0_0_0_1_2_4 - 0.00042328042328042*G0_0_0_1_2_5 - 0.00063492063492063*G0_0_0_1_3_0 + 0.00423280423280421*G0_0_0_1_3_1 - 0.000634920634920632*G0_0_0_1_3_2 + 0.00634920634920632*G0_0_0_1_3_3 + 0.00126984126984126*G0_0_0_1_3_4 + 0.0021164021164021*G0_0_0_1_3_5 - 0.00021164021164021*G0_0_0_1_4_0 + 0.000634920634920631*G0_0_0_1_4_2 + 0.00126984126984126*G0_0_0_1_4_3 + 0.00380952380952379*G0_0_0_1_4_4 + 0.000846560846560843*G0_0_0_1_4_5 - 0.000423280423280418*G0_0_0_1_5_0 + 0.0021164021164021*G0_0_0_1_5_1 - 0.00042328042328042*G0_0_0_1_5_2 + 0.0021164021164021*G0_0_0_1_5_3 + 0.000846560846560843*G0_0_0_1_5_4 + 0.0021164021164021*G0_0_0_1_5_5 - 0.00021164021164021*G0_0_0_2_0_0 - 0.000105820105820105*G0_0_0_2_0_1 + 0.00158730158730158*G0_0_0_2_0_2 + 0.00148148148148147*G0_0_0_2_0_3 + 0.00275132275132274*G0_0_0_2_0_4 + 0.000846560846560843*G0_0_0_2_0_5 - 0.000105820105820105*G0_0_0_2_1_0 - 0.00105820105820105*G0_0_0_2_1_1 + 0.00158730158730158*G0_0_0_2_1_2 - 0.000634920634920632*G0_0_0_2_1_3 + 0.000634920634920631*G0_0_0_2_1_4 - 0.00042328042328042*G0_0_0_2_1_5 + 0.00158730158730158*G0_0_0_2_2_0 + 0.00158730158730158*G0_0_0_2_2_1 - 0.0190476190476189*G0_0_0_2_2_2 - 0.00423280423280421*G0_0_0_2_2_3 - 0.00846560846560842*G0_0_0_2_2_4 + 0.00148148148148147*G0_0_0_2_3_0 - 0.000634920634920632*G0_0_0_2_3_1 - 0.00423280423280421*G0_0_0_2_3_2 - 0.00846560846560842*G0_0_0_2_3_3 - 0.00423280423280421*G0_0_0_2_3_4 - 0.00296296296296295*G0_0_0_2_3_5 + 0.00275132275132274*G0_0_0_2_4_0 + 0.000634920634920631*G0_0_0_2_4_1 - 0.00846560846560841*G0_0_0_2_4_2 - 0.00423280423280421*G0_0_0_2_4_3 - 0.00846560846560843*G0_0_0_2_4_4 - 0.00126984126984127*G0_0_0_2_4_5 + 0.000846560846560843*G0_0_0_2_5_0 - 0.00042328042328042*G0_0_0_2_5_1 - 0.00296296296296295*G0_0_0_2_5_3 - 0.00126984126984127*G0_0_0_2_5_4 - 0.00253968253968253*G0_0_0_2_5_5 + 0.000423280423280419*G0_0_0_3_0_0 - 0.00063492063492063*G0_0_0_3_0_1 + 0.00148148148148147*G0_0_0_3_0_2 - 0.00465608465608462*G0_0_0_3_0_3 - 0.000423280423280421*G0_0_0_3_0_4 - 0.00253968253968253*G0_0_0_3_0_5 - 0.00063492063492063*G0_0_0_3_1_0 + 0.00423280423280421*G0_0_0_3_1_1 - 0.000634920634920632*G0_0_0_3_1_2 + 0.00634920634920632*G0_0_0_3_1_3 + 0.00126984126984126*G0_0_0_3_1_4 + 0.00211640211640211*G0_0_0_3_1_5 + 0.00148148148148147*G0_0_0_3_2_0 - 0.000634920634920632*G0_0_0_3_2_1 - 0.00423280423280421*G0_0_0_3_2_2 - 0.00846560846560842*G0_0_0_3_2_3 - 0.00423280423280421*G0_0_0_3_2_4 - 0.00296296296296295*G0_0_0_3_2_5 - 0.00465608465608462*G0_0_0_3_3_0 + 0.00634920634920632*G0_0_0_3_3_1 - 0.00846560846560842*G0_0_0_3_3_2 + 0.0609523809523806*G0_0_0_3_3_3 + 0.00677248677248675*G0_0_0_3_3_4 + 0.0152380952380952*G0_0_0_3_3_5 - 0.000423280423280421*G0_0_0_3_4_0 + 0.00126984126984126*G0_0_0_3_4_1 - 0.00423280423280421*G0_0_0_3_4_2 + 0.00677248677248675*G0_0_0_3_4_3 - 0.00677248677248674*G0_0_0_3_4_4 + 0.00338624338624337*G0_0_0_3_4_5 - 0.00253968253968253*G0_0_0_3_5_0 + 0.0021164021164021*G0_0_0_3_5_1 - 0.00296296296296295*G0_0_0_3_5_2 + 0.0152380952380952*G0_0_0_3_5_3 + 0.00338624338624337*G0_0_0_3_5_4 + 0.0101587301587301*G0_0_0_3_5_5 - 0.00211640211640211*G0_0_0_4_0_0 - 0.00021164021164021*G0_0_0_4_0_1 + 0.00275132275132274*G0_0_0_4_0_2 - 0.000423280423280421*G0_0_0_4_0_3 + 0.00126984126984126*G0_0_0_4_0_4 - 0.00126984126984126*G0_0_0_4_0_5 - 0.00021164021164021*G0_0_0_4_1_0 + 0.000634920634920631*G0_0_0_4_1_2 + 0.00126984126984126*G0_0_0_4_1_3 + 0.00380952380952379*G0_0_0_4_1_4 + 0.000846560846560843*G0_0_0_4_1_5 + 0.00275132275132274*G0_0_0_4_2_0 + 0.000634920634920631*G0_0_0_4_2_1 - 0.00846560846560842*G0_0_0_4_2_2 - 0.00423280423280421*G0_0_0_4_2_3 - 0.00846560846560843*G0_0_0_4_2_4 - 0.00126984126984127*G0_0_0_4_2_5 - 0.000423280423280421*G0_0_0_4_3_0 + 0.00126984126984126*G0_0_0_4_3_1 - 0.00423280423280421*G0_0_0_4_3_2 + 0.00677248677248675*G0_0_0_4_3_3 - 0.00677248677248674*G0_0_0_4_3_4 + 0.00338624338624337*G0_0_0_4_3_5 + 0.00126984126984126*G0_0_0_4_4_0 + 0.00380952380952379*G0_0_0_4_4_1 - 0.00846560846560843*G0_0_0_4_4_2 - 0.00677248677248674*G0_0_0_4_4_3 - 0.0609523809523807*G0_0_0_4_4_4 - 0.00507936507936507*G0_0_0_4_4_5 - 0.00126984126984126*G0_0_0_4_5_0 + 0.000846560846560843*G0_0_0_4_5_1 - 0.00126984126984127*G0_0_0_4_5_2 + 0.00338624338624337*G0_0_0_4_5_3 - 0.00507936507936507*G0_0_0_4_5_4 + 0.00338624338624337*G0_0_0_4_5_5 - 0.000423280423280418*G0_0_0_5_0_1 + 0.000846560846560843*G0_0_0_5_0_2 - 0.00253968253968253*G0_0_0_5_0_3 - 0.00126984126984126*G0_0_0_5_0_4 - 0.00296296296296294*G0_0_0_5_0_5 - 0.000423280423280418*G0_0_0_5_1_0 + 0.0021164021164021*G0_0_0_5_1_1 - 0.00042328042328042*G0_0_0_5_1_2 + 0.0021164021164021*G0_0_0_5_1_3 + 0.000846560846560843*G0_0_0_5_1_4 + 0.0021164021164021*G0_0_0_5_1_5 + 0.000846560846560843*G0_0_0_5_2_0 - 0.00042328042328042*G0_0_0_5_2_1 - 0.00296296296296295*G0_0_0_5_2_3 - 0.00126984126984127*G0_0_0_5_2_4 - 0.00253968253968253*G0_0_0_5_2_5 - 0.00253968253968253*G0_0_0_5_3_0 + 0.00211640211640211*G0_0_0_5_3_1 - 0.00296296296296295*G0_0_0_5_3_2 + 0.0152380952380952*G0_0_0_5_3_3 + 0.00338624338624337*G0_0_0_5_3_4 + 0.0101587301587301*G0_0_0_5_3_5 - 0.00126984126984126*G0_0_0_5_4_0 + 0.000846560846560843*G0_0_0_5_4_1 - 0.00126984126984127*G0_0_0_5_4_2 + 0.00338624338624337*G0_0_0_5_4_3 - 0.00507936507936506*G0_0_0_5_4_4 + 0.00338624338624337*G0_0_0_5_4_5 - 0.00296296296296294*G0_0_0_5_5_0 + 0.0021164021164021*G0_0_0_5_5_1 - 0.00253968253968253*G0_0_0_5_5_2 + 0.0101587301587301*G0_0_0_5_5_3 + 0.00338624338624337*G0_0_0_5_5_4 + 0.0152380952380951*G0_0_0_5_5_5 - 0.00158730158730158*G0_0_1_0_0_0 + 0.00126984126984126*G0_0_1_0_0_1 - 0.000317460317460315*G0_0_1_0_0_2 + 0.00169312169312168*G0_0_1_0_0_3 + 0.0021164021164021*G0_0_1_0_0_5 + 0.00126984126984126*G0_0_1_0_1_0 - 0.00582010582010577*G0_0_1_0_1_1 + 0.000740740740740735*G0_0_1_0_1_2 - 0.00317460317460315*G0_0_1_0_1_3 - 0.00042328042328042*G0_0_1_0_1_4 - 0.00529100529100525*G0_0_1_0_1_5 - 0.000317460317460315*G0_0_1_0_2_0 + 0.000740740740740735*G0_0_1_0_2_1 - 0.000317460317460316*G0_0_1_0_2_2 + 0.00190476190476189*G0_0_1_0_2_3 + 0.000846560846560842*G0_0_1_0_2_4 + 0.00190476190476189*G0_0_1_0_2_5 + 0.00169312169312168*G0_0_1_0_3_0 - 0.00317460317460315*G0_0_1_0_3_1 + 0.00190476190476189*G0_0_1_0_3_2 - 0.00973544973544967*G0_0_1_0_3_3 - 0.00253968253968253*G0_0_1_0_3_4 - 0.00719576719576715*G0_0_1_0_3_5 - 0.00042328042328042*G0_0_1_0_4_1 + 0.000846560846560842*G0_0_1_0_4_2 - 0.00253968253968253*G0_0_1_0_4_3 - 0.00126984126984127*G0_0_1_0_4_4 - 0.00296296296296295*G0_0_1_0_4_5 + 0.0021164021164021*G0_0_1_0_5_0 - 0.00529100529100525*G0_0_1_0_5_1 + 0.00190476190476189*G0_0_1_0_5_2 - 0.00719576719576715*G0_0_1_0_5_3 - 0.00296296296296295*G0_0_1_0_5_4 - 0.0139682539682539*G0_0_1_0_5_5 + 0.00126984126984126*G0_0_1_1_0_0 - 0.00582010582010577*G0_0_1_1_0_1 + 0.000740740740740735*G0_0_1_1_0_2 - 0.00317460317460315*G0_0_1_1_0_3 - 0.00042328042328042*G0_0_1_1_0_4 - 0.00529100529100525*G0_0_1_1_0_5 - 0.00582010582010577*G0_0_1_1_1_0 + 0.0634920634920631*G0_0_1_1_1_1 - 0.00582010582010579*G0_0_1_1_1_2 + 0.0253968253968252*G0_0_1_1_1_3 + 0.00211640211640211*G0_0_1_1_1_4 + 0.0253968253968252*G0_0_1_1_1_5 + 0.000740740740740735*G0_0_1_1_2_0 - 0.00582010582010579*G0_0_1_1_2_1 + 0.00126984126984126*G0_0_1_1_2_2 - 0.00529100529100526*G0_0_1_1_2_3 - 0.000423280423280422*G0_0_1_1_2_4 - 0.00317460317460316*G0_0_1_1_2_5 - 0.00317460317460315*G0_0_1_1_3_0 + 0.0253968253968252*G0_0_1_1_3_1 - 0.00529100529100526*G0_0_1_1_3_2 + 0.0253968253968253*G0_0_1_1_3_3 + 0.00211640211640211*G0_0_1_1_3_4 + 0.0126984126984126*G0_0_1_1_3_5 - 0.00042328042328042*G0_0_1_1_4_0 + 0.00211640211640211*G0_0_1_1_4_1 - 0.000423280423280422*G0_0_1_1_4_2 + 0.00211640211640211*G0_0_1_1_4_3 + 0.000846560846560842*G0_0_1_1_4_4 + 0.0021164021164021*G0_0_1_1_4_5 - 0.00529100529100525*G0_0_1_1_5_0 + 0.0253968253968252*G0_0_1_1_5_1 - 0.00317460317460316*G0_0_1_1_5_2 + 0.0126984126984126*G0_0_1_1_5_3 + 0.0021164021164021*G0_0_1_1_5_4 + 0.0253968253968252*G0_0_1_1_5_5 - 0.000317460317460315*G0_0_1_2_0_0 + 0.000740740740740735*G0_0_1_2_0_1 - 0.000317460317460316*G0_0_1_2_0_2 + 0.00190476190476189*G0_0_1_2_0_3 + 0.000846560846560842*G0_0_1_2_0_4 + 0.00190476190476189*G0_0_1_2_0_5 + 0.000740740740740735*G0_0_1_2_1_0 - 0.00582010582010579*G0_0_1_2_1_1 + 0.00126984126984126*G0_0_1_2_1_2 - 0.00529100529100526*G0_0_1_2_1_3 - 0.000423280423280422*G0_0_1_2_1_4 - 0.00317460317460316*G0_0_1_2_1_5 - 0.000317460317460316*G0_0_1_2_2_0 + 0.00126984126984126*G0_0_1_2_2_1 - 0.00158730158730157*G0_0_1_2_2_2 + 0.00211640211640211*G0_0_1_2_2_3 + 0.00169312169312169*G0_0_1_2_2_5 + 0.00190476190476189*G0_0_1_2_3_0 - 0.00529100529100526*G0_0_1_2_3_1 + 0.00211640211640211*G0_0_1_2_3_2 - 0.0139682539682539*G0_0_1_2_3_3 - 0.00296296296296295*G0_0_1_2_3_4 - 0.00719576719576716*G0_0_1_2_3_5 + 0.000846560846560842*G0_0_1_2_4_0 - 0.000423280423280422*G0_0_1_2_4_1 - 0.00296296296296295*G0_0_1_2_4_3 - 0.00126984126984126*G0_0_1_2_4_4 - 0.00253968253968253*G0_0_1_2_4_5 + 0.00190476190476189*G0_0_1_2_5_0 - 0.00317460317460316*G0_0_1_2_5_1 + 0.00169312169312169*G0_0_1_2_5_2 - 0.00719576719576716*G0_0_1_2_5_3 - 0.00253968253968253*G0_0_1_2_5_4 - 0.00973544973544969*G0_0_1_2_5_5 + 0.00169312169312168*G0_0_1_3_0_0 - 0.00317460317460315*G0_0_1_3_0_1 + 0.00190476190476189*G0_0_1_3_0_2 - 0.00973544973544967*G0_0_1_3_0_3 - 0.00253968253968253*G0_0_1_3_0_4 - 0.00719576719576715*G0_0_1_3_0_5 - 0.00317460317460315*G0_0_1_3_1_0 + 0.0253968253968252*G0_0_1_3_1_1 - 0.00529100529100526*G0_0_1_3_1_2 + 0.0253968253968253*G0_0_1_3_1_3 + 0.00211640211640211*G0_0_1_3_1_4 + 0.0126984126984126*G0_0_1_3_1_5 + 0.00190476190476189*G0_0_1_3_2_0 - 0.00529100529100526*G0_0_1_3_2_1 + 0.00211640211640211*G0_0_1_3_2_2 - 0.0139682539682539*G0_0_1_3_2_3 - 0.00296296296296295*G0_0_1_3_2_4 - 0.00719576719576716*G0_0_1_3_2_5 - 0.00973544973544967*G0_0_1_3_3_0 + 0.0253968253968253*G0_0_1_3_3_1 - 0.0139682539682539*G0_0_1_3_3_2 + 0.101587301587301*G0_0_1_3_3_3 + 0.0152380952380952*G0_0_1_3_3_4 + 0.0338624338624337*G0_0_1_3_3_5 - 0.00253968253968253*G0_0_1_3_4_0 + 0.00211640211640211*G0_0_1_3_4_1 - 0.00296296296296295*G0_0_1_3_4_2 + 0.0152380952380952*G0_0_1_3_4_3 + 0.00338624338624337*G0_0_1_3_4_4 + 0.0101587301587301*G0_0_1_3_4_5 - 0.00719576719576715*G0_0_1_3_5_0 + 0.0126984126984126*G0_0_1_3_5_1 - 0.00719576719576716*G0_0_1_3_5_2 + 0.0338624338624337*G0_0_1_3_5_3 + 0.0101587301587301*G0_0_1_3_5_4 + 0.0338624338624337*G0_0_1_3_5_5 - 0.00042328042328042*G0_0_1_4_0_1 + 0.000846560846560842*G0_0_1_4_0_2 - 0.00253968253968253*G0_0_1_4_0_3 - 0.00126984126984127*G0_0_1_4_0_4 - 0.00296296296296295*G0_0_1_4_0_5 - 0.00042328042328042*G0_0_1_4_1_0 + 0.00211640211640211*G0_0_1_4_1_1 - 0.000423280423280422*G0_0_1_4_1_2 + 0.00211640211640211*G0_0_1_4_1_3 + 0.000846560846560842*G0_0_1_4_1_4 + 0.0021164021164021*G0_0_1_4_1_5 + 0.000846560846560842*G0_0_1_4_2_0 - 0.000423280423280422*G0_0_1_4_2_1 - 0.00296296296296295*G0_0_1_4_2_3 - 0.00126984126984126*G0_0_1_4_2_4 - 0.00253968253968253*G0_0_1_4_2_5 - 0.00253968253968253*G0_0_1_4_3_0 + 0.00211640211640211*G0_0_1_4_3_1 - 0.00296296296296295*G0_0_1_4_3_2 + 0.0152380952380952*G0_0_1_4_3_3 + 0.00338624338624337*G0_0_1_4_3_4 + 0.0101587301587301*G0_0_1_4_3_5 - 0.00126984126984127*G0_0_1_4_4_0 + 0.000846560846560842*G0_0_1_4_4_1 - 0.00126984126984126*G0_0_1_4_4_2 + 0.00338624338624337*G0_0_1_4_4_3 - 0.00507936507936505*G0_0_1_4_4_4 + 0.00338624338624337*G0_0_1_4_4_5 - 0.00296296296296295*G0_0_1_4_5_0 + 0.0021164021164021*G0_0_1_4_5_1 - 0.00253968253968253*G0_0_1_4_5_2 + 0.0101587301587301*G0_0_1_4_5_3 + 0.00338624338624337*G0_0_1_4_5_4 + 0.0152380952380952*G0_0_1_4_5_5 + 0.0021164021164021*G0_0_1_5_0_0 - 0.00529100529100525*G0_0_1_5_0_1 + 0.00190476190476189*G0_0_1_5_0_2 - 0.00719576719576715*G0_0_1_5_0_3 - 0.00296296296296295*G0_0_1_5_0_4 - 0.0139682539682539*G0_0_1_5_0_5 - 0.00529100529100525*G0_0_1_5_1_0 + 0.0253968253968252*G0_0_1_5_1_1 - 0.00317460317460316*G0_0_1_5_1_2 + 0.0126984126984126*G0_0_1_5_1_3 + 0.0021164021164021*G0_0_1_5_1_4 + 0.0253968253968252*G0_0_1_5_1_5 + 0.00190476190476189*G0_0_1_5_2_0 - 0.00317460317460316*G0_0_1_5_2_1 + 0.00169312169312169*G0_0_1_5_2_2 - 0.00719576719576716*G0_0_1_5_2_3 - 0.00253968253968253*G0_0_1_5_2_4 - 0.00973544973544969*G0_0_1_5_2_5 - 0.00719576719576715*G0_0_1_5_3_0 + 0.0126984126984126*G0_0_1_5_3_1 - 0.00719576719576716*G0_0_1_5_3_2 + 0.0338624338624337*G0_0_1_5_3_3 + 0.0101587301587301*G0_0_1_5_3_4 + 0.0338624338624337*G0_0_1_5_3_5 - 0.00296296296296295*G0_0_1_5_4_0 + 0.0021164021164021*G0_0_1_5_4_1 - 0.00253968253968253*G0_0_1_5_4_2 + 0.0101587301587301*G0_0_1_5_4_3 + 0.00338624338624337*G0_0_1_5_4_4 + 0.0152380952380952*G0_0_1_5_4_5 - 0.0139682539682539*G0_0_1_5_5_0 + 0.0253968253968252*G0_0_1_5_5_1 - 0.00973544973544969*G0_0_1_5_5_2 + 0.0338624338624337*G0_0_1_5_5_3 + 0.0152380952380952*G0_0_1_5_5_4 + 0.101587301587301*G0_0_1_5_5_5;
    A[13] = 0.00396825396825395*G0_1_0_0_0_0 - 0.000476190476190473*G0_1_0_0_0_1 - 0.000476190476190474*G0_1_0_0_0_2 - 0.000105820105820105*G0_1_0_0_0_3 + 0.000529100529100526*G0_1_0_0_0_4 + 0.000529100529100527*G0_1_0_0_0_5 - 0.000476190476190473*G0_1_0_0_1_0 + 0.00132275132275131*G0_1_0_0_1_1 - 0.000238095238095236*G0_1_0_0_1_2 + 0.00042328042328042*G0_1_0_0_1_3 - 0.000211640211640211*G0_1_0_0_1_4 + 0.00116402116402116*G0_1_0_0_1_5 - 0.000476190476190474*G0_1_0_0_2_0 - 0.000238095238095236*G0_1_0_0_2_1 + 0.00132275132275131*G0_1_0_0_2_2 + 0.000423280423280421*G0_1_0_0_2_3 + 0.00116402116402116*G0_1_0_0_2_4 - 0.00021164021164021*G0_1_0_0_2_5 - 0.000105820105820105*G0_1_0_0_3_0 + 0.00042328042328042*G0_1_0_0_3_1 + 0.000423280423280421*G0_1_0_0_3_2 - 0.00042328042328042*G0_1_0_0_3_3 + 0.000634920634920632*G0_1_0_0_3_4 + 0.00063492063492063*G0_1_0_0_3_5 + 0.000529100529100526*G0_1_0_0_4_0 - 0.000211640211640211*G0_1_0_0_4_1 + 0.00116402116402116*G0_1_0_0_4_2 + 0.000634920634920632*G0_1_0_0_4_3 + 0.00338624338624337*G0_1_0_0_4_4 + 0.000846560846560842*G0_1_0_0_4_5 + 0.000529100529100527*G0_1_0_0_5_0 + 0.00116402116402116*G0_1_0_0_5_1 - 0.00021164021164021*G0_1_0_0_5_2 + 0.00063492063492063*G0_1_0_0_5_3 + 0.000846560846560842*G0_1_0_0_5_4 + 0.00338624338624336*G0_1_0_0_5_5 - 0.000476190476190473*G0_1_0_1_0_0 + 0.00132275132275131*G0_1_0_1_0_1 - 0.000238095238095236*G0_1_0_1_0_2 + 0.00042328042328042*G0_1_0_1_0_3 - 0.000211640211640211*G0_1_0_1_0_4 + 0.00116402116402116*G0_1_0_1_0_5 + 0.00132275132275131*G0_1_0_1_1_0 - 0.0134920634920634*G0_1_0_1_1_1 + 0.000793650793650789*G0_1_0_1_1_2 - 0.00370370370370368*G0_1_0_1_1_3 - 0.000529100529100526*G0_1_0_1_1_4 - 0.00582010582010578*G0_1_0_1_1_5 - 0.000238095238095236*G0_1_0_1_2_0 + 0.000793650793650789*G0_1_0_1_2_1 + 0.000793650793650789*G0_1_0_1_2_2 + 0.000952380952380947*G0_1_0_1_2_3 + 0.000634920634920631*G0_1_0_1_2_4 + 0.000634920634920631*G0_1_0_1_2_5 + 0.00042328042328042*G0_1_0_1_3_0 - 0.00370370370370368*G0_1_0_1_3_1 + 0.000952380952380947*G0_1_0_1_3_2 - 0.0021164021164021*G0_1_0_1_3_3 + 0.000211640211640211*G0_1_0_1_3_4 - 0.0021164021164021*G0_1_0_1_3_5 - 0.000211640211640211*G0_1_0_1_4_0 - 0.000529100529100526*G0_1_0_1_4_1 + 0.000634920634920631*G0_1_0_1_4_2 + 0.000211640211640211*G0_1_0_1_4_3 + 0.00169312169312169*G0_1_0_1_4_4 - 0.000211640211640209*G0_1_0_1_4_5 + 0.00116402116402116*G0_1_0_1_5_0 - 0.00582010582010578*G0_1_0_1_5_1 + 0.000634920634920631*G0_1_0_1_5_2 - 0.0021164021164021*G0_1_0_1_5_3 - 0.00021164021164021*G0_1_0_1_5_4 - 0.00634920634920631*G0_1_0_1_5_5 - 0.000476190476190474*G0_1_0_2_0_0 - 0.000238095238095236*G0_1_0_2_0_1 + 0.00132275132275131*G0_1_0_2_0_2 + 0.000423280423280421*G0_1_0_2_0_3 + 0.00116402116402116*G0_1_0_2_0_4 - 0.00021164021164021*G0_1_0_2_0_5 - 0.000238095238095236*G0_1_0_2_1_0 + 0.000793650793650789*G0_1_0_2_1_1 + 0.000793650793650789*G0_1_0_2_1_2 + 0.000952380952380947*G0_1_0_2_1_3 + 0.000634920634920631*G0_1_0_2_1_4 + 0.000634920634920631*G0_1_0_2_1_5 + 0.00132275132275131*G0_1_0_2_2_0 + 0.000793650793650789*G0_1_0_2_2_1 - 0.0134920634920634*G0_1_0_2_2_2 - 0.00370370370370368*G0_1_0_2_2_3 - 0.00582010582010579*G0_1_0_2_2_4 - 0.000529100529100529*G0_1_0_2_2_5 + 0.000423280423280421*G0_1_0_2_3_0 + 0.000952380952380947*G0_1_0_2_3_1 - 0.00370370370370368*G0_1_0_2_3_2 - 0.00211640211640211*G0_1_0_2_3_3 - 0.00211640211640211*G0_1_0_2_3_4 + 0.000211640211640209*G0_1_0_2_3_5 + 0.00116402116402116*G0_1_0_2_4_0 + 0.000634920634920631*G0_1_0_2_4_1 - 0.00582010582010579*G0_1_0_2_4_2 - 0.00211640211640211*G0_1_0_2_4_3 - 0.00634920634920632*G0_1_0_2_4_4 - 0.000211640211640213*G0_1_0_2_4_5 - 0.00021164021164021*G0_1_0_2_5_0 + 0.000634920634920631*G0_1_0_2_5_1 - 0.000529100529100529*G0_1_0_2_5_2 + 0.000211640211640209*G0_1_0_2_5_3 - 0.000211640211640213*G0_1_0_2_5_4 + 0.00169312169312168*G0_1_0_2_5_5 - 0.000105820105820105*G0_1_0_3_0_0 + 0.00042328042328042*G0_1_0_3_0_1 + 0.000423280423280421*G0_1_0_3_0_2 - 0.00042328042328042*G0_1_0_3_0_3 + 0.000634920634920632*G0_1_0_3_0_4 + 0.00063492063492063*G0_1_0_3_0_5 + 0.00042328042328042*G0_1_0_3_1_0 - 0.00370370370370368*G0_1_0_3_1_1 + 0.000952380952380947*G0_1_0_3_1_2 - 0.0021164021164021*G0_1_0_3_1_3 + 0.000211640211640211*G0_1_0_3_1_4 - 0.0021164021164021*G0_1_0_3_1_5 + 0.000423280423280421*G0_1_0_3_2_0 + 0.000952380952380947*G0_1_0_3_2_1 - 0.00370370370370368*G0_1_0_3_2_2 - 0.00211640211640211*G0_1_0_3_2_3 - 0.00211640211640211*G0_1_0_3_2_4 + 0.000211640211640209*G0_1_0_3_2_5 - 0.00042328042328042*G0_1_0_3_3_0 - 0.0021164021164021*G0_1_0_3_3_1 - 0.00211640211640211*G0_1_0_3_3_2 + 0.0165079365079364*G0_1_0_3_3_3 + 0.000423280423280423*G0_1_0_3_3_4 + 0.000423280423280428*G0_1_0_3_3_5 + 0.000634920634920632*G0_1_0_3_4_0 + 0.000211640211640211*G0_1_0_3_4_1 - 0.00211640211640211*G0_1_0_3_4_2 + 0.000423280423280422*G0_1_0_3_4_3 - 0.00465608465608464*G0_1_0_3_4_4 - 0.000846560846560842*G0_1_0_3_4_5 + 0.00063492063492063*G0_1_0_3_5_0 - 0.0021164021164021*G0_1_0_3_5_1 + 0.000211640211640209*G0_1_0_3_5_2 + 0.000423280423280428*G0_1_0_3_5_3 - 0.000846560846560842*G0_1_0_3_5_4 - 0.00465608465608462*G0_1_0_3_5_5 + 0.000529100529100526*G0_1_0_4_0_0 - 0.000211640211640211*G0_1_0_4_0_1 + 0.00116402116402116*G0_1_0_4_0_2 + 0.000634920634920632*G0_1_0_4_0_3 + 0.00338624338624337*G0_1_0_4_0_4 + 0.000846560846560842*G0_1_0_4_0_5 - 0.000211640211640211*G0_1_0_4_1_0 - 0.000529100529100526*G0_1_0_4_1_1 + 0.000634920634920631*G0_1_0_4_1_2 + 0.000211640211640211*G0_1_0_4_1_3 + 0.00169312169312169*G0_1_0_4_1_4 - 0.000211640211640209*G0_1_0_4_1_5 + 0.00116402116402116*G0_1_0_4_2_0 + 0.000634920634920631*G0_1_0_4_2_1 - 0.00582010582010579*G0_1_0_4_2_2 - 0.00211640211640211*G0_1_0_4_2_3 - 0.00634920634920632*G0_1_0_4_2_4 - 0.000211640211640213*G0_1_0_4_2_5 + 0.000634920634920632*G0_1_0_4_3_0 + 0.000211640211640211*G0_1_0_4_3_1 - 0.00211640211640211*G0_1_0_4_3_2 + 0.000423280423280422*G0_1_0_4_3_3 - 0.00465608465608464*G0_1_0_4_3_4 - 0.000846560846560842*G0_1_0_4_3_5 + 0.00338624338624337*G0_1_0_4_4_0 + 0.00169312169312169*G0_1_0_4_4_1 - 0.00634920634920632*G0_1_0_4_4_2 - 0.00465608465608464*G0_1_0_4_4_3 - 0.0292063492063491*G0_1_0_4_4_4 - 0.00296296296296295*G0_1_0_4_4_5 + 0.000846560846560842*G0_1_0_4_5_0 - 0.00021164021164021*G0_1_0_4_5_1 - 0.000211640211640213*G0_1_0_4_5_2 - 0.000846560846560842*G0_1_0_4_5_3 - 0.00296296296296295*G0_1_0_4_5_4 - 0.00296296296296295*G0_1_0_4_5_5 + 0.000529100529100527*G0_1_0_5_0_0 + 0.00116402116402116*G0_1_0_5_0_1 - 0.00021164021164021*G0_1_0_5_0_2 + 0.00063492063492063*G0_1_0_5_0_3 + 0.000846560846560842*G0_1_0_5_0_4 + 0.00338624338624336*G0_1_0_5_0_5 + 0.00116402116402116*G0_1_0_5_1_0 - 0.00582010582010578*G0_1_0_5_1_1 + 0.000634920634920631*G0_1_0_5_1_2 - 0.0021164021164021*G0_1_0_5_1_3 - 0.00021164021164021*G0_1_0_5_1_4 - 0.00634920634920631*G0_1_0_5_1_5 - 0.00021164021164021*G0_1_0_5_2_0 + 0.000634920634920631*G0_1_0_5_2_1 - 0.00052910052910053*G0_1_0_5_2_2 + 0.000211640211640209*G0_1_0_5_2_3 - 0.000211640211640213*G0_1_0_5_2_4 + 0.00169312169312168*G0_1_0_5_2_5 + 0.00063492063492063*G0_1_0_5_3_0 - 0.0021164021164021*G0_1_0_5_3_1 + 0.000211640211640209*G0_1_0_5_3_2 + 0.000423280423280427*G0_1_0_5_3_3 - 0.000846560846560842*G0_1_0_5_3_4 - 0.00465608465608462*G0_1_0_5_3_5 + 0.000846560846560842*G0_1_0_5_4_0 - 0.000211640211640209*G0_1_0_5_4_1 - 0.000211640211640213*G0_1_0_5_4_2 - 0.000846560846560842*G0_1_0_5_4_3 - 0.00296296296296296*G0_1_0_5_4_4 - 0.00296296296296295*G0_1_0_5_4_5 + 0.00338624338624336*G0_1_0_5_5_0 - 0.00634920634920631*G0_1_0_5_5_1 + 0.00169312169312168*G0_1_0_5_5_2 - 0.00465608465608462*G0_1_0_5_5_3 - 0.00296296296296295*G0_1_0_5_5_4 - 0.029206349206349*G0_1_0_5_5_5;
    A[8] = 0.00396825396825395*G0_0_1_0_0_0 - 0.000476190476190473*G0_0_1_0_0_1 - 0.000476190476190474*G0_0_1_0_0_2 - 0.000105820105820105*G0_0_1_0_0_3 + 0.000529100529100526*G0_0_1_0_0_4 + 0.000529100529100527*G0_0_1_0_0_5 - 0.000476190476190473*G0_0_1_0_1_0 + 0.00132275132275131*G0_0_1_0_1_1 - 0.000238095238095236*G0_0_1_0_1_2 + 0.00042328042328042*G0_0_1_0_1_3 - 0.000211640211640211*G0_0_1_0_1_4 + 0.00116402116402116*G0_0_1_0_1_5 - 0.000476190476190474*G0_0_1_0_2_0 - 0.000238095238095236*G0_0_1_0_2_1 + 0.00132275132275131*G0_0_1_0_2_2 + 0.000423280423280421*G0_0_1_0_2_3 + 0.00116402116402116*G0_0_1_0_2_4 - 0.00021164021164021*G0_0_1_0_2_5 - 0.000105820105820105*G0_0_1_0_3_0 + 0.00042328042328042*G0_0_1_0_3_1 + 0.000423280423280421*G0_0_1_0_3_2 - 0.00042328042328042*G0_0_1_0_3_3 + 0.000634920634920632*G0_0_1_0_3_4 + 0.00063492063492063*G0_0_1_0_3_5 + 0.000529100529100526*G0_0_1_0_4_0 - 0.000211640211640211*G0_0_1_0_4_1 + 0.00116402116402116*G0_0_1_0_4_2 + 0.000634920634920632*G0_0_1_0_4_3 + 0.00338624338624337*G0_0_1_0_4_4 + 0.000846560846560842*G0_0_1_0_4_5 + 0.000529100529100527*G0_0_1_0_5_0 + 0.00116402116402116*G0_0_1_0_5_1 - 0.00021164021164021*G0_0_1_0_5_2 + 0.00063492063492063*G0_0_1_0_5_3 + 0.000846560846560842*G0_0_1_0_5_4 + 0.00338624338624336*G0_0_1_0_5_5 - 0.000476190476190473*G0_0_1_1_0_0 + 0.00132275132275131*G0_0_1_1_0_1 - 0.000238095238095236*G0_0_1_1_0_2 + 0.00042328042328042*G0_0_1_1_0_3 - 0.000211640211640211*G0_0_1_1_0_4 + 0.00116402116402116*G0_0_1_1_0_5 + 0.00132275132275131*G0_0_1_1_1_0 - 0.0134920634920634*G0_0_1_1_1_1 + 0.000793650793650789*G0_0_1_1_1_2 - 0.00370370370370368*G0_0_1_1_1_3 - 0.000529100529100526*G0_0_1_1_1_4 - 0.00582010582010578*G0_0_1_1_1_5 - 0.000238095238095236*G0_0_1_1_2_0 + 0.000793650793650789*G0_0_1_1_2_1 + 0.000793650793650789*G0_0_1_1_2_2 + 0.000952380952380947*G0_0_1_1_2_3 + 0.000634920634920631*G0_0_1_1_2_4 + 0.000634920634920631*G0_0_1_1_2_5 + 0.00042328042328042*G0_0_1_1_3_0 - 0.00370370370370368*G0_0_1_1_3_1 + 0.000952380952380947*G0_0_1_1_3_2 - 0.0021164021164021*G0_0_1_1_3_3 + 0.000211640211640211*G0_0_1_1_3_4 - 0.0021164021164021*G0_0_1_1_3_5 - 0.000211640211640211*G0_0_1_1_4_0 - 0.000529100529100526*G0_0_1_1_4_1 + 0.000634920634920631*G0_0_1_1_4_2 + 0.000211640211640211*G0_0_1_1_4_3 + 0.00169312169312169*G0_0_1_1_4_4 - 0.000211640211640209*G0_0_1_1_4_5 + 0.00116402116402116*G0_0_1_1_5_0 - 0.00582010582010578*G0_0_1_1_5_1 + 0.000634920634920631*G0_0_1_1_5_2 - 0.0021164021164021*G0_0_1_1_5_3 - 0.00021164021164021*G0_0_1_1_5_4 - 0.00634920634920631*G0_0_1_1_5_5 - 0.000476190476190474*G0_0_1_2_0_0 - 0.000238095238095236*G0_0_1_2_0_1 + 0.00132275132275131*G0_0_1_2_0_2 + 0.000423280423280421*G0_0_1_2_0_3 + 0.00116402116402116*G0_0_1_2_0_4 - 0.00021164021164021*G0_0_1_2_0_5 - 0.000238095238095236*G0_0_1_2_1_0 + 0.000793650793650789*G0_0_1_2_1_1 + 0.000793650793650789*G0_0_1_2_1_2 + 0.000952380952380947*G0_0_1_2_1_3 + 0.000634920634920631*G0_0_1_2_1_4 + 0.000634920634920631*G0_0_1_2_1_5 + 0.00132275132275131*G0_0_1_2_2_0 + 0.000793650793650789*G0_0_1_2_2_1 - 0.0134920634920634*G0_0_1_2_2_2 - 0.00370370370370368*G0_0_1_2_2_3 - 0.00582010582010579*G0_0_1_2_2_4 - 0.000529100529100529*G0_0_1_2_2_5 + 0.000423280423280421*G0_0_1_2_3_0 + 0.000952380952380947*G0_0_1_2_3_1 - 0.00370370370370368*G0_0_1_2_3_2 - 0.00211640211640211*G0_0_1_2_3_3 - 0.00211640211640211*G0_0_1_2_3_4 + 0.000211640211640209*G0_0_1_2_3_5 + 0.00116402116402116*G0_0_1_2_4_0 + 0.000634920634920631*G0_0_1_2_4_1 - 0.00582010582010579*G0_0_1_2_4_2 - 0.00211640211640211*G0_0_1_2_4_3 - 0.00634920634920632*G0_0_1_2_4_4 - 0.000211640211640213*G0_0_1_2_4_5 - 0.00021164021164021*G0_0_1_2_5_0 + 0.000634920634920631*G0_0_1_2_5_1 - 0.000529100529100529*G0_0_1_2_5_2 + 0.000211640211640209*G0_0_1_2_5_3 - 0.000211640211640213*G0_0_1_2_5_4 + 0.00169312169312168*G0_0_1_2_5_5 - 0.000105820105820105*G0_0_1_3_0_0 + 0.00042328042328042*G0_0_1_3_0_1 + 0.000423280423280421*G0_0_1_3_0_2 - 0.00042328042328042*G0_0_1_3_0_3 + 0.000634920634920632*G0_0_1_3_0_4 + 0.00063492063492063*G0_0_1_3_0_5 + 0.00042328042328042*G0_0_1_3_1_0 - 0.00370370370370368*G0_0_1_3_1_1 + 0.000952380952380947*G0_0_1_3_1_2 - 0.0021164021164021*G0_0_1_3_1_3 + 0.000211640211640211*G0_0_1_3_1_4 - 0.0021164021164021*G0_0_1_3_1_5 + 0.000423280423280421*G0_0_1_3_2_0 + 0.000952380952380947*G0_0_1_3_2_1 - 0.00370370370370368*G0_0_1_3_2_2 - 0.00211640211640211*G0_0_1_3_2_3 - 0.00211640211640211*G0_0_1_3_2_4 + 0.000211640211640209*G0_0_1_3_2_5 - 0.00042328042328042*G0_0_1_3_3_0 - 0.0021164021164021*G0_0_1_3_3_1 - 0.00211640211640211*G0_0_1_3_3_2 + 0.0165079365079364*G0_0_1_3_3_3 + 0.000423280423280423*G0_0_1_3_3_4 + 0.000423280423280428*G0_0_1_3_3_5 + 0.000634920634920632*G0_0_1_3_4_0 + 0.000211640211640211*G0_0_1_3_4_1 - 0.00211640211640211*G0_0_1_3_4_2 + 0.000423280423280422*G0_0_1_3_4_3 - 0.00465608465608464*G0_0_1_3_4_4 - 0.000846560846560842*G0_0_1_3_4_5 + 0.00063492063492063*G0_0_1_3_5_0 - 0.0021164021164021*G0_0_1_3_5_1 + 0.000211640211640209*G0_0_1_3_5_2 + 0.000423280423280428*G0_0_1_3_5_3 - 0.000846560846560842*G0_0_1_3_5_4 - 0.00465608465608462*G0_0_1_3_5_5 + 0.000529100529100526*G0_0_1_4_0_0 - 0.000211640211640211*G0_0_1_4_0_1 + 0.00116402116402116*G0_0_1_4_0_2 + 0.000634920634920632*G0_0_1_4_0_3 + 0.00338624338624337*G0_0_1_4_0_4 + 0.000846560846560842*G0_0_1_4_0_5 - 0.000211640211640211*G0_0_1_4_1_0 - 0.000529100529100526*G0_0_1_4_1_1 + 0.000634920634920631*G0_0_1_4_1_2 + 0.000211640211640211*G0_0_1_4_1_3 + 0.00169312169312169*G0_0_1_4_1_4 - 0.000211640211640209*G0_0_1_4_1_5 + 0.00116402116402116*G0_0_1_4_2_0 + 0.000634920634920631*G0_0_1_4_2_1 - 0.00582010582010579*G0_0_1_4_2_2 - 0.00211640211640211*G0_0_1_4_2_3 - 0.00634920634920632*G0_0_1_4_2_4 - 0.000211640211640213*G0_0_1_4_2_5 + 0.000634920634920632*G0_0_1_4_3_0 + 0.000211640211640211*G0_0_1_4_3_1 - 0.00211640211640211*G0_0_1_4_3_2 + 0.000423280423280422*G0_0_1_4_3_3 - 0.00465608465608464*G0_0_1_4_3_4 - 0.000846560846560842*G0_0_1_4_3_5 + 0.00338624338624337*G0_0_1_4_4_0 + 0.00169312169312169*G0_0_1_4_4_1 - 0.00634920634920632*G0_0_1_4_4_2 - 0.00465608465608464*G0_0_1_4_4_3 - 0.0292063492063491*G0_0_1_4_4_4 - 0.00296296296296295*G0_0_1_4_4_5 + 0.000846560846560842*G0_0_1_4_5_0 - 0.00021164021164021*G0_0_1_4_5_1 - 0.000211640211640213*G0_0_1_4_5_2 - 0.000846560846560842*G0_0_1_4_5_3 - 0.00296296296296295*G0_0_1_4_5_4 - 0.00296296296296295*G0_0_1_4_5_5 + 0.000529100529100527*G0_0_1_5_0_0 + 0.00116402116402116*G0_0_1_5_0_1 - 0.00021164021164021*G0_0_1_5_0_2 + 0.00063492063492063*G0_0_1_5_0_3 + 0.000846560846560842*G0_0_1_5_0_4 + 0.00338624338624336*G0_0_1_5_0_5 + 0.00116402116402116*G0_0_1_5_1_0 - 0.00582010582010578*G0_0_1_5_1_1 + 0.000634920634920631*G0_0_1_5_1_2 - 0.0021164021164021*G0_0_1_5_1_3 - 0.00021164021164021*G0_0_1_5_1_4 - 0.00634920634920631*G0_0_1_5_1_5 - 0.00021164021164021*G0_0_1_5_2_0 + 0.000634920634920631*G0_0_1_5_2_1 - 0.00052910052910053*G0_0_1_5_2_2 + 0.000211640211640209*G0_0_1_5_2_3 - 0.000211640211640213*G0_0_1_5_2_4 + 0.00169312169312168*G0_0_1_5_2_5 + 0.00063492063492063*G0_0_1_5_3_0 - 0.0021164021164021*G0_0_1_5_3_1 + 0.000211640211640209*G0_0_1_5_3_2 + 0.000423280423280427*G0_0_1_5_3_3 - 0.000846560846560842*G0_0_1_5_3_4 - 0.00465608465608462*G0_0_1_5_3_5 + 0.000846560846560842*G0_0_1_5_4_0 - 0.000211640211640209*G0_0_1_5_4_1 - 0.000211640211640213*G0_0_1_5_4_2 - 0.000846560846560842*G0_0_1_5_4_3 - 0.00296296296296296*G0_0_1_5_4_4 - 0.00296296296296295*G0_0_1_5_4_5 + 0.00338624338624336*G0_0_1_5_5_0 - 0.00634920634920631*G0_0_1_5_5_1 + 0.00169312169312168*G0_0_1_5_5_2 - 0.00465608465608462*G0_0_1_5_5_3 - 0.00296296296296295*G0_0_1_5_5_4 - 0.029206349206349*G0_0_1_5_5_5;
    A[11] = -A[9] - 0.019047619047619*G0_0_0_0_0_0 + 0.000634920634920634*G0_0_0_0_0_1 + 0.00169312169312169*G0_0_0_0_0_2 - 0.00126984126984126*G0_0_0_0_0_3 - 0.0105820105820105*G0_0_0_0_0_4 - 0.00634920634920631*G0_0_0_0_0_5 + 0.000634920634920634*G0_0_0_0_1_0 + 0.0042328042328042*G0_0_0_0_1_1 - 0.000952380952380947*G0_0_0_0_1_2 + 0.0021164021164021*G0_0_0_0_1_3 + 0.000846560846560845*G0_0_0_0_1_4 + 0.00423280423280421*G0_0_0_0_1_5 + 0.00169312169312169*G0_0_0_0_2_0 - 0.000952380952380947*G0_0_0_0_2_1 + 0.00169312169312168*G0_0_0_0_2_2 + 0.000423280423280421*G0_0_0_0_2_3 + 0.00465608465608464*G0_0_0_0_2_4 + 0.000423280423280424*G0_0_0_0_2_5 - 0.00126984126984126*G0_0_0_0_3_0 + 0.0021164021164021*G0_0_0_0_3_1 + 0.000423280423280422*G0_0_0_0_3_2 + 0.00253968253968252*G0_0_0_0_3_3 + 0.00084656084656084*G0_0_0_0_3_4 + 0.00169312169312168*G0_0_0_0_3_5 - 0.0105820105820105*G0_0_0_0_4_0 + 0.000846560846560845*G0_0_0_0_4_1 + 0.00465608465608464*G0_0_0_0_4_2 + 0.00084656084656084*G0_0_0_0_4_3 - 0.00592592592592591*G0_0_0_0_4_4 - 0.00253968253968253*G0_0_0_0_4_5 - 0.00634920634920631*G0_0_0_0_5_0 + 0.00423280423280421*G0_0_0_0_5_1 + 0.000423280423280424*G0_0_0_0_5_2 + 0.00169312169312168*G0_0_0_0_5_3 - 0.00253968253968253*G0_0_0_0_5_4 + 0.00253968253968252*G0_0_0_0_5_5 + 0.000634920634920634*G0_0_0_1_0_0 + 0.0042328042328042*G0_0_0_1_0_1 - 0.000952380952380947*G0_0_0_1_0_2 + 0.0021164021164021*G0_0_0_1_0_3 + 0.000846560846560844*G0_0_0_1_0_4 + 0.00423280423280421*G0_0_0_1_0_5 + 0.0042328042328042*G0_0_0_1_1_0 - 0.0539682539682537*G0_0_0_1_1_1 + 0.00423280423280421*G0_0_0_1_1_2 - 0.0190476190476189*G0_0_0_1_1_3 - 0.00211640211640211*G0_0_0_1_1_4 - 0.0190476190476189*G0_0_0_1_1_5 - 0.000952380952380947*G0_0_0_1_2_0 + 0.00423280423280421*G0_0_0_1_2_1 + 0.000634920634920629*G0_0_0_1_2_2 + 0.00423280423280421*G0_0_0_1_2_3 + 0.000846560846560841*G0_0_0_1_2_4 + 0.00211640211640211*G0_0_0_1_2_5 + 0.0021164021164021*G0_0_0_1_3_0 - 0.0190476190476189*G0_0_0_1_3_1 + 0.00423280423280421*G0_0_0_1_3_2 - 0.0169312169312168*G0_0_0_1_3_3 - 0.00846560846560842*G0_0_0_1_3_5 + 0.000846560846560845*G0_0_0_1_4_0 - 0.00211640211640211*G0_0_0_1_4_1 + 0.000846560846560841*G0_0_0_1_4_2 + 0.00677248677248674*G0_0_0_1_4_4 + 0.00423280423280421*G0_0_0_1_5_0 - 0.0190476190476189*G0_0_0_1_5_1 + 0.00211640211640211*G0_0_0_1_5_2 - 0.00846560846560842*G0_0_0_1_5_3 - 0.0169312169312168*G0_0_0_1_5_5 + 0.00169312169312169*G0_0_0_2_0_0 - 0.000952380952380947*G0_0_0_2_0_1 + 0.00169312169312168*G0_0_0_2_0_2 + 0.000423280423280421*G0_0_0_2_0_3 + 0.00465608465608463*G0_0_0_2_0_4 + 0.000423280423280424*G0_0_0_2_0_5 - 0.000952380952380947*G0_0_0_2_1_0 + 0.00423280423280421*G0_0_0_2_1_1 + 0.000634920634920629*G0_0_0_2_1_2 + 0.00423280423280421*G0_0_0_2_1_3 + 0.000846560846560841*G0_0_0_2_1_4 + 0.00211640211640211*G0_0_0_2_1_5 + 0.00169312169312168*G0_0_0_2_2_0 + 0.000634920634920629*G0_0_0_2_2_1 - 0.0190476190476189*G0_0_0_2_2_2 - 0.00634920634920631*G0_0_0_2_2_3 - 0.0105820105820105*G0_0_0_2_2_4 - 0.00126984126984127*G0_0_0_2_2_5 + 0.000423280423280422*G0_0_0_2_3_0 + 0.00423280423280421*G0_0_0_2_3_1 - 0.00634920634920631*G0_0_0_2_3_2 + 0.00253968253968253*G0_0_0_2_3_3 - 0.00253968253968252*G0_0_0_2_3_4 + 0.00169312169312169*G0_0_0_2_3_5 + 0.00465608465608464*G0_0_0_2_4_0 + 0.000846560846560841*G0_0_0_2_4_1 - 0.0105820105820105*G0_0_0_2_4_2 - 0.00253968253968252*G0_0_0_2_4_3 - 0.0059259259259259*G0_0_0_2_4_4 + 0.000846560846560842*G0_0_0_2_4_5 + 0.000423280423280424*G0_0_0_2_5_0 + 0.00211640211640211*G0_0_0_2_5_1 - 0.00126984126984127*G0_0_0_2_5_2 + 0.00169312169312169*G0_0_0_2_5_3 + 0.000846560846560842*G0_0_0_2_5_4 + 0.00253968253968253*G0_0_0_2_5_5 - 0.00126984126984126*G0_0_0_3_0_0 + 0.0021164021164021*G0_0_0_3_0_1 + 0.000423280423280422*G0_0_0_3_0_2 + 0.00253968253968252*G0_0_0_3_0_3 + 0.00084656084656084*G0_0_0_3_0_4 + 0.00169312169312168*G0_0_0_3_0_5 + 0.0021164021164021*G0_0_0_3_1_0 - 0.0190476190476189*G0_0_0_3_1_1 + 0.00423280423280421*G0_0_0_3_1_2 - 0.0169312169312168*G0_0_0_3_1_3 - 0.00846560846560842*G0_0_0_3_1_5 + 0.000423280423280421*G0_0_0_3_2_0 + 0.00423280423280421*G0_0_0_3_2_1 - 0.00634920634920631*G0_0_0_3_2_2 + 0.00253968253968253*G0_0_0_3_2_3 - 0.00253968253968252*G0_0_0_3_2_4 + 0.00169312169312169*G0_0_0_3_2_5 + 0.00253968253968252*G0_0_0_3_3_0 - 0.0169312169312168*G0_0_0_3_3_1 + 0.00253968253968253*G0_0_0_3_3_2 - 0.0253968253968253*G0_0_0_3_3_3 - 0.00507936507936506*G0_0_0_3_3_4 - 0.00846560846560843*G0_0_0_3_3_5 + 0.00084656084656084*G0_0_0_3_4_0 - 0.00253968253968252*G0_0_0_3_4_2 - 0.00507936507936506*G0_0_0_3_4_3 - 0.0152380952380952*G0_0_0_3_4_4 - 0.00338624338624338*G0_0_0_3_4_5 + 0.00169312169312168*G0_0_0_3_5_0 - 0.00846560846560842*G0_0_0_3_5_1 + 0.00169312169312169*G0_0_0_3_5_2 - 0.00846560846560843*G0_0_0_3_5_3 - 0.00338624338624338*G0_0_0_3_5_4 - 0.00846560846560842*G0_0_0_3_5_5 - 0.0105820105820105*G0_0_0_4_0_0 + 0.000846560846560844*G0_0_0_4_0_1 + 0.00465608465608464*G0_0_0_4_0_2 + 0.00084656084656084*G0_0_0_4_0_3 - 0.00592592592592591*G0_0_0_4_0_4 - 0.00253968253968253*G0_0_0_4_0_5 + 0.000846560846560844*G0_0_0_4_1_0 - 0.00211640211640211*G0_0_0_4_1_1 + 0.000846560846560841*G0_0_0_4_1_2 + 0.00677248677248675*G0_0_0_4_1_4 + 0.00465608465608464*G0_0_0_4_2_0 + 0.000846560846560841*G0_0_0_4_2_1 - 0.0105820105820105*G0_0_0_4_2_2 - 0.00253968253968252*G0_0_0_4_2_3 - 0.0059259259259259*G0_0_0_4_2_4 + 0.000846560846560842*G0_0_0_4_2_5 + 0.00084656084656084*G0_0_0_4_3_0 - 0.00253968253968252*G0_0_0_4_3_2 - 0.00507936507936506*G0_0_0_4_3_3 - 0.0152380952380952*G0_0_0_4_3_4 - 0.00338624338624338*G0_0_0_4_3_5 - 0.00592592592592591*G0_0_0_4_4_0 + 0.00677248677248675*G0_0_0_4_4_1 - 0.0059259259259259*G0_0_0_4_4_2 - 0.0152380952380952*G0_0_0_4_4_3 - 0.116825396825396*G0_0_0_4_4_4 - 0.0152380952380952*G0_0_0_4_4_5 - 0.00253968253968253*G0_0_0_4_5_0 + 0.000846560846560842*G0_0_0_4_5_2 - 0.00338624338624338*G0_0_0_4_5_3 - 0.0152380952380952*G0_0_0_4_5_4 - 0.00507936507936507*G0_0_0_4_5_5 - 0.00634920634920631*G0_0_0_5_0_0 + 0.00423280423280421*G0_0_0_5_0_1 + 0.000423280423280424*G0_0_0_5_0_2 + 0.00169312169312168*G0_0_0_5_0_3 - 0.00253968253968253*G0_0_0_5_0_4 + 0.00253968253968252*G0_0_0_5_0_5 + 0.00423280423280421*G0_0_0_5_1_0 - 0.0190476190476189*G0_0_0_5_1_1 + 0.00211640211640211*G0_0_0_5_1_2 - 0.00846560846560842*G0_0_0_5_1_3 - 0.0169312169312168*G0_0_0_5_1_5 + 0.000423280423280424*G0_0_0_5_2_0 + 0.00211640211640211*G0_0_0_5_2_1 - 0.00126984126984127*G0_0_0_5_2_2 + 0.00169312169312169*G0_0_0_5_2_3 + 0.000846560846560842*G0_0_0_5_2_4 + 0.00253968253968253*G0_0_0_5_2_5 + 0.00169312169312168*G0_0_0_5_3_0 - 0.00846560846560842*G0_0_0_5_3_1 + 0.00169312169312169*G0_0_0_5_3_2 - 0.00846560846560843*G0_0_0_5_3_3 - 0.00338624338624338*G0_0_0_5_3_4 - 0.00846560846560842*G0_0_0_5_3_5 - 0.00253968253968253*G0_0_0_5_4_0 + 0.000846560846560842*G0_0_0_5_4_2 - 0.00338624338624338*G0_0_0_5_4_3 - 0.0152380952380952*G0_0_0_5_4_4 - 0.00507936507936507*G0_0_0_5_4_5 + 0.00253968253968252*G0_0_0_5_5_0 - 0.0169312169312168*G0_0_0_5_5_1 + 0.00253968253968253*G0_0_0_5_5_2 - 0.00846560846560842*G0_0_0_5_5_3 - 0.00507936507936507*G0_0_0_5_5_4 - 0.0253968253968253*G0_0_0_5_5_5;
    A[7] = 0.00396825396825395*G0_0_0_0_0_0 + 0.000476190476190471*G0_0_0_0_0_1 - 0.000582010582010579*G0_0_0_0_0_2 + 0.00116402116402116*G0_0_0_0_0_3 + 0.00264550264550263*G0_0_0_0_0_4 + 0.00264550264550263*G0_0_0_0_0_5 + 0.000476190476190471*G0_0_0_0_1_0 - 0.00396825396825394*G0_0_0_0_1_1 + 0.000608465608465604*G0_0_0_0_1_2 - 0.0021164021164021*G0_0_0_0_1_3 - 0.000423280423280421*G0_0_0_0_1_4 - 0.00370370370370368*G0_0_0_0_1_5 - 0.000582010582010579*G0_0_0_0_2_0 + 0.000608465608465604*G0_0_0_0_2_1 - 0.000582010582010578*G0_0_0_0_2_2 + 0.000846560846560841*G0_0_0_0_2_3 - 0.000740740740740739*G0_0_0_0_2_4 + 0.000846560846560841*G0_0_0_0_2_5 + 0.00116402116402116*G0_0_0_0_3_0 - 0.0021164021164021*G0_0_0_0_3_1 + 0.000846560846560841*G0_0_0_0_3_2 - 0.00550264550264547*G0_0_0_0_3_3 - 0.00148148148148147*G0_0_0_0_3_4 - 0.004021164021164*G0_0_0_0_3_5 + 0.00264550264550263*G0_0_0_0_4_0 - 0.000423280423280421*G0_0_0_0_4_1 - 0.000740740740740739*G0_0_0_0_4_2 - 0.00148148148148147*G0_0_0_0_4_3 + 0.000846560846560845*G0_0_0_0_4_4 - 0.000846560846560841*G0_0_0_0_4_5 + 0.00264550264550263*G0_0_0_0_5_0 - 0.00370370370370368*G0_0_0_0_5_1 + 0.000846560846560841*G0_0_0_0_5_2 - 0.004021164021164*G0_0_0_0_5_3 - 0.000846560846560841*G0_0_0_0_5_4 - 0.00761904761904757*G0_0_0_0_5_5 + 0.000476190476190471*G0_0_0_1_0_0 - 0.00396825396825394*G0_0_0_1_0_1 + 0.000608465608465604*G0_0_0_1_0_2 - 0.0021164021164021*G0_0_0_1_0_3 - 0.000423280423280421*G0_0_0_1_0_4 - 0.00370370370370368*G0_0_0_1_0_5 - 0.00396825396825394*G0_0_0_1_1_0 + 0.045238095238095*G0_0_0_1_1_1 - 0.00396825396825395*G0_0_0_1_1_2 + 0.0174603174603174*G0_0_0_1_1_3 + 0.00158730158730158*G0_0_0_1_1_4 + 0.0174603174603174*G0_0_0_1_1_5 + 0.000608465608465604*G0_0_0_1_2_0 - 0.00396825396825395*G0_0_0_1_2_1 + 0.000476190476190474*G0_0_0_1_2_2 - 0.00370370370370368*G0_0_0_1_2_3 - 0.000423280423280421*G0_0_0_1_2_4 - 0.00211640211640211*G0_0_0_1_2_5 - 0.0021164021164021*G0_0_0_1_3_0 + 0.0174603174603174*G0_0_0_1_3_1 - 0.00370370370370368*G0_0_0_1_3_2 + 0.0169312169312168*G0_0_0_1_3_3 + 0.00105820105820105*G0_0_0_1_3_4 + 0.00846560846560842*G0_0_0_1_3_5 - 0.000423280423280421*G0_0_0_1_4_0 + 0.00158730158730158*G0_0_0_1_4_1 - 0.000423280423280421*G0_0_0_1_4_2 + 0.00105820105820105*G0_0_0_1_4_3 - 0.00126984126984127*G0_0_0_1_4_4 + 0.00105820105820105*G0_0_0_1_4_5 - 0.00370370370370368*G0_0_0_1_5_0 + 0.0174603174603174*G0_0_0_1_5_1 - 0.00211640211640211*G0_0_0_1_5_2 + 0.00846560846560842*G0_0_0_1_5_3 + 0.00105820105820105*G0_0_0_1_5_4 + 0.0169312169312168*G0_0_0_1_5_5 - 0.000582010582010579*G0_0_0_2_0_0 + 0.000608465608465604*G0_0_0_2_0_1 - 0.000582010582010578*G0_0_0_2_0_2 + 0.000846560846560841*G0_0_0_2_0_3 - 0.000740740740740738*G0_0_0_2_0_4 + 0.000846560846560841*G0_0_0_2_0_5 + 0.000608465608465604*G0_0_0_2_1_0 - 0.00396825396825395*G0_0_0_2_1_1 + 0.000476190476190474*G0_0_0_2_1_2 - 0.00370370370370368*G0_0_0_2_1_3 - 0.000423280423280421*G0_0_0_2_1_4 - 0.00211640211640211*G0_0_0_2_1_5 - 0.000582010582010578*G0_0_0_2_2_0 + 0.000476190476190474*G0_0_0_2_2_1 + 0.00396825396825395*G0_0_0_2_2_2 + 0.00264550264550263*G0_0_0_2_2_3 + 0.00264550264550263*G0_0_0_2_2_4 + 0.00116402116402116*G0_0_0_2_2_5 + 0.000846560846560841*G0_0_0_2_3_0 - 0.00370370370370368*G0_0_0_2_3_1 + 0.00264550264550263*G0_0_0_2_3_2 - 0.00761904761904758*G0_0_0_2_3_3 - 0.000846560846560843*G0_0_0_2_3_4 - 0.004021164021164*G0_0_0_2_3_5 - 0.000740740740740738*G0_0_0_2_4_0 - 0.000423280423280421*G0_0_0_2_4_1 + 0.00264550264550263*G0_0_0_2_4_2 - 0.000846560846560844*G0_0_0_2_4_3 + 0.000846560846560844*G0_0_0_2_4_4 - 0.00148148148148148*G0_0_0_2_4_5 + 0.000846560846560841*G0_0_0_2_5_0 - 0.00211640211640211*G0_0_0_2_5_1 + 0.00116402116402116*G0_0_0_2_5_2 - 0.004021164021164*G0_0_0_2_5_3 - 0.00148148148148148*G0_0_0_2_5_4 - 0.00550264550264548*G0_0_0_2_5_5 + 0.00116402116402116*G0_0_0_3_0_0 - 0.0021164021164021*G0_0_0_3_0_1 + 0.000846560846560841*G0_0_0_3_0_2 - 0.00550264550264547*G0_0_0_3_0_3 - 0.00148148148148147*G0_0_0_3_0_4 - 0.004021164021164*G0_0_0_3_0_5 - 0.0021164021164021*G0_0_0_3_1_0 + 0.0174603174603174*G0_0_0_3_1_1 - 0.00370370370370368*G0_0_0_3_1_2 + 0.0169312169312168*G0_0_0_3_1_3 + 0.00105820105820105*G0_0_0_3_1_4 + 0.00846560846560842*G0_0_0_3_1_5 + 0.000846560846560841*G0_0_0_3_2_0 - 0.00370370370370368*G0_0_0_3_2_1 + 0.00264550264550263*G0_0_0_3_2_2 - 0.00761904761904758*G0_0_0_3_2_3 - 0.000846560846560843*G0_0_0_3_2_4 - 0.004021164021164*G0_0_0_3_2_5 - 0.00550264550264547*G0_0_0_3_3_0 + 0.0169312169312168*G0_0_0_3_3_1 - 0.00761904761904758*G0_0_0_3_3_2 + 0.0571428571428569*G0_0_0_3_3_3 + 0.00888888888888885*G0_0_0_3_3_4 + 0.019047619047619*G0_0_0_3_3_5 - 0.00148148148148147*G0_0_0_3_4_0 + 0.00105820105820105*G0_0_0_3_4_1 - 0.000846560846560843*G0_0_0_3_4_2 + 0.00888888888888885*G0_0_0_3_4_3 + 0.00550264550264548*G0_0_0_3_4_4 + 0.0059259259259259*G0_0_0_3_4_5 - 0.004021164021164*G0_0_0_3_5_0 + 0.00846560846560842*G0_0_0_3_5_1 - 0.004021164021164*G0_0_0_3_5_2 + 0.019047619047619*G0_0_0_3_5_3 + 0.0059259259259259*G0_0_0_3_5_4 + 0.019047619047619*G0_0_0_3_5_5 + 0.00264550264550263*G0_0_0_4_0_0 - 0.000423280423280421*G0_0_0_4_0_1 - 0.000740740740740738*G0_0_0_4_0_2 - 0.00148148148148147*G0_0_0_4_0_3 + 0.000846560846560845*G0_0_0_4_0_4 - 0.000846560846560841*G0_0_0_4_0_5 - 0.000423280423280421*G0_0_0_4_1_0 + 0.00158730158730158*G0_0_0_4_1_1 - 0.000423280423280421*G0_0_0_4_1_2 + 0.00105820105820105*G0_0_0_4_1_3 - 0.00126984126984127*G0_0_0_4_1_4 + 0.00105820105820105*G0_0_0_4_1_5 - 0.000740740740740738*G0_0_0_4_2_0 - 0.000423280423280421*G0_0_0_4_2_1 + 0.00264550264550263*G0_0_0_4_2_2 - 0.000846560846560843*G0_0_0_4_2_3 + 0.000846560846560844*G0_0_0_4_2_4 - 0.00148148148148148*G0_0_0_4_2_5 - 0.00148148148148147*G0_0_0_4_3_0 + 0.00105820105820105*G0_0_0_4_3_1 - 0.000846560846560843*G0_0_0_4_3_2 + 0.00888888888888885*G0_0_0_4_3_3 + 0.00550264550264548*G0_0_0_4_3_4 + 0.0059259259259259*G0_0_0_4_3_5 + 0.000846560846560845*G0_0_0_4_4_0 - 0.00126984126984127*G0_0_0_4_4_1 + 0.000846560846560844*G0_0_0_4_4_2 + 0.00550264550264548*G0_0_0_4_4_3 + 0.0266666666666666*G0_0_0_4_4_4 + 0.00550264550264549*G0_0_0_4_4_5 - 0.000846560846560841*G0_0_0_4_5_0 + 0.00105820105820105*G0_0_0_4_5_1 - 0.00148148148148148*G0_0_0_4_5_2 + 0.0059259259259259*G0_0_0_4_5_3 + 0.00550264550264549*G0_0_0_4_5_4 + 0.00888888888888885*G0_0_0_4_5_5 + 0.00264550264550263*G0_0_0_5_0_0 - 0.00370370370370368*G0_0_0_5_0_1 + 0.000846560846560841*G0_0_0_5_0_2 - 0.004021164021164*G0_0_0_5_0_3 - 0.000846560846560841*G0_0_0_5_0_4 - 0.00761904761904757*G0_0_0_5_0_5 - 0.00370370370370368*G0_0_0_5_1_0 + 0.0174603174603174*G0_0_0_5_1_1 - 0.00211640211640211*G0_0_0_5_1_2 + 0.00846560846560842*G0_0_0_5_1_3 + 0.00105820105820105*G0_0_0_5_1_4 + 0.0169312169312168*G0_0_0_5_1_5 + 0.000846560846560841*G0_0_0_5_2_0 - 0.00211640211640211*G0_0_0_5_2_1 + 0.00116402116402116*G0_0_0_5_2_2 - 0.00402116402116401*G0_0_0_5_2_3 - 0.00148148148148148*G0_0_0_5_2_4 - 0.00550264550264548*G0_0_0_5_2_5 - 0.004021164021164*G0_0_0_5_3_0 + 0.00846560846560842*G0_0_0_5_3_1 - 0.00402116402116401*G0_0_0_5_3_2 + 0.019047619047619*G0_0_0_5_3_3 + 0.0059259259259259*G0_0_0_5_3_4 + 0.019047619047619*G0_0_0_5_3_5 - 0.000846560846560841*G0_0_0_5_4_0 + 0.00105820105820105*G0_0_0_5_4_1 - 0.00148148148148148*G0_0_0_5_4_2 + 0.0059259259259259*G0_0_0_5_4_3 + 0.00550264550264549*G0_0_0_5_4_4 + 0.00888888888888885*G0_0_0_5_4_5 - 0.00761904761904757*G0_0_0_5_5_0 + 0.0169312169312168*G0_0_0_5_5_1 - 0.00550264550264548*G0_0_0_5_5_2 + 0.019047619047619*G0_0_0_5_5_3 + 0.00888888888888885*G0_0_0_5_5_4 + 0.0571428571428568*G0_0_0_5_5_5;
    A[34] = -A[8] - 0.0063492063492063*G0_0_0_0_0_0 + 0.00084656084656084*G0_0_0_0_0_1 + 0.000846560846560842*G0_0_0_0_0_2 + 0.000423280423280418*G0_0_0_0_0_3 - 0.00634920634920632*G0_0_0_0_0_4 - 0.0021164021164021*G0_0_0_0_0_5 + 0.00084656084656084*G0_0_0_0_1_0 - 0.000846560846560838*G0_0_0_0_1_1 - 0.00042328042328042*G0_0_0_0_1_3 + 0.000423280423280423*G0_0_0_0_1_4 + 0.000846560846560842*G0_0_0_0_2_0 + 0.000846560846560842*G0_0_0_0_2_3 + 0.00338624338624337*G0_0_0_0_2_4 + 0.00126984126984126*G0_0_0_0_2_5 + 0.000423280423280418*G0_0_0_0_3_0 - 0.00042328042328042*G0_0_0_0_3_1 + 0.000846560846560842*G0_0_0_0_3_2 - 0.00846560846560841*G0_0_0_0_3_3 - 0.00169312169312168*G0_0_0_0_3_4 - 0.00338624338624337*G0_0_0_0_3_5 - 0.00634920634920632*G0_0_0_0_4_0 + 0.000423280423280423*G0_0_0_0_4_1 + 0.00338624338624337*G0_0_0_0_4_2 - 0.00169312169312168*G0_0_0_0_4_3 - 0.00507936507936506*G0_0_0_0_4_4 - 0.00338624338624337*G0_0_0_0_4_5 - 0.0021164021164021*G0_0_0_0_5_0 + 0.00126984126984126*G0_0_0_0_5_2 - 0.00338624338624337*G0_0_0_0_5_3 - 0.00338624338624337*G0_0_0_0_5_4 - 0.00507936507936504*G0_0_0_0_5_5 + 0.000846560846560841*G0_0_0_1_0_0 - 0.000846560846560838*G0_0_0_1_0_1 - 0.00042328042328042*G0_0_0_1_0_3 + 0.000423280423280423*G0_0_0_1_0_4 - 0.000846560846560838*G0_0_0_1_1_0 + 0.00634920634920628*G0_0_0_1_1_1 - 0.000846560846560841*G0_0_0_1_1_2 + 0.00634920634920631*G0_0_0_1_1_3 - 0.000423280423280422*G0_0_0_1_1_4 + 0.00211640211640209*G0_0_0_1_1_5 - 0.000846560846560841*G0_0_0_1_2_1 - 0.00338624338624337*G0_0_0_1_2_3 - 0.000846560846560843*G0_0_0_1_2_4 - 0.00126984126984126*G0_0_0_1_2_5 - 0.00042328042328042*G0_0_0_1_3_0 + 0.00634920634920631*G0_0_0_1_3_1 - 0.00338624338624337*G0_0_0_1_3_2 + 0.00507936507936506*G0_0_0_1_3_3 + 0.00169312169312169*G0_0_0_1_3_4 + 0.00338624338624337*G0_0_0_1_3_5 + 0.000423280423280423*G0_0_0_1_4_0 - 0.000423280423280422*G0_0_0_1_4_1 - 0.000846560846560843*G0_0_0_1_4_2 + 0.00169312169312169*G0_0_0_1_4_3 + 0.00846560846560842*G0_0_0_1_4_4 + 0.00338624338624337*G0_0_0_1_4_5 + 0.00211640211640209*G0_0_0_1_5_1 - 0.00126984126984126*G0_0_0_1_5_2 + 0.00338624338624337*G0_0_0_1_5_3 + 0.00338624338624337*G0_0_0_1_5_4 + 0.00507936507936504*G0_0_0_1_5_5 + 0.000846560846560842*G0_0_0_2_0_0 + 0.000846560846560842*G0_0_0_2_0_3 + 0.00338624338624337*G0_0_0_2_0_4 + 0.00126984126984126*G0_0_0_2_0_5 - 0.000846560846560841*G0_0_0_2_1_1 - 0.00338624338624337*G0_0_0_2_1_3 - 0.000846560846560843*G0_0_0_2_1_4 - 0.00126984126984126*G0_0_0_2_1_5 + 0.00423280423280421*G0_0_0_2_2_3 - 0.00423280423280421*G0_0_0_2_2_4 + 0.000846560846560842*G0_0_0_2_3_0 - 0.00338624338624337*G0_0_0_2_3_1 + 0.00423280423280421*G0_0_0_2_3_2 - 0.00169312169312168*G0_0_0_2_3_5 + 0.00338624338624337*G0_0_0_2_4_0 - 0.000846560846560843*G0_0_0_2_4_1 - 0.00423280423280421*G0_0_0_2_4_2 + 0.00169312169312168*G0_0_0_2_4_5 + 0.00126984126984126*G0_0_0_2_5_0 - 0.00126984126984126*G0_0_0_2_5_1 - 0.00169312169312168*G0_0_0_2_5_3 + 0.00169312169312168*G0_0_0_2_5_4 + 0.000423280423280418*G0_0_0_3_0_0 - 0.00042328042328042*G0_0_0_3_0_1 + 0.000846560846560843*G0_0_0_3_0_2 - 0.00846560846560841*G0_0_0_3_0_3 - 0.00169312169312168*G0_0_0_3_0_4 - 0.00338624338624337*G0_0_0_3_0_5 - 0.00042328042328042*G0_0_0_3_1_0 + 0.00634920634920631*G0_0_0_3_1_1 - 0.00338624338624337*G0_0_0_3_1_2 + 0.00507936507936506*G0_0_0_3_1_3 + 0.00169312169312169*G0_0_0_3_1_4 + 0.00338624338624337*G0_0_0_3_1_5 + 0.000846560846560843*G0_0_0_3_2_0 - 0.00338624338624337*G0_0_0_3_2_1 + 0.00423280423280421*G0_0_0_3_2_2 - 0.00169312169312168*G0_0_0_3_2_5 - 0.00846560846560841*G0_0_0_3_3_0 + 0.00507936507936506*G0_0_0_3_3_1 + 0.121904761904761*G0_0_0_3_3_3 + 0.0135449735449735*G0_0_0_3_3_4 + 0.0203174603174602*G0_0_0_3_3_5 - 0.00169312169312168*G0_0_0_3_4_0 + 0.00169312169312169*G0_0_0_3_4_1 + 0.0135449735449735*G0_0_0_3_4_3 - 0.0135449735449735*G0_0_0_3_4_4 - 0.00338624338624337*G0_0_0_3_5_0 + 0.00338624338624337*G0_0_0_3_5_1 - 0.00169312169312168*G0_0_0_3_5_2 + 0.0203174603174602*G0_0_0_3_5_3 + 0.00677248677248674*G0_0_0_3_5_5 - 0.00634920634920632*G0_0_0_4_0_0 + 0.000423280423280423*G0_0_0_4_0_1 + 0.00338624338624337*G0_0_0_4_0_2 - 0.00169312169312168*G0_0_0_4_0_3 - 0.00507936507936506*G0_0_0_4_0_4 - 0.00338624338624337*G0_0_0_4_0_5 + 0.000423280423280423*G0_0_0_4_1_0 - 0.000423280423280421*G0_0_0_4_1_1 - 0.000846560846560843*G0_0_0_4_1_2 + 0.00169312169312169*G0_0_0_4_1_3 + 0.00846560846560842*G0_0_0_4_1_4 + 0.00338624338624337*G0_0_0_4_1_5 + 0.00338624338624337*G0_0_0_4_2_0 - 0.000846560846560843*G0_0_0_4_2_1 - 0.00423280423280421*G0_0_0_4_2_2 + 0.00169312169312168*G0_0_0_4_2_5 - 0.00169312169312168*G0_0_0_4_3_0 + 0.00169312169312169*G0_0_0_4_3_1 + 0.0135449735449735*G0_0_0_4_3_3 - 0.0135449735449735*G0_0_0_4_3_4 - 0.00507936507936506*G0_0_0_4_4_0 + 0.00846560846560842*G0_0_0_4_4_1 - 0.0135449735449735*G0_0_0_4_4_3 - 0.121904761904761*G0_0_0_4_4_4 - 0.0203174603174602*G0_0_0_4_4_5 - 0.00338624338624337*G0_0_0_4_5_0 + 0.00338624338624337*G0_0_0_4_5_1 + 0.00169312169312169*G0_0_0_4_5_2 - 0.0203174603174602*G0_0_0_4_5_4 - 0.00677248677248674*G0_0_0_4_5_5 - 0.0021164021164021*G0_0_0_5_0_0 + 0.00126984126984126*G0_0_0_5_0_2 - 0.00338624338624337*G0_0_0_5_0_3 - 0.00338624338624337*G0_0_0_5_0_4 - 0.00507936507936504*G0_0_0_5_0_5 + 0.00211640211640209*G0_0_0_5_1_1 - 0.00126984126984126*G0_0_0_5_1_2 + 0.00338624338624337*G0_0_0_5_1_3 + 0.00338624338624337*G0_0_0_5_1_4 + 0.00507936507936504*G0_0_0_5_1_5 + 0.00126984126984126*G0_0_0_5_2_0 - 0.00126984126984126*G0_0_0_5_2_1 - 0.00169312169312168*G0_0_0_5_2_3 + 0.00169312169312168*G0_0_0_5_2_4 - 0.00338624338624337*G0_0_0_5_3_0 + 0.00338624338624337*G0_0_0_5_3_1 - 0.00169312169312168*G0_0_0_5_3_2 + 0.0203174603174602*G0_0_0_5_3_3 + 0.00677248677248674*G0_0_0_5_3_5 - 0.00338624338624337*G0_0_0_5_4_0 + 0.00338624338624337*G0_0_0_5_4_1 + 0.00169312169312169*G0_0_0_5_4_2 - 0.0203174603174602*G0_0_0_5_4_4 - 0.00677248677248674*G0_0_0_5_4_5 - 0.00507936507936504*G0_0_0_5_5_0 + 0.00507936507936504*G0_0_0_5_5_1 + 0.00677248677248674*G0_0_0_5_5_3 - 0.00677248677248674*G0_0_0_5_5_4 + 0.0801587301587298*G0_0_1_0_0_0 - 0.007037037037037*G0_0_1_0_0_1 - 0.007037037037037*G0_0_1_0_0_2 + 0.00243386243386243*G0_0_1_0_0_3 + 0.0280423280423279*G0_0_1_0_0_4 + 0.0280423280423279*G0_0_1_0_0_5 - 0.007037037037037*G0_0_1_0_1_0 + 0.00280423280423279*G0_0_1_0_1_1 + 0.000608465608465606*G0_0_1_0_1_2 - 0.00359788359788358*G0_0_1_0_1_4 - 0.00349206349206348*G0_0_1_0_1_5 - 0.007037037037037*G0_0_1_0_2_0 + 0.000608465608465607*G0_0_1_0_2_1 + 0.00280423280423279*G0_0_1_0_2_2 - 0.00349206349206348*G0_0_1_0_2_4 - 0.00359788359788358*G0_0_1_0_2_5 + 0.00243386243386243*G0_0_1_0_3_0 - 0.00550264550264546*G0_0_1_0_3_3 + 0.00232804232804232*G0_0_1_0_3_4 + 0.00232804232804232*G0_0_1_0_3_5 + 0.0280423280423279*G0_0_1_0_4_0 - 0.00359788359788358*G0_0_1_0_4_1 - 0.00349206349206348*G0_0_1_0_4_2 + 0.00232804232804232*G0_0_1_0_4_3 + 0.032169312169312*G0_0_1_0_4_4 + 0.0143915343915343*G0_0_1_0_4_5 + 0.0280423280423279*G0_0_1_0_5_0 - 0.00349206349206348*G0_0_1_0_5_1 - 0.00359788359788358*G0_0_1_0_5_2 + 0.00232804232804232*G0_0_1_0_5_3 + 0.0143915343915343*G0_0_1_0_5_4 + 0.032169312169312*G0_0_1_0_5_5 - 0.007037037037037*G0_0_1_1_0_0 + 0.00280423280423279*G0_0_1_1_0_1 + 0.000608465608465606*G0_0_1_1_0_2 - 0.00359788359788358*G0_0_1_1_0_4 - 0.00349206349206348*G0_0_1_1_0_5 + 0.00280423280423279*G0_0_1_1_1_0 - 0.0134920634920634*G0_0_1_1_1_1 + 0.000158730158730159*G0_0_1_1_1_2 + 0.000529100529100523*G0_0_1_1_1_3 + 0.000740740740740738*G0_0_1_1_1_4 - 0.00582010582010579*G0_0_1_1_1_5 + 0.000608465608465606*G0_0_1_1_2_0 + 0.000158730158730159*G0_0_1_1_2_1 + 0.000158730158730157*G0_0_1_1_2_2 - 0.00116402116402116*G0_0_1_1_2_3 + 0.0019047619047619*G0_0_1_1_2_4 + 0.0019047619047619*G0_0_1_1_2_5 + 0.000529100529100523*G0_0_1_1_3_1 - 0.00116402116402116*G0_0_1_1_3_2 - 0.000423280423280422*G0_0_1_1_3_3 - 0.00148148148148148*G0_0_1_1_3_4 - 0.00380952380952379*G0_0_1_1_3_5 - 0.00359788359788358*G0_0_1_1_4_0 + 0.000740740740740738*G0_0_1_1_4_1 + 0.0019047619047619*G0_0_1_1_4_2 - 0.00148148148148148*G0_0_1_1_4_3 - 0.00338624338624338*G0_0_1_1_4_4 - 0.00529100529100527*G0_0_1_1_4_5 - 0.00349206349206348*G0_0_1_1_5_0 - 0.00582010582010579*G0_0_1_1_5_1 + 0.0019047619047619*G0_0_1_1_5_2 - 0.00380952380952379*G0_0_1_1_5_3 - 0.00529100529100527*G0_0_1_1_5_4 - 0.0215873015873015*G0_0_1_1_5_5 - 0.007037037037037*G0_0_1_2_0_0 + 0.000608465608465606*G0_0_1_2_0_1 + 0.00280423280423279*G0_0_1_2_0_2 - 0.00349206349206348*G0_0_1_2_0_4 - 0.00359788359788358*G0_0_1_2_0_5 + 0.000608465608465606*G0_0_1_2_1_0 + 0.000158730158730159*G0_0_1_2_1_1 + 0.000158730158730157*G0_0_1_2_1_2 - 0.00116402116402116*G0_0_1_2_1_3 + 0.0019047619047619*G0_0_1_2_1_4 + 0.0019047619047619*G0_0_1_2_1_5 + 0.00280423280423279*G0_0_1_2_2_0 + 0.000158730158730157*G0_0_1_2_2_1 - 0.0134920634920634*G0_0_1_2_2_2 + 0.000529100529100524*G0_0_1_2_2_3 - 0.00582010582010579*G0_0_1_2_2_4 + 0.000740740740740736*G0_0_1_2_2_5 - 0.00116402116402116*G0_0_1_2_3_1 + 0.000529100529100522*G0_0_1_2_3_2 - 0.000423280423280424*G0_0_1_2_3_3 - 0.00380952380952379*G0_0_1_2_3_4 - 0.00148148148148147*G0_0_1_2_3_5 - 0.00349206349206348*G0_0_1_2_4_0 + 0.0019047619047619*G0_0_1_2_4_1 - 0.00582010582010579*G0_0_1_2_4_2 - 0.00380952380952379*G0_0_1_2_4_3 - 0.0215873015873015*G0_0_1_2_4_4 - 0.00529100529100527*G0_0_1_2_4_5 - 0.00359788359788358*G0_0_1_2_5_0 + 0.0019047619047619*G0_0_1_2_5_1 + 0.000740740740740736*G0_0_1_2_5_2 - 0.00148148148148148*G0_0_1_2_5_3 - 0.00529100529100527*G0_0_1_2_5_4 - 0.00338624338624337*G0_0_1_2_5_5 + 0.00243386243386243*G0_0_1_3_0_0 - 0.00550264550264546*G0_0_1_3_0_3 + 0.00232804232804232*G0_0_1_3_0_4 + 0.00232804232804232*G0_0_1_3_0_5 + 0.000529100529100524*G0_0_1_3_1_1 - 0.00116402116402116*G0_0_1_3_1_2 - 0.000423280423280422*G0_0_1_3_1_3 - 0.00148148148148148*G0_0_1_3_1_4 - 0.00380952380952379*G0_0_1_3_1_5 - 0.00116402116402116*G0_0_1_3_2_1 + 0.000529100529100523*G0_0_1_3_2_2 - 0.000423280423280425*G0_0_1_3_2_3 - 0.00380952380952379*G0_0_1_3_2_4 - 0.00148148148148148*G0_0_1_3_2_5 - 0.00550264550264546*G0_0_1_3_3_0 - 0.000423280423280421*G0_0_1_3_3_1 - 0.000423280423280425*G0_0_1_3_3_2 + 0.118095238095237*G0_0_1_3_3_3 + 0.0139682539682539*G0_0_1_3_3_4 + 0.0139682539682539*G0_0_1_3_3_5 + 0.00232804232804232*G0_0_1_3_4_0 - 0.00148148148148148*G0_0_1_3_4_1 - 0.00380952380952379*G0_0_1_3_4_2 + 0.0139682539682539*G0_0_1_3_4_3 + 0.00211640211640211*G0_0_1_3_4_4 + 0.0059259259259259*G0_0_1_3_4_5 + 0.00232804232804232*G0_0_1_3_5_0 - 0.00380952380952379*G0_0_1_3_5_1 - 0.00148148148148148*G0_0_1_3_5_2 + 0.0139682539682539*G0_0_1_3_5_3 + 0.0059259259259259*G0_0_1_3_5_4 + 0.00211640211640212*G0_0_1_3_5_5 + 0.0280423280423279*G0_0_1_4_0_0 - 0.00359788359788358*G0_0_1_4_0_1 - 0.00349206349206348*G0_0_1_4_0_2 + 0.00232804232804232*G0_0_1_4_0_3 + 0.032169312169312*G0_0_1_4_0_4 + 0.0143915343915343*G0_0_1_4_0_5 - 0.00359788359788358*G0_0_1_4_1_0 + 0.000740740740740738*G0_0_1_4_1_1 + 0.0019047619047619*G0_0_1_4_1_2 - 0.00148148148148148*G0_0_1_4_1_3 - 0.00338624338624338*G0_0_1_4_1_4 - 0.00529100529100527*G0_0_1_4_1_5 - 0.00349206349206348*G0_0_1_4_2_0 + 0.0019047619047619*G0_0_1_4_2_1 - 0.00582010582010579*G0_0_1_4_2_2 - 0.00380952380952379*G0_0_1_4_2_3 - 0.0215873015873015*G0_0_1_4_2_4 - 0.00529100529100527*G0_0_1_4_2_5 + 0.00232804232804232*G0_0_1_4_3_0 - 0.00148148148148148*G0_0_1_4_3_1 - 0.00380952380952379*G0_0_1_4_3_2 + 0.0139682539682539*G0_0_1_4_3_3 + 0.00211640211640211*G0_0_1_4_3_4 + 0.0059259259259259*G0_0_1_4_3_5 + 0.032169312169312*G0_0_1_4_4_0 - 0.00338624338624338*G0_0_1_4_4_1 - 0.0215873015873015*G0_0_1_4_4_2 + 0.00211640211640211*G0_0_1_4_4_3 + 0.0114285714285714*G0_0_1_4_4_4 + 0.0173544973544973*G0_0_1_4_4_5 + 0.0143915343915343*G0_0_1_4_5_0 - 0.00529100529100527*G0_0_1_4_5_1 - 0.00529100529100527*G0_0_1_4_5_2 + 0.0059259259259259*G0_0_1_4_5_3 + 0.0173544973544973*G0_0_1_4_5_4 + 0.0173544973544973*G0_0_1_4_5_5 + 0.0280423280423279*G0_0_1_5_0_0 - 0.00349206349206348*G0_0_1_5_0_1 - 0.00359788359788358*G0_0_1_5_0_2 + 0.00232804232804232*G0_0_1_5_0_3 + 0.0143915343915343*G0_0_1_5_0_4 + 0.032169312169312*G0_0_1_5_0_5 - 0.00349206349206348*G0_0_1_5_1_0 - 0.00582010582010579*G0_0_1_5_1_1 + 0.0019047619047619*G0_0_1_5_1_2 - 0.00380952380952379*G0_0_1_5_1_3 - 0.00529100529100527*G0_0_1_5_1_4 - 0.0215873015873015*G0_0_1_5_1_5 - 0.00359788359788358*G0_0_1_5_2_0 + 0.0019047619047619*G0_0_1_5_2_1 + 0.000740740740740736*G0_0_1_5_2_2 - 0.00148148148148147*G0_0_1_5_2_3 - 0.00529100529100527*G0_0_1_5_2_4 - 0.00338624338624337*G0_0_1_5_2_5 + 0.00232804232804232*G0_0_1_5_3_0 - 0.00380952380952379*G0_0_1_5_3_1 - 0.00148148148148147*G0_0_1_5_3_2 + 0.0139682539682539*G0_0_1_5_3_3 + 0.0059259259259259*G0_0_1_5_3_4 + 0.00211640211640212*G0_0_1_5_3_5 + 0.0143915343915343*G0_0_1_5_4_0 - 0.00529100529100527*G0_0_1_5_4_1 - 0.00529100529100527*G0_0_1_5_4_2 + 0.0059259259259259*G0_0_1_5_4_3 + 0.0173544973544973*G0_0_1_5_4_4 + 0.0173544973544973*G0_0_1_5_4_5 + 0.032169312169312*G0_0_1_5_5_0 - 0.0215873015873015*G0_0_1_5_5_1 - 0.00338624338624337*G0_0_1_5_5_2 + 0.00211640211640212*G0_0_1_5_5_3 + 0.0173544973544973*G0_0_1_5_5_4 + 0.0114285714285713*G0_0_1_5_5_5 - 0.000211640211640211*G0_1_0_0_0_1 - 0.000211640211640211*G0_1_0_0_0_2 + 0.00253968253968252*G0_1_0_0_0_3 + 0.0021164021164021*G0_1_0_0_0_4 + 0.0021164021164021*G0_1_0_0_0_5 - 0.000211640211640211*G0_1_0_0_1_0 - 0.00105820105820105*G0_1_0_0_1_1 + 0.00042328042328042*G0_1_0_0_1_2 + 0.000423280423280422*G0_1_0_0_1_3 + 0.000846560846560841*G0_1_0_0_1_4 - 0.000423280423280417*G0_1_0_0_1_5 - 0.000211640211640211*G0_1_0_0_2_0 + 0.00042328042328042*G0_1_0_0_2_1 - 0.00105820105820105*G0_1_0_0_2_2 + 0.000423280423280422*G0_1_0_0_2_3 - 0.000423280423280419*G0_1_0_0_2_4 + 0.000846560846560842*G0_1_0_0_2_5 + 0.00253968253968252*G0_1_0_0_3_0 + 0.000423280423280422*G0_1_0_0_3_1 + 0.000423280423280422*G0_1_0_0_3_2 - 0.0152380952380951*G0_1_0_0_3_3 - 0.00677248677248673*G0_1_0_0_3_4 - 0.00677248677248674*G0_1_0_0_3_5 + 0.0021164021164021*G0_1_0_0_4_0 + 0.000846560846560841*G0_1_0_0_4_1 - 0.000423280423280419*G0_1_0_0_4_2 - 0.00677248677248673*G0_1_0_0_4_3 - 0.00507936507936505*G0_1_0_0_4_4 - 0.00338624338624337*G0_1_0_0_4_5 + 0.0021164021164021*G0_1_0_0_5_0 - 0.000423280423280417*G0_1_0_0_5_1 + 0.000846560846560842*G0_1_0_0_5_2 - 0.00677248677248674*G0_1_0_0_5_3 - 0.00338624338624337*G0_1_0_0_5_4 - 0.00507936507936505*G0_1_0_0_5_5 - 0.000211640211640211*G0_1_0_1_0_0 - 0.00105820105820105*G0_1_0_1_0_1 + 0.00042328042328042*G0_1_0_1_0_2 + 0.000423280423280422*G0_1_0_1_0_3 + 0.000846560846560841*G0_1_0_1_0_4 - 0.000423280423280417*G0_1_0_1_0_5 - 0.00105820105820105*G0_1_0_1_1_0 + 0.00634920634920628*G0_1_0_1_1_1 - 0.00105820105820105*G0_1_0_1_1_2 + 0.00846560846560842*G0_1_0_1_1_3 + 0.00211640211640211*G0_1_0_1_1_4 + 0.0042328042328042*G0_1_0_1_1_5 + 0.00042328042328042*G0_1_0_1_2_0 - 0.00105820105820105*G0_1_0_1_2_1 - 0.00105820105820105*G0_1_0_1_2_2 - 0.00380952380952379*G0_1_0_1_2_3 - 0.00042328042328042*G0_1_0_1_2_4 - 0.000423280423280421*G0_1_0_1_2_5 + 0.000423280423280422*G0_1_0_1_3_0 + 0.00846560846560842*G0_1_0_1_3_1 - 0.00380952380952379*G0_1_0_1_3_2 - 0.00507936507936505*G0_1_0_1_3_4 + 0.000846560846560841*G0_1_0_1_4_0 + 0.00211640211640211*G0_1_0_1_4_1 - 0.00042328042328042*G0_1_0_1_4_2 - 0.00507936507936505*G0_1_0_1_4_3 - 0.00677248677248674*G0_1_0_1_4_4 - 0.00338624338624337*G0_1_0_1_4_5 - 0.000423280423280417*G0_1_0_1_5_0 + 0.0042328042328042*G0_1_0_1_5_1 - 0.000423280423280421*G0_1_0_1_5_2 - 0.00338624338624337*G0_1_0_1_5_4 - 0.000211640211640211*G0_1_0_2_0_0 + 0.00042328042328042*G0_1_0_2_0_1 - 0.00105820105820105*G0_1_0_2_0_2 + 0.000423280423280422*G0_1_0_2_0_3 - 0.000423280423280419*G0_1_0_2_0_4 + 0.000846560846560842*G0_1_0_2_0_5 + 0.00042328042328042*G0_1_0_2_1_0 - 0.00105820105820105*G0_1_0_2_1_1 - 0.00105820105820105*G0_1_0_2_1_2 - 0.00380952380952379*G0_1_0_2_1_3 - 0.00042328042328042*G0_1_0_2_1_4 - 0.000423280423280421*G0_1_0_2_1_5 - 0.00105820105820105*G0_1_0_2_2_0 - 0.00105820105820105*G0_1_0_2_2_1 + 0.00634920634920629*G0_1_0_2_2_2 + 0.00846560846560841*G0_1_0_2_2_3 + 0.0042328042328042*G0_1_0_2_2_4 + 0.00211640211640211*G0_1_0_2_2_5 + 0.000423280423280422*G0_1_0_2_3_0 - 0.00380952380952379*G0_1_0_2_3_1 + 0.00846560846560841*G0_1_0_2_3_2 - 0.00507936507936505*G0_1_0_2_3_5 - 0.000423280423280419*G0_1_0_2_4_0 - 0.00042328042328042*G0_1_0_2_4_1 + 0.0042328042328042*G0_1_0_2_4_2 - 0.00338624338624337*G0_1_0_2_4_5 + 0.000846560846560842*G0_1_0_2_5_0 - 0.000423280423280421*G0_1_0_2_5_1 + 0.00211640211640211*G0_1_0_2_5_2 - 0.00507936507936505*G0_1_0_2_5_3 - 0.00338624338624337*G0_1_0_2_5_4 - 0.00677248677248674*G0_1_0_2_5_5 + 0.00253968253968252*G0_1_0_3_0_0 + 0.000423280423280422*G0_1_0_3_0_1 + 0.000423280423280422*G0_1_0_3_0_2 - 0.0152380952380951*G0_1_0_3_0_3 - 0.00677248677248673*G0_1_0_3_0_4 - 0.00677248677248674*G0_1_0_3_0_5 + 0.000423280423280422*G0_1_0_3_1_0 + 0.00846560846560842*G0_1_0_3_1_1 - 0.00380952380952379*G0_1_0_3_1_2 - 0.00507936507936505*G0_1_0_3_1_4 + 0.000423280423280422*G0_1_0_3_2_0 - 0.00380952380952379*G0_1_0_3_2_1 + 0.00846560846560841*G0_1_0_3_2_2 - 0.00507936507936505*G0_1_0_3_2_5 - 0.0152380952380951*G0_1_0_3_3_0 + 0.162539682539682*G0_1_0_3_3_3 + 0.0406349206349204*G0_1_0_3_3_4 + 0.0406349206349205*G0_1_0_3_3_5 - 0.00677248677248673*G0_1_0_3_4_0 - 0.00507936507936505*G0_1_0_3_4_1 + 0.0406349206349204*G0_1_0_3_4_3 + 0.027089947089947*G0_1_0_3_4_4 + 0.0203174603174602*G0_1_0_3_4_5 - 0.00677248677248674*G0_1_0_3_5_0 - 0.00507936507936505*G0_1_0_3_5_2 + 0.0406349206349205*G0_1_0_3_5_3 + 0.0203174603174602*G0_1_0_3_5_4 + 0.027089947089947*G0_1_0_3_5_5 + 0.0021164021164021*G0_1_0_4_0_0 + 0.000846560846560841*G0_1_0_4_0_1 - 0.000423280423280419*G0_1_0_4_0_2 - 0.00677248677248673*G0_1_0_4_0_3 - 0.00507936507936505*G0_1_0_4_0_4 - 0.00338624338624337*G0_1_0_4_0_5 + 0.000846560846560841*G0_1_0_4_1_0 + 0.00211640211640211*G0_1_0_4_1_1 - 0.00042328042328042*G0_1_0_4_1_2 - 0.00507936507936505*G0_1_0_4_1_3 - 0.00677248677248674*G0_1_0_4_1_4 - 0.00338624338624337*G0_1_0_4_1_5 - 0.000423280423280419*G0_1_0_4_2_0 - 0.00042328042328042*G0_1_0_4_2_1 + 0.0042328042328042*G0_1_0_4_2_2 - 0.00338624338624337*G0_1_0_4_2_5 - 0.00677248677248673*G0_1_0_4_3_0 - 0.00507936507936505*G0_1_0_4_3_1 + 0.0406349206349204*G0_1_0_4_3_3 + 0.027089947089947*G0_1_0_4_3_4 + 0.0203174603174602*G0_1_0_4_3_5 - 0.00507936507936505*G0_1_0_4_4_0 - 0.00677248677248674*G0_1_0_4_4_1 + 0.027089947089947*G0_1_0_4_4_3 + 0.0406349206349204*G0_1_0_4_4_4 + 0.0203174603174602*G0_1_0_4_4_5 - 0.00338624338624337*G0_1_0_4_5_0 - 0.00338624338624337*G0_1_0_4_5_1 - 0.00338624338624337*G0_1_0_4_5_2 + 0.0203174603174602*G0_1_0_4_5_3 + 0.0203174603174602*G0_1_0_4_5_4 + 0.0203174603174602*G0_1_0_4_5_5 + 0.0021164021164021*G0_1_0_5_0_0 - 0.000423280423280417*G0_1_0_5_0_1 + 0.000846560846560842*G0_1_0_5_0_2 - 0.00677248677248674*G0_1_0_5_0_3 - 0.00338624338624337*G0_1_0_5_0_4 - 0.00507936507936505*G0_1_0_5_0_5 - 0.000423280423280417*G0_1_0_5_1_0 + 0.0042328042328042*G0_1_0_5_1_1 - 0.000423280423280421*G0_1_0_5_1_2 - 0.00338624338624337*G0_1_0_5_1_4 + 0.000846560846560842*G0_1_0_5_2_0 - 0.000423280423280421*G0_1_0_5_2_1 + 0.00211640211640211*G0_1_0_5_2_2 - 0.00507936507936505*G0_1_0_5_2_3 - 0.00338624338624337*G0_1_0_5_2_4 - 0.00677248677248674*G0_1_0_5_2_5 - 0.00677248677248674*G0_1_0_5_3_0 - 0.00507936507936505*G0_1_0_5_3_2 + 0.0406349206349205*G0_1_0_5_3_3 + 0.0203174603174602*G0_1_0_5_3_4 + 0.027089947089947*G0_1_0_5_3_5 - 0.00338624338624337*G0_1_0_5_4_0 - 0.00338624338624337*G0_1_0_5_4_1 - 0.00338624338624337*G0_1_0_5_4_2 + 0.0203174603174602*G0_1_0_5_4_3 + 0.0203174603174602*G0_1_0_5_4_4 + 0.0203174603174602*G0_1_0_5_4_5 - 0.00507936507936505*G0_1_0_5_5_0 - 0.00677248677248674*G0_1_0_5_5_2 + 0.027089947089947*G0_1_0_5_5_3 + 0.0203174603174602*G0_1_0_5_5_4 + 0.0406349206349204*G0_1_0_5_5_5 - 0.00634920634920631*G0_1_1_0_0_0 + 0.000846560846560842*G0_1_1_0_0_1 + 0.000846560846560842*G0_1_1_0_0_2 + 0.000423280423280418*G0_1_1_0_0_3 - 0.00211640211640211*G0_1_1_0_0_4 - 0.00634920634920632*G0_1_1_0_0_5 + 0.000846560846560842*G0_1_1_0_1_0 + 0.000846560846560843*G0_1_1_0_1_3 + 0.00126984126984126*G0_1_1_0_1_4 + 0.00338624338624337*G0_1_1_0_1_5 + 0.000846560846560842*G0_1_1_0_2_0 - 0.000846560846560839*G0_1_1_0_2_2 - 0.00042328042328042*G0_1_1_0_2_3 + 0.000423280423280421*G0_1_1_0_2_5 + 0.000423280423280418*G0_1_1_0_3_0 + 0.000846560846560843*G0_1_1_0_3_1 - 0.00042328042328042*G0_1_1_0_3_2 - 0.00846560846560841*G0_1_1_0_3_3 - 0.00338624338624337*G0_1_1_0_3_4 - 0.00169312169312168*G0_1_1_0_3_5 - 0.00211640211640211*G0_1_1_0_4_0 + 0.00126984126984126*G0_1_1_0_4_1 - 0.00338624338624337*G0_1_1_0_4_3 - 0.00507936507936505*G0_1_1_0_4_4 - 0.00338624338624337*G0_1_1_0_4_5 - 0.00634920634920632*G0_1_1_0_5_0 + 0.00338624338624337*G0_1_1_0_5_1 + 0.000423280423280421*G0_1_1_0_5_2 - 0.00169312169312168*G0_1_1_0_5_3 - 0.00338624338624337*G0_1_1_0_5_4 - 0.00507936507936505*G0_1_1_0_5_5 + 0.000846560846560842*G0_1_1_1_0_0 + 0.000846560846560843*G0_1_1_1_0_3 + 0.00126984126984126*G0_1_1_1_0_4 + 0.00338624338624337*G0_1_1_1_0_5 + 0.0042328042328042*G0_1_1_1_1_3 - 0.00423280423280422*G0_1_1_1_1_5 - 0.00084656084656084*G0_1_1_1_2_2 - 0.00338624338624337*G0_1_1_1_2_3 - 0.00126984126984126*G0_1_1_1_2_4 - 0.000846560846560842*G0_1_1_1_2_5 + 0.000846560846560843*G0_1_1_1_3_0 + 0.0042328042328042*G0_1_1_1_3_1 - 0.00338624338624337*G0_1_1_1_3_2 - 0.00169312169312168*G0_1_1_1_3_4 + 0.00126984126984126*G0_1_1_1_4_0 - 0.00126984126984126*G0_1_1_1_4_2 - 0.00169312169312168*G0_1_1_1_4_3 + 0.00169312169312168*G0_1_1_1_4_5 + 0.00338624338624337*G0_1_1_1_5_0 - 0.00423280423280422*G0_1_1_1_5_1 - 0.000846560846560842*G0_1_1_1_5_2 + 0.00169312169312168*G0_1_1_1_5_4 + 0.000846560846560842*G0_1_1_2_0_0 - 0.000846560846560839*G0_1_1_2_0_2 - 0.00042328042328042*G0_1_1_2_0_3 + 0.000423280423280421*G0_1_1_2_0_5 - 0.00084656084656084*G0_1_1_2_1_2 - 0.00338624338624337*G0_1_1_2_1_3 - 0.00126984126984126*G0_1_1_2_1_4 - 0.000846560846560842*G0_1_1_2_1_5 - 0.000846560846560839*G0_1_1_2_2_0 - 0.00084656084656084*G0_1_1_2_2_1 + 0.00634920634920629*G0_1_1_2_2_2 + 0.00634920634920631*G0_1_1_2_2_3 + 0.0021164021164021*G0_1_1_2_2_4 - 0.00042328042328042*G0_1_1_2_2_5 - 0.00042328042328042*G0_1_1_2_3_0 - 0.00338624338624337*G0_1_1_2_3_1 + 0.00634920634920631*G0_1_1_2_3_2 + 0.00507936507936505*G0_1_1_2_3_3 + 0.00338624338624337*G0_1_1_2_3_4 + 0.00169312169312169*G0_1_1_2_3_5 - 0.00126984126984126*G0_1_1_2_4_1 + 0.0021164021164021*G0_1_1_2_4_2 + 0.00338624338624337*G0_1_1_2_4_3 + 0.00507936507936505*G0_1_1_2_4_4 + 0.00338624338624337*G0_1_1_2_4_5 + 0.000423280423280421*G0_1_1_2_5_0 - 0.000846560846560842*G0_1_1_2_5_1 - 0.00042328042328042*G0_1_1_2_5_2 + 0.00169312169312169*G0_1_1_2_5_3 + 0.00338624338624337*G0_1_1_2_5_4 + 0.00846560846560842*G0_1_1_2_5_5 + 0.000423280423280418*G0_1_1_3_0_0 + 0.000846560846560843*G0_1_1_3_0_1 - 0.00042328042328042*G0_1_1_3_0_2 - 0.00846560846560841*G0_1_1_3_0_3 - 0.00338624338624337*G0_1_1_3_0_4 - 0.00169312169312168*G0_1_1_3_0_5 + 0.000846560846560843*G0_1_1_3_1_0 + 0.0042328042328042*G0_1_1_3_1_1 - 0.00338624338624337*G0_1_1_3_1_2 - 0.00169312169312168*G0_1_1_3_1_4 - 0.00042328042328042*G0_1_1_3_2_0 - 0.00338624338624337*G0_1_1_3_2_1 + 0.00634920634920631*G0_1_1_3_2_2 + 0.00507936507936505*G0_1_1_3_2_3 + 0.00338624338624337*G0_1_1_3_2_4 + 0.00169312169312169*G0_1_1_3_2_5 - 0.00846560846560841*G0_1_1_3_3_0 + 0.00507936507936505*G0_1_1_3_3_2 + 0.121904761904761*G0_1_1_3_3_3 + 0.0203174603174602*G0_1_1_3_3_4 + 0.0135449735449735*G0_1_1_3_3_5 - 0.00338624338624337*G0_1_1_3_4_0 - 0.00169312169312168*G0_1_1_3_4_1 + 0.00338624338624337*G0_1_1_3_4_2 + 0.0203174603174602*G0_1_1_3_4_3 + 0.00677248677248674*G0_1_1_3_4_4 - 0.00169312169312168*G0_1_1_3_5_0 + 0.00169312169312169*G0_1_1_3_5_2 + 0.0135449735449735*G0_1_1_3_5_3 - 0.0135449735449735*G0_1_1_3_5_5 - 0.00211640211640211*G0_1_1_4_0_0 + 0.00126984126984126*G0_1_1_4_0_1 - 0.00338624338624337*G0_1_1_4_0_3 - 0.00507936507936505*G0_1_1_4_0_4 - 0.00338624338624337*G0_1_1_4_0_5 + 0.00126984126984126*G0_1_1_4_1_0 - 0.00126984126984126*G0_1_1_4_1_2 - 0.00169312169312168*G0_1_1_4_1_3 + 0.00169312169312168*G0_1_1_4_1_5 - 0.00126984126984126*G0_1_1_4_2_1 + 0.0021164021164021*G0_1_1_4_2_2 + 0.00338624338624337*G0_1_1_4_2_3 + 0.00507936507936505*G0_1_1_4_2_4 + 0.00338624338624337*G0_1_1_4_2_5 - 0.00338624338624337*G0_1_1_4_3_0 - 0.00169312169312168*G0_1_1_4_3_1 + 0.00338624338624337*G0_1_1_4_3_2 + 0.0203174603174602*G0_1_1_4_3_3 + 0.00677248677248674*G0_1_1_4_3_4 - 0.00507936507936505*G0_1_1_4_4_0 + 0.00507936507936505*G0_1_1_4_4_2 + 0.00677248677248674*G0_1_1_4_4_3 - 0.00677248677248674*G0_1_1_4_4_5 - 0.00338624338624337*G0_1_1_4_5_0 + 0.00169312169312168*G0_1_1_4_5_1 + 0.00338624338624337*G0_1_1_4_5_2 - 0.00677248677248674*G0_1_1_4_5_4 - 0.0203174603174602*G0_1_1_4_5_5 - 0.00634920634920632*G0_1_1_5_0_0 + 0.00338624338624337*G0_1_1_5_0_1 + 0.000423280423280421*G0_1_1_5_0_2 - 0.00169312169312168*G0_1_1_5_0_3 - 0.00338624338624337*G0_1_1_5_0_4 - 0.00507936507936505*G0_1_1_5_0_5 + 0.00338624338624337*G0_1_1_5_1_0 - 0.00423280423280422*G0_1_1_5_1_1 - 0.000846560846560842*G0_1_1_5_1_2 + 0.00169312169312168*G0_1_1_5_1_4 + 0.000423280423280421*G0_1_1_5_2_0 - 0.000846560846560842*G0_1_1_5_2_1 - 0.00042328042328042*G0_1_1_5_2_2 + 0.00169312169312169*G0_1_1_5_2_3 + 0.00338624338624337*G0_1_1_5_2_4 + 0.00846560846560842*G0_1_1_5_2_5 - 0.00169312169312168*G0_1_1_5_3_0 + 0.00169312169312169*G0_1_1_5_3_2 + 0.0135449735449735*G0_1_1_5_3_3 - 0.0135449735449735*G0_1_1_5_3_5 - 0.00338624338624337*G0_1_1_5_4_0 + 0.00169312169312168*G0_1_1_5_4_1 + 0.00338624338624337*G0_1_1_5_4_2 - 0.00677248677248674*G0_1_1_5_4_4 - 0.0203174603174602*G0_1_1_5_4_5 - 0.00507936507936505*G0_1_1_5_5_0 + 0.00846560846560842*G0_1_1_5_5_2 - 0.0135449735449735*G0_1_1_5_5_3 - 0.0203174603174602*G0_1_1_5_5_4 - 0.121904761904761*G0_1_1_5_5_5;
    A[33] = -A[34] + 0.0825396825396821*G0_0_1_0_0_0 - 0.00888888888888884*G0_0_1_0_0_1 - 0.00677248677248674*G0_0_1_0_0_2 + 0.000846560846560854*G0_0_1_0_0_3 + 0.0296296296296295*G0_0_1_0_0_4 + 0.0296296296296295*G0_0_1_0_0_5 - 0.00888888888888884*G0_0_1_0_1_0 + 0.00888888888888882*G0_0_1_0_1_1 + 0.00338624338624336*G0_0_1_0_1_3 - 0.00338624338624337*G0_0_1_0_1_4 - 0.00677248677248674*G0_0_1_0_2_0 + 0.00211640211640211*G0_0_1_0_2_2 - 0.00253968253968252*G0_0_1_0_2_3 - 0.0059259259259259*G0_0_1_0_2_4 - 0.0059259259259259*G0_0_1_0_2_5 + 0.000846560846560854*G0_0_1_0_3_0 + 0.00338624338624336*G0_0_1_0_3_1 - 0.00253968253968252*G0_0_1_0_3_2 + 0.00846560846560841*G0_0_1_0_3_3 + 0.00507936507936506*G0_0_1_0_3_4 + 0.0101587301587301*G0_0_1_0_3_5 + 0.0296296296296295*G0_0_1_0_4_0 - 0.00338624338624337*G0_0_1_0_4_1 - 0.0059259259259259*G0_0_1_0_4_2 + 0.00507936507936506*G0_0_1_0_4_3 + 0.032169312169312*G0_0_1_0_4_4 + 0.0186243386243385*G0_0_1_0_4_5 + 0.0296296296296295*G0_0_1_0_5_0 - 0.0059259259259259*G0_0_1_0_5_2 + 0.0101587301587301*G0_0_1_0_5_3 + 0.0186243386243385*G0_0_1_0_5_4 + 0.0491005291005288*G0_0_1_0_5_5 - 0.00888888888888884*G0_0_1_1_0_0 + 0.00888888888888882*G0_0_1_1_0_1 + 0.00338624338624336*G0_0_1_1_0_3 - 0.00338624338624337*G0_0_1_1_0_4 + 0.00888888888888882*G0_0_1_1_1_0 - 0.082539682539682*G0_0_1_1_1_1 + 0.00677248677248673*G0_0_1_1_1_2 - 0.0296296296296295*G0_0_1_1_1_3 - 0.000846560846560842*G0_0_1_1_1_4 - 0.0296296296296294*G0_0_1_1_1_5 + 0.00677248677248673*G0_0_1_1_2_1 - 0.00211640211640211*G0_0_1_1_2_2 + 0.0059259259259259*G0_0_1_1_2_3 + 0.00253968253968253*G0_0_1_1_2_4 + 0.0059259259259259*G0_0_1_1_2_5 + 0.00338624338624336*G0_0_1_1_3_0 - 0.0296296296296295*G0_0_1_1_3_1 + 0.0059259259259259*G0_0_1_1_3_2 - 0.032169312169312*G0_0_1_1_3_3 - 0.00507936507936506*G0_0_1_1_3_4 - 0.0186243386243385*G0_0_1_1_3_5 - 0.00338624338624337*G0_0_1_1_4_0 - 0.000846560846560842*G0_0_1_1_4_1 + 0.00253968253968253*G0_0_1_1_4_2 - 0.00507936507936506*G0_0_1_1_4_3 - 0.00846560846560843*G0_0_1_1_4_4 - 0.0101587301587301*G0_0_1_1_4_5 - 0.0296296296296294*G0_0_1_1_5_1 + 0.0059259259259259*G0_0_1_1_5_2 - 0.0186243386243385*G0_0_1_1_5_3 - 0.0101587301587301*G0_0_1_1_5_4 - 0.0491005291005288*G0_0_1_1_5_5 - 0.00677248677248674*G0_0_1_2_0_0 + 0.00211640211640211*G0_0_1_2_0_2 - 0.00253968253968252*G0_0_1_2_0_3 - 0.0059259259259259*G0_0_1_2_0_4 - 0.0059259259259259*G0_0_1_2_0_5 + 0.00677248677248673*G0_0_1_2_1_1 - 0.00211640211640211*G0_0_1_2_1_2 + 0.0059259259259259*G0_0_1_2_1_3 + 0.00253968253968253*G0_0_1_2_1_4 + 0.0059259259259259*G0_0_1_2_1_5 + 0.00211640211640211*G0_0_1_2_2_0 - 0.00211640211640211*G0_0_1_2_2_1 - 0.00253968253968252*G0_0_1_2_3_0 + 0.0059259259259259*G0_0_1_2_3_1 + 0.0169312169312168*G0_0_1_2_3_3 + 0.00507936507936506*G0_0_1_2_3_5 - 0.0059259259259259*G0_0_1_2_4_0 + 0.00253968253968253*G0_0_1_2_4_1 - 0.0169312169312169*G0_0_1_2_4_4 - 0.00507936507936506*G0_0_1_2_4_5 - 0.0059259259259259*G0_0_1_2_5_0 + 0.00592592592592589*G0_0_1_2_5_1 + 0.00507936507936506*G0_0_1_2_5_3 - 0.00507936507936506*G0_0_1_2_5_4 + 0.000846560846560854*G0_0_1_3_0_0 + 0.00338624338624336*G0_0_1_3_0_1 - 0.00253968253968252*G0_0_1_3_0_2 + 0.00846560846560842*G0_0_1_3_0_3 + 0.00507936507936506*G0_0_1_3_0_4 + 0.0101587301587301*G0_0_1_3_0_5 + 0.00338624338624336*G0_0_1_3_1_0 - 0.0296296296296295*G0_0_1_3_1_1 + 0.0059259259259259*G0_0_1_3_1_2 - 0.032169312169312*G0_0_1_3_1_3 - 0.00507936507936506*G0_0_1_3_1_4 - 0.0186243386243385*G0_0_1_3_1_5 - 0.00253968253968252*G0_0_1_3_2_0 + 0.0059259259259259*G0_0_1_3_2_1 + 0.0169312169312168*G0_0_1_3_2_3 + 0.00507936507936506*G0_0_1_3_2_5 + 0.00846560846560841*G0_0_1_3_3_0 - 0.032169312169312*G0_0_1_3_3_1 + 0.0169312169312168*G0_0_1_3_3_2 - 0.0609523809523806*G0_0_1_3_3_3 - 0.00677248677248674*G0_0_1_3_3_4 - 0.027089947089947*G0_0_1_3_3_5 + 0.00507936507936506*G0_0_1_3_4_0 - 0.00507936507936506*G0_0_1_3_4_1 - 0.00677248677248674*G0_0_1_3_4_3 + 0.00677248677248675*G0_0_1_3_4_4 + 0.0101587301587301*G0_0_1_3_5_0 - 0.0186243386243385*G0_0_1_3_5_1 + 0.00507936507936506*G0_0_1_3_5_2 - 0.027089947089947*G0_0_1_3_5_3 - 0.0203174603174602*G0_0_1_3_5_5 + 0.0296296296296295*G0_0_1_4_0_0 - 0.00338624338624337*G0_0_1_4_0_1 - 0.0059259259259259*G0_0_1_4_0_2 + 0.00507936507936506*G0_0_1_4_0_3 + 0.032169312169312*G0_0_1_4_0_4 + 0.0186243386243385*G0_0_1_4_0_5 - 0.00338624338624337*G0_0_1_4_1_0 - 0.000846560846560843*G0_0_1_4_1_1 + 0.00253968253968253*G0_0_1_4_1_2 - 0.00507936507936506*G0_0_1_4_1_3 - 0.00846560846560843*G0_0_1_4_1_4 - 0.0101587301587301*G0_0_1_4_1_5 - 0.0059259259259259*G0_0_1_4_2_0 + 0.00253968253968253*G0_0_1_4_2_1 - 0.0169312169312169*G0_0_1_4_2_4 - 0.00507936507936506*G0_0_1_4_2_5 + 0.00507936507936506*G0_0_1_4_3_0 - 0.00507936507936506*G0_0_1_4_3_1 - 0.00677248677248674*G0_0_1_4_3_3 + 0.00677248677248674*G0_0_1_4_3_4 + 0.032169312169312*G0_0_1_4_4_0 - 0.00846560846560843*G0_0_1_4_4_1 - 0.0169312169312169*G0_0_1_4_4_2 + 0.00677248677248674*G0_0_1_4_4_3 + 0.0609523809523807*G0_0_1_4_4_4 + 0.027089947089947*G0_0_1_4_4_5 + 0.0186243386243385*G0_0_1_4_5_0 - 0.0101587301587301*G0_0_1_4_5_1 - 0.00507936507936506*G0_0_1_4_5_2 + 0.027089947089947*G0_0_1_4_5_4 + 0.0203174603174602*G0_0_1_4_5_5 + 0.0296296296296295*G0_0_1_5_0_0 - 0.0059259259259259*G0_0_1_5_0_2 + 0.0101587301587301*G0_0_1_5_0_3 + 0.0186243386243385*G0_0_1_5_0_4 + 0.0491005291005288*G0_0_1_5_0_5 - 0.0296296296296294*G0_0_1_5_1_1 + 0.0059259259259259*G0_0_1_5_1_2 - 0.0186243386243385*G0_0_1_5_1_3 - 0.0101587301587301*G0_0_1_5_1_4 - 0.0491005291005288*G0_0_1_5_1_5 - 0.0059259259259259*G0_0_1_5_2_0 + 0.00592592592592589*G0_0_1_5_2_1 + 0.00507936507936506*G0_0_1_5_2_3 - 0.00507936507936506*G0_0_1_5_2_4 + 0.0101587301587301*G0_0_1_5_3_0 - 0.0186243386243385*G0_0_1_5_3_1 + 0.00507936507936506*G0_0_1_5_3_2 - 0.027089947089947*G0_0_1_5_3_3 - 0.0203174603174602*G0_0_1_5_3_5 + 0.0186243386243385*G0_0_1_5_4_0 - 0.0101587301587301*G0_0_1_5_4_1 - 0.00507936507936506*G0_0_1_5_4_2 + 0.027089947089947*G0_0_1_5_4_4 + 0.0203174603174602*G0_0_1_5_4_5 + 0.0491005291005288*G0_0_1_5_5_0 - 0.0491005291005288*G0_0_1_5_5_1 - 0.0203174603174602*G0_0_1_5_5_3 + 0.0203174603174602*G0_0_1_5_5_4 - 0.00634920634920632*G0_1_1_0_0_0 - 0.000423280423280416*G0_1_1_0_0_1 + 0.00169312169312168*G0_1_1_0_0_2 - 0.00338624338624336*G0_1_1_0_0_3 - 0.00423280423280421*G0_1_1_0_0_4 - 0.0126984126984126*G0_1_1_0_0_5 - 0.000423280423280416*G0_1_1_0_1_0 + 0.0084656084656084*G0_1_1_0_1_1 - 0.00126984126984126*G0_1_1_0_1_2 + 0.00507936507936504*G0_1_1_0_1_3 + 0.00169312169312168*G0_1_1_0_1_4 + 0.0118518518518518*G0_1_1_0_1_5 + 0.00169312169312168*G0_1_1_0_2_0 - 0.00126984126984126*G0_1_1_0_2_1 - 0.00338624338624336*G0_1_1_0_2_3 - 0.00084656084656084*G0_1_1_0_2_4 - 0.00253968253968253*G0_1_1_0_2_5 - 0.00338624338624336*G0_1_1_0_3_0 + 0.00507936507936504*G0_1_1_0_3_1 - 0.00338624338624336*G0_1_1_0_3_2 + 0.0118518518518518*G0_1_1_0_3_3 + 0.00338624338624337*G0_1_1_0_3_4 + 0.0118518518518518*G0_1_1_0_3_5 - 0.00423280423280421*G0_1_1_0_4_0 + 0.00169312169312168*G0_1_1_0_4_1 - 0.00084656084656084*G0_1_1_0_4_2 + 0.00338624338624337*G0_1_1_0_4_3 - 0.00169312169312169*G0_1_1_0_4_4 + 0.00169312169312168*G0_1_1_0_4_5 - 0.0126984126984126*G0_1_1_0_5_0 + 0.0118518518518518*G0_1_1_0_5_1 - 0.00253968253968253*G0_1_1_0_5_2 + 0.0118518518518518*G0_1_1_0_5_3 + 0.00169312169312168*G0_1_1_0_5_4 + 0.0152380952380951*G0_1_1_0_5_5 - 0.000423280423280416*G0_1_1_1_0_0 + 0.0084656084656084*G0_1_1_1_0_1 - 0.00126984126984126*G0_1_1_1_0_2 + 0.00507936507936504*G0_1_1_1_0_3 + 0.00169312169312168*G0_1_1_1_0_4 + 0.0118518518518518*G0_1_1_1_0_5 + 0.00846560846560841*G0_1_1_1_1_0 - 0.0888888888888884*G0_1_1_1_1_1 + 0.00846560846560842*G0_1_1_1_1_2 - 0.0338624338624337*G0_1_1_1_1_3 - 0.00423280423280421*G0_1_1_1_1_4 - 0.0423280423280421*G0_1_1_1_1_5 - 0.00126984126984126*G0_1_1_1_2_0 + 0.00846560846560842*G0_1_1_1_2_1 - 0.0021164021164021*G0_1_1_1_2_2 + 0.00507936507936506*G0_1_1_1_2_3 - 0.000846560846560842*G0_1_1_1_2_4 + 0.00338624338624337*G0_1_1_1_2_5 + 0.00507936507936504*G0_1_1_1_3_0 - 0.0338624338624337*G0_1_1_1_3_1 + 0.00507936507936506*G0_1_1_1_3_2 - 0.0338624338624337*G0_1_1_1_3_3 - 0.00169312169312169*G0_1_1_1_3_4 - 0.0169312169312168*G0_1_1_1_3_5 + 0.00169312169312168*G0_1_1_1_4_0 - 0.00423280423280421*G0_1_1_1_4_1 - 0.000846560846560842*G0_1_1_1_4_2 - 0.00169312169312169*G0_1_1_1_4_3 + 0.00338624338624337*G0_1_1_1_4_4 + 0.00169312169312169*G0_1_1_1_4_5 + 0.0118518518518518*G0_1_1_1_5_0 - 0.0423280423280421*G0_1_1_1_5_1 + 0.00338624338624337*G0_1_1_1_5_2 - 0.0169312169312168*G0_1_1_1_5_3 + 0.00169312169312169*G0_1_1_1_5_4 - 0.0338624338624337*G0_1_1_1_5_5 + 0.00169312169312168*G0_1_1_2_0_0 - 0.00126984126984126*G0_1_1_2_0_1 - 0.00338624338624337*G0_1_1_2_0_3 - 0.00084656084656084*G0_1_1_2_0_4 - 0.00253968253968253*G0_1_1_2_0_5 - 0.00126984126984126*G0_1_1_2_1_0 + 0.00846560846560842*G0_1_1_2_1_1 - 0.0021164021164021*G0_1_1_2_1_2 + 0.00507936507936506*G0_1_1_2_1_3 - 0.000846560846560842*G0_1_1_2_1_4 + 0.00338624338624337*G0_1_1_2_1_5 - 0.0021164021164021*G0_1_1_2_2_1 + 0.0063492063492063*G0_1_1_2_2_2 - 0.00423280423280421*G0_1_1_2_2_5 - 0.00338624338624337*G0_1_1_2_3_0 + 0.00507936507936506*G0_1_1_2_3_1 + 0.0253968253968253*G0_1_1_2_3_3 + 0.00846560846560842*G0_1_1_2_3_4 + 0.0152380952380952*G0_1_1_2_3_5 - 0.00084656084656084*G0_1_1_2_4_0 - 0.000846560846560842*G0_1_1_2_4_1 + 0.00846560846560842*G0_1_1_2_4_3 + 0.00846560846560842*G0_1_1_2_4_4 + 0.0101587301587301*G0_1_1_2_4_5 - 0.00253968253968253*G0_1_1_2_5_0 + 0.00338624338624337*G0_1_1_2_5_1 - 0.00423280423280421*G0_1_1_2_5_2 + 0.0152380952380952*G0_1_1_2_5_3 + 0.0101587301587301*G0_1_1_2_5_4 + 0.0287830687830686*G0_1_1_2_5_5 - 0.00338624338624336*G0_1_1_3_0_0 + 0.00507936507936504*G0_1_1_3_0_1 - 0.00338624338624336*G0_1_1_3_0_2 + 0.0118518518518518*G0_1_1_3_0_3 + 0.00338624338624337*G0_1_1_3_0_4 + 0.0118518518518518*G0_1_1_3_0_5 + 0.00507936507936504*G0_1_1_3_1_0 - 0.0338624338624337*G0_1_1_3_1_1 + 0.00507936507936506*G0_1_1_3_1_2 - 0.0338624338624337*G0_1_1_3_1_3 - 0.00169312169312169*G0_1_1_3_1_4 - 0.0169312169312168*G0_1_1_3_1_5 - 0.00338624338624336*G0_1_1_3_2_0 + 0.00507936507936506*G0_1_1_3_2_1 + 0.0253968253968253*G0_1_1_3_2_3 + 0.00846560846560843*G0_1_1_3_2_4 + 0.0152380952380952*G0_1_1_3_2_5 + 0.0118518518518518*G0_1_1_3_3_0 - 0.0338624338624337*G0_1_1_3_3_1 + 0.0253968253968253*G0_1_1_3_3_2 - 0.0812698412698409*G0_1_1_3_3_3 - 0.0203174603174602*G0_1_1_3_3_4 - 0.0541798941798939*G0_1_1_3_3_5 + 0.00338624338624337*G0_1_1_3_4_0 - 0.00169312169312169*G0_1_1_3_4_1 + 0.00846560846560843*G0_1_1_3_4_2 - 0.0203174603174602*G0_1_1_3_4_3 - 0.0135449735449735*G0_1_1_3_4_4 - 0.027089947089947*G0_1_1_3_4_5 + 0.0118518518518518*G0_1_1_3_5_0 - 0.0169312169312168*G0_1_1_3_5_1 + 0.0152380952380952*G0_1_1_3_5_2 - 0.0541798941798939*G0_1_1_3_5_3 - 0.027089947089947*G0_1_1_3_5_4 - 0.0812698412698409*G0_1_1_3_5_5 - 0.00423280423280421*G0_1_1_4_0_0 + 0.00169312169312168*G0_1_1_4_0_1 - 0.00084656084656084*G0_1_1_4_0_2 + 0.00338624338624337*G0_1_1_4_0_3 - 0.00169312169312169*G0_1_1_4_0_4 + 0.00169312169312168*G0_1_1_4_0_5 + 0.00169312169312168*G0_1_1_4_1_0 - 0.00423280423280421*G0_1_1_4_1_1 - 0.000846560846560842*G0_1_1_4_1_2 - 0.00169312169312169*G0_1_1_4_1_3 + 0.00338624338624337*G0_1_1_4_1_4 + 0.00169312169312169*G0_1_1_4_1_5 - 0.00084656084656084*G0_1_1_4_2_0 - 0.000846560846560842*G0_1_1_4_2_1 + 0.00846560846560843*G0_1_1_4_2_3 + 0.00846560846560842*G0_1_1_4_2_4 + 0.0101587301587301*G0_1_1_4_2_5 + 0.00338624338624337*G0_1_1_4_3_0 - 0.00169312169312169*G0_1_1_4_3_1 + 0.00846560846560843*G0_1_1_4_3_2 - 0.0203174603174602*G0_1_1_4_3_3 - 0.0135449735449735*G0_1_1_4_3_4 - 0.027089947089947*G0_1_1_4_3_5 - 0.00169312169312169*G0_1_1_4_4_0 + 0.00338624338624337*G0_1_1_4_4_1 + 0.00846560846560842*G0_1_1_4_4_2 - 0.0135449735449735*G0_1_1_4_4_3 - 0.0203174603174602*G0_1_1_4_4_4 - 0.027089947089947*G0_1_1_4_4_5 + 0.00169312169312168*G0_1_1_4_5_0 + 0.00169312169312169*G0_1_1_4_5_1 + 0.0101587301587301*G0_1_1_4_5_2 - 0.027089947089947*G0_1_1_4_5_3 - 0.027089947089947*G0_1_1_4_5_4 - 0.0609523809523806*G0_1_1_4_5_5 - 0.0126984126984126*G0_1_1_5_0_0 + 0.0118518518518518*G0_1_1_5_0_1 - 0.00253968253968253*G0_1_1_5_0_2 + 0.0118518518518518*G0_1_1_5_0_3 + 0.00169312169312168*G0_1_1_5_0_4 + 0.0152380952380951*G0_1_1_5_0_5 + 0.0118518518518518*G0_1_1_5_1_0 - 0.0423280423280421*G0_1_1_5_1_1 + 0.00338624338624337*G0_1_1_5_1_2 - 0.0169312169312168*G0_1_1_5_1_3 + 0.00169312169312169*G0_1_1_5_1_4 - 0.0338624338624337*G0_1_1_5_1_5 - 0.00253968253968252*G0_1_1_5_2_0 + 0.00338624338624337*G0_1_1_5_2_1 - 0.00423280423280421*G0_1_1_5_2_2 + 0.0152380952380952*G0_1_1_5_2_3 + 0.0101587301587301*G0_1_1_5_2_4 + 0.0287830687830686*G0_1_1_5_2_5 + 0.0118518518518518*G0_1_1_5_3_0 - 0.0169312169312168*G0_1_1_5_3_1 + 0.0152380952380952*G0_1_1_5_3_2 - 0.0541798941798939*G0_1_1_5_3_3 - 0.027089947089947*G0_1_1_5_3_4 - 0.0812698412698409*G0_1_1_5_3_5 + 0.00169312169312168*G0_1_1_5_4_0 + 0.00169312169312169*G0_1_1_5_4_1 + 0.0101587301587301*G0_1_1_5_4_2 - 0.027089947089947*G0_1_1_5_4_3 - 0.027089947089947*G0_1_1_5_4_4 - 0.0609523809523806*G0_1_1_5_4_5 + 0.0152380952380951*G0_1_1_5_5_0 - 0.0338624338624337*G0_1_1_5_5_1 + 0.0287830687830686*G0_1_1_5_5_2 - 0.0812698412698409*G0_1_1_5_5_3 - 0.0609523809523806*G0_1_1_5_5_4 - 0.325079365079363*G0_1_1_5_5_5;
    A[21] = -A[33] + 0.0063492063492063*G0_0_0_0_0_0 - 0.00169312169312168*G0_0_0_0_0_1 + 0.000423280423280417*G0_0_0_0_0_2 + 0.00338624338624337*G0_0_0_0_0_3 + 0.0126984126984126*G0_0_0_0_0_4 + 0.00423280423280421*G0_0_0_0_0_5 - 0.00169312169312168*G0_0_0_0_1_0 + 0.00126984126984126*G0_0_0_0_1_2 + 0.00338624338624336*G0_0_0_0_1_3 + 0.00253968253968252*G0_0_0_0_1_4 + 0.000846560846560841*G0_0_0_0_1_5 + 0.000423280423280417*G0_0_0_0_2_0 + 0.00126984126984126*G0_0_0_0_2_1 - 0.00846560846560839*G0_0_0_0_2_2 - 0.00507936507936504*G0_0_0_0_2_3 - 0.0118518518518518*G0_0_0_0_2_4 - 0.00169312169312169*G0_0_0_0_2_5 + 0.00338624338624337*G0_0_0_0_3_0 + 0.00338624338624336*G0_0_0_0_3_1 - 0.00507936507936504*G0_0_0_0_3_2 - 0.0118518518518518*G0_0_0_0_3_3 - 0.0118518518518518*G0_0_0_0_3_4 - 0.00338624338624337*G0_0_0_0_3_5 + 0.0126984126984126*G0_0_0_0_4_0 + 0.00253968253968252*G0_0_0_0_4_1 - 0.0118518518518518*G0_0_0_0_4_2 - 0.0118518518518518*G0_0_0_0_4_3 - 0.0152380952380951*G0_0_0_0_4_4 - 0.00169312169312168*G0_0_0_0_4_5 + 0.00423280423280421*G0_0_0_0_5_0 + 0.00084656084656084*G0_0_0_0_5_1 - 0.00169312169312169*G0_0_0_0_5_2 - 0.00338624338624337*G0_0_0_0_5_3 - 0.00169312169312168*G0_0_0_0_5_4 + 0.00169312169312167*G0_0_0_0_5_5 - 0.00169312169312168*G0_0_0_1_0_0 + 0.00126984126984126*G0_0_0_1_0_2 + 0.00338624338624336*G0_0_0_1_0_3 + 0.00253968253968252*G0_0_0_1_0_4 + 0.000846560846560841*G0_0_0_1_0_5 - 0.00634920634920629*G0_0_0_1_1_1 + 0.0021164021164021*G0_0_0_1_1_2 + 0.00423280423280421*G0_0_0_1_1_4 + 0.00126984126984126*G0_0_0_1_2_0 + 0.0021164021164021*G0_0_0_1_2_1 - 0.0084656084656084*G0_0_0_1_2_2 - 0.00507936507936504*G0_0_0_1_2_3 - 0.00338624338624336*G0_0_0_1_2_4 + 0.00084656084656084*G0_0_0_1_2_5 + 0.00338624338624336*G0_0_0_1_3_0 - 0.00507936507936504*G0_0_0_1_3_2 - 0.0253968253968253*G0_0_0_1_3_3 - 0.0152380952380952*G0_0_0_1_3_4 - 0.00846560846560842*G0_0_0_1_3_5 + 0.00253968253968252*G0_0_0_1_4_0 + 0.00423280423280421*G0_0_0_1_4_1 - 0.00338624338624336*G0_0_0_1_4_2 - 0.0152380952380952*G0_0_0_1_4_3 - 0.0287830687830686*G0_0_0_1_4_4 - 0.0101587301587301*G0_0_0_1_4_5 + 0.00084656084656084*G0_0_0_1_5_0 + 0.00084656084656084*G0_0_0_1_5_2 - 0.00846560846560842*G0_0_0_1_5_3 - 0.0101587301587301*G0_0_0_1_5_4 - 0.00846560846560841*G0_0_0_1_5_5 + 0.000423280423280417*G0_0_0_2_0_0 + 0.00126984126984126*G0_0_0_2_0_1 - 0.00846560846560839*G0_0_0_2_0_2 - 0.00507936507936504*G0_0_0_2_0_3 - 0.0118518518518518*G0_0_0_2_0_4 - 0.00169312169312169*G0_0_0_2_0_5 + 0.00126984126984126*G0_0_0_2_1_0 + 0.0021164021164021*G0_0_0_2_1_1 - 0.0084656084656084*G0_0_0_2_1_2 - 0.00507936507936504*G0_0_0_2_1_3 - 0.00338624338624336*G0_0_0_2_1_4 + 0.00084656084656084*G0_0_0_2_1_5 - 0.00846560846560839*G0_0_0_2_2_0 - 0.0084656084656084*G0_0_0_2_2_1 + 0.0888888888888883*G0_0_0_2_2_2 + 0.0338624338624336*G0_0_0_2_2_3 + 0.042328042328042*G0_0_0_2_2_4 + 0.00423280423280423*G0_0_0_2_2_5 - 0.00507936507936504*G0_0_0_2_3_0 - 0.00507936507936504*G0_0_0_2_3_1 + 0.0338624338624336*G0_0_0_2_3_2 + 0.0338624338624336*G0_0_0_2_3_3 + 0.0169312169312168*G0_0_0_2_3_4 + 0.0016931216931217*G0_0_0_2_3_5 - 0.0118518518518518*G0_0_0_2_4_0 - 0.00338624338624336*G0_0_0_2_4_1 + 0.042328042328042*G0_0_0_2_4_2 + 0.0169312169312168*G0_0_0_2_4_3 + 0.0338624338624336*G0_0_0_2_4_4 - 0.00169312169312168*G0_0_0_2_4_5 - 0.00169312169312169*G0_0_0_2_5_0 + 0.00084656084656084*G0_0_0_2_5_1 + 0.00423280423280423*G0_0_0_2_5_2 + 0.0016931216931217*G0_0_0_2_5_3 - 0.00169312169312168*G0_0_0_2_5_4 - 0.00338624338624337*G0_0_0_2_5_5 + 0.00338624338624337*G0_0_0_3_0_0 + 0.00338624338624336*G0_0_0_3_0_1 - 0.00507936507936504*G0_0_0_3_0_2 - 0.0118518518518518*G0_0_0_3_0_3 - 0.0118518518518518*G0_0_0_3_0_4 - 0.00338624338624337*G0_0_0_3_0_5 + 0.00338624338624336*G0_0_0_3_1_0 - 0.00507936507936504*G0_0_0_3_1_2 - 0.0253968253968253*G0_0_0_3_1_3 - 0.0152380952380952*G0_0_0_3_1_4 - 0.00846560846560842*G0_0_0_3_1_5 - 0.00507936507936504*G0_0_0_3_2_0 - 0.00507936507936504*G0_0_0_3_2_1 + 0.0338624338624336*G0_0_0_3_2_2 + 0.0338624338624336*G0_0_0_3_2_3 + 0.0169312169312168*G0_0_0_3_2_4 + 0.0016931216931217*G0_0_0_3_2_5 - 0.0118518518518518*G0_0_0_3_3_0 - 0.0253968253968253*G0_0_0_3_3_1 + 0.0338624338624336*G0_0_0_3_3_2 + 0.0812698412698408*G0_0_0_3_3_3 + 0.0541798941798939*G0_0_0_3_3_4 + 0.0203174603174602*G0_0_0_3_3_5 - 0.0118518518518518*G0_0_0_3_4_0 - 0.0152380952380952*G0_0_0_3_4_1 + 0.0169312169312168*G0_0_0_3_4_2 + 0.0541798941798939*G0_0_0_3_4_3 + 0.0812698412698408*G0_0_0_3_4_4 + 0.027089947089947*G0_0_0_3_4_5 - 0.00338624338624337*G0_0_0_3_5_0 - 0.00846560846560843*G0_0_0_3_5_1 + 0.0016931216931217*G0_0_0_3_5_2 + 0.0203174603174602*G0_0_0_3_5_3 + 0.027089947089947*G0_0_0_3_5_4 + 0.0135449735449735*G0_0_0_3_5_5 + 0.0126984126984126*G0_0_0_4_0_0 + 0.00253968253968252*G0_0_0_4_0_1 - 0.0118518518518518*G0_0_0_4_0_2 - 0.0118518518518518*G0_0_0_4_0_3 - 0.0152380952380951*G0_0_0_4_0_4 - 0.00169312169312168*G0_0_0_4_0_5 + 0.00253968253968252*G0_0_0_4_1_0 + 0.00423280423280421*G0_0_0_4_1_1 - 0.00338624338624336*G0_0_0_4_1_2 - 0.0152380952380952*G0_0_0_4_1_3 - 0.0287830687830686*G0_0_0_4_1_4 - 0.0101587301587301*G0_0_0_4_1_5 - 0.0118518518518518*G0_0_0_4_2_0 - 0.00338624338624336*G0_0_0_4_2_1 + 0.042328042328042*G0_0_0_4_2_2 + 0.0169312169312168*G0_0_0_4_2_3 + 0.0338624338624337*G0_0_0_4_2_4 - 0.00169312169312168*G0_0_0_4_2_5 - 0.0118518518518518*G0_0_0_4_3_0 - 0.0152380952380952*G0_0_0_4_3_1 + 0.0169312169312168*G0_0_0_4_3_2 + 0.0541798941798939*G0_0_0_4_3_3 + 0.0812698412698408*G0_0_0_4_3_4 + 0.027089947089947*G0_0_0_4_3_5 - 0.0152380952380951*G0_0_0_4_4_0 - 0.0287830687830686*G0_0_0_4_4_1 + 0.0338624338624336*G0_0_0_4_4_2 + 0.0812698412698408*G0_0_0_4_4_3 + 0.325079365079363*G0_0_0_4_4_4 + 0.0609523809523807*G0_0_0_4_4_5 - 0.00169312169312168*G0_0_0_4_5_0 - 0.0101587301587301*G0_0_0_4_5_1 - 0.00169312169312168*G0_0_0_4_5_2 + 0.027089947089947*G0_0_0_4_5_3 + 0.0609523809523807*G0_0_0_4_5_4 + 0.027089947089947*G0_0_0_4_5_5 + 0.00423280423280421*G0_0_0_5_0_0 + 0.00084656084656084*G0_0_0_5_0_1 - 0.00169312169312169*G0_0_0_5_0_2 - 0.00338624338624337*G0_0_0_5_0_3 - 0.00169312169312168*G0_0_0_5_0_4 + 0.00169312169312167*G0_0_0_5_0_5 + 0.00084656084656084*G0_0_0_5_1_0 + 0.00084656084656084*G0_0_0_5_1_2 - 0.00846560846560843*G0_0_0_5_1_3 - 0.0101587301587301*G0_0_0_5_1_4 - 0.00846560846560841*G0_0_0_5_1_5 - 0.00169312169312169*G0_0_0_5_2_0 + 0.00084656084656084*G0_0_0_5_2_1 + 0.00423280423280423*G0_0_0_5_2_2 + 0.0016931216931217*G0_0_0_5_2_3 - 0.00169312169312168*G0_0_0_5_2_4 - 0.00338624338624337*G0_0_0_5_2_5 - 0.00338624338624337*G0_0_0_5_3_0 - 0.00846560846560842*G0_0_0_5_3_1 + 0.0016931216931217*G0_0_0_5_3_2 + 0.0203174603174602*G0_0_0_5_3_3 + 0.027089947089947*G0_0_0_5_3_4 + 0.0135449735449735*G0_0_0_5_3_5 - 0.00169312169312168*G0_0_0_5_4_0 - 0.0101587301587301*G0_0_0_5_4_1 - 0.00169312169312168*G0_0_0_5_4_2 + 0.027089947089947*G0_0_0_5_4_3 + 0.0609523809523807*G0_0_0_5_4_4 + 0.027089947089947*G0_0_0_5_4_5 + 0.00169312169312167*G0_0_0_5_5_0 - 0.00846560846560841*G0_0_0_5_5_1 - 0.00338624338624337*G0_0_0_5_5_2 + 0.0135449735449735*G0_0_0_5_5_3 + 0.027089947089947*G0_0_0_5_5_4 + 0.0203174603174602*G0_0_0_5_5_5 + 0.00634920634920631*G0_0_1_0_0_0 - 0.00253968253968252*G0_0_1_0_0_1 - 0.000423280423280422*G0_0_1_0_0_2 + 0.000846560846560842*G0_0_1_0_0_3 + 0.00423280423280421*G0_0_1_0_0_4 + 0.00423280423280421*G0_0_1_0_0_5 - 0.00253968253968252*G0_0_1_0_1_0 + 0.0063492063492063*G0_0_1_0_1_1 - 0.00042328042328042*G0_0_1_0_1_2 + 0.0042328042328042*G0_0_1_0_1_3 + 0.00084656084656084*G0_0_1_0_1_4 + 0.0042328042328042*G0_0_1_0_1_5 - 0.000423280423280422*G0_0_1_0_2_0 - 0.00042328042328042*G0_0_1_0_2_1 - 0.000423280423280416*G0_0_1_0_2_2 - 0.00169312169312168*G0_0_1_0_2_3 - 0.00169312169312168*G0_0_1_0_2_4 - 0.00169312169312168*G0_0_1_0_2_5 + 0.000846560846560842*G0_0_1_0_3_0 + 0.0042328042328042*G0_0_1_0_3_1 - 0.00169312169312168*G0_0_1_0_3_2 - 0.00169312169312169*G0_0_1_0_3_3 - 0.00338624338624336*G0_0_1_0_3_4 + 0.00169312169312168*G0_0_1_0_3_5 + 0.00423280423280421*G0_0_1_0_4_0 + 0.00084656084656084*G0_0_1_0_4_1 - 0.00169312169312168*G0_0_1_0_4_2 - 0.00338624338624336*G0_0_1_0_4_3 - 0.00169312169312167*G0_0_1_0_4_4 + 0.00169312169312168*G0_0_1_0_4_5 + 0.00423280423280421*G0_0_1_0_5_0 + 0.0042328042328042*G0_0_1_0_5_1 - 0.00169312169312168*G0_0_1_0_5_2 + 0.00169312169312168*G0_0_1_0_5_3 + 0.00169312169312168*G0_0_1_0_5_4 + 0.0152380952380951*G0_0_1_0_5_5 - 0.00253968253968252*G0_0_1_1_0_0 + 0.0063492063492063*G0_0_1_1_0_1 - 0.00042328042328042*G0_0_1_1_0_2 + 0.0042328042328042*G0_0_1_1_0_3 + 0.00084656084656084*G0_0_1_1_0_4 + 0.0042328042328042*G0_0_1_1_0_5 + 0.0063492063492063*G0_0_1_1_1_0 - 0.0761904761904757*G0_0_1_1_1_1 + 0.00634920634920631*G0_0_1_1_1_2 - 0.0253968253968252*G0_0_1_1_1_3 - 0.0253968253968252*G0_0_1_1_1_5 - 0.00042328042328042*G0_0_1_1_2_0 + 0.00634920634920631*G0_0_1_1_2_1 - 0.00253968253968252*G0_0_1_1_2_2 + 0.00423280423280421*G0_0_1_1_2_3 + 0.000846560846560844*G0_0_1_1_2_4 + 0.00423280423280421*G0_0_1_1_2_5 + 0.0042328042328042*G0_0_1_1_3_0 - 0.0253968253968252*G0_0_1_1_3_1 + 0.00423280423280422*G0_0_1_1_3_2 - 0.0338624338624337*G0_0_1_1_3_3 - 0.00846560846560842*G0_0_1_1_3_4 - 0.0169312169312168*G0_0_1_1_3_5 + 0.00084656084656084*G0_0_1_1_4_0 + 0.000846560846560844*G0_0_1_1_4_2 - 0.00846560846560842*G0_0_1_1_4_3 - 0.0101587301587301*G0_0_1_1_4_4 - 0.00846560846560842*G0_0_1_1_4_5 + 0.0042328042328042*G0_0_1_1_5_0 - 0.0253968253968252*G0_0_1_1_5_1 + 0.00423280423280421*G0_0_1_1_5_2 - 0.0169312169312168*G0_0_1_1_5_3 - 0.00846560846560842*G0_0_1_1_5_4 - 0.0338624338624336*G0_0_1_1_5_5 - 0.000423280423280422*G0_0_1_2_0_0 - 0.00042328042328042*G0_0_1_2_0_1 - 0.000423280423280416*G0_0_1_2_0_2 - 0.00169312169312168*G0_0_1_2_0_3 - 0.00169312169312168*G0_0_1_2_0_4 - 0.00169312169312168*G0_0_1_2_0_5 - 0.00042328042328042*G0_0_1_2_1_0 + 0.00634920634920631*G0_0_1_2_1_1 - 0.00253968253968252*G0_0_1_2_1_2 + 0.00423280423280422*G0_0_1_2_1_3 + 0.000846560846560844*G0_0_1_2_1_4 + 0.00423280423280421*G0_0_1_2_1_5 - 0.000423280423280416*G0_0_1_2_2_0 - 0.00253968253968252*G0_0_1_2_2_1 + 0.00634920634920627*G0_0_1_2_2_2 + 0.00423280423280419*G0_0_1_2_2_3 + 0.00423280423280419*G0_0_1_2_2_4 + 0.000846560846560844*G0_0_1_2_2_5 - 0.00169312169312168*G0_0_1_2_3_0 + 0.00423280423280422*G0_0_1_2_3_1 + 0.00423280423280419*G0_0_1_2_3_2 + 0.0152380952380951*G0_0_1_2_3_3 + 0.00169312169312168*G0_0_1_2_3_4 + 0.00169312169312169*G0_0_1_2_3_5 - 0.00169312169312168*G0_0_1_2_4_0 + 0.000846560846560844*G0_0_1_2_4_1 + 0.00423280423280419*G0_0_1_2_4_2 + 0.00169312169312168*G0_0_1_2_4_3 - 0.0016931216931217*G0_0_1_2_4_4 - 0.00338624338624337*G0_0_1_2_4_5 - 0.00169312169312168*G0_0_1_2_5_0 + 0.00423280423280421*G0_0_1_2_5_1 + 0.000846560846560844*G0_0_1_2_5_2 + 0.00169312169312169*G0_0_1_2_5_3 - 0.00338624338624337*G0_0_1_2_5_4 - 0.00169312169312168*G0_0_1_2_5_5 + 0.000846560846560842*G0_0_1_3_0_0 + 0.0042328042328042*G0_0_1_3_0_1 - 0.00169312169312168*G0_0_1_3_0_2 - 0.00169312169312169*G0_0_1_3_0_3 - 0.00338624338624337*G0_0_1_3_0_4 + 0.00169312169312168*G0_0_1_3_0_5 + 0.0042328042328042*G0_0_1_3_1_0 - 0.0253968253968252*G0_0_1_3_1_1 + 0.00423280423280421*G0_0_1_3_1_2 - 0.0338624338624337*G0_0_1_3_1_3 - 0.00846560846560842*G0_0_1_3_1_4 - 0.0169312169312168*G0_0_1_3_1_5 - 0.00169312169312168*G0_0_1_3_2_0 + 0.00423280423280421*G0_0_1_3_2_1 + 0.00423280423280419*G0_0_1_3_2_2 + 0.0152380952380951*G0_0_1_3_2_3 + 0.00169312169312168*G0_0_1_3_2_4 + 0.00169312169312169*G0_0_1_3_2_5 - 0.00169312169312169*G0_0_1_3_3_0 - 0.0338624338624337*G0_0_1_3_3_1 + 0.0152380952380951*G0_0_1_3_3_2 + 0.0203174603174602*G0_0_1_3_3_4 - 0.00338624338624337*G0_0_1_3_4_0 - 0.00846560846560842*G0_0_1_3_4_1 + 0.00169312169312168*G0_0_1_3_4_2 + 0.0203174603174602*G0_0_1_3_4_3 + 0.0270899470899469*G0_0_1_3_4_4 + 0.0135449735449735*G0_0_1_3_4_5 + 0.00169312169312168*G0_0_1_3_5_0 - 0.0169312169312168*G0_0_1_3_5_1 + 0.00169312169312169*G0_0_1_3_5_2 + 0.0135449735449735*G0_0_1_3_5_4 + 0.00423280423280421*G0_0_1_4_0_0 + 0.00084656084656084*G0_0_1_4_0_1 - 0.00169312169312168*G0_0_1_4_0_2 - 0.00338624338624337*G0_0_1_4_0_3 - 0.00169312169312167*G0_0_1_4_0_4 + 0.00169312169312168*G0_0_1_4_0_5 + 0.00084656084656084*G0_0_1_4_1_0 + 0.000846560846560844*G0_0_1_4_1_2 - 0.00846560846560842*G0_0_1_4_1_3 - 0.0101587301587301*G0_0_1_4_1_4 - 0.00846560846560842*G0_0_1_4_1_5 - 0.00169312169312168*G0_0_1_4_2_0 + 0.000846560846560844*G0_0_1_4_2_1 + 0.00423280423280419*G0_0_1_4_2_2 + 0.00169312169312168*G0_0_1_4_2_3 - 0.0016931216931217*G0_0_1_4_2_4 - 0.00338624338624337*G0_0_1_4_2_5 - 0.00338624338624336*G0_0_1_4_3_0 - 0.00846560846560842*G0_0_1_4_3_1 + 0.00169312169312168*G0_0_1_4_3_2 + 0.0203174603174602*G0_0_1_4_3_3 + 0.0270899470899469*G0_0_1_4_3_4 + 0.0135449735449735*G0_0_1_4_3_5 - 0.00169312169312167*G0_0_1_4_4_0 - 0.0101587301587301*G0_0_1_4_4_1 - 0.0016931216931217*G0_0_1_4_4_2 + 0.0270899470899469*G0_0_1_4_4_3 + 0.0609523809523806*G0_0_1_4_4_4 + 0.027089947089947*G0_0_1_4_4_5 + 0.00169312169312168*G0_0_1_4_5_0 - 0.00846560846560842*G0_0_1_4_5_1 - 0.00338624338624337*G0_0_1_4_5_2 + 0.0135449735449735*G0_0_1_4_5_3 + 0.027089947089947*G0_0_1_4_5_4 + 0.0203174603174602*G0_0_1_4_5_5 + 0.00423280423280421*G0_0_1_5_0_0 + 0.0042328042328042*G0_0_1_5_0_1 - 0.00169312169312168*G0_0_1_5_0_2 + 0.00169312169312168*G0_0_1_5_0_3 + 0.00169312169312168*G0_0_1_5_0_4 + 0.0152380952380951*G0_0_1_5_0_5 + 0.0042328042328042*G0_0_1_5_1_0 - 0.0253968253968252*G0_0_1_5_1_1 + 0.00423280423280421*G0_0_1_5_1_2 - 0.0169312169312168*G0_0_1_5_1_3 - 0.00846560846560842*G0_0_1_5_1_4 - 0.0338624338624336*G0_0_1_5_1_5 - 0.00169312169312168*G0_0_1_5_2_0 + 0.00423280423280421*G0_0_1_5_2_1 + 0.000846560846560844*G0_0_1_5_2_2 + 0.00169312169312169*G0_0_1_5_2_3 - 0.00338624338624337*G0_0_1_5_2_4 - 0.00169312169312168*G0_0_1_5_2_5 + 0.00169312169312168*G0_0_1_5_3_0 - 0.0169312169312168*G0_0_1_5_3_1 + 0.00169312169312169*G0_0_1_5_3_2 + 0.0135449735449735*G0_0_1_5_3_4 + 0.00169312169312168*G0_0_1_5_4_0 - 0.00846560846560842*G0_0_1_5_4_1 - 0.00338624338624337*G0_0_1_5_4_2 + 0.0135449735449735*G0_0_1_5_4_3 + 0.027089947089947*G0_0_1_5_4_4 + 0.0203174603174602*G0_0_1_5_4_5 + 0.0152380952380951*G0_0_1_5_5_0 - 0.0338624338624336*G0_0_1_5_5_1 - 0.00169312169312168*G0_0_1_5_5_2 + 0.0203174603174602*G0_0_1_5_5_4;
    A[0] = A[7] + 0.0412698412698411*G0_0_0_0_0_0 - 0.00444444444444442*G0_0_0_0_0_1 - 0.00338624338624337*G0_0_0_0_0_2 + 0.000423280423280427*G0_0_0_0_0_3 + 0.0148148148148147*G0_0_0_0_0_4 + 0.0148148148148147*G0_0_0_0_0_5 - 0.00444444444444442*G0_0_0_0_1_0 + 0.00444444444444441*G0_0_0_0_1_1 + 0.00169312169312168*G0_0_0_0_1_3 - 0.00169312169312169*G0_0_0_0_1_4 - 0.00338624338624337*G0_0_0_0_2_0 + 0.00105820105820105*G0_0_0_0_2_2 - 0.00126984126984126*G0_0_0_0_2_3 - 0.00296296296296295*G0_0_0_0_2_4 - 0.00296296296296295*G0_0_0_0_2_5 + 0.000423280423280427*G0_0_0_0_3_0 + 0.00169312169312168*G0_0_0_0_3_1 - 0.00126984126984126*G0_0_0_0_3_2 + 0.00423280423280421*G0_0_0_0_3_3 + 0.00253968253968253*G0_0_0_0_3_4 + 0.00507936507936505*G0_0_0_0_3_5 + 0.0148148148148147*G0_0_0_0_4_0 - 0.00169312169312169*G0_0_0_0_4_1 - 0.00296296296296295*G0_0_0_0_4_2 + 0.00253968253968253*G0_0_0_0_4_3 + 0.016084656084656*G0_0_0_0_4_4 + 0.00931216931216927*G0_0_0_0_4_5 + 0.0148148148148147*G0_0_0_0_5_0 - 0.00296296296296295*G0_0_0_0_5_2 + 0.00507936507936505*G0_0_0_0_5_3 + 0.00931216931216927*G0_0_0_0_5_4 + 0.0245502645502644*G0_0_0_0_5_5 - 0.00444444444444442*G0_0_0_1_0_0 + 0.00444444444444441*G0_0_0_1_0_1 + 0.00169312169312168*G0_0_0_1_0_3 - 0.00169312169312169*G0_0_0_1_0_4 + 0.00444444444444441*G0_0_0_1_1_0 - 0.041269841269841*G0_0_0_1_1_1 + 0.00338624338624337*G0_0_0_1_1_2 - 0.0148148148148147*G0_0_0_1_1_3 - 0.000423280423280422*G0_0_0_1_1_4 - 0.0148148148148147*G0_0_0_1_1_5 + 0.00338624338624337*G0_0_0_1_2_1 - 0.00105820105820105*G0_0_0_1_2_2 + 0.00296296296296295*G0_0_0_1_2_3 + 0.00126984126984126*G0_0_0_1_2_4 + 0.00296296296296295*G0_0_0_1_2_5 + 0.00169312169312168*G0_0_0_1_3_0 - 0.0148148148148147*G0_0_0_1_3_1 + 0.00296296296296295*G0_0_0_1_3_2 - 0.016084656084656*G0_0_0_1_3_3 - 0.00253968253968253*G0_0_0_1_3_4 - 0.00931216931216926*G0_0_0_1_3_5 - 0.00169312169312169*G0_0_0_1_4_0 - 0.000423280423280422*G0_0_0_1_4_1 + 0.00126984126984126*G0_0_0_1_4_2 - 0.00253968253968253*G0_0_0_1_4_3 - 0.00423280423280421*G0_0_0_1_4_4 - 0.00507936507936505*G0_0_0_1_4_5 - 0.0148148148148147*G0_0_0_1_5_1 + 0.00296296296296295*G0_0_0_1_5_2 - 0.00931216931216926*G0_0_0_1_5_3 - 0.00507936507936506*G0_0_0_1_5_4 - 0.0245502645502644*G0_0_0_1_5_5 - 0.00338624338624337*G0_0_0_2_0_0 + 0.00105820105820105*G0_0_0_2_0_2 - 0.00126984126984126*G0_0_0_2_0_3 - 0.00296296296296295*G0_0_0_2_0_4 - 0.00296296296296295*G0_0_0_2_0_5 + 0.00338624338624337*G0_0_0_2_1_1 - 0.00105820105820105*G0_0_0_2_1_2 + 0.00296296296296295*G0_0_0_2_1_3 + 0.00126984126984126*G0_0_0_2_1_4 + 0.00296296296296295*G0_0_0_2_1_5 + 0.00105820105820105*G0_0_0_2_2_0 - 0.00105820105820105*G0_0_0_2_2_1 - 0.00126984126984126*G0_0_0_2_3_0 + 0.00296296296296295*G0_0_0_2_3_1 + 0.00846560846560843*G0_0_0_2_3_3 + 0.00253968253968253*G0_0_0_2_3_5 - 0.00296296296296295*G0_0_0_2_4_0 + 0.00126984126984126*G0_0_0_2_4_1 - 0.00846560846560843*G0_0_0_2_4_4 - 0.00253968253968253*G0_0_0_2_4_5 - 0.00296296296296295*G0_0_0_2_5_0 + 0.00296296296296295*G0_0_0_2_5_1 + 0.00253968253968253*G0_0_0_2_5_3 - 0.00253968253968253*G0_0_0_2_5_4 + 0.000423280423280427*G0_0_0_3_0_0 + 0.00169312169312168*G0_0_0_3_0_1 - 0.00126984126984126*G0_0_0_3_0_2 + 0.00423280423280421*G0_0_0_3_0_3 + 0.00253968253968253*G0_0_0_3_0_4 + 0.00507936507936505*G0_0_0_3_0_5 + 0.00169312169312168*G0_0_0_3_1_0 - 0.0148148148148147*G0_0_0_3_1_1 + 0.00296296296296295*G0_0_0_3_1_2 - 0.016084656084656*G0_0_0_3_1_3 - 0.00253968253968253*G0_0_0_3_1_4 - 0.00931216931216926*G0_0_0_3_1_5 - 0.00126984126984126*G0_0_0_3_2_0 + 0.00296296296296295*G0_0_0_3_2_1 + 0.00846560846560843*G0_0_0_3_2_3 + 0.00253968253968253*G0_0_0_3_2_5 + 0.00423280423280421*G0_0_0_3_3_0 - 0.016084656084656*G0_0_0_3_3_1 + 0.00846560846560843*G0_0_0_3_3_2 - 0.0304761904761903*G0_0_0_3_3_3 - 0.00338624338624338*G0_0_0_3_3_4 - 0.0135449735449735*G0_0_0_3_3_5 + 0.00253968253968253*G0_0_0_3_4_0 - 0.00253968253968253*G0_0_0_3_4_1 - 0.00338624338624338*G0_0_0_3_4_3 + 0.00338624338624337*G0_0_0_3_4_4 + 0.00507936507936505*G0_0_0_3_5_0 - 0.00931216931216926*G0_0_0_3_5_1 + 0.00253968253968253*G0_0_0_3_5_2 - 0.0135449735449735*G0_0_0_3_5_3 - 0.0101587301587301*G0_0_0_3_5_5 + 0.0148148148148148*G0_0_0_4_0_0 - 0.00169312169312169*G0_0_0_4_0_1 - 0.00296296296296295*G0_0_0_4_0_2 + 0.00253968253968253*G0_0_0_4_0_3 + 0.016084656084656*G0_0_0_4_0_4 + 0.00931216931216927*G0_0_0_4_0_5 - 0.00169312169312169*G0_0_0_4_1_0 - 0.000423280423280422*G0_0_0_4_1_1 + 0.00126984126984126*G0_0_0_4_1_2 - 0.00253968253968253*G0_0_0_4_1_3 - 0.00423280423280421*G0_0_0_4_1_4 - 0.00507936507936505*G0_0_0_4_1_5 - 0.00296296296296295*G0_0_0_4_2_0 + 0.00126984126984126*G0_0_0_4_2_1 - 0.00846560846560843*G0_0_0_4_2_4 - 0.00253968253968253*G0_0_0_4_2_5 + 0.00253968253968253*G0_0_0_4_3_0 - 0.00253968253968253*G0_0_0_4_3_1 - 0.00338624338624338*G0_0_0_4_3_3 + 0.00338624338624337*G0_0_0_4_3_4 + 0.016084656084656*G0_0_0_4_4_0 - 0.00423280423280421*G0_0_0_4_4_1 - 0.00846560846560843*G0_0_0_4_4_2 + 0.00338624338624337*G0_0_0_4_4_3 + 0.0304761904761903*G0_0_0_4_4_4 + 0.0135449735449735*G0_0_0_4_4_5 + 0.00931216931216927*G0_0_0_4_5_0 - 0.00507936507936505*G0_0_0_4_5_1 - 0.00253968253968253*G0_0_0_4_5_2 + 0.0135449735449735*G0_0_0_4_5_4 + 0.0101587301587301*G0_0_0_4_5_5 + 0.0148148148148147*G0_0_0_5_0_0 - 0.00296296296296295*G0_0_0_5_0_2 + 0.00507936507936505*G0_0_0_5_0_3 + 0.00931216931216927*G0_0_0_5_0_4 + 0.0245502645502644*G0_0_0_5_0_5 - 0.0148148148148147*G0_0_0_5_1_1 + 0.00296296296296295*G0_0_0_5_1_2 - 0.00931216931216926*G0_0_0_5_1_3 - 0.00507936507936506*G0_0_0_5_1_4 - 0.0245502645502644*G0_0_0_5_1_5 - 0.00296296296296295*G0_0_0_5_2_0 + 0.00296296296296295*G0_0_0_5_2_1 + 0.00253968253968253*G0_0_0_5_2_3 - 0.00253968253968253*G0_0_0_5_2_4 + 0.00507936507936505*G0_0_0_5_3_0 - 0.00931216931216926*G0_0_0_5_3_1 + 0.00253968253968253*G0_0_0_5_3_2 - 0.0135449735449735*G0_0_0_5_3_3 - 0.0101587301587301*G0_0_0_5_3_5 + 0.00931216931216927*G0_0_0_5_4_0 - 0.00507936507936506*G0_0_0_5_4_1 - 0.00253968253968253*G0_0_0_5_4_2 + 0.0135449735449735*G0_0_0_5_4_4 + 0.0101587301587301*G0_0_0_5_4_5 + 0.0245502645502644*G0_0_0_5_5_0 - 0.0245502645502644*G0_0_0_5_5_1 - 0.0101587301587301*G0_0_0_5_5_3 + 0.0101587301587301*G0_0_0_5_5_4 + 0.045238095238095*G0_0_1_0_0_0 - 0.00396825396825395*G0_0_1_0_0_1 - 0.00396825396825395*G0_0_1_0_0_2 + 0.00158730158730158*G0_0_1_0_0_3 + 0.0174603174603174*G0_0_1_0_0_4 + 0.0174603174603174*G0_0_1_0_0_5 - 0.00396825396825395*G0_0_1_0_1_0 + 0.000476190476190475*G0_0_1_0_1_1 + 0.000608465608465606*G0_0_1_0_1_2 - 0.000423280423280421*G0_0_1_0_1_3 - 0.00211640211640211*G0_0_1_0_1_4 - 0.00370370370370368*G0_0_1_0_1_5 - 0.00396825396825395*G0_0_1_0_2_0 + 0.000608465608465606*G0_0_1_0_2_1 + 0.000476190476190475*G0_0_1_0_2_2 - 0.000423280423280422*G0_0_1_0_2_3 - 0.00370370370370369*G0_0_1_0_2_4 - 0.00211640211640211*G0_0_1_0_2_5 + 0.00158730158730158*G0_0_1_0_3_0 - 0.000423280423280422*G0_0_1_0_3_1 - 0.000423280423280422*G0_0_1_0_3_2 - 0.00126984126984126*G0_0_1_0_3_3 + 0.00105820105820106*G0_0_1_0_3_4 + 0.00105820105820105*G0_0_1_0_3_5 + 0.0174603174603174*G0_0_1_0_4_0 - 0.00211640211640211*G0_0_1_0_4_1 - 0.00370370370370369*G0_0_1_0_4_2 + 0.00105820105820106*G0_0_1_0_4_3 + 0.0169312169312169*G0_0_1_0_4_4 + 0.00846560846560843*G0_0_1_0_4_5 + 0.0174603174603174*G0_0_1_0_5_0 - 0.00370370370370368*G0_0_1_0_5_1 - 0.00211640211640211*G0_0_1_0_5_2 + 0.00105820105820105*G0_0_1_0_5_3 + 0.00846560846560843*G0_0_1_0_5_4 + 0.0169312169312168*G0_0_1_0_5_5 - 0.00396825396825395*G0_0_1_1_0_0 + 0.000476190476190475*G0_0_1_1_0_1 + 0.000608465608465606*G0_0_1_1_0_2 - 0.000423280423280422*G0_0_1_1_0_3 - 0.00211640211640211*G0_0_1_1_0_4 - 0.00370370370370368*G0_0_1_1_0_5 + 0.000476190476190475*G0_0_1_1_1_0 + 0.00396825396825394*G0_0_1_1_1_1 - 0.000582010582010579*G0_0_1_1_1_2 + 0.00264550264550263*G0_0_1_1_1_3 + 0.00116402116402116*G0_0_1_1_1_4 + 0.00264550264550263*G0_0_1_1_1_5 + 0.000608465608465606*G0_0_1_1_2_0 - 0.000582010582010579*G0_0_1_1_2_1 - 0.000582010582010579*G0_0_1_1_2_2 - 0.000740740740740737*G0_0_1_1_2_3 + 0.000846560846560843*G0_0_1_1_2_4 + 0.000846560846560842*G0_0_1_1_2_5 - 0.000423280423280422*G0_0_1_1_3_0 + 0.00264550264550263*G0_0_1_1_3_1 - 0.000740740740740737*G0_0_1_1_3_2 + 0.000846560846560842*G0_0_1_1_3_3 - 0.00148148148148147*G0_0_1_1_3_4 - 0.000846560846560843*G0_0_1_1_3_5 - 0.00211640211640211*G0_0_1_1_4_0 + 0.00116402116402116*G0_0_1_1_4_1 + 0.000846560846560843*G0_0_1_1_4_2 - 0.00148148148148147*G0_0_1_1_4_3 - 0.00550264550264548*G0_0_1_1_4_4 - 0.004021164021164*G0_0_1_1_4_5 - 0.00370370370370368*G0_0_1_1_5_0 + 0.00264550264550263*G0_0_1_1_5_1 + 0.000846560846560842*G0_0_1_1_5_2 - 0.000846560846560843*G0_0_1_1_5_3 - 0.004021164021164*G0_0_1_1_5_4 - 0.00761904761904757*G0_0_1_1_5_5 - 0.00396825396825395*G0_0_1_2_0_0 + 0.000608465608465606*G0_0_1_2_0_1 + 0.000476190476190475*G0_0_1_2_0_2 - 0.000423280423280422*G0_0_1_2_0_3 - 0.00370370370370369*G0_0_1_2_0_4 - 0.00211640211640211*G0_0_1_2_0_5 + 0.000608465608465606*G0_0_1_2_1_0 - 0.000582010582010579*G0_0_1_2_1_1 - 0.000582010582010579*G0_0_1_2_1_2 - 0.000740740740740737*G0_0_1_2_1_3 + 0.000846560846560843*G0_0_1_2_1_4 + 0.000846560846560842*G0_0_1_2_1_5 + 0.000476190476190475*G0_0_1_2_2_0 - 0.000582010582010579*G0_0_1_2_2_1 + 0.00396825396825395*G0_0_1_2_2_2 + 0.00264550264550263*G0_0_1_2_2_3 + 0.00264550264550263*G0_0_1_2_2_4 + 0.00116402116402116*G0_0_1_2_2_5 - 0.000423280423280422*G0_0_1_2_3_0 - 0.000740740740740737*G0_0_1_2_3_1 + 0.00264550264550263*G0_0_1_2_3_2 + 0.000846560846560843*G0_0_1_2_3_3 - 0.000846560846560843*G0_0_1_2_3_4 - 0.00148148148148147*G0_0_1_2_3_5 - 0.00370370370370369*G0_0_1_2_4_0 + 0.000846560846560843*G0_0_1_2_4_1 + 0.00264550264550263*G0_0_1_2_4_2 - 0.000846560846560843*G0_0_1_2_4_3 - 0.00761904761904759*G0_0_1_2_4_4 - 0.00402116402116401*G0_0_1_2_4_5 - 0.00211640211640211*G0_0_1_2_5_0 + 0.000846560846560842*G0_0_1_2_5_1 + 0.00116402116402116*G0_0_1_2_5_2 - 0.00148148148148147*G0_0_1_2_5_3 - 0.00402116402116401*G0_0_1_2_5_4 - 0.00550264550264548*G0_0_1_2_5_5 + 0.00158730158730158*G0_0_1_3_0_0 - 0.000423280423280421*G0_0_1_3_0_1 - 0.000423280423280422*G0_0_1_3_0_2 - 0.00126984126984126*G0_0_1_3_0_3 + 0.00105820105820106*G0_0_1_3_0_4 + 0.00105820105820105*G0_0_1_3_0_5 - 0.000423280423280422*G0_0_1_3_1_0 + 0.00264550264550263*G0_0_1_3_1_1 - 0.000740740740740737*G0_0_1_3_1_2 + 0.000846560846560842*G0_0_1_3_1_3 - 0.00148148148148147*G0_0_1_3_1_4 - 0.000846560846560843*G0_0_1_3_1_5 - 0.000423280423280422*G0_0_1_3_2_0 - 0.000740740740740737*G0_0_1_3_2_1 + 0.00264550264550263*G0_0_1_3_2_2 + 0.000846560846560843*G0_0_1_3_2_3 - 0.000846560846560843*G0_0_1_3_2_4 - 0.00148148148148147*G0_0_1_3_2_5 - 0.00126984126984126*G0_0_1_3_3_0 + 0.000846560846560842*G0_0_1_3_3_1 + 0.000846560846560843*G0_0_1_3_3_2 + 0.0266666666666665*G0_0_1_3_3_3 + 0.00550264550264548*G0_0_1_3_3_4 + 0.00550264550264548*G0_0_1_3_3_5 + 0.00105820105820106*G0_0_1_3_4_0 - 0.00148148148148147*G0_0_1_3_4_1 - 0.000846560846560843*G0_0_1_3_4_2 + 0.00550264550264548*G0_0_1_3_4_3 + 0.00888888888888885*G0_0_1_3_4_4 + 0.0059259259259259*G0_0_1_3_4_5 + 0.00105820105820105*G0_0_1_3_5_0 - 0.000846560846560843*G0_0_1_3_5_1 - 0.00148148148148147*G0_0_1_3_5_2 + 0.00550264550264548*G0_0_1_3_5_3 + 0.0059259259259259*G0_0_1_3_5_4 + 0.00888888888888884*G0_0_1_3_5_5 + 0.0174603174603174*G0_0_1_4_0_0 - 0.00211640211640211*G0_0_1_4_0_1 - 0.00370370370370369*G0_0_1_4_0_2 + 0.00105820105820106*G0_0_1_4_0_3 + 0.0169312169312169*G0_0_1_4_0_4 + 0.00846560846560843*G0_0_1_4_0_5 - 0.00211640211640211*G0_0_1_4_1_0 + 0.00116402116402116*G0_0_1_4_1_1 + 0.000846560846560843*G0_0_1_4_1_2 - 0.00148148148148147*G0_0_1_4_1_3 - 0.00550264550264548*G0_0_1_4_1_4 - 0.004021164021164*G0_0_1_4_1_5 - 0.00370370370370369*G0_0_1_4_2_0 + 0.000846560846560843*G0_0_1_4_2_1 + 0.00264550264550263*G0_0_1_4_2_2 - 0.000846560846560843*G0_0_1_4_2_3 - 0.00761904761904759*G0_0_1_4_2_4 - 0.00402116402116401*G0_0_1_4_2_5 + 0.00105820105820106*G0_0_1_4_3_0 - 0.00148148148148147*G0_0_1_4_3_1 - 0.000846560846560843*G0_0_1_4_3_2 + 0.00550264550264548*G0_0_1_4_3_3 + 0.00888888888888885*G0_0_1_4_3_4 + 0.0059259259259259*G0_0_1_4_3_5 + 0.0169312169312169*G0_0_1_4_4_0 - 0.00550264550264548*G0_0_1_4_4_1 - 0.00761904761904759*G0_0_1_4_4_2 + 0.00888888888888885*G0_0_1_4_4_3 + 0.0571428571428569*G0_0_1_4_4_4 + 0.019047619047619*G0_0_1_4_4_5 + 0.00846560846560843*G0_0_1_4_5_0 - 0.004021164021164*G0_0_1_4_5_1 - 0.00402116402116401*G0_0_1_4_5_2 + 0.0059259259259259*G0_0_1_4_5_3 + 0.019047619047619*G0_0_1_4_5_4 + 0.019047619047619*G0_0_1_4_5_5 + 0.0174603174603174*G0_0_1_5_0_0 - 0.00370370370370368*G0_0_1_5_0_1 - 0.00211640211640211*G0_0_1_5_0_2 + 0.00105820105820105*G0_0_1_5_0_3 + 0.00846560846560843*G0_0_1_5_0_4 + 0.0169312169312168*G0_0_1_5_0_5 - 0.00370370370370368*G0_0_1_5_1_0 + 0.00264550264550263*G0_0_1_5_1_1 + 0.000846560846560842*G0_0_1_5_1_2 - 0.000846560846560843*G0_0_1_5_1_3 - 0.004021164021164*G0_0_1_5_1_4 - 0.00761904761904757*G0_0_1_5_1_5 - 0.00211640211640211*G0_0_1_5_2_0 + 0.000846560846560842*G0_0_1_5_2_1 + 0.00116402116402116*G0_0_1_5_2_2 - 0.00148148148148147*G0_0_1_5_2_3 - 0.00402116402116401*G0_0_1_5_2_4 - 0.00550264550264548*G0_0_1_5_2_5 + 0.00105820105820105*G0_0_1_5_3_0 - 0.000846560846560843*G0_0_1_5_3_1 - 0.00148148148148147*G0_0_1_5_3_2 + 0.00550264550264548*G0_0_1_5_3_3 + 0.0059259259259259*G0_0_1_5_3_4 + 0.00888888888888884*G0_0_1_5_3_5 + 0.00846560846560843*G0_0_1_5_4_0 - 0.004021164021164*G0_0_1_5_4_1 - 0.00402116402116401*G0_0_1_5_4_2 + 0.0059259259259259*G0_0_1_5_4_3 + 0.019047619047619*G0_0_1_5_4_4 + 0.019047619047619*G0_0_1_5_4_5 + 0.0169312169312168*G0_0_1_5_5_0 - 0.00761904761904757*G0_0_1_5_5_1 - 0.00550264550264548*G0_0_1_5_5_2 + 0.00888888888888884*G0_0_1_5_5_3 + 0.019047619047619*G0_0_1_5_5_4 + 0.0571428571428568*G0_0_1_5_5_5 + 0.045238095238095*G0_1_0_0_0_0 - 0.00396825396825395*G0_1_0_0_0_1 - 0.00396825396825395*G0_1_0_0_0_2 + 0.00158730158730158*G0_1_0_0_0_3 + 0.0174603174603174*G0_1_0_0_0_4 + 0.0174603174603174*G0_1_0_0_0_5 - 0.00396825396825395*G0_1_0_0_1_0 + 0.000476190476190475*G0_1_0_0_1_1 + 0.000608465608465606*G0_1_0_0_1_2 - 0.000423280423280421*G0_1_0_0_1_3 - 0.00211640211640211*G0_1_0_0_1_4 - 0.00370370370370368*G0_1_0_0_1_5 - 0.00396825396825395*G0_1_0_0_2_0 + 0.000608465608465606*G0_1_0_0_2_1 + 0.000476190476190475*G0_1_0_0_2_2 - 0.000423280423280422*G0_1_0_0_2_3 - 0.00370370370370369*G0_1_0_0_2_4 - 0.00211640211640211*G0_1_0_0_2_5 + 0.00158730158730158*G0_1_0_0_3_0 - 0.000423280423280421*G0_1_0_0_3_1 - 0.000423280423280422*G0_1_0_0_3_2 - 0.00126984126984126*G0_1_0_0_3_3 + 0.00105820105820106*G0_1_0_0_3_4 + 0.00105820105820105*G0_1_0_0_3_5 + 0.0174603174603174*G0_1_0_0_4_0 - 0.00211640211640211*G0_1_0_0_4_1 - 0.00370370370370369*G0_1_0_0_4_2 + 0.00105820105820106*G0_1_0_0_4_3 + 0.0169312169312169*G0_1_0_0_4_4 + 0.00846560846560843*G0_1_0_0_4_5 + 0.0174603174603174*G0_1_0_0_5_0 - 0.00370370370370368*G0_1_0_0_5_1 - 0.00211640211640211*G0_1_0_0_5_2 + 0.00105820105820105*G0_1_0_0_5_3 + 0.00846560846560843*G0_1_0_0_5_4 + 0.0169312169312168*G0_1_0_0_5_5 - 0.00396825396825395*G0_1_0_1_0_0 + 0.000476190476190475*G0_1_0_1_0_1 + 0.000608465608465606*G0_1_0_1_0_2 - 0.000423280423280421*G0_1_0_1_0_3 - 0.00211640211640211*G0_1_0_1_0_4 - 0.00370370370370368*G0_1_0_1_0_5 + 0.000476190476190475*G0_1_0_1_1_0 + 0.00396825396825394*G0_1_0_1_1_1 - 0.000582010582010579*G0_1_0_1_1_2 + 0.00264550264550263*G0_1_0_1_1_3 + 0.00116402116402116*G0_1_0_1_1_4 + 0.00264550264550263*G0_1_0_1_1_5 + 0.000608465608465606*G0_1_0_1_2_0 - 0.000582010582010579*G0_1_0_1_2_1 - 0.000582010582010579*G0_1_0_1_2_2 - 0.000740740740740737*G0_1_0_1_2_3 + 0.000846560846560843*G0_1_0_1_2_4 + 0.000846560846560842*G0_1_0_1_2_5 - 0.000423280423280421*G0_1_0_1_3_0 + 0.00264550264550263*G0_1_0_1_3_1 - 0.000740740740740737*G0_1_0_1_3_2 + 0.000846560846560842*G0_1_0_1_3_3 - 0.00148148148148147*G0_1_0_1_3_4 - 0.000846560846560843*G0_1_0_1_3_5 - 0.00211640211640211*G0_1_0_1_4_0 + 0.00116402116402116*G0_1_0_1_4_1 + 0.000846560846560843*G0_1_0_1_4_2 - 0.00148148148148147*G0_1_0_1_4_3 - 0.00550264550264548*G0_1_0_1_4_4 - 0.004021164021164*G0_1_0_1_4_5 - 0.00370370370370368*G0_1_0_1_5_0 + 0.00264550264550263*G0_1_0_1_5_1 + 0.000846560846560842*G0_1_0_1_5_2 - 0.000846560846560843*G0_1_0_1_5_3 - 0.004021164021164*G0_1_0_1_5_4 - 0.00761904761904757*G0_1_0_1_5_5 - 0.00396825396825395*G0_1_0_2_0_0 + 0.000608465608465606*G0_1_0_2_0_1 + 0.000476190476190475*G0_1_0_2_0_2 - 0.000423280423280422*G0_1_0_2_0_3 - 0.00370370370370369*G0_1_0_2_0_4 - 0.00211640211640211*G0_1_0_2_0_5 + 0.000608465608465606*G0_1_0_2_1_0 - 0.000582010582010579*G0_1_0_2_1_1 - 0.000582010582010579*G0_1_0_2_1_2 - 0.000740740740740737*G0_1_0_2_1_3 + 0.000846560846560843*G0_1_0_2_1_4 + 0.000846560846560842*G0_1_0_2_1_5 + 0.000476190476190475*G0_1_0_2_2_0 - 0.000582010582010579*G0_1_0_2_2_1 + 0.00396825396825395*G0_1_0_2_2_2 + 0.00264550264550263*G0_1_0_2_2_3 + 0.00264550264550263*G0_1_0_2_2_4 + 0.00116402116402116*G0_1_0_2_2_5 - 0.000423280423280422*G0_1_0_2_3_0 - 0.000740740740740737*G0_1_0_2_3_1 + 0.00264550264550263*G0_1_0_2_3_2 + 0.000846560846560842*G0_1_0_2_3_3 - 0.000846560846560843*G0_1_0_2_3_4 - 0.00148148148148147*G0_1_0_2_3_5 - 0.00370370370370369*G0_1_0_2_4_0 + 0.000846560846560843*G0_1_0_2_4_1 + 0.00264550264550263*G0_1_0_2_4_2 - 0.000846560846560843*G0_1_0_2_4_3 - 0.00761904761904759*G0_1_0_2_4_4 - 0.00402116402116401*G0_1_0_2_4_5 - 0.00211640211640211*G0_1_0_2_5_0 + 0.000846560846560842*G0_1_0_2_5_1 + 0.00116402116402116*G0_1_0_2_5_2 - 0.00148148148148147*G0_1_0_2_5_3 - 0.00402116402116401*G0_1_0_2_5_4 - 0.00550264550264548*G0_1_0_2_5_5 + 0.00158730158730158*G0_1_0_3_0_0 - 0.000423280423280421*G0_1_0_3_0_1 - 0.000423280423280422*G0_1_0_3_0_2 - 0.00126984126984126*G0_1_0_3_0_3 + 0.00105820105820106*G0_1_0_3_0_4 + 0.00105820105820105*G0_1_0_3_0_5 - 0.000423280423280422*G0_1_0_3_1_0 + 0.00264550264550263*G0_1_0_3_1_1 - 0.000740740740740737*G0_1_0_3_1_2 + 0.000846560846560842*G0_1_0_3_1_3 - 0.00148148148148147*G0_1_0_3_1_4 - 0.000846560846560842*G0_1_0_3_1_5 - 0.000423280423280422*G0_1_0_3_2_0 - 0.000740740740740737*G0_1_0_3_2_1 + 0.00264550264550263*G0_1_0_3_2_2 + 0.000846560846560842*G0_1_0_3_2_3 - 0.000846560846560842*G0_1_0_3_2_4 - 0.00148148148148147*G0_1_0_3_2_5 - 0.00126984126984126*G0_1_0_3_3_0 + 0.000846560846560842*G0_1_0_3_3_1 + 0.000846560846560842*G0_1_0_3_3_2 + 0.0266666666666665*G0_1_0_3_3_3 + 0.00550264550264548*G0_1_0_3_3_4 + 0.00550264550264548*G0_1_0_3_3_5 + 0.00105820105820106*G0_1_0_3_4_0 - 0.00148148148148147*G0_1_0_3_4_1 - 0.000846560846560842*G0_1_0_3_4_2 + 0.00550264550264548*G0_1_0_3_4_3 + 0.00888888888888885*G0_1_0_3_4_4 + 0.0059259259259259*G0_1_0_3_4_5 + 0.00105820105820105*G0_1_0_3_5_0 - 0.000846560846560842*G0_1_0_3_5_1 - 0.00148148148148147*G0_1_0_3_5_2 + 0.00550264550264548*G0_1_0_3_5_3 + 0.0059259259259259*G0_1_0_3_5_4 + 0.00888888888888884*G0_1_0_3_5_5 + 0.0174603174603174*G0_1_0_4_0_0 - 0.00211640211640211*G0_1_0_4_0_1 - 0.00370370370370369*G0_1_0_4_0_2 + 0.00105820105820106*G0_1_0_4_0_3 + 0.0169312169312169*G0_1_0_4_0_4 + 0.00846560846560843*G0_1_0_4_0_5 - 0.00211640211640211*G0_1_0_4_1_0 + 0.00116402116402116*G0_1_0_4_1_1 + 0.000846560846560843*G0_1_0_4_1_2 - 0.00148148148148147*G0_1_0_4_1_3 - 0.00550264550264548*G0_1_0_4_1_4 - 0.004021164021164*G0_1_0_4_1_5 - 0.00370370370370369*G0_1_0_4_2_0 + 0.000846560846560843*G0_1_0_4_2_1 + 0.00264550264550263*G0_1_0_4_2_2 - 0.000846560846560843*G0_1_0_4_2_3 - 0.00761904761904759*G0_1_0_4_2_4 - 0.00402116402116401*G0_1_0_4_2_5 + 0.00105820105820106*G0_1_0_4_3_0 - 0.00148148148148147*G0_1_0_4_3_1 - 0.000846560846560843*G0_1_0_4_3_2 + 0.00550264550264548*G0_1_0_4_3_3 + 0.00888888888888885*G0_1_0_4_3_4 + 0.0059259259259259*G0_1_0_4_3_5 + 0.0169312169312169*G0_1_0_4_4_0 - 0.00550264550264548*G0_1_0_4_4_1 - 0.00761904761904759*G0_1_0_4_4_2 + 0.00888888888888885*G0_1_0_4_4_3 + 0.0571428571428569*G0_1_0_4_4_4 + 0.019047619047619*G0_1_0_4_4_5 + 0.00846560846560843*G0_1_0_4_5_0 - 0.004021164021164*G0_1_0_4_5_1 - 0.00402116402116401*G0_1_0_4_5_2 + 0.0059259259259259*G0_1_0_4_5_3 + 0.019047619047619*G0_1_0_4_5_4 + 0.019047619047619*G0_1_0_4_5_5 + 0.0174603174603174*G0_1_0_5_0_0 - 0.00370370370370368*G0_1_0_5_0_1 - 0.00211640211640211*G0_1_0_5_0_2 + 0.00105820105820105*G0_1_0_5_0_3 + 0.00846560846560843*G0_1_0_5_0_4 + 0.0169312169312168*G0_1_0_5_0_5 - 0.00370370370370368*G0_1_0_5_1_0 + 0.00264550264550263*G0_1_0_5_1_1 + 0.000846560846560842*G0_1_0_5_1_2 - 0.000846560846560843*G0_1_0_5_1_3 - 0.004021164021164*G0_1_0_5_1_4 - 0.00761904761904757*G0_1_0_5_1_5 - 0.00211640211640211*G0_1_0_5_2_0 + 0.000846560846560842*G0_1_0_5_2_1 + 0.00116402116402116*G0_1_0_5_2_2 - 0.00148148148148147*G0_1_0_5_2_3 - 0.00402116402116401*G0_1_0_5_2_4 - 0.00550264550264548*G0_1_0_5_2_5 + 0.00105820105820105*G0_1_0_5_3_0 - 0.000846560846560842*G0_1_0_5_3_1 - 0.00148148148148147*G0_1_0_5_3_2 + 0.00550264550264548*G0_1_0_5_3_3 + 0.0059259259259259*G0_1_0_5_3_4 + 0.00888888888888884*G0_1_0_5_3_5 + 0.00846560846560843*G0_1_0_5_4_0 - 0.004021164021164*G0_1_0_5_4_1 - 0.00402116402116401*G0_1_0_5_4_2 + 0.0059259259259259*G0_1_0_5_4_3 + 0.019047619047619*G0_1_0_5_4_4 + 0.019047619047619*G0_1_0_5_4_5 + 0.0169312169312168*G0_1_0_5_5_0 - 0.00761904761904757*G0_1_0_5_5_1 - 0.00550264550264548*G0_1_0_5_5_2 + 0.00888888888888884*G0_1_0_5_5_3 + 0.019047619047619*G0_1_0_5_5_4 + 0.0571428571428568*G0_1_0_5_5_5 + 0.045238095238095*G0_1_1_0_0_0 - 0.00396825396825395*G0_1_1_0_0_1 - 0.00396825396825395*G0_1_1_0_0_2 + 0.00158730158730158*G0_1_1_0_0_3 + 0.0174603174603174*G0_1_1_0_0_4 + 0.0174603174603174*G0_1_1_0_0_5 - 0.00396825396825395*G0_1_1_0_1_0 + 0.000476190476190474*G0_1_1_0_1_1 + 0.000608465608465606*G0_1_1_0_1_2 - 0.000423280423280422*G0_1_1_0_1_3 - 0.00211640211640211*G0_1_1_0_1_4 - 0.00370370370370368*G0_1_1_0_1_5 - 0.00396825396825395*G0_1_1_0_2_0 + 0.000608465608465606*G0_1_1_0_2_1 + 0.000476190476190475*G0_1_1_0_2_2 - 0.000423280423280421*G0_1_1_0_2_3 - 0.00370370370370369*G0_1_1_0_2_4 - 0.00211640211640211*G0_1_1_0_2_5 + 0.00158730158730158*G0_1_1_0_3_0 - 0.000423280423280422*G0_1_1_0_3_1 - 0.000423280423280421*G0_1_1_0_3_2 - 0.00126984126984126*G0_1_1_0_3_3 + 0.00105820105820106*G0_1_1_0_3_4 + 0.00105820105820105*G0_1_1_0_3_5 + 0.0174603174603174*G0_1_1_0_4_0 - 0.00211640211640211*G0_1_1_0_4_1 - 0.00370370370370369*G0_1_1_0_4_2 + 0.00105820105820106*G0_1_1_0_4_3 + 0.0169312169312169*G0_1_1_0_4_4 + 0.00846560846560843*G0_1_1_0_4_5 + 0.0174603174603174*G0_1_1_0_5_0 - 0.00370370370370368*G0_1_1_0_5_1 - 0.00211640211640211*G0_1_1_0_5_2 + 0.00105820105820105*G0_1_1_0_5_3 + 0.00846560846560843*G0_1_1_0_5_4 + 0.0169312169312168*G0_1_1_0_5_5 - 0.00396825396825395*G0_1_1_1_0_0 + 0.000476190476190474*G0_1_1_1_0_1 + 0.000608465608465606*G0_1_1_1_0_2 - 0.000423280423280422*G0_1_1_1_0_3 - 0.00211640211640211*G0_1_1_1_0_4 - 0.00370370370370369*G0_1_1_1_0_5 + 0.000476190476190474*G0_1_1_1_1_0 + 0.00396825396825395*G0_1_1_1_1_1 - 0.00058201058201058*G0_1_1_1_1_2 + 0.00264550264550263*G0_1_1_1_1_3 + 0.00116402116402116*G0_1_1_1_1_4 + 0.00264550264550263*G0_1_1_1_1_5 + 0.000608465608465606*G0_1_1_1_2_0 - 0.00058201058201058*G0_1_1_1_2_1 - 0.000582010582010579*G0_1_1_1_2_2 - 0.000740740740740737*G0_1_1_1_2_3 + 0.000846560846560844*G0_1_1_1_2_4 + 0.000846560846560842*G0_1_1_1_2_5 - 0.000423280423280422*G0_1_1_1_3_0 + 0.00264550264550263*G0_1_1_1_3_1 - 0.000740740740740737*G0_1_1_1_3_2 + 0.000846560846560845*G0_1_1_1_3_3 - 0.00148148148148147*G0_1_1_1_3_4 - 0.000846560846560842*G0_1_1_1_3_5 - 0.00211640211640211*G0_1_1_1_4_0 + 0.00116402116402116*G0_1_1_1_4_1 + 0.000846560846560844*G0_1_1_1_4_2 - 0.00148148148148147*G0_1_1_1_4_3 - 0.00550264550264548*G0_1_1_1_4_4 - 0.004021164021164*G0_1_1_1_4_5 - 0.00370370370370368*G0_1_1_1_5_0 + 0.00264550264550263*G0_1_1_1_5_1 + 0.000846560846560842*G0_1_1_1_5_2 - 0.000846560846560842*G0_1_1_1_5_3 - 0.004021164021164*G0_1_1_1_5_4 - 0.00761904761904757*G0_1_1_1_5_5 - 0.00396825396825395*G0_1_1_2_0_0 + 0.000608465608465606*G0_1_1_2_0_1 + 0.000476190476190475*G0_1_1_2_0_2 - 0.000423280423280422*G0_1_1_2_0_3 - 0.00370370370370369*G0_1_1_2_0_4 - 0.00211640211640211*G0_1_1_2_0_5 + 0.000608465608465606*G0_1_1_2_1_0 - 0.00058201058201058*G0_1_1_2_1_1 - 0.000582010582010579*G0_1_1_2_1_2 - 0.000740740740740737*G0_1_1_2_1_3 + 0.000846560846560844*G0_1_1_2_1_4 + 0.000846560846560842*G0_1_1_2_1_5 + 0.000476190476190475*G0_1_1_2_2_0 - 0.000582010582010579*G0_1_1_2_2_1 + 0.00396825396825395*G0_1_1_2_2_2 + 0.00264550264550263*G0_1_1_2_2_3 + 0.00264550264550263*G0_1_1_2_2_4 + 0.00116402116402116*G0_1_1_2_2_5 - 0.000423280423280421*G0_1_1_2_3_0 - 0.000740740740740737*G0_1_1_2_3_1 + 0.00264550264550263*G0_1_1_2_3_2 + 0.00084656084656084*G0_1_1_2_3_3 - 0.000846560846560844*G0_1_1_2_3_4 - 0.00148148148148147*G0_1_1_2_3_5 - 0.00370370370370369*G0_1_1_2_4_0 + 0.000846560846560844*G0_1_1_2_4_1 + 0.00264550264550263*G0_1_1_2_4_2 - 0.000846560846560844*G0_1_1_2_4_3 - 0.00761904761904759*G0_1_1_2_4_4 - 0.00402116402116401*G0_1_1_2_4_5 - 0.00211640211640211*G0_1_1_2_5_0 + 0.000846560846560842*G0_1_1_2_5_1 + 0.00116402116402116*G0_1_1_2_5_2 - 0.00148148148148147*G0_1_1_2_5_3 - 0.00402116402116401*G0_1_1_2_5_4 - 0.00550264550264548*G0_1_1_2_5_5 + 0.00158730158730158*G0_1_1_3_0_0 - 0.000423280423280422*G0_1_1_3_0_1 - 0.000423280423280421*G0_1_1_3_0_2 - 0.00126984126984126*G0_1_1_3_0_3 + 0.00105820105820106*G0_1_1_3_0_4 + 0.00105820105820105*G0_1_1_3_0_5 - 0.000423280423280422*G0_1_1_3_1_0 + 0.00264550264550263*G0_1_1_3_1_1 - 0.000740740740740737*G0_1_1_3_1_2 + 0.000846560846560845*G0_1_1_3_1_3 - 0.00148148148148147*G0_1_1_3_1_4 - 0.000846560846560842*G0_1_1_3_1_5 - 0.000423280423280421*G0_1_1_3_2_0 - 0.000740740740740737*G0_1_1_3_2_1 + 0.00264550264550263*G0_1_1_3_2_2 + 0.00084656084656084*G0_1_1_3_2_3 - 0.000846560846560844*G0_1_1_3_2_4 - 0.00148148148148147*G0_1_1_3_2_5 - 0.00126984126984126*G0_1_1_3_3_0 + 0.000846560846560845*G0_1_1_3_3_1 + 0.00084656084656084*G0_1_1_3_3_2 + 0.0266666666666665*G0_1_1_3_3_3 + 0.00550264550264548*G0_1_1_3_3_4 + 0.00550264550264548*G0_1_1_3_3_5 + 0.00105820105820106*G0_1_1_3_4_0 - 0.00148148148148147*G0_1_1_3_4_1 - 0.000846560846560844*G0_1_1_3_4_2 + 0.00550264550264548*G0_1_1_3_4_3 + 0.00888888888888886*G0_1_1_3_4_4 + 0.0059259259259259*G0_1_1_3_4_5 + 0.00105820105820105*G0_1_1_3_5_0 - 0.000846560846560842*G0_1_1_3_5_1 - 0.00148148148148147*G0_1_1_3_5_2 + 0.00550264550264548*G0_1_1_3_5_3 + 0.0059259259259259*G0_1_1_3_5_4 + 0.00888888888888884*G0_1_1_3_5_5 + 0.0174603174603174*G0_1_1_4_0_0 - 0.00211640211640211*G0_1_1_4_0_1 - 0.00370370370370369*G0_1_1_4_0_2 + 0.00105820105820106*G0_1_1_4_0_3 + 0.0169312169312169*G0_1_1_4_0_4 + 0.00846560846560843*G0_1_1_4_0_5 - 0.00211640211640211*G0_1_1_4_1_0 + 0.00116402116402116*G0_1_1_4_1_1 + 0.000846560846560844*G0_1_1_4_1_2 - 0.00148148148148147*G0_1_1_4_1_3 - 0.00550264550264548*G0_1_1_4_1_4 - 0.004021164021164*G0_1_1_4_1_5 - 0.00370370370370369*G0_1_1_4_2_0 + 0.000846560846560844*G0_1_1_4_2_1 + 0.00264550264550263*G0_1_1_4_2_2 - 0.000846560846560844*G0_1_1_4_2_3 - 0.00761904761904759*G0_1_1_4_2_4 - 0.00402116402116401*G0_1_1_4_2_5 + 0.00105820105820106*G0_1_1_4_3_0 - 0.00148148148148147*G0_1_1_4_3_1 - 0.000846560846560844*G0_1_1_4_3_2 + 0.00550264550264548*G0_1_1_4_3_3 + 0.00888888888888885*G0_1_1_4_3_4 + 0.0059259259259259*G0_1_1_4_3_5 + 0.0169312169312169*G0_1_1_4_4_0 - 0.00550264550264548*G0_1_1_4_4_1 - 0.00761904761904759*G0_1_1_4_4_2 + 0.00888888888888885*G0_1_1_4_4_3 + 0.0571428571428569*G0_1_1_4_4_4 + 0.019047619047619*G0_1_1_4_4_5 + 0.00846560846560843*G0_1_1_4_5_0 - 0.004021164021164*G0_1_1_4_5_1 - 0.00402116402116401*G0_1_1_4_5_2 + 0.0059259259259259*G0_1_1_4_5_3 + 0.019047619047619*G0_1_1_4_5_4 + 0.019047619047619*G0_1_1_4_5_5 + 0.0174603174603174*G0_1_1_5_0_0 - 0.00370370370370369*G0_1_1_5_0_1 - 0.00211640211640211*G0_1_1_5_0_2 + 0.00105820105820105*G0_1_1_5_0_3 + 0.00846560846560843*G0_1_1_5_0_4 + 0.0169312169312168*G0_1_1_5_0_5 - 0.00370370370370369*G0_1_1_5_1_0 + 0.00264550264550263*G0_1_1_5_1_1 + 0.000846560846560842*G0_1_1_5_1_2 - 0.000846560846560842*G0_1_1_5_1_3 - 0.004021164021164*G0_1_1_5_1_4 - 0.00761904761904757*G0_1_1_5_1_5 - 0.00211640211640211*G0_1_1_5_2_0 + 0.000846560846560842*G0_1_1_5_2_1 + 0.00116402116402116*G0_1_1_5_2_2 - 0.00148148148148147*G0_1_1_5_2_3 - 0.00402116402116401*G0_1_1_5_2_4 - 0.00550264550264548*G0_1_1_5_2_5 + 0.00105820105820105*G0_1_1_5_3_0 - 0.000846560846560842*G0_1_1_5_3_1 - 0.00148148148148147*G0_1_1_5_3_2 + 0.00550264550264548*G0_1_1_5_3_3 + 0.0059259259259259*G0_1_1_5_3_4 + 0.00888888888888884*G0_1_1_5_3_5 + 0.00846560846560843*G0_1_1_5_4_0 - 0.004021164021164*G0_1_1_5_4_1 - 0.00402116402116401*G0_1_1_5_4_2 + 0.0059259259259259*G0_1_1_5_4_3 + 0.019047619047619*G0_1_1_5_4_4 + 0.019047619047619*G0_1_1_5_4_5 + 0.0169312169312168*G0_1_1_5_5_0 - 0.00761904761904757*G0_1_1_5_5_1 - 0.00550264550264548*G0_1_1_5_5_2 + 0.00888888888888884*G0_1_1_5_5_3 + 0.019047619047619*G0_1_1_5_5_4 + 0.0571428571428568*G0_1_1_5_5_5;
    A[14] = 0.00396825396825395*G0_1_1_0_0_0 - 0.000582010582010579*G0_1_1_0_0_1 + 0.000476190476190472*G0_1_1_0_0_2 + 0.00116402116402116*G0_1_1_0_0_3 + 0.00264550264550263*G0_1_1_0_0_4 + 0.00264550264550263*G0_1_1_0_0_5 - 0.000582010582010579*G0_1_1_0_1_0 - 0.000582010582010578*G0_1_1_0_1_1 + 0.000608465608465604*G0_1_1_0_1_2 + 0.000846560846560842*G0_1_1_0_1_3 + 0.000846560846560842*G0_1_1_0_1_4 - 0.000740740740740735*G0_1_1_0_1_5 + 0.000476190476190472*G0_1_1_0_2_0 + 0.000608465608465604*G0_1_1_0_2_1 - 0.00396825396825394*G0_1_1_0_2_2 - 0.0021164021164021*G0_1_1_0_2_3 - 0.00370370370370368*G0_1_1_0_2_4 - 0.000423280423280422*G0_1_1_0_2_5 + 0.00116402116402116*G0_1_1_0_3_0 + 0.000846560846560841*G0_1_1_0_3_1 - 0.0021164021164021*G0_1_1_0_3_2 - 0.00550264550264547*G0_1_1_0_3_3 - 0.004021164021164*G0_1_1_0_3_4 - 0.00148148148148147*G0_1_1_0_3_5 + 0.00264550264550263*G0_1_1_0_4_0 + 0.000846560846560842*G0_1_1_0_4_1 - 0.00370370370370368*G0_1_1_0_4_2 - 0.004021164021164*G0_1_1_0_4_3 - 0.00761904761904758*G0_1_1_0_4_4 - 0.000846560846560844*G0_1_1_0_4_5 + 0.00264550264550263*G0_1_1_0_5_0 - 0.000740740740740735*G0_1_1_0_5_1 - 0.000423280423280422*G0_1_1_0_5_2 - 0.00148148148148147*G0_1_1_0_5_3 - 0.000846560846560844*G0_1_1_0_5_4 + 0.000846560846560841*G0_1_1_0_5_5 - 0.000582010582010579*G0_1_1_1_0_0 - 0.000582010582010578*G0_1_1_1_0_1 + 0.000608465608465604*G0_1_1_1_0_2 + 0.000846560846560842*G0_1_1_1_0_3 + 0.000846560846560842*G0_1_1_1_0_4 - 0.000740740740740735*G0_1_1_1_0_5 - 0.000582010582010578*G0_1_1_1_1_0 + 0.00396825396825395*G0_1_1_1_1_1 + 0.000476190476190473*G0_1_1_1_1_2 + 0.00264550264550263*G0_1_1_1_1_3 + 0.00116402116402116*G0_1_1_1_1_4 + 0.00264550264550263*G0_1_1_1_1_5 + 0.000608465608465604*G0_1_1_1_2_0 + 0.000476190476190473*G0_1_1_1_2_1 - 0.00396825396825394*G0_1_1_1_2_2 - 0.00370370370370368*G0_1_1_1_2_3 - 0.0021164021164021*G0_1_1_1_2_4 - 0.000423280423280422*G0_1_1_1_2_5 + 0.000846560846560842*G0_1_1_1_3_0 + 0.00264550264550263*G0_1_1_1_3_1 - 0.00370370370370368*G0_1_1_1_3_2 - 0.00761904761904758*G0_1_1_1_3_3 - 0.004021164021164*G0_1_1_1_3_4 - 0.000846560846560845*G0_1_1_1_3_5 + 0.000846560846560842*G0_1_1_1_4_0 + 0.00116402116402116*G0_1_1_1_4_1 - 0.0021164021164021*G0_1_1_1_4_2 - 0.004021164021164*G0_1_1_1_4_3 - 0.00550264550264547*G0_1_1_1_4_4 - 0.00148148148148148*G0_1_1_1_4_5 - 0.000740740740740735*G0_1_1_1_5_0 + 0.00264550264550263*G0_1_1_1_5_1 - 0.000423280423280422*G0_1_1_1_5_2 - 0.000846560846560846*G0_1_1_1_5_3 - 0.00148148148148148*G0_1_1_1_5_4 + 0.000846560846560841*G0_1_1_1_5_5 + 0.000476190476190472*G0_1_1_2_0_0 + 0.000608465608465604*G0_1_1_2_0_1 - 0.00396825396825394*G0_1_1_2_0_2 - 0.0021164021164021*G0_1_1_2_0_3 - 0.00370370370370368*G0_1_1_2_0_4 - 0.000423280423280422*G0_1_1_2_0_5 + 0.000608465608465604*G0_1_1_2_1_0 + 0.000476190476190473*G0_1_1_2_1_1 - 0.00396825396825394*G0_1_1_2_1_2 - 0.00370370370370368*G0_1_1_2_1_3 - 0.0021164021164021*G0_1_1_2_1_4 - 0.000423280423280422*G0_1_1_2_1_5 - 0.00396825396825394*G0_1_1_2_2_0 - 0.00396825396825394*G0_1_1_2_2_1 + 0.045238095238095*G0_1_1_2_2_2 + 0.0174603174603174*G0_1_1_2_2_3 + 0.0174603174603174*G0_1_1_2_2_4 + 0.00158730158730159*G0_1_1_2_2_5 - 0.0021164021164021*G0_1_1_2_3_0 - 0.00370370370370368*G0_1_1_2_3_1 + 0.0174603174603174*G0_1_1_2_3_2 + 0.0169312169312168*G0_1_1_2_3_3 + 0.00846560846560842*G0_1_1_2_3_4 + 0.00105820105820106*G0_1_1_2_3_5 - 0.00370370370370368*G0_1_1_2_4_0 - 0.0021164021164021*G0_1_1_2_4_1 + 0.0174603174603174*G0_1_1_2_4_2 + 0.00846560846560842*G0_1_1_2_4_3 + 0.0169312169312168*G0_1_1_2_4_4 + 0.00105820105820106*G0_1_1_2_4_5 - 0.000423280423280422*G0_1_1_2_5_0 - 0.000423280423280422*G0_1_1_2_5_1 + 0.00158730158730159*G0_1_1_2_5_2 + 0.00105820105820106*G0_1_1_2_5_3 + 0.00105820105820106*G0_1_1_2_5_4 - 0.00126984126984126*G0_1_1_2_5_5 + 0.00116402116402116*G0_1_1_3_0_0 + 0.000846560846560842*G0_1_1_3_0_1 - 0.0021164021164021*G0_1_1_3_0_2 - 0.00550264550264547*G0_1_1_3_0_3 - 0.004021164021164*G0_1_1_3_0_4 - 0.00148148148148147*G0_1_1_3_0_5 + 0.000846560846560842*G0_1_1_3_1_0 + 0.00264550264550263*G0_1_1_3_1_1 - 0.00370370370370368*G0_1_1_3_1_2 - 0.00761904761904758*G0_1_1_3_1_3 - 0.004021164021164*G0_1_1_3_1_4 - 0.000846560846560846*G0_1_1_3_1_5 - 0.0021164021164021*G0_1_1_3_2_0 - 0.00370370370370368*G0_1_1_3_2_1 + 0.0174603174603174*G0_1_1_3_2_2 + 0.0169312169312168*G0_1_1_3_2_3 + 0.00846560846560842*G0_1_1_3_2_4 + 0.00105820105820106*G0_1_1_3_2_5 - 0.00550264550264547*G0_1_1_3_3_0 - 0.00761904761904758*G0_1_1_3_3_1 + 0.0169312169312168*G0_1_1_3_3_2 + 0.0571428571428568*G0_1_1_3_3_3 + 0.019047619047619*G0_1_1_3_3_4 + 0.00888888888888886*G0_1_1_3_3_5 - 0.004021164021164*G0_1_1_3_4_0 - 0.004021164021164*G0_1_1_3_4_1 + 0.00846560846560842*G0_1_1_3_4_2 + 0.019047619047619*G0_1_1_3_4_3 + 0.019047619047619*G0_1_1_3_4_4 + 0.0059259259259259*G0_1_1_3_4_5 - 0.00148148148148147*G0_1_1_3_5_0 - 0.000846560846560846*G0_1_1_3_5_1 + 0.00105820105820106*G0_1_1_3_5_2 + 0.00888888888888886*G0_1_1_3_5_3 + 0.0059259259259259*G0_1_1_3_5_4 + 0.00550264550264547*G0_1_1_3_5_5 + 0.00264550264550263*G0_1_1_4_0_0 + 0.000846560846560842*G0_1_1_4_0_1 - 0.00370370370370368*G0_1_1_4_0_2 - 0.004021164021164*G0_1_1_4_0_3 - 0.00761904761904758*G0_1_1_4_0_4 - 0.000846560846560844*G0_1_1_4_0_5 + 0.000846560846560842*G0_1_1_4_1_0 + 0.00116402116402116*G0_1_1_4_1_1 - 0.0021164021164021*G0_1_1_4_1_2 - 0.004021164021164*G0_1_1_4_1_3 - 0.00550264550264547*G0_1_1_4_1_4 - 0.00148148148148148*G0_1_1_4_1_5 - 0.00370370370370368*G0_1_1_4_2_0 - 0.0021164021164021*G0_1_1_4_2_1 + 0.0174603174603174*G0_1_1_4_2_2 + 0.00846560846560842*G0_1_1_4_2_3 + 0.0169312169312168*G0_1_1_4_2_4 + 0.00105820105820106*G0_1_1_4_2_5 - 0.004021164021164*G0_1_1_4_3_0 - 0.004021164021164*G0_1_1_4_3_1 + 0.00846560846560842*G0_1_1_4_3_2 + 0.019047619047619*G0_1_1_4_3_3 + 0.019047619047619*G0_1_1_4_3_4 + 0.0059259259259259*G0_1_1_4_3_5 - 0.00761904761904758*G0_1_1_4_4_0 - 0.00550264550264547*G0_1_1_4_4_1 + 0.0169312169312168*G0_1_1_4_4_2 + 0.019047619047619*G0_1_1_4_4_3 + 0.0571428571428569*G0_1_1_4_4_4 + 0.00888888888888886*G0_1_1_4_4_5 - 0.000846560846560844*G0_1_1_4_5_0 - 0.00148148148148148*G0_1_1_4_5_1 + 0.00105820105820106*G0_1_1_4_5_2 + 0.0059259259259259*G0_1_1_4_5_3 + 0.00888888888888886*G0_1_1_4_5_4 + 0.00550264550264548*G0_1_1_4_5_5 + 0.00264550264550263*G0_1_1_5_0_0 - 0.000740740740740735*G0_1_1_5_0_1 - 0.000423280423280422*G0_1_1_5_0_2 - 0.00148148148148147*G0_1_1_5_0_3 - 0.000846560846560844*G0_1_1_5_0_4 + 0.000846560846560841*G0_1_1_5_0_5 - 0.000740740740740735*G0_1_1_5_1_0 + 0.00264550264550263*G0_1_1_5_1_1 - 0.000423280423280422*G0_1_1_5_1_2 - 0.000846560846560846*G0_1_1_5_1_3 - 0.00148148148148148*G0_1_1_5_1_4 + 0.000846560846560842*G0_1_1_5_1_5 - 0.000423280423280422*G0_1_1_5_2_0 - 0.000423280423280422*G0_1_1_5_2_1 + 0.00158730158730159*G0_1_1_5_2_2 + 0.00105820105820106*G0_1_1_5_2_3 + 0.00105820105820106*G0_1_1_5_2_4 - 0.00126984126984126*G0_1_1_5_2_5 - 0.00148148148148147*G0_1_1_5_3_0 - 0.000846560846560845*G0_1_1_5_3_1 + 0.00105820105820106*G0_1_1_5_3_2 + 0.00888888888888886*G0_1_1_5_3_3 + 0.0059259259259259*G0_1_1_5_3_4 + 0.00550264550264547*G0_1_1_5_3_5 - 0.000846560846560844*G0_1_1_5_4_0 - 0.00148148148148148*G0_1_1_5_4_1 + 0.00105820105820106*G0_1_1_5_4_2 + 0.0059259259259259*G0_1_1_5_4_3 + 0.00888888888888886*G0_1_1_5_4_4 + 0.00550264550264548*G0_1_1_5_4_5 + 0.000846560846560841*G0_1_1_5_5_0 + 0.000846560846560841*G0_1_1_5_5_1 - 0.00126984126984126*G0_1_1_5_5_2 + 0.00550264550264547*G0_1_1_5_5_3 + 0.00550264550264548*G0_1_1_5_5_4 + 0.0266666666666665*G0_1_1_5_5_5;
    A[10] = -A[9] - 0.0190476190476189*G0_0_1_0_0_0 + 0.00253968253968252*G0_0_1_0_0_1 + 0.00148148148148148*G0_0_1_0_0_2 + 0.00126984126984126*G0_0_1_0_0_3 - 0.00634920634920632*G0_0_1_0_0_4 - 0.00211640211640211*G0_0_1_0_0_5 + 0.00253968253968252*G0_0_1_0_1_0 - 0.0063492063492063*G0_0_1_0_1_1 + 0.000740740740740735*G0_0_1_0_1_2 - 0.00296296296296294*G0_0_1_0_1_3 + 0.000423280423280423*G0_0_1_0_1_4 - 0.00550264550264546*G0_0_1_0_1_5 + 0.00148148148148148*G0_0_1_0_2_0 + 0.000740740740740735*G0_0_1_0_2_1 - 0.0021164021164021*G0_0_1_0_2_2 + 0.00126984126984126*G0_0_1_0_2_3 + 0.000846560846560845*G0_0_1_0_2_4 + 0.00253968253968253*G0_0_1_0_2_5 + 0.00126984126984126*G0_0_1_0_3_0 - 0.00296296296296294*G0_0_1_0_3_1 + 0.00126984126984126*G0_0_1_0_3_2 - 0.00761904761904757*G0_0_1_0_3_3 - 0.00338624338624337*G0_0_1_0_3_4 - 0.00761904761904758*G0_0_1_0_3_5 - 0.00634920634920632*G0_0_1_0_4_0 + 0.000423280423280424*G0_0_1_0_4_1 + 0.000846560846560844*G0_0_1_0_4_2 - 0.00338624338624337*G0_0_1_0_4_3 - 0.011005291005291*G0_0_1_0_4_4 - 0.0059259259259259*G0_0_1_0_4_5 - 0.00211640211640211*G0_0_1_0_5_0 - 0.00550264550264546*G0_0_1_0_5_1 + 0.00253968253968253*G0_0_1_0_5_2 - 0.00761904761904758*G0_0_1_0_5_3 - 0.0059259259259259*G0_0_1_0_5_4 - 0.0194708994708993*G0_0_1_0_5_5 + 0.00253968253968252*G0_0_1_1_0_0 - 0.0063492063492063*G0_0_1_1_0_1 + 0.000740740740740735*G0_0_1_1_0_2 - 0.00296296296296294*G0_0_1_1_0_3 + 0.000423280423280424*G0_0_1_1_0_4 - 0.00550264550264546*G0_0_1_1_0_5 - 0.0063492063492063*G0_0_1_1_1_0 + 0.0634920634920631*G0_0_1_1_1_1 - 0.00529100529100526*G0_0_1_1_1_2 + 0.0232804232804231*G0_0_1_1_1_3 + 0.00211640211640211*G0_0_1_1_1_4 + 0.0275132275132273*G0_0_1_1_1_5 + 0.000740740740740735*G0_0_1_1_2_0 - 0.00529100529100526*G0_0_1_1_2_1 - 0.00507936507936505*G0_0_1_1_2_3 - 0.00126984126984126*G0_0_1_1_2_4 - 0.00338624338624337*G0_0_1_1_2_5 - 0.00296296296296294*G0_0_1_1_3_0 + 0.0232804232804231*G0_0_1_1_3_1 - 0.00507936507936505*G0_0_1_1_3_2 + 0.0211640211640211*G0_0_1_1_3_3 + 0.00169312169312169*G0_0_1_1_3_4 + 0.0126984126984126*G0_0_1_1_3_5 + 0.000423280423280424*G0_0_1_1_4_0 + 0.00211640211640211*G0_0_1_1_4_1 - 0.00126984126984126*G0_0_1_1_4_2 + 0.00169312169312169*G0_0_1_1_4_3 + 0.000846560846560845*G0_0_1_1_4_4 + 0.00253968253968253*G0_0_1_1_4_5 - 0.00550264550264546*G0_0_1_1_5_0 + 0.0275132275132273*G0_0_1_1_5_1 - 0.00338624338624337*G0_0_1_1_5_2 + 0.0126984126984126*G0_0_1_1_5_3 + 0.00253968253968253*G0_0_1_1_5_4 + 0.0296296296296295*G0_0_1_1_5_5 + 0.00148148148148148*G0_0_1_2_0_0 + 0.000740740740740735*G0_0_1_2_0_1 - 0.0021164021164021*G0_0_1_2_0_2 + 0.00126984126984126*G0_0_1_2_0_3 + 0.000846560846560845*G0_0_1_2_0_4 + 0.00253968253968253*G0_0_1_2_0_5 + 0.000740740740740735*G0_0_1_2_1_0 - 0.00529100529100526*G0_0_1_2_1_1 - 0.00507936507936505*G0_0_1_2_1_3 - 0.00126984126984126*G0_0_1_2_1_4 - 0.00338624338624337*G0_0_1_2_1_5 - 0.0021164021164021*G0_0_1_2_2_0 + 0.0158730158730158*G0_0_1_2_2_2 + 0.00634920634920632*G0_0_1_2_2_3 + 0.00634920634920631*G0_0_1_2_2_4 + 0.00211640211640211*G0_0_1_2_2_5 + 0.00126984126984126*G0_0_1_2_3_0 - 0.00507936507936505*G0_0_1_2_3_1 + 0.00634920634920632*G0_0_1_2_3_2 - 0.00846560846560843*G0_0_1_2_3_3 - 0.00677248677248674*G0_0_1_2_3_5 + 0.000846560846560845*G0_0_1_2_4_0 - 0.00126984126984126*G0_0_1_2_4_1 + 0.00634920634920631*G0_0_1_2_4_2 + 0.00846560846560843*G0_0_1_2_4_4 - 0.00169312169312168*G0_0_1_2_4_5 + 0.00253968253968253*G0_0_1_2_5_0 - 0.00338624338624337*G0_0_1_2_5_1 + 0.00211640211640211*G0_0_1_2_5_2 - 0.00677248677248674*G0_0_1_2_5_3 - 0.00169312169312168*G0_0_1_2_5_4 - 0.0118518518518518*G0_0_1_2_5_5 + 0.00126984126984126*G0_0_1_3_0_0 - 0.00296296296296294*G0_0_1_3_0_1 + 0.00126984126984126*G0_0_1_3_0_2 - 0.00761904761904757*G0_0_1_3_0_3 - 0.00338624338624337*G0_0_1_3_0_4 - 0.00761904761904758*G0_0_1_3_0_5 - 0.00296296296296294*G0_0_1_3_1_0 + 0.0232804232804231*G0_0_1_3_1_1 - 0.00507936507936505*G0_0_1_3_1_2 + 0.0211640211640211*G0_0_1_3_1_3 + 0.00169312169312168*G0_0_1_3_1_4 + 0.0126984126984126*G0_0_1_3_1_5 + 0.00126984126984126*G0_0_1_3_2_0 - 0.00507936507936505*G0_0_1_3_2_1 + 0.00634920634920632*G0_0_1_3_2_2 - 0.00846560846560843*G0_0_1_3_2_3 - 0.00677248677248674*G0_0_1_3_2_5 - 0.00761904761904757*G0_0_1_3_3_0 + 0.0211640211640211*G0_0_1_3_3_1 - 0.00846560846560843*G0_0_1_3_3_2 + 0.0558730158730156*G0_0_1_3_3_3 + 0.0118518518518518*G0_0_1_3_3_4 + 0.0287830687830687*G0_0_1_3_3_5 - 0.00338624338624337*G0_0_1_3_4_0 + 0.00169312169312169*G0_0_1_3_4_1 + 0.0118518518518518*G0_0_1_3_4_3 + 0.00507936507936506*G0_0_1_3_4_4 + 0.0101587301587301*G0_0_1_3_4_5 - 0.00761904761904758*G0_0_1_3_5_0 + 0.0126984126984126*G0_0_1_3_5_1 - 0.00677248677248674*G0_0_1_3_5_2 + 0.0287830687830687*G0_0_1_3_5_3 + 0.0101587301587301*G0_0_1_3_5_4 + 0.0389417989417987*G0_0_1_3_5_5 - 0.00634920634920632*G0_0_1_4_0_0 + 0.000423280423280424*G0_0_1_4_0_1 + 0.000846560846560845*G0_0_1_4_0_2 - 0.00338624338624337*G0_0_1_4_0_3 - 0.011005291005291*G0_0_1_4_0_4 - 0.0059259259259259*G0_0_1_4_0_5 + 0.000423280423280424*G0_0_1_4_1_0 + 0.00211640211640211*G0_0_1_4_1_1 - 0.00126984126984126*G0_0_1_4_1_2 + 0.00169312169312169*G0_0_1_4_1_3 + 0.000846560846560845*G0_0_1_4_1_4 + 0.00253968253968253*G0_0_1_4_1_5 + 0.000846560846560844*G0_0_1_4_2_0 - 0.00126984126984126*G0_0_1_4_2_1 + 0.00634920634920631*G0_0_1_4_2_2 + 0.00846560846560843*G0_0_1_4_2_4 - 0.00169312169312168*G0_0_1_4_2_5 - 0.00338624338624337*G0_0_1_4_3_0 + 0.00169312169312169*G0_0_1_4_3_1 + 0.0118518518518518*G0_0_1_4_3_3 + 0.00507936507936506*G0_0_1_4_3_4 + 0.0101587301587301*G0_0_1_4_3_5 - 0.011005291005291*G0_0_1_4_4_0 + 0.000846560846560845*G0_0_1_4_4_1 + 0.00846560846560843*G0_0_1_4_4_2 + 0.00507936507936506*G0_0_1_4_4_3 - 0.00507936507936506*G0_0_1_4_4_4 + 0.00169312169312168*G0_0_1_4_4_5 - 0.0059259259259259*G0_0_1_4_5_0 + 0.00253968253968253*G0_0_1_4_5_1 - 0.00169312169312168*G0_0_1_4_5_2 + 0.0101587301587301*G0_0_1_4_5_3 + 0.00169312169312168*G0_0_1_4_5_4 + 0.0186243386243385*G0_0_1_4_5_5 - 0.00211640211640211*G0_0_1_5_0_0 - 0.00550264550264546*G0_0_1_5_0_1 + 0.00253968253968253*G0_0_1_5_0_2 - 0.00761904761904758*G0_0_1_5_0_3 - 0.0059259259259259*G0_0_1_5_0_4 - 0.0194708994708993*G0_0_1_5_0_5 - 0.00550264550264546*G0_0_1_5_1_0 + 0.0275132275132273*G0_0_1_5_1_1 - 0.00338624338624337*G0_0_1_5_1_2 + 0.0126984126984126*G0_0_1_5_1_3 + 0.00253968253968253*G0_0_1_5_1_4 + 0.0296296296296295*G0_0_1_5_1_5 + 0.00253968253968253*G0_0_1_5_2_0 - 0.00338624338624337*G0_0_1_5_2_1 + 0.00211640211640211*G0_0_1_5_2_2 - 0.00677248677248674*G0_0_1_5_2_3 - 0.00169312169312168*G0_0_1_5_2_4 - 0.0118518518518518*G0_0_1_5_2_5 - 0.00761904761904758*G0_0_1_5_3_0 + 0.0126984126984126*G0_0_1_5_3_1 - 0.00677248677248674*G0_0_1_5_3_2 + 0.0287830687830687*G0_0_1_5_3_3 + 0.0101587301587301*G0_0_1_5_3_4 + 0.0389417989417987*G0_0_1_5_3_5 - 0.0059259259259259*G0_0_1_5_4_0 + 0.00253968253968253*G0_0_1_5_4_1 - 0.00169312169312168*G0_0_1_5_4_2 + 0.0101587301587301*G0_0_1_5_4_3 + 0.00169312169312168*G0_0_1_5_4_4 + 0.0186243386243385*G0_0_1_5_4_5 - 0.0194708994708993*G0_0_1_5_5_0 + 0.0296296296296295*G0_0_1_5_5_1 - 0.0118518518518518*G0_0_1_5_5_2 + 0.0389417989417987*G0_0_1_5_5_3 + 0.0186243386243385*G0_0_1_5_5_4 + 0.147301587301586*G0_0_1_5_5_5;
    A[25] = A[10] + 0.0174603174603174*G0_0_1_0_0_0 - 0.00126984126984126*G0_0_1_0_0_1 - 0.00179894179894179*G0_0_1_0_0_2 + 0.000423280423280422*G0_0_1_0_0_3 + 0.00634920634920632*G0_0_1_0_0_4 + 0.00423280423280421*G0_0_1_0_0_5 - 0.00126984126984126*G0_0_1_0_1_0 + 0.000529100529100528*G0_0_1_0_1_1 - 0.00021164021164021*G0_0_1_0_1_3 - 0.000846560846560843*G0_0_1_0_1_4 + 0.000211640211640211*G0_0_1_0_1_5 - 0.00179894179894179*G0_0_1_0_2_0 + 0.00179894179894179*G0_0_1_0_2_2 + 0.00063492063492063*G0_0_1_0_2_3 - 0.000634920634920632*G0_0_1_0_2_5 + 0.000423280423280422*G0_0_1_0_3_0 - 0.00021164021164021*G0_0_1_0_3_1 + 0.00063492063492063*G0_0_1_0_3_2 - 0.0021164021164021*G0_0_1_0_3_3 + 0.000846560846560844*G0_0_1_0_3_4 + 0.000423280423280423*G0_0_1_0_3_5 + 0.00634920634920632*G0_0_1_0_4_0 - 0.000846560846560843*G0_0_1_0_4_1 + 0.000846560846560844*G0_0_1_0_4_3 + 0.00973544973544969*G0_0_1_0_4_4 + 0.00296296296296295*G0_0_1_0_4_5 + 0.00423280423280421*G0_0_1_0_5_0 + 0.000211640211640211*G0_0_1_0_5_1 - 0.000634920634920632*G0_0_1_0_5_2 + 0.000423280423280423*G0_0_1_0_5_3 + 0.00296296296296295*G0_0_1_0_5_4 + 0.00550264550264547*G0_0_1_0_5_5 - 0.00126984126984126*G0_0_1_1_0_0 + 0.000529100529100528*G0_0_1_1_0_1 - 0.00021164021164021*G0_0_1_1_0_3 - 0.000846560846560843*G0_0_1_1_0_4 + 0.000211640211640211*G0_0_1_1_0_5 + 0.000529100529100528*G0_0_1_1_1_0 - 0.000529100529100525*G0_0_1_1_1_2 + 0.0021164021164021*G0_0_1_1_1_3 - 0.00211640211640211*G0_0_1_1_1_5 - 0.000529100529100525*G0_0_1_1_2_1 + 0.00126984126984126*G0_0_1_1_2_2 - 0.00021164021164021*G0_0_1_1_2_3 + 0.000846560846560842*G0_0_1_1_2_4 + 0.000211640211640212*G0_0_1_1_2_5 - 0.00021164021164021*G0_0_1_1_3_0 + 0.0021164021164021*G0_0_1_1_3_1 - 0.00021164021164021*G0_0_1_1_3_2 + 0.00423280423280421*G0_0_1_1_3_3 + 0.000423280423280421*G0_0_1_1_3_4 - 0.000846560846560843*G0_0_1_1_4_0 + 0.000846560846560842*G0_0_1_1_4_2 + 0.000423280423280421*G0_0_1_1_4_3 - 0.000423280423280422*G0_0_1_1_4_5 + 0.000211640211640211*G0_0_1_1_5_0 - 0.00211640211640211*G0_0_1_1_5_1 + 0.000211640211640212*G0_0_1_1_5_2 - 0.000423280423280422*G0_0_1_1_5_4 - 0.00423280423280422*G0_0_1_1_5_5 - 0.00179894179894179*G0_0_1_2_0_0 + 0.00179894179894179*G0_0_1_2_0_2 + 0.00063492063492063*G0_0_1_2_0_3 - 0.000634920634920632*G0_0_1_2_0_5 - 0.000529100529100525*G0_0_1_2_1_1 + 0.00126984126984126*G0_0_1_2_1_2 - 0.00021164021164021*G0_0_1_2_1_3 + 0.000846560846560842*G0_0_1_2_1_4 + 0.000211640211640212*G0_0_1_2_1_5 + 0.00179894179894179*G0_0_1_2_2_0 + 0.00126984126984126*G0_0_1_2_2_1 - 0.0174603174603174*G0_0_1_2_2_2 - 0.00423280423280421*G0_0_1_2_2_3 - 0.00634920634920631*G0_0_1_2_2_4 - 0.000423280423280425*G0_0_1_2_2_5 + 0.00063492063492063*G0_0_1_2_3_0 - 0.00021164021164021*G0_0_1_2_3_1 - 0.00423280423280421*G0_0_1_2_3_2 - 0.00550264550264547*G0_0_1_2_3_3 - 0.00296296296296295*G0_0_1_2_3_4 - 0.000423280423280422*G0_0_1_2_3_5 + 0.000846560846560842*G0_0_1_2_4_1 - 0.00634920634920631*G0_0_1_2_4_2 - 0.00296296296296295*G0_0_1_2_4_3 - 0.00973544973544969*G0_0_1_2_4_4 - 0.000846560846560846*G0_0_1_2_4_5 - 0.000634920634920632*G0_0_1_2_5_0 + 0.000211640211640212*G0_0_1_2_5_1 - 0.000423280423280425*G0_0_1_2_5_2 - 0.000423280423280422*G0_0_1_2_5_3 - 0.000846560846560846*G0_0_1_2_5_4 + 0.00211640211640211*G0_0_1_2_5_5 + 0.000423280423280422*G0_0_1_3_0_0 - 0.00021164021164021*G0_0_1_3_0_1 + 0.00063492063492063*G0_0_1_3_0_2 - 0.0021164021164021*G0_0_1_3_0_3 + 0.000846560846560844*G0_0_1_3_0_4 + 0.000423280423280423*G0_0_1_3_0_5 - 0.00021164021164021*G0_0_1_3_1_0 + 0.0021164021164021*G0_0_1_3_1_1 - 0.00021164021164021*G0_0_1_3_1_2 + 0.00423280423280421*G0_0_1_3_1_3 + 0.000423280423280421*G0_0_1_3_1_4 + 0.00063492063492063*G0_0_1_3_2_0 - 0.00021164021164021*G0_0_1_3_2_1 - 0.00423280423280421*G0_0_1_3_2_2 - 0.00550264550264547*G0_0_1_3_2_3 - 0.00296296296296295*G0_0_1_3_2_4 - 0.000423280423280422*G0_0_1_3_2_5 - 0.0021164021164021*G0_0_1_3_3_0 + 0.00423280423280421*G0_0_1_3_3_1 - 0.00550264550264547*G0_0_1_3_3_2 + 0.0457142857142855*G0_0_1_3_3_3 + 0.00338624338624337*G0_0_1_3_3_4 + 0.00507936507936506*G0_0_1_3_3_5 + 0.000846560846560844*G0_0_1_3_4_0 + 0.000423280423280421*G0_0_1_3_4_1 - 0.00296296296296295*G0_0_1_3_4_2 + 0.00338624338624337*G0_0_1_3_4_3 - 0.00169312169312168*G0_0_1_3_4_4 + 0.000423280423280423*G0_0_1_3_5_0 - 0.000423280423280422*G0_0_1_3_5_2 + 0.00507936507936506*G0_0_1_3_5_3 - 0.00507936507936505*G0_0_1_3_5_5 + 0.00634920634920632*G0_0_1_4_0_0 - 0.000846560846560843*G0_0_1_4_0_1 + 0.000846560846560844*G0_0_1_4_0_3 + 0.00973544973544969*G0_0_1_4_0_4 + 0.00296296296296295*G0_0_1_4_0_5 - 0.000846560846560843*G0_0_1_4_1_0 + 0.000846560846560842*G0_0_1_4_1_2 + 0.000423280423280421*G0_0_1_4_1_3 - 0.000423280423280422*G0_0_1_4_1_5 + 0.000846560846560842*G0_0_1_4_2_1 - 0.00634920634920631*G0_0_1_4_2_2 - 0.00296296296296295*G0_0_1_4_2_3 - 0.00973544973544969*G0_0_1_4_2_4 - 0.000846560846560846*G0_0_1_4_2_5 + 0.000846560846560844*G0_0_1_4_3_0 + 0.000423280423280421*G0_0_1_4_3_1 - 0.00296296296296295*G0_0_1_4_3_2 + 0.00338624338624337*G0_0_1_4_3_3 - 0.00169312169312168*G0_0_1_4_3_4 + 0.00973544973544969*G0_0_1_4_4_0 - 0.00973544973544969*G0_0_1_4_4_2 - 0.00169312169312168*G0_0_1_4_4_3 + 0.00169312169312169*G0_0_1_4_4_5 + 0.00296296296296295*G0_0_1_4_5_0 - 0.000423280423280422*G0_0_1_4_5_1 - 0.000846560846560846*G0_0_1_4_5_2 + 0.00169312169312169*G0_0_1_4_5_4 - 0.00338624338624337*G0_0_1_4_5_5 + 0.00423280423280421*G0_0_1_5_0_0 + 0.000211640211640211*G0_0_1_5_0_1 - 0.000634920634920632*G0_0_1_5_0_2 + 0.000423280423280423*G0_0_1_5_0_3 + 0.00296296296296295*G0_0_1_5_0_4 + 0.00550264550264547*G0_0_1_5_0_5 + 0.000211640211640211*G0_0_1_5_1_0 - 0.00211640211640211*G0_0_1_5_1_1 + 0.000211640211640212*G0_0_1_5_1_2 - 0.000423280423280422*G0_0_1_5_1_4 - 0.00423280423280422*G0_0_1_5_1_5 - 0.000634920634920632*G0_0_1_5_2_0 + 0.000211640211640212*G0_0_1_5_2_1 - 0.000423280423280425*G0_0_1_5_2_2 - 0.000423280423280422*G0_0_1_5_2_3 - 0.000846560846560846*G0_0_1_5_2_4 + 0.00211640211640211*G0_0_1_5_2_5 + 0.000423280423280423*G0_0_1_5_3_0 - 0.000423280423280422*G0_0_1_5_3_2 + 0.00507936507936506*G0_0_1_5_3_3 - 0.00507936507936505*G0_0_1_5_3_5 + 0.00296296296296295*G0_0_1_5_4_0 - 0.000423280423280422*G0_0_1_5_4_1 - 0.000846560846560846*G0_0_1_5_4_2 + 0.00169312169312169*G0_0_1_5_4_4 - 0.00338624338624337*G0_0_1_5_4_5 + 0.00550264550264547*G0_0_1_5_5_0 - 0.00423280423280422*G0_0_1_5_5_1 + 0.00211640211640211*G0_0_1_5_5_2 - 0.00507936507936505*G0_0_1_5_5_3 - 0.00338624338624337*G0_0_1_5_5_4 - 0.0457142857142855*G0_0_1_5_5_5 - 0.0174603174603174*G0_1_0_0_0_0 + 0.00126984126984126*G0_1_0_0_0_1 + 0.00179894179894179*G0_1_0_0_0_2 - 0.000423280423280422*G0_1_0_0_0_3 - 0.00634920634920632*G0_1_0_0_0_4 - 0.00423280423280421*G0_1_0_0_0_5 + 0.00126984126984126*G0_1_0_0_1_0 - 0.000529100529100528*G0_1_0_0_1_1 + 0.00021164021164021*G0_1_0_0_1_3 + 0.000846560846560843*G0_1_0_0_1_4 - 0.000211640211640211*G0_1_0_0_1_5 + 0.00179894179894179*G0_1_0_0_2_0 - 0.00179894179894179*G0_1_0_0_2_2 - 0.00063492063492063*G0_1_0_0_2_3 + 0.000634920634920632*G0_1_0_0_2_5 - 0.000423280423280422*G0_1_0_0_3_0 + 0.00021164021164021*G0_1_0_0_3_1 - 0.00063492063492063*G0_1_0_0_3_2 + 0.0021164021164021*G0_1_0_0_3_3 - 0.000846560846560844*G0_1_0_0_3_4 - 0.000423280423280423*G0_1_0_0_3_5 - 0.00634920634920632*G0_1_0_0_4_0 + 0.000846560846560843*G0_1_0_0_4_1 - 0.000846560846560844*G0_1_0_0_4_3 - 0.00973544973544969*G0_1_0_0_4_4 - 0.00296296296296295*G0_1_0_0_4_5 - 0.00423280423280421*G0_1_0_0_5_0 - 0.000211640211640211*G0_1_0_0_5_1 + 0.000634920634920632*G0_1_0_0_5_2 - 0.000423280423280423*G0_1_0_0_5_3 - 0.00296296296296295*G0_1_0_0_5_4 - 0.00550264550264547*G0_1_0_0_5_5 + 0.00126984126984126*G0_1_0_1_0_0 - 0.000529100529100528*G0_1_0_1_0_1 + 0.00021164021164021*G0_1_0_1_0_3 + 0.000846560846560843*G0_1_0_1_0_4 - 0.000211640211640211*G0_1_0_1_0_5 - 0.000529100529100528*G0_1_0_1_1_0 + 0.000529100529100525*G0_1_0_1_1_2 - 0.0021164021164021*G0_1_0_1_1_3 + 0.00211640211640211*G0_1_0_1_1_5 + 0.000529100529100525*G0_1_0_1_2_1 - 0.00126984126984126*G0_1_0_1_2_2 + 0.00021164021164021*G0_1_0_1_2_3 - 0.000846560846560842*G0_1_0_1_2_4 - 0.000211640211640212*G0_1_0_1_2_5 + 0.00021164021164021*G0_1_0_1_3_0 - 0.0021164021164021*G0_1_0_1_3_1 + 0.00021164021164021*G0_1_0_1_3_2 - 0.00423280423280421*G0_1_0_1_3_3 - 0.000423280423280421*G0_1_0_1_3_4 + 0.000846560846560843*G0_1_0_1_4_0 - 0.000846560846560842*G0_1_0_1_4_2 - 0.000423280423280421*G0_1_0_1_4_3 + 0.000423280423280422*G0_1_0_1_4_5 - 0.000211640211640211*G0_1_0_1_5_0 + 0.00211640211640211*G0_1_0_1_5_1 - 0.000211640211640212*G0_1_0_1_5_2 + 0.000423280423280422*G0_1_0_1_5_4 + 0.00423280423280422*G0_1_0_1_5_5 + 0.00179894179894179*G0_1_0_2_0_0 - 0.00179894179894179*G0_1_0_2_0_2 - 0.00063492063492063*G0_1_0_2_0_3 + 0.000634920634920632*G0_1_0_2_0_5 + 0.000529100529100525*G0_1_0_2_1_1 - 0.00126984126984126*G0_1_0_2_1_2 + 0.00021164021164021*G0_1_0_2_1_3 - 0.000846560846560842*G0_1_0_2_1_4 - 0.000211640211640212*G0_1_0_2_1_5 - 0.00179894179894179*G0_1_0_2_2_0 - 0.00126984126984126*G0_1_0_2_2_1 + 0.0174603174603174*G0_1_0_2_2_2 + 0.00423280423280421*G0_1_0_2_2_3 + 0.00634920634920631*G0_1_0_2_2_4 + 0.000423280423280425*G0_1_0_2_2_5 - 0.00063492063492063*G0_1_0_2_3_0 + 0.00021164021164021*G0_1_0_2_3_1 + 0.00423280423280421*G0_1_0_2_3_2 + 0.00550264550264547*G0_1_0_2_3_3 + 0.00296296296296295*G0_1_0_2_3_4 + 0.000423280423280422*G0_1_0_2_3_5 - 0.000846560846560842*G0_1_0_2_4_1 + 0.00634920634920631*G0_1_0_2_4_2 + 0.00296296296296295*G0_1_0_2_4_3 + 0.00973544973544969*G0_1_0_2_4_4 + 0.000846560846560846*G0_1_0_2_4_5 + 0.000634920634920632*G0_1_0_2_5_0 - 0.000211640211640212*G0_1_0_2_5_1 + 0.000423280423280425*G0_1_0_2_5_2 + 0.000423280423280422*G0_1_0_2_5_3 + 0.000846560846560846*G0_1_0_2_5_4 - 0.00211640211640211*G0_1_0_2_5_5 - 0.000423280423280422*G0_1_0_3_0_0 + 0.00021164021164021*G0_1_0_3_0_1 - 0.00063492063492063*G0_1_0_3_0_2 + 0.0021164021164021*G0_1_0_3_0_3 - 0.000846560846560844*G0_1_0_3_0_4 - 0.000423280423280423*G0_1_0_3_0_5 + 0.00021164021164021*G0_1_0_3_1_0 - 0.0021164021164021*G0_1_0_3_1_1 + 0.00021164021164021*G0_1_0_3_1_2 - 0.00423280423280421*G0_1_0_3_1_3 - 0.000423280423280421*G0_1_0_3_1_4 - 0.00063492063492063*G0_1_0_3_2_0 + 0.00021164021164021*G0_1_0_3_2_1 + 0.00423280423280421*G0_1_0_3_2_2 + 0.00550264550264547*G0_1_0_3_2_3 + 0.00296296296296295*G0_1_0_3_2_4 + 0.000423280423280422*G0_1_0_3_2_5 + 0.0021164021164021*G0_1_0_3_3_0 - 0.00423280423280421*G0_1_0_3_3_1 + 0.00550264550264547*G0_1_0_3_3_2 - 0.0457142857142855*G0_1_0_3_3_3 - 0.00338624338624337*G0_1_0_3_3_4 - 0.00507936507936506*G0_1_0_3_3_5 - 0.000846560846560844*G0_1_0_3_4_0 - 0.000423280423280421*G0_1_0_3_4_1 + 0.00296296296296295*G0_1_0_3_4_2 - 0.00338624338624337*G0_1_0_3_4_3 + 0.00169312169312168*G0_1_0_3_4_4 - 0.000423280423280423*G0_1_0_3_5_0 + 0.000423280423280422*G0_1_0_3_5_2 - 0.00507936507936506*G0_1_0_3_5_3 + 0.00507936507936505*G0_1_0_3_5_5 - 0.00634920634920632*G0_1_0_4_0_0 + 0.000846560846560843*G0_1_0_4_0_1 - 0.000846560846560844*G0_1_0_4_0_3 - 0.00973544973544969*G0_1_0_4_0_4 - 0.00296296296296295*G0_1_0_4_0_5 + 0.000846560846560843*G0_1_0_4_1_0 - 0.000846560846560842*G0_1_0_4_1_2 - 0.000423280423280421*G0_1_0_4_1_3 + 0.000423280423280422*G0_1_0_4_1_5 - 0.000846560846560842*G0_1_0_4_2_1 + 0.00634920634920631*G0_1_0_4_2_2 + 0.00296296296296295*G0_1_0_4_2_3 + 0.00973544973544969*G0_1_0_4_2_4 + 0.000846560846560846*G0_1_0_4_2_5 - 0.000846560846560844*G0_1_0_4_3_0 - 0.000423280423280421*G0_1_0_4_3_1 + 0.00296296296296295*G0_1_0_4_3_2 - 0.00338624338624337*G0_1_0_4_3_3 + 0.00169312169312168*G0_1_0_4_3_4 - 0.00973544973544969*G0_1_0_4_4_0 + 0.00973544973544969*G0_1_0_4_4_2 + 0.00169312169312168*G0_1_0_4_4_3 - 0.00169312169312169*G0_1_0_4_4_5 - 0.00296296296296295*G0_1_0_4_5_0 + 0.000423280423280422*G0_1_0_4_5_1 + 0.000846560846560846*G0_1_0_4_5_2 - 0.00169312169312169*G0_1_0_4_5_4 + 0.00338624338624337*G0_1_0_4_5_5 - 0.00423280423280421*G0_1_0_5_0_0 - 0.000211640211640211*G0_1_0_5_0_1 + 0.000634920634920632*G0_1_0_5_0_2 - 0.000423280423280423*G0_1_0_5_0_3 - 0.00296296296296295*G0_1_0_5_0_4 - 0.00550264550264547*G0_1_0_5_0_5 - 0.000211640211640211*G0_1_0_5_1_0 + 0.00211640211640211*G0_1_0_5_1_1 - 0.000211640211640212*G0_1_0_5_1_2 + 0.000423280423280422*G0_1_0_5_1_4 + 0.00423280423280422*G0_1_0_5_1_5 + 0.000634920634920632*G0_1_0_5_2_0 - 0.000211640211640212*G0_1_0_5_2_1 + 0.000423280423280425*G0_1_0_5_2_2 + 0.000423280423280422*G0_1_0_5_2_3 + 0.000846560846560846*G0_1_0_5_2_4 - 0.00211640211640211*G0_1_0_5_2_5 - 0.000423280423280423*G0_1_0_5_3_0 + 0.000423280423280422*G0_1_0_5_3_2 - 0.00507936507936506*G0_1_0_5_3_3 + 0.00507936507936505*G0_1_0_5_3_5 - 0.00296296296296295*G0_1_0_5_4_0 + 0.000423280423280422*G0_1_0_5_4_1 + 0.000846560846560846*G0_1_0_5_4_2 - 0.00169312169312169*G0_1_0_5_4_4 + 0.00338624338624337*G0_1_0_5_4_5 - 0.00550264550264547*G0_1_0_5_5_0 + 0.00423280423280422*G0_1_0_5_5_1 - 0.00211640211640211*G0_1_0_5_5_2 + 0.00507936507936505*G0_1_0_5_5_3 + 0.00338624338624337*G0_1_0_5_5_4 + 0.0457142857142855*G0_1_0_5_5_5;
    A[18] = A[25] - 0.0063492063492063*G0_0_0_0_0_0 + 0.00084656084656084*G0_0_0_0_0_1 + 0.000846560846560843*G0_0_0_0_0_2 + 0.000423280423280419*G0_0_0_0_0_3 - 0.00634920634920632*G0_0_0_0_0_4 - 0.0021164021164021*G0_0_0_0_0_5 + 0.00084656084656084*G0_0_0_0_1_0 - 0.000846560846560838*G0_0_0_0_1_1 - 0.000423280423280419*G0_0_0_0_1_3 + 0.000423280423280423*G0_0_0_0_1_4 + 0.000846560846560843*G0_0_0_0_2_0 + 0.000846560846560842*G0_0_0_0_2_3 + 0.00338624338624337*G0_0_0_0_2_4 + 0.00126984126984126*G0_0_0_0_2_5 + 0.000423280423280418*G0_0_0_0_3_0 - 0.000423280423280419*G0_0_0_0_3_1 + 0.000846560846560842*G0_0_0_0_3_2 - 0.00846560846560841*G0_0_0_0_3_3 - 0.00169312169312169*G0_0_0_0_3_4 - 0.00338624338624337*G0_0_0_0_3_5 - 0.00634920634920632*G0_0_0_0_4_0 + 0.000423280423280423*G0_0_0_0_4_1 + 0.00338624338624337*G0_0_0_0_4_2 - 0.00169312169312169*G0_0_0_0_4_3 - 0.00507936507936507*G0_0_0_0_4_4 - 0.00338624338624337*G0_0_0_0_4_5 - 0.0021164021164021*G0_0_0_0_5_0 + 0.00126984126984126*G0_0_0_0_5_2 - 0.00338624338624337*G0_0_0_0_5_3 - 0.00338624338624337*G0_0_0_0_5_4 - 0.00507936507936504*G0_0_0_0_5_5 + 0.00084656084656084*G0_0_0_1_0_0 - 0.000846560846560838*G0_0_0_1_0_1 - 0.000423280423280419*G0_0_0_1_0_3 + 0.000423280423280423*G0_0_0_1_0_4 - 0.000846560846560838*G0_0_0_1_1_0 + 0.00634920634920628*G0_0_0_1_1_1 - 0.000846560846560841*G0_0_0_1_1_2 + 0.00634920634920631*G0_0_0_1_1_3 - 0.000423280423280421*G0_0_0_1_1_4 + 0.00211640211640209*G0_0_0_1_1_5 - 0.000846560846560841*G0_0_0_1_2_1 - 0.00338624338624337*G0_0_0_1_2_3 - 0.000846560846560844*G0_0_0_1_2_4 - 0.00126984126984126*G0_0_0_1_2_5 - 0.000423280423280419*G0_0_0_1_3_0 + 0.00634920634920631*G0_0_0_1_3_1 - 0.00338624338624337*G0_0_0_1_3_2 + 0.00507936507936505*G0_0_0_1_3_3 + 0.00169312169312168*G0_0_0_1_3_4 + 0.00338624338624337*G0_0_0_1_3_5 + 0.000423280423280423*G0_0_0_1_4_0 - 0.000423280423280421*G0_0_0_1_4_1 - 0.000846560846560844*G0_0_0_1_4_2 + 0.00169312169312168*G0_0_0_1_4_3 + 0.00846560846560842*G0_0_0_1_4_4 + 0.00338624338624337*G0_0_0_1_4_5 + 0.00211640211640209*G0_0_0_1_5_1 - 0.00126984126984126*G0_0_0_1_5_2 + 0.00338624338624337*G0_0_0_1_5_3 + 0.00338624338624337*G0_0_0_1_5_4 + 0.00507936507936504*G0_0_0_1_5_5 + 0.000846560846560843*G0_0_0_2_0_0 + 0.000846560846560842*G0_0_0_2_0_3 + 0.00338624338624337*G0_0_0_2_0_4 + 0.00126984126984126*G0_0_0_2_0_5 - 0.000846560846560841*G0_0_0_2_1_1 - 0.00338624338624337*G0_0_0_2_1_3 - 0.000846560846560844*G0_0_0_2_1_4 - 0.00126984126984126*G0_0_0_2_1_5 + 0.00423280423280421*G0_0_0_2_2_3 - 0.00423280423280421*G0_0_0_2_2_4 + 0.000846560846560842*G0_0_0_2_3_0 - 0.00338624338624337*G0_0_0_2_3_1 + 0.00423280423280421*G0_0_0_2_3_2 - 0.00169312169312169*G0_0_0_2_3_5 + 0.00338624338624337*G0_0_0_2_4_0 - 0.000846560846560844*G0_0_0_2_4_1 - 0.00423280423280421*G0_0_0_2_4_2 + 0.00169312169312168*G0_0_0_2_4_5 + 0.00126984126984126*G0_0_0_2_5_0 - 0.00126984126984126*G0_0_0_2_5_1 - 0.00169312169312168*G0_0_0_2_5_3 + 0.00169312169312169*G0_0_0_2_5_4 + 0.000423280423280419*G0_0_0_3_0_0 - 0.000423280423280419*G0_0_0_3_0_1 + 0.000846560846560842*G0_0_0_3_0_2 - 0.00846560846560841*G0_0_0_3_0_3 - 0.00169312169312169*G0_0_0_3_0_4 - 0.00338624338624337*G0_0_0_3_0_5 - 0.000423280423280419*G0_0_0_3_1_0 + 0.00634920634920631*G0_0_0_3_1_1 - 0.00338624338624337*G0_0_0_3_1_2 + 0.00507936507936505*G0_0_0_3_1_3 + 0.00169312169312168*G0_0_0_3_1_4 + 0.00338624338624337*G0_0_0_3_1_5 + 0.000846560846560842*G0_0_0_3_2_0 - 0.00338624338624337*G0_0_0_3_2_1 + 0.00423280423280421*G0_0_0_3_2_2 - 0.00169312169312169*G0_0_0_3_2_5 - 0.00846560846560841*G0_0_0_3_3_0 + 0.00507936507936505*G0_0_0_3_3_1 + 0.121904761904761*G0_0_0_3_3_3 + 0.0135449735449735*G0_0_0_3_3_4 + 0.0203174603174602*G0_0_0_3_3_5 - 0.00169312169312169*G0_0_0_3_4_0 + 0.00169312169312168*G0_0_0_3_4_1 + 0.0135449735449735*G0_0_0_3_4_3 - 0.0135449735449735*G0_0_0_3_4_4 - 0.00338624338624337*G0_0_0_3_5_0 + 0.00338624338624337*G0_0_0_3_5_1 - 0.00169312169312168*G0_0_0_3_5_2 + 0.0203174603174602*G0_0_0_3_5_3 + 0.00677248677248675*G0_0_0_3_5_5 - 0.00634920634920632*G0_0_0_4_0_0 + 0.000423280423280423*G0_0_0_4_0_1 + 0.00338624338624337*G0_0_0_4_0_2 - 0.00169312169312169*G0_0_0_4_0_3 - 0.00507936507936507*G0_0_0_4_0_4 - 0.00338624338624337*G0_0_0_4_0_5 + 0.000423280423280423*G0_0_0_4_1_0 - 0.000423280423280421*G0_0_0_4_1_1 - 0.000846560846560844*G0_0_0_4_1_2 + 0.00169312169312168*G0_0_0_4_1_3 + 0.00846560846560842*G0_0_0_4_1_4 + 0.00338624338624337*G0_0_0_4_1_5 + 0.00338624338624337*G0_0_0_4_2_0 - 0.000846560846560844*G0_0_0_4_2_1 - 0.00423280423280421*G0_0_0_4_2_2 + 0.00169312169312168*G0_0_0_4_2_5 - 0.00169312169312169*G0_0_0_4_3_0 + 0.00169312169312168*G0_0_0_4_3_1 + 0.0135449735449735*G0_0_0_4_3_3 - 0.0135449735449735*G0_0_0_4_3_4 - 0.00507936507936507*G0_0_0_4_4_0 + 0.00846560846560842*G0_0_0_4_4_1 - 0.0135449735449735*G0_0_0_4_4_3 - 0.121904761904761*G0_0_0_4_4_4 - 0.0203174603174602*G0_0_0_4_4_5 - 0.00338624338624337*G0_0_0_4_5_0 + 0.00338624338624337*G0_0_0_4_5_1 + 0.00169312169312168*G0_0_0_4_5_2 - 0.0203174603174602*G0_0_0_4_5_4 - 0.00677248677248674*G0_0_0_4_5_5 - 0.0021164021164021*G0_0_0_5_0_0 + 0.00126984126984126*G0_0_0_5_0_2 - 0.00338624338624337*G0_0_0_5_0_3 - 0.00338624338624337*G0_0_0_5_0_4 - 0.00507936507936504*G0_0_0_5_0_5 + 0.00211640211640209*G0_0_0_5_1_1 - 0.00126984126984126*G0_0_0_5_1_2 + 0.00338624338624337*G0_0_0_5_1_3 + 0.00338624338624337*G0_0_0_5_1_4 + 0.00507936507936504*G0_0_0_5_1_5 + 0.00126984126984126*G0_0_0_5_2_0 - 0.00126984126984126*G0_0_0_5_2_1 - 0.00169312169312168*G0_0_0_5_2_3 + 0.00169312169312169*G0_0_0_5_2_4 - 0.00338624338624337*G0_0_0_5_3_0 + 0.00338624338624337*G0_0_0_5_3_1 - 0.00169312169312169*G0_0_0_5_3_2 + 0.0203174603174602*G0_0_0_5_3_3 + 0.00677248677248675*G0_0_0_5_3_5 - 0.00338624338624337*G0_0_0_5_4_0 + 0.00338624338624337*G0_0_0_5_4_1 + 0.00169312169312168*G0_0_0_5_4_2 - 0.0203174603174602*G0_0_0_5_4_4 - 0.00677248677248674*G0_0_0_5_4_5 - 0.00507936507936504*G0_0_0_5_5_0 + 0.00507936507936504*G0_0_0_5_5_1 + 0.00677248677248675*G0_0_0_5_5_3 - 0.00677248677248674*G0_0_0_5_5_4 - 0.00476190476190472*G0_0_1_0_0_0 + 0.000529100529100525*G0_0_1_0_0_1 + 0.00105820105820105*G0_0_1_0_0_2 - 0.00423280423280421*G0_0_1_0_0_4 - 0.0021164021164021*G0_0_1_0_0_5 + 0.000529100529100525*G0_0_1_0_1_0 - 0.000317460317460315*G0_0_1_0_1_1 + 0.000105820105820104*G0_0_1_0_1_2 + 0.00021164021164021*G0_0_1_0_1_3 + 0.000634920634920633*G0_0_1_0_1_4 + 0.00042328042328042*G0_0_1_0_1_5 + 0.00105820105820105*G0_0_1_0_2_0 + 0.000105820105820104*G0_0_1_0_2_1 - 0.00158730158730157*G0_0_1_0_2_2 - 0.000634920634920629*G0_0_1_0_2_3 + 0.000634920634920635*G0_0_1_0_2_4 + 0.000423280423280421*G0_0_1_0_2_5 + 0.00021164021164021*G0_0_1_0_3_1 - 0.000634920634920629*G0_0_1_0_3_2 - 0.00380952380952378*G0_0_1_0_3_3 - 0.00126984126984126*G0_0_1_0_3_4 - 0.000846560846560844*G0_0_1_0_3_5 - 0.00423280423280421*G0_0_1_0_4_0 + 0.000634920634920633*G0_0_1_0_4_1 + 0.000634920634920635*G0_0_1_0_4_2 - 0.00126984126984126*G0_0_1_0_4_3 - 0.00634920634920632*G0_0_1_0_4_4 - 0.00211640211640211*G0_0_1_0_4_5 - 0.0021164021164021*G0_0_1_0_5_0 + 0.00042328042328042*G0_0_1_0_5_1 + 0.000423280423280421*G0_0_1_0_5_2 - 0.000846560846560843*G0_0_1_0_5_3 - 0.00211640211640211*G0_0_1_0_5_4 - 0.0021164021164021*G0_0_1_0_5_5 + 0.000529100529100525*G0_0_1_1_0_0 - 0.000317460317460315*G0_0_1_1_0_1 + 0.000105820105820104*G0_0_1_1_0_2 + 0.00021164021164021*G0_0_1_1_0_3 + 0.000634920634920633*G0_0_1_1_0_4 + 0.00042328042328042*G0_0_1_1_0_5 - 0.000317460317460315*G0_0_1_1_1_0 + 0.00158730158730157*G0_0_1_1_1_1 + 0.00021164021164021*G0_0_1_1_1_2 + 0.0021164021164021*G0_0_1_1_1_3 - 0.000423280423280421*G0_0_1_1_1_4 + 0.000105820105820104*G0_0_1_1_2_0 + 0.00021164021164021*G0_0_1_1_2_1 - 0.00158730158730158*G0_0_1_1_2_2 - 0.00275132275132274*G0_0_1_1_2_3 - 0.00148148148148147*G0_0_1_1_2_4 - 0.000846560846560843*G0_0_1_1_2_5 + 0.00021164021164021*G0_0_1_1_3_0 + 0.0021164021164021*G0_0_1_1_3_1 - 0.00275132275132274*G0_0_1_1_3_2 - 0.00126984126984126*G0_0_1_1_3_3 + 0.000423280423280421*G0_0_1_1_3_4 + 0.00126984126984126*G0_0_1_1_3_5 + 0.000634920634920633*G0_0_1_1_4_0 - 0.000423280423280421*G0_0_1_1_4_1 - 0.00148148148148147*G0_0_1_1_4_2 + 0.000423280423280421*G0_0_1_1_4_3 + 0.00465608465608464*G0_0_1_1_4_4 + 0.00253968253968253*G0_0_1_1_4_5 + 0.00042328042328042*G0_0_1_1_5_0 - 0.000846560846560843*G0_0_1_1_5_2 + 0.00126984126984126*G0_0_1_1_5_3 + 0.00253968253968253*G0_0_1_1_5_4 + 0.00296296296296294*G0_0_1_1_5_5 + 0.00105820105820105*G0_0_1_2_0_0 + 0.000105820105820104*G0_0_1_2_0_1 - 0.00158730158730158*G0_0_1_2_0_2 - 0.000634920634920629*G0_0_1_2_0_3 + 0.000634920634920635*G0_0_1_2_0_4 + 0.000423280423280421*G0_0_1_2_0_5 + 0.000105820105820104*G0_0_1_2_1_0 + 0.00021164021164021*G0_0_1_2_1_1 - 0.00158730158730158*G0_0_1_2_1_2 - 0.00275132275132274*G0_0_1_2_1_3 - 0.00148148148148147*G0_0_1_2_1_4 - 0.000846560846560843*G0_0_1_2_1_5 - 0.00158730158730158*G0_0_1_2_2_0 - 0.00158730158730158*G0_0_1_2_2_1 + 0.0190476190476189*G0_0_1_2_2_2 + 0.00846560846560841*G0_0_1_2_2_3 + 0.0042328042328042*G0_0_1_2_2_4 - 0.000634920634920629*G0_0_1_2_3_0 - 0.00275132275132274*G0_0_1_2_3_1 + 0.00846560846560841*G0_0_1_2_3_2 + 0.00846560846560841*G0_0_1_2_3_3 + 0.00423280423280421*G0_0_1_2_3_4 + 0.00126984126984127*G0_0_1_2_3_5 + 0.000634920634920635*G0_0_1_2_4_0 - 0.00148148148148147*G0_0_1_2_4_1 + 0.0042328042328042*G0_0_1_2_4_2 + 0.00423280423280421*G0_0_1_2_4_3 + 0.00846560846560842*G0_0_1_2_4_4 + 0.00296296296296295*G0_0_1_2_4_5 + 0.000423280423280421*G0_0_1_2_5_0 - 0.000846560846560843*G0_0_1_2_5_1 + 0.00126984126984127*G0_0_1_2_5_3 + 0.00296296296296295*G0_0_1_2_5_4 + 0.00253968253968253*G0_0_1_2_5_5 + 0.00021164021164021*G0_0_1_3_0_1 - 0.000634920634920629*G0_0_1_3_0_2 - 0.00380952380952378*G0_0_1_3_0_3 - 0.00126984126984126*G0_0_1_3_0_4 - 0.000846560846560843*G0_0_1_3_0_5 + 0.00021164021164021*G0_0_1_3_1_0 + 0.0021164021164021*G0_0_1_3_1_1 - 0.00275132275132274*G0_0_1_3_1_2 - 0.00126984126984126*G0_0_1_3_1_3 + 0.000423280423280421*G0_0_1_3_1_4 + 0.00126984126984126*G0_0_1_3_1_5 - 0.000634920634920629*G0_0_1_3_2_0 - 0.00275132275132274*G0_0_1_3_2_1 + 0.00846560846560841*G0_0_1_3_2_2 + 0.00846560846560841*G0_0_1_3_2_3 + 0.00423280423280421*G0_0_1_3_2_4 + 0.00126984126984127*G0_0_1_3_2_5 - 0.00380952380952378*G0_0_1_3_3_0 - 0.00126984126984126*G0_0_1_3_3_1 + 0.00846560846560841*G0_0_1_3_3_2 + 0.0609523809523806*G0_0_1_3_3_3 + 0.00677248677248675*G0_0_1_3_3_4 + 0.00507936507936507*G0_0_1_3_3_5 - 0.00126984126984126*G0_0_1_3_4_0 + 0.000423280423280421*G0_0_1_3_4_1 + 0.00423280423280421*G0_0_1_3_4_2 + 0.00677248677248675*G0_0_1_3_4_3 - 0.00677248677248674*G0_0_1_3_4_4 - 0.00338624338624337*G0_0_1_3_4_5 - 0.000846560846560843*G0_0_1_3_5_0 + 0.00126984126984126*G0_0_1_3_5_1 + 0.00126984126984127*G0_0_1_3_5_2 + 0.00507936507936507*G0_0_1_3_5_3 - 0.00338624338624337*G0_0_1_3_5_4 - 0.00338624338624336*G0_0_1_3_5_5 - 0.00423280423280421*G0_0_1_4_0_0 + 0.000634920634920633*G0_0_1_4_0_1 + 0.000634920634920635*G0_0_1_4_0_2 - 0.00126984126984126*G0_0_1_4_0_3 - 0.00634920634920632*G0_0_1_4_0_4 - 0.00211640211640211*G0_0_1_4_0_5 + 0.000634920634920633*G0_0_1_4_1_0 - 0.000423280423280421*G0_0_1_4_1_1 - 0.00148148148148147*G0_0_1_4_1_2 + 0.000423280423280421*G0_0_1_4_1_3 + 0.00465608465608464*G0_0_1_4_1_4 + 0.00253968253968253*G0_0_1_4_1_5 + 0.000634920634920635*G0_0_1_4_2_0 - 0.00148148148148147*G0_0_1_4_2_1 + 0.0042328042328042*G0_0_1_4_2_2 + 0.00423280423280421*G0_0_1_4_2_3 + 0.00846560846560842*G0_0_1_4_2_4 + 0.00296296296296295*G0_0_1_4_2_5 - 0.00126984126984126*G0_0_1_4_3_0 + 0.000423280423280421*G0_0_1_4_3_1 + 0.00423280423280421*G0_0_1_4_3_2 + 0.00677248677248675*G0_0_1_4_3_3 - 0.00677248677248674*G0_0_1_4_3_4 - 0.00338624338624337*G0_0_1_4_3_5 - 0.00634920634920632*G0_0_1_4_4_0 + 0.00465608465608464*G0_0_1_4_4_1 + 0.00846560846560842*G0_0_1_4_4_2 - 0.00677248677248674*G0_0_1_4_4_3 - 0.0609523809523807*G0_0_1_4_4_4 - 0.0152380952380952*G0_0_1_4_4_5 - 0.00211640211640211*G0_0_1_4_5_0 + 0.00253968253968253*G0_0_1_4_5_1 + 0.00296296296296295*G0_0_1_4_5_2 - 0.00338624338624337*G0_0_1_4_5_3 - 0.0152380952380952*G0_0_1_4_5_4 - 0.0101587301587301*G0_0_1_4_5_5 - 0.0021164021164021*G0_0_1_5_0_0 + 0.00042328042328042*G0_0_1_5_0_1 + 0.000423280423280421*G0_0_1_5_0_2 - 0.000846560846560843*G0_0_1_5_0_3 - 0.00211640211640211*G0_0_1_5_0_4 - 0.0021164021164021*G0_0_1_5_0_5 + 0.00042328042328042*G0_0_1_5_1_0 - 0.000846560846560843*G0_0_1_5_1_2 + 0.00126984126984126*G0_0_1_5_1_3 + 0.00253968253968253*G0_0_1_5_1_4 + 0.00296296296296294*G0_0_1_5_1_5 + 0.000423280423280421*G0_0_1_5_2_0 - 0.000846560846560843*G0_0_1_5_2_1 + 0.00126984126984127*G0_0_1_5_2_3 + 0.00296296296296295*G0_0_1_5_2_4 + 0.00253968253968253*G0_0_1_5_2_5 - 0.000846560846560843*G0_0_1_5_3_0 + 0.00126984126984126*G0_0_1_5_3_1 + 0.00126984126984127*G0_0_1_5_3_2 + 0.00507936507936507*G0_0_1_5_3_3 - 0.00338624338624337*G0_0_1_5_3_4 - 0.00338624338624336*G0_0_1_5_3_5 - 0.00211640211640211*G0_0_1_5_4_0 + 0.00253968253968253*G0_0_1_5_4_1 + 0.00296296296296295*G0_0_1_5_4_2 - 0.00338624338624337*G0_0_1_5_4_3 - 0.0152380952380952*G0_0_1_5_4_4 - 0.0101587301587301*G0_0_1_5_4_5 - 0.0021164021164021*G0_0_1_5_5_0 + 0.00296296296296294*G0_0_1_5_5_1 + 0.00253968253968253*G0_0_1_5_5_2 - 0.00338624338624336*G0_0_1_5_5_3 - 0.0101587301587301*G0_0_1_5_5_4 - 0.0152380952380951*G0_0_1_5_5_5 + 0.0126984126984126*G0_1_0_0_0_0 - 0.000211640211640213*G0_1_0_0_0_1 - 0.00126984126984126*G0_1_0_0_0_2 + 0.000423280423280421*G0_1_0_0_0_3 + 0.00423280423280421*G0_1_0_0_0_4 - 0.000211640211640213*G0_1_0_0_1_0 - 0.00105820105820105*G0_1_0_0_1_1 + 0.000105820105820105*G0_1_0_0_1_2 - 0.000846560846560839*G0_1_0_0_1_3 - 0.000423280423280422*G0_1_0_0_1_4 + 0.000846560846560843*G0_1_0_0_1_5 - 0.00126984126984126*G0_1_0_0_2_0 + 0.000105820105820105*G0_1_0_0_2_1 + 0.00148148148148147*G0_1_0_0_2_2 + 0.00084656084656084*G0_1_0_0_2_3 + 0.000423280423280419*G0_1_0_0_2_4 + 0.000423280423280421*G0_1_0_0_3_0 - 0.000846560846560839*G0_1_0_0_3_1 + 0.00084656084656084*G0_1_0_0_3_2 - 0.00592592592592588*G0_1_0_0_3_3 - 0.00084656084656084*G0_1_0_0_3_5 + 0.00423280423280421*G0_1_0_0_4_0 - 0.000423280423280422*G0_1_0_0_4_1 + 0.000423280423280419*G0_1_0_0_4_2 + 0.00761904761904758*G0_1_0_0_4_4 + 0.000846560846560846*G0_1_0_0_4_5 + 0.000846560846560843*G0_1_0_0_5_1 - 0.00084656084656084*G0_1_0_0_5_3 + 0.000846560846560847*G0_1_0_0_5_4 - 0.000846560846560832*G0_1_0_0_5_5 - 0.000211640211640213*G0_1_0_1_0_0 - 0.00105820105820105*G0_1_0_1_0_1 + 0.000105820105820105*G0_1_0_1_0_2 - 0.000846560846560839*G0_1_0_1_0_3 - 0.000423280423280422*G0_1_0_1_0_4 + 0.000846560846560843*G0_1_0_1_0_5 - 0.00105820105820105*G0_1_0_1_1_0 + 0.0190476190476189*G0_1_0_1_1_1 - 0.0021164021164021*G0_1_0_1_1_2 + 0.0105820105820105*G0_1_0_1_1_3 + 0.00211640211640209*G0_1_0_1_1_5 + 0.000105820105820105*G0_1_0_1_2_0 - 0.0021164021164021*G0_1_0_1_2_1 + 0.00148148148148147*G0_1_0_1_2_2 - 0.00296296296296295*G0_1_0_1_2_3 - 0.00126984126984126*G0_1_0_1_2_5 - 0.000846560846560839*G0_1_0_1_3_0 + 0.0105820105820105*G0_1_0_1_3_1 - 0.00296296296296295*G0_1_0_1_3_2 + 0.0126984126984126*G0_1_0_1_3_3 + 0.00169312169312168*G0_1_0_1_3_4 + 0.00423280423280421*G0_1_0_1_3_5 - 0.000423280423280422*G0_1_0_1_4_0 + 0.00169312169312168*G0_1_0_1_4_3 + 0.00253968253968252*G0_1_0_1_4_4 + 0.00253968253968253*G0_1_0_1_4_5 + 0.000846560846560843*G0_1_0_1_5_0 + 0.00211640211640209*G0_1_0_1_5_1 - 0.00126984126984126*G0_1_0_1_5_2 + 0.00423280423280421*G0_1_0_1_5_3 + 0.00253968253968253*G0_1_0_1_5_4 + 0.00423280423280419*G0_1_0_1_5_5 - 0.00126984126984126*G0_1_0_2_0_0 + 0.000105820105820105*G0_1_0_2_0_1 + 0.00148148148148147*G0_1_0_2_0_2 + 0.00084656084656084*G0_1_0_2_0_3 + 0.000423280423280419*G0_1_0_2_0_4 + 0.000105820105820105*G0_1_0_2_1_0 - 0.0021164021164021*G0_1_0_2_1_1 + 0.00148148148148147*G0_1_0_2_1_2 - 0.00296296296296295*G0_1_0_2_1_3 - 0.00126984126984126*G0_1_0_2_1_5 + 0.00148148148148147*G0_1_0_2_2_0 + 0.00148148148148147*G0_1_0_2_2_1 - 0.0158730158730158*G0_1_0_2_2_2 - 0.00211640211640211*G0_1_0_2_2_3 - 0.00634920634920631*G0_1_0_2_2_4 - 0.000846560846560846*G0_1_0_2_2_5 + 0.00084656084656084*G0_1_0_2_3_0 - 0.00296296296296295*G0_1_0_2_3_1 - 0.00211640211640211*G0_1_0_2_3_2 - 0.00677248677248673*G0_1_0_2_3_3 - 0.00169312169312168*G0_1_0_2_3_4 + 0.000423280423280419*G0_1_0_2_4_0 - 0.00634920634920631*G0_1_0_2_4_2 - 0.00169312169312168*G0_1_0_2_4_3 - 0.00677248677248674*G0_1_0_2_4_4 + 0.00169312169312168*G0_1_0_2_4_5 - 0.00126984126984126*G0_1_0_2_5_1 - 0.000846560846560846*G0_1_0_2_5_2 + 0.00169312169312168*G0_1_0_2_5_4 + 0.00677248677248674*G0_1_0_2_5_5 + 0.000423280423280421*G0_1_0_3_0_0 - 0.000846560846560839*G0_1_0_3_0_1 + 0.00084656084656084*G0_1_0_3_0_2 - 0.00592592592592588*G0_1_0_3_0_3 - 0.00084656084656084*G0_1_0_3_0_5 - 0.000846560846560839*G0_1_0_3_1_0 + 0.0105820105820105*G0_1_0_3_1_1 - 0.00296296296296295*G0_1_0_3_1_2 + 0.0126984126984126*G0_1_0_3_1_3 + 0.00169312169312168*G0_1_0_3_1_4 + 0.00423280423280421*G0_1_0_3_1_5 + 0.00084656084656084*G0_1_0_3_2_0 - 0.00296296296296295*G0_1_0_3_2_1 - 0.0021164021164021*G0_1_0_3_2_2 - 0.00677248677248673*G0_1_0_3_2_3 - 0.00169312169312168*G0_1_0_3_2_4 - 0.00592592592592588*G0_1_0_3_3_0 + 0.0126984126984126*G0_1_0_3_3_1 - 0.00677248677248674*G0_1_0_3_3_2 + 0.106666666666666*G0_1_0_3_3_3 + 0.00846560846560843*G0_1_0_3_3_4 + 0.0118518518518518*G0_1_0_3_3_5 + 0.00169312169312168*G0_1_0_3_4_1 - 0.00169312169312168*G0_1_0_3_4_2 + 0.00846560846560843*G0_1_0_3_4_3 - 0.00507936507936505*G0_1_0_3_4_4 - 0.00338624338624337*G0_1_0_3_4_5 - 0.00084656084656084*G0_1_0_3_5_0 + 0.00423280423280421*G0_1_0_3_5_1 + 0.0118518518518518*G0_1_0_3_5_3 - 0.00338624338624337*G0_1_0_3_5_4 - 0.0118518518518518*G0_1_0_3_5_5 + 0.00423280423280421*G0_1_0_4_0_0 - 0.000423280423280422*G0_1_0_4_0_1 + 0.000423280423280419*G0_1_0_4_0_2 + 0.00761904761904758*G0_1_0_4_0_4 + 0.000846560846560847*G0_1_0_4_0_5 - 0.000423280423280422*G0_1_0_4_1_0 + 0.00169312169312168*G0_1_0_4_1_3 + 0.00253968253968252*G0_1_0_4_1_4 + 0.00253968253968253*G0_1_0_4_1_5 + 0.000423280423280419*G0_1_0_4_2_0 - 0.00634920634920631*G0_1_0_4_2_2 - 0.00169312169312168*G0_1_0_4_2_3 - 0.00677248677248674*G0_1_0_4_2_4 + 0.00169312169312168*G0_1_0_4_2_5 + 0.00169312169312168*G0_1_0_4_3_1 - 0.00169312169312168*G0_1_0_4_3_2 + 0.00846560846560843*G0_1_0_4_3_3 - 0.00507936507936505*G0_1_0_4_3_4 - 0.00338624338624337*G0_1_0_4_3_5 + 0.00761904761904758*G0_1_0_4_4_0 + 0.00253968253968252*G0_1_0_4_4_1 - 0.00677248677248674*G0_1_0_4_4_2 - 0.00507936507936505*G0_1_0_4_4_3 - 0.0152380952380951*G0_1_0_4_4_4 - 0.00846560846560842*G0_1_0_4_4_5 + 0.000846560846560847*G0_1_0_4_5_0 + 0.00253968253968253*G0_1_0_4_5_1 + 0.00169312169312168*G0_1_0_4_5_2 - 0.00338624338624337*G0_1_0_4_5_3 - 0.00846560846560842*G0_1_0_4_5_4 - 0.0186243386243385*G0_1_0_4_5_5 + 0.000846560846560843*G0_1_0_5_0_1 - 0.00084656084656084*G0_1_0_5_0_3 + 0.000846560846560847*G0_1_0_5_0_4 - 0.000846560846560832*G0_1_0_5_0_5 + 0.000846560846560843*G0_1_0_5_1_0 + 0.00211640211640209*G0_1_0_5_1_1 - 0.00126984126984126*G0_1_0_5_1_2 + 0.00423280423280421*G0_1_0_5_1_3 + 0.00253968253968252*G0_1_0_5_1_4 + 0.00423280423280419*G0_1_0_5_1_5 - 0.00126984126984126*G0_1_0_5_2_1 - 0.000846560846560846*G0_1_0_5_2_2 + 0.00169312169312168*G0_1_0_5_2_4 + 0.00677248677248674*G0_1_0_5_2_5 - 0.00084656084656084*G0_1_0_5_3_0 + 0.00423280423280421*G0_1_0_5_3_1 + 0.0118518518518518*G0_1_0_5_3_3 - 0.00338624338624337*G0_1_0_5_3_4 - 0.0118518518518518*G0_1_0_5_3_5 + 0.000846560846560847*G0_1_0_5_4_0 + 0.00253968253968252*G0_1_0_5_4_1 + 0.00169312169312168*G0_1_0_5_4_2 - 0.00338624338624337*G0_1_0_5_4_3 - 0.00846560846560842*G0_1_0_5_4_4 - 0.0186243386243385*G0_1_0_5_4_5 - 0.000846560846560832*G0_1_0_5_5_0 + 0.00423280423280419*G0_1_0_5_5_1 + 0.00677248677248674*G0_1_0_5_5_2 - 0.0118518518518518*G0_1_0_5_5_3 - 0.0186243386243385*G0_1_0_5_5_4 - 0.106666666666666*G0_1_0_5_5_5 - 0.00476190476190474*G0_1_1_0_0_0 + 0.00105820105820105*G0_1_1_0_0_1 + 0.000529100529100526*G0_1_1_0_0_2 - 0.00211640211640211*G0_1_1_0_0_4 - 0.00423280423280421*G0_1_1_0_0_5 + 0.00105820105820105*G0_1_1_0_1_0 - 0.00158730158730158*G0_1_1_0_1_1 + 0.000105820105820105*G0_1_1_0_1_2 - 0.00063492063492063*G0_1_1_0_1_3 + 0.000423280423280421*G0_1_1_0_1_4 + 0.000634920634920631*G0_1_1_0_1_5 + 0.000529100529100526*G0_1_1_0_2_0 + 0.000105820105820105*G0_1_1_0_2_1 - 0.000317460317460315*G0_1_1_0_2_2 + 0.000211640211640211*G0_1_1_0_2_3 + 0.000423280423280422*G0_1_1_0_2_4 + 0.000634920634920632*G0_1_1_0_2_5 - 0.00063492063492063*G0_1_1_0_3_1 + 0.000211640211640211*G0_1_1_0_3_2 - 0.00380952380952378*G0_1_1_0_3_3 - 0.000846560846560843*G0_1_1_0_3_4 - 0.00126984126984126*G0_1_1_0_3_5 - 0.00211640211640211*G0_1_1_0_4_0 + 0.000423280423280421*G0_1_1_0_4_1 + 0.000423280423280422*G0_1_1_0_4_2 - 0.000846560846560843*G0_1_1_0_4_3 - 0.00211640211640211*G0_1_1_0_4_4 - 0.00211640211640211*G0_1_1_0_4_5 - 0.00423280423280421*G0_1_1_0_5_0 + 0.000634920634920631*G0_1_1_0_5_1 + 0.000634920634920632*G0_1_1_0_5_2 - 0.00126984126984126*G0_1_1_0_5_3 - 0.00211640211640211*G0_1_1_0_5_4 - 0.00634920634920631*G0_1_1_0_5_5 + 0.00105820105820105*G0_1_1_1_0_0 - 0.00158730158730158*G0_1_1_1_0_1 + 0.000105820105820105*G0_1_1_1_0_2 - 0.00063492063492063*G0_1_1_1_0_3 + 0.000423280423280421*G0_1_1_1_0_4 + 0.000634920634920631*G0_1_1_1_0_5 - 0.00158730158730158*G0_1_1_1_1_0 + 0.0190476190476189*G0_1_1_1_1_1 - 0.00158730158730158*G0_1_1_1_1_2 + 0.00846560846560842*G0_1_1_1_1_3 + 0.00423280423280421*G0_1_1_1_1_5 + 0.000105820105820105*G0_1_1_1_2_0 - 0.00158730158730158*G0_1_1_1_2_1 + 0.000211640211640211*G0_1_1_1_2_2 - 0.00275132275132274*G0_1_1_1_2_3 - 0.000846560846560842*G0_1_1_1_2_4 - 0.00148148148148147*G0_1_1_1_2_5 - 0.00063492063492063*G0_1_1_1_3_0 + 0.00846560846560842*G0_1_1_1_3_1 - 0.00275132275132274*G0_1_1_1_3_2 + 0.00846560846560843*G0_1_1_1_3_3 + 0.00126984126984126*G0_1_1_1_3_4 + 0.00423280423280421*G0_1_1_1_3_5 + 0.000423280423280421*G0_1_1_1_4_0 - 0.000846560846560842*G0_1_1_1_4_2 + 0.00126984126984126*G0_1_1_1_4_3 + 0.00253968253968253*G0_1_1_1_4_4 + 0.00296296296296295*G0_1_1_1_4_5 + 0.000634920634920631*G0_1_1_1_5_0 + 0.00423280423280421*G0_1_1_1_5_1 - 0.00148148148148147*G0_1_1_1_5_2 + 0.00423280423280421*G0_1_1_1_5_3 + 0.00296296296296295*G0_1_1_1_5_4 + 0.00846560846560841*G0_1_1_1_5_5 + 0.000529100529100526*G0_1_1_2_0_0 + 0.000105820105820105*G0_1_1_2_0_1 - 0.000317460317460315*G0_1_1_2_0_2 + 0.000211640211640211*G0_1_1_2_0_3 + 0.000423280423280422*G0_1_1_2_0_4 + 0.000634920634920632*G0_1_1_2_0_5 + 0.000105820105820105*G0_1_1_2_1_0 - 0.00158730158730158*G0_1_1_2_1_1 + 0.000211640211640212*G0_1_1_2_1_2 - 0.00275132275132274*G0_1_1_2_1_3 - 0.000846560846560842*G0_1_1_2_1_4 - 0.00148148148148147*G0_1_1_2_1_5 - 0.000317460317460315*G0_1_1_2_2_0 + 0.000211640211640211*G0_1_1_2_2_1 + 0.00158730158730157*G0_1_1_2_2_2 + 0.0021164021164021*G0_1_1_2_2_3 - 0.00042328042328042*G0_1_1_2_2_5 + 0.000211640211640211*G0_1_1_2_3_0 - 0.00275132275132274*G0_1_1_2_3_1 + 0.0021164021164021*G0_1_1_2_3_2 - 0.00126984126984127*G0_1_1_2_3_3 + 0.00126984126984126*G0_1_1_2_3_4 + 0.00042328042328042*G0_1_1_2_3_5 + 0.000423280423280422*G0_1_1_2_4_0 - 0.000846560846560842*G0_1_1_2_4_1 + 0.00126984126984126*G0_1_1_2_4_3 + 0.00296296296296295*G0_1_1_2_4_4 + 0.00253968253968253*G0_1_1_2_4_5 + 0.000634920634920632*G0_1_1_2_5_0 - 0.00148148148148147*G0_1_1_2_5_1 - 0.00042328042328042*G0_1_1_2_5_2 + 0.00042328042328042*G0_1_1_2_5_3 + 0.00253968253968253*G0_1_1_2_5_4 + 0.00465608465608463*G0_1_1_2_5_5 - 0.00063492063492063*G0_1_1_3_0_1 + 0.000211640211640211*G0_1_1_3_0_2 - 0.00380952380952378*G0_1_1_3_0_3 - 0.000846560846560843*G0_1_1_3_0_4 - 0.00126984126984126*G0_1_1_3_0_5 - 0.00063492063492063*G0_1_1_3_1_0 + 0.00846560846560842*G0_1_1_3_1_1 - 0.00275132275132274*G0_1_1_3_1_2 + 0.00846560846560843*G0_1_1_3_1_3 + 0.00126984126984126*G0_1_1_3_1_4 + 0.00423280423280421*G0_1_1_3_1_5 + 0.000211640211640211*G0_1_1_3_2_0 - 0.00275132275132274*G0_1_1_3_2_1 + 0.0021164021164021*G0_1_1_3_2_2 - 0.00126984126984127*G0_1_1_3_2_3 + 0.00126984126984126*G0_1_1_3_2_4 + 0.00042328042328042*G0_1_1_3_2_5 - 0.00380952380952378*G0_1_1_3_3_0 + 0.00846560846560843*G0_1_1_3_3_1 - 0.00126984126984127*G0_1_1_3_3_2 + 0.0609523809523806*G0_1_1_3_3_3 + 0.00507936507936506*G0_1_1_3_3_4 + 0.00677248677248676*G0_1_1_3_3_5 - 0.000846560846560843*G0_1_1_3_4_0 + 0.00126984126984126*G0_1_1_3_4_1 + 0.00126984126984126*G0_1_1_3_4_2 + 0.00507936507936506*G0_1_1_3_4_3 - 0.00338624338624337*G0_1_1_3_4_4 - 0.00338624338624337*G0_1_1_3_4_5 - 0.00126984126984126*G0_1_1_3_5_0 + 0.00423280423280421*G0_1_1_3_5_1 + 0.00042328042328042*G0_1_1_3_5_2 + 0.00677248677248676*G0_1_1_3_5_3 - 0.00338624338624337*G0_1_1_3_5_4 - 0.00677248677248673*G0_1_1_3_5_5 - 0.00211640211640211*G0_1_1_4_0_0 + 0.000423280423280421*G0_1_1_4_0_1 + 0.000423280423280422*G0_1_1_4_0_2 - 0.000846560846560843*G0_1_1_4_0_3 - 0.00211640211640211*G0_1_1_4_0_4 - 0.00211640211640211*G0_1_1_4_0_5 + 0.000423280423280421*G0_1_1_4_1_0 - 0.000846560846560842*G0_1_1_4_1_2 + 0.00126984126984126*G0_1_1_4_1_3 + 0.00253968253968253*G0_1_1_4_1_4 + 0.00296296296296295*G0_1_1_4_1_5 + 0.000423280423280422*G0_1_1_4_2_0 - 0.000846560846560842*G0_1_1_4_2_1 + 0.00126984126984126*G0_1_1_4_2_3 + 0.00296296296296295*G0_1_1_4_2_4 + 0.00253968253968253*G0_1_1_4_2_5 - 0.000846560846560843*G0_1_1_4_3_0 + 0.00126984126984126*G0_1_1_4_3_1 + 0.00126984126984126*G0_1_1_4_3_2 + 0.00507936507936506*G0_1_1_4_3_3 - 0.00338624338624337*G0_1_1_4_3_4 - 0.00338624338624337*G0_1_1_4_3_5 - 0.00211640211640211*G0_1_1_4_4_0 + 0.00253968253968253*G0_1_1_4_4_1 + 0.00296296296296295*G0_1_1_4_4_2 - 0.00338624338624337*G0_1_1_4_4_3 - 0.0152380952380952*G0_1_1_4_4_4 - 0.0101587301587301*G0_1_1_4_4_5 - 0.00211640211640211*G0_1_1_4_5_0 + 0.00296296296296295*G0_1_1_4_5_1 + 0.00253968253968253*G0_1_1_4_5_2 - 0.00338624338624337*G0_1_1_4_5_3 - 0.0101587301587301*G0_1_1_4_5_4 - 0.0152380952380952*G0_1_1_4_5_5 - 0.00423280423280421*G0_1_1_5_0_0 + 0.000634920634920631*G0_1_1_5_0_1 + 0.000634920634920632*G0_1_1_5_0_2 - 0.00126984126984126*G0_1_1_5_0_3 - 0.00211640211640211*G0_1_1_5_0_4 - 0.00634920634920631*G0_1_1_5_0_5 + 0.000634920634920631*G0_1_1_5_1_0 + 0.00423280423280421*G0_1_1_5_1_1 - 0.00148148148148147*G0_1_1_5_1_2 + 0.00423280423280421*G0_1_1_5_1_3 + 0.00296296296296295*G0_1_1_5_1_4 + 0.00846560846560841*G0_1_1_5_1_5 + 0.000634920634920632*G0_1_1_5_2_0 - 0.00148148148148147*G0_1_1_5_2_1 - 0.00042328042328042*G0_1_1_5_2_2 + 0.000423280423280421*G0_1_1_5_2_3 + 0.00253968253968253*G0_1_1_5_2_4 + 0.00465608465608463*G0_1_1_5_2_5 - 0.00126984126984126*G0_1_1_5_3_0 + 0.00423280423280421*G0_1_1_5_3_1 + 0.00042328042328042*G0_1_1_5_3_2 + 0.00677248677248676*G0_1_1_5_3_3 - 0.00338624338624337*G0_1_1_5_3_4 - 0.00677248677248673*G0_1_1_5_3_5 - 0.00211640211640211*G0_1_1_5_4_0 + 0.00296296296296295*G0_1_1_5_4_1 + 0.00253968253968253*G0_1_1_5_4_2 - 0.00338624338624337*G0_1_1_5_4_3 - 0.0101587301587301*G0_1_1_5_4_4 - 0.0152380952380952*G0_1_1_5_4_5 - 0.00634920634920631*G0_1_1_5_5_0 + 0.00846560846560841*G0_1_1_5_5_1 + 0.00465608465608463*G0_1_1_5_5_2 - 0.00677248677248673*G0_1_1_5_5_3 - 0.0152380952380952*G0_1_1_5_5_4 - 0.0609523809523806*G0_1_1_5_5_5;
    A[3] = A[18] + 0.000529100529100525*G0_0_1_0_0_1 - 0.000529100529100526*G0_0_1_0_0_2 + 0.0021164021164021*G0_0_1_0_0_4 - 0.0021164021164021*G0_0_1_0_0_5 + 0.000529100529100525*G0_0_1_0_1_0 - 0.00126984126984126*G0_0_1_0_1_1 - 0.00084656084656084*G0_0_1_0_1_3 - 0.000211640211640211*G0_0_1_0_1_4 + 0.000211640211640211*G0_0_1_0_1_5 - 0.000529100529100526*G0_0_1_0_2_0 + 0.00126984126984126*G0_0_1_0_2_2 + 0.000846560846560839*G0_0_1_0_2_3 - 0.000211640211640214*G0_0_1_0_2_4 + 0.00021164021164021*G0_0_1_0_2_5 - 0.00084656084656084*G0_0_1_0_3_1 + 0.00084656084656084*G0_0_1_0_3_2 + 0.000423280423280421*G0_0_1_0_3_4 - 0.000423280423280419*G0_0_1_0_3_5 + 0.0021164021164021*G0_0_1_0_4_0 - 0.000211640211640211*G0_0_1_0_4_1 - 0.000211640211640213*G0_0_1_0_4_2 + 0.000423280423280421*G0_0_1_0_4_3 + 0.00423280423280421*G0_0_1_0_4_4 - 0.00211640211640211*G0_0_1_0_5_0 + 0.000211640211640211*G0_0_1_0_5_1 + 0.00021164021164021*G0_0_1_0_5_2 - 0.000423280423280419*G0_0_1_0_5_3 - 0.0042328042328042*G0_0_1_0_5_5 + 0.000529100529100525*G0_0_1_1_0_0 - 0.00126984126984126*G0_0_1_1_0_1 - 0.00084656084656084*G0_0_1_1_0_3 - 0.000211640211640211*G0_0_1_1_0_4 + 0.000211640211640212*G0_0_1_1_0_5 - 0.00126984126984126*G0_0_1_1_1_0 + 0.0174603174603173*G0_0_1_1_1_1 - 0.00179894179894179*G0_0_1_1_1_2 + 0.00634920634920631*G0_0_1_1_1_3 + 0.000423280423280422*G0_0_1_1_1_4 + 0.00423280423280421*G0_0_1_1_1_5 - 0.00179894179894179*G0_0_1_1_2_1 + 0.00179894179894179*G0_0_1_1_2_2 + 0.000634920634920631*G0_0_1_1_2_4 - 0.00063492063492063*G0_0_1_1_2_5 - 0.00084656084656084*G0_0_1_1_3_0 + 0.00634920634920631*G0_0_1_1_3_1 + 0.00973544973544968*G0_0_1_1_3_3 + 0.000846560846560842*G0_0_1_1_3_4 + 0.00296296296296295*G0_0_1_1_3_5 - 0.000211640211640211*G0_0_1_1_4_0 + 0.000423280423280422*G0_0_1_1_4_1 + 0.000634920634920631*G0_0_1_1_4_2 + 0.000846560846560842*G0_0_1_1_4_3 - 0.00211640211640211*G0_0_1_1_4_4 + 0.00042328042328042*G0_0_1_1_4_5 + 0.000211640211640211*G0_0_1_1_5_0 + 0.00423280423280421*G0_0_1_1_5_1 - 0.00063492063492063*G0_0_1_1_5_2 + 0.00296296296296295*G0_0_1_1_5_3 + 0.00042328042328042*G0_0_1_1_5_4 + 0.00550264550264546*G0_0_1_1_5_5 - 0.000529100529100526*G0_0_1_2_0_0 + 0.00126984126984126*G0_0_1_2_0_2 + 0.000846560846560839*G0_0_1_2_0_3 - 0.000211640211640213*G0_0_1_2_0_4 + 0.00021164021164021*G0_0_1_2_0_5 - 0.00179894179894179*G0_0_1_2_1_1 + 0.00179894179894179*G0_0_1_2_1_2 + 0.000634920634920631*G0_0_1_2_1_4 - 0.00063492063492063*G0_0_1_2_1_5 + 0.00126984126984126*G0_0_1_2_2_0 + 0.00179894179894179*G0_0_1_2_2_1 - 0.0174603174603174*G0_0_1_2_2_2 - 0.00634920634920631*G0_0_1_2_2_3 - 0.0042328042328042*G0_0_1_2_2_4 - 0.000423280423280425*G0_0_1_2_2_5 + 0.000846560846560839*G0_0_1_2_3_0 - 0.00634920634920631*G0_0_1_2_3_2 - 0.00973544973544967*G0_0_1_2_3_3 - 0.00296296296296294*G0_0_1_2_3_4 - 0.000846560846560844*G0_0_1_2_3_5 - 0.000211640211640213*G0_0_1_2_4_0 + 0.000634920634920631*G0_0_1_2_4_1 - 0.0042328042328042*G0_0_1_2_4_2 - 0.00296296296296295*G0_0_1_2_4_3 - 0.00550264550264547*G0_0_1_2_4_4 - 0.000423280423280424*G0_0_1_2_4_5 + 0.00021164021164021*G0_0_1_2_5_0 - 0.00063492063492063*G0_0_1_2_5_1 - 0.000423280423280425*G0_0_1_2_5_2 - 0.000846560846560844*G0_0_1_2_5_3 - 0.000423280423280424*G0_0_1_2_5_4 + 0.0021164021164021*G0_0_1_2_5_5 - 0.00084656084656084*G0_0_1_3_0_1 + 0.000846560846560839*G0_0_1_3_0_2 + 0.000423280423280421*G0_0_1_3_0_4 - 0.000423280423280419*G0_0_1_3_0_5 - 0.00084656084656084*G0_0_1_3_1_0 + 0.00634920634920631*G0_0_1_3_1_1 + 0.00973544973544968*G0_0_1_3_1_3 + 0.000846560846560842*G0_0_1_3_1_4 + 0.00296296296296295*G0_0_1_3_1_5 + 0.00084656084656084*G0_0_1_3_2_0 - 0.00634920634920631*G0_0_1_3_2_2 - 0.00973544973544967*G0_0_1_3_2_3 - 0.00296296296296294*G0_0_1_3_2_4 - 0.000846560846560845*G0_0_1_3_2_5 + 0.00973544973544968*G0_0_1_3_3_1 - 0.00973544973544967*G0_0_1_3_3_2 - 0.00169312169312168*G0_0_1_3_3_4 + 0.00169312169312168*G0_0_1_3_3_5 + 0.000423280423280422*G0_0_1_3_4_0 + 0.000846560846560842*G0_0_1_3_4_1 - 0.00296296296296294*G0_0_1_3_4_2 - 0.00169312169312168*G0_0_1_3_4_3 + 0.00338624338624337*G0_0_1_3_4_4 - 0.000423280423280419*G0_0_1_3_5_0 + 0.00296296296296295*G0_0_1_3_5_1 - 0.000846560846560845*G0_0_1_3_5_2 + 0.00169312169312168*G0_0_1_3_5_3 - 0.00338624338624337*G0_0_1_3_5_5 + 0.0021164021164021*G0_0_1_4_0_0 - 0.000211640211640211*G0_0_1_4_0_1 - 0.000211640211640213*G0_0_1_4_0_2 + 0.000423280423280421*G0_0_1_4_0_3 + 0.00423280423280421*G0_0_1_4_0_4 - 0.000211640211640211*G0_0_1_4_1_0 + 0.000423280423280422*G0_0_1_4_1_1 + 0.000634920634920631*G0_0_1_4_1_2 + 0.000846560846560842*G0_0_1_4_1_3 - 0.00211640211640211*G0_0_1_4_1_4 + 0.00042328042328042*G0_0_1_4_1_5 - 0.000211640211640213*G0_0_1_4_2_0 + 0.000634920634920631*G0_0_1_4_2_1 - 0.0042328042328042*G0_0_1_4_2_2 - 0.00296296296296294*G0_0_1_4_2_3 - 0.00550264550264547*G0_0_1_4_2_4 - 0.000423280423280424*G0_0_1_4_2_5 + 0.000423280423280421*G0_0_1_4_3_0 + 0.000846560846560842*G0_0_1_4_3_1 - 0.00296296296296294*G0_0_1_4_3_2 - 0.00169312169312169*G0_0_1_4_3_3 + 0.00338624338624337*G0_0_1_4_3_4 + 0.00423280423280421*G0_0_1_4_4_0 - 0.00211640211640211*G0_0_1_4_4_1 - 0.00550264550264547*G0_0_1_4_4_2 + 0.00338624338624337*G0_0_1_4_4_3 + 0.0457142857142855*G0_0_1_4_4_4 + 0.00507936507936506*G0_0_1_4_4_5 + 0.00042328042328042*G0_0_1_4_5_1 - 0.000423280423280424*G0_0_1_4_5_2 + 0.00507936507936506*G0_0_1_4_5_4 - 0.00507936507936505*G0_0_1_4_5_5 - 0.00211640211640211*G0_0_1_5_0_0 + 0.000211640211640211*G0_0_1_5_0_1 + 0.00021164021164021*G0_0_1_5_0_2 - 0.000423280423280419*G0_0_1_5_0_3 - 0.0042328042328042*G0_0_1_5_0_5 + 0.000211640211640212*G0_0_1_5_1_0 + 0.00423280423280421*G0_0_1_5_1_1 - 0.00063492063492063*G0_0_1_5_1_2 + 0.00296296296296295*G0_0_1_5_1_3 + 0.00042328042328042*G0_0_1_5_1_4 + 0.00550264550264546*G0_0_1_5_1_5 + 0.00021164021164021*G0_0_1_5_2_0 - 0.00063492063492063*G0_0_1_5_2_1 - 0.000423280423280425*G0_0_1_5_2_2 - 0.000846560846560844*G0_0_1_5_2_3 - 0.000423280423280424*G0_0_1_5_2_4 + 0.00211640211640211*G0_0_1_5_2_5 - 0.000423280423280419*G0_0_1_5_3_0 + 0.00296296296296295*G0_0_1_5_3_1 - 0.000846560846560845*G0_0_1_5_3_2 + 0.00169312169312168*G0_0_1_5_3_3 - 0.00338624338624337*G0_0_1_5_3_5 + 0.00042328042328042*G0_0_1_5_4_1 - 0.000423280423280424*G0_0_1_5_4_2 + 0.00507936507936506*G0_0_1_5_4_4 - 0.00507936507936505*G0_0_1_5_4_5 - 0.0042328042328042*G0_0_1_5_5_0 + 0.00550264550264546*G0_0_1_5_5_1 + 0.0021164021164021*G0_0_1_5_5_2 - 0.00338624338624337*G0_0_1_5_5_3 - 0.00507936507936505*G0_0_1_5_5_4 - 0.0457142857142855*G0_0_1_5_5_5 - 0.000529100529100525*G0_1_0_0_0_1 + 0.000529100529100526*G0_1_0_0_0_2 - 0.0021164021164021*G0_1_0_0_0_4 + 0.00211640211640211*G0_1_0_0_0_5 - 0.000529100529100525*G0_1_0_0_1_0 + 0.00126984126984126*G0_1_0_0_1_1 + 0.00084656084656084*G0_1_0_0_1_3 + 0.000211640211640211*G0_1_0_0_1_4 - 0.000211640211640211*G0_1_0_0_1_5 + 0.000529100529100526*G0_1_0_0_2_0 - 0.00126984126984126*G0_1_0_0_2_2 - 0.000846560846560839*G0_1_0_0_2_3 + 0.000211640211640213*G0_1_0_0_2_4 - 0.00021164021164021*G0_1_0_0_2_5 + 0.00084656084656084*G0_1_0_0_3_1 - 0.000846560846560839*G0_1_0_0_3_2 - 0.000423280423280421*G0_1_0_0_3_4 + 0.000423280423280419*G0_1_0_0_3_5 - 0.0021164021164021*G0_1_0_0_4_0 + 0.000211640211640211*G0_1_0_0_4_1 + 0.000211640211640213*G0_1_0_0_4_2 - 0.000423280423280421*G0_1_0_0_4_3 - 0.00423280423280421*G0_1_0_0_4_4 + 0.00211640211640211*G0_1_0_0_5_0 - 0.000211640211640211*G0_1_0_0_5_1 - 0.00021164021164021*G0_1_0_0_5_2 + 0.000423280423280419*G0_1_0_0_5_3 + 0.0042328042328042*G0_1_0_0_5_5 - 0.000529100529100525*G0_1_0_1_0_0 + 0.00126984126984126*G0_1_0_1_0_1 + 0.00084656084656084*G0_1_0_1_0_3 + 0.000211640211640211*G0_1_0_1_0_4 - 0.000211640211640211*G0_1_0_1_0_5 + 0.00126984126984126*G0_1_0_1_1_0 - 0.0174603174603173*G0_1_0_1_1_1 + 0.00179894179894179*G0_1_0_1_1_2 - 0.00634920634920631*G0_1_0_1_1_3 - 0.000423280423280422*G0_1_0_1_1_4 - 0.00423280423280421*G0_1_0_1_1_5 + 0.00179894179894179*G0_1_0_1_2_1 - 0.00179894179894179*G0_1_0_1_2_2 - 0.000634920634920631*G0_1_0_1_2_4 + 0.00063492063492063*G0_1_0_1_2_5 + 0.00084656084656084*G0_1_0_1_3_0 - 0.00634920634920631*G0_1_0_1_3_1 - 0.00973544973544968*G0_1_0_1_3_3 - 0.000846560846560842*G0_1_0_1_3_4 - 0.00296296296296295*G0_1_0_1_3_5 + 0.000211640211640211*G0_1_0_1_4_0 - 0.000423280423280422*G0_1_0_1_4_1 - 0.000634920634920631*G0_1_0_1_4_2 - 0.000846560846560842*G0_1_0_1_4_3 + 0.00211640211640211*G0_1_0_1_4_4 - 0.00042328042328042*G0_1_0_1_4_5 - 0.000211640211640211*G0_1_0_1_5_0 - 0.00423280423280421*G0_1_0_1_5_1 + 0.00063492063492063*G0_1_0_1_5_2 - 0.00296296296296295*G0_1_0_1_5_3 - 0.00042328042328042*G0_1_0_1_5_4 - 0.00550264550264546*G0_1_0_1_5_5 + 0.000529100529100526*G0_1_0_2_0_0 - 0.00126984126984126*G0_1_0_2_0_2 - 0.000846560846560839*G0_1_0_2_0_3 + 0.000211640211640213*G0_1_0_2_0_4 - 0.00021164021164021*G0_1_0_2_0_5 + 0.00179894179894179*G0_1_0_2_1_1 - 0.00179894179894179*G0_1_0_2_1_2 - 0.000634920634920631*G0_1_0_2_1_4 + 0.00063492063492063*G0_1_0_2_1_5 - 0.00126984126984126*G0_1_0_2_2_0 - 0.00179894179894179*G0_1_0_2_2_1 + 0.0174603174603174*G0_1_0_2_2_2 + 0.00634920634920631*G0_1_0_2_2_3 + 0.0042328042328042*G0_1_0_2_2_4 + 0.000423280423280425*G0_1_0_2_2_5 - 0.000846560846560839*G0_1_0_2_3_0 + 0.00634920634920631*G0_1_0_2_3_2 + 0.00973544973544968*G0_1_0_2_3_3 + 0.00296296296296294*G0_1_0_2_3_4 + 0.000846560846560845*G0_1_0_2_3_5 + 0.000211640211640213*G0_1_0_2_4_0 - 0.000634920634920631*G0_1_0_2_4_1 + 0.0042328042328042*G0_1_0_2_4_2 + 0.00296296296296295*G0_1_0_2_4_3 + 0.00550264550264547*G0_1_0_2_4_4 + 0.000423280423280424*G0_1_0_2_4_5 - 0.00021164021164021*G0_1_0_2_5_0 + 0.00063492063492063*G0_1_0_2_5_1 + 0.000423280423280425*G0_1_0_2_5_2 + 0.000846560846560845*G0_1_0_2_5_3 + 0.000423280423280424*G0_1_0_2_5_4 - 0.0021164021164021*G0_1_0_2_5_5 + 0.00084656084656084*G0_1_0_3_0_1 - 0.000846560846560839*G0_1_0_3_0_2 - 0.000423280423280421*G0_1_0_3_0_4 + 0.000423280423280419*G0_1_0_3_0_5 + 0.00084656084656084*G0_1_0_3_1_0 - 0.00634920634920631*G0_1_0_3_1_1 - 0.00973544973544968*G0_1_0_3_1_3 - 0.000846560846560842*G0_1_0_3_1_4 - 0.00296296296296295*G0_1_0_3_1_5 - 0.00084656084656084*G0_1_0_3_2_0 + 0.00634920634920631*G0_1_0_3_2_2 + 0.00973544973544968*G0_1_0_3_2_3 + 0.00296296296296294*G0_1_0_3_2_4 + 0.000846560846560845*G0_1_0_3_2_5 - 0.00973544973544968*G0_1_0_3_3_1 + 0.00973544973544967*G0_1_0_3_3_2 + 0.00169312169312169*G0_1_0_3_3_4 - 0.00169312169312168*G0_1_0_3_3_5 - 0.000423280423280421*G0_1_0_3_4_0 - 0.000846560846560842*G0_1_0_3_4_1 + 0.00296296296296295*G0_1_0_3_4_2 + 0.00169312169312168*G0_1_0_3_4_3 - 0.00338624338624337*G0_1_0_3_4_4 + 0.00042328042328042*G0_1_0_3_5_0 - 0.00296296296296295*G0_1_0_3_5_1 + 0.000846560846560845*G0_1_0_3_5_2 - 0.00169312169312168*G0_1_0_3_5_3 + 0.00338624338624337*G0_1_0_3_5_5 - 0.0021164021164021*G0_1_0_4_0_0 + 0.000211640211640211*G0_1_0_4_0_1 + 0.000211640211640213*G0_1_0_4_0_2 - 0.000423280423280421*G0_1_0_4_0_3 - 0.00423280423280421*G0_1_0_4_0_4 + 0.000211640211640211*G0_1_0_4_1_0 - 0.000423280423280422*G0_1_0_4_1_1 - 0.000634920634920631*G0_1_0_4_1_2 - 0.000846560846560842*G0_1_0_4_1_3 + 0.00211640211640211*G0_1_0_4_1_4 - 0.00042328042328042*G0_1_0_4_1_5 + 0.000211640211640213*G0_1_0_4_2_0 - 0.000634920634920631*G0_1_0_4_2_1 + 0.0042328042328042*G0_1_0_4_2_2 + 0.00296296296296294*G0_1_0_4_2_3 + 0.00550264550264547*G0_1_0_4_2_4 + 0.000423280423280424*G0_1_0_4_2_5 - 0.000423280423280421*G0_1_0_4_3_0 - 0.000846560846560842*G0_1_0_4_3_1 + 0.00296296296296295*G0_1_0_4_3_2 + 0.00169312169312169*G0_1_0_4_3_3 - 0.00338624338624337*G0_1_0_4_3_4 - 0.00423280423280421*G0_1_0_4_4_0 + 0.00211640211640211*G0_1_0_4_4_1 + 0.00550264550264547*G0_1_0_4_4_2 - 0.00338624338624337*G0_1_0_4_4_3 - 0.0457142857142855*G0_1_0_4_4_4 - 0.00507936507936506*G0_1_0_4_4_5 - 0.00042328042328042*G0_1_0_4_5_1 + 0.000423280423280424*G0_1_0_4_5_2 - 0.00507936507936506*G0_1_0_4_5_4 + 0.00507936507936505*G0_1_0_4_5_5 + 0.00211640211640211*G0_1_0_5_0_0 - 0.000211640211640211*G0_1_0_5_0_1 - 0.00021164021164021*G0_1_0_5_0_2 + 0.000423280423280419*G0_1_0_5_0_3 + 0.0042328042328042*G0_1_0_5_0_5 - 0.000211640211640212*G0_1_0_5_1_0 - 0.00423280423280421*G0_1_0_5_1_1 + 0.000634920634920631*G0_1_0_5_1_2 - 0.00296296296296295*G0_1_0_5_1_3 - 0.00042328042328042*G0_1_0_5_1_4 - 0.00550264550264546*G0_1_0_5_1_5 - 0.00021164021164021*G0_1_0_5_2_0 + 0.000634920634920631*G0_1_0_5_2_1 + 0.000423280423280425*G0_1_0_5_2_2 + 0.000846560846560845*G0_1_0_5_2_3 + 0.000423280423280424*G0_1_0_5_2_4 - 0.00211640211640211*G0_1_0_5_2_5 + 0.000423280423280419*G0_1_0_5_3_0 - 0.00296296296296295*G0_1_0_5_3_1 + 0.000846560846560845*G0_1_0_5_3_2 - 0.00169312169312168*G0_1_0_5_3_3 + 0.00338624338624337*G0_1_0_5_3_5 - 0.00042328042328042*G0_1_0_5_4_1 + 0.000423280423280424*G0_1_0_5_4_2 - 0.00507936507936506*G0_1_0_5_4_4 + 0.00507936507936505*G0_1_0_5_4_5 + 0.0042328042328042*G0_1_0_5_5_0 - 0.00550264550264546*G0_1_0_5_5_1 - 0.0021164021164021*G0_1_0_5_5_2 + 0.00338624338624337*G0_1_0_5_5_3 + 0.00507936507936505*G0_1_0_5_5_4 + 0.0457142857142855*G0_1_0_5_5_5;
    A[24] = -A[18] - 0.0634920634920632*G0_1_0_0_0_0 + 0.00634920634920632*G0_1_0_0_0_1 + 0.00529100529100527*G0_1_0_0_0_2 - 0.00211640211640211*G0_1_0_0_0_3 - 0.0232804232804232*G0_1_0_0_0_4 - 0.0275132275132274*G0_1_0_0_0_5 + 0.00634920634920632*G0_1_0_0_1_0 - 0.00253968253968252*G0_1_0_0_1_1 - 0.000740740740740737*G0_1_0_0_1_2 - 0.000423280423280419*G0_1_0_0_1_3 + 0.00296296296296295*G0_1_0_0_1_4 + 0.00550264550264547*G0_1_0_0_1_5 + 0.00529100529100527*G0_1_0_0_2_0 - 0.000740740740740737*G0_1_0_0_2_1 + 0.00126984126984126*G0_1_0_0_2_3 + 0.00507936507936506*G0_1_0_0_2_4 + 0.00338624338624337*G0_1_0_0_2_5 - 0.00211640211640211*G0_1_0_0_3_0 - 0.000423280423280419*G0_1_0_0_3_1 + 0.00126984126984126*G0_1_0_0_3_2 - 0.000846560846560841*G0_1_0_0_3_3 - 0.00169312169312169*G0_1_0_0_3_4 - 0.00253968253968253*G0_1_0_0_3_5 - 0.0232804232804232*G0_1_0_0_4_0 + 0.00296296296296295*G0_1_0_0_4_1 + 0.00507936507936506*G0_1_0_0_4_2 - 0.00169312169312169*G0_1_0_0_4_3 - 0.0211640211640211*G0_1_0_0_4_4 - 0.0126984126984126*G0_1_0_0_4_5 - 0.0275132275132274*G0_1_0_0_5_0 + 0.00550264550264547*G0_1_0_0_5_1 + 0.00338624338624337*G0_1_0_0_5_2 - 0.00253968253968253*G0_1_0_0_5_3 - 0.0126984126984126*G0_1_0_0_5_4 - 0.0296296296296295*G0_1_0_0_5_5 + 0.00634920634920632*G0_1_0_1_0_0 - 0.00253968253968252*G0_1_0_1_0_1 - 0.000740740740740737*G0_1_0_1_0_2 - 0.000423280423280419*G0_1_0_1_0_3 + 0.00296296296296295*G0_1_0_1_0_4 + 0.00550264550264547*G0_1_0_1_0_5 - 0.00253968253968252*G0_1_0_1_1_0 + 0.0190476190476189*G0_1_0_1_1_1 - 0.00148148148148147*G0_1_0_1_1_2 + 0.00634920634920631*G0_1_0_1_1_3 - 0.00126984126984126*G0_1_0_1_1_4 + 0.0021164021164021*G0_1_0_1_1_5 - 0.000740740740740737*G0_1_0_1_2_0 - 0.00148148148148147*G0_1_0_1_2_1 + 0.00211640211640211*G0_1_0_1_2_2 - 0.000846560846560843*G0_1_0_1_2_3 - 0.00126984126984126*G0_1_0_1_2_4 - 0.00253968253968253*G0_1_0_1_2_5 - 0.000423280423280419*G0_1_0_1_3_0 + 0.00634920634920631*G0_1_0_1_3_1 - 0.000846560846560843*G0_1_0_1_3_2 + 0.011005291005291*G0_1_0_1_3_3 + 0.00338624338624337*G0_1_0_1_3_4 + 0.0059259259259259*G0_1_0_1_3_5 + 0.00296296296296295*G0_1_0_1_4_0 - 0.00126984126984126*G0_1_0_1_4_1 - 0.00126984126984126*G0_1_0_1_4_2 + 0.00338624338624337*G0_1_0_1_4_3 + 0.00761904761904758*G0_1_0_1_4_4 + 0.00761904761904758*G0_1_0_1_4_5 + 0.00550264550264547*G0_1_0_1_5_0 + 0.0021164021164021*G0_1_0_1_5_1 - 0.00253968253968253*G0_1_0_1_5_2 + 0.0059259259259259*G0_1_0_1_5_3 + 0.00761904761904758*G0_1_0_1_5_4 + 0.0194708994708993*G0_1_0_1_5_5 + 0.00529100529100527*G0_1_0_2_0_0 - 0.000740740740740737*G0_1_0_2_0_1 + 0.00126984126984126*G0_1_0_2_0_3 + 0.00507936507936506*G0_1_0_2_0_4 + 0.00338624338624337*G0_1_0_2_0_5 - 0.000740740740740737*G0_1_0_2_1_0 - 0.00148148148148147*G0_1_0_2_1_1 + 0.00211640211640211*G0_1_0_2_1_2 - 0.000846560846560843*G0_1_0_2_1_3 - 0.00126984126984126*G0_1_0_2_1_4 - 0.00253968253968253*G0_1_0_2_1_5 + 0.00211640211640211*G0_1_0_2_2_1 - 0.0158730158730158*G0_1_0_2_2_2 - 0.00634920634920632*G0_1_0_2_2_3 - 0.00634920634920632*G0_1_0_2_2_4 - 0.00211640211640211*G0_1_0_2_2_5 + 0.00126984126984126*G0_1_0_2_3_0 - 0.000846560846560843*G0_1_0_2_3_1 - 0.00634920634920632*G0_1_0_2_3_2 - 0.00846560846560842*G0_1_0_2_3_3 + 0.00169312169312168*G0_1_0_2_3_5 + 0.00507936507936506*G0_1_0_2_4_0 - 0.00126984126984126*G0_1_0_2_4_1 - 0.00634920634920632*G0_1_0_2_4_2 + 0.00846560846560843*G0_1_0_2_4_4 + 0.00677248677248674*G0_1_0_2_4_5 + 0.00338624338624337*G0_1_0_2_5_0 - 0.00253968253968253*G0_1_0_2_5_1 - 0.00211640211640211*G0_1_0_2_5_2 + 0.00169312169312168*G0_1_0_2_5_3 + 0.00677248677248674*G0_1_0_2_5_4 + 0.0118518518518518*G0_1_0_2_5_5 - 0.00211640211640211*G0_1_0_3_0_0 - 0.000423280423280418*G0_1_0_3_0_1 + 0.00126984126984126*G0_1_0_3_0_2 - 0.000846560846560841*G0_1_0_3_0_3 - 0.00169312169312169*G0_1_0_3_0_4 - 0.00253968253968253*G0_1_0_3_0_5 - 0.000423280423280419*G0_1_0_3_1_0 + 0.00634920634920631*G0_1_0_3_1_1 - 0.000846560846560843*G0_1_0_3_1_2 + 0.011005291005291*G0_1_0_3_1_3 + 0.00338624338624337*G0_1_0_3_1_4 + 0.0059259259259259*G0_1_0_3_1_5 + 0.00126984126984126*G0_1_0_3_2_0 - 0.000846560846560843*G0_1_0_3_2_1 - 0.00634920634920632*G0_1_0_3_2_2 - 0.00846560846560842*G0_1_0_3_2_3 + 0.00169312169312168*G0_1_0_3_2_5 - 0.000846560846560842*G0_1_0_3_3_0 + 0.011005291005291*G0_1_0_3_3_1 - 0.00846560846560842*G0_1_0_3_3_2 + 0.00507936507936507*G0_1_0_3_3_3 - 0.00507936507936506*G0_1_0_3_3_4 - 0.00169312169312168*G0_1_0_3_3_5 - 0.00169312169312169*G0_1_0_3_4_0 + 0.00338624338624337*G0_1_0_3_4_1 - 0.00507936507936506*G0_1_0_3_4_3 - 0.0118518518518518*G0_1_0_3_4_4 - 0.0101587301587301*G0_1_0_3_4_5 - 0.00253968253968253*G0_1_0_3_5_0 + 0.0059259259259259*G0_1_0_3_5_1 + 0.00169312169312168*G0_1_0_3_5_2 - 0.00169312169312168*G0_1_0_3_5_3 - 0.0101587301587301*G0_1_0_3_5_4 - 0.0186243386243385*G0_1_0_3_5_5 - 0.0232804232804232*G0_1_0_4_0_0 + 0.00296296296296295*G0_1_0_4_0_1 + 0.00507936507936506*G0_1_0_4_0_2 - 0.00169312169312169*G0_1_0_4_0_3 - 0.0211640211640211*G0_1_0_4_0_4 - 0.0126984126984126*G0_1_0_4_0_5 + 0.00296296296296295*G0_1_0_4_1_0 - 0.00126984126984126*G0_1_0_4_1_1 - 0.00126984126984126*G0_1_0_4_1_2 + 0.00338624338624337*G0_1_0_4_1_3 + 0.00761904761904758*G0_1_0_4_1_4 + 0.00761904761904758*G0_1_0_4_1_5 + 0.00507936507936506*G0_1_0_4_2_0 - 0.00126984126984126*G0_1_0_4_2_1 - 0.00634920634920632*G0_1_0_4_2_2 + 0.00846560846560843*G0_1_0_4_2_4 + 0.00677248677248674*G0_1_0_4_2_5 - 0.00169312169312169*G0_1_0_4_3_0 + 0.00338624338624337*G0_1_0_4_3_1 - 0.00507936507936506*G0_1_0_4_3_3 - 0.0118518518518518*G0_1_0_4_3_4 - 0.0101587301587301*G0_1_0_4_3_5 - 0.0211640211640211*G0_1_0_4_4_0 + 0.00761904761904758*G0_1_0_4_4_1 + 0.00846560846560843*G0_1_0_4_4_2 - 0.0118518518518518*G0_1_0_4_4_3 - 0.0558730158730156*G0_1_0_4_4_4 - 0.0287830687830687*G0_1_0_4_4_5 - 0.0126984126984126*G0_1_0_4_5_0 + 0.00761904761904758*G0_1_0_4_5_1 + 0.00677248677248674*G0_1_0_4_5_2 - 0.0101587301587301*G0_1_0_4_5_3 - 0.0287830687830687*G0_1_0_4_5_4 - 0.0389417989417987*G0_1_0_4_5_5 - 0.0275132275132274*G0_1_0_5_0_0 + 0.00550264550264547*G0_1_0_5_0_1 + 0.00338624338624337*G0_1_0_5_0_2 - 0.00253968253968253*G0_1_0_5_0_3 - 0.0126984126984126*G0_1_0_5_0_4 - 0.0296296296296295*G0_1_0_5_0_5 + 0.00550264550264548*G0_1_0_5_1_0 + 0.0021164021164021*G0_1_0_5_1_1 - 0.00253968253968253*G0_1_0_5_1_2 + 0.0059259259259259*G0_1_0_5_1_3 + 0.00761904761904758*G0_1_0_5_1_4 + 0.0194708994708993*G0_1_0_5_1_5 + 0.00338624338624337*G0_1_0_5_2_0 - 0.00253968253968253*G0_1_0_5_2_1 - 0.00211640211640211*G0_1_0_5_2_2 + 0.00169312169312168*G0_1_0_5_2_3 + 0.00677248677248674*G0_1_0_5_2_4 + 0.0118518518518518*G0_1_0_5_2_5 - 0.00253968253968253*G0_1_0_5_3_0 + 0.0059259259259259*G0_1_0_5_3_1 + 0.00169312169312168*G0_1_0_5_3_2 - 0.00169312169312168*G0_1_0_5_3_3 - 0.0101587301587301*G0_1_0_5_3_4 - 0.0186243386243385*G0_1_0_5_3_5 - 0.0126984126984126*G0_1_0_5_4_0 + 0.00761904761904758*G0_1_0_5_4_1 + 0.00677248677248674*G0_1_0_5_4_2 - 0.0101587301587301*G0_1_0_5_4_3 - 0.0287830687830687*G0_1_0_5_4_4 - 0.0389417989417987*G0_1_0_5_4_5 - 0.0296296296296295*G0_1_0_5_5_0 + 0.0194708994708993*G0_1_0_5_5_1 + 0.0118518518518518*G0_1_0_5_5_2 - 0.0186243386243385*G0_1_0_5_5_3 - 0.0389417989417987*G0_1_0_5_5_4 - 0.147301587301586*G0_1_0_5_5_5 - 0.0634920634920632*G0_1_1_0_0_0 + 0.00634920634920631*G0_1_1_0_0_1 + 0.00529100529100526*G0_1_1_0_0_2 - 0.00211640211640211*G0_1_1_0_0_3 - 0.0232804232804232*G0_1_1_0_0_4 - 0.0275132275132274*G0_1_1_0_0_5 + 0.00634920634920632*G0_1_1_0_1_0 - 0.00253968253968252*G0_1_1_0_1_1 - 0.000740740740740737*G0_1_1_0_1_2 - 0.000423280423280419*G0_1_1_0_1_3 + 0.00296296296296295*G0_1_1_0_1_4 + 0.00550264550264547*G0_1_1_0_1_5 + 0.00529100529100527*G0_1_1_0_2_0 - 0.000740740740740737*G0_1_1_0_2_1 + 0.00126984126984126*G0_1_1_0_2_3 + 0.00507936507936506*G0_1_1_0_2_4 + 0.00338624338624337*G0_1_1_0_2_5 - 0.00211640211640211*G0_1_1_0_3_0 - 0.000423280423280419*G0_1_1_0_3_1 + 0.00126984126984126*G0_1_1_0_3_2 - 0.000846560846560842*G0_1_1_0_3_3 - 0.00169312169312169*G0_1_1_0_3_4 - 0.00253968253968253*G0_1_1_0_3_5 - 0.0232804232804232*G0_1_1_0_4_0 + 0.00296296296296295*G0_1_1_0_4_1 + 0.00507936507936506*G0_1_1_0_4_2 - 0.00169312169312169*G0_1_1_0_4_3 - 0.0211640211640211*G0_1_1_0_4_4 - 0.0126984126984126*G0_1_1_0_4_5 - 0.0275132275132274*G0_1_1_0_5_0 + 0.00550264550264547*G0_1_1_0_5_1 + 0.00338624338624337*G0_1_1_0_5_2 - 0.00253968253968253*G0_1_1_0_5_3 - 0.0126984126984126*G0_1_1_0_5_4 - 0.0296296296296295*G0_1_1_0_5_5 + 0.00634920634920631*G0_1_1_1_0_0 - 0.00253968253968252*G0_1_1_1_0_1 - 0.000740740740740737*G0_1_1_1_0_2 - 0.000423280423280419*G0_1_1_1_0_3 + 0.00296296296296295*G0_1_1_1_0_4 + 0.00550264550264547*G0_1_1_1_0_5 - 0.00253968253968252*G0_1_1_1_1_0 + 0.019047619047619*G0_1_1_1_1_1 - 0.00148148148148147*G0_1_1_1_1_2 + 0.00634920634920632*G0_1_1_1_1_3 - 0.00126984126984126*G0_1_1_1_1_4 + 0.00211640211640211*G0_1_1_1_1_5 - 0.000740740740740737*G0_1_1_1_2_0 - 0.00148148148148147*G0_1_1_1_2_1 + 0.0021164021164021*G0_1_1_1_2_2 - 0.000846560846560845*G0_1_1_1_2_3 - 0.00126984126984127*G0_1_1_1_2_4 - 0.00253968253968253*G0_1_1_1_2_5 - 0.000423280423280419*G0_1_1_1_3_0 + 0.00634920634920632*G0_1_1_1_3_1 - 0.000846560846560845*G0_1_1_1_3_2 + 0.011005291005291*G0_1_1_1_3_3 + 0.00338624338624337*G0_1_1_1_3_4 + 0.0059259259259259*G0_1_1_1_3_5 + 0.00296296296296295*G0_1_1_1_4_0 - 0.00126984126984126*G0_1_1_1_4_1 - 0.00126984126984127*G0_1_1_1_4_2 + 0.00338624338624337*G0_1_1_1_4_3 + 0.00761904761904759*G0_1_1_1_4_4 + 0.00761904761904758*G0_1_1_1_4_5 + 0.00550264550264547*G0_1_1_1_5_0 + 0.00211640211640211*G0_1_1_1_5_1 - 0.00253968253968253*G0_1_1_1_5_2 + 0.0059259259259259*G0_1_1_1_5_3 + 0.00761904761904758*G0_1_1_1_5_4 + 0.0194708994708994*G0_1_1_1_5_5 + 0.00529100529100527*G0_1_1_2_0_0 - 0.000740740740740737*G0_1_1_2_0_1 + 0.00126984126984126*G0_1_1_2_0_3 + 0.00507936507936506*G0_1_1_2_0_4 + 0.00338624338624337*G0_1_1_2_0_5 - 0.000740740740740737*G0_1_1_2_1_0 - 0.00148148148148147*G0_1_1_2_1_1 + 0.0021164021164021*G0_1_1_2_1_2 - 0.000846560846560846*G0_1_1_2_1_3 - 0.00126984126984127*G0_1_1_2_1_4 - 0.00253968253968253*G0_1_1_2_1_5 + 0.0021164021164021*G0_1_1_2_2_1 - 0.0158730158730158*G0_1_1_2_2_2 - 0.00634920634920631*G0_1_1_2_2_3 - 0.00634920634920631*G0_1_1_2_2_4 - 0.00211640211640211*G0_1_1_2_2_5 + 0.00126984126984126*G0_1_1_2_3_0 - 0.000846560846560845*G0_1_1_2_3_1 - 0.00634920634920631*G0_1_1_2_3_2 - 0.00846560846560842*G0_1_1_2_3_3 + 0.00169312169312168*G0_1_1_2_3_5 + 0.00507936507936506*G0_1_1_2_4_0 - 0.00126984126984127*G0_1_1_2_4_1 - 0.00634920634920631*G0_1_1_2_4_2 + 0.00846560846560843*G0_1_1_2_4_4 + 0.00677248677248674*G0_1_1_2_4_5 + 0.00338624338624337*G0_1_1_2_5_0 - 0.00253968253968253*G0_1_1_2_5_1 - 0.00211640211640211*G0_1_1_2_5_2 + 0.00169312169312168*G0_1_1_2_5_3 + 0.00677248677248674*G0_1_1_2_5_4 + 0.0118518518518518*G0_1_1_2_5_5 - 0.00211640211640211*G0_1_1_3_0_0 - 0.000423280423280419*G0_1_1_3_0_1 + 0.00126984126984126*G0_1_1_3_0_2 - 0.000846560846560843*G0_1_1_3_0_3 - 0.00169312169312169*G0_1_1_3_0_4 - 0.00253968253968253*G0_1_1_3_0_5 - 0.000423280423280419*G0_1_1_3_1_0 + 0.00634920634920632*G0_1_1_3_1_1 - 0.000846560846560845*G0_1_1_3_1_2 + 0.011005291005291*G0_1_1_3_1_3 + 0.00338624338624337*G0_1_1_3_1_4 + 0.0059259259259259*G0_1_1_3_1_5 + 0.00126984126984126*G0_1_1_3_2_0 - 0.000846560846560845*G0_1_1_3_2_1 - 0.00634920634920631*G0_1_1_3_2_2 - 0.00846560846560842*G0_1_1_3_2_3 + 0.00169312169312168*G0_1_1_3_2_5 - 0.000846560846560842*G0_1_1_3_3_0 + 0.011005291005291*G0_1_1_3_3_1 - 0.00846560846560842*G0_1_1_3_3_2 + 0.00507936507936508*G0_1_1_3_3_3 - 0.00507936507936505*G0_1_1_3_3_4 - 0.00169312169312168*G0_1_1_3_3_5 - 0.00169312169312169*G0_1_1_3_4_0 + 0.00338624338624337*G0_1_1_3_4_1 - 0.00507936507936505*G0_1_1_3_4_3 - 0.0118518518518518*G0_1_1_3_4_4 - 0.0101587301587301*G0_1_1_3_4_5 - 0.00253968253968253*G0_1_1_3_5_0 + 0.0059259259259259*G0_1_1_3_5_1 + 0.00169312169312168*G0_1_1_3_5_2 - 0.00169312169312168*G0_1_1_3_5_3 - 0.0101587301587301*G0_1_1_3_5_4 - 0.0186243386243385*G0_1_1_3_5_5 - 0.0232804232804232*G0_1_1_4_0_0 + 0.00296296296296295*G0_1_1_4_0_1 + 0.00507936507936506*G0_1_1_4_0_2 - 0.00169312169312169*G0_1_1_4_0_3 - 0.0211640211640211*G0_1_1_4_0_4 - 0.0126984126984126*G0_1_1_4_0_5 + 0.00296296296296295*G0_1_1_4_1_0 - 0.00126984126984126*G0_1_1_4_1_1 - 0.00126984126984127*G0_1_1_4_1_2 + 0.00338624338624337*G0_1_1_4_1_3 + 0.00761904761904759*G0_1_1_4_1_4 + 0.00761904761904758*G0_1_1_4_1_5 + 0.00507936507936506*G0_1_1_4_2_0 - 0.00126984126984127*G0_1_1_4_2_1 - 0.00634920634920631*G0_1_1_4_2_2 + 0.00846560846560844*G0_1_1_4_2_4 + 0.00677248677248674*G0_1_1_4_2_5 - 0.00169312169312169*G0_1_1_4_3_0 + 0.00338624338624337*G0_1_1_4_3_1 - 0.00507936507936505*G0_1_1_4_3_3 - 0.0118518518518518*G0_1_1_4_3_4 - 0.0101587301587301*G0_1_1_4_3_5 - 0.0211640211640211*G0_1_1_4_4_0 + 0.00761904761904759*G0_1_1_4_4_1 + 0.00846560846560844*G0_1_1_4_4_2 - 0.0118518518518518*G0_1_1_4_4_3 - 0.0558730158730156*G0_1_1_4_4_4 - 0.0287830687830687*G0_1_1_4_4_5 - 0.0126984126984126*G0_1_1_4_5_0 + 0.00761904761904758*G0_1_1_4_5_1 + 0.00677248677248674*G0_1_1_4_5_2 - 0.0101587301587301*G0_1_1_4_5_3 - 0.0287830687830687*G0_1_1_4_5_4 - 0.0389417989417987*G0_1_1_4_5_5 - 0.0275132275132274*G0_1_1_5_0_0 + 0.00550264550264547*G0_1_1_5_0_1 + 0.00338624338624337*G0_1_1_5_0_2 - 0.00253968253968253*G0_1_1_5_0_3 - 0.0126984126984126*G0_1_1_5_0_4 - 0.0296296296296295*G0_1_1_5_0_5 + 0.00550264550264547*G0_1_1_5_1_0 + 0.00211640211640211*G0_1_1_5_1_1 - 0.00253968253968253*G0_1_1_5_1_2 + 0.0059259259259259*G0_1_1_5_1_3 + 0.00761904761904758*G0_1_1_5_1_4 + 0.0194708994708994*G0_1_1_5_1_5 + 0.00338624338624337*G0_1_1_5_2_0 - 0.00253968253968253*G0_1_1_5_2_1 - 0.00211640211640211*G0_1_1_5_2_2 + 0.00169312169312168*G0_1_1_5_2_3 + 0.00677248677248674*G0_1_1_5_2_4 + 0.0118518518518518*G0_1_1_5_2_5 - 0.00253968253968253*G0_1_1_5_3_0 + 0.0059259259259259*G0_1_1_5_3_1 + 0.00169312169312168*G0_1_1_5_3_2 - 0.00169312169312168*G0_1_1_5_3_3 - 0.0101587301587301*G0_1_1_5_3_4 - 0.0186243386243385*G0_1_1_5_3_5 - 0.0126984126984126*G0_1_1_5_4_0 + 0.00761904761904758*G0_1_1_5_4_1 + 0.00677248677248674*G0_1_1_5_4_2 - 0.0101587301587301*G0_1_1_5_4_3 - 0.0287830687830687*G0_1_1_5_4_4 - 0.0389417989417987*G0_1_1_5_4_5 - 0.0296296296296295*G0_1_1_5_5_0 + 0.0194708994708994*G0_1_1_5_5_1 + 0.0118518518518518*G0_1_1_5_5_2 - 0.0186243386243385*G0_1_1_5_5_3 - 0.0389417989417987*G0_1_1_5_5_4 - 0.147301587301586*G0_1_1_5_5_5;
    A[30] = -A[18] - 0.0634920634920632*G0_0_0_0_0_0 + 0.00529100529100527*G0_0_0_0_0_1 + 0.00634920634920632*G0_0_0_0_0_2 - 0.00211640211640211*G0_0_0_0_0_3 - 0.0275132275132274*G0_0_0_0_0_4 - 0.0232804232804232*G0_0_0_0_0_5 + 0.00529100529100527*G0_0_0_0_1_0 - 0.000740740740740738*G0_0_0_0_1_2 + 0.00126984126984126*G0_0_0_0_1_3 + 0.00338624338624337*G0_0_0_0_1_4 + 0.00507936507936505*G0_0_0_0_1_5 + 0.00634920634920632*G0_0_0_0_2_0 - 0.000740740740740738*G0_0_0_0_2_1 - 0.00253968253968253*G0_0_0_0_2_2 - 0.000423280423280418*G0_0_0_0_2_3 + 0.00550264550264548*G0_0_0_0_2_4 + 0.00296296296296295*G0_0_0_0_2_5 - 0.00211640211640211*G0_0_0_0_3_0 + 0.00126984126984126*G0_0_0_0_3_1 - 0.000423280423280418*G0_0_0_0_3_2 - 0.000846560846560845*G0_0_0_0_3_3 - 0.00253968253968253*G0_0_0_0_3_4 - 0.00169312169312169*G0_0_0_0_3_5 - 0.0275132275132274*G0_0_0_0_4_0 + 0.00338624338624337*G0_0_0_0_4_1 + 0.00550264550264548*G0_0_0_0_4_2 - 0.00253968253968253*G0_0_0_0_4_3 - 0.0296296296296295*G0_0_0_0_4_4 - 0.0126984126984126*G0_0_0_0_4_5 - 0.0232804232804232*G0_0_0_0_5_0 + 0.00507936507936505*G0_0_0_0_5_1 + 0.00296296296296295*G0_0_0_0_5_2 - 0.00169312169312169*G0_0_0_0_5_3 - 0.0126984126984126*G0_0_0_0_5_4 - 0.0211640211640211*G0_0_0_0_5_5 + 0.00529100529100527*G0_0_0_1_0_0 - 0.000740740740740738*G0_0_0_1_0_2 + 0.00126984126984126*G0_0_0_1_0_3 + 0.00338624338624337*G0_0_0_1_0_4 + 0.00507936507936505*G0_0_0_1_0_5 - 0.0158730158730158*G0_0_0_1_1_1 + 0.0021164021164021*G0_0_0_1_1_2 - 0.00634920634920631*G0_0_0_1_1_3 - 0.00211640211640211*G0_0_0_1_1_4 - 0.00634920634920631*G0_0_0_1_1_5 - 0.000740740740740738*G0_0_0_1_2_0 + 0.0021164021164021*G0_0_0_1_2_1 - 0.00148148148148147*G0_0_0_1_2_2 - 0.000846560846560841*G0_0_0_1_2_3 - 0.00253968253968253*G0_0_0_1_2_4 - 0.00126984126984126*G0_0_0_1_2_5 + 0.00126984126984126*G0_0_0_1_3_0 - 0.00634920634920631*G0_0_0_1_3_1 - 0.000846560846560842*G0_0_0_1_3_2 - 0.00846560846560842*G0_0_0_1_3_3 + 0.00169312169312168*G0_0_0_1_3_4 + 0.00338624338624337*G0_0_0_1_4_0 - 0.00211640211640211*G0_0_0_1_4_1 - 0.00253968253968253*G0_0_0_1_4_2 + 0.00169312169312168*G0_0_0_1_4_3 + 0.0118518518518518*G0_0_0_1_4_4 + 0.00677248677248674*G0_0_0_1_4_5 + 0.00507936507936505*G0_0_0_1_5_0 - 0.00634920634920631*G0_0_0_1_5_1 - 0.00126984126984126*G0_0_0_1_5_2 + 0.00677248677248674*G0_0_0_1_5_4 + 0.00846560846560842*G0_0_0_1_5_5 + 0.00634920634920632*G0_0_0_2_0_0 - 0.000740740740740738*G0_0_0_2_0_1 - 0.00253968253968253*G0_0_0_2_0_2 - 0.000423280423280418*G0_0_0_2_0_3 + 0.00550264550264548*G0_0_0_2_0_4 + 0.00296296296296295*G0_0_0_2_0_5 - 0.000740740740740738*G0_0_0_2_1_0 + 0.0021164021164021*G0_0_0_2_1_1 - 0.00148148148148147*G0_0_0_2_1_2 - 0.000846560846560842*G0_0_0_2_1_3 - 0.00253968253968253*G0_0_0_2_1_4 - 0.00126984126984127*G0_0_0_2_1_5 - 0.00253968253968253*G0_0_0_2_2_0 - 0.00148148148148147*G0_0_0_2_2_1 + 0.0190476190476189*G0_0_0_2_2_2 + 0.00634920634920631*G0_0_0_2_2_3 + 0.0021164021164021*G0_0_0_2_2_4 - 0.00126984126984126*G0_0_0_2_2_5 - 0.000423280423280418*G0_0_0_2_3_0 - 0.000846560846560842*G0_0_0_2_3_1 + 0.00634920634920631*G0_0_0_2_3_2 + 0.0110052910052909*G0_0_0_2_3_3 + 0.0059259259259259*G0_0_0_2_3_4 + 0.00338624338624337*G0_0_0_2_3_5 + 0.00550264550264548*G0_0_0_2_4_0 - 0.00253968253968253*G0_0_0_2_4_1 + 0.0021164021164021*G0_0_0_2_4_2 + 0.0059259259259259*G0_0_0_2_4_3 + 0.0194708994708994*G0_0_0_2_4_4 + 0.00761904761904759*G0_0_0_2_4_5 + 0.00296296296296295*G0_0_0_2_5_0 - 0.00126984126984127*G0_0_0_2_5_1 - 0.00126984126984126*G0_0_0_2_5_2 + 0.00338624338624337*G0_0_0_2_5_3 + 0.00761904761904759*G0_0_0_2_5_4 + 0.00761904761904758*G0_0_0_2_5_5 - 0.00211640211640211*G0_0_0_3_0_0 + 0.00126984126984126*G0_0_0_3_0_1 - 0.000423280423280418*G0_0_0_3_0_2 - 0.000846560846560845*G0_0_0_3_0_3 - 0.00253968253968253*G0_0_0_3_0_4 - 0.00169312169312169*G0_0_0_3_0_5 + 0.00126984126984126*G0_0_0_3_1_0 - 0.00634920634920631*G0_0_0_3_1_1 - 0.000846560846560842*G0_0_0_3_1_2 - 0.00846560846560842*G0_0_0_3_1_3 + 0.00169312169312168*G0_0_0_3_1_4 - 0.000423280423280418*G0_0_0_3_2_0 - 0.000846560846560842*G0_0_0_3_2_1 + 0.00634920634920631*G0_0_0_3_2_2 + 0.0110052910052909*G0_0_0_3_2_3 + 0.0059259259259259*G0_0_0_3_2_4 + 0.00338624338624337*G0_0_0_3_2_5 - 0.000846560846560844*G0_0_0_3_3_0 - 0.00846560846560842*G0_0_0_3_3_1 + 0.0110052910052909*G0_0_0_3_3_2 + 0.00507936507936505*G0_0_0_3_3_3 - 0.00169312169312167*G0_0_0_3_3_4 - 0.00507936507936505*G0_0_0_3_3_5 - 0.00253968253968254*G0_0_0_3_4_0 + 0.00169312169312168*G0_0_0_3_4_1 + 0.0059259259259259*G0_0_0_3_4_2 - 0.00169312169312168*G0_0_0_3_4_3 - 0.0186243386243385*G0_0_0_3_4_4 - 0.0101587301587301*G0_0_0_3_4_5 - 0.00169312169312169*G0_0_0_3_5_0 + 0.00338624338624337*G0_0_0_3_5_2 - 0.00507936507936505*G0_0_0_3_5_3 - 0.0101587301587301*G0_0_0_3_5_4 - 0.0118518518518518*G0_0_0_3_5_5 - 0.0275132275132274*G0_0_0_4_0_0 + 0.00338624338624337*G0_0_0_4_0_1 + 0.00550264550264548*G0_0_0_4_0_2 - 0.00253968253968253*G0_0_0_4_0_3 - 0.0296296296296295*G0_0_0_4_0_4 - 0.0126984126984126*G0_0_0_4_0_5 + 0.00338624338624337*G0_0_0_4_1_0 - 0.00211640211640211*G0_0_0_4_1_1 - 0.00253968253968253*G0_0_0_4_1_2 + 0.00169312169312168*G0_0_0_4_1_3 + 0.0118518518518518*G0_0_0_4_1_4 + 0.00677248677248674*G0_0_0_4_1_5 + 0.00550264550264548*G0_0_0_4_2_0 - 0.00253968253968253*G0_0_0_4_2_1 + 0.0021164021164021*G0_0_0_4_2_2 + 0.0059259259259259*G0_0_0_4_2_3 + 0.0194708994708994*G0_0_0_4_2_4 + 0.00761904761904759*G0_0_0_4_2_5 - 0.00253968253968253*G0_0_0_4_3_0 + 0.00169312169312168*G0_0_0_4_3_1 + 0.0059259259259259*G0_0_0_4_3_2 - 0.00169312169312168*G0_0_0_4_3_3 - 0.0186243386243385*G0_0_0_4_3_4 - 0.0101587301587301*G0_0_0_4_3_5 - 0.0296296296296295*G0_0_0_4_4_0 + 0.0118518518518518*G0_0_0_4_4_1 + 0.0194708994708994*G0_0_0_4_4_2 - 0.0186243386243385*G0_0_0_4_4_3 - 0.147301587301587*G0_0_0_4_4_4 - 0.0389417989417988*G0_0_0_4_4_5 - 0.0126984126984126*G0_0_0_4_5_0 + 0.00677248677248674*G0_0_0_4_5_1 + 0.00761904761904759*G0_0_0_4_5_2 - 0.0101587301587301*G0_0_0_4_5_3 - 0.0389417989417988*G0_0_0_4_5_4 - 0.0287830687830686*G0_0_0_4_5_5 - 0.0232804232804232*G0_0_0_5_0_0 + 0.00507936507936505*G0_0_0_5_0_1 + 0.00296296296296295*G0_0_0_5_0_2 - 0.00169312169312169*G0_0_0_5_0_3 - 0.0126984126984126*G0_0_0_5_0_4 - 0.0211640211640211*G0_0_0_5_0_5 + 0.00507936507936505*G0_0_0_5_1_0 - 0.00634920634920631*G0_0_0_5_1_1 - 0.00126984126984127*G0_0_0_5_1_2 + 0.00677248677248674*G0_0_0_5_1_4 + 0.00846560846560842*G0_0_0_5_1_5 + 0.00296296296296295*G0_0_0_5_2_0 - 0.00126984126984127*G0_0_0_5_2_1 - 0.00126984126984126*G0_0_0_5_2_2 + 0.00338624338624337*G0_0_0_5_2_3 + 0.00761904761904759*G0_0_0_5_2_4 + 0.00761904761904758*G0_0_0_5_2_5 - 0.00169312169312169*G0_0_0_5_3_0 + 0.00338624338624337*G0_0_0_5_3_2 - 0.00507936507936505*G0_0_0_5_3_3 - 0.0101587301587301*G0_0_0_5_3_4 - 0.0118518518518518*G0_0_0_5_3_5 - 0.0126984126984126*G0_0_0_5_4_0 + 0.00677248677248674*G0_0_0_5_4_1 + 0.00761904761904759*G0_0_0_5_4_2 - 0.0101587301587301*G0_0_0_5_4_3 - 0.0389417989417988*G0_0_0_5_4_4 - 0.0287830687830686*G0_0_0_5_4_5 - 0.021164021164021*G0_0_0_5_5_0 + 0.00846560846560842*G0_0_0_5_5_1 + 0.00761904761904758*G0_0_0_5_5_2 - 0.0118518518518518*G0_0_0_5_5_3 - 0.0287830687830686*G0_0_0_5_5_4 - 0.0558730158730155*G0_0_0_5_5_5 - 0.0634920634920632*G0_0_1_0_0_0 + 0.00529100529100527*G0_0_1_0_0_1 + 0.00634920634920632*G0_0_1_0_0_2 - 0.00211640211640211*G0_0_1_0_0_3 - 0.0275132275132274*G0_0_1_0_0_4 - 0.0232804232804232*G0_0_1_0_0_5 + 0.00529100529100527*G0_0_1_0_1_0 - 0.000740740740740738*G0_0_1_0_1_2 + 0.00126984126984126*G0_0_1_0_1_3 + 0.00338624338624337*G0_0_1_0_1_4 + 0.00507936507936505*G0_0_1_0_1_5 + 0.00634920634920632*G0_0_1_0_2_0 - 0.000740740740740739*G0_0_1_0_2_1 - 0.00253968253968252*G0_0_1_0_2_2 - 0.000423280423280417*G0_0_1_0_2_3 + 0.00550264550264548*G0_0_1_0_2_4 + 0.00296296296296295*G0_0_1_0_2_5 - 0.00211640211640211*G0_0_1_0_3_0 + 0.00126984126984126*G0_0_1_0_3_1 - 0.000423280423280417*G0_0_1_0_3_2 - 0.000846560846560843*G0_0_1_0_3_3 - 0.00253968253968253*G0_0_1_0_3_4 - 0.00169312169312169*G0_0_1_0_3_5 - 0.0275132275132274*G0_0_1_0_4_0 + 0.00338624338624337*G0_0_1_0_4_1 + 0.00550264550264548*G0_0_1_0_4_2 - 0.00253968253968253*G0_0_1_0_4_3 - 0.0296296296296295*G0_0_1_0_4_4 - 0.0126984126984126*G0_0_1_0_4_5 - 0.0232804232804232*G0_0_1_0_5_0 + 0.00507936507936505*G0_0_1_0_5_1 + 0.00296296296296295*G0_0_1_0_5_2 - 0.00169312169312169*G0_0_1_0_5_3 - 0.0126984126984126*G0_0_1_0_5_4 - 0.021164021164021*G0_0_1_0_5_5 + 0.00529100529100527*G0_0_1_1_0_0 - 0.000740740740740738*G0_0_1_1_0_2 + 0.00126984126984126*G0_0_1_1_0_3 + 0.00338624338624337*G0_0_1_1_0_4 + 0.00507936507936505*G0_0_1_1_0_5 - 0.0158730158730158*G0_0_1_1_1_1 + 0.00211640211640211*G0_0_1_1_1_2 - 0.00634920634920632*G0_0_1_1_1_3 - 0.00211640211640211*G0_0_1_1_1_4 - 0.00634920634920632*G0_0_1_1_1_5 - 0.000740740740740739*G0_0_1_1_2_0 + 0.00211640211640211*G0_0_1_1_2_1 - 0.00148148148148147*G0_0_1_1_2_2 - 0.000846560846560839*G0_0_1_1_2_3 - 0.00253968253968253*G0_0_1_1_2_4 - 0.00126984126984126*G0_0_1_1_2_5 + 0.00126984126984126*G0_0_1_1_3_0 - 0.00634920634920632*G0_0_1_1_3_1 - 0.000846560846560839*G0_0_1_1_3_2 - 0.00846560846560842*G0_0_1_1_3_3 + 0.00169312169312168*G0_0_1_1_3_4 + 0.00338624338624337*G0_0_1_1_4_0 - 0.00211640211640211*G0_0_1_1_4_1 - 0.00253968253968253*G0_0_1_1_4_2 + 0.00169312169312168*G0_0_1_1_4_3 + 0.0118518518518518*G0_0_1_1_4_4 + 0.00677248677248674*G0_0_1_1_4_5 + 0.00507936507936505*G0_0_1_1_5_0 - 0.00634920634920632*G0_0_1_1_5_1 - 0.00126984126984126*G0_0_1_1_5_2 + 0.00677248677248674*G0_0_1_1_5_4 + 0.00846560846560842*G0_0_1_1_5_5 + 0.00634920634920632*G0_0_1_2_0_0 - 0.000740740740740739*G0_0_1_2_0_1 - 0.00253968253968252*G0_0_1_2_0_2 - 0.000423280423280417*G0_0_1_2_0_3 + 0.00550264550264548*G0_0_1_2_0_4 + 0.00296296296296295*G0_0_1_2_0_5 - 0.000740740740740739*G0_0_1_2_1_0 + 0.00211640211640211*G0_0_1_2_1_1 - 0.00148148148148147*G0_0_1_2_1_2 - 0.000846560846560839*G0_0_1_2_1_3 - 0.00253968253968253*G0_0_1_2_1_4 - 0.00126984126984126*G0_0_1_2_1_5 - 0.00253968253968252*G0_0_1_2_2_0 - 0.00148148148148147*G0_0_1_2_2_1 + 0.0190476190476189*G0_0_1_2_2_2 + 0.00634920634920631*G0_0_1_2_2_3 + 0.00211640211640209*G0_0_1_2_2_4 - 0.00126984126984126*G0_0_1_2_2_5 - 0.000423280423280417*G0_0_1_2_3_0 - 0.000846560846560839*G0_0_1_2_3_1 + 0.00634920634920631*G0_0_1_2_3_2 + 0.0110052910052909*G0_0_1_2_3_3 + 0.0059259259259259*G0_0_1_2_3_4 + 0.00338624338624337*G0_0_1_2_3_5 + 0.00550264550264548*G0_0_1_2_4_0 - 0.00253968253968253*G0_0_1_2_4_1 + 0.00211640211640209*G0_0_1_2_4_2 + 0.0059259259259259*G0_0_1_2_4_3 + 0.0194708994708994*G0_0_1_2_4_4 + 0.00761904761904759*G0_0_1_2_4_5 + 0.00296296296296295*G0_0_1_2_5_0 - 0.00126984126984126*G0_0_1_2_5_1 - 0.00126984126984126*G0_0_1_2_5_2 + 0.00338624338624337*G0_0_1_2_5_3 + 0.00761904761904759*G0_0_1_2_5_4 + 0.00761904761904758*G0_0_1_2_5_5 - 0.00211640211640211*G0_0_1_3_0_0 + 0.00126984126984126*G0_0_1_3_0_1 - 0.000423280423280417*G0_0_1_3_0_2 - 0.000846560846560843*G0_0_1_3_0_3 - 0.00253968253968253*G0_0_1_3_0_4 - 0.00169312169312169*G0_0_1_3_0_5 + 0.00126984126984126*G0_0_1_3_1_0 - 0.00634920634920632*G0_0_1_3_1_1 - 0.000846560846560839*G0_0_1_3_1_2 - 0.00846560846560842*G0_0_1_3_1_3 + 0.00169312169312168*G0_0_1_3_1_4 - 0.000423280423280417*G0_0_1_3_2_0 - 0.000846560846560839*G0_0_1_3_2_1 + 0.0063492063492063*G0_0_1_3_2_2 + 0.0110052910052909*G0_0_1_3_2_3 + 0.0059259259259259*G0_0_1_3_2_4 + 0.00338624338624337*G0_0_1_3_2_5 - 0.000846560846560843*G0_0_1_3_3_0 - 0.00846560846560842*G0_0_1_3_3_1 + 0.0110052910052909*G0_0_1_3_3_2 + 0.00507936507936504*G0_0_1_3_3_3 - 0.00169312169312168*G0_0_1_3_3_4 - 0.00507936507936505*G0_0_1_3_3_5 - 0.00253968253968253*G0_0_1_3_4_0 + 0.00169312169312168*G0_0_1_3_4_1 + 0.0059259259259259*G0_0_1_3_4_2 - 0.00169312169312168*G0_0_1_3_4_3 - 0.0186243386243385*G0_0_1_3_4_4 - 0.0101587301587301*G0_0_1_3_4_5 - 0.00169312169312169*G0_0_1_3_5_0 + 0.00338624338624337*G0_0_1_3_5_2 - 0.00507936507936505*G0_0_1_3_5_3 - 0.0101587301587301*G0_0_1_3_5_4 - 0.0118518518518518*G0_0_1_3_5_5 - 0.0275132275132274*G0_0_1_4_0_0 + 0.00338624338624337*G0_0_1_4_0_1 + 0.00550264550264548*G0_0_1_4_0_2 - 0.00253968253968253*G0_0_1_4_0_3 - 0.0296296296296295*G0_0_1_4_0_4 - 0.0126984126984126*G0_0_1_4_0_5 + 0.00338624338624337*G0_0_1_4_1_0 - 0.00211640211640211*G0_0_1_4_1_1 - 0.00253968253968253*G0_0_1_4_1_2 + 0.00169312169312169*G0_0_1_4_1_3 + 0.0118518518518518*G0_0_1_4_1_4 + 0.00677248677248674*G0_0_1_4_1_5 + 0.00550264550264548*G0_0_1_4_2_0 - 0.00253968253968253*G0_0_1_4_2_1 + 0.00211640211640209*G0_0_1_4_2_2 + 0.0059259259259259*G0_0_1_4_2_3 + 0.0194708994708994*G0_0_1_4_2_4 + 0.00761904761904759*G0_0_1_4_2_5 - 0.00253968253968253*G0_0_1_4_3_0 + 0.00169312169312168*G0_0_1_4_3_1 + 0.0059259259259259*G0_0_1_4_3_2 - 0.00169312169312168*G0_0_1_4_3_3 - 0.0186243386243385*G0_0_1_4_3_4 - 0.0101587301587301*G0_0_1_4_3_5 - 0.0296296296296295*G0_0_1_4_4_0 + 0.0118518518518518*G0_0_1_4_4_1 + 0.0194708994708994*G0_0_1_4_4_2 - 0.0186243386243385*G0_0_1_4_4_3 - 0.147301587301587*G0_0_1_4_4_4 - 0.0389417989417988*G0_0_1_4_4_5 - 0.0126984126984126*G0_0_1_4_5_0 + 0.00677248677248674*G0_0_1_4_5_1 + 0.00761904761904759*G0_0_1_4_5_2 - 0.0101587301587301*G0_0_1_4_5_3 - 0.0389417989417988*G0_0_1_4_5_4 - 0.0287830687830687*G0_0_1_4_5_5 - 0.0232804232804232*G0_0_1_5_0_0 + 0.00507936507936505*G0_0_1_5_0_1 + 0.00296296296296295*G0_0_1_5_0_2 - 0.00169312169312169*G0_0_1_5_0_3 - 0.0126984126984126*G0_0_1_5_0_4 - 0.021164021164021*G0_0_1_5_0_5 + 0.00507936507936505*G0_0_1_5_1_0 - 0.00634920634920632*G0_0_1_5_1_1 - 0.00126984126984126*G0_0_1_5_1_2 + 0.00677248677248674*G0_0_1_5_1_4 + 0.00846560846560842*G0_0_1_5_1_5 + 0.00296296296296295*G0_0_1_5_2_0 - 0.00126984126984126*G0_0_1_5_2_1 - 0.00126984126984126*G0_0_1_5_2_2 + 0.00338624338624337*G0_0_1_5_2_3 + 0.00761904761904759*G0_0_1_5_2_4 + 0.00761904761904758*G0_0_1_5_2_5 - 0.00169312169312169*G0_0_1_5_3_0 + 0.00338624338624337*G0_0_1_5_3_2 - 0.00507936507936505*G0_0_1_5_3_3 - 0.0101587301587301*G0_0_1_5_3_4 - 0.0118518518518518*G0_0_1_5_3_5 - 0.0126984126984126*G0_0_1_5_4_0 + 0.00677248677248674*G0_0_1_5_4_1 + 0.00761904761904759*G0_0_1_5_4_2 - 0.0101587301587301*G0_0_1_5_4_3 - 0.0389417989417988*G0_0_1_5_4_4 - 0.0287830687830687*G0_0_1_5_4_5 - 0.021164021164021*G0_0_1_5_5_0 + 0.00846560846560842*G0_0_1_5_5_1 + 0.00761904761904758*G0_0_1_5_5_2 - 0.0118518518518518*G0_0_1_5_5_3 - 0.0287830687830687*G0_0_1_5_5_4 - 0.0558730158730155*G0_0_1_5_5_5;
    A[4] = -A[3] - 0.0634920634920632*G0_0_1_0_0_0 + 0.00634920634920632*G0_0_1_0_0_1 + 0.00529100529100527*G0_0_1_0_0_2 - 0.00211640211640211*G0_0_1_0_0_3 - 0.0232804232804232*G0_0_1_0_0_4 - 0.0275132275132274*G0_0_1_0_0_5 + 0.00634920634920632*G0_0_1_0_1_0 - 0.00253968253968252*G0_0_1_0_1_1 - 0.000740740740740738*G0_0_1_0_1_2 - 0.000423280423280418*G0_0_1_0_1_3 + 0.00296296296296295*G0_0_1_0_1_4 + 0.00550264550264548*G0_0_1_0_1_5 + 0.00529100529100527*G0_0_1_0_2_0 - 0.000740740740740738*G0_0_1_0_2_1 + 0.00126984126984126*G0_0_1_0_2_3 + 0.00507936507936506*G0_0_1_0_2_4 + 0.00338624338624337*G0_0_1_0_2_5 - 0.00211640211640211*G0_0_1_0_3_0 - 0.000423280423280419*G0_0_1_0_3_1 + 0.00126984126984126*G0_0_1_0_3_2 - 0.000846560846560841*G0_0_1_0_3_3 - 0.00169312169312169*G0_0_1_0_3_4 - 0.00253968253968253*G0_0_1_0_3_5 - 0.0232804232804232*G0_0_1_0_4_0 + 0.00296296296296295*G0_0_1_0_4_1 + 0.00507936507936506*G0_0_1_0_4_2 - 0.00169312169312169*G0_0_1_0_4_3 - 0.0211640211640211*G0_0_1_0_4_4 - 0.0126984126984126*G0_0_1_0_4_5 - 0.0275132275132274*G0_0_1_0_5_0 + 0.00550264550264547*G0_0_1_0_5_1 + 0.00338624338624337*G0_0_1_0_5_2 - 0.00253968253968253*G0_0_1_0_5_3 - 0.0126984126984126*G0_0_1_0_5_4 - 0.0296296296296295*G0_0_1_0_5_5 + 0.00634920634920632*G0_0_1_1_0_0 - 0.00253968253968252*G0_0_1_1_0_1 - 0.000740740740740738*G0_0_1_1_0_2 - 0.000423280423280418*G0_0_1_1_0_3 + 0.00296296296296295*G0_0_1_1_0_4 + 0.00550264550264548*G0_0_1_1_0_5 - 0.00253968253968252*G0_0_1_1_1_0 + 0.0190476190476189*G0_0_1_1_1_1 - 0.00148148148148147*G0_0_1_1_1_2 + 0.00634920634920631*G0_0_1_1_1_3 - 0.00126984126984126*G0_0_1_1_1_4 + 0.0021164021164021*G0_0_1_1_1_5 - 0.000740740740740738*G0_0_1_1_2_0 - 0.00148148148148147*G0_0_1_1_2_1 + 0.00211640211640211*G0_0_1_1_2_2 - 0.000846560846560843*G0_0_1_1_2_3 - 0.00126984126984126*G0_0_1_1_2_4 - 0.00253968253968253*G0_0_1_1_2_5 - 0.000423280423280419*G0_0_1_1_3_0 + 0.00634920634920631*G0_0_1_1_3_1 - 0.000846560846560843*G0_0_1_1_3_2 + 0.0110052910052909*G0_0_1_1_3_3 + 0.00338624338624337*G0_0_1_1_3_4 + 0.0059259259259259*G0_0_1_1_3_5 + 0.00296296296296295*G0_0_1_1_4_0 - 0.00126984126984126*G0_0_1_1_4_1 - 0.00126984126984126*G0_0_1_1_4_2 + 0.00338624338624337*G0_0_1_1_4_3 + 0.00761904761904759*G0_0_1_1_4_4 + 0.00761904761904758*G0_0_1_1_4_5 + 0.00550264550264547*G0_0_1_1_5_0 + 0.0021164021164021*G0_0_1_1_5_1 - 0.00253968253968253*G0_0_1_1_5_2 + 0.0059259259259259*G0_0_1_1_5_3 + 0.00761904761904758*G0_0_1_1_5_4 + 0.0194708994708994*G0_0_1_1_5_5 + 0.00529100529100527*G0_0_1_2_0_0 - 0.000740740740740738*G0_0_1_2_0_1 + 0.00126984126984126*G0_0_1_2_0_3 + 0.00507936507936506*G0_0_1_2_0_4 + 0.00338624338624337*G0_0_1_2_0_5 - 0.000740740740740738*G0_0_1_2_1_0 - 0.00148148148148147*G0_0_1_2_1_1 + 0.00211640211640211*G0_0_1_2_1_2 - 0.000846560846560843*G0_0_1_2_1_3 - 0.00126984126984126*G0_0_1_2_1_4 - 0.00253968253968253*G0_0_1_2_1_5 + 0.00211640211640211*G0_0_1_2_2_1 - 0.0158730158730158*G0_0_1_2_2_2 - 0.00634920634920632*G0_0_1_2_2_3 - 0.00634920634920632*G0_0_1_2_2_4 - 0.00211640211640211*G0_0_1_2_2_5 + 0.00126984126984126*G0_0_1_2_3_0 - 0.000846560846560843*G0_0_1_2_3_1 - 0.00634920634920632*G0_0_1_2_3_2 - 0.00846560846560842*G0_0_1_2_3_3 + 0.00169312169312168*G0_0_1_2_3_5 + 0.00507936507936506*G0_0_1_2_4_0 - 0.00126984126984126*G0_0_1_2_4_1 - 0.00634920634920632*G0_0_1_2_4_2 + 0.00846560846560843*G0_0_1_2_4_4 + 0.00677248677248674*G0_0_1_2_4_5 + 0.00338624338624337*G0_0_1_2_5_0 - 0.00253968253968253*G0_0_1_2_5_1 - 0.00211640211640211*G0_0_1_2_5_2 + 0.00169312169312168*G0_0_1_2_5_3 + 0.00677248677248674*G0_0_1_2_5_4 + 0.0118518518518518*G0_0_1_2_5_5 - 0.00211640211640211*G0_0_1_3_0_0 - 0.000423280423280419*G0_0_1_3_0_1 + 0.00126984126984126*G0_0_1_3_0_2 - 0.000846560846560841*G0_0_1_3_0_3 - 0.00169312169312169*G0_0_1_3_0_4 - 0.00253968253968253*G0_0_1_3_0_5 - 0.000423280423280419*G0_0_1_3_1_0 + 0.00634920634920631*G0_0_1_3_1_1 - 0.000846560846560843*G0_0_1_3_1_2 + 0.0110052910052909*G0_0_1_3_1_3 + 0.00338624338624337*G0_0_1_3_1_4 + 0.0059259259259259*G0_0_1_3_1_5 + 0.00126984126984126*G0_0_1_3_2_0 - 0.000846560846560843*G0_0_1_3_2_1 - 0.00634920634920632*G0_0_1_3_2_2 - 0.00846560846560842*G0_0_1_3_2_3 + 0.00169312169312168*G0_0_1_3_2_5 - 0.000846560846560841*G0_0_1_3_3_0 + 0.0110052910052909*G0_0_1_3_3_1 - 0.00846560846560842*G0_0_1_3_3_2 + 0.00507936507936505*G0_0_1_3_3_3 - 0.00507936507936506*G0_0_1_3_3_4 - 0.00169312169312168*G0_0_1_3_3_5 - 0.00169312169312169*G0_0_1_3_4_0 + 0.00338624338624337*G0_0_1_3_4_1 - 0.00507936507936506*G0_0_1_3_4_3 - 0.0118518518518518*G0_0_1_3_4_4 - 0.0101587301587301*G0_0_1_3_4_5 - 0.00253968253968253*G0_0_1_3_5_0 + 0.0059259259259259*G0_0_1_3_5_1 + 0.00169312169312168*G0_0_1_3_5_2 - 0.00169312169312168*G0_0_1_3_5_3 - 0.0101587301587301*G0_0_1_3_5_4 - 0.0186243386243385*G0_0_1_3_5_5 - 0.0232804232804232*G0_0_1_4_0_0 + 0.00296296296296295*G0_0_1_4_0_1 + 0.00507936507936506*G0_0_1_4_0_2 - 0.00169312169312169*G0_0_1_4_0_3 - 0.0211640211640211*G0_0_1_4_0_4 - 0.0126984126984126*G0_0_1_4_0_5 + 0.00296296296296295*G0_0_1_4_1_0 - 0.00126984126984126*G0_0_1_4_1_1 - 0.00126984126984126*G0_0_1_4_1_2 + 0.00338624338624337*G0_0_1_4_1_3 + 0.00761904761904759*G0_0_1_4_1_4 + 0.00761904761904758*G0_0_1_4_1_5 + 0.00507936507936506*G0_0_1_4_2_0 - 0.00126984126984126*G0_0_1_4_2_1 - 0.00634920634920632*G0_0_1_4_2_2 + 0.00846560846560843*G0_0_1_4_2_4 + 0.00677248677248674*G0_0_1_4_2_5 - 0.00169312169312169*G0_0_1_4_3_0 + 0.00338624338624337*G0_0_1_4_3_1 - 0.00507936507936506*G0_0_1_4_3_3 - 0.0118518518518518*G0_0_1_4_3_4 - 0.0101587301587301*G0_0_1_4_3_5 - 0.0211640211640211*G0_0_1_4_4_0 + 0.00761904761904758*G0_0_1_4_4_1 + 0.00846560846560843*G0_0_1_4_4_2 - 0.0118518518518518*G0_0_1_4_4_3 - 0.0558730158730156*G0_0_1_4_4_4 - 0.0287830687830687*G0_0_1_4_4_5 - 0.0126984126984126*G0_0_1_4_5_0 + 0.00761904761904758*G0_0_1_4_5_1 + 0.00677248677248674*G0_0_1_4_5_2 - 0.0101587301587301*G0_0_1_4_5_3 - 0.0287830687830687*G0_0_1_4_5_4 - 0.0389417989417987*G0_0_1_4_5_5 - 0.0275132275132274*G0_0_1_5_0_0 + 0.00550264550264547*G0_0_1_5_0_1 + 0.00338624338624337*G0_0_1_5_0_2 - 0.00253968253968253*G0_0_1_5_0_3 - 0.0126984126984126*G0_0_1_5_0_4 - 0.0296296296296295*G0_0_1_5_0_5 + 0.00550264550264548*G0_0_1_5_1_0 + 0.0021164021164021*G0_0_1_5_1_1 - 0.00253968253968253*G0_0_1_5_1_2 + 0.0059259259259259*G0_0_1_5_1_3 + 0.00761904761904758*G0_0_1_5_1_4 + 0.0194708994708994*G0_0_1_5_1_5 + 0.00338624338624337*G0_0_1_5_2_0 - 0.00253968253968253*G0_0_1_5_2_1 - 0.00211640211640211*G0_0_1_5_2_2 + 0.00169312169312168*G0_0_1_5_2_3 + 0.00677248677248674*G0_0_1_5_2_4 + 0.0118518518518518*G0_0_1_5_2_5 - 0.00253968253968253*G0_0_1_5_3_0 + 0.0059259259259259*G0_0_1_5_3_1 + 0.00169312169312168*G0_0_1_5_3_2 - 0.00169312169312168*G0_0_1_5_3_3 - 0.0101587301587301*G0_0_1_5_3_4 - 0.0186243386243385*G0_0_1_5_3_5 - 0.0126984126984126*G0_0_1_5_4_0 + 0.00761904761904758*G0_0_1_5_4_1 + 0.00677248677248674*G0_0_1_5_4_2 - 0.0101587301587301*G0_0_1_5_4_3 - 0.0287830687830687*G0_0_1_5_4_4 - 0.0389417989417987*G0_0_1_5_4_5 - 0.0296296296296295*G0_0_1_5_5_0 + 0.0194708994708994*G0_0_1_5_5_1 + 0.0118518518518518*G0_0_1_5_5_2 - 0.0186243386243385*G0_0_1_5_5_3 - 0.0389417989417987*G0_0_1_5_5_4 - 0.147301587301586*G0_0_1_5_5_5 - 0.0634920634920632*G0_1_1_0_0_0 + 0.00634920634920632*G0_1_1_0_0_1 + 0.00529100529100527*G0_1_1_0_0_2 - 0.00211640211640211*G0_1_1_0_0_3 - 0.0232804232804232*G0_1_1_0_0_4 - 0.0275132275132274*G0_1_1_0_0_5 + 0.00634920634920632*G0_1_1_0_1_0 - 0.00253968253968252*G0_1_1_0_1_1 - 0.000740740740740737*G0_1_1_0_1_2 - 0.000423280423280419*G0_1_1_0_1_3 + 0.00296296296296295*G0_1_1_0_1_4 + 0.00550264550264547*G0_1_1_0_1_5 + 0.00529100529100527*G0_1_1_0_2_0 - 0.000740740740740737*G0_1_1_0_2_1 + 0.00126984126984126*G0_1_1_0_2_3 + 0.00507936507936506*G0_1_1_0_2_4 + 0.00338624338624337*G0_1_1_0_2_5 - 0.00211640211640211*G0_1_1_0_3_0 - 0.000423280423280419*G0_1_1_0_3_1 + 0.00126984126984126*G0_1_1_0_3_2 - 0.000846560846560843*G0_1_1_0_3_3 - 0.00169312169312169*G0_1_1_0_3_4 - 0.00253968253968253*G0_1_1_0_3_5 - 0.0232804232804232*G0_1_1_0_4_0 + 0.00296296296296295*G0_1_1_0_4_1 + 0.00507936507936506*G0_1_1_0_4_2 - 0.00169312169312169*G0_1_1_0_4_3 - 0.0211640211640211*G0_1_1_0_4_4 - 0.0126984126984126*G0_1_1_0_4_5 - 0.0275132275132274*G0_1_1_0_5_0 + 0.00550264550264547*G0_1_1_0_5_1 + 0.00338624338624337*G0_1_1_0_5_2 - 0.00253968253968253*G0_1_1_0_5_3 - 0.0126984126984126*G0_1_1_0_5_4 - 0.0296296296296295*G0_1_1_0_5_5 + 0.00634920634920632*G0_1_1_1_0_0 - 0.00253968253968252*G0_1_1_1_0_1 - 0.000740740740740737*G0_1_1_1_0_2 - 0.000423280423280419*G0_1_1_1_0_3 + 0.00296296296296295*G0_1_1_1_0_4 + 0.00550264550264547*G0_1_1_1_0_5 - 0.00253968253968252*G0_1_1_1_1_0 + 0.019047619047619*G0_1_1_1_1_1 - 0.00148148148148147*G0_1_1_1_1_2 + 0.00634920634920632*G0_1_1_1_1_3 - 0.00126984126984126*G0_1_1_1_1_4 + 0.00211640211640211*G0_1_1_1_1_5 - 0.000740740740740737*G0_1_1_1_2_0 - 0.00148148148148147*G0_1_1_1_2_1 + 0.0021164021164021*G0_1_1_1_2_2 - 0.000846560846560845*G0_1_1_1_2_3 - 0.00126984126984127*G0_1_1_1_2_4 - 0.00253968253968253*G0_1_1_1_2_5 - 0.000423280423280419*G0_1_1_1_3_0 + 0.00634920634920632*G0_1_1_1_3_1 - 0.000846560846560845*G0_1_1_1_3_2 + 0.011005291005291*G0_1_1_1_3_3 + 0.00338624338624337*G0_1_1_1_3_4 + 0.0059259259259259*G0_1_1_1_3_5 + 0.00296296296296295*G0_1_1_1_4_0 - 0.00126984126984126*G0_1_1_1_4_1 - 0.00126984126984127*G0_1_1_1_4_2 + 0.00338624338624337*G0_1_1_1_4_3 + 0.00761904761904759*G0_1_1_1_4_4 + 0.00761904761904758*G0_1_1_1_4_5 + 0.00550264550264547*G0_1_1_1_5_0 + 0.00211640211640211*G0_1_1_1_5_1 - 0.00253968253968253*G0_1_1_1_5_2 + 0.0059259259259259*G0_1_1_1_5_3 + 0.00761904761904758*G0_1_1_1_5_4 + 0.0194708994708994*G0_1_1_1_5_5 + 0.00529100529100527*G0_1_1_2_0_0 - 0.000740740740740737*G0_1_1_2_0_1 + 0.00126984126984126*G0_1_1_2_0_3 + 0.00507936507936506*G0_1_1_2_0_4 + 0.00338624338624337*G0_1_1_2_0_5 - 0.000740740740740737*G0_1_1_2_1_0 - 0.00148148148148147*G0_1_1_2_1_1 + 0.0021164021164021*G0_1_1_2_1_2 - 0.000846560846560846*G0_1_1_2_1_3 - 0.00126984126984127*G0_1_1_2_1_4 - 0.00253968253968253*G0_1_1_2_1_5 + 0.0021164021164021*G0_1_1_2_2_1 - 0.0158730158730158*G0_1_1_2_2_2 - 0.00634920634920631*G0_1_1_2_2_3 - 0.00634920634920631*G0_1_1_2_2_4 - 0.00211640211640211*G0_1_1_2_2_5 + 0.00126984126984126*G0_1_1_2_3_0 - 0.000846560846560845*G0_1_1_2_3_1 - 0.00634920634920631*G0_1_1_2_3_2 - 0.00846560846560842*G0_1_1_2_3_3 + 0.00169312169312168*G0_1_1_2_3_5 + 0.00507936507936506*G0_1_1_2_4_0 - 0.00126984126984127*G0_1_1_2_4_1 - 0.00634920634920631*G0_1_1_2_4_2 + 0.00846560846560843*G0_1_1_2_4_4 + 0.00677248677248674*G0_1_1_2_4_5 + 0.00338624338624337*G0_1_1_2_5_0 - 0.00253968253968253*G0_1_1_2_5_1 - 0.00211640211640211*G0_1_1_2_5_2 + 0.00169312169312168*G0_1_1_2_5_3 + 0.00677248677248674*G0_1_1_2_5_4 + 0.0118518518518518*G0_1_1_2_5_5 - 0.00211640211640211*G0_1_1_3_0_0 - 0.000423280423280419*G0_1_1_3_0_1 + 0.00126984126984126*G0_1_1_3_0_2 - 0.000846560846560843*G0_1_1_3_0_3 - 0.00169312169312169*G0_1_1_3_0_4 - 0.00253968253968253*G0_1_1_3_0_5 - 0.000423280423280419*G0_1_1_3_1_0 + 0.00634920634920632*G0_1_1_3_1_1 - 0.000846560846560845*G0_1_1_3_1_2 + 0.011005291005291*G0_1_1_3_1_3 + 0.00338624338624337*G0_1_1_3_1_4 + 0.0059259259259259*G0_1_1_3_1_5 + 0.00126984126984126*G0_1_1_3_2_0 - 0.000846560846560845*G0_1_1_3_2_1 - 0.00634920634920631*G0_1_1_3_2_2 - 0.00846560846560842*G0_1_1_3_2_3 + 0.00169312169312168*G0_1_1_3_2_5 - 0.000846560846560842*G0_1_1_3_3_0 + 0.011005291005291*G0_1_1_3_3_1 - 0.00846560846560842*G0_1_1_3_3_2 + 0.00507936507936508*G0_1_1_3_3_3 - 0.00507936507936505*G0_1_1_3_3_4 - 0.00169312169312168*G0_1_1_3_3_5 - 0.00169312169312169*G0_1_1_3_4_0 + 0.00338624338624337*G0_1_1_3_4_1 - 0.00507936507936505*G0_1_1_3_4_3 - 0.0118518518518518*G0_1_1_3_4_4 - 0.0101587301587301*G0_1_1_3_4_5 - 0.00253968253968253*G0_1_1_3_5_0 + 0.0059259259259259*G0_1_1_3_5_1 + 0.00169312169312168*G0_1_1_3_5_2 - 0.00169312169312168*G0_1_1_3_5_3 - 0.0101587301587301*G0_1_1_3_5_4 - 0.0186243386243385*G0_1_1_3_5_5 - 0.0232804232804232*G0_1_1_4_0_0 + 0.00296296296296295*G0_1_1_4_0_1 + 0.00507936507936506*G0_1_1_4_0_2 - 0.00169312169312169*G0_1_1_4_0_3 - 0.0211640211640211*G0_1_1_4_0_4 - 0.0126984126984126*G0_1_1_4_0_5 + 0.00296296296296295*G0_1_1_4_1_0 - 0.00126984126984126*G0_1_1_4_1_1 - 0.00126984126984127*G0_1_1_4_1_2 + 0.00338624338624337*G0_1_1_4_1_3 + 0.00761904761904759*G0_1_1_4_1_4 + 0.00761904761904758*G0_1_1_4_1_5 + 0.00507936507936506*G0_1_1_4_2_0 - 0.00126984126984127*G0_1_1_4_2_1 - 0.00634920634920632*G0_1_1_4_2_2 + 0.00846560846560844*G0_1_1_4_2_4 + 0.00677248677248674*G0_1_1_4_2_5 - 0.00169312169312169*G0_1_1_4_3_0 + 0.00338624338624337*G0_1_1_4_3_1 - 0.00507936507936506*G0_1_1_4_3_3 - 0.0118518518518518*G0_1_1_4_3_4 - 0.0101587301587301*G0_1_1_4_3_5 - 0.0211640211640211*G0_1_1_4_4_0 + 0.00761904761904759*G0_1_1_4_4_1 + 0.00846560846560843*G0_1_1_4_4_2 - 0.0118518518518518*G0_1_1_4_4_3 - 0.0558730158730156*G0_1_1_4_4_4 - 0.0287830687830687*G0_1_1_4_4_5 - 0.0126984126984126*G0_1_1_4_5_0 + 0.00761904761904758*G0_1_1_4_5_1 + 0.00677248677248674*G0_1_1_4_5_2 - 0.0101587301587301*G0_1_1_4_5_3 - 0.0287830687830687*G0_1_1_4_5_4 - 0.0389417989417987*G0_1_1_4_5_5 - 0.0275132275132274*G0_1_1_5_0_0 + 0.00550264550264547*G0_1_1_5_0_1 + 0.00338624338624337*G0_1_1_5_0_2 - 0.00253968253968253*G0_1_1_5_0_3 - 0.0126984126984126*G0_1_1_5_0_4 - 0.0296296296296295*G0_1_1_5_0_5 + 0.00550264550264547*G0_1_1_5_1_0 + 0.00211640211640211*G0_1_1_5_1_1 - 0.00253968253968253*G0_1_1_5_1_2 + 0.0059259259259259*G0_1_1_5_1_3 + 0.00761904761904758*G0_1_1_5_1_4 + 0.0194708994708994*G0_1_1_5_1_5 + 0.00338624338624337*G0_1_1_5_2_0 - 0.00253968253968253*G0_1_1_5_2_1 - 0.00211640211640211*G0_1_1_5_2_2 + 0.00169312169312168*G0_1_1_5_2_3 + 0.00677248677248674*G0_1_1_5_2_4 + 0.0118518518518518*G0_1_1_5_2_5 - 0.00253968253968253*G0_1_1_5_3_0 + 0.0059259259259259*G0_1_1_5_3_1 + 0.00169312169312168*G0_1_1_5_3_2 - 0.00169312169312168*G0_1_1_5_3_3 - 0.0101587301587301*G0_1_1_5_3_4 - 0.0186243386243385*G0_1_1_5_3_5 - 0.0126984126984126*G0_1_1_5_4_0 + 0.00761904761904758*G0_1_1_5_4_1 + 0.00677248677248674*G0_1_1_5_4_2 - 0.0101587301587301*G0_1_1_5_4_3 - 0.0287830687830687*G0_1_1_5_4_4 - 0.0389417989417987*G0_1_1_5_4_5 - 0.0296296296296295*G0_1_1_5_5_0 + 0.0194708994708994*G0_1_1_5_5_1 + 0.0118518518518518*G0_1_1_5_5_2 - 0.0186243386243385*G0_1_1_5_5_3 - 0.0389417989417987*G0_1_1_5_5_4 - 0.147301587301586*G0_1_1_5_5_5;
    A[1] = -A[25] + 0.015079365079365*G0_0_0_0_0_0 - 0.00111111111111111*G0_0_0_0_0_1 - 0.00111111111111111*G0_0_0_0_0_2 + 0.000105820105820108*G0_0_0_0_0_3 + 0.0079365079365079*G0_0_0_0_0_4 + 0.00370370370370369*G0_0_0_0_0_5 - 0.00111111111111111*G0_0_0_0_1_0 - 0.000264550264550263*G0_0_0_0_1_1 + 0.000343915343915342*G0_0_0_0_1_2 - 0.000423280423280423*G0_0_0_0_1_4 - 0.000529100529100528*G0_0_0_0_1_5 - 0.00111111111111111*G0_0_0_0_2_0 + 0.000343915343915342*G0_0_0_0_2_1 - 0.0011111111111111*G0_0_0_0_2_2 - 0.00126984126984126*G0_0_0_0_2_3 - 0.0039153439153439*G0_0_0_0_2_4 - 0.00126984126984126*G0_0_0_0_2_5 + 0.000105820105820108*G0_0_0_0_3_0 - 0.00126984126984126*G0_0_0_0_3_2 + 0.00296296296296294*G0_0_0_0_3_3 + 0.000634920634920634*G0_0_0_0_3_4 + 0.00232804232804232*G0_0_0_0_3_5 + 0.0079365079365079*G0_0_0_0_4_0 - 0.000423280423280423*G0_0_0_0_4_1 - 0.0039153439153439*G0_0_0_0_4_2 + 0.000634920634920634*G0_0_0_0_4_3 + 0.00507936507936506*G0_0_0_0_4_4 + 0.00338624338624337*G0_0_0_0_4_5 + 0.00370370370370369*G0_0_0_0_5_0 - 0.000529100529100528*G0_0_0_0_5_1 - 0.00126984126984126*G0_0_0_0_5_2 + 0.00232804232804232*G0_0_0_0_5_3 + 0.00338624338624337*G0_0_0_0_5_4 + 0.00507936507936505*G0_0_0_0_5_5 - 0.00111111111111111*G0_0_0_1_0_0 - 0.000264550264550263*G0_0_0_1_0_1 + 0.000343915343915342*G0_0_0_1_0_2 - 0.000423280423280423*G0_0_0_1_0_4 - 0.000529100529100528*G0_0_0_1_0_5 - 0.000264550264550263*G0_0_0_1_1_0 + 0.0087301587301587*G0_0_0_1_1_1 - 0.000264550264550264*G0_0_0_1_1_2 + 0.00158730158730158*G0_0_0_1_1_3 + 0.000529100529100527*G0_0_0_1_1_4 + 0.00158730158730158*G0_0_0_1_1_5 + 0.000343915343915342*G0_0_0_1_2_0 - 0.000264550264550264*G0_0_0_1_2_1 - 0.0011111111111111*G0_0_0_1_2_2 - 0.000529100529100526*G0_0_0_1_2_3 - 0.00042328042328042*G0_0_0_1_2_4 + 0.00158730158730158*G0_0_0_1_3_1 - 0.000529100529100526*G0_0_0_1_3_2 - 0.00105820105820105*G0_0_0_1_3_4 - 0.000423280423280423*G0_0_0_1_4_0 + 0.000529100529100528*G0_0_0_1_4_1 - 0.00042328042328042*G0_0_0_1_4_2 - 0.00105820105820105*G0_0_0_1_4_3 - 0.00550264550264548*G0_0_0_1_4_4 - 0.00105820105820105*G0_0_0_1_4_5 - 0.000529100529100528*G0_0_0_1_5_0 + 0.00158730158730158*G0_0_0_1_5_1 - 0.00105820105820105*G0_0_0_1_5_4 - 0.00111111111111111*G0_0_0_2_0_0 + 0.000343915343915342*G0_0_0_2_0_1 - 0.0011111111111111*G0_0_0_2_0_2 - 0.00126984126984126*G0_0_0_2_0_3 - 0.0039153439153439*G0_0_0_2_0_4 - 0.00126984126984127*G0_0_0_2_0_5 + 0.000343915343915342*G0_0_0_2_1_0 - 0.000264550264550264*G0_0_0_2_1_1 - 0.0011111111111111*G0_0_0_2_1_2 - 0.000529100529100526*G0_0_0_2_1_3 - 0.00042328042328042*G0_0_0_2_1_4 - 0.0011111111111111*G0_0_0_2_2_0 - 0.0011111111111111*G0_0_0_2_2_1 + 0.015079365079365*G0_0_0_2_2_2 + 0.00370370370370368*G0_0_0_2_2_3 + 0.00793650793650789*G0_0_0_2_2_4 + 0.000105820105820109*G0_0_0_2_2_5 - 0.00126984126984126*G0_0_0_2_3_0 - 0.000529100529100526*G0_0_0_2_3_1 + 0.00370370370370368*G0_0_0_2_3_2 + 0.00507936507936506*G0_0_0_2_3_3 + 0.00338624338624337*G0_0_0_2_3_4 + 0.00232804232804232*G0_0_0_2_3_5 - 0.0039153439153439*G0_0_0_2_4_0 - 0.00042328042328042*G0_0_0_2_4_1 + 0.00793650793650789*G0_0_0_2_4_2 + 0.00338624338624337*G0_0_0_2_4_3 + 0.00507936507936505*G0_0_0_2_4_4 + 0.000634920634920633*G0_0_0_2_4_5 - 0.00126984126984126*G0_0_0_2_5_0 + 0.000105820105820109*G0_0_0_2_5_2 + 0.00232804232804232*G0_0_0_2_5_3 + 0.000634920634920633*G0_0_0_2_5_4 + 0.00296296296296295*G0_0_0_2_5_5 + 0.000105820105820108*G0_0_0_3_0_0 - 0.00126984126984126*G0_0_0_3_0_2 + 0.00296296296296294*G0_0_0_3_0_3 + 0.000634920634920633*G0_0_0_3_0_4 + 0.00232804232804232*G0_0_0_3_0_5 + 0.00158730158730158*G0_0_0_3_1_1 - 0.000529100529100526*G0_0_0_3_1_2 - 0.00105820105820105*G0_0_0_3_1_4 - 0.00126984126984126*G0_0_0_3_2_0 - 0.000529100529100525*G0_0_0_3_2_1 + 0.00370370370370368*G0_0_0_3_2_2 + 0.00507936507936506*G0_0_0_3_2_3 + 0.00338624338624337*G0_0_0_3_2_4 + 0.00232804232804232*G0_0_0_3_2_5 + 0.00296296296296294*G0_0_0_3_3_0 + 0.00507936507936506*G0_0_0_3_3_2 - 0.0317460317460316*G0_0_0_3_3_3 - 0.00380952380952379*G0_0_0_3_3_4 - 0.0105820105820105*G0_0_0_3_3_5 + 0.000634920634920633*G0_0_0_3_4_0 - 0.00105820105820105*G0_0_0_3_4_1 + 0.00338624338624337*G0_0_0_3_4_2 - 0.00380952380952379*G0_0_0_3_4_3 + 0.00973544973544969*G0_0_0_3_4_4 - 0.00253968253968253*G0_0_0_3_4_5 + 0.00232804232804232*G0_0_0_3_5_0 + 0.00232804232804232*G0_0_0_3_5_2 - 0.0105820105820105*G0_0_0_3_5_3 - 0.00253968253968253*G0_0_0_3_5_4 - 0.0105820105820105*G0_0_0_3_5_5 + 0.0079365079365079*G0_0_0_4_0_0 - 0.000423280423280423*G0_0_0_4_0_1 - 0.0039153439153439*G0_0_0_4_0_2 + 0.000634920634920633*G0_0_0_4_0_3 + 0.00507936507936506*G0_0_0_4_0_4 + 0.00338624338624337*G0_0_0_4_0_5 - 0.000423280423280423*G0_0_0_4_1_0 + 0.000529100529100527*G0_0_0_4_1_1 - 0.00042328042328042*G0_0_0_4_1_2 - 0.00105820105820105*G0_0_0_4_1_3 - 0.00550264550264548*G0_0_0_4_1_4 - 0.00105820105820105*G0_0_0_4_1_5 - 0.0039153439153439*G0_0_0_4_2_0 - 0.00042328042328042*G0_0_0_4_2_1 + 0.00793650793650789*G0_0_0_4_2_2 + 0.00338624338624337*G0_0_0_4_2_3 + 0.00507936507936505*G0_0_0_4_2_4 + 0.000634920634920633*G0_0_0_4_2_5 + 0.000634920634920633*G0_0_0_4_3_0 - 0.00105820105820105*G0_0_0_4_3_1 + 0.00338624338624337*G0_0_0_4_3_2 - 0.00380952380952379*G0_0_0_4_3_3 + 0.00973544973544969*G0_0_0_4_3_4 - 0.00253968253968253*G0_0_0_4_3_5 + 0.00507936507936506*G0_0_0_4_4_0 - 0.00550264550264548*G0_0_0_4_4_1 + 0.00507936507936505*G0_0_0_4_4_2 + 0.00973544973544969*G0_0_0_4_4_3 + 0.0901587301587298*G0_0_0_4_4_4 + 0.00973544973544971*G0_0_0_4_4_5 + 0.00338624338624337*G0_0_0_4_5_0 - 0.00105820105820105*G0_0_0_4_5_1 + 0.000634920634920633*G0_0_0_4_5_2 - 0.00253968253968253*G0_0_0_4_5_3 + 0.00973544973544971*G0_0_0_4_5_4 - 0.00380952380952379*G0_0_0_4_5_5 + 0.00370370370370369*G0_0_0_5_0_0 - 0.000529100529100528*G0_0_0_5_0_1 - 0.00126984126984126*G0_0_0_5_0_2 + 0.00232804232804232*G0_0_0_5_0_3 + 0.00338624338624337*G0_0_0_5_0_4 + 0.00507936507936505*G0_0_0_5_0_5 - 0.000529100529100528*G0_0_0_5_1_0 + 0.00158730158730158*G0_0_0_5_1_1 - 0.00105820105820105*G0_0_0_5_1_4 - 0.00126984126984126*G0_0_0_5_2_0 + 0.000105820105820109*G0_0_0_5_2_2 + 0.00232804232804232*G0_0_0_5_2_3 + 0.000634920634920633*G0_0_0_5_2_4 + 0.00296296296296295*G0_0_0_5_2_5 + 0.00232804232804232*G0_0_0_5_3_0 + 0.00232804232804232*G0_0_0_5_3_2 - 0.0105820105820105*G0_0_0_5_3_3 - 0.00253968253968253*G0_0_0_5_3_4 - 0.0105820105820105*G0_0_0_5_3_5 + 0.00338624338624337*G0_0_0_5_4_0 - 0.00105820105820105*G0_0_0_5_4_1 + 0.000634920634920633*G0_0_0_5_4_2 - 0.00253968253968253*G0_0_0_5_4_3 + 0.0097354497354497*G0_0_0_5_4_4 - 0.00380952380952379*G0_0_0_5_4_5 + 0.00507936507936505*G0_0_0_5_5_0 + 0.00296296296296295*G0_0_0_5_5_2 - 0.0105820105820105*G0_0_0_5_5_3 - 0.00380952380952379*G0_0_0_5_5_4 - 0.0317460317460315*G0_0_0_5_5_5 - 0.00396825396825394*G0_1_0_0_0_0 + 0.000476190476190474*G0_1_0_0_0_1 + 0.000476190476190473*G0_1_0_0_0_2 + 0.000105820105820105*G0_1_0_0_0_3 - 0.000529100529100526*G0_1_0_0_0_4 - 0.000529100529100525*G0_1_0_0_0_5 + 0.000476190476190474*G0_1_0_0_1_0 - 0.00132275132275132*G0_1_0_0_1_1 + 0.000238095238095237*G0_1_0_0_1_2 - 0.000423280423280421*G0_1_0_0_1_3 + 0.00021164021164021*G0_1_0_0_1_4 - 0.00116402116402116*G0_1_0_0_1_5 + 0.000476190476190473*G0_1_0_0_2_0 + 0.000238095238095237*G0_1_0_0_2_1 - 0.00132275132275131*G0_1_0_0_2_2 - 0.00042328042328042*G0_1_0_0_2_3 - 0.00116402116402116*G0_1_0_0_2_4 + 0.00021164021164021*G0_1_0_0_2_5 + 0.000105820105820105*G0_1_0_0_3_0 - 0.000423280423280421*G0_1_0_0_3_1 - 0.00042328042328042*G0_1_0_0_3_2 + 0.000423280423280418*G0_1_0_0_3_3 - 0.000634920634920632*G0_1_0_0_3_4 - 0.000634920634920633*G0_1_0_0_3_5 - 0.000529100529100525*G0_1_0_0_4_0 + 0.00021164021164021*G0_1_0_0_4_1 - 0.00116402116402116*G0_1_0_0_4_2 - 0.000634920634920632*G0_1_0_0_4_3 - 0.00338624338624337*G0_1_0_0_4_4 - 0.000846560846560844*G0_1_0_0_4_5 - 0.000529100529100524*G0_1_0_0_5_0 - 0.00116402116402116*G0_1_0_0_5_1 + 0.00021164021164021*G0_1_0_0_5_2 - 0.000634920634920633*G0_1_0_0_5_3 - 0.000846560846560844*G0_1_0_0_5_4 - 0.00338624338624337*G0_1_0_0_5_5 + 0.000476190476190473*G0_1_0_1_0_0 - 0.00132275132275132*G0_1_0_1_0_1 + 0.000238095238095237*G0_1_0_1_0_2 - 0.000423280423280421*G0_1_0_1_0_3 + 0.00021164021164021*G0_1_0_1_0_4 - 0.00116402116402116*G0_1_0_1_0_5 - 0.00132275132275132*G0_1_0_1_1_0 + 0.0134920634920634*G0_1_0_1_1_1 - 0.000793650793650792*G0_1_0_1_1_2 + 0.00370370370370369*G0_1_0_1_1_3 + 0.000529100529100527*G0_1_0_1_1_4 + 0.0058201058201058*G0_1_0_1_1_5 + 0.000238095238095237*G0_1_0_1_2_0 - 0.000793650793650792*G0_1_0_1_2_1 - 0.000793650793650788*G0_1_0_1_2_2 - 0.000952380952380948*G0_1_0_1_2_3 - 0.000634920634920631*G0_1_0_1_2_4 - 0.000634920634920633*G0_1_0_1_2_5 - 0.000423280423280421*G0_1_0_1_3_0 + 0.00370370370370369*G0_1_0_1_3_1 - 0.000952380952380949*G0_1_0_1_3_2 + 0.00211640211640211*G0_1_0_1_3_3 - 0.00021164021164021*G0_1_0_1_3_4 + 0.00211640211640211*G0_1_0_1_3_5 + 0.00021164021164021*G0_1_0_1_4_0 + 0.000529100529100527*G0_1_0_1_4_1 - 0.000634920634920631*G0_1_0_1_4_2 - 0.00021164021164021*G0_1_0_1_4_3 - 0.00169312169312168*G0_1_0_1_4_4 + 0.00021164021164021*G0_1_0_1_4_5 - 0.00116402116402116*G0_1_0_1_5_0 + 0.0058201058201058*G0_1_0_1_5_1 - 0.000634920634920633*G0_1_0_1_5_2 + 0.00211640211640211*G0_1_0_1_5_3 + 0.00021164021164021*G0_1_0_1_5_4 + 0.00634920634920632*G0_1_0_1_5_5 + 0.000476190476190474*G0_1_0_2_0_0 + 0.000238095238095237*G0_1_0_2_0_1 - 0.00132275132275131*G0_1_0_2_0_2 - 0.00042328042328042*G0_1_0_2_0_3 - 0.00116402116402116*G0_1_0_2_0_4 + 0.00021164021164021*G0_1_0_2_0_5 + 0.000238095238095237*G0_1_0_2_1_0 - 0.000793650793650792*G0_1_0_2_1_1 - 0.000793650793650788*G0_1_0_2_1_2 - 0.000952380952380949*G0_1_0_2_1_3 - 0.000634920634920631*G0_1_0_2_1_4 - 0.000634920634920633*G0_1_0_2_1_5 - 0.00132275132275131*G0_1_0_2_2_0 - 0.000793650793650788*G0_1_0_2_2_1 + 0.0134920634920634*G0_1_0_2_2_2 + 0.00370370370370368*G0_1_0_2_2_3 + 0.00582010582010579*G0_1_0_2_2_4 + 0.00052910052910053*G0_1_0_2_2_5 - 0.00042328042328042*G0_1_0_2_3_0 - 0.000952380952380949*G0_1_0_2_3_1 + 0.00370370370370368*G0_1_0_2_3_2 + 0.0021164021164021*G0_1_0_2_3_3 + 0.0021164021164021*G0_1_0_2_3_4 - 0.000211640211640211*G0_1_0_2_3_5 - 0.00116402116402116*G0_1_0_2_4_0 - 0.000634920634920631*G0_1_0_2_4_1 + 0.00582010582010579*G0_1_0_2_4_2 + 0.0021164021164021*G0_1_0_2_4_3 + 0.00634920634920632*G0_1_0_2_4_4 + 0.000211640211640212*G0_1_0_2_4_5 + 0.00021164021164021*G0_1_0_2_5_0 - 0.000634920634920633*G0_1_0_2_5_1 + 0.00052910052910053*G0_1_0_2_5_2 - 0.000211640211640211*G0_1_0_2_5_3 + 0.000211640211640212*G0_1_0_2_5_4 - 0.00169312169312169*G0_1_0_2_5_5 + 0.000105820105820105*G0_1_0_3_0_0 - 0.000423280423280421*G0_1_0_3_0_1 - 0.00042328042328042*G0_1_0_3_0_2 + 0.000423280423280418*G0_1_0_3_0_3 - 0.000634920634920632*G0_1_0_3_0_4 - 0.000634920634920633*G0_1_0_3_0_5 - 0.000423280423280421*G0_1_0_3_1_0 + 0.00370370370370369*G0_1_0_3_1_1 - 0.000952380952380949*G0_1_0_3_1_2 + 0.00211640211640211*G0_1_0_3_1_3 - 0.00021164021164021*G0_1_0_3_1_4 + 0.00211640211640211*G0_1_0_3_1_5 - 0.00042328042328042*G0_1_0_3_2_0 - 0.000952380952380949*G0_1_0_3_2_1 + 0.00370370370370368*G0_1_0_3_2_2 + 0.0021164021164021*G0_1_0_3_2_3 + 0.0021164021164021*G0_1_0_3_2_4 - 0.000211640211640211*G0_1_0_3_2_5 + 0.000423280423280418*G0_1_0_3_3_0 + 0.00211640211640211*G0_1_0_3_3_1 + 0.0021164021164021*G0_1_0_3_3_2 - 0.0165079365079364*G0_1_0_3_3_3 - 0.000423280423280419*G0_1_0_3_3_4 - 0.000423280423280416*G0_1_0_3_3_5 - 0.000634920634920632*G0_1_0_3_4_0 - 0.00021164021164021*G0_1_0_3_4_1 + 0.0021164021164021*G0_1_0_3_4_2 - 0.000423280423280419*G0_1_0_3_4_3 + 0.00465608465608463*G0_1_0_3_4_4 + 0.000846560846560845*G0_1_0_3_4_5 - 0.000634920634920633*G0_1_0_3_5_0 + 0.00211640211640211*G0_1_0_3_5_1 - 0.000211640211640211*G0_1_0_3_5_2 - 0.000423280423280417*G0_1_0_3_5_3 + 0.000846560846560845*G0_1_0_3_5_4 + 0.00465608465608464*G0_1_0_3_5_5 - 0.000529100529100526*G0_1_0_4_0_0 + 0.00021164021164021*G0_1_0_4_0_1 - 0.00116402116402116*G0_1_0_4_0_2 - 0.000634920634920632*G0_1_0_4_0_3 - 0.00338624338624337*G0_1_0_4_0_4 - 0.000846560846560844*G0_1_0_4_0_5 + 0.00021164021164021*G0_1_0_4_1_0 + 0.000529100529100527*G0_1_0_4_1_1 - 0.000634920634920631*G0_1_0_4_1_2 - 0.00021164021164021*G0_1_0_4_1_3 - 0.00169312169312168*G0_1_0_4_1_4 + 0.00021164021164021*G0_1_0_4_1_5 - 0.00116402116402116*G0_1_0_4_2_0 - 0.000634920634920631*G0_1_0_4_2_1 + 0.00582010582010579*G0_1_0_4_2_2 + 0.0021164021164021*G0_1_0_4_2_3 + 0.00634920634920632*G0_1_0_4_2_4 + 0.000211640211640212*G0_1_0_4_2_5 - 0.000634920634920632*G0_1_0_4_3_0 - 0.00021164021164021*G0_1_0_4_3_1 + 0.0021164021164021*G0_1_0_4_3_2 - 0.000423280423280419*G0_1_0_4_3_3 + 0.00465608465608464*G0_1_0_4_3_4 + 0.000846560846560845*G0_1_0_4_3_5 - 0.00338624338624337*G0_1_0_4_4_0 - 0.00169312169312169*G0_1_0_4_4_1 + 0.00634920634920632*G0_1_0_4_4_2 + 0.00465608465608463*G0_1_0_4_4_3 + 0.0292063492063491*G0_1_0_4_4_4 + 0.00296296296296295*G0_1_0_4_4_5 - 0.000846560846560844*G0_1_0_4_5_0 + 0.00021164021164021*G0_1_0_4_5_1 + 0.000211640211640212*G0_1_0_4_5_2 + 0.000846560846560845*G0_1_0_4_5_3 + 0.00296296296296295*G0_1_0_4_5_4 + 0.00296296296296295*G0_1_0_4_5_5 - 0.000529100529100525*G0_1_0_5_0_0 - 0.00116402116402116*G0_1_0_5_0_1 + 0.00021164021164021*G0_1_0_5_0_2 - 0.000634920634920633*G0_1_0_5_0_3 - 0.000846560846560844*G0_1_0_5_0_4 - 0.00338624338624337*G0_1_0_5_0_5 - 0.00116402116402116*G0_1_0_5_1_0 + 0.0058201058201058*G0_1_0_5_1_1 - 0.000634920634920633*G0_1_0_5_1_2 + 0.00211640211640211*G0_1_0_5_1_3 + 0.000211640211640211*G0_1_0_5_1_4 + 0.00634920634920632*G0_1_0_5_1_5 + 0.00021164021164021*G0_1_0_5_2_0 - 0.000634920634920633*G0_1_0_5_2_1 + 0.00052910052910053*G0_1_0_5_2_2 - 0.000211640211640211*G0_1_0_5_2_3 + 0.000211640211640212*G0_1_0_5_2_4 - 0.00169312169312169*G0_1_0_5_2_5 - 0.000634920634920633*G0_1_0_5_3_0 + 0.00211640211640211*G0_1_0_5_3_1 - 0.000211640211640211*G0_1_0_5_3_2 - 0.000423280423280416*G0_1_0_5_3_3 + 0.000846560846560845*G0_1_0_5_3_4 + 0.00465608465608464*G0_1_0_5_3_5 - 0.000846560846560844*G0_1_0_5_4_0 + 0.000211640211640211*G0_1_0_5_4_1 + 0.000211640211640212*G0_1_0_5_4_2 + 0.000846560846560844*G0_1_0_5_4_3 + 0.00296296296296295*G0_1_0_5_4_4 + 0.00296296296296295*G0_1_0_5_4_5 - 0.00338624338624337*G0_1_0_5_5_0 + 0.00634920634920632*G0_1_0_5_5_1 - 0.00169312169312169*G0_1_0_5_5_2 + 0.00465608465608464*G0_1_0_5_5_3 + 0.00296296296296295*G0_1_0_5_5_4 + 0.0292063492063491*G0_1_0_5_5_5;
    A[5] = -A[3] - 0.0634920634920632*G0_0_0_0_0_0 + 0.00529100529100527*G0_0_0_0_0_1 + 0.00634920634920632*G0_0_0_0_0_2 - 0.00211640211640211*G0_0_0_0_0_3 - 0.0275132275132274*G0_0_0_0_0_4 - 0.0232804232804232*G0_0_0_0_0_5 + 0.00529100529100527*G0_0_0_0_1_0 - 0.000740740740740738*G0_0_0_0_1_2 + 0.00126984126984126*G0_0_0_0_1_3 + 0.00338624338624337*G0_0_0_0_1_4 + 0.00507936507936505*G0_0_0_0_1_5 + 0.00634920634920632*G0_0_0_0_2_0 - 0.000740740740740738*G0_0_0_0_2_1 - 0.00253968253968253*G0_0_0_0_2_2 - 0.000423280423280418*G0_0_0_0_2_3 + 0.00550264550264548*G0_0_0_0_2_4 + 0.00296296296296295*G0_0_0_0_2_5 - 0.00211640211640211*G0_0_0_0_3_0 + 0.00126984126984126*G0_0_0_0_3_1 - 0.000423280423280418*G0_0_0_0_3_2 - 0.000846560846560845*G0_0_0_0_3_3 - 0.00253968253968253*G0_0_0_0_3_4 - 0.00169312169312169*G0_0_0_0_3_5 - 0.0275132275132274*G0_0_0_0_4_0 + 0.00338624338624337*G0_0_0_0_4_1 + 0.00550264550264548*G0_0_0_0_4_2 - 0.00253968253968253*G0_0_0_0_4_3 - 0.0296296296296295*G0_0_0_0_4_4 - 0.0126984126984126*G0_0_0_0_4_5 - 0.0232804232804232*G0_0_0_0_5_0 + 0.00507936507936505*G0_0_0_0_5_1 + 0.00296296296296295*G0_0_0_0_5_2 - 0.00169312169312169*G0_0_0_0_5_3 - 0.0126984126984126*G0_0_0_0_5_4 - 0.0211640211640211*G0_0_0_0_5_5 + 0.00529100529100527*G0_0_0_1_0_0 - 0.000740740740740738*G0_0_0_1_0_2 + 0.00126984126984126*G0_0_0_1_0_3 + 0.00338624338624337*G0_0_0_1_0_4 + 0.00507936507936505*G0_0_0_1_0_5 - 0.0158730158730158*G0_0_0_1_1_1 + 0.0021164021164021*G0_0_0_1_1_2 - 0.00634920634920631*G0_0_0_1_1_3 - 0.00211640211640211*G0_0_0_1_1_4 - 0.00634920634920631*G0_0_0_1_1_5 - 0.000740740740740738*G0_0_0_1_2_0 + 0.0021164021164021*G0_0_0_1_2_1 - 0.00148148148148147*G0_0_0_1_2_2 - 0.000846560846560842*G0_0_0_1_2_3 - 0.00253968253968253*G0_0_0_1_2_4 - 0.00126984126984127*G0_0_0_1_2_5 + 0.00126984126984126*G0_0_0_1_3_0 - 0.00634920634920631*G0_0_0_1_3_1 - 0.000846560846560842*G0_0_0_1_3_2 - 0.00846560846560842*G0_0_0_1_3_3 + 0.00169312169312168*G0_0_0_1_3_4 + 0.00338624338624337*G0_0_0_1_4_0 - 0.00211640211640211*G0_0_0_1_4_1 - 0.00253968253968253*G0_0_0_1_4_2 + 0.00169312169312168*G0_0_0_1_4_3 + 0.0118518518518518*G0_0_0_1_4_4 + 0.00677248677248674*G0_0_0_1_4_5 + 0.00507936507936505*G0_0_0_1_5_0 - 0.00634920634920631*G0_0_0_1_5_1 - 0.00126984126984127*G0_0_0_1_5_2 + 0.00677248677248674*G0_0_0_1_5_4 + 0.00846560846560842*G0_0_0_1_5_5 + 0.00634920634920632*G0_0_0_2_0_0 - 0.000740740740740738*G0_0_0_2_0_1 - 0.00253968253968253*G0_0_0_2_0_2 - 0.000423280423280418*G0_0_0_2_0_3 + 0.00550264550264548*G0_0_0_2_0_4 + 0.00296296296296295*G0_0_0_2_0_5 - 0.000740740740740738*G0_0_0_2_1_0 + 0.0021164021164021*G0_0_0_2_1_1 - 0.00148148148148147*G0_0_0_2_1_2 - 0.000846560846560843*G0_0_0_2_1_3 - 0.00253968253968253*G0_0_0_2_1_4 - 0.00126984126984127*G0_0_0_2_1_5 - 0.00253968253968253*G0_0_0_2_2_0 - 0.00148148148148147*G0_0_0_2_2_1 + 0.0190476190476189*G0_0_0_2_2_2 + 0.00634920634920631*G0_0_0_2_2_3 + 0.0021164021164021*G0_0_0_2_2_4 - 0.00126984126984126*G0_0_0_2_2_5 - 0.000423280423280418*G0_0_0_2_3_0 - 0.000846560846560842*G0_0_0_2_3_1 + 0.00634920634920631*G0_0_0_2_3_2 + 0.0110052910052909*G0_0_0_2_3_3 + 0.0059259259259259*G0_0_0_2_3_4 + 0.00338624338624337*G0_0_0_2_3_5 + 0.00550264550264548*G0_0_0_2_4_0 - 0.00253968253968253*G0_0_0_2_4_1 + 0.0021164021164021*G0_0_0_2_4_2 + 0.0059259259259259*G0_0_0_2_4_3 + 0.0194708994708994*G0_0_0_2_4_4 + 0.00761904761904759*G0_0_0_2_4_5 + 0.00296296296296295*G0_0_0_2_5_0 - 0.00126984126984127*G0_0_0_2_5_1 - 0.00126984126984126*G0_0_0_2_5_2 + 0.00338624338624337*G0_0_0_2_5_3 + 0.00761904761904759*G0_0_0_2_5_4 + 0.00761904761904758*G0_0_0_2_5_5 - 0.00211640211640211*G0_0_0_3_0_0 + 0.00126984126984126*G0_0_0_3_0_1 - 0.000423280423280418*G0_0_0_3_0_2 - 0.000846560846560845*G0_0_0_3_0_3 - 0.00253968253968253*G0_0_0_3_0_4 - 0.00169312169312169*G0_0_0_3_0_5 + 0.00126984126984126*G0_0_0_3_1_0 - 0.00634920634920631*G0_0_0_3_1_1 - 0.000846560846560842*G0_0_0_3_1_2 - 0.00846560846560842*G0_0_0_3_1_3 + 0.00169312169312168*G0_0_0_3_1_4 - 0.000423280423280418*G0_0_0_3_2_0 - 0.000846560846560842*G0_0_0_3_2_1 + 0.00634920634920631*G0_0_0_3_2_2 + 0.0110052910052909*G0_0_0_3_2_3 + 0.0059259259259259*G0_0_0_3_2_4 + 0.00338624338624337*G0_0_0_3_2_5 - 0.000846560846560845*G0_0_0_3_3_0 - 0.00846560846560842*G0_0_0_3_3_1 + 0.0110052910052909*G0_0_0_3_3_2 + 0.00507936507936507*G0_0_0_3_3_3 - 0.00169312169312168*G0_0_0_3_3_4 - 0.00507936507936505*G0_0_0_3_3_5 - 0.00253968253968253*G0_0_0_3_4_0 + 0.00169312169312168*G0_0_0_3_4_1 + 0.0059259259259259*G0_0_0_3_4_2 - 0.00169312169312168*G0_0_0_3_4_3 - 0.0186243386243385*G0_0_0_3_4_4 - 0.0101587301587301*G0_0_0_3_4_5 - 0.00169312169312169*G0_0_0_3_5_0 + 0.00338624338624337*G0_0_0_3_5_2 - 0.00507936507936505*G0_0_0_3_5_3 - 0.0101587301587301*G0_0_0_3_5_4 - 0.0118518518518518*G0_0_0_3_5_5 - 0.0275132275132274*G0_0_0_4_0_0 + 0.00338624338624337*G0_0_0_4_0_1 + 0.00550264550264548*G0_0_0_4_0_2 - 0.00253968253968253*G0_0_0_4_0_3 - 0.0296296296296295*G0_0_0_4_0_4 - 0.0126984126984126*G0_0_0_4_0_5 + 0.00338624338624337*G0_0_0_4_1_0 - 0.00211640211640211*G0_0_0_4_1_1 - 0.00253968253968253*G0_0_0_4_1_2 + 0.00169312169312168*G0_0_0_4_1_3 + 0.0118518518518518*G0_0_0_4_1_4 + 0.00677248677248674*G0_0_0_4_1_5 + 0.00550264550264548*G0_0_0_4_2_0 - 0.00253968253968253*G0_0_0_4_2_1 + 0.0021164021164021*G0_0_0_4_2_2 + 0.0059259259259259*G0_0_0_4_2_3 + 0.0194708994708994*G0_0_0_4_2_4 + 0.00761904761904759*G0_0_0_4_2_5 - 0.00253968253968253*G0_0_0_4_3_0 + 0.00169312169312168*G0_0_0_4_3_1 + 0.0059259259259259*G0_0_0_4_3_2 - 0.00169312169312168*G0_0_0_4_3_3 - 0.0186243386243385*G0_0_0_4_3_4 - 0.0101587301587301*G0_0_0_4_3_5 - 0.0296296296296295*G0_0_0_4_4_0 + 0.0118518518518518*G0_0_0_4_4_1 + 0.0194708994708994*G0_0_0_4_4_2 - 0.0186243386243385*G0_0_0_4_4_3 - 0.147301587301587*G0_0_0_4_4_4 - 0.0389417989417988*G0_0_0_4_4_5 - 0.0126984126984126*G0_0_0_4_5_0 + 0.00677248677248674*G0_0_0_4_5_1 + 0.00761904761904759*G0_0_0_4_5_2 - 0.0101587301587301*G0_0_0_4_5_3 - 0.0389417989417988*G0_0_0_4_5_4 - 0.0287830687830686*G0_0_0_4_5_5 - 0.0232804232804232*G0_0_0_5_0_0 + 0.00507936507936505*G0_0_0_5_0_1 + 0.00296296296296295*G0_0_0_5_0_2 - 0.00169312169312169*G0_0_0_5_0_3 - 0.0126984126984126*G0_0_0_5_0_4 - 0.0211640211640211*G0_0_0_5_0_5 + 0.00507936507936505*G0_0_0_5_1_0 - 0.00634920634920631*G0_0_0_5_1_1 - 0.00126984126984127*G0_0_0_5_1_2 + 0.00677248677248674*G0_0_0_5_1_4 + 0.00846560846560842*G0_0_0_5_1_5 + 0.00296296296296295*G0_0_0_5_2_0 - 0.00126984126984127*G0_0_0_5_2_1 - 0.00126984126984126*G0_0_0_5_2_2 + 0.00338624338624337*G0_0_0_5_2_3 + 0.00761904761904759*G0_0_0_5_2_4 + 0.00761904761904758*G0_0_0_5_2_5 - 0.00169312169312169*G0_0_0_5_3_0 + 0.00338624338624337*G0_0_0_5_3_2 - 0.00507936507936505*G0_0_0_5_3_3 - 0.0101587301587301*G0_0_0_5_3_4 - 0.0118518518518518*G0_0_0_5_3_5 - 0.0126984126984126*G0_0_0_5_4_0 + 0.00677248677248674*G0_0_0_5_4_1 + 0.00761904761904759*G0_0_0_5_4_2 - 0.0101587301587301*G0_0_0_5_4_3 - 0.0389417989417988*G0_0_0_5_4_4 - 0.0287830687830686*G0_0_0_5_4_5 - 0.0211640211640211*G0_0_0_5_5_0 + 0.00846560846560842*G0_0_0_5_5_1 + 0.00761904761904758*G0_0_0_5_5_2 - 0.0118518518518518*G0_0_0_5_5_3 - 0.0287830687830686*G0_0_0_5_5_4 - 0.0558730158730155*G0_0_0_5_5_5 - 0.0634920634920632*G0_1_0_0_0_0 + 0.00529100529100527*G0_1_0_0_0_1 + 0.00634920634920632*G0_1_0_0_0_2 - 0.00211640211640211*G0_1_0_0_0_3 - 0.0275132275132274*G0_1_0_0_0_4 - 0.0232804232804232*G0_1_0_0_0_5 + 0.00529100529100527*G0_1_0_0_1_0 - 0.000740740740740738*G0_1_0_0_1_2 + 0.00126984126984126*G0_1_0_0_1_3 + 0.00338624338624337*G0_1_0_0_1_4 + 0.00507936507936505*G0_1_0_0_1_5 + 0.00634920634920632*G0_1_0_0_2_0 - 0.000740740740740739*G0_1_0_0_2_1 - 0.00253968253968252*G0_1_0_0_2_2 - 0.000423280423280417*G0_1_0_0_2_3 + 0.00550264550264548*G0_1_0_0_2_4 + 0.00296296296296295*G0_1_0_0_2_5 - 0.00211640211640211*G0_1_0_0_3_0 + 0.00126984126984126*G0_1_0_0_3_1 - 0.000423280423280417*G0_1_0_0_3_2 - 0.000846560846560843*G0_1_0_0_3_3 - 0.00253968253968253*G0_1_0_0_3_4 - 0.00169312169312169*G0_1_0_0_3_5 - 0.0275132275132274*G0_1_0_0_4_0 + 0.00338624338624337*G0_1_0_0_4_1 + 0.00550264550264548*G0_1_0_0_4_2 - 0.00253968253968253*G0_1_0_0_4_3 - 0.0296296296296295*G0_1_0_0_4_4 - 0.0126984126984126*G0_1_0_0_4_5 - 0.0232804232804232*G0_1_0_0_5_0 + 0.00507936507936505*G0_1_0_0_5_1 + 0.00296296296296295*G0_1_0_0_5_2 - 0.00169312169312169*G0_1_0_0_5_3 - 0.0126984126984126*G0_1_0_0_5_4 - 0.0211640211640211*G0_1_0_0_5_5 + 0.00529100529100527*G0_1_0_1_0_0 - 0.000740740740740738*G0_1_0_1_0_2 + 0.00126984126984126*G0_1_0_1_0_3 + 0.00338624338624337*G0_1_0_1_0_4 + 0.00507936507936505*G0_1_0_1_0_5 - 0.0158730158730158*G0_1_0_1_1_1 + 0.00211640211640211*G0_1_0_1_1_2 - 0.00634920634920632*G0_1_0_1_1_3 - 0.00211640211640211*G0_1_0_1_1_4 - 0.00634920634920632*G0_1_0_1_1_5 - 0.000740740740740738*G0_1_0_1_2_0 + 0.00211640211640211*G0_1_0_1_2_1 - 0.00148148148148147*G0_1_0_1_2_2 - 0.000846560846560839*G0_1_0_1_2_3 - 0.00253968253968253*G0_1_0_1_2_4 - 0.00126984126984126*G0_1_0_1_2_5 + 0.00126984126984126*G0_1_0_1_3_0 - 0.00634920634920632*G0_1_0_1_3_1 - 0.000846560846560839*G0_1_0_1_3_2 - 0.00846560846560842*G0_1_0_1_3_3 + 0.00169312169312168*G0_1_0_1_3_4 + 0.00338624338624337*G0_1_0_1_4_0 - 0.00211640211640211*G0_1_0_1_4_1 - 0.00253968253968253*G0_1_0_1_4_2 + 0.00169312169312169*G0_1_0_1_4_3 + 0.0118518518518518*G0_1_0_1_4_4 + 0.00677248677248674*G0_1_0_1_4_5 + 0.00507936507936505*G0_1_0_1_5_0 - 0.00634920634920632*G0_1_0_1_5_1 - 0.00126984126984126*G0_1_0_1_5_2 + 0.00677248677248674*G0_1_0_1_5_4 + 0.00846560846560842*G0_1_0_1_5_5 + 0.00634920634920632*G0_1_0_2_0_0 - 0.000740740740740738*G0_1_0_2_0_1 - 0.00253968253968252*G0_1_0_2_0_2 - 0.000423280423280417*G0_1_0_2_0_3 + 0.00550264550264548*G0_1_0_2_0_4 + 0.00296296296296295*G0_1_0_2_0_5 - 0.000740740740740738*G0_1_0_2_1_0 + 0.00211640211640211*G0_1_0_2_1_1 - 0.00148148148148147*G0_1_0_2_1_2 - 0.000846560846560839*G0_1_0_2_1_3 - 0.00253968253968253*G0_1_0_2_1_4 - 0.00126984126984126*G0_1_0_2_1_5 - 0.00253968253968252*G0_1_0_2_2_0 - 0.00148148148148147*G0_1_0_2_2_1 + 0.0190476190476189*G0_1_0_2_2_2 + 0.00634920634920631*G0_1_0_2_2_3 + 0.00211640211640209*G0_1_0_2_2_4 - 0.00126984126984126*G0_1_0_2_2_5 - 0.000423280423280417*G0_1_0_2_3_0 - 0.000846560846560839*G0_1_0_2_3_1 + 0.00634920634920631*G0_1_0_2_3_2 + 0.0110052910052909*G0_1_0_2_3_3 + 0.0059259259259259*G0_1_0_2_3_4 + 0.00338624338624337*G0_1_0_2_3_5 + 0.00550264550264548*G0_1_0_2_4_0 - 0.00253968253968253*G0_1_0_2_4_1 + 0.00211640211640209*G0_1_0_2_4_2 + 0.0059259259259259*G0_1_0_2_4_3 + 0.0194708994708994*G0_1_0_2_4_4 + 0.00761904761904759*G0_1_0_2_4_5 + 0.00296296296296295*G0_1_0_2_5_0 - 0.00126984126984126*G0_1_0_2_5_1 - 0.00126984126984126*G0_1_0_2_5_2 + 0.00338624338624337*G0_1_0_2_5_3 + 0.00761904761904759*G0_1_0_2_5_4 + 0.00761904761904758*G0_1_0_2_5_5 - 0.00211640211640211*G0_1_0_3_0_0 + 0.00126984126984126*G0_1_0_3_0_1 - 0.000423280423280417*G0_1_0_3_0_2 - 0.000846560846560843*G0_1_0_3_0_3 - 0.00253968253968253*G0_1_0_3_0_4 - 0.00169312169312169*G0_1_0_3_0_5 + 0.00126984126984126*G0_1_0_3_1_0 - 0.00634920634920632*G0_1_0_3_1_1 - 0.000846560846560839*G0_1_0_3_1_2 - 0.00846560846560842*G0_1_0_3_1_3 + 0.00169312169312168*G0_1_0_3_1_4 - 0.000423280423280417*G0_1_0_3_2_0 - 0.000846560846560839*G0_1_0_3_2_1 + 0.00634920634920631*G0_1_0_3_2_2 + 0.0110052910052909*G0_1_0_3_2_3 + 0.0059259259259259*G0_1_0_3_2_4 + 0.00338624338624337*G0_1_0_3_2_5 - 0.000846560846560843*G0_1_0_3_3_0 - 0.00846560846560842*G0_1_0_3_3_1 + 0.0110052910052909*G0_1_0_3_3_2 + 0.00507936507936504*G0_1_0_3_3_3 - 0.00169312169312168*G0_1_0_3_3_4 - 0.00507936507936505*G0_1_0_3_3_5 - 0.00253968253968253*G0_1_0_3_4_0 + 0.00169312169312168*G0_1_0_3_4_1 + 0.0059259259259259*G0_1_0_3_4_2 - 0.00169312169312168*G0_1_0_3_4_3 - 0.0186243386243385*G0_1_0_3_4_4 - 0.0101587301587301*G0_1_0_3_4_5 - 0.00169312169312169*G0_1_0_3_5_0 + 0.00338624338624337*G0_1_0_3_5_2 - 0.00507936507936505*G0_1_0_3_5_3 - 0.0101587301587301*G0_1_0_3_5_4 - 0.0118518518518518*G0_1_0_3_5_5 - 0.0275132275132274*G0_1_0_4_0_0 + 0.00338624338624337*G0_1_0_4_0_1 + 0.00550264550264548*G0_1_0_4_0_2 - 0.00253968253968253*G0_1_0_4_0_3 - 0.0296296296296295*G0_1_0_4_0_4 - 0.0126984126984126*G0_1_0_4_0_5 + 0.00338624338624337*G0_1_0_4_1_0 - 0.00211640211640211*G0_1_0_4_1_1 - 0.00253968253968253*G0_1_0_4_1_2 + 0.00169312169312169*G0_1_0_4_1_3 + 0.0118518518518518*G0_1_0_4_1_4 + 0.00677248677248674*G0_1_0_4_1_5 + 0.00550264550264548*G0_1_0_4_2_0 - 0.00253968253968253*G0_1_0_4_2_1 + 0.00211640211640209*G0_1_0_4_2_2 + 0.0059259259259259*G0_1_0_4_2_3 + 0.0194708994708994*G0_1_0_4_2_4 + 0.00761904761904759*G0_1_0_4_2_5 - 0.00253968253968253*G0_1_0_4_3_0 + 0.00169312169312169*G0_1_0_4_3_1 + 0.0059259259259259*G0_1_0_4_3_2 - 0.00169312169312168*G0_1_0_4_3_3 - 0.0186243386243385*G0_1_0_4_3_4 - 0.0101587301587301*G0_1_0_4_3_5 - 0.0296296296296295*G0_1_0_4_4_0 + 0.0118518518518518*G0_1_0_4_4_1 + 0.0194708994708994*G0_1_0_4_4_2 - 0.0186243386243385*G0_1_0_4_4_3 - 0.147301587301587*G0_1_0_4_4_4 - 0.0389417989417988*G0_1_0_4_4_5 - 0.0126984126984126*G0_1_0_4_5_0 + 0.00677248677248674*G0_1_0_4_5_1 + 0.00761904761904759*G0_1_0_4_5_2 - 0.0101587301587301*G0_1_0_4_5_3 - 0.0389417989417988*G0_1_0_4_5_4 - 0.0287830687830687*G0_1_0_4_5_5 - 0.0232804232804232*G0_1_0_5_0_0 + 0.00507936507936505*G0_1_0_5_0_1 + 0.00296296296296295*G0_1_0_5_0_2 - 0.00169312169312169*G0_1_0_5_0_3 - 0.0126984126984126*G0_1_0_5_0_4 - 0.021164021164021*G0_1_0_5_0_5 + 0.00507936507936505*G0_1_0_5_1_0 - 0.00634920634920632*G0_1_0_5_1_1 - 0.00126984126984126*G0_1_0_5_1_2 + 0.00677248677248674*G0_1_0_5_1_4 + 0.00846560846560842*G0_1_0_5_1_5 + 0.00296296296296295*G0_1_0_5_2_0 - 0.00126984126984126*G0_1_0_5_2_1 - 0.00126984126984126*G0_1_0_5_2_2 + 0.00338624338624337*G0_1_0_5_2_3 + 0.00761904761904759*G0_1_0_5_2_4 + 0.00761904761904758*G0_1_0_5_2_5 - 0.00169312169312169*G0_1_0_5_3_0 + 0.00338624338624337*G0_1_0_5_3_2 - 0.00507936507936505*G0_1_0_5_3_3 - 0.0101587301587301*G0_1_0_5_3_4 - 0.0118518518518518*G0_1_0_5_3_5 - 0.0126984126984126*G0_1_0_5_4_0 + 0.00677248677248674*G0_1_0_5_4_1 + 0.00761904761904759*G0_1_0_5_4_2 - 0.0101587301587301*G0_1_0_5_4_3 - 0.0389417989417988*G0_1_0_5_4_4 - 0.0287830687830687*G0_1_0_5_4_5 - 0.021164021164021*G0_1_0_5_5_0 + 0.00846560846560842*G0_1_0_5_5_1 + 0.00761904761904758*G0_1_0_5_5_2 - 0.0118518518518518*G0_1_0_5_5_3 - 0.0287830687830687*G0_1_0_5_5_4 - 0.0558730158730155*G0_1_0_5_5_5;
    A[6] = A[9] + 0.015079365079365*G0_0_0_0_0_0 - 0.00111111111111111*G0_0_0_0_0_1 - 0.00111111111111111*G0_0_0_0_0_2 + 0.000105820105820108*G0_0_0_0_0_3 + 0.0079365079365079*G0_0_0_0_0_4 + 0.00370370370370369*G0_0_0_0_0_5 - 0.00111111111111111*G0_0_0_0_1_0 - 0.000264550264550263*G0_0_0_0_1_1 + 0.000343915343915342*G0_0_0_0_1_2 - 0.000423280423280423*G0_0_0_0_1_4 - 0.000529100529100528*G0_0_0_0_1_5 - 0.00111111111111111*G0_0_0_0_2_0 + 0.000343915343915342*G0_0_0_0_2_1 - 0.0011111111111111*G0_0_0_0_2_2 - 0.00126984126984126*G0_0_0_0_2_3 - 0.0039153439153439*G0_0_0_0_2_4 - 0.00126984126984126*G0_0_0_0_2_5 + 0.000105820105820108*G0_0_0_0_3_0 - 0.00126984126984126*G0_0_0_0_3_2 + 0.00296296296296294*G0_0_0_0_3_3 + 0.000634920634920634*G0_0_0_0_3_4 + 0.00232804232804232*G0_0_0_0_3_5 + 0.0079365079365079*G0_0_0_0_4_0 - 0.000423280423280423*G0_0_0_0_4_1 - 0.0039153439153439*G0_0_0_0_4_2 + 0.000634920634920634*G0_0_0_0_4_3 + 0.00507936507936507*G0_0_0_0_4_4 + 0.00338624338624337*G0_0_0_0_4_5 + 0.00370370370370369*G0_0_0_0_5_0 - 0.000529100529100528*G0_0_0_0_5_1 - 0.00126984126984126*G0_0_0_0_5_2 + 0.00232804232804232*G0_0_0_0_5_3 + 0.00338624338624337*G0_0_0_0_5_4 + 0.00507936507936505*G0_0_0_0_5_5 - 0.00111111111111111*G0_0_0_1_0_0 - 0.000264550264550263*G0_0_0_1_0_1 + 0.000343915343915342*G0_0_0_1_0_2 - 0.000423280423280423*G0_0_0_1_0_4 - 0.000529100529100528*G0_0_0_1_0_5 - 0.000264550264550263*G0_0_0_1_1_0 + 0.0087301587301587*G0_0_0_1_1_1 - 0.000264550264550264*G0_0_0_1_1_2 + 0.00158730158730158*G0_0_0_1_1_3 + 0.000529100529100528*G0_0_0_1_1_4 + 0.00158730158730158*G0_0_0_1_1_5 + 0.000343915343915342*G0_0_0_1_2_0 - 0.000264550264550264*G0_0_0_1_2_1 - 0.0011111111111111*G0_0_0_1_2_2 - 0.000529100529100526*G0_0_0_1_2_3 - 0.00042328042328042*G0_0_0_1_2_4 + 0.00158730158730158*G0_0_0_1_3_1 - 0.000529100529100526*G0_0_0_1_3_2 - 0.00105820105820105*G0_0_0_1_3_4 - 0.000423280423280423*G0_0_0_1_4_0 + 0.000529100529100528*G0_0_0_1_4_1 - 0.00042328042328042*G0_0_0_1_4_2 - 0.00105820105820105*G0_0_0_1_4_3 - 0.00550264550264548*G0_0_0_1_4_4 - 0.00105820105820105*G0_0_0_1_4_5 - 0.000529100529100528*G0_0_0_1_5_0 + 0.00158730158730158*G0_0_0_1_5_1 - 0.00105820105820105*G0_0_0_1_5_4 - 0.00111111111111111*G0_0_0_2_0_0 + 0.000343915343915342*G0_0_0_2_0_1 - 0.0011111111111111*G0_0_0_2_0_2 - 0.00126984126984126*G0_0_0_2_0_3 - 0.0039153439153439*G0_0_0_2_0_4 - 0.00126984126984126*G0_0_0_2_0_5 + 0.000343915343915342*G0_0_0_2_1_0 - 0.000264550264550264*G0_0_0_2_1_1 - 0.0011111111111111*G0_0_0_2_1_2 - 0.000529100529100526*G0_0_0_2_1_3 - 0.00042328042328042*G0_0_0_2_1_4 - 0.0011111111111111*G0_0_0_2_2_0 - 0.0011111111111111*G0_0_0_2_2_1 + 0.015079365079365*G0_0_0_2_2_2 + 0.00370370370370368*G0_0_0_2_2_3 + 0.00793650793650789*G0_0_0_2_2_4 + 0.000105820105820109*G0_0_0_2_2_5 - 0.00126984126984126*G0_0_0_2_3_0 - 0.000529100529100526*G0_0_0_2_3_1 + 0.00370370370370368*G0_0_0_2_3_2 + 0.00507936507936505*G0_0_0_2_3_3 + 0.00338624338624337*G0_0_0_2_3_4 + 0.00232804232804232*G0_0_0_2_3_5 - 0.0039153439153439*G0_0_0_2_4_0 - 0.00042328042328042*G0_0_0_2_4_1 + 0.00793650793650789*G0_0_0_2_4_2 + 0.00338624338624337*G0_0_0_2_4_3 + 0.00507936507936505*G0_0_0_2_4_4 + 0.000634920634920633*G0_0_0_2_4_5 - 0.00126984126984126*G0_0_0_2_5_0 + 0.000105820105820109*G0_0_0_2_5_2 + 0.00232804232804232*G0_0_0_2_5_3 + 0.000634920634920633*G0_0_0_2_5_4 + 0.00296296296296295*G0_0_0_2_5_5 + 0.000105820105820108*G0_0_0_3_0_0 - 0.00126984126984126*G0_0_0_3_0_2 + 0.00296296296296294*G0_0_0_3_0_3 + 0.000634920634920633*G0_0_0_3_0_4 + 0.00232804232804232*G0_0_0_3_0_5 + 0.00158730158730158*G0_0_0_3_1_1 - 0.000529100529100526*G0_0_0_3_1_2 - 0.00105820105820105*G0_0_0_3_1_4 - 0.00126984126984126*G0_0_0_3_2_0 - 0.000529100529100526*G0_0_0_3_2_1 + 0.00370370370370368*G0_0_0_3_2_2 + 0.00507936507936505*G0_0_0_3_2_3 + 0.00338624338624337*G0_0_0_3_2_4 + 0.00232804232804232*G0_0_0_3_2_5 + 0.00296296296296294*G0_0_0_3_3_0 + 0.00507936507936505*G0_0_0_3_3_2 - 0.0317460317460316*G0_0_0_3_3_3 - 0.0038095238095238*G0_0_0_3_3_4 - 0.0105820105820105*G0_0_0_3_3_5 + 0.000634920634920634*G0_0_0_3_4_0 - 0.00105820105820105*G0_0_0_3_4_1 + 0.00338624338624337*G0_0_0_3_4_2 - 0.0038095238095238*G0_0_0_3_4_3 + 0.00973544973544969*G0_0_0_3_4_4 - 0.00253968253968253*G0_0_0_3_4_5 + 0.00232804232804232*G0_0_0_3_5_0 + 0.00232804232804232*G0_0_0_3_5_2 - 0.0105820105820105*G0_0_0_3_5_3 - 0.00253968253968253*G0_0_0_3_5_4 - 0.0105820105820105*G0_0_0_3_5_5 + 0.0079365079365079*G0_0_0_4_0_0 - 0.000423280423280423*G0_0_0_4_0_1 - 0.0039153439153439*G0_0_0_4_0_2 + 0.000634920634920633*G0_0_0_4_0_3 + 0.00507936507936506*G0_0_0_4_0_4 + 0.00338624338624337*G0_0_0_4_0_5 - 0.000423280423280423*G0_0_0_4_1_0 + 0.000529100529100527*G0_0_0_4_1_1 - 0.00042328042328042*G0_0_0_4_1_2 - 0.00105820105820105*G0_0_0_4_1_3 - 0.00550264550264548*G0_0_0_4_1_4 - 0.00105820105820105*G0_0_0_4_1_5 - 0.0039153439153439*G0_0_0_4_2_0 - 0.00042328042328042*G0_0_0_4_2_1 + 0.00793650793650789*G0_0_0_4_2_2 + 0.00338624338624337*G0_0_0_4_2_3 + 0.00507936507936505*G0_0_0_4_2_4 + 0.000634920634920633*G0_0_0_4_2_5 + 0.000634920634920634*G0_0_0_4_3_0 - 0.00105820105820105*G0_0_0_4_3_1 + 0.00338624338624337*G0_0_0_4_3_2 - 0.0038095238095238*G0_0_0_4_3_3 + 0.00973544973544969*G0_0_0_4_3_4 - 0.00253968253968253*G0_0_0_4_3_5 + 0.00507936507936506*G0_0_0_4_4_0 - 0.00550264550264548*G0_0_0_4_4_1 + 0.00507936507936505*G0_0_0_4_4_2 + 0.00973544973544969*G0_0_0_4_4_3 + 0.0901587301587298*G0_0_0_4_4_4 + 0.00973544973544971*G0_0_0_4_4_5 + 0.00338624338624337*G0_0_0_4_5_0 - 0.00105820105820105*G0_0_0_4_5_1 + 0.000634920634920633*G0_0_0_4_5_2 - 0.00253968253968253*G0_0_0_4_5_3 + 0.00973544973544971*G0_0_0_4_5_4 - 0.00380952380952379*G0_0_0_4_5_5 + 0.00370370370370369*G0_0_0_5_0_0 - 0.000529100529100528*G0_0_0_5_0_1 - 0.00126984126984126*G0_0_0_5_0_2 + 0.00232804232804232*G0_0_0_5_0_3 + 0.00338624338624337*G0_0_0_5_0_4 + 0.00507936507936505*G0_0_0_5_0_5 - 0.000529100529100528*G0_0_0_5_1_0 + 0.00158730158730158*G0_0_0_5_1_1 - 0.00105820105820105*G0_0_0_5_1_4 - 0.00126984126984126*G0_0_0_5_2_0 + 0.000105820105820109*G0_0_0_5_2_2 + 0.00232804232804232*G0_0_0_5_2_3 + 0.000634920634920633*G0_0_0_5_2_4 + 0.00296296296296295*G0_0_0_5_2_5 + 0.00232804232804232*G0_0_0_5_3_0 + 0.00232804232804232*G0_0_0_5_3_2 - 0.0105820105820105*G0_0_0_5_3_3 - 0.00253968253968253*G0_0_0_5_3_4 - 0.0105820105820105*G0_0_0_5_3_5 + 0.00338624338624337*G0_0_0_5_4_0 - 0.00105820105820105*G0_0_0_5_4_1 + 0.000634920634920633*G0_0_0_5_4_2 - 0.00253968253968253*G0_0_0_5_4_3 + 0.0097354497354497*G0_0_0_5_4_4 - 0.00380952380952378*G0_0_0_5_4_5 + 0.00507936507936505*G0_0_0_5_5_0 + 0.00296296296296295*G0_0_0_5_5_2 - 0.0105820105820105*G0_0_0_5_5_3 - 0.00380952380952378*G0_0_0_5_5_4 - 0.0317460317460315*G0_0_0_5_5_5 + 0.015079365079365*G0_0_1_0_0_0 - 0.00206349206349205*G0_0_1_0_0_1 - 0.001005291005291*G0_0_1_0_0_2 - 0.00116402116402115*G0_0_1_0_0_3 + 0.00582010582010579*G0_0_1_0_0_4 + 0.00158730158730159*G0_0_1_0_0_5 - 0.00206349206349205*G0_0_1_0_1_0 + 0.00502645502645499*G0_0_1_0_1_1 - 0.000502645502645498*G0_0_1_0_1_2 + 0.00253968253968252*G0_0_1_0_1_3 - 0.000211640211640213*G0_0_1_0_1_4 + 0.0043386243386243*G0_0_1_0_1_5 - 0.001005291005291*G0_0_1_0_2_0 - 0.000502645502645498*G0_0_1_0_2_1 + 0.00079365079365079*G0_0_1_0_2_2 - 0.00169312169312168*G0_0_1_0_2_3 - 0.002010582010582*G0_0_1_0_2_4 - 0.00232804232804232*G0_0_1_0_2_5 - 0.00116402116402115*G0_0_1_0_3_0 + 0.00253968253968252*G0_0_1_0_3_1 - 0.00169312169312168*G0_0_1_0_3_2 + 0.00804232804232799*G0_0_1_0_3_3 + 0.00275132275132274*G0_0_1_0_3_4 + 0.00698412698412694*G0_0_1_0_3_5 + 0.00582010582010579*G0_0_1_0_4_0 - 0.000211640211640213*G0_0_1_0_4_1 - 0.002010582010582*G0_0_1_0_4_2 + 0.00275132275132274*G0_0_1_0_4_3 + 0.00761904761904759*G0_0_1_0_4_4 + 0.00507936507936506*G0_0_1_0_4_5 + 0.00158730158730159*G0_0_1_0_5_0 + 0.0043386243386243*G0_0_1_0_5_1 - 0.00232804232804232*G0_0_1_0_5_2 + 0.00698412698412694*G0_0_1_0_5_3 + 0.00507936507936506*G0_0_1_0_5_4 + 0.016084656084656*G0_0_1_0_5_5 - 0.00206349206349205*G0_0_1_1_0_0 + 0.00502645502645499*G0_0_1_1_0_1 - 0.000502645502645498*G0_0_1_1_0_2 + 0.00253968253968252*G0_0_1_1_0_3 - 0.000211640211640213*G0_0_1_1_0_4 + 0.0043386243386243*G0_0_1_1_0_5 + 0.00502645502645499*G0_0_1_1_1_0 - 0.0499999999999997*G0_0_1_1_1_1 + 0.00449735449735447*G0_0_1_1_1_2 - 0.0195767195767195*G0_0_1_1_1_3 - 0.00158730158730158*G0_0_1_1_1_4 - 0.0216931216931215*G0_0_1_1_1_5 - 0.000502645502645498*G0_0_1_1_2_0 + 0.00449735449735447*G0_0_1_1_2_1 - 0.000793650793650789*G0_0_1_1_2_2 + 0.00412698412698411*G0_0_1_1_2_3 + 0.000634920634920632*G0_0_1_1_2_4 + 0.00275132275132274*G0_0_1_1_2_5 + 0.00253968253968252*G0_0_1_1_3_0 - 0.0195767195767194*G0_0_1_1_3_1 + 0.00412698412698411*G0_0_1_1_3_2 - 0.0190476190476189*G0_0_1_1_3_3 - 0.0019047619047619*G0_0_1_1_3_4 - 0.0105820105820105*G0_0_1_1_3_5 - 0.000211640211640213*G0_0_1_1_4_0 - 0.00158730158730158*G0_0_1_1_4_1 + 0.000634920634920632*G0_0_1_1_4_2 - 0.0019047619047619*G0_0_1_1_4_3 - 0.00253968253968253*G0_0_1_1_4_4 - 0.00232804232804232*G0_0_1_1_4_5 + 0.0043386243386243*G0_0_1_1_5_0 - 0.0216931216931215*G0_0_1_1_5_1 + 0.00275132275132274*G0_0_1_1_5_2 - 0.0105820105820105*G0_0_1_1_5_3 - 0.00232804232804232*G0_0_1_1_5_4 - 0.0232804232804231*G0_0_1_1_5_5 - 0.001005291005291*G0_0_1_2_0_0 - 0.000502645502645498*G0_0_1_2_0_1 + 0.00079365079365079*G0_0_1_2_0_2 - 0.00169312169312168*G0_0_1_2_0_3 - 0.002010582010582*G0_0_1_2_0_4 - 0.00232804232804232*G0_0_1_2_0_5 - 0.000502645502645498*G0_0_1_2_1_0 + 0.00449735449735447*G0_0_1_2_1_1 - 0.000793650793650789*G0_0_1_2_1_2 + 0.0041269841269841*G0_0_1_2_1_3 + 0.000634920634920632*G0_0_1_2_1_4 + 0.00275132275132274*G0_0_1_2_1_5 + 0.00079365079365079*G0_0_1_2_2_0 - 0.000793650793650789*G0_0_1_2_2_1 - 0.00238095238095238*G0_0_1_2_2_2 - 0.00264550264550263*G0_0_1_2_2_3 - 0.000529100529100529*G0_0_1_2_2_4 - 0.00158730158730158*G0_0_1_2_2_5 - 0.00169312169312168*G0_0_1_2_3_0 + 0.0041269841269841*G0_0_1_2_3_1 - 0.00264550264550263*G0_0_1_2_3_2 + 0.0105820105820105*G0_0_1_2_3_3 + 0.00211640211640211*G0_0_1_2_3_4 + 0.00656084656084653*G0_0_1_2_3_5 - 0.002010582010582*G0_0_1_2_4_0 + 0.000634920634920632*G0_0_1_2_4_1 - 0.000529100529100529*G0_0_1_2_4_2 + 0.00211640211640211*G0_0_1_2_4_3 - 0.00211640211640211*G0_0_1_2_4_4 + 0.0019047619047619*G0_0_1_2_4_5 - 0.00232804232804232*G0_0_1_2_5_0 + 0.00275132275132274*G0_0_1_2_5_1 - 0.00158730158730158*G0_0_1_2_5_2 + 0.00656084656084653*G0_0_1_2_5_3 + 0.0019047619047619*G0_0_1_2_5_4 + 0.0101587301587301*G0_0_1_2_5_5 - 0.00116402116402115*G0_0_1_3_0_0 + 0.00253968253968252*G0_0_1_3_0_1 - 0.00169312169312168*G0_0_1_3_0_2 + 0.00804232804232799*G0_0_1_3_0_3 + 0.00275132275132274*G0_0_1_3_0_4 + 0.00698412698412694*G0_0_1_3_0_5 + 0.00253968253968252*G0_0_1_3_1_0 - 0.0195767195767194*G0_0_1_3_1_1 + 0.0041269841269841*G0_0_1_3_1_2 - 0.0190476190476189*G0_0_1_3_1_3 - 0.00190476190476189*G0_0_1_3_1_4 - 0.0105820105820105*G0_0_1_3_1_5 - 0.00169312169312168*G0_0_1_3_2_0 + 0.0041269841269841*G0_0_1_3_2_1 - 0.00264550264550263*G0_0_1_3_2_2 + 0.0105820105820105*G0_0_1_3_2_3 + 0.00211640211640211*G0_0_1_3_2_4 + 0.00656084656084653*G0_0_1_3_2_5 + 0.00804232804232799*G0_0_1_3_3_0 - 0.0190476190476189*G0_0_1_3_3_1 + 0.0105820105820105*G0_0_1_3_3_2 - 0.072380952380952*G0_0_1_3_3_3 - 0.0122751322751322*G0_0_1_3_3_4 - 0.0292063492063491*G0_0_1_3_3_5 + 0.00275132275132274*G0_0_1_3_4_0 - 0.0019047619047619*G0_0_1_3_4_1 + 0.00211640211640211*G0_0_1_3_4_2 - 0.0122751322751322*G0_0_1_3_4_3 - 0.000423280423280422*G0_0_1_3_4_4 - 0.00931216931216927*G0_0_1_3_4_5 + 0.00698412698412694*G0_0_1_3_5_0 - 0.0105820105820105*G0_0_1_3_5_1 + 0.00656084656084653*G0_0_1_3_5_2 - 0.0292063492063491*G0_0_1_3_5_3 - 0.00931216931216927*G0_0_1_3_5_4 - 0.0342857142857141*G0_0_1_3_5_5 + 0.00582010582010579*G0_0_1_4_0_0 - 0.000211640211640213*G0_0_1_4_0_1 - 0.002010582010582*G0_0_1_4_0_2 + 0.00275132275132274*G0_0_1_4_0_3 + 0.00761904761904759*G0_0_1_4_0_4 + 0.00507936507936506*G0_0_1_4_0_5 - 0.000211640211640213*G0_0_1_4_1_0 - 0.00158730158730158*G0_0_1_4_1_1 + 0.000634920634920632*G0_0_1_4_1_2 - 0.0019047619047619*G0_0_1_4_1_3 - 0.00253968253968253*G0_0_1_4_1_4 - 0.00232804232804231*G0_0_1_4_1_5 - 0.002010582010582*G0_0_1_4_2_0 + 0.000634920634920632*G0_0_1_4_2_1 - 0.000529100529100529*G0_0_1_4_2_2 + 0.00211640211640211*G0_0_1_4_2_3 - 0.00211640211640211*G0_0_1_4_2_4 + 0.0019047619047619*G0_0_1_4_2_5 + 0.00275132275132274*G0_0_1_4_3_0 - 0.0019047619047619*G0_0_1_4_3_1 + 0.00211640211640211*G0_0_1_4_3_2 - 0.0122751322751322*G0_0_1_4_3_3 - 0.000423280423280421*G0_0_1_4_3_4 - 0.00931216931216927*G0_0_1_4_3_5 + 0.00761904761904759*G0_0_1_4_4_0 - 0.00253968253968253*G0_0_1_4_4_1 - 0.00211640211640211*G0_0_1_4_4_2 - 0.000423280423280421*G0_0_1_4_4_3 + 0.0342857142857141*G0_0_1_4_4_4 + 0.00126984126984127*G0_0_1_4_4_5 + 0.00507936507936506*G0_0_1_4_5_0 - 0.00232804232804232*G0_0_1_4_5_1 + 0.00190476190476189*G0_0_1_4_5_2 - 0.00931216931216927*G0_0_1_4_5_3 + 0.00126984126984127*G0_0_1_4_5_4 - 0.0156613756613756*G0_0_1_4_5_5 + 0.00158730158730159*G0_0_1_5_0_0 + 0.0043386243386243*G0_0_1_5_0_1 - 0.00232804232804232*G0_0_1_5_0_2 + 0.00698412698412694*G0_0_1_5_0_3 + 0.00507936507936506*G0_0_1_5_0_4 + 0.016084656084656*G0_0_1_5_0_5 + 0.0043386243386243*G0_0_1_5_1_0 - 0.0216931216931215*G0_0_1_5_1_1 + 0.00275132275132274*G0_0_1_5_1_2 - 0.0105820105820105*G0_0_1_5_1_3 - 0.00232804232804232*G0_0_1_5_1_4 - 0.0232804232804231*G0_0_1_5_1_5 - 0.00232804232804232*G0_0_1_5_2_0 + 0.00275132275132274*G0_0_1_5_2_1 - 0.00158730158730158*G0_0_1_5_2_2 + 0.00656084656084653*G0_0_1_5_2_3 + 0.0019047619047619*G0_0_1_5_2_4 + 0.0101587301587301*G0_0_1_5_2_5 + 0.00698412698412694*G0_0_1_5_3_0 - 0.0105820105820105*G0_0_1_5_3_1 + 0.00656084656084653*G0_0_1_5_3_2 - 0.0292063492063491*G0_0_1_5_3_3 - 0.00931216931216927*G0_0_1_5_3_4 - 0.0342857142857141*G0_0_1_5_3_5 + 0.00507936507936506*G0_0_1_5_4_0 - 0.00232804232804231*G0_0_1_5_4_1 + 0.00190476190476189*G0_0_1_5_4_2 - 0.00931216931216927*G0_0_1_5_4_3 + 0.00126984126984127*G0_0_1_5_4_4 - 0.0156613756613756*G0_0_1_5_4_5 + 0.016084656084656*G0_0_1_5_5_0 - 0.0232804232804231*G0_0_1_5_5_1 + 0.0101587301587301*G0_0_1_5_5_2 - 0.0342857142857141*G0_0_1_5_5_3 - 0.0156613756613756*G0_0_1_5_5_4 - 0.118095238095237*G0_0_1_5_5_5;
    A[35] = -A[33] + 0.0825396825396821*G0_0_0_0_0_0 - 0.0059259259259259*G0_0_0_0_0_1 - 0.008042328042328*G0_0_0_0_0_2 + 0.00338624338624338*G0_0_0_0_0_3 + 0.0380952380952379*G0_0_0_0_0_4 + 0.0296296296296295*G0_0_0_0_0_5 - 0.0059259259259259*G0_0_0_0_1_0 - 0.0042328042328042*G0_0_0_0_1_1 + 0.00169312169312168*G0_0_0_0_1_2 - 0.00338624338624336*G0_0_0_0_1_3 - 0.00423280423280422*G0_0_0_0_1_4 - 0.00931216931216926*G0_0_0_0_1_5 - 0.008042328042328*G0_0_0_0_2_0 + 0.00169312169312169*G0_0_0_0_2_1 + 0.000846560846560844*G0_0_0_0_2_2 - 0.0101587301587301*G0_0_0_0_2_4 - 0.00338624338624338*G0_0_0_0_2_5 + 0.00338624338624338*G0_0_0_0_3_0 - 0.00338624338624336*G0_0_0_0_3_1 - 0.00169312169312168*G0_0_0_0_3_3 + 0.00169312169312169*G0_0_0_0_3_4 + 0.0380952380952379*G0_0_0_0_4_0 - 0.00423280423280422*G0_0_0_0_4_1 - 0.0101587301587301*G0_0_0_0_4_2 + 0.00169312169312169*G0_0_0_0_4_3 + 0.0355555555555554*G0_0_0_0_4_4 + 0.0152380952380952*G0_0_0_0_4_5 + 0.0296296296296295*G0_0_0_0_5_0 - 0.00931216931216926*G0_0_0_0_5_1 - 0.00338624338624338*G0_0_0_0_5_2 + 0.0152380952380952*G0_0_0_0_5_4 + 0.0186243386243385*G0_0_0_0_5_5 - 0.0059259259259259*G0_0_0_1_0_0 - 0.0042328042328042*G0_0_0_1_0_1 + 0.00169312169312169*G0_0_0_1_0_2 - 0.00338624338624336*G0_0_0_1_0_3 - 0.00423280423280422*G0_0_0_1_0_4 - 0.00931216931216926*G0_0_0_1_0_5 - 0.0042328042328042*G0_0_0_1_1_0 + 0.0698412698412694*G0_0_0_1_1_1 - 0.00634920634920631*G0_0_0_1_1_2 + 0.0253968253968253*G0_0_0_1_1_3 + 0.00423280423280422*G0_0_0_1_1_4 + 0.0253968253968253*G0_0_0_1_1_5 + 0.00169312169312169*G0_0_0_1_2_0 - 0.00634920634920632*G0_0_0_1_2_1 + 0.000846560846560841*G0_0_0_1_2_2 - 0.00338624338624337*G0_0_0_1_2_3 + 0.00169312169312169*G0_0_0_1_2_4 - 0.000846560846560841*G0_0_0_1_2_5 - 0.00338624338624336*G0_0_0_1_3_0 + 0.0253968253968253*G0_0_0_1_3_1 - 0.00338624338624337*G0_0_0_1_3_2 + 0.0253968253968253*G0_0_0_1_3_3 - 0.00169312169312168*G0_0_0_1_3_4 + 0.00846560846560842*G0_0_0_1_3_5 - 0.00423280423280422*G0_0_0_1_4_0 + 0.00423280423280422*G0_0_0_1_4_1 + 0.00169312169312169*G0_0_0_1_4_2 - 0.00169312169312168*G0_0_0_1_4_3 - 0.0186243386243386*G0_0_0_1_4_4 - 0.00677248677248675*G0_0_0_1_4_5 - 0.00931216931216926*G0_0_0_1_5_0 + 0.0253968253968252*G0_0_0_1_5_1 - 0.000846560846560841*G0_0_0_1_5_2 + 0.00846560846560842*G0_0_0_1_5_3 - 0.00677248677248675*G0_0_0_1_5_4 + 0.00846560846560841*G0_0_0_1_5_5 - 0.00804232804232801*G0_0_0_2_0_0 + 0.00169312169312169*G0_0_0_2_0_1 + 0.000846560846560844*G0_0_0_2_0_2 - 0.0101587301587301*G0_0_0_2_0_4 - 0.00338624338624337*G0_0_0_2_0_5 + 0.00169312169312169*G0_0_0_2_1_0 - 0.00634920634920631*G0_0_0_2_1_1 + 0.000846560846560841*G0_0_0_2_1_2 - 0.00338624338624337*G0_0_0_2_1_3 + 0.00169312169312169*G0_0_0_2_1_4 - 0.000846560846560841*G0_0_0_2_1_5 + 0.000846560846560844*G0_0_0_2_2_0 + 0.000846560846560841*G0_0_0_2_2_1 + 0.00846560846560843*G0_0_0_2_2_4 + 0.00253968253968253*G0_0_0_2_2_5 - 0.00338624338624337*G0_0_0_2_3_1 - 0.0135449735449735*G0_0_0_2_3_3 - 0.00338624338624337*G0_0_0_2_3_4 - 0.00507936507936506*G0_0_0_2_3_5 - 0.0101587301587301*G0_0_0_2_4_0 + 0.00169312169312169*G0_0_0_2_4_1 + 0.00846560846560843*G0_0_0_2_4_2 - 0.00338624338624337*G0_0_0_2_4_3 - 0.0135449735449735*G0_0_0_2_4_4 - 0.00846560846560843*G0_0_0_2_4_5 - 0.00338624338624338*G0_0_0_2_5_0 - 0.00084656084656084*G0_0_0_2_5_1 + 0.00253968253968253*G0_0_0_2_5_2 - 0.00507936507936506*G0_0_0_2_5_3 - 0.00846560846560843*G0_0_0_2_5_4 - 0.0101587301587301*G0_0_0_2_5_5 + 0.00338624338624338*G0_0_0_3_0_0 - 0.00338624338624336*G0_0_0_3_0_1 - 0.00169312169312168*G0_0_0_3_0_3 + 0.00169312169312169*G0_0_0_3_0_4 - 0.00338624338624336*G0_0_0_3_1_0 + 0.0253968253968253*G0_0_0_3_1_1 - 0.00338624338624337*G0_0_0_3_1_2 + 0.0253968253968253*G0_0_0_3_1_3 - 0.00169312169312169*G0_0_0_3_1_4 + 0.00846560846560842*G0_0_0_3_1_5 - 0.00338624338624337*G0_0_0_3_2_1 - 0.0135449735449735*G0_0_0_3_2_3 - 0.00338624338624337*G0_0_0_3_2_4 - 0.00507936507936506*G0_0_0_3_2_5 - 0.00169312169312168*G0_0_0_3_3_0 + 0.0253968253968253*G0_0_0_3_3_1 - 0.0135449735449735*G0_0_0_3_3_2 + 0.0203174603174602*G0_0_0_3_3_3 + 0.00677248677248675*G0_0_0_3_3_4 + 0.0135449735449735*G0_0_0_3_3_5 + 0.00169312169312169*G0_0_0_3_4_0 - 0.00169312169312168*G0_0_0_3_4_1 - 0.00338624338624337*G0_0_0_3_4_2 + 0.00677248677248675*G0_0_0_3_4_3 + 0.0338624338624337*G0_0_0_3_4_4 + 0.0135449735449735*G0_0_0_3_4_5 + 0.00846560846560842*G0_0_0_3_5_1 - 0.00507936507936506*G0_0_0_3_5_2 + 0.0135449735449735*G0_0_0_3_5_3 + 0.0135449735449735*G0_0_0_3_5_4 + 0.0203174603174602*G0_0_0_3_5_5 + 0.0380952380952379*G0_0_0_4_0_0 - 0.00423280423280422*G0_0_0_4_0_1 - 0.0101587301587301*G0_0_0_4_0_2 + 0.00169312169312169*G0_0_0_4_0_3 + 0.0355555555555554*G0_0_0_4_0_4 + 0.0152380952380952*G0_0_0_4_0_5 - 0.00423280423280422*G0_0_0_4_1_0 + 0.00423280423280422*G0_0_0_4_1_1 + 0.00169312169312169*G0_0_0_4_1_2 - 0.00169312169312168*G0_0_0_4_1_3 - 0.0186243386243386*G0_0_0_4_1_4 - 0.00677248677248675*G0_0_0_4_1_5 - 0.0101587301587301*G0_0_0_4_2_0 + 0.00169312169312169*G0_0_0_4_2_1 + 0.00846560846560843*G0_0_0_4_2_2 - 0.00338624338624337*G0_0_0_4_2_3 - 0.0135449735449735*G0_0_0_4_2_4 - 0.00846560846560843*G0_0_0_4_2_5 + 0.00169312169312169*G0_0_0_4_3_0 - 0.00169312169312168*G0_0_0_4_3_1 - 0.00338624338624337*G0_0_0_4_3_2 + 0.00677248677248675*G0_0_0_4_3_3 + 0.0338624338624337*G0_0_0_4_3_4 + 0.0135449735449735*G0_0_0_4_3_5 + 0.0355555555555554*G0_0_0_4_4_0 - 0.0186243386243386*G0_0_0_4_4_1 - 0.0135449735449735*G0_0_0_4_4_2 + 0.0338624338624337*G0_0_0_4_4_3 + 0.264126984126983*G0_0_0_4_4_4 + 0.054179894179894*G0_0_0_4_4_5 + 0.0152380952380952*G0_0_0_4_5_0 - 0.00677248677248675*G0_0_0_4_5_1 - 0.00846560846560843*G0_0_0_4_5_2 + 0.0135449735449735*G0_0_0_4_5_3 + 0.054179894179894*G0_0_0_4_5_4 + 0.0338624338624337*G0_0_0_4_5_5 + 0.0296296296296295*G0_0_0_5_0_0 - 0.00931216931216926*G0_0_0_5_0_1 - 0.00338624338624338*G0_0_0_5_0_2 + 0.0152380952380952*G0_0_0_5_0_4 + 0.0186243386243385*G0_0_0_5_0_5 - 0.00931216931216926*G0_0_0_5_1_0 + 0.0253968253968252*G0_0_0_5_1_1 - 0.000846560846560841*G0_0_0_5_1_2 + 0.00846560846560842*G0_0_0_5_1_3 - 0.00677248677248675*G0_0_0_5_1_4 + 0.00846560846560841*G0_0_0_5_1_5 - 0.00338624338624338*G0_0_0_5_2_0 - 0.000846560846560841*G0_0_0_5_2_1 + 0.00253968253968253*G0_0_0_5_2_2 - 0.00507936507936506*G0_0_0_5_2_3 - 0.00846560846560843*G0_0_0_5_2_4 - 0.0101587301587301*G0_0_0_5_2_5 + 0.00846560846560842*G0_0_0_5_3_1 - 0.00507936507936506*G0_0_0_5_3_2 + 0.0135449735449735*G0_0_0_5_3_3 + 0.0135449735449735*G0_0_0_5_3_4 + 0.0203174603174602*G0_0_0_5_3_5 + 0.0152380952380952*G0_0_0_5_4_0 - 0.00677248677248675*G0_0_0_5_4_1 - 0.00846560846560843*G0_0_0_5_4_2 + 0.0135449735449735*G0_0_0_5_4_3 + 0.054179894179894*G0_0_0_5_4_4 + 0.0338624338624337*G0_0_0_5_4_5 + 0.0186243386243385*G0_0_0_5_5_0 + 0.00846560846560841*G0_0_0_5_5_1 - 0.0101587301587301*G0_0_0_5_5_2 + 0.0203174603174602*G0_0_0_5_5_3 + 0.0338624338624337*G0_0_0_5_5_4 + 0.0812698412698408*G0_0_0_5_5_5 - 0.00634920634920631*G0_1_0_0_0_0 + 0.00253968253968252*G0_1_0_0_0_1 + 0.000423280423280422*G0_1_0_0_0_2 - 0.000846560846560842*G0_1_0_0_0_3 - 0.00423280423280421*G0_1_0_0_0_4 - 0.00423280423280421*G0_1_0_0_0_5 + 0.00253968253968252*G0_1_0_0_1_0 - 0.0063492063492063*G0_1_0_0_1_1 + 0.00042328042328042*G0_1_0_0_1_2 - 0.0042328042328042*G0_1_0_0_1_3 - 0.00084656084656084*G0_1_0_0_1_4 - 0.00423280423280421*G0_1_0_0_1_5 + 0.000423280423280422*G0_1_0_0_2_0 + 0.00042328042328042*G0_1_0_0_2_1 + 0.000423280423280417*G0_1_0_0_2_2 + 0.00169312169312168*G0_1_0_0_2_3 + 0.00169312169312168*G0_1_0_0_2_4 + 0.00169312169312168*G0_1_0_0_2_5 - 0.000846560846560842*G0_1_0_0_3_0 - 0.0042328042328042*G0_1_0_0_3_1 + 0.00169312169312168*G0_1_0_0_3_2 + 0.00169312169312168*G0_1_0_0_3_3 + 0.00338624338624336*G0_1_0_0_3_4 - 0.00169312169312168*G0_1_0_0_3_5 - 0.00423280423280421*G0_1_0_0_4_0 - 0.00084656084656084*G0_1_0_0_4_1 + 0.00169312169312168*G0_1_0_0_4_2 + 0.00338624338624336*G0_1_0_0_4_3 + 0.00169312169312167*G0_1_0_0_4_4 - 0.00169312169312169*G0_1_0_0_4_5 - 0.00423280423280421*G0_1_0_0_5_0 - 0.00423280423280421*G0_1_0_0_5_1 + 0.00169312169312168*G0_1_0_0_5_2 - 0.00169312169312168*G0_1_0_0_5_3 - 0.00169312169312169*G0_1_0_0_5_4 - 0.0152380952380951*G0_1_0_0_5_5 + 0.00253968253968252*G0_1_0_1_0_0 - 0.0063492063492063*G0_1_0_1_0_1 + 0.00042328042328042*G0_1_0_1_0_2 - 0.0042328042328042*G0_1_0_1_0_3 - 0.00084656084656084*G0_1_0_1_0_4 - 0.00423280423280421*G0_1_0_1_0_5 - 0.0063492063492063*G0_1_0_1_1_0 + 0.0761904761904758*G0_1_0_1_1_1 - 0.00634920634920632*G0_1_0_1_1_2 + 0.0253968253968253*G0_1_0_1_1_3 + 0.0253968253968253*G0_1_0_1_1_5 + 0.00042328042328042*G0_1_0_1_2_0 - 0.00634920634920632*G0_1_0_1_2_1 + 0.00253968253968252*G0_1_0_1_2_2 - 0.00423280423280422*G0_1_0_1_2_3 - 0.000846560846560845*G0_1_0_1_2_4 - 0.00423280423280421*G0_1_0_1_2_5 - 0.0042328042328042*G0_1_0_1_3_0 + 0.0253968253968253*G0_1_0_1_3_1 - 0.00423280423280422*G0_1_0_1_3_2 + 0.0338624338624337*G0_1_0_1_3_3 + 0.00846560846560843*G0_1_0_1_3_4 + 0.0169312169312169*G0_1_0_1_3_5 - 0.00084656084656084*G0_1_0_1_4_0 - 0.000846560846560844*G0_1_0_1_4_2 + 0.00846560846560842*G0_1_0_1_4_3 + 0.0101587301587301*G0_1_0_1_4_4 + 0.00846560846560843*G0_1_0_1_4_5 - 0.00423280423280421*G0_1_0_1_5_0 + 0.0253968253968252*G0_1_0_1_5_1 - 0.00423280423280421*G0_1_0_1_5_2 + 0.0169312169312169*G0_1_0_1_5_3 + 0.00846560846560843*G0_1_0_1_5_4 + 0.0338624338624337*G0_1_0_1_5_5 + 0.000423280423280422*G0_1_0_2_0_0 + 0.00042328042328042*G0_1_0_2_0_1 + 0.000423280423280417*G0_1_0_2_0_2 + 0.00169312169312168*G0_1_0_2_0_3 + 0.00169312169312168*G0_1_0_2_0_4 + 0.00169312169312168*G0_1_0_2_0_5 + 0.00042328042328042*G0_1_0_2_1_0 - 0.00634920634920632*G0_1_0_2_1_1 + 0.00253968253968252*G0_1_0_2_1_2 - 0.00423280423280422*G0_1_0_2_1_3 - 0.000846560846560845*G0_1_0_2_1_4 - 0.00423280423280421*G0_1_0_2_1_5 + 0.000423280423280417*G0_1_0_2_2_0 + 0.00253968253968252*G0_1_0_2_2_1 - 0.00634920634920629*G0_1_0_2_2_2 - 0.0042328042328042*G0_1_0_2_2_3 - 0.0042328042328042*G0_1_0_2_2_4 - 0.000846560846560844*G0_1_0_2_2_5 + 0.00169312169312168*G0_1_0_2_3_0 - 0.00423280423280422*G0_1_0_2_3_1 - 0.0042328042328042*G0_1_0_2_3_2 - 0.0152380952380952*G0_1_0_2_3_3 - 0.00169312169312168*G0_1_0_2_3_4 - 0.00169312169312169*G0_1_0_2_3_5 + 0.00169312169312168*G0_1_0_2_4_0 - 0.000846560846560844*G0_1_0_2_4_1 - 0.0042328042328042*G0_1_0_2_4_2 - 0.00169312169312168*G0_1_0_2_4_3 + 0.0016931216931217*G0_1_0_2_4_4 + 0.00338624338624337*G0_1_0_2_4_5 + 0.00169312169312168*G0_1_0_2_5_0 - 0.00423280423280421*G0_1_0_2_5_1 - 0.000846560846560844*G0_1_0_2_5_2 - 0.00169312169312169*G0_1_0_2_5_3 + 0.00338624338624337*G0_1_0_2_5_4 + 0.00169312169312168*G0_1_0_2_5_5 - 0.000846560846560842*G0_1_0_3_0_0 - 0.0042328042328042*G0_1_0_3_0_1 + 0.00169312169312168*G0_1_0_3_0_2 + 0.00169312169312169*G0_1_0_3_0_3 + 0.00338624338624337*G0_1_0_3_0_4 - 0.00169312169312168*G0_1_0_3_0_5 - 0.0042328042328042*G0_1_0_3_1_0 + 0.0253968253968253*G0_1_0_3_1_1 - 0.00423280423280422*G0_1_0_3_1_2 + 0.0338624338624337*G0_1_0_3_1_3 + 0.00846560846560842*G0_1_0_3_1_4 + 0.0169312169312169*G0_1_0_3_1_5 + 0.00169312169312168*G0_1_0_3_2_0 - 0.00423280423280422*G0_1_0_3_2_1 - 0.0042328042328042*G0_1_0_3_2_2 - 0.0152380952380952*G0_1_0_3_2_3 - 0.00169312169312168*G0_1_0_3_2_4 - 0.00169312169312169*G0_1_0_3_2_5 + 0.00169312169312168*G0_1_0_3_3_0 + 0.0338624338624337*G0_1_0_3_3_1 - 0.0152380952380952*G0_1_0_3_3_2 - 0.0203174603174602*G0_1_0_3_3_4 + 0.00338624338624337*G0_1_0_3_4_0 + 0.00846560846560842*G0_1_0_3_4_1 - 0.00169312169312168*G0_1_0_3_4_2 - 0.0203174603174602*G0_1_0_3_4_3 - 0.027089947089947*G0_1_0_3_4_4 - 0.0135449735449735*G0_1_0_3_4_5 - 0.00169312169312168*G0_1_0_3_5_0 + 0.0169312169312169*G0_1_0_3_5_1 - 0.00169312169312169*G0_1_0_3_5_2 - 0.0135449735449735*G0_1_0_3_5_4 - 0.00423280423280421*G0_1_0_4_0_0 - 0.00084656084656084*G0_1_0_4_0_1 + 0.00169312169312168*G0_1_0_4_0_2 + 0.00338624338624337*G0_1_0_4_0_3 + 0.00169312169312167*G0_1_0_4_0_4 - 0.00169312169312169*G0_1_0_4_0_5 - 0.00084656084656084*G0_1_0_4_1_0 - 0.000846560846560844*G0_1_0_4_1_2 + 0.00846560846560842*G0_1_0_4_1_3 + 0.0101587301587301*G0_1_0_4_1_4 + 0.00846560846560843*G0_1_0_4_1_5 + 0.00169312169312168*G0_1_0_4_2_0 - 0.000846560846560844*G0_1_0_4_2_1 - 0.0042328042328042*G0_1_0_4_2_2 - 0.00169312169312168*G0_1_0_4_2_3 + 0.0016931216931217*G0_1_0_4_2_4 + 0.00338624338624337*G0_1_0_4_2_5 + 0.00338624338624337*G0_1_0_4_3_0 + 0.00846560846560842*G0_1_0_4_3_1 - 0.00169312169312168*G0_1_0_4_3_2 - 0.0203174603174602*G0_1_0_4_3_3 - 0.027089947089947*G0_1_0_4_3_4 - 0.0135449735449735*G0_1_0_4_3_5 + 0.00169312169312167*G0_1_0_4_4_0 + 0.0101587301587301*G0_1_0_4_4_1 + 0.0016931216931217*G0_1_0_4_4_2 - 0.027089947089947*G0_1_0_4_4_3 - 0.0609523809523806*G0_1_0_4_4_4 - 0.027089947089947*G0_1_0_4_4_5 - 0.00169312169312169*G0_1_0_4_5_0 + 0.00846560846560843*G0_1_0_4_5_1 + 0.00338624338624337*G0_1_0_4_5_2 - 0.0135449735449735*G0_1_0_4_5_3 - 0.027089947089947*G0_1_0_4_5_4 - 0.0203174603174602*G0_1_0_4_5_5 - 0.00423280423280421*G0_1_0_5_0_0 - 0.00423280423280421*G0_1_0_5_0_1 + 0.00169312169312168*G0_1_0_5_0_2 - 0.00169312169312168*G0_1_0_5_0_3 - 0.00169312169312169*G0_1_0_5_0_4 - 0.0152380952380951*G0_1_0_5_0_5 - 0.00423280423280421*G0_1_0_5_1_0 + 0.0253968253968252*G0_1_0_5_1_1 - 0.00423280423280421*G0_1_0_5_1_2 + 0.0169312169312169*G0_1_0_5_1_3 + 0.00846560846560843*G0_1_0_5_1_4 + 0.0338624338624337*G0_1_0_5_1_5 + 0.00169312169312168*G0_1_0_5_2_0 - 0.00423280423280421*G0_1_0_5_2_1 - 0.000846560846560844*G0_1_0_5_2_2 - 0.00169312169312169*G0_1_0_5_2_3 + 0.00338624338624337*G0_1_0_5_2_4 + 0.00169312169312168*G0_1_0_5_2_5 - 0.00169312169312168*G0_1_0_5_3_0 + 0.0169312169312169*G0_1_0_5_3_1 - 0.00169312169312169*G0_1_0_5_3_2 - 0.0135449735449735*G0_1_0_5_3_4 - 0.00169312169312169*G0_1_0_5_4_0 + 0.00846560846560843*G0_1_0_5_4_1 + 0.00338624338624337*G0_1_0_5_4_2 - 0.0135449735449735*G0_1_0_5_4_3 - 0.027089947089947*G0_1_0_5_4_4 - 0.0203174603174602*G0_1_0_5_4_5 - 0.0152380952380951*G0_1_0_5_5_0 + 0.0338624338624337*G0_1_0_5_5_1 + 0.00169312169312168*G0_1_0_5_5_2 - 0.0203174603174602*G0_1_0_5_5_4;
    A[23] = -A[35] + 0.0825396825396821*G0_0_0_0_0_0 - 0.0059259259259259*G0_0_0_0_0_1 - 0.008042328042328*G0_0_0_0_0_2 + 0.00338624338624338*G0_0_0_0_0_3 + 0.0380952380952379*G0_0_0_0_0_4 + 0.0296296296296295*G0_0_0_0_0_5 - 0.0059259259259259*G0_0_0_0_1_0 - 0.0042328042328042*G0_0_0_0_1_1 + 0.00169312169312168*G0_0_0_0_1_2 - 0.00338624338624337*G0_0_0_0_1_3 - 0.00423280423280422*G0_0_0_0_1_4 - 0.00931216931216926*G0_0_0_0_1_5 - 0.008042328042328*G0_0_0_0_2_0 + 0.00169312169312169*G0_0_0_0_2_1 + 0.000846560846560844*G0_0_0_0_2_2 - 0.0101587301587301*G0_0_0_0_2_4 - 0.00338624338624338*G0_0_0_0_2_5 + 0.00338624338624338*G0_0_0_0_3_0 - 0.00338624338624336*G0_0_0_0_3_1 - 0.00169312169312168*G0_0_0_0_3_3 + 0.00169312169312169*G0_0_0_0_3_4 + 0.0380952380952379*G0_0_0_0_4_0 - 0.00423280423280422*G0_0_0_0_4_1 - 0.0101587301587301*G0_0_0_0_4_2 + 0.00169312169312169*G0_0_0_0_4_3 + 0.0355555555555554*G0_0_0_0_4_4 + 0.0152380952380952*G0_0_0_0_4_5 + 0.0296296296296295*G0_0_0_0_5_0 - 0.00931216931216926*G0_0_0_0_5_1 - 0.00338624338624338*G0_0_0_0_5_2 + 0.0152380952380952*G0_0_0_0_5_4 + 0.0186243386243385*G0_0_0_0_5_5 - 0.0059259259259259*G0_0_0_1_0_0 - 0.0042328042328042*G0_0_0_1_0_1 + 0.00169312169312169*G0_0_0_1_0_2 - 0.00338624338624337*G0_0_0_1_0_3 - 0.00423280423280422*G0_0_0_1_0_4 - 0.00931216931216926*G0_0_0_1_0_5 - 0.0042328042328042*G0_0_0_1_1_0 + 0.0698412698412694*G0_0_0_1_1_1 - 0.00634920634920631*G0_0_0_1_1_2 + 0.0253968253968253*G0_0_0_1_1_3 + 0.00423280423280422*G0_0_0_1_1_4 + 0.0253968253968253*G0_0_0_1_1_5 + 0.00169312169312169*G0_0_0_1_2_0 - 0.00634920634920632*G0_0_0_1_2_1 + 0.000846560846560841*G0_0_0_1_2_2 - 0.00338624338624337*G0_0_0_1_2_3 + 0.00169312169312169*G0_0_0_1_2_4 - 0.000846560846560841*G0_0_0_1_2_5 - 0.00338624338624336*G0_0_0_1_3_0 + 0.0253968253968253*G0_0_0_1_3_1 - 0.00338624338624337*G0_0_0_1_3_2 + 0.0253968253968253*G0_0_0_1_3_3 - 0.00169312169312168*G0_0_0_1_3_4 + 0.00846560846560842*G0_0_0_1_3_5 - 0.00423280423280422*G0_0_0_1_4_0 + 0.00423280423280422*G0_0_0_1_4_1 + 0.00169312169312169*G0_0_0_1_4_2 - 0.00169312169312168*G0_0_0_1_4_3 - 0.0186243386243386*G0_0_0_1_4_4 - 0.00677248677248675*G0_0_0_1_4_5 - 0.00931216931216926*G0_0_0_1_5_0 + 0.0253968253968252*G0_0_0_1_5_1 - 0.000846560846560841*G0_0_0_1_5_2 + 0.00846560846560842*G0_0_0_1_5_3 - 0.00677248677248675*G0_0_0_1_5_4 + 0.00846560846560841*G0_0_0_1_5_5 - 0.00804232804232801*G0_0_0_2_0_0 + 0.00169312169312169*G0_0_0_2_0_1 + 0.000846560846560844*G0_0_0_2_0_2 - 0.0101587301587301*G0_0_0_2_0_4 - 0.00338624338624337*G0_0_0_2_0_5 + 0.00169312169312169*G0_0_0_2_1_0 - 0.00634920634920631*G0_0_0_2_1_1 + 0.000846560846560841*G0_0_0_2_1_2 - 0.00338624338624337*G0_0_0_2_1_3 + 0.00169312169312169*G0_0_0_2_1_4 - 0.000846560846560841*G0_0_0_2_1_5 + 0.000846560846560844*G0_0_0_2_2_0 + 0.000846560846560841*G0_0_0_2_2_1 + 0.00846560846560843*G0_0_0_2_2_4 + 0.00253968253968253*G0_0_0_2_2_5 - 0.00338624338624337*G0_0_0_2_3_1 - 0.0135449735449735*G0_0_0_2_3_3 - 0.00338624338624337*G0_0_0_2_3_4 - 0.00507936507936506*G0_0_0_2_3_5 - 0.0101587301587301*G0_0_0_2_4_0 + 0.00169312169312169*G0_0_0_2_4_1 + 0.00846560846560843*G0_0_0_2_4_2 - 0.00338624338624337*G0_0_0_2_4_3 - 0.0135449735449735*G0_0_0_2_4_4 - 0.00846560846560843*G0_0_0_2_4_5 - 0.00338624338624338*G0_0_0_2_5_0 - 0.00084656084656084*G0_0_0_2_5_1 + 0.00253968253968253*G0_0_0_2_5_2 - 0.00507936507936506*G0_0_0_2_5_3 - 0.00846560846560843*G0_0_0_2_5_4 - 0.0101587301587301*G0_0_0_2_5_5 + 0.00338624338624338*G0_0_0_3_0_0 - 0.00338624338624336*G0_0_0_3_0_1 - 0.00169312169312168*G0_0_0_3_0_3 + 0.00169312169312169*G0_0_0_3_0_4 - 0.00338624338624336*G0_0_0_3_1_0 + 0.0253968253968253*G0_0_0_3_1_1 - 0.00338624338624337*G0_0_0_3_1_2 + 0.0253968253968253*G0_0_0_3_1_3 - 0.00169312169312169*G0_0_0_3_1_4 + 0.00846560846560842*G0_0_0_3_1_5 - 0.00338624338624337*G0_0_0_3_2_1 - 0.0135449735449735*G0_0_0_3_2_3 - 0.00338624338624337*G0_0_0_3_2_4 - 0.00507936507936506*G0_0_0_3_2_5 - 0.00169312169312168*G0_0_0_3_3_0 + 0.0253968253968253*G0_0_0_3_3_1 - 0.0135449735449735*G0_0_0_3_3_2 + 0.0203174603174602*G0_0_0_3_3_3 + 0.00677248677248674*G0_0_0_3_3_4 + 0.0135449735449735*G0_0_0_3_3_5 + 0.00169312169312169*G0_0_0_3_4_0 - 0.00169312169312169*G0_0_0_3_4_1 - 0.00338624338624337*G0_0_0_3_4_2 + 0.00677248677248674*G0_0_0_3_4_3 + 0.0338624338624337*G0_0_0_3_4_4 + 0.0135449735449735*G0_0_0_3_4_5 + 0.00846560846560842*G0_0_0_3_5_1 - 0.00507936507936506*G0_0_0_3_5_2 + 0.0135449735449735*G0_0_0_3_5_3 + 0.0135449735449735*G0_0_0_3_5_4 + 0.0203174603174602*G0_0_0_3_5_5 + 0.0380952380952379*G0_0_0_4_0_0 - 0.00423280423280422*G0_0_0_4_0_1 - 0.0101587301587301*G0_0_0_4_0_2 + 0.00169312169312169*G0_0_0_4_0_3 + 0.0355555555555554*G0_0_0_4_0_4 + 0.0152380952380952*G0_0_0_4_0_5 - 0.00423280423280422*G0_0_0_4_1_0 + 0.00423280423280422*G0_0_0_4_1_1 + 0.00169312169312169*G0_0_0_4_1_2 - 0.00169312169312168*G0_0_0_4_1_3 - 0.0186243386243386*G0_0_0_4_1_4 - 0.00677248677248675*G0_0_0_4_1_5 - 0.0101587301587301*G0_0_0_4_2_0 + 0.00169312169312169*G0_0_0_4_2_1 + 0.00846560846560843*G0_0_0_4_2_2 - 0.00338624338624337*G0_0_0_4_2_3 - 0.0135449735449735*G0_0_0_4_2_4 - 0.00846560846560843*G0_0_0_4_2_5 + 0.00169312169312169*G0_0_0_4_3_0 - 0.00169312169312168*G0_0_0_4_3_1 - 0.00338624338624337*G0_0_0_4_3_2 + 0.00677248677248674*G0_0_0_4_3_3 + 0.0338624338624337*G0_0_0_4_3_4 + 0.0135449735449735*G0_0_0_4_3_5 + 0.0355555555555554*G0_0_0_4_4_0 - 0.0186243386243386*G0_0_0_4_4_1 - 0.0135449735449735*G0_0_0_4_4_2 + 0.0338624338624337*G0_0_0_4_4_3 + 0.264126984126983*G0_0_0_4_4_4 + 0.054179894179894*G0_0_0_4_4_5 + 0.0152380952380952*G0_0_0_4_5_0 - 0.00677248677248675*G0_0_0_4_5_1 - 0.00846560846560843*G0_0_0_4_5_2 + 0.0135449735449735*G0_0_0_4_5_3 + 0.054179894179894*G0_0_0_4_5_4 + 0.0338624338624337*G0_0_0_4_5_5 + 0.0296296296296295*G0_0_0_5_0_0 - 0.00931216931216926*G0_0_0_5_0_1 - 0.00338624338624338*G0_0_0_5_0_2 + 0.0152380952380952*G0_0_0_5_0_4 + 0.0186243386243385*G0_0_0_5_0_5 - 0.00931216931216926*G0_0_0_5_1_0 + 0.0253968253968252*G0_0_0_5_1_1 - 0.000846560846560841*G0_0_0_5_1_2 + 0.00846560846560842*G0_0_0_5_1_3 - 0.00677248677248675*G0_0_0_5_1_4 + 0.00846560846560841*G0_0_0_5_1_5 - 0.00338624338624338*G0_0_0_5_2_0 - 0.000846560846560841*G0_0_0_5_2_1 + 0.00253968253968253*G0_0_0_5_2_2 - 0.00507936507936506*G0_0_0_5_2_3 - 0.00846560846560843*G0_0_0_5_2_4 - 0.0101587301587301*G0_0_0_5_2_5 + 0.00846560846560842*G0_0_0_5_3_1 - 0.00507936507936506*G0_0_0_5_3_2 + 0.0135449735449735*G0_0_0_5_3_3 + 0.0135449735449735*G0_0_0_5_3_4 + 0.0203174603174602*G0_0_0_5_3_5 + 0.0152380952380952*G0_0_0_5_4_0 - 0.00677248677248675*G0_0_0_5_4_1 - 0.00846560846560843*G0_0_0_5_4_2 + 0.0135449735449735*G0_0_0_5_4_3 + 0.054179894179894*G0_0_0_5_4_4 + 0.0338624338624337*G0_0_0_5_4_5 + 0.0186243386243385*G0_0_0_5_5_0 + 0.00846560846560841*G0_0_0_5_5_1 - 0.0101587301587301*G0_0_0_5_5_2 + 0.0203174603174602*G0_0_0_5_5_3 + 0.0338624338624337*G0_0_0_5_5_4 + 0.0812698412698408*G0_0_0_5_5_5 - 0.00634920634920631*G0_0_1_0_0_0 + 0.00253968253968252*G0_0_1_0_0_1 + 0.000423280423280422*G0_0_1_0_0_2 - 0.000846560846560842*G0_0_1_0_0_3 - 0.00423280423280421*G0_0_1_0_0_4 - 0.00423280423280421*G0_0_1_0_0_5 + 0.00253968253968252*G0_0_1_0_1_0 - 0.0063492063492063*G0_0_1_0_1_1 + 0.00042328042328042*G0_0_1_0_1_2 - 0.0042328042328042*G0_0_1_0_1_3 - 0.00084656084656084*G0_0_1_0_1_4 - 0.0042328042328042*G0_0_1_0_1_5 + 0.000423280423280422*G0_0_1_0_2_0 + 0.00042328042328042*G0_0_1_0_2_1 + 0.000423280423280417*G0_0_1_0_2_2 + 0.00169312169312168*G0_0_1_0_2_3 + 0.00169312169312168*G0_0_1_0_2_4 + 0.00169312169312168*G0_0_1_0_2_5 - 0.000846560846560842*G0_0_1_0_3_0 - 0.0042328042328042*G0_0_1_0_3_1 + 0.00169312169312168*G0_0_1_0_3_2 + 0.00169312169312168*G0_0_1_0_3_3 + 0.00338624338624336*G0_0_1_0_3_4 - 0.00169312169312168*G0_0_1_0_3_5 - 0.00423280423280421*G0_0_1_0_4_0 - 0.00084656084656084*G0_0_1_0_4_1 + 0.00169312169312168*G0_0_1_0_4_2 + 0.00338624338624336*G0_0_1_0_4_3 + 0.00169312169312167*G0_0_1_0_4_4 - 0.00169312169312169*G0_0_1_0_4_5 - 0.00423280423280421*G0_0_1_0_5_0 - 0.0042328042328042*G0_0_1_0_5_1 + 0.00169312169312168*G0_0_1_0_5_2 - 0.00169312169312168*G0_0_1_0_5_3 - 0.00169312169312169*G0_0_1_0_5_4 - 0.0152380952380951*G0_0_1_0_5_5 + 0.00253968253968252*G0_0_1_1_0_0 - 0.0063492063492063*G0_0_1_1_0_1 + 0.00042328042328042*G0_0_1_1_0_2 - 0.0042328042328042*G0_0_1_1_0_3 - 0.00084656084656084*G0_0_1_1_0_4 - 0.0042328042328042*G0_0_1_1_0_5 - 0.0063492063492063*G0_0_1_1_1_0 + 0.0761904761904758*G0_0_1_1_1_1 - 0.00634920634920632*G0_0_1_1_1_2 + 0.0253968253968253*G0_0_1_1_1_3 + 0.0253968253968253*G0_0_1_1_1_5 + 0.00042328042328042*G0_0_1_1_2_0 - 0.00634920634920632*G0_0_1_1_2_1 + 0.00253968253968252*G0_0_1_1_2_2 - 0.00423280423280422*G0_0_1_1_2_3 - 0.000846560846560845*G0_0_1_1_2_4 - 0.00423280423280421*G0_0_1_1_2_5 - 0.0042328042328042*G0_0_1_1_3_0 + 0.0253968253968253*G0_0_1_1_3_1 - 0.00423280423280422*G0_0_1_1_3_2 + 0.0338624338624337*G0_0_1_1_3_3 + 0.00846560846560842*G0_0_1_1_3_4 + 0.0169312169312168*G0_0_1_1_3_5 - 0.00084656084656084*G0_0_1_1_4_0 - 0.000846560846560844*G0_0_1_1_4_2 + 0.00846560846560842*G0_0_1_1_4_3 + 0.0101587301587301*G0_0_1_1_4_4 + 0.00846560846560843*G0_0_1_1_4_5 - 0.0042328042328042*G0_0_1_1_5_0 + 0.0253968253968253*G0_0_1_1_5_1 - 0.00423280423280421*G0_0_1_1_5_2 + 0.0169312169312169*G0_0_1_1_5_3 + 0.00846560846560843*G0_0_1_1_5_4 + 0.0338624338624337*G0_0_1_1_5_5 + 0.000423280423280422*G0_0_1_2_0_0 + 0.00042328042328042*G0_0_1_2_0_1 + 0.000423280423280417*G0_0_1_2_0_2 + 0.00169312169312168*G0_0_1_2_0_3 + 0.00169312169312168*G0_0_1_2_0_4 + 0.00169312169312168*G0_0_1_2_0_5 + 0.00042328042328042*G0_0_1_2_1_0 - 0.00634920634920632*G0_0_1_2_1_1 + 0.00253968253968252*G0_0_1_2_1_2 - 0.00423280423280422*G0_0_1_2_1_3 - 0.000846560846560845*G0_0_1_2_1_4 - 0.00423280423280421*G0_0_1_2_1_5 + 0.000423280423280417*G0_0_1_2_2_0 + 0.00253968253968252*G0_0_1_2_2_1 - 0.00634920634920629*G0_0_1_2_2_2 - 0.0042328042328042*G0_0_1_2_2_3 - 0.0042328042328042*G0_0_1_2_2_4 - 0.000846560846560844*G0_0_1_2_2_5 + 0.00169312169312168*G0_0_1_2_3_0 - 0.00423280423280422*G0_0_1_2_3_1 - 0.0042328042328042*G0_0_1_2_3_2 - 0.0152380952380952*G0_0_1_2_3_3 - 0.00169312169312168*G0_0_1_2_3_4 - 0.00169312169312169*G0_0_1_2_3_5 + 0.00169312169312168*G0_0_1_2_4_0 - 0.000846560846560844*G0_0_1_2_4_1 - 0.0042328042328042*G0_0_1_2_4_2 - 0.00169312169312168*G0_0_1_2_4_3 + 0.00169312169312169*G0_0_1_2_4_4 + 0.00338624338624337*G0_0_1_2_4_5 + 0.00169312169312168*G0_0_1_2_5_0 - 0.00423280423280421*G0_0_1_2_5_1 - 0.000846560846560844*G0_0_1_2_5_2 - 0.00169312169312169*G0_0_1_2_5_3 + 0.00338624338624337*G0_0_1_2_5_4 + 0.00169312169312168*G0_0_1_2_5_5 - 0.000846560846560842*G0_0_1_3_0_0 - 0.0042328042328042*G0_0_1_3_0_1 + 0.00169312169312168*G0_0_1_3_0_2 + 0.00169312169312169*G0_0_1_3_0_3 + 0.00338624338624337*G0_0_1_3_0_4 - 0.00169312169312168*G0_0_1_3_0_5 - 0.0042328042328042*G0_0_1_3_1_0 + 0.0253968253968253*G0_0_1_3_1_1 - 0.00423280423280422*G0_0_1_3_1_2 + 0.0338624338624337*G0_0_1_3_1_3 + 0.00846560846560842*G0_0_1_3_1_4 + 0.0169312169312168*G0_0_1_3_1_5 + 0.00169312169312168*G0_0_1_3_2_0 - 0.00423280423280422*G0_0_1_3_2_1 - 0.0042328042328042*G0_0_1_3_2_2 - 0.0152380952380952*G0_0_1_3_2_3 - 0.00169312169312168*G0_0_1_3_2_4 - 0.00169312169312169*G0_0_1_3_2_5 + 0.00169312169312168*G0_0_1_3_3_0 + 0.0338624338624337*G0_0_1_3_3_1 - 0.0152380952380952*G0_0_1_3_3_2 - 0.0203174603174602*G0_0_1_3_3_4 + 0.00338624338624337*G0_0_1_3_4_0 + 0.00846560846560842*G0_0_1_3_4_1 - 0.00169312169312168*G0_0_1_3_4_2 - 0.0203174603174602*G0_0_1_3_4_3 - 0.027089947089947*G0_0_1_3_4_4 - 0.0135449735449735*G0_0_1_3_4_5 - 0.00169312169312168*G0_0_1_3_5_0 + 0.0169312169312168*G0_0_1_3_5_1 - 0.00169312169312169*G0_0_1_3_5_2 - 0.0135449735449735*G0_0_1_3_5_4 - 0.00423280423280421*G0_0_1_4_0_0 - 0.00084656084656084*G0_0_1_4_0_1 + 0.00169312169312168*G0_0_1_4_0_2 + 0.00338624338624336*G0_0_1_4_0_3 + 0.00169312169312167*G0_0_1_4_0_4 - 0.00169312169312169*G0_0_1_4_0_5 - 0.00084656084656084*G0_0_1_4_1_0 - 0.000846560846560844*G0_0_1_4_1_2 + 0.00846560846560842*G0_0_1_4_1_3 + 0.0101587301587301*G0_0_1_4_1_4 + 0.00846560846560843*G0_0_1_4_1_5 + 0.00169312169312168*G0_0_1_4_2_0 - 0.000846560846560844*G0_0_1_4_2_1 - 0.0042328042328042*G0_0_1_4_2_2 - 0.00169312169312168*G0_0_1_4_2_3 + 0.00169312169312169*G0_0_1_4_2_4 + 0.00338624338624337*G0_0_1_4_2_5 + 0.00338624338624336*G0_0_1_4_3_0 + 0.00846560846560842*G0_0_1_4_3_1 - 0.00169312169312168*G0_0_1_4_3_2 - 0.0203174603174602*G0_0_1_4_3_3 - 0.027089947089947*G0_0_1_4_3_4 - 0.0135449735449735*G0_0_1_4_3_5 + 0.00169312169312167*G0_0_1_4_4_0 + 0.0101587301587301*G0_0_1_4_4_1 + 0.00169312169312169*G0_0_1_4_4_2 - 0.027089947089947*G0_0_1_4_4_3 - 0.0609523809523806*G0_0_1_4_4_4 - 0.027089947089947*G0_0_1_4_4_5 - 0.00169312169312169*G0_0_1_4_5_0 + 0.00846560846560842*G0_0_1_4_5_1 + 0.00338624338624337*G0_0_1_4_5_2 - 0.0135449735449735*G0_0_1_4_5_3 - 0.027089947089947*G0_0_1_4_5_4 - 0.0203174603174602*G0_0_1_4_5_5 - 0.00423280423280421*G0_0_1_5_0_0 - 0.0042328042328042*G0_0_1_5_0_1 + 0.00169312169312168*G0_0_1_5_0_2 - 0.00169312169312168*G0_0_1_5_0_3 - 0.00169312169312169*G0_0_1_5_0_4 - 0.0152380952380951*G0_0_1_5_0_5 - 0.0042328042328042*G0_0_1_5_1_0 + 0.0253968253968252*G0_0_1_5_1_1 - 0.00423280423280421*G0_0_1_5_1_2 + 0.0169312169312168*G0_0_1_5_1_3 + 0.00846560846560842*G0_0_1_5_1_4 + 0.0338624338624337*G0_0_1_5_1_5 + 0.00169312169312168*G0_0_1_5_2_0 - 0.00423280423280421*G0_0_1_5_2_1 - 0.000846560846560844*G0_0_1_5_2_2 - 0.00169312169312169*G0_0_1_5_2_3 + 0.00338624338624337*G0_0_1_5_2_4 + 0.00169312169312168*G0_0_1_5_2_5 - 0.00169312169312168*G0_0_1_5_3_0 + 0.0169312169312168*G0_0_1_5_3_1 - 0.00169312169312169*G0_0_1_5_3_2 - 0.0135449735449735*G0_0_1_5_3_4 - 0.00169312169312169*G0_0_1_5_4_0 + 0.00846560846560842*G0_0_1_5_4_1 + 0.00338624338624337*G0_0_1_5_4_2 - 0.0135449735449735*G0_0_1_5_4_3 - 0.027089947089947*G0_0_1_5_4_4 - 0.0203174603174602*G0_0_1_5_4_5 - 0.0152380952380951*G0_0_1_5_5_0 + 0.0338624338624337*G0_0_1_5_5_1 + 0.00169312169312168*G0_0_1_5_5_2 - 0.0203174603174602*G0_0_1_5_5_4;
    A[29] = -A[23] + 0.0825396825396821*G0_1_0_0_0_0 - 0.00888888888888884*G0_1_0_0_0_1 - 0.00677248677248674*G0_1_0_0_0_2 + 0.000846560846560854*G0_1_0_0_0_3 + 0.0296296296296295*G0_1_0_0_0_4 + 0.0296296296296295*G0_1_0_0_0_5 - 0.00888888888888884*G0_1_0_0_1_0 + 0.00888888888888882*G0_1_0_0_1_1 + 0.00338624338624336*G0_1_0_0_1_3 - 0.00338624338624337*G0_1_0_0_1_4 - 0.00677248677248674*G0_1_0_0_2_0 + 0.00211640211640211*G0_1_0_0_2_2 - 0.00253968253968252*G0_1_0_0_2_3 - 0.0059259259259259*G0_1_0_0_2_4 - 0.0059259259259259*G0_1_0_0_2_5 + 0.000846560846560854*G0_1_0_0_3_0 + 0.00338624338624336*G0_1_0_0_3_1 - 0.00253968253968252*G0_1_0_0_3_2 + 0.00846560846560841*G0_1_0_0_3_3 + 0.00507936507936506*G0_1_0_0_3_4 + 0.0101587301587301*G0_1_0_0_3_5 + 0.0296296296296295*G0_1_0_0_4_0 - 0.00338624338624337*G0_1_0_0_4_1 - 0.0059259259259259*G0_1_0_0_4_2 + 0.00507936507936506*G0_1_0_0_4_3 + 0.032169312169312*G0_1_0_0_4_4 + 0.0186243386243385*G0_1_0_0_4_5 + 0.0296296296296295*G0_1_0_0_5_0 - 0.0059259259259259*G0_1_0_0_5_2 + 0.0101587301587301*G0_1_0_0_5_3 + 0.0186243386243385*G0_1_0_0_5_4 + 0.0491005291005288*G0_1_0_0_5_5 - 0.00888888888888884*G0_1_0_1_0_0 + 0.00888888888888882*G0_1_0_1_0_1 + 0.00338624338624336*G0_1_0_1_0_3 - 0.00338624338624337*G0_1_0_1_0_4 + 0.00888888888888882*G0_1_0_1_1_0 - 0.082539682539682*G0_1_0_1_1_1 + 0.00677248677248673*G0_1_0_1_1_2 - 0.0296296296296295*G0_1_0_1_1_3 - 0.000846560846560842*G0_1_0_1_1_4 - 0.0296296296296294*G0_1_0_1_1_5 + 0.00677248677248673*G0_1_0_1_2_1 - 0.00211640211640211*G0_1_0_1_2_2 + 0.0059259259259259*G0_1_0_1_2_3 + 0.00253968253968253*G0_1_0_1_2_4 + 0.0059259259259259*G0_1_0_1_2_5 + 0.00338624338624336*G0_1_0_1_3_0 - 0.0296296296296295*G0_1_0_1_3_1 + 0.0059259259259259*G0_1_0_1_3_2 - 0.032169312169312*G0_1_0_1_3_3 - 0.00507936507936506*G0_1_0_1_3_4 - 0.0186243386243385*G0_1_0_1_3_5 - 0.00338624338624337*G0_1_0_1_4_0 - 0.000846560846560842*G0_1_0_1_4_1 + 0.00253968253968253*G0_1_0_1_4_2 - 0.00507936507936506*G0_1_0_1_4_3 - 0.00846560846560843*G0_1_0_1_4_4 - 0.0101587301587301*G0_1_0_1_4_5 - 0.0296296296296294*G0_1_0_1_5_1 + 0.0059259259259259*G0_1_0_1_5_2 - 0.0186243386243385*G0_1_0_1_5_3 - 0.0101587301587301*G0_1_0_1_5_4 - 0.0491005291005288*G0_1_0_1_5_5 - 0.00677248677248674*G0_1_0_2_0_0 + 0.00211640211640211*G0_1_0_2_0_2 - 0.00253968253968252*G0_1_0_2_0_3 - 0.0059259259259259*G0_1_0_2_0_4 - 0.0059259259259259*G0_1_0_2_0_5 + 0.00677248677248673*G0_1_0_2_1_1 - 0.00211640211640211*G0_1_0_2_1_2 + 0.0059259259259259*G0_1_0_2_1_3 + 0.00253968253968253*G0_1_0_2_1_4 + 0.0059259259259259*G0_1_0_2_1_5 + 0.00211640211640211*G0_1_0_2_2_0 - 0.00211640211640211*G0_1_0_2_2_1 - 0.00253968253968252*G0_1_0_2_3_0 + 0.0059259259259259*G0_1_0_2_3_1 + 0.0169312169312168*G0_1_0_2_3_3 + 0.00507936507936506*G0_1_0_2_3_5 - 0.0059259259259259*G0_1_0_2_4_0 + 0.00253968253968253*G0_1_0_2_4_1 - 0.0169312169312169*G0_1_0_2_4_4 - 0.00507936507936506*G0_1_0_2_4_5 - 0.0059259259259259*G0_1_0_2_5_0 + 0.00592592592592589*G0_1_0_2_5_1 + 0.00507936507936506*G0_1_0_2_5_3 - 0.00507936507936506*G0_1_0_2_5_4 + 0.000846560846560854*G0_1_0_3_0_0 + 0.00338624338624336*G0_1_0_3_0_1 - 0.00253968253968252*G0_1_0_3_0_2 + 0.00846560846560841*G0_1_0_3_0_3 + 0.00507936507936506*G0_1_0_3_0_4 + 0.0101587301587301*G0_1_0_3_0_5 + 0.00338624338624336*G0_1_0_3_1_0 - 0.0296296296296295*G0_1_0_3_1_1 + 0.0059259259259259*G0_1_0_3_1_2 - 0.032169312169312*G0_1_0_3_1_3 - 0.00507936507936506*G0_1_0_3_1_4 - 0.0186243386243385*G0_1_0_3_1_5 - 0.00253968253968252*G0_1_0_3_2_0 + 0.0059259259259259*G0_1_0_3_2_1 + 0.0169312169312168*G0_1_0_3_2_3 + 0.00507936507936506*G0_1_0_3_2_5 + 0.00846560846560841*G0_1_0_3_3_0 - 0.032169312169312*G0_1_0_3_3_1 + 0.0169312169312168*G0_1_0_3_3_2 - 0.0609523809523806*G0_1_0_3_3_3 - 0.00677248677248674*G0_1_0_3_3_4 - 0.027089947089947*G0_1_0_3_3_5 + 0.00507936507936506*G0_1_0_3_4_0 - 0.00507936507936506*G0_1_0_3_4_1 - 0.00677248677248674*G0_1_0_3_4_3 + 0.00677248677248674*G0_1_0_3_4_4 + 0.0101587301587301*G0_1_0_3_5_0 - 0.0186243386243385*G0_1_0_3_5_1 + 0.00507936507936506*G0_1_0_3_5_2 - 0.027089947089947*G0_1_0_3_5_3 - 0.0203174603174602*G0_1_0_3_5_5 + 0.0296296296296295*G0_1_0_4_0_0 - 0.00338624338624337*G0_1_0_4_0_1 - 0.0059259259259259*G0_1_0_4_0_2 + 0.00507936507936506*G0_1_0_4_0_3 + 0.032169312169312*G0_1_0_4_0_4 + 0.0186243386243385*G0_1_0_4_0_5 - 0.00338624338624337*G0_1_0_4_1_0 - 0.000846560846560843*G0_1_0_4_1_1 + 0.00253968253968253*G0_1_0_4_1_2 - 0.00507936507936506*G0_1_0_4_1_3 - 0.00846560846560843*G0_1_0_4_1_4 - 0.0101587301587301*G0_1_0_4_1_5 - 0.0059259259259259*G0_1_0_4_2_0 + 0.00253968253968253*G0_1_0_4_2_1 - 0.0169312169312169*G0_1_0_4_2_4 - 0.00507936507936506*G0_1_0_4_2_5 + 0.00507936507936506*G0_1_0_4_3_0 - 0.00507936507936506*G0_1_0_4_3_1 - 0.00677248677248674*G0_1_0_4_3_3 + 0.00677248677248674*G0_1_0_4_3_4 + 0.032169312169312*G0_1_0_4_4_0 - 0.00846560846560843*G0_1_0_4_4_1 - 0.0169312169312169*G0_1_0_4_4_2 + 0.00677248677248674*G0_1_0_4_4_3 + 0.0609523809523807*G0_1_0_4_4_4 + 0.027089947089947*G0_1_0_4_4_5 + 0.0186243386243385*G0_1_0_4_5_0 - 0.0101587301587301*G0_1_0_4_5_1 - 0.00507936507936506*G0_1_0_4_5_2 + 0.027089947089947*G0_1_0_4_5_4 + 0.0203174603174602*G0_1_0_4_5_5 + 0.0296296296296295*G0_1_0_5_0_0 - 0.0059259259259259*G0_1_0_5_0_2 + 0.0101587301587301*G0_1_0_5_0_3 + 0.0186243386243385*G0_1_0_5_0_4 + 0.0491005291005288*G0_1_0_5_0_5 - 0.0296296296296294*G0_1_0_5_1_1 + 0.0059259259259259*G0_1_0_5_1_2 - 0.0186243386243385*G0_1_0_5_1_3 - 0.0101587301587301*G0_1_0_5_1_4 - 0.0491005291005288*G0_1_0_5_1_5 - 0.0059259259259259*G0_1_0_5_2_0 + 0.0059259259259259*G0_1_0_5_2_1 + 0.00507936507936506*G0_1_0_5_2_3 - 0.00507936507936506*G0_1_0_5_2_4 + 0.0101587301587301*G0_1_0_5_3_0 - 0.0186243386243385*G0_1_0_5_3_1 + 0.00507936507936506*G0_1_0_5_3_2 - 0.027089947089947*G0_1_0_5_3_3 - 0.0203174603174602*G0_1_0_5_3_5 + 0.0186243386243385*G0_1_0_5_4_0 - 0.0101587301587301*G0_1_0_5_4_1 - 0.00507936507936506*G0_1_0_5_4_2 + 0.027089947089947*G0_1_0_5_4_4 + 0.0203174603174602*G0_1_0_5_4_5 + 0.0491005291005288*G0_1_0_5_5_0 - 0.0491005291005288*G0_1_0_5_5_1 - 0.0203174603174602*G0_1_0_5_5_3 + 0.0203174603174602*G0_1_0_5_5_4 - 0.00634920634920632*G0_1_1_0_0_0 - 0.000423280423280416*G0_1_1_0_0_1 + 0.00169312169312168*G0_1_1_0_0_2 - 0.00338624338624336*G0_1_1_0_0_3 - 0.00423280423280421*G0_1_1_0_0_4 - 0.0126984126984126*G0_1_1_0_0_5 - 0.000423280423280416*G0_1_1_0_1_0 + 0.0084656084656084*G0_1_1_0_1_1 - 0.00126984126984126*G0_1_1_0_1_2 + 0.00507936507936504*G0_1_1_0_1_3 + 0.00169312169312168*G0_1_1_0_1_4 + 0.0118518518518518*G0_1_1_0_1_5 + 0.00169312169312168*G0_1_1_0_2_0 - 0.00126984126984126*G0_1_1_0_2_1 - 0.00338624338624336*G0_1_1_0_2_3 - 0.00084656084656084*G0_1_1_0_2_4 - 0.00253968253968253*G0_1_1_0_2_5 - 0.00338624338624336*G0_1_1_0_3_0 + 0.00507936507936504*G0_1_1_0_3_1 - 0.00338624338624336*G0_1_1_0_3_2 + 0.0118518518518518*G0_1_1_0_3_3 + 0.00338624338624337*G0_1_1_0_3_4 + 0.0118518518518518*G0_1_1_0_3_5 - 0.00423280423280421*G0_1_1_0_4_0 + 0.00169312169312168*G0_1_1_0_4_1 - 0.00084656084656084*G0_1_1_0_4_2 + 0.00338624338624337*G0_1_1_0_4_3 - 0.00169312169312169*G0_1_1_0_4_4 + 0.00169312169312168*G0_1_1_0_4_5 - 0.0126984126984126*G0_1_1_0_5_0 + 0.0118518518518518*G0_1_1_0_5_1 - 0.00253968253968253*G0_1_1_0_5_2 + 0.0118518518518518*G0_1_1_0_5_3 + 0.00169312169312168*G0_1_1_0_5_4 + 0.0152380952380951*G0_1_1_0_5_5 - 0.000423280423280416*G0_1_1_1_0_0 + 0.00846560846560841*G0_1_1_1_0_1 - 0.00126984126984126*G0_1_1_1_0_2 + 0.00507936507936504*G0_1_1_1_0_3 + 0.00169312169312168*G0_1_1_1_0_4 + 0.0118518518518518*G0_1_1_1_0_5 + 0.00846560846560841*G0_1_1_1_1_0 - 0.0888888888888884*G0_1_1_1_1_1 + 0.00846560846560842*G0_1_1_1_1_2 - 0.0338624338624337*G0_1_1_1_1_3 - 0.00423280423280421*G0_1_1_1_1_4 - 0.0423280423280421*G0_1_1_1_1_5 - 0.00126984126984126*G0_1_1_1_2_0 + 0.00846560846560842*G0_1_1_1_2_1 - 0.0021164021164021*G0_1_1_1_2_2 + 0.00507936507936506*G0_1_1_1_2_3 - 0.000846560846560842*G0_1_1_1_2_4 + 0.00338624338624337*G0_1_1_1_2_5 + 0.00507936507936504*G0_1_1_1_3_0 - 0.0338624338624337*G0_1_1_1_3_1 + 0.00507936507936506*G0_1_1_1_3_2 - 0.0338624338624337*G0_1_1_1_3_3 - 0.00169312169312169*G0_1_1_1_3_4 - 0.0169312169312168*G0_1_1_1_3_5 + 0.00169312169312168*G0_1_1_1_4_0 - 0.00423280423280421*G0_1_1_1_4_1 - 0.000846560846560842*G0_1_1_1_4_2 - 0.00169312169312169*G0_1_1_1_4_3 + 0.00338624338624337*G0_1_1_1_4_4 + 0.00169312169312169*G0_1_1_1_4_5 + 0.0118518518518518*G0_1_1_1_5_0 - 0.0423280423280421*G0_1_1_1_5_1 + 0.00338624338624337*G0_1_1_1_5_2 - 0.0169312169312168*G0_1_1_1_5_3 + 0.00169312169312169*G0_1_1_1_5_4 - 0.0338624338624337*G0_1_1_1_5_5 + 0.00169312169312168*G0_1_1_2_0_0 - 0.00126984126984126*G0_1_1_2_0_1 - 0.00338624338624337*G0_1_1_2_0_3 - 0.00084656084656084*G0_1_1_2_0_4 - 0.00253968253968253*G0_1_1_2_0_5 - 0.00126984126984126*G0_1_1_2_1_0 + 0.00846560846560842*G0_1_1_2_1_1 - 0.0021164021164021*G0_1_1_2_1_2 + 0.00507936507936506*G0_1_1_2_1_3 - 0.000846560846560842*G0_1_1_2_1_4 + 0.00338624338624337*G0_1_1_2_1_5 - 0.0021164021164021*G0_1_1_2_2_1 + 0.0063492063492063*G0_1_1_2_2_2 - 0.00423280423280421*G0_1_1_2_2_5 - 0.00338624338624336*G0_1_1_2_3_0 + 0.00507936507936506*G0_1_1_2_3_1 + 0.0253968253968253*G0_1_1_2_3_3 + 0.00846560846560842*G0_1_1_2_3_4 + 0.0152380952380952*G0_1_1_2_3_5 - 0.00084656084656084*G0_1_1_2_4_0 - 0.000846560846560842*G0_1_1_2_4_1 + 0.00846560846560842*G0_1_1_2_4_3 + 0.00846560846560842*G0_1_1_2_4_4 + 0.0101587301587301*G0_1_1_2_4_5 - 0.00253968253968253*G0_1_1_2_5_0 + 0.00338624338624337*G0_1_1_2_5_1 - 0.00423280423280421*G0_1_1_2_5_2 + 0.0152380952380952*G0_1_1_2_5_3 + 0.0101587301587301*G0_1_1_2_5_4 + 0.0287830687830686*G0_1_1_2_5_5 - 0.00338624338624336*G0_1_1_3_0_0 + 0.00507936507936504*G0_1_1_3_0_1 - 0.00338624338624336*G0_1_1_3_0_2 + 0.0118518518518518*G0_1_1_3_0_3 + 0.00338624338624337*G0_1_1_3_0_4 + 0.0118518518518518*G0_1_1_3_0_5 + 0.00507936507936504*G0_1_1_3_1_0 - 0.0338624338624337*G0_1_1_3_1_1 + 0.00507936507936506*G0_1_1_3_1_2 - 0.0338624338624337*G0_1_1_3_1_3 - 0.00169312169312168*G0_1_1_3_1_4 - 0.0169312169312168*G0_1_1_3_1_5 - 0.00338624338624336*G0_1_1_3_2_0 + 0.00507936507936506*G0_1_1_3_2_1 + 0.0253968253968253*G0_1_1_3_2_3 + 0.00846560846560842*G0_1_1_3_2_4 + 0.0152380952380952*G0_1_1_3_2_5 + 0.0118518518518518*G0_1_1_3_3_0 - 0.0338624338624337*G0_1_1_3_3_1 + 0.0253968253968253*G0_1_1_3_3_2 - 0.0812698412698409*G0_1_1_3_3_3 - 0.0203174603174602*G0_1_1_3_3_4 - 0.0541798941798939*G0_1_1_3_3_5 + 0.00338624338624337*G0_1_1_3_4_0 - 0.00169312169312169*G0_1_1_3_4_1 + 0.00846560846560843*G0_1_1_3_4_2 - 0.0203174603174602*G0_1_1_3_4_3 - 0.0135449735449735*G0_1_1_3_4_4 - 0.027089947089947*G0_1_1_3_4_5 + 0.0118518518518518*G0_1_1_3_5_0 - 0.0169312169312168*G0_1_1_3_5_1 + 0.0152380952380952*G0_1_1_3_5_2 - 0.0541798941798939*G0_1_1_3_5_3 - 0.027089947089947*G0_1_1_3_5_4 - 0.0812698412698409*G0_1_1_3_5_5 - 0.00423280423280421*G0_1_1_4_0_0 + 0.00169312169312168*G0_1_1_4_0_1 - 0.00084656084656084*G0_1_1_4_0_2 + 0.00338624338624337*G0_1_1_4_0_3 - 0.00169312169312169*G0_1_1_4_0_4 + 0.00169312169312168*G0_1_1_4_0_5 + 0.00169312169312168*G0_1_1_4_1_0 - 0.00423280423280421*G0_1_1_4_1_1 - 0.000846560846560842*G0_1_1_4_1_2 - 0.00169312169312169*G0_1_1_4_1_3 + 0.00338624338624337*G0_1_1_4_1_4 + 0.00169312169312169*G0_1_1_4_1_5 - 0.00084656084656084*G0_1_1_4_2_0 - 0.000846560846560842*G0_1_1_4_2_1 + 0.00846560846560842*G0_1_1_4_2_3 + 0.00846560846560842*G0_1_1_4_2_4 + 0.0101587301587301*G0_1_1_4_2_5 + 0.00338624338624337*G0_1_1_4_3_0 - 0.00169312169312169*G0_1_1_4_3_1 + 0.00846560846560843*G0_1_1_4_3_2 - 0.0203174603174602*G0_1_1_4_3_3 - 0.0135449735449735*G0_1_1_4_3_4 - 0.027089947089947*G0_1_1_4_3_5 - 0.00169312169312169*G0_1_1_4_4_0 + 0.00338624338624337*G0_1_1_4_4_1 + 0.00846560846560842*G0_1_1_4_4_2 - 0.0135449735449735*G0_1_1_4_4_3 - 0.0203174603174602*G0_1_1_4_4_4 - 0.027089947089947*G0_1_1_4_4_5 + 0.00169312169312168*G0_1_1_4_5_0 + 0.00169312169312169*G0_1_1_4_5_1 + 0.0101587301587301*G0_1_1_4_5_2 - 0.027089947089947*G0_1_1_4_5_3 - 0.027089947089947*G0_1_1_4_5_4 - 0.0609523809523806*G0_1_1_4_5_5 - 0.0126984126984126*G0_1_1_5_0_0 + 0.0118518518518518*G0_1_1_5_0_1 - 0.00253968253968252*G0_1_1_5_0_2 + 0.0118518518518518*G0_1_1_5_0_3 + 0.00169312169312168*G0_1_1_5_0_4 + 0.0152380952380951*G0_1_1_5_0_5 + 0.0118518518518518*G0_1_1_5_1_0 - 0.0423280423280421*G0_1_1_5_1_1 + 0.00338624338624337*G0_1_1_5_1_2 - 0.0169312169312168*G0_1_1_5_1_3 + 0.00169312169312169*G0_1_1_5_1_4 - 0.0338624338624337*G0_1_1_5_1_5 - 0.00253968253968252*G0_1_1_5_2_0 + 0.00338624338624337*G0_1_1_5_2_1 - 0.00423280423280421*G0_1_1_5_2_2 + 0.0152380952380952*G0_1_1_5_2_3 + 0.0101587301587301*G0_1_1_5_2_4 + 0.0287830687830686*G0_1_1_5_2_5 + 0.0118518518518518*G0_1_1_5_3_0 - 0.0169312169312168*G0_1_1_5_3_1 + 0.0152380952380952*G0_1_1_5_3_2 - 0.0541798941798939*G0_1_1_5_3_3 - 0.027089947089947*G0_1_1_5_3_4 - 0.0812698412698409*G0_1_1_5_3_5 + 0.00169312169312168*G0_1_1_5_4_0 + 0.00169312169312169*G0_1_1_5_4_1 + 0.0101587301587301*G0_1_1_5_4_2 - 0.027089947089947*G0_1_1_5_4_3 - 0.027089947089947*G0_1_1_5_4_4 - 0.0609523809523806*G0_1_1_5_4_5 + 0.0152380952380951*G0_1_1_5_5_0 - 0.0338624338624337*G0_1_1_5_5_1 + 0.0287830687830686*G0_1_1_5_5_2 - 0.0812698412698409*G0_1_1_5_5_3 - 0.0609523809523806*G0_1_1_5_5_4 - 0.325079365079363*G0_1_1_5_5_5;
    A[22] = -A[34] - 0.0063492063492063*G0_0_0_0_0_0 + 0.00169312169312168*G0_0_0_0_0_1 - 0.000423280423280417*G0_0_0_0_0_2 - 0.00338624338624337*G0_0_0_0_0_3 - 0.0126984126984126*G0_0_0_0_0_4 - 0.00423280423280421*G0_0_0_0_0_5 + 0.00169312169312168*G0_0_0_0_1_0 - 0.00126984126984126*G0_0_0_0_1_2 - 0.00338624338624336*G0_0_0_0_1_3 - 0.00253968253968252*G0_0_0_0_1_4 - 0.000846560846560841*G0_0_0_0_1_5 - 0.000423280423280417*G0_0_0_0_2_0 - 0.00126984126984126*G0_0_0_0_2_1 + 0.00846560846560839*G0_0_0_0_2_2 + 0.00507936507936504*G0_0_0_0_2_3 + 0.0118518518518518*G0_0_0_0_2_4 + 0.00169312169312169*G0_0_0_0_2_5 - 0.00338624338624337*G0_0_0_0_3_0 - 0.00338624338624336*G0_0_0_0_3_1 + 0.00507936507936504*G0_0_0_0_3_2 + 0.0118518518518518*G0_0_0_0_3_3 + 0.0118518518518518*G0_0_0_0_3_4 + 0.00338624338624337*G0_0_0_0_3_5 - 0.0126984126984126*G0_0_0_0_4_0 - 0.00253968253968252*G0_0_0_0_4_1 + 0.0118518518518518*G0_0_0_0_4_2 + 0.0118518518518518*G0_0_0_0_4_3 + 0.0152380952380951*G0_0_0_0_4_4 + 0.00169312169312168*G0_0_0_0_4_5 - 0.00423280423280421*G0_0_0_0_5_0 - 0.00084656084656084*G0_0_0_0_5_1 + 0.00169312169312169*G0_0_0_0_5_2 + 0.00338624338624337*G0_0_0_0_5_3 + 0.00169312169312168*G0_0_0_0_5_4 - 0.00169312169312167*G0_0_0_0_5_5 + 0.00169312169312168*G0_0_0_1_0_0 - 0.00126984126984126*G0_0_0_1_0_2 - 0.00338624338624336*G0_0_0_1_0_3 - 0.00253968253968252*G0_0_0_1_0_4 - 0.000846560846560841*G0_0_0_1_0_5 + 0.00634920634920629*G0_0_0_1_1_1 - 0.0021164021164021*G0_0_0_1_1_2 - 0.00423280423280421*G0_0_0_1_1_4 - 0.00126984126984126*G0_0_0_1_2_0 - 0.0021164021164021*G0_0_0_1_2_1 + 0.0084656084656084*G0_0_0_1_2_2 + 0.00507936507936504*G0_0_0_1_2_3 + 0.00338624338624336*G0_0_0_1_2_4 - 0.00084656084656084*G0_0_0_1_2_5 - 0.00338624338624336*G0_0_0_1_3_0 + 0.00507936507936504*G0_0_0_1_3_2 + 0.0253968253968253*G0_0_0_1_3_3 + 0.0152380952380952*G0_0_0_1_3_4 + 0.00846560846560842*G0_0_0_1_3_5 - 0.00253968253968252*G0_0_0_1_4_0 - 0.00423280423280421*G0_0_0_1_4_1 + 0.00338624338624336*G0_0_0_1_4_2 + 0.0152380952380952*G0_0_0_1_4_3 + 0.0287830687830686*G0_0_0_1_4_4 + 0.0101587301587301*G0_0_0_1_4_5 - 0.00084656084656084*G0_0_0_1_5_0 - 0.00084656084656084*G0_0_0_1_5_2 + 0.00846560846560842*G0_0_0_1_5_3 + 0.0101587301587301*G0_0_0_1_5_4 + 0.00846560846560841*G0_0_0_1_5_5 - 0.000423280423280417*G0_0_0_2_0_0 - 0.00126984126984126*G0_0_0_2_0_1 + 0.00846560846560839*G0_0_0_2_0_2 + 0.00507936507936504*G0_0_0_2_0_3 + 0.0118518518518518*G0_0_0_2_0_4 + 0.00169312169312169*G0_0_0_2_0_5 - 0.00126984126984126*G0_0_0_2_1_0 - 0.0021164021164021*G0_0_0_2_1_1 + 0.0084656084656084*G0_0_0_2_1_2 + 0.00507936507936504*G0_0_0_2_1_3 + 0.00338624338624336*G0_0_0_2_1_4 - 0.00084656084656084*G0_0_0_2_1_5 + 0.00846560846560839*G0_0_0_2_2_0 + 0.0084656084656084*G0_0_0_2_2_1 - 0.0888888888888883*G0_0_0_2_2_2 - 0.0338624338624336*G0_0_0_2_2_3 - 0.042328042328042*G0_0_0_2_2_4 - 0.00423280423280423*G0_0_0_2_2_5 + 0.00507936507936504*G0_0_0_2_3_0 + 0.00507936507936504*G0_0_0_2_3_1 - 0.0338624338624336*G0_0_0_2_3_2 - 0.0338624338624336*G0_0_0_2_3_3 - 0.0169312169312168*G0_0_0_2_3_4 - 0.0016931216931217*G0_0_0_2_3_5 + 0.0118518518518518*G0_0_0_2_4_0 + 0.00338624338624336*G0_0_0_2_4_1 - 0.042328042328042*G0_0_0_2_4_2 - 0.0169312169312168*G0_0_0_2_4_3 - 0.0338624338624336*G0_0_0_2_4_4 + 0.00169312169312168*G0_0_0_2_4_5 + 0.00169312169312169*G0_0_0_2_5_0 - 0.00084656084656084*G0_0_0_2_5_1 - 0.00423280423280423*G0_0_0_2_5_2 - 0.0016931216931217*G0_0_0_2_5_3 + 0.00169312169312168*G0_0_0_2_5_4 + 0.00338624338624337*G0_0_0_2_5_5 - 0.00338624338624337*G0_0_0_3_0_0 - 0.00338624338624336*G0_0_0_3_0_1 + 0.00507936507936504*G0_0_0_3_0_2 + 0.0118518518518518*G0_0_0_3_0_3 + 0.0118518518518518*G0_0_0_3_0_4 + 0.00338624338624337*G0_0_0_3_0_5 - 0.00338624338624336*G0_0_0_3_1_0 + 0.00507936507936504*G0_0_0_3_1_2 + 0.0253968253968253*G0_0_0_3_1_3 + 0.0152380952380952*G0_0_0_3_1_4 + 0.00846560846560842*G0_0_0_3_1_5 + 0.00507936507936504*G0_0_0_3_2_0 + 0.00507936507936504*G0_0_0_3_2_1 - 0.0338624338624336*G0_0_0_3_2_2 - 0.0338624338624336*G0_0_0_3_2_3 - 0.0169312169312168*G0_0_0_3_2_4 - 0.0016931216931217*G0_0_0_3_2_5 + 0.0118518518518518*G0_0_0_3_3_0 + 0.0253968253968253*G0_0_0_3_3_1 - 0.0338624338624336*G0_0_0_3_3_2 - 0.0812698412698408*G0_0_0_3_3_3 - 0.0541798941798939*G0_0_0_3_3_4 - 0.0203174603174602*G0_0_0_3_3_5 + 0.0118518518518518*G0_0_0_3_4_0 + 0.0152380952380952*G0_0_0_3_4_1 - 0.0169312169312168*G0_0_0_3_4_2 - 0.0541798941798939*G0_0_0_3_4_3 - 0.0812698412698408*G0_0_0_3_4_4 - 0.027089947089947*G0_0_0_3_4_5 + 0.00338624338624337*G0_0_0_3_5_0 + 0.00846560846560843*G0_0_0_3_5_1 - 0.0016931216931217*G0_0_0_3_5_2 - 0.0203174603174602*G0_0_0_3_5_3 - 0.027089947089947*G0_0_0_3_5_4 - 0.0135449735449735*G0_0_0_3_5_5 - 0.0126984126984126*G0_0_0_4_0_0 - 0.00253968253968252*G0_0_0_4_0_1 + 0.0118518518518518*G0_0_0_4_0_2 + 0.0118518518518518*G0_0_0_4_0_3 + 0.0152380952380951*G0_0_0_4_0_4 + 0.00169312169312168*G0_0_0_4_0_5 - 0.00253968253968252*G0_0_0_4_1_0 - 0.00423280423280421*G0_0_0_4_1_1 + 0.00338624338624336*G0_0_0_4_1_2 + 0.0152380952380952*G0_0_0_4_1_3 + 0.0287830687830686*G0_0_0_4_1_4 + 0.0101587301587301*G0_0_0_4_1_5 + 0.0118518518518518*G0_0_0_4_2_0 + 0.00338624338624336*G0_0_0_4_2_1 - 0.042328042328042*G0_0_0_4_2_2 - 0.0169312169312168*G0_0_0_4_2_3 - 0.0338624338624337*G0_0_0_4_2_4 + 0.00169312169312168*G0_0_0_4_2_5 + 0.0118518518518518*G0_0_0_4_3_0 + 0.0152380952380952*G0_0_0_4_3_1 - 0.0169312169312168*G0_0_0_4_3_2 - 0.0541798941798939*G0_0_0_4_3_3 - 0.0812698412698408*G0_0_0_4_3_4 - 0.027089947089947*G0_0_0_4_3_5 + 0.0152380952380951*G0_0_0_4_4_0 + 0.0287830687830686*G0_0_0_4_4_1 - 0.0338624338624336*G0_0_0_4_4_2 - 0.0812698412698408*G0_0_0_4_4_3 - 0.325079365079363*G0_0_0_4_4_4 - 0.0609523809523807*G0_0_0_4_4_5 + 0.00169312169312168*G0_0_0_4_5_0 + 0.0101587301587301*G0_0_0_4_5_1 + 0.00169312169312168*G0_0_0_4_5_2 - 0.027089947089947*G0_0_0_4_5_3 - 0.0609523809523807*G0_0_0_4_5_4 - 0.027089947089947*G0_0_0_4_5_5 - 0.00423280423280421*G0_0_0_5_0_0 - 0.00084656084656084*G0_0_0_5_0_1 + 0.00169312169312169*G0_0_0_5_0_2 + 0.00338624338624337*G0_0_0_5_0_3 + 0.00169312169312168*G0_0_0_5_0_4 - 0.00169312169312167*G0_0_0_5_0_5 - 0.00084656084656084*G0_0_0_5_1_0 - 0.00084656084656084*G0_0_0_5_1_2 + 0.00846560846560843*G0_0_0_5_1_3 + 0.0101587301587301*G0_0_0_5_1_4 + 0.00846560846560841*G0_0_0_5_1_5 + 0.00169312169312169*G0_0_0_5_2_0 - 0.00084656084656084*G0_0_0_5_2_1 - 0.00423280423280423*G0_0_0_5_2_2 - 0.0016931216931217*G0_0_0_5_2_3 + 0.00169312169312168*G0_0_0_5_2_4 + 0.00338624338624337*G0_0_0_5_2_5 + 0.00338624338624337*G0_0_0_5_3_0 + 0.00846560846560842*G0_0_0_5_3_1 - 0.0016931216931217*G0_0_0_5_3_2 - 0.0203174603174602*G0_0_0_5_3_3 - 0.027089947089947*G0_0_0_5_3_4 - 0.0135449735449735*G0_0_0_5_3_5 + 0.00169312169312168*G0_0_0_5_4_0 + 0.0101587301587301*G0_0_0_5_4_1 + 0.00169312169312168*G0_0_0_5_4_2 - 0.027089947089947*G0_0_0_5_4_3 - 0.0609523809523807*G0_0_0_5_4_4 - 0.027089947089947*G0_0_0_5_4_5 - 0.00169312169312167*G0_0_0_5_5_0 + 0.00846560846560841*G0_0_0_5_5_1 + 0.00338624338624337*G0_0_0_5_5_2 - 0.0135449735449735*G0_0_0_5_5_3 - 0.027089947089947*G0_0_0_5_5_4 - 0.0203174603174602*G0_0_0_5_5_5 + 0.0825396825396821*G0_0_1_0_0_0 - 0.00677248677248674*G0_0_1_0_0_1 - 0.00888888888888884*G0_0_1_0_0_2 + 0.000846560846560853*G0_0_1_0_0_3 + 0.0296296296296295*G0_0_1_0_0_4 + 0.0296296296296295*G0_0_1_0_0_5 - 0.00677248677248674*G0_0_1_0_1_0 + 0.00211640211640211*G0_0_1_0_1_1 - 0.00253968253968252*G0_0_1_0_1_3 - 0.0059259259259259*G0_0_1_0_1_4 - 0.00592592592592589*G0_0_1_0_1_5 - 0.00888888888888884*G0_0_1_0_2_0 + 0.00888888888888882*G0_0_1_0_2_2 + 0.00338624338624336*G0_0_1_0_2_3 - 0.00338624338624337*G0_0_1_0_2_5 + 0.000846560846560852*G0_0_1_0_3_0 - 0.00253968253968252*G0_0_1_0_3_1 + 0.00338624338624336*G0_0_1_0_3_2 + 0.00846560846560842*G0_0_1_0_3_3 + 0.0101587301587301*G0_0_1_0_3_4 + 0.00507936507936506*G0_0_1_0_3_5 + 0.0296296296296295*G0_0_1_0_4_0 - 0.0059259259259259*G0_0_1_0_4_1 + 0.0101587301587301*G0_0_1_0_4_3 + 0.0491005291005289*G0_0_1_0_4_4 + 0.0186243386243385*G0_0_1_0_4_5 + 0.0296296296296295*G0_0_1_0_5_0 - 0.00592592592592589*G0_0_1_0_5_1 - 0.00338624338624337*G0_0_1_0_5_2 + 0.00507936507936506*G0_0_1_0_5_3 + 0.0186243386243385*G0_0_1_0_5_4 + 0.032169312169312*G0_0_1_0_5_5 - 0.00677248677248674*G0_0_1_1_0_0 + 0.00211640211640211*G0_0_1_1_0_1 - 0.00253968253968252*G0_0_1_1_0_3 - 0.0059259259259259*G0_0_1_1_0_4 - 0.00592592592592589*G0_0_1_1_0_5 + 0.00211640211640211*G0_0_1_1_1_0 - 0.0021164021164021*G0_0_1_1_1_2 - 0.0021164021164021*G0_0_1_1_2_1 + 0.00677248677248672*G0_0_1_1_2_2 + 0.00592592592592589*G0_0_1_1_2_3 + 0.00592592592592589*G0_0_1_1_2_4 + 0.00253968253968253*G0_0_1_1_2_5 - 0.00253968253968252*G0_0_1_1_3_0 + 0.00592592592592589*G0_0_1_1_3_2 + 0.0169312169312168*G0_0_1_1_3_3 + 0.00507936507936505*G0_0_1_1_3_4 - 0.0059259259259259*G0_0_1_1_4_0 + 0.00592592592592589*G0_0_1_1_4_2 + 0.00507936507936505*G0_0_1_1_4_3 - 0.00507936507936506*G0_0_1_1_4_5 - 0.00592592592592589*G0_0_1_1_5_0 + 0.00253968253968253*G0_0_1_1_5_2 - 0.00507936507936506*G0_0_1_1_5_4 - 0.0169312169312168*G0_0_1_1_5_5 - 0.00888888888888884*G0_0_1_2_0_0 + 0.00888888888888882*G0_0_1_2_0_2 + 0.00338624338624336*G0_0_1_2_0_3 - 0.00338624338624337*G0_0_1_2_0_5 - 0.0021164021164021*G0_0_1_2_1_1 + 0.00677248677248672*G0_0_1_2_1_2 + 0.00592592592592589*G0_0_1_2_1_3 + 0.00592592592592589*G0_0_1_2_1_4 + 0.00253968253968253*G0_0_1_2_1_5 + 0.00888888888888882*G0_0_1_2_2_0 + 0.00677248677248672*G0_0_1_2_2_1 - 0.082539682539682*G0_0_1_2_2_2 - 0.0296296296296294*G0_0_1_2_2_3 - 0.0296296296296294*G0_0_1_2_2_4 - 0.000846560846560857*G0_0_1_2_2_5 + 0.00338624338624336*G0_0_1_2_3_0 + 0.00592592592592589*G0_0_1_2_3_1 - 0.0296296296296294*G0_0_1_2_3_2 - 0.032169312169312*G0_0_1_2_3_3 - 0.0186243386243385*G0_0_1_2_3_4 - 0.00507936507936506*G0_0_1_2_3_5 + 0.00592592592592589*G0_0_1_2_4_1 - 0.0296296296296294*G0_0_1_2_4_2 - 0.0186243386243385*G0_0_1_2_4_3 - 0.0491005291005288*G0_0_1_2_4_4 - 0.0101587301587301*G0_0_1_2_4_5 - 0.00338624338624337*G0_0_1_2_5_0 + 0.00253968253968253*G0_0_1_2_5_1 - 0.000846560846560857*G0_0_1_2_5_2 - 0.00507936507936506*G0_0_1_2_5_3 - 0.0101587301587301*G0_0_1_2_5_4 - 0.00846560846560842*G0_0_1_2_5_5 + 0.000846560846560853*G0_0_1_3_0_0 - 0.00253968253968252*G0_0_1_3_0_1 + 0.00338624338624336*G0_0_1_3_0_2 + 0.00846560846560841*G0_0_1_3_0_3 + 0.0101587301587301*G0_0_1_3_0_4 + 0.00507936507936506*G0_0_1_3_0_5 - 0.00253968253968252*G0_0_1_3_1_0 + 0.00592592592592589*G0_0_1_3_1_2 + 0.0169312169312168*G0_0_1_3_1_3 + 0.00507936507936505*G0_0_1_3_1_4 + 0.00338624338624336*G0_0_1_3_2_0 + 0.00592592592592589*G0_0_1_3_2_1 - 0.0296296296296294*G0_0_1_3_2_2 - 0.032169312169312*G0_0_1_3_2_3 - 0.0186243386243385*G0_0_1_3_2_4 - 0.00507936507936506*G0_0_1_3_2_5 + 0.00846560846560841*G0_0_1_3_3_0 + 0.0169312169312168*G0_0_1_3_3_1 - 0.032169312169312*G0_0_1_3_3_2 - 0.0609523809523806*G0_0_1_3_3_3 - 0.027089947089947*G0_0_1_3_3_4 - 0.00677248677248675*G0_0_1_3_3_5 + 0.0101587301587301*G0_0_1_3_4_0 + 0.00507936507936505*G0_0_1_3_4_1 - 0.0186243386243385*G0_0_1_3_4_2 - 0.027089947089947*G0_0_1_3_4_3 - 0.0203174603174602*G0_0_1_3_4_4 + 0.00507936507936506*G0_0_1_3_5_0 - 0.00507936507936506*G0_0_1_3_5_2 - 0.00677248677248675*G0_0_1_3_5_3 + 0.00677248677248673*G0_0_1_3_5_5 + 0.0296296296296295*G0_0_1_4_0_0 - 0.0059259259259259*G0_0_1_4_0_1 + 0.0101587301587301*G0_0_1_4_0_3 + 0.0491005291005289*G0_0_1_4_0_4 + 0.0186243386243385*G0_0_1_4_0_5 - 0.0059259259259259*G0_0_1_4_1_0 + 0.00592592592592589*G0_0_1_4_1_2 + 0.00507936507936505*G0_0_1_4_1_3 - 0.00507936507936505*G0_0_1_4_1_5 + 0.00592592592592589*G0_0_1_4_2_1 - 0.0296296296296294*G0_0_1_4_2_2 - 0.0186243386243385*G0_0_1_4_2_3 - 0.0491005291005288*G0_0_1_4_2_4 - 0.0101587301587301*G0_0_1_4_2_5 + 0.0101587301587301*G0_0_1_4_3_0 + 0.00507936507936505*G0_0_1_4_3_1 - 0.0186243386243385*G0_0_1_4_3_2 - 0.027089947089947*G0_0_1_4_3_3 - 0.0203174603174602*G0_0_1_4_3_4 + 0.0491005291005289*G0_0_1_4_4_0 - 0.0491005291005288*G0_0_1_4_4_2 - 0.0203174603174602*G0_0_1_4_4_3 + 0.0203174603174602*G0_0_1_4_4_5 + 0.0186243386243385*G0_0_1_4_5_0 - 0.00507936507936505*G0_0_1_4_5_1 - 0.0101587301587301*G0_0_1_4_5_2 + 0.0203174603174602*G0_0_1_4_5_4 + 0.027089947089947*G0_0_1_4_5_5 + 0.0296296296296295*G0_0_1_5_0_0 - 0.00592592592592589*G0_0_1_5_0_1 - 0.00338624338624337*G0_0_1_5_0_2 + 0.00507936507936506*G0_0_1_5_0_3 + 0.0186243386243385*G0_0_1_5_0_4 + 0.032169312169312*G0_0_1_5_0_5 - 0.00592592592592589*G0_0_1_5_1_0 + 0.00253968253968253*G0_0_1_5_1_2 - 0.00507936507936506*G0_0_1_5_1_4 - 0.0169312169312168*G0_0_1_5_1_5 - 0.00338624338624337*G0_0_1_5_2_0 + 0.00253968253968253*G0_0_1_5_2_1 - 0.000846560846560858*G0_0_1_5_2_2 - 0.00507936507936506*G0_0_1_5_2_3 - 0.0101587301587301*G0_0_1_5_2_4 - 0.00846560846560842*G0_0_1_5_2_5 + 0.00507936507936506*G0_0_1_5_3_0 - 0.00507936507936506*G0_0_1_5_3_2 - 0.00677248677248675*G0_0_1_5_3_3 + 0.00677248677248673*G0_0_1_5_3_5 + 0.0186243386243385*G0_0_1_5_4_0 - 0.00507936507936505*G0_0_1_5_4_1 - 0.0101587301587301*G0_0_1_5_4_2 + 0.0203174603174602*G0_0_1_5_4_4 + 0.027089947089947*G0_0_1_5_4_5 + 0.032169312169312*G0_0_1_5_5_0 - 0.0169312169312168*G0_0_1_5_5_1 - 0.00846560846560842*G0_0_1_5_5_2 + 0.00677248677248673*G0_0_1_5_5_3 + 0.027089947089947*G0_0_1_5_5_4 + 0.0609523809523805*G0_0_1_5_5_5;
    A[28] = -A[22] - 0.00634920634920629*G0_1_0_0_0_0 + 0.000423280423280421*G0_1_0_0_0_1 + 0.00253968253968252*G0_1_0_0_0_2 - 0.000846560846560841*G0_1_0_0_0_3 - 0.00423280423280421*G0_1_0_0_0_4 - 0.0042328042328042*G0_1_0_0_0_5 + 0.000423280423280421*G0_1_0_0_1_0 + 0.000423280423280417*G0_1_0_0_1_1 + 0.000423280423280419*G0_1_0_0_1_2 + 0.00169312169312168*G0_1_0_0_1_3 + 0.00169312169312168*G0_1_0_0_1_4 + 0.00169312169312168*G0_1_0_0_1_5 + 0.00253968253968252*G0_1_0_0_2_0 + 0.000423280423280419*G0_1_0_0_2_1 - 0.0063492063492063*G0_1_0_0_2_2 - 0.0042328042328042*G0_1_0_0_2_3 - 0.0042328042328042*G0_1_0_0_2_4 - 0.000846560846560843*G0_1_0_0_2_5 - 0.000846560846560841*G0_1_0_0_3_0 + 0.00169312169312168*G0_1_0_0_3_1 - 0.0042328042328042*G0_1_0_0_3_2 + 0.00169312169312168*G0_1_0_0_3_3 - 0.00169312169312168*G0_1_0_0_3_4 + 0.00338624338624337*G0_1_0_0_3_5 - 0.00423280423280421*G0_1_0_0_4_0 + 0.00169312169312168*G0_1_0_0_4_1 - 0.0042328042328042*G0_1_0_0_4_2 - 0.00169312169312168*G0_1_0_0_4_3 - 0.0152380952380952*G0_1_0_0_4_4 - 0.00169312169312169*G0_1_0_0_4_5 - 0.0042328042328042*G0_1_0_0_5_0 + 0.00169312169312168*G0_1_0_0_5_1 - 0.000846560846560843*G0_1_0_0_5_2 + 0.00338624338624337*G0_1_0_0_5_3 - 0.00169312169312169*G0_1_0_0_5_4 + 0.00169312169312169*G0_1_0_0_5_5 + 0.000423280423280421*G0_1_0_1_0_0 + 0.000423280423280417*G0_1_0_1_0_1 + 0.000423280423280419*G0_1_0_1_0_2 + 0.00169312169312168*G0_1_0_1_0_3 + 0.00169312169312168*G0_1_0_1_0_4 + 0.00169312169312168*G0_1_0_1_0_5 + 0.000423280423280417*G0_1_0_1_1_0 - 0.00634920634920628*G0_1_0_1_1_1 + 0.00253968253968252*G0_1_0_1_1_2 - 0.00423280423280421*G0_1_0_1_1_3 - 0.000846560846560842*G0_1_0_1_1_4 - 0.00423280423280419*G0_1_0_1_1_5 + 0.000423280423280419*G0_1_0_1_2_0 + 0.00253968253968252*G0_1_0_1_2_1 - 0.0063492063492063*G0_1_0_1_2_2 - 0.0042328042328042*G0_1_0_1_2_3 - 0.00423280423280421*G0_1_0_1_2_4 - 0.000846560846560845*G0_1_0_1_2_5 + 0.00169312169312168*G0_1_0_1_3_0 - 0.00423280423280421*G0_1_0_1_3_1 - 0.0042328042328042*G0_1_0_1_3_2 - 0.0152380952380952*G0_1_0_1_3_3 - 0.00169312169312168*G0_1_0_1_3_4 - 0.00169312169312168*G0_1_0_1_3_5 + 0.00169312169312168*G0_1_0_1_4_0 - 0.000846560846560842*G0_1_0_1_4_1 - 0.00423280423280421*G0_1_0_1_4_2 - 0.00169312169312168*G0_1_0_1_4_3 + 0.00169312169312169*G0_1_0_1_4_4 + 0.00338624338624337*G0_1_0_1_4_5 + 0.00169312169312168*G0_1_0_1_5_0 - 0.00423280423280419*G0_1_0_1_5_1 - 0.000846560846560845*G0_1_0_1_5_2 - 0.00169312169312168*G0_1_0_1_5_3 + 0.00338624338624337*G0_1_0_1_5_4 + 0.0016931216931217*G0_1_0_1_5_5 + 0.00253968253968252*G0_1_0_2_0_0 + 0.000423280423280419*G0_1_0_2_0_1 - 0.0063492063492063*G0_1_0_2_0_2 - 0.0042328042328042*G0_1_0_2_0_3 - 0.0042328042328042*G0_1_0_2_0_4 - 0.000846560846560843*G0_1_0_2_0_5 + 0.000423280423280419*G0_1_0_2_1_0 + 0.00253968253968252*G0_1_0_2_1_1 - 0.0063492063492063*G0_1_0_2_1_2 - 0.0042328042328042*G0_1_0_2_1_3 - 0.00423280423280421*G0_1_0_2_1_4 - 0.000846560846560845*G0_1_0_2_1_5 - 0.0063492063492063*G0_1_0_2_2_0 - 0.0063492063492063*G0_1_0_2_2_1 + 0.0761904761904757*G0_1_0_2_2_2 + 0.0253968253968252*G0_1_0_2_2_3 + 0.0253968253968252*G0_1_0_2_2_4 - 0.0042328042328042*G0_1_0_2_3_0 - 0.0042328042328042*G0_1_0_2_3_1 + 0.0253968253968252*G0_1_0_2_3_2 + 0.0338624338624337*G0_1_0_2_3_3 + 0.0169312169312168*G0_1_0_2_3_4 + 0.00846560846560843*G0_1_0_2_3_5 - 0.0042328042328042*G0_1_0_2_4_0 - 0.00423280423280421*G0_1_0_2_4_1 + 0.0253968253968252*G0_1_0_2_4_2 + 0.0169312169312168*G0_1_0_2_4_3 + 0.0338624338624337*G0_1_0_2_4_4 + 0.00846560846560843*G0_1_0_2_4_5 - 0.000846560846560843*G0_1_0_2_5_0 - 0.000846560846560845*G0_1_0_2_5_1 + 0.00846560846560843*G0_1_0_2_5_3 + 0.00846560846560843*G0_1_0_2_5_4 + 0.0101587301587301*G0_1_0_2_5_5 - 0.000846560846560841*G0_1_0_3_0_0 + 0.00169312169312168*G0_1_0_3_0_1 - 0.0042328042328042*G0_1_0_3_0_2 + 0.00169312169312169*G0_1_0_3_0_3 - 0.00169312169312168*G0_1_0_3_0_4 + 0.00338624338624337*G0_1_0_3_0_5 + 0.00169312169312168*G0_1_0_3_1_0 - 0.00423280423280421*G0_1_0_3_1_1 - 0.0042328042328042*G0_1_0_3_1_2 - 0.0152380952380952*G0_1_0_3_1_3 - 0.00169312169312168*G0_1_0_3_1_4 - 0.00169312169312168*G0_1_0_3_1_5 - 0.0042328042328042*G0_1_0_3_2_0 - 0.0042328042328042*G0_1_0_3_2_1 + 0.0253968253968252*G0_1_0_3_2_2 + 0.0338624338624337*G0_1_0_3_2_3 + 0.0169312169312168*G0_1_0_3_2_4 + 0.00846560846560843*G0_1_0_3_2_5 + 0.00169312169312169*G0_1_0_3_3_0 - 0.0152380952380952*G0_1_0_3_3_1 + 0.0338624338624337*G0_1_0_3_3_2 - 0.0203174603174602*G0_1_0_3_3_5 - 0.00169312169312168*G0_1_0_3_4_0 - 0.00169312169312168*G0_1_0_3_4_1 + 0.0169312169312168*G0_1_0_3_4_2 - 0.0135449735449735*G0_1_0_3_4_5 + 0.00338624338624337*G0_1_0_3_5_0 - 0.00169312169312168*G0_1_0_3_5_1 + 0.00846560846560843*G0_1_0_3_5_2 - 0.0203174603174602*G0_1_0_3_5_3 - 0.0135449735449735*G0_1_0_3_5_4 - 0.027089947089947*G0_1_0_3_5_5 - 0.00423280423280421*G0_1_0_4_0_0 + 0.00169312169312168*G0_1_0_4_0_1 - 0.0042328042328042*G0_1_0_4_0_2 - 0.00169312169312168*G0_1_0_4_0_3 - 0.0152380952380952*G0_1_0_4_0_4 - 0.00169312169312169*G0_1_0_4_0_5 + 0.00169312169312168*G0_1_0_4_1_0 - 0.000846560846560842*G0_1_0_4_1_1 - 0.00423280423280421*G0_1_0_4_1_2 - 0.00169312169312168*G0_1_0_4_1_3 + 0.00169312169312169*G0_1_0_4_1_4 + 0.00338624338624337*G0_1_0_4_1_5 - 0.0042328042328042*G0_1_0_4_2_0 - 0.00423280423280421*G0_1_0_4_2_1 + 0.0253968253968252*G0_1_0_4_2_2 + 0.0169312169312168*G0_1_0_4_2_3 + 0.0338624338624337*G0_1_0_4_2_4 + 0.00846560846560843*G0_1_0_4_2_5 - 0.00169312169312168*G0_1_0_4_3_0 - 0.00169312169312168*G0_1_0_4_3_1 + 0.0169312169312168*G0_1_0_4_3_2 - 0.0135449735449735*G0_1_0_4_3_5 - 0.0152380952380952*G0_1_0_4_4_0 + 0.00169312169312169*G0_1_0_4_4_1 + 0.0338624338624337*G0_1_0_4_4_2 - 0.0203174603174602*G0_1_0_4_4_5 - 0.00169312169312169*G0_1_0_4_5_0 + 0.00338624338624337*G0_1_0_4_5_1 + 0.00846560846560843*G0_1_0_4_5_2 - 0.0135449735449735*G0_1_0_4_5_3 - 0.0203174603174602*G0_1_0_4_5_4 - 0.0270899470899469*G0_1_0_4_5_5 - 0.0042328042328042*G0_1_0_5_0_0 + 0.00169312169312168*G0_1_0_5_0_1 - 0.000846560846560843*G0_1_0_5_0_2 + 0.00338624338624337*G0_1_0_5_0_3 - 0.00169312169312169*G0_1_0_5_0_4 + 0.00169312169312169*G0_1_0_5_0_5 + 0.00169312169312168*G0_1_0_5_1_0 - 0.00423280423280419*G0_1_0_5_1_1 - 0.000846560846560845*G0_1_0_5_1_2 - 0.00169312169312168*G0_1_0_5_1_3 + 0.00338624338624337*G0_1_0_5_1_4 + 0.0016931216931217*G0_1_0_5_1_5 - 0.000846560846560843*G0_1_0_5_2_0 - 0.000846560846560845*G0_1_0_5_2_1 + 0.00846560846560843*G0_1_0_5_2_3 + 0.00846560846560843*G0_1_0_5_2_4 + 0.0101587301587301*G0_1_0_5_2_5 + 0.00338624338624337*G0_1_0_5_3_0 - 0.00169312169312168*G0_1_0_5_3_1 + 0.00846560846560843*G0_1_0_5_3_2 - 0.0203174603174602*G0_1_0_5_3_3 - 0.0135449735449735*G0_1_0_5_3_4 - 0.027089947089947*G0_1_0_5_3_5 - 0.00169312169312169*G0_1_0_5_4_0 + 0.00338624338624337*G0_1_0_5_4_1 + 0.00846560846560843*G0_1_0_5_4_2 - 0.0135449735449735*G0_1_0_5_4_3 - 0.0203174603174602*G0_1_0_5_4_4 - 0.0270899470899469*G0_1_0_5_4_5 + 0.00169312169312169*G0_1_0_5_5_0 + 0.0016931216931217*G0_1_0_5_5_1 + 0.0101587301587301*G0_1_0_5_5_2 - 0.027089947089947*G0_1_0_5_5_3 - 0.0270899470899469*G0_1_0_5_5_4 - 0.0609523809523805*G0_1_0_5_5_5 + 0.0825396825396821*G0_1_1_0_0_0 - 0.008042328042328*G0_1_1_0_0_1 - 0.0059259259259259*G0_1_1_0_0_2 + 0.00338624338624337*G0_1_1_0_0_3 + 0.0296296296296295*G0_1_1_0_0_4 + 0.0380952380952379*G0_1_1_0_0_5 - 0.00804232804232799*G0_1_1_0_1_0 + 0.000846560846560839*G0_1_1_0_1_1 + 0.00169312169312168*G0_1_1_0_1_2 - 0.00338624338624337*G0_1_1_0_1_4 - 0.0101587301587301*G0_1_1_0_1_5 - 0.0059259259259259*G0_1_1_0_2_0 + 0.00169312169312168*G0_1_1_0_2_1 - 0.00423280423280419*G0_1_1_0_2_2 - 0.00338624338624336*G0_1_1_0_2_3 - 0.00931216931216926*G0_1_1_0_2_4 - 0.00423280423280421*G0_1_1_0_2_5 + 0.00338624338624337*G0_1_1_0_3_0 - 0.00338624338624336*G0_1_1_0_3_2 - 0.00169312169312168*G0_1_1_0_3_3 + 0.00169312169312168*G0_1_1_0_3_5 + 0.0296296296296295*G0_1_1_0_4_0 - 0.00338624338624337*G0_1_1_0_4_1 - 0.00931216931216926*G0_1_1_0_4_2 + 0.0186243386243385*G0_1_1_0_4_4 + 0.0152380952380952*G0_1_1_0_4_5 + 0.0380952380952379*G0_1_1_0_5_0 - 0.0101587301587301*G0_1_1_0_5_1 - 0.00423280423280421*G0_1_1_0_5_2 + 0.00169312169312168*G0_1_1_0_5_3 + 0.0152380952380952*G0_1_1_0_5_4 + 0.0355555555555553*G0_1_1_0_5_5 - 0.008042328042328*G0_1_1_1_0_0 + 0.00084656084656084*G0_1_1_1_0_1 + 0.00169312169312168*G0_1_1_1_0_2 - 0.00338624338624337*G0_1_1_1_0_4 - 0.0101587301587301*G0_1_1_1_0_5 + 0.00084656084656084*G0_1_1_1_1_0 + 0.000846560846560838*G0_1_1_1_1_2 + 0.00253968253968253*G0_1_1_1_1_4 + 0.00846560846560843*G0_1_1_1_1_5 + 0.00169312169312168*G0_1_1_1_2_0 + 0.000846560846560839*G0_1_1_1_2_1 - 0.00634920634920631*G0_1_1_1_2_2 - 0.00338624338624336*G0_1_1_1_2_3 - 0.000846560846560837*G0_1_1_1_2_4 + 0.00169312169312168*G0_1_1_1_2_5 - 0.00338624338624336*G0_1_1_1_3_2 - 0.0135449735449735*G0_1_1_1_3_3 - 0.00507936507936506*G0_1_1_1_3_4 - 0.00338624338624337*G0_1_1_1_3_5 - 0.00338624338624337*G0_1_1_1_4_0 + 0.00253968253968253*G0_1_1_1_4_1 - 0.000846560846560836*G0_1_1_1_4_2 - 0.00507936507936505*G0_1_1_1_4_3 - 0.0101587301587301*G0_1_1_1_4_4 - 0.00846560846560842*G0_1_1_1_4_5 - 0.0101587301587301*G0_1_1_1_5_0 + 0.00846560846560843*G0_1_1_1_5_1 + 0.00169312169312168*G0_1_1_1_5_2 - 0.00338624338624337*G0_1_1_1_5_3 - 0.00846560846560842*G0_1_1_1_5_4 - 0.0135449735449734*G0_1_1_1_5_5 - 0.0059259259259259*G0_1_1_2_0_0 + 0.00169312169312168*G0_1_1_2_0_1 - 0.00423280423280419*G0_1_1_2_0_2 - 0.00338624338624336*G0_1_1_2_0_3 - 0.00931216931216926*G0_1_1_2_0_4 - 0.00423280423280421*G0_1_1_2_0_5 + 0.00169312169312168*G0_1_1_2_1_0 + 0.000846560846560839*G0_1_1_2_1_1 - 0.00634920634920631*G0_1_1_2_1_2 - 0.00338624338624336*G0_1_1_2_1_3 - 0.000846560846560836*G0_1_1_2_1_4 + 0.00169312169312168*G0_1_1_2_1_5 - 0.00423280423280419*G0_1_1_2_2_0 - 0.00634920634920631*G0_1_1_2_2_1 + 0.0698412698412695*G0_1_1_2_2_2 + 0.0253968253968252*G0_1_1_2_2_3 + 0.0253968253968252*G0_1_1_2_2_4 + 0.00423280423280423*G0_1_1_2_2_5 - 0.00338624338624336*G0_1_1_2_3_0 - 0.00338624338624336*G0_1_1_2_3_1 + 0.0253968253968252*G0_1_1_2_3_2 + 0.0253968253968252*G0_1_1_2_3_3 + 0.00846560846560841*G0_1_1_2_3_4 - 0.00169312169312168*G0_1_1_2_3_5 - 0.00931216931216926*G0_1_1_2_4_0 - 0.000846560846560837*G0_1_1_2_4_1 + 0.0253968253968252*G0_1_1_2_4_2 + 0.00846560846560841*G0_1_1_2_4_3 + 0.0084656084656084*G0_1_1_2_4_4 - 0.00677248677248674*G0_1_1_2_4_5 - 0.00423280423280421*G0_1_1_2_5_0 + 0.00169312169312168*G0_1_1_2_5_1 + 0.00423280423280423*G0_1_1_2_5_2 - 0.00169312169312168*G0_1_1_2_5_3 - 0.00677248677248674*G0_1_1_2_5_4 - 0.0186243386243385*G0_1_1_2_5_5 + 0.00338624338624337*G0_1_1_3_0_0 - 0.00338624338624336*G0_1_1_3_0_2 - 0.00169312169312168*G0_1_1_3_0_3 + 0.00169312169312168*G0_1_1_3_0_5 - 0.00338624338624336*G0_1_1_3_1_2 - 0.0135449735449735*G0_1_1_3_1_3 - 0.00507936507936505*G0_1_1_3_1_4 - 0.00338624338624337*G0_1_1_3_1_5 - 0.00338624338624336*G0_1_1_3_2_0 - 0.00338624338624336*G0_1_1_3_2_1 + 0.0253968253968252*G0_1_1_3_2_2 + 0.0253968253968252*G0_1_1_3_2_3 + 0.00846560846560841*G0_1_1_3_2_4 - 0.00169312169312168*G0_1_1_3_2_5 - 0.00169312169312168*G0_1_1_3_3_0 - 0.0135449735449735*G0_1_1_3_3_1 + 0.0253968253968252*G0_1_1_3_3_2 + 0.0203174603174602*G0_1_1_3_3_3 + 0.0135449735449735*G0_1_1_3_3_4 + 0.00677248677248675*G0_1_1_3_3_5 - 0.00507936507936505*G0_1_1_3_4_1 + 0.00846560846560841*G0_1_1_3_4_2 + 0.0135449735449735*G0_1_1_3_4_3 + 0.0203174603174602*G0_1_1_3_4_4 + 0.0135449735449735*G0_1_1_3_4_5 + 0.00169312169312168*G0_1_1_3_5_0 - 0.00338624338624337*G0_1_1_3_5_1 - 0.00169312169312168*G0_1_1_3_5_2 + 0.00677248677248675*G0_1_1_3_5_3 + 0.0135449735449735*G0_1_1_3_5_4 + 0.0338624338624337*G0_1_1_3_5_5 + 0.0296296296296295*G0_1_1_4_0_0 - 0.00338624338624337*G0_1_1_4_0_1 - 0.00931216931216926*G0_1_1_4_0_2 + 0.0186243386243385*G0_1_1_4_0_4 + 0.0152380952380952*G0_1_1_4_0_5 - 0.00338624338624337*G0_1_1_4_1_0 + 0.00253968253968253*G0_1_1_4_1_1 - 0.000846560846560836*G0_1_1_4_1_2 - 0.00507936507936505*G0_1_1_4_1_3 - 0.0101587301587301*G0_1_1_4_1_4 - 0.00846560846560842*G0_1_1_4_1_5 - 0.00931216931216926*G0_1_1_4_2_0 - 0.000846560846560836*G0_1_1_4_2_1 + 0.0253968253968252*G0_1_1_4_2_2 + 0.00846560846560841*G0_1_1_4_2_3 + 0.0084656084656084*G0_1_1_4_2_4 - 0.00677248677248674*G0_1_1_4_2_5 - 0.00507936507936505*G0_1_1_4_3_1 + 0.00846560846560841*G0_1_1_4_3_2 + 0.0135449735449735*G0_1_1_4_3_3 + 0.0203174603174602*G0_1_1_4_3_4 + 0.0135449735449735*G0_1_1_4_3_5 + 0.0186243386243385*G0_1_1_4_4_0 - 0.0101587301587301*G0_1_1_4_4_1 + 0.00846560846560839*G0_1_1_4_4_2 + 0.0203174603174602*G0_1_1_4_4_3 + 0.0812698412698409*G0_1_1_4_4_4 + 0.0338624338624337*G0_1_1_4_4_5 + 0.0152380952380952*G0_1_1_4_5_0 - 0.00846560846560842*G0_1_1_4_5_1 - 0.00677248677248674*G0_1_1_4_5_2 + 0.0135449735449735*G0_1_1_4_5_3 + 0.0338624338624337*G0_1_1_4_5_4 + 0.0541798941798939*G0_1_1_4_5_5 + 0.0380952380952379*G0_1_1_5_0_0 - 0.0101587301587301*G0_1_1_5_0_1 - 0.00423280423280421*G0_1_1_5_0_2 + 0.00169312169312168*G0_1_1_5_0_3 + 0.0152380952380952*G0_1_1_5_0_4 + 0.0355555555555553*G0_1_1_5_0_5 - 0.0101587301587301*G0_1_1_5_1_0 + 0.00846560846560843*G0_1_1_5_1_1 + 0.00169312169312168*G0_1_1_5_1_2 - 0.00338624338624337*G0_1_1_5_1_3 - 0.00846560846560842*G0_1_1_5_1_4 - 0.0135449735449734*G0_1_1_5_1_5 - 0.00423280423280421*G0_1_1_5_2_0 + 0.00169312169312168*G0_1_1_5_2_1 + 0.00423280423280423*G0_1_1_5_2_2 - 0.00169312169312168*G0_1_1_5_2_3 - 0.00677248677248674*G0_1_1_5_2_4 - 0.0186243386243385*G0_1_1_5_2_5 + 0.00169312169312168*G0_1_1_5_3_0 - 0.00338624338624337*G0_1_1_5_3_1 - 0.00169312169312168*G0_1_1_5_3_2 + 0.00677248677248675*G0_1_1_5_3_3 + 0.0135449735449735*G0_1_1_5_3_4 + 0.0338624338624337*G0_1_1_5_3_5 + 0.0152380952380952*G0_1_1_5_4_0 - 0.00846560846560842*G0_1_1_5_4_1 - 0.00677248677248674*G0_1_1_5_4_2 + 0.0135449735449735*G0_1_1_5_4_3 + 0.0338624338624337*G0_1_1_5_4_4 + 0.0541798941798939*G0_1_1_5_4_5 + 0.0355555555555553*G0_1_1_5_5_0 - 0.0135449735449734*G0_1_1_5_5_1 - 0.0186243386243385*G0_1_1_5_5_2 + 0.0338624338624337*G0_1_1_5_5_3 + 0.0541798941798939*G0_1_1_5_5_4 + 0.264126984126983*G0_1_1_5_5_5;
    A[19] = -A[25] - 0.0190476190476189*G0_1_0_0_0_0 + 0.00253968253968252*G0_1_0_0_0_1 + 0.00148148148148148*G0_1_0_0_0_2 + 0.00126984126984126*G0_1_0_0_0_3 - 0.00634920634920632*G0_1_0_0_0_4 - 0.00211640211640211*G0_1_0_0_0_5 + 0.00253968253968252*G0_1_0_0_1_0 - 0.0063492063492063*G0_1_0_0_1_1 + 0.000740740740740735*G0_1_0_0_1_2 - 0.00296296296296294*G0_1_0_0_1_3 + 0.000423280423280423*G0_1_0_0_1_4 - 0.00550264550264546*G0_1_0_0_1_5 + 0.00148148148148148*G0_1_0_0_2_0 + 0.000740740740740735*G0_1_0_0_2_1 - 0.0021164021164021*G0_1_0_0_2_2 + 0.00126984126984126*G0_1_0_0_2_3 + 0.000846560846560844*G0_1_0_0_2_4 + 0.00253968253968253*G0_1_0_0_2_5 + 0.00126984126984126*G0_1_0_0_3_0 - 0.00296296296296294*G0_1_0_0_3_1 + 0.00126984126984126*G0_1_0_0_3_2 - 0.00761904761904757*G0_1_0_0_3_3 - 0.00338624338624337*G0_1_0_0_3_4 - 0.00761904761904758*G0_1_0_0_3_5 - 0.00634920634920632*G0_1_0_0_4_0 + 0.000423280423280423*G0_1_0_0_4_1 + 0.000846560846560844*G0_1_0_0_4_2 - 0.00338624338624337*G0_1_0_0_4_3 - 0.011005291005291*G0_1_0_0_4_4 - 0.0059259259259259*G0_1_0_0_4_5 - 0.00211640211640211*G0_1_0_0_5_0 - 0.00550264550264546*G0_1_0_0_5_1 + 0.00253968253968253*G0_1_0_0_5_2 - 0.00761904761904758*G0_1_0_0_5_3 - 0.0059259259259259*G0_1_0_0_5_4 - 0.0194708994708993*G0_1_0_0_5_5 + 0.00253968253968252*G0_1_0_1_0_0 - 0.0063492063492063*G0_1_0_1_0_1 + 0.000740740740740735*G0_1_0_1_0_2 - 0.00296296296296294*G0_1_0_1_0_3 + 0.000423280423280423*G0_1_0_1_0_4 - 0.00550264550264546*G0_1_0_1_0_5 - 0.0063492063492063*G0_1_0_1_1_0 + 0.0634920634920631*G0_1_0_1_1_1 - 0.00529100529100526*G0_1_0_1_1_2 + 0.0232804232804231*G0_1_0_1_1_3 + 0.00211640211640211*G0_1_0_1_1_4 + 0.0275132275132273*G0_1_0_1_1_5 + 0.000740740740740735*G0_1_0_1_2_0 - 0.00529100529100526*G0_1_0_1_2_1 - 0.00507936507936505*G0_1_0_1_2_3 - 0.00126984126984126*G0_1_0_1_2_4 - 0.00338624338624337*G0_1_0_1_2_5 - 0.00296296296296294*G0_1_0_1_3_0 + 0.0232804232804231*G0_1_0_1_3_1 - 0.00507936507936505*G0_1_0_1_3_2 + 0.0211640211640211*G0_1_0_1_3_3 + 0.00169312169312168*G0_1_0_1_3_4 + 0.0126984126984126*G0_1_0_1_3_5 + 0.000423280423280424*G0_1_0_1_4_0 + 0.00211640211640211*G0_1_0_1_4_1 - 0.00126984126984126*G0_1_0_1_4_2 + 0.00169312169312169*G0_1_0_1_4_3 + 0.000846560846560845*G0_1_0_1_4_4 + 0.00253968253968253*G0_1_0_1_4_5 - 0.00550264550264546*G0_1_0_1_5_0 + 0.0275132275132273*G0_1_0_1_5_1 - 0.00338624338624337*G0_1_0_1_5_2 + 0.0126984126984126*G0_1_0_1_5_3 + 0.00253968253968253*G0_1_0_1_5_4 + 0.0296296296296295*G0_1_0_1_5_5 + 0.00148148148148148*G0_1_0_2_0_0 + 0.000740740740740735*G0_1_0_2_0_1 - 0.0021164021164021*G0_1_0_2_0_2 + 0.00126984126984126*G0_1_0_2_0_3 + 0.000846560846560845*G0_1_0_2_0_4 + 0.00253968253968253*G0_1_0_2_0_5 + 0.000740740740740735*G0_1_0_2_1_0 - 0.00529100529100526*G0_1_0_2_1_1 - 0.00507936507936505*G0_1_0_2_1_3 - 0.00126984126984126*G0_1_0_2_1_4 - 0.00338624338624337*G0_1_0_2_1_5 - 0.0021164021164021*G0_1_0_2_2_0 + 0.0158730158730158*G0_1_0_2_2_2 + 0.00634920634920632*G0_1_0_2_2_3 + 0.00634920634920631*G0_1_0_2_2_4 + 0.00211640211640211*G0_1_0_2_2_5 + 0.00126984126984126*G0_1_0_2_3_0 - 0.00507936507936505*G0_1_0_2_3_1 + 0.00634920634920632*G0_1_0_2_3_2 - 0.00846560846560843*G0_1_0_2_3_3 - 0.00677248677248674*G0_1_0_2_3_5 + 0.000846560846560845*G0_1_0_2_4_0 - 0.00126984126984126*G0_1_0_2_4_1 + 0.00634920634920631*G0_1_0_2_4_2 + 0.00846560846560843*G0_1_0_2_4_4 - 0.00169312169312168*G0_1_0_2_4_5 + 0.00253968253968253*G0_1_0_2_5_0 - 0.00338624338624337*G0_1_0_2_5_1 + 0.00211640211640211*G0_1_0_2_5_2 - 0.00677248677248674*G0_1_0_2_5_3 - 0.00169312169312168*G0_1_0_2_5_4 - 0.0118518518518518*G0_1_0_2_5_5 + 0.00126984126984126*G0_1_0_3_0_0 - 0.00296296296296294*G0_1_0_3_0_1 + 0.00126984126984126*G0_1_0_3_0_2 - 0.00761904761904757*G0_1_0_3_0_3 - 0.00338624338624337*G0_1_0_3_0_4 - 0.00761904761904758*G0_1_0_3_0_5 - 0.00296296296296294*G0_1_0_3_1_0 + 0.0232804232804231*G0_1_0_3_1_1 - 0.00507936507936505*G0_1_0_3_1_2 + 0.0211640211640211*G0_1_0_3_1_3 + 0.00169312169312168*G0_1_0_3_1_4 + 0.0126984126984126*G0_1_0_3_1_5 + 0.00126984126984126*G0_1_0_3_2_0 - 0.00507936507936505*G0_1_0_3_2_1 + 0.00634920634920632*G0_1_0_3_2_2 - 0.00846560846560843*G0_1_0_3_2_3 - 0.00677248677248674*G0_1_0_3_2_5 - 0.00761904761904757*G0_1_0_3_3_0 + 0.0211640211640211*G0_1_0_3_3_1 - 0.00846560846560843*G0_1_0_3_3_2 + 0.0558730158730156*G0_1_0_3_3_3 + 0.0118518518518518*G0_1_0_3_3_4 + 0.0287830687830687*G0_1_0_3_3_5 - 0.00338624338624337*G0_1_0_3_4_0 + 0.00169312169312169*G0_1_0_3_4_1 + 0.0118518518518518*G0_1_0_3_4_3 + 0.00507936507936506*G0_1_0_3_4_4 + 0.0101587301587301*G0_1_0_3_4_5 - 0.00761904761904758*G0_1_0_3_5_0 + 0.0126984126984126*G0_1_0_3_5_1 - 0.00677248677248674*G0_1_0_3_5_2 + 0.0287830687830687*G0_1_0_3_5_3 + 0.0101587301587301*G0_1_0_3_5_4 + 0.0389417989417987*G0_1_0_3_5_5 - 0.00634920634920632*G0_1_0_4_0_0 + 0.000423280423280423*G0_1_0_4_0_1 + 0.000846560846560845*G0_1_0_4_0_2 - 0.00338624338624337*G0_1_0_4_0_3 - 0.011005291005291*G0_1_0_4_0_4 - 0.0059259259259259*G0_1_0_4_0_5 + 0.000423280423280424*G0_1_0_4_1_0 + 0.00211640211640211*G0_1_0_4_1_1 - 0.00126984126984126*G0_1_0_4_1_2 + 0.00169312169312168*G0_1_0_4_1_3 + 0.000846560846560845*G0_1_0_4_1_4 + 0.00253968253968253*G0_1_0_4_1_5 + 0.000846560846560845*G0_1_0_4_2_0 - 0.00126984126984126*G0_1_0_4_2_1 + 0.00634920634920631*G0_1_0_4_2_2 + 0.00846560846560843*G0_1_0_4_2_4 - 0.00169312169312168*G0_1_0_4_2_5 - 0.00338624338624337*G0_1_0_4_3_0 + 0.00169312169312169*G0_1_0_4_3_1 + 0.0118518518518518*G0_1_0_4_3_3 + 0.00507936507936506*G0_1_0_4_3_4 + 0.0101587301587301*G0_1_0_4_3_5 - 0.011005291005291*G0_1_0_4_4_0 + 0.000846560846560845*G0_1_0_4_4_1 + 0.00846560846560843*G0_1_0_4_4_2 + 0.00507936507936506*G0_1_0_4_4_3 - 0.00507936507936506*G0_1_0_4_4_4 + 0.00169312169312168*G0_1_0_4_4_5 - 0.0059259259259259*G0_1_0_4_5_0 + 0.00253968253968253*G0_1_0_4_5_1 - 0.00169312169312168*G0_1_0_4_5_2 + 0.0101587301587301*G0_1_0_4_5_3 + 0.00169312169312168*G0_1_0_4_5_4 + 0.0186243386243385*G0_1_0_4_5_5 - 0.00211640211640211*G0_1_0_5_0_0 - 0.00550264550264546*G0_1_0_5_0_1 + 0.00253968253968253*G0_1_0_5_0_2 - 0.00761904761904758*G0_1_0_5_0_3 - 0.0059259259259259*G0_1_0_5_0_4 - 0.0194708994708993*G0_1_0_5_0_5 - 0.00550264550264546*G0_1_0_5_1_0 + 0.0275132275132273*G0_1_0_5_1_1 - 0.00338624338624337*G0_1_0_5_1_2 + 0.0126984126984126*G0_1_0_5_1_3 + 0.00253968253968253*G0_1_0_5_1_4 + 0.0296296296296295*G0_1_0_5_1_5 + 0.00253968253968253*G0_1_0_5_2_0 - 0.00338624338624337*G0_1_0_5_2_1 + 0.00211640211640211*G0_1_0_5_2_2 - 0.00677248677248674*G0_1_0_5_2_3 - 0.00169312169312168*G0_1_0_5_2_4 - 0.0118518518518518*G0_1_0_5_2_5 - 0.00761904761904758*G0_1_0_5_3_0 + 0.0126984126984126*G0_1_0_5_3_1 - 0.00677248677248674*G0_1_0_5_3_2 + 0.0287830687830687*G0_1_0_5_3_3 + 0.0101587301587301*G0_1_0_5_3_4 + 0.0389417989417987*G0_1_0_5_3_5 - 0.0059259259259259*G0_1_0_5_4_0 + 0.00253968253968253*G0_1_0_5_4_1 - 0.00169312169312168*G0_1_0_5_4_2 + 0.0101587301587301*G0_1_0_5_4_3 + 0.00169312169312168*G0_1_0_5_4_4 + 0.0186243386243385*G0_1_0_5_4_5 - 0.0194708994708993*G0_1_0_5_5_0 + 0.0296296296296295*G0_1_0_5_5_1 - 0.0118518518518518*G0_1_0_5_5_2 + 0.0389417989417987*G0_1_0_5_5_3 + 0.0186243386243385*G0_1_0_5_5_4 + 0.147301587301586*G0_1_0_5_5_5;
    A[31] = -A[19] - 0.019047619047619*G0_0_0_0_0_0 + 0.000634920634920635*G0_0_0_0_0_1 + 0.00169312169312169*G0_0_0_0_0_2 - 0.00126984126984126*G0_0_0_0_0_3 - 0.0105820105820105*G0_0_0_0_0_4 - 0.00634920634920631*G0_0_0_0_0_5 + 0.000634920634920634*G0_0_0_0_1_0 + 0.0042328042328042*G0_0_0_0_1_1 - 0.000952380952380947*G0_0_0_0_1_2 + 0.0021164021164021*G0_0_0_0_1_3 + 0.000846560846560845*G0_0_0_0_1_4 + 0.00423280423280421*G0_0_0_0_1_5 + 0.00169312169312169*G0_0_0_0_2_0 - 0.000952380952380947*G0_0_0_0_2_1 + 0.00169312169312168*G0_0_0_0_2_2 + 0.000423280423280421*G0_0_0_0_2_3 + 0.00465608465608463*G0_0_0_0_2_4 + 0.000423280423280424*G0_0_0_0_2_5 - 0.00126984126984126*G0_0_0_0_3_0 + 0.0021164021164021*G0_0_0_0_3_1 + 0.000423280423280421*G0_0_0_0_3_2 + 0.00253968253968252*G0_0_0_0_3_3 + 0.00084656084656084*G0_0_0_0_3_4 + 0.00169312169312168*G0_0_0_0_3_5 - 0.0105820105820105*G0_0_0_0_4_0 + 0.000846560846560845*G0_0_0_0_4_1 + 0.00465608465608463*G0_0_0_0_4_2 + 0.00084656084656084*G0_0_0_0_4_3 - 0.00592592592592591*G0_0_0_0_4_4 - 0.00253968253968253*G0_0_0_0_4_5 - 0.00634920634920631*G0_0_0_0_5_0 + 0.00423280423280421*G0_0_0_0_5_1 + 0.000423280423280424*G0_0_0_0_5_2 + 0.00169312169312168*G0_0_0_0_5_3 - 0.00253968253968253*G0_0_0_0_5_4 + 0.00253968253968252*G0_0_0_0_5_5 + 0.000634920634920634*G0_0_0_1_0_0 + 0.0042328042328042*G0_0_0_1_0_1 - 0.000952380952380947*G0_0_0_1_0_2 + 0.0021164021164021*G0_0_0_1_0_3 + 0.000846560846560845*G0_0_0_1_0_4 + 0.00423280423280421*G0_0_0_1_0_5 + 0.0042328042328042*G0_0_0_1_1_0 - 0.0539682539682537*G0_0_0_1_1_1 + 0.00423280423280421*G0_0_0_1_1_2 - 0.0190476190476189*G0_0_0_1_1_3 - 0.00211640211640211*G0_0_0_1_1_4 - 0.0190476190476189*G0_0_0_1_1_5 - 0.000952380952380947*G0_0_0_1_2_0 + 0.00423280423280421*G0_0_0_1_2_1 + 0.000634920634920629*G0_0_0_1_2_2 + 0.00423280423280421*G0_0_0_1_2_3 + 0.000846560846560841*G0_0_0_1_2_4 + 0.00211640211640211*G0_0_0_1_2_5 + 0.0021164021164021*G0_0_0_1_3_0 - 0.0190476190476189*G0_0_0_1_3_1 + 0.00423280423280421*G0_0_0_1_3_2 - 0.0169312169312168*G0_0_0_1_3_3 - 0.00846560846560842*G0_0_0_1_3_5 + 0.000846560846560845*G0_0_0_1_4_0 - 0.00211640211640211*G0_0_0_1_4_1 + 0.000846560846560841*G0_0_0_1_4_2 + 0.00677248677248674*G0_0_0_1_4_4 + 0.00423280423280421*G0_0_0_1_5_0 - 0.0190476190476189*G0_0_0_1_5_1 + 0.00211640211640211*G0_0_0_1_5_2 - 0.00846560846560842*G0_0_0_1_5_3 - 0.0169312169312168*G0_0_0_1_5_5 + 0.00169312169312169*G0_0_0_2_0_0 - 0.000952380952380947*G0_0_0_2_0_1 + 0.00169312169312168*G0_0_0_2_0_2 + 0.000423280423280421*G0_0_0_2_0_3 + 0.00465608465608463*G0_0_0_2_0_4 + 0.000423280423280424*G0_0_0_2_0_5 - 0.000952380952380947*G0_0_0_2_1_0 + 0.00423280423280421*G0_0_0_2_1_1 + 0.000634920634920629*G0_0_0_2_1_2 + 0.00423280423280421*G0_0_0_2_1_3 + 0.000846560846560841*G0_0_0_2_1_4 + 0.00211640211640211*G0_0_0_2_1_5 + 0.00169312169312168*G0_0_0_2_2_0 + 0.00063492063492063*G0_0_0_2_2_1 - 0.0190476190476189*G0_0_0_2_2_2 - 0.00634920634920631*G0_0_0_2_2_3 - 0.0105820105820105*G0_0_0_2_2_4 - 0.00126984126984127*G0_0_0_2_2_5 + 0.000423280423280422*G0_0_0_2_3_0 + 0.00423280423280421*G0_0_0_2_3_1 - 0.00634920634920631*G0_0_0_2_3_2 + 0.00253968253968253*G0_0_0_2_3_3 - 0.00253968253968252*G0_0_0_2_3_4 + 0.00169312169312169*G0_0_0_2_3_5 + 0.00465608465608463*G0_0_0_2_4_0 + 0.000846560846560841*G0_0_0_2_4_1 - 0.0105820105820105*G0_0_0_2_4_2 - 0.00253968253968252*G0_0_0_2_4_3 - 0.0059259259259259*G0_0_0_2_4_4 + 0.000846560846560842*G0_0_0_2_4_5 + 0.000423280423280424*G0_0_0_2_5_0 + 0.00211640211640211*G0_0_0_2_5_1 - 0.00126984126984127*G0_0_0_2_5_2 + 0.00169312169312169*G0_0_0_2_5_3 + 0.000846560846560842*G0_0_0_2_5_4 + 0.00253968253968253*G0_0_0_2_5_5 - 0.00126984126984126*G0_0_0_3_0_0 + 0.0021164021164021*G0_0_0_3_0_1 + 0.000423280423280421*G0_0_0_3_0_2 + 0.00253968253968252*G0_0_0_3_0_3 + 0.00084656084656084*G0_0_0_3_0_4 + 0.00169312169312168*G0_0_0_3_0_5 + 0.0021164021164021*G0_0_0_3_1_0 - 0.0190476190476189*G0_0_0_3_1_1 + 0.00423280423280421*G0_0_0_3_1_2 - 0.0169312169312168*G0_0_0_3_1_3 - 0.00846560846560842*G0_0_0_3_1_5 + 0.000423280423280421*G0_0_0_3_2_0 + 0.00423280423280421*G0_0_0_3_2_1 - 0.00634920634920631*G0_0_0_3_2_2 + 0.00253968253968253*G0_0_0_3_2_3 - 0.00253968253968252*G0_0_0_3_2_4 + 0.00169312169312169*G0_0_0_3_2_5 + 0.00253968253968252*G0_0_0_3_3_0 - 0.0169312169312168*G0_0_0_3_3_1 + 0.00253968253968253*G0_0_0_3_3_2 - 0.0253968253968253*G0_0_0_3_3_3 - 0.00507936507936506*G0_0_0_3_3_4 - 0.00846560846560843*G0_0_0_3_3_5 + 0.00084656084656084*G0_0_0_3_4_0 - 0.00253968253968252*G0_0_0_3_4_2 - 0.00507936507936506*G0_0_0_3_4_3 - 0.0152380952380952*G0_0_0_3_4_4 - 0.00338624338624337*G0_0_0_3_4_5 + 0.00169312169312168*G0_0_0_3_5_0 - 0.00846560846560842*G0_0_0_3_5_1 + 0.00169312169312169*G0_0_0_3_5_2 - 0.00846560846560843*G0_0_0_3_5_3 - 0.00338624338624338*G0_0_0_3_5_4 - 0.00846560846560842*G0_0_0_3_5_5 - 0.0105820105820105*G0_0_0_4_0_0 + 0.000846560846560844*G0_0_0_4_0_1 + 0.00465608465608464*G0_0_0_4_0_2 + 0.00084656084656084*G0_0_0_4_0_3 - 0.00592592592592591*G0_0_0_4_0_4 - 0.00253968253968253*G0_0_0_4_0_5 + 0.000846560846560844*G0_0_0_4_1_0 - 0.00211640211640211*G0_0_0_4_1_1 + 0.000846560846560841*G0_0_0_4_1_2 + 0.00677248677248675*G0_0_0_4_1_4 + 0.00465608465608464*G0_0_0_4_2_0 + 0.000846560846560841*G0_0_0_4_2_1 - 0.0105820105820105*G0_0_0_4_2_2 - 0.00253968253968252*G0_0_0_4_2_3 - 0.0059259259259259*G0_0_0_4_2_4 + 0.000846560846560842*G0_0_0_4_2_5 + 0.00084656084656084*G0_0_0_4_3_0 - 0.00253968253968252*G0_0_0_4_3_2 - 0.00507936507936506*G0_0_0_4_3_3 - 0.0152380952380952*G0_0_0_4_3_4 - 0.00338624338624338*G0_0_0_4_3_5 - 0.00592592592592591*G0_0_0_4_4_0 + 0.00677248677248675*G0_0_0_4_4_1 - 0.0059259259259259*G0_0_0_4_4_2 - 0.0152380952380952*G0_0_0_4_4_3 - 0.116825396825396*G0_0_0_4_4_4 - 0.0152380952380952*G0_0_0_4_4_5 - 0.00253968253968253*G0_0_0_4_5_0 + 0.000846560846560842*G0_0_0_4_5_2 - 0.00338624338624338*G0_0_0_4_5_3 - 0.0152380952380952*G0_0_0_4_5_4 - 0.00507936507936507*G0_0_0_4_5_5 - 0.00634920634920631*G0_0_0_5_0_0 + 0.00423280423280421*G0_0_0_5_0_1 + 0.000423280423280424*G0_0_0_5_0_2 + 0.00169312169312168*G0_0_0_5_0_3 - 0.00253968253968253*G0_0_0_5_0_4 + 0.00253968253968252*G0_0_0_5_0_5 + 0.00423280423280421*G0_0_0_5_1_0 - 0.0190476190476189*G0_0_0_5_1_1 + 0.00211640211640211*G0_0_0_5_1_2 - 0.00846560846560842*G0_0_0_5_1_3 - 0.0169312169312168*G0_0_0_5_1_5 + 0.000423280423280424*G0_0_0_5_2_0 + 0.00211640211640211*G0_0_0_5_2_1 - 0.00126984126984127*G0_0_0_5_2_2 + 0.00169312169312169*G0_0_0_5_2_3 + 0.000846560846560842*G0_0_0_5_2_4 + 0.00253968253968253*G0_0_0_5_2_5 + 0.00169312169312168*G0_0_0_5_3_0 - 0.00846560846560842*G0_0_0_5_3_1 + 0.00169312169312169*G0_0_0_5_3_2 - 0.00846560846560843*G0_0_0_5_3_3 - 0.00338624338624338*G0_0_0_5_3_4 - 0.00846560846560842*G0_0_0_5_3_5 - 0.00253968253968253*G0_0_0_5_4_0 + 0.000846560846560842*G0_0_0_5_4_2 - 0.00338624338624338*G0_0_0_5_4_3 - 0.0152380952380952*G0_0_0_5_4_4 - 0.00507936507936507*G0_0_0_5_4_5 + 0.00253968253968252*G0_0_0_5_5_0 - 0.0169312169312168*G0_0_0_5_5_1 + 0.00253968253968253*G0_0_0_5_5_2 - 0.00846560846560842*G0_0_0_5_5_3 - 0.00507936507936507*G0_0_0_5_5_4 - 0.0253968253968253*G0_0_0_5_5_5;
    A[12] = -A[13] + 0.0174603174603174*G0_1_0_0_0_0 - 0.00179894179894179*G0_1_0_0_0_1 - 0.00126984126984126*G0_1_0_0_0_2 + 0.000423280423280423*G0_1_0_0_0_3 + 0.00423280423280421*G0_1_0_0_0_4 + 0.00634920634920632*G0_1_0_0_0_5 - 0.00179894179894179*G0_1_0_0_1_0 + 0.00179894179894178*G0_1_0_0_1_1 + 0.00063492063492063*G0_1_0_0_1_3 - 0.000634920634920632*G0_1_0_0_1_4 - 0.00126984126984126*G0_1_0_0_2_0 + 0.000529100529100527*G0_1_0_0_2_2 - 0.00021164021164021*G0_1_0_0_2_3 + 0.00021164021164021*G0_1_0_0_2_4 - 0.000846560846560842*G0_1_0_0_2_5 + 0.000423280423280423*G0_1_0_0_3_0 + 0.00063492063492063*G0_1_0_0_3_1 - 0.00021164021164021*G0_1_0_0_3_2 - 0.0021164021164021*G0_1_0_0_3_3 + 0.00042328042328042*G0_1_0_0_3_4 + 0.00084656084656084*G0_1_0_0_3_5 + 0.00423280423280421*G0_1_0_0_4_0 - 0.000634920634920632*G0_1_0_0_4_1 + 0.00021164021164021*G0_1_0_0_4_2 + 0.000423280423280421*G0_1_0_0_4_3 + 0.00550264550264547*G0_1_0_0_4_4 + 0.00296296296296295*G0_1_0_0_4_5 + 0.00634920634920632*G0_1_0_0_5_0 - 0.000846560846560842*G0_1_0_0_5_2 + 0.00084656084656084*G0_1_0_0_5_3 + 0.00296296296296295*G0_1_0_0_5_4 + 0.00973544973544967*G0_1_0_0_5_5 - 0.00179894179894179*G0_1_0_1_0_0 + 0.00179894179894178*G0_1_0_1_0_1 + 0.00063492063492063*G0_1_0_1_0_3 - 0.000634920634920632*G0_1_0_1_0_4 + 0.00179894179894178*G0_1_0_1_1_0 - 0.0174603174603173*G0_1_0_1_1_1 + 0.00126984126984126*G0_1_0_1_1_2 - 0.0042328042328042*G0_1_0_1_1_3 - 0.000423280423280421*G0_1_0_1_1_4 - 0.00634920634920631*G0_1_0_1_1_5 + 0.00126984126984126*G0_1_0_1_2_1 - 0.000529100529100526*G0_1_0_1_2_2 - 0.000211640211640211*G0_1_0_1_2_3 + 0.00021164021164021*G0_1_0_1_2_4 + 0.000846560846560841*G0_1_0_1_2_5 + 0.00063492063492063*G0_1_0_1_3_0 - 0.0042328042328042*G0_1_0_1_3_1 - 0.000211640211640211*G0_1_0_1_3_2 - 0.00550264550264547*G0_1_0_1_3_3 - 0.000423280423280422*G0_1_0_1_3_4 - 0.00296296296296295*G0_1_0_1_3_5 - 0.000634920634920632*G0_1_0_1_4_0 - 0.000423280423280421*G0_1_0_1_4_1 + 0.00021164021164021*G0_1_0_1_4_2 - 0.000423280423280422*G0_1_0_1_4_3 + 0.00211640211640211*G0_1_0_1_4_4 - 0.000846560846560841*G0_1_0_1_4_5 - 0.00634920634920631*G0_1_0_1_5_1 + 0.000846560846560841*G0_1_0_1_5_2 - 0.00296296296296295*G0_1_0_1_5_3 - 0.000846560846560841*G0_1_0_1_5_4 - 0.00973544973544967*G0_1_0_1_5_5 - 0.00126984126984126*G0_1_0_2_0_0 + 0.000529100529100527*G0_1_0_2_0_2 - 0.00021164021164021*G0_1_0_2_0_3 + 0.00021164021164021*G0_1_0_2_0_4 - 0.000846560846560842*G0_1_0_2_0_5 + 0.00126984126984126*G0_1_0_2_1_1 - 0.000529100529100526*G0_1_0_2_1_2 - 0.000211640211640211*G0_1_0_2_1_3 + 0.00021164021164021*G0_1_0_2_1_4 + 0.000846560846560841*G0_1_0_2_1_5 + 0.000529100529100526*G0_1_0_2_2_0 - 0.000529100529100526*G0_1_0_2_2_1 + 0.00211640211640211*G0_1_0_2_2_3 - 0.0021164021164021*G0_1_0_2_2_4 - 0.00021164021164021*G0_1_0_2_3_0 - 0.000211640211640211*G0_1_0_2_3_1 + 0.00211640211640211*G0_1_0_2_3_2 + 0.00423280423280421*G0_1_0_2_3_3 + 0.000423280423280422*G0_1_0_2_3_5 + 0.00021164021164021*G0_1_0_2_4_0 + 0.00021164021164021*G0_1_0_2_4_1 - 0.0021164021164021*G0_1_0_2_4_2 - 0.00423280423280421*G0_1_0_2_4_4 - 0.000423280423280422*G0_1_0_2_4_5 - 0.000846560846560842*G0_1_0_2_5_0 + 0.000846560846560841*G0_1_0_2_5_1 + 0.000423280423280422*G0_1_0_2_5_3 - 0.000423280423280422*G0_1_0_2_5_4 + 0.000423280423280423*G0_1_0_3_0_0 + 0.00063492063492063*G0_1_0_3_0_1 - 0.00021164021164021*G0_1_0_3_0_2 - 0.0021164021164021*G0_1_0_3_0_3 + 0.00042328042328042*G0_1_0_3_0_4 + 0.00084656084656084*G0_1_0_3_0_5 + 0.00063492063492063*G0_1_0_3_1_0 - 0.0042328042328042*G0_1_0_3_1_1 - 0.000211640211640211*G0_1_0_3_1_2 - 0.00550264550264547*G0_1_0_3_1_3 - 0.000423280423280422*G0_1_0_3_1_4 - 0.00296296296296295*G0_1_0_3_1_5 - 0.00021164021164021*G0_1_0_3_2_0 - 0.000211640211640211*G0_1_0_3_2_1 + 0.00211640211640211*G0_1_0_3_2_2 + 0.00423280423280421*G0_1_0_3_2_3 + 0.000423280423280422*G0_1_0_3_2_5 - 0.0021164021164021*G0_1_0_3_3_0 - 0.00550264550264547*G0_1_0_3_3_1 + 0.00423280423280421*G0_1_0_3_3_2 + 0.0457142857142855*G0_1_0_3_3_3 + 0.00507936507936506*G0_1_0_3_3_4 + 0.00338624338624338*G0_1_0_3_3_5 + 0.00042328042328042*G0_1_0_3_4_0 - 0.000423280423280422*G0_1_0_3_4_1 + 0.00507936507936506*G0_1_0_3_4_3 - 0.00507936507936505*G0_1_0_3_4_4 + 0.00084656084656084*G0_1_0_3_5_0 - 0.00296296296296295*G0_1_0_3_5_1 + 0.000423280423280422*G0_1_0_3_5_2 + 0.00338624338624338*G0_1_0_3_5_3 - 0.00169312169312168*G0_1_0_3_5_5 + 0.00423280423280421*G0_1_0_4_0_0 - 0.000634920634920632*G0_1_0_4_0_1 + 0.00021164021164021*G0_1_0_4_0_2 + 0.00042328042328042*G0_1_0_4_0_3 + 0.00550264550264548*G0_1_0_4_0_4 + 0.00296296296296295*G0_1_0_4_0_5 - 0.000634920634920632*G0_1_0_4_1_0 - 0.000423280423280421*G0_1_0_4_1_1 + 0.00021164021164021*G0_1_0_4_1_2 - 0.000423280423280422*G0_1_0_4_1_3 + 0.00211640211640211*G0_1_0_4_1_4 - 0.000846560846560841*G0_1_0_4_1_5 + 0.00021164021164021*G0_1_0_4_2_0 + 0.00021164021164021*G0_1_0_4_2_1 - 0.0021164021164021*G0_1_0_4_2_2 - 0.00423280423280421*G0_1_0_4_2_4 - 0.000423280423280422*G0_1_0_4_2_5 + 0.000423280423280421*G0_1_0_4_3_0 - 0.000423280423280422*G0_1_0_4_3_1 + 0.00507936507936506*G0_1_0_4_3_3 - 0.00507936507936505*G0_1_0_4_3_4 + 0.00550264550264548*G0_1_0_4_4_0 + 0.00211640211640211*G0_1_0_4_4_1 - 0.00423280423280421*G0_1_0_4_4_2 - 0.00507936507936505*G0_1_0_4_4_3 - 0.0457142857142855*G0_1_0_4_4_4 - 0.00338624338624338*G0_1_0_4_4_5 + 0.00296296296296295*G0_1_0_4_5_0 - 0.000846560846560841*G0_1_0_4_5_1 - 0.000423280423280422*G0_1_0_4_5_2 - 0.00338624338624338*G0_1_0_4_5_4 + 0.00169312169312168*G0_1_0_4_5_5 + 0.00634920634920632*G0_1_0_5_0_0 - 0.000846560846560842*G0_1_0_5_0_2 + 0.00084656084656084*G0_1_0_5_0_3 + 0.00296296296296295*G0_1_0_5_0_4 + 0.00973544973544967*G0_1_0_5_0_5 - 0.00634920634920631*G0_1_0_5_1_1 + 0.000846560846560841*G0_1_0_5_1_2 - 0.00296296296296295*G0_1_0_5_1_3 - 0.000846560846560841*G0_1_0_5_1_4 - 0.00973544973544967*G0_1_0_5_1_5 - 0.000846560846560842*G0_1_0_5_2_0 + 0.000846560846560841*G0_1_0_5_2_1 + 0.000423280423280422*G0_1_0_5_2_3 - 0.000423280423280422*G0_1_0_5_2_4 + 0.00084656084656084*G0_1_0_5_3_0 - 0.00296296296296295*G0_1_0_5_3_1 + 0.000423280423280422*G0_1_0_5_3_2 + 0.00338624338624338*G0_1_0_5_3_3 - 0.00169312169312168*G0_1_0_5_3_5 + 0.00296296296296295*G0_1_0_5_4_0 - 0.000846560846560841*G0_1_0_5_4_1 - 0.000423280423280422*G0_1_0_5_4_2 - 0.00338624338624338*G0_1_0_5_4_4 + 0.00169312169312168*G0_1_0_5_4_5 + 0.00973544973544967*G0_1_0_5_5_0 - 0.00973544973544967*G0_1_0_5_5_1 - 0.00169312169312168*G0_1_0_5_5_3 + 0.00169312169312168*G0_1_0_5_5_4 + 0.0134920634920634*G0_1_1_0_0_0 - 0.00132275132275132*G0_1_1_0_0_1 - 0.00079365079365079*G0_1_1_0_0_2 + 0.000529100529100527*G0_1_1_0_0_3 + 0.00370370370370368*G0_1_1_0_0_4 + 0.00582010582010579*G0_1_1_0_0_5 - 0.00132275132275132*G0_1_1_0_1_0 + 0.000476190476190473*G0_1_1_0_1_1 + 0.000238095238095237*G0_1_1_0_1_2 + 0.00021164021164021*G0_1_1_0_1_3 - 0.000423280423280421*G0_1_1_0_1_4 - 0.00116402116402116*G0_1_1_0_1_5 - 0.00079365079365079*G0_1_1_0_2_0 + 0.000238095238095237*G0_1_1_0_2_1 - 0.000793650793650787*G0_1_1_0_2_2 - 0.00063492063492063*G0_1_1_0_2_3 - 0.000952380952380947*G0_1_1_0_2_4 - 0.000634920634920632*G0_1_1_0_2_5 + 0.000529100529100527*G0_1_1_0_3_0 + 0.00021164021164021*G0_1_1_0_3_1 - 0.00063492063492063*G0_1_1_0_3_2 - 0.00169312169312168*G0_1_1_0_3_3 - 0.00021164021164021*G0_1_1_0_3_4 + 0.00021164021164021*G0_1_1_0_3_5 + 0.00370370370370368*G0_1_1_0_4_0 - 0.000423280423280421*G0_1_1_0_4_1 - 0.000952380952380947*G0_1_1_0_4_2 - 0.00021164021164021*G0_1_1_0_4_3 + 0.00211640211640211*G0_1_1_0_4_4 + 0.0021164021164021*G0_1_1_0_4_5 + 0.00582010582010579*G0_1_1_0_5_0 - 0.00116402116402116*G0_1_1_0_5_1 - 0.000634920634920632*G0_1_1_0_5_2 + 0.00021164021164021*G0_1_1_0_5_3 + 0.0021164021164021*G0_1_1_0_5_4 + 0.00634920634920631*G0_1_1_0_5_5 - 0.00132275132275132*G0_1_1_1_0_0 + 0.000476190476190473*G0_1_1_1_0_1 + 0.000238095238095237*G0_1_1_1_0_2 + 0.00021164021164021*G0_1_1_1_0_3 - 0.000423280423280421*G0_1_1_1_0_4 - 0.00116402116402116*G0_1_1_1_0_5 + 0.000476190476190473*G0_1_1_1_1_0 - 0.00396825396825395*G0_1_1_1_1_1 + 0.000476190476190474*G0_1_1_1_1_2 - 0.000529100529100526*G0_1_1_1_1_3 + 0.000105820105820105*G0_1_1_1_1_4 - 0.000529100529100527*G0_1_1_1_1_5 + 0.000238095238095237*G0_1_1_1_2_0 + 0.000476190476190474*G0_1_1_1_2_1 - 0.00132275132275131*G0_1_1_1_2_2 - 0.00116402116402116*G0_1_1_1_2_3 - 0.000423280423280421*G0_1_1_1_2_4 + 0.00021164021164021*G0_1_1_1_2_5 + 0.00021164021164021*G0_1_1_1_3_0 - 0.000529100529100526*G0_1_1_1_3_1 - 0.00116402116402116*G0_1_1_1_3_2 - 0.00338624338624337*G0_1_1_1_3_3 - 0.000634920634920632*G0_1_1_1_3_4 - 0.000846560846560842*G0_1_1_1_3_5 - 0.000423280423280421*G0_1_1_1_4_0 + 0.000105820105820105*G0_1_1_1_4_1 - 0.000423280423280421*G0_1_1_1_4_2 - 0.000634920634920632*G0_1_1_1_4_3 + 0.000423280423280422*G0_1_1_1_4_4 - 0.000634920634920631*G0_1_1_1_4_5 - 0.00116402116402116*G0_1_1_1_5_0 - 0.000529100529100527*G0_1_1_1_5_1 + 0.00021164021164021*G0_1_1_1_5_2 - 0.000846560846560842*G0_1_1_1_5_3 - 0.000634920634920631*G0_1_1_1_5_4 - 0.00338624338624336*G0_1_1_1_5_5 - 0.00079365079365079*G0_1_1_2_0_0 + 0.000238095238095237*G0_1_1_2_0_1 - 0.000793650793650787*G0_1_1_2_0_2 - 0.00063492063492063*G0_1_1_2_0_3 - 0.000952380952380947*G0_1_1_2_0_4 - 0.000634920634920632*G0_1_1_2_0_5 + 0.000238095238095237*G0_1_1_2_1_0 + 0.000476190476190474*G0_1_1_2_1_1 - 0.00132275132275131*G0_1_1_2_1_2 - 0.00116402116402116*G0_1_1_2_1_3 - 0.000423280423280421*G0_1_1_2_1_4 + 0.00021164021164021*G0_1_1_2_1_5 - 0.000793650793650787*G0_1_1_2_2_0 - 0.00132275132275131*G0_1_1_2_2_1 + 0.0134920634920634*G0_1_1_2_2_2 + 0.00582010582010579*G0_1_1_2_2_3 + 0.00370370370370368*G0_1_1_2_2_4 + 0.00052910052910053*G0_1_1_2_2_5 - 0.00063492063492063*G0_1_1_2_3_0 - 0.00116402116402116*G0_1_1_2_3_1 + 0.00582010582010579*G0_1_1_2_3_2 + 0.00634920634920631*G0_1_1_2_3_3 + 0.00211640211640211*G0_1_1_2_3_4 + 0.000211640211640213*G0_1_1_2_3_5 - 0.000952380952380947*G0_1_1_2_4_0 - 0.000423280423280421*G0_1_1_2_4_1 + 0.00370370370370368*G0_1_1_2_4_2 + 0.00211640211640211*G0_1_1_2_4_3 + 0.0021164021164021*G0_1_1_2_4_4 - 0.000211640211640209*G0_1_1_2_4_5 - 0.000634920634920632*G0_1_1_2_5_0 + 0.00021164021164021*G0_1_1_2_5_1 + 0.00052910052910053*G0_1_1_2_5_2 + 0.000211640211640213*G0_1_1_2_5_3 - 0.000211640211640209*G0_1_1_2_5_4 - 0.00169312169312168*G0_1_1_2_5_5 + 0.000529100529100527*G0_1_1_3_0_0 + 0.00021164021164021*G0_1_1_3_0_1 - 0.00063492063492063*G0_1_1_3_0_2 - 0.00169312169312168*G0_1_1_3_0_3 - 0.00021164021164021*G0_1_1_3_0_4 + 0.00021164021164021*G0_1_1_3_0_5 + 0.00021164021164021*G0_1_1_3_1_0 - 0.000529100529100526*G0_1_1_3_1_1 - 0.00116402116402116*G0_1_1_3_1_2 - 0.00338624338624337*G0_1_1_3_1_3 - 0.000634920634920632*G0_1_1_3_1_4 - 0.000846560846560842*G0_1_1_3_1_5 - 0.00063492063492063*G0_1_1_3_2_0 - 0.00116402116402116*G0_1_1_3_2_1 + 0.00582010582010579*G0_1_1_3_2_2 + 0.00634920634920631*G0_1_1_3_2_3 + 0.00211640211640211*G0_1_1_3_2_4 + 0.000211640211640213*G0_1_1_3_2_5 - 0.00169312169312168*G0_1_1_3_3_0 - 0.00338624338624337*G0_1_1_3_3_1 + 0.00634920634920631*G0_1_1_3_3_2 + 0.0292063492063491*G0_1_1_3_3_3 + 0.00465608465608464*G0_1_1_3_3_4 + 0.00296296296296296*G0_1_1_3_3_5 - 0.00021164021164021*G0_1_1_3_4_0 - 0.000634920634920632*G0_1_1_3_4_1 + 0.00211640211640211*G0_1_1_3_4_2 + 0.00465608465608464*G0_1_1_3_4_3 - 0.000423280423280421*G0_1_1_3_4_4 + 0.000846560846560843*G0_1_1_3_4_5 + 0.00021164021164021*G0_1_1_3_5_0 - 0.000846560846560842*G0_1_1_3_5_1 + 0.000211640211640213*G0_1_1_3_5_2 + 0.00296296296296296*G0_1_1_3_5_3 + 0.000846560846560843*G0_1_1_3_5_4 + 0.00296296296296295*G0_1_1_3_5_5 + 0.00370370370370368*G0_1_1_4_0_0 - 0.000423280423280421*G0_1_1_4_0_1 - 0.000952380952380947*G0_1_1_4_0_2 - 0.00021164021164021*G0_1_1_4_0_3 + 0.00211640211640211*G0_1_1_4_0_4 + 0.0021164021164021*G0_1_1_4_0_5 - 0.000423280423280421*G0_1_1_4_1_0 + 0.000105820105820105*G0_1_1_4_1_1 - 0.000423280423280421*G0_1_1_4_1_2 - 0.000634920634920632*G0_1_1_4_1_3 + 0.000423280423280421*G0_1_1_4_1_4 - 0.000634920634920631*G0_1_1_4_1_5 - 0.000952380952380947*G0_1_1_4_2_0 - 0.000423280423280421*G0_1_1_4_2_1 + 0.00370370370370368*G0_1_1_4_2_2 + 0.00211640211640211*G0_1_1_4_2_3 + 0.0021164021164021*G0_1_1_4_2_4 - 0.000211640211640209*G0_1_1_4_2_5 - 0.00021164021164021*G0_1_1_4_3_0 - 0.000634920634920632*G0_1_1_4_3_1 + 0.00211640211640211*G0_1_1_4_3_2 + 0.00465608465608464*G0_1_1_4_3_3 - 0.000423280423280421*G0_1_1_4_3_4 + 0.000846560846560843*G0_1_1_4_3_5 + 0.00211640211640211*G0_1_1_4_4_0 + 0.000423280423280421*G0_1_1_4_4_1 + 0.0021164021164021*G0_1_1_4_4_2 - 0.000423280423280421*G0_1_1_4_4_3 - 0.0165079365079364*G0_1_1_4_4_4 - 0.000423280423280425*G0_1_1_4_4_5 + 0.0021164021164021*G0_1_1_4_5_0 - 0.000634920634920631*G0_1_1_4_5_1 - 0.000211640211640209*G0_1_1_4_5_2 + 0.000846560846560843*G0_1_1_4_5_3 - 0.000423280423280425*G0_1_1_4_5_4 + 0.00465608465608463*G0_1_1_4_5_5 + 0.00582010582010579*G0_1_1_5_0_0 - 0.00116402116402116*G0_1_1_5_0_1 - 0.000634920634920632*G0_1_1_5_0_2 + 0.00021164021164021*G0_1_1_5_0_3 + 0.0021164021164021*G0_1_1_5_0_4 + 0.00634920634920631*G0_1_1_5_0_5 - 0.00116402116402116*G0_1_1_5_1_0 - 0.000529100529100527*G0_1_1_5_1_1 + 0.00021164021164021*G0_1_1_5_1_2 - 0.000846560846560842*G0_1_1_5_1_3 - 0.000634920634920631*G0_1_1_5_1_4 - 0.00338624338624336*G0_1_1_5_1_5 - 0.000634920634920632*G0_1_1_5_2_0 + 0.00021164021164021*G0_1_1_5_2_1 + 0.00052910052910053*G0_1_1_5_2_2 + 0.000211640211640213*G0_1_1_5_2_3 - 0.000211640211640209*G0_1_1_5_2_4 - 0.00169312169312168*G0_1_1_5_2_5 + 0.00021164021164021*G0_1_1_5_3_0 - 0.000846560846560842*G0_1_1_5_3_1 + 0.000211640211640213*G0_1_1_5_3_2 + 0.00296296296296296*G0_1_1_5_3_3 + 0.000846560846560843*G0_1_1_5_3_4 + 0.00296296296296295*G0_1_1_5_3_5 + 0.0021164021164021*G0_1_1_5_4_0 - 0.000634920634920631*G0_1_1_5_4_1 - 0.000211640211640209*G0_1_1_5_4_2 + 0.000846560846560843*G0_1_1_5_4_3 - 0.000423280423280425*G0_1_1_5_4_4 + 0.00465608465608463*G0_1_1_5_4_5 + 0.00634920634920631*G0_1_1_5_5_0 - 0.00338624338624336*G0_1_1_5_5_1 - 0.00169312169312168*G0_1_1_5_5_2 + 0.00296296296296295*G0_1_1_5_5_3 + 0.00465608465608463*G0_1_1_5_5_4 + 0.029206349206349*G0_1_1_5_5_5;
    A[27] = -A[29] - 0.0063492063492063*G0_0_0_0_0_0 + 0.00169312169312168*G0_0_0_0_0_1 - 0.000423280423280417*G0_0_0_0_0_2 - 0.00338624338624337*G0_0_0_0_0_3 - 0.0126984126984126*G0_0_0_0_0_4 - 0.00423280423280421*G0_0_0_0_0_5 + 0.00169312169312168*G0_0_0_0_1_0 - 0.00126984126984126*G0_0_0_0_1_2 - 0.00338624338624336*G0_0_0_0_1_3 - 0.00253968253968252*G0_0_0_0_1_4 - 0.00084656084656084*G0_0_0_0_1_5 - 0.000423280423280417*G0_0_0_0_2_0 - 0.00126984126984126*G0_0_0_0_2_1 + 0.00846560846560839*G0_0_0_0_2_2 + 0.00507936507936504*G0_0_0_0_2_3 + 0.0118518518518518*G0_0_0_0_2_4 + 0.00169312169312169*G0_0_0_0_2_5 - 0.00338624338624337*G0_0_0_0_3_0 - 0.00338624338624336*G0_0_0_0_3_1 + 0.00507936507936504*G0_0_0_0_3_2 + 0.0118518518518518*G0_0_0_0_3_3 + 0.0118518518518518*G0_0_0_0_3_4 + 0.00338624338624337*G0_0_0_0_3_5 - 0.0126984126984126*G0_0_0_0_4_0 - 0.00253968253968252*G0_0_0_0_4_1 + 0.0118518518518518*G0_0_0_0_4_2 + 0.0118518518518518*G0_0_0_0_4_3 + 0.0152380952380951*G0_0_0_0_4_4 + 0.00169312169312168*G0_0_0_0_4_5 - 0.00423280423280421*G0_0_0_0_5_0 - 0.00084656084656084*G0_0_0_0_5_1 + 0.00169312169312169*G0_0_0_0_5_2 + 0.00338624338624337*G0_0_0_0_5_3 + 0.00169312169312168*G0_0_0_0_5_4 - 0.00169312169312167*G0_0_0_0_5_5 + 0.00169312169312168*G0_0_0_1_0_0 - 0.00126984126984126*G0_0_0_1_0_2 - 0.00338624338624336*G0_0_0_1_0_3 - 0.00253968253968252*G0_0_0_1_0_4 - 0.00084656084656084*G0_0_0_1_0_5 + 0.00634920634920629*G0_0_0_1_1_1 - 0.0021164021164021*G0_0_0_1_1_2 - 0.00423280423280421*G0_0_0_1_1_4 - 0.00126984126984126*G0_0_0_1_2_0 - 0.0021164021164021*G0_0_0_1_2_1 + 0.0084656084656084*G0_0_0_1_2_2 + 0.00507936507936504*G0_0_0_1_2_3 + 0.00338624338624336*G0_0_0_1_2_4 - 0.00084656084656084*G0_0_0_1_2_5 - 0.00338624338624336*G0_0_0_1_3_0 + 0.00507936507936504*G0_0_0_1_3_2 + 0.0253968253968253*G0_0_0_1_3_3 + 0.0152380952380952*G0_0_0_1_3_4 + 0.00846560846560842*G0_0_0_1_3_5 - 0.00253968253968252*G0_0_0_1_4_0 - 0.00423280423280421*G0_0_0_1_4_1 + 0.00338624338624336*G0_0_0_1_4_2 + 0.0152380952380952*G0_0_0_1_4_3 + 0.0287830687830686*G0_0_0_1_4_4 + 0.0101587301587301*G0_0_0_1_4_5 - 0.00084656084656084*G0_0_0_1_5_0 - 0.00084656084656084*G0_0_0_1_5_2 + 0.00846560846560842*G0_0_0_1_5_3 + 0.0101587301587301*G0_0_0_1_5_4 + 0.00846560846560841*G0_0_0_1_5_5 - 0.000423280423280417*G0_0_0_2_0_0 - 0.00126984126984126*G0_0_0_2_0_1 + 0.00846560846560839*G0_0_0_2_0_2 + 0.00507936507936504*G0_0_0_2_0_3 + 0.0118518518518518*G0_0_0_2_0_4 + 0.00169312169312169*G0_0_0_2_0_5 - 0.00126984126984126*G0_0_0_2_1_0 - 0.0021164021164021*G0_0_0_2_1_1 + 0.0084656084656084*G0_0_0_2_1_2 + 0.00507936507936504*G0_0_0_2_1_3 + 0.00338624338624336*G0_0_0_2_1_4 - 0.00084656084656084*G0_0_0_2_1_5 + 0.00846560846560839*G0_0_0_2_2_0 + 0.0084656084656084*G0_0_0_2_2_1 - 0.0888888888888883*G0_0_0_2_2_2 - 0.0338624338624336*G0_0_0_2_2_3 - 0.042328042328042*G0_0_0_2_2_4 - 0.00423280423280423*G0_0_0_2_2_5 + 0.00507936507936504*G0_0_0_2_3_0 + 0.00507936507936504*G0_0_0_2_3_1 - 0.0338624338624336*G0_0_0_2_3_2 - 0.0338624338624336*G0_0_0_2_3_3 - 0.0169312169312168*G0_0_0_2_3_4 - 0.0016931216931217*G0_0_0_2_3_5 + 0.0118518518518518*G0_0_0_2_4_0 + 0.00338624338624336*G0_0_0_2_4_1 - 0.042328042328042*G0_0_0_2_4_2 - 0.0169312169312168*G0_0_0_2_4_3 - 0.0338624338624336*G0_0_0_2_4_4 + 0.00169312169312168*G0_0_0_2_4_5 + 0.00169312169312169*G0_0_0_2_5_0 - 0.00084656084656084*G0_0_0_2_5_1 - 0.00423280423280423*G0_0_0_2_5_2 - 0.0016931216931217*G0_0_0_2_5_3 + 0.00169312169312168*G0_0_0_2_5_4 + 0.00338624338624337*G0_0_0_2_5_5 - 0.00338624338624337*G0_0_0_3_0_0 - 0.00338624338624336*G0_0_0_3_0_1 + 0.00507936507936504*G0_0_0_3_0_2 + 0.0118518518518518*G0_0_0_3_0_3 + 0.0118518518518518*G0_0_0_3_0_4 + 0.00338624338624337*G0_0_0_3_0_5 - 0.00338624338624336*G0_0_0_3_1_0 + 0.00507936507936504*G0_0_0_3_1_2 + 0.0253968253968253*G0_0_0_3_1_3 + 0.0152380952380952*G0_0_0_3_1_4 + 0.00846560846560842*G0_0_0_3_1_5 + 0.00507936507936504*G0_0_0_3_2_0 + 0.00507936507936504*G0_0_0_3_2_1 - 0.0338624338624336*G0_0_0_3_2_2 - 0.0338624338624336*G0_0_0_3_2_3 - 0.0169312169312168*G0_0_0_3_2_4 - 0.0016931216931217*G0_0_0_3_2_5 + 0.0118518518518518*G0_0_0_3_3_0 + 0.0253968253968253*G0_0_0_3_3_1 - 0.0338624338624336*G0_0_0_3_3_2 - 0.0812698412698408*G0_0_0_3_3_3 - 0.0541798941798939*G0_0_0_3_3_4 - 0.0203174603174602*G0_0_0_3_3_5 + 0.0118518518518518*G0_0_0_3_4_0 + 0.0152380952380952*G0_0_0_3_4_1 - 0.0169312169312168*G0_0_0_3_4_2 - 0.0541798941798939*G0_0_0_3_4_3 - 0.0812698412698408*G0_0_0_3_4_4 - 0.027089947089947*G0_0_0_3_4_5 + 0.00338624338624337*G0_0_0_3_5_0 + 0.00846560846560843*G0_0_0_3_5_1 - 0.0016931216931217*G0_0_0_3_5_2 - 0.0203174603174602*G0_0_0_3_5_3 - 0.027089947089947*G0_0_0_3_5_4 - 0.0135449735449735*G0_0_0_3_5_5 - 0.0126984126984126*G0_0_0_4_0_0 - 0.00253968253968252*G0_0_0_4_0_1 + 0.0118518518518518*G0_0_0_4_0_2 + 0.0118518518518518*G0_0_0_4_0_3 + 0.0152380952380951*G0_0_0_4_0_4 + 0.00169312169312168*G0_0_0_4_0_5 - 0.00253968253968252*G0_0_0_4_1_0 - 0.00423280423280421*G0_0_0_4_1_1 + 0.00338624338624336*G0_0_0_4_1_2 + 0.0152380952380952*G0_0_0_4_1_3 + 0.0287830687830686*G0_0_0_4_1_4 + 0.0101587301587301*G0_0_0_4_1_5 + 0.0118518518518518*G0_0_0_4_2_0 + 0.00338624338624336*G0_0_0_4_2_1 - 0.042328042328042*G0_0_0_4_2_2 - 0.0169312169312168*G0_0_0_4_2_3 - 0.0338624338624337*G0_0_0_4_2_4 + 0.00169312169312168*G0_0_0_4_2_5 + 0.0118518518518518*G0_0_0_4_3_0 + 0.0152380952380952*G0_0_0_4_3_1 - 0.0169312169312168*G0_0_0_4_3_2 - 0.0541798941798939*G0_0_0_4_3_3 - 0.0812698412698408*G0_0_0_4_3_4 - 0.027089947089947*G0_0_0_4_3_5 + 0.0152380952380951*G0_0_0_4_4_0 + 0.0287830687830686*G0_0_0_4_4_1 - 0.0338624338624336*G0_0_0_4_4_2 - 0.0812698412698408*G0_0_0_4_4_3 - 0.325079365079363*G0_0_0_4_4_4 - 0.0609523809523807*G0_0_0_4_4_5 + 0.00169312169312168*G0_0_0_4_5_0 + 0.0101587301587301*G0_0_0_4_5_1 + 0.00169312169312168*G0_0_0_4_5_2 - 0.027089947089947*G0_0_0_4_5_3 - 0.0609523809523807*G0_0_0_4_5_4 - 0.027089947089947*G0_0_0_4_5_5 - 0.00423280423280421*G0_0_0_5_0_0 - 0.00084656084656084*G0_0_0_5_0_1 + 0.00169312169312169*G0_0_0_5_0_2 + 0.00338624338624337*G0_0_0_5_0_3 + 0.00169312169312168*G0_0_0_5_0_4 - 0.00169312169312167*G0_0_0_5_0_5 - 0.00084656084656084*G0_0_0_5_1_0 - 0.00084656084656084*G0_0_0_5_1_2 + 0.00846560846560843*G0_0_0_5_1_3 + 0.0101587301587301*G0_0_0_5_1_4 + 0.00846560846560841*G0_0_0_5_1_5 + 0.00169312169312169*G0_0_0_5_2_0 - 0.00084656084656084*G0_0_0_5_2_1 - 0.00423280423280423*G0_0_0_5_2_2 - 0.0016931216931217*G0_0_0_5_2_3 + 0.00169312169312168*G0_0_0_5_2_4 + 0.00338624338624337*G0_0_0_5_2_5 + 0.00338624338624337*G0_0_0_5_3_0 + 0.00846560846560842*G0_0_0_5_3_1 - 0.0016931216931217*G0_0_0_5_3_2 - 0.0203174603174602*G0_0_0_5_3_3 - 0.027089947089947*G0_0_0_5_3_4 - 0.0135449735449735*G0_0_0_5_3_5 + 0.00169312169312168*G0_0_0_5_4_0 + 0.0101587301587301*G0_0_0_5_4_1 + 0.00169312169312168*G0_0_0_5_4_2 - 0.027089947089947*G0_0_0_5_4_3 - 0.0609523809523807*G0_0_0_5_4_4 - 0.027089947089947*G0_0_0_5_4_5 - 0.00169312169312167*G0_0_0_5_5_0 + 0.00846560846560841*G0_0_0_5_5_1 + 0.00338624338624337*G0_0_0_5_5_2 - 0.0135449735449735*G0_0_0_5_5_3 - 0.027089947089947*G0_0_0_5_5_4 - 0.0203174603174602*G0_0_0_5_5_5 + 0.0825396825396821*G0_1_0_0_0_0 - 0.00677248677248674*G0_1_0_0_0_1 - 0.00888888888888884*G0_1_0_0_0_2 + 0.000846560846560853*G0_1_0_0_0_3 + 0.0296296296296295*G0_1_0_0_0_4 + 0.0296296296296295*G0_1_0_0_0_5 - 0.00677248677248674*G0_1_0_0_1_0 + 0.00211640211640211*G0_1_0_0_1_1 - 0.00253968253968252*G0_1_0_0_1_3 - 0.0059259259259259*G0_1_0_0_1_4 - 0.00592592592592589*G0_1_0_0_1_5 - 0.00888888888888884*G0_1_0_0_2_0 + 0.00888888888888882*G0_1_0_0_2_2 + 0.00338624338624336*G0_1_0_0_2_3 - 0.00338624338624337*G0_1_0_0_2_5 + 0.000846560846560852*G0_1_0_0_3_0 - 0.00253968253968252*G0_1_0_0_3_1 + 0.00338624338624336*G0_1_0_0_3_2 + 0.00846560846560842*G0_1_0_0_3_3 + 0.0101587301587301*G0_1_0_0_3_4 + 0.00507936507936506*G0_1_0_0_3_5 + 0.0296296296296295*G0_1_0_0_4_0 - 0.0059259259259259*G0_1_0_0_4_1 + 0.0101587301587301*G0_1_0_0_4_3 + 0.0491005291005289*G0_1_0_0_4_4 + 0.0186243386243385*G0_1_0_0_4_5 + 0.0296296296296295*G0_1_0_0_5_0 - 0.00592592592592589*G0_1_0_0_5_1 - 0.00338624338624337*G0_1_0_0_5_2 + 0.00507936507936506*G0_1_0_0_5_3 + 0.0186243386243385*G0_1_0_0_5_4 + 0.032169312169312*G0_1_0_0_5_5 - 0.00677248677248674*G0_1_0_1_0_0 + 0.00211640211640211*G0_1_0_1_0_1 - 0.00253968253968252*G0_1_0_1_0_3 - 0.0059259259259259*G0_1_0_1_0_4 - 0.00592592592592589*G0_1_0_1_0_5 + 0.00211640211640211*G0_1_0_1_1_0 - 0.0021164021164021*G0_1_0_1_1_2 - 0.0021164021164021*G0_1_0_1_2_1 + 0.00677248677248672*G0_1_0_1_2_2 + 0.00592592592592589*G0_1_0_1_2_3 + 0.00592592592592589*G0_1_0_1_2_4 + 0.00253968253968253*G0_1_0_1_2_5 - 0.00253968253968252*G0_1_0_1_3_0 + 0.00592592592592589*G0_1_0_1_3_2 + 0.0169312169312168*G0_1_0_1_3_3 + 0.00507936507936505*G0_1_0_1_3_4 - 0.0059259259259259*G0_1_0_1_4_0 + 0.00592592592592589*G0_1_0_1_4_2 + 0.00507936507936505*G0_1_0_1_4_3 - 0.00507936507936505*G0_1_0_1_4_5 - 0.00592592592592589*G0_1_0_1_5_0 + 0.00253968253968253*G0_1_0_1_5_2 - 0.00507936507936505*G0_1_0_1_5_4 - 0.0169312169312168*G0_1_0_1_5_5 - 0.00888888888888884*G0_1_0_2_0_0 + 0.00888888888888882*G0_1_0_2_0_2 + 0.00338624338624336*G0_1_0_2_0_3 - 0.00338624338624337*G0_1_0_2_0_5 - 0.0021164021164021*G0_1_0_2_1_1 + 0.00677248677248672*G0_1_0_2_1_2 + 0.00592592592592589*G0_1_0_2_1_3 + 0.00592592592592589*G0_1_0_2_1_4 + 0.00253968253968253*G0_1_0_2_1_5 + 0.00888888888888882*G0_1_0_2_2_0 + 0.00677248677248672*G0_1_0_2_2_1 - 0.082539682539682*G0_1_0_2_2_2 - 0.0296296296296294*G0_1_0_2_2_3 - 0.0296296296296294*G0_1_0_2_2_4 - 0.000846560846560857*G0_1_0_2_2_5 + 0.00338624338624336*G0_1_0_2_3_0 + 0.00592592592592589*G0_1_0_2_3_1 - 0.0296296296296294*G0_1_0_2_3_2 - 0.032169312169312*G0_1_0_2_3_3 - 0.0186243386243385*G0_1_0_2_3_4 - 0.00507936507936506*G0_1_0_2_3_5 + 0.00592592592592589*G0_1_0_2_4_1 - 0.0296296296296294*G0_1_0_2_4_2 - 0.0186243386243385*G0_1_0_2_4_3 - 0.0491005291005288*G0_1_0_2_4_4 - 0.0101587301587301*G0_1_0_2_4_5 - 0.00338624338624337*G0_1_0_2_5_0 + 0.00253968253968253*G0_1_0_2_5_1 - 0.000846560846560858*G0_1_0_2_5_2 - 0.00507936507936506*G0_1_0_2_5_3 - 0.0101587301587301*G0_1_0_2_5_4 - 0.00846560846560842*G0_1_0_2_5_5 + 0.000846560846560853*G0_1_0_3_0_0 - 0.00253968253968252*G0_1_0_3_0_1 + 0.00338624338624336*G0_1_0_3_0_2 + 0.00846560846560841*G0_1_0_3_0_3 + 0.0101587301587301*G0_1_0_3_0_4 + 0.00507936507936506*G0_1_0_3_0_5 - 0.00253968253968252*G0_1_0_3_1_0 + 0.00592592592592589*G0_1_0_3_1_2 + 0.0169312169312168*G0_1_0_3_1_3 + 0.00507936507936505*G0_1_0_3_1_4 + 0.00338624338624336*G0_1_0_3_2_0 + 0.00592592592592589*G0_1_0_3_2_1 - 0.0296296296296294*G0_1_0_3_2_2 - 0.032169312169312*G0_1_0_3_2_3 - 0.0186243386243385*G0_1_0_3_2_4 - 0.00507936507936506*G0_1_0_3_2_5 + 0.00846560846560841*G0_1_0_3_3_0 + 0.0169312169312168*G0_1_0_3_3_1 - 0.032169312169312*G0_1_0_3_3_2 - 0.0609523809523806*G0_1_0_3_3_3 - 0.027089947089947*G0_1_0_3_3_4 - 0.00677248677248675*G0_1_0_3_3_5 + 0.0101587301587301*G0_1_0_3_4_0 + 0.00507936507936505*G0_1_0_3_4_1 - 0.0186243386243385*G0_1_0_3_4_2 - 0.027089947089947*G0_1_0_3_4_3 - 0.0203174603174602*G0_1_0_3_4_4 + 0.00507936507936506*G0_1_0_3_5_0 - 0.00507936507936507*G0_1_0_3_5_2 - 0.00677248677248675*G0_1_0_3_5_3 + 0.00677248677248673*G0_1_0_3_5_5 + 0.0296296296296295*G0_1_0_4_0_0 - 0.0059259259259259*G0_1_0_4_0_1 + 0.0101587301587301*G0_1_0_4_0_3 + 0.0491005291005289*G0_1_0_4_0_4 + 0.0186243386243385*G0_1_0_4_0_5 - 0.0059259259259259*G0_1_0_4_1_0 + 0.00592592592592589*G0_1_0_4_1_2 + 0.00507936507936505*G0_1_0_4_1_3 - 0.00507936507936505*G0_1_0_4_1_5 + 0.00592592592592589*G0_1_0_4_2_1 - 0.0296296296296294*G0_1_0_4_2_2 - 0.0186243386243385*G0_1_0_4_2_3 - 0.0491005291005288*G0_1_0_4_2_4 - 0.0101587301587301*G0_1_0_4_2_5 + 0.0101587301587301*G0_1_0_4_3_0 + 0.00507936507936505*G0_1_0_4_3_1 - 0.0186243386243385*G0_1_0_4_3_2 - 0.027089947089947*G0_1_0_4_3_3 - 0.0203174603174602*G0_1_0_4_3_4 + 0.0491005291005289*G0_1_0_4_4_0 - 0.0491005291005288*G0_1_0_4_4_2 - 0.0203174603174602*G0_1_0_4_4_3 + 0.0203174603174602*G0_1_0_4_4_5 + 0.0186243386243385*G0_1_0_4_5_0 - 0.00507936507936505*G0_1_0_4_5_1 - 0.0101587301587301*G0_1_0_4_5_2 + 0.0203174603174602*G0_1_0_4_5_4 + 0.027089947089947*G0_1_0_4_5_5 + 0.0296296296296295*G0_1_0_5_0_0 - 0.00592592592592589*G0_1_0_5_0_1 - 0.00338624338624337*G0_1_0_5_0_2 + 0.00507936507936506*G0_1_0_5_0_3 + 0.0186243386243385*G0_1_0_5_0_4 + 0.032169312169312*G0_1_0_5_0_5 - 0.00592592592592589*G0_1_0_5_1_0 + 0.00253968253968253*G0_1_0_5_1_2 - 0.00507936507936505*G0_1_0_5_1_4 - 0.0169312169312168*G0_1_0_5_1_5 - 0.00338624338624337*G0_1_0_5_2_0 + 0.00253968253968253*G0_1_0_5_2_1 - 0.000846560846560858*G0_1_0_5_2_2 - 0.00507936507936506*G0_1_0_5_2_3 - 0.0101587301587301*G0_1_0_5_2_4 - 0.00846560846560842*G0_1_0_5_2_5 + 0.00507936507936506*G0_1_0_5_3_0 - 0.00507936507936506*G0_1_0_5_3_2 - 0.00677248677248675*G0_1_0_5_3_3 + 0.00677248677248672*G0_1_0_5_3_5 + 0.0186243386243385*G0_1_0_5_4_0 - 0.00507936507936505*G0_1_0_5_4_1 - 0.0101587301587301*G0_1_0_5_4_2 + 0.0203174603174602*G0_1_0_5_4_4 + 0.027089947089947*G0_1_0_5_4_5 + 0.032169312169312*G0_1_0_5_5_0 - 0.0169312169312168*G0_1_0_5_5_1 - 0.00846560846560842*G0_1_0_5_5_2 + 0.00677248677248673*G0_1_0_5_5_3 + 0.027089947089947*G0_1_0_5_5_4 + 0.0609523809523805*G0_1_0_5_5_5;
    A[2] = -A[8] + 0.0174603174603174*G0_0_1_0_0_0 - 0.00179894179894179*G0_0_1_0_0_1 - 0.00126984126984126*G0_0_1_0_0_2 + 0.000423280423280423*G0_0_1_0_0_3 + 0.00423280423280421*G0_0_1_0_0_4 + 0.00634920634920632*G0_0_1_0_0_5 - 0.00179894179894179*G0_0_1_0_1_0 + 0.00179894179894178*G0_0_1_0_1_1 + 0.00063492063492063*G0_0_1_0_1_3 - 0.000634920634920632*G0_0_1_0_1_4 - 0.00126984126984126*G0_0_1_0_2_0 + 0.000529100529100526*G0_0_1_0_2_2 - 0.00021164021164021*G0_0_1_0_2_3 + 0.00021164021164021*G0_0_1_0_2_4 - 0.000846560846560842*G0_0_1_0_2_5 + 0.000423280423280423*G0_0_1_0_3_0 + 0.00063492063492063*G0_0_1_0_3_1 - 0.00021164021164021*G0_0_1_0_3_2 - 0.0021164021164021*G0_0_1_0_3_3 + 0.00042328042328042*G0_0_1_0_3_4 + 0.00084656084656084*G0_0_1_0_3_5 + 0.00423280423280421*G0_0_1_0_4_0 - 0.000634920634920632*G0_0_1_0_4_1 + 0.00021164021164021*G0_0_1_0_4_2 + 0.000423280423280421*G0_0_1_0_4_3 + 0.00550264550264547*G0_0_1_0_4_4 + 0.00296296296296295*G0_0_1_0_4_5 + 0.00634920634920632*G0_0_1_0_5_0 - 0.000846560846560842*G0_0_1_0_5_2 + 0.00084656084656084*G0_0_1_0_5_3 + 0.00296296296296295*G0_0_1_0_5_4 + 0.00973544973544967*G0_0_1_0_5_5 - 0.00179894179894179*G0_0_1_1_0_0 + 0.00179894179894178*G0_0_1_1_0_1 + 0.00063492063492063*G0_0_1_1_0_3 - 0.000634920634920632*G0_0_1_1_0_4 + 0.00179894179894178*G0_0_1_1_1_0 - 0.0174603174603174*G0_0_1_1_1_1 + 0.00126984126984126*G0_0_1_1_1_2 - 0.0042328042328042*G0_0_1_1_1_3 - 0.000423280423280421*G0_0_1_1_1_4 - 0.00634920634920631*G0_0_1_1_1_5 + 0.00126984126984126*G0_0_1_1_2_1 - 0.000529100529100526*G0_0_1_1_2_2 - 0.000211640211640211*G0_0_1_1_2_3 + 0.00021164021164021*G0_0_1_1_2_4 + 0.000846560846560841*G0_0_1_1_2_5 + 0.00063492063492063*G0_0_1_1_3_0 - 0.0042328042328042*G0_0_1_1_3_1 - 0.000211640211640211*G0_0_1_1_3_2 - 0.00550264550264547*G0_0_1_1_3_3 - 0.000423280423280422*G0_0_1_1_3_4 - 0.00296296296296295*G0_0_1_1_3_5 - 0.000634920634920632*G0_0_1_1_4_0 - 0.000423280423280421*G0_0_1_1_4_1 + 0.00021164021164021*G0_0_1_1_4_2 - 0.000423280423280422*G0_0_1_1_4_3 + 0.00211640211640211*G0_0_1_1_4_4 - 0.000846560846560841*G0_0_1_1_4_5 - 0.00634920634920631*G0_0_1_1_5_1 + 0.000846560846560841*G0_0_1_1_5_2 - 0.00296296296296295*G0_0_1_1_5_3 - 0.000846560846560841*G0_0_1_1_5_4 - 0.00973544973544967*G0_0_1_1_5_5 - 0.00126984126984126*G0_0_1_2_0_0 + 0.000529100529100526*G0_0_1_2_0_2 - 0.00021164021164021*G0_0_1_2_0_3 + 0.00021164021164021*G0_0_1_2_0_4 - 0.000846560846560842*G0_0_1_2_0_5 + 0.00126984126984126*G0_0_1_2_1_1 - 0.000529100529100526*G0_0_1_2_1_2 - 0.000211640211640211*G0_0_1_2_1_3 + 0.00021164021164021*G0_0_1_2_1_4 + 0.000846560846560841*G0_0_1_2_1_5 + 0.000529100529100526*G0_0_1_2_2_0 - 0.000529100529100526*G0_0_1_2_2_1 + 0.00211640211640211*G0_0_1_2_2_3 - 0.0021164021164021*G0_0_1_2_2_4 - 0.00021164021164021*G0_0_1_2_3_0 - 0.000211640211640211*G0_0_1_2_3_1 + 0.00211640211640211*G0_0_1_2_3_2 + 0.00423280423280421*G0_0_1_2_3_3 + 0.000423280423280422*G0_0_1_2_3_5 + 0.00021164021164021*G0_0_1_2_4_0 + 0.00021164021164021*G0_0_1_2_4_1 - 0.0021164021164021*G0_0_1_2_4_2 - 0.00423280423280421*G0_0_1_2_4_4 - 0.000423280423280422*G0_0_1_2_4_5 - 0.000846560846560842*G0_0_1_2_5_0 + 0.000846560846560841*G0_0_1_2_5_1 + 0.000423280423280422*G0_0_1_2_5_3 - 0.000423280423280422*G0_0_1_2_5_4 + 0.000423280423280423*G0_0_1_3_0_0 + 0.00063492063492063*G0_0_1_3_0_1 - 0.00021164021164021*G0_0_1_3_0_2 - 0.0021164021164021*G0_0_1_3_0_3 + 0.00042328042328042*G0_0_1_3_0_4 + 0.00084656084656084*G0_0_1_3_0_5 + 0.00063492063492063*G0_0_1_3_1_0 - 0.0042328042328042*G0_0_1_3_1_1 - 0.000211640211640211*G0_0_1_3_1_2 - 0.00550264550264547*G0_0_1_3_1_3 - 0.000423280423280422*G0_0_1_3_1_4 - 0.00296296296296295*G0_0_1_3_1_5 - 0.00021164021164021*G0_0_1_3_2_0 - 0.000211640211640211*G0_0_1_3_2_1 + 0.00211640211640211*G0_0_1_3_2_2 + 0.00423280423280421*G0_0_1_3_2_3 + 0.000423280423280422*G0_0_1_3_2_5 - 0.0021164021164021*G0_0_1_3_3_0 - 0.00550264550264547*G0_0_1_3_3_1 + 0.00423280423280421*G0_0_1_3_3_2 + 0.0457142857142855*G0_0_1_3_3_3 + 0.00507936507936507*G0_0_1_3_3_4 + 0.00338624338624338*G0_0_1_3_3_5 + 0.00042328042328042*G0_0_1_3_4_0 - 0.000423280423280422*G0_0_1_3_4_1 + 0.00507936507936507*G0_0_1_3_4_3 - 0.00507936507936505*G0_0_1_3_4_4 + 0.00084656084656084*G0_0_1_3_5_0 - 0.00296296296296295*G0_0_1_3_5_1 + 0.000423280423280422*G0_0_1_3_5_2 + 0.00338624338624338*G0_0_1_3_5_3 - 0.00169312169312168*G0_0_1_3_5_5 + 0.00423280423280421*G0_0_1_4_0_0 - 0.000634920634920632*G0_0_1_4_0_1 + 0.00021164021164021*G0_0_1_4_0_2 + 0.00042328042328042*G0_0_1_4_0_3 + 0.00550264550264548*G0_0_1_4_0_4 + 0.00296296296296295*G0_0_1_4_0_5 - 0.000634920634920632*G0_0_1_4_1_0 - 0.000423280423280421*G0_0_1_4_1_1 + 0.00021164021164021*G0_0_1_4_1_2 - 0.000423280423280422*G0_0_1_4_1_3 + 0.00211640211640211*G0_0_1_4_1_4 - 0.000846560846560841*G0_0_1_4_1_5 + 0.00021164021164021*G0_0_1_4_2_0 + 0.00021164021164021*G0_0_1_4_2_1 - 0.0021164021164021*G0_0_1_4_2_2 - 0.00423280423280421*G0_0_1_4_2_4 - 0.000423280423280422*G0_0_1_4_2_5 + 0.000423280423280421*G0_0_1_4_3_0 - 0.000423280423280422*G0_0_1_4_3_1 + 0.00507936507936506*G0_0_1_4_3_3 - 0.00507936507936505*G0_0_1_4_3_4 + 0.00550264550264548*G0_0_1_4_4_0 + 0.00211640211640211*G0_0_1_4_4_1 - 0.00423280423280421*G0_0_1_4_4_2 - 0.00507936507936505*G0_0_1_4_4_3 - 0.0457142857142855*G0_0_1_4_4_4 - 0.00338624338624338*G0_0_1_4_4_5 + 0.00296296296296295*G0_0_1_4_5_0 - 0.000846560846560841*G0_0_1_4_5_1 - 0.000423280423280422*G0_0_1_4_5_2 - 0.00338624338624338*G0_0_1_4_5_4 + 0.00169312169312168*G0_0_1_4_5_5 + 0.00634920634920632*G0_0_1_5_0_0 - 0.000846560846560842*G0_0_1_5_0_2 + 0.00084656084656084*G0_0_1_5_0_3 + 0.00296296296296295*G0_0_1_5_0_4 + 0.00973544973544967*G0_0_1_5_0_5 - 0.00634920634920631*G0_0_1_5_1_1 + 0.000846560846560841*G0_0_1_5_1_2 - 0.00296296296296295*G0_0_1_5_1_3 - 0.000846560846560841*G0_0_1_5_1_4 - 0.00973544973544967*G0_0_1_5_1_5 - 0.000846560846560842*G0_0_1_5_2_0 + 0.000846560846560841*G0_0_1_5_2_1 + 0.000423280423280422*G0_0_1_5_2_3 - 0.000423280423280422*G0_0_1_5_2_4 + 0.00084656084656084*G0_0_1_5_3_0 - 0.00296296296296295*G0_0_1_5_3_1 + 0.000423280423280422*G0_0_1_5_3_2 + 0.00338624338624338*G0_0_1_5_3_3 - 0.00169312169312168*G0_0_1_5_3_5 + 0.00296296296296295*G0_0_1_5_4_0 - 0.000846560846560841*G0_0_1_5_4_1 - 0.000423280423280422*G0_0_1_5_4_2 - 0.00338624338624338*G0_0_1_5_4_4 + 0.00169312169312168*G0_0_1_5_4_5 + 0.00973544973544967*G0_0_1_5_5_0 - 0.00973544973544967*G0_0_1_5_5_1 - 0.00169312169312168*G0_0_1_5_5_3 + 0.00169312169312168*G0_0_1_5_5_4 + 0.0134920634920634*G0_1_1_0_0_0 - 0.00132275132275132*G0_1_1_0_0_1 - 0.00079365079365079*G0_1_1_0_0_2 + 0.000529100529100527*G0_1_1_0_0_3 + 0.00370370370370368*G0_1_1_0_0_4 + 0.00582010582010579*G0_1_1_0_0_5 - 0.00132275132275132*G0_1_1_0_1_0 + 0.000476190476190473*G0_1_1_0_1_1 + 0.000238095238095236*G0_1_1_0_1_2 + 0.00021164021164021*G0_1_1_0_1_3 - 0.000423280423280421*G0_1_1_0_1_4 - 0.00116402116402116*G0_1_1_0_1_5 - 0.00079365079365079*G0_1_1_0_2_0 + 0.000238095238095237*G0_1_1_0_2_1 - 0.000793650793650787*G0_1_1_0_2_2 - 0.00063492063492063*G0_1_1_0_2_3 - 0.000952380952380947*G0_1_1_0_2_4 - 0.000634920634920632*G0_1_1_0_2_5 + 0.000529100529100527*G0_1_1_0_3_0 + 0.00021164021164021*G0_1_1_0_3_1 - 0.00063492063492063*G0_1_1_0_3_2 - 0.00169312169312168*G0_1_1_0_3_3 - 0.00021164021164021*G0_1_1_0_3_4 + 0.00021164021164021*G0_1_1_0_3_5 + 0.00370370370370368*G0_1_1_0_4_0 - 0.000423280423280421*G0_1_1_0_4_1 - 0.000952380952380947*G0_1_1_0_4_2 - 0.00021164021164021*G0_1_1_0_4_3 + 0.00211640211640211*G0_1_1_0_4_4 + 0.0021164021164021*G0_1_1_0_4_5 + 0.00582010582010579*G0_1_1_0_5_0 - 0.00116402116402116*G0_1_1_0_5_1 - 0.000634920634920632*G0_1_1_0_5_2 + 0.00021164021164021*G0_1_1_0_5_3 + 0.0021164021164021*G0_1_1_0_5_4 + 0.00634920634920631*G0_1_1_0_5_5 - 0.00132275132275132*G0_1_1_1_0_0 + 0.000476190476190473*G0_1_1_1_0_1 + 0.000238095238095236*G0_1_1_1_0_2 + 0.00021164021164021*G0_1_1_1_0_3 - 0.000423280423280421*G0_1_1_1_0_4 - 0.00116402116402116*G0_1_1_1_0_5 + 0.000476190476190473*G0_1_1_1_1_0 - 0.00396825396825395*G0_1_1_1_1_1 + 0.000476190476190474*G0_1_1_1_1_2 - 0.000529100529100526*G0_1_1_1_1_3 + 0.000105820105820105*G0_1_1_1_1_4 - 0.000529100529100527*G0_1_1_1_1_5 + 0.000238095238095237*G0_1_1_1_2_0 + 0.000476190476190474*G0_1_1_1_2_1 - 0.00132275132275131*G0_1_1_1_2_2 - 0.00116402116402116*G0_1_1_1_2_3 - 0.000423280423280421*G0_1_1_1_2_4 + 0.00021164021164021*G0_1_1_1_2_5 + 0.00021164021164021*G0_1_1_1_3_0 - 0.000529100529100526*G0_1_1_1_3_1 - 0.00116402116402116*G0_1_1_1_3_2 - 0.00338624338624337*G0_1_1_1_3_3 - 0.000634920634920632*G0_1_1_1_3_4 - 0.000846560846560842*G0_1_1_1_3_5 - 0.000423280423280421*G0_1_1_1_4_0 + 0.000105820105820105*G0_1_1_1_4_1 - 0.000423280423280421*G0_1_1_1_4_2 - 0.000634920634920632*G0_1_1_1_4_3 + 0.000423280423280422*G0_1_1_1_4_4 - 0.000634920634920631*G0_1_1_1_4_5 - 0.00116402116402116*G0_1_1_1_5_0 - 0.000529100529100527*G0_1_1_1_5_1 + 0.00021164021164021*G0_1_1_1_5_2 - 0.000846560846560842*G0_1_1_1_5_3 - 0.000634920634920631*G0_1_1_1_5_4 - 0.00338624338624336*G0_1_1_1_5_5 - 0.00079365079365079*G0_1_1_2_0_0 + 0.000238095238095237*G0_1_1_2_0_1 - 0.000793650793650787*G0_1_1_2_0_2 - 0.00063492063492063*G0_1_1_2_0_3 - 0.000952380952380947*G0_1_1_2_0_4 - 0.000634920634920632*G0_1_1_2_0_5 + 0.000238095238095237*G0_1_1_2_1_0 + 0.000476190476190474*G0_1_1_2_1_1 - 0.00132275132275131*G0_1_1_2_1_2 - 0.00116402116402116*G0_1_1_2_1_3 - 0.000423280423280421*G0_1_1_2_1_4 + 0.00021164021164021*G0_1_1_2_1_5 - 0.000793650793650787*G0_1_1_2_2_0 - 0.00132275132275131*G0_1_1_2_2_1 + 0.0134920634920634*G0_1_1_2_2_2 + 0.00582010582010579*G0_1_1_2_2_3 + 0.00370370370370368*G0_1_1_2_2_4 + 0.00052910052910053*G0_1_1_2_2_5 - 0.00063492063492063*G0_1_1_2_3_0 - 0.00116402116402116*G0_1_1_2_3_1 + 0.00582010582010579*G0_1_1_2_3_2 + 0.00634920634920631*G0_1_1_2_3_3 + 0.00211640211640211*G0_1_1_2_3_4 + 0.000211640211640213*G0_1_1_2_3_5 - 0.000952380952380947*G0_1_1_2_4_0 - 0.000423280423280421*G0_1_1_2_4_1 + 0.00370370370370368*G0_1_1_2_4_2 + 0.00211640211640211*G0_1_1_2_4_3 + 0.0021164021164021*G0_1_1_2_4_4 - 0.000211640211640209*G0_1_1_2_4_5 - 0.000634920634920632*G0_1_1_2_5_0 + 0.00021164021164021*G0_1_1_2_5_1 + 0.00052910052910053*G0_1_1_2_5_2 + 0.000211640211640213*G0_1_1_2_5_3 - 0.000211640211640209*G0_1_1_2_5_4 - 0.00169312169312168*G0_1_1_2_5_5 + 0.000529100529100527*G0_1_1_3_0_0 + 0.00021164021164021*G0_1_1_3_0_1 - 0.00063492063492063*G0_1_1_3_0_2 - 0.00169312169312168*G0_1_1_3_0_3 - 0.00021164021164021*G0_1_1_3_0_4 + 0.00021164021164021*G0_1_1_3_0_5 + 0.00021164021164021*G0_1_1_3_1_0 - 0.000529100529100526*G0_1_1_3_1_1 - 0.00116402116402116*G0_1_1_3_1_2 - 0.00338624338624337*G0_1_1_3_1_3 - 0.000634920634920632*G0_1_1_3_1_4 - 0.000846560846560842*G0_1_1_3_1_5 - 0.00063492063492063*G0_1_1_3_2_0 - 0.00116402116402116*G0_1_1_3_2_1 + 0.00582010582010579*G0_1_1_3_2_2 + 0.00634920634920631*G0_1_1_3_2_3 + 0.00211640211640211*G0_1_1_3_2_4 + 0.000211640211640213*G0_1_1_3_2_5 - 0.00169312169312168*G0_1_1_3_3_0 - 0.00338624338624337*G0_1_1_3_3_1 + 0.00634920634920631*G0_1_1_3_3_2 + 0.029206349206349*G0_1_1_3_3_3 + 0.00465608465608464*G0_1_1_3_3_4 + 0.00296296296296296*G0_1_1_3_3_5 - 0.00021164021164021*G0_1_1_3_4_0 - 0.000634920634920632*G0_1_1_3_4_1 + 0.00211640211640211*G0_1_1_3_4_2 + 0.00465608465608464*G0_1_1_3_4_3 - 0.000423280423280421*G0_1_1_3_4_4 + 0.000846560846560843*G0_1_1_3_4_5 + 0.00021164021164021*G0_1_1_3_5_0 - 0.000846560846560842*G0_1_1_3_5_1 + 0.000211640211640213*G0_1_1_3_5_2 + 0.00296296296296296*G0_1_1_3_5_3 + 0.000846560846560843*G0_1_1_3_5_4 + 0.00296296296296295*G0_1_1_3_5_5 + 0.00370370370370368*G0_1_1_4_0_0 - 0.000423280423280421*G0_1_1_4_0_1 - 0.000952380952380947*G0_1_1_4_0_2 - 0.00021164021164021*G0_1_1_4_0_3 + 0.00211640211640211*G0_1_1_4_0_4 + 0.0021164021164021*G0_1_1_4_0_5 - 0.000423280423280421*G0_1_1_4_1_0 + 0.000105820105820105*G0_1_1_4_1_1 - 0.000423280423280421*G0_1_1_4_1_2 - 0.000634920634920632*G0_1_1_4_1_3 + 0.000423280423280421*G0_1_1_4_1_4 - 0.000634920634920631*G0_1_1_4_1_5 - 0.000952380952380947*G0_1_1_4_2_0 - 0.000423280423280421*G0_1_1_4_2_1 + 0.00370370370370368*G0_1_1_4_2_2 + 0.00211640211640211*G0_1_1_4_2_3 + 0.0021164021164021*G0_1_1_4_2_4 - 0.000211640211640209*G0_1_1_4_2_5 - 0.00021164021164021*G0_1_1_4_3_0 - 0.000634920634920632*G0_1_1_4_3_1 + 0.00211640211640211*G0_1_1_4_3_2 + 0.00465608465608464*G0_1_1_4_3_3 - 0.000423280423280421*G0_1_1_4_3_4 + 0.000846560846560843*G0_1_1_4_3_5 + 0.00211640211640211*G0_1_1_4_4_0 + 0.000423280423280422*G0_1_1_4_4_1 + 0.0021164021164021*G0_1_1_4_4_2 - 0.000423280423280421*G0_1_1_4_4_3 - 0.0165079365079364*G0_1_1_4_4_4 - 0.000423280423280425*G0_1_1_4_4_5 + 0.0021164021164021*G0_1_1_4_5_0 - 0.000634920634920631*G0_1_1_4_5_1 - 0.000211640211640209*G0_1_1_4_5_2 + 0.000846560846560843*G0_1_1_4_5_3 - 0.000423280423280425*G0_1_1_4_5_4 + 0.00465608465608463*G0_1_1_4_5_5 + 0.00582010582010579*G0_1_1_5_0_0 - 0.00116402116402116*G0_1_1_5_0_1 - 0.000634920634920632*G0_1_1_5_0_2 + 0.00021164021164021*G0_1_1_5_0_3 + 0.0021164021164021*G0_1_1_5_0_4 + 0.00634920634920631*G0_1_1_5_0_5 - 0.00116402116402116*G0_1_1_5_1_0 - 0.000529100529100527*G0_1_1_5_1_1 + 0.00021164021164021*G0_1_1_5_1_2 - 0.000846560846560842*G0_1_1_5_1_3 - 0.000634920634920631*G0_1_1_5_1_4 - 0.00338624338624336*G0_1_1_5_1_5 - 0.000634920634920632*G0_1_1_5_2_0 + 0.00021164021164021*G0_1_1_5_2_1 + 0.00052910052910053*G0_1_1_5_2_2 + 0.000211640211640213*G0_1_1_5_2_3 - 0.000211640211640209*G0_1_1_5_2_4 - 0.00169312169312168*G0_1_1_5_2_5 + 0.00021164021164021*G0_1_1_5_3_0 - 0.000846560846560842*G0_1_1_5_3_1 + 0.000211640211640213*G0_1_1_5_3_2 + 0.00296296296296296*G0_1_1_5_3_3 + 0.000846560846560843*G0_1_1_5_3_4 + 0.00296296296296295*G0_1_1_5_3_5 + 0.0021164021164021*G0_1_1_5_4_0 - 0.000634920634920631*G0_1_1_5_4_1 - 0.000211640211640209*G0_1_1_5_4_2 + 0.000846560846560843*G0_1_1_5_4_3 - 0.000423280423280425*G0_1_1_5_4_4 + 0.00465608465608463*G0_1_1_5_4_5 + 0.00634920634920631*G0_1_1_5_5_0 - 0.00338624338624336*G0_1_1_5_5_1 - 0.00169312169312168*G0_1_1_5_5_2 + 0.00296296296296295*G0_1_1_5_5_3 + 0.00465608465608463*G0_1_1_5_5_4 + 0.029206349206349*G0_1_1_5_5_5;
    A[20] = A[2] - 0.015079365079365*G0_0_1_0_0_0 + 0.001005291005291*G0_0_1_0_0_1 + 0.00206349206349205*G0_0_1_0_0_2 + 0.00116402116402115*G0_0_1_0_0_3 - 0.00158730158730158*G0_0_1_0_0_4 - 0.00582010582010579*G0_0_1_0_0_5 + 0.001005291005291*G0_0_1_0_1_0 - 0.000793650793650788*G0_0_1_0_1_1 + 0.000502645502645498*G0_0_1_0_1_2 + 0.00169312169312168*G0_0_1_0_1_3 + 0.00232804232804231*G0_0_1_0_1_4 + 0.002010582010582*G0_0_1_0_1_5 + 0.00206349206349205*G0_0_1_0_2_0 + 0.000502645502645498*G0_0_1_0_2_1 - 0.00502645502645498*G0_0_1_0_2_2 - 0.00253968253968252*G0_0_1_0_2_3 - 0.00433862433862431*G0_0_1_0_2_4 + 0.000211640211640209*G0_0_1_0_2_5 + 0.00116402116402115*G0_0_1_0_3_0 + 0.00169312169312168*G0_0_1_0_3_1 - 0.00253968253968252*G0_0_1_0_3_2 - 0.00804232804232799*G0_0_1_0_3_3 - 0.00698412698412694*G0_0_1_0_3_4 - 0.00275132275132274*G0_0_1_0_3_5 - 0.00158730158730158*G0_0_1_0_4_0 + 0.00232804232804231*G0_0_1_0_4_1 - 0.00433862433862431*G0_0_1_0_4_2 - 0.00698412698412694*G0_0_1_0_4_3 - 0.016084656084656*G0_0_1_0_4_4 - 0.00507936507936505*G0_0_1_0_4_5 - 0.00582010582010579*G0_0_1_0_5_0 + 0.002010582010582*G0_0_1_0_5_1 + 0.000211640211640209*G0_0_1_0_5_2 - 0.00275132275132274*G0_0_1_0_5_3 - 0.00507936507936505*G0_0_1_0_5_4 - 0.00761904761904757*G0_0_1_0_5_5 + 0.001005291005291*G0_0_1_1_0_0 - 0.000793650793650789*G0_0_1_1_0_1 + 0.000502645502645498*G0_0_1_1_0_2 + 0.00169312169312168*G0_0_1_1_0_3 + 0.00232804232804231*G0_0_1_1_0_4 + 0.002010582010582*G0_0_1_1_0_5 - 0.000793650793650788*G0_0_1_1_1_0 + 0.00238095238095237*G0_0_1_1_1_1 + 0.000793650793650788*G0_0_1_1_1_2 + 0.00264550264550263*G0_0_1_1_1_3 + 0.00158730158730158*G0_0_1_1_1_4 + 0.00052910052910053*G0_0_1_1_1_5 + 0.000502645502645498*G0_0_1_1_2_0 + 0.000793650793650788*G0_0_1_1_2_1 - 0.00449735449735446*G0_0_1_1_2_2 - 0.0041269841269841*G0_0_1_1_2_3 - 0.00275132275132273*G0_0_1_1_2_4 - 0.000634920634920633*G0_0_1_1_2_5 + 0.00169312169312168*G0_0_1_1_3_0 + 0.00264550264550263*G0_0_1_1_3_1 - 0.0041269841269841*G0_0_1_1_3_2 - 0.0105820105820105*G0_0_1_1_3_3 - 0.00656084656084653*G0_0_1_1_3_4 - 0.00211640211640211*G0_0_1_1_3_5 + 0.00232804232804231*G0_0_1_1_4_0 + 0.00158730158730158*G0_0_1_1_4_1 - 0.00275132275132273*G0_0_1_1_4_2 - 0.00656084656084652*G0_0_1_1_4_3 - 0.0101587301587301*G0_0_1_1_4_4 - 0.0019047619047619*G0_0_1_1_4_5 + 0.002010582010582*G0_0_1_1_5_0 + 0.00052910052910053*G0_0_1_1_5_1 - 0.000634920634920633*G0_0_1_1_5_2 - 0.00211640211640211*G0_0_1_1_5_3 - 0.0019047619047619*G0_0_1_1_5_4 + 0.0021164021164021*G0_0_1_1_5_5 + 0.00206349206349205*G0_0_1_2_0_0 + 0.000502645502645498*G0_0_1_2_0_1 - 0.00502645502645498*G0_0_1_2_0_2 - 0.00253968253968252*G0_0_1_2_0_3 - 0.00433862433862431*G0_0_1_2_0_4 + 0.000211640211640209*G0_0_1_2_0_5 + 0.000502645502645498*G0_0_1_2_1_0 + 0.000793650793650788*G0_0_1_2_1_1 - 0.00449735449735446*G0_0_1_2_1_2 - 0.0041269841269841*G0_0_1_2_1_3 - 0.00275132275132273*G0_0_1_2_1_4 - 0.000634920634920633*G0_0_1_2_1_5 - 0.00502645502645498*G0_0_1_2_2_0 - 0.00449735449735446*G0_0_1_2_2_1 + 0.0499999999999996*G0_0_1_2_2_2 + 0.0195767195767194*G0_0_1_2_2_3 + 0.0216931216931215*G0_0_1_2_2_4 + 0.00158730158730159*G0_0_1_2_2_5 - 0.00253968253968252*G0_0_1_2_3_0 - 0.0041269841269841*G0_0_1_2_3_1 + 0.0195767195767194*G0_0_1_2_3_2 + 0.0190476190476189*G0_0_1_2_3_3 + 0.0105820105820105*G0_0_1_2_3_4 + 0.0019047619047619*G0_0_1_2_3_5 - 0.00433862433862431*G0_0_1_2_4_0 - 0.00275132275132273*G0_0_1_2_4_1 + 0.0216931216931215*G0_0_1_2_4_2 + 0.0105820105820105*G0_0_1_2_4_3 + 0.0232804232804232*G0_0_1_2_4_4 + 0.00232804232804232*G0_0_1_2_4_5 + 0.000211640211640209*G0_0_1_2_5_0 - 0.000634920634920633*G0_0_1_2_5_1 + 0.00158730158730159*G0_0_1_2_5_2 + 0.0019047619047619*G0_0_1_2_5_3 + 0.00232804232804232*G0_0_1_2_5_4 + 0.00253968253968252*G0_0_1_2_5_5 + 0.00116402116402115*G0_0_1_3_0_0 + 0.00169312169312168*G0_0_1_3_0_1 - 0.00253968253968252*G0_0_1_3_0_2 - 0.00804232804232799*G0_0_1_3_0_3 - 0.00698412698412694*G0_0_1_3_0_4 - 0.00275132275132274*G0_0_1_3_0_5 + 0.00169312169312168*G0_0_1_3_1_0 + 0.00264550264550263*G0_0_1_3_1_1 - 0.0041269841269841*G0_0_1_3_1_2 - 0.0105820105820105*G0_0_1_3_1_3 - 0.00656084656084652*G0_0_1_3_1_4 - 0.00211640211640211*G0_0_1_3_1_5 - 0.00253968253968252*G0_0_1_3_2_0 - 0.0041269841269841*G0_0_1_3_2_1 + 0.0195767195767194*G0_0_1_3_2_2 + 0.0190476190476189*G0_0_1_3_2_3 + 0.0105820105820105*G0_0_1_3_2_4 + 0.0019047619047619*G0_0_1_3_2_5 - 0.00804232804232799*G0_0_1_3_3_0 - 0.0105820105820105*G0_0_1_3_3_1 + 0.0190476190476189*G0_0_1_3_3_2 + 0.072380952380952*G0_0_1_3_3_3 + 0.0292063492063491*G0_0_1_3_3_4 + 0.0122751322751322*G0_0_1_3_3_5 - 0.00698412698412694*G0_0_1_3_4_0 - 0.00656084656084652*G0_0_1_3_4_1 + 0.0105820105820105*G0_0_1_3_4_2 + 0.0292063492063491*G0_0_1_3_4_3 + 0.0342857142857141*G0_0_1_3_4_4 + 0.00931216931216928*G0_0_1_3_4_5 - 0.00275132275132274*G0_0_1_3_5_0 - 0.00211640211640211*G0_0_1_3_5_1 + 0.0019047619047619*G0_0_1_3_5_2 + 0.0122751322751322*G0_0_1_3_5_3 + 0.00931216931216928*G0_0_1_3_5_4 + 0.000423280423280437*G0_0_1_3_5_5 - 0.00158730158730158*G0_0_1_4_0_0 + 0.00232804232804231*G0_0_1_4_0_1 - 0.00433862433862431*G0_0_1_4_0_2 - 0.00698412698412694*G0_0_1_4_0_3 - 0.016084656084656*G0_0_1_4_0_4 - 0.00507936507936505*G0_0_1_4_0_5 + 0.00232804232804231*G0_0_1_4_1_0 + 0.00158730158730158*G0_0_1_4_1_1 - 0.00275132275132273*G0_0_1_4_1_2 - 0.00656084656084652*G0_0_1_4_1_3 - 0.0101587301587301*G0_0_1_4_1_4 - 0.0019047619047619*G0_0_1_4_1_5 - 0.00433862433862431*G0_0_1_4_2_0 - 0.00275132275132273*G0_0_1_4_2_1 + 0.0216931216931215*G0_0_1_4_2_2 + 0.0105820105820105*G0_0_1_4_2_3 + 0.0232804232804232*G0_0_1_4_2_4 + 0.00232804232804232*G0_0_1_4_2_5 - 0.00698412698412694*G0_0_1_4_3_0 - 0.00656084656084652*G0_0_1_4_3_1 + 0.0105820105820105*G0_0_1_4_3_2 + 0.0292063492063491*G0_0_1_4_3_3 + 0.0342857142857141*G0_0_1_4_3_4 + 0.00931216931216927*G0_0_1_4_3_5 - 0.016084656084656*G0_0_1_4_4_0 - 0.0101587301587301*G0_0_1_4_4_1 + 0.0232804232804231*G0_0_1_4_4_2 + 0.0342857142857141*G0_0_1_4_4_3 + 0.118095238095238*G0_0_1_4_4_4 + 0.0156613756613756*G0_0_1_4_4_5 - 0.00507936507936505*G0_0_1_4_5_0 - 0.0019047619047619*G0_0_1_4_5_1 + 0.00232804232804232*G0_0_1_4_5_2 + 0.00931216931216927*G0_0_1_4_5_3 + 0.0156613756613756*G0_0_1_4_5_4 - 0.00126984126984124*G0_0_1_4_5_5 - 0.00582010582010579*G0_0_1_5_0_0 + 0.002010582010582*G0_0_1_5_0_1 + 0.00021164021164021*G0_0_1_5_0_2 - 0.00275132275132274*G0_0_1_5_0_3 - 0.00507936507936505*G0_0_1_5_0_4 - 0.00761904761904758*G0_0_1_5_0_5 + 0.002010582010582*G0_0_1_5_1_0 + 0.00052910052910053*G0_0_1_5_1_1 - 0.000634920634920633*G0_0_1_5_1_2 - 0.00211640211640211*G0_0_1_5_1_3 - 0.0019047619047619*G0_0_1_5_1_4 + 0.0021164021164021*G0_0_1_5_1_5 + 0.000211640211640209*G0_0_1_5_2_0 - 0.000634920634920633*G0_0_1_5_2_1 + 0.00158730158730159*G0_0_1_5_2_2 + 0.0019047619047619*G0_0_1_5_2_3 + 0.00232804232804232*G0_0_1_5_2_4 + 0.00253968253968252*G0_0_1_5_2_5 - 0.00275132275132274*G0_0_1_5_3_0 - 0.00211640211640211*G0_0_1_5_3_1 + 0.0019047619047619*G0_0_1_5_3_2 + 0.0122751322751322*G0_0_1_5_3_3 + 0.00931216931216928*G0_0_1_5_3_4 + 0.000423280423280437*G0_0_1_5_3_5 - 0.00507936507936505*G0_0_1_5_4_0 - 0.0019047619047619*G0_0_1_5_4_1 + 0.00232804232804232*G0_0_1_5_4_2 + 0.00931216931216928*G0_0_1_5_4_3 + 0.0156613756613756*G0_0_1_5_4_4 - 0.00126984126984124*G0_0_1_5_4_5 - 0.00761904761904757*G0_0_1_5_5_0 + 0.0021164021164021*G0_0_1_5_5_1 + 0.00253968253968252*G0_0_1_5_5_2 + 0.000423280423280438*G0_0_1_5_5_3 - 0.00126984126984124*G0_0_1_5_5_4 - 0.034285714285714*G0_0_1_5_5_5 - 0.015079365079365*G0_1_1_0_0_0 + 0.00111111111111111*G0_1_1_0_0_1 + 0.0011111111111111*G0_1_1_0_0_2 - 0.000105820105820106*G0_1_1_0_0_3 - 0.00370370370370368*G0_1_1_0_0_4 - 0.00793650793650789*G0_1_1_0_0_5 + 0.00111111111111111*G0_1_1_0_1_0 + 0.0011111111111111*G0_1_1_0_1_1 - 0.000343915343915342*G0_1_1_0_1_2 + 0.00126984126984126*G0_1_1_0_1_3 + 0.00126984126984126*G0_1_1_0_1_4 + 0.00391534391534389*G0_1_1_0_1_5 + 0.0011111111111111*G0_1_1_0_2_0 - 0.000343915343915342*G0_1_1_0_2_1 + 0.000264550264550264*G0_1_1_0_2_2 + 0.000529100529100527*G0_1_1_0_2_4 + 0.000423280423280422*G0_1_1_0_2_5 - 0.000105820105820106*G0_1_1_0_3_0 + 0.00126984126984126*G0_1_1_0_3_1 - 0.00296296296296295*G0_1_1_0_3_3 - 0.00232804232804231*G0_1_1_0_3_4 - 0.000634920634920634*G0_1_1_0_3_5 - 0.00370370370370368*G0_1_1_0_4_0 + 0.00126984126984126*G0_1_1_0_4_1 + 0.000529100529100527*G0_1_1_0_4_2 - 0.00232804232804231*G0_1_1_0_4_3 - 0.00507936507936505*G0_1_1_0_4_4 - 0.00338624338624337*G0_1_1_0_4_5 - 0.00793650793650789*G0_1_1_0_5_0 + 0.00391534391534389*G0_1_1_0_5_1 + 0.000423280423280422*G0_1_1_0_5_2 - 0.000634920634920634*G0_1_1_0_5_3 - 0.00338624338624337*G0_1_1_0_5_4 - 0.00507936507936505*G0_1_1_0_5_5 + 0.00111111111111111*G0_1_1_1_0_0 + 0.0011111111111111*G0_1_1_1_0_1 - 0.000343915343915342*G0_1_1_1_0_2 + 0.00126984126984126*G0_1_1_1_0_3 + 0.00126984126984126*G0_1_1_1_0_4 + 0.00391534391534389*G0_1_1_1_0_5 + 0.0011111111111111*G0_1_1_1_1_0 - 0.015079365079365*G0_1_1_1_1_1 + 0.0011111111111111*G0_1_1_1_1_2 - 0.00370370370370368*G0_1_1_1_1_3 - 0.000105820105820105*G0_1_1_1_1_4 - 0.00793650793650788*G0_1_1_1_1_5 - 0.000343915343915342*G0_1_1_1_2_0 + 0.0011111111111111*G0_1_1_1_2_1 + 0.000264550264550264*G0_1_1_1_2_2 + 0.000529100529100526*G0_1_1_1_2_3 + 0.000423280423280421*G0_1_1_1_2_5 + 0.00126984126984126*G0_1_1_1_3_0 - 0.00370370370370368*G0_1_1_1_3_1 + 0.000529100529100526*G0_1_1_1_3_2 - 0.00507936507936505*G0_1_1_1_3_3 - 0.00232804232804232*G0_1_1_1_3_4 - 0.00338624338624337*G0_1_1_1_3_5 + 0.00126984126984126*G0_1_1_1_4_0 - 0.000105820105820105*G0_1_1_1_4_1 - 0.00232804232804232*G0_1_1_1_4_3 - 0.00296296296296295*G0_1_1_1_4_4 - 0.000634920634920633*G0_1_1_1_4_5 + 0.00391534391534389*G0_1_1_1_5_0 - 0.00793650793650788*G0_1_1_1_5_1 + 0.000423280423280421*G0_1_1_1_5_2 - 0.00338624338624337*G0_1_1_1_5_3 - 0.000634920634920633*G0_1_1_1_5_4 - 0.00507936507936505*G0_1_1_1_5_5 + 0.0011111111111111*G0_1_1_2_0_0 - 0.000343915343915342*G0_1_1_2_0_1 + 0.000264550264550264*G0_1_1_2_0_2 + 0.000529100529100527*G0_1_1_2_0_4 + 0.000423280423280422*G0_1_1_2_0_5 - 0.000343915343915342*G0_1_1_2_1_0 + 0.0011111111111111*G0_1_1_2_1_1 + 0.000264550264550264*G0_1_1_2_1_2 + 0.000529100529100526*G0_1_1_2_1_3 + 0.000423280423280421*G0_1_1_2_1_5 + 0.000264550264550264*G0_1_1_2_2_0 + 0.000264550264550265*G0_1_1_2_2_1 - 0.00873015873015871*G0_1_1_2_2_2 - 0.00158730158730159*G0_1_1_2_2_3 - 0.00158730158730158*G0_1_1_2_2_4 - 0.000529100529100528*G0_1_1_2_2_5 + 0.000529100529100526*G0_1_1_2_3_1 - 0.00158730158730159*G0_1_1_2_3_2 + 0.00105820105820105*G0_1_1_2_3_5 + 0.000529100529100527*G0_1_1_2_4_0 - 0.00158730158730158*G0_1_1_2_4_2 + 0.00105820105820105*G0_1_1_2_4_5 + 0.000423280423280422*G0_1_1_2_5_0 + 0.000423280423280421*G0_1_1_2_5_1 - 0.000529100529100528*G0_1_1_2_5_2 + 0.00105820105820105*G0_1_1_2_5_3 + 0.00105820105820105*G0_1_1_2_5_4 + 0.00550264550264547*G0_1_1_2_5_5 - 0.000105820105820106*G0_1_1_3_0_0 + 0.00126984126984126*G0_1_1_3_0_1 - 0.00296296296296295*G0_1_1_3_0_3 - 0.00232804232804231*G0_1_1_3_0_4 - 0.000634920634920634*G0_1_1_3_0_5 + 0.00126984126984126*G0_1_1_3_1_0 - 0.00370370370370368*G0_1_1_3_1_1 + 0.000529100529100526*G0_1_1_3_1_2 - 0.00507936507936505*G0_1_1_3_1_3 - 0.00232804232804232*G0_1_1_3_1_4 - 0.00338624338624337*G0_1_1_3_1_5 + 0.000529100529100526*G0_1_1_3_2_1 - 0.00158730158730159*G0_1_1_3_2_2 + 0.00105820105820105*G0_1_1_3_2_5 - 0.00296296296296295*G0_1_1_3_3_0 - 0.00507936507936505*G0_1_1_3_3_1 + 0.0317460317460316*G0_1_1_3_3_3 + 0.0105820105820105*G0_1_1_3_3_4 + 0.0038095238095238*G0_1_1_3_3_5 - 0.00232804232804231*G0_1_1_3_4_0 - 0.00232804232804232*G0_1_1_3_4_1 + 0.0105820105820105*G0_1_1_3_4_3 + 0.0105820105820105*G0_1_1_3_4_4 + 0.00253968253968253*G0_1_1_3_4_5 - 0.000634920634920634*G0_1_1_3_5_0 - 0.00338624338624337*G0_1_1_3_5_1 + 0.00105820105820105*G0_1_1_3_5_2 + 0.00380952380952381*G0_1_1_3_5_3 + 0.00253968253968254*G0_1_1_3_5_4 - 0.00973544973544966*G0_1_1_3_5_5 - 0.00370370370370368*G0_1_1_4_0_0 + 0.00126984126984126*G0_1_1_4_0_1 + 0.000529100529100527*G0_1_1_4_0_2 - 0.00232804232804232*G0_1_1_4_0_3 - 0.00507936507936505*G0_1_1_4_0_4 - 0.00338624338624337*G0_1_1_4_0_5 + 0.00126984126984126*G0_1_1_4_1_0 - 0.000105820105820105*G0_1_1_4_1_1 - 0.00232804232804232*G0_1_1_4_1_3 - 0.00296296296296295*G0_1_1_4_1_4 - 0.000634920634920633*G0_1_1_4_1_5 + 0.000529100529100527*G0_1_1_4_2_0 - 0.00158730158730158*G0_1_1_4_2_2 + 0.00105820105820105*G0_1_1_4_2_5 - 0.00232804232804231*G0_1_1_4_3_0 - 0.00232804232804232*G0_1_1_4_3_1 + 0.0105820105820105*G0_1_1_4_3_3 + 0.0105820105820105*G0_1_1_4_3_4 + 0.00253968253968253*G0_1_1_4_3_5 - 0.00507936507936505*G0_1_1_4_4_0 - 0.00296296296296295*G0_1_1_4_4_1 + 0.0105820105820105*G0_1_1_4_4_3 + 0.0317460317460316*G0_1_1_4_4_4 + 0.0038095238095238*G0_1_1_4_4_5 - 0.00338624338624337*G0_1_1_4_5_0 - 0.000634920634920633*G0_1_1_4_5_1 + 0.00105820105820105*G0_1_1_4_5_2 + 0.00253968253968254*G0_1_1_4_5_3 + 0.0038095238095238*G0_1_1_4_5_4 - 0.00973544973544966*G0_1_1_4_5_5 - 0.00793650793650789*G0_1_1_5_0_0 + 0.00391534391534389*G0_1_1_5_0_1 + 0.000423280423280422*G0_1_1_5_0_2 - 0.000634920634920634*G0_1_1_5_0_3 - 0.00338624338624337*G0_1_1_5_0_4 - 0.00507936507936505*G0_1_1_5_0_5 + 0.00391534391534389*G0_1_1_5_1_0 - 0.00793650793650788*G0_1_1_5_1_1 + 0.000423280423280421*G0_1_1_5_1_2 - 0.00338624338624337*G0_1_1_5_1_3 - 0.000634920634920633*G0_1_1_5_1_4 - 0.00507936507936505*G0_1_1_5_1_5 + 0.000423280423280422*G0_1_1_5_2_0 + 0.000423280423280421*G0_1_1_5_2_1 - 0.000529100529100528*G0_1_1_5_2_2 + 0.00105820105820105*G0_1_1_5_2_3 + 0.00105820105820105*G0_1_1_5_2_4 + 0.00550264550264547*G0_1_1_5_2_5 - 0.000634920634920634*G0_1_1_5_3_0 - 0.00338624338624337*G0_1_1_5_3_1 + 0.00105820105820105*G0_1_1_5_3_2 + 0.00380952380952381*G0_1_1_5_3_3 + 0.00253968253968254*G0_1_1_5_3_4 - 0.00973544973544966*G0_1_1_5_3_5 - 0.00338624338624337*G0_1_1_5_4_0 - 0.000634920634920633*G0_1_1_5_4_1 + 0.00105820105820105*G0_1_1_5_4_2 + 0.00253968253968253*G0_1_1_5_4_3 + 0.0038095238095238*G0_1_1_5_4_4 - 0.00973544973544966*G0_1_1_5_4_5 - 0.00507936507936505*G0_1_1_5_5_0 - 0.00507936507936505*G0_1_1_5_5_1 + 0.00550264550264547*G0_1_1_5_5_2 - 0.00973544973544966*G0_1_1_5_5_3 - 0.00973544973544966*G0_1_1_5_5_4 - 0.0901587301587295*G0_1_1_5_5_5;
    A[26] = -A[20] - 0.0190476190476189*G0_1_1_0_0_0 + 0.00169312169312168*G0_1_1_0_0_1 + 0.000634920634920633*G0_1_1_0_0_2 - 0.00126984126984126*G0_1_1_0_0_3 - 0.00634920634920631*G0_1_1_0_0_4 - 0.0105820105820105*G0_1_1_0_0_5 + 0.00169312169312168*G0_1_1_0_1_0 + 0.00169312169312168*G0_1_1_0_1_1 - 0.000952380952380945*G0_1_1_0_1_2 + 0.000423280423280419*G0_1_1_0_1_3 + 0.000423280423280421*G0_1_1_0_1_4 + 0.00465608465608463*G0_1_1_0_1_5 + 0.000634920634920633*G0_1_1_0_2_0 - 0.000952380952380945*G0_1_1_0_2_1 + 0.0042328042328042*G0_1_1_0_2_2 + 0.0021164021164021*G0_1_1_0_2_3 + 0.00423280423280421*G0_1_1_0_2_4 + 0.000846560846560844*G0_1_1_0_2_5 - 0.00126984126984126*G0_1_1_0_3_0 + 0.00042328042328042*G0_1_1_0_3_1 + 0.0021164021164021*G0_1_1_0_3_2 + 0.00253968253968252*G0_1_1_0_3_3 + 0.00169312169312168*G0_1_1_0_3_4 + 0.00084656084656084*G0_1_1_0_3_5 - 0.00634920634920631*G0_1_1_0_4_0 + 0.000423280423280421*G0_1_1_0_4_1 + 0.00423280423280421*G0_1_1_0_4_2 + 0.00169312169312168*G0_1_1_0_4_3 + 0.00253968253968253*G0_1_1_0_4_4 - 0.00253968253968252*G0_1_1_0_4_5 - 0.0105820105820105*G0_1_1_0_5_0 + 0.00465608465608463*G0_1_1_0_5_1 + 0.000846560846560844*G0_1_1_0_5_2 + 0.00084656084656084*G0_1_1_0_5_3 - 0.00253968253968252*G0_1_1_0_5_4 - 0.00592592592592589*G0_1_1_0_5_5 + 0.00169312169312168*G0_1_1_1_0_0 + 0.00169312169312168*G0_1_1_1_0_1 - 0.000952380952380945*G0_1_1_1_0_2 + 0.00042328042328042*G0_1_1_1_0_3 + 0.000423280423280421*G0_1_1_1_0_4 + 0.00465608465608463*G0_1_1_1_0_5 + 0.00169312169312168*G0_1_1_1_1_0 - 0.0190476190476189*G0_1_1_1_1_1 + 0.000634920634920632*G0_1_1_1_1_2 - 0.00634920634920631*G0_1_1_1_1_3 - 0.00126984126984126*G0_1_1_1_1_4 - 0.0105820105820105*G0_1_1_1_1_5 - 0.000952380952380945*G0_1_1_1_2_0 + 0.000634920634920632*G0_1_1_1_2_1 + 0.0042328042328042*G0_1_1_1_2_2 + 0.00423280423280421*G0_1_1_1_2_3 + 0.0021164021164021*G0_1_1_1_2_4 + 0.000846560846560843*G0_1_1_1_2_5 + 0.00042328042328042*G0_1_1_1_3_0 - 0.00634920634920631*G0_1_1_1_3_1 + 0.00423280423280421*G0_1_1_1_3_2 + 0.00253968253968253*G0_1_1_1_3_3 + 0.00169312169312168*G0_1_1_1_3_4 - 0.00253968253968252*G0_1_1_1_3_5 + 0.000423280423280421*G0_1_1_1_4_0 - 0.00126984126984126*G0_1_1_1_4_1 + 0.0021164021164021*G0_1_1_1_4_2 + 0.00169312169312168*G0_1_1_1_4_3 + 0.00253968253968253*G0_1_1_1_4_4 + 0.000846560846560842*G0_1_1_1_4_5 + 0.00465608465608463*G0_1_1_1_5_0 - 0.0105820105820105*G0_1_1_1_5_1 + 0.000846560846560844*G0_1_1_1_5_2 - 0.00253968253968252*G0_1_1_1_5_3 + 0.000846560846560842*G0_1_1_1_5_4 - 0.0059259259259259*G0_1_1_1_5_5 + 0.000634920634920633*G0_1_1_2_0_0 - 0.000952380952380945*G0_1_1_2_0_1 + 0.0042328042328042*G0_1_1_2_0_2 + 0.0021164021164021*G0_1_1_2_0_3 + 0.00423280423280421*G0_1_1_2_0_4 + 0.000846560846560844*G0_1_1_2_0_5 - 0.000952380952380945*G0_1_1_2_1_0 + 0.000634920634920632*G0_1_1_2_1_1 + 0.0042328042328042*G0_1_1_2_1_2 + 0.00423280423280421*G0_1_1_2_1_3 + 0.0021164021164021*G0_1_1_2_1_4 + 0.000846560846560844*G0_1_1_2_1_5 + 0.0042328042328042*G0_1_1_2_2_0 + 0.0042328042328042*G0_1_1_2_2_1 - 0.0539682539682537*G0_1_1_2_2_2 - 0.0190476190476189*G0_1_1_2_2_3 - 0.0190476190476189*G0_1_1_2_2_4 - 0.00211640211640212*G0_1_1_2_2_5 + 0.0021164021164021*G0_1_1_2_3_0 + 0.00423280423280421*G0_1_1_2_3_1 - 0.0190476190476189*G0_1_1_2_3_2 - 0.0169312169312168*G0_1_1_2_3_3 - 0.00846560846560842*G0_1_1_2_3_4 + 0.00423280423280421*G0_1_1_2_4_0 + 0.0021164021164021*G0_1_1_2_4_1 - 0.0190476190476189*G0_1_1_2_4_2 - 0.00846560846560842*G0_1_1_2_4_3 - 0.0169312169312168*G0_1_1_2_4_4 + 0.000846560846560844*G0_1_1_2_5_0 + 0.000846560846560843*G0_1_1_2_5_1 - 0.00211640211640212*G0_1_1_2_5_2 + 0.00677248677248673*G0_1_1_2_5_5 - 0.00126984126984126*G0_1_1_3_0_0 + 0.00042328042328042*G0_1_1_3_0_1 + 0.0021164021164021*G0_1_1_3_0_2 + 0.00253968253968252*G0_1_1_3_0_3 + 0.00169312169312168*G0_1_1_3_0_4 + 0.00084656084656084*G0_1_1_3_0_5 + 0.00042328042328042*G0_1_1_3_1_0 - 0.00634920634920631*G0_1_1_3_1_1 + 0.00423280423280421*G0_1_1_3_1_2 + 0.00253968253968252*G0_1_1_3_1_3 + 0.00169312169312168*G0_1_1_3_1_4 - 0.00253968253968252*G0_1_1_3_1_5 + 0.0021164021164021*G0_1_1_3_2_0 + 0.00423280423280421*G0_1_1_3_2_1 - 0.0190476190476189*G0_1_1_3_2_2 - 0.0169312169312168*G0_1_1_3_2_3 - 0.00846560846560842*G0_1_1_3_2_4 + 0.00253968253968252*G0_1_1_3_3_0 + 0.00253968253968253*G0_1_1_3_3_1 - 0.0169312169312168*G0_1_1_3_3_2 - 0.0253968253968253*G0_1_1_3_3_3 - 0.00846560846560842*G0_1_1_3_3_4 - 0.00507936507936506*G0_1_1_3_3_5 + 0.00169312169312168*G0_1_1_3_4_0 + 0.00169312169312168*G0_1_1_3_4_1 - 0.00846560846560842*G0_1_1_3_4_2 - 0.00846560846560842*G0_1_1_3_4_3 - 0.00846560846560842*G0_1_1_3_4_4 - 0.00338624338624337*G0_1_1_3_4_5 + 0.00084656084656084*G0_1_1_3_5_0 - 0.00253968253968252*G0_1_1_3_5_1 - 0.00507936507936506*G0_1_1_3_5_3 - 0.00338624338624337*G0_1_1_3_5_4 - 0.0152380952380951*G0_1_1_3_5_5 - 0.00634920634920631*G0_1_1_4_0_0 + 0.000423280423280421*G0_1_1_4_0_1 + 0.00423280423280421*G0_1_1_4_0_2 + 0.00169312169312168*G0_1_1_4_0_3 + 0.00253968253968253*G0_1_1_4_0_4 - 0.00253968253968252*G0_1_1_4_0_5 + 0.000423280423280421*G0_1_1_4_1_0 - 0.00126984126984126*G0_1_1_4_1_1 + 0.0021164021164021*G0_1_1_4_1_2 + 0.00169312169312168*G0_1_1_4_1_3 + 0.00253968253968253*G0_1_1_4_1_4 + 0.000846560846560842*G0_1_1_4_1_5 + 0.00423280423280421*G0_1_1_4_2_0 + 0.0021164021164021*G0_1_1_4_2_1 - 0.0190476190476189*G0_1_1_4_2_2 - 0.00846560846560842*G0_1_1_4_2_3 - 0.0169312169312168*G0_1_1_4_2_4 + 0.00169312169312168*G0_1_1_4_3_0 + 0.00169312169312168*G0_1_1_4_3_1 - 0.00846560846560842*G0_1_1_4_3_2 - 0.00846560846560842*G0_1_1_4_3_3 - 0.00846560846560842*G0_1_1_4_3_4 - 0.00338624338624337*G0_1_1_4_3_5 + 0.00253968253968253*G0_1_1_4_4_0 + 0.00253968253968253*G0_1_1_4_4_1 - 0.0169312169312168*G0_1_1_4_4_2 - 0.00846560846560843*G0_1_1_4_4_3 - 0.0253968253968253*G0_1_1_4_4_4 - 0.00507936507936506*G0_1_1_4_4_5 - 0.00253968253968252*G0_1_1_4_5_0 + 0.000846560846560842*G0_1_1_4_5_1 - 0.00338624338624337*G0_1_1_4_5_3 - 0.00507936507936506*G0_1_1_4_5_4 - 0.0152380952380951*G0_1_1_4_5_5 - 0.0105820105820105*G0_1_1_5_0_0 + 0.00465608465608463*G0_1_1_5_0_1 + 0.000846560846560844*G0_1_1_5_0_2 + 0.00084656084656084*G0_1_1_5_0_3 - 0.00253968253968252*G0_1_1_5_0_4 - 0.00592592592592589*G0_1_1_5_0_5 + 0.00465608465608463*G0_1_1_5_1_0 - 0.0105820105820105*G0_1_1_5_1_1 + 0.000846560846560844*G0_1_1_5_1_2 - 0.00253968253968252*G0_1_1_5_1_3 + 0.000846560846560842*G0_1_1_5_1_4 - 0.0059259259259259*G0_1_1_5_1_5 + 0.000846560846560844*G0_1_1_5_2_0 + 0.000846560846560844*G0_1_1_5_2_1 - 0.00211640211640212*G0_1_1_5_2_2 + 0.00677248677248673*G0_1_1_5_2_5 + 0.00084656084656084*G0_1_1_5_3_0 - 0.00253968253968252*G0_1_1_5_3_1 - 0.00507936507936506*G0_1_1_5_3_3 - 0.00338624338624337*G0_1_1_5_3_4 - 0.0152380952380951*G0_1_1_5_3_5 - 0.00253968253968252*G0_1_1_5_4_0 + 0.000846560846560842*G0_1_1_5_4_1 - 0.00338624338624337*G0_1_1_5_4_3 - 0.00507936507936506*G0_1_1_5_4_4 - 0.0152380952380951*G0_1_1_5_4_5 - 0.00592592592592589*G0_1_1_5_5_0 - 0.0059259259259259*G0_1_1_5_5_1 + 0.00677248677248673*G0_1_1_5_5_2 - 0.0152380952380951*G0_1_1_5_5_3 - 0.0152380952380951*G0_1_1_5_5_4 - 0.116825396825396*G0_1_1_5_5_5;
    A[32] = -A[20] - 0.019047619047619*G0_0_1_0_0_0 + 0.00148148148148147*G0_0_1_0_0_1 + 0.00253968253968252*G0_0_1_0_0_2 + 0.00126984126984126*G0_0_1_0_0_3 - 0.00211640211640211*G0_0_1_0_0_4 - 0.00634920634920631*G0_0_1_0_0_5 + 0.00148148148148147*G0_0_1_0_1_0 - 0.0021164021164021*G0_0_1_0_1_1 + 0.000740740740740735*G0_0_1_0_1_2 + 0.00126984126984126*G0_0_1_0_1_3 + 0.00253968253968252*G0_0_1_0_1_4 + 0.000846560846560843*G0_0_1_0_1_5 + 0.00253968253968252*G0_0_1_0_2_0 + 0.000740740740740735*G0_0_1_0_2_1 - 0.0063492063492063*G0_0_1_0_2_2 - 0.00296296296296294*G0_0_1_0_2_3 - 0.00550264550264547*G0_0_1_0_2_4 + 0.000423280423280419*G0_0_1_0_2_5 + 0.00126984126984126*G0_0_1_0_3_0 + 0.00126984126984126*G0_0_1_0_3_1 - 0.00296296296296294*G0_0_1_0_3_2 - 0.00761904761904757*G0_0_1_0_3_3 - 0.00761904761904758*G0_0_1_0_3_4 - 0.00338624338624337*G0_0_1_0_3_5 - 0.00211640211640211*G0_0_1_0_4_0 + 0.00253968253968252*G0_0_1_0_4_1 - 0.00550264550264547*G0_0_1_0_4_2 - 0.00761904761904758*G0_0_1_0_4_3 - 0.0194708994708994*G0_0_1_0_4_4 - 0.00592592592592589*G0_0_1_0_4_5 - 0.00634920634920631*G0_0_1_0_5_0 + 0.000846560846560843*G0_0_1_0_5_1 + 0.000423280423280419*G0_0_1_0_5_2 - 0.00338624338624337*G0_0_1_0_5_3 - 0.00592592592592589*G0_0_1_0_5_4 - 0.0110052910052909*G0_0_1_0_5_5 + 0.00148148148148147*G0_0_1_1_0_0 - 0.0021164021164021*G0_0_1_1_0_1 + 0.000740740740740735*G0_0_1_1_0_2 + 0.00126984126984126*G0_0_1_1_0_3 + 0.00253968253968252*G0_0_1_1_0_4 + 0.000846560846560843*G0_0_1_1_0_5 - 0.0021164021164021*G0_0_1_1_1_0 + 0.0158730158730158*G0_0_1_1_1_1 + 0.00634920634920631*G0_0_1_1_1_3 + 0.00211640211640211*G0_0_1_1_1_4 + 0.00634920634920631*G0_0_1_1_1_5 + 0.000740740740740735*G0_0_1_1_2_0 - 0.00529100529100525*G0_0_1_1_2_2 - 0.00507936507936505*G0_0_1_1_2_3 - 0.00338624338624336*G0_0_1_1_2_4 - 0.00126984126984126*G0_0_1_1_2_5 + 0.00126984126984126*G0_0_1_1_3_0 + 0.00634920634920631*G0_0_1_1_3_1 - 0.00507936507936505*G0_0_1_1_3_2 - 0.00846560846560842*G0_0_1_1_3_3 - 0.00677248677248674*G0_0_1_1_3_4 + 0.00253968253968252*G0_0_1_1_4_0 + 0.00211640211640211*G0_0_1_1_4_1 - 0.00338624338624336*G0_0_1_1_4_2 - 0.00677248677248674*G0_0_1_1_4_3 - 0.0118518518518518*G0_0_1_1_4_4 - 0.00169312169312169*G0_0_1_1_4_5 + 0.000846560846560843*G0_0_1_1_5_0 + 0.00634920634920631*G0_0_1_1_5_1 - 0.00126984126984126*G0_0_1_1_5_2 - 0.00169312169312169*G0_0_1_1_5_4 + 0.00846560846560841*G0_0_1_1_5_5 + 0.00253968253968252*G0_0_1_2_0_0 + 0.000740740740740735*G0_0_1_2_0_1 - 0.0063492063492063*G0_0_1_2_0_2 - 0.00296296296296294*G0_0_1_2_0_3 - 0.00550264550264547*G0_0_1_2_0_4 + 0.000423280423280419*G0_0_1_2_0_5 + 0.000740740740740735*G0_0_1_2_1_0 - 0.00529100529100525*G0_0_1_2_1_2 - 0.00507936507936505*G0_0_1_2_1_3 - 0.00338624338624336*G0_0_1_2_1_4 - 0.00126984126984126*G0_0_1_2_1_5 - 0.0063492063492063*G0_0_1_2_2_0 - 0.00529100529100525*G0_0_1_2_2_1 + 0.0634920634920631*G0_0_1_2_2_2 + 0.0232804232804231*G0_0_1_2_2_3 + 0.0275132275132273*G0_0_1_2_2_4 + 0.00211640211640212*G0_0_1_2_2_5 - 0.00296296296296294*G0_0_1_2_3_0 - 0.00507936507936505*G0_0_1_2_3_1 + 0.0232804232804231*G0_0_1_2_3_2 + 0.021164021164021*G0_0_1_2_3_3 + 0.0126984126984126*G0_0_1_2_3_4 + 0.00169312169312169*G0_0_1_2_3_5 - 0.00550264550264547*G0_0_1_2_4_0 - 0.00338624338624336*G0_0_1_2_4_1 + 0.0275132275132273*G0_0_1_2_4_2 + 0.0126984126984126*G0_0_1_2_4_3 + 0.0296296296296295*G0_0_1_2_4_4 + 0.00253968253968253*G0_0_1_2_4_5 + 0.000423280423280419*G0_0_1_2_5_0 - 0.00126984126984126*G0_0_1_2_5_1 + 0.00211640211640212*G0_0_1_2_5_2 + 0.00169312169312169*G0_0_1_2_5_3 + 0.00253968253968253*G0_0_1_2_5_4 + 0.000846560846560842*G0_0_1_2_5_5 + 0.00126984126984126*G0_0_1_3_0_0 + 0.00126984126984126*G0_0_1_3_0_1 - 0.00296296296296294*G0_0_1_3_0_2 - 0.00761904761904757*G0_0_1_3_0_3 - 0.00761904761904758*G0_0_1_3_0_4 - 0.00338624338624337*G0_0_1_3_0_5 + 0.00126984126984126*G0_0_1_3_1_0 + 0.00634920634920631*G0_0_1_3_1_1 - 0.00507936507936505*G0_0_1_3_1_2 - 0.00846560846560842*G0_0_1_3_1_3 - 0.00677248677248674*G0_0_1_3_1_4 - 0.00296296296296294*G0_0_1_3_2_0 - 0.00507936507936505*G0_0_1_3_2_1 + 0.0232804232804231*G0_0_1_3_2_2 + 0.021164021164021*G0_0_1_3_2_3 + 0.0126984126984126*G0_0_1_3_2_4 + 0.00169312169312169*G0_0_1_3_2_5 - 0.00761904761904757*G0_0_1_3_3_0 - 0.00846560846560842*G0_0_1_3_3_1 + 0.021164021164021*G0_0_1_3_3_2 + 0.0558730158730156*G0_0_1_3_3_3 + 0.0287830687830686*G0_0_1_3_3_4 + 0.0118518518518518*G0_0_1_3_3_5 - 0.00761904761904758*G0_0_1_3_4_0 - 0.00677248677248674*G0_0_1_3_4_1 + 0.0126984126984126*G0_0_1_3_4_2 + 0.0287830687830686*G0_0_1_3_4_3 + 0.0389417989417988*G0_0_1_3_4_4 + 0.0101587301587301*G0_0_1_3_4_5 - 0.00338624338624337*G0_0_1_3_5_0 + 0.00169312169312169*G0_0_1_3_5_2 + 0.0118518518518518*G0_0_1_3_5_3 + 0.0101587301587301*G0_0_1_3_5_4 + 0.00507936507936506*G0_0_1_3_5_5 - 0.00211640211640211*G0_0_1_4_0_0 + 0.00253968253968252*G0_0_1_4_0_1 - 0.00550264550264547*G0_0_1_4_0_2 - 0.00761904761904758*G0_0_1_4_0_3 - 0.0194708994708994*G0_0_1_4_0_4 - 0.00592592592592589*G0_0_1_4_0_5 + 0.00253968253968252*G0_0_1_4_1_0 + 0.00211640211640211*G0_0_1_4_1_1 - 0.00338624338624336*G0_0_1_4_1_2 - 0.00677248677248674*G0_0_1_4_1_3 - 0.0118518518518518*G0_0_1_4_1_4 - 0.00169312169312169*G0_0_1_4_1_5 - 0.00550264550264547*G0_0_1_4_2_0 - 0.00338624338624336*G0_0_1_4_2_1 + 0.0275132275132273*G0_0_1_4_2_2 + 0.0126984126984126*G0_0_1_4_2_3 + 0.0296296296296295*G0_0_1_4_2_4 + 0.00253968253968254*G0_0_1_4_2_5 - 0.00761904761904758*G0_0_1_4_3_0 - 0.00677248677248674*G0_0_1_4_3_1 + 0.0126984126984126*G0_0_1_4_3_2 + 0.0287830687830686*G0_0_1_4_3_3 + 0.0389417989417988*G0_0_1_4_3_4 + 0.0101587301587301*G0_0_1_4_3_5 - 0.0194708994708994*G0_0_1_4_4_0 - 0.0118518518518518*G0_0_1_4_4_1 + 0.0296296296296295*G0_0_1_4_4_2 + 0.0389417989417988*G0_0_1_4_4_3 + 0.147301587301587*G0_0_1_4_4_4 + 0.0186243386243386*G0_0_1_4_4_5 - 0.00592592592592589*G0_0_1_4_5_0 - 0.00169312169312169*G0_0_1_4_5_1 + 0.00253968253968254*G0_0_1_4_5_2 + 0.0101587301587301*G0_0_1_4_5_3 + 0.0186243386243386*G0_0_1_4_5_4 + 0.0016931216931217*G0_0_1_4_5_5 - 0.00634920634920631*G0_0_1_5_0_0 + 0.000846560846560842*G0_0_1_5_0_1 + 0.000423280423280419*G0_0_1_5_0_2 - 0.00338624338624337*G0_0_1_5_0_3 - 0.00592592592592589*G0_0_1_5_0_4 - 0.0110052910052909*G0_0_1_5_0_5 + 0.000846560846560843*G0_0_1_5_1_0 + 0.00634920634920631*G0_0_1_5_1_1 - 0.00126984126984126*G0_0_1_5_1_2 - 0.00169312169312169*G0_0_1_5_1_4 + 0.00846560846560841*G0_0_1_5_1_5 + 0.000423280423280419*G0_0_1_5_2_0 - 0.00126984126984126*G0_0_1_5_2_1 + 0.00211640211640212*G0_0_1_5_2_2 + 0.00169312169312169*G0_0_1_5_2_3 + 0.00253968253968254*G0_0_1_5_2_4 + 0.000846560846560841*G0_0_1_5_2_5 - 0.00338624338624337*G0_0_1_5_3_0 + 0.00169312169312169*G0_0_1_5_3_2 + 0.0118518518518518*G0_0_1_5_3_3 + 0.0101587301587301*G0_0_1_5_3_4 + 0.00507936507936506*G0_0_1_5_3_5 - 0.00592592592592589*G0_0_1_5_4_0 - 0.00169312169312169*G0_0_1_5_4_1 + 0.00253968253968253*G0_0_1_5_4_2 + 0.0101587301587301*G0_0_1_5_4_3 + 0.0186243386243386*G0_0_1_5_4_4 + 0.0016931216931217*G0_0_1_5_4_5 - 0.0110052910052909*G0_0_1_5_5_0 + 0.00846560846560841*G0_0_1_5_5_1 + 0.000846560846560841*G0_0_1_5_5_2 + 0.00507936507936506*G0_0_1_5_5_3 + 0.0016931216931217*G0_0_1_5_5_4 - 0.00507936507936499*G0_0_1_5_5_5;
    A[17] = A[32] + 0.0174603174603174*G0_0_1_0_0_0 - 0.00179894179894179*G0_0_1_0_0_1 - 0.00126984126984126*G0_0_1_0_0_2 + 0.000423280423280422*G0_0_1_0_0_3 + 0.00423280423280421*G0_0_1_0_0_4 + 0.00634920634920632*G0_0_1_0_0_5 - 0.00179894179894179*G0_0_1_0_1_0 + 0.00179894179894179*G0_0_1_0_1_1 + 0.00063492063492063*G0_0_1_0_1_3 - 0.000634920634920632*G0_0_1_0_1_4 - 0.00126984126984126*G0_0_1_0_2_0 + 0.000529100529100527*G0_0_1_0_2_2 - 0.00021164021164021*G0_0_1_0_2_3 + 0.000211640211640211*G0_0_1_0_2_4 - 0.000846560846560841*G0_0_1_0_2_5 + 0.000423280423280422*G0_0_1_0_3_0 + 0.00063492063492063*G0_0_1_0_3_1 - 0.00021164021164021*G0_0_1_0_3_2 - 0.0021164021164021*G0_0_1_0_3_3 + 0.000423280423280422*G0_0_1_0_3_4 + 0.000846560846560841*G0_0_1_0_3_5 + 0.00423280423280421*G0_0_1_0_4_0 - 0.000634920634920632*G0_0_1_0_4_1 + 0.000211640211640211*G0_0_1_0_4_2 + 0.000423280423280422*G0_0_1_0_4_3 + 0.00550264550264548*G0_0_1_0_4_4 + 0.00296296296296295*G0_0_1_0_4_5 + 0.00634920634920632*G0_0_1_0_5_0 - 0.000846560846560841*G0_0_1_0_5_2 + 0.000846560846560841*G0_0_1_0_5_3 + 0.00296296296296295*G0_0_1_0_5_4 + 0.00973544973544967*G0_0_1_0_5_5 - 0.00179894179894179*G0_0_1_1_0_0 + 0.00179894179894179*G0_0_1_1_0_1 + 0.00063492063492063*G0_0_1_1_0_3 - 0.000634920634920632*G0_0_1_1_0_4 + 0.00179894179894179*G0_0_1_1_1_0 - 0.0174603174603174*G0_0_1_1_1_1 + 0.00126984126984126*G0_0_1_1_1_2 - 0.0042328042328042*G0_0_1_1_1_3 - 0.000423280423280421*G0_0_1_1_1_4 - 0.00634920634920631*G0_0_1_1_1_5 + 0.00126984126984126*G0_0_1_1_2_1 - 0.000529100529100526*G0_0_1_1_2_2 - 0.00021164021164021*G0_0_1_1_2_3 + 0.000211640211640211*G0_0_1_1_2_4 + 0.000846560846560841*G0_0_1_1_2_5 + 0.00063492063492063*G0_0_1_1_3_0 - 0.0042328042328042*G0_0_1_1_3_1 - 0.00021164021164021*G0_0_1_1_3_2 - 0.00550264550264547*G0_0_1_1_3_3 - 0.000423280423280421*G0_0_1_1_3_4 - 0.00296296296296294*G0_0_1_1_3_5 - 0.000634920634920632*G0_0_1_1_4_0 - 0.000423280423280421*G0_0_1_1_4_1 + 0.000211640211640211*G0_0_1_1_4_2 - 0.000423280423280421*G0_0_1_1_4_3 + 0.00211640211640211*G0_0_1_1_4_4 - 0.00084656084656084*G0_0_1_1_4_5 - 0.00634920634920631*G0_0_1_1_5_1 + 0.000846560846560841*G0_0_1_1_5_2 - 0.00296296296296294*G0_0_1_1_5_3 - 0.00084656084656084*G0_0_1_1_5_4 - 0.00973544973544967*G0_0_1_1_5_5 - 0.00126984126984126*G0_0_1_2_0_0 + 0.000529100529100527*G0_0_1_2_0_2 - 0.00021164021164021*G0_0_1_2_0_3 + 0.000211640211640211*G0_0_1_2_0_4 - 0.000846560846560841*G0_0_1_2_0_5 + 0.00126984126984126*G0_0_1_2_1_1 - 0.000529100529100526*G0_0_1_2_1_2 - 0.00021164021164021*G0_0_1_2_1_3 + 0.000211640211640211*G0_0_1_2_1_4 + 0.000846560846560841*G0_0_1_2_1_5 + 0.000529100529100527*G0_0_1_2_2_0 - 0.000529100529100526*G0_0_1_2_2_1 + 0.0021164021164021*G0_0_1_2_2_3 - 0.00211640211640211*G0_0_1_2_2_4 - 0.00021164021164021*G0_0_1_2_3_0 - 0.00021164021164021*G0_0_1_2_3_1 + 0.0021164021164021*G0_0_1_2_3_2 + 0.00423280423280421*G0_0_1_2_3_3 + 0.000423280423280422*G0_0_1_2_3_5 + 0.000211640211640211*G0_0_1_2_4_0 + 0.000211640211640211*G0_0_1_2_4_1 - 0.00211640211640211*G0_0_1_2_4_2 - 0.00423280423280422*G0_0_1_2_4_4 - 0.000423280423280422*G0_0_1_2_4_5 - 0.000846560846560841*G0_0_1_2_5_0 + 0.000846560846560841*G0_0_1_2_5_1 + 0.000423280423280422*G0_0_1_2_5_3 - 0.000423280423280422*G0_0_1_2_5_4 + 0.000423280423280422*G0_0_1_3_0_0 + 0.00063492063492063*G0_0_1_3_0_1 - 0.00021164021164021*G0_0_1_3_0_2 - 0.0021164021164021*G0_0_1_3_0_3 + 0.000423280423280422*G0_0_1_3_0_4 + 0.000846560846560841*G0_0_1_3_0_5 + 0.00063492063492063*G0_0_1_3_1_0 - 0.0042328042328042*G0_0_1_3_1_1 - 0.00021164021164021*G0_0_1_3_1_2 - 0.00550264550264547*G0_0_1_3_1_3 - 0.000423280423280421*G0_0_1_3_1_4 - 0.00296296296296295*G0_0_1_3_1_5 - 0.00021164021164021*G0_0_1_3_2_0 - 0.00021164021164021*G0_0_1_3_2_1 + 0.0021164021164021*G0_0_1_3_2_2 + 0.00423280423280421*G0_0_1_3_2_3 + 0.000423280423280422*G0_0_1_3_2_5 - 0.0021164021164021*G0_0_1_3_3_0 - 0.00550264550264547*G0_0_1_3_3_1 + 0.00423280423280421*G0_0_1_3_3_2 + 0.0457142857142855*G0_0_1_3_3_3 + 0.00507936507936506*G0_0_1_3_3_4 + 0.00338624338624338*G0_0_1_3_3_5 + 0.000423280423280422*G0_0_1_3_4_0 - 0.000423280423280421*G0_0_1_3_4_1 + 0.00507936507936506*G0_0_1_3_4_3 - 0.00507936507936506*G0_0_1_3_4_4 + 0.000846560846560841*G0_0_1_3_5_0 - 0.00296296296296295*G0_0_1_3_5_1 + 0.000423280423280422*G0_0_1_3_5_2 + 0.00338624338624338*G0_0_1_3_5_3 - 0.00169312169312168*G0_0_1_3_5_5 + 0.00423280423280421*G0_0_1_4_0_0 - 0.000634920634920632*G0_0_1_4_0_1 + 0.000211640211640211*G0_0_1_4_0_2 + 0.000423280423280422*G0_0_1_4_0_3 + 0.00550264550264548*G0_0_1_4_0_4 + 0.00296296296296295*G0_0_1_4_0_5 - 0.000634920634920632*G0_0_1_4_1_0 - 0.000423280423280421*G0_0_1_4_1_1 + 0.000211640211640211*G0_0_1_4_1_2 - 0.000423280423280421*G0_0_1_4_1_3 + 0.00211640211640211*G0_0_1_4_1_4 - 0.00084656084656084*G0_0_1_4_1_5 + 0.000211640211640211*G0_0_1_4_2_0 + 0.000211640211640211*G0_0_1_4_2_1 - 0.00211640211640211*G0_0_1_4_2_2 - 0.00423280423280422*G0_0_1_4_2_4 - 0.000423280423280422*G0_0_1_4_2_5 + 0.000423280423280422*G0_0_1_4_3_0 - 0.000423280423280421*G0_0_1_4_3_1 + 0.00507936507936506*G0_0_1_4_3_3 - 0.00507936507936506*G0_0_1_4_3_4 + 0.00550264550264548*G0_0_1_4_4_0 + 0.00211640211640211*G0_0_1_4_4_1 - 0.00423280423280422*G0_0_1_4_4_2 - 0.00507936507936506*G0_0_1_4_4_3 - 0.0457142857142855*G0_0_1_4_4_4 - 0.00338624338624338*G0_0_1_4_4_5 + 0.00296296296296295*G0_0_1_4_5_0 - 0.00084656084656084*G0_0_1_4_5_1 - 0.000423280423280422*G0_0_1_4_5_2 - 0.00338624338624338*G0_0_1_4_5_4 + 0.00169312169312168*G0_0_1_4_5_5 + 0.00634920634920632*G0_0_1_5_0_0 - 0.000846560846560841*G0_0_1_5_0_2 + 0.000846560846560841*G0_0_1_5_0_3 + 0.00296296296296295*G0_0_1_5_0_4 + 0.00973544973544967*G0_0_1_5_0_5 - 0.00634920634920631*G0_0_1_5_1_1 + 0.000846560846560841*G0_0_1_5_1_2 - 0.00296296296296294*G0_0_1_5_1_3 - 0.00084656084656084*G0_0_1_5_1_4 - 0.00973544973544967*G0_0_1_5_1_5 - 0.000846560846560841*G0_0_1_5_2_0 + 0.000846560846560841*G0_0_1_5_2_1 + 0.000423280423280422*G0_0_1_5_2_3 - 0.000423280423280422*G0_0_1_5_2_4 + 0.000846560846560841*G0_0_1_5_3_0 - 0.00296296296296295*G0_0_1_5_3_1 + 0.000423280423280422*G0_0_1_5_3_2 + 0.00338624338624338*G0_0_1_5_3_3 - 0.00169312169312168*G0_0_1_5_3_5 + 0.00296296296296295*G0_0_1_5_4_0 - 0.00084656084656084*G0_0_1_5_4_1 - 0.000423280423280422*G0_0_1_5_4_2 - 0.00338624338624338*G0_0_1_5_4_4 + 0.00169312169312168*G0_0_1_5_4_5 + 0.00973544973544967*G0_0_1_5_5_0 - 0.00973544973544967*G0_0_1_5_5_1 - 0.00169312169312168*G0_0_1_5_5_3 + 0.00169312169312168*G0_0_1_5_5_4 - 0.0174603174603174*G0_1_0_0_0_0 + 0.00179894179894179*G0_1_0_0_0_1 + 0.00126984126984126*G0_1_0_0_0_2 - 0.000423280423280422*G0_1_0_0_0_3 - 0.00423280423280421*G0_1_0_0_0_4 - 0.00634920634920632*G0_1_0_0_0_5 + 0.00179894179894179*G0_1_0_0_1_0 - 0.00179894179894179*G0_1_0_0_1_1 - 0.00063492063492063*G0_1_0_0_1_3 + 0.000634920634920632*G0_1_0_0_1_4 + 0.00126984126984126*G0_1_0_0_2_0 - 0.000529100529100527*G0_1_0_0_2_2 + 0.00021164021164021*G0_1_0_0_2_3 - 0.000211640211640211*G0_1_0_0_2_4 + 0.000846560846560841*G0_1_0_0_2_5 - 0.000423280423280422*G0_1_0_0_3_0 - 0.00063492063492063*G0_1_0_0_3_1 + 0.00021164021164021*G0_1_0_0_3_2 + 0.0021164021164021*G0_1_0_0_3_3 - 0.000423280423280422*G0_1_0_0_3_4 - 0.000846560846560841*G0_1_0_0_3_5 - 0.00423280423280421*G0_1_0_0_4_0 + 0.000634920634920632*G0_1_0_0_4_1 - 0.000211640211640211*G0_1_0_0_4_2 - 0.000423280423280422*G0_1_0_0_4_3 - 0.00550264550264548*G0_1_0_0_4_4 - 0.00296296296296295*G0_1_0_0_4_5 - 0.00634920634920632*G0_1_0_0_5_0 + 0.000846560846560841*G0_1_0_0_5_2 - 0.000846560846560841*G0_1_0_0_5_3 - 0.00296296296296295*G0_1_0_0_5_4 - 0.00973544973544967*G0_1_0_0_5_5 + 0.00179894179894179*G0_1_0_1_0_0 - 0.00179894179894179*G0_1_0_1_0_1 - 0.00063492063492063*G0_1_0_1_0_3 + 0.000634920634920632*G0_1_0_1_0_4 - 0.00179894179894179*G0_1_0_1_1_0 + 0.0174603174603174*G0_1_0_1_1_1 - 0.00126984126984126*G0_1_0_1_1_2 + 0.0042328042328042*G0_1_0_1_1_3 + 0.000423280423280421*G0_1_0_1_1_4 + 0.00634920634920631*G0_1_0_1_1_5 - 0.00126984126984126*G0_1_0_1_2_1 + 0.000529100529100526*G0_1_0_1_2_2 + 0.00021164021164021*G0_1_0_1_2_3 - 0.000211640211640211*G0_1_0_1_2_4 - 0.000846560846560841*G0_1_0_1_2_5 - 0.00063492063492063*G0_1_0_1_3_0 + 0.0042328042328042*G0_1_0_1_3_1 + 0.00021164021164021*G0_1_0_1_3_2 + 0.00550264550264547*G0_1_0_1_3_3 + 0.000423280423280421*G0_1_0_1_3_4 + 0.00296296296296294*G0_1_0_1_3_5 + 0.000634920634920632*G0_1_0_1_4_0 + 0.000423280423280421*G0_1_0_1_4_1 - 0.000211640211640211*G0_1_0_1_4_2 + 0.000423280423280421*G0_1_0_1_4_3 - 0.00211640211640211*G0_1_0_1_4_4 + 0.00084656084656084*G0_1_0_1_4_5 + 0.00634920634920631*G0_1_0_1_5_1 - 0.000846560846560841*G0_1_0_1_5_2 + 0.00296296296296294*G0_1_0_1_5_3 + 0.00084656084656084*G0_1_0_1_5_4 + 0.00973544973544967*G0_1_0_1_5_5 + 0.00126984126984126*G0_1_0_2_0_0 - 0.000529100529100527*G0_1_0_2_0_2 + 0.00021164021164021*G0_1_0_2_0_3 - 0.000211640211640211*G0_1_0_2_0_4 + 0.000846560846560841*G0_1_0_2_0_5 - 0.00126984126984126*G0_1_0_2_1_1 + 0.000529100529100526*G0_1_0_2_1_2 + 0.00021164021164021*G0_1_0_2_1_3 - 0.000211640211640211*G0_1_0_2_1_4 - 0.000846560846560841*G0_1_0_2_1_5 - 0.000529100529100527*G0_1_0_2_2_0 + 0.000529100529100526*G0_1_0_2_2_1 - 0.0021164021164021*G0_1_0_2_2_3 + 0.00211640211640211*G0_1_0_2_2_4 + 0.00021164021164021*G0_1_0_2_3_0 + 0.00021164021164021*G0_1_0_2_3_1 - 0.0021164021164021*G0_1_0_2_3_2 - 0.00423280423280421*G0_1_0_2_3_3 - 0.000423280423280422*G0_1_0_2_3_5 - 0.000211640211640211*G0_1_0_2_4_0 - 0.000211640211640211*G0_1_0_2_4_1 + 0.00211640211640211*G0_1_0_2_4_2 + 0.00423280423280422*G0_1_0_2_4_4 + 0.000423280423280422*G0_1_0_2_4_5 + 0.000846560846560841*G0_1_0_2_5_0 - 0.000846560846560841*G0_1_0_2_5_1 - 0.000423280423280422*G0_1_0_2_5_3 + 0.000423280423280422*G0_1_0_2_5_4 - 0.000423280423280422*G0_1_0_3_0_0 - 0.00063492063492063*G0_1_0_3_0_1 + 0.00021164021164021*G0_1_0_3_0_2 + 0.0021164021164021*G0_1_0_3_0_3 - 0.000423280423280422*G0_1_0_3_0_4 - 0.000846560846560841*G0_1_0_3_0_5 - 0.00063492063492063*G0_1_0_3_1_0 + 0.0042328042328042*G0_1_0_3_1_1 + 0.00021164021164021*G0_1_0_3_1_2 + 0.00550264550264547*G0_1_0_3_1_3 + 0.000423280423280421*G0_1_0_3_1_4 + 0.00296296296296295*G0_1_0_3_1_5 + 0.00021164021164021*G0_1_0_3_2_0 + 0.00021164021164021*G0_1_0_3_2_1 - 0.0021164021164021*G0_1_0_3_2_2 - 0.00423280423280421*G0_1_0_3_2_3 - 0.000423280423280422*G0_1_0_3_2_5 + 0.0021164021164021*G0_1_0_3_3_0 + 0.00550264550264547*G0_1_0_3_3_1 - 0.00423280423280421*G0_1_0_3_3_2 - 0.0457142857142855*G0_1_0_3_3_3 - 0.00507936507936506*G0_1_0_3_3_4 - 0.00338624338624338*G0_1_0_3_3_5 - 0.000423280423280422*G0_1_0_3_4_0 + 0.000423280423280421*G0_1_0_3_4_1 - 0.00507936507936506*G0_1_0_3_4_3 + 0.00507936507936506*G0_1_0_3_4_4 - 0.000846560846560841*G0_1_0_3_5_0 + 0.00296296296296295*G0_1_0_3_5_1 - 0.000423280423280422*G0_1_0_3_5_2 - 0.00338624338624338*G0_1_0_3_5_3 + 0.00169312169312168*G0_1_0_3_5_5 - 0.00423280423280421*G0_1_0_4_0_0 + 0.000634920634920632*G0_1_0_4_0_1 - 0.000211640211640211*G0_1_0_4_0_2 - 0.000423280423280422*G0_1_0_4_0_3 - 0.00550264550264548*G0_1_0_4_0_4 - 0.00296296296296295*G0_1_0_4_0_5 + 0.000634920634920632*G0_1_0_4_1_0 + 0.000423280423280421*G0_1_0_4_1_1 - 0.000211640211640211*G0_1_0_4_1_2 + 0.000423280423280421*G0_1_0_4_1_3 - 0.00211640211640211*G0_1_0_4_1_4 + 0.00084656084656084*G0_1_0_4_1_5 - 0.000211640211640211*G0_1_0_4_2_0 - 0.000211640211640211*G0_1_0_4_2_1 + 0.00211640211640211*G0_1_0_4_2_2 + 0.00423280423280422*G0_1_0_4_2_4 + 0.000423280423280422*G0_1_0_4_2_5 - 0.000423280423280422*G0_1_0_4_3_0 + 0.000423280423280421*G0_1_0_4_3_1 - 0.00507936507936506*G0_1_0_4_3_3 + 0.00507936507936506*G0_1_0_4_3_4 - 0.00550264550264548*G0_1_0_4_4_0 - 0.00211640211640211*G0_1_0_4_4_1 + 0.00423280423280422*G0_1_0_4_4_2 + 0.00507936507936506*G0_1_0_4_4_3 + 0.0457142857142855*G0_1_0_4_4_4 + 0.00338624338624338*G0_1_0_4_4_5 - 0.00296296296296295*G0_1_0_4_5_0 + 0.00084656084656084*G0_1_0_4_5_1 + 0.000423280423280422*G0_1_0_4_5_2 + 0.00338624338624338*G0_1_0_4_5_4 - 0.00169312169312168*G0_1_0_4_5_5 - 0.00634920634920632*G0_1_0_5_0_0 + 0.000846560846560841*G0_1_0_5_0_2 - 0.000846560846560841*G0_1_0_5_0_3 - 0.00296296296296295*G0_1_0_5_0_4 - 0.00973544973544967*G0_1_0_5_0_5 + 0.00634920634920631*G0_1_0_5_1_1 - 0.000846560846560841*G0_1_0_5_1_2 + 0.00296296296296294*G0_1_0_5_1_3 + 0.00084656084656084*G0_1_0_5_1_4 + 0.00973544973544967*G0_1_0_5_1_5 + 0.000846560846560841*G0_1_0_5_2_0 - 0.000846560846560841*G0_1_0_5_2_1 - 0.000423280423280422*G0_1_0_5_2_3 + 0.000423280423280422*G0_1_0_5_2_4 - 0.000846560846560841*G0_1_0_5_3_0 + 0.00296296296296295*G0_1_0_5_3_1 - 0.000423280423280422*G0_1_0_5_3_2 - 0.00338624338624338*G0_1_0_5_3_3 + 0.00169312169312168*G0_1_0_5_3_5 - 0.00296296296296295*G0_1_0_5_4_0 + 0.00084656084656084*G0_1_0_5_4_1 + 0.000423280423280422*G0_1_0_5_4_2 + 0.00338624338624338*G0_1_0_5_4_4 - 0.00169312169312168*G0_1_0_5_4_5 - 0.00973544973544967*G0_1_0_5_5_0 + 0.00973544973544967*G0_1_0_5_5_1 + 0.00169312169312168*G0_1_0_5_5_3 - 0.00169312169312168*G0_1_0_5_5_4;
    A[15] = -A[17] - 0.019047619047619*G0_1_0_0_0_0 + 0.00148148148148147*G0_1_0_0_0_1 + 0.00253968253968252*G0_1_0_0_0_2 + 0.00126984126984126*G0_1_0_0_0_3 - 0.00211640211640211*G0_1_0_0_0_4 - 0.00634920634920631*G0_1_0_0_0_5 + 0.00148148148148147*G0_1_0_0_1_0 - 0.0021164021164021*G0_1_0_0_1_1 + 0.000740740740740735*G0_1_0_0_1_2 + 0.00126984126984126*G0_1_0_0_1_3 + 0.00253968253968252*G0_1_0_0_1_4 + 0.000846560846560843*G0_1_0_0_1_5 + 0.00253968253968252*G0_1_0_0_2_0 + 0.000740740740740735*G0_1_0_0_2_1 - 0.0063492063492063*G0_1_0_0_2_2 - 0.00296296296296294*G0_1_0_0_2_3 - 0.00550264550264547*G0_1_0_0_2_4 + 0.000423280423280419*G0_1_0_0_2_5 + 0.00126984126984126*G0_1_0_0_3_0 + 0.00126984126984126*G0_1_0_0_3_1 - 0.00296296296296294*G0_1_0_0_3_2 - 0.00761904761904757*G0_1_0_0_3_3 - 0.00761904761904758*G0_1_0_0_3_4 - 0.00338624338624337*G0_1_0_0_3_5 - 0.00211640211640211*G0_1_0_0_4_0 + 0.00253968253968252*G0_1_0_0_4_1 - 0.00550264550264547*G0_1_0_0_4_2 - 0.00761904761904758*G0_1_0_0_4_3 - 0.0194708994708994*G0_1_0_0_4_4 - 0.00592592592592589*G0_1_0_0_4_5 - 0.00634920634920631*G0_1_0_0_5_0 + 0.000846560846560843*G0_1_0_0_5_1 + 0.000423280423280419*G0_1_0_0_5_2 - 0.00338624338624337*G0_1_0_0_5_3 - 0.00592592592592589*G0_1_0_0_5_4 - 0.0110052910052909*G0_1_0_0_5_5 + 0.00148148148148147*G0_1_0_1_0_0 - 0.0021164021164021*G0_1_0_1_0_1 + 0.000740740740740735*G0_1_0_1_0_2 + 0.00126984126984126*G0_1_0_1_0_3 + 0.00253968253968252*G0_1_0_1_0_4 + 0.000846560846560843*G0_1_0_1_0_5 - 0.0021164021164021*G0_1_0_1_1_0 + 0.0158730158730158*G0_1_0_1_1_1 + 0.00634920634920631*G0_1_0_1_1_3 + 0.00211640211640211*G0_1_0_1_1_4 + 0.00634920634920631*G0_1_0_1_1_5 + 0.000740740740740735*G0_1_0_1_2_0 - 0.00529100529100525*G0_1_0_1_2_2 - 0.00507936507936505*G0_1_0_1_2_3 - 0.00338624338624336*G0_1_0_1_2_4 - 0.00126984126984126*G0_1_0_1_2_5 + 0.00126984126984126*G0_1_0_1_3_0 + 0.00634920634920631*G0_1_0_1_3_1 - 0.00507936507936505*G0_1_0_1_3_2 - 0.00846560846560842*G0_1_0_1_3_3 - 0.00677248677248674*G0_1_0_1_3_4 + 0.00253968253968252*G0_1_0_1_4_0 + 0.00211640211640211*G0_1_0_1_4_1 - 0.00338624338624336*G0_1_0_1_4_2 - 0.00677248677248674*G0_1_0_1_4_3 - 0.0118518518518518*G0_1_0_1_4_4 - 0.00169312169312169*G0_1_0_1_4_5 + 0.000846560846560843*G0_1_0_1_5_0 + 0.00634920634920631*G0_1_0_1_5_1 - 0.00126984126984126*G0_1_0_1_5_2 - 0.00169312169312169*G0_1_0_1_5_4 + 0.00846560846560841*G0_1_0_1_5_5 + 0.00253968253968252*G0_1_0_2_0_0 + 0.000740740740740735*G0_1_0_2_0_1 - 0.0063492063492063*G0_1_0_2_0_2 - 0.00296296296296294*G0_1_0_2_0_3 - 0.00550264550264547*G0_1_0_2_0_4 + 0.000423280423280419*G0_1_0_2_0_5 + 0.000740740740740735*G0_1_0_2_1_0 - 0.00529100529100525*G0_1_0_2_1_2 - 0.00507936507936505*G0_1_0_2_1_3 - 0.00338624338624336*G0_1_0_2_1_4 - 0.00126984126984126*G0_1_0_2_1_5 - 0.0063492063492063*G0_1_0_2_2_0 - 0.00529100529100525*G0_1_0_2_2_1 + 0.0634920634920631*G0_1_0_2_2_2 + 0.0232804232804231*G0_1_0_2_2_3 + 0.0275132275132273*G0_1_0_2_2_4 + 0.00211640211640212*G0_1_0_2_2_5 - 0.00296296296296294*G0_1_0_2_3_0 - 0.00507936507936505*G0_1_0_2_3_1 + 0.0232804232804231*G0_1_0_2_3_2 + 0.021164021164021*G0_1_0_2_3_3 + 0.0126984126984126*G0_1_0_2_3_4 + 0.00169312169312169*G0_1_0_2_3_5 - 0.00550264550264547*G0_1_0_2_4_0 - 0.00338624338624336*G0_1_0_2_4_1 + 0.0275132275132273*G0_1_0_2_4_2 + 0.0126984126984126*G0_1_0_2_4_3 + 0.0296296296296295*G0_1_0_2_4_4 + 0.00253968253968254*G0_1_0_2_4_5 + 0.000423280423280419*G0_1_0_2_5_0 - 0.00126984126984126*G0_1_0_2_5_1 + 0.00211640211640212*G0_1_0_2_5_2 + 0.00169312169312169*G0_1_0_2_5_3 + 0.00253968253968254*G0_1_0_2_5_4 + 0.000846560846560841*G0_1_0_2_5_5 + 0.00126984126984126*G0_1_0_3_0_0 + 0.00126984126984126*G0_1_0_3_0_1 - 0.00296296296296294*G0_1_0_3_0_2 - 0.00761904761904757*G0_1_0_3_0_3 - 0.00761904761904758*G0_1_0_3_0_4 - 0.00338624338624337*G0_1_0_3_0_5 + 0.00126984126984126*G0_1_0_3_1_0 + 0.00634920634920631*G0_1_0_3_1_1 - 0.00507936507936505*G0_1_0_3_1_2 - 0.00846560846560842*G0_1_0_3_1_3 - 0.00677248677248674*G0_1_0_3_1_4 - 0.00296296296296294*G0_1_0_3_2_0 - 0.00507936507936505*G0_1_0_3_2_1 + 0.0232804232804231*G0_1_0_3_2_2 + 0.021164021164021*G0_1_0_3_2_3 + 0.0126984126984126*G0_1_0_3_2_4 + 0.00169312169312169*G0_1_0_3_2_5 - 0.00761904761904757*G0_1_0_3_3_0 - 0.00846560846560842*G0_1_0_3_3_1 + 0.021164021164021*G0_1_0_3_3_2 + 0.0558730158730156*G0_1_0_3_3_3 + 0.0287830687830686*G0_1_0_3_3_4 + 0.0118518518518518*G0_1_0_3_3_5 - 0.00761904761904758*G0_1_0_3_4_0 - 0.00677248677248674*G0_1_0_3_4_1 + 0.0126984126984126*G0_1_0_3_4_2 + 0.0287830687830686*G0_1_0_3_4_3 + 0.0389417989417988*G0_1_0_3_4_4 + 0.0101587301587301*G0_1_0_3_4_5 - 0.00338624338624337*G0_1_0_3_5_0 + 0.00169312169312169*G0_1_0_3_5_2 + 0.0118518518518518*G0_1_0_3_5_3 + 0.0101587301587301*G0_1_0_3_5_4 + 0.00507936507936506*G0_1_0_3_5_5 - 0.00211640211640211*G0_1_0_4_0_0 + 0.00253968253968252*G0_1_0_4_0_1 - 0.00550264550264547*G0_1_0_4_0_2 - 0.00761904761904758*G0_1_0_4_0_3 - 0.0194708994708994*G0_1_0_4_0_4 - 0.00592592592592589*G0_1_0_4_0_5 + 0.00253968253968252*G0_1_0_4_1_0 + 0.00211640211640211*G0_1_0_4_1_1 - 0.00338624338624336*G0_1_0_4_1_2 - 0.00677248677248674*G0_1_0_4_1_3 - 0.0118518518518518*G0_1_0_4_1_4 - 0.00169312169312169*G0_1_0_4_1_5 - 0.00550264550264547*G0_1_0_4_2_0 - 0.00338624338624336*G0_1_0_4_2_1 + 0.0275132275132273*G0_1_0_4_2_2 + 0.0126984126984126*G0_1_0_4_2_3 + 0.0296296296296295*G0_1_0_4_2_4 + 0.00253968253968253*G0_1_0_4_2_5 - 0.00761904761904758*G0_1_0_4_3_0 - 0.00677248677248674*G0_1_0_4_3_1 + 0.0126984126984126*G0_1_0_4_3_2 + 0.0287830687830686*G0_1_0_4_3_3 + 0.0389417989417988*G0_1_0_4_3_4 + 0.0101587301587301*G0_1_0_4_3_5 - 0.0194708994708994*G0_1_0_4_4_0 - 0.0118518518518518*G0_1_0_4_4_1 + 0.0296296296296295*G0_1_0_4_4_2 + 0.0389417989417988*G0_1_0_4_4_3 + 0.147301587301587*G0_1_0_4_4_4 + 0.0186243386243386*G0_1_0_4_4_5 - 0.0059259259259259*G0_1_0_4_5_0 - 0.00169312169312169*G0_1_0_4_5_1 + 0.00253968253968254*G0_1_0_4_5_2 + 0.0101587301587301*G0_1_0_4_5_3 + 0.0186243386243386*G0_1_0_4_5_4 + 0.0016931216931217*G0_1_0_4_5_5 - 0.00634920634920631*G0_1_0_5_0_0 + 0.000846560846560842*G0_1_0_5_0_1 + 0.000423280423280419*G0_1_0_5_0_2 - 0.00338624338624337*G0_1_0_5_0_3 - 0.00592592592592589*G0_1_0_5_0_4 - 0.0110052910052909*G0_1_0_5_0_5 + 0.000846560846560843*G0_1_0_5_1_0 + 0.00634920634920631*G0_1_0_5_1_1 - 0.00126984126984126*G0_1_0_5_1_2 - 0.00169312169312169*G0_1_0_5_1_4 + 0.00846560846560841*G0_1_0_5_1_5 + 0.000423280423280419*G0_1_0_5_2_0 - 0.00126984126984126*G0_1_0_5_2_1 + 0.00211640211640212*G0_1_0_5_2_2 + 0.00169312169312169*G0_1_0_5_2_3 + 0.00253968253968254*G0_1_0_5_2_4 + 0.000846560846560841*G0_1_0_5_2_5 - 0.00338624338624337*G0_1_0_5_3_0 + 0.00169312169312169*G0_1_0_5_3_2 + 0.0118518518518518*G0_1_0_5_3_3 + 0.0101587301587301*G0_1_0_5_3_4 + 0.00507936507936506*G0_1_0_5_3_5 - 0.00592592592592589*G0_1_0_5_4_0 - 0.00169312169312169*G0_1_0_5_4_1 + 0.00253968253968253*G0_1_0_5_4_2 + 0.0101587301587301*G0_1_0_5_4_3 + 0.0186243386243386*G0_1_0_5_4_4 + 0.0016931216931217*G0_1_0_5_4_5 - 0.0110052910052909*G0_1_0_5_5_0 + 0.00846560846560841*G0_1_0_5_5_1 + 0.000846560846560841*G0_1_0_5_5_2 + 0.00507936507936506*G0_1_0_5_5_3 + 0.0016931216931217*G0_1_0_5_5_4 - 0.00507936507936499*G0_1_0_5_5_5;
    A[16] = -A[15] - 0.0190476190476189*G0_1_1_0_0_0 + 0.00169312169312168*G0_1_1_0_0_1 + 0.000634920634920633*G0_1_1_0_0_2 - 0.00126984126984126*G0_1_1_0_0_3 - 0.00634920634920631*G0_1_1_0_0_4 - 0.0105820105820105*G0_1_1_0_0_5 + 0.00169312169312168*G0_1_1_0_1_0 + 0.00169312169312168*G0_1_1_0_1_1 - 0.000952380952380945*G0_1_1_0_1_2 + 0.00042328042328042*G0_1_1_0_1_3 + 0.000423280423280421*G0_1_1_0_1_4 + 0.00465608465608463*G0_1_1_0_1_5 + 0.000634920634920633*G0_1_1_0_2_0 - 0.000952380952380945*G0_1_1_0_2_1 + 0.0042328042328042*G0_1_1_0_2_2 + 0.0021164021164021*G0_1_1_0_2_3 + 0.00423280423280421*G0_1_1_0_2_4 + 0.000846560846560844*G0_1_1_0_2_5 - 0.00126984126984126*G0_1_1_0_3_0 + 0.00042328042328042*G0_1_1_0_3_1 + 0.0021164021164021*G0_1_1_0_3_2 + 0.00253968253968252*G0_1_1_0_3_3 + 0.00169312169312168*G0_1_1_0_3_4 + 0.00084656084656084*G0_1_1_0_3_5 - 0.00634920634920631*G0_1_1_0_4_0 + 0.000423280423280421*G0_1_1_0_4_1 + 0.00423280423280421*G0_1_1_0_4_2 + 0.00169312169312168*G0_1_1_0_4_3 + 0.00253968253968253*G0_1_1_0_4_4 - 0.00253968253968252*G0_1_1_0_4_5 - 0.0105820105820105*G0_1_1_0_5_0 + 0.00465608465608463*G0_1_1_0_5_1 + 0.000846560846560844*G0_1_1_0_5_2 + 0.00084656084656084*G0_1_1_0_5_3 - 0.00253968253968252*G0_1_1_0_5_4 - 0.00592592592592589*G0_1_1_0_5_5 + 0.00169312169312168*G0_1_1_1_0_0 + 0.00169312169312168*G0_1_1_1_0_1 - 0.000952380952380945*G0_1_1_1_0_2 + 0.00042328042328042*G0_1_1_1_0_3 + 0.000423280423280421*G0_1_1_1_0_4 + 0.00465608465608463*G0_1_1_1_0_5 + 0.00169312169312168*G0_1_1_1_1_0 - 0.0190476190476189*G0_1_1_1_1_1 + 0.000634920634920632*G0_1_1_1_1_2 - 0.00634920634920631*G0_1_1_1_1_3 - 0.00126984126984126*G0_1_1_1_1_4 - 0.0105820105820105*G0_1_1_1_1_5 - 0.000952380952380945*G0_1_1_1_2_0 + 0.000634920634920632*G0_1_1_1_2_1 + 0.0042328042328042*G0_1_1_1_2_2 + 0.00423280423280421*G0_1_1_1_2_3 + 0.0021164021164021*G0_1_1_1_2_4 + 0.000846560846560843*G0_1_1_1_2_5 + 0.00042328042328042*G0_1_1_1_3_0 - 0.00634920634920631*G0_1_1_1_3_1 + 0.00423280423280421*G0_1_1_1_3_2 + 0.00253968253968252*G0_1_1_1_3_3 + 0.00169312169312168*G0_1_1_1_3_4 - 0.00253968253968252*G0_1_1_1_3_5 + 0.000423280423280421*G0_1_1_1_4_0 - 0.00126984126984126*G0_1_1_1_4_1 + 0.0021164021164021*G0_1_1_1_4_2 + 0.00169312169312168*G0_1_1_1_4_3 + 0.00253968253968253*G0_1_1_1_4_4 + 0.000846560846560842*G0_1_1_1_4_5 + 0.00465608465608463*G0_1_1_1_5_0 - 0.0105820105820105*G0_1_1_1_5_1 + 0.000846560846560843*G0_1_1_1_5_2 - 0.00253968253968252*G0_1_1_1_5_3 + 0.000846560846560842*G0_1_1_1_5_4 - 0.0059259259259259*G0_1_1_1_5_5 + 0.000634920634920633*G0_1_1_2_0_0 - 0.000952380952380945*G0_1_1_2_0_1 + 0.0042328042328042*G0_1_1_2_0_2 + 0.0021164021164021*G0_1_1_2_0_3 + 0.00423280423280421*G0_1_1_2_0_4 + 0.000846560846560844*G0_1_1_2_0_5 - 0.000952380952380945*G0_1_1_2_1_0 + 0.000634920634920632*G0_1_1_2_1_1 + 0.0042328042328042*G0_1_1_2_1_2 + 0.00423280423280421*G0_1_1_2_1_3 + 0.0021164021164021*G0_1_1_2_1_4 + 0.000846560846560844*G0_1_1_2_1_5 + 0.0042328042328042*G0_1_1_2_2_0 + 0.0042328042328042*G0_1_1_2_2_1 - 0.0539682539682537*G0_1_1_2_2_2 - 0.0190476190476189*G0_1_1_2_2_3 - 0.0190476190476189*G0_1_1_2_2_4 - 0.00211640211640212*G0_1_1_2_2_5 + 0.0021164021164021*G0_1_1_2_3_0 + 0.00423280423280421*G0_1_1_2_3_1 - 0.0190476190476189*G0_1_1_2_3_2 - 0.0169312169312168*G0_1_1_2_3_3 - 0.00846560846560842*G0_1_1_2_3_4 + 0.00423280423280421*G0_1_1_2_4_0 + 0.0021164021164021*G0_1_1_2_4_1 - 0.0190476190476189*G0_1_1_2_4_2 - 0.00846560846560842*G0_1_1_2_4_3 - 0.0169312169312168*G0_1_1_2_4_4 + 0.000846560846560844*G0_1_1_2_5_0 + 0.000846560846560844*G0_1_1_2_5_1 - 0.00211640211640212*G0_1_1_2_5_2 + 0.00677248677248673*G0_1_1_2_5_5 - 0.00126984126984126*G0_1_1_3_0_0 + 0.00042328042328042*G0_1_1_3_0_1 + 0.0021164021164021*G0_1_1_3_0_2 + 0.00253968253968252*G0_1_1_3_0_3 + 0.00169312169312168*G0_1_1_3_0_4 + 0.000846560846560839*G0_1_1_3_0_5 + 0.00042328042328042*G0_1_1_3_1_0 - 0.00634920634920631*G0_1_1_3_1_1 + 0.00423280423280421*G0_1_1_3_1_2 + 0.00253968253968252*G0_1_1_3_1_3 + 0.00169312169312168*G0_1_1_3_1_4 - 0.00253968253968252*G0_1_1_3_1_5 + 0.0021164021164021*G0_1_1_3_2_0 + 0.00423280423280421*G0_1_1_3_2_1 - 0.0190476190476189*G0_1_1_3_2_2 - 0.0169312169312168*G0_1_1_3_2_3 - 0.00846560846560842*G0_1_1_3_2_4 + 0.00253968253968252*G0_1_1_3_3_0 + 0.00253968253968252*G0_1_1_3_3_1 - 0.0169312169312168*G0_1_1_3_3_2 - 0.0253968253968252*G0_1_1_3_3_3 - 0.00846560846560842*G0_1_1_3_3_4 - 0.00507936507936506*G0_1_1_3_3_5 + 0.00169312169312168*G0_1_1_3_4_0 + 0.00169312169312168*G0_1_1_3_4_1 - 0.00846560846560842*G0_1_1_3_4_2 - 0.00846560846560842*G0_1_1_3_4_3 - 0.00846560846560842*G0_1_1_3_4_4 - 0.00338624338624337*G0_1_1_3_4_5 + 0.000846560846560839*G0_1_1_3_5_0 - 0.00253968253968252*G0_1_1_3_5_1 - 0.00507936507936505*G0_1_1_3_5_3 - 0.00338624338624337*G0_1_1_3_5_4 - 0.0152380952380951*G0_1_1_3_5_5 - 0.00634920634920631*G0_1_1_4_0_0 + 0.000423280423280421*G0_1_1_4_0_1 + 0.00423280423280421*G0_1_1_4_0_2 + 0.00169312169312168*G0_1_1_4_0_3 + 0.00253968253968253*G0_1_1_4_0_4 - 0.00253968253968252*G0_1_1_4_0_5 + 0.000423280423280421*G0_1_1_4_1_0 - 0.00126984126984126*G0_1_1_4_1_1 + 0.0021164021164021*G0_1_1_4_1_2 + 0.00169312169312168*G0_1_1_4_1_3 + 0.00253968253968253*G0_1_1_4_1_4 + 0.000846560846560842*G0_1_1_4_1_5 + 0.00423280423280421*G0_1_1_4_2_0 + 0.0021164021164021*G0_1_1_4_2_1 - 0.0190476190476189*G0_1_1_4_2_2 - 0.00846560846560842*G0_1_1_4_2_3 - 0.0169312169312168*G0_1_1_4_2_4 + 0.00169312169312168*G0_1_1_4_3_0 + 0.00169312169312168*G0_1_1_4_3_1 - 0.00846560846560842*G0_1_1_4_3_2 - 0.00846560846560842*G0_1_1_4_3_3 - 0.00846560846560842*G0_1_1_4_3_4 - 0.00338624338624337*G0_1_1_4_3_5 + 0.00253968253968253*G0_1_1_4_4_0 + 0.00253968253968253*G0_1_1_4_4_1 - 0.0169312169312168*G0_1_1_4_4_2 - 0.00846560846560842*G0_1_1_4_4_3 - 0.0253968253968253*G0_1_1_4_4_4 - 0.00507936507936506*G0_1_1_4_4_5 - 0.00253968253968252*G0_1_1_4_5_0 + 0.000846560846560842*G0_1_1_4_5_1 - 0.00338624338624337*G0_1_1_4_5_3 - 0.00507936507936506*G0_1_1_4_5_4 - 0.0152380952380951*G0_1_1_4_5_5 - 0.0105820105820105*G0_1_1_5_0_0 + 0.00465608465608463*G0_1_1_5_0_1 + 0.000846560846560844*G0_1_1_5_0_2 + 0.00084656084656084*G0_1_1_5_0_3 - 0.00253968253968252*G0_1_1_5_0_4 - 0.00592592592592589*G0_1_1_5_0_5 + 0.00465608465608463*G0_1_1_5_1_0 - 0.0105820105820105*G0_1_1_5_1_1 + 0.000846560846560844*G0_1_1_5_1_2 - 0.00253968253968252*G0_1_1_5_1_3 + 0.000846560846560842*G0_1_1_5_1_4 - 0.0059259259259259*G0_1_1_5_1_5 + 0.000846560846560844*G0_1_1_5_2_0 + 0.000846560846560844*G0_1_1_5_2_1 - 0.00211640211640212*G0_1_1_5_2_2 + 0.00677248677248673*G0_1_1_5_2_5 + 0.00084656084656084*G0_1_1_5_3_0 - 0.00253968253968252*G0_1_1_5_3_1 - 0.00507936507936506*G0_1_1_5_3_3 - 0.00338624338624337*G0_1_1_5_3_4 - 0.0152380952380951*G0_1_1_5_3_5 - 0.00253968253968253*G0_1_1_5_4_0 + 0.000846560846560842*G0_1_1_5_4_1 - 0.00338624338624337*G0_1_1_5_4_3 - 0.00507936507936506*G0_1_1_5_4_4 - 0.0152380952380951*G0_1_1_5_4_5 - 0.00592592592592589*G0_1_1_5_5_0 - 0.0059259259259259*G0_1_1_5_5_1 + 0.00677248677248673*G0_1_1_5_5_2 - 0.0152380952380951*G0_1_1_5_5_3 - 0.0152380952380951*G0_1_1_5_5_4 - 0.116825396825396*G0_1_1_5_5_5;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class laplacian_f3_p2_q2_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  laplacian_f3_p2_q2_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q2_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 2), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1)))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 3;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f3_p2_q2_tensor_finite_element_0();
        break;
      }
    case 1:
      {
        return new laplacian_f3_p2_q2_tensor_finite_element_0();
        break;
      }
    case 2:
      {
        return new laplacian_f3_p2_q2_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new laplacian_f3_p2_q2_tensor_finite_element_0();
        break;
      }
    case 4:
      {
        return new laplacian_f3_p2_q2_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f3_p2_q2_tensor_dofmap_0();
        break;
      }
    case 1:
      {
        return new laplacian_f3_p2_q2_tensor_dofmap_0();
        break;
      }
    case 2:
      {
        return new laplacian_f3_p2_q2_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new laplacian_f3_p2_q2_tensor_dofmap_0();
        break;
      }
    case 4:
      {
        return new laplacian_f3_p2_q2_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f3_p2_q2_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
