// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __MASS_MATRIX_F2_P3_Q3_TENSOR_H
#define __MASS_MATRIX_F2_P3_Q3_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class mass_matrix_f2_p3_q3_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  mass_matrix_f2_p3_q3_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q3_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, -0.0288675134594813, -0.0166666666666667, 0.0782460796435952, 0.0606091526731326, 0.0349927106111882, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333333, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807677, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, -0.0288675134594813, -0.0166666666666667, 0.0782460796435952, 0.0606091526731326, 0.0349927106111882, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333333, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807677, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new mass_matrix_f2_p3_q3_tensor_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class mass_matrix_f2_p3_q3_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  mass_matrix_f2_p3_q3_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q3_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new mass_matrix_f2_p3_q3_tensor_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class mass_matrix_f2_p3_q3_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  mass_matrix_f2_p3_q3_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q3_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    150
    // Number of operations (multiply-add pairs) for tensor contraction: 3073
    // Total number of operations (multiply-add pairs):                  3232
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[0][0]*w[1][0]*(1.0);
    const double G0_0_1 = det*w[0][0]*w[1][1]*(1.0);
    const double G0_0_2 = det*w[0][0]*w[1][2]*(1.0);
    const double G0_0_3 = det*w[0][0]*w[1][3]*(1.0);
    const double G0_0_4 = det*w[0][0]*w[1][4]*(1.0);
    const double G0_0_5 = det*w[0][0]*w[1][5]*(1.0);
    const double G0_0_6 = det*w[0][0]*w[1][6]*(1.0);
    const double G0_0_7 = det*w[0][0]*w[1][7]*(1.0);
    const double G0_0_8 = det*w[0][0]*w[1][8]*(1.0);
    const double G0_0_9 = det*w[0][0]*w[1][9]*(1.0);
    const double G0_1_0 = det*w[0][1]*w[1][0]*(1.0);
    const double G0_1_1 = det*w[0][1]*w[1][1]*(1.0);
    const double G0_1_2 = det*w[0][1]*w[1][2]*(1.0);
    const double G0_1_3 = det*w[0][1]*w[1][3]*(1.0);
    const double G0_1_4 = det*w[0][1]*w[1][4]*(1.0);
    const double G0_1_5 = det*w[0][1]*w[1][5]*(1.0);
    const double G0_1_6 = det*w[0][1]*w[1][6]*(1.0);
    const double G0_1_7 = det*w[0][1]*w[1][7]*(1.0);
    const double G0_1_8 = det*w[0][1]*w[1][8]*(1.0);
    const double G0_1_9 = det*w[0][1]*w[1][9]*(1.0);
    const double G0_2_0 = det*w[0][2]*w[1][0]*(1.0);
    const double G0_2_1 = det*w[0][2]*w[1][1]*(1.0);
    const double G0_2_2 = det*w[0][2]*w[1][2]*(1.0);
    const double G0_2_3 = det*w[0][2]*w[1][3]*(1.0);
    const double G0_2_4 = det*w[0][2]*w[1][4]*(1.0);
    const double G0_2_5 = det*w[0][2]*w[1][5]*(1.0);
    const double G0_2_6 = det*w[0][2]*w[1][6]*(1.0);
    const double G0_2_7 = det*w[0][2]*w[1][7]*(1.0);
    const double G0_2_8 = det*w[0][2]*w[1][8]*(1.0);
    const double G0_2_9 = det*w[0][2]*w[1][9]*(1.0);
    const double G0_3_0 = det*w[0][3]*w[1][0]*(1.0);
    const double G0_3_1 = det*w[0][3]*w[1][1]*(1.0);
    const double G0_3_2 = det*w[0][3]*w[1][2]*(1.0);
    const double G0_3_3 = det*w[0][3]*w[1][3]*(1.0);
    const double G0_3_4 = det*w[0][3]*w[1][4]*(1.0);
    const double G0_3_5 = det*w[0][3]*w[1][5]*(1.0);
    const double G0_3_6 = det*w[0][3]*w[1][6]*(1.0);
    const double G0_3_7 = det*w[0][3]*w[1][7]*(1.0);
    const double G0_3_8 = det*w[0][3]*w[1][8]*(1.0);
    const double G0_3_9 = det*w[0][3]*w[1][9]*(1.0);
    const double G0_4_0 = det*w[0][4]*w[1][0]*(1.0);
    const double G0_4_1 = det*w[0][4]*w[1][1]*(1.0);
    const double G0_4_2 = det*w[0][4]*w[1][2]*(1.0);
    const double G0_4_3 = det*w[0][4]*w[1][3]*(1.0);
    const double G0_4_4 = det*w[0][4]*w[1][4]*(1.0);
    const double G0_4_5 = det*w[0][4]*w[1][5]*(1.0);
    const double G0_4_6 = det*w[0][4]*w[1][6]*(1.0);
    const double G0_4_7 = det*w[0][4]*w[1][7]*(1.0);
    const double G0_4_8 = det*w[0][4]*w[1][8]*(1.0);
    const double G0_4_9 = det*w[0][4]*w[1][9]*(1.0);
    const double G0_5_0 = det*w[0][5]*w[1][0]*(1.0);
    const double G0_5_1 = det*w[0][5]*w[1][1]*(1.0);
    const double G0_5_2 = det*w[0][5]*w[1][2]*(1.0);
    const double G0_5_3 = det*w[0][5]*w[1][3]*(1.0);
    const double G0_5_4 = det*w[0][5]*w[1][4]*(1.0);
    const double G0_5_5 = det*w[0][5]*w[1][5]*(1.0);
    const double G0_5_6 = det*w[0][5]*w[1][6]*(1.0);
    const double G0_5_7 = det*w[0][5]*w[1][7]*(1.0);
    const double G0_5_8 = det*w[0][5]*w[1][8]*(1.0);
    const double G0_5_9 = det*w[0][5]*w[1][9]*(1.0);
    const double G0_6_0 = det*w[0][6]*w[1][0]*(1.0);
    const double G0_6_1 = det*w[0][6]*w[1][1]*(1.0);
    const double G0_6_2 = det*w[0][6]*w[1][2]*(1.0);
    const double G0_6_3 = det*w[0][6]*w[1][3]*(1.0);
    const double G0_6_4 = det*w[0][6]*w[1][4]*(1.0);
    const double G0_6_5 = det*w[0][6]*w[1][5]*(1.0);
    const double G0_6_6 = det*w[0][6]*w[1][6]*(1.0);
    const double G0_6_7 = det*w[0][6]*w[1][7]*(1.0);
    const double G0_6_8 = det*w[0][6]*w[1][8]*(1.0);
    const double G0_6_9 = det*w[0][6]*w[1][9]*(1.0);
    const double G0_7_0 = det*w[0][7]*w[1][0]*(1.0);
    const double G0_7_1 = det*w[0][7]*w[1][1]*(1.0);
    const double G0_7_2 = det*w[0][7]*w[1][2]*(1.0);
    const double G0_7_3 = det*w[0][7]*w[1][3]*(1.0);
    const double G0_7_4 = det*w[0][7]*w[1][4]*(1.0);
    const double G0_7_5 = det*w[0][7]*w[1][5]*(1.0);
    const double G0_7_6 = det*w[0][7]*w[1][6]*(1.0);
    const double G0_7_7 = det*w[0][7]*w[1][7]*(1.0);
    const double G0_7_8 = det*w[0][7]*w[1][8]*(1.0);
    const double G0_7_9 = det*w[0][7]*w[1][9]*(1.0);
    const double G0_8_0 = det*w[0][8]*w[1][0]*(1.0);
    const double G0_8_1 = det*w[0][8]*w[1][1]*(1.0);
    const double G0_8_2 = det*w[0][8]*w[1][2]*(1.0);
    const double G0_8_3 = det*w[0][8]*w[1][3]*(1.0);
    const double G0_8_4 = det*w[0][8]*w[1][4]*(1.0);
    const double G0_8_5 = det*w[0][8]*w[1][5]*(1.0);
    const double G0_8_6 = det*w[0][8]*w[1][6]*(1.0);
    const double G0_8_7 = det*w[0][8]*w[1][7]*(1.0);
    const double G0_8_8 = det*w[0][8]*w[1][8]*(1.0);
    const double G0_8_9 = det*w[0][8]*w[1][9]*(1.0);
    const double G0_9_0 = det*w[0][9]*w[1][0]*(1.0);
    const double G0_9_1 = det*w[0][9]*w[1][1]*(1.0);
    const double G0_9_2 = det*w[0][9]*w[1][2]*(1.0);
    const double G0_9_3 = det*w[0][9]*w[1][3]*(1.0);
    const double G0_9_4 = det*w[0][9]*w[1][4]*(1.0);
    const double G0_9_5 = det*w[0][9]*w[1][5]*(1.0);
    const double G0_9_6 = det*w[0][9]*w[1][6]*(1.0);
    const double G0_9_7 = det*w[0][9]*w[1][7]*(1.0);
    const double G0_9_8 = det*w[0][9]*w[1][8]*(1.0);
    const double G0_9_9 = det*w[0][9]*w[1][9]*(1.0);
    
    // Compute element tensor
    A[73] = -4.28477772227848e-05*G0_0_0 - 1.81626409305012e-05*G0_0_1 - 1.79619487655232e-05*G0_0_2 - 0.000251366936634836*G0_0_3 + 8.0979288568588e-05*G0_0_4 + 1.68581418581446e-05*G0_0_5 + 4.03391251605606e-05*G0_0_6 + 6.32180319680422e-05*G0_0_7 - 0.000172494915798516*G0_0_8 - 0.000173398030540917*G0_0_9 - 1.81626409305012e-05*G0_1_0 - 0.000214238886113923*G0_1_1 - 3.52214749536238e-05*G0_1_2 - 0.000238121253746295*G0_1_3 + 0.000172795954045984*G0_1_4 - 5.71972670187052e-05*G0_1_5 + 4.03391251605606e-05*G0_1_6 + 5.26816933067023e-05*G0_1_7 - 0.000225477647352686*G0_1_8 - 2.52872127872171e-05*G0_1_9 - 1.79619487655232e-05*G0_2_0 - 3.52214749536238e-05*G0_2_1 - 1.40484515484539e-05*G0_2_2 - 0.000167076227344113*G0_2_3 + 0.000109276883830474*G0_2_4 - 2.01695625802803e-05*G0_2_5 + 4.03391251605606e-05*G0_2_6 + 4.03391251605604e-05*G0_2_7 - 0.000121318413729148*G0_2_8 - 0.000124629834451284*G0_2_9 - 0.000251366936634836*G0_3_0 - 0.000238121253746295*G0_3_1 - 0.000167076227344113*G0_3_2 - 0.00284481143856192*G0_3_3 + 0.0005933463857572*G0_3_4 + 0.000382017536035458*G0_3_5 + 4.0640163408027e-05*G0_3_6 + 0.000915758348794218*G0_3_7 - 0.00144137112887137*G0_3_8 - 0.00175565505922678*G0_3_9 + 8.0979288568588e-05*G0_4_0 + 0.000172795954045983*G0_4_1 + 0.000109276883830474*G0_4_2 + 0.0005933463857572*G0_4_3 - 0.000235712947766559*G0_4_4 - 8.1280326816055e-05*G0_4_5 + 4.06401634080277e-05*G0_4_6 - 0.000262806390038577*G0_4_7 + 0.000525612780077154*G0_4_8 + 0.000536450156985962*G0_4_9 + 1.68581418581446e-05*G0_5_0 - 5.71972670187052e-05*G0_5_1 - 2.01695625802803e-05*G0_5_2 + 0.000382017536035458*G0_5_3 - 8.1280326816055e-05*G0_5_4 - 0.000422657699443485*G0_5_5 + 4.06401634080273e-05*G0_5_6 - 0.000373889503353852*G0_5_7 + 0.000333249339945825*G0_5_8 - 0.000146304588268899*G0_5_9 + 4.03391251605606e-05*G0_6_0 + 4.03391251605606e-05*G0_6_1 + 4.03391251605606e-05*G0_6_2 + 4.06401634080271e-05*G0_6_3 + 4.06401634080277e-05*G0_6_4 + 4.06401634080273e-05*G0_6_5 + 4.0640163408028e-05*G0_6_6 + 4.06401634080277e-05*G0_6_7 + 4.06401634080273e-05*G0_6_8 + 0.000292609176537798*G0_6_9 + 6.32180319680422e-05*G0_7_0 + 5.26816933067022e-05*G0_7_1 + 4.03391251605604e-05*G0_7_2 + 0.000915758348794218*G0_7_3 - 0.000262806390038577*G0_7_4 - 0.000373889503353852*G0_7_5 + 4.06401634080277e-05*G0_7_6 - 0.000650242614528441*G0_7_7 + 0.000885955562294997*G0_7_8 + 0.000438913764806695*G0_7_9 - 0.000172494915798516*G0_8_0 - 0.000225477647352686*G0_8_1 - 0.000121318413729148*G0_8_2 - 0.00144137112887137*G0_8_3 + 0.000525612780077154*G0_8_4 + 0.000333249339945825*G0_8_5 + 4.06401634080273e-05*G0_8_6 + 0.000885955562294997*G0_8_7 - 0.0014793019480522*G0_8_8 - 0.000975363921792657*G0_8_9 - 0.000173398030540917*G0_9_0 - 2.52872127872171e-05*G0_9_1 - 0.000124629834451284*G0_9_2 - 0.00175565505922678*G0_9_3 + 0.000536450156985962*G0_9_4 - 0.000146304588268899*G0_9_5 + 0.000292609176537798*G0_9_6 + 0.000438913764806695*G0_9_7 - 0.000975363921792657*G0_9_8 - 0.00234087341230238*G0_9_9;
    A[37] = A[73];
    A[85] = A[73] - 0.000171391108891137*G0_0_0 + 0.000194169669616131*G0_0_3 - 0.000254979395604438*G0_0_5 + 0.000132456828885422*G0_0_6 - 0.000288695679320727*G0_0_7 + 0.000225176609105218*G0_0_8 + 0.0001481108177537*G0_0_9 + 0.000171391108891138*G0_1_1 + 0.000254979395604439*G0_1_3 - 0.000132456828885423*G0_1_4 - 0.000194169669616131*G0_1_5 - 0.000225176609105218*G0_1_7 + 0.000288695679320727*G0_1_8 - 0.0001481108177537*G0_1_9 + 0.000146906664763833*G0_2_3 - 0.000146906664763832*G0_2_5 - 0.000161657538889709*G0_2_7 + 0.000161657538889709*G0_2_8 + 0.000194169669616131*G0_3_0 + 0.000254979395604439*G0_3_1 + 0.000146906664763833*G0_3_2 + 0.00242215373911844*G0_3_3 - 0.000552706222349173*G0_3_4 - 0.000121920490224082*G0_3_6 - 0.000582509008848393*G0_3_7 + 0.00106748162551752*G0_3_8 + 0.00160935047095788*G0_3_9 - 0.000132456828885423*G0_4_1 - 0.000552706222349172*G0_4_3 + 0.000276353111174586*G0_4_4 + 0.000121920490224082*G0_4_5 + 0.000303446553446604*G0_4_7 - 0.000484972616669127*G0_4_8 - 0.000243840980448165*G0_4_9 - 0.000254979395604438*G0_5_0 - 0.000194169669616131*G0_5_1 - 0.000146906664763832*G0_5_2 + 0.000121920490224082*G0_5_4 - 0.00242215373911843*G0_5_5 + 0.000552706222349172*G0_5_6 - 0.00106748162551752*G0_5_7 + 0.000582509008848391*G0_5_8 - 0.00160935047095788*G0_5_9 + 0.000132456828885422*G0_6_0 - 0.000121920490224082*G0_6_3 + 0.000552706222349172*G0_6_5 - 0.000276353111174587*G0_6_6 + 0.000484972616669126*G0_6_7 - 0.000303446553446604*G0_6_8 + 0.000243840980448164*G0_6_9 - 0.000288695679320727*G0_7_0 - 0.000225176609105218*G0_7_1 - 0.000161657538889709*G0_7_2 - 0.000582509008848393*G0_7_3 + 0.000303446553446604*G0_7_4 - 0.00106748162551752*G0_7_5 + 0.000484972616669126*G0_7_6 - 0.000829059333523755*G0_7_7 - 0.00141427768659935*G0_7_9 + 0.000225176609105218*G0_8_0 + 0.000288695679320727*G0_8_1 + 0.000161657538889709*G0_8_2 + 0.00106748162551752*G0_8_3 - 0.000484972616669127*G0_8_4 + 0.000582509008848391*G0_8_5 - 0.000303446553446604*G0_8_6 + 0.000829059333523757*G0_8_8 + 0.00141427768659935*G0_8_9 + 0.0001481108177537*G0_9_0 - 0.0001481108177537*G0_9_1 + 0.00160935047095788*G0_9_3 - 0.000243840980448165*G0_9_4 - 0.00160935047095788*G0_9_5 + 0.000243840980448164*G0_9_6 - 0.00141427768659935*G0_9_7 + 0.00141427768659935*G0_9_8;
    A[58] = A[85];
    A[67] = A[85] - 0.000120114260739281*G0_0_6 + 0.000120114260739281*G0_0_8 + 0.000130048522905688*G0_1_5 - 0.000130048522905688*G0_2_7 + 0.000463297862851512*G0_3_3 - 0.00034137737262743*G0_3_5 + 0.000121920490224083*G0_3_6 - 0.000292609176537797*G0_3_7 + 0.00041452966676188*G0_3_8 + 0.000438913764806697*G0_3_9 - 0.000463297862851513*G0_4_4 + 0.000292609176537798*G0_4_5 - 0.00041452966676188*G0_4_6 + 0.00034137737262743*G0_4_7 - 0.000121920490224082*G0_4_8 - 0.000438913764806697*G0_4_9 + 0.000130048522905688*G0_5_1 - 0.00034137737262743*G0_5_3 + 0.000292609176537798*G0_5_4 + 0.00136550949050972*G0_5_5 + 0.000292609176537798*G0_5_6 - 0.000390145568717062*G0_5_8 + 0.000780291137434124*G0_5_9 - 0.000120114260739281*G0_6_0 + 0.000121920490224083*G0_6_3 - 0.00041452966676188*G0_6_4 + 0.000292609176537798*G0_6_5 - 0.000414529666761883*G0_6_6 + 0.000390145568717063*G0_6_7 - 0.000130048522905688*G0_7_2 - 0.000292609176537797*G0_7_3 + 0.00034137737262743*G0_7_4 + 0.000390145568717063*G0_7_6 - 0.00136550949050972*G0_7_7 - 0.000292609176537798*G0_7_8 - 0.000780291137434127*G0_7_9 + 0.000120114260739281*G0_8_0 + 0.00041452966676188*G0_8_3 - 0.000121920490224082*G0_8_4 - 0.000390145568717062*G0_8_5 - 0.000292609176537798*G0_8_7 + 0.000414529666761882*G0_8_8 + 0.000438913764806697*G0_9_3 - 0.000438913764806697*G0_9_4 + 0.000780291137434124*G0_9_5 - 0.000780291137434126*G0_9_7;
    A[76] = A[67];
    A[45] = A[73] + 0.000332346225203424*G0_0_3 - 0.000332346225203424*G0_0_4 - 0.000212834040959077*G0_0_6 + 0.000212834040959077*G0_0_8 + 0.000200190434565469*G0_1_1 + 0.000347398137576769*G0_1_3 - 0.000339872181390096*G0_1_4 - 0.000161657538889709*G0_1_6 + 0.000265816772513246*G0_1_8 - 0.000200190434565468*G0_2_2 + 0.000339872181390096*G0_2_3 - 0.000347398137576768*G0_2_4 - 0.000265816772513246*G0_2_6 + 0.000161657538889709*G0_2_8 + 0.000332346225203424*G0_3_0 + 0.000347398137576768*G0_3_1 + 0.000339872181390096*G0_3_2 + 0.00260909849079536*G0_3_3 - 0.000644823926074035*G0_3_5 + 0.000484972616669128*G0_3_6 - 0.000997038675610273*G0_3_7 + 0.0014820112922794*G0_3_8 + 0.00229210521621275*G0_3_9 - 0.000332346225203424*G0_4_0 - 0.000339872181390096*G0_4_1 - 0.000347398137576768*G0_4_2 - 0.00260909849079536*G0_4_4 + 0.000997038675610273*G0_4_5 - 0.0014820112922794*G0_4_6 + 0.000644823926074035*G0_4_7 - 0.000484972616669127*G0_4_8 - 0.00229210521621275*G0_4_9 - 0.000644823926074035*G0_5_3 + 0.000997038675610273*G0_5_4 - 0.000227584915084954*G0_5_5 + 0.000845315398886971*G0_5_6 - 0.000292609176537797*G0_5_8 + 0.000585218353075596*G0_5_9 - 0.000212834040959077*G0_6_0 - 0.000161657538889709*G0_6_1 - 0.000265816772513246*G0_6_2 + 0.000484972616669128*G0_6_3 - 0.0014820112922794*G0_6_4 + 0.000845315398886971*G0_6_5 - 0.00151994211146023*G0_6_6 + 0.000292609176537798*G0_6_7 - 0.00126797309833046*G0_6_9 - 0.000997038675610273*G0_7_3 + 0.000644823926074035*G0_7_4 + 0.000292609176537798*G0_7_6 + 0.000227584915084956*G0_7_7 - 0.00084531539888697*G0_7_8 - 0.000585218353075593*G0_7_9 + 0.000212834040959077*G0_8_0 + 0.000265816772513246*G0_8_1 + 0.000161657538889709*G0_8_2 + 0.0014820112922794*G0_8_3 - 0.000484972616669127*G0_8_4 - 0.000292609176537797*G0_8_5 - 0.00084531539888697*G0_8_7 + 0.00151994211146022*G0_8_8 + 0.00126797309833045*G0_8_9 + 0.00229210521621275*G0_9_3 - 0.00229210521621275*G0_9_4 + 0.000585218353075596*G0_9_5 - 0.00126797309833046*G0_9_6 - 0.000585218353075593*G0_9_7 + 0.00126797309833045*G0_9_8;
    A[75] = A[73] + 0.000471325549450629*G0_0_0 + 0.000268225078492981*G0_0_3 + 0.000446740759240834*G0_0_5 - 0.000265816772513246*G0_0_6 + 0.000400380869130936*G0_0_7 + 0.000223972456115351*G0_0_9 + 0.000271135114885161*G0_1_1 + 0.000180923986727589*G0_1_3 - 0.000192965516626264*G0_1_4 + 0.000429882617382689*G0_1_5 - 0.000161657538889709*G0_1_6 + 0.000286889449835926*G0_1_7 + 0.000323315077779418*G0_1_9 + 0.000146906664763832*G0_2_3 - 0.000166474150849179*G0_2_4 + 0.000359740705722909*G0_2_5 - 0.000212834040959077*G0_2_6 + 0.000332346225203424*G0_2_7 + 0.000422657699443485*G0_2_9 + 0.000268225078492981*G0_3_0 + 0.000180923986727589*G0_3_1 + 0.000146906664763832*G0_3_2 + 0.00322682897459738*G0_3_3 - 0.000674626712573255*G0_3_4 - 0.000804675235478942*G0_3_5 - 0.00128964785214807*G0_3_7 + 0.0017746204688172*G0_3_8 + 0.00160935047095788*G0_3_9 - 0.000192965516626264*G0_4_1 - 0.000166474150849179*G0_4_2 - 0.000674626712573255*G0_4_3 + 0.000617730483802017*G0_4_4 - 0.000292609176537797*G0_4_5 + 0.000292609176537798*G0_4_6 - 0.000159851309404908*G0_4_7 - 0.000484972616669127*G0_4_8 - 0.00068275474525486*G0_4_9 + 0.000446740759240834*G0_5_0 + 0.000429882617382689*G0_5_1 + 0.000359740705722909*G0_5_2 - 0.000804675235478942*G0_5_3 - 0.000292609176537797*G0_5_4 + 0.00474677108605759*G0_5_5 - 0.00151994211146022*G0_5_6 + 0.00325663176109659*G0_5_7 - 0.00177462046881719*G0_5_8 + 0.00287732356928834*G0_5_9 - 0.000265816772513246*G0_6_0 - 0.000161657538889709*G0_6_1 - 0.000212834040959077*G0_6_2 + 0.000292609176537798*G0_6_4 - 0.00151994211146022*G0_6_5 + 0.00084531539888697*G0_6_6 - 0.0014820112922794*G0_6_7 + 0.000484972616669126*G0_6_8 - 0.00126797309833046*G0_6_9 + 0.000400380869130936*G0_7_0 + 0.000286889449835926*G0_7_1 + 0.000332346225203424*G0_7_2 - 0.00128964785214807*G0_7_3 - 0.000159851309404908*G0_7_4 + 0.00325663176109659*G0_7_5 - 0.0014820112922794*G0_7_6 + 0.00497435600114255*G0_7_7 - 0.00236525751034719*G0_7_8 + 0.00229210521621274*G0_7_9 + 0.0017746204688172*G0_8_3 - 0.000484972616669127*G0_8_4 - 0.00177462046881719*G0_8_5 + 0.000484972616669126*G0_8_6 - 0.00236525751034719*G0_8_7 + 0.00236525751034719*G0_8_8 + 0.000223972456115351*G0_9_0 + 0.000323315077779418*G0_9_1 + 0.000422657699443485*G0_9_2 + 0.00160935047095788*G0_9_3 - 0.00068275474525486*G0_9_4 + 0.00287732356928834*G0_9_5 - 0.00126797309833046*G0_9_6 + 0.00229210521621274*G0_9_7 + 0.00702262023690713*G0_9_9;
    A[55] = A[75] + 0.000428477772227846*G0_0_0 + 0.000119411838161858*G0_0_2 + 0.000927197802197961*G0_0_5 - 0.000413024475524546*G0_0_6 + 0.000422055622948551*G0_1_5 + 0.000260097045811375*G0_1_9 + 0.000119411838161858*G0_2_0 + 0.000170688686313715*G0_2_2 + 0.000109878960325407*G0_2_4 + 0.000205910161267339*G0_2_5 - 0.000181526063222522*G0_3_4 - 0.00052019409162275*G0_3_5 - 0.000276353111174586*G0_3_6 - 0.00068275474525486*G0_3_9 + 0.000109878960325407*G0_4_2 - 0.000181526063222522*G0_4_3 + 0.00053374081275876*G0_4_4 - 0.000276353111174586*G0_4_5 + 0.000552706222349173*G0_4_6 + 0.000585218353075595*G0_4_9 + 0.00092719780219796*G0_5_0 + 0.000422055622948551*G0_5_1 + 0.000205910161267339*G0_5_2 - 0.00052019409162275*G0_5_3 - 0.000276353111174586*G0_5_4 + 0.0129723401598423*G0_5_5 - 0.00170688686313715*G0_5_6 + 0.00144137112887137*G0_5_7 - 0.00140344030969054*G0_5_8 + 0.00273101898101944*G0_5_9 - 0.000413024475524546*G0_6_0 - 0.000276353111174586*G0_6_3 + 0.000552706222349173*G0_6_4 - 0.00170688686313715*G0_6_5 + 0.00226772111816793*G0_6_6 + 0.000585218353075595*G0_6_9 + 0.00144137112887137*G0_7_5 - 0.00144137112887137*G0_7_7 - 0.00140344030969054*G0_8_5 - 0.000780291137434126*G0_8_9 + 0.000260097045811375*G0_9_1 - 0.000682754745254859*G0_9_3 + 0.000585218353075595*G0_9_4 + 0.00273101898101944*G0_9_5 + 0.000585218353075595*G0_9_6 - 0.000780291137434125*G0_9_8 + 0.00156058227486825*G0_9_9;
    A[99] = 0.00032030469530475*G0_0_0 - 7.94740973312536e-05*G0_0_1 - 7.94740973312536e-05*G0_0_2 + 0.000585218353075594*G0_0_3 + 0.000585218353075595*G0_0_4 - 0.000910339660339814*G0_0_5 + 0.000487681960896329*G0_0_6 - 0.000910339660339814*G0_0_7 + 0.000487681960896329*G0_0_8 + 0.000390145568717066*G0_0_9 - 7.94740973312536e-05*G0_1_0 + 0.000320304695304749*G0_1_1 - 7.94740973312537e-05*G0_1_2 - 0.000910339660339813*G0_1_3 + 0.000487681960896329*G0_1_4 + 0.000585218353075594*G0_1_5 + 0.000585218353075595*G0_1_6 + 0.000487681960896329*G0_1_7 - 0.000910339660339815*G0_1_8 + 0.000390145568717062*G0_1_9 - 7.94740973312536e-05*G0_2_0 - 7.94740973312537e-05*G0_2_1 + 0.000320304695304749*G0_2_2 + 0.000487681960896329*G0_2_3 - 0.000910339660339814*G0_2_4 + 0.000487681960896329*G0_2_5 - 0.000910339660339814*G0_2_6 + 0.000585218353075595*G0_2_7 + 0.000585218353075594*G0_2_8 + 0.000390145568717063*G0_2_9 + 0.000585218353075594*G0_3_0 - 0.000910339660339813*G0_3_1 + 0.000487681960896329*G0_3_2 + 0.006242329099473*G0_3_3 - 0.00253594619666091*G0_3_4 - 0.00146304588268899*G0_3_5 - 0.00234087341230238*G0_3_6 - 0.00234087341230238*G0_3_7 + 0.00468174682460476*G0_3_8 + 0.00351131011845356*G0_3_9 + 0.000585218353075595*G0_4_0 + 0.000487681960896329*G0_4_1 - 0.000910339660339814*G0_4_2 - 0.00253594619666091*G0_4_3 + 0.00624232909947301*G0_4_4 - 0.00234087341230238*G0_4_5 + 0.00468174682460476*G0_4_6 - 0.00146304588268899*G0_4_7 - 0.00234087341230238*G0_4_8 + 0.00351131011845357*G0_4_9 - 0.000910339660339814*G0_5_0 + 0.000585218353075594*G0_5_1 + 0.000487681960896329*G0_5_2 - 0.00146304588268899*G0_5_3 - 0.00234087341230238*G0_5_4 + 0.006242329099473*G0_5_5 - 0.00253594619666091*G0_5_6 + 0.00468174682460476*G0_5_7 - 0.00234087341230238*G0_5_8 + 0.00351131011845355*G0_5_9 + 0.000487681960896329*G0_6_0 + 0.000585218353075595*G0_6_1 - 0.000910339660339814*G0_6_2 - 0.00234087341230238*G0_6_3 + 0.00468174682460476*G0_6_4 - 0.00253594619666091*G0_6_5 + 0.00624232909947301*G0_6_6 - 0.00234087341230238*G0_6_7 - 0.00146304588268899*G0_6_8 + 0.00351131011845357*G0_6_9 - 0.000910339660339814*G0_7_0 + 0.000487681960896328*G0_7_1 + 0.000585218353075595*G0_7_2 - 0.00234087341230238*G0_7_3 - 0.00146304588268899*G0_7_4 + 0.00468174682460476*G0_7_5 - 0.00234087341230238*G0_7_6 + 0.00624232909947301*G0_7_7 - 0.00253594619666091*G0_7_8 + 0.00351131011845356*G0_7_9 + 0.000487681960896329*G0_8_0 - 0.000910339660339815*G0_8_1 + 0.000585218353075595*G0_8_2 + 0.00468174682460476*G0_8_3 - 0.00234087341230238*G0_8_4 - 0.00234087341230238*G0_8_5 - 0.00146304588268899*G0_8_6 - 0.00253594619666091*G0_8_7 + 0.00624232909947301*G0_8_8 + 0.00351131011845358*G0_8_9 + 0.000390145568717066*G0_9_0 + 0.000390145568717062*G0_9_1 + 0.000390145568717063*G0_9_2 + 0.00351131011845356*G0_9_3 + 0.00351131011845357*G0_9_4 + 0.00351131011845355*G0_9_5 + 0.00351131011845357*G0_9_6 + 0.00351131011845356*G0_9_7 + 0.00351131011845358*G0_9_8 + 0.0842714428428856*G0_9_9;
    A[78] = A[73] - 0.000318899850149903*G0_0_0 - 0.000242335789210829*G0_0_5 + 0.000132456828885422*G0_0_6 - 0.000701720154845272*G0_0_7 - 0.000147508741258766*G0_1_1 - 0.000115297648779811*G0_1_5 - 0.000160152347652374*G0_1_7 - 0.000413024475524546*G0_1_8 - 0.000240228521478562*G0_1_9 - 0.000101148851148868*G0_2_5 - 0.000115297648779811*G0_2_7 + 0.00140344030969055*G0_3_3 + 0.000780291137434126*G0_3_9 + 0.000121920490224082*G0_4_5 - 0.000121920490224082*G0_4_6 - 0.000242335789210829*G0_5_0 - 0.000115297648779811*G0_5_1 - 0.000101148851148868*G0_5_2 + 0.000121920490224082*G0_5_4 - 0.00101871342942788*G0_5_5 + 0.000484972616669126*G0_5_6 - 0.00110541244469834*G0_5_7 + 0.000552706222349172*G0_5_8 - 0.000829059333523757*G0_5_9 + 0.000132456828885422*G0_6_0 - 0.000121920490224082*G0_6_4 + 0.000484972616669126*G0_6_5 - 0.000303446553446605*G0_6_6 + 0.000552706222349172*G0_6_7 - 0.000276353111174586*G0_6_8 + 0.000243840980448163*G0_6_9 - 0.000701720154845272*G0_7_0 - 0.000160152347652374*G0_7_1 - 0.000115297648779811*G0_7_2 - 0.00110541244469834*G0_7_5 + 0.000552706222349172*G0_7_6 - 0.0025359461966609*G0_7_7 + 0.00226772111816793*G0_7_8 - 0.000829059333523757*G0_7_9 - 0.000413024475524546*G0_8_1 + 0.000552706222349172*G0_8_5 - 0.000276353111174586*G0_8_6 + 0.00226772111816793*G0_8_7 - 0.00170688686313715*G0_8_8 + 0.000585218353075594*G0_8_9 - 0.000240228521478562*G0_9_1 + 0.000780291137434126*G0_9_3 - 0.000829059333523757*G0_9_5 + 0.000243840980448163*G0_9_6 - 0.000829059333523757*G0_9_7 + 0.000585218353075594*G0_9_8 - 0.000195072784358532*G0_9_9;
    A[36] = A[85] + 0.000200190434565468*G0_0_0 - 0.000161657538889709*G0_0_4 + 0.000347398137576767*G0_0_5 - 0.000339872181390096*G0_0_6 + 0.000265816772513245*G0_0_7 - 0.000212834040959077*G0_1_4 + 0.000332346225203424*G0_1_5 - 0.000332346225203424*G0_1_6 + 0.000212834040959076*G0_1_7 - 0.000200190434565468*G0_2_2 - 0.000265816772513246*G0_2_4 + 0.000339872181390096*G0_2_5 - 0.000347398137576767*G0_2_6 + 0.000161657538889709*G0_2_7 - 0.000227584915084952*G0_3_3 + 0.00084531539888697*G0_3_4 - 0.000644823926074035*G0_3_5 + 0.000997038675610273*G0_3_6 - 0.000292609176537798*G0_3_7 + 0.000585218353075596*G0_3_9 - 0.000161657538889709*G0_4_0 - 0.000212834040959077*G0_4_1 - 0.000265816772513246*G0_4_2 + 0.000845315398886971*G0_4_3 - 0.00151994211146022*G0_4_4 + 0.000484972616669127*G0_4_5 - 0.0014820112922794*G0_4_6 + 0.000292609176537797*G0_4_8 - 0.00126797309833046*G0_4_9 + 0.000347398137576767*G0_5_0 + 0.000332346225203424*G0_5_1 + 0.000339872181390096*G0_5_2 - 0.000644823926074035*G0_5_3 + 0.000484972616669127*G0_5_4 + 0.00260909849079535*G0_5_5 + 0.0014820112922794*G0_5_7 - 0.00099703867561027*G0_5_8 + 0.00229210521621274*G0_5_9 - 0.000339872181390096*G0_6_0 - 0.000332346225203424*G0_6_1 - 0.000347398137576767*G0_6_2 + 0.000997038675610273*G0_6_3 - 0.0014820112922794*G0_6_4 - 0.00260909849079536*G0_6_6 - 0.000484972616669126*G0_6_7 + 0.000644823926074034*G0_6_8 - 0.00229210521621275*G0_6_9 + 0.000265816772513245*G0_7_0 + 0.000212834040959076*G0_7_1 + 0.000161657538889709*G0_7_2 - 0.000292609176537798*G0_7_3 + 0.0014820112922794*G0_7_5 - 0.000484972616669126*G0_7_6 + 0.00151994211146022*G0_7_7 - 0.00084531539888697*G0_7_8 + 0.00126797309833045*G0_7_9 + 0.000292609176537797*G0_8_4 - 0.00099703867561027*G0_8_5 + 0.000644823926074034*G0_8_6 - 0.00084531539888697*G0_8_7 + 0.000227584915084956*G0_8_8 - 0.000585218353075593*G0_8_9 + 0.000585218353075596*G0_9_3 - 0.00126797309833046*G0_9_4 + 0.00229210521621274*G0_9_5 - 0.00229210521621275*G0_9_6 + 0.00126797309833045*G0_9_7 - 0.000585218353075593*G0_9_8;
    A[86] = A[85] + 0.000301339285714336*G0_0_0 + 0.000410917207792276*G0_0_5 - 0.000263709504780977*G0_0_6 + 0.000398273601398668*G0_0_7 - 0.000143595244041696*G0_0_8 + 0.000332346225203424*G0_1_5 - 0.000214941308691345*G0_1_6 + 0.000281771799628989*G0_1_7 + 0.000195072784358532*G0_1_9 + 0.000276353111174586*G0_2_5 - 0.000121920490224082*G0_2_6 + 0.000202297702297736*G0_2_7 - 0.000174301145283317*G0_2_8 + 0.000146304588268899*G0_2_9 + 0.000292609176537797*G0_3_4 - 0.000463297862851512*G0_3_5 + 0.000463297862851512*G0_3_6 - 0.000292609176537798*G0_3_7 + 0.000292609176537797*G0_4_3 - 0.000414529666761879*G0_4_4 - 0.000463297862851512*G0_4_6 - 0.000121920490224082*G0_4_7 + 0.00034137737262743*G0_4_8 - 0.000438913764806695*G0_4_9 + 0.000410917207792276*G0_5_0 + 0.000332346225203424*G0_5_1 + 0.000276353111174586*G0_5_2 - 0.000463297862851512*G0_5_3 + 0.00343815782431911*G0_5_5 - 0.000829059333523759*G0_5_6 + 0.00196698390894852*G0_5_7 - 0.00117856473883279*G0_5_8 + 0.00229210521621274*G0_5_9 - 0.000263709504780977*G0_6_0 - 0.000214941308691345*G0_6_1 - 0.000121920490224082*G0_6_2 + 0.000463297862851512*G0_6_3 - 0.000463297862851512*G0_6_4 - 0.000829059333523758*G0_6_5 - 0.000707138843299675*G0_6_6 - 0.00078841917011573*G0_6_7 + 0.000674626712573254*G0_6_8 - 0.00136550949050972*G0_6_9 + 0.000398273601398668*G0_7_0 + 0.000281771799628989*G0_7_1 + 0.000202297702297736*G0_7_2 - 0.000292609176537798*G0_7_3 - 0.000121920490224082*G0_7_4 + 0.00196698390894852*G0_7_5 - 0.00078841917011573*G0_7_6 + 0.0020726483338094*G0_7_7 - 0.00112166851006156*G0_7_8 + 0.00151181407877862*G0_7_9 - 0.000143595244041696*G0_8_0 - 0.000174301145283317*G0_8_2 + 0.00034137737262743*G0_8_4 - 0.00117856473883279*G0_8_5 + 0.000674626712573254*G0_8_6 - 0.00112166851006156*G0_8_7 - 0.000292609176537795*G0_8_8 - 0.00126797309833045*G0_8_9 + 0.000195072784358532*G0_9_1 + 0.000146304588268899*G0_9_2 - 0.000438913764806695*G0_9_4 + 0.00229210521621274*G0_9_5 - 0.00136550949050972*G0_9_6 + 0.00151181407877862*G0_9_7 - 0.00126797309833045*G0_9_8 + 0.000877827529613391*G0_9_9;
    A[64] = A[75] - 0.000371581543456605*G0_0_0 - 0.000138176555587293*G0_0_3 + 0.00035582720850584*G0_0_4 - 0.000636093816897495*G0_0_5 + 0.000565048790495314*G0_0_6 - 0.000520796168117684*G0_0_7 + 0.000205308084772405*G0_0_8 + 0.000247453439417767*G0_0_9 - 0.000115297648779811*G0_1_3 + 0.000359740705722909*G0_1_4 - 0.000494003764093133*G0_1_5 + 0.000494003764093133*G0_1_6 - 0.000359740705722909*G0_1_7 + 0.000115297648779811*G0_1_8 + 0.000371581543456606*G0_2_2 - 0.000205308084772405*G0_2_3 + 0.000520796168117684*G0_2_4 - 0.000565048790495314*G0_2_5 + 0.000636093816897495*G0_2_6 - 0.00035582720850584*G0_2_7 + 0.000138176555587293*G0_2_8 - 0.000247453439417767*G0_2_9 - 0.000138176555587293*G0_3_0 - 0.000115297648779811*G0_3_1 - 0.000205308084772405*G0_3_2 + 0.00050393802625954*G0_3_3 - 0.00139802162123614*G0_3_4 + 0.00094827047952064*G0_3_5 - 0.0014820112922794*G0_3_6 + 0.00041452966676188*G0_3_7 - 0.000829059333523759*G0_3_9 + 0.00035582720850584*G0_4_0 + 0.000359740705722909*G0_4_1 + 0.000520796168117684*G0_4_2 - 0.00139802162123614*G0_4_3 + 0.00394209585057866*G0_4_4 - 0.00106748162551752*G0_4_5 + 0.00254949291779692*G0_4_6 - 0.000414529666761879*G0_4_8 + 0.00287732356928834*G0_4_9 - 0.000636093816897495*G0_5_0 - 0.000494003764093133*G0_5_1 - 0.000565048790495314*G0_5_2 + 0.00094827047952064*G0_5_3 - 0.00106748162551752*G0_5_4 - 0.00343815782431911*G0_5_5 - 0.00254949291779692*G0_5_7 + 0.0014820112922794*G0_5_8 - 0.0037063829028121*G0_5_9 + 0.000565048790495314*G0_6_0 + 0.000494003764093133*G0_6_1 + 0.000636093816897495*G0_6_2 - 0.0014820112922794*G0_6_3 + 0.00254949291779692*G0_6_4 + 0.00343815782431912*G0_6_6 + 0.00106748162551752*G0_6_7 - 0.000948270479520638*G0_6_8 + 0.0037063829028121*G0_6_9 - 0.000520796168117684*G0_7_0 - 0.000359740705722909*G0_7_1 - 0.00035582720850584*G0_7_2 + 0.00041452966676188*G0_7_3 - 0.00254949291779692*G0_7_5 + 0.00106748162551752*G0_7_6 - 0.00394209585057865*G0_7_7 + 0.00139802162123614*G0_7_8 - 0.00287732356928834*G0_7_9 + 0.000205308084772405*G0_8_0 + 0.000115297648779811*G0_8_1 + 0.000138176555587293*G0_8_2 - 0.000414529666761879*G0_8_4 + 0.0014820112922794*G0_8_5 - 0.000948270479520638*G0_8_6 + 0.00139802162123614*G0_8_7 - 0.000503938026259539*G0_8_8 + 0.000829059333523758*G0_8_9 + 0.000247453439417767*G0_9_0 - 0.000247453439417767*G0_9_2 - 0.000829059333523759*G0_9_3 + 0.00287732356928834*G0_9_4 - 0.0037063829028121*G0_9_5 + 0.0037063829028121*G0_9_6 - 0.00287732356928834*G0_9_7 + 0.000829059333523758*G0_9_8;
    A[54] = A[45];
    A[35] = A[86] - 0.0001144948801199*G0_0_0 - 0.000113792457542477*G0_0_3 + 0.000101148851148868*G0_0_4 - 0.000185439560439592*G0_0_5 + 0.000200190434565468*G0_0_6 - 0.000155937812187838*G0_0_7 + 0.000166474150849179*G0_1_4 - 0.000214941308691345*G0_1_5 + 0.000214941308691345*G0_1_6 - 0.000166474150849179*G0_1_7 + 0.000114494880119899*G0_2_2 + 0.000155937812187838*G0_2_4 - 0.000200190434565468*G0_2_5 + 0.000185439560439592*G0_2_6 - 0.000101148851148868*G0_2_7 + 0.000113792457542477*G0_2_8 - 0.000113792457542477*G0_3_0 - 0.000568962287712384*G0_3_3 - 0.000568962287712384*G0_3_4 + 0.000493100649350733*G0_3_5 - 0.000644823926074035*G0_3_6 + 0.000341377372627431*G0_3_7 - 0.00068275474525486*G0_3_9 + 0.000101148851148868*G0_4_0 + 0.000166474150849179*G0_4_1 + 0.000155937812187838*G0_4_2 - 0.000568962287712384*G0_4_3 + 0.000967235889111052*G0_4_4 - 0.000303446553446605*G0_4_5 + 0.000948270479520639*G0_4_6 - 0.00034137737262743*G0_4_8 + 0.000682754745254861*G0_4_9 - 0.000185439560439592*G0_5_0 - 0.000214941308691345*G0_5_1 - 0.000200190434565468*G0_5_2 + 0.000493100649350733*G0_5_3 - 0.000303446553446605*G0_5_4 - 0.00153619817682343*G0_5_5 - 0.000948270479520638*G0_5_7 + 0.000644823926074034*G0_5_8 - 0.00136550949050972*G0_5_9 + 0.000200190434565468*G0_6_0 + 0.000214941308691345*G0_6_1 + 0.000185439560439592*G0_6_2 - 0.000644823926074035*G0_6_3 + 0.000948270479520639*G0_6_4 + 0.00153619817682343*G0_6_6 + 0.000303446553446604*G0_6_7 - 0.000493100649350732*G0_6_8 + 0.00136550949050972*G0_6_9 - 0.000155937812187838*G0_7_0 - 0.000166474150849179*G0_7_1 - 0.000101148851148868*G0_7_2 + 0.00034137737262743*G0_7_3 - 0.000948270479520638*G0_7_5 + 0.000303446553446604*G0_7_6 - 0.000967235889111052*G0_7_7 + 0.000568962287712383*G0_7_8 - 0.00068275474525486*G0_7_9 + 0.000113792457542477*G0_8_2 - 0.00034137737262743*G0_8_4 + 0.000644823926074034*G0_8_5 - 0.000493100649350732*G0_8_6 + 0.000568962287712384*G0_8_7 + 0.000568962287712383*G0_8_8 + 0.000682754745254861*G0_8_9 - 0.00068275474525486*G0_9_3 + 0.000682754745254861*G0_9_4 - 0.00136550949050972*G0_9_5 + 0.00136550949050972*G0_9_6 - 0.00068275474525486*G0_9_7 + 0.000682754745254861*G0_9_8;
    A[1] = A[35] + 0.000101409007659025*G0_0_0 + 0.000132746717568169*G0_0_3 - 0.000127071589125182*G0_0_6 + 0.000101409007659025*G0_1_1 - 0.000127071589125182*G0_1_4 + 0.000132746717568168*G0_1_5 - 0.000168324978592864*G0_2_4 - 0.000168324978592864*G0_2_6 + 0.000132746717568169*G0_3_0 + 0.0010004504424149*G0_3_3 + 0.000177512219922964*G0_3_4 - 0.000397270140573779*G0_3_5 + 0.000244844441273054*G0_3_6 - 0.000400180176965959*G0_3_7 + 0.00047604181532761*G0_3_8 + 0.000810595654345791*G0_3_9 - 0.000127071589125182*G0_4_1 - 0.000168324978592864*G0_4_2 + 0.000177512219922964*G0_4_3 - 0.000538256386470764*G0_4_4 + 0.000244844441273054*G0_4_5 - 0.000489688882546108*G0_4_6 - 0.000521799628942575*G0_4_9 + 0.000132746717568168*G0_5_1 - 0.000397270140573779*G0_5_3 + 0.000244844441273054*G0_5_4 + 0.0010004504424149*G0_5_5 + 0.000177512219922964*G0_5_6 + 0.00047604181532761*G0_5_7 - 0.000400180176965958*G0_5_8 + 0.000810595654345791*G0_5_9 - 0.000127071589125182*G0_6_0 - 0.000168324978592864*G0_6_2 + 0.000244844441273054*G0_6_3 - 0.000489688882546108*G0_6_4 + 0.000177512219922964*G0_6_5 - 0.000538256386470764*G0_6_6 - 0.000521799628942575*G0_6_9 - 0.000400180176965959*G0_7_3 + 0.00047604181532761*G0_7_5 + 0.000546685457399836*G0_7_7 - 0.000429581579135223*G0_7_8 + 0.000161958577137176*G0_7_9 + 0.00047604181532761*G0_8_3 - 0.000400180176965958*G0_8_5 - 0.000429581579135223*G0_8_7 + 0.000546685457399836*G0_8_8 + 0.000161958577137176*G0_8_9 + 0.000810595654345791*G0_9_3 - 0.000521799628942575*G0_9_4 + 0.00081059565434579*G0_9_5 - 0.000521799628942575*G0_9_6 + 0.000161958577137176*G0_9_7 + 0.000161958577137176*G0_9_8 + 0.00138357178535773*G0_9_9;
    A[90] = A[1] + 0.000302041708291759*G0_0_9 + 0.000500526259454915*G0_3_3 - 0.000147709433423744*G0_3_4 - 0.000106667885685761*G0_3_6 - 0.000155235389610416*G0_3_7 + 0.000244643749108076*G0_3_8 + 0.000603682032253562*G0_3_9 - 0.000147709433423744*G0_4_3 + 0.000503034911517139*G0_4_4 - 0.000155436081775394*G0_4_5 + 0.000262103967461155*G0_4_6 + 0.000570567825032207*G0_4_9 - 0.000155436081775394*G0_5_4 - 0.000207315006422184*G0_5_6 - 0.000891875981161846*G0_5_9 - 0.000106667885685761*G0_6_3 + 0.000262103967461155*G0_6_4 - 0.000207315006422184*G0_6_5 + 0.000232100488796957*G0_6_6 + 0.000473031432852942*G0_6_9 - 0.000155235389610416*G0_7_3 - 0.000169183495076381*G0_7_8 - 0.000925993649208091*G0_7_9 + 0.000244643749108076*G0_8_3 - 0.000169183495076381*G0_8_7 + 0.00011439453403741*G0_8_8 + 0.000472027972028052*G0_8_9 + 0.000302041708291759*G0_9_0 + 0.000603682032253562*G0_9_3 + 0.000570567825032207*G0_9_4 - 0.000891875981161846*G0_9_5 + 0.000473031432852942*G0_9_6 - 0.000925993649208091*G0_9_7 + 0.000472027972028052*G0_9_8 + 0.000469619666048319*G0_9_9;
    A[11] = A[1] + 0.00147235576923102*G0_1_1 + 0.000641780094905204*G0_1_3 - 0.000302978271728323*G0_1_4 - 0.000295719905094956*G0_1_7 + 0.000620239135864242*G0_1_8 + 0.000641780094905204*G0_3_1 + 0.000799356893107028*G0_3_3 - 0.000303546899529094*G0_3_4 - 0.000196076245183421*G0_3_7 + 0.00037509365634372*G0_3_8 + 0.00015192396888828*G0_3_9 - 0.000302978271728323*G0_4_1 - 0.000303546899529094*G0_4_3 + 0.000172494915798516*G0_4_4 - 0.000179017411160299*G0_4_8 - 0.000295719905094956*G0_7_1 - 0.000196076245183422*G0_7_3 - 0.000265415388183291*G0_7_8 + 0.000620239135864242*G0_8_1 + 0.00037509365634372*G0_8_3 - 0.000179017411160299*G0_8_4 - 0.000265415388183291*G0_8_7 + 0.000684159590409707*G0_8_8 + 0.000117806300842035*G0_8_9 + 0.00015192396888828*G0_9_3 + 0.000117806300842035*G0_9_8 + 0.000399778792636003*G0_9_9;
    A[21] = A[1] + 0.000115197302697322*G0_3_3 + 0.000117705954759546*G0_4_4 - 0.000117705954759546*G0_7_7 - 0.000115197302697323*G0_8_8;
    A[69] = A[21] - 0.000129100809904403*G0_0_3 + 0.000293556889539082*G0_0_4 - 0.000269986709718898*G0_0_5 + 0.000282719512630275*G0_0_6 + 0.000480590837733776*G0_0_9 - 0.000243874429142328*G0_1_3 + 0.000323080936920277*G0_1_4 - 0.000204627961324425*G0_1_5 + 0.000559340213358165*G0_1_6 - 0.000106835129156576*G0_1_7 + 0.000566955366062605*G0_1_9 - 0.000247721028971071*G0_2_5 - 0.000172115830598002*G0_2_7 - 0.000928602647352804*G0_2_9 - 0.000129100809904403*G0_3_0 - 0.000243874429142328*G0_3_1 + 0.000266117810760713*G0_3_3 - 0.00087903168260326*G0_3_4 + 0.000530329045954137*G0_3_5 - 0.00173749241829628*G0_3_6 + 0.000327830651491422*G0_3_7 - 0.000199688704153024*G0_3_8 - 0.00235652740117066*G0_3_9 + 0.000293556889539082*G0_4_0 + 0.000323080936920277*G0_4_1 - 0.00087903168260326*G0_4_3 + 0.00255822302697346*G0_4_4 - 0.000940142446839035*G0_4_5 + 0.00267763486513532*G0_4_6 - 0.000152425699300726*G0_4_7 - 0.000128141947338397*G0_4_8 + 0.00466609283573648*G0_4_9 - 0.000269986709718898*G0_5_0 - 0.000204627961324425*G0_5_1 - 0.000247721028971071*G0_5_2 + 0.000530329045954136*G0_5_3 - 0.000940142446839035*G0_5_4 - 0.0004452355680035*G0_5_5 - 0.00033194484087347*G0_5_6 - 0.0010112878193237*G0_5_7 + 0.000554412105751485*G0_5_8 - 0.0025505967247043*G0_5_9 + 0.000282719512630275*G0_6_0 + 0.000559340213358165*G0_6_1 - 0.00173749241829628*G0_6_3 + 0.00267763486513532*G0_6_4 - 0.00033194484087347*G0_6_5 + 0.00540443931069022*G0_6_6 + 0.000456875713572218*G0_6_7 - 0.000843609515484657*G0_6_8 + 0.00626079277865098*G0_6_9 - 0.000106835129156576*G0_7_1 - 0.000172115830598002*G0_7_2 + 0.000327830651491422*G0_7_3 - 0.000152425699300726*G0_7_4 - 0.0010112878193237*G0_7_5 + 0.000456875713572218*G0_7_6 - 0.00181074505851322*G0_7_7 + 0.000594650884829556*G0_7_8 - 0.00235552394034577*G0_7_9 - 0.000199688704153024*G0_8_3 - 0.000128141947338397*G0_8_4 + 0.000554412105751485*G0_8_5 - 0.000843609515484657*G0_8_6 + 0.000594650884829556*G0_8_7 - 0.000886657984872421*G0_8_8 - 0.00144458220351102*G0_8_9 + 0.000480590837733776*G0_9_0 + 0.000566955366062605*G0_9_1 - 0.000928602647352804*G0_9_2 - 0.00235652740117066*G0_9_3 + 0.00466609283573648*G0_9_4 - 0.0025505967247043*G0_9_5 + 0.00626079277865098*G0_9_6 - 0.00235552394034577*G0_9_7 - 0.00144458220351102*G0_9_8 + 0.00359078421578482*G0_9_9;
    A[89] = A[69] + 0.000422657699443485*G0_0_3 - 0.000422657699443485*G0_0_4 + 0.000240228521478562*G0_0_5 - 0.000290802947052996*G0_0_6 - 0.000240228521478562*G0_0_7 + 0.000290802947052996*G0_0_8 + 0.000102553696303714*G0_1_1 + 0.000223972456115351*G0_1_3 - 0.000323315077779418*G0_1_4 - 0.000536450156985961*G0_1_6 - 0.000140885899814495*G0_1_7 - 0.00149555801341541*G0_1_9 - 0.000102553696303714*G0_2_2 + 0.000323315077779418*G0_2_3 - 0.000223972456115351*G0_2_4 + 0.000140885899814495*G0_2_5 + 0.000536450156985962*G0_2_8 + 0.00149555801341541*G0_2_9 + 0.000422657699443485*G0_3_0 + 0.000223972456115351*G0_3_1 + 0.000323315077779418*G0_3_2 + 0.00229210521621274*G0_3_3 - 0.000682754745254862*G0_3_5 + 0.00160935047095789*G0_3_6 - 0.00126797309833046*G0_3_7 + 0.00287732356928834*G0_3_8 + 0.00702262023690714*G0_3_9 - 0.000422657699443485*G0_4_0 - 0.000323315077779418*G0_4_1 - 0.000223972456115351*G0_4_2 - 0.00229210521621274*G0_4_4 + 0.00126797309833046*G0_4_5 - 0.00287732356928834*G0_4_6 + 0.000682754745254861*G0_4_7 - 0.00160935047095789*G0_4_8 - 0.00702262023690714*G0_4_9 + 0.000240228521478562*G0_5_0 + 0.000140885899814495*G0_5_2 - 0.000682754745254862*G0_5_3 + 0.00126797309833046*G0_5_4 - 0.00136550949050972*G0_5_5 + 0.000926595725703027*G0_5_6 + 0.000195072784358537*G0_5_9 - 0.000290802947052996*G0_6_0 - 0.000536450156985961*G0_6_1 + 0.00160935047095789*G0_6_3 - 0.00287732356928834*G0_6_4 + 0.000926595725703027*G0_6_5 - 0.00629109729556264*G0_6_6 - 0.007705374982162*G0_6_9 - 0.000240228521478562*G0_7_0 - 0.000140885899814495*G0_7_1 - 0.00126797309833046*G0_7_3 + 0.000682754745254861*G0_7_4 + 0.00136550949050972*G0_7_7 - 0.000926595725703025*G0_7_8 - 0.00019507278435853*G0_7_9 + 0.000290802947052996*G0_8_0 + 0.000536450156985962*G0_8_2 + 0.00287732356928834*G0_8_3 - 0.00160935047095789*G0_8_4 - 0.000926595725703025*G0_8_7 + 0.00629109729556265*G0_8_8 + 0.007705374982162*G0_8_9 - 0.00149555801341541*G0_9_1 + 0.00149555801341541*G0_9_2 + 0.00702262023690714*G0_9_3 - 0.00702262023690714*G0_9_4 + 0.000195072784358535*G0_9_5 - 0.007705374982162*G0_9_6 - 0.00019507278435853*G0_9_7 + 0.007705374982162*G0_9_8;
    A[93] = A[89] + 0.000260097045811375*G0_0_3 - 0.000121017375481682*G0_0_6 - 0.000240228521478562*G0_1_4 + 0.000195072784358531*G0_1_5 - 0.000195072784358532*G0_1_6 + 0.000240228521478562*G0_1_7 + 0.000121017375481682*G0_2_5 - 0.000260097045811376*G0_2_8 + 0.000260097045811375*G0_3_0 + 0.00273101898101944*G0_3_3 + 0.000585218353075595*G0_3_4 - 0.00068275474525486*G0_3_5 + 0.000585218353075596*G0_3_6 - 0.000780291137434126*G0_3_7 + 0.00156058227486825*G0_3_9 - 0.000240228521478562*G0_4_1 + 0.000585218353075595*G0_4_3 - 0.000829059333523761*G0_4_4 + 0.000243840980448165*G0_4_5 - 0.00082905933352376*G0_4_6 + 0.000780291137434127*G0_4_8 - 0.000195072784358532*G0_4_9 + 0.000195072784358531*G0_5_1 + 0.000121017375481682*G0_5_2 - 0.00068275474525486*G0_5_3 + 0.000243840980448165*G0_5_4 + 0.000926595725703023*G0_5_5 + 0.000829059333523757*G0_5_7 - 0.000585218353075593*G0_5_8 + 0.000877827529613391*G0_5_9 - 0.000121017375481682*G0_6_0 - 0.000195072784358532*G0_6_1 + 0.000585218353075596*G0_6_3 - 0.00082905933352376*G0_6_4 - 0.000926595725703026*G0_6_6 - 0.000243840980448163*G0_6_7 + 0.000682754745254861*G0_6_8 - 0.000877827529613392*G0_6_9 + 0.000240228521478562*G0_7_1 - 0.000780291137434126*G0_7_3 + 0.000829059333523757*G0_7_5 - 0.000243840980448163*G0_7_6 + 0.000829059333523757*G0_7_7 - 0.000585218353075594*G0_7_8 + 0.000195072784358533*G0_7_9 - 0.000260097045811376*G0_8_2 + 0.000780291137434127*G0_8_4 - 0.000585218353075593*G0_8_5 + 0.000682754745254861*G0_8_6 - 0.000585218353075594*G0_8_7 - 0.00273101898101945*G0_8_8 - 0.00156058227486825*G0_8_9 + 0.00156058227486825*G0_9_3 - 0.000195072784358532*G0_9_4 + 0.000877827529613392*G0_9_5 - 0.000877827529613392*G0_9_6 + 0.000195072784358533*G0_9_7 - 0.00156058227486825*G0_9_8;
    A[94] = A[69] + 0.000260097045811375*G0_0_4 - 0.000121017375481681*G0_0_8 - 0.000260097045811375*G0_1_6 + 0.000121017375481682*G0_1_7 - 0.000240228521478562*G0_2_3 + 0.000240228521478562*G0_2_5 + 0.000195072784358531*G0_2_7 - 0.000195072784358531*G0_2_8 - 0.000240228521478562*G0_3_2 - 0.000829059333523759*G0_3_3 + 0.000585218353075595*G0_3_4 + 0.000780291137434126*G0_3_6 + 0.000243840980448164*G0_3_7 - 0.000829059333523759*G0_3_8 - 0.000195072784358532*G0_3_9 + 0.000260097045811375*G0_4_0 + 0.000585218353075594*G0_4_3 + 0.00273101898101944*G0_4_4 - 0.000780291137434126*G0_4_5 - 0.000682754745254861*G0_4_7 + 0.000585218353075595*G0_4_8 + 0.00156058227486825*G0_4_9 + 0.000240228521478562*G0_5_2 - 0.000780291137434127*G0_5_4 + 0.000829059333523759*G0_5_5 - 0.000585218353075594*G0_5_6 + 0.000829059333523759*G0_5_7 - 0.000243840980448165*G0_5_8 + 0.000195072784358533*G0_5_9 - 0.000260097045811375*G0_6_1 + 0.000780291137434126*G0_6_3 - 0.000585218353075594*G0_6_5 - 0.00273101898101944*G0_6_6 - 0.000585218353075594*G0_6_7 + 0.00068275474525486*G0_6_8 - 0.00156058227486825*G0_6_9 + 0.000121017375481682*G0_7_1 + 0.000195072784358531*G0_7_2 + 0.000243840980448164*G0_7_3 - 0.000682754745254861*G0_7_4 + 0.000829059333523759*G0_7_5 - 0.000585218353075594*G0_7_6 + 0.000926595725703025*G0_7_7 + 0.000877827529613392*G0_7_9 - 0.000121017375481681*G0_8_0 - 0.000195072784358531*G0_8_2 - 0.000829059333523758*G0_8_3 + 0.000585218353075595*G0_8_4 - 0.000243840980448165*G0_8_5 + 0.00068275474525486*G0_8_6 - 0.000926595725703025*G0_8_8 - 0.000877827529613393*G0_8_9 - 0.000195072784358532*G0_9_3 + 0.00156058227486825*G0_9_4 + 0.000195072784358533*G0_9_5 - 0.00156058227486825*G0_9_6 + 0.000877827529613391*G0_9_7 - 0.000877827529613393*G0_9_8;
    A[22] = A[21] + 0.00147235576923102*G0_2_2 - 0.000295719905094955*G0_2_3 + 0.00062023913586424*G0_2_4 - 0.000302978271728323*G0_2_5 + 0.000641780094905202*G0_2_6 - 0.000295719905094955*G0_3_2 - 0.00026541538818329*G0_3_4 - 0.000196076245183421*G0_3_6 + 0.00062023913586424*G0_4_2 - 0.00026541538818329*G0_4_3 + 0.000684159590409705*G0_4_4 - 0.000179017411160298*G0_4_5 + 0.000375093656343719*G0_4_6 + 0.000117806300842035*G0_4_9 - 0.000302978271728323*G0_5_2 - 0.000179017411160298*G0_5_4 + 0.000172494915798516*G0_5_5 - 0.000303546899529094*G0_5_6 + 0.000641780094905202*G0_6_2 - 0.000196076245183421*G0_6_3 + 0.000375093656343719*G0_6_4 - 0.000303546899529094*G0_6_5 + 0.000799356893107028*G0_6_6 + 0.00015192396888828*G0_6_9 + 0.000117806300842035*G0_9_4 + 0.00015192396888828*G0_9_6 + 0.000399778792636003*G0_9_9;
    A[97] = A[89] + 0.000160152347652374*G0_0_0 - 0.000471425895533118*G0_0_3 + 0.000146304588268898*G0_0_4 + 0.000341377372627431*G0_0_7 - 0.000552706222349173*G0_0_8 - 0.00139802162123614*G0_0_9 - 0.000160152347652375*G0_1_1 + 0.000471425895533117*G0_1_5 - 0.000146304588268899*G0_1_6 + 0.000552706222349172*G0_1_7 - 0.000341377372627429*G0_1_8 + 0.00139802162123614*G0_1_9 - 0.000422657699443485*G0_2_3 + 0.000195072784358532*G0_2_4 + 0.000422657699443485*G0_2_5 - 0.000195072784358531*G0_2_6 + 0.000764035072070914*G0_2_7 - 0.000764035072070915*G0_2_8 - 0.000471425895533118*G0_3_0 - 0.000422657699443485*G0_3_2 - 0.00448667404024622*G0_3_3 + 0.00151181407877862*G0_3_4 + 0.000438913764806697*G0_3_6 + 0.00141427768659935*G0_3_7 - 0.0037063829028121*G0_3_8 - 0.00702262023690713*G0_3_9 + 0.000146304588268898*G0_4_0 + 0.000195072784358532*G0_4_2 + 0.00151181407877862*G0_4_3 - 0.00126797309833046*G0_4_4 - 0.000438913764806696*G0_4_5 - 0.00136550949050972*G0_4_7 + 0.00229210521621275*G0_4_8 + 0.00087782752961339*G0_4_9 + 0.000471425895533118*G0_5_1 + 0.000422657699443485*G0_5_2 - 0.000438913764806696*G0_5_4 + 0.00448667404024622*G0_5_5 - 0.00151181407877862*G0_5_6 + 0.00370638290281209*G0_5_7 - 0.00141427768659935*G0_5_8 + 0.00702262023690713*G0_5_9 - 0.000146304588268899*G0_6_1 - 0.000195072784358531*G0_6_2 + 0.000438913764806697*G0_6_3 - 0.00151181407877862*G0_6_5 + 0.00126797309833045*G0_6_6 - 0.00229210521621274*G0_6_7 + 0.00136550949050972*G0_6_8 - 0.000877827529613394*G0_6_9 + 0.000341377372627431*G0_7_0 + 0.000552706222349172*G0_7_1 + 0.000764035072070914*G0_7_2 + 0.00141427768659935*G0_7_3 - 0.00136550949050972*G0_7_4 + 0.00370638290281209*G0_7_5 - 0.00229210521621274*G0_7_6 + 0.00585218353075594*G0_7_7 + 0.00877827529613392*G0_7_9 - 0.000552706222349173*G0_8_0 - 0.000341377372627429*G0_8_1 - 0.000764035072070915*G0_8_2 - 0.0037063829028121*G0_8_3 + 0.00229210521621275*G0_8_4 - 0.00141427768659935*G0_8_5 + 0.00136550949050972*G0_8_6 - 0.00585218353075595*G0_8_8 - 0.00877827529613392*G0_8_9 - 0.00139802162123614*G0_9_0 + 0.00139802162123614*G0_9_1 - 0.00702262023690713*G0_9_3 + 0.00087782752961339*G0_9_4 + 0.00702262023690713*G0_9_5 - 0.000877827529613394*G0_9_6 + 0.00877827529613392*G0_9_7 - 0.00877827529613392*G0_9_8;
    A[10] = A[1];
    A[83] = A[75] - 0.000371581543456605*G0_0_0 + 0.00035582720850584*G0_0_3 - 0.000138176555587293*G0_0_4 - 0.000520796168117684*G0_0_5 + 0.000205308084772405*G0_0_6 - 0.000636093816897495*G0_0_7 + 0.000565048790495314*G0_0_8 + 0.000247453439417767*G0_0_9 + 0.000371581543456607*G0_1_1 + 0.000520796168117685*G0_1_3 - 0.000205308084772405*G0_1_4 - 0.00035582720850584*G0_1_5 + 0.000138176555587293*G0_1_6 - 0.000565048790495314*G0_1_7 + 0.000636093816897495*G0_1_8 - 0.000247453439417767*G0_1_9 + 0.000359740705722909*G0_2_3 - 0.000115297648779811*G0_2_4 - 0.000359740705722909*G0_2_5 + 0.000115297648779811*G0_2_6 - 0.000494003764093133*G0_2_7 + 0.000494003764093133*G0_2_8 + 0.00035582720850584*G0_3_0 + 0.000520796168117685*G0_3_1 + 0.000359740705722909*G0_3_2 + 0.00394209585057866*G0_3_3 - 0.00139802162123614*G0_3_4 - 0.000414529666761879*G0_3_6 - 0.00106748162551752*G0_3_7 + 0.00254949291779692*G0_3_8 + 0.00287732356928834*G0_3_9 - 0.000138176555587293*G0_4_0 - 0.000205308084772405*G0_4_1 - 0.000115297648779811*G0_4_2 - 0.00139802162123614*G0_4_3 + 0.000503938026259539*G0_4_4 + 0.00041452966676188*G0_4_5 + 0.000948270479520639*G0_4_7 - 0.0014820112922794*G0_4_8 - 0.000829059333523759*G0_4_9 - 0.000520796168117684*G0_5_0 - 0.00035582720850584*G0_5_1 - 0.000359740705722909*G0_5_2 + 0.00041452966676188*G0_5_4 - 0.00394209585057865*G0_5_5 + 0.00139802162123614*G0_5_6 - 0.00254949291779692*G0_5_7 + 0.00106748162551752*G0_5_8 - 0.00287732356928834*G0_5_9 + 0.000205308084772405*G0_6_0 + 0.000138176555587293*G0_6_1 + 0.000115297648779811*G0_6_2 - 0.000414529666761879*G0_6_3 + 0.00139802162123614*G0_6_5 - 0.000503938026259541*G0_6_6 + 0.0014820112922794*G0_6_7 - 0.000948270479520639*G0_6_8 + 0.000829059333523758*G0_6_9 - 0.000636093816897495*G0_7_0 - 0.000565048790495314*G0_7_1 - 0.000494003764093133*G0_7_2 - 0.00106748162551752*G0_7_3 + 0.000948270479520639*G0_7_4 - 0.00254949291779692*G0_7_5 + 0.0014820112922794*G0_7_6 - 0.00343815782431911*G0_7_7 - 0.0037063829028121*G0_7_9 + 0.000565048790495314*G0_8_0 + 0.000636093816897495*G0_8_1 + 0.000494003764093133*G0_8_2 + 0.00254949291779692*G0_8_3 - 0.0014820112922794*G0_8_4 + 0.00106748162551752*G0_8_5 - 0.000948270479520639*G0_8_6 + 0.00343815782431912*G0_8_8 + 0.0037063829028121*G0_8_9 + 0.000247453439417767*G0_9_0 - 0.000247453439417767*G0_9_1 + 0.00287732356928834*G0_9_3 - 0.000829059333523759*G0_9_4 - 0.00287732356928834*G0_9_5 + 0.000829059333523758*G0_9_6 - 0.0037063829028121*G0_9_7 + 0.0037063829028121*G0_9_8;
    A[46] = A[64];
    A[92] = A[90] - 0.000117806300842035*G0_0_5 - 0.00015192396888828*G0_0_7 - 0.000399778792636003*G0_0_9 + 0.00015192396888828*G0_2_4 + 0.000117806300842035*G0_2_6 + 0.000399778792636003*G0_2_9 - 0.000270934422720183*G0_3_3 + 0.00015192396888828*G0_4_2 - 0.000482263272441925*G0_4_4 + 0.0001481108177537*G0_4_5 - 0.000247453439417767*G0_4_6 - 0.00149555801341541*G0_4_9 - 0.000117806300842035*G0_5_0 + 0.0001481108177537*G0_5_4 + 0.000211328849721742*G0_5_5 + 0.000247453439417767*G0_5_7 + 0.00139802162123614*G0_5_9 + 0.000117806300842035*G0_6_2 - 0.000247453439417767*G0_6_4 - 0.000211328849721743*G0_6_6 - 0.0001481108177537*G0_6_7 - 0.00139802162123614*G0_6_9 - 0.00015192396888828*G0_7_0 + 0.000247453439417767*G0_7_5 - 0.0001481108177537*G0_7_6 + 0.000482263272441924*G0_7_7 + 0.00149555801341541*G0_7_9 + 0.000270934422720183*G0_8_8 - 0.000399778792636003*G0_9_0 + 0.000399778792636003*G0_9_2 - 0.00149555801341541*G0_9_4 + 0.00139802162123614*G0_9_5 - 0.00139802162123614*G0_9_6 + 0.00149555801341541*G0_9_7;
    A[57] = A[75];
    A[74] = A[86] - 0.000114494880119899*G0_0_0 + 0.000101148851148868*G0_0_3 - 0.000113792457542477*G0_0_4 - 0.000155937812187838*G0_0_5 - 0.000185439560439591*G0_0_7 + 0.000200190434565468*G0_0_8 + 0.0001144948801199*G0_1_1 + 0.000155937812187839*G0_1_3 - 0.000101148851148868*G0_1_5 + 0.000113792457542477*G0_1_6 - 0.000200190434565468*G0_1_7 + 0.000185439560439591*G0_1_8 + 0.000166474150849179*G0_2_3 - 0.000166474150849179*G0_2_5 - 0.000214941308691345*G0_2_7 + 0.000214941308691345*G0_2_8 + 0.000101148851148868*G0_3_0 + 0.000155937812187839*G0_3_1 + 0.000166474150849179*G0_3_2 + 0.000967235889111052*G0_3_3 - 0.000568962287712383*G0_3_4 - 0.00034137737262743*G0_3_6 - 0.000303446553446604*G0_3_7 + 0.000948270479520639*G0_3_8 + 0.000682754745254861*G0_3_9 - 0.000113792457542477*G0_4_0 - 0.000568962287712383*G0_4_3 - 0.000568962287712386*G0_4_4 + 0.000341377372627431*G0_4_5 + 0.000493100649350733*G0_4_7 - 0.000644823926074035*G0_4_8 - 0.000682754745254862*G0_4_9 - 0.000155937812187838*G0_5_0 - 0.000101148851148868*G0_5_1 - 0.000166474150849179*G0_5_2 + 0.000341377372627431*G0_5_4 - 0.000967235889111052*G0_5_5 + 0.000568962287712384*G0_5_6 - 0.000948270479520639*G0_5_7 + 0.000303446553446604*G0_5_8 - 0.00068275474525486*G0_5_9 + 0.000113792457542477*G0_6_1 - 0.00034137737262743*G0_6_3 + 0.000568962287712384*G0_6_5 + 0.00056896228771238*G0_6_6 + 0.000644823926074034*G0_6_7 - 0.000493100649350732*G0_6_8 + 0.000682754745254859*G0_6_9 - 0.000185439560439591*G0_7_0 - 0.000200190434565468*G0_7_1 - 0.000214941308691345*G0_7_2 - 0.000303446553446604*G0_7_3 + 0.000493100649350733*G0_7_4 - 0.000948270479520639*G0_7_5 + 0.000644823926074034*G0_7_6 - 0.00153619817682343*G0_7_7 - 0.00136550949050972*G0_7_9 + 0.000200190434565468*G0_8_0 + 0.000185439560439591*G0_8_1 + 0.000214941308691345*G0_8_2 + 0.000948270479520639*G0_8_3 - 0.000644823926074035*G0_8_4 + 0.000303446553446604*G0_8_5 - 0.000493100649350732*G0_8_6 + 0.00153619817682344*G0_8_8 + 0.00136550949050972*G0_8_9 + 0.000682754745254861*G0_9_3 - 0.000682754745254862*G0_9_4 - 0.00068275474525486*G0_9_5 + 0.000682754745254859*G0_9_6 - 0.00136550949050972*G0_9_7 + 0.00136550949050972*G0_9_8;
    A[2] = A[1] + 0.000115197302697322*G0_5_5 + 0.000117705954759546*G0_6_6 - 0.000115197302697322*G0_7_7 - 0.000117705954759546*G0_8_8;
    A[25] = A[2] + 0.000102319555444573*G0_0_5 - 0.00039478750416257*G0_2_2 + 0.000104895104895123*G0_2_3 - 0.00026317432567437*G0_2_4 + 0.00025263798701303*G0_2_5 - 0.000432224025974099*G0_2_6 + 0.000104895104895123*G0_3_2 - 0.000146003550021432*G0_3_3 + 0.000230996681889578*G0_3_4 + 0.000208017428999607*G0_3_6 - 0.00026317432567437*G0_4_2 + 0.000230996681889578*G0_4_3 - 0.000295719905094955*G0_4_4 - 0.00027886176323681*G0_4_6 + 0.000102319555444573*G0_5_0 + 0.00025263798701303*G0_5_2 + 0.000372685350363984*G0_5_5 + 0.000286187027258504*G0_5_7 - 0.000131854752390489*G0_5_8 + 0.000271536499215116*G0_5_9 - 0.000432224025974099*G0_6_2 + 0.000208017428999607*G0_6_3 - 0.00027886176323681*G0_6_4 - 0.000811298076923214*G0_6_6 - 0.000154332274868015*G0_6_7 + 0.000103155772798647*G0_6_8 - 0.000281169723134056*G0_6_9 + 0.000286187027258504*G0_7_5 - 0.000154332274868015*G0_7_6 + 0.000315086699015323*G0_7_7 + 0.000316491544170169*G0_7_9 - 0.000131854752390489*G0_8_5 + 0.000103155772798647*G0_8_6 - 0.000139280362494672*G0_8_9 + 0.000271536499215116*G0_9_5 - 0.000281169723134056*G0_9_6 + 0.000316491544170169*G0_9_7 - 0.000139280362494672*G0_9_8 + 0.000567156058227583*G0_9_9;
    A[32] = A[25] - 0.000166674843014157*G0_0_5 + 0.000166674843014157*G0_1_3 + 0.000140484515484539*G0_2_3 - 0.000147508741258766*G0_2_4 - 0.000140484515484539*G0_2_5 + 0.000147508741258766*G0_2_6 + 0.000166674843014157*G0_3_1 + 0.000140484515484539*G0_3_2 + 0.000636394855144963*G0_3_3 - 0.000280266608391656*G0_3_4 - 0.000120114260739281*G0_3_6 - 0.000146906664763832*G0_3_7 + 0.000359740705722909*G0_3_8 + 0.000290802947052996*G0_3_9 - 0.000147508741258766*G0_4_2 - 0.000280266608391656*G0_4_3 - 0.000400380869130937*G0_4_4 + 0.000120114260739281*G0_4_5 + 0.000166474150849179*G0_4_7 - 0.000212834040959077*G0_4_8 - 0.000240228521478562*G0_4_9 - 0.000166674843014157*G0_5_0 - 0.000140484515484539*G0_5_2 + 0.000120114260739281*G0_5_4 - 0.000636394855144962*G0_5_5 + 0.000280266608391655*G0_5_6 - 0.000359740705722909*G0_5_7 + 0.000146906664763832*G0_5_8 - 0.000290802947052996*G0_5_9 + 0.000147508741258766*G0_6_2 - 0.000120114260739281*G0_6_3 + 0.000280266608391655*G0_6_5 + 0.000400380869130937*G0_6_6 + 0.000212834040959077*G0_6_7 - 0.000166474150849179*G0_6_8 + 0.000240228521478562*G0_6_9 - 0.000146906664763832*G0_7_3 + 0.000166474150849179*G0_7_4 - 0.000359740705722909*G0_7_5 + 0.000212834040959077*G0_7_6 - 0.000332346225203424*G0_7_7 - 0.000422657699443485*G0_7_9 + 0.000359740705722909*G0_8_3 - 0.000212834040959077*G0_8_4 + 0.000146906664763832*G0_8_5 - 0.000166474150849179*G0_8_6 + 0.000332346225203424*G0_8_8 + 0.000422657699443485*G0_8_9 + 0.000290802947052996*G0_9_3 - 0.000240228521478562*G0_9_4 - 0.000290802947052996*G0_9_5 + 0.000240228521478562*G0_9_6 - 0.000422657699443485*G0_9_7 + 0.000422657699443485*G0_9_8;
    A[60] = A[25] - 0.000391249375624442*G0_0_0 - 0.000534543581418672*G0_0_5 + 0.000323917154274352*G0_0_6 - 0.000267623001998047*G0_0_7 + 0.000122321874554038*G0_0_8 - 0.000113290727130032*G0_1_5 + 0.000113290727130032*G0_1_6 + 0.000391249375624441*G0_2_2 - 0.000122321874554038*G0_2_3 + 0.000267623001998047*G0_2_4 - 0.000323917154274352*G0_2_5 + 0.000534543581418672*G0_2_6 - 0.000122321874554038*G0_3_2 + 0.000131252675895555*G0_3_3 - 0.000294114367775132*G0_3_4 + 0.000200190434565468*G0_3_5 - 0.000339872181390096*G0_3_6 - 0.000121017375481682*G0_3_9 + 0.000267623001998047*G0_4_2 - 0.000294114367775132*G0_4_3 + 0.000610806604110279*G0_4_4 - 0.000225176609105219*G0_4_5 + 0.000565048790495314*G0_4_6 + 0.000323315077779418*G0_4_9 - 0.000534543581418672*G0_5_0 - 0.000113290727130032*G0_5_1 - 0.000323917154274352*G0_5_2 + 0.000200190434565468*G0_5_3 - 0.000225176609105219*G0_5_4 - 0.0011839834272872*G0_5_5 - 0.000565048790495314*G0_5_7 + 0.000339872181390095*G0_5_8 - 0.000552706222349173*G0_5_9 + 0.000323917154274352*G0_6_0 + 0.000113290727130032*G0_6_1 + 0.000534543581418672*G0_6_2 - 0.000339872181390096*G0_6_3 + 0.000565048790495314*G0_6_4 + 0.0011839834272872*G0_6_6 + 0.000225176609105218*G0_6_7 - 0.000200190434565468*G0_6_8 + 0.000552706222349173*G0_6_9 - 0.000267623001998047*G0_7_0 - 0.000565048790495314*G0_7_5 + 0.000225176609105218*G0_7_6 - 0.000610806604110278*G0_7_7 + 0.000294114367775131*G0_7_8 - 0.000323315077779418*G0_7_9 + 0.000122321874554038*G0_8_0 + 0.000339872181390095*G0_8_5 - 0.000200190434565468*G0_8_6 + 0.000294114367775131*G0_8_7 - 0.000131252675895555*G0_8_8 + 0.000121017375481682*G0_8_9 - 0.000121017375481682*G0_9_3 + 0.000323315077779418*G0_9_4 - 0.000552706222349173*G0_9_5 + 0.000552706222349173*G0_9_6 - 0.000323315077779418*G0_9_7 + 0.000121017375481682*G0_9_8;
    A[16] = A[60] + 0.000302978271728323*G0_0_0 + 0.000303546899529094*G0_0_5 - 0.000172494915798517*G0_0_6 + 0.000179017411160298*G0_0_7 - 0.000115197302697322*G0_2_6 + 0.000303546899529094*G0_5_0 + 0.000563543599257981*G0_5_5 + 0.000104159233623537*G0_5_7 - 0.000172494915798517*G0_6_0 - 0.000115197302697322*G0_6_2 + 0.000249259668902567*G0_6_6 + 0.000270934422720182*G0_6_9 + 0.000179017411160298*G0_7_0 + 0.000104159233623537*G0_7_5 + 0.000270934422720182*G0_9_6;
    A[40] = A[16] - 0.000138176555587293*G0_3_3 + 0.000130048522905688*G0_3_6 - 0.000138176555587293*G0_3_8 + 0.000455169830169907*G0_4_4 - 0.000130048522905688*G0_4_5 - 0.000113792457542477*G0_4_7 + 0.000260097045811375*G0_4_9 - 0.000130048522905688*G0_5_4 + 0.000138176555587293*G0_5_5 + 0.000138176555587293*G0_5_7 + 0.000130048522905688*G0_6_3 - 0.000455169830169907*G0_6_6 + 0.000113792457542477*G0_6_8 - 0.000260097045811375*G0_6_9 - 0.000113792457542477*G0_7_4 + 0.000138176555587293*G0_7_5 + 0.000154432620950504*G0_7_7 + 0.000146304588268899*G0_7_9 - 0.000138176555587293*G0_8_3 + 0.000113792457542477*G0_8_6 - 0.000154432620950504*G0_8_8 - 0.000146304588268899*G0_8_9 + 0.000260097045811375*G0_9_4 - 0.000260097045811375*G0_9_6 + 0.000146304588268899*G0_9_7 - 0.000146304588268899*G0_9_8;
    A[4] = A[40];
    A[82] = A[16] + 0.000276353111174586*G0_3_3 - 0.000101148851148868*G0_3_5 + 0.000194169669616131*G0_3_6 - 0.000161657538889709*G0_3_7 + 0.00035582720850584*G0_3_8 + 0.000471425895533118*G0_3_9 - 0.000276353111174586*G0_4_4 + 0.000161657538889709*G0_4_5 - 0.00035582720850584*G0_4_6 + 0.000101148851148868*G0_4_7 - 0.000194169669616131*G0_4_8 - 0.000471425895533118*G0_4_9 - 0.000101148851148868*G0_5_3 + 0.000161657538889709*G0_5_4 + 0.000184235407449724*G0_5_6 + 0.000194169669616131*G0_6_3 - 0.00035582720850584*G0_6_4 + 0.000184235407449724*G0_6_5 - 0.000807384579706144*G0_6_6 - 0.000536450156985962*G0_6_9 - 0.000161657538889709*G0_7_3 + 0.000101148851148868*G0_7_4 - 0.000184235407449724*G0_7_8 + 0.00035582720850584*G0_8_3 - 0.000194169669616131*G0_8_4 - 0.000184235407449724*G0_8_7 + 0.000807384579706144*G0_8_8 + 0.000536450156985962*G0_8_9 + 0.000471425895533118*G0_9_3 - 0.000471425895533118*G0_9_4 - 0.000536450156985962*G0_9_6 + 0.000536450156985962*G0_9_8;
    A[51] = A[16] + 0.000115799379192256*G0_0_5 - 0.000113290727130032*G0_0_6 + 0.000110782075067808*G0_1_5 - 0.000110782075067808*G0_1_6 + 0.000113290727130032*G0_2_5 - 0.000115799379192256*G0_2_6 + 0.00028177179962899*G0_3_4 - 0.000214941308691345*G0_3_5 + 0.000332346225203424*G0_3_6 + 0.000195072784358532*G0_3_9 + 0.00028177179962899*G0_4_3 - 0.000506647370486742*G0_4_4 + 0.000161657538889709*G0_4_5 - 0.000494003764093133*G0_4_6 - 0.000422657699443485*G0_4_9 + 0.000115799379192256*G0_5_0 + 0.000110782075067808*G0_5_1 + 0.000113290727130032*G0_5_2 - 0.000214941308691345*G0_5_3 + 0.000161657538889709*G0_5_4 + 0.000869699496931785*G0_5_5 + 0.000494003764093132*G0_5_7 - 0.000332346225203424*G0_5_8 + 0.000764035072070915*G0_5_9 - 0.000113290727130032*G0_6_0 - 0.000110782075067808*G0_6_1 - 0.000115799379192256*G0_6_2 + 0.000332346225203424*G0_6_3 - 0.000494003764093133*G0_6_4 - 0.000869699496931786*G0_6_6 - 0.000161657538889709*G0_6_7 + 0.000214941308691345*G0_6_8 - 0.000764035072070915*G0_6_9 + 0.000494003764093132*G0_7_5 - 0.000161657538889709*G0_7_6 + 0.000506647370486741*G0_7_7 - 0.000281771799628989*G0_7_8 + 0.000422657699443485*G0_7_9 - 0.000332346225203424*G0_8_5 + 0.000214941308691345*G0_8_6 - 0.000281771799628989*G0_8_7 - 0.000195072784358532*G0_8_9 + 0.000195072784358532*G0_9_3 - 0.000422657699443485*G0_9_4 + 0.000764035072070915*G0_9_5 - 0.000764035072070915*G0_9_6 + 0.000422657699443485*G0_9_7 - 0.000195072784358532*G0_9_8;
    A[72] = A[40] + 0.000184235407449724*G0_3_4 - 0.000101148851148868*G0_3_5 + 0.000161657538889709*G0_3_6 + 0.000184235407449724*G0_4_3 - 0.000807384579706145*G0_4_4 + 0.000194169669616131*G0_4_5 - 0.00035582720850584*G0_4_6 - 0.000536450156985962*G0_4_9 - 0.000101148851148868*G0_5_3 + 0.000194169669616131*G0_5_4 + 0.000276353111174586*G0_5_5 + 0.000355827208505839*G0_5_7 - 0.000161657538889709*G0_5_8 + 0.000471425895533118*G0_5_9 + 0.000161657538889709*G0_6_3 - 0.00035582720850584*G0_6_4 - 0.000276353111174587*G0_6_6 - 0.000194169669616131*G0_6_7 + 0.000101148851148868*G0_6_8 - 0.000471425895533118*G0_6_9 + 0.000355827208505839*G0_7_5 - 0.000194169669616131*G0_7_6 + 0.000807384579706143*G0_7_7 - 0.000184235407449724*G0_7_8 + 0.000536450156985961*G0_7_9 - 0.000161657538889709*G0_8_5 + 0.000101148851148868*G0_8_6 - 0.000184235407449724*G0_8_7 - 0.000536450156985962*G0_9_4 + 0.000471425895533118*G0_9_5 - 0.000471425895533118*G0_9_6 + 0.000536450156985961*G0_9_7;
    A[7] = A[72] + 0.000641780094905203*G0_0_0 + 0.000375093656343719*G0_0_5 - 0.000196076245183421*G0_0_6 + 0.000799356893107027*G0_0_7 - 0.000303546899529093*G0_0_8 + 0.00015192396888828*G0_0_9 + 0.000117705954759546*G0_1_7 - 0.000121318413729148*G0_4_4 + 0.000121318413729149*G0_4_7 + 0.000375093656343719*G0_5_0 + 0.00012402775795635*G0_5_5 - 0.000104159233623536*G0_5_8 - 0.000247453439417767*G0_5_9 - 0.000196076245183421*G0_6_0 + 0.0001481108177537*G0_6_9 + 0.000799356893107027*G0_7_0 + 0.000117705954759546*G0_7_1 + 0.000121318413729149*G0_7_4 + 0.000596055729984402*G0_7_7 - 0.000563543599257979*G0_7_8 - 0.000482263272441924*G0_7_9 - 0.000303546899529093*G0_8_0 - 0.000104159233623536*G0_8_5 - 0.000563543599257979*G0_8_7 + 0.00015192396888828*G0_9_0 - 0.000247453439417767*G0_9_5 + 0.0001481108177537*G0_9_6 - 0.000482263272441924*G0_9_7 - 0.00149555801341541*G0_9_9;
    A[15] = A[51];
    A[41] = A[32] - 0.000113290727130032*G0_0_3 + 0.000113290727130032*G0_0_4 - 0.000391249375624442*G0_1_1 - 0.000534543581418672*G0_1_3 + 0.000323917154274352*G0_1_4 + 0.000122321874554038*G0_1_7 - 0.000267623001998047*G0_1_8 + 0.000391249375624441*G0_2_2 - 0.000323917154274352*G0_2_3 + 0.000534543581418672*G0_2_4 - 0.000122321874554038*G0_2_5 + 0.000267623001998047*G0_2_6 - 0.000113290727130032*G0_3_0 - 0.000534543581418672*G0_3_1 - 0.000323917154274352*G0_3_2 - 0.0011839834272872*G0_3_3 + 0.000200190434565469*G0_3_5 - 0.000225176609105219*G0_3_6 + 0.000339872181390096*G0_3_7 - 0.000565048790495314*G0_3_8 - 0.000552706222349173*G0_3_9 + 0.000113290727130032*G0_4_0 + 0.000323917154274352*G0_4_1 + 0.000534543581418672*G0_4_2 + 0.0011839834272872*G0_4_4 - 0.000339872181390096*G0_4_5 + 0.000565048790495314*G0_4_6 - 0.000200190434565469*G0_4_7 + 0.000225176609105219*G0_4_8 + 0.000552706222349173*G0_4_9 - 0.000122321874554038*G0_5_2 + 0.000200190434565469*G0_5_3 - 0.000339872181390096*G0_5_4 + 0.000131252675895555*G0_5_5 - 0.000294114367775132*G0_5_6 - 0.000121017375481682*G0_5_9 + 0.000267623001998047*G0_6_2 - 0.000225176609105219*G0_6_3 + 0.000565048790495314*G0_6_4 - 0.000294114367775132*G0_6_5 + 0.000610806604110279*G0_6_6 + 0.000323315077779418*G0_6_9 + 0.000122321874554038*G0_7_1 + 0.000339872181390096*G0_7_3 - 0.000200190434565469*G0_7_4 - 0.000131252675895555*G0_7_7 + 0.000294114367775132*G0_7_8 + 0.000121017375481682*G0_7_9 - 0.000267623001998047*G0_8_1 - 0.000565048790495314*G0_8_3 + 0.000225176609105219*G0_8_4 + 0.000294114367775132*G0_8_7 - 0.000610806604110278*G0_8_8 - 0.000323315077779418*G0_8_9 - 0.000552706222349173*G0_9_3 + 0.000552706222349172*G0_9_4 - 0.000121017375481682*G0_9_5 + 0.000323315077779418*G0_9_6 + 0.000121017375481682*G0_9_7 - 0.000323315077779418*G0_9_8;
    A[71] = A[25] - 0.000119411838161858*G0_0_5 + 0.000119411838161858*G0_0_7 - 0.000319490777080118*G0_1_1 - 0.000220359997145749*G0_1_3 + 0.000122321874554038*G0_1_4 + 0.000191661017553907*G0_1_7 - 0.000343785678607166*G0_1_8 + 0.000319490777080116*G0_2_2 - 0.000122321874554038*G0_2_3 + 0.000220359997145749*G0_2_4 - 0.000191661017553907*G0_2_5 + 0.000343785678607165*G0_2_6 - 0.000220359997145749*G0_3_1 - 0.000122321874554038*G0_3_2 - 0.0001472077030113*G0_3_3 - 0.000132456828885423*G0_3_6 - 0.000205308084772405*G0_3_8 + 0.000122321874554038*G0_4_1 + 0.000220359997145749*G0_4_2 + 0.000147207703011299*G0_4_4 + 0.000205308084772405*G0_4_6 + 0.000132456828885423*G0_4_8 - 0.000119411838161858*G0_5_0 - 0.000191661017553907*G0_5_2 - 0.000172795954045983*G0_5_5 + 0.000343785678607165*G0_6_2 - 0.000132456828885423*G0_6_3 + 0.000205308084772405*G0_6_4 + 0.000678841248037791*G0_6_6 + 0.000140885899814495*G0_6_9 + 0.000119411838161858*G0_7_0 + 0.000191661017553907*G0_7_1 + 0.000172795954045982*G0_7_7 - 0.000343785678607166*G0_8_1 - 0.000205308084772405*G0_8_3 + 0.000132456828885423*G0_8_4 - 0.000678841248037792*G0_8_8 - 0.000140885899814495*G0_8_9 + 0.000140885899814495*G0_9_6 - 0.000140885899814495*G0_9_8;
    A[5] = A[7] + 0.000428477772227846*G0_0_5 - 0.000147508741258767*G0_0_6 - 0.000428477772227844*G0_0_7 + 0.000147508741258766*G0_0_8 - 0.000119411838161858*G0_1_7 + 0.000119411838161858*G0_2_5 + 0.000117404916512079*G0_3_3 + 0.000115297648779811*G0_3_8 + 0.000195072784358532*G0_3_9 - 0.000117404916512079*G0_4_4 - 0.000115297648779811*G0_4_6 - 0.000195072784358532*G0_4_9 + 0.000428477772227846*G0_5_0 + 0.000119411838161859*G0_5_2 + 0.000927197802197961*G0_5_5 - 0.000413024475524546*G0_5_6 - 0.000147508741258767*G0_6_0 - 0.000115297648779811*G0_6_4 - 0.000413024475524546*G0_6_5 - 0.000160152347652374*G0_6_6 - 0.000240228521478562*G0_6_9 - 0.000428477772227844*G0_7_0 - 0.000119411838161858*G0_7_1 - 0.000927197802197958*G0_7_7 + 0.000413024475524545*G0_7_8 + 0.000147508741258766*G0_8_0 + 0.000115297648779811*G0_8_3 + 0.000413024475524545*G0_8_7 + 0.000160152347652375*G0_8_8 + 0.000240228521478562*G0_8_9 + 0.000195072784358531*G0_9_3 - 0.000195072784358532*G0_9_4 - 0.000240228521478562*G0_9_6 + 0.000240228521478562*G0_9_8;
    A[26] = A[5] - 0.000715768606393728*G0_0_0 - 0.000953287783645088*G0_0_5 + 0.000534543581418672*G0_0_6 - 0.000446640413158345*G0_0_7 + 0.000220359997145748*G0_0_8 - 0.000117806300842035*G0_0_9 - 0.000115799379192256*G0_1_5 + 0.000115799379192256*G0_1_6 + 0.000715768606393726*G0_2_2 - 0.000220359997145749*G0_2_3 + 0.000446640413158345*G0_2_4 - 0.000534543581418672*G0_2_5 + 0.000953287783645087*G0_2_6 + 0.000117806300842035*G0_2_9 - 0.000220359997145749*G0_3_2 + 0.000186643713429459*G0_3_3 - 0.000306456935921273*G0_3_4 + 0.000185439560439592*G0_3_5 - 0.000347398137576768*G0_3_6 + 0.000446640413158345*G0_4_2 - 0.000306456935921273*G0_4_3 + 0.000714965837733815*G0_4_4 - 0.000288695679320728*G0_4_5 + 0.000636093816897495*G0_4_6 + 0.000223972456115351*G0_4_9 - 0.000953287783645088*G0_5_0 - 0.000115799379192256*G0_5_1 - 0.000534543581418672*G0_5_2 + 0.000185439560439592*G0_5_3 - 0.000288695679320728*G0_5_4 - 0.00149826735764261*G0_5_5 - 0.000636093816897494*G0_5_7 + 0.000347398137576767*G0_5_8 - 0.00034137737262743*G0_5_9 + 0.000534543581418672*G0_6_0 + 0.000115799379192256*G0_6_1 + 0.000953287783645087*G0_6_2 - 0.000347398137576768*G0_6_3 + 0.000636093816897495*G0_6_4 + 0.00149826735764261*G0_6_6 + 0.000288695679320727*G0_6_7 - 0.000185439560439591*G0_6_8 + 0.00034137737262743*G0_6_9 - 0.000446640413158345*G0_7_0 - 0.000636093816897494*G0_7_5 + 0.000288695679320727*G0_7_6 - 0.000714965837733814*G0_7_7 + 0.000306456935921273*G0_7_8 - 0.000223972456115351*G0_7_9 + 0.000220359997145748*G0_8_0 + 0.000347398137576767*G0_8_5 - 0.000185439560439591*G0_8_6 + 0.000306456935921273*G0_8_7 - 0.000186643713429459*G0_8_8 - 0.000117806300842035*G0_9_0 + 0.000117806300842035*G0_9_2 + 0.000223972456115351*G0_9_4 - 0.00034137737262743*G0_9_5 + 0.00034137737262743*G0_9_6 - 0.000223972456115351*G0_9_7;
    A[31] = A[5] - 0.000691930837020241*G0_0_0 - 0.000842405362494791*G0_0_5 + 0.000343785678607166*G0_0_6 - 0.000446640413158345*G0_0_7 + 0.000267623001998047*G0_0_8 - 0.00015192396888828*G0_0_9 + 0.000691930837020241*G0_1_1 + 0.000842405362494791*G0_1_3 - 0.000343785678607166*G0_1_4 - 0.000267623001998047*G0_1_7 + 0.000446640413158346*G0_1_8 + 0.00015192396888828*G0_1_9 + 0.000166674843014157*G0_2_3 - 0.000166674843014157*G0_2_5 + 0.000842405362494791*G0_3_1 + 0.000166674843014157*G0_3_2 + 0.0015247587234197*G0_3_3 - 0.000719481411445819*G0_3_4 - 0.000254979395604439*G0_3_7 + 0.000520796168117685*G0_3_8 - 0.000343785678607166*G0_4_1 - 0.000719481411445819*G0_4_3 + 0.000143896282289164*G0_4_4 + 0.000155937812187839*G0_4_7 - 0.000265816772513246*G0_4_8 - 0.000842405362494791*G0_5_0 - 0.000166674843014157*G0_5_2 - 0.0015247587234197*G0_5_5 + 0.000719481411445819*G0_5_6 - 0.000520796168117684*G0_5_7 + 0.000254979395604438*G0_5_8 + 0.000343785678607166*G0_6_0 + 0.000719481411445819*G0_6_5 - 0.000143896282289164*G0_6_6 + 0.000265816772513246*G0_6_7 - 0.000155937812187838*G0_6_8 - 0.000446640413158345*G0_7_0 - 0.000267623001998048*G0_7_1 - 0.000254979395604439*G0_7_3 + 0.000155937812187839*G0_7_4 - 0.000520796168117684*G0_7_5 + 0.000265816772513246*G0_7_6 - 0.000410917207792276*G0_7_7 + 0.000267623001998047*G0_8_0 + 0.000446640413158347*G0_8_1 + 0.000520796168117685*G0_8_3 - 0.000265816772513246*G0_8_4 + 0.000254979395604438*G0_8_5 - 0.000155937812187838*G0_8_6 + 0.000410917207792278*G0_8_8 - 0.00015192396888828*G0_9_0 + 0.00015192396888828*G0_9_1;
    A[8] = A[32] - 0.000319490777080117*G0_0_0 - 0.000220359997145748*G0_0_5 + 0.000122321874554038*G0_0_6 - 0.000343785678607165*G0_0_7 + 0.000191661017553907*G0_0_8 - 0.000119411838161858*G0_1_3 + 0.000119411838161859*G0_1_8 + 0.000319490777080116*G0_2_2 - 0.000191661017553907*G0_2_3 + 0.000343785678607165*G0_2_4 - 0.000122321874554038*G0_2_5 + 0.000220359997145749*G0_2_6 - 0.000119411838161858*G0_3_1 - 0.000191661017553907*G0_3_2 - 0.000172795954045984*G0_3_3 + 0.000343785678607165*G0_4_2 + 0.000678841248037792*G0_4_4 - 0.000132456828885423*G0_4_5 + 0.000205308084772405*G0_4_6 + 0.000140885899814495*G0_4_9 - 0.000220359997145748*G0_5_0 - 0.000122321874554038*G0_5_2 - 0.000132456828885423*G0_5_4 - 0.000147207703011299*G0_5_5 - 0.000205308084772404*G0_5_7 + 0.000122321874554038*G0_6_0 + 0.000220359997145749*G0_6_2 + 0.000205308084772405*G0_6_4 + 0.000147207703011299*G0_6_6 + 0.000132456828885422*G0_6_7 - 0.000343785678607165*G0_7_0 - 0.000205308084772404*G0_7_5 + 0.000132456828885422*G0_7_6 - 0.00067884124803779*G0_7_7 - 0.000140885899814495*G0_7_9 + 0.000191661017553907*G0_8_0 + 0.000119411838161859*G0_8_1 + 0.000172795954045984*G0_8_8 + 0.000140885899814495*G0_9_4 - 0.000140885899814495*G0_9_7;
    A[27] = A[72];
    A[61] = A[16];
    A[13] = A[31];
    A[48] = A[73] + 0.000130048522905688*G0_0_3 - 0.000120114260739281*G0_1_4 + 0.000120114260739281*G0_1_7 - 0.000130048522905688*G0_2_8 + 0.000130048522905688*G0_3_0 + 0.00136550949050972*G0_3_3 + 0.000292609176537797*G0_3_4 - 0.00034137737262743*G0_3_5 + 0.000292609176537797*G0_3_6 - 0.000390145568717064*G0_3_7 + 0.000780291137434126*G0_3_9 - 0.000120114260739281*G0_4_1 + 0.000292609176537797*G0_4_3 - 0.000414529666761878*G0_4_4 + 0.000121920490224082*G0_4_5 - 0.000414529666761879*G0_4_6 + 0.000390145568717063*G0_4_8 - 0.00034137737262743*G0_5_3 + 0.000121920490224082*G0_5_4 + 0.000463297862851512*G0_5_5 + 0.00041452966676188*G0_5_7 - 0.000292609176537797*G0_5_8 + 0.000438913764806696*G0_5_9 + 0.000292609176537797*G0_6_3 - 0.000414529666761879*G0_6_4 - 0.000463297862851512*G0_6_6 - 0.000121920490224082*G0_6_7 + 0.00034137737262743*G0_6_8 - 0.000438913764806696*G0_6_9 + 0.000120114260739281*G0_7_1 - 0.000390145568717063*G0_7_3 + 0.00041452966676188*G0_7_5 - 0.000121920490224082*G0_7_6 + 0.000414529666761882*G0_7_7 - 0.000292609176537798*G0_7_8 - 0.000130048522905688*G0_8_2 + 0.000390145568717063*G0_8_4 - 0.000292609176537797*G0_8_5 + 0.00034137737262743*G0_8_6 - 0.000292609176537798*G0_8_7 - 0.00136550949050972*G0_8_8 - 0.000780291137434127*G0_8_9 + 0.000780291137434126*G0_9_3 + 0.000438913764806696*G0_9_5 - 0.000438913764806696*G0_9_6 - 0.000780291137434127*G0_9_8;
    A[30] = A[40] + 0.000110782075067808*G0_0_3 - 0.000110782075067808*G0_0_4 + 0.000115799379192256*G0_1_3 - 0.000113290727130032*G0_1_4 + 0.000113290727130032*G0_2_3 - 0.000115799379192256*G0_2_4 + 0.000110782075067808*G0_3_0 + 0.000115799379192256*G0_3_1 + 0.000113290727130032*G0_3_2 + 0.000869699496931788*G0_3_3 - 0.000214941308691345*G0_3_5 + 0.000161657538889709*G0_3_6 - 0.000332346225203424*G0_3_7 + 0.000494003764093133*G0_3_8 + 0.000764035072070915*G0_3_9 - 0.000110782075067808*G0_4_0 - 0.000113290727130032*G0_4_1 - 0.000115799379192256*G0_4_2 - 0.000869699496931786*G0_4_4 + 0.000332346225203424*G0_4_5 - 0.000494003764093133*G0_4_6 + 0.000214941308691345*G0_4_7 - 0.000161657538889709*G0_4_8 - 0.000764035072070915*G0_4_9 - 0.000214941308691345*G0_5_3 + 0.000332346225203424*G0_5_4 + 0.00028177179962899*G0_5_6 + 0.000195072784358532*G0_5_9 + 0.000161657538889709*G0_6_3 - 0.000494003764093133*G0_6_4 + 0.00028177179962899*G0_6_5 - 0.000506647370486742*G0_6_6 - 0.000422657699443485*G0_6_9 - 0.000332346225203424*G0_7_3 + 0.000214941308691345*G0_7_4 - 0.00028177179962899*G0_7_8 - 0.000195072784358531*G0_7_9 + 0.000494003764093133*G0_8_3 - 0.000161657538889709*G0_8_4 - 0.00028177179962899*G0_8_7 + 0.000506647370486741*G0_8_8 + 0.000422657699443485*G0_8_9 + 0.000764035072070915*G0_9_3 - 0.000764035072070915*G0_9_4 + 0.000195072784358532*G0_9_5 - 0.000422657699443485*G0_9_6 - 0.000195072784358531*G0_9_7 + 0.000422657699443485*G0_9_8;
    A[28] = A[82];
    A[98] = A[89];
    A[80] = A[8];
    A[62] = A[26];
    A[50] = A[5];
    A[14] = A[41];
    A[39] = A[93];
    A[23] = A[32];
    A[19] = A[90] - 0.00015192396888828*G0_0_5 - 0.000117806300842035*G0_0_7 - 0.000399778792636003*G0_0_9 + 0.00015192396888828*G0_1_3 + 0.000117806300842035*G0_1_8 + 0.000399778792636003*G0_1_9 + 0.00015192396888828*G0_3_1 - 0.000482263272441924*G0_3_3 + 0.0001481108177537*G0_3_7 - 0.000247453439417767*G0_3_8 - 0.00149555801341541*G0_3_9 - 0.000270934422720183*G0_4_4 - 0.00015192396888828*G0_5_0 + 0.000482263272441924*G0_5_5 + 0.000247453439417767*G0_5_7 - 0.0001481108177537*G0_5_8 + 0.00149555801341541*G0_5_9 + 0.000270934422720182*G0_6_6 - 0.000117806300842035*G0_7_0 + 0.0001481108177537*G0_7_3 + 0.000247453439417767*G0_7_5 + 0.000211328849721742*G0_7_7 + 0.00139802162123614*G0_7_9 + 0.000117806300842035*G0_8_1 - 0.000247453439417767*G0_8_3 - 0.0001481108177537*G0_8_5 - 0.000211328849721743*G0_8_8 - 0.00139802162123614*G0_8_9 - 0.000399778792636003*G0_9_0 + 0.000399778792636003*G0_9_1 - 0.00149555801341541*G0_9_3 + 0.00149555801341541*G0_9_5 + 0.00139802162123614*G0_9_7 - 0.00139802162123614*G0_9_8;
    A[87] = A[78];
    A[42] = A[7] - 0.000691930837020239*G0_0_0 - 0.000446640413158345*G0_0_5 + 0.000267623001998047*G0_0_6 - 0.000842405362494789*G0_0_7 + 0.000343785678607165*G0_0_8 - 0.00015192396888828*G0_0_9 + 0.000166674843014157*G0_1_4 - 0.000166674843014157*G0_1_7 + 0.000691930837020239*G0_2_2 - 0.000343785678607165*G0_2_3 + 0.00084240536249479*G0_2_4 - 0.000267623001998047*G0_2_5 + 0.000446640413158345*G0_2_6 + 0.00015192396888828*G0_2_9 - 0.000343785678607165*G0_3_2 + 0.000143896282289164*G0_3_3 - 0.000719481411445819*G0_3_4 + 0.000155937812187839*G0_3_5 - 0.000265816772513246*G0_3_6 + 0.000166674843014157*G0_4_1 + 0.00084240536249479*G0_4_2 - 0.000719481411445819*G0_4_3 + 0.0015247587234197*G0_4_4 - 0.000254979395604439*G0_4_5 + 0.000520796168117684*G0_4_6 - 0.000446640413158345*G0_5_0 - 0.000267623001998047*G0_5_2 + 0.000155937812187839*G0_5_3 - 0.000254979395604439*G0_5_4 - 0.000410917207792276*G0_5_5 - 0.000520796168117684*G0_5_7 + 0.000265816772513245*G0_5_8 + 0.000267623001998047*G0_6_0 + 0.000446640413158345*G0_6_2 - 0.000265816772513246*G0_6_3 + 0.000520796168117684*G0_6_4 + 0.000410917207792277*G0_6_6 + 0.000254979395604438*G0_6_7 - 0.000155937812187838*G0_6_8 - 0.000842405362494789*G0_7_0 - 0.000166674843014157*G0_7_1 - 0.000520796168117684*G0_7_5 + 0.000254979395604438*G0_7_6 - 0.00152475872341969*G0_7_7 + 0.000719481411445818*G0_7_8 + 0.000343785678607165*G0_8_0 + 0.000265816772513245*G0_8_5 - 0.000155937812187838*G0_8_6 + 0.000719481411445818*G0_8_7 - 0.000143896282289163*G0_8_8 - 0.00015192396888828*G0_9_0 + 0.00015192396888828*G0_9_2;
    A[96] = A[69];
    A[65] = A[78] + 0.00028177179962899*G0_0_3 - 0.00028177179962899*G0_0_4 - 0.000413024475524546*G0_0_5 - 0.000280266608391655*G0_0_6 + 0.000413024475524545*G0_0_7 + 0.000280266608391656*G0_0_8 + 0.000330238957471157*G0_1_1 + 0.000306456935921274*G0_1_3 - 0.000294114367775132*G0_1_4 - 0.000184235407449724*G0_1_6 + 0.000719481411445819*G0_1_8 - 0.000330238957471156*G0_2_2 + 0.000294114367775132*G0_2_3 - 0.000306456935921273*G0_2_4 - 0.000719481411445819*G0_2_6 + 0.000184235407449724*G0_2_8 + 0.00028177179962899*G0_3_0 + 0.000306456935921274*G0_3_1 + 0.000294114367775132*G0_3_2 + 0.00117856473883279*G0_3_3 - 0.000568962287712384*G0_3_5 + 0.000552706222349174*G0_3_6 - 0.00084531539888697*G0_3_7 + 0.00139802162123614*G0_3_8 + 0.00151181407877862*G0_3_9 - 0.00028177179962899*G0_4_0 - 0.000294114367775132*G0_4_1 - 0.000306456935921273*G0_4_2 - 0.0011785647388328*G0_4_4 + 0.000845315398886971*G0_4_5 - 0.00139802162123614*G0_4_6 + 0.000568962287712384*G0_4_7 - 0.000552706222349173*G0_4_8 - 0.00151181407877862*G0_4_9 - 0.000413024475524546*G0_5_0 - 0.000568962287712384*G0_5_3 + 0.000845315398886971*G0_5_4 - 0.00174481768231798*G0_5_5 + 0.00262806390038577*G0_5_6 - 0.000292609176537797*G0_5_8 + 0.000585218353075594*G0_5_9 - 0.000280266608391655*G0_6_0 - 0.000184235407449724*G0_6_1 - 0.000719481411445819*G0_6_2 + 0.000552706222349174*G0_6_3 - 0.00139802162123614*G0_6_4 + 0.00262806390038577*G0_6_5 - 0.00292338242115078*G0_6_6 + 0.000292609176537799*G0_6_7 - 0.000926595725703026*G0_6_9 + 0.000413024475524545*G0_7_0 - 0.00084531539888697*G0_7_3 + 0.000568962287712384*G0_7_4 + 0.000292609176537799*G0_7_6 + 0.00174481768231797*G0_7_7 - 0.00262806390038577*G0_7_8 - 0.000585218353075596*G0_7_9 + 0.000280266608391656*G0_8_0 + 0.000719481411445819*G0_8_1 + 0.000184235407449724*G0_8_2 + 0.00139802162123614*G0_8_3 - 0.000552706222349173*G0_8_4 - 0.000292609176537798*G0_8_5 - 0.00262806390038577*G0_8_7 + 0.00292338242115077*G0_8_8 + 0.000926595725703026*G0_8_9 + 0.00151181407877862*G0_9_3 - 0.00151181407877862*G0_9_4 + 0.000585218353075593*G0_9_5 - 0.000926595725703026*G0_9_6 - 0.000585218353075596*G0_9_7 + 0.000926595725703026*G0_9_8;
    A[53] = A[35];
    A[70] = A[7];
    A[68] = A[86];
    A[6] = A[60];
    A[17] = A[71];
    A[9] = A[90];
    A[34] = A[78] + 0.000330238957471156*G0_0_0 - 0.000184235407449724*G0_0_4 + 0.000306456935921273*G0_0_5 - 0.000294114367775131*G0_0_6 + 0.000719481411445818*G0_0_7 - 0.000413024475524546*G0_1_3 - 0.000280266608391656*G0_1_4 + 0.00028177179962899*G0_1_5 - 0.00028177179962899*G0_1_6 + 0.000280266608391655*G0_1_7 + 0.000413024475524546*G0_1_8 - 0.000330238957471156*G0_2_2 - 0.000719481411445819*G0_2_4 + 0.000294114367775132*G0_2_5 - 0.000306456935921273*G0_2_6 + 0.000184235407449724*G0_2_7 - 0.000413024475524546*G0_3_1 - 0.00174481768231798*G0_3_3 + 0.00262806390038577*G0_3_4 - 0.000568962287712384*G0_3_5 + 0.000845315398886971*G0_3_6 - 0.000292609176537797*G0_3_7 + 0.000585218353075595*G0_3_9 - 0.000184235407449724*G0_4_0 - 0.000280266608391656*G0_4_1 - 0.000719481411445819*G0_4_2 + 0.00262806390038577*G0_4_3 - 0.00292338242115077*G0_4_4 + 0.000552706222349173*G0_4_5 - 0.00139802162123614*G0_4_6 + 0.000292609176537797*G0_4_8 - 0.000926595725703025*G0_4_9 + 0.000306456935921273*G0_5_0 + 0.00028177179962899*G0_5_1 + 0.000294114367775132*G0_5_2 - 0.000568962287712384*G0_5_3 + 0.000552706222349173*G0_5_4 + 0.00117856473883279*G0_5_5 + 0.00139802162123614*G0_5_7 - 0.00084531539888697*G0_5_8 + 0.00151181407877862*G0_5_9 - 0.000294114367775131*G0_6_0 - 0.00028177179962899*G0_6_1 - 0.000306456935921273*G0_6_2 + 0.000845315398886971*G0_6_3 - 0.00139802162123614*G0_6_4 - 0.0011785647388328*G0_6_6 - 0.000552706222349172*G0_6_7 + 0.000568962287712383*G0_6_8 - 0.00151181407877862*G0_6_9 + 0.000719481411445818*G0_7_0 + 0.000280266608391655*G0_7_1 + 0.000184235407449724*G0_7_2 - 0.000292609176537797*G0_7_3 + 0.00139802162123614*G0_7_5 - 0.000552706222349172*G0_7_6 + 0.00292338242115077*G0_7_7 - 0.00262806390038577*G0_7_8 + 0.000926595725703024*G0_7_9 + 0.000413024475524546*G0_8_1 + 0.000292609176537797*G0_8_4 - 0.00084531539888697*G0_8_5 + 0.000568962287712383*G0_8_6 - 0.00262806390038577*G0_8_7 + 0.00174481768231798*G0_8_8 - 0.000585218353075594*G0_8_9 + 0.000585218353075595*G0_9_3 - 0.000926595725703025*G0_9_4 + 0.00151181407877862*G0_9_5 - 0.00151181407877862*G0_9_6 + 0.000926595725703024*G0_9_7 - 0.000585218353075594*G0_9_8;
    A[24] = A[42];
    A[84] = A[48];
    A[59] = A[69] + 0.000160152347652374*G0_0_0 + 0.000146304588268899*G0_0_3 - 0.000471425895533118*G0_0_4 + 0.000341377372627431*G0_0_5 - 0.000552706222349173*G0_0_6 - 0.00139802162123614*G0_0_9 + 0.000195072784358532*G0_1_3 - 0.000422657699443485*G0_1_4 + 0.000764035072070915*G0_1_5 - 0.000764035072070915*G0_1_6 + 0.000422657699443485*G0_1_7 - 0.000195072784358532*G0_1_8 - 0.000160152347652375*G0_2_2 + 0.000552706222349173*G0_2_5 - 0.00034137737262743*G0_2_6 + 0.000471425895533118*G0_2_7 - 0.000146304588268899*G0_2_8 + 0.00139802162123614*G0_2_9 + 0.000146304588268899*G0_3_0 + 0.000195072784358532*G0_3_1 - 0.00126797309833046*G0_3_3 + 0.00151181407877862*G0_3_4 - 0.00136550949050972*G0_3_5 + 0.00229210521621275*G0_3_6 - 0.000438913764806697*G0_3_7 + 0.000877827529613394*G0_3_9 - 0.000471425895533118*G0_4_0 - 0.000422657699443485*G0_4_1 + 0.00151181407877862*G0_4_3 - 0.00448667404024623*G0_4_4 + 0.00141427768659936*G0_4_5 - 0.0037063829028121*G0_4_6 + 0.000438913764806695*G0_4_8 - 0.00702262023690714*G0_4_9 + 0.000341377372627431*G0_5_0 + 0.000764035072070915*G0_5_1 + 0.000552706222349173*G0_5_2 - 0.00136550949050972*G0_5_3 + 0.00141427768659936*G0_5_4 + 0.00585218353075594*G0_5_5 + 0.0037063829028121*G0_5_7 - 0.00229210521621274*G0_5_8 + 0.00877827529613392*G0_5_9 - 0.000552706222349173*G0_6_0 - 0.000764035072070915*G0_6_1 - 0.00034137737262743*G0_6_2 + 0.00229210521621275*G0_6_3 - 0.0037063829028121*G0_6_4 - 0.00585218353075594*G0_6_6 - 0.00141427768659935*G0_6_7 + 0.00136550949050972*G0_6_8 - 0.00877827529613392*G0_6_9 + 0.000422657699443485*G0_7_1 + 0.000471425895533118*G0_7_2 - 0.000438913764806697*G0_7_3 + 0.0037063829028121*G0_7_5 - 0.00141427768659935*G0_7_6 + 0.00448667404024622*G0_7_7 - 0.00151181407877862*G0_7_8 + 0.00702262023690714*G0_7_9 - 0.000195072784358532*G0_8_1 - 0.000146304588268899*G0_8_2 + 0.000438913764806695*G0_8_4 - 0.00229210521621274*G0_8_5 + 0.00136550949050972*G0_8_6 - 0.00151181407877862*G0_8_7 + 0.00126797309833045*G0_8_8 - 0.000877827529613391*G0_8_9 - 0.00139802162123614*G0_9_0 + 0.00139802162123614*G0_9_2 + 0.000877827529613394*G0_9_3 - 0.00702262023690714*G0_9_4 + 0.00877827529613392*G0_9_5 - 0.00877827529613392*G0_9_6 + 0.00702262023690714*G0_9_7 - 0.000877827529613391*G0_9_8;
    A[47] = A[74];
    A[91] = A[19];
    A[66] = A[55] - 0.000629370629370736*G0_0_0 - 0.000154432620950504*G0_0_3 + 0.000276353111174586*G0_0_4 - 0.00149826735764261*G0_0_5 + 0.0011839834272872*G0_0_6 - 0.000410917207792276*G0_0_7 + 0.000147207703011299*G0_0_8 + 0.000211328849721742*G0_0_9 - 0.000117404916512079*G0_1_3 + 0.000332346225203424*G0_1_4 - 0.000869699496931786*G0_1_5 + 0.000869699496931786*G0_1_6 - 0.000332346225203424*G0_1_7 + 0.000117404916512079*G0_1_8 + 0.000629370629370735*G0_2_2 - 0.000147207703011299*G0_2_3 + 0.000410917207792277*G0_2_4 - 0.0011839834272872*G0_2_5 + 0.00149826735764261*G0_2_6 - 0.000276353111174586*G0_2_7 + 0.000154432620950504*G0_2_8 - 0.000211328849721742*G0_2_9 - 0.000154432620950504*G0_3_0 - 0.000117404916512079*G0_3_1 - 0.000147207703011299*G0_3_2 + 0.00050393802625954*G0_3_3 - 0.00117856473883279*G0_3_4 + 0.00153619817682344*G0_3_5 - 0.00260909849079536*G0_3_6 + 0.000463297862851513*G0_3_7 - 0.000926595725703026*G0_3_9 + 0.000276353111174586*G0_4_0 + 0.000332346225203424*G0_4_1 + 0.000410917207792277*G0_4_2 - 0.00117856473883279*G0_4_3 + 0.00196698390894853*G0_4_4 - 0.00082905933352376*G0_4_5 + 0.00343815782431912*G0_4_6 - 0.000463297862851512*G0_4_8 + 0.00229210521621275*G0_4_9 - 0.00149826735764261*G0_5_0 - 0.000869699496931786*G0_5_1 - 0.0011839834272872*G0_5_2 + 0.00153619817682344*G0_5_3 - 0.00082905933352376*G0_5_4 - 0.0141427768659935*G0_5_5 - 0.00343815782431911*G0_5_7 + 0.00260909849079535*G0_5_8 - 0.00585218353075594*G0_5_9 + 0.0011839834272872*G0_6_0 + 0.000869699496931786*G0_6_1 + 0.00149826735764261*G0_6_2 - 0.00260909849079536*G0_6_3 + 0.00343815782431912*G0_6_4 + 0.0141427768659935*G0_6_6 + 0.000829059333523755*G0_6_7 - 0.00153619817682343*G0_6_8 + 0.00585218353075594*G0_6_9 - 0.000410917207792276*G0_7_0 - 0.000332346225203424*G0_7_1 - 0.000276353111174586*G0_7_2 + 0.000463297862851513*G0_7_3 - 0.00343815782431911*G0_7_5 + 0.000829059333523755*G0_7_6 - 0.00196698390894852*G0_7_7 + 0.00117856473883279*G0_7_8 - 0.00229210521621274*G0_7_9 + 0.000147207703011299*G0_8_0 + 0.000117404916512079*G0_8_1 + 0.000154432620950504*G0_8_2 - 0.000463297862851512*G0_8_4 + 0.00260909849079535*G0_8_5 - 0.00153619817682343*G0_8_6 + 0.00117856473883279*G0_8_7 - 0.000503938026259538*G0_8_8 + 0.000926595725703024*G0_8_9 + 0.000211328849721742*G0_9_0 - 0.000211328849721742*G0_9_2 - 0.000926595725703026*G0_9_3 + 0.00229210521621275*G0_9_4 - 0.00585218353075594*G0_9_5 + 0.00585218353075594*G0_9_6 - 0.00229210521621274*G0_9_7 + 0.000926595725703023*G0_9_8;
    A[56] = A[65];
    A[77] = A[55] + 0.000115197302697322*G0_0_1 - 0.000115197302697322*G0_0_2 - 0.000927197802197961*G0_0_5 + 0.000400380869130938*G0_0_6 + 0.000927197802197958*G0_0_7 - 0.000400380869130936*G0_0_8 + 0.000115197302697322*G0_1_0 + 0.000148311509918678*G0_1_1 + 0.000186643713429459*G0_1_3 - 0.000131252675895555*G0_1_4 - 0.000455169830169907*G0_1_5 + 0.000172795954045982*G0_1_7 + 0.000143896282289164*G0_1_8 - 0.000270934422720182*G0_1_9 - 0.000115197302697322*G0_2_0 - 0.000148311509918678*G0_2_2 + 0.000131252675895555*G0_2_3 - 0.000186643713429459*G0_2_4 - 0.000172795954045983*G0_2_5 - 0.000143896282289164*G0_2_6 + 0.000455169830169906*G0_2_7 + 0.000270934422720182*G0_2_9 + 0.000186643713429459*G0_3_1 + 0.000131252675895555*G0_3_2 + 0.00050393802625954*G0_3_3 + 0.000568962287712382*G0_3_5 + 0.000276353111174587*G0_3_6 - 0.000227584915084957*G0_3_7 + 0.00050393802625954*G0_3_8 + 0.00126797309833045*G0_3_9 - 0.000131252675895555*G0_4_1 - 0.000186643713429459*G0_4_2 - 0.00050393802625954*G0_4_4 + 0.000227584915084954*G0_4_5 - 0.000503938026259541*G0_4_6 - 0.000568962287712381*G0_4_7 - 0.000276353111174587*G0_4_8 - 0.00126797309833046*G0_4_9 - 0.00092719780219796*G0_5_0 - 0.000455169830169907*G0_5_1 - 0.000172795954045983*G0_5_2 + 0.000568962287712382*G0_5_3 + 0.000227584915084954*G0_5_4 - 0.0144137112887137*G0_5_5 + 0.00174481768231798*G0_5_6 + 0.00136550949050972*G0_5_8 - 0.00273101898101944*G0_5_9 + 0.000400380869130938*G0_6_0 - 0.000143896282289164*G0_6_2 + 0.000276353111174587*G0_6_3 - 0.000503938026259541*G0_6_4 + 0.00174481768231798*G0_6_5 - 0.00223791833166871*G0_6_6 - 0.00136550949050972*G0_6_7 - 0.00136550949050972*G0_6_9 + 0.000927197802197958*G0_7_0 + 0.000172795954045982*G0_7_1 + 0.000455169830169906*G0_7_2 - 0.000227584915084957*G0_7_3 - 0.000568962287712381*G0_7_4 - 0.00136550949050972*G0_7_6 + 0.0144137112887137*G0_7_7 - 0.00174481768231797*G0_7_8 + 0.00273101898101944*G0_7_9 - 0.000400380869130936*G0_8_0 + 0.000143896282289164*G0_8_1 + 0.00050393802625954*G0_8_3 - 0.000276353111174586*G0_8_4 + 0.00136550949050972*G0_8_5 - 0.00174481768231797*G0_8_7 + 0.00223791833166871*G0_8_8 + 0.00136550949050972*G0_8_9 - 0.000270934422720182*G0_9_1 + 0.000270934422720182*G0_9_2 + 0.00126797309833045*G0_9_3 - 0.00126797309833046*G0_9_4 - 0.00273101898101944*G0_9_5 - 0.00136550949050972*G0_9_6 + 0.00273101898101944*G0_9_7 + 0.00136550949050972*G0_9_8;
    A[3] = A[30];
    A[12] = A[21];
    A[49] = A[94];
    A[33] = A[55] - 0.000777682139289414*G0_0_0 - 0.000117705954759546*G0_0_2 + 0.000807384579706146*G0_0_3 - 0.000138176555587293*G0_0_4 - 0.0015247587234197*G0_0_5 + 0.000678841248037792*G0_0_6 - 0.000714965837733815*G0_0_7 + 0.000610806604110278*G0_0_8 + 0.000482263272441925*G0_0_9 + 0.000777682139289414*G0_1_1 + 0.000117705954759546*G0_1_2 + 0.0015247587234197*G0_1_3 - 0.000678841248037792*G0_1_4 - 0.000807384579706144*G0_1_5 + 0.000138176555587293*G0_1_6 - 0.000610806604110279*G0_1_7 + 0.000714965837733816*G0_1_8 - 0.000482263272441924*G0_1_9 - 0.000117705954759546*G0_2_0 + 0.000117705954759546*G0_2_1 + 0.000636394855144963*G0_2_3 - 0.000160152347652375*G0_2_4 - 0.000636394855144962*G0_2_5 + 0.000160152347652374*G0_2_6 - 0.000506647370486742*G0_2_7 + 0.000506647370486741*G0_2_8 + 0.000807384579706146*G0_3_0 + 0.0015247587234197*G0_3_1 + 0.000636394855144964*G0_3_2 + 0.0168846332239218*G0_3_3 - 0.00292338242115078*G0_3_4 - 0.000414529666761878*G0_3_6 - 0.00242215373911844*G0_3_7 + 0.00394209585057866*G0_3_8 + 0.00629109729556264*G0_3_9 - 0.000138176555587293*G0_4_0 - 0.000678841248037792*G0_4_1 - 0.000160152347652375*G0_4_2 - 0.00292338242115078*G0_4_3 + 0.00223791833166871*G0_4_4 + 0.00041452966676188*G0_4_5 + 0.000967235889111052*G0_4_7 - 0.00151994211146022*G0_4_8 - 0.000829059333523759*G0_4_9 - 0.0015247587234197*G0_5_0 - 0.000807384579706144*G0_5_1 - 0.000636394855144962*G0_5_2 + 0.00041452966676188*G0_5_4 - 0.0168846332239218*G0_5_5 + 0.00292338242115077*G0_5_6 - 0.00394209585057865*G0_5_7 + 0.00242215373911843*G0_5_8 - 0.00629109729556264*G0_5_9 + 0.000678841248037792*G0_6_0 + 0.000138176555587293*G0_6_1 + 0.000160152347652374*G0_6_2 - 0.000414529666761878*G0_6_3 + 0.00292338242115077*G0_6_5 - 0.00223791833166871*G0_6_6 + 0.00151994211146022*G0_6_7 - 0.000967235889111052*G0_6_8 + 0.000829059333523759*G0_6_9 - 0.000714965837733815*G0_7_0 - 0.000610806604110279*G0_7_1 - 0.000506647370486742*G0_7_2 - 0.00242215373911844*G0_7_3 + 0.000967235889111052*G0_7_4 - 0.00394209585057865*G0_7_5 + 0.00151994211146022*G0_7_6 - 0.00196698390894852*G0_7_7 - 0.00448667404024622*G0_7_9 + 0.000610806604110278*G0_8_0 + 0.000714965837733816*G0_8_1 + 0.000506647370486741*G0_8_2 + 0.00394209585057866*G0_8_3 - 0.00151994211146022*G0_8_4 + 0.00242215373911843*G0_8_5 - 0.000967235889111052*G0_8_6 + 0.00196698390894853*G0_8_8 + 0.00448667404024622*G0_8_9 + 0.000482263272441925*G0_9_0 - 0.000482263272441924*G0_9_1 + 0.00629109729556264*G0_9_3 - 0.000829059333523759*G0_9_4 - 0.00629109729556264*G0_9_5 + 0.000829059333523759*G0_9_6 - 0.00448667404024622*G0_9_7 + 0.00448667404024622*G0_9_8;
    A[29] = A[92];
    A[81] = A[7] - 0.000715768606393727*G0_0_0 - 0.000446640413158345*G0_0_5 + 0.000220359997145748*G0_0_6 - 0.000953287783645086*G0_0_7 + 0.000534543581418672*G0_0_8 - 0.000117806300842035*G0_0_9 + 0.000715768606393729*G0_1_1 + 0.000446640413158347*G0_1_3 - 0.000220359997145749*G0_1_4 - 0.000534543581418672*G0_1_7 + 0.000953287783645089*G0_1_8 + 0.000117806300842035*G0_1_9 - 0.000115799379192256*G0_2_7 + 0.000115799379192256*G0_2_8 + 0.000446640413158347*G0_3_1 + 0.000714965837733816*G0_3_3 - 0.000306456935921274*G0_3_4 - 0.000288695679320728*G0_3_7 + 0.000636093816897495*G0_3_8 + 0.000223972456115351*G0_3_9 - 0.000220359997145749*G0_4_1 - 0.000306456935921274*G0_4_3 + 0.000186643713429459*G0_4_4 + 0.000185439560439592*G0_4_7 - 0.000347398137576767*G0_4_8 - 0.000446640413158345*G0_5_0 - 0.000714965837733814*G0_5_5 + 0.000306456935921273*G0_5_6 - 0.000636093816897494*G0_5_7 + 0.000288695679320727*G0_5_8 - 0.000223972456115351*G0_5_9 + 0.000220359997145748*G0_6_0 + 0.000306456935921273*G0_6_5 - 0.000186643713429459*G0_6_6 + 0.000347398137576767*G0_6_7 - 0.000185439560439591*G0_6_8 - 0.000953287783645086*G0_7_0 - 0.000534543581418672*G0_7_1 - 0.000115799379192256*G0_7_2 - 0.000288695679320728*G0_7_3 + 0.000185439560439592*G0_7_4 - 0.000636093816897494*G0_7_5 + 0.000347398137576767*G0_7_6 - 0.00149826735764261*G0_7_7 - 0.00034137737262743*G0_7_9 + 0.000534543581418672*G0_8_0 + 0.000953287783645088*G0_8_1 + 0.000115799379192256*G0_8_2 + 0.000636093816897495*G0_8_3 - 0.000347398137576767*G0_8_4 + 0.000288695679320727*G0_8_5 - 0.000185439560439591*G0_8_6 + 0.00149826735764261*G0_8_8 + 0.00034137737262743*G0_8_9 - 0.000117806300842035*G0_9_0 + 0.000117806300842035*G0_9_1 + 0.000223972456115351*G0_9_3 - 0.000223972456115351*G0_9_5 - 0.00034137737262743*G0_9_7 + 0.00034137737262743*G0_9_8;
    A[44] = A[66] - 0.000148311509918678*G0_0_0 - 0.000115197302697322*G0_0_2 + 0.000455169830169907*G0_0_4 - 0.000143896282289164*G0_0_5 - 0.000172795954045984*G0_0_6 - 0.000186643713429459*G0_0_7 + 0.000131252675895555*G0_0_8 + 0.000270934422720182*G0_0_9 + 0.000148311509918678*G0_1_1 + 0.000115197302697322*G0_1_2 + 0.000143896282289164*G0_1_3 + 0.000172795954045983*G0_1_4 - 0.000455169830169907*G0_1_6 - 0.000131252675895555*G0_1_7 + 0.000186643713429459*G0_1_8 - 0.000270934422720183*G0_1_9 - 0.000115197302697322*G0_2_0 + 0.000115197302697322*G0_2_1 - 0.000400380869130937*G0_2_3 + 0.00092719780219796*G0_2_4 + 0.000400380869130937*G0_2_5 - 0.00092719780219796*G0_2_6 + 0.000143896282289164*G0_3_1 - 0.000400380869130937*G0_3_2 + 0.00223791833166871*G0_3_3 - 0.00174481768231798*G0_3_4 + 0.00136550949050972*G0_3_6 - 0.000276353111174587*G0_3_7 + 0.00050393802625954*G0_3_8 + 0.00136550949050972*G0_3_9 + 0.000455169830169907*G0_4_0 + 0.000172795954045983*G0_4_1 + 0.00092719780219796*G0_4_2 - 0.00174481768231798*G0_4_3 + 0.0144137112887137*G0_4_4 - 0.00136550949050972*G0_4_5 - 0.000568962287712385*G0_4_7 - 0.000227584915084953*G0_4_8 + 0.00273101898101944*G0_4_9 - 0.000143896282289164*G0_5_0 + 0.000400380869130937*G0_5_2 - 0.00136550949050972*G0_5_4 - 0.00223791833166871*G0_5_5 + 0.00174481768231798*G0_5_6 - 0.00050393802625954*G0_5_7 + 0.000276353111174586*G0_5_8 - 0.00136550949050972*G0_5_9 - 0.000172795954045984*G0_6_0 - 0.000455169830169907*G0_6_1 - 0.00092719780219796*G0_6_2 + 0.00136550949050972*G0_6_3 + 0.00174481768231798*G0_6_5 - 0.0144137112887137*G0_6_6 + 0.000227584915084956*G0_6_7 + 0.000568962287712382*G0_6_8 - 0.00273101898101944*G0_6_9 - 0.000186643713429459*G0_7_0 - 0.000131252675895555*G0_7_1 - 0.000276353111174587*G0_7_3 - 0.000568962287712385*G0_7_4 - 0.00050393802625954*G0_7_5 + 0.000227584915084956*G0_7_6 - 0.000503938026259539*G0_7_7 - 0.00126797309833046*G0_7_9 + 0.000131252675895555*G0_8_0 + 0.000186643713429459*G0_8_1 + 0.00050393802625954*G0_8_3 - 0.000227584915084953*G0_8_4 + 0.000276353111174586*G0_8_5 + 0.000568962287712382*G0_8_6 + 0.000503938026259539*G0_8_8 + 0.00126797309833046*G0_8_9 + 0.000270934422720182*G0_9_0 - 0.000270934422720183*G0_9_1 + 0.00136550949050972*G0_9_3 + 0.00273101898101944*G0_9_4 - 0.00136550949050972*G0_9_5 - 0.00273101898101944*G0_9_6 - 0.00126797309833046*G0_9_7 + 0.00126797309833046*G0_9_8;
    A[63] = A[36];
    A[0] = A[1] + 0.00147235576923102*G0_0_0 + 0.000641780094905204*G0_0_5 - 0.000302978271728323*G0_0_6 + 0.00062023913586424*G0_0_7 - 0.000295719905094955*G0_0_8 + 0.000641780094905204*G0_5_0 + 0.000799356893107029*G0_5_5 - 0.000303546899529094*G0_5_6 + 0.000375093656343719*G0_5_7 - 0.000196076245183421*G0_5_8 + 0.00015192396888828*G0_5_9 - 0.000302978271728323*G0_6_0 - 0.000303546899529094*G0_6_5 + 0.000172494915798517*G0_6_6 - 0.000179017411160298*G0_6_7 + 0.00062023913586424*G0_7_0 + 0.000375093656343719*G0_7_5 - 0.000179017411160298*G0_7_6 + 0.000684159590409705*G0_7_7 - 0.00026541538818329*G0_7_8 + 0.000117806300842035*G0_7_9 - 0.000295719905094955*G0_8_0 - 0.000196076245183421*G0_8_5 - 0.00026541538818329*G0_8_7 + 0.00015192396888828*G0_9_5 + 0.000117806300842035*G0_9_7 + 0.000399778792636003*G0_9_9;
    A[79] = A[97];
    A[38] = A[83];
    A[20] = A[2];
    A[18] = A[81];
    A[88] = A[66] + 0.000117705954759546*G0_0_1 - 0.000117705954759546*G0_0_2 + 0.000506647370486742*G0_0_3 - 0.000506647370486742*G0_0_4 + 0.000160152347652374*G0_0_5 - 0.000636394855144963*G0_0_6 - 0.000160152347652375*G0_0_7 + 0.000636394855144963*G0_0_8 + 0.000117705954759546*G0_1_0 + 0.000777682139289415*G0_1_1 + 0.000714965837733816*G0_1_3 - 0.000610806604110278*G0_1_4 + 0.000138176555587293*G0_1_5 - 0.000807384579706144*G0_1_6 - 0.000678841248037792*G0_1_7 + 0.00152475872341969*G0_1_8 - 0.000482263272441926*G0_1_9 - 0.000117705954759546*G0_2_0 - 0.000777682139289413*G0_2_2 + 0.000610806604110278*G0_2_3 - 0.000714965837733815*G0_2_4 + 0.000678841248037791*G0_2_5 - 0.0015247587234197*G0_2_6 - 0.000138176555587293*G0_2_7 + 0.000807384579706144*G0_2_8 + 0.000482263272441925*G0_2_9 + 0.000506647370486742*G0_3_0 + 0.000714965837733816*G0_3_1 + 0.000610806604110278*G0_3_2 + 0.00196698390894852*G0_3_3 - 0.000967235889111054*G0_3_5 + 0.00242215373911843*G0_3_6 - 0.00151994211146023*G0_3_7 + 0.00394209585057865*G0_3_8 + 0.00448667404024623*G0_3_9 - 0.000506647370486742*G0_4_0 - 0.000610806604110278*G0_4_1 - 0.000714965837733815*G0_4_2 - 0.00196698390894853*G0_4_4 + 0.00151994211146023*G0_4_5 - 0.00394209585057866*G0_4_6 + 0.000967235889111053*G0_4_7 - 0.00242215373911843*G0_4_8 - 0.00448667404024623*G0_4_9 + 0.000160152347652374*G0_5_0 + 0.000138176555587293*G0_5_1 + 0.000678841248037791*G0_5_2 - 0.000967235889111054*G0_5_3 + 0.00151994211146023*G0_5_4 - 0.00223791833166871*G0_5_5 + 0.00292338242115078*G0_5_6 - 0.000414529666761882*G0_5_8 + 0.000829059333523759*G0_5_9 - 0.000636394855144963*G0_6_0 - 0.000807384579706144*G0_6_1 - 0.0015247587234197*G0_6_2 + 0.00242215373911843*G0_6_3 - 0.00394209585057866*G0_6_4 + 0.00292338242115078*G0_6_5 - 0.0168846332239218*G0_6_6 + 0.000414529666761883*G0_6_7 - 0.00629109729556264*G0_6_9 - 0.000160152347652375*G0_7_0 - 0.000678841248037792*G0_7_1 - 0.000138176555587293*G0_7_2 - 0.00151994211146023*G0_7_3 + 0.000967235889111053*G0_7_4 + 0.000414529666761884*G0_7_6 + 0.00223791833166871*G0_7_7 - 0.00292338242115077*G0_7_8 - 0.000829059333523759*G0_7_9 + 0.000636394855144963*G0_8_0 + 0.00152475872341969*G0_8_1 + 0.000807384579706144*G0_8_2 + 0.00394209585057865*G0_8_3 - 0.00242215373911843*G0_8_4 - 0.000414529666761882*G0_8_5 - 0.00292338242115077*G0_8_7 + 0.0168846332239218*G0_8_8 + 0.00629109729556264*G0_8_9 - 0.000482263272441926*G0_9_1 + 0.000482263272441925*G0_9_2 + 0.00448667404024623*G0_9_3 - 0.00448667404024623*G0_9_4 + 0.000829059333523759*G0_9_5 - 0.00629109729556264*G0_9_6 - 0.000829059333523759*G0_9_7 + 0.00629109729556264*G0_9_8;
    A[43] = A[34];
    A[95] = A[59];
    A[52] = A[25];
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class mass_matrix_f2_p3_q3_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  mass_matrix_f2_p3_q3_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q3_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Product(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1)), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q3_tensor_finite_element_0();
        break;
      }
    case 1:
      {
        return new mass_matrix_f2_p3_q3_tensor_finite_element_0();
        break;
      }
    case 2:
      {
        return new mass_matrix_f2_p3_q3_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new mass_matrix_f2_p3_q3_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q3_tensor_dofmap_0();
        break;
      }
    case 1:
      {
        return new mass_matrix_f2_p3_q3_tensor_dofmap_0();
        break;
      }
    case 2:
      {
        return new mass_matrix_f2_p3_q3_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new mass_matrix_f2_p3_q3_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q3_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
