// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __MASS_MATRIX_F2_P3_Q4_TENSOR_H
#define __MASS_MATRIX_F2_P3_Q4_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class mass_matrix_f2_p3_q4_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  mass_matrix_f2_p3_q4_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, -0.0288675134594813, -0.0166666666666667, 0.0782460796435952, 0.0606091526731326, 0.0349927106111882, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333333, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807677, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, -0.0288675134594813, -0.0166666666666667, 0.0782460796435952, 0.0606091526731326, 0.0349927106111882, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333333, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807677, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new mass_matrix_f2_p3_q4_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class mass_matrix_f2_p3_q4_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  mass_matrix_f2_p3_q4_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233824, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421162, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.0388807895679869, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968254, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977598, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0109971479845644, 0.00634920634920633, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406278, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977598, 0.026770604530526, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527351, -0.0109971479845643, 0.00634920634920644, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382571, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984127, -0.243432247780074, 0.0, 0.0544331053951818, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.0518410527573159, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924092, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087791, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233824, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421162, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.0388807895679869, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968254, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977598, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0109971479845644, 0.00634920634920633, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406278, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977598, 0.026770604530526, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527351, -0.0109971479845643, 0.00634920634920644, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382571, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984127, -0.243432247780074, 0.0, 0.0544331053951818, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.0518410527573159, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924092, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087791, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new mass_matrix_f2_p3_q4_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class mass_matrix_f2_p3_q4_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  mass_matrix_f2_p3_q4_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new mass_matrix_f2_p3_q4_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class mass_matrix_f2_p3_q4_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  mass_matrix_f2_p3_q4_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3*m.num_entities[1] + 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new mass_matrix_f2_p3_q4_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class mass_matrix_f2_p3_q4_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  mass_matrix_f2_p3_q4_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    150
    // Number of operations (multiply-add pairs) for tensor contraction: 5457
    // Total number of operations (multiply-add pairs):                  5616
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[0][0]*w[1][0]*(1.0);
    const double G0_0_1 = det*w[0][0]*w[1][1]*(1.0);
    const double G0_0_2 = det*w[0][0]*w[1][2]*(1.0);
    const double G0_0_3 = det*w[0][0]*w[1][3]*(1.0);
    const double G0_0_4 = det*w[0][0]*w[1][4]*(1.0);
    const double G0_0_5 = det*w[0][0]*w[1][5]*(1.0);
    const double G0_0_6 = det*w[0][0]*w[1][6]*(1.0);
    const double G0_0_7 = det*w[0][0]*w[1][7]*(1.0);
    const double G0_0_8 = det*w[0][0]*w[1][8]*(1.0);
    const double G0_0_9 = det*w[0][0]*w[1][9]*(1.0);
    const double G0_1_0 = det*w[0][1]*w[1][0]*(1.0);
    const double G0_1_1 = det*w[0][1]*w[1][1]*(1.0);
    const double G0_1_2 = det*w[0][1]*w[1][2]*(1.0);
    const double G0_1_3 = det*w[0][1]*w[1][3]*(1.0);
    const double G0_1_4 = det*w[0][1]*w[1][4]*(1.0);
    const double G0_1_5 = det*w[0][1]*w[1][5]*(1.0);
    const double G0_1_6 = det*w[0][1]*w[1][6]*(1.0);
    const double G0_1_7 = det*w[0][1]*w[1][7]*(1.0);
    const double G0_1_8 = det*w[0][1]*w[1][8]*(1.0);
    const double G0_1_9 = det*w[0][1]*w[1][9]*(1.0);
    const double G0_2_0 = det*w[0][2]*w[1][0]*(1.0);
    const double G0_2_1 = det*w[0][2]*w[1][1]*(1.0);
    const double G0_2_2 = det*w[0][2]*w[1][2]*(1.0);
    const double G0_2_3 = det*w[0][2]*w[1][3]*(1.0);
    const double G0_2_4 = det*w[0][2]*w[1][4]*(1.0);
    const double G0_2_5 = det*w[0][2]*w[1][5]*(1.0);
    const double G0_2_6 = det*w[0][2]*w[1][6]*(1.0);
    const double G0_2_7 = det*w[0][2]*w[1][7]*(1.0);
    const double G0_2_8 = det*w[0][2]*w[1][8]*(1.0);
    const double G0_2_9 = det*w[0][2]*w[1][9]*(1.0);
    const double G0_3_0 = det*w[0][3]*w[1][0]*(1.0);
    const double G0_3_1 = det*w[0][3]*w[1][1]*(1.0);
    const double G0_3_2 = det*w[0][3]*w[1][2]*(1.0);
    const double G0_3_3 = det*w[0][3]*w[1][3]*(1.0);
    const double G0_3_4 = det*w[0][3]*w[1][4]*(1.0);
    const double G0_3_5 = det*w[0][3]*w[1][5]*(1.0);
    const double G0_3_6 = det*w[0][3]*w[1][6]*(1.0);
    const double G0_3_7 = det*w[0][3]*w[1][7]*(1.0);
    const double G0_3_8 = det*w[0][3]*w[1][8]*(1.0);
    const double G0_3_9 = det*w[0][3]*w[1][9]*(1.0);
    const double G0_4_0 = det*w[0][4]*w[1][0]*(1.0);
    const double G0_4_1 = det*w[0][4]*w[1][1]*(1.0);
    const double G0_4_2 = det*w[0][4]*w[1][2]*(1.0);
    const double G0_4_3 = det*w[0][4]*w[1][3]*(1.0);
    const double G0_4_4 = det*w[0][4]*w[1][4]*(1.0);
    const double G0_4_5 = det*w[0][4]*w[1][5]*(1.0);
    const double G0_4_6 = det*w[0][4]*w[1][6]*(1.0);
    const double G0_4_7 = det*w[0][4]*w[1][7]*(1.0);
    const double G0_4_8 = det*w[0][4]*w[1][8]*(1.0);
    const double G0_4_9 = det*w[0][4]*w[1][9]*(1.0);
    const double G0_5_0 = det*w[0][5]*w[1][0]*(1.0);
    const double G0_5_1 = det*w[0][5]*w[1][1]*(1.0);
    const double G0_5_2 = det*w[0][5]*w[1][2]*(1.0);
    const double G0_5_3 = det*w[0][5]*w[1][3]*(1.0);
    const double G0_5_4 = det*w[0][5]*w[1][4]*(1.0);
    const double G0_5_5 = det*w[0][5]*w[1][5]*(1.0);
    const double G0_5_6 = det*w[0][5]*w[1][6]*(1.0);
    const double G0_5_7 = det*w[0][5]*w[1][7]*(1.0);
    const double G0_5_8 = det*w[0][5]*w[1][8]*(1.0);
    const double G0_5_9 = det*w[0][5]*w[1][9]*(1.0);
    const double G0_6_0 = det*w[0][6]*w[1][0]*(1.0);
    const double G0_6_1 = det*w[0][6]*w[1][1]*(1.0);
    const double G0_6_2 = det*w[0][6]*w[1][2]*(1.0);
    const double G0_6_3 = det*w[0][6]*w[1][3]*(1.0);
    const double G0_6_4 = det*w[0][6]*w[1][4]*(1.0);
    const double G0_6_5 = det*w[0][6]*w[1][5]*(1.0);
    const double G0_6_6 = det*w[0][6]*w[1][6]*(1.0);
    const double G0_6_7 = det*w[0][6]*w[1][7]*(1.0);
    const double G0_6_8 = det*w[0][6]*w[1][8]*(1.0);
    const double G0_6_9 = det*w[0][6]*w[1][9]*(1.0);
    const double G0_7_0 = det*w[0][7]*w[1][0]*(1.0);
    const double G0_7_1 = det*w[0][7]*w[1][1]*(1.0);
    const double G0_7_2 = det*w[0][7]*w[1][2]*(1.0);
    const double G0_7_3 = det*w[0][7]*w[1][3]*(1.0);
    const double G0_7_4 = det*w[0][7]*w[1][4]*(1.0);
    const double G0_7_5 = det*w[0][7]*w[1][5]*(1.0);
    const double G0_7_6 = det*w[0][7]*w[1][6]*(1.0);
    const double G0_7_7 = det*w[0][7]*w[1][7]*(1.0);
    const double G0_7_8 = det*w[0][7]*w[1][8]*(1.0);
    const double G0_7_9 = det*w[0][7]*w[1][9]*(1.0);
    const double G0_8_0 = det*w[0][8]*w[1][0]*(1.0);
    const double G0_8_1 = det*w[0][8]*w[1][1]*(1.0);
    const double G0_8_2 = det*w[0][8]*w[1][2]*(1.0);
    const double G0_8_3 = det*w[0][8]*w[1][3]*(1.0);
    const double G0_8_4 = det*w[0][8]*w[1][4]*(1.0);
    const double G0_8_5 = det*w[0][8]*w[1][5]*(1.0);
    const double G0_8_6 = det*w[0][8]*w[1][6]*(1.0);
    const double G0_8_7 = det*w[0][8]*w[1][7]*(1.0);
    const double G0_8_8 = det*w[0][8]*w[1][8]*(1.0);
    const double G0_8_9 = det*w[0][8]*w[1][9]*(1.0);
    const double G0_9_0 = det*w[0][9]*w[1][0]*(1.0);
    const double G0_9_1 = det*w[0][9]*w[1][1]*(1.0);
    const double G0_9_2 = det*w[0][9]*w[1][2]*(1.0);
    const double G0_9_3 = det*w[0][9]*w[1][3]*(1.0);
    const double G0_9_4 = det*w[0][9]*w[1][4]*(1.0);
    const double G0_9_5 = det*w[0][9]*w[1][5]*(1.0);
    const double G0_9_6 = det*w[0][9]*w[1][6]*(1.0);
    const double G0_9_7 = det*w[0][9]*w[1][7]*(1.0);
    const double G0_9_8 = det*w[0][9]*w[1][8]*(1.0);
    const double G0_9_9 = det*w[0][9]*w[1][9]*(1.0);
    
    // Compute element tensor
    A[108] = -1.35666802333532e-05*G0_0_0 - 1.02542959685864e-05*G0_0_1 - 2.27638322876525e-05*G0_0_2 + 3.8374324088628e-05*G0_0_3 - 4.15457558314897e-05*G0_0_4 - 4.09114694829171e-05*G0_0_5 - 6.66000666000979e-05*G0_0_6 - 2.72743129886115e-05*G0_0_7 + 2.69571698143254e-05*G0_0_8 - 5.89886304172295e-05*G0_0_9 - 1.02542959685865e-05*G0_1_0 + 1.01133434466821e-05*G0_1_1 - 2.52305014209894e-05*G0_1_2 + 3.07628879057603e-05*G0_1_3 - 5.3914339628651e-05*G0_1_4 + 4.59857602714962e-05*G0_1_5 - 7.29429300858212e-06*G0_1_6 - 3.48857491714812e-06*G0_1_7 + 6.97714983429626e-06*G0_1_8 + 2.85428856857564e-05*G0_1_9 - 2.27638322876525e-05*G0_2_0 - 2.52305014209894e-05*G0_2_1 - 0.000166253499586911*G0_2_2 + 0.000111951540523022*G0_2_3 - 0.000221048792477468*G0_2_4 + 6.88200688201013e-05*G0_2_5 - 0.000258471687043237*G0_2_6 + 2.69571698143254e-05*G0_2_8 - 0.000114171542743025*G0_2_9 + 3.8374324088628e-05*G0_3_0 + 3.07628879057603e-05*G0_3_1 + 0.000111951540523022*G0_3_2 - 3.42514628229032e-05*G0_3_3 + 0.00018838304552599*G0_3_4 - 0.000162694448408811*G0_3_5 + 9.41915227629953e-05*G0_3_6 - 4.28143285286352e-05*G0_3_7 + 5.13771942343626e-05*G0_3_8 - 4.15457558314897e-05*G0_4_0 - 5.3914339628651e-05*G0_4_1 - 0.000221048792477468*G0_4_2 + 0.00018838304552599*G0_4_3 - 0.000333951762523347*G0_4_4 + 0.000196945911231718*G0_4_5 - 0.000291137433994713*G0_4_6 + 2.5688597117181e-05*G0_4_7 - 8.56286570572749e-06*G0_4_8 - 5.13771942343618e-05*G0_4_9 - 4.09114694829171e-05*G0_5_0 + 4.59857602714962e-05*G0_5_1 + 6.88200688201013e-05*G0_5_2 - 0.000162694448408811*G0_5_3 + 0.000196945911231718*G0_5_4 + 0.000148423005565932*G0_5_5 + 0.000456686170972099*G0_5_6 - 5.70857713715104e-06*G0_5_7 - 6.56486370772395e-05*G0_5_8 + 0.000308263165406167*G0_5_9 - 6.66000666000979e-05*G0_6_0 - 7.29429300858213e-06*G0_6_1 - 0.000258471687043237*G0_6_2 + 9.41915227629953e-05*G0_6_3 - 0.000291137433994713*G0_6_4 + 0.000456686170972099*G0_6_5 - 8.27743684886927e-05*G0_6_6 + 7.13572142143905e-05*G0_6_7 - 6.56486370772395e-05*G0_6_8 + 0.000154131582703084*G0_6_9 - 2.72743129886115e-05*G0_7_0 - 3.48857491714812e-06*G0_7_1 - 4.28143285286352e-05*G0_7_3 + 2.5688597117181e-05*G0_7_4 - 5.70857713715105e-06*G0_7_5 + 7.13572142143905e-05*G0_7_6 - 1.71257314114531e-05*G0_7_7 - 8.56286570572747e-06*G0_7_8 + 3.42514628229074e-05*G0_7_9 + 2.69571698143254e-05*G0_8_0 + 6.97714983429626e-06*G0_8_1 + 2.69571698143254e-05*G0_8_2 + 5.13771942343626e-05*G0_8_3 - 8.56286570572749e-06*G0_8_4 - 6.56486370772395e-05*G0_8_5 - 6.56486370772394e-05*G0_8_6 - 8.56286570572747e-06*G0_8_7 + 5.13771942343624e-05*G0_8_8 - 6.85029256458144e-05*G0_8_9 - 5.89886304172295e-05*G0_9_0 + 2.85428856857564e-05*G0_9_1 - 0.000114171542743025*G0_9_2 - 5.13771942343618e-05*G0_9_4 + 0.000308263165406167*G0_9_5 + 0.000154131582703084*G0_9_6 + 3.42514628229074e-05*G0_9_7 - 6.85029256458144e-05*G0_9_8 + 0.000513771942343613*G0_9_9;
    A[99] = 0.000687378465156565*G0_0_0 + 8.81423103645739e-05*G0_0_1 + 8.81423103645738e-05*G0_0_2 - 2.07200207200305e-05*G0_0_3 - 2.07200207200305e-05*G0_0_4 + 0.000814000814001195*G0_0_5 - 0.000375920375920552*G0_0_6 + 0.000814000814001196*G0_0_7 - 0.000375920375920552*G0_0_8 + 0.000248640248640365*G0_0_9 + 8.81423103645739e-05*G0_1_0 + 3.50971779543373e-05*G0_1_1 + 2.66400266400391e-05*G0_1_2 - 1.94514480228858e-05*G0_1_3 - 1.56457299314516e-05*G0_1_4 + 0.000227920227920335*G0_1_5 - 9.68343825487138e-05*G0_1_6 + 0.000248640248640365*G0_1_7 - 0.000110365824651591*G0_1_8 + 0.000124320124320183*G0_1_9 + 8.81423103645738e-05*G0_2_0 + 2.66400266400391e-05*G0_2_1 + 3.50971779543373e-05*G0_2_2 - 1.56457299314516e-05*G0_2_3 - 1.94514480228858e-05*G0_2_4 + 0.000248640248640365*G0_2_5 - 0.000110365824651591*G0_2_6 + 0.000227920227920335*G0_2_7 - 9.68343825487138e-05*G0_2_8 + 0.000124320124320183*G0_2_9 - 2.07200207200305e-05*G0_3_0 - 1.94514480228858e-05*G0_3_1 - 1.56457299314516e-05*G0_3_2 + 0.000205508776937445*G0_3_3 - 3.42514628229074e-05*G0_3_4 - 0.000186480186480274*G0_3_5 + 4.18628990057761e-05*G0_3_6 - 0.000186480186480274*G0_3_7 + 0.000144617287474498*G0_3_8 - 2.07200207200305e-05*G0_4_0 - 1.56457299314516e-05*G0_4_1 - 1.94514480228858e-05*G0_4_2 - 3.42514628229074e-05*G0_4_3 + 0.000205508776937445*G0_4_4 - 0.000186480186480274*G0_4_5 + 0.000144617287474498*G0_4_6 - 0.000186480186480274*G0_4_7 + 4.1862899005776e-05*G0_4_8 + 0.000814000814001195*G0_5_0 + 0.000227920227920335*G0_5_1 + 0.000248640248640366*G0_5_2 - 0.000186480186480274*G0_5_3 - 0.000186480186480274*G0_5_4 + 0.00279720279720411*G0_5_5 - 0.00111888111888164*G0_5_6 + 0.00186480186480274*G0_5_7 - 0.000932400932401371*G0_5_8 + 0.00111888111888165*G0_5_9 - 0.000375920375920552*G0_6_0 - 9.68343825487138e-05*G0_6_1 - 0.000110365824651591*G0_6_2 + 4.18628990057761e-05*G0_6_3 + 0.000144617287474498*G0_6_4 - 0.00111888111888164*G0_6_5 + 0.00054802340516652*G0_6_6 - 0.000932400932401371*G0_6_7 + 0.000414823271966324*G0_6_8 - 0.000456686170972101*G0_6_9 + 0.000814000814001195*G0_7_0 + 0.000248640248640365*G0_7_1 + 0.000227920227920335*G0_7_2 - 0.000186480186480274*G0_7_3 - 0.000186480186480274*G0_7_4 + 0.00186480186480274*G0_7_5 - 0.000932400932401371*G0_7_6 + 0.00279720279720412*G0_7_7 - 0.00111888111888165*G0_7_8 + 0.00111888111888164*G0_7_9 - 0.000375920375920552*G0_8_0 - 0.000110365824651591*G0_8_1 - 9.68343825487138e-05*G0_8_2 + 0.000144617287474498*G0_8_3 + 4.1862899005776e-05*G0_8_4 - 0.000932400932401371*G0_8_5 + 0.000414823271966324*G0_8_6 - 0.00111888111888165*G0_8_7 + 0.00054802340516652*G0_8_8 - 0.0004566861709721*G0_8_9 + 0.000248640248640365*G0_9_0 + 0.000124320124320183*G0_9_1 + 0.000124320124320183*G0_9_2 + 0.00111888111888165*G0_9_5 - 0.000456686170972101*G0_9_6 + 0.00111888111888164*G0_9_7 - 0.0004566861709721*G0_9_8 + 0.00123305266162467*G0_9_9;
    A[52] = A[108];
    A[125] = A[99] - 0.000652281287202228*G0_0_0 + 0.000248640248640366*G0_0_4 - 0.000924366638652786*G0_0_5 + 0.000624560624560918*G0_0_6 - 0.000833452262024082*G0_0_7 + 0.000360274645989101*G0_0_8 - 0.000124320124320183*G0_0_9 + 0.000264285978571817*G0_1_4 - 0.000324754610469049*G0_1_5 + 0.000324754610469049*G0_1_6 - 0.000264285978571817*G0_1_7 + 0.00065228128720223*G0_2_2 - 0.000360274645989101*G0_2_3 + 0.000833452262024083*G0_2_4 - 0.000624560624560919*G0_2_5 + 0.000924366638652788*G0_2_6 - 0.000248640248640366*G0_2_7 + 0.000124320124320183*G0_2_9 - 0.000360274645989101*G0_3_2 + 0.000342514628229075*G0_3_3 - 0.00108462965605874*G0_3_4 + 0.000601303458446599*G0_3_5 - 0.000974263831407147*G0_3_6 + 0.00022834308548605*G0_3_7 - 0.0004566861709721*G0_3_9 + 0.000248640248640366*G0_4_0 + 0.000264285978571817*G0_4_1 + 0.000833452262024083*G0_4_2 - 0.00108462965605874*G0_4_3 + 0.00259169402026667*G0_4_4 - 0.000745920745921097*G0_4_5 + 0.00172018457732824*G0_4_6 - 0.00022834308548605*G0_4_8 + 0.00111888111888164*G0_4_9 - 0.000924366638652786*G0_5_0 - 0.000324754610469049*G0_5_1 - 0.000624560624560919*G0_5_2 + 0.000601303458446599*G0_5_3 - 0.000745920745921097*G0_5_4 - 0.00224917939203759*G0_5_5 - 0.00172018457732824*G0_5_7 + 0.000974263831407147*G0_5_8 - 0.00157556728985375*G0_5_9 + 0.000624560624560918*G0_6_0 + 0.000324754610469049*G0_6_1 + 0.000924366638652788*G0_6_2 - 0.000974263831407147*G0_6_3 + 0.00172018457732824*G0_6_4 + 0.00224917939203759*G0_6_6 + 0.000745920745921096*G0_6_7 - 0.000601303458446598*G0_6_8 + 0.00157556728985375*G0_6_9 - 0.000833452262024081*G0_7_0 - 0.000264285978571817*G0_7_1 - 0.000248640248640366*G0_7_2 + 0.00022834308548605*G0_7_3 - 0.00172018457732824*G0_7_5 + 0.000745920745921096*G0_7_6 - 0.00259169402026667*G0_7_7 + 0.00108462965605874*G0_7_8 - 0.00111888111888165*G0_7_9 + 0.000360274645989101*G0_8_0 - 0.00022834308548605*G0_8_4 + 0.000974263831407147*G0_8_5 - 0.000601303458446598*G0_8_6 + 0.00108462965605874*G0_8_7 - 0.000342514628229076*G0_8_8 + 0.0004566861709721*G0_8_9 - 0.000124320124320183*G0_9_0 + 0.000124320124320183*G0_9_2 - 0.0004566861709721*G0_9_3 + 0.00111888111888164*G0_9_4 - 0.00157556728985375*G0_9_5 + 0.00157556728985375*G0_9_6 - 0.00111888111888165*G0_9_7 + 0.0004566861709721*G0_9_8;
    A[83] = A[125];
    A[80] = A[125] + 0.000207200207200305*G0_0_4 + 0.000128971557543047*G0_1_1 + 0.000134844579289087*G0_1_2 + 0.00037296037296055*G0_1_4 + 0.000134844579289087*G0_2_1 + 0.000687378465156567*G0_2_2 - 0.000565360565360832*G0_2_3 + 0.0016280016280024*G0_2_4 + 0.000124320124320183*G0_2_9 - 0.000565360565360832*G0_3_2 + 0.00114171542743025*G0_3_3 - 0.00223776223776329*G0_3_4 + 0.000156034441748801*G0_3_5 - 0.000186480186480275*G0_3_6 + 0.00024737167594322*G0_3_8 + 0.000207200207200305*G0_4_0 + 0.00037296037296055*G0_4_1 + 0.0016280016280024*G0_4_2 - 0.00223776223776329*G0_4_3 + 0.00839160839161235*G0_4_4 - 0.000745920745921098*G0_4_5 + 0.000932400932401373*G0_4_6 - 0.000186480186480275*G0_4_7 - 0.000186480186480273*G0_4_8 + 0.00111888111888165*G0_4_9 + 0.000156034441748801*G0_5_3 - 0.000745920745921098*G0_5_4 + 0.000186480186480274*G0_5_6 - 0.000205508776937445*G0_5_9 - 0.000186480186480275*G0_6_3 + 0.000932400932401373*G0_6_4 + 0.000186480186480274*G0_6_5 - 0.000932400932401372*G0_6_6 - 0.000186480186480275*G0_7_4 - 0.000205508776937445*G0_7_9 + 0.00024737167594322*G0_8_3 - 0.000186480186480273*G0_8_4 + 0.00031968031968047*G0_8_8 + 0.000205508776937445*G0_8_9 + 0.000124320124320183*G0_9_2 + 0.00111888111888165*G0_9_4 - 0.000205508776937445*G0_9_5 - 0.000205508776937445*G0_9_7 + 0.000205508776937445*G0_9_8 + 0.00041101755387489*G0_9_9;
    A[144] = A[99] + 0.000687378465156565*G0_0_0 + 0.000134844579289087*G0_0_1 + 0.0016280016280024*G0_0_7 - 0.000565360565360832*G0_0_8 + 0.000124320124320183*G0_0_9 + 0.000134844579289087*G0_1_0 + 0.000128971557543047*G0_1_1 + 0.000372960372960548*G0_1_7 + 0.000207200207200305*G0_2_7 + 0.00031968031968047*G0_3_3 - 0.000186480186480275*G0_3_7 + 0.000247371675943221*G0_3_8 + 0.000205508776937445*G0_3_9 - 0.000186480186480274*G0_4_7 - 0.000205508776937445*G0_4_9 - 0.000932400932401369*G0_5_5 + 0.000186480186480274*G0_5_6 + 0.000932400932401373*G0_5_7 - 0.000186480186480274*G0_5_8 + 0.000186480186480274*G0_6_5 - 0.000745920745921099*G0_6_7 + 0.000156034441748802*G0_6_8 - 0.000205508776937445*G0_6_9 + 0.0016280016280024*G0_7_0 + 0.000372960372960548*G0_7_1 + 0.000207200207200305*G0_7_2 - 0.000186480186480275*G0_7_3 - 0.000186480186480274*G0_7_4 + 0.000932400932401373*G0_7_5 - 0.000745920745921099*G0_7_6 + 0.00839160839161233*G0_7_7 - 0.00223776223776329*G0_7_8 + 0.00111888111888164*G0_7_9 - 0.000565360565360832*G0_8_0 + 0.000247371675943221*G0_8_3 - 0.000186480186480274*G0_8_5 + 0.000156034441748802*G0_8_6 - 0.00223776223776329*G0_8_7 + 0.00114171542743025*G0_8_8 + 0.000124320124320183*G0_9_0 + 0.000205508776937445*G0_9_3 - 0.000205508776937445*G0_9_4 - 0.000205508776937445*G0_9_6 + 0.00111888111888165*G0_9_7 + 0.00041101755387489*G0_9_9;
    A[176] = A[144] - 0.00121068819481575*G0_0_0 + 0.000248640248640366*G0_0_3 - 0.000757760757761113*G0_0_5 + 0.000368731797303399*G0_0_6 - 0.0025726654298095*G0_0_7 + 0.0015628815628823*G0_0_8 - 0.000192823049965998*G0_0_9 + 0.00121068819481575*G0_1_1 + 0.000757760757761114*G0_1_3 - 0.000368731797303399*G0_1_4 - 0.000248640248640366*G0_1_5 - 0.0015628815628823*G0_1_7 + 0.0025726654298095*G0_1_8 + 0.000192823049965998*G0_1_9 + 0.000213120213120313*G0_2_3 - 0.000213120213120313*G0_2_5 - 0.000553097695955099*G0_2_7 + 0.000553097695955099*G0_2_8 + 0.000248640248640366*G0_3_0 + 0.000757760757761114*G0_3_1 + 0.000213120213120313*G0_3_2 + 0.00133961276818483*G0_3_3 - 0.000806812235384042*G0_3_4 - 0.00022834308548605*G0_3_6 - 0.000745920745921096*G0_3_7 + 0.00240521383378639*G0_3_8 + 0.000913372341944199*G0_3_9 - 0.000368731797303399*G0_4_1 - 0.000806812235384043*G0_4_3 + 0.000334903192046207*G0_4_4 + 0.00022834308548605*G0_4_5 + 0.000943818086675673*G0_4_7 - 0.0016592930878653*G0_4_8 - 0.000456686170972099*G0_4_9 - 0.000757760757761113*G0_5_0 - 0.000248640248640366*G0_5_1 - 0.000213120213120313*G0_5_2 + 0.00022834308548605*G0_5_4 - 0.00133961276818483*G0_5_5 + 0.000806812235384043*G0_5_6 - 0.00240521383378639*G0_5_7 + 0.000745920745921096*G0_5_8 - 0.0009133723419442*G0_5_9 + 0.000368731797303399*G0_6_0 - 0.00022834308548605*G0_6_3 + 0.000806812235384043*G0_6_5 - 0.000334903192046207*G0_6_6 + 0.0016592930878653*G0_6_7 - 0.000943818086675674*G0_6_8 + 0.000456686170972101*G0_6_9 - 0.0025726654298095*G0_7_0 - 0.0015628815628823*G0_7_1 - 0.000553097695955099*G0_7_2 - 0.000745920745921096*G0_7_3 + 0.000943818086675673*G0_7_4 - 0.00240521383378639*G0_7_5 + 0.0016592930878653*G0_7_6 - 0.00949907235621967*G0_7_7 - 0.0027401170258326*G0_7_9 + 0.0015628815628823*G0_8_0 + 0.0025726654298095*G0_8_1 + 0.000553097695955099*G0_8_2 + 0.00240521383378639*G0_8_3 - 0.0016592930878653*G0_8_4 + 0.000745920745921096*G0_8_5 - 0.000943818086675674*G0_8_6 + 0.00949907235621968*G0_8_8 + 0.0027401170258326*G0_8_9 - 0.000192823049965998*G0_9_0 + 0.000192823049965998*G0_9_1 + 0.000913372341944199*G0_9_3 - 0.000456686170972099*G0_9_4 - 0.0009133723419442*G0_9_5 + 0.000456686170972101*G0_9_6 - 0.0027401170258326*G0_9_7 + 0.0027401170258326*G0_9_8;
    A[56] = A[99] - 0.000652281287202228*G0_0_0 + 0.000248640248640366*G0_0_3 - 0.000833452262024081*G0_0_5 + 0.0003602746459891*G0_0_6 - 0.000924366638652787*G0_0_7 + 0.000624560624560918*G0_0_8 - 0.000124320124320183*G0_0_9 + 0.000652281287202229*G0_1_1 + 0.000833452262024082*G0_1_3 - 0.000360274645989101*G0_1_4 - 0.000248640248640366*G0_1_5 - 0.000624560624560918*G0_1_7 + 0.000924366638652788*G0_1_8 + 0.000124320124320183*G0_1_9 + 0.000264285978571817*G0_2_3 - 0.000264285978571817*G0_2_5 - 0.000324754610469049*G0_2_7 + 0.000324754610469049*G0_2_8 + 0.000248640248640366*G0_3_0 + 0.000833452262024082*G0_3_1 + 0.000264285978571817*G0_3_2 + 0.00259169402026667*G0_3_3 - 0.00108462965605874*G0_3_4 - 0.00022834308548605*G0_3_6 - 0.000745920745921097*G0_3_7 + 0.00172018457732824*G0_3_8 + 0.00111888111888164*G0_3_9 - 0.000360274645989101*G0_4_1 - 0.00108462965605874*G0_4_3 + 0.000342514628229075*G0_4_4 + 0.00022834308548605*G0_4_5 + 0.000601303458446598*G0_4_7 - 0.000974263831407146*G0_4_8 - 0.0004566861709721*G0_4_9 - 0.000833452262024081*G0_5_0 - 0.000248640248640366*G0_5_1 - 0.000264285978571817*G0_5_2 + 0.00022834308548605*G0_5_4 - 0.00259169402026667*G0_5_5 + 0.00108462965605874*G0_5_6 - 0.00172018457732824*G0_5_7 + 0.000745920745921097*G0_5_8 - 0.00111888111888165*G0_5_9 + 0.0003602746459891*G0_6_0 - 0.00022834308548605*G0_6_3 + 0.00108462965605874*G0_6_5 - 0.000342514628229075*G0_6_6 + 0.000974263831407147*G0_6_7 - 0.000601303458446598*G0_6_8 + 0.000456686170972101*G0_6_9 - 0.000924366638652786*G0_7_0 - 0.000624560624560918*G0_7_1 - 0.000324754610469049*G0_7_2 - 0.000745920745921097*G0_7_3 + 0.000601303458446598*G0_7_4 - 0.00172018457732824*G0_7_5 + 0.000974263831407147*G0_7_6 - 0.00224917939203759*G0_7_7 - 0.00157556728985374*G0_7_9 + 0.000624560624560918*G0_8_0 + 0.000924366638652788*G0_8_1 + 0.000324754610469049*G0_8_2 + 0.00172018457732824*G0_8_3 - 0.000974263831407146*G0_8_4 + 0.000745920745921097*G0_8_5 - 0.000601303458446598*G0_8_6 + 0.00224917939203759*G0_8_8 + 0.00157556728985374*G0_8_9 - 0.000124320124320183*G0_9_0 + 0.000124320124320183*G0_9_1 + 0.00111888111888164*G0_9_3 - 0.0004566861709721*G0_9_4 - 0.00111888111888165*G0_9_5 + 0.000456686170972101*G0_9_6 - 0.00157556728985375*G0_9_7 + 0.00157556728985374*G0_9_8;
    A[193] = -0.000118400118400174*G0_0_0 + 3.7211465782912e-05*G0_0_1 - 5.07429078857889e-05*G0_0_2 - 0.000456686170972101*G0_0_3 + 9.13372341944201e-05*G0_0_4 + 6.08914894629473e-05*G0_0_5 + 0.000197897340754577*G0_0_6 - 6.08914894629462e-05*G0_0_7 - 0.000289234574948997*G0_0_8 - 0.000548023405166521*G0_0_9 + 3.7211465782912e-05*G0_1_0 - 0.000118400118400174*G0_1_1 - 5.07429078857889e-05*G0_1_2 + 6.08914894629471e-05*G0_1_3 + 0.000197897340754577*G0_1_4 - 0.0004566861709721*G0_1_5 + 9.13372341944201e-05*G0_1_6 - 0.000289234574948997*G0_1_7 - 6.08914894629464e-05*G0_1_8 - 0.00054802340516652*G0_1_9 - 5.07429078857889e-05*G0_2_0 - 5.07429078857889e-05*G0_2_1 + 3.38286052571921e-06*G0_2_2 - 0.000106560106560157*G0_2_3 + 0.000121782978925893*G0_2_4 - 0.000106560106560157*G0_2_5 + 0.000121782978925893*G0_2_6 + 9.13372341944199e-05*G0_2_7 + 9.13372341944199e-05*G0_2_8 + 0.00054802340516652*G0_2_9 - 0.000456686170972101*G0_3_0 + 6.08914894629471e-05*G0_3_1 - 0.000106560106560157*G0_3_2 - 0.00383616383616564*G0_3_3 + 0.000274011702583261*G0_3_4 + 0.00123305266162467*G0_3_5 + 0.00164407021549956*G0_3_7 - 0.00164407021549956*G0_3_8 - 0.00164407021549957*G0_3_9 + 9.13372341944201e-05*G0_4_0 + 0.000197897340754577*G0_4_1 + 0.000121782978925893*G0_4_2 + 0.000274011702583261*G0_4_3 - 0.000548023405166521*G0_4_4 - 0.00041101755387489*G0_4_7 - 0.00164407021549956*G0_4_9 + 6.08914894629473e-05*G0_5_0 - 0.0004566861709721*G0_5_1 - 0.000106560106560157*G0_5_2 + 0.00123305266162467*G0_5_3 - 0.00383616383616564*G0_5_5 + 0.00027401170258326*G0_5_6 - 0.00164407021549956*G0_5_7 + 0.00164407021549956*G0_5_8 - 0.00164407021549956*G0_5_9 + 0.000197897340754577*G0_6_0 + 9.13372341944201e-05*G0_6_1 + 0.000121782978925893*G0_6_2 + 0.00027401170258326*G0_6_5 - 0.00054802340516652*G0_6_6 - 0.00041101755387489*G0_6_8 - 0.00164407021549956*G0_6_9 - 6.08914894629462e-05*G0_7_0 - 0.000289234574948997*G0_7_1 + 9.13372341944199e-05*G0_7_2 + 0.00164407021549956*G0_7_3 - 0.00041101755387489*G0_7_4 - 0.00164407021549956*G0_7_5 - 0.000548023405166522*G0_7_7 + 0.00191808191808282*G0_7_8 + 0.00164407021549956*G0_7_9 - 0.000289234574948997*G0_8_0 - 6.08914894629465e-05*G0_8_1 + 9.13372341944199e-05*G0_8_2 - 0.00164407021549956*G0_8_3 + 0.00164407021549956*G0_8_5 - 0.00041101755387489*G0_8_6 + 0.00191808191808282*G0_8_7 - 0.000548023405166522*G0_8_8 + 0.00164407021549956*G0_8_9 - 0.000548023405166521*G0_9_0 - 0.00054802340516652*G0_9_1 + 0.00054802340516652*G0_9_2 - 0.00164407021549957*G0_9_3 - 0.00164407021549956*G0_9_4 - 0.00164407021549956*G0_9_5 - 0.00164407021549956*G0_9_6 + 0.00164407021549956*G0_9_7 + 0.00164407021549956*G0_9_8;
    A[192] = -A[193] + 0.000331520331520487*G0_0_0 - 0.00018267446838884*G0_0_3 + 0.00036534893677768*G0_0_4 - 0.000365348936777679*G0_0_5 + 0.00027401170258326*G0_0_6 - 0.000487131915703572*G0_0_7 - 0.000213120213120314*G0_0_8 - 0.00219209362066608*G0_0_9 + 0.000115017257874455*G0_1_1 - 0.000304457447314733*G0_1_3 + 0.000152228723657367*G0_1_4 + 0.0009133723419442*G0_1_5 - 0.00018267446838884*G0_1_6 + 0.000761143618286832*G0_1_7 - 0.000791589363018306*G0_1_8 + 0.00109604681033304*G0_1_9 + 0.000236800236800348*G0_2_2 - 0.000152228723657367*G0_2_3 - 0.000243565957851786*G0_2_4 + 0.000943818086675671*G0_2_5 - 0.000608914894629467*G0_2_6 + 0.00146139574711072*G0_2_7 - 0.00018267446838884*G0_2_8 + 0.00219209362066608*G0_2_9 - 0.00018267446838884*G0_3_0 - 0.000304457447314733*G0_3_1 - 0.000152228723657367*G0_3_2 - 0.00164407021549956*G0_3_3 - 0.000822035107749781*G0_3_5 - 0.00328814043099913*G0_3_9 + 0.00036534893677768*G0_4_0 + 0.000152228723657367*G0_4_1 - 0.000243565957851786*G0_4_2 + 0.00164407021549956*G0_4_4 - 0.00164407021549956*G0_4_5 + 0.00164407021549956*G0_4_6 - 0.00246610532324934*G0_4_7 - 0.00328814043099912*G0_4_9 - 0.00036534893677768*G0_5_0 + 0.000913372341944199*G0_5_1 + 0.000943818086675671*G0_5_2 - 0.000822035107749781*G0_5_3 - 0.00164407021549956*G0_5_4 + 0.00931639788783084*G0_5_5 - 0.00383616383616564*G0_5_6 + 0.0082203510774978*G0_5_7 - 0.00328814043099912*G0_5_8 + 0.0131525617239965*G0_5_9 + 0.00027401170258326*G0_6_0 - 0.00018267446838884*G0_6_1 - 0.000608914894629467*G0_6_2 + 0.00164407021549956*G0_6_4 - 0.00383616383616564*G0_6_5 + 0.0027401170258326*G0_6_6 - 0.00493221064649868*G0_6_7 + 0.000822035107749781*G0_6_8 - 0.00657628086199824*G0_6_9 - 0.000487131915703572*G0_7_0 + 0.000761143618286832*G0_7_1 + 0.00146139574711072*G0_7_2 - 0.00246610532324934*G0_7_4 + 0.0082203510774978*G0_7_5 - 0.00493221064649868*G0_7_6 + 0.01260453831883*G0_7_7 - 0.00219209362066608*G0_7_8 + 0.0164407021549956*G0_7_9 - 0.000213120213120314*G0_8_0 - 0.000791589363018307*G0_8_1 - 0.00018267446838884*G0_8_2 - 0.00328814043099912*G0_8_5 + 0.000822035107749781*G0_8_6 - 0.00219209362066608*G0_8_7 + 0.0027401170258326*G0_8_8 - 0.00328814043099912*G0_8_9 - 0.00219209362066608*G0_9_0 + 0.00109604681033304*G0_9_1 + 0.00219209362066608*G0_9_2 - 0.00328814043099913*G0_9_3 - 0.00328814043099912*G0_9_4 + 0.0131525617239965*G0_9_5 - 0.00657628086199824*G0_9_6 + 0.0164407021549956*G0_9_7 - 0.00328814043099912*G0_9_8 + 0.0394576851719894*G0_9_9;
    A[208] = -A[193] + 0.000115017257874455*G0_0_0 + 0.0009133723419442*G0_0_3 - 0.00018267446838884*G0_0_4 - 0.000304457447314733*G0_0_5 + 0.000152228723657367*G0_0_6 - 0.000791589363018307*G0_0_7 + 0.000761143618286833*G0_0_8 + 0.00109604681033304*G0_0_9 + 0.000331520331520488*G0_1_1 - 0.00036534893677768*G0_1_3 + 0.00027401170258326*G0_1_4 - 0.00018267446838884*G0_1_5 + 0.00036534893677768*G0_1_6 - 0.000213120213120314*G0_1_7 - 0.000487131915703573*G0_1_8 - 0.00219209362066608*G0_1_9 + 0.000236800236800348*G0_2_2 + 0.000943818086675672*G0_2_3 - 0.000608914894629466*G0_2_4 - 0.000152228723657367*G0_2_5 - 0.000243565957851786*G0_2_6 - 0.00018267446838884*G0_2_7 + 0.00146139574711072*G0_2_8 + 0.00219209362066608*G0_2_9 + 0.0009133723419442*G0_3_0 - 0.00036534893677768*G0_3_1 + 0.000943818086675672*G0_3_2 + 0.00931639788783084*G0_3_3 - 0.00383616383616564*G0_3_4 - 0.000822035107749781*G0_3_5 - 0.00164407021549956*G0_3_6 - 0.00328814043099912*G0_3_7 + 0.0082203510774978*G0_3_8 + 0.0131525617239965*G0_3_9 - 0.00018267446838884*G0_4_0 + 0.00027401170258326*G0_4_1 - 0.000608914894629466*G0_4_2 - 0.00383616383616564*G0_4_3 + 0.0027401170258326*G0_4_4 + 0.00164407021549956*G0_4_6 + 0.00082203510774978*G0_4_7 - 0.00493221064649868*G0_4_8 - 0.00657628086199824*G0_4_9 - 0.000304457447314733*G0_5_0 - 0.00018267446838884*G0_5_1 - 0.000152228723657367*G0_5_2 - 0.000822035107749782*G0_5_3 - 0.00164407021549956*G0_5_5 - 0.00328814043099913*G0_5_9 + 0.000152228723657367*G0_6_0 + 0.00036534893677768*G0_6_1 - 0.000243565957851786*G0_6_2 - 0.00164407021549956*G0_6_3 + 0.00164407021549956*G0_6_4 + 0.00164407021549956*G0_6_6 - 0.00246610532324934*G0_6_8 - 0.00328814043099912*G0_6_9 - 0.000791589363018307*G0_7_0 - 0.000213120213120314*G0_7_1 - 0.00018267446838884*G0_7_2 - 0.00328814043099912*G0_7_3 + 0.00082203510774978*G0_7_4 + 0.0027401170258326*G0_7_7 - 0.00219209362066608*G0_7_8 - 0.00328814043099912*G0_7_9 + 0.000761143618286834*G0_8_0 - 0.000487131915703573*G0_8_1 + 0.00146139574711072*G0_8_2 + 0.0082203510774978*G0_8_3 - 0.00493221064649868*G0_8_4 - 0.00246610532324934*G0_8_6 - 0.00219209362066608*G0_8_7 + 0.01260453831883*G0_8_8 + 0.0164407021549956*G0_8_9 + 0.00109604681033304*G0_9_0 - 0.00219209362066608*G0_9_1 + 0.00219209362066608*G0_9_2 + 0.0131525617239965*G0_9_3 - 0.00657628086199824*G0_9_4 - 0.00328814043099913*G0_9_5 - 0.00328814043099912*G0_9_6 - 0.00328814043099912*G0_9_7 + 0.0164407021549956*G0_9_8 + 0.0394576851719895*G0_9_9;
    A[168] = A[56];
    A[222] = A[193] + 0.000548023405166521*G0_0_3 - 0.00054802340516652*G0_0_4 - 0.000121782978925894*G0_0_5 - 0.000487131915703573*G0_0_6 + 0.000121782978925893*G0_0_7 + 0.000487131915703574*G0_0_8 + 0.000121782978925893*G0_1_1 - 0.000304457447314734*G0_1_4 + 0.00054802340516652*G0_1_5 + 0.000182674468388841*G0_1_7 + 0.00018267446838884*G0_1_8 + 0.00109604681033304*G0_1_9 - 0.000121782978925893*G0_2_2 + 0.000304457447314734*G0_2_3 - 0.000182674468388839*G0_2_5 - 0.00018267446838884*G0_2_6 - 0.000548023405166519*G0_2_7 - 0.00109604681033304*G0_2_9 + 0.000548023405166521*G0_3_0 + 0.000304457447314734*G0_3_2 + 0.00328814043099912*G0_3_3 - 0.00164407021549956*G0_3_5 - 0.00164407021549956*G0_3_7 + 0.00164407021549956*G0_3_8 - 0.00054802340516652*G0_4_0 - 0.000304457447314734*G0_4_1 - 0.00328814043099912*G0_4_4 + 0.00164407021549956*G0_4_5 - 0.00164407021549956*G0_4_6 + 0.00164407021549956*G0_4_7 - 0.000121782978925894*G0_5_0 + 0.00054802340516652*G0_5_1 - 0.000182674468388839*G0_5_2 - 0.00164407021549956*G0_5_3 + 0.00164407021549956*G0_5_4 + 0.00328814043099912*G0_5_5 + 0.00164407021549956*G0_5_6 - 0.00164407021549956*G0_5_8 + 0.00328814043099912*G0_5_9 - 0.000487131915703573*G0_6_0 - 0.00018267446838884*G0_6_2 - 0.00164407021549956*G0_6_4 + 0.00164407021549956*G0_6_5 + 0.00164407021549956*G0_6_7 + 0.00328814043099912*G0_6_9 + 0.000121782978925893*G0_7_0 + 0.000182674468388841*G0_7_1 - 0.000548023405166519*G0_7_2 - 0.00164407021549956*G0_7_3 + 0.00164407021549956*G0_7_4 + 0.00164407021549956*G0_7_6 - 0.00328814043099911*G0_7_7 - 0.00164407021549956*G0_7_8 - 0.00328814043099912*G0_7_9 + 0.000487131915703574*G0_8_0 + 0.00018267446838884*G0_8_1 + 0.00164407021549956*G0_8_3 - 0.00164407021549956*G0_8_5 - 0.00164407021549956*G0_8_7 - 0.00328814043099912*G0_8_9 + 0.00109604681033304*G0_9_1 - 0.00109604681033304*G0_9_2 + 0.00328814043099912*G0_9_5 + 0.00328814043099912*G0_9_6 - 0.00328814043099912*G0_9_7 - 0.00328814043099912*G0_9_8;
    A[2] = A[108] + 0.000125383875383934*G0_2_2 - 0.000101280994138185*G0_2_3 + 0.000200698772127438*G0_2_4 + 0.000230444159015696*G0_2_6 + 0.000110405467548376*G0_2_9 - 0.000101280994138185*G0_3_2 - 0.000187312687312774*G0_3_4 + 0.000160806455449388*G0_3_5 + 0.000200698772127438*G0_4_2 - 0.000187312687312774*G0_4_3 + 0.000331142072213656*G0_4_4 - 0.000192902335759569*G0_4_5 + 0.000281043361400636*G0_4_6 + 0.000160806455449388*G0_5_3 - 0.000192902335759569*G0_5_4 - 0.000190568360211307*G0_5_5 - 0.000431131368631571*G0_5_6 - 0.000309065934066079*G0_5_9 + 0.000230444159015696*G0_6_2 + 0.000281043361400636*G0_6_4 - 0.000431131368631571*G0_6_5 - 0.000154934351362996*G0_6_9 + 0.000110405467548376*G0_9_2 - 0.000309065934066079*G0_9_5 - 0.000154934351362996*G0_9_6 - 0.000503603539318062*G0_9_9;
    A[7] = A[2] - 0.000433655850322721*G0_0_0 - 0.000329947829947985*G0_0_5 + 0.000164062128347919*G0_0_6 - 0.000193325193325284*G0_0_7 + 0.000197258099043906*G0_4_4 + 0.000136574734789085*G0_4_6 + 0.000117739403453744*G0_4_9 - 0.000329947829947985*G0_5_0 - 0.000444867632367841*G0_5_5 - 0.000127268564768624*G0_5_7 + 0.000164062128347919*G0_6_0 + 0.000136574734789085*G0_6_4 + 0.000224106250892071*G0_6_6 + 0.000131386470672247*G0_6_9 - 0.000193325193325284*G0_7_0 - 0.000127268564768624*G0_7_5 - 0.000109577922077973*G0_7_7 + 0.000117739403453744*G0_9_4 + 0.000131386470672247*G0_9_6 + 0.000208184672470485*G0_9_9;
    A[21] = A[2] - 0.000370061486133089*G0_5_5 + 0.000123106060606119*G0_5_6 - 0.000155930379144738*G0_5_7 - 0.000137630226916006*G0_5_9 + 0.000123106060606119*G0_6_5 - 0.000155930379144738*G0_7_5 - 0.000128725441225502*G0_7_7 - 0.000137630226916006*G0_9_5;
    A[202] = A[2] + 0.000103029686363068*G0_0_0 + 0.000303942089656517*G0_0_5 + 0.000183995898281699*G0_0_7 + 0.000197857697857791*G0_0_9 + 0.000103029686363068*G0_2_2 + 0.000183995898281699*G0_2_4 + 0.000303942089656518*G0_2_6 + 0.000197857697857791*G0_2_9 - 0.000138210004281494*G0_3_3 - 0.000189453403739208*G0_3_4 + 0.000327276889777043*G0_3_5 + 0.000113829622758248*G0_3_6 - 0.000108433233433282*G0_3_8 + 0.000105697873555071*G0_3_9 + 0.000183995898281699*G0_4_2 - 0.000189453403739208*G0_4_3 - 0.00019242662099814*G0_4_5 - 0.000208719851577095*G0_4_9 + 0.000303942089656517*G0_5_0 + 0.000327276889777043*G0_5_3 - 0.00019242662099814*G0_5_4 - 0.000642883901812776*G0_5_5 - 0.00101884722420484*G0_5_6 + 0.000113829622758248*G0_5_8 - 0.000821232339089869*G0_5_9 + 0.000303942089656518*G0_6_2 + 0.000113829622758248*G0_6_3 - 0.00101884722420484*G0_6_5 - 0.000642883901812777*G0_6_6 - 0.00019242662099814*G0_6_7 + 0.000327276889777043*G0_6_8 - 0.00082123233908987*G0_6_9 + 0.000183995898281699*G0_7_0 - 0.00019242662099814*G0_7_6 - 0.000189453403739208*G0_7_8 - 0.000208719851577094*G0_7_9 - 0.000108433233433282*G0_8_3 + 0.000113829622758248*G0_8_5 + 0.000327276889777043*G0_8_6 - 0.000189453403739208*G0_8_7 - 0.000138210004281494*G0_8_8 + 0.00010569787355507*G0_8_9 + 0.000197857697857791*G0_9_0 + 0.000197857697857791*G0_9_2 + 0.000105697873555071*G0_9_3 - 0.000208719851577095*G0_9_4 - 0.000821232339089869*G0_9_5 - 0.00082123233908987*G0_9_6 - 0.000208719851577094*G0_9_7 + 0.00010569787355507*G0_9_8 - 0.00247627372627488*G0_9_9;
    A[36] = A[2] + 0.000251769835103288*G0_2_2 + 0.00012210012210018*G0_2_4 - 0.000106963142677479*G0_2_5 + 0.000192677692677784*G0_2_6 + 0.00012210012210018*G0_4_2 - 0.000106963142677479*G0_5_2 - 0.000128160529946304*G0_5_5 - 0.000121441058941116*G0_5_7 + 0.000192677692677784*G0_6_2 + 0.000198655511155605*G0_6_6 - 0.000121441058941116*G0_7_5 - 0.000163214761429124*G0_7_7;
    A[1] = A[2];
    A[181] = A[1] + 0.000142357642357709*G0_3_9 - 0.000519525117739648*G0_5_5 - 0.000232520455734852*G0_5_7 + 0.000177203748632404*G0_5_8 - 0.000362851434280177*G0_5_9 - 0.000232520455734852*G0_7_5 + 0.000117159626088253*G0_7_8 - 0.000119077351220265*G0_7_9 + 0.000177203748632404*G0_8_5 + 0.000117159626088253*G0_8_7 + 0.000214874411303084*G0_8_9 + 0.000142357642357709*G0_9_3 - 0.000362851434280177*G0_9_5 - 0.000119077351220265*G0_9_7 + 0.000214874411303084*G0_9_8 - 0.000164299985728636*G0_9_9;
    A[10] = A[1] - 0.00043365585032272*G0_0_0 - 0.000193325193325284*G0_0_5 - 0.000329947829947984*G0_0_7 + 0.00016406212834792*G0_0_8 + 0.000197258099043906*G0_3_3 + 0.000136574734789085*G0_3_8 + 0.000117739403453745*G0_3_9 - 0.000193325193325284*G0_5_0 - 0.000109577922077973*G0_5_5 - 0.000127268564768624*G0_5_7 - 0.000329947829947984*G0_7_0 - 0.000127268564768624*G0_7_5 - 0.000444867632367841*G0_7_7 + 0.00016406212834792*G0_8_0 + 0.000136574734789085*G0_8_3 + 0.000224106250892071*G0_8_8 + 0.000131386470672247*G0_8_9 + 0.000117739403453745*G0_9_3 + 0.000131386470672247*G0_9_8 + 0.000208184672470485*G0_9_9;
    A[26] = A[1] + 0.000726603643270652*G0_1_1 + 0.000305250305250449*G0_1_3 - 0.000153120688835047*G0_1_4 - 0.000267913303627716*G0_1_7 + 0.00059782809782838*G0_1_8 + 0.000305250305250449*G0_3_1 + 0.000169309856809937*G0_3_3 + 0.000176594239094322*G0_3_8 - 0.000153120688835047*G0_4_1 - 0.000125157580514782*G0_5_5 - 0.000267913303627716*G0_7_1 - 0.000275305052090896*G0_7_8 + 0.00059782809782838*G0_8_1 + 0.000176594239094322*G0_8_3 - 0.000275305052090896*G0_8_7 + 0.00054164585414611*G0_8_8 - 0.000249928642785903*G0_9_9;
    A[158] = A[1] - 0.000125383875383934*G0_0_0 - 0.000200698772127437*G0_0_5 + 0.000101280994138184*G0_0_6 - 0.000230444159015696*G0_0_7 - 0.000110405467548377*G0_0_9 - 0.000200698772127437*G0_5_0 - 0.000331142072213655*G0_5_5 + 0.000187312687312775*G0_5_6 - 0.000281043361400636*G0_5_7 + 0.000192902335759569*G0_5_8 + 0.000101280994138184*G0_6_0 + 0.000187312687312775*G0_6_5 - 0.000160806455449388*G0_6_8 - 0.000230444159015696*G0_7_0 - 0.000281043361400636*G0_7_5 + 0.000431131368631571*G0_7_8 + 0.000154934351362995*G0_7_9 + 0.000192902335759569*G0_8_5 - 0.000160806455449388*G0_8_6 + 0.000431131368631571*G0_8_7 + 0.000190568360211307*G0_8_8 + 0.000309065934066079*G0_8_9 - 0.000110405467548377*G0_9_0 + 0.000154934351362995*G0_9_7 + 0.000309065934066079*G0_9_8 + 0.000503603539318062*G0_9_9;
    A[135] = A[1] + 0.00072660364327065*G0_0_0 + 0.000305250305250448*G0_0_5 - 0.000153120688835046*G0_0_6 + 0.000597828097828378*G0_0_7 - 0.000267913303627715*G0_0_8 - 0.000125157580514782*G0_3_3 + 0.000305250305250448*G0_5_0 + 0.000169309856809935*G0_5_5 + 0.000176594239094321*G0_5_7 - 0.000153120688835046*G0_6_0 + 0.000597828097828378*G0_7_0 + 0.000176594239094321*G0_7_5 + 0.000541645854146108*G0_7_7 - 0.000275305052090896*G0_7_8 - 0.000267913303627715*G0_8_0 - 0.000275305052090896*G0_8_7 - 0.000249928642785903*G0_9_9;
    A[16] = A[1] + 0.00104025604025653*G0_1_1 + 0.000352656602656769*G0_1_3 - 0.000167805078519443*G0_1_4 - 0.000167897578611944*G0_1_7 + 0.000360334110334281*G0_1_8 + 0.000352656602656769*G0_3_1 + 0.000281697469197601*G0_3_3 - 0.000124904857047773*G0_3_4 + 0.000149537962038032*G0_3_8 - 0.000167805078519443*G0_4_1 - 0.000124904857047773*G0_4_3 - 0.000167897578611944*G0_7_1 + 0.000114989177489232*G0_7_7 - 0.000149389301175086*G0_7_8 + 0.000360334110334281*G0_8_1 + 0.000149537962038032*G0_8_3 - 0.000149389301175086*G0_8_7 + 0.000321033133533285*G0_8_8;
    A[90] = A[135] + 0.000284900284900419*G0_0_5 - 0.000114700114700169*G0_0_6 - 0.000284900284900419*G0_0_7 + 0.000114700114700168*G0_0_8 + 0.000284900284900419*G0_5_0 + 0.00033300033300049*G0_5_5 - 0.000166500166500245*G0_5_6 - 0.000114700114700169*G0_6_0 - 0.000166500166500245*G0_6_5 - 0.000284900284900419*G0_7_0 - 0.00033300033300049*G0_7_7 + 0.000166500166500245*G0_7_8 + 0.000114700114700168*G0_8_0 + 0.000166500166500245*G0_8_7;
    A[117] = A[90] - 0.000925494258828027*G0_0_0 + 0.000112850112850166*G0_0_4 - 0.00127576127576187*G0_0_5 + 0.00041889327603633*G0_0_6 - 0.000684500684501006*G0_0_7 + 0.000410753267896318*G0_0_8 - 0.00027242598671183*G0_0_9 + 0.000114356542928025*G0_1_4 + 0.00028291814006113*G0_1_6 - 0.000200566629138151*G0_1_7 + 0.000212327355184599*G0_1_9 + 0.000116550116550171*G0_2_4 - 0.000472543329686409*G0_2_5 + 0.000172050172050253*G0_2_6 - 0.000360406788978387*G0_2_7 + 0.000138855853141633*G0_2_8 - 0.000444317587174938*G0_2_9 + 0.000406260406260596*G0_3_3 - 0.000357975357975526*G0_3_4 - 0.000154131582703084*G0_3_5 - 0.000596546310832306*G0_3_6 + 0.000124637267494469*G0_3_8 - 0.000716426430712484*G0_3_9 + 0.000112850112850166*G0_4_0 + 0.000114356542928025*G0_4_1 + 0.000116550116550171*G0_4_2 - 0.000357975357975526*G0_4_3 + 0.00129251700680333*G0_4_4 + 0.000682888540031718*G0_4_6 + 0.000245230959516788*G0_4_7 - 0.000164359450073813*G0_4_8 + 0.00150563721992364*G0_4_9 - 0.00127576127576187*G0_5_0 - 0.000472543329686409*G0_5_2 - 0.000154131582703084*G0_5_3 - 0.000362494648209098*G0_5_5 + 0.00172256315113539*G0_5_6 - 0.00174206745635399*G0_5_7 + 0.000408638980067742*G0_5_8 + 0.00041889327603633*G0_6_0 + 0.00028291814006113*G0_6_1 + 0.000172050172050253*G0_6_2 - 0.000596546310832306*G0_6_3 + 0.000682888540031718*G0_6_4 + 0.00172256315113539*G0_6_5 + 0.000939060939061381*G0_6_6 + 0.00133342847628624*G0_6_7 - 0.000758765044479686*G0_6_8 + 0.00252604538318943*G0_6_9 - 0.000684500684501006*G0_7_0 - 0.000200566629138151*G0_7_1 - 0.000360406788978387*G0_7_2 + 0.000245230959516788*G0_7_4 - 0.00174206745635399*G0_7_5 + 0.00133342847628624*G0_7_6 - 0.00338613767185355*G0_7_7 + 0.000922410922411355*G0_7_8 - 0.001849578992437*G0_7_9 + 0.000410753267896318*G0_8_0 + 0.000138855853141633*G0_8_2 + 0.000124637267494469*G0_8_3 - 0.000164359450073813*G0_8_4 + 0.000408638980067742*G0_8_5 - 0.000758765044479686*G0_8_6 + 0.000922410922411355*G0_8_7 - 0.000369154654869114*G0_8_8 - 0.000308263165406169*G0_8_9 - 0.00027242598671183*G0_9_0 + 0.000212327355184599*G0_9_1 - 0.000444317587174938*G0_9_2 - 0.000716426430712484*G0_9_3 + 0.00150563721992364*G0_9_4 + 0.00252604538318943*G0_9_6 - 0.001849578992437*G0_9_7 - 0.000308263165406169*G0_9_8 + 0.0027058655630097*G0_9_9;
    A[199] = A[117] + 0.000249485963771795*G0_0_0 + 0.000171257314114537*G0_0_4 + 0.000614623471766617*G0_0_5 + 0.00043004614433206*G0_0_7 - 0.000449074734789231*G0_0_8 + 0.000422434708149194*G0_0_9 - 0.000249485963771795*G0_1_1 - 0.000614623471766618*G0_1_3 - 0.000171257314114537*G0_1_6 + 0.000449074734789231*G0_1_7 - 0.000430046144332061*G0_1_8 - 0.000422434708149194*G0_1_9 - 0.000395794681509153*G0_2_3 + 0.000395794681509153*G0_2_5 + 0.000468103325246402*G0_2_7 - 0.000468103325246402*G0_2_8 - 0.000614623471766618*G0_3_1 - 0.000395794681509153*G0_3_2 - 0.000205508776937439*G0_3_3 + 0.00179820179820264*G0_3_4 + 0.000513771942343613*G0_3_6 + 0.000274011702583258*G0_3_7 - 0.00167832167832246*G0_3_8 + 0.000719280719281063*G0_3_9 + 0.000171257314114537*G0_4_0 + 0.00179820179820264*G0_4_3 - 0.000205508776937443*G0_4_4 - 0.000513771942343613*G0_4_5 - 0.000959040959041409*G0_4_7 + 0.00140430997573921*G0_4_8 + 0.00102754388468723*G0_4_9 + 0.000614623471766617*G0_5_0 + 0.000395794681509153*G0_5_2 - 0.000513771942343613*G0_5_4 + 0.000205508776937441*G0_5_5 - 0.00179820179820264*G0_5_6 + 0.00167832167832246*G0_5_7 - 0.000274011702583259*G0_5_8 - 0.000719280719281063*G0_5_9 - 0.000171257314114537*G0_6_1 + 0.000513771942343613*G0_6_3 - 0.00179820179820264*G0_6_5 + 0.000205508776937444*G0_6_6 - 0.00140430997573921*G0_6_7 + 0.000959040959041409*G0_6_8 - 0.00102754388468722*G0_6_9 + 0.00043004614433206*G0_7_0 + 0.000449074734789231*G0_7_1 + 0.000468103325246402*G0_7_2 + 0.000274011702583258*G0_7_3 - 0.000959040959041409*G0_7_4 + 0.00167832167832246*G0_7_5 - 0.00140430997573921*G0_7_6 + 0.00287712287712423*G0_7_7 + 0.00154131582703083*G0_7_9 - 0.000449074734789231*G0_8_0 - 0.000430046144332061*G0_8_1 - 0.000468103325246402*G0_8_2 - 0.00167832167832246*G0_8_3 + 0.00140430997573921*G0_8_4 - 0.000274011702583259*G0_8_5 + 0.00095904095904141*G0_8_6 - 0.00287712287712423*G0_8_8 - 0.00154131582703083*G0_8_9 + 0.000422434708149194*G0_9_0 - 0.000422434708149193*G0_9_1 + 0.000719280719281063*G0_9_3 + 0.00102754388468723*G0_9_4 - 0.000719280719281063*G0_9_5 - 0.00102754388468722*G0_9_6 + 0.00154131582703083*G0_9_7 - 0.00154131582703083*G0_9_8;
    A[214] = A[199] + 0.000296846011131864*G0_0_3 - 0.000296846011131865*G0_0_4 + 0.000121782978925894*G0_0_5 - 0.000289234574948997*G0_0_6 - 0.000121782978925893*G0_0_7 + 0.000289234574948996*G0_0_8 + 0.000296000296000435*G0_1_1 + 0.000829646543932648*G0_1_3 - 0.000563246277532256*G0_1_4 - 0.000433851862423495*G0_1_6 - 0.00027401170258326*G0_1_7 + 0.00050235478806931*G0_1_8 - 0.000228343085486049*G0_1_9 - 0.000296000296000435*G0_2_2 + 0.000563246277532256*G0_2_3 - 0.000829646543932647*G0_2_4 + 0.00027401170258326*G0_2_5 - 0.00050235478806931*G0_2_6 + 0.000433851862423494*G0_2_8 + 0.000228343085486049*G0_2_9 + 0.000296846011131864*G0_3_0 + 0.000829646543932648*G0_3_1 + 0.000563246277532256*G0_3_2 + 0.000822035107749773*G0_3_3 - 0.00054802340516652*G0_3_5 + 0.00130155558727049*G0_3_6 - 0.000890538033395594*G0_3_7 + 0.00219209362066608*G0_3_8 + 0.00246610532324933*G0_3_9 - 0.000296846011131865*G0_4_0 - 0.000563246277532256*G0_4_1 - 0.000829646543932647*G0_4_2 - 0.000822035107749782*G0_4_4 + 0.000890538033395596*G0_4_5 - 0.00219209362066608*G0_4_6 + 0.00054802340516652*G0_4_7 - 0.00130155558727048*G0_4_8 - 0.00246610532324934*G0_4_9 + 0.000121782978925894*G0_5_0 + 0.00027401170258326*G0_5_2 - 0.00054802340516652*G0_5_3 + 0.000890538033395596*G0_5_4 - 0.000685029256458151*G0_5_5 + 0.00116454973597886*G0_5_6 - 0.000205508776937445*G0_5_8 + 0.000411017553874891*G0_5_9 - 0.000289234574948997*G0_6_0 - 0.000433851862423495*G0_6_1 - 0.00050235478806931*G0_6_2 + 0.00130155558727049*G0_6_3 - 0.00219209362066608*G0_6_4 + 0.00116454973597886*G0_6_5 - 0.00438418724133216*G0_6_6 + 0.000205508776937446*G0_6_7 - 0.00328814043099912*G0_6_9 - 0.000121782978925893*G0_7_0 - 0.00027401170258326*G0_7_1 - 0.000890538033395594*G0_7_3 + 0.00054802340516652*G0_7_4 + 0.000205508776937446*G0_7_6 + 0.000685029256458149*G0_7_7 - 0.00116454973597885*G0_7_8 - 0.000411017553874888*G0_7_9 + 0.000289234574948996*G0_8_0 + 0.00050235478806931*G0_8_1 + 0.000433851862423494*G0_8_2 + 0.00219209362066608*G0_8_3 - 0.00130155558727048*G0_8_4 - 0.000205508776937445*G0_8_5 - 0.00116454973597885*G0_8_7 + 0.00438418724133216*G0_8_8 + 0.00328814043099911*G0_8_9 - 0.000228343085486049*G0_9_1 + 0.000228343085486049*G0_9_2 + 0.00246610532324933*G0_9_3 - 0.00246610532324934*G0_9_4 + 0.000411017553874891*G0_9_5 - 0.00328814043099912*G0_9_6 - 0.000411017553874888*G0_9_7 + 0.00328814043099911*G0_9_8;
    A[163] = A[199] - 0.000308263165406168*G0_0_3 - 0.00013700585129163*G0_0_4 + 0.000194091622663142*G0_0_5 - 0.000114171542743025*G0_0_6 - 0.000220731649303182*G0_0_8 - 0.000650777793635244*G0_0_9 + 0.000306360306360451*G0_1_3 + 0.000106560106560157*G0_1_4 - 0.000106560106560157*G0_1_7 - 0.00030636030636045*G0_1_8 + 0.000220731649303181*G0_2_3 + 0.000114171542743025*G0_2_5 - 0.000194091622663142*G0_2_6 + 0.00013700585129163*G0_2_7 + 0.000308263165406167*G0_2_8 + 0.000650777793635242*G0_2_9 - 0.000308263165406168*G0_3_0 + 0.000306360306360451*G0_3_1 + 0.000220731649303181*G0_3_2 - 0.00335664335664494*G0_3_3 - 0.000633652062223787*G0_3_4 + 0.00041101755387489*G0_3_5 + 0.000102754388468723*G0_3_6 + 0.000924789496218505*G0_3_7 - 0.00184957899243701*G0_3_9 - 0.00013700585129163*G0_4_0 + 0.000106560106560157*G0_4_1 - 0.000633652062223787*G0_4_3 - 0.00130155558727049*G0_4_4 + 0.00041101755387489*G0_4_5 - 0.000513771942343613*G0_4_6 - 0.000924789496218501*G0_4_8 - 0.00277436848865551*G0_4_9 + 0.000194091622663142*G0_5_0 + 0.000114171542743025*G0_5_2 + 0.00041101755387489*G0_5_3 + 0.00041101755387489*G0_5_4 + 0.000822035107749779*G0_5_5 + 0.000513771942343612*G0_5_7 - 0.000102754388468722*G0_5_8 + 0.00215784215784317*G0_5_9 - 0.000114171542743025*G0_6_0 - 0.000194091622663142*G0_6_2 + 0.000102754388468723*G0_6_3 - 0.000513771942343613*G0_6_4 - 0.000822035107749779*G0_6_6 - 0.00041101755387489*G0_6_7 - 0.00041101755387489*G0_6_8 - 0.00215784215784317*G0_6_9 - 0.000106560106560157*G0_7_1 + 0.00013700585129163*G0_7_2 + 0.000924789496218505*G0_7_3 + 0.000513771942343612*G0_7_5 - 0.00041101755387489*G0_7_6 + 0.00130155558727048*G0_7_7 + 0.000633652062223791*G0_7_8 + 0.00277436848865551*G0_7_9 - 0.000220731649303182*G0_8_0 - 0.00030636030636045*G0_8_1 + 0.000308263165406167*G0_8_2 - 0.000924789496218501*G0_8_4 - 0.000102754388468722*G0_8_5 - 0.00041101755387489*G0_8_6 + 0.00063365206222379*G0_8_7 + 0.00335664335664493*G0_8_8 + 0.001849578992437*G0_8_9 - 0.000650777793635244*G0_9_0 + 0.000650777793635242*G0_9_2 - 0.00184957899243701*G0_9_3 - 0.00277436848865551*G0_9_4 + 0.00215784215784317*G0_9_5 - 0.00215784215784317*G0_9_6 + 0.00277436848865551*G0_9_7 + 0.001849578992437*G0_9_8;
    A[165] = A[1] + 0.000251769835103286*G0_0_0 + 0.000122100122100179*G0_0_5 + 0.000192677692677783*G0_0_7 - 0.000106963142677479*G0_0_8 - 0.000163214761429124*G0_3_3 - 0.000121441058941116*G0_3_8 + 0.000122100122100179*G0_5_0 + 0.000192677692677783*G0_7_0 + 0.000198655511155604*G0_7_7 - 0.000106963142677479*G0_8_0 - 0.000121441058941116*G0_8_3 - 0.000128160529946305*G0_8_8;
    A[191] = A[1] + 0.000159269742603151*G0_0_0 + 0.000177653034795975*G0_0_5 - 0.00013499067070502*G0_0_6 + 0.000314724957582248*G0_0_7 - 0.000150306043163257*G0_0_8 - 0.000157250157250231*G0_1_3 + 0.000221303167731843*G0_1_5 + 0.000225191475191581*G0_1_7 - 0.00023837273837285*G0_1_8 + 0.000171217671217752*G0_1_9 + 0.000117508153222494*G0_2_5 - 0.000112931050431104*G0_2_8 - 0.000157250157250231*G0_3_1 - 0.000819225417440088*G0_3_3 + 0.000341444270015859*G0_3_4 - 0.000206058822130348*G0_3_5 + 0.000155796584368086*G0_3_7 - 0.000446592098378023*G0_3_8 - 0.000825246182389429*G0_3_9 + 0.000341444270015859*G0_4_3 - 0.000138210004281498*G0_4_4 - 0.000112283549783603*G0_4_7 + 0.000290795514009937*G0_4_8 + 0.000413961038961234*G0_4_9 + 0.000177653034795975*G0_5_0 + 0.000221303167731843*G0_5_1 + 0.000117508153222494*G0_5_2 - 0.000206058822130348*G0_5_3 + 0.00210356607678135*G0_5_5 - 0.000434922220636711*G0_5_6 + 0.0010148036487327*G0_5_7 - 0.000711907140478904*G0_5_8 + 0.00136684743827665*G0_5_9 - 0.00013499067070502*G0_6_0 - 0.000434922220636711*G0_6_5 + 0.000318476166690602*G0_6_6 - 0.000302896508253794*G0_6_7 + 0.000253065386994078*G0_6_8 + 0.000139949336377973*G0_6_9 + 0.000314724957582248*G0_7_0 + 0.000225191475191581*G0_7_1 + 0.000155796584368086*G0_7_3 - 0.000112283549783603*G0_7_4 + 0.0010148036487327*G0_7_5 - 0.000302896508253794*G0_7_6 + 0.000407494291423056*G0_7_7 - 0.000345235122020999*G0_7_8 + 0.000548826173826434*G0_7_9 - 0.000150306043163257*G0_8_0 - 0.00023837273837285*G0_8_1 - 0.000112931050431104*G0_8_2 - 0.000446592098378023*G0_8_3 + 0.000290795514009937*G0_8_4 - 0.000711907140478904*G0_8_5 + 0.000253065386994078*G0_8_6 - 0.000345235122020999*G0_8_7 - 0.000140529113743466*G0_8_8 - 0.00109524404167313*G0_8_9 + 0.000171217671217752*G0_9_1 - 0.000825246182389429*G0_9_3 + 0.000413961038961234*G0_9_4 + 0.00136684743827665*G0_9_5 + 0.000139949336377973*G0_9_6 + 0.000548826173826434*G0_9_7 - 0.00109524404167313*G0_9_8;
    A[205] = A[163];
    A[27] = A[181];
    A[46] = A[26] + 0.000284900284900419*G0_1_3 - 0.000114700114700168*G0_1_4 + 0.000114700114700169*G0_1_7 - 0.000284900284900419*G0_1_8 + 0.000284900284900419*G0_3_1 + 0.00033300033300049*G0_3_3 - 0.000166500166500245*G0_3_4 - 0.000114700114700168*G0_4_1 - 0.000166500166500245*G0_4_3 + 0.000114700114700169*G0_7_1 + 0.000166500166500245*G0_7_8 - 0.000284900284900419*G0_8_1 + 0.000166500166500245*G0_8_7 - 0.00033300033300049*G0_8_8;
    A[41] = A[1] - 0.000128725441225502*G0_3_3 - 0.000155930379144738*G0_3_8 + 0.000123106060606119*G0_7_8 - 0.000155930379144738*G0_8_3 + 0.000123106060606119*G0_8_7 - 0.000370061486133089*G0_8_8 - 0.000137630226916006*G0_8_9 - 0.000137630226916006*G0_9_8;
    A[164] = A[202] - 0.000112268683697307*G0_0_5 - 0.000129394415108762*G0_0_6 + 0.000112268683697309*G0_0_7 + 0.000129394415108761*G0_0_8 + 0.000102754388468722*G0_1_3 + 0.000102754388468722*G0_1_5 + 0.00021502307216603*G0_1_8 + 0.000262594548308958*G0_1_9 - 0.000102754388468722*G0_2_4 - 0.00021502307216603*G0_2_6 - 0.000102754388468722*G0_2_7 - 0.000262594548308958*G0_2_9 + 0.000102754388468722*G0_3_1 + 0.00020550877693744*G0_3_3 - 0.000274011702583259*G0_3_5 - 0.000239760239760351*G0_3_7 + 0.000171257314114535*G0_3_8 - 0.000308263165406173*G0_3_9 - 0.000102754388468722*G0_4_2 - 0.000205508776937444*G0_4_4 + 0.000239760239760352*G0_4_5 - 0.000171257314114536*G0_4_6 + 0.000274011702583259*G0_4_7 + 0.000308263165406171*G0_4_9 - 0.000112268683697307*G0_5_0 + 0.000102754388468722*G0_5_1 - 0.000274011702583259*G0_5_3 + 0.000239760239760352*G0_5_4 + 0.000753532182103965*G0_5_5 + 0.000804909376338324*G0_5_6 - 0.000308263165406167*G0_5_8 + 0.000616526330812336*G0_5_9 - 0.000129394415108762*G0_6_0 - 0.00021502307216603*G0_6_2 - 0.000171257314114536*G0_6_4 + 0.000804909376338324*G0_6_5 + 0.000548023405166522*G0_6_6 + 0.000308263165406167*G0_6_7 + 0.000924789496218505*G0_6_9 + 0.000112268683697309*G0_7_0 - 0.000102754388468722*G0_7_2 - 0.000239760239760351*G0_7_3 + 0.000274011702583259*G0_7_4 + 0.000308263165406167*G0_7_6 - 0.000753532182103965*G0_7_7 - 0.000804909376338326*G0_7_8 - 0.000616526330812334*G0_7_9 + 0.000129394415108761*G0_8_0 + 0.00021502307216603*G0_8_1 + 0.000171257314114535*G0_8_3 - 0.000308263165406167*G0_8_5 - 0.000804909376338325*G0_8_7 - 0.000548023405166524*G0_8_8 - 0.000924789496218508*G0_8_9 + 0.000262594548308958*G0_9_1 - 0.000262594548308958*G0_9_2 - 0.000308263165406173*G0_9_3 + 0.000308263165406171*G0_9_4 + 0.000616526330812336*G0_9_5 + 0.000924789496218505*G0_9_6 - 0.000616526330812334*G0_9_7 - 0.000924789496218508*G0_9_8;
    A[195] = A[1] - 0.000519525117739648*G0_3_3 + 0.000177203748632404*G0_3_7 - 0.000232520455734851*G0_3_8 - 0.000362851434280177*G0_3_9 + 0.00014235764235771*G0_5_9 + 0.000177203748632404*G0_7_3 + 0.000117159626088253*G0_7_8 + 0.000214874411303084*G0_7_9 - 0.000232520455734851*G0_8_3 + 0.000117159626088253*G0_8_7 - 0.000119077351220265*G0_8_9 - 0.000362851434280177*G0_9_3 + 0.00014235764235771*G0_9_5 + 0.000214874411303084*G0_9_7 - 0.000119077351220265*G0_9_8 - 0.000164299985728635*G0_9_9;
    A[14] = A[2] - 0.000519525117739648*G0_4_4 + 0.000177203748632404*G0_4_5 - 0.000232520455734851*G0_4_6 - 0.000362851434280177*G0_4_9 + 0.000177203748632404*G0_5_4 + 0.000117159626088253*G0_5_6 + 0.000214874411303084*G0_5_9 - 0.000232520455734851*G0_6_4 + 0.000117159626088253*G0_6_5 - 0.000119077351220265*G0_6_9 + 0.000142357642357709*G0_7_9 - 0.000362851434280177*G0_9_4 + 0.000214874411303084*G0_9_5 - 0.000119077351220265*G0_9_6 + 0.000142357642357709*G0_9_7 - 0.000164299985728635*G0_9_9;
    A[31] = A[2];
    A[35] = A[31] + 0.000726603643270652*G0_2_2 - 0.000267913303627716*G0_2_3 + 0.000597828097828379*G0_2_4 - 0.000153120688835047*G0_2_5 + 0.000305250305250449*G0_2_6 - 0.000267913303627716*G0_3_2 - 0.000275305052090896*G0_3_4 + 0.000597828097828379*G0_4_2 - 0.000275305052090896*G0_4_3 + 0.000541645854146109*G0_4_4 + 0.000176594239094322*G0_4_6 - 0.000153120688835047*G0_5_2 + 0.000305250305250449*G0_6_2 + 0.000176594239094322*G0_6_4 + 0.000169309856809936*G0_6_6 - 0.000125157580514782*G0_8_8 - 0.000249928642785903*G0_9_9;
    A[60] = A[31] - 0.000192352290566667*G0_3_4 - 0.000192352290566667*G0_4_3 - 0.00018356643356652*G0_9_9;
    A[211] = A[31] + 0.000117159626088253*G0_3_4 + 0.000177203748632403*G0_3_6 + 0.000214874411303084*G0_3_9 + 0.000117159626088253*G0_4_3 - 0.000232520455734851*G0_4_6 - 0.000119077351220264*G0_4_9 + 0.000177203748632403*G0_6_3 - 0.000232520455734851*G0_6_4 - 0.000519525117739648*G0_6_6 - 0.000362851434280176*G0_6_9 + 0.000142357642357709*G0_8_9 + 0.000214874411303084*G0_9_3 - 0.000119077351220264*G0_9_4 - 0.000362851434280176*G0_9_6 + 0.000142357642357709*G0_9_8 - 0.000164299985728634*G0_9_9;
    A[4] = A[60];
    A[47] = A[31] + 0.000251769835103287*G0_2_2 - 0.000106963142677479*G0_2_3 + 0.000192677692677784*G0_2_4 + 0.00012210012210018*G0_2_6 - 0.000106963142677479*G0_3_2 - 0.000128160529946304*G0_3_3 - 0.000121441058941116*G0_3_8 + 0.000192677692677784*G0_4_2 + 0.000198655511155605*G0_4_4 + 0.00012210012210018*G0_6_2 - 0.000121441058941116*G0_8_3 - 0.000163214761429124*G0_8_8;
    A[122] = A[35] + 0.000114700114700169*G0_2_3 - 0.000284900284900419*G0_2_4 - 0.000114700114700169*G0_2_5 + 0.000284900284900419*G0_2_6 + 0.000114700114700169*G0_3_2 + 0.000166500166500245*G0_3_4 - 0.000284900284900419*G0_4_2 + 0.000166500166500245*G0_4_3 - 0.00033300033300049*G0_4_4 - 0.000114700114700169*G0_5_2 - 0.000166500166500245*G0_5_6 + 0.000284900284900419*G0_6_2 - 0.000166500166500245*G0_6_5 + 0.00033300033300049*G0_6_6;
    A[72] = A[202] - 0.000102754388468722*G0_0_4 - 0.00021502307216603*G0_0_5 - 0.000102754388468722*G0_0_7 - 0.000262594548308958*G0_0_9 + 0.00021502307216603*G0_1_3 + 0.000102754388468723*G0_1_6 + 0.000102754388468722*G0_1_8 + 0.000262594548308958*G0_1_9 + 0.000129394415108761*G0_2_3 + 0.000112268683697309*G0_2_4 - 0.000129394415108762*G0_2_5 - 0.000112268683697307*G0_2_6 + 0.00021502307216603*G0_3_1 + 0.000129394415108761*G0_3_2 - 0.000548023405166524*G0_3_3 - 0.000804909376338325*G0_3_4 - 0.000308263165406168*G0_3_6 + 0.000171257314114534*G0_3_8 - 0.000924789496218507*G0_3_9 - 0.000102754388468722*G0_4_0 + 0.000112268683697309*G0_4_2 - 0.000804909376338325*G0_4_3 - 0.000753532182103966*G0_4_4 + 0.000308263165406167*G0_4_5 + 0.00027401170258326*G0_4_7 - 0.000239760239760351*G0_4_8 - 0.000616526330812333*G0_4_9 - 0.00021502307216603*G0_5_0 - 0.000129394415108762*G0_5_2 + 0.000308263165406167*G0_5_4 + 0.00054802340516652*G0_5_5 + 0.000804909376338324*G0_5_6 - 0.000171257314114537*G0_5_7 + 0.000924789496218504*G0_5_9 + 0.000102754388468723*G0_6_1 - 0.000112268683697307*G0_6_2 - 0.000308263165406168*G0_6_3 + 0.000804909376338324*G0_6_5 + 0.000753532182103967*G0_6_6 + 0.000239760239760352*G0_6_7 - 0.00027401170258326*G0_6_8 + 0.000616526330812337*G0_6_9 - 0.000102754388468722*G0_7_0 + 0.00027401170258326*G0_7_4 - 0.000171257314114537*G0_7_5 + 0.000239760239760352*G0_7_6 - 0.000205508776937445*G0_7_7 + 0.00030826316540617*G0_7_9 + 0.000102754388468722*G0_8_1 + 0.000171257314114534*G0_8_3 - 0.000239760239760351*G0_8_4 - 0.00027401170258326*G0_8_6 + 0.000205508776937442*G0_8_8 - 0.000308263165406172*G0_8_9 - 0.000262594548308958*G0_9_0 + 0.000262594548308958*G0_9_1 - 0.000924789496218507*G0_9_3 - 0.000616526330812333*G0_9_4 + 0.000924789496218504*G0_9_5 + 0.000616526330812336*G0_9_6 + 0.00030826316540617*G0_9_7 - 0.000308263165406172*G0_9_8;
    A[42] = A[2] + 0.000142357642357709*G0_4_9 + 0.000117159626088253*G0_5_6 - 0.000232520455734851*G0_5_7 - 0.000119077351220264*G0_5_9 + 0.000117159626088253*G0_6_5 + 0.000177203748632403*G0_6_7 + 0.000214874411303084*G0_6_9 - 0.000232520455734851*G0_7_5 + 0.000177203748632403*G0_7_6 - 0.000519525117739647*G0_7_7 - 0.000362851434280176*G0_7_9 + 0.000142357642357709*G0_9_4 - 0.000119077351220264*G0_9_5 + 0.000214874411303084*G0_9_6 - 0.000362851434280176*G0_9_7 - 0.000164299985728634*G0_9_9;
    A[139] = A[31] - 0.000125383875383934*G0_1_1 - 0.000230444159015696*G0_1_3 + 0.000101280994138185*G0_1_7 - 0.000200698772127438*G0_1_8 - 0.000110405467548377*G0_1_9 - 0.000230444159015696*G0_3_1 + 0.000431131368631571*G0_3_4 - 0.000281043361400636*G0_3_8 + 0.000154934351362996*G0_3_9 + 0.000431131368631571*G0_4_3 + 0.000190568360211307*G0_4_4 - 0.000160806455449388*G0_4_7 + 0.000192902335759569*G0_4_8 + 0.000309065934066079*G0_4_9 + 0.000101280994138185*G0_7_1 - 0.000160806455449388*G0_7_4 + 0.000187312687312775*G0_7_8 - 0.000200698772127438*G0_8_1 - 0.000281043361400636*G0_8_3 + 0.000192902335759569*G0_8_4 + 0.000187312687312775*G0_8_7 - 0.000331142072213656*G0_8_8 - 0.000110405467548377*G0_9_1 + 0.000154934351362996*G0_9_3 + 0.000309065934066079*G0_9_4 + 0.000503603539318062*G0_9_9;
    A[76] = A[47] + 0.00027844583400152*G0_1_1 + 0.000273113130256116*G0_1_3 - 0.000153920153920226*G0_1_4 + 0.00015275729561451*G0_1_8 - 0.000278445834001521*G0_2_2 + 0.000153920153920226*G0_2_3 - 0.000273113130256116*G0_2_4 - 0.000152757295614511*G0_2_6 + 0.000273113130256116*G0_3_1 + 0.000153920153920226*G0_3_2 + 0.000326816041101909*G0_3_3 - 0.00010418153275301*G0_3_7 + 0.000184815184815272*G0_3_8 + 0.000119880119880176*G0_3_9 - 0.000153920153920226*G0_4_1 - 0.000273113130256116*G0_4_2 - 0.000326816041101909*G0_4_4 + 0.00010418153275301*G0_4_5 - 0.000184815184815272*G0_4_6 - 0.000119880119880176*G0_4_9 + 0.00010418153275301*G0_5_4 - 0.000152757295614511*G0_6_2 - 0.000184815184815272*G0_6_4 - 0.000202654488368869*G0_6_6 - 0.00010418153275301*G0_7_3 + 0.00015275729561451*G0_8_1 + 0.000184815184815272*G0_8_3 + 0.000202654488368869*G0_8_8 + 0.000119880119880176*G0_9_3 - 0.000119880119880176*G0_9_4;
    A[107] = A[7] + 0.000517908017908261*G0_0_0 + 0.000423742923743123*G0_0_5 - 0.000237381665953206*G0_0_6 + 0.000246816675388219*G0_0_7 - 0.00012031619174482*G0_0_8 - 0.000517908017908263*G0_2_2 + 0.00012031619174482*G0_2_3 - 0.00024681667538822*G0_2_4 + 0.000237381665953206*G0_2_5 - 0.000423742923743123*G0_2_6 + 0.00012031619174482*G0_3_2 + 0.000129334950763583*G0_3_4 + 0.000153061224489868*G0_3_6 - 0.00024681667538822*G0_4_2 + 0.000129334950763583*G0_4_3 - 0.00030683602112188*G0_4_4 + 0.000110782075067842*G0_4_5 - 0.000263843299557709*G0_4_6 - 0.000120950478093392*G0_4_9 + 0.000423742923743123*G0_5_0 + 0.000237381665953206*G0_5_2 + 0.000110782075067842*G0_5_4 + 0.000668973883259911*G0_5_5 + 0.000263843299557709*G0_5_7 - 0.000153061224489868*G0_5_8 + 0.000205508776937445*G0_5_9 - 0.000237381665953206*G0_6_0 - 0.000423742923743123*G0_6_2 + 0.000153061224489868*G0_6_3 - 0.000263843299557709*G0_6_4 - 0.000668973883259913*G0_6_6 - 0.000110782075067841*G0_6_7 - 0.000205508776937445*G0_6_9 + 0.000246816675388219*G0_7_0 + 0.000263843299557709*G0_7_5 - 0.000110782075067841*G0_7_6 + 0.000306836021121879*G0_7_7 - 0.000129334950763583*G0_7_8 + 0.000120950478093392*G0_7_9 - 0.00012031619174482*G0_8_0 - 0.000153061224489868*G0_8_5 - 0.000129334950763583*G0_8_7 - 0.000120950478093392*G0_9_4 + 0.000205508776937445*G0_9_5 - 0.000205508776937445*G0_9_6 + 0.000120950478093392*G0_9_7;
    A[182] = A[42];
    A[20] = A[76];
    A[11] = A[165];
    A[51] = A[60] + 0.000545466438323836*G0_3_3 - 0.000104478854478903*G0_3_7 + 0.000120474763331962*G0_3_8 + 0.000221564150135682*G0_3_9 + 0.00019153465582046*G0_4_4 + 0.000105251890966226*G0_4_6 + 0.000516566766567009*G0_5_5 - 0.000202000380571904*G0_5_6 + 0.000177560534703475*G0_5_7 - 0.000111614575900342*G0_5_8 + 0.000116669045240529*G0_5_9 + 0.000105251890966226*G0_6_4 - 0.000202000380571904*G0_6_5 + 0.000108046715189623*G0_6_6 - 0.000104478854478903*G0_7_3 + 0.000177560534703475*G0_7_5 + 0.000113160648874987*G0_7_7 + 0.000120474763331962*G0_8_3 - 0.000111614575900342*G0_8_5 + 0.000221564150135682*G0_9_3 + 0.000116669045240529*G0_9_5 + 0.0003104038818326*G0_9_9;
    A[32] = A[2] + 0.00104025604025653*G0_2_2 - 0.000167805078519443*G0_2_3 + 0.000352656602656769*G0_2_4 - 0.000167897578611944*G0_2_5 + 0.000360334110334281*G0_2_6 - 0.000167805078519443*G0_3_2 - 0.000124904857047773*G0_3_4 + 0.000352656602656769*G0_4_2 - 0.000124904857047773*G0_4_3 + 0.000281697469197602*G0_4_4 + 0.000149537962038033*G0_4_6 - 0.000167897578611944*G0_5_2 + 0.000114989177489232*G0_5_5 - 0.000149389301175086*G0_5_6 + 0.000360334110334281*G0_6_2 + 0.000149537962038033*G0_6_4 - 0.000149389301175086*G0_6_5 + 0.000321033133533285*G0_6_6;
    A[212] = A[32] - 0.00084028625695332*G0_2_2 - 0.000193556443556535*G0_2_4 - 0.000193556443556535*G0_2_6 + 0.000123834498834557*G0_3_4 + 0.000119671994672051*G0_3_6 + 0.00019462680176975*G0_3_9 - 0.000193556443556535*G0_4_2 + 0.000123834498834557*G0_4_3 - 0.000428737928738131*G0_4_4 + 0.000119671994672051*G0_4_5 - 0.000239343989344102*G0_4_6 - 0.000330919080919236*G0_4_9 + 0.000119671994672051*G0_5_4 + 0.000123834498834557*G0_5_6 + 0.00019462680176975*G0_5_9 - 0.000193556443556535*G0_6_2 + 0.000119671994672051*G0_6_3 - 0.000239343989344102*G0_6_4 + 0.000123834498834557*G0_6_5 - 0.000428737928738131*G0_6_6 - 0.000330919080919237*G0_6_9 + 0.000196618857333235*G0_7_7 + 0.000141019694591189*G0_7_9 + 0.000196618857333235*G0_8_8 + 0.000141019694591189*G0_8_9 + 0.00019462680176975*G0_9_3 - 0.000330919080919236*G0_9_4 + 0.00019462680176975*G0_9_5 - 0.000330919080919237*G0_9_6 + 0.000141019694591189*G0_9_7 + 0.000141019694591189*G0_9_8 + 0.000387469673184141*G0_9_9;
    A[25] = A[10] + 0.000517908017908261*G0_0_0 + 0.00024681667538822*G0_0_5 - 0.00012031619174482*G0_0_6 + 0.000423742923743122*G0_0_7 - 0.000237381665953206*G0_0_8 - 0.000517908017908262*G0_1_1 - 0.00024681667538822*G0_1_3 + 0.00012031619174482*G0_1_4 + 0.000237381665953206*G0_1_7 - 0.000423742923743123*G0_1_8 - 0.00024681667538822*G0_3_1 - 0.00030683602112188*G0_3_3 + 0.000129334950763583*G0_3_4 + 0.000110782075067842*G0_3_7 - 0.000263843299557709*G0_3_8 - 0.000120950478093392*G0_3_9 + 0.00012031619174482*G0_4_1 + 0.000129334950763583*G0_4_3 + 0.000153061224489868*G0_4_8 + 0.00024681667538822*G0_5_0 + 0.000306836021121879*G0_5_5 - 0.000129334950763583*G0_5_6 + 0.000263843299557709*G0_5_7 - 0.000110782075067841*G0_5_8 + 0.000120950478093392*G0_5_9 - 0.00012031619174482*G0_6_0 - 0.000129334950763583*G0_6_5 - 0.000153061224489868*G0_6_7 + 0.000423742923743122*G0_7_0 + 0.000237381665953206*G0_7_1 + 0.000110782075067842*G0_7_3 + 0.000263843299557709*G0_7_5 - 0.000153061224489868*G0_7_6 + 0.000668973883259911*G0_7_7 + 0.000205508776937445*G0_7_9 - 0.000237381665953206*G0_8_0 - 0.000423742923743123*G0_8_1 - 0.000263843299557709*G0_8_3 + 0.000153061224489868*G0_8_4 - 0.000110782075067841*G0_8_5 - 0.000668973883259912*G0_8_8 - 0.000205508776937445*G0_8_9 - 0.000120950478093392*G0_9_3 + 0.000120950478093392*G0_9_5 + 0.000205508776937445*G0_9_7 - 0.000205508776937445*G0_9_8;
    A[61] = A[31] - 0.000433655850322721*G0_1_1 - 0.000329947829947985*G0_1_3 + 0.00016406212834792*G0_1_4 - 0.000193325193325284*G0_1_8 - 0.000329947829947985*G0_3_1 - 0.000444867632367841*G0_3_3 - 0.000127268564768625*G0_3_8 + 0.00016406212834792*G0_4_1 + 0.000224106250892071*G0_4_4 + 0.000136574734789085*G0_4_6 + 0.000131386470672247*G0_4_9 + 0.000136574734789085*G0_6_4 + 0.000197258099043906*G0_6_6 + 0.000117739403453745*G0_6_9 - 0.000193325193325284*G0_8_1 - 0.000127268564768625*G0_8_3 - 0.000109577922077974*G0_8_8 + 0.000131386470672247*G0_9_4 + 0.000117739403453745*G0_9_6 + 0.000208184672470485*G0_9_9;
    A[94] = A[31] - 0.000125383875383935*G0_2_2 - 0.000230444159015696*G0_2_4 + 0.000101280994138185*G0_2_5 - 0.000200698772127438*G0_2_6 - 0.000110405467548377*G0_2_9 + 0.000190568360211307*G0_3_3 + 0.000431131368631571*G0_3_4 - 0.000160806455449388*G0_3_5 + 0.000192902335759569*G0_3_6 + 0.000309065934066079*G0_3_9 - 0.000230444159015696*G0_4_2 + 0.000431131368631571*G0_4_3 - 0.000281043361400636*G0_4_6 + 0.000154934351362995*G0_4_9 + 0.000101280994138185*G0_5_2 - 0.000160806455449388*G0_5_3 + 0.000187312687312776*G0_5_6 - 0.000200698772127438*G0_6_2 + 0.000192902335759569*G0_6_3 - 0.000281043361400636*G0_6_4 + 0.000187312687312776*G0_6_5 - 0.000331142072213657*G0_6_6 - 0.000110405467548377*G0_9_2 + 0.00030906593406608*G0_9_3 + 0.000154934351362995*G0_9_4 + 0.000503603539318061*G0_9_9;
    A[106] = A[2] - 0.000192352290566667*G0_5_6 - 0.000192352290566667*G0_6_5 - 0.00018356643356652*G0_9_9;
    A[187] = A[117];
    A[5] = A[31] + 0.000123106060606119*G0_3_4 + 0.000123106060606119*G0_4_3 - 0.000370061486133089*G0_4_4 - 0.000155930379144738*G0_4_6 - 0.000137630226916006*G0_4_9 - 0.000155930379144738*G0_6_4 - 0.000128725441225502*G0_6_6 - 0.000137630226916006*G0_9_4;
    A[15] = A[1];
    A[8] = A[36] + 0.00027844583400152*G0_0_0 + 0.000273113130256115*G0_0_5 - 0.000153920153920226*G0_0_6 + 0.00015275729561451*G0_0_7 - 0.000278445834001521*G0_2_2 - 0.000152757295614511*G0_2_4 + 0.000153920153920227*G0_2_5 - 0.000273113130256116*G0_2_6 + 0.00010418153275301*G0_3_6 - 0.000152757295614511*G0_4_2 - 0.00020265448836887*G0_4_4 - 0.000184815184815272*G0_4_6 + 0.000273113130256115*G0_5_0 + 0.000153920153920227*G0_5_2 + 0.000326816041101908*G0_5_5 + 0.000184815184815271*G0_5_7 - 0.00010418153275301*G0_5_8 + 0.000119880119880176*G0_5_9 - 0.000153920153920226*G0_6_0 - 0.000273113130256116*G0_6_2 + 0.00010418153275301*G0_6_3 - 0.000184815184815272*G0_6_4 - 0.000326816041101909*G0_6_6 - 0.000119880119880176*G0_6_9 + 0.00015275729561451*G0_7_0 + 0.000184815184815271*G0_7_5 + 0.000202654488368869*G0_7_7 - 0.00010418153275301*G0_8_5 + 0.000119880119880176*G0_9_5 - 0.000119880119880176*G0_9_6;
    A[37] = A[107];
    A[148] = -A[191] + 0.000152228723657367*G0_0_3 + 0.00018267446838884*G0_0_9 + 0.000152228723657367*G0_1_5 + 0.000182674468388841*G0_1_9 - 0.00018267446838884*G0_2_9 + 0.000152228723657367*G0_3_0 + 0.00127872127872188*G0_3_3 - 0.00041101755387489*G0_3_5 - 0.00054802340516652*G0_3_7 + 0.00054802340516652*G0_3_8 + 0.00054802340516652*G0_3_9 + 0.00018267446838884*G0_4_4 + 0.00013700585129163*G0_4_7 + 0.00054802340516652*G0_4_9 + 0.000152228723657367*G0_5_1 - 0.00041101755387489*G0_5_3 + 0.00127872127872188*G0_5_5 + 0.00054802340516652*G0_5_7 - 0.00054802340516652*G0_5_8 + 0.000548023405166521*G0_5_9 + 0.00018267446838884*G0_6_6 + 0.00013700585129163*G0_6_8 + 0.00054802340516652*G0_6_9 - 0.00054802340516652*G0_7_3 + 0.00013700585129163*G0_7_4 + 0.000548023405166521*G0_7_5 + 0.000182674468388842*G0_7_7 - 0.000639360639360941*G0_7_8 - 0.000548023405166519*G0_7_9 + 0.00054802340516652*G0_8_3 - 0.00054802340516652*G0_8_5 + 0.00013700585129163*G0_8_6 - 0.000639360639360941*G0_8_7 + 0.00018267446838884*G0_8_8 - 0.000548023405166522*G0_8_9 + 0.00018267446838884*G0_9_0 + 0.000182674468388841*G0_9_1 - 0.00018267446838884*G0_9_2 + 0.00054802340516652*G0_9_3 + 0.00054802340516652*G0_9_4 + 0.000548023405166521*G0_9_5 + 0.00054802340516652*G0_9_6 - 0.00054802340516652*G0_9_7 - 0.000548023405166522*G0_9_8;
    A[149] = A[148] - 0.000223268794697471*G0_0_3 + 0.000142080142080209*G0_0_4 - 0.000152228723657367*G0_0_8 - 0.000121782978925894*G0_0_9 - 0.000158994444708805*G0_1_1 - 0.000243565957851786*G0_1_3 + 0.00018267446838884*G0_1_4 - 0.000334903192046207*G0_1_8 - 0.00018267446838884*G0_1_9 - 0.000152228723657367*G0_2_3 - 0.000223268794697471*G0_3_0 - 0.000243565957851786*G0_3_1 - 0.000152228723657367*G0_3_2 - 0.00200941915227724*G0_3_3 + 0.0004566861709721*G0_3_4 + 0.00027401170258326*G0_3_5 + 0.000822035107749781*G0_3_7 - 0.00109604681033304*G0_3_8 - 0.00109604681033304*G0_3_9 + 0.000142080142080209*G0_4_0 + 0.00018267446838884*G0_4_1 + 0.0004566861709721*G0_4_3 + 0.000456686170972099*G0_4_4 - 0.00027401170258326*G0_4_5 + 0.00027401170258326*G0_4_6 - 0.00027401170258326*G0_4_7 + 0.00027401170258326*G0_4_8 + 0.000548023405166519*G0_4_9 + 0.00027401170258326*G0_5_3 - 0.00027401170258326*G0_5_4 + 0.00036534893677768*G0_5_5 - 0.00018267446838884*G0_5_6 - 0.000365348936777679*G0_5_7 + 0.00018267446838884*G0_5_8 + 0.00027401170258326*G0_6_4 - 0.00018267446838884*G0_6_5 + 0.00018267446838884*G0_6_7 + 0.00082203510774978*G0_7_3 - 0.00027401170258326*G0_7_4 - 0.000365348936777679*G0_7_5 + 0.00018267446838884*G0_7_6 - 0.00219209362066608*G0_7_7 + 0.00109604681033304*G0_7_8 - 0.000152228723657367*G0_8_0 - 0.000334903192046207*G0_8_1 - 0.00109604681033304*G0_8_3 + 0.00027401170258326*G0_8_4 + 0.00018267446838884*G0_8_5 + 0.00109604681033304*G0_8_7 - 0.00054802340516652*G0_8_8 - 0.000121782978925894*G0_9_0 - 0.00018267446838884*G0_9_1 - 0.00109604681033304*G0_9_3 + 0.000548023405166519*G0_9_4;
    A[104] = A[148] - 0.000258788830217524*G0_0_3 + 0.000258788830217523*G0_0_4 + 0.000177600177600261*G0_0_6 - 0.000177600177600261*G0_0_8 - 0.000118963928487794*G0_1_1 - 0.000218194503908892*G0_1_3 + 0.000238491667063208*G0_1_4 - 0.000266400266400392*G0_1_8 - 0.000106560106560157*G0_1_9 + 0.000118963928487794*G0_2_2 - 0.000238491667063208*G0_2_3 + 0.000218194503908892*G0_2_4 + 0.000266400266400392*G0_2_6 + 0.000106560106560157*G0_2_9 - 0.000258788830217524*G0_3_0 - 0.000218194503908892*G0_3_1 - 0.000238491667063208*G0_3_2 - 0.00178107606679119*G0_3_3 + 0.0004566861709721*G0_3_5 - 0.00022834308548605*G0_3_6 + 0.000776366490652571*G0_3_7 - 0.00100470957613862*G0_3_8 - 0.00123305266162467*G0_3_9 + 0.000258788830217523*G0_4_0 + 0.000238491667063208*G0_4_1 + 0.000218194503908892*G0_4_2 + 0.00178107606679119*G0_4_4 - 0.00077636649065257*G0_4_5 + 0.00100470957613862*G0_4_6 - 0.0004566861709721*G0_4_7 + 0.00022834308548605*G0_4_8 + 0.00123305266162467*G0_4_9 + 0.0004566861709721*G0_5_3 - 0.00077636649065257*G0_5_4 + 0.000639360639360939*G0_5_5 - 0.000662194947909545*G0_5_6 + 0.00013700585129163*G0_5_8 - 0.000274011702583259*G0_5_9 + 0.000177600177600261*G0_6_0 + 0.000266400266400391*G0_6_2 - 0.00022834308548605*G0_6_3 + 0.00100470957613862*G0_6_4 - 0.000662194947909545*G0_6_5 + 0.000502354788069311*G0_6_6 - 0.00013700585129163*G0_6_7 + 0.00013700585129163*G0_6_9 + 0.000776366490652571*G0_7_3 - 0.0004566861709721*G0_7_4 - 0.00013700585129163*G0_7_6 - 0.00063936063936094*G0_7_7 + 0.000662194947909545*G0_7_8 + 0.000274011702583261*G0_7_9 - 0.000177600177600261*G0_8_0 - 0.000266400266400392*G0_8_1 - 0.00100470957613862*G0_8_3 + 0.00022834308548605*G0_8_4 + 0.00013700585129163*G0_8_5 + 0.000662194947909545*G0_8_7 - 0.00050235478806931*G0_8_8 - 0.000137005851291631*G0_8_9 - 0.000106560106560156*G0_9_1 + 0.000106560106560157*G0_9_2 - 0.00123305266162467*G0_9_3 + 0.00123305266162467*G0_9_4 - 0.000274011702583259*G0_9_5 + 0.00013700585129163*G0_9_6 + 0.000274011702583262*G0_9_7 - 0.000137005851291631*G0_9_8;
    A[132] = -A[104] + 0.000152228723657367*G0_0_4 + 0.00018267446838884*G0_0_9 - 0.00018267446838884*G0_1_9 + 0.000152228723657366*G0_2_7 + 0.00018267446838884*G0_2_9 + 0.00018267446838884*G0_3_3 + 0.00013700585129163*G0_3_5 + 0.00054802340516652*G0_3_9 + 0.000152228723657366*G0_4_0 + 0.00127872127872188*G0_4_4 - 0.000548023405166519*G0_4_5 + 0.000548023405166519*G0_4_6 - 0.00041101755387489*G0_4_7 + 0.000548023405166519*G0_4_9 + 0.00013700585129163*G0_5_3 - 0.000548023405166519*G0_5_4 + 0.000182674468388836*G0_5_5 - 0.000639360639360938*G0_5_6 + 0.000548023405166518*G0_5_7 - 0.000548023405166522*G0_5_9 + 0.000548023405166519*G0_6_4 - 0.000639360639360938*G0_6_5 + 0.000182674468388838*G0_6_6 - 0.000548023405166519*G0_6_7 + 0.00013700585129163*G0_6_8 - 0.000548023405166519*G0_6_9 + 0.000152228723657366*G0_7_2 - 0.00041101755387489*G0_7_4 + 0.000548023405166518*G0_7_5 - 0.000548023405166519*G0_7_6 + 0.00127872127872188*G0_7_7 + 0.000548023405166517*G0_7_9 + 0.00013700585129163*G0_8_6 + 0.00018267446838884*G0_8_8 + 0.000548023405166521*G0_8_9 + 0.00018267446838884*G0_9_0 - 0.00018267446838884*G0_9_1 + 0.00018267446838884*G0_9_2 + 0.00054802340516652*G0_9_3 + 0.000548023405166519*G0_9_4 - 0.000548023405166522*G0_9_5 - 0.000548023405166519*G0_9_6 + 0.000548023405166517*G0_9_7 + 0.000548023405166521*G0_9_8;
    A[186] = A[132] + 0.000276266942933739*G0_0_0 + 0.000512503369646467*G0_0_5 - 0.000233417376274629*G0_0_6 + 0.000375497518354837*G0_0_7 - 0.000142080142080209*G0_0_8 + 0.000400868972297733*G0_1_5 - 0.000116708688137315*G0_1_6 + 0.000233417376274629*G0_1_7 - 0.000101485815771578*G0_1_8 + 0.000365348936777681*G0_1_9 + 0.000131931560503051*G0_2_4 + 0.000253714539428944*G0_2_5 + 0.000126857269714472*G0_2_7 - 0.000147154432868788*G0_2_8 + 0.000152228723657367*G0_2_9 - 0.000274011702583259*G0_3_3 - 0.00013700585129163*G0_3_4 - 0.000365348936777681*G0_3_5 - 0.000137005851291631*G0_3_7 - 0.000822035107749781*G0_3_9 + 0.000131931560503051*G0_4_2 - 0.00013700585129163*G0_4_3 - 0.000228343085486051*G0_4_5 + 0.000182674468388841*G0_4_6 + 0.00013700585129163*G0_4_8 + 0.000512503369646467*G0_5_0 + 0.000400868972297733*G0_5_1 + 0.000253714539428944*G0_5_2 - 0.000365348936777681*G0_5_3 - 0.00022834308548605*G0_5_4 + 0.00602825745683172*G0_5_5 - 0.00164407021549956*G0_5_6 + 0.00219209362066608*G0_5_7 - 0.00150706436420793*G0_5_8 + 0.00274011702583261*G0_5_9 - 0.000233417376274629*G0_6_0 - 0.000116708688137314*G0_6_1 + 0.000182674468388841*G0_6_4 - 0.00164407021549956*G0_6_5 + 0.000548023405166523*G0_6_6 - 0.000685029256458151*G0_6_7 + 0.000548023405166521*G0_6_8 - 0.000548023405166521*G0_6_9 + 0.000375497518354838*G0_7_0 + 0.000233417376274629*G0_7_1 + 0.000126857269714472*G0_7_2 - 0.000137005851291631*G0_7_3 + 0.00219209362066608*G0_7_5 - 0.000685029256458151*G0_7_6 + 0.00109604681033304*G0_7_7 - 0.000959040959041411*G0_7_8 + 0.00109604681033305*G0_7_9 - 0.000142080142080209*G0_8_0 - 0.000101485815771578*G0_8_1 - 0.000147154432868788*G0_8_2 + 0.00013700585129163*G0_8_4 - 0.00150706436420793*G0_8_5 + 0.000548023405166521*G0_8_6 - 0.000959040959041411*G0_8_7 + 0.000274011702583261*G0_8_8 - 0.0013700585129163*G0_8_9 + 0.000365348936777681*G0_9_1 + 0.000152228723657367*G0_9_2 - 0.000822035107749781*G0_9_3 + 0.00274011702583261*G0_9_5 - 0.000548023405166521*G0_9_6 + 0.00109604681033305*G0_9_7 - 0.0013700585129163*G0_9_8;
    A[103] = A[104] + 0.000142080142080209*G0_0_3 - 0.000223268794697471*G0_0_4 - 0.000152228723657367*G0_0_6 - 0.000121782978925893*G0_0_9 - 0.000152228723657367*G0_1_4 - 0.000158994444708805*G0_2_2 + 0.00018267446838884*G0_2_3 - 0.000243565957851787*G0_2_4 - 0.000334903192046207*G0_2_6 - 0.00018267446838884*G0_2_9 + 0.000142080142080209*G0_3_0 + 0.00018267446838884*G0_3_2 + 0.000456686170972099*G0_3_3 + 0.000456686170972101*G0_3_4 - 0.00027401170258326*G0_3_5 + 0.00027401170258326*G0_3_6 - 0.00027401170258326*G0_3_7 + 0.000274011702583259*G0_3_8 + 0.00054802340516652*G0_3_9 - 0.000223268794697471*G0_4_0 - 0.000152228723657367*G0_4_1 - 0.000243565957851787*G0_4_2 + 0.000456686170972101*G0_4_3 - 0.00200941915227724*G0_4_4 + 0.00082203510774978*G0_4_5 - 0.00109604681033304*G0_4_6 + 0.00027401170258326*G0_4_7 - 0.00109604681033304*G0_4_9 - 0.00027401170258326*G0_5_3 + 0.00082203510774978*G0_5_4 - 0.00219209362066607*G0_5_5 + 0.00109604681033304*G0_5_6 - 0.00036534893677768*G0_5_7 + 0.00018267446838884*G0_5_8 - 0.000152228723657367*G0_6_0 - 0.000334903192046207*G0_6_2 + 0.00027401170258326*G0_6_3 - 0.00109604681033304*G0_6_4 + 0.00109604681033304*G0_6_5 - 0.00054802340516652*G0_6_6 + 0.00018267446838884*G0_6_7 - 0.00027401170258326*G0_7_3 + 0.00027401170258326*G0_7_4 - 0.00036534893677768*G0_7_5 + 0.00018267446838884*G0_7_6 + 0.000365348936777679*G0_7_7 - 0.00018267446838884*G0_7_8 + 0.000274011702583259*G0_8_3 + 0.00018267446838884*G0_8_5 - 0.00018267446838884*G0_8_7 - 0.000121782978925893*G0_9_0 - 0.00018267446838884*G0_9_2 + 0.00054802340516652*G0_9_3 - 0.00109604681033304*G0_9_4;
    A[218] = A[186] - 0.000393539441158673*G0_0_0 - 0.00013700585129163*G0_0_3 + 0.000441463298606363*G0_0_4 - 0.0010097838669272*G0_0_5 + 0.000862629434058411*G0_0_6 - 0.000578469149897993*G0_0_7 + 0.000243565957851787*G0_0_8 + 0.000213120213120314*G0_0_9 - 0.000162377305234524*G0_1_3 + 0.000416091844663469*G0_1_4 - 0.000715475001189623*G0_1_5 + 0.000715475001189623*G0_1_6 - 0.000416091844663469*G0_1_7 + 0.000162377305234525*G0_1_8 + 0.000393539441158674*G0_2_2 - 0.000243565957851787*G0_2_3 + 0.000578469149897993*G0_2_4 - 0.000862629434058411*G0_2_5 + 0.0010097838669272*G0_2_6 - 0.000441463298606363*G0_2_7 + 0.00013700585129163*G0_2_8 - 0.000213120213120313*G0_2_9 - 0.00013700585129163*G0_3_0 - 0.000162377305234524*G0_3_1 - 0.000243565957851787*G0_3_2 + 0.00100470957613862*G0_3_3 - 0.00159840159840235*G0_3_4 + 0.00127872127872188*G0_3_5 - 0.00214642500356887*G0_3_6 + 0.000411017553874891*G0_3_7 - 0.000822035107749779*G0_3_9 + 0.000441463298606363*G0_4_0 + 0.000416091844663469*G0_4_1 + 0.000578469149897993*G0_4_2 - 0.00159840159840235*G0_4_3 + 0.00401883830455448*G0_4_4 - 0.00132438989581909*G0_4_5 + 0.00347081489938796*G0_4_6 - 0.00041101755387489*G0_4_8 + 0.00328814043099912*G0_4_9 - 0.0010097838669272*G0_5_0 - 0.000715475001189623*G0_5_1 - 0.000862629434058411*G0_5_2 + 0.00127872127872188*G0_5_3 - 0.00132438989581909*G0_5_4 - 0.00602825745683171*G0_5_5 - 0.00347081489938796*G0_5_7 + 0.00214642500356887*G0_5_8 - 0.00493221064649868*G0_5_9 + 0.000862629434058411*G0_6_0 + 0.000715475001189624*G0_6_1 + 0.0010097838669272*G0_6_2 - 0.00214642500356887*G0_6_3 + 0.00347081489938796*G0_6_4 + 0.00602825745683172*G0_6_6 + 0.00132438989581909*G0_6_7 - 0.00127872127872188*G0_6_8 + 0.00493221064649868*G0_6_9 - 0.000578469149897993*G0_7_0 - 0.000416091844663469*G0_7_1 - 0.000441463298606363*G0_7_2 + 0.000411017553874891*G0_7_3 - 0.00347081489938796*G0_7_5 + 0.00132438989581909*G0_7_6 - 0.00401883830455448*G0_7_7 + 0.00159840159840235*G0_7_8 - 0.00328814043099912*G0_7_9 + 0.000243565957851787*G0_8_0 + 0.000162377305234525*G0_8_1 + 0.00013700585129163*G0_8_2 - 0.00041101755387489*G0_8_4 + 0.00214642500356887*G0_8_5 - 0.00127872127872188*G0_8_6 + 0.00159840159840235*G0_8_7 - 0.00100470957613862*G0_8_8 + 0.000822035107749782*G0_8_9 + 0.000213120213120313*G0_9_0 - 0.000213120213120313*G0_9_2 - 0.000822035107749779*G0_9_3 + 0.00328814043099912*G0_9_4 - 0.00493221064649868*G0_9_5 + 0.00493221064649868*G0_9_6 - 0.00328814043099912*G0_9_7 + 0.000822035107749782*G0_9_8;
    A[89] = A[218] + 0.00013700585129163*G0_0_4 - 0.000142080142080209*G0_0_6 + 0.000142080142080209*G0_1_4 - 0.00013700585129163*G0_1_6 - 0.000106560106560157*G0_2_3 + 0.000266400266400392*G0_2_4 + 0.000106560106560157*G0_2_5 - 0.000266400266400392*G0_2_6 - 0.000106560106560157*G0_3_2 - 0.000228343085486049*G0_3_3 - 0.000570857713715125*G0_3_4 + 0.000411017553874889*G0_3_6 + 0.00013700585129163*G0_3_7 - 0.00027401170258326*G0_3_8 - 0.00041101755387489*G0_3_9 + 0.00013700585129163*G0_4_0 + 0.000142080142080209*G0_4_1 + 0.000266400266400392*G0_4_2 - 0.000570857713715125*G0_4_3 + 0.0031968031968047*G0_4_4 - 0.00041101755387489*G0_4_5 - 0.00027401170258326*G0_4_7 + 0.00013700585129163*G0_4_8 + 0.00082203510774978*G0_4_9 + 0.000106560106560157*G0_5_2 - 0.00041101755387489*G0_5_4 + 0.000228343085486049*G0_5_5 + 0.000570857713715126*G0_5_6 + 0.00027401170258326*G0_5_7 - 0.00013700585129163*G0_5_8 + 0.000411017553874889*G0_5_9 - 0.000142080142080209*G0_6_0 - 0.00013700585129163*G0_6_1 - 0.000266400266400392*G0_6_2 + 0.000411017553874889*G0_6_3 + 0.000570857713715126*G0_6_5 - 0.0031968031968047*G0_6_6 - 0.000137005851291629*G0_6_7 + 0.00027401170258326*G0_6_8 - 0.00082203510774978*G0_6_9 + 0.00013700585129163*G0_7_3 - 0.00027401170258326*G0_7_4 + 0.00027401170258326*G0_7_5 - 0.000137005851291629*G0_7_6 + 0.00041101755387489*G0_7_7 + 0.00041101755387489*G0_7_9 - 0.00027401170258326*G0_8_3 + 0.00013700585129163*G0_8_4 - 0.00013700585129163*G0_8_5 + 0.00027401170258326*G0_8_6 - 0.00041101755387489*G0_8_8 - 0.00041101755387489*G0_8_9 - 0.000411017553874889*G0_9_3 + 0.00082203510774978*G0_9_4 + 0.000411017553874889*G0_9_5 - 0.00082203510774978*G0_9_6 + 0.00041101755387489*G0_9_7 - 0.00041101755387489*G0_9_8;
    A[188] = A[132];
    A[215] = A[89];
    A[198] = A[186] - 0.00036365750651482*G0_0_0 + 0.000532800532800783*G0_0_3 - 0.00013700585129163*G0_0_4 - 0.000799200799201174*G0_0_5 + 0.000304457447314733*G0_0_6 - 0.000695177838035307*G0_0_7 + 0.000613989185418046*G0_0_8 + 0.000167451596023104*G0_0_9 + 0.00036365750651482*G0_1_1 + 0.000799200799201175*G0_1_3 - 0.000304457447314733*G0_1_4 - 0.000532800532800783*G0_1_5 + 0.00013700585129163*G0_1_6 - 0.000613989185418046*G0_1_7 + 0.000695177838035308*G0_1_8 - 0.000167451596023104*G0_1_9 + 0.000512503369646467*G0_2_3 - 0.000164914450628814*G0_2_4 - 0.000512503369646467*G0_2_5 + 0.000164914450628814*G0_2_6 - 0.000532800532800783*G0_2_7 + 0.000532800532800783*G0_2_8 + 0.000532800532800784*G0_3_0 + 0.000799200799201175*G0_3_1 + 0.000512503369646467*G0_3_2 + 0.00680462394748429*G0_3_3 - 0.00216925931211747*G0_3_4 - 0.00041101755387489*G0_3_6 - 0.00159840159840235*G0_3_7 + 0.0031968031968047*G0_3_8 + 0.00369915798487401*G0_3_9 - 0.00013700585129163*G0_4_0 - 0.000304457447314733*G0_4_1 - 0.000164914450628814*G0_4_2 - 0.00216925931211747*G0_4_3 + 0.00118738404452746*G0_4_4 + 0.00041101755387489*G0_4_5 + 0.00100470957613862*G0_4_7 - 0.00159840159840235*G0_4_8 - 0.000822035107749779*G0_4_9 - 0.000799200799201174*G0_5_0 - 0.000532800532800783*G0_5_1 - 0.000512503369646468*G0_5_2 + 0.00041101755387489*G0_5_4 - 0.00680462394748428*G0_5_5 + 0.00216925931211747*G0_5_6 - 0.0031968031968047*G0_5_7 + 0.00159840159840235*G0_5_8 - 0.00369915798487401*G0_5_9 + 0.000304457447314733*G0_6_0 + 0.00013700585129163*G0_6_1 + 0.000164914450628814*G0_6_2 - 0.00041101755387489*G0_6_3 + 0.00216925931211747*G0_6_5 - 0.00118738404452746*G0_6_6 + 0.00159840159840235*G0_6_7 - 0.00100470957613862*G0_6_8 + 0.000822035107749782*G0_6_9 - 0.000695177838035308*G0_7_0 - 0.000613989185418046*G0_7_1 - 0.000532800532800783*G0_7_2 - 0.00159840159840235*G0_7_3 + 0.00100470957613862*G0_7_4 - 0.0031968031968047*G0_7_5 + 0.00159840159840235*G0_7_6 - 0.00260311117454097*G0_7_7 - 0.00369915798487401*G0_7_9 + 0.000613989185418046*G0_8_0 + 0.000695177838035308*G0_8_1 + 0.000532800532800783*G0_8_2 + 0.0031968031968047*G0_8_3 - 0.00159840159840235*G0_8_4 + 0.00159840159840235*G0_8_5 - 0.00100470957613862*G0_8_6 + 0.00260311117454097*G0_8_8 + 0.00369915798487401*G0_8_9 + 0.000167451596023104*G0_9_0 - 0.000167451596023104*G0_9_1 + 0.00369915798487401*G0_9_3 - 0.000822035107749779*G0_9_4 - 0.00369915798487401*G0_9_5 + 0.000822035107749782*G0_9_6 - 0.00369915798487401*G0_9_7 + 0.00369915798487401*G0_9_8;
    A[216] = A[104];
    A[201] = A[103];
    A[85] = A[1] - 0.000125383875383934*G0_1_1 - 0.000200698772127438*G0_1_3 + 0.000101280994138185*G0_1_4 - 0.000230444159015696*G0_1_8 - 0.000110405467548377*G0_1_9 - 0.000200698772127438*G0_3_1 - 0.000331142072213656*G0_3_3 + 0.000187312687312775*G0_3_4 + 0.000192902335759569*G0_3_7 - 0.000281043361400636*G0_3_8 + 0.000101280994138185*G0_4_1 + 0.000187312687312775*G0_4_3 - 0.000160806455449388*G0_4_7 + 0.000192902335759569*G0_7_3 - 0.000160806455449388*G0_7_4 + 0.000190568360211307*G0_7_7 + 0.000431131368631571*G0_7_8 + 0.000309065934066079*G0_7_9 - 0.000230444159015696*G0_8_1 - 0.000281043361400636*G0_8_3 + 0.000431131368631571*G0_8_7 + 0.000154934351362996*G0_8_9 - 0.000110405467548377*G0_9_1 + 0.000309065934066079*G0_9_7 + 0.000154934351362996*G0_9_8 + 0.000503603539318062*G0_9_9;
    A[66] = A[94];
    A[160] = A[2] + 0.000630650213983843*G0_0_0 + 0.000168077806966775*G0_0_1 + 0.000359362859363028*G0_0_5 - 0.000158234622520411*G0_0_6 + 0.000308395308395452*G0_0_7 - 0.000401232365518268*G0_0_8 + 0.000168077806966775*G0_1_0 + 0.000587113503780447*G0_1_1 + 0.000325965370608381*G0_1_3 - 0.000144134965563605*G0_1_4 - 0.000387225208653963*G0_1_7 + 0.000282675327318317*G0_1_8 + 0.000128951736094654*G0_2_3 - 0.000101908673337293*G0_2_4 + 0.000128859236002154*G0_2_5 + 0.000254841058412607*G0_2_7 + 0.00025254672576113*G0_2_8 + 0.000351989280560875*G0_2_9 + 0.000325965370608381*G0_3_1 + 0.000128951736094654*G0_3_2 + 0.00145876444983656*G0_3_3 - 0.000576923076923348*G0_3_4 - 0.000205761500404455*G0_3_5 - 0.000110945602017083*G0_3_6 - 0.000463836758479835*G0_3_7 + 0.00139649041434821*G0_3_8 + 0.000940577279863436*G0_3_9 - 0.000144134965563605*G0_4_1 - 0.000101908673337293*G0_4_2 - 0.000576923076923348*G0_4_3 + 0.000396701512773128*G0_4_4 - 0.000108938680367303*G0_4_5 + 0.000219884282384386*G0_4_6 - 0.000261717449217572*G0_4_7 - 0.00093265365586838*G0_4_8 - 0.000838090480948018*G0_4_9 + 0.000359362859363028*G0_5_0 + 0.000128859236002154*G0_5_2 - 0.000205761500404455*G0_5_3 - 0.000108938680367303*G0_5_4 + 0.00150211395747181*G0_5_5 - 0.000601407521050661*G0_5_6 + 0.00141226333190685*G0_5_7 - 0.000472726678084044*G0_5_8 + 0.000938436563437005*G0_5_9 - 0.000158234622520411*G0_6_0 - 0.000110945602017083*G0_6_3 + 0.000219884282384386*G0_6_4 - 0.000601407521050661*G0_6_5 + 0.000436037177108811*G0_6_6 - 0.000939536653822811*G0_6_7 - 0.000259279411065248*G0_6_8 - 0.00083407663764846*G0_6_9 + 0.000308395308395452*G0_7_0 - 0.000387225208653963*G0_7_1 + 0.000254841058412607*G0_7_2 - 0.000463836758479835*G0_7_3 - 0.000261717449217572*G0_7_4 + 0.00141226333190685*G0_7_5 - 0.000939536653822811*G0_7_6 + 0.00574849257885243*G0_7_7 + 0.000542671614100442*G0_7_8 + 0.00187205651491454*G0_7_9 - 0.000401232365518268*G0_8_0 + 0.000282675327318317*G0_8_1 + 0.00025254672576113*G0_8_2 + 0.00139649041434821*G0_8_3 - 0.00093265365586838*G0_8_4 - 0.000472726678084044*G0_8_5 - 0.000259279411065248*G0_8_6 + 0.000542671614100442*G0_8_7 + 0.00574447873555287*G0_8_8 + 0.00187821107464053*G0_8_9 + 0.000351989280560875*G0_9_2 + 0.000940577279863436*G0_9_3 - 0.000838090480948018*G0_9_4 + 0.000938436563437005*G0_9_5 - 0.00083407663764846*G0_9_6 + 0.00187205651491454*G0_9_7 + 0.00187821107464053*G0_9_8 + 0.0033807264164423*G0_9_9;
    A[137] = A[21] + 0.00028067170924327*G0_5_5 - 0.000280671709243269*G0_7_7;
    A[91] = A[21];
    A[184] = A[72];
    A[213] = A[191] - 0.000118963928487794*G0_0_0 - 0.000218194503908892*G0_0_5 + 0.000238491667063208*G0_0_6 - 0.000266400266400392*G0_0_7 - 0.000106560106560156*G0_0_9 + 0.000177600177600261*G0_1_4 - 0.000258788830217524*G0_1_5 + 0.000258788830217523*G0_1_6 - 0.000177600177600261*G0_1_7 + 0.000118963928487794*G0_2_2 + 0.000266400266400392*G0_2_4 - 0.000238491667063208*G0_2_5 + 0.000218194503908892*G0_2_6 + 0.000106560106560157*G0_2_9 + 0.000639360639360942*G0_3_3 - 0.000662194947909546*G0_3_4 + 0.0004566861709721*G0_3_5 - 0.00077636649065257*G0_3_6 + 0.00013700585129163*G0_3_7 - 0.000274011702583257*G0_3_9 + 0.000177600177600261*G0_4_1 + 0.000266400266400392*G0_4_2 - 0.000662194947909546*G0_4_3 + 0.000502354788069311*G0_4_4 - 0.000228343085486051*G0_4_5 + 0.00100470957613862*G0_4_6 - 0.000137005851291631*G0_4_8 + 0.00013700585129163*G0_4_9 - 0.000218194503908892*G0_5_0 - 0.000258788830217524*G0_5_1 - 0.000238491667063208*G0_5_2 + 0.0004566861709721*G0_5_3 - 0.000228343085486051*G0_5_4 - 0.00178107606679119*G0_5_5 - 0.00100470957613862*G0_5_7 + 0.00077636649065257*G0_5_8 - 0.00123305266162467*G0_5_9 + 0.000238491667063208*G0_6_0 + 0.000258788830217523*G0_6_1 + 0.000218194503908892*G0_6_2 - 0.00077636649065257*G0_6_3 + 0.00100470957613862*G0_6_4 + 0.00178107606679119*G0_6_6 + 0.00022834308548605*G0_6_7 - 0.0004566861709721*G0_6_8 + 0.00123305266162467*G0_6_9 - 0.000266400266400392*G0_7_0 - 0.000177600177600261*G0_7_1 + 0.00013700585129163*G0_7_3 - 0.00100470957613862*G0_7_5 + 0.00022834308548605*G0_7_6 - 0.000502354788069311*G0_7_7 + 0.000662194947909545*G0_7_8 - 0.000137005851291632*G0_7_9 - 0.000137005851291631*G0_8_4 + 0.00077636649065257*G0_8_5 - 0.0004566861709721*G0_8_6 + 0.000662194947909545*G0_8_7 - 0.000639360639360939*G0_8_8 + 0.000274011702583264*G0_8_9 - 0.000106560106560156*G0_9_0 + 0.000106560106560157*G0_9_2 - 0.000274011702583257*G0_9_3 + 0.00013700585129163*G0_9_4 - 0.00123305266162467*G0_9_5 + 0.00123305266162467*G0_9_6 - 0.000137005851291632*G0_9_7 + 0.000274011702583264*G0_9_8;
    A[57] = A[213] - 0.000152228723657367*G0_0_6 - 0.000152228723657367*G0_1_4 + 0.000142080142080209*G0_1_5 - 0.000223268794697471*G0_1_6 - 0.000121782978925893*G0_1_9 - 0.000158994444708805*G0_2_2 - 0.000334903192046207*G0_2_4 + 0.00018267446838884*G0_2_5 - 0.000243565957851787*G0_2_6 - 0.00018267446838884*G0_2_9 - 0.00219209362066608*G0_3_3 + 0.00109604681033304*G0_3_4 - 0.00027401170258326*G0_3_5 + 0.00082203510774978*G0_3_6 + 0.000182674468388841*G0_3_7 - 0.000365348936777681*G0_3_8 - 0.000152228723657367*G0_4_1 - 0.000334903192046207*G0_4_2 + 0.00109604681033304*G0_4_3 - 0.000548023405166521*G0_4_4 + 0.000274011702583261*G0_4_5 - 0.00109604681033304*G0_4_6 + 0.00018267446838884*G0_4_8 + 0.000142080142080209*G0_5_1 + 0.00018267446838884*G0_5_2 - 0.00027401170258326*G0_5_3 + 0.000274011702583261*G0_5_4 + 0.000456686170972099*G0_5_5 + 0.000456686170972101*G0_5_6 + 0.000274011702583259*G0_5_7 - 0.00027401170258326*G0_5_8 + 0.00054802340516652*G0_5_9 - 0.000152228723657367*G0_6_0 - 0.000223268794697471*G0_6_1 - 0.000243565957851787*G0_6_2 + 0.00082203510774978*G0_6_3 - 0.00109604681033304*G0_6_4 + 0.000456686170972101*G0_6_5 - 0.00200941915227724*G0_6_6 + 0.00027401170258326*G0_6_8 - 0.00109604681033304*G0_6_9 + 0.000182674468388841*G0_7_3 + 0.000274011702583259*G0_7_5 - 0.000182674468388839*G0_7_8 - 0.000365348936777681*G0_8_3 + 0.00018267446838884*G0_8_4 - 0.00027401170258326*G0_8_5 + 0.00027401170258326*G0_8_6 - 0.000182674468388839*G0_8_7 + 0.000365348936777678*G0_8_8 - 0.000121782978925893*G0_9_1 - 0.00018267446838884*G0_9_2 + 0.00054802340516652*G0_9_5 - 0.00109604681033304*G0_9_6;
    A[204] = A[148];
    A[18] = A[46];
    A[133] = A[132] - 0.000158994444708805*G0_0_0 - 0.000334903192046206*G0_0_5 - 0.000243565957851786*G0_0_7 + 0.00018267446838884*G0_0_8 - 0.00018267446838884*G0_0_9 - 0.000152228723657366*G0_1_7 - 0.000152228723657367*G0_2_5 - 0.000223268794697471*G0_2_7 + 0.000142080142080209*G0_2_8 - 0.000121782978925893*G0_2_9 - 0.00018267446838884*G0_3_4 + 0.00018267446838884*G0_3_6 + 0.00027401170258326*G0_3_8 - 0.00018267446838884*G0_4_3 + 0.00036534893677768*G0_4_4 + 0.000182674468388839*G0_4_5 - 0.00036534893677768*G0_4_6 + 0.00027401170258326*G0_4_7 - 0.00027401170258326*G0_4_8 - 0.000334903192046206*G0_5_0 - 0.000152228723657367*G0_5_2 + 0.000182674468388839*G0_5_4 - 0.000548023405166515*G0_5_5 + 0.00109604681033304*G0_5_6 - 0.00109604681033304*G0_5_7 + 0.000274011702583259*G0_5_8 + 0.00018267446838884*G0_6_3 - 0.00036534893677768*G0_6_4 + 0.00109604681033304*G0_6_5 - 0.00219209362066608*G0_6_6 + 0.000822035107749779*G0_6_7 - 0.00027401170258326*G0_6_8 - 0.000243565957851786*G0_7_0 - 0.000152228723657366*G0_7_1 - 0.000223268794697471*G0_7_2 + 0.00027401170258326*G0_7_4 - 0.00109604681033304*G0_7_5 + 0.000822035107749779*G0_7_6 - 0.00200941915227724*G0_7_7 + 0.000456686170972099*G0_7_8 - 0.00109604681033304*G0_7_9 + 0.00018267446838884*G0_8_0 + 0.000142080142080209*G0_8_2 + 0.00027401170258326*G0_8_3 - 0.00027401170258326*G0_8_4 + 0.000274011702583259*G0_8_5 - 0.00027401170258326*G0_8_6 + 0.000456686170972099*G0_8_7 + 0.0004566861709721*G0_8_8 + 0.000548023405166518*G0_8_9 - 0.00018267446838884*G0_9_0 - 0.000121782978925893*G0_9_2 - 0.00109604681033304*G0_9_7 + 0.000548023405166518*G0_9_8;
    A[45] = A[41] - 0.00028067170924327*G0_3_3 + 0.000280671709243269*G0_8_8;
    A[38] = A[122];
    A[120] = A[8];
    A[88] = A[132] - 0.000118963928487794*G0_0_0 - 0.000266400266400391*G0_0_5 - 0.000218194503908892*G0_0_7 + 0.000238491667063208*G0_0_8 - 0.000106560106560157*G0_0_9 + 0.000118963928487794*G0_1_1 + 0.000266400266400392*G0_1_3 - 0.000238491667063208*G0_1_7 + 0.000218194503908892*G0_1_8 + 0.000106560106560157*G0_1_9 + 0.000177600177600261*G0_2_3 - 0.000177600177600261*G0_2_5 - 0.000258788830217523*G0_2_7 + 0.000258788830217523*G0_2_8 + 0.000266400266400392*G0_3_1 + 0.000177600177600261*G0_3_2 + 0.000502354788069309*G0_3_3 - 0.000662194947909545*G0_3_4 - 0.000137005851291631*G0_3_6 - 0.00022834308548605*G0_3_7 + 0.00100470957613862*G0_3_8 + 0.000137005851291628*G0_3_9 - 0.000662194947909545*G0_4_3 + 0.000639360639360942*G0_4_4 + 0.000137005851291629*G0_4_5 + 0.000456686170972099*G0_4_7 - 0.00077636649065257*G0_4_8 - 0.000274011702583259*G0_4_9 - 0.000266400266400391*G0_5_0 - 0.000177600177600261*G0_5_2 + 0.000137005851291629*G0_5_4 - 0.000502354788069306*G0_5_5 + 0.000662194947909543*G0_5_6 - 0.00100470957613862*G0_5_7 + 0.000228343085486049*G0_5_8 - 0.000137005851291627*G0_5_9 - 0.000137005851291631*G0_6_3 + 0.000662194947909543*G0_6_5 - 0.000639360639360938*G0_6_6 + 0.000776366490652569*G0_6_7 - 0.0004566861709721*G0_6_8 + 0.00027401170258326*G0_6_9 - 0.000218194503908892*G0_7_0 - 0.000238491667063208*G0_7_1 - 0.000258788830217523*G0_7_2 - 0.00022834308548605*G0_7_3 + 0.000456686170972099*G0_7_4 - 0.00100470957613862*G0_7_5 + 0.000776366490652569*G0_7_6 - 0.00178107606679119*G0_7_7 - 0.00123305266162467*G0_7_9 + 0.000238491667063208*G0_8_0 + 0.000218194503908892*G0_8_1 + 0.000258788830217523*G0_8_2 + 0.00100470957613862*G0_8_3 - 0.00077636649065257*G0_8_4 + 0.000228343085486049*G0_8_5 - 0.0004566861709721*G0_8_6 + 0.00178107606679119*G0_8_8 + 0.00123305266162467*G0_8_9 - 0.000106560106560157*G0_9_0 + 0.000106560106560157*G0_9_1 + 0.000137005851291628*G0_9_3 - 0.000274011702583259*G0_9_4 - 0.000137005851291627*G0_9_5 + 0.00027401170258326*G0_9_6 - 0.00123305266162467*G0_9_7 + 0.00123305266162467*G0_9_8;
    A[92] = A[36];
    A[179] = A[191] - 0.000158994444708805*G0_0_0 - 0.000243565957851786*G0_0_5 + 0.00018267446838884*G0_0_6 - 0.000334903192046207*G0_0_7 - 0.00018267446838884*G0_0_9 - 0.000223268794697471*G0_1_5 + 0.000142080142080209*G0_1_6 - 0.000152228723657367*G0_1_7 - 0.000121782978925894*G0_1_9 - 0.000152228723657367*G0_2_5 + 0.000365348936777681*G0_3_3 - 0.000182674468388841*G0_3_4 + 0.00027401170258326*G0_3_5 - 0.000274011702583261*G0_3_6 + 0.00018267446838884*G0_3_7 - 0.000365348936777678*G0_3_8 - 0.000182674468388841*G0_4_3 + 0.000274011702583261*G0_4_6 + 0.000182674468388839*G0_4_8 - 0.000243565957851786*G0_5_0 - 0.000223268794697471*G0_5_1 - 0.000152228723657367*G0_5_2 + 0.00027401170258326*G0_5_3 - 0.00200941915227724*G0_5_5 + 0.0004566861709721*G0_5_6 - 0.00109604681033304*G0_5_7 + 0.00082203510774978*G0_5_8 - 0.00109604681033304*G0_5_9 + 0.00018267446838884*G0_6_0 + 0.000142080142080209*G0_6_1 - 0.000274011702583261*G0_6_3 + 0.000274011702583261*G0_6_4 + 0.0004566861709721*G0_6_5 + 0.000456686170972101*G0_6_6 + 0.00027401170258326*G0_6_7 - 0.000274011702583261*G0_6_8 + 0.000548023405166521*G0_6_9 - 0.000334903192046207*G0_7_0 - 0.000152228723657367*G0_7_1 + 0.00018267446838884*G0_7_3 - 0.00109604681033304*G0_7_5 + 0.00027401170258326*G0_7_6 - 0.000548023405166521*G0_7_7 + 0.00109604681033304*G0_7_8 - 0.000365348936777678*G0_8_3 + 0.000182674468388839*G0_8_4 + 0.000822035107749781*G0_8_5 - 0.000274011702583261*G0_8_6 + 0.00109604681033304*G0_8_7 - 0.00219209362066608*G0_8_8 - 0.00018267446838884*G0_9_0 - 0.000121782978925894*G0_9_1 - 0.00109604681033304*G0_9_5 + 0.000548023405166521*G0_9_6;
    A[116] = A[2] - 0.000125383875383934*G0_0_0 - 0.000230444159015695*G0_0_5 - 0.000200698772127438*G0_0_7 + 0.000101280994138185*G0_0_8 - 0.000110405467548376*G0_0_9 - 0.000230444159015695*G0_5_0 + 0.000431131368631571*G0_5_6 - 0.000281043361400636*G0_5_7 + 0.000154934351362996*G0_5_9 + 0.000431131368631571*G0_6_5 + 0.000190568360211308*G0_6_6 + 0.000192902335759569*G0_6_7 - 0.000160806455449388*G0_6_8 + 0.00030906593406608*G0_6_9 - 0.000200698772127438*G0_7_0 - 0.000281043361400636*G0_7_5 + 0.000192902335759569*G0_7_6 - 0.000331142072213656*G0_7_7 + 0.000187312687312774*G0_7_8 + 0.000101280994138185*G0_8_0 - 0.000160806455449388*G0_8_6 + 0.000187312687312774*G0_8_7 - 0.000110405467548376*G0_9_0 + 0.000154934351362996*G0_9_5 + 0.00030906593406608*G0_9_6 + 0.000503603539318063*G0_9_9;
    A[219] = A[149];
    A[189] = A[186] - 0.000266400266400391*G0_0_5 + 0.000106560106560156*G0_0_6 + 0.000266400266400392*G0_0_7 - 0.000106560106560157*G0_0_8 - 0.00013700585129163*G0_1_5 + 0.000142080142080209*G0_1_7 - 0.000142080142080209*G0_2_5 + 0.00013700585129163*G0_2_7 - 0.00041101755387489*G0_3_3 + 0.000274011702583261*G0_3_5 - 0.00013700585129163*G0_3_6 + 0.00013700585129163*G0_3_7 - 0.00027401170258326*G0_3_8 - 0.00041101755387489*G0_3_9 + 0.00041101755387489*G0_4_4 - 0.00013700585129163*G0_4_5 + 0.00027401170258326*G0_4_6 - 0.00027401170258326*G0_4_7 + 0.00013700585129163*G0_4_8 + 0.00041101755387489*G0_4_9 - 0.000266400266400391*G0_5_0 - 0.00013700585129163*G0_5_1 - 0.000142080142080209*G0_5_2 + 0.000274011702583261*G0_5_3 - 0.00013700585129163*G0_5_4 - 0.0031968031968047*G0_5_5 + 0.000570857713715125*G0_5_6 + 0.00041101755387489*G0_5_8 - 0.000822035107749782*G0_5_9 + 0.000106560106560156*G0_6_0 - 0.00013700585129163*G0_6_3 + 0.00027401170258326*G0_6_4 + 0.000570857713715125*G0_6_5 + 0.00022834308548605*G0_6_6 - 0.00041101755387489*G0_6_7 + 0.00041101755387489*G0_6_9 + 0.000266400266400392*G0_7_0 + 0.000142080142080209*G0_7_1 + 0.00013700585129163*G0_7_2 + 0.00013700585129163*G0_7_3 - 0.00027401170258326*G0_7_4 - 0.00041101755387489*G0_7_6 + 0.0031968031968047*G0_7_7 - 0.000570857713715127*G0_7_8 + 0.000822035107749777*G0_7_9 - 0.000106560106560157*G0_8_0 - 0.00027401170258326*G0_8_3 + 0.00013700585129163*G0_8_4 + 0.000411017553874891*G0_8_5 - 0.000570857713715127*G0_8_7 - 0.00022834308548605*G0_8_8 - 0.00041101755387489*G0_8_9 - 0.00041101755387489*G0_9_3 + 0.00041101755387489*G0_9_4 - 0.000822035107749782*G0_9_5 + 0.00041101755387489*G0_9_6 + 0.000822035107749777*G0_9_7 - 0.00041101755387489*G0_9_8;
    A[207] = A[193];
    A[29] = A[211];
    A[130] = A[158];
    A[73] = A[199];
    A[43] = A[31] + 0.000117159626088253*G0_3_4 - 0.000232520455734851*G0_3_8 - 0.000119077351220264*G0_3_9 + 0.000117159626088253*G0_4_3 + 0.000177203748632403*G0_4_8 + 0.000214874411303084*G0_4_9 + 0.000142357642357709*G0_6_9 - 0.000232520455734851*G0_8_3 + 0.000177203748632403*G0_8_4 - 0.000519525117739648*G0_8_8 - 0.000362851434280176*G0_8_9 - 0.000119077351220264*G0_9_3 + 0.000214874411303084*G0_9_4 + 0.000142357642357709*G0_9_6 - 0.000362851434280176*G0_9_8 - 0.000164299985728634*G0_9_9;
    A[75] = A[5];
    A[150] = A[10];
    A[183] = A[57];
    A[178] = A[218] + 0.000532800532800783*G0_0_3 - 0.000532800532800783*G0_0_4 + 0.000164914450628814*G0_0_5 - 0.000512503369646468*G0_0_6 - 0.000164914450628814*G0_0_7 + 0.000512503369646468*G0_0_8 + 0.00036365750651482*G0_1_1 + 0.000695177838035308*G0_1_3 - 0.000613989185418046*G0_1_4 + 0.00013700585129163*G0_1_5 - 0.000532800532800783*G0_1_6 - 0.000304457447314733*G0_1_7 + 0.000799200799201175*G0_1_8 - 0.000167451596023103*G0_1_9 - 0.00036365750651482*G0_2_2 + 0.000613989185418045*G0_2_3 - 0.000695177838035308*G0_2_4 + 0.000304457447314734*G0_2_5 - 0.000799200799201175*G0_2_6 - 0.00013700585129163*G0_2_7 + 0.000532800532800783*G0_2_8 + 0.000167451596023103*G0_2_9 + 0.000532800532800783*G0_3_0 + 0.000695177838035308*G0_3_1 + 0.000613989185418045*G0_3_2 + 0.00260311117454097*G0_3_3 - 0.00100470957613862*G0_3_5 + 0.00159840159840235*G0_3_6 - 0.00159840159840235*G0_3_7 + 0.0031968031968047*G0_3_8 + 0.00369915798487401*G0_3_9 - 0.000532800532800783*G0_4_0 - 0.000613989185418046*G0_4_1 - 0.000695177838035308*G0_4_2 - 0.00260311117454097*G0_4_4 + 0.00159840159840235*G0_4_5 - 0.0031968031968047*G0_4_6 + 0.00100470957613862*G0_4_7 - 0.00159840159840235*G0_4_8 - 0.00369915798487401*G0_4_9 + 0.000164914450628814*G0_5_0 + 0.00013700585129163*G0_5_1 + 0.000304457447314734*G0_5_2 - 0.00100470957613862*G0_5_3 + 0.00159840159840235*G0_5_4 - 0.00118738404452746*G0_5_5 + 0.00216925931211748*G0_5_6 - 0.000411017553874891*G0_5_8 + 0.000822035107749779*G0_5_9 - 0.000512503369646468*G0_6_0 - 0.000532800532800783*G0_6_1 - 0.000799200799201175*G0_6_2 + 0.00159840159840235*G0_6_3 - 0.0031968031968047*G0_6_4 + 0.00216925931211748*G0_6_5 - 0.00680462394748429*G0_6_6 + 0.000411017553874892*G0_6_7 - 0.00369915798487401*G0_6_9 - 0.000164914450628814*G0_7_0 - 0.000304457447314733*G0_7_1 - 0.00013700585129163*G0_7_2 - 0.00159840159840235*G0_7_3 + 0.00100470957613862*G0_7_4 + 0.000411017553874892*G0_7_6 + 0.00118738404452746*G0_7_7 - 0.00216925931211748*G0_7_8 - 0.000822035107749782*G0_7_9 + 0.000512503369646468*G0_8_0 + 0.000799200799201175*G0_8_1 + 0.000532800532800783*G0_8_2 + 0.0031968031968047*G0_8_3 - 0.00159840159840235*G0_8_4 - 0.00041101755387489*G0_8_5 - 0.00216925931211748*G0_8_7 + 0.00680462394748429*G0_8_8 + 0.00369915798487401*G0_8_9 - 0.000167451596023103*G0_9_1 + 0.000167451596023103*G0_9_2 + 0.00369915798487401*G0_9_3 - 0.00369915798487401*G0_9_4 + 0.000822035107749778*G0_9_5 - 0.00369915798487401*G0_9_6 - 0.000822035107749781*G0_9_7 + 0.00369915798487401*G0_9_8;
    A[119] = A[117] + 0.000296000296000434*G0_0_0 - 0.000433851862423494*G0_0_4 + 0.000829646543932647*G0_0_5 - 0.000563246277532256*G0_0_6 + 0.00050235478806931*G0_0_7 - 0.00027401170258326*G0_0_8 - 0.000228343085486048*G0_0_9 + 0.000121782978925893*G0_1_3 - 0.000289234574948996*G0_1_4 + 0.000296846011131864*G0_1_5 - 0.000296846011131864*G0_1_6 + 0.000289234574948996*G0_1_7 - 0.000121782978925893*G0_1_8 - 0.000296000296000435*G0_2_2 + 0.00027401170258326*G0_2_3 - 0.00050235478806931*G0_2_4 + 0.000563246277532256*G0_2_5 - 0.000829646543932648*G0_2_6 + 0.000433851862423495*G0_2_7 + 0.000228343085486049*G0_2_9 + 0.000121782978925893*G0_3_1 + 0.00027401170258326*G0_3_2 - 0.000685029256458148*G0_3_3 + 0.00116454973597885*G0_3_4 - 0.000548023405166519*G0_3_5 + 0.000890538033395594*G0_3_6 - 0.000205508776937446*G0_3_7 + 0.00041101755387489*G0_3_9 - 0.000433851862423494*G0_4_0 - 0.000289234574948996*G0_4_1 - 0.00050235478806931*G0_4_2 + 0.00116454973597885*G0_4_3 - 0.00438418724133215*G0_4_4 + 0.00130155558727048*G0_4_5 - 0.00219209362066608*G0_4_6 + 0.000205508776937444*G0_4_8 - 0.00328814043099911*G0_4_9 + 0.000829646543932647*G0_5_0 + 0.000296846011131864*G0_5_1 + 0.000563246277532256*G0_5_2 - 0.000548023405166519*G0_5_3 + 0.00130155558727048*G0_5_4 + 0.000822035107749773*G0_5_5 + 0.00219209362066607*G0_5_7 - 0.000890538033395592*G0_5_8 + 0.00246610532324933*G0_5_9 - 0.000563246277532256*G0_6_0 - 0.000296846011131864*G0_6_1 - 0.000829646543932648*G0_6_2 + 0.000890538033395594*G0_6_3 - 0.00219209362066608*G0_6_4 - 0.000822035107749777*G0_6_6 - 0.00130155558727048*G0_6_7 + 0.00054802340516652*G0_6_8 - 0.00246610532324933*G0_6_9 + 0.00050235478806931*G0_7_0 + 0.000289234574948996*G0_7_1 + 0.000433851862423495*G0_7_2 - 0.000205508776937446*G0_7_3 + 0.00219209362066608*G0_7_5 - 0.00130155558727048*G0_7_6 + 0.00438418724133215*G0_7_7 - 0.00116454973597885*G0_7_8 + 0.00328814043099911*G0_7_9 - 0.00027401170258326*G0_8_0 - 0.000121782978925893*G0_8_1 + 0.000205508776937444*G0_8_4 - 0.000890538033395592*G0_8_5 + 0.00054802340516652*G0_8_6 - 0.00116454973597885*G0_8_7 + 0.000685029256458148*G0_8_8 - 0.00041101755387489*G0_8_9 - 0.000228343085486048*G0_9_0 + 0.000228343085486049*G0_9_2 + 0.00041101755387489*G0_9_3 - 0.00328814043099911*G0_9_4 + 0.00246610532324933*G0_9_5 - 0.00246610532324933*G0_9_6 + 0.00328814043099911*G0_9_7 - 0.00041101755387489*G0_9_8;
    A[220] = A[164];
    A[197] = A[43];
    A[194] = A[222];
    A[19] = A[61];
    A[33] = A[47];
    A[24] = A[165] - 0.00027844583400152*G0_0_0 - 0.00015275729561451*G0_0_5 - 0.000273113130256116*G0_0_7 + 0.000153920153920226*G0_0_8 + 0.000278445834001521*G0_1_1 + 0.00015275729561451*G0_1_3 - 0.000153920153920227*G0_1_7 + 0.000273113130256116*G0_1_8 + 0.00015275729561451*G0_3_1 + 0.00020265448836887*G0_3_3 + 0.000184815184815272*G0_3_8 - 0.00010418153275301*G0_4_8 - 0.00015275729561451*G0_5_0 - 0.000202654488368869*G0_5_5 - 0.000184815184815272*G0_5_7 + 0.00010418153275301*G0_6_7 - 0.000273113130256116*G0_7_0 - 0.000153920153920226*G0_7_1 - 0.000184815184815272*G0_7_5 + 0.00010418153275301*G0_7_6 - 0.000326816041101909*G0_7_7 - 0.000119880119880177*G0_7_9 + 0.000153920153920226*G0_8_0 + 0.000273113130256116*G0_8_1 + 0.000184815184815272*G0_8_3 - 0.00010418153275301*G0_8_4 + 0.00032681604110191*G0_8_8 + 0.000119880119880177*G0_8_9 - 0.000119880119880177*G0_9_7 + 0.000119880119880177*G0_9_8;
    A[62] = A[61] + 0.000517908017908261*G0_1_1 + 0.000423742923743123*G0_1_3 - 0.000237381665953206*G0_1_4 - 0.00012031619174482*G0_1_7 + 0.00024681667538822*G0_1_8 - 0.000517908017908262*G0_2_2 + 0.000237381665953206*G0_2_3 - 0.000423742923743123*G0_2_4 + 0.00012031619174482*G0_2_5 - 0.000246816675388221*G0_2_6 + 0.000423742923743123*G0_3_1 + 0.000237381665953206*G0_3_2 + 0.000668973883259911*G0_3_3 + 0.000110782075067842*G0_3_6 - 0.000153061224489868*G0_3_7 + 0.000263843299557709*G0_3_8 + 0.000205508776937445*G0_3_9 - 0.000237381665953206*G0_4_1 - 0.000423742923743123*G0_4_2 - 0.000668973883259913*G0_4_4 + 0.000153061224489868*G0_4_5 - 0.00026384329955771*G0_4_6 - 0.000110782075067842*G0_4_8 - 0.000205508776937445*G0_4_9 + 0.00012031619174482*G0_5_2 + 0.000153061224489868*G0_5_4 + 0.000129334950763583*G0_5_6 - 0.000246816675388221*G0_6_2 + 0.000110782075067842*G0_6_3 - 0.00026384329955771*G0_6_4 + 0.000129334950763583*G0_6_5 - 0.00030683602112188*G0_6_6 - 0.000120950478093392*G0_6_9 - 0.00012031619174482*G0_7_1 - 0.000153061224489868*G0_7_3 - 0.000129334950763583*G0_7_8 + 0.00024681667538822*G0_8_1 + 0.000263843299557709*G0_8_3 - 0.000110782075067842*G0_8_4 - 0.000129334950763583*G0_8_7 + 0.00030683602112188*G0_8_8 + 0.000120950478093392*G0_8_9 + 0.000205508776937445*G0_9_3 - 0.000205508776937445*G0_9_4 - 0.000120950478093392*G0_9_6 + 0.000120950478093392*G0_9_8;
    A[44] = A[212];
    A[141] = A[99];
    A[172] = A[116];
    A[155] = A[85];
    A[105] = A[7];
    A[173] = A[51] - 0.00040340611769202*G0_3_3 + 0.000133200133200195*G0_3_4 + 0.000133200133200195*G0_4_3 + 0.000114171542743025*G0_4_9 - 0.000353931782503377*G0_5_5 - 0.000205508776937445*G0_5_9 + 0.000353931782503378*G0_6_6 + 0.000205508776937445*G0_6_9 - 0.000133200133200196*G0_7_8 - 0.000114171542743025*G0_7_9 - 0.000133200133200196*G0_8_7 + 0.000403406117692021*G0_8_8 + 0.000114171542743025*G0_9_4 - 0.000205508776937445*G0_9_5 + 0.000205508776937445*G0_9_6 - 0.000114171542743025*G0_9_7;
    A[118] = A[202];
    A[217] = A[119];
    A[200] = A[88];
    A[6] = A[90];
    A[22] = A[106];
    A[9] = A[135];
    A[34] = A[62];
    A[147] = A[189];
    A[84] = A[51] - 0.000353931782503377*G0_3_3 - 0.000205508776937445*G0_3_9 + 0.000353931782503376*G0_4_4 + 0.000205508776937445*G0_4_9 - 0.000403406117692021*G0_5_5 + 0.000133200133200196*G0_5_6 + 0.000133200133200196*G0_6_5 + 0.000114171542743025*G0_6_9 + 0.000403406117692021*G0_7_7 - 0.000133200133200196*G0_7_8 - 0.000133200133200196*G0_8_7 - 0.000114171542743025*G0_8_9 - 0.000205508776937445*G0_9_3 + 0.000205508776937445*G0_9_4 + 0.000114171542743025*G0_9_6 - 0.000114171542743025*G0_9_8;
    A[170] = A[84] + 0.000109097251954446*G0_0_8 + 0.000164068735497384*G0_1_1 + 0.000152228723657367*G0_1_3 - 0.000126857269714472*G0_1_7 + 0.000241028812457497*G0_1_8 + 0.000106560106560157*G0_2_8 + 0.000152228723657367*G0_3_1 + 0.000479520479520705*G0_3_3 - 0.00013700585129163*G0_3_4 - 0.00022834308548605*G0_3_7 + 0.000593692022263729*G0_3_8 + 0.00041101755387489*G0_3_9 - 0.00013700585129163*G0_4_3 - 0.000274011702583259*G0_4_4 + 0.00018267446838884*G0_4_7 - 0.00036534893677768*G0_4_8 - 0.000274011702583259*G0_4_9 - 0.00013700585129163*G0_5_7 - 0.00013700585129163*G0_5_9 + 0.00013700585129163*G0_6_7 - 0.00013700585129163*G0_6_8 - 0.000126857269714472*G0_7_1 - 0.00022834308548605*G0_7_3 + 0.00018267446838884*G0_7_4 - 0.00013700585129163*G0_7_5 + 0.00013700585129163*G0_7_6 - 0.000350126064411943*G0_7_7 - 0.000327291755863338*G0_7_8 - 0.000411017553874889*G0_7_9 + 0.000109097251954446*G0_8_0 + 0.000241028812457497*G0_8_1 + 0.000106560106560157*G0_8_2 + 0.000593692022263729*G0_8_3 - 0.00036534893677768*G0_8_4 - 0.00013700585129163*G0_8_6 - 0.000327291755863338*G0_8_7 + 0.00154512154512227*G0_8_8 + 0.000685029256458149*G0_8_9 + 0.00041101755387489*G0_9_3 - 0.000274011702583259*G0_9_4 - 0.00013700585129163*G0_9_5 - 0.00041101755387489*G0_9_7 + 0.000685029256458149*G0_9_8 + 0.00027401170258326*G0_9_9;
    A[86] = A[170];
    A[138] = A[170] + 0.00106560106560157*G0_3_3 - 0.000190285904571708*G0_3_4 - 0.00013700585129163*G0_3_7 + 0.00027401170258326*G0_3_9 - 0.000190285904571708*G0_4_3 + 0.00013700585129163*G0_4_8 - 0.00013700585129163*G0_4_9 + 0.00013700585129163*G0_5_5 + 0.00013700585129163*G0_5_9 - 0.00013700585129163*G0_6_6 - 0.00013700585129163*G0_6_9 - 0.00013700585129163*G0_7_3 + 0.000190285904571708*G0_7_8 + 0.000137005851291629*G0_7_9 + 0.00013700585129163*G0_8_4 + 0.000190285904571708*G0_8_7 - 0.00106560106560157*G0_8_8 - 0.000274011702583259*G0_8_9 + 0.00027401170258326*G0_9_3 - 0.000137005851291631*G0_9_4 + 0.00013700585129163*G0_9_5 - 0.00013700585129163*G0_9_6 + 0.000137005851291629*G0_9_7 - 0.000274011702583259*G0_9_8;
    A[129] = A[170] + 0.000229329753139384*G0_0_0 + 0.00025075453646894*G0_0_5 - 0.000113325827611595*G0_0_6 + 0.000369577512434829*G0_0_7 - 0.000263440263440387*G0_0_8 - 0.000229329753139385*G0_1_1 - 0.00025075453646894*G0_1_3 + 0.000113325827611595*G0_1_4 + 0.000263440263440387*G0_1_7 - 0.000369577512434829*G0_1_8 + 0.000157303014445945*G0_2_7 - 0.000157303014445945*G0_2_8 - 0.00025075453646894*G0_3_1 - 0.000620332048903768*G0_3_3 + 0.000315874601589036*G0_3_4 + 0.000243565957851786*G0_3_7 - 0.000715475001189622*G0_3_8 - 0.000433851862423494*G0_3_9 + 0.000113325827611595*G0_4_1 + 0.000315874601589036*G0_4_3 - 0.000281623138766128*G0_4_7 + 0.000471909043337836*G0_4_8 + 0.00018267446838884*G0_4_9 + 0.00025075453646894*G0_5_0 + 0.000620332048903767*G0_5_5 - 0.000315874601589035*G0_5_6 + 0.000715475001189622*G0_5_7 - 0.000243565957851786*G0_5_8 + 0.000433851862423495*G0_5_9 - 0.000113325827611595*G0_6_0 - 0.000315874601589035*G0_6_5 - 0.000471909043337836*G0_6_7 + 0.000281623138766128*G0_6_8 - 0.00018267446838884*G0_6_9 + 0.000369577512434829*G0_7_0 + 0.000263440263440387*G0_7_1 + 0.000157303014445945*G0_7_2 + 0.000243565957851786*G0_7_3 - 0.000281623138766128*G0_7_4 + 0.000715475001189622*G0_7_5 - 0.000471909043337836*G0_7_6 + 0.00154131582703084*G0_7_7 + 0.000890538033395595*G0_7_9 - 0.000263440263440387*G0_8_0 - 0.000369577512434829*G0_8_1 - 0.000157303014445945*G0_8_2 - 0.000715475001189623*G0_8_3 + 0.000471909043337836*G0_8_4 - 0.000243565957851786*G0_8_5 + 0.000281623138766128*G0_8_6 - 0.00154131582703084*G0_8_8 - 0.000890538033395594*G0_8_9 - 0.000433851862423494*G0_9_3 + 0.00018267446838884*G0_9_4 + 0.000433851862423495*G0_9_5 - 0.00018267446838884*G0_9_6 + 0.000890538033395595*G0_9_7 - 0.000890538033395594*G0_9_8;
    A[101] = A[138] + 0.0002193691082581*G0_0_0 - 0.000111634397348736*G0_0_3 + 0.000324331752903333*G0_0_5 - 0.00013362299076591*G0_0_6 + 0.000264708836137532*G0_0_7 - 0.000180560180560265*G0_0_8 - 0.0002193691082581*G0_1_1 - 0.000324331752903334*G0_1_3 + 0.000133622990765911*G0_1_4 + 0.000111634397348736*G0_1_5 + 0.000180560180560266*G0_1_7 - 0.000264708836137532*G0_1_8 - 0.00011459440030874*G0_2_3 + 0.00011459440030874*G0_2_5 - 0.000111634397348736*G0_3_0 - 0.000324331752903334*G0_3_1 - 0.00011459440030874*G0_3_2 - 0.0015489272632137*G0_3_3 + 0.000506160506160744*G0_3_4 + 0.000334903192046207*G0_3_7 - 0.000624137766995203*G0_3_8 - 0.000570857713715125*G0_3_9 + 0.000133622990765911*G0_4_1 + 0.000506160506160744*G0_4_3 - 0.000144617287474498*G0_4_4 - 0.000190285904571708*G0_4_7 + 0.000289234574948997*G0_4_8 + 0.00018267446838884*G0_4_9 + 0.000324331752903333*G0_5_0 + 0.000111634397348736*G0_5_1 + 0.00011459440030874*G0_5_2 + 0.0015489272632137*G0_5_5 - 0.000506160506160744*G0_5_6 + 0.000624137766995203*G0_5_7 - 0.000334903192046206*G0_5_8 + 0.000570857713715125*G0_5_9 - 0.00013362299076591*G0_6_0 - 0.000506160506160744*G0_6_5 + 0.000144617287474498*G0_6_6 - 0.000289234574948997*G0_6_7 + 0.000190285904571708*G0_6_8 - 0.00018267446838884*G0_6_9 + 0.000264708836137532*G0_7_0 + 0.000180560180560266*G0_7_1 + 0.000334903192046207*G0_7_3 - 0.000190285904571708*G0_7_4 + 0.000624137766995203*G0_7_5 - 0.000289234574948997*G0_7_6 + 0.000399600399600589*G0_7_7 + 0.000479520479520706*G0_7_9 - 0.000180560180560265*G0_8_0 - 0.000264708836137532*G0_8_1 - 0.000624137766995203*G0_8_3 + 0.000289234574948997*G0_8_4 - 0.000334903192046206*G0_8_5 + 0.000190285904571708*G0_8_6 - 0.000399600399600588*G0_8_8 - 0.000479520479520706*G0_8_9 - 0.000570857713715125*G0_9_3 + 0.00018267446838884*G0_9_4 + 0.000570857713715125*G0_9_5 - 0.00018267446838884*G0_9_6 + 0.000479520479520706*G0_9_7 - 0.000479520479520706*G0_9_8;
    A[126] = A[101] + 0.000128266794933522*G0_0_0 + 0.000148000148000218*G0_0_5 + 0.000357596548072907*G0_2_2 - 0.000137428708857345*G0_2_3 + 0.00025075453646894*G0_2_4 - 0.000210583067726024*G0_2_5 + 0.000517577660435047*G0_2_6 - 0.000137428708857345*G0_3_2 - 0.000243565957851787*G0_3_4 + 0.000232148803577484*G0_3_5 - 0.000304457447314734*G0_3_6 - 0.000251177394034655*G0_3_9 + 0.00025075453646894*G0_4_2 - 0.000243565957851787*G0_4_3 + 0.000715475001189623*G0_4_4 - 0.000315874601589036*G0_4_5 + 0.000620332048903769*G0_4_6 + 0.000433851862423495*G0_4_9 + 0.000148000148000218*G0_5_0 - 0.000210583067726024*G0_5_2 + 0.000232148803577484*G0_5_3 - 0.000315874601589036*G0_5_4 - 0.00049093763379501*G0_5_5 - 0.000593692022263729*G0_5_6 + 0.000167451596023104*G0_5_8 - 0.000479520479520706*G0_5_9 + 0.000517577660435047*G0_6_2 - 0.000304457447314734*G0_6_3 + 0.000620332048903769*G0_6_4 - 0.000593692022263729*G0_6_5 + 0.00105037819323583*G0_6_6 + 0.00041101755387489*G0_6_9 + 0.000167451596023104*G0_8_5 - 0.000121782978925893*G0_8_8 - 0.000251177394034655*G0_9_3 + 0.000433851862423495*G0_9_4 - 0.000479520479520706*G0_9_5 + 0.00041101755387489*G0_9_6 + 0.000137005851291628*G0_9_9;
    A[174] = A[126] + 0.000120514406228749*G0_0_3 - 0.000120514406228749*G0_0_4 - 0.000236800236800348*G0_0_5 + 0.000236800236800348*G0_0_7 + 0.000359428930857672*G0_1_1 + 0.000286274571988992*G0_1_3 - 0.00020339448910887*G0_1_4 - 0.000161954447668809*G0_1_7 + 0.000523074808789341*G0_1_8 - 0.000359428930857672*G0_2_2 + 0.000203394489108871*G0_2_3 - 0.000286274571988992*G0_2_4 + 0.00016195444766881*G0_2_5 - 0.000523074808789341*G0_2_6 + 0.000120514406228749*G0_3_0 + 0.000286274571988992*G0_3_1 + 0.00020339448910887*G0_3_2 + 0.000616526330812335*G0_3_3 - 0.000232148803577485*G0_3_5 + 0.000258788830217524*G0_3_6 - 0.000361543218686246*G0_3_7 + 0.00062033204890377*G0_3_8 + 0.00054802340516652*G0_3_9 - 0.000120514406228749*G0_4_0 - 0.00020339448910887*G0_4_1 - 0.000286274571988992*G0_4_2 - 0.000616526330812335*G0_4_4 + 0.000361543218686246*G0_4_5 - 0.000620332048903769*G0_4_6 + 0.000232148803577484*G0_4_7 - 0.000258788830217523*G0_4_8 - 0.00054802340516652*G0_4_9 - 0.000236800236800348*G0_5_0 + 0.00016195444766881*G0_5_2 - 0.000232148803577485*G0_5_3 + 0.000361543218686246*G0_5_4 - 0.000479520479520701*G0_5_5 + 0.000856286570572687*G0_5_6 - 0.000102754388468724*G0_5_8 + 0.000205508776937447*G0_5_9 - 0.000523074808789341*G0_6_2 + 0.000258788830217524*G0_6_3 - 0.000620332048903769*G0_6_4 + 0.000856286570572687*G0_6_5 - 0.00109604681033304*G0_6_6 + 0.000102754388468722*G0_6_7 - 0.000342514628229076*G0_6_9 + 0.000236800236800348*G0_7_0 - 0.000161954447668809*G0_7_1 - 0.000361543218686246*G0_7_3 + 0.000232148803577484*G0_7_4 + 0.000102754388468722*G0_7_6 + 0.000479520479520708*G0_7_7 - 0.00085628657057269*G0_7_8 - 0.000205508776937444*G0_7_9 + 0.000523074808789341*G0_8_1 + 0.000620332048903769*G0_8_3 - 0.000258788830217523*G0_8_4 - 0.000102754388468724*G0_8_5 - 0.00085628657057269*G0_8_7 + 0.00109604681033304*G0_8_8 + 0.000342514628229075*G0_8_9 + 0.00054802340516652*G0_9_3 - 0.00054802340516652*G0_9_4 + 0.000205508776937447*G0_9_5 - 0.000342514628229076*G0_9_6 - 0.000205508776937444*G0_9_7 + 0.000342514628229075*G0_9_8;
    A[50] = A[126] - 0.00035942893085767*G0_0_0 - 0.00052307480878934*G0_0_5 + 0.000161954447668809*G0_0_6 - 0.000286274571988992*G0_0_7 + 0.00020339448910887*G0_0_8 + 0.000359428930857671*G0_1_1 + 0.00052307480878934*G0_1_3 - 0.000161954447668809*G0_1_4 - 0.00020339448910887*G0_1_7 + 0.000286274571988992*G0_1_8 + 0.000236800236800349*G0_2_4 - 0.000236800236800348*G0_2_6 - 0.000120514406228748*G0_2_7 + 0.000120514406228748*G0_2_8 + 0.00052307480878934*G0_3_1 + 0.00109604681033304*G0_3_3 - 0.000856286570572688*G0_3_4 - 0.000102754388468723*G0_3_6 - 0.000258788830217523*G0_3_7 + 0.000620332048903768*G0_3_8 + 0.000342514628229074*G0_3_9 - 0.000161954447668809*G0_4_1 + 0.000236800236800349*G0_4_2 - 0.000856286570572688*G0_4_3 + 0.000479520479520705*G0_4_4 + 0.000102754388468722*G0_4_5 + 0.000232148803577484*G0_4_7 - 0.000361543218686246*G0_4_8 - 0.000205508776937444*G0_4_9 - 0.00052307480878934*G0_5_0 + 0.000102754388468722*G0_5_4 - 0.00109604681033304*G0_5_5 + 0.000856286570572686*G0_5_6 - 0.000620332048903768*G0_5_7 + 0.000258788830217522*G0_5_8 - 0.000342514628229074*G0_5_9 + 0.000161954447668809*G0_6_0 - 0.000236800236800348*G0_6_2 - 0.000102754388468723*G0_6_3 + 0.000856286570572686*G0_6_5 - 0.000479520479520705*G0_6_6 + 0.000361543218686245*G0_6_7 - 0.000232148803577484*G0_6_8 + 0.000205508776937445*G0_6_9 - 0.000286274571988992*G0_7_0 - 0.00020339448910887*G0_7_1 - 0.000120514406228748*G0_7_2 - 0.000258788830217523*G0_7_3 + 0.000232148803577484*G0_7_4 - 0.000620332048903768*G0_7_5 + 0.000361543218686245*G0_7_6 - 0.000616526330812334*G0_7_7 - 0.00054802340516652*G0_7_9 + 0.00020339448910887*G0_8_0 + 0.000286274571988992*G0_8_1 + 0.000120514406228748*G0_8_2 + 0.000620332048903768*G0_8_3 - 0.000361543218686246*G0_8_4 + 0.000258788830217522*G0_8_5 - 0.000232148803577484*G0_8_6 + 0.000616526330812335*G0_8_8 + 0.000548023405166519*G0_8_9 + 0.000342514628229074*G0_9_3 - 0.000205508776937444*G0_9_4 - 0.000342514628229074*G0_9_5 + 0.000205508776937445*G0_9_6 - 0.00054802340516652*G0_9_7 + 0.000548023405166519*G0_9_8;
    A[123] = A[170] + 0.00011459440030874*G0_0_6 - 0.00011459440030874*G0_0_8 - 0.0002193691082581*G0_1_1 - 0.000264708836137532*G0_1_3 + 0.000180560180560265*G0_1_4 + 0.000111634397348736*G0_1_6 + 0.000133622990765911*G0_1_7 - 0.000324331752903334*G0_1_8 + 0.000219369108258101*G0_2_2 - 0.000180560180560266*G0_2_3 + 0.000264708836137532*G0_2_4 - 0.000133622990765911*G0_2_5 + 0.000324331752903334*G0_2_6 - 0.000111634397348735*G0_2_8 - 0.000264708836137532*G0_3_1 - 0.000180560180560265*G0_3_2 - 0.000399600399600587*G0_3_3 + 0.000190285904571708*G0_3_5 - 0.000334903192046207*G0_3_6 + 0.000289234574948997*G0_3_7 - 0.000624137766995203*G0_3_8 - 0.000479520479520705*G0_3_9 + 0.000180560180560265*G0_4_1 + 0.000264708836137532*G0_4_2 + 0.000399600399600587*G0_4_4 - 0.000289234574948997*G0_4_5 + 0.000624137766995203*G0_4_6 - 0.000190285904571708*G0_4_7 + 0.000334903192046207*G0_4_8 + 0.000479520479520705*G0_4_9 - 0.000133622990765911*G0_5_2 + 0.000190285904571708*G0_5_3 - 0.000289234574948997*G0_5_4 + 0.000144617287474498*G0_5_5 - 0.000506160506160744*G0_5_6 - 0.00018267446838884*G0_5_9 + 0.00011459440030874*G0_6_0 + 0.000111634397348736*G0_6_1 + 0.000324331752903334*G0_6_2 - 0.000334903192046207*G0_6_3 + 0.000624137766995203*G0_6_4 - 0.000506160506160744*G0_6_5 + 0.00154892726321371*G0_6_6 + 0.000570857713715125*G0_6_9 + 0.000133622990765911*G0_7_1 + 0.000289234574948997*G0_7_3 - 0.000190285904571708*G0_7_4 - 0.000144617287474499*G0_7_7 + 0.000506160506160744*G0_7_8 + 0.00018267446838884*G0_7_9 - 0.00011459440030874*G0_8_0 - 0.000324331752903334*G0_8_1 - 0.000111634397348735*G0_8_2 - 0.000624137766995203*G0_8_3 + 0.000334903192046207*G0_8_4 + 0.000506160506160744*G0_8_7 - 0.00154892726321371*G0_8_8 - 0.000570857713715124*G0_8_9 - 0.000479520479520705*G0_9_3 + 0.000479520479520705*G0_9_4 - 0.00018267446838884*G0_9_5 + 0.000570857713715125*G0_9_6 + 0.00018267446838884*G0_9_7 - 0.000570857713715124*G0_9_8;
    A[143] = A[129];
    A[146] = A[174];
    A[54] = A[138];
    A[95] = A[138] - 0.000157303014445946*G0_0_3 + 0.000157303014445946*G0_0_4 - 0.000229329753139385*G0_1_1 - 0.000369577512434829*G0_1_3 + 0.000263440263440387*G0_1_4 + 0.000113325827611595*G0_1_7 - 0.00025075453646894*G0_1_8 + 0.000229329753139385*G0_2_2 - 0.000263440263440387*G0_2_3 + 0.000369577512434829*G0_2_4 - 0.000113325827611595*G0_2_5 + 0.00025075453646894*G0_2_6 - 0.000157303014445946*G0_3_0 - 0.000369577512434829*G0_3_1 - 0.000263440263440387*G0_3_2 - 0.00154131582703084*G0_3_3 + 0.000281623138766129*G0_3_5 - 0.000243565957851787*G0_3_6 + 0.000471909043337837*G0_3_7 - 0.000715475001189623*G0_3_8 - 0.000890538033395595*G0_3_9 + 0.000157303014445946*G0_4_0 + 0.000263440263440387*G0_4_1 + 0.000369577512434829*G0_4_2 + 0.00154131582703084*G0_4_4 - 0.000471909043337837*G0_4_5 + 0.000715475001189624*G0_4_6 - 0.000281623138766129*G0_4_7 + 0.000243565957851787*G0_4_8 + 0.000890538033395595*G0_4_9 - 0.000113325827611595*G0_5_2 + 0.000281623138766129*G0_5_3 - 0.000471909043337837*G0_5_4 - 0.000315874601589036*G0_5_6 - 0.00018267446838884*G0_5_9 + 0.00025075453646894*G0_6_2 - 0.000243565957851787*G0_6_3 + 0.000715475001189624*G0_6_4 - 0.000315874601589036*G0_6_5 + 0.000620332048903769*G0_6_6 + 0.000433851862423495*G0_6_9 + 0.000113325827611595*G0_7_1 + 0.000471909043337837*G0_7_3 - 0.000281623138766129*G0_7_4 + 0.000315874601589036*G0_7_8 + 0.00018267446838884*G0_7_9 - 0.00025075453646894*G0_8_1 - 0.000715475001189623*G0_8_3 + 0.000243565957851787*G0_8_4 + 0.000315874601589036*G0_8_7 - 0.00062033204890377*G0_8_8 - 0.000433851862423495*G0_8_9 - 0.000890538033395595*G0_9_3 + 0.000890538033395595*G0_9_4 - 0.00018267446838884*G0_9_5 + 0.000433851862423495*G0_9_6 + 0.00018267446838884*G0_9_7 - 0.000433851862423495*G0_9_8;
    A[78] = A[50];
    A[98] = A[126];
    A[136] = A[24];
    A[96] = A[99] + 0.000687378465156566*G0_0_0 + 0.000134844579289087*G0_0_2 + 0.00162800162800239*G0_0_5 - 0.000565360565360831*G0_0_6 + 0.000124320124320183*G0_0_9 + 0.000207200207200304*G0_1_5 + 0.000134844579289087*G0_2_0 + 0.000128971557543047*G0_2_2 + 0.000372960372960548*G0_2_5 - 0.000186480186480274*G0_3_5 - 0.000205508776937445*G0_3_9 + 0.00031968031968047*G0_4_4 - 0.000186480186480274*G0_4_5 + 0.000247371675943221*G0_4_6 + 0.000205508776937445*G0_4_9 + 0.00162800162800239*G0_5_0 + 0.000207200207200304*G0_5_1 + 0.000372960372960548*G0_5_2 - 0.000186480186480274*G0_5_3 - 0.000186480186480274*G0_5_4 + 0.00839160839161234*G0_5_5 - 0.00223776223776329*G0_5_6 + 0.000932400932401369*G0_5_7 - 0.000745920745921096*G0_5_8 + 0.00111888111888164*G0_5_9 - 0.000565360565360831*G0_6_0 + 0.000247371675943221*G0_6_4 - 0.00223776223776329*G0_6_5 + 0.00114171542743025*G0_6_6 - 0.000186480186480273*G0_6_7 + 0.000156034441748801*G0_6_8 + 0.000932400932401369*G0_7_5 - 0.000186480186480273*G0_7_6 - 0.000932400932401375*G0_7_7 + 0.000186480186480275*G0_7_8 - 0.000745920745921096*G0_8_5 + 0.000156034441748801*G0_8_6 + 0.000186480186480275*G0_8_7 - 0.000205508776937445*G0_8_9 + 0.000124320124320183*G0_9_0 - 0.000205508776937445*G0_9_3 + 0.000205508776937445*G0_9_4 + 0.00111888111888164*G0_9_5 - 0.000205508776937445*G0_9_8 + 0.00041101755387489*G0_9_9;
    A[81] = A[95];
    A[167] = A[41];
    A[112] = A[160] - 0.000130372273229477*G0_0_1 + 0.000130372273229477*G0_0_2 - 0.00012059369202232*G0_0_3 + 0.00012059369202232*G0_0_4 - 0.000243090243090357*G0_0_6 + 0.000243090243090358*G0_0_8 - 0.000130372273229477*G0_1_0 - 0.000539196253482221*G0_1_1 - 0.000453594025022809*G0_1_3 + 0.000287093858522565*G0_1_4 + 0.000156272299129515*G0_1_5 + 0.000276865991151835*G0_1_6 + 0.000530184101612923*G0_1_7 - 0.000410303981732746*G0_1_8 + 0.000349650349650514*G0_1_9 + 0.000130372273229477*G0_2_0 + 0.000539196253482221*G0_2_2 - 0.000287093858522565*G0_2_3 + 0.000453594025022809*G0_2_4 - 0.000530184101612922*G0_2_5 + 0.000410303981732746*G0_2_6 - 0.000156272299129516*G0_2_7 - 0.000276865991151836*G0_2_8 - 0.000349650349650514*G0_2_9 - 0.00012059369202232*G0_3_0 - 0.000453594025022809*G0_3_1 - 0.000287093858522565*G0_3_2 - 0.001066076780363*G0_3_3 - 0.000830597973455507*G0_3_6 + 0.000361781076066962*G0_3_7 - 0.00119237904952247*G0_3_8 - 0.00177251320108546*G0_3_9 + 0.00012059369202232*G0_4_0 + 0.000287093858522565*G0_4_1 + 0.000453594025022809*G0_4_2 + 0.00106607678036299*G0_4_4 - 0.000361781076066959*G0_4_5 + 0.00119237904952247*G0_4_6 + 0.000830597973455507*G0_4_8 + 0.00177251320108546*G0_4_9 + 0.000156272299129515*G0_5_1 - 0.000530184101612922*G0_5_2 - 0.000361781076066959*G0_5_4 + 0.00428571428571629*G0_5_5 + 0.00111959469102379*G0_5_6 - 0.000468816897388545*G0_5_8 + 0.000937633794777092*G0_5_9 - 0.000243090243090357*G0_6_0 + 0.000276865991151835*G0_6_1 + 0.000410303981732746*G0_6_2 - 0.000830597973455507*G0_6_3 + 0.00119237904952247*G0_6_4 + 0.00111959469102379*G0_6_5 + 0.00535179106607929*G0_6_6 + 0.000468816897388547*G0_6_7 + 0.00271014699586256*G0_6_9 + 0.000530184101612923*G0_7_1 - 0.000156272299129516*G0_7_2 + 0.000361781076066962*G0_7_3 + 0.000468816897388547*G0_7_6 - 0.00428571428571631*G0_7_7 - 0.00111959469102379*G0_7_8 - 0.000937633794777095*G0_7_9 + 0.000243090243090358*G0_8_0 - 0.000410303981732746*G0_8_1 - 0.000276865991151836*G0_8_2 - 0.00119237904952247*G0_8_3 + 0.000830597973455507*G0_8_4 - 0.000468816897388545*G0_8_5 - 0.00111959469102379*G0_8_7 - 0.0053517910660793*G0_8_8 - 0.00271014699586256*G0_8_9 + 0.000349650349650514*G0_9_1 - 0.000349650349650514*G0_9_2 - 0.00177251320108546*G0_9_3 + 0.00177251320108546*G0_9_4 + 0.000937633794777092*G0_9_5 + 0.00271014699586256*G0_9_6 - 0.000937633794777095*G0_9_7 - 0.00271014699586256*G0_9_8;
    A[223] = A[193] + 0.000121782978925893*G0_0_0 + 0.000548023405166521*G0_0_3 - 0.000304457447314733*G0_0_6 + 0.000182674468388839*G0_0_7 + 0.000182674468388841*G0_0_8 + 0.00109604681033304*G0_0_9 - 0.000121782978925894*G0_1_3 - 0.000487131915703573*G0_1_4 + 0.00054802340516652*G0_1_5 - 0.00054802340516652*G0_1_6 + 0.000487131915703574*G0_1_7 + 0.000121782978925893*G0_1_8 - 0.000121782978925893*G0_2_2 - 0.000182674468388839*G0_2_3 - 0.00018267446838884*G0_2_4 + 0.000304457447314733*G0_2_5 - 0.000548023405166519*G0_2_8 - 0.00109604681033304*G0_2_9 + 0.000548023405166521*G0_3_0 - 0.000121782978925894*G0_3_1 - 0.000182674468388839*G0_3_2 + 0.00328814043099913*G0_3_3 + 0.00164407021549956*G0_3_4 - 0.00164407021549956*G0_3_5 + 0.00164407021549956*G0_3_6 - 0.00164407021549956*G0_3_7 + 0.00328814043099913*G0_3_9 - 0.000487131915703573*G0_4_1 - 0.00018267446838884*G0_4_2 + 0.00164407021549956*G0_4_3 - 0.00164407021549956*G0_4_6 + 0.00164407021549956*G0_4_8 + 0.00328814043099912*G0_4_9 + 0.00054802340516652*G0_5_1 + 0.000304457447314733*G0_5_2 - 0.00164407021549956*G0_5_3 + 0.00328814043099912*G0_5_5 + 0.00164407021549956*G0_5_7 - 0.00164407021549956*G0_5_8 - 0.000304457447314733*G0_6_0 - 0.00054802340516652*G0_6_1 + 0.00164407021549956*G0_6_3 - 0.00164407021549956*G0_6_4 - 0.00328814043099912*G0_6_6 + 0.00164407021549956*G0_6_8 + 0.000182674468388839*G0_7_0 + 0.000487131915703574*G0_7_1 - 0.00164407021549956*G0_7_3 + 0.00164407021549956*G0_7_5 - 0.00164407021549956*G0_7_8 - 0.00328814043099912*G0_7_9 + 0.000182674468388841*G0_8_0 + 0.000121782978925893*G0_8_1 - 0.000548023405166519*G0_8_2 + 0.00164407021549956*G0_8_4 - 0.00164407021549956*G0_8_5 + 0.00164407021549956*G0_8_6 - 0.00164407021549956*G0_8_7 - 0.00328814043099912*G0_8_8 - 0.00328814043099912*G0_8_9 + 0.00109604681033304*G0_9_0 - 0.00109604681033304*G0_9_2 + 0.00328814043099913*G0_9_3 + 0.00328814043099912*G0_9_4 - 0.00328814043099912*G0_9_7 - 0.00328814043099911*G0_9_8;
    A[185] = A[88] - 0.000152228723657367*G0_0_8 - 0.000158994444708805*G0_1_1 - 0.000334903192046206*G0_1_3 + 0.00018267446838884*G0_1_7 - 0.000243565957851787*G0_1_8 - 0.00018267446838884*G0_1_9 - 0.000152228723657366*G0_2_3 + 0.000142080142080209*G0_2_7 - 0.000223268794697471*G0_2_8 - 0.000121782978925893*G0_2_9 - 0.000334903192046206*G0_3_1 - 0.000152228723657366*G0_3_2 - 0.000548023405166519*G0_3_3 + 0.00109604681033304*G0_3_4 + 0.000182674468388841*G0_3_6 + 0.00027401170258326*G0_3_7 - 0.00109604681033304*G0_3_8 + 0.00109604681033304*G0_4_3 - 0.00219209362066608*G0_4_4 + 0.000182674468388841*G0_4_5 - 0.000365348936777681*G0_4_6 - 0.000274011702583259*G0_4_7 + 0.00082203510774978*G0_4_8 + 0.000182674468388841*G0_5_4 - 0.000182674468388839*G0_5_6 + 0.000274011702583259*G0_5_7 + 0.000182674468388841*G0_6_3 - 0.000365348936777681*G0_6_4 - 0.000182674468388839*G0_6_5 + 0.000365348936777679*G0_6_6 - 0.000274011702583259*G0_6_7 + 0.00027401170258326*G0_6_8 + 0.00018267446838884*G0_7_1 + 0.000142080142080209*G0_7_2 + 0.00027401170258326*G0_7_3 - 0.000274011702583259*G0_7_4 + 0.000274011702583259*G0_7_5 - 0.00027401170258326*G0_7_6 + 0.000456686170972098*G0_7_7 + 0.0004566861709721*G0_7_8 + 0.000548023405166518*G0_7_9 - 0.000152228723657367*G0_8_0 - 0.000243565957851787*G0_8_1 - 0.000223268794697471*G0_8_2 - 0.00109604681033304*G0_8_3 + 0.00082203510774978*G0_8_4 + 0.00027401170258326*G0_8_6 + 0.0004566861709721*G0_8_7 - 0.00200941915227724*G0_8_8 - 0.00109604681033304*G0_8_9 - 0.00018267446838884*G0_9_1 - 0.000121782978925893*G0_9_2 + 0.000548023405166518*G0_9_7 - 0.00109604681033304*G0_9_8;
    A[210] = A[14];
    A[203] = A[133];
    A[3] = A[45];
    A[59] = A[213];
    A[17] = A[31];
    A[134] = A[218];
    A[69] = A[139];
    A[48] = A[80] + 0.000553097695955099*G0_0_3 - 0.000553097695955099*G0_0_4 - 0.000213120213120313*G0_0_6 + 0.000213120213120313*G0_0_8 + 0.00121068819481575*G0_1_1 + 0.0025726654298095*G0_1_3 - 0.0015628815628823*G0_1_4 - 0.000248640248640366*G0_1_6 - 0.0003687317973034*G0_1_7 + 0.000757760757761114*G0_1_8 + 0.000192823049965998*G0_1_9 - 0.00121068819481575*G0_2_2 + 0.0015628815628823*G0_2_3 - 0.0025726654298095*G0_2_4 + 0.0003687317973034*G0_2_5 - 0.000757760757761115*G0_2_6 + 0.000248640248640365*G0_2_8 - 0.000192823049965998*G0_2_9 + 0.000553097695955099*G0_3_0 + 0.0025726654298095*G0_3_1 + 0.0015628815628823*G0_3_2 + 0.00949907235621969*G0_3_3 - 0.000943818086675674*G0_3_5 + 0.000745920745921098*G0_3_6 - 0.0016592930878653*G0_3_7 + 0.00240521383378639*G0_3_8 + 0.0027401170258326*G0_3_9 - 0.000553097695955099*G0_4_0 - 0.0015628815628823*G0_4_1 - 0.0025726654298095*G0_4_2 - 0.00949907235621969*G0_4_4 + 0.0016592930878653*G0_4_5 - 0.0024052138337864*G0_4_6 + 0.000943818086675675*G0_4_7 - 0.000745920745921097*G0_4_8 - 0.0027401170258326*G0_4_9 + 0.0003687317973034*G0_5_2 - 0.000943818086675674*G0_5_3 + 0.0016592930878653*G0_5_4 - 0.000334903192046207*G0_5_5 + 0.000806812235384044*G0_5_6 - 0.00022834308548605*G0_5_8 + 0.0004566861709721*G0_5_9 - 0.000213120213120313*G0_6_0 - 0.000248640248640366*G0_6_1 - 0.000757760757761115*G0_6_2 + 0.000745920745921098*G0_6_3 - 0.0024052138337864*G0_6_4 + 0.000806812235384044*G0_6_5 - 0.00133961276818483*G0_6_6 + 0.00022834308548605*G0_6_7 - 0.0009133723419442*G0_6_9 - 0.0003687317973034*G0_7_1 - 0.0016592930878653*G0_7_3 + 0.000943818086675675*G0_7_4 + 0.00022834308548605*G0_7_6 + 0.000334903192046207*G0_7_7 - 0.000806812235384043*G0_7_8 - 0.0004566861709721*G0_7_9 + 0.000213120213120313*G0_8_0 + 0.000757760757761114*G0_8_1 + 0.000248640248640365*G0_8_2 + 0.00240521383378639*G0_8_3 - 0.000745920745921097*G0_8_4 - 0.00022834308548605*G0_8_5 - 0.000806812235384043*G0_8_7 + 0.00133961276818483*G0_8_8 + 0.0009133723419442*G0_8_9 + 0.000192823049965998*G0_9_1 - 0.000192823049965998*G0_9_2 + 0.0027401170258326*G0_9_3 - 0.0027401170258326*G0_9_4 + 0.0004566861709721*G0_9_5 - 0.0009133723419442*G0_9_6 - 0.0004566861709721*G0_9_7 + 0.0009133723419442*G0_9_8;
    A[39] = A[137];
    A[121] = A[5] + 0.00028067170924327*G0_4_4 - 0.00028067170924327*G0_6_6;
    A[87] = A[185];
    A[64] = A[160] - 0.00053919625348222*G0_0_0 - 0.000130372273229477*G0_0_1 + 0.000156272299129515*G0_0_3 + 0.000276865991151836*G0_0_4 - 0.000453594025022809*G0_0_5 + 0.000287093858522565*G0_0_6 - 0.000410303981732745*G0_0_7 + 0.000530184101612922*G0_0_8 + 0.000349650349650514*G0_0_9 - 0.000130372273229477*G0_1_0 + 0.000130372273229477*G0_1_2 - 0.000243090243090357*G0_1_4 - 0.00012059369202232*G0_1_5 + 0.00012059369202232*G0_1_6 + 0.000243090243090358*G0_1_7 + 0.000130372273229477*G0_2_1 + 0.000539196253482222*G0_2_2 - 0.000530184101612923*G0_2_3 + 0.000410303981732746*G0_2_4 - 0.000287093858522565*G0_2_5 + 0.00045359402502281*G0_2_6 - 0.000276865991151836*G0_2_7 - 0.000156272299129516*G0_2_8 - 0.000349650349650514*G0_2_9 + 0.000156272299129515*G0_3_0 - 0.000530184101612923*G0_3_2 + 0.0042857142857163*G0_3_3 + 0.00111959469102379*G0_3_4 - 0.00036178107606696*G0_3_6 - 0.000468816897388544*G0_3_7 + 0.00093763379477709*G0_3_9 + 0.000276865991151836*G0_4_0 - 0.000243090243090357*G0_4_1 + 0.000410303981732746*G0_4_2 + 0.00111959469102379*G0_4_3 + 0.0053517910660793*G0_4_4 - 0.000830597973455507*G0_4_5 + 0.00119237904952247*G0_4_6 + 0.000468816897388548*G0_4_8 + 0.00271014699586256*G0_4_9 - 0.000453594025022809*G0_5_0 - 0.00012059369202232*G0_5_1 - 0.000287093858522565*G0_5_2 - 0.000830597973455507*G0_5_4 - 0.001066076780363*G0_5_5 - 0.00119237904952247*G0_5_7 + 0.000361781076066961*G0_5_8 - 0.00177251320108546*G0_5_9 + 0.000287093858522565*G0_6_0 + 0.00012059369202232*G0_6_1 + 0.00045359402502281*G0_6_2 - 0.00036178107606696*G0_6_3 + 0.00119237904952247*G0_6_4 + 0.001066076780363*G0_6_6 + 0.000830597973455507*G0_6_7 + 0.00177251320108546*G0_6_9 - 0.000410303981732745*G0_7_0 + 0.000243090243090358*G0_7_1 - 0.000276865991151836*G0_7_2 - 0.000468816897388544*G0_7_3 - 0.00119237904952247*G0_7_5 + 0.000830597973455507*G0_7_6 - 0.0053517910660793*G0_7_7 - 0.00111959469102379*G0_7_8 - 0.00271014699586256*G0_7_9 + 0.000530184101612922*G0_8_0 - 0.000156272299129516*G0_8_2 + 0.000468816897388548*G0_8_4 + 0.000361781076066961*G0_8_5 - 0.00111959469102379*G0_8_7 - 0.00428571428571631*G0_8_8 - 0.000937633794777095*G0_8_9 + 0.000349650349650514*G0_9_0 - 0.000349650349650514*G0_9_2 + 0.00093763379477709*G0_9_3 + 0.00271014699586256*G0_9_4 - 0.00177251320108546*G0_9_5 + 0.00177251320108546*G0_9_6 - 0.00271014699586256*G0_9_7 - 0.000937633794777095*G0_9_8;
    A[162] = A[117] + 0.00030636030636045*G0_0_5 + 0.000106560106560157*G0_0_6 - 0.00030636030636045*G0_0_7 - 0.000106560106560157*G0_0_8 + 0.000194091622663143*G0_1_3 - 0.000114171542743025*G0_1_4 - 0.000308263165406168*G0_1_5 - 0.00013700585129163*G0_1_6 - 0.000220731649303182*G0_1_7 - 0.000650777793635244*G0_1_9 + 0.000114171542743025*G0_2_3 - 0.000194091622663143*G0_2_4 + 0.000220731649303181*G0_2_5 + 0.000308263165406167*G0_2_7 + 0.00013700585129163*G0_2_8 + 0.000650777793635242*G0_2_9 + 0.000194091622663143*G0_3_1 + 0.000114171542743025*G0_3_2 + 0.000822035107749781*G0_3_3 + 0.00041101755387489*G0_3_5 + 0.00041101755387489*G0_3_6 - 0.000102754388468723*G0_3_7 + 0.000513771942343613*G0_3_8 + 0.00215784215784318*G0_3_9 - 0.000114171542743025*G0_4_1 - 0.000194091622663143*G0_4_2 - 0.000822035107749779*G0_4_4 + 0.000102754388468723*G0_4_5 - 0.000513771942343613*G0_4_6 - 0.000411017553874889*G0_4_7 - 0.00041101755387489*G0_4_8 - 0.00215784215784317*G0_4_9 + 0.00030636030636045*G0_5_0 - 0.000308263165406168*G0_5_1 + 0.000220731649303181*G0_5_2 + 0.00041101755387489*G0_5_3 + 0.000102754388468723*G0_5_4 - 0.00335664335664494*G0_5_5 - 0.000633652062223786*G0_5_6 + 0.000924789496218504*G0_5_8 - 0.00184957899243701*G0_5_9 + 0.000106560106560157*G0_6_0 - 0.00013700585129163*G0_6_1 + 0.00041101755387489*G0_6_3 - 0.000513771942343613*G0_6_4 - 0.000633652062223786*G0_6_5 - 0.00130155558727049*G0_6_6 - 0.0009247894962185*G0_6_7 - 0.00277436848865551*G0_6_9 - 0.00030636030636045*G0_7_0 - 0.000220731649303183*G0_7_1 + 0.000308263165406167*G0_7_2 - 0.000102754388468723*G0_7_3 - 0.000411017553874889*G0_7_4 - 0.0009247894962185*G0_7_6 + 0.00335664335664493*G0_7_7 + 0.00063365206222379*G0_7_8 + 0.001849578992437*G0_7_9 - 0.000106560106560157*G0_8_0 + 0.00013700585129163*G0_8_2 + 0.000513771942343613*G0_8_3 - 0.00041101755387489*G0_8_4 + 0.000924789496218504*G0_8_5 + 0.00063365206222379*G0_8_7 + 0.00130155558727048*G0_8_8 + 0.00277436848865551*G0_8_9 - 0.000650777793635244*G0_9_1 + 0.000650777793635242*G0_9_2 + 0.00215784215784318*G0_9_3 - 0.00215784215784317*G0_9_4 - 0.00184957899243701*G0_9_5 - 0.00277436848865551*G0_9_6 + 0.001849578992437*G0_9_7 + 0.00277436848865551*G0_9_8;
    A[93] = A[51];
    A[166] = A[26];
    A[224] = -A[222] + 0.000115017257874455*G0_0_0 - 0.00018267446838884*G0_0_3 + 0.000913372341944199*G0_0_4 - 0.000791589363018307*G0_0_5 + 0.000761143618286833*G0_0_6 - 0.000304457447314734*G0_0_7 + 0.000152228723657367*G0_0_8 + 0.00109604681033304*G0_0_9 + 0.000236800236800348*G0_1_1 - 0.000608914894629466*G0_1_3 + 0.000943818086675673*G0_1_4 - 0.000182674468388841*G0_1_5 + 0.00146139574711072*G0_1_6 - 0.000152228723657367*G0_1_7 - 0.000243565957851786*G0_1_8 + 0.00219209362066608*G0_1_9 + 0.000331520331520487*G0_2_2 + 0.00027401170258326*G0_2_3 - 0.000365348936777679*G0_2_4 - 0.000213120213120313*G0_2_5 - 0.000487131915703572*G0_2_6 - 0.00018267446838884*G0_2_7 + 0.00036534893677768*G0_2_8 - 0.00219209362066608*G0_2_9 - 0.00018267446838884*G0_3_0 - 0.000608914894629466*G0_3_1 + 0.00027401170258326*G0_3_2 + 0.0027401170258326*G0_3_3 - 0.00383616383616564*G0_3_4 + 0.000822035107749782*G0_3_5 - 0.00493221064649868*G0_3_6 + 0.00164407021549956*G0_3_8 - 0.00657628086199824*G0_3_9 + 0.000913372341944199*G0_4_0 + 0.000943818086675673*G0_4_1 - 0.000365348936777679*G0_4_2 - 0.00383616383616564*G0_4_3 + 0.00931639788783083*G0_4_4 - 0.00328814043099912*G0_4_5 + 0.0082203510774978*G0_4_6 - 0.000822035107749782*G0_4_7 - 0.00164407021549956*G0_4_8 + 0.0131525617239965*G0_4_9 - 0.000791589363018307*G0_5_0 - 0.000182674468388841*G0_5_1 - 0.000213120213120313*G0_5_2 + 0.000822035107749782*G0_5_3 - 0.00328814043099912*G0_5_4 + 0.0027401170258326*G0_5_5 - 0.00219209362066609*G0_5_6 - 0.00328814043099912*G0_5_9 + 0.000761143618286833*G0_6_0 + 0.00146139574711072*G0_6_1 - 0.000487131915703572*G0_6_2 - 0.00493221064649868*G0_6_3 + 0.0082203510774978*G0_6_4 - 0.00219209362066609*G0_6_5 + 0.01260453831883*G0_6_6 - 0.00246610532324934*G0_6_8 + 0.0164407021549956*G0_6_9 - 0.000304457447314734*G0_7_0 - 0.000152228723657367*G0_7_1 - 0.00018267446838884*G0_7_2 - 0.000822035107749782*G0_7_4 - 0.00164407021549956*G0_7_7 - 0.00328814043099912*G0_7_9 + 0.000152228723657367*G0_8_0 - 0.000243565957851786*G0_8_1 + 0.00036534893677768*G0_8_2 + 0.00164407021549956*G0_8_3 - 0.00164407021549956*G0_8_4 - 0.00246610532324934*G0_8_6 + 0.00164407021549956*G0_8_8 - 0.00328814043099912*G0_8_9 + 0.00109604681033304*G0_9_0 + 0.00219209362066608*G0_9_1 - 0.00219209362066608*G0_9_2 - 0.00657628086199824*G0_9_3 + 0.0131525617239965*G0_9_4 - 0.00328814043099912*G0_9_5 + 0.0164407021549956*G0_9_6 - 0.00328814043099912*G0_9_7 - 0.00328814043099912*G0_9_8 + 0.0394576851719894*G0_9_9;
    A[190] = A[162];
    A[206] = A[178];
    A[0] = A[2] + 0.00104025604025653*G0_0_0 + 0.00036033411033428*G0_0_5 - 0.000167897578611943*G0_0_6 + 0.000352656602656768*G0_0_7 - 0.000167805078519443*G0_0_8 + 0.00036033411033428*G0_5_0 + 0.000321033133533285*G0_5_5 - 0.000149389301175086*G0_5_6 + 0.000149537962038032*G0_5_7 - 0.000167897578611943*G0_6_0 - 0.000149389301175086*G0_6_5 + 0.000114989177489232*G0_6_6 + 0.000352656602656768*G0_7_0 + 0.000149537962038032*G0_7_5 + 0.000281697469197601*G0_7_7 - 0.000124904857047773*G0_7_8 - 0.000167805078519443*G0_8_0 - 0.000124904857047773*G0_8_7;
    A[157] = A[0] - 0.000640856057523028*G0_0_0 + 0.000152208902208973*G0_0_5 + 0.000152208902208974*G0_0_7 + 0.000172288029430967*G0_0_9 + 0.000104658899301806*G0_1_7 + 0.000104658899301805*G0_2_5 + 0.00010488023880886*G0_3_6 + 0.00010488023880886*G0_4_8 + 0.000152208902208973*G0_5_0 + 0.000104658899301805*G0_5_2 + 0.000266994909852176*G0_5_5 - 0.000454158936302006*G0_5_6 + 0.000498489605632696*G0_5_7 - 0.000249244802816348*G0_5_8 + 0.00010488023880886*G0_6_3 - 0.000454158936302006*G0_6_5 - 0.000249244802816349*G0_6_7 + 0.000254537129537249*G0_6_8 - 0.000250642214928048*G0_6_9 + 0.000152208902208974*G0_7_0 + 0.000104658899301806*G0_7_1 + 0.000498489605632696*G0_7_5 - 0.000249244802816349*G0_7_6 + 0.00026699490985218*G0_7_7 - 0.000454158936302006*G0_7_8 + 0.00010488023880886*G0_8_4 - 0.000249244802816348*G0_8_5 + 0.000254537129537249*G0_8_6 - 0.000454158936302006*G0_8_7 - 0.000250642214928047*G0_8_9 + 0.000172288029430967*G0_9_0 - 0.000250642214928048*G0_9_6 - 0.000250642214928047*G0_9_8 - 0.000614385614385903*G0_9_9;
    A[100] = A[0] - 0.00151492026492098*G0_0_0 - 0.000105339986292417*G0_0_2 - 0.00100940725940773*G0_0_5 + 0.000465714840715059*G0_0_6 - 0.000876207126207537*G0_0_7 + 0.000412434787434981*G0_0_8 - 0.000222555222555327*G0_0_9 - 0.000220777899349432*G0_1_5 - 0.000174744237244319*G0_1_7 - 0.000105339986292417*G0_2_0 - 0.000245784308284424*G0_2_5 + 0.000102538004323767*G0_2_6 - 0.000152274973703617*G0_2_7 - 0.000109582877440072*G0_2_9 - 0.000291464487893196*G0_3_3 + 0.000215751510394469*G0_3_5 + 0.000188055991627509*G0_3_7 - 0.000195176846962653*G0_3_8 - 0.000115866276580617*G0_3_9 + 0.000119553065981694*G0_4_5 - 0.00100940725940773*G0_5_0 - 0.000220777899349432*G0_5_1 - 0.000245784308284424*G0_5_2 + 0.000215751510394469*G0_5_3 + 0.000119553065981694*G0_5_4 - 0.00317599067599217*G0_5_5 + 0.00110570976642457*G0_5_6 - 0.00153804528804601*G0_5_7 + 0.000871777032491728*G0_5_8 - 0.00107588839731748*G0_5_9 + 0.000465714840715059*G0_6_0 + 0.000102538004323767*G0_6_2 + 0.00110570976642457*G0_6_5 - 0.000426775605347235*G0_6_6 + 0.000666268255554283*G0_6_7 - 0.000341295609152913*G0_6_8 + 0.000451512772941557*G0_6_9 - 0.000876207126207537*G0_7_0 - 0.000174744237244319*G0_7_1 - 0.000152274973703617*G0_7_2 + 0.000188055991627509*G0_7_3 - 0.00153804528804601*G0_7_5 + 0.000666268255554283*G0_7_6 - 0.00157758907758982*G0_7_7 + 0.000820280909567009*G0_7_8 - 0.000664870843442586*G0_7_9 + 0.000412434787434981*G0_8_0 - 0.000195176846962653*G0_8_3 + 0.000871777032491728*G0_8_5 - 0.000341295609152913*G0_8_6 + 0.000820280909567009*G0_8_7 - 0.00054094714809026*G0_8_8 + 0.000246003996004112*G0_8_9 - 0.000222555222555327*G0_9_0 - 0.000109582877440072*G0_9_2 - 0.000115866276580617*G0_9_3 - 0.00107588839731748*G0_9_5 + 0.000451512772941557*G0_9_6 - 0.000664870843442586*G0_9_7 + 0.000246003996004112*G0_9_8 - 0.000999714571143615*G0_9_9;
    A[97] = A[100] - 0.000318200318200467*G0_0_0 - 0.000555000555000815*G0_0_5 + 0.000144300144300212*G0_0_6 - 0.000251494537208941*G0_2_2 - 0.000182357325214554*G0_2_4 - 0.000235954521668918*G0_2_6 + 0.000239760239760353*G0_3_4 - 0.000236905951191777*G0_3_5 + 0.000336806051091924*G0_3_6 - 0.000102754388468723*G0_3_7 + 0.000102754388468723*G0_3_8 + 0.000359640359640529*G0_3_9 - 0.000182357325214554*G0_4_2 + 0.000239760239760352*G0_4_3 - 0.000787783644926871*G0_4_4 + 0.000276865991151835*G0_4_5 - 0.000613672042243759*G0_4_6 + 0.000102754388468722*G0_4_7 - 0.000565149136577973*G0_4_9 - 0.000555000555000815*G0_5_0 - 0.000236905951191777*G0_5_3 + 0.000276865991151835*G0_5_4 + 0.000899100899101328*G0_5_5 + 0.00059940059940088*G0_5_6 - 0.000199800199800295*G0_5_8 + 0.000599400599400884*G0_5_9 + 0.000144300144300212*G0_6_0 - 0.000235954521668918*G0_6_2 + 0.000336806051091924*G0_6_3 - 0.000613672042243759*G0_6_4 + 0.00059940059940088*G0_6_5 - 0.00157556728985374*G0_6_6 - 0.000685029256458151*G0_6_9 - 0.000102754388468723*G0_7_3 + 0.000102754388468722*G0_7_4 + 0.000102754388468723*G0_8_3 - 0.000199800199800295*G0_8_5 + 0.00018267446838884*G0_8_8 + 0.000154131582703083*G0_8_9 + 0.000359640359640529*G0_9_3 - 0.000565149136577973*G0_9_4 + 0.000599400599400884*G0_9_5 - 0.000685029256458151*G0_9_6 + 0.000154131582703083*G0_9_8 - 0.000308263165406164*G0_9_9;
    A[111] = A[97];
    A[70] = A[157] - 0.00036130536130553*G0_0_0 - 0.000489748346891433*G0_0_5 + 0.000181723038865981*G0_0_6 - 0.0005151990866279*G0_0_7 + 0.000327529613244053*G0_0_8 - 0.000189810189810279*G0_0_9 + 0.000361305361305531*G0_1_1 + 0.000489748346891434*G0_1_3 - 0.000181723038865981*G0_1_4 - 0.000327529613244053*G0_1_7 + 0.0005151990866279*G0_1_8 + 0.000189810189810279*G0_1_9 + 0.000145806574378071*G0_2_3 - 0.000145806574378071*G0_2_5 - 0.000139860139860206*G0_2_7 + 0.000139860139860206*G0_2_8 + 0.000489748346891434*G0_3_1 + 0.000145806574378071*G0_3_2 + 0.000575852718710132*G0_3_3 - 0.000644355644355947*G0_3_4 - 0.000154131582703084*G0_3_6 - 0.000265448836877533*G0_3_7 + 0.00068502925645815*G0_3_8 - 0.000181723038865981*G0_4_1 - 0.000644355644355947*G0_4_3 + 0.000154131582703084*G0_4_5 + 0.00028685600114185*G0_4_7 - 0.000419580419580617*G0_4_8 - 0.000308263165406167*G0_4_9 - 0.000489748346891433*G0_5_0 - 0.000145806574378071*G0_5_2 + 0.000154131582703084*G0_5_4 - 0.00057585271871013*G0_5_5 + 0.000644355644355947*G0_5_6 - 0.000685029256458149*G0_5_7 + 0.000265448836877533*G0_5_8 + 0.000181723038865981*G0_6_0 - 0.000154131582703084*G0_6_3 + 0.000644355644355947*G0_6_5 + 0.000419580419580617*G0_6_7 - 0.00028685600114185*G0_6_8 + 0.000308263165406168*G0_6_9 - 0.0005151990866279*G0_7_0 - 0.000327529613244053*G0_7_1 - 0.000139860139860206*G0_7_2 - 0.000265448836877533*G0_7_3 + 0.00028685600114185*G0_7_4 - 0.000685029256458149*G0_7_5 + 0.000419580419580617*G0_7_6 - 0.00057157128585727*G0_7_7 - 0.000269730269730397*G0_7_9 + 0.000327529613244053*G0_8_0 + 0.0005151990866279*G0_8_1 + 0.000139860139860206*G0_8_2 + 0.00068502925645815*G0_8_3 - 0.000419580419580617*G0_8_4 + 0.000265448836877533*G0_8_5 - 0.00028685600114185*G0_8_6 + 0.000571571285857269*G0_8_8 + 0.000269730269730396*G0_8_9 - 0.000189810189810279*G0_9_0 + 0.000189810189810279*G0_9_1 - 0.000308263165406167*G0_9_4 + 0.000308263165406168*G0_9_6 - 0.000269730269730397*G0_9_7 + 0.000269730269730396*G0_9_8;
    A[113] = A[97] + 0.000563387230054161*G0_0_0 - 0.000104657247514439*G0_0_4 + 0.00109097251954446*G0_0_5 - 0.000600669172098025*G0_0_6 + 0.000387548958977712*G0_0_7 - 0.000190920190920281*G0_0_8 + 0.000152228723657366*G0_0_9 + 0.00011036582465159*G0_1_5 - 0.000110365824651591*G0_1_6 - 0.000563387230054162*G0_2_2 + 0.000190920190920281*G0_2_3 - 0.000387548958977713*G0_2_4 + 0.000600669172098026*G0_2_5 - 0.00109097251954446*G0_2_6 + 0.00010465724751444*G0_2_7 - 0.000152228723657367*G0_2_9 + 0.000190920190920281*G0_3_2 - 0.000114171542743025*G0_3_3 + 0.000331097473954772*G0_3_4 - 0.000199800199800294*G0_3_5 + 0.000331097473954772*G0_3_6 + 0.000137005851291629*G0_3_9 - 0.000104657247514439*G0_4_0 - 0.000387548958977713*G0_4_2 + 0.000331097473954772*G0_4_3 - 0.000559440559440822*G0_4_4 + 0.000313971742543319*G0_4_5 - 0.000645069216498091*G0_4_6 - 0.000171257314114537*G0_4_9 + 0.00109097251954446*G0_5_0 + 0.00011036582465159*G0_5_1 + 0.000600669172098026*G0_5_2 - 0.000199800199800294*G0_5_3 + 0.000313971742543319*G0_5_4 + 0.000645069216498089*G0_5_7 - 0.000331097473954772*G0_5_8 + 0.000205508776937444*G0_5_9 - 0.000600669172098025*G0_6_0 - 0.000110365824651591*G0_6_1 - 0.00109097251954446*G0_6_2 + 0.000331097473954772*G0_6_3 - 0.000645069216498091*G0_6_4 - 0.000313971742543318*G0_6_7 + 0.000199800199800293*G0_6_8 - 0.000205508776937444*G0_6_9 + 0.000387548958977712*G0_7_0 + 0.00010465724751444*G0_7_2 + 0.000645069216498089*G0_7_5 - 0.000313971742543318*G0_7_6 + 0.000559440559440823*G0_7_7 - 0.000331097473954772*G0_7_8 + 0.000171257314114538*G0_7_9 - 0.000190920190920281*G0_8_0 - 0.000331097473954772*G0_8_5 + 0.000199800199800293*G0_8_6 - 0.000331097473954772*G0_8_7 + 0.000114171542743025*G0_8_8 - 0.00013700585129163*G0_8_9 + 0.000152228723657366*G0_9_0 - 0.000152228723657367*G0_9_2 + 0.000137005851291629*G0_9_3 - 0.000171257314114537*G0_9_4 + 0.000205508776937444*G0_9_5 - 0.000205508776937444*G0_9_6 + 0.000171257314114538*G0_9_7 - 0.00013700585129163*G0_9_8;
    A[65] = A[113] + 0.000245609769419408*G0_0_0 + 0.000216608788037461*G0_0_5 + 0.000205191633763158*G0_0_7 - 0.00015444872587737*G0_0_8 - 0.000245609769419408*G0_1_1 - 0.000216608788037461*G0_1_3 + 0.00015444872587737*G0_1_7 - 0.000205191633763159*G0_1_8 + 0.000164280164280242*G0_2_3 - 0.000688200688201012*G0_2_4 - 0.000164280164280241*G0_2_5 + 0.000688200688201011*G0_2_6 + 0.000103705817991581*G0_2_7 - 0.000103705817991581*G0_2_8 - 0.000216608788037461*G0_3_1 + 0.000164280164280242*G0_3_2 - 0.00164407021549956*G0_3_3 + 0.000984729556158592*G0_3_4 + 0.000268303125446108*G0_3_7 - 0.000579420579420851*G0_3_8 - 0.000633652062223787*G0_3_9 - 0.000688200688201012*G0_4_2 + 0.000984729556158592*G0_4_3 - 0.000599400599400882*G0_4_4 - 0.000202654488368869*G0_4_7 + 0.000311117453974743*G0_4_8 + 0.00018838304552599*G0_4_9 + 0.000216608788037461*G0_5_0 - 0.000164280164280242*G0_5_2 + 0.00164407021549956*G0_5_5 - 0.000984729556158588*G0_5_6 + 0.00057942057942085*G0_5_7 - 0.000268303125446108*G0_5_8 + 0.000633652062223789*G0_5_9 + 0.000688200688201011*G0_6_2 - 0.000984729556158588*G0_6_5 + 0.000599400599400877*G0_6_6 - 0.000311117453974743*G0_6_7 + 0.000202654488368869*G0_6_8 - 0.000188383045525992*G0_6_9 + 0.000205191633763158*G0_7_0 + 0.00015444872587737*G0_7_1 + 0.000103705817991581*G0_7_2 + 0.000268303125446108*G0_7_3 - 0.000202654488368869*G0_7_4 + 0.00057942057942085*G0_7_5 - 0.000311117453974742*G0_7_6 + 0.000667903525046694*G0_7_7 + 0.000719280719281057*G0_7_9 - 0.00015444872587737*G0_8_0 - 0.000205191633763159*G0_8_1 - 0.000103705817991581*G0_8_2 - 0.000579420579420851*G0_8_3 + 0.000311117453974743*G0_8_4 - 0.000268303125446108*G0_8_5 + 0.000202654488368869*G0_8_6 - 0.000667903525046696*G0_8_8 - 0.000719280719281057*G0_8_9 - 0.000633652062223787*G0_9_3 + 0.00018838304552599*G0_9_4 + 0.000633652062223789*G0_9_5 - 0.000188383045525992*G0_9_6 + 0.000719280719281057*G0_9_7 - 0.000719280719281057*G0_9_8;
    A[153] = A[100] + 0.000481740481740707*G0_0_0 - 0.000209314495028879*G0_0_3 + 0.000680272108843856*G0_0_5 - 0.000285428856857562*G0_0_6 + 0.000614623471766617*G0_0_7 - 0.000406260406260597*G0_0_8 + 0.000104657247514439*G0_0_9 - 0.000481740481740708*G0_1_1 - 0.000680272108843857*G0_1_3 + 0.000285428856857562*G0_1_4 + 0.000209314495028879*G0_1_5 + 0.000406260406260597*G0_1_7 - 0.000614623471766618*G0_1_8 - 0.000104657247514439*G0_1_9 - 0.000222317365174613*G0_2_3 + 0.000222317365174612*G0_2_5 + 0.000197897340754577*G0_2_7 - 0.000197897340754577*G0_2_8 - 0.000209314495028879*G0_3_0 - 0.000680272108843857*G0_3_1 - 0.000222317365174613*G0_3_2 - 0.00264021692593245*G0_3_3 + 0.000956186670472834*G0_3_4 + 0.000171257314114538*G0_3_6 + 0.000627943485086637*G0_3_7 - 0.00122163550735037*G0_3_8 - 0.000941915227629956*G0_3_9 + 0.000285428856857562*G0_4_1 + 0.000956186670472834*G0_4_3 - 0.000302554588269016*G0_4_4 - 0.000171257314114538*G0_4_5 - 0.000382474668189134*G0_4_7 + 0.00059369202226373*G0_4_8 + 0.000342514628229075*G0_4_9 + 0.000680272108843857*G0_5_0 + 0.000209314495028879*G0_5_1 + 0.000222317365174612*G0_5_2 - 0.000171257314114538*G0_5_4 + 0.00264021692593245*G0_5_5 - 0.000956186670472834*G0_5_6 + 0.00122163550735037*G0_5_7 - 0.000627943485086637*G0_5_8 + 0.000941915227629957*G0_5_9 - 0.000285428856857562*G0_6_0 + 0.000171257314114538*G0_6_3 - 0.000956186670472834*G0_6_5 + 0.000302554588269016*G0_6_6 - 0.00059369202226373*G0_6_7 + 0.000382474668189134*G0_6_8 - 0.000342514628229075*G0_6_9 + 0.000614623471766617*G0_7_0 + 0.000406260406260597*G0_7_1 + 0.000197897340754577*G0_7_2 + 0.000627943485086637*G0_7_3 - 0.000382474668189134*G0_7_4 + 0.00122163550735037*G0_7_5 - 0.00059369202226373*G0_7_6 + 0.000830597973455507*G0_7_7 + 0.000873412301984142*G0_7_9 - 0.000406260406260597*G0_8_0 - 0.000614623471766618*G0_8_1 - 0.000197897340754577*G0_8_2 - 0.00122163550735037*G0_8_3 + 0.00059369202226373*G0_8_4 - 0.000627943485086637*G0_8_5 + 0.000382474668189134*G0_8_6 - 0.000830597973455508*G0_8_8 - 0.000873412301984142*G0_8_9 + 0.000104657247514439*G0_9_0 - 0.000104657247514439*G0_9_1 - 0.000941915227629956*G0_9_3 + 0.000342514628229075*G0_9_4 + 0.000941915227629957*G0_9_5 - 0.000342514628229075*G0_9_6 + 0.000873412301984142*G0_9_7 - 0.000873412301984142*G0_9_8;
    A[110] = A[153] + 0.000289234574948997*G0_0_3 - 0.000289234574948996*G0_0_4 - 0.000174111602683113*G0_0_6 + 0.000174111602683113*G0_0_8 + 0.000496681449062635*G0_1_1 + 0.000771926486212563*G0_1_3 - 0.00053058053058078*G0_1_4 - 0.000163645877931669*G0_1_6 - 0.000254983112126089*G0_1_7 + 0.000569906284192266*G0_1_8 - 0.000496681449062635*G0_2_2 + 0.00053058053058078*G0_2_3 - 0.000771926486212563*G0_2_4 + 0.000254983112126089*G0_2_5 - 0.000569906284192266*G0_2_6 + 0.000163645877931669*G0_2_8 + 0.000289234574948997*G0_3_0 + 0.000771926486212563*G0_3_1 + 0.00053058053058078*G0_3_2 + 0.00254317111460088*G0_3_3 - 0.000519480519480764*G0_3_5 + 0.000490937633795007*G0_3_6 - 0.00086770372484699*G0_3_7 + 0.001358641358642*G0_3_8 + 0.00148993863279648*G0_3_9 - 0.000289234574948996*G0_4_0 - 0.00053058053058078*G0_4_1 - 0.000771926486212563*G0_4_2 - 0.00254317111460088*G0_4_4 + 0.00086770372484699*G0_4_5 - 0.001358641358642*G0_4_6 + 0.000519480519480764*G0_4_7 - 0.000490937633795008*G0_4_8 - 0.00148993863279648*G0_4_9 + 0.000254983112126089*G0_5_2 - 0.000519480519480764*G0_5_3 + 0.00086770372484699*G0_5_4 - 0.000211217354074596*G0_5_5 + 0.000670757813615272*G0_5_6 - 0.000171257314114537*G0_5_8 + 0.000342514628229075*G0_5_9 - 0.000174111602683113*G0_6_0 - 0.000163645877931669*G0_6_1 - 0.000569906284192266*G0_6_2 + 0.000490937633795007*G0_6_3 - 0.001358641358642*G0_6_4 + 0.000670757813615272*G0_6_5 - 0.00124732410446755*G0_6_6 + 0.000171257314114537*G0_6_7 - 0.000736406450692511*G0_6_9 - 0.000254983112126089*G0_7_1 - 0.00086770372484699*G0_7_3 + 0.000519480519480764*G0_7_4 + 0.000171257314114537*G0_7_6 + 0.000211217354074598*G0_7_7 - 0.000670757813615272*G0_7_8 - 0.000342514628229074*G0_7_9 + 0.000174111602683113*G0_8_0 + 0.000569906284192266*G0_8_1 + 0.000163645877931669*G0_8_2 + 0.001358641358642*G0_8_3 - 0.000490937633795008*G0_8_4 - 0.000171257314114537*G0_8_5 - 0.000670757813615272*G0_8_7 + 0.00124732410446755*G0_8_8 + 0.000736406450692512*G0_8_9 + 0.00148993863279648*G0_9_3 - 0.00148993863279648*G0_9_4 + 0.000342514628229075*G0_9_5 - 0.000736406450692511*G0_9_6 - 0.000342514628229074*G0_9_7 + 0.000736406450692512*G0_9_8;
    A[175] = A[113] - 0.000107441059822063*G0_0_1 + 0.000107441059822063*G0_0_2 - 0.000231197374054626*G0_0_3 + 0.000231197374054625*G0_0_4 + 0.000245468816897504*G0_0_6 - 0.000245468816897504*G0_0_8 - 0.000107441059822063*G0_1_0 - 0.000808996999473571*G0_1_1 - 0.00061938061938091*G0_1_3 + 0.000425288996717768*G0_1_4 + 0.000176965891251689*G0_1_6 + 0.000509649081077892*G0_1_7 - 0.00128094128094188*G0_1_8 - 0.000119880119880176*G0_1_9 + 0.000107441059822063*G0_2_0 + 0.000808996999473571*G0_2_2 - 0.000425288996717768*G0_2_3 + 0.000619380619380911*G0_2_4 - 0.000509649081077892*G0_2_5 + 0.00128094128094188*G0_2_6 - 0.000176965891251689*G0_2_8 + 0.000119880119880176*G0_2_9 - 0.000231197374054626*G0_3_0 - 0.00061938061938091*G0_3_1 - 0.000425288996717768*G0_3_2 - 0.00111317254174449*G0_3_3 + 0.000402454688169163*G0_3_5 - 0.000530897673755065*G0_3_6 + 0.000693592122163877*G0_3_7 - 0.00122448979591894*G0_3_8 - 0.00102754388468722*G0_3_9 + 0.000231197374054625*G0_4_0 + 0.000425288996717768*G0_4_1 + 0.000619380619380911*G0_4_2 + 0.00111317254174449*G0_4_4 - 0.000693592122163877*G0_4_5 + 0.00122448979591894*G0_4_6 - 0.000402454688169163*G0_4_7 + 0.000530897673755067*G0_4_8 + 0.00102754388468722*G0_4_9 - 0.000509649081077893*G0_5_2 + 0.000402454688169163*G0_5_3 - 0.000693592122163877*G0_5_4 + 0.00109033823319589*G0_5_5 - 0.00131582703011336*G0_5_6 + 0.00011131725417445*G0_5_8 - 0.000222634508348899*G0_5_9 + 0.000245468816897504*G0_6_0 + 0.000176965891251688*G0_6_1 + 0.00128094128094188*G0_6_2 - 0.000530897673755065*G0_6_3 + 0.00122448979591894*G0_6_4 - 0.00131582703011336*G0_6_5 + 0.0018267446838884*G0_6_6 - 0.000111317254174449*G0_6_7 + 0.000702154987869603*G0_6_9 + 0.000509649081077892*G0_7_1 + 0.000693592122163877*G0_7_3 - 0.000402454688169163*G0_7_4 - 0.000111317254174449*G0_7_6 - 0.00109033823319589*G0_7_7 + 0.00131582703011336*G0_7_8 + 0.000222634508348897*G0_7_9 - 0.000245468816897504*G0_8_0 - 0.00128094128094188*G0_8_1 - 0.000176965891251689*G0_8_2 - 0.00122448979591894*G0_8_3 + 0.000530897673755067*G0_8_4 + 0.00011131725417445*G0_8_5 + 0.00131582703011336*G0_8_7 - 0.0018267446838884*G0_8_8 - 0.000702154987869604*G0_8_9 - 0.000119880119880176*G0_9_1 + 0.000119880119880176*G0_9_2 - 0.00102754388468722*G0_9_3 + 0.00102754388468722*G0_9_4 - 0.000222634508348899*G0_9_5 + 0.000702154987869603*G0_9_6 + 0.000222634508348897*G0_9_7 - 0.000702154987869604*G0_9_8;
    A[159] = A[97] - 0.000103705817991581*G0_0_3 + 0.000103705817991581*G0_0_4 + 0.000688200688201011*G0_0_5 - 0.000164280164280241*G0_0_6 - 0.000688200688201012*G0_0_7 + 0.000164280164280242*G0_0_8 - 0.000245609769419409*G0_1_1 - 0.000205191633763158*G0_1_3 + 0.00015444872587737*G0_1_4 - 0.000216608788037461*G0_1_8 + 0.000245609769419409*G0_2_2 - 0.00015444872587737*G0_2_3 + 0.000205191633763159*G0_2_4 + 0.000216608788037461*G0_2_6 - 0.000103705817991581*G0_3_0 - 0.000205191633763158*G0_3_1 - 0.00015444872587737*G0_3_2 - 0.000667903525046696*G0_3_3 + 0.00020265448836887*G0_3_5 - 0.000268303125446109*G0_3_6 + 0.000311117453974743*G0_3_7 - 0.000579420579420852*G0_3_8 - 0.000719280719281058*G0_3_9 + 0.000103705817991581*G0_4_0 + 0.00015444872587737*G0_4_1 + 0.000205191633763159*G0_4_2 + 0.000667903525046695*G0_4_4 - 0.000311117453974743*G0_4_5 + 0.000579420579420851*G0_4_6 - 0.000202654488368869*G0_4_7 + 0.000268303125446109*G0_4_8 + 0.000719280719281057*G0_4_9 + 0.000688200688201011*G0_5_0 + 0.00020265448836887*G0_5_3 - 0.000311117453974743*G0_5_4 + 0.000599400599400875*G0_5_5 - 0.000984729556158589*G0_5_6 - 0.000188383045525993*G0_5_9 - 0.000164280164280241*G0_6_0 + 0.000216608788037461*G0_6_2 - 0.000268303125446109*G0_6_3 + 0.000579420579420851*G0_6_4 - 0.000984729556158589*G0_6_5 + 0.00164407021549956*G0_6_6 + 0.00063365206222379*G0_6_9 - 0.000688200688201012*G0_7_0 + 0.000311117453974743*G0_7_3 - 0.000202654488368869*G0_7_4 - 0.000599400599400889*G0_7_7 + 0.000984729556158593*G0_7_8 + 0.000188383045525989*G0_7_9 + 0.000164280164280242*G0_8_0 - 0.000216608788037461*G0_8_1 - 0.000579420579420852*G0_8_3 + 0.000268303125446109*G0_8_4 + 0.000984729556158594*G0_8_7 - 0.00164407021549956*G0_8_8 - 0.000633652062223788*G0_8_9 - 0.000719280719281058*G0_9_3 + 0.000719280719281057*G0_9_4 - 0.000188383045525993*G0_9_5 + 0.00063365206222379*G0_9_6 + 0.000188383045525989*G0_9_7 - 0.000633652062223788*G0_9_8;
    A[142] = A[100] + 0.000133200133200196*G0_0_5 - 0.000133200133200196*G0_0_7 + 0.000205508776937446*G0_3_3 - 0.00013700585129163*G0_3_5 + 0.00013700585129163*G0_3_8 + 0.000205508776937445*G0_3_9 - 0.000205508776937445*G0_4_4 - 0.00013700585129163*G0_4_6 + 0.00013700585129163*G0_4_7 - 0.000205508776937445*G0_4_9 + 0.000133200133200196*G0_5_0 - 0.00013700585129163*G0_5_3 + 0.00159840159840235*G0_5_5 - 0.000285428856857563*G0_5_6 - 0.000205508776937446*G0_5_8 + 0.000411017553874891*G0_5_9 - 0.00013700585129163*G0_6_4 - 0.000285428856857563*G0_6_5 - 0.000114171542743024*G0_6_6 + 0.000205508776937444*G0_6_7 - 0.000205508776937445*G0_6_9 - 0.000133200133200196*G0_7_0 + 0.00013700585129163*G0_7_4 + 0.000205508776937445*G0_7_6 - 0.00159840159840235*G0_7_7 + 0.000285428856857562*G0_7_8 - 0.000411017553874888*G0_7_9 + 0.00013700585129163*G0_8_3 - 0.000205508776937446*G0_8_5 + 0.000285428856857562*G0_8_7 + 0.000114171542743025*G0_8_8 + 0.000205508776937445*G0_8_9 + 0.000205508776937445*G0_9_3 - 0.000205508776937445*G0_9_4 + 0.000411017553874892*G0_9_5 - 0.000205508776937445*G0_9_6 - 0.000411017553874888*G0_9_7 + 0.000205508776937444*G0_9_8;
    A[79] = A[65];
    A[169] = A[153] + 0.000133200133200196*G0_1_3 - 0.000133200133200196*G0_1_8 + 0.000133200133200196*G0_3_1 + 0.00159840159840235*G0_3_3 - 0.000285428856857562*G0_3_4 - 0.00013700585129163*G0_3_5 - 0.000205508776937446*G0_3_7 + 0.000411017553874891*G0_3_9 - 0.000285428856857562*G0_4_3 - 0.000114171542743024*G0_4_4 - 0.00013700585129163*G0_4_6 + 0.000205508776937444*G0_4_8 - 0.000205508776937445*G0_4_9 - 0.00013700585129163*G0_5_3 + 0.000205508776937444*G0_5_5 + 0.00013700585129163*G0_5_7 + 0.000205508776937445*G0_5_9 - 0.00013700585129163*G0_6_4 - 0.000205508776937445*G0_6_6 + 0.00013700585129163*G0_6_8 - 0.000205508776937446*G0_6_9 - 0.000205508776937446*G0_7_3 + 0.00013700585129163*G0_7_5 + 0.000114171542743026*G0_7_7 + 0.000285428856857563*G0_7_8 + 0.000205508776937445*G0_7_9 - 0.000133200133200196*G0_8_1 + 0.000205508776937444*G0_8_4 + 0.00013700585129163*G0_8_6 + 0.000285428856857563*G0_8_7 - 0.00159840159840235*G0_8_8 - 0.000411017553874888*G0_8_9 + 0.000411017553874891*G0_9_3 - 0.000205508776937446*G0_9_4 + 0.000205508776937445*G0_9_5 - 0.000205508776937446*G0_9_6 + 0.000205508776937445*G0_9_7 - 0.000411017553874888*G0_9_8;
    A[154] = A[70];
    A[71] = A[169];
    A[82] = A[110];
    A[109] = A[157] - 0.00036130536130553*G0_0_0 - 0.000515199086627899*G0_0_5 + 0.000327529613244052*G0_0_6 - 0.000489748346891433*G0_0_7 + 0.000181723038865981*G0_0_8 - 0.000189810189810279*G0_0_9 + 0.000145806574378071*G0_1_4 - 0.000139860139860205*G0_1_5 + 0.000139860139860205*G0_1_6 - 0.000145806574378071*G0_1_7 + 0.000361305361305531*G0_2_2 - 0.000181723038865982*G0_2_3 + 0.000489748346891434*G0_2_4 - 0.000327529613244053*G0_2_5 + 0.0005151990866279*G0_2_6 + 0.000189810189810279*G0_2_9 - 0.000181723038865982*G0_3_2 - 0.000644355644355946*G0_3_4 + 0.00028685600114185*G0_3_5 - 0.000419580419580616*G0_3_6 + 0.000154131582703083*G0_3_7 - 0.000308263165406166*G0_3_9 + 0.000145806574378071*G0_4_1 + 0.000489748346891434*G0_4_2 - 0.000644355644355946*G0_4_3 + 0.000575852718710133*G0_4_4 - 0.000265448836877533*G0_4_5 + 0.000685029256458149*G0_4_6 - 0.000154131582703083*G0_4_8 - 0.000515199086627899*G0_5_0 - 0.000139860139860205*G0_5_1 - 0.000327529613244053*G0_5_2 + 0.00028685600114185*G0_5_3 - 0.000265448836877533*G0_5_4 - 0.000571571285857266*G0_5_5 - 0.000685029256458149*G0_5_7 + 0.000419580419580616*G0_5_8 - 0.000269730269730396*G0_5_9 + 0.000327529613244053*G0_6_0 + 0.000139860139860205*G0_6_1 + 0.0005151990866279*G0_6_2 - 0.000419580419580616*G0_6_3 + 0.000685029256458149*G0_6_4 + 0.000571571285857268*G0_6_6 + 0.000265448836877533*G0_6_7 - 0.00028685600114185*G0_6_8 + 0.000269730269730397*G0_6_9 - 0.000489748346891434*G0_7_0 - 0.000145806574378071*G0_7_1 + 0.000154131582703083*G0_7_3 - 0.000685029256458149*G0_7_5 + 0.000265448836877533*G0_7_6 - 0.000575852718710134*G0_7_7 + 0.000644355644355947*G0_7_8 + 0.000181723038865981*G0_8_0 - 0.000154131582703083*G0_8_4 + 0.000419580419580616*G0_8_5 - 0.00028685600114185*G0_8_6 + 0.000644355644355947*G0_8_7 + 0.000308263165406167*G0_8_9 - 0.000189810189810279*G0_9_0 + 0.000189810189810279*G0_9_2 - 0.000308263165406166*G0_9_3 - 0.000269730269730396*G0_9_5 + 0.000269730269730397*G0_9_6 + 0.000308263165406167*G0_9_8;
    A[68] = A[100] + 0.000496681449062634*G0_0_0 - 0.000163645877931669*G0_0_4 + 0.000771926486212563*G0_0_5 - 0.00053058053058078*G0_0_6 + 0.000569906284192266*G0_0_7 - 0.000254983112126089*G0_0_8 - 0.000174111602683113*G0_1_4 + 0.000289234574948997*G0_1_5 - 0.000289234574948997*G0_1_6 + 0.000174111602683113*G0_1_7 - 0.000496681449062636*G0_2_2 + 0.000254983112126089*G0_2_3 - 0.000569906284192267*G0_2_4 + 0.00053058053058078*G0_2_5 - 0.000771926486212564*G0_2_6 + 0.000163645877931669*G0_2_7 + 0.000254983112126089*G0_3_2 - 0.000211217354074596*G0_3_3 + 0.000670757813615272*G0_3_4 - 0.000519480519480764*G0_3_5 + 0.00086770372484699*G0_3_6 - 0.000171257314114538*G0_3_7 + 0.000342514628229075*G0_3_9 - 0.000163645877931669*G0_4_0 - 0.000174111602683113*G0_4_1 - 0.000569906284192267*G0_4_2 + 0.000670757813615272*G0_4_3 - 0.00124732410446755*G0_4_4 + 0.000490937633795008*G0_4_5 - 0.001358641358642*G0_4_6 + 0.000171257314114537*G0_4_8 - 0.000736406450692512*G0_4_9 + 0.000771926486212563*G0_5_0 + 0.000289234574948997*G0_5_1 + 0.00053058053058078*G0_5_2 - 0.000519480519480764*G0_5_3 + 0.000490937633795008*G0_5_4 + 0.00254317111460088*G0_5_5 + 0.001358641358642*G0_5_7 - 0.00086770372484699*G0_5_8 + 0.00148993863279648*G0_5_9 - 0.00053058053058078*G0_6_0 - 0.000289234574948997*G0_6_1 - 0.000771926486212564*G0_6_2 + 0.00086770372484699*G0_6_3 - 0.001358641358642*G0_6_4 - 0.00254317111460088*G0_6_6 - 0.000490937633795007*G0_6_7 + 0.000519480519480763*G0_6_8 - 0.00148993863279648*G0_6_9 + 0.000569906284192266*G0_7_0 + 0.000174111602683113*G0_7_1 + 0.000163645877931669*G0_7_2 - 0.000171257314114538*G0_7_3 + 0.001358641358642*G0_7_5 - 0.000490937633795007*G0_7_6 + 0.00124732410446755*G0_7_7 - 0.000670757813615272*G0_7_8 + 0.000736406450692512*G0_7_9 - 0.000254983112126089*G0_8_0 + 0.000171257314114537*G0_8_4 - 0.00086770372484699*G0_8_5 + 0.000519480519480763*G0_8_6 - 0.000670757813615272*G0_8_7 + 0.000211217354074597*G0_8_8 - 0.000342514628229075*G0_8_9 + 0.000342514628229075*G0_9_3 - 0.000736406450692512*G0_9_4 + 0.00148993863279648*G0_9_5 - 0.00148993863279648*G0_9_6 + 0.000736406450692512*G0_9_7 - 0.000342514628229075*G0_9_8;
    A[55] = A[153];
    A[12] = A[0] - 0.00084028625695332*G0_0_0 - 0.000193556443556535*G0_0_5 - 0.000193556443556534*G0_0_7 + 0.000196618857333236*G0_3_3 + 0.00014101969459119*G0_3_9 + 0.000196618857333236*G0_4_4 + 0.00014101969459119*G0_4_9 - 0.000193556443556535*G0_5_0 - 0.000428737928738131*G0_5_5 + 0.000123834498834557*G0_5_6 - 0.000239343989344102*G0_5_7 + 0.000119671994672051*G0_5_8 - 0.000330919080919237*G0_5_9 + 0.000123834498834557*G0_6_5 + 0.000119671994672051*G0_6_7 + 0.000194626801769751*G0_6_9 - 0.000193556443556534*G0_7_0 - 0.000239343989344102*G0_7_5 + 0.000119671994672051*G0_7_6 - 0.00042873792873813*G0_7_7 + 0.000123834498834557*G0_7_8 - 0.000330919080919237*G0_7_9 + 0.000119671994672051*G0_8_5 + 0.000123834498834557*G0_8_7 + 0.000194626801769751*G0_8_9 + 0.00014101969459119*G0_9_3 + 0.00014101969459119*G0_9_4 - 0.000330919080919237*G0_9_5 + 0.000194626801769751*G0_9_6 - 0.000330919080919237*G0_9_7 + 0.000194626801769751*G0_9_8 + 0.000387469673184142*G0_9_9;
    A[127] = A[113];
    A[180] = A[12];
    A[49] = A[97] + 0.000808996999473569*G0_0_0 + 0.000107441059822063*G0_0_2 - 0.000176965891251689*G0_0_3 + 0.00128094128094188*G0_0_5 - 0.000509649081077891*G0_0_6 + 0.000619380619380909*G0_0_7 - 0.000425288996717768*G0_0_8 + 0.000119880119880176*G0_0_9 - 0.00080899699947357*G0_1_1 - 0.000107441059822063*G0_1_2 - 0.00128094128094188*G0_1_3 + 0.000509649081077891*G0_1_4 + 0.000176965891251688*G0_1_5 + 0.000425288996717768*G0_1_7 - 0.00061938061938091*G0_1_8 - 0.000119880119880176*G0_1_9 + 0.000107441059822063*G0_2_0 - 0.000107441059822063*G0_2_1 - 0.000245468816897503*G0_2_3 + 0.000245468816897503*G0_2_5 + 0.000231197374054625*G0_2_7 - 0.000231197374054625*G0_2_8 - 0.000176965891251689*G0_3_0 - 0.00128094128094188*G0_3_1 - 0.000245468816897503*G0_3_2 - 0.00182674468388839*G0_3_3 + 0.00131582703011336*G0_3_4 + 0.00011131725417445*G0_3_6 + 0.000530897673755066*G0_3_7 - 0.00122448979591894*G0_3_8 - 0.000702154987869602*G0_3_9 + 0.000509649081077891*G0_4_1 + 0.00131582703011336*G0_4_3 - 0.00109033823319589*G0_4_4 - 0.000111317254174449*G0_4_5 - 0.000402454688169163*G0_4_7 + 0.000693592122163876*G0_4_8 + 0.000222634508348898*G0_4_9 + 0.00128094128094188*G0_5_0 + 0.000176965891251688*G0_5_1 + 0.000245468816897503*G0_5_2 - 0.000111317254174449*G0_5_4 + 0.00182674468388839*G0_5_5 - 0.00131582703011336*G0_5_6 + 0.00122448979591894*G0_5_7 - 0.000530897673755065*G0_5_8 + 0.000702154987869602*G0_5_9 - 0.000509649081077891*G0_6_0 + 0.00011131725417445*G0_6_3 - 0.00131582703011336*G0_6_5 + 0.00109033823319589*G0_6_6 - 0.000693592122163876*G0_6_7 + 0.000402454688169163*G0_6_8 - 0.000222634508348899*G0_6_9 + 0.000619380619380909*G0_7_0 + 0.000425288996717768*G0_7_1 + 0.000231197374054625*G0_7_2 + 0.000530897673755066*G0_7_3 - 0.000402454688169163*G0_7_4 + 0.00122448979591894*G0_7_5 - 0.000693592122163876*G0_7_6 + 0.00111317254174449*G0_7_7 + 0.00102754388468722*G0_7_9 - 0.000425288996717768*G0_8_0 - 0.00061938061938091*G0_8_1 - 0.000231197374054625*G0_8_2 - 0.00122448979591894*G0_8_3 + 0.000693592122163876*G0_8_4 - 0.000530897673755065*G0_8_5 + 0.000402454688169163*G0_8_6 - 0.00111317254174449*G0_8_8 - 0.00102754388468722*G0_8_9 + 0.000119880119880176*G0_9_0 - 0.000119880119880176*G0_9_1 - 0.000702154987869602*G0_9_3 + 0.000222634508348898*G0_9_4 + 0.000702154987869602*G0_9_5 - 0.000222634508348899*G0_9_6 + 0.00102754388468722*G0_9_7 - 0.00102754388468722*G0_9_8;
    A[124] = A[68];
    A[67] = A[109];
    A[161] = A[175];
    A[156] = A[100];
    A[115] = A[157];
    A[58] = A[198];
    A[28] = A[16] - 0.00084028625695332*G0_1_1 - 0.000193556443556535*G0_1_3 - 0.000193556443556535*G0_1_8 - 0.000193556443556535*G0_3_1 - 0.000428737928738129*G0_3_3 + 0.000123834498834557*G0_3_4 + 0.000119671994672051*G0_3_7 - 0.000239343989344102*G0_3_8 - 0.000330919080919236*G0_3_9 + 0.000123834498834557*G0_4_3 + 0.000119671994672051*G0_4_8 + 0.00019462680176975*G0_4_9 + 0.000196618857333236*G0_5_5 + 0.000141019694591189*G0_5_9 + 0.000196618857333236*G0_6_6 + 0.000141019694591189*G0_6_9 + 0.000119671994672051*G0_7_3 + 0.000123834498834557*G0_7_8 + 0.00019462680176975*G0_7_9 - 0.000193556443556535*G0_8_1 - 0.000239343989344102*G0_8_3 + 0.000119671994672051*G0_8_4 + 0.000123834498834557*G0_8_7 - 0.00042873792873813*G0_8_8 - 0.000330919080919236*G0_8_9 - 0.000330919080919236*G0_9_3 + 0.00019462680176975*G0_9_4 + 0.000141019694591189*G0_9_5 + 0.000141019694591189*G0_9_6 + 0.00019462680176975*G0_9_7 - 0.000330919080919236*G0_9_8 + 0.000387469673184143*G0_9_9;
    A[131] = A[173];
    A[74] = A[214];
    A[40] = A[1] - 0.000192352290566667*G0_7_8 - 0.000192352290566667*G0_8_7 - 0.00018356643356652*G0_9_9;
    A[145] = A[159];
    A[151] = A[25];
    A[102] = A[186];
    A[177] = A[191];
    A[114] = A[142];
    A[221] = A[179];
    A[196] = A[28];
    A[209] = A[223];
    A[13] = A[195];
    A[53] = A[123];
    A[30] = A[2];
    A[23] = A[121];
    A[128] = A[125] + 0.000128971557543047*G0_0_0 + 0.000134844579289087*G0_0_2 + 0.000372960372960549*G0_0_6 + 0.000207200207200305*G0_1_6 + 0.000134844579289087*G0_2_0 + 0.000687378465156567*G0_2_2 - 0.000565360565360832*G0_2_5 + 0.0016280016280024*G0_2_6 + 0.000124320124320183*G0_2_9 + 0.000186480186480275*G0_3_4 + 0.000156034441748801*G0_3_5 - 0.000745920745921097*G0_3_6 - 0.000205508776937445*G0_3_9 + 0.000186480186480275*G0_4_3 - 0.000932400932401371*G0_4_4 - 0.000186480186480275*G0_4_5 + 0.000932400932401373*G0_4_6 - 0.000565360565360832*G0_5_2 + 0.000156034441748801*G0_5_3 - 0.000186480186480275*G0_5_4 + 0.00114171542743025*G0_5_5 - 0.00223776223776329*G0_5_6 + 0.000247371675943221*G0_5_7 + 0.000372960372960549*G0_6_0 + 0.000207200207200305*G0_6_1 + 0.0016280016280024*G0_6_2 - 0.000745920745921097*G0_6_3 + 0.000932400932401373*G0_6_4 - 0.00223776223776329*G0_6_5 + 0.00839160839161234*G0_6_6 - 0.000186480186480276*G0_6_7 - 0.000186480186480274*G0_6_8 + 0.00111888111888165*G0_6_9 + 0.000247371675943221*G0_7_5 - 0.000186480186480276*G0_7_6 + 0.000319680319680469*G0_7_7 + 0.000205508776937444*G0_7_9 - 0.000186480186480274*G0_8_6 - 0.000205508776937445*G0_8_9 + 0.000124320124320183*G0_9_2 - 0.000205508776937445*G0_9_3 + 0.00111888111888165*G0_9_6 + 0.000205508776937444*G0_9_7 - 0.000205508776937445*G0_9_8 + 0.00041101755387489*G0_9_9;
    A[63] = A[49];
    A[140] = A[84];
    A[77] = A[35];
    A[171] = A[101];
    A[152] = A[40];
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class mass_matrix_f2_p3_q4_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  mass_matrix_f2_p3_q4_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Product(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 0), Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 1)), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q4_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new mass_matrix_f2_p3_q4_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new mass_matrix_f2_p3_q4_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new mass_matrix_f2_p3_q4_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q4_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new mass_matrix_f2_p3_q4_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new mass_matrix_f2_p3_q4_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new mass_matrix_f2_p3_q4_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q4_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
