// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __MASS_MATRIX_F3_P2_Q3_TENSOR_H
#define __MASS_MATRIX_F3_P2_Q3_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class mass_matrix_f3_p2_q3_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  mass_matrix_f3_p2_q3_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f3_p2_q3_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new mass_matrix_f3_p2_q3_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class mass_matrix_f3_p2_q3_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  mass_matrix_f3_p2_q3_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f3_p2_q3_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, -0.0288675134594813, -0.0166666666666667, 0.0782460796435952, 0.0606091526731326, 0.0349927106111882, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333333, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807677, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, -0.0288675134594813, -0.0166666666666667, 0.0782460796435952, 0.0606091526731326, 0.0349927106111882, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333333, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807677, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new mass_matrix_f3_p2_q3_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class mass_matrix_f3_p2_q3_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  mass_matrix_f3_p2_q3_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~mass_matrix_f3_p2_q3_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new mass_matrix_f3_p2_q3_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class mass_matrix_f3_p2_q3_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  mass_matrix_f3_p2_q3_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~mass_matrix_f3_p2_q3_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new mass_matrix_f3_p2_q3_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class mass_matrix_f3_p2_q3_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  mass_matrix_f3_p2_q3_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f3_p2_q3_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    432
    // Number of operations (multiply-add pairs) for tensor contraction: 3464
    // Total number of operations (multiply-add pairs):                  3905
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0 = det*w[2][0]*w[0][0]*w[1][0]*(1.0);
    const double G0_0_0_1 = det*w[2][0]*w[0][0]*w[1][1]*(1.0);
    const double G0_0_0_2 = det*w[2][0]*w[0][0]*w[1][2]*(1.0);
    const double G0_0_0_3 = det*w[2][0]*w[0][0]*w[1][3]*(1.0);
    const double G0_0_0_4 = det*w[2][0]*w[0][0]*w[1][4]*(1.0);
    const double G0_0_0_5 = det*w[2][0]*w[0][0]*w[1][5]*(1.0);
    const double G0_0_1_0 = det*w[2][0]*w[0][1]*w[1][0]*(1.0);
    const double G0_0_1_1 = det*w[2][0]*w[0][1]*w[1][1]*(1.0);
    const double G0_0_1_2 = det*w[2][0]*w[0][1]*w[1][2]*(1.0);
    const double G0_0_1_3 = det*w[2][0]*w[0][1]*w[1][3]*(1.0);
    const double G0_0_1_4 = det*w[2][0]*w[0][1]*w[1][4]*(1.0);
    const double G0_0_1_5 = det*w[2][0]*w[0][1]*w[1][5]*(1.0);
    const double G0_0_2_0 = det*w[2][0]*w[0][2]*w[1][0]*(1.0);
    const double G0_0_2_1 = det*w[2][0]*w[0][2]*w[1][1]*(1.0);
    const double G0_0_2_2 = det*w[2][0]*w[0][2]*w[1][2]*(1.0);
    const double G0_0_2_3 = det*w[2][0]*w[0][2]*w[1][3]*(1.0);
    const double G0_0_2_4 = det*w[2][0]*w[0][2]*w[1][4]*(1.0);
    const double G0_0_2_5 = det*w[2][0]*w[0][2]*w[1][5]*(1.0);
    const double G0_0_3_0 = det*w[2][0]*w[0][3]*w[1][0]*(1.0);
    const double G0_0_3_1 = det*w[2][0]*w[0][3]*w[1][1]*(1.0);
    const double G0_0_3_2 = det*w[2][0]*w[0][3]*w[1][2]*(1.0);
    const double G0_0_3_3 = det*w[2][0]*w[0][3]*w[1][3]*(1.0);
    const double G0_0_3_4 = det*w[2][0]*w[0][3]*w[1][4]*(1.0);
    const double G0_0_3_5 = det*w[2][0]*w[0][3]*w[1][5]*(1.0);
    const double G0_0_4_0 = det*w[2][0]*w[0][4]*w[1][0]*(1.0);
    const double G0_0_4_1 = det*w[2][0]*w[0][4]*w[1][1]*(1.0);
    const double G0_0_4_2 = det*w[2][0]*w[0][4]*w[1][2]*(1.0);
    const double G0_0_4_3 = det*w[2][0]*w[0][4]*w[1][3]*(1.0);
    const double G0_0_4_4 = det*w[2][0]*w[0][4]*w[1][4]*(1.0);
    const double G0_0_4_5 = det*w[2][0]*w[0][4]*w[1][5]*(1.0);
    const double G0_0_5_0 = det*w[2][0]*w[0][5]*w[1][0]*(1.0);
    const double G0_0_5_1 = det*w[2][0]*w[0][5]*w[1][1]*(1.0);
    const double G0_0_5_2 = det*w[2][0]*w[0][5]*w[1][2]*(1.0);
    const double G0_0_5_3 = det*w[2][0]*w[0][5]*w[1][3]*(1.0);
    const double G0_0_5_4 = det*w[2][0]*w[0][5]*w[1][4]*(1.0);
    const double G0_0_5_5 = det*w[2][0]*w[0][5]*w[1][5]*(1.0);
    const double G0_1_0_0 = det*w[2][1]*w[0][0]*w[1][0]*(1.0);
    const double G0_1_0_1 = det*w[2][1]*w[0][0]*w[1][1]*(1.0);
    const double G0_1_0_2 = det*w[2][1]*w[0][0]*w[1][2]*(1.0);
    const double G0_1_0_3 = det*w[2][1]*w[0][0]*w[1][3]*(1.0);
    const double G0_1_0_4 = det*w[2][1]*w[0][0]*w[1][4]*(1.0);
    const double G0_1_0_5 = det*w[2][1]*w[0][0]*w[1][5]*(1.0);
    const double G0_1_1_0 = det*w[2][1]*w[0][1]*w[1][0]*(1.0);
    const double G0_1_1_1 = det*w[2][1]*w[0][1]*w[1][1]*(1.0);
    const double G0_1_1_2 = det*w[2][1]*w[0][1]*w[1][2]*(1.0);
    const double G0_1_1_3 = det*w[2][1]*w[0][1]*w[1][3]*(1.0);
    const double G0_1_1_4 = det*w[2][1]*w[0][1]*w[1][4]*(1.0);
    const double G0_1_1_5 = det*w[2][1]*w[0][1]*w[1][5]*(1.0);
    const double G0_1_2_0 = det*w[2][1]*w[0][2]*w[1][0]*(1.0);
    const double G0_1_2_1 = det*w[2][1]*w[0][2]*w[1][1]*(1.0);
    const double G0_1_2_2 = det*w[2][1]*w[0][2]*w[1][2]*(1.0);
    const double G0_1_2_3 = det*w[2][1]*w[0][2]*w[1][3]*(1.0);
    const double G0_1_2_4 = det*w[2][1]*w[0][2]*w[1][4]*(1.0);
    const double G0_1_2_5 = det*w[2][1]*w[0][2]*w[1][5]*(1.0);
    const double G0_1_3_0 = det*w[2][1]*w[0][3]*w[1][0]*(1.0);
    const double G0_1_3_1 = det*w[2][1]*w[0][3]*w[1][1]*(1.0);
    const double G0_1_3_2 = det*w[2][1]*w[0][3]*w[1][2]*(1.0);
    const double G0_1_3_3 = det*w[2][1]*w[0][3]*w[1][3]*(1.0);
    const double G0_1_3_4 = det*w[2][1]*w[0][3]*w[1][4]*(1.0);
    const double G0_1_3_5 = det*w[2][1]*w[0][3]*w[1][5]*(1.0);
    const double G0_1_4_0 = det*w[2][1]*w[0][4]*w[1][0]*(1.0);
    const double G0_1_4_1 = det*w[2][1]*w[0][4]*w[1][1]*(1.0);
    const double G0_1_4_2 = det*w[2][1]*w[0][4]*w[1][2]*(1.0);
    const double G0_1_4_3 = det*w[2][1]*w[0][4]*w[1][3]*(1.0);
    const double G0_1_4_4 = det*w[2][1]*w[0][4]*w[1][4]*(1.0);
    const double G0_1_4_5 = det*w[2][1]*w[0][4]*w[1][5]*(1.0);
    const double G0_1_5_0 = det*w[2][1]*w[0][5]*w[1][0]*(1.0);
    const double G0_1_5_1 = det*w[2][1]*w[0][5]*w[1][1]*(1.0);
    const double G0_1_5_2 = det*w[2][1]*w[0][5]*w[1][2]*(1.0);
    const double G0_1_5_3 = det*w[2][1]*w[0][5]*w[1][3]*(1.0);
    const double G0_1_5_4 = det*w[2][1]*w[0][5]*w[1][4]*(1.0);
    const double G0_1_5_5 = det*w[2][1]*w[0][5]*w[1][5]*(1.0);
    const double G0_2_0_0 = det*w[2][2]*w[0][0]*w[1][0]*(1.0);
    const double G0_2_0_1 = det*w[2][2]*w[0][0]*w[1][1]*(1.0);
    const double G0_2_0_2 = det*w[2][2]*w[0][0]*w[1][2]*(1.0);
    const double G0_2_0_3 = det*w[2][2]*w[0][0]*w[1][3]*(1.0);
    const double G0_2_0_4 = det*w[2][2]*w[0][0]*w[1][4]*(1.0);
    const double G0_2_0_5 = det*w[2][2]*w[0][0]*w[1][5]*(1.0);
    const double G0_2_1_0 = det*w[2][2]*w[0][1]*w[1][0]*(1.0);
    const double G0_2_1_1 = det*w[2][2]*w[0][1]*w[1][1]*(1.0);
    const double G0_2_1_2 = det*w[2][2]*w[0][1]*w[1][2]*(1.0);
    const double G0_2_1_3 = det*w[2][2]*w[0][1]*w[1][3]*(1.0);
    const double G0_2_1_4 = det*w[2][2]*w[0][1]*w[1][4]*(1.0);
    const double G0_2_1_5 = det*w[2][2]*w[0][1]*w[1][5]*(1.0);
    const double G0_2_2_0 = det*w[2][2]*w[0][2]*w[1][0]*(1.0);
    const double G0_2_2_1 = det*w[2][2]*w[0][2]*w[1][1]*(1.0);
    const double G0_2_2_2 = det*w[2][2]*w[0][2]*w[1][2]*(1.0);
    const double G0_2_2_3 = det*w[2][2]*w[0][2]*w[1][3]*(1.0);
    const double G0_2_2_4 = det*w[2][2]*w[0][2]*w[1][4]*(1.0);
    const double G0_2_2_5 = det*w[2][2]*w[0][2]*w[1][5]*(1.0);
    const double G0_2_3_0 = det*w[2][2]*w[0][3]*w[1][0]*(1.0);
    const double G0_2_3_1 = det*w[2][2]*w[0][3]*w[1][1]*(1.0);
    const double G0_2_3_2 = det*w[2][2]*w[0][3]*w[1][2]*(1.0);
    const double G0_2_3_3 = det*w[2][2]*w[0][3]*w[1][3]*(1.0);
    const double G0_2_3_4 = det*w[2][2]*w[0][3]*w[1][4]*(1.0);
    const double G0_2_3_5 = det*w[2][2]*w[0][3]*w[1][5]*(1.0);
    const double G0_2_4_0 = det*w[2][2]*w[0][4]*w[1][0]*(1.0);
    const double G0_2_4_1 = det*w[2][2]*w[0][4]*w[1][1]*(1.0);
    const double G0_2_4_2 = det*w[2][2]*w[0][4]*w[1][2]*(1.0);
    const double G0_2_4_3 = det*w[2][2]*w[0][4]*w[1][3]*(1.0);
    const double G0_2_4_4 = det*w[2][2]*w[0][4]*w[1][4]*(1.0);
    const double G0_2_4_5 = det*w[2][2]*w[0][4]*w[1][5]*(1.0);
    const double G0_2_5_0 = det*w[2][2]*w[0][5]*w[1][0]*(1.0);
    const double G0_2_5_1 = det*w[2][2]*w[0][5]*w[1][1]*(1.0);
    const double G0_2_5_2 = det*w[2][2]*w[0][5]*w[1][2]*(1.0);
    const double G0_2_5_3 = det*w[2][2]*w[0][5]*w[1][3]*(1.0);
    const double G0_2_5_4 = det*w[2][2]*w[0][5]*w[1][4]*(1.0);
    const double G0_2_5_5 = det*w[2][2]*w[0][5]*w[1][5]*(1.0);
    const double G0_3_0_0 = det*w[2][3]*w[0][0]*w[1][0]*(1.0);
    const double G0_3_0_1 = det*w[2][3]*w[0][0]*w[1][1]*(1.0);
    const double G0_3_0_2 = det*w[2][3]*w[0][0]*w[1][2]*(1.0);
    const double G0_3_0_3 = det*w[2][3]*w[0][0]*w[1][3]*(1.0);
    const double G0_3_0_4 = det*w[2][3]*w[0][0]*w[1][4]*(1.0);
    const double G0_3_0_5 = det*w[2][3]*w[0][0]*w[1][5]*(1.0);
    const double G0_3_1_0 = det*w[2][3]*w[0][1]*w[1][0]*(1.0);
    const double G0_3_1_1 = det*w[2][3]*w[0][1]*w[1][1]*(1.0);
    const double G0_3_1_2 = det*w[2][3]*w[0][1]*w[1][2]*(1.0);
    const double G0_3_1_3 = det*w[2][3]*w[0][1]*w[1][3]*(1.0);
    const double G0_3_1_4 = det*w[2][3]*w[0][1]*w[1][4]*(1.0);
    const double G0_3_1_5 = det*w[2][3]*w[0][1]*w[1][5]*(1.0);
    const double G0_3_2_0 = det*w[2][3]*w[0][2]*w[1][0]*(1.0);
    const double G0_3_2_1 = det*w[2][3]*w[0][2]*w[1][1]*(1.0);
    const double G0_3_2_2 = det*w[2][3]*w[0][2]*w[1][2]*(1.0);
    const double G0_3_2_3 = det*w[2][3]*w[0][2]*w[1][3]*(1.0);
    const double G0_3_2_4 = det*w[2][3]*w[0][2]*w[1][4]*(1.0);
    const double G0_3_2_5 = det*w[2][3]*w[0][2]*w[1][5]*(1.0);
    const double G0_3_3_0 = det*w[2][3]*w[0][3]*w[1][0]*(1.0);
    const double G0_3_3_1 = det*w[2][3]*w[0][3]*w[1][1]*(1.0);
    const double G0_3_3_2 = det*w[2][3]*w[0][3]*w[1][2]*(1.0);
    const double G0_3_3_3 = det*w[2][3]*w[0][3]*w[1][3]*(1.0);
    const double G0_3_3_4 = det*w[2][3]*w[0][3]*w[1][4]*(1.0);
    const double G0_3_3_5 = det*w[2][3]*w[0][3]*w[1][5]*(1.0);
    const double G0_3_4_0 = det*w[2][3]*w[0][4]*w[1][0]*(1.0);
    const double G0_3_4_1 = det*w[2][3]*w[0][4]*w[1][1]*(1.0);
    const double G0_3_4_2 = det*w[2][3]*w[0][4]*w[1][2]*(1.0);
    const double G0_3_4_3 = det*w[2][3]*w[0][4]*w[1][3]*(1.0);
    const double G0_3_4_4 = det*w[2][3]*w[0][4]*w[1][4]*(1.0);
    const double G0_3_4_5 = det*w[2][3]*w[0][4]*w[1][5]*(1.0);
    const double G0_3_5_0 = det*w[2][3]*w[0][5]*w[1][0]*(1.0);
    const double G0_3_5_1 = det*w[2][3]*w[0][5]*w[1][1]*(1.0);
    const double G0_3_5_2 = det*w[2][3]*w[0][5]*w[1][2]*(1.0);
    const double G0_3_5_3 = det*w[2][3]*w[0][5]*w[1][3]*(1.0);
    const double G0_3_5_4 = det*w[2][3]*w[0][5]*w[1][4]*(1.0);
    const double G0_3_5_5 = det*w[2][3]*w[0][5]*w[1][5]*(1.0);
    const double G0_4_0_0 = det*w[2][4]*w[0][0]*w[1][0]*(1.0);
    const double G0_4_0_1 = det*w[2][4]*w[0][0]*w[1][1]*(1.0);
    const double G0_4_0_2 = det*w[2][4]*w[0][0]*w[1][2]*(1.0);
    const double G0_4_0_3 = det*w[2][4]*w[0][0]*w[1][3]*(1.0);
    const double G0_4_0_4 = det*w[2][4]*w[0][0]*w[1][4]*(1.0);
    const double G0_4_0_5 = det*w[2][4]*w[0][0]*w[1][5]*(1.0);
    const double G0_4_1_0 = det*w[2][4]*w[0][1]*w[1][0]*(1.0);
    const double G0_4_1_1 = det*w[2][4]*w[0][1]*w[1][1]*(1.0);
    const double G0_4_1_2 = det*w[2][4]*w[0][1]*w[1][2]*(1.0);
    const double G0_4_1_3 = det*w[2][4]*w[0][1]*w[1][3]*(1.0);
    const double G0_4_1_4 = det*w[2][4]*w[0][1]*w[1][4]*(1.0);
    const double G0_4_1_5 = det*w[2][4]*w[0][1]*w[1][5]*(1.0);
    const double G0_4_2_0 = det*w[2][4]*w[0][2]*w[1][0]*(1.0);
    const double G0_4_2_1 = det*w[2][4]*w[0][2]*w[1][1]*(1.0);
    const double G0_4_2_2 = det*w[2][4]*w[0][2]*w[1][2]*(1.0);
    const double G0_4_2_3 = det*w[2][4]*w[0][2]*w[1][3]*(1.0);
    const double G0_4_2_4 = det*w[2][4]*w[0][2]*w[1][4]*(1.0);
    const double G0_4_2_5 = det*w[2][4]*w[0][2]*w[1][5]*(1.0);
    const double G0_4_3_0 = det*w[2][4]*w[0][3]*w[1][0]*(1.0);
    const double G0_4_3_1 = det*w[2][4]*w[0][3]*w[1][1]*(1.0);
    const double G0_4_3_2 = det*w[2][4]*w[0][3]*w[1][2]*(1.0);
    const double G0_4_3_3 = det*w[2][4]*w[0][3]*w[1][3]*(1.0);
    const double G0_4_3_4 = det*w[2][4]*w[0][3]*w[1][4]*(1.0);
    const double G0_4_3_5 = det*w[2][4]*w[0][3]*w[1][5]*(1.0);
    const double G0_4_4_0 = det*w[2][4]*w[0][4]*w[1][0]*(1.0);
    const double G0_4_4_1 = det*w[2][4]*w[0][4]*w[1][1]*(1.0);
    const double G0_4_4_2 = det*w[2][4]*w[0][4]*w[1][2]*(1.0);
    const double G0_4_4_3 = det*w[2][4]*w[0][4]*w[1][3]*(1.0);
    const double G0_4_4_4 = det*w[2][4]*w[0][4]*w[1][4]*(1.0);
    const double G0_4_4_5 = det*w[2][4]*w[0][4]*w[1][5]*(1.0);
    const double G0_4_5_0 = det*w[2][4]*w[0][5]*w[1][0]*(1.0);
    const double G0_4_5_1 = det*w[2][4]*w[0][5]*w[1][1]*(1.0);
    const double G0_4_5_2 = det*w[2][4]*w[0][5]*w[1][2]*(1.0);
    const double G0_4_5_3 = det*w[2][4]*w[0][5]*w[1][3]*(1.0);
    const double G0_4_5_4 = det*w[2][4]*w[0][5]*w[1][4]*(1.0);
    const double G0_4_5_5 = det*w[2][4]*w[0][5]*w[1][5]*(1.0);
    const double G0_5_0_0 = det*w[2][5]*w[0][0]*w[1][0]*(1.0);
    const double G0_5_0_1 = det*w[2][5]*w[0][0]*w[1][1]*(1.0);
    const double G0_5_0_2 = det*w[2][5]*w[0][0]*w[1][2]*(1.0);
    const double G0_5_0_3 = det*w[2][5]*w[0][0]*w[1][3]*(1.0);
    const double G0_5_0_4 = det*w[2][5]*w[0][0]*w[1][4]*(1.0);
    const double G0_5_0_5 = det*w[2][5]*w[0][0]*w[1][5]*(1.0);
    const double G0_5_1_0 = det*w[2][5]*w[0][1]*w[1][0]*(1.0);
    const double G0_5_1_1 = det*w[2][5]*w[0][1]*w[1][1]*(1.0);
    const double G0_5_1_2 = det*w[2][5]*w[0][1]*w[1][2]*(1.0);
    const double G0_5_1_3 = det*w[2][5]*w[0][1]*w[1][3]*(1.0);
    const double G0_5_1_4 = det*w[2][5]*w[0][1]*w[1][4]*(1.0);
    const double G0_5_1_5 = det*w[2][5]*w[0][1]*w[1][5]*(1.0);
    const double G0_5_2_0 = det*w[2][5]*w[0][2]*w[1][0]*(1.0);
    const double G0_5_2_1 = det*w[2][5]*w[0][2]*w[1][1]*(1.0);
    const double G0_5_2_2 = det*w[2][5]*w[0][2]*w[1][2]*(1.0);
    const double G0_5_2_3 = det*w[2][5]*w[0][2]*w[1][3]*(1.0);
    const double G0_5_2_4 = det*w[2][5]*w[0][2]*w[1][4]*(1.0);
    const double G0_5_2_5 = det*w[2][5]*w[0][2]*w[1][5]*(1.0);
    const double G0_5_3_0 = det*w[2][5]*w[0][3]*w[1][0]*(1.0);
    const double G0_5_3_1 = det*w[2][5]*w[0][3]*w[1][1]*(1.0);
    const double G0_5_3_2 = det*w[2][5]*w[0][3]*w[1][2]*(1.0);
    const double G0_5_3_3 = det*w[2][5]*w[0][3]*w[1][3]*(1.0);
    const double G0_5_3_4 = det*w[2][5]*w[0][3]*w[1][4]*(1.0);
    const double G0_5_3_5 = det*w[2][5]*w[0][3]*w[1][5]*(1.0);
    const double G0_5_4_0 = det*w[2][5]*w[0][4]*w[1][0]*(1.0);
    const double G0_5_4_1 = det*w[2][5]*w[0][4]*w[1][1]*(1.0);
    const double G0_5_4_2 = det*w[2][5]*w[0][4]*w[1][2]*(1.0);
    const double G0_5_4_3 = det*w[2][5]*w[0][4]*w[1][3]*(1.0);
    const double G0_5_4_4 = det*w[2][5]*w[0][4]*w[1][4]*(1.0);
    const double G0_5_4_5 = det*w[2][5]*w[0][4]*w[1][5]*(1.0);
    const double G0_5_5_0 = det*w[2][5]*w[0][5]*w[1][0]*(1.0);
    const double G0_5_5_1 = det*w[2][5]*w[0][5]*w[1][1]*(1.0);
    const double G0_5_5_2 = det*w[2][5]*w[0][5]*w[1][2]*(1.0);
    const double G0_5_5_3 = det*w[2][5]*w[0][5]*w[1][3]*(1.0);
    const double G0_5_5_4 = det*w[2][5]*w[0][5]*w[1][4]*(1.0);
    const double G0_5_5_5 = det*w[2][5]*w[0][5]*w[1][5]*(1.0);
    
    // Compute element tensor
    A[73] = -3.37162837162899e-05*G0_0_0_0 - 5.75317539603344e-06*G0_0_0_1 + 1.67243470814928e-05*G0_0_0_2 - 3.90680747823671e-05*G0_0_0_3 - 4.12087912087982e-05*G0_0_0_4 - 6.74325674325791e-05*G0_0_0_5 - 5.75317539603344e-06*G0_0_1_0 + 5.43206793206885e-05*G0_0_1_1 - 1.53863993149733e-05*G0_0_1_2 + 6.58270301127555e-05*G0_0_1_3 + 2.30127015841341e-05*G0_0_1_4 + 7.27843584986565e-05*G0_0_1_5 + 1.67243470814928e-05*G0_0_2_0 - 1.53863993149733e-05*G0_0_2_1 + 1.47174254317134e-06*G0_0_2_2 - 4.33495076352292e-05*G0_0_2_3 - 2.67589553303885e-06*G0_0_2_4 - 1.76609105180563e-05*G0_0_2_5 - 3.90680747823671e-05*G0_0_3_0 + 6.58270301127555e-05*G0_0_3_1 - 4.33495076352292e-05*G0_0_3_2 + 0.000211930926216676*G0_0_3_3 + 3.2110746396466e-05*G0_0_3_4 + 0.000113457970600847*G0_0_3_5 - 4.12087912087982e-05*G0_0_4_0 + 2.3012701584134e-05*G0_0_4_1 - 2.67589553303885e-06*G0_0_4_2 + 3.2110746396466e-05*G0_0_4_3 - 4.92364778079148e-05*G0_0_4_4 - 1.07035821321555e-05*G0_0_4_5 - 6.74325674325791e-05*G0_0_5_0 + 7.27843584986565e-05*G0_0_5_1 - 1.76609105180563e-05*G0_0_5_2 + 0.000113457970600847*G0_0_5_3 - 1.07035821321554e-05*G0_0_5_4 + 5.56586270872073e-05*G0_0_5_5 - 5.75317539603344e-06*G0_1_0_0 + 5.43206793206885e-05*G0_1_0_1 - 1.53863993149733e-05*G0_1_0_2 + 6.58270301127555e-05*G0_1_0_3 + 2.3012701584134e-05*G0_1_0_4 + 7.27843584986565e-05*G0_1_0_5 + 5.43206793206885e-05*G0_1_1_0 - 0.00039335664335671*G0_1_1_1 + 7.11788211788333e-05*G0_1_1_2 - 0.000299700299700351*G0_1_1_3 - 4.12087912087981e-05*G0_1_1_4 - 0.000243506493506535*G0_1_1_5 - 1.53863993149733e-05*G0_1_2_0 + 7.11788211788333e-05*G0_1_2_1 - 2.22099329242224e-05*G0_1_2_2 + 8.08120450977731e-05*G0_1_2_3 - 2.67589553303886e-06*G0_1_2_4 + 4.65605822748758e-05*G0_1_2_5 + 6.58270301127555e-05*G0_1_3_0 - 0.000299700299700351*G0_1_3_1 + 8.08120450977731e-05*G0_1_3_2 - 0.000449550449550526*G0_1_3_3 - 4.92364778079147e-05*G0_1_3_4 - 0.000224775224775263*G0_1_3_5 + 2.3012701584134e-05*G0_1_4_0 - 4.12087912087981e-05*G0_1_4_1 - 2.67589553303886e-06*G0_1_4_2 - 4.92364778079147e-05*G0_1_4_3 + 3.21107463964661e-05*G0_1_4_4 - 1.07035821321553e-05*G0_1_4_5 + 7.27843584986565e-05*G0_1_5_0 - 0.000243506493506535*G0_1_5_1 + 4.65605822748758e-05*G0_1_5_2 - 0.000224775224775263*G0_1_5_3 - 1.07035821321553e-05*G0_1_5_4 - 0.000224775224775262*G0_1_5_5 + 1.67243470814928e-05*G0_2_0_0 - 1.53863993149733e-05*G0_2_0_1 + 1.47174254317134e-06*G0_2_0_2 - 4.33495076352292e-05*G0_2_0_3 - 2.67589553303885e-06*G0_2_0_4 - 1.76609105180563e-05*G0_2_0_5 - 1.53863993149733e-05*G0_2_1_0 + 7.11788211788333e-05*G0_2_1_1 - 2.22099329242224e-05*G0_2_1_2 + 8.08120450977731e-05*G0_2_1_3 - 2.67589553303886e-06*G0_2_1_4 + 4.65605822748758e-05*G0_2_1_5 + 1.47174254317134e-06*G0_2_2_0 - 2.22099329242224e-05*G0_2_2_1 + 3.37162837162895e-05*G0_2_2_2 - 3.53218210361126e-05*G0_2_2_3 - 5.8869701726854e-06*G0_2_2_4 - 3.26459255030739e-05*G0_2_2_5 - 4.33495076352292e-05*G0_2_3_0 + 8.08120450977731e-05*G0_2_3_1 - 3.53218210361127e-05*G0_2_3_2 + 0.00033823319537611*G0_2_3_3 + 9.20508063365362e-05*G0_2_3_4 + 0.000151990866276606*G0_2_3_5 - 2.67589553303885e-06*G0_2_4_0 - 2.67589553303886e-06*G0_2_4_1 - 5.8869701726854e-06*G0_2_4_2 + 9.20508063365362e-05*G0_2_4_3 + 9.20508063365363e-05*G0_2_4_4 + 7.06436420722255e-05*G0_2_4_5 - 1.76609105180563e-05*G0_2_5_0 + 4.65605822748758e-05*G0_2_5_1 - 3.26459255030739e-05*G0_2_5_2 + 0.000151990866276606*G0_2_5_3 + 7.06436420722255e-05*G0_2_5_4 + 0.000122020836306571*G0_2_5_5 - 3.90680747823671e-05*G0_3_0_0 + 6.58270301127555e-05*G0_3_0_1 - 4.33495076352292e-05*G0_3_0_2 + 0.000211930926216676*G0_3_0_3 + 3.2110746396466e-05*G0_3_0_4 + 0.000113457970600847*G0_3_0_5 + 6.58270301127555e-05*G0_3_1_0 - 0.000299700299700351*G0_3_1_1 + 8.08120450977731e-05*G0_3_1_2 - 0.000449550449550526*G0_3_1_3 - 4.92364778079147e-05*G0_3_1_4 - 0.000224775224775263*G0_3_1_5 - 4.33495076352292e-05*G0_3_2_0 + 8.08120450977731e-05*G0_3_2_1 - 3.53218210361127e-05*G0_3_2_2 + 0.00033823319537611*G0_3_2_3 + 9.20508063365362e-05*G0_3_2_4 + 0.000151990866276606*G0_3_2_5 + 0.000211930926216676*G0_3_3_0 - 0.000449550449550526*G0_3_3_1 + 0.00033823319537611*G0_3_3_2 - 0.00196945911231659*G0_3_3_3 - 0.000325388896817523*G0_3_3_4 - 0.000727843584986565*G0_3_3_5 + 3.2110746396466e-05*G0_3_4_0 - 4.92364778079147e-05*G0_3_4_1 + 9.20508063365362e-05*G0_3_4_2 - 0.000325388896817523*G0_3_4_3 - 0.000128442985585864*G0_3_4_4 - 0.000205508776937383*G0_3_4_5 + 0.000113457970600847*G0_3_5_0 - 0.000224775224775263*G0_3_5_1 + 0.000151990866276606*G0_3_5_2 - 0.000727843584986565*G0_3_5_3 - 0.000205508776937383*G0_3_5_4 - 0.000470957613814836*G0_3_5_5 - 4.12087912087982e-05*G0_4_0_0 + 2.3012701584134e-05*G0_4_0_1 - 2.67589553303886e-06*G0_4_0_2 + 3.2110746396466e-05*G0_4_0_3 - 4.92364778079148e-05*G0_4_0_4 - 1.07035821321554e-05*G0_4_0_5 + 2.3012701584134e-05*G0_4_1_0 - 4.12087912087981e-05*G0_4_1_1 - 2.67589553303886e-06*G0_4_1_2 - 4.92364778079147e-05*G0_4_1_3 + 3.21107463964661e-05*G0_4_1_4 - 1.07035821321553e-05*G0_4_1_5 - 2.67589553303885e-06*G0_4_2_0 - 2.67589553303886e-06*G0_4_2_1 - 5.8869701726854e-06*G0_4_2_2 + 9.20508063365362e-05*G0_4_2_3 + 9.20508063365363e-05*G0_4_2_4 + 7.06436420722255e-05*G0_4_2_5 + 3.2110746396466e-05*G0_4_3_0 - 4.92364778079147e-05*G0_4_3_1 + 9.20508063365362e-05*G0_4_3_2 - 0.000325388896817523*G0_4_3_3 - 0.000128442985585864*G0_4_3_4 - 0.000205508776937383*G0_4_3_5 - 4.92364778079148e-05*G0_4_4_0 + 3.21107463964661e-05*G0_4_4_1 + 9.20508063365363e-05*G0_4_4_2 - 0.000128442985585864*G0_4_4_3 - 0.000325388896817523*G0_4_4_4 - 0.000205508776937383*G0_4_4_5 - 1.07035821321554e-05*G0_4_5_0 - 1.07035821321553e-05*G0_4_5_1 + 7.06436420722255e-05*G0_4_5_2 - 0.000205508776937383*G0_4_5_3 - 0.000205508776937383*G0_4_5_4 - 0.000222634508348832*G0_4_5_5 - 6.74325674325791e-05*G0_5_0_0 + 7.27843584986565e-05*G0_5_0_1 - 1.76609105180563e-05*G0_5_0_2 + 0.000113457970600847*G0_5_0_3 - 1.07035821321554e-05*G0_5_0_4 + 5.56586270872074e-05*G0_5_0_5 + 7.27843584986566e-05*G0_5_1_0 - 0.000243506493506535*G0_5_1_1 + 4.65605822748758e-05*G0_5_1_2 - 0.000224775224775263*G0_5_1_3 - 1.07035821321553e-05*G0_5_1_4 - 0.000224775224775262*G0_5_1_5 - 1.76609105180563e-05*G0_5_2_0 + 4.65605822748758e-05*G0_5_2_1 - 3.26459255030739e-05*G0_5_2_2 + 0.000151990866276606*G0_5_2_3 + 7.06436420722255e-05*G0_5_2_4 + 0.000122020836306571*G0_5_2_5 + 0.000113457970600847*G0_5_3_0 - 0.000224775224775263*G0_5_3_1 + 0.000151990866276606*G0_5_3_2 - 0.000727843584986565*G0_5_3_3 - 0.000205508776937383*G0_5_3_4 - 0.000470957613814836*G0_5_3_5 - 1.07035821321555e-05*G0_5_4_0 - 1.07035821321553e-05*G0_5_4_1 + 7.06436420722255e-05*G0_5_4_2 - 0.000205508776937383*G0_5_4_3 - 0.000205508776937383*G0_5_4_4 - 0.000222634508348832*G0_5_4_5 + 5.56586270872073e-05*G0_5_5_0 - 0.000224775224775262*G0_5_5_1 + 0.000122020836306571*G0_5_5_2 - 0.000470957613814836*G0_5_5_3 - 0.000222634508348832*G0_5_5_4 - 0.000428143285286216*G0_5_5_5;
    A[37] = A[73];
    A[85] = A[73] - 0.000359640359640419*G0_0_0_0 - 0.000258491508491552*G0_0_0_4 - 0.000176073926073955*G0_0_0_5 - 0.00017982017982021*G0_0_3_3 - 0.000124161552733002*G0_0_3_5 - 0.000258491508491552*G0_0_4_0 - 0.00040031397174261*G0_0_4_4 - 0.000214071642643107*G0_0_4_5 - 0.000176073926073955*G0_0_5_0 - 0.000124161552733002*G0_0_5_3 - 0.000214071642643107*G0_0_5_4 - 0.00028043385186247*G0_0_5_5 + 0.00035964035964042*G0_1_1_1 + 0.000258491508491552*G0_1_1_3 + 0.000176073926073955*G0_1_1_5 + 0.000258491508491552*G0_1_3_1 + 0.000400313971742611*G0_1_3_3 + 0.000214071642643107*G0_1_3_5 + 0.00017982017982021*G0_1_4_4 + 0.000124161552733002*G0_1_4_5 + 0.000176073926073956*G0_1_5_1 + 0.000214071642643107*G0_1_5_3 + 0.000124161552733002*G0_1_5_4 + 0.00028043385186247*G0_1_5_5 - 0.000246182389039574*G0_2_3_3 + 0.000246182389039573*G0_2_4_4 - 0.00017982017982021*G0_3_0_3 - 0.000124161552733002*G0_3_0_5 + 0.000258491508491552*G0_3_1_1 + 0.000400313971742611*G0_3_1_3 + 0.000214071642643107*G0_3_1_5 - 0.000246182389039574*G0_3_2_3 - 0.00017982017982021*G0_3_3_0 + 0.000400313971742611*G0_3_3_1 - 0.000246182389039574*G0_3_3_2 + 0.00164407021549906*G0_3_3_3 + 0.000196945911231658*G0_3_3_4 + 0.000522334808049182*G0_3_3_5 + 0.000196945911231658*G0_3_4_3 - 0.000196945911231659*G0_3_4_4 - 0.000124161552733002*G0_3_5_0 + 0.000214071642643107*G0_3_5_1 + 0.000522334808049182*G0_3_5_3 + 0.000248323105466004*G0_3_5_5 - 0.000258491508491552*G0_4_0_0 - 0.00040031397174261*G0_4_0_4 - 0.000214071642643107*G0_4_0_5 + 0.00017982017982021*G0_4_1_4 + 0.000124161552733002*G0_4_1_5 + 0.000246182389039573*G0_4_2_4 + 0.000196945911231658*G0_4_3_3 - 0.000196945911231659*G0_4_3_4 - 0.00040031397174261*G0_4_4_0 + 0.00017982017982021*G0_4_4_1 + 0.000246182389039573*G0_4_4_2 - 0.000196945911231659*G0_4_4_3 - 0.00164407021549906*G0_4_4_4 - 0.000522334808049181*G0_4_4_5 - 0.000214071642643107*G0_4_5_0 + 0.000124161552733002*G0_4_5_1 - 0.000522334808049181*G0_4_5_4 - 0.000248323105466004*G0_4_5_5 - 0.000176073926073955*G0_5_0_0 - 0.000124161552733002*G0_5_0_3 - 0.000214071642643107*G0_5_0_4 - 0.00028043385186247*G0_5_0_5 + 0.000176073926073956*G0_5_1_1 + 0.000214071642643107*G0_5_1_3 + 0.000124161552733002*G0_5_1_4 + 0.00028043385186247*G0_5_1_5 - 0.000124161552733002*G0_5_3_0 + 0.000214071642643107*G0_5_3_1 + 0.000522334808049182*G0_5_3_3 + 0.000248323105466004*G0_5_3_5 - 0.000214071642643107*G0_5_4_0 + 0.000124161552733002*G0_5_4_1 - 0.000522334808049181*G0_5_4_4 - 0.000248323105466004*G0_5_4_5 - 0.00028043385186247*G0_5_5_0 + 0.00028043385186247*G0_5_5_1 + 0.000248323105466004*G0_5_5_3 - 0.000248323105466004*G0_5_5_4;
    A[58] = A[85];
    A[99] = -0.000115598687027278*G0_0_0_1 - 0.000115598687027278*G0_0_0_2 + 0.000635792778650029*G0_0_0_3 + 0.000674325674325788*G0_0_0_4 + 0.000674325674325788*G0_0_0_5 - 0.000115598687027278*G0_0_1_0 - 0.000115598687027278*G0_0_1_1 + 1.44498358784097e-05*G0_0_1_2 + 0.000288996717568195*G0_0_1_3 + 0.000288996717568195*G0_0_1_4 + 7.70657913515187e-05*G0_0_1_5 - 0.000115598687027278*G0_0_2_0 + 1.44498358784097e-05*G0_0_2_1 - 0.000115598687027278*G0_0_2_2 + 0.000288996717568195*G0_0_2_3 + 7.70657913515188e-05*G0_0_2_4 + 0.000288996717568195*G0_0_2_5 + 0.000635792778650029*G0_0_3_0 + 0.000288996717568195*G0_0_3_1 + 0.000288996717568195*G0_0_3_2 - 0.00277436848865467*G0_0_3_3 - 0.00184957899243645*G0_0_3_4 - 0.00184957899243645*G0_0_3_5 + 0.000674325674325788*G0_0_4_0 + 0.000288996717568195*G0_0_4_1 + 7.70657913515188e-05*G0_0_4_2 - 0.00184957899243645*G0_0_4_3 - 0.00154131582703037*G0_0_4_4 - 0.00115598687027278*G0_0_4_5 + 0.000674325674325788*G0_0_5_0 + 7.70657913515187e-05*G0_0_5_1 + 0.000288996717568195*G0_0_5_2 - 0.00184957899243645*G0_0_5_3 - 0.00115598687027278*G0_0_5_4 - 0.00154131582703037*G0_0_5_5 - 0.000115598687027278*G0_1_0_0 - 0.000115598687027278*G0_1_0_1 + 1.44498358784097e-05*G0_1_0_2 + 0.000288996717568195*G0_1_0_3 + 0.000288996717568195*G0_1_0_4 + 7.70657913515187e-05*G0_1_0_5 - 0.000115598687027278*G0_1_1_0 - 0.000115598687027278*G0_1_1_2 + 0.000674325674325788*G0_1_1_3 + 0.000635792778650029*G0_1_1_4 + 0.000674325674325788*G0_1_1_5 + 1.44498358784097e-05*G0_1_2_0 - 0.000115598687027278*G0_1_2_1 - 0.000115598687027278*G0_1_2_2 + 7.70657913515188e-05*G0_1_2_3 + 0.000288996717568195*G0_1_2_4 + 0.000288996717568195*G0_1_2_5 + 0.000288996717568195*G0_1_3_0 + 0.000674325674325788*G0_1_3_1 + 7.70657913515189e-05*G0_1_3_2 - 0.00154131582703037*G0_1_3_3 - 0.00184957899243645*G0_1_3_4 - 0.00115598687027278*G0_1_3_5 + 0.000288996717568195*G0_1_4_0 + 0.000635792778650029*G0_1_4_1 + 0.000288996717568195*G0_1_4_2 - 0.00184957899243645*G0_1_4_3 - 0.00277436848865467*G0_1_4_4 - 0.00184957899243645*G0_1_4_5 + 7.70657913515187e-05*G0_1_5_0 + 0.000674325674325788*G0_1_5_1 + 0.000288996717568195*G0_1_5_2 - 0.00115598687027278*G0_1_5_3 - 0.00184957899243645*G0_1_5_4 - 0.00154131582703037*G0_1_5_5 - 0.000115598687027278*G0_2_0_0 + 1.44498358784097e-05*G0_2_0_1 - 0.000115598687027278*G0_2_0_2 + 0.000288996717568195*G0_2_0_3 + 7.70657913515188e-05*G0_2_0_4 + 0.000288996717568195*G0_2_0_5 + 1.44498358784097e-05*G0_2_1_0 - 0.000115598687027278*G0_2_1_1 - 0.000115598687027278*G0_2_1_2 + 7.70657913515188e-05*G0_2_1_3 + 0.000288996717568195*G0_2_1_4 + 0.000288996717568195*G0_2_1_5 - 0.000115598687027278*G0_2_2_0 - 0.000115598687027278*G0_2_2_1 + 0.000674325674325788*G0_2_2_3 + 0.000674325674325788*G0_2_2_4 + 0.000635792778650029*G0_2_2_5 + 0.000288996717568195*G0_2_3_0 + 7.70657913515189e-05*G0_2_3_1 + 0.000674325674325788*G0_2_3_2 - 0.00154131582703037*G0_2_3_3 - 0.00115598687027278*G0_2_3_4 - 0.00184957899243645*G0_2_3_5 + 7.70657913515189e-05*G0_2_4_0 + 0.000288996717568195*G0_2_4_1 + 0.000674325674325788*G0_2_4_2 - 0.00115598687027278*G0_2_4_3 - 0.00154131582703037*G0_2_4_4 - 0.00184957899243645*G0_2_4_5 + 0.000288996717568195*G0_2_5_0 + 0.000288996717568195*G0_2_5_1 + 0.000635792778650029*G0_2_5_2 - 0.00184957899243645*G0_2_5_3 - 0.00184957899243645*G0_2_5_4 - 0.00277436848865467*G0_2_5_5 + 0.000635792778650029*G0_3_0_0 + 0.000288996717568195*G0_3_0_1 + 0.000288996717568195*G0_3_0_2 - 0.00277436848865467*G0_3_0_3 - 0.00184957899243645*G0_3_0_4 - 0.00184957899243645*G0_3_0_5 + 0.000288996717568195*G0_3_1_0 + 0.000674325674325788*G0_3_1_1 + 7.70657913515188e-05*G0_3_1_2 - 0.00154131582703037*G0_3_1_3 - 0.00184957899243645*G0_3_1_4 - 0.00115598687027278*G0_3_1_5 + 0.000288996717568195*G0_3_2_0 + 7.70657913515188e-05*G0_3_2_1 + 0.000674325674325788*G0_3_2_2 - 0.00154131582703037*G0_3_2_3 - 0.00115598687027278*G0_3_2_4 - 0.00184957899243645*G0_3_2_5 - 0.00277436848865467*G0_3_3_0 - 0.00154131582703037*G0_3_3_1 - 0.00154131582703037*G0_3_3_2 + 0.0154131582703037*G0_3_3_3 + 0.00924789496218223*G0_3_3_4 + 0.00924789496218224*G0_3_3_5 - 0.00184957899243645*G0_3_4_0 - 0.00184957899243645*G0_3_4_1 - 0.00115598687027278*G0_3_4_2 + 0.00924789496218224*G0_3_4_3 + 0.00924789496218224*G0_3_4_4 + 0.00739831596974579*G0_3_4_5 - 0.00184957899243645*G0_3_5_0 - 0.00115598687027278*G0_3_5_1 - 0.00184957899243645*G0_3_5_2 + 0.00924789496218224*G0_3_5_3 + 0.00739831596974579*G0_3_5_4 + 0.00924789496218224*G0_3_5_5 + 0.000674325674325788*G0_4_0_0 + 0.000288996717568195*G0_4_0_1 + 7.70657913515188e-05*G0_4_0_2 - 0.00184957899243645*G0_4_0_3 - 0.00154131582703037*G0_4_0_4 - 0.00115598687027278*G0_4_0_5 + 0.000288996717568195*G0_4_1_0 + 0.000635792778650029*G0_4_1_1 + 0.000288996717568195*G0_4_1_2 - 0.00184957899243645*G0_4_1_3 - 0.00277436848865467*G0_4_1_4 - 0.00184957899243645*G0_4_1_5 + 7.70657913515188e-05*G0_4_2_0 + 0.000288996717568195*G0_4_2_1 + 0.000674325674325788*G0_4_2_2 - 0.00115598687027278*G0_4_2_3 - 0.00154131582703037*G0_4_2_4 - 0.00184957899243645*G0_4_2_5 - 0.00184957899243645*G0_4_3_0 - 0.00184957899243645*G0_4_3_1 - 0.00115598687027278*G0_4_3_2 + 0.00924789496218224*G0_4_3_3 + 0.00924789496218224*G0_4_3_4 + 0.00739831596974579*G0_4_3_5 - 0.00154131582703037*G0_4_4_0 - 0.00277436848865467*G0_4_4_1 - 0.00154131582703037*G0_4_4_2 + 0.00924789496218224*G0_4_4_3 + 0.0154131582703037*G0_4_4_4 + 0.00924789496218224*G0_4_4_5 - 0.00115598687027278*G0_4_5_0 - 0.00184957899243645*G0_4_5_1 - 0.00184957899243645*G0_4_5_2 + 0.00739831596974579*G0_4_5_3 + 0.00924789496218224*G0_4_5_4 + 0.00924789496218223*G0_4_5_5 + 0.000674325674325788*G0_5_0_0 + 7.70657913515187e-05*G0_5_0_1 + 0.000288996717568195*G0_5_0_2 - 0.00184957899243645*G0_5_0_3 - 0.00115598687027278*G0_5_0_4 - 0.00154131582703037*G0_5_0_5 + 7.70657913515187e-05*G0_5_1_0 + 0.000674325674325788*G0_5_1_1 + 0.000288996717568195*G0_5_1_2 - 0.00115598687027278*G0_5_1_3 - 0.00184957899243645*G0_5_1_4 - 0.00154131582703037*G0_5_1_5 + 0.000288996717568195*G0_5_2_0 + 0.000288996717568195*G0_5_2_1 + 0.000635792778650029*G0_5_2_2 - 0.00184957899243645*G0_5_2_3 - 0.00184957899243645*G0_5_2_4 - 0.00277436848865467*G0_5_2_5 - 0.00184957899243645*G0_5_3_0 - 0.00115598687027278*G0_5_3_1 - 0.00184957899243645*G0_5_3_2 + 0.00924789496218224*G0_5_3_3 + 0.00739831596974579*G0_5_3_4 + 0.00924789496218224*G0_5_3_5 - 0.00115598687027278*G0_5_4_0 - 0.00184957899243645*G0_5_4_1 - 0.00184957899243645*G0_5_4_2 + 0.00739831596974579*G0_5_4_3 + 0.00924789496218224*G0_5_4_4 + 0.00924789496218223*G0_5_4_5 - 0.00154131582703037*G0_5_5_0 - 0.00154131582703037*G0_5_5_1 - 0.00277436848865467*G0_5_5_2 + 0.00924789496218224*G0_5_5_3 + 0.00924789496218223*G0_5_5_4 + 0.0154131582703037*G0_5_5_5;
    A[86] = A[85] + 0.000590034965035063*G0_0_0_0 - 0.00010195161980878*G0_0_0_2 + 0.000393356643356709*G0_0_0_4 + 0.000337162837162894*G0_0_0_5 - 0.000105965463108338*G0_0_1_4 - 0.00010195161980878*G0_0_2_0 + 0.000141287284144451*G0_0_3_4 + 0.000102754388468691*G0_0_3_5 + 0.000393356643356709*G0_0_4_0 - 0.000105965463108338*G0_0_4_1 + 0.000141287284144451*G0_0_4_3 + 0.000738547167118719*G0_0_4_4 + 0.000385328956757593*G0_0_4_5 + 0.000337162837162894*G0_0_5_0 + 0.000102754388468691*G0_0_5_3 + 0.000385328956757593*G0_0_5_4 + 0.000513771942343457*G0_0_5_5 - 0.000105965463108338*G0_1_0_4 - 0.000105965463108338*G0_1_4_0 - 0.000141287284144451*G0_1_4_4 - 0.000141287284144451*G0_1_4_5 - 0.000141287284144451*G0_1_5_4 - 0.000231197374054555*G0_1_5_5 - 0.00010195161980878*G0_2_0_0 - 0.000102754388468691*G0_2_3_3 - 0.000141287284144451*G0_2_3_4 - 0.000141287284144451*G0_2_4_3 - 0.000513771942343457*G0_2_4_4 - 0.00017982017982021*G0_2_4_5 - 0.00017982017982021*G0_2_5_4 + 0.000141287284144451*G0_3_0_4 + 0.000102754388468691*G0_3_0_5 - 0.000102754388468691*G0_3_2_3 - 0.000141287284144451*G0_3_2_4 - 0.000102754388468691*G0_3_3_2 + 0.000102754388468692*G0_3_3_3 + 0.000141287284144451*G0_3_4_0 - 0.000141287284144451*G0_3_4_2 + 0.000102754388468691*G0_3_5_0 - 0.000102754388468692*G0_3_5_5 + 0.000393356643356709*G0_4_0_0 - 0.000105965463108338*G0_4_0_1 + 0.000141287284144451*G0_4_0_3 + 0.000738547167118719*G0_4_0_4 + 0.000385328956757593*G0_4_0_5 - 0.000105965463108338*G0_4_1_0 - 0.000141287284144451*G0_4_1_4 - 0.000141287284144451*G0_4_1_5 - 0.000141287284144451*G0_4_2_3 - 0.000513771942343457*G0_4_2_4 - 0.00017982017982021*G0_4_2_5 + 0.000141287284144451*G0_4_3_0 - 0.000141287284144451*G0_4_3_2 + 0.000738547167118719*G0_4_4_0 - 0.000141287284144451*G0_4_4_1 - 0.000513771942343457*G0_4_4_2 + 0.00102754388468691*G0_4_4_4 + 0.000642214927929322*G0_4_4_5 + 0.000385328956757593*G0_4_5_0 - 0.000141287284144451*G0_4_5_1 - 0.00017982017982021*G0_4_5_2 + 0.000642214927929322*G0_4_5_4 + 0.000385328956757593*G0_4_5_5 + 0.000337162837162894*G0_5_0_0 + 0.000102754388468691*G0_5_0_3 + 0.000385328956757593*G0_5_0_4 + 0.000513771942343457*G0_5_0_5 - 0.000141287284144451*G0_5_1_4 - 0.000231197374054555*G0_5_1_5 - 0.00017982017982021*G0_5_2_4 + 0.000102754388468691*G0_5_3_0 - 0.000102754388468692*G0_5_3_5 + 0.000385328956757593*G0_5_4_0 - 0.000141287284144451*G0_5_4_1 - 0.00017982017982021*G0_5_4_2 + 0.000642214927929322*G0_5_4_4 + 0.000385328956757593*G0_5_4_5 + 0.000513771942343457*G0_5_5_0 - 0.000231197374054555*G0_5_5_1 - 0.000102754388468692*G0_5_5_3 + 0.000385328956757593*G0_5_5_4 - 0.000513771942343458*G0_5_5_5;
    A[35] = A[86] - 0.000247252747252789*G0_0_0_0 - 0.000149850149850175*G0_0_0_4 - 0.000134865134865157*G0_0_0_5 - 0.00011988011988014*G0_0_3_4 - 0.000149850149850175*G0_0_4_0 - 0.00011988011988014*G0_0_4_3 - 0.000464535464535543*G0_0_4_4 - 0.000209790209790245*G0_0_4_5 - 0.000134865134865157*G0_0_5_0 - 0.000209790209790245*G0_0_5_4 - 0.00029970029970035*G0_0_5_5 - 0.000164835164835193*G0_1_3_3 + 0.000164835164835192*G0_1_5_5 + 0.000247252747252789*G0_2_2_2 + 0.000134865134865158*G0_2_2_3 + 0.000149850149850175*G0_2_2_4 + 0.000134865134865158*G0_2_3_2 + 0.00029970029970035*G0_2_3_3 + 0.000209790209790245*G0_2_3_4 + 0.000149850149850175*G0_2_4_2 + 0.000209790209790245*G0_2_4_3 + 0.000464535464535542*G0_2_4_4 + 0.00011988011988014*G0_2_4_5 + 0.00011988011988014*G0_2_5_4 - 0.00011988011988014*G0_3_0_4 - 0.000164835164835193*G0_3_1_3 + 0.000134865134865158*G0_3_2_2 + 0.00029970029970035*G0_3_2_3 + 0.000209790209790245*G0_3_2_4 - 0.000164835164835193*G0_3_3_1 + 0.00029970029970035*G0_3_3_2 - 0.000719280719280841*G0_3_3_3 + 0.00011988011988014*G0_3_3_4 - 0.00011988011988014*G0_3_3_5 - 0.00011988011988014*G0_3_4_0 + 0.000209790209790245*G0_3_4_2 + 0.00011988011988014*G0_3_4_3 + 0.00023976023976028*G0_3_4_4 - 0.00011988011988014*G0_3_5_3 + 0.00011988011988014*G0_3_5_5 - 0.000149850149850175*G0_4_0_0 - 0.00011988011988014*G0_4_0_3 - 0.000464535464535543*G0_4_0_4 - 0.000209790209790245*G0_4_0_5 + 0.000149850149850175*G0_4_2_2 + 0.000209790209790245*G0_4_2_3 + 0.000464535464535542*G0_4_2_4 + 0.00011988011988014*G0_4_2_5 - 0.00011988011988014*G0_4_3_0 + 0.000209790209790245*G0_4_3_2 + 0.00011988011988014*G0_4_3_3 + 0.00023976023976028*G0_4_3_4 - 0.000464535464535543*G0_4_4_0 + 0.000464535464535542*G0_4_4_2 + 0.00023976023976028*G0_4_4_3 - 0.00023976023976028*G0_4_4_5 - 0.000209790209790245*G0_4_5_0 + 0.00011988011988014*G0_4_5_2 - 0.00023976023976028*G0_4_5_4 - 0.00011988011988014*G0_4_5_5 - 0.000134865134865158*G0_5_0_0 - 0.000209790209790245*G0_5_0_4 - 0.00029970029970035*G0_5_0_5 + 0.000164835164835192*G0_5_1_5 + 0.00011988011988014*G0_5_2_4 - 0.00011988011988014*G0_5_3_3 + 0.00011988011988014*G0_5_3_5 - 0.000209790209790245*G0_5_4_0 + 0.00011988011988014*G0_5_4_2 - 0.00023976023976028*G0_5_4_4 - 0.00011988011988014*G0_5_4_5 - 0.00029970029970035*G0_5_5_0 + 0.000164835164835192*G0_5_5_1 + 0.00011988011988014*G0_5_5_3 - 0.00011988011988014*G0_5_5_4 + 0.000719280719280841*G0_5_5_5;
    A[16] = A[35] + 0.000140573712002307*G0_1_3_3 - 0.000129870129870152*G0_1_4_4 - 0.000101773226773244*G0_2_2_2 - 0.000230483801912412*G0_2_3_3 - 0.000100851529422975*G0_2_3_4 - 0.000100851529422975*G0_2_4_3 - 0.000155558726987325*G0_2_4_4 + 0.000140573712002307*G0_3_1_3 - 0.000230483801912412*G0_3_2_3 - 0.000100851529422975*G0_3_2_4 + 0.000140573712002307*G0_3_3_1 - 0.000230483801912412*G0_3_3_2 + 0.00103896103896121*G0_3_3_3 + 0.000211217354074532*G0_3_3_4 + 0.000368203225346145*G0_3_3_5 - 0.000100851529422975*G0_3_4_2 + 0.000211217354074532*G0_3_4_3 + 0.000296846011131775*G0_3_4_4 + 0.00017982017982021*G0_3_4_5 + 0.000368203225346145*G0_3_5_3 + 0.00017982017982021*G0_3_5_4 + 0.000242614528328855*G0_3_5_5 - 0.000129870129870152*G0_4_1_4 - 0.000100851529422975*G0_4_2_3 - 0.000155558726987325*G0_4_2_4 - 0.000100851529422975*G0_4_3_2 + 0.000211217354074532*G0_4_3_3 + 0.000296846011131775*G0_4_3_4 + 0.00017982017982021*G0_4_3_5 - 0.000129870129870152*G0_4_4_1 - 0.000155558726987325*G0_4_4_2 + 0.000296846011131775*G0_4_4_3 + 0.00155273298130467*G0_4_4_4 + 0.000402454688169042*G0_4_4_5 + 0.00017982017982021*G0_4_5_3 + 0.000402454688169042*G0_4_5_4 + 0.000216925931211682*G0_4_5_5 + 0.000368203225346145*G0_5_3_3 + 0.00017982017982021*G0_5_3_4 + 0.000242614528328855*G0_5_3_5 + 0.00017982017982021*G0_5_4_3 + 0.000402454688169042*G0_5_4_4 + 0.000216925931211682*G0_5_4_5 + 0.000242614528328855*G0_5_5_3 + 0.000216925931211682*G0_5_5_4 + 0.000285428856857477*G0_5_5_5;
    A[60] = A[16] - 0.000417707292707364*G0_0_0_0 - 0.000171614100185558*G0_0_0_4 - 0.000171614100185558*G0_0_4_0 + 0.000114171542742991*G0_3_3_3 - 0.00011417154274299*G0_3_4_4 - 0.000171614100185558*G0_4_0_0 - 0.00011417154274299*G0_4_3_4 - 0.000114171542742991*G0_4_4_3 - 0.000810617953475233*G0_4_4_4;
    A[1] = -A[16] - 0.000117501546072994*G0_0_4_4 + 0.000105296489225078*G0_2_2_2 + 0.000145885860171599*G0_2_4_4 + 0.000120514406228712*G0_3_3_4 + 0.000120514406228712*G0_3_4_3 + 0.000206143063285955*G0_3_4_4 - 0.000117501546072994*G0_4_0_4 + 0.000145885860171599*G0_4_2_4 + 0.000120514406228712*G0_4_3_3 + 0.000206143063285955*G0_4_3_4 - 0.000117501546072994*G0_4_4_0 + 0.000145885860171599*G0_4_4_2 + 0.000206143063285955*G0_4_4_3 + 0.000578786293072105*G0_4_4_4 + 0.000145885860171599*G0_5_5_5;
    A[7] = A[1] + 0.000901875901876053*G0_0_0_0 + 0.000201233951233985*G0_0_0_4 + 0.000414122914122984*G0_0_0_5 + 0.000201233951233985*G0_0_4_0 + 0.000104895104895123*G0_0_4_4 + 0.000104895104895123*G0_0_4_5 + 0.000414122914122984*G0_0_5_0 + 0.000104895104895123*G0_0_5_4 + 0.000326340326340381*G0_0_5_5 - 0.000164557664557693*G0_1_1_1 - 0.000256251684823157*G0_3_3_3 - 0.000126117268974433*G0_3_3_5 - 0.000126117268974433*G0_3_5_3 - 0.000161108732537331*G0_3_5_5 + 0.000201233951233985*G0_4_0_0 + 0.000104895104895123*G0_4_0_4 + 0.000104895104895123*G0_4_0_5 + 0.000104895104895123*G0_4_4_0 + 0.000104895104895123*G0_4_5_0 - 0.000101168672597261*G0_4_5_5 + 0.000414122914122984*G0_5_0_0 + 0.000104895104895123*G0_5_0_4 + 0.000326340326340381*G0_5_0_5 - 0.000126117268974433*G0_5_3_3 - 0.000161108732537331*G0_5_3_5 + 0.000104895104895123*G0_5_4_0 - 0.000101168672597261*G0_5_4_5 + 0.000326340326340381*G0_5_5_0 - 0.000161108732537331*G0_5_5_3 - 0.000101168672597261*G0_5_5_4 - 0.000482691911263421*G0_5_5_5;
    A[25] = A[1] + 0.000149612292469461*G0_0_4_4 - 0.000109880199165932*G0_1_1_1 - 0.000475551234479886*G0_2_2_2 - 0.000120739049310498*G0_2_2_3 - 0.000191501620073081*G0_2_2_4 - 0.000120739049310498*G0_2_3_2 - 0.000191501620073081*G0_2_4_2 - 0.000187273044415933*G0_2_4_4 - 0.000120739049310498*G0_3_2_2 + 0.000131931560503011*G0_3_3_3 + 0.000149612292469461*G0_4_0_4 - 0.000191501620073081*G0_4_2_2 - 0.000187273044415933*G0_4_2_4 + 0.000149612292469461*G0_4_4_0 - 0.000187273044415933*G0_4_4_2 - 0.000167768739197338*G0_4_4_4 + 0.000107934393648698*G0_4_4_5 + 0.000107934393648698*G0_4_5_4 + 0.000124320124320145*G0_4_5_5 + 0.000107934393648698*G0_5_4_4 + 0.000124320124320145*G0_5_4_5 + 0.000124320124320145*G0_5_5_4 + 0.000128125842411578*G0_5_5_5;
    A[40] = -A[1] - 0.000117501546072994*G0_1_3_3 + 0.000105296489225078*G0_2_2_2 + 0.000145885860171599*G0_2_3_3 - 0.000117501546072994*G0_3_1_3 + 0.000145885860171599*G0_3_2_3 - 0.000117501546072994*G0_3_3_1 + 0.000145885860171599*G0_3_3_2 + 0.000578786293072105*G0_3_3_3 + 0.000206143063285955*G0_3_3_4 + 0.000206143063285955*G0_3_4_3 + 0.000120514406228712*G0_3_4_4 + 0.000206143063285955*G0_4_3_3 + 0.000120514406228712*G0_4_3_4 + 0.000120514406228712*G0_4_4_3 + 0.000145885860171599*G0_5_5_5;
    A[4] = A[40];
    A[11] = A[1] + 0.00177461427461458*G0_1_1_1 + 0.000342759092759151*G0_1_1_3 + 0.000326710326710383*G0_1_1_5 + 0.000342759092759151*G0_1_3_1 + 0.000140045140045164*G0_1_3_3 + 0.000326710326710383*G0_1_5_1 + 0.00012839012839015*G0_1_5_5 + 0.000342759092759151*G0_3_1_1 + 0.000140045140045164*G0_3_1_3 + 0.000140045140045164*G0_3_3_1 + 0.000242931671503141*G0_3_3_3 + 0.000148740148740174*G0_4_4_4 + 0.000326710326710383*G0_5_1_1 + 0.00012839012839015*G0_5_1_5 + 0.00012839012839015*G0_5_5_1 + 0.000127808699237292*G0_5_5_5;
    A[32] = A[1] - 0.000109880199165932*G0_0_0_0 + 0.000149612292469461*G0_1_3_3 - 0.000475551234479885*G0_2_2_2 - 0.000191501620073081*G0_2_2_3 - 0.000120739049310498*G0_2_2_4 - 0.000191501620073081*G0_2_3_2 - 0.000187273044415933*G0_2_3_3 - 0.000120739049310498*G0_2_4_2 + 0.000149612292469461*G0_3_1_3 - 0.000191501620073081*G0_3_2_2 - 0.000187273044415933*G0_3_2_3 + 0.000149612292469461*G0_3_3_1 - 0.000187273044415933*G0_3_3_2 - 0.000167768739197339*G0_3_3_3 + 0.000107934393648698*G0_3_3_5 + 0.000107934393648698*G0_3_5_3 + 0.000124320124320145*G0_3_5_5 - 0.000120739049310498*G0_4_2_2 + 0.000131931560503011*G0_4_4_4 + 0.000107934393648698*G0_5_3_3 + 0.000124320124320145*G0_5_3_5 + 0.000124320124320145*G0_5_5_3 + 0.000128125842411578*G0_5_5_5;
    A[21] = A[1] + 0.000115122972265849*G0_3_3_3 - 0.000115122972265849*G0_5_5_5;
    A[69] = A[21] - 0.000178972812901414*G0_0_0_0 - 0.000118657797229246*G0_0_0_5 + 0.000118875833161567*G0_0_1_3 + 0.000169308205022519*G0_0_1_4 + 0.000105007426436016*G0_0_1_5 - 0.000103712425141014*G0_0_2_4 + 0.000118875833161568*G0_0_3_1 - 0.000382950382950448*G0_0_3_3 - 0.00046559260844983*G0_0_3_4 - 0.000118796547367996*G0_0_3_5 + 0.000169308205022519*G0_0_4_1 - 0.000103712425141014*G0_0_4_2 - 0.00046559260844983*G0_0_4_3 - 0.00103999175427764*G0_0_4_4 - 0.000330436759008243*G0_0_4_5 - 0.000118657797229246*G0_0_5_0 + 0.000105007426436016*G0_0_5_1 - 0.000118796547367996*G0_0_5_3 - 0.000330436759008243*G0_0_5_4 - 0.000140890855176593*G0_0_5_5 + 0.000118875833161568*G0_1_0_3 + 0.000169308205022519*G0_1_0_4 + 0.000105007426436016*G0_1_0_5 - 0.00013708513708516*G0_1_1_1 - 0.000129103700532294*G0_1_2_4 + 0.000118875833161568*G0_1_3_0 - 0.000485704771419139*G0_1_3_3 - 0.000387073244216166*G0_1_3_4 - 0.000127253698682292*G0_1_3_5 + 0.000169308205022519*G0_1_4_0 - 0.000129103700532294*G0_1_4_2 - 0.000387073244216166*G0_1_4_3 - 0.000567395567395663*G0_1_4_4 + 0.000105007426436016*G0_1_5_0 - 0.000127253698682292*G0_1_5_3 + 0.000142476571048024*G0_1_5_5 - 0.000103712425141014*G0_2_0_4 - 0.000129103700532294*G0_2_1_4 + 0.000233793983794023*G0_2_2_2 + 0.000181022681022711*G0_2_2_3 + 0.000309459059459112*G0_2_2_4 + 0.000181022681022711*G0_2_3_2 + 0.000426240426240498*G0_2_3_3 + 0.000437895437895511*G0_2_3_4 + 0.000229453086595982*G0_2_3_5 - 0.000103712425141014*G0_2_4_0 - 0.000129103700532294*G0_2_4_1 + 0.000309459059459112*G0_2_4_2 + 0.000437895437895512*G0_2_4_3 + 0.000887445887446036*G0_2_4_4 + 0.000307972450829646*G0_2_4_5 + 0.000229453086595982*G0_2_5_3 + 0.000307972450829646*G0_2_5_4 + 0.000421615421615493*G0_2_5_5 + 0.000118875833161568*G0_3_0_1 - 0.000382950382950448*G0_3_0_3 - 0.00046559260844983*G0_3_0_4 - 0.000118796547367996*G0_3_0_5 + 0.000118875833161568*G0_3_1_0 - 0.000485704771419139*G0_3_1_3 - 0.000387073244216166*G0_3_1_4 - 0.000127253698682292*G0_3_1_5 + 0.000181022681022711*G0_3_2_2 + 0.000426240426240498*G0_3_2_3 + 0.000437895437895511*G0_3_2_4 + 0.000229453086595982*G0_3_2_5 - 0.000382950382950448*G0_3_3_0 - 0.000485704771419139*G0_3_3_1 + 0.000426240426240498*G0_3_3_2 + 0.00197199625771088*G0_3_3_3 + 0.00154004725433323*G0_3_3_4 + 0.00030699459270893*G0_3_3_5 - 0.00046559260844983*G0_3_4_0 - 0.000387073244216166*G0_3_4_1 + 0.000437895437895511*G0_3_4_2 + 0.00154004725433323*G0_3_4_3 + 0.00206597635169099*G0_3_4_4 + 0.000315240315240368*G0_3_4_5 - 0.000118796547367996*G0_3_5_0 - 0.000127253698682292*G0_3_5_1 + 0.000229453086595982*G0_3_5_2 + 0.00030699459270893*G0_3_5_3 + 0.000315240315240368*G0_3_5_4 - 0.000605637748494994*G0_3_5_5 + 0.000169308205022519*G0_4_0_1 - 0.000103712425141014*G0_4_0_2 - 0.00046559260844983*G0_4_0_3 - 0.00103999175427764*G0_4_0_4 - 0.000330436759008243*G0_4_0_5 + 0.000169308205022519*G0_4_1_0 - 0.000129103700532294*G0_4_1_2 - 0.000387073244216166*G0_4_1_3 - 0.000567395567395663*G0_4_1_4 - 0.000103712425141014*G0_4_2_0 - 0.000129103700532294*G0_4_2_1 + 0.000309459059459112*G0_4_2_2 + 0.000437895437895511*G0_4_2_3 + 0.000887445887446036*G0_4_2_4 + 0.000307972450829646*G0_4_2_5 - 0.00046559260844983*G0_4_3_0 - 0.000387073244216166*G0_4_3_1 + 0.000437895437895512*G0_4_3_2 + 0.00154004725433323*G0_4_3_3 + 0.00206597635169098*G0_4_3_4 + 0.000315240315240368*G0_4_3_5 - 0.00103999175427764*G0_4_4_0 - 0.000567395567395663*G0_4_4_1 + 0.000887445887446036*G0_4_4_2 + 0.00206597635169098*G0_4_4_3 + 0.00516975088403747*G0_4_4_4 + 0.000518846233132034*G0_4_4_5 - 0.000330436759008243*G0_4_5_0 + 0.000307972450829646*G0_4_5_2 + 0.000315240315240368*G0_4_5_3 + 0.000518846233132034*G0_4_5_4 - 0.00076558362272661*G0_4_5_5 - 0.000118657797229246*G0_5_0_0 + 0.000105007426436016*G0_5_0_1 - 0.000118796547367996*G0_5_0_3 - 0.000330436759008243*G0_5_0_4 - 0.000140890855176593*G0_5_0_5 + 0.000105007426436016*G0_5_1_0 - 0.000127253698682292*G0_5_1_3 + 0.000142476571048024*G0_5_1_5 + 0.000229453086595982*G0_5_2_3 + 0.000307972450829646*G0_5_2_4 + 0.000421615421615493*G0_5_2_5 - 0.000118796547367996*G0_5_3_0 - 0.000127253698682292*G0_5_3_1 + 0.000229453086595982*G0_5_3_2 + 0.00030699459270893*G0_5_3_3 + 0.000315240315240368*G0_5_3_4 - 0.000605637748494994*G0_5_3_5 - 0.000330436759008243*G0_5_4_0 + 0.000307972450829646*G0_5_4_2 + 0.000315240315240368*G0_5_4_3 + 0.000518846233132034*G0_5_4_4 - 0.00076558362272661*G0_5_4_5 - 0.000140890855176593*G0_5_5_0 + 0.000142476571048024*G0_5_5_1 + 0.000421615421615493*G0_5_5_2 - 0.000605637748494994*G0_5_5_3 - 0.00076558362272661*G0_5_5_4 - 0.00253682825111439*G0_5_5_5;
    A[90] = A[21] + 0.000139458755530208*G0_0_0_0 - 0.000160315874601616*G0_0_3_3 + 0.000105370819656552*G0_1_5_5 + 0.000105370819656552*G0_2_4_4 - 0.000160315874601616*G0_3_0_3 - 0.000160315874601616*G0_3_3_0 + 0.000990120990121157*G0_3_3_3 + 0.000341246055531828*G0_3_3_4 + 0.000341246055531828*G0_3_3_5 + 0.000341246055531828*G0_3_4_3 + 0.000341246055531828*G0_3_5_3 + 0.000105370819656552*G0_4_2_4 + 0.000341246055531828*G0_4_3_3 + 0.000105370819656552*G0_4_4_2 - 0.000367568938997572*G0_4_4_4 - 0.000194725909011656*G0_4_4_5 - 0.000194725909011656*G0_4_5_4 - 0.000194725909011656*G0_4_5_5 + 0.000105370819656552*G0_5_1_5 + 0.000341246055531828*G0_5_3_3 - 0.000194725909011656*G0_5_4_4 - 0.000194725909011656*G0_5_4_5 + 0.000105370819656552*G0_5_5_1 - 0.000194725909011656*G0_5_5_4 - 0.000367568938997572*G0_5_5_5;
    A[82] = -A[21] - 0.000116708688137279*G0_0_5_5 + 0.000198273948273982*G0_1_1_1 + 0.000102212602212619*G0_1_1_5 + 0.000102212602212619*G0_1_5_1 + 0.000145093002235884*G0_1_5_5 + 0.000180137322994496*G0_3_3_3 + 0.000126857269714434*G0_3_3_5 + 0.000126857269714434*G0_3_5_3 + 0.000200328771757377*G0_3_5_5 - 0.000116708688137279*G0_5_0_5 + 0.000102212602212619*G0_5_1_1 + 0.000145093002235884*G0_5_1_5 + 0.000126857269714434*G0_5_3_3 + 0.000200328771757377*G0_5_3_5 - 0.000116708688137279*G0_5_5_0 + 0.000145093002235884*G0_5_5_1 + 0.000200328771757377*G0_5_5_3 + 0.000578786293072106*G0_5_5_5;
    A[31] = A[21] + 0.000901875901876055*G0_1_1_1 + 0.000414122914122985*G0_1_1_3 + 0.000201233951233986*G0_1_1_5 + 0.000414122914122985*G0_1_3_1 + 0.000326340326340382*G0_1_3_3 + 0.000104895104895123*G0_1_3_5 + 0.000201233951233986*G0_1_5_1 + 0.000104895104895123*G0_1_5_3 + 0.000104895104895123*G0_1_5_5 - 0.000164557664557692*G0_2_2_2 + 0.000414122914122985*G0_3_1_1 + 0.000326340326340382*G0_3_1_3 + 0.000104895104895123*G0_3_1_5 + 0.000326340326340382*G0_3_3_1 - 0.00048269191126342*G0_3_3_3 - 0.000161108732537331*G0_3_3_4 - 0.000101168672597261*G0_3_3_5 - 0.000161108732537331*G0_3_4_3 - 0.000126117268974433*G0_3_4_4 + 0.000104895104895123*G0_3_5_1 - 0.000101168672597261*G0_3_5_3 - 0.000161108732537331*G0_4_3_3 - 0.000126117268974433*G0_4_3_4 - 0.000126117268974433*G0_4_4_3 - 0.000256251684823157*G0_4_4_4 + 0.000201233951233986*G0_5_1_1 + 0.000104895104895123*G0_5_1_3 + 0.000104895104895123*G0_5_1_5 + 0.000104895104895123*G0_5_3_1 - 0.000101168672597261*G0_5_3_3 + 0.000104895104895123*G0_5_5_1;
    A[89] = A[69] - 0.000112387612387631*G0_0_0_4 + 0.000112387612387632*G0_0_0_5 - 0.00020871985157703*G0_0_1_3 - 0.000173398030540917*G0_0_1_4 - 0.00020871985157703*G0_0_1_5 + 0.00020871985157703*G0_0_2_3 + 0.000208719851577029*G0_0_2_4 + 0.000173398030540917*G0_0_2_5 - 0.00020871985157703*G0_0_3_1 + 0.00020871985157703*G0_0_3_2 + 0.000346796061081833*G0_0_3_4 - 0.000346796061081834*G0_0_3_5 - 0.000112387612387631*G0_0_4_0 - 0.000173398030540917*G0_0_4_1 + 0.000208719851577029*G0_0_4_2 + 0.000346796061081833*G0_0_4_3 + 0.00089910089910105*G0_0_4_4 + 0.000112387612387632*G0_0_5_0 - 0.00020871985157703*G0_0_5_1 + 0.000173398030540917*G0_0_5_2 - 0.000346796061081834*G0_0_5_3 - 0.000899100899101052*G0_0_5_5 - 0.00020871985157703*G0_1_0_3 - 0.000173398030540917*G0_1_0_4 - 0.00020871985157703*G0_1_0_5 + 0.000370879120879184*G0_1_1_1 + 0.00016055373198233*G0_1_1_3 + 0.0003789068074783*G0_1_1_5 - 0.00020871985157703*G0_1_3_0 + 0.00016055373198233*G0_1_3_1 + 0.000911945197659637*G0_1_3_3 + 0.000616526330812149*G0_1_3_4 + 0.000565149136577803*G0_1_3_5 - 0.000173398030540917*G0_1_4_0 + 0.000616526330812149*G0_1_4_3 + 0.000989010989011155*G0_1_4_4 + 0.000346796061081834*G0_1_4_5 - 0.00020871985157703*G0_1_5_0 + 0.0003789068074783*G0_1_5_1 + 0.000565149136577803*G0_1_5_3 + 0.000346796061081834*G0_1_5_4 + 0.000744969316398013*G0_1_5_5 + 0.00020871985157703*G0_2_0_3 + 0.000208719851577029*G0_2_0_4 + 0.000173398030540917*G0_2_0_5 - 0.000370879120879183*G0_2_2_2 - 0.00016055373198233*G0_2_2_3 - 0.0003789068074783*G0_2_2_4 + 0.00020871985157703*G0_2_3_0 - 0.00016055373198233*G0_2_3_2 - 0.000911945197659637*G0_2_3_3 - 0.000565149136577803*G0_2_3_4 - 0.000616526330812149*G0_2_3_5 + 0.000208719851577029*G0_2_4_0 - 0.0003789068074783*G0_2_4_2 - 0.000565149136577803*G0_2_4_3 - 0.000744969316398012*G0_2_4_4 - 0.000346796061081834*G0_2_4_5 + 0.000173398030540917*G0_2_5_0 - 0.000616526330812149*G0_2_5_3 - 0.000346796061081834*G0_2_5_4 - 0.000989010989011157*G0_2_5_5 - 0.00020871985157703*G0_3_0_1 + 0.00020871985157703*G0_3_0_2 + 0.000346796061081834*G0_3_0_4 - 0.000346796061081834*G0_3_0_5 - 0.00020871985157703*G0_3_1_0 + 0.00016055373198233*G0_3_1_1 + 0.000911945197659637*G0_3_1_3 + 0.000616526330812149*G0_3_1_4 + 0.000565149136577803*G0_3_1_5 + 0.00020871985157703*G0_3_2_0 - 0.00016055373198233*G0_3_2_2 - 0.000911945197659637*G0_3_2_3 - 0.000565149136577803*G0_3_2_4 - 0.000616526330812149*G0_3_2_5 + 0.000911945197659637*G0_3_3_1 - 0.000911945197659637*G0_3_3_2 - 0.0012330526616243*G0_3_3_4 + 0.0012330526616243*G0_3_3_5 + 0.000346796061081834*G0_3_4_0 + 0.000616526330812149*G0_3_4_1 - 0.000565149136577803*G0_3_4_2 - 0.0012330526616243*G0_3_4_3 - 0.00267161410018598*G0_3_4_4 - 0.000346796061081834*G0_3_5_0 + 0.000565149136577803*G0_3_5_1 - 0.000616526330812149*G0_3_5_2 + 0.0012330526616243*G0_3_5_3 + 0.00267161410018598*G0_3_5_5 - 0.000112387612387631*G0_4_0_0 - 0.000173398030540917*G0_4_0_1 + 0.000208719851577029*G0_4_0_2 + 0.000346796061081834*G0_4_0_3 + 0.00089910089910105*G0_4_0_4 - 0.000173398030540917*G0_4_1_0 + 0.000616526330812149*G0_4_1_3 + 0.000989010989011155*G0_4_1_4 + 0.000346796061081834*G0_4_1_5 + 0.000208719851577029*G0_4_2_0 - 0.0003789068074783*G0_4_2_2 - 0.000565149136577803*G0_4_2_3 - 0.000744969316398012*G0_4_2_4 - 0.000346796061081834*G0_4_2_5 + 0.000346796061081834*G0_4_3_0 + 0.000616526330812149*G0_4_3_1 - 0.000565149136577803*G0_4_3_2 - 0.0012330526616243*G0_4_3_3 - 0.00267161410018598*G0_4_3_4 + 0.00089910089910105*G0_4_4_0 + 0.000989010989011155*G0_4_4_1 - 0.000744969316398012*G0_4_4_2 - 0.00267161410018598*G0_4_4_3 - 0.00770657913515186*G0_4_4_4 - 0.00128442985585864*G0_4_4_5 + 0.000346796061081834*G0_4_5_1 - 0.000346796061081834*G0_4_5_2 - 0.00128442985585864*G0_4_5_4 + 0.00128442985585865*G0_4_5_5 + 0.000112387612387632*G0_5_0_0 - 0.00020871985157703*G0_5_0_1 + 0.000173398030540917*G0_5_0_2 - 0.000346796061081834*G0_5_0_3 - 0.000899100899101051*G0_5_0_5 - 0.00020871985157703*G0_5_1_0 + 0.0003789068074783*G0_5_1_1 + 0.000565149136577803*G0_5_1_3 + 0.000346796061081834*G0_5_1_4 + 0.000744969316398013*G0_5_1_5 + 0.000173398030540917*G0_5_2_0 - 0.000616526330812149*G0_5_2_3 - 0.000346796061081834*G0_5_2_4 - 0.000989010989011157*G0_5_2_5 - 0.000346796061081834*G0_5_3_0 + 0.000565149136577803*G0_5_3_1 - 0.000616526330812149*G0_5_3_2 + 0.0012330526616243*G0_5_3_3 + 0.00267161410018598*G0_5_3_5 + 0.000346796061081834*G0_5_4_1 - 0.000346796061081834*G0_5_4_2 - 0.00128442985585864*G0_5_4_4 + 0.00128442985585865*G0_5_4_5 - 0.000899100899101051*G0_5_5_0 + 0.000744969316398013*G0_5_5_1 - 0.000989010989011157*G0_5_5_2 + 0.00267161410018598*G0_5_5_3 + 0.00128442985585865*G0_5_5_4 + 0.00770657913515187*G0_5_5_5;
    A[93] = A[89] + 0.000134865134865157*G0_0_0_0 - 0.000179820179820209*G0_0_3_3 + 0.000282574568288902*G0_0_4_4 + 0.000205508776937383*G0_0_4_5 + 0.000205508776937383*G0_0_5_4 + 0.000565149136577804*G0_0_5_5 + 0.000112387612387632*G0_1_1_3 - 0.000112387612387631*G0_1_1_5 + 0.000112387612387632*G0_1_3_1 + 0.000449550449550526*G0_1_3_3 - 0.000112387612387631*G0_1_5_1 - 0.000449550449550525*G0_1_5_5 - 0.000134865134865158*G0_2_2_2 - 0.000565149136577803*G0_2_3_3 - 0.000205508776937383*G0_2_3_4 - 0.000205508776937383*G0_2_4_3 - 0.000282574568288901*G0_2_4_4 + 0.000179820179820211*G0_2_5_5 - 0.000179820179820209*G0_3_0_3 + 0.000112387612387632*G0_3_1_1 + 0.000449550449550526*G0_3_1_3 - 0.000565149136577803*G0_3_2_3 - 0.000205508776937383*G0_3_2_4 - 0.000179820179820209*G0_3_3_0 + 0.000449550449550526*G0_3_3_1 - 0.000565149136577803*G0_3_3_2 + 0.00308263165406074*G0_3_3_3 + 0.000205508776937381*G0_3_3_4 + 0.000513771942343456*G0_3_3_5 - 0.000205508776937383*G0_3_4_2 + 0.000205508776937381*G0_3_4_3 - 0.000154131582703039*G0_3_4_4 + 0.000513771942343456*G0_3_5_3 - 0.000513771942343461*G0_3_5_5 + 0.000282574568288902*G0_4_0_4 + 0.000205508776937383*G0_4_0_5 - 0.000205508776937383*G0_4_2_3 - 0.000282574568288901*G0_4_2_4 - 0.000205508776937383*G0_4_3_2 + 0.000205508776937381*G0_4_3_3 - 0.000154131582703039*G0_4_3_4 + 0.000282574568288902*G0_4_4_0 - 0.000282574568288901*G0_4_4_2 - 0.000154131582703039*G0_4_4_3 + 0.000154131582703036*G0_4_4_5 + 0.000205508776937383*G0_4_5_0 + 0.000154131582703036*G0_4_5_4 - 0.000205508776937385*G0_4_5_5 + 0.000205508776937383*G0_5_0_4 + 0.000565149136577804*G0_5_0_5 - 0.000112387612387631*G0_5_1_1 - 0.000449550449550525*G0_5_1_5 + 0.000179820179820211*G0_5_2_5 + 0.000513771942343455*G0_5_3_3 - 0.000513771942343461*G0_5_3_5 + 0.000205508776937383*G0_5_4_0 + 0.000154131582703036*G0_5_4_4 - 0.000205508776937385*G0_5_4_5 + 0.000565149136577804*G0_5_5_0 - 0.000449550449550525*G0_5_5_1 + 0.000179820179820211*G0_5_5_2 - 0.000513771942343461*G0_5_5_3 - 0.000205508776937385*G0_5_5_4 - 0.00308263165406075*G0_5_5_5;
    A[94] = A[69] + 0.000134865134865158*G0_0_0_0 - 0.00017982017982021*G0_0_3_3 + 0.000565149136577803*G0_0_4_4 + 0.000205508776937383*G0_0_4_5 + 0.000205508776937383*G0_0_5_4 + 0.000282574568288902*G0_0_5_5 - 0.000134865134865158*G0_1_1_1 - 0.000565149136577803*G0_1_3_3 - 0.000205508776937383*G0_1_3_5 + 0.00017982017982021*G0_1_4_4 - 0.000205508776937383*G0_1_5_3 - 0.000282574568288902*G0_1_5_5 + 0.000112387612387631*G0_2_2_3 - 0.000112387612387631*G0_2_2_4 + 0.000112387612387631*G0_2_3_2 + 0.000449550449550525*G0_2_3_3 - 0.000112387612387631*G0_2_4_2 - 0.000449550449550525*G0_2_4_4 - 0.00017982017982021*G0_3_0_3 - 0.000565149136577803*G0_3_1_3 - 0.000205508776937383*G0_3_1_5 + 0.000112387612387631*G0_3_2_2 + 0.000449550449550525*G0_3_2_3 - 0.00017982017982021*G0_3_3_0 - 0.000565149136577803*G0_3_3_1 + 0.000449550449550525*G0_3_3_2 + 0.00308263165406074*G0_3_3_3 + 0.000513771942343456*G0_3_3_4 + 0.000205508776937383*G0_3_3_5 + 0.000513771942343457*G0_3_4_3 - 0.000513771942343457*G0_3_4_4 - 0.000205508776937383*G0_3_5_1 + 0.000205508776937383*G0_3_5_3 - 0.000154131582703037*G0_3_5_5 + 0.000565149136577803*G0_4_0_4 + 0.000205508776937383*G0_4_0_5 + 0.00017982017982021*G0_4_1_4 - 0.000112387612387631*G0_4_2_2 - 0.000449550449550525*G0_4_2_4 + 0.000513771942343457*G0_4_3_3 - 0.000513771942343456*G0_4_3_4 + 0.000565149136577803*G0_4_4_0 + 0.00017982017982021*G0_4_4_1 - 0.000449550449550525*G0_4_4_2 - 0.000513771942343456*G0_4_4_3 - 0.00308263165406074*G0_4_4_4 - 0.000205508776937383*G0_4_4_5 + 0.000205508776937383*G0_4_5_0 - 0.000205508776937383*G0_4_5_4 + 0.000154131582703037*G0_4_5_5 + 0.000205508776937383*G0_5_0_4 + 0.000282574568288902*G0_5_0_5 - 0.000205508776937383*G0_5_1_3 - 0.000282574568288902*G0_5_1_5 - 0.000205508776937383*G0_5_3_1 + 0.000205508776937383*G0_5_3_3 - 0.000154131582703037*G0_5_3_5 + 0.000205508776937383*G0_5_4_0 - 0.000205508776937382*G0_5_4_4 + 0.000154131582703037*G0_5_4_5 + 0.000282574568288902*G0_5_5_0 - 0.000282574568288902*G0_5_5_1 - 0.000154131582703037*G0_5_5_3 + 0.000154131582703037*G0_5_5_4;
    A[51] = A[25] + 0.000417707292707363*G0_2_2_2 + 0.000171614100185558*G0_2_2_4 + 0.000171614100185558*G0_2_4_2 + 0.000171614100185558*G0_4_2_2 + 0.000810617953475232*G0_4_4_4 + 0.00011417154274299*G0_4_4_5 + 0.00011417154274299*G0_4_5_4 + 0.00011417154274299*G0_5_4_4 - 0.00011417154274299*G0_5_5_5;
    A[72] = -A[21] + 0.000105296489225078*G0_0_0_0 + 0.000145885860171599*G0_0_5_5 - 0.000117501546072994*G0_1_5_5 + 0.000145885860171599*G0_3_3_3 + 0.000120514406228712*G0_4_4_5 + 0.000120514406228712*G0_4_5_4 + 0.000206143063285955*G0_4_5_5 + 0.000145885860171599*G0_5_0_5 - 0.000117501546072994*G0_5_1_5 + 0.000120514406228712*G0_5_4_4 + 0.000206143063285955*G0_5_4_5 + 0.000145885860171599*G0_5_5_0 - 0.000117501546072994*G0_5_5_1 + 0.000206143063285955*G0_5_5_4 + 0.000578786293072104*G0_5_5_5;
    A[15] = A[51];
    A[22] = A[21] + 0.00177461427461457*G0_2_2_2 + 0.000326710326710382*G0_2_2_3 + 0.00034275909275915*G0_2_2_4 + 0.000326710326710382*G0_2_3_2 + 0.00012839012839015*G0_2_3_3 + 0.00034275909275915*G0_2_4_2 + 0.000140045140045164*G0_2_4_4 + 0.000326710326710382*G0_3_2_2 + 0.00012839012839015*G0_3_2_3 + 0.00012839012839015*G0_3_3_2 + 0.000127808699237292*G0_3_3_3 + 0.00034275909275915*G0_4_2_2 + 0.000140045140045164*G0_4_2_4 + 0.000140045140045164*G0_4_4_2 + 0.000242931671503141*G0_4_4_4 + 0.000148740148740174*G0_5_5_5;
    A[41] = A[40] - 0.000417707292707363*G0_1_1_1 - 0.000171614100185558*G0_1_1_3 - 0.000171614100185558*G0_1_3_1 - 0.000171614100185558*G0_3_1_1 - 0.000810617953475233*G0_3_3_3 - 0.000114171542742991*G0_3_3_4 - 0.000114171542742991*G0_3_4_3 - 0.000114171542742991*G0_4_3_3 + 0.000114171542742991*G0_4_4_4;
    A[97] = A[89] + 0.000505744255744341*G0_0_0_0 - 0.000158948194662507*G0_0_0_1 + 0.000337162837162894*G0_0_0_4 + 0.000337162837162894*G0_0_0_5 - 0.000158948194662507*G0_0_1_0 + 0.000158948194662507*G0_0_1_1 - 0.000173398030540917*G0_0_2_3 - 0.000192664478378796*G0_0_2_4 - 0.000298629941487135*G0_0_2_5 - 0.000173398030540917*G0_0_3_2 + 0.000809190809190946*G0_0_3_3 + 0.000346796061081834*G0_0_3_4 + 0.000770657913515187*G0_0_3_5 + 0.000337162837162894*G0_0_4_0 - 0.000192664478378796*G0_0_4_2 + 0.000346796061081834*G0_0_4_3 + 0.00057799343513639*G0_0_4_4 + 0.000770657913515187*G0_0_4_5 + 0.000337162837162894*G0_0_5_0 - 0.000298629941487135*G0_0_5_2 + 0.000770657913515187*G0_0_5_3 + 0.000770657913515187*G0_0_5_4 + 0.00192664478378797*G0_0_5_5 - 0.000158948194662507*G0_1_0_0 + 0.000158948194662507*G0_1_0_1 + 0.000158948194662507*G0_1_1_0 - 0.000505744255744341*G0_1_1_1 - 0.000337162837162894*G0_1_1_3 - 0.000337162837162894*G0_1_1_5 + 0.000192664478378797*G0_1_2_3 + 0.000173398030540917*G0_1_2_4 + 0.000298629941487135*G0_1_2_5 - 0.000337162837162894*G0_1_3_1 + 0.000192664478378797*G0_1_3_2 - 0.000577993435136389*G0_1_3_3 - 0.000346796061081833*G0_1_3_4 - 0.000770657913515186*G0_1_3_5 + 0.000173398030540917*G0_1_4_2 - 0.000346796061081833*G0_1_4_3 - 0.000809190809190945*G0_1_4_4 - 0.000770657913515186*G0_1_4_5 - 0.000337162837162894*G0_1_5_1 + 0.000298629941487135*G0_1_5_2 - 0.000770657913515186*G0_1_5_3 - 0.000770657913515186*G0_1_5_4 - 0.00192664478378797*G0_1_5_5 - 0.000173398030540917*G0_2_0_3 - 0.000192664478378796*G0_2_0_4 - 0.000298629941487135*G0_2_0_5 + 0.000192664478378797*G0_2_1_3 + 0.000173398030540917*G0_2_1_4 + 0.000298629941487135*G0_2_1_5 - 0.000105965463108338*G0_2_2_3 + 0.000105965463108338*G0_2_2_4 - 0.000173398030540917*G0_2_3_0 + 0.000192664478378797*G0_2_3_1 - 0.000105965463108338*G0_2_3_2 + 0.000616526330812149*G0_2_3_3 + 0.000346796061081834*G0_2_3_5 - 0.000192664478378796*G0_2_4_0 + 0.000173398030540917*G0_2_4_1 + 0.000105965463108338*G0_2_4_2 - 0.000616526330812149*G0_2_4_4 - 0.000346796061081834*G0_2_4_5 - 0.000298629941487135*G0_2_5_0 + 0.000298629941487135*G0_2_5_1 + 0.000346796061081834*G0_2_5_3 - 0.000346796061081834*G0_2_5_4 - 0.000173398030540917*G0_3_0_2 + 0.000809190809190946*G0_3_0_3 + 0.000346796061081834*G0_3_0_4 + 0.000770657913515187*G0_3_0_5 - 0.000337162837162894*G0_3_1_1 + 0.000192664478378797*G0_3_1_2 - 0.000577993435136389*G0_3_1_3 - 0.000346796061081833*G0_3_1_4 - 0.000770657913515186*G0_3_1_5 - 0.000173398030540917*G0_3_2_0 + 0.000192664478378797*G0_3_2_1 - 0.000105965463108338*G0_3_2_2 + 0.000616526330812149*G0_3_2_3 + 0.000346796061081834*G0_3_2_5 + 0.000809190809190946*G0_3_3_0 - 0.000577993435136389*G0_3_3_1 + 0.000616526330812149*G0_3_3_2 - 0.00462394748109112*G0_3_3_3 - 0.000924789496218226*G0_3_3_4 - 0.00231197374054556*G0_3_3_5 + 0.000346796061081834*G0_3_4_0 - 0.000346796061081833*G0_3_4_1 - 0.000924789496218226*G0_3_4_3 + 0.000924789496218222*G0_3_4_4 + 0.000770657913515187*G0_3_5_0 - 0.000770657913515186*G0_3_5_1 + 0.000346796061081834*G0_3_5_2 - 0.00231197374054556*G0_3_5_3 - 0.00154131582703038*G0_3_5_5 + 0.000337162837162894*G0_4_0_0 - 0.000192664478378796*G0_4_0_2 + 0.000346796061081834*G0_4_0_3 + 0.00057799343513639*G0_4_0_4 + 0.000770657913515187*G0_4_0_5 + 0.000173398030540917*G0_4_1_2 - 0.000346796061081833*G0_4_1_3 - 0.000809190809190945*G0_4_1_4 - 0.000770657913515186*G0_4_1_5 - 0.000192664478378796*G0_4_2_0 + 0.000173398030540917*G0_4_2_1 + 0.000105965463108338*G0_4_2_2 - 0.000616526330812149*G0_4_2_4 - 0.000346796061081834*G0_4_2_5 + 0.000346796061081834*G0_4_3_0 - 0.000346796061081833*G0_4_3_1 - 0.000924789496218226*G0_4_3_3 + 0.000924789496218222*G0_4_3_4 + 0.00057799343513639*G0_4_4_0 - 0.000809190809190945*G0_4_4_1 - 0.000616526330812149*G0_4_4_2 + 0.000924789496218222*G0_4_4_3 + 0.00462394748109111*G0_4_4_4 + 0.00231197374054556*G0_4_4_5 + 0.000770657913515187*G0_4_5_0 - 0.000770657913515186*G0_4_5_1 - 0.000346796061081834*G0_4_5_2 + 0.00231197374054556*G0_4_5_4 + 0.00154131582703037*G0_4_5_5 + 0.000337162837162894*G0_5_0_0 - 0.000298629941487135*G0_5_0_2 + 0.000770657913515187*G0_5_0_3 + 0.000770657913515187*G0_5_0_4 + 0.00192664478378797*G0_5_0_5 - 0.000337162837162894*G0_5_1_1 + 0.000298629941487135*G0_5_1_2 - 0.000770657913515186*G0_5_1_3 - 0.000770657913515186*G0_5_1_4 - 0.00192664478378796*G0_5_1_5 - 0.000298629941487135*G0_5_2_0 + 0.000298629941487135*G0_5_2_1 + 0.000346796061081834*G0_5_2_3 - 0.000346796061081834*G0_5_2_4 + 0.000770657913515187*G0_5_3_0 - 0.000770657913515186*G0_5_3_1 + 0.000346796061081834*G0_5_3_2 - 0.00231197374054556*G0_5_3_3 - 0.00154131582703038*G0_5_3_5 + 0.000770657913515187*G0_5_4_0 - 0.000770657913515186*G0_5_4_1 - 0.000346796061081834*G0_5_4_2 + 0.00231197374054556*G0_5_4_4 + 0.00154131582703037*G0_5_4_5 + 0.00192664478378797*G0_5_5_0 - 0.00192664478378796*G0_5_5_1 - 0.00154131582703038*G0_5_5_3 + 0.00154131582703037*G0_5_5_4;
    A[71] = A[72] - 0.000417707292707364*G0_1_1_1 - 0.000171614100185558*G0_1_1_5 - 0.000171614100185558*G0_1_5_1 + 0.00011417154274299*G0_4_4_4 - 0.00011417154274299*G0_4_5_5 - 0.000171614100185558*G0_5_1_1 - 0.00011417154274299*G0_5_4_5 - 0.000114171542742991*G0_5_5_4 - 0.000810617953475233*G0_5_5_5;
    A[5] = A[7] + 0.000228937728937768*G0_0_0_4 - 0.000228937728937767*G0_0_0_5 + 0.000228937728937768*G0_0_4_0 + 0.000233100233100273*G0_0_4_4 - 0.000228937728937767*G0_0_5_0 - 0.000233100233100273*G0_0_5_5 + 0.000228937728937768*G0_4_0_0 + 0.000233100233100273*G0_4_0_4 + 0.000233100233100273*G0_4_4_0 - 0.00029970029970035*G0_4_4_4 - 0.000228937728937767*G0_5_0_0 - 0.000233100233100273*G0_5_0_5 - 0.000233100233100273*G0_5_5_0 + 0.00029970029970035*G0_5_5_5;
    A[10] = A[1];
    A[8] = A[82] - 0.000417707292707363*G0_0_0_0 - 0.000171614100185558*G0_0_0_5 - 0.000171614100185558*G0_0_5_0 + 0.000114171542742991*G0_3_3_3 - 0.000114171542742991*G0_3_5_5 - 0.000171614100185558*G0_5_0_0 - 0.000114171542742991*G0_5_3_5 - 0.000114171542742991*G0_5_5_3 - 0.000810617953475234*G0_5_5_5;
    A[27] = A[72];
    A[92] = A[1] + 0.000105370819656552*G0_0_4_4 + 0.000105370819656552*G0_1_3_3 + 0.000139458755530207*G0_2_2_2 - 0.000160315874601616*G0_2_5_5 + 0.000105370819656552*G0_3_1_3 + 0.000105370819656552*G0_3_3_1 - 0.000367568938997573*G0_3_3_3 - 0.000194725909011656*G0_3_3_4 - 0.000194725909011656*G0_3_4_3 - 0.000194725909011656*G0_3_4_4 + 0.000341246055531827*G0_3_5_5 + 0.000105370819656552*G0_4_0_4 - 0.000194725909011656*G0_4_3_3 - 0.000194725909011656*G0_4_3_4 + 0.000105370819656552*G0_4_4_0 - 0.000194725909011656*G0_4_4_3 - 0.000367568938997572*G0_4_4_4 + 0.000341246055531827*G0_4_5_5 - 0.000160315874601616*G0_5_2_5 + 0.000341246055531827*G0_5_3_5 + 0.000341246055531827*G0_5_4_5 - 0.000160315874601616*G0_5_5_2 + 0.000341246055531827*G0_5_5_3 + 0.000341246055531827*G0_5_5_4 + 0.000990120990121157*G0_5_5_5;
    A[61] = A[16];
    A[74] = A[86] - 0.000247252747252788*G0_0_0_0 - 0.000134865134865157*G0_0_0_4 - 0.000149850149850175*G0_0_0_5 - 0.00011988011988014*G0_0_3_5 - 0.000134865134865157*G0_0_4_0 - 0.00029970029970035*G0_0_4_4 - 0.000209790209790245*G0_0_4_5 - 0.000149850149850175*G0_0_5_0 - 0.00011988011988014*G0_0_5_3 - 0.000209790209790245*G0_0_5_4 - 0.000464535464535543*G0_0_5_5 + 0.000247252747252789*G0_1_1_1 + 0.000134865134865158*G0_1_1_3 + 0.000149850149850175*G0_1_1_5 + 0.000134865134865158*G0_1_3_1 + 0.000299700299700351*G0_1_3_3 + 0.000209790209790245*G0_1_3_5 + 0.00011988011988014*G0_1_4_5 + 0.000149850149850175*G0_1_5_1 + 0.000209790209790245*G0_1_5_3 + 0.00011988011988014*G0_1_5_4 + 0.000464535464535542*G0_1_5_5 - 0.000164835164835193*G0_2_3_3 + 0.000164835164835192*G0_2_4_4 - 0.00011988011988014*G0_3_0_5 + 0.000134865134865158*G0_3_1_1 + 0.000299700299700351*G0_3_1_3 + 0.000209790209790245*G0_3_1_5 - 0.000164835164835193*G0_3_2_3 + 0.000299700299700351*G0_3_3_1 - 0.000164835164835193*G0_3_3_2 - 0.000719280719280842*G0_3_3_3 - 0.000119880119880141*G0_3_3_4 + 0.00011988011988014*G0_3_3_5 - 0.000119880119880141*G0_3_4_3 + 0.000119880119880139*G0_3_4_4 - 0.00011988011988014*G0_3_5_0 + 0.000209790209790245*G0_3_5_1 + 0.00011988011988014*G0_3_5_3 + 0.000239760239760281*G0_3_5_5 - 0.000134865134865157*G0_4_0_0 - 0.00029970029970035*G0_4_0_4 - 0.000209790209790245*G0_4_0_5 + 0.00011988011988014*G0_4_1_5 + 0.000164835164835192*G0_4_2_4 - 0.000119880119880141*G0_4_3_3 + 0.000119880119880139*G0_4_3_4 - 0.00029970029970035*G0_4_4_0 + 0.000164835164835192*G0_4_4_2 + 0.000119880119880139*G0_4_4_3 + 0.000719280719280838*G0_4_4_4 - 0.00011988011988014*G0_4_4_5 - 0.000209790209790245*G0_4_5_0 + 0.00011988011988014*G0_4_5_1 - 0.00011988011988014*G0_4_5_4 - 0.00023976023976028*G0_4_5_5 - 0.000149850149850175*G0_5_0_0 - 0.00011988011988014*G0_5_0_3 - 0.000209790209790245*G0_5_0_4 - 0.000464535464535543*G0_5_0_5 + 0.000149850149850175*G0_5_1_1 + 0.000209790209790245*G0_5_1_3 + 0.00011988011988014*G0_5_1_4 + 0.000464535464535542*G0_5_1_5 - 0.00011988011988014*G0_5_3_0 + 0.000209790209790245*G0_5_3_1 + 0.00011988011988014*G0_5_3_3 + 0.000239760239760281*G0_5_3_5 - 0.000209790209790245*G0_5_4_0 + 0.00011988011988014*G0_5_4_1 - 0.00011988011988014*G0_5_4_4 - 0.00023976023976028*G0_5_4_5 - 0.000464535464535543*G0_5_5_0 + 0.000464535464535542*G0_5_5_1 + 0.000239760239760281*G0_5_5_3 - 0.00023976023976028*G0_5_5_4;
    A[2] = A[1] + 0.000115122972265849*G0_4_4_4 - 0.000115122972265849*G0_5_5_5;
    A[26] = A[2] - 0.000164557664557692*G0_0_0_0 + 0.000901875901876053*G0_2_2_2 + 0.000201233951233985*G0_2_2_3 + 0.000414122914122984*G0_2_2_4 + 0.000201233951233985*G0_2_3_2 + 0.000104895104895123*G0_2_3_3 + 0.000104895104895123*G0_2_3_4 + 0.000414122914122984*G0_2_4_2 + 0.000104895104895123*G0_2_4_3 + 0.000326340326340381*G0_2_4_4 + 0.000201233951233985*G0_3_2_2 + 0.000104895104895123*G0_3_2_3 + 0.000104895104895123*G0_3_2_4 + 0.000104895104895123*G0_3_3_2 + 0.000104895104895123*G0_3_4_2 - 0.000101168672597261*G0_3_4_4 + 0.000414122914122984*G0_4_2_2 + 0.000104895104895123*G0_4_2_3 + 0.000326340326340381*G0_4_2_4 + 0.000104895104895123*G0_4_3_2 - 0.000101168672597261*G0_4_3_4 + 0.000326340326340381*G0_4_4_2 - 0.000101168672597261*G0_4_4_3 - 0.000482691911263421*G0_4_4_4 - 0.000161108732537331*G0_4_4_5 - 0.000161108732537331*G0_4_5_4 - 0.000126117268974433*G0_4_5_5 - 0.000161108732537331*G0_5_4_4 - 0.000126117268974433*G0_5_4_5 - 0.000126117268974433*G0_5_5_4 - 0.000256251684823157*G0_5_5_5;
    A[13] = A[31];
    A[30] = A[32] + 0.000417707292707363*G0_2_2_2 + 0.000171614100185558*G0_2_2_3 + 0.000171614100185558*G0_2_3_2 + 0.000171614100185558*G0_3_2_2 + 0.000810617953475234*G0_3_3_3 + 0.000114171542742991*G0_3_3_5 + 0.000114171542742991*G0_3_5_3 + 0.000114171542742991*G0_5_3_3 - 0.000114171542742991*G0_5_5_5;
    A[28] = A[82];
    A[98] = A[89];
    A[80] = A[8];
    A[62] = A[26];
    A[50] = A[5];
    A[14] = A[41];
    A[39] = A[93];
    A[23] = A[32];
    A[19] = A[2] + 0.000105370819656552*G0_0_5_5 + 0.000139458755530208*G0_1_1_1 - 0.000160315874601616*G0_1_4_4 + 0.000105370819656552*G0_2_3_3 + 0.000105370819656552*G0_3_2_3 + 0.000105370819656552*G0_3_3_2 - 0.000367568938997572*G0_3_3_3 - 0.000194725909011656*G0_3_3_5 + 0.000341246055531827*G0_3_4_4 - 0.000194725909011656*G0_3_5_3 - 0.000194725909011657*G0_3_5_5 - 0.000160315874601616*G0_4_1_4 + 0.000341246055531827*G0_4_3_4 - 0.000160315874601616*G0_4_4_1 + 0.000341246055531827*G0_4_4_3 + 0.000990120990121157*G0_4_4_4 + 0.000341246055531827*G0_4_4_5 + 0.000341246055531827*G0_4_5_4 + 0.000105370819656552*G0_5_0_5 - 0.000194725909011656*G0_5_3_3 - 0.000194725909011657*G0_5_3_5 + 0.000341246055531827*G0_5_4_4 + 0.000105370819656552*G0_5_5_0 - 0.000194725909011657*G0_5_5_3 - 0.000367568938997574*G0_5_5_5;
    A[42] = A[26] + 0.000228937728937768*G0_2_2_3 - 0.000228937728937768*G0_2_2_4 + 0.000228937728937768*G0_2_3_2 + 0.000233100233100273*G0_2_3_3 - 0.000228937728937768*G0_2_4_2 - 0.000233100233100272*G0_2_4_4 + 0.000228937728937768*G0_3_2_2 + 0.000233100233100273*G0_3_2_3 + 0.000233100233100273*G0_3_3_2 - 0.00029970029970035*G0_3_3_3 - 0.000228937728937768*G0_4_2_2 - 0.000233100233100272*G0_4_2_4 - 0.000233100233100272*G0_4_4_2 + 0.00029970029970035*G0_4_4_4;
    A[96] = A[69];
    A[65] = A[85] - 0.000224775224775264*G0_0_0_0 - 0.000262237762237807*G0_0_0_4 + 0.000106500642214946*G0_0_2_2 + 0.000183566433566465*G0_0_2_4 + 0.000104895104895123*G0_0_3_4 - 0.000262237762237807*G0_0_4_0 + 0.000183566433566465*G0_0_4_2 + 0.000104895104895123*G0_0_4_3 + 0.000201227344084521*G0_1_3_3 + 0.000106500642214946*G0_2_0_2 + 0.000183566433566465*G0_2_0_4 + 0.000106500642214946*G0_2_2_0 - 0.000651848151848262*G0_2_2_2 - 0.000237619523333849*G0_2_2_3 - 0.000526616240902044*G0_2_2_4 - 0.000237619523333849*G0_2_3_2 - 0.000316826031111799*G0_2_3_3 - 0.000316826031111799*G0_2_3_4 + 0.000183566433566465*G0_2_4_0 - 0.000526616240902044*G0_2_4_2 - 0.000316826031111799*G0_2_4_3 - 0.000787783644926635*G0_2_4_4 + 0.000104895104895123*G0_3_0_4 + 0.000201227344084521*G0_3_1_3 - 0.000237619523333849*G0_3_2_2 - 0.000316826031111799*G0_3_2_3 - 0.000316826031111799*G0_3_2_4 + 0.000201227344084521*G0_3_3_1 - 0.000316826031111799*G0_3_3_2 - 0.000402454688169042*G0_3_3_3 - 0.000342514628228972*G0_3_3_4 + 0.000104895104895123*G0_3_4_0 - 0.000316826031111799*G0_3_4_2 - 0.000342514628228972*G0_3_4_3 - 0.000102754388468692*G0_3_4_4 - 0.000262237762237807*G0_4_0_0 + 0.000183566433566465*G0_4_0_2 + 0.000104895104895123*G0_4_0_3 + 0.000183566433566465*G0_4_2_0 - 0.000526616240902044*G0_4_2_2 - 0.000316826031111799*G0_4_2_3 - 0.000787783644926635*G0_4_2_4 + 0.000104895104895123*G0_4_3_0 - 0.000316826031111799*G0_4_3_2 - 0.000342514628228972*G0_4_3_3 - 0.000102754388468692*G0_4_3_4 - 0.000787783644926635*G0_4_4_2 - 0.000102754388468692*G0_4_4_3 + 0.0023976023976028*G0_4_4_4 + 0.000299700299700349*G0_4_4_5 + 0.000299700299700349*G0_4_5_4 + 0.000299700299700349*G0_5_4_4 - 0.000299700299700349*G0_5_5_5;
    A[36] = A[65] + 0.000651848151848262*G0_0_0_0 - 0.000106500642214946*G0_0_0_2 + 0.000526616240902045*G0_0_0_4 + 0.000237619523333849*G0_0_0_5 - 0.000106500642214946*G0_0_2_0 - 0.000183566433566465*G0_0_2_4 + 0.000526616240902045*G0_0_4_0 - 0.000183566433566465*G0_0_4_2 + 0.000787783644926635*G0_0_4_4 + 0.000316826031111799*G0_0_4_5 + 0.000237619523333849*G0_0_5_0 + 0.000316826031111799*G0_0_5_4 + 0.000316826031111799*G0_0_5_5 - 0.000201227344084521*G0_1_5_5 - 0.000106500642214946*G0_2_0_0 - 0.000183566433566465*G0_2_0_4 + 0.000224775224775263*G0_2_2_2 + 0.000262237762237807*G0_2_2_4 - 0.000183566433566465*G0_2_4_0 + 0.000262237762237807*G0_2_4_2 - 0.000104895104895123*G0_2_4_5 - 0.000104895104895123*G0_2_5_4 + 0.000299700299700352*G0_3_3_3 - 0.00029970029970035*G0_3_4_4 + 0.000526616240902045*G0_4_0_0 - 0.000183566433566465*G0_4_0_2 + 0.000787783644926635*G0_4_0_4 + 0.000316826031111799*G0_4_0_5 - 0.000183566433566465*G0_4_2_0 + 0.000262237762237807*G0_4_2_2 - 0.000104895104895123*G0_4_2_5 - 0.00029970029970035*G0_4_3_4 + 0.000787783644926635*G0_4_4_0 - 0.00029970029970035*G0_4_4_3 - 0.0023976023976028*G0_4_4_4 + 0.000102754388468692*G0_4_4_5 + 0.000316826031111799*G0_4_5_0 - 0.000104895104895123*G0_4_5_2 + 0.000102754388468692*G0_4_5_4 + 0.000342514628228972*G0_4_5_5 + 0.000237619523333849*G0_5_0_0 + 0.000316826031111799*G0_5_0_4 + 0.000316826031111799*G0_5_0_5 - 0.000201227344084521*G0_5_1_5 - 0.000104895104895123*G0_5_2_4 + 0.000316826031111799*G0_5_4_0 - 0.000104895104895123*G0_5_4_2 + 0.000102754388468692*G0_5_4_4 + 0.000342514628228972*G0_5_4_5 + 0.000316826031111799*G0_5_5_0 - 0.000201227344084521*G0_5_5_1 + 0.000342514628228972*G0_5_5_4 + 0.000402454688169042*G0_5_5_5;
    A[53] = A[35];
    A[70] = A[7];
    A[68] = A[86];
    A[6] = A[60];
    A[17] = A[71];
    A[9] = A[90];
    A[34] = A[73] + 0.000201227344084521*G0_0_4_4 - 0.000224775224775263*G0_1_1_1 - 0.000262237762237807*G0_1_1_3 + 0.000106500642214946*G0_1_2_2 + 0.000183566433566465*G0_1_2_3 - 0.000262237762237807*G0_1_3_1 + 0.000183566433566465*G0_1_3_2 + 0.000104895104895123*G0_1_3_4 + 0.000104895104895123*G0_1_4_3 + 0.000106500642214946*G0_2_1_2 + 0.000183566433566465*G0_2_1_3 + 0.000106500642214946*G0_2_2_1 - 0.000651848151848262*G0_2_2_2 - 0.000526616240902044*G0_2_2_3 - 0.000237619523333849*G0_2_2_4 + 0.000183566433566465*G0_2_3_1 - 0.000526616240902044*G0_2_3_2 - 0.000787783644926636*G0_2_3_3 - 0.000316826031111799*G0_2_3_4 - 0.000237619523333849*G0_2_4_2 - 0.000316826031111799*G0_2_4_3 - 0.000316826031111799*G0_2_4_4 - 0.000262237762237807*G0_3_1_1 + 0.000183566433566465*G0_3_1_2 + 0.000104895104895123*G0_3_1_4 + 0.000183566433566465*G0_3_2_1 - 0.000526616240902044*G0_3_2_2 - 0.000787783644926636*G0_3_2_3 - 0.000316826031111799*G0_3_2_4 - 0.000787783644926635*G0_3_3_2 + 0.0023976023976028*G0_3_3_3 - 0.000102754388468692*G0_3_3_4 + 0.00029970029970035*G0_3_3_5 + 0.000104895104895123*G0_3_4_1 - 0.000316826031111799*G0_3_4_2 - 0.000102754388468692*G0_3_4_3 - 0.000342514628228972*G0_3_4_4 + 0.00029970029970035*G0_3_5_3 + 0.000201227344084521*G0_4_0_4 + 0.000104895104895123*G0_4_1_3 - 0.000237619523333849*G0_4_2_2 - 0.000316826031111799*G0_4_2_3 - 0.000316826031111799*G0_4_2_4 + 0.000104895104895123*G0_4_3_1 - 0.000316826031111799*G0_4_3_2 - 0.000102754388468692*G0_4_3_3 - 0.000342514628228972*G0_4_3_4 + 0.000201227344084521*G0_4_4_0 - 0.000316826031111799*G0_4_4_2 - 0.000342514628228972*G0_4_4_3 - 0.000402454688169042*G0_4_4_4 + 0.00029970029970035*G0_5_3_3 - 0.000299700299700348*G0_5_5_5;
    A[45] = A[34] - 0.000201227344084521*G0_0_5_5 + 0.000651848151848263*G0_1_1_1 - 0.000106500642214946*G0_1_1_2 + 0.000526616240902045*G0_1_1_3 + 0.000237619523333849*G0_1_1_5 - 0.000106500642214946*G0_1_2_1 - 0.000183566433566465*G0_1_2_3 + 0.000526616240902045*G0_1_3_1 - 0.000183566433566465*G0_1_3_2 + 0.000787783644926636*G0_1_3_3 + 0.000316826031111799*G0_1_3_5 + 0.000237619523333849*G0_1_5_1 + 0.000316826031111799*G0_1_5_3 + 0.000316826031111799*G0_1_5_5 - 0.000106500642214946*G0_2_1_1 - 0.000183566433566465*G0_2_1_3 + 0.000224775224775263*G0_2_2_2 + 0.000262237762237807*G0_2_2_3 - 0.000183566433566465*G0_2_3_1 + 0.000262237762237807*G0_2_3_2 - 0.000104895104895123*G0_2_3_5 - 0.000104895104895123*G0_2_5_3 + 0.000526616240902045*G0_3_1_1 - 0.000183566433566465*G0_3_1_2 + 0.000787783644926636*G0_3_1_3 + 0.000316826031111799*G0_3_1_5 - 0.000183566433566465*G0_3_2_1 + 0.000262237762237807*G0_3_2_2 - 0.000104895104895123*G0_3_2_5 + 0.000787783644926636*G0_3_3_1 - 0.0023976023976028*G0_3_3_3 - 0.00029970029970035*G0_3_3_4 + 0.000102754388468692*G0_3_3_5 - 0.00029970029970035*G0_3_4_3 + 0.000316826031111799*G0_3_5_1 - 0.000104895104895123*G0_3_5_2 + 0.000102754388468691*G0_3_5_3 + 0.000342514628228972*G0_3_5_5 - 0.00029970029970035*G0_4_3_3 + 0.00029970029970035*G0_4_4_4 - 0.000201227344084521*G0_5_0_5 + 0.000237619523333849*G0_5_1_1 + 0.000316826031111799*G0_5_1_3 + 0.000316826031111799*G0_5_1_5 - 0.000104895104895123*G0_5_2_3 + 0.000316826031111799*G0_5_3_1 - 0.000104895104895123*G0_5_3_2 + 0.000102754388468691*G0_5_3_3 + 0.000342514628228972*G0_5_3_5 - 0.000201227344084521*G0_5_5_0 + 0.000316826031111799*G0_5_5_1 + 0.000342514628228972*G0_5_5_3 + 0.000402454688169042*G0_5_5_5;
    A[67] = A[45] - 0.00035964035964042*G0_0_0_0 - 0.000176073926073956*G0_0_0_4 - 0.000258491508491552*G0_0_0_5 - 0.00017982017982021*G0_0_3_3 - 0.000124161552733002*G0_0_3_4 - 0.000176073926073956*G0_0_4_0 - 0.000124161552733002*G0_0_4_3 - 0.00028043385186247*G0_0_4_4 - 0.000214071642643107*G0_0_4_5 - 0.000258491508491552*G0_0_5_0 - 0.000214071642643107*G0_0_5_4 - 0.00040031397174261*G0_0_5_5 - 0.000246182389039573*G0_1_3_3 + 0.000246182389039573*G0_1_5_5 + 0.00035964035964042*G0_2_2_2 + 0.000258491508491552*G0_2_2_3 + 0.000176073926073955*G0_2_2_4 + 0.000258491508491552*G0_2_3_2 + 0.00040031397174261*G0_2_3_3 + 0.000214071642643107*G0_2_3_4 + 0.000176073926073955*G0_2_4_2 + 0.000214071642643107*G0_2_4_3 + 0.00028043385186247*G0_2_4_4 + 0.000124161552733002*G0_2_4_5 + 0.000124161552733002*G0_2_5_4 + 0.00017982017982021*G0_2_5_5 - 0.00017982017982021*G0_3_0_3 - 0.000124161552733002*G0_3_0_4 - 0.000246182389039573*G0_3_1_3 + 0.000258491508491552*G0_3_2_2 + 0.00040031397174261*G0_3_2_3 + 0.000214071642643107*G0_3_2_4 - 0.00017982017982021*G0_3_3_0 - 0.000246182389039573*G0_3_3_1 + 0.00040031397174261*G0_3_3_2 + 0.00164407021549906*G0_3_3_3 + 0.000522334808049182*G0_3_3_4 + 0.000196945911231659*G0_3_3_5 - 0.000124161552733002*G0_3_4_0 + 0.000214071642643107*G0_3_4_2 + 0.000522334808049181*G0_3_4_3 + 0.000248323105466004*G0_3_4_4 + 0.000196945911231659*G0_3_5_3 - 0.000196945911231659*G0_3_5_5 - 0.000176073926073956*G0_4_0_0 - 0.000124161552733002*G0_4_0_3 - 0.00028043385186247*G0_4_0_4 - 0.000214071642643107*G0_4_0_5 + 0.000176073926073955*G0_4_2_2 + 0.000214071642643107*G0_4_2_3 + 0.00028043385186247*G0_4_2_4 + 0.000124161552733002*G0_4_2_5 - 0.000124161552733002*G0_4_3_0 + 0.000214071642643107*G0_4_3_2 + 0.000522334808049182*G0_4_3_3 + 0.000248323105466004*G0_4_3_4 - 0.00028043385186247*G0_4_4_0 + 0.00028043385186247*G0_4_4_2 + 0.000248323105466004*G0_4_4_3 - 0.000248323105466005*G0_4_4_5 - 0.000214071642643107*G0_4_5_0 + 0.000124161552733002*G0_4_5_2 - 0.000248323105466005*G0_4_5_4 - 0.000522334808049182*G0_4_5_5 - 0.000258491508491552*G0_5_0_0 - 0.000214071642643107*G0_5_0_4 - 0.00040031397174261*G0_5_0_5 + 0.000246182389039573*G0_5_1_5 + 0.000124161552733002*G0_5_2_4 + 0.00017982017982021*G0_5_2_5 + 0.000196945911231659*G0_5_3_3 - 0.000196945911231659*G0_5_3_5 - 0.000214071642643107*G0_5_4_0 + 0.000124161552733002*G0_5_4_2 - 0.000248323105466005*G0_5_4_4 - 0.000522334808049182*G0_5_4_5 - 0.00040031397174261*G0_5_5_0 + 0.000246182389039573*G0_5_5_1 + 0.00017982017982021*G0_5_5_2 - 0.000196945911231659*G0_5_5_3 - 0.000522334808049182*G0_5_5_4 - 0.00164407021549906*G0_5_5_5;
    A[55] = -A[67] + 0.00118006993007013*G0_0_0_0 - 0.000260364635364679*G0_0_0_2 + 0.00138611388611412*G0_0_0_4 + 0.000243506493506534*G0_0_0_5 - 0.000137005851291589*G0_0_1_4 - 0.000260364635364679*G0_0_2_0 - 0.000481661195946992*G0_0_2_4 + 0.000109176537747985*G0_0_3_4 + 0.00138611388611412*G0_0_4_0 - 0.000137005851291589*G0_0_4_1 - 0.000481661195946992*G0_0_4_2 + 0.000109176537747985*G0_0_4_3 + 0.00247252747252789*G0_0_4_4 + 0.000449550449550525*G0_0_4_5 + 0.000243506493506534*G0_0_5_0 + 0.000449550449550525*G0_0_5_4 - 0.000137005851291589*G0_1_0_4 - 0.000122020836306571*G0_1_3_4 - 0.000137005851291589*G0_1_4_0 - 0.000122020836306571*G0_1_4_3 - 0.000682888540031511*G0_1_4_4 - 0.000181960896246641*G0_1_4_5 - 0.000181960896246641*G0_1_5_4 - 0.000260364635364679*G0_2_0_0 - 0.000481661195946992*G0_2_0_4 + 0.000191058941058973*G0_2_2_2 + 0.000108641358641377*G0_2_2_3 + 0.000382117882117946*G0_2_2_4 + 0.000108641358641377*G0_2_3_2 - 0.000481661195946992*G0_2_4_0 + 0.000382117882117946*G0_2_4_2 - 0.00122877122877144*G0_2_4_4 - 0.00028043385186247*G0_2_4_5 - 0.000280433851862471*G0_2_5_4 + 0.000109176537747985*G0_3_0_4 - 0.000122020836306571*G0_3_1_4 + 0.000108641358641377*G0_3_2_2 + 0.000488083345226285*G0_3_3_3 + 0.000351077493934696*G0_3_3_4 + 0.000205508776937383*G0_3_3_5 + 0.000109176537747985*G0_3_4_0 - 0.000122020836306571*G0_3_4_1 + 0.000351077493934696*G0_3_4_3 + 0.00114742400456706*G0_3_4_4 + 0.000342514628228972*G0_3_4_5 + 0.000205508776937383*G0_3_5_3 + 0.000342514628228972*G0_3_5_4 + 0.00138611388611412*G0_4_0_0 - 0.000137005851291589*G0_4_0_1 - 0.000481661195946992*G0_4_0_2 + 0.000109176537747985*G0_4_0_3 + 0.00247252747252789*G0_4_0_4 + 0.000449550449550525*G0_4_0_5 - 0.000137005851291589*G0_4_1_0 - 0.000122020836306571*G0_4_1_3 - 0.000682888540031511*G0_4_1_4 - 0.000181960896246641*G0_4_1_5 - 0.000481661195946992*G0_4_2_0 + 0.000382117882117946*G0_4_2_2 - 0.00122877122877144*G0_4_2_4 - 0.00028043385186247*G0_4_2_5 + 0.000109176537747985*G0_4_3_0 - 0.000122020836306571*G0_4_3_1 + 0.000351077493934696*G0_4_3_3 + 0.00114742400456706*G0_4_3_4 + 0.000342514628228972*G0_4_3_5 + 0.00247252747252789*G0_4_4_0 - 0.000682888540031511*G0_4_4_1 - 0.00122877122877144*G0_4_4_2 + 0.00114742400456706*G0_4_4_3 + 0.0115598687027278*G0_4_4_4 + 0.00192664478378796*G0_4_4_5 + 0.000449550449550525*G0_4_5_0 - 0.000181960896246641*G0_4_5_1 - 0.00028043385186247*G0_4_5_2 + 0.000342514628228971*G0_4_5_3 + 0.00192664478378796*G0_4_5_4 + 0.000470957613814835*G0_4_5_5 + 0.000243506493506534*G0_5_0_0 + 0.000449550449550525*G0_5_0_4 - 0.000181960896246641*G0_5_1_4 - 0.00028043385186247*G0_5_2_4 + 0.000205508776937383*G0_5_3_3 + 0.000342514628228971*G0_5_3_4 + 0.000449550449550525*G0_5_4_0 - 0.000181960896246641*G0_5_4_1 - 0.00028043385186247*G0_5_4_2 + 0.000342514628228971*G0_5_4_3 + 0.00192664478378796*G0_5_4_4 + 0.000470957613814835*G0_5_4_5 + 0.000470957613814835*G0_5_5_4 - 0.000770657913515186*G0_5_5_5;
    A[76] = A[67];
    A[75] = A[55] - 0.000786713286713422*G0_0_0_0 + 0.000189185814185846*G0_0_0_2 - 0.00108641358641377*G0_0_0_4 + 0.000189185814185846*G0_0_2_0 + 0.000400849150849219*G0_0_2_4 - 0.00108641358641377*G0_0_4_0 + 0.000400849150849219*G0_0_4_2 - 0.00202297702297736*G0_0_4_4 - 0.000224775224775263*G0_0_4_5 - 0.000224775224775263*G0_0_5_4 + 0.000224775224775262*G0_0_5_5 + 0.000470957613814835*G0_1_4_4 - 0.000128442985585864*G0_1_5_5 + 0.000189185814185846*G0_2_0_0 + 0.000400849150849219*G0_2_0_4 - 0.000224775224775263*G0_2_2_2 - 0.000102754388468692*G0_2_2_3 - 0.000346796061081834*G0_2_2_4 - 0.000102754388468692*G0_2_3_2 - 0.000107035821321554*G0_2_3_3 + 0.000400849150849219*G0_2_4_0 - 0.000346796061081834*G0_2_4_2 + 0.000890538033395326*G0_2_4_4 + 0.000128442985585864*G0_2_4_5 + 0.000128442985585864*G0_2_5_4 - 0.000102754388468692*G0_3_2_2 - 0.000107035821321554*G0_3_2_3 - 0.000107035821321554*G0_3_3_2 - 0.000162694448408762*G0_3_3_3 - 0.000222634508348832*G0_3_3_4 - 0.000222634508348832*G0_3_4_3 - 0.000822035107749533*G0_3_4_4 - 0.000137005851291589*G0_3_4_5 - 0.000137005851291589*G0_3_5_4 + 0.000137005851291589*G0_3_5_5 - 0.00108641358641377*G0_4_0_0 + 0.000400849150849219*G0_4_0_2 - 0.00202297702297736*G0_4_0_4 - 0.000224775224775263*G0_4_0_5 + 0.000470957613814835*G0_4_1_4 + 0.000400849150849219*G0_4_2_0 - 0.000346796061081834*G0_4_2_2 + 0.000890538033395326*G0_4_2_4 + 0.000128442985585864*G0_4_2_5 - 0.000222634508348832*G0_4_3_3 - 0.000822035107749533*G0_4_3_4 - 0.000137005851291589*G0_4_3_5 - 0.00202297702297736*G0_4_4_0 + 0.000470957613814835*G0_4_4_1 + 0.000890538033395326*G0_4_4_2 - 0.000822035107749533*G0_4_4_3 - 0.00959040959041121*G0_4_4_4 - 0.0011988011988014*G0_4_4_5 - 0.000224775224775263*G0_4_5_0 + 0.000128442985585864*G0_4_5_2 - 0.000137005851291589*G0_4_5_3 - 0.0011988011988014*G0_4_5_4 - 0.000224775224775263*G0_5_0_4 + 0.000224775224775262*G0_5_0_5 - 0.000128442985585864*G0_5_1_5 + 0.000128442985585864*G0_5_2_4 - 0.000137005851291589*G0_5_3_4 + 0.000137005851291588*G0_5_3_5 - 0.000224775224775263*G0_5_4_0 + 0.000128442985585864*G0_5_4_2 - 0.000137005851291589*G0_5_4_3 - 0.0011988011988014*G0_5_4_4 + 0.000224775224775262*G0_5_5_0 - 0.000128442985585864*G0_5_5_1 + 0.000137005851291589*G0_5_5_3 + 0.0011988011988014*G0_5_5_5;
    A[78] = A[67] - 0.000224775224775262*G0_0_0_0 - 0.000262237762237806*G0_0_0_5 + 0.000106500642214946*G0_0_1_1 + 0.000183566433566464*G0_0_1_5 + 0.000104895104895123*G0_0_3_5 - 0.000262237762237806*G0_0_5_0 + 0.000183566433566464*G0_0_5_1 + 0.000104895104895123*G0_0_5_3 + 0.000106500642214946*G0_1_0_1 + 0.000183566433566464*G0_1_0_5 + 0.000106500642214946*G0_1_1_0 - 0.000651848151848262*G0_1_1_1 - 0.000237619523333849*G0_1_1_3 - 0.000526616240902044*G0_1_1_5 - 0.000237619523333849*G0_1_3_1 - 0.000316826031111799*G0_1_3_3 - 0.000316826031111799*G0_1_3_5 + 0.000183566433566464*G0_1_5_0 - 0.000526616240902044*G0_1_5_1 - 0.000316826031111799*G0_1_5_3 - 0.000787783644926635*G0_1_5_5 + 0.000201227344084521*G0_2_3_3 + 0.000104895104895123*G0_3_0_5 - 0.000237619523333849*G0_3_1_1 - 0.000316826031111799*G0_3_1_3 - 0.000316826031111799*G0_3_1_5 + 0.000201227344084521*G0_3_2_3 - 0.000316826031111799*G0_3_3_1 + 0.000201227344084521*G0_3_3_2 - 0.000402454688169042*G0_3_3_3 - 0.000342514628228972*G0_3_3_5 + 0.000104895104895123*G0_3_5_0 - 0.000316826031111799*G0_3_5_1 - 0.000342514628228972*G0_3_5_3 - 0.000102754388468691*G0_3_5_5 - 0.000299700299700347*G0_4_4_4 + 0.000299700299700351*G0_4_5_5 - 0.000262237762237806*G0_5_0_0 + 0.000183566433566464*G0_5_0_1 + 0.000104895104895123*G0_5_0_3 + 0.000183566433566464*G0_5_1_0 - 0.000526616240902044*G0_5_1_1 - 0.000316826031111799*G0_5_1_3 - 0.000787783644926635*G0_5_1_5 + 0.000104895104895123*G0_5_3_0 - 0.000316826031111799*G0_5_3_1 - 0.000342514628228972*G0_5_3_3 - 0.000102754388468691*G0_5_3_5 + 0.000299700299700351*G0_5_4_5 - 0.000787783644926635*G0_5_5_1 - 0.000102754388468691*G0_5_5_3 + 0.000299700299700351*G0_5_5_4 + 0.0023976023976028*G0_5_5_5;
    A[64] = A[75] - 0.000786713286713418*G0_0_0_0 + 0.000107303410874857*G0_0_0_1 + 0.000153462608819777*G0_0_0_2 - 0.000440452404738193*G0_0_0_4 - 0.000496111031825401*G0_0_0_5 + 0.000107303410874857*G0_0_1_0 + 0.000173398030540917*G0_0_1_4 + 0.000158948194662507*G0_0_1_5 + 0.000153462608819777*G0_0_2_0 - 0.000153462608819777*G0_0_2_2 - 0.000269730269730315*G0_0_3_3 - 0.000325388896817523*G0_0_3_4 - 0.000162694448408762*G0_0_3_5 - 0.000440452404738193*G0_0_4_0 + 0.000173398030540917*G0_0_4_1 - 0.000325388896817523*G0_0_4_3 - 0.0010682174967891*G0_0_4_4 - 0.000530897673754906*G0_0_4_5 - 0.000496111031825401*G0_0_5_0 + 0.000158948194662507*G0_0_5_1 - 0.000162694448408762*G0_0_5_3 - 0.000530897673754906*G0_0_5_4 - 0.000717140002854409*G0_0_5_5 + 0.000107303410874857*G0_1_0_0 + 0.000173398030540917*G0_1_0_4 + 0.000158948194662507*G0_1_0_5 - 0.000107303410874857*G0_1_2_2 - 0.000158948194662507*G0_1_2_3 - 0.000173398030540917*G0_1_2_4 - 0.000158948194662507*G0_1_3_2 - 0.000351077493934696*G0_1_3_3 - 0.000162694448408761*G0_1_3_4 + 0.000173398030540917*G0_1_4_0 - 0.000173398030540917*G0_1_4_2 - 0.000162694448408761*G0_1_4_3 + 0.000162694448408762*G0_1_4_5 + 0.000158948194662507*G0_1_5_0 + 0.000162694448408762*G0_1_5_4 + 0.000351077493934696*G0_1_5_5 + 0.000153462608819777*G0_2_0_0 - 0.000153462608819777*G0_2_0_2 - 0.000107303410874857*G0_2_1_2 - 0.000158948194662507*G0_2_1_3 - 0.000173398030540917*G0_2_1_4 - 0.000153462608819777*G0_2_2_0 - 0.000107303410874857*G0_2_2_1 + 0.000786713286713418*G0_2_2_2 + 0.000496111031825401*G0_2_2_3 + 0.000440452404738193*G0_2_2_4 - 0.000158948194662507*G0_2_3_1 + 0.000496111031825401*G0_2_3_2 + 0.000717140002854409*G0_2_3_3 + 0.000530897673754906*G0_2_3_4 + 0.000162694448408762*G0_2_3_5 - 0.000173398030540917*G0_2_4_1 + 0.000440452404738193*G0_2_4_2 + 0.000530897673754906*G0_2_4_3 + 0.0010682174967891*G0_2_4_4 + 0.000325388896817523*G0_2_4_5 + 0.000162694448408762*G0_2_5_3 + 0.000325388896817523*G0_2_5_4 + 0.000269730269730315*G0_2_5_5 - 0.000269730269730315*G0_3_0_3 - 0.000325388896817523*G0_3_0_4 - 0.000162694448408762*G0_3_0_5 - 0.000158948194662507*G0_3_1_2 - 0.000351077493934696*G0_3_1_3 - 0.000162694448408761*G0_3_1_4 - 0.000158948194662507*G0_3_2_1 + 0.000496111031825401*G0_3_2_2 + 0.000717140002854409*G0_3_2_3 + 0.000530897673754906*G0_3_2_4 + 0.000162694448408762*G0_3_2_5 - 0.000269730269730315*G0_3_3_0 - 0.000351077493934696*G0_3_3_1 + 0.000717140002854409*G0_3_3_2 + 0.00174682460396776*G0_3_3_3 + 0.000864849436278153*G0_3_3_4 + 0.000214071642643108*G0_3_3_5 - 0.000325388896817523*G0_3_4_0 - 0.000162694448408761*G0_3_4_1 + 0.000530897673754906*G0_3_4_2 + 0.000864849436278153*G0_3_4_3 + 0.000650777793635046*G0_3_4_4 - 0.000162694448408762*G0_3_5_0 + 0.000162694448408762*G0_3_5_2 + 0.000214071642643108*G0_3_5_3 - 0.000214071642643107*G0_3_5_5 - 0.000440452404738193*G0_4_0_0 + 0.000173398030540917*G0_4_0_1 - 0.000325388896817523*G0_4_0_3 - 0.0010682174967891*G0_4_0_4 - 0.000530897673754906*G0_4_0_5 + 0.000173398030540917*G0_4_1_0 - 0.000173398030540917*G0_4_1_2 - 0.000162694448408761*G0_4_1_3 + 0.000162694448408761*G0_4_1_5 - 0.000173398030540917*G0_4_2_1 + 0.000440452404738193*G0_4_2_2 + 0.000530897673754906*G0_4_2_3 + 0.0010682174967891*G0_4_2_4 + 0.000325388896817523*G0_4_2_5 - 0.000325388896817523*G0_4_3_0 - 0.000162694448408761*G0_4_3_1 + 0.000530897673754906*G0_4_3_2 + 0.000864849436278153*G0_4_3_3 + 0.000650777793635046*G0_4_3_4 - 0.0010682174967891*G0_4_4_0 + 0.0010682174967891*G0_4_4_2 + 0.000650777793635046*G0_4_4_3 - 0.000650777793635045*G0_4_4_5 - 0.000530897673754906*G0_4_5_0 + 0.000162694448408762*G0_4_5_1 + 0.000325388896817523*G0_4_5_2 - 0.000650777793635045*G0_4_5_4 - 0.000864849436278153*G0_4_5_5 - 0.000496111031825401*G0_5_0_0 + 0.000158948194662507*G0_5_0_1 - 0.000162694448408762*G0_5_0_3 - 0.000530897673754906*G0_5_0_4 - 0.000717140002854409*G0_5_0_5 + 0.000158948194662507*G0_5_1_0 + 0.000162694448408762*G0_5_1_4 + 0.000351077493934696*G0_5_1_5 + 0.000162694448408762*G0_5_2_3 + 0.000325388896817523*G0_5_2_4 + 0.000269730269730315*G0_5_2_5 - 0.000162694448408762*G0_5_3_0 + 0.000162694448408762*G0_5_3_2 + 0.000214071642643108*G0_5_3_3 - 0.000214071642643107*G0_5_3_5 - 0.000530897673754906*G0_5_4_0 + 0.000162694448408762*G0_5_4_1 + 0.000325388896817523*G0_5_4_2 - 0.000650777793635045*G0_5_4_4 - 0.000864849436278153*G0_5_4_5 - 0.000717140002854409*G0_5_5_0 + 0.000351077493934696*G0_5_5_1 + 0.000269730269730315*G0_5_5_2 - 0.000214071642643107*G0_5_5_3 - 0.000864849436278153*G0_5_5_4 - 0.00174682460396775*G0_5_5_5;
    A[54] = A[45];
    A[83] = A[75] - 0.000786713286713418*G0_0_0_0 + 0.000153462608819777*G0_0_0_1 + 0.000107303410874857*G0_0_0_2 - 0.000496111031825401*G0_0_0_4 - 0.000440452404738193*G0_0_0_5 + 0.000153462608819777*G0_0_1_0 - 0.000153462608819777*G0_0_1_1 + 0.000107303410874857*G0_0_2_0 + 0.000158948194662507*G0_0_2_4 + 0.000173398030540917*G0_0_2_5 - 0.000269730269730315*G0_0_3_3 - 0.000162694448408761*G0_0_3_4 - 0.000325388896817523*G0_0_3_5 - 0.000496111031825401*G0_0_4_0 + 0.000158948194662507*G0_0_4_2 - 0.000162694448408761*G0_0_4_3 - 0.000717140002854409*G0_0_4_4 - 0.000530897673754906*G0_0_4_5 - 0.000440452404738193*G0_0_5_0 + 0.000173398030540917*G0_0_5_2 - 0.000325388896817523*G0_0_5_3 - 0.000530897673754906*G0_0_5_4 - 0.0010682174967891*G0_0_5_5 + 0.000153462608819777*G0_1_0_0 - 0.000153462608819778*G0_1_0_1 - 0.000153462608819778*G0_1_1_0 + 0.00078671328671342*G0_1_1_1 - 0.000107303410874858*G0_1_1_2 + 0.000496111031825401*G0_1_1_3 + 0.000440452404738193*G0_1_1_5 - 0.000107303410874858*G0_1_2_1 - 0.000158948194662507*G0_1_2_3 - 0.000173398030540917*G0_1_2_5 + 0.000496111031825401*G0_1_3_1 - 0.000158948194662507*G0_1_3_2 + 0.00071714000285441*G0_1_3_3 + 0.000162694448408762*G0_1_3_4 + 0.000530897673754906*G0_1_3_5 + 0.000162694448408762*G0_1_4_3 + 0.000269730269730315*G0_1_4_4 + 0.000325388896817523*G0_1_4_5 + 0.000440452404738193*G0_1_5_1 - 0.000173398030540917*G0_1_5_2 + 0.000530897673754906*G0_1_5_3 + 0.000325388896817523*G0_1_5_4 + 0.0010682174967891*G0_1_5_5 + 0.000107303410874857*G0_2_0_0 + 0.000158948194662507*G0_2_0_4 + 0.000173398030540917*G0_2_0_5 - 0.000107303410874858*G0_2_1_1 - 0.000158948194662507*G0_2_1_3 - 0.000173398030540917*G0_2_1_5 - 0.000158948194662507*G0_2_3_1 - 0.000351077493934696*G0_2_3_3 - 0.000162694448408762*G0_2_3_5 + 0.000158948194662507*G0_2_4_0 + 0.000351077493934696*G0_2_4_4 + 0.000162694448408761*G0_2_4_5 + 0.000173398030540917*G0_2_5_0 - 0.000173398030540917*G0_2_5_1 - 0.000162694448408762*G0_2_5_3 + 0.000162694448408761*G0_2_5_4 - 0.000269730269730315*G0_3_0_3 - 0.000162694448408761*G0_3_0_4 - 0.000325388896817523*G0_3_0_5 + 0.000496111031825401*G0_3_1_1 - 0.000158948194662507*G0_3_1_2 + 0.00071714000285441*G0_3_1_3 + 0.000162694448408762*G0_3_1_4 + 0.000530897673754906*G0_3_1_5 - 0.000158948194662507*G0_3_2_1 - 0.000351077493934696*G0_3_2_3 - 0.000162694448408761*G0_3_2_5 - 0.000269730269730315*G0_3_3_0 + 0.00071714000285441*G0_3_3_1 - 0.000351077493934696*G0_3_3_2 + 0.00174682460396776*G0_3_3_3 + 0.000214071642643107*G0_3_3_4 + 0.000864849436278154*G0_3_3_5 - 0.000162694448408761*G0_3_4_0 + 0.000162694448408762*G0_3_4_1 + 0.000214071642643107*G0_3_4_3 - 0.000214071642643108*G0_3_4_4 - 0.000325388896817523*G0_3_5_0 + 0.000530897673754906*G0_3_5_1 - 0.000162694448408761*G0_3_5_2 + 0.000864849436278154*G0_3_5_3 + 0.000650777793635046*G0_3_5_5 - 0.000496111031825401*G0_4_0_0 + 0.000158948194662507*G0_4_0_2 - 0.000162694448408761*G0_4_0_3 - 0.000717140002854409*G0_4_0_4 - 0.000530897673754906*G0_4_0_5 + 0.000162694448408762*G0_4_1_3 + 0.000269730269730315*G0_4_1_4 + 0.000325388896817523*G0_4_1_5 + 0.000158948194662507*G0_4_2_0 + 0.000351077493934695*G0_4_2_4 + 0.000162694448408761*G0_4_2_5 - 0.000162694448408761*G0_4_3_0 + 0.000162694448408762*G0_4_3_1 + 0.000214071642643107*G0_4_3_3 - 0.000214071642643108*G0_4_3_4 - 0.000717140002854409*G0_4_4_0 + 0.000269730269730315*G0_4_4_1 + 0.000351077493934696*G0_4_4_2 - 0.000214071642643108*G0_4_4_3 - 0.00174682460396775*G0_4_4_4 - 0.000864849436278153*G0_4_4_5 - 0.000530897673754906*G0_4_5_0 + 0.000325388896817523*G0_4_5_1 + 0.000162694448408761*G0_4_5_2 - 0.000864849436278153*G0_4_5_4 - 0.000650777793635046*G0_4_5_5 - 0.000440452404738193*G0_5_0_0 + 0.000173398030540917*G0_5_0_2 - 0.000325388896817523*G0_5_0_3 - 0.000530897673754906*G0_5_0_4 - 0.0010682174967891*G0_5_0_5 + 0.000440452404738193*G0_5_1_1 - 0.000173398030540917*G0_5_1_2 + 0.000530897673754906*G0_5_1_3 + 0.000325388896817523*G0_5_1_4 + 0.0010682174967891*G0_5_1_5 + 0.000173398030540917*G0_5_2_0 - 0.000173398030540917*G0_5_2_1 - 0.000162694448408762*G0_5_2_3 + 0.000162694448408761*G0_5_2_4 - 0.000325388896817523*G0_5_3_0 + 0.000530897673754906*G0_5_3_1 - 0.000162694448408762*G0_5_3_2 + 0.000864849436278154*G0_5_3_3 + 0.000650777793635046*G0_5_3_5 - 0.000530897673754906*G0_5_4_0 + 0.000325388896817523*G0_5_4_1 + 0.000162694448408761*G0_5_4_2 - 0.000864849436278153*G0_5_4_4 - 0.000650777793635046*G0_5_4_5 - 0.0010682174967891*G0_5_5_0 + 0.0010682174967891*G0_5_5_1 + 0.000650777793635046*G0_5_5_3 - 0.000650777793635046*G0_5_5_4;
    A[46] = A[64];
    A[57] = A[75];
    A[48] = A[78] + 0.000651848151848261*G0_0_0_0 - 0.000106500642214946*G0_0_0_1 + 0.000237619523333849*G0_0_0_4 + 0.000526616240902044*G0_0_0_5 - 0.000106500642214946*G0_0_1_0 - 0.000183566433566464*G0_0_1_5 + 0.000237619523333849*G0_0_4_0 + 0.000316826031111798*G0_0_4_4 + 0.000316826031111799*G0_0_4_5 + 0.000526616240902044*G0_0_5_0 - 0.000183566433566464*G0_0_5_1 + 0.000316826031111799*G0_0_5_4 + 0.000787783644926634*G0_0_5_5 - 0.000106500642214946*G0_1_0_0 - 0.000183566433566464*G0_1_0_5 + 0.000224775224775263*G0_1_1_1 + 0.000262237762237807*G0_1_1_5 - 0.000104895104895123*G0_1_4_5 - 0.000183566433566464*G0_1_5_0 + 0.000262237762237807*G0_1_5_1 - 0.000104895104895123*G0_1_5_4 - 0.000201227344084521*G0_2_4_4 + 0.000299700299700351*G0_3_3_3 - 0.000299700299700351*G0_3_5_5 + 0.000237619523333849*G0_4_0_0 + 0.000316826031111798*G0_4_0_4 + 0.000316826031111799*G0_4_0_5 - 0.000104895104895123*G0_4_1_5 - 0.000201227344084521*G0_4_2_4 + 0.000316826031111798*G0_4_4_0 - 0.000201227344084521*G0_4_4_2 + 0.000402454688169042*G0_4_4_4 + 0.000342514628228971*G0_4_4_5 + 0.000316826031111799*G0_4_5_0 - 0.000104895104895123*G0_4_5_1 + 0.000342514628228971*G0_4_5_4 + 0.000102754388468691*G0_4_5_5 + 0.000526616240902044*G0_5_0_0 - 0.000183566433566464*G0_5_0_1 + 0.000316826031111799*G0_5_0_4 + 0.000787783644926634*G0_5_0_5 - 0.000183566433566464*G0_5_1_0 + 0.000262237762237807*G0_5_1_1 - 0.000104895104895123*G0_5_1_4 - 0.000299700299700351*G0_5_3_5 + 0.000316826031111799*G0_5_4_0 - 0.000104895104895123*G0_5_4_1 + 0.000342514628228971*G0_5_4_4 + 0.000102754388468691*G0_5_4_5 + 0.000787783644926634*G0_5_5_0 - 0.000299700299700351*G0_5_5_3 + 0.000102754388468691*G0_5_5_4 - 0.0023976023976028*G0_5_5_5;
    A[87] = A[78];
    A[24] = A[42];
    A[84] = A[48];
    A[59] = A[69] + 0.00050574425574434*G0_0_0_0 - 0.000158948194662507*G0_0_0_2 + 0.000337162837162894*G0_0_0_4 + 0.000337162837162894*G0_0_0_5 - 0.000173398030540917*G0_0_1_3 - 0.000298629941487135*G0_0_1_4 - 0.000192664478378797*G0_0_1_5 - 0.000158948194662507*G0_0_2_0 + 0.000158948194662507*G0_0_2_2 - 0.000173398030540917*G0_0_3_1 + 0.000809190809190946*G0_0_3_3 + 0.000770657913515187*G0_0_3_4 + 0.000346796061081834*G0_0_3_5 + 0.000337162837162894*G0_0_4_0 - 0.000298629941487135*G0_0_4_1 + 0.000770657913515187*G0_0_4_3 + 0.00192664478378797*G0_0_4_4 + 0.000770657913515187*G0_0_4_5 + 0.000337162837162894*G0_0_5_0 - 0.000192664478378797*G0_0_5_1 + 0.000346796061081834*G0_0_5_3 + 0.000770657913515187*G0_0_5_4 + 0.00057799343513639*G0_0_5_5 - 0.000173398030540917*G0_1_0_3 - 0.000298629941487135*G0_1_0_4 - 0.000192664478378797*G0_1_0_5 - 0.000105965463108338*G0_1_1_3 + 0.000105965463108338*G0_1_1_5 + 0.000192664478378796*G0_1_2_3 + 0.000298629941487134*G0_1_2_4 + 0.000173398030540917*G0_1_2_5 - 0.000173398030540917*G0_1_3_0 - 0.000105965463108338*G0_1_3_1 + 0.000192664478378796*G0_1_3_2 + 0.000616526330812149*G0_1_3_3 + 0.000346796061081834*G0_1_3_4 - 0.000298629941487135*G0_1_4_0 + 0.000298629941487134*G0_1_4_2 + 0.000346796061081834*G0_1_4_3 - 0.000346796061081834*G0_1_4_5 - 0.000192664478378797*G0_1_5_0 + 0.000105965463108338*G0_1_5_1 + 0.000173398030540917*G0_1_5_2 - 0.000346796061081834*G0_1_5_4 - 0.000616526330812149*G0_1_5_5 - 0.000158948194662507*G0_2_0_0 + 0.000158948194662507*G0_2_0_2 + 0.000192664478378796*G0_2_1_3 + 0.000298629941487134*G0_2_1_4 + 0.000173398030540917*G0_2_1_5 + 0.000158948194662507*G0_2_2_0 - 0.000505744255744341*G0_2_2_2 - 0.000337162837162894*G0_2_2_3 - 0.000337162837162894*G0_2_2_4 + 0.000192664478378796*G0_2_3_1 - 0.000337162837162894*G0_2_3_2 - 0.000577993435136389*G0_2_3_3 - 0.000770657913515186*G0_2_3_4 - 0.000346796061081834*G0_2_3_5 + 0.000298629941487134*G0_2_4_1 - 0.000337162837162894*G0_2_4_2 - 0.000770657913515186*G0_2_4_3 - 0.00192664478378796*G0_2_4_4 - 0.000770657913515186*G0_2_4_5 + 0.000173398030540917*G0_2_5_1 - 0.000346796061081834*G0_2_5_3 - 0.000770657913515186*G0_2_5_4 - 0.000809190809190946*G0_2_5_5 - 0.000173398030540917*G0_3_0_1 + 0.000809190809190946*G0_3_0_3 + 0.000770657913515187*G0_3_0_4 + 0.000346796061081834*G0_3_0_5 - 0.000173398030540917*G0_3_1_0 - 0.000105965463108338*G0_3_1_1 + 0.000192664478378796*G0_3_1_2 + 0.000616526330812149*G0_3_1_3 + 0.000346796061081834*G0_3_1_4 + 0.000192664478378796*G0_3_2_1 - 0.000337162837162894*G0_3_2_2 - 0.000577993435136389*G0_3_2_3 - 0.000770657913515186*G0_3_2_4 - 0.000346796061081834*G0_3_2_5 + 0.000809190809190946*G0_3_3_0 + 0.000616526330812149*G0_3_3_1 - 0.000577993435136389*G0_3_3_2 - 0.00462394748109112*G0_3_3_3 - 0.00231197374054556*G0_3_3_4 - 0.000924789496218225*G0_3_3_5 + 0.000770657913515187*G0_3_4_0 + 0.000346796061081834*G0_3_4_1 - 0.000770657913515186*G0_3_4_2 - 0.00231197374054556*G0_3_4_3 - 0.00154131582703037*G0_3_4_4 + 0.000346796061081834*G0_3_5_0 - 0.000346796061081834*G0_3_5_2 - 0.000924789496218225*G0_3_5_3 + 0.000924789496218223*G0_3_5_5 + 0.000337162837162894*G0_4_0_0 - 0.000298629941487135*G0_4_0_1 + 0.000770657913515187*G0_4_0_3 + 0.00192664478378797*G0_4_0_4 + 0.000770657913515187*G0_4_0_5 - 0.000298629941487135*G0_4_1_0 + 0.000298629941487134*G0_4_1_2 + 0.000346796061081834*G0_4_1_3 - 0.000346796061081834*G0_4_1_5 + 0.000298629941487134*G0_4_2_1 - 0.000337162837162894*G0_4_2_2 - 0.000770657913515186*G0_4_2_3 - 0.00192664478378796*G0_4_2_4 - 0.000770657913515186*G0_4_2_5 + 0.000770657913515187*G0_4_3_0 + 0.000346796061081834*G0_4_3_1 - 0.000770657913515186*G0_4_3_2 - 0.00231197374054556*G0_4_3_3 - 0.00154131582703037*G0_4_3_4 + 0.00192664478378797*G0_4_4_0 - 0.00192664478378796*G0_4_4_2 - 0.00154131582703037*G0_4_4_3 + 0.00154131582703037*G0_4_4_5 + 0.000770657913515187*G0_4_5_0 - 0.000346796061081834*G0_4_5_1 - 0.000770657913515186*G0_4_5_2 + 0.00154131582703037*G0_4_5_4 + 0.00231197374054556*G0_4_5_5 + 0.000337162837162894*G0_5_0_0 - 0.000192664478378797*G0_5_0_1 + 0.000346796061081834*G0_5_0_3 + 0.000770657913515186*G0_5_0_4 + 0.00057799343513639*G0_5_0_5 - 0.000192664478378797*G0_5_1_0 + 0.000105965463108338*G0_5_1_1 + 0.000173398030540917*G0_5_1_2 - 0.000346796061081834*G0_5_1_4 - 0.000616526330812149*G0_5_1_5 + 0.000173398030540917*G0_5_2_1 - 0.000346796061081834*G0_5_2_3 - 0.000770657913515186*G0_5_2_4 - 0.000809190809190946*G0_5_2_5 + 0.000346796061081834*G0_5_3_0 - 0.000346796061081834*G0_5_3_2 - 0.000924789496218225*G0_5_3_3 + 0.000924789496218223*G0_5_3_5 + 0.000770657913515186*G0_5_4_0 - 0.000346796061081834*G0_5_4_1 - 0.000770657913515186*G0_5_4_2 + 0.00154131582703037*G0_5_4_4 + 0.00231197374054556*G0_5_4_5 + 0.00057799343513639*G0_5_5_0 - 0.000616526330812149*G0_5_5_1 - 0.000809190809190946*G0_5_5_2 + 0.000924789496218223*G0_5_5_3 + 0.00231197374054556*G0_5_5_4 + 0.00462394748109112*G0_5_5_5;
    A[47] = A[74];
    A[91] = A[19];
    A[66] = A[55] - 0.00134865134865158*G0_0_0_0 + 0.00036445697159989*G0_0_0_2 - 0.00118006993007013*G0_0_0_4 - 0.000393356643356709*G0_0_0_5 + 0.000277757956329432*G0_0_1_4 + 0.000105965463108338*G0_0_1_5 + 0.00036445697159989*G0_0_2_0 - 0.00036445697159989*G0_0_2_2 - 0.00017982017982021*G0_0_3_3 - 0.000513771942343458*G0_0_3_4 - 0.000141287284144451*G0_0_3_5 - 0.00118006993007013*G0_0_4_0 + 0.000277757956329432*G0_0_4_1 - 0.000513771942343458*G0_0_4_3 - 0.00398173255316179*G0_0_4_4 - 0.00073854716711872*G0_0_4_5 - 0.000393356643356709*G0_0_5_0 + 0.000105965463108338*G0_0_5_1 - 0.000141287284144451*G0_0_5_3 - 0.00073854716711872*G0_0_5_4 - 0.000385328956757593*G0_0_5_5 + 0.000277757956329432*G0_1_0_4 + 0.000105965463108338*G0_1_0_5 - 0.000105965463108338*G0_1_2_3 - 0.000277757956329431*G0_1_2_4 - 0.000105965463108338*G0_1_3_2 - 0.000141287284144451*G0_1_3_3 - 0.000141287284144451*G0_1_3_4 + 0.000277757956329432*G0_1_4_0 - 0.000277757956329431*G0_1_4_2 - 0.000141287284144451*G0_1_4_3 + 0.000141287284144451*G0_1_4_5 + 0.000105965463108338*G0_1_5_0 + 0.000141287284144451*G0_1_5_4 + 0.000141287284144451*G0_1_5_5 + 0.00036445697159989*G0_2_0_0 - 0.00036445697159989*G0_2_0_2 - 0.000105965463108338*G0_2_1_3 - 0.000277757956329431*G0_2_1_4 - 0.00036445697159989*G0_2_2_0 + 0.00134865134865158*G0_2_2_2 + 0.000393356643356709*G0_2_2_3 + 0.00118006993007013*G0_2_2_4 - 0.000105965463108338*G0_2_3_1 + 0.000393356643356709*G0_2_3_2 + 0.000385328956757593*G0_2_3_3 + 0.00073854716711872*G0_2_3_4 + 0.000141287284144451*G0_2_3_5 - 0.000277757956329431*G0_2_4_1 + 0.00118006993007013*G0_2_4_2 + 0.00073854716711872*G0_2_4_3 + 0.00398173255316179*G0_2_4_4 + 0.000513771942343457*G0_2_4_5 + 0.000141287284144451*G0_2_5_3 + 0.000513771942343457*G0_2_5_4 + 0.00017982017982021*G0_2_5_5 - 0.00017982017982021*G0_3_0_3 - 0.000513771942343458*G0_3_0_4 - 0.000141287284144451*G0_3_0_5 - 0.000105965463108338*G0_3_1_2 - 0.000141287284144451*G0_3_1_3 - 0.000141287284144451*G0_3_1_4 - 0.000105965463108338*G0_3_2_1 + 0.000393356643356709*G0_3_2_2 + 0.000385328956757593*G0_3_2_3 + 0.00073854716711872*G0_3_2_4 + 0.000141287284144451*G0_3_2_5 - 0.00017982017982021*G0_3_3_0 - 0.000141287284144451*G0_3_3_1 + 0.000385328956757593*G0_3_3_2 + 0.000385328956757593*G0_3_3_3 + 0.000642214927929322*G0_3_3_4 - 0.000513771942343458*G0_3_4_0 - 0.000141287284144451*G0_3_4_1 + 0.00073854716711872*G0_3_4_2 + 0.000642214927929322*G0_3_4_3 + 0.00102754388468691*G0_3_4_4 - 0.000141287284144451*G0_3_5_0 + 0.000141287284144451*G0_3_5_2 - 0.00118006993007013*G0_4_0_0 + 0.000277757956329432*G0_4_0_1 - 0.000513771942343458*G0_4_0_3 - 0.00398173255316179*G0_4_0_4 - 0.00073854716711872*G0_4_0_5 + 0.000277757956329432*G0_4_1_0 - 0.000277757956329431*G0_4_1_2 - 0.000141287284144451*G0_4_1_3 + 0.000141287284144451*G0_4_1_5 - 0.000277757956329431*G0_4_2_1 + 0.00118006993007013*G0_4_2_2 + 0.00073854716711872*G0_4_2_3 + 0.00398173255316179*G0_4_2_4 + 0.000513771942343457*G0_4_2_5 - 0.000513771942343458*G0_4_3_0 - 0.000141287284144451*G0_4_3_1 + 0.00073854716711872*G0_4_3_2 + 0.000642214927929322*G0_4_3_3 + 0.00102754388468691*G0_4_3_4 - 0.00398173255316179*G0_4_4_0 + 0.00398173255316179*G0_4_4_2 + 0.00102754388468691*G0_4_4_3 - 0.00102754388468691*G0_4_4_5 - 0.00073854716711872*G0_4_5_0 + 0.000141287284144451*G0_4_5_1 + 0.000513771942343457*G0_4_5_2 - 0.00102754388468691*G0_4_5_4 - 0.000642214927929321*G0_4_5_5 - 0.000393356643356709*G0_5_0_0 + 0.000105965463108338*G0_5_0_1 - 0.000141287284144451*G0_5_0_3 - 0.00073854716711872*G0_5_0_4 - 0.000385328956757593*G0_5_0_5 + 0.000105965463108338*G0_5_1_0 + 0.000141287284144451*G0_5_1_4 + 0.000141287284144451*G0_5_1_5 + 0.000141287284144451*G0_5_2_3 + 0.000513771942343457*G0_5_2_4 + 0.00017982017982021*G0_5_2_5 - 0.000141287284144451*G0_5_3_0 + 0.000141287284144451*G0_5_3_2 - 0.00073854716711872*G0_5_4_0 + 0.000141287284144451*G0_5_4_1 + 0.000513771942343457*G0_5_4_2 - 0.00102754388468691*G0_5_4_4 - 0.000642214927929321*G0_5_4_5 - 0.000385328956757593*G0_5_5_0 + 0.000141287284144451*G0_5_5_1 + 0.00017982017982021*G0_5_5_2 - 0.000642214927929321*G0_5_5_4 - 0.000385328956757592*G0_5_5_5;
    A[56] = A[65];
    A[77] = A[55] - 0.000168581418581447*G0_0_0_1 + 0.000168581418581447*G0_0_0_2 - 0.00108641358641377*G0_0_0_4 + 0.00108641358641377*G0_0_0_5 - 0.000168581418581447*G0_0_1_0 - 0.000442057942058016*G0_0_1_5 + 0.000168581418581447*G0_0_2_0 + 0.000442057942058017*G0_0_2_4 - 0.00108641358641377*G0_0_4_0 + 0.000442057942058017*G0_0_4_2 - 0.00224775224775262*G0_0_4_4 + 0.00108641358641377*G0_0_5_0 - 0.000442057942058016*G0_0_5_1 + 0.00224775224775263*G0_0_5_5 - 0.000168581418581447*G0_1_0_0 - 0.000442057942058016*G0_1_0_5 + 0.000242436135293319*G0_1_1_1 + 0.000103824746681907*G0_1_1_3 + 0.000377836449265084*G0_1_1_5 + 0.000103824746681907*G0_1_3_1 + 0.000188383045525935*G0_1_3_3 + 0.000111317254174416*G0_1_3_4 + 0.000111317254174416*G0_1_4_3 + 0.00053946053946063*G0_1_4_4 - 0.000442057942058016*G0_1_5_0 + 0.000377836449265084*G0_1_5_1 - 0.00101898101898119*G0_1_5_5 + 0.000168581418581447*G0_2_0_0 + 0.000442057942058017*G0_2_0_4 - 0.000242436135293319*G0_2_2_2 - 0.000103824746681907*G0_2_2_3 - 0.000377836449265085*G0_2_2_4 - 0.000103824746681907*G0_2_3_2 - 0.000188383045525935*G0_2_3_3 - 0.000111317254174416*G0_2_3_5 + 0.000442057942058017*G0_2_4_0 - 0.000377836449265085*G0_2_4_2 + 0.00101898101898119*G0_2_4_4 - 0.000111317254174416*G0_2_5_3 - 0.00053946053946063*G0_2_5_5 + 0.000103824746681907*G0_3_1_1 + 0.000188383045525935*G0_3_1_3 + 0.000111317254174416*G0_3_1_4 - 0.000103824746681907*G0_3_2_2 - 0.000188383045525935*G0_3_2_3 - 0.000111317254174416*G0_3_2_5 + 0.000188383045525935*G0_3_3_1 - 0.000188383045525935*G0_3_3_2 - 0.000222634508348832*G0_3_3_4 + 0.000222634508348832*G0_3_3_5 + 0.000111317254174416*G0_3_4_1 - 0.000222634508348832*G0_3_4_3 - 0.000959040959041122*G0_3_4_4 - 0.000111317254174416*G0_3_5_2 + 0.000222634508348832*G0_3_5_3 + 0.00095904095904112*G0_3_5_5 - 0.00108641358641377*G0_4_0_0 + 0.000442057942058017*G0_4_0_2 - 0.00224775224775262*G0_4_0_4 + 0.000111317254174416*G0_4_1_3 + 0.00053946053946063*G0_4_1_4 + 0.000442057942058017*G0_4_2_0 - 0.000377836449265085*G0_4_2_2 + 0.00101898101898119*G0_4_2_4 + 0.000111317254174416*G0_4_3_1 - 0.000222634508348832*G0_4_3_3 - 0.000959040959041122*G0_4_3_4 - 0.00224775224775262*G0_4_4_0 + 0.00053946053946063*G0_4_4_1 + 0.00101898101898119*G0_4_4_2 - 0.000959040959041122*G0_4_4_3 - 0.0107892107892126*G0_4_4_4 - 0.0011988011988014*G0_4_4_5 - 0.0011988011988014*G0_4_5_4 + 0.0011988011988014*G0_4_5_5 + 0.00108641358641377*G0_5_0_0 - 0.000442057942058016*G0_5_0_1 + 0.00224775224775263*G0_5_0_5 - 0.000442057942058016*G0_5_1_0 + 0.000377836449265084*G0_5_1_1 - 0.00101898101898119*G0_5_1_5 - 0.000111317254174416*G0_5_2_3 - 0.00053946053946063*G0_5_2_5 - 0.000111317254174416*G0_5_3_2 + 0.000222634508348832*G0_5_3_3 + 0.00095904095904112*G0_5_3_5 - 0.0011988011988014*G0_5_4_4 + 0.0011988011988014*G0_5_4_5 + 0.00224775224775263*G0_5_5_0 - 0.00101898101898119*G0_5_5_1 - 0.00053946053946063*G0_5_5_2 + 0.00095904095904112*G0_5_5_3 + 0.0011988011988014*G0_5_5_4 + 0.0107892107892126*G0_5_5_5;
    A[3] = A[30];
    A[12] = A[21];
    A[49] = A[94];
    A[33] = A[55] - 0.0015910874839449*G0_0_0_0 + 0.00017152490366779*G0_0_0_1 + 0.000302376195233389*G0_0_0_2 - 0.00158359497645239*G0_0_0_4 - 0.000471492792921443*G0_0_0_5 + 0.00017152490366779*G0_0_1_0 - 0.00017152490366779*G0_0_1_1 - 0.000173933209647525*G0_0_1_3 + 0.000173933209647525*G0_0_1_4 + 0.000302376195233389*G0_0_2_0 - 0.000101148851148868*G0_0_2_2 + 0.000156272299129468*G0_0_2_3 + 0.000548023405166355*G0_0_2_4 + 0.000214606821749715*G0_0_2_5 - 0.000173933209647525*G0_0_3_1 + 0.000156272299129468*G0_0_3_2 - 0.000719280719280841*G0_0_3_3 - 0.000312544598258937*G0_0_3_4 - 0.000393891822463317*G0_0_3_5 - 0.00158359497645239*G0_0_4_0 + 0.000173933209647525*G0_0_4_1 + 0.000548023405166355*G0_0_4_2 - 0.000312544598258937*G0_0_4_3 - 0.00282146425003615*G0_0_4_4 - 0.000777080062794479*G0_0_4_5 - 0.000471492792921443*G0_0_5_0 + 0.000214606821749715*G0_0_5_2 - 0.000393891822463317*G0_0_5_3 - 0.000777080062794479*G0_0_5_4 - 0.000714999286427978*G0_0_5_5 + 0.00017152490366779*G0_1_0_0 - 0.00017152490366779*G0_1_0_1 - 0.000173933209647525*G0_1_0_3 + 0.000173933209647525*G0_1_0_4 - 0.00017152490366779*G0_1_1_0 + 0.0015910874839449*G0_1_1_1 - 0.00030237619523339*G0_1_1_2 + 0.00158359497645239*G0_1_1_3 + 0.000471492792921444*G0_1_1_5 - 0.00030237619523339*G0_1_2_1 + 0.000101148851148868*G0_1_2_2 - 0.000548023405166355*G0_1_2_3 - 0.000156272299129468*G0_1_2_4 - 0.000214606821749715*G0_1_2_5 - 0.000173933209647525*G0_1_3_0 + 0.00158359497645239*G0_1_3_1 - 0.000548023405166355*G0_1_3_2 + 0.00282146425003616*G0_1_3_3 + 0.000312544598258937*G0_1_3_4 + 0.00077708006279448*G0_1_3_5 + 0.000173933209647525*G0_1_4_0 - 0.000156272299129468*G0_1_4_2 + 0.000312544598258937*G0_1_4_3 + 0.00071928071928084*G0_1_4_4 + 0.000393891822463317*G0_1_4_5 + 0.000471492792921444*G0_1_5_1 - 0.000214606821749715*G0_1_5_2 + 0.00077708006279448*G0_1_5_3 + 0.000393891822463317*G0_1_5_4 + 0.000714999286427978*G0_1_5_5 + 0.000302376195233389*G0_2_0_0 - 0.000101148851148868*G0_2_0_2 + 0.000156272299129468*G0_2_0_3 + 0.000548023405166355*G0_2_0_4 + 0.000214606821749715*G0_2_0_5 - 0.00030237619523339*G0_2_1_1 + 0.000101148851148868*G0_2_1_2 - 0.000548023405166355*G0_2_1_3 - 0.000156272299129468*G0_2_1_4 - 0.000214606821749715*G0_2_1_5 - 0.000101148851148868*G0_2_2_0 + 0.000101148851148868*G0_2_2_1 + 0.00029970029970035*G0_2_2_3 - 0.00029970029970035*G0_2_2_4 + 0.000156272299129468*G0_2_3_0 - 0.000548023405166355*G0_2_3_1 + 0.00029970029970035*G0_2_3_2 - 0.00134865134865158*G0_2_3_3 - 0.000312544598258937*G0_2_3_5 + 0.000548023405166355*G0_2_4_0 - 0.000156272299129468*G0_2_4_1 - 0.00029970029970035*G0_2_4_2 + 0.00134865134865158*G0_2_4_4 + 0.000312544598258937*G0_2_4_5 + 0.000214606821749715*G0_2_5_0 - 0.000214606821749715*G0_2_5_1 - 0.000312544598258937*G0_2_5_3 + 0.000312544598258937*G0_2_5_4 - 0.000173933209647525*G0_3_0_1 + 0.000156272299129468*G0_3_0_2 - 0.000719280719280841*G0_3_0_3 - 0.000312544598258937*G0_3_0_4 - 0.000393891822463317*G0_3_0_5 - 0.000173933209647525*G0_3_1_0 + 0.00158359497645239*G0_3_1_1 - 0.000548023405166355*G0_3_1_2 + 0.00282146425003616*G0_3_1_3 + 0.000312544598258937*G0_3_1_4 + 0.00077708006279448*G0_3_1_5 + 0.000156272299129468*G0_3_2_0 - 0.000548023405166355*G0_3_2_1 + 0.00029970029970035*G0_3_2_2 - 0.00134865134865158*G0_3_2_3 - 0.000312544598258937*G0_3_2_5 - 0.000719280719280841*G0_3_3_0 + 0.00282146425003616*G0_3_3_1 - 0.00134865134865158*G0_3_3_2 + 0.0111745397459702*G0_3_3_3 + 0.000813472242043807*G0_3_3_4 + 0.00206365063507955*G0_3_3_5 - 0.000312544598258937*G0_3_4_0 + 0.000312544598258937*G0_3_4_1 + 0.000813472242043807*G0_3_4_3 - 0.000813472242043809*G0_3_4_4 - 0.000393891822463317*G0_3_5_0 + 0.00077708006279448*G0_3_5_1 - 0.000312544598258937*G0_3_5_2 + 0.00206365063507955*G0_3_5_3 + 0.000787783644926634*G0_3_5_5 - 0.00158359497645239*G0_4_0_0 + 0.000173933209647525*G0_4_0_1 + 0.000548023405166355*G0_4_0_2 - 0.000312544598258937*G0_4_0_3 - 0.00282146425003615*G0_4_0_4 - 0.000777080062794479*G0_4_0_5 + 0.000173933209647525*G0_4_1_0 - 0.000156272299129468*G0_4_1_2 + 0.000312544598258937*G0_4_1_3 + 0.00071928071928084*G0_4_1_4 + 0.000393891822463317*G0_4_1_5 + 0.000548023405166355*G0_4_2_0 - 0.000156272299129468*G0_4_2_1 - 0.00029970029970035*G0_4_2_2 + 0.00134865134865158*G0_4_2_4 + 0.000312544598258937*G0_4_2_5 - 0.000312544598258937*G0_4_3_0 + 0.000312544598258937*G0_4_3_1 + 0.000813472242043807*G0_4_3_3 - 0.000813472242043809*G0_4_3_4 - 0.00282146425003615*G0_4_4_0 + 0.00071928071928084*G0_4_4_1 + 0.00134865134865158*G0_4_4_2 - 0.000813472242043809*G0_4_4_3 - 0.0111745397459702*G0_4_4_4 - 0.00206365063507955*G0_4_4_5 - 0.000777080062794479*G0_4_5_0 + 0.000393891822463317*G0_4_5_1 + 0.000312544598258937*G0_4_5_2 - 0.00206365063507955*G0_4_5_4 - 0.000787783644926634*G0_4_5_5 - 0.000471492792921443*G0_5_0_0 + 0.000214606821749715*G0_5_0_2 - 0.000393891822463317*G0_5_0_3 - 0.000777080062794479*G0_5_0_4 - 0.000714999286427978*G0_5_0_5 + 0.000471492792921444*G0_5_1_1 - 0.000214606821749715*G0_5_1_2 + 0.00077708006279448*G0_5_1_3 + 0.000393891822463317*G0_5_1_4 + 0.000714999286427978*G0_5_1_5 + 0.000214606821749715*G0_5_2_0 - 0.000214606821749715*G0_5_2_1 - 0.000312544598258937*G0_5_2_3 + 0.000312544598258937*G0_5_2_4 - 0.000393891822463317*G0_5_3_0 + 0.00077708006279448*G0_5_3_1 - 0.000312544598258937*G0_5_3_2 + 0.00206365063507955*G0_5_3_3 + 0.000787783644926635*G0_5_3_5 - 0.000777080062794479*G0_5_4_0 + 0.000393891822463317*G0_5_4_1 + 0.000312544598258937*G0_5_4_2 - 0.00206365063507955*G0_5_4_4 - 0.000787783644926634*G0_5_4_5 - 0.000714999286427978*G0_5_5_0 + 0.000714999286427978*G0_5_5_1 + 0.000787783644926634*G0_5_5_3 - 0.000787783644926634*G0_5_5_4;
    A[29] = A[92];
    A[81] = A[31] - 0.000228937728937768*G0_1_1_3 + 0.000228937728937768*G0_1_1_5 - 0.000228937728937768*G0_1_3_1 - 0.000233100233100273*G0_1_3_3 + 0.000228937728937767*G0_1_5_1 + 0.000233100233100272*G0_1_5_5 - 0.000228937728937768*G0_3_1_1 - 0.000233100233100273*G0_3_1_3 - 0.000233100233100273*G0_3_3_1 + 0.000299700299700349*G0_3_3_3 + 0.000228937728937768*G0_5_1_1 + 0.000233100233100272*G0_5_1_5 + 0.000233100233100272*G0_5_5_1 - 0.000299700299700351*G0_5_5_5;
    A[44] = A[66] - 0.000242436135293319*G0_0_0_0 - 0.000377836449265085*G0_0_0_4 - 0.000103824746681907*G0_0_0_5 + 0.000168581418581447*G0_0_2_2 + 0.000442057942058017*G0_0_2_4 - 0.00053946053946063*G0_0_3_3 - 0.000111317254174416*G0_0_3_5 - 0.000377836449265085*G0_0_4_0 + 0.000442057942058017*G0_0_4_2 + 0.00101898101898119*G0_0_4_4 - 0.000103824746681907*G0_0_5_0 - 0.000111317254174416*G0_0_5_3 - 0.000188383045525934*G0_0_5_5 + 0.000242436135293319*G0_1_1_1 + 0.000377836449265084*G0_1_1_3 + 0.000103824746681907*G0_1_1_5 - 0.000168581418581447*G0_1_2_2 - 0.000442057942058016*G0_1_2_3 + 0.000377836449265084*G0_1_3_1 - 0.000442057942058016*G0_1_3_2 - 0.00101898101898119*G0_1_3_3 + 0.00053946053946063*G0_1_4_4 + 0.000111317254174416*G0_1_4_5 + 0.000103824746681907*G0_1_5_1 + 0.000111317254174416*G0_1_5_4 + 0.000188383045525934*G0_1_5_5 + 0.000168581418581447*G0_2_0_2 + 0.000442057942058017*G0_2_0_4 - 0.000168581418581447*G0_2_1_2 - 0.000442057942058016*G0_2_1_3 + 0.000168581418581447*G0_2_2_0 - 0.000168581418581447*G0_2_2_1 + 0.00108641358641377*G0_2_2_3 - 0.00108641358641377*G0_2_2_4 - 0.000442057942058016*G0_2_3_1 + 0.00108641358641377*G0_2_3_2 + 0.00224775224775263*G0_2_3_3 + 0.000442057942058017*G0_2_4_0 - 0.00108641358641377*G0_2_4_2 - 0.00224775224775263*G0_2_4_4 - 0.00053946053946063*G0_3_0_3 - 0.000111317254174416*G0_3_0_5 + 0.000377836449265084*G0_3_1_1 - 0.000442057942058016*G0_3_1_2 - 0.00101898101898119*G0_3_1_3 - 0.000442057942058016*G0_3_2_1 + 0.00108641358641377*G0_3_2_2 + 0.00224775224775263*G0_3_2_3 - 0.00053946053946063*G0_3_3_0 - 0.00101898101898119*G0_3_3_1 + 0.00224775224775263*G0_3_3_2 + 0.0107892107892126*G0_3_3_3 + 0.0011988011988014*G0_3_3_4 + 0.000959040959041121*G0_3_3_5 + 0.0011988011988014*G0_3_4_3 - 0.0011988011988014*G0_3_4_4 - 0.000111317254174416*G0_3_5_0 + 0.000959040959041121*G0_3_5_3 + 0.000222634508348832*G0_3_5_5 - 0.000377836449265085*G0_4_0_0 + 0.000442057942058017*G0_4_0_2 + 0.00101898101898119*G0_4_0_4 + 0.00053946053946063*G0_4_1_4 + 0.000111317254174416*G0_4_1_5 + 0.000442057942058017*G0_4_2_0 - 0.00108641358641377*G0_4_2_2 - 0.00224775224775263*G0_4_2_4 + 0.0011988011988014*G0_4_3_3 - 0.0011988011988014*G0_4_3_4 + 0.00101898101898119*G0_4_4_0 + 0.00053946053946063*G0_4_4_1 - 0.00224775224775263*G0_4_4_2 - 0.0011988011988014*G0_4_4_3 - 0.0107892107892126*G0_4_4_4 - 0.000959040959041121*G0_4_4_5 + 0.000111317254174416*G0_4_5_1 - 0.000959040959041121*G0_4_5_4 - 0.000222634508348832*G0_4_5_5 - 0.000103824746681907*G0_5_0_0 - 0.000111317254174416*G0_5_0_3 - 0.000188383045525934*G0_5_0_5 + 0.000103824746681907*G0_5_1_1 + 0.000111317254174416*G0_5_1_4 + 0.000188383045525934*G0_5_1_5 - 0.000111317254174416*G0_5_3_0 + 0.000959040959041121*G0_5_3_3 + 0.000222634508348832*G0_5_3_5 + 0.000111317254174416*G0_5_4_1 - 0.000959040959041121*G0_5_4_4 - 0.000222634508348832*G0_5_4_5 - 0.000188383045525934*G0_5_5_0 + 0.000188383045525934*G0_5_5_1 + 0.000222634508348832*G0_5_5_3 - 0.000222634508348832*G0_5_5_4;
    A[63] = A[36];
    A[0] = A[1] + 0.00177461427461458*G0_0_0_0 + 0.000342759092759152*G0_0_0_4 + 0.000326710326710382*G0_0_0_5 + 0.000342759092759152*G0_0_4_0 + 0.000140045140045164*G0_0_4_4 + 0.000326710326710382*G0_0_5_0 + 0.00012839012839015*G0_0_5_5 + 0.000148740148740174*G0_3_3_3 + 0.000342759092759152*G0_4_0_0 + 0.000140045140045164*G0_4_0_4 + 0.000140045140045164*G0_4_4_0 + 0.000242931671503141*G0_4_4_4 + 0.000326710326710382*G0_5_0_0 + 0.00012839012839015*G0_5_0_5 + 0.00012839012839015*G0_5_5_0 + 0.000127808699237292*G0_5_5_5;
    A[79] = A[97];
    A[38] = A[83];
    A[20] = A[2];
    A[18] = A[81];
    A[88] = A[66] + 0.000101148851148868*G0_0_0_1 - 0.000101148851148868*G0_0_0_2 - 0.000299700299700351*G0_0_0_4 + 0.00029970029970035*G0_0_0_5 + 0.000101148851148868*G0_0_1_0 - 0.000302376195233389*G0_0_1_1 - 0.000214606821749715*G0_0_1_3 - 0.000156272299129468*G0_0_1_4 - 0.000548023405166355*G0_0_1_5 - 0.000101148851148868*G0_0_2_0 + 0.000302376195233389*G0_0_2_2 + 0.000214606821749715*G0_0_2_3 + 0.000548023405166355*G0_0_2_4 + 0.000156272299129468*G0_0_2_5 - 0.000214606821749715*G0_0_3_1 + 0.000214606821749715*G0_0_3_2 + 0.000312544598258937*G0_0_3_4 - 0.000312544598258937*G0_0_3_5 - 0.000299700299700351*G0_0_4_0 - 0.000156272299129468*G0_0_4_1 + 0.000548023405166355*G0_0_4_2 + 0.000312544598258937*G0_0_4_3 + 0.00134865134865157*G0_0_4_4 + 0.00029970029970035*G0_0_5_0 - 0.000548023405166355*G0_0_5_1 + 0.000156272299129468*G0_0_5_2 - 0.000312544598258937*G0_0_5_3 - 0.00134865134865158*G0_0_5_5 + 0.000101148851148868*G0_1_0_0 - 0.000302376195233389*G0_1_0_1 - 0.000214606821749715*G0_1_0_3 - 0.000156272299129468*G0_1_0_4 - 0.000548023405166355*G0_1_0_5 - 0.000302376195233389*G0_1_1_0 + 0.0015910874839449*G0_1_1_1 - 0.00017152490366779*G0_1_1_2 + 0.000471492792921444*G0_1_1_3 + 0.00158359497645239*G0_1_1_5 - 0.00017152490366779*G0_1_2_1 + 0.000171524903667789*G0_1_2_2 + 0.000173933209647524*G0_1_2_4 - 0.000173933209647525*G0_1_2_5 - 0.000214606821749715*G0_1_3_0 + 0.000471492792921444*G0_1_3_1 + 0.000714999286427978*G0_1_3_3 + 0.000393891822463317*G0_1_3_4 + 0.000777080062794479*G0_1_3_5 - 0.000156272299129468*G0_1_4_0 + 0.000173933209647524*G0_1_4_2 + 0.000393891822463317*G0_1_4_3 + 0.00071928071928084*G0_1_4_4 + 0.000312544598258936*G0_1_4_5 - 0.000548023405166355*G0_1_5_0 + 0.00158359497645239*G0_1_5_1 - 0.000173933209647525*G0_1_5_2 + 0.000777080062794479*G0_1_5_3 + 0.000312544598258936*G0_1_5_4 + 0.00282146425003616*G0_1_5_5 - 0.000101148851148868*G0_2_0_0 + 0.000302376195233389*G0_2_0_2 + 0.000214606821749715*G0_2_0_3 + 0.000548023405166355*G0_2_0_4 + 0.000156272299129468*G0_2_0_5 - 0.00017152490366779*G0_2_1_1 + 0.000171524903667789*G0_2_1_2 + 0.000173933209647524*G0_2_1_4 - 0.000173933209647525*G0_2_1_5 + 0.000302376195233389*G0_2_2_0 + 0.000171524903667789*G0_2_2_1 - 0.00159108748394489*G0_2_2_2 - 0.000471492792921443*G0_2_2_3 - 0.00158359497645239*G0_2_2_4 + 0.000214606821749715*G0_2_3_0 - 0.000471492792921443*G0_2_3_2 - 0.000714999286427978*G0_2_3_3 - 0.000777080062794479*G0_2_3_4 - 0.000393891822463318*G0_2_3_5 + 0.000548023405166355*G0_2_4_0 + 0.000173933209647524*G0_2_4_1 - 0.00158359497645239*G0_2_4_2 - 0.000777080062794479*G0_2_4_3 - 0.00282146425003615*G0_2_4_4 - 0.000312544598258936*G0_2_4_5 + 0.000156272299129468*G0_2_5_0 - 0.000173933209647525*G0_2_5_1 - 0.000393891822463318*G0_2_5_3 - 0.000312544598258937*G0_2_5_4 - 0.000719280719280841*G0_2_5_5 - 0.000214606821749715*G0_3_0_1 + 0.000214606821749715*G0_3_0_2 + 0.000312544598258937*G0_3_0_4 - 0.000312544598258937*G0_3_0_5 - 0.000214606821749715*G0_3_1_0 + 0.000471492792921444*G0_3_1_1 + 0.000714999286427978*G0_3_1_3 + 0.000393891822463317*G0_3_1_4 + 0.000777080062794479*G0_3_1_5 + 0.000214606821749715*G0_3_2_0 - 0.000471492792921443*G0_3_2_2 - 0.000714999286427978*G0_3_2_3 - 0.000777080062794479*G0_3_2_4 - 0.000393891822463318*G0_3_2_5 + 0.000714999286427978*G0_3_3_1 - 0.000714999286427978*G0_3_3_2 - 0.000787783644926635*G0_3_3_4 + 0.000787783644926635*G0_3_3_5 + 0.000312544598258937*G0_3_4_0 + 0.000393891822463317*G0_3_4_1 - 0.000777080062794479*G0_3_4_2 - 0.000787783644926635*G0_3_4_3 - 0.00206365063507955*G0_3_4_4 - 0.000312544598258937*G0_3_5_0 + 0.000777080062794479*G0_3_5_1 - 0.000393891822463318*G0_3_5_2 + 0.000787783644926635*G0_3_5_3 + 0.00206365063507956*G0_3_5_5 - 0.000299700299700351*G0_4_0_0 - 0.000156272299129468*G0_4_0_1 + 0.000548023405166355*G0_4_0_2 + 0.000312544598258937*G0_4_0_3 + 0.00134865134865157*G0_4_0_4 - 0.000156272299129468*G0_4_1_0 + 0.000173933209647524*G0_4_1_2 + 0.000393891822463317*G0_4_1_3 + 0.00071928071928084*G0_4_1_4 + 0.000312544598258936*G0_4_1_5 + 0.000548023405166355*G0_4_2_0 + 0.000173933209647524*G0_4_2_1 - 0.00158359497645239*G0_4_2_2 - 0.000777080062794479*G0_4_2_3 - 0.00282146425003615*G0_4_2_4 - 0.000312544598258937*G0_4_2_5 + 0.000312544598258937*G0_4_3_0 + 0.000393891822463317*G0_4_3_1 - 0.000777080062794479*G0_4_3_2 - 0.000787783644926635*G0_4_3_3 - 0.00206365063507955*G0_4_3_4 + 0.00134865134865157*G0_4_4_0 + 0.00071928071928084*G0_4_4_1 - 0.00282146425003615*G0_4_4_2 - 0.00206365063507955*G0_4_4_3 - 0.0111745397459702*G0_4_4_4 - 0.000813472242043808*G0_4_4_5 + 0.000312544598258936*G0_4_5_1 - 0.000312544598258936*G0_4_5_2 - 0.000813472242043808*G0_4_5_4 + 0.000813472242043807*G0_4_5_5 + 0.00029970029970035*G0_5_0_0 - 0.000548023405166355*G0_5_0_1 + 0.000156272299129468*G0_5_0_2 - 0.000312544598258937*G0_5_0_3 - 0.00134865134865158*G0_5_0_5 - 0.000548023405166355*G0_5_1_0 + 0.00158359497645239*G0_5_1_1 - 0.000173933209647525*G0_5_1_2 + 0.000777080062794479*G0_5_1_3 + 0.000312544598258936*G0_5_1_4 + 0.00282146425003616*G0_5_1_5 + 0.000156272299129468*G0_5_2_0 - 0.000173933209647525*G0_5_2_1 - 0.000393891822463318*G0_5_2_3 - 0.000312544598258936*G0_5_2_4 - 0.000719280719280841*G0_5_2_5 - 0.000312544598258937*G0_5_3_0 + 0.000777080062794479*G0_5_3_1 - 0.000393891822463318*G0_5_3_2 + 0.000787783644926635*G0_5_3_3 + 0.00206365063507956*G0_5_3_5 + 0.000312544598258936*G0_5_4_1 - 0.000312544598258937*G0_5_4_2 - 0.000813472242043808*G0_5_4_4 + 0.000813472242043807*G0_5_4_5 - 0.00134865134865158*G0_5_5_0 + 0.00282146425003616*G0_5_5_1 - 0.000719280719280841*G0_5_5_2 + 0.00206365063507956*G0_5_5_3 + 0.000813472242043807*G0_5_5_4 + 0.0111745397459702*G0_5_5_5;
    A[43] = A[34];
    A[95] = A[59];
    A[52] = A[25];
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class mass_matrix_f3_p2_q3_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  mass_matrix_f3_p2_q3_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f3_p2_q3_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Product(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1)), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 2), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1)))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 3;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f3_p2_q3_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new mass_matrix_f3_p2_q3_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new mass_matrix_f3_p2_q3_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new mass_matrix_f3_p2_q3_tensor_finite_element_0();
        break;
      }
    case 4:
      {
        return new mass_matrix_f3_p2_q3_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f3_p2_q3_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new mass_matrix_f3_p2_q3_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new mass_matrix_f3_p2_q3_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new mass_matrix_f3_p2_q3_tensor_dofmap_0();
        break;
      }
    case 4:
      {
        return new mass_matrix_f3_p2_q3_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f3_p2_q3_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
