// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __VECTOR_LAPLACIAN_F1_P2_Q4_TENSOR_H
#define __VECTOR_LAPLACIAN_F1_P2_Q4_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p2_q4_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p2_q4_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p2_q4_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('triangle', Space(2)), 2, 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 12;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 9:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 11:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[1];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[1];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[10] = vals[1];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[1];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[6];
    vertex_values[3] = dof_values[7];
    vertex_values[5] = dof_values[8];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 2;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p2_q4_tensor_finite_element_0();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p2_q4_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p2_q4_tensor_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p2_q4_tensor_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p2_q4_tensor_finite_element_2();
  }

};

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p2_q4_tensor_finite_element_3: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_finite_element_3() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_finite_element_3()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('triangle', Space(2)), 4, 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 30;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 16:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 17:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 18:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 19:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 20:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 21:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 22:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 23:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 24:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 25:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 26:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 27:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 28:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 29:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[15] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[16] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[17] = vals[1];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[18] = vals[1];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[19] = vals[1];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[20] = vals[1];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[21] = vals[1];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[22] = vals[1];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[23] = vals[1];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[24] = vals[1];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[25] = vals[1];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[26] = vals[1];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[27] = vals[1];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[28] = vals[1];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[29] = vals[1];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[15];
    vertex_values[3] = dof_values[16];
    vertex_values[5] = dof_values[17];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 2;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p2_q4_tensor_finite_element_2();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p2_q4_tensor_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p2_q4_tensor_finite_element_3();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vector_laplacian_f1_p2_q4_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vector_laplacian_f1_p2_q4_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vector_laplacian_f1_p2_q4_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Cell('triangle', Space(2)), 2, 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 2*m.num_entities[0] + 2*m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 12;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 12;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 6;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
    dofs[6] = offset + c.entity_indices[0][0];
    dofs[7] = offset + c.entity_indices[0][1];
    dofs[8] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[9] = offset + c.entity_indices[1][0];
    dofs[10] = offset + c.entity_indices[1][1];
    dofs[11] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 7;
      dofs[4] = 8;
      dofs[5] = 9;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 10;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
      dofs[3] = 6;
      dofs[4] = 7;
      dofs[5] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 7;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 9;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
        dofs[1] = 10;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
        dofs[1] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[6][0] = x[0][0];
    coordinates[6][1] = x[0][1];
    coordinates[7][0] = x[1][0];
    coordinates[7][1] = x[1][1];
    coordinates[8][0] = x[2][0];
    coordinates[8][1] = x[2][1];
    coordinates[9][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[9][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[11][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[11][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 2;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p2_q4_tensor_dofmap_0();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p2_q4_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vector_laplacian_f1_p2_q4_tensor_dofmap_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vector_laplacian_f1_p2_q4_tensor_dofmap_2: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_dofmap_2() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_dofmap_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3*m.num_entities[1] + 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vector_laplacian_f1_p2_q4_tensor_dofmap_2();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vector_laplacian_f1_p2_q4_tensor_dofmap_3: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_dofmap_3() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_dofmap_3()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Cell('triangle', Space(2)), 4, 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 2*m.num_entities[0] + 6*m.num_entities[1] + 6*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 30;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 30;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 10;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 6;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
    dofs[15] = offset + c.entity_indices[0][0];
    dofs[16] = offset + c.entity_indices[0][1];
    dofs[17] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[18] = offset + 3*c.entity_indices[1][0];
    dofs[19] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[20] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[21] = offset + 3*c.entity_indices[1][1];
    dofs[22] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[23] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[24] = offset + 3*c.entity_indices[1][2];
    dofs[25] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[26] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[27] = offset + 3*c.entity_indices[2][0];
    dofs[28] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[29] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 16;
      dofs[6] = 17;
      dofs[7] = 18;
      dofs[8] = 19;
      dofs[9] = 20;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
      dofs[5] = 15;
      dofs[6] = 17;
      dofs[7] = 21;
      dofs[8] = 22;
      dofs[9] = 23;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
      dofs[5] = 15;
      dofs[6] = 16;
      dofs[7] = 24;
      dofs[8] = 25;
      dofs[9] = 26;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 15;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 16;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 17;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
        dofs[3] = 18;
        dofs[4] = 19;
        dofs[5] = 20;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
        dofs[3] = 21;
        dofs[4] = 22;
        dofs[5] = 23;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
        dofs[3] = 24;
        dofs[4] = 25;
        dofs[5] = 26;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
      dofs[3] = 27;
      dofs[4] = 28;
      dofs[5] = 29;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    coordinates[15][0] = x[0][0];
    coordinates[15][1] = x[0][1];
    coordinates[16][0] = x[1][0];
    coordinates[16][1] = x[1][1];
    coordinates[17][0] = x[2][0];
    coordinates[17][1] = x[2][1];
    coordinates[18][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[18][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[19][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[19][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[20][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[20][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[21][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[21][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[22][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[22][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[23][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[23][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[24][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[24][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[25][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[25][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[26][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[26][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[27][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[27][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[28][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[28][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[29][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[29][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 2;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p2_q4_tensor_dofmap_2();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p2_q4_tensor_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vector_laplacian_f1_p2_q4_tensor_dofmap_3();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class vector_laplacian_f1_p2_q4_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  vector_laplacian_f1_p2_q4_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p2_q4_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    240
    // Number of operations (multiply-add pairs) for tensor contraction: 9723
    // Total number of operations (multiply-add pairs):                  9974
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0_0 = det*(w[0][0]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_1 = det*(w[0][0]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_0 = det*(w[0][1]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_1 = det*(w[0][2]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_0 = det*(w[0][3]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_1 = det*(w[0][3]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_0 = det*(w[0][4]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_1 = det*(w[0][4]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_0 = det*(w[0][5]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_1 = det*(w[0][5]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_1_0 = det*(w[0][6]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_1_1 = det*(w[0][6]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_1_0 = det*(w[0][7]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_1_1 = det*(w[0][8]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_1_0 = det*(w[0][9]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_1_1 = det*(w[0][9]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_10_1_0 = det*(w[0][10]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_10_1_1 = det*(w[0][10]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_11_1_0 = det*(w[0][11]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_11_1_1 = det*(w[0][11]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0_0 = det*(w[0][0]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_1 = det*(w[0][0]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_0 = det*(w[0][1]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_1 = det*(w[0][2]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_0 = det*(w[0][3]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_1 = det*(w[0][3]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_0 = det*(w[0][4]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_1 = det*(w[0][4]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_0 = det*(w[0][5]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_1 = det*(w[0][5]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_1_0 = det*(w[0][6]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_1_1 = det*(w[0][6]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_1_0 = det*(w[0][7]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_1_1 = det*(w[0][8]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_1_0 = det*(w[0][9]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_1_1 = det*(w[0][9]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_10_1_0 = det*(w[0][10]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_10_1_1 = det*(w[0][10]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_11_1_0 = det*(w[0][11]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_11_1_1 = det*(w[0][11]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0_0 = det*(w[0][0]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_1 = det*(w[0][0]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_0 = det*(w[0][1]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_1 = det*(w[0][2]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_0 = det*(w[0][3]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_1 = det*(w[0][3]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_0 = det*(w[0][4]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_1 = det*(w[0][4]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_0 = det*(w[0][5]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_1 = det*(w[0][5]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_1_0 = det*(w[0][6]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_1_1 = det*(w[0][6]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_1_0 = det*(w[0][7]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_1_1 = det*(w[0][8]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_1_0 = det*(w[0][9]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_1_1 = det*(w[0][9]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_10_1_0 = det*(w[0][10]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_10_1_1 = det*(w[0][10]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_11_1_0 = det*(w[0][11]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_11_1_1 = det*(w[0][11]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0_0 = det*(w[0][0]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_1 = det*(w[0][0]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_0 = det*(w[0][1]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_1 = det*(w[0][2]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_0 = det*(w[0][3]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_1 = det*(w[0][3]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_0 = det*(w[0][4]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_1 = det*(w[0][4]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_0 = det*(w[0][5]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_1 = det*(w[0][5]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_1_0 = det*(w[0][6]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_1_1 = det*(w[0][6]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_1_0 = det*(w[0][7]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_1_1 = det*(w[0][8]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_1_0 = det*(w[0][9]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_1_1 = det*(w[0][9]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_10_1_0 = det*(w[0][10]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_10_1_1 = det*(w[0][10]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_11_1_0 = det*(w[0][11]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_11_1_1 = det*(w[0][11]*K_11*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[213] = 0.186243386243386*G0_0_0_0_0_0 + 0.186243386243386*G0_0_0_0_0_1 + 0.22010582010582*G0_0_0_1_0_0 - 0.186243386243385*G0_0_0_2_0_1 - 0.338624338624336*G0_0_0_3_0_0 + 0.0677248677248692*G0_0_0_3_0_1 + 0.338624338624336*G0_0_0_4_0_0 - 0.406349206349206*G0_0_0_5_0_0 - 0.0677248677248692*G0_0_0_5_0_1 + 0.186243386243386*G0_0_0_6_1_0 + 0.186243386243386*G0_0_0_6_1_1 + 0.22010582010582*G0_0_0_7_1_0 - 0.186243386243385*G0_0_0_8_1_1 - 0.338624338624336*G0_0_0_9_1_0 + 0.0677248677248692*G0_0_0_9_1_1 + 0.338624338624336*G0_0_0_10_1_0 - 0.406349206349206*G0_0_0_11_1_0 - 0.0677248677248692*G0_0_0_11_1_1 + 0.0141093474426797*G0_0_1_0_0_0 + 0.0141093474426797*G0_0_1_0_0_1 - 0.00282186948853863*G0_0_1_1_0_0 - 0.0253968253968252*G0_0_1_2_0_1 - 0.0677248677248688*G0_0_1_3_0_0 - 0.0451499118165822*G0_0_1_3_0_1 + 0.0677248677248688*G0_0_1_4_0_0 + 0.0112874779541455*G0_0_1_4_0_1 - 0.0112874779541411*G0_0_1_5_0_0 + 0.0451499118165822*G0_0_1_5_0_1 + 0.0141093474426797*G0_0_1_6_1_0 + 0.0141093474426797*G0_0_1_6_1_1 - 0.00282186948853863*G0_0_1_7_1_0 - 0.0253968253968252*G0_0_1_8_1_1 - 0.0677248677248688*G0_0_1_9_1_0 - 0.0451499118165822*G0_0_1_9_1_1 + 0.0677248677248688*G0_0_1_10_1_0 + 0.0112874779541455*G0_0_1_10_1_1 - 0.0112874779541411*G0_0_1_11_1_0 + 0.0451499118165822*G0_0_1_11_1_1 - 0.0423280423280418*G0_1_0_0_0_0 - 0.0423280423280417*G0_1_0_0_0_1 + 0.00846560846560771*G0_1_0_1_0_0 - 0.0931216931216923*G0_1_0_2_0_1 - 0.135449735449735*G0_1_0_3_0_0 - 0.0338624338624351*G0_1_0_3_0_1 + 0.135449735449735*G0_1_0_4_0_0 + 0.135449735449734*G0_1_0_4_0_1 + 0.0338624338624341*G0_1_0_5_0_0 + 0.0338624338624351*G0_1_0_5_0_1 - 0.0423280423280418*G0_1_0_6_1_0 - 0.0423280423280417*G0_1_0_6_1_1 + 0.00846560846560771*G0_1_0_7_1_0 - 0.0931216931216923*G0_1_0_8_1_1 - 0.135449735449735*G0_1_0_9_1_0 - 0.0338624338624351*G0_1_0_9_1_1 + 0.135449735449735*G0_1_0_10_1_0 + 0.135449735449734*G0_1_0_10_1_1 + 0.0338624338624341*G0_1_0_11_1_0 + 0.0338624338624351*G0_1_0_11_1_1 - 0.0112874779541456*G0_1_1_0_0_0 - 0.0112874779541456*G0_1_1_0_0_1 - 0.0112874779541436*G0_1_1_2_0_1 - 0.0112874779541457*G0_1_1_3_0_0 + 0.0112874779541457*G0_1_1_4_0_0 + 0.0225749559082892*G0_1_1_4_0_1 + 0.0112874779541495*G0_1_1_5_0_0 - 0.0112874779541456*G0_1_1_6_1_0 - 0.0112874779541456*G0_1_1_6_1_1 - 0.0112874779541436*G0_1_1_8_1_1 - 0.0112874779541457*G0_1_1_9_1_0 + 0.0112874779541457*G0_1_1_10_1_0 + 0.0225749559082892*G0_1_1_10_1_1 + 0.0112874779541495*G0_1_1_11_1_0;
    A[489] = 0.0;
    A[208] = 0.0;
    A[574] = 0.0;
    A[530] = 0.595414462081129*G0_1_0_0_0_0 + 0.595414462081129*G0_1_0_0_0_1 - 0.595414462081129*G0_1_0_1_0_0 + 1.96966490299824*G0_1_0_2_0_1 + 2.74850088183421*G0_1_0_3_0_0 + 0.183421516754849*G0_1_0_3_0_1 - 2.74850088183421*G0_1_0_4_0_0 - 2.56507936507936*G0_1_0_4_0_1 - 0.18342151675485*G0_1_0_5_0_1 + 0.595414462081129*G0_1_0_6_1_0 + 0.595414462081129*G0_1_0_6_1_1 - 0.595414462081129*G0_1_0_7_1_0 + 1.96966490299824*G0_1_0_8_1_1 + 2.74850088183421*G0_1_0_9_1_0 + 0.183421516754849*G0_1_0_9_1_1 - 2.74850088183421*G0_1_0_10_1_0 - 2.56507936507936*G0_1_0_10_1_1 - 0.18342151675485*G0_1_0_11_1_1 + 0.225749559082893*G0_1_1_0_0_0 + 0.225749559082892*G0_1_1_0_0_1 - 0.324514991181658*G0_1_1_1_0_0 + 0.677248677248677*G0_1_1_2_0_1 + 0.804232804232804*G0_1_1_3_0_0 - 0.197530864197531*G0_1_1_3_0_1 - 0.804232804232804*G0_1_1_4_0_0 - 0.90299823633157*G0_1_1_4_0_1 + 0.0987654320987656*G0_1_1_5_0_0 + 0.197530864197531*G0_1_1_5_0_1 + 0.225749559082893*G0_1_1_6_1_0 + 0.225749559082892*G0_1_1_6_1_1 - 0.324514991181658*G0_1_1_7_1_0 + 0.677248677248677*G0_1_1_8_1_1 + 0.804232804232804*G0_1_1_9_1_0 - 0.197530864197531*G0_1_1_9_1_1 - 0.804232804232804*G0_1_1_10_1_0 - 0.90299823633157*G0_1_1_10_1_1 + 0.0987654320987656*G0_1_1_11_1_0 + 0.197530864197531*G0_1_1_11_1_1;
    A[235] = 0.0;
    A[607] = 0.0;
    A[716] = 0.0451499118165783*G0_0_0_0_0_0 + 0.0451499118165783*G0_0_0_0_0_1 + 0.045149911816578*G0_0_0_1_0_0 + 0.0451499118165781*G0_0_0_3_0_1 - 0.0451499118165788*G0_0_0_4_0_1 - 0.0902998236331563*G0_0_0_5_0_0 - 0.0451499118165782*G0_0_0_5_0_1 + 0.0451499118165783*G0_0_0_6_1_0 + 0.0451499118165783*G0_0_0_6_1_1 + 0.045149911816578*G0_0_0_7_1_0 + 0.0451499118165781*G0_0_0_9_1_1 - 0.0451499118165788*G0_0_0_10_1_1 - 0.0902998236331563*G0_0_0_11_1_0 - 0.0451499118165782*G0_0_0_11_1_1 + 0.0564373897707227*G0_0_1_0_0_0 + 0.0564373897707227*G0_0_1_0_0_1 + 0.0790123456790109*G0_0_1_1_0_0 + 0.0790123456790124*G0_0_1_2_0_1 + 0.180599647266313*G0_0_1_3_0_0 + 0.180599647266312*G0_0_1_3_0_1 - 0.180599647266313*G0_0_1_4_0_0 - 0.135449735449735*G0_0_1_4_0_1 - 0.135449735449734*G0_0_1_5_0_0 - 0.180599647266312*G0_0_1_5_0_1 + 0.0564373897707227*G0_0_1_6_1_0 + 0.0564373897707227*G0_0_1_6_1_1 + 0.0790123456790109*G0_0_1_7_1_0 + 0.0790123456790124*G0_0_1_8_1_1 + 0.180599647266313*G0_0_1_9_1_0 + 0.180599647266312*G0_0_1_9_1_1 - 0.180599647266313*G0_0_1_10_1_0 - 0.135449735449735*G0_0_1_10_1_1 - 0.135449735449734*G0_0_1_11_1_0 - 0.180599647266312*G0_0_1_11_1_1 - 0.0338624338624349*G0_1_0_0_0_0 - 0.033862433862435*G0_1_0_0_0_1 + 0.033862433862432*G0_1_0_1_0_0 + 0.0338624338624339*G0_1_0_2_0_1 + 0.135449735449735*G0_1_0_3_0_0 + 0.135449735449733*G0_1_0_3_0_1 - 0.135449735449735*G0_1_0_4_0_0 - 0.135449735449733*G0_1_0_5_0_1 - 0.0338624338624349*G0_1_0_6_1_0 - 0.033862433862435*G0_1_0_6_1_1 + 0.033862433862432*G0_1_0_7_1_0 + 0.0338624338624339*G0_1_0_8_1_1 + 0.135449735449735*G0_1_0_9_1_0 + 0.135449735449733*G0_1_0_9_1_1 - 0.135449735449735*G0_1_0_10_1_0 - 0.135449735449733*G0_1_0_11_1_1 + 0.0451499118165779*G0_1_1_0_0_0 + 0.0451499118165779*G0_1_1_0_0_1 + 0.0451499118165799*G0_1_1_2_0_1 + 0.0451499118165785*G0_1_1_3_0_0 - 0.0451499118165785*G0_1_1_4_0_0 - 0.0902998236331578*G0_1_1_4_0_1 - 0.0451499118165746*G0_1_1_5_0_0 + 0.0451499118165779*G0_1_1_6_1_0 + 0.0451499118165779*G0_1_1_6_1_1 + 0.0451499118165799*G0_1_1_8_1_1 + 0.0451499118165785*G0_1_1_9_1_0 - 0.0451499118165785*G0_1_1_10_1_0 - 0.0902998236331578*G0_1_1_10_1_1 - 0.0451499118165746*G0_1_1_11_1_0;
    A[625] = -A[716] + 0.0338624338624332*G0_0_0_0_0_0 + 0.0338624338624332*G0_0_0_0_0_1 + 0.0338624338624341*G0_0_0_1_0_0 + 0.0338624338624336*G0_0_0_3_0_1 - 0.0338624338624319*G0_0_0_4_0_1 - 0.0677248677248673*G0_0_0_5_0_0 - 0.0338624338624336*G0_0_0_5_0_1 + 0.0338624338624332*G0_0_0_6_1_0 + 0.0338624338624332*G0_0_0_6_1_1 + 0.0338624338624341*G0_0_0_7_1_0 + 0.0338624338624336*G0_0_0_9_1_1 - 0.0338624338624319*G0_0_0_10_1_1 - 0.0677248677248673*G0_0_0_11_1_0 - 0.0338624338624336*G0_0_0_11_1_1 + 0.0705467372134035*G0_0_1_0_0_0 + 0.0705467372134035*G0_0_1_0_0_1 + 0.0536155202821857*G0_0_1_1_0_0 + 0.0761904761904771*G0_0_1_2_0_1 + 0.135449735449736*G0_0_1_3_0_0 + 0.112874779541445*G0_0_1_3_0_1 - 0.135449735449736*G0_0_1_4_0_0 - 0.146737213403881*G0_0_1_4_0_1 - 0.124162257495589*G0_0_1_5_0_0 - 0.112874779541445*G0_0_1_5_0_1 + 0.0705467372134035*G0_0_1_6_1_0 + 0.0705467372134035*G0_0_1_6_1_1 + 0.0536155202821857*G0_0_1_7_1_0 + 0.0761904761904771*G0_0_1_8_1_1 + 0.135449735449736*G0_0_1_9_1_0 + 0.112874779541445*G0_0_1_9_1_1 - 0.135449735449736*G0_0_1_10_1_0 - 0.146737213403881*G0_0_1_10_1_1 - 0.124162257495589*G0_0_1_11_1_0 - 0.112874779541445*G0_0_1_11_1_1 - 0.0761904761904769*G0_1_0_0_0_0 - 0.0761904761904769*G0_1_0_0_0_1 - 0.0592592592592593*G0_1_0_1_0_0 + 0.042328042328041*G0_1_0_2_0_1 + 0.1015873015873*G0_1_0_3_0_0 - 0.1015873015873*G0_1_0_4_0_0 + 0.0338624338624358*G0_1_0_4_0_1 + 0.135449735449736*G0_1_0_5_0_0 - 0.0761904761904769*G0_1_0_6_1_0 - 0.0761904761904769*G0_1_0_6_1_1 - 0.0592592592592593*G0_1_0_7_1_0 + 0.042328042328041*G0_1_0_8_1_1 + 0.1015873015873*G0_1_0_9_1_0 - 0.1015873015873*G0_1_0_10_1_0 + 0.0338624338624358*G0_1_0_10_1_1 + 0.135449735449736*G0_1_0_11_1_0 + 0.231393298059965*G0_1_1_0_0_0 + 0.231393298059965*G0_1_1_0_0_1 - 0.186243386243388*G0_1_1_1_0_0 + 0.2652557319224*G0_1_1_2_0_1 + 0.112874779541447*G0_1_1_3_0_0 - 0.338624338624341*G0_1_1_3_0_1 - 0.112874779541447*G0_1_1_4_0_0 - 0.496649029982364*G0_1_1_4_0_1 - 0.0451499118165765*G0_1_1_5_0_0 + 0.338624338624341*G0_1_1_5_0_1 + 0.231393298059965*G0_1_1_6_1_0 + 0.231393298059965*G0_1_1_6_1_1 - 0.186243386243388*G0_1_1_7_1_0 + 0.2652557319224*G0_1_1_8_1_1 + 0.112874779541447*G0_1_1_9_1_0 - 0.338624338624341*G0_1_1_9_1_1 - 0.112874779541447*G0_1_1_10_1_0 - 0.496649029982364*G0_1_1_10_1_1 - 0.0451499118165765*G0_1_1_11_1_0 + 0.338624338624341*G0_1_1_11_1_1;
    A[636] = 0.0;
    A[270] = A[530] + 1.29241622574956*G0_0_0_0_0_0 + 1.29241622574956*G0_0_0_0_0_1 + 0.270899470899471*G0_0_0_1_0_0 + 0.369664902998237*G0_0_0_2_0_1 - 0.282186948853614*G0_0_0_3_0_0 - 0.38095238095238*G0_0_0_3_0_1 + 0.282186948853614*G0_0_0_4_0_0 - 1.6620811287478*G0_0_0_4_0_1 - 1.56331569664903*G0_0_0_5_0_0 + 0.380952380952381*G0_0_0_5_0_1 + 1.29241622574956*G0_0_0_6_1_0 + 1.29241622574956*G0_0_0_6_1_1 + 0.270899470899471*G0_0_0_7_1_0 + 0.369664902998237*G0_0_0_8_1_1 - 0.282186948853614*G0_0_0_9_1_0 - 0.38095238095238*G0_0_0_9_1_1 + 0.282186948853614*G0_0_0_10_1_0 - 1.6620811287478*G0_0_0_10_1_1 - 1.56331569664903*G0_0_0_11_1_0 + 0.380952380952381*G0_0_0_11_1_1 + 1.29241622574956*G0_0_1_0_0_0 + 1.29241622574956*G0_0_1_0_0_1 + 0.270899470899471*G0_0_1_1_0_0 + 0.369664902998236*G0_0_1_2_0_1 - 0.282186948853614*G0_0_1_3_0_0 - 0.38095238095238*G0_0_1_3_0_1 + 0.282186948853614*G0_0_1_4_0_0 - 1.6620811287478*G0_0_1_4_0_1 - 1.56331569664903*G0_0_1_5_0_0 + 0.38095238095238*G0_0_1_5_0_1 + 1.29241622574956*G0_0_1_6_1_0 + 1.29241622574956*G0_0_1_6_1_1 + 0.270899470899471*G0_0_1_7_1_0 + 0.369664902998236*G0_0_1_8_1_1 - 0.282186948853614*G0_0_1_9_1_0 - 0.38095238095238*G0_0_1_9_1_1 + 0.282186948853614*G0_0_1_10_1_0 - 1.6620811287478*G0_0_1_10_1_1 - 1.56331569664903*G0_0_1_11_1_0 + 0.38095238095238*G0_0_1_11_1_1 - 1.27266313932981*G0_1_0_0_0_0 - 1.2726631393298*G0_1_0_0_0_1 + 0.270899470899472*G0_1_0_1_0_0 - 2.19541446208113*G0_1_0_2_0_1 - 2.84726631393298*G0_1_0_3_0_0 - 0.38095238095238*G0_1_0_3_0_1 + 2.84726631393298*G0_1_0_4_0_0 + 3.46807760141093*G0_1_0_4_0_1 + 1.00176366843033*G0_1_0_5_0_0 + 0.38095238095238*G0_1_0_5_0_1 - 1.27266313932981*G0_1_0_6_1_0 - 1.2726631393298*G0_1_0_6_1_1 + 0.270899470899472*G0_1_0_7_1_0 - 2.19541446208113*G0_1_0_8_1_1 - 2.84726631393298*G0_1_0_9_1_0 - 0.38095238095238*G0_1_0_9_1_1 + 2.84726631393298*G0_1_0_10_1_0 + 3.46807760141093*G0_1_0_10_1_1 + 1.00176366843033*G0_1_0_11_1_0 + 0.38095238095238*G0_1_0_11_1_1 - 0.902998236331568*G0_1_1_0_0_0 - 0.902998236331568*G0_1_1_0_0_1 - 0.90299823633157*G0_1_1_2_0_1 - 0.90299823633157*G0_1_1_3_0_0 + 0.90299823633157*G0_1_1_4_0_0 + 1.80599647266314*G0_1_1_4_0_1 + 0.902998236331567*G0_1_1_5_0_0 - 0.902998236331568*G0_1_1_6_1_0 - 0.902998236331568*G0_1_1_6_1_1 - 0.90299823633157*G0_1_1_8_1_1 - 0.90299823633157*G0_1_1_9_1_0 + 0.90299823633157*G0_1_1_10_1_0 + 1.80599647266314*G0_1_1_10_1_1 + 0.902998236331567*G0_1_1_11_1_0;
    A[352] = 0.0;
    A[17] = 0.0;
    A[734] = 0.0;
    A[421] = 0.090299823633157*G0_0_0_0_0_0 + 0.0902998236331571*G0_0_0_0_0_1 + 0.395061728395061*G0_0_0_1_0_0 - 0.389417989417988*G0_0_0_2_0_1 - 0.474074074074072*G0_0_0_3_0_0 + 0.310405643738977*G0_0_0_3_0_1 + 0.474074074074072*G0_0_0_4_0_0 + 0.299118165784831*G0_0_0_4_0_1 - 0.485361552028218*G0_0_0_5_0_0 - 0.310405643738977*G0_0_0_5_0_1 + 0.090299823633157*G0_0_0_6_1_0 + 0.0902998236331571*G0_0_0_6_1_1 + 0.395061728395061*G0_0_0_7_1_0 - 0.389417989417988*G0_0_0_8_1_1 - 0.474074074074072*G0_0_0_9_1_0 + 0.310405643738977*G0_0_0_9_1_1 + 0.474074074074072*G0_0_0_10_1_0 + 0.299118165784831*G0_0_0_10_1_1 - 0.485361552028218*G0_0_0_11_1_0 - 0.310405643738977*G0_0_0_11_1_1 - 0.0282186948853618*G0_1_0_0_0_0 - 0.0282186948853618*G0_1_0_0_0_1 - 0.028218694885361*G0_1_0_2_0_1 - 0.0282186948853613*G0_1_0_3_0_0 + 0.0282186948853613*G0_1_0_4_0_0 + 0.0564373897707229*G0_1_0_4_0_1 + 0.0282186948853628*G0_1_0_5_0_0 - 0.0282186948853618*G0_1_0_6_1_0 - 0.0282186948853618*G0_1_0_6_1_1 - 0.028218694885361*G0_1_0_8_1_1 - 0.0282186948853613*G0_1_0_9_1_0 + 0.0282186948853613*G0_1_0_10_1_0 + 0.0564373897707229*G0_1_0_10_1_1 + 0.0282186948853628*G0_1_0_11_1_0;
    A[377] = 0.0;
    A[58] = 0.0;
    A[454] = 0.0;
    A[410] = 0.0;
    A[87] = 0.0;
    A[792] = 0.0;
    A[887] = -0.0282186948853634*G0_0_1_0_0_0 - 0.0282186948853635*G0_0_1_0_0_1 - 0.0282186948853606*G0_0_1_1_0_0 - 0.0282186948853628*G0_0_1_3_0_1 + 0.0282186948853685*G0_0_1_4_0_1 + 0.056437389770724*G0_0_1_5_0_0 + 0.0282186948853628*G0_0_1_5_0_1 - 0.0282186948853634*G0_0_1_6_1_0 - 0.0282186948853635*G0_0_1_6_1_1 - 0.0282186948853606*G0_0_1_7_1_0 - 0.0282186948853628*G0_0_1_9_1_1 + 0.0282186948853685*G0_0_1_10_1_1 + 0.056437389770724*G0_0_1_11_1_0 + 0.0282186948853628*G0_0_1_11_1_1 - 0.451499118165786*G0_1_1_0_0_0 - 0.451499118165785*G0_1_1_0_0_1 + 0.423280423280424*G0_1_1_1_0_0 - 0.959435626102294*G0_1_1_2_0_1 - 1.04409171075838*G0_1_1_3_0_0 + 0.338624338624338*G0_1_1_3_0_1 + 1.04409171075838*G0_1_1_4_0_0 + 1.41093474426808*G0_1_1_4_0_1 + 0.028218694885362*G0_1_1_5_0_0 - 0.338624338624338*G0_1_1_5_0_1 - 0.451499118165786*G0_1_1_6_1_0 - 0.451499118165785*G0_1_1_6_1_1 + 0.423280423280424*G0_1_1_7_1_0 - 0.959435626102294*G0_1_1_8_1_1 - 1.04409171075838*G0_1_1_9_1_0 + 0.338624338624338*G0_1_1_9_1_1 + 1.04409171075838*G0_1_1_10_1_0 + 1.41093474426808*G0_1_1_10_1_1 + 0.028218694885362*G0_1_1_11_1_0 - 0.338624338624338*G0_1_1_11_1_1;
    A[811] = 0.0;
    A[850] = 0.0;
    A[174] = 0.0;
    A[881] = 0.0;
    A[480] = 0.0;
    A[203] = 0.0;
    A[583] = 0.0;
    A[523] = 0.0;
    A[232] = 0.0;
    A[614] = 0.0;
    A[550] = 0.0;
    A[672] = 0.0;
    A[699] = 0.0;
    A[258] = 0.0;
    A[345] = 0.0;
    A[289] = 0.0;
    A[51] = 0.0;
    A[766] = 0.00564373897707244*G0_0_0_0_0_0 + 0.00564373897707264*G0_0_0_0_0_1 + 0.729453262786597*G0_0_0_1_0_0 - 0.256084656084656*G0_0_0_2_0_1 + 0.211640211640211*G0_0_0_3_0_0 + 1.19717813051146*G0_0_0_3_0_1 - 0.211640211640211*G0_0_0_4_0_0 + 0.250440917107584*G0_0_0_4_0_1 - 0.735097001763669*G0_0_0_5_0_0 - 1.19717813051146*G0_0_0_5_0_1 + 0.00564373897707244*G0_0_0_6_1_0 + 0.00564373897707264*G0_0_0_6_1_1 + 0.729453262786597*G0_0_0_7_1_0 - 0.256084656084656*G0_0_0_8_1_1 + 0.211640211640211*G0_0_0_9_1_0 + 1.19717813051146*G0_0_0_9_1_1 - 0.211640211640211*G0_0_0_10_1_0 + 0.250440917107584*G0_0_0_10_1_1 - 0.735097001763669*G0_0_0_11_1_0 - 1.19717813051146*G0_0_0_11_1_1 + 0.323104056437389*G0_1_0_0_0_0 + 0.323104056437389*G0_1_0_0_0_1 + 1.04338624338624*G0_1_0_1_0_0 - 0.294885361552028*G0_1_0_2_0_1 + 0.130511463844796*G0_1_0_3_0_0 + 1.46878306878307*G0_1_0_3_0_1 - 0.130511463844796*G0_1_0_4_0_0 - 0.0282186948853607*G0_1_0_4_0_1 - 1.36649029982363*G0_1_0_5_0_0 - 1.46878306878307*G0_1_0_5_0_1 + 0.323104056437389*G0_1_0_6_1_0 + 0.323104056437389*G0_1_0_6_1_1 + 1.04338624338624*G0_1_0_7_1_0 - 0.294885361552028*G0_1_0_8_1_1 + 0.130511463844796*G0_1_0_9_1_0 + 1.46878306878307*G0_1_0_9_1_1 - 0.130511463844796*G0_1_0_10_1_0 - 0.0282186948853607*G0_1_0_10_1_1 - 1.36649029982363*G0_1_0_11_1_0 - 1.46878306878307*G0_1_0_11_1_1;
    A[765] = A[766] - 0.735097001763669*G0_0_0_0_0_0 - 0.735097001763669*G0_0_0_0_0_1 - 0.735097001763669*G0_0_0_1_0_0 - 0.735097001763669*G0_0_0_3_0_1 + 0.735097001763669*G0_0_0_4_0_1 + 1.47019400352734*G0_0_0_5_0_0 + 0.735097001763669*G0_0_0_5_0_1 - 0.735097001763669*G0_0_0_6_1_0 - 0.735097001763669*G0_0_0_6_1_1 - 0.735097001763669*G0_0_0_7_1_0 - 0.735097001763669*G0_0_0_9_1_1 + 0.735097001763669*G0_0_0_10_1_1 + 1.47019400352734*G0_0_0_11_1_0 + 0.735097001763669*G0_0_0_11_1_1 - 0.729453262786597*G0_0_1_0_0_0 - 0.729453262786597*G0_0_1_0_0_1 - 0.00564373897707268*G0_0_1_1_0_0 - 0.256084656084656*G0_0_1_2_0_1 + 0.211640211640211*G0_0_1_3_0_0 + 0.462081128747795*G0_0_1_3_0_1 - 0.211640211640211*G0_0_1_4_0_0 + 0.985537918871253*G0_0_1_4_0_1 + 0.735097001763669*G0_0_1_5_0_0 - 0.462081128747795*G0_0_1_5_0_1 - 0.729453262786597*G0_0_1_6_1_0 - 0.729453262786597*G0_0_1_6_1_1 - 0.00564373897707268*G0_0_1_7_1_0 - 0.256084656084656*G0_0_1_8_1_1 + 0.211640211640211*G0_0_1_9_1_0 + 0.462081128747795*G0_0_1_9_1_1 - 0.211640211640211*G0_0_1_10_1_0 + 0.985537918871253*G0_0_1_10_1_1 + 0.735097001763669*G0_0_1_11_1_0 - 0.462081128747795*G0_0_1_11_1_1 - 0.00917107583774357*G0_1_0_0_0_0 - 0.00917107583774379*G0_1_0_0_0_1 - 0.725925925925926*G0_1_0_1_0_0 + 0.3336860670194*G0_1_0_2_0_1 - 0.049382716049382*G0_1_0_3_0_0 - 1.10899470899471*G0_1_0_3_0_1 + 0.049382716049382*G0_1_0_4_0_0 - 0.324514991181656*G0_1_0_4_0_1 + 0.735097001763669*G0_1_0_5_0_0 + 1.10899470899471*G0_1_0_5_0_1 - 0.00917107583774357*G0_1_0_6_1_0 - 0.00917107583774379*G0_1_0_6_1_1 - 0.725925925925926*G0_1_0_7_1_0 + 0.3336860670194*G0_1_0_8_1_1 - 0.049382716049382*G0_1_0_9_1_0 - 1.10899470899471*G0_1_0_9_1_1 + 0.049382716049382*G0_1_0_10_1_0 - 0.324514991181656*G0_1_0_10_1_1 + 0.735097001763669*G0_1_0_11_1_0 + 1.10899470899471*G0_1_0_11_1_1 + 0.313932980599645*G0_1_1_0_0_0 + 0.313932980599645*G0_1_1_0_0_1 + 0.317460317460316*G0_1_1_1_0_0 + 0.0388007054673716*G0_1_1_2_0_1 + 0.0811287477954141*G0_1_1_3_0_0 + 0.359788359788359*G0_1_1_3_0_1 - 0.0811287477954141*G0_1_1_4_0_0 - 0.352733686067017*G0_1_1_4_0_1 - 0.631393298059962*G0_1_1_5_0_0 - 0.359788359788359*G0_1_1_5_0_1 + 0.313932980599645*G0_1_1_6_1_0 + 0.313932980599645*G0_1_1_6_1_1 + 0.317460317460316*G0_1_1_7_1_0 + 0.0388007054673716*G0_1_1_8_1_1 + 0.0811287477954141*G0_1_1_9_1_0 + 0.359788359788359*G0_1_1_9_1_1 - 0.0811287477954141*G0_1_1_10_1_0 - 0.352733686067017*G0_1_1_10_1_1 - 0.631393298059962*G0_1_1_11_1_0 - 0.359788359788359*G0_1_1_11_1_1;
    A[463] = 0.0;
    A[78] = 0.0;
    A[803] = A[716] - 0.0902998236331576*G0_0_1_0_0_0 - 0.0902998236331576*G0_0_1_0_0_1 - 0.0451499118165789*G0_0_1_1_0_0 - 0.0451499118165785*G0_0_1_2_0_1 - 0.0451499118165783*G0_0_1_3_0_0 - 0.0451499118165788*G0_0_1_3_0_1 + 0.0451499118165783*G0_0_1_4_0_0 + 0.135449735449736*G0_0_1_4_0_1 + 0.135449735449737*G0_0_1_5_0_0 + 0.0451499118165788*G0_0_1_5_0_1 - 0.0902998236331576*G0_0_1_6_1_0 - 0.0902998236331576*G0_0_1_6_1_1 - 0.0451499118165789*G0_0_1_7_1_0 - 0.0451499118165785*G0_0_1_8_1_1 - 0.0451499118165783*G0_0_1_9_1_0 - 0.0451499118165788*G0_0_1_9_1_1 + 0.0451499118165783*G0_0_1_10_1_0 + 0.135449735449736*G0_0_1_10_1_1 + 0.135449735449737*G0_0_1_11_1_0 + 0.0451499118165788*G0_0_1_11_1_1 + 0.0902998236331576*G0_1_0_0_0_0 + 0.0902998236331577*G0_1_0_0_0_1 + 0.045149911816579*G0_1_0_1_0_0 + 0.0451499118165785*G0_1_0_2_0_1 + 0.0451499118165784*G0_1_0_3_0_0 + 0.0451499118165788*G0_1_0_3_0_1 - 0.0451499118165784*G0_1_0_4_0_0 - 0.135449735449736*G0_1_0_4_0_1 - 0.135449735449737*G0_1_0_5_0_0 - 0.0451499118165789*G0_1_0_5_0_1 + 0.0902998236331576*G0_1_0_6_1_0 + 0.0902998236331577*G0_1_0_6_1_1 + 0.045149911816579*G0_1_0_7_1_0 + 0.0451499118165785*G0_1_0_8_1_1 + 0.0451499118165784*G0_1_0_9_1_0 + 0.0451499118165788*G0_1_0_9_1_1 - 0.0451499118165784*G0_1_0_10_1_0 - 0.135449735449736*G0_1_0_10_1_1 - 0.135449735449737*G0_1_0_11_1_0 - 0.0451499118165789*G0_1_0_11_1_1;
    A[14] = A[421] - 0.48536155202822*G0_0_0_0_0_0 - 0.48536155202822*G0_0_0_0_0_1 - 0.485361552028219*G0_0_0_1_0_0 - 0.485361552028218*G0_0_0_3_0_1 + 0.485361552028221*G0_0_0_4_0_1 + 0.970723104056438*G0_0_0_5_0_0 + 0.485361552028218*G0_0_0_5_0_1 - 0.48536155202822*G0_0_0_6_1_0 - 0.48536155202822*G0_0_0_6_1_1 - 0.485361552028219*G0_0_0_7_1_0 - 0.485361552028218*G0_0_0_9_1_1 + 0.485361552028221*G0_0_0_10_1_1 + 0.970723104056438*G0_0_0_11_1_0 + 0.485361552028218*G0_0_0_11_1_1 - 0.395061728395064*G0_0_1_0_0_0 - 0.395061728395064*G0_0_1_0_0_1 - 0.118518518518519*G0_0_1_1_0_0 - 0.361199294532628*G0_0_1_2_0_1 - 0.445855379188712*G0_0_1_3_0_0 - 0.203174603174603*G0_0_1_3_0_1 + 0.445855379188712*G0_0_1_4_0_0 + 0.756261022927692*G0_0_1_4_0_1 + 0.513580246913583*G0_0_1_5_0_0 + 0.203174603174603*G0_0_1_5_0_1 - 0.395061728395064*G0_0_1_6_1_0 - 0.395061728395064*G0_0_1_6_1_1 - 0.118518518518519*G0_0_1_7_1_0 - 0.361199294532628*G0_0_1_8_1_1 - 0.445855379188712*G0_0_1_9_1_0 - 0.203174603174603*G0_0_1_9_1_1 + 0.445855379188712*G0_0_1_10_1_0 + 0.756261022927692*G0_0_1_10_1_1 + 0.513580246913583*G0_0_1_11_1_0 + 0.203174603174603*G0_0_1_11_1_1 - 0.366843033509701*G0_1_0_0_0_0 - 0.366843033509701*G0_1_0_0_0_1 - 0.090299823633156*G0_1_0_1_0_0 - 0.361199294532629*G0_1_0_2_0_1 - 0.445855379188712*G0_1_0_3_0_0 - 0.17495590828924*G0_1_0_3_0_1 + 0.445855379188712*G0_1_0_4_0_0 + 0.728042328042329*G0_1_0_4_0_1 + 0.457142857142857*G0_1_0_5_0_0 + 0.17495590828924*G0_1_0_5_0_1 - 0.366843033509701*G0_1_0_6_1_0 - 0.366843033509701*G0_1_0_6_1_1 - 0.090299823633156*G0_1_0_7_1_0 - 0.361199294532629*G0_1_0_8_1_1 - 0.445855379188712*G0_1_0_9_1_0 - 0.17495590828924*G0_1_0_9_1_1 + 0.445855379188712*G0_1_0_10_1_0 + 0.728042328042329*G0_1_0_10_1_1 + 0.457142857142857*G0_1_0_11_1_0 + 0.17495590828924*G0_1_0_11_1_1 - 0.395061728395064*G0_1_1_0_0_0 - 0.395061728395064*G0_1_1_0_0_1 - 0.118518518518519*G0_1_1_1_0_0 - 0.361199294532629*G0_1_1_2_0_1 - 0.445855379188712*G0_1_1_3_0_0 - 0.203174603174602*G0_1_1_3_0_1 + 0.445855379188712*G0_1_1_4_0_0 + 0.756261022927692*G0_1_1_4_0_1 + 0.513580246913583*G0_1_1_5_0_0 + 0.203174603174602*G0_1_1_5_0_1 - 0.395061728395064*G0_1_1_6_1_0 - 0.395061728395064*G0_1_1_6_1_1 - 0.118518518518519*G0_1_1_7_1_0 - 0.361199294532629*G0_1_1_8_1_1 - 0.445855379188712*G0_1_1_9_1_0 - 0.203174603174602*G0_1_1_9_1_1 + 0.445855379188712*G0_1_1_10_1_0 + 0.756261022927692*G0_1_1_10_1_1 + 0.513580246913583*G0_1_1_11_1_0 + 0.203174603174602*G0_1_1_11_1_1;
    A[816] = 0.0;
    A[45] = 0.0;
    A[841] = 0.0;
    A[874] = 0.0;
    A[107] = 0.0;
    A[487] = 0.0;
    A[516] = 0.0;
    A[225] = 0.0;
    A[545] = 0.0;
    A[509] = A[421] - 0.0282186948853621*G0_0_1_0_0_0 - 0.028218694885362*G0_0_1_0_0_1 - 0.0282186948853611*G0_0_1_2_0_1 - 0.0282186948853614*G0_0_1_3_0_0 + 0.0282186948853614*G0_0_1_4_0_0 + 0.0564373897707231*G0_0_1_4_0_1 + 0.0282186948853634*G0_0_1_5_0_0 - 0.0282186948853621*G0_0_1_6_1_0 - 0.028218694885362*G0_0_1_6_1_1 - 0.0282186948853611*G0_0_1_8_1_1 - 0.0282186948853614*G0_0_1_9_1_0 + 0.0282186948853614*G0_0_1_10_1_0 + 0.0564373897707231*G0_0_1_10_1_1 + 0.0282186948853634*G0_0_1_11_1_0 + 0.028218694885362*G0_1_0_0_0_0 + 0.028218694885362*G0_1_0_0_0_1 + 0.0282186948853611*G0_1_0_2_0_1 + 0.0282186948853614*G0_1_0_3_0_0 - 0.0282186948853614*G0_1_0_4_0_0 - 0.0564373897707231*G0_1_0_4_0_1 - 0.0282186948853633*G0_1_0_5_0_0 + 0.028218694885362*G0_1_0_6_1_0 + 0.028218694885362*G0_1_0_6_1_1 + 0.0282186948853611*G0_1_0_8_1_1 + 0.0282186948853614*G0_1_0_9_1_0 - 0.0282186948853614*G0_1_0_10_1_0 - 0.0564373897707231*G0_1_0_10_1_1 - 0.0282186948853633*G0_1_0_11_1_0;
    A[638] = 0.0;
    A[534] = 0.0310405643738978*G0_1_0_0_0_0 + 0.0310405643738978*G0_1_0_0_0_1 + 0.0310405643738976*G0_1_0_1_0_0 + 0.0310405643738978*G0_1_0_3_0_1 - 0.0310405643738982*G0_1_0_4_0_1 - 0.0620811287477954*G0_1_0_5_0_0 - 0.0310405643738978*G0_1_0_5_0_1 + 0.0310405643738978*G0_1_0_6_1_0 + 0.0310405643738978*G0_1_0_6_1_1 + 0.0310405643738976*G0_1_0_7_1_0 + 0.0310405643738978*G0_1_0_9_1_1 - 0.0310405643738982*G0_1_0_10_1_1 - 0.0620811287477954*G0_1_0_11_1_0 - 0.0310405643738978*G0_1_0_11_1_1 - 0.135449735449736*G0_1_1_0_0_0 - 0.135449735449736*G0_1_1_0_0_1 + 0.019753086419753*G0_1_1_1_0_0 - 0.112874779541446*G0_1_1_2_0_1 - 0.0705467372134039*G0_1_1_3_0_0 + 0.0620811287477953*G0_1_1_3_0_1 + 0.0705467372134039*G0_1_1_4_0_0 + 0.248324514991182*G0_1_1_4_0_1 + 0.115696649029983*G0_1_1_5_0_0 - 0.0620811287477953*G0_1_1_5_0_1 - 0.135449735449736*G0_1_1_6_1_0 - 0.135449735449736*G0_1_1_6_1_1 + 0.019753086419753*G0_1_1_7_1_0 - 0.112874779541446*G0_1_1_8_1_1 - 0.0705467372134039*G0_1_1_9_1_0 + 0.0620811287477953*G0_1_1_9_1_1 + 0.0705467372134039*G0_1_1_10_1_0 + 0.248324514991182*G0_1_1_10_1_1 + 0.115696649029983*G0_1_1_11_1_0 - 0.0620811287477953*G0_1_1_11_1_1;
    A[667] = 0.0;
    A[696] = 0.0;
    A[265] = 0.0;
    A[290] = 0.0;
    A[439] = 0.0;
    A[319] = 0.0;
    A[460] = 0.0;
    A[356] = 0.0;
    A[5] = A[534] + 0.112874779541446*G0_0_0_0_0_0 + 0.112874779541446*G0_0_0_0_0_1 - 0.0112874779541446*G0_0_0_1_0_0 + 0.166490299823633*G0_0_0_2_0_1 + 0.208818342151676*G0_0_0_3_0_0 + 0.0310405643738977*G0_0_0_3_0_1 - 0.208818342151676*G0_0_0_4_0_0 - 0.27936507936508*G0_0_0_4_0_1 - 0.101587301587302*G0_0_0_5_0_0 - 0.0310405643738978*G0_0_0_5_0_1 + 0.112874779541446*G0_0_0_6_1_0 + 0.112874779541446*G0_0_0_6_1_1 - 0.0112874779541446*G0_0_0_7_1_0 + 0.166490299823633*G0_0_0_8_1_1 + 0.208818342151676*G0_0_0_9_1_0 + 0.0310405643738977*G0_0_0_9_1_1 - 0.208818342151676*G0_0_0_10_1_0 - 0.27936507936508*G0_0_0_10_1_1 - 0.101587301587302*G0_0_0_11_1_0 - 0.0310405643738978*G0_0_0_11_1_1 + 0.112874779541446*G0_0_1_0_0_0 + 0.112874779541446*G0_0_1_0_0_1 + 0.0197530864197533*G0_0_1_1_0_0 + 0.135449735449735*G0_0_1_2_0_1 + 0.177777777777777*G0_0_1_3_0_0 + 0.0620811287477955*G0_0_1_3_0_1 - 0.177777777777777*G0_0_1_4_0_0 - 0.248324514991181*G0_0_1_4_0_1 - 0.132627865961199*G0_0_1_5_0_0 - 0.0620811287477956*G0_0_1_5_0_1 + 0.112874779541446*G0_0_1_6_1_0 + 0.112874779541446*G0_0_1_6_1_1 + 0.0197530864197533*G0_0_1_7_1_0 + 0.135449735449735*G0_0_1_8_1_1 + 0.177777777777777*G0_0_1_9_1_0 + 0.0620811287477955*G0_0_1_9_1_1 - 0.177777777777777*G0_0_1_10_1_0 - 0.248324514991181*G0_0_1_10_1_1 - 0.132627865961199*G0_0_1_11_1_0 - 0.0620811287477956*G0_0_1_11_1_1 + 0.0818342151675487*G0_1_0_0_0_0 + 0.0818342151675487*G0_1_0_0_0_1 - 0.0423280423280426*G0_1_0_1_0_0 + 0.166490299823634*G0_1_0_2_0_1 + 0.208818342151676*G0_1_0_3_0_0 - 0.208818342151676*G0_1_0_4_0_0 - 0.248324514991182*G0_1_0_4_0_1 - 0.0395061728395061*G0_1_0_5_0_0 + 0.0818342151675487*G0_1_0_6_1_0 + 0.0818342151675487*G0_1_0_6_1_1 - 0.0423280423280426*G0_1_0_7_1_0 + 0.166490299823634*G0_1_0_8_1_1 + 0.208818342151676*G0_1_0_9_1_0 - 0.208818342151676*G0_1_0_10_1_0 - 0.248324514991182*G0_1_0_10_1_1 - 0.0395061728395061*G0_1_0_11_1_0 + 0.248324514991182*G0_1_1_0_0_0 + 0.248324514991182*G0_1_1_0_0_1 + 0.248324514991182*G0_1_1_2_0_1 + 0.248324514991182*G0_1_1_3_0_0 - 0.248324514991182*G0_1_1_4_0_0 - 0.496649029982363*G0_1_1_4_0_1 - 0.248324514991182*G0_1_1_5_0_0 + 0.248324514991182*G0_1_1_6_1_0 + 0.248324514991182*G0_1_1_6_1_1 + 0.248324514991182*G0_1_1_8_1_1 + 0.248324514991182*G0_1_1_9_1_0 - 0.248324514991182*G0_1_1_10_1_0 - 0.496649029982363*G0_1_1_10_1_1 - 0.248324514991182*G0_1_1_11_1_0;
    A[722] = 0.0;
    A[389] = 0.0;
    A[753] = 0.0;
    A[67] = 0.32310405643739*G0_1_0_0_0_0 + 0.32310405643739*G0_1_0_0_0_1 - 0.294885361552028*G0_1_0_1_0_0 + 1.04338624338624*G0_1_0_2_0_1 + 1.46878306878307*G0_1_0_3_0_0 + 0.130511463844797*G0_1_0_3_0_1 - 1.46878306878307*G0_1_0_4_0_0 - 1.36649029982363*G0_1_0_4_0_1 - 0.0282186948853621*G0_1_0_5_0_0 - 0.130511463844797*G0_1_0_5_0_1 + 0.32310405643739*G0_1_0_6_1_0 + 0.32310405643739*G0_1_0_6_1_1 - 0.294885361552028*G0_1_0_7_1_0 + 1.04338624338624*G0_1_0_8_1_1 + 1.46878306878307*G0_1_0_9_1_0 + 0.130511463844797*G0_1_0_9_1_1 - 1.46878306878307*G0_1_0_10_1_0 - 1.36649029982363*G0_1_0_10_1_1 - 0.0282186948853621*G0_1_0_11_1_0 - 0.130511463844797*G0_1_0_11_1_1 + 0.00564373897707346*G0_1_1_0_0_0 + 0.00564373897707338*G0_1_1_0_0_1 - 0.256084656084656*G0_1_1_1_0_0 + 0.729453262786597*G0_1_1_2_0_1 + 1.19717813051146*G0_1_1_3_0_0 + 0.211640211640211*G0_1_1_3_0_1 - 1.19717813051146*G0_1_1_4_0_0 - 0.73509700176367*G0_1_1_4_0_1 + 0.250440917107582*G0_1_1_5_0_0 - 0.211640211640212*G0_1_1_5_0_1 + 0.00564373897707346*G0_1_1_6_1_0 + 0.00564373897707338*G0_1_1_6_1_1 - 0.256084656084656*G0_1_1_7_1_0 + 0.729453262786597*G0_1_1_8_1_1 + 1.19717813051146*G0_1_1_9_1_0 + 0.211640211640211*G0_1_1_9_1_1 - 1.19717813051146*G0_1_1_10_1_0 - 0.73509700176367*G0_1_1_10_1_1 + 0.250440917107582*G0_1_1_11_1_0 - 0.211640211640212*G0_1_1_11_1_1;
    A[160] = A[625];
    A[112] = 0.0;
    A[181] = -0.135449735449735*G0_0_0_0_0_0 - 0.135449735449735*G0_0_0_0_0_1 - 0.112874779541445*G0_0_0_1_0_0 + 0.0197530864197529*G0_0_0_2_0_1 + 0.062081128747795*G0_0_0_3_0_0 - 0.0705467372134032*G0_0_0_3_0_1 - 0.062081128747795*G0_0_0_4_0_0 + 0.115696649029982*G0_0_0_4_0_1 + 0.24832451499118*G0_0_0_5_0_0 + 0.0705467372134032*G0_0_0_5_0_1 - 0.135449735449735*G0_0_0_6_1_0 - 0.135449735449735*G0_0_0_6_1_1 - 0.112874779541445*G0_0_0_7_1_0 + 0.0197530864197529*G0_0_0_8_1_1 + 0.062081128747795*G0_0_0_9_1_0 - 0.0705467372134032*G0_0_0_9_1_1 - 0.062081128747795*G0_0_0_10_1_0 + 0.115696649029982*G0_0_0_10_1_1 + 0.24832451499118*G0_0_0_11_1_0 + 0.0705467372134032*G0_0_0_11_1_1 + 0.0310405643738985*G0_1_0_0_0_0 + 0.0310405643738985*G0_1_0_0_0_1 + 0.0310405643738976*G0_1_0_2_0_1 + 0.0310405643738977*G0_1_0_3_0_0 - 0.0310405643738977*G0_1_0_4_0_0 - 0.0620811287477961*G0_1_0_4_0_1 - 0.0310405643738995*G0_1_0_5_0_0 + 0.0310405643738985*G0_1_0_6_1_0 + 0.0310405643738985*G0_1_0_6_1_1 + 0.0310405643738976*G0_1_0_8_1_1 + 0.0310405643738977*G0_1_0_9_1_0 - 0.0310405643738977*G0_1_0_10_1_0 - 0.0620811287477961*G0_1_0_10_1_1 - 0.0310405643738995*G0_1_0_11_1_0;
    A[137] = 0.0;
    A[170] = 0.0;
    A[207] = 0.0;
    A[571] = 0.0;
    A[527] = 0.221340388007055*G0_1_1_0_0_0 + 0.221340388007055*G0_1_1_0_0_1 - 0.221340388007055*G0_1_1_1_0_0 + 0.815696649029982*G0_1_1_2_0_1 + 1.18871252204585*G0_1_1_3_0_0 + 0.151675485008818*G0_1_1_3_0_1 - 1.18871252204585*G0_1_1_4_0_0 - 1.03703703703704*G0_1_1_4_0_1 - 0.151675485008818*G0_1_1_5_0_1 + 0.221340388007055*G0_1_1_6_1_0 + 0.221340388007055*G0_1_1_6_1_1 - 0.221340388007055*G0_1_1_7_1_0 + 0.815696649029982*G0_1_1_8_1_1 + 1.18871252204585*G0_1_1_9_1_0 + 0.151675485008818*G0_1_1_9_1_1 - 1.18871252204585*G0_1_1_10_1_0 - 1.03703703703704*G0_1_1_10_1_1 - 0.151675485008818*G0_1_1_11_1_1;
    A[562] = A[213] - 0.0564373897707215*G0_0_1_0_0_0 - 0.0564373897707214*G0_0_1_0_0_1 + 0.0112874779541464*G0_0_1_1_0_0 - 0.0677248677248671*G0_0_1_2_0_1 - 0.0677248677248663*G0_0_1_3_0_0 + 0.0112874779541471*G0_0_1_3_0_1 + 0.0677248677248663*G0_0_1_4_0_0 + 0.124162257495588*G0_0_1_4_0_1 + 0.0451499118165751*G0_0_1_5_0_0 - 0.0112874779541471*G0_0_1_5_0_1 - 0.0564373897707215*G0_0_1_6_1_0 - 0.0564373897707214*G0_0_1_6_1_1 + 0.0112874779541464*G0_0_1_7_1_0 - 0.0677248677248671*G0_0_1_8_1_1 - 0.0677248677248663*G0_0_1_9_1_0 + 0.0112874779541471*G0_0_1_9_1_1 + 0.0677248677248663*G0_0_1_10_1_0 + 0.124162257495588*G0_0_1_10_1_1 + 0.0451499118165751*G0_0_1_11_1_0 - 0.0112874779541471*G0_0_1_11_1_1 + 0.0564373897707215*G0_1_0_0_0_0 + 0.0564373897707214*G0_1_0_0_0_1 - 0.0112874779541463*G0_1_0_1_0_0 + 0.067724867724867*G0_1_0_2_0_1 + 0.0677248677248662*G0_1_0_3_0_0 - 0.0112874779541471*G0_1_0_3_0_1 - 0.0677248677248662*G0_1_0_4_0_0 - 0.124162257495588*G0_1_0_4_0_1 - 0.0451499118165752*G0_1_0_5_0_0 + 0.0112874779541471*G0_1_0_5_0_1 + 0.0564373897707215*G0_1_0_6_1_0 + 0.0564373897707214*G0_1_0_6_1_1 - 0.0112874779541463*G0_1_0_7_1_0 + 0.067724867724867*G0_1_0_8_1_1 + 0.0677248677248662*G0_1_0_9_1_0 - 0.0112874779541471*G0_1_0_9_1_1 - 0.0677248677248662*G0_1_0_10_1_0 - 0.124162257495588*G0_1_0_10_1_1 - 0.0451499118165752*G0_1_0_11_1_0 + 0.0112874779541471*G0_1_0_11_1_1;
    A[299] = 0.0;
    A[446] = 0.0;
    A[326] = 0.0;
    A[349] = 0.0;
    A[28] = 0.0;
    A[729] = 0.0;
    A[380] = 0.0;
    A[55] = 0.0;
    A[754] = 0.0;
    A[415] = 0.0;
    A[783] = 0.0;
    A[820] = 0.0;
    A[144] = 0.0;
    A[853] = 0.0;
    A[179] = 0.0;
    A[491] = 0.0;
    A[198] = 0.0;
    A[656] = A[716] + 0.496649029982362*G0_0_0_0_0_0 + 0.496649029982361*G0_0_0_0_0_1 + 0.406349206349206*G0_0_0_1_0_0 - 0.045149911816579*G0_0_0_2_0_1 - 0.180599647266314*G0_0_0_3_0_0 + 0.270899470899471*G0_0_0_3_0_1 + 0.180599647266314*G0_0_0_4_0_0 - 0.451499118165782*G0_0_0_4_0_1 - 0.902998236331567*G0_0_0_5_0_0 - 0.270899470899471*G0_0_0_5_0_1 + 0.496649029982362*G0_0_0_6_1_0 + 0.496649029982361*G0_0_0_6_1_1 + 0.406349206349206*G0_0_0_7_1_0 - 0.045149911816579*G0_0_0_8_1_1 - 0.180599647266314*G0_0_0_9_1_0 + 0.270899470899471*G0_0_0_9_1_1 + 0.180599647266314*G0_0_0_10_1_0 - 0.451499118165782*G0_0_0_10_1_1 - 0.902998236331567*G0_0_0_11_1_0 - 0.270899470899471*G0_0_0_11_1_1 - 0.0902998236331569*G0_0_1_0_0_0 - 0.0902998236331568*G0_0_1_0_0_1 - 0.0902998236331565*G0_0_1_2_0_1 - 0.0902998236331561*G0_0_1_3_0_0 + 0.0902998236331561*G0_0_1_4_0_0 + 0.180599647266313*G0_0_1_4_0_1 + 0.0902998236331567*G0_0_1_5_0_0 - 0.0902998236331569*G0_0_1_6_1_0 - 0.0902998236331568*G0_0_1_6_1_1 - 0.0902998236331565*G0_0_1_8_1_1 - 0.0902998236331561*G0_0_1_9_1_0 + 0.0902998236331561*G0_0_1_10_1_0 + 0.180599647266313*G0_0_1_10_1_1 + 0.0902998236331567*G0_0_1_11_1_0 - 0.180599647266315*G0_1_0_0_0_0 - 0.180599647266315*G0_1_0_0_0_1 - 0.180599647266314*G0_1_0_2_0_1 - 0.180599647266313*G0_1_0_3_0_0 + 0.180599647266313*G0_1_0_4_0_0 + 0.361199294532629*G0_1_0_4_0_1 + 0.180599647266315*G0_1_0_5_0_0 - 0.180599647266315*G0_1_0_6_1_0 - 0.180599647266315*G0_1_0_6_1_1 - 0.180599647266314*G0_1_0_8_1_1 - 0.180599647266313*G0_1_0_9_1_0 + 0.180599647266313*G0_1_0_10_1_0 + 0.361199294532629*G0_1_0_10_1_1 + 0.180599647266315*G0_1_0_11_1_0;
    A[576] = 0.0;
    A[520] = 0.0;
    A[237] = 0.0;
    A[677] = 0.32310405643739*G0_0_1_0_0_0 + 0.32310405643739*G0_0_1_0_0_1 - 0.294885361552028*G0_0_1_1_0_0 + 1.04338624338624*G0_0_1_2_0_1 + 1.46878306878307*G0_0_1_3_0_0 + 0.130511463844797*G0_0_1_3_0_1 - 1.46878306878307*G0_0_1_4_0_0 - 1.36649029982363*G0_0_1_4_0_1 - 0.0282186948853621*G0_0_1_5_0_0 - 0.130511463844797*G0_0_1_5_0_1 + 0.32310405643739*G0_0_1_6_1_0 + 0.32310405643739*G0_0_1_6_1_1 - 0.294885361552028*G0_0_1_7_1_0 + 1.04338624338624*G0_0_1_8_1_1 + 1.46878306878307*G0_0_1_9_1_0 + 0.130511463844797*G0_0_1_9_1_1 - 1.46878306878307*G0_0_1_10_1_0 - 1.36649029982363*G0_0_1_10_1_1 - 0.0282186948853621*G0_0_1_11_1_0 - 0.130511463844797*G0_0_1_11_1_1 + 0.00564373897707343*G0_1_1_0_0_0 + 0.0056437389770734*G0_1_1_0_0_1 - 0.256084656084656*G0_1_1_1_0_0 + 0.729453262786596*G0_1_1_2_0_1 + 1.19717813051146*G0_1_1_3_0_0 + 0.211640211640211*G0_1_1_3_0_1 - 1.19717813051146*G0_1_1_4_0_0 - 0.73509700176367*G0_1_1_4_0_1 + 0.250440917107582*G0_1_1_5_0_0 - 0.211640211640212*G0_1_1_5_0_1 + 0.00564373897707343*G0_1_1_6_1_0 + 0.0056437389770734*G0_1_1_6_1_1 - 0.256084656084656*G0_1_1_7_1_0 + 0.729453262786596*G0_1_1_8_1_1 + 1.19717813051146*G0_1_1_9_1_0 + 0.211640211640211*G0_1_1_9_1_1 - 1.19717813051146*G0_1_1_10_1_0 - 0.73509700176367*G0_1_1_10_1_1 + 0.250440917107582*G0_1_1_11_1_0 - 0.211640211640212*G0_1_1_11_1_1;
    A[601] = 0.0;
    A[634] = 0.0;
    A[671] = 0.0;
    A[449] = 0.0;
    A[305] = A[625] - 0.0564373897707228*G0_0_1_0_0_0 - 0.0564373897707228*G0_0_1_0_0_1 - 0.0677248677248661*G0_0_1_1_0_0 + 0.0112874779541425*G0_0_1_2_0_1 + 0.0112874779541416*G0_0_1_3_0_0 - 0.067724867724867*G0_0_1_3_0_1 - 0.0112874779541416*G0_0_1_4_0_0 + 0.0451499118165803*G0_0_1_4_0_1 + 0.124162257495589*G0_0_1_5_0_0 + 0.0677248677248669*G0_0_1_5_0_1 - 0.0564373897707228*G0_0_1_6_1_0 - 0.0564373897707228*G0_0_1_6_1_1 - 0.0677248677248661*G0_0_1_7_1_0 + 0.0112874779541425*G0_0_1_8_1_1 + 0.0112874779541416*G0_0_1_9_1_0 - 0.067724867724867*G0_0_1_9_1_1 - 0.0112874779541416*G0_0_1_10_1_0 + 0.0451499118165803*G0_0_1_10_1_1 + 0.124162257495589*G0_0_1_11_1_0 + 0.0677248677248669*G0_0_1_11_1_1 + 0.0564373897707228*G0_1_0_0_0_0 + 0.0564373897707228*G0_1_0_0_0_1 + 0.0677248677248661*G0_1_0_1_0_0 - 0.0112874779541425*G0_1_0_2_0_1 - 0.0112874779541416*G0_1_0_3_0_0 + 0.067724867724867*G0_1_0_3_0_1 + 0.0112874779541416*G0_1_0_4_0_0 - 0.0451499118165803*G0_1_0_4_0_1 - 0.124162257495589*G0_1_0_5_0_0 - 0.0677248677248669*G0_1_0_5_0_1 + 0.0564373897707228*G0_1_0_6_1_0 + 0.0564373897707228*G0_1_0_6_1_1 + 0.0677248677248661*G0_1_0_7_1_0 - 0.0112874779541425*G0_1_0_8_1_1 - 0.0112874779541416*G0_1_0_9_1_0 + 0.067724867724867*G0_1_0_9_1_1 + 0.0112874779541416*G0_1_0_10_1_0 - 0.0451499118165803*G0_1_0_10_1_1 - 0.124162257495589*G0_1_0_11_1_0 - 0.0677248677248669*G0_1_0_11_1_1;
    A[474] = A[270] - 1.96966490299823*G0_0_1_0_0_0 - 1.96966490299823*G0_0_1_0_0_1 - 0.595414462081128*G0_0_1_1_0_0 - 0.595414462081128*G0_0_1_2_0_1 + 0.183421516754849*G0_0_1_3_0_0 + 0.183421516754849*G0_0_1_3_0_1 - 0.183421516754849*G0_0_1_4_0_0 + 2.56507936507936*G0_0_1_4_0_1 + 2.56507936507936*G0_0_1_5_0_0 - 0.18342151675485*G0_0_1_5_0_1 - 1.96966490299823*G0_0_1_6_1_0 - 1.96966490299823*G0_0_1_6_1_1 - 0.595414462081128*G0_0_1_7_1_0 - 0.595414462081128*G0_0_1_8_1_1 + 0.183421516754849*G0_0_1_9_1_0 + 0.183421516754849*G0_0_1_9_1_1 - 0.183421516754849*G0_0_1_10_1_0 + 2.56507936507936*G0_0_1_10_1_1 + 2.56507936507936*G0_0_1_11_1_0 - 0.18342151675485*G0_0_1_11_1_1 + 1.96966490299823*G0_1_0_0_0_0 + 1.96966490299823*G0_1_0_0_0_1 + 0.595414462081128*G0_1_0_1_0_0 + 0.595414462081128*G0_1_0_2_0_1 - 0.183421516754848*G0_1_0_3_0_0 - 0.183421516754849*G0_1_0_3_0_1 + 0.183421516754848*G0_1_0_4_0_0 - 2.56507936507936*G0_1_0_4_0_1 - 2.56507936507936*G0_1_0_5_0_0 + 0.18342151675485*G0_1_0_5_0_1 + 1.96966490299823*G0_1_0_6_1_0 + 1.96966490299823*G0_1_0_6_1_1 + 0.595414462081128*G0_1_0_7_1_0 + 0.595414462081128*G0_1_0_8_1_1 - 0.183421516754848*G0_1_0_9_1_0 - 0.183421516754849*G0_1_0_9_1_1 + 0.183421516754848*G0_1_0_10_1_0 - 2.56507936507936*G0_1_0_10_1_1 - 2.56507936507936*G0_1_0_11_1_0 + 0.18342151675485*G0_1_0_11_1_1;
    A[645] = A[474] - 1.96966490299823*G0_0_0_0_0_0 - 1.96966490299823*G0_0_0_0_0_1 - 0.496649029982363*G0_0_0_1_0_0 - 0.694179894179894*G0_0_0_2_0_1 + 0.0846560846560832*G0_0_0_3_0_0 + 0.282186948853615*G0_0_0_3_0_1 - 0.0846560846560832*G0_0_0_4_0_0 + 2.66384479717813*G0_0_0_4_0_1 + 2.4663139329806*G0_0_0_5_0_0 - 0.282186948853615*G0_0_0_5_0_1 - 1.96966490299823*G0_0_0_6_1_0 - 1.96966490299823*G0_0_0_6_1_1 - 0.496649029982363*G0_0_0_7_1_0 - 0.694179894179894*G0_0_0_8_1_1 + 0.0846560846560832*G0_0_0_9_1_0 + 0.282186948853615*G0_0_0_9_1_1 - 0.0846560846560832*G0_0_0_10_1_0 + 2.66384479717813*G0_0_0_10_1_1 + 2.4663139329806*G0_0_0_11_1_0 - 0.282186948853615*G0_0_0_11_1_1 + 0.0987654320987658*G0_0_1_1_0_0 - 0.0987654320987653*G0_0_1_2_0_1 - 0.0987654320987659*G0_0_1_3_0_0 + 0.0987654320987652*G0_0_1_3_0_1 + 0.0987654320987659*G0_0_1_4_0_0 + 0.0987654320987645*G0_0_1_4_0_1 - 0.0987654320987662*G0_0_1_5_0_0 - 0.0987654320987652*G0_0_1_5_0_1 + 0.0987654320987658*G0_0_1_7_1_0 - 0.0987654320987653*G0_0_1_8_1_1 - 0.0987654320987659*G0_0_1_9_1_0 + 0.0987654320987652*G0_0_1_9_1_1 + 0.0987654320987659*G0_0_1_10_1_0 + 0.0987654320987645*G0_0_1_10_1_1 - 0.0987654320987662*G0_0_1_11_1_0 - 0.0987654320987652*G0_0_1_11_1_1 + 0.098765432098765*G0_1_0_1_0_0 - 0.0987654320987658*G0_1_0_2_0_1 - 0.0987654320987655*G0_1_0_3_0_0 + 0.0987654320987651*G0_1_0_3_0_1 + 0.0987654320987655*G0_1_0_4_0_0 + 0.0987654320987672*G0_1_0_4_0_1 - 0.0987654320987637*G0_1_0_5_0_0 - 0.0987654320987652*G0_1_0_5_0_1 + 0.098765432098765*G0_1_0_7_1_0 - 0.0987654320987658*G0_1_0_8_1_1 - 0.0987654320987655*G0_1_0_9_1_0 + 0.0987654320987651*G0_1_0_9_1_1 + 0.0987654320987655*G0_1_0_10_1_0 + 0.0987654320987672*G0_1_0_10_1_1 - 0.0987654320987637*G0_1_0_11_1_0 - 0.0987654320987652*G0_1_0_11_1_1 + 1.96966490299823*G0_1_1_0_0_0 + 1.96966490299823*G0_1_1_0_0_1 + 0.694179894179893*G0_1_1_1_0_0 + 0.496649029982362*G0_1_1_2_0_1 - 0.282186948853615*G0_1_1_3_0_0 - 0.0846560846560843*G0_1_1_3_0_1 + 0.282186948853615*G0_1_1_4_0_0 - 2.46631393298059*G0_1_1_4_0_1 - 2.66384479717813*G0_1_1_5_0_0 + 0.0846560846560847*G0_1_1_5_0_1 + 1.96966490299823*G0_1_1_6_1_0 + 1.96966490299823*G0_1_1_6_1_1 + 0.694179894179893*G0_1_1_7_1_0 + 0.496649029982362*G0_1_1_8_1_1 - 0.282186948853615*G0_1_1_9_1_0 - 0.0846560846560843*G0_1_1_9_1_1 + 0.282186948853615*G0_1_1_10_1_0 - 2.46631393298059*G0_1_1_10_1_1 - 2.66384479717813*G0_1_1_11_1_0 + 0.0846560846560847*G0_1_1_11_1_1;
    A[338] = A[803];
    A[19] = 0.0;
    A[379] = 0.0;
    A[48] = 0.0;
    A[763] = 0.0;
    A[456] = 0.0;
    A[408] = 0.0;
    A[85] = 0.0;
    A[790] = 0.0;
    A[9] = A[474];
    A[813] = 0.0;
    A[844] = 0.0;
    A[879] = 0.0;
    A[482] = 0.0;
    A[201] = 0.0;
    A[513] = 0.0;
    A[226] = 0.0;
    A[608] = 0.0;
    A[548] = 0.0;
    A[643] = 0.0;
    A[662] = 0.0;
    A[285] = 0.0;
    A[701] = 0.0;
    A[260] = 0.0;
    A[331] = -0.270899470899471*G0_0_0_0_0_0 - 0.270899470899471*G0_0_0_0_0_1 - 1.29241622574956*G0_0_0_1_0_0 + 0.369664902998236*G0_0_0_2_0_1 - 0.282186948853614*G0_0_0_3_0_0 - 1.94426807760141*G0_0_0_3_0_1 + 0.282186948853614*G0_0_0_4_0_0 - 0.0987654320987662*G0_0_0_4_0_1 + 1.56331569664903*G0_0_0_5_0_0 + 1.94426807760141*G0_0_0_5_0_1 - 0.270899470899471*G0_0_0_6_1_0 - 0.270899470899471*G0_0_0_6_1_1 - 1.29241622574956*G0_0_0_7_1_0 + 0.369664902998236*G0_0_0_8_1_1 - 0.282186948853614*G0_0_0_9_1_0 - 1.94426807760141*G0_0_0_9_1_1 + 0.282186948853614*G0_0_0_10_1_0 - 0.0987654320987662*G0_0_0_10_1_1 + 1.56331569664903*G0_0_0_11_1_0 + 1.94426807760141*G0_0_0_11_1_1 - 0.595414462081128*G0_1_0_0_0_0 - 0.595414462081128*G0_1_0_0_0_1 - 1.96966490299823*G0_1_0_1_0_0 + 0.595414462081128*G0_1_0_2_0_1 - 0.183421516754848*G0_1_0_3_0_0 - 2.74850088183421*G0_1_0_3_0_1 + 0.183421516754848*G0_1_0_4_0_0 + 2.56507936507936*G0_1_0_5_0_0 + 2.74850088183421*G0_1_0_5_0_1 - 0.595414462081128*G0_1_0_6_1_0 - 0.595414462081128*G0_1_0_6_1_1 - 1.96966490299823*G0_1_0_7_1_0 + 0.595414462081128*G0_1_0_8_1_1 - 0.183421516754848*G0_1_0_9_1_0 - 2.74850088183421*G0_1_0_9_1_1 + 0.183421516754848*G0_1_0_10_1_0 + 2.56507936507936*G0_1_0_11_1_0 + 2.74850088183421*G0_1_0_11_1_1;
    A[287] = 0.0;
    A[743] = A[803] - 0.180599647266313*G0_0_1_0_0_0 - 0.180599647266313*G0_0_1_0_0_1 - 0.180599647266312*G0_0_1_1_0_0 - 0.180599647266311*G0_0_1_3_0_1 + 0.180599647266313*G0_0_1_4_0_1 + 0.361199294532625*G0_0_1_5_0_0 + 0.180599647266311*G0_0_1_5_0_1 - 0.180599647266313*G0_0_1_6_1_0 - 0.180599647266313*G0_0_1_6_1_1 - 0.180599647266312*G0_0_1_7_1_0 - 0.180599647266311*G0_0_1_9_1_1 + 0.180599647266313*G0_0_1_10_1_1 + 0.361199294532625*G0_0_1_11_1_0 + 0.180599647266311*G0_0_1_11_1_1 - 0.090299823633156*G0_1_0_0_0_0 - 0.090299823633156*G0_1_0_0_0_1 - 0.0902998236331553*G0_1_0_1_0_0 - 0.0902998236331548*G0_1_0_3_0_1 + 0.090299823633156*G0_1_0_4_0_1 + 0.180599647266311*G0_1_0_5_0_0 + 0.0902998236331548*G0_1_0_5_0_1 - 0.090299823633156*G0_1_0_6_1_0 - 0.090299823633156*G0_1_0_6_1_1 - 0.0902998236331553*G0_1_0_7_1_0 - 0.0902998236331548*G0_1_0_9_1_1 + 0.090299823633156*G0_1_0_10_1_1 + 0.180599647266311*G0_1_0_11_1_0 + 0.0902998236331548*G0_1_0_11_1_1 + 0.496649029982363*G0_1_1_0_0_0 + 0.496649029982363*G0_1_1_0_0_1 - 0.0451499118165756*G0_1_1_1_0_0 + 0.406349206349205*G0_1_1_2_0_1 + 0.270899470899472*G0_1_1_3_0_0 - 0.180599647266309*G0_1_1_3_0_1 - 0.270899470899472*G0_1_1_4_0_0 - 0.902998236331569*G0_1_1_4_0_1 - 0.451499118165788*G0_1_1_5_0_0 + 0.180599647266309*G0_1_1_5_0_1 + 0.496649029982363*G0_1_1_6_1_0 + 0.496649029982363*G0_1_1_6_1_1 - 0.0451499118165756*G0_1_1_7_1_0 + 0.406349206349205*G0_1_1_8_1_1 + 0.270899470899472*G0_1_1_9_1_0 - 0.180599647266309*G0_1_1_9_1_1 - 0.270899470899472*G0_1_1_10_1_0 - 0.902998236331569*G0_1_1_10_1_1 - 0.451499118165788*G0_1_1_11_1_0 + 0.180599647266309*G0_1_1_11_1_1;
    A[322] = 0.0;
    A[465] = A[527] - 0.815696649029982*G0_0_0_0_0_0 - 0.815696649029982*G0_0_0_0_0_1 - 0.221340388007055*G0_0_0_1_0_0 - 0.221340388007055*G0_0_0_2_0_1 + 0.151675485008818*G0_0_0_3_0_0 + 0.151675485008818*G0_0_0_3_0_1 - 0.151675485008818*G0_0_0_4_0_0 + 1.03703703703704*G0_0_0_4_0_1 + 1.03703703703704*G0_0_0_5_0_0 - 0.151675485008818*G0_0_0_5_0_1 - 0.815696649029982*G0_0_0_6_1_0 - 0.815696649029982*G0_0_0_6_1_1 - 0.221340388007055*G0_0_0_7_1_0 - 0.221340388007055*G0_0_0_8_1_1 + 0.151675485008818*G0_0_0_9_1_0 + 0.151675485008818*G0_0_0_9_1_1 - 0.151675485008818*G0_0_0_10_1_0 + 1.03703703703704*G0_0_0_10_1_1 + 1.03703703703704*G0_0_0_11_1_0 - 0.151675485008818*G0_0_0_11_1_1 - 0.815696649029982*G0_0_1_0_0_0 - 0.815696649029982*G0_0_1_0_0_1 - 0.221340388007055*G0_0_1_1_0_0 - 0.221340388007054*G0_0_1_2_0_1 + 0.151675485008818*G0_0_1_3_0_0 + 0.151675485008818*G0_0_1_3_0_1 - 0.151675485008818*G0_0_1_4_0_0 + 1.03703703703704*G0_0_1_4_0_1 + 1.03703703703704*G0_0_1_5_0_0 - 0.151675485008818*G0_0_1_5_0_1 - 0.815696649029982*G0_0_1_6_1_0 - 0.815696649029982*G0_0_1_6_1_1 - 0.221340388007055*G0_0_1_7_1_0 - 0.221340388007054*G0_0_1_8_1_1 + 0.151675485008818*G0_0_1_9_1_0 + 0.151675485008818*G0_0_1_9_1_1 - 0.151675485008818*G0_0_1_10_1_0 + 1.03703703703704*G0_0_1_10_1_1 + 1.03703703703704*G0_0_1_11_1_0 - 0.151675485008818*G0_0_1_11_1_1 - 0.815696649029982*G0_1_0_0_0_0 - 0.815696649029982*G0_1_0_0_0_1 - 0.221340388007055*G0_1_0_1_0_0 - 0.221340388007054*G0_1_0_2_0_1 + 0.151675485008818*G0_1_0_3_0_0 + 0.151675485008818*G0_1_0_3_0_1 - 0.151675485008818*G0_1_0_4_0_0 + 1.03703703703704*G0_1_0_4_0_1 + 1.03703703703704*G0_1_0_5_0_0 - 0.151675485008818*G0_1_0_5_0_1 - 0.815696649029982*G0_1_0_6_1_0 - 0.815696649029982*G0_1_0_6_1_1 - 0.221340388007055*G0_1_0_7_1_0 - 0.221340388007054*G0_1_0_8_1_1 + 0.151675485008818*G0_1_0_9_1_0 + 0.151675485008818*G0_1_0_9_1_1 - 0.151675485008818*G0_1_0_10_1_0 + 1.03703703703704*G0_1_0_10_1_1 + 1.03703703703704*G0_1_0_11_1_0 - 0.151675485008818*G0_1_0_11_1_1 - 1.03703703703704*G0_1_1_0_0_0 - 1.03703703703704*G0_1_1_0_0_1 - 1.03703703703704*G0_1_1_2_0_1 - 1.03703703703704*G0_1_1_3_0_0 + 1.03703703703704*G0_1_1_4_0_0 + 2.07407407407407*G0_1_1_4_0_1 + 1.03703703703704*G0_1_1_5_0_0 - 1.03703703703704*G0_1_1_6_1_0 - 1.03703703703704*G0_1_1_6_1_1 - 1.03703703703704*G0_1_1_8_1_1 - 1.03703703703704*G0_1_1_9_1_0 + 1.03703703703704*G0_1_1_10_1_0 + 2.07407407407407*G0_1_1_10_1_1 + 1.03703703703704*G0_1_1_11_1_0;
    A[76] = 0.0;
    A[0] = A[465];
    A[43] = A[509] - 0.541798941798941*G0_0_0_0_0_0 - 0.541798941798941*G0_0_0_0_0_1 - 1.35449735449735*G0_0_0_1_0_0 + 0.812698412698411*G0_0_0_2_0_1 + 0.812698412698411*G0_0_0_3_0_0 - 1.35449735449735*G0_0_0_3_0_1 - 0.812698412698411*G0_0_0_4_0_0 - 0.27089947089947*G0_0_0_4_0_1 + 1.89629629629629*G0_0_0_5_0_0 + 1.35449735449735*G0_0_0_5_0_1 - 0.541798941798941*G0_0_0_6_1_0 - 0.541798941798941*G0_0_0_6_1_1 - 1.35449735449735*G0_0_0_7_1_0 + 0.812698412698411*G0_0_0_8_1_1 + 0.812698412698411*G0_0_0_9_1_0 - 1.35449735449735*G0_0_0_9_1_1 - 0.812698412698411*G0_0_0_10_1_0 - 0.27089947089947*G0_0_0_10_1_1 + 1.89629629629629*G0_0_0_11_1_0 + 1.35449735449735*G0_0_0_11_1_1;
    A[843] = 0.0;
    A[70] = 0.0204585537918867*G0_1_0_0_0_0 + 0.0204585537918867*G0_1_0_0_0_1 + 0.0204585537918872*G0_1_0_1_0_0 + 0.0204585537918869*G0_1_0_3_0_1 - 0.0204585537918859*G0_1_0_4_0_1 - 0.0409171075837739*G0_1_0_5_0_0 - 0.0204585537918869*G0_1_0_5_0_1 + 0.0204585537918867*G0_1_0_6_1_0 + 0.0204585537918867*G0_1_0_6_1_1 + 0.0204585537918872*G0_1_0_7_1_0 + 0.0204585537918869*G0_1_0_9_1_1 - 0.0204585537918859*G0_1_0_10_1_1 - 0.0409171075837739*G0_1_0_11_1_0 - 0.0204585537918869*G0_1_0_11_1_1 - 0.0514991181657851*G0_1_1_0_0_0 - 0.051499118165785*G0_1_1_0_0_1 + 0.0719576719576718*G0_1_1_1_0_0 - 0.0811287477954142*G0_1_1_2_0_1 - 0.0388007054673717*G0_1_1_3_0_0 + 0.114285714285714*G0_1_1_3_0_1 + 0.0388007054673717*G0_1_1_4_0_0 + 0.132627865961199*G0_1_1_4_0_1 - 0.0204585537918867*G0_1_1_5_0_0 - 0.114285714285714*G0_1_1_5_0_1 - 0.0514991181657851*G0_1_1_6_1_0 - 0.051499118165785*G0_1_1_6_1_1 + 0.0719576719576718*G0_1_1_7_1_0 - 0.0811287477954142*G0_1_1_8_1_1 - 0.0388007054673717*G0_1_1_9_1_0 + 0.114285714285714*G0_1_1_9_1_1 + 0.0388007054673717*G0_1_1_10_1_0 + 0.132627865961199*G0_1_1_10_1_1 - 0.0204585537918867*G0_1_1_11_1_0 - 0.114285714285714*G0_1_1_11_1_1;
    A[469] = A[70] + 0.0811287477954147*G0_0_0_0_0_0 + 0.0811287477954147*G0_0_0_0_0_1 + 0.0514991181657847*G0_0_0_1_0_0 + 0.0719576719576717*G0_0_0_2_0_1 + 0.114285714285713*G0_0_0_3_0_0 + 0.0938271604938264*G0_0_0_3_0_1 - 0.114285714285713*G0_0_0_4_0_0 - 0.153086419753086*G0_0_0_4_0_1 - 0.132627865961199*G0_0_0_5_0_0 - 0.0938271604938264*G0_0_0_5_0_1 + 0.0811287477954147*G0_0_0_6_1_0 + 0.0811287477954147*G0_0_0_6_1_1 + 0.0514991181657847*G0_0_0_7_1_0 + 0.0719576719576717*G0_0_0_8_1_1 + 0.114285714285713*G0_0_0_9_1_0 + 0.0938271604938264*G0_0_0_9_1_1 - 0.114285714285713*G0_0_0_10_1_0 - 0.153086419753086*G0_0_0_10_1_1 - 0.132627865961199*G0_0_0_11_1_0 - 0.0938271604938264*G0_0_0_11_1_1 + 0.0811287477954147*G0_0_1_0_0_0 + 0.0811287477954147*G0_0_1_0_0_1 + 0.0719576719576711*G0_0_1_1_0_0 + 0.051499118165785*G0_0_1_2_0_1 + 0.0938271604938264*G0_0_1_3_0_0 + 0.114285714285713*G0_0_1_3_0_1 - 0.0938271604938264*G0_0_1_4_0_0 - 0.1326278659612*G0_0_1_4_0_1 - 0.153086419753086*G0_0_1_5_0_0 - 0.114285714285712*G0_0_1_5_0_1 + 0.0811287477954147*G0_0_1_6_1_0 + 0.0811287477954147*G0_0_1_6_1_1 + 0.0719576719576711*G0_0_1_7_1_0 + 0.051499118165785*G0_0_1_8_1_1 + 0.0938271604938264*G0_0_1_9_1_0 + 0.114285714285713*G0_0_1_9_1_1 - 0.0938271604938264*G0_0_1_10_1_0 - 0.1326278659612*G0_0_1_10_1_1 - 0.153086419753086*G0_0_1_11_1_0 - 0.114285714285712*G0_0_1_11_1_1 + 0.0606701940035279*G0_1_0_0_0_0 + 0.0606701940035279*G0_1_0_0_0_1 + 0.0310405643738977*G0_1_0_1_0_0 + 0.071957671957672*G0_1_0_2_0_1 + 0.114285714285714*G0_1_0_3_0_0 + 0.0733686067019394*G0_1_0_3_0_1 - 0.114285714285714*G0_1_0_4_0_0 - 0.1326278659612*G0_1_0_4_0_1 - 0.0917107583774256*G0_1_0_5_0_0 - 0.0733686067019394*G0_1_0_5_0_1 + 0.0606701940035279*G0_1_0_6_1_0 + 0.0606701940035279*G0_1_0_6_1_1 + 0.0310405643738977*G0_1_0_7_1_0 + 0.071957671957672*G0_1_0_8_1_1 + 0.114285714285714*G0_1_0_9_1_0 + 0.0733686067019394*G0_1_0_9_1_1 - 0.114285714285714*G0_1_0_10_1_0 - 0.1326278659612*G0_1_0_10_1_1 - 0.0917107583774256*G0_1_0_11_1_0 - 0.0733686067019394*G0_1_0_11_1_1 + 0.1326278659612*G0_1_1_0_0_0 + 0.1326278659612*G0_1_1_0_0_1 + 0.132627865961199*G0_1_1_2_0_1 + 0.132627865961198*G0_1_1_3_0_0 - 0.132627865961198*G0_1_1_4_0_0 - 0.265255731922399*G0_1_1_4_0_1 - 0.132627865961199*G0_1_1_5_0_0 + 0.1326278659612*G0_1_1_6_1_0 + 0.1326278659612*G0_1_1_6_1_1 + 0.132627865961199*G0_1_1_8_1_1 + 0.132627865961198*G0_1_1_9_1_0 - 0.132627865961198*G0_1_1_10_1_0 - 0.265255731922399*G0_1_1_10_1_1 - 0.132627865961199*G0_1_1_11_1_0;
    A[585] = A[469] - 0.0204585537918863*G0_0_1_1_0_0 + 0.0204585537918862*G0_0_1_2_0_1 + 0.0204585537918862*G0_0_1_3_0_0 - 0.0204585537918863*G0_0_1_3_0_1 - 0.0204585537918862*G0_0_1_4_0_0 - 0.0204585537918862*G0_0_1_4_0_1 + 0.0204585537918863*G0_0_1_5_0_0 + 0.0204585537918863*G0_0_1_5_0_1 - 0.0204585537918863*G0_0_1_7_1_0 + 0.0204585537918862*G0_0_1_8_1_1 + 0.0204585537918862*G0_0_1_9_1_0 - 0.0204585537918863*G0_0_1_9_1_1 - 0.0204585537918862*G0_0_1_10_1_0 - 0.0204585537918862*G0_0_1_10_1_1 + 0.0204585537918863*G0_0_1_11_1_0 + 0.0204585537918863*G0_0_1_11_1_1 + 0.0204585537918862*G0_1_0_1_0_0 - 0.0204585537918862*G0_1_0_2_0_1 - 0.0204585537918862*G0_1_0_3_0_0 + 0.0204585537918863*G0_1_0_3_0_1 + 0.0204585537918862*G0_1_0_4_0_0 + 0.0204585537918862*G0_1_0_4_0_1 - 0.0204585537918862*G0_1_0_5_0_0 - 0.0204585537918863*G0_1_0_5_0_1 + 0.0204585537918862*G0_1_0_7_1_0 - 0.0204585537918862*G0_1_0_8_1_1 - 0.0204585537918862*G0_1_0_9_1_0 + 0.0204585537918863*G0_1_0_9_1_1 + 0.0204585537918862*G0_1_0_10_1_0 + 0.0204585537918862*G0_1_0_10_1_1 - 0.0204585537918862*G0_1_0_11_1_0 - 0.0204585537918863*G0_1_0_11_1_1;
    A[165] = 0.0;
    A[872] = 0.0;
    A[109] = 0.0;
    A[140] = 0.0;
    A[514] = 0.0;
    A[543] = 0.0;
    A[665] = 0.0;
    A[690] = 0.0;
    A[267] = 0.0;
    A[296] = 0.0;
    A[437] = 0.0;
    A[361] = A[421] + 0.27089947089947*G0_0_0_0_0_0 + 0.27089947089947*G0_0_0_0_0_1 + 0.27089947089947*G0_0_0_2_0_1 + 0.27089947089947*G0_0_0_3_0_0 - 0.27089947089947*G0_0_0_4_0_0 - 0.541798941798939*G0_0_0_4_0_1 - 0.27089947089947*G0_0_0_5_0_0 + 0.27089947089947*G0_0_0_6_1_0 + 0.27089947089947*G0_0_0_6_1_1 + 0.27089947089947*G0_0_0_8_1_1 + 0.27089947089947*G0_0_0_9_1_0 - 0.27089947089947*G0_0_0_10_1_0 - 0.541798941798939*G0_0_0_10_1_1 - 0.27089947089947*G0_0_0_11_1_0;
    A[317] = 0.0;
    A[470] = A[5];
    A[358] = 0.0;
    A[7] = A[765] + 1.04338624338624*G0_0_0_0_0_0 + 1.04338624338624*G0_0_0_0_0_1 + 0.0444444444444449*G0_0_0_1_0_0 + 0.573544973544974*G0_0_0_2_0_1 + 0.148148148148149*G0_0_0_3_0_0 - 0.380952380952381*G0_0_0_3_0_1 - 0.148148148148149*G0_0_0_4_0_0 - 1.61693121693122*G0_0_0_4_0_1 - 1.08783068783069*G0_0_0_5_0_0 + 0.380952380952381*G0_0_0_5_0_1 + 1.04338624338624*G0_0_0_6_1_0 + 1.04338624338624*G0_0_0_6_1_1 + 0.0444444444444449*G0_0_0_7_1_0 + 0.573544973544974*G0_0_0_8_1_1 + 0.148148148148149*G0_0_0_9_1_0 - 0.380952380952381*G0_0_0_9_1_1 - 0.148148148148149*G0_0_0_10_1_0 - 1.61693121693122*G0_0_0_10_1_1 - 1.08783068783069*G0_0_0_11_1_0 + 0.380952380952381*G0_0_0_11_1_1 - 0.250440917107583*G0_0_1_1_0_0 + 0.250440917107584*G0_0_1_2_0_1 + 0.250440917107584*G0_0_1_3_0_0 - 0.250440917107583*G0_0_1_3_0_1 - 0.250440917107584*G0_0_1_4_0_0 - 0.250440917107587*G0_0_1_4_0_1 + 0.250440917107581*G0_0_1_5_0_0 + 0.250440917107583*G0_0_1_5_0_1 - 0.250440917107583*G0_0_1_7_1_0 + 0.250440917107584*G0_0_1_8_1_1 + 0.250440917107584*G0_0_1_9_1_0 - 0.250440917107583*G0_0_1_9_1_1 - 0.250440917107584*G0_0_1_10_1_0 - 0.250440917107587*G0_0_1_10_1_1 + 0.250440917107581*G0_0_1_11_1_0 + 0.250440917107583*G0_0_1_11_1_1 - 0.278659611992945*G0_1_0_1_0_0 + 0.278659611992947*G0_1_0_2_0_1 + 0.278659611992946*G0_1_0_3_0_0 - 0.278659611992945*G0_1_0_3_0_1 - 0.278659611992946*G0_1_0_4_0_0 - 0.278659611992949*G0_1_0_4_0_1 + 0.278659611992942*G0_1_0_5_0_0 + 0.278659611992945*G0_1_0_5_0_1 - 0.278659611992945*G0_1_0_7_1_0 + 0.278659611992947*G0_1_0_8_1_1 + 0.278659611992946*G0_1_0_9_1_0 - 0.278659611992945*G0_1_0_9_1_1 - 0.278659611992946*G0_1_0_10_1_0 - 0.278659611992949*G0_1_0_10_1_1 + 0.278659611992942*G0_1_0_11_1_0 + 0.278659611992945*G0_1_0_11_1_1 - 1.04338624338624*G0_1_1_0_0_0 - 1.04338624338624*G0_1_1_0_0_1 - 0.573544973544972*G0_1_1_1_0_0 - 0.0444444444444432*G0_1_1_2_0_1 + 0.380952380952381*G0_1_1_3_0_0 - 0.148148148148147*G0_1_1_3_0_1 - 0.380952380952381*G0_1_1_4_0_0 + 1.08783068783068*G0_1_1_4_0_1 + 1.61693121693121*G0_1_1_5_0_0 + 0.148148148148147*G0_1_1_5_0_1 - 1.04338624338624*G0_1_1_6_1_0 - 1.04338624338624*G0_1_1_6_1_1 - 0.573544973544972*G0_1_1_7_1_0 - 0.0444444444444432*G0_1_1_8_1_1 + 0.380952380952381*G0_1_1_9_1_0 - 0.148148148148147*G0_1_1_9_1_1 - 0.380952380952381*G0_1_1_10_1_0 + 1.08783068783068*G0_1_1_10_1_1 + 1.61693121693121*G0_1_1_11_1_0 + 0.148148148148147*G0_1_1_11_1_1;
    A[724] = 0.0;
    A[827] = A[887] + 0.812698412698414*G0_1_1_0_0_0 + 0.812698412698414*G0_1_1_0_0_1 - 0.541798941798942*G0_1_1_1_0_0 + 1.35449735449736*G0_1_1_2_0_1 + 1.35449735449736*G0_1_1_3_0_0 - 0.54179894179894*G0_1_1_3_0_1 - 1.35449735449736*G0_1_1_4_0_0 - 2.16719576719577*G0_1_1_4_0_1 - 0.270899470899472*G0_1_1_5_0_0 + 0.54179894179894*G0_1_1_5_0_1 + 0.812698412698414*G0_1_1_6_1_0 + 0.812698412698414*G0_1_1_6_1_1 - 0.541798941798942*G0_1_1_7_1_0 + 1.35449735449736*G0_1_1_8_1_1 + 1.35449735449736*G0_1_1_9_1_0 - 0.54179894179894*G0_1_1_9_1_1 - 1.35449735449736*G0_1_1_10_1_0 - 2.16719576719577*G0_1_1_10_1_1 - 0.270899470899472*G0_1_1_11_1_0 + 0.54179894179894*G0_1_1_11_1_1;
    A[72] = A[827] + 0.0282186948853606*G0_0_1_0_0_0 + 0.0282186948853606*G0_0_1_0_0_1 + 0.0282186948853616*G0_0_1_1_0_0 + 0.0282186948853607*G0_0_1_3_0_1 - 0.0282186948853586*G0_0_1_4_0_1 - 0.0564373897707222*G0_0_1_5_0_0 - 0.0282186948853607*G0_0_1_5_0_1 + 0.0282186948853606*G0_0_1_6_1_0 + 0.0282186948853606*G0_0_1_6_1_1 + 0.0282186948853616*G0_0_1_7_1_0 + 0.0282186948853607*G0_0_1_9_1_1 - 0.0282186948853586*G0_0_1_10_1_1 - 0.0564373897707222*G0_0_1_11_1_0 - 0.0282186948853607*G0_0_1_11_1_1 - 0.0282186948853607*G0_1_0_0_0_0 - 0.0282186948853606*G0_1_0_0_0_1 - 0.0282186948853616*G0_1_0_1_0_0 - 0.0282186948853606*G0_1_0_3_0_1 + 0.0282186948853586*G0_1_0_4_0_1 + 0.0564373897707223*G0_1_0_5_0_0 + 0.0282186948853607*G0_1_0_5_0_1 - 0.0282186948853607*G0_1_0_6_1_0 - 0.0282186948853606*G0_1_0_6_1_1 - 0.0282186948853616*G0_1_0_7_1_0 - 0.0282186948853606*G0_1_0_9_1_1 + 0.0282186948853586*G0_1_0_10_1_1 + 0.0564373897707223*G0_1_0_11_1_0 + 0.0282186948853607*G0_1_0_11_1_1;
    A[36] = A[181] + 0.0310405643738986*G0_0_1_0_0_0 + 0.0310405643738986*G0_0_1_0_0_1 + 0.0310405643738977*G0_0_1_2_0_1 + 0.0310405643738978*G0_0_1_3_0_0 - 0.0310405643738978*G0_0_1_4_0_0 - 0.0620811287477962*G0_0_1_4_0_1 - 0.0310405643738996*G0_0_1_5_0_0 + 0.0310405643738986*G0_0_1_6_1_0 + 0.0310405643738986*G0_0_1_6_1_1 + 0.0310405643738977*G0_0_1_8_1_1 + 0.0310405643738978*G0_0_1_9_1_0 - 0.0310405643738978*G0_0_1_10_1_0 - 0.0620811287477962*G0_0_1_10_1_1 - 0.0310405643738996*G0_0_1_11_1_0 - 0.0310405643738986*G0_1_0_0_0_0 - 0.0310405643738986*G0_1_0_0_0_1 - 0.0310405643738977*G0_1_0_2_0_1 - 0.0310405643738978*G0_1_0_3_0_0 + 0.0310405643738978*G0_1_0_4_0_0 + 0.0620811287477962*G0_1_0_4_0_1 + 0.0310405643738996*G0_1_0_5_0_0 - 0.0310405643738986*G0_1_0_6_1_0 - 0.0310405643738986*G0_1_0_6_1_1 - 0.0310405643738977*G0_1_0_8_1_1 - 0.0310405643738978*G0_1_0_9_1_0 + 0.0310405643738978*G0_1_0_10_1_0 + 0.0620811287477962*G0_1_0_10_1_1 + 0.0310405643738996*G0_1_0_11_1_0;
    A[751] = 0.0;
    A[65] = A[530];
    A[786] = 0.0;
    A[114] = 0.0;
    A[139] = 0.0;
    A[168] = 0.0;
    A[502] = -0.0514991181657851*G0_0_0_0_0_0 - 0.0514991181657851*G0_0_0_0_0_1 - 0.0811287477954157*G0_0_0_1_0_0 + 0.0719576719576722*G0_0_0_2_0_1 + 0.114285714285714*G0_0_0_3_0_0 - 0.038800705467374*G0_0_0_3_0_1 - 0.114285714285714*G0_0_0_4_0_0 - 0.020458553791887*G0_0_0_4_0_1 + 0.132627865961201*G0_0_0_5_0_0 + 0.038800705467374*G0_0_0_5_0_1 - 0.0514991181657851*G0_0_0_6_1_0 - 0.0514991181657851*G0_0_0_6_1_1 - 0.0811287477954157*G0_0_0_7_1_0 + 0.0719576719576722*G0_0_0_8_1_1 + 0.114285714285714*G0_0_0_9_1_0 - 0.038800705467374*G0_0_0_9_1_1 - 0.114285714285714*G0_0_0_10_1_0 - 0.020458553791887*G0_0_0_10_1_1 + 0.132627865961201*G0_0_0_11_1_0 + 0.038800705467374*G0_0_0_11_1_1 + 0.020458553791886*G0_0_1_0_0_0 + 0.020458553791886*G0_0_1_0_0_1 + 0.0204585537918875*G0_0_1_2_0_1 + 0.0204585537918871*G0_0_1_3_0_0 - 0.0204585537918871*G0_0_1_4_0_0 - 0.0409171075837735*G0_0_1_4_0_1 - 0.0204585537918841*G0_0_1_5_0_0 + 0.020458553791886*G0_0_1_6_1_0 + 0.020458553791886*G0_0_1_6_1_1 + 0.0204585537918875*G0_0_1_8_1_1 + 0.0204585537918871*G0_0_1_9_1_0 - 0.0204585537918871*G0_0_1_10_1_0 - 0.0409171075837735*G0_0_1_10_1_1 - 0.0204585537918841*G0_0_1_11_1_0;
    A[205] = 0.0;
    A[573] = 0.0;
    A[533] = -A[530] - 0.0451499118165791*G0_1_1_0_0_0 - 0.0451499118165791*G0_1_1_0_0_1 + 0.0451499118165782*G0_1_1_1_0_0 - 0.615167548500882*G0_1_1_2_0_1 - 1.14003527336861*G0_1_1_3_0_0 - 0.479717813051146*G0_1_1_3_0_1 + 1.14003527336861*G0_1_1_4_0_0 + 0.660317460317461*G0_1_1_4_0_1 + 0.479717813051146*G0_1_1_5_0_1 - 0.0451499118165791*G0_1_1_6_1_0 - 0.0451499118165791*G0_1_1_6_1_1 + 0.0451499118165782*G0_1_1_7_1_0 - 0.615167548500882*G0_1_1_8_1_1 - 1.14003527336861*G0_1_1_9_1_0 - 0.479717813051146*G0_1_1_9_1_1 + 1.14003527336861*G0_1_1_10_1_0 + 0.660317460317461*G0_1_1_10_1_1 + 0.479717813051146*G0_1_1_11_1_1;
    A[238] = 0.0;
    A[604] = 0.0;
    A[715] = -A[625] - 0.12416225749559*G0_1_0_0_0_0 - 0.12416225749559*G0_1_0_0_0_1 - 0.124162257495589*G0_1_0_1_0_0 - 0.124162257495588*G0_1_0_3_0_1 + 0.124162257495589*G0_1_0_4_0_1 + 0.248324514991179*G0_1_0_5_0_0 + 0.124162257495588*G0_1_0_5_0_1 - 0.12416225749559*G0_1_0_6_1_0 - 0.12416225749559*G0_1_0_6_1_1 - 0.124162257495589*G0_1_0_7_1_0 - 0.124162257495588*G0_1_0_9_1_1 + 0.124162257495589*G0_1_0_10_1_1 + 0.248324514991179*G0_1_0_11_1_0 + 0.124162257495588*G0_1_0_11_1_1 + 0.2652557319224*G0_1_1_0_0_0 + 0.2652557319224*G0_1_1_0_0_1 - 0.389417989417987*G0_1_1_1_0_0 + 0.434567901234568*G0_1_1_2_0_1 + 0.21446208112875*G0_1_1_3_0_0 - 0.609523809523806*G0_1_1_3_0_1 - 0.21446208112875*G0_1_1_4_0_0 - 0.699823633156968*G0_1_1_4_0_1 + 0.124162257495587*G0_1_1_5_0_0 + 0.609523809523806*G0_1_1_5_0_1 + 0.2652557319224*G0_1_1_6_1_0 + 0.2652557319224*G0_1_1_6_1_1 - 0.389417989417987*G0_1_1_7_1_0 + 0.434567901234568*G0_1_1_8_1_1 + 0.21446208112875*G0_1_1_9_1_0 - 0.609523809523806*G0_1_1_9_1_1 - 0.21446208112875*G0_1_1_10_1_0 - 0.699823633156968*G0_1_1_10_1_1 + 0.124162257495587*G0_1_1_11_1_0 + 0.609523809523806*G0_1_1_11_1_1;
    A[242] = A[533] - 0.595414462081129*G0_0_1_0_0_0 - 0.595414462081129*G0_0_1_0_0_1 + 0.595414462081129*G0_0_1_1_0_0 - 1.96966490299823*G0_0_1_2_0_1 - 2.74850088183421*G0_0_1_3_0_0 - 0.183421516754849*G0_0_1_3_0_1 + 2.74850088183421*G0_0_1_4_0_0 + 2.56507936507936*G0_0_1_4_0_1 + 0.183421516754849*G0_0_1_5_0_1 - 0.595414462081129*G0_0_1_6_1_0 - 0.595414462081129*G0_0_1_6_1_1 + 0.595414462081129*G0_0_1_7_1_0 - 1.96966490299823*G0_0_1_8_1_1 - 2.74850088183421*G0_0_1_9_1_0 - 0.183421516754849*G0_0_1_9_1_1 + 2.74850088183421*G0_0_1_10_1_0 + 2.56507936507936*G0_0_1_10_1_1 + 0.183421516754849*G0_0_1_11_1_1 + 0.595414462081129*G0_1_0_0_0_0 + 0.595414462081129*G0_1_0_0_0_1 - 0.595414462081129*G0_1_0_1_0_0 + 1.96966490299824*G0_1_0_2_0_1 + 2.74850088183421*G0_1_0_3_0_0 + 0.183421516754849*G0_1_0_3_0_1 - 2.74850088183421*G0_1_0_4_0_0 - 2.56507936507936*G0_1_0_4_0_1 - 0.183421516754849*G0_1_0_5_0_1 + 0.595414462081129*G0_1_0_6_1_0 + 0.595414462081129*G0_1_0_6_1_1 - 0.595414462081129*G0_1_0_7_1_0 + 1.96966490299824*G0_1_0_8_1_1 + 2.74850088183421*G0_1_0_9_1_0 + 0.183421516754849*G0_1_0_9_1_1 - 2.74850088183421*G0_1_0_10_1_0 - 2.56507936507936*G0_1_0_10_1_1 - 0.183421516754849*G0_1_0_11_1_1;
    A[444] = 0.0;
    A[324] = 0.0;
    A[479] = A[14];
    A[351] = 0.0;
    A[731] = 0.0;
    A[422] = A[887];
    A[382] = 0.0;
    A[760] = 0.0;
    A[413] = 0.0;
    A[857] = A[827] - 0.270899470899472*G0_1_1_0_0_0 - 0.270899470899472*G0_1_1_0_0_1 - 0.270899470899471*G0_1_1_1_0_0 - 0.270899470899473*G0_1_1_3_0_1 + 0.270899470899475*G0_1_1_4_0_1 + 0.541798941798942*G0_1_1_5_0_0 + 0.270899470899473*G0_1_1_5_0_1 - 0.270899470899472*G0_1_1_6_1_0 - 0.270899470899472*G0_1_1_6_1_1 - 0.270899470899471*G0_1_1_7_1_0 - 0.270899470899473*G0_1_1_9_1_1 + 0.270899470899475*G0_1_1_10_1_1 + 0.541798941798942*G0_1_1_11_1_0 + 0.270899470899473*G0_1_1_11_1_1;
    A[88] = 0.0;
    A[781] = 0.0;
    A[91] = -A[331] - 0.0451499118165792*G0_0_0_0_0_0 - 0.0451499118165794*G0_0_0_0_0_1 - 0.615167548500884*G0_0_0_1_0_0 + 0.0451499118165795*G0_0_0_2_0_1 - 0.479717813051145*G0_0_0_3_0_0 - 1.14003527336861*G0_0_0_3_0_1 + 0.479717813051145*G0_0_0_4_0_0 + 0.660317460317463*G0_0_0_5_0_0 + 1.14003527336861*G0_0_0_5_0_1 - 0.0451499118165792*G0_0_0_6_1_0 - 0.0451499118165794*G0_0_0_6_1_1 - 0.615167548500884*G0_0_0_7_1_0 + 0.0451499118165795*G0_0_0_8_1_1 - 0.479717813051145*G0_0_0_9_1_0 - 1.14003527336861*G0_0_0_9_1_1 + 0.479717813051145*G0_0_0_10_1_0 + 0.660317460317463*G0_0_0_11_1_0 + 1.14003527336861*G0_0_0_11_1_1;
    A[822] = 0.0;
    A[146] = 0.0;
    A[855] = A[14] - 0.270899470899469*G0_0_0_1_0_0 + 0.270899470899471*G0_0_0_2_0_1 + 0.270899470899471*G0_0_0_3_0_0 - 0.270899470899469*G0_0_0_3_0_1 - 0.270899470899471*G0_0_0_4_0_0 - 0.270899470899473*G0_0_0_4_0_1 + 0.270899470899467*G0_0_0_5_0_0 + 0.270899470899469*G0_0_0_5_0_1 - 0.270899470899469*G0_0_0_7_1_0 + 0.270899470899471*G0_0_0_8_1_1 + 0.270899470899471*G0_0_0_9_1_0 - 0.270899470899469*G0_0_0_9_1_1 - 0.270899470899471*G0_0_0_10_1_0 - 0.270899470899473*G0_0_0_10_1_1 + 0.270899470899467*G0_0_0_11_1_0 + 0.270899470899469*G0_0_0_11_1_1 - 0.242680776014107*G0_0_1_1_0_0 + 0.24268077601411*G0_0_1_2_0_1 + 0.242680776014109*G0_0_1_3_0_0 - 0.242680776014107*G0_0_1_3_0_1 - 0.242680776014109*G0_0_1_4_0_0 - 0.242680776014113*G0_0_1_4_0_1 + 0.242680776014104*G0_0_1_5_0_0 + 0.242680776014107*G0_0_1_5_0_1 - 0.242680776014107*G0_0_1_7_1_0 + 0.24268077601411*G0_0_1_8_1_1 + 0.242680776014109*G0_0_1_9_1_0 - 0.242680776014107*G0_0_1_9_1_1 - 0.242680776014109*G0_0_1_10_1_0 - 0.242680776014113*G0_0_1_10_1_1 + 0.242680776014104*G0_0_1_11_1_0 + 0.242680776014107*G0_0_1_11_1_1 - 0.29911816578483*G0_1_0_1_0_0 + 0.299118165784834*G0_1_0_2_0_1 + 0.299118165784833*G0_1_0_3_0_0 - 0.299118165784831*G0_1_0_3_0_1 - 0.299118165784833*G0_1_0_4_0_0 - 0.299118165784837*G0_1_0_4_0_1 + 0.299118165784826*G0_1_0_5_0_0 + 0.299118165784831*G0_1_0_5_0_1 - 0.29911816578483*G0_1_0_7_1_0 + 0.299118165784834*G0_1_0_8_1_1 + 0.299118165784833*G0_1_0_9_1_0 - 0.299118165784831*G0_1_0_9_1_1 - 0.299118165784833*G0_1_0_10_1_0 - 0.299118165784837*G0_1_0_10_1_1 + 0.299118165784826*G0_1_0_11_1_0 + 0.299118165784831*G0_1_0_11_1_1 - 0.270899470899468*G0_1_1_1_0_0 + 0.270899470899472*G0_1_1_2_0_1 + 0.270899470899472*G0_1_1_3_0_0 - 0.270899470899469*G0_1_1_3_0_1 - 0.270899470899472*G0_1_1_4_0_0 - 0.270899470899478*G0_1_1_4_0_1 + 0.270899470899463*G0_1_1_5_0_0 + 0.270899470899469*G0_1_1_5_0_1 - 0.270899470899468*G0_1_1_7_1_0 + 0.270899470899472*G0_1_1_8_1_1 + 0.270899470899472*G0_1_1_9_1_0 - 0.270899470899469*G0_1_1_9_1_1 - 0.270899470899472*G0_1_1_10_1_0 - 0.270899470899478*G0_1_1_10_1_1 + 0.270899470899463*G0_1_1_11_1_0 + 0.270899470899469*G0_1_1_11_1_1;
    A[177] = 0.0;
    A[884] = 0.0;
    A[493] = 0.0;
    A[196] = 0.0;
    A[578] = 0.0;
    A[518] = 0.0;
    A[231] = 0.0;
    A[603] = 0.0;
    A[555] = A[5] + 0.146737213403879*G0_0_0_1_0_0 - 0.14673721340388*G0_0_0_2_0_1 - 0.146737213403881*G0_0_0_3_0_0 + 0.146737213403879*G0_0_0_3_0_1 + 0.146737213403881*G0_0_0_4_0_0 + 0.14673721340388*G0_0_0_4_0_1 - 0.146737213403879*G0_0_0_5_0_0 - 0.146737213403879*G0_0_0_5_0_1 + 0.146737213403879*G0_0_0_7_1_0 - 0.14673721340388*G0_0_0_8_1_1 - 0.146737213403881*G0_0_0_9_1_0 + 0.146737213403879*G0_0_0_9_1_1 + 0.146737213403881*G0_0_0_10_1_0 + 0.14673721340388*G0_0_0_10_1_1 - 0.146737213403879*G0_0_0_11_1_0 - 0.146737213403879*G0_0_0_11_1_1 + 0.115696649029981*G0_0_1_1_0_0 - 0.115696649029982*G0_0_1_2_0_1 - 0.115696649029982*G0_0_1_3_0_0 + 0.115696649029981*G0_0_1_3_0_1 + 0.115696649029982*G0_0_1_4_0_0 + 0.115696649029982*G0_0_1_4_0_1 - 0.115696649029981*G0_0_1_5_0_0 - 0.115696649029981*G0_0_1_5_0_1 + 0.115696649029981*G0_0_1_7_1_0 - 0.115696649029982*G0_0_1_8_1_1 - 0.115696649029982*G0_0_1_9_1_0 + 0.115696649029981*G0_0_1_9_1_1 + 0.115696649029982*G0_0_1_10_1_0 + 0.115696649029982*G0_0_1_10_1_1 - 0.115696649029981*G0_0_1_11_1_0 - 0.115696649029981*G0_0_1_11_1_1 + 0.177777777777778*G0_1_0_1_0_0 - 0.177777777777779*G0_1_0_2_0_1 - 0.17777777777778*G0_1_0_3_0_0 + 0.177777777777777*G0_1_0_3_0_1 + 0.17777777777778*G0_1_0_4_0_0 + 0.177777777777779*G0_1_0_4_0_1 - 0.177777777777778*G0_1_0_5_0_0 - 0.177777777777777*G0_1_0_5_0_1 + 0.177777777777778*G0_1_0_7_1_0 - 0.177777777777779*G0_1_0_8_1_1 - 0.17777777777778*G0_1_0_9_1_0 + 0.177777777777777*G0_1_0_9_1_1 + 0.17777777777778*G0_1_0_10_1_0 + 0.177777777777779*G0_1_0_10_1_1 - 0.177777777777778*G0_1_0_11_1_0 - 0.177777777777777*G0_1_0_11_1_1 + 0.14673721340388*G0_1_1_1_0_0 - 0.14673721340388*G0_1_1_2_0_1 - 0.14673721340388*G0_1_1_3_0_0 + 0.146737213403879*G0_1_1_3_0_1 + 0.14673721340388*G0_1_1_4_0_0 + 0.146737213403879*G0_1_1_4_0_1 - 0.14673721340388*G0_1_1_5_0_0 - 0.146737213403879*G0_1_1_5_0_1 + 0.14673721340388*G0_1_1_7_1_0 - 0.14673721340388*G0_1_1_8_1_1 - 0.14673721340388*G0_1_1_9_1_0 + 0.146737213403879*G0_1_1_9_1_1 + 0.14673721340388*G0_1_1_10_1_0 + 0.146737213403879*G0_1_1_10_1_1 - 0.14673721340388*G0_1_1_11_1_0 - 0.146737213403879*G0_1_1_11_1_1;
    A[632] = 0.0;
    A[669] = 0.0;
    A[274] = A[625] - 0.203174603174602*G0_0_0_0_0_0 - 0.203174603174602*G0_0_0_0_0_1 - 0.0677248677248682*G0_0_0_1_0_0 - 0.203174603174601*G0_0_0_2_0_1 - 0.270899470899468*G0_0_0_3_0_0 - 0.135449735449735*G0_0_0_3_0_1 + 0.270899470899468*G0_0_0_4_0_0 + 0.406349206349204*G0_0_0_4_0_1 + 0.270899470899471*G0_0_0_5_0_0 + 0.135449735449735*G0_0_0_5_0_1 - 0.203174603174602*G0_0_0_6_1_0 - 0.203174603174602*G0_0_0_6_1_1 - 0.0677248677248682*G0_0_0_7_1_0 - 0.203174603174601*G0_0_0_8_1_1 - 0.270899470899468*G0_0_0_9_1_0 - 0.135449735449735*G0_0_0_9_1_1 + 0.270899470899468*G0_0_0_10_1_0 + 0.406349206349204*G0_0_0_10_1_1 + 0.270899470899471*G0_0_0_11_1_0 + 0.135449735449735*G0_0_0_11_1_1 - 0.237037037037036*G0_0_1_0_0_0 - 0.237037037037037*G0_0_1_0_0_1 - 0.135449735449734*G0_0_1_1_0_0 - 0.16931216931217*G0_0_1_2_0_1 - 0.237037037037038*G0_0_1_3_0_0 - 0.203174603174601*G0_0_1_3_0_1 + 0.237037037037038*G0_0_1_4_0_0 + 0.406349206349207*G0_0_1_4_0_1 + 0.37248677248677*G0_0_1_5_0_0 + 0.203174603174601*G0_0_1_5_0_1 - 0.237037037037036*G0_0_1_6_1_0 - 0.237037037037037*G0_0_1_6_1_1 - 0.135449735449734*G0_0_1_7_1_0 - 0.16931216931217*G0_0_1_8_1_1 - 0.237037037037038*G0_0_1_9_1_0 - 0.203174603174601*G0_0_1_9_1_1 + 0.237037037037038*G0_0_1_10_1_0 + 0.406349206349207*G0_0_1_10_1_1 + 0.37248677248677*G0_0_1_11_1_0 + 0.203174603174601*G0_0_1_11_1_1 - 0.169312169312168*G0_1_0_0_0_0 - 0.169312169312168*G0_1_0_0_0_1 - 0.237037037037036*G0_1_0_2_0_1 - 0.304761904761905*G0_1_0_3_0_0 - 0.0677248677248709*G0_1_0_3_0_1 + 0.304761904761905*G0_1_0_4_0_0 + 0.406349206349204*G0_1_0_4_0_1 + 0.16931216931217*G0_1_0_5_0_0 + 0.0677248677248709*G0_1_0_5_0_1 - 0.169312169312168*G0_1_0_6_1_0 - 0.169312169312168*G0_1_0_6_1_1 - 0.237037037037036*G0_1_0_8_1_1 - 0.304761904761905*G0_1_0_9_1_0 - 0.0677248677248709*G0_1_0_9_1_1 + 0.304761904761905*G0_1_0_10_1_0 + 0.406349206349204*G0_1_0_10_1_1 + 0.16931216931217*G0_1_0_11_1_0 + 0.0677248677248709*G0_1_0_11_1_1 - 0.406349206349206*G0_1_1_0_0_0 - 0.406349206349206*G0_1_1_0_0_1 - 0.406349206349206*G0_1_1_2_0_1 - 0.406349206349208*G0_1_1_3_0_0 + 0.406349206349208*G0_1_1_4_0_0 + 0.812698412698412*G0_1_1_4_0_1 + 0.406349206349208*G0_1_1_5_0_0 - 0.406349206349206*G0_1_1_6_1_0 - 0.406349206349206*G0_1_1_6_1_1 - 0.406349206349206*G0_1_1_8_1_1 - 0.406349206349208*G0_1_1_9_1_0 + 0.406349206349208*G0_1_1_10_1_0 + 0.812698412698412*G0_1_1_10_1_1 + 0.406349206349208*G0_1_1_11_1_0;
    A[125] = A[274] - 0.186243386243385*G0_0_0_0_0_0 - 0.186243386243385*G0_0_0_0_0_1 + 0.93121693121693*G0_0_0_1_0_0 - 1.81164021164021*G0_0_0_2_0_1 - 2.50582010582009*G0_0_0_3_0_0 + 0.23703703703704*G0_0_0_3_0_1 + 2.50582010582009*G0_0_0_4_0_0 + 1.99788359788359*G0_0_0_4_0_1 - 0.744973544973545*G0_0_0_5_0_0 - 0.237037037037039*G0_0_0_5_0_1 - 0.186243386243385*G0_0_0_6_1_0 - 0.186243386243385*G0_0_0_6_1_1 + 0.93121693121693*G0_0_0_7_1_0 - 1.81164021164021*G0_0_0_8_1_1 - 2.50582010582009*G0_0_0_9_1_0 + 0.23703703703704*G0_0_0_9_1_1 + 2.50582010582009*G0_0_0_10_1_0 + 1.99788359788359*G0_0_0_10_1_1 - 0.744973544973545*G0_0_0_11_1_0 - 0.237037037037039*G0_0_0_11_1_1 + 0.874779541446208*G0_0_1_0_0_0 + 0.874779541446208*G0_0_1_0_0_1 + 0.49100529100529*G0_0_1_1_0_0 + 1.31499118165785*G0_0_1_2_0_1 + 2.24620811287478*G0_0_1_3_0_0 + 1.42222222222222*G0_0_1_3_0_1 - 2.24620811287478*G0_0_1_4_0_0 - 2.18977072310406*G0_0_1_4_0_1 - 1.3657848324515*G0_0_1_5_0_0 - 1.42222222222222*G0_0_1_5_0_1 + 0.874779541446208*G0_0_1_6_1_0 + 0.874779541446208*G0_0_1_6_1_1 + 0.49100529100529*G0_0_1_7_1_0 + 1.31499118165785*G0_0_1_8_1_1 + 2.24620811287478*G0_0_1_9_1_0 + 1.42222222222222*G0_0_1_9_1_1 - 2.24620811287478*G0_0_1_10_1_0 - 2.18977072310406*G0_0_1_10_1_1 - 1.3657848324515*G0_0_1_11_1_0 - 1.42222222222222*G0_0_1_11_1_1 + 0.0395061728395061*G0_1_0_0_0_0 + 0.0395061728395063*G0_1_0_0_0_1 + 0.186243386243387*G0_1_0_1_0_0 - 0.332980599647264*G0_1_0_2_0_1 - 0.519223985890646*G0_1_0_3_0_0 + 0.519223985890646*G0_1_0_4_0_0 + 0.293474426807757*G0_1_0_4_0_1 - 0.225749559082893*G0_1_0_5_0_0 + 0.0395061728395061*G0_1_0_6_1_0 + 0.0395061728395063*G0_1_0_6_1_1 + 0.186243386243387*G0_1_0_7_1_0 - 0.332980599647264*G0_1_0_8_1_1 - 0.519223985890646*G0_1_0_9_1_0 + 0.519223985890646*G0_1_0_10_1_0 + 0.293474426807757*G0_1_0_10_1_1 - 0.225749559082893*G0_1_0_11_1_0 + 0.0338624338624336*G0_1_1_0_0_0 + 0.0338624338624334*G0_1_1_0_0_1 - 0.982010582010582*G0_1_1_1_0_0 + 0.50793650793651*G0_1_1_2_0_1 - 1.48994708994709*G0_1_1_3_0_1 - 0.541798941798944*G0_1_1_4_0_1 + 0.948148148148149*G0_1_1_5_0_0 + 1.48994708994709*G0_1_1_5_0_1 + 0.0338624338624336*G0_1_1_6_1_0 + 0.0338624338624334*G0_1_1_6_1_1 - 0.982010582010582*G0_1_1_7_1_0 + 0.50793650793651*G0_1_1_8_1_1 - 1.48994708994709*G0_1_1_9_1_1 - 0.541798941798944*G0_1_1_10_1_1 + 0.948148148148149*G0_1_1_11_1_0 + 1.48994708994709*G0_1_1_11_1_1;
    A[559] = A[125] + 0.214462081128746*G0_0_0_0_0_0 + 0.214462081128746*G0_0_0_0_0_1 - 0.530511463844798*G0_0_0_1_0_0 + 0.846560846560842*G0_0_0_2_0_1 + 0.948148148148139*G0_0_0_3_0_0 - 0.428924162257499*G0_0_0_3_0_1 - 0.948148148148139*G0_0_0_4_0_0 - 1.06102292768959*G0_0_0_4_0_1 + 0.316049382716052*G0_0_0_5_0_0 + 0.428924162257499*G0_0_0_5_0_1 + 0.214462081128746*G0_0_0_6_1_0 + 0.214462081128746*G0_0_0_6_1_1 - 0.530511463844798*G0_0_0_7_1_0 + 0.846560846560842*G0_0_0_8_1_1 + 0.948148148148139*G0_0_0_9_1_0 - 0.428924162257499*G0_0_0_9_1_1 - 0.948148148148139*G0_0_0_10_1_0 - 1.06102292768959*G0_0_0_10_1_1 + 0.316049382716052*G0_0_0_11_1_0 + 0.428924162257499*G0_0_0_11_1_1 + 0.81269841269841*G0_0_1_1_0_0 - 0.812698412698415*G0_0_1_2_0_1 - 0.812698412698417*G0_0_1_3_0_0 + 0.812698412698409*G0_0_1_3_0_1 + 0.812698412698417*G0_0_1_4_0_0 + 0.812698412698417*G0_0_1_4_0_1 - 0.812698412698409*G0_0_1_5_0_0 - 0.812698412698408*G0_0_1_5_0_1 + 0.81269841269841*G0_0_1_7_1_0 - 0.812698412698415*G0_0_1_8_1_1 - 0.812698412698417*G0_0_1_9_1_0 + 0.812698412698409*G0_0_1_9_1_1 + 0.812698412698417*G0_0_1_10_1_0 + 0.812698412698417*G0_0_1_10_1_1 - 0.812698412698409*G0_0_1_11_1_0 - 0.812698412698408*G0_0_1_11_1_1 - 0.654673721340387*G0_1_0_1_0_0 + 0.654673721340385*G0_1_0_2_0_1 + 0.654673721340383*G0_1_0_3_0_0 - 0.654673721340388*G0_1_0_3_0_1 - 0.654673721340383*G0_1_0_4_0_0 - 0.654673721340384*G0_1_0_4_0_1 + 0.654673721340387*G0_1_0_5_0_0 + 0.654673721340388*G0_1_0_5_0_1 - 0.654673721340387*G0_1_0_7_1_0 + 0.654673721340385*G0_1_0_8_1_1 + 0.654673721340383*G0_1_0_9_1_0 - 0.654673721340388*G0_1_0_9_1_1 - 0.654673721340383*G0_1_0_10_1_0 - 0.654673721340384*G0_1_0_10_1_1 + 0.654673721340387*G0_1_0_11_1_0 + 0.654673721340388*G0_1_0_11_1_1 - 0.214462081128749*G0_1_1_0_0_0 - 0.214462081128749*G0_1_1_0_0_1 - 0.846560846560849*G0_1_1_1_0_0 + 0.530511463844795*G0_1_1_2_0_1 + 0.428924162257492*G0_1_1_3_0_0 - 0.948148148148151*G0_1_1_3_0_1 - 0.428924162257492*G0_1_1_4_0_0 - 0.316049382716046*G0_1_1_4_0_1 + 1.0610229276896*G0_1_1_5_0_0 + 0.948148148148152*G0_1_1_5_0_1 - 0.214462081128749*G0_1_1_6_1_0 - 0.214462081128749*G0_1_1_6_1_1 - 0.846560846560849*G0_1_1_7_1_0 + 0.530511463844795*G0_1_1_8_1_1 + 0.428924162257492*G0_1_1_9_1_0 - 0.948148148148151*G0_1_1_9_1_1 - 0.428924162257492*G0_1_1_10_1_0 - 0.316049382716046*G0_1_1_10_1_1 + 1.0610229276896*G0_1_1_11_1_0 + 0.948148148148152*G0_1_1_11_1_1;
    A[588] = A[559] - 0.823985890652556*G0_0_1_0_0_0 - 0.823985890652556*G0_0_1_0_0_1 - 1.70440917107583*G0_0_1_1_0_0 - 0.237037037037037*G0_0_1_2_0_1 - 1.35449735449735*G0_0_1_3_0_0 - 2.82186948853615*G0_0_1_3_0_1 + 1.35449735449735*G0_0_1_4_0_0 + 1.06102292768959*G0_0_1_4_0_1 + 2.52839506172839*G0_0_1_5_0_0 + 2.82186948853615*G0_0_1_5_0_1 - 0.823985890652556*G0_0_1_6_1_0 - 0.823985890652556*G0_0_1_6_1_1 - 1.70440917107583*G0_0_1_7_1_0 - 0.237037037037037*G0_0_1_8_1_1 - 1.35449735449735*G0_0_1_9_1_0 - 2.82186948853615*G0_0_1_9_1_1 + 1.35449735449735*G0_0_1_10_1_0 + 1.06102292768959*G0_0_1_10_1_1 + 2.52839506172839*G0_0_1_11_1_0 + 2.82186948853615*G0_0_1_11_1_1 + 0.823985890652556*G0_1_0_0_0_0 + 0.823985890652556*G0_1_0_0_0_1 + 1.70440917107583*G0_1_0_1_0_0 + 0.237037037037037*G0_1_0_2_0_1 + 1.35449735449735*G0_1_0_3_0_0 + 2.82186948853615*G0_1_0_3_0_1 - 1.35449735449735*G0_1_0_4_0_0 - 1.06102292768959*G0_1_0_4_0_1 - 2.52839506172839*G0_1_0_5_0_0 - 2.82186948853615*G0_1_0_5_0_1 + 0.823985890652556*G0_1_0_6_1_0 + 0.823985890652556*G0_1_0_6_1_1 + 1.70440917107583*G0_1_0_7_1_0 + 0.237037037037037*G0_1_0_8_1_1 + 1.35449735449735*G0_1_0_9_1_0 + 2.82186948853615*G0_1_0_9_1_1 - 1.35449735449735*G0_1_0_10_1_0 - 1.06102292768959*G0_1_0_10_1_1 - 2.52839506172839*G0_1_0_11_1_0 - 2.82186948853615*G0_1_0_11_1_1;
    A[309] = A[125] + 2.67513227513227*G0_0_0_0_0_0 + 2.67513227513227*G0_0_0_0_0_1 - 1.59153439153439*G0_0_0_1_0_0 + 3.08148148148147*G0_0_0_2_0_1 + 1.89629629629629*G0_0_0_3_0_0 - 2.77671957671958*G0_0_0_3_0_1 - 1.89629629629629*G0_0_0_4_0_0 - 5.75661375661375*G0_0_0_4_0_1 - 1.08359788359788*G0_0_0_5_0_0 + 2.77671957671958*G0_0_0_5_0_1 + 2.67513227513227*G0_0_0_6_1_0 + 2.67513227513227*G0_0_0_6_1_1 - 1.59153439153439*G0_0_0_7_1_0 + 3.08148148148147*G0_0_0_8_1_1 + 1.89629629629629*G0_0_0_9_1_0 - 2.77671957671958*G0_0_0_9_1_1 - 1.89629629629629*G0_0_0_10_1_0 - 5.75661375661375*G0_0_0_10_1_1 - 1.08359788359788*G0_0_0_11_1_0 + 2.77671957671958*G0_0_0_11_1_1 + 0.169312169312168*G0_0_1_0_0_0 + 0.169312169312168*G0_0_1_0_0_1 - 1.82857142857143*G0_0_1_1_0_0 - 0.304761904761907*G0_0_1_2_0_1 - 2.60740740740741*G0_0_1_3_0_0 - 4.13121693121693*G0_0_1_3_0_1 + 2.60740740740741*G0_0_1_4_0_0 + 0.135449735449739*G0_0_1_4_0_1 + 1.65925925925926*G0_0_1_5_0_0 + 4.13121693121693*G0_0_1_5_0_1 + 0.169312169312168*G0_0_1_6_1_0 + 0.169312169312168*G0_0_1_6_1_1 - 1.82857142857143*G0_0_1_7_1_0 - 0.304761904761907*G0_0_1_8_1_1 - 2.60740740740741*G0_0_1_9_1_0 - 4.13121693121693*G0_0_1_9_1_1 + 2.60740740740741*G0_0_1_10_1_0 + 0.135449735449739*G0_0_1_10_1_1 + 1.65925925925926*G0_0_1_11_1_0 + 4.13121693121693*G0_0_1_11_1_1 - 0.71111111111111*G0_1_0_0_0_0 - 0.71111111111111*G0_1_0_0_0_1 - 1.35449735449735*G0_1_0_1_0_0 + 0.575661375661374*G0_1_0_2_0_1 + 0.507936507936503*G0_1_0_3_0_0 - 1.42222222222222*G0_1_0_3_0_1 - 0.507936507936503*G0_1_0_4_0_0 + 0.135449735449736*G0_1_0_4_0_1 + 2.06560846560846*G0_1_0_5_0_0 + 1.42222222222222*G0_1_0_5_0_1 - 0.71111111111111*G0_1_0_6_1_0 - 0.71111111111111*G0_1_0_6_1_1 - 1.35449735449735*G0_1_0_7_1_0 + 0.575661375661374*G0_1_0_8_1_1 + 0.507936507936503*G0_1_0_9_1_0 - 1.42222222222222*G0_1_0_9_1_1 - 0.507936507936503*G0_1_0_10_1_0 + 0.135449735449736*G0_1_0_10_1_1 + 2.06560846560846*G0_1_0_11_1_0 + 1.42222222222222*G0_1_0_11_1_1 - 0.135449735449736*G0_1_1_0_0_0 - 0.135449735449736*G0_1_1_0_0_1 - 0.135449735449739*G0_1_1_2_0_1 - 0.135449735449738*G0_1_1_3_0_0 + 0.135449735449738*G0_1_1_4_0_0 + 0.270899470899475*G0_1_1_4_0_1 + 0.135449735449734*G0_1_1_5_0_0 - 0.135449735449736*G0_1_1_6_1_0 - 0.135449735449736*G0_1_1_6_1_1 - 0.135449735449739*G0_1_1_8_1_1 - 0.135449735449738*G0_1_1_9_1_0 + 0.135449735449738*G0_1_1_10_1_0 + 0.270899470899475*G0_1_1_10_1_1 + 0.135449735449734*G0_1_1_11_1_0;
    A[334] = -A[559] - 0.0395061728395073*G0_0_0_0_0_0 - 0.0395061728395069*G0_0_0_0_0_1 + 0.603880070546735*G0_0_0_1_0_0 - 1.37142857142857*G0_0_0_2_0_1 - 2.09947089947089*G0_0_0_3_0_0 - 0.124162257495592*G0_0_0_3_0_1 + 2.09947089947089*G0_0_0_4_0_0 + 1.41093474426807*G0_0_0_4_0_1 - 0.564373897707228*G0_0_0_5_0_0 + 0.124162257495592*G0_0_0_5_0_1 - 0.0395061728395073*G0_0_0_6_1_0 - 0.0395061728395069*G0_0_0_6_1_1 + 0.603880070546735*G0_0_0_7_1_0 - 1.37142857142857*G0_0_0_8_1_1 - 2.09947089947089*G0_0_0_9_1_0 - 0.124162257495592*G0_0_0_9_1_1 + 2.09947089947089*G0_0_0_10_1_0 + 1.41093474426807*G0_0_0_10_1_1 - 0.564373897707228*G0_0_0_11_1_0 + 0.124162257495592*G0_0_0_11_1_1 + 1.06102292768959*G0_0_1_0_0_0 + 1.0610229276896*G0_0_1_0_0_1 + 2.06560846560847*G0_0_1_1_0_0 + 0.112874779541445*G0_0_1_2_0_1 + 1.23033509700176*G0_0_1_3_0_0 + 3.18306878306878*G0_0_1_3_0_1 - 1.23033509700176*G0_0_1_4_0_0 - 1.17389770723104*G0_0_1_4_0_1 - 3.12663139329806*G0_0_1_5_0_0 - 3.18306878306878*G0_0_1_5_0_1 + 1.06102292768959*G0_0_1_6_1_0 + 1.0610229276896*G0_0_1_6_1_1 + 2.06560846560847*G0_0_1_7_1_0 + 0.112874779541445*G0_0_1_8_1_1 + 1.23033509700176*G0_0_1_9_1_0 + 3.18306878306878*G0_0_1_9_1_1 - 1.23033509700176*G0_0_1_10_1_0 - 1.17389770723104*G0_0_1_10_1_1 - 3.12663139329806*G0_0_1_11_1_0 - 3.18306878306878*G0_0_1_11_1_1;
    A[131] = -A[588] - 0.0395061728395073*G0_0_0_0_0_0 - 0.0395061728395069*G0_0_0_0_0_1 + 0.603880070546734*G0_0_0_1_0_0 - 1.37142857142857*G0_0_0_2_0_1 - 2.09947089947089*G0_0_0_3_0_0 - 0.124162257495592*G0_0_0_3_0_1 + 2.09947089947089*G0_0_0_4_0_0 + 1.41093474426807*G0_0_0_4_0_1 - 0.564373897707227*G0_0_0_5_0_0 + 0.124162257495593*G0_0_0_5_0_1 - 0.0395061728395073*G0_0_0_6_1_0 - 0.0395061728395069*G0_0_0_6_1_1 + 0.603880070546734*G0_0_0_7_1_0 - 1.37142857142857*G0_0_0_8_1_1 - 2.09947089947089*G0_0_0_9_1_0 - 0.124162257495592*G0_0_0_9_1_1 + 2.09947089947089*G0_0_0_10_1_0 + 1.41093474426807*G0_0_0_10_1_1 - 0.564373897707227*G0_0_0_11_1_0 + 0.124162257495593*G0_0_0_11_1_1 + 1.06102292768959*G0_1_0_0_0_0 + 1.0610229276896*G0_1_0_0_0_1 + 2.06560846560847*G0_1_0_1_0_0 + 0.112874779541445*G0_1_0_2_0_1 + 1.23033509700176*G0_1_0_3_0_0 + 3.18306878306879*G0_1_0_3_0_1 - 1.23033509700176*G0_1_0_4_0_0 - 1.17389770723104*G0_1_0_4_0_1 - 3.12663139329806*G0_1_0_5_0_0 - 3.18306878306879*G0_1_0_5_0_1 + 1.06102292768959*G0_1_0_6_1_0 + 1.0610229276896*G0_1_0_6_1_1 + 2.06560846560847*G0_1_0_7_1_0 + 0.112874779541445*G0_1_0_8_1_1 + 1.23033509700176*G0_1_0_9_1_0 + 3.18306878306879*G0_1_0_9_1_1 - 1.23033509700176*G0_1_0_10_1_0 - 1.17389770723104*G0_1_0_10_1_1 - 3.12663139329806*G0_1_0_11_1_0 - 3.18306878306879*G0_1_0_11_1_1;
    A[805] = A[559] + 0.92557319223986*G0_0_0_0_0_0 + 0.925573192239859*G0_0_0_0_0_1 - 2.59611992945326*G0_0_0_1_0_0 + 2.23492063492063*G0_0_0_2_0_1 + 0.948148148148149*G0_0_0_3_0_0 - 3.88289241622575*G0_0_0_3_0_1 - 0.948148148148149*G0_0_0_4_0_0 - 3.16049382716049*G0_0_0_4_0_1 + 1.6705467372134*G0_0_0_5_0_0 + 3.88289241622575*G0_0_0_5_0_1 + 0.92557319223986*G0_0_0_6_1_0 + 0.925573192239859*G0_0_0_6_1_1 - 2.59611992945326*G0_0_0_7_1_0 + 2.23492063492063*G0_0_0_8_1_1 + 0.948148148148149*G0_0_0_9_1_0 - 3.88289241622575*G0_0_0_9_1_1 - 0.948148148148149*G0_0_0_10_1_0 - 3.16049382716049*G0_0_0_10_1_1 + 1.6705467372134*G0_0_0_11_1_0 + 3.88289241622575*G0_0_0_11_1_1 - 1.17389770723104*G0_0_1_0_0_0 - 1.17389770723104*G0_0_1_0_0_1 - 4.3005291005291*G0_0_1_1_0_0 + 0.722398589065256*G0_0_1_2_0_1 - 1.68183421516754*G0_0_1_3_0_0 - 6.7047619047619*G0_0_1_3_0_1 + 1.68183421516754*G0_0_1_4_0_0 + 0.45149911816578*G0_0_1_4_0_1 + 5.47442680776014*G0_0_1_5_0_0 + 6.7047619047619*G0_0_1_5_0_1 - 1.17389770723104*G0_0_1_6_1_0 - 1.17389770723104*G0_0_1_6_1_1 - 4.3005291005291*G0_0_1_7_1_0 + 0.722398589065256*G0_0_1_8_1_1 - 1.68183421516754*G0_0_1_9_1_0 - 6.7047619047619*G0_0_1_9_1_1 + 1.68183421516754*G0_0_1_10_1_0 + 0.45149911816578*G0_0_1_10_1_1 + 5.47442680776014*G0_0_1_11_1_0 + 6.7047619047619*G0_0_1_11_1_1 - 0.586948853615521*G0_1_0_0_0_0 - 0.586948853615521*G0_1_0_0_0_1 - 0.891710758377426*G0_1_0_1_0_0 + 0.135449735449736*G0_1_0_2_0_1 - 0.0338624338624338*G0_1_0_3_0_0 - 1.0610229276896*G0_1_0_3_0_1 + 0.0338624338624338*G0_1_0_4_0_0 + 0.451499118165785*G0_1_0_4_0_1 + 1.47865961199295*G0_1_0_5_0_0 + 1.0610229276896*G0_1_0_5_0_1 - 0.586948853615521*G0_1_0_6_1_0 - 0.586948853615521*G0_1_0_6_1_1 - 0.891710758377426*G0_1_0_7_1_0 + 0.135449735449736*G0_1_0_8_1_1 - 0.0338624338624338*G0_1_0_9_1_0 - 1.0610229276896*G0_1_0_9_1_1 + 0.0338624338624338*G0_1_0_10_1_0 + 0.451499118165785*G0_1_0_10_1_1 + 1.47865961199295*G0_1_0_11_1_0 + 1.0610229276896*G0_1_0_11_1_1 - 0.451499118165782*G0_1_1_0_0_0 - 0.451499118165782*G0_1_1_0_0_1 - 0.451499118165786*G0_1_1_2_0_1 - 0.451499118165784*G0_1_1_3_0_0 + 0.451499118165784*G0_1_1_4_0_0 + 0.902998236331568*G0_1_1_4_0_1 + 0.451499118165774*G0_1_1_5_0_0 - 0.451499118165782*G0_1_1_6_1_0 - 0.451499118165782*G0_1_1_6_1_1 - 0.451499118165786*G0_1_1_8_1_1 - 0.451499118165784*G0_1_1_9_1_0 + 0.451499118165784*G0_1_1_10_1_0 + 0.902998236331568*G0_1_1_10_1_1 + 0.451499118165774*G0_1_1_11_1_0;
    A[94] = A[559];
    A[590] = A[125];
    A[652] = A[309] - 2.59611992945326*G0_0_0_0_0_0 - 2.59611992945326*G0_0_0_0_0_1 + 0.925573192239858*G0_0_0_1_0_0 - 2.23492063492063*G0_0_0_2_0_1 - 0.94814814814815*G0_0_0_3_0_0 + 2.21234567901234*G0_0_0_3_0_1 + 0.94814814814815*G0_0_0_4_0_0 + 4.8310405643739*G0_0_0_4_0_1 + 1.6705467372134*G0_0_0_5_0_0 - 2.21234567901234*G0_0_0_5_0_1 - 2.59611992945326*G0_0_0_6_1_0 - 2.59611992945326*G0_0_0_6_1_1 + 0.925573192239858*G0_0_0_7_1_0 - 2.23492063492063*G0_0_0_8_1_1 - 0.94814814814815*G0_0_0_9_1_0 + 2.21234567901234*G0_0_0_9_1_1 + 0.94814814814815*G0_0_0_10_1_0 + 4.8310405643739*G0_0_0_10_1_1 + 1.6705467372134*G0_0_0_11_1_0 - 2.21234567901234*G0_0_0_11_1_1 + 2.33650793650794*G0_0_1_1_0_0 - 2.33650793650793*G0_0_1_2_0_1 - 2.33650793650794*G0_0_1_3_0_0 + 2.33650793650793*G0_0_1_3_0_1 + 2.33650793650794*G0_0_1_4_0_0 + 2.33650793650793*G0_0_1_4_0_1 - 2.33650793650794*G0_0_1_5_0_0 - 2.33650793650793*G0_0_1_5_0_1 + 2.33650793650794*G0_0_1_7_1_0 - 2.33650793650793*G0_0_1_8_1_1 - 2.33650793650794*G0_0_1_9_1_0 + 2.33650793650793*G0_0_1_9_1_1 + 2.33650793650794*G0_0_1_10_1_0 + 2.33650793650793*G0_0_1_10_1_1 - 2.33650793650794*G0_0_1_11_1_0 - 2.33650793650793*G0_0_1_11_1_1 + 1.27548500881834*G0_1_0_1_0_0 - 1.27548500881834*G0_1_0_2_0_1 - 1.27548500881834*G0_1_0_3_0_0 + 1.27548500881834*G0_1_0_3_0_1 + 1.27548500881834*G0_1_0_4_0_0 + 1.27548500881835*G0_1_0_4_0_1 - 1.27548500881834*G0_1_0_5_0_0 - 1.27548500881834*G0_1_0_5_0_1 + 1.27548500881834*G0_1_0_7_1_0 - 1.27548500881834*G0_1_0_8_1_1 - 1.27548500881834*G0_1_0_9_1_0 + 1.27548500881834*G0_1_0_9_1_1 + 1.27548500881834*G0_1_0_10_1_0 + 1.27548500881835*G0_1_0_10_1_1 - 1.27548500881834*G0_1_0_11_1_0 - 1.27548500881834*G0_1_0_11_1_1 + 2.59611992945326*G0_1_1_0_0_0 + 2.59611992945326*G0_1_1_0_0_1 + 2.23492063492063*G0_1_1_1_0_0 - 0.925573192239859*G0_1_1_2_0_1 - 2.21234567901235*G0_1_1_3_0_0 + 0.948148148148145*G0_1_1_3_0_1 + 2.21234567901235*G0_1_1_4_0_0 - 1.6705467372134*G0_1_1_4_0_1 - 4.83104056437389*G0_1_1_5_0_0 - 0.948148148148145*G0_1_1_5_0_1 + 2.59611992945326*G0_1_1_6_1_0 + 2.59611992945326*G0_1_1_6_1_1 + 2.23492063492063*G0_1_1_7_1_0 - 0.925573192239859*G0_1_1_8_1_1 - 2.21234567901235*G0_1_1_9_1_0 + 0.948148148148145*G0_1_1_9_1_1 + 2.21234567901235*G0_1_1_10_1_0 - 1.6705467372134*G0_1_1_10_1_1 - 4.83104056437389*G0_1_1_11_1_0 - 0.948148148148145*G0_1_1_11_1_1;
    A[187] = A[652];
    A[216] = A[652] - 1.70440917107584*G0_0_1_0_0_0 - 1.70440917107584*G0_0_1_0_0_1 - 0.823985890652558*G0_0_1_1_0_0 + 0.237037037037035*G0_0_1_2_0_1 + 1.35449735449735*G0_0_1_3_0_0 + 0.29347442680776*G0_0_1_3_0_1 - 1.35449735449735*G0_0_1_4_0_0 + 1.46737213403881*G0_0_1_4_0_1 + 2.5283950617284*G0_0_1_5_0_0 - 0.29347442680776*G0_0_1_5_0_1 - 1.70440917107584*G0_0_1_6_1_0 - 1.70440917107584*G0_0_1_6_1_1 - 0.823985890652558*G0_0_1_7_1_0 + 0.237037037037035*G0_0_1_8_1_1 + 1.35449735449735*G0_0_1_9_1_0 + 0.29347442680776*G0_0_1_9_1_1 - 1.35449735449735*G0_0_1_10_1_0 + 1.46737213403881*G0_0_1_10_1_1 + 2.5283950617284*G0_0_1_11_1_0 - 0.29347442680776*G0_0_1_11_1_1 + 1.70440917107584*G0_1_0_0_0_0 + 1.70440917107584*G0_1_0_0_0_1 + 0.823985890652558*G0_1_0_1_0_0 - 0.237037037037034*G0_1_0_2_0_1 - 1.35449735449735*G0_1_0_3_0_0 - 0.29347442680776*G0_1_0_3_0_1 + 1.35449735449735*G0_1_0_4_0_0 - 1.46737213403881*G0_1_0_4_0_1 - 2.5283950617284*G0_1_0_5_0_0 + 0.29347442680776*G0_1_0_5_0_1 + 1.70440917107584*G0_1_0_6_1_0 + 1.70440917107584*G0_1_0_6_1_1 + 0.823985890652558*G0_1_0_7_1_0 - 0.237037037037034*G0_1_0_8_1_1 - 1.35449735449735*G0_1_0_9_1_0 - 0.29347442680776*G0_1_0_9_1_1 + 1.35449735449735*G0_1_0_10_1_0 - 1.46737213403881*G0_1_0_10_1_1 - 2.5283950617284*G0_1_0_11_1_0 + 0.29347442680776*G0_1_0_11_1_1;
    A[702] = 0.0;
    A[340] = A[805];
    A[21] = 0.0;
    A[46] = 0.0;
    A[450] = 0.0;
    A[406] = 0.0;
    A[83] = 0.0;
    A[788] = 0.0;
    A[815] = 0.0;
    A[40] = 0.00564373897707236*G0_0_0_0_0_0 + 0.00564373897707261*G0_0_0_0_0_1 + 0.729453262786596*G0_0_0_1_0_0 - 0.256084656084656*G0_0_0_2_0_1 + 0.211640211640211*G0_0_0_3_0_0 + 1.19717813051146*G0_0_0_3_0_1 - 0.211640211640211*G0_0_0_4_0_0 + 0.250440917107584*G0_0_0_4_0_1 - 0.735097001763669*G0_0_0_5_0_0 - 1.19717813051146*G0_0_0_5_0_1 + 0.00564373897707236*G0_0_0_6_1_0 + 0.00564373897707261*G0_0_0_6_1_1 + 0.729453262786596*G0_0_0_7_1_0 - 0.256084656084656*G0_0_0_8_1_1 + 0.211640211640211*G0_0_0_9_1_0 + 1.19717813051146*G0_0_0_9_1_1 - 0.211640211640211*G0_0_0_10_1_0 + 0.250440917107584*G0_0_0_10_1_1 - 0.735097001763669*G0_0_0_11_1_0 - 1.19717813051146*G0_0_0_11_1_1 + 0.323104056437389*G0_0_1_0_0_0 + 0.323104056437389*G0_0_1_0_0_1 + 1.04338624338624*G0_0_1_1_0_0 - 0.294885361552028*G0_0_1_2_0_1 + 0.130511463844796*G0_0_1_3_0_0 + 1.46878306878307*G0_0_1_3_0_1 - 0.130511463844796*G0_0_1_4_0_0 - 0.0282186948853607*G0_0_1_4_0_1 - 1.36649029982363*G0_0_1_5_0_0 - 1.46878306878307*G0_0_1_5_0_1 + 0.323104056437389*G0_0_1_6_1_0 + 0.323104056437389*G0_0_1_6_1_1 + 1.04338624338624*G0_0_1_7_1_0 - 0.294885361552028*G0_0_1_8_1_1 + 0.130511463844796*G0_0_1_9_1_0 + 1.46878306878307*G0_0_1_9_1_1 - 0.130511463844796*G0_0_1_10_1_0 - 0.0282186948853607*G0_0_1_10_1_1 - 1.36649029982363*G0_0_1_11_1_0 - 1.46878306878307*G0_0_1_11_1_1;
    A[121] = -A[766] - 0.0331569664902994*G0_0_0_0_0_0 - 0.0331569664902993*G0_0_0_0_0_1 + 0.415520282186951*G0_0_0_1_0_0 + 0.06137566137566*G0_0_0_2_0_1 + 0.571428571428569*G0_0_0_3_0_0 + 0.92557319223986*G0_0_0_3_0_1 - 0.571428571428569*G0_0_0_4_0_0 - 0.0282186948853603*G0_0_0_4_0_1 - 0.382363315696651*G0_0_0_5_0_0 - 0.925573192239861*G0_0_0_5_0_1 - 0.0331569664902994*G0_0_0_6_1_0 - 0.0331569664902993*G0_0_0_6_1_1 + 0.415520282186951*G0_0_0_7_1_0 + 0.06137566137566*G0_0_0_8_1_1 + 0.571428571428569*G0_0_0_9_1_0 + 0.92557319223986*G0_0_0_9_1_1 - 0.571428571428569*G0_0_0_10_1_0 - 0.0282186948853603*G0_0_0_10_1_1 - 0.382363315696651*G0_0_0_11_1_0 - 0.925573192239861*G0_0_0_11_1_1 + 0.0282186948853608*G0_1_0_0_0_0 + 0.0282186948853608*G0_1_0_0_0_1 + 0.0282186948853617*G0_1_0_2_0_1 + 0.0282186948853611*G0_1_0_3_0_0 - 0.0282186948853611*G0_1_0_4_0_0 - 0.0564373897707226*G0_1_0_4_0_1 - 0.0282186948853593*G0_1_0_5_0_0 + 0.0282186948853608*G0_1_0_6_1_0 + 0.0282186948853608*G0_1_0_6_1_1 + 0.0282186948853617*G0_1_0_8_1_1 + 0.0282186948853611*G0_1_0_9_1_0 - 0.0282186948853611*G0_1_0_10_1_0 - 0.0564373897707226*G0_1_0_10_1_1 - 0.0282186948853593*G0_1_0_11_1_0;
    A[846] = 0.0;
    A[154] = A[125] - 0.823985890652557*G0_0_1_0_0_0 - 0.823985890652557*G0_0_1_0_0_1 - 0.237037037037037*G0_0_1_1_0_0 - 1.70440917107584*G0_0_1_2_0_1 - 2.82186948853615*G0_0_1_3_0_0 - 1.35449735449735*G0_0_1_3_0_1 + 2.82186948853615*G0_0_1_4_0_0 + 2.52839506172839*G0_0_1_4_0_1 + 1.06102292768959*G0_0_1_5_0_0 + 1.35449735449735*G0_0_1_5_0_1 - 0.823985890652557*G0_0_1_6_1_0 - 0.823985890652557*G0_0_1_6_1_1 - 0.237037037037037*G0_0_1_7_1_0 - 1.70440917107584*G0_0_1_8_1_1 - 2.82186948853615*G0_0_1_9_1_0 - 1.35449735449735*G0_0_1_9_1_1 + 2.82186948853615*G0_0_1_10_1_0 + 2.52839506172839*G0_0_1_10_1_1 + 1.06102292768959*G0_0_1_11_1_0 + 1.35449735449735*G0_0_1_11_1_1 + 0.823985890652557*G0_1_0_0_0_0 + 0.823985890652557*G0_1_0_0_0_1 + 0.237037037037037*G0_1_0_1_0_0 + 1.70440917107584*G0_1_0_2_0_1 + 2.82186948853615*G0_1_0_3_0_0 + 1.35449735449735*G0_1_0_3_0_1 - 2.82186948853615*G0_1_0_4_0_0 - 2.52839506172839*G0_1_0_4_0_1 - 1.06102292768959*G0_1_0_5_0_0 - 1.35449735449735*G0_1_0_5_0_1 + 0.823985890652557*G0_1_0_6_1_0 + 0.823985890652557*G0_1_0_6_1_1 + 0.237037037037037*G0_1_0_7_1_0 + 1.70440917107584*G0_1_0_8_1_1 + 2.82186948853615*G0_1_0_9_1_0 + 1.35449735449735*G0_1_0_9_1_1 - 2.82186948853615*G0_1_0_10_1_0 - 2.52839506172839*G0_1_0_10_1_1 - 1.06102292768959*G0_1_0_11_1_0 - 1.35449735449735*G0_1_0_11_1_1;
    A[709] = -A[154] + 1.06102292768959*G0_1_0_0_0_0 + 1.06102292768959*G0_1_0_0_0_1 + 0.112874779541448*G0_1_0_1_0_0 + 2.06560846560846*G0_1_0_2_0_1 + 3.18306878306878*G0_1_0_3_0_0 + 1.23033509700176*G0_1_0_3_0_1 - 3.18306878306878*G0_1_0_4_0_0 - 3.12663139329805*G0_1_0_4_0_1 - 1.17389770723104*G0_1_0_5_0_0 - 1.23033509700176*G0_1_0_5_0_1 + 1.06102292768959*G0_1_0_6_1_0 + 1.06102292768959*G0_1_0_6_1_1 + 0.112874779541448*G0_1_0_7_1_0 + 2.06560846560846*G0_1_0_8_1_1 + 3.18306878306878*G0_1_0_9_1_0 + 1.23033509700176*G0_1_0_9_1_1 - 3.18306878306878*G0_1_0_10_1_0 - 3.12663139329805*G0_1_0_10_1_1 - 1.17389770723104*G0_1_0_11_1_0 - 1.23033509700176*G0_1_0_11_1_1 - 0.0395061728395083*G0_1_1_0_0_0 - 0.0395061728395086*G0_1_1_0_0_1 - 1.37142857142857*G0_1_1_1_0_0 + 0.603880070546737*G0_1_1_2_0_1 - 0.124162257495591*G0_1_1_3_0_0 - 2.0994708994709*G0_1_1_3_0_1 + 0.124162257495591*G0_1_1_4_0_0 - 0.564373897707229*G0_1_1_4_0_1 + 1.41093474426808*G0_1_1_5_0_0 + 2.0994708994709*G0_1_1_5_0_1 - 0.0395061728395083*G0_1_1_6_1_0 - 0.0395061728395086*G0_1_1_6_1_1 - 1.37142857142857*G0_1_1_7_1_0 + 0.603880070546737*G0_1_1_8_1_1 - 0.124162257495591*G0_1_1_9_1_0 - 2.0994708994709*G0_1_1_9_1_1 + 0.124162257495591*G0_1_1_10_1_0 - 0.564373897707229*G0_1_1_10_1_1 + 1.41093474426808*G0_1_1_11_1_0 + 2.0994708994709*G0_1_1_11_1_1;
    A[877] = 0.0;
    A[484] = 0.0;
    A[191] = A[656];
    A[587] = -A[677] + 0.0282186948853626*G0_0_1_0_0_0 + 0.0282186948853627*G0_0_1_0_0_1 + 0.0282186948853613*G0_0_1_1_0_0 + 0.0282186948853625*G0_0_1_3_0_1 - 0.0282186948853653*G0_0_1_4_0_1 - 0.0564373897707239*G0_0_1_5_0_0 - 0.0282186948853625*G0_0_1_5_0_1 + 0.0282186948853626*G0_0_1_6_1_0 + 0.0282186948853627*G0_0_1_6_1_1 + 0.0282186948853613*G0_0_1_7_1_0 + 0.0282186948853625*G0_0_1_9_1_1 - 0.0282186948853653*G0_0_1_10_1_1 - 0.0564373897707239*G0_0_1_11_1_0 - 0.0282186948853625*G0_0_1_11_1_1 - 0.033156966490298*G0_1_1_0_0_0 - 0.0331569664902979*G0_1_1_0_0_1 + 0.0613756613756621*G0_1_1_1_0_0 + 0.41552028218695*G0_1_1_2_0_1 + 0.92557319223986*G0_1_1_3_0_0 + 0.571428571428572*G0_1_1_3_0_1 - 0.92557319223986*G0_1_1_4_0_0 - 0.382363315696652*G0_1_1_4_0_1 - 0.028218694885364*G0_1_1_5_0_0 - 0.571428571428573*G0_1_1_5_0_1 - 0.033156966490298*G0_1_1_6_1_0 - 0.0331569664902979*G0_1_1_6_1_1 + 0.0613756613756621*G0_1_1_7_1_0 + 0.41552028218695*G0_1_1_8_1_1 + 0.92557319223986*G0_1_1_9_1_0 + 0.571428571428572*G0_1_1_9_1_1 - 0.92557319223986*G0_1_1_10_1_0 - 0.382363315696652*G0_1_1_10_1_1 - 0.028218694885364*G0_1_1_11_1_0 - 0.571428571428573*G0_1_1_11_1_1;
    A[511] = 0.0;
    A[228] = 0.0;
    A[610] = 0.0;
    A[546] = 0.0;
    A[506] = A[331] - 0.595414462081127*G0_0_1_0_0_0 - 0.595414462081128*G0_0_1_0_0_1 - 1.96966490299823*G0_0_1_1_0_0 + 0.595414462081128*G0_0_1_2_0_1 - 0.183421516754848*G0_0_1_3_0_0 - 2.74850088183421*G0_0_1_3_0_1 + 0.183421516754848*G0_0_1_4_0_0 + 2.56507936507936*G0_0_1_5_0_0 + 2.74850088183421*G0_0_1_5_0_1 - 0.595414462081127*G0_0_1_6_1_0 - 0.595414462081128*G0_0_1_6_1_1 - 1.96966490299823*G0_0_1_7_1_0 + 0.595414462081128*G0_0_1_8_1_1 - 0.183421516754848*G0_0_1_9_1_0 - 2.74850088183421*G0_0_1_9_1_1 + 0.183421516754848*G0_0_1_10_1_0 + 2.56507936507936*G0_0_1_11_1_0 + 2.74850088183421*G0_0_1_11_1_1 + 0.595414462081127*G0_1_0_0_0_0 + 0.595414462081128*G0_1_0_0_0_1 + 1.96966490299823*G0_1_0_1_0_0 - 0.595414462081128*G0_1_0_2_0_1 + 0.183421516754848*G0_1_0_3_0_0 + 2.74850088183421*G0_1_0_3_0_1 - 0.183421516754848*G0_1_0_4_0_0 - 2.56507936507936*G0_1_0_5_0_0 - 2.74850088183421*G0_1_0_5_0_1 + 0.595414462081127*G0_1_0_6_1_0 + 0.595414462081128*G0_1_0_6_1_1 + 1.96966490299823*G0_1_0_7_1_0 - 0.595414462081128*G0_1_0_8_1_1 + 0.183421516754848*G0_1_0_9_1_0 + 2.74850088183421*G0_1_0_9_1_1 - 0.183421516754848*G0_1_0_10_1_0 - 2.56507936507936*G0_1_0_11_1_0 - 2.74850088183421*G0_1_0_11_1_1;
    A[641] = 0.0;
    A[537] = A[72];
    A[660] = 0.0;
    A[695] = 0.0;
    A[262] = 0.0;
    A[293] = 0.0;
    A[745] = A[309] - 1.70440917107583*G0_0_1_0_0_0 - 1.70440917107583*G0_0_1_0_0_1 + 0.237037037037038*G0_0_1_1_0_0 - 0.823985890652556*G0_0_1_2_0_1 + 0.293474426807759*G0_0_1_3_0_0 + 1.35449735449735*G0_0_1_3_0_1 - 0.293474426807759*G0_0_1_4_0_0 + 2.52839506172839*G0_0_1_4_0_1 + 1.4673721340388*G0_0_1_5_0_0 - 1.35449735449735*G0_0_1_5_0_1 - 1.70440917107583*G0_0_1_6_1_0 - 1.70440917107583*G0_0_1_6_1_1 + 0.237037037037038*G0_0_1_7_1_0 - 0.823985890652556*G0_0_1_8_1_1 + 0.293474426807759*G0_0_1_9_1_0 + 1.35449735449735*G0_0_1_9_1_1 - 0.293474426807759*G0_0_1_10_1_0 + 2.52839506172839*G0_0_1_10_1_1 + 1.4673721340388*G0_0_1_11_1_0 - 1.35449735449735*G0_0_1_11_1_1 + 1.70440917107583*G0_1_0_0_0_0 + 1.70440917107583*G0_1_0_0_0_1 - 0.237037037037038*G0_1_0_1_0_0 + 0.823985890652556*G0_1_0_2_0_1 - 0.293474426807759*G0_1_0_3_0_0 - 1.35449735449735*G0_1_0_3_0_1 + 0.293474426807759*G0_1_0_4_0_0 - 2.52839506172839*G0_1_0_4_0_1 - 1.4673721340388*G0_1_0_5_0_0 + 1.35449735449735*G0_1_0_5_0_1 + 1.70440917107583*G0_1_0_6_1_0 + 1.70440917107583*G0_1_0_6_1_1 - 0.237037037037038*G0_1_0_7_1_0 + 0.823985890652556*G0_1_0_8_1_1 - 0.293474426807759*G0_1_0_9_1_0 - 1.35449735449735*G0_1_0_9_1_1 + 0.293474426807759*G0_1_0_10_1_0 - 2.52839506172839*G0_1_0_10_1_1 - 1.4673721340388*G0_1_0_11_1_0 + 1.35449735449735*G0_1_0_11_1_1;
    A[320] = 0.0;
    A[770] = A[305];
    A[459] = 0.0;
    A[355] = 0.0;
    A[799] = A[334];
    A[105] = 0.0;
    A[33] = -A[506] - 0.0451499118165792*G0_0_0_0_0_0 - 0.0451499118165793*G0_0_0_0_0_1 - 0.615167548500884*G0_0_0_1_0_0 + 0.0451499118165794*G0_0_0_2_0_1 - 0.479717813051145*G0_0_0_3_0_0 - 1.14003527336861*G0_0_0_3_0_1 + 0.479717813051145*G0_0_0_4_0_0 + 0.660317460317463*G0_0_0_5_0_0 + 1.14003527336861*G0_0_0_5_0_1 - 0.0451499118165792*G0_0_0_6_1_0 - 0.0451499118165793*G0_0_0_6_1_1 - 0.615167548500884*G0_0_0_7_1_0 + 0.0451499118165794*G0_0_0_8_1_1 - 0.479717813051145*G0_0_0_9_1_0 - 1.14003527336861*G0_0_0_9_1_1 + 0.479717813051145*G0_0_0_10_1_0 + 0.660317460317463*G0_0_0_