// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F2_P2_Q3_TENSOR_H
#define __LAPLACIAN_F2_P2_Q3_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f2_p2_q3_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p2_q3_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q3_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p2_q3_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class laplacian_f2_p2_q3_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p2_q3_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q3_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p2_q3_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p2_q3_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p2_q3_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q3_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p2_q3_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p2_q3_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p2_q3_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q3_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p2_q3_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f2_p2_q3_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f2_p2_q3_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q3_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    432
    // Number of operations (multiply-add pairs) for tensor contraction: 7509
    // Total number of operations (multiply-add pairs):                  7952
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3 = det*(w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4 = det*(w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5 = det*(w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3 = det*(w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4 = det*(w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5 = det*(w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3 = det*(w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4 = det*(w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5 = det*(w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0 = det*(w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1 = det*(w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2 = det*(w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3 = det*(w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4 = det*(w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5 = det*(w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0 = det*(w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1 = det*(w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2 = det*(w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3 = det*(w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4 = det*(w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5 = det*(w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0 = det*(w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1 = det*(w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2 = det*(w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3 = det*(w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4 = det*(w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5 = det*(w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3 = det*(w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4 = det*(w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5 = det*(w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3 = det*(w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4 = det*(w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5 = det*(w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3 = det*(w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4 = det*(w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5 = det*(w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0 = det*(w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1 = det*(w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2 = det*(w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3 = det*(w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4 = det*(w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5 = det*(w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0 = det*(w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1 = det*(w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2 = det*(w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3 = det*(w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4 = det*(w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5 = det*(w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0 = det*(w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1 = det*(w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2 = det*(w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3 = det*(w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4 = det*(w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5 = det*(w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3 = det*(w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4 = det*(w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5 = det*(w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3 = det*(w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4 = det*(w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5 = det*(w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3 = det*(w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4 = det*(w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5 = det*(w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0 = det*(w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1 = det*(w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2 = det*(w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3 = det*(w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4 = det*(w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5 = det*(w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0 = det*(w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1 = det*(w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2 = det*(w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3 = det*(w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4 = det*(w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5 = det*(w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0 = det*(w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1 = det*(w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2 = det*(w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3 = det*(w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4 = det*(w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5 = det*(w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3 = det*(w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4 = det*(w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5 = det*(w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3 = det*(w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4 = det*(w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5 = det*(w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3 = det*(w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4 = det*(w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5 = det*(w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0 = det*(w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1 = det*(w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2 = det*(w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3 = det*(w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4 = det*(w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5 = det*(w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0 = det*(w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1 = det*(w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2 = det*(w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3 = det*(w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4 = det*(w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5 = det*(w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0 = det*(w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1 = det*(w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2 = det*(w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3 = det*(w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4 = det*(w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5 = det*(w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[73] = -0.0160714285714286*G0_0_0_0_0 - 0.00160714285714283*G0_0_0_0_1 + 0.00160714285714287*G0_0_0_0_3 - 0.00964285714285713*G0_0_0_0_4 + 0.00964285714285707*G0_0_0_0_5 - 0.00160714285714283*G0_0_0_1_0 + 0.036160714285714*G0_0_0_1_1 - 0.0104464285714285*G0_0_0_1_2 + 0.0449999999999998*G0_0_0_1_3 + 0.00803571428571426*G0_0_0_1_4 + 0.01125*G0_0_0_1_5 - 0.0104464285714285*G0_0_0_2_1 + 0.00401785714285709*G0_0_0_2_2 - 0.00160714285714285*G0_0_0_2_3 + 0.0176785714285713*G0_0_0_2_4 + 0.0144642857142857*G0_0_0_2_5 + 0.00160714285714287*G0_0_0_3_0 + 0.0449999999999998*G0_0_0_3_1 - 0.00160714285714285*G0_0_0_3_2 + 0.167142857142856*G0_0_0_3_3 - 0.0192857142857142*G0_0_0_3_4 - 0.032142857142857*G0_0_0_3_5 - 0.00964285714285713*G0_0_0_4_0 + 0.00803571428571426*G0_0_0_4_1 + 0.0176785714285713*G0_0_0_4_2 - 0.0192857142857142*G0_0_0_4_3 - 0.064285714285714*G0_0_0_4_4 - 0.0449999999999998*G0_0_0_4_5 + 0.00964285714285707*G0_0_0_5_0 + 0.01125*G0_0_0_5_1 + 0.0144642857142857*G0_0_0_5_2 - 0.032142857142857*G0_0_0_5_3 - 0.0449999999999998*G0_0_0_5_4 - 0.102857142857142*G0_0_0_5_5 - 0.0120535714285712*G0_0_1_0_0 - 0.00281249999999996*G0_0_1_0_1 + 0.000401785714285703*G0_0_1_0_2 - 0.00160714285714282*G0_0_1_0_3 - 0.00321428571428567*G0_0_1_0_4 + 0.01125*G0_0_1_0_5 - 0.00281249999999997*G0_0_1_1_0 + 0.15267857142857*G0_0_1_1_1 - 0.0148660714285713*G0_0_1_1_2 + 0.0723214285714281*G0_0_1_1_3 + 0.00160714285714286*G0_0_1_1_4 + 0.00803571428571422*G0_0_1_1_5 + 0.000401785714285703*G0_0_1_2_0 - 0.0148660714285713*G0_0_1_2_1 + 0.00160714285714284*G0_0_1_2_2 - 0.0144642857142856*G0_0_1_2_3 + 0.0032142857142857*G0_0_1_2_4 + 0.00803571428571427*G0_0_1_2_5 - 0.00160714285714282*G0_0_1_3_0 + 0.0723214285714281*G0_0_1_3_1 - 0.0144642857142856*G0_0_1_3_2 + 0.109285714285714*G0_0_1_3_3 - 0.0128571428571428*G0_0_1_3_5 - 0.00321428571428567*G0_0_1_4_0 + 0.00160714285714286*G0_0_1_4_1 + 0.0032142857142857*G0_0_1_4_2 - 0.00642857142857145*G0_0_1_4_4 - 0.0192857142857142*G0_0_1_4_5 + 0.01125*G0_0_1_5_0 + 0.00803571428571421*G0_0_1_5_1 + 0.00803571428571427*G0_0_1_5_2 - 0.0128571428571428*G0_0_1_5_3 - 0.0192857142857142*G0_0_1_5_4 - 0.147857142857142*G0_0_1_5_5 - 0.00321428571428569*G0_1_0_0_1 - 0.00160714285714284*G0_1_0_0_2 - 0.00321428571428567*G0_1_0_0_3 + 0.00642857142857142*G0_1_0_0_4 + 0.0096428571428571*G0_1_0_0_5 - 0.00321428571428569*G0_1_0_1_0 + 0.0401785714285712*G0_1_0_1_1 - 0.0112499999999999*G0_1_0_1_2 + 0.0482142857142855*G0_1_0_1_3 + 0.0064285714285714*G0_1_0_1_4 + 0.0160714285714285*G0_1_0_1_5 - 0.00160714285714284*G0_1_0_2_0 - 0.0112499999999999*G0_1_0_2_1 - 0.00642857142857144*G0_1_0_2_3 + 0.00642857142857135*G0_1_0_2_4 + 0.0128571428571428*G0_1_0_2_5 - 0.00321428571428567*G0_1_0_3_0 + 0.0482142857142855*G0_1_0_3_1 - 0.00642857142857144*G0_1_0_3_2 + 0.212142857142856*G0_1_0_3_3 - 0.00642857142857139*G0_1_0_3_4 - 0.0192857142857142*G0_1_0_3_5 + 0.00642857142857142*G0_1_0_4_0 + 0.0064285714285714*G0_1_0_4_1 + 0.00642857142857135*G0_1_0_4_2 - 0.00642857142857139*G0_1_0_4_3 - 0.00642857142857145*G0_1_0_4_4 - 0.0385714285714284*G0_1_0_4_5 + 0.0096428571428571*G0_1_0_5_0 + 0.0160714285714285*G0_1_0_5_1 + 0.0128571428571428*G0_1_0_5_2 - 0.0192857142857142*G0_1_0_5_3 - 0.0385714285714284*G0_1_0_5_4 - 0.109285714285714*G0_1_0_5_5 + 0.00401785714285709*G0_1_1_0_0 - 0.0080357142857142*G0_1_1_0_1 - 0.000803571428571427*G0_1_1_0_2 - 0.00321428571428567*G0_1_1_0_3 + 0.00482142857142855*G0_1_1_0_4 + 0.0192857142857142*G0_1_1_0_5 - 0.0080357142857142*G0_1_1_1_0 + 0.168749999999999*G0_1_1_1_1 - 0.0160714285714285*G0_1_1_1_2 + 0.0803571428571424*G0_1_1_1_3 + 0.0160714285714284*G0_1_1_1_5 - 0.000803571428571427*G0_1_1_2_0 - 0.0160714285714285*G0_1_1_2_1 + 0.00241071428571427*G0_1_1_2_2 - 0.0192857142857142*G0_1_1_2_3 - 0.00160714285714284*G0_1_1_2_4 + 0.00321428571428572*G0_1_1_2_5 - 0.00321428571428567*G0_1_1_3_0 + 0.0803571428571424*G0_1_1_3_1 - 0.0192857142857142*G0_1_1_3_2 + 0.128571428571428*G0_1_1_3_3 + 0.00642857142857137*G0_1_1_3_4 + 0.00482142857142855*G0_1_1_4_0 - 0.00160714285714284*G0_1_1_4_2 + 0.00642857142857137*G0_1_1_4_3 + 0.0128571428571428*G0_1_1_4_4 - 0.00642857142857146*G0_1_1_4_5 + 0.0192857142857142*G0_1_1_5_0 + 0.0160714285714284*G0_1_1_5_1 + 0.00321428571428572*G0_1_1_5_2 - 0.00642857142857146*G0_1_1_5_4 - 0.128571428571428*G0_1_1_5_5;
    A[37] = A[73] + 0.0120535714285713*G0_0_1_0_0 - 0.00040178571428573*G0_0_1_0_1 - 0.00200892857142855*G0_0_1_0_2 - 0.00160714285714285*G0_0_1_0_3 + 0.00964285714285709*G0_0_1_0_4 - 0.00160714285714289*G0_0_1_0_5 - 0.000401785714285727*G0_0_1_1_0 - 0.112499999999999*G0_0_1_1_1 + 0.0036160714285714*G0_0_1_1_2 - 0.0241071428571426*G0_0_1_1_3 + 0.00482142857142854*G0_0_1_1_4 + 0.00803571428571428*G0_0_1_1_5 - 0.00200892857142855*G0_0_1_2_0 + 0.0036160714285714*G0_0_1_2_1 - 0.00160714285714291*G0_0_1_2_2 + 0.00803571428571418*G0_0_1_2_3 + 0.00321428571428565*G0_0_1_2_4 + 0.00482142857142853*G0_0_1_2_5 - 0.00160714285714285*G0_0_1_3_0 - 0.0241071428571426*G0_0_1_3_1 + 0.00803571428571418*G0_0_1_3_2 + 0.102857142857142*G0_0_1_3_3 - 0.00642857142857136*G0_0_1_3_4 - 0.00642857142857132*G0_0_1_3_5 + 0.00964285714285709*G0_0_1_4_0 + 0.00482142857142854*G0_0_1_4_1 + 0.00321428571428565*G0_0_1_4_2 - 0.00642857142857136*G0_0_1_4_3 - 0.0192857142857142*G0_0_1_4_5 - 0.00160714285714289*G0_0_1_5_0 + 0.00803571428571429*G0_0_1_5_1 + 0.00482142857142853*G0_0_1_5_2 - 0.00642857142857134*G0_0_1_5_3 - 0.0192857142857142*G0_0_1_5_4 + 0.0385714285714285*G0_0_1_5_5 - 0.0120535714285713*G0_1_0_0_0 + 0.00040178571428573*G0_1_0_0_1 + 0.00200892857142855*G0_1_0_0_2 + 0.00160714285714285*G0_1_0_0_3 - 0.00964285714285709*G0_1_0_0_4 + 0.00160714285714289*G0_1_0_0_5 + 0.000401785714285726*G0_1_0_1_0 + 0.112499999999999*G0_1_0_1_1 - 0.0036160714285714*G0_1_0_1_2 + 0.0241071428571426*G0_1_0_1_3 - 0.00482142857142854*G0_1_0_1_4 - 0.00803571428571428*G0_1_0_1_5 + 0.00200892857142855*G0_1_0_2_0 - 0.0036160714285714*G0_1_0_2_1 + 0.00160714285714291*G0_1_0_2_2 - 0.00803571428571419*G0_1_0_2_3 - 0.00321428571428565*G0_1_0_2_4 - 0.00482142857142853*G0_1_0_2_5 + 0.00160714285714285*G0_1_0_3_0 + 0.0241071428571426*G0_1_0_3_1 - 0.00803571428571418*G0_1_0_3_2 - 0.102857142857142*G0_1_0_3_3 + 0.00642857142857136*G0_1_0_3_4 + 0.00642857142857132*G0_1_0_3_5 - 0.00964285714285709*G0_1_0_4_0 - 0.00482142857142854*G0_1_0_4_1 - 0.00321428571428565*G0_1_0_4_2 + 0.00642857142857136*G0_1_0_4_3 + 0.0192857142857142*G0_1_0_4_5 + 0.00160714285714289*G0_1_0_5_0 - 0.00803571428571429*G0_1_0_5_1 - 0.00482142857142853*G0_1_0_5_2 + 0.00642857142857134*G0_1_0_5_3 + 0.0192857142857142*G0_1_0_5_4 - 0.0385714285714285*G0_1_0_5_5;
    A[11] = 0.00648809523809519*G0_0_0_0_0 - 0.0103670634920634*G0_0_0_0_1 - 9.9206349206373e-06*G0_0_0_0_2 - 0.00575396825396821*G0_0_0_0_3 + 0.000714285714285707*G0_0_0_0_4 - 0.00714285714285709*G0_0_0_0_5 - 0.0103670634920634*G0_0_0_1_0 + 0.131845238095237*G0_0_0_1_1 - 0.0103670634920634*G0_0_0_1_2 + 0.0428571428571426*G0_0_0_1_3 + 0.00138888888888889*G0_0_0_1_4 + 0.0428571428571426*G0_0_0_1_5 - 9.92063492063757e-06*G0_0_0_2_0 - 0.0103670634920634*G0_0_0_2_1 + 0.00648809523809523*G0_0_0_2_2 - 0.00714285714285711*G0_0_0_2_3 + 0.00071428571428572*G0_0_0_2_4 - 0.00575396825396822*G0_0_0_2_5 - 0.00575396825396821*G0_0_0_3_0 + 0.0428571428571426*G0_0_0_3_1 - 0.00714285714285711*G0_0_0_3_2 + 0.0460317460317458*G0_0_0_3_3 + 0.00873015873015869*G0_0_0_3_4 + 0.0230158730158729*G0_0_0_3_5 + 0.000714285714285707*G0_0_0_4_0 + 0.00138888888888889*G0_0_0_4_1 + 0.00071428571428572*G0_0_0_4_2 + 0.00873015873015869*G0_0_0_4_3 + 0.0231746031746031*G0_0_0_4_4 + 0.00873015873015869*G0_0_0_4_5 - 0.00714285714285709*G0_0_0_5_0 + 0.0428571428571426*G0_0_0_5_1 - 0.00575396825396822*G0_0_0_5_2 + 0.0230158730158729*G0_0_0_5_3 + 0.00873015873015869*G0_0_0_5_4 + 0.0460317460317458*G0_0_0_5_5;
    A[99] = 0.0771428571428569*G0_0_0_0_0 - 0.00964285714285713*G0_0_0_0_1 - 0.0289285714285713*G0_0_0_0_2 - 0.0771428571428566*G0_0_0_0_3 + 0.0385714285714287*G0_0_0_0_4 - 0.00964285714285713*G0_0_0_1_0 + 0.0771428571428567*G0_0_0_1_1 - 0.0289285714285712*G0_0_0_1_2 + 0.0385714285714286*G0_0_0_1_3 - 0.0771428571428568*G0_0_0_1_4 - 0.0289285714285713*G0_0_0_2_0 - 0.0289285714285712*G0_0_0_2_1 + 0.0964285714285708*G0_0_0_2_2 - 0.0385714285714284*G0_0_0_2_5 - 0.0771428571428566*G0_0_0_3_0 + 0.0385714285714286*G0_0_0_3_1 + 1.23428571428571*G0_0_0_3_3 + 0.308571428571427*G0_0_0_3_4 + 0.231428571428571*G0_0_0_3_5 + 0.0385714285714287*G0_0_0_4_0 - 0.0771428571428568*G0_0_0_4_1 + 0.308571428571427*G0_0_0_4_3 + 1.23428571428571*G0_0_0_4_4 + 0.231428571428571*G0_0_0_4_5 - 0.0385714285714284*G0_0_0_5_2 + 0.231428571428571*G0_0_0_5_3 + 0.231428571428571*G0_0_0_5_4 + 0.154285714285714*G0_0_0_5_5 + 0.0289285714285714*G0_0_1_0_0 - 0.00482142857142858*G0_0_1_0_1 - 0.00482142857142855*G0_0_1_0_2 - 0.0578571428571424*G0_0_1_0_3 + 0.0192857142857143*G0_0_1_0_4 + 0.0192857142857142*G0_0_1_0_5 - 0.00482142857142858*G0_0_1_1_0 + 0.0482142857142855*G0_0_1_1_1 - 0.0241071428571427*G0_0_1_1_2 + 0.0192857142857144*G0_0_1_1_3 - 0.0192857142857142*G0_0_1_1_4 - 0.0192857142857141*G0_0_1_1_5 - 0.00482142857142855*G0_0_1_2_0 - 0.0241071428571427*G0_0_1_2_1 + 0.0482142857142854*G0_0_1_2_2 + 0.019285714285714*G0_0_1_2_3 - 0.0192857142857143*G0_0_1_2_4 - 0.0192857142857142*G0_0_1_2_5 - 0.0578571428571424*G0_0_1_3_0 + 0.0192857142857143*G0_0_1_3_1 + 0.019285714285714*G0_0_1_3_2 + 1.15714285714285*G0_0_1_3_3 + 0.154285714285714*G0_0_1_3_4 + 0.154285714285714*G0_0_1_3_5 + 0.0192857142857143*G0_0_1_4_0 - 0.0192857142857142*G0_0_1_4_1 - 0.0192857142857143*G0_0_1_4_2 + 0.154285714285714*G0_0_1_4_3 + 0.0771428571428566*G0_0_1_4_4 + 0.0771428571428569*G0_0_1_4_5 + 0.0192857142857142*G0_0_1_5_0 - 0.0192857142857141*G0_0_1_5_1 - 0.0192857142857142*G0_0_1_5_2 + 0.154285714285714*G0_0_1_5_3 + 0.0771428571428569*G0_0_1_5_4 + 0.0771428571428569*G0_0_1_5_5 + 0.0289285714285714*G0_1_0_0_0 - 0.00482142857142858*G0_1_0_0_1 - 0.00482142857142855*G0_1_0_0_2 - 0.0578571428571424*G0_1_0_0_3 + 0.0192857142857143*G0_1_0_0_4 + 0.0192857142857142*G0_1_0_0_5 - 0.00482142857142858*G0_1_0_1_0 + 0.0482142857142855*G0_1_0_1_1 - 0.0241071428571427*G0_1_0_1_2 + 0.0192857142857143*G0_1_0_1_3 - 0.0192857142857142*G0_1_0_1_4 - 0.0192857142857141*G0_1_0_1_5 - 0.00482142857142855*G0_1_0_2_0 - 0.0241071428571427*G0_1_0_2_1 + 0.0482142857142854*G0_1_0_2_2 + 0.019285714285714*G0_1_0_2_3 - 0.0192857142857143*G0_1_0_2_4 - 0.0192857142857142*G0_1_0_2_5 - 0.0578571428571424*G0_1_0_3_0 + 0.0192857142857143*G0_1_0_3_1 + 0.019285714285714*G0_1_0_3_2 + 1.15714285714285*G0_1_0_3_3 + 0.154285714285714*G0_1_0_3_4 + 0.154285714285714*G0_1_0_3_5 + 0.0192857142857143*G0_1_0_4_0 - 0.0192857142857142*G0_1_0_4_1 - 0.0192857142857143*G0_1_0_4_2 + 0.154285714285714*G0_1_0_4_3 + 0.0771428571428566*G0_1_0_4_4 + 0.0771428571428569*G0_1_0_4_5 + 0.0192857142857142*G0_1_0_5_0 - 0.0192857142857141*G0_1_0_5_1 - 0.0192857142857142*G0_1_0_5_2 + 0.154285714285714*G0_1_0_5_3 + 0.0771428571428569*G0_1_0_5_4 + 0.0771428571428569*G0_1_0_5_5 + 0.0771428571428569*G0_1_1_0_0 - 0.0289285714285713*G0_1_1_0_1 - 0.00964285714285711*G0_1_1_0_2 - 0.0771428571428567*G0_1_1_0_3 + 0.0385714285714285*G0_1_1_0_5 - 0.0289285714285713*G0_1_1_1_0 + 0.096428571428571*G0_1_1_1_1 - 0.0289285714285713*G0_1_1_1_2 - 0.0385714285714284*G0_1_1_1_4 - 0.00964285714285711*G0_1_1_2_0 - 0.0289285714285713*G0_1_1_2_1 + 0.0771428571428568*G0_1_1_2_2 + 0.0385714285714283*G0_1_1_2_3 - 0.0771428571428568*G0_1_1_2_5 - 0.0771428571428566*G0_1_1_3_0 + 0.0385714285714283*G0_1_1_3_2 + 1.23428571428571*G0_1_1_3_3 + 0.231428571428571*G0_1_1_3_4 + 0.308571428571427*G0_1_1_3_5 - 0.0385714285714284*G0_1_1_4_1 + 0.231428571428571*G0_1_1_4_3 + 0.154285714285714*G0_1_1_4_4 + 0.231428571428571*G0_1_1_4_5 + 0.0385714285714285*G0_1_1_5_0 - 0.0771428571428568*G0_1_1_5_2 + 0.308571428571427*G0_1_1_5_3 + 0.231428571428571*G0_1_1_5_4 + 1.23428571428571*G0_1_1_5_5;
    A[78] = -A[73] - 0.164732142857142*G0_0_0_0_0 + 0.0124553571428571*G0_0_0_0_1 + 0.0108482142857142*G0_0_0_0_2 + 0.0128571428571428*G0_0_0_0_3 - 0.0707142857142853*G0_0_0_0_4 - 0.00160714285714283*G0_0_0_0_5 + 0.0124553571428571*G0_0_0_1_0 - 0.112499999999999*G0_0_0_1_1 + 0.000401785714285702*G0_0_0_1_2 - 0.0160714285714284*G0_0_0_1_3 + 0.0192857142857142*G0_0_0_1_4 + 0.0108482142857142*G0_0_0_2_0 + 0.000401785714285698*G0_0_0_2_1 - 0.00482142857142859*G0_0_0_2_2 + 0.0273214285714284*G0_0_0_2_3 + 0.0466071428571426*G0_0_0_2_4 + 0.0482142857142855*G0_0_0_2_5 + 0.0128571428571428*G0_0_0_3_0 - 0.0160714285714284*G0_0_0_3_1 + 0.0273214285714284*G0_0_0_3_2 + 0.0257142857142854*G0_0_0_3_3 - 0.064285714285714*G0_0_0_3_4 - 0.122142857142857*G0_0_0_3_5 - 0.0707142857142853*G0_0_0_4_0 + 0.0192857142857142*G0_0_0_4_1 + 0.0466071428571426*G0_0_0_4_2 - 0.064285714285714*G0_0_0_4_3 - 0.205714285714285*G0_0_0_4_4 - 0.134999999999999*G0_0_0_4_5 - 0.00160714285714283*G0_0_0_5_0 + 0.0482142857142855*G0_0_0_5_2 - 0.122142857142857*G0_0_0_5_3 - 0.134999999999999*G0_0_0_5_4 - 0.424285714285713*G0_0_0_5_5 + 0.0040178571428571*G0_1_0_0_0 + 0.00803571428571423*G0_1_0_0_1 - 0.00562499999999996*G0_1_0_0_2 + 0.00964285714285711*G0_1_0_0_3 + 0.0176785714285714*G0_1_0_0_4 + 0.00642857142857136*G0_1_0_0_5 + 0.00803571428571423*G0_1_0_1_0 - 0.120535714285713*G0_1_0_1_1 - 0.0160714285714284*G0_1_0_1_3 + 0.0160714285714285*G0_1_0_1_4 + 0.0160714285714285*G0_1_0_1_5 - 0.00562499999999996*G0_1_0_2_0 - 0.00723214285714292*G0_1_0_2_2 + 0.0257142857142856*G0_1_0_2_3 + 0.020892857142857*G0_1_0_2_4 + 0.0546428571428569*G0_1_0_2_5 + 0.00964285714285711*G0_1_0_3_0 - 0.0160714285714284*G0_1_0_3_1 + 0.0257142857142856*G0_1_0_3_2 + 0.0642857142857137*G0_1_0_3_3 - 0.0514285714285712*G0_1_0_3_4 - 0.128571428571428*G0_1_0_3_5 + 0.0176785714285714*G0_1_0_4_0 + 0.0160714285714285*G0_1_0_4_1 + 0.020892857142857*G0_1_0_4_2 - 0.0514285714285712*G0_1_0_4_3 - 0.0385714285714285*G0_1_0_4_4 - 0.141428571428571*G0_1_0_4_5 + 0.00642857142857136*G0_1_0_5_0 + 0.0160714285714285*G0_1_0_5_1 + 0.0546428571428569*G0_1_0_5_2 - 0.128571428571428*G0_1_0_5_3 - 0.141428571428571*G0_1_0_5_4 - 0.578571428571426*G0_1_0_5_5;
    A[21] = 0.00247023809523808*G0_1_0_0_0 - 0.00157242063492062*G0_1_0_0_1 - 0.00157242063492063*G0_1_0_0_2 - 0.000932539682539675*G0_1_0_0_3 - 0.0032142857142857*G0_1_0_0_4 - 0.00321428571428569*G0_1_0_0_5 - 0.00157242063492062*G0_1_0_1_0 + 0.019345238095238*G0_1_0_1_1 - 0.00112599206349206*G0_1_0_1_2 + 0.00178571428571426*G0_1_0_1_3 - 0.000575396825396823*G0_1_0_1_4 + 0.00892857142857136*G0_1_0_1_5 - 0.00157242063492063*G0_1_0_2_0 - 0.00112599206349206*G0_1_0_2_1 + 0.0193452380952381*G0_1_0_2_2 + 0.00178571428571429*G0_1_0_2_3 + 0.0089285714285714*G0_1_0_2_4 - 0.000575396825396815*G0_1_0_2_5 - 0.000932539682539675*G0_1_0_3_0 + 0.00178571428571426*G0_1_0_3_1 + 0.00178571428571429*G0_1_0_3_2 - 0.00539682539682539*G0_1_0_3_3 + 0.003015873015873*G0_1_0_3_4 + 0.00301587301587299*G0_1_0_3_5 - 0.0032142857142857*G0_1_0_4_0 - 0.000575396825396823*G0_1_0_4_1 + 0.0089285714285714*G0_1_0_4_2 + 0.003015873015873*G0_1_0_4_3 + 0.00888888888888885*G0_1_0_4_4 + 0.00230158730158729*G0_1_0_4_5 - 0.00321428571428569*G0_1_0_5_0 + 0.00892857142857136*G0_1_0_5_1 - 0.000575396825396816*G0_1_0_5_2 + 0.00301587301587299*G0_1_0_5_3 + 0.00230158730158729*G0_1_0_5_4 + 0.00888888888888882*G0_1_0_5_5;
    A[1] = -A[21] - 0.019345238095238*G0_0_0_0_0 + 0.00112599206349206*G0_0_0_0_1 + 0.00157242063492063*G0_0_0_0_2 + 0.00057539682539682*G0_0_0_0_3 - 0.00892857142857138*G0_0_0_0_4 - 0.00178571428571427*G0_0_0_0_5 + 0.00112599206349206*G0_0_0_1_0 - 0.019345238095238*G0_0_0_1_1 + 0.00157242063492063*G0_0_0_1_2 - 0.00892857142857139*G0_0_0_1_3 + 0.00057539682539682*G0_0_0_1_4 - 0.00178571428571429*G0_0_0_1_5 + 0.00157242063492063*G0_0_0_2_0 + 0.00157242063492063*G0_0_0_2_1 - 0.0024702380952381*G0_0_0_2_2 + 0.0032142857142857*G0_0_0_2_3 + 0.0032142857142857*G0_0_0_2_4 + 0.00093253968253968*G0_0_0_2_5 + 0.00057539682539682*G0_0_0_3_0 - 0.00892857142857139*G0_0_0_3_1 + 0.0032142857142857*G0_0_0_3_2 - 0.00888888888888886*G0_0_0_3_3 - 0.00230158730158729*G0_0_0_3_4 - 0.00301587301587301*G0_0_0_3_5 - 0.00892857142857138*G0_0_0_4_0 + 0.00057539682539682*G0_0_0_4_1 + 0.0032142857142857*G0_0_0_4_2 - 0.00230158730158729*G0_0_0_4_3 - 0.00888888888888883*G0_0_0_4_4 - 0.003015873015873*G0_0_0_4_5 - 0.00178571428571427*G0_0_0_5_0 - 0.00178571428571429*G0_0_0_5_1 + 0.00093253968253968*G0_0_0_5_2 - 0.00301587301587301*G0_0_0_5_3 - 0.003015873015873*G0_0_0_5_4 + 0.00539682539682535*G0_0_0_5_5 - 0.0168749999999999*G0_1_0_0_0 - 0.000446428571428565*G0_1_0_0_1 - 0.000357142857142855*G0_1_0_0_3 - 0.0121428571428571*G0_1_0_0_4 - 0.00499999999999996*G0_1_0_0_5 - 0.000446428571428565*G0_1_0_1_0 + 0.00044642857142857*G0_1_0_1_2 - 0.00714285714285712*G0_1_0_1_3 + 0.00714285714285708*G0_1_0_1_5 + 0.00044642857142857*G0_1_0_2_1 + 0.016875*G0_1_0_2_2 + 0.00499999999999999*G0_1_0_2_3 + 0.0121428571428571*G0_1_0_2_4 + 0.000357142857142864*G0_1_0_2_5 - 0.000357142857142855*G0_1_0_3_0 - 0.00714285714285712*G0_1_0_3_1 + 0.00499999999999999*G0_1_0_3_2 - 0.0142857142857142*G0_1_0_3_3 + 0.000714285714285708*G0_1_0_3_4 - 0.0121428571428571*G0_1_0_4_0 + 0.0121428571428571*G0_1_0_4_2 + 0.000714285714285708*G0_1_0_4_3 - 0.000714285714285711*G0_1_0_4_5 - 0.00499999999999996*G0_1_0_5_0 + 0.00714285714285708*G0_1_0_5_1 + 0.000357142857142863*G0_1_0_5_2 - 0.000714285714285711*G0_1_0_5_4 + 0.0142857142857142*G0_1_0_5_5;
    A[22] = 0.00648809523809519*G0_1_1_0_0 - 9.92063492063439e-06*G0_1_1_0_1 - 0.0103670634920634*G0_1_1_0_2 - 0.00575396825396821*G0_1_1_0_3 - 0.0071428571428571*G0_1_1_0_4 + 0.000714285714285705*G0_1_1_0_5 - 9.92063492063436e-06*G0_1_1_1_0 + 0.00648809523809519*G0_1_1_1_1 - 0.0103670634920634*G0_1_1_1_2 - 0.0071428571428571*G0_1_1_1_3 - 0.00575396825396822*G0_1_1_1_4 + 0.000714285714285703*G0_1_1_1_5 - 0.0103670634920634*G0_1_1_2_0 - 0.0103670634920634*G0_1_1_2_1 + 0.131845238095238*G0_1_1_2_2 + 0.0428571428571426*G0_1_1_2_3 + 0.0428571428571426*G0_1_1_2_4 + 0.00138888888888891*G0_1_1_2_5 - 0.00575396825396821*G0_1_1_3_0 - 0.0071428571428571*G0_1_1_3_1 + 0.0428571428571426*G0_1_1_3_2 + 0.0460317460317458*G0_1_1_3_3 + 0.0230158730158729*G0_1_1_3_4 + 0.0087301587301587*G0_1_1_3_5 - 0.0071428571428571*G0_1_1_4_0 - 0.00575396825396822*G0_1_1_4_1 + 0.0428571428571426*G0_1_1_4_2 + 0.0230158730158729*G0_1_1_4_3 + 0.0460317460317458*G0_1_1_4_4 + 0.0087301587301587*G0_1_1_4_5 + 0.000714285714285705*G0_1_1_5_0 + 0.000714285714285703*G0_1_1_5_1 + 0.00138888888888891*G0_1_1_5_2 + 0.0087301587301587*G0_1_1_5_3 + 0.0087301587301587*G0_1_1_5_4 + 0.023174603174603*G0_1_1_5_5;
    A[92] = 0.00374999999999998*G0_0_1_0_0 - 0.00267857142857141*G0_0_1_0_2 - 0.00428571428571427*G0_0_1_0_3 - 0.0171428571428571*G0_0_1_0_4 - 0.00107142857142859*G0_0_1_0_5 - 0.00374999999999993*G0_0_1_1_1 + 0.0026785714285714*G0_0_1_1_2 + 0.0171428571428571*G0_0_1_1_3 + 0.00428571428571428*G0_0_1_1_4 + 0.0010714285714286*G0_0_1_1_5 - 0.00267857142857141*G0_0_1_2_0 + 0.0026785714285714*G0_0_1_2_1 - 0.0321428571428569*G0_0_1_2_3 + 0.032142857142857*G0_0_1_2_4 - 0.00428571428571427*G0_0_1_3_0 + 0.0171428571428571*G0_0_1_3_1 - 0.0321428571428569*G0_0_1_3_2 + 0.00857142857142854*G0_0_1_3_5 - 0.0171428571428571*G0_0_1_4_0 + 0.00428571428571428*G0_0_1_4_1 + 0.032142857142857*G0_0_1_4_2 - 0.00857142857142854*G0_0_1_4_5 - 0.00107142857142859*G0_0_1_5_0 + 0.0010714285714286*G0_0_1_5_1 + 0.00857142857142854*G0_0_1_5_3 - 0.00857142857142854*G0_0_1_5_4 + 0.0117857142857142*G0_1_1_0_0 - 0.00669642857142853*G0_1_1_0_1 + 0.00562499999999997*G0_1_1_0_2 + 0.00214285714285713*G0_1_1_0_3 + 0.00535714285714283*G0_1_1_0_4 + 0.00857142857142854*G0_1_1_0_5 - 0.00669642857142853*G0_1_1_1_0 + 0.00803571428571426*G0_1_1_1_1 + 0.00830357142857138*G0_1_1_1_2 + 0.0224999999999999*G0_1_1_1_3 + 0.00642857142857141*G0_1_1_1_4 + 0.00964285714285712*G0_1_1_1_5 + 0.00562499999999997*G0_1_1_2_0 + 0.00830357142857138*G0_1_1_2_1 - 0.0535714285714284*G0_1_1_2_2 - 0.0535714285714283*G0_1_1_2_3 - 0.0214285714285713*G0_1_1_2_4 - 0.00857142857142854*G0_1_1_2_5 + 0.00214285714285713*G0_1_1_3_0 + 0.0224999999999999*G0_1_1_3_1 - 0.0535714285714283*G0_1_1_3_2 - 0.0257142857142856*G0_1_1_3_3 - 0.0171428571428571*G0_1_1_3_4 + 0.0128571428571427*G0_1_1_3_5 + 0.00535714285714283*G0_1_1_4_0 + 0.00642857142857141*G0_1_1_4_1 - 0.0214285714285713*G0_1_1_4_2 - 0.0171428571428571*G0_1_1_4_3 - 0.0257142857142856*G0_1_1_4_4 + 0.00428571428571421*G0_1_1_4_5 + 0.00857142857142854*G0_1_1_5_0 + 0.00964285714285712*G0_1_1_5_1 - 0.00857142857142854*G0_1_1_5_2 + 0.0128571428571427*G0_1_1_5_3 + 0.00428571428571421*G0_1_1_5_4 + 0.128571428571428*G0_1_1_5_5;
    A[82] = -A[92] - 0.00482142857142852*G0_0_1_0_0 + 0.000937499999999984*G0_0_1_0_1 - 0.00272321428571426*G0_0_1_0_2 - 0.00303571428571428*G0_0_1_0_3 - 0.0124999999999999*G0_0_1_0_4 + 0.00339285714285711*G0_0_1_0_5 + 0.000937499999999983*G0_0_1_1_0 - 0.0291964285714283*G0_0_1_1_1 + 0.00218749999999998*G0_0_1_1_2 + 0.0167857142857142*G0_0_1_1_3 + 0.00517857142857142*G0_0_1_1_4 - 0.00660714285714274*G0_0_1_1_5 - 0.00272321428571426*G0_0_1_2_0 + 0.00218749999999998*G0_0_1_2_1 - 0.0285714285714284*G0_0_1_2_3 + 0.0285714285714284*G0_0_1_2_4 + 0.000535714285714282*G0_0_1_2_5 - 0.00303571428571428*G0_0_1_3_0 + 0.0167857142857142*G0_0_1_3_1 - 0.0285714285714284*G0_0_1_3_2 + 0.0114285714285715*G0_0_1_3_3 - 0.00428571428571428*G0_0_1_3_4 + 0.00499999999999998*G0_0_1_3_5 - 0.0124999999999999*G0_0_1_4_0 + 0.00517857142857142*G0_0_1_4_1 + 0.0285714285714284*G0_0_1_4_2 - 0.00428571428571428*G0_0_1_4_3 - 0.00285714285714294*G0_0_1_4_4 - 0.0114285714285714*G0_0_1_4_5 + 0.00339285714285711*G0_0_1_5_0 - 0.00660714285714274*G0_0_1_5_1 + 0.000535714285714283*G0_0_1_5_2 + 0.00499999999999998*G0_0_1_5_3 - 0.0114285714285714*G0_0_1_5_4 + 0.0385714285714283*G0_0_1_5_5 + 0.0125892857142857*G0_1_1_0_0 - 0.00299107142857142*G0_1_1_0_1 + 0.00486607142857141*G0_1_1_0_2 + 0.00410714285714284*G0_1_1_0_4 + 0.0135714285714285*G0_1_1_0_5 - 0.00299107142857142*G0_1_1_1_0 - 0.0267857142857141*G0_1_1_1_1 + 0.00799107142857138*G0_1_1_1_2 + 0.0198214285714285*G0_1_1_1_3 + 0.0057142857142857*G0_1_1_1_4 - 0.00910714285714274*G0_1_1_1_5 + 0.00486607142857141*G0_1_1_2_0 + 0.00799107142857138*G0_1_1_2_1 - 0.0455357142857143*G0_1_1_2_2 - 0.0517857142857141*G0_1_1_2_3 - 0.0178571428571428*G0_1_1_2_4 - 0.00749999999999998*G0_1_1_2_5 + 0.0198214285714285*G0_1_1_3_1 - 0.0517857142857141*G0_1_1_3_2 + 0.00428571428571432*G0_1_1_3_3 - 0.0114285714285714*G0_1_1_3_4 + 0.0149999999999999*G0_1_1_3_5 + 0.00410714285714284*G0_1_1_4_0 + 0.0057142857142857*G0_1_1_4_1 - 0.0178571428571428*G0_1_1_4_2 - 0.0114285714285714*G0_1_1_4_3 - 0.0242857142857143*G0_1_1_4_4 + 0.00357142857142851*G0_1_1_4_5 + 0.0135714285714285*G0_1_1_5_0 - 0.00910714285714273*G0_1_1_5_1 - 0.00749999999999998*G0_1_1_5_2 + 0.0149999999999999*G0_1_1_5_3 + 0.00357142857142851*G0_1_1_5_4 + 0.0942857142857137*G0_1_1_5_5;
    A[32] = -A[82] - 0.0109821428571428*G0_0_1_0_0 + 0.00709821428571424*G0_0_1_0_2 + 0.00874999999999995*G0_0_1_0_3 + 0.0167857142857142*G0_0_1_0_4 + 0.00785714285714283*G0_0_1_0_5 - 0.0241071428571427*G0_0_1_1_1 + 0.00397321428571427*G0_0_1_1_2 - 0.00535714285714281*G0_0_1_1_3 + 0.00410714285714283*G0_0_1_1_4 - 0.0053571428571428*G0_0_1_1_5 + 0.00709821428571424*G0_0_1_2_0 + 0.00397321428571427*G0_0_1_2_1 - 0.0937499999999997*G0_0_1_2_2 - 0.00178571428571431*G0_0_1_2_3 - 0.0410714285714284*G0_0_1_2_4 + 0.00232142857142855*G0_0_1_2_5 + 0.00874999999999995*G0_0_1_3_0 - 0.00535714285714281*G0_0_1_3_1 - 0.00178571428571431*G0_0_1_3_2 - 0.0314285714285713*G0_0_1_3_3 - 0.0257142857142856*G0_0_1_3_4 - 0.0221428571428571*G0_0_1_3_5 + 0.0167857142857142*G0_0_1_4_0 + 0.00410714285714283*G0_0_1_4_1 - 0.0410714285714284*G0_0_1_4_2 - 0.0257142857142856*G0_0_1_4_3 - 0.0457142857142855*G0_0_1_4_4 - 0.0128571428571428*G0_0_1_4_5 + 0.00785714285714283*G0_0_1_5_0 - 0.0053571428571428*G0_0_1_5_1 + 0.00232142857142855*G0_0_1_5_2 - 0.0221428571428571*G0_0_1_5_3 - 0.0128571428571428*G0_0_1_5_4 + 0.0328571428571426*G0_0_1_5_5;
    A[72] = A[82] + 0.0340178571428569*G0_0_1_0_0 - 0.00187499999999997*G0_0_1_0_1 + 0.000535714285714278*G0_0_1_0_2 - 0.00214285714285713*G0_0_1_0_3 - 0.0042857142857143*G0_0_1_0_4 + 0.00321428571428567*G0_0_1_0_5 - 0.00187499999999997*G0_0_1_1_0 + 0.0340178571428569*G0_0_1_1_1 + 0.000535714285714283*G0_0_1_1_2 - 0.00428571428571431*G0_0_1_1_3 - 0.00214285714285714*G0_0_1_1_4 + 0.00321428571428565*G0_0_1_1_5 + 0.000535714285714277*G0_0_1_2_0 + 0.000535714285714283*G0_0_1_2_1 - 0.00107142857142857*G0_0_1_2_5 - 0.00214285714285713*G0_0_1_3_0 - 0.00428571428571431*G0_0_1_3_1 - 0.00857142857142852*G0_0_1_3_3 + 0.00857142857142855*G0_0_1_3_4 + 0.00642857142857143*G0_0_1_3_5 - 0.0042857142857143*G0_0_1_4_0 - 0.00214285714285714*G0_0_1_4_1 + 0.00857142857142855*G0_0_1_4_3 - 0.0085714285714285*G0_0_1_4_4 + 0.00642857142857143*G0_0_1_4_5 + 0.00321428571428567*G0_0_1_5_0 + 0.00321428571428565*G0_0_1_5_1 - 0.00107142857142858*G0_0_1_5_2 + 0.00642857142857143*G0_0_1_5_3 + 0.00642857142857143*G0_0_1_5_4 - 0.0771428571428566*G0_0_1_5_5 - 0.0101785714285714*G0_1_1_0_0 - 0.000937499999999981*G0_1_1_0_1 + 0.000937499999999975*G0_1_1_0_2 + 0.000535714285714289*G0_1_1_0_3 - 0.00107142857142856*G0_1_1_0_4 - 0.0160714285714285*G0_1_1_0_5 - 0.000937499999999981*G0_1_1_1_0 + 0.0441964285714282*G0_1_1_1_1 - 0.000401785714285703*G0_1_1_1_2 - 0.00321428571428575*G0_1_1_1_3 - 0.00267857142857143*G0_1_1_1_4 + 0.0192857142857141*G0_1_1_1_5 + 0.000937499999999975*G0_1_1_2_0 - 0.000401785714285702*G0_1_1_2_1 + 0.00535714285714285*G0_1_1_2_3 - 0.00535714285714277*G0_1_1_2_4 - 0.000535714285714284*G0_1_1_2_5 + 0.000535714285714289*G0_1_1_3_0 - 0.00321428571428575*G0_1_1_3_1 + 0.00535714285714285*G0_1_1_3_2 - 0.0257142857142857*G0_1_1_3_3 + 0.00428571428571428*G0_1_1_3_4 - 0.00107142857142856*G0_1_1_4_0 - 0.00267857142857143*G0_1_1_4_1 - 0.00535714285714277*G0_1_1_4_2 + 0.00428571428571428*G0_1_1_4_3 + 0.0171428571428572*G0_1_1_4_4 + 0.00642857142857144*G0_1_1_4_5 - 0.0160714285714284*G0_1_1_5_0 + 0.0192857142857141*G0_1_1_5_1 - 0.000535714285714285*G0_1_1_5_2 + 0.00642857142857144*G0_1_1_5_4 - 0.0385714285714283*G0_1_1_5_5;
    A[48] = -A[73] - 0.01125*G0_0_0_0_0 - 0.00200892857142855*G0_0_0_0_1 + 0.000401785714285738*G0_0_0_0_2 - 0.00160714285714281*G0_0_0_0_3 - 0.00321428571428571*G0_0_0_0_4 + 0.00964285714285707*G0_0_0_0_5 - 0.00200892857142855*G0_0_0_1_0 + 0.0482142857142855*G0_0_0_1_1 - 0.0140624999999999*G0_0_0_1_2 + 0.0482142857142855*G0_0_0_1_3 + 0.00803571428571426*G0_0_0_1_4 + 0.0160714285714285*G0_0_0_1_5 + 0.000401785714285738*G0_0_0_2_0 - 0.0140624999999999*G0_0_0_2_1 + 0.00401785714285688*G0_0_0_2_2 + 0.00642857142857135*G0_0_0_2_3 + 0.00964285714285702*G0_0_0_2_4 + 0.0176785714285714*G0_0_0_2_5 - 0.00160714285714281*G0_0_0_3_0 + 0.0482142857142855*G0_0_0_3_1 + 0.00642857142857134*G0_0_0_3_2 + 0.192857142857142*G0_0_0_3_3 - 0.0128571428571428*G0_0_0_3_4 - 0.032142857142857*G0_0_0_3_5 - 0.00321428571428571*G0_0_0_4_0 + 0.00803571428571426*G0_0_0_4_1 + 0.00964285714285702*G0_0_0_4_2 - 0.0128571428571428*G0_0_0_4_3 - 0.102857142857142*G0_0_0_4_4 - 0.0514285714285713*G0_0_0_4_5 + 0.00964285714285707*G0_0_0_5_0 + 0.0160714285714285*G0_0_0_5_1 + 0.0176785714285714*G0_0_0_5_2 - 0.032142857142857*G0_0_0_5_3 - 0.0514285714285713*G0_0_0_5_4 - 0.128571428571428*G0_0_0_5_5 - 0.0112499999999998*G0_0_1_0_0 - 0.0040178571428571*G0_0_1_0_1 - 0.000803571428571417*G0_0_1_0_2 - 0.00642857142857135*G0_0_1_0_3 - 0.0080357142857142*G0_0_1_0_4 + 0.00642857142857144*G0_0_1_0_5 - 0.00401785714285711*G0_0_1_1_0 + 0.168749999999999*G0_0_1_1_1 - 0.0200892857142856*G0_0_1_1_2 + 0.0803571428571424*G0_0_1_1_3 + 0.0160714285714285*G0_0_1_1_5 - 0.000803571428571417*G0_0_1_2_0 - 0.0200892857142856*G0_0_1_2_1 + 0.0176785714285712*G0_0_1_2_2 - 0.00642857142857138*G0_0_1_2_3 + 0.0112499999999999*G0_0_1_2_4 + 0.00642857142857142*G0_0_1_2_5 - 0.00642857142857135*G0_0_1_3_0 + 0.0803571428571423*G0_0_1_3_1 - 0.00642857142857138*G0_0_1_3_2 + 0.128571428571428*G0_0_1_3_3 + 0.0128571428571427*G0_0_1_3_4 - 0.0080357142857142*G0_0_1_4_0 + 0.0112499999999999*G0_0_1_4_2 + 0.0128571428571427*G0_0_1_4_3 + 0.0128571428571427*G0_0_1_4_4 - 0.0128571428571428*G0_0_1_4_5 + 0.00642857142857144*G0_0_1_5_0 + 0.0160714285714285*G0_0_1_5_1 + 0.00642857142857142*G0_0_1_5_2 - 0.0128571428571428*G0_0_1_5_4 - 0.128571428571428*G0_0_1_5_5 + 0.00241071428571433*G0_1_0_0_0 - 0.00803571428571421*G0_1_0_0_1 - 0.000803571428571422*G0_1_0_0_2 - 0.0128571428571427*G0_1_0_0_3 - 0.00160714285714279*G0_1_0_0_4 - 0.00321428571428567*G0_1_0_0_5 - 0.00803571428571421*G0_1_0_1_0 + 0.168749999999999*G0_1_0_1_1 - 0.0160714285714285*G0_1_0_1_2 + 0.0482142857142854*G0_1_0_1_3 + 0.0482142857142854*G0_1_0_1_5 - 0.000803571428571422*G0_1_0_2_0 - 0.0160714285714285*G0_1_0_2_1 + 0.00401785714285701*G0_1_0_2_2 + 0.00321428571428566*G0_1_0_2_3 + 0.00482142857142849*G0_1_0_2_4 + 0.0128571428571428*G0_1_0_2_5 - 0.0128571428571427*G0_1_0_3_0 + 0.0482142857142854*G0_1_0_3_1 + 0.00321428571428566*G0_1_0_3_2 + 0.192857142857141*G0_1_0_3_3 + 0.0257142857142856*G0_1_0_3_4 - 0.00160714285714279*G0_1_0_4_0 + 0.00482142857142849*G0_1_0_4_2 + 0.0257142857142856*G0_1_0_4_3 + 0.0128571428571427*G0_1_0_4_4 - 0.0257142857142856*G0_1_0_4_5 - 0.00321428571428567*G0_1_0_5_0 + 0.0482142857142854*G0_1_0_5_1 + 0.0128571428571428*G0_1_0_5_2 - 0.0257142857142856*G0_1_0_5_4 - 0.192857142857142*G0_1_0_5_5 + 0.00642857142857135*G0_1_1_0_0 - 0.0241071428571426*G0_1_1_0_1 - 0.00160714285714286*G0_1_1_0_2 + 0.00321428571428571*G0_1_1_0_4 - 0.0241071428571426*G0_1_1_1_0 + 0.337499999999998*G0_1_1_1_1 - 0.0241071428571427*G0_1_1_1_2 + 0.0964285714285708*G0_1_1_1_3 + 0.0964285714285708*G0_1_1_1_5 - 0.00160714285714286*G0_1_1_2_0 - 0.0241071428571427*G0_1_1_2_1 + 0.00642857142857138*G0_1_1_2_2 + 0.00321428571428571*G0_1_1_2_4 + 0.0964285714285708*G0_1_1_3_1 + 0.00321428571428571*G0_1_1_4_0 + 0.00321428571428571*G0_1_1_4_2 + 0.0257142857142855*G0_1_1_4_4 + 0.0964285714285708*G0_1_1_5_1;
    A[62] = -A[82] - 0.0117857142857142*G0_0_1_0_0 - 0.00183035714285714*G0_0_1_0_1 + 0.0209374999999999*G0_0_1_0_2 + 0.0119642857142856*G0_0_1_0_3 + 0.0224999999999999*G0_0_1_0_4 + 0.00642857142857141*G0_0_1_0_5 - 0.00183035714285714*G0_0_1_1_0 - 0.0286607142857141*G0_0_1_1_1 + 0.0204910714285713*G0_0_1_1_2 + 0.0174999999999999*G0_0_1_1_3 + 0.0116071428571428*G0_0_1_1_4 - 0.00571428571428563*G0_0_1_1_5 + 0.0209374999999999*G0_0_1_2_0 + 0.0204910714285713*G0_0_1_2_1 - 0.243749999999999*G0_0_1_2_2 - 0.0874999999999996*G0_0_1_2_3 - 0.0946428571428567*G0_0_1_2_4 - 0.00660714285714289*G0_0_1_2_5 + 0.0119642857142856*G0_0_1_3_0 + 0.0174999999999999*G0_0_1_3_1 - 0.0874999999999996*G0_0_1_3_2 - 0.0742857142857139*G0_0_1_3_3 - 0.0471428571428569*G0_0_1_3_4 - 0.0107142857142857*G0_0_1_3_5 + 0.0224999999999999*G0_0_1_4_0 + 0.0116071428571428*G0_0_1_4_1 - 0.0946428571428567*G0_0_1_4_2 - 0.0471428571428569*G0_0_1_4_3 - 0.0885714285714282*G0_0_1_4_4 - 0.01*G0_0_1_4_5 + 0.00642857142857141*G0_0_1_5_0 - 0.00571428571428563*G0_0_1_5_1 - 0.00660714285714289*G0_0_1_5_2 - 0.0107142857142857*G0_0_1_5_3 - 0.01*G0_0_1_5_4 + 0.0399999999999998*G0_0_1_5_5 - 0.0198214285714285*G0_1_1_0_0 + 0.00486607142857139*G0_1_1_0_1 + 0.0126339285714285*G0_1_1_0_2 + 0.00553571428571424*G0_1_1_0_3 - 0.00321428571428571*G0_1_1_0_5 + 0.00486607142857139*G0_1_1_1_0 - 0.0404464285714283*G0_1_1_1_1 + 0.0148660714285713*G0_1_1_1_2 + 0.0121428571428571*G0_1_1_1_3 + 0.00946428571428568*G0_1_1_1_4 - 0.0142857142857142*G0_1_1_1_5 + 0.0126339285714285*G0_1_1_2_0 + 0.0148660714285713*G0_1_1_2_1 - 0.190178571428571*G0_1_1_2_2 - 0.0660714285714283*G0_1_1_2_3 - 0.0410714285714284*G0_1_1_2_4 + 0.00196428571428565*G0_1_1_2_5 + 0.00553571428571424*G0_1_1_3_0 + 0.0121428571428571*G0_1_1_3_1 - 0.0660714285714283*G0_1_1_3_2 - 0.0485714285714283*G0_1_1_3_3 - 0.0299999999999999*G0_1_1_3_4 - 0.0149999999999999*G0_1_1_3_5 + 0.00946428571428568*G0_1_1_4_1 - 0.0410714285714284*G0_1_1_4_2 - 0.0299999999999999*G0_1_1_4_3 - 0.0628571428571426*G0_1_1_4_4 - 0.0228571428571428*G0_1_1_4_5 - 0.00321428571428571*G0_1_1_5_0 - 0.0142857142857142*G0_1_1_5_1 + 0.00196428571428565*G0_1_1_5_2 - 0.0149999999999999*G0_1_1_5_3 - 0.0228571428571428*G0_1_1_5_4 - 0.088571428571428*G0_1_1_5_5;
    A[19] = 0.0117857142857142*G0_0_0_0_0 + 0.00562499999999995*G0_0_0_0_1 - 0.00669642857142854*G0_0_0_0_2 + 0.00214285714285713*G0_0_0_0_3 + 0.00857142857142854*G0_0_0_0_4 + 0.00535714285714283*G0_0_0_0_5 + 0.00562499999999995*G0_0_0_1_0 - 0.0535714285714281*G0_0_0_1_1 + 0.00830357142857139*G0_0_0_1_2 - 0.0535714285714283*G0_0_0_1_3 - 0.00857142857142854*G0_0_0_1_4 - 0.0214285714285713*G0_0_0_1_5 - 0.00669642857142854*G0_0_0_2_0 + 0.00830357142857139*G0_0_0_2_1 + 0.00803571428571423*G0_0_0_2_2 + 0.0224999999999999*G0_0_0_2_3 + 0.00964285714285711*G0_0_0_2_4 + 0.00642857142857141*G0_0_0_2_5 + 0.00214285714285713*G0_0_0_3_0 - 0.0535714285714283*G0_0_0_3_1 + 0.0224999999999999*G0_0_0_3_2 - 0.0257142857142857*G0_0_0_3_3 + 0.0128571428571428*G0_0_0_3_4 - 0.0171428571428571*G0_0_0_3_5 + 0.00857142857142854*G0_0_0_4_0 - 0.00857142857142854*G0_0_0_4_1 + 0.00964285714285711*G0_0_0_4_2 + 0.0128571428571428*G0_0_0_4_3 + 0.128571428571428*G0_0_0_4_4 + 0.00428571428571428*G0_0_0_4_5 + 0.00535714285714283*G0_0_0_5_0 - 0.0214285714285713*G0_0_0_5_1 + 0.00642857142857141*G0_0_0_5_2 - 0.0171428571428571*G0_0_0_5_3 + 0.00428571428571428*G0_0_0_5_4 - 0.0257142857142855*G0_0_0_5_5 + 0.00374999999999999*G0_0_1_0_0 - 0.00267857142857142*G0_0_1_0_1 - 0.00428571428571426*G0_0_1_0_3 - 0.00107142857142856*G0_0_1_0_4 - 0.017142857142857*G0_0_1_0_5 - 0.00267857142857142*G0_0_1_1_0 + 0.00267857142857141*G0_0_1_1_2 - 0.032142857142857*G0_0_1_1_3 + 0.032142857142857*G0_0_1_1_5 + 0.00267857142857141*G0_0_1_2_1 - 0.00375000000000002*G0_0_1_2_2 + 0.0171428571428571*G0_0_1_2_3 + 0.00107142857142856*G0_0_1_2_4 + 0.00428571428571427*G0_0_1_2_5 - 0.00428571428571426*G0_0_1_3_0 - 0.032142857142857*G0_0_1_3_1 + 0.0171428571428571*G0_0_1_3_2 + 0.00857142857142852*G0_0_1_3_4 - 0.00107142857142856*G0_0_1_4_0 + 0.00107142857142856*G0_0_1_4_2 + 0.00857142857142852*G0_0_1_4_3 - 0.00857142857142854*G0_0_1_4_5 - 0.017142857142857*G0_0_1_5_0 + 0.032142857142857*G0_0_1_5_1 + 0.00428571428571427*G0_0_1_5_2 - 0.00857142857142854*G0_0_1_5_4;
    A[16] = -A[19] + 0.0125892857142857*G0_0_0_0_0 + 0.00486607142857138*G0_0_0_0_1 - 0.00299107142857141*G0_0_0_0_2 + 0.0135714285714285*G0_0_0_0_4 + 0.00410714285714283*G0_0_0_0_5 + 0.00486607142857138*G0_0_0_1_0 - 0.0455357142857138*G0_0_0_1_1 + 0.00799107142857139*G0_0_0_1_2 - 0.051785714285714*G0_0_0_1_3 - 0.00749999999999997*G0_0_0_1_4 - 0.0178571428571427*G0_0_0_1_5 - 0.00299107142857141*G0_0_0_2_0 + 0.00799107142857139*G0_0_0_2_1 - 0.0267857142857143*G0_0_0_2_2 + 0.0198214285714285*G0_0_0_2_3 - 0.00910714285714284*G0_0_0_2_4 + 0.00571428571428569*G0_0_0_2_5 - 0.051785714285714*G0_0_0_3_1 + 0.0198214285714285*G0_0_0_3_2 + 0.00428571428571415*G0_0_0_3_3 + 0.0149999999999999*G0_0_0_3_4 - 0.0114285714285714*G0_0_0_3_5 + 0.0135714285714285*G0_0_0_4_0 - 0.00749999999999997*G0_0_0_4_1 - 0.00910714285714283*G0_0_0_4_2 + 0.0149999999999999*G0_0_0_4_3 + 0.0942857142857138*G0_0_0_4_4 + 0.00357142857142856*G0_0_0_4_5 + 0.00410714285714283*G0_0_0_5_0 - 0.0178571428571427*G0_0_0_5_1 + 0.00571428571428569*G0_0_0_5_2 - 0.0114285714285714*G0_0_0_5_3 + 0.00357142857142856*G0_0_0_5_4 - 0.0242857142857141*G0_0_0_5_5 - 0.00482142857142852*G0_0_1_0_0 - 0.00272321428571428*G0_0_1_0_1 + 0.000937500000000001*G0_0_1_0_2 - 0.00303571428571427*G0_0_1_0_3 + 0.00339285714285714*G0_0_1_0_4 - 0.0124999999999999*G0_0_1_0_5 - 0.00272321428571428*G0_0_1_1_0 + 0.00218749999999999*G0_0_1_1_2 - 0.0285714285714284*G0_0_1_1_3 + 0.000535714285714281*G0_0_1_1_4 + 0.0285714285714285*G0_0_1_1_5 + 0.000937500000000002*G0_0_1_2_0 + 0.00218749999999999*G0_0_1_2_1 - 0.0291964285714286*G0_0_1_2_2 + 0.0167857142857142*G0_0_1_2_3 - 0.00660714285714285*G0_0_1_2_4 + 0.00517857142857141*G0_0_1_2_5 - 0.00303571428571426*G0_0_1_3_0 - 0.0285714285714284*G0_0_1_3_1 + 0.0167857142857142*G0_0_1_3_2 + 0.0114285714285713*G0_0_1_3_3 + 0.00499999999999997*G0_0_1_3_4 - 0.00428571428571428*G0_0_1_3_5 + 0.00339285714285714*G0_0_1_4_0 + 0.000535714285714281*G0_0_1_4_1 - 0.00660714285714285*G0_0_1_4_2 + 0.00499999999999997*G0_0_1_4_3 + 0.0385714285714283*G0_0_1_4_4 - 0.0114285714285714*G0_0_1_4_5 - 0.0124999999999999*G0_0_1_5_0 + 0.0285714285714285*G0_0_1_5_1 + 0.00517857142857141*G0_0_1_5_2 - 0.00428571428571429*G0_0_1_5_3 - 0.0114285714285714*G0_0_1_5_4 - 0.0028571428571429*G0_0_1_5_5;
    A[15] = A[16] - 0.0101785714285714*G0_0_0_0_0 + 0.000937500000000009*G0_0_0_0_1 - 0.000937500000000001*G0_0_0_0_2 + 0.000535714285714283*G0_0_0_0_3 - 0.0160714285714285*G0_0_0_0_4 - 0.00107142857142856*G0_0_0_0_5 + 0.000937500000000009*G0_0_0_1_0 - 0.000401785714285713*G0_0_0_1_2 + 0.00535714285714281*G0_0_0_1_3 - 0.000535714285714282*G0_0_0_1_4 - 0.00535714285714289*G0_0_0_1_5 - 0.000937500000000002*G0_0_0_2_0 - 0.000401785714285713*G0_0_0_2_1 + 0.0441964285714285*G0_0_0_2_2 - 0.00321428571428566*G0_0_0_2_3 + 0.0192857142857142*G0_0_0_2_4 - 0.0026785714285714*G0_0_0_2_5 + 0.000535714285714283*G0_0_0_3_0 + 0.0053571428571428*G0_0_0_3_1 - 0.00321428571428566*G0_0_0_3_2 - 0.0257142857142856*G0_0_0_3_3 + 0.00428571428571425*G0_0_0_3_5 - 0.0160714285714285*G0_0_0_4_0 - 0.000535714285714282*G0_0_0_4_1 + 0.0192857142857142*G0_0_0_4_2 - 0.0385714285714283*G0_0_0_4_4 + 0.00642857142857139*G0_0_0_4_5 - 0.00107142857142856*G0_0_0_5_0 - 0.00535714285714289*G0_0_0_5_1 - 0.0026785714285714*G0_0_0_5_2 + 0.00428571428571425*G0_0_0_5_3 + 0.00642857142857139*G0_0_0_5_4 + 0.017142857142857*G0_0_0_5_5 + 0.0340178571428569*G0_0_1_0_0 + 0.000535714285714289*G0_0_1_0_1 - 0.00187499999999999*G0_0_1_0_2 - 0.00214285714285713*G0_0_1_0_3 + 0.00321428571428568*G0_0_1_0_4 - 0.00428571428571427*G0_0_1_0_5 + 0.000535714285714289*G0_0_1_1_0 + 0.00053571428571428*G0_0_1_1_2 - 0.00107142857142857*G0_0_1_1_4 - 0.00187499999999999*G0_0_1_2_0 + 0.00053571428571428*G0_0_1_2_1 + 0.0340178571428572*G0_0_1_2_2 - 0.00428571428571421*G0_0_1_2_3 + 0.00321428571428572*G0_0_1_2_4 - 0.00214285714285712*G0_0_1_2_5 - 0.00214285714285713*G0_0_1_3_0 - 0.00428571428571421*G0_0_1_3_2 - 0.00857142857142852*G0_0_1_3_3 + 0.00642857142857139*G0_0_1_3_4 + 0.00857142857142852*G0_0_1_3_5 + 0.00321428571428568*G0_0_1_4_0 - 0.00107142857142857*G0_0_1_4_1 + 0.00321428571428572*G0_0_1_4_2 + 0.00642857142857139*G0_0_1_4_3 - 0.0771428571428568*G0_0_1_4_4 + 0.00642857142857139*G0_0_1_4_5 - 0.00428571428571427*G0_0_1_5_0 - 0.00214285714285712*G0_0_1_5_2 + 0.00857142857142852*G0_0_1_5_3 + 0.00642857142857139*G0_0_1_5_4 - 0.00857142857142852*G0_0_1_5_5;
    A[10] = A[15] - 0.00997023809523802*G0_0_0_0_0 + 0.00094742063492062*G0_0_0_0_1 - 0.0011954365079365*G0_0_0_0_2 + 0.00218253968253967*G0_0_0_0_3 + 0.00214285714285714*G0_0_0_0_4 + 0.000535714285714282*G0_0_0_0_5 + 0.00094742063492062*G0_0_0_1_0 - 0.0273809523809522*G0_0_0_1_1 + 0.00228670634920634*G0_0_0_1_2 - 0.0160714285714285*G0_0_0_1_3 - 0.0011954365079365*G0_0_0_2_0 + 0.00228670634920634*G0_0_0_2_1 - 0.0118452380952381*G0_0_0_2_2 + 0.00910714285714279*G0_0_0_2_3 + 0.00267857142857141*G0_0_0_2_4 + 0.0043253968253968*G0_0_0_2_5 + 0.00218253968253967*G0_0_0_3_0 - 0.0160714285714285*G0_0_0_3_1 + 0.00910714285714279*G0_0_0_3_2 - 0.0131746031746031*G0_0_0_3_3 - 0.00444444444444442*G0_0_0_3_4 - 0.013015873015873*G0_0_0_3_5 + 0.00214285714285714*G0_0_0_4_0 + 0.00267857142857141*G0_0_0_4_2 - 0.00444444444444442*G0_0_0_4_3 + 0.0639682539682537*G0_0_0_4_4 - 0.00873015873015868*G0_0_0_4_5 + 0.000535714285714282*G0_0_0_5_0 + 0.0043253968253968*G0_0_0_5_2 - 0.013015873015873*G0_0_0_5_3 - 0.00873015873015868*G0_0_0_5_4 - 0.0131746031746031*G0_0_0_5_5 - 0.0447916666666664*G0_0_1_0_0 + 0.000634920634920627*G0_0_1_0_1 + 0.00250992063492062*G0_0_1_0_2 + 0.00146825396825395*G0_0_1_0_3 - 0.0166071428571428*G0_0_1_0_4 - 0.00214285714285712*G0_0_1_0_5 + 0.000634920634920627*G0_0_1_1_0 - 0.019345238095238*G0_0_1_1_1 + 0.00152777777777777*G0_0_1_1_2 - 0.0124999999999999*G0_0_1_1_3 + 0.0011111111111111*G0_0_1_1_4 + 0.00178571428571428*G0_0_1_1_5 + 0.00250992063492062*G0_0_1_2_0 + 0.00152777777777777*G0_0_1_2_1 - 0.0110416666666667*G0_0_1_2_2 + 0.00785714285714279*G0_0_1_2_3 + 0.00767857142857139*G0_0_1_2_4 + 0.00218253968253967*G0_0_1_2_5 + 0.00146825396825395*G0_0_1_3_0 - 0.0124999999999999*G0_0_1_3_1 + 0.00785714285714279*G0_0_1_3_2 - 0.0117460317460317*G0_0_1_3_3 - 0.00515873015873012*G0_0_1_3_4 - 0.00730158730158726*G0_0_1_3_5 - 0.0166071428571428*G0_0_1_4_0 + 0.0011111111111111*G0_0_1_4_1 + 0.00767857142857138*G0_0_1_4_2 - 0.00515873015873012*G0_0_1_4_3 + 0.0296825396825396*G0_0_1_4_4 - 0.00658730158730155*G0_0_1_4_5 - 0.00214285714285713*G0_0_1_5_0 + 0.00178571428571428*G0_0_1_5_1 + 0.00218253968253967*G0_0_1_5_2 - 0.00730158730158726*G0_0_1_5_3 - 0.00658730158730155*G0_0_1_5_4 + 0.0168253968253967*G0_0_1_5_5;
    A[14] = -A[16] - 0.0109821428571428*G0_0_1_0_0 + 0.00709821428571422*G0_0_1_0_1 + 0.00874999999999994*G0_0_1_0_3 + 0.00785714285714282*G0_0_1_0_4 + 0.0167857142857142*G0_0_1_0_5 + 0.00709821428571422*G0_0_1_1_0 - 0.0937499999999994*G0_0_1_1_1 + 0.00397321428571426*G0_0_1_1_2 - 0.00178571428571419*G0_0_1_1_3 + 0.00232142857142856*G0_0_1_1_4 - 0.0410714285714283*G0_0_1_1_5 + 0.00397321428571426*G0_0_1_2_1 - 0.0241071428571428*G0_0_1_2_2 - 0.00535714285714287*G0_0_1_2_3 - 0.00535714285714285*G0_0_1_2_4 + 0.00410714285714282*G0_0_1_2_5 + 0.00874999999999993*G0_0_1_3_0 - 0.00178571428571419*G0_0_1_3_1 - 0.00535714285714287*G0_0_1_3_2 - 0.0314285714285712*G0_0_1_3_3 - 0.022142857142857*G0_0_1_3_4 - 0.0257142857142855*G0_0_1_3_5 + 0.00785714285714282*G0_0_1_4_0 + 0.00232142857142856*G0_0_1_4_1 - 0.00535714285714285*G0_0_1_4_2 - 0.022142857142857*G0_0_1_4_3 + 0.0328571428571427*G0_0_1_4_4 - 0.0128571428571428*G0_0_1_4_5 + 0.0167857142857142*G0_0_1_5_0 - 0.0410714285714283*G0_0_1_5_1 + 0.00410714285714282*G0_0_1_5_2 - 0.0257142857142855*G0_0_1_5_3 - 0.0128571428571428*G0_0_1_5_4 - 0.0457142857142854*G0_0_1_5_5;
    A[87] = -A[37] - 0.164732142857142*G0_0_0_0_0 + 0.0124553571428571*G0_0_0_0_1 + 0.0108482142857142*G0_0_0_0_2 + 0.0128571428571428*G0_0_0_0_3 - 0.0707142857142853*G0_0_0_0_4 - 0.00160714285714284*G0_0_0_0_5 + 0.0124553571428571*G0_0_0_1_0 - 0.112499999999999*G0_0_0_1_1 + 0.0004017857142857*G0_0_0_1_2 - 0.0160714285714284*G0_0_0_1_3 + 0.0192857142857142*G0_0_0_1_4 + 0.0108482142857142*G0_0_0_2_0 + 0.0004017857142857*G0_0_0_2_1 - 0.00482142857142859*G0_0_0_2_2 + 0.0273214285714284*G0_0_0_2_3 + 0.0466071428571426*G0_0_0_2_4 + 0.0482142857142855*G0_0_0_2_5 + 0.0128571428571428*G0_0_0_3_0 - 0.0160714285714284*G0_0_0_3_1 + 0.0273214285714284*G0_0_0_3_2 + 0.0257142857142854*G0_0_0_3_3 - 0.064285714285714*G0_0_0_3_4 - 0.122142857142857*G0_0_0_3_5 - 0.0707142857142853*G0_0_0_4_0 + 0.0192857142857142*G0_0_0_4_1 + 0.0466071428571426*G0_0_0_4_2 - 0.064285714285714*G0_0_0_4_3 - 0.205714285714285*G0_0_0_4_4 - 0.134999999999999*G0_0_0_4_5 - 0.00160714285714283*G0_0_0_5_0 + 0.0482142857142855*G0_0_0_5_2 - 0.122142857142857*G0_0_0_5_3 - 0.134999999999999*G0_0_0_5_4 - 0.424285714285713*G0_0_0_5_5 + 0.0040178571428571*G0_0_1_0_0 + 0.00803571428571423*G0_0_1_0_1 - 0.00562499999999996*G0_0_1_0_2 + 0.00964285714285711*G0_0_1_0_3 + 0.0176785714285714*G0_0_1_0_4 + 0.00642857142857137*G0_0_1_0_5 + 0.00803571428571423*G0_0_1_1_0 - 0.120535714285713*G0_0_1_1_1 - 0.0160714285714284*G0_0_1_1_3 + 0.0160714285714285*G0_0_1_1_4 + 0.0160714285714285*G0_0_1_1_5 - 0.00562499999999996*G0_0_1_2_0 - 0.00723214285714292*G0_0_1_2_2 + 0.0257142857142856*G0_0_1_2_3 + 0.020892857142857*G0_0_1_2_4 + 0.0546428571428569*G0_0_1_2_5 + 0.00964285714285711*G0_0_1_3_0 - 0.0160714285714284*G0_0_1_3_1 + 0.0257142857142856*G0_0_1_3_2 + 0.0642857142857137*G0_0_1_3_3 - 0.0514285714285712*G0_0_1_3_4 - 0.128571428571428*G0_0_1_3_5 + 0.0176785714285714*G0_0_1_4_0 + 0.0160714285714285*G0_0_1_4_1 + 0.020892857142857*G0_0_1_4_2 - 0.0514285714285712*G0_0_1_4_3 - 0.0385714285714285*G0_0_1_4_4 - 0.141428571428571*G0_0_1_4_5 + 0.00642857142857137*G0_0_1_5_0 + 0.0160714285714285*G0_0_1_5_1 + 0.0546428571428569*G0_0_1_5_2 - 0.128571428571428*G0_0_1_5_3 - 0.141428571428571*G0_0_1_5_4 - 0.578571428571426*G0_0_1_5_5;
    A[42] = -A[62] - 0.0230357142857142*G0_1_1_0_0 + 0.00508928571428568*G0_1_1_0_1 + 0.00758928571428567*G0_1_1_0_2 + 0.00714285714285709*G0_1_1_0_3 - 0.00178571428571429*G0_1_1_0_4 - 0.00571428571428568*G0_1_1_0_5 + 0.00508928571428568*G0_1_1_1_0 - 0.0230357142857141*G0_1_1_1_1 + 0.00758928571428566*G0_1_1_1_2 - 0.00178571428571428*G0_1_1_1_3 + 0.00714285714285711*G0_1_1_1_4 - 0.00571428571428567*G0_1_1_1_5 + 0.00758928571428567*G0_1_1_2_0 + 0.00758928571428566*G0_1_1_2_1 - 0.152678571428571*G0_1_1_2_2 - 0.0214285714285713*G0_1_1_2_3 - 0.0214285714285713*G0_1_1_2_4 + 0.00892857142857136*G0_1_1_2_5 + 0.00714285714285709*G0_1_1_3_0 - 0.00178571428571428*G0_1_1_3_1 - 0.0214285714285713*G0_1_1_3_2 - 0.0571428571428568*G0_1_1_3_3 - 0.0285714285714284*G0_1_1_3_4 - 0.032142857142857*G0_1_1_3_5 - 0.00178571428571429*G0_1_1_4_0 + 0.0071428571428571*G0_1_1_4_1 - 0.0214285714285713*G0_1_1_4_2 - 0.0285714285714284*G0_1_1_4_3 - 0.0571428571428569*G0_1_1_4_4 - 0.032142857142857*G0_1_1_4_5 - 0.00571428571428568*G0_1_1_5_0 - 0.00571428571428567*G0_1_1_5_1 + 0.00892857142857136*G0_1_1_5_2 - 0.032142857142857*G0_1_1_5_3 - 0.032142857142857*G0_1_1_5_4 - 0.109999999999999*G0_1_1_5_5;
    A[7] = A[42] - 0.198214285714285*G0_0_0_0_0 + 0.0133928571428571*G0_0_0_0_1 + 0.0151785714285714*G0_0_0_0_2 + 0.000892857142857119*G0_0_0_0_3 - 0.0678571428571424*G0_0_0_0_4 - 0.0446428571428569*G0_0_0_0_5 + 0.0133928571428571*G0_0_0_1_0 - 0.0206249999999999*G0_0_0_1_1 + 0.00116071428571428*G0_0_0_1_2 - 0.00821428571428567*G0_0_0_1_3 + 0.00767857142857139*G0_0_0_1_4 + 0.00124999999999999*G0_0_0_1_5 + 0.0151785714285714*G0_0_0_2_0 + 0.00116071428571428*G0_0_0_2_1 - 0.00562500000000002*G0_0_0_2_2 + 0.00446428571428568*G0_0_0_2_3 + 0.0148214285714285*G0_0_0_2_4 + 0.0101785714285714*G0_0_0_2_5 + 0.000892857142857119*G0_0_0_3_0 - 0.00821428571428567*G0_0_0_3_1 + 0.00446428571428568*G0_0_0_3_2 - 0.0542857142857139*G0_0_0_3_3 - 0.0171428571428571*G0_0_0_3_4 - 0.0221428571428571*G0_0_0_3_5 - 0.0678571428571424*G0_0_0_4_0 + 0.00767857142857139*G0_0_0_4_1 + 0.0148214285714285*G0_0_0_4_2 - 0.0171428571428571*G0_0_0_4_3 - 0.0785714285714282*G0_0_0_4_4 - 0.0357142857142856*G0_0_0_4_5 - 0.0446428571428569*G0_0_0_5_0 + 0.00124999999999999*G0_0_0_5_1 + 0.0101785714285714*G0_0_0_5_2 - 0.0221428571428571*G0_0_0_5_3 - 0.0357142857142856*G0_0_0_5_4 - 0.064285714285714*G0_0_0_5_5 + 0.0423214285714284*G0_0_1_0_0 - 0.0103571428571428*G0_0_1_0_1 + 0.0151785714285713*G0_0_1_0_2 + 0.0187499999999999*G0_0_1_0_3 + 0.0410714285714284*G0_0_1_0_4 + 0.0483928571428569*G0_0_1_0_5 - 0.0103571428571428*G0_0_1_1_0 - 0.0206249999999999*G0_0_1_1_1 + 0.0249107142857142*G0_0_1_1_2 + 0.00767857142857139*G0_0_1_1_3 + 0.00767857142857138*G0_0_1_1_4 - 0.0146428571428571*G0_0_1_1_5 + 0.0151785714285713*G0_0_1_2_0 + 0.0249107142857142*G0_0_1_2_1 - 0.246160714285713*G0_0_1_2_2 - 0.0885714285714281*G0_0_1_2_3 - 0.0941071428571424*G0_0_1_2_4 - 0.00767857142857145*G0_0_1_2_5 + 0.0187499999999999*G0_0_1_3_0 + 0.00767857142857139*G0_0_1_3_1 - 0.0885714285714281*G0_0_1_3_2 - 0.141428571428571*G0_0_1_3_3 - 0.0528571428571426*G0_0_1_3_4 - 0.0221428571428571*G0_0_1_3_5 + 0.0410714285714284*G0_0_1_4_0 + 0.00767857142857138*G0_0_1_4_1 - 0.0941071428571424*G0_0_1_4_2 - 0.0528571428571426*G0_0_1_4_3 - 0.0785714285714281*G0_0_1_4_4 + 0.0483928571428569*G0_0_1_5_0 - 0.0146428571428571*G0_0_1_5_1 - 0.00767857142857145*G0_0_1_5_2 - 0.0221428571428571*G0_0_1_5_3 + 0.0228571428571426*G0_0_1_5_5 - 0.198214285714285*G0_1_0_0_0 + 0.0133928571428571*G0_1_0_0_1 + 0.0151785714285714*G0_1_0_0_2 + 0.000892857142857115*G0_1_0_0_3 - 0.0678571428571424*G0_1_0_0_4 - 0.0446428571428569*G0_1_0_0_5 + 0.0133928571428571*G0_1_0_1_0 - 0.0206249999999999*G0_1_0_1_1 + 0.00116071428571428*G0_1_0_1_2 - 0.00821428571428565*G0_1_0_1_3 + 0.00767857142857139*G0_1_0_1_4 + 0.00124999999999999*G0_1_0_1_5 + 0.0151785714285714*G0_1_0_2_0 + 0.00116071428571428*G0_1_0_2_1 - 0.00562499999999998*G0_1_0_2_2 + 0.00446428571428568*G0_1_0_2_3 + 0.0148214285714285*G0_1_0_2_4 + 0.0101785714285714*G0_1_0_2_5 + 0.000892857142857115*G0_1_0_3_0 - 0.00821428571428565*G0_1_0_3_1 + 0.00446428571428568*G0_1_0_3_2 - 0.0542857142857139*G0_1_0_3_3 - 0.0171428571428571*G0_1_0_3_4 - 0.022142857142857*G0_1_0_3_5 - 0.0678571428571424*G0_1_0_4_0 + 0.00767857142857139*G0_1_0_4_1 + 0.0148214285714285*G0_1_0_4_2 - 0.0171428571428571*G0_1_0_4_3 - 0.0785714285714282*G0_1_0_4_4 - 0.0357142857142856*G0_1_0_4_5 - 0.0446428571428569*G0_1_0_5_0 + 0.00124999999999999*G0_1_0_5_1 + 0.0101785714285714*G0_1_0_5_2 - 0.022142857142857*G0_1_0_5_3 - 0.0357142857142856*G0_1_0_5_4 - 0.064285714285714*G0_1_0_5_5 + 0.0479464285714284*G0_1_1_0_0 - 0.0115178571428571*G0_1_1_0_1 + 0.00857142857142853*G0_1_1_0_3 + 0.0262499999999999*G0_1_1_0_4 + 0.0439285714285713*G0_1_1_0_5 - 0.0115178571428571*G0_1_1_1_0 + 0.0115178571428571*G0_1_1_1_2 + 0.0064285714285714*G0_1_1_1_3 - 0.0064285714285714*G0_1_1_1_5 + 0.0115178571428571*G0_1_1_2_1 - 0.0479464285714284*G0_1_1_2_2 - 0.0439285714285712*G0_1_1_2_3 - 0.0262499999999999*G0_1_1_2_4 - 0.00857142857142854*G0_1_1_2_5 + 0.00857142857142853*G0_1_1_3_0 + 0.0064285714285714*G0_1_1_3_1 - 0.0439285714285712*G0_1_1_3_2 - 0.0771428571428567*G0_1_1_3_3 - 0.0171428571428571*G0_1_1_3_4 + 0.0262499999999999*G0_1_1_4_0 - 0.0262499999999999*G0_1_1_4_2 - 0.0171428571428571*G0_1_1_4_3 + 0.0171428571428571*G0_1_1_4_5 + 0.0439285714285713*G0_1_1_5_0 - 0.0064285714285714*G0_1_1_5_1 - 0.00857142857142854*G0_1_1_5_2 + 0.0171428571428571*G0_1_1_5_4 + 0.0771428571428567*G0_1_1_5_5;
    A[70] = A[7] - 0.243749999999999*G0_0_1_0_0 + 0.0209821428571427*G0_0_1_0_1 + 0.0209821428571428*G0_0_1_0_2 - 0.00714285714285713*G0_0_1_0_3 - 0.0910714285714281*G0_0_1_0_4 - 0.0910714285714281*G0_0_1_0_5 + 0.0209821428571427*G0_0_1_1_0 - 0.00321428571428567*G0_0_1_1_1 - 0.00276785714285713*G0_0_1_1_2 + 0.00196428571428573*G0_0_1_1_3 + 0.0107142857142857*G0_0_1_1_4 + 0.0178571428571428*G0_0_1_1_5 + 0.0209821428571428*G0_0_1_2_0 - 0.00276785714285713*G0_0_1_2_1 - 0.0032142857142857*G0_0_1_2_2 + 0.0019642857142857*G0_0_1_2_3 + 0.0178571428571428*G0_0_1_2_4 + 0.0107142857142857*G0_0_1_2_5 - 0.00714285714285713*G0_0_1_3_0 + 0.00196428571428573*G0_0_1_3_1 + 0.0019642857142857*G0_0_1_3_2 + 0.00142857142857141*G0_0_1_3_3 - 0.00714285714285712*G0_0_1_3_4 - 0.0071428571428571*G0_0_1_3_5 - 0.0910714285714281*G0_0_1_4_0 + 0.0107142857142857*G0_0_1_4_1 + 0.0178571428571428*G0_0_1_4_2 - 0.00714285714285712*G0_0_1_4_3 - 0.0857142857142853*G0_0_1_4_4 - 0.0428571428571427*G0_0_1_4_5 - 0.0910714285714281*G0_0_1_5_0 + 0.0178571428571428*G0_0_1_5_1 + 0.0107142857142857*G0_0_1_5_2 - 0.0071428571428571*G0_0_1_5_3 - 0.0428571428571427*G0_0_1_5_4 - 0.0857142857142851*G0_0_1_5_5 + 0.243749999999999*G0_1_0_0_0 - 0.0209821428571427*G0_1_0_0_1 - 0.0209821428571428*G0_1_0_0_2 + 0.00714285714285713*G0_1_0_0_3 + 0.0910714285714281*G0_1_0_0_4 + 0.0910714285714281*G0_1_0_0_5 - 0.0209821428571427*G0_1_0_1_0 + 0.00321428571428567*G0_1_0_1_1 + 0.00276785714285713*G0_1_0_1_2 - 0.00196428571428573*G0_1_0_1_3 - 0.0107142857142857*G0_1_0_1_4 - 0.0178571428571428*G0_1_0_1_5 - 0.0209821428571428*G0_1_0_2_0 + 0.00276785714285713*G0_1_0_2_1 + 0.0032142857142857*G0_1_0_2_2 - 0.0019642857142857*G0_1_0_2_3 - 0.0178571428571428*G0_1_0_2_4 - 0.0107142857142857*G0_1_0_2_5 + 0.00714285714285713*G0_1_0_3_0 - 0.00196428571428573*G0_1_0_3_1 - 0.0019642857142857*G0_1_0_3_2 - 0.00142857142857142*G0_1_0_3_3 + 0.00714285714285712*G0_1_0_3_4 + 0.0071428571428571*G0_1_0_3_5 + 0.0910714285714281*G0_1_0_4_0 - 0.0107142857142857*G0_1_0_4_1 - 0.0178571428571428*G0_1_0_4_2 + 0.00714285714285712*G0_1_0_4_3 + 0.0857142857142853*G0_1_0_4_4 + 0.0428571428571427*G0_1_0_4_5 + 0.0910714285714281*G0_1_0_5_0 - 0.0178571428571428*G0_1_0_5_1 - 0.0107142857142857*G0_1_0_5_2 + 0.0071428571428571*G0_1_0_5_3 + 0.0428571428571427*G0_1_0_5_4 + 0.0857142857142852*G0_1_0_5_5;
    A[5] = A[70] + 0.243749999999999*G0_0_0_0_0 - 0.0191964285714285*G0_0_0_0_1 - 0.022767857142857*G0_0_0_0_2 + 0.00714285714285713*G0_0_0_0_3 + 0.114285714285714*G0_0_0_0_4 + 0.0678571428571425*G0_0_0_0_5 - 0.0191964285714285*G0_0_0_1_0 + 0.0182142857142856*G0_0_0_1_1 + 0.00276785714285713*G0_0_0_1_2 + 0.0107142857142856*G0_0_0_1_3 - 0.00821428571428569*G0_0_0_1_4 - 0.00428571428571426*G0_0_0_1_5 - 0.022767857142857*G0_0_0_2_0 + 0.00276785714285713*G0_0_0_2_1 - 0.0117857142857143*G0_0_0_2_2 - 0.0146428571428571*G0_0_0_2_3 - 0.0314285714285713*G0_0_0_2_4 - 0.0132142857142857*G0_0_0_2_5 + 0.00714285714285713*G0_0_0_3_0 + 0.0107142857142856*G0_0_0_3_1 - 0.0146428571428571*G0_0_0_3_2 - 0.0014285714285714*G0_0_0_3_3 + 0.00214285714285715*G0_0_0_3_4 + 0.0121428571428571*G0_0_0_3_5 + 0.114285714285714*G0_0_0_4_0 - 0.00821428571428569*G0_0_0_4_1 - 0.0314285714285713*G0_0_0_4_2 + 0.00214285714285715*G0_0_0_4_3 + 0.1*G0_0_0_4_4 + 0.0428571428571427*G0_0_0_4_5 + 0.0678571428571425*G0_0_0_5_0 - 0.00428571428571426*G0_0_0_5_1 - 0.0132142857142857*G0_0_0_5_2 + 0.0121428571428571*G0_0_0_5_3 + 0.0428571428571427*G0_0_0_5_4 + 0.0714285714285711*G0_0_0_5_5 + 0.00178571428571428*G0_0_1_0_1 - 0.00178571428571428*G0_0_1_0_2 + 0.0232142857142856*G0_0_1_0_4 - 0.0232142857142856*G0_0_1_0_5 + 0.00178571428571428*G0_0_1_1_0 + 0.0149999999999999*G0_0_1_1_1 + 0.0126785714285713*G0_0_1_1_3 + 0.00249999999999998*G0_0_1_1_4 + 0.0135714285714285*G0_0_1_1_5 - 0.00178571428571429*G0_0_1_2_0 - 0.015*G0_0_1_2_2 - 0.0126785714285714*G0_0_1_2_3 - 0.0135714285714285*G0_0_1_2_4 - 0.0025*G0_0_1_2_5 + 0.0126785714285713*G0_0_1_3_1 - 0.0126785714285714*G0_0_1_3_2 - 0.00499999999999997*G0_0_1_3_4 + 0.00499999999999998*G0_0_1_3_5 + 0.0232142857142856*G0_0_1_4_0 + 0.00249999999999998*G0_0_1_4_1 - 0.0135714285714285*G0_0_1_4_2 - 0.00499999999999997*G0_0_1_4_3 + 0.0142857142857142*G0_0_1_4_4 - 0.0232142857142856*G0_0_1_5_0 + 0.0135714285714285*G0_0_1_5_1 - 0.0025*G0_0_1_5_2 + 0.00499999999999998*G0_0_1_5_3 - 0.0142857142857141*G0_0_1_5_5 + 0.00178571428571427*G0_1_0_0_1 - 0.00178571428571428*G0_1_0_0_2 + 0.0232142857142856*G0_1_0_0_4 - 0.0232142857142856*G0_1_0_0_5 + 0.00178571428571427*G0_1_0_1_0 + 0.015*G0_1_0_1_1 + 0.0126785714285714*G0_1_0_1_3 + 0.00249999999999998*G0_1_0_1_4 + 0.0135714285714285*G0_1_0_1_5 - 0.00178571428571428*G0_1_0_2_0 - 0.015*G0_1_0_2_2 - 0.0126785714285714*G0_1_0_2_3 - 0.0135714285714285*G0_1_0_2_4 - 0.00250000000000001*G0_1_0_2_5 + 0.0126785714285714*G0_1_0_3_1 - 0.0126785714285714*G0_1_0_3_2 - 0.00499999999999998*G0_1_0_3_4 + 0.00499999999999999*G0_1_0_3_5 + 0.0232142857142856*G0_1_0_4_0 + 0.00249999999999998*G0_1_0_4_1 - 0.0135714285714285*G0_1_0_4_2 - 0.00499999999999998*G0_1_0_4_3 + 0.0142857142857142*G0_1_0_4_4 - 0.0232142857142856*G0_1_0_5_0 + 0.0135714285714285*G0_1_0_5_1 - 0.0025*G0_1_0_5_2 + 0.00499999999999999*G0_1_0_5_3 - 0.0142857142857141*G0_1_0_5_5 - 0.243749999999999*G0_1_1_0_0 + 0.022767857142857*G0_1_1_0_1 + 0.0191964285714285*G0_1_1_0_2 - 0.00714285714285713*G0_1_1_0_3 - 0.0678571428571425*G0_1_1_0_4 - 0.114285714285714*G0_1_1_0_5 + 0.022767857142857*G0_1_1_1_0 + 0.0117857142857142*G0_1_1_1_1 - 0.00276785714285713*G0_1_1_1_2 + 0.0146428571428571*G0_1_1_1_3 + 0.0132142857142857*G0_1_1_1_4 + 0.0314285714285713*G0_1_1_1_5 + 0.0191964285714285*G0_1_1_2_0 - 0.00276785714285713*G0_1_1_2_1 - 0.0182142857142857*G0_1_1_2_2 - 0.0107142857142857*G0_1_1_2_3 + 0.00428571428571426*G0_1_1_2_4 + 0.00821428571428567*G0_1_1_2_5 - 0.00714285714285713*G0_1_1_3_0 + 0.0146428571428571*G0_1_1_3_1 - 0.0107142857142857*G0_1_1_3_2 + 0.00142857142857142*G0_1_1_3_3 - 0.0121428571428571*G0_1_1_3_4 - 0.00214285714285714*G0_1_1_3_5 - 0.0678571428571425*G0_1_1_4_0 + 0.0132142857142857*G0_1_1_4_1 + 0.00428571428571426*G0_1_1_4_2 - 0.0121428571428571*G0_1_1_4_3 - 0.0714285714285711*G0_1_1_4_4 - 0.0428571428571427*G0_1_1_4_5 - 0.114285714285714*G0_1_1_5_0 + 0.0314285714285713*G0_1_1_5_1 + 0.00821428571428567*G0_1_1_5_2 - 0.00214285714285714*G0_1_1_5_3 - 0.0428571428571427*G0_1_1_5_4 - 0.1*G0_1_1_5_5;
    A[50] = A[5] + 0.243749999999999*G0_0_1_0_0 - 0.0209821428571428*G0_0_1_0_1 - 0.0209821428571428*G0_0_1_0_2 + 0.00714285714285713*G0_0_1_0_3 + 0.0910714285714281*G0_0_1_0_4 + 0.0910714285714281*G0_0_1_0_5 - 0.0209821428571428*G0_0_1_1_0 + 0.0032142857142857*G0_0_1_1_1 + 0.00276785714285713*G0_0_1_1_2 - 0.0019642857142857*G0_0_1_1_3 - 0.0107142857142857*G0_0_1_1_4 - 0.0178571428571428*G0_0_1_1_5 - 0.0209821428571428*G0_0_1_2_0 + 0.00276785714285713*G0_0_1_2_1 + 0.0032142857142857*G0_0_1_2_2 - 0.00196428571428571*G0_0_1_2_3 - 0.0178571428571428*G0_0_1_2_4 - 0.0107142857142857*G0_0_1_2_5 + 0.00714285714285713*G0_0_1_3_0 - 0.00196428571428571*G0_0_1_3_1 - 0.00196428571428571*G0_0_1_3_2 - 0.00142857142857145*G0_0_1_3_3 + 0.00714285714285711*G0_0_1_3_4 + 0.00714285714285711*G0_0_1_3_5 + 0.0910714285714281*G0_0_1_4_0 - 0.0107142857142857*G0_0_1_4_1 - 0.0178571428571428*G0_0_1_4_2 + 0.00714285714285711*G0_0_1_4_3 + 0.0857142857142853*G0_0_1_4_4 + 0.0428571428571427*G0_0_1_4_5 + 0.0910714285714281*G0_0_1_5_0 - 0.0178571428571428*G0_0_1_5_1 - 0.0107142857142857*G0_0_1_5_2 + 0.00714285714285711*G0_0_1_5_3 + 0.0428571428571427*G0_0_1_5_4 + 0.0857142857142852*G0_0_1_5_5 - 0.243749999999999*G0_1_0_0_0 + 0.0209821428571428*G0_1_0_0_1 + 0.0209821428571428*G0_1_0_0_2 - 0.00714285714285713*G0_1_0_0_3 - 0.0910714285714281*G0_1_0_0_4 - 0.0910714285714281*G0_1_0_0_5 + 0.0209821428571428*G0_1_0_1_0 - 0.0032142857142857*G0_1_0_1_1 - 0.00276785714285713*G0_1_0_1_2 + 0.0019642857142857*G0_1_0_1_3 + 0.0107142857142857*G0_1_0_1_4 + 0.0178571428571428*G0_1_0_1_5 + 0.0209821428571428*G0_1_0_2_0 - 0.00276785714285713*G0_1_0_2_1 - 0.00321428571428571*G0_1_0_2_2 + 0.00196428571428571*G0_1_0_2_3 + 0.0178571428571428*G0_1_0_2_4 + 0.0107142857142857*G0_1_0_2_5 - 0.00714285714285713*G0_1_0_3_0 + 0.0019642857142857*G0_1_0_3_1 + 0.0019642857142857*G0_1_0_3_2 + 0.00142857142857145*G0_1_0_3_3 - 0.00714285714285712*G0_1_0_3_4 - 0.00714285714285711*G0_1_0_3_5 - 0.0910714285714281*G0_1_0_4_0 + 0.0107142857142857*G0_1_0_4_1 + 0.0178571428571428*G0_1_0_4_2 - 0.00714285714285711*G0_1_0_4_3 - 0.0857142857142853*G0_1_0_4_4 - 0.0428571428571427*G0_1_0_4_5 - 0.0910714285714281*G0_1_0_5_0 + 0.0178571428571428*G0_1_0_5_1 + 0.0107142857142857*G0_1_0_5_2 - 0.00714285714285711*G0_1_0_5_3 - 0.0428571428571427*G0_1_0_5_4 - 0.0857142857142852*G0_1_0_5_5;
    A[68] = -A[48] + 0.041785714285714*G0_1_0_0_0 - 0.00281249999999994*G0_1_0_0_1 + 0.00281249999999998*G0_1_0_0_2 - 0.0144642857142856*G0_1_0_0_3 - 0.0192857142857142*G0_1_0_0_4 - 0.0241071428571428*G0_1_0_0_5 - 0.00281249999999994*G0_1_0_1_0 + 0.124553571428571*G0_1_0_1_1 - 0.00120535714285712*G0_1_0_1_2 - 0.00964285714285724*G0_1_0_1_3 - 0.00803571428571425*G0_1_0_1_4 + 0.0337499999999997*G0_1_0_1_5 + 0.00281249999999998*G0_1_0_2_0 - 0.00120535714285712*G0_1_0_2_1 - 0.00160714285714285*G0_1_0_2_5 - 0.0144642857142856*G0_1_0_3_0 - 0.00964285714285724*G0_1_0_3_1 - 0.012857142857143*G0_1_0_3_3 + 0.0449999999999998*G0_1_0_3_4 + 0.032142857142857*G0_1_0_3_5 - 0.0192857142857142*G0_1_0_4_0 - 0.00803571428571425*G0_1_0_4_1 + 0.0449999999999998*G0_1_0_4_3 - 0.0771428571428569*G0_1_0_4_4 + 0.0192857142857142*G0_1_0_4_5 - 0.0241071428571428*G0_1_0_5_0 + 0.0337499999999997*G0_1_0_5_1 - 0.00160714285714285*G0_1_0_5_2 + 0.032142857142857*G0_1_0_5_3 + 0.0192857142857142*G0_1_0_5_4 - 0.179999999999999*G0_1_0_5_5 - 0.00241071428571422*G0_1_1_0_0 - 0.0164732142857142*G0_1_1_0_1 - 0.000401785714285735*G0_1_1_0_2 + 0.00642857142857143*G0_1_1_0_3 - 0.00160714285714281*G0_1_1_0_4 - 0.0257142857142855*G0_1_1_0_5 - 0.0164732142857142*G0_1_1_1_0 + 0.168749999999999*G0_1_1_1_1 - 0.00441964285714281*G0_1_1_1_2 + 0.00803571428571405*G0_1_1_1_3 - 0.00321428571428572*G0_1_1_1_4 + 0.0883928571428565*G0_1_1_1_5 - 0.000401785714285735*G0_1_1_2_0 - 0.00441964285714281*G0_1_1_2_1 - 0.00803571428571415*G0_1_1_2_2 + 0.0160714285714286*G0_1_1_2_3 - 0.00321428571428566*G0_1_1_2_5 + 0.00642857142857143*G0_1_1_3_0 + 0.00803571428571404*G0_1_1_3_1 + 0.0160714285714286*G0_1_1_3_2 - 0.154285714285714*G0_1_1_3_3 - 0.00642857142857146*G0_1_1_3_4 - 0.00642857142857161*G0_1_1_3_5 - 0.00160714285714281*G0_1_1_4_0 - 0.00321428571428572*G0_1_1_4_1 - 0.00642857142857146*G0_1_1_4_3 + 0.0385714285714285*G0_1_1_4_4 + 0.0128571428571428*G0_1_1_4_5 - 0.0257142857142855*G0_1_1_5_0 + 0.0883928571428565*G0_1_1_5_1 - 0.00321428571428566*G0_1_1_5_2 - 0.00642857142857161*G0_1_1_5_3 + 0.0128571428571428*G0_1_1_5_4 + 0.167142857142856*G0_1_1_5_5;
    A[17] = -A[14] + 0.0326785714285712*G0_0_0_0_0 - 0.00339285714285711*G0_0_0_0_1 - 0.0064285714285714*G0_0_0_0_2 - 0.000357142857142846*G0_0_0_0_3 + 0.0114285714285713*G0_0_0_0_4 + 0.00892857142857139*G0_0_0_0_5 - 0.00339285714285711*G0_0_0_1_0 + 0.077678571428571*G0_0_0_1_1 - 0.00607142857142854*G0_0_0_1_2 + 0.032142857142857*G0_0_0_1_3 - 0.0039285714285714*G0_0_0_1_4 - 0.0064285714285714*G0_0_0_2_0 - 0.00607142857142854*G0_0_0_2_1 + 0.0364285714285714*G0_0_0_2_2 - 0.00821428571428565*G0_0_0_2_3 + 0.0103571428571428*G0_0_0_2_4 - 0.00464285714285712*G0_0_0_2_5 - 0.000357142857142846*G0_0_0_3_0 + 0.032142857142857*G0_0_0_3_1 - 0.00821428571428565*G0_0_0_3_2 + 0.0114285714285714*G0_0_0_3_3 + 0.00857142857142852*G0_0_0_3_4 + 0.00999999999999995*G0_0_0_3_5 + 0.0114285714285713*G0_0_0_4_0 - 0.0039285714285714*G0_0_0_4_1 + 0.0103571428571428*G0_0_0_4_2 + 0.00857142857142852*G0_0_0_4_3 + 0.0742857142857139*G0_0_0_4_4 + 0.0171428571428571*G0_0_0_4_5 + 0.00892857142857139*G0_0_0_5_0 - 0.00464285714285712*G0_0_0_5_2 + 0.00999999999999995*G0_0_0_5_3 + 0.0171428571428571*G0_0_0_5_4 + 0.0114285714285714*G0_0_0_5_5 - 0.00374999999999998*G0_0_1_0_0 + 0.00267857142857141*G0_0_1_0_1 + 0.00428571428571425*G0_0_1_0_3 + 0.00107142857142856*G0_0_1_0_4 + 0.017142857142857*G0_0_1_0_5 + 0.00267857142857141*G0_0_1_1_0 - 0.00267857142857143*G0_0_1_1_2 + 0.032142857142857*G0_0_1_1_3 - 0.032142857142857*G0_0_1_1_5 - 0.00267857142857143*G0_0_1_2_1 + 0.00375000000000003*G0_0_1_2_2 - 0.0171428571428571*G0_0_1_2_3 - 0.00107142857142855*G0_0_1_2_4 - 0.00428571428571428*G0_0_1_2_5 + 0.00428571428571425*G0_0_1_3_0 + 0.032142857142857*G0_0_1_3_1 - 0.0171428571428571*G0_0_1_3_2 - 0.00857142857142851*G0_0_1_3_4 + 0.00107142857142855*G0_0_1_4_0 - 0.00107142857142855*G0_0_1_4_2 - 0.00857142857142851*G0_0_1_4_3 + 0.00857142857142854*G0_0_1_4_5 + 0.017142857142857*G0_0_1_5_0 - 0.032142857142857*G0_0_1_5_1 - 0.00428571428571428*G0_0_1_5_2 + 0.00857142857142855*G0_0_1_5_4;
    A[91] = A[19] - 0.00374999999999999*G0_0_1_0_0 + 0.00267857142857142*G0_0_1_0_1 + 0.00428571428571426*G0_0_1_0_3 + 0.00107142857142856*G0_0_1_0_4 + 0.0171428571428571*G0_0_1_0_5 + 0.00267857142857142*G0_0_1_1_0 - 0.00267857142857141*G0_0_1_1_2 + 0.032142857142857*G0_0_1_1_3 - 0.032142857142857*G0_0_1_1_5 - 0.00267857142857141*G0_0_1_2_1 + 0.00375000000000002*G0_0_1_2_2 - 0.017142857142857*G0_0_1_2_3 - 0.00107142857142857*G0_0_1_2_4 - 0.00428571428571427*G0_0_1_2_5 + 0.00428571428571426*G0_0_1_3_0 + 0.032142857142857*G0_0_1_3_1 - 0.017142857142857*G0_0_1_3_2 - 0.00857142857142852*G0_0_1_3_4 + 0.00107142857142856*G0_0_1_4_0 - 0.00107142857142857*G0_0_1_4_2 - 0.00857142857142851*G0_0_1_4_3 + 0.00857142857142856*G0_0_1_4_5 + 0.0171428571428571*G0_0_1_5_0 - 0.032142857142857*G0_0_1_5_1 - 0.00428571428571427*G0_0_1_5_2 + 0.00857142857142856*G0_0_1_5_4 + 0.00374999999999999*G0_1_0_0_0 - 0.00267857142857142*G0_1_0_0_1 - 0.00428571428571426*G0_1_0_0_3 - 0.00107142857142856*G0_1_0_0_4 - 0.0171428571428571*G0_1_0_0_5 - 0.00267857142857142*G0_1_0_1_0 + 0.00267857142857141*G0_1_0_1_2 - 0.032142857142857*G0_1_0_1_3 + 0.032142857142857*G0_1_0_1_5 + 0.00267857142857141*G0_1_0_2_1 - 0.00375000000000002*G0_1_0_2_2 + 0.017142857142857*G0_1_0_2_3 + 0.00107142857142857*G0_1_0_2_4 + 0.00428571428571428*G0_1_0_2_5 - 0.00428571428571426*G0_1_0_3_0 - 0.032142857142857*G0_1_0_3_1 + 0.017142857142857*G0_1_0_3_2 + 0.00857142857142852*G0_1_0_3_4 - 0.00107142857142856*G0_1_0_4_0 + 0.00107142857142857*G0_1_0_4_2 + 0.00857142857142851*G0_1_0_4_3 - 0.00857142857142855*G0_1_0_4_5 - 0.017142857142857*G0_1_0_5_0 + 0.032142857142857*G0_1_0_5_1 + 0.00428571428571428*G0_1_0_5_2 - 0.00857142857142855*G0_1_0_5_4;
    A[61] = -A[91] + 0.0125892857142857*G0_0_0_0_0 + 0.00486607142857138*G0_0_0_0_1 - 0.00299107142857141*G0_0_0_0_2 + 0.0135714285714285*G0_0_0_0_4 + 0.00410714285714283*G0_0_0_0_5 + 0.00486607142857138*G0_0_0_1_0 - 0.0455357142857138*G0_0_0_1_1 + 0.00799107142857139*G0_0_0_1_2 - 0.051785714285714*G0_0_0_1_3 - 0.00749999999999997*G0_0_0_1_4 - 0.0178571428571427*G0_0_0_1_5 - 0.00299107142857141*G0_0_0_2_0 + 0.00799107142857139*G0_0_0_2_1 - 0.0267857142857143*G0_0_0_2_2 + 0.0198214285714285*G0_0_0_2_3 - 0.00910714285714284*G0_0_0_2_4 + 0.00571428571428569*G0_0_0_2_5 - 0.051785714285714*G0_0_0_3_1 + 0.0198214285714285*G0_0_0_3_2 + 0.00428571428571414*G0_0_0_3_3 + 0.0149999999999999*G0_0_0_3_4 - 0.0114285714285714*G0_0_0_3_5 + 0.0135714285714285*G0_0_0_4_0 - 0.00749999999999997*G0_0_0_4_1 - 0.00910714285714283*G0_0_0_4_2 + 0.0149999999999999*G0_0_0_4_3 + 0.0942857142857138*G0_0_0_4_4 + 0.00357142857142856*G0_0_0_4_5 + 0.00410714285714283*G0_0_0_5_0 - 0.0178571428571427*G0_0_0_5_1 + 0.00571428571428569*G0_0_0_5_2 - 0.0114285714285714*G0_0_0_5_3 + 0.00357142857142856*G0_0_0_5_4 - 0.0242857142857141*G0_0_0_5_5 - 0.00482142857142851*G0_1_0_0_0 - 0.00272321428571428*G0_1_0_0_1 + 0.000937500000000001*G0_1_0_0_2 - 0.00303571428571426*G0_1_0_0_3 + 0.00339285714285714*G0_1_0_0_4 - 0.0124999999999999*G0_1_0_0_5 - 0.00272321428571428*G0_1_0_1_0 + 0.00218749999999999*G0_1_0_1_2 - 0.0285714285714284*G0_1_0_1_3 + 0.000535714285714281*G0_1_0_1_4 + 0.0285714285714284*G0_1_0_1_5 + 0.000937500000000001*G0_1_0_2_0 + 0.00218749999999999*G0_1_0_2_1 - 0.0291964285714286*G0_1_0_2_2 + 0.0167857142857142*G0_1_0_2_3 - 0.00660714285714285*G0_1_0_2_4 + 0.00517857142857141*G0_1_0_2_5 - 0.00303571428571427*G0_1_0_3_0 - 0.0285714285714284*G0_1_0_3_1 + 0.0167857142857142*G0_1_0_3_2 + 0.0114285714285713*G0_1_0_3_3 + 0.00499999999999997*G0_1_0_3_4 - 0.00428571428571429*G0_1_0_3_5 + 0.00339285714285714*G0_1_0_4_0 + 0.000535714285714281*G0_1_0_4_1 - 0.00660714285714285*G0_1_0_4_2 + 0.00499999999999997*G0_1_0_4_3 + 0.0385714285714284*G0_1_0_4_4 - 0.0114285714285714*G0_1_0_4_5 - 0.0124999999999999*G0_1_0_5_0 + 0.0285714285714284*G0_1_0_5_1 + 0.00517857142857141*G0_1_0_5_2 - 0.00428571428571429*G0_1_0_5_3 - 0.0114285714285714*G0_1_0_5_4 - 0.00285714285714291*G0_1_0_5_5;
    A[51] = A[61] - 0.0101785714285714*G0_0_0_0_0 + 0.000937500000000009*G0_0_0_0_1 - 0.000937500000000002*G0_0_0_0_2 + 0.000535714285714282*G0_0_0_0_3 - 0.0160714285714285*G0_0_0_0_4 - 0.00107142857142856*G0_0_0_0_5 + 0.000937500000000009*G0_0_0_1_0 - 0.000401785714285713*G0_0_0_1_2 + 0.0053571428571428*G0_0_0_1_3 - 0.000535714285714283*G0_0_0_1_4 - 0.00535714285714289*G0_0_0_1_5 - 0.000937500000000002*G0_0_0_2_0 - 0.000401785714285713*G0_0_0_2_1 + 0.0441964285714285*G0_0_0_2_2 - 0.00321428571428566*G0_0_0_2_3 + 0.0192857142857142*G0_0_0_2_4 - 0.0026785714285714*G0_0_0_2_5 + 0.000535714285714282*G0_0_0_3_0 + 0.0053571428571428*G0_0_0_3_1 - 0.00321428571428566*G0_0_0_3_2 - 0.0257142857142856*G0_0_0_3_3 + 0.00428571428571425*G0_0_0_3_5 - 0.0160714285714285*G0_0_0_4_0 - 0.000535714285714283*G0_0_0_4_1 + 0.0192857142857142*G0_0_0_4_2 - 0.0385714285714283*G0_0_0_4_4 + 0.00642857142857139*G0_0_0_4_5 - 0.00107142857142856*G0_0_0_5_0 - 0.00535714285714289*G0_0_0_5_1 - 0.0026785714285714*G0_0_0_5_2 + 0.00428571428571425*G0_0_0_5_3 + 0.00642857142857139*G0_0_0_5_4 + 0.017142857142857*G0_0_0_5_5 + 0.0340178571428569*G0_1_0_0_0 + 0.000535714285714289*G0_1_0_0_1 - 0.00187499999999999*G0_1_0_0_2 - 0.00214285714285713*G0_1_0_0_3 + 0.00321428571428568*G0_1_0_0_4 - 0.00428571428571427*G0_1_0_0_5 + 0.000535714285714289*G0_1_0_1_0 + 0.00053571428571428*G0_1_0_1_2 - 0.00107142857142857*G0_1_0_1_4 - 0.00187499999999999*G0_1_0_2_0 + 0.00053571428571428*G0_1_0_2_1 + 0.0340178571428572*G0_1_0_2_2 - 0.00428571428571421*G0_1_0_2_3 + 0.00321428571428572*G0_1_0_2_4 - 0.00214285714285712*G0_1_0_2_5 - 0.00214285714285713*G0_1_0_3_0 - 0.00428571428571421*G0_1_0_3_2 - 0.00857142857142852*G0_1_0_3_3 + 0.00642857142857139*G0_1_0_3_4 + 0.00857142857142852*G0_1_0_3_5 + 0.00321428571428568*G0_1_0_4_0 - 0.00107142857142857*G0_1_0_4_1 + 0.00321428571428572*G0_1_0_4_2 + 0.00642857142857139*G0_1_0_4_3 - 0.0771428571428568*G0_1_0_4_4 + 0.00642857142857139*G0_1_0_4_5 - 0.00428571428571427*G0_1_0_5_0 - 0.00214285714285712*G0_1_0_5_2 + 0.00857142857142852*G0_1_0_5_3 + 0.00642857142857139*G0_1_0_5_4 - 0.00857142857142851*G0_1_0_5_5;
    A[41] = -A[61] - 0.0109821428571428*G0_1_0_0_0 + 0.00709821428571422*G0_1_0_0_1 + 0.00874999999999994*G0_1_0_0_3 + 0.00785714285714282*G0_1_0_0_4 + 0.0167857142857142*G0_1_0_0_5 + 0.00709821428571422*G0_1_0_1_0 - 0.0937499999999994*G0_1_0_1_1 + 0.00397321428571426*G0_1_0_1_2 - 0.00178571428571419*G0_1_0_1_3 + 0.00232142857142856*G0_1_0_1_4 - 0.0410714285714283*G0_1_0_1_5 + 0.00397321428571426*G0_1_0_2_1 - 0.0241071428571428*G0_1_0_2_2 - 0.00535714285714287*G0_1_0_2_3 - 0.00535714285714285*G0_1_0_2_4 + 0.00410714285714282*G0_1_0_2_5 + 0.00874999999999993*G0_1_0_3_0 - 0.00178571428571419*G0_1_0_3_1 - 0.00535714285714287*G0_1_0_3_2 - 0.0314285714285712*G0_1_0_3_3 - 0.022142857142857*G0_1_0_3_4 - 0.0257142857142855*G0_1_0_3_5 + 0.00785714285714282*G0_1_0_4_0 + 0.00232142857142856*G0_1_0_4_1 - 0.00535714285714285*G0_1_0_4_2 - 0.022142857142857*G0_1_0_4_3 + 0.0328571428571427*G0_1_0_4_4 - 0.0128571428571428*G0_1_0_4_5 + 0.0167857142857142*G0_1_0_5_0 - 0.0410714285714283*G0_1_0_5_1 + 0.00410714285714282*G0_1_0_5_2 - 0.0257142857142855*G0_1_0_5_3 - 0.0128571428571428*G0_1_0_5_4 - 0.0457142857142854*G0_1_0_5_5;
    A[40] = -A[41] + 0.00723214285714288*G0_0_0_0_0 - 0.00401785714285713*G0_0_0_0_2 + 0.00321428571428569*G0_0_0_0_3 - 0.00321428571428569*G0_0_0_0_4 + 0.00482142857142858*G0_0_0_0_5 - 0.00723214285714286*G0_0_0_1_1 + 0.00401785714285712*G0_0_0_1_2 + 0.0032142857142857*G0_0_0_1_3 - 0.0032142857142857*G0_0_0_1_4 - 0.00482142857142857*G0_0_0_1_5 - 0.00401785714285713*G0_0_0_2_0 + 0.00401785714285712*G0_0_0_2_1 - 0.0160714285714285*G0_0_0_2_3 + 0.0160714285714285*G0_0_0_2_4 + 0.00321428571428569*G0_0_0_3_0 + 0.0032142857142857*G0_0_0_3_1 - 0.0160714285714285*G0_0_0_3_2 - 0.064285714285714*G0_0_0_3_3 - 0.00642857142857142*G0_0_0_3_5 - 0.00321428571428569*G0_0_0_4_0 - 0.0032142857142857*G0_0_0_4_1 + 0.0160714285714285*G0_0_0_4_2 + 0.064285714285714*G0_0_0_4_4 + 0.00642857142857141*G0_0_0_4_5 + 0.00482142857142858*G0_0_0_5_0 - 0.00482142857142857*G0_0_0_5_1 - 0.00642857142857142*G0_0_0_5_3 + 0.00642857142857141*G0_0_0_5_4 + 0.00803571428571431*G0_0_1_0_0 - 0.000758928571428573*G0_0_1_0_1 - 0.0003125*G0_0_1_0_2 + 0.00107142857142857*G0_0_1_0_3 + 0.00178571428571429*G0_0_1_0_4 + 0.00357142857142858*G0_0_1_0_5 - 0.000758928571428573*G0_0_1_1_0 + 0.000803571428571426*G0_0_1_1_1 + 0.00370535714285713*G0_0_1_1_2 + 0.00499999999999997*G0_0_1_1_3 - 0.00214285714285713*G0_0_1_1_4 - 0.00125*G0_0_1_1_5 - 0.0003125*G0_0_1_2_0 + 0.00370535714285713*G0_0_1_2_1 - 0.0348214285714285*G0_0_1_2_2 - 0.0187499999999999*G0_0_1_2_3 - 0.00267857142857144*G0_0_1_2_4 - 0.000714285714285725*G0_0_1_2_5 + 0.00107142857142857*G0_0_1_3_0 + 0.00499999999999997*G0_0_1_3_1 - 0.0187499999999999*G0_0_1_3_2 - 0.0342857142857142*G0_0_1_3_3 + 0.00214285714285712*G0_0_1_3_4 - 0.000714285714285721*G0_0_1_3_5 + 0.00178571428571429*G0_0_1_4_0 - 0.00214285714285713*G0_0_1_4_1 - 0.00267857142857144*G0_0_1_4_2 + 0.00214285714285712*G0_0_1_4_3 + 0.0299999999999999*G0_0_1_4_4 + 0.0057142857142857*G0_0_1_4_5 + 0.00357142857142858*G0_0_1_5_0 - 0.00125*G0_0_1_5_1 - 0.000714285714285725*G0_0_1_5_2 - 0.000714285714285721*G0_0_1_5_3 + 0.0057142857142857*G0_0_1_5_4 + 0.00142857142857145*G0_0_1_5_5 + 0.00562500000000006*G0_1_0_0_0 + 0.00642857142857137*G0_1_0_0_1 - 0.00080357142857143*G0_1_0_0_2 + 0.00803571428571422*G0_1_0_0_3 + 0.00160714285714287*G0_1_0_0_4 + 0.0192857142857142*G0_1_0_0_5 + 0.00642857142857137*G0_1_0_1_0 - 0.0843749999999995*G0_1_0_1_1 + 0.00723214285714281*G0_1_0_1_2 - 0.00482142857142849*G0_1_0_1_3 - 0.00160714285714285*G0_1_0_1_4 - 0.0433928571428569*G0_1_0_1_5 - 0.00080357142857143*G0_1_0_2_0 + 0.00723214285714281*G0_1_0_2_1 - 0.00803571428571423*G0_1_0_2_2 - 0.0160714285714285*G0_1_0_2_3 + 0.00160714285714283*G0_1_0_2_5 + 0.00803571428571422*G0_1_0_3_0 - 0.00482142857142849*G0_1_0_3_1 - 0.0160714285714285*G0_1_0_3_2 - 0.115714285714285*G0_1_0_3_3 - 0.0128571428571428*G0_1_0_3_4 - 0.0192857142857142*G0_1_0_3_5 + 0.00160714285714287*G0_1_0_4_0 - 0.00160714285714285*G0_1_0_4_1 - 0.0128571428571428*G0_1_0_4_3 + 0.0128571428571428*G0_1_0_4_4 + 0.0192857142857142*G0_1_0_5_0 - 0.0433928571428569*G0_1_0_5_1 + 0.00160714285714283*G0_1_0_5_2 - 0.0192857142857142*G0_1_0_5_3 - 0.0385714285714283*G0_1_0_5_5 + 0.00803571428571435*G0_1_1_0_0 - 0.000714285714285718*G0_1_1_0_1 + 0.000178571428571422*G0_1_1_0_2 + 0.000535714285714274*G0_1_1_0_3 - 0.00178571428571425*G0_1_1_0_4 + 0.00714285714285714*G0_1_1_0_5 - 0.000714285714285718*G0_1_1_1_0 + 0.00937499999999994*G0_1_1_1_1 + 0.00276785714285713*G0_1_1_1_2 + 0.000535714285714273*G0_1_1_1_3 - 0.00339285714285713*G0_1_1_1_4 - 0.00589285714285712*G0_1_1_1_5 + 0.000178571428571422*G0_1_1_2_0 + 0.00276785714285713*G0_1_1_2_1 - 0.00937499999999998*G0_1_1_2_2 - 0.0110714285714285*G0_1_1_2_3 - 0.00232142857142857*G0_1_1_2_4 - 0.00160714285714286*G0_1_1_2_5 + 0.000535714285714274*G0_1_1_3_0 + 0.000535714285714273*G0_1_1_3_1 - 0.0110714285714285*G0_1_1_3_2 - 0.0728571428571424*G0_1_1_3_3 + 0.00571428571428569*G0_1_1_3_4 + 0.00214285714285714*G0_1_1_3_5 - 0.00178571428571425*G0_1_1_4_0 - 0.00339285714285713*G0_1_1_4_1 - 0.00232142857142857*G0_1_1_4_2 + 0.00571428571428569*G0_1_1_4_3 + 0.0185714285714285*G0_1_1_4_4 + 0.00999999999999997*G0_1_1_4_5 + 0.00714285714285714*G0_1_1_5_0 - 0.00589285714285712*G0_1_1_5_1 - 0.00160714285714286*G0_1_1_5_2 + 0.00214285714285714*G0_1_1_5_3 + 0.00999999999999997*G0_1_1_5_4 + 0.00428571428571433*G0_1_1_5_5;
    A[4] = A[40] + 0.000491071428571424*G0_0_1_0_2 - 0.00053571428571429*G0_0_1_0_3 - 0.00357142857142854*G0_0_1_0_4 + 0.00357142857142855*G0_0_1_0_5 + 0.00857142857142854*G0_0_1_1_1 - 0.0009375*G0_0_1_1_2 - 0.0044642857142857*G0_0_1_1_3 - 0.00124999999999999*G0_0_1_1_4 - 0.00464285714285711*G0_0_1_1_5 + 0.000491071428571424*G0_0_1_2_0 - 0.0009375*G0_0_1_2_1 + 0.0254464285714285*G0_0_1_2_2 + 0.00767857142857141*G0_0_1_2_3 + 0.000357142857142862*G0_0_1_2_4 - 0.000892857142857133*G0_0_1_2_5 - 0.000535714285714289*G0_0_1_3_0 - 0.0044642857142857*G0_0_1_3_1 + 0.00767857142857141*G0_0_1_3_2 - 0.0385714285714282*G0_0_1_3_3 + 0.00357142857142855*G0_0_1_3_4 + 0.00285714285714284*G0_0_1_3_5 - 0.00357142857142854*G0_0_1_4_0 - 0.00124999999999999*G0_0_1_4_1 + 0.000357142857142862*G0_0_1_4_2 + 0.00357142857142855*G0_0_1_4_3 - 0.0114285714285714*G0_0_1_4_4 + 0.00428571428571426*G0_0_1_4_5 + 0.00357142857142856*G0_0_1_5_0 - 0.00464285714285711*G0_0_1_5_1 - 0.000892857142857132*G0_0_1_5_2 + 0.00285714285714284*G0_0_1_5_3 + 0.00428571428571426*G0_0_1_5_4 + 0.00285714285714283*G0_0_1_5_5 - 0.000491071428571424*G0_1_0_0_2 + 0.00053571428571429*G0_1_0_0_3 + 0.00357142857142854*G0_1_0_0_4 - 0.00357142857142855*G0_1_0_0_5 - 0.00857142857142854*G0_1_0_1_1 + 0.0009375*G0_1_0_1_2 + 0.0044642857142857*G0_1_0_1_3 + 0.00124999999999999*G0_1_0_1_4 + 0.00464285714285711*G0_1_0_1_5 - 0.000491071428571424*G0_1_0_2_0 + 0.0009375*G0_1_0_2_1 - 0.0254464285714285*G0_1_0_2_2 - 0.00767857142857141*G0_1_0_2_3 - 0.000357142857142861*G0_1_0_2_4 + 0.000892857142857133*G0_1_0_2_5 + 0.000535714285714289*G0_1_0_3_0 + 0.0044642857142857*G0_1_0_3_1 - 0.00767857142857141*G0_1_0_3_2 + 0.0385714285714283*G0_1_0_3_3 - 0.00357142857142855*G0_1_0_3_4 - 0.00285714285714284*G0_1_0_3_5 + 0.00357142857142854*G0_1_0_4_0 + 0.00124999999999999*G0_1_0_4_1 - 0.000357142857142861*G0_1_0_4_2 - 0.00357142857142855*G0_1_0_4_3 + 0.0114285714285714*G0_1_0_4_4 - 0.00428571428571426*G0_1_0_4_5 - 0.00357142857142855*G0_1_0_5_0 + 0.00464285714285711*G0_1_0_5_1 + 0.000892857142857132*G0_1_0_5_2 - 0.00285714285714284*G0_1_0_5_3 - 0.00428571428571426*G0_1_0_5_4 - 0.00285714285714282*G0_1_0_5_5;
    A[60] = -A[40] + 0.0937499999999996*G0_1_0_0_0 - 0.00709821428571425*G0_1_0_0_1 - 0.00397321428571427*G0_1_0_0_2 - 0.00232142857142856*G0_1_0_0_3 + 0.00178571428571426*G0_1_0_0_4 + 0.0410714285714284*G0_1_0_0_5 - 0.00709821428571425*G0_1_0_1_0 + 0.0109821428571428*G0_1_0_1_1 - 0.00785714285714282*G0_1_0_1_3 - 0.00874999999999995*G0_1_0_1_4 - 0.0167857142857142*G0_1_0_1_5 - 0.00397321428571427*G0_1_0_2_0 + 0.0241071428571428*G0_1_0_2_2 + 0.00535714285714283*G0_1_0_2_3 + 0.00535714285714284*G0_1_0_2_4 - 0.00410714285714283*G0_1_0_2_5 - 0.00232142857142856*G0_1_0_3_0 - 0.00785714285714282*G0_1_0_3_1 + 0.00535714285714283*G0_1_0_3_2 - 0.0328571428571427*G0_1_0_3_3 + 0.022142857142857*G0_1_0_3_4 + 0.0128571428571428*G0_1_0_3_5 + 0.00178571428571426*G0_1_0_4_0 - 0.00874999999999995*G0_1_0_4_1 + 0.00535714285714284*G0_1_0_4_2 + 0.022142857142857*G0_1_0_4_3 + 0.0314285714285713*G0_1_0_4_4 + 0.0257142857142856*G0_1_0_4_5 + 0.0410714285714284*G0_1_0_5_0 - 0.0167857142857142*G0_1_0_5_1 - 0.00410714285714283*G0_1_0_5_2 + 0.0128571428571428*G0_1_0_5_3 + 0.0257142857142856*G0_1_0_5_4 + 0.0457142857142854*G0_1_0_5_5 + 0.0937499999999996*G0_1_1_0_0 - 0.00709821428571426*G0_1_1_0_1 - 0.00397321428571427*G0_1_1_0_2 - 0.00232142857142856*G0_1_1_0_3 + 0.00178571428571427*G0_1_1_0_4 + 0.0410714285714284*G0_1_1_0_5 - 0.00709821428571426*G0_1_1_1_0 + 0.0109821428571428*G0_1_1_1_1 - 0.00785714285714283*G0_1_1_1_3 - 0.00874999999999995*G0_1_1_1_4 - 0.0167857142857142*G0_1_1_1_5 - 0.00397321428571427*G0_1_1_2_0 + 0.0241071428571428*G0_1_1_2_2 + 0.00535714285714283*G0_1_1_2_3 + 0.00535714285714284*G0_1_1_2_4 - 0.00410714285714284*G0_1_1_2_5 - 0.00232142857142856*G0_1_1_3_0 - 0.00785714285714283*G0_1_1_3_1 + 0.00535714285714283*G0_1_1_3_2 - 0.0328571428571427*G0_1_1_3_3 + 0.022142857142857*G0_1_1_3_4 + 0.0128571428571428*G0_1_1_3_5 + 0.00178571428571427*G0_1_1_4_0 - 0.00874999999999995*G0_1_1_4_1 + 0.00535714285714284*G0_1_1_4_2 + 0.022142857142857*G0_1_1_4_3 + 0.0314285714285713*G0_1_1_4_4 + 0.0257142857142856*G0_1_1_4_5 + 0.0410714285714284*G0_1_1_5_0 - 0.0167857142857142*G0_1_1_5_1 - 0.00410714285714284*G0_1_1_5_2 + 0.0128571428571428*G0_1_1_5_3 + 0.0257142857142856*G0_1_1_5_4 + 0.0457142857142855*G0_1_1_5_5;
    A[71] = -A[41] + 0.0326785714285712*G0_0_0_0_0 - 0.00339285714285711*G0_0_0_0_1 - 0.0064285714285714*G0_0_0_0_2 - 0.000357142857142845*G0_0_0_0_3 + 0.0114285714285713*G0_0_0_0_4 + 0.00892857142857138*G0_0_0_0_5 - 0.00339285714285711*G0_0_0_1_0 + 0.077678571428571*G0_0_0_1_1 - 0.00607142857142854*G0_0_0_1_2 + 0.032142857142857*G0_0_0_1_3 - 0.0039285714285714*G0_0_0_1_4 - 0.0064285714285714*G0_0_0_2_0 - 0.00607142857142854*G0_0_0_2_1 + 0.0364285714285714*G0_0_0_2_2 - 0.00821428571428565*G0_0_0_2_3 + 0.0103571428571428*G0_0_0_2_4 - 0.00464285714285712*G0_0_0_2_5 - 0.000357142857142845*G0_0_0_3_0 + 0.032142857142857*G0_0_0_3_1 - 0.00821428571428565*G0_0_0_3_2 + 0.0114285714285713*G0_0_0_3_3 + 0.00857142857142852*G0_0_0_3_4 + 0.00999999999999994*G0_0_0_3_5 + 0.0114285714285713*G0_0_0_4_0 - 0.0039285714285714*G0_0_0_4_1 + 0.0103571428571428*G0_0_0_4_2 + 0.00857142857142852*G0_0_0_4_3 + 0.0742857142857139*G0_0_0_4_4 + 0.0171428571428571*G0_0_0_4_5 + 0.00892857142857139*G0_0_0_5_0 - 0.00464285714285712*G0_0_0_5_2 + 0.00999999999999994*G0_0_0_5_3 + 0.0171428571428571*G0_0_0_5_4 + 0.0114285714285714*G0_0_0_5_5 - 0.00374999999999998*G0_1_0_0_0 + 0.00267857142857141*G0_1_0_0_1 + 0.00428571428571425*G0_1_0_0_3 + 0.00107142857142856*G0_1_0_0_4 + 0.017142857142857*G0_1_0_0_5 + 0.00267857142857141*G0_1_0_1_0 - 0.00267857142857142*G0_1_0_1_2 + 0.032142857142857*G0_1_0_1_3 - 0.032142857142857*G0_1_0_1_5 - 0.00267857142857143*G0_1_0_2_1 + 0.00375000000000003*G0_1_0_2_2 - 0.0171428571428571*G0_1_0_2_3 - 0.00107142857142855*G0_1_0_2_4 - 0.00428571428571428*G0_1_0_2_5 + 0.00428571428571425*G0_1_0_3_0 + 0.032142857142857*G0_1_0_3_1 - 0.0171428571428571*G0_1_0_3_2 - 0.00857142857142851*G0_1_0_3_4 + 0.00107142857142856*G0_1_0_4_0 - 0.00107142857142855*G0_1_0_4_2 - 0.00857142857142851*G0_1_0_4_3 + 0.00857142857142855*G0_1_0_4_5 + 0.017142857142857*G0_1_0_5_0 - 0.032142857142857*G0_1_0_5_1 - 0.00428571428571428*G0_1_0_5_2 + 0.00857142857142855*G0_1_0_5_4;
    A[30] = A[4] + 0.000937499999999995*G0_0_0_0_1 - 0.000401785714285714*G0_0_0_0_2 - 0.000535714285714291*G0_0_0_0_3 + 0.00535714285714284*G0_0_0_0_4 - 0.00535714285714284*G0_0_0_0_5 + 0.000937499999999995*G0_0_0_1_0 - 0.0101785714285714*G0_0_0_1_1 - 0.0009375*G0_0_0_1_2 - 0.0160714285714285*G0_0_0_1_3 + 0.00053571428571428*G0_0_0_1_4 - 0.00107142857142857*G0_0_0_1_5 - 0.000401785714285714*G0_0_0_2_0 - 0.0009375*G0_0_0_2_1 + 0.0441964285714285*G0_0_0_2_2 + 0.0192857142857142*G0_0_0_2_3 - 0.00321428571428568*G0_0_0_2_4 - 0.00267857142857141*G0_0_0_2_5 - 0.000535714285714291*G0_0_0_3_0 - 0.0160714285714285*G0_0_0_3_1 + 0.0192857142857142*G0_0_0_3_2 - 0.0385714285714282*G0_0_0_3_3 + 0.00642857142857141*G0_0_0_3_5 + 0.00535714285714284*G0_0_0_4_0 + 0.000535714285714281*G0_0_0_4_1 - 0.00321428571428568*G0_0_0_4_2 - 0.0257142857142856*G0_0_0_4_4 + 0.00428571428571427*G0_0_0_4_5 - 0.00535714285714285*G0_0_0_5_0 - 0.00107142857142857*G0_0_0_5_1 - 0.00267857142857141*G0_0_0_5_2 + 0.00642857142857141*G0_0_0_5_3 + 0.00428571428571427*G0_0_0_5_4 + 0.0171428571428571*G0_0_0_5_5 + 0.00089285714285714*G0_0_1_0_1 - 0.000892857142857136*G0_0_1_0_2 + 0.00892857142857138*G0_0_1_0_4 - 0.0089285714285714*G0_0_1_0_5 + 0.00089285714285714*G0_0_1_1_0 - 0.0187499999999999*G0_0_1_1_1 - 0.0116071428571428*G0_0_1_1_3 + 0.00178571428571427*G0_0_1_1_4 + 0.00357142857142855*G0_0_1_1_5 - 0.000892857142857136*G0_0_1_2_0 + 0.01875*G0_0_1_2_2 + 0.0116071428571428*G0_0_1_2_3 - 0.00357142857142855*G0_0_1_2_4 - 0.00178571428571428*G0_0_1_2_5 - 0.0116071428571428*G0_0_1_3_1 + 0.0116071428571428*G0_0_1_3_2 - 0.00357142857142854*G0_0_1_3_4 + 0.00357142857142857*G0_0_1_3_5 + 0.00892857142857138*G0_0_1_4_0 + 0.00178571428571427*G0_0_1_4_1 - 0.00357142857142855*G0_0_1_4_2 - 0.00357142857142854*G0_0_1_4_3 - 0.0142857142857142*G0_0_1_4_4 - 0.0089285714285714*G0_0_1_5_0 + 0.00357142857142855*G0_0_1_5_1 - 0.00178571428571428*G0_0_1_5_2 + 0.00357142857142857*G0_0_1_5_3 + 0.0142857142857142*G0_0_1_5_5 + 0.000446428571428581*G0_1_0_0_1 - 0.000446428571428559*G0_1_0_0_2 + 0.00178571428571424*G0_1_0_0_4 - 0.00178571428571434*G0_1_0_0_5 + 0.000446428571428581*G0_1_0_1_0 - 0.0356249999999999*G0_1_0_1_1 - 0.0237499999999999*G0_1_0_1_3 + 0.00142857142857142*G0_1_0_1_4 - 0.00142857142857143*G0_1_0_1_5 - 0.000446428571428559*G0_1_0_2_0 + 0.0356249999999999*G0_1_0_2_2 + 0.0237499999999999*G0_1_0_2_3 + 0.00142857142857143*G0_1_0_2_4 - 0.00142857142857141*G0_1_0_2_5 - 0.0237499999999999*G0_1_0_3_1 + 0.0237499999999999*G0_1_0_3_2 - 0.00285714285714283*G0_1_0_3_4 + 0.00285714285714285*G0_1_0_3_5 + 0.00178571428571424*G0_1_0_4_0 + 0.00142857142857142*G0_1_0_4_1 + 0.00142857142857143*G0_1_0_4_2 - 0.00285714285714283*G0_1_0_4_3 - 0.0285714285714284*G0_1_0_4_4 - 0.00178571428571434*G0_1_0_5_0 - 0.00142857142857143*G0_1_0_5_1 - 0.00142857142857141*G0_1_0_5_2 + 0.00285714285714285*G0_1_0_5_3 + 0.0285714285714284*G0_1_0_5_5 + 0.000401785714285721*G0_1_1_0_1 - 0.000937499999999982*G0_1_1_0_2 + 0.000535714285714282*G0_1_1_0_3 + 0.00535714285714278*G0_1_1_0_4 - 0.0053571428571429*G0_1_1_0_5 + 0.000401785714285721*G0_1_1_1_0 - 0.0441964285714283*G0_1_1_1_1 + 0.000937499999999988*G0_1_1_1_2 - 0.0192857142857142*G0_1_1_1_3 + 0.00267857142857141*G0_1_1_1_4 + 0.00321428571428571*G0_1_1_1_5 - 0.000937499999999982*G0_1_1_2_0 + 0.000937499999999989*G0_1_1_2_1 + 0.0101785714285714*G0_1_1_2_2 + 0.0160714285714285*G0_1_1_2_3 + 0.00107142857142857*G0_1_1_2_4 - 0.000535714285714274*G0_1_1_2_5 + 0.000535714285714282*G0_1_1_3_0 - 0.0192857142857142*G0_1_1_3_1 + 0.0160714285714285*G0_1_1_3_2 + 0.0385714285714284*G0_1_1_3_3 - 0.00642857142857138*G0_1_1_3_4 + 0.00535714285714278*G0_1_1_4_0 + 0.00267857142857141*G0_1_1_4_1 + 0.00107142857142857*G0_1_1_4_2 - 0.00642857142857138*G0_1_1_4_3 - 0.0171428571428571*G0_1_1_4_4 - 0.00428571428571428*G0_1_1_4_5 - 0.0053571428571429*G0_1_1_5_0 + 0.00321428571428571*G0_1_1_5_1 - 0.000535714285714275*G0_1_1_5_2 - 0.00428571428571428*G0_1_1_5_4 + 0.0257142857142855*G0_1_1_5_5;
    A[80] = -A[30] + 0.0937499999999995*G0_0_0_0_0 - 0.00397321428571426*G0_0_0_0_1 - 0.00709821428571425*G0_0_0_0_2 - 0.00232142857142856*G0_0_0_0_3 + 0.0410714285714284*G0_0_0_0_4 + 0.00178571428571427*G0_0_0_0_5 - 0.00397321428571426*G0_0_0_1_0 + 0.0241071428571428*G0_0_0_1_1 + 0.00535714285714282*G0_0_0_1_3 - 0.00410714285714284*G0_0_0_1_4 + 0.00535714285714283*G0_0_0_1_5 - 0.00709821428571425*G0_0_0_2_0 + 0.0109821428571429*G0_0_0_2_2 - 0.0078571428571428*G0_0_0_2_3 - 0.0167857142857142*G0_0_0_2_4 - 0.00874999999999997*G0_0_0_2_5 - 0.00232142857142856*G0_0_0_3_0 + 0.00535714285714282*G0_0_0_3_1 - 0.0078571428571428*G0_0_0_3_2 - 0.0328571428571426*G0_0_0_3_3 + 0.0128571428571428*G0_0_0_3_4 + 0.0221428571428571*G0_0_0_3_5 + 0.0410714285714284*G0_0_0_4_0 - 0.00410714285714284*G0_0_0_4_1 - 0.0167857142857142*G0_0_0_4_2 + 0.0128571428571428*G0_0_0_4_3 + 0.0457142857142855*G0_0_0_4_4 + 0.0257142857142856*G0_0_0_4_5 + 0.00178571428571427*G0_0_0_5_0 + 0.00535714285714283*G0_0_0_5_1 - 0.00874999999999997*G0_0_0_5_2 + 0.0221428571428571*G0_0_0_5_3 + 0.0257142857142856*G0_0_0_5_4 + 0.0314285714285714*G0_0_0_5_5 + 0.0937499999999995*G0_0_1_0_0 - 0.00397321428571426*G0_0_1_0_1 - 0.00709821428571425*G0_0_1_0_2 - 0.00232142857142856*G0_0_1_0_3 + 0.0410714285714284*G0_0_1_0_4 + 0.00178571428571426*G0_0_1_0_5 - 0.00397321428571426*G0_0_1_1_0 + 0.0241071428571427*G0_0_1_1_1 + 0.00535714285714281*G0_0_1_1_3 - 0.00410714285714284*G0_0_1_1_4 + 0.00535714285714282*G0_0_1_1_5 - 0.00709821428571425*G0_0_1_2_0 + 0.0109821428571429*G0_0_1_2_2 - 0.00785714285714281*G0_0_1_2_3 - 0.0167857142857142*G0_0_1_2_4 - 0.00874999999999997*G0_0_1_2_5 - 0.00232142857142856*G0_0_1_3_0 + 0.00535714285714281*G0_0_1_3_1 - 0.00785714285714281*G0_0_1_3_2 - 0.0328571428571426*G0_0_1_3_3 + 0.0128571428571428*G0_0_1_3_4 + 0.0221428571428571*G0_0_1_3_5 + 0.0410714285714284*G0_0_1_4_0 - 0.00410714285714284*G0_0_1_4_1 - 0.0167857142857142*G0_0_1_4_2 + 0.0128571428571428*G0_0_1_4_3 + 0.0457142857142855*G0_0_1_4_4 + 0.0257142857142856*G0_0_1_4_5 + 0.00178571428571427*G0_0_1_5_0 + 0.00535714285714282*G0_0_1_5_1 - 0.00874999999999997*G0_0_1_5_2 + 0.0221428571428571*G0_0_1_5_3 + 0.0257142857142856*G0_0_1_5_4 + 0.0314285714285713*G0_0_1_5_5;
    A[6] = -A[4] + 0.0937499999999996*G0_0_1_0_0 - 0.00709821428571425*G0_0_1_0_1 - 0.00397321428571427*G0_0_1_0_2 - 0.00232142857142856*G0_0_1_0_3 + 0.00178571428571426*G0_0_1_0_4 + 0.0410714285714284*G0_0_1_0_5 - 0.00709821428571425*G0_0_1_1_0 + 0.0109821428571428*G0_0_1_1_1 - 0.00785714285714282*G0_0_1_1_3 - 0.00874999999999995*G0_0_1_1_4 - 0.0167857142857142*G0_0_1_1_5 - 0.00397321428571427*G0_0_1_2_0 + 0.0241071428571428*G0_0_1_2_2 + 0.00535714285714284*G0_0_1_2_3 + 0.00535714285714284*G0_0_1_2_4 - 0.00410714285714283*G0_0_1_2_5 - 0.00232142857142856*G0_0_1_3_0 - 0.00785714285714283*G0_0_1_3_1 + 0.00535714285714284*G0_0_1_3_2 - 0.0328571428571427*G0_0_1_3_3 + 0.022142857142857*G0_0_1_3_4 + 0.0128571428571428*G0_0_1_3_5 + 0.00178571428571427*G0_0_1_4_0 - 0.00874999999999995*G0_0_1_4_1 + 0.00535714285714284*G0_0_1_4_2 + 0.022142857142857*G0_0_1_4_3 + 0.0314285714285713*G0_0_1_4_4 + 0.0257142857142856*G0_0_1_4_5 + 0.0410714285714284*G0_0_1_5_0 - 0.0167857142857142*G0_0_1_5_1 - 0.00410714285714283*G0_0_1_5_2 + 0.0128571428571428*G0_0_1_5_3 + 0.0257142857142856*G0_0_1_5_4 + 0.0457142857142854*G0_0_1_5_5 + 0.0937499999999996*G0_1_1_0_0 - 0.00709821428571426*G0_1_1_0_1 - 0.00397321428571427*G0_1_1_0_2 - 0.00232142857142856*G0_1_1_0_3 + 0.00178571428571427*G0_1_1_0_4 + 0.0410714285714284*G0_1_1_0_5 - 0.00709821428571426*G0_1_1_1_0 + 0.0109821428571428*G0_1_1_1_1 - 0.00785714285714283*G0_1_1_1_3 - 0.00874999999999995*G0_1_1_1_4 - 0.0167857142857142*G0_1_1_1_5 - 0.00397321428571427*G0_1_1_2_0 + 0.0241071428571428*G0_1_1_2_2 + 0.00535714285714283*G0_1_1_2_3 + 0.00535714285714284*G0_1_1_2_4 - 0.00410714285714284*G0_1_1_2_5 - 0.00232142857142856*G0_1_1_3_0 - 0.00785714285714283*G0_1_1_3_1 + 0.00535714285714283*G0_1_1_3_2 - 0.0328571428571426*G0_1_1_3_3 + 0.022142857142857*G0_1_1_3_4 + 0.0128571428571428*G0_1_1_3_5 + 0.00178571428571427*G0_1_1_4_0 - 0.00874999999999995*G0_1_1_4_1 + 0.00535714285714284*G0_1_1_4_2 + 0.022142857142857*G0_1_1_4_3 + 0.0314285714285713*G0_1_1_4_4 + 0.0257142857142856*G0_1_1_4_5 + 0.0410714285714284*G0_1_1_5_0 - 0.0167857142857142*G0_1_1_5_1 - 0.00410714285714284*G0_1_1_5_2 + 0.0128571428571428*G0_1_1_5_3 + 0.0257142857142856*G0_1_1_5_4 + 0.0457142857142855*G0_1_1_5_5;
    A[3] = A[30] - 0.000491071428571413*G0_0_1_0_1 + 0.000535714285714288*G0_0_1_0_3 - 0.0035714285714286*G0_0_1_0_4 + 0.00357142857142851*G0_0_1_0_5 - 0.000491071428571413*G0_0_1_1_0 - 0.0254464285714285*G0_0_1_1_1 + 0.0009375*G0_0_1_1_2 - 0.0076785714285714*G0_0_1_1_3 + 0.000892857142857137*G0_0_1_1_4 - 0.000357142857142866*G0_0_1_1_5 + 0.000937500000000001*G0_0_1_2_1 - 0.00857142857142858*G0_0_1_2_2 + 0.00446428571428569*G0_0_1_2_3 + 0.00464285714285712*G0_0_1_2_4 + 0.00125*G0_0_1_2_5 + 0.000535714285714287*G0_0_1_3_0 - 0.0076785714285714*G0_0_1_3_1 + 0.00446428571428569*G0_0_1_3_2 + 0.0385714285714283*G0_0_1_3_3 - 0.00285714285714284*G0_0_1_3_4 - 0.00357142857142856*G0_0_1_3_5 - 0.0035714285714286*G0_0_1_4_0 + 0.000892857142857137*G0_0_1_4_1 + 0.00464285714285712*G0_0_1_4_2 - 0.00285714285714284*G0_0_1_4_3 - 0.00285714285714283*G0_0_1_4_4 - 0.00428571428571428*G0_0_1_4_5 + 0.00357142857142851*G0_0_1_5_0 - 0.000357142857142865*G0_0_1_5_1 + 0.00125*G0_0_1_5_2 - 0.00357142857142856*G0_0_1_5_3 - 0.00428571428571428*G0_0_1_5_4 + 0.0114285714285713*G0_0_1_5_5 + 0.000491071428571413*G0_1_0_0_1 - 0.000535714285714287*G0_1_0_0_3 + 0.0035714285714286*G0_1_0_0_4 - 0.00357142857142851*G0_1_0_0_5 + 0.000491071428571413*G0_1_0_1_0 + 0.0254464285714285*G0_1_0_1_1 - 0.000937500000000001*G0_1_0_1_2 + 0.0076785714285714*G0_1_0_1_3 - 0.000892857142857138*G0_1_0_1_4 + 0.000357142857142866*G0_1_0_1_5 - 0.000937500000000002*G0_1_0_2_1 + 0.00857142857142858*G0_1_0_2_2 - 0.00446428571428569*G0_1_0_2_3 - 0.00464285714285712*G0_1_0_2_4 - 0.00125*G0_1_0_2_5 - 0.000535714285714287*G0_1_0_3_0 + 0.0076785714285714*G0_1_0_3_1 - 0.00446428571428569*G0_1_0_3_2 - 0.0385714285714283*G0_1_0_3_3 + 0.00285714285714284*G0_1_0_3_4 + 0.00357142857142856*G0_1_0_3_5 + 0.0035714285714286*G0_1_0_4_0 - 0.000892857142857137*G0_1_0_4_1 - 0.00464285714285712*G0_1_0_4_2 + 0.00285714285714284*G0_1_0_4_3 + 0.00285714285714283*G0_1_0_4_4 + 0.00428571428571428*G0_1_0_4_5 - 0.00357142857142851*G0_1_0_5_0 + 0.000357142857142864*G0_1_0_5_1 - 0.00125*G0_1_0_5_2 + 0.00357142857142856*G0_1_0_5_3 + 0.00428571428571428*G0_1_0_5_4 - 0.0114285714285713*G0_1_0_5_5;
    A[8] = -A[3] + 0.0937499999999995*G0_0_0_0_0 - 0.00397321428571426*G0_0_0_0_1 - 0.00709821428571425*G0_0_0_0_2 - 0.00232142857142856*G0_0_0_0_3 + 0.0410714285714284*G0_0_0_0_4 + 0.00178571428571426*G0_0_0_0_5 - 0.00397321428571426*G0_0_0_1_0 + 0.0241071428571428*G0_0_0_1_1 + 0.00535714285714282*G0_0_0_1_3 - 0.00410714285714284*G0_0_0_1_4 + 0.00535714285714284*G0_0_0_1_5 - 0.00709821428571425*G0_0_0_2_0 + 0.0109821428571429*G0_0_0_2_2 - 0.0078571428571428*G0_0_0_2_3 - 0.0167857142857142*G0_0_0_2_4 - 0.00874999999999997*G0_0_0_2_5 - 0.00232142857142856*G0_0_0_3_0 + 0.00535714285714282*G0_0_0_3_1 - 0.0078571428571428*G0_0_0_3_2 - 0.0328571428571426*G0_0_0_3_3 + 0.0128571428571428*G0_0_0_3_4 + 0.0221428571428571*G0_0_0_3_5 + 0.0410714285714284*G0_0_0_4_0 - 0.00410714285714284*G0_0_0_4_1 - 0.0167857142857142*G0_0_0_4_2 + 0.0128571428571428*G0_0_0_4_3 + 0.0457142857142855*G0_0_0_4_4 + 0.0257142857142856*G0_0_0_4_5 + 0.00178571428571427*G0_0_0_5_0 + 0.00535714285714283*G0_0_0_5_1 - 0.00874999999999997*G0_0_0_5_2 + 0.0221428571428571*G0_0_0_5_3 + 0.0257142857142856*G0_0_0_5_4 + 0.0314285714285714*G0_0_0_5_5 + 0.0937499999999995*G0_1_0_0_0 - 0.00397321428571426*G0_1_0_0_1 - 0.00709821428571425*G0_1_0_0_2 - 0.00232142857142856*G0_1_0_0_3 + 0.0410714285714284*G0_1_0_0_4 + 0.00178571428571426*G0_1_0_0_5 - 0.00397321428571426*G0_1_0_1_0 + 0.0241071428571427*G0_1_0_1_1 + 0.00535714285714281*G0_1_0_1_3 - 0.00410714285714284*G0_1_0_1_4 + 0.00535714285714282*G0_1_0_1_5 - 0.00709821428571425*G0_1_0_2_0 + 0.0109821428571429*G0_1_0_2_2 - 0.00785714285714281*G0_1_0_2_3 - 0.0167857142857142*G0_1_0_2_4 - 0.00874999999999997*G0_1_0_2_5 - 0.00232142857142856*G0_1_0_3_0 + 0.00535714285714281*G0_1_0_3_1 - 0.00785714285714281*G0_1_0_3_2 - 0.0328571428571426*G0_1_0_3_3 + 0.0128571428571428*G0_1_0_3_4 + 0.0221428571428571*G0_1_0_3_5 + 0.0410714285714284*G0_1_0_4_0 - 0.00410714285714284*G0_1_0_4_1 - 0.0167857142857142*G0_1_0_4_2 + 0.0128571428571428*G0_1_0_4_3 + 0.0457142857142855*G0_1_0_4_4 + 0.0257142857142856*G0_1_0_4_5 + 0.00178571428571426*G0_1_0_5_0 + 0.00535714285714283*G0_1_0_5_1 - 0.00874999999999997*G0_1_0_5_2 + 0.0221428571428571*G0_1_0_5_3 + 0.0257142857142856*G0_1_0_5_4 + 0.0314285714285713*G0_1_0_5_5;
    A[12] = 0.00247023809523808*G0_0_1_0_0 - 0.00157242063492062*G0_0_1_0_1 - 0.00157242063492063*G0_0_1_0_2 - 0.000932539682539674*G0_0_1_0_3 - 0.0032142857142857*G0_0_1_0_4 - 0.00321428571428569*G0_0_1_0_5 - 0.00157242063492062*G0_0_1_1_0 + 0.019345238095238*G0_0_1_1_1 - 0.00112599206349206*G0_0_1_1_2 + 0.00178571428571426*G0_0_1_1_3 - 0.000575396825396823*G0_0_1_1_4 + 0.00892857142857136*G0_0_1_1_5 - 0.00157242063492063*G0_0_1_2_0 - 0.00112599206349206*G0_0_1_2_1 + 0.0193452380952381*G0_0_1_2_2 + 0.00178571428571429*G0_0_1_2_3 + 0.0089285714285714*G0_0_1_2_4 - 0.000575396825396816*G0_0_1_2_5 - 0.000932539682539674*G0_0_1_3_0 + 0.00178571428571426*G0_0_1_3_1 + 0.00178571428571429*G0_0_1_3_2 - 0.00539682539682539*G0_0_1_3_3 + 0.003015873015873*G0_0_1_3_4 + 0.00301587301587299*G0_0_1_3_5 - 0.0032142857142857*G0_0_1_4_0 - 0.000575396825396823*G0_0_1_4_1 + 0.0089285714285714*G0_0_1_4_2 + 0.003015873015873*G0_0_1_4_3 + 0.00888888888888886*G0_0_1_4_4 + 0.00230158730158729*G0_0_1_4_5 - 0.00321428571428569*G0_0_1_5_0 + 0.00892857142857136*G0_0_1_5_1 - 0.000575396825396816*G0_0_1_5_2 + 0.00301587301587299*G0_0_1_5_3 + 0.00230158730158729*G0_0_1_5_4 + 0.00888888888888882*G0_0_1_5_5;
    A[2] = -A[12] - 0.0168749999999999*G0_0_1_0_0 - 0.000446428571428575*G0_0_1_0_2 - 0.000357142857142852*G0_0_1_0_3 - 0.00499999999999996*G0_0_1_0_4 - 0.0121428571428571*G0_0_1_0_5 + 0.0168749999999999*G0_0_1_1_1 + 0.000446428571428572*G0_0_1_1_2 + 0.00499999999999996*G0_0_1_1_3 + 0.000357142857142852*G0_0_1_1_4 + 0.012142857142857*G0_0_1_1_5 - 0.000446428571428574*G0_0_1_2_0 + 0.000446428571428572*G0_0_1_2_1 - 0.00714285714285709*G0_0_1_2_3 + 0.00714285714285711*G0_0_1_2_4 - 0.000357142857142853*G0_0_1_3_0 + 0.00499999999999996*G0_0_1_3_1 - 0.00714285714285709*G0_0_1_3_2 - 0.0142857142857142*G0_0_1_3_3 + 0.000714285714285692*G0_0_1_3_5 - 0.00499999999999996*G0_0_1_4_0 + 0.000357142857142852*G0_0_1_4_1 + 0.00714285714285711*G0_0_1_4_2 + 0.0142857142857142*G0_0_1_4_4 - 0.000714285714285702*G0_0_1_4_5 - 0.0121428571428571*G0_0_1_5_0 + 0.0121428571428571*G0_0_1_5_1 + 0.000714285714285691*G0_0_1_5_3 - 0.000714285714285702*G0_0_1_5_4 - 0.019345238095238*G0_1_1_0_0 + 0.00157242063492062*G0_1_1_0_1 + 0.00112599206349206*G0_1_1_0_2 + 0.000575396825396824*G0_1_1_0_3 - 0.00178571428571426*G0_1_1_0_4 - 0.00892857142857137*G0_1_1_0_5 + 0.00157242063492062*G0_1_1_1_0 - 0.00247023809523808*G0_1_1_1_1 + 0.00157242063492063*G0_1_1_1_2 + 0.0032142857142857*G0_1_1_1_3 + 0.000932539682539677*G0_1_1_1_4 + 0.00321428571428569*G0_1_1_1_5 + 0.00112599206349206*G0_1_1_2_0 + 0.00157242063492063*G0_1_1_2_1 - 0.0193452380952381*G0_1_1_2_2 - 0.0089285714285714*G0_1_1_2_3 - 0.00178571428571429*G0_1_1_2_4 + 0.000575396825396817*G0_1_1_2_5 + 0.000575396825396824*G0_1_1_3_0 + 0.0032142857142857*G0_1_1_3_1 - 0.0089285714285714*G0_1_1_3_2 - 0.00888888888888887*G0_1_1_3_3 - 0.00301587301587301*G0_1_1_3_4 - 0.0023015873015873*G0_1_1_3_5 - 0.00178571428571426*G0_1_1_4_0 + 0.000932539682539677*G0_1_1_4_1 - 0.00178571428571429*G0_1_1_4_2 - 0.00301587301587301*G0_1_1_4_3 + 0.00539682539682537*G0_1_1_4_4 - 0.003015873015873*G0_1_1_4_5 - 0.00892857142857137*G0_1_1_5_0 + 0.00321428571428569*G0_1_1_5_1 + 0.000575396825396817*G0_1_1_5_2 - 0.0023015873015873*G0_1_1_5_3 - 0.003015873015873*G0_1_1_5_4 - 0.00888888888888885*G0_1_1_5_5;
    A[29] = A[92] - 0.00374999999999998*G0_0_1_0_0 + 0.00267857142857141*G0_0_1_0_2 + 0.00428571428571427*G0_0_1_0_3 + 0.0171428571428571*G0_0_1_0_4 + 0.00107142857142858*G0_0_1_0_5 + 0.00374999999999993*G0_0_1_1_1 - 0.0026785714285714*G0_0_1_1_2 - 0.0171428571428571*G0_0_1_1_3 - 0.00428571428571428*G0_0_1_1_4 - 0.0010714285714286*G0_0_1_1_5 + 0.00267857142857141*G0_0_1_2_0 - 0.0026785714285714*G0_0_1_2_1 + 0.0321428571428569*G0_0_1_2_3 - 0.032142857142857*G0_0_1_2_4 + 0.00428571428571427*G0_0_1_3_0 - 0.0171428571428571*G0_0_1_3_1 + 0.0321428571428569*G0_0_1_3_2 - 0.00857142857142854*G0_0_1_3_5 + 0.0171428571428571*G0_0_1_4_0 - 0.00428571428571428*G0_0_1_4_1 - 0.032142857142857*G0_0_1_4_2 + 0.00857142857142854*G0_0_1_4_5 + 0.00107142857142858*G0_0_1_5_0 - 0.0010714285714286*G0_0_1_5_1 - 0.00857142857142854*G0_0_1_5_3 + 0.00857142857142854*G0_0_1_5_4 + 0.00374999999999998*G0_1_0_0_0 - 0.00267857142857141*G0_1_0_0_2 - 0.00428571428571427*G0_1_0_0_3 - 0.0171428571428571*G0_1_0_0_4 - 0.00107142857142858*G0_1_0_0_5 - 0.00374999999999993*G0_1_0_1_1 + 0.0026785714285714*G0_1_0_1_2 + 0.0171428571428571*G0_1_0_1_3 + 0.00428571428571428*G0_1_0_1_4 + 0.0010714285714286*G0_1_0_1_5 - 0.00267857142857141*G0_1_0_2_0 + 0.0026785714285714*G0_1_0_2_1 - 0.0321428571428569*G0_1_0_2_3 + 0.032142857142857*G0_1_0_2_4 - 0.00428571428571427*G0_1_0_3_0 + 0.0171428571428571*G0_1_0_3_1 - 0.0321428571428569*G0_1_0_3_2 + 0.00857142857142854*G0_1_0_3_5 - 0.0171428571428571*G0_1_0_4_0 + 0.00428571428571428*G0_1_0_4_1 + 0.032142857142857*G0_1_0_4_2 - 0.00857142857142854*G0_1_0_4_5 - 0.00107142857142858*G0_1_0_5_0 + 0.0010714285714286*G0_1_0_5_1 + 0.00857142857142854*G0_1_0_5_3 - 0.00857142857142854*G0_1_0_5_4;
    A[69] = -A[29] + 0.00160714285714287*G0_0_0_0_0 + 0.00803571428571425*G0_0_0_0_2 - 0.00642857142857138*G0_0_0_0_3 + 0.0385714285714284*G0_0_0_0_4 + 0.00642857142857141*G0_0_0_0_5 - 0.00160714285714285*G0_0_0_1_1 - 0.00803571428571423*G0_0_0_1_2 - 0.0385714285714283*G0_0_0_1_3 + 0.0064285714285714*G0_0_0_1_4 - 0.00642857142857141*G0_0_0_1_5 + 0.00803571428571425*G0_0_0_2_0 - 0.00803571428571423*G0_0_0_2_1 + 0.0642857142857138*G0_0_0_2_3 - 0.0642857142857139*G0_0_0_2_4 - 0.00642857142857138*G0_0_0_3_0 - 0.0385714285714283*G0_0_0_3_1 + 0.0642857142857138*G0_0_0_3_2 + 0.257142857142856*G0_0_0_3_3 + 0.0128571428571429*G0_0_0_3_5 + 0.0385714285714284*G0_0_0_4_0 + 0.0064285714285714*G0_0_0_4_1 - 0.064285714285714*G0_0_0_4_2 - 0.257142857142856*G0_0_0_4_4 - 0.0128571428571428*G0_0_0_4_5 + 0.00642857142857141*G0_0_0_5_0 - 0.00642857142857141*G0_0_0_5_1 + 0.0128571428571429*G0_0_0_5_3 - 0.0128571428571428*G0_0_0_5_4 + 0.00964285714285714*G0_0_1_0_0 + 0.0040178571428571*G0_0_1_0_1 - 0.0136607142857142*G0_0_1_0_2 - 0.0289285714285713*G0_0_1_0_3 - 0.0160714285714285*G0_0_1_0_4 - 0.00321428571428568*G0_0_1_0_5 + 0.00401785714285711*G0_0_1_1_0 + 0.00803571428571428*G0_0_1_1_1 - 0.0216964285714285*G0_0_1_1_2 - 0.0546428571428569*G0_0_1_1_3 - 0.0224999999999999*G0_0_1_1_4 - 0.00964285714285711*G0_0_1_1_5 - 0.0136607142857142*G0_0_1_2_0 - 0.0216964285714285*G0_0_1_2_1 + 0.1125*G0_0_1_2_2 + 0.112499999999999*G0_0_1_2_3 + 0.0482142857142855*G0_0_1_2_4 + 0.00321428571428572*G0_0_1_2_5 - 0.0289285714285713*G0_0_1_3_0 - 0.0546428571428569*G0_0_1_3_1 + 0.112499999999999*G0_0_1_3_2 + 0.347142857142856*G0_0_1_3_3 + 0.102857142857143*G0_0_1_3_4 + 0.0514285714285714*G0_0_1_3_5 - 0.0160714285714285*G0_0_1_4_0 - 0.0224999999999999*G0_0_1_4_1 + 0.0482142857142856*G0_0_1_4_2 + 0.102857142857143*G0_0_1_4_3 + 0.0899999999999997*G0_0_1_4_4 + 0.0385714285714285*G0_0_1_4_5 - 0.00321428571428568*G0_0_1_5_0 - 0.00964285714285711*G0_0_1_5_1 + 0.00321428571428572*G0_0_1_5_2 + 0.0514285714285714*G0_0_1_5_3 + 0.0385714285714285*G0_0_1_5_4 + 0.0642857142857143*G0_0_1_5_5 - 0.00267857142857144*G0_1_0_0_0 + 0.00321428571428568*G0_1_0_0_1 - 0.00910714285714281*G0_1_0_0_2 - 0.00749999999999992*G0_1_0_0_3 - 0.00107142857142848*G0_1_0_0_4 - 0.00428571428571424*G0_1_0_0_5 + 0.00321428571428568*G0_1_0_1_0 - 0.000535714285714259*G0_1_0_1_1 - 0.00374999999999996*G0_1_0_1_2 - 0.024642857142857*G0_1_0_1_3 - 0.0374999999999998*G0_1_0_1_4 - 0.0117857142857142*G0_1_0_1_5 - 0.00910714285714281*G0_1_0_2_0 - 0.00374999999999996*G0_1_0_2_1 + 0.0321428571428569*G0_1_0_2_2 + 0.0321428571428569*G0_1_0_2_3 - 0.0032142857142857*G0_1_0_2_5 - 0.00749999999999991*G0_1_0_3_0 - 0.024642857142857*G0_1_0_3_1 + 0.0321428571428569*G0_1_0_3_2 + 0.167142857142856*G0_1_0_3_3 + 0.0899999999999996*G0_1_0_3_4 + 0.0214285714285713*G0_1_0_3_5 - 0.00107142857142849*G0_1_0_4_0 - 0.0374999999999998*G0_1_0_4_1 + 0.0899999999999996*G0_1_0_4_3 + 0.55285714285714*G0_1_0_4_4 + 0.0814285714285712*G0_1_0_4_5 - 0.00428571428571424*G0_1_0_5_0 - 0.0117857142857142*G0_1_0_5_1 - 0.0032142857142857*G0_1_0_5_2 + 0.0214285714285713*G0_1_0_5_3 + 0.0814285714285712*G0_1_0_5_4 + 0.0128571428571429*G0_1_0_5_5 - 0.0348214285714285*G0_1_1_0_0 + 0.00696428571428568*G0_1_1_0_1 - 0.00428571428571423*G0_1_1_0_3 - 0.00107142857142856*G0_1_1_0_4 - 0.0364285714285713*G0_1_1_0_5 + 0.00696428571428568*G0_1_1_1_0 - 0.00696428571428567*G0_1_1_1_2 - 0.0128571428571428*G0_1_1_1_3 + 0.0128571428571428*G0_1_1_1_5 - 0.00696428571428567*G0_1_1_2_1 + 0.0348214285714284*G0_1_1_2_2 + 0.0364285714285712*G0_1_1_2_3 + 0.00107142857142857*G0_1_1_2_4 + 0.00428571428571426*G0_1_1_2_5 - 0.00428571428571423*G0_1_1_3_0 - 0.0128571428571428*G0_1_1_3_1 + 0.0364285714285712*G0_1_1_3_2 + 0.154285714285713*G0_1_1_3_3 + 0.00857142857142849*G0_1_1_3_4 - 0.00107142857142856*G0_1_1_4_0 + 0.00107142857142857*G0_1_1_4_2 + 0.0085714285714285*G0_1_1_4_3 - 0.00857142857142851*G0_1_1_4_5 - 0.0364285714285713*G0_1_1_5_0 + 0.0128571428571428*G0_1_1_5_1 + 0.00428571428571427*G0_1_1_5_2 - 0.00857142857142851*G0_1_1_5_4 - 0.154285714285713*G0_1_1_5_5;
    A[28] = -A[29] - 0.00482142857142852*G0_1_0_0_0 + 0.000937499999999983*G0_1_0_0_1 - 0.00272321428571426*G0_1_0_0_2 - 0.00303571428571428*G0_1_0_0_3 - 0.0124999999999999*G0_1_0_0_4 + 0.00339285714285711*G0_1_0_0_5 + 0.000937499999999983*G0_1_0_1_0 - 0.0291964285714283*G0_1_0_1_1 + 0.00218749999999998*G0_1_0_1_2 + 0.0167857142857142*G0_1_0_1_3 + 0.00517857142857142*G0_1_0_1_4 - 0.00660714285714274*G0_1_0_1_5 - 0.00272321428571426*G0_1_0_2_0 + 0.00218749999999998*G0_1_0_2_1 - 0.0285714285714284*G0_1_0_2_3 + 0.0285714285714284*G0_1_0_2_4 + 0.000535714285714282*G0_1_0_2_5 - 0.00303571428571428*G0_1_0_3_0 + 0.0167857142857142*G0_1_0_3_1 - 0.0285714285714284*G0_1_0_3_2 + 0.0114285714285715*G0_1_0_3_3 - 0.00428571428571428*G0_1_0_3_4 + 0.00499999999999998*G0_1_0_3_5 - 0.0124999999999999*G0_1_0_4_0 + 0.00517857142857142*G0_1_0_4_1 + 0.0285714285714284*G0_1_0_4_2 - 0.00428571428571428*G0_1_0_4_3 - 0.00285714285714294*G0_1_0_4_4 - 0.0114285714285714*G0_1_0_4_5 + 0.00339285714285711*G0_1_0_5_0 - 0.00660714285714274*G0_1_0_5_1 + 0.000535714285714282*G0_1_0_5_2 + 0.00499999999999998*G0_1_0_5_3 - 0.0114285714285714*G0_1_0_5_4 + 0.0385714285714283*G0_1_0_5_5 + 0.0125892857142857*G0_1_1_0_0 - 0.00299107142857142*G0_1_1_0_1 + 0.00486607142857141*G0_1_1_0_2 + 0.00410714285714284*G0_1_1_0_4 + 0.0135714285714285*G0_1_1_0_5 - 0.00299107142857142*G0_1_1_1_0 - 0.0267857142857141*G0_1_1_1_1 + 0.00799107142857138*G0_1_1_1_2 + 0.0198214285714285*G0_1_1_1_3 + 0.0057142857142857*G0_1_1_1_4 - 0.00910714285714273*G0_1_1_1_5 + 0.00486607142857141*G0_1_1_2_0 + 0.00799107142857138*G0_1_1_2_1 - 0.0455357142857143*G0_1_1_2_2 - 0.0517857142857141*G0_1_1_2_3 - 0.0178571428571428*G0_1_1_2_4 - 0.00749999999999998*G0_1_1_2_5 + 0.0198214285714285*G0_1_1_3_1 - 0.051785714285714*G0_1_1_3_2 + 0.00428571428571432*G0_1_1_3_3 - 0.0114285714285714*G0_1_1_3_4 + 0.0149999999999999*G0_1_1_3_5 + 0.00410714285714284*G0_1_1_4_0 + 0.0057142857142857*G0_1_1_4_1 - 0.0178571428571428*G0_1_1_4_2 - 0.0114285714285714*G0_1_1_4_3 - 0.0242857142857143*G0_1_1_4_4 + 0.00357142857142851*G0_1_1_4_5 + 0.0135714285714285*G0_1_1_5_0 - 0.00910714285714273*G0_1_1_5_1 - 0.00749999999999998*G0_1_1_5_2 + 0.0149999999999999*G0_1_1_5_3 + 0.00357142857142851*G0_1_1_5_4 + 0.0942857142857137*G0_1_1_5_5;
    A[26] = -A[28] - 0.0117857142857142*G0_1_0_0_0 - 0.00183035714285714*G0_1_0_0_1 + 0.0209374999999999*G0_1_0_0_2 + 0.0119642857142856*G0_1_0_0_3 + 0.0224999999999999*G0_1_0_0_4 + 0.00642857142857141*G0_1_0_0_5 - 0.00183035714285714*G0_1_0_1_0 - 0.0286607142857141*G0_1_0_1_1 + 0.0204910714285713*G0_1_0_1_2 + 0.0175*G0_1_0_1_3 + 0.0116071428571428*G0_1_0_1_4 - 0.00571428571428563*G0_1_0_1_5 + 0.0209374999999999*G0_1_0_2_0 + 0.0204910714285713*G0_1_0_2_1 - 0.243749999999999*G0_1_0_2_2 - 0.0874999999999996*G0_1_0_2_3 - 0.0946428571428567*G0_1_0_2_4 - 0.00660714285714289*G0_1_0_2_5 + 0.0119642857142856*G0_1_0_3_0 + 0.0174999999999999*G0_1_0_3_1 - 0.0874999999999996*G0_1_0_3_2 - 0.0742857142857139*G0_1_0_3_3 - 0.0471428571428569*G0_1_0_3_4 - 0.0107142857142857*G0_1_0_3_5 + 0.0224999999999999*G0_1_0_4_0 + 0.0116071428571428*G0_1_0_4_1 - 0.0946428571428567*G0_1_0_4_2 - 0.0471428571428569*G0_1_0_4_3 - 0.0885714285714282*G0_1_0_4_4 - 0.01*G0_1_0_4_5 + 0.00642857142857141*G0_1_0_5_0 - 0.00571428571428563*G0_1_0_5_1 - 0.00660714285714289*G0_1_0_5_2 - 0.0107142857142857*G0_1_0_5_3 - 0.01*G0_1_0_5_4 + 0.0399999999999998*G0_1_0_5_5 - 0.0198214285714285*G0_1_1_0_0 + 0.00486607142857139*G0_1_1_0_1 + 0.0126339285714285*G0_1_1_0_2 + 0.00553571428571424*G0_1_1_0_3 - 0.00321428571428571*G0_1_1_0_5 + 0.00486607142857139*G0_1_1_1_0 - 0.0404464285714283*G0_1_1_1_1 + 0.0148660714285713*G0_1_1_1_2 + 0.0121428571428571*G0_1_1_1_3 + 0.00946428571428568*G0_1_1_1_4 - 0.0142857142857142*G0_1_1_1_5 + 0.0126339285714285*G0_1_1_2_0 + 0.0148660714285713*G0_1_1_2_1 - 0.190178571428571*G0_1_1_2_2 - 0.0660714285714283*G0_1_1_2_3 - 0.0410714285714284*G0_1_1_2_4 + 0.00196428571428565*G0_1_1_2_5 + 0.00553571428571424*G0_1_1_3_0 + 0.0121428571428571*G0_1_1_3_1 - 0.0660714285714283*G0_1_1_3_2 - 0.0485714285714283*G0_1_1_3_3 - 0.0299999999999999*G0_1_1_3_4 - 0.0149999999999999*G0_1_1_3_5 + 0.00946428571428568*G0_1_1_4_1 - 0.0410714285714284*G0_1_1_4_2 - 0.0299999999999999*G0_1_1_4_3 - 0.0628571428571426*G0_1_1_4_4 - 0.0228571428571428*G0_1_1_4_5 - 0.00321428571428571*G0_1_1_5_0 - 0.0142857142857142*G0_1_1_5_1 + 0.00196428571428565*G0_1_1_5_2 - 0.0149999999999999*G0_1_1_5_3 - 0.0228571428571428*G0_1_1_5_4 - 0.088571428571428*G0_1_1_5_5;
    A[27] = A[28] + 0.0340178571428569*G0_1_0_0_0 - 0.00187499999999997*G0_1_0_0_1 + 0.000535714285714278*G0_1_0_0_2 - 0.00214285714285713*G0_1_0_0_3 - 0.0042857142857143*G0_1_0_0_4 + 0.00321428571428567*G0_1_0_0_5 - 0.00187499999999997*G0_1_0_1_0 + 0.0340178571428569*G0_1_0_1_1 + 0.000535714285714283*G0_1_0_1_2 - 0.00428571428571431*G0_1_0_1_3 - 0.00214285714285714*G0_1_0_1_4 + 0.00321428571428565*G0_1_0_1_5 + 0.000535714285714277*G0_1_0_2_0 + 0.000535714285714283*G0_1_0_2_1 - 0.00107142857142858*G0_1_0_2_5 - 0.00214285714285713*G0_1_0_3_0 - 0.00428571428571431*G0_1_0_3_1 - 0.00857142857142852*G0_1_0_3_3 + 0.00857142857142855*G0_1_0_3_4 + 0.00642857142857142*G0_1_0_3_5 - 0.0042857142857143*G0_1_0_4_0 - 0.00214285714285714*G0_1_0_4_1 + 0.00857142857142855*G0_1_0_4_3 - 0.0085714285714285*G0_1_0_4_4 + 0.00642857142857143*G0_1_0_4_5 + 0.00321428571428567*G0_1_0_5_0 + 0.00321428571428565*G0_1_0_5_1 - 0.00107142857142857*G0_1_0_5_2 + 0.00642857142857143*G0_1_0_5_3 + 0.00642857142857143*G0_1_0_5_4 - 0.0771428571428566*G0_1_0_5_5 - 0.0101785714285714*G0_1_1_0_0 - 0.000937499999999982*G0_1_1_0_1 + 0.000937499999999975*G0_1_1_0_2 + 0.000535714285714289*G0_1_1_0_3 - 0.00107142857142856*G0_1_1_0_4 - 0.0160714285714284*G0_1_1_0_5 - 0.000937499999999981*G0_1_1_1_0 + 0.0441964285714282*G0_1_1_1_1 - 0.000401785714285703*G0_1_1_1_2 - 0.00321428571428575*G0_1_1_1_3 - 0.00267857142857143*G0_1_1_1_4 + 0.0192857142857141*G0_1_1_1_5 + 0.000937499999999975*G0_1_1_2_0 - 0.000401785714285702*G0_1_1_2_1 + 0.00535714285714285*G0_1_1_2_3 - 0.00535714285714277*G0_1_1_2_4 - 0.000535714285714285*G0_1_1_2_5 + 0.000535714285714289*G0_1_1_3_0 - 0.00321428571428575*G0_1_1_3_1 + 0.00535714285714285*G0_1_1_3_2 - 0.0257142857142857*G0_1_1_3_3 + 0.00428571428571428*G0_1_1_3_4 - 0.00107142857142856*G0_1_1_4_0 - 0.00267857142857143*G0_1_1_4_1 - 0.00535714285714277*G0_1_1_4_2 + 0.00428571428571428*G0_1_1_4_3 + 0.0171428571428572*G0_1_1_4_4 + 0.00642857142857144*G0_1_1_4_5 - 0.0160714285714284*G0_1_1_5_0 + 0.0192857142857141*G0_1_1_5_1 - 0.000535714285714285*G0_1_1_5_2 + 0.00642857142857144*G0_1_1_5_4 - 0.0385714285714283*G0_1_1_5_5;
    A[23] = -A[28] - 0.0109821428571428*G0_1_0_0_0 + 0.00709821428571424*G0_1_0_0_2 + 0.00874999999999995*G0_1_0_0_3 + 0.0167857142857142*G0_1_0_0_4 + 0.00785714285714283*G0_1_0_0_5 - 0.0241071428571427*G0_1_0_1_1 + 0.00397321428571427*G0_1_0_1_2 - 0.00535714285714281*G0_1_0_1_3 + 0.00410714285714283*G0_1_0_1_4 - 0.0053571428571428*G0_1_0_1_5 + 0.00709821428571424*G0_1_0_2_0 + 0.00397321428571427*G0_1_0_2_1 - 0.0937499999999997*G0_1_0_2_2 - 0.00178571428571431*G0_1_0_2_3 - 0.0410714285714284*G0_1_0_2_4 + 0.00232142857142855*G0_1_0_2_5 + 0.00874999999999995*G0_1_0_3_0 - 0.00535714285714281*G0_1_0_3_1 - 0.00178571428571431*G0_1_0_3_2 - 0.0314285714285713*G0_1_0_3_3 - 0.0257142857142856*G0_1_0_3_4 - 0.0221428571428571*G0_1_0_3_5 + 0.0167857142857142*G0_1_0_4_0 + 0.00410714285714283*G0_1_0_4_1 - 0.0410714285714284*G0_1_0_4_2 - 0.0257142857142856*G0_1_0_4_3 - 0.0457142857142855*G0_1_0_4_4 - 0.0128571428571428*G0_1_0_4_5 + 0.00785714285714283*G0_1_0_5_0 - 0.0053571428571428*G0_1_0_5_1 + 0.00232142857142855*G0_1_0_5_2 - 0.0221428571428571*G0_1_0_5_3 - 0.0128571428571428*G0_1_0_5_4 + 0.0328571428571426*G0_1_0_5_5;
    A[25] = -A[23] - 0.00374999999999998*G0_1_0_0_0 + 0.00267857142857141*G0_1_0_0_2 + 0.00428571428571427*G0_1_0_0_3 + 0.0171428571428571*G0_1_0_0_4 + 0.00107142857142858*G0_1_0_0_5 + 0.00374999999999993*G0_1_0_1_1 - 0.0026785714285714*G0_1_0_1_2 - 0.0171428571428571*G0_1_0_1_3 - 0.00428571428571428*G0_1_0_1_4 - 0.0010714285714286*G0_1_0_1_5 + 0.00267857142857141*G0_1_0_2_0 - 0.0026785714285714*G0_1_0_2_1 + 0.032142857142857*G0_1_0_2_3 - 0.032142857142857*G0_1_0_2_4 + 0.00428571428571427*G0_1_0_3_0 - 0.0171428571428571*G0_1_0_3_1 + 0.032142857142857*G0_1_0_3_2 - 0.00857142857142854*G0_1_0_3_5 + 0.0171428571428571*G0_1_0_4_0 - 0.00428571428571428*G0_1_0_4_1 - 0.032142857142857*G0_1_0_4_2 + 0.00857142857142855*G0_1_0_4_5 + 0.00107142857142858*G0_1_0_5_0 - 0.0010714285714286*G0_1_0_5_1 - 0.00857142857142854*G0_1_0_5_3 + 0.00857142857142855*G0_1_0_5_4 + 0.0326785714285712*G0_1_1_0_0 - 0.00642857142857138*G0_1_1_0_1 - 0.00339285714285713*G0_1_1_0_2 - 0.000357142857142843*G0_1_1_0_3 + 0.00892857142857137*G0_1_1_0_4 + 0.0114285714285714*G0_1_1_0_5 - 0.00642857142857138*G0_1_1_1_0 + 0.0364285714285712*G0_1_1_1_1 - 0.00607142857142853*G0_1_1_1_2 - 0.0082142857142857*G0_1_1_1_3 - 0.00464285714285712*G0_1_1_1_4 + 0.0103571428571428*G0_1_1_1_5 - 0.00339285714285713*G0_1_1_2_0 - 0.00607142857142853*G0_1_1_2_1 + 0.0776785714285713*G0_1_1_2_2 + 0.032142857142857*G0_1_1_2_3 - 0.00392857142857138*G0_1_1_2_5 - 0.000357142857142843*G0_1_1_3_0 - 0.0082142857142857*G0_1_1_3_1 + 0.032142857142857*G0_1_1_3_2 + 0.0114285714285713*G0_1_1_3_3 + 0.00999999999999995*G0_1_1_3_4 + 0.0085714285714285*G0_1_1_3_5 + 0.00892857142857137*G0_1_1_4_0 - 0.00464285714285712*G0_1_1_4_1 + 0.00999999999999995*G0_1_1_4_3 + 0.0114285714285714*G0_1_1_4_4 + 0.0171428571428571*G0_1_1_4_5 + 0.0114285714285714*G0_1_1_5_0 + 0.0103571428571428*G0_1_1_5_1 - 0.00392857142857138*G0_1_1_5_2 + 0.0085714285714285*G0_1_1_5_3 + 0.0171428571428571*G0_1_1_5_4 + 0.0742857142857138*G0_1_1_5_5;
    A[24] = -A[26] - 0.0230357142857142*G0_1_1_0_0 + 0.00508928571428568*G0_1_1_0_1 + 0.00758928571428567*G0_1_1_0_2 + 0.00714285714285709*G0_1_1_0_3 - 0.00178571428571429*G0_1_1_0_4 - 0.00571428571428568*G0_1_1_0_5 + 0.00508928571428568*G0_1_1_1_0 - 0.0230357142857141*G0_1_1_1_1 + 0.00758928571428567*G0_1_1_1_2 - 0.00178571428571428*G0_1_1_1_3 + 0.00714285714285711*G0_1_1_1_4 - 0.00571428571428567*G0_1_1_1_5 + 0.00758928571428567*G0_1_1_2_0 + 0.00758928571428566*G0_1_1_2_1 - 0.152678571428571*G0_1_1_2_2 - 0.0214285714285713*G0_1_1_2_3 - 0.0214285714285713*G0_1_1_2_4 + 0.00892857142857136*G0_1_1_2_5 + 0.00714285714285709*G0_1_1_3_0 - 0.00178571428571428*G0_1_1_3_1 - 0.0214285714285713*G0_1_1_3_2 - 0.0571428571428568*G0_1_1_3_3 - 0.0285714285714284*G0_1_1_3_4 - 0.032142857142857*G0_1_1_3_5 - 0.00178571428571429*G0_1_1_4_0 + 0.00714285714285711*G0_1_1_4_1 - 0.0214285714285713*G0_1_1_4_2 - 0.0285714285714284*G0_1_1_4_3 - 0.0571428571428569*G0_1_1_4_4 - 0.032142857142857*G0_1_1_4_5 - 0.00571428571428568*G0_1_1_5_0 - 0.00571428571428567*G0_1_1_5_1 + 0.00892857142857136*G0_1_1_5_2 - 0.032142857142857*G0_1_1_5_3 - 0.032142857142857*G0_1_1_5_4 - 0.109999999999999*G0_1_1_5_5;
    A[49] = -A[69] - 0.01125*G0_1_0_0_0 - 0.00803571428571426*G0_1_0_0_2 + 0.0449999999999998*G0_1_0_0_3 + 0.0192857142857143*G0_1_0_0_4 + 0.00321428571428575*G0_1_0_0_5 + 0.0112499999999997*G0_1_0_1_1 + 0.00803571428571429*G0_1_0_1_2 - 0.0192857142857143*G0_1_0_1_3 - 0.0449999999999998*G0_1_0_1_4 - 0.00321428571428584*G0_1_0_1_5 - 0.00803571428571426*G0_1_0_2_0 + 0.00803571428571429*G0_1_0_2_1 + 0.032142857142857*G0_1_0_2_3 - 0.032142857142857*G0_1_0_2_4 + 0.0449999999999998*G0_1_0_3_0 - 0.0192857142857143*G0_1_0_3_1 + 0.032142857142857*G0_1_0_3_2 - 0.64285714285714*G0_1_0_3_3 - 0.0899999999999999*G0_1_0_3_5 + 0.0192857142857143*G0_1_0_4_0 - 0.0449999999999998*G0_1_0_4_1 - 0.032142857142857*G0_1_0_4_2 + 0.64285714285714*G0_1_0_4_4 + 0.0899999999999996*G0_1_0_4_5 + 0.00321428571428576*G0_1_0_5_0 - 0.00321428571428584*G0_1_0_5_1 - 0.0899999999999999*G0_1_0_5_3 + 0.0899999999999996*G0_1_0_5_4 - 0.0674999999999999*G0_1_1_0_0 + 0.0200892857142856*G0_1_1_0_1 - 0.000803571428571413*G0_1_1_0_2 + 0.0578571428571425*G0_1_1_0_3 + 0.0160714285714285*G0_1_1_0_4 - 0.0257142857142857*G0_1_1_0_5 + 0.0200892857142856*G0_1_1_1_0 - 0.0562499999999999*G0_1_1_1_1 + 0.00723214285714286*G0_1_1_1_2 - 0.00321428571428575*G0_1_1_1_3 + 0.0128571428571428*G0_1_1_1_4 - 0.0289285714285714*G0_1_1_1_5 - 0.000803571428571412*G0_1_1_2_0 + 0.00723214285714286*G0_1_1_2_1 + 0.0321428571428571*G0_1_1_2_2 + 0.032142857142857*G0_1_1_2_3 + 0.0257142857142856*G0_1_1_2_5 + 0.0578571428571425*G0_1_1_3_0 - 0.00321428571428576*G0_1_1_3_1 + 0.032142857142857*G0_1_1_3_2 - 0.694285714285712*G0_1_1_3_3 - 0.141428571428571*G0_1_1_3_4 - 0.167142857142857*G0_1_1_3_5 + 0.0160714285714285*G0_1_1_4_0 + 0.0128571428571428*G0_1_1_4_1 - 0.141428571428571*G0_1_1_4_3 - 0.0514285714285713*G0_1_1_4_4 - 0.0771428571428568*G0_1_1_4_5 - 0.0257142857142857*G0_1_1_5_0 - 0.0289285714285714*G0_1_1_5_1 + 0.0257142857142856*G0_1_1_5_2 - 0.167142857142857*G0_1_1_5_3 - 0.0771428571428568*G0_1_1_5_4 - 0.64285714285714*G0_1_1_5_5;
    A[94] = A[49] + 0.00482142857142857*G0_0_1_0_0 + 0.000803571428571439*G0_0_1_0_1 - 0.0152678571428571*G0_0_1_0_2 + 0.0192857142857141*G0_0_1_0_3 - 0.0128571428571428*G0_0_1_0_4 + 0.00321428571428573*G0_0_1_0_5 + 0.000803571428571439*G0_0_1_1_0 + 0.0160714285714283*G0_0_1_1_1 - 0.00723214285714283*G0_0_1_1_2 - 0.0321428571428572*G0_0_1_1_3 - 0.0257142857142856*G0_0_1_1_4 - 0.0152678571428571*G0_0_1_2_0 - 0.00723214285714283*G0_0_1_2_1 + 0.0803571428571427*G0_0_1_2_2 + 0.0803571428571426*G0_0_1_2_3 + 0.0482142857142856*G0_0_1_2_4 + 0.00642857142857145*G0_0_1_2_5 + 0.0192857142857141*G0_0_1_3_0 - 0.0321428571428572*G0_0_1_3_1 + 0.0803571428571426*G0_0_1_3_2 - 0.46285714285714*G0_0_1_3_3 + 0.0128571428571429*G0_0_1_3_4 - 0.0514285714285712*G0_0_1_3_5 - 0.0128571428571428*G0_0_1_4_0 - 0.0257142857142856*G0_0_1_4_1 + 0.0482142857142856*G0_0_1_4_2 + 0.0128571428571429*G0_0_1_4_3 + 0.179999999999999*G0_0_1_4_4 + 0.0385714285714284*G0_0_1_4_5 + 0.00321428571428573*G0_0_1_5_0 + 0.00642857142857145*G0_0_1_5_2 - 0.0514285714285712*G0_0_1_5_3 + 0.0385714285714284*G0_0_1_5_4 + 0.0514285714285713*G0_0_1_5_5 - 0.00482142857142856*G0_1_0_0_0 - 0.000803571428571439*G0_1_0_0_1 + 0.0152678571428571*G0_1_0_0_2 - 0.0192857142857141*G0_1_0_0_3 + 0.0128571428571428*G0_1_0_0_4 - 0.00321428571428573*G0_1_0_0_5 - 0.000803571428571438*G0_1_0_1_0 - 0.0160714285714283*G0_1_0_1_1 + 0.00723214285714283*G0_1_0_1_2 + 0.0321428571428571*G0_1_0_1_3 + 0.0257142857142856*G0_1_0_1_4 + 0.0152678571428571*G0_1_0_2_0 + 0.00723214285714283*G0_1_0_2_1 - 0.0803571428571427*G0_1_0_2_2 - 0.0803571428571426*G0_1_0_2_3 - 0.0482142857142856*G0_1_0_2_4 - 0.00642857142857145*G0_1_0_2_5 - 0.0192857142857141*G0_1_0_3_0 + 0.0321428571428572*G0_1_0_3_1 - 0.0803571428571426*G0_1_0_3_2 + 0.46285714285714*G0_1_0_3_3 - 0.0128571428571429*G0_1_0_3_4 + 0.0514285714285712*G0_1_0_3_5 + 0.0128571428571428*G0_1_0_4_0 + 0.0257142857142856*G0_1_0_4_1 - 0.0482142857142856*G0_1_0_4_2 - 0.0128571428571429*G0_1_0_4_3 - 0.179999999999999*G0_1_0_4_4 - 0.0385714285714284*G0_1_0_4_5 - 0.00321428571428573*G0_1_0_5_0 - 0.00642857142857145*G0_1_0_5_2 + 0.0514285714285712*G0_1_0_5_3 - 0.0385714285714284*G0_1_0_5_4 - 0.0514285714285713*G0_1_0_5_5;
    A[97] = A[49] + 0.0899999999999997*G0_0_0_0_0 - 0.00562500000000001*G0_0_0_0_1 - 0.00723214285714285*G0_0_0_0_2 + 0.00642857142857136*G0_0_0_0_3 + 0.128571428571428*G0_0_0_0_4 + 0.0289285714285713*G0_0_0_0_5 - 0.00562500000000001*G0_0_0_1_0 - 0.0482142857142853*G0_0_0_1_1 + 0.00562499999999997*G0_0_0_1_2 - 0.0835714285714281*G0_0_0_1_3 - 0.0128571428571428*G0_0_0_1_5 - 0.00723214285714285*G0_0_0_2_0 + 0.00562499999999997*G0_0_0_2_1 - 0.00803571428571416*G0_0_0_2_2 + 0.0674999999999996*G0_0_0_2_3 - 0.0996428571428566*G0_0_0_2_4 - 0.00642857142857142*G0_0_0_2_5 + 0.00642857142857136*G0_0_0_3_0 - 0.0835714285714281*G0_0_0_3_1 + 0.0674999999999996*G0_0_0_3_2 - 0.0257142857142848*G0_0_0_3_3 - 0.0128571428571427*G0_0_0_3_4 + 0.128571428571428*G0_0_0_4_0 - 0.0996428571428566*G0_0_0_4_2 - 0.0128571428571427*G0_0_0_4_3 - 0.0771428571428566*G0_0_0_4_4 + 0.0128571428571429*G0_0_0_4_5 + 0.0289285714285713*G0_0_0_5_0 - 0.0128571428571428*G0_0_0_5_1 - 0.00642857142857142*G0_0_0_5_2 + 0.0128571428571429*G0_0_0_5_4 + 0.0257142857142857*G0_0_0_5_5 - 0.0144642857142856*G0_0_1_0_0 + 0.0120535714285714*G0_0_1_0_1 - 0.00723214285714281*G0_0_1_0_2 - 0.0192857142857143*G0_0_1_0_3 - 0.0385714285714285*G0_0_1_0_4 - 0.0289285714285713*G0_0_1_0_5 + 0.0120535714285714*G0_0_1_1_0 - 0.0482142857142853*G0_0_1_1_1 - 0.0120535714285714*G0_0_1_1_2 - 0.096428571428571*G0_0_1_1_3 - 0.00723214285714281*G0_0_1_2_0 - 0.0120535714285714*G0_0_1_2_1 + 0.0964285714285712*G0_0_1_2_2 + 0.125357142857142*G0_0_1_2_3 + 0.0674999999999998*G0_0_1_2_4 + 0.0192857142857142*G0_0_1_2_5 - 0.0192857142857143*G0_0_1_3_0 - 0.096428571428571*G0_0_1_3_1 + 0.125357142857142*G0_0_1_3_2 + 0.0385714285714286*G0_0_1_3_4 - 0.0385714285714285*G0_0_1_4_0 + 0.0674999999999998*G0_0_1_4_2 + 0.0385714285714286*G0_0_1_4_3 - 0.0771428571428566*G0_0_1_4_4 - 0.0385714285714284*G0_0_1_4_5 - 0.0289285714285713*G0_0_1_5_0 + 0.0192857142857142*G0_0_1_5_2 - 0.0385714285714284*G0_0_1_5_4 + 0.0610714285714286*G0_1_0_0_0 + 0.00401785714285707*G0_1_0_0_1 - 0.00723214285714283*G0_1_0_0_2 - 0.0321428571428569*G0_1_0_0_3 + 0.0225*G0_1_0_0_4 + 0.0482142857142855*G0_1_0_0_5 + 0.00401785714285707*G0_1_0_1_0 - 0.0482142857142852*G0_1_0_1_1 - 0.00401785714285715*G0_1_0_1_2 - 0.0642857142857138*G0_1_0_1_3 - 0.0321428571428569*G0_1_0_1_5 - 0.00723214285714283*G0_1_0_2_0 - 0.00401785714285714*G0_1_0_2_1 + 0.020892857142857*G0_1_0_2_2 + 0.0482142857142853*G0_1_0_2_3 + 0.00642857142857138*G0_1_0_2_4 + 0.032142857142857*G0_1_0_2_5 - 0.0321428571428569*G0_1_0_3_0 - 0.0642857142857138*G0_1_0_3_1 + 0.0482142857142853*G0_1_0_3_2 + 0.514285714285712*G0_1_0_3_3 + 0.0642857142857141*G0_1_0_3_4 + 0.0225*G0_1_0_4_0 + 0.00642857142857139*G0_1_0_4_2 + 0.0642857142857141*G0_1_0_4_3 - 0.0771428571428566*G0_1_0_4_4 - 0.064285714285714*G0_1_0_4_5 + 0.0482142857142855*G0_1_0_5_0 - 0.0321428571428569*G0_1_0_5_1 + 0.032142857142857*G0_1_0_5_2 - 0.064285714285714*G0_1_0_5_4 - 0.514285714285712*G0_1_0_5_5 - 0.0353571428571428*G0_1_1_0_0 + 0.0160714285714285*G0_1_1_0_1 - 0.0514285714285712*G0_1_1_0_3 - 0.0449999999999998*G0_1_1_0_4 - 0.0771428571428568*G0_1_1_0_5 + 0.0160714285714285*G0_1_1_1_0 - 0.0160714285714285*G0_1_1_1_2 - 0.0642857142857139*G0_1_1_1_3 + 0.064285714285714*G0_1_1_1_5 - 0.0160714285714285*G0_1_1_2_1 + 0.0353571428571427*G0_1_1_2_2 + 0.0771428571428568*G0_1_1_2_3 + 0.0449999999999998*G0_1_1_2_4 + 0.0514285714285713*G0_1_1_2_5 - 0.0514285714285712*G0_1_1_3_0 - 0.0642857142857139*G0_1_1_3_1 + 0.0771428571428568*G0_1_1_3_2 + 0.514285714285712*G0_1_1_3_3 + 0.102857142857142*G0_1_1_3_4 - 0.0449999999999998*G0_1_1_4_0 + 0.0449999999999998*G0_1_1_4_2 + 0.102857142857143*G0_1_1_4_3 - 0.102857142857142*G0_1_1_4_5 - 0.0771428571428568*G0_1_1_5_0 + 0.064285714285714*G0_1_1_5_1 + 0.0514285714285713*G0_1_1_5_2 - 0.102857142857142*G0_1_1_5_4 - 0.514285714285712*G0_1_1_5_5;
    A[90] = -A[97] + 0.0348214285714285*G0_0_0_0_0 - 0.00696428571428569*G0_0_0_0_2 + 0.00428571428571424*G0_0_0_0_3 + 0.0364285714285713*G0_0_0_0_4 + 0.00107142857142857*G0_0_0_0_5 - 0.0348214285714283*G0_0_0_1_1 + 0.00696428571428567*G0_0_0_1_2 - 0.0364285714285712*G0_0_0_1_3 - 0.00428571428571427*G0_0_0_1_4 - 0.00107142857142856*G0_0_0_1_5 - 0.00696428571428569*G0_0_0_2_0 + 0.00696428571428567*G0_0_0_2_1 + 0.0128571428571428*G0_0_0_2_3 - 0.0128571428571428*G0_0_0_2_4 + 0.00428571428571424*G0_0_0_3_0 - 0.0364285714285712*G0_0_0_3_1 + 0.0128571428571428*G0_0_0_3_2 - 0.154285714285713*G0_0_0_3_3 - 0.00857142857142853*G0_0_0_3_5 + 0.0364285714285713*G0_0_0_4_0 - 0.00428571428571427*G0_0_0_4_1 - 0.0128571428571428*G0_0_0_4_2 + 0.154285714285714*G0_0_0_4_4 + 0.00857142857142857*G0_0_0_4_5 + 0.00107142857142857*G0_0_0_5_0 - 0.00107142857142856*G0_0_0_5_1 - 0.00857142857142853*G0_0_0_5_3 + 0.00857142857142857*G0_0_0_5_4 - 0.0776785714285712*G0_0_1_0_0 + 0.0136607142857142*G0_0_1_0_1 + 0.0147321428571428*G0_0_1_0_2 + 0.00107142857142851*G0_0_1_0_3 - 0.0760714285714283*G0_0_1_0_4 - 0.047142857142857*G0_0_1_0_5 + 0.0136607142857142*G0_0_1_1_0 - 0.0444642857142854*G0_0_1_1_1 + 0.00294642857142854*G0_0_1_1_2 - 0.0332142857142856*G0_0_1_1_3 + 0.024642857142857*G0_0_1_1_4 + 0.0149999999999999*G0_0_1_1_5 + 0.0147321428571428*G0_0_1_2_0 + 0.00294642857142854*G0_0_1_2_1 - 0.00803571428571421*G0_0_1_2_2 + 0.0225*G0_0_1_2_3 + 0.0417857142857142*G0_0_1_2_4 + 0.0224999999999999*G0_0_1_2_5 + 0.00107142857142851*G0_0_1_3_0 - 0.0332142857142856*G0_0_1_3_1 + 0.0225*G0_0_1_3_2 - 0.218571428571427*G0_0_1_3_3 - 0.0514285714285712*G0_0_1_3_4 - 0.047142857142857*G0_0_1_3_5 - 0.0760714285714283*G0_0_1_4_0 + 0.024642857142857*G0_0_1_4_1 + 0.0417857142857142*G0_0_1_4_2 - 0.0514285714285712*G0_0_1_4_3 - 0.192857142857142*G0_0_1_4_4 - 0.094285714285714*G0_0_1_4_5 - 0.047142857142857*G0_0_1_5_0 + 0.0149999999999999*G0_0_1_5_1 + 0.0224999999999999*G0_0_1_5_2 - 0.047142857142857*G0_0_1_5_3 - 0.094285714285714*G0_0_1_5_4 - 0.0899999999999996*G0_0_1_5_5 + 0.00267857142857147*G0_1_0_0_0 + 0.00910714285714281*G0_1_0_0_1 - 0.0032142857142857*G0_1_0_0_2 + 0.00749999999999994*G0_1_0_0_3 + 0.00428571428571428*G0_1_0_0_4 + 0.00107142857142854*G0_1_0_0_5 + 0.00910714285714281*G0_1_0_1_0 - 0.0321428571428569*G0_1_0_1_1 + 0.00374999999999997*G0_1_0_1_2 - 0.0321428571428569*G0_1_0_1_3 + 0.0032142857142857*G0_1_0_1_4 - 0.0032142857142857*G0_1_0_2_0 + 0.00374999999999997*G0_1_0_2_1 + 0.000535714285714306*G0_1_0_2_2 + 0.024642857142857*G0_1_0_2_3 + 0.0117857142857142*G0_1_0_2_4 + 0.0374999999999999*G0_1_0_2_5 + 0.00749999999999994*G0_1_0_3_0 - 0.0321428571428569*G0_1_0_3_1 + 0.024642857142857*G0_1_0_3_2 - 0.167142857142856*G0_1_0_3_3 - 0.0214285714285713*G0_1_0_3_4 - 0.0899999999999996*G0_1_0_3_5 + 0.00428571428571428*G0_1_0_4_0 + 0.0032142857142857*G0_1_0_4_1 + 0.0117857142857142*G0_1_0_4_2 - 0.0214285714285713*G0_1_0_4_3 - 0.0128571428571428*G0_1_0_4_4 - 0.0814285714285711*G0_1_0_4_5 + 0.00107142857142854*G0_1_0_5_0 + 0.0374999999999999*G0_1_0_5_2 - 0.0899999999999996*G0_1_0_5_3 - 0.0814285714285711*G0_1_0_5_4 - 0.55285714285714*G0_1_0_5_5 - 0.109821428571428*G0_1_1_0_0 + 0.0308035714285713*G0_1_1_0_1 + 0.0104464285714286*G0_1_1_0_2 + 0.00428571428571423*G0_1_1_0_3 - 0.0439285714285713*G0_1_1_0_4 - 0.111428571428571*G0_1_1_0_5 + 0.0308035714285713*G0_1_1_1_0 - 0.0401785714285712*G0_1_1_1_1 - 0.000267857142857152*G0_1_1_1_2 - 0.0224999999999999*G0_1_1_1_3 + 0.0257142857142856*G0_1_1_1_4 + 0.0546428571428568*G0_1_1_1_5 + 0.0104464285714286*G0_1_1_2_0 - 0.000267857142857152*G0_1_1_2_1 - 0.00910714285714279*G0_1_1_2_2 + 0.0278571428571428*G0_1_1_2_3 + 0.0278571428571428*G0_1_1_2_4 + 0.0664285714285712*G0_1_1_2_5 + 0.00428571428571422*G0_1_1_3_0 - 0.0224999999999999*G0_1_1_3_1 + 0.0278571428571428*G0_1_1_3_2 - 0.23142857142857*G0_1_1_3_3 - 0.0599999999999998*G0_1_1_3_4 - 0.141428571428571*G0_1_1_3_5 - 0.0439285714285713*G0_1_1_4_0 + 0.0257142857142856*G0_1_1_4_1 + 0.0278571428571428*G0_1_1_4_2 - 0.0599999999999998*G0_1_1_4_3 - 0.102857142857143*G0_1_1_4_4 - 0.184285714285714*G0_1_1_4_5 - 0.111428571428571*G0_1_1_5_0 + 0.0546428571428568*G0_1_1_5_1 + 0.0664285714285712*G0_1_1_5_2 - 0.141428571428571*G0_1_1_5_3 - 0.184285714285714*G0_1_1_5_4 - 0.899999999999996*G0_1_1_5_5;
    A[96] = -A[94] - 0.01125*G0_0_1_0_0 - 0.00803571428571426*G0_0_1_0_2 + 0.0449999999999998*G0_0_1_0_3 + 0.0192857142857143*G0_0_1_0_4 + 0.00321428571428576*G0_0_1_0_5 + 0.0112499999999997*G0_0_1_1_1 + 0.00803571428571429*G0_0_1_1_2 - 0.0192857142857143*G0_0_1_1_3 - 0.0449999999999998*G0_0_1_1_4 - 0.00321428571428584*G0_0_1_1_5 - 0.00803571428571426*G0_0_1_2_0 + 0.00803571428571429*G0_0_1_2_1 + 0.032142857142857*G0_0_1_2_3 - 0.032142857142857*G0_0_1_2_4 + 0.0449999999999998*G0_0_1_3_0 - 0.0192857142857143*G0_0_1_3_1 + 0.032142857142857*G0_0_1_3_2 - 0.64285714285714*G0_0_1_3_3 - 0.0899999999999999*G0_0_1_3_5 + 0.0192857142857143*G0_0_1_4_0 - 0.0449999999999998*G0_0_1_4_1 - 0.032142857142857*G0_0_1_4_2 + 0.64285714285714*G0_0_1_4_4 + 0.0899999999999996*G0_0_1_4_5 + 0.00321428571428576*G0_0_1_5_0 - 0.00321428571428584*G0_0_1_5_1 - 0.0899999999999999*G0_0_1_5_3 + 0.0899999999999996*G0_0_1_5_4 - 0.0674999999999999*G0_1_1_0_0 + 0.0200892857142856*G0_1_1_0_1 - 0.000803571428571413*G0_1_1_0_2 + 0.0578571428571425*G0_1_1_0_3 + 0.0160714285714285*G0_1_1_0_4 - 0.0257142857142857*G0_1_1_0_5 + 0.0200892857142856*G0_1_1_1_0 - 0.0562499999999999*G0_1_1_1_1 + 0.00723214285714286*G0_1_1_1_2 - 0.00321428571428575*G0_1_1_1_3 + 0.0128571428571428*G0_1_1_1_4 - 0.0289285714285714*G0_1_1_1_5 - 0.000803571428571412*G0_1_1_2_0 + 0.00723214285714286*G0_1_1_2_1 + 0.0321428571428571*G0_1_1_2_2 + 0.032142857142857*G0_1_1_2_3 + 0.0257142857142856*G0_1_1_2_5 + 0.0578571428571425*G0_1_1_3_0 - 0.00321428571428576*G0_1_1_3_1 + 0.032142857142857*G0_1_1_3_2 - 0.694285714285712*G0_1_1_3_3 - 0.141428571428571*G0_1_1_3_4 - 0.167142857142857*G0_1_1_3_5 + 0.0160714285714285*G0_1_1_4_0 + 0.0128571428571428*G0_1_1_4_1 - 0.141428571428571*G0_1_1_4_3 - 0.0514285714285713*G0_1_1_4_4 - 0.0771428571428568*G0_1_1_4_5 - 0.0257142857142857*G0_1_1_5_0 - 0.0289285714285714*G0_1_1_5_1 + 0.0257142857142856*G0_1_1_5_2 - 0.167142857142857*G0_1_1_5_3 - 0.0771428571428568*G0_1_1_5_4 - 0.64285714285714*G0_1_1_5_5;
    A[89] = A[96] - 0.0482142857142855*G0_0_0_0_0 - 0.00562499999999993*G0_0_0_0_1 + 0.00562499999999997*G0_0_0_0_2 - 0.0835714285714282*G0_0_0_0_4 - 0.0128571428571428*G0_0_0_0_5 - 0.00562499999999993*G0_0_0_1_0 + 0.0899999999999993*G0_0_0_1_1 - 0.00723214285714283*G0_0_0_1_2 + 0.128571428571428*G0_0_0_1_3 + 0.00642857142857142*G0_0_0_1_4 + 0.0289285714285713*G0_0_0_1_5 + 0.00562499999999997*G0_0_0_2_0 - 0.00723214285714283*G0_0_0_2_1 - 0.0080357142857143*G0_0_0_2_2 - 0.0996428571428565*G0_0_0_2_3 + 0.0674999999999996*G0_0_0_2_4 - 0.0064285714285714*G0_0_0_2_5 + 0.128571428571428*G0_0_0_3_1 - 0.0996428571428565*G0_0_0_3_2 - 0.0771428571428567*G0_0_0_3_3 - 0.0128571428571428*G0_0_0_3_4 + 0.0128571428571428*G0_0_0_3_5 - 0.0835714285714282*G0_0_0_4_0 + 0.00642857142857142*G0_0_0_4_1 + 0.0674999999999997*G0_0_0_4_2 - 0.0128571428571428*G0_0_0_4_3 - 0.0257142857142856*G0_0_0_4_4 - 0.0128571428571428*G0_0_0_5_0 + 0.0289285714285713*G0_0_0_5_1 - 0.0064285714285714*G0_0_0_5_2 + 0.0128571428571428*G0_0_0_5_3 + 0.0257142857142855*G0_0_0_5_5 - 0.00964285714285707*G0_0_1_0_1 + 0.00964285714285709*G0_0_1_0_2 - 0.0192857142857143*G0_0_1_0_4 + 0.0192857142857142*G0_0_1_0_5 - 0.00964285714285708*G0_0_1_1_0 + 0.0289285714285711*G0_0_1_1_1 + 0.106071428571428*G0_0_1_1_3 + 0.0385714285714284*G0_0_1_1_4 - 0.0192857142857141*G0_0_1_1_5 + 0.00964285714285709*G0_0_1_2_0 - 0.0289285714285712*G0_0_1_2_2 - 0.106071428571428*G0_0_1_2_3 + 0.0192857142857142*G0_0_1_2_4 - 0.0385714285714284*G0_0_1_2_5 + 0.106071428571428*G0_0_1_3_1 - 0.106071428571428*G0_0_1_3_2 - 0.0771428571428567*G0_0_1_3_4 + 0.0771428571428569*G0_0_1_3_5 - 0.0192857142857143*G0_0_1_4_0 + 0.0385714285714284*G0_0_1_4_1 + 0.0192857142857142*G0_0_1_4_2 - 0.0771428571428567*G0_0_1_4_3 - 0.539999999999998*G0_0_1_4_4 + 0.0192857142857142*G0_0_1_5_0 - 0.0192857142857141*G0_0_1_5_1 - 0.0385714285714284*G0_0_1_5_2 + 0.0771428571428569*G0_0_1_5_3 + 0.539999999999998*G0_0_1_5_5 - 0.0176785714285713*G0_1_0_0_1 + 0.0176785714285713*G0_1_0_0_2 + 0.0128571428571428*G0_1_0_0_4 - 0.0128571428571428*G0_1_0_0_5 - 0.0176785714285713*G0_1_0_1_0 + 0.104464285714285*G0_1_0_1_1 + 0.167142857142856*G0_1_0_1_3 + 0.0257142857142856*G0_1_0_1_4 + 0.0578571428571425*G0_1_0_1_5 + 0.0176785714285713*G0_1_0_2_0 - 0.104464285714285*G0_1_0_2_2 - 0.167142857142856*G0_1_0_2_3 - 0.0578571428571427*G0_1_0_2_4 - 0.0257142857142857*G0_1_0_2_5 + 0.167142857142856*G0_1_0_3_1 - 0.167142857142856*G0_1_0_3_2 - 0.0514285714285713*G0_1_0_3_4 + 0.0514285714285712*G0_1_0_3_5 + 0.0128571428571428*G0_1_0_4_0 + 0.0257142857142856*G0_1_0_4_1 - 0.0578571428571427*G0_1_0_4_2 - 0.0514285714285713*G0_1_0_4_3 - 0.0257142857142857*G0_1_0_4_4 - 0.0128571428571428*G0_1_0_5_0 + 0.0578571428571425*G0_1_0_5_1 - 0.0257142857142857*G0_1_0_5_2 + 0.0514285714285712*G0_1_0_5_3 + 0.0257142857142852*G0_1_0_5_5 + 0.0482142857142856*G0_1_1_0_0 - 0.00562499999999996*G0_1_1_0_1 + 0.00562499999999996*G0_1_1_0_2 + 0.0128571428571428*G0_1_1_0_4 + 0.0835714285714281*G0_1_1_0_5 - 0.00562499999999996*G0_1_1_1_0 + 0.00803571428571405*G0_1_1_1_1 + 0.0072321428571428*G0_1_1_1_2 + 0.0996428571428567*G0_1_1_1_3 + 0.00642857142857142*G0_1_1_1_4 - 0.0674999999999996*G0_1_1_1_5 + 0.00562499999999996*G0_1_1_2_0 + 0.0072321428571428*G0_1_1_2_1 - 0.0899999999999997*G0_1_1_2_2 - 0.128571428571428*G0_1_1_2_3 - 0.0289285714285713*G0_1_1_2_4 - 0.00642857142857141*G0_1_1_2_5 + 0.0996428571428567*G0_1_1_3_1 - 0.128571428571428*G0_1_1_3_2 + 0.0771428571428572*G0_1_1_3_3 - 0.0128571428571428*G0_1_1_3_4 + 0.0128571428571428*G0_1_1_3_5 + 0.0128571428571428*G0_1_1_4_0 + 0.00642857142857142*G0_1_1_4_1 - 0.0289285714285713*G0_1_1_4_2 - 0.0128571428571428*G0_1_1_4_3 - 0.0257142857142855*G0_1_1_4_4 + 0.0835714285714282*G0_1_1_5_0 - 0.0674999999999996*G0_1_1_5_1 - 0.00642857142857142*G0_1_1_5_2 + 0.0128571428571428*G0_1_1_5_3 + 0.0257142857142851*G0_1_1_5_5;
    A[39] = -A[89] - 0.0674999999999997*G0_0_0_0_0 - 0.000803571428571384*G0_0_0_0_1 + 0.0200892857142856*G0_0_0_0_2 + 0.0578571428571425*G0_0_0_0_3 - 0.0257142857142857*G0_0_0_0_4 + 0.0160714285714285*G0_0_0_0_5 - 0.000803571428571384*G0_0_0_1_0 + 0.0321428571428567*G0_0_0_1_1 + 0.00723214285714282*G0_0_0_1_2 + 0.0321428571428568*G0_0_0_1_3 + 0.0257142857142856*G0_0_0_1_4 + 0.0200892857142856*G0_0_0_2_0 + 0.00723214285714282*G0_0_0_2_1 - 0.0562499999999996*G0_0_0_2_2 - 0.00321428571428555*G0_0_0_2_3 - 0.0289285714285712*G0_0_0_2_4 + 0.0128571428571428*G0_0_0_2_5 + 0.0578571428571425*G0_0_0_3_0 + 0.0321428571428568*G0_0_0_3_1 - 0.00321428571428554*G0_0_0_3_2 - 0.69428571428571*G0_0_0_3_3 - 0.167142857142856*G0_0_0_3_4 - 0.141428571428571*G0_0_0_3_5 - 0.0257142857142857*G0_0_0_4_0 + 0.0257142857142856*G0_0_0_4_1 - 0.0289285714285712*G0_0_0_4_2 - 0.167142857142856*G0_0_0_4_3 - 0.64285714285714*G0_0_0_4_4 - 0.077142857142857*G0_0_0_4_5 + 0.0160714285714285*G0_0_0_5_0 + 0.0128571428571428*G0_0_0_5_2 - 0.141428571428571*G0_0_0_5_3 - 0.077142857142857*G0_0_0_5_4 - 0.0514285714285714*G0_0_0_5_5 - 0.01125*G0_0_1_0_0 - 0.00803571428571423*G0_0_1_0_1 + 0.0449999999999997*G0_0_1_0_3 + 0.00321428571428564*G0_0_1_0_4 + 0.0192857142857142*G0_0_1_0_5 - 0.00803571428571423*G0_0_1_1_0 + 0.00803571428571425*G0_0_1_1_2 + 0.0321428571428569*G0_0_1_1_3 - 0.032142857142857*G0_0_1_1_5 + 0.00803571428571425*G0_0_1_2_1 + 0.0112500000000001*G0_0_1_2_2 - 0.0192857142857141*G0_0_1_2_3 - 0.00321428571428566*G0_0_1_2_4 - 0.0449999999999998*G0_0_1_2_5 + 0.0449999999999997*G0_0_1_3_0 + 0.0321428571428569*G0_0_1_3_1 - 0.0192857142857141*G0_0_1_3_2 - 0.642857142857139*G0_0_1_3_3 - 0.0899999999999995*G0_0_1_3_4 + 0.00321428571428564*G0_0_1_4_0 - 0.00321428571428566*G0_0_1_4_2 - 0.0899999999999995*G0_0_1_4_3 + 0.0899999999999996*G0_0_1_4_5 + 0.0192857142857142*G0_0_1_5_0 - 0.032142857142857*G0_0_1_5_1 - 0.0449999999999998*G0_0_1_5_2 + 0.0899999999999996*G0_0_1_5_4 + 0.64285714285714*G0_0_1_5_5;
    A[93] = A[39] - 0.00482142857142851*G0_0_1_0_0 + 0.015267857142857*G0_0_1_0_1 - 0.000803571428571427*G0_0_1_0_2 - 0.0192857142857141*G0_0_1_0_3 - 0.0032142857142857*G0_0_1_0_4 + 0.0128571428571428*G0_0_1_0_5 + 0.015267857142857*G0_0_1_1_0 - 0.0803571428571421*G0_0_1_1_1 + 0.00723214285714282*G0_0_1_1_2 - 0.0803571428571424*G0_0_1_1_3 - 0.00642857142857141*G0_0_1_1_4 - 0.0482142857142854*G0_0_1_1_5 - 0.000803571428571426*G0_0_1_2_0 + 0.00723214285714281*G0_0_1_2_1 - 0.0160714285714286*G0_0_1_2_2 + 0.0321428571428569*G0_0_1_2_3 + 0.0257142857142856*G0_0_1_2_5 - 0.0192857142857141*G0_0_1_3_0 - 0.0803571428571424*G0_0_1_3_1 + 0.0321428571428569*G0_0_1_3_2 + 0.46285714285714*G0_0_1_3_3 + 0.0514285714285712*G0_0_1_3_4 - 0.0128571428571427*G0_0_1_3_5 - 0.0032142857142857*G0_0_1_4_0 - 0.00642857142857141*G0_0_1_4_1 + 0.0514285714285712*G0_0_1_4_3 - 0.0514285714285711*G0_0_1_4_4 - 0.0385714285714284*G0_0_1_4_5 + 0.0128571428571428*G0_0_1_5_0 - 0.0482142857142854*G0_0_1_5_1 + 0.0257142857142856*G0_0_1_5_2 - 0.0128571428571427*G0_0_1_5_3 - 0.0385714285714284*G0_0_1_5_4 - 0.179999999999999*G0_0_1_5_5 + 0.00482142857142851*G0_1_0_0_0 - 0.015267857142857*G0_1_0_0_1 + 0.000803571428571426*G0_1_0_0_2 + 0.0192857142857141*G0_1_0_0_3 + 0.0032142857142857*G0_1_0_0_4 - 0.0128571428571428*G0_1_0_0_5 - 0.015267857142857*G0_1_0_1_0 + 0.0803571428571422*G0_1_0_1_1 - 0.00723214285714282*G0_1_0_1_2 + 0.0803571428571424*G0_1_0_1_3 + 0.00642857142857141*G0_1_0_1_4 + 0.0482142857142854*G0_1_0_1_5 + 0.000803571428571426*G0_1_0_2_0 - 0.00723214285714281*G0_1_0_2_1 + 0.0160714285714286*G0_1_0_2_2 - 0.0321428571428569*G0_1_0_2_3 - 0.0257142857142856*G0_1_0_2_5 + 0.0192857142857141*G0_1_0_3_0 + 0.0803571428571424*G0_1_0_3_1 - 0.0321428571428569*G0_1_0_3_2 - 0.46285714285714*G0_1_0_3_3 - 0.0514285714285712*G0_1_0_3_4 + 0.0128571428571427*G0_1_0_3_5 + 0.0032142857142857*G0_1_0_4_0 + 0.00642857142857141*G0_1_0_4_1 - 0.0514285714285712*G0_1_0_4_3 + 0.0514285714285711*G0_1_0_4_4 + 0.0385714285714284*G0_1_0_4_5 - 0.0128571428571428*G0_1_0_5_0 + 0.0482142857142854*G0_1_0_5_1 - 0.0257142857142856*G0_1_0_5_2 + 0.0128571428571427*G0_1_0_5_3 + 0.0385714285714284*G0_1_0_5_4 + 0.179999999999999*G0_1_0_5_5;
    A[98] = -A[93] - 0.0674999999999997*G0_0_0_0_0 - 0.000803571428571385*G0_0_0_0_1 + 0.0200892857142856*G0_0_0_0_2 + 0.0578571428571425*G0_0_0_0_3 - 0.0257142857142857*G0_0_0_0_4 + 0.0160714285714285*G0_0_0_0_5 - 0.000803571428571384*G0_0_0_1_0 + 0.0321428571428567*G0_0_0_1_1 + 0.00723214285714282*G0_0_0_1_2 + 0.0321428571428568*G0_0_0_1_3 + 0.0257142857142856*G0_0_0_1_4 + 0.0200892857142856*G0_0_0_2_0 + 0.00723214285714282*G0_0_0_2_1 - 0.0562499999999996*G0_0_0_2_2 - 0.00321428571428556*G0_0_0_2_3 - 0.0289285714285712*G0_0_0_2_4 + 0.0128571428571428*G0_0_0_2_5 + 0.0578571428571425*G0_0_0_3_0 + 0.0321428571428568*G0_0_0_3_1 - 0.00321428571428555*G0_0_0_3_2 - 0.69428571428571*G0_0_0_3_3 - 0.167142857142856*G0_0_0_3_4 - 0.141428571428571*G0_0_0_3_5 - 0.0257142857142857*G0_0_0_4_0 + 0.0257142857142856*G0_0_0_4_1 - 0.0289285714285712*G0_0_0_4_2 - 0.167142857142856*G0_0_0_4_3 - 0.64285714285714*G0_0_0_4_4 - 0.077142857142857*G0_0_0_4_5 + 0.0160714285714285*G0_0_0_5_0 + 0.0128571428571428*G0_0_0_5_2 - 0.141428571428571*G0_0_0_5_3 - 0.077142857142857*G0_0_0_5_4 - 0.0514285714285714*G0_0_0_5_5 - 0.01125*G0_1_0_0_0 - 0.00803571428571423*G0_1_0_0_1 + 0.0449999999999997*G0_1_0_0_3 + 0.00321428571428564*G0_1_0_0_4 + 0.0192857142857142*G0_1_0_0_5 - 0.00803571428571423*G0_1_0_1_0 + 0.00803571428571425*G0_1_0_1_2 + 0.0321428571428568*G0_1_0_1_3 - 0.032142857142857*G0_1_0_1_5 + 0.00803571428571425*G0_1_0_2_1 + 0.0112500000000001*G0_1_0_2_2 - 0.0192857142857141*G0_1_0_2_3 - 0.00321428571428566*G0_1_0_2_4 - 0.0449999999999998*G0_1_0_2_5 + 0.0449999999999997*G0_1_0_3_0 + 0.0321428571428569*G0_1_0_3_1 - 0.0192857142857141*G0_1_0_3_2 - 0.642857142857139*G0_1_0_3_3 - 0.0899999999999995*G0_1_0_3_4 + 0.00321428571428564*G0_1_0_4_0 - 0.00321428571428566*G0_1_0_4_2 - 0.0899999999999995*G0_1_0_4_3 + 0.0899999999999996*G0_1_0_4_5 + 0.0192857142857142*G0_1_0_5_0 - 0.032142857142857*G0_1_0_5_1 - 0.0449999999999998*G0_1_0_5_2 + 0.0899999999999996*G0_1_0_5_4 + 0.64285714285714*G0_1_0_5_5;
    A[9] = A[90] + 0.00267857142857142*G0_0_1_0_1 - 0.00267857142857141*G0_0_1_0_2 + 0.032142857142857*G0_0_1_0_4 - 0.032142857142857*G0_0_1_0_5 + 0.00267857142857142*G0_0_1_1_0 - 0.00374999999999997*G0_0_1_1_1 + 0.00107142857142857*G0_0_1_1_3 + 0.00428571428571426*G0_0_1_1_4 + 0.0171428571428571*G0_0_1_1_5 - 0.00267857142857141*G0_0_1_2_0 + 0.00375000000000001*G0_0_1_2_2 - 0.00107142857142857*G0_0_1_2_3 - 0.0171428571428571*G0_0_1_2_4 - 0.00428571428571428*G0_0_1_2_5 + 0.00107142857142857*G0_0_1_3_1 - 0.00107142857142857*G0_0_1_3_2 - 0.00857142857142852*G0_0_1_3_4 + 0.00857142857142857*G0_0_1_3_5 + 0.032142857142857*G0_0_1_4_0 + 0.00428571428571426*G0_0_1_4_1 - 0.0171428571428571*G0_0_1_4_2 - 0.00857142857142852*G0_0_1_4_3 - 0.032142857142857*G0_0_1_5_0 + 0.0171428571428571*G0_0_1_5_1 - 0.00428571428571428*G0_0_1_5_2 + 0.00857142857142856*G0_0_1_5_3 - 0.00267857142857142*G0_1_0_0_1 + 0.00267857142857141*G0_1_0_0_2 - 0.032142857142857*G0_1_0_0_4 + 0.032142857142857*G0_1_0_0_5 - 0.00267857142857142*G0_1_0_1_0 + 0.00374999999999997*G0_1_0_1_1 - 0.00107142857142857*G0_1_0_1_3 - 0.00428571428571426*G0_1_0_1_4 - 0.017142857142857*G0_1_0_1_5 + 0.00267857142857141*G0_1_0_2_0 - 0.00375000000000002*G0_1_0_2_2 + 0.00107142857142857*G0_1_0_2_3 + 0.0171428571428571*G0_1_0_2_4 + 0.00428571428571429*G0_1_0_2_5 - 0.00107142857142857*G0_1_0_3_1 + 0.00107142857142857*G0_1_0_3_2 + 0.00857142857142852*G0_1_0_3_4 - 0.00857142857142857*G0_1_0_3_5 - 0.032142857142857*G0_1_0_4_0 - 0.00428571428571426*G0_1_0_4_1 + 0.0171428571428571*G0_1_0_4_2 + 0.00857142857142851*G0_1_0_4_3 + 0.032142857142857*G0_1_0_5_0 - 0.017142857142857*G0_1_0_5_1 + 0.00428571428571428*G0_1_0_5_2 - 0.00857142857142857*G0_1_0_5_3;
    A[59] = A[93] - 0.0353571428571428*G0_0_0_0_0 + 0.0160714285714285*G0_0_0_0_2 - 0.0514285714285711*G0_0_0_0_3 - 0.0771428571428569*G0_0_0_0_4 - 0.0449999999999998*G0_0_0_0_5 + 0.0353571428571427*G0_0_0_1_1 - 0.0160714285714285*G0_0_0_1_2 + 0.0771428571428568*G0_0_0_1_3 + 0.0514285714285712*G0_0_0_1_4 + 0.0449999999999998*G0_0_0_1_5 + 0.0160714285714285*G0_0_0_2_0 - 0.0160714285714285*G0_0_0_2_1 - 0.0642857142857139*G0_0_0_2_3 + 0.064285714285714*G0_0_0_2_4 - 0.0514285714285711*G0_0_0_3_0 + 0.0771428571428568*G0_0_0_3_1 - 0.0642857142857139*G0_0_0_3_2 + 0.514285714285712*G0_0_0_3_3 + 0.102857142857142*G0_0_0_3_5 - 0.0771428571428569*G0_0_0_4_0 + 0.0514285714285712*G0_0_0_4_1 + 0.064285714285714*G0_0_0_4_2 - 0.514285714285712*G0_0_0_4_4 - 0.102857142857142*G0_0_0_4_5 - 0.0449999999999998*G0_0_0_5_0 + 0.0449999999999998*G0_0_0_5_1 + 0.102857142857143*G0_0_0_5_3 - 0.102857142857142*G0_0_0_5_4 - 0.0144642857142857*G0_0_1_0_0 - 0.00723214285714275*G0_0_1_0_1 + 0.0120535714285714*G0_0_1_0_2 - 0.0192857142857142*G0_0_1_0_3 - 0.0289285714285713*G0_0_1_0_4 - 0.0385714285714284*G0_0_1_0_5 - 0.00723214285714276*G0_0_1_1_0 + 0.0964285714285706*G0_0_1_1_1 - 0.0120535714285714*G0_0_1_1_2 + 0.125357142857142*G0_0_1_1_3 + 0.0192857142857142*G0_0_1_1_4 + 0.0674999999999996*G0_0_1_1_5 + 0.0120535714285714*G0_0_1_2_0 - 0.0120535714285714*G0_0_1_2_1 - 0.0482142857142855*G0_0_1_2_2 - 0.0964285714285709*G0_0_1_2_3 - 0.0192857142857142*G0_0_1_3_0 + 0.125357142857142*G0_0_1_3_1 - 0.0964285714285709*G0_0_1_3_2 + 0.0385714285714284*G0_0_1_3_5 - 0.0289285714285713*G0_0_1_4_0 + 0.0192857142857142*G0_0_1_4_1 - 0.0385714285714284*G0_0_1_4_5 - 0.0385714285714284*G0_0_1_5_0 + 0.0674999999999996*G0_0_1_5_1 + 0.0385714285714284*G0_0_1_5_3 - 0.0385714285714284*G0_0_1_5_4 - 0.0771428571428571*G0_0_1_5_5 + 0.0610714285714284*G0_1_0_0_0 - 0.00723214285714283*G0_1_0_0_1 + 0.00401785714285711*G0_1_0_0_2 - 0.0321428571428569*G0_1_0_0_3 + 0.0482142857142855*G0_1_0_0_4 + 0.0224999999999999*G0_1_0_0_5 - 0.00723214285714283*G0_1_0_1_0 + 0.020892857142857*G0_1_0_1_1 - 0.00401785714285715*G0_1_0_1_2 + 0.0482142857142855*G0_1_0_1_3 + 0.032142857142857*G0_1_0_1_4 + 0.00642857142857144*G0_1_0_1_5 + 0.00401785714285711*G0_1_0_2_0 - 0.00401785714285715*G0_1_0_2_1 - 0.0482142857142855*G0_1_0_2_2 - 0.0642857142857139*G0_1_0_2_3 - 0.032142857142857*G0_1_0_2_4 - 0.0321428571428569*G0_1_0_3_0 + 0.0482142857142855*G0_1_0_3_1 - 0.0642857142857139*G0_1_0_3_2 + 0.514285714285712*G0_1_0_3_3 + 0.0642857142857141*G0_1_0_3_5 + 0.0482142857142855*G0_1_0_4_0 + 0.032142857142857*G0_1_0_4_1 - 0.032142857142857*G0_1_0_4_2 - 0.514285714285712*G0_1_0_4_4 - 0.064285714285714*G0_1_0_4_5 + 0.0224999999999999*G0_1_0_5_0 + 0.00642857142857144*G0_1_0_5_1 + 0.0642857142857142*G0_1_0_5_3 - 0.064285714285714*G0_1_0_5_4 - 0.0771428571428568*G0_1_0_5_5 + 0.0899999999999998*G0_1_1_0_0 - 0.00723214285714282*G0_1_1_0_1 - 0.005625*G0_1_1_0_2 + 0.00642857142857137*G0_1_1_0_3 + 0.0289285714285713*G0_1_1_0_4 + 0.128571428571428*G0_1_1_0_5 - 0.00723214285714282*G0_1_1_1_0 - 0.00803571428571446*G0_1_1_1_1 + 0.00562499999999996*G0_1_1_1_2 + 0.0674999999999997*G0_1_1_1_3 - 0.00642857142857139*G0_1_1_1_4 - 0.0996428571428566*G0_1_1_1_5 - 0.005625*G0_1_1_2_0 + 0.00562499999999996*G0_1_1_2_1 - 0.0482142857142855*G0_1_1_2_2 - 0.0835714285714281*G0_1_1_2_3 - 0.0128571428571428*G0_1_1_2_4 + 0.00642857142857137*G0_1_1_3_0 + 0.0674999999999997*G0_1_1_3_1 - 0.0835714285714281*G0_1_1_3_2 - 0.0257142857142852*G0_1_1_3_3 - 0.0128571428571428*G0_1_1_3_5 + 0.0289285714285713*G0_1_1_4_0 - 0.00642857142857139*G0_1_1_4_1 - 0.0128571428571428*G0_1_1_4_2 + 0.0257142857142857*G0_1_1_4_4 + 0.0128571428571428*G0_1_1_4_5 + 0.128571428571428*G0_1_1_5_0 - 0.0996428571428566*G0_1_1_5_1 - 0.0128571428571428*G0_1_1_5_3 + 0.0128571428571427*G0_1_1_5_4 - 0.0771428571428574*G0_1_1_5_5;
    A[55] = -A[59] - 0.00803571428571426*G0_0_0_0_0 + 0.00160714285714285*G0_0_0_0_1 + 0.0032142857142857*G0_0_0_0_2 + 0.00321428571428567*G0_0_0_0_3 - 0.00964285714285713*G0_0_0_0_4 - 0.00642857142857141*G0_0_0_0_5 + 0.00160714285714285*G0_0_0_1_0 - 0.00803571428571423*G0_0_0_1_1 + 0.00321428571428569*G0_0_0_1_2 - 0.00964285714285713*G0_0_0_1_3 + 0.00321428571428569*G0_0_0_1_4 - 0.0064285714285714*G0_0_0_1_5 + 0.0032142857142857*G0_0_0_2_0 + 0.00321428571428569*G0_0_0_2_1 + 0.0482142857142855*G0_0_0_2_2 - 0.00642857142857139*G0_0_0_2_5 + 0.00321428571428567*G0_0_0_3_0 - 0.00964285714285713*G0_0_0_3_1 - 0.179999999999999*G0_0_0_3_3 - 0.0128571428571428*G0_0_0_3_4 + 0.00642857142857141*G0_0_0_3_5 - 0.00964285714285715*G0_0_0_4_0 + 0.00321428571428569*G0_0_0_4_1 - 0.0128571428571428*G0_0_0_4_3 - 0.179999999999999*G0_0_0_4_4 + 0.00642857142857131*G0_0_0_4_5 - 0.00642857142857142*G0_0_0_5_0 - 0.0064285714285714*G0_0_0_5_1 - 0.00642857142857139*G0_0_0_5_2 + 0.00642857142857142*G0_0_0_5_3 + 0.00642857142857131*G0_0_0_5_4 + 0.0385714285714284*G0_0_0_5_5 - 0.0723214285714283*G0_0_1_0_0 + 0.0152678571428571*G0_0_1_0_1 + 0.00883928571428569*G0_0_1_0_2 - 0.00803571428571428*G0_0_1_0_3 - 0.0739285714285711*G0_0_1_0_4 - 0.0546428571428569*G0_0_1_0_5 + 0.0152678571428571*G0_0_1_1_0 - 0.00883928571428569*G0_0_1_1_1 + 0.00160714285714284*G0_0_1_1_2 - 0.00964285714285712*G0_0_1_1_3 - 0.0176785714285713*G0_0_1_1_4 + 0.0112499999999999*G0_0_1_1_5 + 0.00883928571428569*G0_0_1_2_0 + 0.00160714285714284*G0_0_1_2_1 + 0.0281249999999999*G0_0_1_2_2 - 0.0048214285714285*G0_0_1_2_3 + 0.0208928571428571*G0_0_1_2_4 + 0.0176785714285714*G0_0_1_2_5 - 0.00803571428571428*G0_0_1_3_0 - 0.00964285714285712*G0_0_1_3_1 - 0.0048214285714285*G0_0_1_3_2 - 0.18642857142857*G0_0_1_3_3 + 0.0514285714285712*G0_0_1_3_4 - 0.0192857142857142*G0_0_1_3_5 - 0.0739285714285711*G0_0_1_4_0 - 0.0176785714285713*G0_0_1_4_1 + 0.0208928571428571*G0_0_1_4_2 + 0.0514285714285712*G0_0_1_4_3 + 0.340714285714284*G0_0_1_4_4 - 0.0546428571428569*G0_0_1_5_0 + 0.0112499999999999*G0_0_1_5_1 + 0.0176785714285714*G0_0_1_5_2 - 0.0192857142857143*G0_0_1_5_3 - 0.147857142857142*G0_0_1_5_5 + 0.00803571428571428*G0_1_0_0_0 + 0.00160714285714284*G0_1_0_0_2 - 0.00160714285714288*G0_1_0_0_3 + 0.00642857142857139*G0_1_0_0_4 - 0.00642857142857138*G0_1_0_0_5 - 0.00401785714285711*G0_1_0_1_1 + 0.00241071428571426*G0_1_0_1_2 - 0.0064285714285714*G0_1_0_1_3 + 0.00160714285714283*G0_1_0_1_4 - 0.00160714285714285*G0_1_0_1_5 + 0.00160714285714285*G0_1_0_2_0 + 0.00241071428571426*G0_1_0_2_1 + 0.0441964285714284*G0_1_0_2_2 - 0.0048214285714285*G0_1_0_2_3 - 0.0112499999999999*G0_1_0_2_4 - 0.00803571428571425*G0_1_0_2_5 - 0.00160714285714288*G0_1_0_3_0 - 0.00642857142857141*G0_1_0_3_1 - 0.0048214285714285*G0_1_0_3_2 - 0.134999999999999*G0_1_0_3_3 + 0.0192857142857142*G0_1_0_3_5 + 0.00642857142857141*G0_1_0_4_0 + 0.00160714285714283*G0_1_0_4_1 - 0.0112499999999999*G0_1_0_4_2 - 0.122142857142857*G0_1_0_4_4 + 0.0128571428571428*G0_1_0_4_5 - 0.00642857142857138*G0_1_0_5_0 - 0.00160714285714285*G0_1_0_5_1 - 0.00803571428571425*G0_1_0_5_2 + 0.0192857142857142*G0_1_0_5_3 + 0.0128571428571428*G0_1_0_5_4 + 0.032142857142857*G0_1_0_5_5 + 0.401785714285713*G0_1_1_0_0 - 0.0385714285714284*G0_1_1_0_1 - 0.0289285714285713*G0_1_1_0_2 + 0.00321428571428571*G0_1_1_0_3 + 0.0707142857142853*G0_1_1_0_4 + 0.202499999999999*G0_1_1_0_5 - 0.0385714285714284*G0_1_1_1_0 + 0.00482142857142855*G0_1_1_1_1 + 0.00803571428571424*G0_1_1_1_2 - 0.0192857142857142*G0_1_1_1_3 - 0.0449999999999998*G0_1_1_1_4 - 0.0707142857142853*G0_1_1_1_5 - 0.0289285714285713*G0_1_1_2_0 + 0.00803571428571424*G0_1_1_2_1 + 0.0369642857142855*G0_1_1_2_2 - 0.00964285714285709*G0_1_1_2_3 - 0.0224999999999999*G0_1_1_2_5 + 0.00321428571428571*G0_1_1_3_0 - 0.0192857142857142*G0_1_1_3_1 - 0.00964285714285709*G0_1_1_3_2 - 0.128571428571428*G0_1_1_3_3 + 0.0835714285714282*G0_1_1_3_4 + 0.0385714285714284*G0_1_1_3_5 + 0.0707142857142853*G0_1_1_4_0 - 0.0449999999999998*G0_1_1_4_1 + 0.0835714285714282*G0_1_1_4_3 + 0.398571428571427*G0_1_1_4_4 + 0.134999999999999*G0_1_1_4_5 + 0.202499999999999*G0_1_1_5_0 - 0.0707142857142853*G0_1_1_5_1 - 0.0224999999999999*G0_1_1_5_2 + 0.0385714285714284*G0_1_1_5_3 + 0.134999999999999*G0_1_1_5_4 + 0.359999999999998*G0_1_1_5_5;
    A[77] = A[55] + 0.26517857142857*G0_0_0_0_0 - 0.0200892857142856*G0_0_0_0_1 - 0.00401785714285711*G0_0_0_0_2 + 0.0642857142857136*G0_0_0_0_4 + 0.0321428571428569*G0_0_0_0_5 - 0.0200892857142856*G0_0_0_1_0 + 0.0707142857142853*G0_0_0_1_1 - 0.00241071428571429*G0_0_0_1_2 + 0.0642857142857139*G0_0_0_1_3 + 0.0449999999999998*G0_0_0_1_4 + 0.0353571428571427*G0_0_0_1_5 - 0.0040178571428571*G0_0_0_2_0 - 0.00241071428571429*G0_0_0_2_1 - 0.0835714285714282*G0_0_0_2_2 - 0.0546428571428568*G0_0_0_2_3 - 0.00321428571428564*G0_0_0_2_4 - 0.0128571428571428*G0_0_0_2_5 + 0.0642857142857139*G0_0_0_3_1 - 0.0546428571428568*G0_0_0_3_2 - 0.0257142857142855*G0_0_0_3_3 - 0.0899999999999996*G0_0_0_3_4 + 0.0257142857142856*G0_0_0_3_5 + 0.0642857142857137*G0_0_0_4_0 + 0.0449999999999998*G0_0_0_4_1 - 0.00321428571428563*G0_0_0_4_2 - 0.0899999999999996*G0_0_0_4_3 - 0.514285714285712*G0_0_0_4_4 - 0.0642857142857141*G0_0_0_4_5 + 0.0321428571428569*G0_0_0_5_0 + 0.0353571428571427*G0_0_0_5_1 - 0.0128571428571428*G0_0_0_5_2 + 0.0257142857142856*G0_0_0_5_3 - 0.0642857142857141*G0_0_0_5_4 + 0.257142857142856*G0_0_0_5_5 - 0.00803571428571423*G0_0_1_0_1 + 0.00803571428571424*G0_0_1_0_2 + 0.0160714285714285*G0_0_1_0_4 - 0.0160714285714285*G0_0_1_0_5 - 0.00803571428571423*G0_0_1_1_0 + 0.0771428571428567*G0_0_1_1_1 + 0.0594642857142853*G0_0_1_1_3 + 0.0289285714285713*G0_0_1_1_4 + 0.0192857142857142*G0_0_1_1_5 + 0.00803571428571424*G0_0_1_2_0 - 0.0771428571428568*G0_0_1_2_2 - 0.0594642857142854*G0_0_1_2_3 - 0.0192857142857142*G0_0_1_2_4 - 0.0289285714285713*G0_0_1_2_5 + 0.0594642857142853*G0_0_1_3_1 - 0.0594642857142854*G0_0_1_3_2 - 0.0578571428571425*G0_0_1_3_4 + 0.0578571428571426*G0_0_1_3_5 + 0.0160714285714285*G0_0_1_4_0 + 0.0289285714285713*G0_0_1_4_1 - 0.0192857142857142*G0_0_1_4_2 - 0.0578571428571425*G0_0_1_4_3 - 0.385714285714284*G0_0_1_4_4 - 0.0160714285714285*G0_0_1_5_0 + 0.0192857142857142*G0_0_1_5_1 - 0.0289285714285713*G0_0_1_5_2 + 0.0578571428571426*G0_0_1_5_3 + 0.385714285714284*G0_0_1_5_5 - 0.00803571428571423*G0_1_0_0_1 + 0.00803571428571424*G0_1_0_0_2 + 0.0160714285714285*G0_1_0_0_4 - 0.0160714285714285*G0_1_0_0_5 - 0.00803571428571423*G0_1_0_1_0 + 0.0771428571428567*G0_1_0_1_1 + 0.0594642857142854*G0_1_0_1_3 + 0.0289285714285713*G0_1_0_1_4 + 0.0192857142857142*G0_1_0_1_5 + 0.00803571428571424*G0_1_0_2_0 - 0.0771428571428568*G0_1_0_2_2 - 0.0594642857142854*G0_1_0_2_3 - 0.0192857142857142*G0_1_0_2_4 - 0.0289285714285713*G0_1_0_2_5 + 0.0594642857142854*G0_1_0_3_1 - 0.0594642857142854*G0_1_0_3_2 - 0.0578571428571425*G0_1_0_3_4 + 0.0578571428571426*G0_1_0_3_5 + 0.0160714285714285*G0_1_0_4_0 + 0.0289285714285713*G0_1_0_4_1 - 0.0192857142857142*G0_1_0_4_2 - 0.0578571428571425*G0_1_0_4_3 - 0.385714285714284*G0_1_0_4_4 - 0.0160714285714285*G0_1_0_5_0 + 0.0192857142857142*G0_1_0_5_1 - 0.0289285714285713*G0_1_0_5_2 + 0.0578571428571426*G0_1_0_5_3 + 0.385714285714284*G0_1_0_5_5 - 0.26517857142857*G0_1_1_0_0 + 0.00401785714285711*G0_1_1_0_1 + 0.0200892857142856*G0_1_1_0_2 - 0.0321428571428569*G0_1_1_0_4 - 0.0642857142857138*G0_1_1_0_5 + 0.00401785714285712*G0_1_1_1_0 + 0.083571428571428*G0_1_1_1_1 + 0.00241071428571428*G0_1_1_1_2 + 0.0546428571428568*G0_1_1_1_3 + 0.0128571428571428*G0_1_1_1_4 + 0.00321428571428566*G0_1_1_1_5 + 0.0200892857142856*G0_1_1_2_0 + 0.00241071428571428*G0_1_1_2_1 - 0.0707142857142854*G0_1_1_2_2 - 0.064285714285714*G0_1_1_2_3 - 0.0353571428571427*G0_1_1_2_4 - 0.0449999999999999*G0_1_1_2_5 + 0.0546428571428568*G0_1_1_3_1 - 0.064285714285714*G0_1_1_3_2 + 0.0257142857142858*G0_1_1_3_3 - 0.0257142857142855*G0_1_1_3_4 + 0.0899999999999997*G0_1_1_3_5 - 0.0321428571428569*G0_1_1_4_0 + 0.0128571428571428*G0_1_1_4_1 - 0.0353571428571427*G0_1_1_4_2 - 0.0257142857142855*G0_1_1_4_3 - 0.257142857142856*G0_1_1_4_4 + 0.0642857142857141*G0_1_1_4_5 - 0.0642857142857138*G0_1_1_5_0 + 0.00321428571428566*G0_1_1_5_1 - 0.0449999999999999*G0_1_1_5_2 + 0.0899999999999997*G0_1_1_5_3 + 0.0642857142857141*G0_1_1_5_4 + 0.514285714285712*G0_1_1_5_5;
    A[33] = -A[39] - 0.00803571428571427*G0_0_0_0_0 + 0.00160714285714285*G0_0_0_0_1 + 0.00321428571428571*G0_0_0_0_2 + 0.00321428571428568*G0_0_0_0_3 - 0.00964285714285713*G0_0_0_0_4 - 0.00642857142857141*G0_0_0_0_5 + 0.00160714285714285*G0_0_0_1_0 - 0.00803571428571422*G0_0_0_1_1 + 0.00321428571428569*G0_0_0_1_2 - 0.00964285714285712*G0_0_0_1_3 + 0.00321428571428571*G0_0_0_1_4 - 0.00642857142857139*G0_0_0_1_5 + 0.00321428571428571*G0_0_0_2_0 + 0.00321428571428569*G0_0_0_2_1 + 0.0482142857142855*G0_0_0_2_2 - 0.00642857142857138*G0_0_0_2_5 + 0.00321428571428567*G0_0_0_3_0 - 0.00964285714285712*G0_0_0_3_1 - 0.179999999999999*G0_0_0_3_3 - 0.0128571428571429*G0_0_0_3_4 + 0.00642857142857131*G0_0_0_3_5 - 0.00964285714285713*G0_0_0_4_0 + 0.00321428571428571*G0_0_0_4_1 - 0.0128571428571429*G0_0_0_4_3 - 0.179999999999999*G0_0_0_4_4 + 0.00642857142857134*G0_0_0_4_5 - 0.00642857142857141*G0_0_0_5_0 - 0.0064285714285714*G0_0_0_5_1 - 0.00642857142857137*G0_0_0_5_2 + 0.00642857142857134*G0_0_0_5_3 + 0.00642857142857134*G0_0_0_5_4 + 0.0385714285714284*G0_0_0_5_5 + 0.000803571428571409*G0_0_1_0_0 - 0.0136607142857142*G0_0_1_0_1 + 0.00160714285714286*G0_0_1_0_2 + 0.020892857142857*G0_0_1_0_3 - 0.0176785714285713*G0_0_1_0_5 - 0.0136607142857142*G0_0_1_1_0 + 0.0642857142857138*G0_0_1_1_1 - 0.00562499999999997*G0_0_1_1_2 + 0.0642857142857139*G0_0_1_1_3 + 0.0112499999999999*G0_0_1_1_4 + 0.0482142857142854*G0_0_1_1_5 + 0.00160714285714286*G0_0_1_2_0 - 0.00562499999999997*G0_0_1_2_1 + 0.0200892857142856*G0_0_1_2_2 - 0.020892857142857*G0_0_1_2_3 + 0.00482142857142852*G0_0_1_2_4 - 0.0241071428571428*G0_0_1_2_5 + 0.020892857142857*G0_0_1_3_0 + 0.0642857142857139*G0_0_1_3_1 - 0.020892857142857*G0_0_1_3_2 - 0.520714285714283*G0_0_1_3_3 - 0.0642857142857139*G0_0_1_3_4 + 0.00642857142857137*G0_0_1_3_5 + 0.0112499999999999*G0_0_1_4_1 + 0.00482142857142852*G0_0_1_4_2 - 0.0642857142857139*G0_0_1_4_3 + 0.00642857142857143*G0_0_1_4_4 + 0.0257142857142856*G0_0_1_4_5 - 0.0176785714285713*G0_0_1_5_0 + 0.0482142857142854*G0_0_1_5_1 - 0.0241071428571428*G0_0_1_5_2 + 0.00642857142857137*G0_0_1_5_3 + 0.0257142857142856*G0_0_1_5_4 + 0.186428571428571*G0_0_1_5_5 - 0.0040178571428571*G0_1_0_0_0 + 0.00160714285714283*G0_1_0_0_1 + 0.000803571428571431*G0_1_0_0_2 + 0.00160714285714283*G0_1_0_0_3 - 0.00321428571428572*G0_1_0_0_4 - 0.00482142857142856*G0_1_0_0_5 + 0.00160714285714283*G0_1_0_1_0 - 0.0160714285714283*G0_1_0_1_1 + 0.00160714285714284*G0_1_0_1_2 - 0.0160714285714284*G0_1_0_1_3 + 0.00482142857142854*G0_1_0_1_4 + 0.000803571428571432*G0_1_0_2_0 + 0.00160714285714284*G0_1_0_2_1 + 0.00401785714285706*G0_1_0_2_2 + 0.0112499999999999*G0_1_0_2_3 + 0.00482142857142854*G0_1_0_2_4 + 0.00160714285714284*G0_1_0_2_5 + 0.00160714285714283*G0_1_0_3_0 - 0.0160714285714284*G0_1_0_3_1 + 0.0112499999999999*G0_1_0_3_2 - 0.0578571428571425*G0_1_0_3_3 - 0.0128571428571428*G0_1_0_3_4 - 0.00642857142857137*G0_1_0_3_5 - 0.00321428571428572*G0_1_0_4_0 + 0.00482142857142854*G0_1_0_4_1 + 0.00482142857142854*G0_1_0_4_2 - 0.0128571428571428*G0_1_0_4_3 - 0.0449999999999997*G0_1_0_4_4 - 0.0128571428571428*G0_1_0_4_5 - 0.00482142857142856*G0_1_0_5_0 + 0.00160714285714284*G0_1_0_5_2 - 0.00642857142857138*G0_1_0_5_3 - 0.0128571428571428*G0_1_0_5_4 + 0.00642857142857153*G0_1_0_5_5 + 0.00964285714285708*G0_1_1_0_0 - 0.0522321428571425*G0_1_1_0_1 + 0.00723214285714282*G0_1_1_0_2 - 0.0257142857142856*G0_1_1_0_3 - 0.0128571428571428*G0_1_1_0_4 - 0.0867857142857137*G0_1_1_0_5 - 0.0522321428571425*G0_1_1_1_0 + 0.458035714285712*G0_1_1_1_1 - 0.0361607142857141*G0_1_1_1_2 + 0.128571428571428*G0_1_1_1_3 + 0.0160714285714285*G0_1_1_1_4 + 0.257142857142856*G0_1_1_1_5 + 0.00723214285714282*G0_1_1_2_0 - 0.0361607142857141*G0_1_1_2_1 + 0.0128571428571428*G0_1_1_2_2 - 0.00964285714285709*G0_1_1_2_3 - 0.0385714285714284*G0_1_1_2_5 - 0.0257142857142856*G0_1_1_3_0 + 0.128571428571428*G0_1_1_3_1 - 0.0096428571428571*G0_1_1_3_2 + 0.0192857142857142*G0_1_1_3_4 + 0.128571428571428*G0_1_1_3_5 - 0.0128571428571428*G0_1_1_4_0 + 0.0160714285714285*G0_1_1_4_1 + 0.0192857142857142*G0_1_1_4_3 + 0.0128571428571428*G0_1_1_4_4 + 0.0449999999999998*G0_1_1_4_5 - 0.0867857142857137*G0_1_1_5_0 + 0.257142857142856*G0_1_1_5_1 - 0.0385714285714284*G0_1_1_5_2 + 0.128571428571428*G0_1_1_5_3 + 0.0449999999999998*G0_1_1_5_4 + 0.514285714285712*G0_1_1_5_5;
    A[83] = -A[33] + 0.0233035714285713*G0_0_0_0_0 + 0.00401785714285709*G0_0_0_0_1 - 0.00642857142857139*G0_0_0_0_2 - 0.062678571428571*G0_0_0_0_3 - 0.0289285714285712*G0_0_0_0_4 - 0.0337499999999998*G0_0_0_0_5 + 0.00401785714285709*G0_0_0_1_0 - 0.0241071428571426*G0_0_0_1_1 - 0.00401785714285713*G0_0_0_1_2 - 0.0321428571428569*G0_0_0_1_3 - 0.0241071428571427*G0_0_0_1_4 - 0.0160714285714285*G0_0_0_1_5 - 0.00642857142857139*G0_0_0_2_0 - 0.00401785714285713*G0_0_0_2_1 + 0.100446428571428*G0_0_0_2_2 - 0.0144642857142857*G0_0_0_2_3 + 0.0305357142857141*G0_0_0_2_4 - 0.0337499999999999*G0_0_0_2_5 - 0.062678571428571*G0_0_0_3_0 - 0.0321428571428569*G0_0_0_3_1 - 0.0144642857142857*G0_0_0_3_2 + 0.578571428571425*G0_0_0_3_3 + 0.173571428571428*G0_0_0_3_4 + 0.192857142857142*G0_0_0_3_5 - 0.0289285714285712*G0_0_0_4_0 - 0.0241071428571427*G0_0_0_4_1 + 0.0305357142857141*G0_0_0_4_2 + 0.173571428571428*G0_0_0_4_3 + 0.295714285714284*G0_0_0_4_4 + 0.115714285714285*G0_0_0_4_5 - 0.0337499999999998*G0_0_0_5_0 - 0.0160714285714285*G0_0_0_5_1 - 0.0337499999999999*G0_0_0_5_2 + 0.192857142857142*G0_0_0_5_3 + 0.115714285714285*G0_0_0_5_4 + 0.192857142857142*G0_0_0_5_5 + 0.00642857142857136*G0_0_1_0_0 + 0.0120535714285713*G0_0_1_0_1 + 0.00241071428571429*G0_0_1_0_2 - 0.0160714285714285*G0_0_1_0_3 - 0.00482142857142855*G0_0_1_0_4 - 0.0160714285714285*G0_0_1_0_5 + 0.0120535714285713*G0_0_1_1_0 - 0.26517857142857*G0_0_1_1_1 + 0.0120535714285714*G0_0_1_1_2 - 0.0482142857142853*G0_0_1_1_3 - 0.0482142857142853*G0_0_1_1_5 + 0.00241071428571429*G0_0_1_2_0 + 0.0120535714285714*G0_0_1_2_1 + 0.00642857142857132*G0_0_1_2_2 - 0.0160714285714286*G0_0_1_2_3 - 0.00482142857142863*G0_0_1_2_4 - 0.0160714285714286*G0_0_1_2_5 - 0.0160714285714285*G0_0_1_3_0 - 0.0482142857142853*G0_0_1_3_1 - 0.0160714285714286*G0_0_1_3_2 + 0.128571428571428*G0_0_1_3_3 + 0.0321428571428571*G0_0_1_3_4 + 0.0642857142857142*G0_0_1_3_5 - 0.00482142857142855*G0_0_1_4_0 - 0.00482142857142863*G0_0_1_4_2 + 0.0321428571428571*G0_0_1_4_3 + 0.0257142857142856*G0_0_1_4_4 + 0.0321428571428571*G0_0_1_4_5 - 0.0160714285714285*G0_0_1_5_0 - 0.0482142857142854*G0_0_1_5_1 - 0.0160714285714286*G0_0_1_5_2 + 0.0642857142857142*G0_0_1_5_3 + 0.0321428571428571*G0_0_1_5_4 + 0.128571428571428*G0_0_1_5_5;
    A[75] = A[83] - 0.0827678571428569*G0_0_0_0_0 + 0.0184821428571428*G0_0_0_0_2 - 0.0128571428571428*G0_0_0_0_3 - 0.0803571428571425*G0_0_0_0_4 - 0.0273214285714285*G0_0_0_0_5 + 0.0827678571428565*G0_0_0_1_1 - 0.0184821428571428*G0_0_0_1_2 + 0.0803571428571425*G0_0_0_1_3 + 0.0128571428571428*G0_0_0_1_4 + 0.0273214285714284*G0_0_0_1_5 + 0.0184821428571428*G0_0_0_2_0 - 0.0184821428571428*G0_0_0_2_1 - 0.0192857142857142*G0_0_0_2_3 + 0.0192857142857142*G0_0_0_2_4 - 0.0128571428571428*G0_0_0_3_0 + 0.0803571428571424*G0_0_0_3_1 - 0.0192857142857142*G0_0_0_3_2 + 0.23142857142857*G0_0_0_3_3 + 0.0257142857142857*G0_0_0_3_5 - 0.0803571428571425*G0_0_0_4_0 + 0.0128571428571428*G0_0_0_4_1 + 0.0192857142857142*G0_0_0_4_2 - 0.23142857142857*G0_0_0_4_4 - 0.0257142857142856*G0_0_0_4_5 - 0.0273214285714285*G0_0_0_5_0 + 0.0273214285714284*G0_0_0_5_1 + 0.0257142857142857*G0_0_0_5_3 - 0.0257142857142856*G0_0_0_5_4 + 0.288482142857141*G0_0_1_0_0 - 0.0409821428571426*G0_0_1_0_1 - 0.0144642857142856*G0_0_1_0_2 - 0.0176785714285713*G0_0_1_0_3 + 0.062678571428571*G0_0_1_0_4 + 0.0594642857142854*G0_0_1_0_5 - 0.0409821428571426*G0_0_1_1_0 + 0.371249999999998*G0_0_1_1_1 - 0.0329464285714284*G0_0_1_1_2 + 0.143035714285713*G0_0_1_1_3 - 0.00482142857142853*G0_0_1_1_4 + 0.0867857142857137*G0_0_1_1_5 - 0.0144642857142856*G0_0_1_2_0 - 0.0329464285714284*G0_0_1_2_1 + 0.0152678571428571*G0_0_1_2_2 - 0.0289285714285713*G0_0_1_2_3 - 0.00964285714285708*G0_0_1_2_4 - 0.0176785714285713*G0_0_1_2_5 - 0.0176785714285713*G0_0_1_3_0 + 0.143035714285713*G0_0_1_3_1 - 0.0289285714285713*G0_0_1_3_2 + 0.269999999999998*G0_0_1_3_3 + 0.0449999999999998*G0_0_1_3_4 + 0.0707142857142854*G0_0_1_3_5 + 0.062678571428571*G0_0_1_4_0 - 0.00482142857142853*G0_0_1_4_1 - 0.00964285714285708*G0_0_1_4_2 + 0.0449999999999998*G0_0_1_4_3 + 0.0385714285714283*G0_0_1_4_4 + 0.0449999999999997*G0_0_1_4_5 + 0.0594642857142854*G0_0_1_5_0 + 0.0867857142857137*G0_0_1_5_1 - 0.0176785714285713*G0_0_1_5_2 + 0.0707142857142854*G0_0_1_5_3 + 0.0449999999999997*G0_0_1_5_4 + 0.0128571428571425*G0_0_1_5_5 + 0.0297321428571427*G0_1_0_0_0 - 0.0168749999999999*G0_1_0_0_1 - 0.0337499999999998*G0_1_0_0_3 + 0.0096428571428572*G0_1_0_0_4 - 0.00482142857142849*G0_1_0_0_5 - 0.0168749999999999*G0_1_0_1_0 + 0.112499999999999*G0_1_0_1_1 - 0.0184821428571428*G0_1_0_1_2 + 0.0899999999999996*G0_1_0_1_3 - 0.020892857142857*G0_1_0_1_4 + 0.0224999999999998*G0_1_0_1_5 - 0.0184821428571428*G0_1_0_2_1 + 0.0281249999999998*G0_1_0_2_2 - 0.0498214285714284*G0_1_0_2_3 - 0.0305357142857142*G0_1_0_2_4 - 0.0498214285714284*G0_1_0_2_5 - 0.0337499999999998*G0_1_0_3_0 + 0.0899999999999996*G0_1_0_3_1 - 0.0498214285714284*G0_1_0_3_2 + 0.424285714285712*G0_1_0_3_3 + 0.109285714285714*G0_1_0_3_4 + 0.167142857142857*G0_1_0_3_5 + 0.0096428571428572*G0_1_0_4_0 - 0.0208928571428571*G0_1_0_4_1 - 0.0305357142857142*G0_1_0_4_2 + 0.109285714285714*G0_1_0_4_3 + 0.192857142857142*G0_1_0_4_4 + 0.141428571428571*G0_1_0_4_5 - 0.0048214285714285*G0_1_0_5_0 + 0.0224999999999998*G0_1_0_5_1 - 0.0498214285714284*G0_1_0_5_2 + 0.167142857142857*G0_1_0_5_3 + 0.141428571428571*G0_1_0_5_4 + 0.269999999999999*G0_1_0_5_5 - 0.0610714285714283*G0_1_1_0_0 - 0.0289285714285712*G0_1_1_0_1 + 0.0144642857142856*G0_1_1_0_2 - 0.0466071428571426*G0_1_1_0_3 - 0.0385714285714283*G0_1_1_0_4 - 0.128571428571428*G0_1_1_0_5 - 0.0289285714285712*G0_1_1_1_0 + 0.462053571428569*G0_1_1_1_1 - 0.047410714285714*G0_1_1_1_2 + 0.191249999999999*G0_1_1_1_3 + 0.00803571428571426*G0_1_1_1_4 + 0.210535714285713*G0_1_1_1_5 + 0.0144642857142856*G0_1_1_2_0 - 0.047410714285714*G0_1_1_2_1 + 0.0216964285714285*G0_1_1_2_2 - 0.0482142857142855*G0_1_1_2_3 - 0.01125*G0_1_1_2_4 - 0.0337499999999999*G0_1_1_2_5 - 0.0466071428571426*G0_1_1_3_0 + 0.191249999999999*G0_1_1_3_1 - 0.0482142857142856*G0_1_1_3_2 + 0.372857142857141*G0_1_1_3_3 + 0.0771428571428568*G0_1_1_3_4 + 0.160714285714285*G0_1_1_3_5 - 0.0385714285714283*G0_1_1_4_0 + 0.00803571428571426*G0_1_1_4_1 - 0.01125*G0_1_1_4_2 + 0.0771428571428568*G0_1_1_4_3 + 0.0899999999999995*G0_1_1_4_4 + 0.0514285714285713*G0_1_1_4_5 - 0.128571428571428*G0_1_1_5_0 + 0.210535714285713*G0_1_1_5_1 - 0.0337499999999999*G0_1_1_5_2 + 0.160714285714285*G0_1_1_5_3 + 0.0514285714285713*G0_1_1_5_4 + 0.141428571428571*G0_1_1_5_5;
    A[57] = A[75] - 0.26517857142857*G0_0_1_0_0 + 0.0120535714285713*G0_0_1_0_1 + 0.0120535714285713*G0_0_1_0_2 - 0.0482142857142853*G0_0_1_0_4 - 0.0482142857142854*G0_0_1_0_5 + 0.0120535714285713*G0_0_1_1_0 + 0.00642857142857137*G0_0_1_1_1 + 0.00241071428571428*G0_0_1_1_2 - 0.00482142857142853*G0_0_1_1_3 - 0.0160714285714285*G0_0_1_1_4 - 0.0160714285714285*G0_0_1_1_5 + 0.0120535714285713*G0_0_1_2_0 + 0.00241071428571428*G0_0_1_2_1 + 0.00642857142857142*G0_0_1_2_2 - 0.00482142857142858*G0_0_1_2_3 - 0.0160714285714285*G0_0_1_2_4 - 0.0160714285714285*G0_0_1_2_5 - 0.00482142857142853*G0_0_1_3_1 - 0.00482142857142858*G0_0_1_3_2 + 0.0257142857142856*G0_0_1_3_3 + 0.032142857142857*G0_0_1_3_4 + 0.032142857142857*G0_0_1_3_5 - 0.0482142857142853*G0_0_1_4_0 - 0.0160714285714285*G0_0_1_4_1 - 0.0160714285714285*G0_0_1_4_2 + 0.032142857142857*G0_0_1_4_3 + 0.128571428571428*G0_0_1_4_4 + 0.0642857142857141*G0_0_1_4_5 - 0.0482142857142854*G0_0_1_5_0 - 0.0160714285714285*G0_0_1_5_1 - 0.0160714285714285*G0_0_1_5_2 + 0.032142857142857*G0_0_1_5_3 + 0.0642857142857141*G0_0_1_5_4 + 0.128571428571428*G0_0_1_5_5 + 0.26517857142857*G0_1_0_0_0 - 0.0120535714285713*G0_1_0_0_1 - 0.0120535714285713*G0_1_0_0_2 + 0.0482142857142853*G0_1_0_0_4 + 0.0482142857142854*G0_1_0_0_5 - 0.0120535714285713*G0_1_0_1_0 - 0.00642857142857137*G0_1_0_1_1 - 0.00241071428571428*G0_1_0_1_2 + 0.00482142857142853*G0_1_0_1_3 + 0.0160714285714285*G0_1_0_1_4 + 0.0160714285714285*G0_1_0_1_5 - 0.0120535714285713*G0_1_0_2_0 - 0.00241071428571428*G0_1_0_2_1 - 0.00642857142857142*G0_1_0_2_2 + 0.00482142857142858*G0_1_0_2_3 + 0.0160714285714285*G0_1_0_2_4 + 0.0160714285714285*G0_1_0_2_5 + 0.00482142857142853*G0_1_0_3_1 + 0.00482142857142858*G0_1_0_3_2 - 0.0257142857142856*G0_1_0_3_3 - 0.032142857142857*G0_1_0_3_4 - 0.032142857142857*G0_1_0_3_5 + 0.0482142857142853*G0_1_0_4_0 + 0.0160714285714285*G0_1_0_4_1 + 0.0160714285714285*G0_1_0_4_2 - 0.032142857142857*G0_1_0_4_3 - 0.128571428571428*G0_1_0_4_4 - 0.0642857142857141*G0_1_0_4_5 + 0.0482142857142854*G0_1_0_5_0 + 0.0160714285714285*G0_1_0_5_1 + 0.0160714285714285*G0_1_0_5_2 - 0.032142857142857*G0_1_0_5_3 - 0.0642857142857141*G0_1_0_5_4 - 0.128571428571428*G0_1_0_5_5;
    A[81] = -A[61] - 0.0198214285714284*G0_0_0_0_0 + 0.0126339285714285*G0_0_0_0_1 + 0.00486607142857141*G0_0_0_0_2 + 0.00553571428571424*G0_0_0_0_3 - 0.00321428571428568*G0_0_0_0_4 + 0.0126339285714285*G0_0_0_1_0 - 0.19017857142857*G0_0_0_1_1 + 0.0148660714285713*G0_0_0_1_2 - 0.0660714285714282*G0_0_0_1_3 + 0.0019642857142857*G0_0_0_1_4 - 0.0410714285714283*G0_0_0_1_5 + 0.00486607142857141*G0_0_0_2_0 + 0.0148660714285713*G0_0_0_2_1 - 0.0404464285714285*G0_0_0_2_2 + 0.0121428571428571*G0_0_0_2_3 - 0.0142857142857143*G0_0_0_2_4 + 0.00946428571428566*G0_0_0_2_5 + 0.00553571428571424*G0_0_0_3_0 - 0.0660714285714282*G0_0_0_3_1 + 0.0121428571428571*G0_0_0_3_2 - 0.0485714285714283*G0_0_0_3_3 - 0.0149999999999999*G0_0_0_3_4 - 0.0299999999999998*G0_0_0_3_5 - 0.00321428571428568*G0_0_0_4_0 + 0.0019642857142857*G0_0_0_4_1 - 0.0142857142857143*G0_0_0_4_2 - 0.0149999999999999*G0_0_0_4_3 - 0.0885714285714282*G0_0_0_4_4 - 0.0228571428571428*G0_0_0_4_5 - 0.0410714285714283*G0_0_0_5_1 + 0.00946428571428566*G0_0_0_5_2 - 0.0299999999999998*G0_0_0_5_3 - 0.0228571428571428*G0_0_0_5_4 - 0.0628571428571425*G0_0_0_5_5 - 0.0117857142857142*G0_1_0_0_0 + 0.0209374999999998*G0_1_0_0_1 - 0.00183035714285712*G0_1_0_0_2 + 0.0119642857142856*G0_1_0_0_3 + 0.00642857142857141*G0_1_0_0_4 + 0.0224999999999999*G0_1_0_0_5 + 0.0209374999999998*G0_1_0_1_0 - 0.243749999999999*G0_1_0_1_1 + 0.0204910714285713*G0_1_0_1_2 - 0.0874999999999995*G0_1_0_1_3 - 0.00660714285714283*G0_1_0_1_4 - 0.0946428571428566*G0_1_0_1_5 - 0.00183035714285712*G0_1_0_2_0 + 0.0204910714285713*G0_1_0_2_1 - 0.0286607142857143*G0_1_0_2_2 + 0.0174999999999999*G0_1_0_2_3 - 0.00571428571428572*G0_1_0_2_4 + 0.0116071428571428*G0_1_0_2_5 + 0.0119642857142856*G0_1_0_3_0 - 0.0874999999999995*G0_1_0_3_1 + 0.0174999999999999*G0_1_0_3_2 - 0.074285714285714*G0_1_0_3_3 - 0.0107142857142857*G0_1_0_3_4 - 0.0471428571428569*G0_1_0_3_5 + 0.00642857142857141*G0_1_0_4_0 - 0.00660714285714283*G0_1_0_4_1 - 0.00571428571428572*G0_1_0_4_2 - 0.0107142857142857*G0_1_0_4_3 + 0.0399999999999998*G0_1_0_4_4 - 0.00999999999999994*G0_1_0_4_5 + 0.0224999999999999*G0_1_0_5_0 - 0.0946428571428566*G0_1_0_5_1 + 0.0116071428571428*G0_1_0_5_2 - 0.0471428571428569*G0_1_0_5_3 - 0.00999999999999994*G0_1_0_5_4 - 0.088571428571428*G0_1_0_5_5;
    A[31] = -A[81] - 0.0230357142857141*G0_0_0_0_0 + 0.00758928571428565*G0_0_0_0_1 + 0.00508928571428569*G0_0_0_0_2 + 0.00714285714285708*G0_0_0_0_3 - 0.00571428571428568*G0_0_0_0_4 - 0.0017857142857143*G0_0_0_0_5 + 0.00758928571428565*G0_0_0_1_0 - 0.152678571428571*G0_0_0_1_1 + 0.00758928571428566*G0_0_0_1_2 - 0.0214285714285712*G0_0_0_1_3 + 0.00892857142857138*G0_0_0_1_4 - 0.0214285714285713*G0_0_0_1_5 + 0.00508928571428569*G0_0_0_2_0 + 0.00758928571428566*G0_0_0_2_1 - 0.0230357142857142*G0_0_0_2_2 - 0.0017857142857143*G0_0_0_2_3 - 0.00571428571428572*G0_0_0_2_4 + 0.00714285714285709*G0_0_0_2_5 + 0.00714285714285708*G0_0_0_3_0 - 0.0214285714285712*G0_0_0_3_1 - 0.0017857142857143*G0_0_0_3_2 - 0.0571428571428567*G0_0_0_3_3 - 0.032142857142857*G0_0_0_3_4 - 0.0285714285714284*G0_0_0_3_5 - 0.00571428571428568*G0_0_0_4_0 + 0.00892857142857138*G0_0_0_4_1 - 0.00571428571428572*G0_0_0_4_2 - 0.032142857142857*G0_0_0_4_3 - 0.109999999999999*G0_0_0_4_4 - 0.032142857142857*G0_0_0_4_5 - 0.0017857142857143*G0_0_0_5_0 - 0.0214285714285713*G0_0_0_5_1 + 0.00714285714285709*G0_0_0_5_2 - 0.0285714285714284*G0_0_0_5_3 - 0.032142857142857*G0_0_0_5_4 - 0.0571428571428569*G0_0_0_5_5;
    A[63] = -A[68] - 0.0024107142857143*G0_0_0_0_0 - 0.000401785714285708*G0_0_0_0_1 - 0.0164732142857142*G0_0_0_0_2 + 0.00642857142857138*G0_0_0_0_3 - 0.0257142857142856*G0_0_0_0_4 - 0.00160714285714286*G0_0_0_0_5 - 0.000401785714285708*G0_0_0_1_0 - 0.0080357142857143*G0_0_0_1_1 - 0.00441964285714284*G0_0_0_1_2 + 0.0160714285714285*G0_0_0_1_3 - 0.0032142857142857*G0_0_0_1_4 - 0.0164732142857142*G0_0_0_2_0 - 0.00441964285714284*G0_0_0_2_1 + 0.168749999999999*G0_0_0_2_2 + 0.00803571428571432*G0_0_0_2_3 + 0.0883928571428568*G0_0_0_2_4 - 0.00321428571428567*G0_0_0_2_5 + 0.00642857142857138*G0_0_0_3_0 + 0.0160714285714285*G0_0_0_3_1 + 0.00803571428571433*G0_0_0_3_2 - 0.154285714285714*G0_0_0_3_3 - 0.0064285714285714*G0_0_0_3_4 - 0.00642857142857141*G0_0_0_3_5 - 0.0257142857142856*G0_0_0_4_0 - 0.0032142857142857*G0_0_0_4_1 + 0.0883928571428568*G0_0_0_4_2 - 0.0064285714285714*G0_0_0_4_3 + 0.167142857142856*G0_0_0_4_4 + 0.0128571428571429*G0_0_0_4_5 - 0.00160714285714286*G0_0_0_5_0 - 0.00321428571428567*G0_0_0_5_2 - 0.00642857142857141*G0_0_0_5_3 + 0.0128571428571429*G0_0_0_5_4 + 0.0385714285714286*G0_0_0_5_5 + 0.041785714285714*G0_1_0_0_0 + 0.0028125*G0_1_0_0_1 - 0.00281249999999998*G0_1_0_0_2 - 0.0144642857142857*G0_1_0_0_3 - 0.0241071428571428*G0_1_0_0_4 - 0.0192857142857142*G0_1_0_0_5 + 0.0028125*G0_1_0_1_0 - 0.00120535714285715*G0_1_0_1_2 - 0.00160714285714285*G0_1_0_1_4 - 0.00281249999999998*G0_1_0_2_0 - 0.00120535714285715*G0_1_0_2_1 + 0.124553571428571*G0_1_0_2_2 - 0.00964285714285701*G0_1_0_2_3 + 0.0337499999999999*G0_1_0_2_4 - 0.00803571428571425*G0_1_0_2_5 - 0.0144642857142857*G0_1_0_3_0 - 0.00964285714285701*G0_1_0_3_2 - 0.0128571428571424*G0_1_0_3_3 + 0.032142857142857*G0_1_0_3_4 + 0.0449999999999999*G0_1_0_3_5 - 0.0241071428571428*G0_1_0_4_0 - 0.00160714285714284*G0_1_0_4_1 + 0.0337499999999999*G0_1_0_4_2 + 0.032142857142857*G0_1_0_4_3 - 0.179999999999999*G0_1_0_4_4 + 0.0192857142857142*G0_1_0_4_5 - 0.0192857142857142*G0_1_0_5_0 - 0.00803571428571425*G0_1_0_5_2 + 0.0449999999999999*G0_1_0_5_3 + 0.0192857142857142*G0_1_0_5_4 - 0.0771428571428565*G0_1_0_5_5;
    A[45] = -A[63] + 0.00642857142857141*G0_0_0_0_0 - 0.00160714285714286*G0_0_0_0_1 - 0.0241071428571427*G0_0_0_0_2 + 0.00321428571428571*G0_0_0_0_5 - 0.00160714285714286*G0_0_0_1_0 + 0.0064285714285714*G0_0_0_1_1 - 0.0241071428571427*G0_0_0_1_2 + 0.0032142857142857*G0_0_0_1_5 - 0.0241071428571427*G0_0_0_2_0 - 0.0241071428571427*G0_0_0_2_1 + 0.337499999999999*G0_0_0_2_2 + 0.0964285714285709*G0_0_0_2_3 + 0.0964285714285709*G0_0_0_2_4 + 0.0964285714285709*G0_0_0_3_2 + 0.0964285714285709*G0_0_0_4_2 + 0.00321428571428571*G0_0_0_5_0 + 0.0032142857142857*G0_0_0_5_1 + 0.0257142857142856*G0_0_0_5_5 - 0.0112500000000001*G0_0_1_0_0 - 0.000803571428571427*G0_0_1_0_1 - 0.00401785714285708*G0_0_1_0_2 - 0.00642857142857137*G0_0_1_0_3 + 0.00642857142857141*G0_0_1_0_4 - 0.0080357142857143*G0_0_1_0_5 - 0.000803571428571428*G0_0_1_1_0 + 0.0176785714285714*G0_0_1_1_1 - 0.0200892857142856*G0_0_1_1_2 - 0.00642857142857136*G0_0_1_1_3 + 0.00642857142857141*G0_0_1_1_4 + 0.01125*G0_0_1_1_5 - 0.00401785714285708*G0_0_1_2_0 - 0.0200892857142856*G0_0_1_2_1 + 0.168749999999999*G0_0_1_2_2 + 0.0803571428571424*G0_0_1_2_3 + 0.0160714285714284*G0_0_1_2_4 - 0.00642857142857137*G0_0_1_3_0 - 0.00642857142857137*G0_0_1_3_1 + 0.0803571428571424*G0_0_1_3_2 + 0.128571428571428*G0_0_1_3_3 + 0.0128571428571428*G0_0_1_3_5 + 0.0064285714285714*G0_0_1_4_0 + 0.00642857142857141*G0_0_1_4_1 + 0.0160714285714284*G0_0_1_4_2 - 0.128571428571428*G0_0_1_4_4 - 0.0128571428571428*G0_0_1_4_5 - 0.0080357142857143*G0_0_1_5_0 + 0.01125*G0_0_1_5_1 + 0.0128571428571428*G0_0_1_5_3 - 0.0128571428571428*G0_0_1_5_4 + 0.0128571428571428*G0_0_1_5_5 + 0.00241071428571434*G0_1_0_0_0 - 0.00080357142857144*G0_1_0_0_1 - 0.00803571428571423*G0_1_0_0_2 - 0.0128571428571428*G0_1_0_0_3 - 0.0032142857142857*G0_1_0_0_4 - 0.00160714285714286*G0_1_0_0_5 - 0.000803571428571439*G0_1_0_1_0 + 0.00401785714285723*G0_1_0_1_1 - 0.0160714285714285*G0_1_0_1_2 + 0.00321428571428575*G0_1_0_1_3 + 0.0128571428571428*G0_1_0_1_4 + 0.0048214285714286*G0_1_0_1_5 - 0.00803571428571423*G0_1_0_2_0 - 0.0160714285714285*G0_1_0_2_1 + 0.168749999999999*G0_1_0_2_2 + 0.0482142857142855*G0_1_0_2_3 + 0.0482142857142855*G0_1_0_2_4 - 0.0128571428571428*G0_1_0_3_0 + 0.00321428571428575*G0_1_0_3_1 + 0.0482142857142854*G0_1_0_3_2 + 0.192857142857142*G0_1_0_3_3 + 0.0257142857142857*G0_1_0_3_5 - 0.0032142857142857*G0_1_0_4_0 + 0.0128571428571428*G0_1_0_4_1 + 0.0482142857142855*G0_1_0_4_2 - 0.192857142857142*G0_1_0_4_4 - 0.0257142857142856*G0_1_0_4_5 - 0.00160714285714286*G0_1_0_5_0 + 0.0048214285714286*G0_1_0_5_1 + 0.0257142857142857*G0_1_0_5_3 - 0.0257142857142856*G0_1_0_5_4 + 0.0128571428571429*G0_1_0_5_5 - 0.0112500000000002*G0_1_1_0_0 + 0.000401785714285729*G0_1_1_0_1 - 0.00200892857142853*G0_1_1_0_2 - 0.00160714285714284*G0_1_1_0_3 + 0.00964285714285702*G0_1_1_0_4 - 0.00321428571428582*G0_1_1_0_5 + 0.000401785714285729*G0_1_1_1_0 + 0.00401785714285719*G0_1_1_1_1 - 0.0140624999999999*G0_1_1_1_2 + 0.00642857142857143*G0_1_1_1_3 + 0.0176785714285713*G0_1_1_1_4 + 0.00964285714285713*G0_1_1_1_5 - 0.00200892857142853*G0_1_1_2_0 - 0.0140624999999999*G0_1_1_2_1 + 0.0482142857142854*G0_1_1_2_2 + 0.0482142857142854*G0_1_1_2_3 + 0.0160714285714285*G0_1_1_2_4 + 0.00803571428571426*G0_1_1_2_5 - 0.00160714285714284*G0_1_1_3_0 + 0.00642857142857143*G0_1_1_3_1 + 0.0482142857142854*G0_1_1_3_2 + 0.192857142857142*G0_1_1_3_3 - 0.0321428571428569*G0_1_1_3_4 - 0.0128571428571427*G0_1_1_3_5 + 0.00964285714285702*G0_1_1_4_0 + 0.0176785714285713*G0_1_1_4_1 + 0.0160714285714285*G0_1_1_4_2 - 0.0321428571428569*G0_1_1_4_3 - 0.128571428571428*G0_1_1_4_4 - 0.0514285714285712*G0_1_1_4_5 - 0.00321428571428582*G0_1_1_5_0 + 0.00964285714285713*G0_1_1_5_1 + 0.00803571428571426*G0_1_1_5_2 - 0.0128571428571427*G0_1_1_5_3 - 0.0514285714285712*G0_1_1_5_4 - 0.102857142857142*G0_1_1_5_5;
    A[36] = A[63] + 0.00160714285714288*G0_0_1_0_0 + 0.00200892857142857*G0_0_1_0_1 - 0.00361607142857142*G0_0_1_0_2 - 0.00482142857142857*G0_0_1_0_3 - 0.00803571428571428*G0_0_1_0_4 - 0.0032142857142857*G0_0_1_0_5 + 0.00200892857142857*G0_0_1_1_0 - 0.0120535714285714*G0_0_1_1_1 + 0.000401785714285697*G0_0_1_1_2 + 0.00160714285714283*G0_0_1_1_3 + 0.00160714285714284*G0_0_1_1_4 - 0.00964285714285713*G0_0_1_1_5 - 0.00361607142857142*G0_0_1_2_0 + 0.000401785714285697*G0_0_1_2_1 + 0.1125*G0_0_1_2_2 - 0.00803571428571419*G0_0_1_2_3 + 0.0241071428571428*G0_0_1_2_4 - 0.00482142857142853*G0_0_1_2_5 - 0.00482142857142857*G0_0_1_3_0 + 0.00160714285714283*G0_0_1_3_1 - 0.00803571428571418*G0_0_1_3_2 - 0.038571428571428*G0_0_1_3_3 + 0.00642857142857144*G0_0_1_3_4 + 0.0192857142857142*G0_0_1_3_5 - 0.00803571428571428*G0_0_1_4_0 + 0.00160714285714285*G0_0_1_4_1 + 0.0241071428571428*G0_0_1_4_2 + 0.00642857142857144*G0_0_1_4_3 - 0.102857142857142*G0_0_1_4_4 + 0.00642857142857141*G0_0_1_4_5 - 0.0032142857142857*G0_0_1_5_0 - 0.00964285714285713*G0_0_1_5_1 - 0.00482142857142853*G0_0_1_5_2 + 0.0192857142857142*G0_0_1_5_3 + 0.00642857142857141*G0_0_1_5_4 - 0.00160714285714288*G0_1_0_0_0 - 0.00200892857142857*G0_1_0_0_1 + 0.00361607142857142*G0_1_0_0_2 + 0.00482142857142857*G0_1_0_0_3 + 0.00803571428571428*G0_1_0_0_4 + 0.0032142857142857*G0_1_0_0_5 - 0.00200892857142857*G0_1_0_1_0 + 0.0120535714285714*G0_1_0_1_1 - 0.000401785714285698*G0_1_0_1_2 - 0.00160714285714283*G0_1_0_1_3 - 0.00160714285714285*G0_1_0_1_4 + 0.00964285714285713*G0_1_0_1_5 + 0.00361607142857142*G0_1_0_2_0 - 0.000401785714285698*G0_1_0_2_1 - 0.1125*G0_1_0_2_2 + 0.00803571428571419*G0_1_0_2_3 - 0.0241071428571428*G0_1_0_2_4 + 0.00482142857142853*G0_1_0_2_5 + 0.00482142857142857*G0_1_0_3_0 - 0.00160714285714283*G0_1_0_3_1 + 0.00803571428571419*G0_1_0_3_2 + 0.038571428571428*G0_1_0_3_3 - 0.00642857142857143*G0_1_0_3_4 - 0.0192857142857142*G0_1_0_3_5 + 0.00803571428571428*G0_1_0_4_0 - 0.00160714285714285*G0_1_0_4_1 - 0.0241071428571428*G0_1_0_4_2 - 0.00642857142857143*G0_1_0_4_3 + 0.102857142857142*G0_1_0_4_4 - 0.00642857142857141*G0_1_0_4_5 + 0.0032142857142857*G0_1_0_5_0 + 0.00964285714285713*G0_1_0_5_1 + 0.00482142857142853*G0_1_0_5_2 - 0.0192857142857142*G0_1_0_5_3 - 0.0064285714285714*G0_1_0_5_4;
    A[86] = -A[36] - 0.0024107142857143*G0_0_0_0_0 - 0.000401785714285708*G0_0_0_0_1 - 0.0164732142857142*G0_0_0_0_2 + 0.00642857142857138*G0_0_0_0_3 - 0.0257142857142856*G0_0_0_0_4 - 0.00160714285714285*G0_0_0_0_5 - 0.000401785714285708*G0_0_0_1_0 - 0.0080357142857143*G0_0_0_1_1 - 0.00441964285714284*G0_0_0_1_2 + 0.0160714285714285*G0_0_0_1_3 - 0.0032142857142857*G0_0_0_1_4 - 0.0164732142857142*G0_0_0_2_0 - 0.00441964285714284*G0_0_0_2_1 + 0.168749999999999*G0_0_0_2_2 + 0.00803571428571432*G0_0_0_2_3 + 0.0883928571428568*G0_0_0_2_4 - 0.00321428571428567*G0_0_0_2_5 + 0.00642857142857138*G0_0_0_3_0 + 0.0160714285714285*G0_0_0_3_1 + 0.00803571428571433*G0_0_0_3_2 - 0.154285714285714*G0_0_0_3_3 - 0.0064285714285714*G0_0_0_3_4 - 0.00642857142857141*G0_0_0_3_5 - 0.0257142857142856*G0_0_0_4_0 - 0.0032142857142857*G0_0_0_4_1 + 0.0883928571428568*G0_0_0_4_2 - 0.0064285714285714*G0_0_0_4_3 + 0.167142857142856*G0_0_0_4_4 + 0.0128571428571429*G0_0_0_4_5 - 0.00160714285714286*G0_0_0_5_0 - 0.00321428571428567*G0_0_0_5_2 - 0.00642857142857141*G0_0_0_5_3 + 0.0128571428571429*G0_0_0_5_4 + 0.0385714285714286*G0_0_0_5_5 + 0.041785714285714*G0_0_1_0_0 + 0.00281249999999999*G0_0_1_0_1 - 0.00281249999999998*G0_0_1_0_2 - 0.0144642857142857*G0_0_1_0_3 - 0.0241071428571428*G0_0_1_0_4 - 0.0192857142857142*G0_0_1_0_5 + 0.00281249999999999*G0_0_1_1_0 - 0.00120535714285715*G0_0_1_1_2 - 0.00160714285714285*G0_0_1_1_4 - 0.00281249999999998*G0_0_1_2_0 - 0.00120535714285715*G0_0_1_2_1 + 0.124553571428571*G0_0_1_2_2 - 0.00964285714285701*G0_0_1_2_3 + 0.0337499999999999*G0_0_1_2_4 - 0.00803571428571425*G0_0_1_2_5 - 0.0144642857142857*G0_0_1_3_0 - 0.00964285714285701*G0_0_1_3_2 - 0.0128571428571424*G0_0_1_3_3 + 0.032142857142857*G0_0_1_3_4 + 0.0449999999999999*G0_0_1_3_5 - 0.0241071428571428*G0_0_1_4_0 - 0.00160714285714285*G0_0_1_4_1 + 0.0337499999999999*G0_0_1_4_2 + 0.032142857142857*G0_0_1_4_3 - 0.179999999999999*G0_0_1_4_4 + 0.0192857142857142*G0_0_1_4_5 - 0.0192857142857142*G0_0_1_5_0 - 0.00803571428571425*G0_0_1_5_2 + 0.0449999999999999*G0_0_1_5_3 + 0.0192857142857142*G0_0_1_5_4 - 0.0771428571428565*G0_0_1_5_5;
    A[54] = A[45] + 0.0120535714285715*G0_0_1_0_0 - 0.00200892857142858*G0_0_1_0_1 - 0.000401785714285727*G0_0_1_0_2 - 0.00160714285714284*G0_0_1_0_3 - 0.00160714285714282*G0_0_1_0_4 + 0.00964285714285714*G0_0_1_0_5 - 0.00200892857142858*G0_0_1_1_0 - 0.00160714285714275*G0_0_1_1_1 + 0.00361607142857141*G0_0_1_1_2 + 0.00803571428571428*G0_0_1_1_3 + 0.00482142857142854*G0_0_1_1_4 + 0.00321428571428573*G0_0_1_1_5 - 0.000401785714285726*G0_0_1_2_0 + 0.00361607142857141*G0_0_1_2_1 - 0.1125*G0_0_1_2_2 - 0.0241071428571428*G0_0_1_2_3 + 0.00803571428571423*G0_0_1_2_4 + 0.00482142857142851*G0_0_1_2_5 - 0.00160714285714284*G0_0_1_3_0 + 0.00803571428571428*G0_0_1_3_1 - 0.0241071428571428*G0_0_1_3_2 + 0.102857142857142*G0_0_1_3_3 - 0.00642857142857136*G0_0_1_3_4 - 0.00642857142857136*G0_0_1_3_5 - 0.00160714285714282*G0_0_1_4_0 + 0.00482142857142854*G0_0_1_4_1 + 0.00803571428571423*G0_0_1_4_2 - 0.00642857142857136*G0_0_1_4_3 + 0.0385714285714285*G0_0_1_4_4 - 0.0192857142857141*G0_0_1_4_5 + 0.00964285714285714*G0_0_1_5_0 + 0.00321428571428573*G0_0_1_5_1 + 0.00482142857142851*G0_0_1_5_2 - 0.00642857142857136*G0_0_1_5_3 - 0.0192857142857141*G0_0_1_5_4 - 0.0120535714285715*G0_1_0_0_0 + 0.00200892857142858*G0_1_0_0_1 + 0.000401785714285728*G0_1_0_0_2 + 0.00160714285714284*G0_1_0_0_3 + 0.00160714285714282*G0_1_0_0_4 - 0.00964285714285714*G0_1_0_0_5 + 0.00200892857142858*G0_1_0_1_0 + 0.00160714285714275*G0_1_0_1_1 - 0.00361607142857141*G0_1_0_1_2 - 0.00803571428571428*G0_1_0_1_3 - 0.00482142857142854*G0_1_0_1_4 - 0.00321428571428573*G0_1_0_1_5 + 0.000401785714285727*G0_1_0_2_0 - 0.00361607142857141*G0_1_0_2_1 + 0.1125*G0_1_0_2_2 + 0.0241071428571428*G0_1_0_2_3 - 0.00803571428571423*G0_1_0_2_4 - 0.00482142857142851*G0_1_0_2_5 + 0.00160714285714284*G0_1_0_3_0 - 0.00803571428571428*G0_1_0_3_1 + 0.0241071428571428*G0_1_0_3_2 - 0.102857142857142*G0_1_0_3_3 + 0.00642857142857136*G0_1_0_3_4 + 0.00642857142857136*G0_1_0_3_5 + 0.00160714285714282*G0_1_0_4_0 - 0.00482142857142854*G0_1_0_4_1 - 0.00803571428571422*G0_1_0_4_2 + 0.00642857142857136*G0_1_0_4_3 - 0.0385714285714285*G0_1_0_4_4 + 0.0192857142857141*G0_1_0_4_5 - 0.00964285714285714*G0_1_0_5_0 - 0.00321428571428573*G0_1_0_5_1 - 0.00482142857142851*G0_1_0_5_2 + 0.00642857142857137*G0_1_0_5_3 + 0.0192857142857141*G0_1_0_5_4;
    A[35] = -A[36] + 0.0104464285714285*G0_0_0_0_0 - 0.00241071428571428*G0_0_0_0_1 - 0.0192857142857142*G0_0_0_0_2 - 0.00964285714285705*G0_0_0_0_4 + 0.00482142857142855*G0_0_0_0_5 - 0.00241071428571428*G0_0_0_1_0 + 0.0120535714285714*G0_0_0_1_1 - 0.0112499999999999*G0_0_0_1_2 + 0.0289285714285713*G0_0_0_1_3 - 0.0064285714285714*G0_0_0_1_4 + 0.0112499999999999*G0_0_0_1_5 - 0.0192857142857142*G0_0_0_2_0 - 0.0112499999999999*G0_0_0_2_1 + 0.120535714285714*G0_0_0_2_2 + 0.0160714285714285*G0_0_0_2_3 + 0.0803571428571424*G0_0_0_2_4 + 0.00642857142857141*G0_0_0_2_5 + 0.0289285714285713*G0_0_0_3_1 + 0.0160714285714285*G0_0_0_3_2 + 0.0514285714285708*G0_0_0_3_3 + 0.0128571428571428*G0_0_0_3_4 - 0.0128571428571428*G0_0_0_3_5 - 0.00964285714285705*G0_0_0_4_0 - 0.0064285714285714*G0_0_0_4_1 + 0.0803571428571424*G0_0_0_4_2 + 0.0128571428571428*G0_0_0_4_3 + 0.308571428571427*G0_0_0_4_4 + 0.00482142857142855*G0_0_0_5_0 + 0.0112499999999999*G0_0_0_5_1 + 0.00642857142857142*G0_0_0_5_2 - 0.0128571428571428*G0_0_0_5_3 - 0.0257142857142856*G0_0_0_5_5 - 0.00562500000000003*G0_0_1_0_0 + 0.000803571428571429*G0_0_1_0_1 - 0.00642857142857138*G0_0_1_0_2 - 0.00803571428571424*G0_0_1_0_3 - 0.0192857142857142*G0_0_1_0_4 - 0.00160714285714288*G0_0_1_0_5 + 0.00080357142857143*G0_0_1_1_0 + 0.00803571428571425*G0_0_1_1_1 - 0.00723214285714282*G0_0_1_1_2 + 0.0160714285714285*G0_0_1_1_3 - 0.00160714285714284*G0_0_1_1_4 - 0.00642857142857138*G0_0_1_2_0 - 0.00723214285714282*G0_0_1_2_1 + 0.0843749999999996*G0_0_1_2_2 + 0.00482142857142855*G0_0_1_2_3 + 0.0433928571428569*G0_0_1_2_4 + 0.00160714285714286*G0_0_1_2_5 - 0.00803571428571424*G0_0_1_3_0 + 0.0160714285714285*G0_0_1_3_1 + 0.00482142857142855*G0_0_1_3_2 + 0.115714285714285*G0_0_1_3_3 + 0.0192857142857142*G0_0_1_3_4 + 0.0128571428571429*G0_0_1_3_5 - 0.0192857142857142*G0_0_1_4_0 - 0.00160714285714284*G0_0_1_4_1 + 0.0433928571428569*G0_0_1_4_2 + 0.0192857142857142*G0_0_1_4_3 + 0.0385714285714284*G0_0_1_4_4 - 0.00160714285714288*G0_0_1_5_0 + 0.00160714285714287*G0_0_1_5_2 + 0.0128571428571428*G0_0_1_5_3 - 0.0128571428571428*G0_0_1_5_5 + 0.00482142857142853*G0_1_0_0_0 - 0.00281249999999998*G0_1_0_0_1 - 0.00200892857142854*G0_1_0_0_2 - 0.00642857142857137*G0_1_0_0_3 - 0.0016071428571428*G0_1_0_0_4 - 0.00281249999999998*G0_1_0_1_0 + 0.0321428571428569*G0_1_0_1_1 - 0.0068303571428571*G0_1_0_1_2 + 0.0241071428571427*G0_1_0_1_3 - 0.00642857142857138*G0_1_0_1_4 + 0.00803571428571424*G0_1_0_1_5 - 0.00200892857142854*G0_1_0_2_0 - 0.0068303571428571*G0_1_0_2_1 + 0.0120535714285712*G0_1_0_2_2 - 0.00321428571428571*G0_1_0_2_3 + 0.00321428571428561*G0_1_0_2_4 - 0.0032142857142857*G0_1_0_2_5 - 0.00642857142857137*G0_1_0_3_0 + 0.0241071428571427*G0_1_0_3_1 - 0.00321428571428571*G0_1_0_3_2 + 0.0771428571428567*G0_1_0_3_3 + 0.0257142857142855*G0_1_0_3_4 + 0.0192857142857142*G0_1_0_3_5 - 0.0016071428571428*G0_1_0_4_0 - 0.00642857142857138*G0_1_0_4_1 + 0.00321428571428561*G0_1_0_4_2 + 0.0257142857142855*G0_1_0_4_3 + 0.0642857142857138*G0_1_0_4_4 + 0.0192857142857142*G0_1_0_4_5 + 0.00803571428571424*G0_1_0_5_1 - 0.0032142857142857*G0_1_0_5_2 + 0.0192857142857142*G0_1_0_5_3 + 0.0192857142857142*G0_1_0_5_4 + 0.0128571428571428*G0_1_0_5_5 - 0.00723214285714275*G0_1_1_0_0 + 0.00401785714285711*G0_1_1_0_1 - 0.00321428571428569*G0_1_1_0_3 - 0.00482142857142853*G0_1_1_0_4 + 0.00321428571428571*G0_1_1_0_5 + 0.00401785714285711*G0_1_1_1_0 - 0.00401785714285712*G0_1_1_1_2 + 0.0160714285714285*G0_1_1_1_3 - 0.0160714285714285*G0_1_1_1_5 - 0.00401785714285712*G0_1_1_2_1 + 0.00723214285714273*G0_1_1_2_2 - 0.00321428571428571*G0_1_1_2_3 + 0.0048214285714285*G0_1_1_2_4 + 0.00321428571428569*G0_1_1_2_5 - 0.00321428571428569*G0_1_1_3_0 + 0.0160714285714285*G0_1_1_3_1 - 0.00321428571428571*G0_1_1_3_2 + 0.0642857142857139*G0_1_1_3_3 + 0.00642857142857138*G0_1_1_3_4 - 0.00482142857142853*G0_1_1_4_0 + 0.0048214285714285*G0_1_1_4_2 + 0.00642857142857138*G0_1_1_4_3 - 0.00642857142857139*G0_1_1_4_5 + 0.00321428571428571*G0_1_1_5_0 - 0.0160714285714285*G0_1_1_5_1 + 0.00321428571428569*G0_1_1_5_2 - 0.00642857142857139*G0_1_1_5_4 - 0.0642857142857139*G0_1_1_5_5;
    A[85] = -A[35] + 0.0441964285714284*G0_0_0_0_0 - 0.00321428571428572*G0_0_0_0_1 - 0.0136607142857142*G0_0_0_0_2 + 0.00482142857142857*G0_0_0_0_3 + 0.0546428571428569*G0_0_0_0_4 + 0.0176785714285714*G0_0_0_0_5 - 0.00321428571428571*G0_0_0_1_0 - 0.0080357142857141*G0_0_0_1_1 - 0.00321428571428569*G0_0_0_1_2 - 0.00160714285714286*G0_0_0_1_4 + 0.0160714285714285*G0_0_0_1_5 - 0.0136607142857142*G0_0_0_2_0 - 0.00321428571428569*G0_0_0_2_1 - 0.0441964285714285*G0_0_0_2_2 + 0.0176785714285713*G0_0_0_2_3 - 0.00160714285714287*G0_0_0_2_4 + 0.020892857142857*G0_0_0_2_5 + 0.00482142857142857*G0_0_0_3_0 + 0.0176785714285713*G0_0_0_3_2 + 0.115714285714285*G0_0_0_3_3 - 0.00642857142857136*G0_0_0_3_4 - 0.0514285714285712*G0_0_0_3_5 + 0.0546428571428569*G0_0_0_4_0 - 0.00160714285714286*G0_0_0_4_1 - 0.00160714285714287*G0_0_0_4_2 - 0.00642857142857137*G0_0_0_4_3 + 0.347142857142856*G0_0_0_4_4 - 0.0385714285714283*G0_0_0_4_5 + 0.0176785714285714*G0_0_0_5_0 + 0.0160714285714285*G0_0_0_5_1 + 0.020892857142857*G0_0_0_5_2 - 0.0514285714285712*G0_0_0_5_3 - 0.0385714285714283*G0_0_0_5_4 - 0.141428571428571*G0_0_0_5_5 - 0.124553571428571*G0_0_1_0_0 + 0.00120535714285713*G0_0_1_0_1 + 0.00281249999999998*G0_0_1_0_2 + 0.00803571428571425*G0_0_1_0_3 - 0.0337499999999998*G0_0_1_0_4 + 0.00964285714285712*G0_0_1_0_5 + 0.00120535714285713*G0_0_1_1_0 - 0.00281249999999998*G0_0_1_1_2 + 0.00160714285714285*G0_0_1_1_4 + 0.00281249999999998*G0_0_1_2_0 - 0.00281249999999998*G0_0_1_2_1 - 0.0417857142857142*G0_0_1_2_2 + 0.0192857142857141*G0_0_1_2_3 + 0.0241071428571427*G0_0_1_2_4 + 0.0144642857142857*G0_0_1_2_5 + 0.00803571428571425*G0_0_1_3_0 + 0.0192857142857141*G0_0_1_3_2 + 0.0771428571428564*G0_0_1_3_3 - 0.0192857142857142*G0_0_1_3_4 - 0.0449999999999998*G0_0_1_3_5 - 0.0337499999999998*G0_0_1_4_0 + 0.00160714285714285*G0_0_1_4_1 + 0.0241071428571427*G0_0_1_4_2 - 0.0192857142857142*G0_0_1_4_3 + 0.179999999999999*G0_0_1_4_4 - 0.032142857142857*G0_0_1_4_5 + 0.00964285714285712*G0_0_1_5_0 + 0.0144642857142857*G0_0_1_5_2 - 0.0449999999999998*G0_0_1_5_3 - 0.032142857142857*G0_0_1_5_4 + 0.0128571428571426*G0_0_1_5_5;
    A[58] = A[85] + 0.112499999999999*G0_0_1_0_0 + 0.000401785714285709*G0_0_1_0_1 - 0.00361607142857139*G0_0_1_0_2 - 0.00482142857142854*G0_0_1_0_3 + 0.0241071428571426*G0_0_1_0_4 - 0.00803571428571431*G0_0_1_0_5 + 0.000401785714285709*G0_0_1_1_0 - 0.0120535714285712*G0_0_1_1_1 + 0.00200892857142856*G0_0_1_1_2 - 0.00964285714285711*G0_0_1_1_3 + 0.00160714285714286*G0_0_1_1_4 + 0.0016071428571429*G0_0_1_1_5 - 0.00361607142857139*G0_0_1_2_0 + 0.00200892857142855*G0_0_1_2_1 + 0.00160714285714287*G0_0_1_2_2 - 0.00321428571428566*G0_0_1_2_3 - 0.00803571428571423*G0_0_1_2_4 - 0.00482142857142856*G0_0_1_2_5 - 0.00482142857142854*G0_0_1_3_0 - 0.00964285714285711*G0_0_1_3_1 - 0.00321428571428566*G0_0_1_3_2 + 0.00642857142857137*G0_0_1_3_4 + 0.0192857142857142*G0_0_1_3_5 + 0.0241071428571426*G0_0_1_4_0 + 0.00160714285714286*G0_0_1_4_1 - 0.00803571428571423*G0_0_1_4_2 + 0.00642857142857137*G0_0_1_4_3 - 0.102857142857143*G0_0_1_4_4 + 0.00642857142857138*G0_0_1_4_5 - 0.00803571428571431*G0_0_1_5_0 + 0.0016071428571429*G0_0_1_5_1 - 0.00482142857142856*G0_0_1_5_2 + 0.0192857142857142*G0_0_1_5_3 + 0.00642857142857137*G0_0_1_5_4 - 0.0385714285714282*G0_0_1_5_5 - 0.112499999999999*G0_1_0_0_0 - 0.000401785714285708*G0_1_0_0_1 + 0.0036160714285714*G0_1_0_0_2 + 0.00482142857142854*G0_1_0_0_3 - 0.0241071428571427*G0_1_0_0_4 + 0.0080357142857143*G0_1_0_0_5 - 0.000401785714285708*G0_1_0_1_0 + 0.0120535714285712*G0_1_0_1_1 - 0.00200892857142856*G0_1_0_1_2 + 0.00964285714285711*G0_1_0_1_3 - 0.00160714285714286*G0_1_0_1_4 - 0.0016071428571429*G0_1_0_1_5 + 0.0036160714285714*G0_1_0_2_0 - 0.00200892857142855*G0_1_0_2_1 - 0.00160714285714287*G0_1_0_2_2 + 0.00321428571428566*G0_1_0_2_3 + 0.00803571428571423*G0_1_0_2_4 + 0.00482142857142856*G0_1_0_2_5 + 0.00482142857142854*G0_1_0_3_0 + 0.00964285714285711*G0_1_0_3_1 + 0.00321428571428566*G0_1_0_3_2 - 0.00642857142857137*G0_1_0_3_4 - 0.0192857142857142*G0_1_0_3_5 - 0.0241071428571427*G0_1_0_4_0 - 0.00160714285714286*G0_1_0_4_1 + 0.00803571428571423*G0_1_0_4_2 - 0.00642857142857137*G0_1_0_4_3 + 0.102857142857143*G0_1_0_4_4 - 0.00642857142857138*G0_1_0_4_5 + 0.00803571428571431*G0_1_0_5_0 - 0.0016071428571429*G0_1_0_5_1 + 0.00482142857142856*G0_1_0_5_2 - 0.0192857142857142*G0_1_0_5_3 - 0.00642857142857137*G0_1_0_5_4 + 0.0385714285714282*G0_1_0_5_5;
    A[65] = -A[45] + 0.00401785714285716*G0_1_0_0_0 - 0.00562499999999997*G0_1_0_0_1 + 0.00803571428571424*G0_1_0_0_2 + 0.00964285714285709*G0_1_0_0_3 + 0.00642857142857132*G0_1_0_0_4 + 0.0176785714285713*G0_1_0_0_5 - 0.00562499999999997*G0_1_0_1_0 - 0.00723214285714272*G0_1_0_1_1 + 0.0257142857142856*G0_1_0_1_3 + 0.0546428571428569*G0_1_0_1_4 + 0.0208928571428571*G0_1_0_1_5 + 0.00803571428571424*G0_1_0_2_0 - 0.120535714285714*G0_1_0_2_2 - 0.0160714285714285*G0_1_0_2_3 + 0.0160714285714285*G0_1_0_2_4 + 0.0160714285714285*G0_1_0_2_5 + 0.00964285714285709*G0_1_0_3_0 + 0.0257142857142856*G0_1_0_3_1 - 0.0160714285714285*G0_1_0_3_2 + 0.0642857142857141*G0_1_0_3_3 - 0.128571428571428*G0_1_0_3_4 - 0.0514285714285712*G0_1_0_3_5 + 0.00642857142857132*G0_1_0_4_0 + 0.0546428571428569*G0_1_0_4_1 + 0.0160714285714285*G0_1_0_4_2 - 0.128571428571428*G0_1_0_4_3 - 0.578571428571426*G0_1_0_4_4 - 0.141428571428571*G0_1_0_4_5 + 0.0176785714285713*G0_1_0_5_0 + 0.0208928571428571*G0_1_0_5_1 + 0.0160714285714285*G0_1_0_5_2 - 0.0514285714285712*G0_1_0_5_3 - 0.141428571428571*G0_1_0_5_4 - 0.0385714285714284*G0_1_0_5_5 - 0.164732142857142*G0_1_1_0_0 + 0.0108482142857142*G0_1_1_0_1 + 0.0124553571428571*G0_1_1_0_2 + 0.0128571428571428*G0_1_1_0_3 - 0.00160714285714286*G0_1_1_0_4 - 0.0707142857142854*G0_1_1_0_5 + 0.0108482142857142*G0_1_1_1_0 - 0.00482142857142853*G0_1_1_1_1 + 0.000401785714285709*G0_1_1_1_2 + 0.0273214285714284*G0_1_1_1_3 + 0.0482142857142855*G0_1_1_1_4 + 0.0466071428571426*G0_1_1_1_5 + 0.0124553571428571*G0_1_1_2_0 + 0.000401785714285709*G0_1_1_2_1 - 0.1125*G0_1_1_2_2 - 0.0160714285714285*G0_1_1_2_3 + 0.0192857142857142*G0_1_1_2_5 + 0.0128571428571428*G0_1_1_3_0 + 0.0273214285714284*G0_1_1_3_1 - 0.0160714285714285*G0_1_1_3_2 + 0.0257142857142856*G0_1_1_3_3 - 0.122142857142857*G0_1_1_3_4 - 0.064285714285714*G0_1_1_3_5 - 0.00160714285714287*G0_1_1_4_0 + 0.0482142857142855*G0_1_1_4_1 - 0.122142857142857*G0_1_1_4_3 - 0.424285714285712*G0_1_1_4_4 - 0.134999999999999*G0_1_1_4_5 - 0.0707142857142854*G0_1_1_5_0 + 0.0466071428571426*G0_1_1_5_1 + 0.0192857142857142*G0_1_1_5_2 - 0.064285714285714*G0_1_1_5_3 - 0.134999999999999*G0_1_1_5_4 - 0.205714285714285*G0_1_1_5_5;
    A[53] = -A[58] + 0.0441964285714284*G0_0_0_0_0 - 0.00321428571428572*G0_0_0_0_1 - 0.0136607142857142*G0_0_0_0_2 + 0.00482142857142857*G0_0_0_0_3 + 0.0546428571428569*G0_0_0_0_4 + 0.0176785714285714*G0_0_0_0_5 - 0.00321428571428571*G0_0_0_1_0 - 0.0080357142857141*G0_0_0_1_1 - 0.00321428571428569*G0_0_0_1_2 - 0.00160714285714286*G0_0_0_1_4 + 0.0160714285714285*G0_0_0_1_5 - 0.0136607142857142*G0_0_0_2_0 - 0.00321428571428569*G0_0_0_2_1 - 0.0441964285714285*G0_0_0_2_2 + 0.0176785714285713*G0_0_0_2_3 - 0.00160714285714287*G0_0_0_2_4 + 0.020892857142857*G0_0_0_2_5 + 0.00482142857142857*G0_0_0_3_0 + 0.0176785714285713*G0_0_0_3_2 + 0.115714285714285*G0_0_0_3_3 - 0.00642857142857136*G0_0_0_3_4 - 0.0514285714285712*G0_0_0_3_5 + 0.0546428571428569*G0_0_0_4_0 - 0.00160714285714286*G0_0_0_4_1 - 0.00160714285714287*G0_0_0_4_2 - 0.00642857142857136*G0_0_0_4_3 + 0.347142857142856*G0_0_0_4_4 - 0.0385714285714283*G0_0_0_4_5 + 0.0176785714285714*G0_0_0_5_0 + 0.0160714285714285*G0_0_0_5_1 + 0.020892857142857*G0_0_0_5_2 - 0.0514285714285712*G0_0_0_5_3 - 0.0385714285714283*G0_0_0_5_4 - 0.141428571428571*G0_0_0_5_5 - 0.124553571428571*G0_1_0_0_0 + 0.00120535714285713*G0_1_0_0_1 + 0.00281249999999998*G0_1_0_0_2 + 0.00803571428571425*G0_1_0_0_3 - 0.0337499999999998*G0_1_0_0_4 + 0.00964285714285712*G0_1_0_0_5 + 0.00120535714285713*G0_1_0_1_0 - 0.00281249999999998*G0_1_0_1_2 + 0.00160714285714284*G0_1_0_1_4 + 0.00281249999999998*G0_1_0_2_0 - 0.00281249999999998*G0_1_0_2_1 - 0.0417857142857142*G0_1_0_2_2 + 0.0192857142857141*G0_1_0_2_3 + 0.0241071428571427*G0_1_0_2_4 + 0.0144642857142857*G0_1_0_2_5 + 0.00803571428571425*G0_1_0_3_0 + 0.0192857142857141*G0_1_0_3_2 + 0.0771428571428564*G0_1_0_3_3 - 0.0192857142857142*G0_1_0_3_4 - 0.0449999999999998*G0_1_0_3_5 - 0.0337499999999998*G0_1_0_4_0 + 0.00160714285714284*G0_1_0_4_1 + 0.0241071428571427*G0_1_0_4_2 - 0.0192857142857142*G0_1_0_4_3 + 0.179999999999999*G0_1_0_4_4 - 0.032142857142857*G0_1_0_4_5 + 0.00964285714285712*G0_1_0_5_0 + 0.0144642857142857*G0_1_0_5_2 - 0.0449999999999998*G0_1_0_5_3 - 0.032142857142857*G0_1_0_5_4 + 0.0128571428571426*G0_1_0_5_5;
    A[34] = -A[36] + 0.00723214285714285*G0_0_1_0_0 + 0.00562499999999995*G0_0_1_0_1 - 0.0546428571428568*G0_0_1_0_3 - 0.0257142857142856*G0_0_1_0_4 - 0.0208928571428571*G0_0_1_0_5 + 0.00562499999999995*G0_0_1_1_0 - 0.004017857142857*G0_0_1_1_1 - 0.00803571428571427*G0_0_1_1_2 - 0.00642857142857129*G0_0_1_1_3 - 0.00964285714285708*G0_0_1_1_4 - 0.0176785714285713*G0_0_1_1_5 - 0.00803571428571427*G0_0_1_2_1 + 0.120535714285714*G0_0_1_2_2 - 0.0160714285714285*G0_0_1_2_3 + 0.0160714285714285*G0_0_1_2_4 - 0.0160714285714285*G0_0_1_2_5 - 0.0546428571428568*G0_0_1_3_0 - 0.00642857142857129*G0_0_1_3_1 - 0.0160714285714285*G0_0_1_3_2 + 0.578571428571426*G0_0_1_3_3 + 0.128571428571428*G0_0_1_3_4 + 0.141428571428571*G0_0_1_3_5 - 0.0257142857142856*G0_0_1_4_0 - 0.00964285714285708*G0_0_1_4_1 + 0.0160714285714285*G0_0_1_4_2 + 0.128571428571428*G0_0_1_4_3 - 0.064285714285714*G0_0_1_4_4 + 0.0514285714285712*G0_0_1_4_5 - 0.0208928571428571*G0_0_1_5_0 - 0.0176785714285713*G0_0_1_5_1 - 0.0160714285714285*G0_0_1_5_2 + 0.141428571428571*G0_0_1_5_3 + 0.0514285714285712*G0_0_1_5_4 + 0.0385714285714286*G0_0_1_5_5 + 0.00241071428571422*G0_1_1_0_0 + 0.0164732142857142*G0_1_1_0_1 + 0.000401785714285735*G0_1_1_0_2 - 0.00642857142857143*G0_1_1_0_3 + 0.0016071428571428*G0_1_1_0_4 + 0.0257142857142855*G0_1_1_0_5 + 0.0164732142857142*G0_1_1_1_0 - 0.168749999999999*G0_1_1_1_1 + 0.00441964285714281*G0_1_1_1_2 - 0.00803571428571406*G0_1_1_1_3 + 0.0032142857142857*G0_1_1_1_4 - 0.0883928571428565*G0_1_1_1_5 + 0.000401785714285735*G0_1_1_2_0 + 0.00441964285714281*G0_1_1_2_1 + 0.00803571428571413*G0_1_1_2_2 - 0.0160714285714286*G0_1_1_2_3 + 0.00321428571428566*G0_1_1_2_5 - 0.00642857142857143*G0_1_1_3_0 - 0.00803571428571406*G0_1_1_3_1 - 0.0160714285714286*G0_1_1_3_2 + 0.154285714285714*G0_1_1_3_3 + 0.00642857142857151*G0_1_1_3_4 + 0.00642857142857163*G0_1_1_3_5 + 0.0016071428571428*G0_1_1_4_0 + 0.0032142857142857*G0_1_1_4_1 + 0.00642857142857151*G0_1_1_4_3 - 0.0385714285714283*G0_1_1_4_4 - 0.0128571428571427*G0_1_1_4_5 + 0.0257142857142855*G0_1_1_5_0 - 0.0883928571428565*G0_1_1_5_1 + 0.00321428571428566*G0_1_1_5_2 + 0.00642857142857162*G0_1_1_5_3 - 0.0128571428571427*G0_1_1_5_4 - 0.167142857142856*G0_1_1_5_5;
    A[84] = -A[86] + 0.041785714285714*G0_0_1_0_0 - 0.00281249999999994*G0_0_1_0_1 + 0.00281249999999998*G0_0_1_0_2 - 0.0144642857142856*G0_0_1_0_3 - 0.0192857142857142*G0_0_1_0_4 - 0.0241071428571427*G0_0_1_0_5 - 0.00281249999999994*G0_0_1_1_0 + 0.124553571428571*G0_0_1_1_1 - 0.00120535714285712*G0_0_1_1_2 - 0.00964285714285724*G0_0_1_1_3 - 0.00803571428571425*G0_0_1_1_4 + 0.0337499999999997*G0_0_1_1_5 + 0.00281249999999998*G0_0_1_2_0 - 0.00120535714285712*G0_0_1_2_1 - 0.00160714285714285*G0_0_1_2_5 - 0.0144642857142856*G0_0_1_3_0 - 0.00964285714285724*G0_0_1_3_1 - 0.012857142857143*G0_0_1_3_3 + 0.0449999999999998*G0_0_1_3_4 + 0.032142857142857*G0_0_1_3_5 - 0.0192857142857142*G0_0_1_4_0 - 0.00803571428571425*G0_0_1_4_1 + 0.0449999999999998*G0_0_1_4_3 - 0.0771428571428569*G0_0_1_4_4 + 0.0192857142857142*G0_0_1_4_5 - 0.0241071428571427*G0_0_1_5_0 + 0.0337499999999997*G0_0_1_5_1 - 0.00160714285714285*G0_0_1_5_2 + 0.032142857142857*G0_0_1_5_3 + 0.0192857142857142*G0_0_1_5_4 - 0.179999999999999*G0_0_1_5_5 - 0.00241071428571422*G0_1_1_0_0 - 0.0164732142857142*G0_1_1_0_1 - 0.000401785714285735*G0_1_1_0_2 + 0.00642857142857143*G0_1_1_0_3 - 0.00160714285714281*G0_1_1_0_4 - 0.0257142857142855*G0_1_1_0_5 - 0.0164732142857142*G0_1_1_1_0 + 0.168749999999999*G0_1_1_1_1 - 0.0044196428571428*G0_1_1_1_2 + 0.00803571428571404*G0_1_1_1_3 - 0.00321428571428572*G0_1_1_1_4 + 0.0883928571428565*G0_1_1_1_5 - 0.000401785714285735*G0_1_1_2_0 - 0.0044196428571428*G0_1_1_2_1 - 0.00803571428571415*G0_1_1_2_2 + 0.0160714285714286*G0_1_1_2_3 - 0.00321428571428566*G0_1_1_2_5 + 0.00642857142857143*G0_1_1_3_0 + 0.00803571428571404*G0_1_1_3_1 + 0.0160714285714286*G0_1_1_3_2 - 0.154285714285714*G0_1_1_3_3 - 0.00642857142857146*G0_1_1_3_4 - 0.00642857142857161*G0_1_1_3_5 - 0.00160714285714281*G0_1_1_4_0 - 0.00321428571428572*G0_1_1_4_1 - 0.00642857142857146*G0_1_1_4_3 + 0.0385714285714285*G0_1_1_4_4 + 0.0128571428571428*G0_1_1_4_5 - 0.0257142857142855*G0_1_1_5_0 + 0.0883928571428565*G0_1_1_5_1 - 0.00321428571428566*G0_1_1_5_2 - 0.00642857142857162*G0_1_1_5_3 + 0.0128571428571428*G0_1_1_5_4 + 0.167142857142856*G0_1_1_5_5;
    A[74] = -A[84] - 0.00723214285714288*G0_0_0_0_0 + 0.00401785714285714*G0_0_0_0_2 - 0.00321428571428568*G0_0_0_0_3 + 0.0032142857142857*G0_0_0_0_4 - 0.00482142857142858*G0_0_0_0_5 + 0.00723214285714285*G0_0_0_1_1 - 0.00401785714285711*G0_0_0_1_2 - 0.00321428571428568*G0_0_0_1_3 + 0.00321428571428571*G0_0_0_1_4 + 0.00482142857142857*G0_0_0_1_5 + 0.00401785714285714*G0_0_0_2_0 - 0.00401785714285711*G0_0_0_2_1 + 0.0160714285714284*G0_0_0_2_3 - 0.0160714285714286*G0_0_0_2_4 - 0.00321428571428568*G0_0_0_3_0 - 0.00321428571428569*G0_0_0_3_1 + 0.0160714285714284*G0_0_0_3_2 + 0.0642857142857139*G0_0_0_3_3 + 0.0064285714285714*G0_0_0_3_5 + 0.00321428571428571*G0_0_0_4_0 + 0.00321428571428571*G0_0_0_4_1 - 0.0160714285714286*G0_0_0_4_2 - 0.0642857142857141*G0_0_0_4_4 - 0.00642857142857142*G0_0_0_4_5 - 0.00482142857142858*G0_0_0_5_0 + 0.00482142857142857*G0_0_0_5_1 + 0.00642857142857141*G0_0_0_5_3 - 0.00642857142857142*G0_0_0_5_4 - 0.00562500000000007*G0_0_1_0_0 - 0.00642857142857137*G0_0_1_0_1 + 0.000803571428571433*G0_0_1_0_2 - 0.00803571428571421*G0_0_1_0_3 - 0.00160714285714286*G0_0_1_0_4 - 0.0192857142857142*G0_0_1_0_5 - 0.00642857142857137*G0_0_1_1_0 + 0.0843749999999995*G0_0_1_1_1 - 0.0072321428571428*G0_0_1_1_2 + 0.0048214285714285*G0_0_1_1_3 + 0.00160714285714285*G0_0_1_1_4 + 0.0433928571428569*G0_0_1_1_5 + 0.000803571428571433*G0_0_1_2_0 - 0.0072321428571428*G0_0_1_2_1 + 0.00803571428571421*G0_0_1_2_2 + 0.0160714285714285*G0_0_1_2_3 - 0.00160714285714283*G0_0_1_2_5 - 0.00803571428571421*G0_0_1_3_0 + 0.0048214285714285*G0_0_1_3_1 + 0.0160714285714285*G0_0_1_3_2 + 0.115714285714285*G0_0_1_3_3 + 0.0128571428571427*G0_0_1_3_4 + 0.0192857142857141*G0_0_1_3_5 - 0.00160714285714286*G0_0_1_4_0 + 0.00160714285714285*G0_0_1_4_1 + 0.0128571428571427*G0_0_1_4_3 - 0.0128571428571429*G0_0_1_4_4 - 0.0192857142857142*G0_0_1_5_0 + 0.0433928571428569*G0_0_1_5_1 - 0.00160714285714283*G0_0_1_5_2 + 0.0192857142857141*G0_0_1_5_3 + 0.0385714285714282*G0_0_1_5_5 + 0.00482142857142857*G0_1_0_0_0 - 0.00200892857142857*G0_1_0_0_1 - 0.00281249999999998*G0_1_0_0_2 - 0.00642857142857138*G0_1_0_0_3 - 0.00160714285714282*G0_1_0_0_5 - 0.00200892857142857*G0_1_0_1_0 + 0.0120535714285714*G0_1_0_1_1 - 0.0068303571428571*G0_1_0_1_2 - 0.00321428571428569*G0_1_0_1_3 - 0.0032142857142857*G0_1_0_1_4 + 0.00321428571428572*G0_1_0_1_5 - 0.00281249999999998*G0_1_0_2_0 - 0.0068303571428571*G0_1_0_2_1 + 0.0321428571428569*G0_1_0_2_2 + 0.0241071428571427*G0_1_0_2_3 + 0.00803571428571424*G0_1_0_2_4 - 0.00642857142857139*G0_1_0_2_5 - 0.00642857142857138*G0_1_0_3_0 - 0.0032142857142857*G0_1_0_3_1 + 0.0241071428571427*G0_1_0_3_2 + 0.0771428571428567*G0_1_0_3_3 + 0.0192857142857142*G0_1_0_3_4 + 0.0257142857142856*G0_1_0_3_5 - 0.0032142857142857*G0_1_0_4_1 + 0.00803571428571424*G0_1_0_4_2 + 0.0192857142857142*G0_1_0_4_3 + 0.0128571428571428*G0_1_0_4_4 + 0.0192857142857142*G0_1_0_4_5 - 0.00160714285714282*G0_1_0_5_0 + 0.00321428571428572*G0_1_0_5_1 - 0.0064285714285714*G0_1_0_5_2 + 0.0257142857142856*G0_1_0_5_3 + 0.0192857142857142*G0_1_0_5_4 + 0.0642857142857142*G0_1_0_5_5 + 0.0104464285714286*G0_1_1_0_0 - 0.0192857142857142*G0_1_1_0_1 - 0.00241071428571428*G0_1_1_0_2 + 0.00482142857142856*G0_1_1_0_4 - 0.00964285714285701*G0_1_1_0_5 - 0.0192857142857142*G0_1_1_1_0 + 0.120535714285714*G0_1_1_1_1 - 0.0112499999999999*G0_1_1_1_2 + 0.0160714285714284*G0_1_1_1_3 + 0.00642857142857138*G0_1_1_1_4 + 0.0803571428571424*G0_1_1_1_5 - 0.00241071428571428*G0_1_1_2_0 - 0.0112499999999999*G0_1_1_2_1 + 0.0120535714285714*G0_1_1_2_2 + 0.0289285714285713*G0_1_1_2_3 + 0.01125*G0_1_1_2_4 - 0.00642857142857137*G0_1_1_2_5 + 0.0160714285714284*G0_1_1_3_1 + 0.0289285714285713*G0_1_1_3_2 + 0.0514285714285709*G0_1_1_3_3 - 0.0128571428571428*G0_1_1_3_4 + 0.0128571428571427*G0_1_1_3_5 + 0.00482142857142856*G0_1_1_4_0 + 0.00642857142857138*G0_1_1_4_1 + 0.01125*G0_1_1_4_2 - 0.0128571428571428*G0_1_1_4_3 - 0.0257142857142855*G0_1_1_4_4 - 0.00964285714285701*G0_1_1_5_0 + 0.0803571428571424*G0_1_1_5_1 - 0.00642857142857137*G0_1_1_5_2 + 0.0128571428571427*G0_1_1_5_3 + 0.308571428571427*G0_1_1_5_5;
    A[76] = -A[74] - 0.124553571428571*G0_0_1_0_0 + 0.00281249999999997*G0_0_1_0_1 + 0.00120535714285714*G0_0_1_0_2 + 0.00803571428571425*G0_0_1_0_3 + 0.00964285714285712*G0_0_1_0_4 - 0.0337499999999998*G0_0_1_0_5 + 0.00281249999999997*G0_0_1_1_0 - 0.041785714285714*G0_0_1_1_1 - 0.0028125*G0_0_1_1_2 + 0.0192857142857143*G0_0_1_1_3 + 0.0144642857142856*G0_0_1_1_4 + 0.0241071428571428*G0_0_1_1_5 + 0.00120535714285714*G0_0_1_2_0 - 0.0028125*G0_0_1_2_1 + 0.00160714285714287*G0_0_1_2_5 + 0.00803571428571425*G0_0_1_3_0 + 0.0192857142857143*G0_0_1_3_1 + 0.0771428571428567*G0_0_1_3_3 - 0.0449999999999998*G0_0_1_3_4 - 0.0192857142857142*G0_0_1_3_5 + 0.00964285714285712*G0_0_1_4_0 + 0.0144642857142856*G0_0_1_4_1 - 0.0449999999999998*G0_0_1_4_3 + 0.0128571428571428*G0_0_1_4_4 - 0.032142857142857*G0_0_1_4_5 - 0.0337499999999998*G0_0_1_5_0 + 0.0241071428571428*G0_0_1_5_1 + 0.00160714285714287*G0_0_1_5_2 - 0.0192857142857142*G0_0_1_5_3 - 0.032142857142857*G0_0_1_5_4 + 0.179999999999999*G0_0_1_5_5 + 0.0441964285714284*G0_1_1_0_0 - 0.0136607142857142*G0_1_1_0_1 - 0.00321428571428569*G0_1_1_0_2 + 0.00482142857142855*G0_1_1_0_3 + 0.0176785714285713*G0_1_1_0_4 + 0.0546428571428569*G0_1_1_0_5 - 0.0136607142857142*G0_1_1_1_0 - 0.0441964285714282*G0_1_1_1_1 - 0.00321428571428572*G0_1_1_1_2 + 0.0176785714285714*G0_1_1_1_3 + 0.0208928571428571*G0_1_1_1_4 - 0.00160714285714272*G0_1_1_1_5 - 0.00321428571428569*G0_1_1_2_0 - 0.00321428571428572*G0_1_1_2_1 - 0.00803571428571433*G0_1_1_2_2 + 0.0160714285714285*G0_1_1_2_4 - 0.00160714285714283*G0_1_1_2_5 + 0.00482142857142855*G0_1_1_3_0 + 0.0176785714285714*G0_1_1_3_1 + 0.115714285714285*G0_1_1_3_3 - 0.0514285714285712*G0_1_1_3_4 - 0.00642857142857142*G0_1_1_3_5 + 0.0176785714285713*G0_1_1_4_0 + 0.0208928571428571*G0_1_1_4_1 + 0.0160714285714285*G0_1_1_4_2 - 0.0514285714285712*G0_1_1_4_3 - 0.141428571428571*G0_1_1_4_4 - 0.0385714285714285*G0_1_1_4_5 + 0.0546428571428569*G0_1_1_5_0 - 0.00160714285714272*G0_1_1_5_1 - 0.00160714285714283*G0_1_1_5_2 - 0.00642857142857142*G0_1_1_5_3 - 0.0385714285714285*G0_1_1_5_4 + 0.347142857142855*G0_1_1_5_5;
    A[67] = A[76] + 0.112499999999999*G0_0_1_0_0 - 0.00361607142857139*G0_0_1_0_1 + 0.000401785714285737*G0_0_1_0_2 - 0.00482142857142854*G0_0_1_0_3 - 0.00803571428571431*G0_0_1_0_4 + 0.0241071428571426*G0_0_1_0_5 - 0.00361607142857139*G0_0_1_1_0 + 0.00160714285714286*G0_0_1_1_1 + 0.00200892857142856*G0_0_1_1_2 - 0.00321428571428571*G0_0_1_1_3 - 0.00482142857142853*G0_0_1_1_4 - 0.00803571428571424*G0_0_1_1_5 + 0.000401785714285737*G0_0_1_2_0 + 0.00200892857142856*G0_0_1_2_1 - 0.0120535714285715*G0_0_1_2_2 - 0.0096428571428571*G0_0_1_2_3 + 0.0016071428571428*G0_0_1_2_4 + 0.00160714285714285*G0_0_1_2_5 - 0.00482142857142854*G0_0_1_3_0 - 0.00321428571428571*G0_0_1_3_1 - 0.0096428571428571*G0_0_1_3_2 + 0.0192857142857142*G0_0_1_3_4 + 0.00642857142857141*G0_0_1_3_5 - 0.00803571428571431*G0_0_1_4_0 - 0.00482142857142853*G0_0_1_4_1 + 0.0016071428571428*G0_0_1_4_2 + 0.0192857142857142*G0_0_1_4_3 - 0.0385714285714286*G0_0_1_4_4 + 0.00642857142857135*G0_0_1_4_5 + 0.0241071428571427*G0_0_1_5_0 - 0.00803571428571424*G0_0_1_5_1 + 0.00160714285714285*G0_0_1_5_2 + 0.00642857142857142*G0_0_1_5_3 + 0.00642857142857136*G0_0_1_5_4 - 0.102857142857142*G0_0_1_5_5 - 0.112499999999999*G0_1_0_0_0 + 0.00361607142857139*G0_1_0_0_1 - 0.000401785714285737*G0_1_0_0_2 + 0.00482142857142854*G0_1_0_0_3 + 0.00803571428571431*G0_1_0_0_4 - 0.0241071428571426*G0_1_0_0_5 + 0.00361607142857139*G0_1_0_1_0 - 0.00160714285714286*G0_1_0_1_1 - 0.00200892857142856*G0_1_0_1_2 + 0.00321428571428571*G0_1_0_1_3 + 0.00482142857142853*G0_1_0_1_4 + 0.00803571428571424*G0_1_0_1_5 - 0.000401785714285737*G0_1_0_2_0 - 0.00200892857142856*G0_1_0_2_1 + 0.0120535714285715*G0_1_0_2_2 + 0.0096428571428571*G0_1_0_2_3 - 0.0016071428571428*G0_1_0_2_4 - 0.00160714285714285*G0_1_0_2_5 + 0.00482142857142854*G0_1_0_3_0 + 0.00321428571428571*G0_1_0_3_1 + 0.0096428571428571*G0_1_0_3_2 - 0.0192857142857142*G0_1_0_3_4 - 0.00642857142857141*G0_1_0_3_5 + 0.00803571428571431*G0_1_0_4_0 + 0.00482142857142853*G0_1_0_4_1 - 0.0016071428571428*G0_1_0_4_2 - 0.0192857142857142*G0_1_0_4_3 + 0.0385714285714286*G0_1_0_4_4 - 0.00642857142857135*G0_1_0_4_5 - 0.0241071428571426*G0_1_0_5_0 + 0.00803571428571424*G0_1_0_5_1 - 0.00160714285714285*G0_1_0_5_2 - 0.00642857142857141*G0_1_0_5_3 - 0.00642857142857135*G0_1_0_5_4 + 0.102857142857142*G0_1_0_5_5;
    A[47] = -A[67] - 0.124553571428571*G0_1_0_0_0 + 0.00281249999999998*G0_1_0_0_1 + 0.00120535714285714*G0_1_0_0_2 + 0.00803571428571425*G0_1_0_0_3 + 0.00964285714285712*G0_1_0_0_4 - 0.0337499999999998*G0_1_0_0_5 + 0.00281249999999997*G0_1_0_1_0 - 0.041785714285714*G0_1_0_1_1 - 0.0028125*G0_1_0_1_2 + 0.0192857142857143*G0_1_0_1_3 + 0.0144642857142856*G0_1_0_1_4 + 0.0241071428571428*G0_1_0_1_5 + 0.00120535714285714*G0_1_0_2_0 - 0.0028125*G0_1_0_2_1 + 0.00160714285714286*G0_1_0_2_5 + 0.00803571428571425*G0_1_0_3_0 + 0.0192857142857143*G0_1_0_3_1 + 0.0771428571428567*G0_1_0_3_3 - 0.0449999999999998*G0_1_0_3_4 - 0.0192857142857142*G0_1_0_3_5 + 0.00964285714285712*G0_1_0_4_0 + 0.0144642857142856*G0_1_0_4_1 - 0.0449999999999998*G0_1_0_4_3 + 0.0128571428571428*G0_1_0_4_4 - 0.032142857142857*G0_1_0_4_5 - 0.0337499999999998*G0_1_0_5_0 + 0.0241071428571428*G0_1_0_5_1 + 0.00160714285714286*G0_1_0_5_2 - 0.0192857142857142*G0_1_0_5_3 - 0.032142857142857*G0_1_0_5_4 + 0.179999999999999*G0_1_0_5_5 + 0.0441964285714284*G0_1_1_0_0 - 0.0136607142857142*G0_1_1_0_1 - 0.00321428571428569*G0_1_1_0_2 + 0.00482142857142855*G0_1_1_0_3 + 0.0176785714285713*G0_1_1_0_4 + 0.0546428571428569*G0_1_1_0_5 - 0.0136607142857142*G0_1_1_1_0 - 0.0441964285714282*G0_1_1_1_1 - 0.00321428571428572*G0_1_1_1_2 + 0.0176785714285714*G0_1_1_1_3 + 0.0208928571428571*G0_1_1_1_4 - 0.00160714285714272*G0_1_1_1_5 - 0.00321428571428569*G0_1_1_2_0 - 0.00321428571428572*G0_1_1_2_1 - 0.00803571428571433*G0_1_1_2_2 + 0.0160714285714285*G0_1_1_2_4 - 0.00160714285714283*G0_1_1_2_5 + 0.00482142857142855*G0_1_1_3_0 + 0.0176785714285714*G0_1_1_3_1 + 0.115714285714285*G0_1_1_3_3 - 0.0514285714285712*G0_1_1_3_4 - 0.00642857142857142*G0_1_1_3_5 + 0.0176785714285713*G0_1_1_4_0 + 0.0208928571428571*G0_1_1_4_1 + 0.0160714285714285*G0_1_1_4_2 - 0.0514285714285712*G0_1_1_4_3 - 0.141428571428571*G0_1_1_4_4 - 0.0385714285714285*G0_1_1_4_5 + 0.0546428571428569*G0_1_1_5_0 - 0.00160714285714272*G0_1_1_5_1 - 0.00160714285714283*G0_1_1_5_2 - 0.00642857142857142*G0_1_1_5_3 - 0.0385714285714285*G0_1_1_5_4 + 0.347142857142855*G0_1_1_5_5;
    A[56] = -A[54] + 0.00401785714285716*G0_0_1_0_0 - 0.00562499999999997*G0_0_1_0_1 + 0.00803571428571424*G0_0_1_0_2 + 0.00964285714285709*G0_0_1_0_3 + 0.00642857142857132*G0_0_1_0_4 + 0.0176785714285713*G0_0_1_0_5 - 0.00562499999999997*G0_0_1_1_0 - 0.00723214285714272*G0_0_1_1_1 + 0.0257142857142856*G0_0_1_1_3 + 0.0546428571428569*G0_0_1_1_4 + 0.0208928571428571*G0_0_1_1_5 + 0.00803571428571424*G0_0_1_2_0 - 0.120535714285714*G0_0_1_2_2 - 0.0160714285714285*G0_0_1_2_3 + 0.0160714285714285*G0_0_1_2_4 + 0.0160714285714285*G0_0_1_2_5 + 0.00964285714285709*G0_0_1_3_0 + 0.0257142857142856*G0_0_1_3_1 - 0.0160714285714285*G0_0_1_3_2 + 0.064285714285714*G0_0_1_3_3 - 0.128571428571428*G0_0_1_3_4 - 0.0514285714285712*G0_0_1_3_5 + 0.00642857142857132*G0_0_1_4_0 + 0.0546428571428569*G0_0_1_4_1 + 0.0160714285714285*G0_0_1_4_2 - 0.128571428571428*G0_0_1_4_3 - 0.578571428571426*G0_0_1_4_4 - 0.141428571428571*G0_0_1_4_5 + 0.0176785714285713*G0_0_1_5_0 + 0.0208928571428571*G0_0_1_5_1 + 0.0160714285714285*G0_0_1_5_2 - 0.0514285714285712*G0_0_1_5_3 - 0.141428571428571*G0_0_1_5_4 - 0.0385714285714284*G0_0_1_5_5 - 0.164732142857142*G0_1_1_0_0 + 0.0108482142857142*G0_1_1_0_1 + 0.0124553571428571*G0_1_1_0_2 + 0.0128571428571428*G0_1_1_0_3 - 0.00160714285714286*G0_1_1_0_4 - 0.0707142857142854*G0_1_1_0_5 + 0.0108482142857142*G0_1_1_1_0 - 0.00482142857142853*G0_1_1_1_1 + 0.00040178571428571*G0_1_1_1_2 + 0.0273214285714284*G0_1_1_1_3 + 0.0482142857142855*G0_1_1_1_4 + 0.0466071428571426*G0_1_1_1_5 + 0.0124553571428571*G0_1_1_2_0 + 0.000401785714285709*G0_1_1_2_1 - 0.1125*G0_1_1_2_2 - 0.0160714285714285*G0_1_1_2_3 + 0.0192857142857142*G0_1_1_2_5 + 0.0128571428571428*G0_1_1_3_0 + 0.0273214285714284*G0_1_1_3_1 - 0.0160714285714285*G0_1_1_3_2 + 0.0257142857142856*G0_1_1_3_3 - 0.122142857142857*G0_1_1_3_4 - 0.064285714285714*G0_1_1_3_5 - 0.00160714285714288*G0_1_1_4_0 + 0.0482142857142855*G0_1_1_4_1 - 0.122142857142857*G0_1_1_4_3 - 0.424285714285712*G0_1_1_4_4 - 0.134999999999999*G0_1_1_4_5 - 0.0707142857142854*G0_1_1_5_0 + 0.0466071428571426*G0_1_1_5_1 + 0.0192857142857142*G0_1_1_5_2 - 0.064285714285714*G0_1_1_5_3 - 0.134999999999999*G0_1_1_5_4 - 0.205714285714285*G0_1_1_5_5;
    A[0] = A[11] + 0.125357142857142*G0_0_0_0_0 - 0.0103571428571428*G0_0_0_0_2 + 0.00714285714285711*G0_0_0_0_3 + 0.0421428571428569*G0_0_0_0_4 + 0.0499999999999997*G0_0_0_0_5 - 0.125357142857142*G0_0_0_1_1 + 0.0103571428571428*G0_0_0_1_2 - 0.0421428571428569*G0_0_0_1_3 - 0.00714285714285712*G0_0_0_1_4 - 0.0499999999999997*G0_0_0_1_5 - 0.0103571428571428*G0_0_0_2_0 + 0.0103571428571428*G0_0_0_2_1 + 0.00785714285714281*G0_0_0_2_3 - 0.00785714285714283*G0_0_0_2_4 + 0.00714285714285711*G0_0_0_3_0 - 0.0421428571428569*G0_0_0_3_1 + 0.00785714285714281*G0_0_0_3_2 - 0.0228571428571428*G0_0_0_3_3 - 0.0142857142857142*G0_0_0_3_5 + 0.0421428571428569*G0_0_0_4_0 - 0.00714285714285711*G0_0_0_4_1 - 0.00785714285714283*G0_0_0_4_2 + 0.0228571428571428*G0_0_0_4_4 + 0.0142857142857142*G0_0_0_4_5 + 0.0499999999999997*G0_0_0_5_0 - 0.0499999999999997*G0_0_0_5_1 - 0.0142857142857142*G0_0_0_5_3 + 0.0142857142857142*G0_0_0_5_4 + 0.131845238095237*G0_0_1_0_0 - 0.0103670634920634*G0_0_1_0_1 - 0.0103670634920634*G0_0_1_0_2 + 0.0013888888888889*G0_0_1_0_3 + 0.0428571428571426*G0_0_1_0_4 + 0.0428571428571426*G0_0_1_0_5 - 0.0103670634920634*G0_0_1_1_0 + 0.0064880952380952*G0_0_1_1_1 + 0.000714285714285699*G0_0_1_1_3 - 0.00575396825396823*G0_0_1_1_4 - 0.00714285714285711*G0_0_1_1_5 - 0.0103670634920634*G0_0_1_2_0 + 0.00648809523809522*G0_0_1_2_2 + 0.000714285714285713*G0_0_1_2_3 - 0.00714285714285711*G0_0_1_2_4 - 0.00575396825396823*G0_0_1_2_5 + 0.0013888888888889*G0_0_1_3_0 + 0.0007142857142857*G0_0_1_3_1 + 0.000714285714285713*G0_0_1_3_2 + 0.023174603174603*G0_0_1_3_3 + 0.00873015873015869*G0_0_1_3_4 + 0.00873015873015869*G0_0_1_3_5 + 0.0428571428571426*G0_0_1_4_0 - 0.00575396825396823*G0_0_1_4_1 - 0.00714285714285711*G0_0_1_4_2 + 0.00873015873015869*G0_0_1_4_3 + 0.0460317460317458*G0_0_1_4_4 + 0.0230158730158729*G0_0_1_4_5 + 0.0428571428571426*G0_0_1_5_0 - 0.00714285714285711*G0_0_1_5_1 - 0.00575396825396823*G0_0_1_5_2 + 0.00873015873015869*G0_0_1_5_3 + 0.0230158730158729*G0_0_1_5_4 + 0.0460317460317458*G0_0_1_5_5 + 0.131845238095237*G0_1_0_0_0 - 0.0103670634920634*G0_1_0_0_1 - 0.0103670634920634*G0_1_0_0_2 + 0.0013888888888889*G0_1_0_0_3 + 0.0428571428571426*G0_1_0_0_4 + 0.0428571428571426*G0_1_0_0_5 - 0.0103670634920634*G0_1_0_1_0 + 0.0064880952380952*G0_1_0_1_1 + 0.000714285714285699*G0_1_0_1_3 - 0.00575396825396823*G0_1_0_1_4 - 0.00714285714285711*G0_1_0_1_5 - 0.0103670634920634*G0_1_0_2_0 + 0.00648809523809522*G0_1_0_2_2 + 0.000714285714285713*G0_1_0_2_3 - 0.00714285714285711*G0_1_0_2_4 - 0.00575396825396823*G0_1_0_2_5 + 0.0013888888888889*G0_1_0_3_0 + 0.0007142857142857*G0_1_0_3_1 + 0.000714285714285714*G0_1_0_3_2 + 0.023174603174603*G0_1_0_3_3 + 0.00873015873015869*G0_1_0_3_4 + 0.00873015873015869*G0_1_0_3_5 + 0.0428571428571426*G0_1_0_4_0 - 0.00575396825396823*G0_1_0_4_1 - 0.00714285714285711*G0_1_0_4_2 + 0.00873015873015869*G0_1_0_4_3 + 0.0460317460317458*G0_1_0_4_4 + 0.0230158730158729*G0_1_0_4_5 + 0.0428571428571426*G0_1_0_5_0 - 0.00714285714285711*G0_1_0_5_1 - 0.00575396825396823*G0_1_0_5_2 + 0.00873015873015869*G0_1_0_5_3 + 0.0230158730158729*G0_1_0_5_4 + 0.0460317460317458*G0_1_0_5_5 + 0.131845238095237*G0_1_1_0_0 - 0.0103670634920634*G0_1_1_0_1 - 0.0103670634920634*G0_1_1_0_2 + 0.0013888888888889*G0_1_1_0_3 + 0.0428571428571426*G0_1_1_0_4 + 0.0428571428571426*G0_1_1_0_5 - 0.0103670634920634*G0_1_1_1_0 + 0.0064880952380952*G0_1_1_1_1 + 0.000714285714285704*G0_1_1_1_3 - 0.00575396825396823*G0_1_1_1_4 - 0.00714285714285711*G0_1_1_1_5 - 0.0103670634920634*G0_1_1_2_0 + 0.00648809523809522*G0_1_1_2_2 + 0.000714285714285713*G0_1_1_2_3 - 0.00714285714285711*G0_1_1_2_4 - 0.00575396825396823*G0_1_1_2_5 + 0.0013888888888889*G0_1_1_3_0 + 0.000714285714285705*G0_1_1_3_1 + 0.000714285714285713*G0_1_1_3_2 + 0.023174603174603*G0_1_1_3_3 + 0.00873015873015869*G0_1_1_3_4 + 0.0087301587301587*G0_1_1_3_5 + 0.0428571428571426*G0_1_1_4_0 - 0.00575396825396823*G0_1_1_4_1 - 0.00714285714285711*G0_1_1_4_2 + 0.00873015873015869*G0_1_1_4_3 + 0.0460317460317458*G0_1_1_4_4 + 0.0230158730158729*G0_1_1_4_5 + 0.0428571428571427*G0_1_1_5_0 - 0.00714285714285711*G0_1_1_5_1 - 0.00575396825396823*G0_1_1_5_2 + 0.0087301587301587*G0_1_1_5_3 + 0.0230158730158729*G0_1_1_5_4 + 0.0460317460317458*G0_1_1_5_5;
    A[79] = A[97] + 0.0803571428571428*G0_0_1_0_0 - 0.00723214285714285*G0_0_1_0_1 - 0.0152678571428571*G0_0_1_0_2 + 0.00642857142857143*G0_0_1_0_3 + 0.0482142857142856*G0_0_1_0_4 + 0.0803571428571425*G0_0_1_0_5 - 0.00723214285714285*G0_0_1_1_0 + 0.0160714285714285*G0_0_1_1_1 + 0.00080357142857143*G0_0_1_1_2 - 0.0257142857142856*G0_0_1_1_4 - 0.032142857142857*G0_0_1_1_5 - 0.0152678571428571*G0_0_1_2_0 + 0.00080357142857143*G0_0_1_2_1 + 0.0048214285714285*G0_0_1_2_2 + 0.00321428571428563*G0_0_1_2_3 - 0.0128571428571429*G0_0_1_2_4 + 0.0192857142857142*G0_0_1_2_5 + 0.00642857142857143*G0_0_1_3_0 + 0.00321428571428564*G0_0_1_3_2 + 0.051428571428571*G0_0_1_3_3 + 0.0385714285714284*G0_0_1_3_4 - 0.0514285714285712*G0_0_1_3_5 + 0.0482142857142856*G0_0_1_4_0 - 0.0257142857142856*G0_0_1_4_1 - 0.0128571428571429*G0_0_1_4_2 + 0.0385714285714284*G0_0_1_4_3 + 0.179999999999999*G0_0_1_4_4 + 0.0128571428571429*G0_0_1_4_5 + 0.0803571428571425*G0_0_1_5_0 - 0.032142857142857*G0_0_1_5_1 + 0.0192857142857142*G0_0_1_5_2 - 0.0514285714285712*G0_0_1_5_3 + 0.0128571428571429*G0_0_1_5_4 - 0.462857142857141*G0_0_1_5_5 - 0.0803571428571428*G0_1_0_0_0 + 0.00723214285714285*G0_1_0_0_1 + 0.0152678571428571*G0_1_0_0_2 - 0.00642857142857143*G0_1_0_0_3 - 0.0482142857142856*G0_1_0_0_4 - 0.0803571428571425*G0_1_0_0_5 + 0.00723214285714285*G0_1_0_1_0 - 0.0160714285714285*G0_1_0_1_1 - 0.000803571428571424*G0_1_0_1_2 + 0.0257142857142856*G0_1_0_1_4 + 0.032142857142857*G0_1_0_1_5 + 0.0152678571428571*G0_1_0_2_0 - 0.00080357142857143*G0_1_0_2_1 - 0.0048214285714285*G0_1_0_2_2 - 0.00321428571428563*G0_1_0_2_3 + 0.0128571428571429*G0_1_0_2_4 - 0.0192857142857142*G0_1_0_2_5 - 0.00642857142857143*G0_1_0_3_0 - 0.00321428571428563*G0_1_0_3_2 - 0.0514285714285712*G0_1_0_3_3 - 0.0385714285714284*G0_1_0_3_4 + 0.0514285714285712*G0_1_0_3_5 - 0.0482142857142856*G0_1_0_4_0 + 0.0257142857142856*G0_1_0_4_1 + 0.0128571428571429*G0_1_0_4_2 - 0.0385714285714284*G0_1_0_4_3 - 0.179999999999999*G0_1_0_4_4 - 0.0128571428571428*G0_1_0_4_5 - 0.0803571428571425*G0_1_0_5_0 + 0.032142857142857*G0_1_0_5_1 - 0.0192857142857142*G0_1_0_5_2 + 0.0514285714285712*G0_1_0_5_3 - 0.0128571428571429*G0_1_0_5_4 + 0.462857142857141*G0_1_0_5_5;
    A[38] = A[83] - 0.00642857142857136*G0_0_1_0_0 - 0.0120535714285713*G0_0_1_0_1 - 0.00241071428571429*G0_0_1_0_2 + 0.0160714285714285*G0_0_1_0_3 + 0.00482142857142855*G0_0_1_0_4 + 0.0160714285714285*G0_0_1_0_5 - 0.0120535714285713*G0_0_1_1_0 + 0.26517857142857*G0_0_1_1_1 - 0.0120535714285713*G0_0_1_1_2 + 0.0482142857142853*G0_0_1_1_3 + 0.0482142857142853*G0_0_1_1_5 - 0.00241071428571429*G0_0_1_2_0 - 0.0120535714285713*G0_0_1_2_1 - 0.00642857142857133*G0_0_1_2_2 + 0.0160714285714286*G0_0_1_2_3 + 0.00482142857142862*G0_0_1_2_4 + 0.0160714285714286*G0_0_1_2_5 + 0.0160714285714285*G0_0_1_3_0 + 0.0482142857142853*G0_0_1_3_1 + 0.0160714285714286*G0_0_1_3_2 - 0.128571428571428*G0_0_1_3_3 - 0.0321428571428571*G0_0_1_3_4 - 0.0642857142857142*G0_0_1_3_5 + 0.00482142857142855*G0_0_1_4_0 + 0.00482142857142862*G0_0_1_4_2 - 0.0321428571428571*G0_0_1_4_3 - 0.0257142857142856*G0_0_1_4_4 - 0.0321428571428571*G0_0_1_4_5 + 0.0160714285714285*G0_0_1_5_0 + 0.0482142857142853*G0_0_1_5_1 + 0.0160714285714286*G0_0_1_5_2 - 0.0642857142857142*G0_0_1_5_3 - 0.0321428571428571*G0_0_1_5_4 - 0.128571428571428*G0_0_1_5_5 + 0.00642857142857136*G0_1_0_0_0 + 0.0120535714285713*G0_1_0_0_1 + 0.00241071428571429*G0_1_0_0_2 - 0.0160714285714285*G0_1_0_0_3 - 0.00482142857142855*G0_1_0_0_4 - 0.0160714285714285*G0_1_0_0_5 + 0.0120535714285713*G0_1_0_1_0 - 0.26517857142857*G0_1_0_1_1 + 0.0120535714285713*G0_1_0_1_2 - 0.0482142857142853*G0_1_0_1_3 - 0.0482142857142853*G0_1_0_1_5 + 0.00241071428571429*G0_1_0_2_0 + 0.0120535714285713*G0_1_0_2_1 + 0.00642857142857133*G0_1_0_2_2 - 0.0160714285714286*G0_1_0_2_3 - 0.00482142857142862*G0_1_0_2_4 - 0.0160714285714286*G0_1_0_2_5 - 0.0160714285714285*G0_1_0_3_0 - 0.0482142857142853*G0_1_0_3_1 - 0.0160714285714286*G0_1_0_3_2 + 0.128571428571428*G0_1_0_3_3 + 0.0321428571428571*G0_1_0_3_4 + 0.0642857142857142*G0_1_0_3_5 - 0.00482142857142855*G0_1_0_4_0 - 0.00482142857142862*G0_1_0_4_2 + 0.0321428571428571*G0_1_0_4_3 + 0.0257142857142856*G0_1_0_4_4 + 0.0321428571428571*G0_1_0_4_5 - 0.0160714285714285*G0_1_0_5_0 - 0.0482142857142853*G0_1_0_5_1 - 0.0160714285714286*G0_1_0_5_2 + 0.0642857142857142*G0_1_0_5_3 + 0.0321428571428571*G0_1_0_5_4 + 0.128571428571428*G0_1_0_5_5;
    A[64] = A[38] - 0.0216964285714285*G0_0_0_0_0 - 0.0144642857142856*G0_0_0_0_1 + 0.047410714285714*G0_0_0_0_2 + 0.0337499999999998*G0_0_0_0_3 + 0.0482142857142855*G0_0_0_0_4 + 0.01125*G0_0_0_0_5 - 0.0144642857142856*G0_0_0_1_0 + 0.0610714285714282*G0_0_0_1_1 + 0.0289285714285713*G0_0_0_1_2 + 0.128571428571428*G0_0_0_1_3 + 0.0466071428571427*G0_0_0_1_4 + 0.0385714285714284*G0_0_0_1_5 + 0.047410714285714*G0_0_0_2_0 + 0.0289285714285713*G0_0_0_2_1 - 0.46205357142857*G0_0_0_2_2 - 0.210535714285713*G0_0_0_2_3 - 0.191249999999999*G0_0_0_2_4 - 0.00803571428571437*G0_0_0_2_5 + 0.0337499999999998*G0_0_0_3_0 + 0.128571428571428*G0_0_0_3_1 - 0.210535714285713*G0_0_0_3_2 - 0.141428571428571*G0_0_0_3_3 - 0.160714285714285*G0_0_0_3_4 - 0.0514285714285713*G0_0_0_3_5 + 0.0482142857142855*G0_0_0_4_0 + 0.0466071428571427*G0_0_0_4_1 - 0.191249999999999*G0_0_0_4_2 - 0.160714285714285*G0_0_0_4_3 - 0.372857142857141*G0_0_0_4_4 - 0.0771428571428569*G0_0_0_4_5 + 0.01125*G0_0_0_5_0 + 0.0385714285714284*G0_0_0_5_1 - 0.00803571428571437*G0_0_0_5_2 - 0.0514285714285713*G0_0_0_5_3 - 0.0771428571428569*G0_0_0_5_4 - 0.0899999999999997*G0_0_0_5_5 - 0.0168749999999999*G0_0_1_0_1 + 0.0168749999999999*G0_0_1_0_2 + 0.0144642857142857*G0_0_1_0_4 - 0.0144642857142856*G0_0_1_0_5 - 0.0168749999999999*G0_0_1_1_0 + 0.0843749999999995*G0_0_1_1_1 + 0.139821428571428*G0_0_1_1_3 + 0.0289285714285713*G0_0_1_1_4 + 0.053035714285714*G0_0_1_1_5 + 0.0168749999999999*G0_0_1_2_0 - 0.0843749999999998*G0_0_1_2_2 - 0.139821428571428*G0_0_1_2_3 - 0.0530357142857141*G0_0_1_2_4 - 0.0289285714285714*G0_0_1_2_5 + 0.139821428571428*G0_0_1_3_1 - 0.139821428571428*G0_0_1_3_2 - 0.0578571428571427*G0_0_1_3_4 + 0.0578571428571426*G0_0_1_3_5 + 0.0144642857142857*G0_0_1_4_0 + 0.0289285714285713*G0_0_1_4_1 - 0.0530357142857141*G0_0_1_4_2 - 0.0578571428571427*G0_0_1_4_3 - 0.0771428571428569*G0_0_1_4_4 - 0.0144642857142856*G0_0_1_5_0 + 0.053035714285714*G0_0_1_5_1 - 0.0289285714285714*G0_0_1_5_2 + 0.0578571428571426*G0_0_1_5_3 + 0.0771428571428567*G0_0_1_5_5 - 0.0265178571428569*G0_1_0_0_1 + 0.026517857142857*G0_1_0_0_2 + 0.00321428571428571*G0_1_0_0_4 - 0.00321428571428562*G0_1_0_0_5 - 0.0265178571428569*G0_1_0_1_0 + 0.355982142857141*G0_1_0_1_1 + 0.171964285714285*G0_1_0_1_3 + 0.0128571428571428*G0_1_0_1_4 + 0.0964285714285708*G0_1_0_1_5 + 0.026517857142857*G0_1_0_2_0 - 0.355982142857141*G0_1_0_2_2 - 0.171964285714285*G0_1_0_2_3 - 0.096428571428571*G0_1_0_2_4 - 0.0128571428571429*G0_1_0_2_5 + 0.171964285714285*G0_1_0_3_1 - 0.171964285714285*G0_1_0_3_2 - 0.0257142857142856*G0_1_0_3_4 + 0.0257142857142855*G0_1_0_3_5 + 0.00321428571428571*G0_1_0_4_0 + 0.0128571428571428*G0_1_0_4_1 - 0.096428571428571*G0_1_0_4_2 - 0.0257142857142856*G0_1_0_4_3 + 0.0257142857142856*G0_1_0_4_4 - 0.00321428571428563*G0_1_0_5_0 + 0.0964285714285708*G0_1_0_5_1 - 0.0128571428571429*G0_1_0_5_2 + 0.0257142857142855*G0_1_0_5_3 - 0.0257142857142859*G0_1_0_5_5 + 0.0216964285714285*G0_1_1_0_0 - 0.0474107142857139*G0_1_1_0_1 + 0.0144642857142856*G0_1_1_0_2 - 0.0337499999999998*G0_1_1_0_3 - 0.0112499999999999*G0_1_1_0_4 - 0.0482142857142854*G0_1_1_0_5 - 0.0474107142857139*G0_1_1_1_0 + 0.462053571428569*G0_1_1_1_1 - 0.0289285714285713*G0_1_1_1_2 + 0.210535714285713*G0_1_1_1_3 + 0.00803571428571427*G0_1_1_1_4 + 0.191249999999999*G0_1_1_1_5 + 0.0144642857142856*G0_1_1_2_0 - 0.0289285714285713*G0_1_1_2_1 - 0.0610714285714284*G0_1_1_2_2 - 0.128571428571428*G0_1_1_2_3 - 0.0385714285714284*G0_1_1_2_4 - 0.0466071428571427*G0_1_1_2_5 - 0.0337499999999998*G0_1_1_3_0 + 0.210535714285713*G0_1_1_3_1 - 0.128571428571428*G0_1_1_3_2 + 0.141428571428571*G0_1_1_3_3 + 0.0514285714285712*G0_1_1_3_4 + 0.160714285714285*G0_1_1_3_5 - 0.0112499999999999*G0_1_1_4_0 + 0.00803571428571427*G0_1_1_4_1 - 0.0385714285714284*G0_1_1_4_2 + 0.0514285714285712*G0_1_1_4_3 + 0.0899999999999995*G0_1_1_4_4 + 0.0771428571428568*G0_1_1_4_5 - 0.0482142857142854*G0_1_1_5_0 + 0.191249999999999*G0_1_1_5_1 - 0.0466071428571427*G0_1_1_5_2 + 0.160714285714285*G0_1_1_5_3 + 0.0771428571428568*G0_1_1_5_4 + 0.372857142857141*G0_1_1_5_5;
    A[46] = A[64] + 0.00642857142857146*G0_0_1_0_0 + 0.00241071428571427*G0_0_1_0_1 + 0.0120535714285713*G0_0_1_0_2 - 0.0160714285714285*G0_0_1_0_3 - 0.0160714285714285*G0_0_1_0_4 - 0.00482142857142853*G0_0_1_0_5 + 0.00241071428571427*G0_0_1_1_0 + 0.00642857142857146*G0_0_1_1_1 + 0.0120535714285713*G0_0_1_1_2 - 0.0160714285714285*G0_0_1_1_3 - 0.0160714285714285*G0_0_1_1_4 - 0.00482142857142854*G0_0_1_1_5 + 0.0120535714285713*G0_0_1_2_0 + 0.0120535714285713*G0_0_1_2_1 - 0.26517857142857*G0_0_1_2_2 - 0.0482142857142854*G0_0_1_2_3 - 0.0482142857142855*G0_0_1_2_4 - 0.0160714285714285*G0_0_1_3_0 - 0.0160714285714285*G0_0_1_3_1 - 0.0482142857142854*G0_0_1_3_2 + 0.128571428571428*G0_0_1_3_3 + 0.0642857142857141*G0_0_1_3_4 + 0.0321428571428571*G0_0_1_3_5 - 0.0160714285714285*G0_0_1_4_0 - 0.0160714285714285*G0_0_1_4_1 - 0.0482142857142855*G0_0_1_4_2 + 0.0642857142857141*G0_0_1_4_3 + 0.128571428571428*G0_0_1_4_4 + 0.032142857142857*G0_0_1_4_5 - 0.00482142857142853*G0_0_1_5_0 - 0.00482142857142854*G0_0_1_5_1 + 0.0321428571428571*G0_0_1_5_3 + 0.032142857142857*G0_0_1_5_4 + 0.0257142857142858*G0_0_1_5_5 - 0.00642857142857146*G0_1_0_0_0 - 0.00241071428571427*G0_1_0_0_1 - 0.0120535714285713*G0_1_0_0_2 + 0.0160714285714285*G0_1_0_0_3 + 0.0160714285714285*G0_1_0_0_4 + 0.00482142857142853*G0_1_0_0_5 - 0.00241071428571427*G0_1_0_1_0 - 0.00642857142857146*G0_1_0_1_1 - 0.0120535714285714*G0_1_0_1_2 + 0.0160714285714285*G0_1_0_1_3 + 0.0160714285714285*G0_1_0_1_4 + 0.00482142857142854*G0_1_0_1_5 - 0.0120535714285713*G0_1_0_2_0 - 0.0120535714285713*G0_1_0_2_1 + 0.26517857142857*G0_1_0_2_2 + 0.0482142857142854*G0_1_0_2_3 + 0.0482142857142855*G0_1_0_2_4 + 0.0160714285714285*G0_1_0_3_0 + 0.0160714285714285*G0_1_0_3_1 + 0.0482142857142854*G0_1_0_3_2 - 0.128571428571428*G0_1_0_3_3 - 0.0642857142857141*G0_1_0_3_4 - 0.0321428571428571*G0_1_0_3_5 + 0.0160714285714285*G0_1_0_4_0 + 0.0160714285714285*G0_1_0_4_1 + 0.0482142857142855*G0_1_0_4_2 - 0.0642857142857141*G0_1_0_4_3 - 0.128571428571428*G0_1_0_4_4 - 0.032142857142857*G0_1_0_4_5 + 0.00482142857142853*G0_1_0_5_0 + 0.00482142857142854*G0_1_0_5_1 - 0.0321428571428571*G0_1_0_5_3 - 0.0321428571428571*G0_1_0_5_4 - 0.0257142857142858*G0_1_0_5_5;
    A[66] = -A[64] - 0.00642857142857146*G0_0_1_0_0 - 0.00241071428571427*G0_0_1_0_1 - 0.0120535714285713*G0_0_1_0_2 + 0.0160714285714285*G0_0_1_0_3 + 0.0160714285714285*G0_0_1_0_4 + 0.00482142857142853*G0_0_1_0_5 - 0.00241071428571427*G0_0_1_1_0 - 0.00642857142857145*G0_0_1_1_1 - 0.0120535714285714*G0_0_1_1_2 + 0.0160714285714285*G0_0_1_1_3 + 0.0160714285714285*G0_0_1_1_4 + 0.00482142857142854*G0_0_1_1_5 - 0.0120535714285713*G0_0_1_2_0 - 0.0120535714285713*G0_0_1_2_1 + 0.26517857142857*G0_0_1_2_2 + 0.0482142857142854*G0_0_1_2_3 + 0.0482142857142855*G0_0_1_2_4 + 0.0160714285714285*G0_0_1_3_0 + 0.0160714285714285*G0_0_1_3_1 + 0.0482142857142854*G0_0_1_3_2 - 0.128571428571428*G0_0_1_3_3 - 0.0642857142857141*G0_0_1_3_4 - 0.0321428571428571*G0_0_1_3_5 + 0.0160714285714285*G0_0_1_4_0 + 0.0160714285714285*G0_0_1_4_1 + 0.0482142857142855*G0_0_1_4_2 - 0.0642857142857141*G0_0_1_4_3 - 0.128571428571428*G0_0_1_4_4 - 0.032142857142857*G0_0_1_4_5 + 0.00482142857142853*G0_0_1_5_0 + 0.00482142857142854*G0_0_1_5_1 - 0.0321428571428571*G0_0_1_5_3 - 0.032142857142857*G0_0_1_5_4 - 0.0257142857142858*G0_0_1_5_5 + 0.0940178571428568*G0_1_1_0_0 - 0.00883928571428567*G0_1_1_0_1 - 0.0160714285714285*G0_1_1_0_2 - 0.0176785714285713*G0_1_1_0_3 + 0.00160714285714289*G0_1_1_0_4 + 0.0353571428571427*G0_1_1_0_5 - 0.00883928571428568*G0_1_1_1_0 + 0.0168749999999999*G0_1_1_1_1 - 0.00803571428571423*G0_1_1_1_2 - 0.0176785714285713*G0_1_1_1_3 - 0.0466071428571426*G0_1_1_1_4 - 0.0241071428571428*G0_1_1_1_5 - 0.0160714285714285*G0_1_1_2_0 - 0.00803571428571423*G0_1_1_2_1 + 0.241071428571428*G0_1_1_2_2 + 0.032142857142857*G0_1_1_2_3 + 0.0160714285714285*G0_1_1_2_4 - 0.0241071428571427*G0_1_1_2_5 - 0.0176785714285713*G0_1_1_3_0 - 0.0176785714285713*G0_1_1_3_1 + 0.032142857142857*G0_1_1_3_2 + 0.0642857142857141*G0_1_1_3_3 + 0.128571428571428*G0_1_1_3_4 + 0.0835714285714283*G0_1_1_3_5 + 0.0016071428571429*G0_1_1_4_0 - 0.0466071428571426*G0_1_1_4_1 + 0.0160714285714285*G0_1_1_4_2 + 0.128571428571428*G0_1_1_4_3 + 0.449999999999998*G0_1_1_4_4 + 0.141428571428571*G0_1_1_4_5 + 0.0353571428571427*G0_1_1_5_0 - 0.0241071428571428*G0_1_1_5_1 - 0.0241071428571427*G0_1_1_5_2 + 0.0835714285714283*G0_1_1_5_3 + 0.141428571428571*G0_1_1_5_4 + 0.269999999999999*G0_1_1_5_5;
    A[44] = -A[64] + 0.00642857142857146*G0_1_0_0_0 + 0.00241071428571427*G0_1_0_0_1 + 0.0120535714285713*G0_1_0_0_2 - 0.0160714285714285*G0_1_0_0_3 - 0.0160714285714285*G0_1_0_0_4 - 0.00482142857142853*G0_1_0_0_5 + 0.00241071428571427*G0_1_0_1_0 + 0.00642857142857146*G0_1_0_1_1 + 0.0120535714285714*G0_1_0_1_2 - 0.0160714285714285*G0_1_0_1_3 - 0.0160714285714285*G0_1_0_1_4 - 0.00482142857142854*G0_1_0_1_5 + 0.0120535714285713*G0_1_0_2_0 + 0.0120535714285713*G0_1_0_2_1 - 0.26517857142857*G0_1_0_2_2 - 0.0482142857142854*G0_1_0_2_3 - 0.0482142857142855*G0_1_0_2_4 - 0.0160714285714285*G0_1_0_3_0 - 0.0160714285714285*G0_1_0_3_1 - 0.0482142857142854*G0_1_0_3_2 + 0.128571428571429*G0_1_0_3_3 + 0.0642857142857142*G0_1_0_3_4 + 0.0321428571428571*G0_1_0_3_5 - 0.0160714285714285*G0_1_0_4_0 - 0.0160714285714285*G0_1_0_4_1 - 0.0482142857142855*G0_1_0_4_2 + 0.0642857142857142*G0_1_0_4_3 + 0.128571428571428*G0_1_0_4_4 + 0.0321428571428571*G0_1_0_4_5 - 0.00482142857142853*G0_1_0_5_0 - 0.00482142857142854*G0_1_0_5_1 + 0.0321428571428571*G0_1_0_5_3 + 0.0321428571428571*G0_1_0_5_4 + 0.0257142857142858*G0_1_0_5_5 + 0.0233035714285714*G0_1_1_0_0 - 0.00642857142857139*G0_1_1_0_1 + 0.00401785714285711*G0_1_1_0_2 - 0.0626785714285711*G0_1_1_0_3 - 0.0337499999999998*G0_1_1_0_4 - 0.0289285714285712*G0_1_1_0_5 - 0.00642857142857139*G0_1_1_1_0 + 0.100446428571428*G0_1_1_1_1 - 0.00401785714285714*G0_1_1_1_2 - 0.0144642857142857*G0_1_1_1_3 - 0.0337499999999998*G0_1_1_1_4 + 0.0305357142857141*G0_1_1_1_5 + 0.00401785714285711*G0_1_1_2_0 - 0.00401785714285713*G0_1_1_2_1 - 0.0241071428571428*G0_1_1_2_2 - 0.032142857142857*G0_1_1_2_3 - 0.0160714285714285*G0_1_1_2_4 - 0.0241071428571428*G0_1_1_2_5 - 0.0626785714285711*G0_1_1_3_0 - 0.0144642857142857*G0_1_1_3_1 - 0.032142857142857*G0_1_1_3_2 + 0.578571428571426*G0_1_1_3_3 + 0.192857142857142*G0_1_1_3_4 + 0.173571428571428*G0_1_1_3_5 - 0.0337499999999998*G0_1_1_4_0 - 0.0337499999999998*G0_1_1_4_1 - 0.0160714285714285*G0_1_1_4_2 + 0.192857142857142*G0_1_1_4_3 + 0.192857142857142*G0_1_1_4_4 + 0.115714285714285*G0_1_1_4_5 - 0.0289285714285712*G0_1_1_5_0 + 0.0305357142857141*G0_1_1_5_1 - 0.0241071428571428*G0_1_1_5_2 + 0.173571428571428*G0_1_1_5_3 + 0.115714285714285*G0_1_1_5_4 + 0.295714285714284*G0_1_1_5_5;
    A[20] = -A[21] - 0.0168749999999999*G0_1_0_0_0 - 0.000446428571428574*G0_1_0_0_2 - 0.000357142857142853*G0_1_0_0_3 - 0.00499999999999996*G0_1_0_0_4 - 0.0121428571428571*G0_1_0_0_5 + 0.0168749999999999*G0_1_0_1_1 + 0.000446428571428572*G0_1_0_1_2 + 0.00499999999999996*G0_1_0_1_3 + 0.000357142857142852*G0_1_0_1_4 + 0.012142857142857*G0_1_0_1_5 - 0.000446428571428574*G0_1_0_2_0 + 0.000446428571428572*G0_1_0_2_1 - 0.00714285714285709*G0_1_0_2_3 + 0.00714285714285711*G0_1_0_2_4 - 0.000357142857142853*G0_1_0_3_0 + 0.00499999999999996*G0_1_0_3_1 - 0.00714285714285709*G0_1_0_3_2 - 0.0142857142857142*G0_1_0_3_3 + 0.000714285714285692*G0_1_0_3_5 - 0.00499999999999996*G0_1_0_4_0 + 0.000357142857142852*G0_1_0_4_1 + 0.00714285714285711*G0_1_0_4_2 + 0.0142857142857142*G0_1_0_4_4 - 0.000714285714285702*G0_1_0_4_5 - 0.0121428571428571*G0_1_0_5_0 + 0.0121428571428571*G0_1_0_5_1 + 0.000714285714285692*G0_1_0_5_3 - 0.000714285714285702*G0_1_0_5_4 - 0.019345238095238*G0_1_1_0_0 + 0.00157242063492062*G0_1_1_0_1 + 0.00112599206349206*G0_1_1_0_2 + 0.000575396825396824*G0_1_1_0_3 - 0.00178571428571426*G0_1_1_0_4 - 0.00892857142857137*G0_1_1_0_5 + 0.00157242063492062*G0_1_1_1_0 - 0.00247023809523808*G0_1_1_1_1 + 0.00157242063492063*G0_1_1_1_2 + 0.0032142857142857*G0_1_1_1_3 + 0.000932539682539677*G0_1_1_1_4 + 0.00321428571428569*G0_1_1_1_5 + 0.00112599206349206*G0_1_1_2_0 + 0.00157242063492063*G0_1_1_2_1 - 0.0193452380952381*G0_1_1_2_2 - 0.0089285714285714*G0_1_1_2_3 - 0.00178571428571429*G0_1_1_2_4 + 0.000575396825396817*G0_1_1_2_5 + 0.000575396825396824*G0_1_1_3_0 + 0.0032142857142857*G0_1_1_3_1 - 0.0089285714285714*G0_1_1_3_2 - 0.00888888888888887*G0_1_1_3_3 - 0.00301587301587301*G0_1_1_3_4 - 0.0023015873015873*G0_1_1_3_5 - 0.00178571428571426*G0_1_1_4_0 + 0.000932539682539677*G0_1_1_4_1 - 0.00178571428571429*G0_1_1_4_2 - 0.00301587301587301*G0_1_1_4_3 + 0.00539682539682537*G0_1_1_4_4 - 0.003015873015873*G0_1_1_4_5 - 0.00892857142857137*G0_1_1_5_0 + 0.00321428571428569*G0_1_1_5_1 + 0.000575396825396817*G0_1_1_5_2 - 0.0023015873015873*G0_1_1_5_3 - 0.003015873015873*G0_1_1_5_4 - 0.00888888888888885*G0_1_1_5_5;
    A[18] = -A[16] - 0.0198214285714284*G0_0_0_0_0 + 0.0126339285714285*G0_0_0_0_1 + 0.00486607142857141*G0_0_0_0_2 + 0.00553571428571424*G0_0_0_0_3 - 0.00321428571428568*G0_0_0_0_4 + 0.0126339285714285*G0_0_0_1_0 - 0.19017857142857*G0_0_0_1_1 + 0.0148660714285713*G0_0_0_1_2 - 0.0660714285714282*G0_0_0_1_3 + 0.0019642857142857*G0_0_0_1_4 - 0.0410714285714283*G0_0_0_1_5 + 0.00486607142857141*G0_0_0_2_0 + 0.0148660714285714*G0_0_0_2_1 - 0.0404464285714285*G0_0_0_2_2 + 0.0121428571428571*G0_0_0_2_3 - 0.0142857142857143*G0_0_0_2_4 + 0.00946428571428566*G0_0_0_2_5 + 0.00553571428571424*G0_0_0_3_0 - 0.0660714285714282*G0_0_0_3_1 + 0.0121428571428571*G0_0_0_3_2 - 0.0485714285714283*G0_0_0_3_3 - 0.0149999999999999*G0_0_0_3_4 - 0.0299999999999998*G0_0_0_3_5 - 0.00321428571428568*G0_0_0_4_0 + 0.0019642857142857*G0_0_0_4_1 - 0.0142857142857143*G0_0_0_4_2 - 0.0149999999999999*G0_0_0_4_3 - 0.0885714285714282*G0_0_0_4_4 - 0.0228571428571428*G0_0_0_4_5 - 0.0410714285714283*G0_0_0_5_1 + 0.00946428571428566*G0_0_0_5_2 - 0.0299999999999998*G0_0_0_5_3 - 0.0228571428571427*G0_0_0_5_4 - 0.0628571428571425*G0_0_0_5_5 - 0.0117857142857142*G0_0_1_0_0 + 0.0209374999999998*G0_0_1_0_1 - 0.00183035714285712*G0_0_1_0_2 + 0.0119642857142856*G0_0_1_0_3 + 0.00642857142857141*G0_0_1_0_4 + 0.0224999999999999*G0_0_1_0_5 + 0.0209374999999998*G0_0_1_1_0 - 0.243749999999999*G0_0_1_1_1 + 0.0204910714285713*G0_0_1_1_2 - 0.0874999999999995*G0_0_1_1_3 - 0.00660714285714283*G0_0_1_1_4 - 0.0946428571428566*G0_0_1_1_5 - 0.00183035714285712*G0_0_1_2_0 + 0.0204910714285713*G0_0_1_2_1 - 0.0286607142857143*G0_0_1_2_2 + 0.0174999999999999*G0_0_1_2_3 - 0.00571428571428572*G0_0_1_2_4 + 0.0116071428571428*G0_0_1_2_5 + 0.0119642857142856*G0_0_1_3_0 - 0.0874999999999995*G0_0_1_3_1 + 0.0174999999999999*G0_0_1_3_2 - 0.074285714285714*G0_0_1_3_3 - 0.0107142857142857*G0_0_1_3_4 - 0.0471428571428569*G0_0_1_3_5 + 0.00642857142857141*G0_0_1_4_0 - 0.00660714285714283*G0_0_1_4_1 - 0.00571428571428572*G0_0_1_4_2 - 0.0107142857142857*G0_0_1_4_3 + 0.0399999999999998*G0_0_1_4_4 - 0.00999999999999994*G0_0_1_4_5 + 0.0224999999999999*G0_0_1_5_0 - 0.0946428571428566*G0_0_1_5_1 + 0.0116071428571428*G0_0_1_5_2 - 0.0471428571428569*G0_0_1_5_3 - 0.00999999999999994*G0_0_1_5_4 - 0.088571428571428*G0_0_1_5_5;
    A[13] = -A[18] - 0.0230357142857141*G0_0_0_0_0 + 0.00758928571428565*G0_0_0_0_1 + 0.00508928571428569*G0_0_0_0_2 + 0.00714285714285708*G0_0_0_0_3 - 0.00571428571428568*G0_0_0_0_4 - 0.0017857142857143*G0_0_0_0_5 + 0.00758928571428565*G0_0_0_1_0 - 0.152678571428571*G0_0_0_1_1 + 0.00758928571428567*G0_0_0_1_2 - 0.0214285714285712*G0_0_0_1_3 + 0.00892857142857138*G0_0_0_1_4 - 0.0214285714285713*G0_0_0_1_5 + 0.00508928571428569*G0_0_0_2_0 + 0.00758928571428567*G0_0_0_2_1 - 0.0230357142857142*G0_0_0_2_2 - 0.0017857142857143*G0_0_0_2_3 - 0.00571428571428572*G0_0_0_2_4 + 0.00714285714285709*G0_0_0_2_5 + 0.00714285714285708*G0_0_0_3_0 - 0.0214285714285713*G0_0_0_3_1 - 0.0017857142857143*G0_0_0_3_2 - 0.0571428571428568*G0_0_0_3_3 - 0.032142857142857*G0_0_0_3_4 - 0.0285714285714284*G0_0_0_3_5 - 0.00571428571428568*G0_0_0_4_0 + 0.00892857142857138*G0_0_0_4_1 - 0.00571428571428572*G0_0_0_4_2 - 0.032142857142857*G0_0_0_4_3 - 0.109999999999999*G0_0_0_4_4 - 0.032142857142857*G0_0_0_4_5 - 0.0017857142857143*G0_0_0_5_0 - 0.0214285714285713*G0_0_0_5_1 + 0.00714285714285709*G0_0_0_5_2 - 0.0285714285714284*G0_0_0_5_3 - 0.032142857142857*G0_0_0_5_4 - 0.0571428571428569*G0_0_0_5_5;
    A[88] = -A[83] + 0.0940178571428566*G0_0_0_0_0 - 0.0160714285714285*G0_0_0_0_1 - 0.00883928571428568*G0_0_0_0_2 - 0.0176785714285713*G0_0_0_0_3 + 0.0353571428571427*G0_0_0_0_4 + 0.00160714285714287*G0_0_0_0_5 - 0.0160714285714285*G0_0_0_1_0 + 0.241071428571427*G0_0_0_1_1 - 0.00803571428571422*G0_0_0_1_2 + 0.0321428571428568*G0_0_0_1_3 - 0.0241071428571427*G0_0_0_1_4 + 0.0160714285714284*G0_0_0_1_5 - 0.00883928571428568*G0_0_0_2_0 - 0.00803571428571422*G0_0_0_2_1 + 0.016875*G0_0_0_2_2 - 0.0176785714285713*G0_0_0_2_3 - 0.0241071428571427*G0_0_0_2_4 - 0.0466071428571427*G0_0_0_2_5 - 0.0176785714285713*G0_0_0_3_0 + 0.0321428571428568*G0_0_0_3_1 - 0.0176785714285713*G0_0_0_3_2 + 0.0642857142857138*G0_0_0_3_3 + 0.0835714285714282*G0_0_0_3_4 + 0.128571428571428*G0_0_0_3_5 + 0.0353571428571427*G0_0_0_4_0 - 0.0241071428571427*G0_0_0_4_1 - 0.0241071428571427*G0_0_0_4_2 + 0.0835714285714282*G0_0_0_4_3 + 0.269999999999999*G0_0_0_4_4 + 0.141428571428571*G0_0_0_4_5 + 0.00160714285714287*G0_0_0_5_0 + 0.0160714285714284*G0_0_0_5_1 - 0.0466071428571427*G0_0_0_5_2 + 0.128571428571428*G0_0_0_5_3 + 0.141428571428571*G0_0_0_5_4 + 0.449999999999998*G0_0_0_5_5 - 0.00642857142857136*G0_1_0_0_0 - 0.0120535714285713*G0_1_0_0_1 - 0.00241071428571429*G0_1_0_0_2 + 0.0160714285714285*G0_1_0_0_3 + 0.00482142857142853*G0_1_0_0_4 + 0.0160714285714285*G0_1_0_0_5 - 0.0120535714285713*G0_1_0_1_0 + 0.26517857142857*G0_1_0_1_1 - 0.0120535714285713*G0_1_0_1_2 + 0.0482142857142853*G0_1_0_1_3 + 0.0482142857142853*G0_1_0_1_5 - 0.00241071428571429*G0_1_0_2_0 - 0.0120535714285714*G0_1_0_2_1 - 0.00642857142857133*G0_1_0_2_2 + 0.0160714285714286*G0_1_0_2_3 + 0.00482142857142862*G0_1_0_2_4 + 0.0160714285714285*G0_1_0_2_5 + 0.0160714285714285*G0_1_0_3_0 + 0.0482142857142853*G0_1_0_3_1 + 0.0160714285714286*G0_1_0_3_2 - 0.128571428571428*G0_1_0_3_3 - 0.032142857142857*G0_1_0_3_4 - 0.0642857142857142*G0_1_0_3_5 + 0.00482142857142853*G0_1_0_4_0 + 0.00482142857142862*G0_1_0_4_2 - 0.032142857142857*G0_1_0_4_3 - 0.0257142857142857*G0_1_0_4_4 - 0.0321428571428571*G0_1_0_4_5 + 0.0160714285714285*G0_1_0_5_0 + 0.0482142857142853*G0_1_0_5_1 + 0.0160714285714285*G0_1_0_5_2 - 0.0642857142857142*G0_1_0_5_3 - 0.0321428571428571*G0_1_0_5_4 - 0.128571428571428*G0_1_0_5_5;
    A[43] = -A[48] + 0.00241071428571431*G0_0_0_0_0 + 0.000401785714285709*G0_0_0_0_1 + 0.0164732142857142*G0_0_0_0_2 - 0.00642857142857141*G0_0_0_0_3 + 0.0257142857142856*G0_0_0_0_4 + 0.00160714285714284*G0_0_0_0_5 + 0.000401785714285709*G0_0_0_1_0 + 0.0080357142857143*G0_0_0_1_1 + 0.00441964285714284*G0_0_0_1_2 - 0.0160714285714285*G0_0_0_1_3 + 0.00321428571428569*G0_0_0_1_4 + 0.0164732142857142*G0_0_0_2_0 + 0.00441964285714284*G0_0_0_2_1 - 0.168749999999999*G0_0_0_2_2 - 0.00803571428571434*G0_0_0_2_3 - 0.0883928571428567*G0_0_0_2_4 + 0.00321428571428565*G0_0_0_2_5 - 0.00642857142857141*G0_0_0_3_0 - 0.0160714285714285*G0_0_0_3_1 - 0.00803571428571434*G0_0_0_3_2 + 0.154285714285714*G0_0_0_3_3 + 0.00642857142857147*G0_0_0_3_4 + 0.00642857142857149*G0_0_0_3_5 + 0.0257142857142856*G0_0_0_4_0 + 0.00321428571428569*G0_0_0_4_1 - 0.0883928571428567*G0_0_0_4_2 + 0.00642857142857147*G0_0_0_4_3 - 0.167142857142856*G0_0_0_4_4 - 0.0128571428571428*G0_0_0_4_5 + 0.00160714285714284*G0_0_0_5_0 + 0.00321428571428565*G0_0_0_5_2 + 0.00642857142857149*G0_0_0_5_3 - 0.0128571428571428*G0_0_0_5_4 - 0.0385714285714285*G0_0_0_5_5 + 0.00723214285714286*G0_1_0_0_0 + 0.00562499999999997*G0_1_0_0_2 - 0.0546428571428568*G0_1_0_0_3 - 0.020892857142857*G0_1_0_0_4 - 0.0257142857142856*G0_1_0_0_5 + 0.120535714285714*G0_1_0_1_1 - 0.00803571428571423*G0_1_0_1_2 - 0.0160714285714285*G0_1_0_1_3 - 0.0160714285714285*G0_1_0_1_4 + 0.0160714285714284*G0_1_0_1_5 + 0.00562499999999997*G0_1_0_2_0 - 0.00803571428571423*G0_1_0_2_1 - 0.00401785714285722*G0_1_0_2_2 - 0.00642857142857147*G0_1_0_2_3 - 0.0176785714285714*G0_1_0_2_4 - 0.00964285714285711*G0_1_0_2_5 - 0.0546428571428568*G0_1_0_3_0 - 0.0160714285714285*G0_1_0_3_1 - 0.00642857142857147*G0_1_0_3_2 + 0.578571428571426*G0_1_0_3_3 + 0.141428571428571*G0_1_0_3_4 + 0.128571428571428*G0_1_0_3_5 - 0.020892857142857*G0_1_0_4_0 - 0.0160714285714285*G0_1_0_4_1 - 0.0176785714285714*G0_1_0_4_2 + 0.141428571428571*G0_1_0_4_3 + 0.0385714285714284*G0_1_0_4_4 + 0.0514285714285712*G0_1_0_4_5 - 0.0257142857142856*G0_1_0_5_0 + 0.0160714285714284*G0_1_0_5_1 - 0.00964285714285711*G0_1_0_5_2 + 0.128571428571428*G0_1_0_5_3 + 0.0514285714285712*G0_1_0_5_4 - 0.0642857142857141*G0_1_0_5_5;
    A[95] = A[59] + 0.0803571428571426*G0_0_1_0_0 - 0.0152678571428571*G0_0_1_0_1 - 0.00723214285714284*G0_0_1_0_2 + 0.0064285714285714*G0_0_1_0_3 + 0.0803571428571425*G0_0_1_0_4 + 0.0482142857142855*G0_0_1_0_5 - 0.0152678571428571*G0_0_1_1_0 + 0.00482142857142859*G0_0_1_1_1 + 0.000803571428571419*G0_0_1_1_2 + 0.00321428571428572*G0_0_1_1_3 + 0.0192857142857142*G0_0_1_1_4 - 0.0128571428571428*G0_0_1_1_5 - 0.00723214285714284*G0_0_1_2_0 + 0.000803571428571419*G0_0_1_2_1 + 0.0160714285714286*G0_0_1_2_2 - 0.032142857142857*G0_0_1_2_4 - 0.0257142857142856*G0_0_1_2_5 + 0.0064285714285714*G0_0_1_3_0 + 0.00321428571428572*G0_0_1_3_1 + 0.0514285714285715*G0_0_1_3_3 - 0.0514285714285712*G0_0_1_3_4 + 0.0385714285714285*G0_0_1_3_5 + 0.0803571428571425*G0_0_1_4_0 + 0.0192857142857142*G0_0_1_4_1 - 0.032142857142857*G0_0_1_4_2 - 0.0514285714285712*G0_0_1_4_3 - 0.462857142857141*G0_0_1_4_4 + 0.0128571428571428*G0_0_1_4_5 + 0.0482142857142855*G0_0_1_5_0 - 0.0128571428571428*G0_0_1_5_1 - 0.0257142857142856*G0_0_1_5_2 + 0.0385714285714285*G0_0_1_5_3 + 0.0128571428571428*G0_0_1_5_4 + 0.179999999999999*G0_0_1_5_5 - 0.0803571428571426*G0_1_0_0_0 + 0.0152678571428571*G0_1_0_0_1 + 0.00723214285714284*G0_1_0_0_2 - 0.00642857142857141*G0_1_0_0_3 - 0.0803571428571425*G0_1_0_0_4 - 0.0482142857142855*G0_1_0_0_5 + 0.0152678571428571*G0_1_0_1_0 - 0.00482142857142858*G0_1_0_1_1 - 0.000803571428571419*G0_1_0_1_2 - 0.00321428571428572*G0_1_0_1_3 - 0.0192857142857142*G0_1_0_1_4 + 0.0128571428571428*G0_1_0_1_5 + 0.00723214285714284*G0_1_0_2_0 - 0.000803571428571419*G0_1_0_2_1 - 0.0160714285714286*G0_1_0_2_2 + 0.032142857142857*G0_1_0_2_4 + 0.0257142857142856*G0_1_0_2_5 - 0.00642857142857141*G0_1_0_3_0 - 0.00321428571428571*G0_1_0_3_1 - 0.0514285714285714*G0_1_0_3_3 + 0.0514285714285712*G0_1_0_3_4 - 0.0385714285714285*G0_1_0_3_5 - 0.0803571428571425*G0_1_0_4_0 - 0.0192857142857142*G0_1_0_4_1 + 0.032142857142857*G0_1_0_4_2 + 0.0514285714285712*G0_1_0_4_3 + 0.462857142857141*G0_1_0_4_4 - 0.0128571428571428*G0_1_0_4_5 - 0.0482142857142855*G0_1_0_5_0 + 0.0128571428571428*G0_1_0_5_1 + 0.0257142857142856*G0_1_0_5_2 - 0.0385714285714285*G0_1_0_5_3 - 0.0128571428571428*G0_1_0_5_4 - 0.179999999999999*G0_1_0_5_5;
    A[52] = -A[32] - 0.00374999999999998*G0_0_1_0_0 + 0.00267857142857141*G0_0_1_0_2 + 0.00428571428571427*G0_0_1_0_3 + 0.0171428571428571*G0_0_1_0_4 + 0.00107142857142858*G0_0_1_0_5 + 0.00374999999999993*G0_0_1_1_1 - 0.0026785714285714*G0_0_1_1_2 - 0.0171428571428571*G0_0_1_1_3 - 0.00428571428571428*G0_0_1_1_4 - 0.0010714285714286*G0_0_1_1_5 + 0.00267857142857141*G0_0_1_2_0 - 0.0026785714285714*G0_0_1_2_1 + 0.032142857142857*G0_0_1_2_3 - 0.032142857142857*G0_0_1_2_4 + 0.00428571428571427*G0_0_1_3_0 - 0.0171428571428571*G0_0_1_3_1 + 0.032142857142857*G0_0_1_3_2 - 0.00857142857142854*G0_0_1_3_5 + 0.0171428571428571*G0_0_1_4_0 - 0.00428571428571428*G0_0_1_4_1 - 0.032142857142857*G0_0_1_4_2 + 0.00857142857142855*G0_0_1_4_5 + 0.00107142857142858*G0_0_1_5_0 - 0.0010714285714286*G0_0_1_5_1 - 0.00857142857142854*G0_0_1_5_3 + 0.00857142857142855*G0_0_1_5_4 + 0.0326785714285712*G0_1_1_0_0 - 0.00642857142857138*G0_1_1_0_1 - 0.00339285714285713*G0_1_1_0_2 - 0.000357142857142842*G0_1_1_0_3 + 0.00892857142857137*G0_1_1_0_4 + 0.0114285714285714*G0_1_1_0_5 - 0.00642857142857138*G0_1_1_1_0 + 0.0364285714285712*G0_1_1_1_1 - 0.00607142857142853*G0_1_1_1_2 - 0.0082142857142857*G0_1_1_1_3 - 0.00464285714285712*G0_1_1_1_4 + 0.0103571428571428*G0_1_1_1_5 - 0.00339285714285713*G0_1_1_2_0 - 0.00607142857142853*G0_1_1_2_1 + 0.0776785714285713*G0_1_1_2_2 + 0.032142857142857*G0_1_1_2_3 - 0.00392857142857138*G0_1_1_2_5 - 0.000357142857142843*G0_1_1_3_0 - 0.0082142857142857*G0_1_1_3_1 + 0.032142857142857*G0_1_1_3_2 + 0.0114285714285713*G0_1_1_3_3 + 0.00999999999999995*G0_1_1_3_4 + 0.0085714285714285*G0_1_1_3_5 + 0.00892857142857137*G0_1_1_4_0 - 0.00464285714285712*G0_1_1_4_1 + 0.00999999999999995*G0_1_1_4_3 + 0.0114285714285714*G0_1_1_4_4 + 0.017142857142857*G0_1_1_4_5 + 0.0114285714285714*G0_1_1_5_0 + 0.0103571428571428*G0_1_1_5_1 - 0.00392857142857138*G0_1_1_5_2 + 0.0085714285714285*G0_1_1_5_3 + 0.017142857142857*G0_1_1_5_4 + 0.0742857142857138*G0_1_1_5_5;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class laplacian_f2_p2_q3_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  laplacian_f2_p2_q3_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q3_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p2_q3_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p2_q3_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p2_q3_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p2_q3_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p2_q3_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p2_q3_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p2_q3_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p2_q3_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p2_q3_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
