// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F2_P2_Q4_TENSOR_H
#define __LAPLACIAN_F2_P2_Q4_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f2_p2_q4_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p2_q4_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q4_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p2_q4_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class laplacian_f2_p2_q4_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p2_q4_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q4_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p2_q4_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p2_q4_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p2_q4_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q4_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p2_q4_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p2_q4_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p2_q4_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q4_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3*m.num_entities[1] + 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p2_q4_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f2_p2_q4_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f2_p2_q4_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q4_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    432
    // Number of operations (multiply-add pairs) for tensor contraction: 19073
    // Total number of operations (multiply-add pairs):                  19516
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3 = det*(w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4 = det*(w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5 = det*(w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3 = det*(w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4 = det*(w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5 = det*(w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3 = det*(w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4 = det*(w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5 = det*(w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0 = det*(w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1 = det*(w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2 = det*(w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3 = det*(w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4 = det*(w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5 = det*(w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0 = det*(w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1 = det*(w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2 = det*(w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3 = det*(w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4 = det*(w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5 = det*(w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0 = det*(w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1 = det*(w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2 = det*(w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3 = det*(w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4 = det*(w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5 = det*(w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3 = det*(w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4 = det*(w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5 = det*(w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3 = det*(w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4 = det*(w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5 = det*(w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3 = det*(w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4 = det*(w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5 = det*(w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0 = det*(w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1 = det*(w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2 = det*(w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3 = det*(w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4 = det*(w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5 = det*(w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0 = det*(w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1 = det*(w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2 = det*(w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3 = det*(w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4 = det*(w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5 = det*(w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0 = det*(w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1 = det*(w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2 = det*(w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3 = det*(w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4 = det*(w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5 = det*(w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3 = det*(w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4 = det*(w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5 = det*(w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3 = det*(w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4 = det*(w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5 = det*(w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3 = det*(w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4 = det*(w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5 = det*(w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0 = det*(w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1 = det*(w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2 = det*(w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3 = det*(w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4 = det*(w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5 = det*(w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0 = det*(w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1 = det*(w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2 = det*(w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3 = det*(w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4 = det*(w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5 = det*(w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0 = det*(w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1 = det*(w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2 = det*(w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3 = det*(w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4 = det*(w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5 = det*(w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3 = det*(w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4 = det*(w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5 = det*(w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3 = det*(w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4 = det*(w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5 = det*(w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3 = det*(w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4 = det*(w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5 = det*(w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0 = det*(w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1 = det*(w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2 = det*(w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3 = det*(w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4 = det*(w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5 = det*(w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0 = det*(w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1 = det*(w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2 = det*(w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3 = det*(w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4 = det*(w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5 = det*(w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0 = det*(w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1 = det*(w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2 = det*(w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3 = det*(w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4 = det*(w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5 = det*(w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[108] = -0.00010261343594676*G0_0_0_0_0 + 0.000564373897707256*G0_0_0_0_1 + 0.00466891133557817*G0_0_0_0_2 - 0.00318101651434999*G0_0_0_0_3 + 0.0120057720057724*G0_0_0_0_4 - 0.00379669713003059*G0_0_0_0_5 + 0.000564373897707255*G0_0_0_1_0 - 0.00297578964245641*G0_0_0_1_1 + 0.0030270963604298*G0_0_0_1_2 + 0.00379669713003072*G0_0_0_1_3 + 0.000513067179733826*G0_0_0_1_4 - 0.00153920153920161*G0_0_0_1_5 + 0.00466891133557817*G0_0_0_2_0 + 0.0030270963604298*G0_0_0_2_1 + 0.0615680615680633*G0_0_0_2_2 - 0.0190860990860999*G0_0_0_2_3 - 0.0301683501683513*G0_0_0_2_4 - 0.00307840307840319*G0_0_0_2_5 - 0.00318101651434999*G0_0_0_3_0 + 0.00379669713003073*G0_0_0_3_1 - 0.0190860990860999*G0_0_0_3_2 + 0.00738816738816809*G0_0_0_3_3 + 0.00533589866923231*G0_0_0_3_4 + 0.0125188391855064*G0_0_0_3_5 + 0.0120057720057724*G0_0_0_4_0 + 0.000513067179733825*G0_0_0_4_1 - 0.0301683501683513*G0_0_0_4_2 + 0.00533589866923232*G0_0_0_4_3 - 0.202764149430822*G0_0_0_4_4 + 0.0051306717973387*G0_0_0_4_5 - 0.00379669713003059*G0_0_0_5_0 - 0.00153920153920161*G0_0_0_5_1 - 0.00307840307840319*G0_0_0_5_2 + 0.0125188391855064*G0_0_0_5_3 + 0.0051306717973387*G0_0_0_5_4 + 0.0110822510822515*G0_0_0_5_5 + 0.00138528138528145*G0_0_1_0_0 - 0.000461760461760435*G0_0_1_0_1 + 0.000153920153920167*G0_0_1_0_2 + 0.000718294051627409*G0_0_1_0_3 + 0.00379669713003059*G0_0_1_0_4 + 0.000615680615680676*G0_0_1_0_5 - 0.000461760461760435*G0_0_1_1_0 - 0.00692640692640779*G0_0_1_1_1 + 0.000102613435946796*G0_0_1_1_2 - 0.00184704184704189*G0_0_1_1_3 + 0.00266794933461608*G0_0_1_1_4 + 0.000820907487573975*G0_0_1_1_5 + 0.000153920153920167*G0_0_1_2_0 + 0.000102613435946796*G0_0_1_2_1 + 0.00651595318261985*G0_0_1_2_2 + 0.00215488215488212*G0_0_1_2_3 - 0.00174442841109518*G0_0_1_2_4 - 0.000410453743787089*G0_0_1_2_5 + 0.000718294051627409*G0_0_1_3_0 - 0.00184704184704189*G0_0_1_3_1 + 0.00215488215488212*G0_0_1_3_2 - 0.00266794933461604*G0_0_1_3_3 - 0.00677248677248698*G0_0_1_3_4 - 0.000615680615680642*G0_0_1_3_5 + 0.00379669713003059*G0_0_1_4_0 + 0.00266794933461608*G0_0_1_4_1 - 0.00174442841109518*G0_0_1_4_2 - 0.00677248677248698*G0_0_1_4_3 - 0.0318101651434995*G0_0_1_4_4 - 0.00451499118165799*G0_0_1_4_5 + 0.000615680615680676*G0_0_1_5_0 + 0.000820907487573975*G0_0_1_5_1 - 0.000410453743787089*G0_0_1_5_2 - 0.000615680615680642*G0_0_1_5_3 - 0.00451499118165799*G0_0_1_5_4 + 0.00184704184704173*G0_0_1_5_5 + 0.00302709636042968*G0_1_0_0_0 + 0.000359147025813728*G0_1_0_0_1 + 0.0026679493346161*G0_1_0_0_2 - 0.00143658810325482*G0_1_0_0_3 + 0.0265768799102141*G0_1_0_0_4 - 0.000718294051627429*G0_1_0_0_5 + 0.000359147025813728*G0_1_0_1_0 - 0.00312970979637664*G0_1_0_1_1 + 0.00241141574474917*G0_1_0_1_2 - 0.000615680615680605*G0_1_0_1_3 - 0.000718294051627419*G0_1_0_1_4 + 0.0026679493346161*G0_1_0_2_0 + 0.00241141574474917*G0_1_0_2_1 + 0.0460221260221272*G0_1_0_2_2 - 0.0104665704665709*G0_1_0_2_3 - 0.0379669713003059*G0_1_0_2_4 + 0.000718294051627443*G0_1_0_2_5 - 0.00143658810325482*G0_1_0_3_0 - 0.000615680615680607*G0_1_0_3_1 - 0.0104665704665709*G0_1_0_3_2 - 0.00677248677248692*G0_1_0_3_3 + 0.00430976430976447*G0_1_0_3_4 + 0.00143658810325476*G0_1_0_3_5 + 0.0265768799102141*G0_1_0_4_0 - 0.000718294051627419*G0_1_0_4_1 - 0.0379669713003059*G0_1_0_4_2 + 0.00430976430976446*G0_1_0_4_3 - 0.0531537598204284*G0_1_0_4_4 - 0.000718294051627428*G0_1_0_5_0 + 0.000718294051627443*G0_1_0_5_2 + 0.00143658810325476*G0_1_0_5_3 - 0.00143658810325496*G0_1_0_5_5 - 0.00513067179733873*G0_1_1_0_0 - 0.000564373897707193*G0_1_1_0_1 + 0.00112874779541451*G0_1_1_0_3 + 0.00554112554112573*G0_1_1_0_4 - 0.00153920153920159*G0_1_1_0_5 - 0.000564373897707193*G0_1_1_1_0 + 0.000564373897707281*G0_1_1_1_2 - 0.00266794933461614*G0_1_1_1_3 + 0.00266794933461588*G0_1_1_1_5 + 0.000564373897707281*G0_1_1_2_1 + 0.00513067179733844*G0_1_1_2_2 + 0.00153920153920153*G0_1_1_2_3 - 0.00554112554112575*G0_1_1_2_4 - 0.00112874779541448*G0_1_1_2_5 + 0.00112874779541451*G0_1_1_3_0 - 0.00266794933461614*G0_1_1_3_1 + 0.00153920153920153*G0_1_1_3_2 - 0.00451499118165805*G0_1_1_3_3 - 0.00225749559082901*G0_1_1_3_4 + 0.00554112554112573*G0_1_1_4_0 - 0.00554112554112575*G0_1_1_4_2 - 0.00225749559082901*G0_1_1_4_3 + 0.00225749559082896*G0_1_1_4_5 - 0.00153920153920159*G0_1_1_5_0 + 0.00266794933461588*G0_1_1_5_1 - 0.00112874779541448*G0_1_1_5_2 + 0.00225749559082897*G0_1_1_5_4 + 0.00451499118165781*G0_1_1_5_5;
    A[181] = -0.0222158088824763*G0_0_0_0_0 - 0.00123136123136129*G0_0_0_0_1 + 0.00474587141253823*G0_0_0_0_2 - 0.000666987333654026*G0_0_0_0_3 - 0.0225236491903166*G0_0_0_0_4 - 0.00354016354016366*G0_0_0_0_5 - 0.00123136123136129*G0_0_0_1_0 + 0.0336059002725684*G0_0_0_1_1 - 0.00546416546416566*G0_0_0_1_2 + 0.0231393298059973*G0_0_0_1_3 + 0.00682379349046038*G0_0_0_1_4 + 0.00661856661856692*G0_0_0_1_5 + 0.00474587141253823*G0_0_0_2_0 - 0.00546416546416566*G0_0_0_2_1 + 0.00430976430976446*G0_0_0_2_2 - 0.00194965528298869*G0_0_0_2_3 + 0.010363957030624*G0_0_0_2_4 - 0.00184704184704193*G0_0_0_2_5 - 0.000666987333654026*G0_0_0_3_0 + 0.0231393298059973*G0_0_0_3_1 - 0.00194965528298869*G0_0_0_3_2 + 0.00595157928491277*G0_0_0_3_3 - 0.0123136123136127*G0_0_0_3_4 + 0.00502805836139191*G0_0_0_3_5 - 0.0225236491903166*G0_0_0_4_0 + 0.00682379349046038*G0_0_0_4_1 + 0.010363957030624*G0_0_0_4_2 - 0.0123136123136127*G0_0_0_4_3 - 0.11349046015713*G0_0_0_4_4 - 0.00995350328683691*G0_0_0_4_5 - 0.00354016354016366*G0_0_0_5_0 + 0.00661856661856692*G0_0_0_5_1 - 0.00184704184704193*G0_0_0_5_2 + 0.00502805836139191*G0_0_0_5_3 - 0.00995350328683691*G0_0_0_5_4 + 0.0127240660573999*G0_0_0_5_5 + 0.00107744107744111*G0_1_0_0_0 - 0.000436107102773783*G0_1_0_0_1 - 0.000461760461760478*G0_1_0_0_2 + 0.00189834856501529*G0_1_0_0_3 + 0.00354016354016366*G0_1_0_0_4 + 0.0132884399551071*G0_1_0_0_5 - 0.000436107102773782*G0_1_0_1_0 - 0.00274490941157617*G0_1_0_1_2 + 0.0128266794933466*G0_1_0_1_3 + 0.00318101651434996*G0_1_0_1_4 - 0.0128266794933466*G0_1_0_1_5 - 0.000461760461760478*G0_1_0_2_0 - 0.00274490941157617*G0_1_0_2_1 + 0.00210357543690884*G0_1_0_2_2 + 5.13067179733831e-05*G0_1_0_2_3 + 0.00148789482122821*G0_1_0_2_4 - 0.00128266794933467*G0_1_0_2_5 + 0.00189834856501529*G0_1_0_3_0 + 0.0128266794933466*G0_1_0_3_1 + 5.13067179733836e-05*G0_1_0_3_2 + 0.00225749559082891*G0_1_0_3_3 - 0.0101587301587305*G0_1_0_3_4 - 0.00123136123136126*G0_1_0_3_5 + 0.00354016354016366*G0_1_0_4_0 + 0.00318101651434996*G0_1_0_4_1 + 0.00148789482122821*G0_1_0_4_2 - 0.0101587301587305*G0_1_0_4_3 - 0.0123136123136128*G0_1_0_4_4 - 0.00379669713003058*G0_1_0_4_5 + 0.0132884399551071*G0_1_0_5_0 - 0.0128266794933466*G0_1_0_5_1 - 0.00128266794933467*G0_1_0_5_2 - 0.00123136123136126*G0_1_0_5_3 - 0.00379669713003058*G0_1_0_5_4 + 0.000205226871893577*G0_1_0_5_5;
    A[21] = 0.0144428411095083*G0_0_0_0_0 + 0.000286462508684734*G0_0_0_0_1 - 0.00237721126610023*G0_0_0_0_2 - 0.000153920153920164*G0_0_0_0_3 + 0.0156656512212073*G0_0_0_0_4 - 0.00063278285500511*G0_0_0_0_5 + 0.000286462508684734*G0_0_0_1_0 - 0.0062850729517398*G0_0_0_1_1 + 0.000906418684196497*G0_0_0_1_2 - 0.00321522099299891*G0_0_0_1_3 - 0.000359147025813697*G0_0_0_1_4 + 0.000906418684196527*G0_0_0_1_5 - 0.00237721126610023*G0_0_0_2_0 + 0.000906418684196497*G0_0_0_2_1 + 0.00346320346320353*G0_0_0_2_2 - 0.000564373897707239*G0_0_0_2_3 - 0.00651595318262006*G0_0_0_2_4 + 0.00141948586393036*G0_0_0_2_5 - 0.000153920153920164*G0_0_0_3_0 - 0.00321522099299891*G0_0_0_3_1 - 0.000564373897707239*G0_0_0_3_2 - 0.00246272246272253*G0_0_0_3_3 + 0.00102613435946771*G0_0_0_3_4 - 0.0025311314200204*G0_0_0_3_5 + 0.0156656512212073*G0_0_0_4_0 - 0.000359147025813697*G0_0_0_4_1 - 0.00651595318262006*G0_0_0_4_2 + 0.00102613435946771*G0_0_0_4_3 + 0.0385826519159864*G0_0_0_4_4 - 0.00212067767623333*G0_0_0_4_5 - 0.000632782855005109*G0_0_0_5_0 + 0.000906418684196527*G0_0_0_5_1 + 0.00141948586393036*G0_0_0_5_2 - 0.0025311314200204*G0_0_0_5_3 - 0.00212067767623333*G0_0_0_5_4 - 0.00889316444872029*G0_0_0_5_5 - 0.020573993907328*G0_0_1_0_0 - 0.000269360269360286*G0_0_1_0_1 + 0.000641333974667334*G0_0_1_0_2 - 0.000307840307840318*G0_0_1_0_3 + 0.00097482764149432*G0_0_1_0_4 + 0.000205226871893525*G0_0_1_0_5 - 0.000269360269360286*G0_0_1_1_0 + 0.000457484901929355*G0_0_1_1_2 - 0.00160761049649942*G0_0_1_1_3 - 0.000188124632569077*G0_0_1_1_4 + 0.00160761049649948*G0_0_1_1_5 + 0.000641333974667334*G0_0_1_2_0 + 0.000457484901929355*G0_0_1_2_1 + 0.00256533589866931*G0_0_1_2_2 - 0.000530169419058317*G0_0_1_2_3 - 0.00372828817273273*G0_0_1_2_4 + 0.000735396290951874*G0_0_1_2_5 - 0.000307840307840318*G0_0_1_3_0 - 0.00160761049649942*G0_0_1_3_1 - 0.000530169419058317*G0_0_1_3_2 - 0.00164181497514833*G0_0_1_3_3 + 0.000991929880818793*G0_0_1_3_4 - 0.000855111966223105*G0_0_1_3_5 + 0.00097482764149432*G0_0_1_4_0 - 0.000188124632569077*G0_0_1_4_1 - 0.00372828817273273*G0_0_1_4_2 + 0.000991929880818793*G0_0_1_4_3 + 0.0222329111218007*G0_0_1_4_4 - 0.0010945433167656*G0_0_1_4_5 + 0.000205226871893525*G0_0_1_5_0 + 0.00160761049649948*G0_0_1_5_1 + 0.000735396290951874*G0_0_1_5_2 - 0.000855111966223106*G0_0_1_5_3 - 0.0010945433167656*G0_0_1_5_4 + 0.00335203890759459*G0_0_1_5_5;
    A[52] = A[108] + 0.00164181497514823*G0_0_1_0_0 + 0.000820907487574163*G0_0_1_0_1 + 0.00251402918069594*G0_0_1_0_2 - 0.00215488215488223*G0_0_1_0_3 + 0.0227801827801835*G0_0_1_0_4 - 0.00133397466730811*G0_0_1_0_5 + 0.000820907487574163*G0_0_1_1_0 + 0.00379669713003115*G0_0_1_1_1 + 0.00230880230880238*G0_0_1_1_2 + 0.00123136123136129*G0_0_1_1_3 - 0.0033862433862435*G0_0_1_1_4 - 0.00082090748757402*G0_0_1_1_5 + 0.00251402918069594*G0_0_1_2_0 + 0.00230880230880238*G0_0_1_2_1 + 0.0395061728395074*G0_0_1_2_2 - 0.012621452621453*G0_0_1_2_3 - 0.0362225428892107*G0_0_1_2_4 + 0.00112874779541453*G0_0_1_2_5 - 0.00215488215488223*G0_0_1_3_0 + 0.00123136123136129*G0_0_1_3_1 - 0.012621452621453*G0_0_1_3_2 - 0.00410453743787088*G0_0_1_3_3 + 0.0110822510822514*G0_0_1_3_4 + 0.0020522687189354*G0_0_1_3_5 + 0.0227801827801835*G0_0_1_4_0 - 0.0033862433862435*G0_0_1_4_1 - 0.0362225428892107*G0_0_1_4_2 + 0.0110822510822514*G0_0_1_4_3 - 0.0213435946769289*G0_0_1_4_4 + 0.00451499118165793*G0_0_1_4_5 - 0.0013339746673081*G0_0_1_5_0 - 0.00082090748757402*G0_0_1_5_1 + 0.00112874779541453*G0_0_1_5_2 + 0.0020522687189354*G0_0_1_5_3 + 0.00451499118165792*G0_0_1_5_4 - 0.00328362995029669*G0_0_1_5_5 - 0.00164181497514823*G0_1_0_0_0 - 0.000820907487574164*G0_1_0_0_1 - 0.00251402918069594*G0_1_0_0_2 + 0.00215488215488223*G0_1_0_0_3 - 0.0227801827801835*G0_1_0_0_4 + 0.0013339746673081*G0_1_0_0_5 - 0.000820907487574163*G0_1_0_1_0 - 0.00379669713003115*G0_1_0_1_1 - 0.00230880230880238*G0_1_0_1_2 - 0.00123136123136129*G0_1_0_1_3 + 0.0033862433862435*G0_1_0_1_4 + 0.00082090748757402*G0_1_0_1_5 - 0.00251402918069594*G0_1_0_2_0 - 0.00230880230880238*G0_1_0_2_1 - 0.0395061728395074*G0_1_0_2_2 + 0.012621452621453*G0_1_0_2_3 + 0.0362225428892107*G0_1_0_2_4 - 0.00112874779541453*G0_1_0_2_5 + 0.00215488215488223*G0_1_0_3_0 - 0.00123136123136129*G0_1_0_3_1 + 0.012621452621453*G0_1_0_3_2 + 0.00410453743787088*G0_1_0_3_3 - 0.0110822510822515*G0_1_0_3_4 - 0.0020522687189354*G0_1_0_3_5 - 0.0227801827801835*G0_1_0_4_0 + 0.0033862433862435*G0_1_0_4_1 + 0.0362225428892107*G0_1_0_4_2 - 0.0110822510822514*G0_1_0_4_3 + 0.0213435946769289*G0_1_0_4_4 - 0.00451499118165792*G0_1_0_4_5 + 0.0013339746673081*G0_1_0_5_0 + 0.00082090748757402*G0_1_0_5_1 - 0.00112874779541453*G0_1_0_5_2 - 0.0020522687189354*G0_1_0_5_3 - 0.00451499118165793*G0_1_0_5_4 + 0.00328362995029669*G0_1_0_5_5;
    A[35] = 0.00233445566778908*G0_1_0_0_0 + 0.00167174389396617*G0_1_0_0_1 - 0.0225322003099788*G0_1_0_0_2 - 0.0064988509432956*G0_1_0_0_3 - 0.0115440115440119*G0_1_0_0_4 - 0.000820907487574186*G0_1_0_0_5 + 0.00167174389396617*G0_1_0_1_0 + 0.00233445566778909*G0_1_0_1_1 - 0.0225322003099788*G0_1_0_1_2 - 0.0115440115440119*G0_1_0_1_3 - 0.0064988509432956*G0_1_0_1_4 - 0.000820907487574178*G0_1_0_1_5 - 0.0225322003099788*G0_1_0_2_0 - 0.0225322003099788*G0_1_0_2_1 + 0.378771845438525*G0_1_0_2_2 + 0.0951739618406317*G0_1_0_2_3 + 0.0951739618406317*G0_1_0_2_4 + 0.00504516060071639*G0_1_0_2_5 - 0.0064988509432956*G0_1_0_3_0 - 0.0115440115440119*G0_1_0_3_1 + 0.0951739618406317*G0_1_0_3_2 + 0.0519908075463649*G0_1_0_3_3 + 0.0259954037731824*G0_1_0_3_4 + 0.00290738068515858*G0_1_0_3_5 - 0.0115440115440119*G0_1_0_4_0 - 0.0064988509432956*G0_1_0_4_1 + 0.0951739618406317*G0_1_0_4_2 + 0.0259954037731824*G0_1_0_4_3 + 0.0519908075463648*G0_1_0_4_4 + 0.00290738068515858*G0_1_0_4_5 - 0.000820907487574186*G0_1_0_5_0 - 0.000820907487574178*G0_1_0_5_1 + 0.00504516060071639*G0_1_0_5_2 + 0.00290738068515858*G0_1_0_5_3 + 0.00290738068515858*G0_1_0_5_4 - 0.000752498530276287*G0_1_0_5_5 - 0.00202661535994876*G0_1_1_0_0 + 0.00304419859975427*G0_1_1_0_1 - 0.00664849553738464*G0_1_1_0_2 - 0.000359147025813703*G0_1_1_0_3 - 0.00203516647961099*G0_1_1_0_4 + 0.00167601945379729*G0_1_1_0_5 + 0.00304419859975427*G0_1_1_1_0 - 0.0145454545454552*G0_1_1_1_1 - 0.0106033883811665*G0_1_1_1_2 - 0.0111335578002249*G0_1_1_1_3 - 0.00203516647961099*G0_1_1_1_4 - 0.00846560846560883*G0_1_1_1_5 - 0.00664849553738464*G0_1_1_2_0 - 0.0106033883811665*G0_1_1_2_1 + 0.0950456950456982*G0_1_1_2_2 + 0.0531879642990772*G0_1_1_2_3 + 0.0265939821495386*G0_1_1_2_4 + 0.00538720538720559*G0_1_1_2_5 - 0.000359147025813703*G0_1_1_3_0 - 0.0111335578002249*G0_1_1_3_1 + 0.0531879642990772*G0_1_1_3_2 + 0.0143658810325482*G0_1_1_3_3 + 0.00478862701084941*G0_1_1_3_4 - 0.0100561167227837*G0_1_1_3_5 - 0.00203516647961099*G0_1_1_4_0 - 0.00203516647961099*G0_1_1_4_1 + 0.0265939821495386*G0_1_1_4_2 + 0.00478862701084941*G0_1_1_4_3 + 0.0047886270108494*G0_1_1_4_4 - 0.00670407781518913*G0_1_1_4_5 + 0.00167601945379729*G0_1_1_5_0 - 0.00846560846560883*G0_1_1_5_1 + 0.00538720538720559*G0_1_1_5_2 - 0.0100561167227837*G0_1_1_5_3 - 0.00670407781518913*G0_1_1_5_4 - 0.0439185505852188*G0_1_1_5_5;
    A[26] = -0.0168799102132442*G0_0_0_0_0 + 0.0119288119288123*G0_0_0_0_1 + 0.00137245470578808*G0_0_0_0_2 + 0.00446368446368462*G0_0_0_0_3 - 0.00764470097803457*G0_0_0_0_4 + 0.000410453743787106*G0_0_0_0_5 + 0.0119288119288123*G0_0_0_1_0 - 0.283726150392827*G0_0_0_1_1 + 0.0158837047725942*G0_0_0_1_2 - 0.0685799796910932*G0_0_0_1_3 + 0.000342044786489266*G0_0_0_1_4 - 0.0419859975415548*G0_0_0_1_5 + 0.00137245470578808*G0_0_0_2_0 + 0.0158837047725942*G0_0_0_2_1 - 0.00436107102773784*G0_0_0_2_2 + 0.00950884506440094*G0_0_0_2_3 + 0.00249692694137147*G0_0_0_2_4 + 0.00613970391748192*G0_0_0_2_5 + 0.00446368446368462*G0_0_0_3_0 - 0.0685799796910932*G0_0_0_3_1 + 0.00950884506440094*G0_0_0_3_2 - 0.0472021805355155*G0_0_0_3_3 - 0.0096114585003477*G0_0_0_3_4 - 0.0212067767623331*G0_0_0_3_5 - 0.00764470097803457*G0_0_0_4_0 + 0.000342044786489265*G0_0_0_4_1 + 0.00249692694137147*G0_0_0_4_2 - 0.0096114585003477*G0_0_0_4_3 - 0.0431660520549423*G0_0_0_4_4 - 0.0129634974079423*G0_0_0_4_5 + 0.000410453743787105*G0_0_0_5_0 - 0.0419859975415548*G0_0_0_5_1 + 0.00613970391748192*G0_0_0_5_2 - 0.0212067767623331*G0_0_0_5_3 - 0.0129634974079423*G0_0_0_5_4 - 0.0376249265138168*G0_0_0_5_5 - 0.00233445566778906*G0_0_1_0_0 + 0.0225322003099789*G0_0_1_0_1 - 0.00167174389396618*G0_0_1_0_2 + 0.00649885094329561*G0_0_1_0_3 + 0.000820907487574184*G0_0_1_0_4 + 0.011544011544012*G0_0_1_0_5 + 0.0225322003099789*G0_0_1_1_0 - 0.378771845438526*G0_0_1_1_1 + 0.0225322003099789*G0_0_1_1_2 - 0.0951739618406319*G0_0_1_1_3 - 0.0050451606007163*G0_0_1_1_4 - 0.0951739618406323*G0_0_1_1_5 - 0.00167174389396618*G0_0_1_2_0 + 0.0225322003099789*G0_0_1_2_1 - 0.00233445566778909*G0_0_1_2_2 + 0.0115440115440119*G0_0_1_2_3 + 0.000820907487574178*G0_0_1_2_4 + 0.00649885094329564*G0_0_1_2_5 + 0.00649885094329561*G0_0_1_3_0 - 0.0951739618406319*G0_0_1_3_1 + 0.0115440115440119*G0_0_1_3_2 - 0.0519908075463649*G0_0_1_3_3 - 0.00290738068515856*G0_0_1_3_4 - 0.0259954037731825*G0_0_1_3_5 + 0.000820907487574184*G0_0_1_4_0 - 0.0050451606007163*G0_0_1_4_1 + 0.000820907487574178*G0_0_1_4_2 - 0.00290738068515856*G0_0_1_4_3 + 0.000752498530276327*G0_0_1_4_4 - 0.00290738068515855*G0_0_1_4_5 + 0.011544011544012*G0_0_1_5_0 - 0.0951739618406322*G0_0_1_5_1 + 0.00649885094329564*G0_0_1_5_2 - 0.0259954037731825*G0_0_1_5_3 - 0.00290738068515855*G0_0_1_5_4 - 0.0519908075463651*G0_0_1_5_5;
    A[135] = A[26] - 0.266846240179583*G0_0_0_0_0 + 0.0145112500668061*G0_0_0_0_2 - 0.00412163967719534*G0_0_0_0_3 - 0.0609352787130586*G0_0_0_0_4 - 0.0423964512853418*G0_0_0_0_5 + 0.266846240179583*G0_0_0_1_1 - 0.0145112500668061*G0_0_0_1_2 + 0.0609352787130586*G0_0_0_1_3 + 0.00412163967719535*G0_0_0_1_4 + 0.0423964512853419*G0_0_0_1_5 + 0.0145112500668061*G0_0_0_2_0 - 0.0145112500668061*G0_0_0_2_1 - 0.00701191812302947*G0_0_0_2_3 + 0.00701191812302947*G0_0_0_2_4 - 0.00412163967719534*G0_0_0_3_0 + 0.0609352787130586*G0_0_0_3_1 - 0.00701191812302947*G0_0_0_3_2 + 0.00403612848057309*G0_0_0_3_3 + 0.00824327935439081*G0_0_0_3_5 - 0.0609352787130586*G0_0_0_4_0 + 0.00412163967719535*G0_0_0_4_1 + 0.00701191812302947*G0_0_0_4_2 - 0.00403612848057317*G0_0_0_4_4 - 0.00824327935439078*G0_0_0_4_5 - 0.0423964512853417*G0_0_0_5_0 + 0.0423964512853419*G0_0_0_5_1 + 0.00824327935439081*G0_0_0_5_3 - 0.00824327935439078*G0_0_0_5_4 - 0.281391694725038*G0_0_1_0_0 - 0.0106033883811665*G0_0_1_0_1 + 0.0175554486665604*G0_0_1_0_2 - 0.00615680615680634*G0_0_1_0_3 - 0.0694008871786673*G0_0_1_0_4 - 0.0535300090855666*G0_0_1_0_5 - 0.0106033883811665*G0_0_1_1_0 + 0.361891935225282*G0_0_1_1_1 - 0.0211597456041908*G0_0_1_1_2 + 0.0875292608625973*G0_0_1_1_3 + 0.00950884506440092*G0_0_1_1_4 + 0.0955844155844194*G0_0_1_1_5 + 0.0175554486665604*G0_0_1_2_0 - 0.0211597456041908*G0_0_1_2_1 - 0.00202661535994874*G0_0_1_2_2 - 0.00904708460264048*G0_0_1_2_3 + 0.00868793757682676*G0_0_1_2_4 - 0.000359147025813723*G0_0_1_2_5 - 0.00615680615680634*G0_0_1_3_0 + 0.0875292608625973*G0_0_1_3_1 - 0.00904708460264048*G0_0_1_3_2 + 0.00882475549142253*G0_0_1_3_3 - 0.00670407781518916*G0_0_1_3_4 + 0.0130319063652403*G0_0_1_3_5 - 0.0694008871786673*G0_0_1_4_0 + 0.00950884506440092*G0_0_1_4_1 + 0.00868793757682676*G0_0_1_4_2 - 0.00670407781518916*G0_0_1_4_3 - 0.0479546790657918*G0_0_1_4_4 - 0.0182993960771745*G0_0_1_4_5 - 0.0535300090855666*G0_0_1_5_0 + 0.0955844155844193*G0_0_1_5_1 - 0.000359147025813723*G0_0_1_5_2 + 0.0130319063652403*G0_0_1_5_3 - 0.0182993960771745*G0_0_1_5_4 + 0.0143658810325483*G0_0_1_5_5 + 0.0950456950456983*G0_1_0_0_0 - 0.0106033883811665*G0_1_0_0_1 - 0.00664849553738465*G0_1_0_0_2 + 0.00538720538720555*G0_1_0_0_3 + 0.0265939821495386*G0_1_0_0_4 + 0.0531879642990773*G0_1_0_0_5 - 0.0106033883811665*G0_1_0_1_0 - 0.014545454545455*G0_1_0_1_1 + 0.00304419859975426*G0_1_0_1_2 - 0.00846560846560873*G0_1_0_1_3 - 0.00203516647961099*G0_1_0_1_4 - 0.0111335578002249*G0_1_0_1_5 - 0.00664849553738465*G0_1_0_2_0 + 0.00304419859975426*G0_1_0_2_1 - 0.00202661535994876*G0_1_0_2_2 + 0.00167601945379728*G0_1_0_2_3 - 0.00203516647961099*G0_1_0_2_4 - 0.000359147025813703*G0_1_0_2_5 + 0.00538720538720555*G0_1_0_3_0 - 0.00846560846560873*G0_1_0_3_1 + 0.00167601945379728*G0_1_0_3_2 - 0.0439185505852188*G0_1_0_3_3 - 0.00670407781518916*G0_1_0_3_4 - 0.0100561167227838*G0_1_0_3_5 + 0.0265939821495386*G0_1_0_4_0 - 0.00203516647961099*G0_1_0_4_1 - 0.00203516647961099*G0_1_0_4_2 - 0.00670407781518916*G0_1_0_4_3 + 0.00478862701084936*G0_1_0_4_4 + 0.00478862701084938*G0_1_0_4_5 + 0.0531879642990773*G0_1_0_5_0 - 0.0111335578002249*G0_1_0_5_1 - 0.000359147025813703*G0_1_0_5_2 - 0.0100561167227838*G0_1_0_5_3 + 0.00478862701084938*G0_1_0_5_4 + 0.0143658810325482*G0_1_0_5_5 + 0.0950456950456983*G0_1_1_0_0 - 0.0106033883811665*G0_1_1_0_1 - 0.00664849553738465*G0_1_1_0_2 + 0.00538720538720555*G0_1_1_0_3 + 0.0265939821495386*G0_1_1_0_4 + 0.0531879642990773*G0_1_1_0_5 - 0.0106033883811665*G0_1_1_1_0 - 0.0145454545454549*G0_1_1_1_1 + 0.00304419859975425*G0_1_1_1_2 - 0.0084656084656087*G0_1_1_1_3 - 0.00203516647961098*G0_1_1_1_4 - 0.0111335578002248*G0_1_1_1_5 - 0.00664849553738465*G0_1_1_2_0 + 0.00304419859975425*G0_1_1_2_1 - 0.00202661535994876*G0_1_1_2_2 + 0.00167601945379727*G0_1_1_2_3 - 0.00203516647961099*G0_1_1_2_4 - 0.00035914702581371*G0_1_1_2_5 + 0.00538720538720555*G0_1_1_3_0 - 0.0084656084656087*G0_1_1_3_1 + 0.00167601945379727*G0_1_1_3_2 - 0.0439185505852187*G0_1_1_3_3 - 0.00670407781518916*G0_1_1_3_4 - 0.0100561167227837*G0_1_1_3_5 + 0.0265939821495386*G0_1_1_4_0 - 0.00203516647961098*G0_1_1_4_1 - 0.00203516647961099*G0_1_1_4_2 - 0.00670407781518916*G0_1_1_4_3 + 0.00478862701084934*G0_1_1_4_4 + 0.00478862701084938*G0_1_1_4_5 + 0.0531879642990773*G0_1_1_5_0 - 0.0111335578002248*G0_1_1_5_1 - 0.00035914702581371*G0_1_1_5_2 - 0.0100561167227837*G0_1_1_5_3 + 0.00478862701084938*G0_1_1_5_4 + 0.0143658810325483*G0_1_1_5_5;
    A[211] = -A[181] - 0.0200096200096206*G0_0_0_0_0 - 0.00395061728395076*G0_0_0_0_1 + 0.00995350328683694*G0_0_0_0_2 - 0.00123136123136128*G0_0_0_0_3 - 0.0136475869809208*G0_0_0_0_4 - 0.00554112554112574*G0_0_0_0_5 - 0.00395061728395076*G0_0_0_1_0 + 0.0672118005451365*G0_0_0_1_1 - 0.00625941959275316*G0_0_0_1_2 + 0.0425845759179107*G0_0_0_1_3 + 0.0104665704665708*G0_0_0_1_4 + 0.0169312169312176*G0_0_0_1_5 + 0.00995350328683694*G0_0_0_2_0 - 0.00625941959275316*G0_0_0_2_1 - 0.0189834856501529*G0_0_0_2_2 - 0.0187782587782594*G0_0_0_2_3 - 0.0156998556998562*G0_0_0_2_4 - 0.00441237774571125*G0_0_0_2_5 - 0.00123136123136128*G0_0_0_3_0 + 0.0425845759179107*G0_0_0_3_1 - 0.0187782587782594*G0_0_0_3_2 + 0.0184704184704192*G0_0_0_3_3 - 0.018470418470419*G0_0_0_3_4 + 0.0112874779541451*G0_0_0_3_5 - 0.0136475869809208*G0_0_0_4_0 + 0.0104665704665708*G0_0_0_4_1 - 0.0156998556998562*G0_0_0_4_2 - 0.018470418470419*G0_0_0_4_3 - 0.214667308000648*G0_0_0_4_4 - 0.0121083854417191*G0_0_0_4_5 - 0.00554112554112574*G0_0_0_5_0 + 0.0169312169312176*G0_0_0_5_1 - 0.00441237774571125*G0_0_0_5_2 + 0.0112874779541451*G0_0_0_5_3 - 0.0121083854417191*G0_0_0_5_4 + 0.0164181497514837*G0_0_0_5_5 - 0.00102613435946771*G0_1_0_0_0 + 0.00230880230880241*G0_1_0_0_1 + 0.00318101651434995*G0_1_0_0_3 + 0.00205226871893546*G0_1_0_0_4 + 0.0132371332371337*G0_1_0_0_5 + 0.00230880230880241*G0_1_0_1_0 - 0.00230880230880238*G0_1_0_1_2 + 0.0256533589866931*G0_1_0_1_3 - 0.0256533589866933*G0_1_0_1_5 - 0.00230880230880238*G0_1_0_2_1 + 0.00102613435946774*G0_1_0_2_2 - 0.0132371332371337*G0_1_0_2_3 - 0.00205226871893545*G0_1_0_2_4 - 0.00318101651434996*G0_1_0_2_5 + 0.00318101651434995*G0_1_0_3_0 + 0.0256533589866931*G0_1_0_3_1 - 0.0132371332371337*G0_1_0_3_2 + 0.00205226871893548*G0_1_0_3_3 - 0.0063620330286999*G0_1_0_3_4 + 0.00205226871893546*G0_1_0_4_0 - 0.00205226871893545*G0_1_0_4_2 - 0.0063620330286999*G0_1_0_4_3 + 0.00636203302869993*G0_1_0_4_5 + 0.0132371332371337*G0_1_0_5_0 - 0.0256533589866933*G0_1_0_5_1 - 0.00318101651434996*G0_1_0_5_2 + 0.00636203302869993*G0_1_0_5_4 - 0.00205226871893549*G0_1_0_5_5;
    A[157] = A[211] - 0.0321436588103268*G0_0_0_0_0 + 0.00102613435946772*G0_0_0_0_1 - 0.0034760301426969*G0_0_0_0_2 + 0.00387365720699068*G0_0_0_0_3 - 0.01295494628828*G0_0_0_0_4 + 0.0170081770081776*G0_0_0_0_5 + 0.00102613435946772*G0_0_0_1_0 - 0.0384543851210534*G0_0_0_1_1 + 0.00306557639890985*G0_0_0_1_2 - 0.0215231681898355*G0_0_0_1_3 - 0.00387365720699064*G0_0_0_1_4 - 0.0219336219336227*G0_0_0_1_5 - 0.0034760301426969*G0_0_0_2_0 + 0.00306557639890985*G0_0_0_2_1 + 0.0192913259579929*G0_0_0_2_2 + 0.0131345198011868*G0_0_0_2_3 + 0.022985409652077*G0_0_0_2_4 - 0.000820907487574189*G0_0_0_2_5 + 0.00387365720699068*G0_0_0_3_0 - 0.0215231681898355*G0_0_0_3_1 + 0.0131345198011868*G0_0_0_3_2 + 0.00441237774571123*G0_0_0_3_3 - 0.00610549943883297*G0_0_0_3_5 - 0.01295494628828*G0_0_0_4_0 - 0.00387365720699064*G0_0_0_4_1 + 0.022985409652077*G0_0_0_4_2 + 0.153201859868531*G0_0_0_4_4 + 0.00938912938912969*G0_0_0_4_5 + 0.0170081770081776*G0_0_0_5_0 - 0.0219336219336227*G0_0_0_5_1 - 0.000820907487574189*G0_0_0_5_2 - 0.00610549943883297*G0_0_0_5_3 + 0.00938912938912969*G0_0_0_5_4 + 0.0295526695526708*G0_0_0_5_5 + 0.10647426647427*G0_0_1_0_0 + 0.0063876863876866*G0_0_1_0_1 + 0.0063876863876866*G0_0_1_0_2 - 0.00153920153920162*G0_0_1_0_3 - 0.0391726791726804*G0_0_1_0_4 - 0.0391726791726805*G0_0_1_0_5 + 0.0063876863876866*G0_0_1_1_0 - 0.00596440596440637*G0_0_1_1_1 + 0.00277056277056287*G0_0_1_1_2 - 0.00631072631072649*G0_0_1_1_3 - 0.0037710437710439*G0_0_1_1_4 + 0.00985088985089024*G0_0_1_1_5 + 0.0063876863876866*G0_0_1_2_0 + 0.00277056277056287*G0_0_1_2_1 - 0.0059644059644064*G0_0_1_2_2 - 0.00631072631072662*G0_0_1_2_3 + 0.0098508898508901*G0_0_1_2_4 - 0.00377104377104393*G0_0_1_2_5 - 0.00153920153920162*G0_0_1_3_0 - 0.00631072631072649*G0_0_1_3_1 - 0.00631072631072662*G0_0_1_3_2 + 0.0284752284752295*G0_0_1_3_3 + 0.010620490620491*G0_0_1_3_4 + 0.0106204906204911*G0_0_1_3_5 - 0.0391726791726804*G0_0_1_4_0 - 0.0037710437710439*G0_0_1_4_1 + 0.0098508898508901*G0_0_1_4_2 + 0.010620490620491*G0_0_1_4_3 - 0.106050986050989*G0_0_1_4_4 + 0.0150841750841757*G0_0_1_4_5 - 0.0391726791726805*G0_0_1_5_0 + 0.00985088985089025*G0_0_1_5_1 - 0.00377104377104393*G0_0_1_5_2 + 0.0106204906204911*G0_0_1_5_3 + 0.0150841750841757*G0_0_1_5_4 - 0.10605098605099*G0_0_1_5_5 + 0.00968414301747665*G0_1_0_0_0 - 0.00351451018117699*G0_1_0_0_1 - 0.00123136123136125*G0_1_0_0_2 + 0.00071829405162741*G0_1_0_0_3 + 0.0108000641333979*G0_1_0_0_4 + 0.00936347603014299*G0_1_0_0_5 - 0.00351451018117699*G0_1_0_1_0 - 0.00681096681096702*G0_1_0_1_1 + 0.000910694244027591*G0_1_0_1_2 - 0.0145198011864682*G0_1_0_1_3 + 0.00772166105499469*G0_1_0_1_4 + 0.0111335578002249*G0_1_0_1_5 - 0.00123136123136125*G0_1_0_2_0 + 0.000910694244027591*G0_1_0_2_1 - 0.00573352573352596*G0_1_0_2_2 + 0.0115953182619853*G0_1_0_2_3 + 0.00184704184704183*G0_1_0_2_4 + 0.00643899310565998*G0_1_0_2_5 + 0.00071829405162741*G0_1_0_3_0 - 0.0145198011864682*G0_1_0_3_1 + 0.0115953182619853*G0_1_0_3_2 + 0.0243706910373587*G0_1_0_3_3 - 0.0168799102132442*G0_1_0_3_4 - 0.0143145743145748*G0_1_0_3_5 + 0.0108000641333979*G0_1_0_4_0 + 0.00772166105499469*G0_1_0_4_1 + 0.00184704184704183*G0_1_0_4_2 - 0.0168799102132442*G0_1_0_4_3 - 0.0728042328042361*G0_1_0_4_4 - 0.0283213083213094*G0_1_0_4_5 + 0.00936347603014299*G0_1_0_5_0 + 0.0111335578002249*G0_1_0_5_1 + 0.00643899310565998*G0_1_0_5_2 - 0.0143145743145748*G0_1_0_5_3 - 0.0283213083213094*G0_1_0_5_4 - 0.0582331248997934*G0_1_0_5_5 - 0.0299374699374706*G0_1_1_0_0 + 0.00173160173160175*G0_1_1_0_1 - 0.00169312169312175*G0_1_1_0_2 + 0.00330928330928342*G0_1_1_0_3 + 0.0150072150072156*G0_1_1_0_4 - 0.00407888407888415*G0_1_1_0_5 + 0.00173160173160175*G0_1_1_1_0 - 0.00400192400192436*G0_1_1_1_1 + 0.00227032227032235*G0_1_1_1_2 - 0.0036940836940838*G0_1_1_1_3 - 0.0033862433862435*G0_1_1_1_4 - 0.00307840307840316*G0_1_1_1_5 - 0.00169312169312174*G0_1_1_2_0 + 0.00227032227032235*G0_1_1_2_1 - 0.00484848484848501*G0_1_1_2_2 - 0.00207792207792219*G0_1_1_2_3 - 0.0116209716209721*G0_1_1_2_4 - 0.000230880230880305*G0_1_1_2_5 + 0.00330928330928342*G0_1_1_3_0 - 0.0036940836940838*G0_1_1_3_1 - 0.00207792207792219*G0_1_1_3_2 + 0.0169312169312176*G0_1_1_3_3 + 0.000153920153920154*G0_1_1_3_4 - 0.00615680615680623*G0_1_1_3_5 + 0.0150072150072156*G0_1_1_4_0 - 0.0033862433862435*G0_1_1_4_1 - 0.0116209716209721*G0_1_1_4_2 + 0.000153920153920152*G0_1_1_4_3 + 0.0332467532467542*G0_1_1_4_4 + 0.00723424723424759*G0_1_1_4_5 - 0.00407888407888415*G0_1_1_5_0 - 0.00307840307840316*G0_1_1_5_1 - 0.000230880230880305*G0_1_1_5_2 - 0.00615680615680623*G0_1_1_5_3 + 0.0072342472342476*G0_1_1_5_4 + 0.0520250120250145*G0_1_1_5_5;
    A[16] = 0.00441718775052124*G0_0_0_0_0 - 0.0091697397252956*G0_0_0_0_1 - 0.000244508577841918*G0_0_0_0_2 - 0.00298754743199198*G0_0_0_0_3 + 0.000940623162845418*G0_0_0_0_4 - 0.00389075944631515*G0_0_0_0_5 - 0.0091697397252956*G0_0_0_1_0 + 0.168726952060292*G0_0_0_1_1 - 0.00916973972529561*G0_0_0_1_2 + 0.0375821709155056*G0_0_0_1_3 + 0.000903212014323143*G0_0_0_1_4 + 0.0375821709155057*G0_0_0_1_5 - 0.000244508577841918*G0_0_0_2_0 - 0.0091697397252956*G0_0_0_2_1 + 0.00441718775052123*G0_0_0_2_2 - 0.00389075944631514*G0_0_0_2_3 + 0.000940623162845417*G0_0_0_2_4 - 0.00298754743199199*G0_0_0_2_5 - 0.00298754743199198*G0_0_0_3_0 + 0.0375821709155056*G0_0_0_3_1 - 0.00389075944631514*G0_0_0_3_2 + 0.0239003794559358*G0_0_0_3_3 + 0.00416867083533764*G0_0_0_3_4 + 0.011950189727968*G0_0_0_3_5 + 0.000940623162845419*G0_0_0_4_0 + 0.000903212014323143*G0_0_0_4_1 + 0.000940623162845417*G0_0_0_4_2 + 0.00416867083533764*G0_0_0_4_3 + 0.0158623269734386*G0_0_0_4_4 + 0.00416867083533764*G0_0_0_4_5 - 0.00389075944631515*G0_0_0_5_0 + 0.0375821709155057*G0_0_0_5_1 - 0.00298754743199199*G0_0_0_5_2 + 0.011950189727968*G0_0_0_5_3 + 0.00416867083533764*G0_0_0_5_4 + 0.0239003794559359*G0_0_0_5_5;
    A[70] = A[157] + 0.0250889850889861*G0_0_0_0_0 + 0.000538720538720519*G0_0_0_0_2 - 0.00354016354016363*G0_0_0_0_3 + 0.00200096200096207*G0_0_0_0_4 - 0.0266281866281874*G0_0_0_0_5 - 0.0250889850889856*G0_0_0_1_1 - 0.000538720538720559*G0_0_0_1_2 - 0.00200096200096217*G0_0_0_1_3 + 0.00354016354016363*G0_0_0_1_4 + 0.0266281866281874*G0_0_0_1_5 + 0.000538720538720519*G0_0_0_2_0 - 0.000538720538720559*G0_0_0_2_1 + 0.000615680615680771*G0_0_0_2_3 - 0.000615680615680526*G0_0_0_2_4 - 0.00354016354016363*G0_0_0_3_0 - 0.00200096200096217*G0_0_0_3_1 + 0.000615680615680771*G0_0_0_3_2 + 0.0350937950937959*G0_0_0_3_3 + 0.00708032708032724*G0_0_0_3_5 + 0.00200096200096207*G0_0_0_4_0 + 0.00354016354016363*G0_0_0_4_1 - 0.000615680615680526*G0_0_0_4_2 - 0.035093795093796*G0_0_0_4_4 - 0.0070803270803273*G0_0_0_4_5 - 0.0266281866281874*G0_0_0_5_0 + 0.0266281866281874*G0_0_0_5_1 + 0.00708032708032725*G0_0_0_5_3 - 0.0070803270803273*G0_0_0_5_4 - 0.104511784511788*G0_0_1_0_0 - 0.00731120731120754*G0_0_1_0_1 - 0.00546416546416564*G0_0_1_0_2 - 0.00323232323232328*G0_0_1_0_3 + 0.0387878787878801*G0_0_1_0_4 + 0.0292448292448303*G0_0_1_0_5 - 0.00731120731120754*G0_0_1_1_0 - 0.0315536315536323*G0_0_1_1_1 - 0.000269360269360275*G0_0_1_1_2 - 0.00708032708032742*G0_0_1_1_3 + 0.00507936507936525*G0_0_1_1_4 - 0.00415584415584445*G0_0_1_1_5 - 0.00546416546416564*G0_0_1_2_0 - 0.000269360269360276*G0_0_1_2_1 + 0.00877344877344925*G0_0_1_2_2 + 0.00492544492544522*G0_0_1_2_3 - 0.0118518518518522*G0_0_1_2_4 - 0.00415584415584425*G0_0_1_2_5 - 0.00323232323232328*G0_0_1_3_0 - 0.00708032708032742*G0_0_1_3_1 + 0.00492544492544522*G0_0_1_3_2 + 0.0840404040404066*G0_0_1_3_3 - 0.00369408369408387*G0_0_1_3_4 + 0.0147763347763351*G0_0_1_3_5 + 0.03878787878788*G0_0_1_4_0 + 0.00507936507936525*G0_0_1_4_1 - 0.0118518518518522*G0_0_1_4_2 - 0.00369408369408387*G0_0_1_4_3 + 0.0988167388167417*G0_0_1_4_4 - 0.00184704184704202*G0_0_1_4_5 + 0.0292448292448303*G0_0_1_5_0 - 0.00415584415584445*G0_0_1_5_1 - 0.00415584415584425*G0_0_1_5_2 + 0.0147763347763351*G0_0_1_5_3 - 0.00184704184704201*G0_0_1_5_4 + 0.199788359788366*G0_0_1_5_5 - 0.0064646464646468*G0_1_0_0_0 - 0.00731120731120756*G0_1_0_0_1 + 0.000269360269360255*G0_1_0_0_2 + 0.0015392015392016*G0_1_0_0_3 - 0.00507936507936525*G0_1_0_0_4 - 0.0307840307840318*G0_1_0_0_5 - 0.00731120731120757*G0_1_0_1_0 - 0.129600769600774*G0_1_0_1_1 - 0.00600288600288619*G0_1_0_1_2 + 0.036786916786918*G0_1_0_1_3 + 0.000307840307840299*G0_1_0_1_4 + 0.0558730158730177*G0_1_0_1_5 + 0.000269360269360255*G0_1_0_2_0 - 0.00600288600288619*G0_1_0_2_1 + 0.00877344877344912*G0_1_0_2_2 - 0.0112361712361716*G0_1_0_2_3 + 0.00430976430976452*G0_1_0_2_4 - 0.00415584415584431*G0_1_0_2_5 + 0.0015392015392016*G0_1_0_3_0 + 0.036786916786918*G0_1_0_3_1 - 0.0112361712361716*G0_1_0_3_2 + 0.133910533910538*G0_1_0_3_3 - 0.00369408369408374*G0_1_0_3_4 + 0.00523328523328548*G0_1_0_3_5 - 0.00507936507936525*G0_1_0_4_0 + 0.0003078403078403*G0_1_0_4_1 + 0.00430976430976452*G0_1_0_4_2 - 0.00369408369408374*G0_1_0_4_3 + 0.0489466089466115*G0_1_0_4_4 + 0.00769600769600803*G0_1_0_4_5 - 0.0307840307840318*G0_1_0_5_0 + 0.0558730158730177*G0_1_0_5_1 - 0.00415584415584431*G0_1_0_5_2 + 0.00523328523328547*G0_1_0_5_3 + 0.00769600769600802*G0_1_0_5_4 + 0.199788359788367*G0_1_0_5_5 + 0.0338624338624347*G0_1_1_0_0 - 0.0073112073112075*G0_1_1_0_1 + 0.00211640211640219*G0_1_1_0_2 - 0.00769600769600793*G0_1_1_0_3 - 0.0127753727753733*G0_1_1_0_4 - 0.0187782587782595*G0_1_1_0_5 - 0.0073112073112075*G0_1_1_1_0 - 0.169927849927856*G0_1_1_1_1 - 0.0078499278499281*G0_1_1_1_2 + 0.0444829244829259*G0_1_1_1_3 + 0.00954304954304989*G0_1_1_1_4 + 0.0438672438672452*G0_1_1_1_5 + 0.00211640211640219*G0_1_1_2_0 - 0.0078499278499281*G0_1_1_2_1 + 0.00877344877344908*G0_1_1_2_2 - 0.0207792207792215*G0_1_1_2_3 + 0.0138528138528144*G0_1_1_2_4 - 0.00415584415584426*G0_1_1_2_5 - 0.00769600769600793*G0_1_1_3_0 + 0.0444829244829259*G0_1_1_3_1 - 0.0207792207792215*G0_1_1_3_2 + 0.234882154882163*G0_1_1_3_3 - 0.00369408369408381*G0_1_1_3_4 + 0.0237037037037045*G0_1_1_3_5 - 0.0127753727753733*G0_1_1_4_0 + 0.00954304954304989*G0_1_1_4_1 + 0.0138528138528144*G0_1_1_4_2 - 0.00369408369408381*G0_1_1_4_3 - 0.0520250120250138*G0_1_1_4_4 - 0.0107744107744113*G0_1_1_4_5 - 0.0187782587782595*G0_1_1_5_0 + 0.0438672438672452*G0_1_1_5_1 - 0.00415584415584426*G0_1_1_5_2 + 0.0237037037037045*G0_1_1_5_3 - 0.0107744107744113*G0_1_1_5_4 + 0.199788359788366*G0_1_1_5_5;
    A[36] = -0.000590027256693936*G0_1_0_0_0 + 2.99289188178132e-05*G0_1_0_0_1 + 0.00352306130083916*G0_1_0_0_2 + 0.000359147025813706*G0_1_0_0_3 - 0.00875634653412457*G0_1_0_0_4 - 0.000632782855005087*G0_1_0_0_5 + 2.99289188178132e-05*G0_1_0_1_0 - 0.00161616161616169*G0_1_0_1_1 + 0.00583186360964157*G0_1_0_1_2 + 0.00448078670300906*G0_1_0_1_3 + 0.00354016354016365*G0_1_0_1_4 + 0.00141948586393034*G0_1_0_1_5 + 0.00352306130083916*G0_1_0_2_0 + 0.00583186360964157*G0_1_0_2_1 - 0.0896584896584922*G0_1_0_2_2 - 0.0274490941157617*G0_1_0_2_3 - 0.00179573512906847*G0_1_0_2_4 + 0.000906418684196477*G0_1_0_2_5 + 0.000359147025813706*G0_1_0_3_0 + 0.00448078670300906*G0_1_0_3_1 - 0.0274490941157617*G0_1_0_3_2 - 0.0178547378547385*G0_1_0_3_3 - 0.00779862113195471*G0_1_0_3_4 - 0.00253113142002041*G0_1_0_3_5 - 0.00875634653412457*G0_1_0_4_0 + 0.00354016354016365*G0_1_0_4_1 - 0.00179573512906847*G0_1_0_4_2 - 0.00779862113195471*G0_1_0_4_3 - 0.0158024691358028*G0_1_0_4_4 - 0.00889316444872028*G0_1_0_4_5 - 0.000632782855005087*G0_1_0_5_0 + 0.00141948586393034*G0_1_0_5_1 + 0.000906418684196477*G0_1_0_5_2 - 0.00253113142002041*G0_1_0_5_3 - 0.00889316444872028*G0_1_0_5_4 - 0.00212067767623336*G0_1_0_5_5 - 0.0356068622735302*G0_1_1_0_0 + 0.00304847415958538*G0_1_1_0_1 + 0.00296723852279417*G0_1_1_0_2 + 0.00020522687189355*G0_1_1_0_3 - 0.00791833680722595*G0_1_1_0_4 - 0.0153236064347181*G0_1_1_0_5 + 0.00304847415958538*G0_1_1_1_0 - 0.00251402918069595*G0_1_1_1_1 + 0.00538292982737445*G0_1_1_1_2 + 0.004514991181658*G0_1_1_1_3 + 0.00285607396718517*G0_1_1_1_4 + 0.00420715087381768*G0_1_1_1_5 + 0.00296723852279417*G0_1_1_2_0 + 0.00538292982737445*G0_1_1_2_1 - 0.0833734167067527*G0_1_1_2_2 - 0.0258414836192623*G0_1_1_2_3 - 0.00109454331676558*G0_1_1_2_4 + 0.0010774410774411*G0_1_1_2_5 + 0.00020522687189355*G0_1_1_3_0 + 0.004514991181658*G0_1_1_3_1 - 0.0258414836192623*G0_1_1_3_2 - 0.0170338303671643*G0_1_1_3_3 - 0.00612260167815744*G0_1_1_3_4 - 0.00256533589866933*G0_1_1_3_5 - 0.00791833680722595*G0_1_1_4_0 + 0.00285607396718517*G0_1_1_4_1 - 0.00109454331676558*G0_1_1_4_2 - 0.00612260167815744*G0_1_1_4_3 - 0.00355726577948803*G0_1_1_4_4 - 0.00786703008925257*G0_1_1_4_5 - 0.0153236064347181*G0_1_1_5_0 + 0.00420715087381768*G0_1_1_5_1 + 0.0010774410774411*G0_1_1_5_2 - 0.00256533589866933*G0_1_1_5_3 - 0.00786703008925256*G0_1_1_5_4 - 0.0184704184704192*G0_1_1_5_5;
    A[122] = -0.00233445566778907*G0_0_1_0_0 - 0.00167174389396617*G0_0_1_0_1 + 0.0225322003099788*G0_0_1_0_2 + 0.00649885094329559*G0_0_1_0_3 + 0.0115440115440119*G0_0_1_0_4 + 0.000820907487574185*G0_0_1_0_5 - 0.00167174389396617*G0_0_1_1_0 - 0.00233445566778909*G0_0_1_1_1 + 0.0225322003099788*G0_0_1_1_2 + 0.0115440115440119*G0_0_1_1_3 + 0.0064988509432956*G0_0_1_1_4 + 0.000820907487574178*G0_0_1_1_5 + 0.0225322003099788*G0_0_1_2_0 + 0.0225322003099788*G0_0_1_2_1 - 0.378771845438524*G0_0_1_2_2 - 0.0951739618406317*G0_0_1_2_3 - 0.0951739618406316*G0_0_1_2_4 - 0.00504516060071639*G0_0_1_2_5 + 0.00649885094329559*G0_0_1_3_0 + 0.0115440115440119*G0_0_1_3_1 - 0.0951739618406317*G0_0_1_3_2 - 0.0519908075463649*G0_0_1_3_3 - 0.0259954037731824*G0_0_1_3_4 - 0.00290738068515858*G0_0_1_3_5 + 0.0115440115440119*G0_0_1_4_0 + 0.0064988509432956*G0_0_1_4_1 - 0.0951739618406317*G0_0_1_4_2 - 0.0259954037731824*G0_0_1_4_3 - 0.0519908075463648*G0_0_1_4_4 - 0.00290738068515858*G0_0_1_4_5 + 0.000820907487574186*G0_0_1_5_0 + 0.000820907487574178*G0_0_1_5_1 - 0.00504516060071639*G0_0_1_5_2 - 0.00290738068515858*G0_0_1_5_3 - 0.00290738068515858*G0_0_1_5_4 + 0.000752498530276286*G0_0_1_5_5 - 0.0168799102132441*G0_1_1_0_0 + 0.0013724547057881*G0_1_1_0_1 + 0.0119288119288123*G0_1_1_0_2 + 0.00446368446368461*G0_1_1_0_3 + 0.000410453743787088*G0_1_1_0_4 - 0.00764470097803459*G0_1_1_0_5 + 0.0013724547057881*G0_1_1_1_0 - 0.00436107102773789*G0_1_1_1_1 + 0.0158837047725942*G0_1_1_1_2 + 0.00950884506440093*G0_1_1_1_3 + 0.00613970391748189*G0_1_1_1_4 + 0.00249692694137145*G0_1_1_1_5 + 0.0119288119288123*G0_1_1_2_0 + 0.0158837047725942*G0_1_1_2_1 - 0.283726150392826*G0_1_1_2_2 - 0.0685799796910931*G0_1_1_2_3 - 0.0419859975415545*G0_1_1_2_4 + 0.000342044786489195*G0_1_1_2_5 + 0.0044636844636846*G0_1_1_3_0 + 0.00950884506440093*G0_1_1_3_1 - 0.0685799796910931*G0_1_1_3_2 - 0.0472021805355155*G0_1_1_3_3 - 0.021206776762333*G0_1_1_3_4 - 0.00961145850034772*G0_1_1_3_5 + 0.000410453743787088*G0_1_1_4_0 + 0.00613970391748189*G0_1_1_4_1 - 0.0419859975415545*G0_1_1_4_2 - 0.021206776762333*G0_1_1_4_3 - 0.0376249265138167*G0_1_1_4_4 - 0.0129634974079423*G0_1_1_4_5 - 0.0076447009780346*G0_1_1_5_0 + 0.00249692694137145*G0_1_1_5_1 + 0.000342044786489195*G0_1_1_5_2 - 0.00961145850034772*G0_1_1_5_3 - 0.0129634974079423*G0_1_1_5_4 - 0.0431660520549425*G0_1_1_5_5;
    A[138] = 0.0160076960076967*G0_0_0_0_0 - 0.00129977018865913*G0_0_0_0_1 - 0.00177863288974407*G0_0_0_0_2 + 0.0116295227406343*G0_0_0_0_4 - 0.00424135535246655*G0_0_0_0_5 - 0.00129977018865913*G0_0_0_1_0 - 0.0669039602372957*G0_0_0_1_1 + 0.0113558869114429*G0_0_0_1_2 - 0.0638939661161906*G0_0_0_1_3 - 0.000820907487574186*G0_0_0_1_4 + 0.00191545080433968*G0_0_0_1_5 - 0.00177863288974407*G0_0_0_2_0 + 0.0113558869114429*G0_0_0_2_1 + 0.00287317620650972*G0_0_0_2_2 + 0.0184704184704191*G0_0_0_2_3 - 0.00533589866923216*G0_0_0_2_4 - 0.00752498530276332*G0_0_0_2_5 - 0.0638939661161906*G0_0_0_3_1 + 0.0184704184704191*G0_0_0_3_2 - 0.142837902837908*G0_0_0_3_3 + 0.00164181497514834*G0_0_0_3_4 + 0.0150499706055266*G0_0_0_3_5 + 0.0116295227406343*G0_0_0_4_0 - 0.000820907487574186*G0_0_0_4_1 - 0.00533589866923216*G0_0_0_4_2 + 0.00164181497514834*G0_0_0_4_3 + 0.0213435946769287*G0_0_0_4_4 + 0.016691785580675*G0_0_0_4_5 - 0.00424135535246655*G0_0_0_5_0 + 0.00191545080433968*G0_0_0_5_1 - 0.00752498530276332*G0_0_0_5_2 + 0.0150499706055266*G0_0_0_5_3 + 0.016691785580675*G0_0_0_5_4 + 0.0503489925712165*G0_0_0_5_5 + 0.0100561167227839*G0_0_1_0_0 - 0.000615680615680659*G0_0_1_0_1 - 0.000410453743787103*G0_0_1_0_2 + 0.0020522687189355*G0_0_1_0_4 - 0.00656725990059339*G0_0_1_0_5 - 0.000615680615680659*G0_0_1_1_0 - 0.177521244187917*G0_0_1_1_1 + 0.0138186093741654*G0_0_1_1_2 - 0.0674512318956786*G0_0_1_1_3 + 0.0001368179145957*G0_0_1_1_4 + 0.00588317032761487*G0_0_1_1_5 - 0.000410453743787103*G0_0_1_2_0 + 0.0138186093741654*G0_0_1_2_1 - 0.0018470418470419*G0_0_1_2_2 + 0.012176794399017*G0_0_1_2_3 - 0.000273635829191405*G0_0_1_2_4 - 0.00314681203570103*G0_0_1_2_5 - 0.0674512318956786*G0_0_1_3_1 + 0.012176794399017*G0_0_1_3_2 - 0.0681353214686571*G0_0_1_3_3 - 0.000273635829191388*G0_0_1_3_4 + 0.00629362407140201*G0_0_1_3_5 + 0.0020522687189355*G0_0_1_4_0 + 0.0001368179145957*G0_0_1_4_1 - 0.000273635829191404*G0_0_1_4_2 - 0.000273635829191388*G0_0_1_4_3 + 0.00136817914595702*G0_0_1_4_4 + 0.00601998824221069*G0_0_1_4_5 - 0.00656725990059339*G0_0_1_5_0 + 0.00588317032761487*G0_0_1_5_1 - 0.00314681203570103*G0_0_1_5_2 + 0.006293624071402*G0_0_1_5_3 + 0.00601998824221069*G0_0_1_5_4 + 0.0637571482015949*G0_0_1_5_5 + 0.000615680615680601*G0_1_0_0_0 + 0.000410453743787079*G0_1_0_0_2 + 0.00164181497514837*G0_1_0_0_3 - 0.00123136123136126*G0_1_0_0_4 - 0.0036940836940838*G0_1_0_0_5 - 0.0728555395222084*G0_1_0_1_1 + 0.0125188391855063*G0_1_0_1_2 - 0.0714189514189539*G0_1_0_1_3 - 0.00123136123136128*G0_1_0_1_4 - 0.00246272246272262*G0_1_0_1_5 + 0.000410453743787079*G0_1_0_2_0 + 0.0125188391855063*G0_1_0_2_1 - 0.00102613435946765*G0_1_0_2_2 + 0.0229854096520772*G0_1_0_2_3 - 0.00164181497514834*G0_1_0_2_4 - 0.00615680615680635*G0_1_0_2_5 + 0.00164181497514837*G0_1_0_3_0 - 0.0714189514189539*G0_1_0_3_1 + 0.0229854096520772*G0_1_0_3_2 - 0.160076960076966*G0_1_0_3_3 - 0.000820907487574203*G0_1_0_3_4 + 0.00902998236331589*G0_1_0_3_5 - 0.00123136123136126*G0_1_0_4_0 - 0.00123136123136128*G0_1_0_4_1 - 0.00164181497514834*G0_1_0_4_2 - 0.000820907487574203*G0_1_0_4_3 - 0.000820907487574126*G0_1_0_4_4 + 0.0147763347763353*G0_1_0_4_5 - 0.00369408369408379*G0_1_0_5_0 - 0.00246272246272262*G0_1_0_5_1 - 0.00615680615680635*G0_1_0_5_2 + 0.00902998236331589*G0_1_0_5_3 + 0.0147763347763353*G0_1_0_5_4 + 0.0517171717171735*G0_1_0_5_5 - 0.00533589866923226*G0_1_1_0_0 + 0.00280476724921178*G0_1_1_0_1 + 0.000889316444872032*G0_1_1_0_2 + 0.000410453743787093*G0_1_1_0_3 - 0.00437817326706231*G0_1_1_0_4 - 0.0124504302282084*G0_1_1_0_5 + 0.00280476724921178*G0_1_1_1_0 - 0.192913259579933*G0_1_1_1_1 + 0.0151183795628245*G0_1_1_1_2 - 0.0738816738816764*G0_1_1_1_3 + 0.000547271658382798*G0_1_1_1_4 + 0.000889316444872032*G0_1_1_2_0 + 0.0151183795628245*G0_1_1_2_1 - 0.00287317620650963*G0_1_1_2_2 + 0.0138186093741654*G0_1_1_2_3 + 0.00136817914595697*G0_1_1_2_4 - 0.00123136123136126*G0_1_1_2_5 + 0.000410453743787093*G0_1_1_3_0 - 0.0738816738816764*G0_1_1_3_1 + 0.0138186093741654*G0_1_1_3_2 - 0.0755234888568248*G0_1_1_3_3 - 0.00191545080433975*G0_1_1_3_4 + 0.0016418149751483*G0_1_1_3_5 - 0.00437817326706231*G0_1_1_4_0 + 0.000547271658382798*G0_1_1_4_1 + 0.00136817914595697*G0_1_1_4_2 - 0.00191545080433976*G0_1_1_4_3 - 0.00601998824221066*G0_1_1_4_4 + 0.00136817914595697*G0_1_1_4_5 - 0.0124504302282084*G0_1_1_5_0 - 0.00123136123136126*G0_1_1_5_2 + 0.0016418149751483*G0_1_1_5_3 + 0.00136817914595697*G0_1_1_5_4 + 0.0558217091550444*G0_1_1_5_5;
    A[212] = 0.00302709636042985*G0_0_1_0_0 - 0.00756774090107447*G0_0_1_0_2 - 0.00128266794933464*G0_0_1_0_3 - 0.00743947410614099*G0_0_1_0_4 + 0.00056437389770729*G0_0_1_0_5 - 0.00302709636042984*G0_0_1_1_1 + 0.00756774090107454*G0_0_1_1_2 + 0.00743947410614106*G0_0_1_1_3 + 0.00128266794933468*G0_0_1_1_4 - 0.000564373897707267*G0_0_1_1_5 - 0.00756774090107447*G0_0_1_2_0 + 0.00756774090107455*G0_0_1_2_1 - 0.0389931056597739*G0_0_1_2_3 + 0.0389931056597735*G0_0_1_2_4 - 0.00128266794933464*G0_0_1_3_0 + 0.00743947410614106*G0_0_1_3_1 - 0.0389931056597739*G0_0_1_3_2 - 0.00923520923520986*G0_0_1_3_3 + 0.00256533589866929*G0_0_1_3_5 - 0.00743947410614099*G0_0_1_4_0 + 0.00128266794933468*G0_0_1_4_1 + 0.0389931056597735*G0_0_1_4_2 + 0.00923520923520937*G0_0_1_4_4 - 0.00256533589866933*G0_0_1_4_5 + 0.00056437389770729*G0_0_1_5_0 - 0.000564373897707267*G0_0_1_5_1 + 0.00256533589866929*G0_0_1_5_3 - 0.00256533589866933*G0_0_1_5_4 + 0.00979958313291686*G0_1_1_0_0 - 0.00541285874619228*G0_1_1_0_1 + 0.00759339426006117*G0_1_1_0_2 + 0.0011800545133879*G0_1_1_0_3 + 0.00620811287477976*G0_1_1_0_4 + 0.0051819785153121*G0_1_1_0_5 - 0.00541285874619228*G0_1_1_1_0 + 0.00677248677248705*G0_1_1_1_1 + 0.0151611351611357*G0_1_1_1_2 + 0.0136475869809208*G0_1_1_1_3 + 0.00246272246272257*G0_1_1_1_4 + 0.00461760461760483*G0_1_1_1_5 + 0.00759339426006117*G0_1_1_2_0 + 0.0151611351611357*G0_1_1_2_1 - 0.122366522366527*G0_1_1_2_2 - 0.0731120731120757*G0_1_1_2_3 - 0.0341189674523019*G0_1_1_2_4 - 0.0118518518518523*G0_1_1_2_5 + 0.0011800545133879*G0_1_1_3_0 + 0.0136475869809208*G0_1_1_3_1 - 0.0731120731120757*G0_1_1_3_2 - 0.0178547378547388*G0_1_1_3_3 - 0.00728555395222096*G0_1_1_3_4 + 0.0213435946769286*G0_1_1_3_5 + 0.00620811287477976*G0_1_1_4_0 + 0.00246272246272257*G0_1_1_4_1 - 0.0341189674523019*G0_1_1_4_2 - 0.00728555395222096*G0_1_1_4_3 - 0.00861952861952901*G0_1_1_4_4 + 0.0187782587782593*G0_1_1_4_5 + 0.0051819785153121*G0_1_1_5_0 + 0.00461760461760483*G0_1_1_5_1 - 0.0118518518518523*G0_1_1_5_2 + 0.0213435946769286*G0_1_1_5_3 + 0.0187782587782593*G0_1_1_5_4 + 0.118826358826363*G0_1_1_5_5;
    A[1] = 0.0161696328363001*G0_0_0_0_0 - 0.000518678852012203*G0_0_0_0_1 - 0.00119742397520179*G0_0_0_0_2 - 3.95489284378203e-05*G0_0_0_0_3 + 0.00540430762653003*G0_0_0_0_4 + 0.000816631927743074*G0_0_0_0_5 - 0.000518678852012203*G0_0_0_1_0 + 0.0161696328363001*G0_0_0_1_1 - 0.00119742397520179*G0_0_0_1_2 + 0.00540430762653003*G0_0_0_1_3 - 3.95489284378203e-05*G0_0_0_1_4 + 0.000816631927743076*G0_0_0_1_5 - 0.00119742397520179*G0_0_0_2_0 - 0.00119742397520179*G0_0_0_2_1 - 1.76366843033532e-05*G0_0_0_2_2 - 0.000654160654160679*G0_0_0_2_3 - 0.000654160654160678*G0_0_0_2_4 - 0.00044145155256268*G0_0_0_2_5 - 3.95489284378202e-05*G0_0_0_3_0 + 0.00540430762653003*G0_0_0_3_1 - 0.000654160654160678*G0_0_0_3_2 + 0.0034461012238791*G0_0_0_3_3 + 0.000158195713751273*G0_0_0_3_4 + 0.000962000962000998*G0_0_0_3_5 + 0.00540430762653003*G0_0_0_4_0 - 3.95489284378204e-05*G0_0_0_4_1 - 0.000654160654160678*G0_0_0_4_2 + 0.000158195713751273*G0_0_0_4_3 + 0.0034461012238791*G0_0_0_4_4 + 0.000962000962000997*G0_0_0_4_5 + 0.000816631927743074*G0_0_0_5_0 + 0.000816631927743076*G0_0_0_5_1 - 0.00044145155256268*G0_0_0_5_2 + 0.000962000962000998*G0_0_0_5_3 + 0.000962000962000997*G0_0_0_5_4 - 0.00216343327454445*G0_0_0_5_5 + 0.0161696328363001*G0_1_0_0_0 - 0.000518678852012202*G0_1_0_0_1 - 0.00119742397520179*G0_1_0_0_2 - 3.95489284378196e-05*G0_1_0_0_3 + 0.00540430762653003*G0_1_0_0_4 + 0.000816631927743073*G0_1_0_0_5 - 0.000518678852012202*G0_1_0_1_0 + 0.0161696328363*G0_1_0_1_1 - 0.00119742397520179*G0_1_0_1_2 + 0.00540430762653002*G0_1_0_1_3 - 3.95489284378206e-05*G0_1_0_1_4 + 0.000816631927743075*G0_1_0_1_5 - 0.00119742397520179*G0_1_0_2_0 - 0.00119742397520179*G0_1_0_2_1 - 1.76366843033628e-05*G0_1_0_2_2 - 0.000654160654160677*G0_1_0_2_3 - 0.000654160654160679*G0_1_0_2_4 - 0.00044145155256268*G0_1_0_2_5 - 3.95489284378196e-05*G0_1_0_3_0 + 0.00540430762653002*G0_1_0_3_1 - 0.000654160654160677*G0_1_0_3_2 + 0.00344610122387909*G0_1_0_3_3 + 0.000158195713751272*G0_1_0_3_4 + 0.000962000962000996*G0_1_0_3_5 + 0.00540430762653003*G0_1_0_4_0 - 3.95489284378206e-05*G0_1_0_4_1 - 0.000654160654160678*G0_1_0_4_2 + 0.000158195713751273*G0_1_0_4_3 + 0.0034461012238791*G0_1_0_4_4 + 0.000962000962000997*G0_1_0_4_5 + 0.000816631927743073*G0_1_0_5_0 + 0.000816631927743075*G0_1_0_5_1 - 0.00044145155256268*G0_1_0_5_2 + 0.000962000962000996*G0_1_0_5_3 + 0.000962000962000997*G0_1_0_5_4 - 0.00216343327454445*G0_1_0_5_5;
    A[46] = -0.00202661535994877*G0_0_0_0_0 - 0.00664849553738463*G0_0_0_0_1 + 0.00304419859975425*G0_0_0_0_2 - 0.00035914702581371*G0_0_0_0_3 + 0.00167601945379728*G0_0_0_0_4 - 0.00203516647961099*G0_0_0_0_5 - 0.00664849553738463*G0_0_0_1_0 + 0.095045695045698*G0_0_0_1_1 - 0.0106033883811665*G0_0_0_1_2 + 0.0531879642990772*G0_0_0_1_3 + 0.00538720538720556*G0_0_0_1_4 + 0.0265939821495386*G0_0_0_1_5 + 0.00304419859975425*G0_0_0_2_0 - 0.0106033883811665*G0_0_0_2_1 - 0.014545454545455*G0_0_0_2_2 - 0.0111335578002248*G0_0_0_2_3 - 0.00846560846560874*G0_0_0_2_4 - 0.00203516647961101*G0_0_0_2_5 - 0.00035914702581371*G0_0_0_3_0 + 0.0531879642990772*G0_0_0_3_1 - 0.0111335578002248*G0_0_0_3_2 + 0.0143658810325482*G0_0_0_3_3 - 0.0100561167227837*G0_0_0_3_4 + 0.00478862701084944*G0_0_0_3_5 + 0.00167601945379728*G0_0_0_4_0 + 0.00538720538720556*G0_0_0_4_1 - 0.00846560846560874*G0_0_0_4_2 - 0.0100561167227837*G0_0_0_4_3 - 0.0439185505852186*G0_0_0_4_4 - 0.00670407781518916*G0_0_0_4_5 - 0.00203516647961099*G0_0_0_5_0 + 0.0265939821495386*G0_0_0_5_1 - 0.002035166479611*G0_0_0_5_2 + 0.00478862701084944*G0_0_0_5_3 - 0.00670407781518916*G0_0_0_5_4 + 0.00478862701084939*G0_0_0_5_5 + 0.00233445566778907*G0_1_0_0_0 - 0.0225322003099789*G0_1_0_0_1 + 0.00167174389396617*G0_1_0_0_2 - 0.00649885094329561*G0_1_0_0_3 - 0.000820907487574183*G0_1_0_0_4 - 0.011544011544012*G0_1_0_0_5 - 0.0225322003099789*G0_1_0_1_0 + 0.378771845438526*G0_1_0_1_1 - 0.0225322003099789*G0_1_0_1_2 + 0.0951739618406319*G0_1_0_1_3 + 0.0050451606007163*G0_1_0_1_4 + 0.0951739618406322*G0_1_0_1_5 + 0.00167174389396617*G0_1_0_2_0 - 0.0225322003099789*G0_1_0_2_1 + 0.0023344556677891*G0_1_0_2_2 - 0.0115440115440119*G0_1_0_2_3 - 0.000820907487574177*G0_1_0_2_4 - 0.00649885094329564*G0_1_0_2_5 - 0.00649885094329561*G0_1_0_3_0 + 0.0951739618406319*G0_1_0_3_1 - 0.0115440115440119*G0_1_0_3_2 + 0.0519908075463649*G0_1_0_3_3 + 0.00290738068515856*G0_1_0_3_4 + 0.0259954037731826*G0_1_0_3_5 - 0.000820907487574183*G0_1_0_4_0 + 0.0050451606007163*G0_1_0_4_1 - 0.000820907487574177*G0_1_0_4_2 + 0.00290738068515856*G0_1_0_4_3 - 0.000752498530276348*G0_1_0_4_4 + 0.00290738068515855*G0_1_0_4_5 - 0.011544011544012*G0_1_0_5_0 + 0.0951739618406322*G0_1_0_5_1 - 0.00649885094329564*G0_1_0_5_2 + 0.0259954037731826*G0_1_0_5_3 + 0.00290738068515855*G0_1_0_5_4 + 0.0519908075463651*G0_1_0_5_5;
    A[89] = 0.00574635241301926*G0_0_0_0_0 - 0.0246272246272254*G0_0_0_0_2 + 0.00410453743787091*G0_0_0_0_3 - 0.0492544492544509*G0_0_0_0_4 - 0.00369408369408382*G0_0_0_0_5 - 0.00574635241301931*G0_0_0_1_1 + 0.0246272246272256*G0_0_0_1_2 + 0.0492544492544511*G0_0_0_1_3 - 0.00410453743787086*G0_0_0_1_4 + 0.00369408369408383*G0_0_0_1_5 - 0.0246272246272254*G0_0_0_2_0 + 0.0246272246272256*G0_0_0_2_1 - 0.143658810325483*G0_0_0_2_3 + 0.143658810325482*G0_0_0_2_4 + 0.00410453743787091*G0_0_0_3_0 + 0.0492544492544511*G0_0_0_3_1 - 0.143658810325483*G0_0_0_3_2 - 0.262690396023739*G0_0_0_3_3 - 0.00820907487574192*G0_0_0_3_5 - 0.0492544492544509*G0_0_0_4_0 - 0.00410453743787086*G0_0_0_4_1 + 0.143658810325482*G0_0_0_4_2 + 0.262690396023738*G0_0_0_4_4 + 0.00820907487574182*G0_0_0_4_5 - 0.00369408369408382*G0_0_0_5_0 + 0.00369408369408383*G0_0_0_5_1 - 0.00820907487574192*G0_0_0_5_3 + 0.00820907487574182*G0_0_0_5_4 - 0.00533589866923217*G0_0_1_0_0 - 0.00492544492544509*G0_0_1_0_1 + 0.0233958633958642*G0_0_1_0_2 + 0.0242167708834383*G0_0_1_0_3 + 0.0147763347763353*G0_0_1_0_4 + 0.00205226871893546*G0_0_1_0_5 - 0.0049254449254451*G0_0_1_1_0 - 0.0110822510822514*G0_0_1_1_1 + 0.0480230880230897*G0_0_1_1_2 + 0.0640307840307863*G0_0_1_1_3 + 0.0201122334455675*G0_0_1_1_4 + 0.00574635241301934*G0_0_1_1_5 + 0.0233958633958642*G0_0_1_2_0 + 0.0480230880230897*G0_0_1_2_1 - 0.326310726310738*G0_0_1_2_2 - 0.231906365239707*G0_0_1_2_3 - 0.0882475549142246*G0_0_1_2_4 - 0.0119031585698257*G0_0_1_2_5 + 0.0242167708834383*G0_0_1_3_0 + 0.0640307840307863*G0_0_1_3_1 - 0.231906365239707*G0_0_1_3_2 - 0.330004810004822*G0_0_1_3_3 - 0.0886580086580118*G0_0_1_3_4 - 0.0246272246272255*G0_0_1_3_5 + 0.0147763347763353*G0_0_1_4_0 + 0.0201122334455675*G0_0_1_4_1 - 0.0882475549142246*G0_0_1_4_2 - 0.0886580086580118*G0_0_1_4_3 - 0.0673144139810831*G0_0_1_4_4 - 0.0164181497514837*G0_0_1_4_5 + 0.00205226871893546*G0_0_1_5_0 + 0.00574635241301934*G0_0_1_5_1 - 0.0119031585698257*G0_0_1_5_2 - 0.0246272246272256*G0_0_1_5_3 - 0.0164181497514837*G0_0_1_5_4 - 0.0180599647266317*G0_0_1_5_5 - 0.000820907487574183*G0_1_0_0_0 - 0.00554112554112571*G0_1_0_0_1 + 0.00472021805355151*G0_1_0_0_2 + 0.0373512906846252*G0_1_0_0_3 - 0.00944043610710316*G0_1_0_0_4 + 0.000820907487574143*G0_1_0_0_5 - 0.00554112554112571*G0_1_0_1_0 - 0.00779862113195465*G0_1_0_1_1 + 0.0416610549943898*G0_1_0_1_2 + 0.11287477954145*G0_1_0_1_3 + 0.00944043610710309*G0_1_0_1_4 + 0.0119031585698257*G0_1_0_1_5 + 0.00472021805355151*G0_1_0_2_0 + 0.0416610549943898*G0_1_0_2_1 - 0.133397466730805*G0_1_0_2_2 - 0.242167708834384*G0_1_0_2_3 - 0.00944043610710315*G0_1_0_2_5 + 0.0373512906846252*G0_1_0_3_0 + 0.11287477954145*G0_1_0_3_1 - 0.242167708834384*G0_1_0_3_2 - 0.842251082251113*G0_1_0_3_3 - 0.0935834535834568*G0_1_0_3_4 - 0.0558217091550446*G0_1_0_3_5 - 0.00944043610710316*G0_1_0_4_0 + 0.00944043610710309*G0_1_0_4_1 - 0.0935834535834568*G0_1_0_4_3 + 0.0935834535834574*G0_1_0_4_4 + 0.000820907487574144*G0_1_0_5_0 + 0.0119031585698257*G0_1_0_5_1 - 0.00944043610710315*G0_1_0_5_2 - 0.0558217091550446*G0_1_0_5_3 - 0.00164181497514857*G0_1_0_5_5 - 0.018059964726632*G0_1_1_0_0 + 0.00410453743787095*G0_1_1_0_1 + 0.0172390572390578*G0_1_1_0_2 + 0.0566426166426184*G0_1_1_0_3 + 0.0168286034952707*G0_1_1_0_4 + 0.0180599647266319*G0_1_1_0_5 + 0.00410453743787095*G0_1_1_1_0 - 0.0566426166426188*G0_1_1_1_1 + 0.0558217091550445*G0_1_1_1_2 + 0.104255250921921*G0_1_1_1_3 + 0.0262690396023738*G0_1_1_1_4 - 0.0254481321147998*G0_1_1_1_5 + 0.0172390572390578*G0_1_1_2_0 + 0.0558217091550445*G0_1_1_2_1 - 0.2257495590829*G0_1_1_2_2 - 0.270899470899481*G0_1_1_2_3 - 0.0595157928491283*G0_1_1_2_4 + 0.00902998236331591*G0_1_1_2_5 + 0.0566426166426184*G0_1_1_3_0 + 0.104255250921921*G0_1_1_3_1 - 0.270899470899481*G0_1_1_3_2 - 0.893147346480711*G0_1_1_3_3 - 0.165823312489985*G0_1_1_3_4 - 0.131345198011869*G0_1_1_3_5 + 0.0168286034952707*G0_1_1_4_0 + 0.0262690396023738*G0_1_1_4_1 - 0.0595157928491283*G0_1_1_4_2 - 0.165823312489985*G0_1_1_4_3 - 0.072239858906528*G0_1_1_4_4 - 0.0705980439313796*G0_1_1_4_5 + 0.0180599647266319*G0_1_1_5_0 - 0.0254481321147998*G0_1_1_5_1 + 0.00902998236331591*G0_1_1_5_2 - 0.131345198011869*G0_1_1_5_3 - 0.0705980439313796*G0_1_1_5_4 - 0.34149751483086*G0_1_1_5_5;
    A[99] = A[89] - 0.176084656084662*G0_0_0_0_0 + 0.00581476137031712*G0_0_0_0_1 + 0.0465180909625369*G0_0_0_0_2 - 0.0123136123136127*G0_0_0_0_3 - 0.0608839719950852*G0_0_0_0_4 - 0.0175126930682493*G0_0_0_0_5 + 0.00581476137031712*G0_0_0_1_0 + 0.0168286034952708*G0_0_0_1_1 - 0.0273635829191396*G0_0_0_1_2 - 0.0477494521938983*G0_0_0_1_3 - 0.0129977018865912*G0_0_0_1_5 + 0.0465180909625369*G0_0_0_2_0 - 0.0273635829191396*G0_0_0_2_1 + 0.00451499118165926*G0_0_0_2_2 + 0.144890171556844*G0_0_0_2_3 - 0.125188391855063*G0_0_0_2_4 - 0.00725134947357191*G0_0_0_2_5 - 0.0123136123136127*G0_0_0_3_0 - 0.0477494521938983*G0_0_0_3_1 + 0.144890171556844*G0_0_0_3_2 + 0.366124739458086*G0_0_0_3_3 + 0.0246272246272257*G0_0_0_3_4 + 0.0391299235743695*G0_0_0_3_5 - 0.0608839719950852*G0_0_0_4_0 - 0.125188391855063*G0_0_0_4_2 + 0.0246272246272257*G0_0_0_4_3 - 0.349706589706601*G0_0_0_4_4 + 0.0145026989471439*G0_0_0_4_5 - 0.0175126930682493*G0_0_0_5_0 - 0.0129977018865912*G0_0_0_5_1 - 0.00725134947357191*G0_0_0_5_2 + 0.0391299235743695*G0_0_0_5_3 + 0.0145026989471439*G0_0_0_5_4 + 0.0744289455400592*G0_0_0_5_5 + 0.0905050505050534*G0_0_1_0_0 - 0.0114927048260385*G0_0_1_0_1 - 0.0398140131473478*G0_0_1_0_2 - 0.0201122334455674*G0_0_1_0_3 + 0.0529485329485347*G0_0_1_0_4 + 0.0656725990059345*G0_0_1_0_5 - 0.0114927048260385*G0_0_1_1_0 + 0.0268847202180545*G0_0_1_1_1 - 0.0461760461760478*G0_0_1_1_2 - 0.0656725990059346*G0_0_1_1_3 - 0.0459708193041542*G0_0_1_1_4 - 0.0336572069905415*G0_0_1_1_5 - 0.0398140131473478*G0_0_1_2_0 - 0.0461760461760478*G0_0_1_2_1 + 0.342113195446541*G0_0_1_2_2 + 0.230264550264558*G0_0_1_2_3 + 0.0603367003367025*G0_0_1_2_4 - 0.013955427288761*G0_0_1_2_5 - 0.0201122334455674*G0_0_1_3_0 - 0.0656725990059346*G0_0_1_3_1 + 0.230264550264558*G0_0_1_3_2 + 0.440827320827337*G0_0_1_3_3 + 0.132166105499443*G0_0_1_3_4 + 0.0681353214686572*G0_0_1_3_5 + 0.0529485329485347*G0_0_1_4_0 - 0.0459708193041542*G0_0_1_4_1 + 0.0603367003367025*G0_0_1_4_2 + 0.132166105499443*G0_0_1_4_3 + 0.222465929132604*G0_0_1_4_4 + 0.119852493185831*G0_0_1_4_5 + 0.0656725990059345*G0_0_1_5_0 - 0.0336572069905415*G0_0_1_5_1 - 0.013955427288761*G0_0_1_5_2 + 0.0681353214686573*G0_0_1_5_3 + 0.119852493185831*G0_0_1_5_4 + 0.173211479878152*G0_0_1_5_5 + 0.449241622574972*G0_1_0_0_0 - 0.0108770242103579*G0_1_0_0_1 - 0.0211383678050352*G0_1_0_0_2 - 0.0414558281224961*G0_1_0_0_3 + 0.0689562289562314*G0_1_0_0_4 + 0.0586948853615542*G0_1_0_0_5 - 0.0108770242103579*G0_1_0_1_0 + 0.0170338303671642*G0_1_0_1_1 - 0.0433028699695382*G0_1_0_1_2 - 0.111643418310089*G0_1_0_1_3 - 0.0188808722142062*G0_1_0_1_4 - 0.0151867885201224*G0_1_0_1_5 - 0.0211383678050352*G0_1_0_2_0 - 0.0433028699695382*G0_1_0_2_1 + 0.142632675966015*G0_1_0_2_2 + 0.243399070065746*G0_1_0_2_3 - 0.00328362995029673*G0_1_0_2_4 - 0.0414558281224961*G0_1_0_3_0 - 0.111643418310089*G0_1_0_3_1 + 0.243399070065746*G0_1_0_3_2 + 0.943222703222737*G0_1_0_3_3 + 0.120673400673405*G0_1_0_3_4 + 0.0829116562449926*G0_1_0_3_5 + 0.0689562289562314*G0_1_0_4_0 - 0.0188808722142062*G0_1_0_4_1 - 0.00328362995029674*G0_1_0_4_2 + 0.120673400673405*G0_1_0_4_3 - 0.0697771364438061*G0_1_0_4_4 + 0.0377617444284124*G0_1_0_4_5 + 0.0586948853615542*G0_1_0_5_0 - 0.0151867885201224*G0_1_0_5_1 + 0.0829116562449926*G0_1_0_5_3 + 0.0377617444284124*G0_1_0_5_4 + 0.0254481321147998*G0_1_0_5_5 - 0.152278338945011*G0_1_1_0_0 + 0.0177863288974406*G0_1_1_0_1 - 0.0114242958687407*G0_1_1_0_2 - 0.0648516915183602*G0_1_1_0_3 - 0.0380353802576037*G0_1_1_0_4 - 0.128198385976168*G0_1_1_0_5 + 0.0177863288974406*G0_1_1_1_0 + 0.0611576078242768*G0_1_1_1_1 - 0.0585580674469584*G0_1_1_1_2 - 0.10302388969056*G0_1_1_1_3 - 0.0335203890759458*G0_1_1_1_4 + 0.043918550585219*G0_1_1_1_5 - 0.0114242958687407*G0_1_1_2_0 - 0.0585580674469584*G0_1_1_2_1 + 0.236831810165152*G0_1_1_2_2 + 0.272404467960033*G0_1_1_2_3 + 0.0502121746566209*G0_1_1_2_4 - 0.0131345198011868*G0_1_1_2_5 - 0.0648516915183602*G0_1_1_3_0 - 0.10302388969056*G0_1_1_3_1 + 0.272404467960033*G0_1_1_3_2 + 0.996581689915059*G0_1_1_3_3 + 0.196744161188612*G0_1_1_3_4 + 0.155972422639095*G0_1_1_3_5 - 0.0380353802576037*G0_1_1_4_0 - 0.0335203890759458*G0_1_1_4_1 + 0.0502121746566209*G0_1_1_4_2 + 0.196744161188612*G0_1_1_4_3 + 0.146668804446587*G0_1_1_4_4 + 0.0933098177542653*G0_1_1_4_5 - 0.128198385976168*G0_1_1_5_0 + 0.043918550585219*G0_1_1_5_1 - 0.0131345198011868*G0_1_1_5_2 + 0.155972422639095*G0_1_1_5_3 + 0.0933098177542653*G0_1_1_5_4 + 0.254481321147996*G0_1_1_5_5;
    A[125] = A[99] + 0.16089786756454*G0_0_0_0_0 - 0.0114927048260385*G0_0_0_0_1 + 0.0386510608732843*G0_0_0_0_2 + 0.0321522099299887*G0_0_0_0_3 + 0.150499706055267*G0_0_0_0_4 + 0.0243535887980341*G0_0_0_0_5 - 0.0114927048260385*G0_0_0_1_0 - 0.0205226871893546*G0_0_0_1_1 + 0.0632782855005098*G0_0_0_1_2 + 0.0388562877451779*G0_0_0_1_3 + 0.0280476724921179*G0_0_0_1_4 + 0.0124504302282084*G0_0_0_1_5 + 0.0386510608732843*G0_0_0_2_0 + 0.0632782855005098*G0_0_0_2_1 - 0.878781465448161*G0_0_0_2_2 - 0.259817219817228*G0_0_0_2_3 - 0.277056277056286*G0_0_0_2_4 - 0.00916680027791186*G0_0_0_2_5 + 0.0321522099299887*G0_0_0_3_0 + 0.0388562877451779*G0_0_0_3_1 - 0.259817219817228*G0_0_0_3_2 - 0.294979423868323*G0_0_0_3_3 - 0.120399764844213*G0_0_0_3_4 - 0.0459708193041543*G0_0_0_3_5 + 0.150499706055267*G0_0_0_4_0 + 0.0280476724921179*G0_0_0_4_1 - 0.277056277056286*G0_0_0_4_2 - 0.120399764844213*G0_0_0_4_3 - 0.104528886751113*G0_0_0_4_4 - 0.0377617444284124*G0_0_0_4_5 + 0.0243535887980341*G0_0_0_5_0 + 0.0124504302282084*G0_0_0_5_1 - 0.00916680027791186*G0_0_0_5_2 - 0.0459708193041543*G0_0_0_5_3 - 0.0377617444284124*G0_0_0_5_4 - 0.0793543904655042*G0_0_0_5_5 - 0.0898893698893728*G0_0_1_0_0 + 0.0118347496125278*G0_0_1_0_1 + 0.0386510608732844*G0_0_1_0_2 + 0.0176495109828449*G0_0_1_0_3 - 0.0491176313398552*G0_0_1_0_4 - 0.0645780556891689*G0_0_1_0_5 + 0.0118347496125278*G0_0_1_1_0 - 0.027089947089948*G0_0_1_1_1 + 0.0364619742397533*G0_0_1_1_2 + 0.0480230880230896*G0_0_1_1_3 + 0.0444658222436015*G0_0_1_1_4 + 0.0307840307840318*G0_0_1_1_5 + 0.0386510608732844*G0_0_1_2_0 + 0.0364619742397533*G0_0_1_2_1 - 0.271309924643267*G0_0_1_2_2 - 0.176221473999258*G0_0_1_2_3 - 0.0610207899096809*G0_0_1_2_4 + 0.0135449735449739*G0_0_1_2_5 + 0.0176495109828449*G0_0_1_3_0 + 0.0480230880230896*G0_0_1_3_1 - 0.176221473999258*G0_0_1_3_2 - 0.352990219656899*G0_0_1_3_3 - 0.124230666452893*G0_0_1_3_4 - 0.0623889690556379*G0_0_1_3_5 - 0.0491176313398552*G0_0_1_4_0 + 0.0444658222436015*G0_0_1_4_1 - 0.0610207899096809*G0_0_1_4_2 - 0.124230666452893*G0_0_1_4_3 - 0.235874084762982*G0_0_1_4_4 - 0.116021591577151*G0_0_1_4_5 - 0.0645780556891689*G0_0_1_5_0 + 0.0307840307840318*G0_0_1_5_1 + 0.0135449735449739*G0_0_1_5_2 - 0.0623889690556379*G0_0_1_5_3 - 0.116021591577151*G0_0_1_5_4 - 0.162539682539688*G0_0_1_5_5 - 0.446573673240356*G0_1_0_0_0 + 0.0153236064347181*G0_1_0_0_1 + 0.0386510608732843*G0_1_0_0_2 + 0.00944043610710311*G0_1_0_0_3 - 0.0655357810913389*G0_1_0_0_4 - 0.059242157019937*G0_1_0_0_5 + 0.0153236064347181*G0_1_0_1_0 - 0.0139554272887611*G0_1_0_1_1 + 0.0399508310619435*G0_1_0_1_2 + 0.0205226871893546*G0_1_0_1_3 + 0.0116295227406342*G0_1_0_1_4 + 0.00328362995029672*G0_1_0_1_5 + 0.0386510608732843*G0_1_0_2_0 + 0.0399508310619435*G0_1_0_2_1 - 0.627994227994248*G0_1_0_2_2 - 0.170885575330026*G0_1_0_2_3 - 0.0774389396611644*G0_1_0_2_4 + 0.00533589866923209*G0_1_0_2_5 + 0.00944043610710311*G0_1_0_3_0 + 0.0205226871893546*G0_1_0_3_1 - 0.170885575330026*G0_1_0_3_2 - 0.211794131794139*G0_1_0_3_3 - 0.0421399176954747*G0_1_0_3_4 - 0.0295526695526706*G0_1_0_3_5 - 0.0655357810913389*G0_1_0_4_0 + 0.0116295227406342*G0_1_0_4_1 - 0.0774389396611644*G0_1_0_4_2 - 0.0421399176954747*G0_1_0_4_3 + 0.0268163112607568*G0_1_0_4_4 - 0.0339308428197329*G0_1_0_4_5 - 0.059242157019937*G0_1_0_5_0 + 0.00328362995029672*G0_1_0_5_1 + 0.00533589866923209*G0_1_0_5_2 - 0.0295526695526706*G0_1_0_5_3 - 0.0339308428197329*G0_1_0_5_4 - 0.0213435946769288*G0_1_0_5_5 + 0.181420554753894*G0_1_1_0_0 - 0.0246272246272255*G0_1_1_0_1 + 0.00410453743787087*G0_1_1_0_3 + 0.0119031585698256*G0_1_1_0_4 + 0.111643418310089*G0_1_1_0_5 - 0.0246272246272255*G0_1_1_1_0 + 0.0246272246272255*G0_1_1_1_2 + 0.0172390572390579*G0_1_1_1_3 - 0.0172390572390578*G0_1_1_1_5 + 0.0246272246272255*G0_1_1_2_1 - 0.181420554753894*G0_1_1_2_2 - 0.111643418310089*G0_1_1_2_3 - 0.0119031585698256*G0_1_1_2_4 - 0.00410453743787095*G0_1_1_2_5 + 0.00410453743787087*G0_1_1_3_0 + 0.0172390572390579*G0_1_1_3_1 - 0.111643418310089*G0_1_1_3_2 - 0.190450537117211*G0_1_1_3_3 - 0.00820907487574185*G0_1_1_3_4 + 0.0119031585698256*G0_1_1_4_0 - 0.0119031585698256*G0_1_1_4_2 - 0.00820907487574185*G0_1_1_4_3 + 0.00820907487574182*G0_1_1_4_5 + 0.111643418310089*G0_1_1_5_0 - 0.0172390572390578*G0_1_1_5_1 - 0.00410453743787095*G0_1_1_5_2 + 0.00820907487574182*G0_1_1_5_4 + 0.190450537117211*G0_1_1_5_5;
    A[83] = A[125] + 0.00656725990059345*G0_0_1_0_0 + 0.00348885682219028*G0_0_1_0_1 - 0.0164181497514836*G0_0_1_0_3 - 0.0246272246272255*G0_0_1_0_4 - 0.00287317620650964*G0_0_1_0_5 + 0.00348885682219028*G0_0_1_1_0 + 0.00656725990059338*G0_0_1_1_1 - 0.0246272246272255*G0_0_1_1_3 - 0.0164181497514837*G0_0_1_1_4 - 0.00287317620650969*G0_0_1_1_5 - 0.363251563251575*G0_0_1_2_2 + 0.00820907487574182*G0_0_1_2_3 + 0.00820907487574199*G0_0_1_2_4 + 0.00820907487574179*G0_0_1_2_5 - 0.0164181497514836*G0_0_1_3_0 - 0.0246272246272255*G0_0_1_3_1 + 0.00820907487574182*G0_0_1_3_2 + 0.131345198011869*G0_0_1_3_3 + 0.0656725990059346*G0_0_1_3_4 + 0.0164181497514836*G0_0_1_3_5 - 0.0246272246272255*G0_0_1_4_0 - 0.0164181497514837*G0_0_1_4_1 + 0.00820907487574199*G0_0_1_4_2 + 0.0656725990059346*G0_0_1_4_3 + 0.131345198011869*G0_0_1_4_4 + 0.0164181497514837*G0_0_1_4_5 - 0.00287317620650963*G0_0_1_5_0 - 0.00287317620650969*G0_0_1_5_1 + 0.00820907487574178*G0_0_1_5_2 + 0.0164181497514836*G0_0_1_5_3 + 0.0164181497514837*G0_0_1_5_4 + 0.00985088985088991*G0_0_1_5_5 - 0.00656725990059345*G0_1_0_0_0 - 0.00348885682219028*G0_1_0_0_1 + 0.0164181497514836*G0_1_0_0_3 + 0.0246272246272255*G0_1_0_0_4 + 0.00287317620650964*G0_1_0_0_5 - 0.00348885682219029*G0_1_0_1_0 - 0.00656725990059338*G0_1_0_1_1 + 0.0246272246272255*G0_1_0_1_3 + 0.0164181497514837*G0_1_0_1_4 + 0.00287317620650969*G0_1_0_1_5 + 0.363251563251575*G0_1_0_2_2 - 0.00820907487574182*G0_1_0_2_3 - 0.00820907487574199*G0_1_0_2_4 - 0.00820907487574179*G0_1_0_2_5 + 0.0164181497514836*G0_1_0_3_0 + 0.0246272246272255*G0_1_0_3_1 - 0.00820907487574182*G0_1_0_3_2 - 0.131345198011869*G0_1_0_3_3 - 0.0656725990059346*G0_1_0_3_4 - 0.0164181497514836*G0_1_0_3_5 + 0.0246272246272255*G0_1_0_4_0 + 0.0164181497514837*G0_1_0_4_1 - 0.00820907487574199*G0_1_0_4_2 - 0.0656725990059346*G0_1_0_4_3 - 0.131345198011869*G0_1_0_4_4 - 0.0164181497514837*G0_1_0_4_5 + 0.00287317620650963*G0_1_0_5_0 + 0.00287317620650969*G0_1_0_5_1 - 0.00820907487574179*G0_1_0_5_2 - 0.0164181497514836*G0_1_0_5_3 - 0.0164181497514837*G0_1_0_5_4 - 0.00985088985088991*G0_1_0_5_5;
    A[80] = -A[125] + 0.00656725990059345*G0_1_0_0_0 + 0.00348885682219029*G0_1_0_0_1 - 0.0164181497514836*G0_1_0_0_3 - 0.0246272246272255*G0_1_0_0_4 - 0.00287317620650964*G0_1_0_0_5 + 0.00348885682219029*G0_1_0_1_0 + 0.00656725990059339*G0_1_0_1_1 - 0.0246272246272255*G0_1_0_1_3 - 0.0164181497514837*G0_1_0_1_4 - 0.00287317620650969*G0_1_0_1_5 - 0.363251563251575*G0_1_0_2_2 + 0.00820907487574193*G0_1_0_2_3 + 0.00820907487574205*G0_1_0_2_4 + 0.0082090748757418*G0_1_0_2_5 - 0.0164181497514836*G0_1_0_3_0 - 0.0246272246272255*G0_1_0_3_1 + 0.00820907487574191*G0_1_0_3_2 + 0.131345198011869*G0_1_0_3_3 + 0.0656725990059346*G0_1_0_3_4 + 0.0164181497514837*G0_1_0_3_5 - 0.0246272246272255*G0_1_0_4_0 - 0.0164181497514837*G0_1_0_4_1 + 0.00820907487574205*G0_1_0_4_2 + 0.0656725990059346*G0_1_0_4_3 + 0.13134519801187*G0_1_0_4_4 + 0.0164181497514837*G0_1_0_4_5 - 0.00287317620650964*G0_1_0_5_0 - 0.00287317620650969*G0_1_0_5_1 + 0.0082090748757418*G0_1_0_5_2 + 0.0164181497514837*G0_1_0_5_3 + 0.0164181497514837*G0_1_0_5_4 + 0.00985088985088992*G0_1_0_5_5 + 0.0221645021645029*G0_1_1_0_0 - 0.00458340013895591*G0_1_1_0_1 - 0.0116295227406343*G0_1_1_0_2 - 0.0537694404361088*G0_1_1_0_3 - 0.0351622040510941*G0_1_1_0_4 - 0.0186072363850148*G0_1_1_0_5 - 0.00458340013895591*G0_1_1_1_0 + 0.101382074715412*G0_1_1_1_1 - 0.0242851798407363*G0_1_1_1_2 - 0.0496649029982379*G0_1_1_1_3 - 0.0351622040510942*G0_1_1_1_4 + 0.0348885682219031*G0_1_1_1_5 - 0.0116295227406343*G0_1_1_2_0 - 0.0242851798407363*G0_1_1_2_1 + 0.093036181925074*G0_1_1_2_3 + 0.0465180909625371*G0_1_1_2_4 - 0.00205226871893543*G0_1_1_2_5 - 0.0537694404361088*G0_1_1_3_0 - 0.0496649029982379*G0_1_1_3_1 + 0.093036181925074*G0_1_1_3_2 + 0.533589866923219*G0_1_1_3_3 + 0.177863288974406*G0_1_1_3_4 + 0.111643418310089*G0_1_1_3_5 - 0.0351622040510941*G0_1_1_4_0 - 0.0351622040510942*G0_1_1_4_1 + 0.0465180909625371*G0_1_1_4_2 + 0.177863288974406*G0_1_1_4_3 + 0.177863288974407*G0_1_1_4_4 + 0.0744289455400592*G0_1_1_4_5 - 0.0186072363850148*G0_1_1_5_0 + 0.0348885682219031*G0_1_1_5_1 - 0.00205226871893543*G0_1_1_5_2 + 0.111643418310089*G0_1_1_5_3 + 0.0744289455400592*G0_1_1_5_4 + 0.2511976911977*G0_1_1_5_5;
    A[144] = A[80] + 0.524149430816116*G0_0_0_0_0 - 0.0357778846667748*G0_0_0_0_1 + 0.0270215381326501*G0_0_0_0_2 + 0.0218908663353114*G0_0_0_0_3 + 0.188808722142062*G0_0_0_0_4 + 0.109180695847367*G0_0_0_0_5 - 0.0357778846667748*G0_0_0_1_0 + 0.0742921276254635*G0_0_0_1_1 + 0.0552060285393637*G0_0_0_1_2 + 0.0766180321735904*G0_0_0_1_3 + 0.00930361819250737*G0_0_0_1_4 - 0.0125872481428041*G0_0_0_1_5 + 0.0270215381326501*G0_0_0_2_0 + 0.0552060285393637*G0_0_0_2_1 - 0.863184223184252*G0_0_0_2_2 - 0.275551279995734*G0_0_0_2_3 - 0.287591256480155*G0_0_0_2_4 - 0.0465180909625372*G0_0_0_2_5 + 0.0218908663353114*G0_0_0_3_0 + 0.0766180321735904*G0_0_0_3_1 - 0.275551279995734*G0_0_0_3_2 - 0.0536326225215133*G0_0_0_3_3 - 0.0623889690556379*G0_0_0_3_4 + 0.0492544492544509*G0_0_0_3_5 + 0.188808722142062*G0_0_0_4_0 + 0.00930361819250737*G0_0_0_4_1 - 0.287591256480155*G0_0_0_4_2 - 0.0623889690556379*G0_0_0_4_3 - 0.0580107957885756*G0_0_0_4_4 + 0.0744289455400592*G0_0_0_4_5 + 0.109180695847367*G0_0_0_5_0 - 0.0125872481428041*G0_0_0_5_1 - 0.0465180909625372*G0_0_0_5_2 + 0.0492544492544509*G0_0_0_5_3 + 0.0744289455400592*G0_0_0_5_4 + 0.322890278445846*G0_0_0_5_5 - 0.0898893698893729*G0_0_1_0_0 - 0.0124504302282084*G0_0_1_0_1 + 0.0270215381326501*G0_0_1_0_2 + 0.0155972422639095*G0_0_1_0_3 - 0.00259954037731822*G0_0_1_0_4 + 0.028458126235905*G0_0_1_0_5 - 0.0124504302282084*G0_0_1_1_0 + 0.0742921276254635*G0_0_1_1_1 + 0.0318785741007974*G0_0_1_1_2 + 0.0829116562449924*G0_0_1_1_3 + 0.0093036181925074*G0_0_1_1_4 - 0.0188808722142061*G0_0_1_1_5 + 0.0270215381326501*G0_0_1_2_0 + 0.0318785741007974*G0_0_1_2_1 - 0.249145422478764*G0_0_1_2_2 - 0.194828710384273*G0_0_1_2_3 - 0.0961829939607751*G0_0_1_2_4 - 0.040224466891135*G0_0_1_2_5 + 0.0155972422639095*G0_0_1_3_0 + 0.0829116562449924*G0_0_1_3_1 - 0.194828710384273*G0_0_1_3_2 - 0.101792528459199*G0_0_1_3_3 - 0.0498017209128337*G0_0_1_3_4 + 0.0492544492544509*G0_0_1_3_5 - 0.00259954037731822*G0_0_1_4_0 + 0.0093036181925074*G0_0_1_4_1 - 0.0961829939607751*G0_0_1_4_2 - 0.0498017209128337*G0_0_1_4_3 - 0.0580107957885756*G0_0_1_4_4 + 0.061841697397255*G0_0_1_4_5 + 0.028458126235905*G0_0_1_5_0 - 0.0188808722142061*G0_0_1_5_1 - 0.040224466891135*G0_0_1_5_2 + 0.0492544492544509*G0_0_1_5_3 + 0.0618416973972551*G0_0_1_5_4 + 0.371050184383531*G0_0_1_5_5 - 0.0898893698893729*G0_1_0_0_0 - 0.0124504302282084*G0_1_0_0_1 + 0.0270215381326501*G0_1_0_0_2 + 0.0155972422639095*G0_1_0_0_3 - 0.00259954037731822*G0_1_0_0_4 + 0.028458126235905*G0_1_0_0_5 - 0.0124504302282084*G0_1_0_1_0 + 0.0742921276254635*G0_1_0_1_1 + 0.0318785741007974*G0_1_0_1_2 + 0.0829116562449925*G0_1_0_1_3 + 0.0093036181925074*G0_1_0_1_4 - 0.0188808722142061*G0_1_0_1_5 + 0.0270215381326501*G0_1_0_2_0 + 0.0318785741007974*G0_1_0_2_1 - 0.249145422478764*G0_1_0_2_2 - 0.194828710384273*G0_1_0_2_3 - 0.0961829939607751*G0_1_0_2_4 - 0.040224466891135*G0_1_0_2_5 + 0.0155972422639095*G0_1_0_3_0 + 0.0829116562449924*G0_1_0_3_1 - 0.194828710384273*G0_1_0_3_2 - 0.101792528459199*G0_1_0_3_3 - 0.0498017209128337*G0_1_0_3_4 + 0.0492544492544509*G0_1_0_3_5 - 0.00259954037731822*G0_1_0_4_0 + 0.0093036181925074*G0_1_0_4_1 - 0.0961829939607751*G0_1_0_4_2 - 0.0498017209128337*G0_1_0_4_3 - 0.0580107957885756*G0_1_0_4_4 + 0.0618416973972551*G0_1_0_4_5 + 0.028458126235905*G0_1_0_5_0 - 0.0188808722142061*G0_1_0_5_1 - 0.040224466891135*G0_1_0_5_2 + 0.0492544492544509*G0_1_0_5_3 + 0.0618416973972551*G0_1_0_5_4 + 0.371050184383531*G0_1_0_5_5 + 0.159256052589392*G0_1_1_0_0 - 0.0443290043290058*G0_1_1_0_1 + 0.0558217091550443*G0_1_1_0_3 + 0.0935834535834568*G0_1_1_0_4 + 0.223286836620178*G0_1_1_0_5 - 0.0443290043290058*G0_1_1_1_0 + 0.0443290043290059*G0_1_1_1_2 + 0.101792528459199*G0_1_1_1_3 - 0.101792528459199*G0_1_1_1_5 + 0.0443290043290059*G0_1_1_2_1 - 0.159256052589391*G0_1_1_2_2 - 0.223286836620178*G0_1_1_2_3 - 0.0935834535834568*G0_1_1_2_4 - 0.0558217091550445*G0_1_1_2_5 + 0.0558217091550443*G0_1_1_3_0 + 0.101792528459199*G0_1_1_3_1 - 0.223286836620178*G0_1_1_3_2 - 0.472842712842729*G0_1_1_3_3 - 0.111643418310089*G0_1_1_3_4 + 0.0935834535834568*G0_1_1_4_0 - 0.0935834535834568*G0_1_1_4_2 - 0.111643418310089*G0_1_1_4_3 + 0.111643418310089*G0_1_1_4_5 + 0.223286836620178*G0_1_1_5_0 - 0.101792528459199*G0_1_1_5_1 - 0.0558217091550445*G0_1_1_5_2 + 0.111643418310089*G0_1_1_5_4 + 0.47284271284273*G0_1_1_5_5;
    A[31] = 1.76366843033591e-05*G0_1_0_0_0 + 0.0011974239752018*G0_1_0_0_1 + 0.00119742397520179*G0_1_0_0_2 + 0.00044145155256268*G0_1_0_0_3 + 0.00065416065416068*G0_1_0_0_4 + 0.000654160654160682*G0_1_0_0_5 + 0.0011974239752018*G0_1_0_1_0 - 0.0161696328363002*G0_1_0_1_1 + 0.000518678852012207*G0_1_0_1_2 - 0.000816631927743088*G0_1_0_1_3 + 3.95489284378198e-05*G0_1_0_1_4 - 0.00540430762653009*G0_1_0_1_5 + 0.00119742397520179*G0_1_0_2_0 + 0.000518678852012208*G0_1_0_2_1 - 0.0161696328363*G0_1_0_2_2 - 0.000816631927743068*G0_1_0_2_3 - 0.00540430762653003*G0_1_0_2_4 + 3.95489284378183e-05*G0_1_0_2_5 + 0.00044145155256268*G0_1_0_3_0 - 0.000816631927743088*G0_1_0_3_1 - 0.000816631927743068*G0_1_0_3_2 + 0.00216343327454445*G0_1_0_3_3 - 0.000962000962000996*G0_1_0_3_4 - 0.000962000962001002*G0_1_0_3_5 + 0.00065416065416068*G0_1_0_4_0 + 3.95489284378198e-05*G0_1_0_4_1 - 0.00540430762653003*G0_1_0_4_2 - 0.000962000962000996*G0_1_0_4_3 - 0.0034461012238791*G0_1_0_4_4 - 0.000158195713751276*G0_1_0_4_5 + 0.000654160654160682*G0_1_0_5_0 - 0.00540430762653009*G0_1_0_5_1 + 3.95489284378182e-05*G0_1_0_5_2 - 0.000962000962001002*G0_1_0_5_3 - 0.000158195713751277*G0_1_0_5_4 - 0.00344610122387915*G0_1_0_5_5;
    A[107] = -0.000814494147827546*G0_0_1_0_0 + 0.00109988776655447*G0_0_1_0_1 - 0.00634920634920652*G0_0_1_0_2 - 0.00365560365560377*G0_0_1_0_3 - 0.00218053551386892*G0_0_1_0_4 - 0.00168029501362843*G0_0_1_0_5 + 0.00109988776655447*G0_0_1_1_0 + 0.00221260221260234*G0_0_1_1_1 - 0.013916947250281*G0_0_1_1_2 - 0.00962000962000994*G0_0_1_1_3 - 0.00493827160493844*G0_0_1_1_4 - 0.00111592111592113*G0_0_1_1_5 - 0.00634920634920652*G0_0_1_2_0 - 0.013916947250281*G0_0_1_2_1 + 0.212698412698419*G0_0_1_2_2 + 0.0616321949655303*G0_0_1_2_3 + 0.0226390893057566*G0_0_1_2_4 + 0.00160333493666836*G0_0_1_2_5 - 0.00365560365560377*G0_0_1_3_0 - 0.00962000962000994*G0_0_1_3_1 + 0.0616321949655303*G0_0_1_3_2 + 0.0389931056597737*G0_0_1_3_3 + 0.0171877505210845*G0_0_1_3_4 + 0.00410453743787094*G0_0_1_3_5 - 0.00218053551386892*G0_0_1_4_0 - 0.00493827160493844*G0_0_1_4_1 + 0.0226390893057566*G0_0_1_4_2 + 0.0171877505210845*G0_0_1_4_3 + 0.0297578964245642*G0_0_1_4_4 + 0.00666987333654025*G0_0_1_4_5 - 0.00168029501362843*G0_0_1_5_0 - 0.00111592111592113*G0_0_1_5_1 + 0.00160333493666835*G0_0_1_5_2 + 0.00410453743787094*G0_0_1_5_3 + 0.00666987333654025*G0_0_1_5_4 - 0.000410453743787087*G0_0_1_5_5 + 0.031899951899953*G0_1_1_0_0 - 0.00297899631232975*G0_1_1_0_1 - 0.00520763187429868*G0_1_1_0_2 - 0.00164181497514836*G0_1_1_0_3 + 0.0105820105820109*G0_1_1_0_4 + 0.0166233766233772*G0_1_1_0_5 - 0.00297899631232975*G0_1_1_1_0 + 0.00247554914221593*G0_1_1_1_1 - 0.0108994708994712*G0_1_1_1_2 - 0.00947891614558313*G0_1_1_1_3 - 0.00556677890011241*G0_1_1_1_4 - 0.00699054032387388*G0_1_1_1_5 - 0.00520763187429868*G0_1_1_2_0 - 0.0108994708994712*G0_1_1_2_1 + 0.182202982202988*G0_1_1_2_2 + 0.0514349847683198*G0_1_1_2_3 + 0.00468173801507146*G0_1_1_2_4 - 0.00228314894981566*G0_1_1_2_5 - 0.00164181497514836*G0_1_1_3_0 - 0.00947891614558313*G0_1_1_3_1 + 0.0514349847683198*G0_1_1_3_2 + 0.0368895302228649*G0_1_1_3_3 + 0.0144171877505216*G0_1_1_3_4 + 0.00784992784992812*G0_1_1_3_5 + 0.0105820105820109*G0_1_1_4_0 - 0.00556677890011241*G0_1_1_4_1 + 0.00468173801507146*G0_1_1_4_2 + 0.0144171877505216*G0_1_1_4_3 + 0.0194452461119133*G0_1_1_4_4 + 0.0156998556998562*G0_1_1_4_5 + 0.0166233766233772*G0_1_1_5_0 - 0.00699054032387388*G0_1_1_5_1 - 0.00228314894981566*G0_1_1_5_2 + 0.00784992784992812*G0_1_1_5_3 + 0.0156998556998562*G0_1_1_5_4 + 0.0423280423280438*G0_1_1_5_5;
    A[7] = A[107] - 0.0304954304954318*G0_0_0_0_0 + 0.0030174763508098*G0_0_0_0_1 + 0.00114157447490786*G0_0_0_0_2 - 0.00388648388648401*G0_0_0_0_3 - 0.0179573512906853*G0_0_0_0_4 - 0.0101972101972106*G0_0_0_0_5 + 0.0030174763508098*G0_0_0_1_0 + 0.000262946929613591*G0_0_0_1_1 - 0.00407888407888422*G0_0_0_1_2 - 0.00587461920795273*G0_0_0_1_3 - 0.000628507295173978*G0_0_0_1_4 + 0.000141093474426823*G0_0_0_1_5 + 0.00114157447490786*G0_0_0_2_0 - 0.00407888407888422*G0_0_0_2_1 + 0.0327144460477805*G0_0_0_2_2 + 0.0183036716370056*G0_0_0_2_3 + 0.0127625460958799*G0_0_0_2_4 + 0.00201378868045542*G0_0_0_2_5 - 0.00388648388648401*G0_0_0_3_0 - 0.00587461920795273*G0_0_0_3_1 + 0.0183036716370056*G0_0_0_3_2 + 0.0427384960718309*G0_0_0_3_3 + 0.009029982363316*G0_0_0_3_4 + 0.00374539041205722*G0_0_0_3_5 - 0.0179573512906853*G0_0_0_4_0 - 0.000628507295173978*G0_0_0_4_1 + 0.0127625460958799*G0_0_0_4_2 + 0.009029982363316*G0_0_0_4_3 - 0.0103126503126507*G0_0_0_4_4 - 0.00277056277056288*G0_0_0_4_5 - 0.0101972101972106*G0_0_0_5_0 + 0.000141093474426823*G0_0_0_5_1 + 0.00201378868045542*G0_0_0_5_2 + 0.00374539041205722*G0_0_0_5_3 - 0.00277056277056288*G0_0_0_5_4 - 0.00210357543690887*G0_0_0_5_5 + 0.183017476350816*G0_0_1_0_0 - 0.0119993586660257*G0_0_1_0_1 + 0.0011415744749078*G0_0_1_0_2 + 0.00137245470578806*G0_0_1_0_3 + 0.00686227352894043*G0_0_1_0_4 + 0.0531152797819483*G0_0_1_0_5 - 0.0119993586660257*G0_0_1_1_0 + 0.000262946929613543*G0_0_1_1_1 + 0.0109379509379513*G0_0_1_1_2 + 0.00262946929613605*G0_0_1_1_3 - 0.000628507295173976*G0_0_1_1_4 - 0.00836299502966201*G0_0_1_1_5 + 0.0011415744749078*G0_0_1_2_0 + 0.0109379509379513*G0_0_1_2_1 - 0.180798460798466*G0_0_1_2_2 - 0.0450088183421532*G0_0_1_2_3 - 0.0120570787237457*G0_0_1_2_4 - 0.00324514991181672*G0_0_1_2_5 + 0.00137245470578806*G0_0_1_3_0 + 0.00262946929613605*G0_0_1_3_1 - 0.0450088183421532*G0_0_1_3_2 + 0.00333493666827008*G0_0_1_3_3 - 0.00148789482122822*G0_0_1_3_4 + 0.0037453904120572*G0_0_1_3_5 + 0.00686227352894043*G0_0_1_4_0 - 0.000628507295173976*G0_0_1_4_1 - 0.0120570787237457*G0_0_1_4_2 - 0.00148789482122822*G0_0_1_4_3 - 0.0103126503126507*G0_0_1_4_4 + 0.00774731441398133*G0_0_1_4_5 + 0.0531152797819483*G0_0_1_5_0 - 0.00836299502966201*G0_0_1_5_1 - 0.00324514991181672*G0_0_1_5_2 + 0.0037453904120572*G0_0_1_5_3 + 0.00774731441398133*G0_0_1_5_4 + 0.037299983966652*G0_0_1_5_5 - 0.0304954304954318*G0_1_0_0_0 + 0.0030174763508098*G0_1_0_0_1 + 0.00114157447490786*G0_1_0_0_2 - 0.00388648388648401*G0_1_0_0_3 - 0.0179573512906853*G0_1_0_0_4 - 0.0101972101972106*G0_1_0_0_5 + 0.0030174763508098*G0_1_0_1_0 + 0.000262946929613593*G0_1_0_1_1 - 0.00407888407888423*G0_1_0_1_2 - 0.00587461920795273*G0_1_0_1_3 - 0.00062850729517398*G0_1_0_1_4 + 0.000141093474426823*G0_1_0_1_5 + 0.00114157447490786*G0_1_0_2_0 - 0.00407888407888423*G0_1_0_2_1 + 0.0327144460477806*G0_1_0_2_2 + 0.0183036716370056*G0_1_0_2_3 + 0.0127625460958799*G0_1_0_2_4 + 0.00201378868045543*G0_1_0_2_5 - 0.00388648388648401*G0_1_0_3_0 - 0.00587461920795273*G0_1_0_3_1 + 0.0183036716370056*G0_1_0_3_2 + 0.0427384960718309*G0_1_0_3_3 + 0.00902998236331601*G0_1_0_3_4 + 0.00374539041205722*G0_1_0_3_5 - 0.0179573512906853*G0_1_0_4_0 - 0.000628507295173979*G0_1_0_4_1 + 0.0127625460958799*G0_1_0_4_2 + 0.00902998236331601*G0_1_0_4_3 - 0.0103126503126507*G0_1_0_4_4 - 0.00277056277056288*G0_1_0_4_5 - 0.0101972101972106*G0_1_0_5_0 + 0.000141093474426823*G0_1_0_5_1 + 0.00201378868045543*G0_1_0_5_2 + 0.00374539041205722*G0_1_0_5_3 - 0.00277056277056288*G0_1_0_5_4 - 0.00210357543690886*G0_1_0_5_5 + 0.150303030303035*G0_1_1_0_0 - 0.00792047458714152*G0_1_1_0_1 - 0.000641333974667356*G0_1_1_0_3 - 0.00590027256693939*G0_1_1_0_4 + 0.0348116081449427*G0_1_1_0_5 - 0.00792047458714152*G0_1_1_1_0 + 0.0079204745871415*G0_1_1_1_2 + 0.00248837582170923*G0_1_1_1_3 - 0.00248837582170926*G0_1_1_1_5 + 0.00792047458714149*G0_1_1_2_1 - 0.150303030303035*G0_1_1_2_2 - 0.0348116081449426*G0_1_1_2_3 + 0.00590027256693949*G0_1_1_2_4 + 0.000641333974667292*G0_1_1_2_5 - 0.000641333974667357*G0_1_1_3_0 + 0.00248837582170923*G0_1_1_3_1 - 0.0348116081449426*G0_1_1_3_2 + 0.00543851210517897*G0_1_1_3_3 + 0.0012826679493347*G0_1_1_3_4 - 0.0059002725669394*G0_1_1_4_0 + 0.00590027256693949*G0_1_1_4_2 + 0.0012826679493347*G0_1_1_4_3 - 0.00128266794933459*G0_1_1_4_5 + 0.0348116081449427*G0_1_1_5_0 - 0.00248837582170926*G0_1_1_5_1 + 0.000641333974667291*G0_1_1_5_2 - 0.00128266794933459*G0_1_1_5_4 - 0.00543851210517891*G0_1_1_5_5;
    A[182] = -A[212] + 0.00410453743787095*G0_0_1_0_0 - 0.00046176046176048*G0_0_1_0_1 - 0.00800384800384825*G0_0_1_0_2 + 0.000615680615680621*G0_0_1_0_3 + 0.00584896584896601*G0_0_1_0_4 + 0.00410453743787091*G0_0_1_0_5 - 0.00046176046176048*G0_0_1_1_0 - 0.00092352092352101*G0_0_1_1_1 + 0.00482283148949835*G0_0_1_1_2 + 0.00749078082411443*G0_0_1_1_3 + 0.000923520923520937*G0_0_1_1_5 - 0.00800384800384825*G0_0_1_2_0 + 0.00482283148949835*G0_0_1_2_1 - 0.0261664261664272*G0_0_1_2_3 + 0.026166426166427*G0_0_1_2_4 + 0.00318101651434993*G0_0_1_2_5 + 0.000615680615680622*G0_0_1_3_0 + 0.00749078082411443*G0_0_1_3_1 - 0.0261664261664272*G0_0_1_3_2 - 0.00697771364438055*G0_0_1_3_3 - 0.00123136123136127*G0_0_1_3_4 - 0.00759339426006111*G0_0_1_3_5 + 0.00584896584896601*G0_0_1_4_0 + 0.026166426166427*G0_0_1_4_2 - 0.00123136123136127*G0_0_1_4_3 + 0.00944043610710277*G0_0_1_4_4 - 0.00636203302869988*G0_0_1_4_5 + 0.00410453743787091*G0_0_1_5_0 + 0.000923520923520937*G0_0_1_5_1 + 0.00318101651434993*G0_0_1_5_2 - 0.00759339426006111*G0_0_1_5_3 - 0.00636203302869988*G0_0_1_5_4 - 0.0123136123136125*G0_0_1_5_5 - 0.0124162257495595*G0_1_1_0_0 - 0.000666987333654025*G0_1_1_0_1 + 0.0063620330286999*G0_1_1_0_2 + 0.000513067179733855*G0_1_1_0_3 + 0.00266794933461608*G0_1_1_0_4 - 0.0173416706750046*G0_1_1_0_5 - 0.000666987333654025*G0_1_1_1_0 + 0.0110822510822515*G0_1_1_1_1 + 0.00969696969697001*G0_1_1_1_2 + 0.0116979316979321*G0_1_1_1_3 + 0.000615680615680641*G0_1_1_1_4 + 0.0149815616482289*G0_1_1_1_5 + 0.0063620330286999*G0_1_1_2_0 + 0.00969696969697002*G0_1_1_2_1 - 0.0887606220939584*G0_1_1_2_2 - 0.0499727433060783*G0_1_1_2_3 - 0.0275004008337351*G0_1_1_2_4 - 0.00502805836139188*G0_1_1_2_5 + 0.000513067179733855*G0_1_1_3_0 + 0.0116979316979321*G0_1_1_3_1 - 0.0499727433060784*G0_1_1_3_2 - 0.0119031585698256*G0_1_1_3_3 - 0.002257495590829*G0_1_1_3_4 + 0.00902998236331601*G0_1_1_3_5 + 0.00266794933461608*G0_1_1_4_0 + 0.000615680615680642*G0_1_1_4_1 - 0.0275004008337351*G0_1_1_4_2 - 0.002257495590829*G0_1_1_4_3 + 0.00410453743787088*G0_1_1_4_4 + 0.00882475549142243*G0_1_1_4_5 - 0.0173416706750046*G0_1_1_5_0 + 0.0149815616482289*G0_1_1_5_1 - 0.00502805836139187*G0_1_1_5_2 + 0.00902998236331601*G0_1_1_5_3 + 0.00882475549142243*G0_1_1_5_4 + 0.00533589866923213*G0_1_1_5_5;
    A[198] = A[89] - 0.0238063171396512*G0_0_0_0_0 + 0.0172390572390578*G0_0_0_0_1 + 0.0287317620650963*G0_0_0_0_2 + 0.0525380792047476*G0_0_0_0_3 + 0.0673144139810829*G0_0_0_0_4 + 0.0205226871893546*G0_0_0_0_5 + 0.0172390572390578*G0_0_0_1_0 - 0.220003206669881*G0_0_0_1_1 + 0.0311944845278188*G0_0_0_1_2 - 0.320153920153932*G0_0_0_1_3 + 0.0131345198011868*G0_0_0_1_4 - 0.0632098765432122*G0_0_0_1_5 + 0.0287317620650963*G0_0_0_2_0 + 0.0311944845278188*G0_0_0_2_1 - 0.0566426166426174*G0_0_0_2_2 + 0.247914061247404*G0_0_0_2_3 - 0.169106942440281*G0_0_0_2_4 + 0.0262690396023739*G0_0_0_2_5 + 0.0525380792047476*G0_0_0_3_0 - 0.320153920153932*G0_0_0_3_1 + 0.247914061247404*G0_0_0_3_2 - 0.630456950456972*G0_0_0_3_3 - 0.131345198011869*G0_0_0_3_4 - 0.157614237614243*G0_0_0_3_5 + 0.0673144139810829*G0_0_0_4_0 + 0.0131345198011868*G0_0_0_4_1 - 0.169106942440281*G0_0_0_4_2 - 0.131345198011869*G0_0_0_4_3 - 0.604187910854597*G0_0_0_4_4 - 0.0788071188071216*G0_0_0_4_5 + 0.0205226871893546*G0_0_0_5_0 - 0.0632098765432122*G0_0_0_5_1 + 0.0262690396023739*G0_0_0_5_2 - 0.157614237614243*G0_0_0_5_3 - 0.0788071188071216*G0_0_0_5_4 - 0.0722398589065283*G0_0_0_5_5 + 0.0283213083213093*G0_0_1_0_1 - 0.0283213083213092*G0_0_1_0_2 - 0.0127240660573998*G0_0_1_0_4 + 0.0127240660573998*G0_0_1_0_5 + 0.0283213083213093*G0_0_1_1_0 - 0.315228475228486*G0_0_1_1_1 - 0.295937149270493*G0_0_1_1_3 - 0.0320153920153931*G0_0_1_1_4 - 0.0939939073272443*G0_0_1_1_5 - 0.0283213083213092*G0_0_1_2_0 + 0.315228475228486*G0_0_1_2_2 + 0.295937149270493*G0_0_1_2_3 + 0.0939939073272439*G0_0_1_2_4 + 0.0320153920153933*G0_0_1_2_5 - 0.295937149270493*G0_0_1_3_1 + 0.295937149270493*G0_0_1_3_2 + 0.0640307840307862*G0_0_1_3_4 - 0.0640307840307864*G0_0_1_3_5 - 0.0127240660573998*G0_0_1_4_0 - 0.0320153920153931*G0_0_1_4_1 + 0.0939939073272439*G0_0_1_4_2 + 0.0640307840307862*G0_0_1_4_3 + 0.0492544492544508*G0_0_1_4_4 + 0.0127240660573998*G0_0_1_5_0 - 0.0939939073272443*G0_0_1_5_1 + 0.0320153920153933*G0_0_1_5_2 - 0.0640307840307864*G0_0_1_5_3 - 0.0492544492544517*G0_0_1_5_5 + 0.0102613435946773*G0_1_0_0_1 - 0.0102613435946772*G0_1_0_0_2 + 0.0102613435946774*G0_1_0_0_4 - 0.0102613435946772*G0_1_0_0_5 + 0.0102613435946773*G0_1_0_1_0 - 0.12559884559885*G0_1_0_1_1 - 0.355042488375834*G0_1_0_1_3 - 0.0188808722142062*G0_1_0_1_4 - 0.0119031585698259*G0_1_0_1_5 - 0.0102613435946772*G0_1_0_2_0 + 0.12559884559885*G0_1_0_2_2 + 0.355042488375835*G0_1_0_2_3 + 0.0119031585698255*G0_1_0_2_4 + 0.0188808722142063*G0_1_0_2_5 - 0.355042488375834*G0_1_0_3_1 + 0.355042488375835*G0_1_0_3_2 + 0.0377617444284123*G0_1_0_3_4 - 0.0377617444284126*G0_1_0_3_5 + 0.0102613435946774*G0_1_0_4_0 - 0.0188808722142062*G0_1_0_4_1 + 0.0119031585698255*G0_1_0_4_2 + 0.0377617444284124*G0_1_0_4_3 - 0.0952252685586061*G0_1_0_4_4 - 0.0102613435946772*G0_1_0_5_0 - 0.0119031585698259*G0_1_0_5_1 + 0.0188808722142063*G0_1_0_5_2 - 0.0377617444284125*G0_1_0_5_3 + 0.095225268558605*G0_1_0_5_5 + 0.0238063171396512*G0_1_1_0_0 - 0.0287317620650964*G0_1_1_0_1 - 0.0172390572390578*G0_1_1_0_2 - 0.0525380792047475*G0_1_1_0_3 - 0.0205226871893545*G0_1_1_0_4 - 0.0673144139810828*G0_1_1_0_5 - 0.0287317620650964*G0_1_1_1_0 + 0.0566426166426195*G0_1_1_1_1 - 0.031194484527819*G0_1_1_1_2 - 0.247914061247403*G0_1_1_1_3 - 0.0262690396023739*G0_1_1_1_4 + 0.169106942440282*G0_1_1_1_5 - 0.0172390572390578*G0_1_1_2_0 - 0.031194484527819*G0_1_1_2_1 + 0.220003206669881*G0_1_1_2_2 + 0.320153920153932*G0_1_1_2_3 + 0.0632098765432121*G0_1_1_2_4 - 0.0131345198011868*G0_1_1_2_5 - 0.0525380792047475*G0_1_1_3_0 - 0.247914061247403*G0_1_1_3_1 + 0.320153920153932*G0_1_1_3_2 + 0.630456950456973*G0_1_1_3_3 + 0.157614237614243*G0_1_1_3_4 + 0.131345198011869*G0_1_1_3_5 - 0.0205226871893545*G0_1_1_4_0 - 0.0262690396023739*G0_1_1_4_1 + 0.0632098765432121*G0_1_1_4_2 + 0.157614237614243*G0_1_1_4_3 + 0.0722398589065279*G0_1_1_4_4 + 0.0788071188071213*G0_1_1_4_5 - 0.0673144139810828*G0_1_1_5_0 + 0.169106942440282*G0_1_1_5_1 - 0.0131345198011868*G0_1_1_5_2 + 0.131345198011869*G0_1_1_5_3 + 0.0788071188071213*G0_1_1_5_4 + 0.604187910854597*G0_1_1_5_5;
    A[32] = 0.00441718775052123*G0_1_1_0_0 - 0.000244508577841925*G0_1_1_0_1 - 0.00916973972529557*G0_1_1_0_2 - 0.00298754743199197*G0_1_1_0_3 - 0.00389075944631513*G0_1_1_0_4 + 0.00094062316284542*G0_1_1_0_5 - 0.000244508577841925*G0_1_1_1_0 + 0.00441718775052127*G0_1_1_1_1 - 0.00916973972529557*G0_1_1_1_2 - 0.00389075944631513*G0_1_1_1_3 - 0.00298754743199197*G0_1_1_1_4 + 0.000940623162845434*G0_1_1_1_5 - 0.00916973972529557*G0_1_1_2_0 - 0.00916973972529557*G0_1_1_2_1 + 0.168726952060291*G0_1_1_2_2 + 0.0375821709155055*G0_1_1_2_3 + 0.0375821709155055*G0_1_1_2_4 + 0.000903212014323184*G0_1_1_2_5 - 0.00298754743199197*G0_1_1_3_0 - 0.00389075944631513*G0_1_1_3_1 + 0.0375821709155055*G0_1_1_3_2 + 0.0239003794559358*G0_1_1_3_3 + 0.0119501897279679*G0_1_1_3_4 + 0.00416867083533765*G0_1_1_3_5 - 0.00389075944631513*G0_1_1_4_0 - 0.00298754743199197*G0_1_1_4_1 + 0.0375821709155055*G0_1_1_4_2 + 0.0119501897279679*G0_1_1_4_3 + 0.0239003794559358*G0_1_1_4_4 + 0.00416867083533764*G0_1_1_4_5 + 0.00094062316284542*G0_1_1_5_0 + 0.000940623162845434*G0_1_1_5_1 + 0.000903212014323184*G0_1_1_5_2 + 0.00416867083533765*G0_1_1_5_3 + 0.00416867083533764*G0_1_1_5_4 + 0.0158623269734387*G0_1_1_5_5;
    A[25] = 0.0318999518999531*G0_0_0_0_0 - 0.00520763187429871*G0_0_0_0_1 - 0.00297899631232975*G0_0_0_0_2 - 0.00164181497514837*G0_0_0_0_3 + 0.0166233766233772*G0_0_0_0_4 + 0.0105820105820109*G0_0_0_0_5 - 0.00520763187429871*G0_0_0_1_0 + 0.182202982202989*G0_0_0_1_1 - 0.0108994708994713*G0_0_0_1_2 + 0.0514349847683199*G0_0_0_1_3 - 0.00228314894981571*G0_0_0_1_4 + 0.00468173801507162*G0_0_0_1_5 - 0.00297899631232975*G0_0_0_2_0 - 0.0108994708994713*G0_0_0_2_1 + 0.00247554914221591*G0_0_0_2_2 - 0.00947891614558313*G0_0_0_2_3 - 0.00699054032387388*G0_0_0_2_4 - 0.00556677890011243*G0_0_0_2_5 - 0.00164181497514837*G0_0_0_3_0 + 0.0514349847683199*G0_0_0_3_1 - 0.00947891614558313*G0_0_0_3_2 + 0.0368895302228648*G0_0_0_3_3 + 0.0078499278499281*G0_0_0_3_4 + 0.0144171877505216*G0_0_0_3_5 + 0.0166233766233772*G0_0_0_4_0 - 0.00228314894981571*G0_0_0_4_1 - 0.00699054032387389*G0_0_0_4_2 + 0.0078499278499281*G0_0_0_4_3 + 0.0423280423280436*G0_0_0_4_4 + 0.0156998556998562*G0_0_0_4_5 + 0.0105820105820109*G0_0_0_5_0 + 0.00468173801507162*G0_0_0_5_1 - 0.00556677890011243*G0_0_0_5_2 + 0.0144171877505216*G0_0_0_5_3 + 0.0156998556998562*G0_0_0_5_4 + 0.0194452461119135*G0_0_0_5_5 - 0.000814494147827487*G0_0_1_0_0 - 0.00634920634920656*G0_0_1_0_1 + 0.00109988776655447*G0_0_1_0_2 - 0.00365560365560378*G0_0_1_0_3 - 0.00168029501362839*G0_0_1_0_4 - 0.00218053551386894*G0_0_1_0_5 - 0.00634920634920656*G0_0_1_1_0 + 0.21269841269842*G0_0_1_1_1 - 0.0139169472502811*G0_0_1_1_2 + 0.0616321949655304*G0_0_1_1_3 + 0.0016033349366683*G0_0_1_1_4 + 0.0226390893057569*G0_0_1_1_5 + 0.00109988776655447*G0_0_1_2_0 - 0.0139169472502811*G0_0_1_2_1 + 0.00221260221260228*G0_0_1_2_2 - 0.00962000962000994*G0_0_1_2_3 - 0.00111592111592116*G0_0_1_2_4 - 0.00493827160493846*G0_0_1_2_5 - 0.00365560365560378*G0_0_1_3_0 + 0.0616321949655304*G0_0_1_3_1 - 0.00962000962000994*G0_0_1_3_2 + 0.0389931056597736*G0_0_1_3_3 + 0.00410453743787091*G0_0_1_3_4 + 0.0171877505210845*G0_0_1_3_5 - 0.00168029501362839*G0_0_1_4_0 + 0.00160333493666831*G0_0_1_4_1 - 0.00111592111592116*G0_0_1_4_2 + 0.00410453743787091*G0_0_1_4_3 - 0.000410453743787132*G0_0_1_4_4 + 0.00666987333654024*G0_0_1_4_5 - 0.00218053551386894*G0_0_1_5_0 + 0.0226390893057569*G0_0_1_5_1 - 0.00493827160493846*G0_0_1_5_2 + 0.0171877505210845*G0_0_1_5_3 + 0.00666987333654024*G0_0_1_5_4 + 0.0297578964245642*G0_0_1_5_5;
    A[61] = 0.0002629469296136*G0_0_0_0_0 + 0.00301747635080977*G0_0_0_0_1 - 0.00407888407888421*G0_0_0_0_2 - 0.000628507295173977*G0_0_0_0_3 - 0.00587461920795272*G0_0_0_0_4 + 0.000141093474426812*G0_0_0_0_5 + 0.00301747635080977*G0_0_0_1_0 - 0.0304954304954314*G0_0_0_1_1 + 0.00114157447490785*G0_0_0_1_2 - 0.0179573512906852*G0_0_0_1_3 - 0.00388648388648401*G0_0_0_1_4 - 0.0101972101972105*G0_0_0_1_5 - 0.00407888407888421*G0_0_0_2_0 + 0.00114157447490785*G0_0_0_2_1 + 0.0327144460477804*G0_0_0_2_2 + 0.0127625460958799*G0_0_0_2_3 + 0.0183036716370056*G0_0_0_2_4 + 0.00201378868045542*G0_0_0_2_5 - 0.000628507295173977*G0_0_0_3_0 - 0.0179573512906852*G0_0_0_3_1 + 0.0127625460958799*G0_0_0_3_2 - 0.0103126503126508*G0_0_0_3_3 + 0.00902998236331598*G0_0_0_3_4 - 0.00277056277056288*G0_0_0_3_5 - 0.00587461920795272*G0_0_0_4_0 - 0.00388648388648401*G0_0_0_4_1 + 0.0183036716370056*G0_0_0_4_2 + 0.00902998236331598*G0_0_0_4_3 + 0.0427384960718308*G0_0_0_4_4 + 0.00374539041205721*G0_0_0_4_5 + 0.000141093474426812*G0_0_0_5_0 - 0.0101972101972105*G0_0_0_5_1 + 0.00201378868045542*G0_0_0_5_2 - 0.00277056277056288*G0_0_0_5_3 + 0.00374539041205721*G0_0_0_5_4 - 0.00210357543690882*G0_0_0_5_5 - 0.0022126022126023*G0_1_0_0_0 + 0.0139169472502811*G0_1_0_0_1 - 0.00109988776655447*G0_1_0_0_2 + 0.00493827160493844*G0_1_0_0_3 + 0.00111592111592116*G0_1_0_0_4 + 0.00962000962000997*G0_1_0_0_5 + 0.0139169472502811*G0_1_0_1_0 - 0.212698412698421*G0_1_0_1_1 + 0.0063492063492066*G0_1_0_1_2 - 0.0226390893057569*G0_1_0_1_3 - 0.0016033349366683*G0_1_0_1_4 - 0.0616321949655308*G0_1_0_1_5 - 0.00109988776655447*G0_1_0_2_0 + 0.0063492063492066*G0_1_0_2_1 + 0.000814494147827494*G0_1_0_2_2 + 0.00218053551386894*G0_1_0_2_3 + 0.0016802950136284*G0_1_0_2_4 + 0.00365560365560379*G0_1_0_2_5 + 0.00493827160493844*G0_1_0_3_0 - 0.0226390893057569*G0_1_0_3_1 + 0.00218053551386894*G0_1_0_3_2 - 0.0297578964245642*G0_1_0_3_3 - 0.00666987333654023*G0_1_0_3_4 - 0.0171877505210845*G0_1_0_3_5 + 0.00111592111592116*G0_1_0_4_0 - 0.0016033349366683*G0_1_0_4_1 + 0.0016802950136284*G0_1_0_4_2 - 0.00666987333654023*G0_1_0_4_3 + 0.000410453743787149*G0_1_0_4_4 - 0.00410453743787091*G0_1_0_4_5 + 0.00962000962000997*G0_1_0_5_0 - 0.0616321949655308*G0_1_0_5_1 + 0.00365560365560379*G0_1_0_5_2 - 0.0171877505210845*G0_1_0_5_3 - 0.00410453743787091*G0_1_0_5_4 - 0.0389931056597738*G0_1_0_5_5;
    A[154] = A[70] - 0.000846560846561003*G0_0_1_0_0 - 0.00715728715728742*G0_0_1_0_1 - 0.00142376142376149*G0_0_1_0_2 + 0.00831168831168858*G0_0_1_0_3 + 0.00461760461760478*G0_0_1_0_4 - 0.011544011544012*G0_0_1_0_5 - 0.00715728715728742*G0_0_1_1_0 - 0.0988936988937028*G0_0_1_1_1 - 0.00715728715728741*G0_0_1_1_2 + 0.0484848484848502*G0_0_1_1_3 + 0.00354016354016369*G0_0_1_1_4 + 0.0484848484848501*G0_0_1_1_5 - 0.00142376142376149*G0_0_1_2_0 - 0.0071572871572874*G0_0_1_2_1 - 0.000846560846560787*G0_0_1_2_2 - 0.011544011544012*G0_0_1_2_3 + 0.00461760461760484*G0_0_1_2_4 + 0.00831168831168855*G0_0_1_2_5 + 0.00831168831168857*G0_0_1_3_0 + 0.0484848484848502*G0_0_1_3_1 - 0.011544011544012*G0_0_1_3_2 + 0.0455603655603674*G0_0_1_3_3 - 0.0237037037037045*G0_0_1_3_4 - 0.0332467532467543*G0_0_1_3_5 + 0.00461760461760478*G0_0_1_4_0 + 0.00354016354016369*G0_0_1_4_1 + 0.00461760461760484*G0_0_1_4_2 - 0.0237037037037045*G0_0_1_4_3 - 0.0043097643097641*G0_0_1_4_4 - 0.0237037037037045*G0_0_1_4_5 - 0.011544011544012*G0_0_1_5_0 + 0.0484848484848501*G0_0_1_5_1 + 0.00831168831168855*G0_0_1_5_2 - 0.0332467532467543*G0_0_1_5_3 - 0.0237037037037045*G0_0_1_5_4 + 0.045560365560368*G0_0_1_5_5 + 0.000846560846561002*G0_1_0_0_0 + 0.00715728715728742*G0_1_0_0_1 + 0.00142376142376149*G0_1_0_0_2 - 0.00831168831168857*G0_1_0_0_3 - 0.00461760461760478*G0_1_0_0_4 + 0.011544011544012*G0_1_0_0_5 + 0.00715728715728742*G0_1_0_1_0 + 0.0988936988937028*G0_1_0_1_1 + 0.00715728715728741*G0_1_0_1_2 - 0.0484848484848502*G0_1_0_1_3 - 0.00354016354016369*G0_1_0_1_4 - 0.0484848484848502*G0_1_0_1_5 + 0.00142376142376149*G0_1_0_2_0 + 0.00715728715728741*G0_1_0_2_1 + 0.000846560846560787*G0_1_0_2_2 + 0.011544011544012*G0_1_0_2_3 - 0.00461760461760484*G0_1_0_2_4 - 0.00831168831168855*G0_1_0_2_5 - 0.00831168831168857*G0_1_0_3_0 - 0.0484848484848502*G0_1_0_3_1 + 0.011544011544012*G0_1_0_3_2 - 0.0455603655603674*G0_1_0_3_3 + 0.0237037037037045*G0_1_0_3_4 + 0.0332467532467542*G0_1_0_3_5 - 0.00461760461760478*G0_1_0_4_0 - 0.00354016354016369*G0_1_0_4_1 - 0.00461760461760484*G0_1_0_4_2 + 0.0237037037037045*G0_1_0_4_3 + 0.0043097643097641*G0_1_0_4_4 + 0.0237037037037045*G0_1_0_4_5 + 0.011544011544012*G0_1_0_5_0 - 0.0484848484848501*G0_1_0_5_1 - 0.00831168831168855*G0_1_0_5_2 + 0.0332467532467543*G0_1_0_5_3 + 0.0237037037037045*G0_1_0_5_4 - 0.045560365560368*G0_1_0_5_5;
    A[106] = -0.00246913580246924*G0_0_0_0_0 - 0.000298220298220291*G0_0_0_0_1 - 0.0011287477954145*G0_0_0_0_2 + 0.00119288119288124*G0_0_0_0_3 - 0.0030014430014431*G0_0_0_0_4 + 0.00185986852653527*G0_0_0_0_5 - 0.000298220298220291*G0_0_0_1_0 - 0.00311046977713685*G0_0_0_1_1 - 0.000346320346320352*G0_0_0_1_2 - 0.00148789482122821*G0_0_0_1_3 + 0.000243706910373591*G0_0_0_1_4 - 0.000115440115440203*G0_0_0_1_5 - 0.0011287477954145*G0_0_0_2_0 - 0.000346320346320352*G0_0_0_2_1 - 0.00942119608786303*G0_0_0_2_2 + 0.00406605739939086*G0_0_0_2_3 + 0.00776014109347471*G0_0_0_2_4 + 0.000551547218213905*G0_0_0_2_5 + 0.00119288119288124*G0_0_0_3_0 - 0.00148789482122821*G0_0_0_3_1 + 0.00406605739939086*G0_0_0_3_2 - 0.00220618887285565*G0_0_0_3_3 - 0.00287317620650965*G0_0_0_3_4 - 0.00348885682219028*G0_0_0_3_5 - 0.0030014430014431*G0_0_0_4_0 + 0.00024370691037359*G0_0_0_4_1 + 0.00776014109347471*G0_0_0_4_2 - 0.00287317620650965*G0_0_0_4_3 + 0.058438351771687*G0_0_0_4_4 - 0.00159050825717498*G0_0_0_4_5 + 0.00185986852653527*G0_0_0_5_0 - 0.000115440115440203*G0_0_0_5_1 + 0.000551547218213905*G0_0_0_5_2 - 0.00348885682219028*G0_0_0_5_3 - 0.00159050825717499*G0_0_0_5_4 - 0.00159050825717502*G0_0_0_5_5 + 0.00695206028539392*G0_1_0_0_0 + 4.81000481000647e-05*G0_1_0_0_1 + 0.000641333974667333*G0_1_0_0_3 - 0.0107615840949178*G0_1_0_0_4 - 0.00220618887285559*G0_1_0_0_5 + 4.81000481000647e-05*G0_1_0_1_0 - 4.81000481000407e-05*G0_1_0_1_2 - 0.00137245470578811*G0_1_0_1_3 + 0.00137245470578801*G0_1_0_1_5 - 4.81000481000405e-05*G0_1_0_2_1 - 0.00695206028539381*G0_1_0_2_2 + 0.0022061888728556*G0_1_0_2_3 + 0.0107615840949178*G0_1_0_2_4 - 0.000641333974667333*G0_1_0_2_5 + 0.000641333974667333*G0_1_0_3_0 - 0.00137245470578811*G0_1_0_3_1 + 0.0022061888728556*G0_1_0_3_2 - 0.000615680615680659*G0_1_0_3_3 - 0.00128266794933465*G0_1_0_3_4 - 0.0107615840949178*G0_1_0_4_0 + 0.0107615840949178*G0_1_0_4_2 - 0.00128266794933465*G0_1_0_4_3 + 0.00128266794933468*G0_1_0_4_5 - 0.00220618887285559*G0_1_0_5_0 + 0.00137245470578801*G0_1_0_5_1 - 0.000641333974667333*G0_1_0_5_2 + 0.00128266794933468*G0_1_0_5_4 + 0.000615680615680605*G0_1_0_5_5;
    A[60] = A[106] - 0.00064133397466745*G0_0_0_0_0 + 0.00078242744909415*G0_0_0_0_2 - 0.000949174282507639*G0_0_0_0_3 + 0.00151354818021488*G0_0_0_0_4 - 0.00197530864197544*G0_0_0_0_5 + 0.000641333974667637*G0_0_0_1_1 - 0.000782427449094153*G0_0_0_1_2 - 0.0015135481802149*G0_0_0_1_3 + 0.000949174282507645*G0_0_0_1_4 + 0.00197530864197546*G0_0_0_1_5 + 0.00078242744909415*G0_0_0_2_0 - 0.000782427449094153*G0_0_0_2_1 + 0.00369408369408386*G0_0_0_2_3 - 0.00369408369408384*G0_0_0_2_4 - 0.000949174282507639*G0_0_0_3_0 - 0.0015135481802149*G0_0_0_3_1 + 0.00369408369408386*G0_0_0_3_2 + 0.0606445406445427*G0_0_0_3_3 + 0.00189834856501531*G0_0_0_3_5 + 0.00151354818021488*G0_0_0_4_0 + 0.000949174282507645*G0_0_0_4_1 - 0.00369408369408384*G0_0_0_4_2 - 0.0606445406445426*G0_0_0_4_4 - 0.00189834856501529*G0_0_0_4_5 - 0.00197530864197544*G0_0_0_5_0 + 0.00197530864197546*G0_0_0_5_1 + 0.00189834856501531*G0_0_0_5_3 - 0.00189834856501529*G0_0_0_5_4 - 0.00311046977713669*G0_0_1_0_0 - 0.000298220298220297*G0_0_1_0_1 - 0.000346320346320343*G0_0_1_0_2 + 0.000243706910373602*G0_0_1_0_3 - 0.00148789482122821*G0_0_1_0_4 - 0.000115440115440167*G0_0_1_0_5 - 0.000298220298220297*G0_0_1_1_0 - 0.0024691358024692*G0_0_1_1_1 - 0.0011287477954145*G0_0_1_1_2 - 0.0030014430014431*G0_0_1_1_3 + 0.00119288119288124*G0_0_1_1_4 + 0.00185986852653526*G0_0_1_1_5 - 0.000346320346320343*G0_0_1_2_0 - 0.0011287477954145*G0_0_1_2_1 - 0.00942119608786319*G0_0_1_2_2 + 0.00776014109347469*G0_0_1_2_3 + 0.00406605739939082*G0_0_1_2_4 + 0.000551547218213904*G0_0_1_2_5 + 0.000243706910373602*G0_0_1_3_0 - 0.0030014430014431*G0_0_1_3_1 + 0.00776014109347469*G0_0_1_3_2 + 0.058438351771687*G0_0_1_3_3 - 0.00287317620650966*G0_0_1_3_4 - 0.00159050825717498*G0_0_1_3_5 - 0.00148789482122821*G0_0_1_4_0 + 0.00119288119288124*G0_0_1_4_1 + 0.00406605739939082*G0_0_1_4_2 - 0.00287317620650966*G0_0_1_4_3 - 0.0022061888728557*G0_0_1_4_4 - 0.00348885682219028*G0_0_1_4_5 - 0.000115440115440167*G0_0_1_5_0 + 0.00185986852653526*G0_0_1_5_1 + 0.000551547218213904*G0_0_1_5_2 - 0.00159050825717498*G0_0_1_5_3 - 0.00348885682219028*G0_0_1_5_4 - 0.00159050825717503*G0_0_1_5_5 - 0.0100625300625307*G0_1_0_0_0 - 0.000394420394420408*G0_1_0_0_1 - 0.000298220298220299*G0_1_0_0_2 - 0.000397627064293738*G0_1_0_0_3 + 0.0106461439794776*G0_1_0_0_4 + 0.000718294051627327*G0_1_0_0_5 - 0.000394420394420408*G0_1_0_1_0 - 0.00942119608786284*G0_1_0_1_1 - 0.00108064774731446*G0_1_0_1_2 + 0.00913259579926278*G0_1_0_1_3 + 0.000551547218213912*G0_1_0_1_4 + 0.00269360269360286*G0_1_0_1_5 - 0.000298220298220299*G0_1_0_2_0 - 0.00108064774731446*G0_1_0_2_1 + 0.00448292448292463*G0_1_0_2_2 - 0.00520763187429867*G0_1_0_2_3 - 0.00890171556838252*G0_1_0_2_4 + 0.00183421516754857*G0_1_0_2_5 - 0.000397627064293739*G0_1_0_3_0 + 0.00913259579926278*G0_1_0_3_1 - 0.00520763187429867*G0_1_0_3_2 + 0.0590540323873678*G0_1_0_3_3 - 0.000307840307840327*G0_1_0_3_4 - 0.00287317620650963*G0_1_0_3_5 + 0.0106461439794776*G0_1_0_4_0 + 0.000551547218213912*G0_1_0_4_1 - 0.00890171556838252*G0_1_0_4_2 - 0.000307840307840328*G0_1_0_4_3 - 0.00159050825717513*G0_1_0_4_4 - 0.00477152477152497*G0_1_0_4_5 + 0.000718294051627328*G0_1_0_5_0 + 0.00269360269360286*G0_1_0_5_1 + 0.00183421516754857*G0_1_0_5_2 - 0.00287317620650963*G0_1_0_5_3 - 0.00477152477152497*G0_1_0_5_4 - 0.00282186948853623*G0_1_0_5_5 - 0.00311046977713677*G0_1_1_0_0 - 0.000346320346320337*G0_1_1_0_1 - 0.000298220298220301*G0_1_1_0_2 + 0.000243706910373598*G0_1_1_0_3 - 0.000115440115440142*G0_1_1_0_4 - 0.00148789482122827*G0_1_1_0_5 - 0.000346320346320337*G0_1_1_1_0 - 0.00942119608786312*G0_1_1_1_1 - 0.0011287477954145*G0_1_1_1_2 + 0.00776014109347466*G0_1_1_1_3 + 0.000551547218213908*G0_1_1_1_4 + 0.00406605739939085*G0_1_1_1_5 - 0.000298220298220301*G0_1_1_2_0 - 0.0011287477954145*G0_1_1_2_1 - 0.00246913580246926*G0_1_1_2_2 - 0.00300144300144309*G0_1_1_2_3 + 0.00185986852653525*G0_1_1_2_4 + 0.00119288119288124*G0_1_1_2_5 + 0.000243706910373598*G0_1_1_3_0 + 0.00776014109347466*G0_1_1_3_1 - 0.00300144300144309*G0_1_1_3_2 + 0.0584383517716871*G0_1_1_3_3 - 0.00159050825717499*G0_1_1_3_4 - 0.00287317620650965*G0_1_1_3_5 - 0.000115440115440142*G0_1_1_4_0 + 0.000551547218213908*G0_1_1_4_1 + 0.00185986852653525*G0_1_1_4_2 - 0.00159050825717499*G0_1_1_4_3 - 0.00159050825717504*G0_1_1_4_4 - 0.00348885682219029*G0_1_1_4_5 - 0.00148789482122827*G0_1_1_5_0 + 0.00406605739939085*G0_1_1_5_1 + 0.00119288119288124*G0_1_1_5_2 - 0.00287317620650964*G0_1_1_5_3 - 0.00348885682219029*G0_1_1_5_4 - 0.00220618887285567*G0_1_1_5_5;
    A[4] = A[60] + 0.00137245470578808*G0_0_1_0_4 - 0.00137245470578809*G0_0_1_0_5 - 0.00695206028539391*G0_0_1_1_1 + 0.0107615840949178*G0_0_1_1_3 - 0.000641333974667331*G0_0_1_1_4 + 0.00220618887285561*G0_0_1_1_5 + 0.00695206028539394*G0_0_1_2_2 - 0.0107615840949178*G0_0_1_2_3 - 0.00220618887285557*G0_0_1_2_4 + 0.000641333974667333*G0_0_1_2_5 + 0.0107615840949178*G0_0_1_3_1 - 0.0107615840949178*G0_0_1_3_2 + 0.00128266794933467*G0_0_1_3_4 - 0.00128266794933466*G0_0_1_3_5 + 0.00137245470578808*G0_0_1_4_0 - 0.000641333974667331*G0_0_1_4_1 - 0.00220618887285557*G0_0_1_4_2 + 0.00128266794933467*G0_0_1_4_3 + 0.000615680615680646*G0_0_1_4_4 - 0.00137245470578809*G0_0_1_5_0 + 0.00220618887285561*G0_0_1_5_1 + 0.000641333974667332*G0_0_1_5_2 - 0.00128266794933466*G0_0_1_5_3 - 0.000615680615680609*G0_0_1_5_5 - 0.00137245470578808*G0_1_0_0_4 + 0.00137245470578809*G0_1_0_0_5 + 0.00695206028539391*G0_1_0_1_1 - 0.0107615840949178*G0_1_0_1_3 + 0.000641333974667331*G0_1_0_1_4 - 0.00220618887285561*G0_1_0_1_5 - 0.00695206028539394*G0_1_0_2_2 + 0.0107615840949178*G0_1_0_2_3 + 0.00220618887285558*G0_1_0_2_4 - 0.000641333974667333*G0_1_0_2_5 - 0.0107615840949178*G0_1_0_3_1 + 0.0107615840949178*G0_1_0_3_2 - 0.00128266794933467*G0_1_0_3_4 + 0.00128266794933466*G0_1_0_3_5 - 0.00137245470578808*G0_1_0_4_0 + 0.000641333974667331*G0_1_0_4_1 + 0.00220618887285558*G0_1_0_4_2 - 0.00128266794933467*G0_1_0_4_3 - 0.000615680615680649*G0_1_0_4_4 + 0.00137245470578809*G0_1_0_5_0 - 0.00220618887285561*G0_1_0_5_1 - 0.000641333974667333*G0_1_0_5_2 + 0.00128266794933466*G0_1_0_5_3 + 0.000615680615680608*G0_1_0_5_5;
    A[15] = 0.0161696328363001*G0_0_0_0_0 - 0.000518678852012202*G0_0_0_0_1 - 0.00119742397520179*G0_0_0_0_2 - 3.95489284378203e-05*G0_0_0_0_3 + 0.00540430762653003*G0_0_0_0_4 + 0.000816631927743074*G0_0_0_0_5 - 0.000518678852012203*G0_0_0_1_0 + 0.0161696328363001*G0_0_0_1_1 - 0.00119742397520179*G0_0_0_1_2 + 0.00540430762653003*G0_0_0_1_3 - 3.95489284378203e-05*G0_0_0_1_4 + 0.000816631927743076*G0_0_0_1_5 - 0.00119742397520179*G0_0_0_2_0 - 0.00119742397520179*G0_0_0_2_1 - 1.76366843033533e-05*G0_0_0_2_2 - 0.000654160654160679*G0_0_0_2_3 - 0.000654160654160678*G0_0_0_2_4 - 0.00044145155256268*G0_0_0_2_5 - 3.95489284378203e-05*G0_0_0_3_0 + 0.00540430762653003*G0_0_0_3_1 - 0.000654160654160678*G0_0_0_3_2 + 0.0034461012238791*G0_0_0_3_3 + 0.000158195713751273*G0_0_0_3_4 + 0.000962000962000998*G0_0_0_3_5 + 0.00540430762653003*G0_0_0_4_0 - 3.95489284378203e-05*G0_0_0_4_1 - 0.000654160654160678*G0_0_0_4_2 + 0.000158195713751273*G0_0_0_4_3 + 0.0034461012238791*G0_0_0_4_4 + 0.000962000962000997*G0_0_0_4_5 + 0.000816631927743073*G0_0_0_5_0 + 0.000816631927743076*G0_0_0_5_1 - 0.00044145155256268*G0_0_0_5_2 + 0.000962000962000998*G0_0_0_5_3 + 0.000962000962000997*G0_0_0_5_4 - 0.00216343327454445*G0_0_0_5_5 + 0.0161696328363001*G0_0_1_0_0 - 0.000518678852012202*G0_0_1_0_1 - 0.00119742397520179*G0_0_1_0_2 - 3.95489284378197e-05*G0_0_1_0_3 + 0.00540430762653003*G0_0_1_0_4 + 0.000816631927743073*G0_0_1_0_5 - 0.000518678852012202*G0_0_1_1_0 + 0.0161696328363*G0_0_1_1_1 - 0.00119742397520179*G0_0_1_1_2 + 0.00540430762653002*G0_0_1_1_3 - 3.95489284378206e-05*G0_0_1_1_4 + 0.000816631927743075*G0_0_1_1_5 - 0.00119742397520179*G0_0_1_2_0 - 0.00119742397520179*G0_0_1_2_1 - 1.76366843033629e-05*G0_0_1_2_2 - 0.000654160654160677*G0_0_1_2_3 - 0.000654160654160679*G0_0_1_2_4 - 0.00044145155256268*G0_0_1_2_5 - 3.95489284378196e-05*G0_0_1_3_0 + 0.00540430762653002*G0_0_1_3_1 - 0.000654160654160677*G0_0_1_3_2 + 0.00344610122387909*G0_0_1_3_3 + 0.000158195713751272*G0_0_1_3_4 + 0.000962000962000996*G0_0_1_3_5 + 0.00540430762653003*G0_0_1_4_0 - 3.95489284378206e-05*G0_0_1_4_1 - 0.000654160654160679*G0_0_1_4_2 + 0.000158195713751273*G0_0_1_4_3 + 0.0034461012238791*G0_0_1_4_4 + 0.000962000962000997*G0_0_1_4_5 + 0.000816631927743073*G0_0_1_5_0 + 0.000816631927743075*G0_0_1_5_1 - 0.00044145155256268*G0_0_1_5_2 + 0.000962000962000996*G0_0_1_5_3 + 0.000962000962000997*G0_0_1_5_4 - 0.00216343327454445*G0_0_1_5_5;
    A[37] = -0.000814494147827547*G0_1_0_0_0 + 0.00109988776655447*G0_1_0_0_1 - 0.00634920634920652*G0_1_0_0_2 - 0.00365560365560377*G0_1_0_0_3 - 0.00218053551386892*G0_1_0_0_4 - 0.00168029501362843*G0_1_0_0_5 + 0.00109988776655447*G0_1_0_1_0 + 0.00221260221260234*G0_1_0_1_1 - 0.013916947250281*G0_1_0_1_2 - 0.00962000962000994*G0_1_0_1_3 - 0.00493827160493844*G0_1_0_1_4 - 0.00111592111592113*G0_1_0_1_5 - 0.00634920634920652*G0_1_0_2_0 - 0.013916947250281*G0_1_0_2_1 + 0.212698412698419*G0_1_0_2_2 + 0.0616321949655303*G0_1_0_2_3 + 0.0226390893057566*G0_1_0_2_4 + 0.00160333493666835*G0_1_0_2_5 - 0.00365560365560377*G0_1_0_3_0 - 0.00962000962000994*G0_1_0_3_1 + 0.0616321949655303*G0_1_0_3_2 + 0.0389931056597737*G0_1_0_3_3 + 0.0171877505210845*G0_1_0_3_4 + 0.00410453743787094*G0_1_0_3_5 - 0.00218053551386892*G0_1_0_4_0 - 0.00493827160493844*G0_1_0_4_1 + 0.0226390893057566*G0_1_0_4_2 + 0.0171877505210845*G0_1_0_4_3 + 0.0297578964245642*G0_1_0_4_4 + 0.00666987333654025*G0_1_0_4_5 - 0.00168029501362843*G0_1_0_5_0 - 0.00111592111592113*G0_1_0_5_1 + 0.00160333493666835*G0_1_0_5_2 + 0.00410453743787094*G0_1_0_5_3 + 0.00666987333654025*G0_1_0_5_4 - 0.000410453743787087*G0_1_0_5_5 + 0.031899951899953*G0_1_1_0_0 - 0.00297899631232975*G0_1_1_0_1 - 0.00520763187429868*G0_1_1_0_2 - 0.00164181497514836*G0_1_1_0_3 + 0.0105820105820109*G0_1_1_0_4 + 0.0166233766233772*G0_1_1_0_5 - 0.00297899631232975*G0_1_1_1_0 + 0.00247554914221593*G0_1_1_1_1 - 0.0108994708994712*G0_1_1_1_2 - 0.00947891614558313*G0_1_1_1_3 - 0.00556677890011241*G0_1_1_1_4 - 0.00699054032387388*G0_1_1_1_5 - 0.00520763187429868*G0_1_1_2_0 - 0.0108994708994712*G0_1_1_2_1 + 0.182202982202988*G0_1_1_2_2 + 0.0514349847683198*G0_1_1_2_3 + 0.00468173801507146*G0_1_1_2_4 - 0.00228314894981566*G0_1_1_2_5 - 0.00164181497514836*G0_1_1_3_0 - 0.00947891614558313*G0_1_1_3_1 + 0.0514349847683198*G0_1_1_3_2 + 0.0368895302228649*G0_1_1_3_3 + 0.0144171877505216*G0_1_1_3_4 + 0.00784992784992812*G0_1_1_3_5 + 0.0105820105820109*G0_1_1_4_0 - 0.00556677890011241*G0_1_1_4_1 + 0.00468173801507145*G0_1_1_4_2 + 0.0144171877505216*G0_1_1_4_3 + 0.0194452461119133*G0_1_1_4_4 + 0.0156998556998562*G0_1_1_4_5 + 0.0166233766233772*G0_1_1_5_0 - 0.00699054032387388*G0_1_1_5_1 - 0.00228314894981566*G0_1_1_5_2 + 0.00784992784992812*G0_1_1_5_3 + 0.0156998556998562*G0_1_1_5_4 + 0.0423280423280438*G0_1_1_5_5;
    A[91] = A[21] + 0.020573993907328*G0_0_1_0_0 + 0.000269360269360285*G0_0_1_0_1 - 0.000641333974667332*G0_0_1_0_2 + 0.000307840307840319*G0_0_1_0_3 - 0.000974827641494325*G0_0_1_0_4 - 0.00020522687189352*G0_0_1_0_5 + 0.000269360269360285*G0_0_1_1_0 - 0.000457484901929353*G0_0_1_1_2 + 0.00160761049649942*G0_0_1_1_3 + 0.000188124632569078*G0_0_1_1_4 - 0.00160761049649948*G0_0_1_1_5 - 0.000641333974667332*G0_0_1_2_0 - 0.000457484901929353*G0_0_1_2_1 - 0.00256533589866934*G0_0_1_2_2 + 0.000530169419058313*G0_0_1_2_3 + 0.00372828817273273*G0_0_1_2_4 - 0.000735396290951875*G0_0_1_2_5 + 0.000307840307840319*G0_0_1_3_0 + 0.00160761049649942*G0_0_1_3_1 + 0.000530169419058313*G0_0_1_3_2 + 0.00164181497514833*G0_0_1_3_3 - 0.000991929880818796*G0_0_1_3_4 + 0.000855111966223105*G0_0_1_3_5 - 0.000974827641494325*G0_0_1_4_0 + 0.000188124632569078*G0_0_1_4_1 + 0.00372828817273273*G0_0_1_4_2 - 0.000991929880818796*G0_0_1_4_3 - 0.0222329111218007*G0_0_1_4_4 + 0.0010945433167656*G0_0_1_4_5 - 0.00020522687189352*G0_0_1_5_0 - 0.00160761049649948*G0_0_1_5_1 - 0.000735396290951875*G0_0_1_5_2 + 0.000855111966223106*G0_0_1_5_3 + 0.0010945433167656*G0_0_1_5_4 - 0.00335203890759458*G0_0_1_5_5 - 0.020573993907328*G0_1_0_0_0 - 0.000269360269360285*G0_1_0_0_1 + 0.000641333974667331*G0_1_0_0_2 - 0.000307840307840319*G0_1_0_0_3 + 0.000974827641494327*G0_1_0_0_4 + 0.000205226871893521*G0_1_0_0_5 - 0.000269360269360285*G0_1_0_1_0 + 0.000457484901929353*G0_1_0_1_2 - 0.00160761049649942*G0_1_0_1_3 - 0.000188124632569078*G0_1_0_1_4 + 0.00160761049649948*G0_1_0_1_5 + 0.000641333974667332*G0_1_0_2_0 + 0.000457484901929353*G0_1_0_2_1 + 0.00256533589866934*G0_1_0_2_2 - 0.000530169419058313*G0_1_0_2_3 - 0.00372828817273273*G0_1_0_2_4 + 0.000735396290951875*G0_1_0_2_5 - 0.000307840307840319*G0_1_0_3_0 - 0.00160761049649942*G0_1_0_3_1 - 0.000530169419058313*G0_1_0_3_2 - 0.00164181497514834*G0_1_0_3_3 + 0.000991929880818795*G0_1_0_3_4 - 0.000855111966223106*G0_1_0_3_5 + 0.000974827641494327*G0_1_0_4_0 - 0.000188124632569078*G0_1_0_4_1 - 0.00372828817273273*G0_1_0_4_2 + 0.000991929880818796*G0_1_0_4_3 + 0.0222329111218007*G0_1_0_4_4 - 0.0010945433167656*G0_1_0_4_5 + 0.000205226871893521*G0_1_0_5_0 + 0.00160761049649948*G0_1_0_5_1 + 0.000735396290951875*G0_1_0_5_2 - 0.000855111966223106*G0_1_0_5_3 - 0.0010945433167656*G0_1_0_5_4 + 0.00335203890759458*G0_1_0_5_5;
    A[109] = A[70] + 0.00877344877344915*G0_0_0_0_0 + 0.00211640211640218*G0_0_0_0_1 - 0.00784992784992816*G0_0_0_0_2 - 0.0041558441558443*G0_0_0_0_3 - 0.0207792207792215*G0_0_0_0_4 + 0.0138528138528142*G0_0_0_0_5 + 0.00211640211640218*G0_0_0_1_0 + 0.0338624338624349*G0_0_0_1_1 - 0.00731120731120768*G0_0_0_1_2 - 0.0187782587782595*G0_0_0_1_3 - 0.00769600769600796*G0_0_0_1_4 - 0.0127753727753731*G0_0_0_1_5 - 0.00784992784992816*G0_0_0_2_0 - 0.00731120731120768*G0_0_0_2_1 - 0.169927849927854*G0_0_0_2_2 + 0.0438672438672458*G0_0_0_2_3 + 0.0444829244829262*G0_0_0_2_4 + 0.00954304954304986*G0_0_0_2_5 - 0.00415584415584429*G0_0_0_3_0 - 0.0187782587782595*G0_0_0_3_1 + 0.0438672438672458*G0_0_0_3_2 + 0.199788359788368*G0_0_0_3_3 + 0.0237037037037046*G0_0_0_3_4 - 0.0107744107744111*G0_0_0_3_5 - 0.0207792207792215*G0_0_0_4_0 - 0.00769600769600795*G0_0_0_4_1 + 0.0444829244829262*G0_0_0_4_2 + 0.0237037037037046*G0_0_0_4_3 + 0.234882154882163*G0_0_0_4_4 - 0.00369408369408381*G0_0_0_4_5 + 0.0138528138528142*G0_0_0_5_0 - 0.0127753727753731*G0_0_0_5_1 + 0.00954304954304986*G0_0_0_5_2 - 0.0107744107744111*G0_0_0_5_3 - 0.00369408369408382*G0_0_0_5_4 - 0.0520250120250138*G0_0_0_5_5 + 0.00184704184704186*G0_0_1_0_1 - 0.00184704184704195*G0_0_1_0_2 - 0.00954304954304993*G0_0_1_0_4 + 0.00954304954304977*G0_0_1_0_5 + 0.00184704184704186*G0_0_1_1_0 + 0.0403270803270821*G0_0_1_1_1 + 0.0120057720057726*G0_0_1_1_3 - 0.00923520923520958*G0_0_1_1_4 - 0.00769600769600767*G0_0_1_1_5 - 0.00184704184704195*G0_0_1_2_0 - 0.0403270803270811*G0_0_1_2_2 - 0.0120057720057723*G0_0_1_2_3 + 0.00769600769600817*G0_0_1_2_4 + 0.00923520923520952*G0_0_1_2_5 + 0.0120057720057726*G0_0_1_3_1 - 0.0120057720057723*G0_0_1_3_2 + 0.0184704184704193*G0_0_1_3_4 - 0.0184704184704189*G0_0_1_3_5 - 0.00954304954304993*G0_0_1_4_0 - 0.00923520923520958*G0_0_1_4_1 + 0.00769600769600818*G0_0_1_4_2 + 0.0184704184704193*G0_0_1_4_3 + 0.100971620971625*G0_0_1_4_4 + 0.00954304954304977*G0_0_1_5_0 - 0.00769600769600767*G0_0_1_5_1 + 0.00923520923520952*G0_0_1_5_2 - 0.0184704184704189*G0_0_1_5_3 - 0.100971620971624*G0_0_1_5_5 + 0.00758056758056787*G0_1_0_0_1 - 0.00758056758056787*G0_1_0_0_2 - 0.0257046657046667*G0_1_0_0_4 + 0.0257046657046664*G0_1_0_0_5 + 0.00758056758056787*G0_1_0_1_0 + 0.138374218374224*G0_1_0_1_1 - 0.0480230880230897*G0_1_0_1_3 - 0.00446368446368463*G0_1_0_1_4 - 0.0515632515632532*G0_1_0_1_5 - 0.00758056758056787*G0_1_0_2_0 - 0.138374218374222*G0_1_0_2_2 + 0.0480230880230901*G0_1_0_2_3 + 0.0515632515632536*G0_1_0_2_4 + 0.00446368446368465*G0_1_0_2_5 - 0.0480230880230897*G0_1_0_3_1 + 0.0480230880230901*G0_1_0_3_2 + 0.00892736892736925*G0_1_0_3_4 - 0.0089273689273693*G0_1_0_3_5 - 0.0257046657046667*G0_1_0_4_0 - 0.00446368446368463*G0_1_0_4_1 + 0.0515632515632536*G0_1_0_4_2 + 0.00892736892736926*G0_1_0_4_3 + 0.150841750841756*G0_1_0_4_4 + 0.0257046657046664*G0_1_0_5_0 - 0.0515632515632532*G0_1_0_5_1 + 0.00446368446368464*G0_1_0_5_2 - 0.00892736892736929*G0_1_0_5_3 - 0.150841750841757*G0_1_0_5_5 - 0.0087734487734494*G0_1_1_0_0 + 0.00784992784992809*G0_1_1_0_1 - 0.0021164021164022*G0_1_1_0_2 + 0.00415584415584428*G0_1_1_0_3 - 0.0138528138528145*G0_1_1_0_4 + 0.0207792207792213*G0_1_1_0_5 + 0.00784992784992809*G0_1_1_1_0 + 0.169927849927857*G0_1_1_1_1 + 0.00731120731120747*G0_1_1_1_2 - 0.0438672438672452*G0_1_1_1_3 - 0.00954304954304988*G0_1_1_1_4 - 0.0444829244829256*G0_1_1_1_5 - 0.0021164021164022*G0_1_1_2_0 + 0.00731120731120747*G0_1_1_2_1 - 0.0338624338624346*G0_1_1_2_2 + 0.0187782587782597*G0_1_1_2_3 + 0.0127753727753734*G0_1_1_2_4 + 0.00769600769600802*G0_1_1_2_5 + 0.00415584415584427*G0_1_1_3_0 - 0.0438672438672452*G0_1_1_3_1 + 0.0187782587782597*G0_1_1_3_2 - 0.199788359788367*G0_1_1_3_3 + 0.0107744107744111*G0_1_1_3_4 - 0.0237037037037047*G0_1_1_3_5 - 0.0138528138528145*G0_1_1_4_0 - 0.00954304954304988*G0_1_1_4_1 + 0.0127753727753734*G0_1_1_4_2 + 0.0107744107744111*G0_1_1_4_3 + 0.0520250120250138*G0_1_1_4_4 + 0.00369408369408373*G0_1_1_4_5 + 0.0207792207792213*G0_1_1_5_0 - 0.0444829244829256*G0_1_1_5_1 + 0.00769600769600802*G0_1_1_5_2 - 0.0237037037037047*G0_1_1_5_3 + 0.00369408369408373*G0_1_1_5_4 - 0.234882154882163*G0_1_1_5_5;
    A[18] = -A[26] - 0.0189065255731929*G0_0_0_0_0 + 0.00528031639142771*G0_0_0_0_1 + 0.00441665330554234*G0_0_0_0_2 + 0.00410453743787091*G0_0_0_0_3 - 0.00596868152423729*G0_0_0_0_4 - 0.00162471273582389*G0_0_0_0_5 + 0.00528031639142771*G0_0_0_1_0 - 0.188680455347129*G0_0_0_1_1 + 0.0052803163914277*G0_0_0_1_2 - 0.015392015392016*G0_0_0_1_3 + 0.00572925017369482*G0_0_0_1_4 - 0.0153920153920162*G0_0_0_1_5 + 0.00441665330554234*G0_0_0_2_0 + 0.0052803163914277*G0_0_0_2_1 - 0.0189065255731929*G0_0_0_2_2 - 0.0016247127358239*G0_0_0_2_3 - 0.00596868152423727*G0_0_0_2_4 + 0.00410453743787092*G0_0_0_2_5 + 0.00410453743787091*G0_0_0_3_0 - 0.015392015392016*G0_0_0_3_1 - 0.0016247127358239*G0_0_0_3_2 - 0.0328362995029673*G0_0_0_3_3 - 0.0196675752231314*G0_0_0_3_4 - 0.0164181497514837*G0_0_0_3_5 - 0.00596868152423729*G0_0_0_4_0 + 0.00572925017369482*G0_0_0_4_1 - 0.00596868152423727*G0_0_0_4_2 - 0.0196675752231314*G0_0_0_4_3 - 0.0870846026401609*G0_0_0_4_4 - 0.0196675752231315*G0_0_0_4_5 - 0.00162471273582389*G0_0_0_5_0 - 0.0153920153920162*G0_0_0_5_1 + 0.00410453743787092*G0_0_0_5_2 - 0.0164181497514837*G0_0_0_5_3 - 0.0196675752231315*G0_0_0_5_4 - 0.0328362995029674*G0_0_0_5_5;
    A[38] = -A[35] - 0.0189065255731929*G0_1_1_0_0 + 0.00441665330554236*G0_1_1_0_1 + 0.00528031639142766*G0_1_1_0_2 + 0.0041045374378709*G0_1_1_0_3 - 0.0016247127358239*G0_1_1_0_4 - 0.00596868152423731*G0_1_1_0_5 + 0.00441665330554236*G0_1_1_1_0 - 0.0189065255731931*G0_1_1_1_1 + 0.00528031639142767*G0_1_1_1_2 - 0.00162471273582395*G0_1_1_1_3 + 0.0041045374378709*G0_1_1_1_4 - 0.00596868152423738*G0_1_1_1_5 + 0.00528031639142766*G0_1_1_2_0 + 0.00528031639142767*G0_1_1_2_1 - 0.188680455347128*G0_1_1_2_2 - 0.0153920153920159*G0_1_1_2_3 - 0.0153920153920159*G0_1_1_2_4 + 0.00572925017369478*G0_1_1_2_5 + 0.0041045374378709*G0_1_1_3_0 - 0.00162471273582395*G0_1_1_3_1 - 0.0153920153920159*G0_1_1_3_2 - 0.0328362995029672*G0_1_1_3_3 - 0.0164181497514836*G0_1_1_3_4 - 0.0196675752231314*G0_1_1_3_5 - 0.0016247127358239*G0_1_1_4_0 + 0.0041045374378709*G0_1_1_4_1 - 0.0153920153920159*G0_1_1_4_2 - 0.0164181497514836*G0_1_1_4_3 - 0.0328362995029673*G0_1_1_4_4 - 0.0196675752231314*G0_1_1_4_5 - 0.00596868152423731*G0_1_1_5_0 - 0.00596868152423737*G0_1_1_5_1 + 0.00572925017369478*G0_1_1_5_2 - 0.0196675752231314*G0_1_1_5_3 - 0.0196675752231314*G0_1_1_5_4 - 0.0870846026401613*G0_1_1_5_5;
    A[116] = -A[108] + 0.014058040724708*G0_0_0_0_0 + 0.00164181497514836*G0_0_0_0_1 + 0.00651595318262007*G0_0_0_0_2 - 0.00769600769600799*G0_0_0_0_3 + 0.0160076960076965*G0_0_0_0_4 - 0.0130319063652401*G0_0_0_0_5 + 0.00164181497514836*G0_0_0_1_0 + 0.00410453743787135*G0_0_0_1_1 + 0.00312970979637656*G0_0_0_1_2 + 0.00410453743787102*G0_0_0_1_3 - 0.000923520923521027*G0_0_0_1_4 + 0.0020522687189355*G0_0_0_1_5 + 0.00651595318262007*G0_0_0_2_0 + 0.00312970979637656*G0_0_0_2_1 + 0.0519223985890667*G0_0_0_2_2 - 0.0243193843193852*G0_0_0_2_3 - 0.0429950296616978*G0_0_0_2_4 - 0.00441237774571123*G0_0_0_2_5 - 0.00769600769600799*G0_0_0_3_0 + 0.00410453743787102*G0_0_0_3_1 - 0.0243193843193852*G0_0_0_3_2 + 0.0225749559082905*G0_0_0_3_3 + 0.017239057239058*G0_0_0_3_4 + 0.0242167708834385*G0_0_0_3_5 + 0.0160076960076965*G0_0_0_4_0 - 0.000923520923521027*G0_0_0_4_1 - 0.0429950296616978*G0_0_0_4_2 + 0.017239057239058*G0_0_0_4_3 - 0.320564373897717*G0_0_0_4_4 + 0.0106717973384645*G0_0_0_4_5 - 0.0130319063652401*G0_0_0_5_0 + 0.0020522687189355*G0_0_0_5_1 - 0.00441237774571123*G0_0_0_5_2 + 0.0242167708834385*G0_0_0_5_3 + 0.0106717973384645*G0_0_0_5_4 + 0.0233958633958641*G0_0_0_5_5 - 0.0378643578643595*G0_1_0_0_0 - 0.00148789482122818*G0_1_0_0_1 - 0.00328362995029673*G0_1_0_0_3 + 0.0590027256693941*G0_1_0_0_4 + 0.0112874779541449*G0_1_0_0_5 - 0.00148789482122818*G0_1_0_1_0 + 0.0014878948212282*G0_1_0_1_2 + 0.00205226871893549*G0_1_0_1_3 - 0.00205226871893545*G0_1_0_1_5 + 0.0014878948212282*G0_1_0_2_1 + 0.0378643578643588*G0_1_0_2_2 - 0.011287477954145*G0_1_0_2_3 - 0.0590027256693942*G0_1_0_2_4 + 0.00328362995029679*G0_1_0_2_5 - 0.00328362995029673*G0_1_0_3_0 + 0.00205226871893549*G0_1_0_3_1 - 0.011287477954145*G0_1_0_3_2 - 0.000820907487574091*G0_1_0_3_3 + 0.00656725990059346*G0_1_0_3_4 + 0.0590027256693941*G0_1_0_4_0 - 0.0590027256693942*G0_1_0_4_2 + 0.00656725990059345*G0_1_0_4_3 - 0.0065672599005936*G0_1_0_4_5 + 0.0112874779541449*G0_1_0_5_0 - 0.00205226871893545*G0_1_0_5_1 + 0.00328362995029679*G0_1_0_5_2 - 0.0065672599005936*G0_1_0_5_4 + 0.000820907487573818*G0_1_0_5_5;
    A[139] = A[116] - 0.00708032708032726*G0_0_0_0_0 - 0.00174442841109512*G0_0_0_0_2 + 0.00307840307840315*G0_0_0_0_3 - 0.00369408369408378*G0_0_0_0_4 + 0.0128266794933466*G0_0_0_0_5 + 0.00708032708032683*G0_0_0_1_1 + 0.00174442841109515*G0_0_0_1_2 + 0.00369408369408388*G0_0_0_1_3 - 0.00307840307840315*G0_0_0_1_4 - 0.0128266794933466*G0_0_0_1_5 - 0.00174442841109512*G0_0_0_2_0 + 0.00174442841109515*G0_0_0_2_1 - 0.0075933942600613*G0_0_0_2_3 + 0.00759339426006112*G0_0_0_2_4 + 0.00307840307840316*G0_0_0_3_0 + 0.00369408369408387*G0_0_0_3_1 - 0.00759339426006129*G0_0_0_3_2 - 0.132987012987018*G0_0_0_3_3 - 0.00615680615680639*G0_0_0_3_5 - 0.00369408369408378*G0_0_0_4_0 - 0.00307840307840315*G0_0_0_4_1 + 0.00759339426006111*G0_0_0_4_2 + 0.132987012987017*G0_0_0_4_4 + 0.0061568061568063*G0_0_0_4_5 + 0.0128266794933466*G0_0_0_5_0 - 0.0128266794933466*G0_0_0_5_1 - 0.00615680615680639*G0_0_0_5_3 + 0.0061568061568063*G0_0_0_5_4 + 0.00533589866923247*G0_0_1_0_0 + 0.00246272246272259*G0_0_1_0_1 + 0.00118005451338788*G0_0_1_0_2 - 0.00143658810325485*G0_0_1_0_3 + 0.00143658810325481*G0_0_1_0_4 + 0.00625941959275321*G0_0_1_0_5 + 0.00246272246272259*G0_0_1_1_0 + 0.0481257014590358*G0_0_1_1_1 + 0.00461760461760479*G0_0_1_1_2 - 0.030270963604298*G0_0_1_1_3 - 0.020420073753408*G0_0_1_1_5 + 0.00118005451338788*G0_0_1_2_0 + 0.00461760461760479*G0_0_1_2_1 + 0.0050280583613918*G0_0_1_2_2 + 0.010363957030624*G0_0_1_2_3 - 0.00615680615680637*G0_0_1_2_4 - 0.00430976430976445*G0_0_1_2_5 - 0.00143658810325485*G0_0_1_3_0 - 0.030270963604298*G0_0_1_3_1 + 0.010363957030624*G0_0_1_3_2 - 0.17362193362194*G0_0_1_3_3 + 0.00287317620650971*G0_0_1_3_4 + 0.0114927048260385*G0_0_1_3_5 + 0.00143658810325481*G0_0_1_4_0 - 0.00615680615680637*G0_0_1_4_2 + 0.00287317620650971*G0_0_1_4_3 - 0.0225749559082898*G0_0_1_4_4 + 0.00861952861952896*G0_0_1_4_5 + 0.00625941959275321*G0_0_1_5_0 - 0.020420073753408*G0_0_1_5_1 - 0.00430976430976445*G0_0_1_5_2 + 0.0114927048260385*G0_0_1_5_3 + 0.00861952861952896*G0_0_1_5_4 + 0.0119031585698253*G0_0_1_5_5 + 0.0410453743787092*G0_1_0_0_0 + 0.00246272246272257*G0_1_0_0_1 + 0.00287317620650965*G0_1_0_0_2 + 0.00307840307840316*G0_1_0_0_3 - 0.0339650472983817*G0_1_0_0_4 - 0.00759339426006128*G0_1_0_0_5 + 0.00246272246272257*G0_1_0_1_0 + 0.012416225749559*G0_1_0_1_1 + 0.00292448292448306*G0_1_0_1_2 + 0.00513067179733869*G0_1_0_1_3 - 0.00451499118165799*G0_1_0_1_4 - 0.00656725990059341*G0_1_0_1_5 + 0.00287317620650965*G0_1_0_2_0 + 0.00292448292448306*G0_1_0_2_1 + 0.00502805836139161*G0_1_0_2_2 - 0.0137502004168677*G0_1_0_2_3 + 0.0179573512906851*G0_1_0_2_4 - 0.00430976430976448*G0_1_0_2_5 + 0.00307840307840316*G0_1_0_3_0 + 0.0051306717973387*G0_1_0_3_1 - 0.0137502004168677*G0_1_0_3_2 - 0.155561968895308*G0_1_0_3_3 + 0.00287317620650959*G0_1_0_3_4 + 0.00246272246272254*G0_1_0_3_5 - 0.0339650472983817*G0_1_0_4_0 - 0.00451499118165799*G0_1_0_4_1 + 0.0179573512906851*G0_1_0_4_2 + 0.00287317620650959*G0_1_0_4_3 - 0.0406349206349218*G0_1_0_4_4 + 0.0176495109828449*G0_1_0_4_5 - 0.00759339426006128*G0_1_0_5_0 - 0.00656725990059341*G0_1_0_5_1 - 0.00430976430976448*G0_1_0_5_2 + 0.00246272246272254*G0_1_0_5_3 + 0.0176495109828449*G0_1_0_5_4 + 0.0119031585698255*G0_1_0_5_5 - 0.00810646143979536*G0_1_1_0_0 + 0.00246272246272264*G0_1_1_0_1 + 0.000564373897707255*G0_1_1_0_2 + 0.00164181497514836*G0_1_1_0_3 + 0.0040019240019241*G0_1_1_0_4 + 0.00225749559082889*G0_1_1_0_5 + 0.00246272246272264*G0_1_1_1_0 + 0.061568061568063*G0_1_1_1_1 + 0.00523328523328545*G0_1_1_1_2 - 0.0328362995029674*G0_1_1_1_3 - 0.0030784030784032*G0_1_1_1_4 - 0.0164181497514838*G0_1_1_1_5 + 0.000564373897707255*G0_1_1_2_0 + 0.00523328523328545*G0_1_1_2_1 + 0.00502805836139181*G0_1_1_2_2 + 0.013544973544974*G0_1_1_2_3 - 0.0093378226711563*G0_1_1_2_4 - 0.00430976430976442*G0_1_1_2_5 + 0.00164181497514836*G0_1_1_3_0 - 0.0328362995029674*G0_1_1_3_1 + 0.013544973544974*G0_1_1_3_2 - 0.207279140612482*G0_1_1_3_3 + 0.00287317620650961*G0_1_1_3_4 + 0.00533589866923203*G0_1_1_3_5 + 0.0040019240019241*G0_1_1_4_0 - 0.0030784030784032*G0_1_1_4_1 - 0.0093378226711563*G0_1_1_4_2 + 0.00287317620650961*G0_1_1_4_3 + 0.0110822510822515*G0_1_1_4_4 + 0.0147763347763352*G0_1_1_4_5 + 0.00225749559082889*G0_1_1_5_0 - 0.0164181497514838*G0_1_1_5_1 - 0.00430976430976442*G0_1_1_5_2 + 0.00533589866923203*G0_1_1_5_3 + 0.0147763347763352*G0_1_1_5_4 + 0.0119031585698251*G0_1_1_5_5;
    A[110] = -A[139] + 0.00646464646464684*G0_0_0_0_0 + 0.00102613435946771*G0_0_0_0_1 - 0.00887606220939573*G0_0_0_0_2 - 0.00502805836139185*G0_0_0_0_3 + 0.0223697290363965*G0_0_0_0_4 + 0.00605419272085958*G0_0_0_0_5 + 0.00102613435946771*G0_0_0_1_0 + 0.0192913259579932*G0_0_0_1_1 - 0.0317588584255261*G0_0_0_1_2 - 0.0231906365239706*G0_0_0_1_3 - 0.00400192400192412*G0_0_0_1_4 - 0.0104665704665708*G0_0_0_1_5 - 0.00887606220939573*G0_0_0_2_0 - 0.0317588584255261*G0_0_0_2_1 + 0.452114798781479*G0_0_0_2_2 + 0.145198011864683*G0_0_0_2_3 + 0.00913259579926241*G0_0_0_2_4 - 0.000307840307840257*G0_0_0_2_5 - 0.00502805836139185*G0_0_0_3_0 - 0.0231906365239706*G0_0_0_3_1 + 0.145198011864683*G0_0_0_3_2 + 0.0258585858585869*G0_0_0_3_3 + 0.018059964726632*G0_0_0_3_4 + 0.0106717973384644*G0_0_0_3_5 + 0.0223697290363965*G0_0_0_4_0 - 0.00400192400192412*G0_0_0_4_1 + 0.00913259579926241*G0_0_0_4_2 + 0.018059964726632*G0_0_0_4_3 - 0.103844797178134*G0_0_0_4_4 + 0.00861952861952888*G0_0_0_4_5 + 0.00605419272085958*G0_0_0_5_0 - 0.0104665704665708*G0_0_0_5_1 - 0.000307840307840255*G0_0_0_5_2 + 0.0106717973384644*G0_0_0_5_3 + 0.00861952861952888*G0_0_0_5_4 + 0.019291325957993*G0_0_0_5_5 + 0.00215488215488247*G0_0_1_0_0 + 0.00200096200096208*G0_0_1_0_1 - 0.00287317620650958*G0_0_1_0_2 - 0.00441237774571117*G0_0_1_0_3 + 0.0141606541606547*G0_0_1_0_4 + 0.00985088985089027*G0_0_1_0_5 + 0.00200096200096208*G0_0_1_1_0 + 0.0599262465929151*G0_0_1_1_1 - 0.0206766073432747*G0_0_1_1_2 - 0.0633124899791589*G0_0_1_1_3 + 0.00441237774571126*G0_0_1_1_4 - 0.0195991662658337*G0_0_1_1_5 - 0.00287317620650958*G0_0_1_2_0 - 0.0206766073432747*G0_0_1_2_1 + 0.156793330126669*G0_0_1_2_2 + 0.141606541606547*G0_0_1_2_3 + 0.00174442841109498*G0_0_1_2_4 - 0.0017444284110951*G0_0_1_2_5 - 0.00441237774571117*G0_0_1_3_0 - 0.0633124899791589*G0_0_1_3_1 + 0.141606541606547*G0_0_1_3_2 + 0.0808593875260569*G0_0_1_3_3 + 0.0123136123136127*G0_0_1_3_5 + 0.0141606541606547*G0_0_1_4_0 + 0.00441237774571126*G0_0_1_4_1 + 0.00174442841109498*G0_0_1_4_2 - 0.0939939073272445*G0_0_1_4_4 - 0.00533589866923227*G0_0_1_4_5 + 0.00985088985089027*G0_0_1_5_0 - 0.0195991662658337*G0_0_1_5_1 - 0.0017444284110951*G0_0_1_5_2 + 0.0123136123136127*G0_0_1_5_3 - 0.00533589866923227*G0_0_1_5_4 + 0.0135449735449736*G0_0_1_5_5 - 0.00779862113195487*G0_1_0_0_0 + 0.000564373897707361*G0_1_0_0_2 + 0.00256533589866933*G0_1_0_0_3 + 0.0232932499599174*G0_1_0_0_4 + 0.00451499118165785*G0_1_0_0_5 + 0.0188808722142061*G0_1_0_1_1 - 0.024575917909252*G0_1_0_1_2 - 0.0118005451338788*G0_1_0_1_3 + 0.00297578964245644*G0_1_0_1_4 - 0.00749078082411434*G0_1_0_1_5 + 0.000564373897707361*G0_1_0_2_0 - 0.024575917909252*G0_1_0_2_1 + 0.379361872695217*G0_1_0_2_2 + 0.112669552669556*G0_1_0_2_3 - 0.0225749559082903*G0_1_0_2_4 - 0.00297578964245635*G0_1_0_2_5 + 0.00256533589866933*G0_1_0_3_0 - 0.0118005451338788*G0_1_0_3_1 + 0.112669552669556*G0_1_0_3_2 - 0.038993105659774*G0_1_0_3_3 - 0.0110822510822516*G0_1_0_3_4 + 0.000820907487574151*G0_1_0_3_5 + 0.0232932499599174*G0_1_0_4_0 + 0.00297578964245644*G0_1_0_4_1 - 0.0225749559082903*G0_1_0_4_2 - 0.0110822510822516*G0_1_0_4_3 - 0.141606541606547*G0_1_0_4_4 + 0.00451499118165785*G0_1_0_5_0 - 0.00749078082411434*G0_1_0_5_1 - 0.00297578964245635*G0_1_0_5_2 + 0.000820907487574154*G0_1_0_5_3 + 0.0119031585698253*G0_1_0_5_5 - 0.0217540484207159*G0_1_1_0_0 + 0.00359147025813708*G0_1_1_0_1 + 0.00241141574474921*G0_1_1_0_2 + 0.00533589866923222*G0_1_1_0_3 + 0.013134519801187*G0_1_1_0_4 - 0.00779862113195481*G0_1_1_0_5 + 0.00359147025813708*G0_1_1_1_0 + 0.0652621452621472*G0_1_1_1_1 - 0.0155972422639094*G0_1_1_1_2 - 0.0494596761263446*G0_1_1_1_3 + 0.0123136123136127*G0_1_1_1_4 - 0.0059515792849129*G0_1_1_1_5 + 0.00241141574474921*G0_1_1_2_0 - 0.0155972422639094*G0_1_1_2_1 + 0.127651114317785*G0_1_1_2_2 + 0.117184543851215*G0_1_1_2_3 - 0.010466570466571*G0_1_1_2_4 + 0.000615680615680655*G0_1_1_2_5 + 0.00533589866923222*G0_1_1_3_0 - 0.0494596761263446*G0_1_1_3_1 + 0.117184543851215*G0_1_1_3_2 - 0.0258585858585873*G0_1_1_3_3 - 0.0352990219656899*G0_1_1_3_4 - 0.0119031585698257*G0_1_1_3_5 + 0.013134519801187*G0_1_1_4_0 + 0.0123136123136127*G0_1_1_4_1 - 0.010466570466571*G0_1_1_4_2 - 0.0352990219656899*G0_1_1_4_3 - 0.109591149591153*G0_1_1_4_4 - 0.0258585858585867*G0_1_1_4_5 - 0.00779862113195481*G0_1_1_5_0 - 0.00595157928491291*G0_1_1_5_1 + 0.000615680615680655*G0_1_1_5_2 - 0.0119031585698257*G0_1_1_5_3 - 0.0258585858585867*G0_1_1_5_4 - 0.0710084976751671*G0_1_1_5_5;
    A[117] = -A[110] + 0.0477152477152494*G0_0_0_0_0 + 0.00333493666827009*G0_0_0_0_1 - 0.0175982042648714*G0_0_0_0_2 - 0.0300657367324044*G0_0_0_0_3 + 0.0122109988776659*G0_0_0_0_4 + 0.00584896584896607*G0_0_0_0_5 + 0.00333493666827009*G0_0_0_1_0 + 0.0128266794933466*G0_0_0_1_1 - 0.0471508738175421*G0_0_0_1_2 - 0.0715215648549006*G0_0_0_1_3 - 0.0173416706750046*G0_0_0_1_4 - 0.014468494468495*G0_0_0_1_5 - 0.0175982042648714*G0_0_0_2_0 - 0.0471508738175421*G0_0_0_2_1 + 0.517171717171734*G0_0_0_2_2 + 0.230059323392665*G0_0_0_2_3 + 0.0408401475068153*G0_0_0_2_4 + 0.00472021805355162*G0_0_0_2_5 - 0.0300657367324044*G0_0_0_3_0 - 0.0715215648549006*G0_0_0_3_1 + 0.230059323392665*G0_0_0_3_2 + 0.468738175404859*G0_0_0_3_3 + 0.0948148148148181*G0_0_0_3_4 + 0.0506910373577059*G0_0_0_3_5 + 0.0122109988776659*G0_0_0_4_0 - 0.0173416706750046*G0_0_0_4_1 + 0.0408401475068153*G0_0_0_4_2 + 0.0948148148148181*G0_0_0_4_3 - 0.424409171075853*G0_0_0_4_4 + 0.0252429052429061*G0_0_0_4_5 + 0.00584896584896607*G0_0_0_5_0 - 0.014468494468495*G0_0_0_5_1 + 0.00472021805355162*G0_0_0_5_2 + 0.0506910373577059*G0_0_0_5_3 + 0.0252429052429061*G0_0_0_5_4 + 0.00697771364438062*G0_0_0_5_5 + 0.0419175885842569*G0_0_1_0_0 + 0.000461760461760431*G0_0_1_0_1 - 0.0157511624178296*G0_0_1_0_2 - 0.0327336860670204*G0_0_1_0_3 - 0.0124162257495594*G0_0_1_0_4 + 0.023601090267758*G0_0_1_0_5 + 0.000461760461760429*G0_0_1_1_0 + 0.0190347923681262*G0_0_1_1_1 - 0.0388904922238269*G0_0_1_1_2 - 0.0909155042488408*G0_0_1_1_3 - 0.0498701298701315*G0_0_1_1_4 - 0.0328362995029674*G0_0_1_1_5 - 0.0157511624178296*G0_0_1_2_0 - 0.0388904922238269*G0_0_1_2_1 + 0.249401956068631*G0_0_1_2_2 + 0.213743787077128*G0_0_1_2_3 + 0.0255507455507464*G0_0_1_2_4 - 0.0073881673881676*G0_0_1_2_5 - 0.0327336860670204*G0_0_1_3_0 - 0.0909155042488408*G0_0_1_3_1 + 0.213743787077128*G0_0_1_3_2 + 0.612602212602235*G0_0_1_3_3 + 0.165207631874304*G0_0_1_3_4 + 0.0802437069103764*G0_0_1_3_5 - 0.0124162257495594*G0_0_1_4_0 - 0.0498701298701315*G0_0_1_4_1 + 0.0255507455507464*G0_0_1_4_2 + 0.165207631874304*G0_0_1_4_3 + 0.292037838704514*G0_0_1_4_4 + 0.114516594516598*G0_0_1_4_5 + 0.023601090267758*G0_0_1_5_0 - 0.0328362995029674*G0_0_1_5_1 - 0.0073881673881676*G0_0_1_5_2 + 0.0802437069103764*G0_0_1_5_3 + 0.114516594516598*G0_0_1_5_4 + 0.140169953503292*G0_0_1_5_5 + 0.0234471701138379*G0_1_0_0_0 - 0.00138528138528148*G0_1_0_0_1 - 0.0367356100689446*G0_1_0_0_2 - 0.0125188391855062*G0_1_0_0_3 + 0.179060445727119*G0_1_0_0_4 + 0.0118005451338789*G0_1_0_0_5 - 0.00138528138528148*G0_1_0_1_0 + 0.0107231040564378*G0_1_0_1_1 - 0.0375052108385454*G0_1_0_1_2 - 0.0617732884399573*G0_1_0_1_3 - 0.041558441558443*G0_1_0_1_4 - 0.00902998236331606*G0_1_0_1_5 - 0.0367356100689446*G0_1_0_2_0 - 0.0375052108385454*G0_1_0_2_1 + 0.458220298220313*G0_1_0_2_2 + 0.199275292608633*G0_1_0_2_3 - 0.0736764470097831*G0_1_0_2_4 - 0.00277056277056286*G0_1_0_2_5 - 0.0125188391855062*G0_1_0_3_0 - 0.0617732884399573*G0_1_0_3_1 + 0.199275292608633*G0_1_0_3_2 + 0.399987173320521*G0_1_0_3_3 + 0.108154561487899*G0_1_0_3_4 + 0.0305788039121386*G0_1_0_3_5 + 0.179060445727119*G0_1_0_4_0 - 0.041558441558443*G0_1_0_4_1 - 0.0736764470097831*G0_1_0_4_2 + 0.108154561487899*G0_1_0_4_3 + 0.477562930896279*G0_1_0_4_4 + 0.0886580086580118*G0_1_0_4_5 + 0.0118005451338789*G0_1_0_5_0 - 0.00902998236331605*G0_1_0_5_1 - 0.00277056277056286*G0_1_0_5_2 + 0.0305788039121386*G0_1_0_5_3 + 0.0886580086580118*G0_1_0_5_4 - 0.0108770242103574*G0_1_0_5_5 - 0.207484367484375*G0_1_1_0_0 + 0.0393522526855874*G0_1_1_0_1 - 0.0253455186788528*G0_1_1_0_3 - 0.0379669713003058*G0_1_1_0_4 - 0.19014269680937*G0_1_1_0_5 + 0.0393522526855874*G0_1_1_1_0 - 0.0393522526855874*G0_1_1_1_2 - 0.0580792047458735*G0_1_1_1_3 + 0.0580792047458734*G0_1_1_1_5 - 0.0393522526855874*G0_1_1_2_1 + 0.207484367484375*G0_1_1_2_2 + 0.19014269680937*G0_1_1_2_3 + 0.0379669713003058*G0_1_1_2_4 + 0.0253455186788529*G0_1_1_2_5 - 0.0253455186788528*G0_1_1_3_0 - 0.0580792047458735*G0_1_1_3_1 + 0.19014269680937*G0_1_1_3_2 + 0.472432259098943*G0_1_1_3_3 + 0.0506910373577059*G0_1_1_3_4 - 0.0379669713003058*G0_1_1_4_0 + 0.0379669713003058*G0_1_1_4_2 + 0.0506910373577059*G0_1_1_4_3 - 0.0506910373577055*G0_1_1_4_5 - 0.19014269680937*G0_1_1_5_0 + 0.0580792047458734*G0_1_1_5_1 + 0.0253455186788529*G0_1_1_5_2 - 0.0506910373577055*G0_1_1_5_4 - 0.472432259098942*G0_1_1_5_5;
    A[65] = -A[110] - 0.00574635241301927*G0_0_0_0_0 + 0.0246272246272255*G0_0_0_0_2 - 0.00410453743787088*G0_0_0_0_3 + 0.0492544492544509*G0_0_0_0_4 + 0.00369408369408383*G0_0_0_0_5 + 0.0057463524130193*G0_0_0_1_1 - 0.0246272246272255*G0_0_0_1_2 - 0.049254449254451*G0_0_0_1_3 + 0.0041045374378709*G0_0_0_1_4 - 0.00369408369408383*G0_0_0_1_5 + 0.0246272246272255*G0_0_0_2_0 - 0.0246272246272255*G0_0_0_2_1 + 0.143658810325482*G0_0_0_2_3 - 0.143658810325482*G0_0_0_2_4 - 0.00410453743787088*G0_0_0_3_0 - 0.049254449254451*G0_0_0_3_1 + 0.143658810325482*G0_0_0_3_2 + 0.262690396023739*G0_0_0_3_3 + 0.0082090748757419*G0_0_0_3_5 + 0.0492544492544509*G0_0_0_4_0 + 0.0041045374378709*G0_0_0_4_1 - 0.143658810325482*G0_0_0_4_2 - 0.262690396023738*G0_0_0_4_4 - 0.00820907487574185*G0_0_0_4_5 + 0.00369408369408383*G0_0_0_5_0 - 0.00369408369408383*G0_0_0_5_1 + 0.0082090748757419*G0_0_0_5_3 - 0.00820907487574185*G0_0_0_5_4 + 0.000820907487574176*G0_0_1_0_0 + 0.0055411255411257*G0_0_1_0_1 - 0.00472021805355148*G0_0_1_0_2 - 0.0373512906846251*G0_0_1_0_3 + 0.00944043610710319*G0_0_1_0_4 - 0.000820907487574141*G0_0_1_0_5 + 0.0055411255411257*G0_0_1_1_0 + 0.00779862113195462*G0_0_1_1_1 - 0.0416610549943898*G0_0_1_1_2 - 0.11287477954145*G0_0_1_1_3 - 0.00944043610710305*G0_0_1_1_4 - 0.0119031585698257*G0_0_1_1_5 - 0.00472021805355148*G0_0_1_2_0 - 0.0416610549943898*G0_0_1_2_1 + 0.133397466730805*G0_0_1_2_2 + 0.242167708834384*G0_0_1_2_3 + 0.00944043610710313*G0_0_1_2_5 - 0.0373512906846251*G0_0_1_3_0 - 0.11287477954145*G0_0_1_3_1 + 0.242167708834384*G0_0_1_3_2 + 0.842251082251112*G0_0_1_3_3 + 0.0935834535834567*G0_0_1_3_4 + 0.0558217091550445*G0_0_1_3_5 + 0.00944043610710319*G0_0_1_4_0 - 0.00944043610710305*G0_0_1_4_1 + 0.0935834535834567*G0_0_1_4_3 - 0.0935834535834575*G0_0_1_4_4 - 0.000820907487574141*G0_0_1_5_0 - 0.0119031585698257*G0_0_1_5_1 + 0.00944043610710313*G0_0_1_5_2 + 0.0558217091550445*G0_0_1_5_3 + 0.00164181497514857*G0_0_1_5_5 - 0.00974827641494339*G0_1_0_0_0 - 0.00118005451338791*G0_1_0_0_1 + 0.0073881673881677*G0_1_0_0_2 + 0.00759339426006118*G0_1_0_0_3 + 0.0324258457591802*G0_1_0_0_4 + 0.00246272246272255*G0_1_0_0_5 - 0.00118005451338791*G0_1_0_1_0 - 0.00400192400192397*G0_1_0_1_1 - 0.0172390572390578*G0_1_0_1_2 - 0.0168286034952708*G0_1_0_1_3 + 0.0116979316979321*G0_1_0_1_4 - 0.0012313612313612*G0_1_0_1_5 + 0.0073881673881677*G0_1_0_2_0 - 0.0172390572390578*G0_1_0_2_1 + 0.303222703222713*G0_1_0_2_2 + 0.0933782267115633*G0_1_0_2_3 - 0.0502805836139188*G0_1_0_2_4 - 0.00348885682219024*G0_1_0_2_5 + 0.00759339426006118*G0_1_0_3_0 - 0.0168286034952708*G0_1_0_3_1 + 0.0933782267115633*G0_1_0_3_2 + 0.0755234888568254*G0_1_0_3_3 - 0.0385826519159865*G0_1_0_3_4 - 0.00820907487574175*G0_1_0_3_5 + 0.0324258457591802*G0_1_0_4_0 + 0.0116979316979321*G0_1_0_4_1 - 0.0502805836139188*G0_1_0_4_2 - 0.0385826519159865*G0_1_0_4_3 - 0.187166907166914*G0_1_0_4_4 - 0.0164181497514837*G0_1_0_4_5 + 0.00246272246272255*G0_1_0_5_0 - 0.0012313612313612*G0_1_0_5_1 - 0.00348885682219024*G0_1_0_5_2 - 0.00820907487574175*G0_1_0_5_3 - 0.0164181497514837*G0_1_0_5_4 - 0.0114927048260383*G0_1_0_5_5 - 0.0244219977553318*G0_1_1_0_0 + 0.0184704184704192*G0_1_1_0_1 + 0.00251402918069596*G0_1_1_0_2 + 0.0153920153920159*G0_1_1_0_3 + 0.0229854096520772*G0_1_1_0_4 + 0.0141606541606547*G0_1_1_0_5 + 0.0184704184704192*G0_1_1_1_0 - 0.168696488696496*G0_1_1_1_1 - 0.00400192400192412*G0_1_1_1_2 - 0.081475068141738*G0_1_1_1_3 + 0.013544973544974*G0_1_1_1_4 - 0.0724450857784221*G0_1_1_1_5 + 0.00251402918069596*G0_1_1_2_0 - 0.00400192400192412*G0_1_1_2_1 + 0.0872214205547568*G0_1_1_2_2 + 0.11287477954145*G0_1_1_2_3 - 0.019496552829887*G0_1_1_2_4 + 0.0155972422639095*G0_1_1_2_5 + 0.0153920153920159*G0_1_1_3_0 - 0.081475068141738*G0_1_1_3_1 + 0.11287477954145*G0_1_1_3_2 + 0.222055475388817*G0_1_1_3_3 - 0.0578739778739798*G0_1_1_3_4 - 0.0619785153118507*G0_1_1_3_5 + 0.0229854096520772*G0_1_1_4_0 + 0.013544973544974*G0_1_1_4_1 - 0.019496552829887*G0_1_1_4_2 - 0.0578739778739798*G0_1_1_4_3 - 0.151457431457437*G0_1_1_4_4 - 0.0582844316177669*G0_1_1_4_5 + 0.0141606541606547*G0_1_1_5_0 - 0.0724450857784221*G0_1_1_5_1 + 0.0155972422639095*G0_1_1_5_2 - 0.0619785153118507*G0_1_1_5_3 - 0.0582844316177669*G0_1_1_5_4 - 0.243399070065745*G0_1_1_5_5;
    A[113] = -A[110] - 0.00410453743787076*G0_0_1_0_0 - 0.00733686067019425*G0_0_1_0_1 + 0.0215488215488223*G0_0_1_0_2 + 0.0178547378547385*G0_0_1_0_3 + 0.0724450857784217*G0_0_1_0_4 + 0.0152894019560693*G0_0_1_0_5 - 0.00733686067019425*G0_0_1_1_0 - 0.00287317620650991*G0_0_1_1_1 + 0.00923520923520954*G0_0_1_1_2 - 0.000615680615680701*G0_0_1_1_3 + 0.0416610549943898*G0_0_1_1_4 + 0.00790123456790139*G0_0_1_1_5 + 0.0215488215488223*G0_0_1_2_0 + 0.00923520923520954*G0_0_1_2_1 - 0.278595478595487*G0_0_1_2_2 - 0.018470418470419*G0_0_1_2_3 - 0.116979316979321*G0_0_1_2_4 - 0.00615680615680643*G0_0_1_2_5 + 0.0178547378547385*G0_0_1_3_0 - 0.000615680615680701*G0_0_1_3_1 - 0.018470418470419*G0_0_1_3_2 + 0.0985088985089019*G0_0_1_3_3 - 0.119031585698257*G0_0_1_3_4 - 0.0233958633958643*G0_0_1_3_5 + 0.0724450857784217*G0_0_1_4_0 + 0.0416610549943898*G0_0_1_4_1 - 0.116979316979321*G0_0_1_4_2 - 0.119031585698257*G0_0_1_4_3 - 0.574635241301929*G0_0_1_4_4 - 0.071008497675167*G0_0_1_4_5 + 0.0152894019560693*G0_0_1_5_0 + 0.00790123456790139*G0_0_1_5_1 - 0.00615680615680643*G0_0_1_5_2 - 0.0233958633958643*G0_0_1_5_3 - 0.071008497675167*G0_0_1_5_4 - 0.00164181497514846*G0_0_1_5_5 - 0.186140772807446*G0_1_1_0_0 + 0.0126214526214531*G0_1_1_0_1 + 0.0342215808882487*G0_1_1_0_2 + 0.0181625781625788*G0_1_1_0_3 + 0.00564373897707264*G0_1_1_0_4 - 0.0837325637325666*G0_1_1_0_5 + 0.0126214526214531*G0_1_1_1_0 - 0.00790123456790172*G0_1_1_1_1 + 0.00779862113195471*G0_1_1_1_2 + 0.0156998556998562*G0_1_1_1_3 + 0.0542825076158428*G0_1_1_1_4 + 0.0427898027898042*G0_1_1_1_5 + 0.0342215808882487*G0_1_1_2_0 + 0.00779862113195471*G0_1_1_2_1 - 0.270386403719746*G0_1_1_2_2 - 0.0287317620650963*G0_1_1_2_3 - 0.0882475549142248*G0_1_1_2_4 + 0.00954304954304979*G0_1_1_2_5 + 0.0181625781625788*G0_1_1_3_0 + 0.0156998556998562*G0_1_1_3_1 - 0.0287317620650963*G0_1_1_3_2 + 0.0258585858585868*G0_1_1_3_3 - 0.144890171556843*G0_1_1_3_4 - 0.0554112554112573*G0_1_1_3_5 + 0.00564373897707264*G0_1_1_4_0 + 0.0542825076158428*G0_1_1_4_1 - 0.0882475549142249*G0_1_1_4_2 - 0.144890171556843*G0_1_1_4_3 - 0.511835818502503*G0_1_1_4_4 - 0.127651114317785*G0_1_1_4_5 - 0.0837325637325667*G0_1_1_5_0 + 0.0427898027898042*G0_1_1_5_1 + 0.00954304954304979*G0_1_1_5_2 - 0.0554112554112573*G0_1_1_5_3 - 0.127651114317785*G0_1_1_5_4 - 0.239294532627874*G0_1_1_5_5;
    A[97] = A[113] - 0.0411479878146559*G0_0_0_0_0 + 0.000615680615680633*G0_0_0_0_1 + 0.00728555395222095*G0_0_0_0_2 + 0.00820907487574185*G0_0_0_0_3 + 0.0297578964245642*G0_0_0_0_4 - 0.0103639570306241*G0_0_0_0_5 + 0.000615680615680633*G0_0_0_1_0 - 0.000513067179733879*G0_0_0_1_1 - 0.0156998556998562*G0_0_0_1_2 - 0.00143658810325481*G0_0_0_1_3 + 0.0110822510822515*G0_0_0_1_4 + 0.00708032708032732*G0_0_0_1_5 + 0.00728555395222095*G0_0_0_2_0 - 0.0156998556998562*G0_0_0_2_1 + 0.289369889369898*G0_0_0_2_2 + 0.0724450857784214*G0_0_0_2_3 - 0.0478178611511964*G0_0_0_2_4 - 0.000820907487574158*G0_0_0_2_5 + 0.00820907487574185*G0_0_0_3_0 - 0.00143658810325481*G0_0_0_3_1 + 0.0724450857784214*G0_0_0_3_2 - 0.021343594676929*G0_0_0_3_3 - 0.0385826519159867*G0_0_0_3_4 - 0.0147763347763353*G0_0_0_3_5 + 0.0297578964245642*G0_0_0_4_0 + 0.0110822510822515*G0_0_0_4_1 - 0.0478178611511965*G0_0_0_4_2 - 0.0385826519159867*G0_0_0_4_3 - 0.0738816738816768*G0_0_0_4_4 - 0.0205226871893546*G0_0_0_4_5 - 0.0103639570306241*G0_0_0_5_0 + 0.00708032708032732*G0_0_0_5_1 - 0.000820907487574158*G0_0_0_5_2 - 0.0147763347763353*G0_0_0_5_3 - 0.0205226871893546*G0_0_0_5_4 - 0.0238063171396513*G0_0_0_5_5 - 0.0133397466730809*G0_0_1_0_0 + 0.00790123456790155*G0_0_1_0_1 + 0.0072855539522209*G0_0_1_0_2 - 0.0155972422639095*G0_0_1_0_3 - 0.156998556998562*G0_0_1_0_4 - 0.0177521244187919*G0_0_1_0_5 + 0.00790123456790155*G0_0_1_1_0 - 0.000513067179733846*G0_0_1_1_1 - 0.0229854096520771*G0_0_1_1_2 - 0.00348885682219028*G0_0_1_1_3 + 0.0110822510822514*G0_0_1_1_4 + 0.00913259579926283*G0_0_1_1_5 + 0.0072855539522209*G0_0_1_2_0 - 0.0229854096520771*G0_0_1_2_1 + 0.261561648228323*G0_0_1_2_2 + 0.0798332531665893*G0_0_1_2_3 + 0.13893859227193*G0_0_1_2_4 + 0.0229854096520772*G0_0_1_2_5 - 0.0155972422639095*G0_0_1_3_0 - 0.00348885682219028*G0_0_1_3_1 + 0.0798332531665893*G0_0_1_3_2 - 0.00985088985089011*G0_0_1_3_3 + 0.00902998236331612*G0_0_1_3_4 - 0.0147763347763353*G0_0_1_3_5 - 0.156998556998562*G0_0_1_4_0 + 0.0110822510822514*G0_0_1_4_1 + 0.13893859227193*G0_0_1_4_2 + 0.00902998236331611*G0_0_1_4_3 - 0.0738816738816754*G0_0_1_4_4 - 0.068135321468657*G0_0_1_4_5 - 0.0177521244187919*G0_0_1_5_0 + 0.00913259579926283*G0_0_1_5_1 + 0.0229854096520772*G0_0_1_5_2 - 0.0147763347763353*G0_0_1_5_3 - 0.068135321468657*G0_0_1_5_4 - 0.03529902196569*G0_0_1_5_5 + 0.0307840307840323*G0_1_0_0_0 - 0.00697771364438058*G0_1_0_0_1 + 0.00728555395222092*G0_1_0_0_2 + 0.0153920153920159*G0_1_0_0_3 + 0.0663908930575621*G0_1_0_0_4 + 0.0180599647266322*G0_1_0_0_5 - 0.00697771364438058*G0_1_0_1_0 - 0.00051306717973389*G0_1_0_1_1 - 0.00810646143979498*G0_1_0_1_2 + 0.0037966971300306*G0_1_0_1_3 + 0.0110822510822515*G0_1_0_1_4 + 0.00184704184704187*G0_1_0_1_5 + 0.00728555395222092*G0_1_0_2_0 - 0.00810646143979498*G0_1_0_2_1 + 0.21743787077121*G0_1_0_2_2 + 0.0440211640211654*G0_1_0_2_3 - 0.0844508577841943*G0_1_0_2_4 - 0.00800384800384827*G0_1_0_2_5 + 0.0153920153920159*G0_1_0_3_0 + 0.0037966971300306*G0_1_0_3_1 + 0.0440211640211654*G0_1_0_3_2 - 0.0451499118165802*G0_1_0_3_3 - 0.0529485329485348*G0_1_0_3_4 - 0.0147763347763353*G0_1_0_3_5 + 0.0663908930575621*G0_1_0_4_0 + 0.0110822510822515*G0_1_0_4_1 - 0.0844508577841942*G0_1_0_4_2 - 0.0529485329485348*G0_1_0_4_3 - 0.0738816738816769*G0_1_0_4_4 - 0.00615680615680641*G0_1_0_4_5 + 0.0180599647266322*G0_1_0_5_0 + 0.00184704184704187*G0_1_0_5_1 - 0.00800384800384827*G0_1_0_5_2 - 0.0147763347763353*G0_1_0_5_3 - 0.00615680615680641*G0_1_0_5_4 - 0.230777617444292*G0_1_1_0_0 + 0.0160076960076965*G0_1_1_0_1 - 0.00759339426006114*G0_1_1_0_3 - 0.0725476992143684*G0_1_1_0_4 - 0.0617732884399573*G0_1_1_0_5 + 0.0160076960076965*G0_1_1_1_0 - 0.0160076960076965*G0_1_1_1_2 - 0.00533589866923221*G0_1_1_1_3 + 0.00533589866923217*G0_1_1_1_5 - 0.0160076960076965*G0_1_1_2_1 + 0.230777617444291*G0_1_1_2_2 + 0.0617732884399572*G0_1_1_2_3 + 0.0725476992143684*G0_1_1_2_4 + 0.00759339426006124*G0_1_1_2_5 - 0.00759339426006115*G0_1_1_3_0 - 0.0053358986692322*G0_1_1_3_1 + 0.0617732884399572*G0_1_1_3_2 - 0.00985088985089014*G0_1_1_3_3 + 0.0151867885201225*G0_1_1_3_4 - 0.0725476992143684*G0_1_1_4_0 + 0.0725476992143684*G0_1_1_4_2 + 0.0151867885201225*G0_1_1_4_3 - 0.0151867885201223*G0_1_1_4_5 - 0.0617732884399573*G0_1_1_5_0 + 0.00533589866923217*G0_1_1_5_1 + 0.00759339426006124*G0_1_1_5_2 - 0.0151867885201223*G0_1_1_5_4 + 0.00985088985088997*G0_1_1_5_5;
    A[111] = A[97] + 0.0543851210517903*G0_0_1_0_0 - 0.00784992784992818*G0_0_1_0_1 - 0.0258072791406134*G0_0_1_0_2 + 0.00954304954304987*G0_0_1_0_3 + 0.142632675966014*G0_0_1_0_4 + 0.0246272246272257*G0_0_1_0_5 - 0.00784992784992818*G0_0_1_1_0 + 0.00441237774571122*G0_0_1_1_1 + 0.00702902036235395*G0_0_1_1_2 - 0.00738816738816764*G0_0_1_1_3 - 0.0413532146865494*G0_0_1_1_4 - 0.0146737213403886*G0_0_1_1_5 - 0.0258072791406134*G0_0_1_2_0 + 0.00702902036235395*G0_0_1_2_1 + 0.010261343594677*G0_0_1_2_2 - 0.0111848645181983*G0_0_1_2_3 - 0.0807567740901101*G0_0_1_2_4 - 0.0214462081128755*G0_0_1_2_5 + 0.00954304954304987*G0_0_1_3_0 - 0.00738816738816764*G0_0_1_3_1 - 0.0111848645181983*G0_0_1_3_2 + 0.00738816738816761*G0_0_1_3_3 + 0.063620330286999*G0_0_1_3_4 + 0.0238063171396513*G0_0_1_3_5 + 0.142632675966014*G0_0_1_4_0 - 0.0413532146865494*G0_0_1_4_1 - 0.0807567740901101*G0_0_1_4_2 + 0.063620330286999*G0_0_1_4_3 + 0.625531505531526*G0_0_1_4_4 + 0.12559884559885*G0_0_1_4_5 + 0.0246272246272257*G0_0_1_5_0 - 0.0146737213403886*G0_0_1_5_1 - 0.0214462081128755*G0_0_1_5_2 + 0.0238063171396513*G0_0_1_5_3 + 0.12559884559885*G0_0_1_5_4 + 0.0426871893538578*G0_0_1_5_5 - 0.0543851210517903*G0_1_0_0_0 + 0.00784992784992818*G0_1_0_0_1 + 0.0258072791406134*G0_1_0_0_2 - 0.00954304954304987*G0_1_0_0_3 - 0.142632675966014*G0_1_0_0_4 - 0.0246272246272257*G0_1_0_0_5 + 0.00784992784992818*G0_1_0_1_0 - 0.00441237774571122*G0_1_0_1_1 - 0.00702902036235395*G0_1_0_1_2 + 0.00738816738816764*G0_1_0_1_3 + 0.0413532146865494*G0_1_0_1_4 + 0.0146737213403886*G0_1_0_1_5 + 0.0258072791406134*G0_1_0_2_0 - 0.00702902036235395*G0_1_0_2_1 - 0.010261343594677*G0_1_0_2_2 + 0.0111848645181983*G0_1_0_2_3 + 0.0807567740901101*G0_1_0_2_4 + 0.0214462081128755*G0_1_0_2_5 - 0.00954304954304987*G0_1_0_3_0 + 0.00738816738816764*G0_1_0_3_1 + 0.0111848645181983*G0_1_0_3_2 - 0.00738816738816764*G0_1_0_3_3 - 0.063620330286999*G0_1_0_3_4 - 0.0238063171396513*G0_1_0_3_5 - 0.142632675966014*G0_1_0_4_0 + 0.0413532146865494*G0_1_0_4_1 + 0.0807567740901101*G0_1_0_4_2 - 0.063620330286999*G0_1_0_4_3 - 0.625531505531526*G0_1_0_4_4 - 0.12559884559885*G0_1_0_4_5 - 0.0246272246272257*G0_1_0_5_0 + 0.0146737213403886*G0_1_0_5_1 + 0.0214462081128755*G0_1_0_5_2 - 0.0238063171396513*G0_1_0_5_3 - 0.12559884559885*G0_1_0_5_4 - 0.0426871893538578*G0_1_0_5_5;
    A[159] = A[97] - 0.357607824274504*G0_0_0_0_0 + 0.0317075517075527*G0_0_0_0_1 + 0.0118005451338789*G0_0_0_0_2 - 0.00605419272085956*G0_0_0_0_3 - 0.141606541606547*G0_0_0_0_4 - 0.0687510020843379*G0_0_0_0_5 + 0.0317075517075527*G0_0_0_1_0 - 0.161718775052114*G0_0_0_1_1 - 0.00584896584896603*G0_0_0_1_2 - 0.0978932178932212*G0_0_0_1_3 + 0.00277056277056288*G0_0_0_1_4 - 0.0173416706750047*G0_0_0_1_5 + 0.0118005451338789*G0_0_0_2_0 - 0.00584896584896603*G0_0_0_2_1 + 0.160795254128592*G0_0_0_2_2 + 0.115234888568226*G0_0_0_2_3 + 0.0971749238415938*G0_0_0_2_4 + 0.0407375340708689*G0_0_0_2_5 - 0.00605419272085956*G0_0_0_3_0 - 0.0978932178932212*G0_0_0_3_1 + 0.115234888568226*G0_0_0_3_2 + 0.00410453743787137*G0_0_0_3_3 + 0.00656725990059356*G0_0_0_3_4 - 0.0693666827000184*G0_0_0_3_5 - 0.141606541606547*G0_0_0_4_0 + 0.00277056277056288*G0_0_0_4_1 + 0.0971749238415938*G0_0_0_4_2 + 0.00656725990059357*G0_0_0_4_3 - 0.196196889530229*G0_0_0_4_4 - 0.0870161936828633*G0_0_0_4_5 - 0.0687510020843379*G0_0_0_5_0 - 0.0173416706750047*G0_0_0_5_1 + 0.0407375340708689*G0_0_0_5_2 - 0.0693666827000184*G0_0_0_5_3 - 0.0870161936828633*G0_0_0_5_4 - 0.360378387045067*G0_0_0_5_5 + 0.0312457912457923*G0_0_1_0_1 - 0.0312457912457923*G0_0_1_0_2 + 0.0944043610710309*G0_0_1_0_4 - 0.0944043610710309*G0_0_1_0_5 + 0.0312457912457923*G0_0_1_1_0 - 0.167054673721346*G0_0_1_1_1 - 0.102818662818666*G0_0_1_1_3 - 0.0309892576559254*G0_0_1_1_4 + 0.000410453743787039*G0_0_1_1_5 - 0.0312457912457923*G0_0_1_2_0 + 0.167054673721345*G0_0_1_2_2 + 0.102818662818666*G0_0_1_2_3 - 0.00041045374378699*G0_0_1_2_4 + 0.0309892576559255*G0_0_1_2_5 - 0.102818662818666*G0_0_1_3_1 + 0.102818662818666*G0_0_1_3_2 + 0.0619785153118508*G0_0_1_3_4 - 0.0619785153118507*G0_0_1_3_5 + 0.0944043610710309*G0_0_1_4_0 - 0.0309892576559254*G0_0_1_4_1 - 0.000410453743786995*G0_0_1_4_2 + 0.0619785153118508*G0_0_1_4_3 + 0.504858104858122*G0_0_1_4_4 - 0.094404361071031*G0_0_1_5_0 + 0.00041045374378704*G0_0_1_5_1 + 0.0309892576559255*G0_0_1_5_2 - 0.0619785153118507*G0_0_1_5_3 - 0.504858104858123*G0_0_1_5_5 + 0.0132884399551071*G0_1_0_0_1 - 0.013288439955107*G0_1_0_0_2 - 0.0236010902677579*G0_1_0_0_4 + 0.0236010902677577*G0_1_0_0_5 + 0.0132884399551071*G0_1_0_1_0 - 0.16120570787238*G0_1_0_1_1 - 0.106615359948697*G0_1_0_1_3 - 0.0110822510822515*G0_1_0_1_4 - 0.0656725990059347*G0_1_0_1_5 - 0.013288439955107*G0_1_0_2_0 + 0.16120570787238*G0_1_0_2_2 + 0.106615359948697*G0_1_0_2_3 + 0.0656725990059346*G0_1_0_2_4 + 0.0110822510822515*G0_1_0_2_5 - 0.106615359948697*G0_1_0_3_1 + 0.106615359948697*G0_1_0_3_2 + 0.022164502164503*G0_1_0_3_4 - 0.0221645021645029*G0_1_0_3_5 - 0.0236010902677579*G0_1_0_4_0 - 0.0110822510822515*G0_1_0_4_1 + 0.0656725990059346*G0_1_0_4_2 + 0.022164502164503*G0_1_0_4_3 - 0.077986211319547*G0_1_0_4_4 + 0.0236010902677577*G0_1_0_5_0 - 0.0656725990059347*G0_1_0_5_1 + 0.0110822510822515*G0_1_0_5_2 - 0.0221645021645029*G0_1_0_5_3 + 0.0779862113195472*G0_1_0_5_5 + 0.357607824274503*G0_1_1_0_0 - 0.0118005451338789*G0_1_1_0_1 - 0.0317075517075528*G0_1_1_0_2 + 0.00605419272085953*G0_1_1_0_3 + 0.0687510020843377*G0_1_1_0_4 + 0.141606541606547*G0_1_1_0_5 - 0.0118005451338789*G0_1_1_1_0 - 0.160795254128593*G0_1_1_1_1 + 0.00584896584896604*G0_1_1_1_2 - 0.115234888568226*G0_1_1_1_3 - 0.0407375340708688*G0_1_1_1_4 - 0.0971749238415939*G0_1_1_1_5 - 0.0317075517075528*G0_1_1_2_0 + 0.00584896584896605*G0_1_1_2_1 + 0.161718775052114*G0_1_1_2_2 + 0.0978932178932212*G0_1_1_2_3 + 0.0173416706750047*G0_1_1_2_4 - 0.00277056277056284*G0_1_1_2_5 + 0.00605419272085953*G0_1_1_3_0 - 0.115234888568226*G0_1_1_3_1 + 0.0978932178932212*G0_1_1_3_2 - 0.00410453743787079*G0_1_1_3_3 + 0.0693666827000183*G0_1_1_3_4 - 0.00656725990059345*G0_1_1_3_5 + 0.0687510020843377*G0_1_1_4_0 - 0.0407375340708688*G0_1_1_4_1 + 0.0173416706750047*G0_1_1_4_2 + 0.0693666827000184*G0_1_1_4_3 + 0.360378387045066*G0_1_1_4_4 + 0.0870161936828633*G0_1_1_4_5 + 0.141606541606547*G0_1_1_5_0 - 0.0971749238415939*G0_1_1_5_1 - 0.00277056277056284*G0_1_1_5_2 - 0.00656725990059345*G0_1_1_5_3 + 0.0870161936828633*G0_1_1_5_4 + 0.19619688953023*G0_1_1_5_5;
    A[79] = A[65] - 0.00441237774571122*G0_0_1_0_0 - 0.00702902036235392*G0_0_1_0_1 + 0.00784992784992808*G0_0_1_0_2 + 0.0413532146865493*G0_0_1_0_3 + 0.0146737213403885*G0_0_1_0_4 + 0.00738816738816761*G0_0_1_0_5 - 0.00702902036235392*G0_0_1_1_0 - 0.0102613435946772*G0_0_1_1_1 + 0.0258072791406134*G0_0_1_1_2 + 0.0807567740901102*G0_0_1_1_3 + 0.0214462081128755*G0_0_1_1_4 + 0.0111848645181983*G0_0_1_1_5 + 0.00784992784992808*G0_0_1_2_0 + 0.0258072791406134*G0_0_1_2_1 - 0.0543851210517894*G0_0_1_2_2 - 0.142632675966014*G0_0_1_2_3 - 0.0246272246272254*G0_0_1_2_4 - 0.00954304954304989*G0_0_1_2_5 + 0.0413532146865493*G0_0_1_3_0 + 0.0807567740901102*G0_0_1_3_1 - 0.142632675966014*G0_0_1_3_2 - 0.625531505531527*G0_0_1_3_3 - 0.12559884559885*G0_0_1_3_4 - 0.0636203302869992*G0_0_1_3_5 + 0.0146737213403885*G0_0_1_4_0 + 0.0214462081128755*G0_0_1_4_1 - 0.0246272246272254*G0_0_1_4_2 - 0.12559884559885*G0_0_1_4_3 - 0.0426871893538574*G0_0_1_4_4 - 0.0238063171396513*G0_0_1_4_5 + 0.00738816738816761*G0_0_1_5_0 + 0.0111848645181983*G0_0_1_5_1 - 0.00954304954304989*G0_0_1_5_2 - 0.0636203302869992*G0_0_1_5_3 - 0.0238063171396513*G0_0_1_5_4 - 0.00738816738816777*G0_0_1_5_5 + 0.00441237774571122*G0_1_0_0_0 + 0.00702902036235391*G0_1_0_0_1 - 0.00784992784992808*G0_1_0_0_2 - 0.0413532146865493*G0_1_0_0_3 - 0.0146737213403885*G0_1_0_0_4 - 0.00738816738816761*G0_1_0_0_5 + 0.00702902036235392*G0_1_0_1_0 + 0.0102613435946772*G0_1_0_1_1 - 0.0258072791406134*G0_1_0_1_2 - 0.0807567740901102*G0_1_0_1_3 - 0.0214462081128755*G0_1_0_1_4 - 0.0111848645181983*G0_1_0_1_5 - 0.00784992784992808*G0_1_0_2_0 - 0.0258072791406134*G0_1_0_2_1 + 0.0543851210517894*G0_1_0_2_2 + 0.142632675966014*G0_1_0_2_3 + 0.0246272246272254*G0_1_0_2_4 + 0.00954304954304989*G0_1_0_2_5 - 0.0413532146865493*G0_1_0_3_0 - 0.0807567740901102*G0_1_0_3_1 + 0.142632675966014*G0_1_0_3_2 + 0.625531505531527*G0_1_0_3_3 + 0.12559884559885*G0_1_0_3_4 + 0.0636203302869992*G0_1_0_3_5 - 0.0146737213403885*G0_1_0_4_0 - 0.0214462081128755*G0_1_0_4_1 + 0.0246272246272254*G0_1_0_4_2 + 0.12559884559885*G0_1_0_4_3 + 0.0426871893538574*G0_1_0_4_4 + 0.0238063171396513*G0_1_0_4_5 - 0.00738816738816761*G0_1_0_5_0 - 0.0111848645181983*G0_1_0_5_1 + 0.00954304954304989*G0_1_0_5_2 + 0.0636203302869992*G0_1_0_5_3 + 0.0238063171396513*G0_1_0_5_4 + 0.00738816738816777*G0_1_0_5_5;
    A[187] = A[117] - 0.0123136123136127*G0_0_1_0_0 - 0.00215488215488221*G0_0_1_0_1 - 0.0252429052429061*G0_0_1_0_2 + 0.0166233766233771*G0_0_1_0_3 + 0.183164983164989*G0_0_1_0_4 - 0.00769600769600815*G0_0_1_0_5 - 0.00215488215488221*G0_0_1_1_0 - 0.00677248677248708*G0_0_1_1_1 + 0.00277056277056289*G0_0_1_1_2 + 0.0138528138528143*G0_0_1_1_3 + 0.00861952861952887*G0_0_1_1_4 + 0.0243193843193851*G0_0_1_1_5 - 0.0252429052429061*G0_0_1_2_0 + 0.00277056277056289*G0_0_1_2_1 - 0.015392015392016*G0_0_1_2_2 - 0.00831168831168869*G0_0_1_2_3 - 0.0735738335738362*G0_0_1_2_4 + 0.00800384800384822*G0_0_1_2_5 + 0.0166233766233772*G0_0_1_3_0 + 0.0138528138528143*G0_0_1_3_1 - 0.00831168831168867*G0_0_1_3_2 - 0.0714189514189543*G0_0_1_3_3 - 0.0504858104858122*G0_0_1_3_4 - 0.0492544492544508*G0_0_1_3_5 + 0.183164983164989*G0_0_1_4_0 + 0.00861952861952887*G0_0_1_4_1 - 0.0735738335738362*G0_0_1_4_2 - 0.0504858104858122*G0_0_1_4_3 + 0.236421356421364*G0_0_1_4_4 - 0.0332467532467543*G0_0_1_4_5 - 0.00769600769600816*G0_0_1_5_0 + 0.0243193843193851*G0_0_1_5_1 + 0.00800384800384822*G0_0_1_5_2 - 0.0492544492544508*G0_0_1_5_3 - 0.0332467532467544*G0_0_1_5_4 - 0.14530062530063*G0_0_1_5_5 + 0.0123136123136127*G0_1_0_0_0 + 0.00215488215488221*G0_1_0_0_1 + 0.0252429052429061*G0_1_0_0_2 - 0.0166233766233772*G0_1_0_0_3 - 0.183164983164989*G0_1_0_0_4 + 0.00769600769600814*G0_1_0_0_5 + 0.00215488215488221*G0_1_0_1_0 + 0.00677248677248708*G0_1_0_1_1 - 0.00277056277056289*G0_1_0_1_2 - 0.0138528138528143*G0_1_0_1_3 - 0.00861952861952887*G0_1_0_1_4 - 0.0243193843193851*G0_1_0_1_5 + 0.0252429052429061*G0_1_0_2_0 - 0.00277056277056289*G0_1_0_2_1 + 0.015392015392016*G0_1_0_2_2 + 0.00831168831168869*G0_1_0_2_3 + 0.0735738335738362*G0_1_0_2_4 - 0.00800384800384822*G0_1_0_2_5 - 0.0166233766233772*G0_1_0_3_0 - 0.0138528138528143*G0_1_0_3_1 + 0.0083116883116887*G0_1_0_3_2 + 0.0714189514189543*G0_1_0_3_3 + 0.0504858104858122*G0_1_0_3_4 + 0.0492544492544508*G0_1_0_3_5 - 0.183164983164989*G0_1_0_4_0 - 0.00861952861952887*G0_1_0_4_1 + 0.0735738335738362*G0_1_0_4_2 + 0.0504858104858122*G0_1_0_4_3 - 0.236421356421364*G0_1_0_4_4 + 0.0332467532467543*G0_1_0_4_5 + 0.00769600769600814*G0_1_0_5_0 - 0.0243193843193851*G0_1_0_5_1 - 0.00800384800384822*G0_1_0_5_2 + 0.0492544492544508*G0_1_0_5_3 + 0.0332467532467543*G0_1_0_5_4 + 0.14530062530063*G0_1_0_5_5;
    A[82] = A[110] - 0.00615680615680635*G0_0_1_0_0 + 0.000307840307840302*G0_0_1_0_1 + 0.0042584575917911*G0_0_1_0_2 + 0.003591470258137*G0_0_1_0_3 + 0.00831168831168852*G0_0_1_0_4 - 0.00410453743787093*G0_0_1_0_5 + 0.000307840307840303*G0_0_1_1_0 - 0.00153920153920135*G0_0_1_1_1 - 0.0013852813852814*G0_0_1_1_2 + 0.0152894019560692*G0_0_1_1_3 - 0.00030784030784034*G0_0_1_1_4 - 0.000513067179733777*G0_0_1_1_5 + 0.0042584575917911*G0_0_1_2_0 - 0.0013852813852814*G0_0_1_2_1 + 0.224210357543697*G0_0_1_2_2 - 0.00615680615680655*G0_0_1_2_3 - 0.0256533589866933*G0_0_1_2_4 - 0.00338624338624347*G0_0_1_2_5 + 0.003591470258137*G0_0_1_3_0 + 0.0152894019560692*G0_0_1_3_1 - 0.00615680615680655*G0_0_1_3_2 - 0.14119608786276*G0_0_1_3_3 - 0.00656725990059335*G0_0_1_3_4 - 0.000410453743787053*G0_0_1_3_5 + 0.00831168831168852*G0_0_1_4_0 - 0.000307840307840339*G0_0_1_4_1 - 0.0256533589866933*G0_0_1_4_2 - 0.00656725990059336*G0_0_1_4_3 - 0.050896264229599*G0_0_1_4_4 + 0.00738816738816768*G0_0_1_4_5 - 0.00410453743787093*G0_0_1_5_0 - 0.000513067179733777*G0_0_1_5_1 - 0.00338624338624348*G0_0_1_5_2 - 0.000410453743787057*G0_0_1_5_3 + 0.00738816738816768*G0_0_1_5_4 - 0.00574635241301909*G0_0_1_5_5 + 0.00615680615680635*G0_1_0_0_0 - 0.000307840307840302*G0_1_0_0_1 - 0.0042584575917911*G0_1_0_0_2 - 0.003591470258137*G0_1_0_0_3 - 0.00831168831168852*G0_1_0_0_4 + 0.00410453743787093*G0_1_0_0_5 - 0.000307840307840303*G0_1_0_1_0 + 0.00153920153920135*G0_1_0_1_1 + 0.0013852813852814*G0_1_0_1_2 - 0.0152894019560692*G0_1_0_1_3 + 0.000307840307840335*G0_1_0_1_4 + 0.000513067179733776*G0_1_0_1_5 - 0.0042584575917911*G0_1_0_2_0 + 0.0013852813852814*G0_1_0_2_1 - 0.224210357543697*G0_1_0_2_2 + 0.00615680615680655*G0_1_0_2_3 + 0.0256533589866933*G0_1_0_2_4 + 0.00338624338624348*G0_1_0_2_5 - 0.003591470258137*G0_1_0_3_0 - 0.0152894019560692*G0_1_0_3_1 + 0.00615680615680655*G0_1_0_3_2 + 0.14119608786276*G0_1_0_3_3 + 0.00656725990059337*G0_1_0_3_4 + 0.000410453743787059*G0_1_0_3_5 - 0.00831168831168852*G0_1_0_4_0 + 0.000307840307840332*G0_1_0_4_1 + 0.0256533589866933*G0_1_0_4_2 + 0.00656725990059337*G0_1_0_4_3 + 0.050896264229599*G0_1_0_4_4 - 0.00738816738816768*G0_1_0_4_5 + 0.00410453743787093*G0_1_0_5_0 + 0.000513067179733776*G0_1_0_5_1 + 0.00338624338624348*G0_1_0_5_2 + 0.000410453743787059*G0_1_0_5_3 - 0.00738816738816768*G0_1_0_5_4 + 0.00574635241301909*G0_1_0_5_5;
    A[153] = A[82] - 0.0181625781625788*G0_0_0_0_0 + 0.0018983485650153*G0_0_0_0_1 + 0.00954304954304977*G0_0_0_0_2 + 0.00841430174763531*G0_0_0_0_3 - 0.0336572069905415*G0_0_0_0_4 + 0.0122109988776659*G0_0_0_0_5 + 0.0018983485650153*G0_0_0_1_0 + 0.122623055956393*G0_0_0_1_1 + 0.0133397466730804*G0_0_0_1_2 + 0.132371332371337*G0_0_0_1_3 + 0.00328362995029672*G0_0_0_1_4 - 0.00543851210517881*G0_0_0_1_5 + 0.00954304954304977*G0_0_0_2_0 + 0.0133397466730804*G0_0_0_2_1 - 0.458066378066392*G0_0_0_2_2 - 0.177316017316023*G0_0_0_2_3 - 0.001231361231361*G0_0_0_2_4 + 0.0143658810325481*G0_0_0_2_5 + 0.00841430174763531*G0_0_0_3_0 + 0.132371332371337*G0_0_0_3_1 - 0.177316017316023*G0_0_0_3_2 + 0.0332467532467544*G0_0_0_3_3 - 0.0233958633958641*G0_0_0_3_4 - 0.045560365560367*G0_0_0_3_5 - 0.0336572069905415*G0_0_0_4_0 + 0.00328362995029672*G0_0_0_4_1 - 0.001231361231361*G0_0_0_4_2 - 0.0233958633958641*G0_0_0_4_3 + 0.0406349206349225*G0_0_0_4_4 - 0.0352990219656898*G0_0_0_4_5 + 0.0122109988776659*G0_0_0_5_0 - 0.0054385121051788*G0_0_0_5_1 + 0.0143658810325481*G0_0_0_5_2 - 0.045560365560367*G0_0_0_5_3 - 0.0352990219656898*G0_0_0_5_4 - 0.127651114317785*G0_0_0_5_5 + 0.00097482764149435*G0_0_1_0_1 - 0.000974827641494415*G0_0_1_0_2 - 0.0247298380631723*G0_0_1_0_4 + 0.0247298380631721*G0_0_1_0_5 + 0.000974827641494347*G0_0_1_1_0 + 0.379156645823326*G0_0_1_1_1 + 0.146839826839832*G0_0_1_1_3 - 0.0080038480038483*G0_0_1_1_4 - 0.020625300625301*G0_0_1_1_5 - 0.000974827641494415*G0_0_1_2_0 - 0.379156645823324*G0_0_1_2_2 - 0.146839826839832*G0_0_1_2_3 + 0.0206253006253016*G0_0_1_2_4 + 0.00800384800384819*G0_0_1_2_5 + 0.146839826839832*G0_0_1_3_1 - 0.146839826839832*G0_0_1_3_2 + 0.0160076960076966*G0_0_1_3_4 - 0.0160076960076964*G0_0_1_3_5 - 0.0247298380631723*G0_0_1_4_0 - 0.0080038480038483*G0_0_1_4_1 + 0.0206253006253016*G0_0_1_4_2 + 0.0160076960076966*G0_0_1_4_3 + 0.151867885201224*G0_0_1_4_4 + 0.0247298380631721*G0_0_1_5_0 - 0.020625300625301*G0_0_1_5_1 + 0.00800384800384819*G0_0_1_5_2 - 0.0160076960076964*G0_0_1_5_3 - 0.151867885201224*G0_0_1_5_5 - 0.00297578964245642*G0_1_0_0_1 + 0.00297578964245635*G0_1_0_0_2 - 0.0123136123136128*G0_1_0_0_4 + 0.0123136123136126*G0_1_0_0_5 - 0.00297578964245642*G0_1_0_1_0 + 0.153407086740425*G0_1_0_1_1 + 0.168286034952707*G0_1_0_1_3 - 0.00492544492544512*G0_1_0_1_4 + 0.00451499118165825*G0_1_0_1_5 + 0.00297578964245635*G0_1_0_2_0 - 0.153407086740425*G0_1_0_2_2 - 0.168286034952707*G0_1_0_2_3 - 0.00451499118165782*G0_1_0_2_4 + 0.00492544492544501*G0_1_0_2_5 + 0.168286034952707*G0_1_0_3_1 - 0.168286034952707*G0_1_0_3_2 + 0.00985088985089033*G0_1_0_3_4 - 0.00985088985088996*G0_1_0_3_5 - 0.0123136123136128*G0_1_0_4_0 - 0.00492544492544512*G0_1_0_4_1 - 0.00451499118165782*G0_1_0_4_2 + 0.00985088985089034*G0_1_0_4_3 + 0.106717973384644*G0_1_0_4_4 + 0.0123136123136126*G0_1_0_5_0 + 0.00451499118165824*G0_1_0_5_1 + 0.00492544492544501*G0_1_0_5_2 - 0.00985088985088996*G0_1_0_5_3 - 0.106717973384643*G0_1_0_5_5 + 0.0181625781625787*G0_1_1_0_0 - 0.00954304954304989*G0_1_1_0_1 - 0.00189834856501533*G0_1_1_0_2 - 0.00841430174763542*G0_1_1_0_3 - 0.012210998877666*G0_1_1_0_4 + 0.0336572069905414*G0_1_1_0_5 - 0.00954304954304989*G0_1_1_1_0 + 0.458066378066394*G0_1_1_1_1 - 0.0133397466730805*G0_1_1_1_2 + 0.177316017316023*G0_1_1_1_3 - 0.0143658810325482*G0_1_1_1_4 + 0.00123136123136181*G0_1_1_1_5 - 0.00189834856501533*G0_1_1_2_0 - 0.0133397466730805*G0_1_1_2_1 - 0.122623055956393*G0_1_1_2_2 - 0.132371332371337*G0_1_1_2_3 + 0.0054385121051791*G0_1_1_2_4 - 0.0032836299502968*G0_1_1_2_5 - 0.00841430174763542*G0_1_1_3_0 + 0.177316017316023*G0_1_1_3_1 - 0.132371332371337*G0_1_1_3_2 - 0.0332467532467547*G0_1_1_3_3 + 0.0455603655603672*G0_1_1_3_4 + 0.0233958633958644*G0_1_1_3_5 - 0.012210998877666*G0_1_1_4_0 - 0.0143658810325482*G0_1_1_4_1 + 0.00543851210517911*G0_1_1_4_2 + 0.0455603655603672*G0_1_1_4_3 + 0.127651114317786*G0_1_1_4_4 + 0.0352990219656899*G0_1_1_4_5 + 0.0336572069905414*G0_1_1_5_0 + 0.0012313612313618*G0_1_1_5_1 - 0.0032836299502968*G0_1_1_5_2 + 0.0233958633958644*G0_1_1_5_3 + 0.0352990219656899*G0_1_1_5_4 - 0.0406349206349213*G0_1_1_5_5;
    A[100] = A[153] + 0.146531986531992*G0_0_0_0_0 - 0.0208305274971949*G0_0_0_0_2 - 0.00102613435946773*G0_0_0_0_3 + 0.116774090107427*G0_0_0_0_4 - 0.0213435946769285*G0_0_0_0_5 - 0.146531986531991*G0_0_0_1_1 + 0.0208305274971949*G0_0_0_1_2 - 0.116774090107428*G0_0_0_1_3 + 0.00102613435946771*G0_0_0_1_4 + 0.0213435946769285*G0_0_0_1_5 - 0.0208305274971949*G0_0_0_2_0 + 0.0208305274971949*G0_0_0_2_1 + 0.0324258457591803*G0_0_0_2_3 - 0.0324258457591801*G0_0_0_2_4 - 0.00102613435946773*G0_0_0_3_0 - 0.116774090107428*G0_0_0_3_1 + 0.0324258457591803*G0_0_0_3_2 - 0.255302228635571*G0_0_0_3_3 + 0.00205226871893523*G0_0_0_3_5 + 0.116774090107427*G0_0_0_4_0 + 0.00102613435946771*G0_0_0_4_1 - 0.0324258457591801*G0_0_0_4_2 + 0.25530222863557*G0_0_0_4_4 - 0.00205226871893551*G0_0_0_4_5 - 0.0213435946769285*G0_0_0_5_0 + 0.0213435946769284*G0_0_0_5_1 + 0.00205226871893523*G0_0_0_5_3 - 0.00205226871893551*G0_0_0_5_4 - 0.0225749559082898*G0_0_1_0_0 + 0.00538720538720558*G0_0_1_0_1 + 0.0055411255411257*G0_0_1_0_2 + 0.000307840307840333*G0_0_1_0_3 - 0.0283213083213092*G0_0_1_0_4 - 0.0376591309924654*G0_0_1_0_5 + 0.00538720538720558*G0_0_1_1_0 - 0.399474106140787*G0_0_1_1_1 + 0.0280647747314424*G0_0_1_1_2 - 0.143043129709801*G0_0_1_1_3 + 0.0083116883116886*G0_0_1_1_4 + 0.0176495109828445*G0_0_1_1_5 + 0.0055411255411257*G0_0_1_2_0 + 0.0280647747314424*G0_0_1_2_1 - 0.004514991181658*G0_0_1_2_2 + 0.0310918710918722*G0_0_1_2_3 + 0.014468494468495*G0_0_1_2_4 + 0.00153920153920165*G0_0_1_2_5 + 0.000307840307840335*G0_0_1_3_0 - 0.143043129709801*G0_0_1_3_1 + 0.0310918710918722*G0_0_1_3_2 - 0.192502805836146*G0_0_1_3_3 - 0.0172390572390578*G0_0_1_3_4 - 0.00369408369408407*G0_0_1_3_5 - 0.0283213083213092*G0_0_1_4_0 + 0.0083116883116886*G0_0_1_4_1 + 0.014468494468495*G0_0_1_4_2 - 0.0172390572390578*G0_0_1_4_3 - 0.0726503126503152*G0_0_1_4_4 - 0.0197017797017804*G0_0_1_4_5 - 0.0376591309924654*G0_0_1_5_0 + 0.0176495109828445*G0_0_1_5_1 + 0.00153920153920165*G0_0_1_5_2 - 0.00369408369408407*G0_0_1_5_3 - 0.0197017797017804*G0_0_1_5_4 + 0.136681096681101*G0_0_1_5_5 - 0.252942119608795*G0_1_0_0_0 + 0.00538720538720556*G0_1_0_0_1 + 0.0072342472342475*G0_1_0_0_2 + 0.00728555395222089*G0_1_0_0_3 - 0.0262690396023739*G0_1_0_0_4 - 0.00369408369408382*G0_1_0_0_5 + 0.00538720538720556*G0_1_0_1_0 - 0.169106942440281*G0_1_0_1_1 + 0.0263716530383206*G0_1_0_1_2 - 0.145095398428737*G0_1_0_1_3 + 0.00133397466730805*G0_1_0_1_4 - 0.0163155363155371*G0_1_0_1_5 + 0.0072342472342475*G0_1_0_2_0 + 0.0263716530383206*G0_1_0_2_1 - 0.00451499118165793*G0_1_0_2_2 + 0.0468943402276752*G0_1_0_2_3 - 0.00133397466730804*G0_1_0_2_4 + 0.00153920153920166*G0_1_0_2_5 + 0.00728555395222089*G0_1_0_3_0 - 0.145095398428737*G0_1_0_3_1 + 0.0468943402276752*G0_1_0_3_2 - 0.327952541285886*G0_1_0_3_3 - 0.0172390572390579*G0_1_0_3_4 - 0.0176495109828452*G0_1_0_3_5 - 0.0262690396023739*G0_1_0_4_0 + 0.00133397466730805*G0_1_0_4_1 - 0.00133397466730803*G0_1_0_4_2 - 0.0172390572390579*G0_1_0_4_3 + 0.0627994227994245*G0_1_0_4_4 - 0.00574635241301939*G0_1_0_4_5 - 0.00369408369408381*G0_1_0_5_0 - 0.0163155363155371*G0_1_0_5_1 + 0.00153920153920166*G0_1_0_5_2 - 0.0176495109828452*G0_1_0_5_3 - 0.00574635241301939*G0_1_0_5_4 + 0.136681096681101*G0_1_0_5_5 + 0.0493570626903972*G0_1_1_0_0 + 0.00538720538720561*G0_1_1_0_1 - 0.00205226871893544*G0_1_1_0_2 + 0.0074907808241144*G0_1_1_0_3 + 0.000102613435946657*G0_1_1_0_4 - 0.00102613435946771*G0_1_1_0_5 + 0.00538720538720561*G0_1_1_1_0 - 0.471406124739474*G0_1_1_1_1 + 0.0356581689915035*G0_1_1_1_2 - 0.171467051467057*G0_1_1_1_3 + 0.00112874779541454*G0_1_1_1_4 - 0.0189834856501534*G0_1_1_1_5 - 0.00205226871893544*G0_1_1_2_0 + 0.0356581689915035*G0_1_1_2_1 - 0.004514991181658*G0_1_1_2_2 + 0.0363251563251576*G0_1_1_2_3 + 0.00923520923520961*G0_1_1_2_4 + 0.00153920153920169*G0_1_1_2_5 + 0.0074907808241144*G0_1_1_3_0 - 0.171467051467057*G0_1_1_3_1 + 0.0363251563251576*G0_1_1_3_2 - 0.216309122975797*G0_1_1_3_3 - 0.0172390572390578*G0_1_1_3_4 - 0.0180599647266323*G0_1_1_3_5 + 0.000102613435946659*G0_1_1_4_0 + 0.00112874779541454*G0_1_1_4_1 + 0.00923520923520961*G0_1_1_4_2 - 0.0172390572390578*G0_1_1_4_3 - 0.048843995510664*G0_1_1_4_4 - 0.00533589866923235*G0_1_1_4_5 - 0.00102613435946771*G0_1_1_5_0 - 0.0189834856501534*G0_1_1_5_1 + 0.00153920153920169*G0_1_1_5_2 - 0.0180599647266323*G0_1_1_5_3 - 0.00533589866923235*G0_1_1_5_4 + 0.1366810966811*G0_1_1_5_5;
    A[163] = -A[153] + 0.060952380952383*G0_0_0_0_0 - 0.0185217251883925*G0_0_0_0_2 + 0.0263716530383205*G0_0_0_0_3 + 0.0733686067019426*G0_0_0_0_4 + 0.0593105659772346*G0_0_0_0_5 - 0.0609523809523833*G0_0_0_1_1 + 0.0185217251883925*G0_0_0_1_2 - 0.0733686067019425*G0_0_0_1_3 - 0.0263716530383206*G0_0_0_1_4 - 0.0593105659772346*G0_0_0_1_5 - 0.0185217251883925*G0_0_0_2_0 + 0.0185217251883925*G0_0_0_2_1 + 0.0256533589866931*G0_0_0_2_3 - 0.0256533589866932*G0_0_0_2_4 + 0.0263716530383205*G0_0_0_3_0 - 0.0733686067019425*G0_0_0_3_1 + 0.0256533589866932*G0_0_0_3_2 - 0.217130030463371*G0_0_0_3_3 - 0.0527433060766412*G0_0_0_3_5 + 0.0733686067019426*G0_0_0_4_0 - 0.0263716530383206*G0_0_0_4_1 - 0.0256533589866932*G0_0_0_4_2 + 0.217130030463371*G0_0_0_4_4 + 0.0527433060766412*G0_0_0_4_5 + 0.0593105659772346*G0_0_0_5_0 - 0.0593105659772346*G0_0_0_5_1 - 0.0527433060766412*G0_0_0_5_3 + 0.0527433060766412*G0_0_0_5_4 - 0.0039506172839512*G0_0_1_0_0 + 0.0356068622735301*G0_0_1_0_1 - 0.00877344877344903*G0_0_1_0_2 + 0.0244219977553318*G0_0_1_0_3 + 0.01303190636524*G0_0_1_0_4 + 0.123649190315861*G0_0_1_0_5 + 0.0356068622735301*G0_0_1_1_0 + 0.162385762385768*G0_0_1_1_1 + 0.0129805996472667*G0_0_1_1_2 - 0.0630046496713184*G0_0_1_1_3 - 0.0175468975468982*G0_0_1_1_4 - 0.226365239698581*G0_0_1_1_5 - 0.00877344877344903*G0_0_1_2_0 + 0.0129805996472667*G0_0_1_2_1 - 0.00774731441398138*G0_0_1_2_2 + 0.0355042488375833*G0_0_1_2_3 + 0.00451499118165798*G0_0_1_2_4 + 0.039711399711401*G0_0_1_2_5 + 0.0244219977553318*G0_0_1_3_0 - 0.0630046496713184*G0_0_1_3_1 + 0.0355042488375833*G0_0_1_3_2 - 0.274798781465457*G0_0_1_3_3 - 0.0137502004168675*G0_0_1_3_4 - 0.128266794933466*G0_0_1_3_5 + 0.01303190636524*G0_0_1_4_0 - 0.0175468975468981*G0_0_1_4_1 + 0.00451499118165798*G0_0_1_4_2 - 0.0137502004168675*G0_0_1_4_3 + 0.00389931056597742*G0_0_1_4_4 - 0.0443290043290057*G0_0_1_4_5 + 0.123649190315861*G0_0_1_5_0 - 0.226365239698581*G0_0_1_5_1 + 0.039711399711401*G0_0_1_5_2 - 0.128266794933466*G0_0_1_5_3 - 0.0443290043290057*G0_0_1_5_4 - 0.665140291806982*G0_0_1_5_5 - 0.0131858265191603*G0_1_0_0_0 + 0.00610549943883298*G0_1_0_0_1 - 0.0063107263107265*G0_1_0_0_2 + 0.028834375501043*G0_1_0_0_3 + 0.0088247554914224*G0_1_0_0_4 + 0.0417636684303364*G0_1_0_0_5 + 0.00610549943883298*G0_1_0_1_0 - 0.0741382074715437*G0_1_0_1_1 + 0.012210998877666*G0_1_0_1_2 - 0.0645438512105201*G0_1_0_1_3 + 0.00246272246272255*G0_1_0_1_4 - 0.0175468975468982*G0_1_0_1_5 - 0.0063107263107265*G0_1_0_2_0 + 0.012210998877666*G0_1_0_2_1 - 0.0129805996472667*G0_1_0_2_2 + 0.0445342312008993*G0_1_0_2_3 + 0.0188808722142062*G0_1_0_2_4 + 0.0486387686387703*G0_1_0_2_5 + 0.028834375501043*G0_1_0_3_0 - 0.0645438512105201*G0_1_0_3_1 + 0.0445342312008993*G0_1_0_3_2 - 0.278903318903328*G0_1_0_3_3 - 0.0625941959275313*G0_1_0_3_4 - 0.154946288279627*G0_1_0_3_5 + 0.00882475549142241*G0_1_0_4_0 + 0.00246272246272255*G0_1_0_4_1 + 0.0188808722142062*G0_1_0_4_2 - 0.0625941959275313*G0_1_0_4_3 - 0.0617732884399575*G0_1_0_4_4 - 0.102202982202986*G0_1_0_4_5 + 0.0417636684303364*G0_1_0_5_0 - 0.0175468975468982*G0_1_0_5_1 + 0.0486387686387703*G0_1_0_5_2 - 0.154946288279627*G0_1_0_5_3 - 0.102202982202986*G0_1_0_5_4 - 0.377822671156017*G0_1_0_5_5 - 0.0323232323232333*G0_1_1_0_0 + 0.0295013628346971*G0_1_1_0_1 - 0.00805515472182165*G0_1_1_0_2 + 0.0327336860670204*G0_1_1_0_3 + 0.00708032708032731*G0_1_1_0_4 + 0.127958954625626*G0_1_1_0_5 + 0.0295013628346971*G0_1_1_1_0 + 0.246272246272255*G0_1_1_1_1 + 0.00795254128587485*G0_1_1_1_2 - 0.048228314894983*G0_1_1_1_3 - 0.011287477954145*G0_1_1_1_4 - 0.173416706750046*G0_1_1_1_5 - 0.00805515472182165*G0_1_1_2_0 + 0.00795254128587486*G0_1_1_2_1 - 0.0124162257495595*G0_1_1_2_2 + 0.0491518358185041*G0_1_1_2_3 + 0.0138528138528143*G0_1_1_2_4 + 0.0725476992143683*G0_1_1_2_5 + 0.0327336860670204*G0_1_1_3_0 - 0.048228314894983*G0_1_1_3_1 + 0.0491518358185041*G0_1_1_3_2 - 0.378438351771698*G0_1_1_3_3 - 0.0428924162257509*G0_1_1_3_4 - 0.210562770562778*G0_1_1_3_5 + 0.00708032708032731*G0_1_1_4_0 - 0.011287477954145*G0_1_1_4_1 + 0.0138528138528143*G0_1_1_4_2 - 0.042892416225751*G0_1_1_4_3 - 0.0225749559082899*G0_1_1_4_4 - 0.122520442520447*G0_1_1_4_5 + 0.127958954625625*G0_1_1_5_0 - 0.173416706750046*G0_1_1_5_1 + 0.0725476992143683*G0_1_1_5_2 - 0.210562770562778*G0_1_1_5_3 - 0.122520442520447*G0_1_1_5_4 - 1.33069103735775*G0_1_1_5_5;
    A[205] = A[163] - 0.0153920153920155*G0_0_1_0_0 - 0.0252429052429061*G0_0_1_0_1 + 0.00277056277056286*G0_0_1_0_2 + 0.00800384800384825*G0_0_1_0_3 - 0.00831168831168852*G0_0_1_0_4 - 0.0735738335738362*G0_0_1_0_5 - 0.0252429052429061*G0_0_1_1_0 - 0.0123136123136128*G0_0_1_1_1 - 0.00215488215488222*G0_0_1_1_2 - 0.00769600769600806*G0_0_1_1_3 + 0.0166233766233772*G0_0_1_1_4 + 0.183164983164989*G0_0_1_1_5 + 0.00277056277056286*G0_0_1_2_0 - 0.00215488215488222*G0_0_1_2_1 - 0.00677248677248698*G0_0_1_2_2 + 0.0243193843193852*G0_0_1_2_3 + 0.0138528138528143*G0_0_1_2_4 + 0.00861952861952892*G0_0_1_2_5 + 0.00800384800384825*G0_0_1_3_0 - 0.00769600769600806*G0_0_1_3_1 + 0.0243193843193852*G0_0_1_3_2 - 0.14530062530063*G0_0_1_3_3 - 0.0492544492544509*G0_0_1_3_4 - 0.0332467532467545*G0_0_1_3_5 - 0.00831168831168852*G0_0_1_4_0 + 0.0166233766233772*G0_0_1_4_1 + 0.0138528138528143*G0_0_1_4_2 - 0.0492544492544509*G0_0_1_4_3 - 0.0714189514189545*G0_0_1_4_4 - 0.0504858104858123*G0_0_1_4_5 - 0.0735738335738362*G0_0_1_5_0 + 0.183164983164989*G0_0_1_5_1 + 0.00861952861952892*G0_0_1_5_2 - 0.0332467532467545*G0_0_1_5_3 - 0.0504858104858123*G0_0_1_5_4 + 0.236421356421365*G0_0_1_5_5 + 0.0153920153920155*G0_1_0_0_0 + 0.0252429052429061*G0_1_0_0_1 - 0.00277056277056286*G0_1_0_0_2 - 0.00800384800384824*G0_1_0_0_3 + 0.00831168831168852*G0_1_0_0_4 + 0.0735738335738362*G0_1_0_0_5 + 0.0252429052429061*G0_1_0_1_0 + 0.0123136123136128*G0_1_0_1_1 + 0.00215488215488223*G0_1_0_1_2 + 0.00769600769600803*G0_1_0_1_3 - 0.0166233766233772*G0_1_0_1_4 - 0.183164983164989*G0_1_0_1_5 - 0.00277056277056286*G0_1_0_2_0 + 0.00215488215488222*G0_1_0_2_1 + 0.00677248677248699*G0_1_0_2_2 - 0.0243193843193852*G0_1_0_2_3 - 0.0138528138528143*G0_1_0_2_4 - 0.00861952861952892*G0_1_0_2_5 - 0.00800384800384824*G0_1_0_3_0 + 0.00769600769600803*G0_1_0_3_1 - 0.0243193843193852*G0_1_0_3_2 + 0.14530062530063*G0_1_0_3_3 + 0.0492544492544509*G0_1_0_3_4 + 0.0332467532467545*G0_1_0_3_5 + 0.00831168831168852*G0_1_0_4_0 - 0.0166233766233772*G0_1_0_4_1 - 0.0138528138528143*G0_1_0_4_2 + 0.0492544492544509*G0_1_0_4_3 + 0.0714189514189545*G0_1_0_4_4 + 0.0504858104858123*G0_1_0_4_5 + 0.0735738335738362*G0_1_0_5_0 - 0.183164983164989*G0_1_0_5_1 - 0.00861952861952892*G0_1_0_5_2 + 0.0332467532467545*G0_1_0_5_3 + 0.0504858104858123*G0_1_0_5_4 - 0.236421356421365*G0_1_0_5_5;
    A[68] = -A[65] + 0.00287317620650975*G0_0_1_0_0 + 0.0073368606701942*G0_0_1_0_1 - 0.00923520923520947*G0_0_1_0_2 - 0.0416610549943896*G0_0_1_0_3 + 0.00061568061568073*G0_0_1_0_4 - 0.00790123456790142*G0_0_1_0_5 + 0.0073368606701942*G0_0_1_1_0 + 0.00410453743787102*G0_0_1_1_1 - 0.0215488215488222*G0_0_1_1_2 - 0.0724450857784216*G0_0_1_1_3 - 0.0178547378547384*G0_0_1_1_4 - 0.0152894019560691*G0_0_1_1_5 - 0.00923520923520947*G0_0_1_2_0 - 0.0215488215488222*G0_0_1_2_1 + 0.278595478595487*G0_0_1_2_2 + 0.116979316979321*G0_0_1_2_3 + 0.0184704184704188*G0_0_1_2_4 + 0.00615680615680638*G0_0_1_2_5 - 0.0416610549943896*G0_0_1_3_0 - 0.0724450857784216*G0_0_1_3_1 + 0.116979316979321*G0_0_1_3_2 + 0.574635241301928*G0_0_1_3_3 + 0.119031585698256*G0_0_1_3_4 + 0.0710084976751669*G0_0_1_3_5 + 0.00061568061568073*G0_0_1_4_0 - 0.0178547378547384*G0_0_1_4_1 + 0.0184704184704188*G0_0_1_4_2 + 0.119031585698256*G0_0_1_4_3 - 0.0985088985089022*G0_0_1_4_4 + 0.0233958633958642*G0_0_1_4_5 - 0.00790123456790142*G0_0_1_5_0 - 0.0152894019560691*G0_0_1_5_1 + 0.00615680615680638*G0_0_1_5_2 + 0.0710084976751669*G0_0_1_5_3 + 0.0233958633958642*G0_0_1_5_4 + 0.00164181497514896*G0_0_1_5_5 - 0.0050280583613917*G0_1_1_0_0 + 0.0199583132916474*G0_1_1_0_1 - 0.00143658810325481*G0_1_1_0_2 + 0.0126214526214531*G0_1_1_0_3 + 0.0163155363155369*G0_1_1_0_4 + 0.0348885682219028*G0_1_1_0_5 + 0.0199583132916474*G0_1_1_1_0 - 0.182036235369576*G0_1_1_1_1 + 0.0126727593394265*G0_1_1_1_2 - 0.0668013468013495*G0_1_1_1_3 + 0.000307840307840323*G0_1_1_1_4 - 0.0990219656886364*G0_1_1_1_5 - 0.00143658810325481*G0_1_1_2_0 + 0.0126727593394265*G0_1_1_2_1 + 0.00820907487574147*G0_1_1_2_2 + 0.0287317620650965*G0_1_1_2_3 - 0.0102613435946774*G0_1_1_2_4 + 0.0156998556998562*G0_1_1_2_5 + 0.0126214526214531*G0_1_1_3_0 - 0.0668013468013495*G0_1_1_3_1 + 0.0287317620650965*G0_1_1_3_2 + 0.062799422799425*G0_1_1_3_3 - 0.0258585858585867*G0_1_1_3_4 - 0.0566426166426186*G0_1_1_3_5 + 0.0163155363155369*G0_1_1_4_0 + 0.000307840307840323*G0_1_1_4_1 - 0.0102613435946774*G0_1_1_4_2 - 0.0258585858585867*G0_1_1_4_3 - 0.0726503126503154*G0_1_1_4_4 - 0.032015392015393*G0_1_1_4_5 + 0.0348885682219028*G0_1_1_5_0 - 0.0990219656886364*G0_1_1_5_1 + 0.0156998556998562*G0_1_1_5_2 - 0.0566426166426186*G0_1_1_5_3 - 0.032015392015393*G0_1_1_5_4 - 0.237652717652726*G0_1_1_5_5;
    A[169] = A[68] - 0.00451499118165795*G0_0_0_0_0 - 0.00205226871893545*G0_0_0_0_1 + 0.0356581689915034*G0_0_0_0_2 + 0.00153920153920157*G0_0_0_0_3 + 0.0363251563251575*G0_0_0_0_4 + 0.0092352092352095*G0_0_0_0_5 - 0.00205226871893545*G0_0_0_1_0 + 0.0493570626903975*G0_0_0_1_1 + 0.00538720538720542*G0_0_0_1_2 - 0.00102613435946778*G0_0_0_1_3 + 0.00749078082411437*G0_0_0_1_4 + 0.000102613435946835*G0_0_0_1_5 + 0.0356581689915034*G0_0_0_2_0 + 0.00538720538720542*G0_0_0_2_1 - 0.471406124739472*G0_0_0_2_2 - 0.0189834856501525*G0_0_0_2_3 - 0.171467051467057*G0_0_0_2_4 + 0.00112874779541443*G0_0_0_2_5 + 0.00153920153920157*G0_0_0_3_0 - 0.00102613435946778*G0_0_0_3_1 - 0.0189834856501525*G0_0_0_3_2 + 0.136681096681102*G0_0_0_3_3 - 0.0180599647266319*G0_0_0_3_4 - 0.0053358986692321*G0_0_0_3_5 + 0.0363251563251575*G0_0_0_4_0 + 0.00749078082411437*G0_0_0_4_1 - 0.171467051467057*G0_0_0_4_2 - 0.0180599647266319*G0_0_0_4_3 - 0.216309122975796*G0_0_0_4_4 - 0.0172390572390578*G0_0_0_4_5 + 0.00923520923520949*G0_0_0_5_0 + 0.000102613435946835*G0_0_0_5_1 + 0.00112874779541443*G0_0_0_5_2 - 0.0053358986692321*G0_0_0_5_3 - 0.0172390572390578*G0_0_0_5_4 - 0.0488439955106636*G0_0_0_5_5 - 0.00928651595318296*G0_0_1_0_1 + 0.00928651595318287*G0_0_1_0_2 - 0.0105691839025177*G0_0_1_0_4 + 0.0105691839025175*G0_0_1_0_5 - 0.00928651595318296*G0_0_1_1_0 + 0.302299182299194*G0_0_1_1_1 + 0.00266794933461623*G0_0_1_1_3 + 0.000205226871893494*G0_0_1_1_4 + 0.0263716530383211*G0_0_1_1_5 + 0.00928651595318287*G0_0_1_2_0 - 0.302299182299191*G0_0_1_2_2 - 0.00266794933461572*G0_0_1_2_3 - 0.0263716530383203*G0_0_1_2_4 - 0.000205226871893567*G0_0_1_2_5 + 0.00266794933461623*G0_0_1_3_1 - 0.00266794933461572*G0_0_1_3_2 - 0.000410453743786983*G0_0_1_3_4 + 0.000410453743787153*G0_0_1_3_5 - 0.0105691839025177*G0_0_1_4_0 + 0.000205226871893494*G0_0_1_4_1 - 0.0263716530383203*G0_0_1_4_2 - 0.000410453743786983*G0_0_1_4_3 + 0.111643418310089*G0_0_1_4_4 + 0.0105691839025175*G0_0_1_5_0 + 0.0263716530383211*G0_0_1_5_1 - 0.000205226871893566*G0_0_1_5_2 + 0.000410453743787146*G0_0_1_5_3 - 0.111643418310089*G0_0_1_5_5 - 0.00759339426006117*G0_1_0_0_1 + 0.00759339426006116*G0_1_0_0_2 + 0.0052332852332854*G0_1_0_0_4 - 0.00523328523328541*G0_1_0_0_5 - 0.00759339426006117*G0_1_0_1_0 + 0.0719320185986875*G0_1_0_1_1 + 0.0366329966329979*G0_1_0_1_3 + 0.00718294051627408*G0_1_0_1_4 + 0.0284239217572561*G0_1_0_1_5 + 0.00759339426006116*G0_1_0_2_0 - 0.0719320185986871*G0_1_0_2_2 - 0.0366329966329977*G0_1_0_2_3 - 0.028423921757256*G0_1_0_2_4 - 0.00718294051627412*G0_1_0_2_5 + 0.0366329966329979*G0_1_0_3_1 - 0.0366329966329977*G0_1_0_3_2 - 0.0143658810325481*G0_1_0_3_4 + 0.0143658810325483*G0_1_0_3_5 + 0.0052332852332854*G0_1_0_4_0 + 0.00718294051627408*G0_1_0_4_1 - 0.028423921757256*G0_1_0_4_2 - 0.0143658810325481*G0_1_0_4_3 - 0.0238063171396513*G0_1_0_4_4 - 0.00523328523328541*G0_1_0_5_0 + 0.0284239217572561*G0_1_0_5_1 - 0.00718294051627412*G0_1_0_5_2 + 0.0143658810325483*G0_1_0_5_3 + 0.0238063171396514*G0_1_0_5_5 + 0.00451499118165786*G0_1_1_0_0 - 0.0356581689915036*G0_1_1_0_1 + 0.00205226871893544*G0_1_1_0_2 - 0.00153920153920167*G0_1_1_0_3 - 0.00923520923520962*G0_1_1_0_4 - 0.0363251563251577*G0_1_1_0_5 - 0.0356581689915036*G0_1_1_1_0 + 0.471406124739476*G0_1_1_1_1 - 0.00538720538720571*G0_1_1_1_2 + 0.0189834856501533*G0_1_1_1_3 - 0.00112874779541455*G0_1_1_1_4 + 0.171467051467058*G0_1_1_1_5 + 0.00205226871893544*G0_1_1_2_0 - 0.00538720538720571*G0_1_1_2_1 - 0.0493570626903972*G0_1_1_2_2 + 0.00102613435946787*G0_1_1_2_3 - 0.000102613435946635*G0_1_1_2_4 - 0.00749078082411444*G0_1_1_2_5 - 0.00153920153920167*G0_1_1_3_0 + 0.0189834856501533*G0_1_1_3_1 + 0.00102613435946787*G0_1_1_3_2 - 0.136681096681101*G0_1_1_3_3 + 0.00533589866923226*G0_1_1_3_4 + 0.0180599647266322*G0_1_1_3_5 - 0.00923520923520962*G0_1_1_4_0 - 0.00112874779541455*G0_1_1_4_1 - 0.000102613435946636*G0_1_1_4_2 + 0.00533589866923226*G0_1_1_4_3 + 0.0488439955106641*G0_1_1_4_4 + 0.0172390572390578*G0_1_1_4_5 - 0.0363251563251577*G0_1_1_5_0 + 0.171467051467058*G0_1_1_5_1 - 0.00749078082411444*G0_1_1_5_2 + 0.0180599647266322*G0_1_1_5_3 + 0.0172390572390578*G0_1_1_5_4 + 0.216309122975797*G0_1_1_5_5;
    A[71] = A[169] + 0.00153920153920152*G0_0_1_0_0 + 0.00138528138528151*G0_0_1_0_1 - 0.000307840307840316*G0_0_1_0_2 + 0.000307840307840317*G0_0_1_0_3 + 0.000513067179733889*G0_0_1_0_4 - 0.0152894019560691*G0_0_1_0_5 + 0.00138528138528151*G0_0_1_1_0 - 0.2242103575437*G0_0_1_1_1 - 0.00425845759179102*G0_0_1_1_2 + 0.025653358986693*G0_0_1_1_3 + 0.00338624338624353*G0_0_1_1_4 + 0.00615680615680585*G0_0_1_1_5 - 0.000307840307840316*G0_0_1_2_0 - 0.00425845759179102*G0_0_1_2_1 + 0.00615680615680632*G0_0_1_2_2 - 0.00831168831168862*G0_0_1_2_3 + 0.00410453743787087*G0_0_1_2_4 - 0.00359147025813705*G0_0_1_2_5 + 0.000307840307840319*G0_0_1_3_0 + 0.025653358986693*G0_0_1_3_1 - 0.00831168831168862*G0_0_1_3_2 + 0.0508962642295992*G0_0_1_3_3 - 0.00738816738816762*G0_0_1_3_4 + 0.00656725990059348*G0_0_1_3_5 + 0.000513067179733889*G0_0_1_4_0 + 0.00338624338624353*G0_0_1_4_1 + 0.00410453743787087*G0_0_1_4_2 - 0.00738816738816762*G0_0_1_4_3 + 0.00574635241301936*G0_0_1_4_4 + 0.000410453743787088*G0_0_1_4_5 - 0.0152894019560691*G0_0_1_5_0 + 0.00615680615680586*G0_0_1_5_1 - 0.00359147025813705*G0_0_1_5_2 + 0.00656725990059349*G0_0_1_5_3 + 0.000410453743787088*G0_0_1_5_4 + 0.141196087862759*G0_0_1_5_5 - 0.00153920153920152*G0_1_0_0_0 - 0.00138528138528151*G0_1_0_0_1 + 0.000307840307840316*G0_1_0_0_2 - 0.000307840307840319*G0_1_0_0_3 - 0.000513067179733889*G0_1_0_0_4 + 0.0152894019560691*G0_1_0_0_5 - 0.00138528138528151*G0_1_0_1_0 + 0.2242103575437*G0_1_0_1_1 + 0.00425845759179102*G0_1_0_1_2 - 0.025653358986693*G0_1_0_1_3 - 0.00338624338624353*G0_1_0_1_4 - 0.00615680615680585*G0_1_0_1_5 + 0.000307840307840316*G0_1_0_2_0 + 0.00425845759179102*G0_1_0_2_1 - 0.00615680615680632*G0_1_0_2_2 + 0.00831168831168862*G0_1_0_2_3 - 0.00410453743787087*G0_1_0_2_4 + 0.00359147025813705*G0_1_0_2_5 - 0.000307840307840319*G0_1_0_3_0 - 0.025653358986693*G0_1_0_3_1 + 0.00831168831168862*G0_1_0_3_2 - 0.0508962642295992*G0_1_0_3_3 + 0.00738816738816762*G0_1_0_3_4 - 0.00656725990059347*G0_1_0_3_5 - 0.000513067179733889*G0_1_0_4_0 - 0.00338624338624353*G0_1_0_4_1 - 0.00410453743787087*G0_1_0_4_2 + 0.00738816738816762*G0_1_0_4_3 - 0.00574635241301936*G0_1_0_4_4 - 0.000410453743787088*G0_1_0_4_5 + 0.0152894019560691*G0_1_0_5_0 - 0.00615680615680586*G0_1_0_5_1 + 0.00359147025813705*G0_1_0_5_2 - 0.00656725990059348*G0_1_0_5_3 - 0.000410453743787089*G0_1_0_5_4 - 0.141196087862759*G0_1_0_5_5;
    A[55] = A[153] + 0.00615680615680645*G0_0_1_0_0 - 0.00425845759179107*G0_0_1_0_1 - 0.000307840307840335*G0_0_1_0_2 - 0.00359147025813703*G0_0_1_0_3 + 0.00410453743787093*G0_0_1_0_4 - 0.00831168831168855*G0_0_1_0_5 - 0.00425845759179106*G0_0_1_1_0 - 0.224210357543699*G0_0_1_1_1 + 0.00138528138528145*G0_0_1_1_2 + 0.0061568061568063*G0_0_1_1_3 + 0.00338624338624352*G0_0_1_1_4 + 0.025653358986693*G0_0_1_1_5 - 0.000307840307840336*G0_0_1_2_0 + 0.00138528138528146*G0_0_1_2_1 + 0.00153920153920162*G0_0_1_2_2 - 0.0152894019560692*G0_0_1_2_3 + 0.000513067179733888*G0_0_1_2_4 + 0.0003078403078403*G0_0_1_2_5 - 0.00359147025813703*G0_0_1_3_0 + 0.0061568061568063*G0_0_1_3_1 - 0.0152894019560692*G0_0_1_3_2 + 0.14119608786276*G0_0_1_3_3 + 0.000410453743787114*G0_0_1_3_4 + 0.0065672599005935*G0_0_1_3_5 + 0.00410453743787093*G0_0_1_4_0 + 0.00338624338624352*G0_0_1_4_1 + 0.000513067179733887*G0_0_1_4_2 + 0.000410453743787113*G0_0_1_4_3 + 0.00574635241301951*G0_0_1_4_4 - 0.00738816738816761*G0_0_1_4_5 - 0.00831168831168855*G0_0_1_5_0 + 0.025653358986693*G0_0_1_5_1 + 0.0003078403078403*G0_0_1_5_2 + 0.0065672599005935*G0_0_1_5_3 - 0.0073881673881676*G0_0_1_5_4 + 0.0508962642295993*G0_0_1_5_5 - 0.00615680615680645*G0_1_0_0_0 + 0.00425845759179106*G0_1_0_0_1 + 0.000307840307840335*G0_1_0_0_2 + 0.00359147025813703*G0_1_0_0_3 - 0.00410453743787093*G0_1_0_0_4 + 0.00831168831168855*G0_1_0_0_5 + 0.00425845759179106*G0_1_0_1_0 + 0.224210357543699*G0_1_0_1_1 - 0.00138528138528145*G0_1_0_1_2 - 0.00615680615680633*G0_1_0_1_3 - 0.00338624338624352*G0_1_0_1_4 - 0.025653358986693*G0_1_0_1_5 + 0.000307840307840336*G0_1_0_2_0 - 0.00138528138528146*G0_1_0_2_1 - 0.00153920153920162*G0_1_0_2_2 + 0.0152894019560692*G0_1_0_2_3 - 0.000513067179733887*G0_1_0_2_4 - 0.000307840307840302*G0_1_0_2_5 + 0.00359147025813703*G0_1_0_3_0 - 0.00615680615680633*G0_1_0_3_1 + 0.0152894019560692*G0_1_0_3_2 - 0.14119608786276*G0_1_0_3_3 - 0.000410453743787112*G0_1_0_3_4 - 0.0065672599005935*G0_1_0_3_5 - 0.00410453743787093*G0_1_0_4_0 - 0.00338624338624352*G0_1_0_4_1 - 0.000513067179733887*G0_1_0_4_2 - 0.000410453743787115*G0_1_0_4_3 - 0.00574635241301951*G0_1_0_4_4 + 0.00738816738816761*G0_1_0_4_5 + 0.00831168831168855*G0_1_0_5_0 - 0.025653358986693*G0_1_0_5_1 - 0.000307840307840304*G0_1_0_5_2 - 0.0065672599005935*G0_1_0_5_3 + 0.00738816738816761*G0_1_0_5_4 - 0.0508962642295993*G0_1_0_5_5;
    A[175] = -A[55] - 0.186140772807446*G0_0_0_0_0 + 0.0342215808882487*G0_0_0_0_1 + 0.0126214526214531*G0_0_0_0_2 + 0.0181625781625787*G0_0_0_0_3 - 0.0837325637325666*G0_0_0_0_4 + 0.0056437389770724*G0_0_0_0_5 + 0.0342215808882487*G0_0_0_1_0 - 0.270386403719747*G0_0_0_1_1 + 0.00779862113195472*G0_0_0_1_2 - 0.0287317620650963*G0_0_0_1_3 + 0.00954304954304991*G0_0_0_1_4 - 0.0882475549142247*G0_0_0_1_5 + 0.0126214526214531*G0_0_0_2_0 + 0.00779862113195473*G0_0_0_2_1 - 0.00790123456790159*G0_0_0_2_2 + 0.0156998556998562*G0_0_0_2_3 + 0.0427898027898042*G0_0_0_2_4 + 0.0542825076158428*G0_0_0_2_5 + 0.0181625781625787*G0_0_0_3_0 - 0.0287317620650963*G0_0_0_3_1 + 0.0156998556998562*G0_0_0_3_2 + 0.0258585858585872*G0_0_0_3_3 - 0.0554112554112572*G0_0_0_3_4 - 0.144890171556843*G0_0_0_3_5 - 0.0837325637325666*G0_0_0_4_0 + 0.00954304954304991*G0_0_0_4_1 + 0.0427898027898042*G0_0_0_4_2 - 0.0554112554112572*G0_0_0_4_3 - 0.239294532627874*G0_0_0_4_4 - 0.127651114317785*G0_0_0_4_5 + 0.00564373897707239*G0_0_0_5_0 - 0.0882475549142247*G0_0_0_5_1 + 0.0542825076158428*G0_0_0_5_2 - 0.144890171556843*G0_0_0_5_3 - 0.127651114317785*G0_0_0_5_4 - 0.511835818502503*G0_0_0_5_5 - 0.00410453743787097*G0_0_1_0_0 + 0.0215488215488223*G0_0_1_0_1 - 0.00733686067019424*G0_0_1_0_2 + 0.0178547378547384*G0_0_1_0_3 + 0.0152894019560691*G0_0_1_0_4 + 0.0724450857784215*G0_0_1_0_5 + 0.0215488215488223*G0_0_1_1_0 - 0.278595478595488*G0_0_1_1_1 + 0.00923520923520954*G0_0_1_1_2 - 0.0184704184704191*G0_0_1_1_3 - 0.00615680615680631*G0_0_1_1_4 - 0.116979316979321*G0_0_1_1_5 - 0.00733686067019424*G0_0_1_2_0 + 0.00923520923520954*G0_0_1_2_1 - 0.0028731762065096*G0_0_1_2_2 - 0.000615680615680722*G0_0_1_2_3 + 0.00790123456790154*G0_0_1_2_4 + 0.0416610549943897*G0_0_1_2_5 + 0.0178547378547384*G0_0_1_3_0 - 0.018470418470419*G0_0_1_3_1 - 0.000615680615680722*G0_0_1_3_2 + 0.0985088985089023*G0_0_1_3_3 - 0.0233958633958642*G0_0_1_3_4 - 0.119031585698256*G0_0_1_3_5 + 0.0152894019560691*G0_0_1_4_0 - 0.00615680615680631*G0_0_1_4_1 + 0.00790123456790154*G0_0_1_4_2 - 0.0233958633958642*G0_0_1_4_3 - 0.0016418149751481*G0_0_1_4_4 - 0.0710084976751667*G0_0_1_4_5 + 0.0724450857784215*G0_0_1_5_0 - 0.116979316979321*G0_0_1_5_1 + 0.0416610549943897*G0_0_1_5_2 - 0.119031585698256*G0_0_1_5_3 - 0.0710084976751667*G0_0_1_5_4 - 0.574635241301928*G0_0_1_5_5;
    A[146] = -A[138] + 0.199890973224314*G0_0_0_0_0 - 0.0184704184704191*G0_0_0_0_1 - 0.0152551974774202*G0_0_0_0_2 - 0.00424135535246661*G0_0_0_0_3 + 0.0809962054406527*G0_0_0_0_4 + 0.0212067767623332*G0_0_0_0_5 - 0.0184704184704191*G0_0_0_1_0 + 0.116979316979321*G0_0_0_1_1 - 0.00212067767623329*G0_0_0_1_2 + 0.00547271658382778*G0_0_0_1_3 - 0.00506226284004081*G0_0_0_1_4 + 0.0273635829191394*G0_0_0_1_5 - 0.0152551974774202*G0_0_0_2_0 - 0.00212067767623329*G0_0_0_2_1 + 0.0102613435946774*G0_0_0_2_2 - 0.00123136123136123*G0_0_0_2_3 - 0.0250376783710125*G0_0_0_2_4 - 0.0253113142002039*G0_0_0_2_5 - 0.00424135535246661*G0_0_0_3_0 + 0.00547271658382779*G0_0_0_3_1 - 0.00123136123136122*G0_0_0_3_2 - 0.0596526107637243*G0_0_0_3_3 + 0.0186072363850147*G0_0_0_3_4 + 0.0591053391053411*G0_0_0_3_5 + 0.0809962054406527*G0_0_0_4_0 - 0.00506226284004081*G0_0_0_4_1 - 0.0250376783710125*G0_0_0_4_2 + 0.0186072363850147*G0_0_0_4_3 + 0.104528886751112*G0_0_0_4_4 + 0.0607471540804895*G0_0_0_4_5 + 0.0212067767623332*G0_0_0_5_0 + 0.0273635829191394*G0_0_0_5_1 - 0.0253113142002039*G0_0_0_5_2 + 0.0591053391053411*G0_0_0_5_3 + 0.0607471540804895*G0_0_0_5_4 + 0.154877879322329*G0_0_0_5_5 + 0.00697771364438048*G0_1_0_0_0 - 0.0177863288974406*G0_1_0_0_1 + 0.000752498530276312*G0_1_0_0_2 - 0.00246272246272251*G0_1_0_0_3 + 0.000684089572978519*G0_1_0_0_4 + 0.0276372187483308*G0_1_0_0_5 - 0.0177863288974406*G0_1_0_1_0 + 0.121083854417192*G0_1_0_1_1 - 0.00136817914595695*G0_1_0_1_2 - 0.00547271658382791*G0_1_0_1_4 + 0.0164181497514836*G0_1_0_1_5 + 0.000752498530276313*G0_1_0_2_0 - 0.00136817914595695*G0_1_0_2_1 + 0.00451499118165808*G0_1_0_2_2 + 0.00300999412110544*G0_1_0_2_3 - 0.00916680027791168*G0_1_0_2_4 - 0.027089947089948*G0_1_0_2_5 - 0.00246272246272251*G0_1_0_3_0 + 0.00300999412110544*G0_1_0_3_2 - 0.0755234888568254*G0_1_0_3_3 + 0.0158708780931008*G0_1_0_3_4 + 0.059105339105341*G0_1_0_3_5 + 0.000684089572978519*G0_1_0_4_0 - 0.00547271658382791*G0_1_0_4_1 - 0.00916680027791168*G0_1_0_4_2 + 0.0158708780931008*G0_1_0_4_3 + 0.0142290631179526*G0_1_0_4_4 + 0.0651253273475518*G0_1_0_4_5 + 0.0276372187483308*G0_1_0_5_0 + 0.0164181497514836*G0_1_0_5_1 - 0.027089947089948*G0_1_0_5_2 + 0.059105339105341*G0_1_0_5_3 + 0.0651253273475518*G0_1_0_5_4 + 0.220003206669881*G0_1_0_5_5;
    A[174] = A[146] + 0.0164181497514839*G0_0_1_0_0 - 0.0184020095131212*G0_0_1_0_1 - 0.00410453743787087*G0_0_1_0_3 + 0.0039677195232753*G0_0_1_0_4 + 0.0247640425418212*G0_0_1_0_5 - 0.0184020095131212*G0_0_1_1_0 + 0.0164181497514834*G0_0_1_1_1 + 0.00396771952327514*G0_0_1_1_3 - 0.00410453743787093*G0_0_1_1_4 + 0.0247640425418211*G0_0_1_1_5 + 0.00369408369408382*G0_0_1_2_2 - 0.00779862113195471*G0_0_1_2_3 - 0.00779862113195474*G0_0_1_2_4 - 0.0240799529688427*G0_0_1_2_5 - 0.00410453743787087*G0_0_1_3_0 + 0.00396771952327514*G0_0_1_3_1 - 0.00779862113195471*G0_0_1_3_2 + 0.0164181497514834*G0_0_1_3_3 + 0.0164181497514836*G0_0_1_3_4 + 0.0563689808134271*G0_0_1_3_5 + 0.00396771952327531*G0_0_1_4_0 - 0.00410453743787093*G0_0_1_4_1 - 0.00779862113195474*G0_0_1_4_2 + 0.0164181497514836*G0_0_1_4_3 + 0.0164181497514837*G0_0_1_4_4 + 0.0563689808134272*G0_0_1_4_5 + 0.0247640425418212*G0_0_1_5_0 + 0.0247640425418212*G0_0_1_5_1 - 0.0240799529688427*G0_0_1_5_2 + 0.0563689808134271*G0_0_1_5_3 + 0.0563689808134272*G0_0_1_5_4 + 0.232043183154302*G0_0_1_5_5 - 0.0164181497514839*G0_1_0_0_0 + 0.0184020095131212*G0_1_0_0_1 + 0.00410453743787087*G0_1_0_0_3 - 0.00396771952327531*G0_1_0_0_4 - 0.0247640425418212*G0_1_0_0_5 + 0.0184020095131212*G0_1_0_1_0 - 0.0164181497514835*G0_1_0_1_1 - 0.00396771952327514*G0_1_0_1_3 + 0.00410453743787093*G0_1_0_1_4 - 0.0247640425418212*G0_1_0_1_5 - 0.00369408369408383*G0_1_0_2_2 + 0.00779862113195471*G0_1_0_2_3 + 0.00779862113195474*G0_1_0_2_4 + 0.0240799529688427*G0_1_0_2_5 + 0.00410453743787087*G0_1_0_3_0 - 0.00396771952327514*G0_1_0_3_1 + 0.00779862113195471*G0_1_0_3_2 - 0.0164181497514834*G0_1_0_3_3 - 0.0164181497514836*G0_1_0_3_4 - 0.0563689808134271*G0_1_0_3_5 - 0.00396771952327531*G0_1_0_4_0 + 0.00410453743787093*G0_1_0_4_1 + 0.00779862113195475*G0_1_0_4_2 - 0.0164181497514836*G0_1_0_4_3 - 0.0164181497514837*G0_1_0_4_4 - 0.0563689808134272*G0_1_0_4_5 - 0.0247640425418212*G0_1_0_5_0 - 0.0247640425418212*G0_1_0_5_1 + 0.0240799529688427*G0_1_0_5_2 - 0.0563689808134271*G0_1_0_5_3 - 0.0563689808134272*G0_1_0_5_4 - 0.232043183154302*G0_1_0_5_5;
    A[119] = A[205] - 0.111438191438195*G0_0_0_0_0 - 0.00615680615680634*G0_0_0_0_1 + 0.0575661375661396*G0_0_0_0_2 + 0.0147763347763353*G0_0_0_0_3 + 0.0209331409331415*G0_0_0_0_4 - 0.0400192400192414*G0_0_0_0_5 - 0.00615680615680633*G0_0_0_1_0 + 0.171159211159217*G0_0_0_1_1 + 0.00277056277056299*G0_0_0_1_2 + 0.254891774891784*G0_0_0_1_3 + 0.102202982202986*G0_0_0_1_4 + 0.0677248677248702*G0_0_0_1_5 + 0.0575661375661396*G0_0_0_2_0 + 0.00277056277056298*G0_0_0_2_1 - 0.21179413179414*G0_0_0_2_2 - 0.2511976911977*G0_0_0_2_3 - 0.148994708994715*G0_0_0_2_4 + 0.00307840307840307*G0_0_0_2_5 + 0.0147763347763353*G0_0_0_3_0 + 0.254891774891784*G0_0_0_3_1 - 0.2511976911977*G0_0_0_3_2 - 0.128061568061574*G0_0_0_3_3 - 0.233958633958642*G0_0_0_3_4 - 0.0357094757094769*G0_0_0_3_5 + 0.0209331409331415*G0_0_0_4_0 + 0.102202982202986*G0_0_0_4_1 - 0.148994708994715*G0_0_0_4_2 - 0.233958633958642*G0_0_0_4_3 - 1.5071861471862*G0_0_0_4_4 - 0.210562770562778*G0_0_0_4_5 - 0.0400192400192414*G0_0_0_5_0 + 0.0677248677248702*G0_0_0_5_1 + 0.00307840307840306*G0_0_0_5_2 - 0.0357094757094769*G0_0_0_5_3 - 0.210562770562778*G0_0_0_5_4 - 0.150226070226075*G0_0_0_5_5 - 0.0153920153920159*G0_0_1_0_1 + 0.0153920153920158*G0_0_1_0_2 + 0.0206253006253012*G0_0_1_0_4 - 0.0206253006253014*G0_0_1_0_5 - 0.0153920153920159*G0_0_1_1_0 + 0.214564694564702*G0_0_1_1_1 + 0.277364117364127*G0_0_1_1_3 + 0.0412506012506026*G0_0_1_1_4 + 0.0409427609427627*G0_0_1_1_5 + 0.0153920153920159*G0_0_1_2_0 - 0.214564694564702*G0_0_1_2_2 - 0.277364117364127*G0_0_1_2_3 - 0.0409427609427623*G0_0_1_2_4 - 0.0412506012506027*G0_0_1_2_5 + 0.277364117364127*G0_0_1_3_1 - 0.277364117364127*G0_0_1_3_2 - 0.0825012025012052*G0_0_1_3_4 + 0.0825012025012054*G0_0_1_3_5 + 0.0206253006253012*G0_0_1_4_0 + 0.0412506012506026*G0_0_1_4_1 - 0.0409427609427623*G0_0_1_4_2 - 0.0825012025012052*G0_0_1_4_3 - 0.209331409331415*G0_0_1_4_4 - 0.0206253006253014*G0_0_1_5_0 + 0.0409427609427627*G0_0_1_5_1 - 0.0412506012506027*G0_0_1_5_2 + 0.0825012025012054*G0_0_1_5_3 + 0.209331409331417*G0_0_1_5_5 - 0.0434054834054849*G0_1_0_0_1 + 0.0434054834054848*G0_1_0_0_2 + 0.085887445887449*G0_1_0_0_4 - 0.0858874458874486*G0_1_0_0_5 - 0.0434054834054849*G0_1_0_1_0 + 0.209023569023576*G0_1_0_1_1 + 0.245348725348734*G0_1_0_1_3 + 0.0492544492544509*G0_1_0_1_4 + 0.210254930254938*G0_1_0_1_5 + 0.0434054834054848*G0_1_0_2_0 - 0.209023569023577*G0_1_0_2_2 - 0.245348725348734*G0_1_0_2_3 - 0.210254930254938*G0_1_0_2_4 - 0.049254449254451*G0_1_0_2_5 + 0.245348725348734*G0_1_0_3_1 - 0.245348725348734*G0_1_0_3_2 - 0.0985088985089021*G0_1_0_3_4 + 0.0985088985089018*G0_1_0_3_5 + 0.085887445887449*G0_1_0_4_0 + 0.0492544492544509*G0_1_0_4_1 - 0.210254930254938*G0_1_0_4_2 - 0.0985088985089021*G0_1_0_4_3 - 0.517171717171735*G0_1_0_4_4 - 0.0858874458874486*G0_1_0_5_0 + 0.210254930254938*G0_1_0_5_1 - 0.049254449254451*G0_1_0_5_2 + 0.0985088985089018*G0_1_0_5_3 + 0.517171717171736*G0_1_0_5_5 + 0.111438191438196*G0_1_1_0_0 - 0.0575661375661395*G0_1_1_0_1 + 0.00615680615680629*G0_1_1_0_2 - 0.0147763347763352*G0_1_1_0_3 + 0.0400192400192414*G0_1_1_0_4 - 0.0209331409331412*G0_1_1_0_5 - 0.0575661375661395*G0_1_1_1_0 + 0.211794131794139*G0_1_1_1_1 - 0.00277056277056281*G0_1_1_1_2 + 0.2511976911977*G0_1_1_1_3 - 0.00307840307840319*G0_1_1_1_4 + 0.148994708994714*G0_1_1_1_5 + 0.00615680615680629*G0_1_1_2_0 - 0.00277056277056281*G0_1_1_2_1 - 0.171159211159217*G0_1_1_2_2 - 0.254891774891784*G0_1_1_2_3 - 0.06772486772487*G0_1_1_2_4 - 0.102202982202986*G0_1_1_2_5 - 0.0147763347763352*G0_1_1_3_0 + 0.2511976911977*G0_1_1_3_1 - 0.254891774891784*G0_1_1_3_2 + 0.128061568061571*G0_1_1_3_3 + 0.0357094757094767*G0_1_1_3_4 + 0.233958633958642*G0_1_1_3_5 + 0.0400192400192414*G0_1_1_4_0 - 0.00307840307840319*G0_1_1_4_1 - 0.06772486772487*G0_1_1_4_2 + 0.0357094757094767*G0_1_1_4_3 + 0.150226070226075*G0_1_1_4_4 + 0.210562770562778*G0_1_1_4_5 - 0.0209331409331412*G0_1_1_5_0 + 0.148994708994714*G0_1_1_5_1 - 0.102202982202986*G0_1_1_5_2 + 0.233958633958642*G0_1_1_5_3 + 0.210562770562778*G0_1_1_5_4 + 1.5071861471862*G0_1_1_5_5;
    A[197] = -A[182] - 0.00102613435946772*G0_0_1_0_0 + 0.0023088023088024*G0_0_1_0_2 + 0.00318101651434995*G0_0_1_0_3 + 0.0132371332371336*G0_0_1_0_4 + 0.00205226871893544*G0_0_1_0_5 + 0.00102613435946775*G0_0_1_1_1 - 0.00230880230880239*G0_0_1_1_2 - 0.0132371332371337*G0_0_1_1_3 - 0.00318101651434995*G0_0_1_1_4 - 0.00205226871893543*G0_0_1_1_5 + 0.0023088023088024*G0_0_1_2_0 - 0.00230880230880239*G0_0_1_2_1 + 0.0256533589866932*G0_0_1_2_3 - 0.0256533589866932*G0_0_1_2_4 + 0.00318101651434995*G0_0_1_3_0 - 0.0132371332371337*G0_0_1_3_1 + 0.0256533589866932*G0_0_1_3_2 + 0.00205226871893548*G0_0_1_3_3 - 0.00636203302869988*G0_0_1_3_5 + 0.0132371332371336*G0_0_1_4_0 - 0.00318101651434995*G0_0_1_4_1 - 0.0256533589866932*G0_0_1_4_2 - 0.00205226871893557*G0_0_1_4_4 + 0.00636203302869988*G0_0_1_4_5 + 0.00205226871893544*G0_0_1_5_0 - 0.00205226871893543*G0_0_1_5_1 - 0.00636203302869988*G0_0_1_5_3 + 0.00636203302869989*G0_0_1_5_4 - 0.0200096200096208*G0_1_1_0_0 + 0.00995350328683699*G0_1_1_0_1 - 0.00395061728395071*G0_1_1_0_2 - 0.00123136123136128*G0_1_1_0_3 - 0.00554112554112573*G0_1_1_0_4 - 0.0136475869809209*G0_1_1_0_5 + 0.00995350328683699*G0_1_1_1_0 - 0.0189834856501531*G0_1_1_1_1 - 0.00625941959275312*G0_1_1_1_2 - 0.0187782587782595*G0_1_1_1_3 - 0.00441237774571124*G0_1_1_1_4 - 0.0156998556998563*G0_1_1_1_5 - 0.00395061728395071*G0_1_1_2_0 - 0.00625941959275312*G0_1_1_2_1 + 0.0672118005451359*G0_1_1_2_2 + 0.0425845759179107*G0_1_1_2_3 + 0.0169312169312174*G0_1_1_2_4 + 0.0104665704665708*G0_1_1_2_5 - 0.00123136123136128*G0_1_1_3_0 - 0.0187782587782595*G0_1_1_3_1 + 0.0425845759179107*G0_1_1_3_2 + 0.0184704184704192*G0_1_1_3_3 + 0.0112874779541451*G0_1_1_3_4 - 0.0184704184704191*G0_1_1_3_5 - 0.00554112554112573*G0_1_1_4_0 - 0.00441237774571124*G0_1_1_4_1 + 0.0169312169312174*G0_1_1_4_2 + 0.0112874779541451*G0_1_1_4_3 + 0.0164181497514837*G0_1_1_4_4 - 0.0121083854417191*G0_1_1_4_5 - 0.0136475869809209*G0_1_1_5_0 - 0.0156998556998563*G0_1_1_5_1 + 0.0104665704665708*G0_1_1_5_2 - 0.0184704184704191*G0_1_1_5_3 - 0.0121083854417191*G0_1_1_5_4 - 0.214667308000649*G0_1_1_5_5;
    A[195] = A[197] + 0.0336059002725682*G0_0_0_0_0 - 0.00123136123136129*G0_0_0_0_1 - 0.00546416546416564*G0_0_0_0_2 + 0.00682379349046036*G0_0_0_0_3 + 0.0231393298059972*G0_0_0_0_4 + 0.00661856661856689*G0_0_0_0_5 - 0.00123136123136129*G0_0_0_1_0 - 0.0222158088824763*G0_0_0_1_1 + 0.00474587141253824*G0_0_0_1_2 - 0.0225236491903166*G0_0_0_1_3 - 0.000666987333654026*G0_0_0_1_4 - 0.00354016354016368*G0_0_0_1_5 - 0.00546416546416564*G0_0_0_2_0 + 0.00474587141253824*G0_0_0_2_1 + 0.00430976430976441*G0_0_0_2_2 + 0.010363957030624*G0_0_0_2_3 - 0.0019496552829887*G0_0_0_2_4 - 0.00184704184704192*G0_0_0_2_5 + 0.00682379349046036*G0_0_0_3_0 - 0.0225236491903166*G0_0_0_3_1 + 0.010363957030624*G0_0_0_3_2 - 0.113490460157131*G0_0_0_3_3 - 0.0123136123136127*G0_0_0_3_4 - 0.00995350328683694*G0_0_0_3_5 + 0.0231393298059972*G0_0_0_4_0 - 0.000666987333654026*G0_0_0_4_1 - 0.0019496552829887*G0_0_0_4_2 - 0.0123136123136127*G0_0_0_4_3 + 0.00595157928491275*G0_0_0_4_4 + 0.0050280583613919*G0_0_0_4_5 + 0.00661856661856689*G0_0_0_5_0 - 0.00354016354016368*G0_0_0_5_1 - 0.00184704184704192*G0_0_0_5_2 - 0.00995350328683694*G0_0_0_5_3 + 0.0050280583613919*G0_0_0_5_4 + 0.0127240660573999*G0_0_0_5_5 + 0.035709475709477*G0_0_1_0_0 - 0.00169312169312175*G0_0_1_0_1 - 0.00820907487574182*G0_0_1_0_2 + 0.00554112554112567*G0_0_1_0_3 + 0.0231906365239706*G0_0_1_0_4 + 0.00810646143979507*G0_0_1_0_5 - 0.00169312169312175*G0_0_1_1_0 - 0.0211383678050352*G0_0_1_1_1 + 0.00430976430976443*G0_0_1_1_2 - 0.00923520923520949*G0_0_1_1_3 + 0.00123136123136125*G0_0_1_1_4 - 0.00820907487574182*G0_0_1_2_0 + 0.00430976430976443*G0_0_1_2_1 + 0.00430976430976478*G0_0_1_2_2 - 0.00246272246272253*G0_0_1_2_3 + 0.010877024210358*G0_0_1_2_4 + 0.00133397466730802*G0_0_1_2_5 + 0.00554112554112567*G0_0_1_3_0 - 0.00923520923520949*G0_0_1_3_1 - 0.00246272246272253*G0_0_1_3_2 - 0.113285233285237*G0_0_1_3_3 - 0.0135449735449739*G0_0_1_3_4 - 0.0137502004168674*G0_0_1_3_5 + 0.0231906365239706*G0_0_1_4_0 + 0.00123136123136125*G0_0_1_4_1 + 0.010877024210358*G0_0_1_4_2 - 0.0135449735449739*G0_0_1_4_3 + 0.00820907487574167*G0_0_1_4_4 - 0.00513067179733853*G0_0_1_4_5 + 0.00810646143979507*G0_0_1_5_0 + 0.00133397466730802*G0_0_1_5_2 - 0.0137502004168674*G0_0_1_5_3 - 0.00513067179733853*G0_0_1_5_4 + 0.000410453743787271*G0_0_1_5_5 + 0.0336059002725677*G0_1_0_0_0 - 0.000795254128587483*G0_1_0_0_1 - 0.00271925605258946*G0_1_0_0_2 + 0.0036427769761104*G0_1_0_0_3 + 0.0103126503126506*G0_1_0_0_4 + 0.0194452461119134*G0_1_0_0_5 - 0.000795254128587482*G0_1_0_1_0 - 0.0232932499599174*G0_1_0_1_1 + 0.00520763187429871*G0_1_0_1_2 - 0.0260638127304802*G0_1_0_1_3 - 0.00256533589866931*G0_1_0_1_4 - 0.0168286034952707*G0_1_0_1_5 - 0.00271925605258946*G0_1_0_2_0 + 0.00520763187429871*G0_1_0_2_1 + 0.00220618887285558*G0_1_0_2_2 + 0.0088760622093958*G0_1_0_2_3 - 0.00200096200096206*G0_1_0_2_4 - 0.000564373897707251*G0_1_0_2_5 + 0.0036427769761104*G0_1_0_3_0 - 0.0260638127304802*G0_1_0_3_1 + 0.0088760622093958*G0_1_0_3_2 - 0.101176847843518*G0_1_0_3_3 - 0.00215488215488221*G0_1_0_3_4 - 0.00615680615680636*G0_1_0_3_5 + 0.0103126503126506*G0_1_0_4_0 - 0.00256533589866931*G0_1_0_4_1 - 0.00200096200096206*G0_1_0_4_2 - 0.00215488215488221*G0_1_0_4_3 + 0.0036940836940838*G0_1_0_4_4 + 0.00625941959275314*G0_1_0_4_5 + 0.0194452461119134*G0_1_0_5_0 - 0.0168286034952707*G0_1_0_5_1 - 0.00056437389770725*G0_1_0_5_2 - 0.00615680615680636*G0_1_0_5_3 + 0.00625941959275314*G0_1_0_5_4 + 0.0125188391855062*G0_1_0_5_5 + 0.0313997113997121*G0_1_1_0_0 - 0.00600288600288623*G0_1_1_0_1 + 0.00420715087381762*G0_1_1_0_3 + 0.0123136123136126*G0_1_1_0_4 + 0.0105691839025175*G0_1_1_0_5 - 0.00600288600288622*G0_1_1_1_0 + 0.00600288600288615*G0_1_1_1_2 - 0.00923520923520944*G0_1_1_1_3 + 0.00923520923520972*G0_1_1_1_5 + 0.00600288600288616*G0_1_1_2_1 - 0.0313997113997121*G0_1_1_2_2 - 0.0105691839025176*G0_1_1_2_3 - 0.0123136123136126*G0_1_1_2_4 - 0.00420715087381771*G0_1_1_2_5 + 0.00420715087381762*G0_1_1_3_0 - 0.00923520923520943*G0_1_1_3_1 - 0.0105691839025176*G0_1_1_3_2 - 0.113695687029024*G0_1_1_3_3 - 0.00841430174763531*G0_1_1_3_4 + 0.0123136123136126*G0_1_1_4_0 - 0.0123136123136126*G0_1_1_4_2 - 0.00841430174763531*G0_1_1_4_3 + 0.00841430174763538*G0_1_1_4_5 + 0.0105691839025175*G0_1_1_5_0 + 0.00923520923520973*G0_1_1_5_1 - 0.00420715087381771*G0_1_1_5_2 + 0.00841430174763538*G0_1_1_5_4 + 0.113695687029025*G0_1_1_5_5;
    A[14] = A[195] - 0.00148789482122821*G0_0_0_0_1 + 0.00466891133557814*G0_0_0_0_2 - 0.00318101651434995*G0_0_0_0_3 - 0.00369408369408378*G0_0_0_0_4 + 0.00369408369408388*G0_0_0_0_5 - 0.00148789482122821*G0_0_0_1_0 + 0.0244219977553319*G0_0_0_1_1 + 0.000461760461760484*G0_0_0_1_2 + 0.0313997113997124*G0_0_0_1_3 + 0.000102613435946763*G0_0_0_1_4 + 0.0015392015392016*G0_0_0_1_5 + 0.00466891133557814*G0_0_0_2_0 + 0.000461760461760483*G0_0_0_2_1 - 0.0276030142696819*G0_0_0_2_2 - 0.0364277697611043*G0_0_0_2_3 - 0.014878948212282*G0_0_0_2_4 - 0.000718294051627412*G0_0_0_2_5 - 0.00318101651434995*G0_0_0_3_0 + 0.0313997113997124*G0_0_0_3_1 - 0.0364277697611043*G0_0_0_3_2 + 0.0123136123136126*G0_0_0_3_3 + 0.00615680615680637*G0_0_0_3_4 + 0.00779862113195471*G0_0_0_3_5 - 0.00369408369408378*G0_0_0_4_0 + 0.000102613435946763*G0_0_0_4_1 - 0.014878948212282*G0_0_0_4_2 + 0.00615680615680637*G0_0_0_4_3 + 0.00656725990059373*G0_0_0_4_4 + 0.00123136123136128*G0_0_0_4_5 + 0.00369408369408388*G0_0_0_5_0 + 0.0015392015392016*G0_0_0_5_1 - 0.000718294051627413*G0_0_0_5_2 + 0.00779862113195471*G0_0_0_5_3 + 0.00123136123136128*G0_0_0_5_4 - 0.00902998236331599*G0_0_0_5_5 - 0.00423280423280439*G0_0_1_0_1 + 0.00423280423280435*G0_0_1_0_2 - 0.0165207631874303*G0_0_1_0_4 + 0.0165207631874305*G0_0_1_0_5 - 0.00423280423280439*G0_0_1_1_0 + 0.0265255731922407*G0_0_1_1_1 + 0.0328876062209406*G0_0_1_1_3 - 0.0011800545133879*G0_0_1_1_4 + 0.00159050825717497*G0_0_1_1_5 + 0.00423280423280435*G0_0_1_2_0 - 0.0265255731922407*G0_0_1_2_2 - 0.0328876062209406*G0_0_1_2_3 - 0.00159050825717497*G0_0_1_2_4 + 0.00118005451338789*G0_0_1_2_5 + 0.0328876062209406*G0_0_1_3_1 - 0.0328876062209406*G0_0_1_3_2 + 0.00236010902677579*G0_0_1_3_4 - 0.00236010902677579*G0_0_1_3_5 - 0.0165207631874303*G0_0_1_4_0 - 0.0011800545133879*G0_0_1_4_1 - 0.00159050825717497*G0_0_1_4_2 + 0.00236010902677579*G0_0_1_4_3 + 0.00677248677248718*G0_0_1_4_4 + 0.0165207631874305*G0_0_1_5_0 + 0.00159050825717497*G0_0_1_5_1 + 0.00118005451338788*G0_0_1_5_2 - 0.0023601090267758*G0_0_1_5_3 - 0.00677248677248691*G0_0_1_5_5 - 0.00192400192400202*G0_1_0_0_1 + 0.00192400192400195*G0_1_0_0_2 + 0.00913259579926289*G0_1_0_0_4 - 0.00913259579926262*G0_1_0_0_5 - 0.00192400192400202*G0_1_0_1_0 + 0.025499438832773*G0_1_0_1_1 + 0.0349398749398761*G0_1_0_1_3 + 0.00200096200096205*G0_1_0_1_4 + 0.0148276414943087*G0_1_0_1_5 + 0.00192400192400195*G0_1_0_2_0 - 0.0254994388327731*G0_1_0_2_2 - 0.0349398749398761*G0_1_0_2_3 - 0.0148276414943087*G0_1_0_2_4 - 0.00200096200096208*G0_1_0_2_5 + 0.0349398749398761*G0_1_0_3_1 - 0.0349398749398761*G0_1_0_3_2 - 0.00400192400192414*G0_1_0_3_4 + 0.00400192400192413*G0_1_0_3_5 + 0.00913259579926289*G0_1_0_4_0 + 0.00200096200096205*G0_1_0_4_1 - 0.0148276414943087*G0_1_0_4_2 - 0.00400192400192414*G0_1_0_4_3 + 0.00882475549142257*G0_1_0_4_4 - 0.00913259579926262*G0_1_0_5_0 + 0.0148276414943087*G0_1_0_5_1 - 0.00200096200096208*G0_1_0_5_2 + 0.00400192400192413*G0_1_0_5_3 - 0.00882475549142233*G0_1_0_5_5 - 0.00466891133557819*G0_1_1_0_1 + 0.00148789482122817*G0_1_1_0_2 + 0.00318101651434996*G0_1_1_0_3 - 0.00369408369408367*G0_1_1_0_4 + 0.00369408369408404*G0_1_1_0_5 - 0.00466891133557819*G0_1_1_1_0 + 0.0276030142696818*G0_1_1_1_1 - 0.00046176046176045*G0_1_1_1_2 + 0.0364277697611042*G0_1_1_1_3 + 0.000718294051627379*G0_1_1_1_4 + 0.014878948212282*G0_1_1_1_5 + 0.00148789482122817*G0_1_1_2_0 - 0.000461760461760451*G0_1_1_2_1 - 0.024421997755332*G0_1_1_2_2 - 0.0313997113997125*G0_1_1_2_3 - 0.00153920153920162*G0_1_1_2_4 - 0.000102613435946786*G0_1_1_2_5 + 0.00318101651434996*G0_1_1_3_0 + 0.0364277697611042*G0_1_1_3_1 - 0.0313997113997125*G0_1_1_3_2 - 0.0123136123136129*G0_1_1_3_3 - 0.0077986211319547*G0_1_1_3_4 - 0.00615680615680637*G0_1_1_3_5 - 0.00369408369408368*G0_1_1_4_0 + 0.000718294051627378*G0_1_1_4_1 - 0.00153920153920162*G0_1_1_4_2 - 0.0077986211319547*G0_1_1_4_3 + 0.00902998236331611*G0_1_1_4_4 - 0.00123136123136121*G0_1_1_4_5 + 0.00369408369408404*G0_1_1_5_0 + 0.014878948212282*G0_1_1_5_1 - 0.000102613435946786*G0_1_1_5_2 - 0.00615680615680637*G0_1_1_5_3 - 0.00123136123136122*G0_1_1_5_4 - 0.00656725990059347*G0_1_1_5_5;
    A[19] = -A[25] + 0.0321628988295667*G0_0_0_0_0 - 0.00219015552348894*G0_0_0_0_1 - 0.00705788039121396*G0_0_0_0_2 - 0.00227032227032234*G0_0_0_0_3 + 0.0107487574154245*G0_0_0_0_4 + 0.0107231040564378*G0_0_0_0_5 - 0.00219015552348894*G0_0_0_1_0 + 0.151707551707557*G0_0_0_1_1 - 0.00975789642456342*G0_0_0_1_2 + 0.0334776334776346*G0_0_0_1_3 - 0.00616963283629972*G0_0_0_1_4 - 0.0055154721821389*G0_0_0_1_5 - 0.00705788039121396*G0_0_0_2_0 - 0.00975789642456342*G0_0_0_2_1 + 0.0351899951899963*G0_0_0_2_2 + 0.00328362995029672*G0_0_0_2_3 + 0.0113131313131317*G0_0_0_2_4 - 0.00355299021965701*G0_0_0_2_5 - 0.00227032227032234*G0_0_0_3_0 + 0.0334776334776346*G0_0_0_3_1 + 0.00328362995029672*G0_0_0_3_2 + 0.026576879910214*G0_0_0_3_3 + 0.0168799102132441*G0_0_0_3_4 + 0.0116466249799587*G0_0_0_3_5 + 0.0107487574154245*G0_0_0_4_0 - 0.00616963283629972*G0_0_0_4_1 + 0.0113131313131317*G0_0_0_4_2 + 0.0168799102132441*G0_0_0_4_3 + 0.0850665383998744*G0_0_0_4_4 + 0.0194452461119134*G0_0_0_4_5 + 0.0107231040564378*G0_0_0_5_0 - 0.0055154721821389*G0_0_0_5_1 - 0.00355299021965701*G0_0_0_5_2 + 0.0116466249799587*G0_0_0_5_3 + 0.0194452461119134*G0_0_0_5_4 + 0.0173416706750047*G0_0_0_5_5 - 0.00302709636042978*G0_0_1_0_0 + 0.00756774090107453*G0_0_1_0_1 + 0.00128266794933466*G0_0_1_0_3 - 0.000564373897707238*G0_0_1_0_4 + 0.00743947410614103*G0_0_1_0_5 + 0.00756774090107454*G0_0_1_1_0 - 0.00756774090107446*G0_0_1_1_2 + 0.0389931056597735*G0_0_1_1_3 - 0.0389931056597738*G0_0_1_1_5 - 0.00756774090107446*G0_0_1_2_1 + 0.00302709636042978*G0_0_1_2_2 - 0.007439474106141*G0_0_1_2_3 + 0.00056437389770724*G0_0_1_2_4 - 0.00128266794933466*G0_0_1_2_5 + 0.00128266794933466*G0_0_1_3_0 + 0.0389931056597735*G0_0_1_3_1 - 0.007439474106141*G0_0_1_3_2 + 0.00923520923520938*G0_0_1_3_3 - 0.00256533589866932*G0_0_1_3_4 - 0.000564373897707239*G0_0_1_4_0 + 0.00056437389770724*G0_0_1_4_2 - 0.00256533589866932*G0_0_1_4_3 + 0.00256533589866933*G0_0_1_4_5 + 0.00743947410614103*G0_0_1_5_0 - 0.0389931056597738*G0_0_1_5_1 - 0.00128266794933466*G0_0_1_5_2 + 0.00256533589866933*G0_0_1_5_4 - 0.0092352092352096*G0_0_1_5_5;
    A[54] = -A[174] + 0.199890973224314*G0_0_0_0_0 - 0.0184704184704191*G0_0_0_0_1 - 0.0152551974774202*G0_0_0_0_2 - 0.00424135535246661*G0_0_0_0_3 + 0.0809962054406527*G0_0_0_0_4 + 0.0212067767623332*G0_0_0_0_5 - 0.0184704184704191*G0_0_0_1_0 + 0.116979316979321*G0_0_0_1_1 - 0.00212067767623329*G0_0_0_1_2 + 0.00547271658382781*G0_0_0_1_3 - 0.00506226284004081*G0_0_0_1_4 + 0.0273635829191394*G0_0_0_1_5 - 0.0152551974774202*G0_0_0_2_0 - 0.00212067767623329*G0_0_0_2_1 + 0.0102613435946774*G0_0_0_2_2 - 0.00123136123136123*G0_0_0_2_3 - 0.0250376783710125*G0_0_0_2_4 - 0.025311314200204*G0_0_0_2_5 - 0.00424135535246661*G0_0_0_3_0 + 0.00547271658382779*G0_0_0_3_1 - 0.00123136123136123*G0_0_0_3_2 - 0.0596526107637243*G0_0_0_3_3 + 0.0186072363850147*G0_0_0_3_4 + 0.0591053391053411*G0_0_0_3_5 + 0.0809962054406527*G0_0_0_4_0 - 0.00506226284004081*G0_0_0_4_1 - 0.0250376783710125*G0_0_0_4_2 + 0.0186072363850147*G0_0_0_4_3 + 0.104528886751112*G0_0_0_4_4 + 0.0607471540804895*G0_0_0_4_5 + 0.0212067767623332*G0_0_0_5_0 + 0.0273635829191394*G0_0_0_5_1 - 0.0253113142002039*G0_0_0_5_2 + 0.0591053391053411*G0_0_0_5_3 + 0.0607471540804895*G0_0_0_5_4 + 0.154877879322329*G0_0_0_5_5 + 0.00697771364438048*G0_0_1_0_0 - 0.0177863288974406*G0_0_1_0_1 + 0.000752498530276313*G0_0_1_0_2 - 0.00246272246272251*G0_0_1_0_3 + 0.000684089572978515*G0_0_1_0_4 + 0.0276372187483308*G0_0_1_0_5 - 0.0177863288974406*G0_0_1_1_0 + 0.121083854417192*G0_0_1_1_1 - 0.00136817914595695*G0_0_1_1_2 - 0.00547271658382791*G0_0_1_1_4 + 0.0164181497514836*G0_0_1_1_5 + 0.000752498530276313*G0_0_1_2_0 - 0.00136817914595695*G0_0_1_2_1 + 0.00451499118165808*G0_0_1_2_2 + 0.00300999412110544*G0_0_1_2_3 - 0.00916680027791168*G0_0_1_2_4 - 0.027089947089948*G0_0_1_2_5 - 0.00246272246272251*G0_0_1_3_0 + 0.00300999412110544*G0_0_1_3_2 - 0.0755234888568254*G0_0_1_3_3 + 0.0158708780931008*G0_0_1_3_4 + 0.059105339105341*G0_0_1_3_5 + 0.000684089572978519*G0_0_1_4_0 - 0.00547271658382791*G0_0_1_4_1 - 0.00916680027791168*G0_0_1_4_2 + 0.0158708780931008*G0_0_1_4_3 + 0.0142290631179526*G0_0_1_4_4 + 0.0651253273475518*G0_0_1_4_5 + 0.0276372187483308*G0_0_1_5_0 + 0.0164181497514836*G0_0_1_5_1 - 0.027089947089948*G0_0_1_5_2 + 0.059105339105341*G0_0_1_5_3 + 0.0651253273475518*G0_0_1_5_4 + 0.220003206669881*G0_0_1_5_5;
    A[50] = -A[54] + 0.0188808722142063*G0_0_0_0_0 - 0.00218908663353116*G0_0_0_0_1 - 0.0168970124525686*G0_0_0_0_2 + 0.00123136123136127*G0_0_0_0_3 - 0.00218908663353113*G0_0_0_0_4 - 0.00560953449842352*G0_0_0_0_5 - 0.00218908663353116*G0_0_0_1_0 - 0.0615680615680635*G0_0_0_1_1 + 0.0085511196622311*G0_0_0_1_2 - 0.0514435358879821*G0_0_0_1_3 - 0.00123136123136126*G0_0_0_1_4 + 0.00629362407140198*G0_0_0_1_5 - 0.0168970124525686*G0_0_0_2_0 + 0.0085511196622311*G0_0_0_2_1 + 0.195786435786442*G0_0_0_2_2 + 0.018470418470419*G0_0_0_2_3 + 0.0685457752124441*G0_0_0_2_4 - 0.00807225696114609*G0_0_0_2_5 + 0.00123136123136127*G0_0_0_3_0 - 0.0514435358879821*G0_0_0_3_1 + 0.018470418470419*G0_0_0_3_2 - 0.198659611992952*G0_0_0_3_3 + 0.0136817914595696*G0_0_0_3_5 - 0.00218908663353113*G0_0_0_4_0 - 0.00123136123136126*G0_0_0_4_1 + 0.0685457752124441*G0_0_0_4_2 + 0.0968670835337533*G0_0_0_4_4 + 0.0186072363850148*G0_0_0_4_5 - 0.00560953449842352*G0_0_0_5_0 + 0.00629362407140198*G0_0_0_5_1 - 0.00807225696114609*G0_0_0_5_2 + 0.0136817914595696*G0_0_0_5_3 + 0.0186072363850148*G0_0_0_5_4 + 0.0563689808134272*G0_0_0_5_5 - 0.00205226871893548*G0_0_1_0_0 - 0.00123136123136126*G0_0_1_0_1 - 0.000820907487574197*G0_0_1_0_2 + 0.0238063171396513*G0_0_1_0_3 + 0.0049254449254451*G0_0_1_0_4 + 0.00246272246272257*G0_0_1_0_5 - 0.00123136123136126*G0_0_1_1_0 - 0.0738816738816763*G0_0_1_1_1 + 0.0275004008337351*G0_0_1_1_2 - 0.0902998236331602*G0_0_1_1_3 + 0.00246272246272253*G0_0_1_1_4 - 0.000820907487574198*G0_0_1_2_0 + 0.0275004008337351*G0_0_1_2_1 - 0.00205226871893545*G0_0_1_2_2 + 0.00410453743787099*G0_0_1_2_3 + 0.000820907487574208*G0_0_1_2_4 - 0.00246272246272254*G0_0_1_2_5 + 0.0238063171396513*G0_0_1_3_0 - 0.0902998236331602*G0_0_1_3_1 + 0.00410453743787099*G0_0_1_3_2 - 0.384184704184718*G0_0_1_3_3 - 0.0525380792047477*G0_0_1_3_4 - 0.0426871893538576*G0_0_1_3_5 + 0.0049254449254451*G0_0_1_4_0 + 0.00246272246272253*G0_0_1_4_1 + 0.000820907487574207*G0_0_1_4_2 - 0.0525380792047477*G0_0_1_4_3 - 0.00985088985089003*G0_0_1_4_4 + 0.00246272246272257*G0_0_1_5_0 - 0.00246272246272254*G0_0_1_5_2 - 0.0426871893538576*G0_0_1_5_3 + 0.0426871893538574*G0_0_1_5_5 + 0.0110822510822516*G0_1_0_0_0 - 0.00191545080433976*G0_1_0_0_1 - 0.0017102239324462*G0_1_0_0_2 - 0.00191545080433974*G0_1_0_0_3 + 0.00041045374378715*G0_1_0_0_4 - 0.00820907487574173*G0_1_0_0_5 - 0.00191545080433976*G0_1_0_1_0 - 0.162129228795901*G0_1_0_1_1 + 0.010398161509273*G0_1_0_1_2 - 0.0615680615680636*G0_1_0_1_3 - 0.000273635829191387*G0_1_0_1_4 + 0.0123136123136125*G0_1_0_1_5 - 0.0017102239324462*G0_1_0_2_0 + 0.010398161509273*G0_1_0_2_1 + 0.0135449735449737*G0_1_0_2_2 + 0.0180599647266319*G0_1_0_2_3 + 0.00615680615680628*G0_1_0_2_4 - 0.00355726577948812*G0_1_0_2_5 - 0.00191545080433974*G0_1_0_3_0 - 0.0615680615680636*G0_1_0_3_1 + 0.0180599647266319*G0_1_0_3_2 - 0.0601998824221067*G0_1_0_3_3 + 0.00437817326706228*G0_1_0_3_4 + 0.0109454331676557*G0_1_0_3_5 + 0.00041045374378715*G0_1_0_4_0 - 0.000273635829191387*G0_1_0_4_1 + 0.00615680615680628*G0_1_0_4_2 + 0.00437817326706228*G0_1_0_4_3 + 0.00875634653412461*G0_1_0_4_4 + 0.00766180321735905*G0_1_0_4_5 - 0.00820907487574173*G0_1_0_5_0 + 0.0123136123136125*G0_1_0_5_1 - 0.00355726577948812*G0_1_0_5_2 + 0.0109454331676557*G0_1_0_5_3 + 0.00766180321735905*G0_1_0_5_4 + 0.0711453155897624*G0_1_0_5_5 - 0.00246272246272262*G0_1_1_0_0 - 0.0123136123136128*G0_1_1_0_1 + 0.00164181497514836*G0_1_1_0_3 - 0.00574635241301927*G0_1_1_0_4 - 0.0262690396023739*G0_1_1_0_5 - 0.0123136123136128*G0_1_1_1_0 + 0.0123136123136127*G0_1_1_1_2 - 0.0738816738816762*G0_1_1_1_3 + 0.0738816738816767*G0_1_1_1_5 + 0.0123136123136127*G0_1_1_2_1 + 0.00246272246272245*G0_1_1_2_2 + 0.0262690396023738*G0_1_1_2_3 + 0.00574635241301924*G0_1_1_2_4 - 0.00164181497514837*G0_1_1_2_5 + 0.00164181497514836*G0_1_1_3_0 - 0.0738816738816762*G0_1_1_3_1 + 0.0262690396023738*G0_1_1_3_2 - 0.131345198011869*G0_1_1_3_3 - 0.00328362995029677*G0_1_1_3_4 - 0.00574635241301927*G0_1_1_4_0 + 0.00574635241301924*G0_1_1_4_2 - 0.00328362995029677*G0_1_1_4_3 + 0.00328362995029672*G0_1_1_4_5 - 0.0262690396023739*G0_1_1_5_0 + 0.0738816738816767*G0_1_1_5_1 - 0.00164181497514837*G0_1_1_5_2 + 0.00328362995029673*G0_1_1_5_4 + 0.131345198011869*G0_1_1_5_5;
    A[170] = -A[50] + 0.00574635241301926*G0_0_0_0_0 - 0.000752498530276335*G0_0_0_0_1 - 0.0160076960076965*G0_0_0_0_2 + 0.00177863288974406*G0_0_0_0_3 - 0.0158708780931008*G0_0_0_0_4 - 0.00424135535246657*G0_0_0_0_5 - 0.000752498530276335*G0_0_0_1_0 - 0.00410453743787082*G0_0_0_1_1 - 0.000684089572978451*G0_0_0_1_2 + 0.0109454331676558*G0_0_0_1_3 + 0.00041045374378711*G0_0_0_1_4 + 0.00547271658382785*G0_0_0_1_5 - 0.0160076960076965*G0_0_0_2_0 - 0.000684089572978449*G0_0_0_2_1 + 0.192913259579932*G0_0_0_2_2 - 0.00643044198599786*G0_0_0_2_3 + 0.080312115867674*G0_0_0_2_4 - 0.00177863288974404*G0_0_0_2_5 + 0.00177863288974406*G0_0_0_3_0 + 0.0109454331676558*G0_0_0_3_1 - 0.00643044198599785*G0_0_0_3_2 - 0.0651253273475517*G0_0_0_3_3 - 0.00437817326706235*G0_0_0_3_4 - 0.0158708780931008*G0_0_0_4_0 + 0.00041045374378711*G0_0_0_4_1 + 0.080312115867674*G0_0_0_4_2 - 0.00437817326706235*G0_0_0_4_3 + 0.0902998236331598*G0_0_0_4_4 + 0.00273635829191394*G0_0_0_4_5 - 0.00424135535246657*G0_0_0_5_0 + 0.00547271658382785*G0_0_0_5_1 - 0.00177863288974404*G0_0_0_5_2 + 0.00273635829191395*G0_0_0_5_4 + 0.0158708780931007*G0_0_0_5_5 - 0.004514991181658*G0_0_1_0_0 + 0.00136817914595701*G0_0_1_0_1 - 0.000752498530276339*G0_0_1_0_2 + 0.027089947089948*G0_0_1_0_3 + 0.00916680027791171*G0_0_1_0_4 - 0.00300999412110531*G0_0_1_0_5 + 0.00136817914595701*G0_0_1_1_0 - 0.121083854417193*G0_0_1_1_1 + 0.0177863288974407*G0_0_1_1_2 - 0.0164181497514838*G0_0_1_1_3 + 0.0054727165838279*G0_0_1_1_4 - 0.000752498530276339*G0_0_1_2_0 + 0.0177863288974407*G0_0_1_2_1 - 0.00697771364438061*G0_0_1_2_2 - 0.0276372187483308*G0_0_1_2_3 - 0.000684089572978498*G0_0_1_2_4 + 0.00246272246272254*G0_0_1_2_5 + 0.027089947089948*G0_0_1_3_0 - 0.0164181497514838*G0_0_1_3_1 - 0.0276372187483308*G0_0_1_3_2 - 0.220003206669881*G0_0_1_3_3 - 0.0651253273475518*G0_0_1_3_4 - 0.0591053391053412*G0_0_1_3_5 + 0.00916680027791171*G0_0_1_4_0 + 0.0054727165838279*G0_0_1_4_1 - 0.0006840895729785*G0_0_1_4_2 - 0.0651253273475518*G0_0_1_4_3 - 0.0142290631179523*G0_0_1_4_4 - 0.0158708780931009*G0_0_1_4_5 - 0.00300999412110531*G0_0_1_5_0 + 0.00246272246272254*G0_0_1_5_2 - 0.0591053391053412*G0_0_1_5_3 - 0.0158708780931009*G0_0_1_5_4 + 0.0755234888568247*G0_0_1_5_5;
    A[86] = A[170] + 0.000820907487574195*G0_0_1_0_0 - 0.00129977018865917*G0_0_1_0_1 + 0.000820907487574176*G0_0_1_0_2 - 0.00300999412110534*G0_0_1_0_3 - 0.001368179145957*G0_0_1_0_4 + 0.01080861525306*G0_0_1_0_5 - 0.00129977018865917*G0_0_1_1_0 + 0.104665704665709*G0_0_1_1_1 + 0.000615680615680603*G0_0_1_1_2 - 0.0083458927903374*G0_0_1_1_3 - 0.00136817914595699*G0_0_1_1_4 - 0.00396771952327491*G0_0_1_1_5 + 0.000820907487574176*G0_0_1_2_0 + 0.000615680615680603*G0_0_1_2_1 - 0.00944043610710305*G0_0_1_2_2 + 0.00287317620650965*G0_0_1_2_3 - 0.00328362995029669*G0_0_1_2_4 + 0.00164181497514837*G0_0_1_2_5 - 0.00300999412110534*G0_0_1_3_0 - 0.0083458927903374*G0_0_1_3_1 + 0.00287317620650965*G0_0_1_3_2 - 0.0120399764844215*G0_0_1_3_3 + 0.00875634653412462*G0_0_1_3_4 + 0.00273635829191395*G0_0_1_3_5 - 0.001368179145957*G0_0_1_4_0 - 0.00136817914595699*G0_0_1_4_1 - 0.00328362995029668*G0_0_1_4_2 + 0.00875634653412462*G0_0_1_4_3 - 0.00218908663353119*G0_0_1_4_4 - 0.000547271658382774*G0_0_1_4_5 + 0.01080861525306*G0_0_1_5_0 - 0.00396771952327491*G0_0_1_5_1 + 0.00164181497514836*G0_0_1_5_2 + 0.00273635829191395*G0_0_1_5_3 - 0.000547271658382775*G0_0_1_5_4 - 0.0919416386083083*G0_0_1_5_5 - 0.000820907487574195*G0_1_0_0_0 + 0.00129977018865917*G0_1_0_0_1 - 0.000820907487574176*G0_1_0_0_2 + 0.00300999412110534*G0_1_0_0_3 + 0.00136817914595699*G0_1_0_0_4 - 0.01080861525306*G0_1_0_0_5 + 0.00129977018865917*G0_1_0_1_0 - 0.104665704665709*G0_1_0_1_1 - 0.000615680615680603*G0_1_0_1_2 + 0.0083458927903374*G0_1_0_1_3 + 0.00136817914595699*G0_1_0_1_4 + 0.00396771952327492*G0_1_0_1_5 - 0.000820907487574176*G0_1_0_2_0 - 0.000615680615680603*G0_1_0_2_1 + 0.00944043610710305*G0_1_0_2_2 - 0.00287317620650965*G0_1_0_2_3 + 0.00328362995029669*G0_1_0_2_4 - 0.00164181497514837*G0_1_0_2_5 + 0.00300999412110534*G0_1_0_3_0 + 0.0083458927903374*G0_1_0_3_1 - 0.00287317620650965*G0_1_0_3_2 + 0.0120399764844215*G0_1_0_3_3 - 0.00875634653412462*G0_1_0_3_4 - 0.00273635829191395*G0_1_0_3_5 + 0.00136817914595699*G0_1_0_4_0 + 0.00136817914595699*G0_1_0_4_1 + 0.00328362995029668*G0_1_0_4_2 - 0.00875634653412462*G0_1_0_4_3 + 0.00218908663353119*G0_1_0_4_4 + 0.000547271658382776*G0_1_0_4_5 - 0.01080861525306*G0_1_0_5_0 + 0.00396771952327491*G0_1_0_5_1 - 0.00164181497514837*G0_1_0_5_2 - 0.00273635829191395*G0_1_0_5_3 + 0.000547271658382775*G0_1_0_5_4 + 0.0919416386083083*G0_1_0_5_5;
    A[33] = -A[36] + 0.00102613435946772*G0_1_0_0_0 - 0.00230880230880241*G0_1_0_0_2 - 0.00318101651434995*G0_1_0_0_3 - 0.0132371332371336*G0_1_0_0_4 - 0.00205226871893544*G0_1_0_0_5 - 0.00102613435946775*G0_1_0_1_1 + 0.00230880230880238*G0_1_0_1_2 + 0.0132371332371337*G0_1_0_1_3 + 0.00318101651434994*G0_1_0_1_4 + 0.00205226871893543*G0_1_0_1_5 - 0.00230880230880241*G0_1_0_2_0 + 0.00230880230880238*G0_1_0_2_1 - 0.0256533589866932*G0_1_0_2_3 + 0.0256533589866932*G0_1_0_2_4 - 0.00318101651434995*G0_1_0_3_0 + 0.0132371332371337*G0_1_0_3_1 - 0.0256533589866932*G0_1_0_3_2 - 0.00205226871893547*G0_1_0_3_3 + 0.00636203302869989*G0_1_0_3_5 - 0.0132371332371336*G0_1_0_4_0 + 0.00318101651434994*G0_1_0_4_1 + 0.0256533589866932*G0_1_0_4_2 + 0.00205226871893559*G0_1_0_4_4 - 0.00636203302869988*G0_1_0_4_5 - 0.00205226871893544*G0_1_0_5_0 + 0.00205226871893543*G0_1_0_5_1 + 0.00636203302869989*G0_1_0_5_3 - 0.00636203302869988*G0_1_0_5_4 - 0.0365047298380645*G0_1_1_0_0 + 0.00606701940035297*G0_1_1_0_1 + 0.00251830474052704*G0_1_1_0_2 - 0.000478862701084925*G0_1_1_0_3 - 0.00788413232857702*G0_1_1_0_4 - 0.0125359414248307*G0_1_1_0_5 + 0.00606701940035297*G0_1_1_1_0 - 0.0375308641975325*G0_1_1_1_1 + 0.00482710704932945*G0_1_1_1_2 + 0.0053530009085566*G0_1_1_1_3 + 0.00270215381326501*G0_1_1_1_4 - 0.0104836727058954*G0_1_1_1_5 + 0.00251830474052704*G0_1_1_2_0 + 0.00482710704932945*G0_1_1_2_1 - 0.077088343755013*G0_1_1_2_2 - 0.0251402918069594*G0_1_1_2_3 + 0.000513067179733834*G0_1_1_2_4 + 0.00124846347068573*G0_1_1_2_5 - 0.000478862701084926*G0_1_1_3_0 + 0.0053530009085566*G0_1_1_3_1 - 0.0251402918069594*G0_1_1_3_2 - 0.00478862701084947*G0_1_1_3_3 - 0.00444658222436016*G0_1_1_3_4 - 0.00153920153920163*G0_1_1_3_5 - 0.00788413232857702*G0_1_1_4_0 + 0.00270215381326501*G0_1_1_4_1 + 0.000513067179733835*G0_1_1_4_2 - 0.00444658222436016*G0_1_1_4_3 - 0.00273635829191387*G0_1_1_4_4 - 0.0079012345679015*G0_1_1_4_5 - 0.0125359414248307*G0_1_1_5_0 - 0.0104836727058954*G0_1_1_5_1 + 0.00124846347068573*G0_1_1_5_2 - 0.00153920153920163*G0_1_1_5_3 - 0.00790123456790149*G0_1_1_5_4 - 0.034820159264605*G0_1_1_5_5;
    A[41] = -A[33] - 0.000949174282507699*G0_1_0_0_0 - 0.000671262893485141*G0_1_0_0_1 - 0.00628934851157093*G0_1_0_0_2 - 0.00427555983111552*G0_1_0_0_3 - 0.00395061728395076*G0_1_0_0_4 + 0.0023088023088024*G0_1_0_0_5 - 0.000671262893485141*G0_1_0_1_0 + 0.0211640211640221*G0_1_0_1_1 - 0.00325370103147891*G0_1_0_1_2 + 0.0085511196622311*G0_1_0_1_3 - 0.000342044786489219*G0_1_0_1_5 - 0.00628934851157093*G0_1_0_2_0 - 0.00325370103147891*G0_1_0_2_1 + 0.0896584896584926*G0_1_0_2_2 + 0.000188124632569056*G0_1_0_2_3 + 0.0290567046122611*G0_1_0_2_4 - 0.000718294051627388*G0_1_0_2_5 - 0.00427555983111552*G0_1_0_3_0 + 0.0085511196622311*G0_1_0_3_1 + 0.000188124632569057*G0_1_0_3_2 + 0.0124504302282085*G0_1_0_3_3 + 0.00865373309817784*G0_1_0_3_4 + 0.00998770776548586*G0_1_0_3_5 - 0.00395061728395076*G0_1_0_4_0 + 0.0290567046122611*G0_1_0_4_2 + 0.00865373309817784*G0_1_0_4_3 + 0.0194965528298867*G0_1_0_4_4 + 0.00153920153920159*G0_1_0_4_5 + 0.0023088023088024*G0_1_0_5_0 - 0.00034204478648922*G0_1_0_5_1 - 0.000718294051627388*G0_1_0_5_2 + 0.00998770776548586*G0_1_0_5_3 + 0.00153920153920159*G0_1_0_5_4 - 0.0201122334455676*G0_1_0_5_5;
    A[127] = A[113] + 0.0102613435946771*G0_0_1_0_0 + 0.00702902036235395*G0_0_1_0_1 - 0.0258072791406134*G0_0_1_0_2 - 0.0214462081128755*G0_0_1_0_3 - 0.0807567740901102*G0_0_1_0_4 - 0.0111848645181983*G0_0_1_0_5 + 0.00702902036235395*G0_0_1_1_0 + 0.00441237774571126*G0_0_1_1_1 - 0.00784992784992816*G0_0_1_1_2 - 0.0146737213403885*G0_0_1_1_3 - 0.0413532146865495*G0_0_1_1_4 - 0.00738816738816761*G0_0_1_1_5 - 0.0258072791406134*G0_0_1_2_0 - 0.00784992784992816*G0_0_1_2_1 + 0.05438512105179*G0_0_1_2_2 + 0.0246272246272256*G0_0_1_2_3 + 0.142632675966014*G0_0_1_2_4 + 0.00954304954304991*G0_0_1_2_5 - 0.0214462081128755*G0_0_1_3_0 - 0.0146737213403885*G0_0_1_3_1 + 0.0246272246272256*G0_0_1_3_2 + 0.0426871893538577*G0_0_1_3_3 + 0.12559884559885*G0_0_1_3_4 + 0.0238063171396513*G0_0_1_3_5 - 0.0807567740901102*G0_0_1_4_0 - 0.0413532146865495*G0_0_1_4_1 + 0.142632675966014*G0_0_1_4_2 + 0.12559884559885*G0_0_1_4_3 + 0.625531505531528*G0_0_1_4_4 + 0.0636203302869992*G0_0_1_4_5 - 0.0111848645181983*G0_0_1_5_0 - 0.00738816738816761*G0_0_1_5_1 + 0.00954304954304991*G0_0_1_5_2 + 0.0238063171396513*G0_0_1_5_3 + 0.0636203302869992*G0_0_1_5_4 + 0.00738816738816754*G0_0_1_5_5 - 0.0102613435946771*G0_1_0_0_0 - 0.00702902036235395*G0_1_0_0_1 + 0.0258072791406134*G0_1_0_0_2 + 0.0214462081128755*G0_1_0_0_3 + 0.0807567740901102*G0_1_0_0_4 + 0.0111848645181983*G0_1_0_0_5 - 0.00702902036235395*G0_1_0_1_0 - 0.00441237774571126*G0_1_0_1_1 + 0.00784992784992816*G0_1_0_1_2 + 0.0146737213403885*G0_1_0_1_3 + 0.0413532146865495*G0_1_0_1_4 + 0.00738816738816761*G0_1_0_1_5 + 0.0258072791406134*G0_1_0_2_0 + 0.00784992784992816*G0_1_0_2_1 - 0.05438512105179*G0_1_0_2_2 - 0.0246272246272256*G0_1_0_2_3 - 0.142632675966014*G0_1_0_2_4 - 0.00954304954304991*G0_1_0_2_5 + 0.0214462081128755*G0_1_0_3_0 + 0.0146737213403885*G0_1_0_3_1 - 0.0246272246272256*G0_1_0_3_2 - 0.0426871893538577*G0_1_0_3_3 - 0.12559884559885*G0_1_0_3_4 - 0.0238063171396513*G0_1_0_3_5 + 0.0807567740901102*G0_1_0_4_0 + 0.0413532146865494*G0_1_0_4_1 - 0.142632675966014*G0_1_0_4_2 - 0.12559884559885*G0_1_0_4_3 - 0.625531505531528*G0_1_0_4_4 - 0.0636203302869992*G0_1_0_4_5 + 0.0111848645181983*G0_1_0_5_0 + 0.00738816738816761*G0_1_0_5_1 - 0.00954304954304991*G0_1_0_5_2 - 0.0238063171396513*G0_1_0_5_3 - 0.0636203302869992*G0_1_0_5_4 - 0.00738816738816754*G0_1_0_5_5;
    A[62] = -A[107] - 0.00302709636042985*G0_0_1_0_0 + 0.0075677409010745*G0_0_1_0_2 + 0.00128266794933465*G0_0_1_0_3 + 0.007439474106141*G0_0_1_0_4 - 0.000564373897707289*G0_0_1_0_5 + 0.00302709636042983*G0_0_1_1_1 - 0.00756774090107452*G0_0_1_1_2 - 0.00743947410614105*G0_0_1_1_3 - 0.00128266794933467*G0_0_1_1_4 + 0.000564373897707267*G0_0_1_1_5 + 0.00756774090107449*G0_0_1_2_0 - 0.00756774090107452*G0_0_1_2_1 + 0.0389931056597737*G0_0_1_2_3 - 0.0389931056597737*G0_0_1_2_4 + 0.00128266794933465*G0_0_1_3_0 - 0.00743947410614105*G0_0_1_3_1 + 0.0389931056597738*G0_0_1_3_2 + 0.0092352092352098*G0_0_1_3_3 - 0.0025653358986693*G0_0_1_3_5 + 0.007439474106141*G0_0_1_4_0 - 0.00128266794933467*G0_0_1_4_1 - 0.0389931056597737*G0_0_1_4_2 - 0.00923520923520942*G0_0_1_4_4 + 0.00256533589866932*G0_0_1_4_5 - 0.000564373897707288*G0_0_1_5_0 + 0.000564373897707267*G0_0_1_5_1 - 0.0025653358986693*G0_0_1_5_3 + 0.00256533589866932*G0_0_1_5_4 + 0.0321628988295666*G0_1_1_0_0 - 0.00705788039121398*G0_1_1_0_1 - 0.00219015552348891*G0_1_1_0_2 - 0.00227032227032235*G0_1_1_0_3 + 0.0107231040564377*G0_1_1_0_4 + 0.0107487574154244*G0_1_1_0_5 - 0.00705788039121398*G0_1_1_1_0 + 0.0351899951899967*G0_1_1_1_1 - 0.00975789642456343*G0_1_1_1_2 + 0.00328362995029678*G0_1_1_1_3 - 0.003552990219657*G0_1_1_1_4 + 0.0113131313131318*G0_1_1_1_5 - 0.00219015552348891*G0_1_1_2_0 - 0.00975789642456343*G0_1_1_2_1 + 0.151707551707557*G0_1_1_2_2 + 0.0334776334776347*G0_1_1_2_3 - 0.00551547218213904*G0_1_1_2_4 - 0.00616963283629968*G0_1_1_2_5 - 0.00227032227032235*G0_1_1_3_0 + 0.00328362995029678*G0_1_1_3_1 + 0.0334776334776347*G0_1_1_3_2 + 0.0265768799102143*G0_1_1_3_3 + 0.0116466249799587*G0_1_1_3_4 + 0.0168799102132441*G0_1_1_3_5 + 0.0107231040564377*G0_1_1_4_0 - 0.003552990219657*G0_1_1_4_1 - 0.00551547218213905*G0_1_1_4_2 + 0.0116466249799587*G0_1_1_4_3 + 0.0173416706750045*G0_1_1_4_4 + 0.0194452461119134*G0_1_1_4_5 + 0.0107487574154244*G0_1_1_5_0 + 0.0113131313131318*G0_1_1_5_1 - 0.00616963283629968*G0_1_1_5_2 + 0.0168799102132441*G0_1_1_5_3 + 0.0194452461119134*G0_1_1_5_4 + 0.0850665383998747*G0_1_1_5_5;
    A[44] = A[212] - 0.00302709636042985*G0_0_1_0_0 + 0.00756774090107447*G0_0_1_0_2 + 0.00128266794933465*G0_0_1_0_3 + 0.00743947410614099*G0_0_1_0_4 - 0.000564373897707287*G0_0_1_0_5 + 0.00302709636042983*G0_0_1_1_1 - 0.00756774090107454*G0_0_1_1_2 - 0.00743947410614105*G0_0_1_1_3 - 0.00128266794933468*G0_0_1_1_4 + 0.000564373897707268*G0_0_1_1_5 + 0.00756774090107447*G0_0_1_2_0 - 0.00756774090107455*G0_0_1_2_1 + 0.0389931056597739*G0_0_1_2_3 - 0.0389931056597735*G0_0_1_2_4 + 0.00128266794933465*G0_0_1_3_0 - 0.00743947410614105*G0_0_1_3_1 + 0.0389931056597739*G0_0_1_3_2 + 0.00923520923520979*G0_0_1_3_3 - 0.00256533589866931*G0_0_1_3_5 + 0.00743947410614099*G0_0_1_4_0 - 0.00128266794933468*G0_0_1_4_1 - 0.0389931056597735*G0_0_1_4_2 - 0.00923520923520935*G0_0_1_4_4 + 0.00256533589866932*G0_0_1_4_5 - 0.000564373897707287*G0_0_1_5_0 + 0.000564373897707268*G0_0_1_5_1 - 0.00256533589866931*G0_0_1_5_3 + 0.00256533589866932*G0_0_1_5_4 + 0.00302709636042985*G0_1_0_0_0 - 0.00756774090107447*G0_1_0_0_2 - 0.00128266794933465*G0_1_0_0_3 - 0.00743947410614099*G0_1_0_0_4 + 0.000564373897707287*G0_1_0_0_5 - 0.00302709636042983*G0_1_0_1_1 + 0.00756774090107454*G0_1_0_1_2 + 0.00743947410614105*G0_1_0_1_3 + 0.00128266794933468*G0_1_0_1_4 - 0.000564373897707268*G0_1_0_1_5 - 0.00756774090107447*G0_1_0_2_0 + 0.00756774090107454*G0_1_0_2_1 - 0.0389931056597739*G0_1_0_2_3 + 0.0389931056597735*G0_1_0_2_4 - 0.00128266794933465*G0_1_0_3_0 + 0.00743947410614105*G0_1_0_3_1 - 0.0389931056597739*G0_1_0_3_2 - 0.00923520923520979*G0_1_0_3_3 + 0.00256533589866931*G0_1_0_3_5 - 0.00743947410614099*G0_1_0_4_0 + 0.00128266794933468*G0_1_0_4_1 + 0.0389931056597735*G0_1_0_4_2 + 0.00923520923520936*G0_1_0_4_4 - 0.00256533589866932*G0_1_0_4_5 + 0.000564373897707287*G0_1_0_5_0 - 0.000564373897707269*G0_1_0_5_1 + 0.00256533589866931*G0_1_0_5_3 - 0.00256533589866932*G0_1_0_5_4;
    A[42] = -A[44] + 0.00410453743787095*G0_1_0_0_0 - 0.00046176046176048*G0_1_0_0_1 - 0.00800384800384825*G0_1_0_0_2 + 0.000615680615680621*G0_1_0_0_3 + 0.00584896584896601*G0_1_0_0_4 + 0.00410453743787091*G0_1_0_0_5 - 0.00046176046176048*G0_1_0_1_0 - 0.000923520923521011*G0_1_0_1_1 + 0.00482283148949835*G0_1_0_1_2 + 0.00749078082411442*G0_1_0_1_3 + 0.000923520923520936*G0_1_0_1_5 - 0.00800384800384825*G0_1_0_2_0 + 0.00482283148949835*G0_1_0_2_1 - 0.0261664261664272*G0_1_0_2_3 + 0.026166426166427*G0_1_0_2_4 + 0.00318101651434993*G0_1_0_2_5 + 0.00061568061568062*G0_1_0_3_0 + 0.00749078082411442*G0_1_0_3_1 - 0.0261664261664272*G0_1_0_3_2 - 0.00697771364438055*G0_1_0_3_3 - 0.00123136123136127*G0_1_0_3_4 - 0.00759339426006111*G0_1_0_3_5 + 0.00584896584896601*G0_1_0_4_0 + 0.026166426166427*G0_1_0_4_2 - 0.00123136123136127*G0_1_0_4_3 + 0.00944043610710277*G0_1_0_4_4 - 0.00636203302869988*G0_1_0_4_5 + 0.00410453743787091*G0_1_0_5_0 + 0.000923520923520937*G0_1_0_5_1 + 0.00318101651434993*G0_1_0_5_2 - 0.00759339426006111*G0_1_0_5_3 - 0.00636203302869988*G0_1_0_5_4 - 0.0123136123136125*G0_1_0_5_5 - 0.0124162257495595*G0_1_1_0_0 - 0.000666987333654025*G0_1_1_0_1 + 0.0063620330286999*G0_1_1_0_2 + 0.000513067179733853*G0_1_1_0_3 + 0.00266794933461608*G0_1_1_0_4 - 0.0173416706750046*G0_1_1_0_5 - 0.000666987333654025*G0_1_1_1_0 + 0.0110822510822515*G0_1_1_1_1 + 0.00969696969697001*G0_1_1_1_2 + 0.0116979316979321*G0_1_1_1_3 + 0.000615680615680641*G0_1_1_1_4 + 0.0149815616482289*G0_1_1_1_5 + 0.0063620330286999*G0_1_1_2_0 + 0.00969696969697001*G0_1_1_2_1 - 0.0887606220939584*G0_1_1_2_2 - 0.0499727433060784*G0_1_1_2_3 - 0.0275004008337351*G0_1_1_2_4 - 0.00502805836139188*G0_1_1_2_5 + 0.000513067179733854*G0_1_1_3_0 + 0.0116979316979321*G0_1_1_3_1 - 0.0499727433060784*G0_1_1_3_2 - 0.0119031585698256*G0_1_1_3_3 - 0.002257495590829*G0_1_1_3_4 + 0.00902998236331601*G0_1_1_3_5 + 0.00266794933461608*G0_1_1_4_0 + 0.000615680615680641*G0_1_1_4_1 - 0.0275004008337351*G0_1_1_4_2 - 0.002257495590829*G0_1_1_4_3 + 0.00410453743787088*G0_1_1_4_4 + 0.00882475549142243*G0_1_1_4_5 - 0.0173416706750046*G0_1_1_5_0 + 0.0149815616482289*G0_1_1_5_1 - 0.00502805836139187*G0_1_1_5_2 + 0.00902998236331601*G0_1_1_5_3 + 0.00882475549142244*G0_1_1_5_4 + 0.00533589866923213*G0_1_1_5_5;
    A[43] = -A[42] - 0.00102613435946772*G0_1_0_0_0 + 0.0023088023088024*G0_1_0_0_2 + 0.00318101651434995*G0_1_0_0_3 + 0.0132371332371336*G0_1_0_0_4 + 0.00205226871893544*G0_1_0_0_5 + 0.00102613435946775*G0_1_0_1_1 - 0.00230880230880239*G0_1_0_1_2 - 0.0132371332371337*G0_1_0_1_3 - 0.00318101651434995*G0_1_0_1_4 - 0.00205226871893543*G0_1_0_1_5 + 0.0023088023088024*G0_1_0_2_0 - 0.00230880230880239*G0_1_0_2_1 + 0.0256533589866932*G0_1_0_2_3 - 0.0256533589866932*G0_1_0_2_4 + 0.00318101651434995*G0_1_0_3_0 - 0.0132371332371337*G0_1_0_3_1 + 0.0256533589866932*G0_1_0_3_2 + 0.00205226871893548*G0_1_0_3_3 - 0.00636203302869988*G0_1_0_3_5 + 0.0132371332371336*G0_1_0_4_0 - 0.00318101651434995*G0_1_0_4_1 - 0.0256533589866932*G0_1_0_4_2 - 0.00205226871893557*G0_1_0_4_4 + 0.00636203302869989*G0_1_0_4_5 + 0.00205226871893544*G0_1_0_5_0 - 0.00205226871893543*G0_1_0_5_1 - 0.00636203302869988*G0_1_0_5_3 + 0.00636203302869989*G0_1_0_5_4 - 0.0200096200096208*G0_1_1_0_0 + 0.00995350328683699*G0_1_1_0_1 - 0.00395061728395071*G0_1_1_0_2 - 0.00123136123136128*G0_1_1_0_3 - 0.00554112554112573*G0_1_1_0_4 - 0.0136475869809209*G0_1_1_0_5 + 0.00995350328683699*G0_1_1_1_0 - 0.0189834856501531*G0_1_1_1_1 - 0.00625941959275312*G0_1_1_1_2 - 0.0187782587782595*G0_1_1_1_3 - 0.00441237774571124*G0_1_1_1_4 - 0.0156998556998563*G0_1_1_1_5 - 0.00395061728395071*G0_1_1_2_0 - 0.00625941959275312*G0_1_1_2_1 + 0.0672118005451359*G0_1_1_2_2 + 0.0425845759179107*G0_1_1_2_3 + 0.0169312169312174*G0_1_1_2_4 + 0.0104665704665708*G0_1_1_2_5 - 0.00123136123136128*G0_1_1_3_0 - 0.0187782587782595*G0_1_1_3_1 + 0.0425845759179107*G0_1_1_3_2 + 0.0184704184704192*G0_1_1_3_3 + 0.0112874779541451*G0_1_1_3_4 - 0.0184704184704191*G0_1_1_3_5 - 0.00554112554112573*G0_1_1_4_0 - 0.00441237774571124*G0_1_1_4_1 + 0.0169312169312174*G0_1_1_4_2 + 0.0112874779541451*G0_1_1_4_3 + 0.0164181497514837*G0_1_1_4_4 - 0.0121083854417191*G0_1_1_4_5 - 0.0136475869809209*G0_1_1_5_0 - 0.0156998556998563*G0_1_1_5_1 + 0.0104665704665708*G0_1_1_5_2 - 0.0184704184704191*G0_1_1_5_3 - 0.0121083854417191*G0_1_1_5_4 - 0.214667308000649*G0_1_1_5_5;
    A[141] = A[99] + 0.363251563251576*G0_0_1_0_0 - 0.00820907487574186*G0_0_1_0_3 - 0.00820907487574173*G0_0_1_0_4 - 0.00820907487574159*G0_0_1_0_5 - 0.00656725990059354*G0_0_1_1_1 - 0.00348885682219025*G0_0_1_1_2 + 0.00287317620650958*G0_0_1_1_3 + 0.0164181497514836*G0_0_1_1_4 + 0.0246272246272254*G0_0_1_1_5 - 0.00348885682219025*G0_0_1_2_1 - 0.00656725990059351*G0_0_1_2_2 + 0.00287317620650961*G0_0_1_2_3 + 0.0246272246272254*G0_0_1_2_4 + 0.0164181497514836*G0_0_1_2_5 - 0.00820907487574186*G0_0_1_3_0 + 0.00287317620650958*G0_0_1_3_1 + 0.00287317620650961*G0_0_1_3_2 - 0.00985088985089061*G0_0_1_3_3 - 0.0164181497514837*G0_0_1_3_4 - 0.0164181497514837*G0_0_1_3_5 - 0.00820907487574173*G0_0_1_4_0 + 0.0164181497514836*G0_0_1_4_1 + 0.0246272246272254*G0_0_1_4_2 - 0.0164181497514837*G0_0_1_4_3 - 0.131345198011869*G0_0_1_4_4 - 0.0656725990059345*G0_0_1_4_5 - 0.00820907487574159*G0_0_1_5_0 + 0.0246272246272254*G0_0_1_5_1 + 0.0164181497514836*G0_0_1_5_2 - 0.0164181497514837*G0_0_1_5_3 - 0.0656725990059345*G0_0_1_5_4 - 0.131345198011869*G0_0_1_5_5 - 0.363251563251576*G0_1_0_0_0 + 0.00820907487574186*G0_1_0_0_3 + 0.00820907487574175*G0_1_0_0_4 + 0.0082090748757416*G0_1_0_0_5 + 0.00656725990059354*G0_1_0_1_1 + 0.00348885682219025*G0_1_0_1_2 - 0.00287317620650958*G0_1_0_1_3 - 0.0164181497514836*G0_1_0_1_4 - 0.0246272246272254*G0_1_0_1_5 + 0.00348885682219025*G0_1_0_2_1 + 0.00656725990059351*G0_1_0_2_2 - 0.00287317620650961*G0_1_0_2_3 - 0.0246272246272254*G0_1_0_2_4 - 0.0164181497514836*G0_1_0_2_5 + 0.00820907487574186*G0_1_0_3_0 - 0.00287317620650958*G0_1_0_3_1 - 0.00287317620650961*G0_1_0_3_2 + 0.00985088985089061*G0_1_0_3_3 + 0.0164181497514837*G0_1_0_3_4 + 0.0164181497514837*G0_1_0_3_5 + 0.00820907487574176*G0_1_0_4_0 - 0.0164181497514836*G0_1_0_4_1 - 0.0246272246272254*G0_1_0_4_2 + 0.0164181497514837*G0_1_0_4_3 + 0.131345198011869*G0_1_0_4_4 + 0.0656725990059345*G0_1_0_4_5 + 0.0082090748757416*G0_1_0_5_0 - 0.0246272246272254*G0_1_0_5_1 - 0.0164181497514836*G0_1_0_5_2 + 0.0164181497514837*G0_1_0_5_3 + 0.0656725990059345*G0_1_0_5_4 + 0.131345198011869*G0_1_0_5_5;
    A[95] = A[54] - 0.0213435946769288*G0_0_0_0_0 + 0.00218908663353116*G0_0_0_0_1 + 0.00458340013895578*G0_0_0_0_2 + 0.000410453743787074*G0_0_0_0_3 - 0.0240799529688426*G0_0_0_0_4 - 0.000136817914595731*G0_0_0_0_5 + 0.00218908663353116*G0_0_0_1_0 + 0.064030784030786*G0_0_0_1_1 + 0.00376249265138162*G0_0_0_1_2 + 0.0777125754903559*G0_0_0_1_3 - 0.000410453743787111*G0_0_0_1_4 - 0.000547271658382721*G0_0_0_1_5 + 0.00458340013895578*G0_0_0_2_0 + 0.00376249265138162*G0_0_0_2_1 - 0.195786435786442*G0_0_0_2_2 - 0.0923520923520954*G0_0_0_2_3 + 0.00533589866923236*G0_0_0_2_4 + 0.00807225696114608*G0_0_0_2_5 + 0.000410453743787075*G0_0_0_3_0 + 0.077712575490356*G0_0_0_3_1 - 0.0923520923520954*G0_0_0_3_2 + 0.0673144139810831*G0_0_0_3_3 - 0.0169654214098664*G0_0_0_3_5 - 0.0240799529688426*G0_0_0_4_0 - 0.000410453743787111*G0_0_0_4_1 + 0.00533589866923235*G0_0_0_4_2 + 0.034478114478116*G0_0_0_4_4 - 0.015323606434718*G0_0_0_4_5 - 0.000136817914595731*G0_0_0_5_0 - 0.000547271658382719*G0_0_0_5_1 + 0.00807225696114608*G0_0_0_5_2 - 0.0169654214098664*G0_0_0_5_3 - 0.015323606434718*G0_0_0_5_4 - 0.0563689808134271*G0_0_0_5_5 + 0.000410453743787077*G0_0_1_0_1 - 0.000410453743787101*G0_0_1_0_2 - 0.00246272246272261*G0_0_1_0_4 + 0.00246272246272251*G0_0_1_0_5 + 0.000410453743787077*G0_0_1_1_0 + 0.0718294051627408*G0_0_1_1_1 + 0.0944043610710311*G0_0_1_1_3 - 0.00492544492544508*G0_0_1_1_4 + 0.000820907487574337*G0_0_1_1_5 - 0.0004104537437871*G0_0_1_2_0 - 0.0718294051627409*G0_0_1_2_2 - 0.0944043610710311*G0_0_1_2_3 - 0.000820907487574124*G0_0_1_2_4 + 0.00492544492544505*G0_0_1_2_5 + 0.0944043610710311*G0_0_1_3_1 - 0.0944043610710311*G0_0_1_3_2 + 0.0098508898508902*G0_0_1_3_4 - 0.00985088985089007*G0_0_1_3_5 - 0.00246272246272261*G0_0_1_4_0 - 0.00492544492544508*G0_0_1_4_1 - 0.000820907487574124*G0_0_1_4_2 + 0.0098508898508902*G0_0_1_4_3 + 0.0525380792047475*G0_0_1_4_4 + 0.00246272246272251*G0_0_1_5_0 + 0.000820907487574338*G0_0_1_5_1 + 0.00492544492544505*G0_0_1_5_2 - 0.00985088985089007*G0_0_1_5_3 - 0.0525380792047474*G0_0_1_5_5 + 0.000205226871893573*G0_1_0_0_1 - 0.000205226871893564*G0_1_0_0_2 - 0.00861952861952895*G0_1_0_0_4 + 0.00861952861952883*G0_1_0_0_5 + 0.000205226871893573*G0_1_0_1_0 + 0.175674202340875*G0_1_0_1_1 + 0.0796280262946957*G0_1_0_1_3 - 0.00328362995029674*G0_1_0_1_4 - 0.00615680615680625*G0_1_0_1_5 - 0.000205226871893565*G0_1_0_2_0 - 0.175674202340875*G0_1_0_2_2 - 0.0796280262946956*G0_1_0_2_3 + 0.00615680615680641*G0_1_0_2_4 + 0.00328362995029669*G0_1_0_2_5 + 0.0796280262946956*G0_1_0_3_1 - 0.0796280262946957*G0_1_0_3_2 + 0.00656725990059347*G0_1_0_3_4 - 0.00656725990059341*G0_1_0_3_5 - 0.00861952861952895*G0_1_0_4_0 - 0.00328362995029674*G0_1_0_4_1 + 0.00615680615680641*G0_1_0_4_2 + 0.00656725990059347*G0_1_0_4_3 + 0.062388969055638*G0_1_0_4_4 + 0.00861952861952883*G0_1_0_5_0 - 0.00615680615680626*G0_1_0_5_1 + 0.00328362995029669*G0_1_0_5_2 - 0.00656725990059341*G0_1_0_5_3 - 0.0623889690556379*G0_1_0_5_5 + 0.0213435946769287*G0_1_1_0_0 - 0.00458340013895584*G0_1_1_0_1 - 0.00218908663353117*G0_1_1_0_2 - 0.000410453743787127*G0_1_1_0_3 + 0.000136817914595662*G0_1_1_0_4 + 0.0240799529688427*G0_1_1_0_5 - 0.00458340013895584*G0_1_1_1_0 + 0.195786435786442*G0_1_1_1_1 - 0.00376249265138167*G0_1_1_1_2 + 0.0923520923520955*G0_1_1_1_3 - 0.00807225696114612*G0_1_1_1_4 - 0.00533589866923204*G0_1_1_1_5 - 0.00218908663353117*G0_1_1_2_0 - 0.00376249265138167*G0_1_1_2_1 - 0.0640307840307862*G0_1_1_2_2 - 0.077712575490356*G0_1_1_2_3 + 0.000547271658382844*G0_1_1_2_4 + 0.000410453743787066*G0_1_1_2_5 - 0.000410453743787127*G0_1_1_3_0 + 0.0923520923520955*G0_1_1_3_1 - 0.077712575490356*G0_1_1_3_2 - 0.0673144139810831*G0_1_1_3_3 + 0.0169654214098664*G0_1_1_3_4 + 0.000136817914595663*G0_1_1_4_0 - 0.00807225696114612*G0_1_1_4_1 + 0.000547271658382843*G0_1_1_4_2 + 0.0169654214098664*G0_1_1_4_3 + 0.0563689808134271*G0_1_1_4_4 + 0.0153236064347181*G0_1_1_4_5 + 0.0240799529688427*G0_1_1_5_0 - 0.00533589866923204*G0_1_1_5_1 + 0.000410453743787066*G0_1_1_5_2 + 0.0153236064347181*G0_1_1_5_4 - 0.0344781144781156*G0_1_1_5_5;
    A[78] = -A[86] + 0.00574635241301926*G0_0_0_0_0 - 0.000752498530276335*G0_0_0_0_1 - 0.0160076960076965*G0_0_0_0_2 + 0.00177863288974406*G0_0_0_0_3 - 0.0158708780931008*G0_0_0_0_4 - 0.00424135535246657*G0_0_0_0_5 - 0.000752498530276335*G0_0_0_1_0 - 0.00410453743787082*G0_0_0_1_1 - 0.000684089572978451*G0_0_0_1_2 + 0.0109454331676558*G0_0_0_1_3 + 0.000410453743787109*G0_0_0_1_4 + 0.00547271658382785*G0_0_0_1_5 - 0.0160076960076965*G0_0_0_2_0 - 0.000684089572978451*G0_0_0_2_1 + 0.192913259579933*G0_0_0_2_2 - 0.00643044198599785*G0_0_0_2_3 + 0.080312115867674*G0_0_0_2_4 - 0.00177863288974404*G0_0_0_2_5 + 0.00177863288974406*G0_0_0_3_0 + 0.0109454331676558*G0_0_0_3_1 - 0.00643044198599785*G0_0_0_3_2 - 0.0651253273475517*G0_0_0_3_3 - 0.00437817326706234*G0_0_0_3_4 - 0.0158708780931008*G0_0_0_4_0 + 0.00041045374378711*G0_0_0_4_1 + 0.080312115867674*G0_0_0_4_2 - 0.00437817326706234*G0_0_0_4_3 + 0.0902998236331598*G0_0_0_4_4 + 0.00273635829191394*G0_0_0_4_5 - 0.00424135535246657*G0_0_0_5_0 + 0.00547271658382785*G0_0_0_5_1 - 0.00177863288974404*G0_0_0_5_2 + 0.00273635829191395*G0_0_0_5_4 + 0.0158708780931007*G0_0_0_5_5 - 0.004514991181658*G0_1_0_0_0 + 0.00136817914595701*G0_1_0_0_1 - 0.000752498530276339*G0_1_0_0_2 + 0.027089947089948*G0_1_0_0_3 + 0.00916680027791171*G0_1_0_0_4 - 0.00300999412110531*G0_1_0_0_5 + 0.00136817914595701*G0_1_0_1_0 - 0.121083854417193*G0_1_0_1_1 + 0.0177863288974407*G0_1_0_1_2 - 0.0164181497514838*G0_1_0_1_3 + 0.00547271658382789*G0_1_0_1_4 - 0.00075249853027634*G0_1_0_2_0 + 0.0177863288974407*G0_1_0_2_1 - 0.00697771364438061*G0_1_0_2_2 - 0.0276372187483308*G0_1_0_2_3 - 0.000684089572978499*G0_1_0_2_4 + 0.00246272246272254*G0_1_0_2_5 + 0.027089947089948*G0_1_0_3_0 - 0.0164181497514838*G0_1_0_3_1 - 0.0276372187483308*G0_1_0_3_2 - 0.220003206669881*G0_1_0_3_3 - 0.0651253273475518*G0_1_0_3_4 - 0.0591053391053412*G0_1_0_3_5 + 0.00916680027791171*G0_1_0_4_0 + 0.00547271658382789*G0_1_0_4_1 - 0.000684089572978501*G0_1_0_4_2 - 0.0651253273475518*G0_1_0_4_3 - 0.0142290631179523*G0_1_0_4_4 - 0.0158708780931009*G0_1_0_4_5 - 0.00300999412110531*G0_1_0_5_0 + 0.00246272246272254*G0_1_0_5_2 - 0.0591053391053412*G0_1_0_5_3 - 0.0158708780931009*G0_1_0_5_4 + 0.0755234888568247*G0_1_0_5_5;
    A[123] = -A[78] - 0.00451499118165793*G0_1_0_0_0 - 0.000752498530276334*G0_1_0_0_1 + 0.00136817914595695*G0_1_0_0_2 + 0.027089947089948*G0_1_0_0_3 - 0.00300999412110531*G0_1_0_0_4 + 0.00916680027791171*G0_1_0_0_5 - 0.000752498530276333*G0_1_0_1_0 - 0.00697771364438062*G0_1_0_1_1 + 0.0177863288974406*G0_1_0_1_2 - 0.027637218748331*G0_1_0_1_3 + 0.00246272246272255*G0_1_0_1_4 - 0.000684089572978517*G0_1_0_1_5 + 0.00136817914595695*G0_1_0_2_0 + 0.0177863288974406*G0_1_0_2_1 - 0.121083854417192*G0_1_0_2_2 - 0.0164181497514836*G0_1_0_2_3 + 0.00547271658382785*G0_1_0_2_5 + 0.027089947089948*G0_1_0_3_0 - 0.027637218748331*G0_1_0_3_1 - 0.0164181497514836*G0_1_0_3_2 - 0.220003206669881*G0_1_0_3_3 - 0.0591053391053412*G0_1_0_3_4 - 0.0651253273475518*G0_1_0_3_5 - 0.00300999412110531*G0_1_0_4_0 + 0.00246272246272255*G0_1_0_4_1 - 0.0591053391053411*G0_1_0_4_3 + 0.0755234888568248*G0_1_0_4_4 - 0.0158708780931008*G0_1_0_4_5 + 0.00916680027791171*G0_1_0_5_0 - 0.000684089572978518*G0_1_0_5_1 + 0.00547271658382785*G0_1_0_5_2 - 0.0651253273475518*G0_1_0_5_3 - 0.0158708780931008*G0_1_0_5_4 - 0.0142290631179524*G0_1_0_5_5 + 0.00574635241301933*G0_1_1_0_0 - 0.0160076960076967*G0_1_1_0_1 - 0.000752498530276332*G0_1_1_0_2 + 0.00177863288974405*G0_1_1_0_3 - 0.0042413553524666*G0_1_1_0_4 - 0.0158708780931009*G0_1_1_0_5 - 0.0160076960076967*G0_1_1_1_0 + 0.192913259579935*G0_1_1_1_1 - 0.000684089572978537*G0_1_1_1_2 - 0.00643044198599756*G0_1_1_1_3 - 0.00177863288974408*G0_1_1_1_4 + 0.0803121158676747*G0_1_1_1_5 - 0.000752498530276332*G0_1_1_2_0 - 0.000684089572978537*G0_1_1_2_1 - 0.00410453743787073*G0_1_1_2_2 + 0.0109454331676558*G0_1_1_2_3 + 0.00547271658382789*G0_1_1_2_4 + 0.000410453743787062*G0_1_1_2_5 + 0.00177863288974405*G0_1_1_3_0 - 0.00643044198599755*G0_1_1_3_1 + 0.0109454331676558*G0_1_1_3_2 - 0.065125327347552*G0_1_1_3_3 - 0.00437817326706224*G0_1_1_3_5 - 0.0042413553524666*G0_1_1_4_0 - 0.00177863288974408*G0_1_1_4_1 + 0.00547271658382789*G0_1_1_4_2 + 0.0158708780931009*G0_1_1_4_4 + 0.00273635829191395*G0_1_1_4_5 - 0.0158708780931009*G0_1_1_5_0 + 0.0803121158676747*G0_1_1_5_1 + 0.000410453743787062*G0_1_1_5_2 - 0.00437817326706224*G0_1_1_5_3 + 0.00273635829191395*G0_1_1_5_4 + 0.0902998236331602*G0_1_1_5_5;
    A[172] = -A[52] + 0.014058040724708*G0_0_0_0_0 + 0.00164181497514836*G0_0_0_0_1 + 0.00651595318262007*G0_0_0_0_2 - 0.00769600769600799*G0_0_0_0_3 + 0.0160076960076965*G0_0_0_0_4 - 0.0130319063652401*G0_0_0_0_5 + 0.00164181497514836*G0_0_0_1_0 + 0.00410453743787135*G0_0_0_1_1 + 0.00312970979637656*G0_0_0_1_2 + 0.00410453743787102*G0_0_0_1_3 - 0.000923520923521027*G0_0_0_1_4 + 0.00205226871893549*G0_0_0_1_5 + 0.00651595318262007*G0_0_0_2_0 + 0.00312970979637656*G0_0_0_2_1 + 0.0519223985890667*G0_0_0_2_2 - 0.0243193843193852*G0_0_0_2_3 - 0.0429950296616978*G0_0_0_2_4 - 0.00441237774571123*G0_0_0_2_5 - 0.00769600769600799*G0_0_0_3_0 + 0.00410453743787102*G0_0_0_3_1 - 0.0243193843193852*G0_0_0_3_2 + 0.0225749559082905*G0_0_0_3_3 + 0.017239057239058*G0_0_0_3_4 + 0.0242167708834385*G0_0_0_3_5 + 0.0160076960076965*G0_0_0_4_0 - 0.000923520923521028*G0_0_0_4_1 - 0.0429950296616978*G0_0_0_4_2 + 0.017239057239058*G0_0_0_4_3 - 0.320564373897717*G0_0_0_4_4 + 0.0106717973384645*G0_0_0_4_5 - 0.0130319063652401*G0_0_0_5_0 + 0.00205226871893549*G0_0_0_5_1 - 0.00441237774571123*G0_0_0_5_2 + 0.0242167708834385*G0_0_0_5_3 + 0.0106717973384645*G0_0_0_5_4 + 0.0233958633958641*G0_0_0_5_5 - 0.0378643578643595*G0_0_1_0_0 - 0.00148789482122818*G0_0_1_0_1 - 0.00328362995029673*G0_0_1_0_3 + 0.0590027256693941*G0_0_1_0_4 + 0.0112874779541449*G0_0_1_0_5 - 0.00148789482122818*G0_0_1_1_0 + 0.0014878948212282*G0_0_1_1_2 + 0.00205226871893549*G0_0_1_1_3 - 0.00205226871893545*G0_0_1_1_5 + 0.0014878948212282*G0_0_1_2_1 + 0.0378643578643588*G0_0_1_2_2 - 0.011287477954145*G0_0_1_2_3 - 0.0590027256693942*G0_0_1_2_4 + 0.00328362995029679*G0_0_1_2_5 - 0.00328362995029673*G0_0_1_3_0 + 0.00205226871893549*G0_0_1_3_1 - 0.011287477954145*G0_0_1_3_2 - 0.000820907487574091*G0_0_1_3_3 + 0.00656725990059346*G0_0_1_3_4 + 0.0590027256693941*G0_0_1_4_0 - 0.0590027256693942*G0_0_1_4_2 + 0.00656725990059345*G0_0_1_4_3 - 0.0065672599005936*G0_0_1_4_5 + 0.0112874779541449*G0_0_1_5_0 - 0.00205226871893545*G0_0_1_5_1 + 0.00328362995029679*G0_0_1_5_2 - 0.0065672599005936*G0_0_1_5_4 + 0.000820907487573826*G0_0_1_5_5;
    A[158] = A[172] - 0.00902998236331609*G0_0_0_0_0 - 0.0010774410774411*G0_0_0_0_1 - 0.00128266794933467*G0_0_0_0_2 + 0.00338624338624351*G0_0_0_0_3 - 0.00246272246272251*G0_0_0_0_4 + 0.00369408369408387*G0_0_0_0_5 - 0.0010774410774411*G0_0_0_1_0 - 0.0122109988776663*G0_0_0_1_1 - 0.000666987333654033*G0_0_0_1_2 - 0.00184704184704191*G0_0_0_1_3 + 0.00256533589866934*G0_0_0_1_4 + 0.00194965528298855*G0_0_0_1_5 - 0.00128266794933467*G0_0_0_2_0 - 0.000666987333654033*G0_0_0_2_1 + 0.00964566297899704*G0_0_0_2_2 + 0.00790123456790156*G0_0_0_2_3 + 0.0101587301587306*G0_0_0_2_4 + 0.00133397466730806*G0_0_0_2_5 + 0.00338624338624351*G0_0_0_3_0 - 0.00184704184704191*G0_0_0_3_1 + 0.00790123456790156*G0_0_0_3_2 - 0.0106717973384644*G0_0_0_3_3 - 0.0119031585698257*G0_0_0_3_4 - 0.00944043610710314*G0_0_0_3_5 - 0.00246272246272251*G0_0_0_4_0 + 0.00256533589866934*G0_0_0_4_1 + 0.0101587301587306*G0_0_0_4_2 - 0.0119031585698257*G0_0_0_4_3 + 0.113285233285237*G0_0_0_4_4 - 0.00779862113195478*G0_0_0_4_5 + 0.00369408369408387*G0_0_0_5_0 + 0.00194965528298855*G0_0_0_5_1 + 0.00133397466730806*G0_0_0_5_2 - 0.00944043610710314*G0_0_0_5_3 - 0.00779862113195478*G0_0_0_5_4 - 0.0123136123136128*G0_0_0_5_5 - 0.000820907487574192*G0_0_1_0_1 + 0.000820907487574156*G0_0_1_0_2 - 0.0204200737534077*G0_0_1_0_4 + 0.0204200737534079*G0_0_1_0_5 - 0.000820907487574192*G0_0_1_1_0 - 0.0112874779541452*G0_0_1_1_1 - 0.00348885682219031*G0_0_1_1_3 + 0.0018470418470419*G0_0_1_1_4 - 0.0189834856501531*G0_0_1_1_5 + 0.000820907487574155*G0_0_1_2_0 + 0.0112874779541453*G0_0_1_2_2 + 0.00348885682219032*G0_0_1_2_3 + 0.018983485650153*G0_0_1_2_4 - 0.00184704184704192*G0_0_1_2_5 - 0.00348885682219031*G0_0_1_3_1 + 0.00348885682219032*G0_0_1_3_2 - 0.00369408369408381*G0_0_1_3_4 + 0.00369408369408381*G0_0_1_3_5 - 0.0204200737534077*G0_0_1_4_0 + 0.0018470418470419*G0_0_1_4_1 + 0.018983485650153*G0_0_1_4_2 - 0.00369408369408381*G0_0_1_4_3 - 0.0508962642295989*G0_0_1_4_4 + 0.0204200737534079*G0_0_1_5_0 - 0.0189834856501531*G0_0_1_5_1 - 0.00184704184704193*G0_0_1_5_2 + 0.0036940836940838*G0_0_1_5_3 + 0.0508962642295995*G0_0_1_5_5 - 0.000615680615680587*G0_1_0_0_1 + 0.000615680615680651*G0_1_0_0_2 + 0.00318101651434998*G0_1_0_0_4 - 0.00318101651434988*G0_1_0_0_5 - 0.000615680615680587*G0_1_0_1_0 - 0.0134423601090278*G0_1_0_1_1 - 0.00400192400192414*G0_1_0_1_3 + 0.00307840307840317*G0_1_0_1_4 + 0.00256533589866906*G0_1_0_1_5 + 0.000615680615680651*G0_1_0_2_0 + 0.0134423601090271*G0_1_0_2_2 + 0.00400192400192406*G0_1_0_2_3 - 0.00256533589866942*G0_1_0_2_4 - 0.00307840307840317*G0_1_0_2_5 - 0.00400192400192414*G0_1_0_3_1 + 0.00400192400192406*G0_1_0_3_2 - 0.00615680615680635*G0_1_0_3_4 + 0.00615680615680632*G0_1_0_3_5 + 0.00318101651434998*G0_1_0_4_0 + 0.00307840307840317*G0_1_0_4_1 - 0.00256533589866942*G0_1_0_4_2 - 0.00615680615680635*G0_1_0_4_3 - 0.0336572069905413*G0_1_0_4_4 - 0.00318101651434988*G0_1_0_5_0 + 0.00256533589866906*G0_1_0_5_1 - 0.00307840307840317*G0_1_0_5_2 + 0.00615680615680632*G0_1_0_5_3 + 0.0336572069905409*G0_1_0_5_5 + 0.00902998236331569*G0_1_1_0_0 + 0.00128266794933473*G0_1_1_0_1 + 0.00107744107744111*G0_1_1_0_2 - 0.00338624338624349*G0_1_1_0_3 - 0.00369408369408391*G0_1_1_0_4 + 0.00246272246272249*G0_1_1_0_5 + 0.00128266794933473*G0_1_1_1_0 - 0.00964566297899699*G0_1_1_1_1 + 0.000666987333654039*G0_1_1_1_2 - 0.00790123456790158*G0_1_1_1_3 - 0.00133397466730806*G0_1_1_1_4 - 0.0101587301587307*G0_1_1_1_5 + 0.00107744107744111*G0_1_1_2_0 + 0.000666987333654039*G0_1_1_2_1 + 0.0122109988776659*G0_1_1_2_2 + 0.00184704184704193*G0_1_1_2_3 - 0.00194965528298859*G0_1_1_2_4 - 0.00256533589866926*G0_1_1_2_5 - 0.00338624338624349*G0_1_1_3_0 - 0.00790123456790158*G0_1_1_3_1 + 0.00184704184704193*G0_1_1_3_2 + 0.0106717973384642*G0_1_1_3_3 + 0.00944043610710312*G0_1_1_3_4 + 0.0119031585698255*G0_1_1_3_5 - 0.00369408369408391*G0_1_1_4_0 - 0.00133397466730806*G0_1_1_4_1 - 0.00194965528298859*G0_1_1_4_2 + 0.00944043610710312*G0_1_1_4_3 + 0.012313612313613*G0_1_1_4_4 + 0.00779862113195466*G0_1_1_4_5 + 0.00246272246272249*G0_1_1_5_0 - 0.0101587301587307*G0_1_1_5_1 - 0.00256533589866926*G0_1_1_5_2 + 0.0119031585698255*G0_1_1_5_3 + 0.00779862113195466*G0_1_1_5_4 - 0.113285233285238*G0_1_1_5_5;
    A[155] = -A[158] - 0.0378643578643593*G0_0_1_0_0 - 0.00148789482122822*G0_0_1_0_2 - 0.00328362995029669*G0_0_1_0_3 + 0.011287477954145*G0_0_1_0_4 + 0.0590027256693944*G0_0_1_0_5 + 0.0378643578643597*G0_0_1_1_1 + 0.0014878948212282*G0_0_1_1_2 - 0.011287477954145*G0_0_1_1_3 + 0.00328362995029671*G0_0_1_1_4 - 0.0590027256693944*G0_0_1_1_5 - 0.00148789482122822*G0_0_1_2_0 + 0.0014878948212282*G0_0_1_2_1 + 0.00205226871893553*G0_0_1_2_3 - 0.00205226871893538*G0_0_1_2_4 - 0.00328362995029669*G0_0_1_3_0 - 0.011287477954145*G0_0_1_3_1 + 0.00205226871893553*G0_0_1_3_2 - 0.000820907487574542*G0_0_1_3_3 + 0.00656725990059332*G0_0_1_3_5 + 0.011287477954145*G0_0_1_4_0 + 0.00328362995029671*G0_0_1_4_1 - 0.00205226871893538*G0_0_1_4_2 + 0.000820907487574185*G0_0_1_4_4 - 0.00656725990059347*G0_0_1_4_5 + 0.0590027256693944*G0_0_1_5_0 - 0.0590027256693944*G0_0_1_5_1 + 0.00656725990059332*G0_0_1_5_3 - 0.00656725990059348*G0_0_1_5_4 + 0.0140580407247077*G0_1_1_0_0 + 0.00651595318262007*G0_1_1_0_1 + 0.00164181497514835*G0_1_1_0_2 - 0.00769600769600794*G0_1_1_0_3 - 0.0130319063652402*G0_1_1_0_4 + 0.0160076960076965*G0_1_1_0_5 + 0.00651595318262008*G0_1_1_1_0 + 0.0519223985890677*G0_1_1_1_1 + 0.00312970979637655*G0_1_1_1_2 - 0.0243193843193851*G0_1_1_1_3 - 0.00441237774571126*G0_1_1_1_4 - 0.0429950296616977*G0_1_1_1_5 + 0.00164181497514835*G0_1_1_2_0 + 0.00312970979637655*G0_1_1_2_1 + 0.00410453743787095*G0_1_1_2_2 + 0.00410453743787101*G0_1_1_2_3 + 0.00205226871893556*G0_1_1_2_4 - 0.000923520923520898*G0_1_1_2_5 - 0.00769600769600794*G0_1_1_3_0 - 0.0243193843193851*G0_1_1_3_1 + 0.00410453743787101*G0_1_1_3_2 + 0.0225749559082898*G0_1_1_3_3 + 0.0242167708834384*G0_1_1_3_4 + 0.0172390572390577*G0_1_1_3_5 - 0.0130319063652402*G0_1_1_4_0 - 0.00441237774571126*G0_1_1_4_1 + 0.00205226871893556*G0_1_1_4_2 + 0.0242167708834384*G0_1_1_4_3 + 0.0233958633958646*G0_1_1_4_4 + 0.0106717973384644*G0_1_1_4_5 + 0.0160076960076965*G0_1_1_5_0 - 0.0429950296616977*G0_1_1_5_1 - 0.000923520923520896*G0_1_1_5_2 + 0.0172390572390577*G0_1_1_5_3 + 0.0106717973384644*G0_1_1_5_4 - 0.320564373897719*G0_1_1_5_5;
    A[85] = A[155] - 0.0016418149751484*G0_0_1_0_0 - 0.00251402918069594*G0_0_1_0_1 - 0.000820907487574201*G0_0_1_0_2 + 0.00215488215488219*G0_0_1_0_3 + 0.00133397466730801*G0_0_1_0_4 - 0.0227801827801836*G0_0_1_0_5 - 0.00251402918069594*G0_0_1_1_0 - 0.0395061728395079*G0_0_1_1_1 - 0.00230880230880241*G0_0_1_1_2 + 0.012621452621453*G0_0_1_1_3 - 0.0011287477954145*G0_0_1_1_4 + 0.0362225428892108*G0_0_1_1_5 - 0.000820907487574201*G0_0_1_2_0 - 0.00230880230880241*G0_0_1_2_1 - 0.0037966971300304*G0_0_1_2_2 - 0.0012313612313612*G0_0_1_2_3 + 0.000820907487574289*G0_0_1_2_4 + 0.00338624338624348*G0_0_1_2_5 + 0.00215488215488219*G0_0_1_3_0 + 0.012621452621453*G0_0_1_3_1 - 0.0012313612313612*G0_0_1_3_2 + 0.00410453743787127*G0_0_1_3_3 - 0.00205226871893536*G0_0_1_3_4 - 0.0110822510822513*G0_0_1_3_5 + 0.00133397466730801*G0_0_1_4_0 - 0.0011287477954145*G0_0_1_4_1 + 0.000820907487574289*G0_0_1_4_2 - 0.00205226871893537*G0_0_1_4_3 + 0.00328362995029694*G0_0_1_4_4 - 0.00451499118165796*G0_0_1_4_5 - 0.0227801827801836*G0_0_1_5_0 + 0.0362225428892108*G0_0_1_5_1 + 0.00338624338624348*G0_0_1_5_2 - 0.0110822510822513*G0_0_1_5_3 - 0.00451499118165796*G0_0_1_5_4 + 0.0213435946769293*G0_0_1_5_5 + 0.0016418149751484*G0_1_0_0_0 + 0.00251402918069594*G0_1_0_0_1 + 0.000820907487574201*G0_1_0_0_2 - 0.00215488215488219*G0_1_0_0_3 - 0.00133397466730801*G0_1_0_0_4 + 0.0227801827801836*G0_1_0_0_5 + 0.00251402918069594*G0_1_0_1_0 + 0.0395061728395079*G0_1_0_1_1 + 0.00230880230880241*G0_1_0_1_2 - 0.012621452621453*G0_1_0_1_3 + 0.0011287477954145*G0_1_0_1_4 - 0.0362225428892108*G0_1_0_1_5 + 0.000820907487574201*G0_1_0_2_0 + 0.00230880230880241*G0_1_0_2_1 + 0.0037966971300304*G0_1_0_2_2 + 0.0012313612313612*G0_1_0_2_3 - 0.000820907487574289*G0_1_0_2_4 - 0.00338624338624348*G0_1_0_2_5 - 0.00215488215488219*G0_1_0_3_0 - 0.012621452621453*G0_1_0_3_1 + 0.0012313612313612*G0_1_0_3_2 - 0.00410453743787128*G0_1_0_3_3 + 0.00205226871893537*G0_1_0_3_4 + 0.0110822510822513*G0_1_0_3_5 - 0.00133397466730801*G0_1_0_4_0 + 0.0011287477954145*G0_1_0_4_1 - 0.000820907487574288*G0_1_0_4_2 + 0.00205226871893537*G0_1_0_4_3 - 0.00328362995029694*G0_1_0_4_4 + 0.00451499118165796*G0_1_0_4_5 + 0.0227801827801836*G0_1_0_5_0 - 0.0362225428892108*G0_1_0_5_1 - 0.00338624338624348*G0_1_0_5_2 + 0.0110822510822513*G0_1_0_5_3 + 0.00451499118165796*G0_1_0_5_4 - 0.0213435946769293*G0_1_0_5_5;
    A[130] = -A[85] - 0.0378643578643593*G0_1_0_0_0 - 0.00148789482122822*G0_1_0_0_2 - 0.00328362995029669*G0_1_0_0_3 + 0.0112874779541449*G0_1_0_0_4 + 0.0590027256693944*G0_1_0_0_5 + 0.0378643578643597*G0_1_0_1_1 + 0.0014878948212282*G0_1_0_1_2 - 0.011287477954145*G0_1_0_1_3 + 0.00328362995029671*G0_1_0_1_4 - 0.0590027256693944*G0_1_0_1_5 - 0.00148789482122822*G0_1_0_2_0 + 0.0014878948212282*G0_1_0_2_1 + 0.00205226871893553*G0_1_0_2_3 - 0.00205226871893538*G0_1_0_2_4 - 0.00328362995029669*G0_1_0_3_0 - 0.011287477954145*G0_1_0_3_1 + 0.00205226871893553*G0_1_0_3_2 - 0.000820907487574544*G0_1_0_3_3 + 0.00656725990059332*G0_1_0_3_5 + 0.0112874779541449*G0_1_0_4_0 + 0.00328362995029671*G0_1_0_4_1 - 0.00205226871893538*G0_1_0_4_2 + 0.000820907487574185*G0_1_0_4_4 - 0.00656725990059347*G0_1_0_4_5 + 0.0590027256693944*G0_1_0_5_0 - 0.0590027256693944*G0_1_0_5_1 + 0.00656725990059332*G0_1_0_5_3 - 0.00656725990059348*G0_1_0_5_4 + 0.0140580407247077*G0_1_1_0_0 + 0.00651595318262008*G0_1_1_0_1 + 0.00164181497514835*G0_1_1_0_2 - 0.00769600769600794*G0_1_1_0_3 - 0.0130319063652402*G0_1_1_0_4 + 0.0160076960076965*G0_1_1_0_5 + 0.00651595318262008*G0_1_1_1_0 + 0.0519223985890677*G0_1_1_1_1 + 0.00312970979637655*G0_1_1_1_2 - 0.0243193843193851*G0_1_1_1_3 - 0.00441237774571126*G0_1_1_1_4 - 0.0429950296616977*G0_1_1_1_5 + 0.00164181497514835*G0_1_1_2_0 + 0.00312970979637655*G0_1_1_2_1 + 0.00410453743787095*G0_1_1_2_2 + 0.00410453743787101*G0_1_1_2_3 + 0.00205226871893556*G0_1_1_2_4 - 0.000923520923520897*G0_1_1_2_5 - 0.00769600769600794*G0_1_1_3_0 - 0.0243193843193851*G0_1_1_3_1 + 0.00410453743787101*G0_1_1_3_2 + 0.0225749559082898*G0_1_1_3_3 + 0.0242167708834384*G0_1_1_3_4 + 0.0172390572390577*G0_1_1_3_5 - 0.0130319063652402*G0_1_1_4_0 - 0.00441237774571126*G0_1_1_4_1 + 0.00205226871893556*G0_1_1_4_2 + 0.0242167708834384*G0_1_1_4_3 + 0.0233958633958646*G0_1_1_4_4 + 0.0106717973384644*G0_1_1_4_5 + 0.0160076960076965*G0_1_1_5_0 - 0.0429950296616977*G0_1_1_5_1 - 0.000923520923520896*G0_1_1_5_2 + 0.0172390572390577*G0_1_1_5_3 + 0.0106717973384644*G0_1_1_5_4 - 0.320564373897719*G0_1_1_5_5;
    A[105] = A[7] - 0.21269841269842*G0_0_1_0_0 + 0.0139169472502811*G0_0_1_0_1 + 0.00634920634920657*G0_0_1_0_2 - 0.0016033349366683*G0_0_1_0_3 - 0.0226390893057568*G0_0_1_0_4 - 0.0616321949655305*G0_0_1_0_5 + 0.0139169472502811*G0_0_1_1_0 - 0.00221260221260229*G0_0_1_1_1 - 0.00109988776655448*G0_0_1_1_2 + 0.00111592111592115*G0_0_1_1_3 + 0.00493827160493844*G0_0_1_1_4 + 0.00962000962000996*G0_0_1_1_5 + 0.00634920634920657*G0_0_1_2_0 - 0.00109988776655448*G0_0_1_2_1 + 0.000814494147827652*G0_0_1_2_2 + 0.00168029501362844*G0_0_1_2_3 + 0.00218053551386896*G0_0_1_2_4 + 0.00365560365560379*G0_0_1_2_5 - 0.0016033349366683*G0_0_1_3_0 + 0.00111592111592115*G0_0_1_3_1 + 0.00168029501362844*G0_0_1_3_2 + 0.00041045374378712*G0_0_1_3_3 - 0.00666987333654023*G0_0_1_3_4 - 0.00410453743787091*G0_0_1_3_5 - 0.0226390893057568*G0_0_1_4_0 + 0.00493827160493844*G0_0_1_4_1 + 0.00218053551386896*G0_0_1_4_2 - 0.00666987333654023*G0_0_1_4_3 - 0.0297578964245642*G0_0_1_4_4 - 0.0171877505210845*G0_0_1_4_5 - 0.0616321949655305*G0_0_1_5_0 + 0.00962000962000996*G0_0_1_5_1 + 0.00365560365560379*G0_0_1_5_2 - 0.00410453743787091*G0_0_1_5_3 - 0.0171877505210845*G0_0_1_5_4 - 0.0389931056597738*G0_0_1_5_5 + 0.21269841269842*G0_1_0_0_0 - 0.0139169472502811*G0_1_0_0_1 - 0.00634920634920657*G0_1_0_0_2 + 0.0016033349366683*G0_1_0_0_3 + 0.0226390893057568*G0_1_0_0_4 + 0.0616321949655305*G0_1_0_0_5 - 0.0139169472502811*G0_1_0_1_0 + 0.00221260221260229*G0_1_0_1_1 + 0.00109988776655448*G0_1_0_1_2 - 0.00111592111592115*G0_1_0_1_3 - 0.00493827160493844*G0_1_0_1_4 - 0.00962000962000996*G0_1_0_1_5 - 0.00634920634920657*G0_1_0_2_0 + 0.00109988776655448*G0_1_0_2_1 - 0.000814494147827659*G0_1_0_2_2 - 0.00168029501362845*G0_1_0_2_3 - 0.00218053551386896*G0_1_0_2_4 - 0.00365560365560379*G0_1_0_2_5 + 0.0016033349366683*G0_1_0_3_0 - 0.00111592111592115*G0_1_0_3_1 - 0.00168029501362844*G0_1_0_3_2 - 0.000410453743787141*G0_1_0_3_3 + 0.00666987333654023*G0_1_0_3_4 + 0.00410453743787091*G0_1_0_3_5 + 0.0226390893057568*G0_1_0_4_0 - 0.00493827160493844*G0_1_0_4_1 - 0.00218053551386896*G0_1_0_4_2 + 0.00666987333654023*G0_1_0_4_3 + 0.0297578964245642*G0_1_0_4_4 + 0.0171877505210845*G0_1_0_4_5 + 0.0616321949655305*G0_1_0_5_0 - 0.00962000962000996*G0_1_0_5_1 - 0.00365560365560379*G0_1_0_5_2 + 0.00410453743787091*G0_1_0_5_3 + 0.0171877505210845*G0_1_0_5_4 + 0.0389931056597738*G0_1_0_5_5;
    A[10] = A[105] + 0.212698412698421*G0_0_0_0_0 - 0.00822510822510851*G0_0_0_0_1 - 0.0120410453743791*G0_0_0_0_2 + 0.0016033349366683*G0_0_0_0_3 + 0.0693923360590051*G0_0_0_0_4 + 0.0148789482122822*G0_0_0_0_5 - 0.00822510822510851*G0_0_0_1_0 + 0.0316370049703394*G0_0_0_1_1 + 0.00109988776655447*G0_0_0_1_2 + 0.0224979958313299*G0_0_0_1_3 - 0.0010133076799744*G0_0_0_1_4 + 0.0104409171075841*G0_0_0_1_5 - 0.0120410453743791*G0_0_0_2_0 + 0.00109988776655447*G0_0_0_2_1 - 0.0302388969055646*G0_0_0_2_2 - 0.0252942119608795*G0_0_0_2_3 - 0.022241462241463*G0_0_0_2_4 - 0.00758056758056786*G0_0_0_2_5 + 0.0016033349366683*G0_0_0_3_0 + 0.0224979958313299*G0_0_0_3_1 - 0.0252942119608795*G0_0_0_3_2 - 0.000410453743787211*G0_0_0_3_3 - 0.00118005451338789*G0_0_0_3_4 + 0.011954465287799*G0_0_0_3_5 + 0.0693923360590051*G0_0_0_4_0 - 0.0010133076799744*G0_0_0_4_1 - 0.022241462241463*G0_0_0_4_2 - 0.00118005451338789*G0_0_0_4_3 + 0.0472021805355156*G0_0_0_4_4 + 0.0171877505210845*G0_0_0_4_5 + 0.0148789482122822*G0_0_0_5_0 + 0.0104409171075841*G0_0_0_5_1 - 0.00758056758056786*G0_0_0_5_2 + 0.011954465287799*G0_0_0_5_3 + 0.0171877505210845*G0_0_0_5_4 + 0.0215488215488224*G0_0_0_5_5 - 0.00187590187590196*G0_0_1_0_1 + 0.00187590187590192*G0_0_1_0_2 + 0.00776014109347478*G0_0_1_0_4 - 0.00776014109347459*G0_0_1_0_5 - 0.00187590187590196*G0_0_1_1_0 + 0.0324514991181669*G0_0_1_1_1 + 0.0241782908449583*G0_0_1_1_3 + 0.00264229597562939*G0_0_1_1_4 + 0.012621452621453*G0_0_1_1_5 + 0.00187590187590192*G0_0_1_2_0 - 0.032451499118167*G0_0_1_2_2 - 0.0241782908449583*G0_0_1_2_3 - 0.0126214526214531*G0_0_1_2_4 - 0.00264229597562941*G0_0_1_2_5 + 0.0241782908449583*G0_0_1_3_1 - 0.0241782908449584*G0_0_1_3_2 - 0.00528459195125881*G0_0_1_3_4 + 0.00528459195125879*G0_0_1_3_5 + 0.00776014109347478*G0_0_1_4_0 + 0.00264229597562939*G0_0_1_4_1 - 0.0126214526214531*G0_0_1_4_2 - 0.00528459195125881*G0_0_1_4_3 + 0.0082090748757419*G0_0_1_4_4 - 0.00776014109347459*G0_0_1_5_0 + 0.012621452621453*G0_0_1_5_1 - 0.00264229597562941*G0_0_1_5_2 + 0.00528459195125879*G0_0_1_5_3 - 0.00820907487574173*G0_0_1_5_5 + 0.00569183902517256*G0_1_0_0_1 - 0.00569183902517257*G0_1_0_0_2 + 0.0467532467532484*G0_1_0_0_4 - 0.0467532467532483*G0_1_0_0_5 + 0.00569183902517256*G0_1_0_1_0 + 0.029424402757737*G0_1_0_1_1 + 0.023613916947251*G0_1_0_1_3 + 0.00392496392496404*G0_1_0_1_4 + 0.0200609267275941*G0_1_0_1_5 - 0.00569183902517257*G0_1_0_2_0 - 0.029424402757737*G0_1_0_2_2 - 0.0236139169472511*G0_1_0_2_3 - 0.0200609267275941*G0_1_0_2_4 - 0.00392496392496406*G0_1_0_2_5 + 0.023613916947251*G0_1_0_3_1 - 0.0236139169472511*G0_1_0_3_2 - 0.00784992784992814*G0_1_0_3_4 + 0.00784992784992809*G0_1_0_3_5 + 0.0467532467532484*G0_1_0_4_0 + 0.00392496392496404*G0_1_0_4_1 - 0.0200609267275941*G0_1_0_4_2 - 0.00784992784992814*G0_1_0_4_3 + 0.0174442841109513*G0_1_0_4_4 - 0.0467532467532483*G0_1_0_5_0 + 0.0200609267275941*G0_1_0_5_1 - 0.00392496392496406*G0_1_0_5_2 + 0.00784992784992809*G0_1_0_5_3 - 0.0174442841109515*G0_1_0_5_5 - 0.21269841269842*G0_1_1_0_0 + 0.0120410453743791*G0_1_1_0_1 + 0.0082251082251085*G0_1_1_0_2 - 0.00160333493666828*G0_1_1_0_3 - 0.014878948212282*G0_1_1_0_4 - 0.0693923360590051*G0_1_1_0_5 + 0.0120410453743791*G0_1_1_1_0 + 0.0302388969055645*G0_1_1_1_1 - 0.00109988776655445*G0_1_1_1_2 + 0.0252942119608794*G0_1_1_1_3 + 0.00758056758056783*G0_1_1_1_4 + 0.022241462241463*G0_1_1_1_5 + 0.0082251082251085*G0_1_1_2_0 - 0.00109988776655445*G0_1_1_2_1 - 0.0316370049703395*G0_1_1_2_2 - 0.0224979958313299*G0_1_1_2_3 - 0.0104409171075841*G0_1_1_2_4 + 0.00101330767997439*G0_1_1_2_5 - 0.00160333493666828*G0_1_1_3_0 + 0.0252942119608794*G0_1_1_3_1 - 0.0224979958313299*G0_1_1_3_2 + 0.000410453743786905*G0_1_1_3_3 - 0.0119544652877991*G0_1_1_3_4 + 0.00118005451338784*G0_1_1_3_5 - 0.014878948212282*G0_1_1_4_0 + 0.00758056758056783*G0_1_1_4_1 - 0.0104409171075841*G0_1_1_4_2 - 0.0119544652877991*G0_1_1_4_3 - 0.0215488215488223*G0_1_1_4_4 - 0.0171877505210845*G0_1_1_4_5 - 0.0693923360590051*G0_1_1_5_0 + 0.022241462241463*G0_1_1_5_1 + 0.00101330767997439*G0_1_1_5_2 + 0.00118005451338784*G0_1_1_5_3 - 0.0171877505210845*G0_1_1_5_4 - 0.0472021805355157*G0_1_1_5_5;
    A[150] = A[10] + 0.21269841269842*G0_0_1_0_0 - 0.00634920634920655*G0_0_1_0_1 - 0.0139169472502811*G0_0_1_0_2 + 0.0016033349366683*G0_0_1_0_3 + 0.0616321949655303*G0_0_1_0_4 + 0.0226390893057568*G0_0_1_0_5 - 0.00634920634920655*G0_0_1_1_0 - 0.000814494147827555*G0_0_1_1_1 + 0.00109988776655448*G0_0_1_1_2 - 0.00168029501362842*G0_0_1_1_3 - 0.00365560365560378*G0_0_1_1_4 - 0.00218053551386895*G0_0_1_1_5 - 0.0139169472502811*G0_0_1_2_0 + 0.00109988776655448*G0_0_1_2_1 + 0.00221260221260227*G0_0_1_2_2 - 0.00111592111592116*G0_0_1_2_3 - 0.00962000962000993*G0_0_1_2_4 - 0.00493827160493844*G0_0_1_2_5 + 0.0016033349366683*G0_0_1_3_0 - 0.00168029501362842*G0_0_1_3_1 - 0.00111592111592116*G0_0_1_3_2 - 0.000410453743787093*G0_0_1_3_3 + 0.00410453743787091*G0_0_1_3_4 + 0.00666987333654022*G0_0_1_3_5 + 0.0616321949655304*G0_0_1_4_0 - 0.00365560365560378*G0_0_1_4_1 - 0.00962000962000993*G0_0_1_4_2 + 0.00410453743787091*G0_0_1_4_3 + 0.0389931056597736*G0_0_1_4_4 + 0.0171877505210845*G0_0_1_4_5 + 0.0226390893057568*G0_0_1_5_0 - 0.00218053551386895*G0_0_1_5_1 - 0.00493827160493844*G0_0_1_5_2 + 0.00666987333654022*G0_0_1_5_3 + 0.0171877505210845*G0_0_1_5_4 + 0.029757896424564*G0_0_1_5_5 - 0.21269841269842*G0_1_0_0_0 + 0.00634920634920655*G0_1_0_0_1 + 0.0139169472502811*G0_1_0_0_2 - 0.0016033349366683*G0_1_0_0_3 - 0.0616321949655304*G0_1_0_0_4 - 0.0226390893057568*G0_1_0_0_5 + 0.00634920634920655*G0_1_0_1_0 + 0.000814494147827555*G0_1_0_1_1 - 0.00109988776655448*G0_1_0_1_2 + 0.00168029501362842*G0_1_0_1_3 + 0.00365560365560378*G0_1_0_1_4 + 0.00218053551386895*G0_1_0_1_5 + 0.0139169472502811*G0_1_0_2_0 - 0.00109988776655448*G0_1_0_2_1 - 0.00221260221260227*G0_1_0_2_2 + 0.00111592111592116*G0_1_0_2_3 + 0.00962000962000993*G0_1_0_2_4 + 0.00493827160493844*G0_1_0_2_5 - 0.0016033349366683*G0_1_0_3_0 + 0.00168029501362842*G0_1_0_3_1 + 0.00111592111592116*G0_1_0_3_2 + 0.000410453743787099*G0_1_0_3_3 - 0.00410453743787091*G0_1_0_3_4 - 0.00666987333654022*G0_1_0_3_5 - 0.0616321949655304*G0_1_0_4_0 + 0.00365560365560378*G0_1_0_4_1 + 0.00962000962000993*G0_1_0_4_2 - 0.00410453743787091*G0_1_0_4_3 - 0.0389931056597736*G0_1_0_4_4 - 0.0171877505210845*G0_1_0_4_5 - 0.0226390893057568*G0_1_0_5_0 + 0.00218053551386895*G0_1_0_5_1 + 0.00493827160493844*G0_1_0_5_2 - 0.00666987333654022*G0_1_0_5_3 - 0.0171877505210845*G0_1_0_5_4 - 0.029757896424564*G0_1_0_5_5;
    A[98] = -A[95] + 0.00697771364438066*G0_0_1_0_0 + 0.0007524985302763*G0_0_1_0_1 - 0.0177863288974406*G0_0_1_0_2 - 0.00246272246272257*G0_0_1_0_3 + 0.0276372187483307*G0_0_1_0_4 + 0.000684089572978497*G0_0_1_0_5 + 0.0007524985302763*G0_0_1_1_0 + 0.00451499118165812*G0_0_1_1_1 - 0.00136817914595696*G0_0_1_1_2 + 0.00300999412110543*G0_0_1_1_3 - 0.027089947089948*G0_0_1_1_4 - 0.00916680027791161*G0_0_1_1_5 - 0.0177863288974406*G0_0_1_2_0 - 0.00136817914595696*G0_0_1_2_1 + 0.121083854417191*G0_0_1_2_2 + 0.0164181497514837*G0_0_1_2_4 - 0.00547271658382787*G0_0_1_2_5 - 0.00246272246272257*G0_0_1_3_0 + 0.00300999412110543*G0_0_1_3_1 - 0.0755234888568249*G0_0_1_3_3 + 0.0591053391053411*G0_0_1_3_4 + 0.0158708780931009*G0_0_1_3_5 + 0.0276372187483307*G0_0_1_4_0 - 0.027089947089948*G0_0_1_4_1 + 0.0164181497514837*G0_0_1_4_2 + 0.0591053391053411*G0_0_1_4_3 + 0.220003206669881*G0_0_1_4_4 + 0.0651253273475518*G0_0_1_4_5 + 0.000684089572978502*G0_0_1_5_0 - 0.00916680027791161*G0_0_1_5_1 - 0.00547271658382787*G0_0_1_5_2 + 0.0158708780931009*G0_0_1_5_3 + 0.0651253273475518*G0_0_1_5_4 + 0.0142290631179529*G0_0_1_5_5 + 0.199890973224313*G0_1_1_0_0 - 0.0152551974774202*G0_1_1_0_1 - 0.0184704184704191*G0_1_1_0_2 - 0.00424135535246665*G0_1_1_0_3 + 0.021206776762333*G0_1_1_0_4 + 0.0809962054406528*G0_1_1_0_5 - 0.0152551974774202*G0_1_1_1_0 + 0.0102613435946774*G0_1_1_1_1 - 0.0021206776762333*G0_1_1_1_2 - 0.00123136123136124*G0_1_1_1_3 - 0.0253113142002039*G0_1_1_1_4 - 0.0250376783710125*G0_1_1_1_5 - 0.0184704184704191*G0_1_1_2_0 - 0.0021206776762333*G0_1_1_2_1 + 0.116979316979321*G0_1_1_2_2 + 0.00547271658382785*G0_1_1_2_3 + 0.0273635829191395*G0_1_1_2_4 - 0.00506226284004077*G0_1_1_2_5 - 0.00424135535246665*G0_1_1_3_0 - 0.00123136123136124*G0_1_1_3_1 + 0.00547271658382785*G0_1_1_3_2 - 0.0596526107637239*G0_1_1_3_3 + 0.0591053391053411*G0_1_1_3_4 + 0.0186072363850148*G0_1_1_3_5 + 0.021206776762333*G0_1_1_4_0 - 0.0253113142002039*G0_1_1_4_1 + 0.0273635829191395*G0_1_1_4_2 + 0.0591053391053411*G0_1_1_4_3 + 0.154877879322329*G0_1_1_4_4 + 0.0607471540804895*G0_1_1_4_5 + 0.0809962054406528*G0_1_1_5_0 - 0.0250376783710125*G0_1_1_5_1 - 0.00506226284004077*G0_1_1_5_2 + 0.0186072363850148*G0_1_1_5_3 + 0.0607471540804895*G0_1_1_5_4 + 0.104528886751113*G0_1_1_5_5;
    A[126] = A[98] - 0.0164181497514837*G0_0_1_0_0 + 0.0184020095131212*G0_0_1_0_2 + 0.00410453743787091*G0_0_1_0_3 - 0.0247640425418211*G0_0_1_0_4 - 0.00396771952327523*G0_0_1_0_5 - 0.00369408369408384*G0_0_1_1_1 + 0.00779862113195473*G0_0_1_1_3 + 0.0240799529688427*G0_0_1_1_4 + 0.00779862113195472*G0_0_1_1_5 + 0.0184020095131212*G0_0_1_2_0 - 0.0164181497514833*G0_0_1_2_2 - 0.00396771952327521*G0_0_1_2_3 - 0.0247640425418212*G0_0_1_2_4 + 0.00410453743787091*G0_0_1_2_5 + 0.00410453743787091*G0_0_1_3_0 + 0.00779862113195473*G0_0_1_3_1 - 0.00396771952327521*G0_0_1_3_2 - 0.0164181497514838*G0_0_1_3_3 - 0.0563689808134272*G0_0_1_3_4 - 0.0164181497514837*G0_0_1_3_5 - 0.0247640425418211*G0_0_1_4_0 + 0.0240799529688427*G0_0_1_4_1 - 0.0247640425418212*G0_0_1_4_2 - 0.0563689808134272*G0_0_1_4_3 - 0.232043183154302*G0_0_1_4_4 - 0.0563689808134272*G0_0_1_4_5 - 0.00396771952327524*G0_0_1_5_0 + 0.00779862113195472*G0_0_1_5_1 + 0.00410453743787091*G0_0_1_5_2 - 0.0164181497514837*G0_0_1_5_3 - 0.0563689808134272*G0_0_1_5_4 - 0.0164181497514838*G0_0_1_5_5 + 0.0164181497514837*G0_1_0_0_0 - 0.0184020095131212*G0_1_0_0_2 - 0.00410453743787091*G0_1_0_0_3 + 0.0247640425418211*G0_1_0_0_4 + 0.00396771952327523*G0_1_0_0_5 + 0.00369408369408384*G0_1_0_1_1 - 0.00779862113195472*G0_1_0_1_3 - 0.0240799529688427*G0_1_0_1_4 - 0.00779862113195472*G0_1_0_1_5 - 0.0184020095131212*G0_1_0_2_0 + 0.0164181497514833*G0_1_0_2_2 + 0.0039677195232752*G0_1_0_2_3 + 0.0247640425418212*G0_1_0_2_4 - 0.00410453743787091*G0_1_0_2_5 - 0.00410453743787091*G0_1_0_3_0 - 0.00779862113195473*G0_1_0_3_1 + 0.00396771952327521*G0_1_0_3_2 + 0.0164181497514838*G0_1_0_3_3 + 0.0563689808134272*G0_1_0_3_4 + 0.0164181497514837*G0_1_0_3_5 + 0.0247640425418211*G0_1_0_4_0 - 0.0240799529688427*G0_1_0_4_1 + 0.0247640425418212*G0_1_0_4_2 + 0.0563689808134272*G0_1_0_4_3 + 0.232043183154302*G0_1_0_4_4 + 0.0563689808134272*G0_1_0_4_5 + 0.00396771952327523*G0_1_0_5_0 - 0.00779862113195472*G0_1_0_5_1 - 0.00410453743787091*G0_1_0_5_2 + 0.0164181497514837*G0_1_0_5_3 + 0.0563689808134272*G0_1_0_5_4 + 0.0164181497514838*G0_1_0_5_5;
    A[173] = -A[170] + 0.0143658810325483*G0_0_1_0_0 + 0.00280476724921183*G0_0_1_0_1 + 0.000684089572978482*G0_0_1_0_2 + 0.00738816738816764*G0_0_1_0_3 - 0.00766180321735896*G0_0_1_0_4 - 0.019838597616376*G0_0_1_0_5 + 0.00280476724921183*G0_0_1_1_0 - 0.114106140772813*G0_0_1_1_1 + 0.0017786328897441*G0_0_1_1_2 + 0.00574635241301914*G0_0_1_1_3 + 0.000547271658382813*G0_0_1_1_4 + 0.0061568061568061*G0_0_1_1_5 + 0.000684089572978481*G0_0_1_2_0 + 0.0017786328897441*G0_0_1_2_1 - 0.0054727165838279*G0_0_1_2_3 + 0.00547271658382784*G0_0_1_2_4 - 0.00246272246272256*G0_0_1_2_5 + 0.00738816738816764*G0_0_1_3_0 + 0.00574635241301914*G0_0_1_3_1 - 0.0054727165838279*G0_0_1_3_2 - 0.0158708780931009*G0_0_1_3_4 - 0.00985088985089017*G0_0_1_3_5 - 0.00766180321735897*G0_0_1_4_0 + 0.000547271658382813*G0_0_1_4_1 + 0.00547271658382784*G0_0_1_4_2 - 0.0158708780931009*G0_0_1_4_3 + 0.0317417561862018*G0_0_1_4_4 + 0.00383090160867952*G0_0_1_4_5 - 0.019838597616376*G0_0_1_5_0 + 0.0061568061568061*G0_0_1_5_1 - 0.00246272246272256*G0_0_1_5_2 - 0.00985088985089016*G0_0_1_5_3 + 0.00383090160867952*G0_0_1_5_4 + 0.121494308160979*G0_0_1_5_5 - 0.00574635241301937*G0_1_1_0_0 + 0.0160076960076967*G0_1_1_0_1 + 0.000752498530276327*G0_1_1_0_2 - 0.00177863288974404*G0_1_1_0_3 + 0.00424135535246658*G0_1_1_0_4 + 0.0158708780931009*G0_1_1_0_5 + 0.0160076960076967*G0_1_1_1_0 - 0.192913259579935*G0_1_1_1_1 + 0.000684089572978536*G0_1_1_1_2 + 0.00643044198599756*G0_1_1_1_3 + 0.00177863288974407*G0_1_1_1_4 - 0.0803121158676748*G0_1_1_1_5 + 0.000752498530276327*G0_1_1_2_0 + 0.000684089572978535*G0_1_1_2_1 + 0.00410453743787088*G0_1_1_2_2 - 0.0109454331676558*G0_1_1_2_3 - 0.00547271658382786*G0_1_1_2_4 - 0.000410453743787047*G0_1_1_2_5 - 0.00177863288974404*G0_1_1_3_0 + 0.00643044198599757*G0_1_1_3_1 - 0.0109454331676558*G0_1_1_3_2 + 0.0651253273475519*G0_1_1_3_3 + 0.0043781732670622*G0_1_1_3_5 + 0.00424135535246658*G0_1_1_4_0 + 0.00177863288974407*G0_1_1_4_1 - 0.00547271658382785*G0_1_1_4_2 - 0.0158708780931008*G0_1_1_4_4 - 0.00273635829191398*G0_1_1_4_5 + 0.0158708780931009*G0_1_1_5_0 - 0.0803121158676748*G0_1_1_5_1 - 0.000410453743787047*G0_1_1_5_2 + 0.0043781732670622*G0_1_1_5_3 - 0.00273635829191398*G0_1_1_5_4 - 0.0902998236331606*G0_1_1_5_5;
    A[217] = A[119] + 0.0153920153920166*G0_0_1_0_0 - 0.00277056277056293*G0_0_1_0_1 + 0.0252429052429061*G0_0_1_0_2 - 0.0080038480038482*G0_0_1_0_3 + 0.0735738335738363*G0_0_1_0_4 + 0.00831168831168899*G0_0_1_0_5 - 0.00277056277056293*G0_0_1_1_0 + 0.00677248677248688*G0_0_1_1_1 + 0.00215488215488228*G0_0_1_1_2 - 0.0243193843193852*G0_0_1_1_3 - 0.00861952861952885*G0_0_1_1_4 - 0.0138528138528145*G0_0_1_1_5 + 0.0252429052429061*G0_0_1_2_0 + 0.00215488215488228*G0_0_1_2_1 + 0.0123136123136119*G0_0_1_2_2 + 0.00769600769600776*G0_0_1_2_3 - 0.18316498316499*G0_0_1_2_4 - 0.0166233766233772*G0_0_1_2_5 - 0.00800384800384821*G0_0_1_3_0 - 0.0243193843193852*G0_0_1_3_1 + 0.00769600769600778*G0_0_1_3_2 + 0.14530062530063*G0_0_1_3_3 + 0.0332467532467541*G0_0_1_3_4 + 0.0492544492544509*G0_0_1_3_5 + 0.0735738335738363*G0_0_1_4_0 - 0.00861952861952885*G0_0_1_4_1 - 0.18316498316499*G0_0_1_4_2 + 0.0332467532467541*G0_0_1_4_3 - 0.236421356421366*G0_0_1_4_4 + 0.0504858104858121*G0_0_1_4_5 + 0.00831168831168899*G0_0_1_5_0 - 0.0138528138528145*G0_0_1_5_1 - 0.0166233766233772*G0_0_1_5_2 + 0.0492544492544509*G0_0_1_5_3 + 0.0504858104858121*G0_0_1_5_4 + 0.0714189514189542*G0_0_1_5_5 - 0.0153920153920166*G0_1_0_0_0 + 0.00277056277056293*G0_1_0_0_1 - 0.0252429052429061*G0_1_0_0_2 + 0.0080038480038482*G0_1_0_0_3 - 0.0735738335738363*G0_1_0_0_4 - 0.008311688311689*G0_1_0_0_5 + 0.00277056277056293*G0_1_0_1_0 - 0.00677248677248688*G0_1_0_1_1 - 0.00215488215488228*G0_1_0_1_2 + 0.0243193843193852*G0_1_0_1_3 + 0.00861952861952885*G0_1_0_1_4 + 0.0138528138528145*G0_1_0_1_5 - 0.0252429052429061*G0_1_0_2_0 - 0.00215488215488228*G0_1_0_2_1 - 0.0123136123136119*G0_1_0_2_2 - 0.00769600769600776*G0_1_0_2_3 + 0.18316498316499*G0_1_0_2_4 + 0.0166233766233772*G0_1_0_2_5 + 0.00800384800384821*G0_1_0_3_0 + 0.0243193843193852*G0_1_0_3_1 - 0.00769600769600778*G0_1_0_3_2 - 0.14530062530063*G0_1_0_3_3 - 0.0332467532467541*G0_1_0_3_4 - 0.0492544492544509*G0_1_0_3_5 - 0.0735738335738363*G0_1_0_4_0 + 0.00861952861952885*G0_1_0_4_1 + 0.18316498316499*G0_1_0_4_2 - 0.0332467532467541*G0_1_0_4_3 + 0.236421356421366*G0_1_0_4_4 - 0.0504858104858121*G0_1_0_4_5 - 0.008311688311689*G0_1_0_5_0 + 0.0138528138528145*G0_1_0_5_1 + 0.0166233766233772*G0_1_0_5_2 - 0.0492544492544509*G0_1_0_5_3 - 0.0504858104858121*G0_1_0_5_4 - 0.0714189514189542*G0_1_0_5_5;
    A[22] = A[106] + 0.00695206028539393*G0_0_1_0_0 + 0.000641333974667334*G0_0_1_0_3 - 0.0107615840949178*G0_0_1_0_4 - 0.00220618887285558*G0_0_1_0_5 - 0.00137245470578811*G0_0_1_1_3 + 0.001372454705788*G0_0_1_1_5 - 0.00695206028539388*G0_0_1_2_2 + 0.00220618887285559*G0_0_1_2_3 + 0.0107615840949178*G0_0_1_2_4 - 0.000641333974667334*G0_0_1_2_5 + 0.000641333974667335*G0_0_1_3_0 - 0.00137245470578811*G0_0_1_3_1 + 0.00220618887285559*G0_0_1_3_2 - 0.000615680615680648*G0_0_1_3_3 - 0.00128266794933466*G0_0_1_3_4 - 0.0107615840949178*G0_0_1_4_0 + 0.0107615840949178*G0_0_1_4_2 - 0.00128266794933466*G0_0_1_4_3 + 0.00128266794933468*G0_0_1_4_5 - 0.00220618887285559*G0_0_1_5_0 + 0.001372454705788*G0_0_1_5_1 - 0.000641333974667334*G0_0_1_5_2 + 0.00128266794933468*G0_0_1_5_4 + 0.0006156806156806*G0_0_1_5_5 - 0.00695206028539393*G0_1_0_0_0 - 0.000641333974667334*G0_1_0_0_3 + 0.0107615840949178*G0_1_0_0_4 + 0.00220618887285558*G0_1_0_0_5 + 0.00137245470578811*G0_1_0_1_3 - 0.001372454705788*G0_1_0_1_5 + 0.00695206028539388*G0_1_0_2_2 - 0.00220618887285559*G0_1_0_2_3 - 0.0107615840949178*G0_1_0_2_4 + 0.000641333974667334*G0_1_0_2_5 - 0.000641333974667335*G0_1_0_3_0 + 0.00137245470578811*G0_1_0_3_1 - 0.00220618887285559*G0_1_0_3_2 + 0.000615680615680649*G0_1_0_3_3 + 0.00128266794933466*G0_1_0_3_4 + 0.0107615840949178*G0_1_0_4_0 - 0.0107615840949178*G0_1_0_4_2 + 0.00128266794933466*G0_1_0_4_3 - 0.00128266794933468*G0_1_0_4_5 + 0.00220618887285559*G0_1_0_5_0 - 0.001372454705788*G0_1_0_5_1 + 0.000641333974667334*G0_1_0_5_2 - 0.00128266794933468*G0_1_0_5_4 - 0.0006156806156806*G0_1_0_5_5;
    A[9] = A[135] + 0.378771845438526*G0_0_1_0_0 - 0.0225322003099789*G0_0_1_0_1 - 0.0225322003099789*G0_0_1_0_2 + 0.00504516060071628*G0_0_1_0_3 + 0.0951739618406317*G0_0_1_0_4 + 0.0951739618406319*G0_0_1_0_5 - 0.0225322003099789*G0_0_1_1_0 + 0.00233445566778907*G0_0_1_1_1 + 0.00167174389396618*G0_0_1_1_2 - 0.000820907487574189*G0_0_1_1_3 - 0.00649885094329561*G0_0_1_1_4 - 0.011544011544012*G0_0_1_1_5 - 0.0225322003099789*G0_0_1_2_0 + 0.00167174389396618*G0_0_1_2_1 + 0.00233445566778907*G0_0_1_2_2 - 0.000820907487574186*G0_0_1_2_3 - 0.0115440115440119*G0_0_1_2_4 - 0.00649885094329562*G0_0_1_2_5 + 0.00504516060071628*G0_0_1_3_0 - 0.000820907487574189*G0_0_1_3_1 - 0.000820907487574184*G0_0_1_3_2 - 0.000752498530276417*G0_0_1_3_3 + 0.00290738068515855*G0_0_1_3_4 + 0.00290738068515855*G0_0_1_3_5 + 0.0951739618406317*G0_0_1_4_0 - 0.00649885094329561*G0_0_1_4_1 - 0.0115440115440119*G0_0_1_4_2 + 0.00290738068515855*G0_0_1_4_3 + 0.0519908075463648*G0_0_1_4_4 + 0.0259954037731825*G0_0_1_4_5 + 0.095173961840632*G0_0_1_5_0 - 0.011544011544012*G0_0_1_5_1 - 0.00649885094329562*G0_0_1_5_2 + 0.00290738068515855*G0_0_1_5_3 + 0.0259954037731825*G0_0_1_5_4 + 0.051990807546365*G0_0_1_5_5 - 0.378771845438526*G0_1_0_0_0 + 0.0225322003099789*G0_1_0_0_1 + 0.0225322003099789*G0_1_0_0_2 - 0.00504516060071628*G0_1_0_0_3 - 0.0951739618406317*G0_1_0_0_4 - 0.0951739618406319*G0_1_0_0_5 + 0.0225322003099789*G0_1_0_1_0 - 0.00233445566778907*G0_1_0_1_1 - 0.00167174389396618*G0_1_0_1_2 + 0.00082090748757419*G0_1_0_1_3 + 0.00649885094329561*G0_1_0_1_4 + 0.011544011544012*G0_1_0_1_5 + 0.0225322003099789*G0_1_0_2_0 - 0.00167174389396618*G0_1_0_2_1 - 0.00233445566778907*G0_1_0_2_2 + 0.000820907487574185*G0_1_0_2_3 + 0.0115440115440119*G0_1_0_2_4 + 0.00649885094329562*G0_1_0_2_5 - 0.00504516060071628*G0_1_0_3_0 + 0.000820907487574192*G0_1_0_3_1 + 0.000820907487574185*G0_1_0_3_2 + 0.000752498530276417*G0_1_0_3_3 - 0.00290738068515855*G0_1_0_3_4 - 0.00290738068515855*G0_1_0_3_5 - 0.0951739618406317*G0_1_0_4_0 + 0.00649885094329561*G0_1_0_4_1 + 0.0115440115440119*G0_1_0_4_2 - 0.00290738068515855*G0_1_0_4_3 - 0.0519908075463648*G0_1_0_4_4 - 0.0259954037731825*G0_1_0_4_5 - 0.0951739618406319*G0_1_0_5_0 + 0.011544011544012*G0_1_0_5_1 + 0.00649885094329562*G0_1_0_5_2 - 0.00290738068515855*G0_1_0_5_3 - 0.0259954037731825*G0_1_0_5_4 - 0.051990807546365*G0_1_0_5_5;
    A[90] = A[9] + 0.378771845438526*G0_0_0_0_0 - 0.018577307466197*G0_0_0_0_1 - 0.0264870931537607*G0_0_0_0_2 + 0.00504516060071628*G0_0_0_0_3 + 0.12176794399017*G0_0_0_0_4 + 0.0685799796910933*G0_0_0_0_5 - 0.018577307466197*G0_0_0_1_0 + 0.0148532948532953*G0_0_0_1_1 + 0.00167174389396617*G0_0_0_1_2 + 0.00932072043183184*G0_0_0_1_3 - 0.00482283148949832*G0_0_0_1_4 - 0.00244562022339809*G0_0_0_1_5 - 0.0264870931537607*G0_0_0_2_0 + 0.00167174389396618*G0_0_0_2_1 - 0.0101843835177172*G0_0_0_2_2 - 0.0109625354069802*G0_0_0_2_3 - 0.0206424028646258*G0_0_0_2_4 - 0.00817487039709291*G0_0_0_2_5 + 0.00504516060071628*G0_0_0_3_0 + 0.00932072043183184*G0_0_0_3_1 - 0.0109625354069802*G0_0_0_3_2 - 0.000752498530276396*G0_0_0_3_3 - 0.00044465822243603*G0_0_0_3_4 + 0.00625941959275313*G0_0_0_3_5 + 0.12176794399017*G0_0_0_4_0 - 0.00482283148949832*G0_0_0_4_1 - 0.0206424028646258*G0_0_0_4_2 - 0.000444658222436028*G0_0_0_4_3 + 0.0615680615680635*G0_0_0_4_4 + 0.0259954037731825*G0_0_0_4_5 + 0.0685799796910933*G0_0_0_5_0 - 0.00244562022339809*G0_0_0_5_1 - 0.00817487039709291*G0_0_0_5_2 + 0.00625941959275313*G0_0_0_5_3 + 0.0259954037731824*G0_0_0_5_4 + 0.0424135535246661*G0_0_0_5_5 + 0.0039548928437819*G0_0_1_0_1 - 0.00395489284378185*G0_0_1_0_2 + 0.0265939821495385*G0_0_1_0_4 - 0.0265939821495387*G0_0_1_0_5 + 0.0039548928437819*G0_0_1_1_0 + 0.0125188391855062*G0_0_1_1_1 + 0.010141627919406*G0_0_1_1_3 + 0.0016760194537973*G0_0_1_1_4 + 0.00909839132061387*G0_0_1_1_5 - 0.00395489284378185*G0_0_1_2_0 - 0.0125188391855063*G0_0_1_2_2 - 0.010141627919406*G0_0_1_2_3 - 0.00909839132061383*G0_0_1_2_4 - 0.00167601945379728*G0_0_1_2_5 + 0.010141627919406*G0_0_1_3_1 - 0.010141627919406*G0_0_1_3_2 - 0.00335203890759459*G0_0_1_3_4 + 0.00335203890759457*G0_0_1_3_5 + 0.0265939821495385*G0_0_1_4_0 + 0.0016760194537973*G0_0_1_4_1 - 0.00909839132061383*G0_0_1_4_2 - 0.00335203890759459*G0_0_1_4_3 + 0.00957725402169863*G0_0_1_4_4 - 0.0265939821495387*G0_0_1_5_0 + 0.00909839132061387*G0_0_1_5_1 - 0.00167601945379728*G0_0_1_5_2 + 0.00335203890759457*G0_0_1_5_3 - 0.00957725402169891*G0_0_1_5_5 + 0.00395489284378188*G0_1_0_0_1 - 0.00395489284378186*G0_1_0_0_2 + 0.0265939821495386*G0_1_0_0_4 - 0.0265939821495387*G0_1_0_0_5 + 0.00395489284378188*G0_1_0_1_0 + 0.0125188391855063*G0_1_0_1_1 + 0.010141627919406*G0_1_0_1_3 + 0.00167601945379728*G0_1_0_1_4 + 0.00909839132061385*G0_1_0_1_5 - 0.00395489284378186*G0_1_0_2_0 - 0.0125188391855063*G0_1_0_2_2 - 0.010141627919406*G0_1_0_2_3 - 0.00909839132061384*G0_1_0_2_4 - 0.00167601945379729*G0_1_0_2_5 + 0.010141627919406*G0_1_0_3_1 - 0.010141627919406*G0_1_0_3_2 - 0.00335203890759457*G0_1_0_3_4 + 0.00335203890759458*G0_1_0_3_5 + 0.0265939821495386*G0_1_0_4_0 + 0.00167601945379728*G0_1_0_4_1 - 0.00909839132061384*G0_1_0_4_2 - 0.00335203890759458*G0_1_0_4_3 + 0.00957725402169873*G0_1_0_4_4 - 0.0265939821495387*G0_1_0_5_0 + 0.00909839132061385*G0_1_0_5_1 - 0.00167601945379729*G0_1_0_5_2 + 0.00335203890759458*G0_1_0_5_3 - 0.00957725402169884*G0_1_0_5_5 - 0.378771845438525*G0_1_1_0_0 + 0.0264870931537607*G0_1_1_0_1 + 0.018577307466197*G0_1_1_0_2 - 0.00504516060071628*G0_1_1_0_3 - 0.0685799796910931*G0_1_1_0_4 - 0.121767943990171*G0_1_1_0_5 + 0.0264870931537607*G0_1_1_1_0 + 0.0101843835177172*G0_1_1_1_1 - 0.00167174389396617*G0_1_1_1_2 + 0.0109625354069802*G0_1_1_1_3 + 0.00817487039709289*G0_1_1_1_4 + 0.0206424028646258*G0_1_1_1_5 + 0.018577307466197*G0_1_1_2_0 - 0.00167174389396617*G0_1_1_2_1 - 0.0148532948532954*G0_1_1_2_2 - 0.00932072043183186*G0_1_1_2_3 + 0.00244562022339808*G0_1_1_2_4 + 0.00482283148949833*G0_1_1_2_5 - 0.00504516060071628*G0_1_1_3_0 + 0.0109625354069802*G0_1_1_3_1 - 0.00932072043183186*G0_1_1_3_2 + 0.000752498530276362*G0_1_1_3_3 - 0.00625941959275313*G0_1_1_3_4 + 0.000444658222436023*G0_1_1_3_5 - 0.0685799796910931*G0_1_1_4_0 + 0.00817487039709289*G0_1_1_4_1 + 0.00244562022339808*G0_1_1_4_2 - 0.00625941959275313*G0_1_1_4_3 - 0.0424135535246661*G0_1_1_4_4 - 0.0259954037731825*G0_1_1_4_5 - 0.121767943990171*G0_1_1_5_0 + 0.0206424028646258*G0_1_1_5_1 + 0.00482283148949833*G0_1_1_5_2 + 0.000444658222436027*G0_1_1_5_3 - 0.0259954037731825*G0_1_1_5_4 - 0.0615680615680638*G0_1_1_5_5;
    A[6] = A[90] - 0.378771845438525*G0_0_1_0_0 + 0.0225322003099788*G0_0_1_0_1 + 0.0225322003099789*G0_0_1_0_2 - 0.00504516060071627*G0_0_1_0_3 - 0.0951739618406317*G0_0_1_0_4 - 0.0951739618406319*G0_0_1_0_5 + 0.0225322003099788*G0_0_1_1_0 - 0.00233445566778906*G0_0_1_1_1 - 0.00167174389396618*G0_0_1_1_2 + 0.000820907487574187*G0_0_1_1_3 + 0.0064988509432956*G0_0_1_1_4 + 0.0115440115440119*G0_0_1_1_5 + 0.0225322003099789*G0_0_1_2_0 - 0.00167174389396618*G0_0_1_2_1 - 0.00233445566778904*G0_0_1_2_2 + 0.000820907487574189*G0_0_1_2_3 + 0.0115440115440119*G0_0_1_2_4 + 0.00649885094329561*G0_0_1_2_5 - 0.00504516060071627*G0_0_1_3_0 + 0.000820907487574187*G0_0_1_3_1 + 0.000820907487574189*G0_0_1_3_2 + 0.000752498530276396*G0_0_1_3_3 - 0.00290738068515853*G0_0_1_3_4 - 0.00290738068515855*G0_0_1_3_5 - 0.0951739618406317*G0_0_1_4_0 + 0.0064988509432956*G0_0_1_4_1 + 0.0115440115440119*G0_0_1_4_2 - 0.00290738068515854*G0_0_1_4_3 - 0.0519908075463647*G0_0_1_4_4 - 0.0259954037731824*G0_0_1_4_5 - 0.0951739618406319*G0_0_1_5_0 + 0.0115440115440119*G0_0_1_5_1 + 0.00649885094329561*G0_0_1_5_2 - 0.00290738068515855*G0_0_1_5_3 - 0.0259954037731824*G0_0_1_5_4 - 0.051990807546365*G0_0_1_5_5 + 0.378771845438525*G0_1_0_0_0 - 0.0225322003099788*G0_1_0_0_1 - 0.0225322003099789*G0_1_0_0_2 + 0.00504516060071627*G0_1_0_0_3 + 0.0951739618406317*G0_1_0_0_4 + 0.0951739618406319*G0_1_0_0_5 - 0.0225322003099788*G0_1_0_1_0 + 0.00233445566778906*G0_1_0_1_1 + 0.00167174389396618*G0_1_0_1_2 - 0.000820907487574187*G0_1_0_1_3 - 0.0064988509432956*G0_1_0_1_4 - 0.0115440115440119*G0_1_0_1_5 - 0.0225322003099789*G0_1_0_2_0 + 0.00167174389396618*G0_1_0_2_1 + 0.00233445566778904*G0_1_0_2_2 - 0.000820907487574189*G0_1_0_2_3 - 0.0115440115440119*G0_1_0_2_4 - 0.00649885094329561*G0_1_0_2_5 + 0.00504516060071627*G0_1_0_3_0 - 0.000820907487574187*G0_1_0_3_1 - 0.000820907487574189*G0_1_0_3_2 - 0.000752498530276396*G0_1_0_3_3 + 0.00290738068515853*G0_1_0_3_4 + 0.00290738068515855*G0_1_0_3_5 + 0.0951739618406317*G0_1_0_4_0 - 0.0064988509432956*G0_1_0_4_1 - 0.0115440115440119*G0_1_0_4_2 + 0.00290738068515854*G0_1_0_4_3 + 0.0519908075463647*G0_1_0_4_4 + 0.0259954037731824*G0_1_0_4_5 + 0.0951739618406319*G0_1_0_5_0 - 0.0115440115440119*G0_1_0_5_1 - 0.00649885094329561*G0_1_0_5_2 + 0.00290738068515854*G0_1_0_5_3 + 0.0259954037731824*G0_1_0_5_4 + 0.051990807546365*G0_1_0_5_5;
    A[49] = -A[169] - 0.00502805836139182*G0_0_0_0_0 - 0.0014365881032548*G0_0_0_0_1 + 0.0199583132916472*G0_0_0_0_2 + 0.0126214526214531*G0_0_0_0_3 + 0.0348885682219026*G0_0_0_0_4 + 0.0163155363155368*G0_0_0_0_5 - 0.0014365881032548*G0_0_0_1_0 + 0.00820907487574159*G0_0_0_1_1 + 0.0126727593394264*G0_0_0_1_2 + 0.0287317620650963*G0_0_0_1_3 + 0.0156998556998562*G0_0_0_1_4 - 0.0102613435946772*G0_0_0_1_5 + 0.0199583132916472*G0_0_0_2_0 + 0.0126727593394264*G0_0_0_2_1 - 0.182036235369575*G0_0_0_2_2 - 0.066801346801349*G0_0_0_2_3 - 0.0990219656886356*G0_0_0_2_4 + 0.000307840307840296*G0_0_0_2_5 + 0.0126214526214531*G0_0_0_3_0 + 0.0287317620650963*G0_0_0_3_1 - 0.066801346801349*G0_0_0_3_2 + 0.062799422799425*G0_0_0_3_3 - 0.0566426166426186*G0_0_0_3_4 - 0.0258585858585868*G0_0_0_3_5 + 0.0348885682219026*G0_0_0_4_0 + 0.0156998556998562*G0_0_0_4_1 - 0.0990219656886356*G0_0_0_4_2 - 0.0566426166426186*G0_0_0_4_3 - 0.237652717652725*G0_0_0_4_4 - 0.0320153920153931*G0_0_0_4_5 + 0.0163155363155368*G0_0_0_5_0 - 0.0102613435946772*G0_0_0_5_1 + 0.000307840307840295*G0_0_0_5_2 - 0.0258585858585868*G0_0_0_5_3 - 0.0320153920153931*G0_0_0_5_4 - 0.0726503126503149*G0_0_0_5_5 + 0.00287317620650968*G0_0_1_0_0 - 0.00923520923520961*G0_0_1_0_1 + 0.00733686067019424*G0_0_1_0_2 - 0.0416610549943897*G0_0_1_0_3 - 0.00790123456790152*G0_0_1_0_4 + 0.000615680615680598*G0_0_1_0_5 - 0.00923520923520961*G0_0_1_1_0 + 0.27859547859549*G0_0_1_1_1 - 0.0215488215488224*G0_0_1_1_2 + 0.116979316979321*G0_0_1_1_3 + 0.00615680615680635*G0_0_1_1_4 + 0.0184704184704196*G0_0_1_1_5 + 0.00733686067019424*G0_0_1_2_0 - 0.0215488215488224*G0_0_1_2_1 + 0.00410453743787103*G0_0_1_2_2 - 0.0724450857784217*G0_0_1_2_3 - 0.0152894019560691*G0_0_1_2_4 - 0.0178547378547385*G0_0_1_2_5 - 0.0416610549943897*G0_0_1_3_0 + 0.116979316979321*G0_0_1_3_1 - 0.0724450857784217*G0_0_1_3_2 + 0.574635241301929*G0_0_1_3_3 + 0.0710084976751667*G0_0_1_3_4 + 0.119031585698257*G0_0_1_3_5 - 0.00790123456790152*G0_0_1_4_0 + 0.00615680615680635*G0_0_1_4_1 - 0.0152894019560691*G0_0_1_4_2 + 0.0710084976751667*G0_0_1_4_3 + 0.00164181497514809*G0_0_1_4_4 + 0.0233958633958642*G0_0_1_4_5 + 0.0006156806156806*G0_0_1_5_0 + 0.0184704184704196*G0_0_1_5_1 - 0.0178547378547385*G0_0_1_5_2 + 0.119031585698257*G0_0_1_5_3 + 0.0233958633958642*G0_0_1_5_4 - 0.0985088985089018*G0_0_1_5_5;
    A[34] = -A[37] - 0.00302709636042985*G0_1_0_0_0 + 0.00756774090107449*G0_1_0_0_2 + 0.00128266794933465*G0_1_0_0_3 + 0.007439474106141*G0_1_0_0_4 - 0.000564373897707288*G0_1_0_0_5 + 0.00302709636042983*G0_1_0_1_1 - 0.00756774090107452*G0_1_0_1_2 - 0.00743947410614105*G0_1_0_1_3 - 0.00128266794933467*G0_1_0_1_4 + 0.000564373897707267*G0_1_0_1_5 + 0.00756774090107449*G0_1_0_2_0 - 0.00756774090107452*G0_1_0_2_1 + 0.0389931056597738*G0_1_0_2_3 - 0.0389931056597737*G0_1_0_2_4 + 0.00128266794933465*G0_1_0_3_0 - 0.00743947410614105*G0_1_0_3_1 + 0.0389931056597738*G0_1_0_3_2 + 0.0092352092352098*G0_1_0_3_3 - 0.0025653358986693*G0_1_0_3_5 + 0.007439474106141*G0_1_0_4_0 - 0.00128266794933467*G0_1_0_4_1 - 0.0389931056597737*G0_1_0_4_2 - 0.00923520923520942*G0_1_0_4_4 + 0.00256533589866932*G0_1_0_4_5 - 0.000564373897707288*G0_1_0_5_0 + 0.000564373897707268*G0_1_0_5_1 - 0.0025653358986693*G0_1_0_5_3 + 0.00256533589866932*G0_1_0_5_4 + 0.0321628988295666*G0_1_1_0_0 - 0.00705788039121398*G0_1_1_0_1 - 0.00219015552348891*G0_1_1_0_2 - 0.00227032227032235*G0_1_1_0_3 + 0.0107231040564377*G0_1_1_0_4 + 0.0107487574154244*G0_1_1_0_5 - 0.00705788039121398*G0_1_1_1_0 + 0.0351899951899967*G0_1_1_1_1 - 0.00975789642456343*G0_1_1_1_2 + 0.00328362995029679*G0_1_1_1_3 - 0.003552990219657*G0_1_1_1_4 + 0.0113131313131318*G0_1_1_1_5 - 0.00219015552348891*G0_1_1_2_0 - 0.00975789642456343*G0_1_1_2_1 + 0.151707551707557*G0_1_1_2_2 + 0.0334776334776347*G0_1_1_2_3 - 0.00551547218213905*G0_1_1_2_4 - 0.00616963283629968*G0_1_1_2_5 - 0.00227032227032235*G0_1_1_3_0 + 0.00328362995029679*G0_1_1_3_1 + 0.0334776334776347*G0_1_1_3_2 + 0.0265768799102143*G0_1_1_3_3 + 0.0116466249799587*G0_1_1_3_4 + 0.0168799102132441*G0_1_1_3_5 + 0.0107231040564377*G0_1_1_4_0 - 0.003552990219657*G0_1_1_4_1 - 0.00551547218213905*G0_1_1_4_2 + 0.0116466249799587*G0_1_1_4_3 + 0.0173416706750045*G0_1_1_4_4 + 0.0194452461119134*G0_1_1_4_5 + 0.0107487574154244*G0_1_1_5_0 + 0.0113131313131318*G0_1_1_5_1 - 0.00616963283629968*G0_1_1_5_2 + 0.0168799102132441*G0_1_1_5_3 + 0.0194452461119134*G0_1_1_5_4 + 0.0850665383998747*G0_1_1_5_5;
    A[124] = -A[79] + 0.00287317620650975*G0_1_0_0_0 + 0.00733686067019419*G0_1_0_0_1 - 0.00923520923520947*G0_1_0_0_2 - 0.0416610549943896*G0_1_0_0_3 + 0.00061568061568073*G0_1_0_0_4 - 0.00790123456790142*G0_1_0_0_5 + 0.0073368606701942*G0_1_0_1_0 + 0.00410453743787102*G0_1_0_1_1 - 0.0215488215488222*G0_1_0_1_2 - 0.0724450857784216*G0_1_0_1_3 - 0.0178547378547384*G0_1_0_1_4 - 0.0152894019560691*G0_1_0_1_5 - 0.00923520923520947*G0_1_0_2_0 - 0.0215488215488222*G0_1_0_2_1 + 0.278595478595487*G0_1_0_2_2 + 0.116979316979321*G0_1_0_2_3 + 0.0184704184704188*G0_1_0_2_4 + 0.00615680615680639*G0_1_0_2_5 - 0.0416610549943896*G0_1_0_3_0 - 0.0724450857784216*G0_1_0_3_1 + 0.116979316979321*G0_1_0_3_2 + 0.574635241301928*G0_1_0_3_3 + 0.119031585698256*G0_1_0_3_4 + 0.0710084976751669*G0_1_0_3_5 + 0.000615680615680728*G0_1_0_4_0 - 0.0178547378547384*G0_1_0_4_1 + 0.0184704184704188*G0_1_0_4_2 + 0.119031585698256*G0_1_0_4_3 - 0.0985088985089022*G0_1_0_4_4 + 0.0233958633958642*G0_1_0_4_5 - 0.00790123456790142*G0_1_0_5_0 - 0.0152894019560691*G0_1_0_5_1 + 0.00615680615680638*G0_1_0_5_2 + 0.0710084976751669*G0_1_0_5_3 + 0.0233958633958642*G0_1_0_5_4 + 0.00164181497514895*G0_1_0_5_5 - 0.0050280583613917*G0_1_1_0_0 + 0.0199583132916474*G0_1_1_0_1 - 0.00143658810325481*G0_1_1_0_2 + 0.0126214526214531*G0_1_1_0_3 + 0.0163155363155369*G0_1_1_0_4 + 0.0348885682219028*G0_1_1_0_5 + 0.0199583132916474*G0_1_1_1_0 - 0.182036235369576*G0_1_1_1_1 + 0.0126727593394265*G0_1_1_1_2 - 0.0668013468013495*G0_1_1_1_3 + 0.000307840307840324*G0_1_1_1_4 - 0.0990219656886364*G0_1_1_1_5 - 0.00143658810325481*G0_1_1_2_0 + 0.0126727593394265*G0_1_1_2_1 + 0.00820907487574147*G0_1_1_2_2 + 0.0287317620650965*G0_1_1_2_3 - 0.0102613435946774*G0_1_1_2_4 + 0.0156998556998562*G0_1_1_2_5 + 0.0126214526214531*G0_1_1_3_0 - 0.0668013468013495*G0_1_1_3_1 + 0.0287317620650965*G0_1_1_3_2 + 0.062799422799425*G0_1_1_3_3 - 0.0258585858585867*G0_1_1_3_4 - 0.0566426166426186*G0_1_1_3_5 + 0.0163155363155369*G0_1_1_4_0 + 0.000307840307840324*G0_1_1_4_1 - 0.0102613435946774*G0_1_1_4_2 - 0.0258585858585867*G0_1_1_4_3 - 0.0726503126503154*G0_1_1_4_4 - 0.032015392015393*G0_1_1_4_5 + 0.0348885682219028*G0_1_1_5_0 - 0.0990219656886364*G0_1_1_5_1 + 0.0156998556998562*G0_1_1_5_2 - 0.0566426166426185*G0_1_1_5_3 - 0.032015392015393*G0_1_1_5_4 - 0.237652717652726*G0_1_1_5_5;
    A[67] = A[109] - 0.000846560846561161*G0_0_1_0_0 - 0.00142376142376141*G0_0_1_0_1 - 0.0071572871572874*G0_0_1_0_2 + 0.00831168831168863*G0_0_1_0_3 - 0.011544011544012*G0_0_1_0_4 + 0.00461760461760465*G0_0_1_0_5 - 0.00142376142376141*G0_0_1_1_0 - 0.000846560846561397*G0_0_1_1_1 - 0.00715728715728742*G0_0_1_1_2 - 0.0115440115440121*G0_0_1_1_3 + 0.00831168831168863*G0_0_1_1_4 + 0.00461760461760464*G0_0_1_1_5 - 0.0071572871572874*G0_0_1_2_0 - 0.00715728715728742*G0_0_1_2_1 - 0.0988936988937014*G0_0_1_2_2 + 0.0484848484848503*G0_0_1_2_3 + 0.0484848484848502*G0_0_1_2_4 + 0.00354016354016367*G0_0_1_2_5 + 0.00831168831168863*G0_0_1_3_0 - 0.0115440115440121*G0_0_1_3_1 + 0.0484848484848503*G0_0_1_3_2 + 0.0455603655603667*G0_0_1_3_3 - 0.0332467532467545*G0_0_1_3_4 - 0.0237037037037046*G0_0_1_3_5 - 0.011544011544012*G0_0_1_4_0 + 0.00831168831168863*G0_0_1_4_1 + 0.0484848484848502*G0_0_1_4_2 - 0.0332467532467545*G0_0_1_4_3 + 0.0455603655603665*G0_0_1_4_4 - 0.0237037037037046*G0_0_1_4_5 + 0.00461760461760465*G0_0_1_5_0 + 0.00461760461760464*G0_0_1_5_1 + 0.00354016354016367*G0_0_1_5_2 - 0.0237037037037046*G0_0_1_5_3 - 0.0237037037037046*G0_0_1_5_4 - 0.00430976430976493*G0_0_1_5_5 + 0.000846560846561162*G0_1_0_0_0 + 0.00142376142376141*G0_1_0_0_1 + 0.0071572871572874*G0_1_0_0_2 - 0.00831168831168863*G0_1_0_0_3 + 0.011544011544012*G0_1_0_0_4 - 0.00461760461760465*G0_1_0_0_5 + 0.00142376142376141*G0_1_0_1_0 + 0.000846560846561397*G0_1_0_1_1 + 0.00715728715728742*G0_1_0_1_2 + 0.0115440115440121*G0_1_0_1_3 - 0.00831168831168863*G0_1_0_1_4 - 0.00461760461760464*G0_1_0_1_5 + 0.0071572871572874*G0_1_0_2_0 + 0.00715728715728742*G0_1_0_2_1 + 0.0988936988937014*G0_1_0_2_2 - 0.0484848484848503*G0_1_0_2_3 - 0.0484848484848502*G0_1_0_2_4 - 0.00354016354016368*G0_1_0_2_5 - 0.00831168831168863*G0_1_0_3_0 + 0.0115440115440121*G0_1_0_3_1 - 0.0484848484848503*G0_1_0_3_2 - 0.0455603655603666*G0_1_0_3_3 + 0.0332467532467545*G0_1_0_3_4 + 0.0237037037037046*G0_1_0_3_5 + 0.011544011544012*G0_1_0_4_0 - 0.00831168831168863*G0_1_0_4_1 - 0.0484848484848502*G0_1_0_4_2 + 0.0332467532467545*G0_1_0_4_3 - 0.0455603655603665*G0_1_0_4_4 + 0.0237037037037046*G0_1_0_4_5 - 0.00461760461760465*G0_1_0_5_0 - 0.00461760461760464*G0_1_0_5_1 - 0.00354016354016368*G0_1_0_5_2 + 0.0237037037037046*G0_1_0_5_3 + 0.0237037037037046*G0_1_0_5_4 + 0.00430976430976493*G0_1_0_5_5;
    A[161] = -A[153] - 0.186140772807446*G0_0_0_0_0 + 0.0342215808882487*G0_0_0_0_1 + 0.0126214526214531*G0_0_0_0_2 + 0.0181625781625787*G0_0_0_0_3 - 0.0837325637325666*G0_0_0_0_4 + 0.0056437389770724*G0_0_0_0_5 + 0.0342215808882487*G0_0_0_1_0 - 0.270386403719747*G0_0_0_1_1 + 0.00779862113195472*G0_0_0_1_2 - 0.0287317620650963*G0_0_0_1_3 + 0.00954304954304991*G0_0_0_1_4 - 0.0882475549142247*G0_0_0_1_5 + 0.0126214526214531*G0_0_0_2_0 + 0.00779862113195472*G0_0_0_2_1 - 0.00790123456790159*G0_0_0_2_2 + 0.0156998556998562*G0_0_0_2_3 + 0.0427898027898042*G0_0_0_2_4 + 0.0542825076158428*G0_0_0_2_5 + 0.0181625781625787*G0_0_0_3_0 - 0.0287317620650963*G0_0_0_3_1 + 0.0156998556998562*G0_0_0_3_2 + 0.0258585858585872*G0_0_0_3_3 - 0.0554112554112572*G0_0_0_3_4 - 0.144890171556843*G0_0_0_3_5 - 0.0837325637325666*G0_0_0_4_0 + 0.00954304954304991*G0_0_0_4_1 + 0.0427898027898042*G0_0_0_4_2 - 0.0554112554112572*G0_0_0_4_3 - 0.239294532627873*G0_0_0_4_4 - 0.127651114317785*G0_0_0_4_5 + 0.00564373897707239*G0_0_0_5_0 - 0.0882475549142247*G0_0_0_5_1 + 0.0542825076158428*G0_0_0_5_2 - 0.144890171556843*G0_0_0_5_3 - 0.127651114317785*G0_0_0_5_4 - 0.511835818502503*G0_0_0_5_5 - 0.00410453743787097*G0_1_0_0_0 + 0.0215488215488223*G0_1_0_0_1 - 0.00733686067019424*G0_1_0_0_2 + 0.0178547378547384*G0_1_0_0_3 + 0.0152894019560691*G0_1_0_0_4 + 0.0724450857784215*G0_1_0_0_5 + 0.0215488215488223*G0_1_0_1_0 - 0.278595478595488*G0_1_0_1_1 + 0.00923520923520954*G0_1_0_1_2 - 0.018470418470419*G0_1_0_1_3 - 0.00615680615680631*G0_1_0_1_4 - 0.116979316979321*G0_1_0_1_5 - 0.00733686067019424*G0_1_0_2_0 + 0.00923520923520954*G0_1_0_2_1 - 0.0028731762065096*G0_1_0_2_2 - 0.000615680615680729*G0_1_0_2_3 + 0.00790123456790154*G0_1_0_2_4 + 0.0416610549943897*G0_1_0_2_5 + 0.0178547378547384*G0_1_0_3_0 - 0.018470418470419*G0_1_0_3_1 - 0.000615680615680722*G0_1_0_3_2 + 0.0985088985089023*G0_1_0_3_3 - 0.0233958633958642*G0_1_0_3_4 - 0.119031585698256*G0_1_0_3_5 + 0.0152894019560691*G0_1_0_4_0 - 0.00615680615680631*G0_1_0_4_1 + 0.00790123456790154*G0_1_0_4_2 - 0.0233958633958642*G0_1_0_4_3 - 0.00164181497514811*G0_1_0_4_4 - 0.0710084976751667*G0_1_0_4_5 + 0.0724450857784215*G0_1_0_5_0 - 0.116979316979321*G0_1_0_5_1 + 0.0416610549943897*G0_1_0_5_2 - 0.119031585698256*G0_1_0_5_3 - 0.0710084976751667*G0_1_0_5_4 - 0.574635241301928*G0_1_0_5_5;
    A[96] = A[144] - 0.363251563251577*G0_0_0_0_0 + 0.012655657100102*G0_0_0_0_1 - 0.0126556571001019*G0_0_0_0_2 + 0.00820907487574186*G0_0_0_0_3 + 0.0547271658382786*G0_0_0_0_4 - 0.0383090160867955*G0_0_0_0_5 + 0.012655657100102*G0_0_0_1_0 - 0.0726503126503151*G0_0_0_1_1 + 0.00348885682219028*G0_0_0_1_2 - 0.0563689808134271*G0_0_0_1_3 - 0.0350253861364984*G0_0_0_1_4 - 0.0101245256800816*G0_0_0_1_5 - 0.0126556571001019*G0_0_0_2_0 + 0.00348885682219028*G0_0_0_2_1 + 0.0857848324515016*G0_0_0_2_2 + 0.0506226284004079*G0_0_0_2_3 - 0.0391299235743692*G0_0_0_2_4 + 0.00218908663353121*G0_0_0_2_5 + 0.00820907487574185*G0_0_0_3_0 - 0.0563689808134272*G0_0_0_3_1 + 0.0506226284004079*G0_0_0_3_2 + 0.00985088985089047*G0_0_0_3_3 + 0.0536326225215132*G0_0_0_3_4 - 0.020796323018546*G0_0_0_3_5 + 0.0547271658382786*G0_0_0_4_0 - 0.0350253861364984*G0_0_0_4_1 - 0.0391299235743692*G0_0_0_4_2 + 0.0536326225215132*G0_0_0_4_3 + 0.487071775960681*G0_0_0_4_4 + 0.0656725990059345*G0_0_0_4_5 - 0.0383090160867955*G0_0_0_5_0 - 0.0101245256800816*G0_0_0_5_1 + 0.00218908663353121*G0_0_0_5_2 - 0.020796323018546*G0_0_0_5_3 + 0.0656725990059345*G0_0_0_5_4 - 0.224381379936944*G0_0_0_5_5 + 0.0126556571001019*G0_0_1_0_1 - 0.012655657100102*G0_0_1_0_2 + 0.0465180909625371*G0_0_1_0_4 - 0.046518090962537*G0_0_1_0_5 + 0.0126556571001019*G0_0_1_1_0 - 0.0792175725509085*G0_0_1_1_1 - 0.0534958046069175*G0_0_1_1_3 - 0.0186072363850148*G0_0_1_1_4 + 0.0145026989471439*G0_0_1_1_5 - 0.012655657100102*G0_0_1_2_0 + 0.0792175725509083*G0_0_1_2_2 + 0.0534958046069175*G0_0_1_2_3 - 0.0145026989471439*G0_0_1_2_4 + 0.0186072363850148*G0_0_1_2_5 - 0.0534958046069175*G0_0_1_3_1 + 0.0534958046069175*G0_0_1_3_2 + 0.0372144727700295*G0_0_1_3_4 - 0.0372144727700296*G0_0_1_3_5 + 0.0465180909625371*G0_0_1_4_0 - 0.0186072363850148*G0_0_1_4_1 - 0.0145026989471439*G0_0_1_4_2 + 0.0372144727700295*G0_0_1_4_3 + 0.355726577948812*G0_0_1_4_4 - 0.046518090962537*G0_0_1_5_0 + 0.0145026989471439*G0_0_1_5_1 + 0.0186072363850148*G0_0_1_5_2 - 0.0372144727700296*G0_0_1_5_3 - 0.355726577948813*G0_0_1_5_5 + 0.0126556571001019*G0_1_0_0_1 - 0.012655657100102*G0_1_0_0_2 + 0.0465180909625371*G0_1_0_0_4 - 0.046518090962537*G0_1_0_0_5 + 0.0126556571001019*G0_1_0_1_0 - 0.0792175725509085*G0_1_0_1_1 - 0.0534958046069175*G0_1_0_1_3 - 0.0186072363850148*G0_1_0_1_4 + 0.0145026989471439*G0_1_0_1_5 - 0.012655657100102*G0_1_0_2_0 + 0.0792175725509083*G0_1_0_2_2 + 0.0534958046069175*G0_1_0_2_3 - 0.0145026989471439*G0_1_0_2_4 + 0.0186072363850148*G0_1_0_2_5 - 0.0534958046069175*G0_1_0_3_1 + 0.0534958046069175*G0_1_0_3_2 + 0.0372144727700295*G0_1_0_3_4 - 0.0372144727700296*G0_1_0_3_5 + 0.0465180909625371*G0_1_0_4_0 - 0.0186072363850148*G0_1_0_4_1 - 0.0145026989471439*G0_1_0_4_2 + 0.0372144727700295*G0_1_0_4_3 + 0.355726577948812*G0_1_0_4_4 - 0.046518090962537*G0_1_0_5_0 + 0.0145026989471439*G0_1_0_5_1 + 0.0186072363850148*G0_1_0_5_2 - 0.0372144727700296*G0_1_0_5_3 - 0.355726577948813*G0_1_0_5_5 + 0.363251563251576*G0_1_1_0_0 + 0.012655657100102*G0_1_1_0_1 - 0.012655657100102*G0_1_1_0_2 - 0.00820907487574188*G0_1_1_0_3 + 0.0383090160867951*G0_1_1_0_4 - 0.0547271658382789*G0_1_1_0_5 + 0.012655657100102*G0_1_1_1_0 - 0.0857848324515019*G0_1_1_1_1 - 0.00348885682219028*G0_1_1_1_2 - 0.0506226284004079*G0_1_1_1_3 - 0.00218908663353112*G0_1_1_1_4 + 0.0391299235743694*G0_1_1_1_5 - 0.012655657100102*G0_1_1_2_0 - 0.00348885682219027*G0_1_1_2_1 + 0.072650312650315*G0_1_1_2_2 + 0.0563689808134272*G0_1_1_2_3 + 0.0101245256800816*G0_1_1_2_4 + 0.0350253861364985*G0_1_1_2_5 - 0.00820907487574188*G0_1_1_3_0 - 0.0506226284004079*G0_1_1_3_1 + 0.0563689808134272*G0_1_1_3_2 - 0.00985088985089055*G0_1_1_3_3 + 0.0207963230185458*G0_1_1_3_4 - 0.0536326225215133*G0_1_1_3_5 + 0.0383090160867952*G0_1_1_4_0 - 0.00218908663353113*G0_1_1_4_1 + 0.0101245256800816*G0_1_1_4_2 + 0.0207963230185458*G0_1_1_4_3 + 0.224381379936943*G0_1_1_4_4 - 0.0656725990059347*G0_1_1_4_5 - 0.0547271658382789*G0_1_1_5_0 + 0.0391299235743694*G0_1_1_5_1 + 0.0350253861364985*G0_1_1_5_2 - 0.0536326225215133*G0_1_1_5_3 - 0.0656725990059347*G0_1_1_5_4 - 0.487071775960682*G0_1_1_5_5;
    A[81] = -A[126] + 0.00697771364438066*G0_1_0_0_0 + 0.0007524985302763*G0_1_0_0_1 - 0.0177863288974406*G0_1_0_0_2 - 0.00246272246272257*G0_1_0_0_3 + 0.0276372187483307*G0_1_0_0_4 + 0.000684089572978497*G0_1_0_0_5 + 0.0007524985302763*G0_1_0_1_0 + 0.00451499118165812*G0_1_0_1_1 - 0.00136817914595696*G0_1_0_1_2 + 0.00300999412110543*G0_1_0_1_3 - 0.027089947089948*G0_1_0_1_4 - 0.00916680027791161*G0_1_0_1_5 - 0.0177863288974406*G0_1_0_2_0 - 0.00136817914595696*G0_1_0_2_1 + 0.121083854417191*G0_1_0_2_2 + 0.0164181497514837*G0_1_0_2_4 - 0.00547271658382787*G0_1_0_2_5 - 0.00246272246272257*G0_1_0_3_0 + 0.00300999412110543*G0_1_0_3_1 - 0.0755234888568249*G0_1_0_3_3 + 0.0591053391053411*G0_1_0_3_4 + 0.0158708780931009*G0_1_0_3_5 + 0.0276372187483307*G0_1_0_4_0 - 0.027089947089948*G0_1_0_4_1 + 0.0164181497514837*G0_1_0_4_2 + 0.0591053391053411*G0_1_0_4_3 + 0.220003206669881*G0_1_0_4_4 + 0.0651253273475518*G0_1_0_4_5 + 0.000684089572978498*G0_1_0_5_0 - 0.00916680027791161*G0_1_0_5_1 - 0.00547271658382787*G0_1_0_5_2 + 0.0158708780931009*G0_1_0_5_3 + 0.0651253273475518*G0_1_0_5_4 + 0.0142290631179529*G0_1_0_5_5 + 0.199890973224313*G0_1_1_0_0 - 0.0152551974774202*G0_1_1_0_1 - 0.0184704184704191*G0_1_1_0_2 - 0.00424135535246665*G0_1_1_0_3 + 0.021206776762333*G0_1_1_0_4 + 0.0809962054406528*G0_1_1_0_5 - 0.0152551974774202*G0_1_1_1_0 + 0.0102613435946774*G0_1_1_1_1 - 0.0021206776762333*G0_1_1_1_2 - 0.00123136123136124*G0_1_1_1_3 - 0.0253113142002039*G0_1_1_1_4 - 0.0250376783710125*G0_1_1_1_5 - 0.0184704184704191*G0_1_1_2_0 - 0.0021206776762333*G0_1_1_2_1 + 0.116979316979321*G0_1_1_2_2 + 0.00547271658382785*G0_1_1_2_3 + 0.0273635829191395*G0_1_1_2_4 - 0.00506226284004077*G0_1_1_2_5 - 0.00424135535246665*G0_1_1_3_0 - 0.00123136123136124*G0_1_1_3_1 + 0.00547271658382785*G0_1_1_3_2 - 0.0596526107637239*G0_1_1_3_3 + 0.0591053391053411*G0_1_1_3_4 + 0.0186072363850148*G0_1_1_3_5 + 0.021206776762333*G0_1_1_4_0 - 0.0253113142002039*G0_1_1_4_1 + 0.0273635829191395*G0_1_1_4_2 + 0.0591053391053411*G0_1_1_4_3 + 0.154877879322329*G0_1_1_4_4 + 0.0607471540804895*G0_1_1_4_5 + 0.0809962054406528*G0_1_1_5_0 - 0.0250376783710125*G0_1_1_5_1 - 0.00506226284004077*G0_1_1_5_2 + 0.0186072363850148*G0_1_1_5_3 + 0.0607471540804895*G0_1_1_5_4 + 0.104528886751113*G0_1_1_5_5;
    A[129] = A[81] - 0.00410453743787099*G0_0_0_0_0 - 0.000752498530276336*G0_0_0_0_1 - 0.000684089572978381*G0_0_0_0_2 + 0.000410453743787111*G0_0_0_0_3 + 0.0109454331676557*G0_0_0_0_4 + 0.00547271658382784*G0_0_0_0_5 - 0.000752498530276336*G0_0_0_1_0 + 0.00574635241301925*G0_0_0_1_1 - 0.0160076960076965*G0_0_0_1_2 - 0.0158708780931008*G0_0_0_1_3 + 0.00177863288974409*G0_0_0_1_4 - 0.00424135535246657*G0_0_0_1_5 - 0.000684089572978381*G0_0_0_2_0 - 0.0160076960076965*G0_0_0_2_1 + 0.192913259579931*G0_0_0_2_2 + 0.080312115867674*G0_0_0_2_3 - 0.00643044198599805*G0_0_0_2_4 - 0.00177863288974403*G0_0_0_2_5 + 0.000410453743787111*G0_0_0_3_0 - 0.0158708780931008*G0_0_0_3_1 + 0.080312115867674*G0_0_0_3_2 + 0.0902998236331602*G0_0_0_3_3 - 0.00437817326706238*G0_0_0_3_4 + 0.00273635829191396*G0_0_0_3_5 + 0.0109454331676557*G0_0_0_4_0 + 0.0017786328897441*G0_0_0_4_1 - 0.00643044198599804*G0_0_0_4_2 - 0.00437817326706238*G0_0_0_4_3 - 0.0651253273475521*G0_0_0_4_4 + 0.00547271658382783*G0_0_0_5_0 - 0.00424135535246657*G0_0_0_5_1 - 0.00177863288974403*G0_0_0_5_2 + 0.00273635829191396*G0_0_0_5_3 + 0.0158708780931007*G0_0_0_5_5 - 0.00410453743787091*G0_0_1_0_0 - 0.000752498530276339*G0_0_1_0_1 - 0.000684089572978437*G0_0_1_0_2 + 0.000410453743787102*G0_0_1_0_3 + 0.0109454331676558*G0_0_1_0_4 + 0.00547271658382786*G0_0_1_0_5 - 0.00075249853027634*G0_0_1_1_0 + 0.00574635241301925*G0_0_1_1_1 - 0.0160076960076965*G0_0_1_1_2 - 0.0158708780931009*G0_0_1_1_3 + 0.00177863288974407*G0_0_1_1_4 - 0.00424135535246658*G0_0_1_1_5 - 0.000684089572978436*G0_0_1_2_0 - 0.0160076960076965*G0_0_1_2_1 + 0.192913259579932*G0_0_1_2_2 + 0.0803121158676742*G0_0_1_2_3 - 0.00643044198599786*G0_0_1_2_4 - 0.00177863288974403*G0_0_1_2_5 + 0.000410453743787103*G0_0_1_3_0 - 0.0158708780931009*G0_0_1_3_1 + 0.0803121158676742*G0_0_1_3_2 + 0.0902998236331603*G0_0_1_3_3 - 0.00437817326706231*G0_0_1_3_4 + 0.00273635829191397*G0_0_1_3_5 + 0.0109454331676558*G0_0_1_4_0 + 0.00177863288974407*G0_0_1_4_1 - 0.00643044198599786*G0_0_1_4_2 - 0.00437817326706231*G0_0_1_4_3 - 0.065125327347552*G0_0_1_4_4 + 0.00547271658382786*G0_0_1_5_0 - 0.00424135535246658*G0_0_1_5_1 - 0.00177863288974403*G0_0_1_5_2 + 0.00273635829191397*G0_0_1_5_3 + 0.0158708780931008*G0_0_1_5_5 + 0.110001603334941*G0_1_0_0_0 - 0.00287317620650962*G0_1_0_0_1 - 0.000684089572978455*G0_1_0_0_2 - 0.00259954037731823*G0_1_0_0_3 - 0.000273635829191341*G0_1_0_0_4 + 0.00478862701084942*G0_1_0_0_5 - 0.00287317620650962*G0_1_0_1_0 + 0.00574635241301909*G0_1_0_1_1 - 0.0138870183314632*G0_1_0_1_2 - 0.028047672492118*G0_1_0_1_3 + 0.00177863288974406*G0_1_0_1_4 + 0.00793543904655037*G0_1_0_1_5 - 0.000684089572978455*G0_1_0_2_0 - 0.0138870183314632*G0_1_0_2_1 + 0.0788071188071211*G0_1_0_2_2 + 0.0809962054406527*G0_1_0_2_3 + 0.00478862701084927*G0_1_0_2_4 + 0.00123136123136129*G0_1_0_2_5 - 0.00259954037731823*G0_1_0_3_0 - 0.028047672492118*G0_1_0_3_1 + 0.0809962054406527*G0_1_0_3_2 + 0.180052375607938*G0_1_0_3_3 + 0.00164181497514838*G0_1_0_3_4 + 0.00273635829191398*G0_1_0_3_5 - 0.000273635829191339*G0_1_0_4_0 + 0.00177863288974406*G0_1_0_4_1 + 0.00478862701084928*G0_1_0_4_2 + 0.00164181497514839*G0_1_0_4_3 - 0.0651253273475517*G0_1_0_4_4 - 0.00601998824221066*G0_1_0_4_5 + 0.00478862701084942*G0_1_0_5_0 + 0.00793543904655037*G0_1_0_5_1 + 0.00123136123136129*G0_1_0_5_2 + 0.00273635829191398*G0_1_0_5_3 - 0.00601998824221066*G0_1_0_5_4 - 0.0738816738816767*G0_1_0_5_5 - 0.0829116562449924*G0_1_1_0_0 + 0.0131345198011869*G0_1_1_0_1 - 0.000820907487574155*G0_1_1_0_3 + 0.0061568061568064*G0_1_1_0_4 - 0.075523488856825*G0_1_1_0_5 + 0.0131345198011869*G0_1_1_1_0 - 0.0131345198011869*G0_1_1_1_2 - 0.0238063171396513*G0_1_1_1_3 + 0.0238063171396513*G0_1_1_1_5 - 0.0131345198011869*G0_1_1_2_1 + 0.0829116562449922*G0_1_1_2_2 + 0.0755234888568248*G0_1_1_2_3 - 0.00615680615680643*G0_1_1_2_4 + 0.000820907487574206*G0_1_1_2_5 - 0.000820907487574155*G0_1_1_3_0 - 0.0238063171396513*G0_1_1_3_1 + 0.0755234888568248*G0_1_1_3_2 + 0.164181497514837*G0_1_1_3_3 + 0.0016418149751484*G0_1_1_3_4 + 0.0061568061568064*G0_1_1_4_0 - 0.00615680615680643*G0_1_1_4_2 + 0.0016418149751484*G0_1_1_4_3 - 0.00164181497514836*G0_1_1_4_5 - 0.075523488856825*G0_1_1_5_0 + 0.0238063171396513*G0_1_1_5_1 + 0.000820907487574205*G0_1_1_5_2 - 0.00164181497514836*G0_1_1_5_4 - 0.164181497514837*G0_1_1_5_5;
    A[143] = A[129] + 0.104665704665708*G0_0_1_0_0 - 0.00129977018865912*G0_0_1_0_1 + 0.000615680615680627*G0_0_1_0_2 - 0.00136817914595699*G0_0_1_0_3 - 0.00834589279033752*G0_0_1_0_4 - 0.00396771952327518*G0_0_1_0_5 - 0.00129977018865912*G0_0_1_1_0 + 0.000820907487574121*G0_0_1_1_1 + 0.000820907487574193*G0_0_1_1_2 - 0.00136817914595694*G0_0_1_1_3 - 0.00300999412110534*G0_0_1_1_4 + 0.0108086152530601*G0_0_1_1_5 + 0.000615680615680628*G0_0_1_2_0 + 0.000820907487574192*G0_0_1_2_1 - 0.00944043610710316*G0_0_1_2_2 - 0.00328362995029681*G0_0_1_2_3 + 0.00287317620650966*G0_0_1_2_4 + 0.00164181497514836*G0_0_1_2_5 - 0.00136817914595699*G0_0_1_3_0 - 0.00136817914595694*G0_0_1_3_1 - 0.00328362995029681*G0_0_1_3_2 - 0.00218908663353115*G0_0_1_3_3 + 0.00875634653412462*G0_0_1_3_4 - 0.000547271658382767*G0_0_1_3_5 - 0.00834589279033751*G0_0_1_4_0 - 0.00300999412110534*G0_0_1_4_1 + 0.00287317620650966*G0_0_1_4_2 + 0.00875634653412462*G0_0_1_4_3 - 0.0120399764844213*G0_0_1_4_4 + 0.00273635829191395*G0_0_1_4_5 - 0.00396771952327518*G0_0_1_5_0 + 0.0108086152530601*G0_0_1_5_1 + 0.00164181497514836*G0_0_1_5_2 - 0.000547271658382766*G0_0_1_5_3 + 0.00273635829191395*G0_0_1_5_4 - 0.0919416386083084*G0_0_1_5_5 - 0.104665704665708*G0_1_0_0_0 + 0.00129977018865912*G0_1_0_0_1 - 0.000615680615680627*G0_1_0_0_2 + 0.00136817914595699*G0_1_0_0_3 + 0.00834589279033752*G0_1_0_0_4 + 0.00396771952327517*G0_1_0_0_5 + 0.00129977018865912*G0_1_0_1_0 - 0.00082090748757412*G0_1_0_1_1 - 0.000820907487574193*G0_1_0_1_2 + 0.00136817914595694*G0_1_0_1_3 + 0.00300999412110534*G0_1_0_1_4 - 0.0108086152530601*G0_1_0_1_5 - 0.000615680615680628*G0_1_0_2_0 - 0.000820907487574193*G0_1_0_2_1 + 0.00944043610710316*G0_1_0_2_2 + 0.00328362995029681*G0_1_0_2_3 - 0.00287317620650966*G0_1_0_2_4 - 0.00164181497514836*G0_1_0_2_5 + 0.00136817914595699*G0_1_0_3_0 + 0.00136817914595694*G0_1_0_3_1 + 0.00328362995029681*G0_1_0_3_2 + 0.00218908663353115*G0_1_0_3_3 - 0.00875634653412461*G0_1_0_3_4 + 0.000547271658382765*G0_1_0_3_5 + 0.00834589279033751*G0_1_0_4_0 + 0.00300999412110534*G0_1_0_4_1 - 0.00287317620650966*G0_1_0_4_2 - 0.00875634653412462*G0_1_0_4_3 + 0.0120399764844213*G0_1_0_4_4 - 0.00273635829191396*G0_1_0_4_5 + 0.00396771952327517*G0_1_0_5_0 - 0.0108086152530601*G0_1_0_5_1 - 0.00164181497514836*G0_1_0_5_2 + 0.000547271658382766*G0_1_0_5_3 - 0.00273635829191395*G0_1_0_5_4 + 0.0919416386083084*G0_1_0_5_5;
    A[84] = -A[129] + 0.114106140772811*G0_1_0_0_0 - 0.00280476724921179*G0_1_0_0_1 - 0.00177863288974406*G0_1_0_0_2 - 0.000547271658382844*G0_1_0_0_3 - 0.00574635241301928*G0_1_0_0_4 - 0.00615680615680639*G0_1_0_0_5 - 0.00280476724921179*G0_1_0_1_0 - 0.0143658810325484*G0_1_0_1_1 - 0.000684089572978489*G0_1_0_1_2 + 0.00766180321735905*G0_1_0_1_3 - 0.00738816738816764*G0_1_0_1_4 + 0.0198385976163761*G0_1_0_1_5 - 0.00177863288974406*G0_1_0_2_0 - 0.000684089572978491*G0_1_0_2_1 - 0.00547271658382792*G0_1_0_2_3 + 0.00547271658382787*G0_1_0_2_4 + 0.00246272246272254*G0_1_0_2_5 - 0.000547271658382843*G0_1_0_3_0 + 0.00766180321735906*G0_1_0_3_1 - 0.00547271658382792*G0_1_0_3_2 - 0.0317417561862014*G0_1_0_3_3 + 0.0158708780931009*G0_1_0_3_4 - 0.00383090160867943*G0_1_0_3_5 - 0.00574635241301927*G0_1_0_4_0 - 0.00738816738816764*G0_1_0_4_1 + 0.00547271658382787*G0_1_0_4_2 + 0.0158708780931009*G0_1_0_4_3 + 0.00985088985089021*G0_1_0_4_5 - 0.00615680615680639*G0_1_0_5_0 + 0.0198385976163761*G0_1_0_5_1 + 0.00246272246272254*G0_1_0_5_2 - 0.00383090160867943*G0_1_0_5_3 + 0.00985088985089021*G0_1_0_5_4 - 0.121494308160979*G0_1_0_5_5 - 0.0788071188071216*G0_1_1_0_0 + 0.0132029287584848*G0_1_1_0_1 - 0.00109454331676556*G0_1_1_0_2 + 0.00123136123136125*G0_1_1_0_3 + 0.000684089572978477*G0_1_1_0_4 - 0.0864689220244808*G0_1_1_0_5 + 0.0132029287584848*G0_1_1_1_0 - 0.0201122334455676*G0_1_1_1_1 + 0.0119031585698257*G0_1_1_1_3 - 0.0091668002779117*G0_1_1_1_4 + 0.035709475709477*G0_1_1_1_5 - 0.00109454331676556*G0_1_1_2_0 + 0.00410453743787078*G0_1_1_2_2 - 0.0109454331676559*G0_1_1_2_3 - 0.00547271658382789*G0_1_1_2_4 + 0.00205226871893546*G0_1_1_2_5 + 0.00123136123136125*G0_1_1_3_0 + 0.0119031585698257*G0_1_1_3_1 - 0.0109454331676559*G0_1_1_3_2 - 0.0476126342793026*G0_1_1_3_3 + 0.0158708780931009*G0_1_1_3_4 - 0.00656725990059339*G0_1_1_3_5 + 0.000684089572978477*G0_1_1_4_0 - 0.0091668002779117*G0_1_1_4_1 - 0.00547271658382789*G0_1_1_4_2 + 0.0158708780931009*G0_1_1_4_3 + 0.0651253273475517*G0_1_1_4_4 + 0.0142290631179525*G0_1_1_4_5 - 0.0864689220244808*G0_1_1_5_0 + 0.035709475709477*G0_1_1_5_1 + 0.00205226871893545*G0_1_1_5_2 - 0.00656725990059339*G0_1_1_5_3 + 0.0142290631179525*G0_1_1_5_4 - 0.211794131794139*G0_1_1_5_5;
    A[156] = A[100] - 0.224210357543699*G0_0_1_0_0 - 0.00425845759179108*G0_0_1_0_1 + 0.00138528138528146*G0_0_1_0_2 + 0.00338624338624353*G0_0_1_0_3 + 0.00615680615680629*G0_0_1_0_4 + 0.0256533589866931*G0_0_1_0_5 - 0.00425845759179108*G0_0_1_1_0 + 0.00615680615680653*G0_0_1_1_1 - 0.000307840307840349*G0_0_1_1_2 + 0.00410453743787104*G0_0_1_1_3 - 0.00359147025813703*G0_0_1_1_4 - 0.00831168831168853*G0_0_1_1_5 + 0.00138528138528146*G0_0_1_2_0 - 0.000307840307840349*G0_0_1_2_1 + 0.0015392015392017*G0_0_1_2_2 + 0.000513067179733869*G0_0_1_2_3 - 0.0152894019560692*G0_0_1_2_4 + 0.000307840307840307*G0_0_1_2_5 + 0.00338624338624353*G0_0_1_3_0 + 0.00410453743787104*G0_0_1_3_1 + 0.000513067179733869*G0_0_1_3_2 + 0.00574635241301953*G0_0_1_3_3 + 0.000410453743787065*G0_0_1_3_4 - 0.00738816738816761*G0_0_1_3_5 + 0.00615680615680631*G0_0_1_4_0 - 0.00359147025813704*G0_0_1_4_1 - 0.0152894019560692*G0_0_1_4_2 + 0.000410453743787065*G0_0_1_4_3 + 0.141196087862759*G0_0_1_4_4 + 0.00656725990059343*G0_0_1_4_5 + 0.0256533589866931*G0_0_1_5_0 - 0.00831168831168853*G0_0_1_5_1 + 0.000307840307840307*G0_0_1_5_2 - 0.00738816738816761*G0_0_1_5_3 + 0.00656725990059343*G0_0_1_5_4 + 0.0508962642295998*G0_0_1_5_5 + 0.224210357543699*G0_1_0_0_0 + 0.00425845759179108*G0_1_0_0_1 - 0.00138528138528146*G0_1_0_0_2 - 0.00338624338624353*G0_1_0_0_3 - 0.0061568061568063*G0_1_0_0_4 - 0.0256533589866931*G0_1_0_0_5 + 0.00425845759179108*G0_1_0_1_0 - 0.00615680615680654*G0_1_0_1_1 + 0.000307840307840349*G0_1_0_1_2 - 0.00410453743787104*G0_1_0_1_3 + 0.00359147025813704*G0_1_0_1_4 + 0.00831168831168853*G0_1_0_1_5 - 0.00138528138528146*G0_1_0_2_0 + 0.000307840307840349*G0_1_0_2_1 - 0.0015392015392017*G0_1_0_2_2 - 0.000513067179733869*G0_1_0_2_3 + 0.0152894019560692*G0_1_0_2_4 - 0.000307840307840307*G0_1_0_2_5 - 0.00338624338624353*G0_1_0_3_0 - 0.00410453743787104*G0_1_0_3_1 - 0.000513067179733869*G0_1_0_3_2 - 0.00574635241301953*G0_1_0_3_3 - 0.000410453743787065*G0_1_0_3_4 + 0.00738816738816761*G0_1_0_3_5 - 0.0061568061568063*G0_1_0_4_0 + 0.00359147025813704*G0_1_0_4_1 + 0.0152894019560692*G0_1_0_4_2 - 0.000410453743787061*G0_1_0_4_3 - 0.141196087862759*G0_1_0_4_4 - 0.00656725990059343*G0_1_0_4_5 - 0.0256533589866931*G0_1_0_5_0 + 0.00831168831168853*G0_1_0_5_1 - 0.000307840307840306*G0_1_0_5_2 + 0.00738816738816761*G0_1_0_5_3 - 0.00656725990059343*G0_1_0_5_4 - 0.0508962642295998*G0_1_0_5_5;
    A[142] = A[156] - 0.0790123456790146*G0_0_0_0_0 - 0.00395061728395076*G0_0_0_0_1 + 0.0166746833413506*G0_0_0_0_2 + 0.000102613435946786*G0_0_0_0_3 - 0.0841430174763536*G0_0_0_0_4 + 0.0092352092352095*G0_0_0_0_5 - 0.00395061728395076*G0_0_0_1_0 + 0.0193939393939402*G0_0_0_1_1 + 0.00148789482122819*G0_0_0_1_2 + 0.0207279140612482*G0_0_0_1_3 - 0.00277056277056286*G0_0_0_1_4 - 0.00666987333654009*G0_0_0_1_5 + 0.0166746833413506*G0_0_0_2_0 + 0.00148789482122819*G0_0_0_2_1 - 0.0133397466730804*G0_0_0_2_2 - 0.0265768799102142*G0_0_0_2_3 + 0.0146737213403884*G0_0_0_2_4 - 0.0132371332371337*G0_0_0_2_5 + 0.000102613435946786*G0_0_0_3_0 + 0.0207279140612482*G0_0_0_3_1 - 0.0265768799102142*G0_0_0_3_2 + 0.00574635241301918*G0_0_0_3_3 + 0.00533589866923219*G0_0_0_3_4 + 0.0262690396023738*G0_0_0_3_5 - 0.0841430174763536*G0_0_0_4_0 - 0.00277056277056285*G0_0_0_4_1 + 0.0146737213403884*G0_0_0_4_2 + 0.00533589866923219*G0_0_0_4_3 - 0.159256052589391*G0_0_0_4_4 + 0.0320153920153931*G0_0_0_4_5 + 0.0092352092352095*G0_0_0_5_0 - 0.00666987333654009*G0_0_0_5_1 - 0.0132371332371337*G0_0_0_5_2 + 0.0262690396023738*G0_0_0_5_3 + 0.0320153920153931*G0_0_0_5_4 + 0.0788071188071215*G0_0_0_5_5 + 0.00482283148949831*G0_0_1_0_1 - 0.00482283148949834*G0_0_1_0_2 + 0.0348885682219028*G0_0_1_0_4 - 0.0348885682219027*G0_0_1_0_5 + 0.00482283148949831*G0_0_1_1_0 + 0.0111848645181982*G0_0_1_1_1 + 0.0237037037037045*G0_0_1_1_3 + 0.00513067179733863*G0_0_1_1_4 + 0.0104665704665709*G0_0_1_1_5 - 0.00482283148949833*G0_0_1_2_0 - 0.0111848645181982*G0_0_1_2_2 - 0.0237037037037045*G0_0_1_2_3 - 0.0104665704665709*G0_0_1_2_4 - 0.00513067179733865*G0_0_1_2_5 + 0.0237037037037045*G0_0_1_3_1 - 0.0237037037037045*G0_0_1_3_2 - 0.0102613435946773*G0_0_1_3_4 + 0.0102613435946773*G0_0_1_3_5 + 0.0348885682219028*G0_0_1_4_0 + 0.00513067179733863*G0_0_1_4_1 - 0.0104665704665709*G0_0_1_4_2 - 0.0102613435946773*G0_0_1_4_3 - 0.0328362995029671*G0_0_1_4_4 - 0.0348885682219027*G0_0_1_5_0 + 0.0104665704665709*G0_0_1_5_1 - 0.00513067179733865*G0_0_1_5_2 + 0.0102613435946773*G0_0_1_5_3 + 0.0328362995029672*G0_0_1_5_5 - 0.000820907487574162*G0_1_0_0_1 + 0.000820907487574201*G0_1_0_0_2 + 0.0153920153920159*G0_1_0_0_4 - 0.0153920153920161*G0_1_0_0_5 - 0.000820907487574162*G0_1_0_1_0 + 0.0158024691358032*G0_1_0_1_1 + 0.0272951739618417*G0_1_0_1_3 + 0.00123136123136129*G0_1_0_1_4 + 0.0174442841109515*G0_1_0_1_5 + 0.000820907487574201*G0_1_0_2_0 - 0.015802469135803*G0_1_0_2_2 - 0.0272951739618416*G0_1_0_2_3 - 0.0174442841109514*G0_1_0_2_4 - 0.00123136123136129*G0_1_0_2_5 + 0.0272951739618417*G0_1_0_3_1 - 0.0272951739618416*G0_1_0_3_2 - 0.00246272246272261*G0_1_0_3_4 + 0.00246272246272254*G0_1_0_3_5 + 0.0153920153920159*G0_1_0_4_0 + 0.00123136123136129*G0_1_0_4_1 - 0.0174442841109514*G0_1_0_4_2 - 0.00246272246272261*G0_1_0_4_3 + 0.0574635241301928*G0_1_0_4_4 - 0.0153920153920161*G0_1_0_5_0 + 0.0174442841109515*G0_1_0_5_1 - 0.00123136123136129*G0_1_0_5_2 + 0.00246272246272254*G0_1_0_5_3 - 0.0574635241301926*G0_1_0_5_5 + 0.0790123456790155*G0_1_1_0_0 - 0.0166746833413506*G0_1_1_0_1 + 0.00395061728395074*G0_1_1_0_2 - 0.000102613435946754*G0_1_1_0_3 - 0.00923520923520946*G0_1_1_0_4 + 0.0841430174763539*G0_1_1_0_5 - 0.0166746833413506*G0_1_1_1_0 + 0.0133397466730804*G0_1_1_1_1 - 0.00148789482122818*G0_1_1_1_2 + 0.0265768799102141*G0_1_1_1_3 + 0.0132371332371337*G0_1_1_1_4 - 0.0146737213403885*G0_1_1_1_5 + 0.00395061728395074*G0_1_1_2_0 - 0.00148789482122818*G0_1_1_2_1 - 0.01939393939394*G0_1_1_2_2 - 0.0207279140612481*G0_1_1_2_3 + 0.00666987333654015*G0_1_1_2_4 + 0.00277056277056283*G0_1_1_2_5 - 0.000102613435946754*G0_1_1_3_0 + 0.0265768799102141*G0_1_1_3_1 - 0.0207279140612482*G0_1_1_3_2 - 0.00574635241301967*G0_1_1_3_3 - 0.0262690396023739*G0_1_1_3_4 - 0.00533589866923222*G0_1_1_3_5 - 0.00923520923520947*G0_1_1_4_0 + 0.0132371332371337*G0_1_1_4_1 + 0.00666987333654015*G0_1_1_4_2 - 0.0262690396023739*G0_1_1_4_3 - 0.0788071188071214*G0_1_1_4_4 - 0.0320153920153931*G0_1_1_4_5 + 0.0841430174763539*G0_1_1_5_0 - 0.0146737213403885*G0_1_1_5_1 + 0.00277056277056283*G0_1_1_5_2 - 0.00533589866923222*G0_1_1_5_3 - 0.0320153920153931*G0_1_1_5_4 + 0.159256052589392*G0_1_1_5_5;
    A[223] = 0.00123136123136129*G0_0_0_0_1 + 0.0258585858585867*G0_0_0_0_2 + 0.0541798941798959*G0_0_0_0_4 + 0.00123136123136129*G0_0_0_1_0 - 0.0492544492544509*G0_0_0_1_1 + 0.0160076960076965*G0_0_0_1_2 - 0.00492544492544509*G0_0_0_1_3 + 0.0197017797017803*G0_0_0_1_4 - 0.00985088985089022*G0_0_0_1_5 + 0.0258585858585867*G0_0_0_2_0 + 0.0160076960076965*G0_0_0_2_1 - 0.110822510822515*G0_0_0_2_2 - 0.0591053391053409*G0_0_0_2_3 - 0.137912457912463*G0_0_0_2_4 - 0.0049254449254451*G0_0_0_2_5 - 0.00492544492544509*G0_0_0_3_1 - 0.0591053391053409*G0_0_0_3_2 + 0.472842712842731*G0_0_0_3_3 - 0.0394035594035606*G0_0_0_3_4 + 0.00985088985089028*G0_0_0_3_5 + 0.0541798941798959*G0_0_0_4_0 + 0.0197017797017803*G0_0_0_4_1 - 0.137912457912463*G0_0_0_4_2 - 0.0394035594035606*G0_0_0_4_3 - 0.788071188071215*G0_0_0_4_4 - 0.0295526695526706*G0_0_0_4_5 - 0.00985088985089022*G0_0_0_5_1 - 0.0049254449254451*G0_0_0_5_2 + 0.00985088985089028*G0_0_0_5_3 - 0.0295526695526706*G0_0_0_5_4 - 0.0197017797017806*G0_0_0_5_5 + 0.0160076960076965*G0_0_1_0_0 - 0.00184704184704191*G0_0_1_0_1 - 0.00184704184704185*G0_0_1_0_2 - 0.0418662818662831*G0_0_1_0_3 - 0.0123136123136126*G0_0_1_0_4 - 0.0123136123136127*G0_0_1_0_5 - 0.00184704184704191*G0_0_1_1_0 - 0.00861952861952875*G0_0_1_1_1 + 0.000615680615680589*G0_0_1_1_2 - 0.0221645021645029*G0_0_1_1_3 - 0.00738816738816761*G0_0_1_1_4 + 0.0123136123136127*G0_0_1_1_5 - 0.00184704184704185*G0_0_1_2_0 + 0.00061568061568059*G0_0_1_2_1 - 0.00861952861952912*G0_0_1_2_2 - 0.0221645021645028*G0_0_1_2_3 + 0.0123136123136124*G0_0_1_2_4 - 0.0073881673881676*G0_0_1_2_5 - 0.0418662818662831*G0_0_1_3_0 - 0.0221645021645029*G0_0_1_3_1 - 0.0221645021645028*G0_0_1_3_2 + 0.837325637325668*G0_0_1_3_3 + 0.0985088985089018*G0_0_1_3_4 + 0.0985088985089019*G0_0_1_3_5 - 0.0123136123136126*G0_0_1_4_0 - 0.00738816738816761*G0_0_1_4_1 + 0.0123136123136124*G0_0_1_4_2 + 0.0985088985089018*G0_0_1_4_3 + 0.0689562289562302*G0_0_1_4_4 + 0.0295526695526704*G0_0_1_4_5 - 0.0123136123136127*G0_0_1_5_0 + 0.0123136123136127*G0_0_1_5_1 - 0.0073881673881676*G0_0_1_5_2 + 0.0985088985089019*G0_0_1_5_3 + 0.0295526695526704*G0_0_1_5_4 + 0.0689562289562305*G0_0_1_5_5 + 0.0061568061568064*G0_1_0_0_0 + 0.0153920153920159*G0_1_0_0_1 + 0.0153920153920159*G0_1_0_0_2 - 0.0418662818662831*G0_1_0_0_3 - 0.0517171717171734*G0_1_0_0_4 - 0.0517171717171733*G0_1_0_0_5 + 0.0153920153920159*G0_1_0_1_0 - 0.0332467532467543*G0_1_0_1_1 + 0.0350937950937962*G0_1_0_1_2 - 0.0911207311207343*G0_1_0_1_3 - 0.0664935064935087*G0_1_0_1_4 - 0.0763443963443989*G0_1_0_1_5 + 0.0153920153920159*G0_1_0_2_0 + 0.0350937950937962*G0_1_0_2_1 - 0.0332467532467541*G0_1_0_2_2 - 0.0911207311207338*G0_1_0_2_3 - 0.0763443963443988*G0_1_0_2_4 - 0.0664935064935087*G0_1_0_2_5 - 0.0418662818662831*G0_1_0_3_0 - 0.0911207311207343*G0_1_0_3_1 - 0.0911207311207338*G0_1_0_3_2 + 0.52209716209718*G0_1_0_3_3 + 0.216719576719584*G0_1_0_3_4 + 0.216719576719584*G0_1_0_3_5 - 0.0517171717171734*G0_1_0_4_0 - 0.0664935064935087*G0_1_0_4_1 - 0.0763443963443988*G0_1_0_4_2 + 0.216719576719584*G0_1_0_4_3 + 0.226570466570474*G0_1_0_4_4 + 0.265974025974035*G0_1_0_4_5 - 0.0517171717171733*G0_1_0_5_0 - 0.0763443963443989*G0_1_0_5_1 - 0.0664935064935087*G0_1_0_5_2 + 0.216719576719584*G0_1_0_5_3 + 0.265974025974035*G0_1_0_5_4 + 0.226570466570474*G0_1_0_5_5 + 0.0258585858585868*G0_1_1_0_1 + 0.00123136123136123*G0_1_1_0_2 + 0.054179894179896*G0_1_1_0_5 + 0.0258585858585868*G0_1_1_1_0 - 0.110822510822515*G0_1_1_1_1 + 0.0160076960076965*G0_1_1_1_2 - 0.0591053391053414*G0_1_1_1_3 - 0.00492544492544515*G0_1_1_1_4 - 0.137912457912463*G0_1_1_1_5 + 0.00123136123136123*G0_1_1_2_0 + 0.0160076960076965*G0_1_1_2_1 - 0.0492544492544506*G0_1_1_2_2 - 0.00492544492544471*G0_1_1_2_3 - 0.00985088985089011*G0_1_1_2_4 + 0.0197017797017804*G0_1_1_2_5 - 0.0591053391053414*G0_1_1_3_1 - 0.0049254449254447*G0_1_1_3_2 + 0.47284271284273*G0_1_1_3_3 + 0.00985088985089039*G0_1_1_3_4 - 0.0394035594035607*G0_1_1_3_5 - 0.00492544492544515*G0_1_1_4_1 - 0.00985088985089011*G0_1_1_4_2 + 0.00985088985089039*G0_1_1_4_3 - 0.0197017797017802*G0_1_1_4_4 - 0.0295526695526704*G0_1_1_4_5 + 0.054179894179896*G0_1_1_5_0 - 0.137912457912463*G0_1_1_5_1 + 0.0197017797017804*G0_1_1_5_2 - 0.0394035594035607*G0_1_1_5_3 - 0.0295526695526704*G0_1_1_5_4 - 0.788071188071216*G0_1_1_5_5;
    A[192] = A[223] + 0.325079365079376*G0_0_0_0_0 - 0.0147763347763353*G0_0_0_0_1 - 0.0911207311207342*G0_0_0_0_2 - 0.0886580086580114*G0_0_0_0_3 + 0.275824915824925*G0_0_0_0_4 - 0.0147763347763353*G0_0_0_1_0 + 0.118210678210682*G0_0_0_1_1 - 0.0221645021645029*G0_0_0_1_2 - 0.0197017797017803*G0_0_0_1_3 - 0.147763347763353*G0_0_0_1_4 - 0.0492544492544508*G0_0_0_1_5 - 0.0911207311207342*G0_0_0_2_0 - 0.0221645021645029*G0_0_0_2_1 + 0.206868686868694*G0_0_0_2_2 + 0.0197017797017806*G0_0_0_2_3 - 0.059105339105341*G0_0_0_2_4 - 0.108359788359792*G0_0_0_2_5 - 0.0886580086580114*G0_0_0_3_0 - 0.0197017797017803*G0_0_0_3_1 + 0.0197017797017806*G0_0_0_3_2 + 0.630456950456971*G0_0_0_3_3 + 0.472842712842728*G0_0_0_3_4 + 0.394035594035607*G0_0_0_3_5 + 0.275824915824925*G0_0_0_4_0 - 0.147763347763353*G0_0_0_4_1 - 0.059105339105341*G0_0_0_4_2 + 0.472842712842728*G0_0_0_4_3 + 2.52182780182789*G0_0_0_4_4 + 0.512246272246289*G0_0_0_4_5 - 0.0492544492544508*G0_0_0_5_1 - 0.108359788359792*G0_0_0_5_2 + 0.394035594035607*G0_0_0_5_3 + 0.512246272246289*G0_0_0_5_4 + 0.55164983164985*G0_0_0_5_5 + 0.0935834535834567*G0_0_1_0_0 + 0.00246272246272253*G0_0_1_0_1 + 0.00246272246272246*G0_0_1_0_2 - 0.059105339105341*G0_0_1_0_3 - 0.0197017797017803*G0_0_1_0_4 - 0.0197017797017802*G0_0_1_0_5 + 0.00246272246272253*G0_0_1_1_0 + 0.0664935064935086*G0_0_1_1_1 - 0.0147763347763353*G0_0_1_1_2 - 0.0591053391053411*G0_0_1_1_4 - 0.0492544492544509*G0_0_1_1_5 + 0.00246272246272246*G0_0_1_2_0 - 0.0147763347763353*G0_0_1_2_1 + 0.0664935064935092*G0_0_1_2_2 - 0.0492544492544506*G0_0_1_2_4 - 0.0591053391053411*G0_0_1_2_5 - 0.059105339105341*G0_0_1_3_0 + 0.236421356421364*G0_0_1_3_3 + 0.236421356421364*G0_0_1_3_4 + 0.236421356421364*G0_0_1_3_5 - 0.0197017797017803*G0_0_1_4_0 - 0.0591053391053411*G0_0_1_4_1 - 0.0492544492544506*G0_0_1_4_2 + 0.236421356421364*G0_0_1_4_3 + 0.197017797017805*G0_0_1_4_4 + 0.236421356421365*G0_0_1_4_5 - 0.0197017797017803*G0_0_1_5_0 - 0.0492544492544509*G0_0_1_5_1 - 0.0591053391053411*G0_0_1_5_2 + 0.236421356421364*G0_0_1_5_3 + 0.236421356421365*G0_0_1_5_4 + 0.197017797017804*G0_0_1_5_5 + 0.103434343434347*G0_1_0_0_0 - 0.0147763347763353*G0_1_0_0_1 - 0.0147763347763353*G0_1_0_0_2 - 0.059105339105341*G0_1_0_0_3 + 0.0197017797017804*G0_1_0_0_4 + 0.0197017797017804*G0_1_0_0_5 - 0.0147763347763353*G0_1_0_1_0 + 0.0911207311207341*G0_1_0_1_1 - 0.0492544492544509*G0_1_0_1_2 + 0.0689562289562314*G0_1_0_1_3 + 0.0394035594035607*G0_1_0_1_5 - 0.0147763347763353*G0_1_0_2_0 - 0.0492544492544509*G0_1_0_2_1 + 0.0911207311207342*G0_1_0_2_2 + 0.0689562289562313*G0_1_0_2_3 + 0.0394035594035607*G0_1_0_2_4 - 0.059105339105341*G0_1_0_3_0 + 0.0689562289562314*G0_1_0_3_1 + 0.0689562289562313*G0_1_0_3_2 + 0.551649831649851*G0_1_0_3_3 + 0.118210678210682*G0_1_0_3_4 + 0.118210678210682*G0_1_0_3_5 + 0.0197017797017804*G0_1_0_4_0 + 0.0394035594035607*G0_1_0_4_2 + 0.118210678210682*G0_1_0_4_3 + 0.0394035594035608*G0_1_0_4_4 + 0.0197017797017804*G0_1_0_5_0 + 0.0394035594035607*G0_1_0_5_1 + 0.118210678210682*G0_1_0_5_3 + 0.0394035594035604*G0_1_0_5_5 + 0.325079365079377*G0_1_1_0_0 - 0.0911207311207344*G0_1_1_0_1 - 0.0147763347763353*G0_1_1_0_2 - 0.0886580086580115*G0_1_1_0_3 + 0.275824915824927*G0_1_1_0_5 - 0.0911207311207344*G0_1_1_1_0 + 0.206868686868694*G0_1_1_1_1 - 0.022164502164503*G0_1_1_1_2 + 0.0197017797017807*G0_1_1_1_3 - 0.108359788359792*G0_1_1_1_4 - 0.0591053391053409*G0_1_1_1_5 - 0.0147763347763353*G0_1_1_2_0 - 0.022164502164503*G0_1_1_2_1 + 0.118210678210682*G0_1_1_2_2 - 0.0197017797017803*G0_1_1_2_3 - 0.0492544492544509*G0_1_1_2_4 - 0.147763347763353*G0_1_1_2_5 - 0.0886580086580115*G0_1_1_3_0 + 0.0197017797017806*G0_1_1_3_1 - 0.0197017797017803*G0_1_1_3_2 + 0.630456950456972*G0_1_1_3_3 + 0.394035594035607*G0_1_1_3_4 + 0.472842712842729*G0_1_1_3_5 - 0.108359788359792*G0_1_1_4_1 - 0.0492544492544509*G0_1_1_4_2 + 0.394035594035607*G0_1_1_4_3 + 0.55164983164985*G0_1_1_4_4 + 0.512246272246289*G0_1_1_4_5 + 0.275824915824927*G0_1_1_5_0 - 0.0591053391053409*G0_1_1_5_1 - 0.147763347763353*G0_1_1_5_2 + 0.472842712842729*G0_1_1_5_3 + 0.512246272246289*G0_1_1_5_4 + 2.52182780182789*G0_1_1_5_5;
    A[208] = A[192] - 0.256123136123145*G0_0_0_0_0 + 0.0591053391053411*G0_0_0_0_2 - 0.0394035594035607*G0_0_0_0_3 - 0.354632034632047*G0_0_0_0_4 - 0.0591053391053412*G0_0_0_0_5 + 0.256123136123145*G0_0_0_1_1 - 0.0591053391053411*G0_0_0_1_2 + 0.354632034632047*G0_0_0_1_3 + 0.0394035594035607*G0_0_0_1_4 + 0.0591053391053414*G0_0_0_1_5 + 0.0591053391053411*G0_0_0_2_0 - 0.0591053391053411*G0_0_0_2_1 - 0.157614237614244*G0_0_0_2_3 + 0.157614237614243*G0_0_0_2_4 - 0.0394035594035607*G0_0_0_3_0 + 0.354632034632047*G0_0_0_3_1 - 0.157614237614244*G0_0_0_3_2 + 0.630456950456972*G0_0_0_3_3 + 0.0788071188071219*G0_0_0_3_5 - 0.354632034632047*G0_0_0_4_0 + 0.0394035594035607*G0_0_0_4_1 + 0.157614237614243*G0_0_0_4_2 - 0.630456950456973*G0_0_0_4_4 - 0.0788071188071212*G0_0_0_4_5 - 0.0591053391053412*G0_0_0_5_0 + 0.0591053391053414*G0_0_0_5_1 + 0.0788071188071219*G0_0_0_5_3 - 0.0788071188071212*G0_0_0_5_4 - 0.0985088985089018*G0_0_1_0_0 - 0.0147763347763352*G0_0_1_0_1 + 0.00738816738816765*G0_0_1_0_2 + 0.0394035594035607*G0_0_1_0_3 + 0.0295526695526704*G0_0_1_0_4 + 0.00985088985089008*G0_0_1_0_5 - 0.0147763347763352*G0_0_1_1_0 + 0.157614237614243*G0_0_1_1_1 - 0.0517171717171734*G0_0_1_1_2 + 0.384184704184717*G0_0_1_1_3 + 0.0788071188071214*G0_0_1_1_4 + 0.0689562289562314*G0_0_1_1_5 + 0.00738816738816764*G0_0_1_2_0 - 0.0517171717171734*G0_0_1_2_1 - 0.0197017797017806*G0_0_1_2_2 - 0.137912457912463*G0_0_1_2_3 + 0.0197017797017804*G0_0_1_2_4 + 0.0197017797017802*G0_0_1_2_5 + 0.0394035594035607*G0_0_1_3_0 + 0.384184704184717*G0_0_1_3_1 - 0.137912457912463*G0_0_1_3_2 + 0.394035594035608*G0_0_1_3_3 - 0.236421356421364*G0_0_1_3_4 - 0.118210678210682*G0_0_1_3_5 + 0.0295526695526704*G0_0_1_4_0 + 0.0788071188071214*G0_0_1_4_1 + 0.0197017797017804*G0_0_1_4_2 - 0.236421356421364*G0_0_1_4_3 - 0.236421356421364*G0_0_1_4_4 - 0.197017797017804*G0_0_1_4_5 + 0.00985088985089009*G0_0_1_5_0 + 0.0689562289562314*G0_0_1_5_1 + 0.0197017797017802*G0_0_1_5_2 - 0.118210678210682*G0_0_1_5_3 - 0.197017797017804*G0_0_1_5_4 - 0.0985088985089018*G0_1_0_0_0 - 0.0147763347763352*G0_1_0_0_1 + 0.00738816738816764*G0_1_0_0_2 + 0.0394035594035607*G0_1_0_0_3 + 0.0295526695526704*G0_1_0_0_4 + 0.00985088985089008*G0_1_0_0_5 - 0.0147763347763352*G0_1_0_1_0 + 0.157614237614243*G0_1_0_1_1 - 0.0517171717171734*G0_1_0_1_2 + 0.384184704184717*G0_1_0_1_3 + 0.0788071188071214*G0_1_0_1_4 + 0.0689562289562314*G0_1_0_1_5 + 0.00738816738816764*G0_1_0_2_0 - 0.0517171717171734*G0_1_0_2_1 - 0.0197017797017807*G0_1_0_2_2 - 0.137912457912463*G0_1_0_2_3 + 0.0197017797017804*G0_1_0_2_4 + 0.0197017797017802*G0_1_0_2_5 + 0.0394035594035607*G0_1_0_3_0 + 0.384184704184717*G0_1_0_3_1 - 0.137912457912463*G0_1_0_3_2 + 0.394035594035608*G0_1_0_3_3 - 0.236421356421364*G0_1_0_3_4 - 0.118210678210682*G0_1_0_3_5 + 0.0295526695526704*G0_1_0_4_0 + 0.0788071188071214*G0_1_0_4_1 + 0.0197017797017804*G0_1_0_4_2 - 0.236421356421364*G0_1_0_4_3 - 0.236421356421364*G0_1_0_4_4 - 0.197017797017804*G0_1_0_4_5 + 0.00985088985089009*G0_1_0_5_0 + 0.0689562289562314*G0_1_0_5_1 + 0.0197017797017802*G0_1_0_5_2 - 0.118210678210682*G0_1_0_5_3 - 0.197017797017804*G0_1_0_5_4 - 0.275824915824926*G0_1_1_0_0 - 0.0147763347763351*G0_1_1_0_1 + 0.0295526695526706*G0_1_1_0_2 - 0.0197017797017804*G0_1_1_0_3 - 0.0197017797017806*G0_1_1_0_4 - 0.512246272246291*G0_1_1_0_5 - 0.0147763347763351*G0_1_1_1_0 + 0.334930254930267*G0_1_1_1_1 - 0.0738816738816763*G0_1_1_1_2 + 0.433439153439168*G0_1_1_1_3 + 0.137912457912463*G0_1_1_1_4 + 0.591053391053412*G0_1_1_1_5 + 0.0295526695526706*G0_1_1_2_0 - 0.0738816738816763*G0_1_1_2_1 - 0.0197017797017808*G0_1_1_2_2 - 0.157614237614244*G0_1_1_2_3 + 0.0394035594035606*G0_1_1_2_4 + 0.0197017797017803*G0_1_1_2_5 - 0.0197017797017804*G0_1_1_3_0 + 0.433439153439168*G0_1_1_3_1 - 0.157614237614244*G0_1_1_3_2 + 0.630456950456972*G0_1_1_3_3 - 0.236421356421364*G0_1_1_3_4 - 0.0197017797017806*G0_1_1_4_0 + 0.137912457912463*G0_1_1_4_1 + 0.0394035594035606*G0_1_1_4_2 - 0.236421356421364*G0_1_1_4_3 - 0.472842712842728*G0_1_1_4_4 - 0.315228475228486*G0_1_1_4_5 - 0.512246272246291*G0_1_1_5_0 + 0.591053391053412*G0_1_1_5_1 + 0.0197017797017802*G0_1_1_5_2 - 0.315228475228486*G0_1_1_5_4;
    A[193] = A[223] - 0.118210678210682*G0_0_0_0_0 - 0.00492544492544507*G0_0_0_0_1 - 0.0123136123136127*G0_0_0_0_2 + 0.0886580086580114*G0_0_0_0_3 - 0.137912457912463*G0_0_0_0_4 + 0.0492544492544508*G0_0_0_0_5 - 0.00492544492544507*G0_0_0_1_0 - 0.0689562289562316*G0_0_0_1_1 - 0.00246272246272243*G0_0_0_1_2 - 0.0788071188071218*G0_0_0_1_3 + 0.0689562289562312*G0_0_0_1_4 + 0.059105339105341*G0_0_0_1_5 - 0.0123136123136127*G0_0_0_2_0 - 0.00246272246272244*G0_0_0_2_1 + 0.0886580086580116*G0_0_0_2_2 + 0.177316017316023*G0_0_0_2_3 + 0.256123136123145*G0_0_0_2_4 + 0.0886580086580117*G0_0_0_2_5 + 0.0886580086580114*G0_0_0_3_0 - 0.0788071188071218*G0_0_0_3_1 + 0.177316017316023*G0_0_0_3_2 - 1.57614237614243*G0_0_0_3_3 - 0.315228475228486*G0_0_0_3_4 - 0.354632034632047*G0_0_0_3_5 - 0.137912457912463*G0_0_0_4_0 + 0.0689562289562312*G0_0_0_4_1 + 0.256123136123145*G0_0_0_4_2 - 0.315228475228486*G0_0_0_4_3 - 0.315228475228487*G0_0_0_4_4 - 0.315228475228486*G0_0_0_4_5 + 0.0492544492544508*G0_0_0_5_0 + 0.059105339105341*G0_0_0_5_1 + 0.0886580086580117*G0_0_0_5_2 - 0.354632034632047*G0_0_0_5_3 - 0.315228475228486*G0_0_0_5_4 - 0.394035594035607*G0_0_0_5_5 - 0.0566426166426182*G0_0_1_0_0 + 0.0172390572390578*G0_0_1_0_1 + 0.004925444925445*G0_0_1_0_2 + 0.068956228956231*G0_0_1_0_3 - 0.00985088985089019*G0_0_1_0_4 + 0.0295526695526705*G0_0_1_0_5 + 0.0172390572390578*G0_0_1_1_0 - 0.0935834535834569*G0_0_1_1_1 + 0.0270899470899481*G0_0_1_1_2 - 0.128061568061573*G0_0_1_1_3 + 0.00985088985089016*G0_0_1_1_4 - 0.049254449254451*G0_0_1_1_5 + 0.004925444925445*G0_0_1_2_0 + 0.0270899470899481*G0_0_1_2_1 - 0.00738816738816737*G0_0_1_2_2 + 0.0886580086580115*G0_0_1_2_3 + 0.0492544492544509*G0_0_1_2_5 + 0.068956228956231*G0_0_1_3_0 - 0.128061568061573*G0_0_1_3_1 + 0.0886580086580115*G0_0_1_3_2 - 1.69435305435311*G0_0_1_3_3 - 0.157614237614243*G0_0_1_3_4 - 0.236421356421365*G0_0_1_3_5 - 0.00985088985089019*G0_0_1_4_0 + 0.00985088985089016*G0_0_1_4_1 - 0.157614237614243*G0_0_1_4_3 - 0.157614237614242*G0_0_1_4_4 - 0.118210678210682*G0_0_1_4_5 + 0.0295526695526705*G0_0_1_5_0 - 0.049254449254451*G0_0_1_5_1 + 0.0492544492544509*G0_0_1_5_2 - 0.236421356421365*G0_0_1_5_3 - 0.118210678210682*G0_0_1_5_4 - 0.433439153439168*G0_0_1_5_5 - 0.0221645021645031*G0_1_0_0_0 - 0.0344781144781156*G0_1_0_0_1 - 0.0295526695526705*G0_1_0_0_2 + 0.128061568061572*G0_1_0_0_3 + 0.118210678210682*G0_1_0_0_4 + 0.137912457912462*G0_1_0_0_5 - 0.0344781144781156*G0_1_0_1_0 - 0.044329004329006*G0_1_0_1_1 - 0.0246272246272253*G0_1_0_1_2 + 0.0295526695526704*G0_1_0_1_3 + 0.128061568061572*G0_1_0_1_4 + 0.108359788359792*G0_1_0_1_5 - 0.0295526695526705*G0_1_0_2_0 - 0.0246272246272253*G0_1_0_2_1 + 0.0270899470899477*G0_1_0_2_2 + 0.197017797017803*G0_1_0_2_3 + 0.128061568061572*G0_1_0_2_4 + 0.108359788359792*G0_1_0_2_5 + 0.128061568061572*G0_1_0_3_0 + 0.0295526695526704*G0_1_0_3_1 + 0.197017797017803*G0_1_0_3_2 - 1.53673881673887*G0_1_0_3_3 - 0.512246272246289*G0_1_0_3_4 - 0.472842712842729*G0_1_0_3_5 + 0.118210678210682*G0_1_0_4_0 + 0.128061568061572*G0_1_0_4_1 + 0.128061568061572*G0_1_0_4_2 - 0.512246272246289*G0_1_0_4_3 - 0.472842712842729*G0_1_0_4_4 - 0.472842712842729*G0_1_0_4_5 + 0.137912457912462*G0_1_0_5_0 + 0.108359788359792*G0_1_0_5_1 + 0.108359788359792*G0_1_0_5_2 - 0.472842712842729*G0_1_0_5_3 - 0.472842712842729*G0_1_0_5_4 - 0.275824915824925*G0_1_0_5_5 - 0.0492544492544508*G0_1_1_0_0 - 0.00985088985089029*G0_1_1_0_1 + 0.0197017797017802*G0_1_1_0_3 - 0.00985088985089009*G0_1_1_0_4 - 0.0591053391053409*G0_1_1_0_5 - 0.00985088985089029*G0_1_1_1_0 + 0.00985088985089024*G0_1_1_1_2 - 0.0788071188071213*G0_1_1_1_3 + 0.0788071188071219*G0_1_1_1_5 + 0.00985088985089025*G0_1_1_2_1 + 0.0492544492544506*G0_1_1_2_2 + 0.0591053391053407*G0_1_1_2_3 + 0.00985088985089013*G0_1_1_2_4 - 0.0197017797017804*G0_1_1_2_5 + 0.0197017797017802*G0_1_1_3_0 - 0.0788071188071213*G0_1_1_3_1 + 0.0591053391053407*G0_1_1_3_2 - 1.26091390091395*G0_1_1_3_3 - 0.039403559403561*G0_1_1_3_4 - 0.0098508898508901*G0_1_1_4_0 + 0.00985088985089013*G0_1_1_4_2 - 0.039403559403561*G0_1_1_4_3 + 0.0394035594035606*G0_1_1_4_5 - 0.0591053391053409*G0_1_1_5_0 + 0.0788071188071219*G0_1_1_5_1 - 0.0197017797017804*G0_1_1_5_2 + 0.0394035594035606*G0_1_1_5_4 + 1.26091390091395*G0_1_1_5_5;
    A[222] = A[193] + 0.0689562289562313*G0_0_0_0_0 + 0.00492544492544505*G0_0_0_0_1 + 0.00246272246272247*G0_0_0_0_2 - 0.0689562289562311*G0_0_0_0_3 + 0.0788071188071218*G0_0_0_0_4 - 0.059105339105341*G0_0_0_0_5 + 0.00492544492544505*G0_0_0_1_0 + 0.118210678210682*G0_0_0_1_1 + 0.0123136123136128*G0_0_0_1_2 + 0.137912457912463*G0_0_0_1_3 - 0.0886580086580116*G0_0_0_1_4 - 0.0492544492544507*G0_0_0_1_5 + 0.00246272246272247*G0_0_0_2_0 + 0.0123136123136128*G0_0_0_2_1 - 0.0886580086580121*G0_0_0_2_2 - 0.256123136123145*G0_0_0_2_3 - 0.177316017316023*G0_0_0_2_4 - 0.0886580086580117*G0_0_0_2_5 - 0.0689562289562311*G0_0_0_3_0 + 0.137912457912463*G0_0_0_3_1 - 0.256123136123145*G0_0_0_3_2 + 0.315228475228484*G0_0_0_3_3 + 0.315228475228485*G0_0_0_3_4 + 0.315228475228486*G0_0_0_3_5 + 0.0788071188071218*G0_0_0_4_0 - 0.0886580086580116*G0_0_0_4_1 - 0.177316017316023*G0_0_0_4_2 + 0.315228475228485*G0_0_0_4_3 + 1.57614237614243*G0_0_0_4_4 + 0.354632034632047*G0_0_0_4_5 - 0.059105339105341*G0_0_0_5_0 - 0.0492544492544507*G0_0_0_5_1 - 0.0886580086580117*G0_0_0_5_2 + 0.315228475228486*G0_0_0_5_3 + 0.354632034632047*G0_0_0_5_4 + 0.394035594035608*G0_0_0_5_5 - 0.0123136123136126*G0_0_1_0_1 + 0.0123136123136128*G0_0_1_0_2 + 0.0394035594035606*G0_0_1_0_4 - 0.0394035594035612*G0_0_1_0_5 - 0.0123136123136126*G0_0_1_1_0 + 0.086195286195289*G0_0_1_1_1 + 0.216719576719584*G0_0_1_1_3 + 0.0394035594035608*G0_0_1_1_4 + 0.0492544492544513*G0_0_1_1_5 + 0.0123136123136128*G0_0_1_2_0 - 0.0861952861952898*G0_0_1_2_2 - 0.216719576719585*G0_0_1_2_3 - 0.0492544492544512*G0_0_1_2_4 - 0.0394035594035608*G0_0_1_2_5 + 0.216719576719584*G0_0_1_3_1 - 0.216719576719585*G0_0_1_3_2 - 0.0788071188071216*G0_0_1_3_4 + 0.0788071188071214*G0_0_1_3_5 + 0.0394035594035606*G0_0_1_4_0 + 0.0394035594035608*G0_0_1_4_1 - 0.0492544492544512*G0_0_1_4_2 - 0.0788071188071216*G0_0_1_4_3 - 0.275824915824924*G0_0_1_4_4 - 0.0394035594035612*G0_0_1_5_0 + 0.0492544492544513*G0_0_1_5_1 - 0.0394035594035608*G0_0_1_5_2 + 0.0788071188071214*G0_0_1_5_3 + 0.275824915824925*G0_0_1_5_5 + 0.00492544492544507*G0_1_0_0_1 - 0.00492544492544507*G0_1_0_0_2 + 0.0197017797017804*G0_1_0_0_4 - 0.0197017797017804*G0_1_0_0_5 + 0.00492544492544506*G0_1_0_1_0 + 0.0714189514189539*G0_1_0_1_1 + 0.167465127465134*G0_1_0_1_3 - 0.0197017797017804*G0_1_0_1_4 + 0.0197017797017805*G0_1_0_1_5 - 0.00492544492544507*G0_1_0_2_0 - 0.0714189514189543*G0_1_0_2_2 - 0.167465127465134*G0_1_0_2_3 - 0.0197017797017805*G0_1_0_2_4 + 0.0197017797017802*G0_1_0_2_5 + 0.167465127465134*G0_1_0_3_1 - 0.167465127465134*G0_1_0_3_2 + 0.0394035594035606*G0_1_0_3_4 - 0.0394035594035605*G0_1_0_3_5 + 0.0197017797017805*G0_1_0_4_0 - 0.0197017797017804*G0_1_0_4_1 - 0.0197017797017805*G0_1_0_4_2 + 0.0394035594035606*G0_1_0_4_3 + 0.197017797017804*G0_1_0_4_4 - 0.0197017797017804*G0_1_0_5_0 + 0.0197017797017805*G0_1_0_5_1 + 0.0197017797017802*G0_1_0_5_2 - 0.0394035594035604*G0_1_0_5_3 - 0.197017797017803*G0_1_0_5_5 - 0.0689562289562321*G0_1_1_0_0 - 0.00246272246272233*G0_1_1_0_1 - 0.00492544492544502*G0_1_1_0_2 + 0.0689562289562311*G0_1_1_0_3 + 0.0591053391053408*G0_1_1_0_4 - 0.0788071188071225*G0_1_1_0_5 - 0.00246272246272233*G0_1_1_1_0 + 0.0886580086580117*G0_1_1_1_1 - 0.0123136123136126*G0_1_1_1_2 + 0.256123136123145*G0_1_1_1_3 + 0.0886580086580116*G0_1_1_1_4 + 0.177316017316023*G0_1_1_1_5 - 0.00492544492544502*G0_1_1_2_0 - 0.0123136123136126*G0_1_1_2_1 - 0.118210678210683*G0_1_1_2_2 - 0.137912457912463*G0_1_1_2_3 + 0.0492544492544508*G0_1_1_2_4 + 0.0886580086580117*G0_1_1_2_5 + 0.0689562289562311*G0_1_1_3_0 + 0.256123136123145*G0_1_1_3_1 - 0.137912457912463*G0_1_1_3_2 - 0.315228475228486*G0_1_1_3_3 - 0.315228475228486*G0_1_1_3_4 - 0.315228475228486*G0_1_1_3_5 + 0.0591053391053408*G0_1_1_4_0 + 0.0886580086580116*G0_1_1_4_1 + 0.0492544492544508*G0_1_1_4_2 - 0.315228475228486*G0_1_1_4_3 - 0.394035594035607*G0_1_1_4_4 - 0.354632034632047*G0_1_1_4_5 - 0.0788071188071225*G0_1_1_5_0 + 0.177316017316023*G0_1_1_5_1 + 0.0886580086580117*G0_1_1_5_2 - 0.315228475228486*G0_1_1_5_3 - 0.354632034632047*G0_1_1_5_4 - 1.57614237614243*G0_1_1_5_5;
    A[207] = A[193] + 0.024627224627225*G0_0_1_0_0 - 0.0344781144781156*G0_0_1_0_1 - 0.0172390572390578*G0_0_1_0_2 + 0.059105339105341*G0_0_1_0_3 + 0.0886580086580114*G0_0_1_0_4 + 0.068956228956231*G0_0_1_0_5 - 0.0344781144781156*G0_0_1_1_0 + 0.0246272246272254*G0_0_1_1_1 - 0.0172390572390578*G0_0_1_1_2 + 0.0886580086580115*G0_0_1_1_3 + 0.0591053391053411*G0_0_1_1_4 + 0.0689562289562314*G0_0_1_1_5 - 0.0172390572390578*G0_0_1_2_0 - 0.0172390572390578*G0_0_1_2_1 + 0.00985088985089008*G0_0_1_2_2 + 0.0394035594035607*G0_0_1_2_3 + 0.0394035594035607*G0_0_1_2_4 + 0.059105339105341*G0_0_1_3_0 + 0.0886580086580115*G0_0_1_3_1 + 0.0394035594035607*G0_0_1_3_2 - 0.157614237614243*G0_0_1_3_3 - 0.236421356421364*G0_0_1_3_4 - 0.118210678210682*G0_0_1_3_5 + 0.0886580086580114*G0_0_1_4_0 + 0.0591053391053411*G0_0_1_4_1 + 0.0394035594035607*G0_0_1_4_2 - 0.236421356421364*G0_0_1_4_3 - 0.157614237614243*G0_0_1_4_4 - 0.118210678210682*G0_0_1_4_5 + 0.068956228956231*G0_0_1_5_0 + 0.0689562289562314*G0_0_1_5_1 - 0.118210678210682*G0_0_1_5_3 - 0.118210678210682*G0_0_1_5_4 + 0.315228475228486*G0_0_1_5_5 - 0.024627224627225*G0_1_0_0_0 + 0.0344781144781156*G0_1_0_0_1 + 0.0172390572390578*G0_1_0_0_2 - 0.059105339105341*G0_1_0_0_3 - 0.0886580086580114*G0_1_0_0_4 - 0.068956228956231*G0_1_0_0_5 + 0.0344781144781156*G0_1_0_1_0 - 0.0246272246272254*G0_1_0_1_1 + 0.0172390572390578*G0_1_0_1_2 - 0.0886580086580115*G0_1_0_1_3 - 0.0591053391053411*G0_1_0_1_4 - 0.0689562289562314*G0_1_0_1_5 + 0.0172390572390578*G0_1_0_2_0 + 0.0172390572390578*G0_1_0_2_1 - 0.00985088985089008*G0_1_0_2_2 - 0.0394035594035607*G0_1_0_2_3 - 0.0394035594035607*G0_1_0_2_4 - 0.059105339105341*G0_1_0_3_0 - 0.0886580086580115*G0_1_0_3_1 - 0.0394035594035607*G0_1_0_3_2 + 0.157614237614243*G0_1_0_3_3 + 0.236421356421364*G0_1_0_3_4 + 0.118210678210682*G0_1_0_3_5 - 0.0886580086580114*G0_1_0_4_0 - 0.0591053391053411*G0_1_0_4_1 - 0.0394035594035607*G0_1_0_4_2 + 0.236421356421364*G0_1_0_4_3 + 0.157614237614243*G0_1_0_4_4 + 0.118210678210682*G0_1_0_4_5 - 0.068956228956231*G0_1_0_5_0 - 0.0689562289562314*G0_1_0_5_1 + 0.118210678210682*G0_1_0_5_3 + 0.118210678210682*G0_1_0_5_4 - 0.315228475228486*G0_1_0_5_5;
    A[194] = A[222] + 0.0246272246272259*G0_0_1_0_0 - 0.0172390572390579*G0_0_1_0_1 - 0.0344781144781156*G0_0_1_0_2 + 0.0591053391053409*G0_0_1_0_3 + 0.0689562289562313*G0_0_1_0_4 + 0.0886580086580119*G0_0_1_0_5 - 0.0172390572390579*G0_0_1_1_0 + 0.00985088985089027*G0_0_1_1_1 - 0.0172390572390578*G0_0_1_1_2 + 0.0394035594035607*G0_0_1_1_3 + 0.0394035594035606*G0_0_1_1_5 - 0.0344781144781156*G0_0_1_2_0 - 0.0172390572390578*G0_0_1_2_1 + 0.0246272246272256*G0_0_1_2_2 + 0.0886580086580116*G0_0_1_2_3 + 0.0689562289562313*G0_0_1_2_4 + 0.059105339105341*G0_0_1_2_5 + 0.0591053391053409*G0_0_1_3_0 + 0.0394035594035607*G0_0_1_3_1 + 0.0886580086580116*G0_0_1_3_2 - 0.157614237614241*G0_0_1_3_3 - 0.118210678210682*G0_0_1_3_4 - 0.236421356421364*G0_0_1_3_5 + 0.0689562289562313*G0_0_1_4_0 + 0.0689562289562313*G0_0_1_4_2 - 0.118210678210682*G0_0_1_4_3 + 0.315228475228485*G0_0_1_4_4 - 0.118210678210682*G0_0_1_4_5 + 0.0886580086580119*G0_0_1_5_0 + 0.0394035594035606*G0_0_1_5_1 + 0.059105339105341*G0_0_1_5_2 - 0.236421356421364*G0_0_1_5_3 - 0.118210678210682*G0_0_1_5_4 - 0.157614237614241*G0_0_1_5_5 - 0.0246272246272259*G0_1_0_0_0 + 0.0172390572390579*G0_1_0_0_1 + 0.0344781144781156*G0_1_0_0_2 - 0.0591053391053409*G0_1_0_0_3 - 0.0689562289562313*G0_1_0_0_4 - 0.0886580086580119*G0_1_0_0_5 + 0.0172390572390579*G0_1_0_1_0 - 0.00985088985089027*G0_1_0_1_1 + 0.0172390572390578*G0_1_0_1_2 - 0.0394035594035607*G0_1_0_1_3 - 0.0394035594035606*G0_1_0_1_5 + 0.0344781144781156*G0_1_0_2_0 + 0.0172390572390578*G0_1_0_2_1 - 0.0246272246272256*G0_1_0_2_2 - 0.0886580086580116*G0_1_0_2_3 - 0.0689562289562313*G0_1_0_2_4 - 0.059105339105341*G0_1_0_2_5 - 0.0591053391053409*G0_1_0_3_0 - 0.0394035594035607*G0_1_0_3_1 - 0.0886580086580116*G0_1_0_3_2 + 0.157614237614241*G0_1_0_3_3 + 0.118210678210682*G0_1_0_3_4 + 0.236421356421364*G0_1_0_3_5 - 0.0689562289562313*G0_1_0_4_0 - 0.0689562289562313*G0_1_0_4_2 + 0.118210678210682*G0_1_0_4_3 - 0.315228475228485*G0_1_0_4_4 + 0.118210678210682*G0_1_0_4_5 - 0.0886580086580119*G0_1_0_5_0 - 0.0394035594035606*G0_1_0_5_1 - 0.059105339105341*G0_1_0_5_2 + 0.236421356421364*G0_1_0_5_3 + 0.118210678210682*G0_1_0_5_4 + 0.157614237614241*G0_1_0_5_5;
    A[210] = A[14] + 0.00274490941157618*G0_0_1_0_1 + 0.000436107102773789*G0_0_1_0_2 - 0.00318101651434995*G0_0_1_0_3 + 0.0128266794933466*G0_0_1_0_4 - 0.0128266794933466*G0_0_1_0_5 + 0.00274490941157618*G0_0_1_1_0 - 0.00210357543690884*G0_0_1_1_1 + 0.000461760461760485*G0_0_1_1_2 - 0.0014878948212282*G0_0_1_1_3 + 0.00128266794933467*G0_0_1_1_4 + 0.000436107102773789*G0_0_1_2_0 + 0.000461760461760486*G0_0_1_2_1 - 0.00107744107744118*G0_0_1_2_2 - 0.00354016354016369*G0_0_1_2_3 - 0.0132884399551071*G0_0_1_2_4 - 0.00189834856501529*G0_0_1_2_5 - 0.00318101651434995*G0_0_1_3_0 - 0.0014878948212282*G0_0_1_3_1 - 0.00354016354016369*G0_0_1_3_2 + 0.0123136123136127*G0_0_1_3_3 + 0.00379669713003057*G0_0_1_3_4 + 0.0101587301587305*G0_0_1_3_5 + 0.0128266794933466*G0_0_1_4_0 + 0.00128266794933467*G0_0_1_4_1 - 0.0132884399551071*G0_0_1_4_2 + 0.00379669713003057*G0_0_1_4_3 - 0.000205226871893515*G0_0_1_4_4 + 0.00123136123136124*G0_0_1_4_5 - 0.0128266794933466*G0_0_1_5_0 - 0.00189834856501529*G0_0_1_5_2 + 0.0101587301587305*G0_0_1_5_3 + 0.00123136123136124*G0_0_1_5_4 - 0.00225749559082914*G0_0_1_5_5 - 0.00274490941157618*G0_1_0_0_1 - 0.00043610710277379*G0_1_0_0_2 + 0.00318101651434995*G0_1_0_0_3 - 0.0128266794933466*G0_1_0_0_4 + 0.0128266794933466*G0_1_0_0_5 - 0.00274490941157618*G0_1_0_1_0 + 0.00210357543690884*G0_1_0_1_1 - 0.000461760461760486*G0_1_0_1_2 + 0.0014878948212282*G0_1_0_1_3 - 0.00128266794933467*G0_1_0_1_4 - 0.000436107102773789*G0_1_0_2_0 - 0.000461760461760487*G0_1_0_2_1 + 0.00107744107744118*G0_1_0_2_2 + 0.00354016354016369*G0_1_0_2_3 + 0.0132884399551071*G0_1_0_2_4 + 0.00189834856501529*G0_1_0_2_5 + 0.00318101651434995*G0_1_0_3_0 + 0.0014878948212282*G0_1_0_3_1 + 0.00354016354016369*G0_1_0_3_2 - 0.0123136123136127*G0_1_0_3_3 - 0.00379669713003056*G0_1_0_3_4 - 0.0101587301587305*G0_1_0_3_5 - 0.0128266794933466*G0_1_0_4_0 - 0.00128266794933467*G0_1_0_4_1 + 0.0132884399551071*G0_1_0_4_2 - 0.00379669713003056*G0_1_0_4_3 + 0.000205226871893519*G0_1_0_4_4 - 0.00123136123136124*G0_1_0_4_5 + 0.0128266794933466*G0_1_0_5_0 + 0.00189834856501529*G0_1_0_5_2 - 0.0101587301587305*G0_1_0_5_3 - 0.00123136123136124*G0_1_0_5_4 + 0.00225749559082915*G0_1_0_5_5;
    A[17] = 1.76366843033591e-05*G0_0_1_0_0 + 0.0011974239752018*G0_0_1_0_1 + 0.00119742397520179*G0_0_1_0_2 + 0.00044145155256268*G0_0_1_0_3 + 0.00065416065416068*G0_0_1_0_4 + 0.000654160654160682*G0_0_1_0_5 + 0.0011974239752018*G0_0_1_1_0 - 0.0161696328363002*G0_0_1_1_1 + 0.000518678852012207*G0_0_1_1_2 - 0.000816631927743088*G0_0_1_1_3 + 3.95489284378198e-05*G0_0_1_1_4 - 0.00540430762653009*G0_0_1_1_5 + 0.00119742397520179*G0_0_1_2_0 + 0.000518678852012208*G0_0_1_2_1 - 0.0161696328363*G0_0_1_2_2 - 0.000816631927743068*G0_0_1_2_3 - 0.00540430762653003*G0_0_1_2_4 + 3.95489284378183e-05*G0_0_1_2_5 + 0.00044145155256268*G0_0_1_3_0 - 0.000816631927743088*G0_0_1_3_1 - 0.000816631927743068*G0_0_1_3_2 + 0.00216343327454445*G0_0_1_3_3 - 0.000962000962000996*G0_0_1_3_4 - 0.000962000962001002*G0_0_1_3_5 + 0.00065416065416068*G0_0_1_4_0 + 3.95489284378198e-05*G0_0_1_4_1 - 0.00540430762653003*G0_0_1_4_2 - 0.000962000962000996*G0_0_1_4_3 - 0.0034461012238791*G0_0_1_4_4 - 0.000158195713751276*G0_0_1_4_5 + 0.000654160654160682*G0_0_1_5_0 - 0.00540430762653009*G0_0_1_5_1 + 3.95489284378182e-05*G0_0_1_5_2 - 0.000962000962001002*G0_0_1_5_3 - 0.000158195713751276*G0_0_1_5_4 - 0.00344610122387915*G0_0_1_5_5;
    A[2] = -A[17] + 0.0161872695206034*G0_0_1_0_0 + 0.000678745123189588*G0_0_1_0_2 + 0.000401902624124859*G0_0_1_0_3 + 0.00147079258190375*G0_0_1_0_4 + 0.00605846828069073*G0_0_1_0_5 - 0.0161872695206036*G0_0_1_1_1 - 0.000678745123189584*G0_0_1_1_2 - 0.00147079258190376*G0_0_1_1_3 - 0.000401902624124858*G0_0_1_1_4 - 0.00605846828069076*G0_0_1_1_5 + 0.000678745123189588*G0_0_1_2_0 - 0.000678745123189583*G0_0_1_2_1 + 0.00458767569878696*G0_0_1_2_3 - 0.00458767569878696*G0_0_1_2_4 + 0.000401902624124859*G0_0_1_3_0 - 0.00147079258190376*G0_0_1_3_1 + 0.00458767569878696*G0_0_1_3_2 + 0.00560953449842359*G0_0_1_3_3 - 0.000803805248249722*G0_0_1_3_5 + 0.00147079258190375*G0_0_1_4_0 - 0.000401902624124858*G0_0_1_4_1 - 0.00458767569878696*G0_0_1_4_2 - 0.00560953449842356*G0_0_1_4_4 + 0.000803805248249721*G0_0_1_4_5 + 0.00605846828069073*G0_0_1_5_0 - 0.00605846828069076*G0_0_1_5_1 - 0.000803805248249722*G0_0_1_5_3 + 0.000803805248249721*G0_0_1_5_4 + 0.0161696328363001*G0_1_1_0_0 - 0.00119742397520179*G0_1_1_0_1 - 0.00051867885201221*G0_1_1_0_2 + 0.000816631927743073*G0_1_1_0_4 + 0.00540430762653005*G0_1_1_0_5 - 0.00119742397520179*G0_1_1_1_0 - 0.0011974239752018*G0_1_1_1_2 - 0.000654160654160681*G0_1_1_1_3 - 0.00044145155256268*G0_1_1_1_4 - 0.000654160654160685*G0_1_1_1_5 - 0.00051867885201221*G0_1_1_2_0 - 0.0011974239752018*G0_1_1_2_1 + 0.0161696328363002*G0_1_1_2_2 + 0.00540430762653006*G0_1_1_2_3 + 0.000816631927743091*G0_1_1_2_4 - 0.000654160654160681*G0_1_1_3_1 + 0.00540430762653006*G0_1_1_3_2 + 0.00344610122387915*G0_1_1_3_3 + 0.000962000962001004*G0_1_1_3_4 + 0.00015819571375128*G0_1_1_3_5 + 0.000816631927743073*G0_1_1_4_0 - 0.00044145155256268*G0_1_1_4_1 + 0.000816631927743091*G0_1_1_4_2 + 0.000962000962001004*G0_1_1_4_3 - 0.00216343327454444*G0_1_1_4_4 + 0.000962000962000999*G0_1_1_4_5 + 0.00540430762653005*G0_1_1_5_0 - 0.000654160654160685*G0_1_1_5_1 + 0.00015819571375128*G0_1_1_5_3 + 0.000962000962000999*G0_1_1_5_4 + 0.00344610122387911*G0_1_1_5_5;
    A[134] = -A[89] + 0.001231361231361*G0_1_0_0_0 - 0.0123136123136128*G0_1_0_0_2 + 0.0238063171396511*G0_1_0_0_3 - 0.0730607663941024*G0_1_0_0_4 - 0.00738816738816785*G0_1_0_0_5 - 0.00123136123136113*G0_1_0_1_1 + 0.0123136123136127*G0_1_0_1_2 + 0.0730607663941023*G0_1_0_1_3 - 0.0238063171396513*G0_1_0_1_4 + 0.00738816738816773*G0_1_0_1_5 - 0.0123136123136128*G0_1_0_2_0 + 0.0123136123136127*G0_1_0_2_1 - 0.098508898508902*G0_1_0_2_3 + 0.0985088985089023*G0_1_0_2_4 + 0.0238063171396511*G0_1_0_3_0 + 0.0730607663941023*G0_1_0_3_1 - 0.0985088985089019*G0_1_0_3_2 - 0.67314413981083*G0_1_0_3_3 - 0.0476126342793026*G0_1_0_3_5 - 0.0730607663941024*G0_1_0_4_0 - 0.0238063171396513*G0_1_0_4_1 + 0.0985088985089023*G0_1_0_4_2 + 0.673144139810831*G0_1_0_4_4 + 0.0476126342793027*G0_1_0_4_5 - 0.00738816738816784*G0_1_0_5_0 + 0.00738816738816773*G0_1_0_5_1 - 0.0476126342793026*G0_1_0_5_3 + 0.0476126342793027*G0_1_0_5_4 - 0.061568061568064*G0_1_1_0_0 + 0.0186756453423127*G0_1_1_0_1 + 0.0080038480038483*G0_1_1_0_2 + 0.0492544492544508*G0_1_1_0_3 - 0.00656725990059352*G0_1_1_0_4 - 0.0213435946769291*G0_1_1_0_5 + 0.0186756453423127*G0_1_1_1_0 - 0.0627994227994252*G0_1_1_1_1 + 0.020317460317461*G0_1_1_1_2 + 0.0664935064935087*G0_1_1_1_3 + 0.0254481321147996*G0_1_1_1_4 - 0.0139554272887613*G0_1_1_1_5 + 0.0080038480038483*G0_1_1_2_0 + 0.020317460317461*G0_1_1_2_1 + 0.00820907487574171*G0_1_1_2_2 - 0.0985088985089021*G0_1_1_2_3 + 0.0394035594035607*G0_1_1_2_5 + 0.0492544492544508*G0_1_1_3_0 + 0.0664935064935087*G0_1_1_3_1 - 0.0985088985089021*G0_1_1_3_2 - 0.728965848965874*G0_1_1_3_3 - 0.149405162738501*G0_1_1_3_4 - 0.177316017316023*G0_1_1_3_5 - 0.00656725990059352*G0_1_1_4_0 + 0.0254481321147996*G0_1_1_4_1 - 0.149405162738501*G0_1_1_4_3 - 0.0558217091550445*G0_1_1_4_4 - 0.129703383036721*G0_1_1_4_5 - 0.0213435946769291*G0_1_1_5_0 - 0.0139554272887613*G0_1_1_5_1 + 0.0394035594035607*G0_1_1_5_2 - 0.177316017316023*G0_1_1_5_3 - 0.129703383036721*G0_1_1_5_4 - 0.663293249959939*G0_1_1_5_5;
    A[186] = A[134] - 0.220003206669881*G0_0_0_0_0 + 0.0172390572390578*G0_0_0_0_1 + 0.031194484527819*G0_0_0_0_2 + 0.0131345198011869*G0_0_0_0_3 - 0.320153920153931*G0_0_0_0_4 - 0.063209876543212*G0_0_0_0_5 + 0.0172390572390578*G0_0_0_1_0 - 0.0238063171396514*G0_0_0_1_1 + 0.0287317620650966*G0_0_0_1_2 + 0.067314413981083*G0_0_0_1_3 + 0.0525380792047477*G0_0_0_1_4 + 0.0205226871893545*G0_0_0_1_5 + 0.031194484527819*G0_0_0_2_0 + 0.0287317620650965*G0_0_0_2_1 - 0.0566426166426201*G0_0_0_2_2 - 0.169106942440282*G0_0_0_2_3 + 0.247914061247403*G0_0_0_2_4 + 0.0262690396023738*G0_0_0_2_5 + 0.0131345198011869*G0_0_0_3_0 + 0.067314413981083*G0_0_0_3_1 - 0.169106942440282*G0_0_0_3_2 - 0.6041879108546*G0_0_0_3_3 - 0.131345198011869*G0_0_0_3_4 - 0.0788071188071217*G0_0_0_3_5 - 0.320153920153931*G0_0_0_4_0 + 0.0525380792047477*G0_0_0_4_1 + 0.247914061247403*G0_0_0_4_2 - 0.131345198011869*G0_0_0_4_3 - 0.630456950456972*G0_0_0_4_4 - 0.157614237614243*G0_0_0_4_5 - 0.063209876543212*G0_0_0_5_0 + 0.0205226871893545*G0_0_0_5_1 + 0.0262690396023738*G0_0_0_5_2 - 0.0788071188071217*G0_0_0_5_3 - 0.157614237614243*G0_0_0_5_4 - 0.0722398589065282*G0_0_0_5_5 + 0.0952252685586049*G0_0_1_0_0 - 0.0110822510822514*G0_0_1_0_1 + 0.0311944845278189*G0_0_1_0_2 + 0.0451499118165799*G0_0_1_0_3 - 0.0242167708834386*G0_0_1_0_4 + 0.0307840307840318*G0_0_1_0_5 - 0.0110822510822514*G0_0_1_1_0 - 0.0238063171396513*G0_0_1_1_1 + 0.0570530703864057*G0_0_1_1_2 + 0.0800384800384829*G0_0_1_1_3 + 0.0525380792047477*G0_0_1_1_4 + 0.0077986211319548*G0_0_1_1_5 + 0.0311944845278189*G0_0_1_2_0 + 0.0570530703864057*G0_0_1_2_1 - 0.371871091871105*G0_0_1_2_2 - 0.263100849767526*G0_0_1_2_3 - 0.0480230880230897*G0_0_1_2_4 - 0.00574635241301935*G0_0_1_2_5 + 0.0451499118165799*G0_0_1_3_0 + 0.0800384800384829*G0_0_1_3_1 - 0.263100849767526*G0_0_1_3_2 - 0.65344236010905*G0_0_1_3_3 - 0.195375982042655*G0_0_1_3_4 - 0.0788071188071216*G0_0_1_3_5 - 0.0242167708834386*G0_0_1_4_0 + 0.0525380792047477*G0_0_1_4_1 - 0.0480230880230897*G0_0_1_4_2 - 0.195375982042655*G0_0_1_4_3 - 0.630456950456972*G0_0_1_4_4 - 0.0935834535834568*G0_0_1_4_5 + 0.0307840307840318*G0_0_1_5_0 + 0.0077986211319548*G0_0_1_5_1 - 0.00574635241301935*G0_0_1_5_2 - 0.0788071188071216*G0_0_1_5_3 - 0.0935834535834568*G0_0_1_5_4 - 0.0229854096520769*G0_0_1_5_5 - 0.0944043610710305*G0_1_0_0_0 + 0.00697771364438051*G0_1_0_0_1 + 0.031194484527819*G0_1_0_0_2 + 0.0320153920153931*G0_1_0_0_3 + 0.0348885682219029*G0_1_0_0_4 - 0.0513067179733861*G0_1_0_0_5 + 0.00697771364438051*G0_1_0_1_0 - 0.0238063171396514*G0_1_0_1_1 + 0.0389931056597738*G0_1_0_1_2 + 0.0570530703864057*G0_1_0_1_3 + 0.0525380792047477*G0_1_0_1_4 + 0.0307840307840317*G0_1_0_1_5 + 0.031194484527819*G0_1_0_2_0 + 0.0389931056597738*G0_1_0_2_1 - 0.18224146224147*G0_1_0_2_2 - 0.181010101010108*G0_1_0_2_3 - 0.107128427128431*G0_1_0_2_4 + 0.00738816738816754*G0_1_0_2_5 + 0.0320153920153931*G0_1_0_3_0 + 0.0570530703864057*G0_1_0_3_1 - 0.181010101010108*G0_1_0_3_2 - 0.508962642295995*G0_1_0_3_3 - 0.169106942440282*G0_1_0_3_4 - 0.0788071188071216*G0_1_0_3_5 + 0.0348885682219029*G0_1_0_4_0 + 0.0525380792047477*G0_1_0_4_1 - 0.107128427128431*G0_1_0_4_2 - 0.169106942440282*G0_1_0_4_3 - 0.630456950456973*G0_1_0_4_4 - 0.119852493185831*G0_1_0_4_5 - 0.0513067179733861*G0_1_0_5_0 + 0.0307840307840317*G0_1_0_5_1 + 0.00738816738816754*G0_1_0_5_2 - 0.0788071188071216*G0_1_0_5_3 - 0.119852493185831*G0_1_0_5_4 - 0.167465127465133*G0_1_0_5_5 + 0.277466730800074*G0_1_1_0_0 - 0.0500753567420252*G0_1_1_0_1 + 0.0377617444284123*G0_1_1_0_3 + 0.0829116562449924*G0_1_1_0_4 + 0.21179413179414*G0_1_1_0_5 - 0.0500753567420252*G0_1_1_1_0 + 0.0500753567420252*G0_1_1_1_2 + 0.049254449254451*G0_1_1_1_3 - 0.049254449254451*G0_1_1_1_5 + 0.0500753567420252*G0_1_1_2_1 - 0.277466730800074*G0_1_1_2_2 - 0.211794131794139*G0_1_1_2_3 - 0.0829116562449924*G0_1_1_2_4 - 0.0377617444284125*G0_1_1_2_5 + 0.0377617444284123*G0_1_1_3_0 + 0.049254449254451*G0_1_1_3_1 - 0.211794131794139*G0_1_1_3_2 - 0.485977232643917*G0_1_1_3_3 - 0.0755234888568249*G0_1_1_3_4 + 0.0829116562449924*G0_1_1_4_0 - 0.0829116562449924*G0_1_1_4_2 - 0.0755234888568249*G0_1_1_4_3 + 0.0755234888568247*G0_1_1_4_5 + 0.21179413179414*G0_1_1_5_0 - 0.049254449254451*G0_1_1_5_1 - 0.0377617444284125*G0_1_1_5_2 + 0.0755234888568247*G0_1_1_5_4 + 0.485977232643917*G0_1_1_5_5;
    A[218] = A[134] - 0.00328362995029698*G0_0_1_0_0 + 0.000615680615680661*G0_0_1_0_1 + 0.00636203302869982*G0_0_1_0_2 + 0.0106717973384643*G0_0_1_0_3 - 0.048843995510664*G0_0_1_0_4 - 0.00615680615680653*G0_0_1_0_5 + 0.000615680615680661*G0_0_1_1_0 - 0.00451499118165792*G0_0_1_1_1 + 0.0186756453423126*G0_0_1_1_2 + 0.0242167708834383*G0_0_1_1_3 - 0.0131345198011869*G0_0_1_1_4 + 0.00123136123136136*G0_0_1_1_5 + 0.00636203302869982*G0_0_1_2_0 + 0.0186756453423126*G0_0_1_2_1 - 0.192913259579932*G0_0_1_2_2 - 0.0882475549142242*G0_0_1_2_3 + 0.0102613435946777*G0_0_1_2_4 - 0.00246272246272255*G0_0_1_2_5 + 0.0106717973384643*G0_0_1_3_0 + 0.0242167708834383*G0_0_1_3_1 - 0.0882475549142243*G0_0_1_3_2 - 0.160897867564539*G0_0_1_3_3 + 0.00492544492544524*G0_0_1_3_4 - 0.0164181497514836*G0_0_1_3_5 - 0.048843995510664*G0_0_1_4_0 - 0.0131345198011869*G0_0_1_4_1 + 0.0102613435946777*G0_0_1_4_2 + 0.00492544492544524*G0_0_1_4_3 + 0.512246272246291*G0_0_1_4_4 + 0.031194484527819*G0_0_1_4_5 - 0.00615680615680653*G0_0_1_5_0 + 0.00123136123136137*G0_0_1_5_1 - 0.00246272246272255*G0_0_1_5_2 - 0.0164181497514836*G0_0_1_5_3 + 0.031194484527819*G0_0_1_5_4 - 0.0164181497514836*G0_0_1_5_5 + 0.00328362995029698*G0_1_0_0_0 - 0.000615680615680661*G0_1_0_0_1 - 0.00636203302869982*G0_1_0_0_2 - 0.0106717973384643*G0_1_0_0_3 + 0.048843995510664*G0_1_0_0_4 + 0.00615680615680653*G0_1_0_0_5 - 0.00061568061568066*G0_1_0_1_0 + 0.00451499118165792*G0_1_0_1_1 - 0.0186756453423126*G0_1_0_1_2 - 0.0242167708834383*G0_1_0_1_3 + 0.0131345198011869*G0_1_0_1_4 - 0.00123136123136137*G0_1_0_1_5 - 0.00636203302869982*G0_1_0_2_0 - 0.0186756453423126*G0_1_0_2_1 + 0.192913259579932*G0_1_0_2_2 + 0.0882475549142243*G0_1_0_2_3 - 0.0102613435946777*G0_1_0_2_4 + 0.00246272246272255*G0_1_0_2_5 - 0.0106717973384643*G0_1_0_3_0 - 0.0242167708834383*G0_1_0_3_1 + 0.0882475549142243*G0_1_0_3_2 + 0.160897867564539*G0_1_0_3_3 - 0.00492544492544522*G0_1_0_3_4 + 0.0164181497514836*G0_1_0_3_5 + 0.048843995510664*G0_1_0_4_0 + 0.0131345198011869*G0_1_0_4_1 - 0.0102613435946777*G0_1_0_4_2 - 0.00492544492544524*G0_1_0_4_3 - 0.512246272246291*G0_1_0_4_4 - 0.0311944845278189*G0_1_0_4_5 + 0.00615680615680653*G0_1_0_5_0 - 0.00123136123136137*G0_1_0_5_1 + 0.00246272246272255*G0_1_0_5_2 + 0.0164181497514836*G0_1_0_5_3 - 0.0311944845278189*G0_1_0_5_4 + 0.0164181497514836*G0_1_0_5_5;
    A[215] = -A[218] + 0.00123136123136101*G0_0_1_0_0 - 0.0123136123136128*G0_0_1_0_2 + 0.0238063171396511*G0_0_1_0_3 - 0.0730607663941024*G0_0_1_0_4 - 0.00738816738816784*G0_0_1_0_5 - 0.00123136123136113*G0_0_1_1_1 + 0.0123136123136127*G0_0_1_1_2 + 0.0730607663941023*G0_0_1_1_3 - 0.0238063171396513*G0_0_1_1_4 + 0.00738816738816773*G0_0_1_1_5 - 0.0123136123136128*G0_0_1_2_0 + 0.0123136123136127*G0_0_1_2_1 - 0.0985088985089019*G0_0_1_2_3 + 0.0985088985089023*G0_0_1_2_4 + 0.0238063171396511*G0_0_1_3_0 + 0.0730607663941023*G0_0_1_3_1 - 0.0985088985089019*G0_0_1_3_2 - 0.67314413981083*G0_0_1_3_3 - 0.0476126342793026*G0_0_1_3_5 - 0.0730607663941024*G0_0_1_4_0 - 0.0238063171396513*G0_0_1_4_1 + 0.0985088985089023*G0_0_1_4_2 + 0.673144139810831*G0_0_1_4_4 + 0.0476126342793027*G0_0_1_4_5 - 0.00738816738816784*G0_0_1_5_0 + 0.00738816738816773*G0_0_1_5_1 - 0.0476126342793026*G0_0_1_5_3 + 0.0476126342793027*G0_0_1_5_4 - 0.061568061568064*G0_1_1_0_0 + 0.0186756453423127*G0_1_1_0_1 + 0.0080038480038483*G0_1_1_0_2 + 0.0492544492544508*G0_1_1_0_3 - 0.00656725990059352*G0_1_1_0_4 - 0.0213435946769291*G0_1_1_0_5 + 0.0186756453423127*G0_1_1_1_0 - 0.0627994227994252*G0_1_1_1_1 + 0.020317460317461*G0_1_1_1_2 + 0.0664935064935087*G0_1_1_1_3 + 0.0254481321147996*G0_1_1_1_4 - 0.0139554272887613*G0_1_1_1_5 + 0.0080038480038483*G0_1_1_2_0 + 0.020317460317461*G0_1_1_2_1 + 0.00820907487574174*G0_1_1_2_2 - 0.0985088985089021*G0_1_1_2_3 + 0.0394035594035607*G0_1_1_2_5 + 0.0492544492544508*G0_1_1_3_0 + 0.0664935064935087*G0_1_1_3_1 - 0.0985088985089021*G0_1_1_3_2 - 0.728965848965874*G0_1_1_3_3 - 0.149405162738501*G0_1_1_3_4 - 0.177316017316023*G0_1_1_3_5 - 0.00656725990059352*G0_1_1_4_0 + 0.0254481321147996*G0_1_1_4_1 - 0.149405162738501*G0_1_1_4_3 - 0.0558217091550445*G0_1_1_4_4 - 0.129703383036721*G0_1_1_4_5 - 0.0213435946769291*G0_1_1_5_0 - 0.0139554272887613*G0_1_1_5_1 + 0.0394035594035607*G0_1_1_5_2 - 0.177316017316023*G0_1_1_5_3 - 0.129703383036721*G0_1_1_5_4 - 0.663293249959939*G0_1_1_5_5;
    A[69] = A[139] - 0.003796697130031*G0_0_1_0_0 - 0.00230880230880236*G0_0_1_0_1 - 0.000820907487574159*G0_0_1_0_2 + 0.0033862433862435*G0_0_1_0_3 + 0.000820907487574169*G0_0_1_0_4 - 0.00123136123136149*G0_0_1_0_5 - 0.00230880230880236*G0_0_1_1_0 - 0.0395061728395076*G0_0_1_1_1 - 0.00251402918069593*G0_0_1_1_2 + 0.0362225428892109*G0_0_1_1_3 - 0.00112874779541447*G0_0_1_1_4 + 0.0126214526214532*G0_0_1_1_5 - 0.000820907487574159*G0_0_1_2_0 - 0.00251402918069593*G0_0_1_2_1 - 0.00164181497514854*G0_0_1_2_2 - 0.0227801827801837*G0_0_1_2_3 + 0.00133397466730798*G0_0_1_2_4 + 0.00215488215488223*G0_0_1_2_5 + 0.0033862433862435*G0_0_1_3_0 + 0.0362225428892109*G0_0_1_3_1 - 0.0227801827801837*G0_0_1_3_2 + 0.0213435946769285*G0_0_1_3_3 - 0.00451499118165805*G0_0_1_3_4 - 0.0110822510822515*G0_0_1_3_5 + 0.00082090748757417*G0_0_1_4_0 - 0.00112874779541447*G0_0_1_4_1 + 0.00133397466730798*G0_0_1_4_2 - 0.00451499118165805*G0_0_1_4_3 + 0.00328362995029671*G0_0_1_4_4 - 0.00205226871893551*G0_0_1_4_5 - 0.00123136123136149*G0_0_1_5_0 + 0.0126214526214532*G0_0_1_5_1 + 0.00215488215488223*G0_0_1_5_2 - 0.0110822510822515*G0_0_1_5_3 - 0.00205226871893551*G0_0_1_5_4 + 0.00410453743787075*G0_0_1_5_5 + 0.003796697130031*G0_1_0_0_0 + 0.00230880230880236*G0_1_0_0_1 + 0.000820907487574159*G0_1_0_0_2 - 0.0033862433862435*G0_1_0_0_3 - 0.000820907487574168*G0_1_0_0_4 + 0.00123136123136149*G0_1_0_0_5 + 0.00230880230880236*G0_1_0_1_0 + 0.0395061728395077*G0_1_0_1_1 + 0.00251402918069593*G0_1_0_1_2 - 0.0362225428892109*G0_1_0_1_3 + 0.00112874779541447*G0_1_0_1_4 - 0.0126214526214532*G0_1_0_1_5 + 0.000820907487574159*G0_1_0_2_0 + 0.00251402918069593*G0_1_0_2_1 + 0.00164181497514854*G0_1_0_2_2 + 0.0227801827801837*G0_1_0_2_3 - 0.00133397466730798*G0_1_0_2_4 - 0.00215488215488223*G0_1_0_2_5 - 0.0033862433862435*G0_1_0_3_0 - 0.0362225428892109*G0_1_0_3_1 + 0.0227801827801837*G0_1_0_3_2 - 0.0213435946769285*G0_1_0_3_3 + 0.00451499118165805*G0_1_0_3_4 + 0.0110822510822515*G0_1_0_3_5 - 0.000820907487574169*G0_1_0_4_0 + 0.00112874779541448*G0_1_0_4_1 - 0.00133397466730798*G0_1_0_4_2 + 0.00451499118165805*G0_1_0_4_3 - 0.00328362995029672*G0_1_0_4_4 + 0.00205226871893551*G0_1_0_4_5 + 0.00123136123136149*G0_1_0_5_0 - 0.0126214526214532*G0_1_0_5_1 - 0.00215488215488223*G0_1_0_5_2 + 0.0110822510822515*G0_1_0_5_3 + 0.00205226871893551*G0_1_0_5_4 - 0.00410453743787076*G0_1_0_5_5;
    A[94] = A[69] - 0.0100561167227839*G0_0_0_0_0 - 0.000513067179733854*G0_0_0_0_1 + 0.00292448292448305*G0_0_0_0_2 + 0.00194965528298871*G0_0_0_0_3 + 0.00348885682219031*G0_0_0_0_4 - 0.00513067179733864*G0_0_0_0_5 - 0.000513067179733855*G0_0_0_1_0 - 0.0142632675966014*G0_0_0_1_1 + 0.00282186948853631*G0_0_0_1_2 + 0.00800384800384834*G0_0_0_1_3 + 0.00133397466730806*G0_0_0_1_4 + 0.00543851210517891*G0_0_0_1_5 + 0.00292448292448305*G0_0_0_2_0 + 0.00282186948853631*G0_0_0_2_1 + 0.0712137245470595*G0_0_0_2_2 - 0.0173416706750048*G0_0_0_2_3 - 0.0138528138528145*G0_0_0_2_4 - 0.00174442841109514*G0_0_0_2_5 + 0.00194965528298871*G0_0_0_3_0 + 0.00800384800384834*G0_0_0_3_1 - 0.0173416706750048*G0_0_0_3_2 - 0.0849639249639286*G0_0_0_3_3 - 0.00656725990059357*G0_0_0_3_4 - 0.000410453743787157*G0_0_0_3_5 + 0.00348885682219031*G0_0_0_4_0 + 0.00133397466730806*G0_0_0_4_1 - 0.0138528138528145*G0_0_0_4_2 - 0.00656725990059357*G0_0_0_4_3 - 0.00779862113195491*G0_0_0_4_4 + 0.000820907487574171*G0_0_0_4_5 - 0.00513067179733864*G0_0_0_5_0 + 0.00543851210517891*G0_0_0_5_1 - 0.00174442841109514*G0_0_0_5_2 - 0.000410453743787155*G0_0_0_5_3 + 0.000820907487574171*G0_0_0_5_4 - 0.00123136123136113*G0_0_0_5_5 - 0.00041045374378709*G0_0_1_0_1 + 0.000410453743787065*G0_0_1_0_2 + 0.00595157928491295*G0_0_1_0_4 - 0.00595157928491261*G0_0_1_0_5 - 0.000410453743787091*G0_0_1_1_0 - 0.0186756453423127*G0_0_1_1_1 - 0.0223697290363966*G0_0_1_1_3 + 0.00205226871893541*G0_0_1_1_4 + 0.00554112554112548*G0_0_1_1_5 + 0.000410453743787065*G0_0_1_2_0 + 0.0186756453423126*G0_0_1_2_2 + 0.0223697290363965*G0_0_1_2_3 - 0.00554112554112577*G0_0_1_2_4 - 0.00205226871893546*G0_0_1_2_5 - 0.0223697290363966*G0_0_1_3_1 + 0.0223697290363965*G0_0_1_3_2 - 0.0041045374378709*G0_0_1_3_4 + 0.00410453743787086*G0_0_1_3_5 + 0.00595157928491294*G0_0_1_4_0 + 0.00205226871893542*G0_0_1_4_1 - 0.00554112554112578*G0_0_1_4_2 - 0.0041045374378709*G0_0_1_4_3 + 0.00164181497514879*G0_0_1_4_4 - 0.00595157928491261*G0_0_1_5_0 + 0.00554112554112548*G0_0_1_5_1 - 0.00205226871893546*G0_0_1_5_2 + 0.00410453743787086*G0_0_1_5_3 - 0.00164181497514825*G0_0_1_5_5 - 0.00189834856501533*G0_1_0_0_1 + 0.00189834856501529*G0_1_0_0_2 + 0.00800384800384832*G0_1_0_0_4 - 0.00800384800384818*G0_1_0_0_5 - 0.00189834856501533*G0_1_0_1_0 - 0.0565400032066719*G0_1_0_1_1 + 0.036632996632998*G0_1_0_1_3 - 0.00123136123136126*G0_1_0_1_4 + 0.0168286034952707*G0_1_0_1_5 + 0.00189834856501529*G0_1_0_2_0 + 0.0565400032066713*G0_1_0_2_2 - 0.0366329966329981*G0_1_0_2_3 - 0.0168286034952708*G0_1_0_2_4 + 0.00123136123136127*G0_1_0_2_5 + 0.036632996632998*G0_1_0_3_1 - 0.0366329966329981*G0_1_0_3_2 + 0.0024627224627225*G0_1_0_3_4 - 0.00246272246272254*G0_1_0_3_5 + 0.00800384800384832*G0_1_0_4_0 - 0.00123136123136126*G0_1_0_4_1 - 0.0168286034952708*G0_1_0_4_2 + 0.0024627224627225*G0_1_0_4_3 + 0.000820907487574095*G0_1_0_4_4 - 0.00800384800384818*G0_1_0_5_0 + 0.0168286034952707*G0_1_0_5_1 + 0.00123136123136127*G0_1_0_5_2 - 0.00246272246272254*G0_1_0_5_3 - 0.000820907487573849*G0_1_0_5_5 + 0.0100561167227842*G0_1_1_0_0 - 0.00292448292448307*G0_1_1_0_1 + 0.000513067179733849*G0_1_1_0_2 - 0.00194965528298869*G0_1_1_0_3 + 0.00513067179733875*G0_1_1_0_4 - 0.00348885682219002*G0_1_1_0_5 - 0.00292448292448307*G0_1_1_1_0 - 0.0712137245470604*G0_1_1_1_1 - 0.00282186948853624*G0_1_1_1_2 + 0.0173416706750047*G0_1_1_1_3 + 0.00174442841109513*G0_1_1_1_4 + 0.0138528138528142*G0_1_1_1_5 + 0.00051306717973385*G0_1_1_2_0 - 0.00282186948853624*G0_1_1_2_1 + 0.0142632675966013*G0_1_1_2_2 - 0.00800384800384841*G0_1_1_2_3 - 0.00543851210517902*G0_1_1_2_4 - 0.00133397466730808*G0_1_1_2_5 - 0.00194965528298869*G0_1_1_3_0 + 0.0173416706750047*G0_1_1_3_1 - 0.00800384800384842*G0_1_1_3_2 + 0.0849639249639285*G0_1_1_3_3 + 0.000410453743787137*G0_1_1_3_4 + 0.00656725990059356*G0_1_1_3_5 + 0.00513067179733875*G0_1_1_4_0 + 0.00174442841109513*G0_1_1_4_1 - 0.00543851210517902*G0_1_1_4_2 + 0.000410453743787137*G0_1_1_4_3 + 0.00123136123136151*G0_1_1_4_4 - 0.000820907487574109*G0_1_1_4_5 - 0.00348885682219002*G0_1_1_5_0 + 0.0138528138528142*G0_1_1_5_1 - 0.00133397466730807*G0_1_1_5_2 + 0.00656725990059356*G0_1_1_5_3 - 0.000820907487574112*G0_1_1_5_4 + 0.00779862113195503*G0_1_1_5_5;
    A[66] = A[94] + 0.0037966971300309*G0_0_1_0_0 + 0.000820907487574129*G0_0_1_0_1 + 0.00230880230880239*G0_0_1_0_2 - 0.00338624338624354*G0_0_1_0_3 + 0.00123136123136121*G0_0_1_0_4 - 0.00082090748757408*G0_0_1_0_5 + 0.000820907487574129*G0_0_1_1_0 + 0.00164181497514855*G0_0_1_1_1 + 0.00251402918069592*G0_0_1_1_2 + 0.0227801827801837*G0_0_1_1_3 - 0.0021548821548822*G0_0_1_1_4 - 0.00133397466730792*G0_0_1_1_5 + 0.00230880230880239*G0_0_1_2_0 + 0.00251402918069592*G0_0_1_2_1 + 0.0395061728395072*G0_0_1_2_2 - 0.0362225428892109*G0_0_1_2_3 - 0.012621452621453*G0_0_1_2_4 + 0.0011287477954145*G0_0_1_2_5 - 0.00338624338624354*G0_0_1_3_0 + 0.0227801827801837*G0_0_1_3_1 - 0.0362225428892109*G0_0_1_3_2 - 0.0213435946769281*G0_0_1_3_3 + 0.0110822510822515*G0_0_1_3_4 + 0.00451499118165806*G0_0_1_3_5 + 0.00123136123136121*G0_0_1_4_0 - 0.0021548821548822*G0_0_1_4_1 - 0.012621452621453*G0_0_1_4_2 + 0.0110822510822514*G0_0_1_4_3 - 0.00410453743787141*G0_0_1_4_4 + 0.00205226871893541*G0_0_1_4_5 - 0.000820907487574081*G0_0_1_5_0 - 0.00133397466730792*G0_0_1_5_1 + 0.0011287477954145*G0_0_1_5_2 + 0.00451499118165806*G0_0_1_5_3 + 0.00205226871893541*G0_0_1_5_4 - 0.00328362995029636*G0_0_1_5_5 - 0.0037966971300309*G0_1_0_0_0 - 0.000820907487574129*G0_1_0_0_1 - 0.00230880230880239*G0_1_0_0_2 + 0.00338624338624353*G0_1_0_0_3 - 0.00123136123136121*G0_1_0_0_4 + 0.000820907487574081*G0_1_0_0_5 - 0.000820907487574129*G0_1_0_1_0 - 0.00164181497514855*G0_1_0_1_1 - 0.00251402918069592*G0_1_0_1_2 - 0.0227801827801837*G0_1_0_1_3 + 0.0021548821548822*G0_1_0_1_4 + 0.00133397466730792*G0_1_0_1_5 - 0.00230880230880239*G0_1_0_2_0 - 0.00251402918069592*G0_1_0_2_1 - 0.0395061728395072*G0_1_0_2_2 + 0.0362225428892109*G0_1_0_2_3 + 0.012621452621453*G0_1_0_2_4 - 0.0011287477954145*G0_1_0_2_5 + 0.00338624338624354*G0_1_0_3_0 - 0.0227801827801837*G0_1_0_3_1 + 0.0362225428892109*G0_1_0_3_2 + 0.0213435946769281*G0_1_0_3_3 - 0.0110822510822515*G0_1_0_3_4 - 0.00451499118165806*G0_1_0_3_5 - 0.00123136123136121*G0_1_0_4_0 + 0.0021548821548822*G0_1_0_4_1 + 0.012621452621453*G0_1_0_4_2 - 0.0110822510822514*G0_1_0_4_3 + 0.00410453743787141*G0_1_0_4_4 - 0.00205226871893541*G0_1_0_4_5 + 0.000820907487574081*G0_1_0_5_0 + 0.00133397466730792*G0_1_0_5_1 - 0.0011287477954145*G0_1_0_5_2 - 0.00451499118165806*G0_1_0_5_3 - 0.00205226871893541*G0_1_0_5_4 + 0.00328362995029635*G0_1_0_5_5;
    A[39] = -A[41] - 0.0231393298059973*G0_1_0_0_0 - 0.000726845171289644*G0_1_0_0_2 - 0.00104323659879218*G0_1_0_0_3 + 0.000735396290951841*G0_1_0_0_4 + 0.0047031158142271*G0_1_0_0_5 + 0.0231393298059975*G0_1_0_1_1 + 0.00072684517128963*G0_1_0_1_2 - 0.000735396290951857*G0_1_0_1_3 + 0.00104323659879218*G0_1_0_1_4 - 0.00470311581422708*G0_1_0_1_5 - 0.000726845171289643*G0_1_0_2_0 + 0.00072684517128963*G0_1_0_2_1 - 0.00321522099299884*G0_1_0_2_3 + 0.00321522099299891*G0_1_0_2_4 - 0.00104323659879218*G0_1_0_3_0 - 0.000735396290951856*G0_1_0_3_1 - 0.00321522099299884*G0_1_0_3_2 - 0.00499385388274302*G0_1_0_3_3 + 0.00208647319758435*G0_1_0_3_5 + 0.000735396290951841*G0_1_0_4_0 + 0.00104323659879218*G0_1_0_4_1 + 0.00321522099299891*G0_1_0_4_2 + 0.00499385388274291*G0_1_0_4_4 - 0.00208647319758437*G0_1_0_4_5 + 0.0047031158142271*G0_1_0_5_0 - 0.00470311581422708*G0_1_0_5_1 + 0.00208647319758434*G0_1_0_5_3 - 0.00208647319758437*G0_1_0_5_4 + 0.0153407086740426*G0_1_1_0_0 - 0.00539575650686783*G0_1_1_0_1 + 0.000735396290951858*G0_1_1_0_2 + 0.000530169419058325*G0_1_1_0_3 - 0.00066698733365401*G0_1_1_0_4 + 0.01287798621132*G0_1_1_0_5 - 0.00539575650686783*G0_1_1_1_0 + 0.0384800384800401*G0_1_1_1_1 + 0.0014622414622415*G0_1_1_1_2 - 0.00140238362460585*G0_1_1_1_3 + 0.0015734060178505*G0_1_1_1_4 + 0.00817487039709301*G0_1_1_1_5 + 0.000735396290951858*G0_1_1_2_0 + 0.0014622414622415*G0_1_1_2_1 - 0.0125701459034796*G0_1_1_2_2 - 0.00391641280530183*G0_1_1_2_3 - 0.000701191812302923*G0_1_1_2_4 - 0.000530169419058344*G0_1_1_2_5 + 0.000530169419058325*G0_1_1_3_0 - 0.00140238362460585*G0_1_1_3_1 - 0.00391641280530182*G0_1_1_3_2 - 0.0147079258190375*G0_1_1_3_3 - 0.00420715087381768*G0_1_1_3_4 - 0.000666987333654009*G0_1_1_4_0 + 0.0015734060178505*G0_1_1_4_1 - 0.000701191812302923*G0_1_1_4_2 - 0.00420715087381768*G0_1_1_4_3 - 0.00971407193629443*G0_1_1_4_4 - 0.00208647319758435*G0_1_1_4_5 + 0.01287798621132*G0_1_1_5_0 + 0.00817487039709301*G0_1_1_5_1 - 0.000530169419058344*G0_1_1_5_2 - 0.00208647319758435*G0_1_1_5_4 + 0.0549323927101726*G0_1_1_5_5;
    A[137] = A[39] - 0.020573993907328*G0_0_1_0_0 + 0.000641333974667331*G0_0_1_0_1 - 0.000269360269360286*G0_0_1_0_2 - 0.00030784030784031*G0_0_1_0_3 + 0.000205226871893534*G0_0_1_0_4 + 0.000974827641494355*G0_0_1_0_5 + 0.000641333974667331*G0_0_1_1_0 + 0.00256533589866934*G0_0_1_1_1 + 0.000457484901929357*G0_0_1_1_2 - 0.000530169419058332*G0_0_1_1_3 + 0.000735396290951865*G0_0_1_1_4 - 0.00372828817273276*G0_0_1_1_5 - 0.000269360269360286*G0_0_1_2_0 + 0.000457484901929357*G0_0_1_2_1 - 0.00160761049649941*G0_0_1_2_3 + 0.00160761049649948*G0_0_1_2_4 - 0.000188124632569083*G0_0_1_2_5 - 0.00030784030784031*G0_0_1_3_0 - 0.000530169419058332*G0_0_1_3_1 - 0.00160761049649941*G0_0_1_3_2 - 0.00164181497514841*G0_0_1_3_3 - 0.000855111966223104*G0_0_1_3_4 + 0.00099192988081879*G0_0_1_3_5 + 0.000205226871893533*G0_0_1_4_0 + 0.000735396290951865*G0_0_1_4_1 + 0.00160761049649948*G0_0_1_4_2 - 0.000855111966223104*G0_0_1_4_3 + 0.00335203890759459*G0_0_1_4_4 - 0.00109454331676557*G0_0_1_4_5 + 0.000974827641494355*G0_0_1_5_0 - 0.00372828817273276*G0_0_1_5_1 - 0.000188124632569083*G0_0_1_5_2 + 0.000991929880818788*G0_0_1_5_3 - 0.00109454331676557*G0_0_1_5_4 + 0.0222329111218008*G0_0_1_5_5 + 0.020573993907328*G0_1_0_0_0 - 0.000641333974667331*G0_1_0_0_1 + 0.000269360269360286*G0_1_0_0_2 + 0.00030784030784031*G0_1_0_0_3 - 0.000205226871893534*G0_1_0_0_4 - 0.000974827641494355*G0_1_0_0_5 - 0.000641333974667331*G0_1_0_1_0 - 0.00256533589866934*G0_1_0_1_1 - 0.000457484901929358*G0_1_0_1_2 + 0.000530169419058333*G0_1_0_1_3 - 0.000735396290951865*G0_1_0_1_4 + 0.00372828817273277*G0_1_0_1_5 + 0.000269360269360285*G0_1_0_2_0 - 0.000457484901929358*G0_1_0_2_1 + 0.00160761049649941*G0_1_0_2_3 - 0.00160761049649948*G0_1_0_2_4 + 0.000188124632569082*G0_1_0_2_5 + 0.00030784030784031*G0_1_0_3_0 + 0.000530169419058332*G0_1_0_3_1 + 0.00160761049649941*G0_1_0_3_2 + 0.00164181497514841*G0_1_0_3_3 + 0.000855111966223104*G0_1_0_3_4 - 0.00099192988081879*G0_1_0_3_5 - 0.000205226871893533*G0_1_0_4_0 - 0.000735396290951865*G0_1_0_4_1 - 0.00160761049649948*G0_1_0_4_2 + 0.000855111966223104*G0_1_0_4_3 - 0.00335203890759459*G0_1_0_4_4 + 0.00109454331676557*G0_1_0_4_5 - 0.000974827641494355*G0_1_0_5_0 + 0.00372828817273276*G0_1_0_5_1 + 0.000188124632569083*G0_1_0_5_2 - 0.000991929880818789*G0_1_0_5_3 + 0.00109454331676557*G0_1_0_5_4 - 0.0222329111218008*G0_1_0_5_5;
    A[167] = -A[137] - 0.0231393298059973*G0_0_1_0_0 - 0.000726845171289644*G0_0_1_0_2 - 0.00104323659879218*G0_0_1_0_3 + 0.000735396290951842*G0_0_1_0_4 + 0.0047031158142271*G0_0_1_0_5 + 0.0231393298059975*G0_0_1_1_1 + 0.00072684517128963*G0_0_1_1_2 - 0.000735396290951856*G0_0_1_1_3 + 0.00104323659879218*G0_0_1_1_4 - 0.00470311581422708*G0_0_1_1_5 - 0.000726845171289644*G0_0_1_2_0 + 0.00072684517128963*G0_0_1_2_1 - 0.00321522099299884*G0_0_1_2_3 + 0.00321522099299891*G0_0_1_2_4 - 0.00104323659879218*G0_0_1_3_0 - 0.000735396290951856*G0_0_1_3_1 - 0.00321522099299884*G0_0_1_3_2 - 0.00499385388274302*G0_0_1_3_3 + 0.00208647319758435*G0_0_1_3_5 + 0.000735396290951842*G0_0_1_4_0 + 0.00104323659879218*G0_0_1_4_1 + 0.00321522099299891*G0_0_1_4_2 + 0.00499385388274291*G0_0_1_4_4 - 0.00208647319758437*G0_0_1_4_5 + 0.0047031158142271*G0_0_1_5_0 - 0.00470311581422707*G0_0_1_5_1 + 0.00208647319758435*G0_0_1_5_3 - 0.00208647319758437*G0_0_1_5_4 + 0.0153407086740426*G0_1_1_0_0 - 0.00539575650686783*G0_1_1_0_1 + 0.000735396290951858*G0_1_1_0_2 + 0.000530169419058325*G0_1_1_0_3 - 0.00066698733365401*G0_1_1_0_4 + 0.01287798621132*G0_1_1_0_5 - 0.00539575650686783*G0_1_1_1_0 + 0.0384800384800401*G0_1_1_1_1 + 0.0014622414622415*G0_1_1_1_2 - 0.00140238362460585*G0_1_1_1_3 + 0.0015734060178505*G0_1_1_1_4 + 0.00817487039709301*G0_1_1_1_5 + 0.000735396290951858*G0_1_1_2_0 + 0.0014622414622415*G0_1_1_2_1 - 0.0125701459034796*G0_1_1_2_2 - 0.00391641280530182*G0_1_1_2_3 - 0.000701191812302923*G0_1_1_2_4 - 0.000530169419058344*G0_1_1_2_5 + 0.000530169419058325*G0_1_1_3_0 - 0.00140238362460585*G0_1_1_3_1 - 0.00391641280530182*G0_1_1_3_2 - 0.0147079258190375*G0_1_1_3_3 - 0.00420715087381768*G0_1_1_3_4 - 0.000666987333654009*G0_1_1_4_0 + 0.0015734060178505*G0_1_1_4_1 - 0.000701191812302923*G0_1_1_4_2 - 0.00420715087381768*G0_1_1_4_3 - 0.00971407193629443*G0_1_1_4_4 - 0.00208647319758435*G0_1_1_4_5 + 0.01287798621132*G0_1_1_5_0 + 0.00817487039709301*G0_1_1_5_1 - 0.000530169419058344*G0_1_1_5_2 - 0.00208647319758435*G0_1_1_5_4 + 0.0549323927101726*G0_1_1_5_5;
    A[47] = -A[167] - 0.000949174282507699*G0_0_1_0_0 - 0.000671262893485142*G0_0_1_0_1 - 0.00628934851157093*G0_0_1_0_2 - 0.00427555983111552*G0_0_1_0_3 - 0.00395061728395076*G0_0_1_0_4 + 0.0023088023088024*G0_0_1_0_5 - 0.000671262893485142*G0_0_1_1_0 + 0.0211640211640221*G0_0_1_1_1 - 0.00325370103147891*G0_0_1_1_2 + 0.0085511196622311*G0_0_1_1_3 - 0.000342044786489219*G0_0_1_1_5 - 0.00628934851157093*G0_0_1_2_0 - 0.00325370103147891*G0_0_1_2_1 + 0.0896584896584926*G0_0_1_2_2 + 0.000188124632569056*G0_0_1_2_3 + 0.0290567046122611*G0_0_1_2_4 - 0.000718294051627388*G0_0_1_2_5 - 0.00427555983111552*G0_0_1_3_0 + 0.0085511196622311*G0_0_1_3_1 + 0.000188124632569056*G0_0_1_3_2 + 0.0124504302282085*G0_0_1_3_3 + 0.00865373309817784*G0_0_1_3_4 + 0.00998770776548586*G0_0_1_3_5 - 0.00395061728395076*G0_0_1_4_0 + 0.0290567046122611*G0_0_1_4_2 + 0.00865373309817784*G0_0_1_4_3 + 0.0194965528298867*G0_0_1_4_4 + 0.00153920153920159*G0_0_1_4_5 + 0.0023088023088024*G0_0_1_5_0 - 0.000342044786489219*G0_0_1_5_1 - 0.000718294051627388*G0_0_1_5_2 + 0.00998770776548586*G0_0_1_5_3 + 0.00153920153920159*G0_0_1_5_4 - 0.0201122334455676*G0_0_1_5_5;
    A[92] = -A[47] + 0.00102613435946772*G0_0_1_0_0 - 0.00230880230880241*G0_0_1_0_2 - 0.00318101651434995*G0_0_1_0_3 - 0.0132371332371336*G0_0_1_0_4 - 0.00205226871893544*G0_0_1_0_5 - 0.00102613435946775*G0_0_1_1_1 + 0.00230880230880238*G0_0_1_1_2 + 0.0132371332371337*G0_0_1_1_3 + 0.00318101651434994*G0_0_1_1_4 + 0.00205226871893543*G0_0_1_1_5 - 0.00230880230880241*G0_0_1_2_0 + 0.00230880230880238*G0_0_1_2_1 - 0.0256533589866932*G0_0_1_2_3 + 0.0256533589866932*G0_0_1_2_4 - 0.00318101651434995*G0_0_1_3_0 + 0.0132371332371337*G0_0_1_3_1 - 0.0256533589866932*G0_0_1_3_2 - 0.00205226871893547*G0_0_1_3_3 + 0.00636203302869989*G0_0_1_3_5 - 0.0132371332371336*G0_0_1_4_0 + 0.00318101651434994*G0_0_1_4_1 + 0.0256533589866932*G0_0_1_4_2 + 0.0020522687189356*G0_0_1_4_4 - 0.00636203302869988*G0_0_1_4_5 - 0.00205226871893544*G0_0_1_5_0 + 0.00205226871893543*G0_0_1_5_1 + 0.00636203302869989*G0_0_1_5_3 - 0.00636203302869988*G0_0_1_5_4 - 0.0365047298380645*G0_1_1_0_0 + 0.00606701940035297*G0_1_1_0_1 + 0.00251830474052704*G0_1_1_0_2 - 0.000478862701084926*G0_1_1_0_3 - 0.00788413232857702*G0_1_1_0_4 - 0.0125359414248308*G0_1_1_0_5 + 0.00606701940035297*G0_1_1_1_0 - 0.0375308641975325*G0_1_1_1_1 + 0.00482710704932945*G0_1_1_1_2 + 0.0053530009085566*G0_1_1_1_3 + 0.00270215381326501*G0_1_1_1_4 - 0.0104836727058954*G0_1_1_1_5 + 0.00251830474052704*G0_1_1_2_0 + 0.00482710704932945*G0_1_1_2_1 - 0.077088343755013*G0_1_1_2_2 - 0.0251402918069593*G0_1_1_2_3 + 0.000513067179733835*G0_1_1_2_4 + 0.00124846347068573*G0_1_1_2_5 - 0.000478862701084926*G0_1_1_3_0 + 0.0053530009085566*G0_1_1_3_1 - 0.0251402918069593*G0_1_1_3_2 - 0.00478862701084946*G0_1_1_3_3 - 0.00444658222436016*G0_1_1_3_4 - 0.00153920153920163*G0_1_1_3_5 - 0.00788413232857702*G0_1_1_4_0 + 0.00270215381326501*G0_1_1_4_1 + 0.000513067179733834*G0_1_1_4_2 - 0.00444658222436016*G0_1_1_4_3 - 0.00273635829191387*G0_1_1_4_4 - 0.0079012345679015*G0_1_1_4_5 - 0.0125359414248307*G0_1_1_5_0 - 0.0104836727058954*G0_1_1_5_1 + 0.00124846347068573*G0_1_1_5_2 - 0.00153920153920163*G0_1_1_5_3 - 0.00790123456790149*G0_1_1_5_4 - 0.034820159264605*G0_1_1_5_5;
    A[121] = -A[91] + 0.0153407086740425*G0_0_0_0_0 + 0.000735396290951857*G0_0_0_0_1 - 0.00539575650686779*G0_0_0_0_2 + 0.000530169419058317*G0_0_0_0_3 + 0.01287798621132*G0_0_0_0_4 - 0.000666987333654038*G0_0_0_0_5 + 0.000735396290951857*G0_0_0_1_0 - 0.0125701459034795*G0_0_0_1_1 + 0.00146224146224151*G0_0_0_1_2 - 0.00391641280530185*G0_0_0_1_3 - 0.000530169419058315*G0_0_0_1_4 - 0.000701191812302883*G0_0_0_1_5 - 0.00539575650686779*G0_0_0_2_0 + 0.00146224146224151*G0_0_0_2_1 + 0.0384800384800397*G0_0_0_2_2 - 0.00140238362460587*G0_0_0_2_3 + 0.00817487039709289*G0_0_0_2_4 + 0.00157340601785053*G0_0_0_2_5 + 0.000530169419058317*G0_0_0_3_0 - 0.00391641280530185*G0_0_0_3_1 - 0.00140238362460587*G0_0_0_3_2 - 0.0147079258190374*G0_0_0_3_3 - 0.00420715087381769*G0_0_0_3_5 + 0.01287798621132*G0_0_0_4_0 - 0.000530169419058316*G0_0_0_4_1 + 0.0081748703970929*G0_0_0_4_2 + 0.0549323927101722*G0_0_0_4_4 - 0.00208647319758441*G0_0_0_4_5 - 0.000666987333654037*G0_0_0_5_0 - 0.000701191812302883*G0_0_0_5_1 + 0.00157340601785053*G0_0_0_5_2 - 0.00420715087381769*G0_0_0_5_3 - 0.00208647319758441*G0_0_0_5_4 - 0.00971407193629445*G0_0_0_5_5 - 0.0231393298059974*G0_1_0_0_0 - 0.000726845171289664*G0_1_0_0_1 - 0.00104323659879219*G0_1_0_0_3 + 0.00470311581422705*G0_1_0_0_4 + 0.000735396290951839*G0_1_0_0_5 - 0.000726845171289664*G0_1_0_1_0 + 0.000726845171289626*G0_1_0_1_2 - 0.00321522099299883*G0_1_0_1_3 + 0.003215220992999*G0_1_0_1_5 + 0.000726845171289626*G0_1_0_2_1 + 0.0231393298059972*G0_1_0_2_2 - 0.000735396290951857*G0_1_0_2_3 - 0.00470311581422708*G0_1_0_2_4 + 0.00104323659879219*G0_1_0_2_5 - 0.00104323659879219*G0_1_0_3_0 - 0.00321522099299883*G0_1_0_3_1 - 0.000735396290951857*G0_1_0_3_2 - 0.0049938538827429*G0_1_0_3_3 + 0.00208647319758437*G0_1_0_3_4 + 0.00470311581422705*G0_1_0_4_0 - 0.00470311581422708*G0_1_0_4_2 + 0.00208647319758437*G0_1_0_4_3 - 0.00208647319758441*G0_1_0_4_5 + 0.000735396290951839*G0_1_0_5_0 + 0.003215220992999*G0_1_0_5_1 + 0.00104323659879219*G0_1_0_5_2 - 0.00208647319758441*G0_1_0_5_4 + 0.004993853882743*G0_1_0_5_5;
    A[76] = -A[121] - 0.000949174282507679*G0_1_0_0_0 - 0.00628934851157099*G0_1_0_0_1 - 0.000671262893485128*G0_1_0_0_2 - 0.00427555983111553*G0_1_0_0_3 + 0.00230880230880238*G0_1_0_0_4 - 0.00395061728395078*G0_1_0_0_5 - 0.00628934851157099*G0_1_0_1_0 + 0.0896584896584935*G0_1_0_1_1 - 0.00325370103147894*G0_1_0_1_2 + 0.000188124632569197*G0_1_0_1_3 - 0.000718294051627414*G0_1_0_1_4 + 0.0290567046122614*G0_1_0_1_5 - 0.000671262893485128*G0_1_0_2_0 - 0.00325370103147894*G0_1_0_2_1 + 0.0211640211640218*G0_1_0_2_2 + 0.00855111966223105*G0_1_0_2_3 - 0.000342044786489258*G0_1_0_2_4 - 0.00427555983111553*G0_1_0_3_0 + 0.0001881246325692*G0_1_0_3_1 + 0.00855111966223105*G0_1_0_3_2 + 0.0124504302282084*G0_1_0_3_3 + 0.00998770776548587*G0_1_0_3_4 + 0.00865373309817786*G0_1_0_3_5 + 0.00230880230880237*G0_1_0_4_0 - 0.000718294051627414*G0_1_0_4_1 - 0.000342044786489259*G0_1_0_4_2 + 0.00998770776548587*G0_1_0_4_3 - 0.0201122334455675*G0_1_0_4_4 + 0.00153920153920158*G0_1_0_4_5 - 0.00395061728395078*G0_1_0_5_0 + 0.0290567046122614*G0_1_0_5_1 + 0.00865373309817786*G0_1_0_5_3 + 0.00153920153920158*G0_1_0_5_4 + 0.019496552829887*G0_1_0_5_5;
    A[136] = -A[76] - 0.0365047298380645*G0_0_0_0_0 + 0.00251830474052705*G0_0_0_0_1 + 0.00606701940035294*G0_0_0_0_2 - 0.000478862701084933*G0_0_0_0_3 - 0.0125359414248307*G0_0_0_0_4 - 0.00788413232857705*G0_0_0_0_5 + 0.00251830474052705*G0_0_0_1_0 - 0.0770883437550131*G0_0_0_1_1 + 0.00482710704932943*G0_0_0_1_2 - 0.0251402918069593*G0_0_0_1_3 + 0.00124846347068574*G0_0_0_1_4 + 0.000513067179733811*G0_0_0_1_5 + 0.00606701940035294*G0_0_0_2_0 + 0.00482710704932944*G0_0_0_2_1 - 0.0375308641975321*G0_0_0_2_2 + 0.00535300090855664*G0_0_0_2_3 - 0.0104836727058953*G0_0_0_2_4 + 0.00270215381326502*G0_0_0_2_5 - 0.000478862701084933*G0_0_0_3_0 - 0.0251402918069593*G0_0_0_3_1 + 0.00535300090855664*G0_0_0_3_2 - 0.00478862701084939*G0_0_0_3_3 - 0.00153920153920159*G0_0_0_3_4 - 0.00444658222436018*G0_0_0_3_5 - 0.0125359414248307*G0_0_0_4_0 + 0.00124846347068574*G0_0_0_4_1 - 0.0104836727058953*G0_0_0_4_2 - 0.00153920153920159*G0_0_0_4_3 - 0.0348201592646048*G0_0_0_4_4 - 0.00790123456790151*G0_0_0_4_5 - 0.00788413232857705*G0_0_0_5_0 + 0.000513067179733811*G0_0_0_5_1 + 0.00270215381326502*G0_0_0_5_2 - 0.00444658222436018*G0_0_0_5_3 - 0.00790123456790151*G0_0_0_5_4 - 0.00273635829191399*G0_0_0_5_5 + 0.00102613435946772*G0_1_0_0_0 - 0.00230880230880243*G0_1_0_0_1 - 0.00318101651434996*G0_1_0_0_3 - 0.00205226871893546*G0_1_0_0_4 - 0.0132371332371337*G0_1_0_0_5 - 0.00230880230880243*G0_1_0_1_0 + 0.00230880230880237*G0_1_0_1_2 - 0.0256533589866931*G0_1_0_1_3 + 0.0256533589866934*G0_1_0_1_5 + 0.00230880230880237*G0_1_0_2_1 - 0.00102613435946776*G0_1_0_2_2 + 0.0132371332371337*G0_1_0_2_3 + 0.00205226871893545*G0_1_0_2_4 + 0.00318101651434996*G0_1_0_2_5 - 0.00318101651434996*G0_1_0_3_0 - 0.0256533589866931*G0_1_0_3_1 + 0.0132371332371337*G0_1_0_3_2 - 0.00205226871893548*G0_1_0_3_3 + 0.0063620330286999*G0_1_0_3_4 - 0.00205226871893546*G0_1_0_4_0 + 0.00205226871893544*G0_1_0_4_2 + 0.00636203302869989*G0_1_0_4_3 - 0.00636203302869993*G0_1_0_4_5 - 0.0132371332371337*G0_1_0_5_0 + 0.0256533589866934*G0_1_0_5_1 + 0.00318101651434996*G0_1_0_5_2 - 0.00636203302869993*G0_1_0_5_4 + 0.00205226871893551*G0_1_0_5_5;
    A[162] = A[187] - 0.237037037037045*G0_0_0_0_0 - 0.0052332852332854*G0_0_0_0_1 + 0.047407407407409*G0_0_0_0_2 - 0.00369408369408374*G0_0_0_0_3 - 0.168696488696494*G0_0_0_0_4 - 0.056026936026938*G0_0_0_0_5 - 0.00523328523328539*G0_0_0_1_0 + 0.0720346320346348*G0_0_0_1_1 - 0.00554112554112566*G0_0_0_1_2 + 0.129292929292934*G0_0_0_1_3 + 0.0394035594035607*G0_0_0_1_4 + 0.05787397787398*G0_0_0_1_5 + 0.047407407407409*G0_0_0_2_0 - 0.00554112554112566*G0_0_0_2_1 - 0.0591053391053415*G0_0_0_2_2 - 0.110822510822515*G0_0_0_2_3 + 0.018470418470419*G0_0_0_2_4 - 0.0190860990860998*G0_0_0_2_5 - 0.00369408369408374*G0_0_0_3_0 + 0.129292929292934*G0_0_0_3_1 - 0.110822510822515*G0_0_0_3_2 - 0.0295526695526718*G0_0_0_3_3 - 0.0714189514189539*G0_0_0_3_4 + 0.045560365560367*G0_0_0_3_5 - 0.168696488696494*G0_0_0_4_0 + 0.0394035594035607*G0_0_0_4_1 + 0.018470418470419*G0_0_0_4_2 - 0.0714189514189539*G0_0_0_4_3 - 0.0886580086580105*G0_0_0_4_4 - 0.040634920634922*G0_0_0_4_5 - 0.0560269360269379*G0_0_0_5_0 + 0.05787397787398*G0_0_0_5_1 - 0.0190860990860998*G0_0_0_5_2 + 0.045560365560367*G0_0_0_5_3 - 0.040634920634922*G0_0_0_5_4 + 0.120673400673405*G0_0_0_5_5 - 0.0363251563251575*G0_0_1_0_1 + 0.0363251563251575*G0_0_1_0_2 - 0.142530062530067*G0_0_1_0_4 + 0.142530062530068*G0_0_1_0_5 - 0.0363251563251575*G0_0_1_1_0 + 0.0683405483405506*G0_0_1_1_1 + 0.114208754208758*G0_0_1_1_3 + 0.0467917267917284*G0_0_1_1_4 - 0.0440211640211656*G0_0_1_1_5 + 0.0363251563251575*G0_0_1_2_0 - 0.068340548340551*G0_0_1_2_2 - 0.114208754208758*G0_0_1_2_3 + 0.0440211640211655*G0_0_1_2_4 - 0.0467917267917283*G0_0_1_2_5 + 0.114208754208758*G0_0_1_3_1 - 0.114208754208758*G0_0_1_3_2 - 0.0935834535834569*G0_0_1_3_4 + 0.0935834535834564*G0_0_1_3_5 - 0.142530062530067*G0_0_1_4_0 + 0.0467917267917284*G0_0_1_4_1 + 0.0440211640211655*G0_0_1_4_2 - 0.0935834535834569*G0_0_1_4_3 - 0.640307840307861*G0_0_1_4_4 + 0.142530062530068*G0_0_1_5_0 - 0.0440211640211656*G0_0_1_5_1 - 0.0467917267917283*G0_0_1_5_2 + 0.0935834535834564*G0_0_1_5_3 + 0.640307840307862*G0_0_1_5_5 - 0.0132371332371336*G0_1_0_0_1 + 0.0132371332371337*G0_1_0_0_2 + 0.0483309283309299*G0_1_0_0_4 - 0.0483309283309301*G0_1_0_0_5 - 0.0132371332371336*G0_1_0_1_0 + 0.0769600769600798*G0_1_0_1_1 + 0.136373256373261*G0_1_0_1_3 + 0.047407407407409*G0_1_0_1_4 + 0.0538720538720559*G0_1_0_1_5 + 0.0132371332371337*G0_1_0_2_0 - 0.07696007696008*G0_1_0_2_2 - 0.136373256373261*G0_1_0_2_3 - 0.0538720538720558*G0_1_0_2_4 - 0.047407407407409*G0_1_0_2_5 + 0.136373256373261*G0_1_0_3_1 - 0.136373256373261*G0_1_0_3_2 - 0.0948148148148182*G0_1_0_3_4 + 0.0948148148148178*G0_1_0_3_5 + 0.04833092833093*G0_1_0_4_0 + 0.047407407407409*G0_1_0_4_1 - 0.0538720538720558*G0_1_0_4_2 - 0.0948148148148182*G0_1_0_4_3 - 0.258585858585866*G0_1_0_4_4 - 0.0483309283309301*G0_1_0_5_0 + 0.0538720538720559*G0_1_0_5_1 - 0.047407407407409*G0_1_0_5_2 + 0.0948148148148178*G0_1_0_5_3 + 0.258585858585867*G0_1_0_5_5 + 0.237037037037045*G0_1_1_0_0 - 0.047407407407409*G0_1_1_0_1 + 0.00523328523328539*G0_1_1_0_2 + 0.0036940836940839*G0_1_1_0_3 + 0.0560269360269379*G0_1_1_0_4 + 0.168696488696495*G0_1_1_0_5 - 0.047407407407409*G0_1_1_1_0 + 0.059105339105341*G0_1_1_1_1 + 0.00554112554112579*G0_1_1_1_2 + 0.110822510822515*G0_1_1_1_3 + 0.0190860990860998*G0_1_1_1_4 - 0.0184704184704192*G0_1_1_1_5 + 0.0052332852332854*G0_1_1_2_0 + 0.00554112554112578*G0_1_1_2_1 - 0.0720346320346349*G0_1_1_2_2 - 0.129292929292934*G0_1_1_2_3 - 0.0578739778739799*G0_1_1_2_4 - 0.0394035594035607*G0_1_1_2_5 + 0.0036940836940839*G0_1_1_3_0 + 0.110822510822515*G0_1_1_3_1 - 0.129292929292934*G0_1_1_3_2 + 0.0295526695526696*G0_1_1_3_3 - 0.0455603655603675*G0_1_1_3_4 + 0.0714189514189534*G0_1_1_3_5 + 0.0560269360269379*G0_1_1_4_0 + 0.0190860990860998*G0_1_1_4_1 - 0.0578739778739799*G0_1_1_4_2 - 0.0455603655603675*G0_1_1_4_3 - 0.120673400673405*G0_1_1_4_4 + 0.0406349206349216*G0_1_1_4_5 + 0.168696488696495*G0_1_1_5_0 - 0.0184704184704192*G0_1_1_5_1 - 0.0394035594035607*G0_1_1_5_2 + 0.0714189514189534*G0_1_1_5_3 + 0.0406349206349216*G0_1_1_5_4 + 0.0886580086580107*G0_1_1_5_5;
    A[214] = A[162] + 0.171159211159217*G0_0_0_0_0 - 0.00615680615680634*G0_0_0_0_1 + 0.00277056277056284*G0_0_0_0_2 + 0.102202982202985*G0_0_0_0_3 + 0.254891774891783*G0_0_0_0_4 + 0.06772486772487*G0_0_0_0_5 - 0.00615680615680634*G0_0_0_1_0 - 0.111438191438196*G0_0_0_1_1 + 0.0575661375661396*G0_0_0_1_2 + 0.0209331409331417*G0_0_0_1_3 + 0.0147763347763353*G0_0_0_1_4 - 0.0400192400192415*G0_0_0_1_5 + 0.00277056277056284*G0_0_0_2_0 + 0.0575661375661396*G0_0_0_2_1 - 0.211794131794139*G0_0_0_2_2 - 0.148994708994715*G0_0_0_2_3 - 0.2511976911977*G0_0_0_2_4 + 0.00307840307840312*G0_0_0_2_5 + 0.102202982202985*G0_0_0_3_0 + 0.0209331409331417*G0_0_0_3_1 - 0.148994708994715*G0_0_0_3_2 - 1.5071861471862*G0_0_0_3_3 - 0.233958633958642*G0_0_0_3_4 - 0.210562770562778*G0_0_0_3_5 + 0.254891774891783*G0_0_0_4_0 + 0.0147763347763353*G0_0_0_4_1 - 0.2511976911977*G0_0_0_4_2 - 0.233958633958642*G0_0_0_4_3 - 0.128061568061572*G0_0_0_4_4 - 0.035709475709477*G0_0_0_4_5 + 0.06772486772487*G0_0_0_5_0 - 0.0400192400192415*G0_0_0_5_1 + 0.00307840307840312*G0_0_0_5_2 - 0.210562770562778*G0_0_0_5_3 - 0.035709475709477*G0_0_0_5_4 - 0.150226070226076*G0_0_0_5_5 - 0.0378643578643592*G0_0_1_0_0 + 0.0372486772486785*G0_0_1_0_1 + 0.0027705627705629*G0_0_1_0_2 + 0.0529485329485346*G0_0_1_0_3 + 0.00954304954304987*G0_0_1_0_4 - 0.142530062530068*G0_0_1_0_5 + 0.0372486772486785*G0_0_1_1_0 - 0.111438191438195*G0_0_1_1_1 + 0.0141606541606547*G0_0_1_1_2 - 0.0649543049543072*G0_0_1_1_3 + 0.0147763347763353*G0_0_1_1_4 + 0.0458682058682075*G0_0_1_1_5 + 0.00277056277056291*G0_0_1_2_0 + 0.0141606541606547*G0_0_1_2_1 - 0.0027705627705629*G0_0_1_2_2 + 0.0612602212602231*G0_0_1_2_3 - 0.00584896584896613*G0_0_1_2_4 + 0.0523328523328541*G0_0_1_2_5 + 0.0529485329485346*G0_0_1_3_0 - 0.0649543049543072*G0_0_1_3_1 + 0.0612602212602231*G0_0_1_3_2 - 0.990014430014466*G0_0_1_3_3 - 0.13544973544974*G0_0_1_3_4 - 0.210562770562778*G0_0_1_3_5 + 0.00954304954304987*G0_0_1_4_0 + 0.0147763347763353*G0_0_1_4_1 - 0.00584896584896613*G0_0_1_4_2 - 0.13544973544974*G0_0_1_4_3 - 0.128061568061573*G0_0_1_4_4 - 0.134218374218379*G0_0_1_4_5 - 0.142530062530068*G0_0_1_5_0 + 0.0458682058682075*G0_0_1_5_1 + 0.0523328523328541*G0_0_1_5_2 - 0.210562770562778*G0_0_1_5_3 - 0.134218374218379*G0_0_1_5_4 - 0.66739778739781*G0_0_1_5_5 - 0.0434054834054848*G0_1_0_0_0 + 0.0092352092352096*G0_1_0_0_1 + 0.00277056277056287*G0_1_0_0_2 + 0.0609523809523828*G0_1_0_0_3 - 0.0224723424723433*G0_1_0_0_4 + 0.0267821067821076*G0_1_0_0_5 + 0.00923520923520959*G0_1_0_1_0 - 0.111438191438196*G0_1_0_1_1 + 0.0421741221741237*G0_1_0_1_2 + 0.000307840307840437*G0_1_0_1_3 + 0.0147763347763353*G0_1_0_1_4 - 0.0193939393939402*G0_1_0_1_5 + 0.00277056277056287*G0_1_0_2_0 + 0.0421741221741237*G0_1_0_2_1 + 0.00277056277056233*G0_1_0_2_2 - 0.108051948051952*G0_1_0_2_3 + 0.026166426166427*G0_1_0_2_4 + 0.0443290043290058*G0_1_0_2_5 + 0.0609523809523828*G0_1_0_3_0 + 0.000307840307840437*G0_1_0_3_1 - 0.108051948051952*G0_1_0_3_2 - 1.29785473785478*G0_1_0_3_3 - 0.151457431457437*G0_1_0_3_4 - 0.210562770562778*G0_1_0_3_5 - 0.0224723424723433*G0_1_0_4_0 + 0.0147763347763353*G0_1_0_4_1 + 0.026166426166427*G0_1_0_4_2 - 0.151457431457437*G0_1_0_4_3 - 0.128061568061573*G0_1_0_4_4 - 0.118210678210682*G0_1_0_4_5 + 0.0267821067821076*G0_1_0_5_0 - 0.0193939393939402*G0_1_0_5_1 + 0.0443290043290058*G0_1_0_5_2 - 0.210562770562778*G0_1_0_5_3 - 0.118210678210682*G0_1_0_5_4 - 0.359557479557493*G0_1_0_5_5 - 0.0406349206349219*G0_1_1_0_0 - 0.00492544492544517*G0_1_1_0_1 + 0.00861952861952883*G0_1_1_0_3 - 0.0166233766233772*G0_1_1_0_4 - 0.0344781144781155*G0_1_1_0_5 - 0.00492544492544517*G0_1_1_1_0 + 0.00492544492544512*G0_1_1_1_2 - 0.0455603655603669*G0_1_1_1_3 + 0.0455603655603674*G0_1_1_1_5 + 0.00492544492544512*G0_1_1_2_1 + 0.0406349206349218*G0_1_1_2_2 + 0.0344781144781153*G0_1_1_2_3 + 0.0166233766233772*G0_1_1_2_4 - 0.00861952861952894*G0_1_1_2_5 + 0.00861952861952883*G0_1_1_3_0 - 0.0455603655603669*G0_1_1_3_1 + 0.0344781144781153*G0_1_1_3_2 - 0.630456950456973*G0_1_1_3_3 - 0.0172390572390579*G0_1_1_3_4 - 0.0166233766233772*G0_1_1_4_0 + 0.0166233766233772*G0_1_1_4_2 - 0.0172390572390579*G0_1_1_4_3 + 0.0172390572390578*G0_1_1_4_5 - 0.0344781144781155*G0_1_1_5_0 + 0.0455603655603674*G0_1_1_5_1 - 0.00861952861952894*G0_1_1_5_2 + 0.0172390572390578*G0_1_1_5_4 + 0.630456950456973*G0_1_1_5_5;
    A[160] = A[162] + 0.540105820105839*G0_0_0_0_0 - 0.0524867724867742*G0_0_0_0_1 - 0.0650312650312672*G0_0_0_0_2 + 0.0150072150072154*G0_0_0_0_3 + 0.316536796536807*G0_0_0_0_4 + 0.127984607984613*G0_0_0_0_5 - 0.0524867724867742*G0_0_0_1_0 + 0.271669071669081*G0_0_0_1_1 - 0.00715728715728739*G0_0_0_1_2 + 0.0530254930254947*G0_0_0_1_3 - 0.036709956709958*G0_0_0_1_4 + 0.0307070707070719*G0_0_0_1_5 - 0.0650312650312672*G0_0_0_2_0 - 0.0071572871572874*G0_0_0_2_1 + 0.0219336219336227*G0_0_0_2_2 - 0.00938912938912966*G0_0_0_2_3 - 0.0931216931216962*G0_0_0_2_4 - 0.051255411255413*G0_0_0_2_5 + 0.0150072150072154*G0_0_0_3_0 + 0.0530254930254947*G0_0_0_3_1 - 0.00938912938912966*G0_0_0_3_2 - 0.0627994227994249*G0_0_0_3_3 + 0.0434054834054848*G0_0_0_3_4 + 0.0724963924963949*G0_0_0_3_5 + 0.316536796536807*G0_0_0_4_0 - 0.036709956709958*G0_0_0_4_1 - 0.0931216931216962*G0_0_0_4_2 + 0.0434054834054848*G0_0_0_4_3 + 0.626762866762887*G0_0_0_4_4 + 0.175930735930742*G0_0_0_4_5 + 0.127984607984612*G0_0_0_5_0 + 0.0307070707070719*G0_0_0_5_1 - 0.051255411255413*G0_0_0_5_2 + 0.0724963924963949*G0_0_0_5_3 + 0.175930735930742*G0_0_0_5_4 + 0.622760942760964*G0_0_0_5_5 - 0.0365175565175575*G0_0_1_0_0 + 0.00992784992785031*G0_0_1_0_1 + 0.00942760942760974*G0_0_1_0_2 - 0.0127753727753732*G0_0_1_0_3 - 0.0288600288600298*G0_0_1_0_4 - 0.23157287157288*G0_0_1_0_5 + 0.00992784992785031*G0_0_1_1_0 + 0.28078884078885*G0_0_1_1_1 - 0.0239730639730648*G0_0_1_1_2 + 0.0831168831168859*G0_0_1_1_3 + 0.0130062530062534*G0_0_1_1_4 + 0.206868686868694*G0_0_1_1_5 + 0.00942760942760974*G0_0_1_2_0 - 0.0239730639730648*G0_0_1_2_1 + 0.00173160173160184*G0_0_1_2_2 + 0.0041558441558443*G0_0_1_2_4 + 0.0150072150072155*G0_0_1_2_5 - 0.0127753727753732*G0_0_1_3_0 + 0.0831168831168859*G0_0_1_3_1 - 0.0620298220298243*G0_0_1_3_3 - 0.000461760461760462*G0_0_1_3_4 - 0.00446368446368446*G0_0_1_3_5 - 0.0288600288600298*G0_0_1_4_0 + 0.0130062530062534*G0_0_1_4_1 + 0.0041558441558443*G0_0_1_4_2 - 0.000461760461760455*G0_0_1_4_3 + 0.0140067340067346*G0_0_1_4_4 - 0.056026936026938*G0_0_1_4_5 - 0.23157287157288*G0_0_1_5_0 + 0.206868686868694*G0_0_1_5_1 + 0.0150072150072155*G0_0_1_5_2 - 0.00446368446368449*G0_0_1_5_3 - 0.0560269360269379*G0_0_1_5_4 - 0.259971139971149*G0_0_1_5_5 - 0.0488311688311701*G0_1_0_0_0 - 0.0153150553150558*G0_1_0_0_1 + 0.00727272727272751*G0_1_0_0_2 + 0.00384800384800393*G0_1_0_0_3 - 0.0365560365560378*G0_1_0_0_4 - 0.0484078884078902*G0_1_0_0_5 - 0.0153150553150558*G0_1_0_1_0 + 0.265396825396834*G0_1_0_1_1 - 0.0212025012025019*G0_1_0_1_2 + 0.0748051948051972*G0_1_0_1_3 + 0.0210101010101017*G0_1_0_1_4 + 0.133294853294858*G0_1_0_1_5 + 0.00727272727272751*G0_1_0_2_0 - 0.0212025012025019*G0_1_0_2_1 - 0.00504088504088519*G0_1_0_2_2 + 0.0138528138528143*G0_1_0_2_3 + 0.0284752284752295*G0_1_0_2_4 + 0.0236267436267444*G0_1_0_2_5 + 0.00384800384800393*G0_1_0_3_0 + 0.0748051948051972*G0_1_0_3_1 + 0.0138528138528143*G0_1_0_3_2 - 0.133448773448778*G0_1_0_3_3 - 0.0497162097162113*G0_1_0_3_4 - 0.0549494949494967*G0_1_0_3_5 - 0.0365560365560378*G0_1_0_4_0 + 0.0210101010101017*G0_1_0_4_1 + 0.0284752284752295*G0_1_0_4_2 - 0.0497162097162114*G0_1_0_4_3 - 0.131293891293896*G0_1_0_4_4 - 0.0892736892736923*G0_1_0_4_5 - 0.0484078884078902*G0_1_0_5_0 + 0.133294853294858*G0_1_0_5_1 + 0.0236267436267444*G0_1_0_5_2 - 0.0549494949494967*G0_1_0_5_3 - 0.0892736892736923*G0_1_0_5_4 - 0.0235497835497842*G0_1_0_5_5 - 0.0205483405483412*G0_1_1_0_0 - 0.0242809042809051*G0_1_1_0_1 + 0.00419432419432432*G0_1_1_0_2 - 0.00546416546416567*G0_1_1_0_3 - 0.0102356902356906*G0_1_1_0_4 - 0.0731890331890355*G0_1_1_0_5 - 0.0242809042809051*G0_1_1_1_0 + 0.334006734006745*G0_1_1_1_1 - 0.0224338624338632*G0_1_1_1_2 + 0.0934295334295364*G0_1_1_1_3 + 0.00246272246272248*G0_1_1_1_4 + 0.120519480519485*G0_1_1_1_5 + 0.00419432419432433*G0_1_1_2_0 - 0.0224338624338632*G0_1_1_2_1 + 0.00592592592592613*G0_1_1_2_2 - 0.00915824915824946*G0_1_1_2_3 - 0.00407888407888421*G0_1_1_2_4 - 0.0497931697931716*G0_1_1_2_5 - 0.00546416546416568*G0_1_1_3_0 + 0.0934295334295364*G0_1_1_3_1 - 0.00915824915824946*G0_1_1_3_2 - 0.0547955747955769*G0_1_1_3_3 + 0.00600288600288632*G0_1_1_3_4 + 0.110514670514675*G0_1_1_3_5 - 0.0102356902356906*G0_1_1_4_0 + 0.00246272246272248*G0_1_1_4_1 - 0.00407888407888421*G0_1_1_4_2 + 0.00600288600288632*G0_1_1_4_3 + 0.0483309283309303*G0_1_1_4_4 + 0.0946608946608981*G0_1_1_4_5 - 0.0731890331890355*G0_1_1_5_0 + 0.120519480519485*G0_1_1_5_1 - 0.0497931697931716*G0_1_1_5_2 + 0.110514670514675*G0_1_1_5_3 + 0.0946608946608981*G0_1_1_5_4 + 1.26522366522371*G0_1_1_5_5;
    A[112] = A[160] - 0.323617123617135*G0_0_0_0_0 + 0.0619143819143839*G0_0_0_0_1 - 0.00665704665704682*G0_0_0_0_2 - 0.0167772967772973*G0_0_0_0_3 - 0.221029341029349*G0_0_0_0_4 - 0.0821933621933651*G0_0_0_0_5 + 0.0619143819143839*G0_0_0_1_0 - 0.337777777777789*G0_0_0_1_1 - 0.00973544973545004*G0_0_0_1_2 - 0.191476671476678*G0_0_0_1_3 - 0.0524867724867743*G0_0_0_1_4 - 0.0926599326599361*G0_0_0_1_5 - 0.00665704665704682*G0_0_0_2_0 - 0.00973544973545005*G0_0_0_2_1 + 0.371178451178463*G0_0_0_2_2 + 0.213641173641181*G0_0_0_2_3 + 0.195170755170762*G0_0_0_2_4 + 0.0728042328042354*G0_0_0_2_5 - 0.0167772967772973*G0_0_0_3_0 - 0.191476671476678*G0_0_0_3_1 + 0.213641173641181*G0_0_0_3_2 + 0.0375565175565195*G0_0_0_3_3 + 0.138528138528143*G0_0_0_3_4 - 0.112053872053876*G0_0_0_3_5 - 0.221029341029349*G0_0_0_4_0 - 0.0524867724867743*G0_0_0_4_1 + 0.195170755170762*G0_0_0_4_2 + 0.138528138528143*G0_0_0_4_3 + 0.727118807118833*G0_0_0_4_4 - 0.0406349206349218*G0_0_0_4_5 - 0.0821933621933651*G0_0_0_5_0 - 0.0926599326599361*G0_0_0_5_1 + 0.0728042328042354*G0_0_0_5_2 - 0.112053872053876*G0_0_0_5_3 - 0.0406349206349218*G0_0_0_5_4 - 0.695103415103439*G0_0_0_5_5 + 0.035824915824917*G0_0_1_0_1 - 0.035824915824917*G0_0_1_0_2 - 0.0601827801827824*G0_0_1_0_4 + 0.0601827801827822*G0_0_1_0_5 + 0.035824915824917*G0_0_1_1_0 - 0.347397787397799*G0_0_1_1_1 - 0.197325637325644*G0_0_1_1_3 - 0.0447907647907663*G0_0_1_1_4 - 0.158691678691684*G0_0_1_1_5 - 0.035824915824917*G0_0_1_2_0 + 0.347397787397798*G0_0_1_2_2 + 0.197325637325644*G0_0_1_2_3 + 0.158691678691684*G0_0_1_2_4 + 0.0447907647907664*G0_0_1_2_5 - 0.197325637325644*G0_0_1_3_1 + 0.197325637325644*G0_0_1_3_2 + 0.0895815295815329*G0_0_1_3_4 - 0.0895815295815326*G0_0_1_3_5 - 0.0601827801827824*G0_0_1_4_0 - 0.0447907647907663*G0_0_1_4_1 + 0.158691678691684*G0_0_1_4_2 + 0.0895815295815328*G0_0_1_4_3 + 0.36632996632998*G0_0_1_4_4 + 0.0601827801827822*G0_0_1_5_0 - 0.158691678691684*G0_0_1_5_1 + 0.0447907647907664*G0_0_1_5_2 - 0.0895815295815326*G0_0_1_5_3 - 0.366329966329979*G0_0_1_5_5 + 0.035824915824917*G0_1_0_0_1 - 0.035824915824917*G0_1_0_0_2 - 0.0601827801827824*G0_1_0_0_4 + 0.0601827801827822*G0_1_0_0_5 + 0.035824915824917*G0_1_0_1_0 - 0.347397787397799*G0_1_0_1_1 - 0.197325637325644*G0_1_0_1_3 - 0.0447907647907663*G0_1_0_1_4 - 0.158691678691684*G0_1_0_1_5 - 0.035824915824917*G0_1_0_2_0 + 0.347397787397798*G0_1_0_2_2 + 0.197325637325644*G0_1_0_2_3 + 0.158691678691684*G0_1_0_2_4 + 0.0447907647907664*G0_1_0_2_5 - 0.197325637325644*G0_1_0_3_1 + 0.197325637325644*G0_1_0_3_2 + 0.0895815295815329*G0_1_0_3_4 - 0.0895815295815326*G0_1_0_3_5 - 0.0601827801827824*G0_1_0_4_0 - 0.0447907647907663*G0_1_0_4_1 + 0.158691678691684*G0_1_0_4_2 + 0.0895815295815328*G0_1_0_4_3 + 0.36632996632998*G0_1_0_4_4 + 0.0601827801827822*G0_1_0_5_0 - 0.158691678691684*G0_1_0_5_1 + 0.0447907647907664*G0_1_0_5_2 - 0.0895815295815326*G0_1_0_5_3 - 0.366329966329979*G0_1_0_5_5 + 0.323617123617135*G0_1_1_0_0 + 0.00665704665704687*G0_1_1_0_1 - 0.0619143819143839*G0_1_1_0_2 + 0.0167772967772973*G0_1_1_0_3 + 0.0821933621933649*G0_1_1_0_4 + 0.221029341029348*G0_1_1_0_5 + 0.00665704665704687*G0_1_1_1_0 - 0.371178451178464*G0_1_1_1_1 + 0.00973544973545009*G0_1_1_1_2 - 0.213641173641181*G0_1_1_1_3 - 0.0728042328042352*G0_1_1_1_4 - 0.195170755170762*G0_1_1_1_5 - 0.061914381914384*G0_1_1_2_0 + 0.00973544973545009*G0_1_1_2_1 + 0.337777777777788*G0_1_1_2_2 + 0.191476671476678*G0_1_1_2_3 + 0.092659932659936*G0_1_1_2_4 + 0.0524867724867744*G0_1_1_2_5 + 0.0167772967772973*G0_1_1_3_0 - 0.213641173641181*G0_1_1_3_1 + 0.191476671476678*G0_1_1_3_2 - 0.0375565175565183*G0_1_1_3_3 + 0.112053872053876*G0_1_1_3_4 - 0.138528138528143*G0_1_1_3_5 + 0.0821933621933649*G0_1_1_4_0 - 0.0728042328042352*G0_1_1_4_1 + 0.092659932659936*G0_1_1_4_2 + 0.112053872053876*G0_1_1_4_3 + 0.695103415103439*G0_1_1_4_4 + 0.0406349206349221*G0_1_1_4_5 + 0.221029341029348*G0_1_1_5_0 - 0.195170755170762*G0_1_1_5_1 + 0.0524867724867744*G0_1_1_5_2 - 0.138528138528143*G0_1_1_5_3 + 0.0406349206349221*G0_1_1_5_4 - 0.727118807118833*G0_1_1_5_5;
    A[64] = A[160] - 0.33777777777779*G0_0_0_0_0 + 0.0619143819143839*G0_0_0_0_1 - 0.00973544973544991*G0_0_0_0_2 - 0.0524867724867741*G0_0_0_0_3 - 0.191476671476678*G0_0_0_0_4 - 0.0926599326599359*G0_0_0_0_5 + 0.0619143819143839*G0_0_0_1_0 - 0.323617123617135*G0_0_0_1_1 - 0.00665704665704685*G0_0_0_1_2 - 0.221029341029349*G0_0_0_1_3 - 0.0167772967772973*G0_0_0_1_4 - 0.0821933621933652*G0_0_0_1_5 - 0.00973544973544991*G0_0_0_2_0 - 0.00665704665704685*G0_0_0_2_1 + 0.371178451178463*G0_0_0_2_2 + 0.195170755170762*G0_0_0_2_3 + 0.213641173641181*G0_0_0_2_4 + 0.0728042328042354*G0_0_0_2_5 - 0.0524867724867741*G0_0_0_3_0 - 0.221029341029349*G0_0_0_3_1 + 0.195170755170762*G0_0_0_3_2 + 0.727118807118833*G0_0_0_3_3 + 0.138528138528143*G0_0_0_3_4 - 0.040634920634922*G0_0_0_3_5 - 0.191476671476678*G0_0_0_4_0 - 0.0167772967772973*G0_0_0_4_1 + 0.213641173641181*G0_0_0_4_2 + 0.138528138528143*G0_0_0_4_3 + 0.0375565175565188*G0_0_0_4_4 - 0.112053872053876*G0_0_0_4_5 - 0.0926599326599359*G0_0_0_5_0 - 0.0821933621933652*G0_0_0_5_1 + 0.0728042328042354*G0_0_0_5_2 - 0.040634920634922*G0_0_0_5_3 - 0.112053872053876*G0_0_0_5_4 - 0.69510341510344*G0_0_0_5_5 + 0.00962000962000972*G0_0_1_0_0 + 0.0260894660894669*G0_0_1_0_1 - 0.00973544973545005*G0_0_1_0_2 - 0.00769600769600788*G0_0_1_0_3 + 0.00584896584896602*G0_0_1_0_4 + 0.0660317460317485*G0_0_1_0_5 + 0.0260894660894669*G0_0_1_1_0 - 0.323617123617135*G0_0_1_1_1 + 0.0291678691678702*G0_0_1_1_2 - 0.160846560846566*G0_0_1_1_3 - 0.0167772967772973*G0_0_1_1_4 - 0.142376142376148*G0_0_1_1_5 - 0.00973544973545005*G0_0_1_2_0 + 0.0291678691678702*G0_0_1_2_1 + 0.0237806637806642*G0_0_1_2_2 + 0.0364790764790778*G0_0_1_2_3 + 0.0163155363155369*G0_0_1_2_4 + 0.028013468013469*G0_0_1_2_5 - 0.00769600769600788*G0_0_1_3_0 - 0.160846560846566*G0_0_1_3_1 + 0.0364790764790778*G0_0_1_3_2 + 0.360788840788854*G0_0_1_3_3 + 0.0489466089466106*G0_0_1_3_4 - 0.0406349206349221*G0_0_1_3_5 + 0.00584896584896602*G0_0_1_4_0 - 0.0167772967772973*G0_0_1_4_1 + 0.0163155363155369*G0_0_1_4_2 + 0.0489466089466106*G0_0_1_4_3 + 0.037556517556519*G0_0_1_4_4 - 0.0224723424723432*G0_0_1_4_5 + 0.0660317460317485*G0_0_1_5_0 - 0.142376142376148*G0_0_1_5_1 + 0.028013468013469*G0_0_1_5_2 - 0.0406349206349221*G0_0_1_5_3 - 0.0224723424723432*G0_0_1_5_4 - 0.328773448773461*G0_0_1_5_5 + 0.00962000962000972*G0_1_0_0_0 + 0.0260894660894669*G0_1_0_0_1 - 0.00973544973545005*G0_1_0_0_2 - 0.00769600769600788*G0_1_0_0_3 + 0.00584896584896602*G0_1_0_0_4 + 0.0660317460317485*G0_1_0_0_5 + 0.0260894660894669*G0_1_0_1_0 - 0.323617123617135*G0_1_0_1_1 + 0.0291678691678702*G0_1_0_1_2 - 0.160846560846566*G0_1_0_1_3 - 0.0167772967772973*G0_1_0_1_4 - 0.142376142376148*G0_1_0_1_5 - 0.00973544973545005*G0_1_0_2_0 + 0.0291678691678702*G0_1_0_2_1 + 0.0237806637806642*G0_1_0_2_2 + 0.0364790764790778*G0_1_0_2_3 + 0.0163155363155369*G0_1_0_2_4 + 0.028013468013469*G0_1_0_2_5 - 0.00769600769600787*G0_1_0_3_0 - 0.160846560846566*G0_1_0_3_1 + 0.0364790764790778*G0_1_0_3_2 + 0.360788840788854*G0_1_0_3_3 + 0.0489466089466106*G0_1_0_3_4 - 0.0406349206349221*G0_1_0_3_5 + 0.00584896584896602*G0_1_0_4_0 - 0.0167772967772973*G0_1_0_4_1 + 0.0163155363155369*G0_1_0_4_2 + 0.0489466089466106*G0_1_0_4_3 + 0.037556517556519*G0_1_0_4_4 - 0.0224723424723432*G0_1_0_4_5 + 0.0660317460317485*G0_1_0_5_0 - 0.142376142376148*G0_1_0_5_1 + 0.028013468013469*G0_1_0_5_2 - 0.0406349206349221*G0_1_0_5_3 - 0.0224723424723432*G0_1_0_5_4 - 0.328773448773461*G0_1_0_5_5 - 0.0141606541606546*G0_1_1_0_0 - 0.00307840307840329*G0_1_1_0_1 - 0.0357094757094768*G0_1_1_0_3 - 0.0104665704665708*G0_1_1_0_4 + 0.0295526695526705*G0_1_1_0_5 - 0.00307840307840329*G0_1_1_1_0 + 0.00307840307840308*G0_1_1_1_2 - 0.0184704184704185*G0_1_1_1_3 + 0.0184704184704195*G0_1_1_1_5 + 0.00307840307840308*G0_1_1_2_1 + 0.0141606541606546*G0_1_1_2_2 - 0.0295526695526707*G0_1_1_2_3 + 0.0104665704665708*G0_1_1_2_4 + 0.0357094757094769*G0_1_1_2_5 - 0.0357094757094768*G0_1_1_3_0 - 0.0184704184704185*G0_1_1_3_1 - 0.0295526695526707*G0_1_1_3_2 + 0.689562289562315*G0_1_1_3_3 + 0.0714189514189539*G0_1_1_3_4 - 0.0104665704665708*G0_1_1_4_0 + 0.0104665704665708*G0_1_1_4_2 + 0.0714189514189539*G0_1_1_4_3 - 0.0714189514189539*G0_1_1_4_5 + 0.0295526695526705*G0_1_1_5_0 + 0.0184704184704196*G0_1_1_5_1 + 0.0357094757094769*G0_1_1_5_2 - 0.0714189514189539*G0_1_1_5_4 - 0.689562289562314*G0_1_1_5_5;
    A[166] = -A[46] - 0.0189065255731929*G0_0_0_0_0 + 0.00528031639142771*G0_0_0_0_1 + 0.00441665330554234*G0_0_0_0_2 + 0.00410453743787091*G0_0_0_0_3 - 0.00596868152423729*G0_0_0_0_4 - 0.00162471273582389*G0_0_0_0_5 + 0.00528031639142771*G0_0_0_1_0 - 0.188680455347129*G0_0_0_1_1 + 0.0052803163914277*G0_0_0_1_2 - 0.015392015392016*G0_0_0_1_3 + 0.00572925017369482*G0_0_0_1_4 - 0.0153920153920162*G0_0_0_1_5 + 0.00441665330554234*G0_0_0_2_0 + 0.0052803163914277*G0_0_0_2_1 - 0.0189065255731929*G0_0_0_2_2 - 0.0016247127358239*G0_0_0_2_3 - 0.00596868152423727*G0_0_0_2_4 + 0.00410453743787092*G0_0_0_2_5 + 0.0041045374378709*G0_0_0_3_0 - 0.015392015392016*G0_0_0_3_1 - 0.0016247127358239*G0_0_0_3_2 - 0.0328362995029673*G0_0_0_3_3 - 0.0196675752231314*G0_0_0_3_4 - 0.0164181497514837*G0_0_0_3_5 - 0.00596868152423729*G0_0_0_4_0 + 0.00572925017369482*G0_0_0_4_1 - 0.00596868152423727*G0_0_0_4_2 - 0.0196675752231314*G0_0_0_4_3 - 0.0870846026401609*G0_0_0_4_4 - 0.0196675752231315*G0_0_0_4_5 - 0.00162471273582389*G0_0_0_5_0 - 0.0153920153920162*G0_0_0_5_1 + 0.00410453743787092*G0_0_0_5_2 - 0.0164181497514837*G0_0_0_5_3 - 0.0196675752231315*G0_0_0_5_4 - 0.0328362995029674*G0_0_0_5_5;
    A[115] = A[157] - 0.0988936988937025*G0_0_1_0_0 - 0.0071572871572874*G0_0_1_0_1 - 0.00715728715728738*G0_0_1_0_2 + 0.00354016354016369*G0_0_1_0_3 + 0.0484848484848501*G0_0_1_0_4 + 0.0484848484848501*G0_0_1_0_5 - 0.0071572871572874*G0_0_1_1_0 - 0.00084656084656093*G0_0_1_1_1 - 0.00142376142376149*G0_0_1_1_2 + 0.00461760461760481*G0_0_1_1_3 + 0.00831168831168863*G0_0_1_1_4 - 0.011544011544012*G0_0_1_1_5 - 0.00715728715728738*G0_0_1_2_0 - 0.00142376142376149*G0_0_1_2_1 - 0.000846560846560662*G0_0_1_2_2 + 0.00461760461760485*G0_0_1_2_3 - 0.0115440115440119*G0_0_1_2_4 + 0.00831168831168862*G0_0_1_2_5 + 0.00354016354016369*G0_0_1_3_0 + 0.00461760461760481*G0_0_1_3_1 + 0.00461760461760484*G0_0_1_3_2 - 0.00430976430976434*G0_0_1_3_3 - 0.0237037037037046*G0_0_1_3_4 - 0.0237037037037046*G0_0_1_3_5 + 0.0484848484848501*G0_0_1_4_0 + 0.00831168831168863*G0_0_1_4_1 - 0.0115440115440119*G0_0_1_4_2 - 0.0237037037037046*G0_0_1_4_3 + 0.0455603655603662*G0_0_1_4_4 - 0.0332467532467545*G0_0_1_4_5 + 0.0484848484848501*G0_0_1_5_0 - 0.011544011544012*G0_0_1_5_1 + 0.00831168831168861*G0_0_1_5_2 - 0.0237037037037046*G0_0_1_5_3 - 0.0332467532467545*G0_0_1_5_4 + 0.045560365560367*G0_0_1_5_5 + 0.0988936988937025*G0_1_0_0_0 + 0.0071572871572874*G0_1_0_0_1 + 0.00715728715728738*G0_1_0_0_2 - 0.00354016354016369*G0_1_0_0_3 - 0.0484848484848501*G0_1_0_0_4 - 0.0484848484848501*G0_1_0_0_5 + 0.0071572871572874*G0_1_0_1_0 + 0.000846560846560929*G0_1_0_1_1 + 0.00142376142376149*G0_1_0_1_2 - 0.00461760461760481*G0_1_0_1_3 - 0.00831168831168863*G0_1_0_1_4 + 0.011544011544012*G0_1_0_1_5 + 0.00715728715728738*G0_1_0_2_0 + 0.00142376142376149*G0_1_0_2_1 + 0.000846560846560662*G0_1_0_2_2 - 0.00461760461760485*G0_1_0_2_3 + 0.0115440115440119*G0_1_0_2_4 - 0.00831168831168861*G0_1_0_2_5 - 0.00354016354016369*G0_1_0_3_0 - 0.00461760461760481*G0_1_0_3_1 - 0.00461760461760484*G0_1_0_3_2 + 0.00430976430976433*G0_1_0_3_3 + 0.0237037037037046*G0_1_0_3_4 + 0.0237037037037046*G0_1_0_3_5 - 0.0484848484848501*G0_1_0_4_0 - 0.00831168831168863*G0_1_0_4_1 + 0.0115440115440119*G0_1_0_4_2 + 0.0237037037037046*G0_1_0_4_3 - 0.0455603655603662*G0_1_0_4_4 + 0.0332467532467545*G0_1_0_4_5 - 0.0484848484848501*G0_1_0_5_0 + 0.011544011544012*G0_1_0_5_1 - 0.00831168831168861*G0_1_0_5_2 + 0.0237037037037046*G0_1_0_5_3 + 0.0332467532467545*G0_1_0_5_4 - 0.045560365560367*G0_1_0_5_5;
    A[224] = A[208] - 0.0197017797017803*G0_0_0_0_0 + 0.0295526695526705*G0_0_0_0_1 - 0.0738816738816763*G0_0_0_0_2 + 0.0197017797017803*G0_0_0_0_3 - 0.157614237614243*G0_0_0_0_4 + 0.0394035594035607*G0_0_0_0_5 + 0.0295526695526705*G0_0_0_1_0 - 0.275824915824925*G0_0_0_1_1 - 0.0147763347763354*G0_0_0_1_2 - 0.51224627224629*G0_0_0_1_3 - 0.0197017797017804*G0_0_0_1_4 - 0.0197017797017808*G0_0_0_1_5 - 0.0738816738816763*G0_0_0_2_0 - 0.0147763347763354*G0_0_0_2_1 + 0.334930254930267*G0_0_0_2_2 + 0.591053391053413*G0_0_0_2_3 + 0.433439153439168*G0_0_0_2_4 + 0.137912457912463*G0_0_0_2_5 + 0.0197017797017803*G0_0_0_3_0 - 0.51224627224629*G0_0_0_3_1 + 0.591053391053413*G0_0_0_3_2 - 0.315228475228486*G0_0_0_3_5 - 0.157614237614243*G0_0_0_4_0 - 0.0197017797017803*G0_0_0_4_1 + 0.433439153439168*G0_0_0_4_2 + 0.630456950456972*G0_0_0_4_4 - 0.236421356421364*G0_0_0_4_5 + 0.0394035594035607*G0_0_0_5_0 - 0.0197017797017808*G0_0_0_5_1 + 0.137912457912463*G0_0_0_5_2 - 0.315228475228486*G0_0_0_5_3 - 0.236421356421364*G0_0_0_5_4 - 0.472842712842729*G0_0_0_5_5 + 0.0221645021645028*G0_0_1_0_1 - 0.0221645021645029*G0_0_1_0_2 - 0.0197017797017802*G0_0_1_0_4 + 0.0197017797017805*G0_0_1_0_5 + 0.0221645021645028*G0_0_1_1_0 - 0.177316017316023*G0_0_1_1_1 - 0.52209716209718*G0_0_1_1_3 - 0.0591053391053411*G0_0_1_1_4 - 0.0492544492544511*G0_0_1_1_5 - 0.0221645021645029*G0_0_1_2_0 + 0.177316017316024*G0_0_1_2_2 + 0.522097162097181*G0_0_1_2_3 + 0.0492544492544511*G0_0_1_2_4 + 0.0591053391053413*G0_0_1_2_5 - 0.52209716209718*G0_0_1_3_1 + 0.522097162097181*G0_0_1_3_2 + 0.118210678210682*G0_0_1_3_4 - 0.118210678210682*G0_0_1_3_5 - 0.0197017797017802*G0_0_1_4_0 - 0.0591053391053411*G0_0_1_4_1 + 0.0492544492544511*G0_0_1_4_2 + 0.118210678210682*G0_0_1_4_3 + 0.236421356421363*G0_0_1_4_4 + 0.0197017797017805*G0_0_1_5_0 - 0.0492544492544511*G0_0_1_5_1 + 0.0591053391053413*G0_0_1_5_2 - 0.118210678210682*G0_0_1_5_3 - 0.236421356421364*G0_0_1_5_5 + 0.0221645021645028*G0_1_0_0_1 - 0.0221645021645029*G0_1_0_0_2 - 0.0197017797017802*G0_1_0_0_4 + 0.0197017797017805*G0_1_0_0_5 + 0.0221645021645028*G0_1_0_1_0 - 0.177316017316023*G0_1_0_1_1 - 0.52209716209718*G0_1_0_1_3 - 0.0591053391053411*G0_1_0_1_4 - 0.0492544492544511*G0_1_0_1_5 - 0.0221645021645029*G0_1_0_2_0 + 0.177316017316024*G0_1_0_2_2 + 0.522097162097181*G0_1_0_2_3 + 0.0492544492544511*G0_1_0_2_4 + 0.0591053391053413*G0_1_0_2_5 - 0.52209716209718*G0_1_0_3_1 + 0.522097162097181*G0_1_0_3_2 + 0.118210678210682*G0_1_0_3_4 - 0.118210678210682*G0_1_0_3_5 - 0.0197017797017802*G0_1_0_4_0 - 0.0591053391053411*G0_1_0_4_1 + 0.0492544492544511*G0_1_0_4_2 + 0.118210678210682*G0_1_0_4_3 + 0.236421356421363*G0_1_0_4_4 + 0.0197017797017805*G0_1_0_5_0 - 0.0492544492544511*G0_1_0_5_1 + 0.0591053391053413*G0_1_0_5_2 - 0.118210678210682*G0_1_0_5_3 - 0.236421356421364*G0_1_0_5_5 + 0.0197017797017808*G0_1_1_0_0 + 0.0738816738816762*G0_1_1_0_1 - 0.0295526695526706*G0_1_1_0_2 - 0.0197017797017802*G0_1_1_0_3 - 0.0394035594035605*G0_1_1_0_4 + 0.157614237614244*G0_1_1_0_5 + 0.0738816738816762*G0_1_1_1_0 - 0.334930254930266*G0_1_1_1_1 + 0.0147763347763351*G0_1_1_1_2 - 0.591053391053411*G0_1_1_1_3 - 0.137912457912462*G0_1_1_1_4 - 0.433439153439169*G0_1_1_1_5 - 0.0295526695526706*G0_1_1_2_0 + 0.0147763347763351*G0_1_1_2_1 + 0.275824915824926*G0_1_1_2_2 + 0.512246272246291*G0_1_1_2_3 + 0.0197017797017806*G0_1_1_2_4 + 0.0197017797017806*G0_1_1_2_5 - 0.0197017797017802*G0_1_1_3_0 - 0.591053391053411*G0_1_1_3_1 + 0.512246272246291*G0_1_1_3_2 + 0.315228475228486*G0_1_1_3_4 - 0.0394035594035605*G0_1_1_4_0 - 0.137912457912462*G0_1_1_4_1 + 0.0197017797017806*G0_1_1_4_2 + 0.315228475228486*G0_1_1_4_3 + 0.472842712842728*G0_1_1_4_4 + 0.236421356421364*G0_1_1_4_5 + 0.157614237614244*G0_1_1_5_0 - 0.433439153439169*G0_1_1_5_1 + 0.0197017797017807*G0_1_1_5_2 + 0.236421356421364*G0_1_1_5_4 - 0.630456950456974*G0_1_1_5_5;
    A[190] = A[162] + 0.0123136123136126*G0_0_1_0_0 + 0.0252429052429061*G0_0_1_0_1 + 0.00215488215488223*G0_0_1_0_2 - 0.0166233766233772*G0_0_1_0_3 + 0.00769600769600802*G0_0_1_0_4 - 0.18316498316499*G0_0_1_0_5 + 0.0252429052429061*G0_0_1_1_0 + 0.0153920153920162*G0_0_1_1_1 - 0.00277056277056289*G0_0_1_1_2 + 0.00831168831168867*G0_0_1_1_3 - 0.00800384800384827*G0_0_1_1_4 + 0.0735738335738364*G0_0_1_1_5 + 0.00215488215488223*G0_0_1_2_0 - 0.00277056277056289*G0_0_1_2_1 + 0.00677248677248703*G0_0_1_2_2 - 0.0138528138528143*G0_0_1_2_3 - 0.0243193843193852*G0_0_1_2_4 - 0.00861952861952892*G0_0_1_2_5 - 0.0166233766233772*G0_0_1_3_0 + 0.00831168831168867*G0_0_1_3_1 - 0.0138528138528143*G0_0_1_3_2 + 0.0714189514189536*G0_0_1_3_3 + 0.0492544492544509*G0_0_1_3_4 + 0.0504858104858122*G0_0_1_3_5 + 0.00769600769600802*G0_0_1_4_0 - 0.00800384800384828*G0_0_1_4_1 - 0.0243193843193852*G0_0_1_4_2 + 0.0492544492544509*G0_0_1_4_3 + 0.145300625300631*G0_0_1_4_4 + 0.0332467532467543*G0_0_1_4_5 - 0.18316498316499*G0_0_1_5_0 + 0.0735738335738364*G0_0_1_5_1 - 0.00861952861952891*G0_0_1_5_2 + 0.0504858104858122*G0_0_1_5_3 + 0.0332467532467543*G0_0_1_5_4 - 0.236421356421364*G0_0_1_5_5 - 0.0123136123136126*G0_1_0_0_0 - 0.0252429052429061*G0_1_0_0_1 - 0.00215488215488223*G0_1_0_0_2 + 0.0166233766233772*G0_1_0_0_3 - 0.00769600769600802*G0_1_0_0_4 + 0.18316498316499*G0_1_0_0_5 - 0.0252429052429061*G0_1_0_1_0 - 0.0153920153920162*G0_1_0_1_1 + 0.00277056277056289*G0_1_0_1_2 - 0.00831168831168867*G0_1_0_1_3 + 0.00800384800384827*G0_1_0_1_4 - 0.0735738335738364*G0_1_0_1_5 - 0.00215488215488223*G0_1_0_2_0 + 0.00277056277056289*G0_1_0_2_1 - 0.00677248677248703*G0_1_0_2_2 + 0.0138528138528143*G0_1_0_2_3 + 0.0243193843193852*G0_1_0_2_4 + 0.00861952861952892*G0_1_0_2_5 + 0.0166233766233772*G0_1_0_3_0 - 0.00831168831168867*G0_1_0_3_1 + 0.0138528138528143*G0_1_0_3_2 - 0.0714189514189536*G0_1_0_3_3 - 0.0492544492544509*G0_1_0_3_4 - 0.0504858104858122*G0_1_0_3_5 - 0.00769600769600802*G0_1_0_4_0 + 0.00800384800384827*G0_1_0_4_1 + 0.0243193843193852*G0_1_0_4_2 - 0.0492544492544509*G0_1_0_4_3 - 0.145300625300631*G0_1_0_4_4 - 0.0332467532467543*G0_1_0_4_5 + 0.18316498316499*G0_1_0_5_0 - 0.0735738335738364*G0_1_0_5_1 + 0.00861952861952891*G0_1_0_5_2 - 0.0504858104858122*G0_1_0_5_3 - 0.0332467532467543*G0_1_0_5_4 + 0.236421356421365*G0_1_0_5_5;
    A[206] = -A[198] - 0.0615680615680636*G0_0_0_0_0 + 0.00800384800384827*G0_0_0_0_1 + 0.0186756453423126*G0_0_0_0_2 + 0.0492544492544509*G0_0_0_0_3 - 0.0213435946769287*G0_0_0_0_4 - 0.00656725990059345*G0_0_0_0_5 + 0.00800384800384827*G0_0_0_1_0 + 0.00820907487574177*G0_0_0_1_1 + 0.0203174603174611*G0_0_0_1_2 - 0.0985088985089023*G0_0_0_1_3 + 0.0394035594035607*G0_0_0_1_4 + 0.0186756453423126*G0_0_0_2_0 + 0.0203174603174611*G0_0_0_2_1 - 0.0627994227994251*G0_0_0_2_2 + 0.066493506493509*G0_0_0_2_3 - 0.0139554272887611*G0_0_0_2_4 + 0.0254481321147997*G0_0_0_2_5 + 0.0492544492544509*G0_0_0_3_0 - 0.0985088985089023*G0_0_0_3_1 + 0.066493506493509*G0_0_0_3_2 - 0.728965848965875*G0_0_0_3_3 - 0.177316017316023*G0_0_0_3_4 - 0.149405162738501*G0_0_0_3_5 - 0.0213435946769287*G0_0_0_4_0 + 0.0394035594035607*G0_0_0_4_1 - 0.0139554272887611*G0_0_0_4_2 - 0.177316017316023*G0_0_0_4_3 - 0.663293249959938*G0_0_0_4_4 - 0.129703383036721*G0_0_0_4_5 - 0.00656725990059345*G0_0_0_5_0 + 0.0254481321147997*G0_0_0_5_2 - 0.149405162738501*G0_0_0_5_3 - 0.129703383036721*G0_0_0_5_4 - 0.0558217091550446*G0_0_0_5_5 + 0.00123136123136142*G0_1_0_0_0 - 0.0123136123136127*G0_1_0_0_1 + 0.0238063171396513*G0_1_0_0_3 - 0.00738816738816753*G0_1_0_0_4 - 0.0730607663941021*G0_1_0_0_5 - 0.0123136123136127*G0_1_0_1_0 + 0.0123136123136128*G0_1_0_1_2 - 0.0985088985089024*G0_1_0_1_3 + 0.0985088985089017*G0_1_0_1_5 + 0.0123136123136128*G0_1_0_2_1 - 0.00123136123136155*G0_1_0_2_2 + 0.0730607663941024*G0_1_0_2_3 + 0.00738816738816751*G0_1_0_2_4 - 0.0238063171396512*G0_1_0_2_5 + 0.0238063171396513*G0_1_0_3_0 - 0.0985088985089024*G0_1_0_3_1 + 0.0730607663941024*G0_1_0_3_2 - 0.673144139810831*G0_1_0_3_3 - 0.0476126342793027*G0_1_0_3_4 - 0.00738816738816753*G0_1_0_4_0 + 0.00738816738816751*G0_1_0_4_2 - 0.0476126342793027*G0_1_0_4_3 + 0.0476126342793024*G0_1_0_4_5 - 0.0730607663941021*G0_1_0_5_0 + 0.0985088985089017*G0_1_0_5_1 - 0.0238063171396512*G0_1_0_5_2 + 0.0476126342793024*G0_1_0_5_4 + 0.67314413981083*G0_1_0_5_5;
    A[178] = A[206] - 0.00328362995029661*G0_0_1_0_0 + 0.00636203302869998*G0_0_1_0_1 + 0.000615680615680622*G0_0_1_0_2 + 0.0106717973384644*G0_0_1_0_3 - 0.0061568061568063*G0_0_1_0_4 - 0.0488439955106638*G0_0_1_0_5 + 0.00636203302869998*G0_0_1_1_0 - 0.192913259579934*G0_0_1_1_1 + 0.0186756453423127*G0_0_1_1_2 - 0.088247554914225*G0_0_1_1_3 - 0.0024627224627225*G0_0_1_1_4 + 0.010261343594677*G0_0_1_1_5 + 0.000615680615680622*G0_0_1_2_0 + 0.0186756453423127*G0_0_1_2_1 - 0.00451499118165805*G0_0_1_2_2 + 0.0242167708834385*G0_0_1_2_3 + 0.00123136123136129*G0_0_1_2_4 - 0.0131345198011869*G0_0_1_2_5 + 0.0106717973384644*G0_0_1_3_0 - 0.088247554914225*G0_0_1_3_1 + 0.0242167708834385*G0_0_1_3_2 - 0.160897867564541*G0_0_1_3_3 - 0.0164181497514838*G0_0_1_3_4 + 0.00492544492544474*G0_0_1_3_5 - 0.0061568061568063*G0_0_1_4_0 - 0.0024627224627225*G0_0_1_4_1 + 0.00123136123136129*G0_0_1_4_2 - 0.0164181497514838*G0_0_1_4_3 - 0.0164181497514839*G0_0_1_4_4 + 0.0311944845278187*G0_0_1_4_5 - 0.0488439955106638*G0_0_1_5_0 + 0.010261343594677*G0_0_1_5_1 - 0.0131345198011869*G0_0_1_5_2 + 0.00492544492544474*G0_0_1_5_3 + 0.0311944845278187*G0_0_1_5_4 + 0.51224627224629*G0_0_1_5_5 + 0.00328362995029661*G0_1_0_0_0 - 0.00636203302869998*G0_1_0_0_1 - 0.000615680615680622*G0_1_0_0_2 - 0.0106717973384644*G0_1_0_0_3 + 0.0061568061568063*G0_1_0_0_4 + 0.0488439955106638*G0_1_0_0_5 - 0.00636203302869998*G0_1_0_1_0 + 0.192913259579934*G0_1_0_1_1 - 0.0186756453423127*G0_1_0_1_2 + 0.088247554914225*G0_1_0_1_3 + 0.0024627224627225*G0_1_0_1_4 - 0.010261343594677*G0_1_0_1_5 - 0.000615680615680622*G0_1_0_2_0 - 0.0186756453423127*G0_1_0_2_1 + 0.00451499118165805*G0_1_0_2_2 - 0.0242167708834385*G0_1_0_2_3 - 0.00123136123136129*G0_1_0_2_4 + 0.0131345198011868*G0_1_0_2_5 - 0.0106717973384644*G0_1_0_3_0 + 0.088247554914225*G0_1_0_3_1 - 0.0242167708834385*G0_1_0_3_2 + 0.160897867564541*G0_1_0_3_3 + 0.0164181497514838*G0_1_0_3_4 - 0.00492544492544474*G0_1_0_3_5 + 0.0061568061568063*G0_1_0_4_0 + 0.0024627224627225*G0_1_0_4_1 - 0.00123136123136129*G0_1_0_4_2 + 0.0164181497514838*G0_1_0_4_3 + 0.0164181497514839*G0_1_0_4_4 - 0.0311944845278187*G0_1_0_4_5 + 0.0488439955106638*G0_1_0_5_0 - 0.010261343594677*G0_1_0_5_1 + 0.0131345198011869*G0_1_0_5_2 - 0.00492544492544474*G0_1_0_5_3 - 0.0311944845278187*G0_1_0_5_4 - 0.51224627224629*G0_1_0_5_5;
    A[0] = A[16] + 0.16430976430977*G0_0_0_0_0 - 0.00892523114745369*G0_0_0_0_2 + 0.00389075944631512*G0_0_0_0_3 + 0.0366415477526602*G0_0_0_0_4 + 0.0414729303618208*G0_0_0_0_5 - 0.16430976430977*G0_0_0_1_1 + 0.00892523114745369*G0_0_0_1_2 - 0.0366415477526602*G0_0_0_1_3 - 0.00389075944631512*G0_0_0_1_4 - 0.0414729303618209*G0_0_0_1_5 - 0.00892523114745369*G0_0_0_2_0 + 0.00892523114745369*G0_0_0_2_1 + 0.00483138260916056*G0_0_0_2_3 - 0.00483138260916055*G0_0_0_2_4 + 0.00389075944631512*G0_0_0_3_0 - 0.0366415477526602*G0_0_0_3_1 + 0.00483138260916056*G0_0_0_3_2 - 0.00803805248249723*G0_0_0_3_3 - 0.00778151889263032*G0_0_0_3_5 + 0.0366415477526602*G0_0_0_4_0 - 0.00389075944631512*G0_0_0_4_1 - 0.00483138260916055*G0_0_0_4_2 + 0.00803805248249725*G0_0_0_4_4 + 0.00778151889263029*G0_0_0_4_5 + 0.0414729303618208*G0_0_0_5_0 - 0.0414729303618209*G0_0_0_5_1 - 0.00778151889263032*G0_0_0_5_3 + 0.00778151889263029*G0_0_0_5_4 + 0.168726952060291*G0_0_1_0_0 - 0.00916973972529559*G0_0_1_0_1 - 0.0091697397252956*G0_0_1_0_2 + 0.000903212014323139*G0_0_1_0_3 + 0.0375821709155056*G0_0_1_0_4 + 0.0375821709155056*G0_0_1_0_5 - 0.00916973972529559*G0_0_1_1_0 + 0.0044171877505212*G0_0_1_1_1 - 0.000244508577841916*G0_0_1_1_2 + 0.000940623162845404*G0_0_1_1_3 - 0.00298754743199198*G0_0_1_1_4 - 0.00389075944631516*G0_0_1_1_5 - 0.0091697397252956*G0_0_1_2_0 - 0.000244508577841916*G0_0_1_2_1 + 0.00441718775052124*G0_0_1_2_2 + 0.000940623162845423*G0_0_1_2_3 - 0.00389075944631513*G0_0_1_2_4 - 0.00298754743199198*G0_0_1_2_5 + 0.000903212014323139*G0_0_1_3_0 + 0.000940623162845403*G0_0_1_3_1 + 0.000940623162845423*G0_0_1_3_2 + 0.0158623269734386*G0_0_1_3_3 + 0.00416867083533764*G0_0_1_3_4 + 0.00416867083533764*G0_0_1_3_5 + 0.0375821709155056*G0_0_1_4_0 - 0.00298754743199198*G0_0_1_4_1 - 0.00389075944631513*G0_0_1_4_2 + 0.00416867083533764*G0_0_1_4_3 + 0.0239003794559358*G0_0_1_4_4 + 0.0119501897279679*G0_0_1_4_5 + 0.0375821709155056*G0_0_1_5_0 - 0.00389075944631516*G0_0_1_5_1 - 0.00298754743199198*G0_0_1_5_2 + 0.00416867083533764*G0_0_1_5_3 + 0.0119501897279679*G0_0_1_5_4 + 0.0239003794559359*G0_0_1_5_5 + 0.168726952060291*G0_1_0_0_0 - 0.00916973972529559*G0_1_0_0_1 - 0.0091697397252956*G0_1_0_0_2 + 0.000903212014323139*G0_1_0_0_3 + 0.0375821709155056*G0_1_0_0_4 + 0.0375821709155056*G0_1_0_0_5 - 0.00916973972529559*G0_1_0_1_0 + 0.0044171877505212*G0_1_0_1_1 - 0.000244508577841916*G0_1_0_1_2 + 0.000940623162845404*G0_1_0_1_3 - 0.00298754743199198*G0_1_0_1_4 - 0.00389075944631516*G0_1_0_1_5 - 0.0091697397252956*G0_1_0_2_0 - 0.000244508577841916*G0_1_0_2_1 + 0.00441718775052124*G0_1_0_2_2 + 0.000940623162845423*G0_1_0_2_3 - 0.00389075944631513*G0_1_0_2_4 - 0.00298754743199198*G0_1_0_2_5 + 0.000903212014323139*G0_1_0_3_0 + 0.000940623162845403*G0_1_0_3_1 + 0.000940623162845423*G0_1_0_3_2 + 0.0158623269734386*G0_1_0_3_3 + 0.00416867083533764*G0_1_0_3_4 + 0.00416867083533764*G0_1_0_3_5 + 0.0375821709155056*G0_1_0_4_0 - 0.00298754743199198*G0_1_0_4_1 - 0.00389075944631513*G0_1_0_4_2 + 0.00416867083533764*G0_1_0_4_3 + 0.0239003794559358*G0_1_0_4_4 + 0.0119501897279679*G0_1_0_4_5 + 0.0375821709155056*G0_1_0_5_0 - 0.00389075944631516*G0_1_0_5_1 - 0.00298754743199198*G0_1_0_5_2 + 0.00416867083533764*G0_1_0_5_3 + 0.0119501897279679*G0_1_0_5_4 + 0.0239003794559359*G0_1_0_5_5 + 0.168726952060291*G0_1_1_0_0 - 0.00916973972529559*G0_1_1_0_1 - 0.0091697397252956*G0_1_1_0_2 + 0.000903212014323138*G0_1_1_0_3 + 0.0375821709155055*G0_1_1_0_4 + 0.0375821709155056*G0_1_1_0_5 - 0.00916973972529559*G0_1_1_1_0 + 0.00441718775052122*G0_1_1_1_1 - 0.000244508577841918*G0_1_1_1_2 + 0.000940623162845407*G0_1_1_1_3 - 0.00298754743199198*G0_1_1_1_4 - 0.00389075944631514*G0_1_1_1_5 - 0.0091697397252956*G0_1_1_2_0 - 0.000244508577841918*G0_1_1_2_1 + 0.00441718775052125*G0_1_1_2_2 + 0.000940623162845425*G0_1_1_2_3 - 0.00389075944631513*G0_1_1_2_4 - 0.00298754743199198*G0_1_1_2_5 + 0.000903212014323138*G0_1_1_3_0 + 0.000940623162845407*G0_1_1_3_1 + 0.000940623162845425*G0_1_1_3_2 + 0.0158623269734386*G0_1_1_3_3 + 0.00416867083533764*G0_1_1_3_4 + 0.00416867083533764*G0_1_1_3_5 + 0.0375821709155055*G0_1_1_4_0 - 0.00298754743199198*G0_1_1_4_1 - 0.00389075944631513*G0_1_1_4_2 + 0.00416867083533764*G0_1_1_4_3 + 0.0239003794559358*G0_1_1_4_4 + 0.0119501897279679*G0_1_1_4_5 + 0.0375821709155056*G0_1_1_5_0 - 0.00389075944631514*G0_1_1_5_1 - 0.00298754743199198*G0_1_1_5_2 + 0.00416867083533764*G0_1_1_5_3 + 0.0119501897279679*G0_1_1_5_4 + 0.0239003794559359*G0_1_1_5_5;
    A[58] = -A[178] - 0.0615680615680636*G0_0_0_0_0 + 0.00800384800384827*G0_0_0_0_1 + 0.0186756453423126*G0_0_0_0_2 + 0.0492544492544509*G0_0_0_0_3 - 0.0213435946769288*G0_0_0_0_4 - 0.00656725990059346*G0_0_0_0_5 + 0.00800384800384827*G0_0_0_1_0 + 0.00820907487574177*G0_0_0_1_1 + 0.0203174603174611*G0_0_0_1_2 - 0.0985088985089023*G0_0_0_1_3 + 0.0394035594035607*G0_0_0_1_4 + 0.0186756453423126*G0_0_0_2_0 + 0.0203174603174611*G0_0_0_2_1 - 0.0627994227994251*G0_0_0_2_2 + 0.066493506493509*G0_0_0_2_3 - 0.0139554272887611*G0_0_0_2_4 + 0.0254481321147997*G0_0_0_2_5 + 0.0492544492544509*G0_0_0_3_0 - 0.0985088985089023*G0_0_0_3_1 + 0.066493506493509*G0_0_0_3_2 - 0.728965848965875*G0_0_0_3_3 - 0.177316017316023*G0_0_0_3_4 - 0.149405162738501*G0_0_0_3_5 - 0.0213435946769288*G0_0_0_4_0 + 0.0394035594035607*G0_0_0_4_1 - 0.0139554272887611*G0_0_0_4_2 - 0.177316017316023*G0_0_0_4_3 - 0.663293249959938*G0_0_0_4_4 - 0.129703383036721*G0_0_0_4_5 - 0.00656725990059345*G0_0_0_5_0 + 0.0254481321147997*G0_0_0_5_2 - 0.149405162738501*G0_0_0_5_3 - 0.129703383036721*G0_0_0_5_4 - 0.0558217091550445*G0_0_0_5_5 + 0.00123136123136142*G0_0_1_0_0 - 0.0123136123136127*G0_0_1_0_1 + 0.0238063171396513*G0_0_1_0_3 - 0.00738816738816753*G0_0_1_0_4 - 0.0730607663941021*G0_0_1_0_5 - 0.0123136123136127*G0_0_1_1_0 + 0.0123136123136128*G0_0_1_1_2 - 0.0985088985089024*G0_0_1_1_3 + 0.0985088985089017*G0_0_1_1_5 + 0.0123136123136128*G0_0_1_2_1 - 0.00123136123136155*G0_0_1_2_2 + 0.0730607663941024*G0_0_1_2_3 + 0.00738816738816751*G0_0_1_2_4 - 0.0238063171396512*G0_0_1_2_5 + 0.0238063171396513*G0_0_1_3_0 - 0.0985088985089024*G0_0_1_3_1 + 0.0730607663941024*G0_0_1_3_2 - 0.673144139810831*G0_0_1_3_3 - 0.0476126342793027*G0_0_1_3_4 - 0.00738816738816753*G0_0_1_4_0 + 0.00738816738816751*G0_0_1_4_2 - 0.0476126342793027*G0_0_1_4_3 + 0.0476126342793024*G0_0_1_4_5 - 0.0730607663941021*G0_0_1_5_0 + 0.0985088985089017*G0_0_1_5_1 - 0.0238063171396512*G0_0_1_5_2 + 0.0476126342793024*G0_0_1_5_4 + 0.67314413981083*G0_0_1_5_5;
    A[131] = -A[86] + 0.0143658810325483*G0_1_0_0_0 + 0.00280476724921183*G0_1_0_0_1 + 0.000684089572978482*G0_1_0_0_2 + 0.00738816738816764*G0_1_0_0_3 - 0.00766180321735896*G0_1_0_0_4 - 0.019838597616376*G0_1_0_0_5 + 0.00280476724921183*G0_1_0_1_0 - 0.114106140772813*G0_1_0_1_1 + 0.0017786328897441*G0_1_0_1_2 + 0.00574635241301914*G0_1_0_1_3 + 0.000547271658382813*G0_1_0_1_4 + 0.0061568061568061*G0_1_0_1_5 + 0.00068408957297848*G0_1_0_2_0 + 0.0017786328897441*G0_1_0_2_1 - 0.0054727165838279*G0_1_0_2_3 + 0.00547271658382784*G0_1_0_2_4 - 0.00246272246272256*G0_1_0_2_5 + 0.00738816738816764*G0_1_0_3_0 + 0.00574635241301914*G0_1_0_3_1 - 0.0054727165838279*G0_1_0_3_2 - 0.0158708780931009*G0_1_0_3_4 - 0.00985088985089017*G0_1_0_3_5 - 0.00766180321735897*G0_1_0_4_0 + 0.000547271658382813*G0_1_0_4_1 + 0.00547271658382784*G0_1_0_4_2 - 0.0158708780931009*G0_1_0_4_3 + 0.0317417561862018*G0_1_0_4_4 + 0.00383090160867952*G0_1_0_4_5 - 0.019838597616376*G0_1_0_5_0 + 0.0061568061568061*G0_1_0_5_1 - 0.00246272246272256*G0_1_0_5_2 - 0.00985088985089016*G0_1_0_5_3 + 0.00383090160867952*G0_1_0_5_4 + 0.121494308160979*G0_1_0_5_5 - 0.00574635241301937*G0_1_1_0_0 + 0.0160076960076967*G0_1_1_0_1 + 0.000752498530276326*G0_1_1_0_2 - 0.00177863288974404*G0_1_1_0_3 + 0.00424135535246658*G0_1_1_0_4 + 0.0158708780931009*G0_1_1_0_5 + 0.0160076960076967*G0_1_1_1_0 - 0.192913259579935*G0_1_1_1_1 + 0.000684089572978537*G0_1_1_1_2 + 0.00643044198599756*G0_1_1_1_3 + 0.00177863288974407*G0_1_1_1_4 - 0.0803121158676748*G0_1_1_1_5 + 0.000752498530276326*G0_1_1_2_0 + 0.000684089572978537*G0_1_1_2_1 + 0.00410453743787088*G0_1_1_2_2 - 0.0109454331676558*G0_1_1_2_3 - 0.00547271658382786*G0_1_1_2_4 - 0.000410453743787046*G0_1_1_2_5 - 0.00177863288974404*G0_1_1_3_0 + 0.00643044198599757*G0_1_1_3_1 - 0.0109454331676558*G0_1_1_3_2 + 0.0651253273475519*G0_1_1_3_3 + 0.00437817326706219*G0_1_1_3_5 + 0.00424135535246658*G0_1_1_4_0 + 0.00177863288974407*G0_1_1_4_1 - 0.00547271658382786*G0_1_1_4_2 - 0.0158708780931008*G0_1_1_4_4 - 0.00273635829191398*G0_1_1_4_5 + 0.0158708780931009*G0_1_1_5_0 - 0.0803121158676748*G0_1_1_5_1 - 0.000410453743787047*G0_1_1_5_2 + 0.00437817326706219*G0_1_1_5_3 - 0.00273635829191398*G0_1_1_5_4 - 0.0902998236331606*G0_1_1_5_5;
    A[74] = A[214] + 0.00677248677248694*G0_0_1_0_0 - 0.00277056277056284*G0_0_1_0_1 + 0.0021548821548822*G0_0_1_0_2 - 0.00861952861952894*G0_0_1_0_3 - 0.0243193843193851*G0_0_1_0_4 - 0.0138528138528143*G0_0_1_0_5 - 0.00277056277056284*G0_0_1_1_0 + 0.0153920153920161*G0_0_1_1_1 + 0.0252429052429061*G0_0_1_1_2 + 0.0735738335738363*G0_0_1_1_3 - 0.00800384800384827*G0_0_1_1_4 + 0.00831168831168866*G0_0_1_1_5 + 0.0021548821548822*G0_0_1_2_0 + 0.0252429052429061*G0_0_1_2_1 + 0.0123136123136123*G0_0_1_2_2 - 0.18316498316499*G0_0_1_2_3 + 0.00769600769600795*G0_0_1_2_4 - 0.0166233766233772*G0_0_1_2_5 - 0.00861952861952894*G0_0_1_3_0 + 0.0735738335738363*G0_0_1_3_1 - 0.18316498316499*G0_0_1_3_2 - 0.236421356421364*G0_0_1_3_3 + 0.0332467532467542*G0_0_1_3_4 + 0.050485810485812*G0_0_1_3_5 - 0.0243193843193851*G0_0_1_4_0 - 0.00800384800384827*G0_0_1_4_1 + 0.00769600769600795*G0_0_1_4_2 + 0.0332467532467543*G0_0_1_4_3 + 0.145300625300631*G0_0_1_4_4 + 0.0492544492544509*G0_0_1_4_5 - 0.0138528138528143*G0_0_1_5_0 + 0.00831168831168866*G0_0_1_5_1 - 0.0166233766233772*G0_0_1_5_2 + 0.050485810485812*G0_0_1_5_3 + 0.0492544492544509*G0_0_1_5_4 + 0.0714189514189529*G0_0_1_5_5 - 0.00677248677248694*G0_1_0_0_0 + 0.00277056277056284*G0_1_0_0_1 - 0.0021548821548822*G0_1_0_0_2 + 0.00861952861952893*G0_1_0_0_3 + 0.0243193843193851*G0_1_0_0_4 + 0.0138528138528143*G0_1_0_0_5 + 0.00277056277056284*G0_1_0_1_0 - 0.0153920153920161*G0_1_0_1_1 - 0.0252429052429061*G0_1_0_1_2 - 0.0735738335738363*G0_1_0_1_3 + 0.00800384800384827*G0_1_0_1_4 - 0.00831168831168866*G0_1_0_1_5 - 0.0021548821548822*G0_1_0_2_0 - 0.0252429052429061*G0_1_0_2_1 - 0.0123136123136123*G0_1_0_2_2 + 0.18316498316499*G0_1_0_2_3 - 0.00769600769600794*G0_1_0_2_4 + 0.0166233766233772*G0_1_0_2_5 + 0.00861952861952894*G0_1_0_3_0 - 0.0735738335738363*G0_1_0_3_1 + 0.18316498316499*G0_1_0_3_2 + 0.236421356421364*G0_1_0_3_3 - 0.0332467532467542*G0_1_0_3_4 - 0.050485810485812*G0_1_0_3_5 + 0.0243193843193851*G0_1_0_4_0 + 0.00800384800384827*G0_1_0_4_1 - 0.00769600769600794*G0_1_0_4_2 - 0.0332467532467542*G0_1_0_4_3 - 0.145300625300631*G0_1_0_4_4 - 0.0492544492544509*G0_1_0_4_5 + 0.0138528138528143*G0_1_0_5_0 - 0.00831168831168866*G0_1_0_5_1 + 0.0166233766233772*G0_1_0_5_2 - 0.050485810485812*G0_1_0_5_3 - 0.0492544492544509*G0_1_0_5_4 - 0.0714189514189529*G0_1_0_5_5;
    A[199] = A[74] + 0.0252429052429061*G0_0_0_0_0 + 0.0113900913900917*G0_0_0_0_1 - 0.0551034151034169*G0_0_0_0_2 - 0.0898893698893727*G0_0_0_0_3 - 0.120673400673405*G0_0_0_0_4 - 0.0283213083213092*G0_0_0_0_5 + 0.0113900913900917*G0_0_0_1_0 + 0.0800384800384828*G0_0_0_1_1 - 0.0470995670995688*G0_0_0_1_2 - 0.11574795574796*G0_0_0_1_3 - 0.0627994227994248*G0_0_0_1_4 - 0.0012313612313612*G0_0_0_1_5 - 0.0551034151034169*G0_0_0_2_0 - 0.0470995670995688*G0_0_0_2_1 + 0.27089947089948*G0_0_0_2_2 + 0.214256854256862*G0_0_0_2_3 + 0.278287638287648*G0_0_0_2_4 + 0.0160076960076966*G0_0_0_2_5 - 0.0898893698893727*G0_0_0_3_0 - 0.11574795574796*G0_0_0_3_1 + 0.214256854256862*G0_0_0_3_2 + 0.906281866281898*G0_0_0_3_3 + 0.305377585377595*G0_0_0_3_4 + 0.147763347763353*G0_0_0_3_5 - 0.120673400673405*G0_0_0_4_0 - 0.0627994227994248*G0_0_0_4_1 + 0.278287638287648*G0_0_0_4_2 + 0.305377585377595*G0_0_0_4_3 + 0.847176527176555*G0_0_0_4_4 + 0.0935834535834567*G0_0_0_4_5 - 0.0283213083213092*G0_0_0_5_0 - 0.0012313612313612*G0_0_0_5_1 + 0.0160076960076966*G0_0_0_5_2 + 0.147763347763353*G0_0_0_5_3 + 0.0935834535834567*G0_0_0_5_4 + 0.0295526695526706*G0_0_0_5_5 + 0.00677248677248692*G0_0_1_0_1 - 0.00677248677248702*G0_0_1_0_2 + 0.000923520923521*G0_0_1_0_4 - 0.0009235209235209*G0_0_1_0_5 + 0.00677248677248692*G0_0_1_1_0 + 0.0372486772486788*G0_0_1_1_1 - 0.244733044733053*G0_0_1_1_3 - 0.0178547378547385*G0_0_1_1_4 - 0.00831168831168848*G0_0_1_1_5 - 0.00677248677248702*G0_0_1_2_0 - 0.0372486772486779*G0_0_1_2_2 + 0.244733044733054*G0_0_1_2_3 + 0.00831168831168875*G0_0_1_2_4 + 0.0178547378547385*G0_0_1_2_5 - 0.244733044733053*G0_0_1_3_1 + 0.244733044733054*G0_0_1_3_2 + 0.0357094757094771*G0_0_1_3_4 - 0.0357094757094769*G0_0_1_3_5 + 0.000923520923520999*G0_0_1_4_0 - 0.0178547378547385*G0_0_1_4_1 + 0.00831168831168875*G0_0_1_4_2 + 0.0357094757094771*G0_0_1_4_3 + 0.0270899470899485*G0_0_1_4_4 - 0.0009235209235209*G0_0_1_5_0 - 0.00831168831168848*G0_0_1_5_1 + 0.0178547378547385*G0_0_1_5_2 - 0.0357094757094769*G0_0_1_5_3 - 0.0270899470899472*G0_0_1_5_5 + 0.00184704184704185*G0_1_0_0_1 - 0.00184704184704197*G0_1_0_0_2 - 0.00954304954304995*G0_1_0_0_4 + 0.00954304954304977*G0_1_0_0_5 + 0.00184704184704185*G0_1_0_1_0 + 0.0403270803270821*G0_1_0_1_1 + 0.0120057720057726*G0_1_0_1_3 - 0.00923520923520958*G0_1_0_1_4 - 0.00769600769600767*G0_1_0_1_5 - 0.00184704184704197*G0_1_0_2_0 - 0.040327080327081*G0_1_0_2_2 - 0.0120057720057723*G0_1_0_2_3 + 0.00769600769600826*G0_1_0_2_4 + 0.00923520923520951*G0_1_0_2_5 + 0.0120057720057726*G0_1_0_3_1 - 0.0120057720057723*G0_1_0_3_2 + 0.0184704184704193*G0_1_0_3_4 - 0.0184704184704188*G0_1_0_3_5 - 0.00954304954304996*G0_1_0_4_0 - 0.00923520923520958*G0_1_0_4_1 + 0.00769600769600827*G0_1_0_4_2 + 0.0184704184704193*G0_1_0_4_3 + 0.100971620971626*G0_1_0_4_4 + 0.00954304954304977*G0_1_0_5_0 - 0.00769600769600767*G0_1_0_5_1 + 0.00923520923520951*G0_1_0_5_2 - 0.0184704184704188*G0_1_0_5_3 - 0.100971620971624*G0_1_0_5_5 - 0.025242905242906*G0_1_1_0_0 + 0.055103415103417*G0_1_1_0_1 - 0.0113900913900918*G0_1_1_0_2 + 0.0898893698893728*G0_1_1_0_3 + 0.0283213083213092*G0_1_1_0_4 + 0.120673400673405*G0_1_1_0_5 + 0.055103415103417*G0_1_1_1_0 - 0.270899470899481*G0_1_1_1_1 + 0.0470995670995687*G0_1_1_1_2 - 0.214256854256862*G0_1_1_1_3 - 0.0160076960076966*G0_1_1_1_4 - 0.278287638287649*G0_1_1_1_5 - 0.0113900913900918*G0_1_1_2_0 + 0.0470995670995687*G0_1_1_2_1 - 0.0800384800384824*G0_1_1_2_2 + 0.11574795574796*G0_1_1_2_3 + 0.00123136123136132*G0_1_1_2_4 + 0.062799422799425*G0_1_1_2_5 + 0.0898893698893728*G0_1_1_3_0 - 0.214256854256862*G0_1_1_3_1 + 0.11574795574796*G0_1_1_3_2 - 0.906281866281897*G0_1_1_3_3 - 0.147763347763353*G0_1_1_3_4 - 0.305377585377596*G0_1_1_3_5 + 0.0283213083213092*G0_1_1_4_0 - 0.0160076960076966*G0_1_1_4_1 + 0.00123136123136132*G0_1_1_4_2 - 0.147763347763353*G0_1_1_4_3 - 0.0295526695526702*G0_1_1_4_4 - 0.0935834535834565*G0_1_1_4_5 + 0.120673400673405*G0_1_1_5_0 - 0.278287638287649*G0_1_1_5_1 + 0.062799422799425*G0_1_1_5_2 - 0.305377585377596*G0_1_1_5_3 - 0.0935834535834565*G0_1_1_5_4 - 0.847176527176556*G0_1_1_5_5;
    A[202] = -A[199] - 0.0012313612313613*G0_0_0_0_1 - 0.0258585858585867*G0_0_0_0_2 - 0.0541798941798959*G0_0_0_0_4 - 0.0012313612313613*G0_0_0_1_0 + 0.0492544492544509*G0_0_0_1_1 - 0.0160076960076965*G0_0_0_1_2 + 0.00492544492544523*G0_0_0_1_3 - 0.0197017797017803*G0_0_0_1_4 + 0.00985088985089028*G0_0_0_1_5 - 0.0258585858585867*G0_0_0_2_0 - 0.0160076960076965*G0_0_0_2_1 + 0.110822510822515*G0_0_0_2_2 + 0.0591053391053409*G0_0_0_2_3 + 0.137912457912463*G0_0_0_2_4 + 0.00492544492544511*G0_0_0_2_5 + 0.00492544492544523*G0_0_0_3_1 + 0.0591053391053409*G0_0_0_3_2 - 0.47284271284273*G0_0_0_3_3 + 0.0394035594035605*G0_0_0_3_4 - 0.00985088985089033*G0_0_0_3_5 - 0.0541798941798959*G0_0_0_4_0 - 0.0197017797017803*G0_0_0_4_1 + 0.137912457912463*G0_0_0_4_2 + 0.0394035594035605*G0_0_0_4_3 + 0.788071188071215*G0_0_0_4_4 + 0.0295526695526705*G0_0_0_4_5 + 0.00985088985089028*G0_0_0_5_1 + 0.00492544492544511*G0_0_0_5_2 - 0.00985088985089033*G0_0_0_5_3 + 0.0295526695526705*G0_0_0_5_4 + 0.0197017797017804*G0_0_0_5_5 - 0.018470418470419*G0_0_1_0_0 + 0.00307840307840311*G0_0_1_0_1 - 0.000923520923520987*G0_0_1_0_2 + 0.0412506012506026*G0_0_1_0_3 - 0.0818855218855246*G0_0_1_0_4 - 0.00738816738816749*G0_0_1_0_5 + 0.00307840307840311*G0_0_1_1_0 + 0.0209331409331419*G0_0_1_1_1 + 0.0255507455507465*G0_0_1_1_2 - 0.152073112073117*G0_0_1_1_3 - 0.00923520923520952*G0_0_1_1_4 - 0.0135449735449738*G0_0_1_1_5 - 0.000923520923520987*G0_0_1_2_0 + 0.0255507455507465*G0_0_1_2_1 + 0.0332467532467541*G0_0_1_2_2 + 0.0911207311207343*G0_0_1_2_3 + 0.076344396344399*G0_0_1_2_4 - 0.00861952861952882*G0_0_1_2_5 + 0.0412506012506026*G0_0_1_3_0 - 0.152073112073117*G0_0_1_3_1 + 0.0911207311207343*G0_0_1_3_2 - 1.05650793650797*G0_0_1_3_3 - 0.0640307840307864*G0_0_1_3_4 - 0.0652621452621479*G0_0_1_3_5 - 0.0818855218855246*G0_0_1_4_0 - 0.00923520923520952*G0_0_1_4_1 + 0.076344396344399*G0_0_1_4_2 - 0.0640307840307864*G0_0_1_4_3 + 0.00246272246272349*G0_0_1_4_4 + 0.0357094757094768*G0_0_1_4_5 - 0.00738816738816749*G0_0_1_5_0 - 0.0135449735449738*G0_0_1_5_1 - 0.00861952861952883*G0_0_1_5_2 - 0.0652621452621479*G0_0_1_5_3 + 0.0357094757094768*G0_0_1_5_4 + 0.059105339105341*G0_0_1_5_5 - 0.0160076960076965*G0_1_0_0_0 + 0.00184704184704191*G0_1_0_0_1 + 0.00184704184704187*G0_1_0_0_2 + 0.0418662818662831*G0_1_0_0_3 + 0.0123136123136126*G0_1_0_0_4 + 0.0123136123136127*G0_1_0_0_5 + 0.00184704184704191*G0_1_0_1_0 + 0.00861952861952878*G0_1_0_1_1 - 0.00061568061568059*G0_1_0_1_2 + 0.0221645021645029*G0_1_0_1_3 + 0.00738816738816762*G0_1_0_1_4 - 0.0123136123136127*G0_1_0_1_5 + 0.00184704184704187*G0_1_0_2_0 - 0.00061568061568059*G0_1_0_2_1 + 0.00861952861952902*G0_1_0_2_2 + 0.0221645021645027*G0_1_0_2_3 - 0.0123136123136125*G0_1_0_2_4 + 0.0073881673881676*G0_1_0_2_5 + 0.0418662818662831*G0_1_0_3_0 + 0.0221645021645029*G0_1_0_3_1 + 0.0221645021645027*G0_1_0_3_2 - 0.837325637325667*G0_1_0_3_3 - 0.0985088985089018*G0_1_0_3_4 - 0.0985088985089018*G0_1_0_3_5 + 0.0123136123136126*G0_1_0_4_0 + 0.00738816738816762*G0_1_0_4_1 - 0.0123136123136125*G0_1_0_4_2 - 0.0985088985089018*G0_1_0_4_3 - 0.0689562289562303*G0_1_0_4_4 - 0.0295526695526705*G0_1_0_4_5 + 0.0123136123136127*G0_1_0_5_0 - 0.0123136123136127*G0_1_0_5_1 + 0.0073881673881676*G0_1_0_5_2 - 0.0985088985089018*G0_1_0_5_3 - 0.0295526695526705*G0_1_0_5_4 - 0.0689562289562307*G0_1_0_5_5 + 0.0172390572390574*G0_1_1_0_0 + 0.0375565175565189*G0_1_1_0_1 - 0.00461760461760478*G0_1_1_0_2 + 0.0689562289562311*G0_1_1_0_3 + 0.0116979316979319*G0_1_1_0_4 + 0.0825012025012052*G0_1_1_0_5 + 0.0375565175565189*G0_1_1_1_0 - 0.207484367484375*G0_1_1_1_1 + 0.0344781144781158*G0_1_1_1_2 - 0.181010101010108*G0_1_1_1_3 - 0.00554112554112575*G0_1_1_1_4 - 0.199480519480527*G0_1_1_1_5 - 0.00461760461760477*G0_1_1_2_0 + 0.0344781144781158*G0_1_1_2_1 + 0.00307840307840289*G0_1_1_2_2 + 0.112053872053876*G0_1_1_2_3 + 0.00123136123136139*G0_1_1_2_4 + 0.0332467532467545*G0_1_1_2_5 + 0.0689562289562311*G0_1_1_3_0 - 0.181010101010108*G0_1_1_3_1 + 0.112053872053876*G0_1_1_3_2 - 1.28061568061573*G0_1_1_3_3 - 0.126830206830211*G0_1_1_3_4 - 0.204405964405972*G0_1_1_3_5 + 0.0116979316979319*G0_1_1_4_0 - 0.00554112554112575*G0_1_1_4_1 + 0.00123136123136138*G0_1_1_4_2 - 0.126830206830211*G0_1_1_4_3 - 0.0960461760461789*G0_1_1_4_4 - 0.0554112554112573*G0_1_1_4_5 + 0.0825012025012052*G0_1_1_5_0 - 0.199480519480527*G0_1_1_5_1 + 0.0332467532467545*G0_1_1_5_2 - 0.204405964405972*G0_1_1_5_3 - 0.0554112554112573*G0_1_1_5_4 - 0.591053391053412*G0_1_1_5_5;
    A[164] = A[202] + 0.0424819624819642*G0_0_0_0_0 + 0.00800384800384828*G0_0_0_0_1 + 0.0083116883116886*G0_0_0_0_2 - 0.0209331409331417*G0_0_0_0_3 + 0.0160076960076964*G0_0_0_0_4 - 0.0166233766233773*G0_0_0_0_5 + 0.00800384800384828*G0_0_0_1_0 + 0.0338624338624351*G0_0_0_1_1 + 0.00338624338624341*G0_0_0_1_2 - 0.00861952861952884*G0_0_0_1_3 - 0.00985088985089022*G0_0_0_1_4 - 0.00985088985089006*G0_0_0_1_5 + 0.0083116883116886*G0_0_0_2_0 + 0.00338624338624341*G0_0_0_2_1 - 0.0474074074074085*G0_0_0_2_2 - 0.0258585858585865*G0_0_0_2_3 - 0.0591053391053411*G0_0_0_2_4 + 0.00554112554112571*G0_0_0_2_5 - 0.0209331409331417*G0_0_0_3_0 - 0.00861952861952884*G0_0_0_3_1 - 0.0258585858585865*G0_0_0_3_2 + 0.098508898508903*G0_0_0_3_3 + 0.0615680615680639*G0_0_0_3_4 + 0.030784030784032*G0_0_0_3_5 + 0.0160076960076964*G0_0_0_4_0 - 0.00985088985089022*G0_0_0_4_1 - 0.0591053391053411*G0_0_0_4_2 + 0.0615680615680639*G0_0_0_4_3 - 0.53194805194807*G0_0_0_4_4 + 0.00861952861952894*G0_0_0_4_5 - 0.0166233766233773*G0_0_0_5_0 - 0.00985088985089007*G0_0_0_5_1 + 0.00554112554112571*G0_0_0_5_2 + 0.030784030784032*G0_0_0_5_3 + 0.00861952861952895*G0_0_0_5_4 - 0.0861952861952894*G0_0_0_5_5 + 0.0027705627705629*G0_0_1_0_1 - 0.00277056277056285*G0_0_1_0_2 + 0.075420875420878*G0_0_1_0_4 - 0.0754208754208783*G0_0_1_0_5 + 0.0027705627705629*G0_0_1_1_0 + 0.0495622895622911*G0_0_1_1_1 - 0.00153920153920161*G0_0_1_1_3 - 0.0172390572390579*G0_0_1_1_4 + 0.0815776815776845*G0_0_1_1_5 - 0.00277056277056285*G0_0_1_2_0 - 0.0495622895622907*G0_0_1_2_2 + 0.00153920153920178*G0_0_1_2_3 - 0.0815776815776843*G0_0_1_2_4 + 0.0172390572390578*G0_0_1_2_5 - 0.00153920153920161*G0_0_1_3_1 + 0.00153920153920179*G0_0_1_3_2 + 0.0344781144781158*G0_0_1_3_4 - 0.0344781144781154*G0_0_1_3_5 + 0.075420875420878*G0_0_1_4_0 - 0.0172390572390579*G0_0_1_4_1 - 0.0815776815776843*G0_0_1_4_2 + 0.0344781144781158*G0_0_1_4_3 + 0.0837325637325663*G0_0_1_4_4 - 0.0754208754208783*G0_0_1_5_0 + 0.0815776815776845*G0_0_1_5_1 + 0.0172390572390578*G0_0_1_5_2 - 0.0344781144781154*G0_0_1_5_3 - 0.0837325637325665*G0_0_1_5_5 + 0.00184704184704186*G0_1_0_0_1 - 0.00184704184704193*G0_1_0_0_2 - 0.00954304954304992*G0_1_0_0_4 + 0.00954304954304974*G0_1_0_0_5 + 0.00184704184704186*G0_1_0_1_0 + 0.040327080327082*G0_1_0_1_1 + 0.0120057720057725*G0_1_0_1_3 - 0.00923520923520957*G0_1_0_1_4 - 0.00769600769600767*G0_1_0_1_5 - 0.00184704184704193*G0_1_0_2_0 - 0.0403270803270811*G0_1_0_2_2 - 0.0120057720057723*G0_1_0_2_3 + 0.00769600769600809*G0_1_0_2_4 + 0.0092352092352095*G0_1_0_2_5 + 0.0120057720057726*G0_1_0_3_1 - 0.0120057720057723*G0_1_0_3_2 + 0.0184704184704192*G0_1_0_3_4 - 0.0184704184704189*G0_1_0_3_5 - 0.00954304954304992*G0_1_0_4_0 - 0.00923520923520957*G0_1_0_4_1 + 0.00769600769600809*G0_1_0_4_2 + 0.0184704184704192*G0_1_0_4_3 + 0.100971620971625*G0_1_0_4_4 + 0.00954304954304973*G0_1_0_5_0 - 0.00769600769600767*G0_1_0_5_1 + 0.0092352092352095*G0_1_0_5_2 - 0.0184704184704189*G0_1_0_5_3 - 0.100971620971624*G0_1_0_5_5 - 0.0424819624819635*G0_1_1_0_0 - 0.00831168831168866*G0_1_1_0_1 - 0.00800384800384826*G0_1_1_0_2 + 0.0209331409331416*G0_1_1_0_3 + 0.0166233766233773*G0_1_1_0_4 - 0.0160076960076965*G0_1_1_0_5 - 0.00831168831168866*G0_1_1_1_0 + 0.047407407407409*G0_1_1_1_1 - 0.00338624338624354*G0_1_1_1_2 + 0.0258585858585868*G0_1_1_1_3 - 0.00554112554112573*G0_1_1_1_4 + 0.0591053391053414*G0_1_1_1_5 - 0.00800384800384826*G0_1_1_2_0 - 0.00338624338624354*G0_1_1_2_1 - 0.0338624338624346*G0_1_1_2_2 + 0.00861952861952894*G0_1_1_2_3 + 0.00985088985089006*G0_1_1_2_4 + 0.00985088985089009*G0_1_1_2_5 + 0.0209331409331416*G0_1_1_3_0 + 0.0258585858585868*G0_1_1_3_1 + 0.00861952861952894*G0_1_1_3_2 - 0.0985088985089012*G0_1_1_3_3 - 0.0307840307840318*G0_1_1_3_4 - 0.0615680615680634*G0_1_1_3_5 + 0.0166233766233773*G0_1_1_4_0 - 0.00554112554112573*G0_1_1_4_1 + 0.00985088985089006*G0_1_1_4_2 - 0.0307840307840318*G0_1_1_4_3 + 0.086195286195289*G0_1_1_4_4 - 0.00861952861952882*G0_1_1_4_5 - 0.0160076960076965*G0_1_1_5_0 + 0.0591053391053414*G0_1_1_5_1 + 0.00985088985089009*G0_1_1_5_2 - 0.0615680615680634*G0_1_1_5_3 - 0.00861952861952883*G0_1_1_5_4 + 0.531948051948071*G0_1_1_5_5;
    A[72] = A[202] + 0.00861952861952894*G0_0_0_0_0 + 0.00492544492544512*G0_0_0_0_2 - 0.0110822510822515*G0_0_0_0_3 + 0.0246272246272254*G0_0_0_0_4 - 0.00677248677248701*G0_0_0_0_5 - 0.00861952861952892*G0_0_0_1_1 - 0.0049254449254452*G0_0_0_1_2 - 0.0246272246272256*G0_0_0_1_3 + 0.0110822510822514*G0_0_0_1_4 + 0.00677248677248692*G0_0_0_1_5 + 0.00492544492544512*G0_0_0_2_0 - 0.0049254449254452*G0_0_0_2_1 + 0.0332467532467548*G0_0_0_2_3 - 0.0332467532467545*G0_0_0_2_4 - 0.0110822510822515*G0_0_0_3_0 - 0.0246272246272256*G0_0_0_3_1 + 0.0332467532467548*G0_0_0_3_2 + 0.630456950456974*G0_0_0_3_3 + 0.0221645021645032*G0_0_0_3_5 + 0.0246272246272254*G0_0_0_4_0 + 0.0110822510822514*G0_0_0_4_1 - 0.0332467532467545*G0_0_0_4_2 - 0.630456950456972*G0_0_0_4_4 - 0.0221645021645028*G0_0_0_4_5 - 0.00677248677248701*G0_0_0_5_0 + 0.00677248677248692*G0_0_0_5_1 + 0.0221645021645032*G0_0_0_5_3 - 0.0221645021645028*G0_0_0_5_4 + 0.0156998556998563*G0_0_1_0_0 - 0.00338624338624349*G0_0_1_0_1 - 0.00523328523328541*G0_0_1_0_2 - 0.00738816738816764*G0_0_1_0_3 + 0.0914285714285745*G0_0_1_0_4 + 0.0070803270803274*G0_0_1_0_5 - 0.00338624338624349*G0_0_1_1_0 - 0.00215488215488229*G0_0_1_1_1 - 0.0110822510822515*G0_0_1_1_2 - 0.0224723424723435*G0_0_1_1_3 + 0.011697931697932*G0_0_1_1_4 + 0.0273977873977881*G0_0_1_1_5 - 0.00523328523328541*G0_0_1_2_0 - 0.0110822510822515*G0_0_1_2_1 - 0.0424819624819634*G0_0_1_2_2 + 0.0594131794131819*G0_0_1_2_3 - 0.0587974987975007*G0_0_1_2_4 + 0.0209331409331416*G0_0_1_2_5 - 0.00738816738816764*G0_0_1_3_0 - 0.0224723424723435*G0_0_1_3_1 + 0.0594131794131819*G0_0_1_3_2 + 0.615680615680639*G0_0_1_3_3 - 0.00861952861952853*G0_0_1_3_4 - 0.0270899470899476*G0_0_1_3_5 + 0.0914285714285745*G0_0_1_4_0 + 0.011697931697932*G0_0_1_4_1 - 0.0587974987975008*G0_0_1_4_2 - 0.00861952861952854*G0_0_1_4_3 + 0.00246272246272217*G0_0_1_4_4 - 0.0652621452621473*G0_0_1_4_5 + 0.0070803270803274*G0_0_1_5_0 + 0.0273977873977881*G0_0_1_5_1 + 0.0209331409331416*G0_0_1_5_2 - 0.0270899470899476*G0_0_1_5_3 - 0.0652621452621473*G0_0_1_5_4 - 0.0985088985089009*G0_0_1_5_5 + 0.00646464646464667*G0_1_0_0_0 - 0.00338624338624352*G0_1_0_0_1 - 0.00615680615680632*G0_1_0_0_2 + 0.000615680615680633*G0_1_0_0_3 + 0.00215488215488207*G0_1_0_0_4 + 0.0206253006253012*G0_1_0_0_5 - 0.00338624338624352*G0_1_0_1_0 + 0.00708032708032732*G0_1_0_1_1 - 0.0101587301587306*G0_1_0_1_2 + 0.0668013468013493*G0_1_0_1_3 + 0.00369408369408385*G0_1_0_1_4 + 0.0138528138528145*G0_1_0_1_5 - 0.00615680615680632*G0_1_0_2_0 - 0.0101587301587306*G0_1_0_2_1 - 0.0424819624819634*G0_1_0_2_2 - 0.0255507455507463*G0_1_0_2_3 + 0.0261664261664271*G0_1_0_2_4 + 0.0209331409331416*G0_1_0_2_5 + 0.000615680615680633*G0_1_0_3_0 + 0.0668013468013493*G0_1_0_3_1 - 0.0255507455507463*G0_1_0_3_2 + 0.632919672919697*G0_1_0_3_3 - 0.00861952861952876*G0_1_0_3_4 - 0.0430976430976442*G0_1_0_3_5 + 0.00215488215488206*G0_1_0_4_0 + 0.00369408369408385*G0_1_0_4_1 + 0.0261664261664271*G0_1_0_4_2 - 0.00861952861952877*G0_1_0_4_3 - 0.0147763347763366*G0_1_0_4_4 - 0.0492544492544509*G0_1_0_4_5 + 0.0206253006253012*G0_1_0_5_0 + 0.0138528138528145*G0_1_0_5_1 + 0.0209331409331416*G0_1_0_5_2 - 0.0430976430976441*G0_1_0_5_3 - 0.0492544492544509*G0_1_0_5_4 - 0.0985088985089013*G0_1_0_5_5 - 0.0338624338624343*G0_1_1_0_0 - 0.0033862433862436*G0_1_1_0_1 - 0.00800384800384828*G0_1_1_0_2 + 0.00985088985089019*G0_1_1_0_3 + 0.00985088985089028*G0_1_1_0_4 + 0.00861952861952907*G0_1_1_0_5 - 0.0033862433862436*G0_1_1_1_0 + 0.0474074074074094*G0_1_1_1_1 - 0.00831168831168869*G0_1_1_1_2 + 0.0591053391053413*G0_1_1_1_3 - 0.00554112554112574*G0_1_1_1_4 + 0.0258585858585869*G0_1_1_1_5 - 0.00800384800384828*G0_1_1_2_0 - 0.00831168831168869*G0_1_1_2_1 - 0.0424819624819634*G0_1_1_2_2 - 0.0160076960076964*G0_1_1_2_3 + 0.0166233766233771*G0_1_1_2_4 + 0.0209331409331416*G0_1_1_2_5 + 0.0098508898508902*G0_1_1_3_0 + 0.0591053391053413*G0_1_1_3_1 - 0.0160076960076964*G0_1_1_3_2 + 0.531948051948072*G0_1_1_3_3 - 0.00861952861952874*G0_1_1_3_4 - 0.0615680615680632*G0_1_1_3_5 + 0.00985088985089028*G0_1_1_4_0 - 0.00554112554112574*G0_1_1_4_1 + 0.0166233766233771*G0_1_1_4_2 - 0.00861952861952873*G0_1_1_4_3 + 0.0861952861952891*G0_1_1_4_4 - 0.0307840307840316*G0_1_1_4_5 + 0.00861952861952907*G0_1_1_5_0 + 0.0258585858585869*G0_1_1_5_1 + 0.0209331409331416*G0_1_1_5_2 - 0.0615680615680632*G0_1_1_5_3 - 0.0307840307840316*G0_1_1_5_4 - 0.0985088985089007*G0_1_1_5_5;
    A[184] = A[72] + 0.000923520923521003*G0_0_1_0_1 - 0.000923520923520904*G0_0_1_0_2 - 0.00892736892736938*G0_0_1_0_4 + 0.00892736892736896*G0_0_1_0_5 + 0.000923520923521003*G0_0_1_1_0 + 0.00923520923520925*G0_0_1_1_1 + 0.0803463203463234*G0_0_1_1_3 - 0.00800384800384821*G0_0_1_1_4 - 0.00461760461760465*G0_0_1_1_5 - 0.000923520923520904*G0_0_1_2_0 - 0.00923520923520971*G0_0_1_2_2 - 0.0803463203463234*G0_0_1_2_3 + 0.00461760461760475*G0_0_1_2_4 + 0.00800384800384826*G0_0_1_2_5 + 0.0803463203463234*G0_0_1_3_1 - 0.0803463203463234*G0_0_1_3_2 + 0.0160076960076964*G0_0_1_3_4 - 0.0160076960076965*G0_0_1_3_5 - 0.00892736892736938*G0_0_1_4_0 - 0.00800384800384821*G0_0_1_4_1 + 0.00461760461760476*G0_0_1_4_2 + 0.0160076960076964*G0_0_1_4_3 - 0.0172390572390586*G0_0_1_4_4 + 0.00892736892736895*G0_0_1_5_0 - 0.00461760461760465*G0_0_1_5_1 + 0.00800384800384826*G0_0_1_5_2 - 0.0160076960076965*G0_0_1_5_3 + 0.0172390572390572*G0_0_1_5_5 - 0.000923520923521002*G0_1_0_0_1 + 0.000923520923520905*G0_1_0_0_2 + 0.00892736892736938*G0_1_0_0_4 - 0.00892736892736895*G0_1_0_0_5 - 0.000923520923521003*G0_1_0_1_0 - 0.00923520923520925*G0_1_0_1_1 - 0.0803463203463233*G0_1_0_1_3 + 0.00800384800384821*G0_1_0_1_4 + 0.00461760461760465*G0_1_0_1_5 + 0.000923520923520904*G0_1_0_2_0 + 0.00923520923520971*G0_1_0_2_2 + 0.0803463203463234*G0_1_0_2_3 - 0.00461760461760475*G0_1_0_2_4 - 0.00800384800384826*G0_1_0_2_5 - 0.0803463203463233*G0_1_0_3_1 + 0.0803463203463234*G0_1_0_3_2 - 0.0160076960076964*G0_1_0_3_4 + 0.0160076960076965*G0_1_0_3_5 + 0.00892736892736938*G0_1_0_4_0 + 0.00800384800384821*G0_1_0_4_1 - 0.00461760461760476*G0_1_0_4_2 - 0.0160076960076964*G0_1_0_4_3 + 0.0172390572390586*G0_1_0_4_4 - 0.00892736892736895*G0_1_0_5_0 + 0.00461760461760465*G0_1_0_5_1 - 0.00800384800384826*G0_1_0_5_2 + 0.0160076960076965*G0_1_0_5_3 - 0.0172390572390572*G0_1_0_5_5;
    A[73] = A[199] - 0.00677248677248701*G0_0_1_0_0 - 0.00215488215488223*G0_0_1_0_1 + 0.00277056277056285*G0_0_1_0_2 + 0.00861952861952885*G0_0_1_0_3 + 0.0138528138528142*G0_0_1_0_4 + 0.024319384319385*G0_0_1_0_5 - 0.00215488215488223*G0_0_1_1_0 - 0.0123136123136128*G0_0_1_1_1 - 0.0252429052429061*G0_0_1_1_2 + 0.18316498316499*G0_0_1_1_3 + 0.0166233766233772*G0_0_1_1_4 - 0.00769600769600785*G0_0_1_1_5 + 0.00277056277056285*G0_0_1_2_0 - 0.0252429052429061*G0_0_1_2_1 - 0.0153920153920154*G0_0_1_2_2 - 0.0735738335738364*G0_0_1_2_3 - 0.00831168831168844*G0_0_1_2_4 + 0.00800384800384818*G0_0_1_2_5 + 0.00861952861952884*G0_0_1_3_0 + 0.18316498316499*G0_0_1_3_1 - 0.0735738335738364*G0_0_1_3_2 + 0.236421356421366*G0_0_1_3_3 - 0.050485810485812*G0_0_1_3_4 - 0.0332467532467539*G0_0_1_3_5 + 0.0138528138528142*G0_0_1_4_0 + 0.0166233766233772*G0_0_1_4_1 - 0.00831168831168844*G0_0_1_4_2 - 0.050485810485812*G0_0_1_4_3 - 0.0714189514189539*G0_0_1_4_4 - 0.0492544492544508*G0_0_1_4_5 + 0.024319384319385*G0_0_1_5_0 - 0.00769600769600784*G0_0_1_5_1 + 0.00800384800384818*G0_0_1_5_2 - 0.033246753246754*G0_0_1_5_3 - 0.0492544492544508*G0_0_1_5_4 - 0.145300625300629*G0_0_1_5_5 + 0.00677248677248701*G0_1_0_0_0 + 0.00215488215488223*G0_1_0_0_1 - 0.00277056277056285*G0_1_0_0_2 - 0.00861952861952885*G0_1_0_0_3 - 0.0138528138528142*G0_1_0_0_4 - 0.024319384319385*G0_1_0_0_5 + 0.00215488215488223*G0_1_0_1_0 + 0.0123136123136128*G0_1_0_1_1 + 0.0252429052429061*G0_1_0_1_2 - 0.18316498316499*G0_1_0_1_3 - 0.0166233766233772*G0_1_0_1_4 + 0.00769600769600785*G0_1_0_1_5 - 0.00277056277056285*G0_1_0_2_0 + 0.0252429052429061*G0_1_0_2_1 + 0.0153920153920154*G0_1_0_2_2 + 0.0735738335738364*G0_1_0_2_3 + 0.00831168831168844*G0_1_0_2_4 - 0.00800384800384818*G0_1_0_2_5 - 0.00861952861952885*G0_1_0_3_0 - 0.18316498316499*G0_1_0_3_1 + 0.0735738335738364*G0_1_0_3_2 - 0.236421356421366*G0_1_0_3_3 + 0.050485810485812*G0_1_0_3_4 + 0.033246753246754*G0_1_0_3_5 - 0.0138528138528142*G0_1_0_4_0 - 0.0166233766233772*G0_1_0_4_1 + 0.00831168831168843*G0_1_0_4_2 + 0.050485810485812*G0_1_0_4_3 + 0.0714189514189539*G0_1_0_4_4 + 0.0492544492544508*G0_1_0_4_5 - 0.024319384319385*G0_1_0_5_0 + 0.00769600769600784*G0_1_0_5_1 - 0.00800384800384818*G0_1_0_5_2 + 0.033246753246754*G0_1_0_5_3 + 0.0492544492544508*G0_1_0_5_4 + 0.145300625300629*G0_1_0_5_5;
    A[220] = A[164] + 0.00923520923520931*G0_0_1_0_0 + 0.000923520923520927*G0_0_1_0_2 - 0.00800384800384826*G0_0_1_0_3 - 0.00461760461760485*G0_0_1_0_4 + 0.0803463203463232*G0_0_1_0_5 - 0.00923520923520939*G0_0_1_1_1 - 0.000923520923520927*G0_0_1_1_2 + 0.00461760461760474*G0_0_1_1_3 + 0.00800384800384824*G0_0_1_1_4 - 0.0803463203463232*G0_0_1_1_5 + 0.000923520923520927*G0_0_1_2_0 - 0.000923520923520928*G0_0_1_2_1 - 0.00892736892736929*G0_0_1_2_3 + 0.00892736892736935*G0_0_1_2_4 - 0.00800384800384826*G0_0_1_3_0 + 0.00461760461760475*G0_0_1_3_1 - 0.00892736892736929*G0_0_1_3_2 - 0.0172390572390583*G0_0_1_3_3 + 0.0160076960076965*G0_0_1_3_5 - 0.00461760461760486*G0_0_1_4_0 + 0.00800384800384824*G0_0_1_4_1 + 0.00892736892736936*G0_0_1_4_2 + 0.0172390572390587*G0_0_1_4_4 - 0.0160076960076964*G0_0_1_4_5 + 0.0803463203463232*G0_0_1_5_0 - 0.0803463203463232*G0_0_1_5_1 + 0.0160076960076965*G0_0_1_5_3 - 0.0160076960076964*G0_0_1_5_4 - 0.00923520923520931*G0_1_0_0_0 - 0.000923520923520929*G0_1_0_0_2 + 0.00800384800384826*G0_1_0_0_3 + 0.00461760461760485*G0_1_0_0_4 - 0.0803463203463232*G0_1_0_0_5 + 0.00923520923520938*G0_1_0_1_1 + 0.000923520923520927*G0_1_0_1_2 - 0.00461760461760475*G0_1_0_1_3 - 0.00800384800384824*G0_1_0_1_4 + 0.0803463203463232*G0_1_0_1_5 - 0.000923520923520928*G0_1_0_2_0 + 0.000923520923520928*G0_1_0_2_1 + 0.00892736892736929*G0_1_0_2_3 - 0.00892736892736936*G0_1_0_2_4 + 0.00800384800384826*G0_1_0_3_0 - 0.00461760461760475*G0_1_0_3_1 + 0.00892736892736929*G0_1_0_3_2 + 0.0172390572390583*G0_1_0_3_3 - 0.0160076960076965*G0_1_0_3_5 + 0.00461760461760485*G0_1_0_4_0 - 0.00800384800384824*G0_1_0_4_1 - 0.00892736892736936*G0_1_0_4_2 - 0.0172390572390587*G0_1_0_4_4 + 0.0160076960076964*G0_1_0_4_5 - 0.0803463203463232*G0_1_0_5_0 + 0.0803463203463232*G0_1_0_5_1 - 0.0160076960076965*G0_1_0_5_3 + 0.0160076960076964*G0_1_0_5_4;
    A[118] = A[202] + 0.00923520923520945*G0_0_1_0_0 + 0.000923520923521033*G0_0_1_0_1 - 0.00800384800384828*G0_0_1_0_3 + 0.0803463203463231*G0_0_1_0_4 - 0.00461760461760484*G0_0_1_0_5 + 0.000923520923521032*G0_0_1_1_0 - 0.000923520923520911*G0_0_1_1_2 - 0.00892736892736942*G0_0_1_1_3 + 0.00892736892736896*G0_0_1_1_5 - 0.000923520923520909*G0_0_1_2_1 - 0.00923520923520965*G0_0_1_2_2 + 0.00461760461760479*G0_0_1_2_3 - 0.0803463203463231*G0_0_1_2_4 + 0.00800384800384825*G0_0_1_2_5 - 0.00800384800384828*G0_0_1_3_0 - 0.00892736892736942*G0_0_1_3_1 + 0.0046176046176048*G0_0_1_3_2 - 0.0172390572390583*G0_0_1_3_3 + 0.0160076960076966*G0_0_1_3_4 + 0.0803463203463231*G0_0_1_4_0 - 0.0803463203463231*G0_0_1_4_2 + 0.0160076960076966*G0_0_1_4_3 - 0.0160076960076965*G0_0_1_4_5 - 0.00461760461760484*G0_0_1_5_0 + 0.00892736892736896*G0_0_1_5_1 + 0.00800384800384825*G0_0_1_5_2 - 0.0160076960076965*G0_0_1_5_4 + 0.0172390572390577*G0_0_1_5_5 - 0.00923520923520945*G0_1_0_0_0 - 0.000923520923521032*G0_1_0_0_1 + 0.00800384800384828*G0_1_0_0_3 - 0.080346320346323*G0_1_0_0_4 + 0.00461760461760484*G0_1_0_0_5 - 0.00092352092352103*G0_1_0_1_0 + 0.000923520923520911*G0_1_0_1_2 + 0.00892736892736942*G0_1_0_1_3 - 0.00892736892736896*G0_1_0_1_5 + 0.000923520923520909*G0_1_0_2_1 + 0.00923520923520966*G0_1_0_2_2 - 0.0046176046176048*G0_1_0_2_3 + 0.0803463203463231*G0_1_0_2_4 - 0.00800384800384825*G0_1_0_2_5 + 0.00800384800384828*G0_1_0_3_0 + 0.00892736892736942*G0_1_0_3_1 - 0.0046176046176048*G0_1_0_3_2 + 0.0172390572390583*G0_1_0_3_3 - 0.0160076960076966*G0_1_0_3_4 - 0.080346320346323*G0_1_0_4_0 + 0.0803463203463231*G0_1_0_4_2 - 0.0160076960076966*G0_1_0_4_3 + 0.0160076960076965*G0_1_0_4_5 + 0.00461760461760484*G0_1_0_5_0 - 0.00892736892736896*G0_1_0_5_1 - 0.00800384800384825*G0_1_0_5_2 + 0.0160076960076965*G0_1_0_5_4 - 0.0172390572390577*G0_1_0_5_5;
    A[40] = 0.00695206028539389*G0_1_0_0_0 + 4.81000481000586e-05*G0_1_0_0_2 + 0.000641333974667319*G0_1_0_0_3 - 0.00220618887285559*G0_1_0_0_4 - 0.0107615840949178*G0_1_0_0_5 - 0.00695206028539393*G0_1_0_1_1 - 4.81000481000426e-05*G0_1_0_1_2 + 0.00220618887285562*G0_1_0_1_3 - 0.000641333974667319*G0_1_0_1_4 + 0.0107615840949178*G0_1_0_1_5 + 4.81000481000586e-05*G0_1_0_2_0 - 4.81000481000426e-05*G0_1_0_2_1 - 0.00137245470578813*G0_1_0_2_3 + 0.00137245470578804*G0_1_0_2_4 + 0.000641333974667319*G0_1_0_3_0 + 0.00220618887285562*G0_1_0_3_1 - 0.00137245470578813*G0_1_0_3_2 - 0.000615680615680578*G0_1_0_3_3 - 0.00128266794933462*G0_1_0_3_5 - 0.00220618887285559*G0_1_0_4_0 - 0.000641333974667319*G0_1_0_4_1 + 0.00137245470578804*G0_1_0_4_2 + 0.000615680615680645*G0_1_0_4_4 + 0.00128266794933465*G0_1_0_4_5 - 0.0107615840949178*G0_1_0_5_0 + 0.0107615840949178*G0_1_0_5_1 - 0.00128266794933462*G0_1_0_5_3 + 0.00128266794933465*G0_1_0_5_4 - 0.00246913580246919*G0_1_1_0_0 - 0.0011287477954145*G0_1_1_0_1 - 0.000298220298220311*G0_1_1_0_2 + 0.00119288119288122*G0_1_1_0_3 + 0.00185986852653525*G0_1_1_0_4 - 0.00300144300144311*G0_1_1_0_5 - 0.0011287477954145*G0_1_1_1_0 - 0.00942119608786319*G0_1_1_1_1 - 0.00034632034632036*G0_1_1_1_2 + 0.00406605739939086*G0_1_1_1_3 + 0.000551547218213905*G0_1_1_1_4 + 0.0077601410934747*G0_1_1_1_5 - 0.000298220298220311*G0_1_1_2_0 - 0.00034632034632036*G0_1_1_2_1 - 0.00311046977713652*G0_1_1_2_2 - 0.0014878948212282*G0_1_1_2_3 - 0.000115440115440099*G0_1_1_2_4 + 0.000243706910373567*G0_1_1_2_5 + 0.00119288119288122*G0_1_1_3_0 + 0.00406605739939086*G0_1_1_3_1 - 0.0014878948212282*G0_1_1_3_2 - 0.00220618887285552*G0_1_1_3_3 - 0.00348885682219025*G0_1_1_3_4 - 0.00287317620650958*G0_1_1_3_5 + 0.00185986852653525*G0_1_1_4_0 + 0.000551547218213906*G0_1_1_4_1 - 0.000115440115440099*G0_1_1_4_2 - 0.00348885682219025*G0_1_1_4_3 - 0.00159050825717499*G0_1_1_4_4 - 0.00159050825717496*G0_1_1_4_5 - 0.00300144300144311*G0_1_1_5_0 + 0.0077601410934747*G0_1_1_5_1 + 0.000243706910373568*G0_1_1_5_2 - 0.00287317620650958*G0_1_1_5_3 - 0.00159050825717495*G0_1_1_5_4 + 0.0584383517716874*G0_1_1_5_5;
    A[145] = A[159] + 0.0543851210517892*G0_0_1_0_0 - 0.0258072791406134*G0_0_1_0_1 - 0.00784992784992811*G0_0_1_0_2 + 0.00954304954304987*G0_0_1_0_3 + 0.0246272246272254*G0_0_1_0_4 + 0.142632675966014*G0_0_1_0_5 - 0.0258072791406134*G0_0_1_1_0 + 0.0102613435946772*G0_0_1_1_1 + 0.00702902036235395*G0_0_1_1_2 - 0.0111848645181982*G0_0_1_1_3 - 0.0214462081128755*G0_0_1_1_4 - 0.0807567740901103*G0_0_1_1_5 - 0.00784992784992811*G0_0_1_2_0 + 0.00702902036235394*G0_0_1_2_1 + 0.00441237774571122*G0_0_1_2_2 - 0.00738816738816766*G0_0_1_2_3 - 0.0146737213403885*G0_0_1_2_4 - 0.0413532146865495*G0_0_1_2_5 + 0.00954304954304987*G0_0_1_3_0 - 0.0111848645181982*G0_0_1_3_1 - 0.00738816738816766*G0_0_1_3_2 + 0.00738816738816775*G0_0_1_3_3 + 0.0238063171396513*G0_0_1_3_4 + 0.0636203302869991*G0_0_1_3_5 + 0.0246272246272254*G0_0_1_4_0 - 0.0214462081128755*G0_0_1_4_1 - 0.0146737213403885*G0_0_1_4_2 + 0.0238063171396513*G0_0_1_4_3 + 0.0426871893538575*G0_0_1_4_4 + 0.12559884559885*G0_0_1_4_5 + 0.142632675966014*G0_0_1_5_0 - 0.0807567740901103*G0_0_1_5_1 - 0.0413532146865495*G0_0_1_5_2 + 0.0636203302869991*G0_0_1_5_3 + 0.12559884559885*G0_0_1_5_4 + 0.625531505531527*G0_0_1_5_5 - 0.0543851210517892*G0_1_0_0_0 + 0.0258072791406133*G0_1_0_0_1 + 0.00784992784992811*G0_1_0_0_2 - 0.00954304954304987*G0_1_0_0_3 - 0.0246272246272254*G0_1_0_0_4 - 0.142632675966014*G0_1_0_0_5 + 0.0258072791406134*G0_1_0_1_0 - 0.0102613435946772*G0_1_0_1_1 - 0.00702902036235395*G0_1_0_1_2 + 0.0111848645181982*G0_1_0_1_3 + 0.0214462081128755*G0_1_0_1_4 + 0.0807567740901103*G0_1_0_1_5 + 0.00784992784992811*G0_1_0_2_0 - 0.00702902036235394*G0_1_0_2_1 - 0.00441237774571122*G0_1_0_2_2 + 0.00738816738816766*G0_1_0_2_3 + 0.0146737213403885*G0_1_0_2_4 + 0.0413532146865495*G0_1_0_2_5 - 0.00954304954304987*G0_1_0_3_0 + 0.0111848645181982*G0_1_0_3_1 + 0.00738816738816767*G0_1_0_3_2 - 0.00738816738816775*G0_1_0_3_3 - 0.0238063171396513*G0_1_0_3_4 - 0.0636203302869991*G0_1_0_3_5 - 0.0246272246272254*G0_1_0_4_0 + 0.0214462081128755*G0_1_0_4_1 + 0.0146737213403885*G0_1_0_4_2 - 0.0238063171396513*G0_1_0_4_3 - 0.0426871893538575*G0_1_0_4_4 - 0.12559884559885*G0_1_0_4_5 - 0.142632675966014*G0_1_0_5_0 + 0.0807567740901103*G0_1_0_5_1 + 0.0413532146865495*G0_1_0_5_2 - 0.0636203302869991*G0_1_0_5_3 - 0.12559884559885*G0_1_0_5_4 - 0.625531505531527*G0_1_0_5_5;
    A[151] = -A[61] + 0.0321628988295667*G0_0_0_0_0 - 0.00219015552348894*G0_0_0_0_1 - 0.00705788039121396*G0_0_0_0_2 - 0.00227032227032234*G0_0_0_0_3 + 0.0107487574154245*G0_0_0_0_4 + 0.0107231040564378*G0_0_0_0_5 - 0.00219015552348894*G0_0_0_1_0 + 0.151707551707557*G0_0_0_1_1 - 0.00975789642456342*G0_0_0_1_2 + 0.0334776334776346*G0_0_0_1_3 - 0.00616963283629972*G0_0_0_1_4 - 0.00551547218213891*G0_0_0_1_5 - 0.00705788039121396*G0_0_0_2_0 - 0.00975789642456342*G0_0_0_2_1 + 0.0351899951899963*G0_0_0_2_2 + 0.00328362995029672*G0_0_0_2_3 + 0.0113131313131317*G0_0_0_2_4 - 0.00355299021965701*G0_0_0_2_5 - 0.00227032227032234*G0_0_0_3_0 + 0.0334776334776346*G0_0_0_3_1 + 0.00328362995029672*G0_0_0_3_2 + 0.026576879910214*G0_0_0_3_3 + 0.0168799102132441*G0_0_0_3_4 + 0.0116466249799587*G0_0_0_3_5 + 0.0107487574154245*G0_0_0_4_0 - 0.00616963283629972*G0_0_0_4_1 + 0.0113131313131317*G0_0_0_4_2 + 0.0168799102132441*G0_0_0_4_3 + 0.0850665383998744*G0_0_0_4_4 + 0.0194452461119134*G0_0_0_4_5 + 0.0107231040564378*G0_0_0_5_0 - 0.0055154721821389*G0_0_0_5_1 - 0.00355299021965701*G0_0_0_5_2 + 0.0116466249799587*G0_0_0_5_3 + 0.0194452461119134*G0_0_0_5_4 + 0.0173416706750047*G0_0_0_5_5 - 0.00302709636042978*G0_1_0_0_0 + 0.00756774090107453*G0_1_0_0_1 + 0.00128266794933466*G0_1_0_0_3 - 0.000564373897707238*G0_1_0_0_4 + 0.00743947410614103*G0_1_0_0_5 + 0.00756774090107454*G0_1_0_1_0 - 0.00756774090107446*G0_1_0_1_2 + 0.0389931056597735*G0_1_0_1_3 - 0.0389931056597739*G0_1_0_1_5 - 0.00756774090107446*G0_1_0_2_1 + 0.00302709636042978*G0_1_0_2_2 - 0.007439474106141*G0_1_0_2_3 + 0.00056437389770724*G0_1_0_2_4 - 0.00128266794933466*G0_1_0_2_5 + 0.00128266794933466*G0_1_0_3_0 + 0.0389931056597735*G0_1_0_3_1 - 0.007439474106141*G0_1_0_3_2 + 0.00923520923520938*G0_1_0_3_3 - 0.00256533589866932*G0_1_0_3_4 - 0.000564373897707239*G0_1_0_4_0 + 0.000564373897707239*G0_1_0_4_2 - 0.00256533589866932*G0_1_0_4_3 + 0.00256533589866933*G0_1_0_4_5 + 0.00743947410614103*G0_1_0_5_0 - 0.0389931056597738*G0_1_0_5_1 - 0.00128266794933466*G0_1_0_5_2 + 0.00256533589866933*G0_1_0_5_4 - 0.00923520923520959*G0_1_0_5_5;
    A[102] = A[186] - 0.192913259579932*G0_0_1_0_0 + 0.0186756453423126*G0_0_1_0_1 + 0.0063620330286999*G0_0_1_0_2 - 0.00246272246272251*G0_0_1_0_3 + 0.0102613435946775*G0_0_1_0_4 - 0.0882475549142245*G0_0_1_0_5 + 0.0186756453423126*G0_0_1_1_0 - 0.00451499118165809*G0_0_1_1_1 + 0.000615680615680661*G0_0_1_1_2 + 0.00123136123136119*G0_0_1_1_3 - 0.0131345198011869*G0_0_1_1_4 + 0.0242167708834383*G0_0_1_1_5 + 0.0063620330286999*G0_0_1_2_0 + 0.000615680615680661*G0_0_1_2_1 - 0.00328362995029675*G0_0_1_2_2 - 0.00615680615680636*G0_0_1_2_3 - 0.0488439955106639*G0_0_1_2_4 + 0.0106717973384643*G0_0_1_2_5 - 0.00246272246272251*G0_0_1_3_0 + 0.00123136123136119*G0_0_1_3_1 - 0.00615680615680636*G0_0_1_3_2 - 0.0164181497514843*G0_0_1_3_3 + 0.0311944845278188*G0_0_1_3_4 - 0.0164181497514836*G0_0_1_3_5 + 0.0102613435946775*G0_0_1_4_0 - 0.0131345198011869*G0_0_1_4_1 - 0.0488439955106639*G0_0_1_4_2 + 0.0311944845278188*G0_0_1_4_3 + 0.512246272246289*G0_0_1_4_4 + 0.00492544492544512*G0_0_1_4_5 - 0.0882475549142245*G0_0_1_5_0 + 0.0242167708834383*G0_0_1_5_1 + 0.0106717973384643*G0_0_1_5_2 - 0.0164181497514836*G0_0_1_5_3 + 0.00492544492544512*G0_0_1_5_4 - 0.160897867564539*G0_0_1_5_5 + 0.192913259579932*G0_1_0_0_0 - 0.0186756453423126*G0_1_0_0_1 - 0.0063620330286999*G0_1_0_0_2 + 0.0024627224627225*G0_1_0_0_3 - 0.0102613435946775*G0_1_0_0_4 + 0.0882475549142245*G0_1_0_0_5 - 0.0186756453423126*G0_1_0_1_0 + 0.00451499118165809*G0_1_0_1_1 - 0.000615680615680663*G0_1_0_1_2 - 0.00123136123136119*G0_1_0_1_3 + 0.0131345198011869*G0_1_0_1_4 - 0.0242167708834383*G0_1_0_1_5 - 0.00636203302869989*G0_1_0_2_0 - 0.00061568061568066*G0_1_0_2_1 + 0.00328362995029675*G0_1_0_2_2 + 0.00615680615680636*G0_1_0_2_3 + 0.0488439955106639*G0_1_0_2_4 - 0.0106717973384643*G0_1_0_2_5 + 0.0024627224627225*G0_1_0_3_0 - 0.00123136123136119*G0_1_0_3_1 + 0.00615680615680636*G0_1_0_3_2 + 0.0164181497514843*G0_1_0_3_3 - 0.0311944845278188*G0_1_0_3_4 + 0.0164181497514836*G0_1_0_3_5 - 0.0102613435946775*G0_1_0_4_0 + 0.0131345198011869*G0_1_0_4_1 + 0.0488439955106639*G0_1_0_4_2 - 0.0311944845278188*G0_1_0_4_3 - 0.512246272246289*G0_1_0_4_4 - 0.00492544492544511*G0_1_0_4_5 + 0.0882475549142245*G0_1_0_5_0 - 0.0242167708834383*G0_1_0_5_1 - 0.0106717973384643*G0_1_0_5_2 + 0.0164181497514836*G0_1_0_5_3 - 0.00492544492544512*G0_1_0_5_4 + 0.160897867564539*G0_1_0_5_5;
    A[189] = A[102] + 0.459708193041542*G0_0_0_0_0 - 0.0264742664742674*G0_0_0_0_1 - 0.0913259579926277*G0_0_0_0_2 + 0.0213435946769287*G0_0_0_0_3 + 0.443290043290058*G0_0_0_0_4 + 0.119031585698256*G0_0_0_0_5 - 0.0264742664742674*G0_0_0_1_0 - 0.0254481321147997*G0_0_0_1_1 + 0.0104665704665708*G0_0_0_1_2 - 0.0574635241301927*G0_0_0_1_3 - 0.0640307840307862*G0_0_0_1_4 - 0.0402244668911349*G0_0_0_1_5 - 0.0913259579926277*G0_0_0_2_0 + 0.0104665704665708*G0_0_0_2_1 + 0.0504858104858123*G0_0_0_2_2 + 0.0369408369408383*G0_0_0_2_3 - 0.142016995350333*G0_0_0_2_4 - 0.027089947089948*G0_0_0_2_5 + 0.0213435946769287*G0_0_0_3_0 - 0.0574635241301927*G0_0_0_3_1 + 0.0369408369408383*G0_0_0_3_2 + 0.0197017797017809*G0_0_0_3_3 + 0.0853743787077149*G0_0_0_3_4 + 0.0114927048260386*G0_0_0_3_5 + 0.443290043290058*G0_0_0_4_0 - 0.0640307840307862*G0_0_0_4_1 - 0.142016995350333*G0_0_0_4_2 + 0.0853743787077148*G0_0_0_4_3 + 1.05732884399555*G0_0_0_4_4 + 0.182241462241468*G0_0_0_4_5 + 0.119031585698256*G0_0_0_5_0 - 0.0402244668911349*G0_0_0_5_1 - 0.027089947089948*G0_0_0_5_2 + 0.0114927048260386*G0_0_0_5_3 + 0.182241462241468*G0_0_0_5_4 + 0.0886580086580117*G0_0_0_5_5 + 0.00164181497514837*G0_0_1_0_1 - 0.00164181497514835*G0_0_1_0_2 - 0.0307840307840318*G0_0_1_0_4 + 0.0307840307840317*G0_0_1_0_5 + 0.00164181497514837*G0_0_1_1_0 - 0.0316049382716061*G0_0_1_1_1 - 0.0545903479236831*G0_0_1_1_3 - 0.00246272246272253*G0_0_1_1_4 - 0.0348885682219027*G0_0_1_1_5 - 0.00164181497514836*G0_0_1_2_0 + 0.0316049382716061*G0_0_1_2_2 + 0.0545903479236832*G0_0_1_2_3 + 0.0348885682219027*G0_0_1_2_4 + 0.00246272246272259*G0_0_1_2_5 - 0.0545903479236831*G0_0_1_3_1 + 0.0545903479236832*G0_0_1_3_2 + 0.0049254449254451*G0_0_1_3_4 - 0.00492544492544514*G0_0_1_3_5 - 0.0307840307840318*G0_0_1_4_0 - 0.00246272246272253*G0_0_1_4_1 + 0.0348885682219027*G0_0_1_4_2 + 0.00492544492544508*G0_0_1_4_3 - 0.114927048260385*G0_0_1_4_4 + 0.0307840307840317*G0_0_1_5_0 - 0.0348885682219027*G0_0_1_5_1 + 0.00246272246272259*G0_0_1_5_2 - 0.00492544492544514*G0_0_1_5_3 + 0.114927048260385*G0_0_1_5_5 + 0.013955427288761*G0_1_0_0_1 - 0.0139554272887611*G0_1_0_0_2 + 0.0677248677248702*G0_1_0_0_4 - 0.0677248677248701*G0_1_0_0_5 + 0.0139554272887611*G0_1_0_1_0 - 0.0328362995029673*G0_1_0_1_1 - 0.0472021805355155*G0_1_0_1_3 - 0.0262690396023738*G0_1_0_1_4 + 0.0381721981721995*G0_1_0_1_5 - 0.0139554272887611*G0_1_0_2_0 + 0.0328362995029674*G0_1_0_2_2 + 0.0472021805355156*G0_1_0_2_3 - 0.0381721981721995*G0_1_0_2_4 + 0.0262690396023738*G0_1_0_2_5 - 0.0472021805355155*G0_1_0_3_1 + 0.0472021805355156*G0_1_0_3_2 + 0.0525380792047475*G0_1_0_3_4 - 0.0525380792047477*G0_1_0_3_5 + 0.0677248677248702*G0_1_0_4_0 - 0.0262690396023738*G0_1_0_4_1 - 0.0381721981721995*G0_1_0_4_2 + 0.0525380792047475*G0_1_0_4_3 + 0.558217091550444*G0_1_0_4_4 - 0.0677248677248701*G0_1_0_5_0 + 0.0381721981721995*G0_1_0_5_1 + 0.0262690396023738*G0_1_0_5_2 - 0.0525380792047477*G0_1_0_5_3 - 0.558217091550444*G0_1_0_5_5 - 0.459708193041543*G0_1_1_0_0 + 0.0913259579926279*G0_1_1_0_1 + 0.0264742664742674*G0_1_1_0_2 - 0.0213435946769287*G0_1_1_0_3 - 0.119031585698256*G0_1_1_0_4 - 0.443290043290059*G0_1_1_0_5 + 0.0913259579926279*G0_1_1_1_0 - 0.0504858104858122*G0_1_1_1_1 - 0.0104665704665708*G0_1_1_1_2 - 0.0369408369408382*G0_1_1_1_3 + 0.027089947089948*G0_1_1_1_4 + 0.142016995350334*G0_1_1_1_5 + 0.0264742664742674*G0_1_1_2_0 - 0.0104665704665708*G0_1_1_2_1 + 0.0254481321147998*G0_1_1_2_2 + 0.0574635241301928*G0_1_1_2_3 + 0.0402244668911349*G0_1_1_2_4 + 0.0640307840307863*G0_1_1_2_5 - 0.0213435946769287*G0_1_1_3_0 - 0.0369408369408382*G0_1_1_3_1 + 0.0574635241301928*G0_1_1_3_2 - 0.0197017797017808*G0_1_1_3_3 - 0.0114927048260386*G0_1_1_3_4 - 0.0853743787077149*G0_1_1_3_5 - 0.119031585698256*G0_1_1_4_0 + 0.027089947089948*G0_1_1_4_1 + 0.0402244668911349*G0_1_1_4_2 - 0.0114927048260386*G0_1_1_4_3 - 0.0886580086580114*G0_1_1_4_4 - 0.182241462241469*G0_1_1_4_5 - 0.443290043290059*G0_1_1_5_0 + 0.142016995350334*G0_1_1_5_1 + 0.0640307840307863*G0_1_1_5_2 - 0.0853743787077149*G0_1_1_5_3 - 0.182241462241469*G0_1_1_5_4 - 1.05732884399555*G0_1_1_5_5;
    A[147] = A[189] + 0.192913259579933*G0_0_1_0_0 - 0.00636203302869993*G0_0_1_0_1 - 0.0186756453423127*G0_0_1_0_2 + 0.0024627224627225*G0_0_1_0_3 + 0.0882475549142246*G0_0_1_0_4 - 0.0102613435946773*G0_0_1_0_5 - 0.00636203302869993*G0_0_1_1_0 + 0.00328362995029684*G0_0_1_1_1 - 0.000615680615680653*G0_0_1_1_2 + 0.00615680615680636*G0_0_1_1_3 - 0.0106717973384644*G0_0_1_1_4 + 0.0488439955106639*G0_0_1_1_5 - 0.0186756453423127*G0_0_1_2_0 - 0.000615680615680653*G0_0_1_2_1 + 0.00451499118165808*G0_0_1_2_2 - 0.00123136123136121*G0_0_1_2_3 - 0.0242167708834384*G0_0_1_2_4 + 0.0131345198011869*G0_0_1_2_5 + 0.0024627224627225*G0_0_1_3_0 + 0.00615680615680637*G0_0_1_3_1 - 0.00123136123136121*G0_0_1_3_2 + 0.0164181497514841*G0_0_1_3_3 + 0.0164181497514837*G0_0_1_3_4 - 0.0311944845278189*G0_0_1_3_5 + 0.0882475549142246*G0_0_1_4_0 - 0.0106717973384644*G0_0_1_4_1 - 0.0242167708834383*G0_0_1_4_2 + 0.0164181497514837*G0_0_1_4_3 + 0.16089786756454*G0_0_1_4_4 - 0.00492544492544511*G0_0_1_4_5 - 0.0102613435946773*G0_0_1_5_0 + 0.0488439955106639*G0_0_1_5_1 + 0.0131345198011869*G0_0_1_5_2 - 0.0311944845278189*G0_0_1_5_3 - 0.0049254449254451*G0_0_1_5_4 - 0.51224627224629*G0_0_1_5_5 - 0.192913259579933*G0_1_0_0_0 + 0.00636203302869993*G0_1_0_0_1 + 0.0186756453423126*G0_1_0_0_2 - 0.0024627224627225*G0_1_0_0_3 - 0.0882475549142245*G0_1_0_0_4 + 0.0102613435946773*G0_1_0_0_5 + 0.00636203302869992*G0_1_0_1_0 - 0.00328362995029684*G0_1_0_1_1 + 0.000615680615680654*G0_1_0_1_2 - 0.00615680615680636*G0_1_0_1_3 + 0.0106717973384644*G0_1_0_1_4 - 0.0488439955106639*G0_1_0_1_5 + 0.0186756453423126*G0_1_0_2_0 + 0.000615680615680654*G0_1_0_2_1 - 0.00451499118165807*G0_1_0_2_2 + 0.00123136123136121*G0_1_0_2_3 + 0.0242167708834383*G0_1_0_2_4 - 0.0131345198011869*G0_1_0_2_5 - 0.0024627224627225*G0_1_0_3_0 - 0.00615680615680637*G0_1_0_3_1 + 0.00123136123136122*G0_1_0_3_2 - 0.0164181497514841*G0_1_0_3_3 - 0.0164181497514837*G0_1_0_3_4 + 0.0311944845278189*G0_1_0_3_5 - 0.0882475549142245*G0_1_0_4_0 + 0.0106717973384644*G0_1_0_4_1 + 0.0242167708834383*G0_1_0_4_2 - 0.0164181497514837*G0_1_0_4_3 - 0.16089786756454*G0_1_0_4_4 + 0.00492544492544511*G0_1_0_4_5 + 0.0102613435946773*G0_1_0_5_0 - 0.0488439955106639*G0_1_0_5_1 - 0.0131345198011869*G0_1_0_5_2 + 0.0311944845278189*G0_1_0_5_3 + 0.00492544492544511*G0_1_0_5_4 + 0.51224627224629*G0_1_0_5_5;
    A[149] = A[147] - 0.289780343113687*G0_0_0_0_0 + 0.0102613435946773*G0_0_0_0_1 + 0.0389931056597737*G0_0_0_0_2 - 0.0328362995029671*G0_0_0_0_3 - 0.193734167067507*G0_0_0_0_4 - 0.0656725990059346*G0_0_0_0_5 + 0.0102613435946773*G0_0_0_1_0 + 0.0287317620650965*G0_0_0_1_1 - 0.0184704184704191*G0_0_0_1_2 + 0.0262690396023739*G0_0_0_1_3 + 0.00985088985089017*G0_0_0_1_4 + 0.0246272246272254*G0_0_0_1_5 + 0.0389931056597736*G0_0_0_2_0 - 0.0184704184704191*G0_0_0_2_1 + 0.0254481321147998*G0_0_0_2_2 + 0.0147763347763353*G0_0_0_2_3 + 0.0476126342793026*G0_0_0_2_4 - 0.0328362995029671*G0_0_0_3_0 + 0.0262690396023739*G0_0_0_3_1 + 0.0147763347763353*G0_0_0_3_2 + 0.51224627224629*G0_0_0_3_3 + 0.0459708193041542*G0_0_0_3_4 + 0.0656725990059347*G0_0_0_3_5 - 0.193734167067507*G0_0_0_4_0 + 0.00985088985089017*G0_0_0_4_1 + 0.0476126342793026*G0_0_0_4_2 + 0.0459708193041542*G0_0_0_4_3 - 0.197017797017803*G0_0_0_4_4 - 0.0197017797017803*G0_0_0_4_5 - 0.0656725990059346*G0_0_0_5_0 + 0.0246272246272254*G0_0_0_5_1 + 0.0656725990059347*G0_0_0_5_3 - 0.0197017797017803*G0_0_0_5_4 + 0.0131345198011873*G0_0_0_5_5 - 0.119442039442044*G0_0_1_0_0 - 0.0073881673881676*G0_0_1_0_1 + 0.00861952861952893*G0_0_1_0_2 - 0.0361199294532639*G0_0_1_0_3 - 0.0344781144781157*G0_0_1_0_4 + 0.0623889690556379*G0_0_1_0_5 - 0.0073881673881676*G0_0_1_1_0 + 0.0246272246272255*G0_0_1_1_1 - 0.0123136123136127*G0_0_1_1_2 + 0.0131345198011869*G0_0_1_1_3 - 0.0722398589065281*G0_0_1_1_5 + 0.00861952861952893*G0_0_1_2_0 - 0.0123136123136127*G0_0_1_2_1 + 0.0250376783710125*G0_0_1_2_2 - 0.0394035594035608*G0_0_1_2_5 - 0.0361199294532639*G0_0_1_3_0 + 0.0131345198011869*G0_0_1_3_1 + 0.558217091550444*G0_0_1_3_3 + 0.072239858906528*G0_0_1_3_4 + 0.15104697771365*G0_0_1_3_5 - 0.0344781144781157*G0_0_1_4_0 + 0.072239858906528*G0_0_1_4_3 - 0.0262690396023738*G0_0_1_4_4 + 0.0788071188071215*G0_0_1_4_5 + 0.0623889690556379*G0_0_1_5_0 - 0.0722398589065281*G0_0_1_5_1 - 0.0394035594035608*G0_0_1_5_2 + 0.15104697771365*G0_0_1_5_3 + 0.0788071188071215*G0_0_1_5_4 + 0.794638447971809*G0_0_1_5_5 + 0.12272566939234*G0_1_0_0_0 - 0.0197017797017804*G0_1_0_0_1 - 0.0184704184704191*G0_1_0_0_2 - 0.0213435946769287*G0_1_0_0_3 + 0.0738816738816764*G0_1_0_0_4 + 0.052538079204748*G0_1_0_0_5 - 0.0197017797017804*G0_1_0_1_0 + 0.0344781144781158*G0_1_0_1_1 - 0.013134519801187*G0_1_0_1_2 + 0.018059964726632*G0_1_0_1_3 - 0.0213435946769288*G0_1_0_1_4 + 0.00164181497514826*G0_1_0_1_5 - 0.0184704184704191*G0_1_0_2_0 - 0.013134519801187*G0_1_0_2_1 + 0.0373512906846256*G0_1_0_2_2 + 0.0131345198011872*G0_1_0_2_3 - 0.0213435946769286*G0_1_0_2_4 - 0.0246272246272255*G0_1_0_2_5 - 0.0213435946769287*G0_1_0_3_0 + 0.018059964726632*G0_1_0_3_1 + 0.0131345198011872*G0_1_0_3_2 + 0.571351611351633*G0_1_0_3_3 + 0.0853743787077151*G0_1_0_3_4 + 0.0919416386083086*G0_1_0_3_5 + 0.0738816738816764*G0_1_0_4_0 - 0.0213435946769288*G0_1_0_4_1 - 0.0213435946769286*G0_1_0_4_2 + 0.0853743787077151*G0_1_0_4_3 + 0.17074875741543*G0_1_0_4_4 + 0.0919416386083085*G0_1_0_4_5 + 0.052538079204748*G0_1_0_5_0 + 0.00164181497514826*G0_1_0_5_1 - 0.0246272246272255*G0_1_0_5_2 + 0.0919416386083086*G0_1_0_5_3 + 0.0919416386083085*G0_1_0_5_4 + 0.11164341831009*G0_1_0_5_5 + 0.293063973063984*G0_1_1_0_0 - 0.0673144139810831*G0_1_1_0_1 - 0.0172390572390579*G0_1_1_0_2 - 0.0262690396023737*G0_1_1_0_3 + 0.0525380792047477*G0_1_1_0_4 + 0.361199294532641*G0_1_1_0_5 - 0.0673144139810831*G0_1_1_1_0 + 0.0394035594035609*G0_1_1_1_1 - 0.00820907487574186*G0_1_1_1_2 - 0.0229854096520771*G0_1_1_1_4 - 0.157614237614243*G0_1_1_1_5 - 0.0172390572390579*G0_1_1_2_0 - 0.00820907487574186*G0_1_1_2_1 + 0.0369408369408383*G0_1_1_2_2 + 0.00656725990059373*G0_1_1_2_3 - 0.00656725990059344*G0_1_1_2_4 - 0.0656725990059347*G0_1_1_2_5 - 0.0262690396023737*G0_1_1_3_0 + 0.00656725990059374*G0_1_1_3_2 + 0.6041879108546*G0_1_1_3_3 + 0.098508898508902*G0_1_1_3_4 + 0.183883277216617*G0_1_1_3_5 + 0.0525380792047477*G0_1_1_4_0 - 0.0229854096520771*G0_1_1_4_1 - 0.00656725990059344*G0_1_1_4_2 + 0.098508898508902*G0_1_1_4_3 + 0.0262690396023739*G0_1_1_4_4 + 0.177316017316024*G0_1_1_4_5 + 0.361199294532641*G0_1_1_5_0 - 0.157614237614243*G0_1_1_5_1 - 0.0656725990059347*G0_1_1_5_2 + 0.183883277216617*G0_1_1_5_3 + 0.177316017316024*G0_1_1_5_4 + 1.23464486131157*G0_1_1_5_5;
    A[219] = A[149] + 0.0492544492544518*G0_0_1_0_0 - 0.00595157928491289*G0_0_1_0_1 - 0.00841430174763542*G0_0_1_0_2 + 0.0123136123136127*G0_0_1_0_3 + 0.0201122334455675*G0_0_1_0_4 + 0.000410453743787394*G0_0_1_0_5 - 0.00595157928491289*G0_0_1_1_0 + 0.00656725990059347*G0_0_1_1_1 - 0.000205226871893591*G0_0_1_1_2 - 0.00123136123136131*G0_0_1_1_3 - 0.0106717973384644*G0_0_1_1_4 + 0.0250376783710125*G0_0_1_1_5 - 0.00841430174763542*G0_0_1_2_0 - 0.00020522687189359*G0_0_1_2_1 + 0.00779862113195499*G0_0_1_2_2 + 0.0143658810325484*G0_0_1_2_3 + 0.00287317620650976*G0_0_1_2_4 + 0.00164181497514834*G0_0_1_2_5 + 0.0123136123136127*G0_0_1_3_0 - 0.00123136123136131*G0_0_1_3_1 + 0.0143658810325484*G0_0_1_3_2 - 0.00328362995029563*G0_0_1_3_3 - 0.0032836299502966*G0_0_1_3_4 - 0.0279108545775221*G0_0_1_3_5 + 0.0201122334455675*G0_0_1_4_0 - 0.0106717973384644*G0_0_1_4_1 + 0.00287317620650975*G0_0_1_4_2 - 0.0032836299502966*G0_0_1_4_3 + 0.0361199294532641*G0_0_1_4_4 + 0.0180599647266321*G0_0_1_4_5 + 0.000410453743787391*G0_0_1_5_0 + 0.0250376783710125*G0_0_1_5_1 + 0.00164181497514834*G0_0_1_5_2 - 0.0279108545775221*G0_0_1_5_3 + 0.0180599647266321*G0_0_1_5_4 - 0.170748757415429*G0_0_1_5_5 - 0.0492544492544518*G0_1_0_0_0 + 0.00595157928491289*G0_1_0_0_1 + 0.00841430174763541*G0_1_0_0_2 - 0.0123136123136127*G0_1_0_0_3 - 0.0201122334455675*G0_1_0_0_4 - 0.000410453743787394*G0_1_0_0_5 + 0.00595157928491289*G0_1_0_1_0 - 0.00656725990059347*G0_1_0_1_1 + 0.000205226871893591*G0_1_0_1_2 + 0.00123136123136131*G0_1_0_1_3 + 0.0106717973384644*G0_1_0_1_4 - 0.0250376783710125*G0_1_0_1_5 + 0.00841430174763542*G0_1_0_2_0 + 0.00020522687189359*G0_1_0_2_1 - 0.00779862113195499*G0_1_0_2_2 - 0.0143658810325484*G0_1_0_2_3 - 0.00287317620650976*G0_1_0_2_4 - 0.00164181497514834*G0_1_0_2_5 - 0.0123136123136127*G0_1_0_3_0 + 0.00123136123136131*G0_1_0_3_1 - 0.0143658810325484*G0_1_0_3_2 + 0.00328362995029563*G0_1_0_3_3 + 0.00328362995029659*G0_1_0_3_4 + 0.027910854577522*G0_1_0_3_5 - 0.0201122334455675*G0_1_0_4_0 + 0.0106717973384644*G0_1_0_4_1 - 0.00287317620650976*G0_1_0_4_2 + 0.00328362995029659*G0_1_0_4_3 - 0.0361199294532641*G0_1_0_4_4 - 0.0180599647266321*G0_1_0_4_5 - 0.000410453743787387*G0_1_0_5_0 - 0.0250376783710125*G0_1_0_5_1 - 0.00164181497514834*G0_1_0_5_2 + 0.027910854577522*G0_1_0_5_3 - 0.0180599647266321*G0_1_0_5_4 + 0.170748757415429*G0_1_0_5_5;
    A[103] = A[219] + 0.123136123136128*G0_0_0_0_0 - 0.00102613435946775*G0_0_0_0_1 - 0.0149815616482288*G0_0_0_0_2 - 0.0147763347763353*G0_0_0_0_3 + 0.111643418310089*G0_0_0_0_4 - 0.000820907487574133*G0_0_0_0_5 - 0.00102613435946775*G0_0_0_1_0 + 0.0336572069905416*G0_0_0_1_1 - 0.000205226871893606*G0_0_0_1_2 + 0.0377617444284126*G0_0_0_1_3 - 0.0114927048260385*G0_0_0_1_4 + 0.00902998236331609*G0_0_0_1_5 - 0.0149815616482288*G0_0_0_2_0 - 0.000205226871893605*G0_0_0_2_1 - 0.036530383197051*G0_0_0_2_2 - 0.0517171717171735*G0_0_0_2_3 - 0.0632098765432121*G0_0_0_2_4 + 0.00410453743787089*G0_0_0_2_5 - 0.0147763347763353*G0_0_0_3_0 + 0.0377617444284126*G0_0_0_3_1 - 0.0517171717171735*G0_0_0_3_2 + 0.0722398589065288*G0_0_0_3_3 + 0.0525380792047476*G0_0_0_3_4 + 0.0213435946769288*G0_0_0_3_5 + 0.111643418310089*G0_0_0_4_0 - 0.0114927048260385*G0_0_0_4_1 - 0.063209876543212*G0_0_0_4_2 + 0.0525380792047476*G0_0_0_4_3 + 0.374333814333827*G0_0_0_4_4 + 0.0147763347763352*G0_0_0_4_5 - 0.000820907487574134*G0_0_0_5_0 + 0.00902998236331609*G0_0_0_5_1 + 0.00410453743787089*G0_0_0_5_2 + 0.0213435946769288*G0_0_0_5_3 + 0.0147763347763352*G0_0_0_5_4 - 0.075523488856825*G0_0_0_5_5 - 0.000410453743787065*G0_0_1_0_1 + 0.000410453743787149*G0_0_1_0_2 + 0.00944043610710299*G0_0_1_0_4 - 0.00944043610710356*G0_0_1_0_5 - 0.000410453743787066*G0_0_1_1_0 + 0.0344781144781159*G0_0_1_1_1 + 0.0496649029982383*G0_0_1_1_3 - 0.000820907487574123*G0_0_1_1_4 + 0.011903158569826*G0_0_1_1_5 + 0.000410453743787149*G0_0_1_2_0 - 0.0344781144781156*G0_0_1_2_2 - 0.0496649029982382*G0_0_1_2_3 - 0.0119031585698257*G0_0_1_2_4 + 0.000820907487574177*G0_0_1_2_5 + 0.0496649029982383*G0_0_1_3_1 - 0.0496649029982382*G0_0_1_3_2 + 0.00164181497514829*G0_0_1_3_4 - 0.00164181497514831*G0_0_1_3_5 + 0.00944043610710299*G0_0_1_4_0 - 0.000820907487574125*G0_0_1_4_1 - 0.0119031585698257*G0_0_1_4_2 + 0.00164181497514829*G0_0_1_4_3 + 0.0558217091550443*G0_0_1_4_4 - 0.00944043610710356*G0_0_1_5_0 + 0.011903158569826*G0_0_1_5_1 + 0.000820907487574177*G0_0_1_5_2 - 0.00164181497514831*G0_0_1_5_3 - 0.0558217091550444*G0_0_1_5_5 + 0.00205226871893546*G0_1_0_0_1 - 0.00205226871893549*G0_1_0_0_2 + 0.0291422158088836*G0_1_0_0_4 - 0.0291422158088836*G0_1_0_0_5 + 0.00205226871893546*G0_1_0_1_0 + 0.0332467532467543*G0_1_0_1_1 + 0.0340676607343285*G0_1_0_1_3 - 0.0131345198011869*G0_1_0_1_4 + 0.0340676607343286*G0_1_0_1_5 - 0.00205226871893549*G0_1_0_2_0 - 0.0332467532467541*G0_1_0_2_2 - 0.0340676607343285*G0_1_0_2_3 - 0.0340676607343285*G0_1_0_2_4 + 0.0131345198011869*G0_1_0_2_5 + 0.0340676607343285*G0_1_0_3_1 - 0.0340676607343284*G0_1_0_3_2 + 0.0262690396023738*G0_1_0_3_4 - 0.0262690396023738*G0_1_0_3_5 + 0.0291422158088836*G0_1_0_4_0 - 0.0131345198011869*G0_1_0_4_1 - 0.0340676607343285*G0_1_0_4_2 + 0.0262690396023738*G0_1_0_4_3 + 0.262690396023738*G0_1_0_4_4 - 0.0291422158088836*G0_1_0_5_0 + 0.0340676607343286*G0_1_0_5_1 + 0.0131345198011869*G0_1_0_5_2 - 0.0262690396023738*G0_1_0_5_3 - 0.262690396023738*G0_1_0_5_5 - 0.123136123136127*G0_1_1_0_0 + 0.0149815616482288*G0_1_1_0_1 + 0.00102613435946773*G0_1_1_0_2 + 0.0147763347763353*G0_1_1_0_3 + 0.00082090748757427*G0_1_1_0_4 - 0.111643418310089*G0_1_1_0_5 + 0.0149815616482288*G0_1_1_1_0 + 0.0365303831970511*G0_1_1_1_1 + 0.00020522687189355*G0_1_1_1_2 + 0.0517171717171735*G0_1_1_1_3 - 0.00410453743787089*G0_1_1_1_4 + 0.0632098765432123*G0_1_1_1_5 + 0.00102613435946773*G0_1_1_2_0 + 0.00020522687189355*G0_1_1_2_1 - 0.0336572069905414*G0_1_1_2_2 - 0.0377617444284125*G0_1_1_2_3 - 0.00902998236331604*G0_1_1_2_4 + 0.0114927048260385*G0_1_1_2_5 + 0.0147763347763353*G0_1_1_3_0 + 0.0517171717171735*G0_1_1_3_1 - 0.0377617444284125*G0_1_1_3_2 - 0.0722398589065286*G0_1_1_3_3 - 0.0213435946769288*G0_1_1_3_4 - 0.0525380792047476*G0_1_1_3_5 + 0.000820907487574267*G0_1_1_4_0 - 0.00410453743787089*G0_1_1_4_1 - 0.00902998236331604*G0_1_1_4_2 - 0.0213435946769288*G0_1_1_4_3 + 0.0755234888568248*G0_1_1_4_4 - 0.0147763347763353*G0_1_1_4_5 - 0.111643418310089*G0_1_1_5_0 + 0.0632098765432123*G0_1_1_5_1 + 0.0114927048260385*G0_1_1_5_2 - 0.0525380792047476*G0_1_1_5_3 - 0.0147763347763353*G0_1_1_5_4 - 0.374333814333827*G0_1_1_5_5;
    A[57] = A[103] - 0.0484335417668768*G0_0_0_0_0 + 0.00738816738816764*G0_0_0_0_2 + 0.0082090748757418*G0_0_0_0_3 - 0.0656725990059347*G0_0_0_0_4 + 0.0172390572390577*G0_0_0_0_5 + 0.0484335417668767*G0_0_0_1_1 - 0.0073881673881676*G0_0_0_1_2 + 0.0656725990059346*G0_0_0_1_3 - 0.00820907487574181*G0_0_0_1_4 - 0.0172390572390577*G0_0_0_1_5 + 0.00738816738816764*G0_0_0_2_0 - 0.0073881673881676*G0_0_0_2_1 - 0.0279108545775224*G0_0_0_2_3 + 0.0279108545775223*G0_0_0_2_4 + 0.0082090748757418*G0_0_0_3_0 + 0.0656725990059346*G0_0_0_3_1 - 0.0279108545775224*G0_0_0_3_2 + 0.0788071188071212*G0_0_0_3_3 - 0.0164181497514835*G0_0_0_3_5 - 0.0656725990059347*G0_0_0_4_0 - 0.00820907487574181*G0_0_0_4_1 + 0.0279108545775223*G0_0_0_4_2 - 0.0788071188071218*G0_0_0_4_4 + 0.0164181497514837*G0_0_0_4_5 + 0.0172390572390577*G0_0_0_5_0 - 0.0172390572390577*G0_0_0_5_1 - 0.0164181497514835*G0_0_0_5_3 + 0.0164181497514837*G0_0_0_5_4 - 0.0316049382716057*G0_0_1_0_0 + 0.0119031585698256*G0_0_1_0_1 + 0.00492544492544507*G0_0_1_0_2 - 0.000820907487574187*G0_0_1_0_3 - 0.0295526695526705*G0_0_1_0_4 - 0.0090299823633159*G0_0_1_0_5 + 0.0119031585698256*G0_0_1_1_0 + 0.0168286034952705*G0_0_1_1_1 - 0.00246272246272249*G0_0_1_1_2 + 0.036119929453264*G0_0_1_1_3 - 0.00902998236331604*G0_0_1_1_4 - 0.026269039602374*G0_0_1_1_5 + 0.00492544492544507*G0_0_1_2_0 - 0.00246272246272249*G0_0_1_2_1 + 0.0114927048260383*G0_0_1_2_2 - 0.0270899470899483*G0_0_1_2_3 + 0.000820907487574124*G0_0_1_2_4 + 0.0123136123136127*G0_0_1_2_5 - 0.000820907487574189*G0_0_1_3_0 + 0.036119929453264*G0_0_1_3_1 - 0.0270899470899482*G0_0_1_3_2 + 0.0492544492544507*G0_0_1_3_3 + 0.0197017797017805*G0_0_1_3_4 - 0.022985409652077*G0_0_1_3_5 - 0.0295526695526705*G0_0_1_4_0 - 0.00902998236331604*G0_0_1_4_1 + 0.000820907487574124*G0_0_1_4_2 + 0.0197017797017805*G0_0_1_4_3 - 0.0295526695526702*G0_0_1_4_4 - 0.00656725990059329*G0_0_1_4_5 - 0.0090299823633159*G0_0_1_5_0 - 0.026269039602374*G0_0_1_5_1 + 0.0123136123136127*G0_0_1_5_2 - 0.022985409652077*G0_0_1_5_3 - 0.00656725990059328*G0_0_1_5_4 - 0.0558217091550448*G0_0_1_5_5 + 0.0254481321147999*G0_1_0_0_0 - 0.00492544492544515*G0_1_0_0_1 - 0.00123136123136127*G0_1_0_0_2 + 0.0131345198011868*G0_1_0_0_3 - 0.0147763347763353*G0_1_0_0_4 + 0.0139554272887612*G0_1_0_0_5 - 0.00492544492544515*G0_1_0_1_0 + 0.0738816738816771*G0_1_0_1_1 - 0.00861952861952893*G0_1_0_1_2 + 0.0508962642295995*G0_1_0_1_3 + 0.00492544492544508*G0_1_0_1_4 - 0.00328362995029653*G0_1_0_1_5 - 0.00123136123136127*G0_1_0_2_0 - 0.00861952861952893*G0_1_0_2_1 + 0.0246272246272253*G0_1_0_2_2 - 0.00328362995029692*G0_1_0_2_3 + 0.0246272246272255*G0_1_0_2_4 - 0.00902998236331606*G0_1_0_2_5 + 0.0131345198011868*G0_1_0_3_0 + 0.0508962642295995*G0_1_0_3_1 - 0.00328362995029692*G0_1_0_3_2 - 0.124777938111276*G0_1_0_3_3 - 0.0361199294532639*G0_1_0_3_4 - 0.00820907487574163*G0_1_0_3_5 - 0.0147763347763353*G0_1_0_4_0 + 0.00492544492544508*G0_1_0_4_1 + 0.0246272246272255*G0_1_0_4_2 - 0.0361199294532639*G0_1_0_4_3 - 0.203585056918397*G0_1_0_4_4 + 0.00820907487574196*G0_1_0_4_5 + 0.0139554272887612*G0_1_0_5_0 - 0.00328362995029653*G0_1_0_5_1 - 0.00902998236331606*G0_1_0_5_2 - 0.00820907487574163*G0_1_0_5_3 + 0.00820907487574196*G0_1_0_5_4 + 0.016418149751484*G0_1_0_5_5 + 0.0615680615680631*G0_1_1_0_0 + 0.0034888568221903*G0_1_1_0_1 - 0.00225749559082897*G0_1_1_0_2 + 0.00492544492544502*G0_1_1_0_3 + 0.0106717973384642*G0_1_1_0_4 + 0.0344781144781156*G0_1_1_0_5 + 0.0034888568221903*G0_1_1_1_0 - 0.0192913259579934*G0_1_1_1_1 - 0.0014365881032548*G0_1_1_1_2 + 0.0106717973384644*G0_1_1_1_3 - 0.000820907487574191*G0_1_1_1_4 - 0.0467917267917285*G0_1_1_1_5 - 0.00225749559082897*G0_1_1_2_0 - 0.0014365881032548*G0_1_1_2_1 + 0.0180599647266318*G0_1_1_2_2 - 0.00246272246272254*G0_1_1_2_4 + 0.00164181497514834*G0_1_1_2_5 + 0.00492544492544502*G0_1_1_3_0 + 0.0106717973384644*G0_1_1_3_1 - 0.111643418310089*G0_1_1_3_3 - 0.00820907487574172*G0_1_1_3_4 - 0.0131345198011868*G0_1_1_3_5 + 0.0106717973384642*G0_1_1_4_0 - 0.000820907487574191*G0_1_1_4_1 - 0.00246272246272254*G0_1_1_4_2 - 0.00820907487574172*G0_1_1_4_3 - 0.0426871893538574*G0_1_1_4_4 - 0.00164181497514829*G0_1_1_4_5 + 0.0344781144781156*G0_1_1_5_0 - 0.0467917267917285*G0_1_1_5_1 + 0.00164181497514834*G0_1_1_5_2 - 0.0131345198011868*G0_1_1_5_3 - 0.00164181497514829*G0_1_1_5_4 - 0.0197017797017809*G0_1_1_5_5;
    A[201] = A[103] - 0.0492544492544508*G0_0_1_0_0 + 0.00841430174763542*G0_0_1_0_1 + 0.00595157928491278*G0_0_1_0_2 - 0.0123136123136127*G0_0_1_0_3 - 0.000410453743786954*G0_0_1_0_4 - 0.0201122334455674*G0_0_1_0_5 + 0.00841430174763542*G0_0_1_1_0 - 0.0077986211319551*G0_0_1_1_1 + 0.000205226871893603*G0_0_1_1_2 - 0.0143658810325484*G0_0_1_1_3 - 0.00164181497514839*G0_0_1_1_4 - 0.00287317620650992*G0_0_1_1_5 + 0.00595157928491278*G0_0_1_2_0 + 0.000205226871893602*G0_0_1_2_1 - 0.0065672599005935*G0_0_1_2_2 + 0.00123136123136135*G0_0_1_2_3 - 0.0250376783710126*G0_0_1_2_4 + 0.0106717973384644*G0_0_1_2_5 - 0.0123136123136127*G0_0_1_3_0 - 0.0143658810325484*G0_0_1_3_1 + 0.00123136123136136*G0_0_1_3_2 + 0.00328362995029585*G0_0_1_3_3 + 0.0279108545775221*G0_0_1_3_4 + 0.00328362995029658*G0_0_1_3_5 - 0.00041045374378694*G0_0_1_4_0 - 0.00164181497514839*G0_0_1_4_1 - 0.0250376783710126*G0_0_1_4_2 + 0.0279108545775221*G0_0_1_4_3 + 0.17074875741543*G0_0_1_4_4 - 0.018059964726632*G0_0_1_4_5 - 0.0201122334455674*G0_0_1_5_0 - 0.00287317620650992*G0_0_1_5_1 + 0.0106717973384644*G0_0_1_5_2 + 0.00328362995029658*G0_0_1_5_3 - 0.018059964726632*G0_0_1_5_4 - 0.0361199294532647*G0_0_1_5_5 + 0.0492544492544508*G0_1_0_0_0 - 0.00841430174763542*G0_1_0_0_1 - 0.00595157928491278*G0_1_0_0_2 + 0.0123136123136127*G0_1_0_0_3 + 0.000410453743786933*G0_1_0_0_4 + 0.0201122334455674*G0_1_0_0_5 - 0.00841430174763542*G0_1_0_1_0 + 0.0077986211319551*G0_1_0_1_1 - 0.000205226871893602*G0_1_0_1_2 + 0.0143658810325484*G0_1_0_1_3 + 0.00164181497514839*G0_1_0_1_4 + 0.00287317620650992*G0_1_0_1_5 - 0.00595157928491278*G0_1_0_2_0 - 0.000205226871893602*G0_1_0_2_1 + 0.0065672599005935*G0_1_0_2_2 - 0.00123136123136135*G0_1_0_2_3 + 0.0250376783710126*G0_1_0_2_4 - 0.0106717973384644*G0_1_0_2_5 + 0.0123136123136127*G0_1_0_3_0 + 0.0143658810325484*G0_1_0_3_1 - 0.00123136123136136*G0_1_0_3_2 - 0.00328362995029591*G0_1_0_3_3 - 0.0279108545775221*G0_1_0_3_4 - 0.00328362995029658*G0_1_0_3_5 + 0.000410453743786933*G0_1_0_4_0 + 0.00164181497514839*G0_1_0_4_1 + 0.0250376783710126*G0_1_0_4_2 - 0.0279108545775221*G0_1_0_4_3 - 0.17074875741543*G0_1_0_4_4 + 0.018059964726632*G0_1_0_4_5 + 0.0201122334455674*G0_1_0_5_0 + 0.00287317620650992*G0_1_0_5_1 - 0.0106717973384644*G0_1_0_5_2 - 0.00328362995029658*G0_1_0_5_3 + 0.018059964726632*G0_1_0_5_4 + 0.0361199294532647*G0_1_0_5_5;
    A[177] = -A[57] + 0.118210678210682*G0_0_0_0_0 + 0.00472021805355155*G0_0_0_0_1 - 0.0272951739618415*G0_0_0_0_2 + 0.00328362995029667*G0_0_0_0_3 + 0.126419753086424*G0_0_0_0_4 + 0.041045374378709*G0_0_0_0_5 + 0.00472021805355155*G0_0_0_1_0 - 0.012313612313613*G0_0_0_1_1 + 0.00389931056597734*G0_0_0_1_2 + 0.0164181497514838*G0_0_0_1_3 - 0.0394035594035607*G0_0_0_1_4 - 0.0410453743787091*G0_0_0_1_5 - 0.0272951739618415*G0_0_0_2_0 + 0.00389931056597734*G0_0_0_2_1 - 0.0184704184704191*G0_0_0_2_2 - 0.0287317620650965*G0_0_0_2_3 - 0.0566426166426184*G0_0_0_2_4 + 0.0188808722142061*G0_0_0_2_5 + 0.00328362995029667*G0_0_0_3_0 + 0.0164181497514838*G0_0_0_3_1 - 0.0287317620650965*G0_0_0_3_2 + 0.242988616321959*G0_0_0_3_3 + 0.072239858906528*G0_0_0_3_4 - 0.0443290043290056*G0_0_0_3_5 + 0.126419753086424*G0_0_0_4_0 - 0.0394035594035607*G0_0_0_4_1 - 0.0566426166426184*G0_0_0_4_2 + 0.072239858906528*G0_0_0_4_3 + 0.623889690556377*G0_0_0_4_4 + 0.0410453743787091*G0_0_0_4_5 + 0.041045374378709*G0_0_0_5_0 - 0.0410453743787091*G0_0_0_5_1 + 0.0188808722142061*G0_0_0_5_2 - 0.0443290043290056*G0_0_0_5_3 + 0.0410453743787091*G0_0_0_5_4 - 0.187166907166914*G0_0_0_5_5 - 0.0119031585698255*G0_0_1_0_0 + 0.0205226871893545*G0_0_1_0_1 - 0.000820907487574167*G0_0_1_0_2 - 0.000820907487574239*G0_0_1_0_3 - 0.0155972422639095*G0_0_1_0_4 - 0.0500753567420252*G0_0_1_0_5 + 0.0205226871893545*G0_0_1_1_0 + 0.00410453743787088*G0_0_1_1_2 + 0.00820907487574208*G0_0_1_1_3 - 0.0246272246272255*G0_0_1_1_4 - 0.00820907487574162*G0_0_1_1_5 - 0.000820907487574167*G0_0_1_2_0 + 0.00410453743787088*G0_0_1_2_1 - 0.0094404361071031*G0_0_1_2_2 - 0.0254481321147999*G0_0_1_2_3 - 0.00574635241301933*G0_0_1_2_4 + 0.0238063171396512*G0_0_1_2_5 - 0.000820907487574241*G0_0_1_3_0 + 0.00820907487574208*G0_0_1_3_1 - 0.0254481321147999*G0_0_1_3_2 + 0.193734167067508*G0_0_1_3_3 + 0.0508962642295995*G0_0_1_3_4 - 0.0459708193041538*G0_0_1_3_5 - 0.0155972422639095*G0_0_1_4_0 - 0.0246272246272255*G0_0_1_4_1 - 0.00574635241301933*G0_0_1_4_2 + 0.0508962642295995*G0_0_1_4_3 + 0.0656725990059352*G0_0_1_4_4 + 0.00164181497514857*G0_0_1_4_5 - 0.0500753567420252*G0_0_1_5_0 - 0.00820907487574161*G0_0_1_5_1 + 0.0238063171396512*G0_0_1_5_2 - 0.0459708193041538*G0_0_1_5_3 + 0.00164181497514857*G0_0_1_5_4 - 0.101792528459198*G0_0_1_5_5;
    A[191] = A[177] + 0.0041045374378707*G0_0_1_0_0 - 0.0121083854417191*G0_0_1_0_1 + 0.00102613435946772*G0_0_1_0_2 - 0.000820907487574095*G0_0_1_0_3 + 0.00123136123136127*G0_0_1_0_4 + 0.0472021805355155*G0_0_1_0_5 - 0.0121083854417191*G0_0_1_1_0 - 0.0492544492544516*G0_0_1_1_1 + 0.00184704184704196*G0_0_1_1_2 - 0.0086195286195291*G0_0_1_1_3 + 0.0123136123136128*G0_0_1_1_4 - 0.0119031585698259*G0_0_1_1_5 + 0.00102613435946772*G0_0_1_2_0 + 0.00184704184704196*G0_0_1_2_1 + 0.0028731762065096*G0_0_1_2_2 + 0.000410453743787152*G0_0_1_2_3 + 0.00697771364438056*G0_0_1_2_4 - 0.0131345198011868*G0_0_1_2_5 - 0.000820907487574094*G0_0_1_3_0 - 0.00861952861952912*G0_0_1_3_1 + 0.000410453743787152*G0_0_1_3_2 - 0.0229854096520778*G0_0_1_3_3 - 0.0229854096520773*G0_0_1_3_4 + 0.0279108545775218*G0_0_1_3_5 + 0.00123136123136127*G0_0_1_4_0 + 0.0123136123136128*G0_0_1_4_1 + 0.00697771364438056*G0_0_1_4_2 - 0.0229854096520773*G0_0_1_4_3 - 0.0623889690556381*G0_0_1_4_4 + 0.00164181497514818*G0_0_1_4_5 + 0.0472021805355155*G0_0_1_5_0 - 0.0119031585698259*G0_0_1_5_1 - 0.0131345198011868*G0_0_1_5_2 + 0.0279108545775218*G0_0_1_5_3 + 0.00164181497514818*G0_0_1_5_4 + 0.0656725990059341*G0_0_1_5_5 - 0.00410453743787071*G0_1_0_0_0 + 0.0121083854417191*G0_1_0_0_1 - 0.00102613435946772*G0_1_0_0_2 + 0.000820907487574096*G0_1_0_0_3 - 0.00123136123136127*G0_1_0_0_4 - 0.0472021805355155*G0_1_0_0_5 + 0.0121083854417191*G0_1_0_1_0 + 0.0492544492544516*G0_1_0_1_1 - 0.00184704184704197*G0_1_0_1_2 + 0.00861952861952912*G0_1_0_1_3 - 0.0123136123136128*G0_1_0_1_4 + 0.0119031585698259*G0_1_0_1_5 - 0.00102613435946772*G0_1_0_2_0 - 0.00184704184704197*G0_1_0_2_1 - 0.0028731762065096*G0_1_0_2_2 - 0.000410453743787158*G0_1_0_2_3 - 0.00697771364438056*G0_1_0_2_4 + 0.0131345198011868*G0_1_0_2_5 + 0.000820907487574093*G0_1_0_3_0 + 0.00861952861952912*G0_1_0_3_1 - 0.000410453743787152*G0_1_0_3_2 + 0.0229854096520778*G0_1_0_3_3 + 0.0229854096520773*G0_1_0_3_4 - 0.0279108545775218*G0_1_0_3_5 - 0.00123136123136127*G0_1_0_4_0 - 0.0123136123136128*G0_1_0_4_1 - 0.00697771364438056*G0_1_0_4_2 + 0.0229854096520773*G0_1_0_4_3 + 0.0623889690556381*G0_1_0_4_4 - 0.00164181497514818*G0_1_0_4_5 - 0.0472021805355155*G0_1_0_5_0 + 0.0119031585698259*G0_1_0_5_1 + 0.0131345198011868*G0_1_0_5_2 - 0.0279108545775218*G0_1_0_5_3 - 0.00164181497514818*G0_1_0_5_4 - 0.0656725990059341*G0_1_0_5_5;
    A[132] = A[191] - 0.105076158409495*G0_0_0_0_0 - 0.00348885682219029*G0_0_0_0_1 + 0.0162129228795901*G0_0_0_0_2 - 0.0147763347763352*G0_0_0_0_3 - 0.114927048260385*G0_0_0_0_4 - 0.0352990219656898*G0_0_0_0_5 - 0.00348885682219029*G0_0_0_1_0 + 0.0763443963443993*G0_0_0_1_1 - 0.0100561167227837*G0_0_0_1_2 + 0.0870161936828634*G0_0_0_1_3 + 0.018059964726632*G0_0_0_1_4 + 0.03529902196569*G0_0_0_1_5 + 0.0162129228795901*G0_0_0_2_0 - 0.0100561167227837*G0_0_0_2_1 + 0.00123136123136081*G0_0_0_2_2 - 0.061568061568064*G0_0_0_2_3 + 0.0681353214686568*G0_0_0_2_4 - 0.0139554272887611*G0_0_0_2_5 - 0.0147763347763352*G0_0_0_3_0 + 0.0870161936828634*G0_0_0_3_1 - 0.061568061568064*G0_0_0_3_2 + 0.0197017797017793*G0_0_0_3_3 - 0.00656725990059358*G0_0_0_3_4 + 0.0574635241301927*G0_0_0_3_5 - 0.114927048260385*G0_0_0_4_0 + 0.018059964726632*G0_0_0_4_1 + 0.0681353214686568*G0_0_0_4_2 - 0.00656725990059358*G0_0_0_4_3 - 0.308661215327892*G0_0_0_4_4 - 0.00820907487574178*G0_0_0_4_5 - 0.0352990219656898*G0_0_0_5_0 + 0.03529902196569*G0_0_0_5_1 - 0.0139554272887611*G0_0_0_5_2 + 0.0574635241301927*G0_0_0_5_3 - 0.00820907487574179*G0_0_0_5_4 + 0.154330607663946*G0_0_0_5_5 - 0.0016418149751484*G0_0_1_0_1 + 0.00164181497514836*G0_0_1_0_2 + 0.000410453743787103*G0_0_1_0_4 - 0.000410453743787086*G0_0_1_0_5 - 0.0016418149751484*G0_0_1_1_0 + 0.0825012025012059*G0_0_1_1_1 + 0.0882475549142248*G0_0_1_1_3 + 0.000820907487574188*G0_0_1_1_4 + 0.0061568061568065*G0_0_1_1_5 + 0.00164181497514836*G0_0_1_2_0 - 0.0825012025012057*G0_0_1_2_2 - 0.0882475549142249*G0_0_1_2_3 - 0.0061568061568064*G0_0_1_2_4 - 0.00082090748757427*G0_0_1_2_5 + 0.0882475549142248*G0_0_1_3_1 - 0.0882475549142249*G0_0_1_3_2 - 0.00164181497514835*G0_0_1_3_4 + 0.00164181497514855*G0_0_1_3_5 + 0.000410453743787103*G0_0_1_4_0 + 0.000820907487574189*G0_0_1_4_1 - 0.0061568061568064*G0_0_1_4_2 - 0.00164181497514835*G0_0_1_4_3 + 0.0426871893538574*G0_0_1_4_4 - 0.00041045374378708*G0_0_1_5_0 + 0.0061568061568065*G0_0_1_5_1 - 0.000820907487574269*G0_0_1_5_2 + 0.00164181497514855*G0_0_1_5_3 - 0.042687189353857*G0_0_1_5_5 - 0.0147763347763352*G0_1_0_0_1 + 0.0147763347763353*G0_1_0_0_2 - 0.0455603655603671*G0_1_0_0_4 + 0.0455603655603671*G0_1_0_0_5 - 0.0147763347763352*G0_1_0_1_0 + 0.0303735770402446*G0_1_0_1_1 + 0.0792175725509086*G0_1_0_1_3 + 0.0262690396023739*G0_1_0_1_4 - 0.0127240660573999*G0_1_0_1_5 + 0.0147763347763353*G0_1_0_2_0 - 0.0303735770402451*G0_1_0_2_2 - 0.0792175725509088*G0_1_0_2_3 + 0.0127240660573998*G0_1_0_2_4 - 0.0262690396023738*G0_1_0_2_5 + 0.0792175725509086*G0_1_0_3_1 - 0.0792175725509088*G0_1_0_3_2 - 0.0525380792047478*G0_1_0_3_4 + 0.0525380792047474*G0_1_0_3_5 - 0.0455603655603671*G0_1_0_4_0 + 0.0262690396023739*G0_1_0_4_1 + 0.0127240660573998*G0_1_0_4_2 - 0.0525380792047478*G0_1_0_4_3 - 0.0853743787077147*G0_1_0_4_4 + 0.0455603655603671*G0_1_0_5_0 - 0.0127240660573999*G0_1_0_5_1 - 0.0262690396023738*G0_1_0_5_2 + 0.0525380792047474*G0_1_0_5_3 + 0.0853743787077144*G0_1_0_5_5 + 0.105076158409496*G0_1_1_0_0 - 0.0162129228795901*G0_1_1_0_1 + 0.00348885682219026*G0_1_1_0_2 + 0.0147763347763352*G0_1_1_0_3 + 0.0352990219656898*G0_1_1_0_4 + 0.114927048260386*G0_1_1_0_5 - 0.0162129228795901*G0_1_1_1_0 - 0.00123136123136138*G0_1_1_1_1 + 0.0100561167227838*G0_1_1_1_2 + 0.0615680615680637*G0_1_1_1_3 + 0.0139554272887611*G0_1_1_1_4 - 0.0681353214686572*G0_1_1_1_5 + 0.00348885682219026*G0_1_1_2_0 + 0.0100561167227838*G0_1_1_2_1 - 0.0763443963443993*G0_1_1_2_2 - 0.0870161936828636*G0_1_1_2_3 - 0.0352990219656899*G0_1_1_2_4 - 0.0180599647266321*G0_1_1_2_5 + 0.0147763347763352*G0_1_1_3_0 + 0.0615680615680637*G0_1_1_3_1 - 0.0870161936828636*G0_1_1_3_2 - 0.0197017797017808*G0_1_1_3_3 - 0.0574635241301927*G0_1_1_3_4 + 0.00656725990059353*G0_1_1_3_5 + 0.0352990219656898*G0_1_1_4_0 + 0.0139554272887611*G0_1_1_4_1 - 0.0352990219656899*G0_1_1_4_2 - 0.0574635241301927*G0_1_1_4_3 - 0.154330607663946*G0_1_1_4_4 + 0.00820907487574192*G0_1_1_4_5 + 0.114927048260386*G0_1_1_5_0 - 0.0681353214686572*G0_1_1_5_1 - 0.0180599647266321*G0_1_1_5_2 + 0.00656725990059353*G0_1_1_5_3 + 0.00820907487574192*G0_1_1_5_4 + 0.308661215327893*G0_1_1_5_5;
    A[188] = A[132] - 0.00410453743787101*G0_0_1_0_0 - 0.00102613435946771*G0_0_1_0_1 + 0.0121083854417192*G0_0_1_0_2 + 0.000820907487574193*G0_0_1_0_3 - 0.0472021805355155*G0_0_1_0_4 - 0.0012313612313613*G0_0_1_0_5 - 0.00102613435946771*G0_0_1_1_0 - 0.00287317620650962*G0_0_1_1_1 - 0.00184704184704191*G0_0_1_1_2 - 0.000410453743787138*G0_0_1_1_3 + 0.0131345198011869*G0_0_1_1_4 - 0.00697771364438051*G0_0_1_1_5 + 0.0121083854417192*G0_0_1_2_0 - 0.00184704184704191*G0_0_1_2_1 + 0.0492544492544509*G0_0_1_2_2 + 0.00861952861952898*G0_0_1_2_3 + 0.0119031585698256*G0_0_1_2_4 - 0.0123136123136127*G0_0_1_2_5 + 0.00082090748757419*G0_0_1_3_0 - 0.000410453743787138*G0_0_1_3_1 + 0.00861952861952898*G0_0_1_3_2 + 0.022985409652077*G0_0_1_3_3 - 0.0279108545775222*G0_0_1_3_4 + 0.022985409652077*G0_0_1_3_5 - 0.0472021805355155*G0_0_1_4_0 + 0.0131345198011869*G0_0_1_4_1 + 0.0119031585698256*G0_0_1_4_2 - 0.0279108545775222*G0_0_1_4_3 - 0.065672599005934*G0_0_1_4_4 - 0.00164181497514842*G0_0_1_4_5 - 0.0012313612313613*G0_0_1_5_0 - 0.00697771364438051*G0_0_1_5_1 - 0.0123136123136127*G0_0_1_5_2 + 0.022985409652077*G0_0_1_5_3 - 0.00164181497514843*G0_0_1_5_4 + 0.0623889690556373*G0_0_1_5_5 + 0.004104537437871*G0_1_0_0_0 + 0.00102613435946771*G0_1_0_0_1 - 0.0121083854417192*G0_1_0_0_2 - 0.000820907487574191*G0_1_0_0_3 + 0.0472021805355155*G0_1_0_0_4 + 0.00123136123136129*G0_1_0_0_5 + 0.00102613435946771*G0_1_0_1_0 + 0.00287317620650962*G0_1_0_1_1 + 0.00184704184704191*G0_1_0_1_2 + 0.000410453743787138*G0_1_0_1_3 - 0.0131345198011869*G0_1_0_1_4 + 0.00697771364438051*G0_1_0_1_5 - 0.0121083854417192*G0_1_0_2_0 + 0.00184704184704191*G0_1_0_2_1 - 0.0492544492544509*G0_1_0_2_2 - 0.00861952861952898*G0_1_0_2_3 - 0.0119031585698256*G0_1_0_2_4 + 0.0123136123136127*G0_1_0_2_5 - 0.000820907487574191*G0_1_0_3_0 + 0.000410453743787138*G0_1_0_3_1 - 0.00861952861952898*G0_1_0_3_2 - 0.022985409652077*G0_1_0_3_3 + 0.0279108545775222*G0_1_0_3_4 - 0.022985409652077*G0_1_0_3_5 + 0.0472021805355155*G0_1_0_4_0 - 0.0131345198011869*G0_1_0_4_1 - 0.0119031585698256*G0_1_0_4_2 + 0.0279108545775222*G0_1_0_4_3 + 0.065672599005934*G0_1_0_4_4 + 0.00164181497514842*G0_1_0_4_5 + 0.0012313612313613*G0_1_0_5_0 + 0.00697771364438051*G0_1_0_5_1 + 0.0123136123136127*G0_1_0_5_2 - 0.022985409652077*G0_1_0_5_3 + 0.00164181497514842*G0_1_0_5_4 - 0.0623889690556373*G0_1_0_5_5;
    A[104] = A[132] + 0.0492544492544509*G0_0_0_0_0 - 0.00246272246272255*G0_0_0_0_1 - 0.0123136123136128*G0_0_0_0_2 - 0.00985088985089019*G0_0_0_0_3 + 0.00164181497514815*G0_0_0_0_4 + 0.0188808722142062*G0_0_0_0_5 - 0.00246272246272255*G0_0_0_1_0 + 0.00902998236331605*G0_0_0_1_1 - 0.0279108545775223*G0_0_0_1_2 - 0.0508962642295995*G0_0_0_1_3 - 0.00328362995029678*G0_0_0_1_4 - 0.00574635241301929*G0_0_0_1_5 - 0.0123136123136128*G0_0_0_2_0 - 0.0279108545775223*G0_0_0_2_1 + 0.110822510822516*G0_0_0_2_2 + 0.152688792688799*G0_0_0_2_3 + 0.0443290043290062*G0_0_0_2_4 + 0.00328362995029678*G0_0_0_2_5 - 0.00985088985089019*G0_0_0_3_0 - 0.0508962642295995*G0_0_0_3_1 + 0.152688792688799*G0_0_0_3_2 + 0.446573673240357*G0_0_0_3_3 + 0.0262690396023741*G0_0_0_3_4 + 0.0131345198011871*G0_0_0_3_5 + 0.00164181497514815*G0_0_0_4_0 - 0.00328362995029678*G0_0_0_4_1 + 0.0443290043290062*G0_0_0_4_2 + 0.0262690396023741*G0_0_0_4_3 - 0.105076158409495*G0_0_0_4_4 + 0.0188808722142062*G0_0_0_5_0 - 0.00574635241301929*G0_0_0_5_1 + 0.00328362995029678*G0_0_0_5_2 + 0.0131345198011871*G0_0_0_5_3 + 0.00656725990059366*G0_0_0_5_5 + 0.0131345198011869*G0_0_1_0_0 + 0.0026679493346161*G0_0_1_0_1 - 0.000205226871893515*G0_0_1_0_2 - 0.0262690396023738*G0_0_1_0_3 - 0.027089947089948*G0_0_1_0_4 + 0.00164181497514836*G0_0_1_0_5 + 0.0026679493346161*G0_0_1_1_0 + 0.00615680615680633*G0_0_1_1_1 - 0.0359147025813705*G0_0_1_1_2 - 0.0599262465929155*G0_0_1_1_3 + 0.00985088985089017*G0_0_1_1_4 - 0.00410453743787096*G0_0_1_1_5 - 0.000205226871893515*G0_0_1_2_0 - 0.0359147025813705*G0_0_1_2_1 + 0.192092352092359*G0_0_1_2_2 + 0.177316017316024*G0_0_1_2_3 + 0.0377617444284124*G0_0_1_2_4 + 0.00820907487574189*G0_0_1_2_5 - 0.0262690396023738*G0_0_1_3_0 - 0.0599262465929155*G0_0_1_3_1 + 0.177316017316024*G0_0_1_3_2 + 0.499111752445104*G0_0_1_3_3 + 0.0328362995029674*G0_0_1_3_4 + 0.0361199294532641*G0_0_1_3_5 - 0.027089947089948*G0_0_1_4_0 + 0.00985088985089017*G0_0_1_4_1 + 0.0377617444284124*G0_0_1_4_2 + 0.0328362995029674*G0_0_1_4_3 - 0.17074875741543*G0_0_1_4_4 - 0.036119929453264*G0_0_1_4_5 + 0.00164181497514835*G0_0_1_5_0 - 0.00410453743787096*G0_0_1_5_1 + 0.0082090748757419*G0_0_1_5_2 + 0.0361199294532641*G0_0_1_5_3 - 0.036119929453264*G0_0_1_5_4 + 0.03940355940356*G0_0_1_5_5 - 0.0320153920153937*G0_1_0_0_0 + 0.00554112554112576*G0_1_0_0_1 - 0.0244219977553319*G0_1_0_0_2 - 0.0147763347763353*G0_1_0_0_3 + 0.00820907487574168*G0_1_0_0_4 - 0.00574635241301958*G0_1_0_0_5 + 0.00554112554112576*G0_1_0_1_0 + 0.0119031585698257*G0_1_0_1_1 - 0.0330415263748609*G0_1_0_1_2 - 0.0525380792047477*G0_1_0_1_3 - 0.0164181497514837*G0_1_0_1_4 + 0.00328362995029678*G0_1_0_1_5 - 0.0244219977553319*G0_1_0_2_0 - 0.0330415263748609*G0_1_0_2_1 + 0.146942440275779*G0_1_0_2_2 + 0.169927849927856*G0_1_0_2_3 + 0.0730607663941023*G0_1_0_2_4 + 0.0197017797017804*G0_1_0_2_5 - 0.0147763347763353*G0_1_0_3_0 - 0.0525380792047477*G0_1_0_3_1 + 0.169927849927856*G0_1_0_3_2 + 0.413737373737389*G0_1_0_3_3 + 0.062388969055638*G0_1_0_3_4 - 0.00985088985088995*G0_1_0_3_5 + 0.00820907487574167*G0_1_0_4_0 - 0.0164181497514837*G0_1_0_4_1 + 0.0730607663941023*G0_1_0_4_2 + 0.062388969055638*G0_1_0_4_3 - 0.0394035594035609*G0_1_0_4_4 - 0.00656725990059339*G0_1_0_4_5 - 0.00574635241301958*G0_1_0_5_0 + 0.00328362995029678*G0_1_0_5_1 + 0.0197017797017804*G0_1_0_5_2 - 0.00985088985088995*G0_1_0_5_3 - 0.00656725990059339*G0_1_0_5_4 - 0.0459708193041542*G0_1_0_5_5 - 0.178957832291173*G0_1_1_0_0 + 0.0385826519159867*G0_1_1_0_1 - 0.0344781144781156*G0_1_1_0_3 - 0.0648516915183605*G0_1_1_0_4 - 0.175674202340876*G0_1_1_0_5 + 0.0385826519159867*G0_1_1_1_0 - 0.0385826519159866*G0_1_1_1_2 - 0.0558217091550444*G0_1_1_1_3 + 0.0558217091550445*G0_1_1_1_5 - 0.0385826519159866*G0_1_1_2_1 + 0.178957832291172*G0_1_1_2_2 + 0.175674202340875*G0_1_1_2_3 + 0.0648516915183604*G0_1_1_2_4 + 0.0344781144781157*G0_1_1_2_5 - 0.0344781144781156*G0_1_1_3_0 - 0.0558217091550444*G0_1_1_3_1 + 0.175674202340875*G0_1_1_3_2 + 0.459708193041543*G0_1_1_3_3 + 0.0689562289562314*G0_1_1_3_4 - 0.0648516915183605*G0_1_1_4_0 + 0.0648516915183604*G0_1_1_4_2 + 0.0689562289562314*G0_1_1_4_3 - 0.0689562289562313*G0_1_1_4_5 - 0.175674202340876*G0_1_1_5_0 + 0.0558217091550445*G0_1_1_5_1 + 0.0344781144781157*G0_1_1_5_2 - 0.0689562289562313*G0_1_1_5_4 - 0.459708193041543*G0_1_1_5_5;
    A[216] = A[104] - 0.0492544492544517*G0_0_1_0_0 + 0.00184704184704195*G0_0_1_0_1 - 0.0121083854417192*G0_0_1_0_2 + 0.0123136123136127*G0_0_1_0_3 - 0.0119031585698258*G0_0_1_0_4 - 0.00861952861952923*G0_0_1_0_5 + 0.00184704184704195*G0_0_1_1_0 + 0.00287317620650974*G0_0_1_1_1 + 0.00102613435946769*G0_0_1_1_2 + 0.0069777136443806*G0_0_1_1_3 - 0.0131345198011869*G0_0_1_1_4 + 0.000410453743787229*G0_0_1_1_5 - 0.0121083854417192*G0_0_1_2_0 + 0.00102613435946769*G0_0_1_2_1 + 0.00410453743787137*G0_0_1_2_2 + 0.00123136123136135*G0_0_1_2_3 + 0.0472021805355156*G0_0_1_2_4 - 0.000820907487574178*G0_0_1_2_5 + 0.0123136123136127*G0_0_1_3_0 + 0.00697771364438061*G0_0_1_3_1 + 0.00123136123136133*G0_0_1_3_2 - 0.062388969055638*G0_0_1_3_3 + 0.00164181497514843*G0_0_1_3_4 - 0.022985409652077*G0_0_1_3_5 - 0.0119031585698258*G0_0_1_4_0 - 0.0131345198011869*G0_0_1_4_1 + 0.0472021805355156*G0_0_1_4_2 + 0.00164181497514844*G0_0_1_4_3 + 0.0656725990059347*G0_0_1_4_4 + 0.0279108545775222*G0_0_1_4_5 - 0.00861952861952922*G0_0_1_5_0 + 0.000410453743787226*G0_0_1_5_1 - 0.00082090748757418*G0_0_1_5_2 - 0.022985409652077*G0_0_1_5_3 + 0.0279108545775222*G0_0_1_5_4 - 0.0229854096520768*G0_0_1_5_5 + 0.0492544492544517*G0_1_0_0_0 - 0.00184704184704195*G0_1_0_0_1 + 0.0121083854417192*G0_1_0_0_2 - 0.0123136123136127*G0_1_0_0_3 + 0.0119031585698258*G0_1_0_0_4 + 0.00861952861952923*G0_1_0_0_5 - 0.00184704184704195*G0_1_0_1_0 - 0.00287317620650974*G0_1_0_1_1 - 0.00102613435946769*G0_1_0_1_2 - 0.0069777136443806*G0_1_0_1_3 + 0.0131345198011869*G0_1_0_1_4 - 0.00041045374378723*G0_1_0_1_5 + 0.0121083854417192*G0_1_0_2_0 - 0.00102613435946769*G0_1_0_2_1 - 0.00410453743787136*G0_1_0_2_2 - 0.00123136123136133*G0_1_0_2_3 - 0.0472021805355156*G0_1_0_2_4 + 0.00082090748757418*G0_1_0_2_5 - 0.0123136123136127*G0_1_0_3_0 - 0.00697771364438061*G0_1_0_3_1 - 0.00123136123136133*G0_1_0_3_2 + 0.062388969055638*G0_1_0_3_3 - 0.00164181497514842*G0_1_0_3_4 + 0.022985409652077*G0_1_0_3_5 + 0.0119031585698258*G0_1_0_4_0 + 0.0131345198011869*G0_1_0_4_1 - 0.0472021805355156*G0_1_0_4_2 - 0.00164181497514843*G0_1_0_4_3 - 0.0656725990059347*G0_1_0_4_4 - 0.0279108545775222*G0_1_0_4_5 + 0.00861952861952923*G0_1_0_5_0 - 0.000410453743787227*G0_1_0_5_1 + 0.00082090748757418*G0_1_0_5_2 + 0.022985409652077*G0_1_0_5_3 - 0.0279108545775222*G0_1_0_5_4 + 0.0229854096520768*G0_1_0_5_5;
    A[148] = A[216] - 0.123136123136127*G0_0_0_0_0 + 0.00595157928491284*G0_0_0_0_1 + 0.0346833413500092*G0_0_0_0_2 - 0.00985088985089017*G0_0_0_0_3 - 0.0623889690556377*G0_0_0_0_4 - 0.0484335417668768*G0_0_0_0_5 + 0.00595157928491284*G0_0_0_1_0 + 0.0935834535834567*G0_0_0_1_1 - 0.000615680615680587*G0_0_0_1_2 + 0.139554272887611*G0_0_0_1_3 + 0.0197017797017804*G0_0_0_1_4 + 0.0352990219656899*G0_0_0_1_5 + 0.0346833413500092*G0_0_0_2_0 - 0.00061568061568059*G0_0_0_2_1 - 0.112053872053876*G0_0_0_2_2 - 0.146942440275779*G0_0_0_2_3 - 0.0566426166426188*G0_0_0_2_4 + 0.0106717973384643*G0_0_0_2_5 - 0.00985088985089017*G0_0_0_3_0 + 0.139554272887611*G0_0_0_3_1 - 0.146942440275779*G0_0_0_3_2 - 0.00656725990059437*G0_0_0_3_3 - 0.0197017797017805*G0_0_0_3_4 - 0.00164181497514837*G0_0_0_3_5 - 0.0623889690556377*G0_0_0_4_0 + 0.0197017797017804*G0_0_0_4_1 - 0.0566426166426188*G0_0_0_4_2 - 0.0197017797017805*G0_0_0_4_3 - 0.0459708193041543*G0_0_0_4_4 - 0.0607471540804895*G0_0_0_4_5 - 0.0484335417668768*G0_0_0_5_0 + 0.0352990219656899*G0_0_0_5_1 + 0.0106717973384643*G0_0_0_5_2 - 0.00164181497514837*G0_0_0_5_3 - 0.0607471540804895*G0_0_0_5_4 - 0.16089786756454*G0_0_0_5_5 - 0.0151867885201224*G0_0_1_0_1 + 0.0151867885201223*G0_0_1_0_2 + 0.0316049382716063*G0_0_1_0_4 - 0.0316049382716058*G0_0_1_0_5 - 0.0151867885201224*G0_0_1_1_0 + 0.104665704665708*G0_0_1_1_1 + 0.143248356581695*G0_0_1_1_3 + 0.00985088985089019*G0_0_1_1_4 + 0.0825012025012054*G0_0_1_1_5 + 0.0151867885201223*G0_0_1_2_0 - 0.104665704665709*G0_0_1_2_2 - 0.143248356581695*G0_0_1_2_3 - 0.0825012025012054*G0_0_1_2_4 - 0.00985088985089023*G0_0_1_2_5 + 0.143248356581695*G0_0_1_3_1 - 0.143248356581695*G0_0_1_3_2 - 0.0197017797017805*G0_0_1_3_4 + 0.0197017797017803*G0_0_1_3_5 + 0.0316049382716063*G0_0_1_4_0 + 0.00985088985089019*G0_0_1_4_1 - 0.0825012025012054*G0_0_1_4_2 - 0.0197017797017805*G0_0_1_4_3 + 0.0788071188071212*G0_0_1_4_4 - 0.0316049382716058*G0_0_1_5_0 + 0.0825012025012054*G0_0_1_5_1 - 0.00985088985089023*G0_0_1_5_2 + 0.0197017797017804*G0_0_1_5_3 - 0.0788071188071212*G0_0_1_5_5 - 0.00123136123136129*G0_1_0_0_1 + 0.00123136123136125*G0_1_0_0_2 + 0.0283213083213093*G0_1_0_0_4 - 0.0283213083213092*G0_1_0_0_5 - 0.00123136123136129*G0_1_0_1_0 + 0.103434343434347*G0_1_0_1_1 + 0.148994708994714*G0_1_0_1_3 - 0.00246272246272256*G0_1_0_1_4 + 0.0357094757094771*G0_1_0_1_5 + 0.00123136123136125*G0_1_0_2_0 - 0.103434343434347*G0_1_0_2_2 - 0.148994708994714*G0_1_0_2_3 - 0.0357094757094769*G0_1_0_2_4 + 0.00246272246272247*G0_1_0_2_5 + 0.148994708994714*G0_1_0_3_1 - 0.148994708994714*G0_1_0_3_2 + 0.00492544492544511*G0_1_0_3_4 - 0.00492544492544496*G0_1_0_3_5 + 0.0283213083213093*G0_1_0_4_0 - 0.00246272246272256*G0_1_0_4_1 - 0.0357094757094769*G0_1_0_4_2 + 0.00492544492544512*G0_1_0_4_3 + 0.167465127465133*G0_1_0_4_4 - 0.0283213083213093*G0_1_0_5_0 + 0.0357094757094771*G0_1_0_5_1 + 0.00246272246272247*G0_1_0_5_2 - 0.00492544492544495*G0_1_0_5_3 - 0.167465127465133*G0_1_0_5_5 + 0.123136123136128*G0_1_1_0_0 - 0.0346833413500092*G0_1_1_0_1 - 0.00595157928491286*G0_1_1_0_2 + 0.00985088985089014*G0_1_1_0_3 + 0.0484335417668768*G0_1_1_0_4 + 0.0623889690556381*G0_1_1_0_5 - 0.0346833413500092*G0_1_1_1_0 + 0.112053872053876*G0_1_1_1_1 + 0.000615680615680649*G0_1_1_1_2 + 0.146942440275779*G0_1_1_1_3 - 0.0106717973384644*G0_1_1_1_4 + 0.0566426166426187*G0_1_1_1_5 - 0.00595157928491286*G0_1_1_2_0 + 0.000615680615680649*G0_1_1_2_1 - 0.0935834535834569*G0_1_1_2_2 - 0.139554272887611*G0_1_1_2_3 - 0.0352990219656898*G0_1_1_2_4 - 0.0197017797017804*G0_1_1_2_5 + 0.00985088985089014*G0_1_1_3_0 + 0.146942440275779*G0_1_1_3_1 - 0.139554272887611*G0_1_1_3_2 + 0.00656725990059387*G0_1_1_3_3 + 0.00164181497514834*G0_1_1_3_4 + 0.0197017797017804*G0_1_1_3_5 + 0.0484335417668768*G0_1_1_4_0 - 0.0106717973384644*G0_1_1_4_1 - 0.0352990219656898*G0_1_1_4_2 + 0.00164181497514835*G0_1_1_4_3 + 0.160897867564539*G0_1_1_4_4 + 0.0607471540804894*G0_1_1_4_5 + 0.0623889690556381*G0_1_1_5_0 + 0.0566426166426187*G0_1_1_5_1 - 0.0197017797017804*G0_1_1_5_2 + 0.0197017797017804*G0_1_1_5_3 + 0.0607471540804894*G0_1_1_5_4 + 0.0459708193041545*G0_1_1_5_5;
    A[204] = A[148] + 0.0492544492544504*G0_0_1_0_0 + 0.0121083854417192*G0_0_1_0_1 - 0.00184704184704187*G0_0_1_0_2 - 0.0123136123136128*G0_0_1_0_3 + 0.00861952861952878*G0_0_1_0_4 + 0.0119031585698258*G0_0_1_0_5 + 0.0121083854417192*G0_0_1_1_0 - 0.00410453743787098*G0_0_1_1_1 - 0.00102613435946773*G0_0_1_1_2 - 0.00123136123136119*G0_0_1_1_3 + 0.000820907487574168*G0_0_1_1_4 - 0.0472021805355156*G0_0_1_1_5 - 0.00184704184704187*G0_0_1_2_0 - 0.00102613435946773*G0_0_1_2_1 - 0.00287317620650967*G0_0_1_2_2 - 0.00697771364438062*G0_0_1_2_3 - 0.000410453743787115*G0_0_1_2_4 + 0.0131345198011869*G0_0_1_2_5 - 0.0123136123136128*G0_0_1_3_0 - 0.00123136123136119*G0_0_1_3_1 - 0.00697771364438061*G0_0_1_3_2 + 0.0623889690556384*G0_0_1_3_3 + 0.0229854096520772*G0_0_1_3_4 - 0.00164181497514826*G0_0_1_3_5 + 0.00861952861952878*G0_0_1_4_0 + 0.000820907487574169*G0_0_1_4_1 - 0.000410453743787115*G0_0_1_4_2 + 0.0229854096520772*G0_0_1_4_3 + 0.0229854096520771*G0_0_1_4_4 - 0.0279108545775221*G0_0_1_4_5 + 0.0119031585698257*G0_0_1_5_0 - 0.0472021805355156*G0_0_1_5_1 + 0.0131345198011869*G0_0_1_5_2 - 0.00164181497514826*G0_0_1_5_3 - 0.0279108545775221*G0_0_1_5_4 - 0.0656725990059345*G0_0_1_5_5 - 0.0492544492544504*G0_1_0_0_0 - 0.0121083854417192*G0_1_0_0_1 + 0.00184704184704187*G0_1_0_0_2 + 0.0123136123136128*G0_1_0_0_3 - 0.00861952861952878*G0_1_0_0_4 - 0.0119031585698257*G0_1_0_0_5 - 0.0121083854417192*G0_1_0_1_0 + 0.00410453743787098*G0_1_0_1_1 + 0.00102613435946773*G0_1_0_1_2 + 0.00123136123136119*G0_1_0_1_3 - 0.000820907487574169*G0_1_0_1_4 + 0.0472021805355156*G0_1_0_1_5 + 0.00184704184704188*G0_1_0_2_0 + 0.00102613435946773*G0_1_0_2_1 + 0.00287317620650967*G0_1_0_2_2 + 0.00697771364438061*G0_1_0_2_3 + 0.000410453743787115*G0_1_0_2_4 - 0.0131345198011869*G0_1_0_2_5 + 0.0123136123136128*G0_1_0_3_0 + 0.00123136123136122*G0_1_0_3_1 + 0.00697771364438062*G0_1_0_3_2 - 0.0623889690556385*G0_1_0_3_3 - 0.0229854096520772*G0_1_0_3_4 + 0.00164181497514826*G0_1_0_3_5 - 0.00861952861952878*G0_1_0_4_0 - 0.000820907487574169*G0_1_0_4_1 + 0.000410453743787113*G0_1_0_4_2 - 0.0229854096520772*G0_1_0_4_3 - 0.0229854096520771*G0_1_0_4_4 + 0.0279108545775221*G0_1_0_4_5 - 0.0119031585698257*G0_1_0_5_0 + 0.0472021805355156*G0_1_0_5_1 - 0.0131345198011869*G0_1_0_5_2 + 0.00164181497514826*G0_1_0_5_3 + 0.0279108545775221*G0_1_0_5_4 + 0.0656725990059345*G0_1_0_5_5;
    A[183] = -A[191] + 0.118210678210682*G0_0_0_0_0 + 0.00472021805355155*G0_0_0_0_1 - 0.0272951739618415*G0_0_0_0_2 + 0.00328362995029667*G0_0_0_0_3 + 0.126419753086424*G0_0_0_0_4 + 0.041045374378709*G0_0_0_0_5 + 0.00472021805355155*G0_0_0_1_0 - 0.012313612313613*G0_0_0_1_1 + 0.00389931056597734*G0_0_0_1_2 + 0.0164181497514838*G0_0_0_1_3 - 0.0394035594035607*G0_0_0_1_4 - 0.0410453743787091*G0_0_0_1_5 - 0.0272951739618415*G0_0_0_2_0 + 0.00389931056597734*G0_0_0_2_1 - 0.0184704184704191*G0_0_0_2_2 - 0.0287317620650965*G0_0_0_2_3 - 0.0566426166426184*G0_0_0_2_4 + 0.0188808722142061*G0_0_0_2_5 + 0.00328362995029667*G0_0_0_3_0 + 0.0164181497514838*G0_0_0_3_1 - 0.0287317620650966*G0_0_0_3_2 + 0.242988616321959*G0_0_0_3_3 + 0.072239858906528*G0_0_0_3_4 - 0.0443290043290056*G0_0_0_3_5 + 0.126419753086424*G0_0_0_4_0 - 0.0394035594035607*G0_0_0_4_1 - 0.0566426166426184*G0_0_0_4_2 + 0.072239858906528*G0_0_0_4_3 + 0.623889690556377*G0_0_0_4_4 + 0.0410453743787091*G0_0_0_4_5 + 0.041045374378709*G0_0_0_5_0 - 0.0410453743787091*G0_0_0_5_1 + 0.0188808722142061*G0_0_0_5_2 - 0.0443290043290056*G0_0_0_5_3 + 0.0410453743787091*G0_0_0_5_4 - 0.187166907166914*G0_0_0_5_5 - 0.0119031585698255*G0_1_0_0_0 + 0.0205226871893545*G0_1_0_0_1 - 0.000820907487574165*G0_1_0_0_2 - 0.000820907487574239*G0_1_0_0_3 - 0.0155972422639095*G0_1_0_0_4 - 0.0500753567420252*G0_1_0_0_5 + 0.0205226871893545*G0_1_0_1_0 + 0.00410453743787087*G0_1_0_1_2 + 0.00820907487574209*G0_1_0_1_3 - 0.0246272246272255*G0_1_0_1_4 - 0.00820907487574162*G0_1_0_1_5 - 0.000820907487574165*G0_1_0_2_0 + 0.00410453743787087*G0_1_0_2_1 - 0.0094404361071031*G0_1_0_2_2 - 0.0254481321147999*G0_1_0_2_3 - 0.00574635241301933*G0_1_0_2_4 + 0.0238063171396512*G0_1_0_2_5 - 0.000820907487574243*G0_1_0_3_0 + 0.00820907487574208*G0_1_0_3_1 - 0.0254481321147999*G0_1_0_3_2 + 0.193734167067508*G0_1_0_3_3 + 0.0508962642295995*G0_1_0_3_4 - 0.0459708193041538*G0_1_0_3_5 - 0.0155972422639095*G0_1_0_4_0 - 0.0246272246272255*G0_1_0_4_1 - 0.00574635241301933*G0_1_0_4_2 + 0.0508962642295995*G0_1_0_4_3 + 0.0656725990059352*G0_1_0_4_4 + 0.00164181497514858*G0_1_0_4_5 - 0.0500753567420252*G0_1_0_5_0 - 0.00820907487574162*G0_1_0_5_1 + 0.0238063171396512*G0_1_0_5_2 - 0.0459708193041538*G0_1_0_5_3 + 0.00164181497514858*G0_1_0_5_4 - 0.101792528459198*G0_1_0_5_5;
    A[213] = -A[183] + 0.0246272246272254*G0_0_0_0_0 - 0.00123136123136129*G0_0_0_0_1 - 0.0266794933461609*G0_0_0_0_2 - 0.0164181497514836*G0_0_0_0_3 - 0.0131345198011869*G0_0_0_0_4 + 0.00574635241301923*G0_0_0_0_5 - 0.00123136123136129*G0_0_0_1_0 + 0.110822510822515*G0_0_0_1_1 - 0.0307840307840318*G0_0_0_1_2 + 0.0788071188071216*G0_0_0_1_3 - 0.0295526695526705*G0_0_0_1_4 + 0.00738816738816776*G0_0_0_1_5 - 0.0266794933461609*G0_0_0_2_0 - 0.0307840307840318*G0_0_0_2_1 + 0.0935834535834566*G0_0_0_2_2 + 0.0279108545775221*G0_0_0_2_3 + 0.0902998236331599*G0_0_0_2_4 + 0.00820907487574179*G0_0_0_2_5 - 0.0164181497514836*G0_0_0_3_0 + 0.0788071188071216*G0_0_0_3_1 + 0.0279108545775221*G0_0_0_3_2 + 0.288959435626112*G0_0_0_3_3 + 0.0919416386083083*G0_0_0_3_4 + 0.0164181497514839*G0_0_0_3_5 - 0.0131345198011869*G0_0_0_4_0 - 0.0295526695526705*G0_0_0_4_1 + 0.0902998236331599*G0_0_0_4_2 + 0.0919416386083083*G0_0_0_4_3 + 0.63045695045697*G0_0_0_4_4 + 0.0426871893538575*G0_0_0_4_5 + 0.00574635241301923*G0_0_0_5_0 + 0.00738816738816775*G0_0_0_5_1 + 0.00820907487574179*G0_0_0_5_2 + 0.0164181497514839*G0_0_0_5_3 + 0.0426871893538575*G0_0_0_5_4 - 0.0262690396023736*G0_0_0_5_5 + 0.00697771364438059*G0_0_1_0_0 - 0.00902998236331604*G0_0_1_0_1 - 0.000410453743787096*G0_0_1_0_2 - 0.00902998236331603*G0_0_1_0_3 + 0.00246272246272259*G0_0_1_0_4 - 0.00902998236331604*G0_0_1_1_0 + 0.172390572390579*G0_0_1_1_1 - 0.0213435946769288*G0_0_1_1_2 + 0.102613435946773*G0_0_1_1_3 - 0.00246272246272256*G0_0_1_1_4 + 0.0287317620650967*G0_0_1_1_5 - 0.000410453743787096*G0_0_1_2_0 - 0.0213435946769288*G0_0_1_2_1 + 0.00451499118165803*G0_0_1_2_2 - 0.0262690396023738*G0_0_1_2_3 - 0.00328362995029675*G0_0_1_2_4 - 0.0073881673881677*G0_0_1_2_5 - 0.00902998236331603*G0_0_1_3_0 + 0.102613435946773*G0_0_1_3_1 - 0.0262690396023738*G0_0_1_3_2 + 0.147763347763353*G0_0_1_3_3 + 0.0229854096520772*G0_0_1_3_4 + 0.0328362995029675*G0_0_1_3_5 + 0.00246272246272259*G0_0_1_4_0 - 0.00246272246272256*G0_0_1_4_1 - 0.00328362995029675*G0_0_1_4_2 + 0.0229854096520772*G0_0_1_4_3 + 0.0689562289562315*G0_0_1_4_4 + 0.0197017797017805*G0_0_1_4_5 + 0.0287317620650967*G0_0_1_5_1 - 0.0073881673881677*G0_0_1_5_2 + 0.0328362995029675*G0_0_1_5_3 + 0.0197017797017805*G0_0_1_5_4 + 0.0164181497514839*G0_0_1_5_5 + 0.00205226871893549*G0_1_0_0_0 + 0.00123136123136125*G0_1_0_0_1 + 0.00082090748757419*G0_1_0_0_2 - 0.0238063171396513*G0_1_0_0_3 - 0.00492544492544511*G0_1_0_0_4 - 0.00246272246272259*G0_1_0_0_5 + 0.00123136123136125*G0_1_0_1_0 + 0.0738816738816765*G0_1_0_1_1 - 0.0275004008337352*G0_1_0_1_2 + 0.0902998236331603*G0_1_0_1_3 - 0.00246272246272253*G0_1_0_1_4 + 0.000820907487574191*G0_1_0_2_0 - 0.0275004008337352*G0_1_0_2_1 + 0.00205226871893555*G0_1_0_2_2 - 0.004104537437871*G0_1_0_2_3 - 0.000820907487574161*G0_1_0_2_4 + 0.00246272246272252*G0_1_0_2_5 - 0.0238063171396513*G0_1_0_3_0 + 0.0902998236331602*G0_1_0_3_1 - 0.00410453743787101*G0_1_0_3_2 + 0.384184704184718*G0_1_0_3_3 + 0.0525380792047477*G0_1_0_3_4 + 0.0426871893538577*G0_1_0_3_5 - 0.00492544492544511*G0_1_0_4_0 - 0.00246272246272253*G0_1_0_4_1 - 0.000820907487574161*G0_1_0_4_2 + 0.0525380792047477*G0_1_0_4_3 + 0.00985088985089021*G0_1_0_4_4 - 0.00246272246272259*G0_1_0_5_0 + 0.00246272246272252*G0_1_0_5_2 + 0.0426871893538577*G0_1_0_5_3 - 0.0426871893538574*G0_1_0_5_5 + 0.00246272246272262*G0_1_1_0_0 + 0.0123136123136128*G0_1_1_0_1 - 0.00164181497514838*G0_1_1_0_3 + 0.00574635241301927*G0_1_1_0_4 + 0.0262690396023738*G0_1_1_0_5 + 0.0123136123136128*G0_1_1_1_0 - 0.0123136123136127*G0_1_1_1_2 + 0.0738816738816764*G0_1_1_1_3 - 0.0738816738816765*G0_1_1_1_5 - 0.0123136123136127*G0_1_1_2_1 - 0.00246272246272245*G0_1_1_2_2 - 0.0262690396023738*G0_1_1_2_3 - 0.00574635241301925*G0_1_1_2_4 + 0.00164181497514835*G0_1_1_2_5 - 0.00164181497514838*G0_1_1_3_0 + 0.0738816738816764*G0_1_1_3_1 - 0.0262690396023738*G0_1_1_3_2 + 0.131345198011869*G0_1_1_3_3 + 0.00328362995029677*G0_1_1_3_4 + 0.00574635241301927*G0_1_1_4_0 - 0.00574635241301925*G0_1_1_4_2 + 0.00328362995029677*G0_1_1_4_3 - 0.00328362995029671*G0_1_1_4_5 + 0.0262690396023738*G0_1_1_5_0 - 0.0738816738816765*G0_1_1_5_1 + 0.00164181497514835*G0_1_1_5_2 - 0.00328362995029671*G0_1_1_5_4 - 0.131345198011869*G0_1_1_5_5;
    A[185] = -A[188] - 0.0119031585698257*G0_0_1_0_0 - 0.000820907487574172*G0_0_1_0_1 + 0.0205226871893545*G0_0_1_0_2 - 0.000820907487574114*G0_0_1_0_3 - 0.0500753567420251*G0_0_1_0_4 - 0.0155972422639094*G0_0_1_0_5 - 0.000820907487574172*G0_0_1_1_0 - 0.00944043610710296*G0_0_1_1_1 + 0.0041045374378709*G0_0_1_1_2 - 0.0254481321147998*G0_0_1_1_3 + 0.0238063171396513*G0_0_1_1_4 - 0.00574635241301928*G0_0_1_1_5 + 0.0205226871893545*G0_0_1_2_0 + 0.0041045374378709*G0_0_1_2_1 + 0.00820907487574207*G0_0_1_2_3 - 0.00820907487574178*G0_0_1_2_4 - 0.0246272246272254*G0_0_1_2_5 - 0.000820907487574117*G0_0_1_3_0 - 0.0254481321147998*G0_0_1_3_1 + 0.00820907487574207*G0_0_1_3_2 + 0.193734167067507*G0_0_1_3_3 - 0.0459708193041542*G0_0_1_3_4 + 0.0508962642295991*G0_0_1_3_5 - 0.0500753567420251*G0_0_1_4_0 + 0.0238063171396513*G0_0_1_4_1 - 0.0082090748757418*G0_0_1_4_2 - 0.0459708193041542*G0_0_1_4_3 - 0.101792528459198*G0_0_1_4_4 + 0.00164181497514826*G0_0_1_4_5 - 0.0155972422639094*G0_0_1_5_0 - 0.00574635241301928*G0_0_1_5_1 - 0.0246272246272254*G0_0_1_5_2 + 0.0508962642295991*G0_0_1_5_3 + 0.00164181497514826*G0_0_1_5_4 + 0.0656725990059341*G0_0_1_5_5 + 0.118210678210682*G0_1_1_0_0 - 0.0272951739618416*G0_1_1_0_1 + 0.00472021805355152*G0_1_1_0_2 + 0.0032836299502968*G0_1_1_0_3 + 0.0410453743787091*G0_1_1_0_4 + 0.126419753086425*G0_1_1_0_5 - 0.0272951739618416*G0_1_1_1_0 - 0.0184704184704192*G0_1_1_1_1 + 0.00389931056597737*G0_1_1_1_2 - 0.0287317620650966*G0_1_1_1_3 + 0.0188808722142062*G0_1_1_1_4 - 0.0566426166426187*G0_1_1_1_5 + 0.00472021805355152*G0_1_1_2_0 + 0.00389931056597737*G0_1_1_2_1 - 0.0123136123136129*G0_1_1_2_2 + 0.0164181497514839*G0_1_1_2_3 - 0.0410453743787091*G0_1_1_2_4 - 0.0394035594035607*G0_1_1_2_5 + 0.0032836299502968*G0_1_1_3_0 - 0.0287317620650966*G0_1_1_3_1 + 0.0164181497514839*G0_1_1_3_2 + 0.242988616321958*G0_1_1_3_3 - 0.0443290043290059*G0_1_1_3_4 + 0.0722398589065278*G0_1_1_3_5 + 0.0410453743787091*G0_1_1_4_0 + 0.0188808722142062*G0_1_1_4_1 - 0.0410453743787091*G0_1_1_4_2 - 0.0443290043290059*G0_1_1_4_3 - 0.187166907166914*G0_1_1_4_4 + 0.041045374378709*G0_1_1_4_5 + 0.126419753086425*G0_1_1_5_0 - 0.0566426166426187*G0_1_1_5_1 - 0.0394035594035607*G0_1_1_5_2 + 0.0722398589065278*G0_1_1_5_3 + 0.041045374378709*G0_1_1_5_4 + 0.623889690556379*G0_1_1_5_5;
    A[87] = -A[132] - 0.0119031585698257*G0_1_0_0_0 - 0.000820907487574172*G0_1_0_0_1 + 0.0205226871893545*G0_1_0_0_2 - 0.000820907487574115*G0_1_0_0_3 - 0.050075356742025*G0_1_0_0_4 - 0.0155972422639094*G0_1_0_0_5 - 0.000820907487574173*G0_1_0_1_0 - 0.00944043610710296*G0_1_0_1_1 + 0.0041045374378709*G0_1_0_1_2 - 0.0254481321147998*G0_1_0_1_3 + 0.0238063171396513*G0_1_0_1_4 - 0.00574635241301929*G0_1_0_1_5 + 0.0205226871893545*G0_1_0_2_0 + 0.0041045374378709*G0_1_0_2_1 + 0.00820907487574207*G0_1_0_2_3 - 0.00820907487574179*G0_1_0_2_4 - 0.0246272246272254*G0_1_0_2_5 - 0.000820907487574116*G0_1_0_3_0 - 0.0254481321147998*G0_1_0_3_1 + 0.00820907487574207*G0_1_0_3_2 + 0.193734167067507*G0_1_0_3_3 - 0.0459708193041542*G0_1_0_3_4 + 0.0508962642295991*G0_1_0_3_5 - 0.050075356742025*G0_1_0_4_0 + 0.0238063171396513*G0_1_0_4_1 - 0.0082090748757418*G0_1_0_4_2 - 0.0459708193041542*G0_1_0_4_3 - 0.101792528459198*G0_1_0_4_4 + 0.00164181497514826*G0_1_0_4_5 - 0.0155972422639094*G0_1_0_5_0 - 0.00574635241301928*G0_1_0_5_1 - 0.0246272246272254*G0_1_0_5_2 + 0.0508962642295991*G0_1_0_5_3 + 0.00164181497514827*G0_1_0_5_4 + 0.0656725990059341*G0_1_0_5_5 + 0.118210678210682*G0_1_1_0_0 - 0.0272951739618416*G0_1_1_0_1 + 0.00472021805355152*G0_1_1_0_2 + 0.0032836299502968*G0_1_1_0_3 + 0.0410453743787091*G0_1_1_0_4 + 0.126419753086425*G0_1_1_0_5 - 0.0272951739618416*G0_1_1_1_0 - 0.0184704184704192*G0_1_1_1_1 + 0.00389931056597738*G0_1_1_1_2 - 0.0287317620650966*G0_1_1_1_3 + 0.0188808722142062*G0_1_1_1_4 - 0.0566426166426187*G0_1_1_1_5 + 0.00472021805355152*G0_1_1_2_0 + 0.00389931056597737*G0_1_1_2_1 - 0.0123136123136129*G0_1_1_2_2 + 0.0164181497514839*G0_1_1_2_3 - 0.0410453743787091*G0_1_1_2_4 - 0.0394035594035607*G0_1_1_2_5 + 0.0032836299502968*G0_1_1_3_0 - 0.0287317620650966*G0_1_1_3_1 + 0.0164181497514839*G0_1_1_3_2 + 0.242988616321958*G0_1_1_3_3 - 0.0443290043290059*G0_1_1_3_4 + 0.0722398589065278*G0_1_1_3_5 + 0.0410453743787091*G0_1_1_4_0 + 0.0188808722142062*G0_1_1_4_1 - 0.0410453743787091*G0_1_1_4_2 - 0.0443290043290059*G0_1_1_4_3 - 0.187166907166914*G0_1_1_4_4 + 0.041045374378709*G0_1_1_4_5 + 0.126419753086425*G0_1_1_5_0 - 0.0566426166426187*G0_1_1_5_1 - 0.0394035594035607*G0_1_1_5_2 + 0.0722398589065278*G0_1_1_5_3 + 0.041045374378709*G0_1_1_5_4 + 0.623889690556379*G0_1_1_5_5;
    A[114] = A[142] + 0.224210357543699*G0_0_1_0_0 - 0.00138528138528139*G0_0_1_0_1 + 0.00425845759179107*G0_0_1_0_2 - 0.00338624338624354*G0_0_1_0_3 - 0.0256533589866932*G0_0_1_0_4 - 0.00615680615680646*G0_0_1_0_5 - 0.00138528138528139*G0_0_1_1_0 - 0.0015392015392016*G0_0_1_1_1 + 0.000307840307840335*G0_0_1_1_2 - 0.000513067179733857*G0_0_1_1_3 - 0.000307840307840304*G0_0_1_1_4 + 0.0152894019560692*G0_0_1_1_5 + 0.00425845759179107*G0_0_1_2_0 + 0.000307840307840335*G0_0_1_2_1 - 0.00615680615680646*G0_0_1_2_2 - 0.004104537437871*G0_0_1_2_3 + 0.00831168831168857*G0_0_1_2_4 + 0.00359147025813705*G0_0_1_2_5 - 0.00338624338624354*G0_0_1_3_0 - 0.000513067179733857*G0_0_1_3_1 - 0.004104537437871*G0_0_1_3_2 - 0.0057463524130196*G0_0_1_3_3 + 0.00738816738816762*G0_0_1_3_4 - 0.000410453743787099*G0_0_1_3_5 - 0.0256533589866932*G0_0_1_4_0 - 0.000307840307840304*G0_0_1_4_1 + 0.00831168831168857*G0_0_1_4_2 + 0.00738816738816762*G0_0_1_4_3 - 0.0508962642295992*G0_0_1_4_4 - 0.00656725990059349*G0_0_1_4_5 - 0.00615680615680647*G0_0_1_5_0 + 0.0152894019560692*G0_0_1_5_1 + 0.00359147025813706*G0_0_1_5_2 - 0.000410453743787099*G0_0_1_5_3 - 0.0065672599005935*G0_0_1_5_4 - 0.14119608786276*G0_0_1_5_5 - 0.224210357543699*G0_1_0_0_0 + 0.00138528138528139*G0_1_0_0_1 - 0.00425845759179108*G0_1_0_0_2 + 0.00338624338624354*G0_1_0_0_3 + 0.0256533589866932*G0_1_0_0_4 + 0.00615680615680647*G0_1_0_0_5 + 0.00138528138528139*G0_1_0_1_0 + 0.0015392015392016*G0_1_0_1_1 - 0.000307840307840335*G0_1_0_1_2 + 0.000513067179733855*G0_1_0_1_3 + 0.000307840307840302*G0_1_0_1_4 - 0.0152894019560692*G0_1_0_1_5 - 0.00425845759179108*G0_1_0_2_0 - 0.000307840307840335*G0_1_0_2_1 + 0.00615680615680646*G0_1_0_2_2 + 0.00410453743787099*G0_1_0_2_3 - 0.00831168831168857*G0_1_0_2_4 - 0.00359147025813705*G0_1_0_2_5 + 0.00338624338624355*G0_1_0_3_0 + 0.00051306717973386*G0_1_0_3_1 + 0.004104537437871*G0_1_0_3_2 + 0.0057463524130196*G0_1_0_3_3 - 0.00738816738816762*G0_1_0_3_4 + 0.000410453743787096*G0_1_0_3_5 + 0.0256533589866932*G0_1_0_4_0 + 0.000307840307840302*G0_1_0_4_1 - 0.00831168831168857*G0_1_0_4_2 - 0.00738816738816762*G0_1_0_4_3 + 0.0508962642295993*G0_1_0_4_4 + 0.0065672599005935*G0_1_0_4_5 + 0.00615680615680647*G0_1_0_5_0 - 0.0152894019560692*G0_1_0_5_1 - 0.00359147025813706*G0_1_0_5_2 + 0.000410453743787099*G0_1_0_5_3 + 0.0065672599005935*G0_1_0_5_4 + 0.14119608786276*G0_1_0_5_5;
    A[221] = -A[213] - 0.00902998236331615*G0_0_0_0_0 - 0.00020522687189355*G0_0_0_0_1 - 0.0264742664742673*G0_0_0_0_2 - 0.00492544492544505*G0_0_0_0_3 - 0.0508962642295991*G0_0_0_0_4 - 0.00328362995029665*G0_0_0_0_5 - 0.000205226871893549*G0_0_0_1_0 - 0.0123136123136129*G0_0_0_1_1 - 0.015802469135803*G0_0_0_1_2 - 0.0328362995029674*G0_0_0_1_3 - 0.0147763347763352*G0_0_0_1_4 + 0.00820907487574172*G0_0_0_1_5 - 0.0264742664742673*G0_0_0_2_0 - 0.015802469135803*G0_0_0_2_1 + 0.130113836780508*G0_0_0_2_2 + 0.0911207311207343*G0_0_0_2_3 + 0.142016995350333*G0_0_0_2_4 + 0.00410453743787096*G0_0_0_2_5 - 0.00492544492544505*G0_0_0_3_0 - 0.0328362995029674*G0_0_0_3_1 + 0.0911207311207343*G0_0_0_3_2 - 0.0853743787077157*G0_0_0_3_3 + 0.0394035594035605*G0_0_0_3_4 + 0.00164181497514826*G0_0_0_3_5 - 0.0508962642295991*G0_0_0_4_0 - 0.0147763347763352*G0_0_0_4_1 + 0.142016995350333*G0_0_0_4_2 + 0.0394035594035605*G0_0_0_4_3 + 0.558217091550442*G0_0_0_4_4 + 0.0213435946769286*G0_0_0_4_5 - 0.00328362995029665*G0_0_0_5_0 + 0.00820907487574172*G0_0_0_5_1 + 0.00410453743787096*G0_0_0_5_2 + 0.00164181497514825*G0_0_0_5_3 + 0.0213435946769286*G0_0_0_5_4 + 0.0492544492544507*G0_0_0_5_5 + 0.00944043610710293*G0_1_0_0_0 - 0.00410453743787092*G0_1_0_0_1 + 0.000820907487574179*G0_1_0_0_2 - 0.0238063171396512*G0_1_0_0_3 + 0.00574635241301924*G0_1_0_0_4 + 0.0254481321147997*G0_1_0_0_5 - 0.00410453743787092*G0_1_0_1_0 - 0.0205226871893546*G0_1_0_1_2 + 0.00820907487574188*G0_1_0_1_3 + 0.0246272246272255*G0_1_0_1_4 - 0.00820907487574177*G0_1_0_1_5 + 0.000820907487574179*G0_1_0_2_0 - 0.0205226871893546*G0_1_0_2_1 + 0.0119031585698257*G0_1_0_2_2 + 0.0500753567420252*G0_1_0_2_3 + 0.0155972422639096*G0_1_0_2_4 + 0.000820907487574251*G0_1_0_2_5 - 0.0238063171396512*G0_1_0_3_0 + 0.00820907487574188*G0_1_0_3_1 + 0.0500753567420252*G0_1_0_3_2 + 0.101792528459198*G0_1_0_3_3 - 0.00164181497514843*G0_1_0_3_4 + 0.0459708193041541*G0_1_0_3_5 + 0.00574635241301924*G0_1_0_4_0 + 0.0246272246272255*G0_1_0_4_1 + 0.0155972422639096*G0_1_0_4_2 - 0.00164181497514843*G0_1_0_4_3 - 0.0656725990059351*G0_1_0_4_4 - 0.0508962642295994*G0_1_0_4_5 + 0.0254481321147997*G0_1_0_5_0 - 0.00820907487574177*G0_1_0_5_1 + 0.000820907487574249*G0_1_0_5_2 + 0.0459708193041541*G0_1_0_5_3 - 0.0508962642295994*G0_1_0_5_4 - 0.193734167067507*G0_1_0_5_5;
    A[133] = A[221] + 0.0180599647266321*G0_0_0_0_0 - 0.00225749559082899*G0_0_0_0_1 - 0.00143658810325488*G0_0_0_0_2 + 0.00164181497514829*G0_0_0_0_3 - 0.00246272246272262*G0_0_0_0_5 - 0.00225749559082899*G0_0_0_1_0 + 0.0615680615680637*G0_0_0_1_1 + 0.0034888568221902*G0_0_0_1_2 + 0.0344781144781156*G0_0_0_1_3 + 0.00492544492544504*G0_0_0_1_4 + 0.0106717973384645*G0_0_0_1_5 - 0.00143658810325488*G0_0_0_2_0 + 0.0034888568221902*G0_0_0_2_1 - 0.0192913259579924*G0_0_0_2_2 - 0.0467917267917281*G0_0_0_2_3 + 0.0106717973384646*G0_0_0_2_4 - 0.000820907487574197*G0_0_0_2_5 + 0.00164181497514829*G0_0_0_3_0 + 0.0344781144781156*G0_0_0_3_1 - 0.0467917267917281*G0_0_0_3_2 - 0.0197017797017795*G0_0_0_3_3 - 0.0131345198011867*G0_0_0_3_4 - 0.00164181497514823*G0_0_0_3_5 + 0.00492544492544504*G0_0_0_4_1 + 0.0106717973384646*G0_0_0_4_2 - 0.0131345198011867*G0_0_0_4_3 - 0.111643418310088*G0_0_0_4_4 - 0.00820907487574171*G0_0_0_4_5 - 0.00246272246272262*G0_0_0_5_0 + 0.0106717973384645*G0_0_0_5_1 - 0.000820907487574197*G0_0_0_5_2 - 0.00164181497514823*G0_0_0_5_3 - 0.00820907487574171*G0_0_0_5_4 - 0.0426871893538572*G0_0_0_5_5 - 0.00697771364438057*G0_0_1_0_1 + 0.00697771364438047*G0_0_1_0_2 + 0.00205226871893539*G0_0_1_0_4 - 0.00205226871893553*G0_0_1_0_5 - 0.00697771364438057*G0_0_1_1_0 + 0.0853743787077152*G0_0_1_1_1 + 0.040634920634922*G0_0_1_1_3 + 0.0041045374378709*G0_0_1_1_4 + 0.025858585858587*G0_0_1_1_5 + 0.00697771364438047*G0_0_1_2_0 - 0.085374378707714*G0_0_1_2_2 - 0.0406349206349217*G0_0_1_2_3 - 0.0258585858585864*G0_0_1_2_4 - 0.00410453743787093*G0_0_1_2_5 + 0.040634920634922*G0_0_1_3_1 - 0.0406349206349217*G0_0_1_3_2 - 0.00820907487574172*G0_0_1_3_4 + 0.00820907487574195*G0_0_1_3_5 + 0.00205226871893539*G0_0_1_4_0 + 0.0041045374378709*G0_0_1_4_1 - 0.0258585858585864*G0_0_1_4_2 - 0.00820907487574172*G0_0_1_4_3 + 0.0098508898508902*G0_0_1_4_4 - 0.00205226871893553*G0_0_1_5_0 + 0.025858585858587*G0_0_1_5_1 - 0.00410453743787093*G0_0_1_5_2 + 0.00820907487574195*G0_0_1_5_3 - 0.00985088985088958*G0_0_1_5_5 - 0.00123136123136124*G0_1_0_0_1 + 0.00123136123136127*G0_1_0_0_2 + 0.0283213083213093*G0_1_0_0_4 - 0.0283213083213093*G0_1_0_0_5 - 0.00123136123136124*G0_1_0_1_0 + 0.0439185505852183*G0_1_0_1_1 + 0.0233958633958642*G0_1_0_1_3 - 0.00656725990059348*G0_1_0_1_4 + 0.0398140131473478*G0_1_0_1_5 + 0.00123136123136127*G0_1_0_2_0 - 0.0439185505852182*G0_1_0_2_2 - 0.023395863395864*G0_1_0_2_3 - 0.0398140131473479*G0_1_0_2_4 + 0.0065672599005934*G0_1_0_2_5 + 0.0233958633958642*G0_1_0_3_1 - 0.023395863395864*G0_1_0_3_2 + 0.013134519801187*G0_1_0_3_4 - 0.0131345198011867*G0_1_0_3_5 + 0.0283213083213093*G0_1_0_4_0 - 0.00656725990059348*G0_1_0_4_1 - 0.0398140131473479*G0_1_0_4_2 + 0.013134519801187*G0_1_0_4_3 - 0.157614237614243*G0_1_0_4_4 - 0.0283213083213093*G0_1_0_5_0 + 0.0398140131473478*G0_1_0_5_1 + 0.0065672599005934*G0_1_0_5_2 - 0.0131345198011867*G0_1_0_5_3 + 0.157614237614243*G0_1_0_5_5 - 0.0180599647266319*G0_1_1_0_0 + 0.00143658810325483*G0_1_1_0_1 + 0.00225749559082897*G0_1_1_0_2 - 0.00164181497514836*G0_1_1_0_3 + 0.00246272246272259*G0_1_1_0_4 + 0.00143658810325483*G0_1_1_1_0 + 0.0192913259579929*G0_1_1_1_1 - 0.00348885682219033*G0_1_1_1_2 + 0.0467917267917284*G0_1_1_1_3 + 0.000820907487574239*G0_1_1_1_4 - 0.0106717973384644*G0_1_1_1_5 + 0.00225749559082897*G0_1_1_2_0 - 0.00348885682219033*G0_1_1_2_1 - 0.061568061568063*G0_1_1_2_2 - 0.0344781144781155*G0_1_1_2_3 - 0.0106717973384642*G0_1_1_2_4 - 0.00492544492544507*G0_1_1_2_5 - 0.00164181497514836*G0_1_1_3_0 + 0.0467917267917284*G0_1_1_3_1 - 0.0344781144781155*G0_1_1_3_2 + 0.019701779701781*G0_1_1_3_3 + 0.00164181497514825*G0_1_1_3_4 + 0.0131345198011868*G0_1_1_3_5 + 0.00246272246272259*G0_1_1_4_0 + 0.000820907487574239*G0_1_1_4_1 - 0.0106717973384642*G0_1_1_4_2 + 0.00164181497514825*G0_1_1_4_3 + 0.0426871893538569*G0_1_1_4_4 + 0.00820907487574163*G0_1_1_4_5 - 0.0106717973384644*G0_1_1_5_1 - 0.00492544492544507*G0_1_1_5_2 + 0.0131345198011868*G0_1_1_5_3 + 0.00820907487574163*G0_1_1_5_4 + 0.111643418310089*G0_1_1_5_5;
    A[88] = -A[133] + 0.00944043610710299*G0_1_0_0_0 + 0.000820907487574208*G0_1_0_0_1 - 0.00410453743787087*G0_1_0_0_2 - 0.0238063171396513*G0_1_0_0_3 + 0.0254481321147996*G0_1_0_0_4 + 0.00574635241301918*G0_1_0_0_5 + 0.000820907487574208*G0_1_0_1_0 + 0.0119031585698255*G0_1_0_1_1 - 0.0205226871893546*G0_1_0_1_2 + 0.0500753567420254*G0_1_0_1_3 + 0.000820907487574195*G0_1_0_1_4 + 0.0155972422639094*G0_1_0_1_5 - 0.00410453743787087*G0_1_0_2_0 - 0.0205226871893546*G0_1_0_2_1 + 0.00820907487574161*G0_1_0_2_3 - 0.00820907487574196*G0_1_0_2_4 + 0.0246272246272254*G0_1_0_2_5 - 0.0238063171396513*G0_1_0_3_0 + 0.0500753567420253*G0_1_0_3_1 + 0.00820907487574162*G0_1_0_3_2 + 0.101792528459199*G0_1_0_3_3 + 0.0459708193041542*G0_1_0_3_4 - 0.00164181497514818*G0_1_0_3_5 + 0.0254481321147996*G0_1_0_4_0 + 0.000820907487574199*G0_1_0_4_1 - 0.00820907487574197*G0_1_0_4_2 + 0.0459708193041542*G0_1_0_4_3 - 0.193734167067508*G0_1_0_4_4 - 0.0508962642295993*G0_1_0_4_5 + 0.00574635241301918*G0_1_0_5_0 + 0.0155972422639094*G0_1_0_5_1 + 0.0246272246272254*G0_1_0_5_2 - 0.00164181497514818*G0_1_0_5_3 - 0.0508962642295993*G0_1_0_5_4 - 0.0656725990059346*G0_1_0_5_5 - 0.00902998236331581*G0_1_1_0_0 - 0.0264742664742675*G0_1_1_0_1 - 0.000205226871893538*G0_1_1_0_2 - 0.00492544492544512*G0_1_1_0_3 - 0.00328362995029667*G0_1_1_0_4 - 0.0508962642295992*G0_1_1_0_5 - 0.0264742664742675*G0_1_1_1_0 + 0.130113836780508*G0_1_1_1_1 - 0.0158024691358031*G0_1_1_1_2 + 0.0911207311207346*G0_1_1_1_3 + 0.00410453743787095*G0_1_1_1_4 + 0.142016995350334*G0_1_1_1_5 - 0.000205226871893538*G0_1_1_2_0 - 0.0158024691358031*G0_1_1_2_1 - 0.0123136123136123*G0_1_1_2_2 - 0.0328362995029675*G0_1_1_2_3 + 0.00820907487574179*G0_1_1_2_4 - 0.0147763347763353*G0_1_1_2_5 - 0.00492544492544512*G0_1_1_3_0 + 0.0911207311207346*G0_1_1_3_1 - 0.0328362995029675*G0_1_1_3_2 - 0.0853743787077147*G0_1_1_3_3 + 0.00164181497514825*G0_1_1_3_4 + 0.0394035594035609*G0_1_1_3_5 - 0.00328362995029667*G0_1_1_4_0 + 0.00410453743787095*G0_1_1_4_1 + 0.00820907487574179*G0_1_1_4_2 + 0.00164181497514825*G0_1_1_4_3 + 0.0492544492544505*G0_1_1_4_4 + 0.0213435946769286*G0_1_1_4_5 - 0.0508962642295992*G0_1_1_5_0 + 0.142016995350334*G0_1_1_5_1 - 0.0147763347763353*G0_1_1_5_2 + 0.0394035594035609*G0_1_1_5_3 + 0.0213435946769287*G0_1_1_5_4 + 0.558217091550445*G0_1_1_5_5;
    A[179] = A[221] + 0.00656725990059328*G0_0_1_0_0 - 0.00595157928491284*G0_0_1_0_1 - 0.000205226871893536*G0_0_1_0_2 - 0.0106717973384643*G0_0_1_0_3 - 0.00123136123136129*G0_0_1_0_4 + 0.0250376783710126*G0_0_1_0_5 - 0.00595157928491284*G0_0_1_1_0 + 0.0492544492544515*G0_0_1_1_1 - 0.00841430174763537*G0_0_1_1_2 + 0.0201122334455675*G0_0_1_1_3 + 0.0123136123136128*G0_0_1_1_4 + 0.000410453743787186*G0_0_1_1_5 - 0.000205226871893536*G0_0_1_2_0 - 0.00841430174763537*G0_0_1_2_1 + 0.00779862113195467*G0_0_1_2_2 + 0.00287317620650962*G0_0_1_2_3 + 0.0143658810325482*G0_0_1_2_4 + 0.00164181497514839*G0_0_1_2_5 - 0.0106717973384643*G0_0_1_3_0 + 0.0201122334455675*G0_0_1_3_1 + 0.00287317620650962*G0_0_1_3_2 + 0.0361199294532635*G0_0_1_3_3 - 0.0032836299502968*G0_0_1_3_4 + 0.0180599647266319*G0_0_1_3_5 - 0.00123136123136129*G0_0_1_4_0 + 0.0123136123136128*G0_0_1_4_1 + 0.0143658810325482*G0_0_1_4_2 - 0.0032836299502968*G0_0_1_4_3 - 0.00328362995029723*G0_0_1_4_4 - 0.0279108545775223*G0_0_1_4_5 + 0.0250376783710126*G0_0_1_5_0 + 0.000410453743787183*G0_0_1_5_1 + 0.00164181497514839*G0_0_1_5_2 + 0.0180599647266319*G0_0_1_5_3 - 0.0279108545775223*G0_0_1_5_4 - 0.17074875741543*G0_0_1_5_5 - 0.00656725990059328*G0_1_0_0_0 + 0.00595157928491284*G0_1_0_0_1 + 0.000205226871893536*G0_1_0_0_2 + 0.0106717973384643*G0_1_0_0_3 + 0.00123136123136129*G0_1_0_0_4 - 0.0250376783710126*G0_1_0_0_5 + 0.00595157928491284*G0_1_0_1_0 - 0.0492544492544515*G0_1_0_1_1 + 0.00841430174763537*G0_1_0_1_2 - 0.0201122334455675*G0_1_0_1_3 - 0.0123136123136128*G0_1_0_1_4 - 0.000410453743787186*G0_1_0_1_5 + 0.000205226871893536*G0_1_0_2_0 + 0.00841430174763537*G0_1_0_2_1 - 0.00779862113195467*G0_1_0_2_2 - 0.00287317620650962*G0_1_0_2_3 - 0.0143658810325482*G0_1_0_2_4 - 0.00164181497514839*G0_1_0_2_5 + 0.0106717973384643*G0_1_0_3_0 - 0.0201122334455675*G0_1_0_3_1 - 0.00287317620650962*G0_1_0_3_2 - 0.0361199294532636*G0_1_0_3_3 + 0.0032836299502968*G0_1_0_3_4 - 0.0180599647266319*G0_1_0_3_5 + 0.00123136123136129*G0_1_0_4_0 - 0.0123136123136128*G0_1_0_4_1 - 0.0143658810325482*G0_1_0_4_2 + 0.0032836299502968*G0_1_0_4_3 + 0.00328362995029723*G0_1_0_4_4 + 0.0279108545775223*G0_1_0_4_5 - 0.0250376783710126*G0_1_0_5_0 - 0.000410453743787186*G0_1_0_5_1 - 0.00164181497514839*G0_1_0_5_2 - 0.0180599647266319*G0_1_0_5_3 + 0.0279108545775223*G0_1_0_5_4 + 0.17074875741543*G0_1_0_5_5;
    A[200] = A[88] + 0.00287317620650962*G0_0_1_0_0 + 0.00102613435946772*G0_0_1_0_1 + 0.00184704184704188*G0_0_1_0_2 - 0.0131345198011869*G0_0_1_0_3 + 0.00041045374378701*G0_0_1_0_4 + 0.00697771364438045*G0_0_1_0_5 + 0.00102613435946772*G0_0_1_1_0 + 0.0041045374378709*G0_0_1_1_1 - 0.0121083854417192*G0_0_1_1_2 + 0.0472021805355157*G0_0_1_1_3 - 0.000820907487574183*G0_0_1_1_4 + 0.00123136123136138*G0_0_1_1_5 + 0.00184704184704188*G0_0_1_2_0 - 0.0121083854417192*G0_0_1_2_1 - 0.0492544492544503*G0_0_1_2_2 - 0.0119031585698257*G0_0_1_2_3 - 0.0086195286195287*G0_0_1_2_4 + 0.0123136123136127*G0_0_1_2_5 - 0.013134519801187*G0_0_1_3_0 + 0.0472021805355156*G0_0_1_3_1 - 0.0119031585698257*G0_0_1_3_2 + 0.0656725990059348*G0_0_1_3_3 + 0.0279108545775223*G0_0_1_3_4 + 0.00164181497514855*G0_0_1_3_5 + 0.00041045374378701*G0_0_1_4_0 - 0.000820907487574182*G0_0_1_4_1 - 0.0086195286195287*G0_0_1_4_2 + 0.0279108545775223*G0_0_1_4_3 - 0.0229854096520772*G0_0_1_4_4 - 0.022985409652077*G0_0_1_4_5 + 0.00697771364438045*G0_0_1_5_0 + 0.00123136123136138*G0_0_1_5_1 + 0.0123136123136127*G0_0_1_5_2 + 0.00164181497514855*G0_0_1_5_3 - 0.022985409652077*G0_0_1_5_4 - 0.0623889690556373*G0_0_1_5_5 - 0.00287317620650962*G0_1_0_0_0 - 0.00102613435946772*G0_1_0_0_1 - 0.00184704184704188*G0_1_0_0_2 + 0.0131345198011869*G0_1_0_0_3 - 0.000410453743787012*G0_1_0_0_4 - 0.00697771364438045*G0_1_0_0_5 - 0.00102613435946772*G0_1_0_1_0 - 0.00410453743787091*G0_1_0_1_1 + 0.0121083854417192*G0_1_0_1_2 - 0.0472021805355157*G0_1_0_1_3 + 0.000820907487574183*G0_1_0_1_4 - 0.00123136123136138*G0_1_0_1_5 - 0.00184704184704188*G0_1_0_2_0 + 0.0121083854417192*G0_1_0_2_1 + 0.0492544492544503*G0_1_0_2_2 + 0.0119031585698257*G0_1_0_2_3 + 0.0086195286195287*G0_1_0_2_4 - 0.0123136123136127*G0_1_0_2_5 + 0.013134519801187*G0_1_0_3_0 - 0.0472021805355156*G0_1_0_3_1 + 0.0119031585698257*G0_1_0_3_2 - 0.0656725990059349*G0_1_0_3_3 - 0.0279108545775223*G0_1_0_3_4 - 0.00164181497514855*G0_1_0_3_5 - 0.000410453743787012*G0_1_0_4_0 + 0.000820907487574179*G0_1_0_4_1 + 0.0086195286195287*G0_1_0_4_2 - 0.0279108545775223*G0_1_0_4_3 + 0.0229854096520772*G0_1_0_4_4 + 0.022985409652077*G0_1_0_4_5 - 0.00697771364438045*G0_1_0_5_0 - 0.00123136123136138*G0_1_0_5_1 - 0.0123136123136127*G0_1_0_5_2 - 0.00164181497514855*G0_1_0_5_3 + 0.022985409652077*G0_1_0_5_4 + 0.0623889690556373*G0_1_0_5_5;
    A[203] = -A[200] + 0.00944043610710299*G0_0_1_0_0 + 0.000820907487574208*G0_0_1_0_1 - 0.00410453743787086*G0_0_1_0_2 - 0.0238063171396513*G0_0_1_0_3 + 0.0254481321147996*G0_0_1_0_4 + 0.00574635241301918*G0_0_1_0_5 + 0.000820907487574209*G0_0_1_1_0 + 0.0119031585698254*G0_0_1_1_1 - 0.0205226871893546*G0_0_1_1_2 + 0.0500753567420254*G0_0_1_1_3 + 0.000820907487574195*G0_0_1_1_4 + 0.0155972422639094*G0_0_1_1_5 - 0.00410453743787086*G0_0_1_2_0 - 0.0205226871893546*G0_0_1_2_1 + 0.00820907487574161*G0_0_1_2_3 - 0.00820907487574196*G0_0_1_2_4 + 0.0246272246272254*G0_0_1_2_5 - 0.0238063171396513*G0_0_1_3_0 + 0.0500753567420253*G0_0_1_3_1 + 0.00820907487574161*G0_0_1_3_2 + 0.101792528459199*G0_0_1_3_3 + 0.0459708193041542*G0_0_1_3_4 - 0.00164181497514818*G0_0_1_3_5 + 0.0254481321147996*G0_0_1_4_0 + 0.000820907487574196*G0_0_1_4_1 - 0.00820907487574197*G0_0_1_4_2 + 0.0459708193041542*G0_0_1_4_3 - 0.193734167067508*G0_0_1_4_4 - 0.0508962642295993*G0_0_1_4_5 + 0.00574635241301918*G0_0_1_5_0 + 0.0155972422639094*G0_0_1_5_1 + 0.0246272246272254*G0_0_1_5_2 - 0.00164181497514818*G0_0_1_5_3 - 0.0508962642295993*G0_0_1_5_4 - 0.0656725990059346*G0_0_1_5_5 - 0.00902998236331581*G0_1_1_0_0 - 0.0264742664742675*G0_1_1_0_1 - 0.000205226871893538*G0_1_1_0_2 - 0.00492544492544512*G0_1_1_0_3 - 0.00328362995029667*G0_1_1_0_4 - 0.0508962642295992*G0_1_1_0_5 - 0.0264742664742675*G0_1_1_1_0 + 0.130113836780508*G0_1_1_1_1 - 0.0158024691358031*G0_1_1_1_2 + 0.0911207311207346*G0_1_1_1_3 + 0.00410453743787095*G0_1_1_1_4 + 0.142016995350334*G0_1_1_1_5 - 0.000205226871893538*G0_1_1_2_0 - 0.0158024691358031*G0_1_1_2_1 - 0.0123136123136124*G0_1_1_2_2 - 0.0328362995029675*G0_1_1_2_3 + 0.00820907487574179*G0_1_1_2_4 - 0.0147763347763353*G0_1_1_2_5 - 0.00492544492544511*G0_1_1_3_0 + 0.0911207311207346*G0_1_1_3_1 - 0.0328362995029675*G0_1_1_3_2 - 0.0853743787077148*G0_1_1_3_3 + 0.00164181497514825*G0_1_1_3_4 + 0.0394035594035609*G0_1_1_3_5 - 0.00328362995029667*G0_1_1_4_0 + 0.00410453743787095*G0_1_1_4_1 + 0.00820907487574179*G0_1_1_4_2 + 0.00164181497514825*G0_1_1_4_3 + 0.0492544492544505*G0_1_1_4_4 + 0.0213435946769286*G0_1_1_4_5 - 0.0508962642295992*G0_1_1_5_0 + 0.142016995350334*G0_1_1_5_1 - 0.0147763347763353*G0_1_1_5_2 + 0.0394035594035609*G0_1_1_5_3 + 0.0213435946769286*G0_1_1_5_4 + 0.558217091550445*G0_1_1_5_5;
    A[59] = -A[179] - 0.00902998236331615*G0_0_0_0_0 - 0.00020522687189355*G0_0_0_0_1 - 0.0264742664742673*G0_0_0_0_2 - 0.00492544492544505*G0_0_0_0_3 - 0.0508962642295991*G0_0_0_0_4 - 0.00328362995029665*G0_0_0_0_5 - 0.000205226871893549*G0_0_0_1_0 - 0.0123136123136129*G0_0_0_1_1 - 0.015802469135803*G0_0_0_1_2 - 0.0328362995029674*G0_0_0_1_3 - 0.0147763347763352*G0_0_0_1_4 + 0.00820907487574172*G0_0_0_1_5 - 0.0264742664742673*G0_0_0_2_0 - 0.015802469135803*G0_0_0_2_1 + 0.130113836780508*G0_0_0_2_2 + 0.0911207311207343*G0_0_0_2_3 + 0.142016995350333*G0_0_0_2_4 + 0.00410453743787096*G0_0_0_2_5 - 0.00492544492544505*G0_0_0_3_0 - 0.0328362995029674*G0_0_0_3_1 + 0.0911207311207343*G0_0_0_3_2 - 0.0853743787077157*G0_0_0_3_3 + 0.0394035594035605*G0_0_0_3_4 + 0.00164181497514826*G0_0_0_3_5 - 0.0508962642295991*G0_0_0_4_0 - 0.0147763347763352*G0_0_0_4_1 + 0.142016995350333*G0_0_0_4_2 + 0.0394035594035605*G0_0_0_4_3 + 0.558217091550442*G0_0_0_4_4 + 0.0213435946769286*G0_0_0_4_5 - 0.00328362995029665*G0_0_0_5_0 + 0.00820907487574172*G0_0_0_5_1 + 0.00410453743787096*G0_0_0_5_2 + 0.00164181497514825*G0_0_0_5_3 + 0.0213435946769286*G0_0_0_5_4 + 0.0492544492544507*G0_0_0_5_5 + 0.00944043610710293*G0_0_1_0_0 - 0.00410453743787093*G0_0_1_0_1 + 0.000820907487574179*G0_0_1_0_2 - 0.0238063171396512*G0_0_1_0_3 + 0.00574635241301924*G0_0_1_0_4 + 0.0254481321147997*G0_0_1_0_5 - 0.00410453743787093*G0_0_1_1_0 - 0.0205226871893546*G0_0_1_1_2 + 0.00820907487574188*G0_0_1_1_3 + 0.0246272246272255*G0_0_1_1_4 - 0.00820907487574177*G0_0_1_1_5 + 0.000820907487574179*G0_0_1_2_0 - 0.0205226871893546*G0_0_1_2_1 + 0.0119031585698257*G0_0_1_2_2 + 0.0500753567420252*G0_0_1_2_3 + 0.0155972422639096*G0_0_1_2_4 + 0.000820907487574249*G0_0_1_2_5 - 0.0238063171396512*G0_0_1_3_0 + 0.00820907487574188*G0_0_1_3_1 + 0.0500753567420252*G0_0_1_3_2 + 0.101792528459198*G0_0_1_3_3 - 0.00164181497514843*G0_0_1_3_4 + 0.0459708193041541*G0_0_1_3_5 + 0.00574635241301924*G0_0_1_4_0 + 0.0246272246272255*G0_0_1_4_1 + 0.0155972422639096*G0_0_1_4_2 - 0.00164181497514843*G0_0_1_4_3 - 0.0656725990059351*G0_0_1_4_4 - 0.0508962642295994*G0_0_1_4_5 + 0.0254481321147997*G0_0_1_5_0 - 0.00820907487574177*G0_0_1_5_1 + 0.000820907487574249*G0_0_1_5_2 + 0.0459708193041541*G0_0_1_5_3 - 0.0508962642295994*G0_0_1_5_4 - 0.193734167067507*G0_0_1_5_5;
    A[196] = 0.00979958313291679*G0_0_0_0_0 + 0.00759339426006119*G0_0_0_0_1 - 0.00541285874619226*G0_0_0_0_2 + 0.0011800545133879*G0_0_0_0_3 + 0.00518197851531203*G0_0_0_0_4 + 0.00620811287477976*G0_0_0_0_5 + 0.00759339426006119*G0_0_0_1_0 - 0.122366522366527*G0_0_0_1_1 + 0.0151611351611357*G0_0_0_1_2 - 0.0731120731120756*G0_0_0_1_3 - 0.0118518518518522*G0_0_0_1_4 - 0.0341189674523021*G0_0_0_1_5 - 0.00541285874619226*G0_0_0_2_0 + 0.0151611351611357*G0_0_0_2_1 + 0.00677248677248702*G0_0_0_2_2 + 0.0136475869809208*G0_0_0_2_3 + 0.00461760461760479*G0_0_0_2_4 + 0.00246272246272257*G0_0_0_2_5 + 0.0011800545133879*G0_0_0_3_0 - 0.0731120731120756*G0_0_0_3_1 + 0.0136475869809208*G0_0_0_3_2 - 0.0178547378547384*G0_0_0_3_3 + 0.0213435946769287*G0_0_0_3_4 - 0.00728555395222095*G0_0_0_3_5 + 0.00518197851531203*G0_0_0_4_0 - 0.0118518518518522*G0_0_0_4_1 + 0.00461760461760479*G0_0_0_4_2 + 0.0213435946769287*G0_0_0_4_3 + 0.118826358826363*G0_0_0_4_4 + 0.0187782587782594*G0_0_0_4_5 + 0.00620811287477976*G0_0_0_5_0 - 0.0341189674523021*G0_0_0_5_1 + 0.00246272246272257*G0_0_0_5_2 - 0.00728555395222095*G0_0_0_5_3 + 0.0187782587782594*G0_0_0_5_4 - 0.00861952861952899*G0_0_0_5_5 + 0.00302709636042976*G0_1_0_0_0 - 0.00756774090107452*G0_1_0_0_1 - 0.00128266794933466*G0_1_0_0_3 + 0.000564373897707234*G0_1_0_0_4 - 0.00743947410614103*G0_1_0_0_5 - 0.00756774090107452*G0_1_0_1_0 + 0.00756774090107447*G0_1_0_1_2 - 0.0389931056597735*G0_1_0_1_3 + 0.0389931056597738*G0_1_0_1_5 + 0.00756774090107447*G0_1_0_2_1 - 0.00302709636042976*G0_1_0_2_2 + 0.00743947410614101*G0_1_0_2_3 - 0.000564373897707226*G0_1_0_2_4 + 0.00128266794933466*G0_1_0_2_5 - 0.00128266794933466*G0_1_0_3_0 - 0.0389931056597735*G0_1_0_3_1 + 0.00743947410614101*G0_1_0_3_2 - 0.00923520923520938*G0_1_0_3_3 + 0.00256533589866933*G0_1_0_3_4 + 0.000564373897707234*G0_1_0_4_0 - 0.000564373897707226*G0_1_0_4_2 + 0.00256533589866933*G0_1_0_4_3 - 0.00256533589866932*G0_1_0_4_5 - 0.00743947410614103*G0_1_0_5_0 + 0.0389931056597738*G0_1_0_5_1 + 0.00128266794933466*G0_1_0_5_2 - 0.00256533589866932*G0_1_0_5_4 + 0.00923520923520956*G0_1_0_5_5;
    A[12] = A[196] - 0.132166105499443*G0_0_0_0_0 + 0.0205739939073279*G0_0_0_0_2 - 0.0130319063652401*G0_0_0_0_3 - 0.0782940516273875*G0_0_0_0_4 - 0.0403270803270817*G0_0_0_0_5 + 0.132166105499443*G0_0_0_1_1 - 0.020573993907328*G0_0_0_1_2 + 0.0782940516273876*G0_0_0_1_3 + 0.0130319063652401*G0_0_0_1_4 + 0.0403270803270818*G0_0_0_1_5 + 0.0205739939073279*G0_0_0_2_0 - 0.020573993907328*G0_0_0_2_1 - 0.00902998236331597*G0_0_0_2_3 + 0.00902998236331596*G0_0_0_2_4 - 0.0130319063652401*G0_0_0_3_0 + 0.0782940516273876*G0_0_0_3_1 - 0.00902998236331596*G0_0_0_3_2 + 0.136681096681101*G0_0_0_3_3 + 0.0260638127304804*G0_0_0_3_5 - 0.0782940516273875*G0_0_0_4_0 + 0.0130319063652401*G0_0_0_4_1 + 0.00902998236331596*G0_0_0_4_2 - 0.136681096681101*G0_0_0_4_4 - 0.0260638127304803*G0_0_0_4_5 - 0.0403270803270817*G0_0_0_5_0 + 0.0403270803270818*G0_0_0_5_1 + 0.0260638127304804*G0_0_0_5_3 - 0.0260638127304803*G0_0_0_5_4 - 0.122366522366527*G0_0_1_0_0 + 0.0151611351611357*G0_0_1_0_1 + 0.00759339426006119*G0_0_1_0_2 - 0.0118518518518522*G0_0_1_0_3 - 0.0341189674523019*G0_0_1_0_4 - 0.0731120731120757*G0_0_1_0_5 + 0.0151611351611357*G0_0_1_1_0 + 0.00677248677248702*G0_0_1_1_1 - 0.00541285874619227*G0_0_1_1_2 + 0.00461760461760478*G0_0_1_1_3 + 0.00246272246272255*G0_0_1_1_4 + 0.0136475869809208*G0_0_1_1_5 + 0.00759339426006119*G0_0_1_2_0 - 0.00541285874619227*G0_0_1_2_1 + 0.00979958313291683*G0_0_1_2_2 + 0.00518197851531205*G0_0_1_2_3 + 0.00620811287477975*G0_0_1_2_4 + 0.0011800545133879*G0_0_1_2_5 - 0.0118518518518522*G0_0_1_3_0 + 0.00461760461760478*G0_0_1_3_1 + 0.00518197851531205*G0_0_1_3_2 + 0.118826358826363*G0_0_1_3_3 + 0.0187782587782594*G0_0_1_3_4 + 0.0213435946769287*G0_0_1_3_5 - 0.0341189674523019*G0_0_1_4_0 + 0.00246272246272255*G0_0_1_4_1 + 0.00620811287477975*G0_0_1_4_2 + 0.0187782587782594*G0_0_1_4_3 - 0.00861952861952895*G0_0_1_4_4 - 0.00728555395222089*G0_0_1_4_5 - 0.0731120731120757*G0_0_1_5_0 + 0.0136475869809208*G0_0_1_5_1 + 0.0011800545133879*G0_0_1_5_2 + 0.0213435946769287*G0_0_1_5_3 - 0.0072855539522209*G0_0_1_5_4 - 0.0178547378547387*G0_0_1_5_5 - 0.125393618726956*G0_1_0_0_0 + 0.0151611351611357*G0_1_0_0_1 + 0.0151611351611357*G0_1_0_0_2 - 0.0105691839025175*G0_1_0_0_3 - 0.0736764470097827*G0_1_0_0_4 - 0.0266794933461609*G0_1_0_0_5 + 0.0151611351611357*G0_1_0_1_0 + 0.00979958313291645*G0_1_0_1_1 - 0.0129805996472667*G0_1_0_1_2 + 0.0441750841750855*G0_1_0_1_3 + 0.00118005451338789*G0_1_0_1_4 - 0.032784992784994*G0_1_0_1_5 + 0.0151611351611357*G0_1_0_2_0 - 0.0129805996472667*G0_1_0_2_1 + 0.00979958313291679*G0_1_0_2_2 - 0.00282186948853619*G0_1_0_2_3 + 0.014211960878628*G0_1_0_2_4 + 0.00118005451338789*G0_1_0_2_5 - 0.0105691839025175*G0_1_0_3_0 + 0.0441750841750855*G0_1_0_3_1 - 0.00282186948853618*G0_1_0_3_2 + 0.128061568061572*G0_1_0_3_3 + 0.0187782587782594*G0_1_0_3_4 + 0.0187782587782594*G0_1_0_3_5 - 0.0736764470097827*G0_1_0_4_0 + 0.00118005451338789*G0_1_0_4_1 + 0.014211960878628*G0_1_0_4_2 + 0.0187782587782594*G0_1_0_4_3 - 0.0178547378547383*G0_1_0_4_4 - 0.00472021805355154*G0_1_0_4_5 - 0.0266794933461609*G0_1_0_5_0 - 0.032784992784994*G0_1_0_5_1 + 0.00118005451338789*G0_1_0_5_2 + 0.0187782587782594*G0_1_0_5_3 - 0.00472021805355154*G0_1_0_5_4 - 0.0178547378547385*G0_1_0_5_5 - 0.122366522366527*G0_1_1_0_0 + 0.0151611351611357*G0_1_1_0_1 + 0.00759339426006119*G0_1_1_0_2 - 0.0118518518518522*G0_1_1_0_3 - 0.0341189674523019*G0_1_1_0_4 - 0.0731120731120757*G0_1_1_0_5 + 0.0151611351611357*G0_1_1_1_0 + 0.00677248677248695*G0_1_1_1_1 - 0.00541285874619227*G0_1_1_1_2 + 0.00461760461760475*G0_1_1_1_3 + 0.00246272246272255*G0_1_1_1_4 + 0.0136475869809207*G0_1_1_1_5 + 0.00759339426006119*G0_1_1_2_0 - 0.00541285874619227*G0_1_1_2_1 + 0.00979958313291684*G0_1_1_2_2 + 0.00518197851531207*G0_1_1_2_3 + 0.00620811287477977*G0_1_1_2_4 + 0.00118005451338792*G0_1_1_2_5 - 0.0118518518518522*G0_1_1_3_0 + 0.00461760461760475*G0_1_1_3_1 + 0.00518197851531207*G0_1_1_3_2 + 0.118826358826363*G0_1_1_3_3 + 0.0187782587782594*G0_1_1_3_4 + 0.0213435946769287*G0_1_1_3_5 - 0.0341189674523019*G0_1_1_4_0 + 0.00246272246272255*G0_1_1_4_1 + 0.00620811287477977*G0_1_1_4_2 + 0.0187782587782594*G0_1_1_4_3 - 0.00861952861952892*G0_1_1_4_4 - 0.00728555395222091*G0_1_1_4_5 - 0.0731120731120757*G0_1_1_5_0 + 0.0136475869809207*G0_1_1_5_1 + 0.00118005451338792*G0_1_1_5_2 + 0.0213435946769287*G0_1_1_5_3 - 0.00728555395222092*G0_1_1_5_4 - 0.017854737854739*G0_1_1_5_5;
    A[180] = A[12] - 0.00756774090107452*G0_0_1_0_1 + 0.00756774090107446*G0_0_1_0_2 - 0.0389931056597735*G0_0_1_0_4 + 0.0389931056597738*G0_0_1_0_5 - 0.00756774090107452*G0_0_1_1_0 + 0.00302709636042981*G0_0_1_1_1 + 0.000564373897707234*G0_0_1_1_3 - 0.00128266794933467*G0_0_1_1_4 - 0.00743947410614105*G0_0_1_1_5 + 0.00756774090107446*G0_0_1_2_0 - 0.00302709636042979*G0_0_1_2_2 - 0.000564373897707236*G0_0_1_2_3 + 0.00743947410614098*G0_0_1_2_4 + 0.00128266794933465*G0_0_1_2_5 + 0.000564373897707232*G0_0_1_3_1 - 0.000564373897707237*G0_0_1_3_2 + 0.00256533589866934*G0_0_1_3_4 - 0.00256533589866934*G0_0_1_3_5 - 0.0389931056597735*G0_0_1_4_0 - 0.00128266794933467*G0_0_1_4_1 + 0.00743947410614098*G0_0_1_4_2 + 0.00256533589866933*G0_0_1_4_3 - 0.00923520923520925*G0_0_1_4_4 + 0.0389931056597738*G0_0_1_5_0 - 0.00743947410614105*G0_0_1_5_1 + 0.00128266794933465*G0_0_1_5_2 - 0.00256533589866934*G0_0_1_5_3 + 0.00923520923520972*G0_0_1_5_5 + 0.00756774090107452*G0_1_0_0_1 - 0.00756774090107446*G0_1_0_0_2 + 0.0389931056597735*G0_1_0_0_4 - 0.0389931056597738*G0_1_0_0_5 + 0.00756774090107453*G0_1_0_1_0 - 0.00302709636042981*G0_1_0_1_1 - 0.000564373897707232*G0_1_0_1_3 + 0.00128266794933468*G0_1_0_1_4 + 0.00743947410614105*G0_1_0_1_5 - 0.00756774090107446*G0_1_0_2_0 + 0.00302709636042979*G0_1_0_2_2 + 0.000564373897707235*G0_1_0_2_3 - 0.00743947410614098*G0_1_0_2_4 - 0.00128266794933465*G0_1_0_2_5 - 0.000564373897707231*G0_1_0_3_1 + 0.000564373897707236*G0_1_0_3_2 - 0.00256533589866933*G0_1_0_3_4 + 0.00256533589866934*G0_1_0_3_5 + 0.0389931056597735*G0_1_0_4_0 + 0.00128266794933467*G0_1_0_4_1 - 0.00743947410614098*G0_1_0_4_2 - 0.00256533589866933*G0_1_0_4_3 + 0.00923520923520926*G0_1_0_4_4 - 0.0389931056597738*G0_1_0_5_0 + 0.00743947410614105*G0_1_0_5_1 - 0.00128266794933465*G0_1_0_5_2 + 0.00256533589866934*G0_1_0_5_3 - 0.00923520923520974*G0_1_0_5_5;
    A[28] = A[196] + 0.00302709636042976*G0_0_1_0_0 - 0.00756774090107452*G0_0_1_0_1 - 0.00128266794933466*G0_0_1_0_3 + 0.000564373897707242*G0_0_1_0_4 - 0.00743947410614103*G0_0_1_0_5 - 0.00756774090107452*G0_0_1_1_0 + 0.00756774090107447*G0_0_1_1_2 - 0.0389931056597735*G0_0_1_1_3 + 0.0389931056597738*G0_0_1_1_5 + 0.00756774090107447*G0_0_1_2_1 - 0.00302709636042976*G0_0_1_2_2 + 0.007439474106141*G0_0_1_2_3 - 0.000564373897707235*G0_0_1_2_4 + 0.00128266794933466*G0_0_1_2_5 - 0.00128266794933466*G0_0_1_3_0 - 0.0389931056597735*G0_0_1_3_1 + 0.007439474106141*G0_0_1_3_2 - 0.00923520923520939*G0_0_1_3_3 + 0.00256533589866933*G0_0_1_3_4 + 0.000564373897707243*G0_0_1_4_0 - 0.000564373897707235*G0_0_1_4_2 + 0.00256533589866933*G0_0_1_4_3 - 0.00256533589866931*G0_0_1_4_5 - 0.00743947410614103*G0_0_1_5_0 + 0.0389931056597738*G0_0_1_5_1 + 0.00128266794933466*G0_0_1_5_2 - 0.00256533589866931*G0_0_1_5_4 + 0.00923520923520958*G0_0_1_5_5 - 0.00302709636042976*G0_1_0_0_0 + 0.00756774090107452*G0_1_0_0_1 + 0.00128266794933466*G0_1_0_0_3 - 0.000564373897707243*G0_1_0_0_4 + 0.00743947410614103*G0_1_0_0_5 + 0.00756774090107452*G0_1_0_1_0 - 0.00756774090107447*G0_1_0_1_2 + 0.0389931056597735*G0_1_0_1_3 - 0.0389931056597738*G0_1_0_1_5 - 0.00756774090107447*G0_1_0_2_1 + 0.00302709636042976*G0_1_0_2_2 - 0.007439474106141*G0_1_0_2_3 + 0.000564373897707234*G0_1_0_2_4 - 0.00128266794933466*G0_1_0_2_5 + 0.00128266794933466*G0_1_0_3_0 + 0.0389931056597735*G0_1_0_3_1 - 0.007439474106141*G0_1_0_3_2 + 0.00923520923520939*G0_1_0_3_3 - 0.00256533589866933*G0_1_0_3_4 - 0.000564373897707243*G0_1_0_4_0 + 0.000564373897707234*G0_1_0_4_2 - 0.00256533589866933*G0_1_0_4_3 + 0.00256533589866931*G0_1_0_4_5 + 0.00743947410614103*G0_1_0_5_0 - 0.0389931056597738*G0_1_0_5_1 - 0.00128266794933466*G0_1_0_5_2 + 0.00256533589866931*G0_1_0_5_4 - 0.00923520923520956*G0_1_0_5_5;
    A[27] = -A[28] - 0.0124162257495595*G0_0_0_0_0 + 0.0063620330286999*G0_0_0_0_1 - 0.000666987333654026*G0_0_0_0_2 + 0.000513067179733874*G0_0_0_0_3 - 0.0173416706750045*G0_0_0_0_4 + 0.0026679493346161*G0_0_0_0_5 + 0.0063620330286999*G0_0_0_1_0 - 0.0887606220939583*G0_0_0_1_1 + 0.00969696969697003*G0_0_0_1_2 - 0.0499727433060783*G0_0_0_1_3 - 0.00502805836139187*G0_0_0_1_4 - 0.0275004008337352*G0_0_0_1_5 - 0.000666987333654027*G0_0_0_2_0 + 0.00969696969697002*G0_0_0_2_1 + 0.0110822510822515*G0_0_0_2_2 + 0.0116979316979321*G0_0_0_2_3 + 0.0149815616482288*G0_0_0_2_4 + 0.000615680615680644*G0_0_0_2_5 + 0.000513067179733874*G0_0_0_3_0 - 0.0499727433060783*G0_0_0_3_1 + 0.0116979316979321*G0_0_0_3_2 - 0.0119031585698256*G0_0_0_3_3 + 0.009029982363316*G0_0_0_3_4 - 0.00225749559082904*G0_0_0_3_5 - 0.0173416706750045*G0_0_0_4_0 - 0.00502805836139187*G0_0_0_4_1 + 0.0149815616482288*G0_0_0_4_2 + 0.009029982363316*G0_0_0_4_3 + 0.00533589866923218*G0_0_0_4_4 + 0.00882475549142249*G0_0_0_4_5 + 0.0026679493346161*G0_0_0_5_0 - 0.0275004008337352*G0_0_0_5_1 + 0.000615680615680643*G0_0_0_5_2 - 0.00225749559082904*G0_0_0_5_3 + 0.00882475549142249*G0_0_0_5_4 + 0.0041045374378709*G0_0_0_5_5 + 0.00410453743787087*G0_0_1_0_0 - 0.0080038480038483*G0_0_1_0_1 - 0.000461760461760479*G0_0_1_0_2 + 0.000615680615680629*G0_0_1_0_3 + 0.00410453743787089*G0_0_1_0_4 + 0.00584896584896604*G0_0_1_0_5 - 0.0080038480038483*G0_0_1_1_0 + 0.0048228314894983*G0_0_1_1_2 - 0.026166426166427*G0_0_1_1_3 + 0.00318101651434995*G0_0_1_1_4 + 0.0261664261664272*G0_0_1_1_5 - 0.000461760461760479*G0_0_1_2_0 + 0.0048228314894983*G0_0_1_2_1 - 0.000923520923520915*G0_0_1_2_2 + 0.00749078082411439*G0_0_1_2_3 + 0.000923520923520981*G0_0_1_2_4 + 0.00061568061568063*G0_0_1_3_0 - 0.026166426166427*G0_0_1_3_1 + 0.00749078082411439*G0_0_1_3_2 - 0.00697771364438047*G0_0_1_3_3 - 0.00759339426006116*G0_0_1_3_4 - 0.00123136123136126*G0_0_1_3_5 + 0.00410453743787089*G0_0_1_4_0 + 0.00318101651434995*G0_0_1_4_1 + 0.000923520923520981*G0_0_1_4_2 - 0.00759339426006116*G0_0_1_4_3 - 0.0123136123136127*G0_0_1_4_4 - 0.0063620330286999*G0_0_1_4_5 + 0.00584896584896604*G0_0_1_5_0 + 0.0261664261664272*G0_0_1_5_1 - 0.00123136123136126*G0_0_1_5_3 - 0.0063620330286999*G0_0_1_5_4 + 0.00944043610710316*G0_0_1_5_5;
    A[29] = -A[27] - 0.0200096200096206*G0_0_0_0_0 - 0.00395061728395076*G0_0_0_0_1 + 0.00995350328683694*G0_0_0_0_2 - 0.00123136123136128*G0_0_0_0_3 - 0.0136475869809208*G0_0_0_0_4 - 0.00554112554112574*G0_0_0_0_5 - 0.00395061728395076*G0_0_0_1_0 + 0.0672118005451365*G0_0_0_1_1 - 0.00625941959275316*G0_0_0_1_2 + 0.0425845759179107*G0_0_0_1_3 + 0.0104665704665708*G0_0_0_1_4 + 0.0169312169312176*G0_0_0_1_5 + 0.00995350328683694*G0_0_0_2_0 - 0.00625941959275316*G0_0_0_2_1 - 0.0189834856501529*G0_0_0_2_2 - 0.0187782587782594*G0_0_0_2_3 - 0.0156998556998562*G0_0_0_2_4 - 0.00441237774571125*G0_0_0_2_5 - 0.00123136123136128*G0_0_0_3_0 + 0.0425845759179107*G0_0_0_3_1 - 0.0187782587782594*G0_0_0_3_2 + 0.0184704184704192*G0_0_0_3_3 - 0.018470418470419*G0_0_0_3_4 + 0.0112874779541451*G0_0_0_3_5 - 0.0136475869809208*G0_0_0_4_0 + 0.0104665704665708*G0_0_0_4_1 - 0.0156998556998562*G0_0_0_4_2 - 0.018470418470419*G0_0_0_4_3 - 0.214667308000648*G0_0_0_4_4 - 0.0121083854417191*G0_0_0_4_5 - 0.00554112554112574*G0_0_0_5_0 + 0.0169312169312176*G0_0_0_5_1 - 0.00441237774571125*G0_0_0_5_2 + 0.0112874779541451*G0_0_0_5_3 - 0.0121083854417191*G0_0_0_5_4 + 0.0164181497514837*G0_0_0_5_5 - 0.00102613435946771*G0_0_1_0_0 + 0.00230880230880241*G0_0_1_0_1 + 0.00318101651434995*G0_0_1_0_3 + 0.00205226871893546*G0_0_1_0_4 + 0.0132371332371337*G0_0_1_0_5 + 0.00230880230880241*G0_0_1_1_0 - 0.00230880230880238*G0_0_1_1_2 + 0.0256533589866931*G0_0_1_1_3 - 0.0256533589866933*G0_0_1_1_5 - 0.00230880230880238*G0_0_1_2_1 + 0.00102613435946774*G0_0_1_2_2 - 0.0132371332371337*G0_0_1_2_3 - 0.00205226871893545*G0_0_1_2_4 - 0.00318101651434996*G0_0_1_2_5 + 0.00318101651434995*G0_0_1_3_0 + 0.0256533589866931*G0_0_1_3_1 - 0.0132371332371337*G0_0_1_3_2 + 0.00205226871893549*G0_0_1_3_3 - 0.0063620330286999*G0_0_1_3_4 + 0.00205226871893546*G0_0_1_4_0 - 0.00205226871893545*G0_0_1_4_2 - 0.0063620330286999*G0_0_1_4_3 + 0.00636203302869993*G0_0_1_4_5 + 0.0132371332371337*G0_0_1_5_0 - 0.0256533589866933*G0_0_1_5_1 - 0.00318101651434996*G0_0_1_5_2 + 0.00636203302869993*G0_0_1_5_4 - 0.00205226871893548*G0_0_1_5_5;
    A[209] = A[223] - 0.00985088985089009*G0_0_1_0_0 + 0.0172390572390578*G0_0_1_0_1 + 0.0172390572390577*G0_0_1_0_2 - 0.0394035594035607*G0_0_1_0_4 - 0.0394035594035606*G0_0_1_0_5 + 0.0172390572390578*G0_0_1_1_0 - 0.0246272246272255*G0_0_1_1_1 + 0.0344781144781156*G0_0_1_1_2 - 0.0689562289562314*G0_0_1_1_3 - 0.0591053391053411*G0_0_1_1_4 - 0.0886580086580116*G0_0_1_1_5 + 0.0172390572390577*G0_0_1_2_0 + 0.0344781144781156*G0_0_1_2_1 - 0.024627224627225*G0_0_1_2_2 - 0.068956228956231*G0_0_1_2_3 - 0.0886580086580113*G0_0_1_2_4 - 0.0591053391053411*G0_0_1_2_5 - 0.0689562289562315*G0_0_1_3_1 - 0.068956228956231*G0_0_1_3_2 - 0.315228475228487*G0_0_1_3_3 + 0.118210678210682*G0_0_1_3_4 + 0.118210678210682*G0_0_1_3_5 - 0.0394035594035607*G0_0_1_4_0 - 0.0591053391053411*G0_0_1_4_1 - 0.0886580086580113*G0_0_1_4_2 + 0.118210678210682*G0_0_1_4_3 + 0.157614237614244*G0_0_1_4_4 + 0.236421356421365*G0_0_1_4_5 - 0.0394035594035606*G0_0_1_5_0 - 0.0886580086580117*G0_0_1_5_1 - 0.0591053391053411*G0_0_1_5_2 + 0.118210678210682*G0_0_1_5_3 + 0.236421356421365*G0_0_1_5_4 + 0.157614237614244*G0_0_1_5_5 + 0.00985088985089009*G0_1_0_0_0 - 0.0172390572390578*G0_1_0_0_1 - 0.0172390572390577*G0_1_0_0_2 + 0.0394035594035607*G0_1_0_0_4 + 0.0394035594035606*G0_1_0_0_5 - 0.0172390572390578*G0_1_0_1_0 + 0.0246272246272255*G0_1_0_1_1 - 0.0344781144781156*G0_1_0_1_2 + 0.0689562289562314*G0_1_0_1_3 + 0.0591053391053411*G0_1_0_1_4 + 0.0886580086580116*G0_1_0_1_5 - 0.0172390572390577*G0_1_0_2_0 - 0.0344781144781156*G0_1_0_2_1 + 0.024627224627225*G0_1_0_2_2 + 0.068956228956231*G0_1_0_2_3 + 0.0886580086580113*G0_1_0_2_4 + 0.0591053391053411*G0_1_0_2_5 + 0.0689562289562315*G0_1_0_3_1 + 0.068956228956231*G0_1_0_3_2 + 0.315228475228487*G0_1_0_3_3 - 0.118210678210682*G0_1_0_3_4 - 0.118210678210682*G0_1_0_3_5 + 0.0394035594035607*G0_1_0_4_0 + 0.0591053391053411*G0_1_0_4_1 + 0.0886580086580113*G0_1_0_4_2 - 0.118210678210682*G0_1_0_4_3 - 0.157614237614244*G0_1_0_4_4 - 0.236421356421365*G0_1_0_4_5 + 0.0394035594035607*G0_1_0_5_0 + 0.0886580086580117*G0_1_0_5_1 + 0.0591053391053411*G0_1_0_5_2 - 0.118210678210682*G0_1_0_5_3 - 0.236421356421365*G0_1_0_5_4 - 0.157614237614244*G0_1_0_5_5;
    A[13] = A[195] + 0.000436107102773807*G0_0_1_0_1 + 0.00274490941157618*G0_0_1_0_2 - 0.00318101651434996*G0_0_1_0_3 - 0.0128266794933467*G0_0_1_0_4 + 0.0128266794933465*G0_0_1_0_5 + 0.000436107102773807*G0_0_1_1_0 - 0.00107744107744115*G0_0_1_1_1 + 0.000461760461760479*G0_0_1_1_2 - 0.00354016354016368*G0_0_1_1_3 - 0.00189834856501529*G0_0_1_1_4 - 0.0132884399551071*G0_0_1_1_5 + 0.00274490941157618*G0_0_1_2_0 + 0.000461760461760478*G0_0_1_2_1 - 0.00210357543690884*G0_0_1_2_2 - 0.00148789482122819*G0_0_1_2_3 + 0.00128266794933468*G0_0_1_2_5 - 0.00318101651434996*G0_0_1_3_0 - 0.00354016354016368*G0_0_1_3_1 - 0.00148789482122819*G0_0_1_3_2 + 0.0123136123136127*G0_0_1_3_3 + 0.0101587301587305*G0_0_1_3_4 + 0.00379669713003056*G0_0_1_3_5 - 0.0128266794933467*G0_0_1_4_0 - 0.00189834856501529*G0_0_1_4_1 + 0.0101587301587305*G0_0_1_4_3 - 0.00225749559082891*G0_0_1_4_4 + 0.00123136123136122*G0_0_1_4_5 + 0.0128266794933465*G0_0_1_5_0 - 0.0132884399551071*G0_0_1_5_1 + 0.00128266794933468*G0_0_1_5_2 + 0.00379669713003056*G0_0_1_5_3 + 0.00123136123136122*G0_0_1_5_4 - 0.000205226871893725*G0_0_1_5_5 - 0.000436107102773807*G0_1_0_0_1 - 0.00274490941157618*G0_1_0_0_2 + 0.00318101651434996*G0_1_0_0_3 + 0.0128266794933467*G0_1_0_0_4 - 0.0128266794933465*G0_1_0_0_5 - 0.000436107102773807*G0_1_0_1_0 + 0.00107744107744116*G0_1_0_1_1 - 0.00046176046176048*G0_1_0_1_2 + 0.00354016354016369*G0_1_0_1_3 + 0.00189834856501529*G0_1_0_1_4 + 0.0132884399551071*G0_1_0_1_5 - 0.00274490941157618*G0_1_0_2_0 - 0.00046176046176048*G0_1_0_2_1 + 0.00210357543690884*G0_1_0_2_2 + 0.00148789482122819*G0_1_0_2_3 - 0.00128266794933468*G0_1_0_2_5 + 0.00318101651434996*G0_1_0_3_0 + 0.00354016354016369*G0_1_0_3_1 + 0.00148789482122818*G0_1_0_3_2 - 0.0123136123136127*G0_1_0_3_3 - 0.0101587301587305*G0_1_0_3_4 - 0.00379669713003056*G0_1_0_3_5 + 0.0128266794933467*G0_1_0_4_0 + 0.00189834856501529*G0_1_0_4_1 - 0.0101587301587305*G0_1_0_4_3 + 0.00225749559082891*G0_1_0_4_4 - 0.00123136123136122*G0_1_0_4_5 - 0.0128266794933465*G0_1_0_5_0 + 0.0132884399551071*G0_1_0_5_1 - 0.00128266794933468*G0_1_0_5_2 - 0.00379669713003056*G0_1_0_5_3 - 0.00123136123136122*G0_1_0_5_4 + 0.00020522687189372*G0_1_0_5_5;
    A[53] = -A[50] - 0.00451499118165793*G0_0_1_0_0 - 0.000752498530276334*G0_0_1_0_1 + 0.00136817914595695*G0_0_1_0_2 + 0.027089947089948*G0_0_1_0_3 - 0.0030099941211053*G0_0_1_0_4 + 0.00916680027791171*G0_0_1_0_5 - 0.000752498530276334*G0_0_1_1_0 - 0.00697771364438061*G0_0_1_1_1 + 0.0177863288974406*G0_0_1_1_2 - 0.027637218748331*G0_0_1_1_3 + 0.00246272246272255*G0_0_1_1_4 - 0.000684089572978515*G0_0_1_1_5 + 0.00136817914595694*G0_0_1_2_0 + 0.0177863288974406*G0_0_1_2_1 - 0.121083854417192*G0_0_1_2_2 - 0.0164181497514836*G0_0_1_2_3 + 0.00547271658382785*G0_0_1_2_5 + 0.027089947089948*G0_0_1_3_0 - 0.027637218748331*G0_0_1_3_1 - 0.0164181497514836*G0_0_1_3_2 - 0.220003206669881*G0_0_1_3_3 - 0.0591053391053412*G0_0_1_3_4 - 0.0651253273475518*G0_0_1_3_5 - 0.00300999412110531*G0_0_1_4_0 + 0.00246272246272255*G0_0_1_4_1 - 0.0591053391053412*G0_0_1_4_3 + 0.0755234888568248*G0_0_1_4_4 - 0.0158708780931008*G0_0_1_4_5 + 0.00916680027791171*G0_0_1_5_0 - 0.000684089572978515*G0_0_1_5_1 + 0.00547271658382785*G0_0_1_5_2 - 0.0651253273475518*G0_0_1_5_3 - 0.0158708780931008*G0_0_1_5_4 - 0.0142290631179524*G0_0_1_5_5 + 0.00574635241301933*G0_1_1_0_0 - 0.0160076960076967*G0_1_1_0_1 - 0.000752498530276332*G0_1_1_0_2 + 0.00177863288974405*G0_1_1_0_3 - 0.0042413553524666*G0_1_1_0_4 - 0.0158708780931009*G0_1_1_0_5 - 0.0160076960076967*G0_1_1_1_0 + 0.192913259579935*G0_1_1_1_1 - 0.000684089572978538*G0_1_1_1_2 - 0.00643044198599756*G0_1_1_1_3 - 0.00177863288974408*G0_1_1_1_4 + 0.0803121158676747*G0_1_1_1_5 - 0.000752498530276332*G0_1_1_2_0 - 0.000684089572978537*G0_1_1_2_1 - 0.00410453743787073*G0_1_1_2_2 + 0.0109454331676558*G0_1_1_2_3 + 0.00547271658382789*G0_1_1_2_4 + 0.000410453743787062*G0_1_1_2_5 + 0.00177863288974405*G0_1_1_3_0 - 0.00643044198599755*G0_1_1_3_1 + 0.0109454331676558*G0_1_1_3_2 - 0.065125327347552*G0_1_1_3_3 - 0.00437817326706224*G0_1_1_3_5 - 0.0042413553524666*G0_1_1_4_0 - 0.00177863288974408*G0_1_1_4_1 + 0.00547271658382789*G0_1_1_4_2 + 0.0158708780931009*G0_1_1_4_4 + 0.00273635829191395*G0_1_1_4_5 - 0.0158708780931009*G0_1_1_5_0 + 0.0803121158676747*G0_1_1_5_1 + 0.000410453743787062*G0_1_1_5_2 - 0.00437817326706224*G0_1_1_5_3 + 0.00273635829191395*G0_1_1_5_4 + 0.0902998236331602*G0_1_1_5_5;
    A[30] = -A[31] + 0.0161872695206034*G0_1_0_0_0 + 0.000678745123189588*G0_1_0_0_2 + 0.000401902624124859*G0_1_0_0_3 + 0.00147079258190375*G0_1_0_0_4 + 0.00605846828069073*G0_1_0_0_5 - 0.0161872695206036*G0_1_0_1_1 - 0.000678745123189584*G0_1_0_1_2 - 0.00147079258190376*G0_1_0_1_3 - 0.000401902624124859*G0_1_0_1_4 - 0.00605846828069076*G0_1_0_1_5 + 0.000678745123189588*G0_1_0_2_0 - 0.000678745123189583*G0_1_0_2_1 + 0.00458767569878696*G0_1_0_2_3 - 0.00458767569878696*G0_1_0_2_4 + 0.000401902624124859*G0_1_0_3_0 - 0.00147079258190376*G0_1_0_3_1 + 0.00458767569878696*G0_1_0_3_2 + 0.00560953449842359*G0_1_0_3_3 - 0.000803805248249721*G0_1_0_3_5 + 0.00147079258190375*G0_1_0_4_0 - 0.000401902624124858*G0_1_0_4_1 - 0.00458767569878696*G0_1_0_4_2 - 0.00560953449842356*G0_1_0_4_4 + 0.000803805248249721*G0_1_0_4_5 + 0.00605846828069073*G0_1_0_5_0 - 0.00605846828069076*G0_1_0_5_1 - 0.000803805248249722*G0_1_0_5_3 + 0.00080380524824972*G0_1_0_5_4 + 0.0161696328363001*G0_1_1_0_0 - 0.00119742397520179*G0_1_1_0_1 - 0.00051867885201221*G0_1_1_0_2 + 0.000816631927743073*G0_1_1_0_4 + 0.00540430762653005*G0_1_1_0_5 - 0.00119742397520179*G0_1_1_1_0 - 0.0011974239752018*G0_1_1_1_2 - 0.000654160654160681*G0_1_1_1_3 - 0.00044145155256268*G0_1_1_1_4 - 0.000654160654160685*G0_1_1_1_5 - 0.00051867885201221*G0_1_1_2_0 - 0.0011974239752018*G0_1_1_2_1 + 0.0161696328363002*G0_1_1_2_2 + 0.00540430762653006*G0_1_1_2_3 + 0.000816631927743091*G0_1_1_2_4 - 0.000654160654160681*G0_1_1_3_1 + 0.00540430762653006*G0_1_1_3_2 + 0.00344610122387915*G0_1_1_3_3 + 0.000962000962001004*G0_1_1_3_4 + 0.00015819571375128*G0_1_1_3_5 + 0.000816631927743073*G0_1_1_4_0 - 0.00044145155256268*G0_1_1_4_1 + 0.000816631927743091*G0_1_1_4_2 + 0.000962000962001004*G0_1_1_4_3 - 0.00216343327454444*G0_1_1_4_4 + 0.000962000962000999*G0_1_1_4_5 + 0.00540430762653005*G0_1_1_5_0 - 0.000654160654160685*G0_1_1_5_1 + 0.00015819571375128*G0_1_1_5_3 + 0.000962000962000999*G0_1_1_5_4 + 0.00344610122387911*G0_1_1_5_5;
    A[23] = -A[21] + 0.0153407086740425*G0_0_0_0_0 + 0.000735396290951857*G0_0_0_0_1 - 0.00539575650686779*G0_0_0_0_2 + 0.000530169419058316*G0_0_0_0_3 + 0.01287798621132*G0_0_0_0_4 - 0.000666987333654038*G0_0_0_0_5 + 0.000735396290951857*G0_0_0_1_0 - 0.0125701459034795*G0_0_0_1_1 + 0.00146224146224151*G0_0_0_1_2 - 0.00391641280530185*G0_0_0_1_3 - 0.000530169419058315*G0_0_0_1_4 - 0.000701191812302883*G0_0_0_1_5 - 0.00539575650686779*G0_0_0_2_0 + 0.00146224146224151*G0_0_0_2_1 + 0.0384800384800397*G0_0_0_2_2 - 0.00140238362460587*G0_0_0_2_3 + 0.0081748703970929*G0_0_0_2_4 + 0.00157340601785053*G0_0_0_2_5 + 0.000530169419058316*G0_0_0_3_0 - 0.00391641280530185*G0_0_0_3_1 - 0.00140238362460587*G0_0_0_3_2 - 0.0147079258190374*G0_0_0_3_3 - 0.00420715087381769*G0_0_0_3_5 + 0.01287798621132*G0_0_0_4_0 - 0.000530169419058316*G0_0_0_4_1 + 0.0081748703970929*G0_0_0_4_2 + 0.0549323927101722*G0_0_0_4_4 - 0.00208647319758441*G0_0_0_4_5 - 0.000666987333654038*G0_0_0_5_0 - 0.000701191812302883*G0_0_0_5_1 + 0.00157340601785053*G0_0_0_5_2 - 0.00420715087381769*G0_0_0_5_3 - 0.00208647319758441*G0_0_0_5_4 - 0.00971407193629445*G0_0_0_5_5 - 0.0231393298059974*G0_0_1_0_0 - 0.000726845171289664*G0_0_1_0_1 - 0.00104323659879219*G0_0_1_0_3 + 0.00470311581422705*G0_0_1_0_4 + 0.000735396290951838*G0_0_1_0_5 - 0.000726845171289664*G0_0_1_1_0 + 0.000726845171289626*G0_0_1_1_2 - 0.00321522099299883*G0_0_1_1_3 + 0.003215220992999*G0_0_1_1_5 + 0.000726845171289626*G0_0_1_2_1 + 0.0231393298059972*G0_0_1_2_2 - 0.000735396290951857*G0_0_1_2_3 - 0.00470311581422708*G0_0_1_2_4 + 0.00104323659879219*G0_0_1_2_5 - 0.00104323659879219*G0_0_1_3_0 - 0.00321522099299883*G0_0_1_3_1 - 0.000735396290951857*G0_0_1_3_2 - 0.00499385388274289*G0_0_1_3_3 + 0.00208647319758437*G0_0_1_3_4 + 0.00470311581422705*G0_0_1_4_0 - 0.00470311581422708*G0_0_1_4_2 + 0.00208647319758437*G0_0_1_4_3 - 0.00208647319758441*G0_0_1_4_5 + 0.000735396290951839*G0_0_1_5_0 + 0.003215220992999*G0_0_1_5_1 + 0.00104323659879219*G0_0_1_5_2 - 0.00208647319758441*G0_0_1_5_4 + 0.004993853882743*G0_0_1_5_5;
    A[20] = -A[23] - 0.000949174282507679*G0_0_1_0_0 - 0.00628934851157099*G0_0_1_0_1 - 0.000671262893485128*G0_0_1_0_2 - 0.00427555983111553*G0_0_1_0_3 + 0.00230880230880237*G0_0_1_0_4 - 0.00395061728395078*G0_0_1_0_5 - 0.00628934851157099*G0_0_1_1_0 + 0.0896584896584935*G0_0_1_1_1 - 0.00325370103147894*G0_0_1_1_2 + 0.0001881246325692*G0_0_1_1_3 - 0.000718294051627414*G0_0_1_1_4 + 0.0290567046122614*G0_0_1_1_5 - 0.000671262893485128*G0_0_1_2_0 - 0.00325370103147894*G0_0_1_2_1 + 0.0211640211640218*G0_0_1_2_2 + 0.00855111966223105*G0_0_1_2_3 - 0.000342044786489259*G0_0_1_2_4 - 0.00427555983111553*G0_0_1_3_0 + 0.000188124632569202*G0_0_1_3_1 + 0.00855111966223105*G0_0_1_3_2 + 0.0124504302282084*G0_0_1_3_3 + 0.00998770776548587*G0_0_1_3_4 + 0.00865373309817786*G0_0_1_3_5 + 0.00230880230880237*G0_0_1_4_0 - 0.000718294051627414*G0_0_1_4_1 - 0.000342044786489259*G0_0_1_4_2 + 0.00998770776548587*G0_0_1_4_3 - 0.0201122334455675*G0_0_1_4_4 + 0.00153920153920158*G0_0_1_4_5 - 0.00395061728395078*G0_0_1_5_0 + 0.0290567046122614*G0_0_1_5_1 + 0.00865373309817786*G0_0_1_5_3 + 0.00153920153920158*G0_0_1_5_4 + 0.019496552829887*G0_0_1_5_5;
    A[5] = -A[20] - 0.00718294051627408*G0_0_0_0_0 + 0.00357436801881258*G0_0_0_0_2 - 0.000855111966223097*G0_0_0_0_3 + 0.00208647319758439*G0_0_0_0_4 - 0.0015734060178505*G0_0_0_0_5 + 0.007182940516274*G0_0_0_1_1 - 0.00357436801881258*G0_0_0_1_2 - 0.00208647319758438*G0_0_0_1_3 + 0.000855111966223106*G0_0_0_1_4 + 0.00157340601785049*G0_0_0_1_5 + 0.00357436801881258*G0_0_0_2_0 - 0.00357436801881258*G0_0_0_2_1 + 0.0155288333066116*G0_0_0_2_3 - 0.0155288333066116*G0_0_0_2_4 - 0.000855111966223097*G0_0_0_3_0 - 0.00208647319758438*G0_0_0_3_1 + 0.0155288333066116*G0_0_0_3_2 + 0.0285949441505007*G0_0_0_3_3 + 0.00171022393244621*G0_0_0_3_5 + 0.00208647319758439*G0_0_0_4_0 + 0.000855111966223106*G0_0_0_4_1 - 0.0155288333066116*G0_0_0_4_2 - 0.0285949441505006*G0_0_0_4_4 - 0.00171022393244622*G0_0_0_4_5 - 0.00157340601785051*G0_0_0_5_0 + 0.00157340601785049*G0_0_0_5_1 + 0.00171022393244621*G0_0_0_5_3 - 0.00171022393244622*G0_0_0_5_4 - 0.00466891133557812*G0_0_1_0_0 - 0.00492544492544513*G0_0_1_0_1 + 0.000256533589866942*G0_0_1_0_2 - 0.00389931056597735*G0_0_1_0_3 - 0.000513067179733854*G0_0_1_0_4 - 0.00769600769600797*G0_0_1_0_5 - 0.00492544492544513*G0_0_1_1_0 + 0.0931216931216969*G0_0_1_1_1 - 0.00590027256693945*G0_0_1_1_2 - 0.00472021805355145*G0_0_1_1_3 + 0.00051306717973386*G0_0_1_1_4 + 0.0268847202180547*G0_0_1_1_5 + 0.000256533589866942*G0_0_1_2_0 - 0.00590027256693945*G0_0_1_2_1 + 0.0150328683662022*G0_0_1_2_2 + 0.0244219977553319*G0_0_1_2_3 - 0.000513067179733868*G0_0_1_2_5 - 0.00389931056597735*G0_0_1_3_0 - 0.00472021805355145*G0_0_1_3_1 + 0.0244219977553319*G0_0_1_3_2 + 0.0543851210517895*G0_0_1_3_3 + 0.00677248677248697*G0_0_1_3_4 + 0.00882475549142248*G0_0_1_3_5 - 0.000513067179733854*G0_0_1_4_0 + 0.00051306717973386*G0_0_1_4_1 + 0.00677248677248697*G0_0_1_4_3 - 0.00677248677248706*G0_0_1_4_4 - 0.00769600769600797*G0_0_1_5_0 + 0.0268847202180547*G0_0_1_5_1 - 0.000513067179733868*G0_0_1_5_2 + 0.00882475549142248*G0_0_1_5_3 + 0.015392015392016*G0_0_1_5_5 - 0.00628507295173981*G0_1_0_0_0 + 0.000448933782267127*G0_1_0_0_1 + 0.000555822778045007*G0_1_0_0_2 - 0.000171022393244618*G0_1_0_0_3 - 0.000701191812302939*G0_1_0_0_4 - 0.00160761049649944*G0_1_0_0_5 + 0.000448933782267127*G0_1_0_1_0 + 0.00089786756453426*G0_1_0_1_1 - 0.00301854524076758*G0_1_0_1_2 - 0.00278766500988733*G0_1_0_1_3 + 0.000684089572978485*G0_1_0_1_4 + 0.000555822778045008*G0_1_0_2_0 - 0.00301854524076758*G0_1_0_2_1 + 0.0350168350168365*G0_1_0_2_2 + 0.014690823579713*G0_1_0_2_3 - 0.000838009726898591*G0_1_0_2_4 + 0.000153920153920165*G0_1_0_2_5 - 0.000171022393244618*G0_1_0_3_0 - 0.00278766500988733*G0_1_0_3_1 + 0.014690823579713*G0_1_0_3_2 + 0.0163497407941858*G0_1_0_3_3 - 0.00102613435946773*G0_1_0_3_4 - 0.000701191812302939*G0_1_0_4_0 + 0.000684089572978485*G0_1_0_4_1 - 0.000838009726898591*G0_1_0_4_2 - 0.00102613435946773*G0_1_0_4_3 - 0.0122452033563149*G0_1_0_4_4 - 0.00167601945379729*G0_1_0_4_5 - 0.00160761049649944*G0_1_0_5_0 + 0.000153920153920165*G0_1_0_5_2 - 0.00167601945379729*G0_1_0_5_4 - 0.000820907487574171*G0_1_0_5_5 - 0.00628507295173979*G0_1_1_0_0 + 0.000906418684196483*G0_1_1_0_1 + 0.000286462508684744*G0_1_1_0_2 - 0.000359147025813689*G0_1_1_0_3 + 0.000906418684196502*G0_1_1_0_4 - 0.00321522099299888*G0_1_1_0_5 + 0.000906418684196483*G0_1_1_1_0 + 0.00346320346320364*G0_1_1_1_1 - 0.00237721126610024*G0_1_1_1_2 - 0.00651595318262005*G0_1_1_1_3 + 0.00141948586393036*G0_1_1_1_4 - 0.000564373897707213*G0_1_1_1_5 + 0.000286462508684743*G0_1_1_2_0 - 0.00237721126610024*G0_1_1_2_1 + 0.0144428411095083*G0_1_1_2_2 + 0.0156656512212073*G0_1_1_2_3 - 0.0006327828550051*G0_1_1_2_4 - 0.000153920153920159*G0_1_1_2_5 - 0.00035914702581369*G0_1_1_3_0 - 0.00651595318262005*G0_1_1_3_1 + 0.0156656512212073*G0_1_1_3_2 + 0.0385826519159865*G0_1_1_3_3 - 0.00212067767623333*G0_1_1_3_4 + 0.00102613435946773*G0_1_1_3_5 + 0.000906418684196501*G0_1_1_4_0 + 0.00141948586393036*G0_1_1_4_1 - 0.0006327828550051*G0_1_1_4_2 - 0.00212067767623333*G0_1_1_4_3 - 0.00889316444872033*G0_1_1_4_4 - 0.0025311314200204*G0_1_1_4_5 - 0.00321522099299888*G0_1_1_5_0 - 0.000564373897707213*G0_1_1_5_1 - 0.000153920153920159*G0_1_1_5_2 + 0.00102613435946773*G0_1_1_5_3 - 0.0025311314200204*G0_1_1_5_4 - 0.00246272246272247*G0_1_1_5_5;
    A[8] = -A[5] - 0.0896584896584928*G0_0_1_0_0 + 0.00628934851157095*G0_0_1_0_1 + 0.00325370103147893*G0_0_1_0_2 + 0.000718294051627433*G0_0_1_0_3 - 0.000188124632569089*G0_0_1_0_4 - 0.0290567046122612*G0_0_1_0_5 + 0.00628934851157095*G0_0_1_1_0 + 0.000949174282507696*G0_0_1_1_1 + 0.000671262893485137*G0_0_1_1_2 - 0.00230880230880238*G0_0_1_1_3 + 0.00427555983111553*G0_0_1_1_4 + 0.00395061728395077*G0_0_1_1_5 + 0.00325370103147893*G0_0_1_2_0 + 0.000671262893485137*G0_0_1_2_1 - 0.0211640211640219*G0_0_1_2_2 + 0.00034204478648924*G0_0_1_2_3 - 0.00855111966223107*G0_0_1_2_4 + 0.000718294051627432*G0_0_1_3_0 - 0.00230880230880238*G0_0_1_3_1 + 0.000342044786489238*G0_0_1_3_2 + 0.0201122334455674*G0_0_1_3_3 - 0.0099877077654859*G0_0_1_3_4 - 0.00153920153920161*G0_0_1_3_5 - 0.000188124632569087*G0_0_1_4_0 + 0.00427555983111553*G0_0_1_4_1 - 0.00855111966223107*G0_0_1_4_2 - 0.0099877077654859*G0_0_1_4_3 - 0.0124504302282084*G0_0_1_4_4 - 0.00865373309817785*G0_0_1_4_5 - 0.0290567046122612*G0_0_1_5_0 + 0.00395061728395077*G0_0_1_5_1 - 0.00153920153920161*G0_0_1_5_3 - 0.00865373309817785*G0_0_1_5_4 - 0.0194965528298869*G0_0_1_5_5 - 0.0896584896584928*G0_1_1_0_0 + 0.00628934851157095*G0_1_1_0_1 + 0.00325370103147893*G0_1_1_0_2 + 0.000718294051627436*G0_1_1_0_3 - 0.000188124632569085*G0_1_1_0_4 - 0.0290567046122612*G0_1_1_0_5 + 0.00628934851157095*G0_1_1_1_0 + 0.000949174282507701*G0_1_1_1_1 + 0.000671262893485141*G0_1_1_1_2 - 0.00230880230880237*G0_1_1_1_3 + 0.00427555983111554*G0_1_1_1_4 + 0.00395061728395078*G0_1_1_1_5 + 0.00325370103147893*G0_1_1_2_0 + 0.000671262893485141*G0_1_1_2_1 - 0.021164021164022*G0_1_1_2_2 + 0.000342044786489221*G0_1_1_2_3 - 0.00855111966223109*G0_1_1_2_4 + 0.000718294051627436*G0_1_1_3_0 - 0.00230880230880237*G0_1_1_3_1 + 0.000342044786489217*G0_1_1_3_2 + 0.0201122334455674*G0_1_1_3_3 - 0.00998770776548593*G0_1_1_3_4 - 0.00153920153920162*G0_1_1_3_5 - 0.000188124632569083*G0_1_1_4_0 + 0.00427555983111554*G0_1_1_4_1 - 0.00855111966223109*G0_1_1_4_2 - 0.00998770776548592*G0_1_1_4_3 - 0.0124504302282085*G0_1_1_4_4 - 0.00865373309817787*G0_1_1_4_5 - 0.0290567046122612*G0_1_1_5_0 + 0.00395061728395078*G0_1_1_5_1 - 0.00153920153920162*G0_1_1_5_3 - 0.00865373309817787*G0_1_1_5_4 - 0.0194965528298869*G0_1_1_5_5;
    A[45] = A[5] - 0.00016247127358238*G0_0_0_0_1 + 0.000350595906151469*G0_0_0_0_2 - 0.000188124632569084*G0_0_0_0_3 - 0.00251402918069595*G0_0_0_0_4 + 0.00251402918069591*G0_0_0_0_5 - 0.00016247127358238*G0_0_0_1_0 + 0.013544973544974*G0_0_0_1_1 + 0.000641333974667328*G0_0_0_1_2 + 0.0184533162310946*G0_0_0_1_3 - 0.000838009726898648*G0_0_0_1_4 - 0.000598578376356168*G0_0_0_1_5 + 0.000350595906151469*G0_0_0_2_0 + 0.000641333974667327*G0_0_0_2_1 - 0.0315536315536326*G0_0_0_2_2 - 0.021206776762333*G0_0_0_2_3 + 0.000273635829191409*G0_0_0_2_4 + 0.0012655657100102*G0_0_0_2_5 - 0.000188124632569084*G0_0_0_3_0 + 0.0184533162310946*G0_0_0_3_1 - 0.021206776762333*G0_0_0_3_2 + 0.0222329111218007*G0_0_0_3_3 + 0.00205226871893546*G0_0_0_3_4 - 0.00215488215488223*G0_0_0_3_5 - 0.00251402918069595*G0_0_0_4_0 - 0.000838009726898648*G0_0_0_4_1 + 0.000273635829191409*G0_0_0_4_2 + 0.00205226871893546*G0_0_0_4_3 + 0.00978248089359237*G0_0_0_4_4 - 0.000855111966223111*G0_0_0_4_5 + 0.00251402918069591*G0_0_0_5_0 - 0.000598578376356168*G0_0_0_5_1 + 0.0012655657100102*G0_0_0_5_2 - 0.00215488215488223*G0_0_0_5_3 - 0.00085511196622311*G0_0_0_5_4 - 0.00807225696114614*G0_0_0_5_5 - 0.00061995617551174*G0_0_1_0_1 + 0.000619956175511743*G0_0_1_0_2 - 0.00412163967719538*G0_0_1_0_4 + 0.00412163967719534*G0_0_1_0_5 - 0.00061995617551174*G0_0_1_1_0 + 0.0109796376463046*G0_0_1_1_1 + 0.0221816044038273*G0_0_1_1_3 - 0.00157340601785052*G0_0_1_1_4 + 0.000619956175511743*G0_0_1_2_0 - 0.0109796376463046*G0_0_1_2_2 - 0.0221816044038273*G0_0_1_2_3 + 0.00157340601785052*G0_0_1_2_5 + 0.0221816044038273*G0_0_1_3_1 - 0.0221816044038273*G0_0_1_3_2 + 0.00314681203570105*G0_0_1_3_4 - 0.00314681203570103*G0_0_1_3_5 - 0.00412163967719539*G0_0_1_4_0 - 0.00157340601785052*G0_0_1_4_1 + 0.00314681203570105*G0_0_1_4_3 + 0.0064304419859978*G0_0_1_4_4 + 0.00412163967719534*G0_0_1_5_0 + 0.00157340601785052*G0_0_1_5_2 - 0.00314681203570103*G0_0_1_5_3 - 0.00643044198599772*G0_0_1_5_5 + 0.000106888995777901*G0_1_0_0_1 - 0.000106888995777875*G0_1_0_0_2 - 0.000906418684196524*G0_1_0_0_4 + 0.00090641868419645*G0_1_0_0_5 + 0.0001068889957779*G0_1_0_1_0 + 0.0341189674523019*G0_1_0_1_1 + 0.0174784885896003*G0_1_0_1_3 - 0.000530169419058327*G0_1_0_1_4 - 0.000803805248249693*G0_1_0_1_5 - 0.000106888995777876*G0_1_0_2_0 - 0.0341189674523021*G0_1_0_2_2 - 0.0174784885896003*G0_1_0_2_3 + 0.000803805248249689*G0_1_0_2_4 + 0.000530169419058322*G0_1_0_2_5 + 0.0174784885896003*G0_1_0_3_1 - 0.0174784885896003*G0_1_0_3_2 + 0.00106033883811665*G0_1_0_3_4 - 0.00106033883811665*G0_1_0_3_5 - 0.000906418684196525*G0_1_0_4_0 - 0.000530169419058327*G0_1_0_4_1 + 0.000803805248249689*G0_1_0_4_2 + 0.00106033883811665*G0_1_0_4_3 + 0.0114242958687407*G0_1_0_4_4 + 0.00090641868419645*G0_1_0_5_0 - 0.000803805248249693*G0_1_0_5_1 + 0.000530169419058322*G0_1_0_5_2 - 0.00106033883811665*G0_1_0_5_3 - 0.0114242958687407*G0_1_0_5_5 - 0.00035059590615146*G0_1_1_0_1 + 0.000162471273582392*G0_1_1_0_2 + 0.000188124632569071*G0_1_1_0_3 - 0.00251402918069596*G0_1_1_0_4 + 0.00251402918069589*G0_1_1_0_5 - 0.00035059590615146*G0_1_1_1_0 + 0.0315536315536325*G0_1_1_1_1 - 0.000641333974667317*G0_1_1_1_2 + 0.021206776762333*G0_1_1_1_3 - 0.0012655657100102*G0_1_1_1_4 - 0.000273635829191375*G0_1_1_1_5 + 0.000162471273582392*G0_1_1_2_0 - 0.000641333974667317*G0_1_1_2_1 - 0.0135449735449741*G0_1_1_2_2 - 0.0184533162310946*G0_1_1_2_3 + 0.000598578376356181*G0_1_1_2_4 + 0.000838009726898642*G0_1_1_2_5 + 0.000188124632569071*G0_1_1_3_0 + 0.021206776762333*G0_1_1_3_1 - 0.0184533162310946*G0_1_1_3_2 - 0.0222329111218008*G0_1_1_3_3 + 0.00215488215488225*G0_1_1_3_4 - 0.00205226871893545*G0_1_1_3_5 - 0.00251402918069596*G0_1_1_4_0 - 0.0012655657100102*G0_1_1_4_1 + 0.000598578376356181*G0_1_1_4_2 + 0.00215488215488225*G0_1_1_4_3 + 0.00807225696114613*G0_1_1_4_4 + 0.000855111966223106*G0_1_1_4_5 + 0.00251402918069589*G0_1_1_5_0 - 0.000273635829191375*G0_1_1_5_1 + 0.000838009726898642*G0_1_1_5_2 - 0.00205226871893545*G0_1_1_5_3 + 0.000855111966223107*G0_1_1_5_4 - 0.00978248089359234*G0_1_1_5_5;
    A[165] = -A[45] - 0.0896584896584931*G0_0_0_0_0 + 0.00325370103147893*G0_0_0_0_1 + 0.00628934851157095*G0_0_0_0_2 + 0.000718294051627419*G0_0_0_0_3 - 0.0290567046122612*G0_0_0_0_4 - 0.000188124632569159*G0_0_0_0_5 + 0.00325370103147893*G0_0_0_1_0 - 0.0211640211640219*G0_0_0_1_1 + 0.000671262893485136*G0_0_0_1_2 + 0.000342044786489238*G0_0_0_1_3 - 0.00855111966223107*G0_0_0_1_5 + 0.00628934851157095*G0_0_0_2_0 + 0.000671262893485136*G0_0_0_2_1 + 0.000949174282507647*G0_0_0_2_2 - 0.00230880230880238*G0_0_0_2_3 + 0.00395061728395077*G0_0_0_2_4 + 0.00427555983111554*G0_0_0_2_5 + 0.00071829405162742*G0_0_0_3_0 + 0.000342044786489238*G0_0_0_3_1 - 0.00230880230880238*G0_0_0_3_2 + 0.0201122334455675*G0_0_0_3_3 - 0.00153920153920158*G0_0_0_3_4 - 0.00998770776548589*G0_0_0_3_5 - 0.0290567046122612*G0_0_0_4_0 + 0.00395061728395077*G0_0_0_4_2 - 0.00153920153920158*G0_0_0_4_3 - 0.0194965528298868*G0_0_0_4_4 - 0.00865373309817786*G0_0_0_4_5 - 0.000188124632569157*G0_0_0_5_0 - 0.00855111966223107*G0_0_0_5_1 + 0.00427555983111554*G0_0_0_5_2 - 0.00998770776548589*G0_0_0_5_3 - 0.00865373309817786*G0_0_0_5_4 - 0.0124504302282085*G0_0_0_5_5 - 0.089658489658493*G0_0_1_0_0 + 0.00325370103147892*G0_0_1_0_1 + 0.00628934851157095*G0_0_1_0_2 + 0.000718294051627416*G0_0_1_0_3 - 0.0290567046122612*G0_0_1_0_4 - 0.000188124632569169*G0_0_1_0_5 + 0.00325370103147892*G0_0_1_1_0 - 0.0211640211640219*G0_0_1_1_1 + 0.000671262893485135*G0_0_1_1_2 + 0.000342044786489236*G0_0_1_1_3 - 0.00855111966223105*G0_0_1_1_5 + 0.00628934851157095*G0_0_1_2_0 + 0.000671262893485134*G0_0_1_2_1 + 0.000949174282507696*G0_0_1_2_2 - 0.00230880230880237*G0_0_1_2_3 + 0.00395061728395077*G0_0_1_2_4 + 0.00427555983111554*G0_0_1_2_5 + 0.000718294051627416*G0_0_1_3_0 + 0.000342044786489238*G0_0_1_3_1 - 0.00230880230880237*G0_0_1_3_2 + 0.0201122334455675*G0_0_1_3_3 - 0.00153920153920158*G0_0_1_3_4 - 0.00998770776548587*G0_0_1_3_5 - 0.0290567046122612*G0_0_1_4_0 + 0.00395061728395077*G0_0_1_4_2 - 0.00153920153920158*G0_0_1_4_3 - 0.0194965528298868*G0_0_1_4_4 - 0.00865373309817786*G0_0_1_4_5 - 0.000188124632569169*G0_0_1_5_0 - 0.00855111966223105*G0_0_1_5_1 + 0.00427555983111554*G0_0_1_5_2 - 0.00998770776548587*G0_0_1_5_3 - 0.00865373309817786*G0_0_1_5_4 - 0.0124504302282084*G0_0_1_5_5;
    A[75] = A[5] - 0.000457484901929361*G0_0_1_0_1 + 0.000269360269360267*G0_0_1_0_2 + 0.000188124632569074*G0_0_1_0_3 - 0.00160761049649944*G0_0_1_0_4 + 0.00160761049649944*G0_0_1_0_5 - 0.000457484901929361*G0_0_1_1_0 - 0.00256533589866935*G0_0_1_1_1 - 0.000641333974667337*G0_0_1_1_2 + 0.00372828817273273*G0_0_1_1_3 - 0.000735396290951873*G0_0_1_1_4 + 0.000530169419058324*G0_0_1_1_5 + 0.000269360269360267*G0_0_1_2_0 - 0.000641333974667337*G0_0_1_2_1 + 0.0205739939073281*G0_0_1_2_2 - 0.000974827641494298*G0_0_1_2_3 - 0.000205226871893502*G0_0_1_2_4 + 0.000307840307840321*G0_0_1_2_5 + 0.000188124632569074*G0_0_1_3_0 + 0.00372828817273273*G0_0_1_3_1 - 0.000974827641494298*G0_0_1_3_2 - 0.0222329111218007*G0_0_1_3_3 + 0.00109454331676559*G0_0_1_3_4 - 0.000991929880818796*G0_0_1_3_5 - 0.00160761049649944*G0_0_1_4_0 - 0.000735396290951873*G0_0_1_4_1 - 0.000205226871893502*G0_0_1_4_2 + 0.00109454331676559*G0_0_1_4_3 - 0.00335203890759456*G0_0_1_4_4 + 0.00085511196622311*G0_0_1_4_5 + 0.00160761049649944*G0_0_1_5_0 + 0.000530169419058325*G0_0_1_5_1 + 0.000307840307840321*G0_0_1_5_2 - 0.000991929880818796*G0_0_1_5_3 + 0.000855111966223109*G0_0_1_5_4 + 0.0016418149751484*G0_0_1_5_5 + 0.000457484901929362*G0_1_0_0_1 - 0.000269360269360267*G0_1_0_0_2 - 0.000188124632569075*G0_1_0_0_3 + 0.00160761049649944*G0_1_0_0_4 - 0.00160761049649944*G0_1_0_0_5 + 0.000457484901929361*G0_1_0_1_0 + 0.00256533589866935*G0_1_0_1_1 + 0.000641333974667338*G0_1_0_1_2 - 0.00372828817273273*G0_1_0_1_3 + 0.000735396290951873*G0_1_0_1_4 - 0.000530169419058325*G0_1_0_1_5 - 0.000269360269360267*G0_1_0_2_0 + 0.000641333974667338*G0_1_0_2_1 - 0.0205739939073281*G0_1_0_2_2 + 0.000974827641494301*G0_1_0_2_3 + 0.000205226871893503*G0_1_0_2_4 - 0.000307840307840321*G0_1_0_2_5 - 0.000188124632569075*G0_1_0_3_0 - 0.00372828817273273*G0_1_0_3_1 + 0.000974827641494301*G0_1_0_3_2 + 0.0222329111218007*G0_1_0_3_3 - 0.00109454331676559*G0_1_0_3_4 + 0.000991929880818796*G0_1_0_3_5 + 0.00160761049649944*G0_1_0_4_0 + 0.000735396290951873*G0_1_0_4_1 + 0.000205226871893502*G0_1_0_4_2 - 0.00109454331676559*G0_1_0_4_3 + 0.00335203890759456*G0_1_0_4_4 - 0.000855111966223109*G0_1_0_4_5 - 0.00160761049649944*G0_1_0_5_0 - 0.000530169419058325*G0_1_0_5_1 - 0.000307840307840321*G0_1_0_5_2 + 0.000991929880818796*G0_1_0_5_3 - 0.000855111966223109*G0_1_0_5_4 - 0.0016418149751484*G0_1_0_5_5;
    A[120] = -A[75] - 0.0896584896584928*G0_1_0_0_0 + 0.00628934851157095*G0_1_0_0_1 + 0.00325370103147893*G0_1_0_0_2 + 0.000718294051627432*G0_1_0_0_3 - 0.000188124632569091*G0_1_0_0_4 - 0.0290567046122612*G0_1_0_0_5 + 0.00628934851157095*G0_1_0_1_0 + 0.000949174282507696*G0_1_0_1_1 + 0.000671262893485138*G0_1_0_1_2 - 0.00230880230880238*G0_1_0_1_3 + 0.00427555983111553*G0_1_0_1_4 + 0.00395061728395077*G0_1_0_1_5 + 0.00325370103147892*G0_1_0_2_0 + 0.000671262893485137*G0_1_0_2_1 - 0.0211640211640219*G0_1_0_2_2 + 0.000342044786489243*G0_1_0_2_3 - 0.00855111966223107*G0_1_0_2_4 + 0.000718294051627432*G0_1_0_3_0 - 0.00230880230880238*G0_1_0_3_1 + 0.000342044786489243*G0_1_0_3_2 + 0.0201122334455674*G0_1_0_3_3 - 0.0099877077654859*G0_1_0_3_4 - 0.00153920153920161*G0_1_0_3_5 - 0.000188124632569087*G0_1_0_4_0 + 0.00427555983111553*G0_1_0_4_1 - 0.00855111966223107*G0_1_0_4_2 - 0.0099877077654859*G0_1_0_4_3 - 0.0124504302282084*G0_1_0_4_4 - 0.00865373309817785*G0_1_0_4_5 - 0.0290567046122612*G0_1_0_5_0 + 0.00395061728395077*G0_1_0_5_1 - 0.00153920153920161*G0_1_0_5_3 - 0.00865373309817785*G0_1_0_5_4 - 0.0194965528298869*G0_1_0_5_5 - 0.0896584896584928*G0_1_1_0_0 + 0.00628934851157095*G0_1_1_0_1 + 0.00325370103147893*G0_1_1_0_2 + 0.000718294051627436*G0_1_1_0_3 - 0.000188124632569086*G0_1_1_0_4 - 0.0290567046122612*G0_1_1_0_5 + 0.00628934851157095*G0_1_1_1_0 + 0.000949174282507699*G0_1_1_1_1 + 0.000671262893485141*G0_1_1_1_2 - 0.00230880230880237*G0_1_1_1_3 + 0.00427555983111554*G0_1_1_1_4 + 0.00395061728395078*G0_1_1_1_5 + 0.00325370103147893*G0_1_1_2_0 + 0.000671262893485141*G0_1_1_2_1 - 0.021164021164022*G0_1_1_2_2 + 0.000342044786489221*G0_1_1_2_3 - 0.00855111966223109*G0_1_1_2_4 + 0.000718294051627436*G0_1_1_3_0 - 0.00230880230880237*G0_1_1_3_1 + 0.000342044786489217*G0_1_1_3_2 + 0.0201122334455674*G0_1_1_3_3 - 0.00998770776548592*G0_1_1_3_4 - 0.00153920153920162*G0_1_1_3_5 - 0.000188124632569083*G0_1_1_4_0 + 0.00427555983111554*G0_1_1_4_1 - 0.00855111966223109*G0_1_1_4_2 - 0.00998770776548592*G0_1_1_4_3 - 0.0124504302282085*G0_1_1_4_4 - 0.00865373309817787*G0_1_1_4_5 - 0.0290567046122612*G0_1_1_5_0 + 0.00395061728395078*G0_1_1_5_1 - 0.00153920153920162*G0_1_1_5_3 - 0.00865373309817787*G0_1_1_5_4 - 0.0194965528298869*G0_1_1_5_5;
    A[24] = -A[20] - 0.0365047298380645*G0_0_0_0_0 + 0.00251830474052705*G0_0_0_0_1 + 0.00606701940035294*G0_0_0_0_2 - 0.000478862701084933*G0_0_0_0_3 - 0.0125359414248307*G0_0_0_0_4 - 0.00788413232857705*G0_0_0_0_5 + 0.00251830474052705*G0_0_0_1_0 - 0.0770883437550131*G0_0_0_1_1 + 0.00482710704932944*G0_0_0_1_2 - 0.0251402918069593*G0_0_0_1_3 + 0.00124846347068574*G0_0_0_1_4 + 0.00051306717973381*G0_0_0_1_5 + 0.00606701940035294*G0_0_0_2_0 + 0.00482710704932943*G0_0_0_2_1 - 0.0375308641975321*G0_0_0_2_2 + 0.00535300090855664*G0_0_0_2_3 - 0.0104836727058953*G0_0_0_2_4 + 0.00270215381326502*G0_0_0_2_5 - 0.000478862701084932*G0_0_0_3_0 - 0.0251402918069593*G0_0_0_3_1 + 0.00535300090855664*G0_0_0_3_2 - 0.00478862701084938*G0_0_0_3_3 - 0.00153920153920159*G0_0_0_3_4 - 0.00444658222436018*G0_0_0_3_5 - 0.0125359414248307*G0_0_0_4_0 + 0.00124846347068574*G0_0_0_4_1 - 0.0104836727058953*G0_0_0_4_2 - 0.00153920153920159*G0_0_0_4_3 - 0.0348201592646048*G0_0_0_4_4 - 0.00790123456790151*G0_0_0_4_5 - 0.00788413232857705*G0_0_0_5_0 + 0.000513067179733808*G0_0_0_5_1 + 0.00270215381326502*G0_0_0_5_2 - 0.00444658222436018*G0_0_0_5_3 - 0.00790123456790151*G0_0_0_5_4 - 0.00273635829191399*G0_0_0_5_5 + 0.00102613435946772*G0_0_1_0_0 - 0.00230880230880243*G0_0_1_0_1 - 0.00318101651434996*G0_0_1_0_3 - 0.00205226871893546*G0_0_1_0_4 - 0.0132371332371337*G0_0_1_0_5 - 0.00230880230880243*G0_0_1_1_0 + 0.00230880230880237*G0_0_1_1_2 - 0.0256533589866931*G0_0_1_1_3 + 0.0256533589866934*G0_0_1_1_5 + 0.00230880230880237*G0_0_1_2_1 - 0.00102613435946776*G0_0_1_2_2 + 0.0132371332371337*G0_0_1_2_3 + 0.00205226871893545*G0_0_1_2_4 + 0.00318101651434996*G0_0_1_2_5 - 0.00318101651434996*G0_0_1_3_0 - 0.0256533589866931*G0_0_1_3_1 + 0.0132371332371337*G0_0_1_3_2 - 0.00205226871893548*G0_0_1_3_3 + 0.0063620330286999*G0_0_1_3_4 - 0.00205226871893546*G0_0_1_4_0 + 0.00205226871893545*G0_0_1_4_2 + 0.0063620330286999*G0_0_1_4_3 - 0.00636203302869993*G0_0_1_4_5 - 0.0132371332371337*G0_0_1_5_0 + 0.0256533589866934*G0_0_1_5_1 + 0.00318101651434996*G0_0_1_5_2 - 0.00636203302869993*G0_0_1_5_4 + 0.00205226871893551*G0_0_1_5_5;
    A[3] = A[45] + 0.00026936026936028*G0_0_1_0_1 - 0.000457484901929352*G0_0_1_0_2 + 0.00018812463256908*G0_0_1_0_3 + 0.00160761049649942*G0_0_1_0_4 - 0.00160761049649945*G0_0_1_0_5 + 0.00026936026936028*G0_0_1_1_0 + 0.020573993907328*G0_0_1_1_1 - 0.000641333974667333*G0_0_1_1_2 - 0.000974827641494308*G0_0_1_1_3 + 0.00030784030784032*G0_0_1_1_4 - 0.000205226871893524*G0_0_1_1_5 - 0.000457484901929352*G0_0_1_2_0 - 0.000641333974667333*G0_0_1_2_1 - 0.00256533589866938*G0_0_1_2_2 + 0.00372828817273272*G0_0_1_2_3 + 0.000530169419058309*G0_0_1_2_4 - 0.000735396290951873*G0_0_1_2_5 + 0.000188124632569079*G0_0_1_3_0 - 0.000974827641494308*G0_0_1_3_1 + 0.00372828817273272*G0_0_1_3_2 - 0.0222329111218008*G0_0_1_3_3 - 0.000991929880818811*G0_0_1_3_4 + 0.00109454331676558*G0_0_1_3_5 + 0.00160761049649942*G0_0_1_4_0 + 0.00030784030784032*G0_0_1_4_1 + 0.000530169419058309*G0_0_1_4_2 - 0.000991929880818811*G0_0_1_4_3 + 0.00164181497514832*G0_0_1_4_4 + 0.000855111966223102*G0_0_1_4_5 - 0.00160761049649945*G0_0_1_5_0 - 0.000205226871893523*G0_0_1_5_1 - 0.000735396290951872*G0_0_1_5_2 + 0.00109454331676558*G0_0_1_5_3 + 0.000855111966223102*G0_0_1_5_4 - 0.0033520389075946*G0_0_1_5_5 - 0.00026936026936028*G0_1_0_0_1 + 0.000457484901929352*G0_1_0_0_2 - 0.00018812463256908*G0_1_0_0_3 - 0.00160761049649942*G0_1_0_0_4 + 0.00160761049649945*G0_1_0_0_5 - 0.00026936026936028*G0_1_0_1_0 - 0.020573993907328*G0_1_0_1_1 + 0.000641333974667333*G0_1_0_1_2 + 0.000974827641494308*G0_1_0_1_3 - 0.00030784030784032*G0_1_0_1_4 + 0.000205226871893524*G0_1_0_1_5 + 0.000457484901929352*G0_1_0_2_0 + 0.000641333974667333*G0_1_0_2_1 + 0.00256533589866938*G0_1_0_2_2 - 0.00372828817273272*G0_1_0_2_3 - 0.00053016941905831*G0_1_0_2_4 + 0.000735396290951872*G0_1_0_2_5 - 0.00018812463256908*G0_1_0_3_0 + 0.000974827641494312*G0_1_0_3_1 - 0.00372828817273272*G0_1_0_3_2 + 0.0222329111218008*G0_1_0_3_3 + 0.000991929880818811*G0_1_0_3_4 - 0.00109454331676558*G0_1_0_3_5 - 0.00160761049649942*G0_1_0_4_0 - 0.00030784030784032*G0_1_0_4_1 - 0.000530169419058309*G0_1_0_4_2 + 0.000991929880818811*G0_1_0_4_3 - 0.00164181497514832*G0_1_0_4_4 - 0.000855111966223101*G0_1_0_4_5 + 0.00160761049649945*G0_1_0_5_0 + 0.000205226871893524*G0_1_0_5_1 + 0.000735396290951872*G0_1_0_5_2 - 0.00109454331676558*G0_1_0_5_3 - 0.000855111966223101*G0_1_0_5_4 + 0.0033520389075946*G0_1_0_5_5;
    A[11] = -A[3] - 0.0896584896584931*G0_0_0_0_0 + 0.00325370103147893*G0_0_0_0_1 + 0.00628934851157095*G0_0_0_0_2 + 0.000718294051627419*G0_0_0_0_3 - 0.0290567046122612*G0_0_0_0_4 - 0.00018812463256916*G0_0_0_0_5 + 0.00325370103147893*G0_0_0_1_0 - 0.0211640211640219*G0_0_0_1_1 + 0.000671262893485136*G0_0_0_1_2 + 0.000342044786489238*G0_0_0_1_3 - 0.00855111966223107*G0_0_0_1_5 + 0.00628934851157095*G0_0_0_2_0 + 0.000671262893485136*G0_0_0_2_1 + 0.000949174282507645*G0_0_0_2_2 - 0.00230880230880238*G0_0_0_2_3 + 0.00395061728395077*G0_0_0_2_4 + 0.00427555983111554*G0_0_0_2_5 + 0.000718294051627419*G0_0_0_3_0 + 0.000342044786489238*G0_0_0_3_1 - 0.00230880230880238*G0_0_0_3_2 + 0.0201122334455675*G0_0_0_3_3 - 0.00153920153920158*G0_0_0_3_4 - 0.00998770776548589*G0_0_0_3_5 - 0.0290567046122612*G0_0_0_4_0 + 0.00395061728395077*G0_0_0_4_2 - 0.00153920153920158*G0_0_0_4_3 - 0.0194965528298868*G0_0_0_4_4 - 0.00865373309817786*G0_0_0_4_5 - 0.00018812463256916*G0_0_0_5_0 - 0.00855111966223107*G0_0_0_5_1 + 0.00427555983111554*G0_0_0_5_2 - 0.00998770776548589*G0_0_0_5_3 - 0.00865373309817786*G0_0_0_5_4 - 0.0124504302282085*G0_0_0_5_5 - 0.089658489658493*G0_1_0_0_0 + 0.00325370103147892*G0_1_0_0_1 + 0.00628934851157095*G0_1_0_0_2 + 0.000718294051627416*G0_1_0_0_3 - 0.0290567046122612*G0_1_0_0_4 - 0.000188124632569169*G0_1_0_0_5 + 0.00325370103147892*G0_1_0_1_0 - 0.0211640211640219*G0_1_0_1_1 + 0.000671262893485134*G0_1_0_1_2 + 0.00034204478648924*G0_1_0_1_3 - 0.00855111966223105*G0_1_0_1_5 + 0.00628934851157095*G0_1_0_2_0 + 0.000671262893485134*G0_1_0_2_1 + 0.000949174282507696*G0_1_0_2_2 - 0.00230880230880238*G0_1_0_2_3 + 0.00395061728395077*G0_1_0_2_4 + 0.00427555983111554*G0_1_0_2_5 + 0.000718294051627416*G0_1_0_3_0 + 0.000342044786489243*G0_1_0_3_1 - 0.00230880230880237*G0_1_0_3_2 + 0.0201122334455675*G0_1_0_3_3 - 0.00153920153920158*G0_1_0_3_4 - 0.00998770776548587*G0_1_0_3_5 - 0.0290567046122612*G0_1_0_4_0 + 0.00395061728395077*G0_1_0_4_2 - 0.00153920153920158*G0_1_0_4_3 - 0.0194965528298868*G0_1_0_4_4 - 0.00865373309817786*G0_1_0_4_5 - 0.000188124632569169*G0_1_0_5_0 - 0.00855111966223105*G0_1_0_5_1 + 0.00427555983111554*G0_1_0_5_2 - 0.00998770776548587*G0_1_0_5_3 - 0.00865373309817786*G0_1_0_5_4 - 0.0124504302282084*G0_1_0_5_5;
    A[128] = -A[125] - 0.00656725990059345*G0_0_1_0_0 - 0.00348885682219028*G0_0_1_0_1 + 0.0164181497514836*G0_0_1_0_3 + 0.0246272246272255*G0_0_1_0_4 + 0.00287317620650964*G0_0_1_0_5 - 0.00348885682219028*G0_0_1_1_0 - 0.00656725990059338*G0_0_1_1_1 + 0.0246272246272255*G0_0_1_1_3 + 0.0164181497514837*G0_0_1_1_4 + 0.00287317620650969*G0_0_1_1_5 + 0.363251563251574*G0_0_1_2_2 - 0.00820907487574193*G0_0_1_2_3 - 0.00820907487574203*G0_0_1_2_4 - 0.00820907487574179*G0_0_1_2_5 + 0.0164181497514836*G0_0_1_3_0 + 0.0246272246272255*G0_0_1_3_1 - 0.00820907487574193*G0_0_1_3_2 - 0.131345198011869*G0_0_1_3_3 - 0.0656725990059346*G0_0_1_3_4 - 0.0164181497514836*G0_0_1_3_5 + 0.0246272246272255*G0_0_1_4_0 + 0.0164181497514837*G0_0_1_4_1 - 0.00820907487574202*G0_0_1_4_2 - 0.0656725990059346*G0_0_1_4_3 - 0.131345198011869*G0_0_1_4_4 - 0.0164181497514836*G0_0_1_4_5 + 0.00287317620650963*G0_0_1_5_0 + 0.00287317620650969*G0_0_1_5_1 - 0.00820907487574179*G0_0_1_5_2 - 0.0164181497514836*G0_0_1_5_3 - 0.0164181497514836*G0_0_1_5_4 - 0.00985088985088991*G0_0_1_5_5 + 0.0948148148148181*G0_1_1_0_0 - 0.00807225696114616*G0_1_1_0_1 - 0.0242851798407362*G0_1_1_0_2 - 0.0187440542996105*G0_1_1_0_3 - 0.0250376783710126*G0_1_1_0_4 + 0.0377617444284125*G0_1_1_0_5 - 0.00807225696114616*G0_1_1_1_0 + 0.0155972422639097*G0_1_1_1_1 - 0.0116295227406342*G0_1_1_1_2 - 0.0105349794238686*G0_1_1_1_3 - 0.0373512906846253*G0_1_1_1_4 - 0.0157340601785051*G0_1_1_1_5 - 0.0242851798407362*G0_1_1_2_0 - 0.0116295227406342*G0_1_1_2_1 + 0.363251563251575*G0_1_1_2_2 + 0.0383090160867951*G0_1_1_2_3 + 0.0848271070493323*G0_1_1_2_4 - 0.0102613435946772*G0_1_1_2_5 - 0.0187440542996105*G0_1_1_3_0 - 0.0105349794238686*G0_1_1_3_1 + 0.0383090160867951*G0_1_1_3_2 + 0.0465180909625368*G0_1_1_3_3 + 0.112190689968472*G0_1_1_3_4 + 0.0580107957885755*G0_1_1_3_5 - 0.0250376783710126*G0_1_1_4_0 - 0.0373512906846253*G0_1_1_4_1 + 0.0848271070493323*G0_1_1_4_2 + 0.112190689968472*G0_1_1_4_3 + 0.40224466891135*G0_1_1_4_4 + 0.0952252685586052*G0_1_1_4_5 + 0.0377617444284125*G0_1_1_5_0 - 0.0157340601785051*G0_1_1_5_1 - 0.0102613435946772*G0_1_1_5_2 + 0.0580107957885755*G0_1_1_5_3 + 0.0952252685586052*G0_1_1_5_4 + 0.24134680134681*G0_1_1_5_5;
    A[176] = A[128] + 0.0742921276254637*G0_0_0_0_0 - 0.0357778846667747*G0_0_0_0_1 + 0.0552060285393636*G0_0_0_0_2 + 0.00930361819250734*G0_0_0_0_3 + 0.0766180321735903*G0_0_0_0_4 - 0.0125872481428041*G0_0_0_0_5 - 0.0357778846667747*G0_0_0_1_0 + 0.524149430816116*G0_0_0_1_1 + 0.02702153813265*G0_0_0_1_2 + 0.188808722142062*G0_0_0_1_3 + 0.0218908663353114*G0_0_0_1_4 + 0.109180695847367*G0_0_0_1_5 + 0.0552060285393636*G0_0_0_2_0 + 0.02702153813265*G0_0_0_2_1 - 0.863184223184251*G0_0_0_2_2 - 0.287591256480155*G0_0_0_2_3 - 0.275551279995734*G0_0_0_2_4 - 0.0465180909625372*G0_0_0_2_5 + 0.00930361819250734*G0_0_0_3_0 + 0.188808722142062*G0_0_0_3_1 - 0.287591256480155*G0_0_0_3_2 - 0.0580107957885757*G0_0_0_3_3 - 0.0623889690556378*G0_0_0_3_4 + 0.0744289455400593*G0_0_0_3_5 + 0.0766180321735903*G0_0_0_4_0 + 0.0218908663353114*G0_0_0_4_1 - 0.275551279995734*G0_0_0_4_2 - 0.0623889690556378*G0_0_0_4_3 - 0.0536326225215133*G0_0_0_4_4 + 0.0492544492544509*G0_0_0_4_5 - 0.0125872481428041*G0_0_0_5_0 + 0.109180695847367*G0_0_0_5_1 - 0.0465180909625372*G0_0_0_5_2 + 0.0744289455400593*G0_0_0_5_3 + 0.0492544492544509*G0_0_0_5_4 + 0.322890278445846*G0_0_0_5_5 - 0.0233274544385664*G0_0_1_0_1 + 0.0233274544385663*G0_0_1_0_2 - 0.00629362407140212*G0_0_1_0_4 + 0.00629362407140198*G0_0_1_0_5 - 0.0233274544385664*G0_0_1_1_0 + 0.614038800705489*G0_0_1_1_1 + 0.19140826251938*G0_0_1_1_3 + 0.00629362407140201*G0_0_1_1_4 + 0.0807225696114619*G0_0_1_1_5 + 0.0233274544385663*G0_0_1_2_0 - 0.614038800705487*G0_0_1_2_2 - 0.19140826251938*G0_0_1_2_3 - 0.080722569611461*G0_0_1_2_4 - 0.0062936240714022*G0_0_1_2_5 + 0.19140826251938*G0_0_1_3_1 - 0.19140826251938*G0_0_1_3_2 - 0.0125872481428041*G0_0_1_3_4 + 0.0125872481428043*G0_0_1_3_5 - 0.00629362407140212*G0_0_1_4_0 + 0.00629362407140201*G0_0_1_4_1 - 0.0807225696114611*G0_0_1_4_2 - 0.0125872481428041*G0_0_1_4_3 + 0.0481599059376855*G0_0_1_4_4 + 0.00629362407140199*G0_0_1_5_0 + 0.0807225696114619*G0_0_1_5_1 - 0.0062936240714022*G0_0_1_5_2 + 0.0125872481428043*G0_0_1_5_3 - 0.0481599059376853*G0_0_1_5_5 - 0.0233274544385664*G0_1_0_0_1 + 0.0233274544385663*G0_1_0_0_2 - 0.00629362407140212*G0_1_0_0_4 + 0.00629362407140198*G0_1_0_0_5 - 0.0233274544385664*G0_1_0_1_0 + 0.614038800705489*G0_1_0_1_1 + 0.19140826251938*G0_1_0_1_3 + 0.00629362407140201*G0_1_0_1_4 + 0.0807225696114619*G0_1_0_1_5 + 0.0233274544385663*G0_1_0_2_0 - 0.614038800705487*G0_1_0_2_2 - 0.19140826251938*G0_1_0_2_3 - 0.080722569611461*G0_1_0_2_4 - 0.0062936240714022*G0_1_0_2_5 + 0.19140826251938*G0_1_0_3_1 - 0.19140826251938*G0_1_0_3_2 - 0.0125872481428041*G0_1_0_3_4 + 0.0125872481428043*G0_1_0_3_5 - 0.00629362407140212*G0_1_0_4_0 + 0.00629362407140201*G0_1_0_4_1 - 0.0807225696114611*G0_1_0_4_2 - 0.0125872481428041*G0_1_0_4_3 + 0.0481599059376855*G0_1_0_4_4 + 0.00629362407140199*G0_1_0_5_0 + 0.0807225696114619*G0_1_0_5_1 - 0.0062936240714022*G0_1_0_5_2 + 0.0125872481428043*G0_1_0_5_3 - 0.0481599059376853*G0_1_0_5_5 - 0.0742921276254636*G0_1_1_0_0 - 0.0552060285393638*G0_1_1_0_1 + 0.0357778846667747*G0_1_1_0_2 - 0.00930361819250741*G0_1_1_0_3 + 0.0125872481428042*G0_1_1_0_4 - 0.0766180321735905*G0_1_1_0_5 - 0.0552060285393638*G0_1_1_1_0 + 0.863184223184254*G0_1_1_1_1 - 0.0270215381326503*G0_1_1_1_2 + 0.287591256480155*G0_1_1_1_3 + 0.0465180909625369*G0_1_1_1_4 + 0.275551279995735*G0_1_1_1_5 + 0.0357778846667747*G0_1_1_2_0 - 0.0270215381326503*G0_1_1_2_1 - 0.524149430816114*G0_1_1_2_2 - 0.188808722142062*G0_1_1_2_3 - 0.109180695847366*G0_1_1_2_4 - 0.0218908663353117*G0_1_1_2_5 - 0.00930361819250742*G0_1_1_3_0 + 0.287591256480155*G0_1_1_3_1 - 0.188808722142062*G0_1_1_3_2 + 0.0580107957885755*G0_1_1_3_3 - 0.0744289455400592*G0_1_1_3_4 + 0.0623889690556381*G0_1_1_3_5 + 0.0125872481428042*G0_1_1_4_0 + 0.0465180909625369*G0_1_1_4_1 - 0.109180695847366*G0_1_1_4_2 - 0.0744289455400592*G0_1_1_4_3 - 0.322890278445846*G0_1_1_4_4 - 0.049254449254451*G0_1_1_4_5 - 0.0766180321735905*G0_1_1_5_0 + 0.275551279995735*G0_1_1_5_1 - 0.0218908663353117*G0_1_1_5_2 + 0.0623889690556381*G0_1_1_5_3 - 0.049254449254451*G0_1_1_5_4 + 0.0536326225215137*G0_1_1_5_5;
    A[56] = -A[176] + 0.0948148148148183*G0_0_0_0_0 - 0.0242851798407362*G0_0_0_0_1 - 0.00807225696114613*G0_0_0_0_2 - 0.0187440542996105*G0_0_0_0_3 + 0.0377617444284124*G0_0_0_0_4 - 0.0250376783710125*G0_0_0_0_5 - 0.0242851798407362*G0_0_0_1_0 + 0.363251563251577*G0_0_0_1_1 - 0.0116295227406343*G0_0_0_1_2 + 0.0383090160867953*G0_0_0_1_3 - 0.0102613435946773*G0_0_0_1_4 + 0.0848271070493326*G0_0_0_1_5 - 0.00807225696114613*G0_0_0_2_0 - 0.0116295227406343*G0_0_0_2_1 + 0.0155972422639094*G0_0_0_2_2 - 0.0105349794238686*G0_0_0_2_3 - 0.0157340601785051*G0_0_0_2_4 - 0.0373512906846253*G0_0_0_2_5 - 0.0187440542996105*G0_0_0_3_0 + 0.0383090160867953*G0_0_0_3_1 - 0.0105349794238687*G0_0_0_3_2 + 0.046518090962537*G0_0_0_3_3 + 0.0580107957885755*G0_0_0_3_4 + 0.112190689968472*G0_0_0_3_5 + 0.0377617444284124*G0_0_0_4_0 - 0.0102613435946773*G0_0_0_4_1 - 0.0157340601785051*G0_0_0_4_2 + 0.0580107957885755*G0_0_0_4_3 + 0.241346801346809*G0_0_0_4_4 + 0.0952252685586051*G0_0_0_4_5 - 0.0250376783710125*G0_0_0_5_0 + 0.0848271070493326*G0_0_0_5_1 - 0.0373512906846253*G0_0_0_5_2 + 0.112190689968472*G0_0_0_5_3 + 0.0952252685586051*G0_0_0_5_4 + 0.40224466891135*G0_0_0_5_5 - 0.00656725990059353*G0_0_1_0_0 - 0.00348885682219026*G0_0_1_0_2 + 0.0164181497514836*G0_0_1_0_3 + 0.0028731762065096*G0_0_1_0_4 + 0.0246272246272254*G0_0_1_0_5 + 0.363251563251577*G0_0_1_1_1 - 0.00820907487574174*G0_0_1_1_3 - 0.00820907487574184*G0_0_1_1_4 - 0.00820907487574124*G0_0_1_1_5 - 0.00348885682219026*G0_0_1_2_0 - 0.00656725990059344*G0_0_1_2_2 + 0.0246272246272255*G0_0_1_2_3 + 0.00287317620650966*G0_0_1_2_4 + 0.0164181497514836*G0_0_1_2_5 + 0.0164181497514836*G0_0_1_3_0 - 0.00820907487574174*G0_0_1_3_1 + 0.0246272246272255*G0_0_1_3_2 - 0.131345198011869*G0_0_1_3_3 - 0.0164181497514837*G0_0_1_3_4 - 0.0656725990059345*G0_0_1_3_5 + 0.0028731762065096*G0_0_1_4_0 - 0.00820907487574184*G0_0_1_4_1 + 0.00287317620650966*G0_0_1_4_2 - 0.0164181497514837*G0_0_1_4_3 - 0.00985088985089013*G0_0_1_4_4 - 0.0164181497514837*G0_0_1_4_5 + 0.0246272246272254*G0_0_1_5_0 - 0.00820907487574124*G0_0_1_5_1 + 0.0164181497514836*G0_0_1_5_2 - 0.0656725990059345*G0_0_1_5_3 - 0.0164181497514837*G0_0_1_5_4 - 0.131345198011869*G0_0_1_5_5;
    A[168] = A[56] + 0.00656725990059347*G0_0_1_0_0 + 0.00348885682219026*G0_0_1_0_2 - 0.0164181497514836*G0_0_1_0_3 - 0.0028731762065096*G0_0_1_0_4 - 0.0246272246272253*G0_0_1_0_5 - 0.363251563251577*G0_0_1_1_1 + 0.00820907487574174*G0_0_1_1_3 + 0.00820907487574184*G0_0_1_1_4 + 0.00820907487574121*G0_0_1_1_5 + 0.00348885682219026*G0_0_1_2_0 + 0.00656725990059344*G0_0_1_2_2 - 0.0246272246272255*G0_0_1_2_3 - 0.00287317620650966*G0_0_1_2_4 - 0.0164181497514836*G0_0_1_2_5 - 0.0164181497514836*G0_0_1_3_0 + 0.00820907487574174*G0_0_1_3_1 - 0.0246272246272255*G0_0_1_3_2 + 0.131345198011869*G0_0_1_3_3 + 0.0164181497514837*G0_0_1_3_4 + 0.0656725990059345*G0_0_1_3_5 - 0.0028731762065096*G0_0_1_4_0 + 0.00820907487574184*G0_0_1_4_1 - 0.00287317620650966*G0_0_1_4_2 + 0.0164181497514837*G0_0_1_4_3 + 0.00985088985089018*G0_0_1_4_4 + 0.0164181497514836*G0_0_1_4_5 - 0.0246272246272253*G0_0_1_5_0 + 0.0082090748757412*G0_0_1_5_1 - 0.0164181497514836*G0_0_1_5_2 + 0.0656725990059345*G0_0_1_5_3 + 0.0164181497514836*G0_0_1_5_4 + 0.131345198011869*G0_0_1_5_5 - 0.00656725990059347*G0_1_0_0_0 - 0.00348885682219026*G0_1_0_0_2 + 0.0164181497514836*G0_1_0_0_3 + 0.0028731762065096*G0_1_0_0_4 + 0.0246272246272253*G0_1_0_0_5 + 0.363251563251577*G0_1_0_1_1 - 0.00820907487574171*G0_1_0_1_3 - 0.00820907487574184*G0_1_0_1_4 - 0.00820907487574121*G0_1_0_1_5 - 0.00348885682219026*G0_1_0_2_0 - 0.00656725990059344*G0_1_0_2_2 + 0.0246272246272255*G0_1_0_2_3 + 0.00287317620650966*G0_1_0_2_4 + 0.0164181497514836*G0_1_0_2_5 + 0.0164181497514836*G0_1_0_3_0 - 0.00820907487574177*G0_1_0_3_1 + 0.0246272246272255*G0_1_0_3_2 - 0.131345198011869*G0_1_0_3_3 - 0.0164181497514837*G0_1_0_3_4 - 0.0656725990059345*G0_1_0_3_5 + 0.0028731762065096*G0_1_0_4_0 - 0.00820907487574184*G0_1_0_4_1 + 0.00287317620650966*G0_1_0_4_2 - 0.0164181497514837*G0_1_0_4_3 - 0.00985088985089018*G0_1_0_4_4 - 0.0164181497514836*G0_1_0_4_5 + 0.0246272246272253*G0_1_0_5_0 - 0.00820907487574121*G0_1_0_5_1 + 0.0164181497514836*G0_1_0_5_2 - 0.0656725990059345*G0_1_0_5_3 - 0.0164181497514836*G0_1_0_5_4 - 0.131345198011869*G0_1_0_5_5;
    A[48] = -A[56] + 0.0221645021645029*G0_0_0_0_0 - 0.0116295227406342*G0_0_0_0_1 - 0.00458340013895583*G0_0_0_0_2 - 0.0537694404361088*G0_0_0_0_3 - 0.0186072363850147*G0_0_0_0_4 - 0.035162204051094*G0_0_0_0_5 - 0.0116295227406342*G0_0_0_1_0 - 0.0242851798407363*G0_0_0_1_2 + 0.0930361819250743*G0_0_0_1_3 - 0.00205226871893543*G0_0_0_1_4 + 0.046518090962537*G0_0_0_1_5 - 0.00458340013895583*G0_0_0_2_0 - 0.0242851798407363*G0_0_0_2_1 + 0.101382074715411*G0_0_0_2_2 - 0.0496649029982382*G0_0_0_2_3 + 0.0348885682219027*G0_0_0_2_4 - 0.0351622040510941*G0_0_0_2_5 - 0.0537694404361088*G0_0_0_3_0 + 0.0930361819250743*G0_0_0_3_1 - 0.0496649029982382*G0_0_0_3_2 + 0.53358986692322*G0_0_0_3_3 + 0.111643418310089*G0_0_0_3_4 + 0.177863288974406*G0_0_0_3_5 - 0.0186072363850147*G0_0_0_4_0 - 0.00205226871893543*G0_0_0_4_1 + 0.0348885682219027*G0_0_0_4_2 + 0.111643418310089*G0_0_0_4_3 + 0.251197691197699*G0_0_0_4_4 + 0.0744289455400592*G0_0_0_4_5 - 0.0351622040510941*G0_0_0_5_0 + 0.046518090962537*G0_0_0_5_1 - 0.0351622040510941*G0_0_0_5_2 + 0.177863288974406*G0_0_0_5_3 + 0.0744289455400592*G0_0_0_5_4 + 0.177863288974406*G0_0_0_5_5 + 0.00656725990059347*G0_1_0_0_0 + 0.00348885682219026*G0_1_0_0_2 - 0.0164181497514836*G0_1_0_0_3 - 0.0028731762065096*G0_1_0_0_4 - 0.0246272246272253*G0_1_0_0_5 - 0.363251563251577*G0_1_0_1_1 + 0.00820907487574171*G0_1_0_1_3 + 0.00820907487574184*G0_1_0_1_4 + 0.0082090748757412*G0_1_0_1_5 + 0.00348885682219026*G0_1_0_2_0 + 0.00656725990059339*G0_1_0_2_2 - 0.0246272246272255*G0_1_0_2_3 - 0.00287317620650966*G0_1_0_2_4 - 0.0164181497514836*G0_1_0_2_5 - 0.0164181497514836*G0_1_0_3_0 + 0.00820907487574174*G0_1_0_3_1 - 0.0246272246272255*G0_1_0_3_2 + 0.131345198011869*G0_1_0_3_3 + 0.0164181497514837*G0_1_0_3_4 + 0.0656725990059345*G0_1_0_3_5 - 0.0028731762065096*G0_1_0_4_0 + 0.00820907487574184*G0_1_0_4_1 - 0.00287317620650966*G0_1_0_4_2 + 0.0164181497514837*G0_1_0_4_3 + 0.00985088985089024*G0_1_0_4_4 + 0.0164181497514836*G0_1_0_4_5 - 0.0246272246272253*G0_1_0_5_0 + 0.0082090748757412*G0_1_0_5_1 - 0.0164181497514836*G0_1_0_5_2 + 0.0656725990059345*G0_1_0_5_3 + 0.0164181497514836*G0_1_0_5_4 + 0.131345198011869*G0_1_0_5_5;
    A[63] = -A[71] - 0.00502805836139182*G0_0_0_0_0 - 0.0014365881032548*G0_0_0_0_1 + 0.0199583132916472*G0_0_0_0_2 + 0.0126214526214531*G0_0_0_0_3 + 0.0348885682219026*G0_0_0_0_4 + 0.0163155363155368*G0_0_0_0_5 - 0.0014365881032548*G0_0_0_1_0 + 0.00820907487574159*G0_0_0_1_1 + 0.0126727593394264*G0_0_0_1_2 + 0.0287317620650963*G0_0_0_1_3 + 0.0156998556998562*G0_0_0_1_4 - 0.0102613435946772*G0_0_0_1_5 + 0.0199583132916472*G0_0_0_2_0 + 0.0126727593394264*G0_0_0_2_1 - 0.182036235369575*G0_0_0_2_2 - 0.066801346801349*G0_0_0_2_3 - 0.0990219656886356*G0_0_0_2_4 + 0.000307840307840296*G0_0_0_2_5 + 0.0126214526214531*G0_0_0_3_0 + 0.0287317620650963*G0_0_0_3_1 - 0.066801346801349*G0_0_0_3_2 + 0.062799422799425*G0_0_0_3_3 - 0.0566426166426185*G0_0_0_3_4 - 0.0258585858585868*G0_0_0_3_5 + 0.0348885682219026*G0_0_0_4_0 + 0.0156998556998562*G0_0_0_4_1 - 0.0990219656886356*G0_0_0_4_2 - 0.0566426166426185*G0_0_0_4_3 - 0.237652717652725*G0_0_0_4_4 - 0.0320153920153931*G0_0_0_4_5 + 0.0163155363155368*G0_0_0_5_0 - 0.0102613435946772*G0_0_0_5_1 + 0.000307840307840296*G0_0_0_5_2 - 0.0258585858585868*G0_0_0_5_3 - 0.0320153920153931*G0_0_0_5_4 - 0.0726503126503149*G0_0_0_5_5 + 0.00287317620650968*G0_1_0_0_0 - 0.00923520923520961*G0_1_0_0_1 + 0.00733686067019424*G0_1_0_0_2 - 0.0416610549943897*G0_1_0_0_3 - 0.00790123456790152*G0_1_0_0_4 + 0.0006156806156806*G0_1_0_0_5 - 0.00923520923520961*G0_1_0_1_0 + 0.27859547859549*G0_1_0_1_1 - 0.0215488215488224*G0_1_0_1_2 + 0.116979316979321*G0_1_0_1_3 + 0.00615680615680635*G0_1_0_1_4 + 0.0184704184704196*G0_1_0_1_5 + 0.00733686067019425*G0_1_0_2_0 - 0.0215488215488224*G0_1_0_2_1 + 0.00410453743787103*G0_1_0_2_2 - 0.0724450857784217*G0_1_0_2_3 - 0.0152894019560691*G0_1_0_2_4 - 0.0178547378547385*G0_1_0_2_5 - 0.0416610549943897*G0_1_0_3_0 + 0.116979316979321*G0_1_0_3_1 - 0.0724450857784217*G0_1_0_3_2 + 0.574635241301929*G0_1_0_3_3 + 0.0710084976751668*G0_1_0_3_4 + 0.119031585698257*G0_1_0_3_5 - 0.00790123456790152*G0_1_0_4_0 + 0.00615680615680635*G0_1_0_4_1 - 0.0152894019560691*G0_1_0_4_2 + 0.0710084976751668*G0_1_0_4_3 + 0.00164181497514809*G0_1_0_4_4 + 0.0233958633958642*G0_1_0_4_5 + 0.000615680615680602*G0_1_0_5_0 + 0.0184704184704196*G0_1_0_5_1 - 0.0178547378547385*G0_1_0_5_2 + 0.119031585698257*G0_1_0_5_3 + 0.0233958633958642*G0_1_0_5_4 - 0.0985088985089018*G0_1_0_5_5;
    A[140] = -A[143] + 0.114106140772811*G0_0_1_0_0 - 0.00280476724921179*G0_0_1_0_1 - 0.00177863288974406*G0_0_1_0_2 - 0.000547271658382844*G0_0_1_0_3 - 0.00574635241301928*G0_0_1_0_4 - 0.0061568061568064*G0_0_1_0_5 - 0.00280476724921179*G0_0_1_1_0 - 0.0143658810325483*G0_0_1_1_1 - 0.00068408957297849*G0_0_1_1_2 + 0.00766180321735906*G0_0_1_1_3 - 0.00738816738816764*G0_0_1_1_4 + 0.0198385976163761*G0_0_1_1_5 - 0.00177863288974406*G0_0_1_2_0 - 0.000684089572978491*G0_0_1_2_1 - 0.00547271658382792*G0_0_1_2_3 + 0.00547271658382787*G0_0_1_2_4 + 0.00246272246272254*G0_0_1_2_5 - 0.000547271658382844*G0_0_1_3_0 + 0.00766180321735906*G0_0_1_3_1 - 0.00547271658382792*G0_0_1_3_2 - 0.0317417561862014*G0_0_1_3_3 + 0.0158708780931009*G0_0_1_3_4 - 0.00383090160867943*G0_0_1_3_5 - 0.00574635241301928*G0_0_1_4_0 - 0.00738816738816764*G0_0_1_4_1 + 0.00547271658382787*G0_0_1_4_2 + 0.0158708780931009*G0_0_1_4_3 + 0.00985088985089021*G0_0_1_4_5 - 0.0061568061568064*G0_0_1_5_0 + 0.0198385976163761*G0_0_1_5_1 + 0.00246272246272254*G0_0_1_5_2 - 0.00383090160867943*G0_0_1_5_3 + 0.00985088985089021*G0_0_1_5_4 - 0.121494308160979*G0_0_1_5_5 - 0.0788071188071216*G0_1_1_0_0 + 0.0132029287584848*G0_1_1_0_1 - 0.00109454331676556*G0_1_1_0_2 + 0.00123136123136125*G0_1_1_0_3 + 0.000684089572978478*G0_1_1_0_4 - 0.0864689220244808*G0_1_1_0_5 + 0.0132029287584848*G0_1_1_1_0 - 0.0201122334455676*G0_1_1_1_1 + 0.0119031585698257*G0_1_1_1_3 - 0.0091668002779117*G0_1_1_1_4 + 0.035709475709477*G0_1_1_1_5 - 0.00109454331676556*G0_1_1_2_0 + 0.00410453743787078*G0_1_1_2_2 - 0.0109454331676559*G0_1_1_2_3 - 0.00547271658382789*G0_1_1_2_4 + 0.00205226871893546*G0_1_1_2_5 + 0.00123136123136125*G0_1_1_3_0 + 0.0119031585698257*G0_1_1_3_1 - 0.0109454331676559*G0_1_1_3_2 - 0.0476126342793026*G0_1_1_3_3 + 0.0158708780931009*G0_1_1_3_4 - 0.00656725990059339*G0_1_1_3_5 + 0.000684089572978478*G0_1_1_4_0 - 0.0091668002779117*G0_1_1_4_1 - 0.00547271658382789*G0_1_1_4_2 + 0.0158708780931009*G0_1_1_4_3 + 0.0651253273475518*G0_1_1_4_4 + 0.0142290631179525*G0_1_1_4_5 - 0.0864689220244808*G0_1_1_5_0 + 0.035709475709477*G0_1_1_5_1 + 0.00205226871893545*G0_1_1_5_2 - 0.00656725990059339*G0_1_1_5_3 + 0.0142290631179525*G0_1_1_5_4 - 0.211794131794139*G0_1_1_5_5;
    A[51] = A[140] - 0.0213435946769287*G0_0_0_0_0 + 0.000342044786489238*G0_0_0_0_1 + 0.00396771952327521*G0_0_0_0_2 + 0.00287317620650966*G0_0_0_0_3 - 0.0240799529688426*G0_0_0_0_4 - 0.00013681791459571*G0_0_0_0_5 + 0.000342044786489238*G0_0_0_1_0 - 0.00902998236331611*G0_0_0_1_1 + 0.000957725402169911*G0_0_0_1_2 - 0.0246272246272256*G0_0_0_1_3 + 0.00259954037731823*G0_0_0_1_4 - 0.0041045374378709*G0_0_0_1_5 + 0.00396771952327521*G0_0_0_2_0 + 0.000957725402169911*G0_0_0_2_1 - 0.0229854096520771*G0_0_0_2_2 + 0.0236694992250556*G0_0_0_2_3 + 0.01080861525306*G0_0_0_2_4 - 0.00287317620650964*G0_0_0_2_5 + 0.00287317620650966*G0_0_0_3_0 - 0.0246272246272256*G0_0_0_3_1 + 0.0236694992250556*G0_0_0_3_2 - 0.0541798941798965*G0_0_0_3_3 - 0.0109454331676558*G0_0_0_3_4 - 0.0240799529688426*G0_0_0_4_0 + 0.00259954037731823*G0_0_0_4_1 + 0.01080861525306*G0_0_0_4_2 - 0.0109454331676558*G0_0_0_4_3 - 0.0782598471487383*G0_0_0_4_4 + 0.000547271658382821*G0_0_0_4_5 - 0.000136817914595709*G0_0_0_5_0 - 0.0041045374378709*G0_0_0_5_1 - 0.00287317620650964*G0_0_0_5_2 + 0.000547271658382822*G0_0_0_5_4 + 0.0246272246272254*G0_0_0_5_5 - 0.000752498530276349*G0_0_1_0_1 + 0.000752498530276338*G0_0_1_0_2 - 0.00793543904655037*G0_0_1_0_4 + 0.00793543904655049*G0_0_1_0_5 - 0.000752498530276349*G0_0_1_1_0 + 0.013134519801187*G0_0_1_1_1 - 0.0277740366629265*G0_0_1_1_3 + 0.00547271658382788*G0_0_1_1_4 - 0.010398161509273*G0_0_1_1_5 + 0.000752498530276338*G0_0_1_2_0 - 0.0131345198011869*G0_0_1_2_2 + 0.0277740366629265*G0_0_1_2_3 + 0.0103981615092729*G0_0_1_2_4 - 0.00547271658382789*G0_0_1_2_5 - 0.0277740366629265*G0_0_1_3_1 + 0.0277740366629265*G0_0_1_3_2 - 0.0109454331676558*G0_0_1_3_4 + 0.0109454331676557*G0_0_1_3_5 - 0.00793543904655037*G0_0_1_4_0 + 0.00547271658382787*G0_0_1_4_1 + 0.0103981615092729*G0_0_1_4_2 - 0.0109454331676558*G0_0_1_4_3 - 0.0601998824221065*G0_0_1_4_4 + 0.0079354390465505*G0_0_1_5_0 - 0.010398161509273*G0_0_1_5_1 - 0.00547271658382789*G0_0_1_5_2 + 0.0109454331676557*G0_0_1_5_3 + 0.0601998824221066*G0_0_1_5_5 + 0.000136817914595684*G0_1_0_0_1 - 0.000136817914595672*G0_1_0_0_2 - 0.00314681203570108*G0_1_0_0_4 + 0.00314681203570094*G0_1_0_0_5 + 0.000136817914595684*G0_1_0_1_0 - 0.0114927048260385*G0_1_0_1_1 - 0.0165549676660795*G0_1_0_1_3 + 0.000273635829191399*G0_1_0_1_4 - 0.00396771952327507*G0_1_0_1_5 - 0.000136817914595672*G0_1_0_2_0 + 0.0114927048260385*G0_1_0_2_2 + 0.0165549676660794*G0_1_0_2_3 + 0.00396771952327517*G0_1_0_2_4 - 0.000273635829191385*G0_1_0_2_5 - 0.0165549676660795*G0_1_0_3_1 + 0.0165549676660794*G0_1_0_3_2 - 0.00054727165838278*G0_1_0_3_4 + 0.00054727165838279*G0_1_0_3_5 - 0.00314681203570108*G0_1_0_4_0 + 0.000273635829191398*G0_1_0_4_1 + 0.00396771952327517*G0_1_0_4_2 - 0.00054727165838278*G0_1_0_4_3 - 0.0186072363850149*G0_1_0_4_4 + 0.00314681203570094*G0_1_0_5_0 - 0.00396771952327508*G0_1_0_5_1 - 0.000273635829191385*G0_1_0_5_2 + 0.000547271658382789*G0_1_0_5_3 + 0.0186072363850148*G0_1_0_5_5 + 0.0213435946769289*G0_1_1_0_0 - 0.00396771952327524*G0_1_1_0_1 - 0.000342044786489248*G0_1_1_0_2 - 0.00287317620650963*G0_1_1_0_3 + 0.000136817914595719*G0_1_1_0_4 + 0.0240799529688427*G0_1_1_0_5 - 0.00396771952327524*G0_1_1_1_0 + 0.0229854096520774*G0_1_1_1_1 - 0.000957725402169912*G0_1_1_1_2 - 0.0236694992250556*G0_1_1_1_3 + 0.00287317620650963*G0_1_1_1_4 - 0.01080861525306*G0_1_1_1_5 - 0.000342044786489248*G0_1_1_2_0 - 0.000957725402169911*G0_1_1_2_1 + 0.00902998236331613*G0_1_1_2_2 + 0.0246272246272256*G0_1_1_2_3 + 0.00410453743787091*G0_1_1_2_4 - 0.00259954037731825*G0_1_1_2_5 - 0.00287317620650963*G0_1_1_3_0 - 0.0236694992250556*G0_1_1_3_1 + 0.0246272246272256*G0_1_1_3_2 + 0.0541798941798964*G0_1_1_3_3 + 0.0109454331676558*G0_1_1_3_5 + 0.00013681791459572*G0_1_1_4_0 + 0.00287317620650963*G0_1_1_4_1 + 0.00410453743787091*G0_1_1_4_2 - 0.0246272246272254*G0_1_1_4_4 - 0.000547271658382764*G0_1_1_4_5 + 0.0240799529688427*G0_1_1_5_0 - 0.01080861525306*G0_1_1_5_1 - 0.00259954037731824*G0_1_1_5_2 + 0.0109454331676558*G0_1_1_5_3 - 0.000547271658382764*G0_1_1_5_4 + 0.0782598471487388*G0_1_1_5_5;
    A[77] = -A[122] - 0.0189065255731929*G0_1_1_0_0 + 0.00441665330554236*G0_1_1_0_1 + 0.00528031639142766*G0_1_1_0_2 + 0.0041045374378709*G0_1_1_0_3 - 0.0016247127358239*G0_1_1_0_4 - 0.00596868152423731*G0_1_1_0_5 + 0.00441665330554236*G0_1_1_1_0 - 0.0189065255731931*G0_1_1_1_1 + 0.00528031639142766*G0_1_1_1_2 - 0.00162471273582395*G0_1_1_1_3 + 0.0041045374378709*G0_1_1_1_4 - 0.00596868152423738*G0_1_1_1_5 + 0.00528031639142766*G0_1_1_2_0 + 0.00528031639142766*G0_1_1_2_1 - 0.188680455347128*G0_1_1_2_2 - 0.0153920153920159*G0_1_1_2_3 - 0.0153920153920159*G0_1_1_2_4 + 0.00572925017369478*G0_1_1_2_5 + 0.0041045374378709*G0_1_1_3_0 - 0.00162471273582394*G0_1_1_3_1 - 0.0153920153920159*G0_1_1_3_2 - 0.0328362995029672*G0_1_1_3_3 - 0.0164181497514836*G0_1_1_3_4 - 0.0196675752231314*G0_1_1_3_5 - 0.0016247127358239*G0_1_1_4_0 + 0.0041045374378709*G0_1_1_4_1 - 0.0153920153920159*G0_1_1_4_2 - 0.0164181497514836*G0_1_1_4_3 - 0.0328362995029673*G0_1_1_4_4 - 0.0196675752231314*G0_1_1_4_5 - 0.00596868152423731*G0_1_1_5_0 - 0.00596868152423738*G0_1_1_5_1 + 0.00572925017369478*G0_1_1_5_2 - 0.0196675752231314*G0_1_1_5_3 - 0.0196675752231314*G0_1_1_5_4 - 0.0870846026401613*G0_1_1_5_5;
    A[171] = -A[51] - 0.0788071188071214*G0_0_0_0_0 - 0.00109454331676558*G0_0_0_0_1 + 0.0132029287584847*G0_0_0_0_2 + 0.0012313612313613*G0_0_0_0_3 - 0.0864689220244804*G0_0_0_0_4 + 0.00068408957297845*G0_0_0_0_5 - 0.00109454331676558*G0_0_0_1_0 + 0.00410453743787085*G0_0_0_1_1 - 0.0109454331676559*G0_0_0_1_3 + 0.00205226871893543*G0_0_0_1_4 - 0.00547271658382785*G0_0_0_1_5 + 0.0132029287584847*G0_0_0_2_0 - 0.0201122334455672*G0_0_0_2_2 + 0.0119031585698257*G0_0_0_2_3 + 0.0357094757094769*G0_0_0_2_4 - 0.00916680027791172*G0_0_0_2_5 + 0.0012313612313613*G0_0_0_3_0 - 0.0109454331676559*G0_0_0_3_1 + 0.0119031585698257*G0_0_0_3_2 - 0.0476126342793031*G0_0_0_3_3 - 0.00656725990059342*G0_0_0_3_4 + 0.0158708780931008*G0_0_0_3_5 - 0.0864689220244804*G0_0_0_4_0 + 0.00205226871893542*G0_0_0_4_1 + 0.0357094757094769*G0_0_0_4_2 - 0.00656725990059341*G0_0_0_4_3 - 0.211794131794138*G0_0_0_4_4 + 0.0142290631179526*G0_0_0_4_5 + 0.000684089572978448*G0_0_0_5_0 - 0.00547271658382785*G0_0_0_5_1 - 0.00916680027791172*G0_0_0_5_2 + 0.0158708780931008*G0_0_0_5_3 + 0.0142290631179526*G0_0_0_5_4 + 0.065125327347552*G0_0_0_5_5 + 0.114106140772812*G0_0_1_0_0 - 0.00177863288974408*G0_0_1_0_1 - 0.00280476724921181*G0_0_1_0_2 - 0.0005472716583828*G0_0_1_0_3 - 0.00615680615680623*G0_0_1_0_4 - 0.00574635241301915*G0_0_1_0_5 - 0.00177863288974408*G0_0_1_1_0 - 0.000684089572978478*G0_0_1_1_2 - 0.00547271658382791*G0_0_1_1_3 + 0.00246272246272252*G0_0_1_1_4 + 0.00547271658382786*G0_0_1_1_5 - 0.00280476724921181*G0_0_1_2_0 - 0.000684089572978478*G0_0_1_2_1 - 0.0143658810325481*G0_0_1_2_2 + 0.00766180321735903*G0_0_1_2_3 + 0.019838597616376*G0_0_1_2_4 - 0.00738816738816768*G0_0_1_2_5 - 0.0005472716583828*G0_0_1_3_0 - 0.00547271658382791*G0_0_1_3_1 + 0.00766180321735903*G0_0_1_3_2 - 0.0317417561862018*G0_0_1_3_3 - 0.00383090160867947*G0_0_1_3_4 + 0.0158708780931009*G0_0_1_3_5 - 0.00615680615680623*G0_0_1_4_0 + 0.00246272246272252*G0_0_1_4_1 + 0.019838597616376*G0_0_1_4_2 - 0.00383090160867947*G0_0_1_4_3 - 0.121494308160978*G0_0_1_4_4 + 0.00985088985089033*G0_0_1_4_5 - 0.00574635241301915*G0_0_1_5_0 + 0.00547271658382787*G0_0_1_5_1 - 0.00738816738816768*G0_0_1_5_2 + 0.0158708780931009*G0_0_1_5_3 + 0.00985088985089033*G0_0_1_5_4;
    A[101] = A[171] - 0.104665704665709*G0_0_1_0_0 - 0.000615680615680611*G0_0_1_0_1 + 0.00129977018865913*G0_0_1_0_2 + 0.00136817914595696*G0_0_1_0_3 + 0.00396771952327513*G0_0_1_0_4 + 0.00834589279033746*G0_0_1_0_5 - 0.000615680615680611*G0_0_1_1_0 + 0.00944043610710319*G0_0_1_1_1 - 0.000820907487574216*G0_0_1_1_2 + 0.00328362995029685*G0_0_1_1_3 - 0.00164181497514834*G0_0_1_1_4 - 0.0028731762065097*G0_0_1_1_5 + 0.00129977018865913*G0_0_1_2_0 - 0.000820907487574215*G0_0_1_2_1 - 0.000820907487574176*G0_0_1_2_2 + 0.00136817914595696*G0_0_1_2_3 - 0.01080861525306*G0_0_1_2_4 + 0.00300999412110536*G0_0_1_2_5 + 0.00136817914595696*G0_0_1_3_0 + 0.00328362995029685*G0_0_1_3_1 + 0.00136817914595696*G0_0_1_3_2 + 0.00218908663353146*G0_0_1_3_3 + 0.00054727165838277*G0_0_1_3_4 - 0.00875634653412461*G0_0_1_3_5 + 0.00396771952327513*G0_0_1_4_0 - 0.00164181497514834*G0_0_1_4_1 - 0.01080861525306*G0_0_1_4_2 + 0.00054727165838277*G0_0_1_4_3 + 0.0919416386083079*G0_0_1_4_4 - 0.00273635829191406*G0_0_1_4_5 + 0.00834589279033745*G0_0_1_5_0 - 0.0028731762065097*G0_0_1_5_1 + 0.00300999412110536*G0_0_1_5_2 - 0.00875634653412461*G0_0_1_5_3 - 0.00273635829191406*G0_0_1_5_4 + 0.012039976484421*G0_0_1_5_5 + 0.104665704665709*G0_1_0_0_0 + 0.000615680615680612*G0_1_0_0_1 - 0.00129977018865913*G0_1_0_0_2 - 0.00136817914595696*G0_1_0_0_3 - 0.00396771952327514*G0_1_0_0_4 - 0.00834589279033746*G0_1_0_0_5 + 0.000615680615680612*G0_1_0_1_0 - 0.0094404361071032*G0_1_0_1_1 + 0.000820907487574216*G0_1_0_1_2 - 0.00328362995029685*G0_1_0_1_3 + 0.00164181497514834*G0_1_0_1_4 + 0.0028731762065097*G0_1_0_1_5 - 0.00129977018865913*G0_1_0_2_0 + 0.000820907487574216*G0_1_0_2_1 + 0.000820907487574175*G0_1_0_2_2 - 0.00136817914595696*G0_1_0_2_3 + 0.01080861525306*G0_1_0_2_4 - 0.00300999412110536*G0_1_0_2_5 - 0.00136817914595696*G0_1_0_3_0 - 0.00328362995029685*G0_1_0_3_1 - 0.00136817914595696*G0_1_0_3_2 - 0.00218908663353147*G0_1_0_3_3 - 0.000547271658382771*G0_1_0_3_4 + 0.00875634653412461*G0_1_0_3_5 - 0.00396771952327514*G0_1_0_4_0 + 0.00164181497514834*G0_1_0_4_1 + 0.01080861525306*G0_1_0_4_2 - 0.000547271658382772*G0_1_0_4_3 - 0.0919416386083079*G0_1_0_4_4 + 0.00273635829191406*G0_1_0_4_5 - 0.00834589279033746*G0_1_0_5_0 + 0.0028731762065097*G0_1_0_5_1 - 0.00300999412110536*G0_1_0_5_2 + 0.00875634653412461*G0_1_0_5_3 + 0.00273635829191406*G0_1_0_5_4 - 0.012039976484421*G0_1_0_5_5;
    A[93] = -A[101] - 0.0788071188071214*G0_0_0_0_0 - 0.00109454331676558*G0_0_0_0_1 + 0.0132029287584847*G0_0_0_0_2 + 0.00123136123136131*G0_0_0_0_3 - 0.0864689220244804*G0_0_0_0_4 + 0.000684089572978452*G0_0_0_0_5 - 0.00109454331676558*G0_0_0_1_0 + 0.00410453743787085*G0_0_0_1_1 - 0.0109454331676559*G0_0_0_1_3 + 0.00205226871893542*G0_0_0_1_4 - 0.00547271658382785*G0_0_0_1_5 + 0.0132029287584847*G0_0_0_2_0 - 0.0201122334455672*G0_0_0_2_2 + 0.0119031585698257*G0_0_0_2_3 + 0.0357094757094769*G0_0_0_2_4 - 0.00916680027791172*G0_0_0_2_5 + 0.0012313612313613*G0_0_0_3_0 - 0.0109454331676559*G0_0_0_3_1 + 0.0119031585698257*G0_0_0_3_2 - 0.0476126342793031*G0_0_0_3_3 - 0.00656725990059341*G0_0_0_3_4 + 0.0158708780931008*G0_0_0_3_5 - 0.0864689220244804*G0_0_0_4_0 + 0.00205226871893542*G0_0_0_4_1 + 0.0357094757094769*G0_0_0_4_2 - 0.00656725990059341*G0_0_0_4_3 - 0.211794131794138*G0_0_0_4_4 + 0.0142290631179526*G0_0_0_4_5 + 0.000684089572978452*G0_0_0_5_0 - 0.00547271658382785*G0_0_0_5_1 - 0.00916680027791172*G0_0_0_5_2 + 0.0158708780931008*G0_0_0_5_3 + 0.0142290631179526*G0_0_0_5_4 + 0.0651253273475521*G0_0_0_5_5 + 0.114106140772812*G0_1_0_0_0 - 0.00177863288974408*G0_1_0_0_1 - 0.00280476724921181*G0_1_0_0_2 - 0.0005472716583828*G0_1_0_0_3 - 0.00615680615680624*G0_1_0_0_4 - 0.00574635241301916*G0_1_0_0_5 - 0.00177863288974408*G0_1_0_1_0 - 0.000684089572978478*G0_1_0_1_2 - 0.00547271658382791*G0_1_0_1_3 + 0.00246272246272252*G0_1_0_1_4 + 0.00547271658382787*G0_1_0_1_5 - 0.00280476724921181*G0_1_0_2_0 - 0.000684089572978478*G0_1_0_2_1 - 0.0143658810325481*G0_1_0_2_2 + 0.00766180321735903*G0_1_0_2_3 + 0.019838597616376*G0_1_0_2_4 - 0.00738816738816768*G0_1_0_2_5 - 0.0005472716583828*G0_1_0_3_0 - 0.00547271658382791*G0_1_0_3_1 + 0.00766180321735903*G0_1_0_3_2 - 0.0317417561862019*G0_1_0_3_3 - 0.00383090160867947*G0_1_0_3_4 + 0.0158708780931009*G0_1_0_3_5 - 0.00615680615680624*G0_1_0_4_0 + 0.00246272246272252*G0_1_0_4_1 + 0.019838597616376*G0_1_0_4_2 - 0.00383090160867947*G0_1_0_4_3 - 0.121494308160978*G0_1_0_4_4 + 0.00985088985089033*G0_1_0_4_5 - 0.00574635241301916*G0_1_0_5_0 + 0.00547271658382787*G0_1_0_5_1 - 0.00738816738816768*G0_1_0_5_2 + 0.0158708780931009*G0_1_0_5_3 + 0.00985088985089033*G0_1_0_5_4;
    A[152] = A[40] + 0.00695206028539389*G0_0_1_0_0 + 0.000641333974667321*G0_0_1_0_3 - 0.00220618887285559*G0_0_1_0_4 - 0.0107615840949178*G0_0_1_0_5 - 0.00695206028539393*G0_0_1_1_1 + 0.00220618887285562*G0_0_1_1_3 - 0.000641333974667319*G0_0_1_1_4 + 0.0107615840949178*G0_0_1_1_5 - 0.00137245470578813*G0_0_1_2_3 + 0.00137245470578804*G0_0_1_2_4 + 0.000641333974667321*G0_0_1_3_0 + 0.00220618887285562*G0_0_1_3_1 - 0.00137245470578813*G0_0_1_3_2 - 0.000615680615680598*G0_0_1_3_3 - 0.00128266794933463*G0_0_1_3_5 - 0.00220618887285559*G0_0_1_4_0 - 0.000641333974667319*G0_0_1_4_1 + 0.00137245470578804*G0_0_1_4_2 + 0.000615680615680634*G0_0_1_4_4 + 0.00128266794933464*G0_0_1_4_5 - 0.0107615840949178*G0_0_1_5_0 + 0.0107615840949178*G0_0_1_5_1 - 0.00128266794933463*G0_0_1_5_3 + 0.00128266794933464*G0_0_1_5_4 - 0.00695206028539389*G0_1_0_0_0 - 0.000641333974667321*G0_1_0_0_3 + 0.00220618887285559*G0_1_0_0_4 + 0.0107615840949178*G0_1_0_0_5 + 0.00695206028539393*G0_1_0_1_1 - 0.00220618887285562*G0_1_0_1_3 + 0.000641333974667318*G0_1_0_1_4 - 0.0107615840949178*G0_1_0_1_5 + 0.00137245470578813*G0_1_0_2_3 - 0.00137245470578804*G0_1_0_2_4 - 0.000641333974667321*G0_1_0_3_0 - 0.00220618887285562*G0_1_0_3_1 + 0.00137245470578813*G0_1_0_3_2 + 0.000615680615680598*G0_1_0_3_3 + 0.00128266794933463*G0_1_0_3_5 + 0.00220618887285559*G0_1_0_4_0 + 0.000641333974667319*G0_1_0_4_1 - 0.00137245470578804*G0_1_0_4_2 - 0.000615680615680635*G0_1_0_4_4 - 0.00128266794933464*G0_1_0_4_5 + 0.0107615840949178*G0_1_0_5_0 - 0.0107615840949178*G0_1_0_5_1 + 0.00128266794933463*G0_1_0_5_3 - 0.00128266794933464*G0_1_0_5_4;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class laplacian_f2_p2_q4_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  laplacian_f2_p2_q4_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p2_q4_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p2_q4_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p2_q4_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p2_q4_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p2_q4_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p2_q4_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p2_q4_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p2_q4_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p2_q4_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p2_q4_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
