// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F2_P3_Q3_TENSOR_H
#define __LAPLACIAN_F2_P3_Q3_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f2_p3_q3_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p3_q3_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q3_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p3_q3_tensor_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p3_q3_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p3_q3_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q3_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p3_q3_tensor_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f2_p3_q3_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f2_p3_q3_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q3_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    1200
    // Number of operations (multiply-add pairs) for tensor contraction: 21623
    // Total number of operations (multiply-add pairs):                  22834
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3 = det*(w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4 = det*(w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5 = det*(w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_6 = det*(w[0][0]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_7 = det*(w[0][0]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_8 = det*(w[0][0]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_9 = det*(w[0][0]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3 = det*(w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4 = det*(w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5 = det*(w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_6 = det*(w[0][1]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_7 = det*(w[0][1]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_8 = det*(w[0][1]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_9 = det*(w[0][1]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3 = det*(w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4 = det*(w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5 = det*(w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_6 = det*(w[0][2]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_7 = det*(w[0][2]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_8 = det*(w[0][2]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_9 = det*(w[0][2]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0 = det*(w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1 = det*(w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2 = det*(w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3 = det*(w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4 = det*(w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5 = det*(w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_6 = det*(w[0][3]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_7 = det*(w[0][3]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_8 = det*(w[0][3]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_9 = det*(w[0][3]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0 = det*(w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1 = det*(w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2 = det*(w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3 = det*(w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4 = det*(w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5 = det*(w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_6 = det*(w[0][4]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_7 = det*(w[0][4]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_8 = det*(w[0][4]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_9 = det*(w[0][4]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0 = det*(w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1 = det*(w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2 = det*(w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3 = det*(w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4 = det*(w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5 = det*(w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_6 = det*(w[0][5]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_7 = det*(w[0][5]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_8 = det*(w[0][5]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_9 = det*(w[0][5]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_0 = det*(w[0][6]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_1 = det*(w[0][6]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_2 = det*(w[0][6]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_3 = det*(w[0][6]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_4 = det*(w[0][6]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_5 = det*(w[0][6]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_6 = det*(w[0][6]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_7 = det*(w[0][6]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_8 = det*(w[0][6]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_9 = det*(w[0][6]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_0 = det*(w[0][7]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_1 = det*(w[0][7]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_2 = det*(w[0][7]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_3 = det*(w[0][7]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_4 = det*(w[0][7]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_5 = det*(w[0][7]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_6 = det*(w[0][7]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_7 = det*(w[0][7]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_8 = det*(w[0][7]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_9 = det*(w[0][7]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_0 = det*(w[0][8]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_1 = det*(w[0][8]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_2 = det*(w[0][8]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_3 = det*(w[0][8]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_4 = det*(w[0][8]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_5 = det*(w[0][8]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_6 = det*(w[0][8]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_7 = det*(w[0][8]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_8 = det*(w[0][8]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_9 = det*(w[0][8]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_0 = det*(w[0][9]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_1 = det*(w[0][9]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_2 = det*(w[0][9]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_3 = det*(w[0][9]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_4 = det*(w[0][9]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_5 = det*(w[0][9]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_6 = det*(w[0][9]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_7 = det*(w[0][9]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_8 = det*(w[0][9]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_9 = det*(w[0][9]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3 = det*(w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4 = det*(w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5 = det*(w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_6 = det*(w[0][0]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_7 = det*(w[0][0]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_8 = det*(w[0][0]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_9 = det*(w[0][0]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3 = det*(w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4 = det*(w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5 = det*(w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_6 = det*(w[0][1]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_7 = det*(w[0][1]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_8 = det*(w[0][1]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_9 = det*(w[0][1]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3 = det*(w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4 = det*(w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5 = det*(w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_6 = det*(w[0][2]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_7 = det*(w[0][2]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_8 = det*(w[0][2]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_9 = det*(w[0][2]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0 = det*(w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1 = det*(w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2 = det*(w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3 = det*(w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4 = det*(w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5 = det*(w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_6 = det*(w[0][3]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_7 = det*(w[0][3]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_8 = det*(w[0][3]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_9 = det*(w[0][3]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0 = det*(w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1 = det*(w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2 = det*(w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3 = det*(w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4 = det*(w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5 = det*(w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_6 = det*(w[0][4]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_7 = det*(w[0][4]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_8 = det*(w[0][4]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_9 = det*(w[0][4]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0 = det*(w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1 = det*(w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2 = det*(w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3 = det*(w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4 = det*(w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5 = det*(w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_6 = det*(w[0][5]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_7 = det*(w[0][5]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_8 = det*(w[0][5]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_9 = det*(w[0][5]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_0 = det*(w[0][6]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_1 = det*(w[0][6]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_2 = det*(w[0][6]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_3 = det*(w[0][6]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_4 = det*(w[0][6]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_5 = det*(w[0][6]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_6 = det*(w[0][6]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_7 = det*(w[0][6]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_8 = det*(w[0][6]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_9 = det*(w[0][6]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_0 = det*(w[0][7]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_1 = det*(w[0][7]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_2 = det*(w[0][7]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_3 = det*(w[0][7]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_4 = det*(w[0][7]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_5 = det*(w[0][7]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_6 = det*(w[0][7]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_7 = det*(w[0][7]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_8 = det*(w[0][7]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_9 = det*(w[0][7]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_0 = det*(w[0][8]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_1 = det*(w[0][8]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_2 = det*(w[0][8]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_3 = det*(w[0][8]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_4 = det*(w[0][8]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_5 = det*(w[0][8]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_6 = det*(w[0][8]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_7 = det*(w[0][8]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_8 = det*(w[0][8]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_9 = det*(w[0][8]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_0 = det*(w[0][9]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_1 = det*(w[0][9]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_2 = det*(w[0][9]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_3 = det*(w[0][9]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_4 = det*(w[0][9]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_5 = det*(w[0][9]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_6 = det*(w[0][9]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_7 = det*(w[0][9]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_8 = det*(w[0][9]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_9 = det*(w[0][9]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3 = det*(w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4 = det*(w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5 = det*(w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_6 = det*(w[0][0]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_7 = det*(w[0][0]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_8 = det*(w[0][0]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_9 = det*(w[0][0]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3 = det*(w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4 = det*(w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5 = det*(w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_6 = det*(w[0][1]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_7 = det*(w[0][1]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_8 = det*(w[0][1]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_9 = det*(w[0][1]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3 = det*(w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4 = det*(w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5 = det*(w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_6 = det*(w[0][2]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_7 = det*(w[0][2]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_8 = det*(w[0][2]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_9 = det*(w[0][2]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0 = det*(w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1 = det*(w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2 = det*(w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3 = det*(w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4 = det*(w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5 = det*(w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_6 = det*(w[0][3]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_7 = det*(w[0][3]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_8 = det*(w[0][3]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_9 = det*(w[0][3]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0 = det*(w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1 = det*(w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2 = det*(w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3 = det*(w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4 = det*(w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5 = det*(w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_6 = det*(w[0][4]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_7 = det*(w[0][4]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_8 = det*(w[0][4]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_9 = det*(w[0][4]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0 = det*(w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1 = det*(w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2 = det*(w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3 = det*(w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4 = det*(w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5 = det*(w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_6 = det*(w[0][5]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_7 = det*(w[0][5]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_8 = det*(w[0][5]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_9 = det*(w[0][5]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_0 = det*(w[0][6]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_1 = det*(w[0][6]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_2 = det*(w[0][6]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_3 = det*(w[0][6]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_4 = det*(w[0][6]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_5 = det*(w[0][6]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_6 = det*(w[0][6]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_7 = det*(w[0][6]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_8 = det*(w[0][6]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_9 = det*(w[0][6]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_0 = det*(w[0][7]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_1 = det*(w[0][7]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_2 = det*(w[0][7]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_3 = det*(w[0][7]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_4 = det*(w[0][7]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_5 = det*(w[0][7]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_6 = det*(w[0][7]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_7 = det*(w[0][7]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_8 = det*(w[0][7]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_9 = det*(w[0][7]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_0 = det*(w[0][8]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_1 = det*(w[0][8]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_2 = det*(w[0][8]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_3 = det*(w[0][8]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_4 = det*(w[0][8]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_5 = det*(w[0][8]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_6 = det*(w[0][8]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_7 = det*(w[0][8]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_8 = det*(w[0][8]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_9 = det*(w[0][8]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_0 = det*(w[0][9]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_1 = det*(w[0][9]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_2 = det*(w[0][9]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_3 = det*(w[0][9]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_4 = det*(w[0][9]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_5 = det*(w[0][9]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_6 = det*(w[0][9]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_7 = det*(w[0][9]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_8 = det*(w[0][9]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_9 = det*(w[0][9]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3 = det*(w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4 = det*(w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5 = det*(w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_6 = det*(w[0][0]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_7 = det*(w[0][0]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_8 = det*(w[0][0]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_9 = det*(w[0][0]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3 = det*(w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4 = det*(w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5 = det*(w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_6 = det*(w[0][1]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_7 = det*(w[0][1]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_8 = det*(w[0][1]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_9 = det*(w[0][1]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3 = det*(w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4 = det*(w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5 = det*(w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_6 = det*(w[0][2]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_7 = det*(w[0][2]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_8 = det*(w[0][2]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_9 = det*(w[0][2]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0 = det*(w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1 = det*(w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2 = det*(w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3 = det*(w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4 = det*(w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5 = det*(w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_6 = det*(w[0][3]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_7 = det*(w[0][3]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_8 = det*(w[0][3]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_9 = det*(w[0][3]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0 = det*(w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1 = det*(w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2 = det*(w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3 = det*(w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4 = det*(w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5 = det*(w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_6 = det*(w[0][4]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_7 = det*(w[0][4]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_8 = det*(w[0][4]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_9 = det*(w[0][4]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0 = det*(w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1 = det*(w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2 = det*(w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3 = det*(w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4 = det*(w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5 = det*(w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_6 = det*(w[0][5]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_7 = det*(w[0][5]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_8 = det*(w[0][5]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_9 = det*(w[0][5]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_0 = det*(w[0][6]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_1 = det*(w[0][6]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_2 = det*(w[0][6]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_3 = det*(w[0][6]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_4 = det*(w[0][6]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_5 = det*(w[0][6]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_6 = det*(w[0][6]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_7 = det*(w[0][6]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_8 = det*(w[0][6]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_9 = det*(w[0][6]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_0 = det*(w[0][7]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_1 = det*(w[0][7]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_2 = det*(w[0][7]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_3 = det*(w[0][7]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_4 = det*(w[0][7]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_5 = det*(w[0][7]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_6 = det*(w[0][7]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_7 = det*(w[0][7]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_8 = det*(w[0][7]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_9 = det*(w[0][7]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_0 = det*(w[0][8]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_1 = det*(w[0][8]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_2 = det*(w[0][8]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_3 = det*(w[0][8]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_4 = det*(w[0][8]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_5 = det*(w[0][8]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_6 = det*(w[0][8]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_7 = det*(w[0][8]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_8 = det*(w[0][8]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_9 = det*(w[0][8]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_0 = det*(w[0][9]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_1 = det*(w[0][9]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_2 = det*(w[0][9]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_3 = det*(w[0][9]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_4 = det*(w[0][9]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_5 = det*(w[0][9]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_6 = det*(w[0][9]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_7 = det*(w[0][9]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_8 = det*(w[0][9]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_9 = det*(w[0][9]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[73] = -0.00474837662337685*G0_0_0_0_0 + 0.000493100649350667*G0_0_0_0_1 - 0.000264813311688325*G0_0_0_0_2 + 0.00542410714285736*G0_0_0_0_3 + 0.000739650974026009*G0_0_0_0_4 - 0.00682122564935092*G0_0_0_0_5 + 0.00378043831168846*G0_0_0_0_6 - 0.00139711850649359*G0_0_0_0_7 + 0.0018080357142858*G0_0_0_0_8 + 0.000986201298701326*G0_0_0_0_9 + 0.000493100649350667*G0_0_0_1_0 + 0.0126927759740264*G0_0_0_1_1 + 0.00253855519480528*G0_0_0_1_2 + 0.0196418425324682*G0_0_0_1_3 - 0.0119165990259744*G0_0_0_1_4 - 0.002218952922078*G0_0_0_1_5 - 0.000493100649350664*G0_0_0_1_6 - 0.00353388798701312*G0_0_0_1_7 + 0.00953327922077957*G0_0_0_1_8 + 0.00641030844155867*G0_0_0_1_9 - 0.000264813311688325*G0_0_0_2_0 + 0.00253855519480528*G0_0_0_2_1 + 0.000821834415584434*G0_0_0_2_2 + 0.001479301948052*G0_0_0_2_3 - 0.00246550324675334*G0_0_0_2_4 - 0.002958603896104*G0_0_0_2_5 + 0.00493100649350665*G0_0_0_2_6 - 0.00197240259740267*G0_0_0_2_7 - 0.00221895292207798*G0_0_0_2_8 - 0.00591720779220799*G0_0_0_2_9 + 0.00542410714285736*G0_0_0_3_0 + 0.0196418425324682*G0_0_0_3_1 + 0.001479301948052*G0_0_0_3_2 + 0.171599025974032*G0_0_0_3_3 - 0.00443790584415594*G0_0_0_3_4 - 0.00443790584415599*G0_0_0_3_5 + 0.000739650974025984*G0_0_0_3_6 - 0.017011972402598*G0_0_0_3_7 + 0.0110947646103901*G0_0_0_3_8 + 0.0147930194805201*G0_0_0_3_9 + 0.000739650974026009*G0_0_0_4_0 - 0.0119165990259744*G0_0_0_4_1 - 0.00246550324675334*G0_0_0_4_2 - 0.00443790584415595*G0_0_0_4_3 + 0.050296266233768*G0_0_0_4_4 - 0.00295860389610399*G0_0_0_4_5 + 0.00221895292207802*G0_0_0_4_6 + 0.00221895292207801*G0_0_0_4_7 + 0.00591720779220795*G0_0_0_4_8 + 0.023668831168832*G0_0_0_4_9 - 0.00682122564935092*G0_0_0_5_0 - 0.002218952922078*G0_0_0_5_1 - 0.002958603896104*G0_0_0_5_2 - 0.00443790584415599*G0_0_0_5_3 - 0.002958603896104*G0_0_0_5_4 - 0.054734172077924*G0_0_0_5_5 + 0.00369825487013001*G0_0_0_5_6 - 0.01109476461039*G0_0_0_5_7 + 0.00591720779220801*G0_0_0_5_8 - 0.01479301948052*G0_0_0_5_9 + 0.00378043831168846*G0_0_0_6_0 - 0.000493100649350664*G0_0_0_6_1 + 0.00493100649350665*G0_0_0_6_2 + 0.000739650974025984*G0_0_0_6_3 + 0.00221895292207802*G0_0_0_6_4 + 0.00369825487013001*G0_0_0_6_5 + 0.00443790584415599*G0_0_0_6_6 + 0.00517755681818201*G0_0_0_6_7 + 0.00443790584415597*G0_0_0_6_8 + 0.016272321428572*G0_0_0_6_9 - 0.00139711850649359*G0_0_0_7_0 - 0.00353388798701312*G0_0_0_7_1 - 0.00197240259740267*G0_0_0_7_2 - 0.017011972402598*G0_0_0_7_3 + 0.00221895292207801*G0_0_0_7_4 - 0.01109476461039*G0_0_0_7_5 + 0.00517755681818201*G0_0_0_7_6 - 0.011834415584416*G0_0_0_7_7 - 0.00147930194805202*G0_0_0_7_8 - 0.013313717532468*G0_0_0_7_9 + 0.0018080357142858*G0_0_0_8_0 + 0.00953327922077957*G0_0_0_8_1 - 0.00221895292207798*G0_0_0_8_2 + 0.0110947646103901*G0_0_0_8_3 + 0.00591720779220795*G0_0_0_8_4 + 0.00591720779220801*G0_0_0_8_5 + 0.00443790584415597*G0_0_0_8_6 - 0.00147930194805202*G0_0_0_8_7 - 0.0310653409090919*G0_0_0_8_8 - 0.0310653409090919*G0_0_0_8_9 + 0.000986201298701325*G0_0_0_9_0 + 0.00641030844155867*G0_0_0_9_1 - 0.00591720779220799*G0_0_0_9_2 + 0.0147930194805201*G0_0_0_9_3 + 0.023668831168832*G0_0_0_9_4 - 0.01479301948052*G0_0_0_9_5 + 0.016272321428572*G0_0_0_9_6 - 0.013313717532468*G0_0_0_9_7 - 0.0310653409090919*G0_0_0_9_8 - 0.159764610389616*G0_0_0_9_9 - 0.00374391233766239*G0_0_1_0_0 + 0.00349736201298716*G0_0_1_0_1 + 5.47889610389685e-05*G0_0_1_0_2 + 0.00682122564935092*G0_0_1_0_3 - 0.00156148538961045*G0_0_1_0_4 - 0.00336952110389619*G0_0_1_0_5 + 0.00156148538961043*G0_0_1_0_6 - 0.00443790584415597*G0_0_1_0_7 + 0.00419135551948066*G0_0_1_0_8 + 0.00349736201298716*G0_0_1_1_0 + 0.0871144480519509*G0_0_1_1_1 + 0.00644683441558463*G0_0_1_1_2 + 0.0653358360389632*G0_0_1_1_3 - 0.0295860389610399*G0_0_1_1_4 - 0.00205458603896111*G0_0_1_1_5 - 0.00131493506493512*G0_0_1_1_6 - 0.0172585227272734*G0_0_1_1_7 + 0.0382153003246767*G0_0_1_1_8 + 0.0123275162337667*G0_0_1_1_9 + 5.47889610389685e-05*G0_0_1_2_0 + 0.00644683441558463*G0_0_1_2_1 + 0.000292207792207801*G0_0_1_2_2 + 0.00904017857142887*G0_0_1_2_3 - 0.0035338879870131*G0_0_1_2_4 - 0.000986201298701328*G0_0_1_2_5 + 0.000986201298701326*G0_0_1_2_6 - 0.00254768668831178*G0_0_1_2_7 - 0.00230113636363643*G0_0_1_2_8 - 0.00443790584415598*G0_0_1_2_9 + 0.00682122564935092*G0_0_1_3_0 + 0.0653358360389632*G0_0_1_3_1 + 0.00904017857142887*G0_0_1_3_2 + 0.193048904220786*G0_0_1_3_3 - 0.0428997564935079*G0_0_1_3_4 - 0.005177556818182*G0_0_1_3_5 - 0.0244084821428581*G0_0_1_3_7 + 0.0214498782467542*G0_0_1_3_8 + 0.0118344155844161*G0_0_1_3_9 - 0.00156148538961045*G0_0_1_4_0 - 0.0295860389610399*G0_0_1_4_1 - 0.0035338879870131*G0_0_1_4_2 - 0.0428997564935079*G0_0_1_4_3 + 0.0184912743506499*G0_0_1_4_4 + 0.000739650974026003*G0_0_1_4_5 - 0.000739650974025996*G0_0_1_4_6 + 0.00813616071428603*G0_0_1_4_7 + 0.00295860389610392*G0_0_1_4_8 + 0.0118344155844159*G0_0_1_4_9 - 0.00336952110389619*G0_0_1_5_0 - 0.00205458603896111*G0_0_1_5_1 - 0.000986201298701328*G0_0_1_5_2 - 0.005177556818182*G0_0_1_5_3 + 0.000739650974026003*G0_0_1_5_4 - 0.01109476461039*G0_0_1_5_5 + 0.00295860389610398*G0_0_1_5_6 - 0.00591720779220796*G0_0_1_5_7 + 0.00221895292207798*G0_0_1_5_8 - 0.004437905844156*G0_0_1_5_9 + 0.00156148538961043*G0_0_1_6_0 - 0.00131493506493512*G0_0_1_6_1 + 0.000986201298701326*G0_0_1_6_2 - 0.000739650974025997*G0_0_1_6_4 + 0.00295860389610398*G0_0_1_6_5 - 0.000739650974026003*G0_0_1_6_6 + 0.00369825487012999*G0_0_1_6_7 + 0.00739650974025998*G0_0_1_6_8 + 0.013313717532468*G0_0_1_6_9 - 0.00443790584415597*G0_0_1_7_0 - 0.0172585227272734*G0_0_1_7_1 - 0.00254768668831178*G0_0_1_7_2 - 0.0244084821428581*G0_0_1_7_3 + 0.00813616071428603*G0_0_1_7_4 - 0.00591720779220796*G0_0_1_7_5 + 0.00369825487012999*G0_0_1_7_6 - 0.0140533685064939*G0_0_1_7_7 - 0.00813616071428614*G0_0_1_7_8 - 0.00739650974026005*G0_0_1_7_9 + 0.00419135551948066*G0_0_1_8_0 + 0.0382153003246767*G0_0_1_8_1 - 0.00230113636363643*G0_0_1_8_2 + 0.0214498782467542*G0_0_1_8_3 + 0.00295860389610393*G0_0_1_8_4 + 0.00221895292207798*G0_0_1_8_5 + 0.00739650974025998*G0_0_1_8_6 - 0.00813616071428614*G0_0_1_8_7 - 0.0954149756493538*G0_0_1_8_8 - 0.0428997564935079*G0_0_1_8_9 + 0.0123275162337667*G0_0_1_9_1 - 0.00443790584415598*G0_0_1_9_2 + 0.0118344155844161*G0_0_1_9_3 + 0.0118344155844159*G0_0_1_9_4 - 0.004437905844156*G0_0_1_9_5 + 0.013313717532468*G0_0_1_9_6 - 0.00739650974026005*G0_0_1_9_7 - 0.0428997564935079*G0_0_1_9_8 - 0.04437905844156*G0_0_1_9_9 + 0.000730519480519517*G0_1_0_0_0 + 0.00073051948051951*G0_1_0_0_1 + 0.000346996753246762*G0_1_0_0_2 + 0.00747869318181847*G0_1_0_0_3 + 0.000575284090909115*G0_1_0_0_4 + 0.000575284090909116*G0_1_0_0_5 - 0.00115056818181823*G0_1_0_0_6 + 0.00106838474025978*G0_1_0_0_7 + 0.00180803571428578*G0_1_0_0_8 + 0.005917207792208*G0_1_0_0_9 + 0.00073051948051951*G0_1_0_1_0 + 0.0136972402597407*G0_1_0_1_1 + 0.00258421266233775*G0_1_0_1_2 + 0.0197240259740266*G0_1_0_1_3 - 0.0128206168831173*G0_1_0_1_4 + 0.000575284090909112*G0_1_0_1_5 - 0.00115056818181823*G0_1_0_1_6 - 0.00295860389610401*G0_1_0_1_7 + 0.00986201298701334*G0_1_0_1_8 + 0.005917207792208*G0_1_0_1_9 + 0.000346996753246762*G0_1_0_2_0 + 0.00258421266233775*G0_1_0_2_1 - 0.00109577922077929*G0_1_0_2_2 + 0.002958603896104*G0_1_0_2_3 - 0.00493100649350668*G0_1_0_2_4 - 0.00238331980519489*G0_1_0_2_7 - 0.00164366883116888*G0_1_0_2_8 - 0.00788961038961065*G0_1_0_2_9 + 0.00747869318181847*G0_1_0_3_0 + 0.0197240259740266*G0_1_0_3_1 + 0.002958603896104*G0_1_0_3_2 + 0.193048904220786*G0_1_0_3_3 - 0.00665685876623393*G0_1_0_3_4 - 0.01109476461039*G0_1_0_3_5 + 0.001479301948052*G0_1_0_3_6 - 0.024408482142858*G0_1_0_3_7 + 0.0214498782467541*G0_1_0_3_8 + 0.0310653409090921*G0_1_0_3_9 + 0.000575284090909115*G0_1_0_4_0 - 0.0128206168831173*G0_1_0_4_1 - 0.00493100649350668*G0_1_0_4_2 - 0.00665685876623393*G0_1_0_4_3 + 0.0599117288961059*G0_1_0_4_4 - 0.00369825487012999*G0_1_0_4_5 + 0.00221895292207799*G0_1_0_4_6 + 0.00369825487013001*G0_1_0_4_7 + 0.00295860389610396*G0_1_0_4_8 + 0.0310653409090919*G0_1_0_4_9 + 0.000575284090909116*G0_1_0_5_0 + 0.000575284090909112*G0_1_0_5_1 - 0.01109476461039*G0_1_0_5_3 - 0.00369825487012999*G0_1_0_5_4 + 0.00961546266233799*G0_1_0_5_5 + 0.001479301948052*G0_1_0_5_6 - 0.00147930194805197*G0_1_0_5_7 - 0.00369825487013001*G0_1_0_5_8 - 0.010355113636364*G0_1_0_5_9 - 0.00115056818181823*G0_1_0_6_0 - 0.00115056818181823*G0_1_0_6_1 + 0.001479301948052*G0_1_0_6_3 + 0.00221895292207799*G0_1_0_6_4 + 0.001479301948052*G0_1_0_6_5 + 0.00221895292207789*G0_1_0_6_6 + 0.00517755681818199*G0_1_0_6_7 + 0.00517755681818199*G0_1_0_6_8 + 0.0207102272727279*G0_1_0_6_9 + 0.00106838474025978*G0_1_0_7_0 - 0.00295860389610401*G0_1_0_7_1 - 0.00238331980519489*G0_1_0_7_2 - 0.024408482142858*G0_1_0_7_3 + 0.00369825487013001*G0_1_0_7_4 - 0.00147930194805197*G0_1_0_7_5 + 0.00517755681818199*G0_1_0_7_6 - 0.014053368506494*G0_1_0_7_7 - 0.00887581168831204*G0_1_0_7_8 - 0.028106737012988*G0_1_0_7_9 + 0.00180803571428578*G0_1_0_8_0 + 0.00986201298701334*G0_1_0_8_1 - 0.00164366883116888*G0_1_0_8_2 + 0.0214498782467541*G0_1_0_8_3 + 0.00295860389610396*G0_1_0_8_4 - 0.00369825487013001*G0_1_0_8_5 + 0.00517755681818199*G0_1_0_8_6 - 0.00887581168831204*G0_1_0_8_7 - 0.0214498782467539*G0_1_0_8_8 - 0.0236688311688319*G0_1_0_8_9 + 0.005917207792208*G0_1_0_9_0 + 0.005917207792208*G0_1_0_9_1 - 0.00788961038961065*G0_1_0_9_2 + 0.0310653409090921*G0_1_0_9_3 + 0.0310653409090919*G0_1_0_9_4 - 0.010355113636364*G0_1_0_9_5 + 0.0207102272727279*G0_1_0_9_6 - 0.028106737012988*G0_1_0_9_7 - 0.0236688311688319*G0_1_0_9_8 - 0.13313717532468*G0_1_0_9_9 + 0.00173498376623382*G0_1_1_0_0 + 0.00465706168831187*G0_1_1_0_1 + 0.000730519480519507*G0_1_1_0_2 + 0.00887581168831203*G0_1_1_0_3 - 0.00271205357142867*G0_1_1_0_4 + 0.00032873376623377*G0_1_1_0_5 - 0.000904017857142885*G0_1_1_0_6 + 0.0017258522727273*G0_1_1_0_7 + 0.00419135551948069*G0_1_1_0_8 + 0.00246550324675335*G0_1_1_0_9 + 0.00465706168831187*G0_1_1_1_0 + 0.0925933441558472*G0_1_1_1_1 + 0.00712256493506517*G0_1_1_1_2 + 0.0690340909090932*G0_1_1_1_3 - 0.0320515422077933*G0_1_1_1_4 - 0.00246550324675333*G0_1_1_1_6 - 0.0172585227272734*G0_1_1_1_7 + 0.0443790584415601*G0_1_1_1_8 + 0.01479301948052*G0_1_1_1_9 + 0.000730519480519507*G0_1_1_2_0 + 0.00712256493506516*G0_1_1_2_1 + 0.00052962662337664*G0_1_1_2_2 + 0.0106016639610393*G0_1_1_2_3 - 0.00468445616883132*G0_1_1_2_4 + 0.000575284090909107*G0_1_1_2_5 - 0.000164366883116889*G0_1_1_2_6 - 0.00172585227272735*G0_1_1_2_7 - 0.00147930194805198*G0_1_1_2_8 - 0.00246550324675333*G0_1_1_2_9 + 0.00887581168831203*G0_1_1_3_0 + 0.0690340909090932*G0_1_1_3_1 + 0.0106016639610393*G0_1_1_3_2 + 0.21449878246754*G0_1_1_3_3 - 0.0488169642857159*G0_1_1_3_4 - 0.00961546266233799*G0_1_1_3_5 - 0.0340239448051961*G0_1_1_3_7 + 0.0369825487013002*G0_1_1_3_8 + 0.0236688311688322*G0_1_1_3_9 - 0.00271205357142867*G0_1_1_4_0 - 0.0320515422077933*G0_1_1_4_1 - 0.00468445616883132*G0_1_1_4_2 - 0.0488169642857159*G0_1_1_4_3 + 0.0207102272727279*G0_1_1_4_4 + 0.000739650974026003*G0_1_1_4_5 - 0.000739650974025997*G0_1_1_4_6 + 0.010355113636364*G0_1_1_4_7 - 0.00295860389610406*G0_1_1_4_8 + 0.00591720779220795*G0_1_1_4_9 + 0.00032873376623377*G0_1_1_5_0 + 0.000575284090909107*G0_1_1_5_2 - 0.00961546266233799*G0_1_1_5_3 + 0.000739650974026003*G0_1_1_5_4 + 0.010355113636364*G0_1_1_5_5 - 0.00295860389610398*G0_1_1_5_6 + 0.00961546266233794*G0_1_1_5_7 - 0.00739650974025998*G0_1_1_5_8 + 0.00739650974025995*G0_1_1_5_9 - 0.000904017857142885*G0_1_1_6_0 - 0.00246550324675333*G0_1_1_6_1 - 0.000164366883116889*G0_1_1_6_2 - 0.000739650974025997*G0_1_1_6_4 - 0.00295860389610398*G0_1_1_6_5 + 0.00147930194805198*G0_1_1_6_6 - 0.00221895292207796*G0_1_1_6_7 + 0.00961546266233797*G0_1_1_6_8 + 0.00739650974026*G0_1_1_6_9 + 0.0017258522727273*G0_1_1_7_0 - 0.0172585227272734*G0_1_1_7_1 - 0.00172585227272735*G0_1_1_7_2 - 0.0340239448051961*G0_1_1_7_3 + 0.010355113636364*G0_1_1_7_4 + 0.00961546266233794*G0_1_1_7_5 - 0.00221895292207796*G0_1_1_7_6 + 0.0147930194805199*G0_1_1_7_7 - 0.032544642857144*G0_1_1_7_8 - 0.00295860389610411*G0_1_1_7_9 + 0.00419135551948069*G0_1_1_8_0 + 0.0443790584415601*G0_1_1_8_1 - 0.00147930194805198*G0_1_1_8_2 + 0.0369825487013002*G0_1_1_8_3 - 0.00295860389610406*G0_1_1_8_4 - 0.00739650974025998*G0_1_1_8_5 + 0.00961546266233797*G0_1_1_8_6 - 0.032544642857144*G0_1_1_8_7 - 0.0665685876623398*G0_1_1_8_8 - 0.0384618506493519*G0_1_1_8_9 + 0.00246550324675335*G0_1_1_9_0 + 0.01479301948052*G0_1_1_9_1 - 0.00246550324675333*G0_1_1_9_2 + 0.0236688311688322*G0_1_1_9_3 + 0.00591720779220796*G0_1_1_9_4 + 0.00739650974025995*G0_1_1_9_5 + 0.00739650974026*G0_1_1_9_6 - 0.00295860389610411*G0_1_1_9_7 - 0.0384618506493519*G0_1_1_9_8 - 0.0177516233766241*G0_1_1_9_9;
    A[16] = 0.000420048701298719*G0_0_0_0_0 + 0.00021002435064936*G0_0_0_0_1 - 0.00137581168831175*G0_0_0_0_2 + 0.00100446428571433*G0_0_0_0_3 + 0.000127840909090909*G0_0_0_0_4 + 0.00173498376623383*G0_0_0_0_5 - 0.0025385551948053*G0_0_0_0_6 - 6.39204545454578e-05*G0_0_0_0_7 + 0.000566152597402623*G0_0_0_0_8 + 0.00158887987012993*G0_0_0_0_9 + 0.00021002435064936*G0_0_0_1_0 + 0.00273944805194818*G0_0_0_1_1 - 0.000517451298701322*G0_0_0_1_2 + 0.00378956980519495*G0_0_0_1_3 - 0.00171672077922085*G0_0_0_1_4 + 0.000264813311688324*G0_0_0_1_5 - 0.00184456168831176*G0_0_0_1_6 - 0.00107751623376629*G0_0_0_1_7 + 0.00223721590909102*G0_0_0_1_8 + 0.000602678571428597*G0_0_0_1_9 - 0.00137581168831175*G0_0_0_2_0 - 0.000517451298701322*G0_0_0_2_1 - 0.0195413961038968*G0_0_0_2_2 + 0.00465706168831186*G0_0_0_2_3 - 0.00808137175324707*G0_0_0_2_4 + 0.00712256493506521*G0_0_0_2_5 - 0.0154778814935071*G0_0_0_2_6 - 6.39204545454585e-05*G0_0_0_2_7 + 0.000922280844155879*G0_0_0_2_8 - 0.00246550324675333*G0_0_0_2_9 + 0.00100446428571433*G0_0_0_3_0 + 0.00378956980519495*G0_0_0_3_1 + 0.00465706168831186*G0_0_0_3_2 + 0.0113413149350653*G0_0_0_3_3 - 0.00394480519480531*G0_0_0_3_4 - 0.00197240259740267*G0_0_0_3_5 + 0.00567065746753267*G0_0_0_3_6 - 0.00287642045454557*G0_0_0_3_7 + 0.0055062905844158*G0_0_0_3_8 + 0.00394480519480535*G0_0_0_3_9 + 0.000127840909090909*G0_0_0_4_0 - 0.00171672077922085*G0_0_0_4_1 - 0.00808137175324707*G0_0_0_4_2 - 0.00394480519480531*G0_0_0_4_3 + 0.0202171266233773*G0_0_0_4_4 - 0.000246550324675316*G0_0_0_4_5 - 0.00542410714285736*G0_0_0_4_6 - 0.000164366883116882*G0_0_0_4_7 - 0.00262987012987023*G0_0_0_4_8 + 0.00788961038961064*G0_0_0_4_9 + 0.00173498376623383*G0_0_0_5_0 + 0.000264813311688324*G0_0_0_5_1 + 0.00712256493506521*G0_0_0_5_2 - 0.00197240259740267*G0_0_0_5_3 - 0.000246550324675316*G0_0_0_5_4 - 0.00345170454545468*G0_0_0_5_5 + 0.00936891233766271*G0_0_0_5_6 + 0.000328733766233776*G0_0_0_5_7 - 0.000657467532467557*G0_0_0_5_8 - 0.00345170454545465*G0_0_0_5_9 - 0.0025385551948053*G0_0_0_6_0 - 0.00184456168831176*G0_0_0_6_1 - 0.0154778814935071*G0_0_0_6_2 + 0.00567065746753267*G0_0_0_6_3 - 0.00542410714285736*G0_0_0_6_4 + 0.00936891233766271*G0_0_0_6_5 - 0.0537479707792227*G0_0_0_6_6 + 0.000328733766233777*G0_0_0_6_7 + 0.0013149350649351*G0_0_0_6_8 - 0.00394480519480534*G0_0_0_6_9 - 6.39204545454579e-05*G0_0_0_7_0 - 0.00107751623376629*G0_0_0_7_1 - 6.39204545454585e-05*G0_0_0_7_2 - 0.00287642045454557*G0_0_0_7_3 - 0.000164366883116882*G0_0_0_7_4 + 0.000328733766233776*G0_0_0_7_5 + 0.000328733766233777*G0_0_0_7_6 - 0.000164366883116894*G0_0_0_7_7 - 0.00287642045454558*G0_0_0_7_8 - 0.00542410714285734*G0_0_0_7_9 + 0.000566152597402623*G0_0_0_8_0 + 0.00223721590909102*G0_0_0_8_1 + 0.000922280844155879*G0_0_0_8_2 + 0.0055062905844158*G0_0_0_8_3 - 0.00262987012987023*G0_0_0_8_4 - 0.000657467532467557*G0_0_0_8_5 + 0.0013149350649351*G0_0_0_8_6 - 0.00287642045454558*G0_0_0_8_7 + 0.00723214285714318*G0_0_0_8_8 + 0.00345170454545468*G0_0_0_8_9 + 0.00158887987012993*G0_0_0_9_0 + 0.000602678571428597*G0_0_0_9_1 - 0.00246550324675333*G0_0_0_9_2 + 0.00394480519480535*G0_0_0_9_3 + 0.00788961038961064*G0_0_0_9_4 - 0.00345170454545466*G0_0_0_9_5 - 0.00394480519480534*G0_0_0_9_6 - 0.00542410714285734*G0_0_0_9_7 + 0.00345170454545468*G0_0_0_9_8 + 0.00986201298701331*G0_0_0_9_9 - 0.00697646103896127*G0_0_1_0_0 - 0.000447443181818197*G0_0_1_0_1 - 0.0010988230519481*G0_0_1_0_2 + 0.000794439935064967*G0_0_1_0_3 - 0.000164366883116891*G0_0_1_0_4 - 0.00292207792207801*G0_0_1_0_5 - 0.000949675324675366*G0_0_1_0_6 - 0.00225547889610397*G0_0_1_0_7 + 0.000675730519480542*G0_0_1_0_8 - 0.00038352272727274*G0_0_1_0_9 - 0.000447443181818197*G0_0_1_1_0 - 0.000566152597402622*G0_0_1_1_2 + 0.00223721590909099*G0_0_1_1_3 - 0.000858360389610422*G0_0_1_1_4 + 0.00101359577922081*G0_0_1_1_5 + 0.000693993506493529*G0_0_1_1_7 - 0.00223721590909098*G0_0_1_1_8 + 0.000164366883116887*G0_0_1_1_9 - 0.0010988230519481*G0_0_1_2_0 - 0.000566152597402622*G0_0_1_2_1 - 0.0164671266233772*G0_0_1_2_2 + 0.00373478084415598*G0_0_1_2_3 - 0.00599025974025998*G0_0_1_2_4 + 0.00366172889610405*G0_0_1_2_5 - 0.011131290584416*G0_0_1_2_6 + 0.000273944805194815*G0_0_1_2_7 + 0.000219155844155853*G0_0_1_2_8 - 0.00109577922077926*G0_0_1_2_9 + 0.000794439935064967*G0_0_1_3_0 + 0.00223721590909099*G0_0_1_3_1 + 0.00373478084415598*G0_0_1_3_2 + 0.0110125811688316*G0_0_1_3_3 - 0.00328733766233776*G0_0_1_3_4 - 0.00304078733766244*G0_0_1_3_5 + 0.000657467532467572*G0_0_1_3_6 - 0.00172585227272734*G0_0_1_3_7 + 0.00172585227272735*G0_0_1_3_8 + 0.00295860389610402*G0_0_1_3_9 - 0.000164366883116891*G0_0_1_4_0 - 0.000858360389610422*G0_0_1_4_1 - 0.00599025974025998*G0_0_1_4_2 - 0.00328733766233776*G0_0_1_4_3 + 0.0134780844155849*G0_0_1_4_4 + 0.00115056818181823*G0_0_1_4_5 - 0.0018080357142858*G0_0_1_4_6 - 0.000493100649350664*G0_0_1_4_7 + 0.000986201298701325*G0_0_1_4_9 - 0.00292207792207801*G0_0_1_5_0 + 0.00101359577922081*G0_0_1_5_1 + 0.00366172889610405*G0_0_1_5_2 - 0.00304078733766244*G0_0_1_5_3 + 0.00115056818181823*G0_0_1_5_4 + 0.0241619318181826*G0_0_1_5_5 + 0.0120809659090913*G0_0_1_5_6 + 0.00254768668831178*G0_0_1_5_7 - 0.00238331980519488*G0_0_1_5_8 + 0.00591720779220798*G0_0_1_5_9 - 0.000949675324675366*G0_0_1_6_0 - 0.011131290584416*G0_0_1_6_2 + 0.000657467532467572*G0_0_1_6_3 - 0.00180803571428581*G0_0_1_6_4 + 0.0120809659090913*G0_0_1_6_5 - 0.000164366883116887*G0_0_1_6_7 - 0.000657467532467554*G0_0_1_6_8 + 0.00197240259740265*G0_0_1_6_9 - 0.00225547889610397*G0_0_1_7_0 + 0.000693993506493529*G0_0_1_7_1 + 0.000273944805194815*G0_0_1_7_2 - 0.00172585227272734*G0_0_1_7_3 - 0.000493100649350664*G0_0_1_7_4 + 0.00254768668831178*G0_0_1_7_5 - 0.000164366883116887*G0_0_1_7_6 + 0.0121631493506498*G0_0_1_7_7 + 0.00254768668831176*G0_0_1_7_8 + 0.00147930194805199*G0_0_1_7_9 + 0.000675730519480541*G0_0_1_8_0 - 0.00223721590909098*G0_0_1_8_1 + 0.000219155844155853*G0_0_1_8_2 + 0.00172585227272735*G0_0_1_8_3 - 0.00238331980519488*G0_0_1_8_5 - 0.000657467532467554*G0_0_1_8_6 + 0.00254768668831176*G0_0_1_8_7 - 0.0144642857142862*G0_0_1_8_8 - 0.000493100649350647*G0_0_1_8_9 - 0.00038352272727274*G0_0_1_9_0 + 0.000164366883116887*G0_0_1_9_1 - 0.00109577922077926*G0_0_1_9_2 + 0.00295860389610402*G0_0_1_9_3 + 0.000986201298701326*G0_0_1_9_4 + 0.00591720779220798*G0_0_1_9_5 + 0.00197240259740265*G0_0_1_9_6 + 0.00147930194805199*G0_0_1_9_7 - 0.000493100649350647*G0_0_1_9_8 - 0.0295860389610399*G0_0_1_9_9;
    A[37] = A[73] + 0.00447443181818191*G0_0_1_0_0 - 0.00276684253246765*G0_0_1_0_1 + 0.000292207792207794*G0_0_1_0_2 + 0.000657467532467555*G0_0_1_0_3 + 0.00213676948051957*G0_0_1_0_4 + 0.0039448051948053*G0_0_1_0_5 - 0.00271205357142865*G0_0_1_0_6 + 0.00550629058441574*G0_0_1_0_7 - 0.00238331980519488*G0_0_1_0_8 + 0.00591720779220799*G0_0_1_0_9 - 0.00276684253246765*G0_0_1_1_0 - 0.0734172077922102*G0_0_1_1_1 - 0.00386262175324688*G0_0_1_1_2 - 0.0456118100649366*G0_0_1_1_3 + 0.0167654220779226*G0_0_1_1_4 + 0.00262987012987022*G0_0_1_1_5 + 0.000164366883116889*G0_0_1_1_6 + 0.0142999188311694*G0_0_1_1_7 - 0.0283532873376634*G0_0_1_1_8 - 0.00641030844155869*G0_0_1_1_9 + 0.000292207792207794*G0_0_1_2_0 - 0.00386262175324688*G0_0_1_2_1 - 0.00138798701298709*G0_0_1_2_2 - 0.00608157467532487*G0_0_1_2_3 - 0.00139711850649358*G0_0_1_2_4 + 0.000986201298701346*G0_0_1_2_5 - 0.00098620129870136*G0_0_1_2_6 + 0.000164366883116894*G0_0_1_2_7 + 0.000657467532467548*G0_0_1_2_8 - 0.00345170454545467*G0_0_1_2_9 + 0.000657467532467555*G0_0_1_3_0 - 0.0456118100649366*G0_0_1_3_1 - 0.00608157467532487*G0_0_1_3_2 + 0.036242897727274*G0_0_1_3_4 - 0.00591720779220799*G0_0_1_3_5 + 0.00147930194805202*G0_0_1_3_6 + 0.019230925324676*G0_0_1_3_9 + 0.00213676948051957*G0_0_1_4_0 + 0.0167654220779226*G0_0_1_4_1 - 0.00139711850649358*G0_0_1_4_2 + 0.036242897727274*G0_0_1_4_3 + 0.041420454545456*G0_0_1_4_4 - 0.00443790584415599*G0_0_1_4_5 + 0.00295860389610399*G0_0_1_4_6 - 0.00443790584415602*G0_0_1_4_7 + 0.019230925324676*G0_0_1_4_9 + 0.0039448051948053*G0_0_1_5_0 + 0.00262987012987022*G0_0_1_5_1 + 0.000986201298701346*G0_0_1_5_2 - 0.00591720779220799*G0_0_1_5_3 - 0.00443790584415599*G0_0_1_5_4 + 0.0207102272727279*G0_0_1_5_5 - 0.00147930194805198*G0_0_1_5_6 + 0.00443790584415599*G0_0_1_5_7 - 0.00591720779220799*G0_0_1_5_8 - 0.00591720779220796*G0_0_1_5_9 - 0.00271205357142865*G0_0_1_6_0 + 0.000164366883116889*G0_0_1_6_1 - 0.00098620129870136*G0_0_1_6_2 + 0.00147930194805202*G0_0_1_6_3 + 0.00295860389610399*G0_0_1_6_4 - 0.00147930194805198*G0_0_1_6_5 + 0.00295860389610389*G0_0_1_6_6 + 0.001479301948052*G0_0_1_6_7 - 0.002218952922078*G0_0_1_6_8 + 0.00739650974025997*G0_0_1_6_9 + 0.00550629058441574*G0_0_1_7_0 + 0.0142999188311694*G0_0_1_7_1 + 0.000164366883116894*G0_0_1_7_2 - 0.00443790584415602*G0_0_1_7_4 + 0.00443790584415599*G0_0_1_7_5 + 0.001479301948052*G0_0_1_7_6 - 0.000739650974025898*G0_0_1_7_8 - 0.020710227272728*G0_0_1_7_9 - 0.00238331980519488*G0_0_1_8_0 - 0.0283532873376634*G0_0_1_8_1 + 0.00065746753246755*G0_0_1_8_2 - 0.00591720779220799*G0_0_1_8_5 - 0.002218952922078*G0_0_1_8_6 - 0.000739650974025896*G0_0_1_8_7 + 0.0739650974025999*G0_0_1_8_8 + 0.019230925324676*G0_0_1_8_9 + 0.00591720779220799*G0_0_1_9_0 - 0.00641030844155869*G0_0_1_9_1 - 0.00345170454545467*G0_0_1_9_2 + 0.019230925324676*G0_0_1_9_3 + 0.019230925324676*G0_0_1_9_4 - 0.00591720779220796*G0_0_1_9_5 + 0.00739650974025997*G0_0_1_9_6 - 0.0207102272727279*G0_0_1_9_7 + 0.019230925324676*G0_0_1_9_8 - 0.0887581168831197*G0_0_1_9_9 - 0.00447443181818191*G0_1_0_0_0 + 0.00276684253246765*G0_1_0_0_1 - 0.000292207792207794*G0_1_0_0_2 - 0.000657467532467555*G0_1_0_0_3 - 0.00213676948051957*G0_1_0_0_4 - 0.0039448051948053*G0_1_0_0_5 + 0.00271205357142865*G0_1_0_0_6 - 0.00550629058441574*G0_1_0_0_7 + 0.00238331980519488*G0_1_0_0_8 - 0.00591720779220799*G0_1_0_0_9 + 0.00276684253246765*G0_1_0_1_0 + 0.0734172077922102*G0_1_0_1_1 + 0.00386262175324688*G0_1_0_1_2 + 0.0456118100649365*G0_1_0_1_3 - 0.0167654220779226*G0_1_0_1_4 - 0.00262987012987022*G0_1_0_1_5 - 0.000164366883116889*G0_1_0_1_6 - 0.0142999188311694*G0_1_0_1_7 + 0.0283532873376634*G0_1_0_1_8 + 0.00641030844155869*G0_1_0_1_9 - 0.000292207792207794*G0_1_0_2_0 + 0.00386262175324688*G0_1_0_2_1 + 0.00138798701298709*G0_1_0_2_2 + 0.00608157467532487*G0_1_0_2_3 + 0.00139711850649358*G0_1_0_2_4 - 0.000986201298701346*G0_1_0_2_5 + 0.00098620129870136*G0_1_0_2_6 - 0.000164366883116893*G0_1_0_2_7 - 0.000657467532467549*G0_1_0_2_8 + 0.00345170454545467*G0_1_0_2_9 - 0.000657467532467555*G0_1_0_3_0 + 0.0456118100649366*G0_1_0_3_1 + 0.00608157467532487*G0_1_0_3_2 - 0.036242897727274*G0_1_0_3_4 + 0.00591720779220799*G0_1_0_3_5 - 0.00147930194805202*G0_1_0_3_6 - 0.019230925324676*G0_1_0_3_9 - 0.00213676948051957*G0_1_0_4_0 - 0.0167654220779226*G0_1_0_4_1 + 0.00139711850649358*G0_1_0_4_2 - 0.036242897727274*G0_1_0_4_3 - 0.041420454545456*G0_1_0_4_4 + 0.00443790584415599*G0_1_0_4_5 - 0.00295860389610399*G0_1_0_4_6 + 0.00443790584415602*G0_1_0_4_7 - 0.019230925324676*G0_1_0_4_9 - 0.0039448051948053*G0_1_0_5_0 - 0.00262987012987022*G0_1_0_5_1 - 0.000986201298701346*G0_1_0_5_2 + 0.00591720779220799*G0_1_0_5_3 + 0.00443790584415599*G0_1_0_5_4 - 0.0207102272727279*G0_1_0_5_5 + 0.00147930194805198*G0_1_0_5_6 - 0.00443790584415599*G0_1_0_5_7 + 0.00591720779220799*G0_1_0_5_8 + 0.00591720779220796*G0_1_0_5_9 + 0.00271205357142865*G0_1_0_6_0 - 0.000164366883116888*G0_1_0_6_1 + 0.00098620129870136*G0_1_0_6_2 - 0.00147930194805202*G0_1_0_6_3 - 0.00295860389610399*G0_1_0_6_4 + 0.00147930194805198*G0_1_0_6_5 - 0.00295860389610389*G0_1_0_6_6 - 0.001479301948052*G0_1_0_6_7 + 0.002218952922078*G0_1_0_6_8 - 0.00739650974025998*G0_1_0_6_9 - 0.00550629058441574*G0_1_0_7_0 - 0.0142999188311694*G0_1_0_7_1 - 0.000164366883116894*G0_1_0_7_2 + 0.00443790584415602*G0_1_0_7_4 - 0.00443790584415599*G0_1_0_7_5 - 0.001479301948052*G0_1_0_7_6 + 0.0007396509740259*G0_1_0_7_8 + 0.020710227272728*G0_1_0_7_9 + 0.00238331980519488*G0_1_0_8_0 + 0.0283532873376634*G0_1_0_8_1 - 0.000657467532467551*G0_1_0_8_2 + 0.00591720779220799*G0_1_0_8_5 + 0.002218952922078*G0_1_0_8_6 + 0.0007396509740259*G0_1_0_8_7 - 0.0739650974025999*G0_1_0_8_8 - 0.019230925324676*G0_1_0_8_9 - 0.00591720779220799*G0_1_0_9_0 + 0.00641030844155869*G0_1_0_9_1 + 0.00345170454545467*G0_1_0_9_2 - 0.019230925324676*G0_1_0_9_3 - 0.019230925324676*G0_1_0_9_4 + 0.00591720779220796*G0_1_0_9_5 - 0.00739650974025998*G0_1_0_9_6 + 0.0207102272727279*G0_1_0_9_7 - 0.019230925324676*G0_1_0_9_8 + 0.0887581168831197*G0_1_0_9_9;
    A[11] = 0.0028909632034633*G0_0_0_0_0 + 0.00448626893939412*G0_0_0_0_1 + 0.000851934523809556*G0_0_0_0_2 + 0.00503145292207812*G0_0_0_0_3 - 0.0019267451298702*G0_0_0_0_4 + 0.00104707792207795*G0_0_0_0_5 - 0.000675730519480538*G0_0_0_0_6 - 0.00264204545454556*G0_0_0_0_7 + 0.0067025162337665*G0_0_0_0_8 + 0.00224025974025983*G0_0_0_0_9 + 0.00448626893939412*G0_0_0_1_0 + 0.0703057359307383*G0_0_0_1_1 + 0.00448626893939409*G0_0_0_1_2 + 0.0427049512987028*G0_0_0_1_3 - 0.0194500811688318*G0_0_0_1_4 - 0.000776176948051977*G0_0_0_1_5 - 0.000776176948051973*G0_0_0_1_6 - 0.0194500811688319*G0_0_0_1_7 + 0.0427049512987029*G0_0_0_1_8 + 0.00760957792207822*G0_0_0_1_9 + 0.000851934523809556*G0_0_0_2_0 + 0.00448626893939409*G0_0_0_2_1 + 0.00289096320346331*G0_0_0_2_2 + 0.00670251623376646*G0_0_0_2_3 - 0.00264204545454554*G0_0_0_2_4 - 0.000675730519480547*G0_0_0_2_5 + 0.00104707792207797*G0_0_0_2_6 - 0.0019267451298702*G0_0_0_2_7 + 0.0050314529220781*G0_0_0_2_8 + 0.00224025974025982*G0_0_0_2_9 + 0.00503145292207812*G0_0_0_3_0 + 0.0427049512987028*G0_0_0_3_1 + 0.00670251623376646*G0_0_0_3_2 + 0.0845576298701329*G0_0_0_3_3 - 0.0325537743506505*G0_0_0_3_4 - 0.00336038961038973*G0_0_0_3_5 - 0.00371651785714299*G0_0_0_3_6 - 0.0211394074675333*G0_0_0_3_7 + 0.0422788149350665*G0_0_0_3_8 + 0.0194500811688319*G0_0_0_3_9 - 0.0019267451298702*G0_0_0_4_0 - 0.0194500811688318*G0_0_0_4_1 - 0.00264204545454554*G0_0_0_4_2 - 0.0325537743506505*G0_0_0_4_3 + 0.0184821428571435*G0_0_0_4_4 - 0.000264813311688324*G0_0_0_4_5 + 0.00398133116883131*G0_0_0_4_6 + 0.00880275974026006*G0_0_0_4_7 - 0.0211394074675332*G0_0_0_4_8 - 0.00619115259740284*G0_0_0_4_9 + 0.00104707792207795*G0_0_0_5_0 - 0.000776176948051977*G0_0_0_5_1 - 0.000675730519480547*G0_0_0_5_2 - 0.00336038961038973*G0_0_0_5_3 - 0.000264813311688324*G0_0_0_5_4 + 0.013222402597403*G0_0_0_5_5 - 0.00280336850649361*G0_0_0_5_6 + 0.0039813311688313*G0_0_0_5_7 - 0.00371651785714299*G0_0_0_5_8 + 0.000712256493506513*G0_0_0_5_9 - 0.000675730519480538*G0_0_0_6_0 - 0.000776176948051973*G0_0_0_6_1 + 0.00104707792207797*G0_0_0_6_2 - 0.00371651785714299*G0_0_0_6_3 + 0.00398133116883131*G0_0_0_6_4 - 0.00280336850649361*G0_0_0_6_5 + 0.0132224025974031*G0_0_0_6_6 - 0.000264813311688318*G0_0_0_6_7 - 0.00336038961038972*G0_0_0_6_8 + 0.000712256493506514*G0_0_0_6_9 - 0.00264204545454556*G0_0_0_7_0 - 0.0194500811688319*G0_0_0_7_1 - 0.0019267451298702*G0_0_0_7_2 - 0.0211394074675333*G0_0_0_7_3 + 0.00880275974026006*G0_0_0_7_4 + 0.0039813311688313*G0_0_0_7_5 - 0.000264813311688318*G0_0_0_7_6 + 0.0184821428571436*G0_0_0_7_7 - 0.0325537743506506*G0_0_0_7_8 - 0.00619115259740283*G0_0_0_7_9 + 0.0067025162337665*G0_0_0_8_0 + 0.0427049512987029*G0_0_0_8_1 + 0.0050314529220781*G0_0_0_8_2 + 0.0422788149350665*G0_0_0_8_3 - 0.0211394074675332*G0_0_0_8_4 - 0.00371651785714299*G0_0_0_8_5 - 0.00336038961038972*G0_0_0_8_6 - 0.0325537743506506*G0_0_0_8_7 + 0.084557629870133*G0_0_0_8_8 + 0.0194500811688319*G0_0_0_8_9 + 0.00224025974025983*G0_0_0_9_0 + 0.00760957792207822*G0_0_0_9_1 + 0.00224025974025982*G0_0_0_9_2 + 0.0194500811688319*G0_0_0_9_3 - 0.00619115259740284*G0_0_0_9_4 + 0.000712256493506514*G0_0_0_9_5 + 0.000712256493506514*G0_0_0_9_6 - 0.00619115259740283*G0_0_0_9_7 + 0.0194500811688319*G0_0_0_9_8 + 0.0282711038961049*G0_0_0_9_9;
    A[82] = -0.00697646103896126*G0_0_1_0_0 - 0.00109882305194809*G0_0_1_0_1 - 0.0004474431818182*G0_0_1_0_2 - 0.000164366883116884*G0_0_1_0_3 + 0.00079443993506496*G0_0_1_0_4 - 0.00225547889610396*G0_0_1_0_5 + 0.00067573051948053*G0_0_1_0_6 - 0.00292207792207801*G0_0_1_0_7 - 0.000949675324675361*G0_0_1_0_8 - 0.00038352272727274*G0_0_1_0_9 - 0.00109882305194809*G0_0_1_1_0 - 0.0164671266233772*G0_0_1_1_1 - 0.000566152597402618*G0_0_1_1_2 - 0.00599025974025992*G0_0_1_1_3 + 0.00373478084415596*G0_0_1_1_4 + 0.000273944805194816*G0_0_1_1_5 + 0.000219155844155845*G0_0_1_1_6 + 0.00366172889610403*G0_0_1_1_7 - 0.011131290584416*G0_0_1_1_8 - 0.00109577922077926*G0_0_1_1_9 - 0.0004474431818182*G0_0_1_2_0 - 0.000566152597402618*G0_0_1_2_1 - 0.000858360389610404*G0_0_1_2_3 + 0.00223721590909096*G0_0_1_2_4 + 0.000693993506493547*G0_0_1_2_5 - 0.00223721590909102*G0_0_1_2_6 + 0.00101359577922081*G0_0_1_2_7 + 0.000164366883116883*G0_0_1_2_9 - 0.000164366883116884*G0_0_1_3_0 - 0.00599025974025992*G0_0_1_3_1 - 0.000858360389610404*G0_0_1_3_2 + 0.0134780844155849*G0_0_1_3_3 - 0.00328733766233776*G0_0_1_3_4 - 0.00049310064935067*G0_0_1_3_5 + 0.00115056818181821*G0_0_1_3_7 - 0.00180803571428578*G0_0_1_3_8 + 0.000986201298701347*G0_0_1_3_9 + 0.00079443993506496*G0_0_1_4_0 + 0.00373478084415596*G0_0_1_4_1 + 0.00223721590909096*G0_0_1_4_2 - 0.00328733766233776*G0_0_1_4_3 + 0.0110125811688315*G0_0_1_4_4 - 0.00172585227272732*G0_0_1_4_5 + 0.00172585227272731*G0_0_1_4_6 - 0.00304078733766244*G0_0_1_4_7 + 0.000657467532467557*G0_0_1_4_8 + 0.00295860389610399*G0_0_1_4_9 - 0.00225547889610396*G0_0_1_5_0 + 0.000273944805194816*G0_0_1_5_1 + 0.000693993506493547*G0_0_1_5_2 - 0.00049310064935067*G0_0_1_5_3 - 0.00172585227272732*G0_0_1_5_4 + 0.0121631493506497*G0_0_1_5_5 + 0.0025476866883118*G0_0_1_5_6 + 0.00254768668831177*G0_0_1_5_7 - 0.000164366883116892*G0_0_1_5_8 + 0.001479301948052*G0_0_1_5_9 + 0.00067573051948053*G0_0_1_6_0 + 0.000219155844155845*G0_0_1_6_1 - 0.00223721590909102*G0_0_1_6_2 + 0.00172585227272731*G0_0_1_6_4 + 0.0025476866883118*G0_0_1_6_5 - 0.0144642857142863*G0_0_1_6_6 - 0.00238331980519488*G0_0_1_6_7 - 0.000657467532467551*G0_0_1_6_8 - 0.000493100649350675*G0_0_1_6_9 - 0.00292207792207801*G0_0_1_7_0 + 0.00366172889610403*G0_0_1_7_1 + 0.00101359577922081*G0_0_1_7_2 + 0.00115056818181821*G0_0_1_7_3 - 0.00304078733766244*G0_0_1_7_4 + 0.00254768668831178*G0_0_1_7_5 - 0.00238331980519488*G0_0_1_7_6 + 0.0241619318181827*G0_0_1_7_7 + 0.0120809659090913*G0_0_1_7_8 + 0.00591720779220799*G0_0_1_7_9 - 0.000949675324675361*G0_0_1_8_0 - 0.011131290584416*G0_0_1_8_1 - 0.00180803571428578*G0_0_1_8_3 + 0.000657467532467556*G0_0_1_8_4 - 0.000164366883116892*G0_0_1_8_5 - 0.000657467532467551*G0_0_1_8_6 + 0.0120809659090913*G0_0_1_8_7 + 0.00197240259740266*G0_0_1_8_9 - 0.00038352272727274*G0_0_1_9_0 - 0.00109577922077926*G0_0_1_9_1 + 0.000164366883116883*G0_0_1_9_2 + 0.000986201298701347*G0_0_1_9_3 + 0.00295860389610399*G0_0_1_9_4 + 0.001479301948052*G0_0_1_9_5 - 0.000493100649350675*G0_0_1_9_6 + 0.00591720779220799*G0_0_1_9_7 + 0.00197240259740266*G0_0_1_9_8 - 0.02958603896104*G0_0_1_9_9 + 0.000420048701298708*G0_1_1_0_0 - 0.00137581168831174*G0_1_1_0_1 + 0.000210024350649355*G0_1_1_0_2 + 0.000127840909090916*G0_1_1_0_3 + 0.00100446428571432*G0_1_1_0_4 - 6.39204545454591e-05*G0_1_1_0_5 + 0.000566152597402615*G0_1_1_0_6 + 0.00173498376623382*G0_1_1_0_7 - 0.00253855519480529*G0_1_1_0_8 + 0.00158887987012993*G0_1_1_0_9 - 0.00137581168831174*G0_1_1_1_0 - 0.0195413961038968*G0_1_1_1_1 - 0.000517451298701316*G0_1_1_1_2 - 0.00808137175324702*G0_1_1_1_3 + 0.00465706168831184*G0_1_1_1_4 - 6.39204545454578e-05*G0_1_1_1_5 + 0.000922280844155873*G0_1_1_1_6 + 0.00712256493506519*G0_1_1_1_7 - 0.0154778814935071*G0_1_1_1_8 - 0.00246550324675334*G0_1_1_1_9 + 0.000210024350649355*G0_1_1_2_0 - 0.000517451298701316*G0_1_1_2_1 + 0.0027394480519481*G0_1_1_2_2 - 0.00171672077922083*G0_1_1_2_3 + 0.00378956980519492*G0_1_1_2_4 - 0.00107751623376626*G0_1_1_2_5 + 0.00223721590909095*G0_1_1_2_6 + 0.00026481331168832*G0_1_1_2_7 - 0.00184456168831175*G0_1_1_2_8 + 0.00060267857142859*G0_1_1_2_9 + 0.000127840909090916*G0_1_1_3_0 - 0.00808137175324702*G0_1_1_3_1 - 0.00171672077922083*G0_1_1_3_2 + 0.0202171266233774*G0_1_1_3_3 - 0.00394480519480534*G0_1_1_3_4 - 0.000164366883116891*G0_1_1_3_5 - 0.00262987012987021*G0_1_1_3_6 - 0.000246550324675338*G0_1_1_3_7 - 0.00542410714285731*G0_1_1_3_8 + 0.00788961038961068*G0_1_1_3_9 + 0.00100446428571432*G0_1_1_4_0 + 0.00465706168831184*G0_1_1_4_1 + 0.00378956980519492*G0_1_1_4_2 - 0.00394480519480534*G0_1_1_4_3 + 0.0113413149350654*G0_1_1_4_4 - 0.00287642045454555*G0_1_1_4_5 + 0.00550629058441576*G0_1_1_4_6 - 0.00197240259740266*G0_1_1_4_7 + 0.00567065746753265*G0_1_1_4_8 + 0.00394480519480533*G0_1_1_4_9 - 6.39204545454591e-05*G0_1_1_5_0 - 6.39204545454577e-05*G0_1_1_5_1 - 0.00107751623376626*G0_1_1_5_2 - 0.000164366883116892*G0_1_1_5_3 - 0.00287642045454555*G0_1_1_5_4 - 0.000164366883116907*G0_1_1_5_5 - 0.00287642045454553*G0_1_1_5_6 + 0.000328733766233771*G0_1_1_5_7 + 0.00032873376623378*G0_1_1_5_8 - 0.00542410714285733*G0_1_1_5_9 + 0.000566152597402616*G0_1_1_6_0 + 0.000922280844155873*G0_1_1_6_1 + 0.00223721590909095*G0_1_1_6_2 - 0.00262987012987021*G0_1_1_6_3 + 0.00550629058441576*G0_1_1_6_4 - 0.00287642045454553*G0_1_1_6_5 + 0.00723214285714303*G0_1_1_6_6 - 0.000657467532467549*G0_1_1_6_7 + 0.0013149350649351*G0_1_1_6_8 + 0.00345170454545465*G0_1_1_6_9 + 0.00173498376623382*G0_1_1_7_0 + 0.00712256493506519*G0_1_1_7_1 + 0.00026481331168832*G0_1_1_7_2 - 0.000246550324675337*G0_1_1_7_3 - 0.00197240259740266*G0_1_1_7_4 + 0.000328733766233771*G0_1_1_7_5 - 0.00065746753246755*G0_1_1_7_6 - 0.00345170454545469*G0_1_1_7_7 + 0.00936891233766267*G0_1_1_7_8 - 0.00345170454545467*G0_1_1_7_9 - 0.00253855519480529*G0_1_1_8_0 - 0.0154778814935071*G0_1_1_8_1 - 0.00184456168831175*G0_1_1_8_2 - 0.00542410714285731*G0_1_1_8_3 + 0.00567065746753265*G0_1_1_8_4 + 0.00032873376623378*G0_1_1_8_5 + 0.0013149350649351*G0_1_1_8_6 + 0.00936891233766267*G0_1_1_8_7 - 0.0537479707792226*G0_1_1_8_8 - 0.00394480519480531*G0_1_1_8_9 + 0.00158887987012993*G0_1_1_9_0 - 0.00246550324675333*G0_1_1_9_1 + 0.00060267857142859*G0_1_1_9_2 + 0.00788961038961068*G0_1_1_9_3 + 0.00394480519480533*G0_1_1_9_4 - 0.00542410714285733*G0_1_1_9_5 + 0.00345170454545465*G0_1_1_9_6 - 0.00345170454545467*G0_1_1_9_7 - 0.00394480519480531*G0_1_1_9_8 + 0.00986201298701335*G0_1_1_9_9;
    A[32] = -A[82] - 0.00787134740259767*G0_0_1_0_0 - 0.00106534090909095*G0_0_1_0_1 - 0.00393567370129886*G0_0_1_0_2 - 0.00111404220779224*G0_0_1_0_3 - 0.000757913961038997*G0_0_1_0_4 + 0.000173498376623403*G0_0_1_0_5 - 0.00544237012987035*G0_0_1_0_6 - 0.00241984577922085*G0_0_1_0_7 - 0.00124188311688316*G0_0_1_0_8 - 0.00378043831168845*G0_0_1_0_9 - 0.00106534090909095*G0_0_1_1_0 - 0.0154017857142862*G0_0_1_1_1 - 0.0030742694805196*G0_0_1_1_2 - 0.00246550324675332*G0_0_1_1_3 + 0.00167106331168835*G0_0_1_1_4 + 0.00146103896103902*G0_0_1_1_5 - 0.00346996753246767*G0_0_1_1_6 + 0.00249289772727282*G0_0_1_1_7 - 0.0090401785714289*G0_0_1_1_8 + 0.000767045454545471*G0_0_1_1_9 - 0.00393567370129886*G0_0_1_2_0 - 0.0030742694805196*G0_0_1_2_1 - 0.0525974025974044*G0_0_1_2_2 + 0.0100994318181822*G0_0_1_2_3 - 0.0196783685064942*G0_0_1_2_4 + 0.0165827922077928*G0_0_1_2_5 - 0.0389458198051962*G0_0_1_2_6 + 0.00170758928571434*G0_0_1_2_7 + 0.000858360389610415*G0_0_1_2_8 - 0.00476663961038978*G0_0_1_2_9 - 0.00111404220779224*G0_0_1_3_0 - 0.00246550324675331*G0_0_1_3_1 + 0.0100994318181822*G0_0_1_3_2 - 0.0259699675324684*G0_0_1_3_3 + 0.00460227272727291*G0_0_1_3_4 - 0.00246550324675334*G0_0_1_3_5 + 0.0142999188311693*G0_0_1_3_6 + 0.00723214285714309*G0_0_1_3_7 - 0.00854707792207822*G0_0_1_3_8 - 0.0167654220779226*G0_0_1_3_9 - 0.000757913961038997*G0_0_1_4_0 + 0.00167106331168835*G0_0_1_4_1 - 0.0196783685064942*G0_0_1_4_2 + 0.00460227272727291*G0_0_1_4_3 + 0.0134780844155848*G0_0_1_4_4 + 0.00616375811688336*G0_0_1_4_5 - 0.0204636769480527*G0_0_1_4_6 - 0.00336952110389622*G0_0_1_4_7 + 0.00131493506493511*G0_0_1_4_8 + 0.00197240259740266*G0_0_1_4_9 + 0.000173498376623402*G0_0_1_5_0 + 0.00146103896103902*G0_0_1_5_1 + 0.0165827922077928*G0_0_1_5_2 - 0.00246550324675334*G0_0_1_5_3 + 0.00616375811688336*G0_0_1_5_4 + 0.0082183441558444*G0_0_1_5_5 + 0.0316406250000011*G0_0_1_5_6 + 0.00172585227272733*G0_0_1_5_7 - 0.00049310064935067*G0_0_1_5_8 + 0.0123275162337667*G0_0_1_5_9 - 0.00544237012987035*G0_0_1_6_0 - 0.00346996753246767*G0_0_1_6_1 - 0.0389458198051962*G0_0_1_6_2 + 0.0142999188311693*G0_0_1_6_3 - 0.0204636769480527*G0_0_1_6_4 + 0.0316406250000011*G0_0_1_6_5 - 0.10568790584416*G0_0_1_6_6 - 0.00123275162337667*G0_0_1_6_7 + 0.00197240259740267*G0_0_1_6_8 - 0.0142999188311693*G0_0_1_6_9 - 0.00241984577922085*G0_0_1_7_0 + 0.00249289772727282*G0_0_1_7_1 + 0.00170758928571434*G0_0_1_7_2 + 0.00723214285714309*G0_0_1_7_3 - 0.00336952110389622*G0_0_1_7_4 + 0.00172585227272733*G0_0_1_7_5 - 0.00123275162337667*G0_0_1_7_6 + 0.0238331980519489*G0_0_1_7_7 + 0.0134780844155849*G0_0_1_7_8 + 0.0138068181818186*G0_0_1_7_9 - 0.00124188311688316*G0_0_1_8_0 - 0.0090401785714289*G0_0_1_8_1 + 0.000858360389610415*G0_0_1_8_2 - 0.00854707792207822*G0_0_1_8_3 + 0.00131493506493511*G0_0_1_8_4 - 0.00049310064935067*G0_0_1_8_5 + 0.00197240259740267*G0_0_1_8_6 + 0.0134780844155849*G0_0_1_8_7 + 0.00361607142857154*G0_0_1_8_8 - 0.00493100649350667*G0_0_1_8_9 - 0.00378043831168845*G0_0_1_9_0 + 0.000767045454545471*G0_0_1_9_1 - 0.00476663961038978*G0_0_1_9_2 - 0.0167654220779226*G0_0_1_9_3 + 0.00197240259740266*G0_0_1_9_4 + 0.0123275162337667*G0_0_1_9_5 - 0.0142999188311693*G0_0_1_9_6 + 0.0138068181818186*G0_0_1_9_7 - 0.00493100649350667*G0_0_1_9_8 - 0.0867857142857172*G0_0_1_9_9;
    A[45] = A[73] + 0.00648336038961069*G0_0_0_0_0 + 0.000237418831168842*G0_0_0_0_1 + 0.00492187500000021*G0_0_0_0_2 - 0.00813616071428603*G0_0_0_0_3 + 0.00813616071428603*G0_0_0_0_4 + 0.00854707792207824*G0_0_0_0_5 + 0.000410917207792207*G0_0_0_0_6 + 0.00172585227272737*G0_0_0_0_7 - 0.00271205357142869*G0_0_0_0_8 + 0.00147930194805201*G0_0_0_0_9 + 0.000237418831168842*G0_0_0_1_0 - 0.0121631493506497*G0_0_0_1_1 + 0.00458400974025992*G0_0_0_1_2 - 0.0243262987012995*G0_0_0_1_3 + 0.0225182629870138*G0_0_0_1_4 + 0.000493100649350663*G0_0_0_1_5 - 0.000986201298701323*G0_0_0_1_6 + 0.00410917207792223*G0_0_0_1_7 - 0.00969764610389646*G0_0_0_1_8 - 0.008875811688312*G0_0_0_1_9 + 0.00492187500000021*G0_0_0_2_0 + 0.00458400974025992*G0_0_0_2_1 + 0.0917715097402629*G0_0_0_2_2 - 0.0335308441558453*G0_0_0_2_3 + 0.0714995941558467*G0_0_0_2_4 - 0.0142999188311694*G0_0_0_2_5 + 0.0394480519480535*G0_0_0_2_6 + 0.00197240259740267*G0_0_0_2_7 - 0.000246550324675346*G0_0_0_2_8 + 0.020710227272728*G0_0_0_2_9 - 0.00813616071428603*G0_0_0_3_0 - 0.0243262987012995*G0_0_0_3_1 - 0.0335308441558453*G0_0_0_3_2 - 0.150888798701304*G0_0_0_3_3 - 0.04437905844156*G0_0_0_3_4 + 0.01479301948052*G0_0_0_3_5 - 0.00369825487013006*G0_0_0_3_6 + 0.017751623376624*G0_0_0_3_7 - 0.0118344155844161*G0_0_0_3_8 - 0.00887581168831213*G0_0_0_3_9 + 0.00813616071428603*G0_0_0_4_0 + 0.0225182629870138*G0_0_0_4_1 + 0.0714995941558467*G0_0_0_4_2 - 0.04437905844156*G0_0_0_4_3 + 0.164202516233772*G0_0_0_4_4 - 0.031065340909092*G0_0_0_4_5 + 0.0347635957792221*G0_0_0_4_6 - 0.011834415584416*G0_0_0_4_7 - 0.00591720779220795*G0_0_0_4_8 + 0.00854707792207824*G0_0_0_5_0 + 0.000493100649350664*G0_0_0_5_1 - 0.0142999188311694*G0_0_0_5_2 + 0.01479301948052*G0_0_0_5_3 - 0.031065340909092*G0_0_0_5_4 + 0.069527191558444*G0_0_0_5_5 - 0.036242897727274*G0_0_0_5_6 + 0.020710227272728*G0_0_0_5_7 - 0.00813616071428602*G0_0_0_5_8 + 0.011834415584416*G0_0_0_5_9 + 0.000410917207792207*G0_0_0_6_0 - 0.000986201298701324*G0_0_0_6_1 + 0.0394480519480535*G0_0_0_6_2 - 0.00369825487013006*G0_0_0_6_3 + 0.0347635957792221*G0_0_0_6_4 - 0.036242897727274*G0_0_0_6_5 - 0.0710064935064956*G0_0_0_6_6 - 0.012574066558442*G0_0_0_6_7 + 0.005177556818182*G0_0_0_6_8 - 0.0547341720779239*G0_0_0_6_9 + 0.00172585227272737*G0_0_0_7_0 + 0.00410917207792223*G0_0_0_7_1 + 0.00197240259740267*G0_0_0_7_2 + 0.017751623376624*G0_0_0_7_3 - 0.011834415584416*G0_0_0_7_4 + 0.020710227272728*G0_0_0_7_5 - 0.012574066558442*G0_0_0_7_6 + 0.02218952922078*G0_0_0_7_7 - 0.00147930194805199*G0_0_0_7_8 + 0.020710227272728*G0_0_0_7_9 - 0.00271205357142869*G0_0_0_8_0 - 0.00969764610389646*G0_0_0_8_1 - 0.000246550324675346*G0_0_0_8_2 - 0.0118344155844161*G0_0_0_8_3 - 0.00591720779220795*G0_0_0_8_4 - 0.00813616071428602*G0_0_0_8_5 + 0.005177556818182*G0_0_0_8_6 - 0.00147930194805199*G0_0_0_8_7 + 0.0325446428571439*G0_0_0_8_8 + 0.0384618506493519*G0_0_0_8_9 + 0.00147930194805201*G0_0_0_9_0 - 0.008875811688312*G0_0_0_9_1 + 0.020710227272728*G0_0_0_9_2 - 0.00887581168831213*G0_0_0_9_3 + 0.011834415584416*G0_0_0_9_5 - 0.0547341720779239*G0_0_0_9_6 + 0.020710227272728*G0_0_0_9_7 + 0.0384618506493519*G0_0_0_9_8 + 0.142012987012992*G0_0_0_9_9 - 0.0034425730519482*G0_0_1_0_1 + 0.00344257305194819*G0_0_1_0_2 - 0.00838271103896137*G0_0_1_0_3 + 0.00838271103896138*G0_0_1_0_4 - 0.00106838474025985*G0_0_1_0_5 + 0.00262987012987025*G0_0_1_0_6 + 0.0010683847402597*G0_0_1_0_7 - 0.0026298701298702*G0_0_1_0_8 - 0.0034425730519482*G0_0_1_1_0 - 0.0868222402597431*G0_0_1_1_1 - 0.0688697240259763*G0_0_1_1_3 + 0.0386262175324688*G0_0_1_1_4 - 0.000493100649350679*G0_0_1_1_5 - 0.000986201298701315*G0_0_1_1_6 + 0.016272321428572*G0_0_1_1_7 - 0.0372290990259754*G0_0_1_1_8 - 0.0167654220779227*G0_0_1_1_9 + 0.00344257305194819*G0_0_1_2_0 + 0.0868222402597433*G0_0_1_2_2 - 0.0386262175324689*G0_0_1_2_3 + 0.0688697240259765*G0_0_1_2_4 - 0.0162723214285721*G0_0_1_2_5 + 0.0372290990259754*G0_0_1_2_6 + 0.000493100649350664*G0_0_1_2_7 + 0.000986201298701318*G0_0_1_2_8 + 0.0167654220779226*G0_0_1_2_9 - 0.00838271103896137*G0_0_1_3_0 - 0.0688697240259763*G0_0_1_3_1 - 0.0386262175324689*G0_0_1_3_2 - 0.174557629870136*G0_0_1_3_3 + 0.013313717532468*G0_0_1_3_5 + 0.00295860389610393*G0_0_1_3_6 + 0.0251481331168841*G0_0_1_3_7 - 0.0221895292207802*G0_0_1_3_8 + 0.00838271103896138*G0_0_1_4_0 + 0.0386262175324688*G0_0_1_4_1 + 0.0688697240259765*G0_0_1_4_2 + 0.174557629870136*G0_0_1_4_4 - 0.025148133116884*G0_0_1_4_5 + 0.0221895292207802*G0_0_1_4_6 - 0.013313717532468*G0_0_1_4_7 - 0.00295860389610393*G0_0_1_4_8 - 0.00106838474025985*G0_0_1_5_0 - 0.000493100649350679*G0_0_1_5_1 - 0.0162723214285721*G0_0_1_5_2 + 0.013313717532468*G0_0_1_5_3 - 0.025148133116884*G0_0_1_5_4 - 0.00295860389610399*G0_0_1_5_5 - 0.01109476461039*G0_0_1_5_6 + 0.00147930194805203*G0_0_1_5_8 - 0.00295860389610401*G0_0_1_5_9 + 0.00262987012987025*G0_0_1_6_0 - 0.000986201298701315*G0_0_1_6_1 + 0.0372290990259754*G0_0_1_6_2 + 0.00295860389610393*G0_0_1_6_3 + 0.0221895292207802*G0_0_1_6_4 - 0.01109476461039*G0_0_1_6_5 - 0.0946753246753277*G0_0_1_6_6 - 0.00147930194805199*G0_0_1_6_7 - 0.0562134740259758*G0_0_1_6_9 + 0.0010683847402597*G0_0_1_7_0 + 0.016272321428572*G0_0_1_7_1 + 0.000493100649350664*G0_0_1_7_2 + 0.0251481331168841*G0_0_1_7_3 - 0.013313717532468*G0_0_1_7_4 - 0.00147930194805199*G0_0_1_7_6 + 0.00295860389610376*G0_0_1_7_7 + 0.0110947646103902*G0_0_1_7_8 + 0.00295860389610402*G0_0_1_7_9 - 0.0026298701298702*G0_0_1_8_0 - 0.0372290990259754*G0_0_1_8_1 + 0.000986201298701319*G0_0_1_8_2 - 0.0221895292207802*G0_0_1_8_3 - 0.00295860389610394*G0_0_1_8_4 + 0.00147930194805203*G0_0_1_8_5 + 0.0110947646103902*G0_0_1_8_7 + 0.0946753246753278*G0_0_1_8_8 + 0.0562134740259759*G0_0_1_8_9 - 0.0167654220779227*G0_0_1_9_1 + 0.0167654220779226*G0_0_1_9_2 - 0.00295860389610401*G0_0_1_9_5 - 0.0562134740259758*G0_0_1_9_6 + 0.00295860389610402*G0_0_1_9_7 + 0.0562134740259759*G0_0_1_9_8 - 0.000383522727272742*G0_1_0_0_1 + 0.000383522727272753*G0_1_0_0_2 - 0.00690340909090935*G0_1_0_0_3 + 0.00690340909090936*G0_1_0_0_4 + 0.000493100649350664*G0_1_0_0_5 + 0.00295860389610399*G0_1_0_0_6 - 0.000493100649350661*G0_1_0_0_7 - 0.002958603896104*G0_1_0_0_8 - 0.000383522727272742*G0_1_0_1_0 - 0.0147930194805199*G0_1_0_1_1 - 0.0246550324675333*G0_1_0_1_3 + 0.0157792207792213*G0_1_0_1_4 - 0.00295860389610399*G0_1_0_1_5 - 0.000493100649350657*G0_1_0_1_6 + 0.002958603896104*G0_1_0_1_7 - 0.00986201298701332*G0_1_0_1_8 - 0.0138068181818187*G0_1_0_1_9 + 0.000383522727272753*G0_1_0_2_0 + 0.0147930194805201*G0_1_0_2_2 - 0.0157792207792213*G0_1_0_2_3 + 0.0246550324675334*G0_1_0_2_4 - 0.00295860389610403*G0_1_0_2_5 + 0.00986201298701338*G0_1_0_2_6 + 0.002958603896104*G0_1_0_2_7 + 0.000493100649350658*G0_1_0_2_8 + 0.0138068181818186*G0_1_0_2_9 - 0.00690340909090935*G0_1_0_3_0 - 0.0246550324675333*G0_1_0_3_1 - 0.0157792207792213*G0_1_0_3_2 - 0.13313717532468*G0_1_0_3_3 + 0.01479301948052*G0_1_0_3_5 + 0.00147930194805197*G0_1_0_3_6 + 0.020710227272728*G0_1_0_3_7 - 0.0192309253246761*G0_1_0_3_8 + 0.00690340909090936*G0_1_0_4_0 + 0.0157792207792213*G0_1_0_4_1 + 0.0246550324675334*G0_1_0_4_2 + 0.13313717532468*G0_1_0_4_4 - 0.020710227272728*G0_1_0_4_5 + 0.0192309253246761*G0_1_0_4_6 - 0.01479301948052*G0_1_0_4_7 - 0.00147930194805198*G0_1_0_4_8 + 0.000493100649350666*G0_1_0_5_0 - 0.00295860389610399*G0_1_0_5_1 - 0.00295860389610403*G0_1_0_5_2 + 0.01479301948052*G0_1_0_5_3 - 0.020710227272728*G0_1_0_5_4 - 0.0236688311688318*G0_1_0_5_5 - 0.010355113636364*G0_1_0_5_6 + 0.00887581168831197*G0_1_0_5_8 - 0.0177516233766239*G0_1_0_5_9 + 0.00295860389610399*G0_1_0_6_0 - 0.000493100649350657*G0_1_0_6_1 + 0.00986201298701338*G0_1_0_6_2 + 0.00147930194805197*G0_1_0_6_3 + 0.0192309253246761*G0_1_0_6_4 - 0.010355113636364*G0_1_0_6_5 - 0.0236688311688318*G0_1_0_6_6 - 0.00887581168831202*G0_1_0_6_7 - 0.0443790584415599*G0_1_0_6_9 - 0.00049310064935066*G0_1_0_7_0 + 0.002958603896104*G0_1_0_7_1 + 0.002958603896104*G0_1_0_7_2 + 0.020710227272728*G0_1_0_7_3 - 0.01479301948052*G0_1_0_7_4 - 0.00887581168831202*G0_1_0_7_6 + 0.023668831168832*G0_1_0_7_7 + 0.010355113636364*G0_1_0_7_8 + 0.0177516233766241*G0_1_0_7_9 - 0.002958603896104*G0_1_0_8_0 - 0.00986201298701332*G0_1_0_8_1 + 0.000493100649350657*G0_1_0_8_2 - 0.0192309253246761*G0_1_0_8_3 - 0.00147930194805198*G0_1_0_8_4 + 0.00887581168831197*G0_1_0_8_5 + 0.010355113636364*G0_1_0_8_7 + 0.023668831168832*G0_1_0_8_8 + 0.0443790584415599*G0_1_0_8_9 - 0.0138068181818187*G0_1_0_9_1 + 0.0138068181818186*G0_1_0_9_2 - 0.0177516233766239*G0_1_0_9_5 - 0.0443790584415599*G0_1_0_9_6 + 0.017751623376624*G0_1_0_9_7 + 0.0443790584415599*G0_1_0_9_8 - 0.00648336038961072*G0_1_1_0_0 - 0.0049218750000002*G0_1_1_0_1 - 0.000237418831168839*G0_1_1_0_2 - 0.00813616071428603*G0_1_1_0_3 + 0.00813616071428604*G0_1_1_0_4 - 0.00172585227272739*G0_1_1_0_5 + 0.00271205357142869*G0_1_1_0_6 - 0.00854707792207827*G0_1_1_0_7 - 0.000410917207792209*G0_1_1_0_8 - 0.00147930194805203*G0_1_1_0_9 - 0.0049218750000002*G0_1_1_1_0 - 0.0917715097402627*G0_1_1_1_1 - 0.00458400974025988*G0_1_1_1_2 - 0.0714995941558465*G0_1_1_1_3 + 0.0335308441558453*G0_1_1_1_4 - 0.00197240259740267*G0_1_1_1_5 + 0.000246550324675343*G0_1_1_1_6 + 0.0142999188311694*G0_1_1_1_7 - 0.0394480519480534*G0_1_1_1_8 - 0.020710227272728*G0_1_1_1_9 - 0.000237418831168839*G0_1_1_2_0 - 0.00458400974025988*G0_1_1_2_1 + 0.0121631493506498*G0_1_1_2_2 - 0.0225182629870138*G0_1_1_2_3 + 0.0243262987012996*G0_1_1_2_4 - 0.00410917207792224*G0_1_1_2_5 + 0.00969764610389646*G0_1_1_2_6 - 0.000493100649350659*G0_1_1_2_7 + 0.000986201298701321*G0_1_1_2_8 + 0.00887581168831197*G0_1_1_2_9 - 0.00813616071428603*G0_1_1_3_0 - 0.0714995941558465*G0_1_1_3_1 - 0.0225182629870138*G0_1_1_3_2 - 0.164202516233772*G0_1_1_3_3 + 0.0443790584415599*G0_1_1_3_4 + 0.011834415584416*G0_1_1_3_5 + 0.00591720779220797*G0_1_1_3_6 + 0.0310653409090921*G0_1_1_3_7 - 0.0347635957792222*G0_1_1_3_8 + 0.00813616071428604*G0_1_1_4_0 + 0.0335308441558453*G0_1_1_4_1 + 0.0243262987012996*G0_1_1_4_2 + 0.0443790584415599*G0_1_1_4_3 + 0.150888798701304*G0_1_1_4_4 - 0.017751623376624*G0_1_1_4_5 + 0.0118344155844161*G0_1_1_4_6 - 0.01479301948052*G0_1_1_4_7 + 0.00369825487013005*G0_1_1_4_8 + 0.00887581168831216*G0_1_1_4_9 - 0.00172585227272739*G0_1_1_5_0 - 0.00197240259740267*G0_1_1_5_1 - 0.00410917207792224*G0_1_1_5_2 + 0.011834415584416*G0_1_1_5_3 - 0.017751623376624*G0_1_1_5_4 - 0.02218952922078*G0_1_1_5_5 + 0.00147930194805201*G0_1_1_5_6 - 0.020710227272728*G0_1_1_5_7 + 0.012574066558442*G0_1_1_5_8 - 0.0207102272727279*G0_1_1_5_9 + 0.00271205357142869*G0_1_1_6_0 + 0.000246550324675343*G0_1_1_6_1 + 0.00969764610389646*G0_1_1_6_2 + 0.00591720779220797*G0_1_1_6_3 + 0.0118344155844161*G0_1_1_6_4 + 0.00147930194805201*G0_1_1_6_5 - 0.0325446428571439*G0_1_1_6_6 + 0.00813616071428597*G0_1_1_6_7 - 0.005177556818182*G0_1_1_6_8 - 0.0384618506493519*G0_1_1_6_9 - 0.00854707792207827*G0_1_1_7_0 + 0.0142999188311694*G0_1_1_7_1 - 0.000493100649350659*G0_1_1_7_2 + 0.0310653409090921*G0_1_1_7_3 - 0.01479301948052*G0_1_1_7_4 - 0.020710227272728*G0_1_1_7_5 + 0.00813616071428597*G0_1_1_7_6 - 0.0695271915584441*G0_1_1_7_7 + 0.0362428977272741*G0_1_1_7_8 - 0.011834415584416*G0_1_1_7_9 - 0.000410917207792209*G0_1_1_8_0 - 0.0394480519480534*G0_1_1_8_1 + 0.00098620129870132*G0_1_1_8_2 - 0.0347635957792222*G0_1_1_8_3 + 0.00369825487013005*G0_1_1_8_4 + 0.012574066558442*G0_1_1_8_5 - 0.005177556818182*G0_1_1_8_6 + 0.0362428977272741*G0_1_1_8_7 + 0.0710064935064958*G0_1_1_8_8 + 0.0547341720779239*G0_1_1_8_9 - 0.00147930194805203*G0_1_1_9_0 - 0.020710227272728*G0_1_1_9_1 + 0.00887581168831197*G0_1_1_9_2 + 0.00887581168831215*G0_1_1_9_4 - 0.0207102272727279*G0_1_1_9_5 - 0.0384618506493519*G0_1_1_9_6 - 0.011834415584416*G0_1_1_9_7 + 0.0547341720779239*G0_1_1_9_8 - 0.142012987012992*G0_1_1_9_9;
    A[99] = 0.0184090909090916*G0_0_0_0_0 - 0.0013149350649351*G0_0_0_0_1 + 0.00493100649350665*G0_0_0_0_2 + 0.0315584415584427*G0_0_0_0_3 + 0.0167654220779227*G0_0_0_0_4 - 0.00690340909090925*G0_0_0_0_5 - 0.0128206168831172*G0_0_0_0_6 - 0.00690340909090933*G0_0_0_0_7 + 0.0108482142857147*G0_0_0_0_8 + 0.0177516233766241*G0_0_0_0_9 - 0.0013149350649351*G0_0_0_1_0 + 0.0184090909090915*G0_0_0_1_1 + 0.00493100649350666*G0_0_0_1_2 - 0.00690340909090929*G0_0_0_1_3 - 0.0128206168831173*G0_0_0_1_4 + 0.0315584415584426*G0_0_0_1_5 + 0.0167654220779227*G0_0_0_1_6 + 0.0108482142857146*G0_0_0_1_7 - 0.0069034090909093*G0_0_0_1_8 + 0.017751623376624*G0_0_0_1_9 + 0.00493100649350665*G0_0_0_2_0 + 0.00493100649350666*G0_0_0_2_1 + 0.0197240259740266*G0_0_0_2_2 - 0.00394480519480536*G0_0_0_2_3 - 0.00986201298701337*G0_0_0_2_4 - 0.00394480519480526*G0_0_0_2_5 - 0.00986201298701334*G0_0_0_2_6 + 0.00493100649350667*G0_0_0_2_7 + 0.00493100649350665*G0_0_0_2_8 - 0.0118344155844159*G0_0_0_2_9 + 0.0315584415584427*G0_0_0_3_0 - 0.00690340909090929*G0_0_0_3_1 - 0.00394480519480536*G0_0_0_3_2 + 0.603555194805216*G0_0_0_3_3 - 0.00887581168831158*G0_0_0_3_4 - 0.0887581168831198*G0_0_0_3_5 - 0.0621306818181838*G0_0_0_3_6 - 0.106509740259744*G0_0_0_3_7 + 0.13313717532468*G0_0_0_3_8 + 0.159764610389616*G0_0_0_3_9 + 0.0167654220779227*G0_0_0_4_0 - 0.0128206168831173*G0_0_0_4_1 - 0.00986201298701336*G0_0_0_4_2 - 0.00887581168831159*G0_0_0_4_3 + 0.497045454545472*G0_0_0_4_4 - 0.062130681818184*G0_0_0_4_5 + 0.124261363636368*G0_0_0_4_6 - 0.026627435064936*G0_0_0_4_7 - 0.026627435064936*G0_0_0_4_8 + 0.159764610389616*G0_0_0_4_9 - 0.00690340909090924*G0_0_0_5_0 + 0.0315584415584426*G0_0_0_5_1 - 0.00394480519480526*G0_0_0_5_2 - 0.0887581168831198*G0_0_0_5_3 - 0.062130681818184*G0_0_0_5_4 + 0.603555194805215*G0_0_0_5_5 - 0.00887581168831208*G0_0_0_5_6 + 0.13313717532468*G0_0_0_5_7 - 0.106509740259744*G0_0_0_5_8 + 0.159764610389616*G0_0_0_5_9 - 0.0128206168831172*G0_0_0_6_0 + 0.0167654220779227*G0_0_0_6_1 - 0.00986201298701334*G0_0_0_6_2 - 0.0621306818181838*G0_0_0_6_3 + 0.124261363636368*G0_0_0_6_4 - 0.00887581168831208*G0_0_0_6_5 + 0.497045454545471*G0_0_0_6_6 - 0.0266274350649359*G0_0_0_6_7 - 0.0266274350649359*G0_0_0_6_8 + 0.159764610389616*G0_0_0_6_9 - 0.00690340909090933*G0_0_0_7_0 + 0.0108482142857146*G0_0_0_7_1 + 0.00493100649350667*G0_0_0_7_2 - 0.106509740259744*G0_0_0_7_3 - 0.026627435064936*G0_0_0_7_4 + 0.13313717532468*G0_0_0_7_5 - 0.0266274350649359*G0_0_0_7_6 + 0.08875811688312*G0_0_0_7_7 - 0.071006493506496*G0_0_0_7_8 + 0.0108482142857147*G0_0_0_8_0 - 0.0069034090909093*G0_0_0_8_1 + 0.00493100649350665*G0_0_0_8_2 + 0.13313717532468*G0_0_0_8_3 - 0.026627435064936*G0_0_0_8_4 - 0.106509740259744*G0_0_0_8_5 - 0.0266274350649359*G0_0_0_8_6 - 0.071006493506496*G0_0_0_8_7 + 0.08875811688312*G0_0_0_8_8 + 0.0177516233766241*G0_0_0_9_0 + 0.017751623376624*G0_0_0_9_1 - 0.0118344155844159*G0_0_0_9_2 + 0.159764610389616*G0_0_0_9_3 + 0.159764610389616*G0_0_0_9_4 + 0.159764610389616*G0_0_0_9_5 + 0.159764610389616*G0_0_0_9_6 + 0.639058441558463*G0_0_0_9_9 + 0.00854707792207827*G0_0_1_0_0 - 0.000657467532467551*G0_0_1_0_1 - 0.000657467532467553*G0_0_1_0_2 + 0.0216964285714294*G0_0_1_0_3 + 0.0216964285714294*G0_0_1_0_4 - 0.00197240259740263*G0_0_1_0_5 + 0.000986201298701317*G0_0_1_0_6 - 0.00197240259740265*G0_0_1_0_7 + 0.000986201298701331*G0_0_1_0_8 + 0.023668831168832*G0_0_1_0_9 - 0.00065746753246755*G0_0_1_1_0 + 0.0098620129870133*G0_0_1_1_1 + 0.00558847402597422*G0_0_1_1_2 - 0.00493100649350667*G0_0_1_1_3 - 0.0138068181818186*G0_0_1_1_4 + 0.00986201298701333*G0_0_1_1_5 - 0.00493100649350668*G0_0_1_1_6 + 0.00986201298701333*G0_0_1_1_7 - 0.00493100649350665*G0_0_1_1_8 - 0.00591720779220795*G0_0_1_1_9 - 0.000657467532467554*G0_0_1_2_0 + 0.00558847402597422*G0_0_1_2_1 + 0.00986201298701332*G0_0_1_2_2 - 0.0138068181818187*G0_0_1_2_3 - 0.00493100649350668*G0_0_1_2_4 + 0.00986201298701334*G0_0_1_2_5 - 0.00493100649350667*G0_0_1_2_6 + 0.00986201298701334*G0_0_1_2_7 - 0.00493100649350666*G0_0_1_2_8 - 0.00591720779220797*G0_0_1_2_9 + 0.0216964285714294*G0_0_1_3_0 - 0.00493100649350667*G0_0_1_3_1 - 0.0138068181818187*G0_0_1_3_2 + 0.505921266233784*G0_0_1_3_3 + 0.0266274350649363*G0_0_1_3_4 - 0.04437905844156*G0_0_1_3_5 + 0.00887581168831202*G0_0_1_3_6 - 0.071006493506496*G0_0_1_3_7 + 0.062130681818184*G0_0_1_3_8 + 0.159764610389616*G0_0_1_3_9 + 0.0216964285714294*G0_0_1_4_0 - 0.0138068181818186*G0_0_1_4_1 - 0.00493100649350669*G0_0_1_4_2 + 0.0266274350649363*G0_0_1_4_3 + 0.505921266233784*G0_0_1_4_4 - 0.0710064935064959*G0_0_1_4_5 + 0.062130681818184*G0_0_1_4_6 - 0.04437905844156*G0_0_1_4_7 + 0.00887581168831198*G0_0_1_4_8 + 0.159764610389616*G0_0_1_4_9 - 0.00197240259740263*G0_0_1_5_0 + 0.00986201298701333*G0_0_1_5_1 + 0.00986201298701334*G0_0_1_5_2 - 0.04437905844156*G0_0_1_5_3 - 0.0710064935064959*G0_0_1_5_4 + 0.0976339285714319*G0_0_1_5_5 - 0.035503246753248*G0_0_1_5_6 + 0.071006493506496*G0_0_1_5_7 - 0.035503246753248*G0_0_1_5_8 + 0.000986201298701317*G0_0_1_6_0 - 0.00493100649350668*G0_0_1_6_1 - 0.00493100649350667*G0_0_1_6_2 + 0.00887581168831202*G0_0_1_6_3 + 0.062130681818184*G0_0_1_6_4 - 0.035503246753248*G0_0_1_6_5 - 0.00887581168831214*G0_0_1_6_6 - 0.035503246753248*G0_0_1_6_7 + 0.017751623376624*G0_0_1_6_8 - 0.00197240259740265*G0_0_1_7_0 + 0.00986201298701333*G0_0_1_7_1 + 0.00986201298701334*G0_0_1_7_2 - 0.071006493506496*G0_0_1_7_3 - 0.04437905844156*G0_0_1_7_4 + 0.071006493506496*G0_0_1_7_5 - 0.035503246753248*G0_0_1_7_6 + 0.0976339285714322*G0_0_1_7_7 - 0.0355032467532481*G0_0_1_7_8 + 0.00098620129870133*G0_0_1_8_0 - 0.00493100649350664*G0_0_1_8_1 - 0.00493100649350666*G0_0_1_8_2 + 0.062130681818184*G0_0_1_8_3 + 0.00887581168831198*G0_0_1_8_4 - 0.035503246753248*G0_0_1_8_5 + 0.017751623376624*G0_0_1_8_6 - 0.0355032467532481*G0_0_1_8_7 - 0.00887581168831189*G0_0_1_8_8 + 0.023668831168832*G0_0_1_9_0 - 0.00591720779220796*G0_0_1_9_1 - 0.00591720779220797*G0_0_1_9_2 + 0.159764610389616*G0_0_1_9_3 + 0.159764610389616*G0_0_1_9_4 + 0.319529220779232*G0_0_1_9_9 + 0.00854707792207827*G0_1_0_0_0 - 0.000657467532467551*G0_1_0_0_1 - 0.000657467532467553*G0_1_0_0_2 + 0.0216964285714294*G0_1_0_0_3 + 0.0216964285714294*G0_1_0_0_4 - 0.00197240259740263*G0_1_0_0_5 + 0.000986201298701317*G0_1_0_0_6 - 0.00197240259740265*G0_1_0_0_7 + 0.000986201298701331*G0_1_0_0_8 + 0.023668831168832*G0_1_0_0_9 - 0.00065746753246755*G0_1_0_1_0 + 0.0098620129870133*G0_1_0_1_1 + 0.00558847402597422*G0_1_0_1_2 - 0.00493100649350667*G0_1_0_1_3 - 0.0138068181818186*G0_1_0_1_4 + 0.00986201298701333*G0_1_0_1_5 - 0.00493100649350668*G0_1_0_1_6 + 0.00986201298701333*G0_1_0_1_7 - 0.00493100649350665*G0_1_0_1_8 - 0.00591720779220796*G0_1_0_1_9 - 0.000657467532467554*G0_1_0_2_0 + 0.00558847402597422*G0_1_0_2_1 + 0.00986201298701332*G0_1_0_2_2 - 0.0138068181818187*G0_1_0_2_3 - 0.00493100649350668*G0_1_0_2_4 + 0.00986201298701334*G0_1_0_2_5 - 0.00493100649350667*G0_1_0_2_6 + 0.00986201298701334*G0_1_0_2_7 - 0.00493100649350666*G0_1_0_2_8 - 0.00591720779220796*G0_1_0_2_9 + 0.0216964285714294*G0_1_0_3_0 - 0.00493100649350667*G0_1_0_3_1 - 0.0138068181818187*G0_1_0_3_2 + 0.505921266233784*G0_1_0_3_3 + 0.0266274350649363*G0_1_0_3_4 - 0.04437905844156*G0_1_0_3_5 + 0.00887581168831202*G0_1_0_3_6 - 0.071006493506496*G0_1_0_3_7 + 0.062130681818184*G0_1_0_3_8 + 0.159764610389616*G0_1_0_3_9 + 0.0216964285714294*G0_1_0_4_0 - 0.0138068181818186*G0_1_0_4_1 - 0.00493100649350669*G0_1_0_4_2 + 0.0266274350649363*G0_1_0_4_3 + 0.505921266233784*G0_1_0_4_4 - 0.0710064935064959*G0_1_0_4_5 + 0.062130681818184*G0_1_0_4_6 - 0.04437905844156*G0_1_0_4_7 + 0.00887581168831198*G0_1_0_4_8 + 0.159764610389616*G0_1_0_4_9 - 0.00197240259740263*G0_1_0_5_0 + 0.00986201298701333*G0_1_0_5_1 + 0.00986201298701334*G0_1_0_5_2 - 0.04437905844156*G0_1_0_5_3 - 0.0710064935064959*G0_1_0_5_4 + 0.0976339285714319*G0_1_0_5_5 - 0.035503246753248*G0_1_0_5_6 + 0.071006493506496*G0_1_0_5_7 - 0.035503246753248*G0_1_0_5_8 + 0.000986201298701317*G0_1_0_6_0 - 0.00493100649350668*G0_1_0_6_1 - 0.00493100649350667*G0_1_0_6_2 + 0.00887581168831202*G0_1_0_6_3 + 0.062130681818184*G0_1_0_6_4 - 0.035503246753248*G0_1_0_6_5 - 0.00887581168831214*G0_1_0_6_6 - 0.035503246753248*G0_1_0_6_7 + 0.017751623376624*G0_1_0_6_8 - 0.00197240259740265*G0_1_0_7_0 + 0.00986201298701333*G0_1_0_7_1 + 0.00986201298701334*G0_1_0_7_2 - 0.071006493506496*G0_1_0_7_3 - 0.04437905844156*G0_1_0_7_4 + 0.071006493506496*G0_1_0_7_5 - 0.035503246753248*G0_1_0_7_6 + 0.0976339285714322*G0_1_0_7_7 - 0.0355032467532481*G0_1_0_7_8 + 0.00098620129870133*G0_1_0_8_0 - 0.00493100649350664*G0_1_0_8_1 - 0.00493100649350666*G0_1_0_8_2 + 0.062130681818184*G0_1_0_8_3 + 0.00887581168831198*G0_1_0_8_4 - 0.035503246753248*G0_1_0_8_5 + 0.017751623376624*G0_1_0_8_6 - 0.0355032467532481*G0_1_0_8_7 - 0.00887581168831189*G0_1_0_8_8 + 0.023668831168832*G0_1_0_9_0 - 0.00591720779220796*G0_1_0_9_1 - 0.00591720779220796*G0_1_0_9_2 + 0.159764610389616*G0_1_0_9_3 + 0.159764610389616*G0_1_0_9_4 + 0.319529220779232*G0_1_0_9_9 + 0.0184090909090916*G0_1_1_0_0 + 0.00493100649350668*G0_1_1_0_1 - 0.0013149350649351*G0_1_1_0_2 + 0.0167654220779227*G0_1_1_0_3 + 0.0315584415584428*G0_1_1_0_4 - 0.00690340909090931*G0_1_1_0_5 + 0.0108482142857147*G0_1_1_0_6 - 0.00690340909090922*G0_1_1_0_7 - 0.0128206168831173*G0_1_1_0_8 + 0.0177516233766241*G0_1_1_0_9 + 0.00493100649350668*G0_1_1_1_0 + 0.0197240259740267*G0_1_1_1_1 + 0.00493100649350667*G0_1_1_1_2 - 0.00986201298701334*G0_1_1_1_3 - 0.00394480519480529*G0_1_1_1_4 + 0.00493100649350666*G0_1_1_1_5 + 0.00493100649350667*G0_1_1_1_6 - 0.00394480519480533*G0_1_1_1_7 - 0.00986201298701329*G0_1_1_1_8 - 0.0118344155844159*G0_1_1_1_9 - 0.0013149350649351*G0_1_1_2_0 + 0.00493100649350667*G0_1_1_2_1 + 0.0184090909090916*G0_1_1_2_2 - 0.0128206168831174*G0_1_1_2_3 - 0.0069034090909093*G0_1_1_2_4 + 0.0108482142857147*G0_1_1_2_5 - 0.0069034090909093*G0_1_1_2_6 + 0.0315584415584427*G0_1_1_2_7 + 0.0167654220779226*G0_1_1_2_8 + 0.017751623376624*G0_1_1_2_9 + 0.0167654220779227*G0_1_1_3_0 - 0.00986201298701334*G0_1_1_3_1 - 0.0128206168831174*G0_1_1_3_2 + 0.497045454545472*G0_1_1_3_3 - 0.00887581168831166*G0_1_1_3_4 - 0.026627435064936*G0_1_1_3_5 - 0.026627435064936*G0_1_1_3_6 - 0.0621306818181842*G0_1_1_3_7 + 0.124261363636368*G0_1_1_3_8 + 0.159764610389616*G0_1_1_3_9 + 0.0315584415584427*G0_1_1_4_0 - 0.00394480519480529*G0_1_1_4_1 - 0.0069034090909093*G0_1_1_4_2 - 0.00887581168831165*G0_1_1_4_3 + 0.603555194805216*G0_1_1_4_4 - 0.106509740259744*G0_1_1_4_5 + 0.13313717532468*G0_1_1_4_6 - 0.0887581168831201*G0_1_1_4_7 - 0.062130681818184*G0_1_1_4_8 + 0.159764610389616*G0_1_1_4_9 - 0.00690340909090931*G0_1_1_5_0 + 0.00493100649350666*G0_1_1_5_1 + 0.0108482142857147*G0_1_1_5_2 - 0.026627435064936*G0_1_1_5_3 - 0.106509740259744*G0_1_1_5_4 + 0.08875811688312*G0_1_1_5_5 - 0.071006493506496*G0_1_1_5_6 + 0.13313717532468*G0_1_1_5_7 - 0.0266274350649361*G0_1_1_5_8 + 0.0108482142857147*G0_1_1_6_0 + 0.00493100649350667*G0_1_1_6_1 - 0.0069034090909093*G0_1_1_6_2 - 0.026627435064936*G0_1_1_6_3 + 0.13313717532468*G0_1_1_6_4 - 0.0710064935064961*G0_1_1_6_5 + 0.0887581168831201*G0_1_1_6_6 - 0.106509740259744*G0_1_1_6_7 - 0.0266274350649359*G0_1_1_6_8 - 0.00690340909090923*G0_1_1_7_0 - 0.00394480519480533*G0_1_1_7_1 + 0.0315584415584427*G0_1_1_7_2 - 0.0621306818181842*G0_1_1_7_3 - 0.0887581168831201*G0_1_1_7_4 + 0.13313717532468*G0_1_1_7_5 - 0.106509740259744*G0_1_1_7_6 + 0.603555194805217*G0_1_1_7_7 - 0.00887581168831227*G0_1_1_7_8 + 0.159764610389617*G0_1_1_7_9 - 0.0128206168831173*G0_1_1_8_0 - 0.00986201298701328*G0_1_1_8_1 + 0.0167654220779226*G0_1_1_8_2 + 0.124261363636368*G0_1_1_8_3 - 0.062130681818184*G0_1_1_8_4 - 0.0266274350649361*G0_1_1_8_5 - 0.0266274350649359*G0_1_1_8_6 - 0.00887581168831226*G0_1_1_8_7 + 0.497045454545473*G0_1_1_8_8 + 0.159764610389616*G0_1_1_8_9 + 0.0177516233766241*G0_1_1_9_0 - 0.0118344155844159*G0_1_1_9_1 + 0.017751623376624*G0_1_1_9_2 + 0.159764610389616*G0_1_1_9_3 + 0.159764610389616*G0_1_1_9_4 + 0.159764610389617*G0_1_1_9_7 + 0.159764610389616*G0_1_1_9_8 + 0.639058441558464*G0_1_1_9_9;
    A[78] = -A[73] - 0.0864752435064963*G0_0_0_0_0 - 0.00699472402597427*G0_0_0_0_1 - 0.00539671266233784*G0_0_0_0_2 + 0.000410917207792224*G0_0_0_0_3 + 0.00189021915584424*G0_0_0_0_4 - 0.0626237824675345*G0_0_0_0_5 + 0.0273670860389619*G0_0_0_0_6 - 0.0216142451298708*G0_0_0_0_7 + 0.0178338068181824*G0_0_0_0_8 - 0.00699472402597427*G0_0_0_1_0 - 0.0690340909090931*G0_0_0_1_1 - 0.00259334415584424*G0_0_0_1_2 - 0.0361607142857154*G0_0_0_1_3 + 0.0116700487012991*G0_0_0_1_4 - 0.0072321428571431*G0_0_0_1_5 + 0.00065746753246756*G0_0_0_1_6 + 0.0124918831168836*G0_0_0_1_7 - 0.0106838474025978*G0_0_0_1_8 + 0.00542410714285729*G0_0_0_1_9 - 0.00539671266233784*G0_0_0_2_0 - 0.00259334415584424*G0_0_0_2_1 - 0.00178977272727279*G0_0_0_2_2 - 0.00977982954545486*G0_0_0_2_3 + 0.00525974025974042*G0_0_0_2_4 - 0.0142177353896109*G0_0_0_2_5 + 0.0126562500000004*G0_0_0_2_6 - 0.00920454545454577*G0_0_0_2_7 - 0.00945109577922109*G0_0_0_2_8 - 0.0197240259740266*G0_0_0_2_9 + 0.000410917207792223*G0_0_0_3_0 - 0.0361607142857154*G0_0_0_3_1 - 0.00977982954545486*G0_0_0_3_2 - 0.0103551136363638*G0_0_0_3_3 + 0.0443790584415599*G0_0_0_3_4 + 0.00665685876623398*G0_0_0_3_5 + 0.00517755681818198*G0_0_0_3_6 + 0.00591720779220803*G0_0_0_3_7 - 0.0414204545454559*G0_0_0_3_8 - 0.0281067370129879*G0_0_0_3_9 + 0.00189021915584424*G0_0_0_4_0 + 0.0116700487012991*G0_0_0_4_1 + 0.00525974025974042*G0_0_0_4_2 + 0.0443790584415599*G0_0_0_4_3 + 0.0236688311688321*G0_0_0_4_4 + 0.00147930194805202*G0_0_0_4_5 - 0.00665685876623397*G0_0_0_4_6 + 0.00739650974026*G0_0_0_4_7 + 0.035503246753248*G0_0_0_4_8 + 0.056213474025976*G0_0_0_4_9 - 0.0626237824675345*G0_0_0_5_0 - 0.0072321428571431*G0_0_0_5_1 - 0.0142177353896109*G0_0_0_5_2 + 0.00665685876623398*G0_0_0_5_3 + 0.00147930194805202*G0_0_0_5_4 - 0.23668831168832*G0_0_0_5_5 + 0.0525152191558459*G0_0_0_5_6 - 0.0636099837662359*G0_0_0_5_7 + 0.028846387987014*G0_0_0_5_8 - 0.057692775974028*G0_0_0_5_9 + 0.0273670860389619*G0_0_0_6_0 + 0.00065746753246756*G0_0_0_6_1 + 0.0126562500000004*G0_0_0_6_2 + 0.00517755681818198*G0_0_0_6_3 - 0.00665685876623397*G0_0_0_6_4 + 0.0525152191558459*G0_0_0_6_5 - 0.0221895292207799*G0_0_0_6_6 + 0.034763595779222*G0_0_0_6_7 + 0.00961546266233796*G0_0_0_6_8 + 0.048816964285716*G0_0_0_6_9 - 0.0216142451298708*G0_0_0_7_0 + 0.0124918831168836*G0_0_0_7_1 - 0.00920454545454577*G0_0_0_7_2 + 0.00591720779220803*G0_0_0_7_3 + 0.00739650974026*G0_0_0_7_4 - 0.0636099837662359*G0_0_0_7_5 + 0.034763595779222*G0_0_0_7_6 - 0.124261363636368*G0_0_0_7_7 - 0.00739650974025996*G0_0_0_7_8 - 0.0695271915584441*G0_0_0_7_9 + 0.0178338068181824*G0_0_0_8_0 - 0.0106838474025978*G0_0_0_8_1 - 0.00945109577922109*G0_0_0_8_2 - 0.0414204545454559*G0_0_0_8_3 + 0.035503246753248*G0_0_0_8_4 + 0.028846387987014*G0_0_0_8_5 + 0.00961546266233796*G0_0_0_8_6 - 0.00739650974025995*G0_0_0_8_7 - 0.143492288961044*G0_0_0_8_8 - 0.0872788149350679*G0_0_0_8_9 + 0.00542410714285729*G0_0_0_9_1 - 0.0197240259740266*G0_0_0_9_2 - 0.0281067370129879*G0_0_0_9_3 + 0.056213474025976*G0_0_0_9_4 - 0.057692775974028*G0_0_0_9_5 + 0.048816964285716*G0_0_0_9_6 - 0.069527191558444*G0_0_0_9_7 - 0.0872788149350679*G0_0_0_9_8 - 0.390535714285727*G0_0_0_9_9 + 0.00611810064935086*G0_1_0_0_0 - 0.0032599431818183*G0_1_0_0_1 + 0.00166193181818187*G0_1_0_0_2 + 0.000410917207792218*G0_1_0_0_3 + 0.000410917207792233*G0_1_0_0_4 + 0.0101085633116887*G0_1_0_0_5 - 0.00714995941558466*G0_1_0_0_6 + 0.0190665584415591*G0_1_0_0_7 + 0.000575284090909081*G0_1_0_0_8 + 0.0172585227272733*G0_1_0_0_9 - 0.0032599431818183*G0_1_0_1_0 - 0.0717735389610413*G0_1_0_1_1 - 0.00249289772727281*G0_1_0_1_2 - 0.0394480519480532*G0_1_0_1_3 + 0.0123275162337666*G0_1_0_1_4 + 0.00238331980519488*G0_1_0_1_5 - 0.00156148538961044*G0_1_0_1_6 + 0.0172585227272733*G0_1_0_1_7 - 0.01479301948052*G0_1_0_1_8 + 0.00493100649350662*G0_1_0_1_9 + 0.00166193181818187*G0_1_0_2_0 - 0.0024928977272728*G0_1_0_2_1 - 0.00341517857142872*G0_1_0_2_2 - 0.00928672889610418*G0_1_0_2_3 + 0.00378043831168841*G0_1_0_2_4 - 0.00221895292207798*G0_1_0_2_5 + 0.00419135551948063*G0_1_0_2_6 - 0.0119165990259744*G0_1_0_2_7 - 0.0114234983766238*G0_1_0_2_8 - 0.0261343344155853*G0_1_0_2_9 + 0.000410917207792217*G0_1_0_3_0 - 0.0394480519480532*G0_1_0_3_1 - 0.00928672889610419*G0_1_0_3_2 + 0.0451187094155859*G0_1_0_3_4 - 0.00517755681818199*G0_1_0_3_5 + 0.006656858766234*G0_1_0_3_6 + 0.000739650974026052*G0_1_0_3_7 - 0.0369825487013*G0_1_0_3_8 - 0.0162723214285719*G0_1_0_3_9 + 0.000410917207792233*G0_1_0_4_0 + 0.0123275162337666*G0_1_0_4_1 + 0.00378043831168841*G0_1_0_4_2 + 0.0451187094155859*G0_1_0_4_3 + 0.032544642857144*G0_1_0_4_4 + 0.00073965097402601*G0_1_0_4_5 - 0.00739650974026002*G0_1_0_4_6 + 0.016272321428572*G0_1_0_4_7 + 0.036242897727274*G0_1_0_4_8 + 0.0769237012987039*G0_1_0_4_9 + 0.0101085633116887*G0_1_0_5_0 + 0.00238331980519488*G0_1_0_5_1 - 0.00221895292207798*G0_1_0_5_2 - 0.00517755681818199*G0_1_0_5_3 + 0.00073965097402601*G0_1_0_5_4 + 0.0207102272727279*G0_1_0_5_5 + 0.00739650974026001*G0_1_0_5_6 - 0.032544642857144*G0_1_0_5_7 - 0.00517755681818198*G0_1_0_5_8 - 0.041420454545456*G0_1_0_5_9 - 0.00714995941558466*G0_1_0_6_0 - 0.00156148538961044*G0_1_0_6_1 + 0.00419135551948063*G0_1_0_6_2 + 0.006656858766234*G0_1_0_6_3 - 0.00739650974026002*G0_1_0_6_4 + 0.00739650974026001*G0_1_0_6_5 - 0.00591720779220814*G0_1_0_6_6 + 0.037722199675326*G0_1_0_6_7 + 0.01849127435065*G0_1_0_6_8 + 0.0650892857142879*G0_1_0_6_9 + 0.0190665584415591*G0_1_0_7_0 + 0.0172585227272733*G0_1_0_7_1 - 0.0119165990259744*G0_1_0_7_2 + 0.000739650974026052*G0_1_0_7_3 + 0.016272321428572*G0_1_0_7_4 - 0.032544642857144*G0_1_0_7_5 + 0.037722199675326*G0_1_0_7_6 - 0.2218952922078*G0_1_0_7_7 - 0.0229291801948059*G0_1_0_7_8 - 0.127219967532472*G0_1_0_7_9 + 0.000575284090909081*G0_1_0_8_0 - 0.01479301948052*G0_1_0_8_1 - 0.0114234983766238*G0_1_0_8_2 - 0.0369825487013*G0_1_0_8_3 + 0.036242897727274*G0_1_0_8_4 - 0.00517755681818198*G0_1_0_8_5 + 0.01849127435065*G0_1_0_8_6 - 0.0229291801948059*G0_1_0_8_7 - 0.1479301948052*G0_1_0_8_8 - 0.0872788149350679*G0_1_0_8_9 + 0.0172585227272733*G0_1_0_9_0 + 0.00493100649350662*G0_1_0_9_1 - 0.0261343344155853*G0_1_0_9_2 - 0.0162723214285719*G0_1_0_9_3 + 0.0769237012987039*G0_1_0_9_4 - 0.0414204545454559*G0_1_0_9_5 + 0.0650892857142879*G0_1_0_9_6 - 0.127219967532472*G0_1_0_9_7 - 0.0872788149350679*G0_1_0_9_8 - 0.408287337662352*G0_1_0_9_9;
    A[21] = 0.0017038690476191*G0_1_0_0_0 + 0.000851934523809557*G0_1_0_0_1 + 0.000851934523809558*G0_1_0_0_2 - 9.13149350649613e-06*G0_1_0_0_3 - 9.13149350649181e-06*G0_1_0_0_4 + 2.43506493506454e-05*G0_1_0_0_5 + 0.00112317370129875*G0_1_0_0_6 + 2.43506493506472e-05*G0_1_0_0_7 + 0.00112317370129874*G0_1_0_0_8 + 0.000267857142857152*G0_1_0_0_9 + 0.000851934523809557*G0_1_0_1_0 + 0.011194534632035*G0_1_0_1_1 + 0.000970643939393975*G0_1_0_1_2 + 0.00375913149350661*G0_1_0_1_3 - 0.00193587662337668*G0_1_0_1_4 - 0.000447443181818199*G0_1_0_1_5 + 0.000566152597402622*G0_1_0_1_6 - 0.00348823051948065*G0_1_0_1_7 + 0.00823356331168861*G0_1_0_1_8 + 0.000980113636363673*G0_1_0_1_9 + 0.000851934523809558*G0_1_0_2_0 + 0.000970643939393974*G0_1_0_2_1 + 0.011194534632035*G0_1_0_2_2 - 0.0019358766233767*G0_1_0_2_3 + 0.00375913149350664*G0_1_0_2_4 - 0.00348823051948065*G0_1_0_2_5 + 0.00823356331168863*G0_1_0_2_6 - 0.000447443181818197*G0_1_0_2_7 + 0.000566152597402616*G0_1_0_2_8 + 0.000980113636363672*G0_1_0_2_9 - 9.13149350649615e-06*G0_1_0_3_0 + 0.00375913149350661*G0_1_0_3_1 - 0.0019358766233767*G0_1_0_3_2 - 0.00321428571428585*G0_1_0_3_3 - 0.000748782467532496*G0_1_0_3_4 + 0.00124188311688316*G0_1_0_3_5 - 0.0028125000000001*G0_1_0_3_6 - 0.00108664772727276*G0_1_0_3_7 + 0.00389914772727285*G0_1_0_3_8 - 0.000767045454545493*G0_1_0_3_9 - 9.13149350649179e-06*G0_1_0_4_0 - 0.00193587662337668*G0_1_0_4_1 + 0.00375913149350664*G0_1_0_4_2 - 0.000748782467532496*G0_1_0_4_3 - 0.00321428571428582*G0_1_0_4_4 - 0.00108664772727277*G0_1_0_4_5 + 0.00389914772727288*G0_1_0_4_6 + 0.00124188311688316*G0_1_0_4_7 - 0.00281250000000009*G0_1_0_4_8 - 0.000767045454545478*G0_1_0_4_9 + 2.43506493506454e-05*G0_1_0_5_0 - 0.000447443181818199*G0_1_0_5_1 - 0.00348823051948065*G0_1_0_5_2 + 0.00124188311688316*G0_1_0_5_3 - 0.00108664772727277*G0_1_0_5_4 - 0.0018993506493507*G0_1_0_5_5 - 0.00658380681818206*G0_1_0_5_6 - 0.000456574675324691*G0_1_0_5_7 + 0.000228287337662346*G0_1_0_5_8 - 0.00126014610389615*G0_1_0_5_9 + 0.00112317370129875*G0_1_0_6_0 + 0.000566152597402622*G0_1_0_6_1 + 0.00823356331168863*G0_1_0_6_2 - 0.0028125000000001*G0_1_0_6_3 + 0.00389914772727288*G0_1_0_6_4 - 0.00658380681818206*G0_1_0_6_5 + 0.022262581168832*G0_1_0_6_6 + 0.000228287337662345*G0_1_0_6_7 - 0.00114143668831172*G0_1_0_6_8 + 0.00268465909090919*G0_1_0_6_9 + 2.43506493506472e-05*G0_1_0_7_0 - 0.00348823051948065*G0_1_0_7_1 - 0.000447443181818197*G0_1_0_7_2 - 0.00108664772727276*G0_1_0_7_3 + 0.00124188311688316*G0_1_0_7_4 - 0.000456574675324691*G0_1_0_7_5 + 0.000228287337662345*G0_1_0_7_6 - 0.00189935064935072*G0_1_0_7_7 - 0.00658380681818205*G0_1_0_7_8 - 0.00126014610389614*G0_1_0_7_9 + 0.00112317370129874*G0_1_0_8_0 + 0.00823356331168861*G0_1_0_8_1 + 0.000566152597402616*G0_1_0_8_2 + 0.00389914772727285*G0_1_0_8_3 - 0.00281250000000009*G0_1_0_8_4 + 0.000228287337662346*G0_1_0_8_5 - 0.00114143668831172*G0_1_0_8_6 - 0.00658380681818205*G0_1_0_8_7 + 0.0222625811688319*G0_1_0_8_8 + 0.00268465909090917*G0_1_0_8_9 + 0.000267857142857152*G0_1_0_9_0 + 0.000980113636363673*G0_1_0_9_1 + 0.000980113636363672*G0_1_0_9_2 - 0.000767045454545492*G0_1_0_9_3 - 0.000767045454545478*G0_1_0_9_4 - 0.00126014610389615*G0_1_0_9_5 + 0.00268465909090919*G0_1_0_9_6 - 0.00126014610389614*G0_1_0_9_7 + 0.00268465909090917*G0_1_0_9_8 + 0.0105194805194809*G0_1_0_9_9;
    A[1] = -A[21] - 0.011194534632035*G0_0_0_0_0 - 0.000970643939393976*G0_0_0_0_1 - 0.000851934523809553*G0_0_0_0_2 - 0.000566152597402621*G0_0_0_0_3 + 0.0004474431818182*G0_0_0_0_4 - 0.00823356331168858*G0_0_0_0_5 + 0.00348823051948063*G0_0_0_0_6 - 0.00375913149350661*G0_0_0_0_7 + 0.00193587662337668*G0_0_0_0_8 - 0.000980113636363677*G0_0_0_0_9 - 0.000970643939393976*G0_0_0_1_0 - 0.011194534632035*G0_0_0_1_1 - 0.000851934523809553*G0_0_0_1_2 - 0.0082335633116886*G0_0_0_1_3 + 0.00348823051948064*G0_0_0_1_4 - 0.000566152597402615*G0_0_0_1_5 + 0.000447443181818198*G0_0_0_1_6 + 0.0019358766233767*G0_0_0_1_7 - 0.00375913149350665*G0_0_0_1_8 - 0.000980113636363678*G0_0_0_1_9 - 0.000851934523809553*G0_0_0_2_0 - 0.000851934523809553*G0_0_0_2_1 - 0.00170386904761911*G0_0_0_2_2 - 0.00112317370129874*G0_0_0_2_3 - 0.00112317370129874*G0_0_0_2_5 - 0.000267857142857154*G0_0_0_2_9 - 0.000566152597402621*G0_0_0_3_0 - 0.0082335633116886*G0_0_0_3_1 - 0.00112317370129874*G0_0_0_3_2 - 0.022262581168832*G0_0_0_3_3 + 0.00658380681818205*G0_0_0_3_4 + 0.00114143668831173*G0_0_0_3_5 - 0.00022828733766234*G0_0_0_3_6 + 0.00281250000000011*G0_0_0_3_7 - 0.00389914772727289*G0_0_0_3_8 - 0.0026846590909092*G0_0_0_3_9 + 0.0004474431818182*G0_0_0_4_0 + 0.00348823051948064*G0_0_0_4_1 + 0.00658380681818205*G0_0_0_4_3 + 0.00189935064935072*G0_0_0_4_4 - 0.000228287337662343*G0_0_0_4_5 + 0.000456574675324688*G0_0_0_4_6 - 0.00124188311688317*G0_0_0_4_7 + 0.00108664772727278*G0_0_0_4_8 + 0.00126014610389615*G0_0_0_4_9 - 0.00823356331168858*G0_0_0_5_0 - 0.000566152597402615*G0_0_0_5_1 - 0.00112317370129874*G0_0_0_5_2 + 0.00114143668831173*G0_0_0_5_3 - 0.000228287337662343*G0_0_0_5_4 - 0.0222625811688319*G0_0_0_5_5 + 0.00658380681818204*G0_0_0_5_6 - 0.00389914772727286*G0_0_0_5_7 + 0.0028125000000001*G0_0_0_5_8 - 0.00268465909090919*G0_0_0_5_9 + 0.00348823051948063*G0_0_0_6_0 + 0.000447443181818198*G0_0_0_6_1 - 0.00022828733766234*G0_0_0_6_3 + 0.000456574675324688*G0_0_0_6_4 + 0.00658380681818204*G0_0_0_6_5 + 0.00189935064935072*G0_0_0_6_6 + 0.00108664772727276*G0_0_0_6_7 - 0.00124188311688316*G0_0_0_6_8 + 0.00126014610389615*G0_0_0_6_9 - 0.00375913149350661*G0_0_0_7_0 + 0.0019358766233767*G0_0_0_7_1 + 0.00281250000000011*G0_0_0_7_3 - 0.00124188311688317*G0_0_0_7_4 - 0.00389914772727286*G0_0_0_7_5 + 0.00108664772727276*G0_0_0_7_6 + 0.00321428571428583*G0_0_0_7_7 + 0.000748782467532511*G0_0_0_7_8 + 0.000767045454545488*G0_0_0_7_9 + 0.00193587662337668*G0_0_0_8_0 - 0.00375913149350665*G0_0_0_8_1 - 0.00389914772727289*G0_0_0_8_3 + 0.00108664772727278*G0_0_0_8_4 + 0.0028125000000001*G0_0_0_8_5 - 0.00124188311688316*G0_0_0_8_6 + 0.000748782467532511*G0_0_0_8_7 + 0.00321428571428579*G0_0_0_8_8 + 0.000767045454545472*G0_0_0_8_9 - 0.000980113636363677*G0_0_0_9_0 - 0.000980113636363678*G0_0_0_9_1 - 0.000267857142857154*G0_0_0_9_2 - 0.0026846590909092*G0_0_0_9_3 + 0.00126014610389615*G0_0_0_9_4 - 0.00268465909090919*G0_0_0_9_5 + 0.00126014610389615*G0_0_0_9_6 + 0.000767045454545488*G0_0_0_9_7 + 0.000767045454545472*G0_0_0_9_8 - 0.0105194805194809*G0_0_0_9_9 - 0.0094906655844159*G0_1_0_0_0 - 0.000118709415584419*G0_1_0_0_1 - 0.000575284090909117*G0_1_0_0_3 + 0.000438311688311708*G0_1_0_0_4 - 0.00820921266233793*G0_1_0_0_5 + 0.00461140422077938*G0_1_0_0_6 - 0.00373478084415597*G0_1_0_0_7 + 0.00305905032467543*G0_1_0_0_8 - 0.000712256493506524*G0_1_0_0_9 - 0.000118709415584419*G0_1_0_1_0 + 0.000118709415584422*G0_1_0_1_2 - 0.00447443181818197*G0_1_0_1_3 + 0.00155235389610395*G0_1_0_1_4 - 0.00101359577922081*G0_1_0_1_5 + 0.00101359577922082*G0_1_0_1_6 - 0.00155235389610395*G0_1_0_1_7 + 0.00447443181818197*G0_1_0_1_8 + 0.000118709415584422*G0_1_0_2_1 + 0.00949066558441593*G0_1_0_2_2 - 0.00305905032467543*G0_1_0_2_3 + 0.00373478084415599*G0_1_0_2_4 - 0.00461140422077939*G0_1_0_2_5 + 0.00820921266233797*G0_1_0_2_6 - 0.000438311688311701*G0_1_0_2_7 + 0.000575284090909107*G0_1_0_2_8 + 0.000712256493506518*G0_1_0_2_9 - 0.000575284090909117*G0_1_0_3_0 - 0.00447443181818197*G0_1_0_3_1 - 0.00305905032467543*G0_1_0_3_2 - 0.0254768668831178*G0_1_0_3_3 + 0.00583502435064954*G0_1_0_3_4 + 0.00238331980519489*G0_1_0_3_5 - 0.00304078733766244*G0_1_0_3_6 + 0.00172585227272735*G0_1_0_3_7 - 0.00345170454545469*G0_1_0_3_9 + 0.000438311688311708*G0_1_0_4_0 + 0.00155235389610395*G0_1_0_4_1 + 0.00373478084415599*G0_1_0_4_2 + 0.00583502435064954*G0_1_0_4_3 - 0.0013149350649351*G0_1_0_4_4 - 0.00131493506493511*G0_1_0_4_5 + 0.00435572240259756*G0_1_0_4_6 - 0.00172585227272732*G0_1_0_4_8 + 0.000493100649350676*G0_1_0_4_9 - 0.00820921266233794*G0_1_0_5_0 - 0.00101359577922081*G0_1_0_5_1 - 0.00461140422077939*G0_1_0_5_2 + 0.00238331980519489*G0_1_0_5_3 - 0.00131493506493511*G0_1_0_5_4 - 0.0241619318181826*G0_1_0_5_5 - 0.00435572240259755*G0_1_0_5_7 + 0.00304078733766244*G0_1_0_5_8 - 0.00394480519480534*G0_1_0_5_9 + 0.00461140422077938*G0_1_0_6_0 + 0.00101359577922082*G0_1_0_6_1 + 0.00820921266233797*G0_1_0_6_2 - 0.00304078733766244*G0_1_0_6_3 + 0.00435572240259756*G0_1_0_6_4 + 0.0241619318181827*G0_1_0_6_6 + 0.00131493506493511*G0_1_0_6_7 - 0.00238331980519488*G0_1_0_6_8 + 0.00394480519480534*G0_1_0_6_9 - 0.00373478084415597*G0_1_0_7_0 - 0.00155235389610395*G0_1_0_7_1 - 0.000438311688311701*G0_1_0_7_2 + 0.00172585227272735*G0_1_0_7_3 - 0.00435572240259755*G0_1_0_7_5 + 0.00131493506493511*G0_1_0_7_6 + 0.00131493506493512*G0_1_0_7_7 - 0.00583502435064954*G0_1_0_7_8 - 0.000493100649350655*G0_1_0_7_9 + 0.00305905032467543*G0_1_0_8_0 + 0.00447443181818197*G0_1_0_8_1 + 0.000575284090909107*G0_1_0_8_2 - 0.00172585227272732*G0_1_0_8_4 + 0.00304078733766244*G0_1_0_8_5 - 0.00238331980519488*G0_1_0_8_6 - 0.00583502435064954*G0_1_0_8_7 + 0.0254768668831177*G0_1_0_8_8 + 0.00345170454545465*G0_1_0_8_9 - 0.000712256493506524*G0_1_0_9_0 + 0.000712256493506518*G0_1_0_9_2 - 0.00345170454545469*G0_1_0_9_3 + 0.000493100649350676*G0_1_0_9_4 - 0.00394480519480534*G0_1_0_9_5 + 0.00394480519480534*G0_1_0_9_6 - 0.000493100649350655*G0_1_0_9_7 + 0.00345170454545465*G0_1_0_9_8;
    A[72] = -A[82] + 0.00949066558441591*G0_0_1_0_0 + 0.000118709415584416*G0_0_1_0_2 - 0.000438311688311704*G0_0_1_0_3 + 0.00057528409090911*G0_0_1_0_4 + 0.00373478084415597*G0_0_1_0_5 - 0.00305905032467544*G0_0_1_0_6 + 0.00820921266233794*G0_0_1_0_7 - 0.00461140422077938*G0_0_1_0_8 + 0.000712256493506521*G0_0_1_0_9 - 0.0094906655844159*G0_0_1_1_1 - 0.000118709415584421*G0_0_1_1_2 - 0.00373478084415596*G0_0_1_1_3 + 0.00305905032467542*G0_0_1_1_4 + 0.000438311688311704*G0_0_1_1_5 - 0.000575284090909117*G0_0_1_1_6 + 0.00461140422077938*G0_0_1_1_7 - 0.00820921266233796*G0_0_1_1_8 - 0.000712256493506521*G0_0_1_1_9 + 0.000118709415584416*G0_0_1_2_0 - 0.000118709415584422*G0_0_1_2_1 - 0.00155235389610394*G0_0_1_2_3 + 0.00447443181818195*G0_0_1_2_4 + 0.00155235389610396*G0_0_1_2_5 - 0.004474431818182*G0_0_1_2_6 + 0.00101359577922081*G0_0_1_2_7 - 0.00101359577922081*G0_0_1_2_8 - 0.000438311688311704*G0_0_1_3_0 - 0.00373478084415596*G0_0_1_3_1 - 0.00155235389610394*G0_0_1_3_2 + 0.00131493506493513*G0_0_1_3_3 - 0.00583502435064954*G0_0_1_3_4 + 0.00172585227272734*G0_0_1_3_6 + 0.0013149350649351*G0_0_1_3_7 - 0.00435572240259754*G0_0_1_3_8 - 0.000493100649350653*G0_0_1_3_9 + 0.000575284090909111*G0_0_1_4_0 + 0.00305905032467542*G0_0_1_4_1 + 0.00447443181818195*G0_0_1_4_2 - 0.00583502435064954*G0_0_1_4_3 + 0.0254768668831177*G0_0_1_4_4 - 0.00172585227272732*G0_0_1_4_5 - 0.00238331980519489*G0_0_1_4_7 + 0.00304078733766244*G0_0_1_4_8 + 0.00345170454545465*G0_0_1_4_9 + 0.00373478084415597*G0_0_1_5_0 + 0.000438311688311704*G0_0_1_5_1 + 0.00155235389610396*G0_0_1_5_2 - 0.00172585227272732*G0_0_1_5_4 - 0.00131493506493513*G0_0_1_5_5 + 0.00583502435064958*G0_0_1_5_6 + 0.00435572240259754*G0_0_1_5_7 - 0.00131493506493511*G0_0_1_5_8 + 0.000493100649350668*G0_0_1_5_9 - 0.00305905032467544*G0_0_1_6_0 - 0.000575284090909117*G0_0_1_6_1 - 0.004474431818182*G0_0_1_6_2 + 0.00172585227272734*G0_0_1_6_3 + 0.00583502435064958*G0_0_1_6_5 - 0.0254768668831178*G0_0_1_6_6 - 0.00304078733766244*G0_0_1_6_7 + 0.00238331980519488*G0_0_1_6_8 - 0.00345170454545468*G0_0_1_6_9 + 0.00820921266233794*G0_0_1_7_0 + 0.00461140422077938*G0_0_1_7_1 + 0.00101359577922081*G0_0_1_7_2 + 0.0013149350649351*G0_0_1_7_3 - 0.00238331980519489*G0_0_1_7_4 + 0.00435572240259754*G0_0_1_7_5 - 0.00304078733766244*G0_0_1_7_6 + 0.0241619318181826*G0_0_1_7_7 + 0.00394480519480533*G0_0_1_7_9 - 0.00461140422077938*G0_0_1_8_0 - 0.00820921266233796*G0_0_1_8_1 - 0.00101359577922081*G0_0_1_8_2 - 0.00435572240259754*G0_0_1_8_3 + 0.00304078733766244*G0_0_1_8_4 - 0.00131493506493511*G0_0_1_8_5 + 0.00238331980519488*G0_0_1_8_6 - 0.0241619318181826*G0_0_1_8_8 - 0.00394480519480532*G0_0_1_8_9 + 0.000712256493506521*G0_0_1_9_0 - 0.000712256493506521*G0_0_1_9_1 - 0.000493100649350653*G0_0_1_9_3 + 0.00345170454545465*G0_0_1_9_4 + 0.000493100649350668*G0_0_1_9_5 - 0.00345170454545468*G0_0_1_9_6 + 0.00394480519480533*G0_0_1_9_7 - 0.00394480519480532*G0_0_1_9_8 - 0.00265422077922088*G0_1_1_0_0 - 0.00165280032467539*G0_1_1_0_1 + 0.000258725649350659*G0_1_1_0_2 - 0.000210024350649359*G0_1_1_0_3 + 0.00170758928571435*G0_1_1_0_4 - 0.00215503246753254*G0_1_1_0_5 + 0.0014884334415585*G0_1_1_0_6 - 0.00261160714285724*G0_1_1_0_7 + 0.00092228084415587*G0_1_1_0_8 + 0.000219155844155851*G0_1_1_0_9 - 0.00165280032467539*G0_1_1_1_0 - 0.0121448863636368*G0_1_1_1_1 + 0.00014001623376624*G0_1_1_1_2 - 0.00588981331168851*G0_1_1_1_3 + 0.00454748376623392*G0_1_1_1_4 + 0.000228287337662344*G0_1_1_1_5 + 0.00113230519480524*G0_1_1_1_6 + 0.00553368506493526*G0_1_1_1_7 - 0.0108208198051952*G0_1_1_1_8 - 0.000493100649350668*G0_1_1_1_9 + 0.000258725649350659*G0_1_1_2_0 + 0.00014001623376624*G0_1_1_2_1 + 0.00547889610389628*G0_1_1_2_2 - 0.00348823051948063*G0_1_1_2_3 + 0.0082640016233769*G0_1_1_2_4 - 0.00193587662337669*G0_1_1_2_5 + 0.00378956980519493*G0_1_1_2_6 - 0.00157974837662343*G0_1_1_2_7 - 0.00259334415584424*G0_1_1_2_8 + 0.0010409902597403*G0_1_1_2_9 - 0.000210024350649359*G0_1_1_3_0 - 0.00588981331168851*G0_1_1_3_1 - 0.00348823051948063*G0_1_1_3_2 + 0.00788961038961068*G0_1_1_3_3 - 0.00936891233766267*G0_1_1_3_4 + 0.000164366883116892*G0_1_1_3_5 - 0.00378043831168845*G0_1_1_3_6 + 0.000246550324675343*G0_1_1_3_7 - 0.0076430600649353*G0_1_1_3_8 + 0.00098620129870135*G0_1_1_3_9 + 0.00170758928571435*G0_1_1_4_0 + 0.00454748376623392*G0_1_1_4_1 + 0.0082640016233769*G0_1_1_4_2 - 0.00936891233766267*G0_1_1_4_3 + 0.0330377435064947*G0_1_1_4_4 - 0.00550629058441578*G0_1_1_4_5 + 0.00928672889610422*G0_1_1_4_6 + 0.00739650974025997*G0_1_1_4_8 + 0.00788961038961065*G0_1_1_4_9 - 0.00215503246753254*G0_1_1_5_0 + 0.000228287337662344*G0_1_1_5_1 - 0.00193587662337669*G0_1_1_5_2 + 0.000164366883116891*G0_1_1_5_3 - 0.00550629058441578*G0_1_1_5_4 + 0.00657467532467554*G0_1_1_5_5 - 0.00353388798701311*G0_1_1_5_6 - 0.00328733766233777*G0_1_1_5_7 - 0.00106838474025977*G0_1_1_5_8 + 0.001479301948052*G0_1_1_5_9 + 0.0014884334415585*G0_1_1_6_0 + 0.00113230519480524*G0_1_1_6_1 + 0.00378956980519493*G0_1_1_6_2 - 0.00378043831168845*G0_1_1_6_3 + 0.00928672889610422*G0_1_1_6_4 - 0.00353388798701311*G0_1_1_6_5 + 0.00756087662337689*G0_1_1_6_6 + 0.00435572240259755*G0_1_1_6_7 + 0.00238331980519487*G0_1_1_6_8 + 0.00443790584415599*G0_1_1_6_9 - 0.00261160714285724*G0_1_1_7_0 + 0.00553368506493526*G0_1_1_7_1 - 0.00157974837662343*G0_1_1_7_2 + 0.000246550324675344*G0_1_1_7_3 - 0.00328733766233777*G0_1_1_7_5 + 0.00435572240259755*G0_1_1_7_6 - 0.0571996753246773*G0_1_1_7_7 + 0.00665685876623402*G0_1_1_7_8 - 0.00936891233766266*G0_1_1_7_9 + 0.000922280844155871*G0_1_1_8_0 - 0.0108208198051952*G0_1_1_8_1 - 0.00259334415584424*G0_1_1_8_2 - 0.0076430600649353*G0_1_1_8_3 + 0.00739650974025997*G0_1_1_8_4 - 0.00106838474025977*G0_1_1_8_5 + 0.00238331980519487*G0_1_1_8_6 + 0.00665685876623402*G0_1_1_8_7 - 0.0813616071428599*G0_1_1_8_8 - 0.013313717532468*G0_1_1_8_9 + 0.00021915584415585*G0_1_1_9_0 - 0.000493100649350667*G0_1_1_9_1 + 0.0010409902597403*G0_1_1_9_2 + 0.000986201298701352*G0_1_1_9_3 + 0.00788961038961065*G0_1_1_9_4 + 0.001479301948052*G0_1_1_9_5 + 0.00443790584415599*G0_1_1_9_6 - 0.00936891233766266*G0_1_1_9_7 - 0.013313717532468*G0_1_1_9_8 + 0.0493100649350667*G0_1_1_9_9;
    A[15] = -A[16] - 0.00265422077922086*G0_0_0_0_0 + 0.000258725649350658*G0_0_0_0_1 - 0.00165280032467539*G0_0_0_0_2 + 0.00170758928571436*G0_0_0_0_3 - 0.000210024350649363*G0_0_0_0_4 - 0.00261160714285722*G0_0_0_0_5 + 0.000922280844155847*G0_0_0_0_6 - 0.00215503246753254*G0_0_0_0_7 + 0.0014884334415585*G0_0_0_0_8 + 0.000219155844155849*G0_0_0_0_9 + 0.000258725649350659*G0_0_0_1_0 + 0.00547889610389627*G0_0_0_1_1 + 0.000140016233766233*G0_0_0_1_2 + 0.0082640016233769*G0_0_0_1_3 - 0.00348823051948064*G0_0_0_1_4 - 0.00157974837662342*G0_0_0_1_5 - 0.00259334415584426*G0_0_0_1_6 - 0.00193587662337669*G0_0_0_1_7 + 0.00378956980519494*G0_0_0_1_8 + 0.0010409902597403*G0_0_0_1_9 - 0.00165280032467539*G0_0_0_2_0 + 0.000140016233766233*G0_0_0_2_1 - 0.0121448863636368*G0_0_0_2_2 + 0.00454748376623393*G0_0_0_2_3 - 0.00588981331168853*G0_0_0_2_4 + 0.00553368506493527*G0_0_0_2_5 - 0.0108208198051952*G0_0_0_2_6 + 0.000228287337662343*G0_0_0_2_7 + 0.00113230519480524*G0_0_0_2_8 - 0.000493100649350671*G0_0_0_2_9 + 0.00170758928571436*G0_0_0_3_0 + 0.0082640016233769*G0_0_0_3_1 + 0.00454748376623393*G0_0_0_3_2 + 0.0330377435064947*G0_0_0_3_3 - 0.00936891233766265*G0_0_0_3_4 + 0.00739650974025999*G0_0_0_3_6 - 0.00550629058441579*G0_0_0_3_7 + 0.00928672889610425*G0_0_0_3_8 + 0.00788961038961069*G0_0_0_3_9 - 0.000210024350649363*G0_0_0_4_0 - 0.00348823051948064*G0_0_0_4_1 - 0.00588981331168853*G0_0_0_4_2 - 0.00936891233766265*G0_0_0_4_3 + 0.00788961038961065*G0_0_0_4_4 + 0.000246550324675353*G0_0_0_4_5 - 0.00764306006493535*G0_0_0_4_6 + 0.000164366883116895*G0_0_0_4_7 - 0.00378043831168845*G0_0_0_4_8 + 0.000986201298701317*G0_0_0_4_9 - 0.00261160714285722*G0_0_0_5_0 - 0.00157974837662342*G0_0_0_5_1 + 0.00553368506493527*G0_0_0_5_2 + 0.000246550324675353*G0_0_0_5_4 - 0.0571996753246772*G0_0_0_5_5 + 0.00665685876623404*G0_0_0_5_6 - 0.00328733766233777*G0_0_0_5_7 + 0.00435572240259754*G0_0_0_5_8 - 0.00936891233766265*G0_0_0_5_9 + 0.000922280844155847*G0_0_0_6_0 - 0.00259334415584426*G0_0_0_6_1 - 0.0108208198051952*G0_0_0_6_2 + 0.00739650974025999*G0_0_0_6_3 - 0.00764306006493535*G0_0_0_6_4 + 0.00665685876623404*G0_0_0_6_5 - 0.08136160714286*G0_0_0_6_6 - 0.00106838474025978*G0_0_0_6_7 + 0.00238331980519488*G0_0_0_6_8 - 0.013313717532468*G0_0_0_6_9 - 0.00215503246753254*G0_0_0_7_0 - 0.00193587662337669*G0_0_0_7_1 + 0.000228287337662343*G0_0_0_7_2 - 0.00550629058441579*G0_0_0_7_3 + 0.000164366883116895*G0_0_0_7_4 - 0.00328733766233777*G0_0_0_7_5 - 0.00106838474025978*G0_0_0_7_6 + 0.00657467532467555*G0_0_0_7_7 - 0.00353388798701312*G0_0_0_7_8 + 0.00147930194805199*G0_0_0_7_9 + 0.0014884334415585*G0_0_0_8_0 + 0.00378956980519494*G0_0_0_8_1 + 0.00113230519480524*G0_0_0_8_2 + 0.00928672889610425*G0_0_0_8_3 - 0.00378043831168845*G0_0_0_8_4 + 0.00435572240259754*G0_0_0_8_5 + 0.00238331980519488*G0_0_0_8_6 - 0.00353388798701312*G0_0_0_8_7 + 0.00756087662337692*G0_0_0_8_8 + 0.004437905844156*G0_0_0_8_9 + 0.00021915584415585*G0_0_0_9_0 + 0.0010409902597403*G0_0_0_9_1 - 0.000493100649350671*G0_0_0_9_2 + 0.00788961038961069*G0_0_0_9_3 + 0.000986201298701317*G0_0_0_9_4 - 0.00936891233766265*G0_0_0_9_5 - 0.013313717532468*G0_0_0_9_6 + 0.00147930194805199*G0_0_0_9_7 + 0.004437905844156*G0_0_0_9_8 + 0.0493100649350666*G0_0_0_9_9 + 0.0094906655844159*G0_0_1_0_0 + 0.000118709415584417*G0_0_1_0_1 + 0.000575284090909116*G0_0_1_0_3 - 0.000438311688311709*G0_0_1_0_4 + 0.00820921266233793*G0_0_1_0_5 - 0.00461140422077938*G0_0_1_0_6 + 0.00373478084415597*G0_0_1_0_7 - 0.00305905032467543*G0_0_1_0_8 + 0.000712256493506522*G0_0_1_0_9 + 0.000118709415584418*G0_0_1_1_0 - 0.000118709415584423*G0_0_1_1_2 + 0.00447443181818196*G0_0_1_1_3 - 0.00155235389610395*G0_0_1_1_4 + 0.00101359577922081*G0_0_1_1_5 - 0.00101359577922082*G0_0_1_1_6 + 0.00155235389610395*G0_0_1_1_7 - 0.00447443181818198*G0_0_1_1_8 - 0.000118709415584424*G0_0_1_2_1 - 0.00949066558441594*G0_0_1_2_2 + 0.00305905032467544*G0_0_1_2_3 - 0.00373478084415599*G0_0_1_2_4 + 0.00461140422077939*G0_0_1_2_5 - 0.00820921266233798*G0_0_1_2_6 + 0.000438311688311701*G0_0_1_2_7 - 0.000575284090909108*G0_0_1_2_8 - 0.000712256493506518*G0_0_1_2_9 + 0.000575284090909116*G0_0_1_3_0 + 0.00447443181818196*G0_0_1_3_1 + 0.00305905032467544*G0_0_1_3_2 + 0.0254768668831178*G0_0_1_3_3 - 0.00583502435064954*G0_0_1_3_4 - 0.00238331980519489*G0_0_1_3_5 + 0.00304078733766244*G0_0_1_3_6 - 0.00172585227272734*G0_0_1_3_7 + 0.00345170454545469*G0_0_1_3_9 - 0.000438311688311709*G0_0_1_4_0 - 0.00155235389610395*G0_0_1_4_1 - 0.00373478084415599*G0_0_1_4_2 - 0.00583502435064954*G0_0_1_4_3 + 0.00131493506493508*G0_0_1_4_4 + 0.00131493506493512*G0_0_1_4_5 - 0.00435572240259757*G0_0_1_4_6 + 0.00172585227272732*G0_0_1_4_8 - 0.000493100649350681*G0_0_1_4_9 + 0.00820921266233793*G0_0_1_5_0 + 0.00101359577922081*G0_0_1_5_1 + 0.00461140422077939*G0_0_1_5_2 - 0.00238331980519489*G0_0_1_5_3 + 0.00131493506493512*G0_0_1_5_4 + 0.0241619318181826*G0_0_1_5_5 + 0.00435572240259754*G0_0_1_5_7 - 0.00304078733766244*G0_0_1_5_8 + 0.00394480519480533*G0_0_1_5_9 - 0.00461140422077938*G0_0_1_6_0 - 0.00101359577922082*G0_0_1_6_1 - 0.00820921266233798*G0_0_1_6_2 + 0.00304078733766244*G0_0_1_6_3 - 0.00435572240259757*G0_0_1_6_4 - 0.0241619318181827*G0_0_1_6_6 - 0.00131493506493511*G0_0_1_6_7 + 0.00238331980519488*G0_0_1_6_8 - 0.00394480519480534*G0_0_1_6_9 + 0.00373478084415597*G0_0_1_7_0 + 0.00155235389610395*G0_0_1_7_1 + 0.000438311688311702*G0_0_1_7_2 - 0.00172585227272734*G0_0_1_7_3 + 0.00435572240259754*G0_0_1_7_5 - 0.00131493506493511*G0_0_1_7_6 - 0.00131493506493511*G0_0_1_7_7 + 0.00583502435064955*G0_0_1_7_8 + 0.000493100649350657*G0_0_1_7_9 - 0.00305905032467543*G0_0_1_8_0 - 0.00447443181818198*G0_0_1_8_1 - 0.000575284090909108*G0_0_1_8_2 + 0.00172585227272732*G0_0_1_8_4 - 0.00304078733766244*G0_0_1_8_5 + 0.00238331980519488*G0_0_1_8_6 + 0.00583502435064955*G0_0_1_8_7 - 0.0254768668831177*G0_0_1_8_8 - 0.00345170454545465*G0_0_1_8_9 + 0.000712256493506522*G0_0_1_9_0 - 0.000712256493506518*G0_0_1_9_2 + 0.00345170454545469*G0_0_1_9_3 - 0.000493100649350679*G0_0_1_9_4 + 0.00394480519480533*G0_0_1_9_5 - 0.00394480519480534*G0_0_1_9_6 + 0.000493100649350657*G0_0_1_9_7 - 0.00345170454545465*G0_0_1_9_8;
    A[51] = A[15] - 0.0164671266233772*G0_0_1_0_0 - 0.000566152597402615*G0_0_1_0_1 - 0.00109882305194809*G0_0_1_0_2 + 0.000219155844155851*G0_0_1_0_3 + 0.000273944805194817*G0_0_1_0_4 - 0.0111312905844159*G0_0_1_0_5 + 0.00366172889610402*G0_0_1_0_6 - 0.00599025974025994*G0_0_1_0_7 + 0.00373478084415597*G0_0_1_0_8 - 0.00109577922077926*G0_0_1_0_9 - 0.000566152597402615*G0_0_1_1_0 - 0.000447443181818199*G0_0_1_1_2 - 0.00223721590909098*G0_0_1_1_3 + 0.000693993506493524*G0_0_1_1_4 + 0.00101359577922081*G0_0_1_1_6 - 0.000858360389610425*G0_0_1_1_7 + 0.002237215909091*G0_0_1_1_8 + 0.000164366883116884*G0_0_1_1_9 - 0.00109882305194809*G0_0_1_2_0 - 0.000447443181818199*G0_0_1_2_1 - 0.00697646103896131*G0_0_1_2_2 + 0.000675730519480551*G0_0_1_2_3 - 0.00225547889610399*G0_0_1_2_4 - 0.000949675324675343*G0_0_1_2_5 - 0.00292207792207804*G0_0_1_2_6 - 0.000164366883116887*G0_0_1_2_7 + 0.000794439935064962*G0_0_1_2_8 - 0.000383522727272743*G0_0_1_2_9 + 0.000219155844155851*G0_0_1_3_0 - 0.00223721590909098*G0_0_1_3_1 + 0.000675730519480551*G0_0_1_3_2 - 0.0144642857142862*G0_0_1_3_3 + 0.00254768668831178*G0_0_1_3_4 - 0.00065746753246755*G0_0_1_3_5 - 0.00238331980519487*G0_0_1_3_6 + 0.00172585227272732*G0_0_1_3_8 - 0.000493100649350663*G0_0_1_3_9 + 0.000273944805194817*G0_0_1_4_0 + 0.000693993506493524*G0_0_1_4_1 - 0.00225547889610399*G0_0_1_4_2 + 0.00254768668831178*G0_0_1_4_3 + 0.0121631493506498*G0_0_1_4_4 - 0.000164366883116886*G0_0_1_4_5 + 0.00254768668831176*G0_0_1_4_6 - 0.000493100649350669*G0_0_1_4_7 - 0.00172585227272733*G0_0_1_4_8 + 0.001479301948052*G0_0_1_4_9 - 0.0111312905844159*G0_0_1_5_0 - 0.000949675324675343*G0_0_1_5_2 - 0.00065746753246755*G0_0_1_5_3 - 0.000164366883116886*G0_0_1_5_4 + 0.0120809659090913*G0_0_1_5_6 - 0.00180803571428578*G0_0_1_5_7 + 0.000657467532467566*G0_0_1_5_8 + 0.00197240259740263*G0_0_1_5_9 + 0.00366172889610402*G0_0_1_6_0 + 0.00101359577922081*G0_0_1_6_1 - 0.00292207792207804*G0_0_1_6_2 - 0.00238331980519487*G0_0_1_6_3 + 0.00254768668831176*G0_0_1_6_4 + 0.0120809659090913*G0_0_1_6_5 + 0.0241619318181826*G0_0_1_6_6 + 0.00115056818181822*G0_0_1_6_7 - 0.00304078733766244*G0_0_1_6_8 + 0.00591720779220798*G0_0_1_6_9 - 0.00599025974025994*G0_0_1_7_0 - 0.000858360389610425*G0_0_1_7_1 - 0.000164366883116887*G0_0_1_7_2 - 0.000493100649350669*G0_0_1_7_4 - 0.00180803571428578*G0_0_1_7_5 + 0.00115056818181822*G0_0_1_7_6 + 0.0134780844155849*G0_0_1_7_7 - 0.00328733766233778*G0_0_1_7_8 + 0.000986201298701329*G0_0_1_7_9 + 0.00373478084415597*G0_0_1_8_0 + 0.002237215909091*G0_0_1_8_1 + 0.000794439935064961*G0_0_1_8_2 + 0.00172585227272732*G0_0_1_8_3 - 0.00172585227272733*G0_0_1_8_4 + 0.000657467532467566*G0_0_1_8_5 - 0.00304078733766244*G0_0_1_8_6 - 0.00328733766233778*G0_0_1_8_7 + 0.0110125811688316*G0_0_1_8_8 + 0.00295860389610401*G0_0_1_8_9 - 0.00109577922077926*G0_0_1_9_0 + 0.000164366883116883*G0_0_1_9_1 - 0.000383522727272743*G0_0_1_9_2 - 0.000493100649350663*G0_0_1_9_3 + 0.001479301948052*G0_0_1_9_4 + 0.00197240259740263*G0_0_1_9_5 + 0.00591720779220798*G0_0_1_9_6 + 0.000986201298701329*G0_0_1_9_7 + 0.00295860389610401*G0_0_1_9_8 - 0.0295860389610399*G0_0_1_9_9 + 0.0164671266233772*G0_1_0_0_0 + 0.000566152597402615*G0_1_0_0_1 + 0.00109882305194809*G0_1_0_0_2 - 0.000219155844155852*G0_1_0_0_3 - 0.000273944805194817*G0_1_0_0_4 + 0.0111312905844159*G0_1_0_0_5 - 0.00366172889610402*G0_1_0_0_6 + 0.00599025974025994*G0_1_0_0_7 - 0.00373478084415597*G0_1_0_0_8 + 0.00109577922077926*G0_1_0_0_9 + 0.000566152597402615*G0_1_0_1_0 + 0.000447443181818199*G0_1_0_1_2 + 0.00223721590909098*G0_1_0_1_3 - 0.000693993506493525*G0_1_0_1_4 - 0.00101359577922081*G0_1_0_1_6 + 0.000858360389610425*G0_1_0_1_7 - 0.002237215909091*G0_1_0_1_8 - 0.000164366883116883*G0_1_0_1_9 + 0.00109882305194809*G0_1_0_2_0 + 0.000447443181818199*G0_1_0_2_1 + 0.00697646103896131*G0_1_0_2_2 - 0.000675730519480551*G0_1_0_2_3 + 0.00225547889610399*G0_1_0_2_4 + 0.000949675324675344*G0_1_0_2_5 + 0.00292207792207804*G0_1_0_2_6 + 0.000164366883116888*G0_1_0_2_7 - 0.000794439935064962*G0_1_0_2_8 + 0.000383522727272743*G0_1_0_2_9 - 0.000219155844155852*G0_1_0_3_0 + 0.00223721590909098*G0_1_0_3_1 - 0.000675730519480551*G0_1_0_3_2 + 0.0144642857142862*G0_1_0_3_3 - 0.00254768668831178*G0_1_0_3_4 + 0.00065746753246755*G0_1_0_3_5 + 0.00238331980519487*G0_1_0_3_6 - 0.00172585227272733*G0_1_0_3_8 + 0.000493100649350663*G0_1_0_3_9 - 0.000273944805194817*G0_1_0_4_0 - 0.000693993506493524*G0_1_0_4_1 + 0.00225547889610399*G0_1_0_4_2 - 0.00254768668831178*G0_1_0_4_3 - 0.0121631493506498*G0_1_0_4_4 + 0.000164366883116885*G0_1_0_4_5 - 0.00254768668831176*G0_1_0_4_6 + 0.000493100649350669*G0_1_0_4_7 + 0.00172585227272733*G0_1_0_4_8 - 0.001479301948052*G0_1_0_4_9 + 0.0111312905844159*G0_1_0_5_0 + 0.000949675324675344*G0_1_0_5_2 + 0.00065746753246755*G0_1_0_5_3 + 0.000164366883116885*G0_1_0_5_4 - 0.0120809659090913*G0_1_0_5_6 + 0.00180803571428578*G0_1_0_5_7 - 0.000657467532467567*G0_1_0_5_8 - 0.00197240259740263*G0_1_0_5_9 - 0.00366172889610402*G0_1_0_6_0 - 0.00101359577922081*G0_1_0_6_1 + 0.00292207792207804*G0_1_0_6_2 + 0.00238331980519487*G0_1_0_6_3 - 0.00254768668831176*G0_1_0_6_4 - 0.0120809659090913*G0_1_0_6_5 - 0.0241619318181826*G0_1_0_6_6 - 0.00115056818181822*G0_1_0_6_7 + 0.00304078733766244*G0_1_0_6_8 - 0.00591720779220798*G0_1_0_6_9 + 0.00599025974025994*G0_1_0_7_0 + 0.000858360389610425*G0_1_0_7_1 + 0.000164366883116888*G0_1_0_7_2 + 0.000493100649350669*G0_1_0_7_4 + 0.00180803571428578*G0_1_0_7_5 - 0.00115056818181822*G0_1_0_7_6 - 0.0134780844155849*G0_1_0_7_7 + 0.00328733766233778*G0_1_0_7_8 - 0.000986201298701328*G0_1_0_7_9 - 0.00373478084415597*G0_1_0_8_0 - 0.002237215909091*G0_1_0_8_1 - 0.000794439935064962*G0_1_0_8_2 - 0.00172585227272732*G0_1_0_8_3 + 0.00172585227272733*G0_1_0_8_4 - 0.000657467532467567*G0_1_0_8_5 + 0.00304078733766244*G0_1_0_8_6 + 0.00328733766233778*G0_1_0_8_7 - 0.0110125811688316*G0_1_0_8_8 - 0.00295860389610401*G0_1_0_8_9 + 0.00109577922077926*G0_1_0_9_0 - 0.000164366883116883*G0_1_0_9_1 + 0.000383522727272743*G0_1_0_9_2 + 0.000493100649350662*G0_1_0_9_3 - 0.001479301948052*G0_1_0_9_4 - 0.00197240259740263*G0_1_0_9_5 - 0.00591720779220798*G0_1_0_9_6 - 0.000986201298701328*G0_1_0_9_7 - 0.00295860389610401*G0_1_0_9_8 + 0.0295860389610399*G0_1_0_9_9;
    A[31] = A[51] + 0.00254464285714293*G0_0_0_0_0 + 0.00127232142857148*G0_0_0_0_1 + 0.00483969155844175*G0_0_0_0_3 - 0.00359780844155858*G0_0_0_0_4 + 0.00463879870129886*G0_0_0_0_5 - 0.00505884740259758*G0_0_0_0_6 + 0.000620941558441569*G0_0_0_0_7 + 0.002976866883117*G0_0_0_0_8 + 0.00241071428571438*G0_0_0_0_9 + 0.00127232142857148*G0_0_0_1_0 + 0.0130275974025979*G0_0_0_1_1 + 0.00103490259740263*G0_0_0_1_2 + 0.019267451298702*G0_0_0_1_3 - 0.00818181818181847*G0_0_0_1_4 + 0.000894886363636393*G0_0_0_1_5 - 0.00113230519480524*G0_0_0_1_6 - 0.00507711038961059*G0_0_0_1_7 + 0.0103185876623381*G0_0_0_1_8 + 0.00339691558441571*G0_0_0_1_9 + 0.00103490259740263*G0_0_0_2_1 - 0.0164366883116889*G0_0_0_2_2 + 0.00909496753246785*G0_0_0_2_3 - 0.00684862012987039*G0_0_0_2_4 + 0.00416396103896121*G0_0_0_2_5 - 0.0117796266233771*G0_0_0_2_6 - 0.00272118506493516*G0_0_0_2_7 + 0.00368912337662351*G0_0_0_2_8 + 0.000986201298701333*G0_0_0_2_9 + 0.00483969155844175*G0_0_0_3_0 + 0.019267451298702*G0_0_0_3_1 + 0.00909496753246785*G0_0_0_3_2 + 0.0867857142857174*G0_0_0_3_3 - 0.026627435064936*G0_0_0_3_4 - 0.00690340909090933*G0_0_0_3_5 - 0.0179159902597409*G0_0_0_3_7 + 0.0323802759740272*G0_0_0_3_8 + 0.0256412337662347*G0_0_0_3_9 - 0.00359780844155857*G0_0_0_4_0 - 0.00818181818181847*G0_0_0_4_1 - 0.00684862012987039*G0_0_0_4_2 - 0.026627435064936*G0_0_0_4_3 + 0.00739650974025999*G0_0_0_4_5 - 0.00739650974026001*G0_0_0_4_6 + 0.0111769480519484*G0_0_0_4_7 - 0.0144642857142862*G0_0_0_4_8 - 0.017751623376624*G0_0_0_4_9 + 0.00463879870129885*G0_0_0_5_0 + 0.000894886363636393*G0_0_0_5_1 + 0.00416396103896121*G0_0_0_5_2 - 0.00690340909090933*G0_0_0_5_3 + 0.00739650974025999*G0_0_0_5_4 + 0.0335308441558452*G0_0_0_5_5 + 0.010355113636364*G0_0_0_5_6 + 0.00131493506493511*G0_0_0_5_7 - 0.00608157467532488*G0_0_0_5_8 + 0.00493100649350665*G0_0_0_5_9 - 0.00505884740259758*G0_0_0_6_0 - 0.00113230519480524*G0_0_0_6_1 - 0.0117796266233771*G0_0_0_6_2 - 0.00739650974026001*G0_0_0_6_4 + 0.010355113636364*G0_0_0_6_5 - 0.01479301948052*G0_0_0_6_6 + 0.00476663961038977*G0_0_0_6_7 - 0.00213676948051956*G0_0_0_6_8 - 0.00295860389610401*G0_0_0_6_9 + 0.000620941558441569*G0_0_0_7_0 - 0.00507711038961059*G0_0_0_7_1 - 0.00272118506493516*G0_0_0_7_2 - 0.0179159902597409*G0_0_0_7_3 + 0.0111769480519484*G0_0_0_7_4 + 0.00131493506493511*G0_0_0_7_5 + 0.00476663961038977*G0_0_0_7_6 - 0.00262987012987021*G0_0_0_7_7 - 0.0149573863636369*G0_0_0_7_8 - 0.0167654220779227*G0_0_0_7_9 + 0.002976866883117*G0_0_0_8_0 + 0.0103185876623381*G0_0_0_8_1 + 0.00368912337662351*G0_0_0_8_2 + 0.0323802759740272*G0_0_0_8_3 - 0.0144642857142862*G0_0_0_8_4 - 0.00608157467532488*G0_0_0_8_5 - 0.00213676948051956*G0_0_0_8_6 - 0.0149573863636369*G0_0_0_8_7 + 0.0358319805194819*G0_0_0_8_8 + 0.0187378246753254*G0_0_0_8_9 + 0.00241071428571438*G0_0_0_9_0 + 0.00339691558441571*G0_0_0_9_1 + 0.000986201298701333*G0_0_0_9_2 + 0.0256412337662347*G0_0_0_9_3 - 0.017751623376624*G0_0_0_9_4 + 0.00493100649350665*G0_0_0_9_5 - 0.00295860389610401*G0_0_0_9_6 - 0.0167654220779227*G0_0_0_9_7 + 0.0187378246753254*G0_0_0_9_8 - 0.0788961038961064*G0_0_0_9_9 - 0.0153348214285719*G0_1_0_0_0 + 0.00766741071428602*G0_1_0_0_1 + 0.0113504464285719*G0_1_0_0_3 - 0.00475750811688329*G0_1_0_0_4 - 0.0120535714285718*G0_1_0_0_5 + 0.0030955762987014*G0_1_0_0_6 - 0.0124918831168836*G0_1_0_0_7 + 0.0187652191558449*G0_1_0_0_8 + 0.0037256493506495*G0_1_0_0_9 + 0.00766741071428602*G0_1_0_1_0 + 0.124736201298706*G0_1_0_1_1 + 0.00778612012987039*G0_1_0_1_2 + 0.0785765016233793*G0_1_0_1_3 - 0.0360146103896116*G0_1_0_1_4 - 0.00223721590909099*G0_1_0_1_5 - 0.00122362012987017*G0_1_0_1_6 - 0.0375669642857157*G0_1_0_1_7 + 0.0830509334415616*G0_1_0_1_8 + 0.0149573863636369*G0_1_0_1_9 + 0.00778612012987039*G0_1_0_2_1 - 0.00584415584415606*G0_1_0_2_2 + 0.0157061688311694*G0_1_0_2_3 - 0.00875710227272758*G0_1_0_2_4 - 0.00151582792207796*G0_1_0_2_5 - 0.00384435876623391*G0_1_0_2_6 - 0.00519581980519499*G0_1_0_2_7 + 0.0119257305194809*G0_1_0_2_8 + 0.004437905844156*G0_1_0_2_9 + 0.0113504464285719*G0_1_0_3_0 + 0.0785765016233793*G0_1_0_3_1 + 0.0157061688311694*G0_1_0_3_2 + 0.16798295454546*G0_1_0_3_3 - 0.0652536525974048*G0_1_0_3_4 - 0.00788961038961066*G0_1_0_3_5 - 0.00788961038961067*G0_1_0_3_6 - 0.0456118100649368*G0_1_0_3_7 + 0.0929494724026008*G0_1_0_3_8 + 0.0463514610389628*G0_1_0_3_9 - 0.00475750811688329*G0_1_0_4_0 - 0.0360146103896116*G0_1_0_4_1 - 0.00875710227272758*G0_1_0_4_2 - 0.0652536525974048*G0_1_0_4_3 + 0.0407629870129884*G0_1_0_4_4 + 0.00271205357142866*G0_1_0_4_5 + 0.00517755681818199*G0_1_0_4_6 + 0.020710227272728*G0_1_0_4_7 - 0.047337662337664*G0_1_0_4_8 - 0.0187378246753254*G0_1_0_4_9 - 0.0120535714285718*G0_1_0_5_0 - 0.00223721590909099*G0_1_0_5_1 - 0.00151582792207796*G0_1_0_5_2 - 0.00788961038961066*G0_1_0_5_3 + 0.00271205357142866*G0_1_0_5_4 - 0.00131493506493512*G0_1_0_5_5 + 0.0127384334415589*G0_1_0_5_6 + 0.000821834415584452*G0_1_0_5_7 - 0.00484882305194822*G0_1_0_5_8 - 0.00147930194805203*G0_1_0_5_9 + 0.0030955762987014*G0_1_0_6_0 - 0.00122362012987017*G0_1_0_6_1 - 0.00384435876623391*G0_1_0_6_2 - 0.00788961038961067*G0_1_0_6_3 + 0.00517755681818199*G0_1_0_6_4 + 0.0127384334415589*G0_1_0_6_5 + 0.0228469967532475*G0_1_0_6_6 + 0.00402698863636378*G0_1_0_6_7 - 0.0102729301948055*G0_1_0_6_8 + 0.00246550324675332*G0_1_0_6_9 - 0.0124918831168836*G0_1_0_7_0 - 0.0375669642857157*G0_1_0_7_1 - 0.00519581980519499*G0_1_0_7_2 - 0.0456118100649368*G0_1_0_7_3 + 0.020710227272728*G0_1_0_7_4 + 0.000821834415584452*G0_1_0_7_5 + 0.00402698863636378*G0_1_0_7_6 + 0.0420779220779236*G0_1_0_7_7 - 0.0710886769480546*G0_1_0_7_8 - 0.019230925324676*G0_1_0_7_9 + 0.0187652191558449*G0_1_0_8_0 + 0.0830509334415616*G0_1_0_8_1 + 0.0119257305194809*G0_1_0_8_2 + 0.0929494724026008*G0_1_0_8_3 - 0.047337662337664*G0_1_0_8_4 - 0.00484882305194822*G0_1_0_8_5 - 0.0102729301948055*G0_1_0_8_6 - 0.0710886769480546*G0_1_0_8_7 + 0.193459821428578*G0_1_0_8_8 + 0.0498031655844174*G0_1_0_8_9 + 0.0037256493506495*G0_1_0_9_0 + 0.0149573863636369*G0_1_0_9_1 + 0.004437905844156*G0_1_0_9_2 + 0.0463514610389628*G0_1_0_9_3 - 0.0187378246753254*G0_1_0_9_4 - 0.00147930194805203*G0_1_0_9_5 + 0.00246550324675332*G0_1_0_9_6 - 0.019230925324676*G0_1_0_9_7 + 0.0498031655844174*G0_1_0_9_8 - 0.00394480519480522*G0_1_0_9_9;
    A[22] = 0.00289096320346331*G0_1_1_0_0 + 0.000851934523809557*G0_1_1_0_1 + 0.00448626893939412*G0_1_1_0_2 - 0.00192674512987021*G0_1_1_0_3 + 0.00503145292207812*G0_1_1_0_4 - 0.00264204545454556*G0_1_1_0_5 + 0.0067025162337665*G0_1_1_0_6 + 0.00104707792207796*G0_1_1_0_7 - 0.000675730519480542*G0_1_1_0_8 + 0.00224025974025983*G0_1_1_0_9 + 0.000851934523809557*G0_1_1_1_0 + 0.0028909632034633*G0_1_1_1_1 + 0.00448626893939411*G0_1_1_1_2 - 0.00264204545454555*G0_1_1_1_3 + 0.00670251623376648*G0_1_1_1_4 - 0.0019267451298702*G0_1_1_1_5 + 0.00503145292207811*G0_1_1_1_6 - 0.000675730519480544*G0_1_1_1_7 + 0.00104707792207796*G0_1_1_1_8 + 0.00224025974025982*G0_1_1_1_9 + 0.00448626893939412*G0_1_1_2_0 + 0.00448626893939411*G0_1_1_2_1 + 0.0703057359307383*G0_1_1_2_2 - 0.0194500811688318*G0_1_1_2_3 + 0.0427049512987028*G0_1_1_2_4 - 0.0194500811688319*G0_1_1_2_5 + 0.0427049512987029*G0_1_1_2_6 - 0.000776176948051975*G0_1_1_2_7 - 0.000776176948051974*G0_1_1_2_8 + 0.00760957792207818*G0_1_1_2_9 - 0.00192674512987021*G0_1_1_3_0 - 0.00264204545454555*G0_1_1_3_1 - 0.0194500811688318*G0_1_1_3_2 + 0.0184821428571435*G0_1_1_3_3 - 0.0325537743506505*G0_1_1_3_4 + 0.00880275974026005*G0_1_1_3_5 - 0.0211394074675332*G0_1_1_3_6 - 0.000264813311688322*G0_1_1_3_7 + 0.0039813311688313*G0_1_1_3_8 - 0.00619115259740281*G0_1_1_3_9 + 0.00503145292207812*G0_1_1_4_0 + 0.00670251623376648*G0_1_1_4_1 + 0.0427049512987028*G0_1_1_4_2 - 0.0325537743506505*G0_1_1_4_3 + 0.0845576298701329*G0_1_1_4_4 - 0.0211394074675332*G0_1_1_4_5 + 0.0422788149350665*G0_1_1_4_6 - 0.00336038961038973*G0_1_1_4_7 - 0.00371651785714298*G0_1_1_4_8 + 0.0194500811688319*G0_1_1_4_9 - 0.00264204545454556*G0_1_1_5_0 - 0.0019267451298702*G0_1_1_5_1 - 0.0194500811688319*G0_1_1_5_2 + 0.00880275974026005*G0_1_1_5_3 - 0.0211394074675332*G0_1_1_5_4 + 0.0184821428571435*G0_1_1_5_5 - 0.0325537743506505*G0_1_1_5_6 + 0.0039813311688313*G0_1_1_5_7 - 0.000264813311688321*G0_1_1_5_8 - 0.00619115259740282*G0_1_1_5_9 + 0.0067025162337665*G0_1_1_6_0 + 0.00503145292207811*G0_1_1_6_1 + 0.0427049512987029*G0_1_1_6_2 - 0.0211394074675332*G0_1_1_6_3 + 0.0422788149350665*G0_1_1_6_4 - 0.0325537743506505*G0_1_1_6_5 + 0.0845576298701329*G0_1_1_6_6 - 0.00371651785714298*G0_1_1_6_7 - 0.00336038961038972*G0_1_1_6_8 + 0.0194500811688319*G0_1_1_6_9 + 0.00104707792207796*G0_1_1_7_0 - 0.000675730519480544*G0_1_1_7_1 - 0.000776176948051976*G0_1_1_7_2 - 0.000264813311688322*G0_1_1_7_3 - 0.00336038961038973*G0_1_1_7_4 + 0.0039813311688313*G0_1_1_7_5 - 0.00371651785714298*G0_1_1_7_6 + 0.013222402597403*G0_1_1_7_7 - 0.0028033685064936*G0_1_1_7_8 + 0.000712256493506519*G0_1_1_7_9 - 0.000675730519480542*G0_1_1_8_0 + 0.00104707792207796*G0_1_1_8_1 - 0.000776176948051974*G0_1_1_8_2 + 0.0039813311688313*G0_1_1_8_3 - 0.00371651785714298*G0_1_1_8_4 - 0.00026481331168832*G0_1_1_8_5 - 0.00336038961038972*G0_1_1_8_6 - 0.0028033685064936*G0_1_1_8_7 + 0.013222402597403*G0_1_1_8_8 + 0.000712256493506509*G0_1_1_8_9 + 0.00224025974025983*G0_1_1_9_0 + 0.00224025974025982*G0_1_1_9_1 + 0.00760957792207818*G0_1_1_9_2 - 0.00619115259740281*G0_1_1_9_3 + 0.0194500811688319*G0_1_1_9_4 - 0.00619115259740282*G0_1_1_9_5 + 0.0194500811688319*G0_1_1_9_6 + 0.000712256493506519*G0_1_1_9_7 + 0.000712256493506509*G0_1_1_9_8 + 0.0282711038961049*G0_1_1_9_9;
    A[54] = A[45] + 0.00447443181818205*G0_0_1_0_0 + 0.000292207792207807*G0_0_1_0_1 - 0.00276684253246765*G0_0_1_0_2 + 0.00213676948051957*G0_0_1_0_3 + 0.000657467532467542*G0_0_1_0_4 + 0.00550629058441582*G0_0_1_0_5 - 0.00238331980519491*G0_0_1_0_6 + 0.00394480519480538*G0_0_1_0_7 - 0.00271205357142868*G0_0_1_0_8 + 0.005917207792208*G0_0_1_0_9 + 0.000292207792207808*G0_0_1_1_0 - 0.00138798701298701*G0_0_1_1_1 - 0.00386262175324689*G0_0_1_1_2 - 0.00139711850649353*G0_0_1_1_3 - 0.00608157467532491*G0_0_1_1_4 + 0.000164366883116905*G0_0_1_1_5 + 0.000657467532467547*G0_0_1_1_6 + 0.000986201298701335*G0_0_1_1_7 - 0.000986201298701313*G0_0_1_1_8 - 0.00345170454545466*G0_0_1_1_9 - 0.00276684253246765*G0_0_1_2_0 - 0.00386262175324689*G0_0_1_2_1 - 0.0734172077922103*G0_0_1_2_2 + 0.0167654220779226*G0_0_1_2_3 - 0.0456118100649367*G0_0_1_2_4 + 0.0142999188311694*G0_0_1_2_5 - 0.0283532873376634*G0_0_1_2_6 + 0.00262987012987023*G0_0_1_2_7 + 0.000164366883116888*G0_0_1_2_8 - 0.00641030844155866*G0_0_1_2_9 + 0.00213676948051957*G0_0_1_3_0 - 0.00139711850649353*G0_0_1_3_1 + 0.0167654220779227*G0_0_1_3_2 + 0.0414204545454561*G0_0_1_3_3 + 0.036242897727274*G0_0_1_3_4 - 0.00443790584415603*G0_0_1_3_5 - 0.00443790584415603*G0_0_1_3_7 + 0.00295860389610402*G0_0_1_3_8 + 0.019230925324676*G0_0_1_3_9 + 0.000657467532467542*G0_0_1_4_0 - 0.00608157467532491*G0_0_1_4_1 - 0.0456118100649367*G0_0_1_4_2 + 0.036242897727274*G0_0_1_4_3 - 0.00591720779220799*G0_0_1_4_7 + 0.00147930194805199*G0_0_1_4_8 + 0.0192309253246759*G0_0_1_4_9 + 0.00550629058441581*G0_0_1_5_0 + 0.000164366883116905*G0_0_1_5_1 + 0.0142999188311694*G0_0_1_5_2 - 0.00443790584415602*G0_0_1_5_3 - 0.000739650974025974*G0_0_1_5_6 + 0.00443790584415608*G0_0_1_5_7 + 0.00147930194805196*G0_0_1_5_8 - 0.0207102272727279*G0_0_1_5_9 - 0.00238331980519491*G0_0_1_6_0 + 0.000657467532467547*G0_0_1_6_1 - 0.0283532873376634*G0_0_1_6_2 - 0.000739650974025974*G0_0_1_6_5 + 0.0739650974025998*G0_0_1_6_6 - 0.00591720779220803*G0_0_1_6_7 - 0.00221895292207798*G0_0_1_6_8 + 0.0192309253246759*G0_0_1_6_9 + 0.00394480519480538*G0_0_1_7_0 + 0.000986201298701335*G0_0_1_7_1 + 0.00262987012987023*G0_0_1_7_2 - 0.00443790584415603*G0_0_1_7_3 - 0.00591720779220799*G0_0_1_7_4 + 0.00443790584415608*G0_0_1_7_5 - 0.00591720779220803*G0_0_1_7_6 + 0.0207102272727282*G0_0_1_7_7 - 0.00147930194805208*G0_0_1_7_8 - 0.00591720779220791*G0_0_1_7_9 - 0.00271205357142869*G0_0_1_8_0 - 0.000986201298701313*G0_0_1_8_1 + 0.000164366883116888*G0_0_1_8_2 + 0.00295860389610402*G0_0_1_8_3 + 0.00147930194805199*G0_0_1_8_4 + 0.00147930194805195*G0_0_1_8_5 - 0.00221895292207798*G0_0_1_8_6 - 0.00147930194805208*G0_0_1_8_7 + 0.0029586038961041*G0_0_1_8_8 + 0.00739650974026*G0_0_1_8_9 + 0.005917207792208*G0_0_1_9_0 - 0.00345170454545466*G0_0_1_9_1 - 0.00641030844155866*G0_0_1_9_2 + 0.019230925324676*G0_0_1_9_3 + 0.0192309253246759*G0_0_1_9_4 - 0.0207102272727279*G0_0_1_9_5 + 0.0192309253246759*G0_0_1_9_6 - 0.00591720779220791*G0_0_1_9_7 + 0.00739650974026*G0_0_1_9_8 - 0.0887581168831197*G0_0_1_9_9 - 0.00447443181818205*G0_1_0_0_0 - 0.000292207792207807*G0_1_0_0_1 + 0.00276684253246765*G0_1_0_0_2 - 0.00213676948051957*G0_1_0_0_3 - 0.000657467532467541*G0_1_0_0_4 - 0.00550629058441582*G0_1_0_0_5 + 0.00238331980519491*G0_1_0_0_6 - 0.00394480519480538*G0_1_0_0_7 + 0.00271205357142869*G0_1_0_0_8 - 0.005917207792208*G0_1_0_0_9 - 0.000292207792207807*G0_1_0_1_0 + 0.00138798701298701*G0_1_0_1_1 + 0.00386262175324689*G0_1_0_1_2 + 0.00139711850649353*G0_1_0_1_3 + 0.00608157467532491*G0_1_0_1_4 - 0.000164366883116905*G0_1_0_1_5 - 0.000657467532467548*G0_1_0_1_6 - 0.000986201298701335*G0_1_0_1_7 + 0.000986201298701313*G0_1_0_1_8 + 0.00345170454545466*G0_1_0_1_9 + 0.00276684253246765*G0_1_0_2_0 + 0.00386262175324689*G0_1_0_2_1 + 0.0734172077922103*G0_1_0_2_2 - 0.0167654220779227*G0_1_0_2_3 + 0.0456118100649367*G0_1_0_2_4 - 0.0142999188311694*G0_1_0_2_5 + 0.0283532873376634*G0_1_0_2_6 - 0.00262987012987023*G0_1_0_2_7 - 0.000164366883116888*G0_1_0_2_8 + 0.00641030844155866*G0_1_0_2_9 - 0.00213676948051957*G0_1_0_3_0 + 0.00139711850649353*G0_1_0_3_1 - 0.0167654220779227*G0_1_0_3_2 - 0.0414204545454561*G0_1_0_3_3 - 0.036242897727274*G0_1_0_3_4 + 0.00443790584415603*G0_1_0_3_5 + 0.00443790584415603*G0_1_0_3_7 - 0.00295860389610402*G0_1_0_3_8 - 0.019230925324676*G0_1_0_3_9 - 0.000657467532467542*G0_1_0_4_0 + 0.00608157467532491*G0_1_0_4_1 + 0.0456118100649367*G0_1_0_4_2 - 0.036242897727274*G0_1_0_4_3 + 0.00591720779220799*G0_1_0_4_7 - 0.00147930194805199*G0_1_0_4_8 - 0.0192309253246759*G0_1_0_4_9 - 0.00550629058441582*G0_1_0_5_0 - 0.000164366883116904*G0_1_0_5_1 - 0.0142999188311694*G0_1_0_5_2 + 0.00443790584415603*G0_1_0_5_3 + 0.000739650974025974*G0_1_0_5_6 - 0.00443790584415608*G0_1_0_5_7 - 0.00147930194805196*G0_1_0_5_8 + 0.0207102272727279*G0_1_0_5_9 + 0.00238331980519491*G0_1_0_6_0 - 0.000657467532467548*G0_1_0_6_1 + 0.0283532873376634*G0_1_0_6_2 + 0.000739650974025974*G0_1_0_6_5 - 0.0739650974025998*G0_1_0_6_6 + 0.00591720779220803*G0_1_0_6_7 + 0.00221895292207798*G0_1_0_6_8 - 0.0192309253246759*G0_1_0_6_9 - 0.00394480519480538*G0_1_0_7_0 - 0.000986201298701335*G0_1_0_7_1 - 0.00262987012987023*G0_1_0_7_2 + 0.00443790584415602*G0_1_0_7_3 + 0.00591720779220799*G0_1_0_7_4 - 0.00443790584415608*G0_1_0_7_5 + 0.00591720779220803*G0_1_0_7_6 - 0.0207102272727282*G0_1_0_7_7 + 0.00147930194805208*G0_1_0_7_8 + 0.00591720779220791*G0_1_0_7_9 + 0.00271205357142869*G0_1_0_8_0 + 0.000986201298701313*G0_1_0_8_1 - 0.000164366883116888*G0_1_0_8_2 - 0.00295860389610402*G0_1_0_8_3 - 0.00147930194805199*G0_1_0_8_4 - 0.00147930194805195*G0_1_0_8_5 + 0.00221895292207798*G0_1_0_8_6 + 0.00147930194805208*G0_1_0_8_7 - 0.0029586038961041*G0_1_0_8_8 - 0.00739650974025999*G0_1_0_8_9 - 0.005917207792208*G0_1_0_9_0 + 0.00345170454545466*G0_1_0_9_1 + 0.00641030844155866*G0_1_0_9_2 - 0.019230925324676*G0_1_0_9_3 - 0.0192309253246759*G0_1_0_9_4 + 0.0207102272727279*G0_1_0_9_5 - 0.0192309253246759*G0_1_0_9_6 + 0.00591720779220791*G0_1_0_9_7 - 0.00739650974025999*G0_1_0_9_8 + 0.0887581168831197*G0_1_0_9_9;
    A[10] = A[1] - 0.011194534632035*G0_0_1_0_0 - 0.000970643939393975*G0_0_1_0_1 - 0.000851934523809553*G0_0_1_0_2 - 0.00056615259740262*G0_0_1_0_3 + 0.0004474431818182*G0_0_1_0_4 - 0.00823356331168858*G0_0_1_0_5 + 0.00348823051948063*G0_0_1_0_6 - 0.00375913149350661*G0_0_1_0_7 + 0.00193587662337668*G0_0_1_0_8 - 0.000980113636363676*G0_0_1_0_9 - 0.000970643939393975*G0_0_1_1_0 - 0.011194534632035*G0_0_1_1_1 - 0.000851934523809553*G0_0_1_1_2 - 0.00823356331168859*G0_0_1_1_3 + 0.00348823051948063*G0_0_1_1_4 - 0.000566152597402614*G0_0_1_1_5 + 0.000447443181818197*G0_0_1_1_6 + 0.0019358766233767*G0_0_1_1_7 - 0.00375913149350664*G0_0_1_1_8 - 0.000980113636363677*G0_0_1_1_9 - 0.000851934523809553*G0_0_1_2_0 - 0.000851934523809553*G0_0_1_2_1 - 0.00170386904761912*G0_0_1_2_2 - 0.00112317370129874*G0_0_1_2_3 - 0.00112317370129873*G0_0_1_2_5 - 0.000267857142857154*G0_0_1_2_9 - 0.00056615259740262*G0_0_1_3_0 - 0.00823356331168859*G0_0_1_3_1 - 0.00112317370129874*G0_0_1_3_2 - 0.0222625811688319*G0_0_1_3_3 + 0.00658380681818204*G0_0_1_3_4 + 0.00114143668831172*G0_0_1_3_5 - 0.00022828733766234*G0_0_1_3_6 + 0.00281250000000011*G0_0_1_3_7 - 0.00389914772727288*G0_0_1_3_8 - 0.0026846590909092*G0_0_1_3_9 + 0.0004474431818182*G0_0_1_4_0 + 0.00348823051948063*G0_0_1_4_1 + 0.00658380681818204*G0_0_1_4_3 + 0.00189935064935072*G0_0_1_4_4 - 0.000228287337662343*G0_0_1_4_5 + 0.000456574675324688*G0_0_1_4_6 - 0.00124188311688317*G0_0_1_4_7 + 0.00108664772727277*G0_0_1_4_8 + 0.00126014610389615*G0_0_1_4_9 - 0.00823356331168858*G0_0_1_5_0 - 0.000566152597402614*G0_0_1_5_1 - 0.00112317370129873*G0_0_1_5_2 + 0.00114143668831172*G0_0_1_5_3 - 0.000228287337662343*G0_0_1_5_4 - 0.0222625811688319*G0_0_1_5_5 + 0.00658380681818203*G0_0_1_5_6 - 0.00389914772727285*G0_0_1_5_7 + 0.00281250000000009*G0_0_1_5_8 - 0.00268465909090919*G0_0_1_5_9 + 0.00348823051948063*G0_0_1_6_0 + 0.000447443181818197*G0_0_1_6_1 - 0.00022828733766234*G0_0_1_6_3 + 0.000456574675324688*G0_0_1_6_4 + 0.00658380681818203*G0_0_1_6_5 + 0.00189935064935072*G0_0_1_6_6 + 0.00108664772727276*G0_0_1_6_7 - 0.00124188311688316*G0_0_1_6_8 + 0.00126014610389615*G0_0_1_6_9 - 0.00375913149350661*G0_0_1_7_0 + 0.0019358766233767*G0_0_1_7_1 + 0.00281250000000011*G0_0_1_7_3 - 0.00124188311688317*G0_0_1_7_4 - 0.00389914772727285*G0_0_1_7_5 + 0.00108664772727276*G0_0_1_7_6 + 0.00321428571428583*G0_0_1_7_7 + 0.00074878246753251*G0_0_1_7_8 + 0.000767045454545489*G0_0_1_7_9 + 0.00193587662337668*G0_0_1_8_0 - 0.00375913149350664*G0_0_1_8_1 - 0.00389914772727288*G0_0_1_8_3 + 0.00108664772727277*G0_0_1_8_4 + 0.00281250000000009*G0_0_1_8_5 - 0.00124188311688316*G0_0_1_8_6 + 0.00074878246753251*G0_0_1_8_7 + 0.00321428571428579*G0_0_1_8_8 + 0.000767045454545473*G0_0_1_8_9 - 0.000980113636363675*G0_0_1_9_0 - 0.000980113636363677*G0_0_1_9_1 - 0.000267857142857154*G0_0_1_9_2 - 0.0026846590909092*G0_0_1_9_3 + 0.00126014610389615*G0_0_1_9_4 - 0.00268465909090919*G0_0_1_9_5 + 0.00126014610389615*G0_0_1_9_6 + 0.000767045454545489*G0_0_1_9_7 + 0.000767045454545473*G0_0_1_9_8 - 0.0105194805194809*G0_0_1_9_9 + 0.011194534632035*G0_1_0_0_0 + 0.000970643939393975*G0_1_0_0_1 + 0.000851934523809553*G0_1_0_0_2 + 0.00056615259740262*G0_1_0_0_3 - 0.0004474431818182*G0_1_0_0_4 + 0.00823356331168858*G0_1_0_0_5 - 0.00348823051948063*G0_1_0_0_6 + 0.00375913149350661*G0_1_0_0_7 - 0.00193587662337668*G0_1_0_0_8 + 0.000980113636363676*G0_1_0_0_9 + 0.000970643939393975*G0_1_0_1_0 + 0.011194534632035*G0_1_0_1_1 + 0.000851934523809553*G0_1_0_1_2 + 0.00823356331168859*G0_1_0_1_3 - 0.00348823051948063*G0_1_0_1_4 + 0.000566152597402614*G0_1_0_1_5 - 0.000447443181818197*G0_1_0_1_6 - 0.0019358766233767*G0_1_0_1_7 + 0.00375913149350664*G0_1_0_1_8 + 0.000980113636363677*G0_1_0_1_9 + 0.000851934523809552*G0_1_0_2_0 + 0.000851934523809553*G0_1_0_2_1 + 0.00170386904761912*G0_1_0_2_2 + 0.00112317370129874*G0_1_0_2_3 + 0.00112317370129873*G0_1_0_2_5 + 0.000267857142857154*G0_1_0_2_9 + 0.00056615259740262*G0_1_0_3_0 + 0.00823356331168859*G0_1_0_3_1 + 0.00112317370129874*G0_1_0_3_2 + 0.0222625811688319*G0_1_0_3_3 - 0.00658380681818204*G0_1_0_3_4 - 0.00114143668831172*G0_1_0_3_5 + 0.00022828733766234*G0_1_0_3_6 - 0.00281250000000011*G0_1_0_3_7 + 0.00389914772727288*G0_1_0_3_8 + 0.0026846590909092*G0_1_0_3_9 - 0.0004474431818182*G0_1_0_4_0 - 0.00348823051948063*G0_1_0_4_1 - 0.00658380681818204*G0_1_0_4_3 - 0.00189935064935072*G0_1_0_4_4 + 0.000228287337662343*G0_1_0_4_5 - 0.000456574675324688*G0_1_0_4_6 + 0.00124188311688316*G0_1_0_4_7 - 0.00108664772727277*G0_1_0_4_8 - 0.00126014610389615*G0_1_0_4_9 + 0.00823356331168858*G0_1_0_5_0 + 0.000566152597402614*G0_1_0_5_1 + 0.00112317370129873*G0_1_0_5_2 - 0.00114143668831172*G0_1_0_5_3 + 0.000228287337662343*G0_1_0_5_4 + 0.0222625811688319*G0_1_0_5_5 - 0.00658380681818203*G0_1_0_5_6 + 0.00389914772727285*G0_1_0_5_7 - 0.00281250000000009*G0_1_0_5_8 + 0.00268465909090919*G0_1_0_5_9 - 0.00348823051948063*G0_1_0_6_0 - 0.000447443181818197*G0_1_0_6_1 + 0.00022828733766234*G0_1_0_6_3 - 0.000456574675324688*G0_1_0_6_4 - 0.00658380681818203*G0_1_0_6_5 - 0.00189935064935072*G0_1_0_6_6 - 0.00108664772727276*G0_1_0_6_7 + 0.00124188311688316*G0_1_0_6_8 - 0.00126014610389615*G0_1_0_6_9 + 0.00375913149350661*G0_1_0_7_0 - 0.0019358766233767*G0_1_0_7_1 - 0.00281250000000011*G0_1_0_7_3 + 0.00124188311688317*G0_1_0_7_4 + 0.00389914772727285*G0_1_0_7_5 - 0.00108664772727276*G0_1_0_7_6 - 0.00321428571428583*G0_1_0_7_7 - 0.00074878246753251*G0_1_0_7_8 - 0.000767045454545489*G0_1_0_7_9 - 0.00193587662337668*G0_1_0_8_0 + 0.00375913149350664*G0_1_0_8_1 + 0.00389914772727288*G0_1_0_8_3 - 0.00108664772727277*G0_1_0_8_4 - 0.00281250000000009*G0_1_0_8_5 + 0.00124188311688316*G0_1_0_8_6 - 0.00074878246753251*G0_1_0_8_7 - 0.00321428571428579*G0_1_0_8_8 - 0.000767045454545473*G0_1_0_8_9 + 0.000980113636363676*G0_1_0_9_0 + 0.000980113636363677*G0_1_0_9_1 + 0.000267857142857154*G0_1_0_9_2 + 0.0026846590909092*G0_1_0_9_3 - 0.00126014610389615*G0_1_0_9_4 + 0.00268465909090919*G0_1_0_9_5 - 0.00126014610389615*G0_1_0_9_6 - 0.000767045454545489*G0_1_0_9_7 - 0.000767045454545473*G0_1_0_9_8 + 0.0105194805194809*G0_1_0_9_9;
    A[27] = A[72] - 0.0164671266233772*G0_0_1_0_0 - 0.00109882305194809*G0_0_1_0_1 - 0.000566152597402615*G0_0_1_0_2 + 0.000273944805194819*G0_0_1_0_3 + 0.00021915584415585*G0_0_1_0_4 - 0.00599025974025993*G0_0_1_0_5 + 0.00373478084415597*G0_0_1_0_6 - 0.011131290584416*G0_0_1_0_7 + 0.00366172889610402*G0_0_1_0_8 - 0.00109577922077926*G0_0_1_0_9 - 0.00109882305194809*G0_0_1_1_0 - 0.00697646103896126*G0_0_1_1_1 - 0.000447443181818196*G0_0_1_1_2 - 0.00225547889610396*G0_0_1_1_3 + 0.000675730519480538*G0_0_1_1_4 - 0.000164366883116888*G0_0_1_1_5 + 0.000794439935064962*G0_0_1_1_6 - 0.000949675324675352*G0_0_1_1_7 - 0.00292207792207803*G0_0_1_1_8 - 0.000383522727272741*G0_0_1_1_9 - 0.000566152597402615*G0_0_1_2_0 - 0.000447443181818196*G0_0_1_2_1 + 0.000693993506493532*G0_0_1_2_3 - 0.00223721590909099*G0_0_1_2_4 - 0.000858360389610415*G0_0_1_2_5 + 0.00223721590909098*G0_0_1_2_6 + 0.00101359577922081*G0_0_1_2_8 + 0.000164366883116888*G0_0_1_2_9 + 0.000273944805194819*G0_0_1_3_0 - 0.00225547889610396*G0_0_1_3_1 + 0.000693993506493532*G0_0_1_3_2 + 0.0121631493506498*G0_0_1_3_3 + 0.00254768668831178*G0_0_1_3_4 - 0.000493100649350663*G0_0_1_3_5 - 0.00172585227272733*G0_0_1_3_6 - 0.000164366883116892*G0_0_1_3_7 + 0.00254768668831176*G0_0_1_3_8 + 0.001479301948052*G0_0_1_3_9 + 0.00021915584415585*G0_0_1_4_0 + 0.000675730519480538*G0_0_1_4_1 - 0.00223721590909099*G0_0_1_4_2 + 0.00254768668831178*G0_0_1_4_3 - 0.0144642857142862*G0_0_1_4_4 + 0.00172585227272733*G0_0_1_4_6 - 0.000657467532467554*G0_0_1_4_7 - 0.00238331980519488*G0_0_1_4_8 - 0.000493100649350662*G0_0_1_4_9 - 0.00599025974025993*G0_0_1_5_0 - 0.000164366883116888*G0_0_1_5_1 - 0.000858360389610415*G0_0_1_5_2 - 0.000493100649350663*G0_0_1_5_3 + 0.0134780844155849*G0_0_1_5_5 - 0.00328733766233778*G0_0_1_5_6 - 0.00180803571428576*G0_0_1_5_7 + 0.00115056818181821*G0_0_1_5_8 + 0.000986201298701339*G0_0_1_5_9 + 0.00373478084415597*G0_0_1_6_0 + 0.000794439935064962*G0_0_1_6_1 + 0.00223721590909098*G0_0_1_6_2 - 0.00172585227272733*G0_0_1_6_3 + 0.00172585227272733*G0_0_1_6_4 - 0.00328733766233778*G0_0_1_6_5 + 0.0110125811688316*G0_0_1_6_6 + 0.000657467532467549*G0_0_1_6_7 - 0.00304078733766243*G0_0_1_6_8 + 0.002958603896104*G0_0_1_6_9 - 0.011131290584416*G0_0_1_7_0 - 0.000949675324675351*G0_0_1_7_1 - 0.000164366883116892*G0_0_1_7_3 - 0.000657467532467554*G0_0_1_7_4 - 0.00180803571428576*G0_0_1_7_5 + 0.000657467532467549*G0_0_1_7_6 + 0.0120809659090913*G0_0_1_7_8 + 0.00197240259740267*G0_0_1_7_9 + 0.00366172889610402*G0_0_1_8_0 - 0.00292207792207803*G0_0_1_8_1 + 0.00101359577922081*G0_0_1_8_2 + 0.00254768668831176*G0_0_1_8_3 - 0.00238331980519488*G0_0_1_8_4 + 0.00115056818181821*G0_0_1_8_5 - 0.00304078733766243*G0_0_1_8_6 + 0.0120809659090913*G0_0_1_8_7 + 0.0241619318181826*G0_0_1_8_8 + 0.00591720779220798*G0_0_1_8_9 - 0.00109577922077926*G0_0_1_9_0 - 0.000383522727272741*G0_0_1_9_1 + 0.000164366883116888*G0_0_1_9_2 + 0.001479301948052*G0_0_1_9_3 - 0.000493100649350662*G0_0_1_9_4 + 0.000986201298701338*G0_0_1_9_5 + 0.002958603896104*G0_0_1_9_6 + 0.00197240259740267*G0_0_1_9_7 + 0.00591720779220798*G0_0_1_9_8 - 0.0295860389610399*G0_0_1_9_9 + 0.0164671266233772*G0_1_0_0_0 + 0.00109882305194809*G0_1_0_0_1 + 0.000566152597402615*G0_1_0_0_2 - 0.000273944805194819*G0_1_0_0_3 - 0.00021915584415585*G0_1_0_0_4 + 0.00599025974025993*G0_1_0_0_5 - 0.00373478084415597*G0_1_0_0_6 + 0.011131290584416*G0_1_0_0_7 - 0.00366172889610402*G0_1_0_0_8 + 0.00109577922077926*G0_1_0_0_9 + 0.00109882305194809*G0_1_0_1_0 + 0.00697646103896126*G0_1_0_1_1 + 0.000447443181818196*G0_1_0_1_2 + 0.00225547889610396*G0_1_0_1_3 - 0.000675730519480538*G0_1_0_1_4 + 0.000164366883116889*G0_1_0_1_5 - 0.000794439935064962*G0_1_0_1_6 + 0.000949675324675352*G0_1_0_1_7 + 0.00292207792207803*G0_1_0_1_8 + 0.000383522727272741*G0_1_0_1_9 + 0.000566152597402615*G0_1_0_2_0 + 0.000447443181818196*G0_1_0_2_1 - 0.000693993506493532*G0_1_0_2_3 + 0.00223721590909099*G0_1_0_2_4 + 0.000858360389610415*G0_1_0_2_5 - 0.00223721590909098*G0_1_0_2_6 - 0.00101359577922081*G0_1_0_2_8 - 0.000164366883116888*G0_1_0_2_9 - 0.000273944805194819*G0_1_0_3_0 + 0.00225547889610396*G0_1_0_3_1 - 0.000693993506493532*G0_1_0_3_2 - 0.0121631493506498*G0_1_0_3_3 - 0.00254768668831178*G0_1_0_3_4 + 0.000493100649350663*G0_1_0_3_5 + 0.00172585227272733*G0_1_0_3_6 + 0.000164366883116892*G0_1_0_3_7 - 0.00254768668831176*G0_1_0_3_8 - 0.001479301948052*G0_1_0_3_9 - 0.00021915584415585*G0_1_0_4_0 - 0.000675730519480538*G0_1_0_4_1 + 0.00223721590909099*G0_1_0_4_2 - 0.00254768668831178*G0_1_0_4_3 + 0.0144642857142862*G0_1_0_4_4 - 0.00172585227272733*G0_1_0_4_6 + 0.000657467532467554*G0_1_0_4_7 + 0.00238331980519488*G0_1_0_4_8 + 0.000493100649350662*G0_1_0_4_9 + 0.00599025974025993*G0_1_0_5_0 + 0.000164366883116888*G0_1_0_5_1 + 0.000858360389610415*G0_1_0_5_2 + 0.000493100649350663*G0_1_0_5_3 - 0.0134780844155849*G0_1_0_5_5 + 0.00328733766233778*G0_1_0_5_6 + 0.00180803571428576*G0_1_0_5_7 - 0.00115056818181821*G0_1_0_5_8 - 0.000986201298701339*G0_1_0_5_9 - 0.00373478084415597*G0_1_0_6_0 - 0.000794439935064962*G0_1_0_6_1 - 0.00223721590909098*G0_1_0_6_2 + 0.00172585227272733*G0_1_0_6_3 - 0.00172585227272733*G0_1_0_6_4 + 0.00328733766233778*G0_1_0_6_5 - 0.0110125811688316*G0_1_0_6_6 - 0.00065746753246755*G0_1_0_6_7 + 0.00304078733766243*G0_1_0_6_8 - 0.002958603896104*G0_1_0_6_9 + 0.011131290584416*G0_1_0_7_0 + 0.000949675324675352*G0_1_0_7_1 + 0.000164366883116892*G0_1_0_7_3 + 0.000657467532467554*G0_1_0_7_4 + 0.00180803571428577*G0_1_0_7_5 - 0.00065746753246755*G0_1_0_7_6 - 0.0120809659090913*G0_1_0_7_8 - 0.00197240259740267*G0_1_0_7_9 - 0.00366172889610402*G0_1_0_8_0 + 0.00292207792207803*G0_1_0_8_1 - 0.00101359577922081*G0_1_0_8_2 - 0.00254768668831176*G0_1_0_8_3 + 0.00238331980519488*G0_1_0_8_4 - 0.00115056818181821*G0_1_0_8_5 + 0.00304078733766243*G0_1_0_8_6 - 0.0120809659090913*G0_1_0_8_7 - 0.0241619318181826*G0_1_0_8_8 - 0.00591720779220798*G0_1_0_8_9 + 0.00109577922077926*G0_1_0_9_0 + 0.000383522727272741*G0_1_0_9_1 - 0.000164366883116887*G0_1_0_9_2 - 0.001479301948052*G0_1_0_9_3 + 0.000493100649350662*G0_1_0_9_4 - 0.000986201298701339*G0_1_0_9_5 - 0.002958603896104*G0_1_0_9_6 - 0.00197240259740267*G0_1_0_9_7 - 0.00591720779220798*G0_1_0_9_8 + 0.0295860389610399*G0_1_0_9_9;
    A[92] = 0.00196022727272735*G0_0_1_0_0 + 0.00098011363636367*G0_0_1_0_2 + 0.00213676948051956*G0_0_1_0_3 - 0.00213676948051957*G0_0_1_0_4 + 0.00109577922077925*G0_0_1_0_5 + 0.00405438311688327*G0_0_1_0_6 + 0.00158887987012993*G0_0_1_0_7 - 0.000876623376623407*G0_0_1_0_8 + 0.00525974025974044*G0_0_1_0_9 - 0.00196022727272733*G0_0_1_1_1 - 0.000980113636363669*G0_0_1_1_2 - 0.00109577922077925*G0_0_1_1_3 - 0.00405438311688326*G0_0_1_1_4 - 0.00213676948051955*G0_0_1_1_5 + 0.00213676948051956*G0_0_1_1_6 + 0.000876623376623402*G0_0_1_1_7 - 0.00158887987012992*G0_0_1_1_8 - 0.00525974025974044*G0_0_1_1_9 + 0.00098011363636367*G0_0_1_2_0 - 0.000980113636363669*G0_0_1_2_1 + 0.00493100649350666*G0_0_1_2_3 - 0.01479301948052*G0_0_1_2_4 - 0.00493100649350666*G0_0_1_2_5 + 0.01479301948052*G0_0_1_2_6 + 0.00016436688311689*G0_0_1_2_7 - 0.000164366883116886*G0_0_1_2_8 + 0.00213676948051956*G0_0_1_3_0 - 0.00109577922077925*G0_0_1_3_1 + 0.00493100649350666*G0_0_1_3_2 + 0.035503246753248*G0_0_1_3_3 + 0.0212033279220786*G0_0_1_3_4 - 0.00641030844155864*G0_0_1_3_6 - 0.00641030844155867*G0_0_1_3_7 + 0.005917207792208*G0_0_1_3_8 + 0.0285998376623386*G0_0_1_3_9 - 0.00213676948051957*G0_0_1_4_0 - 0.00405438311688326*G0_0_1_4_1 - 0.01479301948052*G0_0_1_4_2 + 0.0212033279220786*G0_0_1_4_3 - 0.0936891233766266*G0_0_1_4_4 + 0.00641030844155867*G0_0_1_4_5 + 0.002958603896104*G0_0_1_4_7 + 0.00049310064935066*G0_0_1_4_8 - 0.0128206168831173*G0_0_1_4_9 + 0.00109577922077925*G0_0_1_5_0 - 0.00213676948051955*G0_0_1_5_1 - 0.00493100649350666*G0_0_1_5_2 + 0.00641030844155867*G0_0_1_5_4 - 0.035503246753248*G0_0_1_5_5 - 0.0212033279220786*G0_0_1_5_6 - 0.005917207792208*G0_0_1_5_7 + 0.00641030844155866*G0_0_1_5_8 - 0.0285998376623386*G0_0_1_5_9 + 0.00405438311688327*G0_0_1_6_0 + 0.00213676948051956*G0_0_1_6_1 + 0.01479301948052*G0_0_1_6_2 - 0.00641030844155864*G0_0_1_6_3 - 0.0212033279220786*G0_0_1_6_5 + 0.0936891233766265*G0_0_1_6_6 - 0.000493100649350657*G0_0_1_6_7 - 0.00295860389610399*G0_0_1_6_8 + 0.0128206168831173*G0_0_1_6_9 + 0.00158887987012993*G0_0_1_7_0 + 0.000876623376623402*G0_0_1_7_1 + 0.00016436688311689*G0_0_1_7_2 - 0.00641030844155867*G0_0_1_7_3 + 0.002958603896104*G0_0_1_7_4 - 0.005917207792208*G0_0_1_7_5 - 0.000493100649350657*G0_0_1_7_6 + 0.00394480519480533*G0_0_1_7_7 - 0.01479301948052*G0_0_1_7_9 - 0.000876623376623407*G0_0_1_8_0 - 0.00158887987012992*G0_0_1_8_1 - 0.000164366883116886*G0_0_1_8_2 + 0.005917207792208*G0_0_1_8_3 + 0.00049310064935066*G0_0_1_8_4 + 0.00641030844155866*G0_0_1_8_5 - 0.00295860389610399*G0_0_1_8_6 - 0.0039448051948053*G0_0_1_8_8 + 0.01479301948052*G0_0_1_8_9 + 0.00525974025974044*G0_0_1_9_0 - 0.00525974025974044*G0_0_1_9_1 + 0.0285998376623386*G0_0_1_9_3 - 0.0128206168831173*G0_0_1_9_4 - 0.0285998376623386*G0_0_1_9_5 + 0.0128206168831173*G0_0_1_9_6 - 0.01479301948052*G0_0_1_9_7 + 0.01479301948052*G0_0_1_9_8 + 0.00360389610389624*G0_1_1_0_0 + 0.000487012987013004*G0_1_1_0_1 - 0.00136972402597408*G0_1_1_0_2 + 0.00427353896103912*G0_1_1_0_3 - 0.00624594155844181*G0_1_1_0_4 + 0.0035612824675326*G0_1_1_0_5 - 0.00482142857142876*G0_1_1_0_6 + 0.00405438311688328*G0_1_1_0_7 - 0.00186282467532473*G0_1_1_0_8 + 0.000328733766233777*G0_1_1_0_9 + 0.000487012987013004*G0_1_1_1_0 + 0.00164366883116891*G0_1_1_1_1 - 0.00234983766233775*G0_1_1_1_2 + 0.00246550324675335*G0_1_1_1_3 - 0.00887581168831202*G0_1_1_1_4 + 0.00213676948051956*G0_1_1_1_5 - 0.00410917207792223*G0_1_1_1_6 - 0.000986201298701336*G0_1_1_1_7 + 0.00246550324675335*G0_1_1_1_8 - 0.00493100649350666*G0_1_1_1_9 - 0.00136972402597408*G0_1_1_2_0 - 0.00234983766233775*G0_1_1_2_1 - 0.0185064935064942*G0_1_1_2_2 + 0.0117248376623381*G0_1_1_2_3 - 0.028216314935066*G0_1_1_2_4 + 0.00679383116883143*G0_1_1_2_5 - 0.013423295454546*G0_1_1_2_6 + 0.00279423701298711*G0_1_1_2_7 + 0.00262987012987022*G0_1_1_2_8 - 0.00427353896103912*G0_1_1_2_9 + 0.00427353896103912*G0_1_1_3_0 + 0.00246550324675335*G0_1_1_3_1 + 0.0117248376623381*G0_1_1_3_2 + 0.0246550324675333*G0_1_1_3_3 + 0.0374756493506507*G0_1_1_3_4 - 0.011834415584416*G0_1_1_3_5 + 0.0167654220779227*G0_1_1_3_6 - 0.00838271103896135*G0_1_1_3_7 + 0.011834415584416*G0_1_1_3_8 + 0.0315584415584426*G0_1_1_3_9 - 0.00624594155844181*G0_1_1_4_0 - 0.00887581168831202*G0_1_1_4_1 - 0.028216314935066*G0_1_1_4_2 + 0.0374756493506507*G0_1_1_4_3 - 0.130178571428576*G0_1_1_4_4 + 0.0231757305194814*G0_1_1_4_5 - 0.0399411525974041*G0_1_1_4_6 + 0.002958603896104*G0_1_1_4_7 - 0.00345170454545465*G0_1_1_4_8 - 0.0335308441558453*G0_1_1_4_9 + 0.0035612824675326*G0_1_1_5_0 + 0.00213676948051956*G0_1_1_5_1 + 0.00679383116883143*G0_1_1_5_2 - 0.011834415584416*G0_1_1_5_3 + 0.0231757305194814*G0_1_1_5_4 - 0.0108482142857147*G0_1_1_5_5 + 0.016272321428572*G0_1_1_5_6 + 0.00591720779220799*G0_1_1_5_7 - 0.00197240259740267*G0_1_1_5_8 + 0.00295860389610401*G0_1_1_5_9 - 0.00482142857142876*G0_1_1_6_0 - 0.00410917207792223*G0_1_1_6_1 - 0.013423295454546*G0_1_1_6_2 + 0.0167654220779227*G0_1_1_6_3 - 0.0399411525974041*G0_1_1_6_4 + 0.016272321428572*G0_1_1_6_5 - 0.0364894480519494*G0_1_1_6_6 - 0.00394480519480532*G0_1_1_6_7 - 0.020710227272728*G0_1_1_6_9 + 0.00405438311688328*G0_1_1_7_0 - 0.000986201298701336*G0_1_1_7_1 + 0.00279423701298711*G0_1_1_7_2 - 0.00838271103896135*G0_1_1_7_3 + 0.002958603896104*G0_1_1_7_4 + 0.00591720779220799*G0_1_1_7_5 - 0.00394480519480532*G0_1_1_7_6 + 0.0739650974026*G0_1_1_7_7 - 0.00493100649350669*G0_1_1_7_8 + 0.00690340909090934*G0_1_1_7_9 - 0.00186282467532473*G0_1_1_8_0 + 0.00246550324675335*G0_1_1_8_1 + 0.00262987012987022*G0_1_1_8_2 + 0.011834415584416*G0_1_1_8_3 - 0.00345170454545465*G0_1_1_8_4 - 0.00197240259740267*G0_1_1_8_5 - 0.0049310064935067*G0_1_1_8_7 + 0.0700202922077946*G0_1_1_8_8 + 0.0216964285714293*G0_1_1_8_9 + 0.000328733766233777*G0_1_1_9_0 - 0.00493100649350666*G0_1_1_9_1 - 0.00427353896103912*G0_1_1_9_2 + 0.0315584415584426*G0_1_1_9_3 - 0.0335308441558453*G0_1_1_9_4 + 0.00295860389610401*G0_1_1_9_5 - 0.020710227272728*G0_1_1_9_6 + 0.00690340909090934*G0_1_1_9_7 + 0.0216964285714293*G0_1_1_9_8;
    A[61] = -A[51] - 0.00265422077922086*G0_0_0_0_0 + 0.000258725649350658*G0_0_0_0_1 - 0.00165280032467539*G0_0_0_0_2 + 0.00170758928571436*G0_0_0_0_3 - 0.000210024350649363*G0_0_0_0_4 - 0.00261160714285723*G0_0_0_0_5 + 0.000922280844155847*G0_0_0_0_6 - 0.00215503246753254*G0_0_0_0_7 + 0.0014884334415585*G0_0_0_0_8 + 0.000219155844155849*G0_0_0_0_9 + 0.000258725649350658*G0_0_0_1_0 + 0.00547889610389626*G0_0_0_1_1 + 0.000140016233766233*G0_0_0_1_2 + 0.0082640016233769*G0_0_0_1_3 - 0.00348823051948063*G0_0_0_1_4 - 0.00157974837662342*G0_0_0_1_5 - 0.00259334415584426*G0_0_0_1_6 - 0.00193587662337669*G0_0_0_1_7 + 0.00378956980519494*G0_0_0_1_8 + 0.0010409902597403*G0_0_0_1_9 - 0.00165280032467539*G0_0_0_2_0 + 0.000140016233766233*G0_0_0_2_1 - 0.0121448863636368*G0_0_0_2_2 + 0.00454748376623393*G0_0_0_2_3 - 0.00588981331168853*G0_0_0_2_4 + 0.00553368506493527*G0_0_0_2_5 - 0.0108208198051952*G0_0_0_2_6 + 0.000228287337662343*G0_0_0_2_7 + 0.00113230519480524*G0_0_0_2_8 - 0.00049310064935067*G0_0_0_2_9 + 0.00170758928571436*G0_0_0_3_0 + 0.0082640016233769*G0_0_0_3_1 + 0.00454748376623393*G0_0_0_3_2 + 0.0330377435064947*G0_0_0_3_3 - 0.00936891233766265*G0_0_0_3_4 + 0.00739650974025999*G0_0_0_3_6 - 0.00550629058441579*G0_0_0_3_7 + 0.00928672889610425*G0_0_0_3_8 + 0.00788961038961068*G0_0_0_3_9 - 0.000210024350649363*G0_0_0_4_0 - 0.00348823051948063*G0_0_0_4_1 - 0.00588981331168853*G0_0_0_4_2 - 0.00936891233766265*G0_0_0_4_3 + 0.00788961038961066*G0_0_0_4_4 + 0.000246550324675353*G0_0_0_4_5 - 0.00764306006493535*G0_0_0_4_6 + 0.000164366883116894*G0_0_0_4_7 - 0.00378043831168845*G0_0_0_4_8 + 0.00098620129870132*G0_0_0_4_9 - 0.00261160714285723*G0_0_0_5_0 - 0.00157974837662342*G0_0_0_5_1 + 0.00553368506493527*G0_0_0_5_2 + 0.000246550324675353*G0_0_0_5_4 - 0.0571996753246772*G0_0_0_5_5 + 0.00665685876623404*G0_0_0_5_6 - 0.00328733766233777*G0_0_0_5_7 + 0.00435572240259754*G0_0_0_5_8 - 0.00936891233766265*G0_0_0_5_9 + 0.000922280844155847*G0_0_0_6_0 - 0.00259334415584426*G0_0_0_6_1 - 0.0108208198051952*G0_0_0_6_2 + 0.00739650974025999*G0_0_0_6_3 - 0.00764306006493535*G0_0_0_6_4 + 0.00665685876623403*G0_0_0_6_5 - 0.08136160714286*G0_0_0_6_6 - 0.00106838474025978*G0_0_0_6_7 + 0.00238331980519488*G0_0_0_6_8 - 0.013313717532468*G0_0_0_6_9 - 0.00215503246753254*G0_0_0_7_0 - 0.00193587662337669*G0_0_0_7_1 + 0.000228287337662343*G0_0_0_7_2 - 0.00550629058441579*G0_0_0_7_3 + 0.000164366883116894*G0_0_0_7_4 - 0.00328733766233777*G0_0_0_7_5 - 0.00106838474025978*G0_0_0_7_6 + 0.00657467532467555*G0_0_0_7_7 - 0.00353388798701312*G0_0_0_7_8 + 0.00147930194805199*G0_0_0_7_9 + 0.0014884334415585*G0_0_0_8_0 + 0.00378956980519494*G0_0_0_8_1 + 0.00113230519480524*G0_0_0_8_2 + 0.00928672889610425*G0_0_0_8_3 - 0.00378043831168845*G0_0_0_8_4 + 0.00435572240259754*G0_0_0_8_5 + 0.00238331980519488*G0_0_0_8_6 - 0.00353388798701312*G0_0_0_8_7 + 0.00756087662337692*G0_0_0_8_8 + 0.004437905844156*G0_0_0_8_9 + 0.00021915584415585*G0_0_0_9_0 + 0.0010409902597403*G0_0_0_9_1 - 0.00049310064935067*G0_0_0_9_2 + 0.00788961038961068*G0_0_0_9_3 + 0.000986201298701319*G0_0_0_9_4 - 0.00936891233766265*G0_0_0_9_5 - 0.013313717532468*G0_0_0_9_6 + 0.00147930194805199*G0_0_0_9_7 + 0.004437905844156*G0_0_0_9_8 + 0.0493100649350666*G0_0_0_9_9 + 0.00949066558441591*G0_1_0_0_0 + 0.000118709415584417*G0_1_0_0_1 + 0.000575284090909116*G0_1_0_0_3 - 0.000438311688311709*G0_1_0_0_4 + 0.00820921266233793*G0_1_0_0_5 - 0.00461140422077938*G0_1_0_0_6 + 0.00373478084415597*G0_1_0_0_7 - 0.00305905032467543*G0_1_0_0_8 + 0.000712256493506522*G0_1_0_0_9 + 0.000118709415584418*G0_1_0_1_0 - 0.000118709415584424*G0_1_0_1_2 + 0.00447443181818196*G0_1_0_1_3 - 0.00155235389610395*G0_1_0_1_4 + 0.00101359577922081*G0_1_0_1_5 - 0.00101359577922082*G0_1_0_1_6 + 0.00155235389610395*G0_1_0_1_7 - 0.00447443181818198*G0_1_0_1_8 - 0.000118709415584424*G0_1_0_2_1 - 0.00949066558441594*G0_1_0_2_2 + 0.00305905032467544*G0_1_0_2_3 - 0.00373478084415599*G0_1_0_2_4 + 0.00461140422077939*G0_1_0_2_5 - 0.00820921266233798*G0_1_0_2_6 + 0.000438311688311702*G0_1_0_2_7 - 0.000575284090909108*G0_1_0_2_8 - 0.000712256493506518*G0_1_0_2_9 + 0.000575284090909116*G0_1_0_3_0 + 0.00447443181818196*G0_1_0_3_1 + 0.00305905032467544*G0_1_0_3_2 + 0.0254768668831178*G0_1_0_3_3 - 0.00583502435064954*G0_1_0_3_4 - 0.00238331980519489*G0_1_0_3_5 + 0.00304078733766244*G0_1_0_3_6 - 0.00172585227272734*G0_1_0_3_7 + 0.00345170454545469*G0_1_0_3_9 - 0.000438311688311709*G0_1_0_4_0 - 0.00155235389610395*G0_1_0_4_1 - 0.00373478084415599*G0_1_0_4_2 - 0.00583502435064954*G0_1_0_4_3 + 0.00131493506493508*G0_1_0_4_4 + 0.00131493506493512*G0_1_0_4_5 - 0.00435572240259757*G0_1_0_4_6 + 0.00172585227272732*G0_1_0_4_8 - 0.000493100649350681*G0_1_0_4_9 + 0.00820921266233793*G0_1_0_5_0 + 0.00101359577922081*G0_1_0_5_1 + 0.00461140422077939*G0_1_0_5_2 - 0.00238331980519489*G0_1_0_5_3 + 0.00131493506493512*G0_1_0_5_4 + 0.0241619318181826*G0_1_0_5_5 + 0.00435572240259755*G0_1_0_5_7 - 0.00304078733766244*G0_1_0_5_8 + 0.00394480519480534*G0_1_0_5_9 - 0.00461140422077938*G0_1_0_6_0 - 0.00101359577922082*G0_1_0_6_1 - 0.00820921266233798*G0_1_0_6_2 + 0.00304078733766244*G0_1_0_6_3 - 0.00435572240259757*G0_1_0_6_4 - 0.0241619318181827*G0_1_0_6_6 - 0.00131493506493511*G0_1_0_6_7 + 0.00238331980519488*G0_1_0_6_8 - 0.00394480519480534*G0_1_0_6_9 + 0.00373478084415597*G0_1_0_7_0 + 0.00155235389610395*G0_1_0_7_1 + 0.000438311688311701*G0_1_0_7_2 - 0.00172585227272734*G0_1_0_7_3 + 0.00435572240259755*G0_1_0_7_5 - 0.00131493506493511*G0_1_0_7_6 - 0.00131493506493512*G0_1_0_7_7 + 0.00583502435064955*G0_1_0_7_8 + 0.000493100649350658*G0_1_0_7_9 - 0.00305905032467543*G0_1_0_8_0 - 0.00447443181818198*G0_1_0_8_1 - 0.000575284090909108*G0_1_0_8_2 + 0.00172585227272732*G0_1_0_8_4 - 0.00304078733766244*G0_1_0_8_5 + 0.00238331980519488*G0_1_0_8_6 + 0.00583502435064955*G0_1_0_8_7 - 0.0254768668831177*G0_1_0_8_8 - 0.00345170454545465*G0_1_0_8_9 + 0.000712256493506522*G0_1_0_9_0 - 0.000712256493506517*G0_1_0_9_2 + 0.00345170454545469*G0_1_0_9_3 - 0.00049310064935068*G0_1_0_9_4 + 0.00394480519480534*G0_1_0_9_5 - 0.00394480519480534*G0_1_0_9_6 + 0.000493100649350658*G0_1_0_9_7 - 0.00345170454545465*G0_1_0_9_8;
    A[41] = -A[61] - 0.00787134740259768*G0_1_0_0_0 - 0.00393567370129885*G0_1_0_0_1 - 0.00106534090909095*G0_1_0_0_2 - 0.000757913961038983*G0_1_0_0_3 - 0.00111404220779225*G0_1_0_0_4 - 0.00241984577922085*G0_1_0_0_5 - 0.00124188311688316*G0_1_0_0_6 + 0.000173498376623393*G0_1_0_0_7 - 0.00544237012987034*G0_1_0_0_8 - 0.00378043831168844*G0_1_0_0_9 - 0.00393567370129885*G0_1_0_1_0 - 0.0525974025974044*G0_1_0_1_1 - 0.00307426948051959*G0_1_0_1_2 - 0.0196783685064942*G0_1_0_1_3 + 0.0100994318181821*G0_1_0_1_4 + 0.00170758928571434*G0_1_0_1_5 + 0.000858360389610412*G0_1_0_1_6 + 0.0165827922077928*G0_1_0_1_7 - 0.0389458198051962*G0_1_0_1_8 - 0.0047666396103898*G0_1_0_1_9 - 0.00106534090909095*G0_1_0_2_0 - 0.00307426948051959*G0_1_0_2_1 - 0.0154017857142863*G0_1_0_2_2 + 0.00167106331168838*G0_1_0_2_3 - 0.00246550324675336*G0_1_0_2_4 + 0.00249289772727284*G0_1_0_2_5 - 0.00904017857142893*G0_1_0_2_6 + 0.00146103896103901*G0_1_0_2_7 - 0.00346996753246765*G0_1_0_2_8 + 0.000767045454545479*G0_1_0_2_9 - 0.000757913961038983*G0_1_0_3_0 - 0.0196783685064942*G0_1_0_3_1 + 0.00167106331168838*G0_1_0_3_2 + 0.013478084415585*G0_1_0_3_3 + 0.00460227272727286*G0_1_0_3_4 - 0.00336952110389622*G0_1_0_3_5 + 0.00131493506493512*G0_1_0_3_6 + 0.00616375811688331*G0_1_0_3_7 - 0.0204636769480526*G0_1_0_3_8 + 0.00197240259740272*G0_1_0_3_9 - 0.00111404220779225*G0_1_0_4_0 + 0.0100994318181821*G0_1_0_4_1 - 0.00246550324675336*G0_1_0_4_2 + 0.00460227272727286*G0_1_0_4_3 - 0.0259699675324685*G0_1_0_4_4 + 0.00723214285714311*G0_1_0_4_5 - 0.00854707792207824*G0_1_0_4_6 - 0.00246550324675333*G0_1_0_4_7 + 0.0142999188311693*G0_1_0_4_8 - 0.0167654220779226*G0_1_0_4_9 - 0.00241984577922085*G0_1_0_5_0 + 0.00170758928571434*G0_1_0_5_1 + 0.00249289772727284*G0_1_0_5_2 - 0.00336952110389622*G0_1_0_5_3 + 0.00723214285714311*G0_1_0_5_4 + 0.0238331980519488*G0_1_0_5_5 + 0.0134780844155849*G0_1_0_5_6 + 0.00172585227272733*G0_1_0_5_7 - 0.00123275162337666*G0_1_0_5_8 + 0.0138068181818186*G0_1_0_5_9 - 0.00124188311688316*G0_1_0_6_0 + 0.000858360389610412*G0_1_0_6_1 - 0.00904017857142893*G0_1_0_6_2 + 0.00131493506493512*G0_1_0_6_3 - 0.00854707792207824*G0_1_0_6_4 + 0.0134780844155849*G0_1_0_6_5 + 0.00361607142857147*G0_1_0_6_6 - 0.000493100649350666*G0_1_0_6_7 + 0.00197240259740266*G0_1_0_6_8 - 0.00493100649350668*G0_1_0_6_9 + 0.000173498376623393*G0_1_0_7_0 + 0.0165827922077928*G0_1_0_7_1 + 0.00146103896103901*G0_1_0_7_2 + 0.00616375811688331*G0_1_0_7_3 - 0.00246550324675333*G0_1_0_7_4 + 0.00172585227272733*G0_1_0_7_5 - 0.000493100649350666*G0_1_0_7_6 + 0.00821834415584448*G0_1_0_7_7 + 0.0316406250000011*G0_1_0_7_8 + 0.0123275162337667*G0_1_0_7_9 - 0.00544237012987034*G0_1_0_8_0 - 0.0389458198051962*G0_1_0_8_1 - 0.00346996753246765*G0_1_0_8_2 - 0.0204636769480526*G0_1_0_8_3 + 0.0142999188311693*G0_1_0_8_4 - 0.00123275162337666*G0_1_0_8_5 + 0.00197240259740266*G0_1_0_8_6 + 0.0316406250000011*G0_1_0_8_7 - 0.10568790584416*G0_1_0_8_8 - 0.0142999188311693*G0_1_0_8_9 - 0.00378043831168844*G0_1_0_9_0 - 0.0047666396103898*G0_1_0_9_1 + 0.000767045454545479*G0_1_0_9_2 + 0.00197240259740272*G0_1_0_9_3 - 0.0167654220779226*G0_1_0_9_4 + 0.0138068181818186*G0_1_0_9_5 - 0.00493100649350668*G0_1_0_9_6 + 0.0123275162337667*G0_1_0_9_7 - 0.0142999188311693*G0_1_0_9_8 - 0.0867857142857171*G0_1_0_9_9;
    A[40] = -A[41] + 0.00231939935064946*G0_0_0_0_0 + 0.000858360389610422*G0_0_0_0_2 - 0.000739650974026003*G0_0_0_0_3 - 0.00197240259740268*G0_0_0_0_4 + 0.00205458603896112*G0_0_0_0_5 + 0.000821834415584455*G0_0_0_0_6 + 0.00230113636363647*G0_0_0_0_7 - 0.0016436688311689*G0_0_0_0_8 - 0.000986201298701328*G0_0_0_0_9 - 0.00231939935064946*G0_0_0_1_1 - 0.000858360389610419*G0_0_0_1_2 - 0.00205458603896111*G0_0_0_1_3 - 0.000821834415584447*G0_0_0_1_4 + 0.000739650974026*G0_0_0_1_5 + 0.00197240259740267*G0_0_0_1_6 + 0.0016436688311689*G0_0_0_1_7 - 0.00230113636363647*G0_0_0_1_8 + 0.000986201298701328*G0_0_0_1_9 + 0.000858360389610422*G0_0_0_2_0 - 0.000858360389610419*G0_0_0_2_1 + 0.00246550324675333*G0_0_0_2_3 - 0.00739650974025999*G0_0_0_2_4 - 0.00246550324675333*G0_0_0_2_5 + 0.00739650974026001*G0_0_0_2_6 + 0.000986201298701337*G0_0_0_2_7 - 0.000986201298701335*G0_0_0_2_8 - 0.000739650974026003*G0_0_0_3_0 - 0.00205458603896111*G0_0_0_3_1 + 0.00246550324675333*G0_0_0_3_2 - 0.01479301948052*G0_0_0_3_3 + 0.013313717532468*G0_0_0_3_4 - 0.00591720779220798*G0_0_0_3_6 + 0.002218952922078*G0_0_0_3_7 - 0.00517755681818201*G0_0_0_3_8 - 0.00739650974025999*G0_0_0_3_9 - 0.00197240259740268*G0_0_0_4_0 - 0.000821834415584447*G0_0_0_4_1 - 0.00739650974025999*G0_0_0_4_2 + 0.013313717532468*G0_0_0_4_3 - 0.0739650974026001*G0_0_0_4_4 + 0.005917207792208*G0_0_0_4_5 + 0.001479301948052*G0_0_0_4_7 + 0.00295860389610401*G0_0_0_4_8 - 0.011834415584416*G0_0_0_4_9 + 0.00205458603896112*G0_0_0_5_0 + 0.000739650974026*G0_0_0_5_1 - 0.00246550324675333*G0_0_0_5_2 + 0.005917207792208*G0_0_0_5_4 + 0.01479301948052*G0_0_0_5_5 - 0.013313717532468*G0_0_0_5_6 + 0.00517755681818201*G0_0_0_5_7 - 0.002218952922078*G0_0_0_5_8 + 0.00739650974026*G0_0_0_5_9 + 0.000821834415584455*G0_0_0_6_0 + 0.00197240259740267*G0_0_0_6_1 + 0.00739650974026001*G0_0_0_6_2 - 0.00591720779220798*G0_0_0_6_3 - 0.013313717532468*G0_0_0_6_5 + 0.0739650974026*G0_0_0_6_6 - 0.002958603896104*G0_0_0_6_7 - 0.00147930194805199*G0_0_0_6_8 + 0.011834415584416*G0_0_0_6_9 + 0.00230113636363647*G0_0_0_7_0 + 0.0016436688311689*G0_0_0_7_1 + 0.000986201298701337*G0_0_0_7_2 + 0.002218952922078*G0_0_0_7_3 + 0.001479301948052*G0_0_0_7_4 + 0.00517755681818201*G0_0_0_7_5 - 0.002958603896104*G0_0_0_7_6 + 0.00739650974026007*G0_0_0_7_7 + 0.00887581168831201*G0_0_0_7_9 - 0.0016436688311689*G0_0_0_8_0 - 0.00230113636363647*G0_0_0_8_1 - 0.000986201298701334*G0_0_0_8_2 - 0.00517755681818201*G0_0_0_8_3 + 0.00295860389610401*G0_0_0_8_4 - 0.002218952922078*G0_0_0_8_5 - 0.00147930194805199*G0_0_0_8_6 - 0.00739650974026005*G0_0_0_8_8 - 0.008875811688312*G0_0_0_8_9 - 0.000986201298701328*G0_0_0_9_0 + 0.000986201298701328*G0_0_0_9_1 - 0.00739650974025999*G0_0_0_9_3 - 0.011834415584416*G0_0_0_9_4 + 0.00739650974026*G0_0_0_9_5 + 0.011834415584416*G0_0_0_9_6 + 0.00887581168831201*G0_0_0_9_7 - 0.008875811688312*G0_0_0_9_8 + 0.00273944805194818*G0_0_1_0_0 + 0.00021002435064936*G0_0_1_0_1 - 0.000517451298701324*G0_0_1_0_2 + 0.000264813311688323*G0_0_1_0_3 - 0.00184456168831177*G0_0_1_0_4 + 0.00378956980519495*G0_0_1_0_5 - 0.00171672077922085*G0_0_1_0_6 + 0.00223721590909101*G0_0_1_0_7 - 0.00107751623376628*G0_0_1_0_8 + 0.000602678571428596*G0_0_1_0_9 + 0.00021002435064936*G0_0_1_1_0 + 0.000420048701298718*G0_0_1_1_1 - 0.00137581168831174*G0_0_1_1_2 + 0.00173498376623383*G0_0_1_1_3 - 0.00253855519480529*G0_0_1_1_4 + 0.00100446428571432*G0_0_1_1_5 + 0.000127840909090909*G0_0_1_1_6 + 0.000566152597402621*G0_0_1_1_7 + 0.00158887987012992*G0_0_1_1_9 - 0.000517451298701324*G0_0_1_2_0 - 0.00137581168831174*G0_0_1_2_1 - 0.0195413961038968*G0_0_1_2_2 + 0.0071225649350652*G0_0_1_2_3 - 0.0154778814935071*G0_0_1_2_4 + 0.00465706168831187*G0_0_1_2_5 - 0.00808137175324709*G0_0_1_2_6 + 0.00092228084415588*G0_0_1_2_7 - 0.00246550324675334*G0_0_1_2_9 + 0.000264813311688323*G0_0_1_3_0 + 0.00173498376623383*G0_0_1_3_1 + 0.0071225649350652*G0_0_1_3_2 - 0.00345170454545472*G0_0_1_3_3 + 0.00936891233766269*G0_0_1_3_4 - 0.00197240259740267*G0_0_1_3_5 - 0.000246550324675306*G0_0_1_3_6 - 0.000657467532467557*G0_0_1_3_7 + 0.000328733766233777*G0_0_1_3_8 - 0.00345170454545465*G0_0_1_3_9 - 0.00184456168831177*G0_0_1_4_0 - 0.00253855519480529*G0_0_1_4_1 - 0.0154778814935071*G0_0_1_4_2 + 0.00936891233766269*G0_0_1_4_3 - 0.0537479707792228*G0_0_1_4_4 + 0.00567065746753269*G0_0_1_4_5 - 0.00542410714285739*G0_0_1_4_6 + 0.00131493506493512*G0_0_1_4_7 + 0.000328733766233781*G0_0_1_4_8 - 0.00394480519480537*G0_0_1_4_9 + 0.00378956980519495*G0_0_1_5_0 + 0.00100446428571432*G0_0_1_5_1 + 0.00465706168831187*G0_0_1_5_2 - 0.00197240259740267*G0_0_1_5_3 + 0.00567065746753269*G0_0_1_5_4 + 0.0113413149350653*G0_0_1_5_5 - 0.0039448051948053*G0_0_1_5_6 + 0.00550629058441579*G0_0_1_5_7 - 0.00287642045454556*G0_0_1_5_8 + 0.00394480519480535*G0_0_1_5_9 - 0.00171672077922085*G0_0_1_6_0 + 0.000127840909090909*G0_0_1_6_1 - 0.00808137175324709*G0_0_1_6_2 - 0.000246550324675306*G0_0_1_6_3 - 0.00542410714285739*G0_0_1_6_4 - 0.0039448051948053*G0_0_1_6_5 + 0.0202171266233773*G0_0_1_6_6 - 0.00262987012987022*G0_0_1_6_7 - 0.000164366883116882*G0_0_1_6_8 + 0.00788961038961064*G0_0_1_6_9 + 0.00223721590909101*G0_0_1_7_0 + 0.000566152597402621*G0_0_1_7_1 + 0.00092228084415588*G0_0_1_7_2 - 0.000657467532467557*G0_0_1_7_3 + 0.00131493506493512*G0_0_1_7_4 + 0.00550629058441579*G0_0_1_7_5 - 0.00262987012987022*G0_0_1_7_6 + 0.00723214285714318*G0_0_1_7_7 - 0.00287642045454558*G0_0_1_7_8 + 0.00345170454545468*G0_0_1_7_9 - 0.00107751623376628*G0_0_1_8_0 + 0.000328733766233777*G0_0_1_8_3 + 0.000328733766233781*G0_0_1_8_4 - 0.00287642045454556*G0_0_1_8_5 - 0.000164366883116882*G0_0_1_8_6 - 0.00287642045454558*G0_0_1_8_7 - 0.000164366883116884*G0_0_1_8_8 - 0.00542410714285733*G0_0_1_8_9 + 0.000602678571428596*G0_0_1_9_0 + 0.00158887987012992*G0_0_1_9_1 - 0.00246550324675334*G0_0_1_9_2 - 0.00345170454545465*G0_0_1_9_3 - 0.00394480519480537*G0_0_1_9_4 + 0.00394480519480535*G0_0_1_9_5 + 0.00788961038961063*G0_0_1_9_6 + 0.00345170454545468*G0_0_1_9_7 - 0.00542410714285733*G0_0_1_9_8 + 0.00986201298701334*G0_0_1_9_9 + 0.00184456168831181*G0_1_0_0_0 - 0.00283076298701309*G0_1_0_0_1 - 0.00230113636363645*G0_1_0_0_3 - 0.00279423701298712*G0_1_0_0_4 + 0.00205458603896114*G0_1_0_0_5 - 0.00115056818181823*G0_1_0_0_6 + 0.00690340909090938*G0_1_0_0_7 - 0.0078896103896107*G0_1_0_0_8 - 0.00295860389610399*G0_1_0_0_9 - 0.00283076298701309*G0_1_0_1_0 - 0.0452008928571444*G0_1_0_1_1 - 0.00278510551948061*G0_1_0_1_2 - 0.0172585227272733*G0_1_0_1_3 + 0.00936891233766264*G0_1_0_1_4 + 0.000904017857142894*G0_1_0_1_5 + 0.00115056818181822*G0_1_0_1_6 + 0.0157792207792214*G0_1_0_1_7 - 0.0345170454545467*G0_1_0_1_8 - 0.00295860389610401*G0_1_0_1_9 - 0.00278510551948061*G0_1_0_2_1 - 0.00200892857142864*G0_1_0_2_2 + 0.00139711850649356*G0_1_0_2_3 - 0.000821834415584451*G0_1_0_2_4 - 0.000246550324675326*G0_1_0_2_5 + 0.00189021915584423*G0_1_0_2_7 - 0.00402698863636377*G0_1_0_2_8 + 0.000493100649350669*G0_1_0_2_9 - 0.00230113636363645*G0_1_0_3_0 - 0.0172585227272733*G0_1_0_3_1 + 0.00139711850649356*G0_1_0_3_2 - 0.0251481331168839*G0_1_0_3_3 + 0.00517755681818196*G0_1_0_3_4 + 0.000739650974025989*G0_1_0_3_5 - 0.000739650974025994*G0_1_0_3_6 + 0.00961546266233798*G0_1_0_3_7 - 0.024408482142858*G0_1_0_3_8 - 0.010355113636364*G0_1_0_3_9 - 0.00279423701298713*G0_1_0_4_0 + 0.00936891233766264*G0_1_0_4_1 - 0.000821834415584451*G0_1_0_4_2 + 0.00517755681818196*G0_1_0_4_3 - 0.093196022727276*G0_1_0_4_4 + 0.01109476461039*G0_1_0_4_5 - 0.010355113636364*G0_1_0_4_6 + 0.01479301948052*G0_1_0_4_8 - 0.023668831168832*G0_1_0_4_9 + 0.00205458603896114*G0_1_0_5_0 + 0.000904017857142894*G0_1_0_5_1 - 0.000246550324675326*G0_1_0_5_2 + 0.000739650974025989*G0_1_0_5_3 + 0.01109476461039*G0_1_0_5_4 + 0.000739650974025967*G0_1_0_5_6 + 0.00295860389610405*G0_1_0_5_7 + 0.008875811688312*G0_1_0_5_9 - 0.00115056818181823*G0_1_0_6_0 + 0.00115056818181822*G0_1_0_6_1 - 0.000739650974025993*G0_1_0_6_3 - 0.010355113636364*G0_1_0_6_4 + 0.000739650974025966*G0_1_0_6_5 + 0.010355113636364*G0_1_0_6_6 - 0.00295860389610402*G0_1_0_6_7 + 0.002958603896104*G0_1_0_6_8 + 0.00690340909090938*G0_1_0_7_0 + 0.0157792207792214*G0_1_0_7_1 + 0.00189021915584423*G0_1_0_7_2 + 0.00961546266233798*G0_1_0_7_3 + 0.00295860389610404*G0_1_0_7_5 - 0.00295860389610402*G0_1_0_7_6 + 0.0177516233766241*G0_1_0_7_7 + 0.023668831168832*G0_1_0_7_8 + 0.01479301948052*G0_1_0_7_9 - 0.0078896103896107*G0_1_0_8_0 - 0.0345170454545467*G0_1_0_8_1 - 0.00402698863636377*G0_1_0_8_2 - 0.024408482142858*G0_1_0_8_3 + 0.01479301948052*G0_1_0_8_4 + 0.002958603896104*G0_1_0_8_6 + 0.023668831168832*G0_1_0_8_7 - 0.10355113636364*G0_1_0_8_8 - 0.020710227272728*G0_1_0_8_9 - 0.00295860389610399*G0_1_0_9_0 - 0.00295860389610401*G0_1_0_9_1 + 0.000493100649350668*G0_1_0_9_2 - 0.010355113636364*G0_1_0_9_3 - 0.023668831168832*G0_1_0_9_4 + 0.008875811688312*G0_1_0_9_5 + 0.01479301948052*G0_1_0_9_7 - 0.020710227272728*G0_1_0_9_8 - 0.0177516233766239*G0_1_0_9_9 + 0.00273944805194822*G0_1_1_0_0 + 0.000657467532467562*G0_1_1_0_1 - 0.000748782467532496*G0_1_1_0_3 - 0.00184456168831177*G0_1_1_0_4 + 0.00155235389610399*G0_1_1_0_5 - 0.000858360389610439*G0_1_1_0_6 + 0.00447443181818202*G0_1_1_0_7 - 0.00177150974025982*G0_1_1_0_8 + 0.000438311688311711*G0_1_1_0_9 + 0.000657467532467562*G0_1_1_1_0 + 0.00739650974025999*G0_1_1_1_1 - 0.000276988636363649*G0_1_1_1_2 + 0.00465706168831184*G0_1_1_1_3 - 0.00158887987012993*G0_1_1_1_4 + 0.000210024350649365*G0_1_1_1_5 + 0.000292207792207798*G0_1_1_1_6 - 0.000109577922077921*G0_1_1_1_7 + 0.00219155844155853*G0_1_1_1_8 + 0.00197240259740267*G0_1_1_1_9 - 0.000276988636363649*G0_1_1_2_1 - 0.0030742694805196*G0_1_1_2_2 + 0.00346083603896117*G0_1_1_2_3 - 0.00434659090909107*G0_1_1_2_4 + 0.000922280844155887*G0_1_1_2_5 - 0.0020911120129871*G0_1_1_2_6 + 0.00070312500000003*G0_1_1_2_7 - 0.000337865259740272*G0_1_1_2_8 - 0.00136972402597407*G0_1_1_2_9 - 0.000748782467532496*G0_1_1_3_0 + 0.00465706168831184*G0_1_1_3_1 + 0.00346083603896117*G0_1_1_3_2 - 0.0276136363636373*G0_1_1_3_3 - 0.00271205357142866*G0_1_1_3_4 + 0.00106838474025976*G0_1_1_3_5 - 0.00139711850649354*G0_1_1_3_6 + 0.00172585227272732*G0_1_1_3_7 - 0.00221895292207798*G0_1_1_3_8 - 0.00936891233766265*G0_1_1_3_9 - 0.00184456168831177*G0_1_1_4_0 - 0.00158887987012993*G0_1_1_4_1 - 0.00434659090909107*G0_1_1_4_2 - 0.00271205357142866*G0_1_1_4_3 - 0.0537479707792228*G0_1_1_4_4 + 0.00501318993506512*G0_1_1_4_5 - 0.00361607142857159*G0_1_1_4_6 + 0.00197240259740267*G0_1_1_4_7 + 0.000493100649350664*G0_1_1_4_8 - 0.00591720779220804*G0_1_1_4_9 + 0.00155235389610399*G0_1_1_5_0 + 0.000210024350649365*G0_1_1_5_1 + 0.000922280844155887*G0_1_1_5_2 + 0.00106838474025976*G0_1_1_5_3 + 0.00501318993506512*G0_1_1_5_4 + 0.000328733766233849*G0_1_1_5_5 - 0.000657467532467577*G0_1_1_5_6 + 0.00378043831168849*G0_1_1_5_7 - 0.00115056818181824*G0_1_1_5_8 + 0.00098620129870136*G0_1_1_5_9 - 0.000858360389610439*G0_1_1_6_0 + 0.000292207792207798*G0_1_1_6_1 - 0.0020911120129871*G0_1_1_6_2 - 0.00139711850649354*G0_1_1_6_3 - 0.00361607142857159*G0_1_1_6_4 - 0.000657467532467576*G0_1_1_6_5 + 0.00673904220779243*G0_1_1_6_6 - 0.00262987012987024*G0_1_1_6_7 + 0.000328733766233787*G0_1_1_6_8 + 0.0069034090909093*G0_1_1_6_9 + 0.00447443181818202*G0_1_1_7_0 - 0.000109577922077921*G0_1_1_7_1 + 0.00070312500000003*G0_1_1_7_2 + 0.00172585227272732*G0_1_1_7_3 + 0.00197240259740267*G0_1_1_7_4 + 0.00378043831168849*G0_1_1_7_5 - 0.00262987012987024*G0_1_1_7_6 + 0.0216964285714295*G0_1_1_7_7 - 0.00542410714285739*G0_1_1_7_8 + 0.00394480519480537*G0_1_1_7_9 - 0.00177150974025982*G0_1_1_8_0 + 0.00219155844155852*G0_1_1_8_1 - 0.000337865259740272*G0_1_1_8_2 - 0.00221895292207798*G0_1_1_8_3 + 0.000493100649350664*G0_1_1_8_4 - 0.00115056818181825*G0_1_1_8_5 + 0.000328733766233787*G0_1_1_8_6 - 0.00542410714285739*G0_1_1_8_7 - 0.0123275162337666*G0_1_1_8_8 - 0.00690340909090933*G0_1_1_8_9 + 0.000438311688311711*G0_1_1_9_0 + 0.00197240259740267*G0_1_1_9_1 - 0.00136972402597407*G0_1_1_9_2 - 0.00936891233766265*G0_1_1_9_3 - 0.00591720779220804*G0_1_1_9_4 + 0.00098620129870136*G0_1_1_9_5 + 0.0069034090909093*G0_1_1_9_6 + 0.00394480519480537*G0_1_1_9_7 - 0.00690340909090933*G0_1_1_9_8 + 0.0394480519480533*G0_1_1_9_9;
    A[4] = A[40] + 0.000447443181818202*G0_0_1_0_1 + 0.000566152597402626*G0_0_1_0_2 - 0.00101359577922082*G0_0_1_0_3 - 0.00223721590909096*G0_0_1_0_5 + 0.000858360389610411*G0_0_1_0_6 + 0.00223721590909101*G0_0_1_0_7 - 0.000693993506493541*G0_0_1_0_8 - 0.000164366883116883*G0_0_1_0_9 + 0.000447443181818203*G0_0_1_1_0 + 0.00697646103896127*G0_0_1_1_1 + 0.00109882305194809*G0_0_1_1_2 + 0.00292207792207801*G0_0_1_1_3 + 0.000949675324675364*G0_0_1_1_4 - 0.000794439935064959*G0_0_1_1_5 + 0.000164366883116889*G0_0_1_1_6 - 0.000675730519480543*G0_0_1_1_7 + 0.00225547889610398*G0_0_1_1_8 + 0.000383522727272745*G0_0_1_1_9 + 0.000566152597402626*G0_0_1_2_0 + 0.00109882305194809*G0_0_1_2_1 + 0.0164671266233772*G0_0_1_2_2 - 0.00366172889610403*G0_0_1_2_3 + 0.011131290584416*G0_0_1_2_4 - 0.00373478084415598*G0_0_1_2_5 + 0.00599025974025998*G0_0_1_2_6 - 0.00021915584415585*G0_0_1_2_7 - 0.000273944805194816*G0_0_1_2_8 + 0.00109577922077926*G0_0_1_2_9 - 0.00101359577922082*G0_0_1_3_0 + 0.00292207792207801*G0_0_1_3_1 - 0.00366172889610403*G0_0_1_3_2 - 0.0241619318181826*G0_0_1_3_3 - 0.0120809659090913*G0_0_1_3_4 + 0.00304078733766244*G0_0_1_3_5 - 0.00115056818181823*G0_0_1_3_6 + 0.00238331980519488*G0_0_1_3_7 - 0.00254768668831176*G0_0_1_3_8 - 0.00591720779220799*G0_0_1_3_9 + 0.000949675324675364*G0_0_1_4_1 + 0.011131290584416*G0_0_1_4_2 - 0.0120809659090913*G0_0_1_4_3 - 0.000657467532467572*G0_0_1_4_5 + 0.0018080357142858*G0_0_1_4_6 + 0.000657467532467551*G0_0_1_4_7 + 0.000164366883116886*G0_0_1_4_8 - 0.00197240259740265*G0_0_1_4_9 - 0.00223721590909096*G0_0_1_5_0 - 0.00079443993506496*G0_0_1_5_1 - 0.00373478084415598*G0_0_1_5_2 + 0.00304078733766244*G0_0_1_5_3 - 0.00065746753246757*G0_0_1_5_4 - 0.0110125811688315*G0_0_1_5_5 + 0.00328733766233773*G0_0_1_5_6 - 0.0017258522727273*G0_0_1_5_7 + 0.00172585227272732*G0_0_1_5_8 - 0.00295860389610399*G0_0_1_5_9 + 0.000858360389610411*G0_0_1_6_0 + 0.000164366883116888*G0_0_1_6_1 + 0.00599025974025998*G0_0_1_6_2 - 0.00115056818181823*G0_0_1_6_3 + 0.0018080357142858*G0_0_1_6_4 + 0.00328733766233773*G0_0_1_6_5 - 0.0134780844155849*G0_0_1_6_6 + 0.000493100649350671*G0_0_1_6_8 - 0.000986201298701336*G0_0_1_6_9 + 0.00223721590909101*G0_0_1_7_0 - 0.000675730519480543*G0_0_1_7_1 - 0.00021915584415585*G0_0_1_7_2 + 0.00238331980519488*G0_0_1_7_3 + 0.000657467532467551*G0_0_1_7_4 - 0.0017258522727273*G0_0_1_7_5 + 0.0144642857142863*G0_0_1_7_7 - 0.00254768668831181*G0_0_1_7_8 + 0.000493100649350682*G0_0_1_7_9 - 0.000693993506493541*G0_0_1_8_0 + 0.00225547889610398*G0_0_1_8_1 - 0.000273944805194816*G0_0_1_8_2 - 0.00254768668831176*G0_0_1_8_3 + 0.000164366883116886*G0_0_1_8_4 + 0.00172585227272732*G0_0_1_8_5 + 0.000493100649350671*G0_0_1_8_6 - 0.00254768668831181*G0_0_1_8_7 - 0.0121631493506498*G0_0_1_8_8 - 0.001479301948052*G0_0_1_8_9 - 0.000164366883116882*G0_0_1_9_0 + 0.000383522727272745*G0_0_1_9_1 + 0.00109577922077926*G0_0_1_9_2 - 0.00591720779220799*G0_0_1_9_3 - 0.00197240259740265*G0_0_1_9_4 - 0.00295860389610399*G0_0_1_9_5 - 0.000986201298701332*G0_0_1_9_6 + 0.000493100649350682*G0_0_1_9_7 - 0.001479301948052*G0_0_1_9_8 + 0.0295860389610399*G0_0_1_9_9 - 0.000447443181818202*G0_1_0_0_1 - 0.000566152597402626*G0_1_0_0_2 + 0.00101359577922082*G0_1_0_0_3 + 0.00223721590909096*G0_1_0_0_5 - 0.000858360389610411*G0_1_0_0_6 - 0.00223721590909101*G0_1_0_0_7 + 0.00069399350649354*G0_1_0_0_8 + 0.000164366883116883*G0_1_0_0_9 - 0.000447443181818203*G0_1_0_1_0 - 0.00697646103896127*G0_1_0_1_1 - 0.00109882305194809*G0_1_0_1_2 - 0.00292207792207801*G0_1_0_1_3 - 0.000949675324675364*G0_1_0_1_4 + 0.00079443993506496*G0_1_0_1_5 - 0.000164366883116889*G0_1_0_1_6 + 0.000675730519480543*G0_1_0_1_7 - 0.00225547889610398*G0_1_0_1_8 - 0.000383522727272745*G0_1_0_1_9 - 0.000566152597402626*G0_1_0_2_0 - 0.00109882305194809*G0_1_0_2_1 - 0.0164671266233772*G0_1_0_2_2 + 0.00366172889610403*G0_1_0_2_3 - 0.011131290584416*G0_1_0_2_4 + 0.00373478084415598*G0_1_0_2_5 - 0.00599025974025998*G0_1_0_2_6 + 0.00021915584415585*G0_1_0_2_7 + 0.000273944805194816*G0_1_0_2_8 - 0.00109577922077926*G0_1_0_2_9 + 0.00101359577922082*G0_1_0_3_0 - 0.00292207792207801*G0_1_0_3_1 + 0.00366172889610403*G0_1_0_3_2 + 0.0241619318181826*G0_1_0_3_3 + 0.0120809659090914*G0_1_0_3_4 - 0.00304078733766244*G0_1_0_3_5 + 0.00115056818181823*G0_1_0_3_6 - 0.00238331980519488*G0_1_0_3_7 + 0.00254768668831176*G0_1_0_3_8 + 0.00591720779220799*G0_1_0_3_9 - 0.000949675324675364*G0_1_0_4_1 - 0.011131290584416*G0_1_0_4_2 + 0.0120809659090913*G0_1_0_4_3 + 0.00065746753246757*G0_1_0_4_5 - 0.0018080357142858*G0_1_0_4_6 - 0.000657467532467552*G0_1_0_4_7 - 0.000164366883116886*G0_1_0_4_8 + 0.00197240259740266*G0_1_0_4_9 + 0.00223721590909096*G0_1_0_5_0 + 0.00079443993506496*G0_1_0_5_1 + 0.00373478084415598*G0_1_0_5_2 - 0.00304078733766244*G0_1_0_5_3 + 0.000657467532467572*G0_1_0_5_4 + 0.0110125811688315*G0_1_0_5_5 - 0.00328733766233773*G0_1_0_5_6 + 0.0017258522727273*G0_1_0_5_7 - 0.00172585227272732*G0_1_0_5_8 + 0.00295860389610399*G0_1_0_5_9 - 0.000858360389610411*G0_1_0_6_0 - 0.000164366883116889*G0_1_0_6_1 - 0.00599025974025998*G0_1_0_6_2 + 0.00115056818181823*G0_1_0_6_3 - 0.0018080357142858*G0_1_0_6_4 - 0.00328733766233773*G0_1_0_6_5 + 0.0134780844155849*G0_1_0_6_6 - 0.000493100649350671*G0_1_0_6_8 + 0.000986201298701334*G0_1_0_6_9 - 0.00223721590909101*G0_1_0_7_0 + 0.000675730519480543*G0_1_0_7_1 + 0.00021915584415585*G0_1_0_7_2 - 0.00238331980519488*G0_1_0_7_3 - 0.000657467532467551*G0_1_0_7_4 + 0.0017258522727273*G0_1_0_7_5 - 0.0144642857142863*G0_1_0_7_7 + 0.00254768668831181*G0_1_0_7_8 - 0.000493100649350682*G0_1_0_7_9 + 0.00069399350649354*G0_1_0_8_0 - 0.00225547889610398*G0_1_0_8_1 + 0.000273944805194816*G0_1_0_8_2 + 0.00254768668831176*G0_1_0_8_3 - 0.000164366883116886*G0_1_0_8_4 - 0.00172585227272732*G0_1_0_8_5 - 0.000493100649350671*G0_1_0_8_6 + 0.00254768668831181*G0_1_0_8_7 + 0.0121631493506498*G0_1_0_8_8 + 0.001479301948052*G0_1_0_8_9 + 0.000164366883116883*G0_1_0_9_0 - 0.000383522727272745*G0_1_0_9_1 - 0.00109577922077926*G0_1_0_9_2 + 0.00591720779220799*G0_1_0_9_3 + 0.00197240259740265*G0_1_0_9_4 + 0.00295860389610399*G0_1_0_9_5 + 0.000986201298701332*G0_1_0_9_6 - 0.000493100649350681*G0_1_0_9_7 + 0.001479301948052*G0_1_0_9_8 - 0.0295860389610399*G0_1_0_9_9;
    A[60] = -A[40] + 0.0525974025974045*G0_1_0_0_0 + 0.00393567370129884*G0_1_0_0_1 + 0.00307426948051959*G0_1_0_0_2 - 0.00170758928571436*G0_1_0_0_3 - 0.000858360389610423*G0_1_0_0_4 + 0.0196783685064942*G0_1_0_0_5 - 0.0100994318181822*G0_1_0_0_6 + 0.0389458198051962*G0_1_0_0_7 - 0.0165827922077928*G0_1_0_0_8 + 0.00476663961038981*G0_1_0_0_9 + 0.00393567370129884*G0_1_0_1_0 + 0.00787134740259767*G0_1_0_1_1 + 0.00106534090909095*G0_1_0_1_2 + 0.00241984577922085*G0_1_0_1_3 + 0.00124188311688316*G0_1_0_1_4 + 0.000757913961038991*G0_1_0_1_5 + 0.00111404220779225*G0_1_0_1_6 + 0.00544237012987032*G0_1_0_1_7 - 0.000173498376623372*G0_1_0_1_8 + 0.00378043831168845*G0_1_0_1_9 + 0.00307426948051959*G0_1_0_2_0 + 0.00106534090909095*G0_1_0_2_1 + 0.0154017857142863*G0_1_0_2_2 - 0.00249289772727282*G0_1_0_2_3 + 0.0090401785714289*G0_1_0_2_4 - 0.00167106331168838*G0_1_0_2_5 + 0.00246550324675336*G0_1_0_2_6 + 0.00346996753246765*G0_1_0_2_7 - 0.00146103896103901*G0_1_0_2_8 - 0.000767045454545472*G0_1_0_2_9 - 0.00170758928571436*G0_1_0_3_0 + 0.00241984577922085*G0_1_0_3_1 - 0.00249289772727282*G0_1_0_3_2 - 0.0238331980519489*G0_1_0_3_3 - 0.0134780844155849*G0_1_0_3_4 + 0.00336952110389621*G0_1_0_3_5 - 0.0072321428571431*G0_1_0_3_6 + 0.00123275162337664*G0_1_0_3_7 - 0.00172585227272732*G0_1_0_3_8 - 0.0138068181818186*G0_1_0_3_9 - 0.000858360389610423*G0_1_0_4_0 + 0.00124188311688316*G0_1_0_4_1 + 0.0090401785714289*G0_1_0_4_2 - 0.0134780844155849*G0_1_0_4_3 - 0.00361607142857159*G0_1_0_4_4 - 0.00131493506493512*G0_1_0_4_5 + 0.00854707792207822*G0_1_0_4_6 - 0.00197240259740267*G0_1_0_4_7 + 0.000493100649350667*G0_1_0_4_8 + 0.00493100649350664*G0_1_0_4_9 + 0.0196783685064942*G0_1_0_5_0 + 0.000757913961038991*G0_1_0_5_1 - 0.00167106331168838*G0_1_0_5_2 + 0.00336952110389621*G0_1_0_5_3 - 0.00131493506493512*G0_1_0_5_4 - 0.0134780844155848*G0_1_0_5_5 - 0.00460227272727292*G0_1_0_5_6 + 0.0204636769480527*G0_1_0_5_7 - 0.00616375811688335*G0_1_0_5_8 - 0.00197240259740265*G0_1_0_5_9 - 0.0100994318181822*G0_1_0_6_0 + 0.00111404220779225*G0_1_0_6_1 + 0.00246550324675336*G0_1_0_6_2 - 0.0072321428571431*G0_1_0_6_3 + 0.00854707792207822*G0_1_0_6_4 - 0.00460227272727292*G0_1_0_6_5 + 0.0259699675324684*G0_1_0_6_6 - 0.0142999188311693*G0_1_0_6_7 + 0.00246550324675334*G0_1_0_6_8 + 0.0167654220779226*G0_1_0_6_9 + 0.0389458198051962*G0_1_0_7_0 + 0.00544237012987032*G0_1_0_7_1 + 0.00346996753246765*G0_1_0_7_2 + 0.00123275162337664*G0_1_0_7_3 - 0.00197240259740267*G0_1_0_7_4 + 0.0204636769480527*G0_1_0_7_5 - 0.0142999188311693*G0_1_0_7_6 + 0.10568790584416*G0_1_0_7_7 - 0.0316406250000012*G0_1_0_7_8 + 0.0142999188311694*G0_1_0_7_9 - 0.0165827922077928*G0_1_0_8_0 - 0.000173498376623372*G0_1_0_8_1 - 0.00146103896103901*G0_1_0_8_2 - 0.00172585227272732*G0_1_0_8_3 + 0.000493100649350667*G0_1_0_8_4 - 0.00616375811688335*G0_1_0_8_5 + 0.00246550324675334*G0_1_0_8_6 - 0.0316406250000012*G0_1_0_8_7 - 0.0082183441558444*G0_1_0_8_8 - 0.0123275162337667*G0_1_0_8_9 + 0.00476663961038981*G0_1_0_9_0 + 0.00378043831168845*G0_1_0_9_1 - 0.000767045454545472*G0_1_0_9_2 - 0.0138068181818186*G0_1_0_9_3 + 0.00493100649350664*G0_1_0_9_4 - 0.00197240259740265*G0_1_0_9_5 + 0.0167654220779226*G0_1_0_9_6 + 0.0142999188311694*G0_1_0_9_7 - 0.0123275162337667*G0_1_0_9_8 + 0.0867857142857172*G0_1_0_9_9 + 0.0525974025974045*G0_1_1_0_0 + 0.00393567370129884*G0_1_1_0_1 + 0.00307426948051959*G0_1_1_0_2 - 0.00170758928571436*G0_1_1_0_3 - 0.000858360389610423*G0_1_1_0_4 + 0.0196783685064942*G0_1_1_0_5 - 0.0100994318181822*G0_1_1_0_6 + 0.0389458198051962*G0_1_1_0_7 - 0.0165827922077928*G0_1_1_0_8 + 0.00476663961038981*G0_1_1_0_9 + 0.00393567370129884*G0_1_1_1_0 + 0.00787134740259767*G0_1_1_1_1 + 0.00106534090909095*G0_1_1_1_2 + 0.00241984577922085*G0_1_1_1_3 + 0.00124188311688317*G0_1_1_1_4 + 0.000757913961038992*G0_1_1_1_5 + 0.00111404220779225*G0_1_1_1_6 + 0.00544237012987032*G0_1_1_1_7 - 0.000173498376623374*G0_1_1_1_8 + 0.00378043831168845*G0_1_1_1_9 + 0.00307426948051959*G0_1_1_2_0 + 0.00106534090909095*G0_1_1_2_1 + 0.0154017857142863*G0_1_1_2_2 - 0.00249289772727282*G0_1_1_2_3 + 0.0090401785714289*G0_1_1_2_4 - 0.00167106331168838*G0_1_1_2_5 + 0.00246550324675336*G0_1_1_2_6 + 0.00346996753246765*G0_1_1_2_7 - 0.00146103896103901*G0_1_1_2_8 - 0.000767045454545471*G0_1_1_2_9 - 0.00170758928571436*G0_1_1_3_0 + 0.00241984577922085*G0_1_1_3_1 - 0.00249289772727282*G0_1_1_3_2 - 0.0238331980519489*G0_1_1_3_3 - 0.0134780844155849*G0_1_1_3_4 + 0.00336952110389621*G0_1_1_3_5 - 0.0072321428571431*G0_1_1_3_6 + 0.00123275162337664*G0_1_1_3_7 - 0.00172585227272732*G0_1_1_3_8 - 0.0138068181818187*G0_1_1_3_9 - 0.000858360389610423*G0_1_1_4_0 + 0.00124188311688317*G0_1_1_4_1 + 0.0090401785714289*G0_1_1_4_2 - 0.0134780844155849*G0_1_1_4_3 - 0.00361607142857161*G0_1_1_4_4 - 0.00131493506493512*G0_1_1_4_5 + 0.00854707792207822*G0_1_1_4_6 - 0.00197240259740267*G0_1_1_4_7 + 0.000493100649350663*G0_1_1_4_8 + 0.00493100649350663*G0_1_1_4_9 + 0.0196783685064942*G0_1_1_5_0 + 0.000757913961038992*G0_1_1_5_1 - 0.00167106331168838*G0_1_1_5_2 + 0.00336952110389621*G0_1_1_5_3 - 0.00131493506493512*G0_1_1_5_4 - 0.0134780844155848*G0_1_1_5_5 - 0.00460227272727292*G0_1_1_5_6 + 0.0204636769480527*G0_1_1_5_7 - 0.00616375811688335*G0_1_1_5_8 - 0.00197240259740264*G0_1_1_5_9 - 0.0100994318181822*G0_1_1_6_0 + 0.00111404220779225*G0_1_1_6_1 + 0.00246550324675336*G0_1_1_6_2 - 0.0072321428571431*G0_1_1_6_3 + 0.00854707792207822*G0_1_1_6_4 - 0.00460227272727292*G0_1_1_6_5 + 0.0259699675324684*G0_1_1_6_6 - 0.0142999188311693*G0_1_1_6_7 + 0.00246550324675334*G0_1_1_6_8 + 0.0167654220779226*G0_1_1_6_9 + 0.0389458198051962*G0_1_1_7_0 + 0.00544237012987032*G0_1_1_7_1 + 0.00346996753246765*G0_1_1_7_2 + 0.00123275162337665*G0_1_1_7_3 - 0.00197240259740267*G0_1_1_7_4 + 0.0204636769480527*G0_1_1_7_5 - 0.0142999188311693*G0_1_1_7_6 + 0.10568790584416*G0_1_1_7_7 - 0.0316406250000012*G0_1_1_7_8 + 0.0142999188311694*G0_1_1_7_9 - 0.0165827922077928*G0_1_1_8_0 - 0.000173498376623375*G0_1_1_8_1 - 0.00146103896103901*G0_1_1_8_2 - 0.00172585227272732*G0_1_1_8_3 + 0.000493100649350663*G0_1_1_8_4 - 0.00616375811688335*G0_1_1_8_5 + 0.00246550324675334*G0_1_1_8_6 - 0.0316406250000012*G0_1_1_8_7 - 0.00821834415584437*G0_1_1_8_8 - 0.0123275162337667*G0_1_1_8_9 + 0.00476663961038981*G0_1_1_9_0 + 0.00378043831168845*G0_1_1_9_1 - 0.000767045454545472*G0_1_1_9_2 - 0.0138068181818187*G0_1_1_9_3 + 0.00493100649350663*G0_1_1_9_4 - 0.00197240259740264*G0_1_1_9_5 + 0.0167654220779226*G0_1_1_9_6 + 0.0142999188311694*G0_1_1_9_7 - 0.0123275162337667*G0_1_1_9_8 + 0.0867857142857172*G0_1_1_9_9;
    A[71] = -A[41] + 0.0180560064935071*G0_0_0_0_0 + 0.00281554383116894*G0_0_0_0_1 + 0.00271814123376634*G0_0_0_0_2 + 0.00176237824675332*G0_0_0_0_3 - 0.00125101461038966*G0_0_0_0_4 + 0.0116517857142861*G0_0_0_0_5 - 0.00341517857142866*G0_0_0_0_6 + 0.00462053571428585*G0_0_0_0_7 - 0.00315949675324685*G0_0_0_0_8 - 0.00098620129870132*G0_0_0_0_9 + 0.00281554383116894*G0_0_0_1_0 + 0.047118506493508*G0_0_0_1_1 + 0.0037956574675326*G0_0_0_1_2 + 0.0306818181818192*G0_0_0_1_3 - 0.0130945616883121*G0_0_0_1_4 + 0.000721387987013005*G0_0_0_1_5 + 0.000885754870129908*G0_0_0_1_6 - 0.00816355519480549*G0_0_0_1_7 + 0.0158887987012993*G0_0_0_1_8 + 0.0037256493506495*G0_0_0_1_9 + 0.00271814123376634*G0_0_0_2_0 + 0.0037956574675326*G0_0_0_2_1 + 0.0200162337662345*G0_0_0_2_2 + 0.000894886363636376*G0_0_0_2_3 + 0.00571631493506517*G0_0_0_2_4 - 0.00429180194805212*G0_0_0_2_5 + 0.0132406655844161*G0_0_0_2_6 + 0.000885754870129897*G0_0_0_2_7 - 0.000374391233766243*G0_0_0_2_8 + 0.00427353896103911*G0_0_0_2_9 + 0.00176237824675332*G0_0_0_3_0 + 0.0306818181818192*G0_0_0_3_1 + 0.000894886363636376*G0_0_0_3_2 + 0.0726501623376649*G0_0_0_3_3 - 0.0222717126623384*G0_0_0_3_4 - 0.00197240259740265*G0_0_0_3_5 - 0.00616375811688334*G0_0_0_3_6 - 0.00879362824675359*G0_0_0_3_7 + 0.0111769480519485*G0_0_0_3_8 + 0.00641030844155871*G0_0_0_3_9 - 0.00125101461038966*G0_0_0_4_0 - 0.0130945616883121*G0_0_0_4_1 + 0.00571631493506517*G0_0_0_4_2 - 0.0222717126623384*G0_0_0_4_3 - 0.0161079545454551*G0_0_0_4_4 + 0.000246550324675315*G0_0_0_4_5 + 0.00591720779220803*G0_0_0_4_6 + 0.00230113636363645*G0_0_0_4_7 - 0.00238331980519491*G0_0_0_4_8 - 0.013313717532468*G0_0_0_4_9 + 0.0116517857142861*G0_0_0_5_0 + 0.000721387987013005*G0_0_0_5_1 - 0.00429180194805212*G0_0_0_5_2 - 0.00197240259740265*G0_0_0_5_3 + 0.000246550324675315*G0_0_0_5_4 + 0.0535836038961057*G0_0_0_5_5 - 0.0201349431818189*G0_0_0_5_6 + 0.011834415584416*G0_0_0_5_7 - 0.00567065746753266*G0_0_0_5_8 + 0.0142999188311693*G0_0_0_5_9 - 0.00341517857142865*G0_0_0_6_0 + 0.000885754870129908*G0_0_0_6_1 + 0.0132406655844161*G0_0_0_6_2 - 0.00616375811688334*G0_0_0_6_3 + 0.00591720779220803*G0_0_0_6_4 - 0.0201349431818189*G0_0_0_6_5 + 0.0575284090909111*G0_0_0_6_6 - 0.00616375811688332*G0_0_0_6_7 + 0.000986201298701333*G0_0_0_6_8 - 0.000493100649350668*G0_0_0_6_9 + 0.00462053571428585*G0_0_0_7_0 - 0.00816355519480549*G0_0_0_7_1 + 0.000885754870129897*G0_0_0_7_2 - 0.00879362824675359*G0_0_0_7_3 + 0.00230113636363645*G0_0_0_7_4 + 0.011834415584416*G0_0_0_7_5 - 0.00616375811688332*G0_0_0_7_6 + 0.0193952922077929*G0_0_0_7_7 - 0.00106838474025981*G0_0_0_7_8 + 0.0152861201298707*G0_0_0_7_9 - 0.00315949675324685*G0_0_0_8_0 + 0.0158887987012993*G0_0_0_8_1 - 0.000374391233766242*G0_0_0_8_2 + 0.0111769480519485*G0_0_0_8_3 - 0.00238331980519491*G0_0_0_8_4 - 0.00567065746753266*G0_0_0_8_5 + 0.000986201298701333*G0_0_0_8_6 - 0.00106838474025981*G0_0_0_8_7 - 0.0210389610389617*G0_0_0_8_8 - 0.00641030844155865*G0_0_0_8_9 - 0.00098620129870132*G0_0_0_9_0 + 0.0037256493506495*G0_0_0_9_1 + 0.00427353896103911*G0_0_0_9_2 + 0.00641030844155871*G0_0_0_9_3 - 0.013313717532468*G0_0_0_9_4 + 0.0142999188311693*G0_0_0_9_5 - 0.000493100649350668*G0_0_0_9_6 + 0.0152861201298707*G0_0_0_9_7 - 0.00641030844155865*G0_0_0_9_8 + 0.0374756493506506*G0_0_0_9_9 - 0.00196022727272735*G0_1_0_0_0 - 0.000980113636363676*G0_1_0_0_1 + 0.00213676948051957*G0_1_0_0_3 - 0.00213676948051956*G0_1_0_0_4 - 0.00158887987012993*G0_1_0_0_5 + 0.000876623376623411*G0_1_0_0_6 - 0.00109577922077926*G0_1_0_0_7 - 0.00405438311688326*G0_1_0_0_8 - 0.00525974025974044*G0_1_0_0_9 - 0.000980113636363675*G0_1_0_1_0 + 0.00098011363636367*G0_1_0_1_2 + 0.01479301948052*G0_1_0_1_3 - 0.00493100649350665*G0_1_0_1_4 - 0.000164366883116888*G0_1_0_1_5 + 0.000164366883116886*G0_1_0_1_6 + 0.00493100649350668*G0_1_0_1_7 - 0.01479301948052*G0_1_0_1_8 + 0.00098011363636367*G0_1_0_2_1 + 0.00196022727272736*G0_1_0_2_2 + 0.00405438311688325*G0_1_0_2_3 + 0.00109577922077927*G0_1_0_2_4 - 0.000876623376623415*G0_1_0_2_5 + 0.00158887987012994*G0_1_0_2_6 + 0.00213676948051955*G0_1_0_2_7 - 0.00213676948051955*G0_1_0_2_8 + 0.00525974025974044*G0_1_0_2_9 + 0.00213676948051957*G0_1_0_3_0 + 0.01479301948052*G0_1_0_3_1 + 0.00405438311688325*G0_1_0_3_2 + 0.0936891233766268*G0_1_0_3_3 - 0.0212033279220787*G0_1_0_3_4 - 0.002958603896104*G0_1_0_3_5 - 0.000493100649350686*G0_1_0_3_6 - 0.00641030844155872*G0_1_0_3_7 + 0.0128206168831174*G0_1_0_3_9 - 0.00213676948051956*G0_1_0_4_0 - 0.00493100649350665*G0_1_0_4_1 + 0.00109577922077927*G0_1_0_4_2 - 0.0212033279220787*G0_1_0_4_3 - 0.035503246753248*G0_1_0_4_4 + 0.00641030844155866*G0_1_0_4_5 - 0.00591720779220798*G0_1_0_4_6 + 0.00641030844155863*G0_1_0_4_8 - 0.0285998376623387*G0_1_0_4_9 - 0.00158887987012993*G0_1_0_5_0 - 0.000164366883116888*G0_1_0_5_1 - 0.000876623376623415*G0_1_0_5_2 - 0.002958603896104*G0_1_0_5_3 + 0.00641030844155866*G0_1_0_5_4 - 0.00394480519480533*G0_1_0_5_5 + 0.005917207792208*G0_1_0_5_7 + 0.000493100649350662*G0_1_0_5_8 + 0.01479301948052*G0_1_0_5_9 + 0.000876623376623411*G0_1_0_6_0 + 0.000164366883116886*G0_1_0_6_1 + 0.00158887987012994*G0_1_0_6_2 - 0.000493100649350686*G0_1_0_6_3 - 0.00591720779220798*G0_1_0_6_4 + 0.00394480519480537*G0_1_0_6_6 - 0.00641030844155866*G0_1_0_6_7 + 0.00295860389610399*G0_1_0_6_8 - 0.01479301948052*G0_1_0_6_9 - 0.00109577922077926*G0_1_0_7_0 + 0.00493100649350669*G0_1_0_7_1 + 0.00213676948051955*G0_1_0_7_2 - 0.00641030844155872*G0_1_0_7_3 + 0.005917207792208*G0_1_0_7_5 - 0.00641030844155866*G0_1_0_7_6 + 0.0355032467532481*G0_1_0_7_7 + 0.0212033279220786*G0_1_0_7_8 + 0.0285998376623386*G0_1_0_7_9 - 0.00405438311688326*G0_1_0_8_0 - 0.01479301948052*G0_1_0_8_1 - 0.00213676948051955*G0_1_0_8_2 + 0.00641030844155863*G0_1_0_8_4 + 0.000493100649350662*G0_1_0_8_5 + 0.00295860389610399*G0_1_0_8_6 + 0.0212033279220786*G0_1_0_8_7 - 0.0936891233766266*G0_1_0_8_8 - 0.0128206168831173*G0_1_0_8_9 - 0.00525974025974044*G0_1_0_9_0 + 0.00525974025974044*G0_1_0_9_2 + 0.0128206168831174*G0_1_0_9_3 - 0.0285998376623386*G0_1_0_9_4 + 0.01479301948052*G0_1_0_9_5 - 0.01479301948052*G0_1_0_9_6 + 0.0285998376623386*G0_1_0_9_7 - 0.0128206168831173*G0_1_0_9_8;
    A[13] = A[15] + 0.00254464285714293*G0_0_0_0_0 + 0.00127232142857148*G0_0_0_0_1 + 0.00483969155844175*G0_0_0_0_3 - 0.00359780844155858*G0_0_0_0_4 + 0.00463879870129885*G0_0_0_0_5 - 0.00505884740259758*G0_0_0_0_6 + 0.000620941558441568*G0_0_0_0_7 + 0.002976866883117*G0_0_0_0_8 + 0.00241071428571438*G0_0_0_0_9 + 0.00127232142857148*G0_0_0_1_0 + 0.0130275974025979*G0_0_0_1_1 + 0.00103490259740263*G0_0_0_1_2 + 0.019267451298702*G0_0_0_1_3 - 0.00818181818181847*G0_0_0_1_4 + 0.000894886363636393*G0_0_0_1_5 - 0.00113230519480524*G0_0_0_1_6 - 0.00507711038961059*G0_0_0_1_7 + 0.0103185876623381*G0_0_0_1_8 + 0.00339691558441571*G0_0_0_1_9 + 0.00103490259740263*G0_0_0_2_1 - 0.0164366883116889*G0_0_0_2_2 + 0.00909496753246785*G0_0_0_2_3 - 0.00684862012987039*G0_0_0_2_4 + 0.00416396103896121*G0_0_0_2_5 - 0.0117796266233771*G0_0_0_2_6 - 0.00272118506493516*G0_0_0_2_7 + 0.00368912337662351*G0_0_0_2_8 + 0.000986201298701333*G0_0_0_2_9 + 0.00483969155844175*G0_0_0_3_0 + 0.019267451298702*G0_0_0_3_1 + 0.00909496753246786*G0_0_0_3_2 + 0.0867857142857174*G0_0_0_3_3 - 0.026627435064936*G0_0_0_3_4 - 0.00690340909090933*G0_0_0_3_5 - 0.0179159902597409*G0_0_0_3_7 + 0.0323802759740272*G0_0_0_3_8 + 0.0256412337662347*G0_0_0_3_9 - 0.00359780844155858*G0_0_0_4_0 - 0.00818181818181847*G0_0_0_4_1 - 0.00684862012987039*G0_0_0_4_2 - 0.026627435064936*G0_0_0_4_3 + 0.00739650974025999*G0_0_0_4_5 - 0.00739650974026001*G0_0_0_4_6 + 0.0111769480519484*G0_0_0_4_7 - 0.0144642857142862*G0_0_0_4_8 - 0.017751623376624*G0_0_0_4_9 + 0.00463879870129885*G0_0_0_5_0 + 0.000894886363636393*G0_0_0_5_1 + 0.00416396103896121*G0_0_0_5_2 - 0.00690340909090933*G0_0_0_5_3 + 0.00739650974025999*G0_0_0_5_4 + 0.0335308441558452*G0_0_0_5_5 + 0.010355113636364*G0_0_0_5_6 + 0.00131493506493511*G0_0_0_5_7 - 0.00608157467532488*G0_0_0_5_8 + 0.00493100649350665*G0_0_0_5_9 - 0.00505884740259758*G0_0_0_6_0 - 0.00113230519480524*G0_0_0_6_1 - 0.0117796266233771*G0_0_0_6_2 - 0.00739650974026001*G0_0_0_6_4 + 0.010355113636364*G0_0_0_6_5 - 0.0147930194805201*G0_0_0_6_6 + 0.00476663961038977*G0_0_0_6_7 - 0.00213676948051956*G0_0_0_6_8 - 0.00295860389610401*G0_0_0_6_9 + 0.000620941558441569*G0_0_0_7_0 - 0.00507711038961059*G0_0_0_7_1 - 0.00272118506493516*G0_0_0_7_2 - 0.0179159902597409*G0_0_0_7_3 + 0.0111769480519484*G0_0_0_7_4 + 0.00131493506493511*G0_0_0_7_5 + 0.00476663961038977*G0_0_0_7_6 - 0.00262987012987021*G0_0_0_7_7 - 0.0149573863636369*G0_0_0_7_8 - 0.0167654220779227*G0_0_0_7_9 + 0.002976866883117*G0_0_0_8_0 + 0.0103185876623381*G0_0_0_8_1 + 0.00368912337662351*G0_0_0_8_2 + 0.0323802759740272*G0_0_0_8_3 - 0.0144642857142862*G0_0_0_8_4 - 0.00608157467532488*G0_0_0_8_5 - 0.00213676948051956*G0_0_0_8_6 - 0.0149573863636369*G0_0_0_8_7 + 0.0358319805194819*G0_0_0_8_8 + 0.0187378246753254*G0_0_0_8_9 + 0.00241071428571438*G0_0_0_9_0 + 0.00339691558441571*G0_0_0_9_1 + 0.000986201298701333*G0_0_0_9_2 + 0.0256412337662347*G0_0_0_9_3 - 0.017751623376624*G0_0_0_9_4 + 0.00493100649350665*G0_0_0_9_5 - 0.00295860389610401*G0_0_0_9_6 - 0.0167654220779227*G0_0_0_9_7 + 0.0187378246753254*G0_0_0_9_8 - 0.0788961038961064*G0_0_0_9_9 - 0.0153348214285719*G0_0_1_0_0 + 0.00766741071428602*G0_0_1_0_1 + 0.0113504464285719*G0_0_1_0_3 - 0.00475750811688329*G0_0_1_0_4 - 0.0120535714285718*G0_0_1_0_5 + 0.0030955762987014*G0_0_1_0_6 - 0.0124918831168836*G0_0_1_0_7 + 0.0187652191558449*G0_0_1_0_8 + 0.0037256493506495*G0_0_1_0_9 + 0.00766741071428602*G0_0_1_1_0 + 0.124736201298706*G0_0_1_1_1 + 0.00778612012987039*G0_0_1_1_2 + 0.0785765016233793*G0_0_1_1_3 - 0.0360146103896116*G0_0_1_1_4 - 0.00223721590909099*G0_0_1_1_5 - 0.00122362012987017*G0_0_1_1_6 - 0.0375669642857157*G0_0_1_1_7 + 0.0830509334415616*G0_0_1_1_8 + 0.0149573863636369*G0_0_1_1_9 + 0.00778612012987039*G0_0_1_2_1 - 0.00584415584415606*G0_0_1_2_2 + 0.0157061688311694*G0_0_1_2_3 - 0.00875710227272758*G0_0_1_2_4 - 0.00151582792207796*G0_0_1_2_5 - 0.00384435876623391*G0_0_1_2_6 - 0.00519581980519499*G0_0_1_2_7 + 0.0119257305194809*G0_0_1_2_8 + 0.004437905844156*G0_0_1_2_9 + 0.0113504464285719*G0_0_1_3_0 + 0.0785765016233793*G0_0_1_3_1 + 0.0157061688311694*G0_0_1_3_2 + 0.16798295454546*G0_0_1_3_3 - 0.0652536525974048*G0_0_1_3_4 - 0.00788961038961066*G0_0_1_3_5 - 0.00788961038961067*G0_0_1_3_6 - 0.0456118100649368*G0_0_1_3_7 + 0.0929494724026008*G0_0_1_3_8 + 0.0463514610389628*G0_0_1_3_9 - 0.00475750811688329*G0_0_1_4_0 - 0.0360146103896116*G0_0_1_4_1 - 0.00875710227272758*G0_0_1_4_2 - 0.0652536525974048*G0_0_1_4_3 + 0.0407629870129884*G0_0_1_4_4 + 0.00271205357142866*G0_0_1_4_5 + 0.00517755681818199*G0_0_1_4_6 + 0.020710227272728*G0_0_1_4_7 - 0.047337662337664*G0_0_1_4_8 - 0.0187378246753254*G0_0_1_4_9 - 0.0120535714285718*G0_0_1_5_0 - 0.00223721590909099*G0_0_1_5_1 - 0.00151582792207796*G0_0_1_5_2 - 0.00788961038961066*G0_0_1_5_3 + 0.00271205357142866*G0_0_1_5_4 - 0.00131493506493511*G0_0_1_5_5 + 0.0127384334415589*G0_0_1_5_6 + 0.000821834415584453*G0_0_1_5_7 - 0.00484882305194822*G0_0_1_5_8 - 0.00147930194805203*G0_0_1_5_9 + 0.0030955762987014*G0_0_1_6_0 - 0.00122362012987017*G0_0_1_6_1 - 0.00384435876623391*G0_0_1_6_2 - 0.00788961038961067*G0_0_1_6_3 + 0.00517755681818199*G0_0_1_6_4 + 0.0127384334415589*G0_0_1_6_5 + 0.0228469967532475*G0_0_1_6_6 + 0.00402698863636378*G0_0_1_6_7 - 0.0102729301948055*G0_0_1_6_8 + 0.00246550324675332*G0_0_1_6_9 - 0.0124918831168836*G0_0_1_7_0 - 0.0375669642857157*G0_0_1_7_1 - 0.00519581980519499*G0_0_1_7_2 - 0.0456118100649368*G0_0_1_7_3 + 0.020710227272728*G0_0_1_7_4 + 0.000821834415584453*G0_0_1_7_5 + 0.00402698863636378*G0_0_1_7_6 + 0.0420779220779236*G0_0_1_7_7 - 0.0710886769480546*G0_0_1_7_8 - 0.019230925324676*G0_0_1_7_9 + 0.0187652191558449*G0_0_1_8_0 + 0.0830509334415616*G0_0_1_8_1 + 0.0119257305194809*G0_0_1_8_2 + 0.0929494724026008*G0_0_1_8_3 - 0.047337662337664*G0_0_1_8_4 - 0.00484882305194822*G0_0_1_8_5 - 0.0102729301948055*G0_0_1_8_6 - 0.0710886769480546*G0_0_1_8_7 + 0.193459821428578*G0_0_1_8_8 + 0.0498031655844174*G0_0_1_8_9 + 0.0037256493506495*G0_0_1_9_0 + 0.0149573863636369*G0_0_1_9_1 + 0.004437905844156*G0_0_1_9_2 + 0.0463514610389628*G0_0_1_9_3 - 0.0187378246753254*G0_0_1_9_4 - 0.00147930194805203*G0_0_1_9_5 + 0.00246550324675332*G0_0_1_9_6 - 0.019230925324676*G0_0_1_9_7 + 0.0498031655844174*G0_0_1_9_8 - 0.00394480519480522*G0_0_1_9_9;
    A[30] = A[4] - 0.000161323051948059*G0_0_0_0_1 + 0.00117491883116888*G0_0_0_0_2 - 0.00210937500000008*G0_0_0_0_3 + 0.00109577922077927*G0_0_0_0_4 + 0.000684862012987039*G0_0_0_0_5 - 0.000684862012987041*G0_0_0_0_7 + 0.000219155844155851*G0_0_0_0_8 - 0.000164366883116889*G0_0_0_0_9 - 0.000161323051948059*G0_0_0_1_0 - 0.0034943181818183*G0_0_0_1_1 + 0.0010988230519481*G0_0_0_1_2 - 0.00608157467532489*G0_0_0_1_3 + 0.00599939123376645*G0_0_0_1_4 - 0.000301339285714298*G0_0_0_1_5 - 0.000465706168831181*G0_0_0_1_6 + 0.000356128246753262*G0_0_0_1_7 - 0.00202719155844164*G0_0_0_1_8 - 0.002958603896104*G0_0_0_1_9 + 0.00117491883116888*G0_0_0_2_0 + 0.0010988230519481*G0_0_0_2_1 + 0.0269379058441568*G0_0_0_2_2 - 0.00871144480519512*G0_0_0_2_3 + 0.0201349431818189*G0_0_0_2_4 - 0.0047666396103898*G0_0_0_2_5 + 0.0102729301948056*G0_0_0_2_6 - 0.000712256493506518*G0_0_0_2_7 + 0.000356128246753254*G0_0_0_2_8 + 0.004437905844156*G0_0_0_2_9 - 0.00210937500000008*G0_0_0_3_0 - 0.00608157467532489*G0_0_0_3_1 - 0.00871144480519512*G0_0_0_3_2 - 0.0502962662337679*G0_0_0_3_3 - 0.0120809659090914*G0_0_0_3_4 + 0.00394480519480533*G0_0_0_3_5 + 0.000739650974025973*G0_0_0_3_6 + 0.00567065746753267*G0_0_0_3_7 - 0.00394480519480536*G0_0_0_3_8 - 0.00246550324675336*G0_0_0_3_9 + 0.00109577922077927*G0_0_0_4_0 + 0.00599939123376645*G0_0_0_4_1 + 0.0201349431818189*G0_0_0_4_2 - 0.0120809659090914*G0_0_0_4_3 + 0.0261343344155854*G0_0_0_4_4 - 0.00394480519480536*G0_0_0_4_5 + 0.00320515422077939*G0_0_0_4_6 - 0.000246550324675344*G0_0_0_4_7 - 0.00172585227272732*G0_0_0_4_8 - 0.00542410714285729*G0_0_0_4_9 + 0.000684862012987039*G0_0_0_5_0 - 0.000301339285714298*G0_0_0_5_1 - 0.0047666396103898*G0_0_0_5_2 + 0.00394480519480533*G0_0_0_5_3 - 0.00394480519480536*G0_0_0_5_4 + 0.010355113636364*G0_0_0_5_5 - 0.00147930194805204*G0_0_0_5_6 - 0.00172585227272733*G0_0_0_5_7 + 0.000246550324675329*G0_0_0_5_8 - 0.000465706168831182*G0_0_0_6_1 + 0.0102729301948056*G0_0_0_6_2 + 0.000739650974025973*G0_0_0_6_3 + 0.00320515422077939*G0_0_0_6_4 - 0.00147930194805204*G0_0_0_6_5 - 0.0325446428571439*G0_0_0_6_6 + 0.00147930194805199*G0_0_0_6_7 + 0.000493100649350667*G0_0_0_6_8 - 0.01479301948052*G0_0_0_6_9 - 0.000684862012987041*G0_0_0_7_0 + 0.000356128246753262*G0_0_0_7_1 - 0.000712256493506518*G0_0_0_7_2 + 0.00567065746753267*G0_0_0_7_3 - 0.000246550324675344*G0_0_0_7_4 - 0.00172585227272733*G0_0_0_7_5 + 0.00147930194805199*G0_0_0_7_6 - 0.00690340909090938*G0_0_0_7_7 + 0.00221895292207802*G0_0_0_7_8 - 0.00246550324675333*G0_0_0_7_9 + 0.000219155844155851*G0_0_0_8_0 - 0.00202719155844164*G0_0_0_8_1 + 0.000356128246753254*G0_0_0_8_2 - 0.00394480519480536*G0_0_0_8_3 - 0.00172585227272732*G0_0_0_8_4 + 0.00024655032467533*G0_0_0_8_5 + 0.000493100649350667*G0_0_0_8_6 + 0.00221895292207802*G0_0_0_8_7 + 0.00690340909090931*G0_0_0_8_8 + 0.0123275162337666*G0_0_0_8_9 - 0.000164366883116888*G0_0_0_9_0 - 0.002958603896104*G0_0_0_9_1 + 0.004437905844156*G0_0_0_9_2 - 0.00246550324675336*G0_0_0_9_3 - 0.00542410714285729*G0_0_0_9_4 - 0.01479301948052*G0_0_0_9_6 - 0.00246550324675333*G0_0_0_9_7 + 0.0123275162337666*G0_0_0_9_8 + 0.0295860389610399*G0_0_0_9_9 - 0.000608766233766261*G0_0_1_0_1 + 0.000608766233766258*G0_0_1_0_2 - 0.00109577922077926*G0_0_1_0_3 + 0.00109577922077927*G0_0_1_0_4 + 0.002922077922078*G0_0_1_0_5 - 0.000913149350649374*G0_0_1_0_6 - 0.00292207792207805*G0_0_1_0_7 + 0.000913149350649392*G0_0_1_0_8 - 0.000608766233766261*G0_0_1_1_0 - 0.0104707792207796*G0_0_1_1_1 - 0.0090036525974029*G0_0_1_1_3 + 0.00504971590909108*G0_0_1_1_4 + 0.000493100649350662*G0_0_1_1_5 - 0.000630073051948071*G0_0_1_1_6 + 0.0010318587662338*G0_0_1_1_7 - 0.00428267045454562*G0_0_1_1_8 - 0.00334212662337674*G0_0_1_1_9 + 0.000608766233766258*G0_0_1_2_0 + 0.0104707792207796*G0_0_1_2_2 - 0.00504971590909109*G0_0_1_2_3 + 0.00900365259740293*G0_0_1_2_4 - 0.00103185876623382*G0_0_1_2_5 + 0.00428267045454563*G0_0_1_2_6 - 0.000493100649350669*G0_0_1_2_7 + 0.00063007305194807*G0_0_1_2_8 + 0.00334212662337674*G0_0_1_2_9 - 0.00109577922077926*G0_0_1_3_0 - 0.0090036525974029*G0_0_1_3_1 - 0.00504971590909109*G0_0_1_3_2 - 0.0261343344155853*G0_0_1_3_3 + 0.000904017857142896*G0_0_1_3_5 + 0.00189021915584421*G0_0_1_3_6 + 0.0032873376623378*G0_0_1_3_7 - 0.00139711850649359*G0_0_1_3_8 + 0.00345170454545463*G0_0_1_3_9 + 0.00109577922077927*G0_0_1_4_0 + 0.00504971590909108*G0_0_1_4_1 + 0.00900365259740293*G0_0_1_4_2 + 0.0261343344155854*G0_0_1_4_4 - 0.00328733766233779*G0_0_1_4_5 + 0.00139711850649358*G0_0_1_4_6 - 0.000904017857142892*G0_0_1_4_7 - 0.00189021915584421*G0_0_1_4_8 - 0.00345170454545464*G0_0_1_4_9 + 0.002922077922078*G0_0_1_5_0 + 0.000493100649350662*G0_0_1_5_1 - 0.00103185876623382*G0_0_1_5_2 + 0.000904017857142896*G0_0_1_5_3 - 0.00328733766233779*G0_0_1_5_4 + 0.0213676948051955*G0_0_1_5_5 - 0.00476663961038977*G0_0_1_5_6 - 0.00147930194805199*G0_0_1_5_8 + 0.00295860389610399*G0_0_1_5_9 - 0.000913149350649374*G0_0_1_6_0 - 0.000630073051948071*G0_0_1_6_1 + 0.00428267045454563*G0_0_1_6_2 + 0.00189021915584421*G0_0_1_6_3 + 0.00139711850649358*G0_0_1_6_4 - 0.00476663961038977*G0_0_1_6_5 - 0.0190665584415591*G0_0_1_6_6 + 0.00147930194805201*G0_0_1_6_7 - 0.0138068181818186*G0_0_1_6_9 - 0.00292207792207805*G0_0_1_7_0 + 0.0010318587662338*G0_0_1_7_1 - 0.000493100649350669*G0_0_1_7_2 + 0.0032873376623378*G0_0_1_7_3 - 0.000904017857142893*G0_0_1_7_4 + 0.00147930194805201*G0_0_1_7_6 - 0.0213676948051957*G0_0_1_7_7 + 0.00476663961038983*G0_0_1_7_8 - 0.00295860389610402*G0_0_1_7_9 + 0.000913149350649392*G0_0_1_8_0 - 0.00428267045454562*G0_0_1_8_1 + 0.00063007305194807*G0_0_1_8_2 - 0.00139711850649359*G0_0_1_8_3 - 0.00189021915584421*G0_0_1_8_4 - 0.00147930194805199*G0_0_1_8_5 + 0.00476663961038983*G0_0_1_8_7 + 0.0190665584415591*G0_0_1_8_8 + 0.0138068181818186*G0_0_1_8_9 - 0.00334212662337674*G0_0_1_9_1 + 0.00334212662337674*G0_0_1_9_2 + 0.00345170454545463*G0_0_1_9_3 - 0.00345170454545464*G0_0_1_9_4 + 0.00295860389610399*G0_0_1_9_5 - 0.0138068181818186*G0_0_1_9_6 - 0.00295860389610402*G0_0_1_9_7 + 0.0138068181818186*G0_0_1_9_8 - 0.000727475649350686*G0_1_0_0_1 + 0.000727475649350678*G0_1_0_0_2 - 0.00210937500000008*G0_1_0_0_3 + 0.00210937500000009*G0_1_0_0_4 - 0.00155235389610399*G0_1_0_0_5 + 0.000639204545454591*G0_1_0_0_6 + 0.00155235389610389*G0_1_0_0_7 - 0.000639204545454548*G0_1_0_0_8 - 0.000727475649350686*G0_1_0_1_0 - 0.0199614448051955*G0_1_0_1_1 - 0.0172128652597409*G0_1_0_1_3 + 0.00966112012987047*G0_1_0_1_4 - 0.000191761363636363*G0_1_0_1_6 + 0.00409090909090924*G0_1_0_1_7 - 0.00801745129870161*G0_1_0_1_8 - 0.00405438311688327*G0_1_0_1_9 + 0.000727475649350678*G0_1_0_2_0 + 0.0199614448051955*G0_1_0_2_2 - 0.00966112012987047*G0_1_0_2_3 + 0.0172128652597409*G0_1_0_2_4 - 0.00409090909090926*G0_1_0_2_5 + 0.00801745129870162*G0_1_0_2_6 + 0.000191761363636366*G0_1_0_2_8 + 0.00405438311688325*G0_1_0_2_9 - 0.00210937500000008*G0_1_0_3_0 - 0.0172128652597409*G0_1_0_3_1 - 0.00966112012987047*G0_1_0_3_2 - 0.050296266233768*G0_1_0_3_3 + 0.00328733766233778*G0_1_0_3_5 + 0.000575284090909091*G0_1_0_3_6 + 0.00632812500000025*G0_1_0_3_7 - 0.00575284090909117*G0_1_0_3_8 - 0.000493100649350716*G0_1_0_3_9 + 0.00210937500000009*G0_1_0_4_0 + 0.00966112012987047*G0_1_0_4_1 + 0.0172128652597409*G0_1_0_4_2 + 0.0502962662337681*G0_1_0_4_4 - 0.00632812500000024*G0_1_0_4_5 + 0.00575284090909116*G0_1_0_4_6 - 0.00328733766233779*G0_1_0_4_7 - 0.000575284090909087*G0_1_0_4_8 + 0.000493100649350725*G0_1_0_4_9 - 0.00155235389610399*G0_1_0_5_0 - 0.00409090909090926*G0_1_0_5_2 + 0.00328733766233778*G0_1_0_5_3 - 0.00632812500000025*G0_1_0_5_4 - 0.00410917207792224*G0_1_0_5_5 + 0.00106838474025977*G0_1_0_5_6 + 0.000246550324675356*G0_1_0_5_8 - 0.000493100649350691*G0_1_0_5_9 + 0.00063920454545459*G0_1_0_6_0 - 0.000191761363636363*G0_1_0_6_1 + 0.00801745129870162*G0_1_0_6_2 + 0.000575284090909092*G0_1_0_6_3 + 0.00575284090909116*G0_1_0_6_4 + 0.00106838474025977*G0_1_0_6_5 - 0.0203814935064942*G0_1_0_6_6 - 0.000246550324675313*G0_1_0_6_7 - 0.013313717532468*G0_1_0_6_9 + 0.00155235389610389*G0_1_0_7_0 + 0.00409090909090924*G0_1_0_7_1 + 0.00632812500000025*G0_1_0_7_3 - 0.00328733766233779*G0_1_0_7_4 - 0.000246550324675313*G0_1_0_7_6 + 0.00410917207792205*G0_1_0_7_7 - 0.00106838474025969*G0_1_0_7_8 + 0.000493100649350646*G0_1_0_7_9 - 0.000639204545454548*G0_1_0_8_0 - 0.00801745129870161*G0_1_0_8_1 + 0.000191761363636366*G0_1_0_8_2 - 0.00575284090909116*G0_1_0_8_3 - 0.000575284090909087*G0_1_0_8_4 + 0.000246550324675356*G0_1_0_8_5 - 0.00106838474025969*G0_1_0_8_7 + 0.0203814935064941*G0_1_0_8_8 + 0.013313717532468*G0_1_0_8_9 - 0.00405438311688327*G0_1_0_9_1 + 0.00405438311688325*G0_1_0_9_2 - 0.000493100649350717*G0_1_0_9_3 + 0.000493100649350725*G0_1_0_9_4 - 0.000493100649350691*G0_1_0_9_5 - 0.013313717532468*G0_1_0_9_6 + 0.000493100649350646*G0_1_0_9_7 + 0.013313717532468*G0_1_0_9_8 - 0.00117491883116889*G0_1_1_0_1 + 0.000161323051948052*G0_1_1_0_2 - 0.00109577922077926*G0_1_1_0_3 + 0.00210937500000009*G0_1_1_0_4 + 0.000684862012986973*G0_1_1_0_5 - 0.000219155844155821*G0_1_1_0_6 - 0.000684862012987116*G0_1_1_0_7 + 0.000164366883116875*G0_1_1_0_9 - 0.00117491883116889*G0_1_1_1_0 - 0.0269379058441567*G0_1_1_1_1 - 0.00109882305194809*G0_1_1_1_2 - 0.0201349431818188*G0_1_1_1_3 + 0.0087114448051951*G0_1_1_1_4 + 0.000712256493506508*G0_1_1_1_5 - 0.000356128246753252*G0_1_1_1_6 + 0.00476663961038978*G0_1_1_1_7 - 0.0102729301948056*G0_1_1_1_8 - 0.00443790584415601*G0_1_1_1_9 + 0.000161323051948052*G0_1_1_2_0 - 0.00109882305194809*G0_1_1_2_1 + 0.00349431818181831*G0_1_1_2_2 - 0.00599939123376644*G0_1_1_2_3 + 0.0060815746753249*G0_1_1_2_4 - 0.000356128246753273*G0_1_1_2_5 + 0.00202719155844164*G0_1_1_2_6 + 0.000301339285714288*G0_1_1_2_7 + 0.000465706168831181*G0_1_1_2_8 + 0.00295860389610399*G0_1_1_2_9 - 0.00109577922077926*G0_1_1_3_0 - 0.0201349431818188*G0_1_1_3_1 - 0.00599939123376644*G0_1_1_3_2 - 0.0261343344155853*G0_1_1_3_3 + 0.0120809659090913*G0_1_1_3_4 + 0.000246550324675343*G0_1_1_3_5 + 0.00172585227272732*G0_1_1_3_6 + 0.00394480519480537*G0_1_1_3_7 - 0.0032051542207794*G0_1_1_3_8 + 0.00542410714285728*G0_1_1_3_9 + 0.00210937500000009*G0_1_1_4_0 + 0.0087114448051951*G0_1_1_4_1 + 0.0060815746753249*G0_1_1_4_2 + 0.0120809659090913*G0_1_1_4_3 + 0.0502962662337681*G0_1_1_4_4 - 0.00567065746753268*G0_1_1_4_5 + 0.00394480519480536*G0_1_1_4_6 - 0.00394480519480534*G0_1_1_4_7 - 0.000739650974025973*G0_1_1_4_8 + 0.0024655032467534*G0_1_1_4_9 + 0.000684862012986973*G0_1_1_5_0 + 0.000712256493506509*G0_1_1_5_1 - 0.000356128246753273*G0_1_1_5_2 + 0.000246550324675343*G0_1_1_5_3 - 0.00567065746753268*G0_1_1_5_4 + 0.00690340909090923*G0_1_1_5_5 - 0.00221895292207796*G0_1_1_5_6 + 0.00172585227272725*G0_1_1_5_7 - 0.00147930194805196*G0_1_1_5_8 + 0.0024655032467533*G0_1_1_5_9 - 0.00021915584415582*G0_1_1_6_0 - 0.000356128246753252*G0_1_1_6_1 + 0.00202719155844164*G0_1_1_6_2 + 0.00172585227272732*G0_1_1_6_3 + 0.00394480519480536*G0_1_1_6_4 - 0.00221895292207796*G0_1_1_6_5 - 0.00690340909090932*G0_1_1_6_6 - 0.000246550324675297*G0_1_1_6_7 - 0.000493100649350677*G0_1_1_6_8 - 0.0123275162337666*G0_1_1_6_9 - 0.000684862012987116*G0_1_1_7_0 + 0.00476663961038978*G0_1_1_7_1 + 0.000301339285714288*G0_1_1_7_2 + 0.00394480519480536*G0_1_1_7_3 - 0.00394480519480534*G0_1_1_7_4 + 0.00172585227272725*G0_1_1_7_5 - 0.000246550324675297*G0_1_1_7_6 - 0.0103551136363642*G0_1_1_7_7 + 0.00147930194805213*G0_1_1_7_8 - 0.0102729301948056*G0_1_1_8_1 + 0.000465706168831181*G0_1_1_8_2 - 0.0032051542207794*G0_1_1_8_3 - 0.000739650974025973*G0_1_1_8_4 - 0.00147930194805196*G0_1_1_8_5 - 0.000493100649350677*G0_1_1_8_6 + 0.00147930194805213*G0_1_1_8_7 + 0.0325446428571438*G0_1_1_8_8 + 0.01479301948052*G0_1_1_8_9 + 0.000164366883116875*G0_1_1_9_0 - 0.00443790584415601*G0_1_1_9_1 + 0.00295860389610399*G0_1_1_9_2 + 0.00542410714285729*G0_1_1_9_3 + 0.00246550324675339*G0_1_1_9_4 + 0.0024655032467533*G0_1_1_9_5 - 0.0123275162337666*G0_1_1_9_6 + 0.01479301948052*G0_1_1_9_8 - 0.0295860389610399*G0_1_1_9_9;
    A[28] = -A[27] + 0.00949066558441591*G0_1_0_0_0 + 0.000118709415584416*G0_1_0_0_2 - 0.000438311688311704*G0_1_0_0_3 + 0.000575284090909111*G0_1_0_0_4 + 0.00373478084415597*G0_1_0_0_5 - 0.00305905032467544*G0_1_0_0_6 + 0.00820921266233795*G0_1_0_0_7 - 0.00461140422077938*G0_1_0_0_8 + 0.000712256493506521*G0_1_0_0_9 - 0.0094906655844159*G0_1_0_1_1 - 0.000118709415584421*G0_1_0_1_2 - 0.00373478084415596*G0_1_0_1_3 + 0.00305905032467542*G0_1_0_1_4 + 0.000438311688311705*G0_1_0_1_5 - 0.000575284090909117*G0_1_0_1_6 + 0.00461140422077938*G0_1_0_1_7 - 0.00820921266233796*G0_1_0_1_8 - 0.000712256493506521*G0_1_0_1_9 + 0.000118709415584416*G0_1_0_2_0 - 0.000118709415584422*G0_1_0_2_1 - 0.00155235389610394*G0_1_0_2_3 + 0.00447443181818195*G0_1_0_2_4 + 0.00155235389610396*G0_1_0_2_5 - 0.004474431818182*G0_1_0_2_6 + 0.00101359577922081*G0_1_0_2_7 - 0.00101359577922081*G0_1_0_2_8 - 0.000438311688311704*G0_1_0_3_0 - 0.00373478084415596*G0_1_0_3_1 - 0.00155235389610394*G0_1_0_3_2 + 0.00131493506493512*G0_1_0_3_3 - 0.00583502435064954*G0_1_0_3_4 + 0.00172585227272734*G0_1_0_3_6 + 0.0013149350649351*G0_1_0_3_7 - 0.00435572240259754*G0_1_0_3_8 - 0.000493100649350652*G0_1_0_3_9 + 0.000575284090909111*G0_1_0_4_0 + 0.00305905032467542*G0_1_0_4_1 + 0.00447443181818195*G0_1_0_4_2 - 0.00583502435064954*G0_1_0_4_3 + 0.0254768668831177*G0_1_0_4_4 - 0.00172585227272732*G0_1_0_4_5 - 0.00238331980519489*G0_1_0_4_7 + 0.00304078733766244*G0_1_0_4_8 + 0.00345170454545465*G0_1_0_4_9 + 0.00373478084415597*G0_1_0_5_0 + 0.000438311688311704*G0_1_0_5_1 + 0.00155235389610396*G0_1_0_5_2 - 0.00172585227272732*G0_1_0_5_4 - 0.00131493506493513*G0_1_0_5_5 + 0.00583502435064958*G0_1_0_5_6 + 0.00435572240259754*G0_1_0_5_7 - 0.00131493506493511*G0_1_0_5_8 + 0.000493100649350667*G0_1_0_5_9 - 0.00305905032467544*G0_1_0_6_0 - 0.000575284090909117*G0_1_0_6_1 - 0.004474431818182*G0_1_0_6_2 + 0.00172585227272734*G0_1_0_6_3 + 0.00583502435064958*G0_1_0_6_5 - 0.0254768668831178*G0_1_0_6_6 - 0.00304078733766244*G0_1_0_6_7 + 0.00238331980519488*G0_1_0_6_8 - 0.00345170454545468*G0_1_0_6_9 + 0.00820921266233794*G0_1_0_7_0 + 0.00461140422077938*G0_1_0_7_1 + 0.00101359577922081*G0_1_0_7_2 + 0.0013149350649351*G0_1_0_7_3 - 0.00238331980519489*G0_1_0_7_4 + 0.00435572240259754*G0_1_0_7_5 - 0.00304078733766244*G0_1_0_7_6 + 0.0241619318181826*G0_1_0_7_7 + 0.00394480519480533*G0_1_0_7_9 - 0.00461140422077938*G0_1_0_8_0 - 0.00820921266233796*G0_1_0_8_1 - 0.00101359577922081*G0_1_0_8_2 - 0.00435572240259754*G0_1_0_8_3 + 0.00304078733766244*G0_1_0_8_4 - 0.00131493506493511*G0_1_0_8_5 + 0.00238331980519488*G0_1_0_8_6 - 0.0241619318181826*G0_1_0_8_8 - 0.00394480519480532*G0_1_0_8_9 + 0.000712256493506521*G0_1_0_9_0 - 0.000712256493506521*G0_1_0_9_1 - 0.000493100649350653*G0_1_0_9_3 + 0.00345170454545465*G0_1_0_9_4 + 0.000493100649350668*G0_1_0_9_5 - 0.00345170454545468*G0_1_0_9_6 + 0.00394480519480533*G0_1_0_9_7 - 0.00394480519480532*G0_1_0_9_8 - 0.00265422077922088*G0_1_1_0_0 - 0.00165280032467539*G0_1_1_0_1 + 0.000258725649350659*G0_1_1_0_2 - 0.000210024350649359*G0_1_1_0_3 + 0.00170758928571435*G0_1_1_0_4 - 0.00215503246753254*G0_1_1_0_5 + 0.0014884334415585*G0_1_1_0_6 - 0.00261160714285724*G0_1_1_0_7 + 0.00092228084415587*G0_1_1_0_8 + 0.00021915584415585*G0_1_1_0_9 - 0.00165280032467539*G0_1_1_1_0 - 0.0121448863636368*G0_1_1_1_1 + 0.00014001623376624*G0_1_1_1_2 - 0.00588981331168851*G0_1_1_1_3 + 0.00454748376623392*G0_1_1_1_4 + 0.000228287337662344*G0_1_1_1_5 + 0.00113230519480524*G0_1_1_1_6 + 0.00553368506493526*G0_1_1_1_7 - 0.0108208198051952*G0_1_1_1_8 - 0.000493100649350667*G0_1_1_1_9 + 0.000258725649350659*G0_1_1_2_0 + 0.00014001623376624*G0_1_1_2_1 + 0.00547889610389628*G0_1_1_2_2 - 0.00348823051948063*G0_1_1_2_3 + 0.0082640016233769*G0_1_1_2_4 - 0.00193587662337669*G0_1_1_2_5 + 0.00378956980519493*G0_1_1_2_6 - 0.00157974837662343*G0_1_1_2_7 - 0.00259334415584424*G0_1_1_2_8 + 0.0010409902597403*G0_1_1_2_9 - 0.000210024350649359*G0_1_1_3_0 - 0.00588981331168851*G0_1_1_3_1 - 0.00348823051948063*G0_1_1_3_2 + 0.00788961038961068*G0_1_1_3_3 - 0.00936891233766267*G0_1_1_3_4 + 0.000164366883116892*G0_1_1_3_5 - 0.00378043831168845*G0_1_1_3_6 + 0.000246550324675344*G0_1_1_3_7 - 0.0076430600649353*G0_1_1_3_8 + 0.00098620129870135*G0_1_1_3_9 + 0.00170758928571435*G0_1_1_4_0 + 0.00454748376623392*G0_1_1_4_1 + 0.0082640016233769*G0_1_1_4_2 - 0.00936891233766267*G0_1_1_4_3 + 0.0330377435064947*G0_1_1_4_4 - 0.00550629058441578*G0_1_1_4_5 + 0.00928672889610422*G0_1_1_4_6 + 0.00739650974025997*G0_1_1_4_8 + 0.00788961038961065*G0_1_1_4_9 - 0.00215503246753254*G0_1_1_5_0 + 0.000228287337662344*G0_1_1_5_1 - 0.00193587662337669*G0_1_1_5_2 + 0.000164366883116892*G0_1_1_5_3 - 0.00550629058441578*G0_1_1_5_4 + 0.00657467532467554*G0_1_1_5_5 - 0.00353388798701311*G0_1_1_5_6 - 0.00328733766233777*G0_1_1_5_7 - 0.00106838474025977*G0_1_1_5_8 + 0.001479301948052*G0_1_1_5_9 + 0.0014884334415585*G0_1_1_6_0 + 0.00113230519480524*G0_1_1_6_1 + 0.00378956980519493*G0_1_1_6_2 - 0.00378043831168845*G0_1_1_6_3 + 0.00928672889610422*G0_1_1_6_4 - 0.00353388798701311*G0_1_1_6_5 + 0.00756087662337689*G0_1_1_6_6 + 0.00435572240259755*G0_1_1_6_7 + 0.00238331980519487*G0_1_1_6_8 + 0.00443790584415599*G0_1_1_6_9 - 0.00261160714285724*G0_1_1_7_0 + 0.00553368506493526*G0_1_1_7_1 - 0.00157974837662343*G0_1_1_7_2 + 0.000246550324675344*G0_1_1_7_3 - 0.00328733766233777*G0_1_1_7_5 + 0.00435572240259755*G0_1_1_7_6 - 0.0571996753246773*G0_1_1_7_7 + 0.00665685876623402*G0_1_1_7_8 - 0.00936891233766266*G0_1_1_7_9 + 0.00092228084415587*G0_1_1_8_0 - 0.0108208198051952*G0_1_1_8_1 - 0.00259334415584424*G0_1_1_8_2 - 0.0076430600649353*G0_1_1_8_3 + 0.00739650974025997*G0_1_1_8_4 - 0.00106838474025977*G0_1_1_8_5 + 0.00238331980519487*G0_1_1_8_6 + 0.00665685876623402*G0_1_1_8_7 - 0.0813616071428599*G0_1_1_8_8 - 0.013313717532468*G0_1_1_8_9 + 0.00021915584415585*G0_1_1_9_0 - 0.000493100649350667*G0_1_1_9_1 + 0.0010409902597403*G0_1_1_9_2 + 0.000986201298701352*G0_1_1_9_3 + 0.00788961038961065*G0_1_1_9_4 + 0.001479301948052*G0_1_1_9_5 + 0.00443790584415599*G0_1_1_9_6 - 0.00936891233766266*G0_1_1_9_7 - 0.013313717532468*G0_1_1_9_8 + 0.0493100649350667*G0_1_1_9_9;
    A[80] = -A[30] + 0.0525974025974044*G0_0_0_0_0 + 0.00307426948051959*G0_0_0_0_1 + 0.00393567370129884*G0_0_0_0_2 - 0.000858360389610423*G0_0_0_0_3 - 0.00170758928571435*G0_0_0_0_4 + 0.0389458198051961*G0_0_0_0_5 - 0.0165827922077928*G0_0_0_0_6 + 0.0196783685064942*G0_0_0_0_7 - 0.0100994318181822*G0_0_0_0_8 + 0.0047666396103898*G0_0_0_0_9 + 0.00307426948051959*G0_0_0_1_0 + 0.0154017857142862*G0_0_0_1_1 + 0.00106534090909095*G0_0_0_1_2 + 0.00904017857142887*G0_0_0_1_3 - 0.00249289772727281*G0_0_0_1_4 + 0.00346996753246765*G0_0_0_1_5 - 0.00146103896103901*G0_0_0_1_6 - 0.00167106331168838*G0_0_0_1_7 + 0.00246550324675336*G0_0_0_1_8 - 0.000767045454545472*G0_0_0_1_9 + 0.00393567370129884*G0_0_0_2_0 + 0.00106534090909095*G0_0_0_2_1 + 0.00787134740259769*G0_0_0_2_2 + 0.00124188311688315*G0_0_0_2_3 + 0.00241984577922088*G0_0_0_2_4 + 0.00544237012987031*G0_0_0_2_5 - 0.000173498376623357*G0_0_0_2_6 + 0.000757913961038986*G0_0_0_2_7 + 0.00111404220779224*G0_0_0_2_8 + 0.00378043831168844*G0_0_0_2_9 - 0.000858360389610423*G0_0_0_3_0 + 0.00904017857142887*G0_0_0_3_1 + 0.00124188311688315*G0_0_0_3_2 - 0.00361607142857159*G0_0_0_3_3 - 0.0134780844155849*G0_0_0_3_4 - 0.00197240259740266*G0_0_0_3_5 + 0.000493100649350657*G0_0_0_3_6 - 0.00131493506493511*G0_0_0_3_7 + 0.00854707792207822*G0_0_0_3_8 + 0.00493100649350666*G0_0_0_3_9 - 0.00170758928571435*G0_0_0_4_0 - 0.00249289772727281*G0_0_0_4_1 + 0.00241984577922088*G0_0_0_4_2 - 0.0134780844155849*G0_0_0_4_3 - 0.0238331980519489*G0_0_0_4_4 + 0.00123275162337665*G0_0_0_4_5 - 0.00172585227272732*G0_0_0_4_6 + 0.00336952110389622*G0_0_0_4_7 - 0.0072321428571431*G0_0_0_4_8 - 0.0138068181818187*G0_0_0_4_9 + 0.0389458198051961*G0_0_0_5_0 + 0.00346996753246765*G0_0_0_5_1 + 0.00544237012987031*G0_0_0_5_2 - 0.00197240259740266*G0_0_0_5_3 + 0.00123275162337665*G0_0_0_5_4 + 0.105687905844159*G0_0_0_5_5 - 0.0316406250000011*G0_0_0_5_6 + 0.0204636769480526*G0_0_0_5_7 - 0.0142999188311693*G0_0_0_5_8 + 0.0142999188311694*G0_0_0_5_9 - 0.0165827922077928*G0_0_0_6_0 - 0.00146103896103901*G0_0_0_6_1 - 0.000173498376623357*G0_0_0_6_2 + 0.000493100649350658*G0_0_0_6_3 - 0.00172585227272732*G0_0_0_6_4 - 0.0316406250000011*G0_0_0_6_5 - 0.00821834415584443*G0_0_0_6_6 - 0.00616375811688332*G0_0_0_6_7 + 0.00246550324675334*G0_0_0_6_8 - 0.0123275162337667*G0_0_0_6_9 + 0.0196783685064942*G0_0_0_7_0 - 0.00167106331168838*G0_0_0_7_1 + 0.000757913961038985*G0_0_0_7_2 - 0.00131493506493511*G0_0_0_7_3 + 0.00336952110389622*G0_0_0_7_4 + 0.0204636769480526*G0_0_0_7_5 - 0.00616375811688332*G0_0_0_7_6 - 0.0134780844155849*G0_0_0_7_7 - 0.00460227272727289*G0_0_0_7_8 - 0.00197240259740267*G0_0_0_7_9 - 0.0100994318181822*G0_0_0_8_0 + 0.00246550324675336*G0_0_0_8_1 + 0.00111404220779224*G0_0_0_8_2 + 0.00854707792207822*G0_0_0_8_3 - 0.0072321428571431*G0_0_0_8_4 - 0.0142999188311693*G0_0_0_8_5 + 0.00246550324675334*G0_0_0_8_6 - 0.00460227272727289*G0_0_0_8_7 + 0.0259699675324685*G0_0_0_8_8 + 0.0167654220779226*G0_0_0_8_9 + 0.0047666396103898*G0_0_0_9_0 - 0.000767045454545472*G0_0_0_9_1 + 0.00378043831168844*G0_0_0_9_2 + 0.00493100649350666*G0_0_0_9_3 - 0.0138068181818187*G0_0_0_9_4 + 0.0142999188311694*G0_0_0_9_5 - 0.0123275162337667*G0_0_0_9_6 - 0.00197240259740267*G0_0_0_9_7 + 0.0167654220779226*G0_0_0_9_8 + 0.0867857142857172*G0_0_0_9_9 + 0.0525974025974044*G0_0_1_0_0 + 0.00307426948051959*G0_0_1_0_1 + 0.00393567370129884*G0_0_1_0_2 - 0.000858360389610424*G0_0_1_0_3 - 0.00170758928571435*G0_0_1_0_4 + 0.0389458198051961*G0_0_1_0_5 - 0.0165827922077928*G0_0_1_0_6 + 0.0196783685064942*G0_0_1_0_7 - 0.0100994318181822*G0_0_1_0_8 + 0.0047666396103898*G0_0_1_0_9 + 0.00307426948051959*G0_0_1_1_0 + 0.0154017857142862*G0_0_1_1_1 + 0.00106534090909095*G0_0_1_1_2 + 0.00904017857142886*G0_0_1_1_3 - 0.00249289772727281*G0_0_1_1_4 + 0.00346996753246765*G0_0_1_1_5 - 0.00146103896103901*G0_0_1_1_6 - 0.00167106331168838*G0_0_1_1_7 + 0.00246550324675335*G0_0_1_1_8 - 0.000767045454545471*G0_0_1_1_9 + 0.00393567370129884*G0_0_1_2_0 + 0.00106534090909095*G0_0_1_2_1 + 0.00787134740259769*G0_0_1_2_2 + 0.00124188311688315*G0_0_1_2_3 + 0.00241984577922088*G0_0_1_2_4 + 0.00544237012987031*G0_0_1_2_5 - 0.000173498376623356*G0_0_1_2_6 + 0.000757913961038984*G0_0_1_2_7 + 0.00111404220779224*G0_0_1_2_8 + 0.00378043831168844*G0_0_1_2_9 - 0.000858360389610424*G0_0_1_3_0 + 0.00904017857142886*G0_0_1_3_1 + 0.00124188311688315*G0_0_1_3_2 - 0.00361607142857159*G0_0_1_3_3 - 0.0134780844155849*G0_0_1_3_4 - 0.00197240259740266*G0_0_1_3_5 + 0.00049310064935066*G0_0_1_3_6 - 0.00131493506493511*G0_0_1_3_7 + 0.00854707792207822*G0_0_1_3_8 + 0.00493100649350665*G0_0_1_3_9 - 0.00170758928571435*G0_0_1_4_0 - 0.0024928977272728*G0_0_1_4_1 + 0.00241984577922088*G0_0_1_4_2 - 0.0134780844155849*G0_0_1_4_3 - 0.0238331980519489*G0_0_1_4_4 + 0.00123275162337665*G0_0_1_4_5 - 0.00172585227272733*G0_0_1_4_6 + 0.00336952110389622*G0_0_1_4_7 - 0.0072321428571431*G0_0_1_4_8 - 0.0138068181818187*G0_0_1_4_9 + 0.0389458198051961*G0_0_1_5_0 + 0.00346996753246765*G0_0_1_5_1 + 0.00544237012987031*G0_0_1_5_2 - 0.00197240259740265*G0_0_1_5_3 + 0.00123275162337665*G0_0_1_5_4 + 0.105687905844159*G0_0_1_5_5 - 0.0316406250000011*G0_0_1_5_6 + 0.0204636769480526*G0_0_1_5_7 - 0.0142999188311693*G0_0_1_5_8 + 0.0142999188311694*G0_0_1_5_9 - 0.0165827922077928*G0_0_1_6_0 - 0.00146103896103901*G0_0_1_6_1 - 0.000173498376623356*G0_0_1_6_2 + 0.00049310064935066*G0_0_1_6_3 - 0.00172585227272733*G0_0_1_6_4 - 0.0316406250000011*G0_0_1_6_5 - 0.00821834415584444*G0_0_1_6_6 - 0.00616375811688332*G0_0_1_6_7 + 0.00246550324675334*G0_0_1_6_8 - 0.0123275162337667*G0_0_1_6_9 + 0.0196783685064942*G0_0_1_7_0 - 0.00167106331168838*G0_0_1_7_1 + 0.000757913961038983*G0_0_1_7_2 - 0.00131493506493511*G0_0_1_7_3 + 0.00336952110389622*G0_0_1_7_4 + 0.0204636769480526*G0_0_1_7_5 - 0.00616375811688332*G0_0_1_7_6 - 0.013478084415585*G0_0_1_7_7 - 0.00460227272727289*G0_0_1_7_8 - 0.00197240259740268*G0_0_1_7_9 - 0.0100994318181822*G0_0_1_8_0 + 0.00246550324675335*G0_0_1_8_1 + 0.00111404220779224*G0_0_1_8_2 + 0.00854707792207822*G0_0_1_8_3 - 0.0072321428571431*G0_0_1_8_4 - 0.0142999188311693*G0_0_1_8_5 + 0.00246550324675334*G0_0_1_8_6 - 0.00460227272727289*G0_0_1_8_7 + 0.0259699675324684*G0_0_1_8_8 + 0.0167654220779226*G0_0_1_8_9 + 0.0047666396103898*G0_0_1_9_0 - 0.000767045454545471*G0_0_1_9_1 + 0.00378043831168844*G0_0_1_9_2 + 0.00493100649350666*G0_0_1_9_3 - 0.0138068181818187*G0_0_1_9_4 + 0.0142999188311694*G0_0_1_9_5 - 0.0123275162337667*G0_0_1_9_6 - 0.00197240259740268*G0_0_1_9_7 + 0.0167654220779226*G0_0_1_9_8 + 0.0867857142857172*G0_0_1_9_9;
    A[14] = -A[16] - 0.00787134740259768*G0_0_1_0_0 - 0.00393567370129885*G0_0_1_0_1 - 0.00106534090909095*G0_0_1_0_2 - 0.000757913961038983*G0_0_1_0_3 - 0.00111404220779225*G0_0_1_0_4 - 0.00241984577922085*G0_0_1_0_5 - 0.00124188311688316*G0_0_1_0_6 + 0.000173498376623392*G0_0_1_0_7 - 0.00544237012987034*G0_0_1_0_8 - 0.00378043831168844*G0_0_1_0_9 - 0.00393567370129885*G0_0_1_1_0 - 0.0525974025974044*G0_0_1_1_1 - 0.00307426948051959*G0_0_1_1_2 - 0.0196783685064942*G0_0_1_1_3 + 0.0100994318181821*G0_0_1_1_4 + 0.00170758928571434*G0_0_1_1_5 + 0.000858360389610411*G0_0_1_1_6 + 0.0165827922077928*G0_0_1_1_7 - 0.0389458198051962*G0_0_1_1_8 - 0.0047666396103898*G0_0_1_1_9 - 0.00106534090909095*G0_0_1_2_0 - 0.00307426948051959*G0_0_1_2_1 - 0.0154017857142863*G0_0_1_2_2 + 0.00167106331168838*G0_0_1_2_3 - 0.00246550324675336*G0_0_1_2_4 + 0.00249289772727284*G0_0_1_2_5 - 0.00904017857142893*G0_0_1_2_6 + 0.00146103896103901*G0_0_1_2_7 - 0.00346996753246765*G0_0_1_2_8 + 0.000767045454545479*G0_0_1_2_9 - 0.000757913961038983*G0_0_1_3_0 - 0.0196783685064942*G0_0_1_3_1 + 0.00167106331168838*G0_0_1_3_2 + 0.013478084415585*G0_0_1_3_3 + 0.00460227272727286*G0_0_1_3_4 - 0.00336952110389622*G0_0_1_3_5 + 0.00131493506493512*G0_0_1_3_6 + 0.00616375811688331*G0_0_1_3_7 - 0.0204636769480526*G0_0_1_3_8 + 0.00197240259740272*G0_0_1_3_9 - 0.00111404220779225*G0_0_1_4_0 + 0.0100994318181821*G0_0_1_4_1 - 0.00246550324675336*G0_0_1_4_2 + 0.00460227272727286*G0_0_1_4_3 - 0.0259699675324685*G0_0_1_4_4 + 0.00723214285714311*G0_0_1_4_5 - 0.00854707792207824*G0_0_1_4_6 - 0.00246550324675333*G0_0_1_4_7 + 0.0142999188311693*G0_0_1_4_8 - 0.0167654220779226*G0_0_1_4_9 - 0.00241984577922085*G0_0_1_5_0 + 0.00170758928571434*G0_0_1_5_1 + 0.00249289772727284*G0_0_1_5_2 - 0.00336952110389622*G0_0_1_5_3 + 0.00723214285714311*G0_0_1_5_4 + 0.0238331980519488*G0_0_1_5_5 + 0.0134780844155849*G0_0_1_5_6 + 0.00172585227272733*G0_0_1_5_7 - 0.00123275162337666*G0_0_1_5_8 + 0.0138068181818186*G0_0_1_5_9 - 0.00124188311688316*G0_0_1_6_0 + 0.000858360389610412*G0_0_1_6_1 - 0.00904017857142893*G0_0_1_6_2 + 0.00131493506493512*G0_0_1_6_3 - 0.00854707792207824*G0_0_1_6_4 + 0.0134780844155849*G0_0_1_6_5 + 0.00361607142857147*G0_0_1_6_6 - 0.000493100649350666*G0_0_1_6_7 + 0.00197240259740266*G0_0_1_6_8 - 0.00493100649350668*G0_0_1_6_9 + 0.000173498376623393*G0_0_1_7_0 + 0.0165827922077928*G0_0_1_7_1 + 0.00146103896103901*G0_0_1_7_2 + 0.00616375811688331*G0_0_1_7_3 - 0.00246550324675333*G0_0_1_7_4 + 0.00172585227272734*G0_0_1_7_5 - 0.000493100649350666*G0_0_1_7_6 + 0.00821834415584448*G0_0_1_7_7 + 0.0316406250000011*G0_0_1_7_8 + 0.0123275162337667*G0_0_1_7_9 - 0.00544237012987034*G0_0_1_8_0 - 0.0389458198051962*G0_0_1_8_1 - 0.00346996753246765*G0_0_1_8_2 - 0.0204636769480526*G0_0_1_8_3 + 0.0142999188311693*G0_0_1_8_4 - 0.00123275162337666*G0_0_1_8_5 + 0.00197240259740266*G0_0_1_8_6 + 0.0316406250000011*G0_0_1_8_7 - 0.10568790584416*G0_0_1_8_8 - 0.0142999188311693*G0_0_1_8_9 - 0.00378043831168844*G0_0_1_9_0 - 0.0047666396103898*G0_0_1_9_1 + 0.000767045454545479*G0_0_1_9_2 + 0.00197240259740272*G0_0_1_9_3 - 0.0167654220779226*G0_0_1_9_4 + 0.0138068181818186*G0_0_1_9_5 - 0.00493100649350668*G0_0_1_9_6 + 0.0123275162337667*G0_0_1_9_7 - 0.0142999188311693*G0_0_1_9_8 - 0.0867857142857171*G0_0_1_9_9;
    A[23] = -A[28] - 0.00787134740259767*G0_1_0_0_0 - 0.00106534090909095*G0_1_0_0_1 - 0.00393567370129886*G0_1_0_0_2 - 0.00111404220779224*G0_1_0_0_3 - 0.000757913961038997*G0_1_0_0_4 + 0.000173498376623402*G0_1_0_0_5 - 0.00544237012987035*G0_1_0_0_6 - 0.00241984577922085*G0_1_0_0_7 - 0.00124188311688316*G0_1_0_0_8 - 0.00378043831168845*G0_1_0_0_9 - 0.00106534090909095*G0_1_0_1_0 - 0.0154017857142862*G0_1_0_1_1 - 0.0030742694805196*G0_1_0_1_2 - 0.00246550324675332*G0_1_0_1_3 + 0.00167106331168835*G0_1_0_1_4 + 0.00146103896103902*G0_1_0_1_5 - 0.00346996753246767*G0_1_0_1_6 + 0.00249289772727282*G0_1_0_1_7 - 0.0090401785714289*G0_1_0_1_8 + 0.000767045454545471*G0_1_0_1_9 - 0.00393567370129886*G0_1_0_2_0 - 0.0030742694805196*G0_1_0_2_1 - 0.0525974025974044*G0_1_0_2_2 + 0.0100994318181822*G0_1_0_2_3 - 0.0196783685064942*G0_1_0_2_4 + 0.0165827922077928*G0_1_0_2_5 - 0.0389458198051962*G0_1_0_2_6 + 0.00170758928571434*G0_1_0_2_7 + 0.000858360389610416*G0_1_0_2_8 - 0.00476663961038978*G0_1_0_2_9 - 0.00111404220779224*G0_1_0_3_0 - 0.00246550324675332*G0_1_0_3_1 + 0.0100994318181822*G0_1_0_3_2 - 0.0259699675324684*G0_1_0_3_3 + 0.00460227272727291*G0_1_0_3_4 - 0.00246550324675334*G0_1_0_3_5 + 0.0142999188311693*G0_1_0_3_6 + 0.00723214285714309*G0_1_0_3_7 - 0.00854707792207822*G0_1_0_3_8 - 0.0167654220779226*G0_1_0_3_9 - 0.000757913961038997*G0_1_0_4_0 + 0.00167106331168835*G0_1_0_4_1 - 0.0196783685064942*G0_1_0_4_2 + 0.00460227272727291*G0_1_0_4_3 + 0.0134780844155848*G0_1_0_4_4 + 0.00616375811688336*G0_1_0_4_5 - 0.0204636769480527*G0_1_0_4_6 - 0.00336952110389622*G0_1_0_4_7 + 0.00131493506493511*G0_1_0_4_8 + 0.00197240259740265*G0_1_0_4_9 + 0.000173498376623402*G0_1_0_5_0 + 0.00146103896103902*G0_1_0_5_1 + 0.0165827922077928*G0_1_0_5_2 - 0.00246550324675334*G0_1_0_5_3 + 0.00616375811688336*G0_1_0_5_4 + 0.0082183441558444*G0_1_0_5_5 + 0.0316406250000012*G0_1_0_5_6 + 0.00172585227272733*G0_1_0_5_7 - 0.000493100649350669*G0_1_0_5_8 + 0.0123275162337667*G0_1_0_5_9 - 0.00544237012987035*G0_1_0_6_0 - 0.00346996753246767*G0_1_0_6_1 - 0.0389458198051962*G0_1_0_6_2 + 0.0142999188311693*G0_1_0_6_3 - 0.0204636769480527*G0_1_0_6_4 + 0.0316406250000012*G0_1_0_6_5 - 0.10568790584416*G0_1_0_6_6 - 0.00123275162337667*G0_1_0_6_7 + 0.00197240259740267*G0_1_0_6_8 - 0.0142999188311693*G0_1_0_6_9 - 0.00241984577922085*G0_1_0_7_0 + 0.00249289772727282*G0_1_0_7_1 + 0.00170758928571434*G0_1_0_7_2 + 0.00723214285714309*G0_1_0_7_3 - 0.00336952110389622*G0_1_0_7_4 + 0.00172585227272733*G0_1_0_7_5 - 0.00123275162337667*G0_1_0_7_6 + 0.0238331980519489*G0_1_0_7_7 + 0.0134780844155849*G0_1_0_7_8 + 0.0138068181818186*G0_1_0_7_9 - 0.00124188311688316*G0_1_0_8_0 - 0.0090401785714289*G0_1_0_8_1 + 0.000858360389610416*G0_1_0_8_2 - 0.00854707792207822*G0_1_0_8_3 + 0.00131493506493511*G0_1_0_8_4 - 0.00049310064935067*G0_1_0_8_5 + 0.00197240259740267*G0_1_0_8_6 + 0.0134780844155849*G0_1_0_8_7 + 0.00361607142857154*G0_1_0_8_8 - 0.00493100649350667*G0_1_0_8_9 - 0.00378043831168845*G0_1_0_9_0 + 0.000767045454545471*G0_1_0_9_1 - 0.00476663961038978*G0_1_0_9_2 - 0.0167654220779226*G0_1_0_9_3 + 0.00197240259740266*G0_1_0_9_4 + 0.0123275162337667*G0_1_0_9_5 - 0.0142999188311693*G0_1_0_9_6 + 0.0138068181818186*G0_1_0_9_7 - 0.00493100649350667*G0_1_0_9_8 - 0.0867857142857172*G0_1_0_9_9;
    A[25] = -A[23] - 0.00196022727272735*G0_1_0_0_0 - 0.000980113636363669*G0_1_0_0_2 - 0.00213676948051956*G0_1_0_0_3 + 0.00213676948051957*G0_1_0_0_4 - 0.00109577922077925*G0_1_0_0_5 - 0.00405438311688327*G0_1_0_0_6 - 0.00158887987012993*G0_1_0_0_7 + 0.000876623376623407*G0_1_0_0_8 - 0.00525974025974045*G0_1_0_0_9 + 0.00196022727272733*G0_1_0_1_1 + 0.00098011363636367*G0_1_0_1_2 + 0.00109577922077924*G0_1_0_1_3 + 0.00405438311688327*G0_1_0_1_4 + 0.00213676948051955*G0_1_0_1_5 - 0.00213676948051956*G0_1_0_1_6 - 0.000876623376623403*G0_1_0_1_7 + 0.00158887987012992*G0_1_0_1_8 + 0.00525974025974044*G0_1_0_1_9 - 0.000980113636363669*G0_1_0_2_0 + 0.000980113636363669*G0_1_0_2_1 - 0.00493100649350667*G0_1_0_2_3 + 0.01479301948052*G0_1_0_2_4 + 0.00493100649350665*G0_1_0_2_5 - 0.01479301948052*G0_1_0_2_6 - 0.00016436688311689*G0_1_0_2_7 + 0.000164366883116885*G0_1_0_2_8 - 0.00213676948051956*G0_1_0_3_0 + 0.00109577922077924*G0_1_0_3_1 - 0.00493100649350667*G0_1_0_3_2 - 0.035503246753248*G0_1_0_3_3 - 0.0212033279220786*G0_1_0_3_4 + 0.00641030844155864*G0_1_0_3_6 + 0.00641030844155866*G0_1_0_3_7 - 0.005917207792208*G0_1_0_3_8 - 0.0285998376623386*G0_1_0_3_9 + 0.00213676948051957*G0_1_0_4_0 + 0.00405438311688327*G0_1_0_4_1 + 0.01479301948052*G0_1_0_4_2 - 0.0212033279220786*G0_1_0_4_3 + 0.0936891233766266*G0_1_0_4_4 - 0.00641030844155867*G0_1_0_4_5 - 0.002958603896104*G0_1_0_4_7 - 0.00049310064935066*G0_1_0_4_8 + 0.0128206168831173*G0_1_0_4_9 - 0.00109577922077925*G0_1_0_5_0 + 0.00213676948051955*G0_1_0_5_1 + 0.00493100649350665*G0_1_0_5_2 - 0.00641030844155867*G0_1_0_5_4 + 0.0355032467532479*G0_1_0_5_5 + 0.0212033279220786*G0_1_0_5_6 + 0.005917207792208*G0_1_0_5_7 - 0.00641030844155866*G0_1_0_5_8 + 0.0285998376623386*G0_1_0_5_9 - 0.00405438311688327*G0_1_0_6_0 - 0.00213676948051956*G0_1_0_6_1 - 0.01479301948052*G0_1_0_6_2 + 0.00641030844155864*G0_1_0_6_3 + 0.0212033279220786*G0_1_0_6_5 - 0.0936891233766265*G0_1_0_6_6 + 0.000493100649350656*G0_1_0_6_7 + 0.00295860389610399*G0_1_0_6_8 - 0.0128206168831173*G0_1_0_6_9 - 0.00158887987012993*G0_1_0_7_0 - 0.000876623376623403*G0_1_0_7_1 - 0.00016436688311689*G0_1_0_7_2 + 0.00641030844155866*G0_1_0_7_3 - 0.002958603896104*G0_1_0_7_4 + 0.005917207792208*G0_1_0_7_5 + 0.000493100649350656*G0_1_0_7_6 - 0.00394480519480534*G0_1_0_7_7 + 0.01479301948052*G0_1_0_7_9 + 0.000876623376623408*G0_1_0_8_0 + 0.00158887987012992*G0_1_0_8_1 + 0.000164366883116885*G0_1_0_8_2 - 0.005917207792208*G0_1_0_8_3 - 0.00049310064935066*G0_1_0_8_4 - 0.00641030844155866*G0_1_0_8_5 + 0.00295860389610399*G0_1_0_8_6 + 0.0039448051948053*G0_1_0_8_8 - 0.01479301948052*G0_1_0_8_9 - 0.00525974025974045*G0_1_0_9_0 + 0.00525974025974044*G0_1_0_9_1 - 0.0285998376623386*G0_1_0_9_3 + 0.0128206168831173*G0_1_0_9_4 + 0.0285998376623386*G0_1_0_9_5 - 0.0128206168831173*G0_1_0_9_6 + 0.01479301948052*G0_1_0_9_7 - 0.01479301948052*G0_1_0_9_8 + 0.0180560064935071*G0_1_1_0_0 + 0.00271814123376633*G0_1_1_0_1 + 0.00281554383116895*G0_1_1_0_2 - 0.00125101461038967*G0_1_1_0_3 + 0.00176237824675333*G0_1_1_0_4 + 0.00462053571428586*G0_1_1_0_5 - 0.00315949675324684*G0_1_1_0_6 + 0.0116517857142861*G0_1_1_0_7 - 0.00341517857142868*G0_1_1_0_8 - 0.000986201298701323*G0_1_1_0_9 + 0.00271814123376633*G0_1_1_1_0 + 0.0200162337662344*G0_1_1_1_1 + 0.00379565746753261*G0_1_1_1_2 + 0.00571631493506511*G0_1_1_1_3 + 0.000894886363636417*G0_1_1_1_4 + 0.000885754870129895*G0_1_1_1_5 - 0.000374391233766236*G0_1_1_1_6 - 0.00429180194805211*G0_1_1_1_7 + 0.0132406655844161*G0_1_1_1_8 + 0.00427353896103911*G0_1_1_1_9 + 0.00281554383116895*G0_1_1_2_0 + 0.00379565746753261*G0_1_1_2_1 + 0.0471185064935082*G0_1_1_2_2 - 0.0130945616883122*G0_1_1_2_3 + 0.0306818181818193*G0_1_1_2_4 - 0.00816355519480551*G0_1_1_2_5 + 0.0158887987012993*G0_1_1_2_6 + 0.000721387987013008*G0_1_1_2_7 + 0.000885754870129896*G0_1_1_2_8 + 0.00372564935064949*G0_1_1_2_9 - 0.00125101461038967*G0_1_1_3_0 + 0.00571631493506511*G0_1_1_3_1 - 0.0130945616883122*G0_1_1_3_2 - 0.0161079545454551*G0_1_1_3_3 - 0.0222717126623384*G0_1_1_3_4 + 0.00230113636363646*G0_1_1_3_5 - 0.00238331980519492*G0_1_1_3_6 + 0.000246550324675333*G0_1_1_3_7 + 0.00591720779220798*G0_1_1_3_8 - 0.013313717532468*G0_1_1_3_9 + 0.00176237824675332*G0_1_1_4_0 + 0.000894886363636417*G0_1_1_4_1 + 0.0306818181818193*G0_1_1_4_2 - 0.0222717126623384*G0_1_1_4_3 + 0.0726501623376649*G0_1_1_4_4 - 0.00879362824675359*G0_1_1_4_5 + 0.0111769480519485*G0_1_1_4_6 - 0.00197240259740267*G0_1_1_4_7 - 0.00616375811688331*G0_1_1_4_8 + 0.00641030844155868*G0_1_1_4_9 + 0.00462053571428586*G0_1_1_5_0 + 0.000885754870129895*G0_1_1_5_1 - 0.00816355519480551*G0_1_1_5_2 + 0.00230113636363646*G0_1_1_5_3 - 0.00879362824675359*G0_1_1_5_4 + 0.0193952922077929*G0_1_1_5_5 - 0.00106838474025984*G0_1_1_5_6 + 0.011834415584416*G0_1_1_5_7 - 0.00616375811688332*G0_1_1_5_8 + 0.0152861201298706*G0_1_1_5_9 - 0.00315949675324684*G0_1_1_6_0 - 0.000374391233766236*G0_1_1_6_1 + 0.0158887987012993*G0_1_1_6_2 - 0.00238331980519493*G0_1_1_6_3 + 0.0111769480519485*G0_1_1_6_4 - 0.00106838474025984*G0_1_1_6_5 - 0.0210389610389616*G0_1_1_6_6 - 0.00567065746753266*G0_1_1_6_7 + 0.000986201298701332*G0_1_1_6_8 - 0.00641030844155862*G0_1_1_6_9 + 0.0116517857142861*G0_1_1_7_0 - 0.00429180194805211*G0_1_1_7_1 + 0.000721387987013008*G0_1_1_7_2 + 0.000246550324675332*G0_1_1_7_3 - 0.00197240259740267*G0_1_1_7_4 + 0.011834415584416*G0_1_1_7_5 - 0.00567065746753266*G0_1_1_7_6 + 0.0535836038961057*G0_1_1_7_7 - 0.0201349431818189*G0_1_1_7_8 + 0.0142999188311693*G0_1_1_7_9 - 0.00341517857142869*G0_1_1_8_0 + 0.0132406655844161*G0_1_1_8_1 + 0.000885754870129896*G0_1_1_8_2 + 0.00591720779220798*G0_1_1_8_3 - 0.00616375811688331*G0_1_1_8_4 - 0.00616375811688332*G0_1_1_8_5 + 0.000986201298701332*G0_1_1_8_6 - 0.0201349431818189*G0_1_1_8_7 + 0.057528409090911*G0_1_1_8_8 - 0.000493100649350695*G0_1_1_8_9 - 0.000986201298701323*G0_1_1_9_0 + 0.00427353896103911*G0_1_1_9_1 + 0.00372564935064949*G0_1_1_9_2 - 0.013313717532468*G0_1_1_9_3 + 0.00641030844155868*G0_1_1_9_4 + 0.0152861201298706*G0_1_1_9_5 - 0.00641030844155862*G0_1_1_9_6 + 0.0142999188311693*G0_1_1_9_7 - 0.000493100649350693*G0_1_1_9_8 + 0.0374756493506506*G0_1_1_9_9;
    A[19] = 0.00360389610389623*G0_0_0_0_0 - 0.00136972402597408*G0_0_0_0_1 + 0.000487012987013002*G0_0_0_0_2 - 0.0062459415584418*G0_0_0_0_3 + 0.00427353896103912*G0_0_0_0_4 + 0.00405438311688326*G0_0_0_0_5 - 0.00186282467532472*G0_0_0_0_6 + 0.0035612824675326*G0_0_0_0_7 - 0.00482142857142875*G0_0_0_0_8 + 0.000328733766233773*G0_0_0_0_9 - 0.00136972402597408*G0_0_0_1_0 - 0.0185064935064941*G0_0_0_1_1 - 0.00234983766233774*G0_0_0_1_2 - 0.0282163149350659*G0_0_0_1_3 + 0.011724837662338*G0_0_0_1_4 + 0.0027942370129871*G0_0_0_1_5 + 0.00262987012987023*G0_0_0_1_6 + 0.00679383116883141*G0_0_0_1_7 - 0.0134232954545459*G0_0_0_1_8 - 0.00427353896103912*G0_0_0_1_9 + 0.000487012987013002*G0_0_0_2_0 - 0.00234983766233774*G0_0_0_2_1 + 0.00164366883116889*G0_0_0_2_2 - 0.00887581168831199*G0_0_0_2_3 + 0.00246550324675333*G0_0_0_2_4 - 0.000986201298701328*G0_0_0_2_5 + 0.00246550324675334*G0_0_0_2_6 + 0.00213676948051956*G0_0_0_2_7 - 0.00410917207792222*G0_0_0_2_8 - 0.00493100649350666*G0_0_0_2_9 - 0.0062459415584418*G0_0_0_3_0 - 0.0282163149350659*G0_0_0_3_1 - 0.00887581168831199*G0_0_0_3_2 - 0.130178571428576*G0_0_0_3_3 + 0.0374756493506506*G0_0_0_3_4 + 0.00295860389610402*G0_0_0_3_5 - 0.00345170454545463*G0_0_0_3_6 + 0.0231757305194814*G0_0_0_3_7 - 0.0399411525974041*G0_0_0_3_8 - 0.0335308441558454*G0_0_0_3_9 + 0.00427353896103912*G0_0_0_4_0 + 0.011724837662338*G0_0_0_4_1 + 0.00246550324675333*G0_0_0_4_2 + 0.0374756493506506*G0_0_0_4_3 + 0.0246550324675333*G0_0_0_4_4 - 0.00838271103896133*G0_0_0_4_5 + 0.011834415584416*G0_0_0_4_6 - 0.011834415584416*G0_0_0_4_7 + 0.0167654220779227*G0_0_0_4_8 + 0.0315584415584426*G0_0_0_4_9 + 0.00405438311688326*G0_0_0_5_0 + 0.0027942370129871*G0_0_0_5_1 - 0.000986201298701328*G0_0_0_5_2 + 0.00295860389610402*G0_0_0_5_3 - 0.00838271103896133*G0_0_0_5_4 + 0.0739650974025998*G0_0_0_5_5 - 0.00493100649350668*G0_0_0_5_6 + 0.00591720779220799*G0_0_0_5_7 - 0.00394480519480532*G0_0_0_5_8 + 0.00690340909090933*G0_0_0_5_9 - 0.00186282467532472*G0_0_0_6_0 + 0.00262987012987023*G0_0_0_6_1 + 0.00246550324675334*G0_0_0_6_2 - 0.00345170454545463*G0_0_0_6_3 + 0.011834415584416*G0_0_0_6_4 - 0.00493100649350667*G0_0_0_6_5 + 0.0700202922077946*G0_0_0_6_6 - 0.00197240259740266*G0_0_0_6_7 + 0.0216964285714293*G0_0_0_6_9 + 0.0035612824675326*G0_0_0_7_0 + 0.00679383116883141*G0_0_0_7_1 + 0.00213676948051956*G0_0_0_7_2 + 0.0231757305194814*G0_0_0_7_3 - 0.011834415584416*G0_0_0_7_4 + 0.00591720779220799*G0_0_0_7_5 - 0.00197240259740266*G0_0_0_7_6 - 0.0108482142857147*G0_0_0_7_7 + 0.016272321428572*G0_0_0_7_8 + 0.00295860389610404*G0_0_0_7_9 - 0.00482142857142875*G0_0_0_8_0 - 0.0134232954545459*G0_0_0_8_1 - 0.00410917207792222*G0_0_0_8_2 - 0.0399411525974041*G0_0_0_8_3 + 0.0167654220779227*G0_0_0_8_4 - 0.00394480519480532*G0_0_0_8_5 + 0.016272321428572*G0_0_0_8_7 - 0.0364894480519493*G0_0_0_8_8 - 0.020710227272728*G0_0_0_8_9 + 0.000328733766233773*G0_0_0_9_0 - 0.00427353896103912*G0_0_0_9_1 - 0.00493100649350666*G0_0_0_9_2 - 0.0335308441558454*G0_0_0_9_3 + 0.0315584415584426*G0_0_0_9_4 + 0.00690340909090934*G0_0_0_9_5 + 0.0216964285714293*G0_0_0_9_6 + 0.00295860389610404*G0_0_0_9_7 - 0.020710227272728*G0_0_0_9_8 + 0.00196022727272736*G0_0_1_0_0 + 0.00098011363636368*G0_0_1_0_1 - 0.00213676948051957*G0_0_1_0_3 + 0.00213676948051956*G0_0_1_0_4 + 0.00158887987012993*G0_0_1_0_5 - 0.000876623376623411*G0_0_1_0_6 + 0.00109577922077926*G0_0_1_0_7 + 0.00405438311688327*G0_0_1_0_8 + 0.00525974025974044*G0_0_1_0_9 + 0.00098011363636368*G0_0_1_1_0 - 0.000980113636363665*G0_0_1_1_2 - 0.0147930194805199*G0_0_1_1_3 + 0.00493100649350663*G0_0_1_1_4 + 0.000164366883116887*G0_0_1_1_5 - 0.000164366883116887*G0_0_1_1_6 - 0.0049310064935067*G0_0_1_1_7 + 0.0147930194805201*G0_0_1_1_8 - 0.000980113636363665*G0_0_1_2_1 - 0.00196022727272736*G0_0_1_2_2 - 0.00405438311688325*G0_0_1_2_3 - 0.00109577922077927*G0_0_1_2_4 + 0.000876623376623414*G0_0_1_2_5 - 0.00158887987012994*G0_0_1_2_6 - 0.00213676948051955*G0_0_1_2_7 + 0.00213676948051955*G0_0_1_2_8 - 0.00525974025974044*G0_0_1_2_9 - 0.00213676948051957*G0_0_1_3_0 - 0.0147930194805199*G0_0_1_3_1 - 0.00405438311688325*G0_0_1_3_2 - 0.0936891233766267*G0_0_1_3_3 + 0.0212033279220786*G0_0_1_3_4 + 0.002958603896104*G0_0_1_3_5 + 0.000493100649350682*G0_0_1_3_6 + 0.0064103084415587*G0_0_1_3_7 - 0.0128206168831174*G0_0_1_3_9 + 0.00213676948051956*G0_0_1_4_0 + 0.00493100649350664*G0_0_1_4_1 - 0.00109577922077927*G0_0_1_4_2 + 0.0212033279220786*G0_0_1_4_3 + 0.035503246753248*G0_0_1_4_4 - 0.00641030844155866*G0_0_1_4_5 + 0.00591720779220798*G0_0_1_4_6 - 0.00641030844155865*G0_0_1_4_8 + 0.0285998376623386*G0_0_1_4_9 + 0.00158887987012993*G0_0_1_5_0 + 0.000164366883116887*G0_0_1_5_1 + 0.000876623376623415*G0_0_1_5_2 + 0.002958603896104*G0_0_1_5_3 - 0.00641030844155866*G0_0_1_5_4 + 0.00394480519480533*G0_0_1_5_5 - 0.005917207792208*G0_0_1_5_7 - 0.000493100649350664*G0_0_1_5_8 - 0.01479301948052*G0_0_1_5_9 - 0.000876623376623411*G0_0_1_6_0 - 0.000164366883116887*G0_0_1_6_1 - 0.00158887987012994*G0_0_1_6_2 + 0.000493100649350682*G0_0_1_6_3 + 0.00591720779220798*G0_0_1_6_4 - 0.00394480519480537*G0_0_1_6_6 + 0.00641030844155866*G0_0_1_6_7 - 0.00295860389610399*G0_0_1_6_8 + 0.01479301948052*G0_0_1_6_9 + 0.00109577922077926*G0_0_1_7_0 - 0.0049310064935067*G0_0_1_7_1 - 0.00213676948051955*G0_0_1_7_2 + 0.0064103084415587*G0_0_1_7_3 - 0.005917207792208*G0_0_1_7_5 + 0.00641030844155866*G0_0_1_7_6 - 0.0355032467532481*G0_0_1_7_7 - 0.0212033279220787*G0_0_1_7_8 - 0.0285998376623386*G0_0_1_7_9 + 0.00405438311688327*G0_0_1_8_0 + 0.0147930194805201*G0_0_1_8_1 + 0.00213676948051955*G0_0_1_8_2 - 0.00641030844155865*G0_0_1_8_4 - 0.000493100649350664*G0_0_1_8_5 - 0.00295860389610399*G0_0_1_8_6 - 0.0212033279220787*G0_0_1_8_7 + 0.0936891233766267*G0_0_1_8_8 + 0.0128206168831173*G0_0_1_8_9 + 0.00525974025974044*G0_0_1_9_0 - 0.00525974025974044*G0_0_1_9_2 - 0.0128206168831174*G0_0_1_9_3 + 0.0285998376623386*G0_0_1_9_4 - 0.01479301948052*G0_0_1_9_5 + 0.01479301948052*G0_0_1_9_6 - 0.0285998376623386*G0_0_1_9_7 + 0.0128206168831173*G0_0_1_9_8;
    A[90] = A[19] - 0.0221103896103904*G0_0_0_0_0 - 0.00283685064935075*G0_0_0_0_2 + 0.00904017857142892*G0_0_0_0_3 - 0.00164366883116889*G0_0_0_0_4 - 0.0322706980519492*G0_0_0_0_5 + 0.0135876623376628*G0_0_0_0_6 - 0.0169845779220785*G0_0_0_0_7 + 0.0116152597402602*G0_0_0_0_8 - 0.00460227272727289*G0_0_0_0_9 + 0.0221103896103903*G0_0_0_1_1 + 0.00283685064935074*G0_0_0_1_2 + 0.0322706980519491*G0_0_0_1_3 - 0.0135876623376628*G0_0_0_1_4 - 0.00904017857142887*G0_0_0_1_5 + 0.00164366883116888*G0_0_0_1_6 - 0.0116152597402602*G0_0_0_1_7 + 0.0169845779220785*G0_0_0_1_8 + 0.0046022727272729*G0_0_0_1_9 - 0.00283685064935075*G0_0_0_2_0 + 0.00283685064935074*G0_0_0_2_1 + 0.00788961038961065*G0_0_0_2_3 - 0.00788961038961067*G0_0_0_2_5 - 0.00624594155844178*G0_0_0_2_7 + 0.00624594155844178*G0_0_0_2_8 + 0.00904017857142892*G0_0_0_3_0 + 0.0322706980519491*G0_0_0_3_1 + 0.00788961038961065*G0_0_0_3_2 + 0.204143668831176*G0_0_0_3_3 - 0.0424066558441573*G0_0_0_3_4 - 0.00493100649350668*G0_0_0_3_6 - 0.0271205357142867*G0_0_0_3_7 + 0.0458583603896121*G0_0_0_3_8 + 0.0404342532467548*G0_0_0_3_9 - 0.00164366883116889*G0_0_0_4_0 - 0.0135876623376628*G0_0_0_4_1 - 0.0424066558441573*G0_0_0_4_3 + 0.0453652597402613*G0_0_0_4_4 + 0.00493100649350669*G0_0_0_4_5 + 0.011834415584416*G0_0_0_4_7 - 0.0187378246753253*G0_0_0_4_8 - 0.00986201298701333*G0_0_0_4_9 - 0.0322706980519492*G0_0_0_5_0 - 0.00904017857142887*G0_0_0_5_1 - 0.00788961038961067*G0_0_0_5_2 + 0.00493100649350669*G0_0_0_5_4 - 0.204143668831176*G0_0_0_5_5 + 0.0424066558441573*G0_0_0_5_6 - 0.045858360389612*G0_0_0_5_7 + 0.0271205357142866*G0_0_0_5_8 - 0.0404342532467547*G0_0_0_5_9 + 0.0135876623376628*G0_0_0_6_0 + 0.00164366883116888*G0_0_0_6_1 - 0.00493100649350669*G0_0_0_6_3 + 0.0424066558441573*G0_0_0_6_5 - 0.0453652597402613*G0_0_0_6_6 + 0.0187378246753253*G0_0_0_6_7 - 0.011834415584416*G0_0_0_6_8 + 0.00986201298701337*G0_0_0_6_9 - 0.0169845779220785*G0_0_0_7_0 - 0.0116152597402602*G0_0_0_7_1 - 0.00624594155844178*G0_0_0_7_2 - 0.0271205357142867*G0_0_0_7_3 + 0.011834415584416*G0_0_0_7_4 - 0.045858360389612*G0_0_0_7_5 + 0.0187378246753253*G0_0_0_7_6 - 0.0256412337662347*G0_0_0_7_7 - 0.0236688311688321*G0_0_0_7_9 + 0.0116152597402602*G0_0_0_8_0 + 0.0169845779220785*G0_0_0_8_1 + 0.00624594155844178*G0_0_0_8_2 + 0.0458583603896121*G0_0_0_8_3 - 0.0187378246753253*G0_0_0_8_4 + 0.0271205357142866*G0_0_0_8_5 - 0.011834415584416*G0_0_0_8_6 + 0.0256412337662347*G0_0_0_8_8 + 0.0236688311688321*G0_0_0_8_9 - 0.00460227272727289*G0_0_0_9_0 + 0.0046022727272729*G0_0_0_9_1 + 0.0404342532467548*G0_0_0_9_3 - 0.00986201298701333*G0_0_0_9_4 - 0.0404342532467547*G0_0_0_9_5 + 0.00986201298701337*G0_0_0_9_6 - 0.0236688311688321*G0_0_0_9_7 + 0.0236688311688321*G0_0_0_9_8 - 0.0204667207792216*G0_0_1_0_0 - 0.00234983766233775*G0_0_1_0_1 - 0.00234983766233774*G0_0_1_0_2 + 0.00493100649350669*G0_0_1_0_3 + 0.000493100649350677*G0_0_1_0_4 - 0.0298051948051958*G0_0_1_0_5 + 0.0126014610389615*G0_0_1_0_6 - 0.0145190746753252*G0_0_1_0_7 + 0.00273944805194815*G0_0_1_0_8 - 0.00953327922077956*G0_0_1_0_9 - 0.00234983766233775*G0_0_1_1_0 + 0.00360389610389609*G0_0_1_1_1 + 0.00146712662337667*G0_0_1_1_2 + 0.0188474025974032*G0_0_1_1_3 - 0.00679383116883136*G0_0_1_1_4 - 0.00641030844155866*G0_0_1_1_5 + 0.004437905844156*G0_0_1_1_6 + 0.000109577922077958*G0_0_1_1_7 - 0.0112317370129875*G0_0_1_1_8 + 0.000328733766233782*G0_0_1_1_9 - 0.00234983766233774*G0_0_1_2_0 + 0.00146712662337667*G0_0_1_2_1 + 0.00360389610389624*G0_0_1_2_2 + 0.00306818181818191*G0_0_1_2_3 + 0.0035612824675326*G0_0_1_2_4 - 0.00975243506493541*G0_0_1_2_5 + 0.00405438311688327*G0_0_1_2_6 - 0.00197240259740267*G0_0_1_2_7 + 0.000328733766233774*G0_0_1_2_9 + 0.00493100649350669*G0_0_1_3_0 + 0.0188474025974032*G0_0_1_3_1 + 0.00306818181818191*G0_0_1_3_2 + 0.167654220779227*G0_0_1_3_3 - 0.0261343344155853*G0_0_1_3_4 - 0.008875811688312*G0_0_1_3_6 - 0.010355113636364*G0_0_1_3_7 + 0.00591720779220806*G0_0_1_3_8 + 0.0197240259740268*G0_0_1_3_9 + 0.000493100649350678*G0_0_1_4_0 - 0.00679383116883136*G0_0_1_4_1 + 0.0035612824675326*G0_0_1_4_2 - 0.0261343344155853*G0_0_1_4_3 + 0.0345170454545467*G0_0_1_4_4 + 0.00295860389610401*G0_0_1_4_5 + 0.00591720779220801*G0_0_1_4_6 + 0.00443790584415597*G0_0_1_4_8 - 0.00690340909090932*G0_0_1_4_9 - 0.0298051948051958*G0_0_1_5_0 - 0.00641030844155866*G0_0_1_5_1 - 0.00975243506493541*G0_0_1_5_2 + 0.002958603896104*G0_0_1_5_4 - 0.134123376623381*G0_0_1_5_5 + 0.0374756493506506*G0_0_1_5_6 - 0.034023944805196*G0_0_1_5_7 + 0.023668831168832*G0_0_1_5_8 - 0.0187378246753254*G0_0_1_5_9 + 0.0126014610389615*G0_0_1_6_0 + 0.004437905844156*G0_0_1_6_1 + 0.00405438311688327*G0_0_1_6_2 - 0.008875811688312*G0_0_1_6_3 + 0.00591720779220801*G0_0_1_6_4 + 0.0374756493506506*G0_0_1_6_5 + 0.0285998376623387*G0_0_1_6_6 + 0.010355113636364*G0_0_1_6_7 - 0.00887581168831201*G0_0_1_6_8 + 0.0167654220779227*G0_0_1_6_9 - 0.0145190746753252*G0_0_1_7_0 + 0.000109577922077959*G0_0_1_7_1 - 0.00197240259740267*G0_0_1_7_2 - 0.010355113636364*G0_0_1_7_3 - 0.034023944805196*G0_0_1_7_5 + 0.010355113636364*G0_0_1_7_6 - 0.000986201298701285*G0_0_1_7_7 + 0.0374756493506507*G0_0_1_7_8 + 0.00788961038961062*G0_0_1_7_9 + 0.00273944805194815*G0_0_1_8_0 - 0.0112317370129875*G0_0_1_8_1 + 0.00591720779220806*G0_0_1_8_3 + 0.00443790584415597*G0_0_1_8_4 + 0.023668831168832*G0_0_1_8_5 - 0.00887581168831201*G0_0_1_8_6 + 0.0374756493506507*G0_0_1_8_7 - 0.104537337662341*G0_0_1_8_8 - 0.00986201298701329*G0_0_1_8_9 - 0.00953327922077956*G0_0_1_9_0 + 0.000328733766233783*G0_0_1_9_1 + 0.000328733766233774*G0_0_1_9_2 + 0.0197240259740268*G0_0_1_9_3 - 0.00690340909090932*G0_0_1_9_4 - 0.0187378246753254*G0_0_1_9_5 + 0.0167654220779227*G0_0_1_9_6 + 0.00788961038961062*G0_0_1_9_7 - 0.00986201298701329*G0_0_1_9_8 - 0.0185064935064943*G0_1_0_0_0 - 0.00234983766233775*G0_1_0_0_1 - 0.00136972402597408*G0_1_0_0_2 + 0.00262987012987023*G0_1_0_0_3 + 0.00279423701298713*G0_1_0_0_4 - 0.013423295454546*G0_1_0_0_5 + 0.00679383116883143*G0_1_0_0_6 - 0.028216314935066*G0_1_0_0_7 + 0.0117248376623381*G0_1_0_0_8 - 0.00427353896103913*G0_1_0_0_9 - 0.00234983766233775*G0_1_0_1_0 + 0.00164366883116887*G0_1_0_1_1 + 0.000487012987013004*G0_1_0_1_2 + 0.00246550324675333*G0_1_0_1_3 - 0.000986201298701321*G0_1_0_1_4 - 0.00410917207792223*G0_1_0_1_5 + 0.00213676948051956*G0_1_0_1_6 - 0.00887581168831201*G0_1_0_1_7 + 0.00246550324675333*G0_1_0_1_8 - 0.00493100649350667*G0_1_0_1_9 - 0.00136972402597408*G0_1_0_2_0 + 0.000487012987013004*G0_1_0_2_1 + 0.00360389610389624*G0_1_0_2_2 - 0.00186282467532475*G0_1_0_2_3 + 0.00405438311688327*G0_1_0_2_4 - 0.00482142857142875*G0_1_0_2_5 + 0.00356128246753261*G0_1_0_2_6 - 0.00624594155844178*G0_1_0_2_7 + 0.00427353896103911*G0_1_0_2_8 + 0.000328733766233771*G0_1_0_2_9 + 0.00262987012987023*G0_1_0_3_0 + 0.00246550324675333*G0_1_0_3_1 - 0.00186282467532475*G0_1_0_3_2 + 0.0700202922077947*G0_1_0_3_3 - 0.00493100649350664*G0_1_0_3_4 - 0.00197240259740267*G0_1_0_3_6 - 0.00345170454545465*G0_1_0_3_7 + 0.011834415584416*G0_1_0_3_8 + 0.0216964285714293*G0_1_0_3_9 + 0.00279423701298713*G0_1_0_4_0 - 0.000986201298701321*G0_1_0_4_1 + 0.00405438311688327*G0_1_0_4_2 - 0.00493100649350664*G0_1_0_4_3 + 0.0739650974026*G0_1_0_4_4 - 0.00394480519480533*G0_1_0_4_5 + 0.00591720779220801*G0_1_0_4_6 + 0.00295860389610402*G0_1_0_4_7 - 0.00838271103896133*G0_1_0_4_8 + 0.00690340909090935*G0_1_0_4_9 - 0.013423295454546*G0_1_0_5_0 - 0.00410917207792223*G0_1_0_5_1 - 0.00482142857142875*G0_1_0_5_2 - 0.00394480519480532*G0_1_0_5_4 - 0.0364894480519494*G0_1_0_5_5 + 0.016272321428572*G0_1_0_5_6 - 0.039941152597404*G0_1_0_5_7 + 0.0167654220779227*G0_1_0_5_8 - 0.020710227272728*G0_1_0_5_9 + 0.00679383116883143*G0_1_0_6_0 + 0.00213676948051956*G0_1_0_6_1 + 0.00356128246753261*G0_1_0_6_2 - 0.00197240259740267*G0_1_0_6_3 + 0.00591720779220801*G0_1_0_6_4 + 0.016272321428572*G0_1_0_6_5 - 0.0108482142857147*G0_1_0_6_6 + 0.0231757305194813*G0_1_0_6_7 - 0.011834415584416*G0_1_0_6_8 + 0.00295860389610402*G0_1_0_6_9 - 0.028216314935066*G0_1_0_7_0 - 0.00887581168831201*G0_1_0_7_1 - 0.00624594155844178*G0_1_0_7_2 - 0.00345170454545465*G0_1_0_7_3 + 0.00295860389610402*G0_1_0_7_4 - 0.039941152597404*G0_1_0_7_5 + 0.0231757305194813*G0_1_0_7_6 - 0.130178571428576*G0_1_0_7_7 + 0.0374756493506507*G0_1_0_7_8 - 0.0335308441558454*G0_1_0_7_9 + 0.0117248376623381*G0_1_0_8_0 + 0.00246550324675333*G0_1_0_8_1 + 0.00427353896103911*G0_1_0_8_2 + 0.011834415584416*G0_1_0_8_3 - 0.00838271103896133*G0_1_0_8_4 + 0.0167654220779227*G0_1_0_8_5 - 0.011834415584416*G0_1_0_8_6 + 0.0374756493506507*G0_1_0_8_7 + 0.0246550324675333*G0_1_0_8_8 + 0.0315584415584427*G0_1_0_8_9 - 0.00427353896103913*G0_1_0_9_0 - 0.00493100649350667*G0_1_0_9_1 + 0.000328733766233772*G0_1_0_9_2 + 0.0216964285714293*G0_1_0_9_3 + 0.00690340909090934*G0_1_0_9_4 - 0.020710227272728*G0_1_0_9_5 + 0.00295860389610402*G0_1_0_9_6 - 0.0335308441558454*G0_1_0_9_7 + 0.0315584415584427*G0_1_0_9_8 - 0.0185064935064943*G0_1_1_0_0 - 0.00234983766233775*G0_1_1_0_1 - 0.00136972402597408*G0_1_1_0_2 + 0.00262987012987023*G0_1_1_0_3 + 0.00279423701298713*G0_1_1_0_4 - 0.013423295454546*G0_1_1_0_5 + 0.00679383116883143*G0_1_1_0_6 - 0.028216314935066*G0_1_1_0_7 + 0.0117248376623381*G0_1_1_0_8 - 0.00427353896103912*G0_1_1_0_9 - 0.00234983766233775*G0_1_1_1_0 + 0.00164366883116887*G0_1_1_1_1 + 0.000487012987013004*G0_1_1_1_2 + 0.00246550324675332*G0_1_1_1_3 - 0.00098620129870132*G0_1_1_1_4 - 0.00410917207792223*G0_1_1_1_5 + 0.00213676948051956*G0_1_1_1_6 - 0.008875811688312*G0_1_1_1_7 + 0.00246550324675333*G0_1_1_1_8 - 0.00493100649350667*G0_1_1_1_9 - 0.00136972402597408*G0_1_1_2_0 + 0.000487012987013003*G0_1_1_2_1 + 0.00360389610389624*G0_1_1_2_2 - 0.00186282467532475*G0_1_1_2_3 + 0.00405438311688327*G0_1_1_2_4 - 0.00482142857142875*G0_1_1_2_5 + 0.0035612824675326*G0_1_1_2_6 - 0.00624594155844179*G0_1_1_2_7 + 0.00427353896103911*G0_1_1_2_8 + 0.000328733766233767*G0_1_1_2_9 + 0.00262987012987023*G0_1_1_3_0 + 0.00246550324675332*G0_1_1_3_1 - 0.00186282467532475*G0_1_1_3_2 + 0.0700202922077947*G0_1_1_3_3 - 0.00493100649350663*G0_1_1_3_4 - 0.00197240259740267*G0_1_1_3_6 - 0.00345170454545465*G0_1_1_3_7 + 0.011834415584416*G0_1_1_3_8 + 0.0216964285714293*G0_1_1_3_9 + 0.00279423701298713*G0_1_1_4_0 - 0.000986201298701319*G0_1_1_4_1 + 0.00405438311688327*G0_1_1_4_2 - 0.00493100649350663*G0_1_1_4_3 + 0.0739650974026*G0_1_1_4_4 - 0.00394480519480533*G0_1_1_4_5 + 0.00591720779220801*G0_1_1_4_6 + 0.00295860389610402*G0_1_1_4_7 - 0.00838271103896133*G0_1_1_4_8 + 0.00690340909090937*G0_1_1_4_9 - 0.013423295454546*G0_1_1_5_0 - 0.00410917207792223*G0_1_1_5_1 - 0.00482142857142875*G0_1_1_5_2 - 0.00394480519480533*G0_1_1_5_4 - 0.0364894480519494*G0_1_1_5_5 + 0.016272321428572*G0_1_1_5_6 - 0.039941152597404*G0_1_1_5_7 + 0.0167654220779227*G0_1_1_5_8 - 0.020710227272728*G0_1_1_5_9 + 0.00679383116883143*G0_1_1_6_0 + 0.00213676948051956*G0_1_1_6_1 + 0.0035612824675326*G0_1_1_6_2 - 0.00197240259740267*G0_1_1_6_3 + 0.00591720779220801*G0_1_1_6_4 + 0.016272321428572*G0_1_1_6_5 - 0.0108482142857147*G0_1_1_6_6 + 0.0231757305194813*G0_1_1_6_7 - 0.011834415584416*G0_1_1_6_8 + 0.00295860389610404*G0_1_1_6_9 - 0.028216314935066*G0_1_1_7_0 - 0.00887581168831201*G0_1_1_7_1 - 0.00624594155844178*G0_1_1_7_2 - 0.00345170454545465*G0_1_1_7_3 + 0.00295860389610402*G0_1_1_7_4 - 0.039941152597404*G0_1_1_7_5 + 0.0231757305194813*G0_1_1_7_6 - 0.130178571428576*G0_1_1_7_7 + 0.0374756493506508*G0_1_1_7_8 - 0.0335308441558454*G0_1_1_7_9 + 0.0117248376623381*G0_1_1_8_0 + 0.00246550324675333*G0_1_1_8_1 + 0.00427353896103911*G0_1_1_8_2 + 0.011834415584416*G0_1_1_8_3 - 0.00838271103896133*G0_1_1_8_4 + 0.0167654220779227*G0_1_1_8_5 - 0.011834415584416*G0_1_1_8_6 + 0.0374756493506508*G0_1_1_8_7 + 0.0246550324675333*G0_1_1_8_8 + 0.0315584415584427*G0_1_1_8_9 - 0.00427353896103912*G0_1_1_9_0 - 0.00493100649350667*G0_1_1_9_1 + 0.000328733766233767*G0_1_1_9_2 + 0.0216964285714293*G0_1_1_9_3 + 0.00690340909090937*G0_1_1_9_4 - 0.020710227272728*G0_1_1_9_5 + 0.00295860389610404*G0_1_1_9_6 - 0.0335308441558454*G0_1_1_9_7 + 0.0315584415584427*G0_1_1_9_8;
    A[89] = -A[19] - 0.0116274350649355*G0_0_0_0_0 - 0.0018689123376624*G0_0_0_0_2 + 0.00509537337662358*G0_0_0_0_3 + 0.000821834415584454*G0_0_0_0_4 - 0.0176420454545461*G0_0_0_0_5 + 0.0104646915584419*G0_0_0_0_6 - 0.00728693181818208*G0_0_0_0_7 + 0.0035612824675326*G0_0_0_0_8 - 0.00361607142857156*G0_0_0_0_9 + 0.0116274350649354*G0_0_0_1_1 + 0.0018689123376624*G0_0_0_1_2 + 0.017642045454546*G0_0_0_1_3 - 0.0104646915584419*G0_0_0_1_4 - 0.00509537337662355*G0_0_0_1_5 - 0.000821834415584453*G0_0_0_1_6 - 0.00356128246753259*G0_0_0_1_7 + 0.00728693181818207*G0_0_0_1_8 + 0.00361607142857156*G0_0_0_1_9 - 0.0018689123376624*G0_0_0_2_0 + 0.0018689123376624*G0_0_0_2_1 + 0.00295860389610398*G0_0_0_2_3 - 0.00493100649350666*G0_0_0_2_4 - 0.002958603896104*G0_0_0_2_5 + 0.00493100649350665*G0_0_0_2_6 + 0.00016436688311689*G0_0_0_2_7 - 0.000164366883116884*G0_0_0_2_8 + 0.00509537337662358*G0_0_0_3_0 + 0.017642045454546*G0_0_0_3_1 + 0.00295860389610398*G0_0_0_3_2 + 0.150888798701304*G0_0_0_3_3 - 0.00542410714285725*G0_0_0_3_4 + 0.00246550324675334*G0_0_0_3_6 - 0.0152861201298707*G0_0_0_3_7 + 0.01479301948052*G0_0_0_3_8 + 0.0197240259740267*G0_0_0_3_9 + 0.000821834415584454*G0_0_0_4_0 - 0.0104646915584419*G0_0_0_4_1 - 0.00493100649350666*G0_0_0_4_2 - 0.00542410714285724*G0_0_0_4_3 + 0.0305722402597414*G0_0_0_4_4 - 0.00246550324675333*G0_0_0_4_5 - 0.00147930194805201*G0_0_0_4_7 + 0.000493100649350649*G0_0_0_4_8 + 0.00493100649350669*G0_0_0_4_9 - 0.0176420454545461*G0_0_0_5_0 - 0.00509537337662355*G0_0_0_5_1 - 0.002958603896104*G0_0_0_5_2 - 0.00246550324675333*G0_0_0_5_4 - 0.150888798701304*G0_0_0_5_5 + 0.00542410714285731*G0_0_0_5_6 - 0.01479301948052*G0_0_0_5_7 + 0.0152861201298706*G0_0_0_5_8 - 0.0197240259740267*G0_0_0_5_9 + 0.0104646915584419*G0_0_0_6_0 - 0.000821834415584452*G0_0_0_6_1 + 0.00493100649350665*G0_0_0_6_2 + 0.00246550324675334*G0_0_0_6_3 + 0.00542410714285732*G0_0_0_6_5 - 0.0305722402597414*G0_0_0_6_6 - 0.000493100649350676*G0_0_0_6_7 + 0.001479301948052*G0_0_0_6_8 - 0.00493100649350669*G0_0_0_6_9 - 0.00728693181818208*G0_0_0_7_0 - 0.00356128246753259*G0_0_0_7_1 + 0.00016436688311689*G0_0_0_7_2 - 0.0152861201298707*G0_0_0_7_3 - 0.00147930194805201*G0_0_0_7_4 - 0.01479301948052*G0_0_0_7_5 - 0.000493100649350677*G0_0_0_7_6 + 0.0128206168831174*G0_0_0_7_7 + 0.011834415584416*G0_0_0_7_9 + 0.0035612824675326*G0_0_0_8_0 + 0.00728693181818206*G0_0_0_8_1 - 0.000164366883116883*G0_0_0_8_2 + 0.01479301948052*G0_0_0_8_3 + 0.000493100649350649*G0_0_0_8_4 + 0.0152861201298706*G0_0_0_8_5 + 0.001479301948052*G0_0_0_8_6 - 0.0128206168831173*G0_0_0_8_8 - 0.011834415584416*G0_0_0_8_9 - 0.00361607142857156*G0_0_0_9_0 + 0.00361607142857156*G0_0_0_9_1 + 0.0197240259740267*G0_0_0_9_3 + 0.00493100649350669*G0_0_0_9_4 - 0.0197240259740267*G0_0_0_9_5 - 0.00493100649350669*G0_0_0_9_6 + 0.011834415584416*G0_0_0_9_7 - 0.011834415584416*G0_0_0_9_8 - 0.00505275974025996*G0_0_1_0_0 + 0.000432224025974036*G0_0_1_0_1 - 0.00169845779220785*G0_0_1_0_2 + 0.0047666396103898*G0_0_1_0_3 + 0.0016436688311689*G0_0_1_0_4 - 0.00778003246753276*G0_0_1_0_5 + 0.00454748376623393*G0_0_1_0_6 - 0.0171489448051954*G0_0_1_0_7 - 0.00235592532467537*G0_0_1_0_8 - 0.0115056818181822*G0_0_1_0_9 + 0.000432224025974036*G0_0_1_1_0 + 0.00657467532467548*G0_0_1_1_1 + 0.000170454545454547*G0_0_1_1_2 + 0.00986201298701329*G0_0_1_1_3 - 0.00591720779220798*G0_0_1_1_4 - 0.000328733766233774*G0_0_1_1_5 + 0.000821834415584439*G0_0_1_1_6 - 0.00591720779220798*G0_0_1_1_7 - 0.00986201298701335*G0_0_1_1_8 - 0.00788961038961064*G0_0_1_1_9 - 0.00169845779220785*G0_0_1_2_0 + 0.000170454545454548*G0_0_1_2_1 - 0.000645292207792236*G0_0_1_2_2 + 0.00580762987013005*G0_0_1_2_3 - 0.0104646915584419*G0_0_1_2_4 + 0.00284902597402607*G0_0_1_2_5 - 0.00553368506493526*G0_0_1_2_6 + 0.0106838474025978*G0_0_1_2_7 + 0.0105194805194809*G0_0_1_2_8 + 0.0164366883116889*G0_0_1_2_9 + 0.0047666396103898*G0_0_1_3_0 + 0.00986201298701328*G0_0_1_3_1 + 0.00580762987013005*G0_0_1_3_2 + 0.144478490259745*G0_0_1_3_3 - 0.00690340909090923*G0_0_1_3_4 - 0.00739650974025999*G0_0_1_3_5 - 0.000986201298701329*G0_0_1_3_6 - 0.0128206168831174*G0_0_1_3_7 + 0.0428997564935079*G0_0_1_3_8 + 0.0493100649350666*G0_0_1_3_9 + 0.0016436688311689*G0_0_1_4_0 - 0.00591720779220798*G0_0_1_4_1 - 0.0104646915584419*G0_0_1_4_2 - 0.00690340909090922*G0_0_1_4_3 + 0.0340239448051961*G0_0_1_4_4 - 0.00345170454545469*G0_0_1_4_5 + 0.00443790584415603*G0_0_1_4_6 - 0.019230925324676*G0_0_1_4_7 - 0.0300791396103906*G0_0_1_4_8 - 0.0424066558441572*G0_0_1_4_9 - 0.00778003246753276*G0_0_1_5_0 - 0.000328733766233774*G0_0_1_5_1 + 0.00284902597402607*G0_0_1_5_2 - 0.00739650974025999*G0_0_1_5_3 - 0.00345170454545469*G0_0_1_5_4 - 0.00641030844155867*G0_0_1_5_5 - 0.001479301948052*G0_0_1_5_6 + 0.028106737012988*G0_0_1_5_7 + 0.00246550324675331*G0_0_1_5_8 + 0.02958603896104*G0_0_1_5_9 + 0.00454748376623393*G0_0_1_6_0 + 0.000821834415584439*G0_0_1_6_1 - 0.00553368506493526*G0_0_1_6_2 - 0.00098620129870133*G0_0_1_6_3 + 0.00443790584415603*G0_0_1_6_4 - 0.00147930194805199*G0_0_1_6_5 + 0.00345170454545468*G0_0_1_6_6 - 0.0305722402597414*G0_0_1_6_7 - 0.017751623376624*G0_0_1_6_8 - 0.047337662337664*G0_0_1_6_9 - 0.0171489448051954*G0_0_1_7_0 - 0.00591720779220798*G0_0_1_7_1 + 0.0106838474025978*G0_0_1_7_2 - 0.0128206168831174*G0_0_1_7_3 - 0.019230925324676*G0_0_1_7_4 + 0.028106737012988*G0_0_1_7_5 - 0.0305722402597414*G0_0_1_7_6 + 0.211540178571436*G0_0_1_7_7 + 0.0350101461038973*G0_0_1_7_8 + 0.0956615259740295*G0_0_1_7_9 - 0.00235592532467537*G0_0_1_8_0 - 0.00986201298701335*G0_0_1_8_1 + 0.0105194805194809*G0_0_1_8_2 + 0.0428997564935079*G0_0_1_8_3 - 0.0300791396103906*G0_0_1_8_4 + 0.00246550324675331*G0_0_1_8_5 - 0.017751623376624*G0_0_1_8_6 + 0.0350101461038973*G0_0_1_8_7 + 0.198719561688319*G0_0_1_8_8 + 0.0838271103896133*G0_0_1_8_9 - 0.0115056818181822*G0_0_1_9_0 - 0.00788961038961064*G0_0_1_9_1 + 0.0164366883116889*G0_0_1_9_2 + 0.0493100649350666*G0_0_1_9_3 - 0.0424066558441572*G0_0_1_9_4 + 0.02958603896104*G0_0_1_9_5 - 0.047337662337664*G0_0_1_9_6 + 0.0956615259740295*G0_0_1_9_7 + 0.0838271103896133*G0_0_1_9_8 + 0.159764610389616*G0_0_1_9_9 + 0.00284902597402608*G0_1_0_0_0 + 0.00241071428571438*G0_1_0_0_1 + 0.00131493506493511*G0_1_0_0_2 + 0.0207102272727281*G0_1_0_0_3 - 0.00493100649350667*G0_1_0_0_4 - 0.00197240259740267*G0_1_0_0_5 - 0.001479301948052*G0_1_0_0_6 - 0.00591720779220802*G0_1_0_0_7 + 0.0113413149350654*G0_1_0_0_8 + 0.011834415584416*G0_1_0_0_9 + 0.00241071428571438*G0_1_0_1_0 + 0.0361607142857154*G0_1_0_1_1 + 0.00487621753246769*G0_1_0_1_2 + 0.0468445616883133*G0_1_0_1_3 - 0.0246550324675333*G0_1_0_1_4 + 0.00197240259740267*G0_1_0_1_5 - 0.000493100649350674*G0_1_0_1_6 - 0.00986201298701334*G0_1_0_1_7 + 0.02218952922078*G0_1_0_1_8 + 0.00493100649350671*G0_1_0_1_9 + 0.00131493506493511*G0_1_0_2_0 + 0.00487621753246769*G0_1_0_2_1 + 0.00164366883116888*G0_1_0_2_2 + 0.017751623376624*G0_1_0_2_3 - 0.0123275162337667*G0_1_0_2_4 - 0.00246550324675336*G0_1_0_2_6 - 0.00394480519480533*G0_1_0_2_7 + 0.010355113636364*G0_1_0_2_8 + 0.00690340909090933*G0_1_0_2_9 + 0.0207102272727281*G0_1_0_3_0 + 0.0468445616883133*G0_1_0_3_1 + 0.017751623376624*G0_1_0_3_2 + 0.386097808441572*G0_1_0_3_3 - 0.0665685876623399*G0_1_0_3_4 - 0.028106737012988*G0_1_0_3_5 - 0.010355113636364*G0_1_0_3_6 - 0.0739650974026001*G0_1_0_3_7 + 0.116864853896108*G0_1_0_3_8 + 0.13313717532468*G0_1_0_3_9 - 0.00493100649350667*G0_1_0_4_0 - 0.0246550324675333*G0_1_0_4_1 - 0.0123275162337667*G0_1_0_4_2 - 0.0665685876623399*G0_1_0_4_3 + 0.0399411525974039*G0_1_0_4_4 + 0.002958603896104*G0_1_0_4_5 + 0.00739650974025997*G0_1_0_4_6 + 0.019230925324676*G0_1_0_4_7 - 0.042899756493508*G0_1_0_4_8 - 0.026627435064936*G0_1_0_4_9 - 0.00197240259740267*G0_1_0_5_0 + 0.00197240259740267*G0_1_0_5_1 - 0.028106737012988*G0_1_0_5_3 + 0.002958603896104*G0_1_0_5_4 + 0.0281067370129881*G0_1_0_5_5 - 0.00295860389610396*G0_1_0_5_6 + 0.017751623376624*G0_1_0_5_7 - 0.017751623376624*G0_1_0_5_8 - 0.001479301948052*G0_1_0_6_0 - 0.000493100649350674*G0_1_0_6_1 - 0.00246550324675336*G0_1_0_6_2 - 0.010355113636364*G0_1_0_6_3 + 0.00739650974025997*G0_1_0_6_4 - 0.00295860389610396*G0_1_0_6_5 + 0.0192309253246759*G0_1_0_6_6 - 0.00887581168831199*G0_1_0_6_8 - 0.00591720779220802*G0_1_0_7_0 - 0.00986201298701334*G0_1_0_7_1 - 0.00394480519480533*G0_1_0_7_2 - 0.0739650974026001*G0_1_0_7_3 + 0.019230925324676*G0_1_0_7_4 + 0.017751623376624*G0_1_0_7_5 + 0.034023944805196*G0_1_0_7_7 - 0.050296266233768*G0_1_0_7_8 - 0.035503246753248*G0_1_0_7_9 + 0.0113413149350653*G0_1_0_8_0 + 0.02218952922078*G0_1_0_8_1 + 0.010355113636364*G0_1_0_8_2 + 0.116864853896108*G0_1_0_8_3 - 0.042899756493508*G0_1_0_8_4 - 0.017751623376624*G0_1_0_8_5 - 0.00887581168831199*G0_1_0_8_6 - 0.050296266233768*G0_1_0_8_7 + 0.105030438311692*G0_1_0_8_8 + 0.071006493506496*G0_1_0_8_9 + 0.011834415584416*G0_1_0_9_0 + 0.00493100649350671*G0_1_0_9_1 + 0.00690340909090933*G0_1_0_9_2 + 0.13313717532468*G0_1_0_9_3 - 0.026627435064936*G0_1_0_9_4 - 0.035503246753248*G0_1_0_9_7 + 0.071006493506496*G0_1_0_9_8 + 0.159764610389616*G0_1_0_9_9 + 0.00120535714285718*G0_1_1_0_0 - 0.00246550324675335*G0_1_1_0_1 + 0.010355113636364*G0_1_1_0_3 - 0.000986201298701336*G0_1_1_0_4 + 0.000493100649350662*G0_1_1_0_5 - 0.001479301948052*G0_1_1_0_6 + 0.00641030844155865*G0_1_1_0_7 - 0.00641030844155869*G0_1_1_0_8 + 0.00493100649350667*G0_1_1_0_9 - 0.00246550324675335*G0_1_1_1_0 + 0.00246550324675332*G0_1_1_1_2 + 0.0246550324675332*G0_1_1_1_3 - 0.0147930194805199*G0_1_1_1_4 + 0.00246550324675333*G0_1_1_1_5 - 0.00246550324675334*G0_1_1_1_6 + 0.0147930194805201*G0_1_1_1_7 - 0.0246550324675335*G0_1_1_1_8 + 0.00246550324675332*G0_1_1_2_1 - 0.00120535714285718*G0_1_1_2_2 + 0.00641030844155864*G0_1_1_2_3 - 0.00641030844155866*G0_1_1_2_4 + 0.001479301948052*G0_1_1_2_5 - 0.000493100649350665*G0_1_1_2_6 + 0.000986201298701326*G0_1_1_2_7 - 0.010355113636364*G0_1_1_2_8 - 0.00493100649350666*G0_1_1_2_9 + 0.010355113636364*G0_1_1_3_0 + 0.0246550324675332*G0_1_1_3_1 + 0.00641030844155864*G0_1_1_3_2 + 0.28106737012988*G0_1_1_3_3 - 0.0162723214285719*G0_1_1_3_4 - 0.019230925324676*G0_1_1_3_5 + 0.00739650974025997*G0_1_1_3_6 - 0.031065340909092*G0_1_1_3_7 + 0.0621306818181841*G0_1_1_3_9 - 0.000986201298701336*G0_1_1_4_0 - 0.0147930194805199*G0_1_1_4_1 - 0.00641030844155866*G0_1_1_4_2 - 0.0162723214285719*G0_1_1_4_3 + 0.00591720779220792*G0_1_1_4_4 + 0.002958603896104*G0_1_1_4_5 - 0.010355113636364*G0_1_1_4_6 + 0.0310653409090919*G0_1_1_4_8 + 0.00887581168831196*G0_1_1_4_9 + 0.000493100649350662*G0_1_1_5_0 + 0.00246550324675333*G0_1_1_5_1 + 0.001479301948052*G0_1_1_5_2 - 0.019230925324676*G0_1_1_5_3 + 0.002958603896104*G0_1_1_5_4 + 0.008875811688312*G0_1_1_5_5 + 0.010355113636364*G0_1_1_5_7 - 0.00739650974025999*G0_1_1_5_8 - 0.001479301948052*G0_1_1_6_0 - 0.00246550324675334*G0_1_1_6_1 - 0.000493100649350665*G0_1_1_6_2 + 0.00739650974025997*G0_1_1_6_3 - 0.010355113636364*G0_1_1_6_4 - 0.00887581168831198*G0_1_1_6_6 - 0.00295860389610398*G0_1_1_6_7 + 0.019230925324676*G0_1_1_6_8 + 0.00641030844155865*G0_1_1_7_0 + 0.0147930194805201*G0_1_1_7_1 + 0.000986201298701326*G0_1_1_7_2 - 0.031065340909092*G0_1_1_7_3 + 0.010355113636364*G0_1_1_7_5 - 0.00295860389610398*G0_1_1_7_6 - 0.00591720779220814*G0_1_1_7_7 + 0.016272321428572*G0_1_1_7_8 - 0.00887581168831205*G0_1_1_7_9 - 0.00641030844155869*G0_1_1_8_0 - 0.0246550324675335*G0_1_1_8_1 - 0.010355113636364*G0_1_1_8_2 + 0.0310653409090919*G0_1_1_8_4 - 0.00739650974025999*G0_1_1_8_5 + 0.019230925324676*G0_1_1_8_6 + 0.016272321428572*G0_1_1_8_7 - 0.28106737012988*G0_1_1_8_8 - 0.0621306818181839*G0_1_1_8_9 + 0.00493100649350667*G0_1_1_9_0 - 0.00493100649350666*G0_1_1_9_2 + 0.0621306818181841*G0_1_1_9_3 + 0.00887581168831196*G0_1_1_9_4 - 0.00887581168831205*G0_1_1_9_7 - 0.0621306818181839*G0_1_1_9_8;
    A[98] = A[89] + 0.00986201298701339*G0_0_1_0_0 + 0.00295860389610402*G0_0_1_0_1 + 0.00301339285714296*G0_0_1_0_2 + 0.0138068181818187*G0_0_1_0_3 - 0.00443790584415601*G0_0_1_0_4 + 0.00739650974026002*G0_0_1_0_5 - 0.00690340909090935*G0_0_1_0_6 + 0.0123275162337667*G0_0_1_0_7 + 0.017751623376624*G0_0_1_0_8 + 0.0285998376623387*G0_0_1_0_9 + 0.00295860389610402*G0_0_1_1_0 + 0.02958603896104*G0_0_1_1_1 + 0.00372564935064948*G0_0_1_1_2 + 0.0221895292207801*G0_0_1_1_3 - 0.0138068181818187*G0_0_1_1_4 + 0.00246550324675333*G0_0_1_1_5 - 0.001479301948052*G0_0_1_1_6 - 0.00887581168831206*G0_0_1_1_7 + 0.0468445616883134*G0_0_1_1_8 + 0.0128206168831174*G0_0_1_1_9 + 0.00301339285714296*G0_0_1_2_0 + 0.00372564935064948*G0_0_1_2_1 + 0.000328733766233755*G0_0_1_2_2 + 0.00788961038961068*G0_0_1_2_3 - 0.002958603896104*G0_0_1_2_4 - 0.00197240259740265*G0_0_1_2_5 + 0.00147930194805197*G0_0_1_2_6 - 0.0167654220779227*G0_0_1_2_7 + 0.00197240259740267*G0_0_1_2_8 - 0.01479301948052*G0_0_1_2_9 + 0.0138068181818187*G0_0_1_3_0 + 0.0221895292207801*G0_0_1_3_1 + 0.00788961038961068*G0_0_1_3_2 + 0.1479301948052*G0_0_1_3_3 - 0.038461850649352*G0_0_1_3_4 - 0.017751623376624*G0_0_1_3_5 - 0.00887581168831198*G0_0_1_3_6 - 0.054734172077924*G0_0_1_3_7 + 0.0739650974026001*G0_0_1_3_8 + 0.0710064935064962*G0_0_1_3_9 - 0.00443790584415601*G0_0_1_4_0 - 0.0138068181818187*G0_0_1_4_1 - 0.00295860389610401*G0_0_1_4_2 - 0.038461850649352*G0_0_1_4_3 + 0.0414204545454558*G0_0_1_4_4 + 0.00887581168831192*G0_0_1_4_6 + 0.038461850649352*G0_0_1_4_7 - 0.019230925324676*G0_0_1_4_8 + 0.0443790584415599*G0_0_1_4_9 + 0.00739650974026002*G0_0_1_5_0 + 0.00246550324675333*G0_0_1_5_1 - 0.00197240259740265*G0_0_1_5_2 - 0.017751623376624*G0_0_1_5_3 + 0.0384618506493521*G0_0_1_5_5 - 0.00147930194805196*G0_0_1_5_6 - 0.016272321428572*G0_0_1_5_7 - 0.020710227272728*G0_0_1_5_8 - 0.0443790584415599*G0_0_1_5_9 - 0.00690340909090935*G0_0_1_6_0 - 0.001479301948052*G0_0_1_6_1 + 0.00147930194805197*G0_0_1_6_2 - 0.00887581168831198*G0_0_1_6_3 + 0.00887581168831192*G0_0_1_6_4 - 0.00147930194805196*G0_0_1_6_5 + 0.0118344155844158*G0_0_1_6_6 + 0.0369825487013*G0_0_1_6_7 + 0.00591720779220798*G0_0_1_6_8 + 0.0621306818181839*G0_0_1_6_9 + 0.0123275162337666*G0_0_1_7_0 - 0.00887581168831206*G0_0_1_7_1 - 0.0167654220779227*G0_0_1_7_2 - 0.054734172077924*G0_0_1_7_3 + 0.038461850649352*G0_0_1_7_4 - 0.016272321428572*G0_0_1_7_5 + 0.0369825487013*G0_0_1_7_6 - 0.213019480519489*G0_0_1_7_7 - 0.106509740259744*G0_0_1_7_8 - 0.159764610389616*G0_0_1_7_9 + 0.017751623376624*G0_0_1_8_0 + 0.0468445616883134*G0_0_1_8_1 + 0.00197240259740267*G0_0_1_8_2 + 0.0739650974026001*G0_0_1_8_3 - 0.019230925324676*G0_0_1_8_4 - 0.020710227272728*G0_0_1_8_5 + 0.00591720779220799*G0_0_1_8_6 - 0.106509740259744*G0_0_1_8_7 + 0.0285998376623387*G0_0_1_9_0 + 0.0128206168831174*G0_0_1_9_1 - 0.01479301948052*G0_0_1_9_2 + 0.0710064935064962*G0_0_1_9_3 + 0.0443790584415599*G0_0_1_9_4 - 0.0443790584415599*G0_0_1_9_5 + 0.0621306818181839*G0_0_1_9_6 - 0.159764610389616*G0_0_1_9_7 - 0.00986201298701339*G0_1_0_0_0 - 0.00295860389610402*G0_1_0_0_1 - 0.00301339285714296*G0_1_0_0_2 - 0.0138068181818187*G0_1_0_0_3 + 0.00443790584415601*G0_1_0_0_4 - 0.00739650974026002*G0_1_0_0_5 + 0.00690340909090935*G0_1_0_0_6 - 0.0123275162337667*G0_1_0_0_7 - 0.017751623376624*G0_1_0_0_8 - 0.0285998376623387*G0_1_0_0_9 - 0.00295860389610402*G0_1_0_1_0 - 0.02958603896104*G0_1_0_1_1 - 0.00372564935064948*G0_1_0_1_2 - 0.0221895292207801*G0_1_0_1_3 + 0.0138068181818187*G0_1_0_1_4 - 0.00246550324675333*G0_1_0_1_5 + 0.001479301948052*G0_1_0_1_6 + 0.00887581168831206*G0_1_0_1_7 - 0.0468445616883134*G0_1_0_1_8 - 0.0128206168831174*G0_1_0_1_9 - 0.00301339285714296*G0_1_0_2_0 - 0.00372564935064948*G0_1_0_2_1 - 0.000328733766233755*G0_1_0_2_2 - 0.00788961038961068*G0_1_0_2_3 + 0.00295860389610401*G0_1_0_2_4 + 0.00197240259740265*G0_1_0_2_5 - 0.00147930194805197*G0_1_0_2_6 + 0.0167654220779227*G0_1_0_2_7 - 0.00197240259740267*G0_1_0_2_8 + 0.01479301948052*G0_1_0_2_9 - 0.0138068181818187*G0_1_0_3_0 - 0.0221895292207801*G0_1_0_3_1 - 0.00788961038961068*G0_1_0_3_2 - 0.1479301948052*G0_1_0_3_3 + 0.038461850649352*G0_1_0_3_4 + 0.017751623376624*G0_1_0_3_5 + 0.00887581168831198*G0_1_0_3_6 + 0.054734172077924*G0_1_0_3_7 - 0.0739650974026001*G0_1_0_3_8 - 0.0710064935064962*G0_1_0_3_9 + 0.00443790584415601*G0_1_0_4_0 + 0.0138068181818187*G0_1_0_4_1 + 0.00295860389610401*G0_1_0_4_2 + 0.038461850649352*G0_1_0_4_3 - 0.0414204545454558*G0_1_0_4_4 - 0.00887581168831193*G0_1_0_4_6 - 0.038461850649352*G0_1_0_4_7 + 0.019230925324676*G0_1_0_4_8 - 0.0443790584415599*G0_1_0_4_9 - 0.00739650974026002*G0_1_0_5_0 - 0.00246550324675333*G0_1_0_5_1 + 0.00197240259740265*G0_1_0_5_2 + 0.017751623376624*G0_1_0_5_3 - 0.0384618506493521*G0_1_0_5_5 + 0.00147930194805196*G0_1_0_5_6 + 0.016272321428572*G0_1_0_5_7 + 0.020710227272728*G0_1_0_5_8 + 0.0443790584415599*G0_1_0_5_9 + 0.00690340909090935*G0_1_0_6_0 + 0.001479301948052*G0_1_0_6_1 - 0.00147930194805197*G0_1_0_6_2 + 0.00887581168831198*G0_1_0_6_3 - 0.00887581168831193*G0_1_0_6_4 + 0.00147930194805196*G0_1_0_6_5 - 0.0118344155844158*G0_1_0_6_6 - 0.0369825487013*G0_1_0_6_7 - 0.00591720779220798*G0_1_0_6_8 - 0.0621306818181839*G0_1_0_6_9 - 0.0123275162337666*G0_1_0_7_0 + 0.00887581168831207*G0_1_0_7_1 + 0.0167654220779227*G0_1_0_7_2 + 0.054734172077924*G0_1_0_7_3 - 0.0384618506493521*G0_1_0_7_4 + 0.016272321428572*G0_1_0_7_5 - 0.0369825487013*G0_1_0_7_6 + 0.213019480519489*G0_1_0_7_7 + 0.106509740259744*G0_1_0_7_8 + 0.159764610389616*G0_1_0_7_9 - 0.017751623376624*G0_1_0_8_0 - 0.0468445616883134*G0_1_0_8_1 - 0.00197240259740267*G0_1_0_8_2 - 0.0739650974026001*G0_1_0_8_3 + 0.019230925324676*G0_1_0_8_4 + 0.020710227272728*G0_1_0_8_5 - 0.00591720779220799*G0_1_0_8_6 + 0.106509740259744*G0_1_0_8_7 - 0.0285998376623387*G0_1_0_9_0 - 0.0128206168831174*G0_1_0_9_1 + 0.01479301948052*G0_1_0_9_2 - 0.0710064935064962*G0_1_0_9_3 - 0.0443790584415599*G0_1_0_9_4 + 0.0443790584415599*G0_1_0_9_5 - 0.0621306818181839*G0_1_0_9_6 + 0.159764610389616*G0_1_0_9_7;
    A[93] = -A[98] - 0.0210389610389618*G0_0_0_0_0 + 0.00202719155844162*G0_0_0_0_1 - 0.00432832792207807*G0_0_0_0_2 - 0.0138068181818187*G0_0_0_0_3 - 0.013313717532468*G0_0_0_0_4 - 0.013313717532468*G0_0_0_0_5 + 0.00986201298701326*G0_0_0_0_6 - 0.00295860389610402*G0_0_0_0_7 - 0.000986201298701314*G0_0_0_0_8 - 0.032544642857144*G0_0_0_0_9 + 0.00202719155844163*G0_0_0_1_0 + 0.017532467532468*G0_0_0_1_1 + 0.00126014610389614*G0_0_0_1_2 + 0.0443790584415599*G0_0_0_1_3 - 0.0069034090909093*G0_0_0_1_4 - 0.0142999188311693*G0_0_0_1_5 - 0.010355113636364*G0_0_0_1_6 - 0.011834415584416*G0_0_0_1_7 + 0.0197240259740266*G0_0_0_1_8 + 0.0187378246753253*G0_0_0_1_9 - 0.00432832792207807*G0_0_0_2_0 + 0.00126014610389614*G0_0_0_2_1 - 0.0115056818181822*G0_0_0_2_2 + 0.008875811688312*G0_0_0_2_3 + 0.0123275162337667*G0_0_0_2_4 + 0.00493100649350663*G0_0_0_2_5 - 0.00739650974025999*G0_0_0_2_6 - 0.000986201298701338*G0_0_0_2_7 - 0.00197240259740265*G0_0_0_2_8 + 0.0108482142857146*G0_0_0_2_9 - 0.0138068181818187*G0_0_0_3_0 + 0.0443790584415599*G0_0_0_3_1 + 0.008875811688312*G0_0_0_3_2 - 0.186392045454552*G0_0_0_3_3 - 0.0488169642857161*G0_0_0_3_4 + 0.0414204545454559*G0_0_0_3_5 + 0.0325446428571439*G0_0_0_3_6 + 0.0428997564935079*G0_0_0_3_7 - 0.0502962662337679*G0_0_0_3_8 - 0.142012987012992*G0_0_0_3_9 - 0.013313717532468*G0_0_0_4_0 - 0.0069034090909093*G0_0_0_4_1 + 0.0123275162337667*G0_0_0_4_2 - 0.0488169642857161*G0_0_0_4_3 - 0.257398538961048*G0_0_0_4_4 + 0.041420454545456*G0_0_0_4_5 - 0.0739650974025999*G0_0_0_4_6 + 0.020710227272728*G0_0_0_4_7 + 0.00739650974025997*G0_0_0_4_8 - 0.115385551948056*G0_0_0_4_9 - 0.013313717532468*G0_0_0_5_0 - 0.0142999188311693*G0_0_0_5_1 + 0.00493100649350663*G0_0_0_5_2 + 0.0414204545454559*G0_0_0_5_3 + 0.041420454545456*G0_0_0_5_4 - 0.360949675324687*G0_0_0_5_5 + 0.025148133116884*G0_0_0_5_6 - 0.0488169642857159*G0_0_0_5_7 + 0.0443790584415599*G0_0_0_5_8 + 0.00887581168831187*G0_0_0_5_9 + 0.00986201298701327*G0_0_0_6_0 - 0.010355113636364*G0_0_0_6_1 - 0.00739650974025999*G0_0_0_6_2 + 0.0325446428571439*G0_0_0_6_3 - 0.0739650974025999*G0_0_0_6_4 + 0.025148133116884*G0_0_0_6_5 - 0.334322240259752*G0_0_0_6_6 + 0.00443790584415596*G0_0_0_6_7 + 0.0177516233766239*G0_0_0_6_8 - 0.0976339285714318*G0_0_0_6_9 - 0.00295860389610402*G0_0_0_7_0 - 0.011834415584416*G0_0_0_7_1 - 0.000986201298701337*G0_0_0_7_2 + 0.0428997564935079*G0_0_0_7_3 + 0.020710227272728*G0_0_0_7_4 - 0.0488169642857159*G0_0_0_7_5 + 0.00443790584415596*G0_0_0_7_6 - 0.00295860389610393*G0_0_0_7_7 + 0.019230925324676*G0_0_0_7_8 + 0.0887581168831198*G0_0_0_7_9 - 0.000986201298701314*G0_0_0_8_0 + 0.0197240259740266*G0_0_0_8_1 - 0.00197240259740265*G0_0_0_8_2 - 0.0502962662337679*G0_0_0_8_3 + 0.00739650974025997*G0_0_0_8_4 + 0.0443790584415599*G0_0_0_8_5 + 0.0177516233766239*G0_0_0_8_6 + 0.0192309253246759*G0_0_0_8_7 - 0.0384618506493519*G0_0_0_8_8 - 0.0710064935064958*G0_0_0_8_9 - 0.032544642857144*G0_0_0_9_0 + 0.0187378246753253*G0_0_0_9_1 + 0.0108482142857146*G0_0_0_9_2 - 0.142012987012992*G0_0_0_9_3 - 0.115385551948056*G0_0_0_9_4 + 0.00887581168831187*G0_0_0_9_5 - 0.0976339285714318*G0_0_0_9_6 + 0.0887581168831198*G0_0_0_9_7 - 0.0710064935064958*G0_0_0_9_8 - 0.319529220779231*G0_0_0_9_9 - 0.00953327922077963*G0_1_0_0_0 + 0.000767045454545466*G0_1_0_0_1 - 0.011834415584416*G0_1_0_0_3 - 0.0123275162337667*G0_1_0_0_4 - 0.00591720779220804*G0_1_0_0_5 + 0.00493100649350669*G0_1_0_0_6 - 0.0152861201298707*G0_1_0_0_7 - 0.00986201298701331*G0_1_0_0_8 - 0.0433928571428587*G0_1_0_0_9 + 0.000767045454545466*G0_1_0_1_0 - 0.000767045454545481*G0_1_0_1_2 + 0.0246550324675332*G0_1_0_1_3 + 0.0049310064935067*G0_1_0_1_4 - 0.00394480519480532*G0_1_0_1_5 + 0.00394480519480534*G0_1_0_1_6 - 0.0049310064935066*G0_1_0_1_7 - 0.0246550324675334*G0_1_0_1_8 - 0.000767045454545481*G0_1_0_2_1 + 0.00953327922077962*G0_1_0_2_2 + 0.00986201298701331*G0_1_0_2_3 + 0.0152861201298707*G0_1_0_2_4 - 0.00493100649350669*G0_1_0_2_5 + 0.00591720779220805*G0_1_0_2_6 + 0.0123275162337667*G0_1_0_2_7 + 0.011834415584416*G0_1_0_2_8 + 0.0433928571428586*G0_1_0_2_9 - 0.011834415584416*G0_1_0_3_0 + 0.0246550324675332*G0_1_0_3_1 + 0.0098620129870133*G0_1_0_3_2 - 0.1479301948052*G0_1_0_3_3 - 0.0680478896103921*G0_1_0_3_4 + 0.023668831168832*G0_1_0_3_5 - 0.011834415584416*G0_1_0_3_6 + 0.0355032467532479*G0_1_0_3_7 - 0.0710064935064961*G0_1_0_3_9 - 0.0123275162337667*G0_1_0_4_0 + 0.0049310064935067*G0_1_0_4_1 + 0.0152861201298707*G0_1_0_4_2 - 0.0680478896103921*G0_1_0_4_3 - 0.254439935064944*G0_1_0_4_4 + 0.0369825487012999*G0_1_0_4_5 - 0.0251481331168839*G0_1_0_4_6 - 0.035503246753248*G0_1_0_4_8 - 0.204143668831176*G0_1_0_4_9 - 0.00591720779220804*G0_1_0_5_0 - 0.00394480519480532*G0_1_0_5_1 - 0.0049310064935067*G0_1_0_5_2 + 0.023668831168832*G0_1_0_5_3 + 0.0369825487012999*G0_1_0_5_4 - 0.026627435064936*G0_1_0_5_5 + 0.025148133116884*G0_1_0_5_7 + 0.011834415584416*G0_1_0_5_8 + 0.106509740259744*G0_1_0_5_9 + 0.00493100649350669*G0_1_0_6_0 + 0.00394480519480534*G0_1_0_6_1 + 0.00591720779220805*G0_1_0_6_2 - 0.011834415584416*G0_1_0_6_3 - 0.0251481331168839*G0_1_0_6_4 + 0.0266274350649362*G0_1_0_6_6 - 0.0369825487013*G0_1_0_6_7 - 0.023668831168832*G0_1_0_6_8 - 0.106509740259744*G0_1_0_6_9 - 0.0152861201298707*G0_1_0_7_0 - 0.0049310064935066*G0_1_0_7_1 + 0.0123275162337667*G0_1_0_7_2 + 0.0355032467532479*G0_1_0_7_3 + 0.025148133116884*G0_1_0_7_5 - 0.0369825487013*G0_1_0_7_6 + 0.254439935064945*G0_1_0_7_7 + 0.068047889610392*G0_1_0_7_8 + 0.204143668831176*G0_1_0_7_9 - 0.0098620129870133*G0_1_0_8_0 - 0.0246550324675334*G0_1_0_8_1 + 0.011834415584416*G0_1_0_8_2 - 0.0355032467532479*G0_1_0_8_4 + 0.011834415584416*G0_1_0_8_5 - 0.023668831168832*G0_1_0_8_6 + 0.068047889610392*G0_1_0_8_7 + 0.1479301948052*G0_1_0_8_8 + 0.0710064935064959*G0_1_0_8_9 - 0.0433928571428587*G0_1_0_9_0 + 0.0433928571428586*G0_1_0_9_2 - 0.0710064935064961*G0_1_0_9_3 - 0.204143668831176*G0_1_0_9_4 + 0.106509740259744*G0_1_0_9_5 - 0.106509740259744*G0_1_0_9_6 + 0.204143668831176*G0_1_0_9_7 + 0.0710064935064959*G0_1_0_9_8;
    A[97] = A[98] + 0.0453652597402614*G0_0_0_0_0 + 0.00657467532467555*G0_0_0_0_2 - 0.0192309253246761*G0_0_0_0_3 + 0.0675547889610413*G0_0_0_0_5 - 0.0345170454545466*G0_0_0_0_6 + 0.0315584415584427*G0_0_0_0_7 - 0.0187378246753254*G0_0_0_0_8 + 0.011834415584416*G0_0_0_0_9 - 0.0453652597402611*G0_0_0_1_1 - 0.00657467532467554*G0_0_0_1_2 - 0.0675547889610412*G0_0_0_1_3 + 0.0345170454545466*G0_0_0_1_4 + 0.019230925324676*G0_0_0_1_5 + 0.0187378246753253*G0_0_0_1_7 - 0.0315584415584427*G0_0_0_1_8 - 0.011834415584416*G0_0_0_1_9 + 0.00657467532467555*G0_0_0_2_0 - 0.00657467532467554*G0_0_0_2_1 - 0.0138068181818186*G0_0_0_2_3 + 0.00986201298701333*G0_0_0_2_4 + 0.0138068181818187*G0_0_0_2_5 - 0.0098620129870133*G0_0_0_2_6 + 0.005917207792208*G0_0_0_2_7 - 0.00591720779220801*G0_0_0_2_8 - 0.0192309253246761*G0_0_0_3_0 - 0.0675547889610412*G0_0_0_3_1 - 0.0138068181818186*G0_0_0_3_2 - 0.505921266233784*G0_0_0_3_3 + 0.0532548701298718*G0_0_0_3_4 + 0.0576927759740281*G0_0_0_3_7 - 0.0754443993506522*G0_0_0_3_8 - 0.0798823051948083*G0_0_0_3_9 + 0.0345170454545466*G0_0_0_4_1 + 0.00986201298701333*G0_0_0_4_2 + 0.0532548701298718*G0_0_0_4_3 - 0.106509740259744*G0_0_0_4_4 - 0.00887581168831201*G0_0_0_4_7 + 0.017751623376624*G0_0_0_4_8 + 0.0675547889610413*G0_0_0_5_0 + 0.019230925324676*G0_0_0_5_1 + 0.0138068181818187*G0_0_0_5_2 + 0.505921266233783*G0_0_0_5_5 - 0.0532548701298719*G0_0_0_5_6 + 0.0754443993506519*G0_0_0_5_7 - 0.0576927759740279*G0_0_0_5_8 + 0.079882305194808*G0_0_0_5_9 - 0.0345170454545466*G0_0_0_6_0 - 0.00986201298701331*G0_0_0_6_2 - 0.0532548701298719*G0_0_0_6_5 + 0.106509740259744*G0_0_0_6_6 - 0.017751623376624*G0_0_0_6_7 + 0.00887581168831202*G0_0_0_6_8 + 0.0315584415584427*G0_0_0_7_0 + 0.0187378246753253*G0_0_0_7_1 + 0.005917207792208*G0_0_0_7_2 + 0.0576927759740281*G0_0_0_7_3 - 0.00887581168831201*G0_0_0_7_4 + 0.0754443993506519*G0_0_0_7_5 - 0.017751623376624*G0_0_0_7_6 - 0.0187378246753254*G0_0_0_8_0 - 0.0315584415584427*G0_0_0_8_1 - 0.00591720779220801*G0_0_0_8_2 - 0.0754443993506522*G0_0_0_8_3 + 0.017751623376624*G0_0_0_8_4 - 0.0576927759740279*G0_0_0_8_5 + 0.00887581168831202*G0_0_0_8_6 + 0.011834415584416*G0_0_0_9_0 - 0.011834415584416*G0_0_0_9_1 - 0.0798823051948083*G0_0_0_9_3 + 0.079882305194808*G0_0_0_9_5 - 0.00887581168831201*G0_0_1_0_0 - 0.00345170454545468*G0_0_1_0_1 - 0.00197240259740266*G0_0_1_0_2 - 0.0305722402597414*G0_0_1_0_3 + 0.00197240259740267*G0_0_1_0_4 + 0.000986201298701329*G0_0_1_0_5 + 0.00394480519480533*G0_0_1_0_6 + 0.00443790584415602*G0_0_1_0_7 - 0.011834415584416*G0_0_1_0_8 - 0.00887581168831206*G0_0_1_0_9 - 0.00345170454545468*G0_0_1_1_0 - 0.0542410714285731*G0_0_1_1_1 - 0.0085470779220782*G0_0_1_1_2 - 0.0665685876623399*G0_0_1_1_3 + 0.0384618506493519*G0_0_1_1_4 - 0.0113413149350653*G0_0_1_1_5 + 0.00197240259740268*G0_0_1_1_6 + 0.00690340909090934*G0_0_1_1_7 - 0.0271205357142867*G0_0_1_1_8 - 0.0207102272727281*G0_0_1_1_9 - 0.00197240259740266*G0_0_1_2_0 - 0.0085470779220782*G0_0_1_2_1 - 0.00493100649350664*G0_0_1_2_2 - 0.0197240259740266*G0_0_1_2_3 + 0.0172585227272733*G0_0_1_2_4 - 0.00591720779220802*G0_0_1_2_5 + 0.00739650974026003*G0_0_1_2_6 - 0.00246550324675333*G0_0_1_2_7 - 0.00838271103896133*G0_0_1_2_8 - 0.00887581168831202*G0_0_1_2_9 - 0.0305722402597414*G0_0_1_3_0 - 0.0665685876623399*G0_0_1_3_1 - 0.0197240259740266*G0_0_1_3_2 - 0.639058441558464*G0_0_1_3_3 + 0.0798823051948078*G0_0_1_3_4 + 0.0532548701298719*G0_0_1_3_5 + 0.013313717532468*G0_0_1_3_6 + 0.1109476461039*G0_0_1_3_7 - 0.15532670454546*G0_0_1_3_8 - 0.159764610389616*G0_0_1_3_9 + 0.00197240259740267*G0_0_1_4_0 + 0.0384618506493519*G0_0_1_4_1 + 0.0172585227272733*G0_0_1_4_2 + 0.0798823051948077*G0_0_1_4_3 - 0.159764610389616*G0_0_1_4_4 + 0.013313717532468*G0_0_1_4_5 - 0.0266274350649359*G0_0_1_4_6 - 0.008875811688312*G0_0_1_4_7 + 0.04437905844156*G0_0_1_4_8 + 0.00098620129870133*G0_0_1_5_0 - 0.0113413149350653*G0_0_1_5_1 - 0.00591720779220802*G0_0_1_5_2 + 0.0532548701298719*G0_0_1_5_3 + 0.013313717532468*G0_0_1_5_4 - 0.13313717532468*G0_0_1_5_5 + 0.0266274350649359*G0_0_1_5_6 - 0.0798823051948079*G0_0_1_5_7 + 0.053254870129872*G0_0_1_5_8 - 0.079882305194808*G0_0_1_5_9 + 0.00394480519480533*G0_0_1_6_0 + 0.00197240259740268*G0_0_1_6_1 + 0.00739650974026003*G0_0_1_6_2 + 0.013313717532468*G0_0_1_6_3 - 0.0266274350649359*G0_0_1_6_4 + 0.0266274350649359*G0_0_1_6_5 - 0.0532548701298716*G0_0_1_6_6 + 0.026627435064936*G0_0_1_6_7 + 0.00443790584415602*G0_0_1_7_0 + 0.00690340909090934*G0_0_1_7_1 - 0.00246550324675333*G0_0_1_7_2 + 0.1109476461039*G0_0_1_7_3 - 0.008875811688312*G0_0_1_7_4 - 0.0798823051948079*G0_0_1_7_5 + 0.026627435064936*G0_0_1_7_6 - 0.115385551948056*G0_0_1_7_7 + 0.084320211038964*G0_0_1_7_8 - 0.026627435064936*G0_0_1_7_9 - 0.011834415584416*G0_0_1_8_0 - 0.0271205357142867*G0_0_1_8_1 - 0.00838271103896133*G0_0_1_8_2 - 0.15532670454546*G0_0_1_8_3 + 0.04437905844156*G0_0_1_8_4 + 0.053254870129872*G0_0_1_8_5 + 0.084320211038964*G0_0_1_8_7 - 0.115385551948056*G0_0_1_8_8 - 0.0266274350649361*G0_0_1_8_9 - 0.00887581168831206*G0_0_1_9_0 - 0.020710227272728*G0_0_1_9_1 - 0.00887581168831202*G0_0_1_9_2 - 0.159764610389616*G0_0_1_9_3 - 0.079882305194808*G0_0_1_9_5 - 0.026627435064936*G0_0_1_9_7 - 0.0266274350649361*G0_0_1_9_8 - 0.319529220779232*G0_0_1_9_9 + 0.0305722402597415*G0_1_0_0_0 + 0.00246550324675336*G0_1_0_0_1 + 0.00476663961038978*G0_1_0_0_2 - 0.0142999188311694*G0_1_0_0_3 - 0.00394480519480535*G0_1_0_0_4 + 0.0305722402597414*G0_1_0_0_5 - 0.0167654220779227*G0_1_0_0_6 + 0.0636099837662361*G0_1_0_0_7 - 0.0029586038961041*G0_1_0_0_8 + 0.032544642857144*G0_1_0_0_9 + 0.00246550324675336*G0_1_0_1_0 - 0.0147930194805197*G0_1_0_1_1 - 0.00180803571428576*G0_1_0_1_2 - 0.0369825487012998*G0_1_0_1_3 + 0.0177516233766239*G0_1_0_1_4 + 0.00493100649350666*G0_1_0_1_5 - 0.00394480519480532*G0_1_0_1_6 + 0.0157792207792213*G0_1_0_1_7 + 0.0320515422077934*G0_1_0_1_8 + 0.020710227272728*G0_1_0_1_9 + 0.00476663961038978*G0_1_0_2_0 - 0.00180803571428576*G0_1_0_2_1 - 0.00427353896103912*G0_1_0_2_2 - 0.0138068181818186*G0_1_0_2_3 + 0.0157792207792213*G0_1_0_2_4 + 0.00591720779220798*G0_1_0_2_6 - 0.0172585227272733*G0_1_0_2_7 - 0.0231757305194813*G0_1_0_2_8 - 0.038461850649352*G0_1_0_2_9 - 0.0142999188311694*G0_1_0_3_0 - 0.0369825487012998*G0_1_0_3_1 - 0.0138068181818186*G0_1_0_3_2 - 0.452666396103912*G0_1_0_3_3 + 0.0399411525974037*G0_1_0_3_4 + 0.017751623376624*G0_1_0_3_5 + 0.004437905844156*G0_1_0_3_6 + 0.0355032467532481*G0_1_0_3_7 - 0.0976339285714319*G0_1_0_3_8 - 0.13313717532468*G0_1_0_3_9 - 0.00394480519480535*G0_1_0_4_0 + 0.0177516233766239*G0_1_0_4_1 + 0.0157792207792213*G0_1_0_4_2 + 0.0399411525974037*G0_1_0_4_3 - 0.106509740259744*G0_1_0_4_4 + 0.00443790584415603*G0_1_0_4_5 - 0.00887581168831206*G0_1_0_4_6 + 0.0355032467532481*G0_1_0_4_7 + 0.062130681818184*G0_1_0_4_8 + 0.106509740259744*G0_1_0_4_9 + 0.0305722402597414*G0_1_0_5_0 + 0.00493100649350666*G0_1_0_5_1 + 0.017751623376624*G0_1_0_5_3 + 0.00443790584415603*G0_1_0_5_4 + 0.053254870129872*G0_1_0_5_5 - 0.013313717532468*G0_1_0_5_6 - 0.02218952922078*G0_1_0_5_7 - 0.02218952922078*G0_1_0_5_8 - 0.0532548701298719*G0_1_0_5_9 - 0.0167654220779227*G0_1_0_6_0 - 0.00394480519480532*G0_1_0_6_1 + 0.00591720779220798*G0_1_0_6_2 + 0.004437905844156*G0_1_0_6_3 - 0.00887581168831205*G0_1_0_6_4 - 0.013313717532468*G0_1_0_6_5 + 0.04437905844156*G0_1_0_6_7 + 0.0443790584415599*G0_1_0_6_8 + 0.106509740259744*G0_1_0_6_9 + 0.0636099837662361*G0_1_0_7_0 + 0.0157792207792213*G0_1_0_7_1 - 0.0172585227272733*G0_1_0_7_2 + 0.0355032467532481*G0_1_0_7_3 + 0.0355032467532481*G0_1_0_7_4 - 0.02218952922078*G0_1_0_7_5 + 0.04437905844156*G0_1_0_7_6 - 0.328405032467545*G0_1_0_7_7 - 0.128699269480524*G0_1_0_7_8 - 0.186392045454552*G0_1_0_7_9 - 0.0029586038961041*G0_1_0_8_0 + 0.0320515422077934*G0_1_0_8_1 - 0.0231757305194813*G0_1_0_8_2 - 0.0976339285714319*G0_1_0_8_3 + 0.062130681818184*G0_1_0_8_4 - 0.02218952922078*G0_1_0_8_5 + 0.0443790584415599*G0_1_0_8_6 - 0.128699269480524*G0_1_0_8_7 - 0.328405032467544*G0_1_0_8_8 - 0.186392045454552*G0_1_0_8_9 + 0.032544642857144*G0_1_0_9_0 + 0.020710227272728*G0_1_0_9_1 - 0.038461850649352*G0_1_0_9_2 - 0.13313717532468*G0_1_0_9_3 + 0.106509740259744*G0_1_0_9_4 - 0.0532548701298719*G0_1_0_9_5 + 0.106509740259744*G0_1_0_9_6 - 0.186392045454552*G0_1_0_9_7 - 0.186392045454552*G0_1_0_9_8 - 0.319529220779232*G0_1_0_9_9 - 0.0138068181818187*G0_1_1_0_0 - 0.000493100649350649*G0_1_1_0_1 + 0.000657467532467552*G0_1_1_0_2 - 0.0172585227272734*G0_1_1_0_3 - 0.00542410714285734*G0_1_1_0_4 - 0.00147930194805201*G0_1_1_0_5 - 0.00788961038961072*G0_1_1_0_7 + 0.0216964285714294*G0_1_1_0_8 + 0.00591720779220796*G0_1_1_0_9 - 0.000493100649350649*G0_1_1_1_0 - 0.00986201298701301*G0_1_1_1_1 - 0.00443790584415598*G0_1_1_1_2 - 0.0345170454545465*G0_1_1_1_3 + 0.0216964285714292*G0_1_1_1_4 - 0.00838271103896134*G0_1_1_1_5 + 0.00345170454545468*G0_1_1_1_6 - 0.0177516233766241*G0_1_1_1_7 + 0.0443790584415602*G0_1_1_1_8 + 0.00591720779220796*G0_1_1_1_9 + 0.000657467532467552*G0_1_1_2_0 - 0.00443790584415598*G0_1_1_2_1 - 0.0046022727272729*G0_1_1_2_2 - 0.00887581168831195*G0_1_1_2_3 + 0.01479301948052*G0_1_1_2_4 - 0.0108482142857147*G0_1_1_2_5 + 0.00838271103896132*G0_1_1_2_6 - 0.0261343344155853*G0_1_1_2_7 + 0.00049310064935067*G0_1_1_2_8 - 0.023668831168832*G0_1_1_2_9 - 0.0172585227272734*G0_1_1_3_0 - 0.0345170454545465*G0_1_1_3_1 - 0.00887581168831195*G0_1_1_3_2 - 0.514797077922096*G0_1_1_3_3 + 0.0310653409090917*G0_1_1_3_4 + 0.035503246753248*G0_1_1_3_5 - 0.00443790584415599*G0_1_1_3_6 + 0.0576927759740282*G0_1_1_3_7 - 0.0621306818181841*G0_1_1_3_8 - 0.13313717532468*G0_1_1_3_9 - 0.00542410714285734*G0_1_1_4_0 + 0.0216964285714292*G0_1_1_4_1 + 0.01479301948052*G0_1_1_4_2 + 0.0310653409090917*G0_1_1_4_3 - 0.142012987012992*G0_1_1_4_4 + 0.02218952922078*G0_1_1_4_5 - 0.017751623376624*G0_1_1_4_6 + 0.04437905844156*G0_1_1_4_7 + 0.00443790584415599*G0_1_1_4_8 + 0.0266274350649361*G0_1_1_4_9 - 0.00147930194805201*G0_1_1_5_0 - 0.00838271103896134*G0_1_1_5_1 - 0.0108482142857147*G0_1_1_5_2 + 0.035503246753248*G0_1_1_5_3 + 0.02218952922078*G0_1_1_5_4 - 0.071006493506496*G0_1_1_5_5 + 0.035503246753248*G0_1_1_5_6 - 0.115385551948056*G0_1_1_5_7 + 0.031065340909092*G0_1_1_5_8 - 0.079882305194808*G0_1_1_5_9 + 0.00345170454545468*G0_1_1_6_1 + 0.00838271103896132*G0_1_1_6_2 - 0.00443790584415599*G0_1_1_6_3 - 0.017751623376624*G0_1_1_6_4 + 0.035503246753248*G0_1_1_6_5 - 0.017751623376624*G0_1_1_6_6 + 0.084320211038964*G0_1_1_6_7 - 0.00887581168831201*G0_1_1_6_8 + 0.079882305194808*G0_1_1_6_9 - 0.00788961038961072*G0_1_1_7_0 - 0.0177516233766241*G0_1_1_7_1 - 0.0261343344155853*G0_1_1_7_2 + 0.0576927759740282*G0_1_1_7_3 + 0.04437905844156*G0_1_1_7_4 - 0.115385551948056*G0_1_1_7_5 + 0.084320211038964*G0_1_1_7_6 - 0.461542207792225*G0_1_1_7_7 - 0.0221895292207799*G0_1_1_7_8 - 0.186392045454552*G0_1_1_7_9 + 0.0216964285714294*G0_1_1_8_0 + 0.0443790584415602*G0_1_1_8_1 + 0.00049310064935067*G0_1_1_8_2 - 0.0621306818181841*G0_1_1_8_3 + 0.00443790584415599*G0_1_1_8_4 + 0.031065340909092*G0_1_1_8_5 - 0.00887581168831201*G0_1_1_8_6 - 0.0221895292207799*G0_1_1_8_7 + 0.0177516233766241*G0_1_1_8_8 - 0.0266274350649359*G0_1_1_8_9 + 0.00591720779220795*G0_1_1_9_0 + 0.00591720779220796*G0_1_1_9_1 - 0.023668831168832*G0_1_1_9_2 - 0.13313717532468*G0_1_1_9_3 + 0.0266274350649361*G0_1_1_9_4 - 0.079882305194808*G0_1_1_9_5 + 0.079882305194808*G0_1_1_9_6 - 0.186392045454552*G0_1_1_9_7 - 0.0266274350649359*G0_1_1_9_8 - 0.319529220779232*G0_1_1_9_9;
    A[39] = -A[89] - 0.0210389610389618*G0_0_0_0_0 + 0.00202719155844162*G0_0_0_0_1 - 0.00432832792207807*G0_0_0_0_2 - 0.0138068181818187*G0_0_0_0_3 - 0.013313717532468*G0_0_0_0_4 - 0.013313717532468*G0_0_0_0_5 + 0.00986201298701326*G0_0_0_0_6 - 0.00295860389610402*G0_0_0_0_7 - 0.000986201298701314*G0_0_0_0_8 - 0.032544642857144*G0_0_0_0_9 + 0.00202719155844163*G0_0_0_1_0 + 0.017532467532468*G0_0_0_1_1 + 0.00126014610389614*G0_0_0_1_2 + 0.0443790584415599*G0_0_0_1_3 - 0.0069034090909093*G0_0_0_1_4 - 0.0142999188311693*G0_0_0_1_5 - 0.010355113636364*G0_0_0_1_6 - 0.011834415584416*G0_0_0_1_7 + 0.0197240259740266*G0_0_0_1_8 + 0.0187378246753253*G0_0_0_1_9 - 0.00432832792207807*G0_0_0_2_0 + 0.00126014610389614*G0_0_0_2_1 - 0.0115056818181822*G0_0_0_2_2 + 0.008875811688312*G0_0_0_2_3 + 0.0123275162337667*G0_0_0_2_4 + 0.00493100649350663*G0_0_0_2_5 - 0.00739650974025999*G0_0_0_2_6 - 0.000986201298701338*G0_0_0_2_7 - 0.00197240259740265*G0_0_0_2_8 + 0.0108482142857146*G0_0_0_2_9 - 0.0138068181818187*G0_0_0_3_0 + 0.0443790584415599*G0_0_0_3_1 + 0.008875811688312*G0_0_0_3_2 - 0.186392045454552*G0_0_0_3_3 - 0.0488169642857161*G0_0_0_3_4 + 0.0414204545454559*G0_0_0_3_5 + 0.0325446428571439*G0_0_0_3_6 + 0.0428997564935079*G0_0_0_3_7 - 0.0502962662337679*G0_0_0_3_8 - 0.142012987012992*G0_0_0_3_9 - 0.013313717532468*G0_0_0_4_0 - 0.0069034090909093*G0_0_0_4_1 + 0.0123275162337667*G0_0_0_4_2 - 0.0488169642857161*G0_0_0_4_3 - 0.257398538961048*G0_0_0_4_4 + 0.041420454545456*G0_0_0_4_5 - 0.0739650974025999*G0_0_0_4_6 + 0.020710227272728*G0_0_0_4_7 + 0.00739650974025997*G0_0_0_4_8 - 0.115385551948056*G0_0_0_4_9 - 0.013313717532468*G0_0_0_5_0 - 0.0142999188311693*G0_0_0_5_1 + 0.00493100649350663*G0_0_0_5_2 + 0.0414204545454559*G0_0_0_5_3 + 0.041420454545456*G0_0_0_5_4 - 0.360949675324687*G0_0_0_5_5 + 0.025148133116884*G0_0_0_5_6 - 0.0488169642857159*G0_0_0_5_7 + 0.0443790584415599*G0_0_0_5_8 + 0.00887581168831187*G0_0_0_5_9 + 0.00986201298701326*G0_0_0_6_0 - 0.010355113636364*G0_0_0_6_1 - 0.00739650974025999*G0_0_0_6_2 + 0.0325446428571439*G0_0_0_6_3 - 0.0739650974025999*G0_0_0_6_4 + 0.025148133116884*G0_0_0_6_5 - 0.334322240259752*G0_0_0_6_6 + 0.00443790584415597*G0_0_0_6_7 + 0.0177516233766239*G0_0_0_6_8 - 0.0976339285714318*G0_0_0_6_9 - 0.00295860389610402*G0_0_0_7_0 - 0.011834415584416*G0_0_0_7_1 - 0.000986201298701338*G0_0_0_7_2 + 0.0428997564935079*G0_0_0_7_3 + 0.020710227272728*G0_0_0_7_4 - 0.0488169642857159*G0_0_0_7_5 + 0.00443790584415597*G0_0_0_7_6 - 0.00295860389610393*G0_0_0_7_7 + 0.019230925324676*G0_0_0_7_8 + 0.0887581168831198*G0_0_0_7_9 - 0.000986201298701313*G0_0_0_8_0 + 0.0197240259740266*G0_0_0_8_1 - 0.00197240259740265*G0_0_0_8_2 - 0.0502962662337679*G0_0_0_8_3 + 0.00739650974025997*G0_0_0_8_4 + 0.0443790584415599*G0_0_0_8_5 + 0.0177516233766239*G0_0_0_8_6 + 0.0192309253246759*G0_0_0_8_7 - 0.0384618506493519*G0_0_0_8_8 - 0.0710064935064958*G0_0_0_8_9 - 0.032544642857144*G0_0_0_9_0 + 0.0187378246753253*G0_0_0_9_1 + 0.0108482142857146*G0_0_0_9_2 - 0.142012987012992*G0_0_0_9_3 - 0.115385551948056*G0_0_0_9_4 + 0.00887581168831187*G0_0_0_9_5 - 0.0976339285714318*G0_0_0_9_6 + 0.0887581168831198*G0_0_0_9_7 - 0.0710064935064958*G0_0_0_9_8 - 0.319529220779231*G0_0_0_9_9 - 0.00953327922077963*G0_0_1_0_0 + 0.000767045454545466*G0_0_1_0_1 - 0.011834415584416*G0_0_1_0_3 - 0.0123275162337667*G0_0_1_0_4 - 0.00591720779220804*G0_0_1_0_5 + 0.00493100649350669*G0_0_1_0_6 - 0.0152861201298707*G0_0_1_0_7 - 0.0098620129870133*G0_0_1_0_8 - 0.0433928571428587*G0_0_1_0_9 + 0.000767045454545466*G0_0_1_1_0 - 0.000767045454545482*G0_0_1_1_2 + 0.0246550324675332*G0_0_1_1_3 + 0.0049310064935067*G0_0_1_1_4 - 0.00394480519480533*G0_0_1_1_5 + 0.00394480519480534*G0_0_1_1_6 - 0.0049310064935066*G0_0_1_1_7 - 0.0246550324675334*G0_0_1_1_8 - 0.000767045454545481*G0_0_1_2_1 + 0.00953327922077962*G0_0_1_2_2 + 0.00986201298701331*G0_0_1_2_3 + 0.0152861201298707*G0_0_1_2_4 - 0.00493100649350669*G0_0_1_2_5 + 0.00591720779220805*G0_0_1_2_6 + 0.0123275162337667*G0_0_1_2_7 + 0.011834415584416*G0_0_1_2_8 + 0.0433928571428586*G0_0_1_2_9 - 0.011834415584416*G0_0_1_3_0 + 0.0246550324675332*G0_0_1_3_1 + 0.0098620129870133*G0_0_1_3_2 - 0.1479301948052*G0_0_1_3_3 - 0.0680478896103921*G0_0_1_3_4 + 0.023668831168832*G0_0_1_3_5 - 0.011834415584416*G0_0_1_3_6 + 0.0355032467532479*G0_0_1_3_7 - 0.0710064935064961*G0_0_1_3_9 - 0.0123275162337667*G0_0_1_4_0 + 0.0049310064935067*G0_0_1_4_1 + 0.0152861201298707*G0_0_1_4_2 - 0.0680478896103921*G0_0_1_4_3 - 0.254439935064944*G0_0_1_4_4 + 0.0369825487012999*G0_0_1_4_5 - 0.0251481331168839*G0_0_1_4_6 - 0.035503246753248*G0_0_1_4_8 - 0.204143668831176*G0_0_1_4_9 - 0.00591720779220804*G0_0_1_5_0 - 0.00394480519480532*G0_0_1_5_1 - 0.0049310064935067*G0_0_1_5_2 + 0.023668831168832*G0_0_1_5_3 + 0.0369825487012999*G0_0_1_5_4 - 0.026627435064936*G0_0_1_5_5 + 0.025148133116884*G0_0_1_5_7 + 0.011834415584416*G0_0_1_5_8 + 0.106509740259744*G0_0_1_5_9 + 0.00493100649350669*G0_0_1_6_0 + 0.00394480519480534*G0_0_1_6_1 + 0.00591720779220805*G0_0_1_6_2 - 0.011834415584416*G0_0_1_6_3 - 0.0251481331168839*G0_0_1_6_4 + 0.0266274350649362*G0_0_1_6_6 - 0.0369825487013*G0_0_1_6_7 - 0.023668831168832*G0_0_1_6_8 - 0.106509740259744*G0_0_1_6_9 - 0.0152861201298707*G0_0_1_7_0 - 0.0049310064935066*G0_0_1_7_1 + 0.0123275162337667*G0_0_1_7_2 + 0.0355032467532479*G0_0_1_7_3 + 0.025148133116884*G0_0_1_7_5 - 0.0369825487013*G0_0_1_7_6 + 0.254439935064945*G0_0_1_7_7 + 0.068047889610392*G0_0_1_7_8 + 0.204143668831176*G0_0_1_7_9 - 0.0098620129870133*G0_0_1_8_0 - 0.0246550324675334*G0_0_1_8_1 + 0.011834415584416*G0_0_1_8_2 - 0.0355032467532479*G0_0_1_8_4 + 0.011834415584416*G0_0_1_8_5 - 0.023668831168832*G0_0_1_8_6 + 0.068047889610392*G0_0_1_8_7 + 0.1479301948052*G0_0_1_8_8 + 0.0710064935064959*G0_0_1_8_9 - 0.0433928571428587*G0_0_1_9_0 + 0.0433928571428586*G0_0_1_9_2 - 0.0710064935064961*G0_0_1_9_3 - 0.204143668831176*G0_0_1_9_4 + 0.106509740259744*G0_0_1_9_5 - 0.106509740259744*G0_0_1_9_6 + 0.204143668831176*G0_0_1_9_7 + 0.0710064935064959*G0_0_1_9_8;
    A[87] = A[78] + 0.00164366883116894*G0_0_1_0_0 - 0.000493100649350655*G0_0_1_0_1 + 0.00136972402597407*G0_0_1_0_2 - 0.000246550324675334*G0_0_1_0_3 - 0.00172585227272733*G0_0_1_0_4 + 0.00616375811688335*G0_0_1_0_5 - 0.004437905844156*G0_0_1_0_6 + 0.0135602678571433*G0_0_1_0_7 + 0.00295860389610397*G0_0_1_0_8 + 0.0113413149350653*G0_0_1_0_9 - 0.000493100649350655*G0_0_1_1_0 + 0.00164366883116898*G0_0_1_1_1 + 0.00136972402597408*G0_0_1_1_2 + 0.00616375811688338*G0_0_1_1_3 - 0.00443790584415601*G0_0_1_1_4 - 0.000246550324675338*G0_0_1_1_5 - 0.00172585227272733*G0_0_1_1_6 + 0.00295860389610397*G0_0_1_1_7 + 0.0135602678571434*G0_0_1_1_8 + 0.0113413149350653*G0_0_1_1_9 + 0.00136972402597407*G0_0_1_2_0 + 0.00136972402597408*G0_0_1_2_1 - 0.00202719155844163*G0_0_1_2_2 - 0.00320515422077931*G0_0_1_2_3 + 0.00517755681818199*G0_0_1_2_4 - 0.00320515422077933*G0_0_1_2_5 + 0.00517755681818199*G0_0_1_2_6 - 0.0120809659090913*G0_0_1_2_7 - 0.0120809659090913*G0_0_1_2_8 - 0.0226826298701306*G0_0_1_2_9 - 0.000246550324675335*G0_0_1_3_0 + 0.00616375811688338*G0_0_1_3_1 - 0.00320515422077931*G0_0_1_3_2 + 0.00887581168831193*G0_0_1_3_4 + 0.00073965097402601*G0_0_1_3_5 + 0.00517755681818198*G0_0_1_3_6 + 0.000739650974026018*G0_0_1_3_7 - 0.0369825487012999*G0_0_1_3_8 - 0.0355032467532479*G0_0_1_3_9 - 0.00172585227272733*G0_0_1_4_0 - 0.00443790584415601*G0_0_1_4_1 + 0.00517755681818198*G0_0_1_4_2 + 0.00887581168831194*G0_0_1_4_3 - 0.00887581168831201*G0_0_1_4_4 + 0.005177556818182*G0_0_1_4_5 - 0.010355113636364*G0_0_1_4_6 + 0.020710227272728*G0_0_1_4_7 + 0.0362428977272739*G0_0_1_4_8 + 0.057692775974028*G0_0_1_4_9 + 0.00616375811688335*G0_0_1_5_0 - 0.000246550324675338*G0_0_1_5_1 - 0.00320515422077933*G0_0_1_5_2 + 0.00073965097402601*G0_0_1_5_3 + 0.005177556818182*G0_0_1_5_4 + 0.008875811688312*G0_0_1_5_6 - 0.0369825487013*G0_0_1_5_7 + 0.000739650974026018*G0_0_1_5_8 - 0.035503246753248*G0_0_1_5_9 - 0.004437905844156*G0_0_1_6_0 - 0.00172585227272733*G0_0_1_6_1 + 0.00517755681818199*G0_0_1_6_2 + 0.00517755681818198*G0_0_1_6_3 - 0.010355113636364*G0_0_1_6_4 + 0.00887581168831199*G0_0_1_6_5 - 0.00887581168831204*G0_0_1_6_6 + 0.036242897727274*G0_0_1_6_7 + 0.0207102272727279*G0_0_1_6_8 + 0.0576927759740279*G0_0_1_6_9 + 0.0135602678571433*G0_0_1_7_0 + 0.00295860389610397*G0_0_1_7_1 - 0.0120809659090913*G0_0_1_7_2 + 0.000739650974026018*G0_0_1_7_3 + 0.020710227272728*G0_0_1_7_4 - 0.0369825487013*G0_0_1_7_5 + 0.036242897727274*G0_0_1_7_6 - 0.2218952922078*G0_0_1_7_7 - 0.02218952922078*G0_0_1_7_8 - 0.106509740259744*G0_0_1_7_9 + 0.00295860389610397*G0_0_1_8_0 + 0.0135602678571434*G0_0_1_8_1 - 0.0120809659090913*G0_0_1_8_2 - 0.0369825487012999*G0_0_1_8_3 + 0.0362428977272739*G0_0_1_8_4 + 0.000739650974026018*G0_0_1_8_5 + 0.0207102272727279*G0_0_1_8_6 - 0.02218952922078*G0_0_1_8_7 - 0.2218952922078*G0_0_1_8_8 - 0.106509740259744*G0_0_1_8_9 + 0.0113413149350653*G0_0_1_9_0 + 0.0113413149350653*G0_0_1_9_1 - 0.0226826298701306*G0_0_1_9_2 - 0.0355032467532479*G0_0_1_9_3 + 0.057692775974028*G0_0_1_9_4 - 0.035503246753248*G0_0_1_9_5 + 0.0576927759740279*G0_0_1_9_6 - 0.106509740259744*G0_0_1_9_7 - 0.106509740259744*G0_0_1_9_8 - 0.319529220779232*G0_0_1_9_9 - 0.00164366883116894*G0_1_0_0_0 + 0.000493100649350655*G0_1_0_0_1 - 0.00136972402597407*G0_1_0_0_2 + 0.000246550324675334*G0_1_0_0_3 + 0.00172585227272733*G0_1_0_0_4 - 0.00616375811688335*G0_1_0_0_5 + 0.004437905844156*G0_1_0_0_6 - 0.0135602678571433*G0_1_0_0_7 - 0.00295860389610397*G0_1_0_0_8 - 0.0113413149350653*G0_1_0_0_9 + 0.000493100649350655*G0_1_0_1_0 - 0.00164366883116898*G0_1_0_1_1 - 0.00136972402597408*G0_1_0_1_2 - 0.00616375811688338*G0_1_0_1_3 + 0.00443790584415601*G0_1_0_1_4 + 0.000246550324675338*G0_1_0_1_5 + 0.00172585227272733*G0_1_0_1_6 - 0.00295860389610397*G0_1_0_1_7 - 0.0135602678571434*G0_1_0_1_8 - 0.0113413149350653*G0_1_0_1_9 - 0.00136972402597407*G0_1_0_2_0 - 0.00136972402597408*G0_1_0_2_1 + 0.00202719155844163*G0_1_0_2_2 + 0.00320515422077931*G0_1_0_2_3 - 0.00517755681818199*G0_1_0_2_4 + 0.00320515422077933*G0_1_0_2_5 - 0.00517755681818199*G0_1_0_2_6 + 0.0120809659090913*G0_1_0_2_7 + 0.0120809659090913*G0_1_0_2_8 + 0.0226826298701306*G0_1_0_2_9 + 0.000246550324675335*G0_1_0_3_0 - 0.00616375811688338*G0_1_0_3_1 + 0.00320515422077931*G0_1_0_3_2 - 0.00887581168831193*G0_1_0_3_4 - 0.000739650974026009*G0_1_0_3_5 - 0.00517755681818198*G0_1_0_3_6 - 0.000739650974026018*G0_1_0_3_7 + 0.0369825487012999*G0_1_0_3_8 + 0.0355032467532479*G0_1_0_3_9 + 0.00172585227272733*G0_1_0_4_0 + 0.00443790584415601*G0_1_0_4_1 - 0.00517755681818198*G0_1_0_4_2 - 0.00887581168831194*G0_1_0_4_3 + 0.00887581168831201*G0_1_0_4_4 - 0.005177556818182*G0_1_0_4_5 + 0.010355113636364*G0_1_0_4_6 - 0.020710227272728*G0_1_0_4_7 - 0.0362428977272739*G0_1_0_4_8 - 0.057692775974028*G0_1_0_4_9 - 0.00616375811688335*G0_1_0_5_0 + 0.000246550324675338*G0_1_0_5_1 + 0.00320515422077933*G0_1_0_5_2 - 0.000739650974026009*G0_1_0_5_3 - 0.005177556818182*G0_1_0_5_4 - 0.00887581168831199*G0_1_0_5_6 + 0.0369825487013*G0_1_0_5_7 - 0.000739650974026018*G0_1_0_5_8 + 0.035503246753248*G0_1_0_5_9 + 0.004437905844156*G0_1_0_6_0 + 0.00172585227272733*G0_1_0_6_1 - 0.00517755681818199*G0_1_0_6_2 - 0.00517755681818198*G0_1_0_6_3 + 0.010355113636364*G0_1_0_6_4 - 0.00887581168831199*G0_1_0_6_5 + 0.00887581168831204*G0_1_0_6_6 - 0.036242897727274*G0_1_0_6_7 - 0.0207102272727279*G0_1_0_6_8 - 0.0576927759740279*G0_1_0_6_9 - 0.0135602678571433*G0_1_0_7_0 - 0.00295860389610397*G0_1_0_7_1 + 0.0120809659090913*G0_1_0_7_2 - 0.000739650974026018*G0_1_0_7_3 - 0.020710227272728*G0_1_0_7_4 + 0.0369825487013*G0_1_0_7_5 - 0.036242897727274*G0_1_0_7_6 + 0.2218952922078*G0_1_0_7_7 + 0.02218952922078*G0_1_0_7_8 + 0.106509740259744*G0_1_0_7_9 - 0.00295860389610397*G0_1_0_8_0 - 0.0135602678571434*G0_1_0_8_1 + 0.0120809659090913*G0_1_0_8_2 + 0.0369825487012999*G0_1_0_8_3 - 0.0362428977272739*G0_1_0_8_4 - 0.000739650974026018*G0_1_0_8_5 - 0.0207102272727279*G0_1_0_8_6 + 0.02218952922078*G0_1_0_8_7 + 0.2218952922078*G0_1_0_8_8 + 0.106509740259744*G0_1_0_8_9 - 0.0113413149350653*G0_1_0_9_0 - 0.0113413149350653*G0_1_0_9_1 + 0.0226826298701306*G0_1_0_9_2 + 0.0355032467532479*G0_1_0_9_3 - 0.057692775974028*G0_1_0_9_4 + 0.035503246753248*G0_1_0_9_5 - 0.0576927759740279*G0_1_0_9_6 + 0.106509740259744*G0_1_0_9_7 + 0.106509740259744*G0_1_0_9_8 + 0.319529220779232*G0_1_0_9_9;
    A[42] = A[72] - 0.0153348214285719*G0_0_1_0_0 + 0.00766741071428602*G0_0_1_0_2 - 0.0047575081168833*G0_0_1_0_3 + 0.0113504464285719*G0_0_1_0_4 - 0.0124918831168836*G0_0_1_0_5 + 0.0187652191558449*G0_0_1_0_6 - 0.0120535714285718*G0_0_1_0_7 + 0.0030955762987014*G0_0_1_0_8 + 0.00372564935064949*G0_0_1_0_9 - 0.00584415584415603*G0_0_1_1_1 + 0.00778612012987042*G0_0_1_1_2 - 0.00875710227272758*G0_0_1_1_3 + 0.0157061688311694*G0_0_1_1_4 - 0.005195819805195*G0_0_1_1_5 + 0.011925730519481*G0_0_1_1_6 - 0.00151582792207797*G0_0_1_1_7 - 0.00384435876623391*G0_0_1_1_8 + 0.00443790584415601*G0_0_1_1_9 + 0.00766741071428602*G0_0_1_2_0 + 0.00778612012987042*G0_0_1_2_1 + 0.124736201298706*G0_0_1_2_2 - 0.0360146103896116*G0_0_1_2_3 + 0.0785765016233794*G0_0_1_2_4 - 0.0375669642857156*G0_0_1_2_5 + 0.0830509334415614*G0_0_1_2_6 - 0.00223721590909099*G0_0_1_2_7 - 0.00122362012987017*G0_0_1_2_8 + 0.0149573863636369*G0_0_1_2_9 - 0.0047575081168833*G0_0_1_3_0 - 0.00875710227272758*G0_0_1_3_1 - 0.0360146103896116*G0_0_1_3_2 + 0.0407629870129884*G0_0_1_3_3 - 0.0652536525974049*G0_0_1_3_4 + 0.020710227272728*G0_0_1_3_5 - 0.047337662337664*G0_0_1_3_6 + 0.00271205357142867*G0_0_1_3_7 + 0.00517755681818198*G0_0_1_3_8 - 0.0187378246753253*G0_0_1_3_9 + 0.0113504464285719*G0_0_1_4_0 + 0.0157061688311694*G0_0_1_4_1 + 0.0785765016233794*G0_0_1_4_2 - 0.0652536525974049*G0_0_1_4_3 + 0.167982954545461*G0_0_1_4_4 - 0.0456118100649367*G0_0_1_4_5 + 0.0929494724026007*G0_0_1_4_6 - 0.00788961038961066*G0_0_1_4_7 - 0.00788961038961065*G0_0_1_4_8 + 0.0463514610389627*G0_0_1_4_9 - 0.0124918831168836*G0_0_1_5_0 - 0.005195819805195*G0_0_1_5_1 - 0.0375669642857156*G0_0_1_5_2 + 0.020710227272728*G0_0_1_5_3 - 0.0456118100649367*G0_0_1_5_4 + 0.0420779220779236*G0_0_1_5_5 - 0.0710886769480545*G0_0_1_5_6 + 0.000821834415584448*G0_0_1_5_7 + 0.00402698863636377*G0_0_1_5_8 - 0.019230925324676*G0_0_1_5_9 + 0.0187652191558449*G0_0_1_6_0 + 0.011925730519481*G0_0_1_6_1 + 0.0830509334415614*G0_0_1_6_2 - 0.047337662337664*G0_0_1_6_3 + 0.0929494724026007*G0_0_1_6_4 - 0.0710886769480545*G0_0_1_6_5 + 0.193459821428578*G0_0_1_6_6 - 0.00484882305194822*G0_0_1_6_7 - 0.0102729301948055*G0_0_1_6_8 + 0.0498031655844173*G0_0_1_6_9 - 0.0120535714285718*G0_0_1_7_0 - 0.00151582792207797*G0_0_1_7_1 - 0.00223721590909099*G0_0_1_7_2 + 0.00271205357142867*G0_0_1_7_3 - 0.00788961038961066*G0_0_1_7_4 + 0.000821834415584448*G0_0_1_7_5 - 0.00484882305194822*G0_0_1_7_6 - 0.00131493506493512*G0_0_1_7_7 + 0.0127384334415589*G0_0_1_7_8 - 0.001479301948052*G0_0_1_7_9 + 0.0030955762987014*G0_0_1_8_0 - 0.00384435876623391*G0_0_1_8_1 - 0.00122362012987017*G0_0_1_8_2 + 0.00517755681818198*G0_0_1_8_3 - 0.00788961038961065*G0_0_1_8_4 + 0.00402698863636377*G0_0_1_8_5 - 0.0102729301948055*G0_0_1_8_6 + 0.0127384334415589*G0_0_1_8_7 + 0.0228469967532475*G0_0_1_8_8 + 0.00246550324675331*G0_0_1_8_9 + 0.00372564935064949*G0_0_1_9_0 + 0.00443790584415601*G0_0_1_9_1 + 0.0149573863636369*G0_0_1_9_2 - 0.0187378246753253*G0_0_1_9_3 + 0.0463514610389627*G0_0_1_9_4 - 0.019230925324676*G0_0_1_9_5 + 0.0498031655844173*G0_0_1_9_6 - 0.001479301948052*G0_0_1_9_7 + 0.00246550324675331*G0_0_1_9_8 - 0.00394480519480534*G0_0_1_9_9 + 0.00254464285714294*G0_1_1_0_0 + 0.00127232142857148*G0_1_1_0_2 - 0.00359780844155857*G0_1_1_0_3 + 0.00483969155844175*G0_1_1_0_4 + 0.000620941558441566*G0_1_1_0_5 + 0.002976866883117*G0_1_1_0_6 + 0.00463879870129886*G0_1_1_0_7 - 0.00505884740259758*G0_1_1_0_8 + 0.00241071428571438*G0_1_1_0_9 - 0.0164366883116888*G0_1_1_1_1 + 0.00103490259740264*G0_1_1_1_2 - 0.00684862012987036*G0_1_1_1_3 + 0.00909496753246786*G0_1_1_1_4 - 0.00272118506493516*G0_1_1_1_5 + 0.00368912337662351*G0_1_1_1_6 + 0.00416396103896119*G0_1_1_1_7 - 0.011779626623377*G0_1_1_1_8 + 0.000986201298701332*G0_1_1_1_9 + 0.00127232142857148*G0_1_1_2_0 + 0.00103490259740264*G0_1_1_2_1 + 0.0130275974025979*G0_1_1_2_2 - 0.00818181818181847*G0_1_1_2_3 + 0.019267451298702*G0_1_1_2_4 - 0.00507711038961057*G0_1_1_2_5 + 0.010318587662338*G0_1_1_2_6 + 0.00089488636363639*G0_1_1_2_7 - 0.00113230519480523*G0_1_1_2_8 + 0.0033969155844157*G0_1_1_2_9 - 0.00359780844155857*G0_1_1_3_0 - 0.00684862012987036*G0_1_1_3_1 - 0.00818181818181847*G0_1_1_3_2 - 0.026627435064936*G0_1_1_3_4 + 0.0111769480519484*G0_1_1_3_5 - 0.0144642857142862*G0_1_1_3_6 + 0.00739650974025998*G0_1_1_3_7 - 0.00739650974025999*G0_1_1_3_8 - 0.017751623376624*G0_1_1_3_9 + 0.00483969155844175*G0_1_1_4_0 + 0.00909496753246786*G0_1_1_4_1 + 0.019267451298702*G0_1_1_4_2 - 0.026627435064936*G0_1_1_4_3 + 0.0867857142857175*G0_1_1_4_4 - 0.0179159902597409*G0_1_1_4_5 + 0.0323802759740271*G0_1_1_4_6 - 0.00690340909090933*G0_1_1_4_7 + 0.0256412337662347*G0_1_1_4_9 + 0.000620941558441566*G0_1_1_5_0 - 0.00272118506493516*G0_1_1_5_1 - 0.00507711038961057*G0_1_1_5_2 + 0.0111769480519484*G0_1_1_5_3 - 0.0179159902597409*G0_1_1_5_4 - 0.0026298701298702*G0_1_1_5_5 - 0.0149573863636369*G0_1_1_5_6 + 0.0013149350649351*G0_1_1_5_7 + 0.00476663961038977*G0_1_1_5_8 - 0.0167654220779227*G0_1_1_5_9 + 0.002976866883117*G0_1_1_6_0 + 0.00368912337662351*G0_1_1_6_1 + 0.010318587662338*G0_1_1_6_2 - 0.0144642857142862*G0_1_1_6_3 + 0.0323802759740271*G0_1_1_6_4 - 0.0149573863636369*G0_1_1_6_5 + 0.0358319805194817*G0_1_1_6_6 - 0.00608157467532487*G0_1_1_6_7 - 0.00213676948051955*G0_1_1_6_8 + 0.0187378246753253*G0_1_1_6_9 + 0.00463879870129886*G0_1_1_7_0 + 0.00416396103896119*G0_1_1_7_1 + 0.00089488636363639*G0_1_1_7_2 + 0.00739650974025998*G0_1_1_7_3 - 0.00690340909090933*G0_1_1_7_4 + 0.0013149350649351*G0_1_1_7_5 - 0.00608157467532487*G0_1_1_7_6 + 0.0335308441558453*G0_1_1_7_7 + 0.010355113636364*G0_1_1_7_8 + 0.00493100649350665*G0_1_1_7_9 - 0.00505884740259758*G0_1_1_8_0 - 0.011779626623377*G0_1_1_8_1 - 0.00113230519480523*G0_1_1_8_2 - 0.00739650974025999*G0_1_1_8_3 + 0.00476663961038977*G0_1_1_8_5 - 0.00213676948051955*G0_1_1_8_6 + 0.010355113636364*G0_1_1_8_7 - 0.01479301948052*G0_1_1_8_8 - 0.00295860389610399*G0_1_1_8_9 + 0.00241071428571438*G0_1_1_9_0 + 0.000986201298701331*G0_1_1_9_1 + 0.0033969155844157*G0_1_1_9_2 - 0.017751623376624*G0_1_1_9_3 + 0.0256412337662347*G0_1_1_9_4 - 0.0167654220779227*G0_1_1_9_5 + 0.0187378246753253*G0_1_1_9_6 + 0.00493100649350665*G0_1_1_9_7 - 0.00295860389610399*G0_1_1_9_8 - 0.0788961038961066*G0_1_1_9_9;
    A[62] = -A[42] - 0.0107021103896108*G0_1_1_0_0 - 0.00155235389610395*G0_1_1_0_1 - 0.00522017045454566*G0_1_1_0_2 - 0.00133319805194809*G0_1_1_0_3 - 0.00168932629870137*G0_1_1_0_4 + 0.000374391233766255*G0_1_1_0_5 - 0.00214590097402607*G0_1_1_0_6 - 0.00590807629870151*G0_1_1_0_7 + 0.00154322240259745*G0_1_1_0_8 - 0.000821834415584455*G0_1_1_0_9 - 0.00155235389610395*G0_1_1_1_0 - 0.0107021103896108*G0_1_1_1_1 - 0.00522017045454565*G0_1_1_1_2 + 0.000374391233766252*G0_1_1_1_3 - 0.00214590097402606*G0_1_1_1_4 - 0.00133319805194809*G0_1_1_1_5 - 0.00168932629870137*G0_1_1_1_6 + 0.00154322240259746*G0_1_1_1_7 - 0.00590807629870151*G0_1_1_1_8 - 0.000821834415584454*G0_1_1_1_9 - 0.00522017045454566*G0_1_1_2_0 - 0.00522017045454565*G0_1_1_2_1 - 0.0932021103896135*G0_1_1_2_2 + 0.0208198051948059*G0_1_1_2_3 - 0.0452008928571444*G0_1_1_2_4 + 0.020819805194806*G0_1_1_2_5 - 0.0452008928571445*G0_1_1_2_6 - 0.000593547077922097*G0_1_1_2_7 - 0.000593547077922095*G0_1_1_2_8 - 0.00712256493506518*G0_1_1_2_9 - 0.00133319805194809*G0_1_1_3_0 + 0.000374391233766252*G0_1_1_3_1 + 0.0208198051948059*G0_1_1_3_2 - 0.0368181818181831*G0_1_1_3_3 + 0.0201349431818189*G0_1_1_3_4 + 0.00180803571428576*G0_1_1_3_5 + 0.00945109577922113*G0_1_1_3_6 + 0.00838271103896134*G0_1_1_3_7 - 0.0145464691558446*G0_1_1_3_8 - 0.0142999188311693*G0_1_1_3_9 - 0.00168932629870137*G0_1_1_4_0 - 0.00214590097402606*G0_1_1_4_1 - 0.0452008928571444*G0_1_1_4_2 + 0.0201349431818189*G0_1_1_4_3 - 0.0378043831168844*G0_1_1_4_4 + 0.00945109577922114*G0_1_1_4_5 - 0.0189021915584423*G0_1_1_4_6 + 0.00123275162337667*G0_1_1_4_7 + 0.00616375811688331*G0_1_1_4_8 + 0.00246550324675333*G0_1_1_4_9 + 0.000374391233766255*G0_1_1_5_0 - 0.00133319805194809*G0_1_1_5_1 + 0.020819805194806*G0_1_1_5_2 + 0.00180803571428576*G0_1_1_5_3 + 0.00945109577922114*G0_1_1_5_4 - 0.0368181818181831*G0_1_1_5_5 + 0.020134943181819*G0_1_1_5_6 - 0.0145464691558446*G0_1_1_5_7 + 0.00838271103896132*G0_1_1_5_8 - 0.0142999188311693*G0_1_1_5_9 - 0.00214590097402608*G0_1_1_6_0 - 0.00168932629870137*G0_1_1_6_1 - 0.0452008928571445*G0_1_1_6_2 + 0.00945109577922113*G0_1_1_6_3 - 0.0189021915584423*G0_1_1_6_4 + 0.020134943181819*G0_1_1_6_5 - 0.0378043831168846*G0_1_1_6_6 + 0.00616375811688332*G0_1_1_6_7 + 0.00123275162337666*G0_1_1_6_8 + 0.00246550324675331*G0_1_1_6_9 - 0.00590807629870151*G0_1_1_7_0 + 0.00154322240259746*G0_1_1_7_1 - 0.000593547077922097*G0_1_1_7_2 + 0.00838271103896133*G0_1_1_7_3 + 0.00123275162337667*G0_1_1_7_4 - 0.0145464691558446*G0_1_1_7_5 + 0.00616375811688332*G0_1_1_7_6 - 0.0613088474025995*G0_1_1_7_7 + 0.0146286525974031*G0_1_1_7_8 - 0.00986201298701334*G0_1_1_7_9 + 0.00154322240259745*G0_1_1_8_0 - 0.00590807629870151*G0_1_1_8_1 - 0.000593547077922095*G0_1_1_8_2 - 0.0145464691558446*G0_1_1_8_3 + 0.00616375811688331*G0_1_1_8_4 + 0.00838271103896132*G0_1_1_8_5 + 0.00123275162337666*G0_1_1_8_6 + 0.0146286525974031*G0_1_1_8_7 - 0.0613088474025995*G0_1_1_8_8 - 0.00986201298701329*G0_1_1_8_9 - 0.000821834415584455*G0_1_1_9_0 - 0.000821834415584454*G0_1_1_9_1 - 0.00712256493506518*G0_1_1_9_2 - 0.0142999188311693*G0_1_1_9_3 + 0.00246550324675334*G0_1_1_9_4 - 0.0142999188311693*G0_1_1_9_5 + 0.00246550324675331*G0_1_1_9_6 - 0.00986201298701334*G0_1_1_9_7 - 0.00986201298701329*G0_1_1_9_8 - 0.104537337662341*G0_1_1_9_9;
    A[65] = -A[45] + 0.00611810064935089*G0_1_0_0_0 + 0.00166193181818187*G0_1_0_0_1 - 0.00325994318181831*G0_1_0_0_2 + 0.000410917207792255*G0_1_0_0_3 + 0.000410917207792211*G0_1_0_0_4 + 0.0190665584415591*G0_1_0_0_5 + 0.000575284090909051*G0_1_0_0_6 + 0.0101085633116887*G0_1_0_0_7 - 0.00714995941558466*G0_1_0_0_8 + 0.0172585227272733*G0_1_0_0_9 + 0.00166193181818187*G0_1_0_1_0 - 0.00341517857142864*G0_1_0_1_1 - 0.00249289772727282*G0_1_0_1_2 + 0.00378043831168846*G0_1_0_1_3 - 0.00928672889610423*G0_1_0_1_4 - 0.0119165990259744*G0_1_0_1_5 - 0.0114234983766238*G0_1_0_1_6 - 0.00221895292207801*G0_1_0_1_7 + 0.00419135551948069*G0_1_0_1_8 - 0.0261343344155853*G0_1_0_1_9 - 0.00325994318181831*G0_1_0_2_0 - 0.00249289772727282*G0_1_0_2_1 - 0.0717735389610414*G0_1_0_2_2 + 0.0123275162337667*G0_1_0_2_3 - 0.0394480519480533*G0_1_0_2_4 + 0.0172585227272733*G0_1_0_2_5 - 0.0147930194805201*G0_1_0_2_6 + 0.00238331980519489*G0_1_0_2_7 - 0.00156148538961044*G0_1_0_2_8 + 0.00493100649350663*G0_1_0_2_9 + 0.000410917207792255*G0_1_0_3_0 + 0.00378043831168846*G0_1_0_3_1 + 0.0123275162337667*G0_1_0_3_2 + 0.0325446428571442*G0_1_0_3_3 + 0.045118709415586*G0_1_0_3_4 + 0.0162723214285719*G0_1_0_3_5 + 0.0362428977272739*G0_1_0_3_6 + 0.000739650974025961*G0_1_0_3_7 - 0.00739650974025994*G0_1_0_3_8 + 0.0769237012987039*G0_1_0_3_9 + 0.000410917207792212*G0_1_0_4_0 - 0.00928672889610423*G0_1_0_4_1 - 0.0394480519480533*G0_1_0_4_2 + 0.045118709415586*G0_1_0_4_3 + 0.000739650974026059*G0_1_0_4_5 - 0.0369825487013*G0_1_0_4_6 - 0.005177556818182*G0_1_0_4_7 + 0.00665685876623397*G0_1_0_4_8 - 0.0162723214285719*G0_1_0_4_9 + 0.0190665584415591*G0_1_0_5_0 - 0.0119165990259744*G0_1_0_5_1 + 0.0172585227272733*G0_1_0_5_2 + 0.0162723214285719*G0_1_0_5_3 + 0.000739650974026056*G0_1_0_5_4 - 0.221895292207799*G0_1_0_5_5 - 0.0229291801948059*G0_1_0_5_6 - 0.0325446428571439*G0_1_0_5_7 + 0.0377221996753259*G0_1_0_5_8 - 0.127219967532472*G0_1_0_5_9 + 0.000575284090909052*G0_1_0_6_0 - 0.0114234983766238*G0_1_0_6_1 - 0.0147930194805201*G0_1_0_6_2 + 0.0362428977272739*G0_1_0_6_3 - 0.0369825487013*G0_1_0_6_4 - 0.0229291801948059*G0_1_0_6_5 - 0.1479301948052*G0_1_0_6_6 - 0.00517755681818204*G0_1_0_6_7 + 0.01849127435065*G0_1_0_6_8 - 0.0872788149350679*G0_1_0_6_9 + 0.0101085633116887*G0_1_0_7_0 - 0.00221895292207801*G0_1_0_7_1 + 0.00238331980519489*G0_1_0_7_2 + 0.000739650974025962*G0_1_0_7_3 - 0.005177556818182*G0_1_0_7_4 - 0.0325446428571439*G0_1_0_7_5 - 0.00517755681818204*G0_1_0_7_6 + 0.0207102272727281*G0_1_0_7_7 + 0.00739650974025995*G0_1_0_7_8 - 0.041420454545456*G0_1_0_7_9 - 0.00714995941558466*G0_1_0_8_0 + 0.00419135551948069*G0_1_0_8_1 - 0.00156148538961044*G0_1_0_8_2 - 0.00739650974025994*G0_1_0_8_3 + 0.00665685876623397*G0_1_0_8_4 + 0.0377221996753259*G0_1_0_8_5 + 0.01849127435065*G0_1_0_8_6 + 0.00739650974025995*G0_1_0_8_7 - 0.00591720779220789*G0_1_0_8_8 + 0.065089285714288*G0_1_0_8_9 + 0.0172585227272733*G0_1_0_9_0 - 0.0261343344155853*G0_1_0_9_1 + 0.00493100649350663*G0_1_0_9_2 + 0.0769237012987039*G0_1_0_9_3 - 0.0162723214285719*G0_1_0_9_4 - 0.127219967532472*G0_1_0_9_5 - 0.0872788149350679*G0_1_0_9_6 - 0.041420454545456*G0_1_0_9_7 + 0.065089285714288*G0_1_0_9_8 - 0.408287337662352*G0_1_0_9_9 - 0.0864752435064966*G0_1_1_0_0 - 0.00539671266233786*G0_1_1_0_1 - 0.00699472402597428*G0_1_1_0_2 + 0.00189021915584427*G0_1_1_0_3 + 0.000410917207792222*G0_1_1_0_4 - 0.0216142451298709*G0_1_1_0_5 + 0.0178338068181824*G0_1_1_0_6 - 0.0626237824675347*G0_1_1_0_7 + 0.027367086038962*G0_1_1_0_8 - 0.00539671266233786*G0_1_1_1_0 - 0.00178977272727278*G0_1_1_1_1 - 0.00259334415584426*G0_1_1_1_2 + 0.00525974025974044*G0_1_1_1_3 - 0.00977982954545489*G0_1_1_1_4 - 0.00920454545454576*G0_1_1_1_5 - 0.00945109577922112*G0_1_1_1_6 - 0.0142177353896109*G0_1_1_1_7 + 0.0126562500000005*G0_1_1_1_8 - 0.0197240259740267*G0_1_1_1_9 - 0.00699472402597428*G0_1_1_2_0 - 0.00259334415584425*G0_1_1_2_1 - 0.0690340909090933*G0_1_1_2_2 + 0.0116700487012991*G0_1_1_2_3 - 0.0361607142857156*G0_1_1_2_4 + 0.0124918831168836*G0_1_1_2_5 - 0.0106838474025979*G0_1_1_2_6 - 0.0072321428571431*G0_1_1_2_7 + 0.000657467532467564*G0_1_1_2_8 + 0.00542410714285729*G0_1_1_2_9 + 0.00189021915584427*G0_1_1_3_0 + 0.00525974025974044*G0_1_1_3_1 + 0.0116700487012991*G0_1_1_3_2 + 0.0236688311688321*G0_1_1_3_3 + 0.04437905844156*G0_1_1_3_4 + 0.00739650974025994*G0_1_1_3_5 + 0.0355032467532479*G0_1_1_3_6 + 0.00147930194805203*G0_1_1_3_7 - 0.00665685876623397*G0_1_1_3_8 + 0.0562134740259759*G0_1_1_3_9 + 0.000410917207792222*G0_1_1_4_0 - 0.00977982954545489*G0_1_1_4_1 - 0.0361607142857156*G0_1_1_4_2 + 0.04437905844156*G0_1_1_4_3 - 0.0103551136363638*G0_1_1_4_4 + 0.00591720779220803*G0_1_1_4_5 - 0.0414204545454559*G0_1_1_4_6 + 0.006656858766234*G0_1_1_4_7 + 0.00517755681818197*G0_1_1_4_8 - 0.0281067370129878*G0_1_1_4_9 - 0.0216142451298709*G0_1_1_5_0 - 0.00920454545454576*G0_1_1_5_1 + 0.0124918831168836*G0_1_1_5_2 + 0.00739650974025994*G0_1_1_5_3 + 0.00591720779220803*G0_1_1_5_4 - 0.124261363636368*G0_1_1_5_5 - 0.00739650974025989*G0_1_1_5_6 - 0.0636099837662359*G0_1_1_5_7 + 0.034763595779222*G0_1_1_5_8 - 0.0695271915584439*G0_1_1_5_9 + 0.0178338068181824*G0_1_1_6_0 - 0.00945109577922112*G0_1_1_6_1 - 0.0106838474025979*G0_1_1_6_2 + 0.0355032467532479*G0_1_1_6_3 - 0.0414204545454559*G0_1_1_6_4 - 0.00739650974025989*G0_1_1_6_5 - 0.143492288961044*G0_1_1_6_6 + 0.028846387987014*G0_1_1_6_7 + 0.00961546266233796*G0_1_1_6_8 - 0.0872788149350678*G0_1_1_6_9 - 0.0626237824675347*G0_1_1_7_0 - 0.0142177353896109*G0_1_1_7_1 - 0.0072321428571431*G0_1_1_7_2 + 0.00147930194805203*G0_1_1_7_3 + 0.006656858766234*G0_1_1_7_4 - 0.0636099837662359*G0_1_1_7_5 + 0.028846387987014*G0_1_1_7_6 - 0.23668831168832*G0_1_1_7_7 + 0.0525152191558461*G0_1_1_7_8 - 0.0576927759740281*G0_1_1_7_9 + 0.027367086038962*G0_1_1_8_0 + 0.0126562500000005*G0_1_1_8_1 + 0.000657467532467564*G0_1_1_8_2 - 0.00665685876623398*G0_1_1_8_3 + 0.00517755681818197*G0_1_1_8_4 + 0.034763595779222*G0_1_1_8_5 + 0.00961546266233795*G0_1_1_8_6 + 0.0525152191558461*G0_1_1_8_7 - 0.02218952922078*G0_1_1_8_8 + 0.048816964285716*G0_1_1_8_9 - 0.0197240259740267*G0_1_1_9_1 + 0.00542410714285729*G0_1_1_9_2 + 0.0562134740259759*G0_1_1_9_3 - 0.0281067370129878*G0_1_1_9_4 - 0.0695271915584439*G0_1_1_9_5 - 0.0872788149350678*G0_1_1_9_6 - 0.0576927759740281*G0_1_1_9_7 + 0.048816964285716*G0_1_1_9_8 - 0.390535714285727*G0_1_1_9_9;
    A[6] = -A[4] + 0.0525974025974045*G0_0_1_0_0 + 0.00393567370129884*G0_0_1_0_1 + 0.00307426948051959*G0_0_1_0_2 - 0.00170758928571436*G0_0_1_0_3 - 0.000858360389610423*G0_0_1_0_4 + 0.0196783685064942*G0_0_1_0_5 - 0.0100994318181822*G0_0_1_0_6 + 0.0389458198051962*G0_0_1_0_7 - 0.0165827922077928*G0_0_1_0_8 + 0.00476663961038981*G0_0_1_0_9 + 0.00393567370129884*G0_0_1_1_0 + 0.00787134740259767*G0_0_1_1_1 + 0.00106534090909095*G0_0_1_1_2 + 0.00241984577922085*G0_0_1_1_3 + 0.00124188311688316*G0_0_1_1_4 + 0.000757913961038991*G0_0_1_1_5 + 0.00111404220779225*G0_0_1_1_6 + 0.00544237012987032*G0_0_1_1_7 - 0.000173498376623372*G0_0_1_1_8 + 0.00378043831168845*G0_0_1_1_9 + 0.00307426948051959*G0_0_1_2_0 + 0.00106534090909095*G0_0_1_2_1 + 0.0154017857142863*G0_0_1_2_2 - 0.00249289772727282*G0_0_1_2_3 + 0.0090401785714289*G0_0_1_2_4 - 0.00167106331168838*G0_0_1_2_5 + 0.00246550324675336*G0_0_1_2_6 + 0.00346996753246765*G0_0_1_2_7 - 0.00146103896103901*G0_0_1_2_8 - 0.000767045454545472*G0_0_1_2_9 - 0.00170758928571436*G0_0_1_3_0 + 0.00241984577922085*G0_0_1_3_1 - 0.00249289772727282*G0_0_1_3_2 - 0.0238331980519489*G0_0_1_3_3 - 0.0134780844155849*G0_0_1_3_4 + 0.00336952110389621*G0_0_1_3_5 - 0.0072321428571431*G0_0_1_3_6 + 0.00123275162337664*G0_0_1_3_7 - 0.00172585227272732*G0_0_1_3_8 - 0.0138068181818186*G0_0_1_3_9 - 0.000858360389610423*G0_0_1_4_0 + 0.00124188311688316*G0_0_1_4_1 + 0.0090401785714289*G0_0_1_4_2 - 0.0134780844155849*G0_0_1_4_3 - 0.00361607142857159*G0_0_1_4_4 - 0.00131493506493512*G0_0_1_4_5 + 0.00854707792207822*G0_0_1_4_6 - 0.00197240259740267*G0_0_1_4_7 + 0.000493100649350667*G0_0_1_4_8 + 0.00493100649350664*G0_0_1_4_9 + 0.0196783685064942*G0_0_1_5_0 + 0.000757913961038991*G0_0_1_5_1 - 0.00167106331168838*G0_0_1_5_2 + 0.00336952110389621*G0_0_1_5_3 - 0.00131493506493512*G0_0_1_5_4 - 0.0134780844155848*G0_0_1_5_5 - 0.00460227272727292*G0_0_1_5_6 + 0.0204636769480527*G0_0_1_5_7 - 0.00616375811688335*G0_0_1_5_8 - 0.00197240259740265*G0_0_1_5_9 - 0.0100994318181822*G0_0_1_6_0 + 0.00111404220779225*G0_0_1_6_1 + 0.00246550324675336*G0_0_1_6_2 - 0.0072321428571431*G0_0_1_6_3 + 0.00854707792207822*G0_0_1_6_4 - 0.00460227272727292*G0_0_1_6_5 + 0.0259699675324684*G0_0_1_6_6 - 0.0142999188311693*G0_0_1_6_7 + 0.00246550324675334*G0_0_1_6_8 + 0.0167654220779226*G0_0_1_6_9 + 0.0389458198051962*G0_0_1_7_0 + 0.00544237012987032*G0_0_1_7_1 + 0.00346996753246765*G0_0_1_7_2 + 0.00123275162337664*G0_0_1_7_3 - 0.00197240259740267*G0_0_1_7_4 + 0.0204636769480527*G0_0_1_7_5 - 0.0142999188311693*G0_0_1_7_6 + 0.10568790584416*G0_0_1_7_7 - 0.0316406250000012*G0_0_1_7_8 + 0.0142999188311694*G0_0_1_7_9 - 0.0165827922077928*G0_0_1_8_0 - 0.000173498376623372*G0_0_1_8_1 - 0.00146103896103901*G0_0_1_8_2 - 0.00172585227272732*G0_0_1_8_3 + 0.000493100649350667*G0_0_1_8_4 - 0.00616375811688335*G0_0_1_8_5 + 0.00246550324675334*G0_0_1_8_6 - 0.0316406250000012*G0_0_1_8_7 - 0.0082183441558444*G0_0_1_8_8 - 0.0123275162337667*G0_0_1_8_9 + 0.00476663961038981*G0_0_1_9_0 + 0.00378043831168845*G0_0_1_9_1 - 0.000767045454545472*G0_0_1_9_2 - 0.0138068181818186*G0_0_1_9_3 + 0.00493100649350664*G0_0_1_9_4 - 0.00197240259740265*G0_0_1_9_5 + 0.0167654220779226*G0_0_1_9_6 + 0.0142999188311694*G0_0_1_9_7 - 0.0123275162337667*G0_0_1_9_8 + 0.0867857142857172*G0_0_1_9_9 + 0.0525974025974045*G0_1_1_0_0 + 0.00393567370129885*G0_1_1_0_1 + 0.00307426948051959*G0_1_1_0_2 - 0.00170758928571436*G0_1_1_0_3 - 0.000858360389610424*G0_1_1_0_4 + 0.0196783685064942*G0_1_1_0_5 - 0.0100994318181822*G0_1_1_0_6 + 0.0389458198051962*G0_1_1_0_7 - 0.0165827922077928*G0_1_1_0_8 + 0.00476663961038981*G0_1_1_0_9 + 0.00393567370129885*G0_1_1_1_0 + 0.00787134740259767*G0_1_1_1_1 + 0.00106534090909095*G0_1_1_1_2 + 0.00241984577922085*G0_1_1_1_3 + 0.00124188311688317*G0_1_1_1_4 + 0.000757913961038992*G0_1_1_1_5 + 0.00111404220779225*G0_1_1_1_6 + 0.00544237012987032*G0_1_1_1_7 - 0.000173498376623375*G0_1_1_1_8 + 0.00378043831168845*G0_1_1_1_9 + 0.00307426948051959*G0_1_1_2_0 + 0.00106534090909095*G0_1_1_2_1 + 0.0154017857142863*G0_1_1_2_2 - 0.00249289772727282*G0_1_1_2_3 + 0.0090401785714289*G0_1_1_2_4 - 0.00167106331168838*G0_1_1_2_5 + 0.00246550324675336*G0_1_1_2_6 + 0.00346996753246765*G0_1_1_2_7 - 0.00146103896103901*G0_1_1_2_8 - 0.000767045454545471*G0_1_1_2_9 - 0.00170758928571436*G0_1_1_3_0 + 0.00241984577922085*G0_1_1_3_1 - 0.00249289772727282*G0_1_1_3_2 - 0.0238331980519489*G0_1_1_3_3 - 0.0134780844155849*G0_1_1_3_4 + 0.00336952110389621*G0_1_1_3_5 - 0.0072321428571431*G0_1_1_3_6 + 0.00123275162337664*G0_1_1_3_7 - 0.00172585227272732*G0_1_1_3_8 - 0.0138068181818187*G0_1_1_3_9 - 0.000858360389610424*G0_1_1_4_0 + 0.00124188311688317*G0_1_1_4_1 + 0.0090401785714289*G0_1_1_4_2 - 0.0134780844155849*G0_1_1_4_3 - 0.00361607142857161*G0_1_1_4_4 - 0.00131493506493511*G0_1_1_4_5 + 0.00854707792207822*G0_1_1_4_6 - 0.00197240259740267*G0_1_1_4_7 + 0.000493100649350664*G0_1_1_4_8 + 0.00493100649350663*G0_1_1_4_9 + 0.0196783685064942*G0_1_1_5_0 + 0.000757913961038992*G0_1_1_5_1 - 0.00167106331168838*G0_1_1_5_2 + 0.00336952110389621*G0_1_1_5_3 - 0.00131493506493512*G0_1_1_5_4 - 0.0134780844155848*G0_1_1_5_5 - 0.00460227272727292*G0_1_1_5_6 + 0.0204636769480527*G0_1_1_5_7 - 0.00616375811688335*G0_1_1_5_8 - 0.00197240259740264*G0_1_1_5_9 - 0.0100994318181822*G0_1_1_6_0 + 0.00111404220779225*G0_1_1_6_1 + 0.00246550324675336*G0_1_1_6_2 - 0.0072321428571431*G0_1_1_6_3 + 0.00854707792207822*G0_1_1_6_4 - 0.00460227272727292*G0_1_1_6_5 + 0.0259699675324684*G0_1_1_6_6 - 0.0142999188311693*G0_1_1_6_7 + 0.00246550324675334*G0_1_1_6_8 + 0.0167654220779226*G0_1_1_6_9 + 0.0389458198051962*G0_1_1_7_0 + 0.00544237012987032*G0_1_1_7_1 + 0.00346996753246765*G0_1_1_7_2 + 0.00123275162337664*G0_1_1_7_3 - 0.00197240259740267*G0_1_1_7_4 + 0.0204636769480527*G0_1_1_7_5 - 0.0142999188311693*G0_1_1_7_6 + 0.10568790584416*G0_1_1_7_7 - 0.0316406250000012*G0_1_1_7_8 + 0.0142999188311694*G0_1_1_7_9 - 0.0165827922077928*G0_1_1_8_0 - 0.000173498376623375*G0_1_1_8_1 - 0.00146103896103901*G0_1_1_8_2 - 0.00172585227272732*G0_1_1_8_3 + 0.000493100649350664*G0_1_1_8_4 - 0.00616375811688335*G0_1_1_8_5 + 0.00246550324675334*G0_1_1_8_6 - 0.0316406250000012*G0_1_1_8_7 - 0.00821834415584437*G0_1_1_8_8 - 0.0123275162337667*G0_1_1_8_9 + 0.00476663961038981*G0_1_1_9_0 + 0.00378043831168845*G0_1_1_9_1 - 0.000767045454545471*G0_1_1_9_2 - 0.0138068181818187*G0_1_1_9_3 + 0.00493100649350663*G0_1_1_9_4 - 0.00197240259740264*G0_1_1_9_5 + 0.0167654220779226*G0_1_1_9_6 + 0.0142999188311694*G0_1_1_9_7 - 0.0123275162337667*G0_1_1_9_8 + 0.0867857142857172*G0_1_1_9_9;
    A[17] = -A[14] + 0.0180560064935071*G0_0_0_0_0 + 0.00281554383116894*G0_0_0_0_1 + 0.00271814123376634*G0_0_0_0_2 + 0.00176237824675332*G0_0_0_0_3 - 0.00125101461038966*G0_0_0_0_4 + 0.0116517857142861*G0_0_0_0_5 - 0.00341517857142866*G0_0_0_0_6 + 0.00462053571428585*G0_0_0_0_7 - 0.00315949675324685*G0_0_0_0_8 - 0.00098620129870132*G0_0_0_0_9 + 0.00281554383116894*G0_0_0_1_0 + 0.047118506493508*G0_0_0_1_1 + 0.0037956574675326*G0_0_0_1_2 + 0.0306818181818192*G0_0_0_1_3 - 0.0130945616883121*G0_0_0_1_4 + 0.000721387987013005*G0_0_0_1_5 + 0.000885754870129908*G0_0_0_1_6 - 0.00816355519480549*G0_0_0_1_7 + 0.0158887987012993*G0_0_0_1_8 + 0.0037256493506495*G0_0_0_1_9 + 0.00271814123376634*G0_0_0_2_0 + 0.0037956574675326*G0_0_0_2_1 + 0.0200162337662345*G0_0_0_2_2 + 0.000894886363636376*G0_0_0_2_3 + 0.00571631493506517*G0_0_0_2_4 - 0.00429180194805212*G0_0_0_2_5 + 0.0132406655844161*G0_0_0_2_6 + 0.000885754870129897*G0_0_0_2_7 - 0.000374391233766242*G0_0_0_2_8 + 0.00427353896103911*G0_0_0_2_9 + 0.00176237824675332*G0_0_0_3_0 + 0.0306818181818192*G0_0_0_3_1 + 0.000894886363636376*G0_0_0_3_2 + 0.0726501623376649*G0_0_0_3_3 - 0.0222717126623384*G0_0_0_3_4 - 0.00197240259740265*G0_0_0_3_5 - 0.00616375811688334*G0_0_0_3_6 - 0.00879362824675359*G0_0_0_3_7 + 0.0111769480519485*G0_0_0_3_8 + 0.00641030844155871*G0_0_0_3_9 - 0.00125101461038966*G0_0_0_4_0 - 0.0130945616883121*G0_0_0_4_1 + 0.00571631493506517*G0_0_0_4_2 - 0.0222717126623384*G0_0_0_4_3 - 0.0161079545454551*G0_0_0_4_4 + 0.000246550324675315*G0_0_0_4_5 + 0.00591720779220802*G0_0_0_4_6 + 0.00230113636363645*G0_0_0_4_7 - 0.00238331980519491*G0_0_0_4_8 - 0.013313717532468*G0_0_0_4_9 + 0.0116517857142861*G0_0_0_5_0 + 0.000721387987013005*G0_0_0_5_1 - 0.00429180194805212*G0_0_0_5_2 - 0.00197240259740265*G0_0_0_5_3 + 0.000246550324675315*G0_0_0_5_4 + 0.0535836038961057*G0_0_0_5_5 - 0.0201349431818189*G0_0_0_5_6 + 0.011834415584416*G0_0_0_5_7 - 0.00567065746753266*G0_0_0_5_8 + 0.0142999188311693*G0_0_0_5_9 - 0.00341517857142866*G0_0_0_6_0 + 0.000885754870129908*G0_0_0_6_1 + 0.0132406655844161*G0_0_0_6_2 - 0.00616375811688334*G0_0_0_6_3 + 0.00591720779220803*G0_0_0_6_4 - 0.0201349431818189*G0_0_0_6_5 + 0.0575284090909111*G0_0_0_6_6 - 0.00616375811688332*G0_0_0_6_7 + 0.000986201298701333*G0_0_0_6_8 - 0.000493100649350669*G0_0_0_6_9 + 0.00462053571428585*G0_0_0_7_0 - 0.00816355519480549*G0_0_0_7_1 + 0.000885754870129897*G0_0_0_7_2 - 0.00879362824675359*G0_0_0_7_3 + 0.00230113636363645*G0_0_0_7_4 + 0.011834415584416*G0_0_0_7_5 - 0.00616375811688332*G0_0_0_7_6 + 0.0193952922077929*G0_0_0_7_7 - 0.00106838474025981*G0_0_0_7_8 + 0.0152861201298707*G0_0_0_7_9 - 0.00315949675324685*G0_0_0_8_0 + 0.0158887987012993*G0_0_0_8_1 - 0.000374391233766242*G0_0_0_8_2 + 0.0111769480519485*G0_0_0_8_3 - 0.00238331980519491*G0_0_0_8_4 - 0.00567065746753266*G0_0_0_8_5 + 0.000986201298701334*G0_0_0_8_6 - 0.00106838474025981*G0_0_0_8_7 - 0.0210389610389617*G0_0_0_8_8 - 0.00641030844155865*G0_0_0_8_9 - 0.00098620129870132*G0_0_0_9_0 + 0.0037256493506495*G0_0_0_9_1 + 0.00427353896103911*G0_0_0_9_2 + 0.00641030844155871*G0_0_0_9_3 - 0.013313717532468*G0_0_0_9_4 + 0.0142999188311693*G0_0_0_9_5 - 0.000493100649350669*G0_0_0_9_6 + 0.0152861201298707*G0_0_0_9_7 - 0.00641030844155865*G0_0_0_9_8 + 0.0374756493506506*G0_0_0_9_9 - 0.00196022727272735*G0_0_1_0_0 - 0.000980113636363676*G0_0_1_0_1 + 0.00213676948051957*G0_0_1_0_3 - 0.00213676948051956*G0_0_1_0_4 - 0.00158887987012993*G0_0_1_0_5 + 0.00087662337662341*G0_0_1_0_6 - 0.00109577922077926*G0_0_1_0_7 - 0.00405438311688326*G0_0_1_0_8 - 0.00525974025974044*G0_0_1_0_9 - 0.000980113636363675*G0_0_1_1_0 + 0.00098011363636367*G0_0_1_1_2 + 0.01479301948052*G0_0_1_1_3 - 0.00493100649350665*G0_0_1_1_4 - 0.000164366883116888*G0_0_1_1_5 + 0.000164366883116886*G0_0_1_1_6 + 0.00493100649350668*G0_0_1_1_7 - 0.01479301948052*G0_0_1_1_8 + 0.00098011363636367*G0_0_1_2_1 + 0.00196022727272736*G0_0_1_2_2 + 0.00405438311688325*G0_0_1_2_3 + 0.00109577922077927*G0_0_1_2_4 - 0.000876623376623415*G0_0_1_2_5 + 0.00158887987012994*G0_0_1_2_6 + 0.00213676948051955*G0_0_1_2_7 - 0.00213676948051955*G0_0_1_2_8 + 0.00525974025974044*G0_0_1_2_9 + 0.00213676948051957*G0_0_1_3_0 + 0.01479301948052*G0_0_1_3_1 + 0.00405438311688325*G0_0_1_3_2 + 0.0936891233766268*G0_0_1_3_3 - 0.0212033279220787*G0_0_1_3_4 - 0.002958603896104*G0_0_1_3_5 - 0.000493100649350686*G0_0_1_3_6 - 0.00641030844155872*G0_0_1_3_7 + 0.0128206168831174*G0_0_1_3_9 - 0.00213676948051956*G0_0_1_4_0 - 0.00493100649350665*G0_0_1_4_1 + 0.00109577922077927*G0_0_1_4_2 - 0.0212033279220787*G0_0_1_4_3 - 0.035503246753248*G0_0_1_4_4 + 0.00641030844155866*G0_0_1_4_5 - 0.00591720779220798*G0_0_1_4_6 + 0.00641030844155863*G0_0_1_4_8 - 0.0285998376623386*G0_0_1_4_9 - 0.00158887987012993*G0_0_1_5_0 - 0.000164366883116888*G0_0_1_5_1 - 0.000876623376623415*G0_0_1_5_2 - 0.002958603896104*G0_0_1_5_3 + 0.00641030844155866*G0_0_1_5_4 - 0.00394480519480533*G0_0_1_5_5 + 0.005917207792208*G0_0_1_5_7 + 0.000493100649350662*G0_0_1_5_8 + 0.01479301948052*G0_0_1_5_9 + 0.00087662337662341*G0_0_1_6_0 + 0.000164366883116886*G0_0_1_6_1 + 0.00158887987012994*G0_0_1_6_2 - 0.000493100649350686*G0_0_1_6_3 - 0.00591720779220798*G0_0_1_6_4 + 0.00394480519480537*G0_0_1_6_6 - 0.00641030844155866*G0_0_1_6_7 + 0.00295860389610399*G0_0_1_6_8 - 0.01479301948052*G0_0_1_6_9 - 0.00109577922077926*G0_0_1_7_0 + 0.00493100649350669*G0_0_1_7_1 + 0.00213676948051955*G0_0_1_7_2 - 0.00641030844155872*G0_0_1_7_3 + 0.005917207792208*G0_0_1_7_5 - 0.00641030844155866*G0_0_1_7_6 + 0.0355032467532481*G0_0_1_7_7 + 0.0212033279220786*G0_0_1_7_8 + 0.0285998376623386*G0_0_1_7_9 - 0.00405438311688326*G0_0_1_8_0 - 0.01479301948052*G0_0_1_8_1 - 0.00213676948051955*G0_0_1_8_2 + 0.00641030844155863*G0_0_1_8_4 + 0.000493100649350662*G0_0_1_8_5 + 0.00295860389610398*G0_0_1_8_6 + 0.0212033279220786*G0_0_1_8_7 - 0.0936891233766266*G0_0_1_8_8 - 0.0128206168831173*G0_0_1_8_9 - 0.00525974025974044*G0_0_1_9_0 + 0.00525974025974044*G0_0_1_9_2 + 0.0128206168831174*G0_0_1_9_3 - 0.0285998376623386*G0_0_1_9_4 + 0.01479301948052*G0_0_1_9_5 - 0.01479301948052*G0_0_1_9_6 + 0.0285998376623386*G0_0_1_9_7 - 0.0128206168831173*G0_0_1_9_8;
    A[9] = A[90] - 0.000980113636363679*G0_0_1_0_1 + 0.00098011363636367*G0_0_1_0_2 - 0.000164366883116885*G0_0_1_0_3 + 0.000164366883116888*G0_0_1_0_4 + 0.0147930194805199*G0_0_1_0_5 - 0.00493100649350665*G0_0_1_0_6 - 0.0147930194805201*G0_0_1_0_7 + 0.0049310064935067*G0_0_1_0_8 - 0.000980113636363679*G0_0_1_1_0 - 0.00196022727272735*G0_0_1_1_1 - 0.00158887987012993*G0_0_1_1_3 + 0.00087662337662341*G0_0_1_1_4 + 0.00213676948051954*G0_0_1_1_5 - 0.00213676948051956*G0_0_1_1_6 - 0.00405438311688326*G0_0_1_1_7 - 0.00109577922077926*G0_0_1_1_8 - 0.00525974025974044*G0_0_1_1_9 + 0.00098011363636367*G0_0_1_2_0 + 0.00196022727272736*G0_0_1_2_2 - 0.000876623376623413*G0_0_1_2_3 + 0.00158887987012994*G0_0_1_2_4 + 0.00405438311688324*G0_0_1_2_5 + 0.00109577922077927*G0_0_1_2_6 - 0.00213676948051956*G0_0_1_2_7 + 0.00213676948051955*G0_0_1_2_8 + 0.00525974025974044*G0_0_1_2_9 - 0.000164366883116885*G0_0_1_3_0 - 0.00158887987012992*G0_0_1_3_1 - 0.000876623376623412*G0_0_1_3_2 - 0.00394480519480533*G0_0_1_3_3 - 0.00295860389610398*G0_0_1_3_5 + 0.00641030844155865*G0_0_1_3_6 + 0.000493100649350697*G0_0_1_3_7 + 0.00591720779220796*G0_0_1_3_8 + 0.01479301948052*G0_0_1_3_9 + 0.000164366883116888*G0_0_1_4_0 + 0.00087662337662341*G0_0_1_4_1 + 0.00158887987012994*G0_0_1_4_2 + 0.00394480519480536*G0_0_1_4_4 - 0.000493100649350677*G0_0_1_4_5 - 0.00591720779220798*G0_0_1_4_6 + 0.002958603896104*G0_0_1_4_7 - 0.00641030844155865*G0_0_1_4_8 - 0.01479301948052*G0_0_1_4_9 + 0.0147930194805199*G0_0_1_5_0 + 0.00213676948051954*G0_0_1_5_1 + 0.00405438311688324*G0_0_1_5_2 - 0.00295860389610398*G0_0_1_5_3 - 0.000493100649350675*G0_0_1_5_4 + 0.0936891233766265*G0_0_1_5_5 - 0.0212033279220786*G0_0_1_5_6 - 0.00641030844155863*G0_0_1_5_8 + 0.0128206168831173*G0_0_1_5_9 - 0.00493100649350665*G0_0_1_6_0 - 0.00213676948051956*G0_0_1_6_1 + 0.00109577922077927*G0_0_1_6_2 + 0.00641030844155865*G0_0_1_6_3 - 0.00591720779220798*G0_0_1_6_4 - 0.0212033279220786*G0_0_1_6_5 - 0.035503246753248*G0_0_1_6_6 + 0.00641030844155866*G0_0_1_6_7 - 0.0285998376623386*G0_0_1_6_9 - 0.0147930194805201*G0_0_1_7_0 - 0.00405438311688326*G0_0_1_7_1 - 0.00213676948051956*G0_0_1_7_2 + 0.000493100649350697*G0_0_1_7_3 + 0.002958603896104*G0_0_1_7_4 + 0.00641030844155866*G0_0_1_7_6 - 0.0936891233766269*G0_0_1_7_7 + 0.0212033279220787*G0_0_1_7_8 - 0.0128206168831174*G0_0_1_7_9 + 0.0049310064935067*G0_0_1_8_0 - 0.00109577922077926*G0_0_1_8_1 + 0.00213676948051955*G0_0_1_8_2 + 0.00591720779220797*G0_0_1_8_3 - 0.00641030844155865*G0_0_1_8_4 - 0.00641030844155864*G0_0_1_8_5 + 0.0212033279220787*G0_0_1_8_7 + 0.035503246753248*G0_0_1_8_8 + 0.0285998376623386*G0_0_1_8_9 - 0.00525974025974045*G0_0_1_9_1 + 0.00525974025974044*G0_0_1_9_2 + 0.01479301948052*G0_0_1_9_3 - 0.01479301948052*G0_0_1_9_4 + 0.0128206168831173*G0_0_1_9_5 - 0.0285998376623386*G0_0_1_9_6 - 0.0128206168831174*G0_0_1_9_7 + 0.0285998376623386*G0_0_1_9_8 + 0.000980113636363679*G0_1_0_0_1 - 0.00098011363636367*G0_1_0_0_2 + 0.000164366883116884*G0_1_0_0_3 - 0.000164366883116889*G0_1_0_0_4 - 0.01479301948052*G0_1_0_0_5 + 0.00493100649350665*G0_1_0_0_6 + 0.0147930194805201*G0_1_0_0_7 - 0.0049310064935067*G0_1_0_0_8 + 0.000980113636363679*G0_1_0_1_0 + 0.00196022727272735*G0_1_0_1_1 + 0.00158887987012993*G0_1_0_1_3 - 0.00087662337662341*G0_1_0_1_4 - 0.00213676948051954*G0_1_0_1_5 + 0.00213676948051956*G0_1_0_1_6 + 0.00405438311688326*G0_1_0_1_7 + 0.00109577922077926*G0_1_0_1_8 + 0.00525974025974045*G0_1_0_1_9 - 0.00098011363636367*G0_1_0_2_0 - 0.00196022727272736*G0_1_0_2_2 + 0.000876623376623413*G0_1_0_2_3 - 0.00158887987012994*G0_1_0_2_4 - 0.00405438311688324*G0_1_0_2_5 - 0.00109577922077927*G0_1_0_2_6 + 0.00213676948051956*G0_1_0_2_7 - 0.00213676948051955*G0_1_0_2_8 - 0.00525974025974043*G0_1_0_2_9 + 0.000164366883116884*G0_1_0_3_0 + 0.00158887987012993*G0_1_0_3_1 + 0.000876623376623413*G0_1_0_3_2 + 0.00394480519480536*G0_1_0_3_3 + 0.00295860389610398*G0_1_0_3_5 - 0.00641030844155865*G0_1_0_3_6 - 0.000493100649350699*G0_1_0_3_7 - 0.00591720779220796*G0_1_0_3_8 - 0.01479301948052*G0_1_0_3_9 - 0.000164366883116889*G0_1_0_4_0 - 0.00087662337662341*G0_1_0_4_1 - 0.00158887987012994*G0_1_0_4_2 - 0.00394480519480536*G0_1_0_4_4 + 0.000493100649350676*G0_1_0_4_5 + 0.00591720779220798*G0_1_0_4_6 - 0.002958603896104*G0_1_0_4_7 + 0.00641030844155865*G0_1_0_4_8 + 0.01479301948052*G0_1_0_4_9 - 0.01479301948052*G0_1_0_5_0 - 0.00213676948051954*G0_1_0_5_1 - 0.00405438311688324*G0_1_0_5_2 + 0.00295860389610398*G0_1_0_5_3 + 0.000493100649350675*G0_1_0_5_4 - 0.0936891233766265*G0_1_0_5_5 + 0.0212033279220786*G0_1_0_5_6 + 0.00641030844155863*G0_1_0_5_8 - 0.0128206168831173*G0_1_0_5_9 + 0.00493100649350665*G0_1_0_6_0 + 0.00213676948051956*G0_1_0_6_1 - 0.00109577922077927*G0_1_0_6_2 - 0.00641030844155865*G0_1_0_6_3 + 0.00591720779220798*G0_1_0_6_4 + 0.0212033279220786*G0_1_0_6_5 + 0.035503246753248*G0_1_0_6_6 - 0.00641030844155866*G0_1_0_6_7 + 0.0285998376623386*G0_1_0_6_9 + 0.0147930194805201*G0_1_0_7_0 + 0.00405438311688326*G0_1_0_7_1 + 0.00213676948051956*G0_1_0_7_2 - 0.000493100649350699*G0_1_0_7_3 - 0.002958603896104*G0_1_0_7_4 - 0.00641030844155866*G0_1_0_7_6 + 0.0936891233766269*G0_1_0_7_7 - 0.0212033279220787*G0_1_0_7_8 + 0.0128206168831174*G0_1_0_7_9 - 0.0049310064935067*G0_1_0_8_0 + 0.00109577922077926*G0_1_0_8_1 - 0.00213676948051955*G0_1_0_8_2 - 0.00591720779220796*G0_1_0_8_3 + 0.00641030844155865*G0_1_0_8_4 + 0.00641030844155864*G0_1_0_8_5 - 0.0212033279220787*G0_1_0_8_7 - 0.035503246753248*G0_1_0_8_8 - 0.0285998376623386*G0_1_0_8_9 + 0.00525974025974045*G0_1_0_9_1 - 0.00525974025974044*G0_1_0_9_2 - 0.01479301948052*G0_1_0_9_3 + 0.01479301948052*G0_1_0_9_4 - 0.0128206168831173*G0_1_0_9_5 + 0.0285998376623386*G0_1_0_9_6 + 0.0128206168831174*G0_1_0_9_7 - 0.0285998376623386*G0_1_0_9_8;
    A[34] = -A[37] - 0.00527800324675349*G0_0_0_0_0 - 0.000237418831168845*G0_0_0_0_1 - 0.00738737824675353*G0_0_0_0_2 + 0.00714995941558471*G0_0_0_0_3 + 0.002218952922078*G0_0_0_0_4 - 0.00213676948051958*G0_0_0_0_5 - 0.00682122564935092*G0_0_0_0_6 - 0.00123275162337671*G0_0_0_0_7 + 0.00123275162337669*G0_0_0_0_8 + 0.00345170454545466*G0_0_0_0_9 - 0.000237418831168845*G0_0_0_1_0 + 0.0109577922077926*G0_0_0_1_1 - 0.00211850649350658*G0_0_0_1_2 + 0.0179159902597409*G0_0_0_1_3 - 0.0161079545454551*G0_0_0_1_4 + 0.000493100649350677*G0_0_0_1_5 - 0.00936891233766269*G0_0_0_1_6 - 0.00262987012987023*G0_0_0_1_7 + 0.00920454545454578*G0_0_0_1_8 + 0.00394480519480532*G0_0_0_1_9 - 0.00738737824675353*G0_0_0_2_0 - 0.00211850649350658*G0_0_0_2_1 - 0.0917715097402629*G0_0_0_2_2 + 0.0187378246753253*G0_0_0_2_3 - 0.0468445616883134*G0_0_0_2_4 + 0.0290929383116894*G0_0_0_2_5 - 0.0641030844155867*G0_0_0_2_6 + 0.000493100649350659*G0_0_0_2_7 - 0.00221895292207798*G0_0_0_2_8 - 0.020710227272728*G0_0_0_2_9 + 0.00714995941558471*G0_0_0_3_0 + 0.0179159902597409*G0_0_0_3_1 + 0.0187378246753253*G0_0_0_3_2 + 0.156806006493512*G0_0_0_3_3 + 0.0281067370129881*G0_0_0_3_4 - 0.01479301948052*G0_0_0_3_5 + 0.034763595779222*G0_0_0_3_6 - 0.0147930194805201*G0_0_0_3_7 + 0.00147930194805213*G0_0_0_3_8 + 0.0177516233766242*G0_0_0_3_9 + 0.002218952922078*G0_0_0_4_0 - 0.0161079545454551*G0_0_0_4_1 - 0.0468445616883134*G0_0_0_4_2 + 0.0281067370129881*G0_0_0_4_3 + 0.116864853896108*G0_0_0_4_4 - 0.034763595779222*G0_0_0_4_6 - 0.00739650974025998*G0_0_0_4_7 + 0.0133137175324679*G0_0_0_4_8 + 0.0621306818181839*G0_0_0_4_9 - 0.00213676948051958*G0_0_0_5_0 + 0.000493100649350677*G0_0_0_5_1 + 0.0290929383116894*G0_0_0_5_2 - 0.01479301948052*G0_0_0_5_3 - 0.075444399350652*G0_0_0_5_5 + 0.0525152191558461*G0_0_0_5_6 - 0.010355113636364*G0_0_0_5_7 + 0.005177556818182*G0_0_0_5_8 - 0.020710227272728*G0_0_0_5_9 - 0.00682122564935092*G0_0_0_6_0 - 0.00936891233766269*G0_0_0_6_1 - 0.0641030844155867*G0_0_0_6_2 + 0.034763595779222*G0_0_0_6_3 - 0.034763595779222*G0_0_0_6_4 + 0.0525152191558461*G0_0_0_6_5 - 0.210060876623384*G0_0_0_6_6 + 0.005177556818182*G0_0_0_6_7 + 0.0140533685064939*G0_0_0_6_8 - 0.00739650974026001*G0_0_0_6_9 - 0.00123275162337671*G0_0_0_7_0 - 0.00262987012987023*G0_0_0_7_1 + 0.000493100649350659*G0_0_0_7_2 - 0.0147930194805201*G0_0_0_7_3 - 0.00739650974025998*G0_0_0_7_4 - 0.010355113636364*G0_0_0_7_5 + 0.005177556818182*G0_0_0_7_6 - 0.013313717532468*G0_0_0_7_7 + 0.00147930194805197*G0_0_0_7_8 - 0.020710227272728*G0_0_0_7_9 + 0.00123275162337669*G0_0_0_8_0 + 0.00920454545454578*G0_0_0_8_1 - 0.00221895292207798*G0_0_0_8_2 + 0.00147930194805213*G0_0_0_8_3 + 0.0133137175324679*G0_0_0_8_4 + 0.005177556818182*G0_0_0_8_5 + 0.0140533685064939*G0_0_0_8_6 + 0.00147930194805197*G0_0_0_8_7 - 0.0414204545454559*G0_0_0_8_8 - 0.0384618506493519*G0_0_0_8_9 + 0.00345170454545466*G0_0_0_9_0 + 0.00394480519480532*G0_0_0_9_1 - 0.020710227272728*G0_0_0_9_2 + 0.0177516233766242*G0_0_0_9_3 + 0.0621306818181839*G0_0_0_9_4 - 0.020710227272728*G0_0_0_9_5 - 0.00739650974026*G0_0_0_9_6 - 0.020710227272728*G0_0_0_9_7 - 0.0384618506493519*G0_0_0_9_8 - 0.142012987012992*G0_0_0_9_9 + 0.00252029220779231*G0_0_1_0_0 - 0.00131493506493511*G0_0_1_0_1 - 0.00169845779220786*G0_0_1_0_2 + 0.0187378246753254*G0_0_1_0_3 + 0.011834415584416*G0_0_1_0_4 - 0.00345170454545466*G0_0_1_0_5 + 0.000493100649350651*G0_0_1_0_6 - 0.002958603896104*G0_0_1_0_7 + 0.00345170454545467*G0_0_1_0_8 + 0.026627435064936*G0_0_1_0_9 - 0.00131493506493511*G0_0_1_1_0 + 0.00657467532467554*G0_0_1_1_1 + 0.0019176136363637*G0_0_1_1_2 - 0.0157792207792213*G0_0_1_1_4 + 0.00345170454545466*G0_0_1_1_5 - 0.00295860389610401*G0_0_1_1_6 + 0.00394480519480532*G0_0_1_1_7 - 0.00788961038961063*G0_0_1_1_9 - 0.00169845779220786*G0_0_1_2_0 + 0.0019176136363637*G0_0_1_2_1 - 0.0082183441558445*G0_0_1_2_2 - 0.0246550324675334*G0_0_1_2_4 + 0.00690340909090935*G0_0_1_2_5 - 0.00986201298701339*G0_0_1_2_6 + 0.000493100649350663*G0_0_1_2_7 - 0.00345170454545465*G0_0_1_2_8 - 0.0216964285714293*G0_0_1_2_9 + 0.0187378246753254*G0_0_1_3_0 + 0.386097808441572*G0_0_1_3_3 + 0.0399411525974042*G0_0_1_3_4 - 0.034023944805196*G0_0_1_3_5 + 0.010355113636364*G0_0_1_3_6 - 0.054734172077924*G0_0_1_3_7 + 0.0428997564935081*G0_0_1_3_8 + 0.13313717532468*G0_0_1_3_9 + 0.011834415584416*G0_0_1_4_0 - 0.0157792207792213*G0_0_1_4_1 - 0.0246550324675334*G0_0_1_4_2 + 0.0399411525974042*G0_0_1_4_3 + 0.252960633116892*G0_0_1_4_4 - 0.0340239448051959*G0_0_1_4_5 + 0.023668831168832*G0_0_1_4_6 - 0.019230925324676*G0_0_1_4_7 + 0.0118344155844159*G0_0_1_4_8 + 0.13313717532468*G0_0_1_4_9 - 0.00345170454545466*G0_0_1_5_0 + 0.00345170454545466*G0_0_1_5_1 + 0.00690340909090935*G0_0_1_5_2 - 0.034023944805196*G0_0_1_5_3 - 0.0340239448051959*G0_0_1_5_4 + 0.016272321428572*G0_0_1_5_5 - 0.00147930194805195*G0_0_1_5_6 + 0.00887581168831201*G0_0_1_5_7 - 0.008875811688312*G0_0_1_5_8 - 0.0621306818181838*G0_0_1_5_9 + 0.000493100649350651*G0_0_1_6_0 - 0.00295860389610401*G0_0_1_6_1 - 0.00986201298701339*G0_0_1_6_2 + 0.010355113636364*G0_0_1_6_3 + 0.023668831168832*G0_0_1_6_4 - 0.00147930194805195*G0_0_1_6_5 - 0.0192309253246761*G0_0_1_6_6 + 0.00887581168831198*G0_0_1_6_8 + 0.0443790584415599*G0_0_1_6_9 - 0.002958603896104*G0_0_1_7_0 + 0.00394480519480532*G0_0_1_7_1 + 0.000493100649350663*G0_0_1_7_2 - 0.054734172077924*G0_0_1_7_3 - 0.019230925324676*G0_0_1_7_4 + 0.00887581168831201*G0_0_1_7_5 - 0.00739650974025998*G0_0_1_7_7 - 0.011834415584416*G0_0_1_7_8 - 0.0798823051948079*G0_0_1_7_9 + 0.00345170454545467*G0_0_1_8_0 - 0.00345170454545465*G0_0_1_8_2 + 0.0428997564935081*G0_0_1_8_3 + 0.0118344155844159*G0_0_1_8_4 - 0.008875811688312*G0_0_1_8_5 + 0.00887581168831198*G0_0_1_8_6 - 0.011834415584416*G0_0_1_8_7 - 0.0428997564935079*G0_0_1_8_8 + 0.026627435064936*G0_0_1_9_0 - 0.00788961038961063*G0_0_1_9_1 - 0.0216964285714293*G0_0_1_9_2 + 0.13313717532468*G0_0_1_9_3 + 0.13313717532468*G0_0_1_9_4 - 0.0621306818181838*G0_0_1_9_5 + 0.0443790584415599*G0_0_1_9_6 - 0.0798823051948079*G0_0_1_9_7 + 0.159764610389616*G0_0_1_9_9 - 0.00398133116883123*G0_1_0_0_0 + 0.00282163149350661*G0_1_0_0_1 - 0.000620941558441571*G0_1_0_0_2 + 0.00599939123376648*G0_1_0_0_3 - 0.0023833198051949*G0_1_0_0_4 - 0.00221895292207797*G0_1_0_0_5 - 0.00328733766233774*G0_1_0_0_7 + 0.00262987012987021*G0_1_0_0_8 - 0.00197240259740265*G0_1_0_0_9 + 0.00282163149350661*G0_1_0_1_0 + 0.0816355519480546*G0_1_0_1_1 + 0.00528713474025991*G0_1_0_1_2 + 0.0591720779220798*G0_1_0_1_3 - 0.0295860389610399*G0_1_0_1_4 - 0.000904017857142883*G0_1_0_1_5 - 0.00336952110389622*G0_1_0_1_6 - 0.01479301948052*G0_1_0_1_7 + 0.0345170454545467*G0_1_0_1_8 + 0.00986201298701335*G0_1_0_1_9 - 0.000620941558441571*G0_1_0_2_0 + 0.00528713474025991*G0_1_0_2_1 - 0.00518668831168841*G0_1_0_2_2 + 0.00904017857142886*G0_1_0_2_3 - 0.00969764610389641*G0_1_0_2_4 + 0.00147930194805198*G0_1_0_2_5 - 0.00271205357142862*G0_1_0_2_6 - 0.00139711850649356*G0_1_0_2_7 - 0.00435572240259754*G0_1_0_2_8 - 0.00690340909090931*G0_1_0_2_9 + 0.00599939123376648*G0_1_0_3_0 + 0.0591720779220799*G0_1_0_3_1 + 0.00904017857142886*G0_1_0_3_2 + 0.164202516233772*G0_1_0_3_3 - 0.0184912743506499*G0_1_0_3_4 - 0.00739650974026*G0_1_0_3_5 + 0.00961546266233794*G0_1_0_3_6 - 0.0184912743506501*G0_1_0_3_7 + 0.00591720779220817*G0_1_0_3_8 + 0.00739650974026017*G0_1_0_3_9 - 0.0023833198051949*G0_1_0_4_0 - 0.0295860389610399*G0_1_0_4_1 - 0.00969764610389641*G0_1_0_4_2 - 0.0184912743506499*G0_1_0_4_3 - 0.010355113636364*G0_1_0_4_4 + 0.00665685876623399*G0_1_0_4_5 - 0.016272321428572*G0_1_0_4_6 + 0.00591720779220803*G0_1_0_4_7 + 0.0125740665584419*G0_1_0_4_8 + 0.00739650974025996*G0_1_0_4_9 - 0.00221895292207797*G0_1_0_5_0 - 0.000904017857142884*G0_1_0_5_1 + 0.00147930194805198*G0_1_0_5_2 - 0.00739650974026*G0_1_0_5_3 + 0.00665685876623399*G0_1_0_5_4 - 0.0133137175324679*G0_1_0_5_5 + 0.00887581168831194*G0_1_0_5_6 - 0.00591720779220796*G0_1_0_5_7 + 0.00221895292207798*G0_1_0_5_8 + 0.00147930194805198*G0_1_0_5_9 - 0.00336952110389622*G0_1_0_6_1 - 0.00271205357142862*G0_1_0_6_2 + 0.00961546266233794*G0_1_0_6_3 - 0.016272321428572*G0_1_0_6_4 + 0.00887581168831193*G0_1_0_6_5 - 0.0221895292207798*G0_1_0_6_6 + 0.00369825487012999*G0_1_0_6_7 + 0.011834415584416*G0_1_0_6_8 + 0.00147930194805201*G0_1_0_6_9 - 0.00328733766233774*G0_1_0_7_0 - 0.01479301948052*G0_1_0_7_1 - 0.00139711850649356*G0_1_0_7_2 - 0.0184912743506501*G0_1_0_7_3 + 0.00591720779220803*G0_1_0_7_4 - 0.00591720779220796*G0_1_0_7_5 + 0.00369825487012999*G0_1_0_7_6 - 0.0162723214285719*G0_1_0_7_7 - 0.00221895292207811*G0_1_0_7_8 - 0.00147930194805207*G0_1_0_7_9 + 0.00262987012987021*G0_1_0_8_0 + 0.0345170454545467*G0_1_0_8_1 - 0.00435572240259754*G0_1_0_8_2 + 0.00591720779220816*G0_1_0_8_3 + 0.0125740665584419*G0_1_0_8_4 + 0.00221895292207798*G0_1_0_8_5 + 0.011834415584416*G0_1_0_8_6 - 0.00221895292207811*G0_1_0_8_7 - 0.116864853896108*G0_1_0_8_8 - 0.0547341720779239*G0_1_0_8_9 - 0.00197240259740265*G0_1_0_9_0 + 0.00986201298701335*G0_1_0_9_1 - 0.00690340909090931*G0_1_0_9_2 + 0.00739650974026017*G0_1_0_9_3 + 0.00739650974025996*G0_1_0_9_4 + 0.00147930194805198*G0_1_0_9_5 + 0.00147930194805201*G0_1_0_9_6 - 0.00147930194805208*G0_1_0_9_7 - 0.0547341720779239*G0_1_0_9_8 - 0.0710064935064959*G0_1_0_9_9 + 0.00120535714285718*G0_1_1_0_0 - 0.00246550324675334*G0_1_1_0_1 + 0.010355113636364*G0_1_1_0_3 - 0.00098620129870134*G0_1_1_0_4 + 0.000493100649350657*G0_1_1_0_5 - 0.001479301948052*G0_1_1_0_6 + 0.00641030844155864*G0_1_1_0_7 - 0.00641030844155867*G0_1_1_0_8 + 0.00493100649350669*G0_1_1_0_9 - 0.00246550324675334*G0_1_1_1_0 + 0.00246550324675333*G0_1_1_1_2 + 0.0246550324675333*G0_1_1_1_3 - 0.01479301948052*G0_1_1_1_4 + 0.00246550324675333*G0_1_1_1_5 - 0.00246550324675334*G0_1_1_1_6 + 0.01479301948052*G0_1_1_1_7 - 0.0246550324675334*G0_1_1_1_8 + 0.00246550324675333*G0_1_1_2_1 - 0.00120535714285718*G0_1_1_2_2 + 0.00641030844155866*G0_1_1_2_3 - 0.00641030844155867*G0_1_1_2_4 + 0.00147930194805199*G0_1_1_2_5 - 0.000493100649350667*G0_1_1_2_6 + 0.000986201298701316*G0_1_1_2_7 - 0.010355113636364*G0_1_1_2_8 - 0.00493100649350666*G0_1_1_2_9 + 0.010355113636364*G0_1_1_3_0 + 0.0246550324675333*G0_1_1_3_1 + 0.00641030844155866*G0_1_1_3_2 + 0.28106737012988*G0_1_1_3_3 - 0.016272321428572*G0_1_1_3_4 - 0.019230925324676*G0_1_1_3_5 + 0.00739650974025996*G0_1_1_3_6 - 0.0310653409090921*G0_1_1_3_7 + 0.0621306818181842*G0_1_1_3_9 - 0.00098620129870134*G0_1_1_4_0 - 0.01479301948052*G0_1_1_4_1 - 0.00641030844155867*G0_1_1_4_2 - 0.016272321428572*G0_1_1_4_3 + 0.00591720779220796*G0_1_1_4_4 + 0.002958603896104*G0_1_1_4_5 - 0.010355113636364*G0_1_1_4_6 + 0.0310653409090919*G0_1_1_4_8 + 0.00887581168831196*G0_1_1_4_9 + 0.000493100649350657*G0_1_1_5_0 + 0.00246550324675333*G0_1_1_5_1 + 0.00147930194805199*G0_1_1_5_2 - 0.019230925324676*G0_1_1_5_3 + 0.002958603896104*G0_1_1_5_4 + 0.00887581168831197*G0_1_1_5_5 + 0.010355113636364*G0_1_1_5_7 - 0.00739650974025998*G0_1_1_5_8 - 0.001479301948052*G0_1_1_6_0 - 0.00246550324675334*G0_1_1_6_1 - 0.000493100649350667*G0_1_1_6_2 + 0.00739650974025996*G0_1_1_6_3 - 0.010355113636364*G0_1_1_6_4 - 0.00887581168831199*G0_1_1_6_6 - 0.00295860389610395*G0_1_1_6_7 + 0.0192309253246759*G0_1_1_6_8 + 0.00641030844155864*G0_1_1_7_0 + 0.01479301948052*G0_1_1_7_1 + 0.000986201298701316*G0_1_1_7_2 - 0.0310653409090921*G0_1_1_7_3 + 0.010355113636364*G0_1_1_7_5 - 0.00295860389610395*G0_1_1_7_6 - 0.00591720779220818*G0_1_1_7_7 + 0.016272321428572*G0_1_1_7_8 - 0.00887581168831213*G0_1_1_7_9 - 0.00641030844155867*G0_1_1_8_0 - 0.0246550324675334*G0_1_1_8_1 - 0.010355113636364*G0_1_1_8_2 + 0.0310653409090919*G0_1_1_8_4 - 0.00739650974025998*G0_1_1_8_5 + 0.0192309253246759*G0_1_1_8_6 + 0.016272321428572*G0_1_1_8_7 - 0.28106737012988*G0_1_1_8_8 - 0.0621306818181838*G0_1_1_8_9 + 0.00493100649350668*G0_1_1_9_0 - 0.00493100649350666*G0_1_1_9_2 + 0.0621306818181842*G0_1_1_9_3 + 0.00887581168831196*G0_1_1_9_4 - 0.00887581168831213*G0_1_1_9_7 - 0.0621306818181838*G0_1_1_9_8;
    A[75] = -A[34] - 0.0259151785714295*G0_0_0_0_0 - 0.00259334415584425*G0_0_0_0_1 - 0.011076501623377*G0_0_0_0_2 + 0.00419135551948069*G0_0_0_0_3 + 0.00419135551948067*G0_0_0_0_4 - 0.0343526785714297*G0_0_0_0_5 + 0.00780742694805215*G0_0_0_0_6 - 0.0191487418831176*G0_0_0_0_7 + 0.00797179383116912*G0_0_0_0_8 - 0.00641030844155868*G0_0_0_0_9 - 0.00259334415584425*G0_0_0_1_0 + 0.000803571428571408*G0_0_0_1_1 - 0.00483969155844174*G0_0_0_1_2 + 0.000328733766233758*G0_0_0_1_3 - 0.00460227272727289*G0_0_0_1_4 - 0.00641030844155863*G0_0_0_1_5 - 0.0049310064935067*G0_0_0_1_6 - 0.00394480519480532*G0_0_0_1_7 + 0.000986201298701317*G0_0_0_1_8 - 0.00493100649350667*G0_0_0_1_9 - 0.011076501623377*G0_0_0_2_0 - 0.00483969155844174*G0_0_0_2_1 - 0.0917715097402629*G0_0_0_2_2 + 0.017751623376624*G0_0_0_2_3 - 0.04437905844156*G0_0_0_2_4 + 0.0231757305194814*G0_0_0_2_5 - 0.06656858766234*G0_0_0_2_6 + 0.000493100649350662*G0_0_0_2_7 + 0.00419135551948066*G0_0_0_2_8 - 0.0138068181818187*G0_0_0_2_9 + 0.00419135551948069*G0_0_0_3_0 + 0.000328733766233758*G0_0_0_3_1 + 0.017751623376624*G0_0_0_3_2 + 0.0384618506493522*G0_0_0_3_3 + 0.0266274350649361*G0_0_0_3_4 - 0.00295860389610406*G0_0_0_3_5 + 0.027367086038962*G0_0_0_3_6 + 0.0147930194805201*G0_0_0_3_9 + 0.00419135551948067*G0_0_0_4_0 - 0.00460227272727289*G0_0_0_4_1 - 0.04437905844156*G0_0_0_4_2 + 0.0266274350649361*G0_0_0_4_3 + 0.116864853896108*G0_0_0_4_4 - 0.0273670860389621*G0_0_0_4_6 - 0.013313717532468*G0_0_0_4_7 + 0.0414204545454559*G0_0_0_4_9 - 0.0343526785714297*G0_0_0_5_0 - 0.00641030844155863*G0_0_0_5_1 + 0.0231757305194814*G0_0_0_5_2 - 0.00295860389610406*G0_0_0_5_3 - 0.247043425324684*G0_0_0_5_5 + 0.088018465909094*G0_0_0_5_6 - 0.0428997564935079*G0_0_0_5_7 + 0.031804991883118*G0_0_0_5_8 - 0.04437905844156*G0_0_0_5_9 + 0.00780742694805215*G0_0_0_6_0 - 0.0049310064935067*G0_0_0_6_1 - 0.06656858766234*G0_0_0_6_2 + 0.027367086038962*G0_0_0_6_3 - 0.0273670860389621*G0_0_0_6_4 + 0.088018465909094*G0_0_0_6_5 - 0.224853896103904*G0_0_0_6_6 + 0.01109476461039*G0_0_0_6_7 - 0.005177556818182*G0_0_0_6_8 - 0.013313717532468*G0_0_0_6_9 - 0.0191487418831176*G0_0_0_7_0 - 0.00394480519480532*G0_0_0_7_1 + 0.000493100649350663*G0_0_0_7_2 - 0.013313717532468*G0_0_0_7_4 - 0.0428997564935079*G0_0_0_7_5 + 0.01109476461039*G0_0_0_7_6 - 0.0133137175324679*G0_0_0_7_7 + 0.020710227272728*G0_0_0_7_8 - 0.002958603896104*G0_0_0_7_9 + 0.00797179383116912*G0_0_0_8_0 + 0.000986201298701316*G0_0_0_8_1 + 0.00419135551948066*G0_0_0_8_2 + 0.031804991883118*G0_0_0_8_5 - 0.005177556818182*G0_0_0_8_6 + 0.020710227272728*G0_0_0_8_7 - 0.00295860389610397*G0_0_0_8_8 + 0.01479301948052*G0_0_0_8_9 - 0.00641030844155867*G0_0_0_9_0 - 0.00493100649350667*G0_0_0_9_1 - 0.0138068181818187*G0_0_0_9_2 + 0.0147930194805201*G0_0_0_9_3 + 0.0414204545454559*G0_0_0_9_4 - 0.04437905844156*G0_0_0_9_5 - 0.013313717532468*G0_0_0_9_6 - 0.002958603896104*G0_0_0_9_7 + 0.01479301948052*G0_0_0_9_8 + 0.17751623376624*G0_0_0_9_9 + 0.16871347402598*G0_0_1_0_0 + 0.00730519480519505*G0_0_1_0_1 + 0.00730519480519503*G0_0_1_0_2 + 0.010355113636364*G0_0_1_0_3 + 0.010355113636364*G0_0_1_0_4 + 0.0876075487013016*G0_0_1_0_5 - 0.0391193181818195*G0_0_1_0_6 + 0.0876075487013017*G0_0_1_0_7 - 0.0391193181818195*G0_0_1_0_8 + 0.0364894480519494*G0_0_1_0_9 + 0.00730519480519505*G0_0_1_1_0 - 0.00445616883116898*G0_0_1_1_1 + 0.000547889610389627*G0_0_1_1_2 - 0.0197240259740266*G0_0_1_1_3 - 0.00345170454545468*G0_0_1_1_4 + 0.00986201298701332*G0_0_1_1_5 - 0.00419135551948066*G0_0_1_1_6 + 0.0195596590909098*G0_0_1_1_7 - 0.0156970373376629*G0_0_1_1_8 - 0.0108482142857146*G0_0_1_1_9 + 0.00730519480519503*G0_0_1_2_0 + 0.000547889610389627*G0_0_1_2_1 - 0.00445616883116901*G0_0_1_2_2 - 0.00345170454545468*G0_0_1_2_3 - 0.0197240259740267*G0_0_1_2_4 + 0.0195596590909098*G0_0_1_2_5 - 0.0156970373376629*G0_0_1_2_6 + 0.00986201298701331*G0_0_1_2_7 - 0.00419135551948066*G0_0_1_2_8 - 0.0108482142857146*G0_0_1_2_9 + 0.010355113636364*G0_0_1_3_0 - 0.0197240259740266*G0_0_1_3_1 - 0.00345170454545468*G0_0_1_3_2 + 0.241126217532476*G0_0_1_3_3 + 0.0414204545454562*G0_0_1_3_4 - 0.026627435064936*G0_0_1_3_5 + 0.00517755681818203*G0_0_1_3_6 - 0.038461850649352*G0_0_1_3_7 + 0.03328429383117*G0_0_1_3_8 + 0.109468344155848*G0_0_1_3_9 + 0.010355113636364*G0_0_1_4_0 - 0.00345170454545468*G0_0_1_4_1 - 0.0197240259740267*G0_0_1_4_2 + 0.0414204545454561*G0_0_1_4_3 + 0.241126217532476*G0_0_1_4_4 - 0.0384618506493519*G0_0_1_4_5 + 0.03328429383117*G0_0_1_4_6 - 0.026627435064936*G0_0_1_4_7 + 0.005177556818182*G0_0_1_4_8 + 0.109468344155848*G0_0_1_4_9 + 0.0876075487013016*G0_0_1_5_0 + 0.00986201298701332*G0_0_1_5_1 + 0.0195596590909098*G0_0_1_5_2 - 0.026627435064936*G0_0_1_5_3 - 0.0384618506493519*G0_0_1_5_4 + 0.102071834415588*G0_0_1_5_5 - 0.0650892857142878*G0_0_1_5_6 + 0.0739650974025998*G0_0_1_5_7 - 0.0369825487013*G0_0_1_5_8 - 0.0355032467532478*G0_0_1_5_9 - 0.0391193181818195*G0_0_1_6_0 - 0.00419135551948067*G0_0_1_6_1 - 0.0156970373376629*G0_0_1_6_2 + 0.00517755681818202*G0_0_1_6_3 + 0.03328429383117*G0_0_1_6_4 - 0.0650892857142878*G0_0_1_6_5 + 0.0118344155844159*G0_0_1_6_6 - 0.0369825487012999*G0_0_1_6_7 + 0.016272321428572*G0_0_1_6_8 + 0.0221895292207799*G0_0_1_6_9 + 0.0876075487013016*G0_0_1_7_0 + 0.0195596590909098*G0_0_1_7_1 + 0.00986201298701331*G0_0_1_7_2 - 0.038461850649352*G0_0_1_7_3 - 0.026627435064936*G0_0_1_7_4 + 0.0739650974025998*G0_0_1_7_5 - 0.0369825487012999*G0_0_1_7_6 + 0.102071834415588*G0_0_1_7_7 - 0.065089285714288*G0_0_1_7_8 - 0.0355032467532479*G0_0_1_7_9 - 0.0391193181818195*G0_0_1_8_0 - 0.0156970373376629*G0_0_1_8_1 - 0.00419135551948066*G0_0_1_8_2 + 0.03328429383117*G0_0_1_8_3 + 0.005177556818182*G0_0_1_8_4 - 0.0369825487013*G0_0_1_8_5 + 0.016272321428572*G0_0_1_8_6 - 0.065089285714288*G0_0_1_8_7 + 0.011834415584416*G0_0_1_8_8 + 0.0221895292207799*G0_0_1_8_9 + 0.0364894480519494*G0_0_1_9_0 - 0.0108482142857146*G0_0_1_9_1 - 0.0108482142857146*G0_0_1_9_2 + 0.109468344155848*G0_0_1_9_3 + 0.109468344155848*G0_0_1_9_4 - 0.0355032467532478*G0_0_1_9_5 + 0.0221895292207799*G0_0_1_9_6 - 0.0355032467532479*G0_0_1_9_7 + 0.0221895292207799*G0_0_1_9_8 + 0.443790584415599*G0_0_1_9_9 + 0.00505884740259758*G0_1_0_0_0 - 0.00036525974025976*G0_1_0_0_1 - 0.000365259740259749*G0_1_0_0_2 + 0.00156148538961045*G0_1_0_0_3 + 0.00156148538961045*G0_1_0_0_4 + 0.00156148538961045*G0_1_0_0_5 - 0.00287642045454554*G0_1_0_0_6 + 0.00156148538961045*G0_1_0_0_7 - 0.00287642045454556*G0_1_0_0_8 - 0.0108482142857146*G0_1_0_0_9 - 0.00036525974025976*G0_1_0_1_0 - 0.00109577922077936*G0_1_0_1_1 - 0.00616375811688336*G0_1_0_1_3 - 0.000986201298701325*G0_1_0_1_4 + 0.00994419642857176*G0_1_0_1_5 - 0.00238331980519489*G0_1_0_1_6 + 0.00838271103896136*G0_1_0_1_7 - 0.00862926136363673*G0_1_0_1_8 + 0.00739650974026*G0_1_0_1_9 - 0.000365259740259749*G0_1_0_2_0 - 0.00109577922077915*G0_1_0_2_2 - 0.000986201298701354*G0_1_0_2_3 - 0.00616375811688331*G0_1_0_2_4 + 0.0083827110389613*G0_1_0_2_5 - 0.00862926136363658*G0_1_0_2_6 + 0.00994419642857178*G0_1_0_2_7 - 0.0023833198051949*G0_1_0_2_8 + 0.00739650974026001*G0_1_0_2_9 + 0.00156148538961045*G0_1_0_3_0 - 0.00616375811688336*G0_1_0_3_1 - 0.000986201298701354*G0_1_0_3_2 + 0.0310653409090922*G0_1_0_3_3 + 0.017751623376624*G0_1_0_3_4 - 0.016272321428572*G0_1_0_3_5 + 0.00517755681818199*G0_1_0_3_6 - 0.00665685876623401*G0_1_0_3_7 + 0.00147930194805198*G0_1_0_3_8 - 0.00887581168831195*G0_1_0_3_9 + 0.00156148538961045*G0_1_0_4_0 - 0.000986201298701325*G0_1_0_4_1 - 0.00616375811688331*G0_1_0_4_2 + 0.017751623376624*G0_1_0_4_3 + 0.0310653409090919*G0_1_0_4_4 - 0.00665685876623402*G0_1_0_4_5 + 0.00147930194805203*G0_1_0_4_6 - 0.016272321428572*G0_1_0_4_7 + 0.00517755681818202*G0_1_0_4_8 - 0.00887581168831204*G0_1_0_4_9 + 0.00156148538961045*G0_1_0_5_0 + 0.00994419642857176*G0_1_0_5_1 + 0.0083827110389613*G0_1_0_5_2 - 0.016272321428572*G0_1_0_5_3 - 0.00665685876623402*G0_1_0_5_4 + 0.0931960227272759*G0_1_0_5_5 - 0.019230925324676*G0_1_0_5_6 + 0.063609983766236*G0_1_0_5_7 - 0.031804991883118*G0_1_0_5_8 + 0.0961546266233799*G0_1_0_5_9 - 0.00287642045454554*G0_1_0_6_0 - 0.00238331980519489*G0_1_0_6_1 - 0.00862926136363658*G0_1_0_6_2 + 0.00517755681818199*G0_1_0_6_3 + 0.00147930194805203*G0_1_0_6_4 - 0.019230925324676*G0_1_0_6_5 + 0.0103551136363641*G0_1_0_6_6 - 0.031804991883118*G0_1_0_6_7 + 0.00813616071428601*G0_1_0_6_8 - 0.032544642857144*G0_1_0_6_9 + 0.00156148538961045*G0_1_0_7_0 + 0.00838271103896136*G0_1_0_7_1 + 0.00994419642857178*G0_1_0_7_2 - 0.00665685876623401*G0_1_0_7_3 - 0.016272321428572*G0_1_0_7_4 + 0.063609983766236*G0_1_0_7_5 - 0.031804991883118*G0_1_0_7_6 + 0.0931960227272761*G0_1_0_7_7 - 0.019230925324676*G0_1_0_7_8 + 0.09615462662338*G0_1_0_7_9 - 0.00287642045454556*G0_1_0_8_0 - 0.00862926136363673*G0_1_0_8_1 - 0.0023833198051949*G0_1_0_8_2 + 0.00147930194805198*G0_1_0_8_3 + 0.00517755681818202*G0_1_0_8_4 - 0.031804991883118*G0_1_0_8_5 + 0.00813616071428601*G0_1_0_8_6 - 0.019230925324676*G0_1_0_8_7 + 0.0103551136363639*G0_1_0_8_8 - 0.032544642857144*G0_1_0_8_9 - 0.0108482142857146*G0_1_0_9_0 + 0.00739650974026*G0_1_0_9_1 + 0.00739650974026001*G0_1_0_9_2 - 0.00887581168831195*G0_1_0_9_3 - 0.00887581168831205*G0_1_0_9_4 + 0.0961546266233799*G0_1_0_9_5 - 0.032544642857144*G0_1_0_9_6 + 0.09615462662338*G0_1_0_9_7 - 0.032544642857144*G0_1_0_9_8 + 0.26627435064936*G0_1_0_9_9 - 0.0259151785714295*G0_1_1_0_0 - 0.011076501623377*G0_1_1_0_1 - 0.00259334415584424*G0_1_1_0_2 + 0.00419135551948068*G0_1_1_0_3 + 0.00419135551948068*G0_1_1_0_4 - 0.0191487418831175*G0_1_1_0_5 + 0.0079717938311691*G0_1_1_0_6 - 0.0343526785714298*G0_1_1_0_7 + 0.0078074269480522*G0_1_1_0_8 - 0.00641030844155866*G0_1_1_0_9 - 0.011076501623377*G0_1_1_1_0 - 0.0917715097402629*G0_1_1_1_1 - 0.00483969155844171*G0_1_1_1_2 - 0.0443790584415599*G0_1_1_1_3 + 0.017751623376624*G0_1_1_1_4 + 0.000493100649350664*G0_1_1_1_5 + 0.00419135551948065*G0_1_1_1_6 + 0.0231757305194814*G0_1_1_1_7 - 0.0665685876623401*G0_1_1_1_8 - 0.0138068181818187*G0_1_1_1_9 - 0.00259334415584424*G0_1_1_2_0 - 0.00483969155844172*G0_1_1_2_1 + 0.000803571428571487*G0_1_1_2_2 - 0.00460227272727289*G0_1_1_2_3 + 0.000328733766233772*G0_1_1_2_4 - 0.00394480519480533*G0_1_1_2_5 + 0.000986201298701349*G0_1_1_2_6 - 0.00641030844155867*G0_1_1_2_7 - 0.00493100649350666*G0_1_1_2_8 - 0.00493100649350667*G0_1_1_2_9 + 0.00419135551948068*G0_1_1_3_0 - 0.0443790584415599*G0_1_1_3_1 - 0.00460227272727289*G0_1_1_3_2 + 0.116864853896108*G0_1_1_3_3 + 0.026627435064936*G0_1_1_3_4 - 0.013313717532468*G0_1_1_3_5 - 0.027367086038962*G0_1_1_3_8 + 0.0414204545454561*G0_1_1_3_9 + 0.00419135551948068*G0_1_1_4_0 + 0.017751623376624*G0_1_1_4_1 + 0.000328733766233772*G0_1_1_4_2 + 0.026627435064936*G0_1_1_4_3 + 0.0384618506493519*G0_1_1_4_4 - 0.00295860389610397*G0_1_1_4_7 + 0.027367086038962*G0_1_1_4_8 + 0.01479301948052*G0_1_1_4_9 - 0.0191487418831175*G0_1_1_5_0 + 0.000493100649350664*G0_1_1_5_1 - 0.00394480519480533*G0_1_1_5_2 - 0.013313717532468*G0_1_1_5_3 - 0.013313717532468*G0_1_1_5_5 + 0.020710227272728*G0_1_1_5_6 - 0.042899756493508*G0_1_1_5_7 + 0.01109476461039*G0_1_1_5_8 - 0.00295860389610406*G0_1_1_5_9 + 0.0079717938311691*G0_1_1_6_0 + 0.00419135551948066*G0_1_1_6_1 + 0.000986201298701349*G0_1_1_6_2 + 0.020710227272728*G0_1_1_6_5 - 0.00295860389610405*G0_1_1_6_6 + 0.031804991883118*G0_1_1_6_7 - 0.00517755681818202*G0_1_1_6_8 + 0.01479301948052*G0_1_1_6_9 - 0.0343526785714298*G0_1_1_7_0 + 0.0231757305194814*G0_1_1_7_1 - 0.00641030844155867*G0_1_1_7_2 - 0.00295860389610397*G0_1_1_7_4 - 0.042899756493508*G0_1_1_7_5 + 0.031804991883118*G0_1_1_7_6 - 0.247043425324684*G0_1_1_7_7 + 0.0880184659090941*G0_1_1_7_8 - 0.0443790584415601*G0_1_1_7_9 + 0.0078074269480522*G0_1_1_8_0 - 0.0665685876623401*G0_1_1_8_1 - 0.00493100649350666*G0_1_1_8_2 - 0.027367086038962*G0_1_1_8_3 + 0.027367086038962*G0_1_1_8_4 + 0.01109476461039*G0_1_1_8_5 - 0.00517755681818202*G0_1_1_8_6 + 0.0880184659090941*G0_1_1_8_7 - 0.224853896103904*G0_1_1_8_8 - 0.013313717532468*G0_1_1_8_9 - 0.00641030844155866*G0_1_1_9_0 - 0.0138068181818187*G0_1_1_9_1 - 0.00493100649350667*G0_1_1_9_2 + 0.0414204545454561*G0_1_1_9_3 + 0.01479301948052*G0_1_1_9_4 - 0.00295860389610406*G0_1_1_9_5 + 0.01479301948052*G0_1_1_9_6 - 0.0443790584415601*G0_1_1_9_7 - 0.013313717532468*G0_1_1_9_8 + 0.17751623376624*G0_1_1_9_9;
    A[36] = -A[34] + 0.00341517857142874*G0_0_1_0_0 - 0.00166193181818187*G0_0_1_0_1 + 0.00249289772727283*G0_0_1_0_2 + 0.0119165990259745*G0_0_1_0_3 + 0.0114234983766238*G0_0_1_0_4 - 0.00378043831168845*G0_0_1_0_5 + 0.00928672889610422*G0_0_1_0_6 - 0.00419135551948065*G0_0_1_0_7 + 0.00221895292207799*G0_0_1_0_8 + 0.0261343344155853*G0_0_1_0_9 - 0.00166193181818187*G0_0_1_1_0 - 0.00611810064935085*G0_0_1_1_1 + 0.00325994318181831*G0_0_1_1_2 - 0.0190665584415591*G0_0_1_1_3 - 0.000575284090909116*G0_0_1_1_4 - 0.000410917207792231*G0_0_1_1_5 - 0.000410917207792213*G0_0_1_1_6 + 0.00714995941558466*G0_0_1_1_7 - 0.0101085633116887*G0_0_1_1_8 - 0.0172585227272733*G0_0_1_1_9 + 0.00249289772727283*G0_0_1_2_0 + 0.00325994318181831*G0_0_1_2_1 + 0.0717735389610414*G0_0_1_2_2 - 0.0172585227272733*G0_0_1_2_3 + 0.01479301948052*G0_0_1_2_4 - 0.0123275162337667*G0_0_1_2_5 + 0.0394480519480534*G0_0_1_2_6 + 0.00156148538961044*G0_0_1_2_7 - 0.00238331980519488*G0_0_1_2_8 - 0.00493100649350665*G0_0_1_2_9 + 0.0119165990259745*G0_0_1_3_0 - 0.0190665584415591*G0_0_1_3_1 - 0.0172585227272733*G0_0_1_3_2 + 0.2218952922078*G0_0_1_3_3 + 0.0229291801948061*G0_0_1_3_4 - 0.016272321428572*G0_0_1_3_5 - 0.000739650974026024*G0_0_1_3_6 - 0.037722199675326*G0_0_1_3_7 + 0.032544642857144*G0_0_1_3_8 + 0.127219967532472*G0_0_1_3_9 + 0.0114234983766238*G0_0_1_4_0 - 0.000575284090909115*G0_0_1_4_1 + 0.01479301948052*G0_0_1_4_2 + 0.0229291801948061*G0_0_1_4_3 + 0.1479301948052*G0_0_1_4_4 - 0.036242897727274*G0_0_1_4_5 + 0.0369825487013*G0_0_1_4_6 - 0.01849127435065*G0_0_1_4_7 + 0.00517755681818198*G0_0_1_4_8 + 0.0872788149350679*G0_0_1_4_9 - 0.00378043831168845*G0_0_1_5_0 - 0.000410917207792229*G0_0_1_5_1 - 0.0123275162337667*G0_0_1_5_2 - 0.016272321428572*G0_0_1_5_3 - 0.036242897727274*G0_0_1_5_4 - 0.0325446428571439*G0_0_1_5_5 - 0.045118709415586*G0_0_1_5_6 + 0.00739650974025999*G0_0_1_5_7 - 0.000739650974026003*G0_0_1_5_8 - 0.0769237012987039*G0_0_1_5_9 + 0.00928672889610422*G0_0_1_6_0 - 0.000410917207792214*G0_0_1_6_1 + 0.0394480519480534*G0_0_1_6_2 - 0.000739650974026024*G0_0_1_6_3 + 0.0369825487013*G0_0_1_6_4 - 0.045118709415586*G0_0_1_6_5 - 0.00665685876623399*G0_0_1_6_7 + 0.00517755681818198*G0_0_1_6_8 + 0.016272321428572*G0_0_1_6_9 - 0.00419135551948065*G0_0_1_7_0 + 0.00714995941558466*G0_0_1_7_1 + 0.00156148538961044*G0_0_1_7_2 - 0.037722199675326*G0_0_1_7_3 - 0.01849127435065*G0_0_1_7_4 + 0.00739650974025999*G0_0_1_7_5 - 0.00665685876623399*G0_0_1_7_6 + 0.00591720779220799*G0_0_1_7_7 - 0.00739650974026*G0_0_1_7_8 - 0.0650892857142879*G0_0_1_7_9 + 0.00221895292207799*G0_0_1_8_0 - 0.0101085633116887*G0_0_1_8_1 - 0.00238331980519488*G0_0_1_8_2 + 0.032544642857144*G0_0_1_8_3 + 0.00517755681818198*G0_0_1_8_4 - 0.000739650974026003*G0_0_1_8_5 + 0.00517755681818198*G0_0_1_8_6 - 0.00739650974026*G0_0_1_8_7 - 0.020710227272728*G0_0_1_8_8 + 0.041420454545456*G0_0_1_8_9 + 0.0261343344155853*G0_0_1_9_0 - 0.0172585227272733*G0_0_1_9_1 - 0.00493100649350665*G0_0_1_9_2 + 0.127219967532472*G0_0_1_9_3 + 0.0872788149350679*G0_0_1_9_4 - 0.0769237012987039*G0_0_1_9_5 + 0.016272321428572*G0_0_1_9_6 - 0.0650892857142879*G0_0_1_9_7 + 0.041420454545456*G0_0_1_9_8 + 0.408287337662351*G0_0_1_9_9 + 0.00162540584415586*G0_1_1_0_0 - 0.00705864448051976*G0_1_1_0_1 - 0.000100446428571437*G0_1_1_0_2 + 0.00271205357142868*G0_1_1_0_3 + 0.00197240259740267*G0_1_1_0_4 + 0.00147930194805198*G0_1_1_0_5 - 0.000493100649350665*G0_1_1_0_6 + 0.00846489448051975*G0_1_1_0_7 - 0.0119987824675329*G0_1_1_0_8 + 0.00641030844155867*G0_1_1_0_9 - 0.00705864448051976*G0_1_1_1_0 - 0.0925933441558473*G0_1_1_1_1 - 0.00373478084415597*G0_1_1_1_2 - 0.0406808035714299*G0_1_1_1_3 + 0.0172585227272733*G0_1_1_1_4 + 0.001479301948052*G0_1_1_1_5 + 0.0345170454545467*G0_1_1_1_7 - 0.0727323457792234*G0_1_1_1_8 - 0.0172585227272733*G0_1_1_1_9 - 0.000100446428571437*G0_1_1_2_0 - 0.00373478084415597*G0_1_1_2_1 + 0.00273944805194808*G0_1_1_2_2 - 0.00476663961038975*G0_1_1_2_3 + 0.00410917207792219*G0_1_1_2_4 - 0.000657467532467542*G0_1_1_2_5 + 0.00328733766233774*G0_1_1_2_6 + 0.00221895292207799*G0_1_1_2_7 - 0.00961546266233798*G0_1_1_2_8 + 0.000493100649350658*G0_1_1_2_9 + 0.00271205357142868*G0_1_1_3_0 - 0.0406808035714299*G0_1_1_3_1 - 0.00476663961038975*G0_1_1_3_2 + 0.0976339285714323*G0_1_1_3_3 + 0.015532670454546*G0_1_1_3_4 - 0.00887581168831201*G0_1_1_3_5 + 0.00517755681818198*G0_1_1_3_6 - 0.00295860389610402*G0_1_1_3_7 - 0.0310653409090919*G0_1_1_3_8 + 0.057692775974028*G0_1_1_3_9 + 0.00197240259740267*G0_1_1_4_0 + 0.0172585227272733*G0_1_1_4_1 + 0.00410917207792219*G0_1_1_4_2 + 0.015532670454546*G0_1_1_4_3 + 0.00443790584415604*G0_1_1_4_4 - 0.000739650974025993*G0_1_1_4_5 - 0.00443790584415598*G0_1_1_4_6 - 0.00887581168831198*G0_1_1_4_7 + 0.0340239448051959*G0_1_1_4_8 + 0.00147930194805198*G0_1_1_5_0 + 0.001479301948052*G0_1_1_5_1 - 0.000657467532467542*G0_1_1_5_2 - 0.00887581168831201*G0_1_1_5_3 - 0.000739650974025994*G0_1_1_5_4 - 0.00887581168831199*G0_1_1_5_5 - 0.000739650974025976*G0_1_1_5_6 + 0.000739650974025987*G0_1_1_5_7 + 0.000739650974026*G0_1_1_5_8 - 0.020710227272728*G0_1_1_5_9 - 0.000493100649350664*G0_1_1_6_0 + 0.00328733766233774*G0_1_1_6_2 + 0.00517755681818198*G0_1_1_6_3 - 0.00443790584415598*G0_1_1_6_4 - 0.000739650974025976*G0_1_1_6_5 - 0.010355113636364*G0_1_1_6_6 - 0.00147930194805198*G0_1_1_6_7 + 0.0118344155844159*G0_1_1_6_8 - 0.011834415584416*G0_1_1_6_9 + 0.00846489448051975*G0_1_1_7_0 + 0.0345170454545467*G0_1_1_7_1 + 0.00221895292207799*G0_1_1_7_2 - 0.00295860389610402*G0_1_1_7_3 - 0.00887581168831198*G0_1_1_7_4 + 0.000739650974025987*G0_1_1_7_5 - 0.00147930194805198*G0_1_1_7_6 - 0.0162723214285722*G0_1_1_7_7 + 0.0451187094155861*G0_1_1_7_8 - 0.016272321428572*G0_1_1_7_9 - 0.0119987824675329*G0_1_1_8_0 - 0.0727323457792234*G0_1_1_8_1 - 0.00961546266233798*G0_1_1_8_2 - 0.0310653409090919*G0_1_1_8_3 + 0.0340239448051959*G0_1_1_8_4 + 0.000739650974026*G0_1_1_8_5 + 0.0118344155844159*G0_1_1_8_6 + 0.0451187094155861*G0_1_1_8_7 - 0.257398538961048*G0_1_1_8_8 - 0.016272321428572*G0_1_1_8_9 + 0.00641030844155867*G0_1_1_9_0 - 0.0172585227272733*G0_1_1_9_1 + 0.000493100649350658*G0_1_1_9_2 + 0.057692775974028*G0_1_1_9_3 - 0.020710227272728*G0_1_1_9_5 - 0.011834415584416*G0_1_1_9_6 - 0.016272321428572*G0_1_1_9_7 - 0.016272321428572*G0_1_1_9_8 + 0.0177516233766243*G0_1_1_9_9;
    A[86] = -A[36] - 0.00162540584415592*G0_0_0_0_0 + 0.000100446428571433*G0_0_0_0_1 + 0.00705864448051976*G0_0_0_0_2 - 0.00197240259740269*G0_0_0_0_3 - 0.00271205357142865*G0_0_0_0_4 - 0.0084648944805198*G0_0_0_0_5 + 0.011998782467533*G0_0_0_0_6 - 0.00147930194805201*G0_0_0_0_7 + 0.000493100649350662*G0_0_0_0_8 - 0.00641030844155866*G0_0_0_0_9 + 0.000100446428571433*G0_0_0_1_0 - 0.00273944805194819*G0_0_0_1_1 + 0.00373478084415599*G0_0_0_1_2 - 0.00410917207792224*G0_0_0_1_3 + 0.0047666396103898*G0_0_0_1_4 - 0.00221895292207801*G0_0_0_1_5 + 0.00961546266233804*G0_0_0_1_6 + 0.000657467532467567*G0_0_0_1_7 - 0.00328733766233781*G0_0_0_1_8 - 0.00049310064935066*G0_0_0_1_9 + 0.00705864448051976*G0_0_0_2_0 + 0.00373478084415599*G0_0_0_2_1 + 0.0925933441558475*G0_0_0_2_2 - 0.0172585227272733*G0_0_0_2_3 + 0.0406808035714301*G0_0_0_2_4 - 0.0345170454545467*G0_0_0_2_5 + 0.0727323457792235*G0_0_0_2_6 - 0.00147930194805199*G0_0_0_2_7 + 0.0172585227272733*G0_0_0_2_9 - 0.00197240259740269*G0_0_0_3_0 - 0.00410917207792224*G0_0_0_3_1 - 0.0172585227272733*G0_0_0_3_2 - 0.00443790584415603*G0_0_0_3_3 - 0.0155326704545461*G0_0_0_3_4 + 0.00887581168831202*G0_0_0_3_5 - 0.034023944805196*G0_0_0_3_6 + 0.000739650974026021*G0_0_0_3_7 + 0.00443790584415597*G0_0_0_3_8 - 0.00271205357142865*G0_0_0_4_0 + 0.0047666396103898*G0_0_0_4_1 + 0.0406808035714301*G0_0_0_4_2 - 0.0155326704545461*G0_0_0_4_3 - 0.0976339285714318*G0_0_0_4_4 + 0.00295860389610391*G0_0_0_4_5 + 0.0310653409090921*G0_0_0_4_6 + 0.00887581168831197*G0_0_0_4_7 - 0.00517755681818199*G0_0_0_4_8 - 0.0576927759740279*G0_0_0_4_9 - 0.0084648944805198*G0_0_0_5_0 - 0.00221895292207801*G0_0_0_5_1 - 0.0345170454545467*G0_0_0_5_2 + 0.00887581168831203*G0_0_0_5_3 + 0.00295860389610391*G0_0_0_5_4 + 0.0162723214285721*G0_0_0_5_5 - 0.0451187094155861*G0_0_0_5_6 - 0.000739650974025988*G0_0_0_5_7 + 0.00147930194805201*G0_0_0_5_8 + 0.0162723214285719*G0_0_0_5_9 + 0.011998782467533*G0_0_0_6_0 + 0.00961546266233804*G0_0_0_6_1 + 0.0727323457792234*G0_0_0_6_2 - 0.034023944805196*G0_0_0_6_3 + 0.0310653409090921*G0_0_0_6_4 - 0.0451187094155861*G0_0_0_6_5 + 0.257398538961048*G0_0_0_6_6 - 0.000739650974026003*G0_0_0_6_7 - 0.011834415584416*G0_0_0_6_8 + 0.0162723214285721*G0_0_0_6_9 - 0.00147930194805201*G0_0_0_7_0 + 0.000657467532467567*G0_0_0_7_1 - 0.00147930194805199*G0_0_0_7_2 + 0.000739650974026021*G0_0_0_7_3 + 0.00887581168831197*G0_0_0_7_4 - 0.000739650974025988*G0_0_0_7_5 - 0.000739650974026003*G0_0_0_7_6 + 0.00887581168831208*G0_0_0_7_7 + 0.000739650974026036*G0_0_0_7_8 + 0.020710227272728*G0_0_0_7_9 + 0.000493100649350662*G0_0_0_8_0 - 0.00328733766233781*G0_0_0_8_1 + 0.00443790584415597*G0_0_0_8_3 - 0.00517755681818199*G0_0_0_8_4 + 0.001479301948052*G0_0_0_8_5 - 0.011834415584416*G0_0_0_8_6 + 0.000739650974026036*G0_0_0_8_7 + 0.010355113636364*G0_0_0_8_8 + 0.011834415584416*G0_0_0_8_9 - 0.00641030844155866*G0_0_0_9_0 - 0.00049310064935066*G0_0_0_9_1 + 0.0172585227272733*G0_0_0_9_2 - 0.0576927759740279*G0_0_0_9_4 + 0.0162723214285719*G0_0_0_9_5 + 0.0162723214285721*G0_0_0_9_6 + 0.020710227272728*G0_0_0_9_7 + 0.011834415584416*G0_0_0_9_8 - 0.0177516233766238*G0_0_0_9_9 + 0.0331655844155855*G0_0_1_0_0 + 0.00146103896103901*G0_0_1_0_1 + 0.00561586850649373*G0_0_1_0_2 - 0.000493100649350659*G0_0_1_0_4 + 0.0137246347402602*G0_0_1_0_5 + 0.00410917207792225*G0_0_1_0_6 + 0.013313717532468*G0_0_1_0_7 - 0.002958603896104*G0_0_1_0_8 + 0.00739650974026001*G0_0_1_0_9 + 0.00146103896103901*G0_0_1_1_0 + 0.00346996753246767*G0_0_1_1_2 - 0.00328733766233778*G0_0_1_1_3 + 0.0023833198051949*G0_0_1_1_4 - 0.00493100649350667*G0_0_1_1_5 + 0.00156148538961044*G0_0_1_1_7 + 0.00328733766233778*G0_0_1_1_8 - 0.00394480519480533*G0_0_1_1_9 + 0.00561586850649373*G0_0_1_2_0 + 0.00346996753246767*G0_0_1_2_1 + 0.0778916396103924*G0_0_1_2_2 - 0.0142999188311693*G0_0_1_2_3 + 0.0305722402597414*G0_0_1_2_4 - 0.017915990259741*G0_0_1_2_5 + 0.0528439529220799*G0_0_1_2_6 - 0.002958603896104*G0_0_1_2_7 - 0.00197240259740266*G0_0_1_2_8 + 0.00838271103896133*G0_0_1_2_9 - 0.00328733766233778*G0_0_1_3_1 - 0.0142999188311693*G0_0_1_3_2 + 0.00887581168831202*G0_0_1_3_3 - 0.0103551136363641*G0_0_1_3_4 + 0.010355113636364*G0_0_1_3_5 - 0.00591720779220806*G0_0_1_3_6 - 0.00591720779220797*G0_0_1_3_7 + 0.005917207792208*G0_0_1_3_8 + 0.023668831168832*G0_0_1_3_9 - 0.000493100649350658*G0_0_1_4_0 + 0.0023833198051949*G0_0_1_4_1 + 0.0305722402597414*G0_0_1_4_2 - 0.0103551136363641*G0_0_1_4_3 - 0.0650892857142878*G0_0_1_4_4 - 0.00443790584415603*G0_0_1_4_5 + 0.0103551136363641*G0_0_1_4_6 + 0.00813616071428599*G0_0_1_4_7 - 0.016272321428572*G0_0_1_4_9 + 0.0137246347402602*G0_0_1_5_0 - 0.00493100649350667*G0_0_1_5_1 - 0.017915990259741*G0_0_1_5_2 + 0.010355113636364*G0_0_1_5_3 - 0.00443790584415603*G0_0_1_5_4 - 0.113906250000004*G0_0_1_5_5 - 0.056953125000002*G0_0_1_5_6 - 0.011834415584416*G0_0_1_5_7 + 0.00887581168831199*G0_0_1_5_8 - 0.039941152597404*G0_0_1_5_9 + 0.00410917207792225*G0_0_1_6_0 + 0.0528439529220799*G0_0_1_6_2 - 0.00591720779220806*G0_0_1_6_3 + 0.0103551136363641*G0_0_1_6_4 - 0.056953125000002*G0_0_1_6_5 + 0.00295860389610399*G0_0_1_6_7 + 0.00591720779220798*G0_0_1_6_8 - 0.0133137175324679*G0_0_1_6_9 + 0.013313717532468*G0_0_1_7_0 + 0.00156148538961044*G0_0_1_7_1 - 0.002958603896104*G0_0_1_7_2 - 0.00591720779220797*G0_0_1_7_3 + 0.00813616071428599*G0_0_1_7_4 - 0.011834415584416*G0_0_1_7_5 + 0.00295860389610399*G0_0_1_7_6 - 0.0754443993506521*G0_0_1_7_7 - 0.0192309253246759*G0_0_1_7_8 - 0.028106737012988*G0_0_1_7_9 - 0.002958603896104*G0_0_1_8_0 + 0.00328733766233778*G0_0_1_8_1 - 0.00197240259740266*G0_0_1_8_2 + 0.005917207792208*G0_0_1_8_3 + 0.00887581168831199*G0_0_1_8_5 + 0.00591720779220798*G0_0_1_8_6 - 0.0192309253246759*G0_0_1_8_7 - 0.020710227272728*G0_0_1_8_8 + 0.011834415584416*G0_0_1_8_9 + 0.00739650974026001*G0_0_1_9_0 - 0.00394480519480533*G0_0_1_9_1 + 0.00838271103896133*G0_0_1_9_2 + 0.023668831168832*G0_0_1_9_3 - 0.016272321428572*G0_0_1_9_4 - 0.039941152597404*G0_0_1_9_5 - 0.0133137175324679*G0_0_1_9_6 - 0.028106737012988*G0_0_1_9_7 + 0.011834415584416*G0_0_1_9_8 + 0.213019480519488*G0_0_1_9_9;
    A[35] = -A[36] + 0.00253855519480529*G0_0_0_0_0 + 0.000502232142857166*G0_0_0_0_1 + 0.00602678571428594*G0_0_0_0_2 + 0.00246550324675333*G0_0_0_0_3 + 0.000493100649350683*G0_0_0_0_4 - 0.00443790584415599*G0_0_0_0_5 + 0.00591720779220806*G0_0_0_0_6 + 0.000410917207792223*G0_0_0_0_7 + 0.00115056818181822*G0_0_0_0_8 + 0.000502232142857166*G0_0_0_1_0 + 0.00374391233766246*G0_0_0_1_1 + 0.0035612824675326*G0_0_0_1_2 + 0.00197240259740267*G0_0_0_1_3 - 0.00049310064935065*G0_0_0_1_4 + 0.00147930194805199*G0_0_0_1_5 + 0.0108482142857147*G0_0_0_1_6 - 0.00032873376623378*G0_0_0_1_7 + 0.000904017857142891*G0_0_0_1_8 + 0.00493100649350668*G0_0_0_1_9 + 0.00602678571428594*G0_0_0_2_0 + 0.0035612824675326*G0_0_0_2_1 + 0.0569805194805214*G0_0_0_2_2 - 0.0108482142857147*G0_0_0_2_3 + 0.0246550324675333*G0_0_0_2_4 - 0.0256412337662347*G0_0_0_2_5 + 0.0493100649350667*G0_0_0_2_6 - 0.00246550324675333*G0_0_0_2_7 + 0.00690340909090934*G0_0_0_2_9 + 0.00246550324675333*G0_0_0_3_0 + 0.00197240259740267*G0_0_0_3_1 - 0.0108482142857147*G0_0_0_3_2 + 0.100592532467536*G0_0_0_3_3 - 0.016272321428572*G0_0_0_3_4 - 0.00295860389610397*G0_0_0_3_5 - 0.0384618506493519*G0_0_0_3_6 - 0.013313717532468*G0_0_0_3_7 + 0.019230925324676*G0_0_0_3_8 + 0.011834415584416*G0_0_0_3_9 + 0.000493100649350682*G0_0_0_4_0 - 0.00049310064935065*G0_0_0_4_1 + 0.0246550324675333*G0_0_0_4_2 - 0.016272321428572*G0_0_0_4_3 + 0.013313717532468*G0_0_0_4_4 - 0.00739650974026005*G0_0_0_4_5 + 0.045858360389612*G0_0_0_4_6 + 0.00591720779220799*G0_0_0_4_7 - 0.00591720779220801*G0_0_0_4_8 - 0.00591720779220797*G0_0_0_4_9 - 0.00443790584415599*G0_0_0_5_0 + 0.00147930194805199*G0_0_0_5_1 - 0.0256412337662347*G0_0_0_5_2 - 0.00295860389610397*G0_0_0_5_3 - 0.00739650974026005*G0_0_0_5_4 + 0.106509740259744*G0_0_0_5_5 - 0.0325446428571441*G0_0_0_5_6 + 0.00887581168831201*G0_0_0_5_7 - 0.010355113636364*G0_0_0_5_8 + 0.020710227272728*G0_0_0_5_9 + 0.00591720779220807*G0_0_0_6_0 + 0.0108482142857147*G0_0_0_6_1 + 0.0493100649350667*G0_0_0_6_2 - 0.0384618506493519*G0_0_0_6_3 + 0.045858360389612*G0_0_0_6_4 - 0.0325446428571441*G0_0_0_6_5 + 0.294381087662348*G0_0_0_6_6 + 0.00147930194805201*G0_0_0_6_7 - 0.013313717532468*G0_0_0_6_8 + 0.0562134740259759*G0_0_0_6_9 + 0.000410917207792222*G0_0_0_7_0 - 0.00032873376623378*G0_0_0_7_1 - 0.00246550324675333*G0_0_0_7_2 - 0.013313717532468*G0_0_0_7_3 + 0.00591720779220799*G0_0_0_7_4 + 0.00887581168831201*G0_0_0_7_5 + 0.00147930194805201*G0_0_0_7_6 - 0.00665685876623401*G0_0_0_7_8 - 0.00295860389610399*G0_0_0_7_9 + 0.00115056818181822*G0_0_0_8_0 + 0.000904017857142891*G0_0_0_8_1 + 0.019230925324676*G0_0_0_8_3 - 0.00591720779220801*G0_0_0_8_4 - 0.010355113636364*G0_0_0_8_5 - 0.013313717532468*G0_0_0_8_6 - 0.00665685876623401*G0_0_0_8_7 + 0.00887581168831203*G0_0_0_8_8 - 0.00295860389610397*G0_0_0_8_9 + 0.00493100649350668*G0_0_0_9_1 + 0.00690340909090934*G0_0_0_9_2 + 0.011834415584416*G0_0_0_9_3 - 0.00591720779220798*G0_0_0_9_4 + 0.020710227272728*G0_0_0_9_5 + 0.0562134740259759*G0_0_0_9_6 - 0.00295860389610399*G0_0_0_9_7 - 0.00295860389610397*G0_0_0_9_8 - 0.0887581168831197*G0_0_0_9_9 - 0.00184456168831178*G0_0_1_0_0 + 0.0028307629870131*G0_0_1_0_2 + 0.00279423701298712*G0_0_1_0_3 + 0.00230113636363646*G0_0_1_0_4 - 0.00690340909090936*G0_0_1_0_5 + 0.0078896103896107*G0_0_1_0_6 - 0.00205458603896113*G0_0_1_0_7 + 0.00115056818181823*G0_0_1_0_8 + 0.00295860389610401*G0_0_1_0_9 + 0.00200892857142864*G0_0_1_1_1 + 0.00278510551948062*G0_0_1_1_2 + 0.000821834415584439*G0_0_1_1_3 - 0.00139711850649354*G0_0_1_1_4 - 0.00189021915584423*G0_0_1_1_5 + 0.00402698863636379*G0_0_1_1_6 + 0.000246550324675329*G0_0_1_1_7 - 0.000493100649350667*G0_0_1_1_9 + 0.0028307629870131*G0_0_1_2_0 + 0.00278510551948062*G0_0_1_2_1 + 0.0452008928571444*G0_0_1_2_2 - 0.00936891233766266*G0_0_1_2_3 + 0.0172585227272733*G0_0_1_2_4 - 0.0157792207792213*G0_0_1_2_5 + 0.0345170454545467*G0_0_1_2_6 - 0.000904017857142889*G0_0_1_2_7 - 0.00115056818181821*G0_0_1_2_8 + 0.002958603896104*G0_0_1_2_9 + 0.00279423701298712*G0_0_1_3_0 + 0.00082183441558444*G0_0_1_3_1 - 0.00936891233766266*G0_0_1_3_2 + 0.093196022727276*G0_0_1_3_3 - 0.00517755681818197*G0_0_1_3_4 - 0.01479301948052*G0_0_1_3_6 - 0.01109476461039*G0_0_1_3_7 + 0.010355113636364*G0_0_1_3_8 + 0.0236688311688321*G0_0_1_3_9 + 0.00230113636363646*G0_0_1_4_0 - 0.00139711850649354*G0_0_1_4_1 + 0.0172585227272733*G0_0_1_4_2 - 0.00517755681818198*G0_0_1_4_3 + 0.0251481331168841*G0_0_1_4_4 - 0.00961546266233802*G0_0_1_4_5 + 0.024408482142858*G0_0_1_4_6 - 0.000739650974026001*G0_0_1_4_7 + 0.000739650974025985*G0_0_1_4_8 + 0.010355113636364*G0_0_1_4_9 - 0.00690340909090936*G0_0_1_5_0 - 0.00189021915584423*G0_0_1_5_1 - 0.0157792207792213*G0_0_1_5_2 - 0.00961546266233802*G0_0_1_5_4 - 0.017751623376624*G0_0_1_5_5 - 0.023668831168832*G0_0_1_5_6 - 0.00295860389610401*G0_0_1_5_7 + 0.00295860389610401*G0_0_1_5_8 - 0.01479301948052*G0_0_1_5_9 + 0.0078896103896107*G0_0_1_6_0 + 0.00402698863636379*G0_0_1_6_1 + 0.0345170454545467*G0_0_1_6_2 - 0.01479301948052*G0_0_1_6_3 + 0.024408482142858*G0_0_1_6_4 - 0.023668831168832*G0_0_1_6_5 + 0.10355113636364*G0_0_1_6_6 - 0.002958603896104*G0_0_1_6_8 + 0.020710227272728*G0_0_1_6_9 - 0.00205458603896113*G0_0_1_7_0 + 0.000246550324675328*G0_0_1_7_1 - 0.000904017857142889*G0_0_1_7_2 - 0.01109476461039*G0_0_1_7_3 - 0.000739650974026001*G0_0_1_7_4 - 0.00295860389610401*G0_0_1_7_5 - 0.000739650974026001*G0_0_1_7_8 - 0.00887581168831202*G0_0_1_7_9 + 0.00115056818181823*G0_0_1_8_0 - 0.00115056818181821*G0_0_1_8_2 + 0.010355113636364*G0_0_1_8_3 + 0.000739650974025985*G0_0_1_8_4 + 0.00295860389610401*G0_0_1_8_5 - 0.002958603896104*G0_0_1_8_6 - 0.000739650974026001*G0_0_1_8_7 - 0.010355113636364*G0_0_1_8_8 + 0.00295860389610401*G0_0_1_9_0 - 0.000493100649350667*G0_0_1_9_1 + 0.002958603896104*G0_0_1_9_2 + 0.0236688311688321*G0_0_1_9_3 + 0.010355113636364*G0_0_1_9_4 - 0.01479301948052*G0_0_1_9_5 + 0.020710227272728*G0_0_1_9_6 - 0.00887581168831202*G0_0_1_9_7 + 0.0177516233766241*G0_0_1_9_9 + 0.00124188311688315*G0_1_0_0_0 + 0.000913149350649385*G0_1_0_0_1 + 0.000721387987013009*G0_1_0_0_2 + 0.00361607142857157*G0_1_0_0_3 + 0.000164366883116887*G0_1_0_0_4 - 0.00106838474025978*G0_1_0_0_5 + 0.000657467532467555*G0_1_0_0_6 - 0.000821834415584455*G0_1_0_0_7 + 0.00213676948051956*G0_1_0_0_8 + 0.00147930194805201*G0_1_0_0_9 + 0.000913149350649385*G0_1_0_1_0 + 0.0109577922077925*G0_1_0_1_1 + 0.0017715097402598*G0_1_0_1_2 + 0.0135602678571433*G0_1_0_1_3 - 0.00493100649350665*G0_1_0_1_4 + 0.000904017857142884*G0_1_0_1_5 + 0.00189021915584422*G0_1_0_1_6 - 0.00246550324675334*G0_1_0_1_7 + 0.00616375811688334*G0_1_0_1_8 + 0.00739650974026*G0_1_0_1_9 + 0.000721387987013009*G0_1_0_2_0 + 0.0017715097402598*G0_1_0_2_1 + 0.00356128246753254*G0_1_0_2_2 + 0.002958603896104*G0_1_0_2_3 + 0.00123275162337666*G0_1_0_2_4 - 0.000986201298701315*G0_1_0_2_5 + 0.00123275162337663*G0_1_0_2_6 - 0.000575284090909115*G0_1_0_2_7 + 0.00164366883116889*G0_1_0_2_8 + 0.000493100649350671*G0_1_0_2_9 + 0.00361607142857157*G0_1_0_3_0 + 0.0135602678571433*G0_1_0_3_1 + 0.002958603896104*G0_1_0_3_2 + 0.093196022727276*G0_1_0_3_3 - 0.026627435064936*G0_1_0_3_4 - 0.00443790584415599*G0_1_0_3_5 - 0.010355113636364*G0_1_0_3_6 - 0.015532670454546*G0_1_0_3_7 + 0.025148133116884*G0_1_0_3_8 + 0.00887581168831209*G0_1_0_3_9 + 0.000164366883116888*G0_1_0_4_0 - 0.00493100649350665*G0_1_0_4_1 + 0.00123275162337666*G0_1_0_4_2 - 0.026627435064936*G0_1_0_4_3 + 0.026627435064936*G0_1_0_4_4 - 0.00517755681818199*G0_1_0_4_5 + 0.0155326704545459*G0_1_0_4_6 + 0.00295860389610401*G0_1_0_4_7 - 0.00961546266233801*G0_1_0_4_8 + 0.00887581168831194*G0_1_0_4_9 - 0.00106838474025978*G0_1_0_5_0 + 0.000904017857142884*G0_1_0_5_1 - 0.000986201298701316*G0_1_0_5_2 - 0.00443790584415599*G0_1_0_5_3 - 0.00517755681818199*G0_1_0_5_4 + 0.0236688311688319*G0_1_0_5_5 - 0.00813616071428594*G0_1_0_5_6 + 0.010355113636364*G0_1_0_5_7 - 0.00739650974025998*G0_1_0_5_8 + 0.010355113636364*G0_1_0_5_9 + 0.000657467532467555*G0_1_0_6_0 + 0.00189021915584422*G0_1_0_6_1 + 0.00123275162337663*G0_1_0_6_2 - 0.010355113636364*G0_1_0_6_3 + 0.0155326704545459*G0_1_0_6_4 - 0.00813616071428594*G0_1_0_6_5 + 0.0310653409090918*G0_1_0_6_6 - 0.00295860389610398*G0_1_0_6_7 - 0.002958603896104*G0_1_0_6_8 + 0.0192309253246759*G0_1_0_6_9 - 0.000821834415584455*G0_1_0_7_0 - 0.00246550324675334*G0_1_0_7_1 - 0.000575284090909115*G0_1_0_7_2 - 0.015532670454546*G0_1_0_7_3 + 0.00295860389610401*G0_1_0_7_4 + 0.010355113636364*G0_1_0_7_5 - 0.00295860389610398*G0_1_0_7_6 + 0.011834415584416*G0_1_0_7_7 - 0.013313717532468*G0_1_0_7_8 + 0.00147930194805196*G0_1_0_7_9 + 0.00213676948051956*G0_1_0_8_0 + 0.00616375811688334*G0_1_0_8_1 + 0.00164366883116889*G0_1_0_8_2 + 0.025148133116884*G0_1_0_8_3 - 0.00961546266233801*G0_1_0_8_4 - 0.00739650974025998*G0_1_0_8_5 - 0.002958603896104*G0_1_0_8_6 - 0.013313717532468*G0_1_0_8_7 + 0.0192309253246761*G0_1_0_8_8 - 0.00295860389610392*G0_1_0_8_9 + 0.00147930194805201*G0_1_0_9_0 + 0.00739650974026*G0_1_0_9_1 + 0.000493100649350671*G0_1_0_9_2 + 0.00887581168831209*G0_1_0_9_3 + 0.00887581168831194*G0_1_0_9_4 + 0.010355113636364*G0_1_0_9_5 + 0.0192309253246759*G0_1_0_9_6 + 0.00147930194805196*G0_1_0_9_7 - 0.00295860389610393*G0_1_0_9_8 + 0.0532548701298718*G0_1_0_9_9 - 0.00231939935064939*G0_1_1_0_0 - 0.000858360389610418*G0_1_1_0_1 + 0.00197240259740268*G0_1_1_0_3 + 0.000739650974025999*G0_1_1_0_4 - 0.00230113636363642*G0_1_1_0_5 + 0.00164366883116887*G0_1_1_0_6 - 0.00205458603896109*G0_1_1_0_7 - 0.000821834415584456*G0_1_1_0_8 + 0.000986201298701343*G0_1_1_0_9 - 0.000858360389610418*G0_1_1_1_0 + 0.000858360389610416*G0_1_1_1_2 + 0.00739650974025998*G0_1_1_1_3 - 0.00246550324675332*G0_1_1_1_4 - 0.000986201298701329*G0_1_1_1_5 + 0.000986201298701327*G0_1_1_1_6 + 0.00246550324675334*G0_1_1_1_7 - 0.00739650974026001*G0_1_1_1_8 + 0.000858360389610416*G0_1_1_2_1 + 0.00231939935064939*G0_1_1_2_2 + 0.000821834415584448*G0_1_1_2_3 + 0.0020545860389611*G0_1_1_2_4 - 0.00164366883116887*G0_1_1_2_5 + 0.00230113636363641*G0_1_1_2_6 - 0.000739650974025998*G0_1_1_2_7 - 0.00197240259740266*G0_1_1_2_8 - 0.00098620129870133*G0_1_1_2_9 + 0.00197240259740268*G0_1_1_3_0 + 0.00739650974025998*G0_1_1_3_1 + 0.000821834415584448*G0_1_1_3_2 + 0.0739650974026*G0_1_1_3_3 - 0.013313717532468*G0_1_1_3_4 - 0.00147930194805201*G0_1_1_3_5 - 0.00295860389610399*G0_1_1_3_6 - 0.00591720779220802*G0_1_1_3_7 + 0.0118344155844161*G0_1_1_3_9 + 0.000739650974025999*G0_1_1_4_0 - 0.00246550324675332*G0_1_1_4_1 + 0.0020545860389611*G0_1_1_4_2 - 0.013313717532468*G0_1_1_4_3 + 0.01479301948052*G0_1_1_4_4 - 0.00221895292207799*G0_1_1_4_5 + 0.00517755681818198*G0_1_1_4_6 + 0.00591720779220797*G0_1_1_4_8 + 0.00739650974025997*G0_1_1_4_9 - 0.00230113636363642*G0_1_1_5_0 - 0.000986201298701329*G0_1_1_5_1 - 0.00164366883116887*G0_1_1_5_2 - 0.00147930194805201*G0_1_1_5_3 - 0.00221895292207799*G0_1_1_5_4 - 0.00739650974025998*G0_1_1_5_5 - 0.00517755681818197*G0_1_1_5_7 + 0.00295860389610399*G0_1_1_5_8 - 0.00887581168831199*G0_1_1_5_9 + 0.00164366883116887*G0_1_1_6_0 + 0.000986201298701327*G0_1_1_6_1 + 0.00230113636363641*G0_1_1_6_2 - 0.00295860389610399*G0_1_1_6_3 + 0.00517755681818198*G0_1_1_6_4 + 0.00739650974025992*G0_1_1_6_6 + 0.00221895292207799*G0_1_1_6_7 + 0.00147930194805199*G0_1_1_6_8 + 0.00887581168831197*G0_1_1_6_9 - 0.00205458603896109*G0_1_1_7_0 + 0.00246550324675334*G0_1_1_7_1 - 0.000739650974025998*G0_1_1_7_2 - 0.00591720779220803*G0_1_1_7_3 - 0.00517755681818197*G0_1_1_7_5 + 0.00221895292207799*G0_1_1_7_6 - 0.0147930194805199*G0_1_1_7_7 + 0.013313717532468*G0_1_1_7_8 - 0.00739650974026*G0_1_1_7_9 - 0.000821834415584457*G0_1_1_8_0 - 0.00739650974026001*G0_1_1_8_1 - 0.00197240259740266*G0_1_1_8_2 + 0.00591720779220797*G0_1_1_8_4 + 0.00295860389610399*G0_1_1_8_5 + 0.00147930194805199*G0_1_1_8_6 + 0.013313717532468*G0_1_1_8_7 - 0.0739650974025999*G0_1_1_8_8 - 0.011834415584416*G0_1_1_8_9 + 0.000986201298701343*G0_1_1_9_0 - 0.00098620129870133*G0_1_1_9_2 + 0.0118344155844161*G0_1_1_9_3 + 0.00739650974025997*G0_1_1_9_4 - 0.00887581168831199*G0_1_1_9_5 + 0.00887581168831197*G0_1_1_9_6 - 0.00739650974026001*G0_1_1_9_7 - 0.011834415584416*G0_1_1_9_8;
    A[85] = -A[35] + 0.014701704545455*G0_0_0_0_0 + 0.000264813311688324*G0_0_0_0_1 + 0.00144277597402601*G0_0_0_0_2 + 0.00197240259740267*G0_0_0_0_3 + 0.00147930194805201*G0_0_0_0_4 + 0.0198883928571435*G0_0_0_0_5 - 0.0166010551948057*G0_0_0_0_6 + 0.0101085633116887*G0_0_0_0_7 - 0.002958603896104*G0_0_0_0_8 + 0.00887581168831201*G0_0_0_0_9 + 0.000264813311688324*G0_0_0_1_0 - 0.00273944805194806*G0_0_0_1_1 - 0.00136059253246758*G0_0_0_1_2 - 0.00657467532467551*G0_0_0_1_3 - 0.000904017857142908*G0_0_0_1_4 + 0.00961546266233798*G0_0_0_1_5 + 0.00271205357142867*G0_0_0_1_6 + 0.00238331980519487*G0_0_0_1_7 - 0.000821834415584414*G0_0_0_1_8 + 0.00345170454545466*G0_0_0_1_9 + 0.00144277597402601*G0_0_0_2_0 - 0.00136059253246758*G0_0_0_2_1 - 0.0347909902597415*G0_0_0_2_2 + 0.00345170454545468*G0_0_0_2_3 - 0.01479301948052*G0_0_0_2_4 + 0.00788961038961071*G0_0_0_2_5 - 0.0221895292207801*G0_0_0_2_6 - 0.002218952922078*G0_0_0_2_7 - 0.00197240259740266*G0_0_0_2_8 - 0.0138068181818186*G0_0_0_2_9 + 0.00197240259740267*G0_0_0_3_0 - 0.00657467532467551*G0_0_0_3_1 + 0.00345170454545468*G0_0_0_3_2 + 0.0310653409090921*G0_0_0_3_3 + 0.019970576298702*G0_0_0_3_4 - 0.0177516233766239*G0_0_0_3_5 - 0.00739650974025995*G0_0_0_3_6 - 0.005177556818182*G0_0_0_3_7 - 0.00147930194805198*G0_0_0_3_8 + 0.001479301948052*G0_0_0_4_0 - 0.000904017857142908*G0_0_0_4_1 - 0.01479301948052*G0_0_0_4_2 + 0.019970576298702*G0_0_0_4_3 + 0.0843202110389639*G0_0_0_4_4 - 0.00369825487013*G0_0_0_4_5 + 0.0110947646103899*G0_0_0_4_6 + 0.000739650974026014*G0_0_0_4_7 + 0.00665685876623398*G0_0_0_4_8 + 0.0488169642857159*G0_0_0_4_9 + 0.0198883928571435*G0_0_0_5_0 + 0.00961546266233798*G0_0_0_5_1 + 0.00788961038961071*G0_0_0_5_2 - 0.0177516233766239*G0_0_0_5_3 - 0.00369825487013001*G0_0_0_5_4 + 0.257398538961048*G0_0_0_5_5 + 0.011834415584416*G0_0_0_5_6 + 0.020710227272728*G0_0_0_5_7 - 0.028106737012988*G0_0_0_5_8 + 0.02958603896104*G0_0_0_5_9 - 0.0166010551948057*G0_0_0_6_0 + 0.00271205357142867*G0_0_0_6_1 - 0.0221895292207801*G0_0_0_6_2 - 0.00739650974025994*G0_0_0_6_3 + 0.0110947646103899*G0_0_0_6_4 + 0.011834415584416*G0_0_0_6_5 + 0.130178571428576*G0_0_0_6_6 + 0.00739650974026001*G0_0_0_6_7 - 0.00147930194805199*G0_0_0_6_8 + 0.0562134740259759*G0_0_0_6_9 + 0.0101085633116887*G0_0_0_7_0 + 0.00238331980519487*G0_0_0_7_1 - 0.002218952922078*G0_0_0_7_2 - 0.005177556818182*G0_0_0_7_3 + 0.000739650974026014*G0_0_0_7_4 + 0.020710227272728*G0_0_0_7_5 + 0.00739650974026001*G0_0_0_7_6 - 0.032544642857144*G0_0_0_7_7 - 0.00517755681818201*G0_0_0_7_8 - 0.041420454545456*G0_0_0_7_9 - 0.00295860389610401*G0_0_0_8_0 - 0.000821834415584414*G0_0_0_8_1 - 0.00197240259740266*G0_0_0_8_2 - 0.00147930194805198*G0_0_0_8_3 + 0.00665685876623398*G0_0_0_8_4 - 0.028106737012988*G0_0_0_8_5 - 0.00147930194805199*G0_0_0_8_6 - 0.00517755681818201*G0_0_0_8_7 - 0.0133137175324679*G0_0_0_8_8 - 0.0236688311688319*G0_0_0_8_9 + 0.00887581168831202*G0_0_0_9_0 + 0.00345170454545466*G0_0_0_9_1 - 0.0138068181818186*G0_0_0_9_2 + 0.0488169642857159*G0_0_0_9_4 + 0.02958603896104*G0_0_0_9_5 + 0.0562134740259759*G0_0_0_9_6 - 0.041420454545456*G0_0_0_9_7 - 0.0236688311688319*G0_0_0_9_8 - 0.230771103896111*G0_0_0_9_9 - 0.0778916396103923*G0_0_1_0_0 - 0.00346996753246765*G0_0_1_0_1 - 0.00561586850649371*G0_0_1_0_2 + 0.00197240259740268*G0_0_1_0_3 + 0.00295860389610401*G0_0_1_0_4 - 0.0528439529220797*G0_0_1_0_5 + 0.0179159902597409*G0_0_1_0_6 - 0.0305722402597413*G0_0_1_0_7 + 0.0142999188311693*G0_0_1_0_8 - 0.00838271103896135*G0_0_1_0_9 - 0.00346996753246765*G0_0_1_1_0 - 0.00146103896103902*G0_0_1_1_2 - 0.00328733766233776*G0_0_1_1_3 - 0.00156148538961045*G0_0_1_1_4 + 0.00493100649350667*G0_0_1_1_6 - 0.00238331980519489*G0_0_1_1_7 + 0.00328733766233779*G0_0_1_1_8 + 0.00394480519480532*G0_0_1_1_9 - 0.00561586850649371*G0_0_1_2_0 - 0.00146103896103902*G0_0_1_2_1 - 0.0331655844155856*G0_0_1_2_2 + 0.00295860389610401*G0_0_1_2_3 - 0.013313717532468*G0_0_1_2_4 - 0.00410917207792217*G0_0_1_2_5 - 0.0137246347402603*G0_0_1_2_6 + 0.000493100649350672*G0_0_1_2_7 - 0.00739650974025999*G0_0_1_2_9 + 0.00197240259740268*G0_0_1_3_0 - 0.00328733766233776*G0_0_1_3_1 + 0.00295860389610401*G0_0_1_3_2 + 0.020710227272728*G0_0_1_3_3 + 0.019230925324676*G0_0_1_3_4 - 0.00591720779220798*G0_0_1_3_5 - 0.00887581168831194*G0_0_1_3_6 - 0.00591720779220798*G0_0_1_3_8 - 0.011834415584416*G0_0_1_3_9 + 0.00295860389610401*G0_0_1_4_0 - 0.00156148538961045*G0_0_1_4_1 - 0.013313717532468*G0_0_1_4_2 + 0.019230925324676*G0_0_1_4_3 + 0.075444399350652*G0_0_1_4_4 - 0.00295860389610399*G0_0_1_4_5 + 0.011834415584416*G0_0_1_4_6 - 0.008136160714286*G0_0_1_4_7 + 0.00591720779220798*G0_0_1_4_8 + 0.028106737012988*G0_0_1_4_9 - 0.0528439529220797*G0_0_1_5_0 - 0.00410917207792217*G0_0_1_5_2 - 0.00591720779220798*G0_0_1_5_3 - 0.00295860389610399*G0_0_1_5_4 + 0.0569531250000019*G0_0_1_5_6 - 0.010355113636364*G0_0_1_5_7 + 0.00591720779220801*G0_0_1_5_8 + 0.0133137175324679*G0_0_1_5_9 + 0.0179159902597409*G0_0_1_6_0 + 0.00493100649350667*G0_0_1_6_1 - 0.0137246347402603*G0_0_1_6_2 - 0.00887581168831194*G0_0_1_6_3 + 0.011834415584416*G0_0_1_6_4 + 0.0569531250000019*G0_0_1_6_5 + 0.113906250000004*G0_0_1_6_6 + 0.00443790584415599*G0_0_1_6_7 - 0.010355113636364*G0_0_1_6_8 + 0.039941152597404*G0_0_1_6_9 - 0.0305722402597413*G0_0_1_7_0 - 0.00238331980519489*G0_0_1_7_1 + 0.000493100649350671*G0_0_1_7_2 - 0.008136160714286*G0_0_1_7_4 - 0.010355113636364*G0_0_1_7_5 + 0.00443790584415599*G0_0_1_7_6 + 0.0650892857142882*G0_0_1_7_7 + 0.0103551136363639*G0_0_1_7_8 + 0.016272321428572*G0_0_1_7_9 + 0.0142999188311693*G0_0_1_8_0 + 0.00328733766233779*G0_0_1_8_1 - 0.00591720779220798*G0_0_1_8_3 + 0.00591720779220798*G0_0_1_8_4 + 0.00591720779220801*G0_0_1_8_5 - 0.010355113636364*G0_0_1_8_6 + 0.0103551136363639*G0_0_1_8_7 - 0.00887581168831197*G0_0_1_8_8 - 0.0236688311688319*G0_0_1_8_9 - 0.00838271103896135*G0_0_1_9_0 + 0.00394480519480532*G0_0_1_9_1 - 0.00739650974025999*G0_0_1_9_2 - 0.011834415584416*G0_0_1_9_3 + 0.028106737012988*G0_0_1_9_4 + 0.0133137175324679*G0_0_1_9_5 + 0.039941152597404*G0_0_1_9_6 + 0.016272321428572*G0_0_1_9_7 - 0.0236688311688319*G0_0_1_9_8 - 0.213019480519487*G0_0_1_9_9;
    A[58] = A[85] + 0.0734172077922102*G0_0_1_0_0 + 0.00276684253246762*G0_0_1_0_1 + 0.00386262175324688*G0_0_1_0_2 - 0.00262987012987023*G0_0_1_0_3 - 0.000164366883116892*G0_0_1_0_4 + 0.0456118100649366*G0_0_1_0_5 - 0.0167654220779226*G0_0_1_0_6 + 0.0283532873376632*G0_0_1_0_7 - 0.0142999188311693*G0_0_1_0_8 + 0.00641030844155868*G0_0_1_0_9 + 0.00276684253246762*G0_0_1_1_0 - 0.00447443181818189*G0_0_1_1_1 - 0.000292207792207798*G0_0_1_1_2 - 0.00394480519480531*G0_0_1_1_3 + 0.00271205357142865*G0_0_1_1_4 - 0.000657467532467561*G0_0_1_1_5 - 0.00213676948051956*G0_0_1_1_6 + 0.00238331980519486*G0_0_1_1_7 - 0.00550629058441574*G0_0_1_1_8 - 0.00591720779220799*G0_0_1_1_9 + 0.00386262175324688*G0_0_1_2_0 - 0.000292207792207797*G0_0_1_2_1 + 0.00138798701298707*G0_0_1_2_2 - 0.000986201298701338*G0_0_1_2_3 + 0.000986201298701347*G0_0_1_2_4 + 0.00608157467532486*G0_0_1_2_5 + 0.00139711850649357*G0_0_1_2_6 - 0.000657467532467561*G0_0_1_2_7 - 0.000164366883116886*G0_0_1_2_8 + 0.00345170454545466*G0_0_1_2_9 - 0.00262987012987023*G0_0_1_3_0 - 0.0039448051948053*G0_0_1_3_1 - 0.000986201298701338*G0_0_1_3_2 - 0.0207102272727281*G0_0_1_3_3 + 0.00147930194805199*G0_0_1_3_4 + 0.00591720779220799*G0_0_1_3_5 + 0.00443790584415599*G0_0_1_3_6 + 0.00591720779220802*G0_0_1_3_7 - 0.00443790584415601*G0_0_1_3_8 + 0.00591720779220795*G0_0_1_3_9 - 0.000164366883116891*G0_0_1_4_0 + 0.00271205357142865*G0_0_1_4_1 + 0.000986201298701347*G0_0_1_4_2 + 0.00147930194805199*G0_0_1_4_3 - 0.00295860389610392*G0_0_1_4_4 - 0.001479301948052*G0_0_1_4_5 - 0.00295860389610399*G0_0_1_4_6 + 0.002218952922078*G0_0_1_4_7 - 0.001479301948052*G0_0_1_4_8 - 0.00739650974025998*G0_0_1_4_9 + 0.0456118100649366*G0_0_1_5_0 - 0.000657467532467561*G0_0_1_5_1 + 0.00608157467532486*G0_0_1_5_2 + 0.00591720779220799*G0_0_1_5_3 - 0.001479301948052*G0_0_1_5_4 - 0.0362428977272739*G0_0_1_5_6 - 0.019230925324676*G0_0_1_5_9 - 0.0167654220779226*G0_0_1_6_0 - 0.00213676948051956*G0_0_1_6_1 + 0.00139711850649357*G0_0_1_6_2 + 0.00443790584415598*G0_0_1_6_3 - 0.00295860389610398*G0_0_1_6_4 - 0.0362428977272739*G0_0_1_6_5 - 0.041420454545456*G0_0_1_6_6 + 0.00443790584415599*G0_0_1_6_8 - 0.019230925324676*G0_0_1_6_9 + 0.0283532873376632*G0_0_1_7_0 + 0.00238331980519486*G0_0_1_7_1 - 0.000657467532467561*G0_0_1_7_2 + 0.00591720779220803*G0_0_1_7_3 + 0.002218952922078*G0_0_1_7_4 - 0.0739650974026002*G0_0_1_7_7 + 0.000739650974026027*G0_0_1_7_8 - 0.019230925324676*G0_0_1_7_9 - 0.0142999188311693*G0_0_1_8_0 - 0.00550629058441573*G0_0_1_8_1 - 0.000164366883116886*G0_0_1_8_2 - 0.00443790584415601*G0_0_1_8_3 - 0.001479301948052*G0_0_1_8_4 + 0.00443790584415599*G0_0_1_8_6 + 0.000739650974026027*G0_0_1_8_7 + 0.020710227272728*G0_0_1_8_9 + 0.00641030844155868*G0_0_1_9_0 - 0.00591720779220799*G0_0_1_9_1 + 0.00345170454545466*G0_0_1_9_2 + 0.00591720779220795*G0_0_1_9_3 - 0.00739650974025998*G0_0_1_9_4 - 0.019230925324676*G0_0_1_9_5 - 0.019230925324676*G0_0_1_9_6 - 0.019230925324676*G0_0_1_9_7 + 0.020710227272728*G0_0_1_9_8 + 0.0887581168831197*G0_0_1_9_9 - 0.0734172077922102*G0_1_0_0_0 - 0.00276684253246762*G0_1_0_0_1 - 0.00386262175324688*G0_1_0_0_2 + 0.00262987012987023*G0_1_0_0_3 + 0.000164366883116891*G0_1_0_0_4 - 0.0456118100649366*G0_1_0_0_5 + 0.0167654220779226*G0_1_0_0_6 - 0.0283532873376632*G0_1_0_0_7 + 0.0142999188311693*G0_1_0_0_8 - 0.00641030844155868*G0_1_0_0_9 - 0.00276684253246762*G0_1_0_1_0 + 0.00447443181818189*G0_1_0_1_1 + 0.000292207792207798*G0_1_0_1_2 + 0.00394480519480531*G0_1_0_1_3 - 0.00271205357142865*G0_1_0_1_4 + 0.00065746753246756*G0_1_0_1_5 + 0.00213676948051956*G0_1_0_1_6 - 0.00238331980519486*G0_1_0_1_7 + 0.00550629058441574*G0_1_0_1_8 + 0.00591720779220799*G0_1_0_1_9 - 0.00386262175324688*G0_1_0_2_0 + 0.000292207792207797*G0_1_0_2_1 - 0.00138798701298707*G0_1_0_2_2 + 0.000986201298701338*G0_1_0_2_3 - 0.000986201298701347*G0_1_0_2_4 - 0.00608157467532486*G0_1_0_2_5 - 0.00139711850649357*G0_1_0_2_6 + 0.000657467532467562*G0_1_0_2_7 + 0.000164366883116886*G0_1_0_2_8 - 0.00345170454545466*G0_1_0_2_9 + 0.00262987012987023*G0_1_0_3_0 + 0.00394480519480531*G0_1_0_3_1 + 0.000986201298701338*G0_1_0_3_2 + 0.0207102272727281*G0_1_0_3_3 - 0.00147930194805199*G0_1_0_3_4 - 0.00591720779220799*G0_1_0_3_5 - 0.00443790584415598*G0_1_0_3_6 - 0.00591720779220803*G0_1_0_3_7 + 0.00443790584415601*G0_1_0_3_8 - 0.00591720779220795*G0_1_0_3_9 + 0.000164366883116891*G0_1_0_4_0 - 0.00271205357142865*G0_1_0_4_1 - 0.000986201298701347*G0_1_0_4_2 - 0.00147930194805199*G0_1_0_4_3 + 0.00295860389610392*G0_1_0_4_4 + 0.001479301948052*G0_1_0_4_5 + 0.00295860389610399*G0_1_0_4_6 - 0.002218952922078*G0_1_0_4_7 + 0.001479301948052*G0_1_0_4_8 + 0.00739650974025997*G0_1_0_4_9 - 0.0456118100649366*G0_1_0_5_0 + 0.000657467532467561*G0_1_0_5_1 - 0.00608157467532486*G0_1_0_5_2 - 0.00591720779220799*G0_1_0_5_3 + 0.001479301948052*G0_1_0_5_4 + 0.0362428977272739*G0_1_0_5_6 + 0.019230925324676*G0_1_0_5_9 + 0.0167654220779226*G0_1_0_6_0 + 0.00213676948051956*G0_1_0_6_1 - 0.00139711850649357*G0_1_0_6_2 - 0.00443790584415598*G0_1_0_6_3 + 0.00295860389610399*G0_1_0_6_4 + 0.0362428977272739*G0_1_0_6_5 + 0.041420454545456*G0_1_0_6_6 - 0.00443790584415599*G0_1_0_6_8 + 0.019230925324676*G0_1_0_6_9 - 0.0283532873376632*G0_1_0_7_0 - 0.00238331980519486*G0_1_0_7_1 + 0.000657467532467561*G0_1_0_7_2 - 0.00591720779220802*G0_1_0_7_3 - 0.002218952922078*G0_1_0_7_4 + 0.0739650974026002*G0_1_0_7_7 - 0.000739650974026027*G0_1_0_7_8 + 0.019230925324676*G0_1_0_7_9 + 0.0142999188311693*G0_1_0_8_0 + 0.00550629058441573*G0_1_0_8_1 + 0.000164366883116886*G0_1_0_8_2 + 0.00443790584415601*G0_1_0_8_3 + 0.001479301948052*G0_1_0_8_4 - 0.00443790584415599*G0_1_0_8_6 - 0.000739650974026026*G0_1_0_8_7 - 0.020710227272728*G0_1_0_8_9 - 0.00641030844155868*G0_1_0_9_0 + 0.00591720779220799*G0_1_0_9_1 - 0.00345170454545466*G0_1_0_9_2 - 0.00591720779220795*G0_1_0_9_3 + 0.00739650974025997*G0_1_0_9_4 + 0.019230925324676*G0_1_0_9_5 + 0.019230925324676*G0_1_0_9_6 + 0.019230925324676*G0_1_0_9_7 - 0.020710227272728*G0_1_0_9_8 - 0.0887581168831197*G0_1_0_9_9;
    A[57] = A[75] - 0.161627435064941*G0_0_1_0_0 - 0.00904017857142888*G0_0_1_0_1 - 0.00904017857142887*G0_0_1_0_2 + 0.0032873376623378*G0_0_1_0_3 + 0.00328733766233778*G0_0_1_0_4 - 0.0912236201298731*G0_0_1_0_5 + 0.0394480519480532*G0_0_1_0_6 - 0.0912236201298732*G0_0_1_0_7 + 0.0394480519480533*G0_0_1_0_8 - 0.0246550324675334*G0_0_1_0_9 - 0.00904017857142888*G0_0_1_1_0 + 0.0017167207792208*G0_0_1_1_1 - 0.000127840909090912*G0_0_1_1_2 - 0.000493100649350664*G0_0_1_1_4 + 0.00180803571428578*G0_0_1_1_5 + 0.0020545860389611*G0_0_1_1_6 - 0.00673904220779242*G0_0_1_1_7 + 0.000904017857142882*G0_0_1_1_8 + 0.00690340909090934*G0_0_1_1_9 - 0.00904017857142887*G0_0_1_2_0 - 0.000127840909090912*G0_0_1_2_1 + 0.00171672077922086*G0_0_1_2_2 - 0.00049310064935067*G0_0_1_2_3 - 0.00673904220779243*G0_0_1_2_5 + 0.0009040178571429*G0_0_1_2_6 + 0.00180803571428579*G0_0_1_2_7 + 0.0020545860389611*G0_0_1_2_8 + 0.00690340909090934*G0_0_1_2_9 + 0.0032873376623378*G0_0_1_3_0 - 0.00049310064935067*G0_0_1_3_2 + 0.0118344155844161*G0_0_1_3_3 - 0.00147930194805198*G0_0_1_3_4 - 0.010355113636364*G0_0_1_3_5 - 0.00073965097402599*G0_0_1_3_6 - 0.004437905844156*G0_0_1_3_7 + 0.00517755681818199*G0_0_1_3_8 - 0.011834415584416*G0_0_1_3_9 + 0.00328733766233778*G0_0_1_4_0 - 0.000493100649350664*G0_0_1_4_1 - 0.00147930194805198*G0_0_1_4_3 + 0.0118344155844159*G0_0_1_4_4 - 0.004437905844156*G0_0_1_4_5 + 0.00517755681818199*G0_0_1_4_6 - 0.010355113636364*G0_0_1_4_7 - 0.000739650974025993*G0_0_1_4_8 - 0.011834415584416*G0_0_1_4_9 - 0.0912236201298731*G0_0_1_5_0 + 0.00180803571428578*G0_0_1_5_1 - 0.00673904220779242*G0_0_1_5_2 - 0.010355113636364*G0_0_1_5_3 - 0.004437905844156*G0_0_1_5_4 + 0.0369825487012999*G0_0_1_5_6 + 0.0739650974025999*G0_0_1_5_9 + 0.0394480519480532*G0_0_1_6_0 + 0.0020545860389611*G0_0_1_6_1 + 0.000904017857142901*G0_0_1_6_2 - 0.000739650974025989*G0_0_1_6_3 + 0.00517755681818199*G0_0_1_6_4 + 0.0369825487012999*G0_0_1_6_5 - 0.00147930194805204*G0_0_1_6_6 - 0.00887581168831197*G0_0_1_6_8 - 0.019230925324676*G0_0_1_6_9 - 0.0912236201298732*G0_0_1_7_0 - 0.00673904220779242*G0_0_1_7_1 + 0.00180803571428579*G0_0_1_7_2 - 0.00443790584415601*G0_0_1_7_3 - 0.010355113636364*G0_0_1_7_4 + 0.0369825487013*G0_0_1_7_8 + 0.0739650974026*G0_0_1_7_9 + 0.0394480519480533*G0_0_1_8_0 + 0.000904017857142882*G0_0_1_8_1 + 0.0020545860389611*G0_0_1_8_2 + 0.00517755681818199*G0_0_1_8_3 - 0.000739650974025993*G0_0_1_8_4 - 0.00887581168831197*G0_0_1_8_6 + 0.0369825487013*G0_0_1_8_7 - 0.001479301948052*G0_0_1_8_8 - 0.019230925324676*G0_0_1_8_9 - 0.0246550324675334*G0_0_1_9_0 + 0.00690340909090934*G0_0_1_9_1 + 0.00690340909090934*G0_0_1_9_2 - 0.011834415584416*G0_0_1_9_3 - 0.011834415584416*G0_0_1_9_4 + 0.0739650974025999*G0_0_1_9_5 - 0.019230925324676*G0_0_1_9_6 + 0.0739650974026*G0_0_1_9_7 - 0.019230925324676*G0_0_1_9_8 + 0.142012987012992*G0_0_1_9_9 + 0.161627435064941*G0_1_0_0_0 + 0.00904017857142888*G0_1_0_0_1 + 0.00904017857142887*G0_1_0_0_2 - 0.0032873376623378*G0_1_0_0_3 - 0.00328733766233778*G0_1_0_0_4 + 0.0912236201298731*G0_1_0_0_5 - 0.0394480519480532*G0_1_0_0_6 + 0.0912236201298732*G0_1_0_0_7 - 0.0394480519480533*G0_1_0_0_8 + 0.0246550324675334*G0_1_0_0_9 + 0.00904017857142888*G0_1_0_1_0 - 0.0017167207792208*G0_1_0_1_1 + 0.000127840909090912*G0_1_0_1_2 + 0.000493100649350665*G0_1_0_1_4 - 0.00180803571428577*G0_1_0_1_5 - 0.0020545860389611*G0_1_0_1_6 + 0.00673904220779242*G0_1_0_1_7 - 0.000904017857142882*G0_1_0_1_8 - 0.00690340909090934*G0_1_0_1_9 + 0.00904017857142887*G0_1_0_2_0 + 0.000127840909090912*G0_1_0_2_1 - 0.00171672077922086*G0_1_0_2_2 + 0.000493100649350669*G0_1_0_2_3 + 0.00673904220779243*G0_1_0_2_5 - 0.000904017857142899*G0_1_0_2_6 - 0.00180803571428579*G0_1_0_2_7 - 0.0020545860389611*G0_1_0_2_8 - 0.00690340909090933*G0_1_0_2_9 - 0.0032873376623378*G0_1_0_3_0 + 0.000493100649350669*G0_1_0_3_2 - 0.011834415584416*G0_1_0_3_3 + 0.00147930194805198*G0_1_0_3_4 + 0.010355113636364*G0_1_0_3_5 + 0.000739650974025991*G0_1_0_3_6 + 0.004437905844156*G0_1_0_3_7 - 0.00517755681818199*G0_1_0_3_8 + 0.011834415584416*G0_1_0_3_9 - 0.00328733766233778*G0_1_0_4_0 + 0.000493100649350664*G0_1_0_4_1 + 0.00147930194805198*G0_1_0_4_3 - 0.0118344155844159*G0_1_0_4_4 + 0.004437905844156*G0_1_0_4_5 - 0.00517755681818199*G0_1_0_4_6 + 0.010355113636364*G0_1_0_4_7 + 0.000739650974025993*G0_1_0_4_8 + 0.011834415584416*G0_1_0_4_9 + 0.0912236201298731*G0_1_0_5_0 - 0.00180803571428577*G0_1_0_5_1 + 0.00673904220779243*G0_1_0_5_2 + 0.010355113636364*G0_1_0_5_3 + 0.004437905844156*G0_1_0_5_4 - 0.0369825487012999*G0_1_0_5_6 - 0.0739650974025999*G0_1_0_5_9 - 0.0394480519480533*G0_1_0_6_0 - 0.0020545860389611*G0_1_0_6_1 - 0.000904017857142901*G0_1_0_6_2 + 0.00073965097402599*G0_1_0_6_3 - 0.00517755681818199*G0_1_0_6_4 - 0.0369825487012999*G0_1_0_6_5 + 0.00147930194805204*G0_1_0_6_6 + 0.00887581168831197*G0_1_0_6_8 + 0.019230925324676*G0_1_0_6_9 + 0.0912236201298732*G0_1_0_7_0 + 0.00673904220779242*G0_1_0_7_1 - 0.00180803571428579*G0_1_0_7_2 + 0.004437905844156*G0_1_0_7_3 + 0.010355113636364*G0_1_0_7_4 - 0.0369825487013*G0_1_0_7_8 - 0.0739650974026*G0_1_0_7_9 - 0.0394480519480533*G0_1_0_8_0 - 0.000904017857142882*G0_1_0_8_1 - 0.0020545860389611*G0_1_0_8_2 - 0.00517755681818199*G0_1_0_8_3 + 0.000739650974025993*G0_1_0_8_4 + 0.00887581168831197*G0_1_0_8_6 - 0.0369825487013*G0_1_0_8_7 + 0.001479301948052*G0_1_0_8_8 + 0.019230925324676*G0_1_0_8_9 + 0.0246550324675334*G0_1_0_9_0 - 0.00690340909090934*G0_1_0_9_1 - 0.00690340909090933*G0_1_0_9_2 + 0.011834415584416*G0_1_0_9_3 + 0.011834415584416*G0_1_0_9_4 - 0.0739650974025999*G0_1_0_9_5 + 0.019230925324676*G0_1_0_9_6 - 0.0739650974026*G0_1_0_9_7 + 0.019230925324676*G0_1_0_9_8 - 0.142012987012992*G0_1_0_9_9;
    A[74] = A[35] - 0.00648336038961067*G0_0_0_0_0 - 0.000401785714285733*G0_0_0_0_1 + 0.000173498376623393*G0_0_0_0_2 - 0.00369825487013001*G0_0_0_0_3 - 0.00123275162337666*G0_0_0_0_4 - 0.00608157467532493*G0_0_0_0_5 + 0.00525974025974044*G0_0_0_0_6 - 0.0041913555194807*G0_0_0_0_7 + 0.000986201298701351*G0_0_0_0_8 - 0.00542410714285735*G0_0_0_0_9 - 0.000401785714285734*G0_0_0_1_0 - 0.00416396103896119*G0_0_0_1_1 + 0.00103185876623381*G0_0_0_1_2 - 0.00402698863636377*G0_0_0_1_3 + 0.00608157467532488*G0_0_0_1_4 - 0.004437905844156*G0_0_0_1_5 - 0.00320515422077933*G0_0_0_1_6 - 0.000657467532467558*G0_0_0_1_7 - 0.00189021915584422*G0_0_0_1_8 - 0.00641030844155867*G0_0_0_1_9 + 0.000173498376623393*G0_0_0_2_0 + 0.00103185876623381*G0_0_0_2_1 + 0.0356128246753259*G0_0_0_2_2 - 0.008875811688312*G0_0_0_2_3 + 0.0234222808441567*G0_0_0_2_4 - 0.00641030844155871*G0_0_0_2_5 + 0.0160257711038967*G0_0_0_2_6 + 0.000986201298701332*G0_0_0_2_8 + 0.010355113636364*G0_0_0_2_9 - 0.00369825487013001*G0_0_0_3_0 - 0.00402698863636377*G0_0_0_3_1 - 0.008875811688312*G0_0_0_3_2 - 0.090237418831172*G0_0_0_3_3 - 0.012574066558442*G0_0_0_3_4 + 0.011834415584416*G0_0_0_3_5 + 0.0103551136363639*G0_0_0_3_6 + 0.011834415584416*G0_0_0_3_7 - 0.00961546266233802*G0_0_0_3_8 - 0.00443790584415607*G0_0_0_3_9 - 0.00123275162337666*G0_0_0_4_0 + 0.00608157467532488*G0_0_0_4_1 + 0.0234222808441567*G0_0_0_4_2 - 0.012574066558442*G0_0_0_4_3 - 0.0369825487012999*G0_0_0_4_4 + 0.00443790584415599*G0_0_0_4_5 - 0.0147930194805199*G0_0_0_4_6 + 0.00147930194805199*G0_0_0_4_7 - 0.00221895292207799*G0_0_0_4_8 - 0.0399411525974039*G0_0_0_4_9 - 0.00608157467532493*G0_0_0_5_0 - 0.004437905844156*G0_0_0_5_1 - 0.00641030844155871*G0_0_0_5_2 + 0.011834415584416*G0_0_0_5_3 + 0.00443790584415599*G0_0_0_5_4 - 0.105030438311692*G0_0_0_5_5 + 0.000739650974026014*G0_0_0_5_6 - 0.01479301948052*G0_0_0_5_7 + 0.014053368506494*G0_0_0_5_8 - 0.011834415584416*G0_0_0_5_9 + 0.00525974025974044*G0_0_0_6_0 - 0.00320515422077933*G0_0_0_6_1 + 0.0160257711038967*G0_0_0_6_2 + 0.0103551136363639*G0_0_0_6_3 - 0.0147930194805199*G0_0_0_6_4 + 0.000739650974026018*G0_0_0_6_5 - 0.1109476461039*G0_0_0_6_6 + 0.000739650974026001*G0_0_0_6_7 + 0.00295860389610398*G0_0_0_6_8 - 0.0517755681818199*G0_0_0_6_9 - 0.0041913555194807*G0_0_0_7_0 - 0.000657467532467558*G0_0_0_7_1 + 0.011834415584416*G0_0_0_7_3 + 0.00147930194805199*G0_0_0_7_4 - 0.01479301948052*G0_0_0_7_5 + 0.000739650974026*G0_0_0_7_6 + 0.00147930194805197*G0_0_0_7_7 + 0.00739650974026005*G0_0_0_7_8 + 0.01479301948052*G0_0_0_7_9 + 0.000986201298701351*G0_0_0_8_0 - 0.00189021915584422*G0_0_0_8_1 + 0.000986201298701332*G0_0_0_8_2 - 0.00961546266233802*G0_0_0_8_3 - 0.00221895292207799*G0_0_0_8_4 + 0.014053368506494*G0_0_0_8_5 + 0.00295860389610398*G0_0_0_8_6 + 0.00739650974026004*G0_0_0_8_7 + 0.008875811688312*G0_0_0_8_8 + 0.023668831168832*G0_0_0_8_9 - 0.00542410714285735*G0_0_0_9_0 - 0.00641030844155867*G0_0_0_9_1 + 0.010355113636364*G0_0_0_9_2 - 0.00443790584415607*G0_0_0_9_3 - 0.0399411525974039*G0_0_0_9_4 - 0.011834415584416*G0_0_0_9_5 - 0.0517755681818199*G0_0_0_9_6 + 0.01479301948052*G0_0_0_9_7 + 0.023668831168832*G0_0_0_9_8 + 0.0710064935064957*G0_0_0_9_9 - 0.00124188311688317*G0_0_1_0_1 + 0.00124188311688317*G0_0_1_0_2 + 0.00525974025974039*G0_0_1_0_5 + 0.000328733766233779*G0_0_1_0_6 - 0.00525974025974047*G0_0_1_0_7 - 0.000328733766233762*G0_0_1_0_8 - 0.00124188311688317*G0_0_1_1_0 - 0.0346996753246765*G0_0_1_1_1 - 0.0174228896103902*G0_0_1_1_3 + 0.00871144480519508*G0_0_1_1_4 - 0.000986201298701337*G0_0_1_1_5 - 0.00320515422077933*G0_0_1_1_6 + 0.00345170454545467*G0_0_1_1_7 - 0.0150395698051954*G0_0_1_1_8 - 0.008875811688312*G0_0_1_1_9 + 0.00124188311688317*G0_0_1_2_0 + 0.0346996753246765*G0_0_1_2_2 - 0.00871144480519511*G0_0_1_2_3 + 0.0174228896103902*G0_0_1_2_4 - 0.0034517045454547*G0_0_1_2_5 + 0.0150395698051954*G0_0_1_2_6 + 0.000986201298701335*G0_0_1_2_7 + 0.00320515422077933*G0_0_1_2_8 + 0.00887581168831198*G0_0_1_2_9 - 0.0174228896103902*G0_0_1_3_1 - 0.00871144480519511*G0_0_1_3_2 + 0.00591720779220811*G0_0_1_3_3 + 0.001479301948052*G0_0_1_3_5 + 0.00961546266233795*G0_0_1_3_6 + 0.00961546266233795*G0_0_1_3_8 + 0.0266274350649359*G0_0_1_3_9 + 0.00871144480519508*G0_0_1_4_1 + 0.0174228896103902*G0_0_1_4_2 - 0.00591720779220788*G0_0_1_4_4 - 0.00961546266233794*G0_0_1_4_6 - 0.00147930194805202*G0_0_1_4_7 - 0.00961546266233797*G0_0_1_4_8 - 0.0266274350649359*G0_0_1_4_9 + 0.0052597402597404*G0_0_1_5_0 - 0.000986201298701337*G0_0_1_5_1 - 0.0034517045454547*G0_0_1_5_2 + 0.001479301948052*G0_0_1_5_3 - 0.020710227272728*G0_0_1_5_5 - 0.01479301948052*G0_0_1_5_6 + 0.00295860389610401*G0_0_1_5_8 - 0.005917207792208*G0_0_1_5_9 + 0.000328733766233779*G0_0_1_6_0 - 0.00320515422077933*G0_0_1_6_1 + 0.0150395698051954*G0_0_1_6_2 + 0.00961546266233795*G0_0_1_6_3 - 0.00961546266233794*G0_0_1_6_4 - 0.01479301948052*G0_0_1_6_5 - 0.0931960227272758*G0_0_1_6_6 - 0.00295860389610401*G0_0_1_6_7 - 0.0458583603896119*G0_0_1_6_9 - 0.00525974025974047*G0_0_1_7_0 + 0.00345170454545467*G0_0_1_7_1 + 0.000986201298701335*G0_0_1_7_2 - 0.00147930194805202*G0_0_1_7_4 - 0.00295860389610401*G0_0_1_7_6 + 0.020710227272728*G0_0_1_7_7 + 0.0147930194805201*G0_0_1_7_8 + 0.00591720779220803*G0_0_1_7_9 - 0.000328733766233761*G0_0_1_8_0 - 0.0150395698051954*G0_0_1_8_1 + 0.00320515422077933*G0_0_1_8_2 + 0.00961546266233795*G0_0_1_8_3 - 0.00961546266233797*G0_0_1_8_4 + 0.00295860389610401*G0_0_1_8_5 + 0.0147930194805201*G0_0_1_8_7 + 0.093196022727276*G0_0_1_8_8 + 0.0458583603896119*G0_0_1_8_9 - 0.008875811688312*G0_0_1_9_1 + 0.00887581168831198*G0_0_1_9_2 + 0.0266274350649359*G0_0_1_9_3 - 0.0266274350649359*G0_0_1_9_4 - 0.005917207792208*G0_0_1_9_5 - 0.0458583603896119*G0_0_1_9_6 + 0.00591720779220803*G0_0_1_9_7 + 0.0458583603896119*G0_0_1_9_8 - 0.000191761363636365*G0_1_0_0_1 + 0.000191761363636378*G0_1_0_0_2 - 0.00345170454545467*G0_1_0_0_3 + 0.00345170454545468*G0_1_0_0_4 + 0.000246550324675336*G0_1_0_0_5 + 0.001479301948052*G0_1_0_0_6 - 0.000246550324675315*G0_1_0_0_7 - 0.00147930194805201*G0_1_0_0_8 - 0.000191761363636365*G0_1_0_1_0 - 0.0073965097402599*G0_1_0_1_1 - 0.0123275162337666*G0_1_0_1_3 + 0.00788961038961064*G0_1_0_1_4 - 0.001479301948052*G0_1_0_1_5 - 0.000246550324675326*G0_1_0_1_6 + 0.00147930194805199*G0_1_0_1_7 - 0.00493100649350663*G0_1_0_1_8 - 0.00690340909090932*G0_1_0_1_9 + 0.000191761363636378*G0_1_0_2_0 + 0.00739650974026003*G0_1_0_2_2 - 0.00788961038961066*G0_1_0_2_3 + 0.0123275162337667*G0_1_0_2_4 - 0.00147930194805202*G0_1_0_2_5 + 0.00493100649350671*G0_1_0_2_6 + 0.00147930194805201*G0_1_0_2_7 + 0.000246550324675331*G0_1_0_2_8 + 0.00690340909090933*G0_1_0_2_9 - 0.00345170454545467*G0_1_0_3_0 - 0.0123275162337666*G0_1_0_3_1 - 0.00788961038961066*G0_1_0_3_2 - 0.0665685876623399*G0_1_0_3_3 + 0.00739650974025998*G0_1_0_3_5 + 0.000739650974025971*G0_1_0_3_6 + 0.010355113636364*G0_1_0_3_7 - 0.00961546266233801*G0_1_0_3_8 + 0.00345170454545468*G0_1_0_4_0 + 0.00788961038961064*G0_1_0_4_1 + 0.0123275162337667*G0_1_0_4_2 + 0.06656858766234*G0_1_0_4_4 - 0.010355113636364*G0_1_0_4_5 + 0.00961546266233806*G0_1_0_4_6 - 0.00739650974026002*G0_1_0_4_7 - 0.000739650974026*G0_1_0_4_8 + 0.000246550324675336*G0_1_0_5_0 - 0.001479301948052*G0_1_0_5_1 - 0.00147930194805202*G0_1_0_5_2 + 0.00739650974025998*G0_1_0_5_3 - 0.010355113636364*G0_1_0_5_4 - 0.0118344155844159*G0_1_0_5_5 - 0.00517755681818205*G0_1_0_5_6 + 0.00443790584415598*G0_1_0_5_8 - 0.00887581168831195*G0_1_0_5_9 + 0.001479301948052*G0_1_0_6_0 - 0.000246550324675326*G0_1_0_6_1 + 0.00493100649350671*G0_1_0_6_2 + 0.000739650974025971*G0_1_0_6_3 + 0.00961546266233805*G0_1_0_6_4 - 0.00517755681818205*G0_1_0_6_5 - 0.0118344155844157*G0_1_0_6_6 - 0.00443790584415604*G0_1_0_6_7 - 0.0221895292207799*G0_1_0_6_9 - 0.000246550324675315*G0_1_0_7_0 + 0.00147930194805199*G0_1_0_7_1 + 0.00147930194805201*G0_1_0_7_2 + 0.010355113636364*G0_1_0_7_3 - 0.00739650974026002*G0_1_0_7_4 - 0.00443790584415604*G0_1_0_7_6 + 0.0118344155844162*G0_1_0_7_7 + 0.00517755681818196*G0_1_0_7_8 + 0.00887581168831208*G0_1_0_7_9 - 0.00147930194805201*G0_1_0_8_0 - 0.00493100649350663*G0_1_0_8_1 + 0.000246550324675331*G0_1_0_8_2 - 0.00961546266233801*G0_1_0_8_3 - 0.000739650974026*G0_1_0_8_4 + 0.00443790584415598*G0_1_0_8_5 + 0.00517755681818196*G0_1_0_8_7 + 0.0118344155844161*G0_1_0_8_8 + 0.0221895292207799*G0_1_0_8_9 - 0.00690340909090932*G0_1_0_9_1 + 0.00690340909090933*G0_1_0_9_2 - 0.00887581168831195*G0_1_0_9_5 - 0.0221895292207799*G0_1_0_9_6 + 0.00887581168831208*G0_1_0_9_7 + 0.0221895292207799*G0_1_0_9_8 + 0.00648336038961056*G0_1_1_0_0 - 0.000173498376623391*G0_1_1_0_1 + 0.000401785714285726*G0_1_1_0_2 + 0.00123275162337668*G0_1_1_0_3 + 0.00369825487013002*G0_1_1_0_4 + 0.00419135551948063*G0_1_1_0_5 - 0.00098620129870132*G0_1_1_0_6 + 0.00608157467532485*G0_1_1_0_7 - 0.00525974025974042*G0_1_1_0_8 + 0.00542410714285732*G0_1_1_0_9 - 0.000173498376623391*G0_1_1_1_0 - 0.0356128246753258*G0_1_1_1_1 - 0.00103185876623379*G0_1_1_1_2 - 0.0234222808441566*G0_1_1_1_3 + 0.00887581168831196*G0_1_1_1_4 - 0.000986201298701329*G0_1_1_1_6 + 0.00641030844155867*G0_1_1_1_7 - 0.0160257711038967*G0_1_1_1_8 - 0.010355113636364*G0_1_1_1_9 + 0.000401785714285726*G0_1_1_2_0 - 0.00103185876623379*G0_1_1_2_1 + 0.00416396103896116*G0_1_1_2_2 - 0.00608157467532488*G0_1_1_2_3 + 0.00402698863636376*G0_1_1_2_4 + 0.000657467532467556*G0_1_1_2_5 + 0.00189021915584421*G0_1_1_2_6 + 0.004437905844156*G0_1_1_2_7 + 0.00320515422077933*G0_1_1_2_8 + 0.00641030844155866*G0_1_1_2_9 + 0.00123275162337668*G0_1_1_3_0 - 0.0234222808441566*G0_1_1_3_1 - 0.00608157467532488*G0_1_1_3_2 + 0.0369825487013002*G0_1_1_3_3 + 0.012574066558442*G0_1_1_3_4 - 0.00147930194805201*G0_1_1_3_5 + 0.00221895292207799*G0_1_1_3_6 - 0.00443790584415602*G0_1_1_3_7 + 0.01479301948052*G0_1_1_3_8 + 0.0399411525974039*G0_1_1_3_9 + 0.00369825487013002*G0_1_1_4_0 + 0.00887581168831196*G0_1_1_4_1 + 0.00402698863636376*G0_1_1_4_2 + 0.012574066558442*G0_1_1_4_3 + 0.090237418831172*G0_1_1_4_4 - 0.011834415584416*G0_1_1_4_5 + 0.00961546266233804*G0_1_1_4_6 - 0.011834415584416*G0_1_1_4_7 - 0.010355113636364*G0_1_1_4_8 + 0.00443790584415604*G0_1_1_4_9 + 0.00419135551948063*G0_1_1_5_0 + 0.000657467532467556*G0_1_1_5_2 - 0.00147930194805201*G0_1_1_5_3 - 0.011834415584416*G0_1_1_5_4 - 0.00147930194805196*G0_1_1_5_5 - 0.00739650974026*G0_1_1_5_6 + 0.01479301948052*G0_1_1_5_7 - 0.000739650974026009*G0_1_1_5_8 - 0.0147930194805199*G0_1_1_5_9 - 0.000986201298701319*G0_1_1_6_0 - 0.000986201298701329*G0_1_1_6_1 + 0.00189021915584421*G0_1_1_6_2 + 0.00221895292207799*G0_1_1_6_3 + 0.00961546266233804*G0_1_1_6_4 - 0.00739650974026*G0_1_1_6_5 - 0.00887581168831189*G0_1_1_6_6 - 0.014053368506494*G0_1_1_6_7 - 0.00295860389610399*G0_1_1_6_8 - 0.023668831168832*G0_1_1_6_9 + 0.00608157467532485*G0_1_1_7_0 + 0.00641030844155867*G0_1_1_7_1 + 0.004437905844156*G0_1_1_7_2 - 0.00443790584415602*G0_1_1_7_3 - 0.011834415584416*G0_1_1_7_4 + 0.01479301948052*G0_1_1_7_5 - 0.014053368506494*G0_1_1_7_6 + 0.105030438311692*G0_1_1_7_7 - 0.000739650974025979*G0_1_1_7_8 + 0.0118344155844161*G0_1_1_7_9 - 0.00525974025974042*G0_1_1_8_0 - 0.0160257711038967*G0_1_1_8_1 + 0.00320515422077933*G0_1_1_8_2 + 0.01479301948052*G0_1_1_8_3 - 0.010355113636364*G0_1_1_8_4 - 0.000739650974026009*G0_1_1_8_5 - 0.00295860389610399*G0_1_1_8_6 - 0.000739650974025979*G0_1_1_8_7 + 0.1109476461039*G0_1_1_8_8 + 0.0517755681818199*G0_1_1_8_9 + 0.00542410714285732*G0_1_1_9_0 - 0.010355113636364*G0_1_1_9_1 + 0.00641030844155866*G0_1_1_9_2 + 0.0399411525974039*G0_1_1_9_3 + 0.00443790584415604*G0_1_1_9_4 - 0.0147930194805199*G0_1_1_9_5 - 0.023668831168832*G0_1_1_9_6 + 0.0118344155844161*G0_1_1_9_7 + 0.0517755681818199*G0_1_1_9_8 - 0.0710064935064956*G0_1_1_9_9;
    A[53] = A[35] + 0.00447443181818204*G0_0_1_0_0 + 0.000703125000000024*G0_0_1_0_1 + 0.00175324675324683*G0_0_1_0_2 + 0.000657467532467553*G0_0_1_0_3 - 0.00279423701298712*G0_0_1_0_4 + 0.00723214285714312*G0_0_1_0_5 - 0.00115056818181824*G0_0_1_0_6 + 0.00221895292207803*G0_0_1_0_7 + 0.00197240259740267*G0_0_1_0_9 + 0.000703125000000024*G0_0_1_1_0 + 0.00447443181818187*G0_0_1_1_1 + 0.00175324675324682*G0_0_1_1_2 + 0.00723214285714307*G0_0_1_1_3 - 0.0011505681818182*G0_0_1_1_4 + 0.000657467532467554*G0_0_1_1_5 - 0.00279423701298711*G0_0_1_1_6 + 0.00221895292207795*G0_0_1_1_8 + 0.00197240259740266*G0_0_1_1_9 + 0.00175324675324683*G0_0_1_2_0 + 0.00175324675324682*G0_0_1_2_1 + 0.0317775974025985*G0_0_1_2_2 - 0.00197240259740267*G0_0_1_2_3 + 0.0123275162337667*G0_0_1_2_4 - 0.0019724025974027*G0_0_1_2_5 + 0.0123275162337667*G0_0_1_2_6 + 0.000164366883116888*G0_0_1_2_7 + 0.000164366883116884*G0_0_1_2_8 + 0.00394480519480533*G0_0_1_2_9 + 0.000657467532467553*G0_0_1_3_0 + 0.00723214285714307*G0_0_1_3_1 - 0.00197240259740267*G0_0_1_3_2 - 0.020710227272728*G0_0_1_3_4 + 0.00443790584415596*G0_0_1_3_6 - 0.00591720779220799*G0_0_1_3_7 + 0.010355113636364*G0_0_1_3_8 + 0.00591720779220801*G0_0_1_3_9 - 0.00279423701298712*G0_0_1_4_0 - 0.0011505681818182*G0_0_1_4_1 + 0.0123275162337667*G0_0_1_4_2 - 0.020710227272728*G0_0_1_4_3 - 0.072485795454548*G0_0_1_4_4 + 0.00443790584415599*G0_0_1_4_5 - 0.00887581168831198*G0_0_1_4_6 + 0.005917207792208*G0_0_1_4_7 - 0.00443790584415598*G0_0_1_4_8 - 0.020710227272728*G0_0_1_4_9 + 0.00723214285714312*G0_0_1_5_0 + 0.000657467532467555*G0_0_1_5_1 - 0.0019724025974027*G0_0_1_5_2 + 0.00443790584415599*G0_0_1_5_4 - 0.020710227272728*G0_0_1_5_6 + 0.010355113636364*G0_0_1_5_7 - 0.005917207792208*G0_0_1_5_8 + 0.00591720779220798*G0_0_1_5_9 - 0.00115056818181824*G0_0_1_6_0 - 0.00279423701298711*G0_0_1_6_1 + 0.0123275162337667*G0_0_1_6_2 + 0.00443790584415596*G0_0_1_6_3 - 0.00887581168831198*G0_0_1_6_4 - 0.020710227272728*G0_0_1_6_5 - 0.0724857954545479*G0_0_1_6_6 - 0.004437905844156*G0_0_1_6_7 + 0.00591720779220799*G0_0_1_6_8 - 0.020710227272728*G0_0_1_6_9 + 0.00221895292207803*G0_0_1_7_0 + 0.000164366883116888*G0_0_1_7_2 - 0.00591720779220799*G0_0_1_7_3 + 0.005917207792208*G0_0_1_7_4 + 0.010355113636364*G0_0_1_7_5 - 0.004437905844156*G0_0_1_7_6 + 0.00887581168831196*G0_0_1_7_7 - 0.01109476461039*G0_0_1_7_8 + 0.00295860389610398*G0_0_1_7_9 + 0.00221895292207795*G0_0_1_8_1 + 0.000164366883116884*G0_0_1_8_2 + 0.010355113636364*G0_0_1_8_3 - 0.00443790584415598*G0_0_1_8_4 - 0.005917207792208*G0_0_1_8_5 + 0.00591720779220799*G0_0_1_8_6 - 0.01109476461039*G0_0_1_8_7 + 0.00887581168831188*G0_0_1_8_8 + 0.00295860389610399*G0_0_1_8_9 + 0.00197240259740267*G0_0_1_9_0 + 0.00197240259740266*G0_0_1_9_1 + 0.00394480519480534*G0_0_1_9_2 + 0.00591720779220801*G0_0_1_9_3 - 0.020710227272728*G0_0_1_9_4 + 0.00591720779220798*G0_0_1_9_5 - 0.020710227272728*G0_0_1_9_6 + 0.00295860389610398*G0_0_1_9_7 + 0.00295860389610399*G0_0_1_9_8 + 0.124261363636368*G0_0_1_9_9 - 0.00447443181818204*G0_1_0_0_0 - 0.000703125000000024*G0_1_0_0_1 - 0.00175324675324683*G0_1_0_0_2 - 0.000657467532467553*G0_1_0_0_3 + 0.00279423701298712*G0_1_0_0_4 - 0.00723214285714312*G0_1_0_0_5 + 0.00115056818181824*G0_1_0_0_6 - 0.00221895292207803*G0_1_0_0_7 - 0.00197240259740267*G0_1_0_0_9 - 0.000703125000000024*G0_1_0_1_0 - 0.00447443181818187*G0_1_0_1_1 - 0.00175324675324682*G0_1_0_1_2 - 0.00723214285714307*G0_1_0_1_3 + 0.0011505681818182*G0_1_0_1_4 - 0.000657467532467555*G0_1_0_1_5 + 0.00279423701298711*G0_1_0_1_6 - 0.00221895292207795*G0_1_0_1_8 - 0.00197240259740266*G0_1_0_1_9 - 0.00175324675324683*G0_1_0_2_0 - 0.00175324675324682*G0_1_0_2_1 - 0.0317775974025985*G0_1_0_2_2 + 0.00197240259740268*G0_1_0_2_3 - 0.0123275162337667*G0_1_0_2_4 + 0.0019724025974027*G0_1_0_2_5 - 0.0123275162337667*G0_1_0_2_6 - 0.000164366883116887*G0_1_0_2_7 - 0.000164366883116884*G0_1_0_2_8 - 0.00394480519480533*G0_1_0_2_9 - 0.000657467532467553*G0_1_0_3_0 - 0.00723214285714307*G0_1_0_3_1 + 0.00197240259740267*G0_1_0_3_2 + 0.020710227272728*G0_1_0_3_4 - 0.00443790584415596*G0_1_0_3_6 + 0.00591720779220799*G0_1_0_3_7 - 0.010355113636364*G0_1_0_3_8 - 0.00591720779220801*G0_1_0_3_9 + 0.00279423701298712*G0_1_0_4_0 + 0.0011505681818182*G0_1_0_4_1 - 0.0123275162337667*G0_1_0_4_2 + 0.020710227272728*G0_1_0_4_3 + 0.072485795454548*G0_1_0_4_4 - 0.00443790584415599*G0_1_0_4_5 + 0.00887581168831198*G0_1_0_4_6 - 0.005917207792208*G0_1_0_4_7 + 0.00443790584415598*G0_1_0_4_8 + 0.020710227272728*G0_1_0_4_9 - 0.00723214285714312*G0_1_0_5_0 - 0.000657467532467555*G0_1_0_5_1 + 0.0019724025974027*G0_1_0_5_2 - 0.00443790584415599*G0_1_0_5_4 + 0.020710227272728*G0_1_0_5_6 - 0.010355113636364*G0_1_0_5_7 + 0.005917207792208*G0_1_0_5_8 - 0.00591720779220798*G0_1_0_5_9 + 0.00115056818181824*G0_1_0_6_0 + 0.00279423701298711*G0_1_0_6_1 - 0.0123275162337667*G0_1_0_6_2 - 0.00443790584415596*G0_1_0_6_3 + 0.00887581168831198*G0_1_0_6_4 + 0.020710227272728*G0_1_0_6_5 + 0.0724857954545478*G0_1_0_6_6 + 0.004437905844156*G0_1_0_6_7 - 0.00591720779220799*G0_1_0_6_8 + 0.020710227272728*G0_1_0_6_9 - 0.00221895292207803*G0_1_0_7_0 - 0.000164366883116888*G0_1_0_7_2 + 0.00591720779220799*G0_1_0_7_3 - 0.005917207792208*G0_1_0_7_4 - 0.010355113636364*G0_1_0_7_5 + 0.004437905844156*G0_1_0_7_6 - 0.00887581168831196*G0_1_0_7_7 + 0.01109476461039*G0_1_0_7_8 - 0.00295860389610398*G0_1_0_7_9 - 0.00221895292207795*G0_1_0_8_1 - 0.000164366883116884*G0_1_0_8_2 - 0.010355113636364*G0_1_0_8_3 + 0.00443790584415598*G0_1_0_8_4 + 0.005917207792208*G0_1_0_8_5 - 0.00591720779220799*G0_1_0_8_6 + 0.01109476461039*G0_1_0_8_7 - 0.00887581168831188*G0_1_0_8_8 - 0.00295860389610399*G0_1_0_8_9 - 0.00197240259740267*G0_1_0_9_0 - 0.00197240259740266*G0_1_0_9_1 - 0.00394480519480534*G0_1_0_9_2 - 0.00591720779220801*G0_1_0_9_3 + 0.020710227272728*G0_1_0_9_4 - 0.00591720779220798*G0_1_0_9_5 + 0.020710227272728*G0_1_0_9_6 - 0.00295860389610398*G0_1_0_9_7 - 0.00295860389610399*G0_1_0_9_8 - 0.124261363636368*G0_1_0_9_9;
    A[68] = A[86] - 0.0317775974025984*G0_0_1_0_0 - 0.00175324675324682*G0_0_1_0_1 - 0.00175324675324681*G0_0_1_0_2 - 0.000164366883116884*G0_0_1_0_3 - 0.000164366883116892*G0_0_1_0_4 - 0.0123275162337666*G0_0_1_0_5 + 0.00197240259740265*G0_0_1_0_6 - 0.0123275162337666*G0_0_1_0_7 + 0.00197240259740265*G0_0_1_0_8 - 0.00394480519480534*G0_0_1_0_9 - 0.00175324675324682*G0_0_1_1_0 - 0.00447443181818204*G0_0_1_1_1 - 0.000703125000000029*G0_0_1_1_2 - 0.00221895292207803*G0_0_1_1_3 + 0.00279423701298711*G0_0_1_1_5 - 0.000657467532467555*G0_0_1_1_6 + 0.00115056818181825*G0_0_1_1_7 - 0.00723214285714316*G0_0_1_1_8 - 0.00197240259740268*G0_0_1_1_9 - 0.00175324675324681*G0_0_1_2_0 - 0.000703125000000029*G0_0_1_2_1 - 0.00447443181818198*G0_0_1_2_2 - 0.00221895292207802*G0_0_1_2_4 + 0.00115056818181823*G0_0_1_2_5 - 0.0072321428571431*G0_0_1_2_6 + 0.00279423701298711*G0_0_1_2_7 - 0.000657467532467564*G0_0_1_2_8 - 0.00197240259740267*G0_0_1_2_9 - 0.000164366883116885*G0_0_1_3_0 - 0.00221895292207803*G0_0_1_3_1 - 0.00887581168831195*G0_0_1_3_3 + 0.01109476461039*G0_0_1_3_4 - 0.00591720779220798*G0_0_1_3_5 + 0.00591720779220799*G0_0_1_3_6 + 0.00443790584415599*G0_0_1_3_7 - 0.010355113636364*G0_0_1_3_8 - 0.002958603896104*G0_0_1_3_9 - 0.000164366883116892*G0_0_1_4_0 - 0.00221895292207802*G0_0_1_4_2 + 0.01109476461039*G0_0_1_4_3 - 0.00887581168831213*G0_0_1_4_4 + 0.004437905844156*G0_0_1_4_5 - 0.010355113636364*G0_0_1_4_6 - 0.005917207792208*G0_0_1_4_7 + 0.00591720779220802*G0_0_1_4_8 - 0.00295860389610399*G0_0_1_4_9 - 0.0123275162337666*G0_0_1_5_0 + 0.00279423701298711*G0_0_1_5_1 + 0.00115056818181823*G0_0_1_5_2 - 0.00591720779220798*G0_0_1_5_3 + 0.004437905844156*G0_0_1_5_4 + 0.0724857954545479*G0_0_1_5_5 + 0.020710227272728*G0_0_1_5_6 + 0.008875811688312*G0_0_1_5_7 - 0.00443790584415599*G0_0_1_5_8 + 0.020710227272728*G0_0_1_5_9 + 0.00197240259740265*G0_0_1_6_0 - 0.000657467532467555*G0_0_1_6_1 - 0.0072321428571431*G0_0_1_6_2 + 0.00591720779220799*G0_0_1_6_3 - 0.010355113636364*G0_0_1_6_4 + 0.020710227272728*G0_0_1_6_5 - 0.004437905844156*G0_0_1_6_7 - 0.00591720779220798*G0_0_1_6_9 - 0.0123275162337666*G0_0_1_7_0 + 0.00115056818181825*G0_0_1_7_1 + 0.00279423701298711*G0_0_1_7_2 + 0.00443790584415599*G0_0_1_7_3 - 0.005917207792208*G0_0_1_7_4 + 0.008875811688312*G0_0_1_7_5 - 0.004437905844156*G0_0_1_7_6 + 0.0724857954545481*G0_0_1_7_7 + 0.020710227272728*G0_0_1_7_8 + 0.020710227272728*G0_0_1_7_9 + 0.00197240259740265*G0_0_1_8_0 - 0.00723214285714316*G0_0_1_8_1 - 0.000657467532467564*G0_0_1_8_2 - 0.010355113636364*G0_0_1_8_3 + 0.00591720779220802*G0_0_1_8_4 - 0.00443790584415599*G0_0_1_8_5 + 0.020710227272728*G0_0_1_8_7 - 0.00591720779220803*G0_0_1_8_9 - 0.00394480519480534*G0_0_1_9_0 - 0.00197240259740268*G0_0_1_9_1 - 0.00197240259740267*G0_0_1_9_2 - 0.002958603896104*G0_0_1_9_3 - 0.00295860389610399*G0_0_1_9_4 + 0.020710227272728*G0_0_1_9_5 - 0.00591720779220798*G0_0_1_9_6 + 0.020710227272728*G0_0_1_9_7 - 0.00591720779220804*G0_0_1_9_8 - 0.124261363636368*G0_0_1_9_9 + 0.0317775974025984*G0_1_0_0_0 + 0.00175324675324682*G0_1_0_0_1 + 0.00175324675324681*G0_1_0_0_2 + 0.000164366883116885*G0_1_0_0_3 + 0.000164366883116892*G0_1_0_0_4 + 0.0123275162337666*G0_1_0_0_5 - 0.00197240259740265*G0_1_0_0_6 + 0.0123275162337666*G0_1_0_0_7 - 0.00197240259740265*G0_1_0_0_8 + 0.00394480519480534*G0_1_0_0_9 + 0.00175324675324682*G0_1_0_1_0 + 0.00447443181818204*G0_1_0_1_1 + 0.000703125000000029*G0_1_0_1_2 + 0.00221895292207803*G0_1_0_1_3 - 0.00279423701298711*G0_1_0_1_5 + 0.000657467532467555*G0_1_0_1_6 - 0.00115056818181825*G0_1_0_1_7 + 0.00723214285714316*G0_1_0_1_8 + 0.00197240259740268*G0_1_0_1_9 + 0.00175324675324681*G0_1_0_2_0 + 0.000703125000000029*G0_1_0_2_1 + 0.00447443181818198*G0_1_0_2_2 + 0.00221895292207802*G0_1_0_2_4 - 0.00115056818181823*G0_1_0_2_5 + 0.0072321428571431*G0_1_0_2_6 - 0.00279423701298711*G0_1_0_2_7 + 0.000657467532467564*G0_1_0_2_8 + 0.00197240259740267*G0_1_0_2_9 + 0.000164366883116885*G0_1_0_3_0 + 0.00221895292207803*G0_1_0_3_1 + 0.00887581168831195*G0_1_0_3_3 - 0.01109476461039*G0_1_0_3_4 + 0.00591720779220798*G0_1_0_3_5 - 0.00591720779220799*G0_1_0_3_6 - 0.00443790584415599*G0_1_0_3_7 + 0.010355113636364*G0_1_0_3_8 + 0.002958603896104*G0_1_0_3_9 + 0.000164366883116892*G0_1_0_4_0 + 0.00221895292207802*G0_1_0_4_2 - 0.01109476461039*G0_1_0_4_3 + 0.00887581168831213*G0_1_0_4_4 - 0.004437905844156*G0_1_0_4_5 + 0.010355113636364*G0_1_0_4_6 + 0.005917207792208*G0_1_0_4_7 - 0.00591720779220802*G0_1_0_4_8 + 0.00295860389610399*G0_1_0_4_9 + 0.0123275162337666*G0_1_0_5_0 - 0.00279423701298711*G0_1_0_5_1 - 0.00115056818181823*G0_1_0_5_2 + 0.00591720779220798*G0_1_0_5_3 - 0.004437905844156*G0_1_0_5_4 - 0.0724857954545479*G0_1_0_5_5 - 0.020710227272728*G0_1_0_5_6 - 0.008875811688312*G0_1_0_5_7 + 0.00443790584415599*G0_1_0_5_8 - 0.020710227272728*G0_1_0_5_9 - 0.00197240259740265*G0_1_0_6_0 + 0.000657467532467555*G0_1_0_6_1 + 0.0072321428571431*G0_1_0_6_2 - 0.00591720779220799*G0_1_0_6_3 + 0.010355113636364*G0_1_0_6_4 - 0.020710227272728*G0_1_0_6_5 + 0.004437905844156*G0_1_0_6_7 + 0.00591720779220798*G0_1_0_6_9 + 0.0123275162337666*G0_1_0_7_0 - 0.00115056818181825*G0_1_0_7_1 - 0.00279423701298711*G0_1_0_7_2 - 0.00443790584415599*G0_1_0_7_3 + 0.005917207792208*G0_1_0_7_4 - 0.008875811688312*G0_1_0_7_5 + 0.004437905844156*G0_1_0_7_6 - 0.0724857954545481*G0_1_0_7_7 - 0.020710227272728*G0_1_0_7_8 - 0.020710227272728*G0_1_0_7_9 - 0.00197240259740265*G0_1_0_8_0 + 0.00723214285714316*G0_1_0_8_1 + 0.000657467532467564*G0_1_0_8_2 + 0.010355113636364*G0_1_0_8_3 - 0.00591720779220802*G0_1_0_8_4 + 0.00443790584415599*G0_1_0_8_5 - 0.020710227272728*G0_1_0_8_7 + 0.00591720779220803*G0_1_0_8_9 + 0.00394480519480534*G0_1_0_9_0 + 0.00197240259740268*G0_1_0_9_1 + 0.00197240259740267*G0_1_0_9_2 + 0.002958603896104*G0_1_0_9_3 + 0.00295860389610399*G0_1_0_9_4 - 0.020710227272728*G0_1_0_9_5 + 0.00591720779220798*G0_1_0_9_6 - 0.020710227272728*G0_1_0_9_7 + 0.00591720779220804*G0_1_0_9_8 + 0.124261363636368*G0_1_0_9_9;
    A[48] = -A[68] + 0.0331655844155855*G0_1_0_0_0 + 0.00561586850649372*G0_1_0_0_1 + 0.00146103896103902*G0_1_0_0_2 - 0.000493100649350685*G0_1_0_0_3 + 0.013313717532468*G0_1_0_0_5 - 0.002958603896104*G0_1_0_0_6 + 0.0137246347402602*G0_1_0_0_7 + 0.00410917207792223*G0_1_0_0_8 + 0.00739650974026*G0_1_0_0_9 + 0.00561586850649372*G0_1_0_1_0 + 0.0778916396103922*G0_1_0_1_1 + 0.00346996753246765*G0_1_0_1_2 + 0.0305722402597412*G0_1_0_1_3 - 0.0142999188311693*G0_1_0_1_4 - 0.00295860389610399*G0_1_0_1_5 - 0.00197240259740266*G0_1_0_1_6 - 0.0179159902597409*G0_1_0_1_7 + 0.0528439529220798*G0_1_0_1_8 + 0.00838271103896135*G0_1_0_1_9 + 0.00146103896103902*G0_1_0_2_0 + 0.00346996753246765*G0_1_0_2_1 + 0.00238331980519487*G0_1_0_2_3 - 0.00328733766233772*G0_1_0_2_4 + 0.00156148538961042*G0_1_0_2_5 + 0.00328733766233782*G0_1_0_2_6 - 0.00493100649350667*G0_1_0_2_7 - 0.00394480519480532*G0_1_0_2_9 - 0.000493100649350685*G0_1_0_3_0 + 0.0305722402597412*G0_1_0_3_1 + 0.00238331980519487*G0_1_0_3_2 - 0.0650892857142883*G0_1_0_3_3 - 0.010355113636364*G0_1_0_3_4 + 0.00813616071428598*G0_1_0_3_5 - 0.00443790584415594*G0_1_0_3_7 + 0.010355113636364*G0_1_0_3_8 - 0.016272321428572*G0_1_0_3_9 - 0.0142999188311693*G0_1_0_4_1 - 0.00328733766233772*G0_1_0_4_2 - 0.010355113636364*G0_1_0_4_3 + 0.00887581168831193*G0_1_0_4_4 - 0.00591720779220797*G0_1_0_4_5 + 0.00591720779220799*G0_1_0_4_6 + 0.010355113636364*G0_1_0_4_7 - 0.00591720779220799*G0_1_0_4_8 + 0.0236688311688319*G0_1_0_4_9 + 0.013313717532468*G0_1_0_5_0 - 0.00295860389610399*G0_1_0_5_1 + 0.00156148538961041*G0_1_0_5_2 + 0.00813616071428598*G0_1_0_5_3 - 0.00591720779220797*G0_1_0_5_4 - 0.0754443993506518*G0_1_0_5_5 - 0.019230925324676*G0_1_0_5_6 - 0.011834415584416*G0_1_0_5_7 + 0.00295860389610399*G0_1_0_5_8 - 0.028106737012988*G0_1_0_5_9 - 0.002958603896104*G0_1_0_6_0 - 0.00197240259740266*G0_1_0_6_1 + 0.00328733766233782*G0_1_0_6_2 + 0.00591720779220799*G0_1_0_6_4 - 0.019230925324676*G0_1_0_6_5 - 0.0207102272727279*G0_1_0_6_6 + 0.00887581168831201*G0_1_0_6_7 + 0.00591720779220799*G0_1_0_6_8 + 0.011834415584416*G0_1_0_6_9 + 0.0137246347402602*G0_1_0_7_0 - 0.0179159902597409*G0_1_0_7_1 - 0.00493100649350667*G0_1_0_7_2 - 0.00443790584415595*G0_1_0_7_3 + 0.010355113636364*G0_1_0_7_4 - 0.011834415584416*G0_1_0_7_5 + 0.00887581168831201*G0_1_0_7_6 - 0.113906250000004*G0_1_0_7_7 - 0.056953125000002*G0_1_0_7_8 - 0.039941152597404*G0_1_0_7_9 + 0.00410917207792223*G0_1_0_8_0 + 0.0528439529220798*G0_1_0_8_1 + 0.010355113636364*G0_1_0_8_3 - 0.00591720779220799*G0_1_0_8_4 + 0.00295860389610399*G0_1_0_8_5 + 0.00591720779220799*G0_1_0_8_6 - 0.056953125000002*G0_1_0_8_7 - 0.013313717532468*G0_1_0_8_9 + 0.00739650974026*G0_1_0_9_0 + 0.00838271103896135*G0_1_0_9_1 - 0.00394480519480532*G0_1_0_9_2 - 0.016272321428572*G0_1_0_9_3 + 0.0236688311688319*G0_1_0_9_4 - 0.0281067370129879*G0_1_0_9_5 + 0.011834415584416*G0_1_0_9_6 - 0.039941152597404*G0_1_0_9_7 - 0.013313717532468*G0_1_0_9_8 + 0.213019480519487*G0_1_0_9_9 - 0.00162540584415587*G0_1_1_0_0 + 0.00705864448051976*G0_1_1_0_1 + 0.000100446428571437*G0_1_1_0_2 - 0.00271205357142868*G0_1_1_0_3 - 0.00197240259740267*G0_1_1_0_4 - 0.00147930194805199*G0_1_1_0_5 + 0.000493100649350665*G0_1_1_0_6 - 0.00846489448051976*G0_1_1_0_7 + 0.0119987824675329*G0_1_1_0_8 - 0.00641030844155867*G0_1_1_0_9 + 0.00705864448051976*G0_1_1_1_0 + 0.0925933441558473*G0_1_1_1_1 + 0.00373478084415597*G0_1_1_1_2 + 0.0406808035714299*G0_1_1_1_3 - 0.0172585227272733*G0_1_1_1_4 - 0.001479301948052*G0_1_1_1_5 - 0.0345170454545467*G0_1_1_1_7 + 0.0727323457792234*G0_1_1_1_8 + 0.0172585227272733*G0_1_1_1_9 + 0.000100446428571436*G0_1_1_2_0 + 0.00373478084415597*G0_1_1_2_1 - 0.00273944805194808*G0_1_1_2_2 + 0.00476663961038975*G0_1_1_2_3 - 0.00410917207792219*G0_1_1_2_4 + 0.00065746753246754*G0_1_1_2_5 - 0.00328733766233774*G0_1_1_2_6 - 0.00221895292207799*G0_1_1_2_7 + 0.00961546266233798*G0_1_1_2_8 - 0.000493100649350662*G0_1_1_2_9 - 0.00271205357142868*G0_1_1_3_0 + 0.0406808035714299*G0_1_1_3_1 + 0.00476663961038976*G0_1_1_3_2 - 0.0976339285714323*G0_1_1_3_3 - 0.015532670454546*G0_1_1_3_4 + 0.008875811688312*G0_1_1_3_5 - 0.00517755681818198*G0_1_1_3_6 + 0.00295860389610402*G0_1_1_3_7 + 0.0310653409090919*G0_1_1_3_8 - 0.0576927759740281*G0_1_1_3_9 - 0.00197240259740267*G0_1_1_4_0 - 0.0172585227272733*G0_1_1_4_1 - 0.00410917207792219*G0_1_1_4_2 - 0.015532670454546*G0_1_1_4_3 - 0.00443790584415603*G0_1_1_4_4 + 0.00073965097402599*G0_1_1_4_5 + 0.00443790584415599*G0_1_1_4_6 + 0.00887581168831198*G0_1_1_4_7 - 0.0340239448051959*G0_1_1_4_8 - 0.00147930194805199*G0_1_1_5_0 - 0.001479301948052*G0_1_1_5_1 + 0.00065746753246754*G0_1_1_5_2 + 0.008875811688312*G0_1_1_5_3 + 0.00073965097402599*G0_1_1_5_4 + 0.00887581168831204*G0_1_1_5_5 + 0.000739650974025982*G0_1_1_5_6 - 0.00073965097402598*G0_1_1_5_7 - 0.000739650974026011*G0_1_1_5_8 + 0.020710227272728*G0_1_1_5_9 + 0.000493100649350665*G0_1_1_6_0 - 0.00328733766233774*G0_1_1_6_2 - 0.00517755681818198*G0_1_1_6_3 + 0.00443790584415599*G0_1_1_6_4 + 0.000739650974025982*G0_1_1_6_5 + 0.010355113636364*G0_1_1_6_6 + 0.00147930194805198*G0_1_1_6_7 - 0.011834415584416*G0_1_1_6_8 + 0.011834415584416*G0_1_1_6_9 - 0.00846489448051976*G0_1_1_7_0 - 0.0345170454545467*G0_1_1_7_1 - 0.00221895292207799*G0_1_1_7_2 + 0.00295860389610402*G0_1_1_7_3 + 0.00887581168831198*G0_1_1_7_4 - 0.000739650974025981*G0_1_1_7_5 + 0.00147930194805198*G0_1_1_7_6 + 0.0162723214285721*G0_1_1_7_7 - 0.0451187094155861*G0_1_1_7_8 + 0.016272321428572*G0_1_1_7_9 + 0.0119987824675329*G0_1_1_8_0 + 0.0727323457792234*G0_1_1_8_1 + 0.00961546266233798*G0_1_1_8_2 + 0.0310653409090919*G0_1_1_8_3 - 0.0340239448051959*G0_1_1_8_4 - 0.000739650974026011*G0_1_1_8_5 - 0.011834415584416*G0_1_1_8_6 - 0.045118709415586*G0_1_1_8_7 + 0.257398538961048*G0_1_1_8_8 + 0.0162723214285719*G0_1_1_8_9 - 0.00641030844155867*G0_1_1_9_0 + 0.0172585227272733*G0_1_1_9_1 - 0.000493100649350662*G0_1_1_9_2 - 0.0576927759740281*G0_1_1_9_3 + 0.020710227272728*G0_1_1_9_5 + 0.011834415584416*G0_1_1_9_6 + 0.016272321428572*G0_1_1_9_7 + 0.0162723214285719*G0_1_1_9_8 - 0.0177516233766241*G0_1_1_9_9;
    A[24] = A[27] - 0.0153348214285719*G0_1_0_0_0 + 0.00766741071428602*G0_1_0_0_2 - 0.0047575081168833*G0_1_0_0_3 + 0.0113504464285719*G0_1_0_0_4 - 0.0124918831168836*G0_1_0_0_5 + 0.0187652191558449*G0_1_0_0_6 - 0.0120535714285718*G0_1_0_0_7 + 0.00309557629870141*G0_1_0_0_8 + 0.00372564935064949*G0_1_0_0_9 - 0.00584415584415603*G0_1_0_1_1 + 0.00778612012987042*G0_1_0_1_2 - 0.00875710227272758*G0_1_0_1_3 + 0.0157061688311694*G0_1_0_1_4 - 0.005195819805195*G0_1_0_1_5 + 0.011925730519481*G0_1_0_1_6 - 0.00151582792207797*G0_1_0_1_7 - 0.00384435876623391*G0_1_0_1_8 + 0.00443790584415601*G0_1_0_1_9 + 0.00766741071428602*G0_1_0_2_0 + 0.00778612012987042*G0_1_0_2_1 + 0.124736201298706*G0_1_0_2_2 - 0.0360146103896116*G0_1_0_2_3 + 0.0785765016233794*G0_1_0_2_4 - 0.0375669642857156*G0_1_0_2_5 + 0.0830509334415614*G0_1_0_2_6 - 0.00223721590909099*G0_1_0_2_7 - 0.00122362012987017*G0_1_0_2_8 + 0.0149573863636369*G0_1_0_2_9 - 0.0047575081168833*G0_1_0_3_0 - 0.00875710227272758*G0_1_0_3_1 - 0.0360146103896116*G0_1_0_3_2 + 0.0407629870129884*G0_1_0_3_3 - 0.0652536525974049*G0_1_0_3_4 + 0.020710227272728*G0_1_0_3_5 - 0.047337662337664*G0_1_0_3_6 + 0.00271205357142867*G0_1_0_3_7 + 0.00517755681818198*G0_1_0_3_8 - 0.0187378246753253*G0_1_0_3_9 + 0.0113504464285719*G0_1_0_4_0 + 0.0157061688311694*G0_1_0_4_1 + 0.0785765016233794*G0_1_0_4_2 - 0.0652536525974049*G0_1_0_4_3 + 0.167982954545461*G0_1_0_4_4 - 0.0456118100649367*G0_1_0_4_5 + 0.0929494724026008*G0_1_0_4_6 - 0.00788961038961066*G0_1_0_4_7 - 0.00788961038961065*G0_1_0_4_8 + 0.0463514610389627*G0_1_0_4_9 - 0.0124918831168836*G0_1_0_5_0 - 0.005195819805195*G0_1_0_5_1 - 0.0375669642857156*G0_1_0_5_2 + 0.020710227272728*G0_1_0_5_3 - 0.0456118100649367*G0_1_0_5_4 + 0.0420779220779236*G0_1_0_5_5 - 0.0710886769480545*G0_1_0_5_6 + 0.000821834415584448*G0_1_0_5_7 + 0.00402698863636377*G0_1_0_5_8 - 0.019230925324676*G0_1_0_5_9 + 0.0187652191558449*G0_1_0_6_0 + 0.011925730519481*G0_1_0_6_1 + 0.0830509334415614*G0_1_0_6_2 - 0.047337662337664*G0_1_0_6_3 + 0.0929494724026007*G0_1_0_6_4 - 0.0710886769480545*G0_1_0_6_5 + 0.193459821428578*G0_1_0_6_6 - 0.00484882305194822*G0_1_0_6_7 - 0.0102729301948055*G0_1_0_6_8 + 0.0498031655844173*G0_1_0_6_9 - 0.0120535714285718*G0_1_0_7_0 - 0.00151582792207797*G0_1_0_7_1 - 0.00223721590909099*G0_1_0_7_2 + 0.00271205357142867*G0_1_0_7_3 - 0.00788961038961066*G0_1_0_7_4 + 0.000821834415584446*G0_1_0_7_5 - 0.00484882305194822*G0_1_0_7_6 - 0.00131493506493512*G0_1_0_7_7 + 0.0127384334415589*G0_1_0_7_8 - 0.00147930194805201*G0_1_0_7_9 + 0.0030955762987014*G0_1_0_8_0 - 0.00384435876623391*G0_1_0_8_1 - 0.00122362012987017*G0_1_0_8_2 + 0.00517755681818198*G0_1_0_8_3 - 0.00788961038961065*G0_1_0_8_4 + 0.00402698863636377*G0_1_0_8_5 - 0.0102729301948055*G0_1_0_8_6 + 0.0127384334415589*G0_1_0_8_7 + 0.0228469967532475*G0_1_0_8_8 + 0.00246550324675331*G0_1_0_8_9 + 0.00372564935064949*G0_1_0_9_0 + 0.00443790584415601*G0_1_0_9_1 + 0.0149573863636369*G0_1_0_9_2 - 0.0187378246753253*G0_1_0_9_3 + 0.0463514610389627*G0_1_0_9_4 - 0.019230925324676*G0_1_0_9_5 + 0.0498031655844174*G0_1_0_9_6 - 0.001479301948052*G0_1_0_9_7 + 0.00246550324675331*G0_1_0_9_8 - 0.00394480519480534*G0_1_0_9_9 + 0.00254464285714294*G0_1_1_0_0 + 0.00127232142857148*G0_1_1_0_2 - 0.00359780844155857*G0_1_1_0_3 + 0.00483969155844175*G0_1_1_0_4 + 0.000620941558441566*G0_1_1_0_5 + 0.002976866883117*G0_1_1_0_6 + 0.00463879870129886*G0_1_1_0_7 - 0.00505884740259758*G0_1_1_0_8 + 0.00241071428571438*G0_1_1_0_9 - 0.0164366883116888*G0_1_1_1_1 + 0.00103490259740264*G0_1_1_1_2 - 0.00684862012987036*G0_1_1_1_3 + 0.00909496753246786*G0_1_1_1_4 - 0.00272118506493516*G0_1_1_1_5 + 0.00368912337662351*G0_1_1_1_6 + 0.00416396103896119*G0_1_1_1_7 - 0.011779626623377*G0_1_1_1_8 + 0.000986201298701331*G0_1_1_1_9 + 0.00127232142857148*G0_1_1_2_0 + 0.00103490259740264*G0_1_1_2_1 + 0.0130275974025979*G0_1_1_2_2 - 0.00818181818181847*G0_1_1_2_3 + 0.019267451298702*G0_1_1_2_4 - 0.00507711038961057*G0_1_1_2_5 + 0.010318587662338*G0_1_1_2_6 + 0.00089488636363639*G0_1_1_2_7 - 0.00113230519480523*G0_1_1_2_8 + 0.0033969155844157*G0_1_1_2_9 - 0.00359780844155857*G0_1_1_3_0 - 0.00684862012987036*G0_1_1_3_1 - 0.00818181818181847*G0_1_1_3_2 - 0.026627435064936*G0_1_1_3_4 + 0.0111769480519484*G0_1_1_3_5 - 0.0144642857142862*G0_1_1_3_6 + 0.00739650974025998*G0_1_1_3_7 - 0.00739650974025999*G0_1_1_3_8 - 0.017751623376624*G0_1_1_3_9 + 0.00483969155844175*G0_1_1_4_0 + 0.00909496753246786*G0_1_1_4_1 + 0.019267451298702*G0_1_1_4_2 - 0.026627435064936*G0_1_1_4_3 + 0.0867857142857175*G0_1_1_4_4 - 0.0179159902597409*G0_1_1_4_5 + 0.0323802759740271*G0_1_1_4_6 - 0.00690340909090933*G0_1_1_4_7 + 0.0256412337662347*G0_1_1_4_9 + 0.000620941558441565*G0_1_1_5_0 - 0.00272118506493516*G0_1_1_5_1 - 0.00507711038961057*G0_1_1_5_2 + 0.0111769480519484*G0_1_1_5_3 - 0.0179159902597409*G0_1_1_5_4 - 0.0026298701298702*G0_1_1_5_5 - 0.0149573863636369*G0_1_1_5_6 + 0.0013149350649351*G0_1_1_5_7 + 0.00476663961038977*G0_1_1_5_8 - 0.0167654220779227*G0_1_1_5_9 + 0.002976866883117*G0_1_1_6_0 + 0.00368912337662351*G0_1_1_6_1 + 0.010318587662338*G0_1_1_6_2 - 0.0144642857142862*G0_1_1_6_3 + 0.0323802759740271*G0_1_1_6_4 - 0.0149573863636369*G0_1_1_6_5 + 0.0358319805194817*G0_1_1_6_6 - 0.00608157467532487*G0_1_1_6_7 - 0.00213676948051955*G0_1_1_6_8 + 0.0187378246753253*G0_1_1_6_9 + 0.00463879870129886*G0_1_1_7_0 + 0.00416396103896119*G0_1_1_7_1 + 0.00089488636363639*G0_1_1_7_2 + 0.00739650974025998*G0_1_1_7_3 - 0.00690340909090933*G0_1_1_7_4 + 0.0013149350649351*G0_1_1_7_5 - 0.00608157467532487*G0_1_1_7_6 + 0.0335308441558453*G0_1_1_7_7 + 0.010355113636364*G0_1_1_7_8 + 0.00493100649350665*G0_1_1_7_9 - 0.00505884740259758*G0_1_1_8_0 - 0.011779626623377*G0_1_1_8_1 - 0.00113230519480523*G0_1_1_8_2 - 0.00739650974025999*G0_1_1_8_3 + 0.00476663961038977*G0_1_1_8_5 - 0.00213676948051955*G0_1_1_8_6 + 0.010355113636364*G0_1_1_8_7 - 0.01479301948052*G0_1_1_8_8 - 0.00295860389610399*G0_1_1_8_9 + 0.00241071428571438*G0_1_1_9_0 + 0.000986201298701331*G0_1_1_9_1 + 0.0033969155844157*G0_1_1_9_2 - 0.017751623376624*G0_1_1_9_3 + 0.0256412337662347*G0_1_1_9_4 - 0.0167654220779227*G0_1_1_9_5 + 0.0187378246753253*G0_1_1_9_6 + 0.00493100649350664*G0_1_1_9_7 - 0.00295860389610399*G0_1_1_9_8 - 0.0788961038961066*G0_1_1_9_9;
    A[26] = -A[24] - 0.0107021103896108*G0_1_1_0_0 - 0.00155235389610395*G0_1_1_0_1 - 0.00522017045454566*G0_1_1_0_2 - 0.00133319805194809*G0_1_1_0_3 - 0.00168932629870137*G0_1_1_0_4 + 0.000374391233766255*G0_1_1_0_5 - 0.00214590097402608*G0_1_1_0_6 - 0.00590807629870151*G0_1_1_0_7 + 0.00154322240259745*G0_1_1_0_8 - 0.000821834415584455*G0_1_1_0_9 - 0.00155235389610396*G0_1_1_1_0 - 0.0107021103896108*G0_1_1_1_1 - 0.00522017045454565*G0_1_1_1_2 + 0.000374391233766252*G0_1_1_1_3 - 0.00214590097402606*G0_1_1_1_4 - 0.00133319805194809*G0_1_1_1_5 - 0.00168932629870137*G0_1_1_1_6 + 0.00154322240259746*G0_1_1_1_7 - 0.00590807629870151*G0_1_1_1_8 - 0.000821834415584454*G0_1_1_1_9 - 0.00522017045454566*G0_1_1_2_0 - 0.00522017045454565*G0_1_1_2_1 - 0.0932021103896136*G0_1_1_2_2 + 0.0208198051948059*G0_1_1_2_3 - 0.0452008928571444*G0_1_1_2_4 + 0.020819805194806*G0_1_1_2_5 - 0.0452008928571445*G0_1_1_2_6 - 0.000593547077922097*G0_1_1_2_7 - 0.000593547077922095*G0_1_1_2_8 - 0.00712256493506518*G0_1_1_2_9 - 0.00133319805194809*G0_1_1_3_0 + 0.000374391233766253*G0_1_1_3_1 + 0.0208198051948059*G0_1_1_3_2 - 0.0368181818181831*G0_1_1_3_3 + 0.0201349431818189*G0_1_1_3_4 + 0.00180803571428576*G0_1_1_3_5 + 0.00945109577922113*G0_1_1_3_6 + 0.00838271103896133*G0_1_1_3_7 - 0.0145464691558446*G0_1_1_3_8 - 0.0142999188311693*G0_1_1_3_9 - 0.00168932629870137*G0_1_1_4_0 - 0.00214590097402606*G0_1_1_4_1 - 0.0452008928571444*G0_1_1_4_2 + 0.0201349431818189*G0_1_1_4_3 - 0.0378043831168844*G0_1_1_4_4 + 0.00945109577922114*G0_1_1_4_5 - 0.0189021915584423*G0_1_1_4_6 + 0.00123275162337667*G0_1_1_4_7 + 0.00616375811688331*G0_1_1_4_8 + 0.00246550324675333*G0_1_1_4_9 + 0.000374391233766255*G0_1_1_5_0 - 0.00133319805194809*G0_1_1_5_1 + 0.020819805194806*G0_1_1_5_2 + 0.00180803571428576*G0_1_1_5_3 + 0.00945109577922114*G0_1_1_5_4 - 0.0368181818181831*G0_1_1_5_5 + 0.020134943181819*G0_1_1_5_6 - 0.0145464691558446*G0_1_1_5_7 + 0.00838271103896132*G0_1_1_5_8 - 0.0142999188311693*G0_1_1_5_9 - 0.00214590097402608*G0_1_1_6_0 - 0.00168932629870137*G0_1_1_6_1 - 0.0452008928571445*G0_1_1_6_2 + 0.00945109577922113*G0_1_1_6_3 - 0.0189021915584423*G0_1_1_6_4 + 0.020134943181819*G0_1_1_6_5 - 0.0378043831168846*G0_1_1_6_6 + 0.00616375811688332*G0_1_1_6_7 + 0.00123275162337666*G0_1_1_6_8 + 0.00246550324675331*G0_1_1_6_9 - 0.00590807629870151*G0_1_1_7_0 + 0.00154322240259746*G0_1_1_7_1 - 0.000593547077922097*G0_1_1_7_2 + 0.00838271103896133*G0_1_1_7_3 + 0.00123275162337667*G0_1_1_7_4 - 0.0145464691558446*G0_1_1_7_5 + 0.00616375811688332*G0_1_1_7_6 - 0.0613088474025995*G0_1_1_7_7 + 0.0146286525974031*G0_1_1_7_8 - 0.00986201298701335*G0_1_1_7_9 + 0.00154322240259745*G0_1_1_8_0 - 0.00590807629870151*G0_1_1_8_1 - 0.000593547077922095*G0_1_1_8_2 - 0.0145464691558446*G0_1_1_8_3 + 0.00616375811688331*G0_1_1_8_4 + 0.00838271103896132*G0_1_1_8_5 + 0.00123275162337666*G0_1_1_8_6 + 0.0146286525974031*G0_1_1_8_7 - 0.0613088474025995*G0_1_1_8_8 - 0.00986201298701329*G0_1_1_8_9 - 0.000821834415584455*G0_1_1_9_0 - 0.000821834415584453*G0_1_1_9_1 - 0.00712256493506518*G0_1_1_9_2 - 0.0142999188311693*G0_1_1_9_3 + 0.00246550324675334*G0_1_1_9_4 - 0.0142999188311693*G0_1_1_9_5 + 0.0024655032467533*G0_1_1_9_6 - 0.00986201298701335*G0_1_1_9_7 - 0.00986201298701329*G0_1_1_9_8 - 0.104537337662341*G0_1_1_9_9;
    A[84] = A[48] + 0.00138798701298711*G0_0_1_0_0 + 0.0038626217532469*G0_0_1_0_1 - 0.000292207792207795*G0_0_1_0_2 - 0.000657467532467563*G0_0_1_0_3 - 0.000164366883116898*G0_0_1_0_4 + 0.000986201298701361*G0_0_1_0_5 - 0.000986201298701344*G0_0_1_0_6 + 0.00139711850649357*G0_0_1_0_7 + 0.00608157467532488*G0_0_1_0_8 + 0.00345170454545467*G0_0_1_0_9 + 0.0038626217532469*G0_0_1_1_0 + 0.0734172077922102*G0_0_1_1_1 + 0.00276684253246762*G0_0_1_1_2 + 0.0283532873376632*G0_0_1_1_3 - 0.0142999188311693*G0_0_1_1_4 - 0.000164366883116885*G0_0_1_1_5 - 0.00262987012987021*G0_0_1_1_6 - 0.0167654220779227*G0_0_1_1_7 + 0.0456118100649367*G0_0_1_1_8 + 0.00641030844155867*G0_0_1_1_9 - 0.000292207792207795*G0_0_1_2_0 + 0.00276684253246762*G0_0_1_2_1 - 0.00447443181818189*G0_0_1_2_2 + 0.00238331980519487*G0_0_1_2_3 - 0.00550629058441575*G0_0_1_2_4 + 0.00271205357142864*G0_0_1_2_5 - 0.00394480519480528*G0_0_1_2_6 - 0.00213676948051956*G0_0_1_2_7 - 0.000657467532467559*G0_0_1_2_8 - 0.00591720779220799*G0_0_1_2_9 - 0.000657467532467563*G0_0_1_3_0 + 0.0283532873376632*G0_0_1_3_1 + 0.00238331980519488*G0_0_1_3_2 - 0.0739650974026001*G0_0_1_3_3 + 0.000739650974026024*G0_0_1_3_4 + 0.00221895292207799*G0_0_1_3_5 + 0.00591720779220798*G0_0_1_3_6 - 0.019230925324676*G0_0_1_3_9 - 0.000164366883116898*G0_0_1_4_0 - 0.0142999188311693*G0_0_1_4_1 - 0.00550629058441575*G0_0_1_4_2 + 0.000739650974026024*G0_0_1_4_3 - 0.00147930194805197*G0_0_1_4_5 - 0.00443790584415601*G0_0_1_4_6 + 0.00443790584415603*G0_0_1_4_7 + 0.0207102272727279*G0_0_1_4_9 + 0.000986201298701361*G0_0_1_5_0 - 0.000164366883116885*G0_0_1_5_1 + 0.00271205357142864*G0_0_1_5_2 + 0.00221895292207799*G0_0_1_5_3 - 0.00147930194805197*G0_0_1_5_4 - 0.00295860389610392*G0_0_1_5_5 + 0.00147930194805196*G0_0_1_5_6 - 0.00295860389610401*G0_0_1_5_7 - 0.001479301948052*G0_0_1_5_8 - 0.00739650974025998*G0_0_1_5_9 - 0.000986201298701344*G0_0_1_6_0 - 0.00262987012987021*G0_0_1_6_1 - 0.00394480519480528*G0_0_1_6_2 + 0.00591720779220798*G0_0_1_6_3 - 0.00443790584415601*G0_0_1_6_4 + 0.00147930194805196*G0_0_1_6_5 - 0.0207102272727279*G0_0_1_6_6 + 0.00443790584415601*G0_0_1_6_7 + 0.005917207792208*G0_0_1_6_8 + 0.00591720779220799*G0_0_1_6_9 + 0.00139711850649357*G0_0_1_7_0 - 0.0167654220779227*G0_0_1_7_1 - 0.00213676948051956*G0_0_1_7_2 + 0.00443790584415603*G0_0_1_7_4 - 0.00295860389610401*G0_0_1_7_5 + 0.00443790584415601*G0_0_1_7_6 - 0.0414204545454562*G0_0_1_7_7 - 0.036242897727274*G0_0_1_7_8 - 0.019230925324676*G0_0_1_7_9 + 0.00608157467532488*G0_0_1_8_0 + 0.0456118100649367*G0_0_1_8_1 - 0.000657467532467559*G0_0_1_8_2 - 0.001479301948052*G0_0_1_8_5 + 0.005917207792208*G0_0_1_8_6 - 0.036242897727274*G0_0_1_8_7 - 0.019230925324676*G0_0_1_8_9 + 0.00345170454545467*G0_0_1_9_0 + 0.00641030844155867*G0_0_1_9_1 - 0.00591720779220799*G0_0_1_9_2 - 0.019230925324676*G0_0_1_9_3 + 0.0207102272727279*G0_0_1_9_4 - 0.00739650974025997*G0_0_1_9_5 + 0.005917207792208*G0_0_1_9_6 - 0.019230925324676*G0_0_1_9_7 - 0.019230925324676*G0_0_1_9_8 + 0.0887581168831196*G0_0_1_9_9 - 0.00138798701298711*G0_1_0_0_0 - 0.0038626217532469*G0_1_0_0_1 + 0.000292207792207795*G0_1_0_0_2 + 0.000657467532467563*G0_1_0_0_3 + 0.000164366883116898*G0_1_0_0_4 - 0.000986201298701361*G0_1_0_0_5 + 0.000986201298701345*G0_1_0_0_6 - 0.00139711850649357*G0_1_0_0_7 - 0.00608157467532488*G0_1_0_0_8 - 0.00345170454545467*G0_1_0_0_9 - 0.0038626217532469*G0_1_0_1_0 - 0.0734172077922102*G0_1_0_1_1 - 0.00276684253246762*G0_1_0_1_2 - 0.0283532873376632*G0_1_0_1_3 + 0.0142999188311693*G0_1_0_1_4 + 0.000164366883116885*G0_1_0_1_5 + 0.00262987012987021*G0_1_0_1_6 + 0.0167654220779227*G0_1_0_1_7 - 0.0456118100649367*G0_1_0_1_8 - 0.00641030844155867*G0_1_0_1_9 + 0.000292207792207795*G0_1_0_2_0 - 0.00276684253246762*G0_1_0_2_1 + 0.0044744318181819*G0_1_0_2_2 - 0.00238331980519487*G0_1_0_2_3 + 0.00550629058441575*G0_1_0_2_4 - 0.00271205357142864*G0_1_0_2_5 + 0.00394480519480528*G0_1_0_2_6 + 0.00213676948051956*G0_1_0_2_7 + 0.000657467532467559*G0_1_0_2_8 + 0.00591720779220799*G0_1_0_2_9 + 0.000657467532467563*G0_1_0_3_0 - 0.0283532873376632*G0_1_0_3_1 - 0.00238331980519487*G0_1_0_3_2 + 0.0739650974026001*G0_1_0_3_3 - 0.000739650974026024*G0_1_0_3_4 - 0.00221895292207799*G0_1_0_3_5 - 0.00591720779220798*G0_1_0_3_6 + 0.019230925324676*G0_1_0_3_9 + 0.000164366883116898*G0_1_0_4_0 + 0.0142999188311693*G0_1_0_4_1 + 0.00550629058441575*G0_1_0_4_2 - 0.000739650974026024*G0_1_0_4_3 + 0.00147930194805197*G0_1_0_4_5 + 0.00443790584415601*G0_1_0_4_6 - 0.00443790584415603*G0_1_0_4_7 - 0.0207102272727279*G0_1_0_4_9 - 0.000986201298701361*G0_1_0_5_0 + 0.000164366883116885*G0_1_0_5_1 - 0.00271205357142864*G0_1_0_5_2 - 0.00221895292207799*G0_1_0_5_3 + 0.00147930194805197*G0_1_0_5_4 + 0.00295860389610392*G0_1_0_5_5 - 0.00147930194805196*G0_1_0_5_6 + 0.00295860389610401*G0_1_0_5_7 + 0.001479301948052*G0_1_0_5_8 + 0.00739650974025997*G0_1_0_5_9 + 0.000986201298701345*G0_1_0_6_0 + 0.00262987012987021*G0_1_0_6_1 + 0.00394480519480528*G0_1_0_6_2 - 0.00591720779220798*G0_1_0_6_3 + 0.00443790584415601*G0_1_0_6_4 - 0.00147930194805196*G0_1_0_6_5 + 0.0207102272727279*G0_1_0_6_6 - 0.00443790584415601*G0_1_0_6_7 - 0.005917207792208*G0_1_0_6_8 - 0.00591720779220799*G0_1_0_6_9 - 0.00139711850649357*G0_1_0_7_0 + 0.0167654220779227*G0_1_0_7_1 + 0.00213676948051956*G0_1_0_7_2 - 0.00443790584415603*G0_1_0_7_4 + 0.00295860389610401*G0_1_0_7_5 - 0.00443790584415601*G0_1_0_7_6 + 0.0414204545454562*G0_1_0_7_7 + 0.036242897727274*G0_1_0_7_8 + 0.019230925324676*G0_1_0_7_9 - 0.00608157467532488*G0_1_0_8_0 - 0.0456118100649367*G0_1_0_8_1 + 0.000657467532467559*G0_1_0_8_2 + 0.001479301948052*G0_1_0_8_5 - 0.005917207792208*G0_1_0_8_6 + 0.036242897727274*G0_1_0_8_7 + 0.019230925324676*G0_1_0_8_9 - 0.00345170454545467*G0_1_0_9_0 - 0.00641030844155867*G0_1_0_9_1 + 0.00591720779220799*G0_1_0_9_2 + 0.019230925324676*G0_1_0_9_3 - 0.0207102272727279*G0_1_0_9_4 + 0.00739650974025997*G0_1_0_9_5 - 0.005917207792208*G0_1_0_9_6 + 0.019230925324676*G0_1_0_9_7 + 0.019230925324676*G0_1_0_9_8 - 0.0887581168831196*G0_1_0_9_9;
    A[47] = A[74] + 0.0044744318181821*G0_0_1_0_0 + 0.00175324675324683*G0_0_1_0_1 + 0.000703125000000039*G0_0_1_0_2 - 0.00279423701298712*G0_0_1_0_3 + 0.000657467532467551*G0_0_1_0_4 + 0.00221895292207806*G0_0_1_0_5 + 0.00723214285714319*G0_0_1_0_7 - 0.00115056818181826*G0_0_1_0_8 + 0.00197240259740268*G0_0_1_0_9 + 0.00175324675324683*G0_0_1_1_0 + 0.0317775974025984*G0_0_1_1_1 + 0.00175324675324681*G0_0_1_1_2 + 0.0123275162337666*G0_0_1_1_3 - 0.00197240259740264*G0_0_1_1_4 + 0.000164366883116895*G0_0_1_1_5 + 0.000164366883116895*G0_0_1_1_6 - 0.00197240259740266*G0_0_1_1_7 + 0.0123275162337667*G0_0_1_1_8 + 0.00394480519480535*G0_0_1_1_9 + 0.000703125000000039*G0_0_1_2_0 + 0.00175324675324681*G0_0_1_2_1 + 0.00447443181818204*G0_0_1_2_2 - 0.00115056818181823*G0_0_1_2_3 + 0.00723214285714313*G0_0_1_2_4 + 0.00221895292207805*G0_0_1_2_6 + 0.000657467532467561*G0_0_1_2_7 - 0.00279423701298711*G0_0_1_2_8 + 0.00197240259740268*G0_0_1_2_9 - 0.00279423701298712*G0_0_1_3_0 + 0.0123275162337666*G0_0_1_3_1 - 0.00115056818181823*G0_0_1_3_2 - 0.072485795454548*G0_0_1_3_3 - 0.020710227272728*G0_0_1_3_4 + 0.00591720779220799*G0_0_1_3_5 - 0.00443790584415602*G0_0_1_3_6 + 0.004437905844156*G0_0_1_3_7 - 0.00887581168831197*G0_0_1_3_8 - 0.020710227272728*G0_0_1_3_9 + 0.000657467532467551*G0_0_1_4_0 - 0.00197240259740264*G0_0_1_4_1 + 0.00723214285714313*G0_0_1_4_2 - 0.020710227272728*G0_0_1_4_3 - 0.005917207792208*G0_0_1_4_5 + 0.010355113636364*G0_0_1_4_6 + 0.00443790584415599*G0_0_1_4_8 + 0.00591720779220795*G0_0_1_4_9 + 0.00221895292207806*G0_0_1_5_0 + 0.000164366883116895*G0_0_1_5_1 + 0.00591720779220799*G0_0_1_5_3 - 0.005917207792208*G0_0_1_5_4 + 0.00887581168831215*G0_0_1_5_5 - 0.0110947646103901*G0_0_1_5_6 + 0.0103551136363641*G0_0_1_5_7 - 0.00443790584415603*G0_0_1_5_8 + 0.00295860389610402*G0_0_1_5_9 + 0.000164366883116895*G0_0_1_6_1 + 0.00221895292207805*G0_0_1_6_2 - 0.00443790584415602*G0_0_1_6_3 + 0.010355113636364*G0_0_1_6_4 - 0.0110947646103901*G0_0_1_6_5 + 0.0088758116883122*G0_0_1_6_6 - 0.00591720779220803*G0_0_1_6_7 + 0.005917207792208*G0_0_1_6_8 + 0.00295860389610401*G0_0_1_6_9 + 0.00723214285714319*G0_0_1_7_0 - 0.00197240259740266*G0_0_1_7_1 + 0.000657467532467561*G0_0_1_7_2 + 0.004437905844156*G0_0_1_7_3 + 0.0103551136363641*G0_0_1_7_5 - 0.00591720779220803*G0_0_1_7_6 - 0.0207102272727281*G0_0_1_7_8 + 0.00591720779220803*G0_0_1_7_9 - 0.00115056818181826*G0_0_1_8_0 + 0.0123275162337667*G0_0_1_8_1 - 0.00279423701298711*G0_0_1_8_2 - 0.00887581168831197*G0_0_1_8_3 + 0.00443790584415599*G0_0_1_8_4 - 0.00443790584415603*G0_0_1_8_5 + 0.005917207792208*G0_0_1_8_6 - 0.0207102272727281*G0_0_1_8_7 - 0.0724857954545479*G0_0_1_8_8 - 0.020710227272728*G0_0_1_8_9 + 0.00197240259740268*G0_0_1_9_0 + 0.00394480519480535*G0_0_1_9_1 + 0.00197240259740268*G0_0_1_9_2 - 0.020710227272728*G0_0_1_9_3 + 0.00591720779220795*G0_0_1_9_4 + 0.00295860389610402*G0_0_1_9_5 + 0.00295860389610401*G0_0_1_9_6 + 0.00591720779220803*G0_0_1_9_7 - 0.020710227272728*G0_0_1_9_8 + 0.124261363636368*G0_0_1_9_9 - 0.0044744318181821*G0_1_0_0_0 - 0.00175324675324683*G0_1_0_0_1 - 0.000703125000000039*G0_1_0_0_2 + 0.00279423701298712*G0_1_0_0_3 - 0.000657467532467551*G0_1_0_0_4 - 0.00221895292207806*G0_1_0_0_5 - 0.00723214285714319*G0_1_0_0_7 + 0.00115056818181826*G0_1_0_0_8 - 0.00197240259740268*G0_1_0_0_9 - 0.00175324675324683*G0_1_0_1_0 - 0.0317775974025984*G0_1_0_1_1 - 0.00175324675324681*G0_1_0_1_2 - 0.0123275162337666*G0_1_0_1_3 + 0.00197240259740264*G0_1_0_1_4 - 0.000164366883116895*G0_1_0_1_5 - 0.000164366883116895*G0_1_0_1_6 + 0.00197240259740266*G0_1_0_1_7 - 0.0123275162337667*G0_1_0_1_8 - 0.00394480519480535*G0_1_0_1_9 - 0.000703125000000039*G0_1_0_2_0 - 0.00175324675324681*G0_1_0_2_1 - 0.00447443181818204*G0_1_0_2_2 + 0.00115056818181823*G0_1_0_2_3 - 0.00723214285714313*G0_1_0_2_4 - 0.00221895292207805*G0_1_0_2_6 - 0.000657467532467561*G0_1_0_2_7 + 0.00279423701298711*G0_1_0_2_8 - 0.00197240259740268*G0_1_0_2_9 + 0.00279423701298712*G0_1_0_3_0 - 0.0123275162337666*G0_1_0_3_1 + 0.00115056818181823*G0_1_0_3_2 + 0.072485795454548*G0_1_0_3_3 + 0.020710227272728*G0_1_0_3_4 - 0.00591720779220799*G0_1_0_3_5 + 0.00443790584415602*G0_1_0_3_6 - 0.004437905844156*G0_1_0_3_7 + 0.00887581168831197*G0_1_0_3_8 + 0.020710227272728*G0_1_0_3_9 - 0.000657467532467551*G0_1_0_4_0 + 0.00197240259740264*G0_1_0_4_1 - 0.00723214285714313*G0_1_0_4_2 + 0.020710227272728*G0_1_0_4_3 + 0.005917207792208*G0_1_0_4_5 - 0.010355113636364*G0_1_0_4_6 - 0.00443790584415599*G0_1_0_4_8 - 0.00591720779220795*G0_1_0_4_9 - 0.00221895292207806*G0_1_0_5_0 - 0.000164366883116895*G0_1_0_5_1 - 0.00591720779220799*G0_1_0_5_3 + 0.005917207792208*G0_1_0_5_4 - 0.00887581168831214*G0_1_0_5_5 + 0.0110947646103901*G0_1_0_5_6 - 0.0103551136363641*G0_1_0_5_7 + 0.00443790584415603*G0_1_0_5_8 - 0.00295860389610402*G0_1_0_5_9 - 0.000164366883116894*G0_1_0_6_1 - 0.00221895292207805*G0_1_0_6_2 + 0.00443790584415602*G0_1_0_6_3 - 0.010355113636364*G0_1_0_6_4 + 0.0110947646103901*G0_1_0_6_5 - 0.0088758116883122*G0_1_0_6_6 + 0.00591720779220803*G0_1_0_6_7 - 0.005917207792208*G0_1_0_6_8 - 0.00295860389610401*G0_1_0_6_9 - 0.00723214285714319*G0_1_0_7_0 + 0.00197240259740266*G0_1_0_7_1 - 0.000657467532467561*G0_1_0_7_2 - 0.004437905844156*G0_1_0_7_3 - 0.0103551136363641*G0_1_0_7_5 + 0.00591720779220803*G0_1_0_7_6 + 0.0207102272727281*G0_1_0_7_8 - 0.00591720779220803*G0_1_0_7_9 + 0.00115056818181826*G0_1_0_8_0 - 0.0123275162337667*G0_1_0_8_1 + 0.00279423701298711*G0_1_0_8_2 + 0.00887581168831197*G0_1_0_8_3 - 0.00443790584415599*G0_1_0_8_4 + 0.00443790584415603*G0_1_0_8_5 - 0.005917207792208*G0_1_0_8_6 + 0.0207102272727281*G0_1_0_8_7 + 0.0724857954545479*G0_1_0_8_8 + 0.020710227272728*G0_1_0_8_9 - 0.00197240259740268*G0_1_0_9_0 - 0.00394480519480535*G0_1_0_9_1 - 0.00197240259740268*G0_1_0_9_2 + 0.020710227272728*G0_1_0_9_3 - 0.00591720779220795*G0_1_0_9_4 - 0.00295860389610402*G0_1_0_9_5 - 0.00295860389610401*G0_1_0_9_6 - 0.00591720779220803*G0_1_0_9_7 + 0.020710227272728*G0_1_0_9_8 - 0.124261363636368*G0_1_0_9_9;
    A[67] = -A[47] - 0.0778916396103923*G0_1_0_0_0 - 0.00561586850649371*G0_1_0_0_1 - 0.00346996753246765*G0_1_0_0_2 + 0.00295860389610403*G0_1_0_0_3 + 0.00197240259740268*G0_1_0_0_4 - 0.0305722402597413*G0_1_0_0_5 + 0.0142999188311693*G0_1_0_0_6 - 0.0528439529220798*G0_1_0_0_7 + 0.0179159902597409*G0_1_0_0_8 - 0.00838271103896136*G0_1_0_0_9 - 0.00561586850649371*G0_1_0_1_0 - 0.0331655844155855*G0_1_0_1_1 - 0.00146103896103901*G0_1_0_1_2 - 0.0133137175324679*G0_1_0_1_3 + 0.00295860389610398*G0_1_0_1_4 + 0.000493100649350657*G0_1_0_1_5 - 0.00410917207792221*G0_1_0_1_7 - 0.0137246347402602*G0_1_0_1_8 - 0.00739650974026001*G0_1_0_1_9 - 0.00346996753246765*G0_1_0_2_0 - 0.00146103896103901*G0_1_0_2_1 - 0.00156148538961044*G0_1_0_2_3 - 0.00328733766233779*G0_1_0_2_4 - 0.00238331980519488*G0_1_0_2_5 + 0.00328733766233777*G0_1_0_2_6 + 0.00493100649350666*G0_1_0_2_8 + 0.00394480519480532*G0_1_0_2_9 + 0.00295860389610403*G0_1_0_3_0 - 0.0133137175324679*G0_1_0_3_1 - 0.00156148538961044*G0_1_0_3_2 + 0.0754443993506521*G0_1_0_3_3 + 0.019230925324676*G0_1_0_3_4 - 0.00813616071428597*G0_1_0_3_5 + 0.00591720779220799*G0_1_0_3_6 - 0.00295860389610401*G0_1_0_3_7 + 0.011834415584416*G0_1_0_3_8 + 0.028106737012988*G0_1_0_3_9 + 0.00197240259740268*G0_1_0_4_0 + 0.00295860389610398*G0_1_0_4_1 - 0.00328733766233779*G0_1_0_4_2 + 0.019230925324676*G0_1_0_4_3 + 0.0207102272727281*G0_1_0_4_4 - 0.00591720779220797*G0_1_0_4_6 - 0.00591720779220801*G0_1_0_4_7 - 0.00887581168831198*G0_1_0_4_8 - 0.0118344155844159*G0_1_0_4_9 - 0.0305722402597413*G0_1_0_5_0 + 0.000493100649350657*G0_1_0_5_1 - 0.00238331980519488*G0_1_0_5_2 - 0.00813616071428597*G0_1_0_5_3 + 0.0650892857142877*G0_1_0_5_5 + 0.010355113636364*G0_1_0_5_6 - 0.010355113636364*G0_1_0_5_7 + 0.00443790584415602*G0_1_0_5_8 + 0.016272321428572*G0_1_0_5_9 + 0.0142999188311693*G0_1_0_6_0 + 0.00328733766233777*G0_1_0_6_2 + 0.00591720779220799*G0_1_0_6_3 - 0.00591720779220797*G0_1_0_6_4 + 0.010355113636364*G0_1_0_6_5 - 0.00887581168831198*G0_1_0_6_6 + 0.00591720779220799*G0_1_0_6_7 - 0.010355113636364*G0_1_0_6_8 - 0.0236688311688319*G0_1_0_6_9 - 0.0528439529220798*G0_1_0_7_0 - 0.00410917207792221*G0_1_0_7_1 - 0.00295860389610401*G0_1_0_7_3 - 0.00591720779220801*G0_1_0_7_4 - 0.010355113636364*G0_1_0_7_5 + 0.00591720779220799*G0_1_0_7_6 + 0.056953125000002*G0_1_0_7_8 + 0.013313717532468*G0_1_0_7_9 + 0.0179159902597409*G0_1_0_8_0 - 0.0137246347402602*G0_1_0_8_1 + 0.00493100649350666*G0_1_0_8_2 + 0.011834415584416*G0_1_0_8_3 - 0.00887581168831198*G0_1_0_8_4 + 0.00443790584415602*G0_1_0_8_5 - 0.010355113636364*G0_1_0_8_6 + 0.056953125000002*G0_1_0_8_7 + 0.113906250000004*G0_1_0_8_8 + 0.039941152597404*G0_1_0_8_9 - 0.00838271103896136*G0_1_0_9_0 - 0.00739650974026001*G0_1_0_9_1 + 0.00394480519480532*G0_1_0_9_2 + 0.028106737012988*G0_1_0_9_3 - 0.0118344155844159*G0_1_0_9_4 + 0.016272321428572*G0_1_0_9_5 - 0.0236688311688319*G0_1_0_9_6 + 0.013313717532468*G0_1_0_9_7 + 0.039941152597404*G0_1_0_9_8 - 0.213019480519488*G0_1_0_9_9 + 0.0147017045454551*G0_1_1_0_0 + 0.00144277597402602*G0_1_1_0_1 + 0.000264813311688318*G0_1_1_0_2 + 0.00147930194805202*G0_1_1_0_3 + 0.00197240259740267*G0_1_1_0_4 + 0.0101085633116887*G0_1_1_0_5 - 0.00295860389610401*G0_1_1_0_6 + 0.0198883928571436*G0_1_1_0_7 - 0.0166010551948058*G0_1_1_0_8 + 0.00887581168831201*G0_1_1_0_9 + 0.00144277597402602*G0_1_1_1_0 - 0.0347909902597414*G0_1_1_1_1 - 0.00136059253246758*G0_1_1_1_2 - 0.0147930194805199*G0_1_1_1_3 + 0.00345170454545464*G0_1_1_1_4 - 0.00221895292207799*G0_1_1_1_5 - 0.00197240259740267*G0_1_1_1_6 + 0.00788961038961069*G0_1_1_1_7 - 0.02218952922078*G0_1_1_1_8 - 0.0138068181818187*G0_1_1_1_9 + 0.000264813311688318*G0_1_1_2_0 - 0.00136059253246758*G0_1_1_2_1 - 0.0027394480519482*G0_1_1_2_2 - 0.000904017857142882*G0_1_1_2_3 - 0.00657467532467558*G0_1_1_2_4 + 0.0023833198051949*G0_1_1_2_5 - 0.000821834415584487*G0_1_1_2_6 + 0.009615462662338*G0_1_1_2_7 + 0.00271205357142866*G0_1_1_2_8 + 0.00345170454545466*G0_1_1_2_9 + 0.00147930194805202*G0_1_1_3_0 - 0.0147930194805199*G0_1_1_3_1 - 0.000904017857142883*G0_1_1_3_2 + 0.0843202110389642*G0_1_1_3_3 + 0.019970576298702*G0_1_1_3_4 + 0.000739650974025969*G0_1_1_3_5 + 0.00665685876623399*G0_1_1_3_6 - 0.00369825487013008*G0_1_1_3_7 + 0.01109476461039*G0_1_1_3_8 + 0.048816964285716*G0_1_1_3_9 + 0.00197240259740267*G0_1_1_4_0 + 0.00345170454545464*G0_1_1_4_1 - 0.00657467532467558*G0_1_1_4_2 + 0.019970576298702*G0_1_1_4_3 + 0.0310653409090921*G0_1_1_4_4 - 0.00517755681818199*G0_1_1_4_5 - 0.00147930194805198*G0_1_1_4_6 - 0.017751623376624*G0_1_1_4_7 - 0.00739650974025998*G0_1_1_4_8 + 0.0101085633116887*G0_1_1_5_0 - 0.00221895292207799*G0_1_1_5_1 + 0.0023833198051949*G0_1_1_5_2 + 0.00073965097402597*G0_1_1_5_3 - 0.00517755681818199*G0_1_1_5_4 - 0.0325446428571439*G0_1_1_5_5 - 0.00517755681818198*G0_1_1_5_6 + 0.0207102272727281*G0_1_1_5_7 + 0.00739650974025996*G0_1_1_5_8 - 0.0414204545454559*G0_1_1_5_9 - 0.00295860389610401*G0_1_1_6_0 - 0.00197240259740267*G0_1_1_6_1 - 0.000821834415584487*G0_1_1_6_2 + 0.00665685876623399*G0_1_1_6_3 - 0.00147930194805198*G0_1_1_6_4 - 0.00517755681818198*G0_1_1_6_5 - 0.013313717532468*G0_1_1_6_6 - 0.028106737012988*G0_1_1_6_7 - 0.00147930194805198*G0_1_1_6_8 - 0.023668831168832*G0_1_1_6_9 + 0.0198883928571436*G0_1_1_7_0 + 0.00788961038961069*G0_1_1_7_1 + 0.009615462662338*G0_1_1_7_2 - 0.00369825487013008*G0_1_1_7_3 - 0.017751623376624*G0_1_1_7_4 + 0.0207102272727281*G0_1_1_7_5 - 0.028106737012988*G0_1_1_7_6 + 0.257398538961048*G0_1_1_7_7 + 0.0118344155844159*G0_1_1_7_8 + 0.0295860389610401*G0_1_1_7_9 - 0.0166010551948058*G0_1_1_8_0 - 0.02218952922078*G0_1_1_8_1 + 0.00271205357142866*G0_1_1_8_2 + 0.01109476461039*G0_1_1_8_3 - 0.00739650974025998*G0_1_1_8_4 + 0.00739650974025996*G0_1_1_8_5 - 0.00147930194805198*G0_1_1_8_6 + 0.0118344155844159*G0_1_1_8_7 + 0.130178571428576*G0_1_1_8_8 + 0.0562134740259759*G0_1_1_8_9 + 0.00887581168831201*G0_1_1_9_0 - 0.0138068181818187*G0_1_1_9_1 + 0.00345170454545466*G0_1_1_9_2 + 0.048816964285716*G0_1_1_9_3 - 0.0414204545454559*G0_1_1_9_5 - 0.023668831168832*G0_1_1_9_6 + 0.0295860389610401*G0_1_1_9_7 + 0.0562134740259759*G0_1_1_9_8 - 0.230771103896112*G0_1_1_9_9;
    A[76] = A[67] - 0.0734172077922102*G0_0_1_0_0 - 0.00386262175324689*G0_0_1_0_1 - 0.00276684253246761*G0_0_1_0_2 + 0.000164366883116903*G0_0_1_0_3 + 0.00262987012987023*G0_0_1_0_4 - 0.0283532873376633*G0_0_1_0_5 + 0.0142999188311693*G0_0_1_0_6 - 0.0456118100649366*G0_0_1_0_7 + 0.0167654220779226*G0_0_1_0_8 - 0.00641030844155869*G0_0_1_0_9 - 0.00386262175324689*G0_0_1_1_0 - 0.00138798701298708*G0_0_1_1_1 + 0.000292207792207805*G0_0_1_1_2 - 0.000986201298701342*G0_0_1_1_3 + 0.000986201298701338*G0_0_1_1_4 + 0.000657467532467553*G0_0_1_1_5 + 0.000164366883116895*G0_0_1_1_6 - 0.00608157467532487*G0_0_1_1_7 - 0.00139711850649357*G0_0_1_1_8 - 0.00345170454545467*G0_0_1_1_9 - 0.00276684253246761*G0_0_1_2_0 + 0.000292207792207805*G0_0_1_2_1 + 0.00447443181818203*G0_0_1_2_2 - 0.00271205357142867*G0_0_1_2_3 + 0.00394480519480534*G0_0_1_2_4 - 0.0023833198051949*G0_0_1_2_5 + 0.00550629058441582*G0_0_1_2_6 + 0.000657467532467567*G0_0_1_2_7 + 0.00213676948051955*G0_0_1_2_8 + 0.005917207792208*G0_0_1_2_9 + 0.000164366883116903*G0_0_1_3_0 - 0.000986201298701342*G0_0_1_3_1 - 0.00271205357142867*G0_0_1_3_2 + 0.00295860389610407*G0_0_1_3_3 - 0.00147930194805198*G0_0_1_3_4 - 0.00221895292207798*G0_0_1_3_5 + 0.00147930194805197*G0_0_1_3_6 + 0.00147930194805199*G0_0_1_3_7 + 0.00295860389610398*G0_0_1_3_8 + 0.00739650974025998*G0_0_1_3_9 + 0.00262987012987023*G0_0_1_4_0 + 0.000986201298701338*G0_0_1_4_1 + 0.00394480519480534*G0_0_1_4_2 - 0.00147930194805198*G0_0_1_4_3 + 0.020710227272728*G0_0_1_4_4 - 0.00591720779220802*G0_0_1_4_5 + 0.00443790584415605*G0_0_1_4_6 - 0.00591720779220801*G0_0_1_4_7 - 0.00443790584415599*G0_0_1_4_8 - 0.00591720779220796*G0_0_1_4_9 - 0.0283532873376633*G0_0_1_5_0 + 0.000657467532467553*G0_0_1_5_1 - 0.0023833198051949*G0_0_1_5_2 - 0.00221895292207798*G0_0_1_5_3 - 0.00591720779220802*G0_0_1_5_4 + 0.0739650974025999*G0_0_1_5_5 - 0.000739650974026059*G0_0_1_5_6 + 0.019230925324676*G0_0_1_5_9 + 0.0142999188311693*G0_0_1_6_0 + 0.000164366883116894*G0_0_1_6_1 + 0.00550629058441582*G0_0_1_6_2 + 0.00147930194805197*G0_0_1_6_3 + 0.00443790584415605*G0_0_1_6_4 - 0.000739650974026059*G0_0_1_6_5 - 0.00443790584415599*G0_0_1_6_8 - 0.0207102272727279*G0_0_1_6_9 - 0.0456118100649366*G0_0_1_7_0 - 0.00608157467532487*G0_0_1_7_1 + 0.000657467532467568*G0_0_1_7_2 + 0.00147930194805199*G0_0_1_7_3 - 0.00591720779220801*G0_0_1_7_4 + 0.0362428977272739*G0_0_1_7_8 + 0.019230925324676*G0_0_1_7_9 + 0.0167654220779226*G0_0_1_8_0 - 0.00139711850649357*G0_0_1_8_1 + 0.00213676948051955*G0_0_1_8_2 + 0.00295860389610398*G0_0_1_8_3 - 0.00443790584415599*G0_0_1_8_4 - 0.00443790584415599*G0_0_1_8_6 + 0.0362428977272739*G0_0_1_8_7 + 0.041420454545456*G0_0_1_8_8 + 0.019230925324676*G0_0_1_8_9 - 0.00641030844155869*G0_0_1_9_0 - 0.00345170454545467*G0_0_1_9_1 + 0.005917207792208*G0_0_1_9_2 + 0.00739650974025998*G0_0_1_9_3 - 0.00591720779220797*G0_0_1_9_4 + 0.019230925324676*G0_0_1_9_5 - 0.0207102272727279*G0_0_1_9_6 + 0.019230925324676*G0_0_1_9_7 + 0.019230925324676*G0_0_1_9_8 - 0.0887581168831198*G0_0_1_9_9 + 0.0734172077922102*G0_1_0_0_0 + 0.00386262175324689*G0_1_0_0_1 + 0.00276684253246761*G0_1_0_0_2 - 0.000164366883116903*G0_1_0_0_3 - 0.00262987012987023*G0_1_0_0_4 + 0.0283532873376633*G0_1_0_0_5 - 0.0142999188311693*G0_1_0_0_6 + 0.0456118100649366*G0_1_0_0_7 - 0.0167654220779226*G0_1_0_0_8 + 0.00641030844155869*G0_1_0_0_9 + 0.00386262175324689*G0_1_0_1_0 + 0.00138798701298708*G0_1_0_1_1 - 0.000292207792207805*G0_1_0_1_2 + 0.000986201298701342*G0_1_0_1_3 - 0.000986201298701338*G0_1_0_1_4 - 0.000657467532467553*G0_1_0_1_5 - 0.000164366883116894*G0_1_0_1_6 + 0.00608157467532487*G0_1_0_1_7 + 0.00139711850649357*G0_1_0_1_8 + 0.00345170454545467*G0_1_0_1_9 + 0.00276684253246761*G0_1_0_2_0 - 0.000292207792207805*G0_1_0_2_1 - 0.00447443181818203*G0_1_0_2_2 + 0.00271205357142867*G0_1_0_2_3 - 0.00394480519480534*G0_1_0_2_4 + 0.0023833198051949*G0_1_0_2_5 - 0.00550629058441582*G0_1_0_2_6 - 0.000657467532467568*G0_1_0_2_7 - 0.00213676948051955*G0_1_0_2_8 - 0.005917207792208*G0_1_0_2_9 - 0.000164366883116903*G0_1_0_3_0 + 0.000986201298701342*G0_1_0_3_1 + 0.00271205357142867*G0_1_0_3_2 - 0.00295860389610407*G0_1_0_3_3 + 0.00147930194805198*G0_1_0_3_4 + 0.00221895292207798*G0_1_0_3_5 - 0.00147930194805197*G0_1_0_3_6 - 0.00147930194805199*G0_1_0_3_7 - 0.00295860389610399*G0_1_0_3_8 - 0.00739650974025998*G0_1_0_3_9 - 0.00262987012987023*G0_1_0_4_0 - 0.000986201298701338*G0_1_0_4_1 - 0.00394480519480534*G0_1_0_4_2 + 0.00147930194805198*G0_1_0_4_3 - 0.020710227272728*G0_1_0_4_4 + 0.00591720779220802*G0_1_0_4_5 - 0.00443790584415605*G0_1_0_4_6 + 0.00591720779220801*G0_1_0_4_7 + 0.00443790584415599*G0_1_0_4_8 + 0.00591720779220797*G0_1_0_4_9 + 0.0283532873376633*G0_1_0_5_0 - 0.000657467532467552*G0_1_0_5_1 + 0.0023833198051949*G0_1_0_5_2 + 0.00221895292207798*G0_1_0_5_3 + 0.00591720779220802*G0_1_0_5_4 - 0.0739650974025999*G0_1_0_5_5 + 0.000739650974026058*G0_1_0_5_6 - 0.019230925324676*G0_1_0_5_9 - 0.0142999188311693*G0_1_0_6_0 - 0.000164366883116894*G0_1_0_6_1 - 0.00550629058441582*G0_1_0_6_2 - 0.00147930194805197*G0_1_0_6_3 - 0.00443790584415605*G0_1_0_6_4 + 0.000739650974026057*G0_1_0_6_5 + 0.00443790584415599*G0_1_0_6_8 + 0.0207102272727279*G0_1_0_6_9 + 0.0456118100649366*G0_1_0_7_0 + 0.00608157467532487*G0_1_0_7_1 - 0.000657467532467567*G0_1_0_7_2 - 0.00147930194805199*G0_1_0_7_3 + 0.00591720779220801*G0_1_0_7_4 - 0.0362428977272739*G0_1_0_7_8 - 0.019230925324676*G0_1_0_7_9 - 0.0167654220779226*G0_1_0_8_0 + 0.00139711850649357*G0_1_0_8_1 - 0.00213676948051955*G0_1_0_8_2 - 0.00295860389610398*G0_1_0_8_3 + 0.00443790584415599*G0_1_0_8_4 + 0.00443790584415599*G0_1_0_8_6 - 0.0362428977272739*G0_1_0_8_7 - 0.041420454545456*G0_1_0_8_8 - 0.019230925324676*G0_1_0_8_9 + 0.00641030844155868*G0_1_0_9_0 + 0.00345170454545467*G0_1_0_9_1 - 0.005917207792208*G0_1_0_9_2 - 0.00739650974025998*G0_1_0_9_3 + 0.00591720779220797*G0_1_0_9_4 - 0.019230925324676*G0_1_0_9_5 + 0.0207102272727279*G0_1_0_9_6 - 0.019230925324676*G0_1_0_9_7 - 0.019230925324676*G0_1_0_9_8 + 0.0887581168831198*G0_1_0_9_9;
    A[91] = A[19] - 0.00196022727272735*G0_0_1_0_0 - 0.00098011363636368*G0_0_1_0_1 + 0.00213676948051957*G0_0_1_0_3 - 0.00213676948051956*G0_0_1_0_4 - 0.00158887987012993*G0_0_1_0_5 + 0.000876623376623409*G0_0_1_0_6 - 0.00109577922077926*G0_0_1_0_7 - 0.00405438311688327*G0_0_1_0_8 - 0.00525974025974044*G0_0_1_0_9 - 0.00098011363636368*G0_0_1_1_0 + 0.000980113636363665*G0_0_1_1_2 + 0.0147930194805199*G0_0_1_1_3 - 0.00493100649350663*G0_0_1_1_4 - 0.000164366883116885*G0_0_1_1_5 + 0.000164366883116887*G0_0_1_1_6 + 0.0049310064935067*G0_0_1_1_7 - 0.0147930194805201*G0_0_1_1_8 + 0.000980113636363665*G0_0_1_2_1 + 0.00196022727272736*G0_0_1_2_2 + 0.00405438311688324*G0_0_1_2_3 + 0.00109577922077927*G0_0_1_2_4 - 0.000876623376623413*G0_0_1_2_5 + 0.00158887987012994*G0_0_1_2_6 + 0.00213676948051956*G0_0_1_2_7 - 0.00213676948051955*G0_0_1_2_8 + 0.00525974025974044*G0_0_1_2_9 + 0.00213676948051957*G0_0_1_3_0 + 0.0147930194805199*G0_0_1_3_1 + 0.00405438311688324*G0_0_1_3_2 + 0.0936891233766266*G0_0_1_3_3 - 0.0212033279220786*G0_0_1_3_4 - 0.002958603896104*G0_0_1_3_5 - 0.000493100649350682*G0_0_1_3_6 - 0.00641030844155869*G0_0_1_3_7 + 0.0128206168831174*G0_0_1_3_9 - 0.00213676948051956*G0_0_1_4_0 - 0.00493100649350663*G0_0_1_4_1 + 0.00109577922077927*G0_0_1_4_2 - 0.0212033279220786*G0_0_1_4_3 - 0.035503246753248*G0_0_1_4_4 + 0.00641030844155865*G0_0_1_4_5 - 0.00591720779220798*G0_0_1_4_6 + 0.00641030844155865*G0_0_1_4_8 - 0.0285998376623386*G0_0_1_4_9 - 0.00158887987012993*G0_0_1_5_0 - 0.000164366883116885*G0_0_1_5_1 - 0.000876623376623413*G0_0_1_5_2 - 0.002958603896104*G0_0_1_5_3 + 0.00641030844155865*G0_0_1_5_4 - 0.00394480519480529*G0_0_1_5_5 + 0.00591720779220801*G0_0_1_5_7 + 0.000493100649350658*G0_0_1_5_8 + 0.01479301948052*G0_0_1_5_9 + 0.000876623376623409*G0_0_1_6_0 + 0.000164366883116887*G0_0_1_6_1 + 0.00158887987012994*G0_0_1_6_2 - 0.000493100649350682*G0_0_1_6_3 - 0.00591720779220798*G0_0_1_6_4 + 0.00394480519480537*G0_0_1_6_6 - 0.00641030844155866*G0_0_1_6_7 + 0.00295860389610399*G0_0_1_6_8 - 0.01479301948052*G0_0_1_6_9 - 0.00109577922077926*G0_0_1_7_0 + 0.0049310064935067*G0_0_1_7_1 + 0.00213676948051956*G0_0_1_7_2 - 0.00641030844155869*G0_0_1_7_3 + 0.00591720779220801*G0_0_1_7_5 - 0.00641030844155866*G0_0_1_7_6 + 0.0355032467532481*G0_0_1_7_7 + 0.0212033279220787*G0_0_1_7_8 + 0.0285998376623387*G0_0_1_7_9 - 0.00405438311688327*G0_0_1_8_0 - 0.0147930194805201*G0_0_1_8_1 - 0.00213676948051955*G0_0_1_8_2 + 0.00641030844155865*G0_0_1_8_4 + 0.000493100649350658*G0_0_1_8_5 + 0.00295860389610399*G0_0_1_8_6 + 0.0212033279220787*G0_0_1_8_7 - 0.0936891233766267*G0_0_1_8_8 - 0.0128206168831173*G0_0_1_8_9 - 0.00525974025974044*G0_0_1_9_0 + 0.00525974025974044*G0_0_1_9_2 + 0.0128206168831174*G0_0_1_9_3 - 0.0285998376623386*G0_0_1_9_4 + 0.01479301948052*G0_0_1_9_5 - 0.01479301948052*G0_0_1_9_6 + 0.0285998376623387*G0_0_1_9_7 - 0.0128206168831173*G0_0_1_9_8 + 0.00196022727272735*G0_1_0_0_0 + 0.00098011363636368*G0_1_0_0_1 - 0.00213676948051956*G0_1_0_0_3 + 0.00213676948051956*G0_1_0_0_4 + 0.00158887987012993*G0_1_0_0_5 - 0.000876623376623409*G0_1_0_0_6 + 0.00109577922077926*G0_1_0_0_7 + 0.00405438311688327*G0_1_0_0_8 + 0.00525974025974044*G0_1_0_0_9 + 0.00098011363636368*G0_1_0_1_0 - 0.000980113636363665*G0_1_0_1_2 - 0.0147930194805199*G0_1_0_1_3 + 0.00493100649350663*G0_1_0_1_4 + 0.000164366883116885*G0_1_0_1_5 - 0.000164366883116888*G0_1_0_1_6 - 0.00493100649350671*G0_1_0_1_7 + 0.0147930194805201*G0_1_0_1_8 - 0.000980113636363665*G0_1_0_2_1 - 0.00196022727272736*G0_1_0_2_2 - 0.00405438311688324*G0_1_0_2_3 - 0.00109577922077927*G0_1_0_2_4 + 0.000876623376623413*G0_1_0_2_5 - 0.00158887987012994*G0_1_0_2_6 - 0.00213676948051956*G0_1_0_2_7 + 0.00213676948051955*G0_1_0_2_8 - 0.00525974025974044*G0_1_0_2_9 - 0.00213676948051956*G0_1_0_3_0 - 0.0147930194805199*G0_1_0_3_1 - 0.00405438311688324*G0_1_0_3_2 - 0.0936891233766266*G0_1_0_3_3 + 0.0212033279220786*G0_1_0_3_4 + 0.002958603896104*G0_1_0_3_5 + 0.000493100649350682*G0_1_0_3_6 + 0.00641030844155869*G0_1_0_3_7 - 0.0128206168831174*G0_1_0_3_9 + 0.00213676948051956*G0_1_0_4_0 + 0.00493100649350663*G0_1_0_4_1 - 0.00109577922077928*G0_1_0_4_2 + 0.0212033279220786*G0_1_0_4_3 + 0.035503246753248*G0_1_0_4_4 - 0.00641030844155865*G0_1_0_4_5 + 0.00591720779220798*G0_1_0_4_6 - 0.00641030844155865*G0_1_0_4_8 + 0.0285998376623386*G0_1_0_4_9 + 0.00158887987012993*G0_1_0_5_0 + 0.000164366883116885*G0_1_0_5_1 + 0.000876623376623413*G0_1_0_5_2 + 0.002958603896104*G0_1_0_5_3 - 0.00641030844155865*G0_1_0_5_4 + 0.00394480519480529*G0_1_0_5_5 - 0.00591720779220801*G0_1_0_5_7 - 0.000493100649350658*G0_1_0_5_8 - 0.01479301948052*G0_1_0_5_9 - 0.000876623376623409*G0_1_0_6_0 - 0.000164366883116888*G0_1_0_6_1 - 0.00158887987012994*G0_1_0_6_2 + 0.000493100649350682*G0_1_0_6_3 + 0.00591720779220798*G0_1_0_6_4 - 0.00394480519480537*G0_1_0_6_6 + 0.00641030844155866*G0_1_0_6_7 - 0.00295860389610399*G0_1_0_6_8 + 0.01479301948052*G0_1_0_6_9 + 0.00109577922077926*G0_1_0_7_0 - 0.00493100649350671*G0_1_0_7_1 - 0.00213676948051956*G0_1_0_7_2 + 0.00641030844155869*G0_1_0_7_3 - 0.00591720779220801*G0_1_0_7_5 + 0.00641030844155866*G0_1_0_7_6 - 0.0355032467532481*G0_1_0_7_7 - 0.0212033279220787*G0_1_0_7_8 - 0.0285998376623387*G0_1_0_7_9 + 0.00405438311688327*G0_1_0_8_0 + 0.0147930194805201*G0_1_0_8_1 + 0.00213676948051955*G0_1_0_8_2 - 0.00641030844155865*G0_1_0_8_4 - 0.000493100649350658*G0_1_0_8_5 - 0.00295860389610399*G0_1_0_8_6 - 0.0212033279220787*G0_1_0_8_7 + 0.0936891233766267*G0_1_0_8_8 + 0.0128206168831173*G0_1_0_8_9 + 0.00525974025974044*G0_1_0_9_0 - 0.00525974025974044*G0_1_0_9_2 - 0.0128206168831174*G0_1_0_9_3 + 0.0285998376623386*G0_1_0_9_4 - 0.01479301948052*G0_1_0_9_5 + 0.01479301948052*G0_1_0_9_6 - 0.0285998376623387*G0_1_0_9_7 + 0.0128206168831173*G0_1_0_9_8;
    A[66] = A[45] + 0.00195413961038969*G0_0_0_0_0 + 0.00193587662337671*G0_0_0_0_1 + 0.0108208198051952*G0_0_0_0_2 - 0.00813616071428603*G0_0_0_0_3 + 0.0179981737012994*G0_0_0_0_4 - 0.016272321428572*G0_0_0_0_5 + 0.0281067370129881*G0_0_0_0_6 - 0.00238331980519489*G0_0_0_0_7 - 0.000657467532467561*G0_0_0_0_8 + 0.011834415584416*G0_0_0_0_9 + 0.00193587662337671*G0_0_0_1_0 + 0.00315949675324687*G0_0_0_1_1 + 0.00835531655844188*G0_0_0_1_2 - 0.00986201298701335*G0_0_0_1_3 + 0.0216964285714294*G0_0_0_1_4 - 0.00912236201298737*G0_0_0_1_5 + 0.0283532873376634*G0_0_0_1_6 - 0.00213676948051956*G0_0_0_1_7 - 0.00189021915584422*G0_0_0_1_8 + 0.0167654220779227*G0_0_0_1_9 + 0.0108208198051952*G0_0_0_2_0 + 0.00835531655844188*G0_0_0_2_1 + 0.130397727272732*G0_0_0_2_2 - 0.0369825487013*G0_0_0_2_3 + 0.0813616071428602*G0_0_0_2_4 - 0.0517755681818201*G0_0_0_2_5 + 0.106016639610394*G0_0_0_2_6 - 0.00369825487013*G0_0_0_2_7 - 0.00123275162337667*G0_0_0_2_8 + 0.00986201298701337*G0_0_0_2_9 - 0.00813616071428603*G0_0_0_3_0 - 0.00986201298701335*G0_0_0_3_1 - 0.0369825487013*G0_0_0_3_2 + 0.0473376623376639*G0_0_0_3_3 - 0.095414975649354*G0_0_0_3_4 + 0.035503246753248*G0_0_0_3_5 - 0.104290787337666*G0_0_0_3_6 + 0.005177556818182*G0_0_0_3_7 + 0.010355113636364*G0_0_0_3_8 - 0.0606513798701319*G0_0_0_3_9 + 0.0179981737012994*G0_0_0_4_0 + 0.0216964285714294*G0_0_0_4_1 + 0.0813616071428602*G0_0_0_4_2 - 0.095414975649354*G0_0_0_4_3 + 0.21449878246754*G0_0_0_4_4 - 0.0732254464285741*G0_0_0_4_5 + 0.17751623376624*G0_0_0_4_6 - 0.011834415584416*G0_0_0_4_7 - 0.015532670454546*G0_0_0_4_8 + 0.116864853896108*G0_0_0_4_9 - 0.016272321428572*G0_0_0_5_0 - 0.00912236201298737*G0_0_0_5_1 - 0.0517755681818201*G0_0_0_5_2 + 0.035503246753248*G0_0_0_5_3 - 0.0732254464285741*G0_0_0_5_4 + 0.0532548701298721*G0_0_0_5_5 - 0.111687297077926*G0_0_0_5_6 + 0.00813616071428601*G0_0_0_5_8 - 0.05177556818182*G0_0_0_5_9 + 0.0281067370129881*G0_0_0_6_0 + 0.0283532873376634*G0_0_0_6_1 + 0.106016639610394*G0_0_0_6_2 - 0.104290787337666*G0_0_0_6_3 + 0.17751623376624*G0_0_0_6_4 - 0.111687297077926*G0_0_0_6_5 + 0.49556615259742*G0_0_0_6_6 - 0.00813616071428597*G0_0_0_6_7 - 0.031065340909092*G0_0_0_6_8 + 0.178995535714292*G0_0_0_6_9 - 0.00238331980519489*G0_0_0_7_0 - 0.00213676948051956*G0_0_0_7_1 - 0.00369825487013*G0_0_0_7_2 + 0.005177556818182*G0_0_0_7_3 - 0.011834415584416*G0_0_0_7_4 - 0.00813616071428597*G0_0_0_7_6 - 0.00591720779220801*G0_0_0_7_7 + 0.002958603896104*G0_0_0_7_8 - 0.019230925324676*G0_0_0_7_9 - 0.000657467532467561*G0_0_0_8_0 - 0.00189021915584422*G0_0_0_8_1 - 0.00123275162337667*G0_0_0_8_2 + 0.010355113636364*G0_0_0_8_3 - 0.015532670454546*G0_0_0_8_4 + 0.00813616071428601*G0_0_0_8_5 - 0.0310653409090919*G0_0_0_8_6 + 0.002958603896104*G0_0_0_8_7 + 0.002958603896104*G0_0_0_8_8 - 0.019230925324676*G0_0_0_8_9 + 0.011834415584416*G0_0_0_9_0 + 0.0167654220779227*G0_0_0_9_1 + 0.00986201298701337*G0_0_0_9_2 - 0.0606513798701319*G0_0_0_9_3 + 0.116864853896108*G0_0_0_9_4 - 0.0517755681818201*G0_0_0_9_5 + 0.178995535714292*G0_0_0_9_6 - 0.019230925324676*G0_0_0_9_7 - 0.019230925324676*G0_0_0_9_8 + 0.142012987012992*G0_0_0_9_9 + 0.00387175324675342*G0_0_1_0_0 + 0.0013423295454546*G0_0_1_0_1 + 0.00771611201298732*G0_0_1_0_2 - 0.0047666396103898*G0_0_1_0_3 + 0.00928672889610426*G0_0_1_0_4 - 0.00271205357142868*G0_0_1_0_5 + 0.0133137175324681*G0_0_1_0_6 + 0.00131493506493513*G0_0_1_0_7 - 0.0016436688311689*G0_0_1_0_8 + 0.00542410714285735*G0_0_1_0_9 + 0.0013423295454546*G0_0_1_1_0 + 0.00155235389610395*G0_0_1_1_1 + 0.00685775162337689*G0_0_1_1_2 - 0.00476663961038979*G0_0_1_1_3 + 0.0124918831168836*G0_0_1_1_4 - 0.0040269886363638*G0_0_1_1_5 + 0.0112591314935069*G0_0_1_1_6 - 0.000986201298701339*G0_0_1_1_8 + 0.00641030844155868*G0_0_1_1_9 + 0.00771611201298732*G0_0_1_2_0 + 0.00685775162337689*G0_0_1_2_1 + 0.105194805194809*G0_0_1_2_2 - 0.02958603896104*G0_0_1_2_3 + 0.0653358360389634*G0_0_1_2_4 - 0.0320515422077934*G0_0_1_2_5 + 0.0727323457792235*G0_0_1_2_6 - 0.00131493506493511*G0_0_1_2_7 - 0.00230113636363644*G0_0_1_2_8 + 0.0123275162337667*G0_0_1_2_9 - 0.0047666396103898*G0_0_1_3_0 - 0.00476663961038979*G0_0_1_3_1 - 0.02958603896104*G0_0_1_3_2 + 0.0251481331168839*G0_0_1_3_3 - 0.058432426948054*G0_0_1_3_4 + 0.019230925324676*G0_0_1_3_5 - 0.045858360389612*G0_0_1_3_6 + 0.002218952922078*G0_0_1_3_7 + 0.00295860389610399*G0_0_1_3_8 - 0.023668831168832*G0_0_1_3_9 + 0.00928672889610426*G0_0_1_4_0 + 0.0124918831168836*G0_0_1_4_1 + 0.0653358360389634*G0_0_1_4_2 - 0.058432426948054*G0_0_1_4_3 + 0.128699269480524*G0_0_1_4_4 - 0.0399411525974041*G0_0_1_4_5 + 0.0857995129870161*G0_0_1_4_6 - 0.005917207792208*G0_0_1_4_7 - 0.00517755681818199*G0_0_1_4_8 + 0.042899756493508*G0_0_1_4_9 - 0.00271205357142868*G0_0_1_5_0 - 0.00402698863636379*G0_0_1_5_1 - 0.0320515422077934*G0_0_1_5_2 + 0.019230925324676*G0_0_1_5_3 - 0.0399411525974041*G0_0_1_5_4 + 0.039941152597404*G0_0_1_5_5 - 0.0717461444805221*G0_0_1_5_6 + 0.00813616071428601*G0_0_1_5_7 - 0.016272321428572*G0_0_1_5_9 + 0.0133137175324681*G0_0_1_6_0 + 0.0112591314935069*G0_0_1_6_1 + 0.0727323457792235*G0_0_1_6_2 - 0.045858360389612*G0_0_1_6_3 + 0.0857995129870161*G0_0_1_6_4 - 0.0717461444805221*G0_0_1_6_5 + 0.202664366883124*G0_0_1_6_6 - 0.008136160714286*G0_0_1_6_7 - 0.00739650974025998*G0_0_1_6_8 + 0.054734172077924*G0_0_1_6_9 + 0.00131493506493513*G0_0_1_7_0 - 0.00131493506493511*G0_0_1_7_2 + 0.002218952922078*G0_0_1_7_3 - 0.005917207792208*G0_0_1_7_4 + 0.008136160714286*G0_0_1_7_5 - 0.008136160714286*G0_0_1_7_6 + 0.00591720779220803*G0_0_1_7_7 - 0.00221895292207802*G0_0_1_7_8 - 0.0016436688311689*G0_0_1_8_0 - 0.000986201298701339*G0_0_1_8_1 - 0.00230113636363644*G0_0_1_8_2 + 0.00295860389610399*G0_0_1_8_3 - 0.005177556818182*G0_0_1_8_4 - 0.00739650974025998*G0_0_1_8_6 - 0.00221895292207802*G0_0_1_8_7 - 0.00147930194805203*G0_0_1_8_8 - 0.00887581168831199*G0_0_1_8_9 + 0.00542410714285735*G0_0_1_9_0 + 0.00641030844155868*G0_0_1_9_1 + 0.0123275162337667*G0_0_1_9_2 - 0.023668831168832*G0_0_1_9_3 + 0.042899756493508*G0_0_1_9_4 - 0.016272321428572*G0_0_1_9_5 + 0.054734172077924*G0_0_1_9_6 - 0.00887581168831199*G0_0_1_9_8 + 0.035503246753248*G0_0_1_9_9 - 0.000602678571428626*G0_1_0_0_0 + 0.00105012175324679*G0_1_0_0_1 + 0.010482954545455*G0_1_0_0_2 - 0.00690340909090937*G0_1_0_0_3 + 0.00862926136363672*G0_1_0_0_4 - 0.0082183441558445*G0_1_0_0_5 + 0.015697037337663*G0_1_0_0_6 - 0.00262987012987025*G0_1_0_0_7 + 0.00106838474025979*G0_1_0_0_8 - 0.000493100649350651*G0_1_0_0_9 + 0.00105012175324679*G0_1_0_1_0 + 0.00294034090909097*G0_1_0_1_1 + 0.0107203733766238*G0_1_0_1_2 - 0.00336952110389626*G0_1_0_1_3 + 0.0185734577922085*G0_1_0_1_4 - 0.0041913555194807*G0_1_0_1_5 + 0.0106016639610394*G0_1_0_1_6 - 0.000986201298701331*G0_1_0_1_7 + 0.00986201298701333*G0_1_0_1_9 + 0.010482954545455*G0_1_0_2_0 + 0.0107203733766238*G0_1_0_2_1 + 0.178612012987019*G0_1_0_2_2 - 0.0463514610389627*G0_1_0_2_3 + 0.1109476461039*G0_1_0_2_4 - 0.0463514610389628*G0_1_0_2_5 + 0.101085633116887*G0_1_0_2_6 - 0.00394480519480534*G0_1_0_2_7 - 0.00246550324675333*G0_1_0_2_8 + 0.0187378246753253*G0_1_0_2_9 - 0.00690340909090937*G0_1_0_3_0 - 0.00336952110389626*G0_1_0_3_1 - 0.0463514610389627*G0_1_0_3_2 - 0.0162723214285721*G0_1_0_3_3 - 0.094675324675328*G0_1_0_3_4 + 0.023668831168832*G0_1_0_3_5 - 0.0458583603896121*G0_1_0_3_6 + 0.00665685876623403*G0_1_0_3_7 - 0.042899756493508*G0_1_0_3_9 + 0.00862926136363672*G0_1_0_4_0 + 0.0185734577922085*G0_1_0_4_1 + 0.1109476461039*G0_1_0_4_2 - 0.0946753246753281*G0_1_0_4_3 + 0.128699269480524*G0_1_0_4_4 - 0.0399411525974041*G0_1_0_4_5 + 0.0857995129870162*G0_1_0_4_6 - 0.00665685876623399*G0_1_0_4_8 + 0.023668831168832*G0_1_0_4_9 - 0.0082183441558445*G0_1_0_5_0 - 0.0041913555194807*G0_1_0_5_1 - 0.0463514610389628*G0_1_0_5_2 + 0.023668831168832*G0_1_0_5_3 - 0.0399411525974041*G0_1_0_5_4 + 0.0399411525974039*G0_1_0_5_5 - 0.0710064935064961*G0_1_0_5_6 + 0.00369825487012992*G0_1_0_5_7 - 0.00147930194805196*G0_1_0_5_8 + 0.00443790584415587*G0_1_0_5_9 + 0.015697037337663*G0_1_0_6_0 + 0.0106016639610394*G0_1_0_6_1 + 0.101085633116887*G0_1_0_6_2 - 0.0458583603896121*G0_1_0_6_3 + 0.0857995129870162*G0_1_0_6_4 - 0.0710064935064961*G0_1_0_6_5 + 0.128699269480524*G0_1_0_6_6 - 0.00221895292207797*G0_1_0_6_7 - 0.00517755681818201*G0_1_0_6_8 + 0.0355032467532481*G0_1_0_6_9 - 0.00262987012987025*G0_1_0_7_0 - 0.000986201298701331*G0_1_0_7_1 - 0.00394480519480534*G0_1_0_7_2 + 0.00665685876623403*G0_1_0_7_3 + 0.00369825487012992*G0_1_0_7_5 - 0.00221895292207797*G0_1_0_7_6 - 0.0147930194805202*G0_1_0_7_7 - 0.00073965097402594*G0_1_0_7_8 + 0.00591720779220793*G0_1_0_7_9 + 0.00106838474025979*G0_1_0_8_0 - 0.00246550324675333*G0_1_0_8_2 - 0.00665685876623399*G0_1_0_8_4 - 0.00147930194805196*G0_1_0_8_5 - 0.005177556818182*G0_1_0_8_6 - 0.00073965097402594*G0_1_0_8_7 - 0.00443790584415613*G0_1_0_8_8 - 0.016272321428572*G0_1_0_8_9 - 0.000493100649350651*G0_1_0_9_0 + 0.00986201298701333*G0_1_0_9_1 + 0.0187378246753253*G0_1_0_9_2 - 0.042899756493508*G0_1_0_9_3 + 0.023668831168832*G0_1_0_9_4 + 0.00443790584415588*G0_1_0_9_5 + 0.0355032467532481*G0_1_0_9_6 + 0.00591720779220793*G0_1_0_9_7 - 0.016272321428572*G0_1_0_9_8 + 0.124261363636368*G0_1_0_9_9 + 0.0467897727272745*G0_1_1_0_0 + 0.00346083603896118*G0_1_1_0_1 + 0.0105103490259744*G0_1_1_0_2 - 0.00353388798701316*G0_1_1_0_3 + 0.00583502435064959*G0_1_1_0_4 + 0.00164366883116894*G0_1_1_0_5 - 0.00254768668831171*G0_1_1_0_6 + 0.0343526785714299*G0_1_1_0_7 - 0.0156970373376629*G0_1_1_0_8 - 0.00246550324675326*G0_1_1_0_9 + 0.00346083603896118*G0_1_1_1_0 + 0.00297686688311698*G0_1_1_1_1 + 0.00816355519480551*G0_1_1_1_2 - 0.00805397727272757*G0_1_1_1_3 + 0.0180803571428578*G0_1_1_1_4 + 0.00756087662337686*G0_1_1_1_5 + 0.0142177353896109*G0_1_1_1_6 + 0.00969764610389646*G0_1_1_1_7 - 0.0115056818181822*G0_1_1_1_8 + 0.0216964285714293*G0_1_1_1_9 + 0.0105103490259744*G0_1_1_2_0 + 0.00816355519480551*G0_1_1_2_1 + 0.159527191558447*G0_1_1_2_2 - 0.0364894480519493*G0_1_1_2_3 + 0.091716720779224*G0_1_1_2_4 - 0.0366538149350663*G0_1_1_2_5 + 0.063199066558444*G0_1_1_2_6 + 0.00410917207792222*G0_1_1_2_7 - 0.000821834415584454*G0_1_1_2_8 + 0.00493100649350671*G0_1_1_2_9 - 0.00353388798701316*G0_1_1_3_0 - 0.00805397727272757*G0_1_1_3_1 - 0.0364894480519493*G0_1_1_3_2 - 0.00295860389610411*G0_1_1_3_3 - 0.085799512987016*G0_1_1_3_4 - 0.054734172077924*G0_1_1_3_6 - 0.00147930194805202*G0_1_1_3_7 + 0.01109476461039*G0_1_1_3_8 - 0.0621306818181839*G0_1_1_3_9 + 0.00583502435064959*G0_1_1_4_0 + 0.0180803571428578*G0_1_1_4_1 + 0.091716720779224*G0_1_1_4_2 - 0.085799512987016*G0_1_1_4_3 + 0.106509740259744*G0_1_1_4_4 - 0.0295860389610401*G0_1_1_4_5 + 0.0843202110389641*G0_1_1_4_6 - 0.00887581168831201*G0_1_1_4_7 - 0.00961546266233796*G0_1_1_4_8 + 0.0443790584415598*G0_1_1_4_9 + 0.00164366883116894*G0_1_1_5_0 + 0.00756087662337686*G0_1_1_5_1 - 0.0366538149350663*G0_1_1_5_2 - 0.0295860389610401*G0_1_1_5_4 + 0.178995535714292*G0_1_1_5_5 - 0.0244084821428582*G0_1_1_5_6 + 0.05917207792208*G0_1_1_5_7 - 0.034763595779222*G0_1_1_5_8 + 0.0769237012987039*G0_1_1_5_9 - 0.00254768668831171*G0_1_1_6_0 + 0.0142177353896109*G0_1_1_6_1 + 0.063199066558444*G0_1_1_6_2 - 0.054734172077924*G0_1_1_6_3 + 0.0843202110389641*G0_1_1_6_4 - 0.0244084821428582*G0_1_1_6_5 + 0.198226461038968*G0_1_1_6_6 - 0.024408482142858*G0_1_1_6_7 - 0.014053368506494*G0_1_1_6_8 + 0.0946753246753279*G0_1_1_6_9 + 0.0343526785714299*G0_1_1_7_0 + 0.00969764610389646*G0_1_1_7_1 + 0.00410917207792222*G0_1_1_7_2 - 0.00147930194805202*G0_1_1_7_3 - 0.00887581168831201*G0_1_1_7_4 + 0.05917207792208*G0_1_1_7_5 - 0.024408482142858*G0_1_1_7_6 + 0.193788555194812*G0_1_1_7_7 - 0.0332842938311701*G0_1_1_7_8 + 0.0562134740259761*G0_1_1_7_9 - 0.0156970373376629*G0_1_1_8_0 - 0.0115056818181822*G0_1_1_8_1 - 0.000821834415584454*G0_1_1_8_2 + 0.01109476461039*G0_1_1_8_3 - 0.00961546266233796*G0_1_1_8_4 - 0.034763595779222*G0_1_1_8_5 - 0.014053368506494*G0_1_1_8_6 - 0.0332842938311701*G0_1_1_8_7 + 0.0369825487013*G0_1_1_8_8 - 0.045858360389612*G0_1_1_8_9 - 0.00246550324675326*G0_1_1_9_0 + 0.0216964285714293*G0_1_1_9_1 + 0.00493100649350671*G0_1_1_9_2 - 0.0621306818181839*G0_1_1_9_3 + 0.0443790584415599*G0_1_1_9_4 + 0.0769237012987039*G0_1_1_9_5 + 0.0946753246753279*G0_1_1_9_6 + 0.0562134740259761*G0_1_1_9_7 - 0.045858360389612*G0_1_1_9_8 + 0.408287337662351*G0_1_1_9_9;
    A[55] = A[66] + 0.0069034090909093*G0_0_0_0_0 - 0.00309557629870142*G0_0_0_0_1 - 0.0114234983766239*G0_0_0_0_2 + 0.0130671672077927*G0_0_0_0_3 - 0.0219429788961048*G0_0_0_0_4 + 0.0157792207792214*G0_0_0_0_5 - 0.0428997564935081*G0_0_0_0_6 + 0.00246550324675334*G0_0_0_0_7 + 0.00246550324675333*G0_0_0_0_8 - 0.0276136363636373*G0_0_0_0_9 - 0.00309557629870142*G0_0_0_1_0 + 0.000109577922077908*G0_0_0_1_1 - 0.0124096996753251*G0_0_0_1_2 + 0.00591720779220803*G0_0_0_1_3 - 0.0251481331168841*G0_0_0_1_4 + 0.031804991883118*G0_0_0_1_5 - 0.0189843750000007*G0_0_0_1_6 + 0.010355113636364*G0_0_0_1_7 - 0.00641030844155866*G0_0_0_1_8 + 0.011834415584416*G0_0_0_1_9 - 0.0114234983766239*G0_0_0_2_0 - 0.0124096996753251*G0_0_0_2_1 - 0.17751623376624*G0_0_0_2_2 + 0.0557203733766253*G0_0_0_2_3 - 0.120809659090913*G0_0_0_2_4 + 0.0655823863636388*G0_0_0_2_5 - 0.150395698051954*G0_0_0_2_6 + 0.009615462662338*G0_0_0_2_7 + 0.00271205357142865*G0_0_0_2_8 - 0.0226826298701307*G0_0_0_2_9 + 0.0130671672077927*G0_0_0_3_0 + 0.00591720779220803*G0_0_0_3_1 + 0.0557203733766253*G0_0_0_3_2 - 0.017751623376624*G0_0_0_3_3 + 0.113166599025978*G0_0_0_3_4 - 0.0769237012987039*G0_0_0_3_5 + 0.0761840503246781*G0_0_0_3_6 - 0.019970576298702*G0_0_0_3_7 + 0.00887581168831198*G0_0_0_3_8 + 0.00443790584415608*G0_0_0_3_9 - 0.0219429788961048*G0_0_0_4_0 - 0.0251481331168841*G0_0_0_4_1 - 0.120809659090913*G0_0_0_4_2 + 0.113166599025978*G0_0_0_4_3 - 0.275150162337673*G0_0_0_4_4 + 0.0850598620129901*G0_0_0_4_5 - 0.161243912337668*G0_0_0_4_6 + 0.00887581168831199*G0_0_0_4_7 + 0.01109476461039*G0_0_0_4_8 - 0.102071834415588*G0_0_0_4_9 + 0.0157792207792214*G0_0_0_5_0 + 0.031804991883118*G0_0_0_5_1 + 0.0655823863636388*G0_0_0_5_2 - 0.0769237012987039*G0_0_0_5_3 + 0.0850598620129901*G0_0_0_5_4 + 0.313612012987023*G0_0_0_5_5 + 0.133876826298706*G0_0_0_5_6 + 0.0857995129870159*G0_0_0_5_7 - 0.0761840503246779*G0_0_0_5_8 + 0.235209009740268*G0_0_0_5_9 - 0.0428997564935081*G0_0_0_6_0 - 0.0189843750000007*G0_0_0_6_1 - 0.150395698051954*G0_0_0_6_2 + 0.0761840503246781*G0_0_0_6_3 - 0.161243912337668*G0_0_0_6_4 + 0.133876826298706*G0_0_0_6_5 - 0.245564123376633*G0_0_0_6_6 - 0.00961546266233798*G0_0_0_6_7 + 0.01479301948052*G0_0_0_6_8 - 0.0843202110389642*G0_0_0_6_9 + 0.00246550324675334*G0_0_0_7_0 + 0.010355113636364*G0_0_0_7_1 + 0.009615462662338*G0_0_0_7_2 - 0.019970576298702*G0_0_0_7_3 + 0.00887581168831199*G0_0_0_7_4 + 0.0857995129870159*G0_0_0_7_5 - 0.00961546266233798*G0_0_0_7_6 + 0.05917207792208*G0_0_0_7_7 - 0.031804991883118*G0_0_0_7_8 + 0.102071834415588*G0_0_0_7_9 + 0.00246550324675333*G0_0_0_8_0 - 0.00641030844155866*G0_0_0_8_1 + 0.00271205357142865*G0_0_0_8_2 + 0.00887581168831198*G0_0_0_8_3 + 0.01109476461039*G0_0_0_8_4 - 0.0761840503246779*G0_0_0_8_5 + 0.01479301948052*G0_0_0_8_6 - 0.031804991883118*G0_0_0_8_7 + 0.023668831168832*G0_0_0_8_8 - 0.057692775974028*G0_0_0_8_9 - 0.0276136363636373*G0_0_0_9_0 + 0.011834415584416*G0_0_0_9_1 - 0.0226826298701307*G0_0_0_9_2 + 0.00443790584415609*G0_0_0_9_3 - 0.102071834415588*G0_0_0_9_4 + 0.235209009740268*G0_0_0_9_5 - 0.0843202110389642*G0_0_0_9_6 + 0.102071834415588*G0_0_0_9_7 - 0.057692775974028*G0_0_0_9_8 + 0.26627435064936*G0_0_0_9_9 - 0.0202171266233773*G0_0_1_0_0 - 0.0039995941558443*G0_0_1_0_1 - 0.0114234983766238*G0_0_1_0_2 + 0.00862926136363668*G0_0_1_0_3 - 0.0108482142857147*G0_0_1_0_4 - 0.0310653409090919*G0_0_1_0_5 - 0.00838271103896137*G0_0_1_0_6 - 0.0172585227272733*G0_0_1_0_7 + 0.0108482142857146*G0_0_1_0_8 - 0.0187378246753253*G0_0_1_0_9 - 0.0039995941558443*G0_0_1_1_0 + 0.00010957792207792*G0_0_1_1_1 - 0.0115056818181823*G0_0_1_1_2 + 0.00172585227272736*G0_0_1_1_3 - 0.0138068181818187*G0_0_1_1_4 + 0.00961546266233801*G0_0_1_1_5 + 0.00320515422077929*G0_0_1_1_6 - 0.00098620129870133*G0_0_1_1_7 - 0.00221895292207799*G0_0_1_1_8 + 0.011834415584416*G0_0_1_1_9 - 0.0114234983766238*G0_0_1_2_0 - 0.0115056818181823*G0_0_1_2_1 - 0.150395698051953*G0_0_1_2_2 + 0.047337662337664*G0_0_1_2_3 - 0.101085633116887*G0_0_1_2_4 + 0.0310653409090921*G0_0_1_2_5 - 0.10355113636364*G0_0_1_2_6 - 0.001479301948052*G0_0_1_2_7 + 0.00714995941558466*G0_0_1_2_8 - 0.0315584415584427*G0_0_1_2_9 + 0.00862926136363668*G0_0_1_3_0 + 0.00172585227272736*G0_0_1_3_1 + 0.047337662337664*G0_0_1_3_2 + 0.0710064935064961*G0_0_1_3_4 - 0.0369825487013*G0_0_1_3_5 + 0.00961546266233818*G0_0_1_3_6 - 0.00665685876623399*G0_0_1_3_7 + 0.00887581168831197*G0_0_1_3_8 - 0.0221895292207799*G0_0_1_3_9 - 0.0108482142857147*G0_0_1_4_0 - 0.0138068181818187*G0_0_1_4_1 - 0.101085633116887*G0_0_1_4_2 + 0.0710064935064961*G0_0_1_4_3 - 0.17751623376624*G0_0_1_4_4 + 0.0517755681818201*G0_0_1_4_5 - 0.0613910308441583*G0_0_1_4_6 + 0.00887581168831201*G0_0_1_4_7 - 0.00221895292207798*G0_0_1_4_8 - 0.00887581168831214*G0_0_1_4_9 - 0.0310653409090919*G0_0_1_5_0 + 0.00961546266233801*G0_0_1_5_1 + 0.0310653409090921*G0_0_1_5_2 - 0.0369825487013*G0_0_1_5_3 + 0.0517755681818201*G0_0_1_5_4 + 0.0340239448051957*G0_0_1_5_5 + 0.133876826298706*G0_0_1_5_6 - 0.014053368506494*G0_0_1_5_7 - 0.00961546266233795*G0_0_1_5_8 + 0.0754443993506518*G0_0_1_5_9 - 0.00838271103896137*G0_0_1_6_0 + 0.00320515422077929*G0_0_1_6_1 - 0.10355113636364*G0_0_1_6_2 + 0.00961546266233818*G0_0_1_6_3 - 0.0613910308441583*G0_0_1_6_4 + 0.133876826298706*G0_0_1_6_5 + 0.0340239448051953*G0_0_1_6_6 + 0.023668831168832*G0_0_1_6_7 - 0.0251481331168839*G0_0_1_6_8 + 0.0754443993506518*G0_0_1_6_9 - 0.0172585227272733*G0_0_1_7_0 - 0.00098620129870133*G0_0_1_7_1 - 0.001479301948052*G0_0_1_7_2 - 0.00665685876623399*G0_0_1_7_3 + 0.00887581168831202*G0_0_1_7_4 - 0.014053368506494*G0_0_1_7_5 + 0.023668831168832*G0_0_1_7_6 - 0.0384618506493519*G0_0_1_7_7 + 0.010355113636364*G0_0_1_7_8 + 0.00887581168831197*G0_0_1_7_9 + 0.0108482142857146*G0_0_1_8_0 - 0.00221895292207799*G0_0_1_8_1 + 0.00714995941558466*G0_0_1_8_2 + 0.00887581168831197*G0_0_1_8_3 - 0.00221895292207798*G0_0_1_8_4 - 0.00961546266233795*G0_0_1_8_5 - 0.025148133116884*G0_0_1_8_6 + 0.010355113636364*G0_0_1_8_7 + 0.00591720779220802*G0_0_1_8_8 - 0.0310653409090919*G0_0_1_8_9 - 0.0187378246753253*G0_0_1_9_0 + 0.011834415584416*G0_0_1_9_1 - 0.0315584415584427*G0_0_1_9_2 - 0.0221895292207799*G0_0_1_9_3 - 0.00887581168831214*G0_0_1_9_4 + 0.0754443993506518*G0_0_1_9_5 + 0.0754443993506518*G0_0_1_9_6 + 0.00887581168831197*G0_0_1_9_7 - 0.0310653409090919*G0_0_1_9_8 + 0.26627435064936*G0_0_1_9_9 - 0.0202171266233773*G0_1_0_0_0 - 0.0039995941558443*G0_1_0_0_1 - 0.0114234983766238*G0_1_0_0_2 + 0.00862926136363668*G0_1_0_0_3 - 0.0108482142857147*G0_1_0_0_4 - 0.0310653409090919*G0_1_0_0_5 - 0.00838271103896137*G0_1_0_0_6 - 0.0172585227272733*G0_1_0_0_7 + 0.0108482142857146*G0_1_0_0_8 - 0.0187378246753253*G0_1_0_0_9 - 0.0039995941558443*G0_1_0_1_0 + 0.00010957792207792*G0_1_0_1_1 - 0.0115056818181823*G0_1_0_1_2 + 0.00172585227272736*G0_1_0_1_3 - 0.0138068181818187*G0_1_0_1_4 + 0.00961546266233801*G0_1_0_1_5 + 0.00320515422077929*G0_1_0_1_6 - 0.000986201298701331*G0_1_0_1_7 - 0.00221895292207799*G0_1_0_1_8 + 0.011834415584416*G0_1_0_1_9 - 0.0114234983766238*G0_1_0_2_0 - 0.0115056818181823*G0_1_0_2_1 - 0.150395698051953*G0_1_0_2_2 + 0.047337662337664*G0_1_0_2_3 - 0.101085633116887*G0_1_0_2_4 + 0.0310653409090921*G0_1_0_2_5 - 0.10355113636364*G0_1_0_2_6 - 0.001479301948052*G0_1_0_2_7 + 0.00714995941558466*G0_1_0_2_8 - 0.0315584415584427*G0_1_0_2_9 + 0.00862926136363668*G0_1_0_3_0 + 0.00172585227272736*G0_1_0_3_1 + 0.047337662337664*G0_1_0_3_2 + 0.0710064935064961*G0_1_0_3_4 - 0.0369825487013*G0_1_0_3_5 + 0.00961546266233818*G0_1_0_3_6 - 0.00665685876623399*G0_1_0_3_7 + 0.00887581168831197*G0_1_0_3_8 - 0.0221895292207799*G0_1_0_3_9 - 0.0108482142857147*G0_1_0_4_0 - 0.0138068181818187*G0_1_0_4_1 - 0.101085633116887*G0_1_0_4_2 + 0.0710064935064961*G0_1_0_4_3 - 0.17751623376624*G0_1_0_4_4 + 0.0517755681818201*G0_1_0_4_5 - 0.0613910308441583*G0_1_0_4_6 + 0.00887581168831201*G0_1_0_4_7 - 0.00221895292207798*G0_1_0_4_8 - 0.00887581168831215*G0_1_0_4_9 - 0.0310653409090919*G0_1_0_5_0 + 0.00961546266233801*G0_1_0_5_1 + 0.0310653409090921*G0_1_0_5_2 - 0.0369825487013*G0_1_0_5_3 + 0.0517755681818201*G0_1_0_5_4 + 0.0340239448051957*G0_1_0_5_5 + 0.133876826298706*G0_1_0_5_6 - 0.014053368506494*G0_1_0_5_7 - 0.00961546266233795*G0_1_0_5_8 + 0.0754443993506518*G0_1_0_5_9 - 0.00838271103896137*G0_1_0_6_0 + 0.00320515422077929*G0_1_0_6_1 - 0.10355113636364*G0_1_0_6_2 + 0.00961546266233818*G0_1_0_6_3 - 0.0613910308441583*G0_1_0_6_4 + 0.133876826298706*G0_1_0_6_5 + 0.0340239448051953*G0_1_0_6_6 + 0.023668831168832*G0_1_0_6_7 - 0.0251481331168839*G0_1_0_6_8 + 0.0754443993506518*G0_1_0_6_9 - 0.0172585227272733*G0_1_0_7_0 - 0.000986201298701331*G0_1_0_7_1 - 0.001479301948052*G0_1_0_7_2 - 0.00665685876623399*G0_1_0_7_3 + 0.00887581168831202*G0_1_0_7_4 - 0.014053368506494*G0_1_0_7_5 + 0.023668831168832*G0_1_0_7_6 - 0.0384618506493519*G0_1_0_7_7 + 0.010355113636364*G0_1_0_7_8 + 0.00887581168831197*G0_1_0_7_9 + 0.0108482142857146*G0_1_0_8_0 - 0.00221895292207799*G0_1_0_8_1 + 0.00714995941558466*G0_1_0_8_2 + 0.00887581168831197*G0_1_0_8_3 - 0.00221895292207798*G0_1_0_8_4 - 0.00961546266233795*G0_1_0_8_5 - 0.025148133116884*G0_1_0_8_6 + 0.010355113636364*G0_1_0_8_7 + 0.00591720779220802*G0_1_0_8_8 - 0.0310653409090919*G0_1_0_8_9 - 0.0187378246753253*G0_1_0_9_0 + 0.011834415584416*G0_1_0_9_1 - 0.0315584415584427*G0_1_0_9_2 - 0.0221895292207799*G0_1_0_9_3 - 0.00887581168831215*G0_1_0_9_4 + 0.0754443993506518*G0_1_0_9_5 + 0.0754443993506518*G0_1_0_9_6 + 0.00887581168831197*G0_1_0_9_7 - 0.0310653409090919*G0_1_0_9_8 + 0.26627435064936*G0_1_0_9_9 + 0.130178571428576*G0_1_1_0_0 + 0.00750608766233792*G0_1_1_0_1 + 0.001479301948052*G0_1_1_0_3 - 0.00936891233766271*G0_1_1_0_4 + 0.0724857954545479*G0_1_1_0_5 - 0.0394480519480533*G0_1_1_0_6 + 0.0838271103896133*G0_1_1_0_7 - 0.0364894480519493*G0_1_1_0_8 + 0.0128206168831174*G0_1_1_0_9 + 0.00750608766233792*G0_1_1_1_0 - 0.00750608766233795*G0_1_1_1_2 + 0.00394480519480535*G0_1_1_1_3 - 0.0128206168831174*G0_1_1_1_4 + 0.00641030844155868*G0_1_1_1_5 - 0.00641030844155869*G0_1_1_1_6 + 0.0128206168831173*G0_1_1_1_7 - 0.00394480519480533*G0_1_1_1_8 - 0.00750608766233795*G0_1_1_2_1 - 0.130178571428576*G0_1_1_2_2 + 0.0364894480519493*G0_1_1_2_3 - 0.0838271103896134*G0_1_1_2_4 + 0.0394480519480534*G0_1_1_2_5 - 0.0724857954545482*G0_1_1_2_6 + 0.00936891233766265*G0_1_1_2_7 - 0.001479301948052*G0_1_1_2_8 - 0.0128206168831173*G0_1_1_2_9 + 0.001479301948052*G0_1_1_3_0 + 0.00394480519480535*G0_1_1_3_1 + 0.0364894480519493*G0_1_1_3_2 - 0.00591720779220802*G0_1_1_3_3 + 0.0606513798701321*G0_1_1_3_4 - 0.011834415584416*G0_1_1_3_5 + 0.0192309253246761*G0_1_1_3_6 - 0.00443790584415601*G0_1_1_3_7 + 0.00887581168831205*G0_1_1_3_9 - 0.00936891233766271*G0_1_1_4_0 - 0.0128206168831174*G0_1_1_4_1 - 0.0838271103896134*G0_1_1_4_2 + 0.0606513798701321*G0_1_1_4_3 - 0.139054383116888*G0_1_1_4_4 + 0.0281067370129881*G0_1_1_4_5 - 0.0473376623376642*G0_1_1_4_6 + 0.004437905844156*G0_1_1_4_8 - 0.017751623376624*G0_1_1_4_9 + 0.0724857954545479*G0_1_1_5_0 + 0.00641030844155868*G0_1_1_5_1 + 0.0394480519480534*G0_1_1_5_2 - 0.011834415584416*G0_1_1_5_3 + 0.0281067370129881*G0_1_1_5_4 + 0.0473376623376639*G0_1_1_5_7 - 0.019230925324676*G0_1_1_5_8 - 0.0394480519480533*G0_1_1_6_0 - 0.00641030844155869*G0_1_1_6_1 - 0.0724857954545482*G0_1_1_6_2 + 0.0192309253246761*G0_1_1_6_3 - 0.0473376623376642*G0_1_1_6_4 - 0.0281067370129879*G0_1_1_6_7 + 0.011834415584416*G0_1_1_6_8 + 0.0838271103896133*G0_1_1_7_0 + 0.0128206168831173*G0_1_1_7_1 + 0.00936891233766265*G0_1_1_7_2 - 0.00443790584415602*G0_1_1_7_3 + 0.0473376623376639*G0_1_1_7_5 - 0.0281067370129879*G0_1_1_7_6 + 0.139054383116888*G0_1_1_7_7 - 0.0606513798701319*G0_1_1_7_8 + 0.017751623376624*G0_1_1_7_9 - 0.0364894480519493*G0_1_1_8_0 - 0.00394480519480533*G0_1_1_8_1 - 0.001479301948052*G0_1_1_8_2 + 0.004437905844156*G0_1_1_8_4 - 0.019230925324676*G0_1_1_8_5 + 0.011834415584416*G0_1_1_8_6 - 0.0606513798701319*G0_1_1_8_7 + 0.00591720779220803*G0_1_1_8_8 - 0.00887581168831198*G0_1_1_8_9 + 0.0128206168831174*G0_1_1_9_0 - 0.0128206168831173*G0_1_1_9_2 + 0.00887581168831205*G0_1_1_9_3 - 0.017751623376624*G0_1_1_9_4 + 0.017751623376624*G0_1_1_9_7 - 0.00887581168831198*G0_1_1_9_8;
    A[64] = -A[66] - 0.00171672077922087*G0_0_1_0_0 + 0.000127840909090911*G0_0_1_0_1 + 0.00904017857142894*G0_0_1_0_2 - 0.00205458603896113*G0_0_1_0_3 - 0.00180803571428576*G0_0_1_0_4 - 0.000904017857142925*G0_0_1_0_5 + 0.00673904220779248*G0_0_1_0_6 + 0.000493100649350677*G0_0_1_0_8 - 0.00690340909090935*G0_0_1_0_9 + 0.000127840909090911*G0_0_1_1_0 - 0.00171672077922087*G0_0_1_1_1 + 0.00904017857142891*G0_0_1_1_2 - 0.000904017857142903*G0_0_1_1_3 + 0.00673904220779247*G0_0_1_1_4 - 0.00205458603896112*G0_0_1_1_5 - 0.00180803571428575*G0_0_1_1_6 + 0.000493100649350673*G0_0_1_1_7 - 0.00690340909090933*G0_0_1_1_9 + 0.00904017857142894*G0_0_1_2_0 + 0.00904017857142891*G0_0_1_2_1 + 0.161627435064941*G0_0_1_2_2 - 0.0394480519480533*G0_0_1_2_3 + 0.0912236201298734*G0_0_1_2_4 - 0.0394480519480534*G0_0_1_2_5 + 0.0912236201298735*G0_0_1_2_6 - 0.00328733766233778*G0_0_1_2_7 - 0.00328733766233777*G0_0_1_2_8 + 0.0246550324675333*G0_0_1_2_9 - 0.00205458603896113*G0_0_1_3_0 - 0.000904017857142903*G0_0_1_3_1 - 0.0394480519480533*G0_0_1_3_2 + 0.00147930194805194*G0_0_1_3_3 - 0.0369825487013*G0_0_1_3_4 + 0.00887581168831202*G0_0_1_3_5 + 0.000739650974026026*G0_0_1_3_7 - 0.00517755681818202*G0_0_1_3_8 + 0.0192309253246759*G0_0_1_3_9 - 0.00180803571428576*G0_0_1_4_0 + 0.00673904220779247*G0_0_1_4_1 + 0.0912236201298734*G0_0_1_4_2 - 0.0369825487013001*G0_0_1_4_3 + 0.010355113636364*G0_0_1_4_7 + 0.004437905844156*G0_0_1_4_8 - 0.0739650974025999*G0_0_1_4_9 - 0.000904017857142924*G0_0_1_5_0 - 0.00205458603896112*G0_0_1_5_1 - 0.0394480519480534*G0_0_1_5_2 + 0.00887581168831202*G0_0_1_5_3 + 0.00147930194805205*G0_0_1_5_5 - 0.0369825487013001*G0_0_1_5_6 - 0.00517755681818203*G0_0_1_5_7 + 0.000739650974026004*G0_0_1_5_8 + 0.019230925324676*G0_0_1_5_9 + 0.00673904220779247*G0_0_1_6_0 - 0.00180803571428575*G0_0_1_6_1 + 0.0912236201298735*G0_0_1_6_2 - 0.0369825487013001*G0_0_1_6_5 + 0.004437905844156*G0_0_1_6_7 + 0.010355113636364*G0_0_1_6_8 - 0.0739650974025998*G0_0_1_6_9 + 0.000493100649350673*G0_0_1_7_1 - 0.00328733766233778*G0_0_1_7_2 + 0.000739650974026025*G0_0_1_7_3 + 0.010355113636364*G0_0_1_7_4 - 0.00517755681818203*G0_0_1_7_5 + 0.004437905844156*G0_0_1_7_6 - 0.0118344155844162*G0_0_1_7_7 + 0.00147930194805204*G0_0_1_7_8 + 0.0118344155844159*G0_0_1_7_9 + 0.000493100649350677*G0_0_1_8_0 - 0.00328733766233777*G0_0_1_8_2 - 0.00517755681818202*G0_0_1_8_3 + 0.004437905844156*G0_0_1_8_4 + 0.000739650974026004*G0_0_1_8_5 + 0.010355113636364*G0_0_1_8_6 + 0.00147930194805204*G0_0_1_8_7 - 0.0118344155844161*G0_0_1_8_8 + 0.011834415584416*G0_0_1_8_9 - 0.00690340909090935*G0_0_1_9_0 - 0.00690340909090933*G0_0_1_9_1 + 0.0246550324675333*G0_0_1_9_2 + 0.0192309253246759*G0_0_1_9_3 - 0.0739650974025999*G0_0_1_9_4 + 0.019230925324676*G0_0_1_9_5 - 0.0739650974025998*G0_0_1_9_6 + 0.0118344155844159*G0_0_1_9_7 + 0.011834415584416*G0_0_1_9_8 - 0.142012987012992*G0_0_1_9_9 + 0.0445799512987029*G0_1_1_0_0 + 0.00301339285714297*G0_1_1_0_1 + 0.00914062500000036*G0_1_1_0_2 + 0.00115056818181819*G0_1_1_0_3 + 0.00213676948051958*G0_1_1_0_4 + 0.00156148538961046*G0_1_1_0_5 - 0.00558847402597415*G0_1_1_0_6 + 0.02958603896104*G0_1_1_0_7 - 0.0123275162337667*G0_1_1_0_8 - 0.00394480519480527*G0_1_1_0_9 + 0.00301339285714297*G0_1_1_1_0 + 0.00462053571428588*G0_1_1_1_1 + 0.00674817370129896*G0_1_1_1_2 - 0.00805397727272755*G0_1_1_1_3 + 0.0106838474025978*G0_1_1_1_4 + 0.00977982954545486*G0_1_1_1_5 + 0.0100263798701302*G0_1_1_1_6 + 0.00723214285714312*G0_1_1_1_7 - 0.00657467532467556*G0_1_1_1_8 + 0.0167654220779227*G0_1_1_1_9 + 0.00914062500000036*G0_1_1_2_0 + 0.00674817370129896*G0_1_1_2_1 + 0.146834415584421*G0_1_1_2_2 - 0.0299969561688322*G0_1_1_2_3 + 0.0723214285714311*G0_1_1_2_4 - 0.0316406250000012*G0_1_1_2_5 + 0.0534192370129891*G0_1_1_2_6 + 0.00435572240259755*G0_1_1_2_7 + 0.00139711850649354*G0_1_1_2_8 + 0.00246550324675336*G0_1_1_2_9 + 0.00115056818181819*G0_1_1_3_0 - 0.00805397727272755*G0_1_1_3_1 - 0.0299969561688322*G0_1_1_3_2 + 0.0369825487013*G0_1_1_3_3 - 0.051035917207794*G0_1_1_3_4 - 0.0125740665584419*G0_1_1_3_5 - 0.037722199675326*G0_1_1_3_6 - 0.01109476461039*G0_1_1_3_7 + 0.022929180194806*G0_1_1_3_8 - 0.0281067370129879*G0_1_1_3_9 + 0.00213676948051958*G0_1_1_4_0 + 0.0106838474025978*G0_1_1_4_1 + 0.0723214285714311*G0_1_1_4_2 - 0.051035917207794*G0_1_1_4_3 + 0.0517755681818199*G0_1_1_4_4 - 0.0140533685064941*G0_1_1_4_5 + 0.0517755681818201*G0_1_1_4_6 - 0.00591720779220801*G0_1_1_4_7 - 0.011834415584416*G0_1_1_4_8 + 0.0207102272727279*G0_1_1_4_9 + 0.00156148538961046*G0_1_1_5_0 + 0.00977982954545486*G0_1_1_5_1 - 0.0316406250000012*G0_1_1_5_2 - 0.0125740665584419*G0_1_1_5_3 - 0.0140533685064941*G0_1_1_5_4 + 0.174557629870136*G0_1_1_5_5 - 0.00813616071428615*G0_1_1_5_6 + 0.0576927759740279*G0_1_1_5_7 - 0.0369825487013*G0_1_1_5_8 + 0.0857995129870158*G0_1_1_5_9 - 0.00558847402597415*G0_1_1_6_0 + 0.0100263798701302*G0_1_1_6_1 + 0.0534192370129891*G0_1_1_6_2 - 0.037722199675326*G0_1_1_6_3 + 0.0517755681818201*G0_1_1_6_4 - 0.00813616071428615*G0_1_1_6_5 + 0.15532670454546*G0_1_1_6_6 - 0.020710227272728*G0_1_1_6_7 - 0.013313717532468*G0_1_1_6_8 + 0.0680478896103919*G0_1_1_6_9 + 0.02958603896104*G0_1_1_7_0 + 0.00723214285714312*G0_1_1_7_1 + 0.00435572240259755*G0_1_1_7_2 - 0.01109476461039*G0_1_1_7_3 - 0.00591720779220801*G0_1_1_7_4 + 0.0576927759740279*G0_1_1_7_5 - 0.020710227272728*G0_1_1_7_6 + 0.19230925324676*G0_1_1_7_7 - 0.035503246753248*G0_1_1_7_8 + 0.0532548701298721*G0_1_1_7_9 - 0.0123275162337667*G0_1_1_8_0 - 0.00657467532467556*G0_1_1_8_1 + 0.00139711850649354*G0_1_1_8_2 + 0.022929180194806*G0_1_1_8_3 - 0.011834415584416*G0_1_1_8_4 - 0.0369825487013*G0_1_1_8_5 - 0.013313717532468*G0_1_1_8_6 - 0.035503246753248*G0_1_1_8_7 + 0.0917167207792239*G0_1_1_8_8 - 0.026627435064936*G0_1_1_8_9 - 0.00394480519480527*G0_1_1_9_0 + 0.0167654220779227*G0_1_1_9_1 + 0.00246550324675336*G0_1_1_9_2 - 0.0281067370129879*G0_1_1_9_3 + 0.0207102272727279*G0_1_1_9_4 + 0.0857995129870158*G0_1_1_9_5 + 0.0680478896103919*G0_1_1_9_6 + 0.0532548701298721*G0_1_1_9_7 - 0.026627435064936*G0_1_1_9_8 + 0.408287337662352*G0_1_1_9_9;
    A[46] = A[64] + 0.00171672077922087*G0_0_1_0_0 - 0.000127840909090911*G0_0_1_0_1 - 0.00904017857142893*G0_0_1_0_2 + 0.00205458603896113*G0_0_1_0_3 + 0.00180803571428577*G0_0_1_0_4 + 0.000904017857142925*G0_0_1_0_5 - 0.00673904220779247*G0_0_1_0_6 - 0.000493100649350677*G0_0_1_0_8 + 0.00690340909090935*G0_0_1_0_9 - 0.000127840909090911*G0_0_1_1_0 + 0.00171672077922087*G0_0_1_1_1 - 0.00904017857142891*G0_0_1_1_2 + 0.000904017857142903*G0_0_1_1_3 - 0.00673904220779247*G0_0_1_1_4 + 0.00205458603896112*G0_0_1_1_5 + 0.00180803571428575*G0_0_1_1_6 - 0.000493100649350673*G0_0_1_1_7 + 0.00690340909090933*G0_0_1_1_9 - 0.00904017857142893*G0_0_1_2_0 - 0.00904017857142891*G0_0_1_2_1 - 0.161627435064941*G0_0_1_2_2 + 0.0394480519480533*G0_0_1_2_3 - 0.0912236201298733*G0_0_1_2_4 + 0.0394480519480534*G0_0_1_2_5 - 0.0912236201298735*G0_0_1_2_6 + 0.00328733766233778*G0_0_1_2_7 + 0.00328733766233777*G0_0_1_2_8 - 0.0246550324675333*G0_0_1_2_9 + 0.00205458603896113*G0_0_1_3_0 + 0.000904017857142903*G0_0_1_3_1 + 0.0394480519480533*G0_0_1_3_2 - 0.00147930194805194*G0_0_1_3_3 + 0.0369825487013*G0_0_1_3_4 - 0.00887581168831202*G0_0_1_3_5 - 0.00073965097402603*G0_0_1_3_7 + 0.00517755681818202*G0_0_1_3_8 - 0.0192309253246759*G0_0_1_3_9 + 0.00180803571428577*G0_0_1_4_0 - 0.00673904220779247*G0_0_1_4_1 - 0.0912236201298733*G0_0_1_4_2 + 0.0369825487013001*G0_0_1_4_3 - 0.010355113636364*G0_0_1_4_7 - 0.004437905844156*G0_0_1_4_8 + 0.0739650974025999*G0_0_1_4_9 + 0.000904017857142926*G0_0_1_5_0 + 0.00205458603896112*G0_0_1_5_1 + 0.0394480519480534*G0_0_1_5_2 - 0.00887581168831202*G0_0_1_5_3 - 0.00147930194805206*G0_0_1_5_5 + 0.0369825487013*G0_0_1_5_6 + 0.00517755681818203*G0_0_1_5_7 - 0.000739650974026002*G0_0_1_5_8 - 0.019230925324676*G0_0_1_5_9 - 0.00673904220779247*G0_0_1_6_0 + 0.00180803571428575*G0_0_1_6_1 - 0.0912236201298735*G0_0_1_6_2 + 0.0369825487013*G0_0_1_6_5 - 0.004437905844156*G0_0_1_6_7 - 0.010355113636364*G0_0_1_6_8 + 0.0739650974025998*G0_0_1_6_9 - 0.000493100649350673*G0_0_1_7_1 + 0.00328733766233778*G0_0_1_7_2 - 0.000739650974026029*G0_0_1_7_3 - 0.010355113636364*G0_0_1_7_4 + 0.00517755681818203*G0_0_1_7_5 - 0.004437905844156*G0_0_1_7_6 + 0.0118344155844162*G0_0_1_7_7 - 0.00147930194805204*G0_0_1_7_8 - 0.0118344155844159*G0_0_1_7_9 - 0.000493100649350677*G0_0_1_8_0 + 0.00328733766233777*G0_0_1_8_2 + 0.00517755681818202*G0_0_1_8_3 - 0.004437905844156*G0_0_1_8_4 - 0.000739650974026003*G0_0_1_8_5 - 0.010355113636364*G0_0_1_8_6 - 0.00147930194805204*G0_0_1_8_7 + 0.0118344155844161*G0_0_1_8_8 - 0.011834415584416*G0_0_1_8_9 + 0.00690340909090935*G0_0_1_9_0 + 0.00690340909090933*G0_0_1_9_1 - 0.0246550324675333*G0_0_1_9_2 - 0.0192309253246759*G0_0_1_9_3 + 0.0739650974025999*G0_0_1_9_4 - 0.019230925324676*G0_0_1_9_5 + 0.0739650974025998*G0_0_1_9_6 - 0.0118344155844159*G0_0_1_9_7 - 0.011834415584416*G0_0_1_9_8 + 0.142012987012992*G0_0_1_9_9 - 0.00171672077922087*G0_1_0_0_0 + 0.000127840909090911*G0_1_0_0_1 + 0.00904017857142893*G0_1_0_0_2 - 0.00205458603896113*G0_1_0_0_3 - 0.00180803571428576*G0_1_0_0_4 - 0.000904017857142925*G0_1_0_0_5 + 0.00673904220779247*G0_1_0_0_6 + 0.000493100649350676*G0_1_0_0_8 - 0.00690340909090935*G0_1_0_0_9 + 0.000127840909090911*G0_1_0_1_0 - 0.00171672077922087*G0_1_0_1_1 + 0.00904017857142891*G0_1_0_1_2 - 0.000904017857142903*G0_1_0_1_3 + 0.00673904220779247*G0_1_0_1_4 - 0.00205458603896112*G0_1_0_1_5 - 0.00180803571428575*G0_1_0_1_6 + 0.000493100649350673*G0_1_0_1_7 - 0.00690340909090933*G0_1_0_1_9 + 0.00904017857142894*G0_1_0_2_0 + 0.00904017857142891*G0_1_0_2_1 + 0.161627435064941*G0_1_0_2_2 - 0.0394480519480533*G0_1_0_2_3 + 0.0912236201298733*G0_1_0_2_4 - 0.0394480519480534*G0_1_0_2_5 + 0.0912236201298735*G0_1_0_2_6 - 0.00328733766233778*G0_1_0_2_7 - 0.00328733766233777*G0_1_0_2_8 + 0.0246550324675333*G0_1_0_2_9 - 0.00205458603896113*G0_1_0_3_0 - 0.000904017857142903*G0_1_0_3_1 - 0.0394480519480533*G0_1_0_3_2 + 0.00147930194805194*G0_1_0_3_3 - 0.0369825487013001*G0_1_0_3_4 + 0.00887581168831202*G0_1_0_3_5 + 0.000739650974026029*G0_1_0_3_7 - 0.00517755681818202*G0_1_0_3_8 + 0.0192309253246759*G0_1_0_3_9 - 0.00180803571428577*G0_1_0_4_0 + 0.00673904220779247*G0_1_0_4_1 + 0.0912236201298733*G0_1_0_4_2 - 0.0369825487013001*G0_1_0_4_3 + 0.010355113636364*G0_1_0_4_7 + 0.004437905844156*G0_1_0_4_8 - 0.0739650974025999*G0_1_0_4_9 - 0.000904017857142926*G0_1_0_5_0 - 0.00205458603896112*G0_1_0_5_1 - 0.0394480519480534*G0_1_0_5_2 + 0.00887581168831202*G0_1_0_5_3 + 0.00147930194805206*G0_1_0_5_5 - 0.0369825487013*G0_1_0_5_6 - 0.00517755681818203*G0_1_0_5_7 + 0.000739650974026003*G0_1_0_5_8 + 0.019230925324676*G0_1_0_5_9 + 0.00673904220779247*G0_1_0_6_0 - 0.00180803571428575*G0_1_0_6_1 + 0.0912236201298735*G0_1_0_6_2 - 0.0369825487013*G0_1_0_6_5 + 0.004437905844156*G0_1_0_6_7 + 0.010355113636364*G0_1_0_6_8 - 0.0739650974025998*G0_1_0_6_9 + 0.000493100649350673*G0_1_0_7_1 - 0.00328733766233778*G0_1_0_7_2 + 0.000739650974026029*G0_1_0_7_3 + 0.010355113636364*G0_1_0_7_4 - 0.00517755681818203*G0_1_0_7_5 + 0.004437905844156*G0_1_0_7_6 - 0.0118344155844162*G0_1_0_7_7 + 0.00147930194805204*G0_1_0_7_8 + 0.0118344155844159*G0_1_0_7_9 + 0.000493100649350677*G0_1_0_8_0 - 0.00328733766233777*G0_1_0_8_2 - 0.00517755681818202*G0_1_0_8_3 + 0.004437905844156*G0_1_0_8_4 + 0.000739650974026003*G0_1_0_8_5 + 0.010355113636364*G0_1_0_8_6 + 0.00147930194805204*G0_1_0_8_7 - 0.0118344155844161*G0_1_0_8_8 + 0.011834415584416*G0_1_0_8_9 - 0.00690340909090935*G0_1_0_9_0 - 0.00690340909090933*G0_1_0_9_1 + 0.0246550324675333*G0_1_0_9_2 + 0.0192309253246759*G0_1_0_9_3 - 0.0739650974025999*G0_1_0_9_4 + 0.019230925324676*G0_1_0_9_5 - 0.0739650974025998*G0_1_0_9_6 + 0.0118344155844159*G0_1_0_9_7 + 0.011834415584416*G0_1_0_9_8 - 0.142012987012992*G0_1_0_9_9;
    A[83] = A[46] + 0.00622767857142884*G0_0_0_0_0 + 0.000803571428571468*G0_0_0_0_1 + 0.0152952516233772*G0_0_0_0_2 - 0.0199705762987021*G0_0_0_0_3 + 0.0308187905844168*G0_0_0_0_4 - 0.0124918831168836*G0_0_0_0_5 + 0.0318871753246766*G0_0_0_0_6 - 0.000739650974025977*G0_0_0_0_7 - 0.00641030844155869*G0_0_0_0_8 + 0.011834415584416*G0_0_0_0_9 + 0.000803571428571468*G0_0_0_1_0 - 0.0216964285714293*G0_0_0_1_1 + 0.0115239448051953*G0_0_0_1_2 - 0.0535836038961058*G0_0_0_1_3 + 0.0507071834415603*G0_0_0_1_4 - 0.00838271103896137*G0_0_0_1_5 + 0.0295860389610401*G0_0_0_1_6 + 0.00698559253246779*G0_0_0_1_7 - 0.0213676948051956*G0_0_0_1_8 + 0.00542410714285734*G0_0_0_1_9 + 0.0152952516233772*G0_0_0_2_0 + 0.0115239448051953*G0_0_0_2_1 + 0.223812905844164*G0_0_0_2_2 - 0.0779099025974053*G0_0_0_2_3 + 0.152861201298707*G0_0_0_2_4 - 0.0685409902597428*G0_0_0_2_5 + 0.150395698051954*G0_0_0_2_6 + 0.000493100649350666*G0_0_0_2_7 - 0.00567065746753267*G0_0_0_2_8 + 0.0256412337662347*G0_0_0_2_9 - 0.0199705762987021*G0_0_0_3_0 - 0.0535836038961058*G0_0_0_3_1 - 0.0779099025974053*G0_0_0_3_2 - 0.158285308441564*G0_0_0_3_3 - 0.105030438311692*G0_0_0_3_4 + 0.053254870129872*G0_0_0_3_5 - 0.110207995129874*G0_0_0_3_6 + 0.0384618506493521*G0_0_0_3_7 - 0.0340239448051961*G0_0_0_3_8 - 0.0931960227272761*G0_0_0_3_9 + 0.0308187905844168*G0_0_0_4_0 + 0.0507071834415603*G0_0_0_4_1 + 0.152861201298707*G0_0_0_4_2 - 0.105030438311692*G0_0_0_4_3 + 0.418642451298716*G0_0_0_4_4 - 0.113906250000004*G0_0_0_4_5 + 0.224114245129878*G0_0_0_4_6 - 0.036242897727274*G0_0_0_4_7 - 0.00443790584415596*G0_0_0_4_8 + 0.150888798701304*G0_0_0_4_9 - 0.0124918831168836*G0_0_0_5_0 - 0.00838271103896137*G0_0_0_5_1 - 0.0685409902597428*G0_0_0_5_2 + 0.053254870129872*G0_0_0_5_3 - 0.113906250000004*G0_0_0_5_4 + 0.121302759740264*G0_0_0_5_5 - 0.150149147727278*G0_0_0_5_6 + 0.019230925324676*G0_0_0_5_7 + 0.00369825487013*G0_0_0_5_8 - 0.042899756493508*G0_0_0_5_9 + 0.0318871753246766*G0_0_0_6_0 + 0.0295860389610401*G0_0_0_6_1 + 0.150395698051954*G0_0_0_6_2 - 0.110207995129874*G0_0_0_6_3 + 0.224114245129878*G0_0_0_6_4 - 0.150149147727278*G0_0_0_6_5 + 0.479293831168848*G0_0_0_6_6 - 0.022929180194806*G0_0_0_6_7 - 0.025148133116884*G0_0_0_6_8 + 0.143492288961044*G0_0_0_6_9 - 0.000739650974025978*G0_0_0_7_0 + 0.00698559253246779*G0_0_0_7_1 + 0.000493100649350666*G0_0_0_7_2 + 0.0384618506493521*G0_0_0_7_3 - 0.036242897727274*G0_0_0_7_4 + 0.019230925324676*G0_0_0_7_5 - 0.022929180194806*G0_0_0_7_6 + 0.011834415584416*G0_0_0_7_7 + 0.017751623376624*G0_0_0_7_8 + 0.0103551136363641*G0_0_0_7_9 - 0.00641030844155869*G0_0_0_8_0 - 0.0213676948051956*G0_0_0_8_1 - 0.00567065746753267*G0_0_0_8_2 - 0.0340239448051961*G0_0_0_8_3 - 0.00443790584415596*G0_0_0_8_4 + 0.00369825487013*G0_0_0_8_5 - 0.025148133116884*G0_0_0_8_6 + 0.017751623376624*G0_0_0_8_7 - 0.00739650974026008*G0_0_0_8_8 - 0.00739650974026011*G0_0_0_8_9 + 0.011834415584416*G0_0_0_9_0 + 0.00542410714285734*G0_0_0_9_1 + 0.0256412337662347*G0_0_0_9_2 - 0.0931960227272761*G0_0_0_9_3 + 0.150888798701304*G0_0_0_9_4 - 0.042899756493508*G0_0_0_9_5 + 0.143492288961044*G0_0_0_9_6 + 0.0103551136363641*G0_0_0_9_7 - 0.0073965097402601*G0_0_0_9_8 + 0.284025974025983*G0_0_0_9_9 - 0.00981635551948091*G0_0_1_0_1 + 0.00981635551948092*G0_0_1_0_2 - 0.0224360795454554*G0_0_1_0_3 + 0.0224360795454554*G0_0_1_0_4 - 0.00509537337662362*G0_0_1_0_5 + 0.0175872564935072*G0_0_1_0_6 + 0.00509537337662355*G0_0_1_0_7 - 0.0175872564935072*G0_0_1_0_8 - 0.00981635551948091*G0_0_1_1_0 - 0.190464691558448*G0_0_1_1_1 - 0.138972199675329*G0_0_1_1_3 + 0.0807041396103924*G0_0_1_1_4 - 0.00320515422077936*G0_0_1_1_5 + 0.012574066558442*G0_0_1_1_6 + 0.0483238636363654*G0_0_1_1_7 - 0.1109476461039*G0_0_1_1_8 - 0.0226826298701307*G0_0_1_1_9 + 0.00981635551948092*G0_0_1_2_0 + 0.190464691558448*G0_0_1_2_2 - 0.0807041396103924*G0_0_1_2_3 + 0.13897219967533*G0_0_1_2_4 - 0.0483238636363654*G0_0_1_2_5 + 0.1109476461039*G0_0_1_2_6 + 0.00320515422077934*G0_0_1_2_7 - 0.012574066558442*G0_0_1_2_8 + 0.0226826298701307*G0_0_1_2_9 - 0.0224360795454554*G0_0_1_3_0 - 0.138972199675329*G0_0_1_3_1 - 0.0807041396103924*G0_0_1_3_2 - 0.278108766233776*G0_0_1_3_3 + 0.038461850649352*G0_0_1_3_5 - 0.0377221996753261*G0_0_1_3_6 + 0.0673082386363661*G0_0_1_3_7 - 0.105030438311692*G0_0_1_3_8 - 0.0665685876623403*G0_0_1_3_9 + 0.0224360795454554*G0_0_1_4_0 + 0.0807041396103924*G0_0_1_4_1 + 0.13897219967533*G0_0_1_4_2 + 0.278108766233776*G0_0_1_4_4 - 0.0673082386363661*G0_0_1_4_5 + 0.105030438311692*G0_0_1_4_6 - 0.038461850649352*G0_0_1_4_7 + 0.0377221996753261*G0_0_1_4_8 + 0.0665685876623401*G0_0_1_4_9 - 0.00509537337662362*G0_0_1_5_0 - 0.00320515422077936*G0_0_1_5_1 - 0.0483238636363654*G0_0_1_5_2 + 0.038461850649352*G0_0_1_5_3 - 0.0673082386363661*G0_0_1_5_4 + 0.0310653409090921*G0_0_1_5_5 - 0.0806219561688341*G0_0_1_5_6 + 0.00961546266233801*G0_0_1_5_8 - 0.019230925324676*G0_0_1_5_9 + 0.0175872564935072*G0_0_1_6_0 + 0.012574066558442*G0_0_1_6_1 + 0.1109476461039*G0_0_1_6_2 - 0.0377221996753261*G0_0_1_6_3 + 0.105030438311692*G0_0_1_6_4 - 0.0806219561688341*G0_0_1_6_5 + 0.109468344155849*G0_0_1_6_6 - 0.00961546266233801*G0_0_1_6_7 + 0.00739650974026012*G0_0_1_6_9 + 0.00509537337662355*G0_0_1_7_0 + 0.0483238636363654*G0_0_1_7_1 + 0.00320515422077934*G0_0_1_7_2 + 0.0673082386363661*G0_0_1_7_3 - 0.038461850649352*G0_0_1_7_4 - 0.00961546266233801*G0_0_1_7_6 - 0.0310653409090921*G0_0_1_7_7 + 0.0806219561688342*G0_0_1_7_8 + 0.0192309253246761*G0_0_1_7_9 - 0.0175872564935072*G0_0_1_8_0 - 0.1109476461039*G0_0_1_8_1 - 0.012574066558442*G0_0_1_8_2 - 0.105030438311692*G0_0_1_8_3 + 0.0377221996753261*G0_0_1_8_4 + 0.00961546266233801*G0_0_1_8_5 + 0.0806219561688342*G0_0_1_8_7 - 0.109468344155848*G0_0_1_8_8 - 0.00739650974026014*G0_0_1_8_9 - 0.0226826298701307*G0_0_1_9_1 + 0.0226826298701307*G0_0_1_9_2 - 0.0665685876623403*G0_0_1_9_3 + 0.0665685876623401*G0_0_1_9_4 - 0.019230925324676*G0_0_1_9_5 + 0.00739650974026012*G0_0_1_9_6 + 0.0192309253246761*G0_0_1_9_7 - 0.00739650974026014*G0_0_1_9_8 - 0.000904017857142889*G0_1_0_0_1 + 0.000904017857142908*G0_1_0_0_2 - 0.0221895292207801*G0_1_0_0_3 + 0.0221895292207801*G0_1_0_0_4 - 0.00419135551948068*G0_1_0_0_5 + 0.0113413149350654*G0_1_0_0_6 + 0.00419135551948068*G0_1_0_0_7 - 0.0113413149350654*G0_1_0_0_8 - 0.000904017857142889*G0_1_0_1_0 - 0.0271205357142866*G0_1_0_1_1 - 0.0468445616883133*G0_1_0_1_3 + 0.0345170454545467*G0_1_0_1_4 - 0.00443790584415601*G0_1_0_1_5 + 0.01109476461039*G0_1_0_1_6 + 0.00838271103896135*G0_1_0_1_7 - 0.0197240259740267*G0_1_0_1_8 + 0.00887581168831197*G0_1_0_1_9 + 0.000904017857142907*G0_1_0_2_0 + 0.0271205357142868*G0_1_0_2_2 - 0.0345170454545467*G0_1_0_2_3 + 0.0468445616883134*G0_1_0_2_4 - 0.00838271103896138*G0_1_0_2_5 + 0.0197240259740268*G0_1_0_2_6 + 0.00443790584415599*G0_1_0_2_7 - 0.01109476461039*G0_1_0_2_8 - 0.00887581168831196*G0_1_0_2_9 - 0.0221895292207801*G0_1_0_3_0 - 0.0468445616883133*G0_1_0_3_1 - 0.0345170454545467*G0_1_0_3_2 - 0.279588068181828*G0_1_0_3_3 + 0.039941152597404*G0_1_0_3_5 - 0.03328429383117*G0_1_0_3_6 + 0.06656858766234*G0_1_0_3_7 - 0.0998528814935101*G0_1_0_3_8 - 0.159764610389616*G0_1_0_3_9 + 0.0221895292207801*G0_1_0_4_0 + 0.0345170454545467*G0_1_0_4_1 + 0.0468445616883134*G0_1_0_4_2 + 0.279588068181828*G0_1_0_4_4 - 0.0665685876623401*G0_1_0_4_5 + 0.0998528814935101*G0_1_0_4_6 - 0.039941152597404*G0_1_0_4_7 + 0.03328429383117*G0_1_0_4_8 + 0.159764610389616*G0_1_0_4_9 - 0.00419135551948068*G0_1_0_5_0 - 0.00443790584415601*G0_1_0_5_1 - 0.00838271103896138*G0_1_0_5_2 + 0.039941152597404*G0_1_0_5_3 - 0.0665685876623401*G0_1_0_5_4 + 0.017751623376624*G0_1_0_5_5 - 0.0421601055194821*G0_1_0_5_6 + 0.013313717532468*G0_1_0_5_8 - 0.026627435064936*G0_1_0_5_9 + 0.0113413149350654*G0_1_0_6_0 + 0.01109476461039*G0_1_0_6_1 + 0.0197240259740268*G0_1_0_6_2 - 0.03328429383117*G0_1_0_6_3 + 0.0998528814935101*G0_1_0_6_4 - 0.0421601055194821*G0_1_0_6_5 + 0.0976339285714322*G0_1_0_6_6 - 0.013313717532468*G0_1_0_6_7 + 0.093196022727276*G0_1_0_6_9 + 0.00419135551948068*G0_1_0_7_0 + 0.00838271103896135*G0_1_0_7_1 + 0.00443790584415599*G0_1_0_7_2 + 0.0665685876623401*G0_1_0_7_3 - 0.039941152597404*G0_1_0_7_4 - 0.013313717532468*G0_1_0_7_6 - 0.017751623376624*G0_1_0_7_7 + 0.042160105519482*G0_1_0_7_8 + 0.026627435064936*G0_1_0_7_9 - 0.0113413149350654*G0_1_0_8_0 - 0.0197240259740267*G0_1_0_8_1 - 0.01109476461039*G0_1_0_8_2 - 0.0998528814935101*G0_1_0_8_3 + 0.03328429383117*G0_1_0_8_4 + 0.013313717532468*G0_1_0_8_5 + 0.042160105519482*G0_1_0_8_7 - 0.0976339285714319*G0_1_0_8_8 - 0.093196022727276*G0_1_0_8_9 + 0.00887581168831197*G0_1_0_9_1 - 0.00887581168831195*G0_1_0_9_2 - 0.159764610389616*G0_1_0_9_3 + 0.159764610389616*G0_1_0_9_4 - 0.026627435064936*G0_1_0_9_5 + 0.093196022727276*G0_1_0_9_6 + 0.026627435064936*G0_1_0_9_7 - 0.093196022727276*G0_1_0_9_8 - 0.00622767857142885*G0_1_1_0_0 - 0.0152952516233772*G0_1_1_0_1 - 0.000803571428571448*G0_1_1_0_2 - 0.0308187905844168*G0_1_1_0_3 + 0.0199705762987021*G0_1_1_0_4 + 0.00073965097402597*G0_1_1_0_5 + 0.00641030844155869*G0_1_1_0_6 + 0.0124918831168836*G0_1_1_0_7 - 0.0318871753246765*G0_1_1_0_8 - 0.0118344155844161*G0_1_1_0_9 - 0.0152952516233772*G0_1_1_1_0 - 0.223812905844164*G0_1_1_1_1 - 0.0115239448051952*G0_1_1_1_2 - 0.152861201298707*G0_1_1_1_3 + 0.0779099025974053*G0_1_1_1_4 - 0.000493100649350668*G0_1_1_1_5 + 0.00567065746753269*G0_1_1_1_6 + 0.0685409902597428*G0_1_1_1_7 - 0.150395698051954*G0_1_1_1_8 - 0.0256412337662348*G0_1_1_1_9 - 0.000803571428571448*G0_1_1_2_0 - 0.0115239448051952*G0_1_1_2_1 + 0.0216964285714294*G0_1_1_2_2 - 0.0507071834415602*G0_1_1_2_3 + 0.0535836038961058*G0_1_1_2_4 - 0.00698559253246781*G0_1_1_2_5 + 0.0213676948051956*G0_1_1_2_6 + 0.00838271103896133*G0_1_1_2_7 - 0.02958603896104*G0_1_1_2_8 - 0.00542410714285733*G0_1_1_2_9 - 0.0308187905844168*G0_1_1_3_0 - 0.152861201298707*G0_1_1_3_1 - 0.0507071834415602*G0_1_1_3_2 - 0.418642451298716*G0_1_1_3_3 + 0.105030438311692*G0_1_1_3_4 + 0.036242897727274*G0_1_1_3_5 + 0.00443790584415597*G0_1_1_3_6 + 0.113906250000004*G0_1_1_3_7 - 0.224114245129878*G0_1_1_3_8 - 0.150888798701304*G0_1_1_3_9 + 0.0199705762987021*G0_1_1_4_0 + 0.0779099025974053*G0_1_1_4_1 + 0.0535836038961058*G0_1_1_4_2 + 0.105030438311692*G0_1_1_4_3 + 0.158285308441564*G0_1_1_4_4 - 0.038461850649352*G0_1_1_4_5 + 0.0340239448051961*G0_1_1_4_6 - 0.053254870129872*G0_1_1_4_7 + 0.110207995129874*G0_1_1_4_8 + 0.0931960227272761*G0_1_1_4_9 + 0.00073965097402597*G0_1_1_5_0 - 0.000493100649350668*G0_1_1_5_1 - 0.00698559253246781*G0_1_1_5_2 + 0.036242897727274*G0_1_1_5_3 - 0.038461850649352*G0_1_1_5_4 - 0.0118344155844159*G0_1_1_5_5 - 0.017751623376624*G0_1_1_5_6 - 0.019230925324676*G0_1_1_5_7 + 0.022929180194806*G0_1_1_5_8 - 0.0103551136363639*G0_1_1_5_9 + 0.00641030844155869*G0_1_1_6_0 + 0.00567065746753269*G0_1_1_6_1 + 0.0213676948051956*G0_1_1_6_2 + 0.00443790584415597*G0_1_1_6_3 + 0.0340239448051961*G0_1_1_6_4 - 0.017751623376624*G0_1_1_6_5 + 0.00739650974026017*G0_1_1_6_6 - 0.00369825487013*G0_1_1_6_7 + 0.0251481331168839*G0_1_1_6_8 + 0.00739650974026007*G0_1_1_6_9 + 0.0124918831168836*G0_1_1_7_0 + 0.0685409902597428*G0_1_1_7_1 + 0.00838271103896133*G0_1_1_7_2 + 0.113906250000004*G0_1_1_7_3 - 0.053254870129872*G0_1_1_7_4 - 0.019230925324676*G0_1_1_7_5 - 0.00369825487013*G0_1_1_7_6 - 0.121302759740264*G0_1_1_7_7 + 0.150149147727278*G0_1_1_7_8 + 0.042899756493508*G0_1_1_7_9 - 0.0318871753246765*G0_1_1_8_0 - 0.150395698051954*G0_1_1_8_1 - 0.02958603896104*G0_1_1_8_2 - 0.224114245129878*G0_1_1_8_3 + 0.110207995129874*G0_1_1_8_4 + 0.022929180194806*G0_1_1_8_5 + 0.025148133116884*G0_1_1_8_6 + 0.150149147727278*G0_1_1_8_7 - 0.479293831168848*G0_1_1_8_8 - 0.143492288961044*G0_1_1_8_9 - 0.0118344155844161*G0_1_1_9_0 - 0.0256412337662348*G0_1_1_9_1 - 0.00542410714285733*G0_1_1_9_2 - 0.150888798701304*G0_1_1_9_3 + 0.0931960227272761*G0_1_1_9_4 - 0.0103551136363639*G0_1_1_9_5 + 0.00739650974026006*G0_1_1_9_6 + 0.042899756493508*G0_1_1_9_7 - 0.143492288961044*G0_1_1_9_8 - 0.284025974025984*G0_1_1_9_9;
    A[56] = A[65] + 0.00164366883116885*G0_0_1_0_0 + 0.00136972402597407*G0_0_1_0_1 - 0.000493100649350661*G0_0_1_0_2 - 0.00172585227272732*G0_0_1_0_3 - 0.00024655032467533*G0_0_1_0_4 + 0.0135602678571433*G0_0_1_0_5 + 0.00295860389610396*G0_0_1_0_6 + 0.00616375811688329*G0_0_1_0_7 - 0.00443790584415597*G0_0_1_0_8 + 0.0113413149350653*G0_0_1_0_9 + 0.00136972402597407*G0_0_1_1_0 - 0.00202719155844163*G0_0_1_1_1 + 0.00136972402597408*G0_0_1_1_2 + 0.00517755681818199*G0_0_1_1_3 - 0.00320515422077932*G0_0_1_1_4 - 0.0120809659090913*G0_0_1_1_5 - 0.0120809659090913*G0_0_1_1_6 - 0.00320515422077934*G0_0_1_1_7 + 0.005177556818182*G0_0_1_1_8 - 0.0226826298701307*G0_0_1_1_9 - 0.000493100649350661*G0_0_1_2_0 + 0.00136972402597408*G0_0_1_2_1 + 0.00164366883116891*G0_0_1_2_2 - 0.00443790584415601*G0_0_1_2_3 + 0.00616375811688337*G0_0_1_2_4 + 0.00295860389610397*G0_0_1_2_5 + 0.0135602678571433*G0_0_1_2_6 - 0.00024655032467534*G0_0_1_2_7 - 0.00172585227272732*G0_0_1_2_8 + 0.0113413149350653*G0_0_1_2_9 - 0.00172585227272732*G0_0_1_3_0 + 0.00517755681818199*G0_0_1_3_1 - 0.00443790584415601*G0_0_1_3_2 - 0.00887581168831189*G0_0_1_3_3 + 0.00887581168831193*G0_0_1_3_4 + 0.0207102272727279*G0_0_1_3_5 + 0.0362428977272738*G0_0_1_3_6 + 0.00517755681818199*G0_0_1_3_7 - 0.010355113636364*G0_0_1_3_8 + 0.0576927759740279*G0_0_1_3_9 - 0.000246550324675332*G0_0_1_4_0 - 0.00320515422077932*G0_0_1_4_1 + 0.00616375811688337*G0_0_1_4_2 + 0.00887581168831191*G0_0_1_4_3 + 0.000739650974026018*G0_0_1_4_5 - 0.0369825487012999*G0_0_1_4_6 + 0.000739650974025996*G0_0_1_4_7 + 0.00517755681818197*G0_0_1_4_8 - 0.0355032467532478*G0_0_1_4_9 + 0.0135602678571433*G0_0_1_5_0 - 0.0120809659090913*G0_0_1_5_1 + 0.00295860389610397*G0_0_1_5_2 + 0.0207102272727279*G0_0_1_5_3 + 0.000739650974026014*G0_0_1_5_4 - 0.2218952922078*G0_0_1_5_5 - 0.0221895292207799*G0_0_1_5_6 - 0.0369825487013*G0_0_1_5_7 + 0.036242897727274*G0_0_1_5_8 - 0.106509740259744*G0_0_1_5_9 + 0.00295860389610396*G0_0_1_6_0 - 0.0120809659090913*G0_0_1_6_1 + 0.0135602678571433*G0_0_1_6_2 + 0.0362428977272739*G0_0_1_6_3 - 0.0369825487012999*G0_0_1_6_4 - 0.02218952922078*G0_0_1_6_5 - 0.2218952922078*G0_0_1_6_6 + 0.000739650974025989*G0_0_1_6_7 + 0.0207102272727279*G0_0_1_6_8 - 0.106509740259744*G0_0_1_6_9 + 0.00616375811688329*G0_0_1_7_0 - 0.00320515422077934*G0_0_1_7_1 - 0.00024655032467534*G0_0_1_7_2 + 0.00517755681818199*G0_0_1_7_3 + 0.000739650974025996*G0_0_1_7_4 - 0.0369825487013*G0_0_1_7_5 + 0.000739650974025989*G0_0_1_7_6 + 0.00887581168831203*G0_0_1_7_8 - 0.035503246753248*G0_0_1_7_9 - 0.00443790584415597*G0_0_1_8_0 + 0.00517755681818201*G0_0_1_8_1 - 0.00172585227272732*G0_0_1_8_2 - 0.010355113636364*G0_0_1_8_3 + 0.00517755681818197*G0_0_1_8_4 + 0.036242897727274*G0_0_1_8_5 + 0.0207102272727279*G0_0_1_8_6 + 0.00887581168831203*G0_0_1_8_7 - 0.00887581168831198*G0_0_1_8_8 + 0.057692775974028*G0_0_1_8_9 + 0.0113413149350653*G0_0_1_9_0 - 0.0226826298701307*G0_0_1_9_1 + 0.0113413149350653*G0_0_1_9_2 + 0.0576927759740279*G0_0_1_9_3 - 0.0355032467532478*G0_0_1_9_4 - 0.106509740259744*G0_0_1_9_5 - 0.106509740259744*G0_0_1_9_6 - 0.035503246753248*G0_0_1_9_7 + 0.057692775974028*G0_0_1_9_8 - 0.319529220779232*G0_0_1_9_9 - 0.00164366883116885*G0_1_0_0_0 - 0.00136972402597407*G0_1_0_0_1 + 0.000493100649350661*G0_1_0_0_2 + 0.00172585227272732*G0_1_0_0_3 + 0.00024655032467533*G0_1_0_0_4 - 0.0135602678571433*G0_1_0_0_5 - 0.00295860389610396*G0_1_0_0_6 - 0.00616375811688329*G0_1_0_0_7 + 0.00443790584415597*G0_1_0_0_8 - 0.0113413149350653*G0_1_0_0_9 - 0.00136972402597407*G0_1_0_1_0 + 0.00202719155844163*G0_1_0_1_1 - 0.00136972402597408*G0_1_0_1_2 - 0.00517755681818199*G0_1_0_1_3 + 0.00320515422077932*G0_1_0_1_4 + 0.0120809659090913*G0_1_0_1_5 + 0.0120809659090913*G0_1_0_1_6 + 0.00320515422077934*G0_1_0_1_7 - 0.00517755681818201*G0_1_0_1_8 + 0.0226826298701307*G0_1_0_1_9 + 0.000493100649350661*G0_1_0_2_0 - 0.00136972402597408*G0_1_0_2_1 - 0.00164366883116891*G0_1_0_2_2 + 0.00443790584415601*G0_1_0_2_3 - 0.00616375811688337*G0_1_0_2_4 - 0.00295860389610397*G0_1_0_2_5 - 0.0135602678571433*G0_1_0_2_6 + 0.00024655032467534*G0_1_0_2_7 + 0.00172585227272732*G0_1_0_2_8 - 0.0113413149350653*G0_1_0_2_9 + 0.00172585227272732*G0_1_0_3_0 - 0.00517755681818199*G0_1_0_3_1 + 0.00443790584415601*G0_1_0_3_2 + 0.00887581168831189*G0_1_0_3_3 - 0.00887581168831193*G0_1_0_3_4 - 0.0207102272727279*G0_1_0_3_5 - 0.0362428977272738*G0_1_0_3_6 - 0.00517755681818199*G0_1_0_3_7 + 0.010355113636364*G0_1_0_3_8 - 0.0576927759740279*G0_1_0_3_9 + 0.000246550324675332*G0_1_0_4_0 + 0.00320515422077932*G0_1_0_4_1 - 0.00616375811688337*G0_1_0_4_2 - 0.00887581168831193*G0_1_0_4_3 - 0.000739650974026018*G0_1_0_4_5 + 0.0369825487012999*G0_1_0_4_6 - 0.000739650974025996*G0_1_0_4_7 - 0.00517755681818197*G0_1_0_4_8 + 0.0355032467532478*G0_1_0_4_9 - 0.0135602678571433*G0_1_0_5_0 + 0.0120809659090913*G0_1_0_5_1 - 0.00295860389610396*G0_1_0_5_2 - 0.0207102272727279*G0_1_0_5_3 - 0.000739650974026014*G0_1_0_5_4 + 0.2218952922078*G0_1_0_5_5 + 0.0221895292207799*G0_1_0_5_6 + 0.0369825487013*G0_1_0_5_7 - 0.036242897727274*G0_1_0_5_8 + 0.106509740259744*G0_1_0_5_9 - 0.00295860389610396*G0_1_0_6_0 + 0.0120809659090913*G0_1_0_6_1 - 0.0135602678571433*G0_1_0_6_2 - 0.0362428977272739*G0_1_0_6_3 + 0.0369825487012999*G0_1_0_6_4 + 0.0221895292207799*G0_1_0_6_5 + 0.2218952922078*G0_1_0_6_6 - 0.00073965097402599*G0_1_0_6_7 - 0.0207102272727279*G0_1_0_6_8 + 0.106509740259744*G0_1_0_6_9 - 0.00616375811688329*G0_1_0_7_0 + 0.00320515422077934*G0_1_0_7_1 + 0.00024655032467534*G0_1_0_7_2 - 0.00517755681818199*G0_1_0_7_3 - 0.000739650974025995*G0_1_0_7_4 + 0.0369825487013*G0_1_0_7_5 - 0.00073965097402599*G0_1_0_7_6 - 0.00887581168831202*G0_1_0_7_8 + 0.035503246753248*G0_1_0_7_9 + 0.00443790584415597*G0_1_0_8_0 - 0.005177556818182*G0_1_0_8_1 + 0.00172585227272732*G0_1_0_8_2 + 0.010355113636364*G0_1_0_8_3 - 0.00517755681818197*G0_1_0_8_4 - 0.036242897727274*G0_1_0_8_5 - 0.0207102272727279*G0_1_0_8_6 - 0.00887581168831202*G0_1_0_8_7 + 0.00887581168831198*G0_1_0_8_8 - 0.057692775974028*G0_1_0_8_9 - 0.0113413149350653*G0_1_0_9_0 + 0.0226826298701307*G0_1_0_9_1 - 0.0113413149350653*G0_1_0_9_2 - 0.0576927759740279*G0_1_0_9_3 + 0.0355032467532478*G0_1_0_9_4 + 0.106509740259744*G0_1_0_9_5 + 0.106509740259744*G0_1_0_9_6 + 0.0355032467532481*G0_1_0_9_7 - 0.057692775974028*G0_1_0_9_8 + 0.319529220779232*G0_1_0_9_9;
    A[77] = A[55] + 0.16162743506494*G0_0_0_0_0 + 0.0114326298701303*G0_0_0_0_1 + 0.00664772727272748*G0_0_0_0_2 - 0.000328733766233759*G0_0_0_0_3 - 0.00624594155844182*G0_0_0_0_4 + 0.110125811688315*G0_0_0_0_5 - 0.0378043831168844*G0_0_0_0_6 + 0.072321428571431*G0_0_0_0_7 - 0.0410917207792221*G0_0_0_0_8 + 0.0246550324675333*G0_0_0_0_9 + 0.0114326298701303*G0_0_0_1_0 + 0.038242694805196*G0_0_0_1_1 + 0.000127840909090897*G0_0_0_1_2 + 0.0361607142857155*G0_0_0_1_3 - 0.0190665584415591*G0_0_0_1_4 - 0.00969764610389642*G0_0_0_1_5 - 0.0106838474025978*G0_0_0_1_6 - 0.00953327922077957*G0_0_0_1_7 + 0.00871144480519514*G0_0_0_1_8 - 0.0276136363636373*G0_0_0_1_9 + 0.00664772727272748*G0_0_0_2_0 + 0.000127840909090897*G0_0_0_2_1 - 0.0416761363636378*G0_0_0_2_2 + 0.0200527597402604*G0_0_0_2_3 - 0.0361607142857155*G0_0_0_2_4 + 0.0230113636363644*G0_0_0_2_5 - 0.0105194805194809*G0_0_0_2_6 + 0.00608157467532487*G0_0_0_2_7 + 0.00657467532467555*G0_0_0_2_8 + 0.0138068181818186*G0_0_0_2_9 - 0.00032873376623376*G0_0_0_3_0 + 0.0361607142857155*G0_0_0_3_1 + 0.0200527597402604*G0_0_0_3_2 + 0.0887581168831199*G0_0_0_3_3 + 0.00147930194805203*G0_0_0_3_4 + 0.0177516233766239*G0_0_0_3_5 + 0.0266274350649359*G0_0_0_3_6 - 0.00443790584415604*G0_0_0_3_7 + 0.02958603896104*G0_0_0_3_8 + 0.0917167207792239*G0_0_0_3_9 - 0.00624594155844182*G0_0_0_4_0 - 0.0190665584415591*G0_0_0_4_1 - 0.0361607142857155*G0_0_0_4_2 + 0.00147930194805202*G0_0_0_4_3 - 0.112426948051952*G0_0_0_4_4 + 0.013313717532468*G0_0_0_4_5 - 0.039941152597404*G0_0_0_4_6 + 0.002958603896104*G0_0_0_4_7 - 0.025148133116884*G0_0_0_4_8 - 0.0680478896103918*G0_0_0_4_9 + 0.110125811688315*G0_0_0_5_0 - 0.00969764610389642*G0_0_0_5_1 + 0.0230113636363644*G0_0_0_5_2 + 0.0177516233766239*G0_0_0_5_3 + 0.013313717532468*G0_0_0_5_4 - 0.10355113636364*G0_0_0_5_5 - 0.0798823051948078*G0_0_0_5_6 + 0.0236688311688319*G0_0_0_5_8 - 0.121302759740264*G0_0_0_5_9 - 0.0378043831168844*G0_0_0_6_0 - 0.0106838474025978*G0_0_0_6_1 - 0.0105194805194809*G0_0_0_6_2 + 0.0266274350649359*G0_0_0_6_3 - 0.039941152597404*G0_0_0_6_4 - 0.0798823051948078*G0_0_0_6_5 - 0.136095779220784*G0_0_0_6_6 - 0.0236688311688319*G0_0_0_6_7 + 0.00887581168831197*G0_0_0_6_8 - 0.0946753246753279*G0_0_0_6_9 + 0.072321428571431*G0_0_0_7_0 - 0.00953327922077957*G0_0_0_7_1 + 0.00608157467532487*G0_0_0_7_2 - 0.00443790584415604*G0_0_0_7_3 + 0.002958603896104*G0_0_0_7_4 - 0.0236688311688319*G0_0_0_7_6 + 0.10355113636364*G0_0_0_7_7 + 0.00591720779220799*G0_0_0_7_8 - 0.026627435064936*G0_0_0_7_9 - 0.0410917207792221*G0_0_0_8_0 + 0.00871144480519514*G0_0_0_8_1 + 0.00657467532467555*G0_0_0_8_2 + 0.02958603896104*G0_0_0_8_3 - 0.025148133116884*G0_0_0_8_4 + 0.023668831168832*G0_0_0_8_5 + 0.00887581168831197*G0_0_0_8_6 + 0.00591720779220799*G0_0_0_8_7 + 0.139054383116888*G0_0_0_8_8 + 0.13313717532468*G0_0_0_8_9 + 0.0246550324675333*G0_0_0_9_0 - 0.0276136363636373*G0_0_0_9_1 + 0.0138068181818186*G0_0_0_9_2 + 0.0917167207792239*G0_0_0_9_3 - 0.0680478896103918*G0_0_0_9_4 - 0.121302759740264*G0_0_0_9_5 - 0.0946753246753278*G0_0_0_9_6 - 0.026627435064936*G0_0_0_9_7 + 0.13313717532468*G0_0_0_9_8 - 0.142012987012992*G0_0_0_9_9 + 0.00239245129870138*G0_0_1_0_1 - 0.00239245129870139*G0_0_1_0_2 + 0.00295860389610404*G0_0_1_0_3 - 0.00295860389610403*G0_0_1_0_4 + 0.0189021915584422*G0_0_1_0_5 + 0.00164366883116883*G0_0_1_0_6 - 0.0189021915584422*G0_0_1_0_7 - 0.00164366883116885*G0_0_1_0_8 + 0.00239245129870138*G0_0_1_1_0 + 0.0399594155844169*G0_0_1_1_1 + 0.0361607142857155*G0_0_1_1_3 - 0.0195596590909097*G0_0_1_1_4 - 0.00788961038961064*G0_0_1_1_5 - 0.00862926136363669*G0_0_1_1_6 - 0.016272321428572*G0_0_1_1_7 + 0.00961546266233801*G0_0_1_1_8 - 0.020710227272728*G0_0_1_1_9 - 0.00239245129870139*G0_0_1_2_0 - 0.039959415584417*G0_0_1_2_2 + 0.0195596590909097*G0_0_1_2_3 - 0.0361607142857155*G0_0_1_2_4 + 0.016272321428572*G0_0_1_2_5 - 0.00961546266233806*G0_0_1_2_6 + 0.00788961038961067*G0_0_1_2_7 + 0.00862926136363665*G0_0_1_2_8 + 0.020710227272728*G0_0_1_2_9 + 0.00295860389610404*G0_0_1_3_0 + 0.0361607142857155*G0_0_1_3_1 + 0.0195596590909098*G0_0_1_3_2 + 0.100592532467536*G0_0_1_3_3 + 0.00739650974025993*G0_0_1_3_5 + 0.0258877840909099*G0_0_1_3_6 - 0.00887581168831206*G0_0_1_3_7 + 0.034763595779222*G0_0_1_3_8 + 0.0798823051948079*G0_0_1_3_9 - 0.00295860389610403*G0_0_1_4_0 - 0.0195596590909097*G0_0_1_4_1 - 0.0361607142857155*G0_0_1_4_2 - 0.100592532467536*G0_0_1_4_4 + 0.00887581168831203*G0_0_1_4_5 - 0.034763595779222*G0_0_1_4_6 - 0.00739650974026001*G0_0_1_4_7 - 0.02588778409091*G0_0_1_4_8 - 0.0798823051948079*G0_0_1_4_9 + 0.0189021915584422*G0_0_1_5_0 - 0.00788961038961064*G0_0_1_5_1 + 0.016272321428572*G0_0_1_5_2 + 0.00739650974025993*G0_0_1_5_3 + 0.00887581168831203*G0_0_1_5_4 - 0.10355113636364*G0_0_1_5_5 - 0.0428997564935079*G0_0_1_5_6 + 0.0236688311688319*G0_0_1_5_8 - 0.0473376623376638*G0_0_1_5_9 + 0.00164366883116883*G0_0_1_6_0 - 0.00862926136363669*G0_0_1_6_1 - 0.00961546266233806*G0_0_1_6_2 + 0.0258877840909099*G0_0_1_6_3 - 0.034763595779222*G0_0_1_6_4 - 0.0428997564935079*G0_0_1_6_5 - 0.137575081168836*G0_0_1_6_6 - 0.023668831168832*G0_0_1_6_7 - 0.113906250000004*G0_0_1_6_9 - 0.0189021915584422*G0_0_1_7_0 - 0.016272321428572*G0_0_1_7_1 + 0.00788961038961067*G0_0_1_7_2 - 0.00887581168831206*G0_0_1_7_3 - 0.00739650974026001*G0_0_1_7_4 - 0.023668831168832*G0_0_1_7_6 + 0.10355113636364*G0_0_1_7_7 + 0.0428997564935079*G0_0_1_7_8 + 0.0473376623376641*G0_0_1_7_9 - 0.00164366883116885*G0_0_1_8_0 + 0.00961546266233801*G0_0_1_8_1 + 0.00862926136363665*G0_0_1_8_2 + 0.034763595779222*G0_0_1_8_3 - 0.02588778409091*G0_0_1_8_4 + 0.0236688311688319*G0_0_1_8_5 + 0.0428997564935079*G0_0_1_8_7 + 0.137575081168836*G0_0_1_8_8 + 0.113906250000004*G0_0_1_8_9 - 0.020710227272728*G0_0_1_9_1 + 0.020710227272728*G0_0_1_9_2 + 0.0798823051948079*G0_0_1_9_3 - 0.0798823051948079*G0_0_1_9_4 - 0.0473376623376638*G0_0_1_9_5 - 0.113906250000004*G0_0_1_9_6 + 0.0473376623376641*G0_0_1_9_7 + 0.113906250000004*G0_0_1_9_8 + 0.00239245129870138*G0_1_0_0_1 - 0.00239245129870139*G0_1_0_0_2 + 0.00295860389610404*G0_1_0_0_3 - 0.00295860389610403*G0_1_0_0_4 + 0.0189021915584422*G0_1_0_0_5 + 0.00164366883116883*G0_1_0_0_6 - 0.0189021915584422*G0_1_0_0_7 - 0.00164366883116885*G0_1_0_0_8 + 0.00239245129870138*G0_1_0_1_0 + 0.0399594155844169*G0_1_0_1_1 + 0.0361607142857155*G0_1_0_1_3 - 0.0195596590909097*G0_1_0_1_4 - 0.00788961038961064*G0_1_0_1_5 - 0.00862926136363668*G0_1_0_1_6 - 0.016272321428572*G0_1_0_1_7 + 0.00961546266233801*G0_1_0_1_8 - 0.020710227272728*G0_1_0_1_9 - 0.00239245129870139*G0_1_0_2_0 - 0.039959415584417*G0_1_0_2_2 + 0.0195596590909097*G0_1_0_2_3 - 0.0361607142857155*G0_1_0_2_4 + 0.016272321428572*G0_1_0_2_5 - 0.00961546266233806*G0_1_0_2_6 + 0.00788961038961067*G0_1_0_2_7 + 0.00862926136363665*G0_1_0_2_8 + 0.020710227272728*G0_1_0_2_9 + 0.00295860389610404*G0_1_0_3_0 + 0.0361607142857155*G0_1_0_3_1 + 0.0195596590909098*G0_1_0_3_2 + 0.100592532467536*G0_1_0_3_3 + 0.00739650974025993*G0_1_0_3_5 + 0.0258877840909099*G0_1_0_3_6 - 0.00887581168831205*G0_1_0_3_7 + 0.034763595779222*G0_1_0_3_8 + 0.0798823051948079*G0_1_0_3_9 - 0.00295860389610403*G0_1_0_4_0 - 0.0195596590909097*G0_1_0_4_1 - 0.0361607142857155*G0_1_0_4_2 - 0.100592532467536*G0_1_0_4_4 + 0.00887581168831203*G0_1_0_4_5 - 0.034763595779222*G0_1_0_4_6 - 0.00739650974026001*G0_1_0_4_7 - 0.02588778409091*G0_1_0_4_8 - 0.0798823051948079*G0_1_0_4_9 + 0.0189021915584422*G0_1_0_5_0 - 0.00788961038961064*G0_1_0_5_1 + 0.016272321428572*G0_1_0_5_2 + 0.00739650974025993*G0_1_0_5_3 + 0.00887581168831203*G0_1_0_5_4 - 0.10355113636364*G0_1_0_5_5 - 0.0428997564935079*G0_1_0_5_6 + 0.0236688311688319*G0_1_0_5_8 - 0.0473376623376638*G0_1_0_5_9 + 0.00164366883116883*G0_1_0_6_0 - 0.00862926136363668*G0_1_0_6_1 - 0.00961546266233806*G0_1_0_6_2 + 0.0258877840909099*G0_1_0_6_3 - 0.034763595779222*G0_1_0_6_4 - 0.0428997564935079*G0_1_0_6_5 - 0.137575081168836*G0_1_0_6_6 - 0.023668831168832*G0_1_0_6_7 - 0.113906250000004*G0_1_0_6_9 - 0.0189021915584422*G0_1_0_7_0 - 0.016272321428572*G0_1_0_7_1 + 0.00788961038961067*G0_1_0_7_2 - 0.00887581168831206*G0_1_0_7_3 - 0.00739650974026001*G0_1_0_7_4 - 0.023668831168832*G0_1_0_7_6 + 0.10355113636364*G0_1_0_7_7 + 0.0428997564935079*G0_1_0_7_8 + 0.0473376623376641*G0_1_0_7_9 - 0.00164366883116885*G0_1_0_8_0 + 0.00961546266233801*G0_1_0_8_1 + 0.00862926136363665*G0_1_0_8_2 + 0.034763595779222*G0_1_0_8_3 - 0.02588778409091*G0_1_0_8_4 + 0.0236688311688319*G0_1_0_8_5 + 0.0428997564935079*G0_1_0_8_7 + 0.137575081168836*G0_1_0_8_8 + 0.113906250000004*G0_1_0_8_9 - 0.020710227272728*G0_1_0_9_1 + 0.020710227272728*G0_1_0_9_2 + 0.0798823051948079*G0_1_0_9_3 - 0.0798823051948079*G0_1_0_9_4 - 0.0473376623376638*G0_1_0_9_5 - 0.113906250000004*G0_1_0_9_6 + 0.0473376623376641*G0_1_0_9_7 + 0.113906250000004*G0_1_0_9_8 - 0.161627435064941*G0_1_1_0_0 - 0.00664772727272751*G0_1_1_0_1 - 0.0114326298701303*G0_1_1_0_2 + 0.00624594155844184*G0_1_1_0_3 + 0.000328733766233751*G0_1_1_0_4 - 0.072321428571431*G0_1_1_0_5 + 0.0410917207792221*G0_1_1_0_6 - 0.110125811688315*G0_1_1_0_7 + 0.0378043831168845*G0_1_1_0_8 - 0.0246550324675334*G0_1_1_0_9 - 0.00664772727272751*G0_1_1_1_0 + 0.0416761363636377*G0_1_1_1_1 - 0.000127840909090926*G0_1_1_1_2 + 0.0361607142857155*G0_1_1_1_3 - 0.0200527597402604*G0_1_1_1_4 - 0.00608157467532487*G0_1_1_1_5 - 0.00657467532467558*G0_1_1_1_6 - 0.0230113636363644*G0_1_1_1_7 + 0.0105194805194809*G0_1_1_1_8 - 0.0138068181818186*G0_1_1_1_9 - 0.0114326298701303*G0_1_1_2_0 - 0.000127840909090926*G0_1_1_2_1 - 0.0382426948051961*G0_1_1_2_2 + 0.0190665584415591*G0_1_1_2_3 - 0.0361607142857155*G0_1_1_2_4 + 0.00953327922077957*G0_1_1_2_5 - 0.00871144480519516*G0_1_1_2_6 + 0.00969764610389646*G0_1_1_2_7 + 0.0106838474025978*G0_1_1_2_8 + 0.0276136363636373*G0_1_1_2_9 + 0.00624594155844184*G0_1_1_3_0 + 0.0361607142857155*G0_1_1_3_1 + 0.0190665584415591*G0_1_1_3_2 + 0.112426948051952*G0_1_1_3_3 - 0.00147930194805193*G0_1_1_3_4 - 0.00295860389610405*G0_1_1_3_5 + 0.0251481331168839*G0_1_1_3_6 - 0.0133137175324681*G0_1_1_3_7 + 0.039941152597404*G0_1_1_3_8 + 0.0680478896103919*G0_1_1_3_9 + 0.000328733766233751*G0_1_1_4_0 - 0.0200527597402604*G0_1_1_4_1 - 0.0361607142857155*G0_1_1_4_2 - 0.00147930194805193*G0_1_1_4_3 - 0.0887581168831201*G0_1_1_4_4 + 0.00443790584415604*G0_1_1_4_5 - 0.02958603896104*G0_1_1_4_6 - 0.017751623376624*G0_1_1_4_7 - 0.026627435064936*G0_1_1_4_8 - 0.091716720779224*G0_1_1_4_9 - 0.072321428571431*G0_1_1_5_0 - 0.00608157467532487*G0_1_1_5_1 + 0.00953327922077957*G0_1_1_5_2 - 0.00295860389610404*G0_1_1_5_3 + 0.00443790584415604*G0_1_1_5_4 - 0.10355113636364*G0_1_1_5_5 - 0.00591720779220799*G0_1_1_5_6 + 0.0236688311688319*G0_1_1_5_8 + 0.0266274350649361*G0_1_1_5_9 + 0.0410917207792221*G0_1_1_6_0 - 0.00657467532467558*G0_1_1_6_1 - 0.00871144480519516*G0_1_1_6_2 + 0.025148133116884*G0_1_1_6_3 - 0.02958603896104*G0_1_1_6_4 - 0.00591720779220799*G0_1_1_6_5 - 0.139054383116888*G0_1_1_6_6 - 0.0236688311688321*G0_1_1_6_7 - 0.00887581168831197*G0_1_1_6_8 - 0.13313717532468*G0_1_1_6_9 - 0.110125811688315*G0_1_1_7_0 - 0.0230113636363644*G0_1_1_7_1 + 0.00969764610389647*G0_1_1_7_2 - 0.0133137175324681*G0_1_1_7_3 - 0.017751623376624*G0_1_1_7_4 - 0.0236688311688321*G0_1_1_7_6 + 0.10355113636364*G0_1_1_7_7 + 0.0798823051948079*G0_1_1_7_8 + 0.121302759740264*G0_1_1_7_9 + 0.0378043831168844*G0_1_1_8_0 + 0.0105194805194809*G0_1_1_8_1 + 0.0106838474025978*G0_1_1_8_2 + 0.039941152597404*G0_1_1_8_3 - 0.026627435064936*G0_1_1_8_4 + 0.0236688311688319*G0_1_1_8_5 - 0.00887581168831197*G0_1_1_8_6 + 0.0798823051948078*G0_1_1_8_7 + 0.136095779220784*G0_1_1_8_8 + 0.0946753246753279*G0_1_1_8_9 - 0.0246550324675334*G0_1_1_9_0 - 0.0138068181818186*G0_1_1_9_1 + 0.0276136363636373*G0_1_1_9_2 + 0.0680478896103919*G0_1_1_9_3 - 0.091716720779224*G0_1_1_9_4 + 0.0266274350649361*G0_1_1_9_5 - 0.13313717532468*G0_1_1_9_6 + 0.121302759740264*G0_1_1_9_7 + 0.0946753246753279*G0_1_1_9_8 + 0.142012987012992*G0_1_1_9_9;
    A[3] = A[30] - 0.000566152597402628*G0_0_1_0_1 - 0.000447443181818206*G0_0_1_0_2 + 0.00101359577922082*G0_0_1_0_4 - 0.00223721590909103*G0_0_1_0_5 + 0.000693993506493553*G0_0_1_0_6 + 0.00223721590909093*G0_0_1_0_7 - 0.0008583603896104*G0_0_1_0_8 + 0.000164366883116878*G0_0_1_0_9 - 0.000566152597402628*G0_0_1_1_0 - 0.0164671266233772*G0_0_1_1_1 - 0.00109882305194809*G0_0_1_1_2 - 0.011131290584416*G0_0_1_1_3 + 0.00366172889610402*G0_0_1_1_4 + 0.000219155844155847*G0_0_1_1_5 + 0.00027394480519482*G0_0_1_1_6 + 0.00373478084415598*G0_0_1_1_7 - 0.00599025974025998*G0_0_1_1_8 - 0.00109577922077927*G0_0_1_1_9 - 0.000447443181818206*G0_0_1_2_0 - 0.00109882305194809*G0_0_1_2_1 - 0.0069764610389613*G0_0_1_2_2 - 0.000949675324675355*G0_0_1_2_3 - 0.00292207792207803*G0_0_1_2_4 + 0.000675730519480543*G0_0_1_2_5 - 0.00225547889610399*G0_0_1_2_6 + 0.000794439935064958*G0_0_1_2_7 - 0.000164366883116888*G0_0_1_2_8 - 0.000383522727272746*G0_0_1_2_9 - 0.011131290584416*G0_0_1_3_1 - 0.000949675324675355*G0_0_1_3_2 + 0.0120809659090913*G0_0_1_3_4 - 0.000657467532467553*G0_0_1_3_5 - 0.000164366883116883*G0_0_1_3_6 + 0.000657467532467573*G0_0_1_3_7 - 0.00180803571428581*G0_0_1_3_8 + 0.00197240259740265*G0_0_1_3_9 + 0.00101359577922082*G0_0_1_4_0 + 0.00366172889610402*G0_0_1_4_1 - 0.00292207792207804*G0_0_1_4_2 + 0.0120809659090913*G0_0_1_4_3 + 0.0241619318181827*G0_0_1_4_4 - 0.00238331980519488*G0_0_1_4_5 + 0.00254768668831178*G0_0_1_4_6 - 0.00304078733766245*G0_0_1_4_7 + 0.00115056818181823*G0_0_1_4_8 + 0.00591720779220802*G0_0_1_4_9 - 0.00223721590909103*G0_0_1_5_0 + 0.000219155844155847*G0_0_1_5_1 + 0.000675730519480544*G0_0_1_5_2 - 0.000657467532467553*G0_0_1_5_3 - 0.00238331980519488*G0_0_1_5_4 - 0.0144642857142863*G0_0_1_5_5 + 0.00254768668831181*G0_0_1_5_6 + 0.00172585227272728*G0_0_1_5_7 - 0.000493100649350691*G0_0_1_5_9 + 0.000693993506493553*G0_0_1_6_0 + 0.00027394480519482*G0_0_1_6_1 - 0.00225547889610399*G0_0_1_6_2 - 0.000164366883116883*G0_0_1_6_3 + 0.00254768668831178*G0_0_1_6_4 + 0.00254768668831181*G0_0_1_6_5 + 0.0121631493506498*G0_0_1_6_6 - 0.0017258522727273*G0_0_1_6_7 - 0.000493100649350678*G0_0_1_6_8 + 0.00147930194805202*G0_0_1_6_9 + 0.00223721590909093*G0_0_1_7_0 + 0.00373478084415598*G0_0_1_7_1 + 0.000794439935064958*G0_0_1_7_2 + 0.000657467532467573*G0_0_1_7_3 - 0.00304078733766245*G0_0_1_7_4 + 0.00172585227272728*G0_0_1_7_5 - 0.00172585227272731*G0_0_1_7_6 + 0.0110125811688314*G0_0_1_7_7 - 0.00328733766233771*G0_0_1_7_8 + 0.00295860389610398*G0_0_1_7_9 - 0.0008583603896104*G0_0_1_8_0 - 0.00599025974025998*G0_0_1_8_1 - 0.000164366883116888*G0_0_1_8_2 - 0.00180803571428581*G0_0_1_8_3 + 0.00115056818181823*G0_0_1_8_4 - 0.000493100649350678*G0_0_1_8_6 - 0.00328733766233771*G0_0_1_8_7 + 0.0134780844155848*G0_0_1_8_8 + 0.000986201298701334*G0_0_1_8_9 + 0.000164366883116878*G0_0_1_9_0 - 0.00109577922077927*G0_0_1_9_1 - 0.000383522727272746*G0_0_1_9_2 + 0.00197240259740265*G0_0_1_9_3 + 0.00591720779220802*G0_0_1_9_4 - 0.000493100649350691*G0_0_1_9_5 + 0.00147930194805202*G0_0_1_9_6 + 0.00295860389610398*G0_0_1_9_7 + 0.000986201298701333*G0_0_1_9_8 - 0.0295860389610399*G0_0_1_9_9 + 0.000566152597402628*G0_1_0_0_1 + 0.000447443181818206*G0_1_0_0_2 - 0.00101359577922082*G0_1_0_0_4 + 0.00223721590909103*G0_1_0_0_5 - 0.000693993506493554*G0_1_0_0_6 - 0.00223721590909093*G0_1_0_0_7 + 0.0008583603896104*G0_1_0_0_8 - 0.000164366883116878*G0_1_0_0_9 + 0.000566152597402628*G0_1_0_1_0 + 0.0164671266233772*G0_1_0_1_1 + 0.00109882305194809*G0_1_0_1_2 + 0.011131290584416*G0_1_0_1_3 - 0.00366172889610402*G0_1_0_1_4 - 0.000219155844155847*G0_1_0_1_5 - 0.00027394480519482*G0_1_0_1_6 - 0.00373478084415598*G0_1_0_1_7 + 0.00599025974025998*G0_1_0_1_8 + 0.00109577922077927*G0_1_0_1_9 + 0.000447443181818206*G0_1_0_2_0 + 0.00109882305194809*G0_1_0_2_1 + 0.0069764610389613*G0_1_0_2_2 + 0.000949675324675355*G0_1_0_2_3 + 0.00292207792207803*G0_1_0_2_4 - 0.000675730519480543*G0_1_0_2_5 + 0.00225547889610399*G0_1_0_2_6 - 0.000794439935064957*G0_1_0_2_7 + 0.000164366883116889*G0_1_0_2_8 + 0.000383522727272747*G0_1_0_2_9 + 0.011131290584416*G0_1_0_3_1 + 0.000949675324675355*G0_1_0_3_2 - 0.0120809659090913*G0_1_0_3_4 + 0.000657467532467552*G0_1_0_3_5 + 0.000164366883116883*G0_1_0_3_6 - 0.000657467532467574*G0_1_0_3_7 + 0.00180803571428581*G0_1_0_3_8 - 0.00197240259740265*G0_1_0_3_9 - 0.00101359577922082*G0_1_0_4_0 - 0.00366172889610402*G0_1_0_4_1 + 0.00292207792207803*G0_1_0_4_2 - 0.0120809659090913*G0_1_0_4_3 - 0.0241619318181827*G0_1_0_4_4 + 0.00238331980519488*G0_1_0_4_5 - 0.00254768668831178*G0_1_0_4_6 + 0.00304078733766245*G0_1_0_4_7 - 0.00115056818181823*G0_1_0_4_8 - 0.00591720779220802*G0_1_0_4_9 + 0.00223721590909103*G0_1_0_5_0 - 0.000219155844155847*G0_1_0_5_1 - 0.000675730519480543*G0_1_0_5_2 + 0.000657467532467552*G0_1_0_5_3 + 0.00238331980519488*G0_1_0_5_4 + 0.0144642857142863*G0_1_0_5_5 - 0.00254768668831181*G0_1_0_5_6 - 0.00172585227272728*G0_1_0_5_7 + 0.00049310064935069*G0_1_0_5_9 - 0.000693993506493554*G0_1_0_6_0 - 0.00027394480519482*G0_1_0_6_1 + 0.00225547889610399*G0_1_0_6_2 + 0.000164366883116883*G0_1_0_6_3 - 0.00254768668831178*G0_1_0_6_4 - 0.00254768668831181*G0_1_0_6_5 - 0.0121631493506498*G0_1_0_6_6 + 0.00172585227272731*G0_1_0_6_7 + 0.000493100649350677*G0_1_0_6_8 - 0.00147930194805202*G0_1_0_6_9 - 0.00223721590909093*G0_1_0_7_0 - 0.00373478084415598*G0_1_0_7_1 - 0.000794439935064957*G0_1_0_7_2 - 0.000657467532467574*G0_1_0_7_3 + 0.00304078733766245*G0_1_0_7_4 - 0.00172585227272728*G0_1_0_7_5 + 0.0017258522727273*G0_1_0_7_6 - 0.0110125811688314*G0_1_0_7_7 + 0.00328733766233771*G0_1_0_7_8 - 0.00295860389610398*G0_1_0_7_9 + 0.0008583603896104*G0_1_0_8_0 + 0.00599025974025998*G0_1_0_8_1 + 0.000164366883116888*G0_1_0_8_2 + 0.00180803571428581*G0_1_0_8_3 - 0.00115056818181823*G0_1_0_8_4 + 0.000493100649350677*G0_1_0_8_6 + 0.00328733766233771*G0_1_0_8_7 - 0.0134780844155848*G0_1_0_8_8 - 0.000986201298701334*G0_1_0_8_9 - 0.000164366883116878*G0_1_0_9_0 + 0.00109577922077927*G0_1_0_9_1 + 0.000383522727272747*G0_1_0_9_2 - 0.00197240259740265*G0_1_0_9_3 - 0.00591720779220802*G0_1_0_9_4 + 0.000493100649350691*G0_1_0_9_5 - 0.00147930194805202*G0_1_0_9_6 - 0.00295860389610398*G0_1_0_9_7 - 0.000986201298701331*G0_1_0_9_8 + 0.0295860389610399*G0_1_0_9_9;
    A[8] = -A[3] + 0.0525974025974044*G0_0_0_0_0 + 0.00307426948051959*G0_0_0_0_1 + 0.00393567370129884*G0_0_0_0_2 - 0.000858360389610423*G0_0_0_0_3 - 0.00170758928571435*G0_0_0_0_4 + 0.0389458198051961*G0_0_0_0_5 - 0.0165827922077928*G0_0_0_0_6 + 0.0196783685064942*G0_0_0_0_7 - 0.0100994318181822*G0_0_0_0_8 + 0.0047666396103898*G0_0_0_0_9 + 0.00307426948051959*G0_0_0_1_0 + 0.0154017857142862*G0_0_0_1_1 + 0.00106534090909095*G0_0_0_1_2 + 0.00904017857142887*G0_0_0_1_3 - 0.00249289772727281*G0_0_0_1_4 + 0.00346996753246765*G0_0_0_1_5 - 0.00146103896103901*G0_0_0_1_6 - 0.00167106331168838*G0_0_0_1_7 + 0.00246550324675336*G0_0_0_1_8 - 0.000767045454545472*G0_0_0_1_9 + 0.00393567370129884*G0_0_0_2_0 + 0.00106534090909095*G0_0_0_2_1 + 0.00787134740259769*G0_0_0_2_2 + 0.00124188311688315*G0_0_0_2_3 + 0.00241984577922088*G0_0_0_2_4 + 0.0054423701298703*G0_0_0_2_5 - 0.000173498376623357*G0_0_0_2_6 + 0.000757913961038985*G0_0_0_2_7 + 0.00111404220779224*G0_0_0_2_8 + 0.00378043831168844*G0_0_0_2_9 - 0.000858360389610423*G0_0_0_3_0 + 0.00904017857142887*G0_0_0_3_1 + 0.00124188311688315*G0_0_0_3_2 - 0.00361607142857158*G0_0_0_3_3 - 0.0134780844155849*G0_0_0_3_4 - 0.00197240259740266*G0_0_0_3_5 + 0.000493100649350658*G0_0_0_3_6 - 0.00131493506493511*G0_0_0_3_7 + 0.00854707792207822*G0_0_0_3_8 + 0.00493100649350666*G0_0_0_3_9 - 0.00170758928571435*G0_0_0_4_0 - 0.00249289772727281*G0_0_0_4_1 + 0.00241984577922088*G0_0_0_4_2 - 0.0134780844155849*G0_0_0_4_3 - 0.0238331980519489*G0_0_0_4_4 + 0.00123275162337665*G0_0_0_4_5 - 0.00172585227272732*G0_0_0_4_6 + 0.00336952110389622*G0_0_0_4_7 - 0.0072321428571431*G0_0_0_4_8 - 0.0138068181818187*G0_0_0_4_9 + 0.0389458198051961*G0_0_0_5_0 + 0.00346996753246765*G0_0_0_5_1 + 0.00544237012987031*G0_0_0_5_2 - 0.00197240259740266*G0_0_0_5_3 + 0.00123275162337665*G0_0_0_5_4 + 0.105687905844159*G0_0_0_5_5 - 0.0316406250000011*G0_0_0_5_6 + 0.0204636769480526*G0_0_0_5_7 - 0.0142999188311693*G0_0_0_5_8 + 0.0142999188311694*G0_0_0_5_9 - 0.0165827922077928*G0_0_0_6_0 - 0.00146103896103901*G0_0_0_6_1 - 0.000173498376623357*G0_0_0_6_2 + 0.000493100649350658*G0_0_0_6_3 - 0.00172585227272732*G0_0_0_6_4 - 0.0316406250000011*G0_0_0_6_5 - 0.00821834415584443*G0_0_0_6_6 - 0.00616375811688332*G0_0_0_6_7 + 0.00246550324675334*G0_0_0_6_8 - 0.0123275162337667*G0_0_0_6_9 + 0.0196783685064942*G0_0_0_7_0 - 0.00167106331168838*G0_0_0_7_1 + 0.000757913961038985*G0_0_0_7_2 - 0.00131493506493511*G0_0_0_7_3 + 0.00336952110389622*G0_0_0_7_4 + 0.0204636769480526*G0_0_0_7_5 - 0.00616375811688332*G0_0_0_7_6 - 0.0134780844155849*G0_0_0_7_7 - 0.00460227272727289*G0_0_0_7_8 - 0.00197240259740267*G0_0_0_7_9 - 0.0100994318181822*G0_0_0_8_0 + 0.00246550324675335*G0_0_0_8_1 + 0.00111404220779224*G0_0_0_8_2 + 0.00854707792207822*G0_0_0_8_3 - 0.0072321428571431*G0_0_0_8_4 - 0.0142999188311693*G0_0_0_8_5 + 0.00246550324675334*G0_0_0_8_6 - 0.00460227272727289*G0_0_0_8_7 + 0.0259699675324685*G0_0_0_8_8 + 0.0167654220779226*G0_0_0_8_9 + 0.0047666396103898*G0_0_0_9_0 - 0.000767045454545472*G0_0_0_9_1 + 0.00378043831168844*G0_0_0_9_2 + 0.00493100649350666*G0_0_0_9_3 - 0.0138068181818187*G0_0_0_9_4 + 0.0142999188311694*G0_0_0_9_5 - 0.0123275162337667*G0_0_0_9_6 - 0.00197240259740267*G0_0_0_9_7 + 0.0167654220779226*G0_0_0_9_8 + 0.0867857142857172*G0_0_0_9_9 + 0.0525974025974044*G0_1_0_0_0 + 0.00307426948051959*G0_1_0_0_1 + 0.00393567370129884*G0_1_0_0_2 - 0.000858360389610424*G0_1_0_0_3 - 0.00170758928571435*G0_1_0_0_4 + 0.0389458198051961*G0_1_0_0_5 - 0.0165827922077928*G0_1_0_0_6 + 0.0196783685064942*G0_1_0_0_7 - 0.0100994318181822*G0_1_0_0_8 + 0.0047666396103898*G0_1_0_0_9 + 0.00307426948051959*G0_1_0_1_0 + 0.0154017857142862*G0_1_0_1_1 + 0.00106534090909095*G0_1_0_1_2 + 0.00904017857142886*G0_1_0_1_3 - 0.0024928977272728*G0_1_0_1_4 + 0.00346996753246765*G0_1_0_1_5 - 0.00146103896103901*G0_1_0_1_6 - 0.00167106331168838*G0_1_0_1_7 + 0.00246550324675335*G0_1_0_1_8 - 0.000767045454545472*G0_1_0_1_9 + 0.00393567370129884*G0_1_0_2_0 + 0.00106534090909095*G0_1_0_2_1 + 0.00787134740259769*G0_1_0_2_2 + 0.00124188311688315*G0_1_0_2_3 + 0.00241984577922088*G0_1_0_2_4 + 0.0054423701298703*G0_1_0_2_5 - 0.000173498376623355*G0_1_0_2_6 + 0.000757913961038983*G0_1_0_2_7 + 0.00111404220779224*G0_1_0_2_8 + 0.00378043831168844*G0_1_0_2_9 - 0.000858360389610424*G0_1_0_3_0 + 0.00904017857142886*G0_1_0_3_1 + 0.00124188311688315*G0_1_0_3_2 - 0.00361607142857159*G0_1_0_3_3 - 0.0134780844155849*G0_1_0_3_4 - 0.00197240259740266*G0_1_0_3_5 + 0.00049310064935066*G0_1_0_3_6 - 0.00131493506493511*G0_1_0_3_7 + 0.00854707792207822*G0_1_0_3_8 + 0.00493100649350666*G0_1_0_3_9 - 0.00170758928571435*G0_1_0_4_0 - 0.0024928977272728*G0_1_0_4_1 + 0.00241984577922088*G0_1_0_4_2 - 0.0134780844155849*G0_1_0_4_3 - 0.0238331980519489*G0_1_0_4_4 + 0.00123275162337665*G0_1_0_4_5 - 0.00172585227272733*G0_1_0_4_6 + 0.00336952110389622*G0_1_0_4_7 - 0.0072321428571431*G0_1_0_4_8 - 0.0138068181818187*G0_1_0_4_9 + 0.0389458198051961*G0_1_0_5_0 + 0.00346996753246765*G0_1_0_5_1 + 0.00544237012987031*G0_1_0_5_2 - 0.00197240259740266*G0_1_0_5_3 + 0.00123275162337665*G0_1_0_5_4 + 0.105687905844159*G0_1_0_5_5 - 0.0316406250000011*G0_1_0_5_6 + 0.0204636769480526*G0_1_0_5_7 - 0.0142999188311693*G0_1_0_5_8 + 0.0142999188311693*G0_1_0_5_9 - 0.0165827922077928*G0_1_0_6_0 - 0.00146103896103901*G0_1_0_6_1 - 0.000173498376623355*G0_1_0_6_2 + 0.00049310064935066*G0_1_0_6_3 - 0.00172585227272733*G0_1_0_6_4 - 0.0316406250000011*G0_1_0_6_5 - 0.00821834415584445*G0_1_0_6_6 - 0.00616375811688332*G0_1_0_6_7 + 0.00246550324675334*G0_1_0_6_8 - 0.0123275162337667*G0_1_0_6_9 + 0.0196783685064942*G0_1_0_7_0 - 0.00167106331168838*G0_1_0_7_1 + 0.000757913961038984*G0_1_0_7_2 - 0.00131493506493511*G0_1_0_7_3 + 0.00336952110389622*G0_1_0_7_4 + 0.0204636769480526*G0_1_0_7_5 - 0.00616375811688332*G0_1_0_7_6 - 0.013478084415585*G0_1_0_7_7 - 0.00460227272727289*G0_1_0_7_8 - 0.00197240259740268*G0_1_0_7_9 - 0.0100994318181822*G0_1_0_8_0 + 0.00246550324675335*G0_1_0_8_1 + 0.00111404220779224*G0_1_0_8_2 + 0.00854707792207822*G0_1_0_8_3 - 0.0072321428571431*G0_1_0_8_4 - 0.0142999188311693*G0_1_0_8_5 + 0.00246550324675334*G0_1_0_8_6 - 0.00460227272727289*G0_1_0_8_7 + 0.0259699675324684*G0_1_0_8_8 + 0.0167654220779226*G0_1_0_8_9 + 0.0047666396103898*G0_1_0_9_0 - 0.000767045454545471*G0_1_0_9_1 + 0.00378043831168844*G0_1_0_9_2 + 0.00493100649350666*G0_1_0_9_3 - 0.0138068181818187*G0_1_0_9_4 + 0.0142999188311694*G0_1_0_9_5 - 0.0123275162337667*G0_1_0_9_6 - 0.00197240259740268*G0_1_0_9_7 + 0.0167654220779226*G0_1_0_9_8 + 0.0867857142857172*G0_1_0_9_9;
    A[12] = 0.0017038690476191*G0_0_1_0_0 + 0.000851934523809557*G0_0_1_0_1 + 0.000851934523809558*G0_0_1_0_2 - 9.13149350649613e-06*G0_0_1_0_3 - 9.13149350649181e-06*G0_0_1_0_4 + 2.43506493506454e-05*G0_0_1_0_5 + 0.00112317370129875*G0_0_1_0_6 + 2.43506493506471e-05*G0_0_1_0_7 + 0.00112317370129874*G0_0_1_0_8 + 0.000267857142857152*G0_0_1_0_9 + 0.000851934523809557*G0_0_1_1_0 + 0.011194534632035*G0_0_1_1_1 + 0.000970643939393975*G0_0_1_1_2 + 0.00375913149350661*G0_0_1_1_3 - 0.00193587662337668*G0_0_1_1_4 - 0.000447443181818199*G0_0_1_1_5 + 0.000566152597402622*G0_0_1_1_6 - 0.00348823051948065*G0_0_1_1_7 + 0.00823356331168861*G0_0_1_1_8 + 0.000980113636363673*G0_0_1_1_9 + 0.000851934523809558*G0_0_1_2_0 + 0.000970643939393974*G0_0_1_2_1 + 0.011194534632035*G0_0_1_2_2 - 0.0019358766233767*G0_0_1_2_3 + 0.00375913149350664*G0_0_1_2_4 - 0.00348823051948065*G0_0_1_2_5 + 0.00823356331168863*G0_0_1_2_6 - 0.000447443181818197*G0_0_1_2_7 + 0.000566152597402616*G0_0_1_2_8 + 0.000980113636363672*G0_0_1_2_9 - 9.13149350649615e-06*G0_0_1_3_0 + 0.00375913149350661*G0_0_1_3_1 - 0.0019358766233767*G0_0_1_3_2 - 0.00321428571428585*G0_0_1_3_3 - 0.000748782467532496*G0_0_1_3_4 + 0.00124188311688316*G0_0_1_3_5 - 0.0028125000000001*G0_0_1_3_6 - 0.00108664772727276*G0_0_1_3_7 + 0.00389914772727285*G0_0_1_3_8 - 0.000767045454545493*G0_0_1_3_9 - 9.13149350649179e-06*G0_0_1_4_0 - 0.00193587662337668*G0_0_1_4_1 + 0.00375913149350664*G0_0_1_4_2 - 0.000748782467532496*G0_0_1_4_3 - 0.00321428571428582*G0_0_1_4_4 - 0.00108664772727277*G0_0_1_4_5 + 0.00389914772727288*G0_0_1_4_6 + 0.00124188311688316*G0_0_1_4_7 - 0.00281250000000009*G0_0_1_4_8 - 0.000767045454545478*G0_0_1_4_9 + 2.43506493506454e-05*G0_0_1_5_0 - 0.000447443181818199*G0_0_1_5_1 - 0.00348823051948065*G0_0_1_5_2 + 0.00124188311688316*G0_0_1_5_3 - 0.00108664772727277*G0_0_1_5_4 - 0.0018993506493507*G0_0_1_5_5 - 0.00658380681818206*G0_0_1_5_6 - 0.000456574675324691*G0_0_1_5_7 + 0.000228287337662345*G0_0_1_5_8 - 0.00126014610389615*G0_0_1_5_9 + 0.00112317370129875*G0_0_1_6_0 + 0.000566152597402622*G0_0_1_6_1 + 0.00823356331168863*G0_0_1_6_2 - 0.0028125000000001*G0_0_1_6_3 + 0.00389914772727288*G0_0_1_6_4 - 0.00658380681818206*G0_0_1_6_5 + 0.022262581168832*G0_0_1_6_6 + 0.000228287337662345*G0_0_1_6_7 - 0.00114143668831172*G0_0_1_6_8 + 0.00268465909090919*G0_0_1_6_9 + 2.43506493506473e-05*G0_0_1_7_0 - 0.00348823051948065*G0_0_1_7_1 - 0.000447443181818197*G0_0_1_7_2 - 0.00108664772727276*G0_0_1_7_3 + 0.00124188311688316*G0_0_1_7_4 - 0.000456574675324691*G0_0_1_7_5 + 0.000228287337662345*G0_0_1_7_6 - 0.00189935064935072*G0_0_1_7_7 - 0.00658380681818205*G0_0_1_7_8 - 0.00126014610389614*G0_0_1_7_9 + 0.00112317370129874*G0_0_1_8_0 + 0.00823356331168861*G0_0_1_8_1 + 0.000566152597402616*G0_0_1_8_2 + 0.00389914772727285*G0_0_1_8_3 - 0.00281250000000009*G0_0_1_8_4 + 0.000228287337662345*G0_0_1_8_5 - 0.00114143668831172*G0_0_1_8_6 - 0.00658380681818205*G0_0_1_8_7 + 0.0222625811688319*G0_0_1_8_8 + 0.00268465909090917*G0_0_1_8_9 + 0.000267857142857152*G0_0_1_9_0 + 0.000980113636363673*G0_0_1_9_1 + 0.000980113636363672*G0_0_1_9_2 - 0.000767045454545493*G0_0_1_9_3 - 0.000767045454545478*G0_0_1_9_4 - 0.00126014610389615*G0_0_1_9_5 + 0.00268465909090919*G0_0_1_9_6 - 0.00126014610389614*G0_0_1_9_7 + 0.00268465909090917*G0_0_1_9_8 + 0.0105194805194809*G0_0_1_9_9;
    A[2] = -A[12] - 0.00949066558441591*G0_0_1_0_0 - 0.000118709415584418*G0_0_1_0_2 + 0.000438311688311705*G0_0_1_0_3 - 0.000575284090909114*G0_0_1_0_4 - 0.00373478084415597*G0_0_1_0_5 + 0.00305905032467543*G0_0_1_0_6 - 0.00820921266233794*G0_0_1_0_7 + 0.00461140422077938*G0_0_1_0_8 - 0.000712256493506522*G0_0_1_0_9 + 0.0094906655844159*G0_0_1_1_1 + 0.000118709415584419*G0_0_1_1_2 + 0.00373478084415597*G0_0_1_1_3 - 0.00305905032467543*G0_0_1_1_4 - 0.000438311688311703*G0_0_1_1_5 + 0.000575284090909113*G0_0_1_1_6 - 0.00461140422077938*G0_0_1_1_7 + 0.00820921266233796*G0_0_1_1_8 + 0.00071225649350652*G0_0_1_1_9 - 0.000118709415584418*G0_0_1_2_0 + 0.000118709415584419*G0_0_1_2_1 + 0.00155235389610395*G0_0_1_2_3 - 0.00447443181818197*G0_0_1_2_4 - 0.00155235389610395*G0_0_1_2_5 + 0.00447443181818198*G0_0_1_2_6 - 0.00101359577922081*G0_0_1_2_7 + 0.00101359577922081*G0_0_1_2_8 + 0.000438311688311705*G0_0_1_3_0 + 0.00373478084415597*G0_0_1_3_1 + 0.00155235389610395*G0_0_1_3_2 - 0.00131493506493514*G0_0_1_3_3 + 0.00583502435064956*G0_0_1_3_4 - 0.00172585227272733*G0_0_1_3_6 - 0.0013149350649351*G0_0_1_3_7 + 0.00435572240259754*G0_0_1_3_8 + 0.000493100649350655*G0_0_1_3_9 - 0.000575284090909114*G0_0_1_4_0 - 0.00305905032467543*G0_0_1_4_1 - 0.00447443181818197*G0_0_1_4_2 + 0.00583502435064956*G0_0_1_4_3 - 0.0254768668831178*G0_0_1_4_4 + 0.00172585227272733*G0_0_1_4_5 + 0.00238331980519489*G0_0_1_4_7 - 0.00304078733766243*G0_0_1_4_8 - 0.00345170454545467*G0_0_1_4_9 - 0.00373478084415597*G0_0_1_5_0 - 0.000438311688311703*G0_0_1_5_1 - 0.00155235389610395*G0_0_1_5_2 + 0.00172585227272733*G0_0_1_5_4 + 0.00131493506493512*G0_0_1_5_5 - 0.00583502435064956*G0_0_1_5_6 - 0.00435572240259754*G0_0_1_5_7 + 0.00131493506493511*G0_0_1_5_8 - 0.000493100649350661*G0_0_1_5_9 + 0.00305905032467543*G0_0_1_6_0 + 0.000575284090909113*G0_0_1_6_1 + 0.00447443181818198*G0_0_1_6_2 - 0.00172585227272733*G0_0_1_6_3 - 0.00583502435064956*G0_0_1_6_5 + 0.0254768668831178*G0_0_1_6_6 + 0.00304078733766244*G0_0_1_6_7 - 0.00238331980519488*G0_0_1_6_8 + 0.00345170454545466*G0_0_1_6_9 - 0.00820921266233794*G0_0_1_7_0 - 0.00461140422077939*G0_0_1_7_1 - 0.00101359577922081*G0_0_1_7_2 - 0.0013149350649351*G0_0_1_7_3 + 0.00238331980519489*G0_0_1_7_4 - 0.00435572240259754*G0_0_1_7_5 + 0.00304078733766244*G0_0_1_7_6 - 0.0241619318181826*G0_0_1_7_7 - 0.00394480519480533*G0_0_1_7_9 + 0.00461140422077938*G0_0_1_8_0 + 0.00820921266233796*G0_0_1_8_1 + 0.00101359577922081*G0_0_1_8_2 + 0.00435572240259754*G0_0_1_8_3 - 0.00304078733766243*G0_0_1_8_4 + 0.00131493506493511*G0_0_1_8_5 - 0.00238331980519488*G0_0_1_8_6 + 0.0241619318181826*G0_0_1_8_8 + 0.00394480519480532*G0_0_1_8_9 - 0.000712256493506522*G0_0_1_9_0 + 0.00071225649350652*G0_0_1_9_1 + 0.000493100649350656*G0_0_1_9_3 - 0.00345170454545467*G0_0_1_9_4 - 0.000493100649350661*G0_0_1_9_5 + 0.00345170454545466*G0_0_1_9_6 - 0.00394480519480533*G0_0_1_9_7 + 0.00394480519480532*G0_0_1_9_8 - 0.011194534632035*G0_1_1_0_0 - 0.000851934523809554*G0_1_1_0_1 - 0.000970643939393977*G0_1_1_0_2 + 0.000447443181818201*G0_1_1_0_3 - 0.000566152597402623*G0_1_1_0_4 - 0.00375913149350661*G0_1_1_0_5 + 0.00193587662337668*G0_1_1_0_6 - 0.00823356331168859*G0_1_1_0_7 + 0.00348823051948064*G0_1_1_0_8 - 0.000980113636363675*G0_1_1_0_9 - 0.000851934523809554*G0_1_1_1_0 - 0.0017038690476191*G0_1_1_1_1 - 0.000851934523809557*G0_1_1_1_2 - 0.00112317370129875*G0_1_1_1_4 - 0.00112317370129874*G0_1_1_1_7 - 0.000267857142857154*G0_1_1_1_9 - 0.000970643939393977*G0_1_1_2_0 - 0.000851934523809557*G0_1_1_2_1 - 0.011194534632035*G0_1_1_2_2 + 0.00348823051948065*G0_1_1_2_3 - 0.00823356331168862*G0_1_1_2_4 + 0.0019358766233767*G0_1_1_2_5 - 0.00375913149350665*G0_1_1_2_6 - 0.000566152597402615*G0_1_1_2_7 + 0.000447443181818196*G0_1_1_2_8 - 0.000980113636363674*G0_1_1_2_9 + 0.000447443181818201*G0_1_1_3_0 + 0.00348823051948065*G0_1_1_3_2 + 0.0018993506493507*G0_1_1_3_3 + 0.00658380681818206*G0_1_1_3_4 - 0.00124188311688316*G0_1_1_3_5 + 0.00108664772727278*G0_1_1_3_6 - 0.000228287337662342*G0_1_1_3_7 + 0.000456574675324685*G0_1_1_3_8 + 0.00126014610389615*G0_1_1_3_9 - 0.000566152597402623*G0_1_1_4_0 - 0.00112317370129875*G0_1_1_4_1 - 0.00823356331168862*G0_1_1_4_2 + 0.00658380681818206*G0_1_1_4_3 - 0.022262581168832*G0_1_1_4_4 + 0.00281250000000011*G0_1_1_4_5 - 0.00389914772727289*G0_1_1_4_6 + 0.00114143668831173*G0_1_1_4_7 - 0.000228287337662342*G0_1_1_4_8 - 0.00268465909090919*G0_1_1_4_9 - 0.00375913149350661*G0_1_1_5_0 + 0.0019358766233767*G0_1_1_5_2 - 0.00124188311688316*G0_1_1_5_3 + 0.00281250000000011*G0_1_1_5_4 + 0.00321428571428582*G0_1_1_5_5 + 0.000748782467532506*G0_1_1_5_6 - 0.00389914772727285*G0_1_1_5_7 + 0.00108664772727276*G0_1_1_5_8 + 0.000767045454545484*G0_1_1_5_9 + 0.00193587662337668*G0_1_1_6_0 - 0.00375913149350665*G0_1_1_6_2 + 0.00108664772727278*G0_1_1_6_3 - 0.00389914772727289*G0_1_1_6_4 + 0.000748782467532506*G0_1_1_6_5 + 0.00321428571428579*G0_1_1_6_6 + 0.00281250000000009*G0_1_1_6_7 - 0.00124188311688315*G0_1_1_6_8 + 0.000767045454545472*G0_1_1_6_9 - 0.00823356331168859*G0_1_1_7_0 - 0.00112317370129874*G0_1_1_7_1 - 0.000566152597402615*G0_1_1_7_2 - 0.000228287337662342*G0_1_1_7_3 + 0.00114143668831173*G0_1_1_7_4 - 0.00389914772727285*G0_1_1_7_5 + 0.00281250000000009*G0_1_1_7_6 - 0.0222625811688319*G0_1_1_7_7 + 0.00658380681818205*G0_1_1_7_8 - 0.00268465909090919*G0_1_1_7_9 + 0.00348823051948064*G0_1_1_8_0 + 0.000447443181818196*G0_1_1_8_2 + 0.000456574675324685*G0_1_1_8_3 - 0.000228287337662342*G0_1_1_8_4 + 0.00108664772727276*G0_1_1_8_5 - 0.00124188311688315*G0_1_1_8_6 + 0.00658380681818205*G0_1_1_8_7 + 0.0018993506493507*G0_1_1_8_8 + 0.00126014610389615*G0_1_1_8_9 - 0.000980113636363675*G0_1_1_9_0 - 0.000267857142857154*G0_1_1_9_1 - 0.000980113636363674*G0_1_1_9_2 + 0.00126014610389615*G0_1_1_9_3 - 0.00268465909090919*G0_1_1_9_4 + 0.000767045454545484*G0_1_1_9_5 + 0.000767045454545472*G0_1_1_9_6 - 0.00268465909090919*G0_1_1_9_7 + 0.00126014610389614*G0_1_1_9_8 - 0.0105194805194809*G0_1_1_9_9;
    A[33] = -A[83] + 0.00633725649350675*G0_0_0_0_0 - 0.00229200487012995*G0_0_0_0_1 + 0.00288555194805206*G0_0_0_0_2 + 0.011834415584416*G0_0_0_0_3 + 0.011834415584416*G0_0_0_0_4 - 0.00657467532467553*G0_0_0_0_5 + 0.00673904220779248*G0_0_0_0_6 - 0.00714995941558464*G0_0_0_0_7 + 0.00394480519480532*G0_0_0_0_8 + 0.023668831168832*G0_0_0_0_9 - 0.00229200487012995*G0_0_0_1_0 - 0.01479301948052*G0_0_0_1_1 + 0.000100446428571445*G0_0_0_1_2 - 0.0378043831168844*G0_0_0_1_3 + 0.00780742694805221*G0_0_0_1_4 + 0.00468445616883132*G0_0_0_1_5 + 0.00764306006493535*G0_0_0_1_6 + 0.0094510957792211*G0_0_0_1_7 - 0.0189021915584422*G0_0_0_1_8 - 0.0221895292207799*G0_0_0_1_9 + 0.00288555194805206*G0_0_0_2_0 + 0.000100446428571445*G0_0_0_2_1 + 0.0462966720779237*G0_0_0_2_2 - 0.0123275162337667*G0_0_0_2_3 + 0.00246550324675337*G0_0_0_2_4 - 0.0128206168831173*G0_0_0_2_5 + 0.02958603896104*G0_0_0_2_6 + 0.00320515422077933*G0_0_0_2_7 + 0.00394480519480531*G0_0_0_2_8 + 0.002958603896104*G0_0_0_2_9 + 0.011834415584416*G0_0_0_3_0 - 0.0378043831168844*G0_0_0_3_1 - 0.0123275162337667*G0_0_0_3_2 + 0.15532670454546*G0_0_0_3_3 + 0.0288463879870141*G0_0_0_3_4 - 0.0236688311688319*G0_0_0_3_5 - 0.0251481331168839*G0_0_0_3_6 - 0.0377221996753259*G0_0_0_3_7 + 0.0517755681818199*G0_0_0_3_8 + 0.142012987012992*G0_0_0_3_9 + 0.011834415584416*G0_0_0_4_0 + 0.00780742694805221*G0_0_0_4_1 + 0.00246550324675337*G0_0_0_4_2 + 0.0288463879870141*G0_0_0_4_3 + 0.173078327922084*G0_0_0_4_4 - 0.037722199675326*G0_0_0_4_5 + 0.0628703327922099*G0_0_0_4_6 - 0.021449878246754*G0_0_0_4_7 - 0.0140533685064939*G0_0_0_4_8 + 0.0665685876623398*G0_0_0_4_9 - 0.00657467532467553*G0_0_0_5_0 + 0.00468445616883132*G0_0_0_5_1 - 0.0128206168831173*G0_0_0_5_2 - 0.0236688311688319*G0_0_0_5_3 - 0.037722199675326*G0_0_0_5_4 + 0.10355113636364*G0_0_0_5_5 - 0.0369825487013*G0_0_0_5_6 + 0.028106737012988*G0_0_0_5_7 - 0.016272321428572*G0_0_0_5_8 - 0.0384618506493519*G0_0_0_5_9 + 0.00673904220779248*G0_0_0_6_0 + 0.00764306006493535*G0_0_0_6_1 + 0.02958603896104*G0_0_0_6_2 - 0.0251481331168839*G0_0_0_6_3 + 0.0628703327922099*G0_0_0_6_4 - 0.0369825487013*G0_0_0_6_5 + 0.204143668831176*G0_0_0_6_6 - 0.011834415584416*G0_0_0_6_7 - 0.0162723214285719*G0_0_0_6_8 + 0.0414204545454559*G0_0_0_6_9 - 0.00714995941558464*G0_0_0_7_0 + 0.0094510957792211*G0_0_0_7_1 + 0.00320515422077933*G0_0_0_7_2 - 0.0377221996753259*G0_0_0_7_3 - 0.021449878246754*G0_0_0_7_4 + 0.028106737012988*G0_0_0_7_5 - 0.011834415584416*G0_0_0_7_6 + 0.0355032467532479*G0_0_0_7_7 - 0.0140533685064939*G0_0_0_7_8 - 0.0473376623376638*G0_0_0_7_9 + 0.00394480519480532*G0_0_0_8_0 - 0.0189021915584422*G0_0_0_8_1 + 0.00394480519480531*G0_0_0_8_2 + 0.0517755681818199*G0_0_0_8_3 - 0.0140533685064939*G0_0_0_8_4 - 0.016272321428572*G0_0_0_8_5 - 0.0162723214285719*G0_0_0_8_6 - 0.0140533685064939*G0_0_0_8_7 + 0.0517755681818199*G0_0_0_8_8 + 0.0946753246753278*G0_0_0_8_9 + 0.023668831168832*G0_0_0_9_0 - 0.0221895292207799*G0_0_0_9_1 + 0.002958603896104*G0_0_0_9_2 + 0.142012987012992*G0_0_0_9_3 + 0.0665685876623398*G0_0_0_9_4 - 0.0384618506493519*G0_0_0_9_5 + 0.0414204545454559*G0_0_0_9_6 - 0.0473376623376638*G0_0_0_9_7 + 0.0946753246753278*G0_0_0_9_8 + 0.550300324675343*G0_0_0_9_9 + 0.0017167207792208*G0_0_1_0_0 - 0.00904017857142893*G0_0_1_0_1 - 0.000127840909090921*G0_0_1_0_2 + 0.00180803571428576*G0_0_1_0_3 + 0.00205458603896112*G0_0_1_0_4 - 0.000493100649350662*G0_0_1_0_6 + 0.000904017857142895*G0_0_1_0_7 - 0.00673904220779248*G0_0_1_0_8 + 0.00690340909090933*G0_0_1_0_9 - 0.00904017857142893*G0_0_1_1_0 - 0.161627435064941*G0_0_1_1_1 - 0.00904017857142887*G0_0_1_1_2 - 0.0912236201298731*G0_0_1_1_3 + 0.0394480519480532*G0_0_1_1_4 + 0.00328733766233777*G0_0_1_1_5 + 0.00328733766233777*G0_0_1_1_6 + 0.0394480519480534*G0_0_1_1_7 - 0.0912236201298735*G0_0_1_1_8 - 0.0246550324675334*G0_0_1_1_9 - 0.000127840909090921*G0_0_1_2_0 - 0.00904017857142887*G0_0_1_2_1 + 0.0017167207792208*G0_0_1_2_2 - 0.00673904220779243*G0_0_1_2_3 + 0.000904017857142871*G0_0_1_2_4 - 0.00049310064935065*G0_0_1_2_5 + 0.00205458603896112*G0_0_1_2_7 + 0.00180803571428576*G0_0_1_2_8 + 0.00690340909090931*G0_0_1_2_9 + 0.00180803571428576*G0_0_1_3_0 - 0.0912236201298731*G0_0_1_3_1 - 0.00673904220779243*G0_0_1_3_2 + 0.0369825487012999*G0_0_1_3_4 - 0.010355113636364*G0_0_1_3_5 - 0.00443790584415596*G0_0_1_3_6 + 0.0739650974025998*G0_0_1_3_9 + 0.00205458603896112*G0_0_1_4_0 + 0.0394480519480532*G0_0_1_4_1 + 0.000904017857142871*G0_0_1_4_2 + 0.0369825487012999*G0_0_1_4_3 - 0.00147930194805201*G0_0_1_4_4 - 0.000739650974026*G0_0_1_4_5 + 0.00517755681818198*G0_0_1_4_6 - 0.00887581168831204*G0_0_1_4_7 - 0.0192309253246759*G0_0_1_4_9 + 0.00328733766233777*G0_0_1_5_1 - 0.00049310064935065*G0_0_1_5_2 - 0.010355113636364*G0_0_1_5_3 - 0.000739650974026001*G0_0_1_5_4 + 0.011834415584416*G0_0_1_5_5 - 0.00147930194805197*G0_0_1_5_6 + 0.005177556818182*G0_0_1_5_7 - 0.00443790584415599*G0_0_1_5_8 - 0.011834415584416*G0_0_1_5_9 - 0.000493100649350662*G0_0_1_6_0 + 0.00328733766233777*G0_0_1_6_1 - 0.00443790584415597*G0_0_1_6_3 + 0.00517755681818198*G0_0_1_6_4 - 0.00147930194805197*G0_0_1_6_5 + 0.0118344155844159*G0_0_1_6_6 - 0.000739650974026012*G0_0_1_6_7 - 0.010355113636364*G0_0_1_6_8 - 0.011834415584416*G0_0_1_6_9 + 0.000904017857142895*G0_0_1_7_0 + 0.0394480519480534*G0_0_1_7_1 + 0.00205458603896112*G0_0_1_7_2 - 0.00887581168831204*G0_0_1_7_4 + 0.005177556818182*G0_0_1_7_5 - 0.000739650974026012*G0_0_1_7_6 - 0.001479301948052*G0_0_1_7_7 + 0.0369825487013002*G0_0_1_7_8 - 0.0192309253246759*G0_0_1_7_9 - 0.00673904220779248*G0_0_1_8_0 - 0.0912236201298735*G0_0_1_8_1 + 0.00180803571428576*G0_0_1_8_2 - 0.00443790584415599*G0_0_1_8_5 - 0.010355113636364*G0_0_1_8_6 + 0.0369825487013002*G0_0_1_8_7 + 0.0739650974025999*G0_0_1_8_9 + 0.00690340909090933*G0_0_1_9_0 - 0.0246550324675334*G0_0_1_9_1 + 0.00690340909090931*G0_0_1_9_2 + 0.0739650974025998*G0_0_1_9_3 - 0.0192309253246759*G0_0_1_9_4 - 0.011834415584416*G0_0_1_9_5 - 0.011834415584416*G0_0_1_9_6 - 0.0192309253246759*G0_0_1_9_7 + 0.0739650974025998*G0_0_1_9_8 + 0.142012987012992*G0_0_1_9_9;
    A[29] = A[92] - 0.00196022727272735*G0_0_1_0_0 - 0.00098011363636367*G0_0_1_0_2 - 0.00213676948051956*G0_0_1_0_3 + 0.00213676948051956*G0_0_1_0_4 - 0.00109577922077925*G0_0_1_0_5 - 0.00405438311688327*G0_0_1_0_6 - 0.00158887987012993*G0_0_1_0_7 + 0.000876623376623407*G0_0_1_0_8 - 0.00525974025974044*G0_0_1_0_9 + 0.00196022727272733*G0_0_1_1_1 + 0.000980113636363668*G0_0_1_1_2 + 0.00109577922077925*G0_0_1_1_3 + 0.00405438311688326*G0_0_1_1_4 + 0.00213676948051955*G0_0_1_1_5 - 0.00213676948051956*G0_0_1_1_6 - 0.000876623376623402*G0_0_1_1_7 + 0.00158887987012992*G0_0_1_1_8 + 0.00525974025974044*G0_0_1_1_9 - 0.00098011363636367*G0_0_1_2_0 + 0.000980113636363668*G0_0_1_2_1 - 0.00493100649350666*G0_0_1_2_3 + 0.01479301948052*G0_0_1_2_4 + 0.00493100649350666*G0_0_1_2_5 - 0.01479301948052*G0_0_1_2_6 - 0.00016436688311689*G0_0_1_2_7 + 0.000164366883116885*G0_0_1_2_8 - 0.00213676948051956*G0_0_1_3_0 + 0.00109577922077925*G0_0_1_3_1 - 0.00493100649350666*G0_0_1_3_2 - 0.035503246753248*G0_0_1_3_3 - 0.0212033279220786*G0_0_1_3_4 + 0.00641030844155865*G0_0_1_3_6 + 0.00641030844155866*G0_0_1_3_7 - 0.005917207792208*G0_0_1_3_8 - 0.0285998376623386*G0_0_1_3_9 + 0.00213676948051956*G0_0_1_4_0 + 0.00405438311688326*G0_0_1_4_1 + 0.01479301948052*G0_0_1_4_2 - 0.0212033279220786*G0_0_1_4_3 + 0.0936891233766266*G0_0_1_4_4 - 0.00641030844155866*G0_0_1_4_5 - 0.002958603896104*G0_0_1_4_7 - 0.000493100649350658*G0_0_1_4_8 + 0.0128206168831173*G0_0_1_4_9 - 0.00109577922077925*G0_0_1_5_0 + 0.00213676948051955*G0_0_1_5_1 + 0.00493100649350666*G0_0_1_5_2 - 0.00641030844155866*G0_0_1_5_4 + 0.0355032467532479*G0_0_1_5_5 + 0.0212033279220786*G0_0_1_5_6 + 0.00591720779220799*G0_0_1_5_7 - 0.00641030844155866*G0_0_1_5_8 + 0.0285998376623386*G0_0_1_5_9 - 0.00405438311688327*G0_0_1_6_0 - 0.00213676948051956*G0_0_1_6_1 - 0.01479301948052*G0_0_1_6_2 + 0.00641030844155865*G0_0_1_6_3 + 0.0212033279220786*G0_0_1_6_5 - 0.0936891233766265*G0_0_1_6_6 + 0.00049310064935066*G0_0_1_6_7 + 0.00295860389610399*G0_0_1_6_8 - 0.0128206168831173*G0_0_1_6_9 - 0.00158887987012993*G0_0_1_7_0 - 0.000876623376623402*G0_0_1_7_1 - 0.00016436688311689*G0_0_1_7_2 + 0.00641030844155866*G0_0_1_7_3 - 0.002958603896104*G0_0_1_7_4 + 0.00591720779220799*G0_0_1_7_5 + 0.00049310064935066*G0_0_1_7_6 - 0.00394480519480534*G0_0_1_7_7 + 0.01479301948052*G0_0_1_7_9 + 0.000876623376623407*G0_0_1_8_0 + 0.00158887987012992*G0_0_1_8_1 + 0.000164366883116885*G0_0_1_8_2 - 0.005917207792208*G0_0_1_8_3 - 0.000493100649350658*G0_0_1_8_4 - 0.00641030844155866*G0_0_1_8_5 + 0.00295860389610399*G0_0_1_8_6 + 0.0039448051948053*G0_0_1_8_8 - 0.01479301948052*G0_0_1_8_9 - 0.00525974025974044*G0_0_1_9_0 + 0.00525974025974044*G0_0_1_9_1 - 0.0285998376623386*G0_0_1_9_3 + 0.0128206168831173*G0_0_1_9_4 + 0.0285998376623386*G0_0_1_9_5 - 0.0128206168831173*G0_0_1_9_6 + 0.01479301948052*G0_0_1_9_7 - 0.01479301948052*G0_0_1_9_8 + 0.00196022727272735*G0_1_0_0_0 + 0.00098011363636367*G0_1_0_0_2 + 0.00213676948051956*G0_1_0_0_3 - 0.00213676948051956*G0_1_0_0_4 + 0.00109577922077925*G0_1_0_0_5 + 0.00405438311688327*G0_1_0_0_6 + 0.00158887987012993*G0_1_0_0_7 - 0.000876623376623407*G0_1_0_0_8 + 0.00525974025974044*G0_1_0_0_9 - 0.00196022727272733*G0_1_0_1_1 - 0.000980113636363669*G0_1_0_1_2 - 0.00109577922077925*G0_1_0_1_3 - 0.00405438311688326*G0_1_0_1_4 - 0.00213676948051955*G0_1_0_1_5 + 0.00213676948051956*G0_1_0_1_6 + 0.000876623376623403*G0_1_0_1_7 - 0.00158887987012992*G0_1_0_1_8 - 0.00525974025974044*G0_1_0_1_9 + 0.00098011363636367*G0_1_0_2_0 - 0.000980113636363669*G0_1_0_2_1 + 0.00493100649350666*G0_1_0_2_3 - 0.01479301948052*G0_1_0_2_4 - 0.00493100649350666*G0_1_0_2_5 + 0.01479301948052*G0_1_0_2_6 + 0.00016436688311689*G0_1_0_2_7 - 0.000164366883116886*G0_1_0_2_8 + 0.00213676948051956*G0_1_0_3_0 - 0.00109577922077925*G0_1_0_3_1 + 0.00493100649350666*G0_1_0_3_2 + 0.035503246753248*G0_1_0_3_3 + 0.0212033279220786*G0_1_0_3_4 - 0.00641030844155865*G0_1_0_3_6 - 0.00641030844155866*G0_1_0_3_7 + 0.005917207792208*G0_1_0_3_8 + 0.0285998376623386*G0_1_0_3_9 - 0.00213676948051956*G0_1_0_4_0 - 0.00405438311688326*G0_1_0_4_1 - 0.01479301948052*G0_1_0_4_2 + 0.0212033279220786*G0_1_0_4_3 - 0.0936891233766266*G0_1_0_4_4 + 0.00641030844155866*G0_1_0_4_5 + 0.002958603896104*G0_1_0_4_7 + 0.000493100649350658*G0_1_0_4_8 - 0.0128206168831173*G0_1_0_4_9 + 0.00109577922077925*G0_1_0_5_0 - 0.00213676948051955*G0_1_0_5_1 - 0.00493100649350666*G0_1_0_5_2 + 0.00641030844155866*G0_1_0_5_4 - 0.0355032467532479*G0_1_0_5_5 - 0.0212033279220786*G0_1_0_5_6 - 0.00591720779220799*G0_1_0_5_7 + 0.00641030844155866*G0_1_0_5_8 - 0.0285998376623386*G0_1_0_5_9 + 0.00405438311688327*G0_1_0_6_0 + 0.00213676948051956*G0_1_0_6_1 + 0.01479301948052*G0_1_0_6_2 - 0.00641030844155865*G0_1_0_6_3 - 0.0212033279220786*G0_1_0_6_5 + 0.0936891233766265*G0_1_0_6_6 - 0.00049310064935066*G0_1_0_6_7 - 0.00295860389610399*G0_1_0_6_8 + 0.0128206168831173*G0_1_0_6_9 + 0.00158887987012993*G0_1_0_7_0 + 0.000876623376623402*G0_1_0_7_1 + 0.00016436688311689*G0_1_0_7_2 - 0.00641030844155866*G0_1_0_7_3 + 0.002958603896104*G0_1_0_7_4 - 0.00591720779220799*G0_1_0_7_5 - 0.00049310064935066*G0_1_0_7_6 + 0.00394480519480534*G0_1_0_7_7 - 0.01479301948052*G0_1_0_7_9 - 0.000876623376623407*G0_1_0_8_0 - 0.00158887987012992*G0_1_0_8_1 - 0.000164366883116886*G0_1_0_8_2 + 0.005917207792208*G0_1_0_8_3 + 0.000493100649350658*G0_1_0_8_4 + 0.00641030844155866*G0_1_0_8_5 - 0.00295860389610399*G0_1_0_8_6 - 0.0039448051948053*G0_1_0_8_8 + 0.01479301948052*G0_1_0_8_9 + 0.00525974025974044*G0_1_0_9_0 - 0.00525974025974043*G0_1_0_9_1 + 0.0285998376623386*G0_1_0_9_3 - 0.0128206168831173*G0_1_0_9_4 - 0.0285998376623386*G0_1_0_9_5 + 0.0128206168831173*G0_1_0_9_6 - 0.01479301948052*G0_1_0_9_7 + 0.01479301948052*G0_1_0_9_8;
    A[69] = -A[29] + 0.00120535714285719*G0_0_0_0_0 - 0.00246550324675333*G0_0_0_0_2 - 0.000986201298701322*G0_0_0_0_3 + 0.010355113636364*G0_0_0_0_4 + 0.00641030844155866*G0_0_0_0_5 - 0.00641030844155872*G0_0_0_0_6 + 0.00049310064935067*G0_0_0_0_7 - 0.001479301948052*G0_0_0_0_8 + 0.00493100649350666*G0_0_0_0_9 - 0.00120535714285719*G0_0_0_1_1 + 0.00246550324675333*G0_0_0_1_2 - 0.00641030844155867*G0_0_0_1_3 + 0.00641030844155867*G0_0_0_1_4 + 0.000986201298701337*G0_0_0_1_5 - 0.010355113636364*G0_0_0_1_6 + 0.001479301948052*G0_0_0_1_7 - 0.000493100649350674*G0_0_0_1_8 - 0.00493100649350667*G0_0_0_1_9 - 0.00246550324675333*G0_0_0_2_0 + 0.00246550324675333*G0_0_0_2_1 - 0.01479301948052*G0_0_0_2_3 + 0.0246550324675333*G0_0_0_2_4 + 0.01479301948052*G0_0_0_2_5 - 0.0246550324675333*G0_0_0_2_6 + 0.00246550324675333*G0_0_0_2_7 - 0.00246550324675333*G0_0_0_2_8 - 0.000986201298701322*G0_0_0_3_0 - 0.00641030844155867*G0_0_0_3_1 - 0.01479301948052*G0_0_0_3_2 + 0.00591720779220815*G0_0_0_3_3 - 0.0162723214285719*G0_0_0_3_4 + 0.0310653409090919*G0_0_0_3_6 + 0.00295860389610399*G0_0_0_3_7 - 0.010355113636364*G0_0_0_3_8 + 0.00887581168831202*G0_0_0_3_9 + 0.010355113636364*G0_0_0_4_0 + 0.00641030844155867*G0_0_0_4_1 + 0.0246550324675333*G0_0_0_4_2 - 0.0162723214285719*G0_0_0_4_3 + 0.28106737012988*G0_0_0_4_4 - 0.031065340909092*G0_0_0_4_5 - 0.019230925324676*G0_0_0_4_7 + 0.00739650974025999*G0_0_0_4_8 + 0.0621306818181839*G0_0_0_4_9 + 0.00641030844155866*G0_0_0_5_0 + 0.000986201298701337*G0_0_0_5_1 + 0.01479301948052*G0_0_0_5_2 - 0.031065340909092*G0_0_0_5_4 - 0.00591720779220803*G0_0_0_5_5 + 0.016272321428572*G0_0_0_5_6 + 0.010355113636364*G0_0_0_5_7 - 0.002958603896104*G0_0_0_5_8 - 0.00887581168831195*G0_0_0_5_9 - 0.00641030844155871*G0_0_0_6_0 - 0.010355113636364*G0_0_0_6_1 - 0.0246550324675333*G0_0_0_6_2 + 0.0310653409090919*G0_0_0_6_3 + 0.016272321428572*G0_0_0_6_5 - 0.28106737012988*G0_0_0_6_6 - 0.00739650974026003*G0_0_0_6_7 + 0.019230925324676*G0_0_0_6_8 - 0.0621306818181839*G0_0_0_6_9 + 0.00049310064935067*G0_0_0_7_0 + 0.001479301948052*G0_0_0_7_1 + 0.00246550324675333*G0_0_0_7_2 + 0.00295860389610399*G0_0_0_7_3 - 0.019230925324676*G0_0_0_7_4 + 0.010355113636364*G0_0_0_7_5 - 0.00739650974026003*G0_0_0_7_6 + 0.00887581168831202*G0_0_0_7_7 - 0.001479301948052*G0_0_0_8_0 - 0.000493100649350675*G0_0_0_8_1 - 0.00246550324675333*G0_0_0_8_2 - 0.010355113636364*G0_0_0_8_3 + 0.00739650974025999*G0_0_0_8_4 - 0.002958603896104*G0_0_0_8_5 + 0.019230925324676*G0_0_0_8_6 - 0.008875811688312*G0_0_0_8_8 + 0.00493100649350666*G0_0_0_9_0 - 0.00493100649350667*G0_0_0_9_1 + 0.00887581168831203*G0_0_0_9_3 + 0.0621306818181839*G0_0_0_9_4 - 0.00887581168831196*G0_0_0_9_5 - 0.0621306818181839*G0_0_0_9_6 + 0.0028490259740261*G0_0_1_0_0 + 0.00131493506493512*G0_0_1_0_1 + 0.00241071428571439*G0_0_1_0_2 - 0.00493100649350668*G0_0_1_0_3 + 0.0207102272727281*G0_0_1_0_4 - 0.00591720779220802*G0_0_1_0_5 + 0.0113413149350654*G0_0_1_0_6 - 0.00197240259740266*G0_0_1_0_7 - 0.00147930194805201*G0_0_1_0_8 + 0.011834415584416*G0_0_1_0_9 + 0.00131493506493512*G0_0_1_1_0 + 0.00164366883116891*G0_0_1_1_1 + 0.00487621753246772*G0_0_1_1_2 - 0.0123275162337667*G0_0_1_1_3 + 0.017751623376624*G0_0_1_1_4 - 0.00394480519480535*G0_0_1_1_5 + 0.010355113636364*G0_0_1_1_6 - 0.00246550324675332*G0_0_1_1_8 + 0.00690340909090935*G0_0_1_1_9 + 0.00241071428571439*G0_0_1_2_0 + 0.00487621753246772*G0_0_1_2_1 + 0.0361607142857157*G0_0_1_2_2 - 0.0246550324675334*G0_0_1_2_3 + 0.0468445616883134*G0_0_1_2_4 - 0.00986201298701338*G0_0_1_2_5 + 0.0221895292207801*G0_0_1_2_6 + 0.00197240259740267*G0_0_1_2_7 - 0.000493100649350665*G0_0_1_2_8 + 0.00493100649350669*G0_0_1_2_9 - 0.00493100649350668*G0_0_1_3_0 - 0.0123275162337667*G0_0_1_3_1 - 0.0246550324675334*G0_0_1_3_2 + 0.0399411525974041*G0_0_1_3_3 - 0.0665685876623399*G0_0_1_3_4 + 0.019230925324676*G0_0_1_3_5 - 0.042899756493508*G0_0_1_3_6 + 0.00295860389610397*G0_0_1_3_7 + 0.00739650974026002*G0_0_1_3_8 - 0.0266274350649359*G0_0_1_3_9 + 0.0207102272727281*G0_0_1_4_0 + 0.017751623376624*G0_0_1_4_1 + 0.0468445616883134*G0_0_1_4_2 - 0.0665685876623399*G0_0_1_4_3 + 0.386097808441572*G0_0_1_4_4 - 0.0739650974026*G0_0_1_4_5 + 0.116864853896108*G0_0_1_4_6 - 0.028106737012988*G0_0_1_4_7 - 0.010355113636364*G0_0_1_4_8 + 0.13313717532468*G0_0_1_4_9 - 0.00591720779220802*G0_0_1_5_0 - 0.00394480519480535*G0_0_1_5_1 - 0.00986201298701338*G0_0_1_5_2 + 0.019230925324676*G0_0_1_5_3 - 0.0739650974026*G0_0_1_5_4 + 0.034023944805196*G0_0_1_5_5 - 0.0502962662337681*G0_0_1_5_6 + 0.017751623376624*G0_0_1_5_7 - 0.035503246753248*G0_0_1_5_9 + 0.0113413149350654*G0_0_1_6_0 + 0.010355113636364*G0_0_1_6_1 + 0.0221895292207801*G0_0_1_6_2 - 0.042899756493508*G0_0_1_6_3 + 0.116864853896108*G0_0_1_6_4 - 0.0502962662337681*G0_0_1_6_5 + 0.105030438311692*G0_0_1_6_6 - 0.017751623376624*G0_0_1_6_7 - 0.00887581168831201*G0_0_1_6_8 + 0.071006493506496*G0_0_1_6_9 - 0.00197240259740266*G0_0_1_7_0 + 0.00197240259740267*G0_0_1_7_2 + 0.00295860389610398*G0_0_1_7_3 - 0.028106737012988*G0_0_1_7_4 + 0.017751623376624*G0_0_1_7_5 - 0.017751623376624*G0_0_1_7_6 + 0.0281067370129882*G0_0_1_7_7 - 0.00295860389610403*G0_0_1_7_8 - 0.00147930194805201*G0_0_1_8_0 - 0.00246550324675332*G0_0_1_8_1 - 0.000493100649350665*G0_0_1_8_2 + 0.00739650974026002*G0_0_1_8_3 - 0.010355113636364*G0_0_1_8_4 - 0.00887581168831201*G0_0_1_8_6 - 0.00295860389610403*G0_0_1_8_7 + 0.0192309253246762*G0_0_1_8_8 + 0.011834415584416*G0_0_1_9_0 + 0.00690340909090935*G0_0_1_9_1 + 0.00493100649350669*G0_0_1_9_2 - 0.0266274350649359*G0_0_1_9_3 + 0.13313717532468*G0_0_1_9_4 - 0.035503246753248*G0_0_1_9_5 + 0.071006493506496*G0_0_1_9_6 + 0.159764610389616*G0_0_1_9_9 - 0.00505275974025995*G0_1_0_0_0 - 0.00169845779220785*G0_1_0_0_1 + 0.000432224025974035*G0_1_0_0_2 + 0.00164366883116887*G0_1_0_0_3 + 0.0047666396103898*G0_1_0_0_4 - 0.0171489448051954*G0_1_0_0_5 - 0.00235592532467536*G0_1_0_0_6 - 0.00778003246753275*G0_1_0_0_7 + 0.00454748376623392*G0_1_0_0_8 - 0.0115056818181822*G0_1_0_0_9 - 0.00169845779220785*G0_1_0_1_0 - 0.000645292207792213*G0_1_0_1_1 + 0.000170454545454553*G0_1_0_1_2 - 0.0104646915584419*G0_1_0_1_3 + 0.00580762987013007*G0_1_0_1_4 + 0.0106838474025978*G0_1_0_1_5 + 0.0105194805194809*G0_1_0_1_6 + 0.00284902597402607*G0_1_0_1_7 - 0.00553368506493525*G0_1_0_1_8 + 0.0164366883116889*G0_1_0_1_9 + 0.000432224025974035*G0_1_0_2_0 + 0.000170454545454553*G0_1_0_2_1 + 0.00657467532467554*G0_1_0_2_2 - 0.005917207792208*G0_1_0_2_3 + 0.00986201298701332*G0_1_0_2_4 - 0.00591720779220796*G0_1_0_2_5 - 0.00986201298701333*G0_1_0_2_6 - 0.000328733766233779*G0_1_0_2_7 + 0.00082183441558444*G0_1_0_2_8 - 0.00788961038961064*G0_1_0_2_9 + 0.00164366883116888*G0_1_0_3_0 - 0.0104646915584419*G0_1_0_3_1 - 0.005917207792208*G0_1_0_3_2 + 0.0340239448051959*G0_1_0_3_3 - 0.00690340909090928*G0_1_0_3_4 - 0.0192309253246759*G0_1_0_3_5 - 0.0300791396103906*G0_1_0_3_6 - 0.00345170454545465*G0_1_0_3_7 + 0.00443790584415597*G0_1_0_3_8 - 0.0424066558441573*G0_1_0_3_9 + 0.0047666396103898*G0_1_0_4_0 + 0.00580762987013007*G0_1_0_4_1 + 0.00986201298701332*G0_1_0_4_2 - 0.00690340909090927*G0_1_0_4_3 + 0.144478490259745*G0_1_0_4_4 - 0.0128206168831174*G0_1_0_4_5 + 0.0428997564935079*G0_1_0_4_6 - 0.00739650974025999*G0_1_0_4_7 - 0.000986201298701323*G0_1_0_4_8 + 0.0493100649350665*G0_1_0_4_9 - 0.0171489448051954*G0_1_0_5_0 + 0.0106838474025978*G0_1_0_5_1 - 0.00591720779220796*G0_1_0_5_2 - 0.0192309253246759*G0_1_0_5_3 - 0.0128206168831174*G0_1_0_5_4 + 0.211540178571436*G0_1_0_5_5 + 0.0350101461038973*G0_1_0_5_6 + 0.0281067370129879*G0_1_0_5_7 - 0.0305722402597413*G0_1_0_5_8 + 0.0956615259740292*G0_1_0_5_9 - 0.00235592532467536*G0_1_0_6_0 + 0.0105194805194809*G0_1_0_6_1 - 0.00986201298701333*G0_1_0_6_2 - 0.0300791396103906*G0_1_0_6_3 + 0.0428997564935079*G0_1_0_6_4 + 0.0350101461038973*G0_1_0_6_5 + 0.198719561688318*G0_1_0_6_6 + 0.00246550324675336*G0_1_0_6_7 - 0.017751623376624*G0_1_0_6_8 + 0.0838271103896132*G0_1_0_6_9 - 0.00778003246753275*G0_1_0_7_0 + 0.00284902597402607*G0_1_0_7_1 - 0.000328733766233778*G0_1_0_7_2 - 0.00345170454545465*G0_1_0_7_3 - 0.00739650974025999*G0_1_0_7_4 + 0.0281067370129879*G0_1_0_7_5 + 0.00246550324675336*G0_1_0_7_6 - 0.0064103084415587*G0_1_0_7_7 - 0.00147930194805199*G0_1_0_7_8 + 0.02958603896104*G0_1_0_7_9 + 0.00454748376623392*G0_1_0_8_0 - 0.00553368506493525*G0_1_0_8_1 + 0.00082183441558444*G0_1_0_8_2 + 0.00443790584415597*G0_1_0_8_3 - 0.000986201298701324*G0_1_0_8_4 - 0.0305722402597413*G0_1_0_8_5 - 0.017751623376624*G0_1_0_8_6 - 0.00147930194805199*G0_1_0_8_7 + 0.00345170454545466*G0_1_0_8_8 - 0.047337662337664*G0_1_0_8_9 - 0.0115056818181822*G0_1_0_9_0 + 0.0164366883116889*G0_1_0_9_1 - 0.00788961038961064*G0_1_0_9_2 - 0.0424066558441573*G0_1_0_9_3 + 0.0493100649350665*G0_1_0_9_4 + 0.0956615259740292*G0_1_0_9_5 + 0.0838271103896132*G0_1_0_9_6 + 0.02958603896104*G0_1_0_9_7 - 0.047337662337664*G0_1_0_9_8 + 0.159764610389616*G0_1_0_9_9 - 0.0116274350649355*G0_1_1_0_0 - 0.00186891233766241*G0_1_1_0_1 + 0.000821834415584444*G0_1_1_0_3 + 0.00509537337662358*G0_1_1_0_4 - 0.0072869318181821*G0_1_1_0_5 + 0.0035612824675326*G0_1_1_0_6 - 0.0176420454545461*G0_1_1_0_7 + 0.010464691558442*G0_1_1_0_8 - 0.00361607142857157*G0_1_1_0_9 - 0.00186891233766241*G0_1_1_1_0 + 0.00186891233766241*G0_1_1_1_2 - 0.00493100649350665*G0_1_1_1_3 + 0.00295860389610401*G0_1_1_1_4 + 0.000164366883116882*G0_1_1_1_5 - 0.000164366883116883*G0_1_1_1_6 - 0.00295860389610402*G0_1_1_1_7 + 0.00493100649350668*G0_1_1_1_8 + 0.00186891233766241*G0_1_1_2_1 + 0.0116274350649355*G0_1_1_2_2 - 0.0104646915584419*G0_1_1_2_3 + 0.0176420454545461*G0_1_1_2_4 - 0.00356128246753261*G0_1_1_2_5 + 0.00728693181818211*G0_1_1_2_6 - 0.00509537337662356*G0_1_1_2_7 - 0.000821834415584442*G0_1_1_2_8 + 0.00361607142857156*G0_1_1_2_9 + 0.000821834415584445*G0_1_1_3_0 - 0.00493100649350665*G0_1_1_3_1 - 0.0104646915584419*G0_1_1_3_2 + 0.0305722402597413*G0_1_1_3_3 - 0.00542410714285733*G0_1_1_3_4 - 0.00147930194805198*G0_1_1_3_5 + 0.000493100649350649*G0_1_1_3_6 - 0.00246550324675329*G0_1_1_3_7 + 0.00493100649350665*G0_1_1_3_9 + 0.00509537337662358*G0_1_1_4_0 + 0.00295860389610401*G0_1_1_4_1 + 0.0176420454545461*G0_1_1_4_2 - 0.00542410714285733*G0_1_1_4_3 + 0.150888798701304*G0_1_1_4_4 - 0.0152861201298707*G0_1_1_4_5 + 0.01479301948052*G0_1_1_4_6 + 0.00246550324675332*G0_1_1_4_8 + 0.0197240259740266*G0_1_1_4_9 - 0.00728693181818211*G0_1_1_5_0 + 0.000164366883116882*G0_1_1_5_1 - 0.00356128246753261*G0_1_1_5_2 - 0.00147930194805198*G0_1_1_5_3 - 0.0152861201298707*G0_1_1_5_4 + 0.0128206168831173*G0_1_1_5_5 - 0.01479301948052*G0_1_1_5_7 - 0.00049310064935065*G0_1_1_5_8 + 0.011834415584416*G0_1_1_5_9 + 0.0035612824675326*G0_1_1_6_0 - 0.000164366883116883*G0_1_1_6_1 + 0.0072869318181821*G0_1_1_6_2 + 0.000493100649350649*G0_1_1_6_3 + 0.01479301948052*G0_1_1_6_4 - 0.0128206168831173*G0_1_1_6_6 + 0.0152861201298707*G0_1_1_6_7 + 0.00147930194805199*G0_1_1_6_8 - 0.011834415584416*G0_1_1_6_9 - 0.0176420454545461*G0_1_1_7_0 - 0.00295860389610402*G0_1_1_7_1 - 0.00509537337662356*G0_1_1_7_2 - 0.00246550324675329*G0_1_1_7_3 - 0.01479301948052*G0_1_1_7_5 + 0.0152861201298707*G0_1_1_7_6 - 0.150888798701304*G0_1_1_7_7 + 0.0054241071428574*G0_1_1_7_8 - 0.0197240259740267*G0_1_1_7_9 + 0.0104646915584419*G0_1_1_8_0 + 0.00493100649350668*G0_1_1_8_1 - 0.000821834415584441*G0_1_1_8_2 + 0.00246550324675332*G0_1_1_8_4 - 0.000493100649350649*G0_1_1_8_5 + 0.00147930194805199*G0_1_1_8_6 + 0.0054241071428574*G0_1_1_8_7 - 0.0305722402597413*G0_1_1_8_8 - 0.00493100649350665*G0_1_1_8_9 - 0.00361607142857157*G0_1_1_9_0 + 0.00361607142857156*G0_1_1_9_2 + 0.00493100649350665*G0_1_1_9_3 + 0.0197240259740266*G0_1_1_9_4 + 0.011834415584416*G0_1_1_9_5 - 0.011834415584416*G0_1_1_9_6 - 0.0197240259740267*G0_1_1_9_7 - 0.00493100649350665*G0_1_1_9_8;
    A[96] = A[69] - 0.0098620129870134*G0_0_1_0_0 - 0.00301339285714297*G0_0_1_0_1 - 0.00295860389610403*G0_0_1_0_2 + 0.00443790584415599*G0_0_1_0_3 - 0.0138068181818187*G0_0_1_0_4 - 0.0123275162337666*G0_0_1_0_5 - 0.017751623376624*G0_0_1_0_6 - 0.00739650974026002*G0_0_1_0_7 + 0.00690340909090934*G0_0_1_0_8 - 0.0285998376623387*G0_0_1_0_9 - 0.00301339285714297*G0_0_1_1_0 - 0.000328733766233795*G0_0_1_1_1 - 0.0037256493506495*G0_0_1_1_2 + 0.00295860389610402*G0_0_1_1_3 - 0.0078896103896107*G0_0_1_1_4 + 0.0167654220779227*G0_0_1_1_5 - 0.0019724025974027*G0_0_1_1_6 + 0.00197240259740267*G0_0_1_1_7 - 0.00147930194805201*G0_0_1_1_8 + 0.01479301948052*G0_0_1_1_9 - 0.00295860389610403*G0_0_1_2_0 - 0.0037256493506495*G0_0_1_2_1 - 0.0295860389610401*G0_0_1_2_2 + 0.0138068181818187*G0_0_1_2_3 - 0.0221895292207801*G0_0_1_2_4 + 0.00887581168831207*G0_0_1_2_5 - 0.0468445616883134*G0_0_1_2_6 - 0.00246550324675334*G0_0_1_2_7 + 0.00147930194805199*G0_0_1_2_8 - 0.0128206168831173*G0_0_1_2_9 + 0.00443790584415599*G0_0_1_3_0 + 0.00295860389610402*G0_0_1_3_1 + 0.0138068181818187*G0_0_1_3_2 - 0.0414204545454562*G0_0_1_3_3 + 0.038461850649352*G0_0_1_3_4 - 0.0384618506493519*G0_0_1_3_5 + 0.0192309253246761*G0_0_1_3_6 - 0.00887581168831205*G0_0_1_3_8 - 0.04437905844156*G0_0_1_3_9 - 0.0138068181818187*G0_0_1_4_0 - 0.0078896103896107*G0_0_1_4_1 - 0.0221895292207801*G0_0_1_4_2 + 0.038461850649352*G0_0_1_4_3 - 0.147930194805201*G0_0_1_4_4 + 0.054734172077924*G0_0_1_4_5 - 0.0739650974026002*G0_0_1_4_6 + 0.017751623376624*G0_0_1_4_7 + 0.00887581168831203*G0_0_1_4_8 - 0.0710064935064961*G0_0_1_4_9 - 0.0123275162337666*G0_0_1_5_0 + 0.0167654220779227*G0_0_1_5_1 + 0.00887581168831207*G0_0_1_5_2 - 0.0384618506493519*G0_0_1_5_3 + 0.054734172077924*G0_0_1_5_4 + 0.213019480519487*G0_0_1_5_5 + 0.106509740259744*G0_0_1_5_6 + 0.0162723214285719*G0_0_1_5_7 - 0.0369825487012999*G0_0_1_5_8 + 0.159764610389616*G0_0_1_5_9 - 0.017751623376624*G0_0_1_6_0 - 0.0019724025974027*G0_0_1_6_1 - 0.0468445616883134*G0_0_1_6_2 + 0.0192309253246761*G0_0_1_6_3 - 0.0739650974026002*G0_0_1_6_4 + 0.106509740259744*G0_0_1_6_5 + 0.020710227272728*G0_0_1_6_7 - 0.00591720779220795*G0_0_1_6_8 - 0.00739650974026002*G0_0_1_7_0 + 0.00197240259740267*G0_0_1_7_1 - 0.00246550324675334*G0_0_1_7_2 + 0.017751623376624*G0_0_1_7_4 + 0.0162723214285719*G0_0_1_7_5 + 0.020710227272728*G0_0_1_7_6 - 0.0384618506493523*G0_0_1_7_7 + 0.00147930194805204*G0_0_1_7_8 + 0.0443790584415599*G0_0_1_7_9 + 0.00690340909090934*G0_0_1_8_0 - 0.00147930194805201*G0_0_1_8_1 + 0.00147930194805199*G0_0_1_8_2 - 0.00887581168831205*G0_0_1_8_3 + 0.00887581168831203*G0_0_1_8_4 - 0.0369825487012999*G0_0_1_8_5 - 0.00591720779220795*G0_0_1_8_6 + 0.00147930194805204*G0_0_1_8_7 - 0.0118344155844162*G0_0_1_8_8 - 0.062130681818184*G0_0_1_8_9 - 0.0285998376623387*G0_0_1_9_0 + 0.01479301948052*G0_0_1_9_1 - 0.0128206168831173*G0_0_1_9_2 - 0.04437905844156*G0_0_1_9_3 - 0.0710064935064961*G0_0_1_9_4 + 0.159764610389616*G0_0_1_9_5 + 0.0443790584415599*G0_0_1_9_7 - 0.062130681818184*G0_0_1_9_8 + 0.0098620129870134*G0_1_0_0_0 + 0.00301339285714297*G0_1_0_0_1 + 0.00295860389610403*G0_1_0_0_2 - 0.00443790584415599*G0_1_0_0_3 + 0.0138068181818187*G0_1_0_0_4 + 0.0123275162337666*G0_1_0_0_5 + 0.017751623376624*G0_1_0_0_6 + 0.00739650974026002*G0_1_0_0_7 - 0.00690340909090934*G0_1_0_0_8 + 0.0285998376623387*G0_1_0_0_9 + 0.00301339285714297*G0_1_0_1_0 + 0.000328733766233794*G0_1_0_1_1 + 0.0037256493506495*G0_1_0_1_2 - 0.00295860389610402*G0_1_0_1_3 + 0.0078896103896107*G0_1_0_1_4 - 0.0167654220779227*G0_1_0_1_5 + 0.0019724025974027*G0_1_0_1_6 - 0.00197240259740267*G0_1_0_1_7 + 0.00147930194805201*G0_1_0_1_8 - 0.01479301948052*G0_1_0_1_9 + 0.00295860389610403*G0_1_0_2_0 + 0.0037256493506495*G0_1_0_2_1 + 0.0295860389610401*G0_1_0_2_2 - 0.0138068181818187*G0_1_0_2_3 + 0.0221895292207801*G0_1_0_2_4 - 0.00887581168831207*G0_1_0_2_5 + 0.0468445616883134*G0_1_0_2_6 + 0.00246550324675334*G0_1_0_2_7 - 0.00147930194805199*G0_1_0_2_8 + 0.0128206168831173*G0_1_0_2_9 - 0.00443790584415599*G0_1_0_3_0 - 0.00295860389610402*G0_1_0_3_1 - 0.0138068181818187*G0_1_0_3_2 + 0.0414204545454562*G0_1_0_3_3 - 0.038461850649352*G0_1_0_3_4 + 0.0384618506493519*G0_1_0_3_5 - 0.0192309253246761*G0_1_0_3_6 + 0.00887581168831205*G0_1_0_3_8 + 0.04437905844156*G0_1_0_3_9 + 0.0138068181818187*G0_1_0_4_0 + 0.0078896103896107*G0_1_0_4_1 + 0.0221895292207801*G0_1_0_4_2 - 0.038461850649352*G0_1_0_4_3 + 0.147930194805201*G0_1_0_4_4 - 0.054734172077924*G0_1_0_4_5 + 0.0739650974026002*G0_1_0_4_6 - 0.017751623376624*G0_1_0_4_7 - 0.00887581168831203*G0_1_0_4_8 + 0.0710064935064961*G0_1_0_4_9 + 0.0123275162337666*G0_1_0_5_0 - 0.0167654220779227*G0_1_0_5_1 - 0.00887581168831207*G0_1_0_5_2 + 0.0384618506493519*G0_1_0_5_3 - 0.054734172077924*G0_1_0_5_4 - 0.213019480519487*G0_1_0_5_5 - 0.106509740259744*G0_1_0_5_6 - 0.0162723214285719*G0_1_0_5_7 + 0.0369825487012999*G0_1_0_5_8 - 0.159764610389616*G0_1_0_5_9 + 0.017751623376624*G0_1_0_6_0 + 0.0019724025974027*G0_1_0_6_1 + 0.0468445616883134*G0_1_0_6_2 - 0.0192309253246761*G0_1_0_6_3 + 0.0739650974026002*G0_1_0_6_4 - 0.106509740259744*G0_1_0_6_5 - 0.020710227272728*G0_1_0_6_7 + 0.00591720779220795*G0_1_0_6_8 + 0.00739650974026002*G0_1_0_7_0 - 0.00197240259740267*G0_1_0_7_1 + 0.00246550324675334*G0_1_0_7_2 - 0.017751623376624*G0_1_0_7_4 - 0.0162723214285719*G0_1_0_7_5 - 0.020710227272728*G0_1_0_7_6 + 0.0384618506493523*G0_1_0_7_7 - 0.00147930194805204*G0_1_0_7_8 - 0.0443790584415599*G0_1_0_7_9 - 0.00690340909090934*G0_1_0_8_0 + 0.00147930194805201*G0_1_0_8_1 - 0.00147930194805199*G0_1_0_8_2 + 0.00887581168831205*G0_1_0_8_3 - 0.00887581168831203*G0_1_0_8_4 + 0.0369825487012999*G0_1_0_8_5 + 0.00591720779220795*G0_1_0_8_6 - 0.00147930194805204*G0_1_0_8_7 + 0.0118344155844162*G0_1_0_8_8 + 0.062130681818184*G0_1_0_8_9 + 0.0285998376623387*G0_1_0_9_0 - 0.01479301948052*G0_1_0_9_1 + 0.0128206168831173*G0_1_0_9_2 + 0.04437905844156*G0_1_0_9_3 + 0.0710064935064961*G0_1_0_9_4 - 0.159764610389616*G0_1_0_9_5 - 0.0443790584415599*G0_1_0_9_7 + 0.062130681818184*G0_1_0_9_8;
    A[94] = -A[96] - 0.00953327922077963*G0_0_1_0_0 + 0.000767045454545473*G0_0_1_0_2 - 0.0123275162337667*G0_0_1_0_3 - 0.011834415584416*G0_0_1_0_4 - 0.0152861201298706*G0_0_1_0_5 - 0.00986201298701328*G0_0_1_0_6 - 0.00591720779220801*G0_0_1_0_7 + 0.00493100649350666*G0_0_1_0_8 - 0.0433928571428586*G0_0_1_0_9 + 0.00953327922077948*G0_0_1_1_1 - 0.000767045454545487*G0_0_1_1_2 + 0.0152861201298706*G0_0_1_1_3 + 0.00986201298701335*G0_0_1_1_4 + 0.0123275162337666*G0_0_1_1_5 + 0.011834415584416*G0_0_1_1_6 - 0.00493100649350665*G0_0_1_1_7 + 0.00591720779220796*G0_0_1_1_8 + 0.0433928571428586*G0_0_1_1_9 + 0.000767045454545473*G0_0_1_2_0 - 0.000767045454545486*G0_0_1_2_1 + 0.00493100649350667*G0_0_1_2_3 + 0.0246550324675333*G0_0_1_2_4 - 0.00493100649350663*G0_0_1_2_5 - 0.0246550324675333*G0_0_1_2_6 - 0.00394480519480534*G0_0_1_2_7 + 0.00394480519480532*G0_0_1_2_8 - 0.0123275162337667*G0_0_1_3_0 + 0.0152861201298706*G0_0_1_3_1 + 0.00493100649350667*G0_0_1_3_2 - 0.254439935064944*G0_0_1_3_3 - 0.0680478896103921*G0_0_1_3_4 - 0.0355032467532479*G0_0_1_3_6 + 0.0369825487013*G0_0_1_3_7 - 0.0251481331168841*G0_0_1_3_8 - 0.204143668831176*G0_0_1_3_9 - 0.011834415584416*G0_0_1_4_0 + 0.00986201298701335*G0_0_1_4_1 + 0.0246550324675333*G0_0_1_4_2 - 0.0680478896103921*G0_0_1_4_3 - 0.1479301948052*G0_0_1_4_4 + 0.0355032467532479*G0_0_1_4_5 + 0.023668831168832*G0_0_1_4_7 - 0.011834415584416*G0_0_1_4_8 - 0.071006493506496*G0_0_1_4_9 - 0.0152861201298706*G0_0_1_5_0 + 0.0123275162337666*G0_0_1_5_1 - 0.00493100649350664*G0_0_1_5_2 + 0.0355032467532479*G0_0_1_5_4 + 0.254439935064943*G0_0_1_5_5 + 0.0680478896103919*G0_0_1_5_6 + 0.0251481331168839*G0_0_1_5_7 - 0.0369825487012999*G0_0_1_5_8 + 0.204143668831176*G0_0_1_5_9 - 0.00986201298701328*G0_0_1_6_0 + 0.011834415584416*G0_0_1_6_1 - 0.0246550324675333*G0_0_1_6_2 - 0.0355032467532479*G0_0_1_6_3 + 0.0680478896103919*G0_0_1_6_5 + 0.1479301948052*G0_0_1_6_6 + 0.011834415584416*G0_0_1_6_7 - 0.0236688311688319*G0_0_1_6_8 + 0.0710064935064959*G0_0_1_6_9 - 0.00591720779220801*G0_0_1_7_0 - 0.00493100649350665*G0_0_1_7_1 - 0.00394480519480534*G0_0_1_7_2 + 0.0369825487013*G0_0_1_7_3 + 0.023668831168832*G0_0_1_7_4 + 0.0251481331168839*G0_0_1_7_5 + 0.011834415584416*G0_0_1_7_6 - 0.0266274350649361*G0_0_1_7_7 + 0.106509740259744*G0_0_1_7_9 + 0.00493100649350666*G0_0_1_8_0 + 0.00591720779220796*G0_0_1_8_1 + 0.00394480519480532*G0_0_1_8_2 - 0.0251481331168841*G0_0_1_8_3 - 0.011834415584416*G0_0_1_8_4 - 0.0369825487012999*G0_0_1_8_5 - 0.0236688311688319*G0_0_1_8_6 + 0.0266274350649359*G0_0_1_8_8 - 0.106509740259744*G0_0_1_8_9 - 0.0433928571428586*G0_0_1_9_0 + 0.0433928571428586*G0_0_1_9_1 - 0.204143668831176*G0_0_1_9_3 - 0.071006493506496*G0_0_1_9_4 + 0.204143668831176*G0_0_1_9_5 + 0.0710064935064959*G0_0_1_9_6 + 0.106509740259744*G0_0_1_9_7 - 0.106509740259744*G0_0_1_9_8 - 0.0210389610389619*G0_1_1_0_0 - 0.00432832792207809*G0_1_1_0_1 + 0.00202719155844164*G0_1_1_0_2 - 0.013313717532468*G0_1_1_0_3 - 0.0138068181818187*G0_1_1_0_4 - 0.00295860389610404*G0_1_1_0_5 - 0.000986201298701316*G0_1_1_0_6 - 0.0133137175324681*G0_1_1_0_7 + 0.00986201298701334*G0_1_1_0_8 - 0.032544642857144*G0_1_1_0_9 - 0.00432832792207809*G0_1_1_1_0 - 0.0115056818181823*G0_1_1_1_1 + 0.00126014610389615*G0_1_1_1_2 + 0.0123275162337666*G0_1_1_1_3 + 0.00887581168831203*G0_1_1_1_4 - 0.000986201298701337*G0_1_1_1_5 - 0.00197240259740266*G0_1_1_1_6 + 0.00493100649350667*G0_1_1_1_7 - 0.00739650974026006*G0_1_1_1_8 + 0.0108482142857146*G0_1_1_1_9 + 0.00202719155844164*G0_1_1_2_0 + 0.00126014610389615*G0_1_1_2_1 + 0.0175324675324682*G0_1_1_2_2 - 0.00690340909090932*G0_1_1_2_3 + 0.04437905844156*G0_1_1_2_4 - 0.011834415584416*G0_1_1_2_5 + 0.0197240259740267*G0_1_1_2_6 - 0.0142999188311693*G0_1_1_2_7 - 0.010355113636364*G0_1_1_2_8 + 0.0187378246753253*G0_1_1_2_9 - 0.013313717532468*G0_1_1_3_0 + 0.0123275162337666*G0_1_1_3_1 - 0.00690340909090932*G0_1_1_3_2 - 0.257398538961048*G0_1_1_3_3 - 0.0488169642857162*G0_1_1_3_4 + 0.020710227272728*G0_1_1_3_5 + 0.00739650974025994*G0_1_1_3_6 + 0.0414204545454561*G0_1_1_3_7 - 0.0739650974025999*G0_1_1_3_8 - 0.115385551948056*G0_1_1_3_9 - 0.0138068181818187*G0_1_1_4_0 + 0.00887581168831202*G0_1_1_4_1 + 0.04437905844156*G0_1_1_4_2 - 0.0488169642857162*G0_1_1_4_3 - 0.186392045454552*G0_1_1_4_4 + 0.0428997564935079*G0_1_1_4_5 - 0.0502962662337679*G0_1_1_4_6 + 0.041420454545456*G0_1_1_4_7 + 0.0325446428571439*G0_1_1_4_8 - 0.142012987012992*G0_1_1_4_9 - 0.00295860389610404*G0_1_1_5_0 - 0.000986201298701338*G0_1_1_5_1 - 0.011834415584416*G0_1_1_5_2 + 0.020710227272728*G0_1_1_5_3 + 0.042899756493508*G0_1_1_5_4 - 0.00295860389610408*G0_1_1_5_5 + 0.019230925324676*G0_1_1_5_6 - 0.0488169642857161*G0_1_1_5_7 + 0.00443790584415604*G0_1_1_5_8 + 0.0887581168831198*G0_1_1_5_9 - 0.000986201298701316*G0_1_1_6_0 - 0.00197240259740266*G0_1_1_6_1 + 0.0197240259740267*G0_1_1_6_2 + 0.00739650974025994*G0_1_1_6_3 - 0.0502962662337679*G0_1_1_6_4 + 0.019230925324676*G0_1_1_6_5 - 0.038461850649352*G0_1_1_6_6 + 0.04437905844156*G0_1_1_6_7 + 0.0177516233766239*G0_1_1_6_8 - 0.0710064935064959*G0_1_1_6_9 - 0.0133137175324681*G0_1_1_7_0 + 0.00493100649350667*G0_1_1_7_1 - 0.0142999188311693*G0_1_1_7_2 + 0.0414204545454561*G0_1_1_7_3 + 0.041420454545456*G0_1_1_7_4 - 0.0488169642857161*G0_1_1_7_5 + 0.04437905844156*G0_1_1_7_6 - 0.360949675324689*G0_1_1_7_7 + 0.0251481331168842*G0_1_1_7_8 + 0.00887581168831172*G0_1_1_7_9 + 0.00986201298701334*G0_1_1_8_0 - 0.00739650974026006*G0_1_1_8_1 - 0.010355113636364*G0_1_1_8_2 - 0.0739650974025999*G0_1_1_8_3 + 0.0325446428571439*G0_1_1_8_4 + 0.00443790584415604*G0_1_1_8_5 + 0.0177516233766239*G0_1_1_8_6 + 0.0251481331168842*G0_1_1_8_7 - 0.334322240259752*G0_1_1_8_8 - 0.0976339285714319*G0_1_1_8_9 - 0.032544642857144*G0_1_1_9_0 + 0.0108482142857146*G0_1_1_9_1 + 0.0187378246753253*G0_1_1_9_2 - 0.115385551948056*G0_1_1_9_3 - 0.142012987012992*G0_1_1_9_4 + 0.0887581168831198*G0_1_1_9_5 - 0.0710064935064959*G0_1_1_9_6 + 0.00887581168831171*G0_1_1_9_7 - 0.0976339285714319*G0_1_1_9_8 - 0.319529220779232*G0_1_1_9_9;
    A[59] = A[69] - 0.0138068181818187*G0_0_0_0_0 + 0.000657467532467553*G0_0_0_0_1 - 0.000493100649350664*G0_0_0_0_2 - 0.00542410714285734*G0_0_0_0_3 - 0.0172585227272734*G0_0_0_0_4 - 0.00788961038961073*G0_0_0_0_5 + 0.0216964285714293*G0_0_0_0_6 - 0.00147930194805201*G0_0_0_0_7 + 0.00591720779220794*G0_0_0_0_9 + 0.000657467532467552*G0_0_0_1_0 - 0.00460227272727287*G0_0_0_1_1 - 0.004437905844156*G0_0_0_1_2 + 0.01479301948052*G0_0_0_1_3 - 0.008875811688312*G0_0_0_1_4 - 0.0261343344155853*G0_0_0_1_5 + 0.000493100649350681*G0_0_0_1_6 - 0.0108482142857147*G0_0_0_1_7 + 0.00838271103896134*G0_0_0_1_8 - 0.023668831168832*G0_0_0_1_9 - 0.000493100649350664*G0_0_0_2_0 - 0.004437905844156*G0_0_0_2_1 - 0.00986201298701334*G0_0_0_2_2 + 0.0216964285714293*G0_0_0_2_3 - 0.0345170454545466*G0_0_0_2_4 - 0.017751623376624*G0_0_0_2_5 + 0.0443790584415599*G0_0_0_2_6 - 0.00838271103896133*G0_0_0_2_7 + 0.00345170454545468*G0_0_0_2_8 + 0.00591720779220795*G0_0_0_2_9 - 0.00542410714285734*G0_0_0_3_0 + 0.01479301948052*G0_0_0_3_1 + 0.0216964285714293*G0_0_0_3_2 - 0.142012987012992*G0_0_0_3_3 + 0.0310653409090917*G0_0_0_3_4 + 0.0443790584415599*G0_0_0_3_5 + 0.00443790584415595*G0_0_0_3_6 + 0.02218952922078*G0_0_0_3_7 - 0.017751623376624*G0_0_0_3_8 + 0.0266274350649358*G0_0_0_3_9 - 0.0172585227272734*G0_0_0_4_0 - 0.008875811688312*G0_0_0_4_1 - 0.0345170454545466*G0_0_0_4_2 + 0.0310653409090917*G0_0_0_4_3 - 0.514797077922096*G0_0_0_4_4 + 0.057692775974028*G0_0_0_4_5 - 0.062130681818184*G0_0_0_4_6 + 0.035503246753248*G0_0_0_4_7 - 0.00443790584415602*G0_0_0_4_8 - 0.13313717532468*G0_0_0_4_9 - 0.00788961038961073*G0_0_0_5_0 - 0.0261343344155853*G0_0_0_5_1 - 0.017751623376624*G0_0_0_5_2 + 0.0443790584415599*G0_0_0_5_3 + 0.057692775974028*G0_0_0_5_4 - 0.461542207792223*G0_0_0_5_5 - 0.02218952922078*G0_0_0_5_6 - 0.115385551948056*G0_0_0_5_7 + 0.0843202110389639*G0_0_0_5_8 - 0.186392045454552*G0_0_0_5_9 + 0.0216964285714293*G0_0_0_6_0 + 0.000493100649350681*G0_0_0_6_1 + 0.0443790584415599*G0_0_0_6_2 + 0.00443790584415595*G0_0_0_6_3 - 0.062130681818184*G0_0_0_6_4 - 0.02218952922078*G0_0_0_6_5 + 0.0177516233766241*G0_0_0_6_6 + 0.031065340909092*G0_0_0_6_7 - 0.00887581168831202*G0_0_0_6_8 - 0.0266274350649359*G0_0_0_6_9 - 0.00147930194805201*G0_0_0_7_0 - 0.0108482142857147*G0_0_0_7_1 - 0.00838271103896133*G0_0_0_7_2 + 0.02218952922078*G0_0_0_7_3 + 0.035503246753248*G0_0_0_7_4 - 0.115385551948056*G0_0_0_7_5 + 0.031065340909092*G0_0_0_7_6 - 0.071006493506496*G0_0_0_7_7 + 0.035503246753248*G0_0_0_7_8 - 0.0798823051948081*G0_0_0_7_9 + 0.00838271103896134*G0_0_0_8_1 + 0.00345170454545468*G0_0_0_8_2 - 0.017751623376624*G0_0_0_8_3 - 0.00443790584415602*G0_0_0_8_4 + 0.0843202110389639*G0_0_0_8_5 - 0.00887581168831201*G0_0_0_8_6 + 0.035503246753248*G0_0_0_8_7 - 0.017751623376624*G0_0_0_8_8 + 0.079882305194808*G0_0_0_8_9 + 0.00591720779220794*G0_0_0_9_0 - 0.023668831168832*G0_0_0_9_1 + 0.00591720779220795*G0_0_0_9_2 + 0.0266274350649358*G0_0_0_9_3 - 0.13313717532468*G0_0_0_9_4 - 0.186392045454552*G0_0_0_9_5 - 0.0266274350649358*G0_0_0_9_6 - 0.079882305194808*G0_0_0_9_7 + 0.079882305194808*G0_0_0_9_8 - 0.319529220779232*G0_0_0_9_9 - 0.00887581168831205*G0_0_1_0_0 - 0.00197240259740268*G0_0_1_0_1 - 0.0034517045454547*G0_0_1_0_2 + 0.00197240259740266*G0_0_1_0_3 - 0.0305722402597414*G0_0_1_0_4 + 0.00443790584415599*G0_0_1_0_5 - 0.011834415584416*G0_0_1_0_6 + 0.000986201298701307*G0_0_1_0_7 + 0.00394480519480534*G0_0_1_0_8 - 0.00887581168831205*G0_0_1_0_9 - 0.00197240259740268*G0_0_1_1_0 - 0.00493100649350669*G0_0_1_1_1 - 0.00854707792207824*G0_0_1_1_2 + 0.0172585227272733*G0_0_1_1_3 - 0.0197240259740267*G0_0_1_1_4 - 0.00246550324675331*G0_0_1_1_5 - 0.00838271103896136*G0_0_1_1_6 - 0.005917207792208*G0_0_1_1_7 + 0.00739650974025998*G0_0_1_1_8 - 0.00887581168831203*G0_0_1_1_9 - 0.0034517045454547*G0_0_1_2_0 - 0.00854707792207824*G0_0_1_2_1 - 0.0542410714285735*G0_0_1_2_2 + 0.0384618506493521*G0_0_1_2_3 - 0.0665685876623401*G0_0_1_2_4 + 0.00690340909090939*G0_0_1_2_5 - 0.0271205357142868*G0_0_1_2_6 - 0.0113413149350653*G0_0_1_2_7 + 0.00197240259740267*G0_0_1_2_8 - 0.020710227272728*G0_0_1_2_9 + 0.00197240259740266*G0_0_1_3_0 + 0.0172585227272733*G0_0_1_3_1 + 0.038461850649352*G0_0_1_3_2 - 0.159764610389616*G0_0_1_3_3 + 0.0798823051948078*G0_0_1_3_4 - 0.00887581168831202*G0_0_1_3_5 + 0.04437905844156*G0_0_1_3_6 + 0.013313717532468*G0_0_1_3_7 - 0.026627435064936*G0_0_1_3_8 - 0.0305722402597414*G0_0_1_4_0 - 0.0197240259740267*G0_0_1_4_1 - 0.0665685876623401*G0_0_1_4_2 + 0.0798823051948078*G0_0_1_4_3 - 0.639058441558464*G0_0_1_4_4 + 0.1109476461039*G0_0_1_4_5 - 0.15532670454546*G0_0_1_4_6 + 0.053254870129872*G0_0_1_4_7 + 0.013313717532468*G0_0_1_4_8 - 0.159764610389616*G0_0_1_4_9 + 0.00443790584415599*G0_0_1_5_0 - 0.00246550324675331*G0_0_1_5_1 + 0.00690340909090939*G0_0_1_5_2 - 0.00887581168831202*G0_0_1_5_3 + 0.1109476461039*G0_0_1_5_4 - 0.115385551948056*G0_0_1_5_5 + 0.0843202110389641*G0_0_1_5_6 - 0.079882305194808*G0_0_1_5_7 + 0.026627435064936*G0_0_1_5_8 - 0.026627435064936*G0_0_1_5_9 - 0.011834415584416*G0_0_1_6_0 - 0.00838271103896136*G0_0_1_6_1 - 0.0271205357142868*G0_0_1_6_2 + 0.04437905844156*G0_0_1_6_3 - 0.15532670454546*G0_0_1_6_4 + 0.0843202110389641*G0_0_1_6_5 - 0.115385551948056*G0_0_1_6_6 + 0.053254870129872*G0_0_1_6_7 - 0.026627435064936*G0_0_1_6_9 + 0.000986201298701307*G0_0_1_7_0 - 0.005917207792208*G0_0_1_7_1 - 0.0113413149350653*G0_0_1_7_2 + 0.013313717532468*G0_0_1_7_3 + 0.053254870129872*G0_0_1_7_4 - 0.079882305194808*G0_0_1_7_5 + 0.053254870129872*G0_0_1_7_6 - 0.13313717532468*G0_0_1_7_7 + 0.0266274350649361*G0_0_1_7_8 - 0.0798823051948082*G0_0_1_7_9 + 0.00394480519480534*G0_0_1_8_0 + 0.00739650974025998*G0_0_1_8_1 + 0.00197240259740267*G0_0_1_8_2 - 0.026627435064936*G0_0_1_8_3 + 0.013313717532468*G0_0_1_8_4 + 0.026627435064936*G0_0_1_8_5 + 0.0266274350649361*G0_0_1_8_7 - 0.0532548701298723*G0_0_1_8_8 - 0.00887581168831205*G0_0_1_9_0 - 0.00887581168831203*G0_0_1_9_1 - 0.020710227272728*G0_0_1_9_2 - 0.159764610389616*G0_0_1_9_4 - 0.026627435064936*G0_0_1_9_5 - 0.026627435064936*G0_0_1_9_6 - 0.0798823051948082*G0_0_1_9_7 - 0.319529220779232*G0_0_1_9_9 + 0.0305722402597415*G0_1_0_0_0 + 0.00476663961038977*G0_1_0_0_1 + 0.00246550324675335*G0_1_0_0_2 - 0.00394480519480531*G0_1_0_0_3 - 0.0142999188311694*G0_1_0_0_4 + 0.0636099837662359*G0_1_0_0_5 - 0.0029586038961041*G0_1_0_0_6 + 0.0305722402597414*G0_1_0_0_7 - 0.0167654220779227*G0_1_0_0_8 + 0.0325446428571439*G0_1_0_0_9 + 0.00476663961038977*G0_1_0_1_0 - 0.00427353896103911*G0_1_0_1_1 - 0.00180803571428578*G0_1_0_1_2 + 0.0157792207792213*G0_1_0_1_3 - 0.0138068181818187*G0_1_0_1_4 - 0.0172585227272733*G0_1_0_1_5 - 0.0231757305194813*G0_1_0_1_6 + 0.005917207792208*G0_1_0_1_8 - 0.038461850649352*G0_1_0_1_9 + 0.00246550324675335*G0_1_0_2_0 - 0.00180803571428578*G0_1_0_2_1 - 0.01479301948052*G0_1_0_2_2 + 0.017751623376624*G0_1_0_2_3 - 0.0369825487012999*G0_1_0_2_4 + 0.0157792207792213*G0_1_0_2_5 + 0.0320515422077933*G0_1_0_2_6 + 0.00493100649350667*G0_1_0_2_7 - 0.00394480519480532*G0_1_0_2_8 + 0.0207102272727279*G0_1_0_2_9 - 0.00394480519480531*G0_1_0_3_0 + 0.0157792207792213*G0_1_0_3_1 + 0.017751623376624*G0_1_0_3_2 - 0.106509740259744*G0_1_0_3_3 + 0.0399411525974038*G0_1_0_3_4 + 0.0355032467532478*G0_1_0_3_5 + 0.0621306818181838*G0_1_0_3_6 + 0.00443790584415598*G0_1_0_3_7 - 0.00887581168831196*G0_1_0_3_8 + 0.106509740259744*G0_1_0_3_9 - 0.0142999188311694*G0_1_0_4_0 - 0.0138068181818187*G0_1_0_4_1 - 0.0369825487012999*G0_1_0_4_2 + 0.0399411525974038*G0_1_0_4_3 - 0.452666396103912*G0_1_0_4_4 + 0.035503246753248*G0_1_0_4_5 - 0.0976339285714319*G0_1_0_4_6 + 0.017751623376624*G0_1_0_4_7 + 0.00443790584415598*G0_1_0_4_8 - 0.13313717532468*G0_1_0_4_9 + 0.0636099837662359*G0_1_0_5_0 - 0.0172585227272733*G0_1_0_5_1 + 0.0157792207792213*G0_1_0_5_2 + 0.0355032467532478*G0_1_0_5_3 + 0.035503246753248*G0_1_0_5_4 - 0.328405032467543*G0_1_0_5_5 - 0.128699269480524*G0_1_0_5_6 - 0.0221895292207799*G0_1_0_5_7 + 0.0443790584415599*G0_1_0_5_8 - 0.186392045454552*G0_1_0_5_9 - 0.0029586038961041*G0_1_0_6_0 - 0.0231757305194813*G0_1_0_6_1 + 0.0320515422077933*G0_1_0_6_2 + 0.0621306818181838*G0_1_0_6_3 - 0.0976339285714319*G0_1_0_6_4 - 0.128699269480524*G0_1_0_6_5 - 0.328405032467543*G0_1_0_6_6 - 0.02218952922078*G0_1_0_6_7 + 0.0443790584415599*G0_1_0_6_8 - 0.186392045454552*G0_1_0_6_9 + 0.0305722402597414*G0_1_0_7_0 + 0.00493100649350667*G0_1_0_7_2 + 0.00443790584415598*G0_1_0_7_3 + 0.017751623376624*G0_1_0_7_4 - 0.0221895292207799*G0_1_0_7_5 - 0.02218952922078*G0_1_0_7_6 + 0.0532548701298721*G0_1_0_7_7 - 0.013313717532468*G0_1_0_7_8 - 0.0532548701298719*G0_1_0_7_9 - 0.0167654220779227*G0_1_0_8_0 + 0.005917207792208*G0_1_0_8_1 - 0.00394480519480532*G0_1_0_8_2 - 0.00887581168831196*G0_1_0_8_3 + 0.00443790584415598*G0_1_0_8_4 + 0.0443790584415599*G0_1_0_8_5 + 0.0443790584415599*G0_1_0_8_6 - 0.013313717532468*G0_1_0_8_7 + 0.106509740259744*G0_1_0_8_9 + 0.0325446428571439*G0_1_0_9_0 - 0.038461850649352*G0_1_0_9_1 + 0.0207102272727279*G0_1_0_9_2 + 0.106509740259744*G0_1_0_9_3 - 0.13313717532468*G0_1_0_9_4 - 0.186392045454552*G0_1_0_9_5 - 0.186392045454552*G0_1_0_9_6 - 0.0532548701298719*G0_1_0_9_7 + 0.106509740259744*G0_1_0_9_8 - 0.319529220779232*G0_1_0_9_9 + 0.0453652597402616*G0_1_1_0_0 + 0.00657467532467557*G0_1_1_0_1 - 0.0192309253246761*G0_1_1_0_4 + 0.0315584415584428*G0_1_1_0_5 - 0.0187378246753254*G0_1_1_0_6 + 0.0675547889610416*G0_1_1_0_7 - 0.0345170454545467*G0_1_1_0_8 + 0.011834415584416*G0_1_1_0_9 + 0.00657467532467557*G0_1_1_1_0 - 0.00657467532467557*G0_1_1_1_2 + 0.00986201298701334*G0_1_1_1_3 - 0.0138068181818187*G0_1_1_1_4 + 0.00591720779220802*G0_1_1_1_5 - 0.00591720779220802*G0_1_1_1_6 + 0.0138068181818187*G0_1_1_1_7 - 0.00986201298701336*G0_1_1_1_8 - 0.00657467532467557*G0_1_1_2_1 - 0.0453652597402615*G0_1_1_2_2 + 0.0345170454545467*G0_1_1_2_3 - 0.0675547889610414*G0_1_1_2_4 + 0.0187378246753254*G0_1_1_2_5 - 0.0315584415584428*G0_1_1_2_6 + 0.019230925324676*G0_1_1_2_7 - 0.011834415584416*G0_1_1_2_9 + 0.00986201298701334*G0_1_1_3_1 + 0.0345170454545467*G0_1_1_3_2 - 0.106509740259744*G0_1_1_3_3 + 0.0532548701298719*G0_1_1_3_4 - 0.00887581168831205*G0_1_1_3_5 + 0.017751623376624*G0_1_1_3_6 - 0.0192309253246761*G0_1_1_4_0 - 0.0138068181818187*G0_1_1_4_1 - 0.0675547889610414*G0_1_1_4_2 + 0.0532548701298719*G0_1_1_4_3 - 0.505921266233784*G0_1_1_4_4 + 0.057692775974028*G0_1_1_4_5 - 0.0754443993506522*G0_1_1_4_6 - 0.079882305194808*G0_1_1_4_9 + 0.0315584415584428*G0_1_1_5_0 + 0.00591720779220802*G0_1_1_5_1 + 0.0187378246753254*G0_1_1_5_2 - 0.00887581168831205*G0_1_1_5_3 + 0.057692775974028*G0_1_1_5_4 + 0.0754443993506521*G0_1_1_5_7 - 0.0177516233766241*G0_1_1_5_8 - 0.0187378246753254*G0_1_1_6_0 - 0.00591720779220802*G0_1_1_6_1 - 0.0315584415584428*G0_1_1_6_2 + 0.017751623376624*G0_1_1_6_3 - 0.0754443993506522*G0_1_1_6_4 - 0.057692775974028*G0_1_1_6_7 + 0.00887581168831204*G0_1_1_6_8 + 0.0675547889610416*G0_1_1_7_0 + 0.0138068181818187*G0_1_1_7_1 + 0.019230925324676*G0_1_1_7_2 + 0.0754443993506521*G0_1_1_7_5 - 0.057692775974028*G0_1_1_7_6 + 0.505921266233785*G0_1_1_7_7 - 0.0532548701298722*G0_1_1_7_8 + 0.0798823051948082*G0_1_1_7_9 - 0.0345170454545467*G0_1_1_8_0 - 0.00986201298701336*G0_1_1_8_1 - 0.0177516233766241*G0_1_1_8_5 + 0.00887581168831204*G0_1_1_8_6 - 0.0532548701298722*G0_1_1_8_7 + 0.106509740259744*G0_1_1_8_8 + 0.011834415584416*G0_1_1_9_0 - 0.011834415584416*G0_1_1_9_2 - 0.079882305194808*G0_1_1_9_4 + 0.0798823051948082*G0_1_1_9_7;
    A[49] = -A[69] - 0.00953327922077963*G0_1_0_0_0 + 0.000767045454545473*G0_1_0_0_2 - 0.0123275162337667*G0_1_0_0_3 - 0.011834415584416*G0_1_0_0_4 - 0.0152861201298706*G0_1_0_0_5 - 0.00986201298701327*G0_1_0_0_6 - 0.00591720779220801*G0_1_0_0_7 + 0.00493100649350666*G0_1_0_0_8 - 0.0433928571428586*G0_1_0_0_9 + 0.00953327922077948*G0_1_0_1_1 - 0.000767045454545486*G0_1_0_1_2 + 0.0152861201298706*G0_1_0_1_3 + 0.00986201298701335*G0_1_0_1_4 + 0.0123275162337666*G0_1_0_1_5 + 0.011834415584416*G0_1_0_1_6 - 0.00493100649350665*G0_1_0_1_7 + 0.00591720779220796*G0_1_0_1_8 + 0.0433928571428586*G0_1_0_1_9 + 0.000767045454545473*G0_1_0_2_0 - 0.000767045454545486*G0_1_0_2_1 + 0.00493100649350667*G0_1_0_2_3 + 0.0246550324675333*G0_1_0_2_4 - 0.00493100649350663*G0_1_0_2_5 - 0.0246550324675333*G0_1_0_2_6 - 0.00394480519480533*G0_1_0_2_7 + 0.00394480519480532*G0_1_0_2_8 - 0.0123275162337667*G0_1_0_3_0 + 0.0152861201298706*G0_1_0_3_1 + 0.00493100649350667*G0_1_0_3_2 - 0.254439935064944*G0_1_0_3_3 - 0.0680478896103921*G0_1_0_3_4 - 0.0355032467532479*G0_1_0_3_6 + 0.0369825487013*G0_1_0_3_7 - 0.0251481331168841*G0_1_0_3_8 - 0.204143668831176*G0_1_0_3_9 - 0.011834415584416*G0_1_0_4_0 + 0.00986201298701335*G0_1_0_4_1 + 0.0246550324675333*G0_1_0_4_2 - 0.0680478896103921*G0_1_0_4_3 - 0.1479301948052*G0_1_0_4_4 + 0.0355032467532479*G0_1_0_4_5 + 0.023668831168832*G0_1_0_4_7 - 0.011834415584416*G0_1_0_4_8 - 0.071006493506496*G0_1_0_4_9 - 0.0152861201298706*G0_1_0_5_0 + 0.0123275162337666*G0_1_0_5_1 - 0.00493100649350664*G0_1_0_5_2 + 0.0355032467532479*G0_1_0_5_4 + 0.254439935064943*G0_1_0_5_5 + 0.0680478896103919*G0_1_0_5_6 + 0.0251481331168839*G0_1_0_5_7 - 0.0369825487012999*G0_1_0_5_8 + 0.204143668831176*G0_1_0_5_9 - 0.00986201298701327*G0_1_0_6_0 + 0.011834415584416*G0_1_0_6_1 - 0.0246550324675333*G0_1_0_6_2 - 0.0355032467532479*G0_1_0_6_3 + 0.0680478896103919*G0_1_0_6_5 + 0.1479301948052*G0_1_0_6_6 + 0.011834415584416*G0_1_0_6_7 - 0.0236688311688319*G0_1_0_6_8 + 0.0710064935064959*G0_1_0_6_9 - 0.00591720779220801*G0_1_0_7_0 - 0.00493100649350665*G0_1_0_7_1 - 0.00394480519480533*G0_1_0_7_2 + 0.0369825487013*G0_1_0_7_3 + 0.023668831168832*G0_1_0_7_4 + 0.0251481331168839*G0_1_0_7_5 + 0.011834415584416*G0_1_0_7_6 - 0.0266274350649361*G0_1_0_7_7 + 0.106509740259744*G0_1_0_7_9 + 0.00493100649350666*G0_1_0_8_0 + 0.00591720779220796*G0_1_0_8_1 + 0.00394480519480532*G0_1_0_8_2 - 0.0251481331168841*G0_1_0_8_3 - 0.011834415584416*G0_1_0_8_4 - 0.0369825487012999*G0_1_0_8_5 - 0.0236688311688319*G0_1_0_8_6 + 0.0266274350649359*G0_1_0_8_8 - 0.106509740259744*G0_1_0_8_9 - 0.0433928571428586*G0_1_0_9_0 + 0.0433928571428586*G0_1_0_9_1 - 0.204143668831176*G0_1_0_9_3 - 0.071006493506496*G0_1_0_9_4 + 0.204143668831176*G0_1_0_9_5 + 0.0710064935064959*G0_1_0_9_6 + 0.106509740259744*G0_1_0_9_7 - 0.106509740259744*G0_1_0_9_8 - 0.0210389610389619*G0_1_1_0_0 - 0.00432832792207809*G0_1_1_0_1 + 0.00202719155844164*G0_1_1_0_2 - 0.013313717532468*G0_1_1_0_3 - 0.0138068181818187*G0_1_1_0_4 - 0.00295860389610404*G0_1_1_0_5 - 0.000986201298701314*G0_1_1_0_6 - 0.0133137175324681*G0_1_1_0_7 + 0.00986201298701334*G0_1_1_0_8 - 0.032544642857144*G0_1_1_0_9 - 0.00432832792207809*G0_1_1_1_0 - 0.0115056818181823*G0_1_1_1_1 + 0.00126014610389615*G0_1_1_1_2 + 0.0123275162337666*G0_1_1_1_3 + 0.00887581168831202*G0_1_1_1_4 - 0.000986201298701337*G0_1_1_1_5 - 0.00197240259740266*G0_1_1_1_6 + 0.00493100649350667*G0_1_1_1_7 - 0.00739650974026005*G0_1_1_1_8 + 0.0108482142857146*G0_1_1_1_9 + 0.00202719155844164*G0_1_1_2_0 + 0.00126014610389615*G0_1_1_2_1 + 0.0175324675324682*G0_1_1_2_2 - 0.00690340909090932*G0_1_1_2_3 + 0.04437905844156*G0_1_1_2_4 - 0.011834415584416*G0_1_1_2_5 + 0.0197240259740267*G0_1_1_2_6 - 0.0142999188311693*G0_1_1_2_7 - 0.010355113636364*G0_1_1_2_8 + 0.0187378246753253*G0_1_1_2_9 - 0.013313717532468*G0_1_1_3_0 + 0.0123275162337666*G0_1_1_3_1 - 0.00690340909090932*G0_1_1_3_2 - 0.257398538961048*G0_1_1_3_3 - 0.0488169642857162*G0_1_1_3_4 + 0.020710227272728*G0_1_1_3_5 + 0.00739650974025994*G0_1_1_3_6 + 0.0414204545454561*G0_1_1_3_7 - 0.0739650974025999*G0_1_1_3_8 - 0.115385551948056*G0_1_1_3_9 - 0.0138068181818187*G0_1_1_4_0 + 0.00887581168831202*G0_1_1_4_1 + 0.04437905844156*G0_1_1_4_2 - 0.0488169642857162*G0_1_1_4_3 - 0.186392045454552*G0_1_1_4_4 + 0.042899756493508*G0_1_1_4_5 - 0.0502962662337679*G0_1_1_4_6 + 0.041420454545456*G0_1_1_4_7 + 0.0325446428571439*G0_1_1_4_8 - 0.142012987012992*G0_1_1_4_9 - 0.00295860389610404*G0_1_1_5_0 - 0.000986201298701338*G0_1_1_5_1 - 0.011834415584416*G0_1_1_5_2 + 0.020710227272728*G0_1_1_5_3 + 0.0428997564935079*G0_1_1_5_4 - 0.00295860389610408*G0_1_1_5_5 + 0.019230925324676*G0_1_1_5_6 - 0.0488169642857161*G0_1_1_5_7 + 0.00443790584415604*G0_1_1_5_8 + 0.0887581168831198*G0_1_1_5_9 - 0.000986201298701316*G0_1_1_6_0 - 0.00197240259740266*G0_1_1_6_1 + 0.0197240259740267*G0_1_1_6_2 + 0.00739650974025994*G0_1_1_6_3 - 0.0502962662337679*G0_1_1_6_4 + 0.019230925324676*G0_1_1_6_5 - 0.038461850649352*G0_1_1_6_6 + 0.04437905844156*G0_1_1_6_7 + 0.0177516233766239*G0_1_1_6_8 - 0.0710064935064959*G0_1_1_6_9 - 0.0133137175324681*G0_1_1_7_0 + 0.00493100649350667*G0_1_1_7_1 - 0.0142999188311693*G0_1_1_7_2 + 0.0414204545454561*G0_1_1_7_3 + 0.041420454545456*G0_1_1_7_4 - 0.0488169642857161*G0_1_1_7_5 + 0.04437905844156*G0_1_1_7_6 - 0.360949675324689*G0_1_1_7_7 + 0.0251481331168842*G0_1_1_7_8 + 0.00887581168831172*G0_1_1_7_9 + 0.00986201298701334*G0_1_1_8_0 - 0.00739650974026006*G0_1_1_8_1 - 0.010355113636364*G0_1_1_8_2 - 0.0739650974025999*G0_1_1_8_3 + 0.0325446428571439*G0_1_1_8_4 + 0.00443790584415604*G0_1_1_8_5 + 0.0177516233766239*G0_1_1_8_6 + 0.0251481331168842*G0_1_1_8_7 - 0.334322240259752*G0_1_1_8_8 - 0.0976339285714319*G0_1_1_8_9 - 0.032544642857144*G0_1_1_9_0 + 0.0108482142857146*G0_1_1_9_1 + 0.0187378246753253*G0_1_1_9_2 - 0.115385551948056*G0_1_1_9_3 - 0.142012987012992*G0_1_1_9_4 + 0.0887581168831198*G0_1_1_9_5 - 0.0710064935064959*G0_1_1_9_6 + 0.00887581168831171*G0_1_1_9_7 - 0.0976339285714319*G0_1_1_9_8 - 0.319529220779232*G0_1_1_9_9;
    A[81] = -A[31] - 0.0107021103896107*G0_0_0_0_0 - 0.00522017045454566*G0_0_0_0_1 - 0.00155235389610395*G0_0_0_0_2 - 0.00168932629870137*G0_0_0_0_3 - 0.0013331980519481*G0_0_0_0_4 - 0.00590807629870149*G0_0_0_0_5 + 0.00154322240259743*G0_0_0_0_6 + 0.000374391233766265*G0_0_0_0_7 - 0.00214590097402607*G0_0_0_0_8 - 0.000821834415584454*G0_0_0_0_9 - 0.00522017045454566*G0_0_0_1_0 - 0.0932021103896135*G0_0_0_1_1 - 0.00522017045454563*G0_0_0_1_2 - 0.0452008928571443*G0_0_0_1_3 + 0.0208198051948059*G0_0_0_1_4 - 0.000593547077922093*G0_0_0_1_5 - 0.000593547077922107*G0_0_0_1_6 + 0.020819805194806*G0_0_0_1_7 - 0.0452008928571446*G0_0_0_1_8 - 0.00712256493506522*G0_0_0_1_9 - 0.00155235389610395*G0_0_0_2_0 - 0.00522017045454563*G0_0_0_2_1 - 0.0107021103896108*G0_0_0_2_2 - 0.00214590097402603*G0_0_0_2_3 + 0.000374391233766224*G0_0_0_2_4 + 0.00154322240259747*G0_0_0_2_5 - 0.00590807629870154*G0_0_0_2_6 - 0.00133319805194809*G0_0_0_2_7 - 0.00168932629870136*G0_0_0_2_8 - 0.000821834415584454*G0_0_0_2_9 - 0.00168932629870136*G0_0_0_3_0 - 0.0452008928571443*G0_0_0_3_1 - 0.00214590097402603*G0_0_0_3_2 - 0.0378043831168843*G0_0_0_3_3 + 0.0201349431818188*G0_0_0_3_4 + 0.00123275162337665*G0_0_0_3_5 + 0.00616375811688333*G0_0_0_3_6 + 0.00945109577922114*G0_0_0_3_7 - 0.0189021915584423*G0_0_0_3_8 + 0.00246550324675333*G0_0_0_3_9 - 0.0013331980519481*G0_0_0_4_0 + 0.0208198051948059*G0_0_0_4_1 + 0.000374391233766224*G0_0_0_4_2 + 0.0201349431818188*G0_0_0_4_3 - 0.0368181818181831*G0_0_0_4_4 + 0.00838271103896133*G0_0_0_4_5 - 0.0145464691558447*G0_0_0_4_6 + 0.00180803571428576*G0_0_0_4_7 + 0.00945109577922113*G0_0_0_4_8 - 0.0142999188311693*G0_0_0_4_9 - 0.00590807629870149*G0_0_0_5_0 - 0.000593547077922093*G0_0_0_5_1 + 0.00154322240259747*G0_0_0_5_2 + 0.00123275162337665*G0_0_0_5_3 + 0.00838271103896133*G0_0_0_5_4 - 0.0613088474025994*G0_0_0_5_5 + 0.0146286525974031*G0_0_0_5_6 - 0.0145464691558446*G0_0_0_5_7 + 0.00616375811688333*G0_0_0_5_8 - 0.00986201298701333*G0_0_0_5_9 + 0.00154322240259743*G0_0_0_6_0 - 0.000593547077922107*G0_0_0_6_1 - 0.00590807629870154*G0_0_0_6_2 + 0.00616375811688333*G0_0_0_6_3 - 0.0145464691558447*G0_0_0_6_4 + 0.0146286525974031*G0_0_0_6_5 - 0.0613088474025995*G0_0_0_6_6 + 0.00838271103896132*G0_0_0_6_7 + 0.00123275162337666*G0_0_0_6_8 - 0.00986201298701331*G0_0_0_6_9 + 0.000374391233766264*G0_0_0_7_0 + 0.020819805194806*G0_0_0_7_1 - 0.00133319805194809*G0_0_0_7_2 + 0.00945109577922114*G0_0_0_7_3 + 0.00180803571428576*G0_0_0_7_4 - 0.0145464691558446*G0_0_0_7_5 + 0.00838271103896132*G0_0_0_7_6 - 0.0368181818181832*G0_0_0_7_7 + 0.020134943181819*G0_0_0_7_8 - 0.0142999188311693*G0_0_0_7_9 - 0.00214590097402608*G0_0_0_8_0 - 0.0452008928571446*G0_0_0_8_1 - 0.00168932629870136*G0_0_0_8_2 - 0.0189021915584423*G0_0_0_8_3 + 0.00945109577922113*G0_0_0_8_4 + 0.00616375811688333*G0_0_0_8_5 + 0.00123275162337666*G0_0_0_8_6 + 0.020134943181819*G0_0_0_8_7 - 0.0378043831168846*G0_0_0_8_8 + 0.00246550324675333*G0_0_0_8_9 - 0.000821834415584454*G0_0_0_9_0 - 0.00712256493506522*G0_0_0_9_1 - 0.000821834415584453*G0_0_0_9_2 + 0.00246550324675333*G0_0_0_9_3 - 0.0142999188311693*G0_0_0_9_4 - 0.00986201298701333*G0_0_0_9_5 - 0.00986201298701331*G0_0_0_9_6 - 0.0142999188311693*G0_0_0_9_7 + 0.00246550324675333*G0_0_0_9_8 - 0.104537337662341*G0_0_0_9_9;
    A[7] = A[81] - 0.0987966720779254*G0_0_0_0_0 - 0.00557021103896122*G0_0_0_0_2 + 0.00758827110389641*G0_0_0_0_3 - 0.00131493506493512*G0_0_0_0_4 - 0.062742491883119*G0_0_0_0_5 + 0.0276318993506503*G0_0_0_0_6 - 0.0589163961038981*G0_0_0_0_7 + 0.0328003246753258*G0_0_0_0_8 - 0.00909496753246787*G0_0_0_0_9 + 0.0987966720779254*G0_0_0_1_1 + 0.00557021103896122*G0_0_0_1_2 + 0.062742491883119*G0_0_0_1_3 - 0.0276318993506503*G0_0_0_1_4 - 0.00758827110389636*G0_0_0_1_5 + 0.00131493506493511*G0_0_0_1_6 - 0.0328003246753259*G0_0_0_1_7 + 0.0589163961038983*G0_0_0_1_8 + 0.00909496753246789*G0_0_0_1_9 - 0.00557021103896122*G0_0_0_2_0 + 0.00557021103896122*G0_0_0_2_1 + 0.0100994318181822*G0_0_0_2_3 - 0.00381696428571441*G0_0_0_2_4 - 0.0100994318181822*G0_0_0_2_5 + 0.00381696428571442*G0_0_0_2_6 - 0.00668425324675348*G0_0_0_2_7 + 0.00668425324675348*G0_0_0_2_8 + 0.00758827110389641*G0_0_0_3_0 + 0.062742491883119*G0_0_0_3_1 + 0.0100994318181822*G0_0_0_3_2 + 0.105194805194809*G0_0_0_3_3 - 0.0452008928571444*G0_0_0_3_4 - 0.00394480519480534*G0_0_0_3_6 - 0.0227648133116892*G0_0_0_3_7 + 0.0428175730519497*G0_0_0_3_8 + 0.0182447240259748*G0_0_0_3_9 - 0.00131493506493512*G0_0_0_4_0 - 0.0276318993506503*G0_0_0_4_1 - 0.00381696428571441*G0_0_0_4_2 - 0.0452008928571444*G0_0_0_4_3 + 0.00558847402597418*G0_0_0_4_4 + 0.00394480519480535*G0_0_0_4_5 + 0.0119987824675329*G0_0_0_4_7 - 0.0200527597402605*G0_0_0_4_8 - 0.0078896103896107*G0_0_0_4_9 - 0.062742491883119*G0_0_0_5_0 - 0.00758827110389636*G0_0_0_5_1 - 0.0100994318181822*G0_0_0_5_2 + 0.00394480519480535*G0_0_0_5_4 - 0.105194805194809*G0_0_0_5_5 + 0.0452008928571443*G0_0_0_5_6 - 0.0428175730519495*G0_0_0_5_7 + 0.0227648133116891*G0_0_0_5_8 - 0.0182447240259747*G0_0_0_5_9 + 0.0276318993506503*G0_0_0_6_0 + 0.00131493506493511*G0_0_0_6_1 + 0.00381696428571442*G0_0_0_6_2 - 0.00394480519480534*G0_0_0_6_3 + 0.0452008928571443*G0_0_0_6_5 - 0.00558847402597417*G0_0_0_6_6 + 0.0200527597402604*G0_0_0_6_7 - 0.0119987824675329*G0_0_0_6_8 + 0.00788961038961067*G0_0_0_6_9 - 0.0589163961038981*G0_0_0_7_0 - 0.0328003246753259*G0_0_0_7_1 - 0.00668425324675348*G0_0_0_7_2 - 0.0227648133116892*G0_0_0_7_3 + 0.0119987824675329*G0_0_0_7_4 - 0.0428175730519495*G0_0_0_7_5 + 0.0200527597402604*G0_0_0_7_6 - 0.0330377435064945*G0_0_0_7_7 - 0.0128206168831174*G0_0_0_7_9 + 0.0328003246753258*G0_0_0_8_0 + 0.0589163961038983*G0_0_0_8_1 + 0.00668425324675349*G0_0_0_8_2 + 0.0428175730519497*G0_0_0_8_3 - 0.0200527597402605*G0_0_0_8_4 + 0.0227648133116891*G0_0_0_8_5 - 0.0119987824675329*G0_0_0_8_6 + 0.0330377435064948*G0_0_0_8_8 + 0.0128206168831174*G0_0_0_8_9 - 0.00909496753246787*G0_0_0_9_0 + 0.00909496753246788*G0_0_0_9_1 + 0.0182447240259748*G0_0_0_9_3 - 0.0078896103896107*G0_0_0_9_4 - 0.0182447240259747*G0_0_0_9_5 + 0.00788961038961067*G0_0_0_9_6 - 0.0128206168831174*G0_0_0_9_7 + 0.0128206168831174*G0_0_0_9_8 + 0.015767045454546*G0_0_1_0_0 + 0.00169237012987019*G0_0_1_0_1 + 0.00132102272727277*G0_0_1_0_2 - 0.00188108766233773*G0_0_1_0_3 - 0.000949675324675362*G0_0_1_0_4 + 0.011870941558442*G0_0_1_0_5 - 0.00593547077922098*G0_0_1_0_6 + 0.023741883116884*G0_0_1_0_7 - 0.00995332792207828*G0_0_1_0_8 + 0.00383522727272741*G0_0_1_0_9 + 0.00169237012987019*G0_0_1_1_0 - 0.00904017857142887*G0_0_1_1_1 - 0.000210024350649356*G0_0_1_1_2 - 0.00712256493506517*G0_0_1_1_3 + 0.00257508116883125*G0_0_1_1_4 + 0.00389914772727286*G0_0_1_1_5 - 0.00242897727272735*G0_0_1_1_6 + 0.00898538961038993*G0_0_1_1_7 - 0.00465706168831186*G0_0_1_1_8 + 0.00295860389610399*G0_0_1_1_9 + 0.00132102272727277*G0_0_1_2_0 - 0.000210024350649356*G0_0_1_2_1 - 0.000529626623376646*G0_0_1_2_2 - 0.00159801136363641*G0_0_1_2_3 + 0.000292207792207797*G0_0_1_2_4 + 0.00389914772727286*G0_0_1_2_5 - 0.00147017045454551*G0_0_1_2_6 + 0.00554281655844175*G0_0_1_2_7 - 0.00393567370129883*G0_0_1_2_8 + 0.0010409902597403*G0_0_1_2_9 - 0.00188108766233773*G0_0_1_3_0 - 0.00712256493506517*G0_0_1_3_1 - 0.00159801136363641*G0_0_1_3_2 - 0.0424066558441573*G0_0_1_3_3 + 0.0076430600649353*G0_0_1_3_4 - 0.00106838474025978*G0_0_1_3_5 + 0.00336952110389622*G0_0_1_3_6 + 0.00172585227272732*G0_0_1_3_7 - 0.00961546266233799*G0_0_1_3_8 - 0.0123275162337667*G0_0_1_3_9 - 0.000949675324675362*G0_0_1_4_0 + 0.00257508116883125*G0_0_1_4_1 + 0.000292207792207797*G0_0_1_4_2 + 0.0076430600649353*G0_0_1_4_3 - 0.0202171266233773*G0_0_1_4_4 - 0.00106838474025978*G0_0_1_4_5 - 0.00230113636363644*G0_0_1_4_6 - 0.00493100649350667*G0_0_1_4_7 + 0.00788961038961067*G0_0_1_4_8 - 0.000986201298701332*G0_0_1_4_9 + 0.011870941558442*G0_0_1_5_0 + 0.00389914772727286*G0_0_1_5_1 + 0.00389914772727286*G0_0_1_5_2 - 0.00106838474025978*G0_0_1_5_3 - 0.00106838474025978*G0_0_1_5_4 + 0.0361607142857155*G0_0_1_5_5 - 0.0156148538961044*G0_0_1_5_6 + 0.0361607142857155*G0_0_1_5_7 - 0.0156148538961044*G0_0_1_5_8 + 0.0197240259740267*G0_0_1_5_9 - 0.00593547077922098*G0_0_1_6_0 - 0.00242897727272735*G0_0_1_6_1 - 0.00147017045454551*G0_0_1_6_2 + 0.00336952110389622*G0_0_1_6_3 - 0.00230113636363644*G0_0_1_6_4 - 0.0156148538961044*G0_0_1_6_5 + 0.00410917207792223*G0_0_1_6_6 - 0.0205458603896111*G0_0_1_6_7 + 0.0115056818181822*G0_0_1_6_8 - 0.00986201298701334*G0_0_1_6_9 + 0.023741883116884*G0_0_1_7_0 + 0.00898538961038993*G0_0_1_7_1 + 0.00554281655844175*G0_0_1_7_2 + 0.00172585227272732*G0_0_1_7_3 - 0.00493100649350668*G0_0_1_7_4 + 0.0361607142857155*G0_0_1_7_5 - 0.0205458603896111*G0_0_1_7_6 + 0.108482142857147*G0_0_1_7_7 - 0.0320515422077934*G0_0_1_7_8 + 0.02958603896104*G0_0_1_7_9 - 0.00995332792207828*G0_0_1_8_0 - 0.00465706168831186*G0_0_1_8_1 - 0.00393567370129883*G0_0_1_8_2 - 0.00961546266233799*G0_0_1_8_3 + 0.00788961038961067*G0_0_1_8_4 - 0.0156148538961044*G0_0_1_8_5 + 0.0115056818181822*G0_0_1_8_6 - 0.0320515422077934*G0_0_1_8_7 - 0.0123275162337667*G0_0_1_8_8 - 0.0246550324675333*G0_0_1_8_9 + 0.00383522727272741*G0_0_1_9_0 + 0.00295860389610399*G0_0_1_9_1 + 0.0010409902597403*G0_0_1_9_2 - 0.0123275162337667*G0_0_1_9_3 - 0.000986201298701333*G0_0_1_9_4 + 0.0197240259740267*G0_0_1_9_5 - 0.00986201298701334*G0_0_1_9_6 + 0.02958603896104*G0_0_1_9_7 - 0.0246550324675333*G0_0_1_9_8 - 0.0394480519480532*G0_0_1_9_9 - 0.107836850649354*G0_1_0_0_0 + 0.00169237012987023*G0_1_0_0_1 - 0.00578023538961058*G0_1_0_0_2 + 0.0114874188311693*G0_1_0_0_3 - 0.00374391233766248*G0_1_0_0_4 - 0.0698650568181841*G0_1_0_0_5 + 0.0302069805194815*G0_1_0_0_6 - 0.06357345779221*G0_1_0_0_7 + 0.0417857142857158*G0_1_0_0_8 - 0.00613636363636387*G0_1_0_0_9 + 0.00169237012987023*G0_1_0_1_0 + 0.114563717532472*G0_1_0_1_1 + 0.006891233766234*G0_1_0_1_2 + 0.074613433441561*G0_1_0_1_3 - 0.0335673701298713*G0_1_0_1_4 - 0.00946935876623409*G0_1_0_1_5 + 0.000365259740259748*G0_1_0_1_6 - 0.0427536525974042*G0_1_0_1_7 + 0.0826582792207823*G0_1_0_1_8 + 0.0129301948051953*G0_1_0_1_9 - 0.00578023538961058*G0_1_0_2_0 + 0.006891233766234*G0_1_0_2_1 - 0.000529626623376635*G0_1_0_2_2 + 0.013998579545455*G0_1_0_2_3 - 0.00528713474025992*G0_1_0_2_4 - 0.0116974431818186*G0_1_0_2_5 + 0.00410917207792222*G0_1_0_2_6 - 0.0106199269480523*G0_1_0_2_7 + 0.0122270698051952*G0_1_0_2_8 + 0.0010409902597403*G0_1_0_2_9 + 0.0114874188311693*G0_1_0_3_0 + 0.074613433441561*G0_1_0_3_1 + 0.013998579545455*G0_1_0_3_2 + 0.141355519480525*G0_1_0_3_3 - 0.0608157467532489*G0_1_0_3_4 - 0.0010683847402598*G0_1_0_3_5 - 0.00501318993506513*G0_1_0_3_6 - 0.0383796672077937*G0_1_0_3_7 + 0.0789782873376653*G0_1_0_3_8 + 0.0379687500000015*G0_1_0_3_9 - 0.00374391233766248*G0_1_0_4_0 - 0.0335673701298713*G0_1_0_4_1 - 0.00528713474025992*G0_1_0_4_2 - 0.0608157467532489*G0_1_0_4_3 + 0.00969764610389642*G0_1_0_4_4 + 0.00731432629870157*G0_1_0_4_5 - 0.00230113636363644*G0_1_0_4_6 + 0.0235044642857151*G0_1_0_4_7 - 0.0405986201298716*G0_1_0_4_8 - 0.017751623376624*G0_1_0_4_9 - 0.0698650568181841*G0_1_0_5_0 - 0.00946935876623409*G0_1_0_5_1 - 0.0116974431818186*G0_1_0_5_2 - 0.0010683847402598*G0_1_0_5_3 + 0.00731432629870157*G0_1_0_5_4 - 0.147601461038966*G0_1_0_5_5 + 0.0528439529220797*G0_1_0_5_6 - 0.0524330357142875*G0_1_0_5_7 + 0.0244906655844164*G0_1_0_5_8 - 0.0305722402597414*G0_1_0_5_9 + 0.0302069805194815*G0_1_0_6_0 + 0.000365259740259749*G0_1_0_6_1 + 0.00410917207792222*G0_1_0_6_2 - 0.00501318993506513*G0_1_0_6_3 - 0.00230113636363644*G0_1_0_6_4 + 0.0528439529220797*G0_1_0_6_5 - 0.0258056006493515*G0_1_0_6_6 + 0.0279423701298711*G0_1_0_6_7 - 0.0169297889610395*G0_1_0_6_8 + 0.00690340909090934*G0_1_0_6_9 - 0.06357345779221*G0_1_0_7_0 - 0.0427536525974042*G0_1_0_7_1 - 0.0106199269480523*G0_1_0_7_2 - 0.0383796672077937*G0_1_0_7_3 + 0.0235044642857151*G0_1_0_7_4 - 0.0524330357142875*G0_1_0_7_5 + 0.0279423701298711*G0_1_0_7_6 - 0.0453652597402612*G0_1_0_7_7 - 0.0320515422077935*G0_1_0_7_8 - 0.0374756493506507*G0_1_0_7_9 + 0.0417857142857158*G0_1_0_8_0 + 0.0826582792207823*G0_1_0_8_1 + 0.0122270698051952*G0_1_0_8_2 + 0.0789782873376653*G0_1_0_8_3 - 0.0405986201298716*G0_1_0_8_4 + 0.0244906655844164*G0_1_0_8_5 - 0.0169297889610395*G0_1_0_8_6 - 0.0320515422077935*G0_1_0_8_7 + 0.141519886363642*G0_1_0_8_8 + 0.0424066558441574*G0_1_0_8_9 - 0.00613636363636388*G0_1_0_9_0 + 0.0129301948051953*G0_1_0_9_1 + 0.0010409902597403*G0_1_0_9_2 + 0.0379687500000015*G0_1_0_9_3 - 0.017751623376624*G0_1_0_9_4 - 0.0305722402597414*G0_1_0_9_5 + 0.00690340909090934*G0_1_0_9_6 - 0.0374756493506507*G0_1_0_9_7 + 0.0424066558441574*G0_1_0_9_8 - 0.0394480519480532*G0_1_0_9_9 + 0.015767045454546*G0_1_1_0_0 + 0.00169237012987019*G0_1_1_0_1 + 0.00132102272727277*G0_1_1_0_2 - 0.00188108766233773*G0_1_1_0_3 - 0.000949675324675362*G0_1_1_0_4 + 0.011870941558442*G0_1_1_0_5 - 0.00593547077922098*G0_1_1_0_6 + 0.023741883116884*G0_1_1_0_7 - 0.00995332792207828*G0_1_1_0_8 + 0.00383522727272741*G0_1_1_0_9 + 0.00169237012987019*G0_1_1_1_0 - 0.00904017857142886*G0_1_1_1_1 - 0.000210024350649356*G0_1_1_1_2 - 0.00712256493506516*G0_1_1_1_3 + 0.00257508116883124*G0_1_1_1_4 + 0.00389914772727286*G0_1_1_1_5 - 0.00242897727272736*G0_1_1_1_6 + 0.00898538961038993*G0_1_1_1_7 - 0.00465706168831186*G0_1_1_1_8 + 0.00295860389610399*G0_1_1_1_9 + 0.00132102272727277*G0_1_1_2_0 - 0.000210024350649356*G0_1_1_2_1 - 0.000529626623376646*G0_1_1_2_2 - 0.00159801136363641*G0_1_1_2_3 + 0.000292207792207796*G0_1_1_2_4 + 0.00389914772727286*G0_1_1_2_5 - 0.00147017045454551*G0_1_1_2_6 + 0.00554281655844175*G0_1_1_2_7 - 0.00393567370129883*G0_1_1_2_8 + 0.0010409902597403*G0_1_1_2_9 - 0.00188108766233773*G0_1_1_3_0 - 0.00712256493506516*G0_1_1_3_1 - 0.00159801136363641*G0_1_1_3_2 - 0.0424066558441572*G0_1_1_3_3 + 0.00764306006493529*G0_1_1_3_4 - 0.00106838474025978*G0_1_1_3_5 + 0.00336952110389622*G0_1_1_3_6 + 0.00172585227272732*G0_1_1_3_7 - 0.00961546266233798*G0_1_1_3_8 - 0.0123275162337667*G0_1_1_3_9 - 0.000949675324675362*G0_1_1_4_0 + 0.00257508116883124*G0_1_1_4_1 + 0.000292207792207796*G0_1_1_4_2 + 0.00764306006493529*G0_1_1_4_3 - 0.0202171266233773*G0_1_1_4_4 - 0.00106838474025978*G0_1_1_4_5 - 0.00230113636363644*G0_1_1_4_6 - 0.00493100649350668*G0_1_1_4_7 + 0.00788961038961066*G0_1_1_4_8 - 0.000986201298701344*G0_1_1_4_9 + 0.011870941558442*G0_1_1_5_0 + 0.00389914772727286*G0_1_1_5_1 + 0.00389914772727286*G0_1_1_5_2 - 0.00106838474025978*G0_1_1_5_3 - 0.00106838474025978*G0_1_1_5_4 + 0.0361607142857155*G0_1_1_5_5 - 0.0156148538961044*G0_1_1_5_6 + 0.0361607142857155*G0_1_1_5_7 - 0.0156148538961044*G0_1_1_5_8 + 0.0197240259740267*G0_1_1_5_9 - 0.00593547077922098*G0_1_1_6_0 - 0.00242897727272736*G0_1_1_6_1 - 0.00147017045454551*G0_1_1_6_2 + 0.00336952110389622*G0_1_1_6_3 - 0.00230113636363644*G0_1_1_6_4 - 0.0156148538961044*G0_1_1_6_5 + 0.00410917207792223*G0_1_1_6_6 - 0.0205458603896111*G0_1_1_6_7 + 0.0115056818181822*G0_1_1_6_8 - 0.00986201298701334*G0_1_1_6_9 + 0.023741883116884*G0_1_1_7_0 + 0.00898538961038993*G0_1_1_7_1 + 0.00554281655844175*G0_1_1_7_2 + 0.00172585227272732*G0_1_1_7_3 - 0.00493100649350668*G0_1_1_7_4 + 0.0361607142857155*G0_1_1_7_5 - 0.0205458603896111*G0_1_1_7_6 + 0.108482142857147*G0_1_1_7_7 - 0.0320515422077934*G0_1_1_7_8 + 0.02958603896104*G0_1_1_7_9 - 0.00995332792207828*G0_1_1_8_0 - 0.00465706168831186*G0_1_1_8_1 - 0.00393567370129883*G0_1_1_8_2 - 0.00961546266233798*G0_1_1_8_3 + 0.00788961038961066*G0_1_1_8_4 - 0.0156148538961044*G0_1_1_8_5 + 0.0115056818181822*G0_1_1_8_6 - 0.0320515422077934*G0_1_1_8_7 - 0.0123275162337666*G0_1_1_8_8 - 0.0246550324675333*G0_1_1_8_9 + 0.00383522727272741*G0_1_1_9_0 + 0.00295860389610399*G0_1_1_9_1 + 0.0010409902597403*G0_1_1_9_2 - 0.0123275162337667*G0_1_1_9_3 - 0.000986201298701343*G0_1_1_9_4 + 0.0197240259740267*G0_1_1_9_5 - 0.00986201298701334*G0_1_1_9_6 + 0.02958603896104*G0_1_1_9_7 - 0.0246550324675333*G0_1_1_9_8 - 0.0394480519480532*G0_1_1_9_9;
    A[70] = A[7] - 0.124736201298706*G0_0_1_0_0 - 0.0082335633116886*G0_0_1_0_1 - 0.00823356331168859*G0_0_1_0_2 + 0.002237215909091*G0_0_1_0_3 + 0.002237215909091*G0_0_1_0_4 - 0.0808137175324702*G0_0_1_0_5 + 0.0367086038961051*G0_0_1_0_6 - 0.0808137175324703*G0_0_1_0_7 + 0.0367086038961052*G0_0_1_0_8 - 0.01479301948052*G0_0_1_0_9 - 0.00823356331168859*G0_0_1_1_0 - 0.00113230519480523*G0_0_1_1_1 - 0.00113230519480523*G0_0_1_1_2 + 0.000922280844155883*G0_0_1_1_3 + 0.000566152597402617*G0_0_1_1_4 - 0.011131290584416*G0_0_1_1_5 + 0.00503145292207809*G0_0_1_1_6 - 0.0150304383116888*G0_0_1_1_7 + 0.00650162337662361*G0_0_1_1_8 - 0.00482142857142874*G0_0_1_1_9 - 0.00823356331168859*G0_0_1_2_0 - 0.00113230519480523*G0_0_1_2_1 - 0.00113230519480523*G0_0_1_2_2 + 0.000566152597402618*G0_0_1_2_3 + 0.000922280844155878*G0_0_1_2_4 - 0.0150304383116888*G0_0_1_2_5 + 0.0065016233766236*G0_0_1_2_6 - 0.011131290584416*G0_0_1_2_7 + 0.00503145292207809*G0_0_1_2_8 - 0.00482142857142874*G0_0_1_2_9 + 0.002237215909091*G0_0_1_3_0 + 0.000922280844155883*G0_0_1_3_1 + 0.000566152597402618*G0_0_1_3_2 + 0.00131493506493514*G0_0_1_3_3 - 0.00065746753246756*G0_0_1_3_4 + 0.00723214285714309*G0_0_1_3_5 - 0.00287642045454555*G0_0_1_3_6 + 0.00550629058441579*G0_0_1_3_7 - 0.00262987012987022*G0_0_1_3_8 + 0.00345170454545467*G0_0_1_3_9 + 0.002237215909091*G0_0_1_4_0 + 0.000566152597402617*G0_0_1_4_1 + 0.000922280844155878*G0_0_1_4_2 - 0.00065746753246756*G0_0_1_4_3 + 0.00131493506493509*G0_0_1_4_4 + 0.0055062905844158*G0_0_1_4_5 - 0.00262987012987023*G0_0_1_4_6 + 0.00723214285714312*G0_0_1_4_7 - 0.00287642045454557*G0_0_1_4_8 + 0.00345170454545467*G0_0_1_4_9 - 0.0808137175324702*G0_0_1_5_0 - 0.011131290584416*G0_0_1_5_1 - 0.0150304383116888*G0_0_1_5_2 + 0.00723214285714309*G0_0_1_5_3 + 0.0055062905844158*G0_0_1_5_4 - 0.182447240259746*G0_0_1_5_5 + 0.0678013392857165*G0_0_1_5_6 - 0.0912236201298732*G0_0_1_5_7 + 0.0456118100649366*G0_0_1_5_8 - 0.0468445616883134*G0_0_1_5_9 + 0.0367086038961051*G0_0_1_6_0 + 0.00503145292207809*G0_0_1_6_1 + 0.0065016233766236*G0_0_1_6_2 - 0.00287642045454555*G0_0_1_6_3 - 0.00262987012987023*G0_0_1_6_4 + 0.0678013392857165*G0_0_1_6_5 - 0.0285998376623386*G0_0_1_6_6 + 0.0456118100649366*G0_0_1_6_7 - 0.0212033279220786*G0_0_1_6_8 + 0.0202171266233773*G0_0_1_6_9 - 0.0808137175324703*G0_0_1_7_0 - 0.0150304383116888*G0_0_1_7_1 - 0.011131290584416*G0_0_1_7_2 + 0.00550629058441579*G0_0_1_7_3 + 0.00723214285714313*G0_0_1_7_4 - 0.0912236201298732*G0_0_1_7_5 + 0.0456118100649366*G0_0_1_7_6 - 0.182447240259747*G0_0_1_7_7 + 0.0678013392857167*G0_0_1_7_8 - 0.0468445616883134*G0_0_1_7_9 + 0.0367086038961052*G0_0_1_8_0 + 0.00650162337662361*G0_0_1_8_1 + 0.00503145292207809*G0_0_1_8_2 - 0.00262987012987022*G0_0_1_8_3 - 0.00287642045454557*G0_0_1_8_4 + 0.0456118100649366*G0_0_1_8_5 - 0.0212033279220786*G0_0_1_8_6 + 0.0678013392857167*G0_0_1_8_7 - 0.0285998376623386*G0_0_1_8_8 + 0.0202171266233774*G0_0_1_8_9 - 0.01479301948052*G0_0_1_9_0 - 0.00482142857142874*G0_0_1_9_1 - 0.00482142857142874*G0_0_1_9_2 + 0.00345170454545467*G0_0_1_9_3 + 0.00345170454545467*G0_0_1_9_4 - 0.0468445616883134*G0_0_1_9_5 + 0.0202171266233773*G0_0_1_9_6 - 0.0468445616883134*G0_0_1_9_7 + 0.0202171266233774*G0_0_1_9_8 - 0.0256412337662347*G0_0_1_9_9 + 0.124736201298706*G0_1_0_0_0 + 0.0082335633116886*G0_1_0_0_1 + 0.00823356331168859*G0_1_0_0_2 - 0.002237215909091*G0_1_0_0_3 - 0.002237215909091*G0_1_0_0_4 + 0.0808137175324702*G0_1_0_0_5 - 0.0367086038961051*G0_1_0_0_6 + 0.0808137175324703*G0_1_0_0_7 - 0.0367086038961052*G0_1_0_0_8 + 0.01479301948052*G0_1_0_0_9 + 0.0082335633116886*G0_1_0_1_0 + 0.00113230519480523*G0_1_0_1_1 + 0.00113230519480523*G0_1_0_1_2 - 0.000922280844155883*G0_1_0_1_3 - 0.000566152597402616*G0_1_0_1_4 + 0.011131290584416*G0_1_0_1_5 - 0.00503145292207809*G0_1_0_1_6 + 0.0150304383116888*G0_1_0_1_7 - 0.00650162337662361*G0_1_0_1_8 + 0.00482142857142874*G0_1_0_1_9 + 0.00823356331168859*G0_1_0_2_0 + 0.00113230519480523*G0_1_0_2_1 + 0.00113230519480523*G0_1_0_2_2 - 0.000566152597402618*G0_1_0_2_3 - 0.000922280844155878*G0_1_0_2_4 + 0.0150304383116888*G0_1_0_2_5 - 0.0065016233766236*G0_1_0_2_6 + 0.011131290584416*G0_1_0_2_7 - 0.00503145292207809*G0_1_0_2_8 + 0.00482142857142874*G0_1_0_2_9 - 0.002237215909091*G0_1_0_3_0 - 0.000922280844155882*G0_1_0_3_1 - 0.000566152597402618*G0_1_0_3_2 - 0.00131493506493514*G0_1_0_3_3 + 0.000657467532467561*G0_1_0_3_4 - 0.00723214285714309*G0_1_0_3_5 + 0.00287642045454555*G0_1_0_3_6 - 0.00550629058441579*G0_1_0_3_7 + 0.00262987012987022*G0_1_0_3_8 - 0.00345170454545467*G0_1_0_3_9 - 0.002237215909091*G0_1_0_4_0 - 0.000566152597402616*G0_1_0_4_1 - 0.000922280844155878*G0_1_0_4_2 + 0.000657467532467561*G0_1_0_4_3 - 0.00131493506493509*G0_1_0_4_4 - 0.0055062905844158*G0_1_0_4_5 + 0.00262987012987023*G0_1_0_4_6 - 0.00723214285714312*G0_1_0_4_7 + 0.00287642045454557*G0_1_0_4_8 - 0.00345170454545467*G0_1_0_4_9 + 0.0808137175324702*G0_1_0_5_0 + 0.011131290584416*G0_1_0_5_1 + 0.0150304383116888*G0_1_0_5_2 - 0.00723214285714309*G0_1_0_5_3 - 0.0055062905844158*G0_1_0_5_4 + 0.182447240259746*G0_1_0_5_5 - 0.0678013392857165*G0_1_0_5_6 + 0.0912236201298732*G0_1_0_5_7 - 0.0456118100649366*G0_1_0_5_8 + 0.0468445616883134*G0_1_0_5_9 - 0.0367086038961051*G0_1_0_6_0 - 0.00503145292207809*G0_1_0_6_1 - 0.0065016233766236*G0_1_0_6_2 + 0.00287642045454555*G0_1_0_6_3 + 0.00262987012987023*G0_1_0_6_4 - 0.0678013392857165*G0_1_0_6_5 + 0.0285998376623386*G0_1_0_6_6 - 0.0456118100649366*G0_1_0_6_7 + 0.0212033279220786*G0_1_0_6_8 - 0.0202171266233773*G0_1_0_6_9 + 0.0808137175324703*G0_1_0_7_0 + 0.0150304383116888*G0_1_0_7_1 + 0.011131290584416*G0_1_0_7_2 - 0.00550629058441579*G0_1_0_7_3 - 0.00723214285714312*G0_1_0_7_4 + 0.0912236201298732*G0_1_0_7_5 - 0.0456118100649366*G0_1_0_7_6 + 0.182447240259747*G0_1_0_7_7 - 0.0678013392857167*G0_1_0_7_8 + 0.0468445616883134*G0_1_0_7_9 - 0.0367086038961052*G0_1_0_8_0 - 0.00650162337662361*G0_1_0_8_1 - 0.0050314529220781*G0_1_0_8_2 + 0.00262987012987022*G0_1_0_8_3 + 0.00287642045454557*G0_1_0_8_4 - 0.0456118100649366*G0_1_0_8_5 + 0.0212033279220786*G0_1_0_8_6 - 0.0678013392857167*G0_1_0_8_7 + 0.0285998376623386*G0_1_0_8_8 - 0.0202171266233774*G0_1_0_8_9 + 0.01479301948052*G0_1_0_9_0 + 0.00482142857142874*G0_1_0_9_1 + 0.00482142857142874*G0_1_0_9_2 - 0.00345170454545467*G0_1_0_9_3 - 0.00345170454545467*G0_1_0_9_4 + 0.0468445616883134*G0_1_0_9_5 - 0.0202171266233773*G0_1_0_9_6 + 0.0468445616883134*G0_1_0_9_7 - 0.0202171266233774*G0_1_0_9_8 + 0.0256412337662347*G0_1_0_9_9;
    A[5] = A[70] + 0.124736201298706*G0_0_0_0_0 + 0.00786221590909118*G0_0_0_0_1 + 0.008604910714286*G0_0_0_0_2 - 0.00130580357142862*G0_0_0_0_3 - 0.00316862824675337*G0_0_0_0_4 + 0.0926846590909121*G0_0_0_0_5 - 0.0407264610389624*G0_0_0_0_6 + 0.0689427759740283*G0_0_0_0_7 - 0.0326907467532479*G0_0_0_0_8 + 0.01479301948052*G0_0_0_0_9 + 0.00786221590909118*G0_0_0_1_0 + 0.00964285714285748*G0_0_0_1_1 + 0.00113230519480523*G0_0_0_1_2 + 0.0064924918831171*G0_0_0_1_3 - 0.0047392451298703*G0_0_0_1_4 + 0.0127749594155848*G0_0_0_1_5 - 0.00653814935064958*G0_0_0_1_6 + 0.00994419642857176*G0_0_0_1_7 - 0.00331473214285725*G0_0_0_1_8 + 0.00290381493506504*G0_0_0_1_9 + 0.008604910714286*G0_0_0_2_0 + 0.00113230519480523*G0_0_0_2_1 - 0.00737824675324702*G0_0_0_2_2 + 0.00360693993506506*G0_0_0_2_3 - 0.00833705357142887*G0_0_0_2_4 + 0.0201166801948059*G0_0_0_2_5 - 0.00968851461038995*G0_0_0_2_6 + 0.00948762175324707*G0_0_0_2_7 - 0.00352475649350661*G0_0_0_2_8 + 0.00673904220779245*G0_0_0_2_9 - 0.00130580357142862*G0_0_0_3_0 + 0.0064924918831171*G0_0_0_3_1 + 0.00360693993506506*G0_0_0_3_2 + 0.0208745941558449*G0_0_0_3_3 + 0.000657467532467566*G0_0_0_3_4 - 0.01109476461039*G0_0_0_3_5 + 0.00739650974025999*G0_0_0_3_6 - 0.00830052759740289*G0_0_0_3_7 + 0.00994419642857178*G0_0_0_3_8 + 0.00788961038961066*G0_0_0_3_9 - 0.00316862824675337*G0_0_0_4_0 - 0.00473924512987029*G0_0_0_4_1 - 0.00833705357142887*G0_0_0_4_2 + 0.000657467532467568*G0_0_0_4_3 - 0.0235044642857151*G0_0_0_4_4 - 0.00271205357142869*G0_0_0_4_5 - 0.00468445616883133*G0_0_0_4_6 - 0.00336952110389623*G0_0_0_4_7 - 0.00164366883116888*G0_0_0_4_8 - 0.01479301948052*G0_0_0_4_9 + 0.0926846590909121*G0_0_0_5_0 + 0.0127749594155848*G0_0_0_5_1 + 0.0201166801948059*G0_0_0_5_2 - 0.01109476461039*G0_0_0_5_3 - 0.00271205357142869*G0_0_0_5_4 + 0.254768668831177*G0_0_0_5_5 - 0.0842380275974054*G0_0_0_5_6 + 0.0912236201298732*G0_0_0_5_7 - 0.0505428165584433*G0_0_0_5_8 + 0.0567065746753267*G0_0_0_5_9 - 0.0407264610389624*G0_0_0_6_0 - 0.00653814935064958*G0_0_0_6_1 - 0.00968851461038995*G0_0_0_6_2 + 0.00739650974025999*G0_0_0_6_3 - 0.00468445616883133*G0_0_0_6_4 - 0.0842380275974054*G0_0_0_6_5 + 0.0121631493506497*G0_0_0_6_6 - 0.0406808035714299*G0_0_0_6_7 + 0.0212033279220786*G0_0_0_6_8 - 0.0350101461038973*G0_0_0_6_9 + 0.0689427759740283*G0_0_0_7_0 + 0.00994419642857176*G0_0_0_7_1 + 0.00948762175324707*G0_0_0_7_2 - 0.00830052759740289*G0_0_0_7_3 - 0.00336952110389623*G0_0_0_7_4 + 0.0912236201298732*G0_0_0_7_5 - 0.0406808035714299*G0_0_0_7_6 + 0.110125811688315*G0_0_0_7_7 - 0.0513646509740278*G0_0_0_7_8 + 0.0369825487013*G0_0_0_7_9 - 0.0326907467532479*G0_0_0_8_0 - 0.00331473214285725*G0_0_0_8_1 - 0.00352475649350661*G0_0_0_8_2 + 0.00994419642857178*G0_0_0_8_3 - 0.00164366883116888*G0_0_0_8_4 - 0.0505428165584433*G0_0_0_8_5 + 0.0212033279220786*G0_0_0_8_6 - 0.0513646509740278*G0_0_0_8_7 + 0.0450365259740276*G0_0_0_8_8 - 0.00542410714285737*G0_0_0_8_9 + 0.01479301948052*G0_0_0_9_0 + 0.00290381493506504*G0_0_0_9_1 + 0.00673904220779245*G0_0_0_9_2 + 0.00788961038961066*G0_0_0_9_3 - 0.01479301948052*G0_0_0_9_4 + 0.0567065746753267*G0_0_0_9_5 - 0.0350101461038973*G0_0_0_9_6 + 0.0369825487013*G0_0_0_9_7 - 0.00542410714285736*G0_0_0_9_8 + 0.0256412337662347*G0_0_0_9_9 - 0.000371347402597417*G0_0_1_0_1 + 0.000371347402597415*G0_0_1_0_2 + 0.00093141233766238*G0_0_1_0_3 - 0.000931412337662377*G0_0_1_0_4 + 0.0118709415584419*G0_0_1_0_5 - 0.00401785714285727*G0_0_1_0_6 - 0.011870941558442*G0_0_1_0_7 + 0.00401785714285731*G0_0_1_0_8 - 0.000371347402597418*G0_0_1_1_0 + 0.00851055194805223*G0_0_1_1_1 + 0.00741477272727297*G0_0_1_1_3 - 0.00417309253246767*G0_0_1_1_4 + 0.00164366883116888*G0_0_1_1_5 - 0.00150669642857148*G0_0_1_1_6 - 0.00508624188311707*G0_0_1_1_7 + 0.00318689123376636*G0_0_1_1_8 - 0.0019176136363637*G0_0_1_1_9 + 0.000371347402597414*G0_0_1_2_0 - 0.00851055194805225*G0_0_1_2_2 + 0.00417309253246768*G0_0_1_2_3 - 0.00741477272727299*G0_0_1_2_4 + 0.00508624188311706*G0_0_1_2_5 - 0.00318689123376636*G0_0_1_2_6 - 0.00164366883116889*G0_0_1_2_7 + 0.00150669642857148*G0_0_1_2_8 + 0.0019176136363637*G0_0_1_2_9 + 0.00093141233766238*G0_0_1_3_0 + 0.00741477272727297*G0_0_1_3_1 + 0.00417309253246768*G0_0_1_3_2 + 0.02218952922078*G0_0_1_3_3 - 0.00386262175324688*G0_0_1_3_5 + 0.00452008928571444*G0_0_1_3_6 - 0.0027942370129871*G0_0_1_3_7 + 0.00731432629870155*G0_0_1_3_8 + 0.0113413149350653*G0_0_1_3_9 - 0.000931412337662377*G0_0_1_4_0 - 0.00417309253246767*G0_0_1_4_1 - 0.00741477272727299*G0_0_1_4_2 - 0.02218952922078*G0_0_1_4_4 + 0.00279423701298711*G0_0_1_4_5 - 0.00731432629870156*G0_0_1_4_6 + 0.0038626217532469*G0_0_1_4_7 - 0.00452008928571444*G0_0_1_4_8 - 0.0113413149350653*G0_0_1_4_9 + 0.0118709415584419*G0_0_1_5_0 + 0.00164366883116888*G0_0_1_5_1 + 0.00508624188311706*G0_0_1_5_2 - 0.00386262175324688*G0_0_1_5_3 + 0.00279423701298711*G0_0_1_5_4 + 0.072321428571431*G0_0_1_5_5 - 0.0164366883116888*G0_0_1_5_6 - 0.00493100649350666*G0_0_1_5_8 + 0.00986201298701333*G0_0_1_5_9 - 0.00401785714285727*G0_0_1_6_0 - 0.00150669642857148*G0_0_1_6_1 - 0.00318689123376636*G0_0_1_6_2 + 0.00452008928571444*G0_0_1_6_3 - 0.00731432629870156*G0_0_1_6_4 - 0.0164366883116888*G0_0_1_6_5 - 0.0164366883116889*G0_0_1_6_6 + 0.00493100649350667*G0_0_1_6_7 - 0.01479301948052*G0_0_1_6_9 - 0.011870941558442*G0_0_1_7_0 - 0.00508624188311707*G0_0_1_7_1 - 0.00164366883116889*G0_0_1_7_2 - 0.0027942370129871*G0_0_1_7_3 + 0.0038626217532469*G0_0_1_7_4 + 0.00493100649350667*G0_0_1_7_6 - 0.0723214285714312*G0_0_1_7_7 + 0.0164366883116889*G0_0_1_7_8 - 0.00986201298701338*G0_0_1_7_9 + 0.00401785714285732*G0_0_1_8_0 + 0.00318689123376636*G0_0_1_8_1 + 0.00150669642857148*G0_0_1_8_2 + 0.00731432629870155*G0_0_1_8_3 - 0.00452008928571444*G0_0_1_8_4 - 0.00493100649350666*G0_0_1_8_5 + 0.0164366883116889*G0_0_1_8_7 + 0.0164366883116889*G0_0_1_8_8 + 0.01479301948052*G0_0_1_8_9 - 0.0019176136363637*G0_0_1_9_1 + 0.0019176136363637*G0_0_1_9_2 + 0.0113413149350653*G0_0_1_9_3 - 0.0113413149350653*G0_0_1_9_4 + 0.00986201298701333*G0_0_1_9_5 - 0.01479301948052*G0_0_1_9_6 - 0.00986201298701338*G0_0_1_9_7 + 0.01479301948052*G0_0_1_9_8 - 0.000371347402597415*G0_1_0_0_1 + 0.000371347402597413*G0_1_0_0_2 + 0.00093141233766238*G0_1_0_0_3 - 0.000931412337662379*G0_1_0_0_4 + 0.011870941558442*G0_1_0_0_5 - 0.00401785714285729*G0_1_0_0_6 - 0.011870941558442*G0_1_0_0_7 + 0.00401785714285729*G0_1_0_0_8 - 0.000371347402597415*G0_1_0_1_0 + 0.00851055194805224*G0_1_0_1_1 + 0.00741477272727298*G0_1_0_1_3 - 0.00417309253246768*G0_1_0_1_4 + 0.00164366883116888*G0_1_0_1_5 - 0.00150669642857149*G0_1_0_1_6 - 0.00508624188311707*G0_1_0_1_7 + 0.00318689123376636*G0_1_0_1_8 - 0.0019176136363637*G0_1_0_1_9 + 0.000371347402597413*G0_1_0_2_0 - 0.00851055194805225*G0_1_0_2_2 + 0.00417309253246768*G0_1_0_2_3 - 0.00741477272727299*G0_1_0_2_4 + 0.00508624188311707*G0_1_0_2_5 - 0.00318689123376636*G0_1_0_2_6 - 0.00164366883116889*G0_1_0_2_7 + 0.00150669642857148*G0_1_0_2_8 + 0.0019176136363637*G0_1_0_2_9 + 0.00093141233766238*G0_1_0_3_0 + 0.00741477272727298*G0_1_0_3_1 + 0.00417309253246768*G0_1_0_3_2 + 0.02218952922078*G0_1_0_3_3 - 0.00386262175324688*G0_1_0_3_5 + 0.00452008928571444*G0_1_0_3_6 - 0.0027942370129871*G0_1_0_3_7 + 0.00731432629870156*G0_1_0_3_8 + 0.0113413149350653*G0_1_0_3_9 - 0.000931412337662379*G0_1_0_4_0 - 0.00417309253246768*G0_1_0_4_1 - 0.00741477272727299*G0_1_0_4_2 - 0.02218952922078*G0_1_0_4_4 + 0.00279423701298711*G0_1_0_4_5 - 0.00731432629870157*G0_1_0_4_6 + 0.00386262175324689*G0_1_0_4_7 - 0.00452008928571445*G0_1_0_4_8 - 0.0113413149350653*G0_1_0_4_9 + 0.011870941558442*G0_1_0_5_0 + 0.00164366883116888*G0_1_0_5_1 + 0.00508624188311707*G0_1_0_5_2 - 0.00386262175324688*G0_1_0_5_3 + 0.00279423701298711*G0_1_0_5_4 + 0.072321428571431*G0_1_0_5_5 - 0.0164366883116888*G0_1_0_5_6 - 0.00493100649350667*G0_1_0_5_8 + 0.00986201298701335*G0_1_0_5_9 - 0.00401785714285729*G0_1_0_6_0 - 0.00150669642857149*G0_1_0_6_1 - 0.00318689123376636*G0_1_0_6_2 + 0.00452008928571444*G0_1_0_6_3 - 0.00731432629870157*G0_1_0_6_4 - 0.0164366883116888*G0_1_0_6_5 - 0.0164366883116889*G0_1_0_6_6 + 0.00493100649350666*G0_1_0_6_7 - 0.01479301948052*G0_1_0_6_9 - 0.011870941558442*G0_1_0_7_0 - 0.00508624188311707*G0_1_0_7_1 - 0.00164366883116889*G0_1_0_7_2 - 0.0027942370129871*G0_1_0_7_3 + 0.00386262175324689*G0_1_0_7_4 + 0.00493100649350666*G0_1_0_7_6 - 0.0723214285714311*G0_1_0_7_7 + 0.0164366883116889*G0_1_0_7_8 - 0.00986201298701334*G0_1_0_7_9 + 0.00401785714285729*G0_1_0_8_0 + 0.00318689123376636*G0_1_0_8_1 + 0.00150669642857148*G0_1_0_8_2 + 0.00731432629870156*G0_1_0_8_3 - 0.00452008928571445*G0_1_0_8_4 - 0.00493100649350667*G0_1_0_8_5 + 0.0164366883116889*G0_1_0_8_7 + 0.0164366883116889*G0_1_0_8_8 + 0.01479301948052*G0_1_0_8_9 - 0.0019176136363637*G0_1_0_9_1 + 0.0019176136363637*G0_1_0_9_2 + 0.0113413149350653*G0_1_0_9_3 - 0.0113413149350653*G0_1_0_9_4 + 0.00986201298701335*G0_1_0_9_5 - 0.01479301948052*G0_1_0_9_6 - 0.00986201298701335*G0_1_0_9_7 + 0.01479301948052*G0_1_0_9_8 - 0.124736201298706*G0_1_1_0_0 - 0.00860491071428601*G0_1_1_0_1 - 0.00786221590909117*G0_1_1_0_2 + 0.00316862824675338*G0_1_1_0_3 + 0.00130580357142862*G0_1_1_0_4 - 0.0689427759740283*G0_1_1_0_5 + 0.0326907467532478*G0_1_1_0_6 - 0.0926846590909123*G0_1_1_0_7 + 0.0407264610389625*G0_1_1_0_8 - 0.01479301948052*G0_1_1_0_9 - 0.00860491071428602*G0_1_1_1_0 + 0.00737824675324699*G0_1_1_1_1 - 0.00113230519480524*G0_1_1_1_2 + 0.00833705357142885*G0_1_1_1_3 - 0.00360693993506505*G0_1_1_1_4 - 0.00948762175324708*G0_1_1_1_5 + 0.00352475649350661*G0_1_1_1_6 - 0.0201166801948059*G0_1_1_1_7 + 0.00968851461038996*G0_1_1_1_8 - 0.00673904220779244*G0_1_1_1_9 - 0.00786221590909117*G0_1_1_2_0 - 0.00113230519480524*G0_1_1_2_1 - 0.00964285714285748*G0_1_1_2_2 + 0.00473924512987029*G0_1_1_2_3 - 0.00649249188311712*G0_1_1_2_4 - 0.00994419642857176*G0_1_1_2_5 + 0.00331473214285724*G0_1_1_2_6 - 0.0127749594155849*G0_1_1_2_7 + 0.00653814935064958*G0_1_1_2_8 - 0.00290381493506505*G0_1_1_2_9 + 0.00316862824675338*G0_1_1_3_0 + 0.00833705357142885*G0_1_1_3_1 + 0.00473924512987029*G0_1_1_3_2 + 0.0235044642857151*G0_1_1_3_3 - 0.000657467532467532*G0_1_1_3_4 + 0.00336952110389622*G0_1_1_3_5 + 0.00164366883116889*G0_1_1_3_6 + 0.00271205357142869*G0_1_1_3_7 + 0.00468445616883132*G0_1_1_3_8 + 0.01479301948052*G0_1_1_3_9 + 0.00130580357142862*G0_1_1_4_0 - 0.00360693993506505*G0_1_1_4_1 - 0.00649249188311712*G0_1_1_4_2 - 0.000657467532467532*G0_1_1_4_3 - 0.0208745941558449*G0_1_1_4_4 + 0.00830052759740291*G0_1_1_4_5 - 0.0099441964285718*G0_1_1_4_6 + 0.01109476461039*G0_1_1_4_7 - 0.00739650974026001*G0_1_1_4_8 - 0.00788961038961065*G0_1_1_4_9 - 0.0689427759740283*G0_1_1_5_0 - 0.00948762175324708*G0_1_1_5_1 - 0.00994419642857176*G0_1_1_5_2 + 0.00336952110389622*G0_1_1_5_3 + 0.00830052759740291*G0_1_1_5_4 - 0.110125811688315*G0_1_1_5_5 + 0.0513646509740277*G0_1_1_5_6 - 0.0912236201298732*G0_1_1_5_7 + 0.04068080357143*G0_1_1_5_8 - 0.0369825487013*G0_1_1_5_9 + 0.0326907467532478*G0_1_1_6_0 + 0.00352475649350661*G0_1_1_6_1 + 0.00331473214285724*G0_1_1_6_2 + 0.00164366883116889*G0_1_1_6_3 - 0.0099441964285718*G0_1_1_6_4 + 0.0513646509740277*G0_1_1_6_5 - 0.0450365259740275*G0_1_1_6_6 + 0.0505428165584433*G0_1_1_6_7 - 0.0212033279220786*G0_1_1_6_8 + 0.00542410714285737*G0_1_1_6_9 - 0.0926846590909124*G0_1_1_7_0 - 0.0201166801948059*G0_1_1_7_1 - 0.0127749594155849*G0_1_1_7_2 + 0.00271205357142869*G0_1_1_7_3 + 0.01109476461039*G0_1_1_7_4 - 0.0912236201298732*G0_1_1_7_5 + 0.0505428165584433*G0_1_1_7_6 - 0.254768668831178*G0_1_1_7_7 + 0.0842380275974056*G0_1_1_7_8 - 0.0567065746753268*G0_1_1_7_9 + 0.0407264610389625*G0_1_1_8_0 + 0.00968851461038996*G0_1_1_8_1 + 0.00653814935064958*G0_1_1_8_2 + 0.00468445616883133*G0_1_1_8_3 - 0.00739650974026001*G0_1_1_8_4 + 0.04068080357143*G0_1_1_8_5 - 0.0212033279220786*G0_1_1_8_6 + 0.0842380275974056*G0_1_1_8_7 - 0.0121631493506498*G0_1_1_8_8 + 0.0350101461038973*G0_1_1_8_9 - 0.01479301948052*G0_1_1_9_0 - 0.00673904220779244*G0_1_1_9_1 - 0.00290381493506505*G0_1_1_9_2 + 0.01479301948052*G0_1_1_9_3 - 0.00788961038961065*G0_1_1_9_4 - 0.0369825487013*G0_1_1_9_5 + 0.00542410714285737*G0_1_1_9_6 - 0.0567065746753268*G0_1_1_9_7 + 0.0350101461038973*G0_1_1_9_8 - 0.0256412337662347*G0_1_1_9_9;
    A[50] = A[5] + 0.124736201298706*G0_0_1_0_0 + 0.0082335633116886*G0_0_1_0_1 + 0.00823356331168858*G0_0_1_0_2 - 0.002237215909091*G0_0_1_0_3 - 0.002237215909091*G0_0_1_0_4 + 0.0808137175324702*G0_0_1_0_5 - 0.0367086038961051*G0_0_1_0_6 + 0.0808137175324704*G0_0_1_0_7 - 0.0367086038961052*G0_0_1_0_8 + 0.01479301948052*G0_0_1_0_9 + 0.0082335633116886*G0_0_1_1_0 + 0.00113230519480524*G0_0_1_1_1 + 0.00113230519480523*G0_0_1_1_2 - 0.000922280844155873*G0_0_1_1_3 - 0.00056615259740262*G0_0_1_1_4 + 0.011131290584416*G0_0_1_1_5 - 0.00503145292207809*G0_0_1_1_6 + 0.0150304383116888*G0_0_1_1_7 - 0.0065016233766236*G0_0_1_1_8 + 0.00482142857142874*G0_0_1_1_9 + 0.00823356331168858*G0_0_1_2_0 + 0.00113230519480523*G0_0_1_2_1 + 0.00113230519480523*G0_0_1_2_2 - 0.000566152597402616*G0_0_1_2_3 - 0.000922280844155878*G0_0_1_2_4 + 0.0150304383116888*G0_0_1_2_5 - 0.0065016233766236*G0_0_1_2_6 + 0.011131290584416*G0_0_1_2_7 - 0.00503145292207809*G0_0_1_2_8 + 0.00482142857142875*G0_0_1_2_9 - 0.002237215909091*G0_0_1_3_0 - 0.000922280844155873*G0_0_1_3_1 - 0.000566152597402616*G0_0_1_3_2 - 0.00131493506493513*G0_0_1_3_3 + 0.000657467532467556*G0_0_1_3_4 - 0.00723214285714309*G0_0_1_3_5 + 0.00287642045454556*G0_0_1_3_6 - 0.00550629058441579*G0_0_1_3_7 + 0.00262987012987022*G0_0_1_3_8 - 0.00345170454545467*G0_0_1_3_9 - 0.002237215909091*G0_0_1_4_0 - 0.00056615259740262*G0_0_1_4_1 - 0.000922280844155878*G0_0_1_4_2 + 0.000657467532467556*G0_0_1_4_3 - 0.00131493506493511*G0_0_1_4_4 - 0.0055062905844158*G0_0_1_4_5 + 0.00262987012987023*G0_0_1_4_6 - 0.00723214285714313*G0_0_1_4_7 + 0.00287642045454556*G0_0_1_4_8 - 0.00345170454545469*G0_0_1_4_9 + 0.0808137175324702*G0_0_1_5_0 + 0.011131290584416*G0_0_1_5_1 + 0.0150304383116888*G0_0_1_5_2 - 0.00723214285714309*G0_0_1_5_3 - 0.0055062905844158*G0_0_1_5_4 + 0.182447240259746*G0_0_1_5_5 - 0.0678013392857166*G0_0_1_5_6 + 0.0912236201298732*G0_0_1_5_7 - 0.0456118100649366*G0_0_1_5_8 + 0.0468445616883134*G0_0_1_5_9 - 0.0367086038961051*G0_0_1_6_0 - 0.00503145292207809*G0_0_1_6_1 - 0.0065016233766236*G0_0_1_6_2 + 0.00287642045454556*G0_0_1_6_3 + 0.00262987012987023*G0_0_1_6_4 - 0.0678013392857166*G0_0_1_6_5 + 0.0285998376623386*G0_0_1_6_6 - 0.0456118100649366*G0_0_1_6_7 + 0.0212033279220786*G0_0_1_6_8 - 0.0202171266233774*G0_0_1_6_9 + 0.0808137175324704*G0_0_1_7_0 + 0.0150304383116888*G0_0_1_7_1 + 0.011131290584416*G0_0_1_7_2 - 0.00550629058441579*G0_0_1_7_3 - 0.00723214285714313*G0_0_1_7_4 + 0.0912236201298732*G0_0_1_7_5 - 0.0456118100649366*G0_0_1_7_6 + 0.182447240259747*G0_0_1_7_7 - 0.0678013392857167*G0_0_1_7_8 + 0.0468445616883134*G0_0_1_7_9 - 0.0367086038961052*G0_0_1_8_0 - 0.0065016233766236*G0_0_1_8_1 - 0.00503145292207809*G0_0_1_8_2 + 0.00262987012987022*G0_0_1_8_3 + 0.00287642045454556*G0_0_1_8_4 - 0.0456118100649366*G0_0_1_8_5 + 0.0212033279220786*G0_0_1_8_6 - 0.0678013392857167*G0_0_1_8_7 + 0.0285998376623387*G0_0_1_8_8 - 0.0202171266233773*G0_0_1_8_9 + 0.01479301948052*G0_0_1_9_0 + 0.00482142857142874*G0_0_1_9_1 + 0.00482142857142875*G0_0_1_9_2 - 0.00345170454545467*G0_0_1_9_3 - 0.00345170454545469*G0_0_1_9_4 + 0.0468445616883134*G0_0_1_9_5 - 0.0202171266233774*G0_0_1_9_6 + 0.0468445616883134*G0_0_1_9_7 - 0.0202171266233773*G0_0_1_9_8 + 0.0256412337662347*G0_0_1_9_9 - 0.124736201298706*G0_1_0_0_0 - 0.0082335633116886*G0_1_0_0_1 - 0.00823356331168858*G0_1_0_0_2 + 0.002237215909091*G0_1_0_0_3 + 0.002237215909091*G0_1_0_0_4 - 0.0808137175324702*G0_1_0_0_5 + 0.0367086038961051*G0_1_0_0_6 - 0.0808137175324704*G0_1_0_0_7 + 0.0367086038961052*G0_1_0_0_8 - 0.01479301948052*G0_1_0_0_9 - 0.0082335633116886*G0_1_0_1_0 - 0.00113230519480524*G0_1_0_1_1 - 0.00113230519480523*G0_1_0_1_2 + 0.000922280844155873*G0_1_0_1_3 + 0.000566152597402621*G0_1_0_1_4 - 0.011131290584416*G0_1_0_1_5 + 0.00503145292207809*G0_1_0_1_6 - 0.0150304383116888*G0_1_0_1_7 + 0.0065016233766236*G0_1_0_1_8 - 0.00482142857142874*G0_1_0_1_9 - 0.00823356331168858*G0_1_0_2_0 - 0.00113230519480523*G0_1_0_2_1 - 0.00113230519480523*G0_1_0_2_2 + 0.000566152597402616*G0_1_0_2_3 + 0.000922280844155878*G0_1_0_2_4 - 0.0150304383116888*G0_1_0_2_5 + 0.0065016233766236*G0_1_0_2_6 - 0.011131290584416*G0_1_0_2_7 + 0.00503145292207809*G0_1_0_2_8 - 0.00482142857142875*G0_1_0_2_9 + 0.002237215909091*G0_1_0_3_0 + 0.000922280844155873*G0_1_0_3_1 + 0.000566152597402616*G0_1_0_3_2 + 0.00131493506493513*G0_1_0_3_3 - 0.000657467532467557*G0_1_0_3_4 + 0.00723214285714309*G0_1_0_3_5 - 0.00287642045454556*G0_1_0_3_6 + 0.00550629058441579*G0_1_0_3_7 - 0.00262987012987022*G0_1_0_3_8 + 0.00345170454545467*G0_1_0_3_9 + 0.002237215909091*G0_1_0_4_0 + 0.000566152597402621*G0_1_0_4_1 + 0.000922280844155879*G0_1_0_4_2 - 0.000657467532467556*G0_1_0_4_3 + 0.00131493506493512*G0_1_0_4_4 + 0.0055062905844158*G0_1_0_4_5 - 0.00262987012987023*G0_1_0_4_6 + 0.00723214285714313*G0_1_0_4_7 - 0.00287642045454556*G0_1_0_4_8 + 0.00345170454545469*G0_1_0_4_9 - 0.0808137175324702*G0_1_0_5_0 - 0.011131290584416*G0_1_0_5_1 - 0.0150304383116888*G0_1_0_5_2 + 0.00723214285714309*G0_1_0_5_3 + 0.0055062905844158*G0_1_0_5_4 - 0.182447240259746*G0_1_0_5_5 + 0.0678013392857166*G0_1_0_5_6 - 0.0912236201298732*G0_1_0_5_7 + 0.0456118100649366*G0_1_0_5_8 - 0.0468445616883134*G0_1_0_5_9 + 0.0367086038961051*G0_1_0_6_0 + 0.00503145292207809*G0_1_0_6_1 + 0.0065016233766236*G0_1_0_6_2 - 0.00287642045454556*G0_1_0_6_3 - 0.00262987012987023*G0_1_0_6_4 + 0.0678013392857166*G0_1_0_6_5 - 0.0285998376623386*G0_1_0_6_6 + 0.0456118100649366*G0_1_0_6_7 - 0.0212033279220786*G0_1_0_6_8 + 0.0202171266233774*G0_1_0_6_9 - 0.0808137175324704*G0_1_0_7_0 - 0.0150304383116888*G0_1_0_7_1 - 0.011131290584416*G0_1_0_7_2 + 0.00550629058441579*G0_1_0_7_3 + 0.00723214285714313*G0_1_0_7_4 - 0.0912236201298732*G0_1_0_7_5 + 0.0456118100649366*G0_1_0_7_6 - 0.182447240259747*G0_1_0_7_7 + 0.0678013392857167*G0_1_0_7_8 - 0.0468445616883134*G0_1_0_7_9 + 0.0367086038961052*G0_1_0_8_0 + 0.0065016233766236*G0_1_0_8_1 + 0.00503145292207809*G0_1_0_8_2 - 0.00262987012987022*G0_1_0_8_3 - 0.00287642045454556*G0_1_0_8_4 + 0.0456118100649366*G0_1_0_8_5 - 0.0212033279220786*G0_1_0_8_6 + 0.0678013392857167*G0_1_0_8_7 - 0.0285998376623387*G0_1_0_8_8 + 0.0202171266233774*G0_1_0_8_9 - 0.01479301948052*G0_1_0_9_0 - 0.00482142857142874*G0_1_0_9_1 - 0.00482142857142875*G0_1_0_9_2 + 0.00345170454545467*G0_1_0_9_3 + 0.00345170454545469*G0_1_0_9_4 - 0.0468445616883134*G0_1_0_9_5 + 0.0202171266233774*G0_1_0_9_6 - 0.0468445616883134*G0_1_0_9_7 + 0.0202171266233774*G0_1_0_9_8 - 0.0256412337662347*G0_1_0_9_9;
    A[44] = -A[64] + 0.00171672077922087*G0_1_0_0_0 - 0.000127840909090913*G0_1_0_0_1 - 0.00904017857142893*G0_1_0_0_2 + 0.00205458603896113*G0_1_0_0_3 + 0.00180803571428577*G0_1_0_0_4 + 0.000904017857142924*G0_1_0_0_5 - 0.00673904220779247*G0_1_0_0_6 - 0.000493100649350676*G0_1_0_0_8 + 0.00690340909090936*G0_1_0_0_9 - 0.000127840909090913*G0_1_0_1_0 + 0.00171672077922087*G0_1_0_1_1 - 0.00904017857142891*G0_1_0_1_2 + 0.000904017857142896*G0_1_0_1_3 - 0.00673904220779247*G0_1_0_1_4 + 0.00205458603896112*G0_1_0_1_5 + 0.00180803571428575*G0_1_0_1_6 - 0.00049310064935067*G0_1_0_1_7 + 0.00690340909090932*G0_1_0_1_9 - 0.00904017857142894*G0_1_0_2_0 - 0.00904017857142891*G0_1_0_2_1 - 0.161627435064941*G0_1_0_2_2 + 0.0394480519480533*G0_1_0_2_3 - 0.0912236201298733*G0_1_0_2_4 + 0.0394480519480534*G0_1_0_2_5 - 0.0912236201298735*G0_1_0_2_6 + 0.00328733766233778*G0_1_0_2_7 + 0.00328733766233777*G0_1_0_2_8 - 0.0246550324675333*G0_1_0_2_9 + 0.00205458603896113*G0_1_0_3_0 + 0.000904017857142896*G0_1_0_3_1 + 0.0394480519480533*G0_1_0_3_2 - 0.00147930194805187*G0_1_0_3_3 + 0.0369825487013001*G0_1_0_3_4 - 0.00887581168831203*G0_1_0_3_5 - 0.00073965097402604*G0_1_0_3_7 + 0.00517755681818203*G0_1_0_3_8 - 0.0192309253246758*G0_1_0_3_9 + 0.00180803571428577*G0_1_0_4_0 - 0.00673904220779247*G0_1_0_4_1 - 0.0912236201298733*G0_1_0_4_2 + 0.0369825487013001*G0_1_0_4_3 - 0.010355113636364*G0_1_0_4_7 - 0.004437905844156*G0_1_0_4_8 + 0.0739650974025999*G0_1_0_4_9 + 0.000904017857142925*G0_1_0_5_0 + 0.00205458603896112*G0_1_0_5_1 + 0.0394480519480534*G0_1_0_5_2 - 0.00887581168831203*G0_1_0_5_3 - 0.00147930194805206*G0_1_0_5_5 + 0.0369825487013*G0_1_0_5_6 + 0.00517755681818203*G0_1_0_5_7 - 0.000739650974026006*G0_1_0_5_8 - 0.019230925324676*G0_1_0_5_9 - 0.00673904220779247*G0_1_0_6_0 + 0.00180803571428575*G0_1_0_6_1 - 0.0912236201298735*G0_1_0_6_2 + 0.0369825487013*G0_1_0_6_5 - 0.004437905844156*G0_1_0_6_7 - 0.010355113636364*G0_1_0_6_8 + 0.0739650974025998*G0_1_0_6_9 - 0.00049310064935067*G0_1_0_7_1 + 0.00328733766233778*G0_1_0_7_2 - 0.00073965097402604*G0_1_0_7_3 - 0.010355113636364*G0_1_0_7_4 + 0.00517755681818203*G0_1_0_7_5 - 0.00443790584415601*G0_1_0_7_6 + 0.0118344155844162*G0_1_0_7_7 - 0.00147930194805205*G0_1_0_7_8 - 0.011834415584416*G0_1_0_7_9 - 0.000493100649350676*G0_1_0_8_0 + 0.00328733766233777*G0_1_0_8_2 + 0.00517755681818203*G0_1_0_8_3 - 0.004437905844156*G0_1_0_8_4 - 0.000739650974026006*G0_1_0_8_5 - 0.010355113636364*G0_1_0_8_6 - 0.00147930194805205*G0_1_0_8_7 + 0.0118344155844161*G0_1_0_8_8 - 0.0118344155844159*G0_1_0_8_9 + 0.00690340909090936*G0_1_0_9_0 + 0.00690340909090932*G0_1_0_9_1 - 0.0246550324675333*G0_1_0_9_2 - 0.0192309253246758*G0_1_0_9_3 + 0.0739650974025999*G0_1_0_9_4 - 0.019230925324676*G0_1_0_9_5 + 0.0739650974025998*G0_1_0_9_6 - 0.011834415584416*G0_1_0_9_7 - 0.0118344155844159*G0_1_0_9_8 + 0.142012987012992*G0_1_0_9_9 + 0.00633725649350678*G0_1_1_0_0 + 0.00288555194805207*G0_1_1_0_1 - 0.00229200487012996*G0_1_1_0_2 + 0.011834415584416*G0_1_1_0_3 + 0.011834415584416*G0_1_1_0_4 - 0.00714995941558463*G0_1_1_0_5 + 0.00394480519480533*G0_1_1_0_6 - 0.00657467532467551*G0_1_1_0_7 + 0.00673904220779244*G0_1_1_0_8 + 0.023668831168832*G0_1_1_0_9 + 0.00288555194805207*G0_1_1_1_0 + 0.0462966720779237*G0_1_1_1_1 + 0.000100446428571425*G0_1_1_1_2 + 0.00246550324675332*G0_1_1_1_3 - 0.0123275162337667*G0_1_1_1_4 + 0.00320515422077933*G0_1_1_1_5 + 0.00394480519480533*G0_1_1_1_6 - 0.0128206168831174*G0_1_1_1_7 + 0.0295860389610401*G0_1_1_1_8 + 0.00295860389610402*G0_1_1_1_9 - 0.00229200487012996*G0_1_1_2_0 + 0.000100446428571425*G0_1_1_2_1 - 0.01479301948052*G0_1_1_2_2 + 0.0078074269480522*G0_1_1_2_3 - 0.0378043831168845*G0_1_1_2_4 + 0.00945109577922113*G0_1_1_2_5 - 0.0189021915584422*G0_1_1_2_6 + 0.00468445616883134*G0_1_1_2_7 + 0.00764306006493532*G0_1_1_2_8 - 0.02218952922078*G0_1_1_2_9 + 0.011834415584416*G0_1_1_3_0 + 0.00246550324675332*G0_1_1_3_1 + 0.0078074269480522*G0_1_1_3_2 + 0.173078327922084*G0_1_1_3_3 + 0.0288463879870142*G0_1_1_3_4 - 0.021449878246754*G0_1_1_3_5 - 0.0140533685064939*G0_1_1_3_6 - 0.037722199675326*G0_1_1_3_7 + 0.0628703327922099*G0_1_1_3_8 + 0.0665685876623401*G0_1_1_3_9 + 0.011834415584416*G0_1_1_4_0 - 0.0123275162337667*G0_1_1_4_1 - 0.0378043831168845*G0_1_1_4_2 + 0.0288463879870142*G0_1_1_4_3 + 0.15532670454546*G0_1_1_4_4 - 0.037722199675326*G0_1_1_4_5 + 0.0517755681818199*G0_1_1_4_6 - 0.023668831168832*G0_1_1_4_7 - 0.0251481331168839*G0_1_1_4_8 + 0.142012987012992*G0_1_1_4_9 - 0.00714995941558464*G0_1_1_5_0 + 0.00320515422077933*G0_1_1_5_1 + 0.00945109577922113*G0_1_1_5_2 - 0.021449878246754*G0_1_1_5_3 - 0.037722199675326*G0_1_1_5_4 + 0.0355032467532479*G0_1_1_5_5 - 0.014053368506494*G0_1_1_5_6 + 0.028106737012988*G0_1_1_5_7 - 0.011834415584416*G0_1_1_5_8 - 0.047337662337664*G0_1_1_5_9 + 0.00394480519480533*G0_1_1_6_0 + 0.00394480519480533*G0_1_1_6_1 - 0.0189021915584422*G0_1_1_6_2 - 0.0140533685064939*G0_1_1_6_3 + 0.0517755681818199*G0_1_1_6_4 - 0.014053368506494*G0_1_1_6_5 + 0.0517755681818198*G0_1_1_6_6 - 0.016272321428572*G0_1_1_6_7 - 0.0162723214285719*G0_1_1_6_8 + 0.0946753246753278*G0_1_1_6_9 - 0.00657467532467551*G0_1_1_7_0 - 0.0128206168831174*G0_1_1_7_1 + 0.00468445616883134*G0_1_1_7_2 - 0.037722199675326*G0_1_1_7_3 - 0.023668831168832*G0_1_1_7_4 + 0.028106737012988*G0_1_1_7_5 - 0.016272321428572*G0_1_1_7_6 + 0.10355113636364*G0_1_1_7_7 - 0.0369825487013001*G0_1_1_7_8 - 0.0384618506493519*G0_1_1_7_9 + 0.00673904220779244*G0_1_1_8_0 + 0.0295860389610401*G0_1_1_8_1 + 0.00764306006493532*G0_1_1_8_2 + 0.06287033279221*G0_1_1_8_3 - 0.0251481331168839*G0_1_1_8_4 - 0.011834415584416*G0_1_1_8_5 - 0.0162723214285719*G0_1_1_8_6 - 0.0369825487013001*G0_1_1_8_7 + 0.204143668831176*G0_1_1_8_8 + 0.041420454545456*G0_1_1_8_9 + 0.023668831168832*G0_1_1_9_0 + 0.00295860389610403*G0_1_1_9_1 - 0.02218952922078*G0_1_1_9_2 + 0.0665685876623401*G0_1_1_9_3 + 0.142012987012992*G0_1_1_9_4 - 0.047337662337664*G0_1_1_9_5 + 0.0946753246753278*G0_1_1_9_6 - 0.0384618506493519*G0_1_1_9_7 + 0.0414204545454559*G0_1_1_9_8 + 0.550300324675343*G0_1_1_9_9;
    A[63] = A[36] - 0.0013879870129871*G0_0_1_0_0 + 0.000292207792207805*G0_0_1_0_1 - 0.00386262175324692*G0_0_1_0_2 + 0.000164366883116895*G0_0_1_0_3 + 0.00065746753246755*G0_0_1_0_4 - 0.00139711850649354*G0_0_1_0_5 - 0.0060815746753249*G0_0_1_0_6 - 0.000986201298701353*G0_0_1_0_7 + 0.00098620129870135*G0_0_1_0_8 - 0.00345170454545467*G0_0_1_0_9 + 0.000292207792207805*G0_0_1_1_0 + 0.00447443181818203*G0_0_1_1_1 - 0.00276684253246764*G0_0_1_1_2 + 0.0055062905844158*G0_0_1_1_3 - 0.0023833198051949*G0_0_1_1_4 + 0.00213676948051956*G0_0_1_1_5 + 0.000657467532467534*G0_0_1_1_6 - 0.00271205357142869*G0_0_1_1_7 + 0.00394480519480539*G0_0_1_1_8 + 0.005917207792208*G0_0_1_1_9 - 0.00386262175324692*G0_0_1_2_0 - 0.00276684253246764*G0_0_1_2_1 - 0.0734172077922104*G0_0_1_2_2 + 0.0142999188311693*G0_0_1_2_3 - 0.0283532873376634*G0_0_1_2_4 + 0.0167654220779227*G0_0_1_2_5 - 0.0456118100649368*G0_0_1_2_6 + 0.000164366883116886*G0_0_1_2_7 + 0.00262987012987022*G0_0_1_2_8 - 0.00641030844155866*G0_0_1_2_9 + 0.000164366883116895*G0_0_1_3_0 + 0.0055062905844158*G0_0_1_3_1 + 0.0142999188311693*G0_0_1_3_2 - 0.000739650974025972*G0_0_1_3_4 - 0.00443790584415599*G0_0_1_3_5 + 0.00147930194805198*G0_0_1_3_7 + 0.00443790584415603*G0_0_1_3_8 - 0.020710227272728*G0_0_1_3_9 + 0.00065746753246755*G0_0_1_4_0 - 0.0023833198051949*G0_0_1_4_1 - 0.0283532873376634*G0_0_1_4_2 - 0.000739650974025965*G0_0_1_4_3 + 0.0739650974025999*G0_0_1_4_4 - 0.00221895292207799*G0_0_1_4_7 - 0.00591720779220802*G0_0_1_4_8 + 0.0192309253246759*G0_0_1_4_9 - 0.00139711850649354*G0_0_1_5_0 + 0.00213676948051956*G0_0_1_5_1 + 0.0167654220779227*G0_0_1_5_2 - 0.004437905844156*G0_0_1_5_3 + 0.0414204545454559*G0_0_1_5_5 + 0.0362428977272741*G0_0_1_5_6 + 0.002958603896104*G0_0_1_5_7 - 0.004437905844156*G0_0_1_5_8 + 0.019230925324676*G0_0_1_5_9 - 0.0060815746753249*G0_0_1_6_0 + 0.000657467532467535*G0_0_1_6_1 - 0.0456118100649368*G0_0_1_6_2 + 0.0362428977272741*G0_0_1_6_5 + 0.00147930194805201*G0_0_1_6_7 - 0.00591720779220798*G0_0_1_6_8 + 0.0192309253246759*G0_0_1_6_9 - 0.000986201298701353*G0_0_1_7_0 - 0.00271205357142869*G0_0_1_7_1 + 0.000164366883116886*G0_0_1_7_2 + 0.00147930194805198*G0_0_1_7_3 - 0.00221895292207799*G0_0_1_7_4 + 0.002958603896104*G0_0_1_7_5 + 0.00147930194805201*G0_0_1_7_6 + 0.00295860389610401*G0_0_1_7_7 - 0.00147930194805204*G0_0_1_7_8 + 0.00739650974026*G0_0_1_7_9 + 0.00098620129870135*G0_0_1_8_0 + 0.00394480519480539*G0_0_1_8_1 + 0.00262987012987023*G0_0_1_8_2 + 0.00443790584415603*G0_0_1_8_3 - 0.00591720779220802*G0_0_1_8_4 - 0.004437905844156*G0_0_1_8_5 - 0.00591720779220799*G0_0_1_8_6 - 0.00147930194805204*G0_0_1_8_7 + 0.0207102272727281*G0_0_1_8_8 - 0.00591720779220796*G0_0_1_8_9 - 0.00345170454545467*G0_0_1_9_0 + 0.005917207792208*G0_0_1_9_1 - 0.00641030844155866*G0_0_1_9_2 - 0.020710227272728*G0_0_1_9_3 + 0.0192309253246759*G0_0_1_9_4 + 0.019230925324676*G0_0_1_9_5 + 0.0192309253246759*G0_0_1_9_6 + 0.00739650974026*G0_0_1_9_7 - 0.00591720779220796*G0_0_1_9_8 - 0.0887581168831199*G0_0_1_9_9 + 0.0013879870129871*G0_1_0_0_0 - 0.000292207792207805*G0_1_0_0_1 + 0.00386262175324692*G0_1_0_0_2 - 0.000164366883116895*G0_1_0_0_3 - 0.00065746753246755*G0_1_0_0_4 + 0.00139711850649354*G0_1_0_0_5 + 0.00608157467532491*G0_1_0_0_6 + 0.000986201298701353*G0_1_0_0_7 - 0.00098620129870135*G0_1_0_0_8 + 0.00345170454545467*G0_1_0_0_9 - 0.000292207792207805*G0_1_0_1_0 - 0.00447443181818203*G0_1_0_1_1 + 0.00276684253246764*G0_1_0_1_2 - 0.0055062905844158*G0_1_0_1_3 + 0.0023833198051949*G0_1_0_1_4 - 0.00213676948051956*G0_1_0_1_5 - 0.000657467532467534*G0_1_0_1_6 + 0.00271205357142869*G0_1_0_1_7 - 0.00394480519480539*G0_1_0_1_8 - 0.005917207792208*G0_1_0_1_9 + 0.00386262175324692*G0_1_0_2_0 + 0.00276684253246764*G0_1_0_2_1 + 0.0734172077922104*G0_1_0_2_2 - 0.0142999188311693*G0_1_0_2_3 + 0.0283532873376634*G0_1_0_2_4 - 0.0167654220779227*G0_1_0_2_5 + 0.0456118100649368*G0_1_0_2_6 - 0.000164366883116886*G0_1_0_2_7 - 0.00262987012987022*G0_1_0_2_8 + 0.00641030844155866*G0_1_0_2_9 - 0.000164366883116895*G0_1_0_3_0 - 0.0055062905844158*G0_1_0_3_1 - 0.0142999188311693*G0_1_0_3_2 + 0.000739650974025972*G0_1_0_3_4 + 0.00443790584415599*G0_1_0_3_5 - 0.00147930194805198*G0_1_0_3_7 - 0.00443790584415603*G0_1_0_3_8 + 0.020710227272728*G0_1_0_3_9 - 0.00065746753246755*G0_1_0_4_0 + 0.0023833198051949*G0_1_0_4_1 + 0.0283532873376634*G0_1_0_4_2 + 0.000739650974025965*G0_1_0_4_3 - 0.0739650974025999*G0_1_0_4_4 + 0.00221895292207799*G0_1_0_4_7 + 0.00591720779220802*G0_1_0_4_8 - 0.0192309253246759*G0_1_0_4_9 + 0.00139711850649354*G0_1_0_5_0 - 0.00213676948051956*G0_1_0_5_1 - 0.0167654220779227*G0_1_0_5_2 + 0.00443790584415599*G0_1_0_5_3 - 0.0414204545454559*G0_1_0_5_5 - 0.0362428977272741*G0_1_0_5_6 - 0.002958603896104*G0_1_0_5_7 + 0.004437905844156*G0_1_0_5_8 - 0.019230925324676*G0_1_0_5_9 + 0.0060815746753249*G0_1_0_6_0 - 0.000657467532467535*G0_1_0_6_1 + 0.0456118100649368*G0_1_0_6_2 - 0.0362428977272741*G0_1_0_6_5 - 0.00147930194805201*G0_1_0_6_7 + 0.00591720779220799*G0_1_0_6_8 - 0.0192309253246759*G0_1_0_6_9 + 0.000986201298701353*G0_1_0_7_0 + 0.00271205357142869*G0_1_0_7_1 - 0.000164366883116886*G0_1_0_7_2 - 0.00147930194805198*G0_1_0_7_3 + 0.00221895292207799*G0_1_0_7_4 - 0.002958603896104*G0_1_0_7_5 - 0.00147930194805201*G0_1_0_7_6 - 0.00295860389610401*G0_1_0_7_7 + 0.00147930194805204*G0_1_0_7_8 - 0.00739650974026*G0_1_0_7_9 - 0.00098620129870135*G0_1_0_8_0 - 0.00394480519480539*G0_1_0_8_1 - 0.00262987012987023*G0_1_0_8_2 - 0.00443790584415603*G0_1_0_8_3 + 0.00591720779220802*G0_1_0_8_4 + 0.004437905844156*G0_1_0_8_5 + 0.00591720779220799*G0_1_0_8_6 + 0.00147930194805204*G0_1_0_8_7 - 0.0207102272727282*G0_1_0_8_8 + 0.00591720779220796*G0_1_0_8_9 + 0.00345170454545467*G0_1_0_9_0 - 0.005917207792208*G0_1_0_9_1 + 0.00641030844155866*G0_1_0_9_2 + 0.020710227272728*G0_1_0_9_3 - 0.0192309253246759*G0_1_0_9_4 - 0.019230925324676*G0_1_0_9_5 - 0.0192309253246759*G0_1_0_9_6 - 0.00739650974026*G0_1_0_9_7 + 0.00591720779220796*G0_1_0_9_8 + 0.0887581168831199*G0_1_0_9_9;
    A[0] = A[11] + 0.067414772727275*G0_0_0_0_0 + 0.00363433441558453*G0_0_0_0_2 - 0.0058076298701301*G0_0_0_0_3 + 0.00115056818181823*G0_0_0_0_4 + 0.0416578733766248*G0_0_0_0_5 - 0.0187743506493513*G0_0_0_0_6 + 0.0453469967532483*G0_0_0_0_7 - 0.0261525974025983*G0_0_0_0_8 + 0.00536931818181839*G0_0_0_0_9 - 0.067414772727275*G0_0_0_1_1 - 0.00363433441558454*G0_0_0_1_2 - 0.0416578733766248*G0_0_0_1_3 + 0.0187743506493513*G0_0_0_1_4 + 0.00580762987013007*G0_0_0_1_5 - 0.00115056818181822*G0_0_0_1_6 + 0.0261525974025984*G0_0_0_1_7 - 0.0453469967532485*G0_0_0_1_8 - 0.0053693181818184*G0_0_0_1_9 + 0.00363433441558454*G0_0_0_2_0 - 0.00363433441558454*G0_0_0_2_1 - 0.00737824675324701*G0_0_0_2_3 + 0.0036891233766235*G0_0_0_2_4 + 0.00737824675324701*G0_0_0_2_5 - 0.00368912337662351*G0_0_0_2_6 + 0.00695819805194829*G0_0_0_2_7 - 0.0069581980519483*G0_0_0_2_8 - 0.0058076298701301*G0_0_0_3_0 - 0.0416578733766248*G0_0_0_3_1 - 0.00737824675324701*G0_0_0_3_2 - 0.0713352272727298*G0_0_0_3_3 + 0.0297504058441569*G0_0_0_3_4 + 0.00345170454545467*G0_0_0_3_6 + 0.0174228896103903*G0_0_0_3_7 - 0.0382974837662352*G0_0_0_3_8 - 0.0187378246753254*G0_0_0_3_9 + 0.00115056818181823*G0_0_0_4_0 + 0.0187743506493513*G0_0_0_4_1 + 0.0036891233766235*G0_0_0_4_2 + 0.0297504058441569*G0_0_0_4_3 - 0.00525974025974042*G0_0_0_4_4 - 0.00345170454545467*G0_0_0_4_5 - 0.0121631493506498*G0_0_0_4_7 + 0.0208745941558449*G0_0_0_4_8 + 0.00690340909090935*G0_0_0_4_9 + 0.0416578733766248*G0_0_0_5_0 + 0.00580762987013007*G0_0_0_5_1 + 0.00737824675324701*G0_0_0_5_2 - 0.00345170454545467*G0_0_0_5_4 + 0.0713352272727296*G0_0_0_5_5 - 0.0297504058441568*G0_0_0_5_6 + 0.0382974837662351*G0_0_0_5_7 - 0.0174228896103902*G0_0_0_5_8 + 0.0187378246753254*G0_0_0_5_9 - 0.0187743506493513*G0_0_0_6_0 - 0.00115056818181822*G0_0_0_6_1 - 0.00368912337662351*G0_0_0_6_2 + 0.00345170454545467*G0_0_0_6_3 - 0.0297504058441569*G0_0_0_6_5 + 0.00525974025974042*G0_0_0_6_6 - 0.0208745941558449*G0_0_0_6_7 + 0.0121631493506498*G0_0_0_6_8 - 0.00690340909090934*G0_0_0_6_9 + 0.0453469967532483*G0_0_0_7_0 + 0.0261525974025984*G0_0_0_7_1 + 0.00695819805194829*G0_0_0_7_2 + 0.0174228896103903*G0_0_0_7_3 - 0.0121631493506498*G0_0_0_7_4 + 0.0382974837662351*G0_0_0_7_5 - 0.0208745941558449*G0_0_0_7_6 + 0.0660754870129893*G0_0_0_7_7 + 0.0256412337662347*G0_0_0_7_9 - 0.0261525974025983*G0_0_0_8_0 - 0.0453469967532485*G0_0_0_8_1 - 0.0069581980519483*G0_0_0_8_2 - 0.0382974837662352*G0_0_0_8_3 + 0.0208745941558449*G0_0_0_8_4 - 0.0174228896103902*G0_0_0_8_5 + 0.0121631493506498*G0_0_0_8_6 - 0.0660754870129895*G0_0_0_8_8 - 0.0256412337662347*G0_0_0_8_9 + 0.00536931818181839*G0_0_0_9_0 - 0.0053693181818184*G0_0_0_9_1 - 0.0187378246753254*G0_0_0_9_3 + 0.00690340909090935*G0_0_0_9_4 + 0.0187378246753254*G0_0_0_9_5 - 0.00690340909090934*G0_0_0_9_6 + 0.0256412337662347*G0_0_0_9_7 - 0.0256412337662347*G0_0_0_9_8 + 0.0703057359307383*G0_0_1_0_0 + 0.0044862689393941*G0_0_1_0_1 + 0.00448626893939409*G0_0_1_0_2 - 0.000776176948051984*G0_0_1_0_3 - 0.000776176948051977*G0_0_1_0_4 + 0.0427049512987027*G0_0_1_0_5 - 0.0194500811688318*G0_0_1_0_6 + 0.0427049512987028*G0_0_1_0_7 - 0.0194500811688318*G0_0_1_0_8 + 0.00760957792207822*G0_0_1_0_9 + 0.0044862689393941*G0_0_1_1_0 + 0.0028909632034633*G0_0_1_1_1 + 0.000851934523809553*G0_0_1_1_2 + 0.00104707792207795*G0_0_1_1_3 - 0.000675730519480539*G0_0_1_1_4 + 0.00503145292207809*G0_0_1_1_5 - 0.00192674512987019*G0_0_1_1_6 + 0.00670251623376647*G0_0_1_1_7 - 0.00264204545454555*G0_0_1_1_8 + 0.00224025974025982*G0_0_1_1_9 + 0.00448626893939409*G0_0_1_2_0 + 0.000851934523809553*G0_0_1_2_1 + 0.00289096320346331*G0_0_1_2_2 - 0.000675730519480548*G0_0_1_2_3 + 0.00104707792207796*G0_0_1_2_4 + 0.00670251623376646*G0_0_1_2_5 - 0.00264204545454554*G0_0_1_2_6 + 0.00503145292207809*G0_0_1_2_7 - 0.0019267451298702*G0_0_1_2_8 + 0.00224025974025982*G0_0_1_2_9 - 0.000776176948051984*G0_0_1_3_0 + 0.00104707792207795*G0_0_1_3_1 - 0.000675730519480548*G0_0_1_3_2 + 0.013222402597403*G0_0_1_3_3 - 0.00280336850649359*G0_0_1_3_4 - 0.00336038961038972*G0_0_1_3_5 - 0.000264813311688321*G0_0_1_3_6 - 0.00371651785714299*G0_0_1_3_7 + 0.0039813311688313*G0_0_1_3_8 + 0.000712256493506512*G0_0_1_3_9 - 0.000776176948051977*G0_0_1_4_0 - 0.000675730519480539*G0_0_1_4_1 + 0.00104707792207796*G0_0_1_4_2 - 0.00280336850649359*G0_0_1_4_3 + 0.0132224025974031*G0_0_1_4_4 - 0.003716517857143*G0_0_1_4_5 + 0.00398133116883132*G0_0_1_4_6 - 0.00336038961038974*G0_0_1_4_7 - 0.000264813311688313*G0_0_1_4_8 + 0.000712256493506514*G0_0_1_4_9 + 0.0427049512987027*G0_0_1_5_0 + 0.00503145292207809*G0_0_1_5_1 + 0.00670251623376646*G0_0_1_5_2 - 0.00336038961038972*G0_0_1_5_3 - 0.003716517857143*G0_0_1_5_4 + 0.0845576298701327*G0_0_1_5_5 - 0.0325537743506505*G0_0_1_5_6 + 0.0422788149350664*G0_0_1_5_7 - 0.0211394074675332*G0_0_1_5_8 + 0.0194500811688319*G0_0_1_5_9 - 0.0194500811688318*G0_0_1_6_0 - 0.00192674512987019*G0_0_1_6_1 - 0.00264204545454554*G0_0_1_6_2 - 0.000264813311688321*G0_0_1_6_3 + 0.00398133116883132*G0_0_1_6_4 - 0.0325537743506505*G0_0_1_6_5 + 0.0184821428571435*G0_0_1_6_6 - 0.0211394074675332*G0_0_1_6_7 + 0.00880275974026004*G0_0_1_6_8 - 0.00619115259740283*G0_0_1_6_9 + 0.0427049512987028*G0_0_1_7_0 + 0.00670251623376647*G0_0_1_7_1 + 0.00503145292207809*G0_0_1_7_2 - 0.00371651785714299*G0_0_1_7_3 - 0.00336038961038974*G0_0_1_7_4 + 0.0422788149350664*G0_0_1_7_5 - 0.0211394074675332*G0_0_1_7_6 + 0.0845576298701329*G0_0_1_7_7 - 0.0325537743506505*G0_0_1_7_8 + 0.0194500811688319*G0_0_1_7_9 - 0.0194500811688318*G0_0_1_8_0 - 0.00264204545454555*G0_0_1_8_1 - 0.0019267451298702*G0_0_1_8_2 + 0.0039813311688313*G0_0_1_8_3 - 0.000264813311688313*G0_0_1_8_4 - 0.0211394074675332*G0_0_1_8_5 + 0.00880275974026004*G0_0_1_8_6 - 0.0325537743506505*G0_0_1_8_7 + 0.0184821428571435*G0_0_1_8_8 - 0.00619115259740283*G0_0_1_8_9 + 0.00760957792207822*G0_0_1_9_0 + 0.00224025974025982*G0_0_1_9_1 + 0.00224025974025982*G0_0_1_9_2 + 0.000712256493506511*G0_0_1_9_3 + 0.000712256493506514*G0_0_1_9_4 + 0.0194500811688319*G0_0_1_9_5 - 0.00619115259740282*G0_0_1_9_6 + 0.0194500811688319*G0_0_1_9_7 - 0.00619115259740283*G0_0_1_9_8 + 0.0282711038961049*G0_0_1_9_9 + 0.0703057359307383*G0_1_0_0_0 + 0.0044862689393941*G0_1_0_0_1 + 0.00448626893939409*G0_1_0_0_2 - 0.000776176948051984*G0_1_0_0_3 - 0.000776176948051977*G0_1_0_0_4 + 0.0427049512987027*G0_1_0_0_5 - 0.0194500811688318*G0_1_0_0_6 + 0.0427049512987028*G0_1_0_0_7 - 0.0194500811688318*G0_1_0_0_8 + 0.00760957792207822*G0_1_0_0_9 + 0.0044862689393941*G0_1_0_1_0 + 0.0028909632034633*G0_1_0_1_1 + 0.000851934523809553*G0_1_0_1_2 + 0.00104707792207795*G0_1_0_1_3 - 0.000675730519480539*G0_1_0_1_4 + 0.00503145292207809*G0_1_0_1_5 - 0.00192674512987019*G0_1_0_1_6 + 0.00670251623376647*G0_1_0_1_7 - 0.00264204545454555*G0_1_0_1_8 + 0.00224025974025982*G0_1_0_1_9 + 0.00448626893939409*G0_1_0_2_0 + 0.000851934523809553*G0_1_0_2_1 + 0.00289096320346331*G0_1_0_2_2 - 0.000675730519480548*G0_1_0_2_3 + 0.00104707792207796*G0_1_0_2_4 + 0.00670251623376646*G0_1_0_2_5 - 0.00264204545454554*G0_1_0_2_6 + 0.00503145292207809*G0_1_0_2_7 - 0.0019267451298702*G0_1_0_2_8 + 0.00224025974025982*G0_1_0_2_9 - 0.000776176948051984*G0_1_0_3_0 + 0.00104707792207795*G0_1_0_3_1 - 0.000675730519480548*G0_1_0_3_2 + 0.013222402597403*G0_1_0_3_3 - 0.00280336850649359*G0_1_0_3_4 - 0.00336038961038972*G0_1_0_3_5 - 0.000264813311688321*G0_1_0_3_6 - 0.00371651785714299*G0_1_0_3_7 + 0.0039813311688313*G0_1_0_3_8 + 0.000712256493506512*G0_1_0_3_9 - 0.000776176948051977*G0_1_0_4_0 - 0.000675730519480539*G0_1_0_4_1 + 0.00104707792207796*G0_1_0_4_2 - 0.00280336850649359*G0_1_0_4_3 + 0.0132224025974031*G0_1_0_4_4 - 0.003716517857143*G0_1_0_4_5 + 0.00398133116883132*G0_1_0_4_6 - 0.00336038961038974*G0_1_0_4_7 - 0.000264813311688313*G0_1_0_4_8 + 0.000712256493506514*G0_1_0_4_9 + 0.0427049512987027*G0_1_0_5_0 + 0.00503145292207809*G0_1_0_5_1 + 0.00670251623376646*G0_1_0_5_2 - 0.00336038961038972*G0_1_0_5_3 - 0.003716517857143*G0_1_0_5_4 + 0.0845576298701327*G0_1_0_5_5 - 0.0325537743506505*G0_1_0_5_6 + 0.0422788149350664*G0_1_0_5_7 - 0.0211394074675332*G0_1_0_5_8 + 0.0194500811688319*G0_1_0_5_9 - 0.0194500811688318*G0_1_0_6_0 - 0.00192674512987019*G0_1_0_6_1 - 0.00264204545454554*G0_1_0_6_2 - 0.000264813311688321*G0_1_0_6_3 + 0.00398133116883132*G0_1_0_6_4 - 0.0325537743506505*G0_1_0_6_5 + 0.0184821428571435*G0_1_0_6_6 - 0.0211394074675332*G0_1_0_6_7 + 0.00880275974026004*G0_1_0_6_8 - 0.00619115259740282*G0_1_0_6_9 + 0.0427049512987028*G0_1_0_7_0 + 0.00670251623376647*G0_1_0_7_1 + 0.00503145292207809*G0_1_0_7_2 - 0.00371651785714299*G0_1_0_7_3 - 0.00336038961038974*G0_1_0_7_4 + 0.0422788149350664*G0_1_0_7_5 - 0.0211394074675332*G0_1_0_7_6 + 0.0845576298701329*G0_1_0_7_7 - 0.0325537743506505*G0_1_0_7_8 + 0.0194500811688319*G0_1_0_7_9 - 0.0194500811688318*G0_1_0_8_0 - 0.00264204545454555*G0_1_0_8_1 - 0.0019267451298702*G0_1_0_8_2 + 0.0039813311688313*G0_1_0_8_3 - 0.000264813311688313*G0_1_0_8_4 - 0.0211394074675332*G0_1_0_8_5 + 0.00880275974026004*G0_1_0_8_6 - 0.0325537743506505*G0_1_0_8_7 + 0.0184821428571435*G0_1_0_8_8 - 0.00619115259740283*G0_1_0_8_9 + 0.00760957792207822*G0_1_0_9_0 + 0.00224025974025982*G0_1_0_9_1 + 0.00224025974025982*G0_1_0_9_2 + 0.000712256493506511*G0_1_0_9_3 + 0.000712256493506514*G0_1_0_9_4 + 0.0194500811688319*G0_1_0_9_5 - 0.00619115259740282*G0_1_0_9_6 + 0.0194500811688319*G0_1_0_9_7 - 0.00619115259740283*G0_1_0_9_8 + 0.0282711038961049*G0_1_0_9_9 + 0.0703057359307383*G0_1_1_0_0 + 0.0044862689393941*G0_1_1_0_1 + 0.00448626893939409*G0_1_1_0_2 - 0.000776176948051983*G0_1_1_0_3 - 0.000776176948051977*G0_1_1_0_4 + 0.0427049512987027*G0_1_1_0_5 - 0.0194500811688318*G0_1_1_0_6 + 0.0427049512987028*G0_1_1_0_7 - 0.0194500811688318*G0_1_1_0_8 + 0.00760957792207822*G0_1_1_0_9 + 0.0044862689393941*G0_1_1_1_0 + 0.0028909632034633*G0_1_1_1_1 + 0.000851934523809554*G0_1_1_1_2 + 0.00104707792207795*G0_1_1_1_3 - 0.00067573051948054*G0_1_1_1_4 + 0.00503145292207809*G0_1_1_1_5 - 0.00192674512987019*G0_1_1_1_6 + 0.00670251623376647*G0_1_1_1_7 - 0.00264204545454555*G0_1_1_1_8 + 0.00224025974025982*G0_1_1_1_9 + 0.00448626893939409*G0_1_1_2_0 + 0.000851934523809553*G0_1_1_2_1 + 0.00289096320346331*G0_1_1_2_2 - 0.000675730519480547*G0_1_1_2_3 + 0.00104707792207796*G0_1_1_2_4 + 0.00670251623376646*G0_1_1_2_5 - 0.00264204545454554*G0_1_1_2_6 + 0.00503145292207809*G0_1_1_2_7 - 0.0019267451298702*G0_1_1_2_8 + 0.00224025974025982*G0_1_1_2_9 - 0.000776176948051983*G0_1_1_3_0 + 0.00104707792207795*G0_1_1_3_1 - 0.000675730519480547*G0_1_1_3_2 + 0.013222402597403*G0_1_1_3_3 - 0.0028033685064936*G0_1_1_3_4 - 0.00336038961038972*G0_1_1_3_5 - 0.000264813311688322*G0_1_1_3_6 - 0.00371651785714299*G0_1_1_3_7 + 0.00398133116883131*G0_1_1_3_8 + 0.000712256493506516*G0_1_1_3_9 - 0.000776176948051977*G0_1_1_4_0 - 0.00067573051948054*G0_1_1_4_1 + 0.00104707792207796*G0_1_1_4_2 - 0.0028033685064936*G0_1_1_4_3 + 0.0132224025974031*G0_1_1_4_4 - 0.003716517857143*G0_1_1_4_5 + 0.00398133116883132*G0_1_1_4_6 - 0.00336038961038974*G0_1_1_4_7 - 0.000264813311688315*G0_1_1_4_8 + 0.000712256493506515*G0_1_1_4_9 + 0.0427049512987027*G0_1_1_5_0 + 0.00503145292207809*G0_1_1_5_1 + 0.00670251623376646*G0_1_1_5_2 - 0.00336038961038972*G0_1_1_5_3 - 0.003716517857143*G0_1_1_5_4 + 0.0845576298701327*G0_1_1_5_5 - 0.0325537743506505*G0_1_1_5_6 + 0.0422788149350664*G0_1_1_5_7 - 0.0211394074675332*G0_1_1_5_8 + 0.0194500811688319*G0_1_1_5_9 - 0.0194500811688318*G0_1_1_6_0 - 0.00192674512987019*G0_1_1_6_1 - 0.00264204545454554*G0_1_1_6_2 - 0.000264813311688322*G0_1_1_6_3 + 0.00398133116883132*G0_1_1_6_4 - 0.0325537743506505*G0_1_1_6_5 + 0.0184821428571435*G0_1_1_6_6 - 0.0211394074675332*G0_1_1_6_7 + 0.00880275974026004*G0_1_1_6_8 - 0.00619115259740282*G0_1_1_6_9 + 0.0427049512987028*G0_1_1_7_0 + 0.00670251623376647*G0_1_1_7_1 + 0.00503145292207809*G0_1_1_7_2 - 0.00371651785714299*G0_1_1_7_3 - 0.00336038961038974*G0_1_1_7_4 + 0.0422788149350664*G0_1_1_7_5 - 0.0211394074675332*G0_1_1_7_6 + 0.0845576298701329*G0_1_1_7_7 - 0.0325537743506505*G0_1_1_7_8 + 0.0194500811688319*G0_1_1_7_9 - 0.0194500811688318*G0_1_1_8_0 - 0.00264204545454555*G0_1_1_8_1 - 0.0019267451298702*G0_1_1_8_2 + 0.00398133116883131*G0_1_1_8_3 - 0.000264813311688315*G0_1_1_8_4 - 0.0211394074675332*G0_1_1_8_5 + 0.00880275974026004*G0_1_1_8_6 - 0.0325537743506505*G0_1_1_8_7 + 0.0184821428571435*G0_1_1_8_8 - 0.00619115259740283*G0_1_1_8_9 + 0.00760957792207822*G0_1_1_9_0 + 0.00224025974025982*G0_1_1_9_1 + 0.00224025974025982*G0_1_1_9_2 + 0.000712256493506516*G0_1_1_9_3 + 0.000712256493506515*G0_1_1_9_4 + 0.0194500811688319*G0_1_1_9_5 - 0.00619115259740282*G0_1_1_9_6 + 0.0194500811688319*G0_1_1_9_7 - 0.00619115259740283*G0_1_1_9_8 + 0.0282711038961049*G0_1_1_9_9;
    A[79] = A[97] + 0.0295860389610402*G0_0_1_0_0 + 0.00295860389610402*G0_0_1_0_1 + 0.00372564935064948*G0_0_1_0_2 + 0.00246550324675333*G0_0_1_0_3 - 0.00147930194805201*G0_0_1_0_4 + 0.0221895292207801*G0_0_1_0_5 - 0.0138068181818187*G0_0_1_0_6 + 0.0468445616883134*G0_0_1_0_7 - 0.00887581168831208*G0_0_1_0_8 + 0.0128206168831174*G0_0_1_0_9 + 0.00295860389610402*G0_0_1_1_0 + 0.00986201298701333*G0_0_1_1_1 + 0.00301339285714296*G0_0_1_1_2 + 0.00739650974026*G0_0_1_1_3 - 0.00690340909090934*G0_0_1_1_4 + 0.0138068181818187*G0_0_1_1_5 - 0.004437905844156*G0_0_1_1_6 + 0.017751623376624*G0_0_1_1_7 + 0.0123275162337667*G0_0_1_1_8 + 0.0285998376623387*G0_0_1_1_9 + 0.00372564935064948*G0_0_1_2_0 + 0.00301339285714296*G0_0_1_2_1 + 0.000328733766233769*G0_0_1_2_2 - 0.00197240259740265*G0_0_1_2_3 + 0.00147930194805198*G0_0_1_2_4 + 0.00788961038961068*G0_0_1_2_5 - 0.00295860389610401*G0_0_1_2_6 + 0.00197240259740267*G0_0_1_2_7 - 0.0167654220779226*G0_0_1_2_8 - 0.01479301948052*G0_0_1_2_9 + 0.00246550324675333*G0_0_1_3_0 + 0.00739650974026*G0_0_1_3_1 - 0.00197240259740265*G0_0_1_3_2 + 0.0384618506493523*G0_0_1_3_3 - 0.001479301948052*G0_0_1_3_4 - 0.017751623376624*G0_0_1_3_5 - 0.020710227272728*G0_0_1_3_7 - 0.0162723214285719*G0_0_1_3_8 - 0.0443790584415598*G0_0_1_3_9 - 0.00147930194805201*G0_0_1_4_0 - 0.00690340909090934*G0_0_1_4_1 + 0.00147930194805198*G0_0_1_4_2 - 0.001479301948052*G0_0_1_4_3 + 0.0118344155844158*G0_0_1_4_4 - 0.008875811688312*G0_0_1_4_5 + 0.00887581168831196*G0_0_1_4_6 + 0.00591720779220802*G0_0_1_4_7 + 0.0369825487013*G0_0_1_4_8 + 0.0621306818181838*G0_0_1_4_9 + 0.0221895292207801*G0_0_1_5_0 + 0.0138068181818187*G0_0_1_5_1 + 0.00788961038961068*G0_0_1_5_2 - 0.017751623376624*G0_0_1_5_3 - 0.008875811688312*G0_0_1_5_4 + 0.1479301948052*G0_0_1_5_5 - 0.038461850649352*G0_0_1_5_6 + 0.0739650974026*G0_0_1_5_7 - 0.054734172077924*G0_0_1_5_8 + 0.071006493506496*G0_0_1_5_9 - 0.0138068181818187*G0_0_1_6_0 - 0.004437905844156*G0_0_1_6_1 - 0.00295860389610402*G0_0_1_6_2 + 0.00887581168831196*G0_0_1_6_4 - 0.038461850649352*G0_0_1_6_5 + 0.0414204545454558*G0_0_1_6_6 - 0.019230925324676*G0_0_1_6_7 + 0.038461850649352*G0_0_1_6_8 + 0.0443790584415599*G0_0_1_6_9 + 0.0468445616883134*G0_0_1_7_0 + 0.017751623376624*G0_0_1_7_1 + 0.00197240259740267*G0_0_1_7_2 - 0.020710227272728*G0_0_1_7_3 + 0.00591720779220802*G0_0_1_7_4 + 0.0739650974026*G0_0_1_7_5 - 0.019230925324676*G0_0_1_7_6 - 0.106509740259744*G0_0_1_7_8 - 0.00887581168831207*G0_0_1_8_0 + 0.0123275162337667*G0_0_1_8_1 - 0.0167654220779226*G0_0_1_8_2 - 0.0162723214285719*G0_0_1_8_3 + 0.0369825487013*G0_0_1_8_4 - 0.054734172077924*G0_0_1_8_5 + 0.038461850649352*G0_0_1_8_6 - 0.106509740259744*G0_0_1_8_7 - 0.213019480519488*G0_0_1_8_8 - 0.159764610389616*G0_0_1_8_9 + 0.0128206168831174*G0_0_1_9_0 + 0.0285998376623387*G0_0_1_9_1 - 0.01479301948052*G0_0_1_9_2 - 0.0443790584415598*G0_0_1_9_3 + 0.0621306818181838*G0_0_1_9_4 + 0.071006493506496*G0_0_1_9_5 + 0.0443790584415599*G0_0_1_9_6 - 0.159764610389616*G0_0_1_9_8 - 0.0295860389610402*G0_1_0_0_0 - 0.00295860389610402*G0_1_0_0_1 - 0.00372564935064948*G0_1_0_0_2 - 0.00246550324675333*G0_1_0_0_3 + 0.00147930194805201*G0_1_0_0_4 - 0.0221895292207801*G0_1_0_0_5 + 0.0138068181818187*G0_1_0_0_6 - 0.0468445616883134*G0_1_0_0_7 + 0.00887581168831207*G0_1_0_0_8 - 0.0128206168831174*G0_1_0_0_9 - 0.00295860389610402*G0_1_0_1_0 - 0.00986201298701333*G0_1_0_1_1 - 0.00301339285714296*G0_1_0_1_2 - 0.00739650974026*G0_1_0_1_3 + 0.00690340909090934*G0_1_0_1_4 - 0.0138068181818187*G0_1_0_1_5 + 0.004437905844156*G0_1_0_1_6 - 0.017751623376624*G0_1_0_1_7 - 0.0123275162337667*G0_1_0_1_8 - 0.0285998376623387*G0_1_0_1_9 - 0.00372564935064948*G0_1_0_2_0 - 0.00301339285714296*G0_1_0_2_1 - 0.000328733766233769*G0_1_0_2_2 + 0.00197240259740265*G0_1_0_2_3 - 0.00147930194805198*G0_1_0_2_4 - 0.00788961038961068*G0_1_0_2_5 + 0.00295860389610401*G0_1_0_2_6 - 0.00197240259740267*G0_1_0_2_7 + 0.0167654220779226*G0_1_0_2_8 + 0.01479301948052*G0_1_0_2_9 - 0.00246550324675333*G0_1_0_3_0 - 0.00739650974026*G0_1_0_3_1 + 0.00197240259740265*G0_1_0_3_2 - 0.0384618506493523*G0_1_0_3_3 + 0.00147930194805201*G0_1_0_3_4 + 0.017751623376624*G0_1_0_3_5 + 0.020710227272728*G0_1_0_3_7 + 0.0162723214285719*G0_1_0_3_8 + 0.0443790584415598*G0_1_0_3_9 + 0.00147930194805201*G0_1_0_4_0 + 0.00690340909090934*G0_1_0_4_1 - 0.00147930194805198*G0_1_0_4_2 + 0.00147930194805201*G0_1_0_4_3 - 0.0118344155844158*G0_1_0_4_4 + 0.00887581168831201*G0_1_0_4_5 - 0.00887581168831196*G0_1_0_4_6 - 0.00591720779220802*G0_1_0_4_7 - 0.0369825487013*G0_1_0_4_8 - 0.0621306818181838*G0_1_0_4_9 - 0.0221895292207801*G0_1_0_5_0 - 0.0138068181818187*G0_1_0_5_1 - 0.00788961038961068*G0_1_0_5_2 + 0.017751623376624*G0_1_0_5_3 + 0.008875811688312*G0_1_0_5_4 - 0.1479301948052*G0_1_0_5_5 + 0.038461850649352*G0_1_0_5_6 - 0.0739650974026*G0_1_0_5_7 + 0.054734172077924*G0_1_0_5_8 - 0.071006493506496*G0_1_0_5_9 + 0.0138068181818187*G0_1_0_6_0 + 0.004437905844156*G0_1_0_6_1 + 0.00295860389610402*G0_1_0_6_2 - 0.00887581168831196*G0_1_0_6_4 + 0.038461850649352*G0_1_0_6_5 - 0.0414204545454558*G0_1_0_6_6 + 0.019230925324676*G0_1_0_6_7 - 0.038461850649352*G0_1_0_6_8 - 0.0443790584415599*G0_1_0_6_9 - 0.0468445616883134*G0_1_0_7_0 - 0.017751623376624*G0_1_0_7_1 - 0.00197240259740267*G0_1_0_7_2 + 0.020710227272728*G0_1_0_7_3 - 0.00591720779220802*G0_1_0_7_4 - 0.0739650974026*G0_1_0_7_5 + 0.019230925324676*G0_1_0_7_6 + 0.106509740259744*G0_1_0_7_8 + 0.00887581168831207*G0_1_0_8_0 - 0.0123275162337667*G0_1_0_8_1 + 0.0167654220779226*G0_1_0_8_2 + 0.0162723214285719*G0_1_0_8_3 - 0.0369825487013*G0_1_0_8_4 + 0.054734172077924*G0_1_0_8_5 - 0.038461850649352*G0_1_0_8_6 + 0.106509740259744*G0_1_0_8_7 + 0.213019480519488*G0_1_0_8_8 + 0.159764610389616*G0_1_0_8_9 - 0.0128206168831174*G0_1_0_9_0 - 0.0285998376623387*G0_1_0_9_1 + 0.01479301948052*G0_1_0_9_2 + 0.0443790584415598*G0_1_0_9_3 - 0.0621306818181838*G0_1_0_9_4 - 0.071006493506496*G0_1_0_9_5 - 0.0443790584415599*G0_1_0_9_6 + 0.159764610389616*G0_1_0_9_8;
    A[38] = A[83] - 0.0017167207792208*G0_0_1_0_0 + 0.00904017857142893*G0_0_1_0_1 + 0.000127840909090921*G0_0_1_0_2 - 0.00180803571428576*G0_0_1_0_3 - 0.00205458603896112*G0_0_1_0_4 + 0.000493100649350663*G0_0_1_0_6 - 0.000904017857142895*G0_0_1_0_7 + 0.00673904220779247*G0_0_1_0_8 - 0.00690340909090933*G0_0_1_0_9 + 0.00904017857142893*G0_0_1_1_0 + 0.161627435064941*G0_0_1_1_1 + 0.00904017857142887*G0_0_1_1_2 + 0.0912236201298731*G0_0_1_1_3 - 0.0394480519480532*G0_0_1_1_4 - 0.00328733766233777*G0_0_1_1_5 - 0.00328733766233777*G0_0_1_1_6 - 0.0394480519480534*G0_0_1_1_7 + 0.0912236201298735*G0_0_1_1_8 + 0.0246550324675334*G0_0_1_1_9 + 0.000127840909090921*G0_0_1_2_0 + 0.00904017857142887*G0_0_1_2_1 - 0.0017167207792208*G0_0_1_2_2 + 0.00673904220779243*G0_0_1_2_3 - 0.00090401785714287*G0_0_1_2_4 + 0.000493100649350651*G0_0_1_2_5 - 0.00205458603896112*G0_0_1_2_7 - 0.00180803571428576*G0_0_1_2_8 - 0.00690340909090931*G0_0_1_2_9 - 0.00180803571428576*G0_0_1_3_0 + 0.0912236201298731*G0_0_1_3_1 + 0.00673904220779243*G0_0_1_3_2 - 0.0369825487012999*G0_0_1_3_4 + 0.010355113636364*G0_0_1_3_5 + 0.00443790584415597*G0_0_1_3_6 - 0.0739650974025998*G0_0_1_3_9 - 0.00205458603896112*G0_0_1_4_0 - 0.0394480519480532*G0_0_1_4_1 - 0.000904017857142871*G0_0_1_4_2 - 0.0369825487012999*G0_0_1_4_3 + 0.00147930194805201*G0_0_1_4_4 + 0.000739650974025996*G0_0_1_4_5 - 0.00517755681818197*G0_0_1_4_6 + 0.00887581168831203*G0_0_1_4_7 + 0.0192309253246759*G0_0_1_4_9 - 0.00328733766233777*G0_0_1_5_1 + 0.00049310064935065*G0_0_1_5_2 + 0.010355113636364*G0_0_1_5_3 + 0.000739650974025997*G0_0_1_5_4 - 0.011834415584416*G0_0_1_5_5 + 0.00147930194805197*G0_0_1_5_6 - 0.005177556818182*G0_0_1_5_7 + 0.00443790584415599*G0_0_1_5_8 + 0.011834415584416*G0_0_1_5_9 + 0.000493100649350663*G0_0_1_6_0 - 0.00328733766233777*G0_0_1_6_1 + 0.00443790584415597*G0_0_1_6_3 - 0.00517755681818197*G0_0_1_6_4 + 0.00147930194805197*G0_0_1_6_5 - 0.0118344155844159*G0_0_1_6_6 + 0.00073965097402601*G0_0_1_6_7 + 0.010355113636364*G0_0_1_6_8 + 0.011834415584416*G0_0_1_6_9 - 0.000904017857142896*G0_0_1_7_0 - 0.0394480519480534*G0_0_1_7_1 - 0.00205458603896112*G0_0_1_7_2 + 0.00887581168831204*G0_0_1_7_4 - 0.005177556818182*G0_0_1_7_5 + 0.00073965097402601*G0_0_1_7_6 + 0.001479301948052*G0_0_1_7_7 - 0.0369825487013002*G0_0_1_7_8 + 0.0192309253246759*G0_0_1_7_9 + 0.00673904220779247*G0_0_1_8_0 + 0.0912236201298735*G0_0_1_8_1 - 0.00180803571428576*G0_0_1_8_2 + 0.00443790584415599*G0_0_1_8_5 + 0.010355113636364*G0_0_1_8_6 - 0.0369825487013002*G0_0_1_8_7 - 0.0739650974025999*G0_0_1_8_9 - 0.00690340909090933*G0_0_1_9_0 + 0.0246550324675334*G0_0_1_9_1 - 0.00690340909090931*G0_0_1_9_2 - 0.0739650974025998*G0_0_1_9_3 + 0.0192309253246759*G0_0_1_9_4 + 0.011834415584416*G0_0_1_9_5 + 0.011834415584416*G0_0_1_9_6 + 0.0192309253246759*G0_0_1_9_7 - 0.0739650974025999*G0_0_1_9_8 - 0.142012987012992*G0_0_1_9_9 + 0.0017167207792208*G0_1_0_0_0 - 0.00904017857142893*G0_1_0_0_1 - 0.000127840909090921*G0_1_0_0_2 + 0.00180803571428577*G0_1_0_0_3 + 0.00205458603896112*G0_1_0_0_4 - 0.000493100649350663*G0_1_0_0_6 + 0.000904017857142895*G0_1_0_0_7 - 0.00673904220779248*G0_1_0_0_8 + 0.00690340909090933*G0_1_0_0_9 - 0.00904017857142893*G0_1_0_1_0 - 0.161627435064941*G0_1_0_1_1 - 0.00904017857142887*G0_1_0_1_2 - 0.0912236201298731*G0_1_0_1_3 + 0.0394480519480532*G0_1_0_1_4 + 0.00328733766233777*G0_1_0_1_5 + 0.00328733766233777*G0_1_0_1_6 + 0.0394480519480534*G0_1_0_1_7 - 0.0912236201298735*G0_1_0_1_8 - 0.0246550324675334*G0_1_0_1_9 - 0.000127840909090921*G0_1_0_2_0 - 0.00904017857142886*G0_1_0_2_1 + 0.0017167207792208*G0_1_0_2_2 - 0.00673904220779242*G0_1_0_2_3 + 0.000904017857142868*G0_1_0_2_4 - 0.000493100649350651*G0_1_0_2_5 + 0.00205458603896112*G0_1_0_2_7 + 0.00180803571428576*G0_1_0_2_8 + 0.00690340909090931*G0_1_0_2_9 + 0.00180803571428577*G0_1_0_3_0 - 0.0912236201298731*G0_1_0_3_1 - 0.00673904220779242*G0_1_0_3_2 + 0.0369825487012999*G0_1_0_3_4 - 0.010355113636364*G0_1_0_3_5 - 0.00443790584415597*G0_1_0_3_6 + 0.0739650974025998*G0_1_0_3_9 + 0.00205458603896112*G0_1_0_4_0 + 0.0394480519480532*G0_1_0_4_1 + 0.00090401785714287*G0_1_0_4_2 + 0.0369825487012999*G0_1_0_4_3 - 0.001479301948052*G0_1_0_4_4 - 0.000739650974025996*G0_1_0_4_5 + 0.00517755681818197*G0_1_0_4_6 - 0.00887581168831203*G0_1_0_4_7 - 0.0192309253246759*G0_1_0_4_9 + 0.00328733766233777*G0_1_0_5_1 - 0.000493100649350651*G0_1_0_5_2 - 0.010355113636364*G0_1_0_5_3 - 0.000739650974025996*G0_1_0_5_4 + 0.011834415584416*G0_1_0_5_5 - 0.00147930194805197*G0_1_0_5_6 + 0.005177556818182*G0_1_0_5_7 - 0.00443790584415599*G0_1_0_5_8 - 0.011834415584416*G0_1_0_5_9 - 0.000493100649350663*G0_1_0_6_0 + 0.00328733766233777*G0_1_0_6_1 - 0.00443790584415597*G0_1_0_6_3 + 0.00517755681818197*G0_1_0_6_4 - 0.00147930194805197*G0_1_0_6_5 + 0.0118344155844159*G0_1_0_6_6 - 0.00073965097402601*G0_1_0_6_7 - 0.010355113636364*G0_1_0_6_8 - 0.011834415584416*G0_1_0_6_9 + 0.000904017857142896*G0_1_0_7_0 + 0.0394480519480534*G0_1_0_7_1 + 0.00205458603896112*G0_1_0_7_2 - 0.00887581168831204*G0_1_0_7_4 + 0.005177556818182*G0_1_0_7_5 - 0.00073965097402601*G0_1_0_7_6 - 0.001479301948052*G0_1_0_7_7 + 0.0369825487013002*G0_1_0_7_8 - 0.0192309253246759*G0_1_0_7_9 - 0.00673904220779248*G0_1_0_8_0 - 0.0912236201298735*G0_1_0_8_1 + 0.00180803571428576*G0_1_0_8_2 - 0.00443790584415599*G0_1_0_8_5 - 0.010355113636364*G0_1_0_8_6 + 0.0369825487013002*G0_1_0_8_7 + 0.0739650974025999*G0_1_0_8_9 + 0.00690340909090933*G0_1_0_9_0 - 0.0246550324675334*G0_1_0_9_1 + 0.00690340909090931*G0_1_0_9_2 + 0.0739650974025998*G0_1_0_9_3 - 0.0192309253246759*G0_1_0_9_4 - 0.011834415584416*G0_1_0_9_5 - 0.011834415584416*G0_1_0_9_6 - 0.0192309253246759*G0_1_0_9_7 + 0.0739650974025998*G0_1_0_9_8 + 0.142012987012992*G0_1_0_9_9;
    A[20] = -A[21] - 0.00949066558441591*G0_1_0_0_0 - 0.000118709415584418*G0_1_0_0_2 + 0.000438311688311705*G0_1_0_0_3 - 0.000575284090909114*G0_1_0_0_4 - 0.00373478084415597*G0_1_0_0_5 + 0.00305905032467543*G0_1_0_0_6 - 0.00820921266233794*G0_1_0_0_7 + 0.00461140422077938*G0_1_0_0_8 - 0.000712256493506522*G0_1_0_0_9 + 0.0094906655844159*G0_1_0_1_1 + 0.000118709415584419*G0_1_0_1_2 + 0.00373478084415597*G0_1_0_1_3 - 0.00305905032467543*G0_1_0_1_4 - 0.000438311688311703*G0_1_0_1_5 + 0.000575284090909113*G0_1_0_1_6 - 0.00461140422077938*G0_1_0_1_7 + 0.00820921266233796*G0_1_0_1_8 + 0.00071225649350652*G0_1_0_1_9 - 0.000118709415584418*G0_1_0_2_0 + 0.000118709415584418*G0_1_0_2_1 + 0.00155235389610395*G0_1_0_2_3 - 0.00447443181818197*G0_1_0_2_4 - 0.00155235389610395*G0_1_0_2_5 + 0.00447443181818198*G0_1_0_2_6 - 0.00101359577922081*G0_1_0_2_7 + 0.00101359577922081*G0_1_0_2_8 + 0.000438311688311705*G0_1_0_3_0 + 0.00373478084415597*G0_1_0_3_1 + 0.00155235389610395*G0_1_0_3_2 - 0.00131493506493514*G0_1_0_3_3 + 0.00583502435064956*G0_1_0_3_4 - 0.00172585227272733*G0_1_0_3_6 - 0.0013149350649351*G0_1_0_3_7 + 0.00435572240259754*G0_1_0_3_8 + 0.000493100649350655*G0_1_0_3_9 - 0.000575284090909114*G0_1_0_4_0 - 0.00305905032467543*G0_1_0_4_1 - 0.00447443181818197*G0_1_0_4_2 + 0.00583502435064956*G0_1_0_4_3 - 0.0254768668831178*G0_1_0_4_4 + 0.00172585227272733*G0_1_0_4_5 + 0.00238331980519489*G0_1_0_4_7 - 0.00304078733766243*G0_1_0_4_8 - 0.00345170454545467*G0_1_0_4_9 - 0.00373478084415597*G0_1_0_5_0 - 0.000438311688311703*G0_1_0_5_1 - 0.00155235389610395*G0_1_0_5_2 + 0.00172585227272733*G0_1_0_5_4 + 0.00131493506493512*G0_1_0_5_5 - 0.00583502435064956*G0_1_0_5_6 - 0.00435572240259754*G0_1_0_5_7 + 0.00131493506493511*G0_1_0_5_8 - 0.000493100649350661*G0_1_0_5_9 + 0.00305905032467543*G0_1_0_6_0 + 0.000575284090909113*G0_1_0_6_1 + 0.00447443181818198*G0_1_0_6_2 - 0.00172585227272733*G0_1_0_6_3 - 0.00583502435064956*G0_1_0_6_5 + 0.0254768668831178*G0_1_0_6_6 + 0.00304078733766244*G0_1_0_6_7 - 0.00238331980519488*G0_1_0_6_8 + 0.00345170454545466*G0_1_0_6_9 - 0.00820921266233794*G0_1_0_7_0 - 0.00461140422077939*G0_1_0_7_1 - 0.00101359577922081*G0_1_0_7_2 - 0.0013149350649351*G0_1_0_7_3 + 0.00238331980519489*G0_1_0_7_4 - 0.00435572240259754*G0_1_0_7_5 + 0.00304078733766244*G0_1_0_7_6 - 0.0241619318181826*G0_1_0_7_7 - 0.00394480519480533*G0_1_0_7_9 + 0.00461140422077938*G0_1_0_8_0 + 0.00820921266233796*G0_1_0_8_1 + 0.00101359577922081*G0_1_0_8_2 + 0.00435572240259754*G0_1_0_8_3 - 0.00304078733766243*G0_1_0_8_4 + 0.00131493506493511*G0_1_0_8_5 - 0.00238331980519488*G0_1_0_8_6 + 0.0241619318181826*G0_1_0_8_8 + 0.00394480519480532*G0_1_0_8_9 - 0.000712256493506522*G0_1_0_9_0 + 0.00071225649350652*G0_1_0_9_1 + 0.000493100649350656*G0_1_0_9_3 - 0.00345170454545467*G0_1_0_9_4 - 0.000493100649350661*G0_1_0_9_5 + 0.00345170454545466*G0_1_0_9_6 - 0.00394480519480533*G0_1_0_9_7 + 0.00394480519480532*G0_1_0_9_8 - 0.011194534632035*G0_1_1_0_0 - 0.000851934523809554*G0_1_1_0_1 - 0.000970643939393977*G0_1_1_0_2 + 0.000447443181818202*G0_1_1_0_3 - 0.000566152597402623*G0_1_1_0_4 - 0.00375913149350661*G0_1_1_0_5 + 0.00193587662337668*G0_1_1_0_6 - 0.00823356331168859*G0_1_1_0_7 + 0.00348823051948064*G0_1_1_0_8 - 0.000980113636363675*G0_1_1_0_9 - 0.000851934523809554*G0_1_1_1_0 - 0.0017038690476191*G0_1_1_1_1 - 0.000851934523809556*G0_1_1_1_2 - 0.00112317370129875*G0_1_1_1_4 - 0.00112317370129874*G0_1_1_1_7 - 0.000267857142857154*G0_1_1_1_9 - 0.000970643939393977*G0_1_1_2_0 - 0.000851934523809556*G0_1_1_2_1 - 0.011194534632035*G0_1_1_2_2 + 0.00348823051948065*G0_1_1_2_3 - 0.00823356331168862*G0_1_1_2_4 + 0.0019358766233767*G0_1_1_2_5 - 0.00375913149350665*G0_1_1_2_6 - 0.000566152597402615*G0_1_1_2_7 + 0.000447443181818196*G0_1_1_2_8 - 0.000980113636363674*G0_1_1_2_9 + 0.000447443181818202*G0_1_1_3_0 + 0.00348823051948065*G0_1_1_3_2 + 0.00189935064935071*G0_1_1_3_3 + 0.00658380681818206*G0_1_1_3_4 - 0.00124188311688316*G0_1_1_3_5 + 0.00108664772727278*G0_1_1_3_6 - 0.000228287337662342*G0_1_1_3_7 + 0.000456574675324685*G0_1_1_3_8 + 0.00126014610389615*G0_1_1_3_9 - 0.000566152597402623*G0_1_1_4_0 - 0.00112317370129875*G0_1_1_4_1 - 0.00823356331168862*G0_1_1_4_2 + 0.00658380681818206*G0_1_1_4_3 - 0.022262581168832*G0_1_1_4_4 + 0.00281250000000011*G0_1_1_4_5 - 0.00389914772727289*G0_1_1_4_6 + 0.00114143668831173*G0_1_1_4_7 - 0.000228287337662342*G0_1_1_4_8 - 0.00268465909090919*G0_1_1_4_9 - 0.00375913149350661*G0_1_1_5_0 + 0.0019358766233767*G0_1_1_5_2 - 0.00124188311688316*G0_1_1_5_3 + 0.00281250000000011*G0_1_1_5_4 + 0.00321428571428582*G0_1_1_5_5 + 0.000748782467532506*G0_1_1_5_6 - 0.00389914772727285*G0_1_1_5_7 + 0.00108664772727276*G0_1_1_5_8 + 0.000767045454545484*G0_1_1_5_9 + 0.00193587662337668*G0_1_1_6_0 - 0.00375913149350665*G0_1_1_6_2 + 0.00108664772727278*G0_1_1_6_3 - 0.00389914772727289*G0_1_1_6_4 + 0.000748782467532506*G0_1_1_6_5 + 0.00321428571428579*G0_1_1_6_6 + 0.00281250000000009*G0_1_1_6_7 - 0.00124188311688315*G0_1_1_6_8 + 0.000767045454545472*G0_1_1_6_9 - 0.00823356331168859*G0_1_1_7_0 - 0.00112317370129874*G0_1_1_7_1 - 0.000566152597402615*G0_1_1_7_2 - 0.000228287337662342*G0_1_1_7_3 + 0.00114143668831173*G0_1_1_7_4 - 0.00389914772727285*G0_1_1_7_5 + 0.00281250000000009*G0_1_1_7_6 - 0.0222625811688319*G0_1_1_7_7 + 0.00658380681818205*G0_1_1_7_8 - 0.00268465909090919*G0_1_1_7_9 + 0.00348823051948064*G0_1_1_8_0 + 0.000447443181818196*G0_1_1_8_2 + 0.000456574675324685*G0_1_1_8_3 - 0.000228287337662342*G0_1_1_8_4 + 0.00108664772727276*G0_1_1_8_5 - 0.00124188311688315*G0_1_1_8_6 + 0.00658380681818205*G0_1_1_8_7 + 0.0018993506493507*G0_1_1_8_8 + 0.00126014610389615*G0_1_1_8_9 - 0.000980113636363675*G0_1_1_9_0 - 0.000267857142857154*G0_1_1_9_1 - 0.000980113636363674*G0_1_1_9_2 + 0.00126014610389615*G0_1_1_9_3 - 0.00268465909090919*G0_1_1_9_4 + 0.000767045454545484*G0_1_1_9_5 + 0.000767045454545472*G0_1_1_9_6 - 0.00268465909090919*G0_1_1_9_7 + 0.00126014610389614*G0_1_1_9_8 - 0.0105194805194809*G0_1_1_9_9;
    A[18] = -A[13] - 0.0107021103896107*G0_0_0_0_0 - 0.00522017045454566*G0_0_0_0_1 - 0.00155235389610395*G0_0_0_0_2 - 0.00168932629870137*G0_0_0_0_3 - 0.0013331980519481*G0_0_0_0_4 - 0.00590807629870149*G0_0_0_0_5 + 0.00154322240259743*G0_0_0_0_6 + 0.000374391233766265*G0_0_0_0_7 - 0.00214590097402608*G0_0_0_0_8 - 0.000821834415584455*G0_0_0_0_9 - 0.00522017045454566*G0_0_0_1_0 - 0.0932021103896135*G0_0_0_1_1 - 0.00522017045454563*G0_0_0_1_2 - 0.0452008928571443*G0_0_0_1_3 + 0.0208198051948059*G0_0_0_1_4 - 0.000593547077922093*G0_0_0_1_5 - 0.000593547077922107*G0_0_0_1_6 + 0.020819805194806*G0_0_0_1_7 - 0.0452008928571446*G0_0_0_1_8 - 0.00712256493506522*G0_0_0_1_9 - 0.00155235389610395*G0_0_0_2_0 - 0.00522017045454563*G0_0_0_2_1 - 0.0107021103896108*G0_0_0_2_2 - 0.00214590097402603*G0_0_0_2_3 + 0.000374391233766223*G0_0_0_2_4 + 0.00154322240259747*G0_0_0_2_5 - 0.00590807629870154*G0_0_0_2_6 - 0.00133319805194809*G0_0_0_2_7 - 0.00168932629870136*G0_0_0_2_8 - 0.000821834415584454*G0_0_0_2_9 - 0.00168932629870136*G0_0_0_3_0 - 0.0452008928571443*G0_0_0_3_1 - 0.00214590097402603*G0_0_0_3_2 - 0.0378043831168843*G0_0_0_3_3 + 0.0201349431818188*G0_0_0_3_4 + 0.00123275162337665*G0_0_0_3_5 + 0.00616375811688333*G0_0_0_3_6 + 0.00945109577922114*G0_0_0_3_7 - 0.0189021915584423*G0_0_0_3_8 + 0.00246550324675333*G0_0_0_3_9 - 0.0013331980519481*G0_0_0_4_0 + 0.0208198051948059*G0_0_0_4_1 + 0.000374391233766223*G0_0_0_4_2 + 0.0201349431818188*G0_0_0_4_3 - 0.0368181818181831*G0_0_0_4_4 + 0.00838271103896133*G0_0_0_4_5 - 0.0145464691558447*G0_0_0_4_6 + 0.00180803571428576*G0_0_0_4_7 + 0.00945109577922113*G0_0_0_4_8 - 0.0142999188311693*G0_0_0_4_9 - 0.00590807629870149*G0_0_0_5_0 - 0.000593547077922093*G0_0_0_5_1 + 0.00154322240259747*G0_0_0_5_2 + 0.00123275162337665*G0_0_0_5_3 + 0.00838271103896133*G0_0_0_5_4 - 0.0613088474025994*G0_0_0_5_5 + 0.0146286525974031*G0_0_0_5_6 - 0.0145464691558446*G0_0_0_5_7 + 0.00616375811688333*G0_0_0_5_8 - 0.00986201298701333*G0_0_0_5_9 + 0.00154322240259743*G0_0_0_6_0 - 0.000593547077922107*G0_0_0_6_1 - 0.00590807629870154*G0_0_0_6_2 + 0.00616375811688333*G0_0_0_6_3 - 0.0145464691558447*G0_0_0_6_4 + 0.0146286525974031*G0_0_0_6_5 - 0.0613088474025995*G0_0_0_6_6 + 0.00838271103896132*G0_0_0_6_7 + 0.00123275162337666*G0_0_0_6_8 - 0.00986201298701332*G0_0_0_6_9 + 0.000374391233766265*G0_0_0_7_0 + 0.020819805194806*G0_0_0_7_1 - 0.00133319805194809*G0_0_0_7_2 + 0.00945109577922114*G0_0_0_7_3 + 0.00180803571428576*G0_0_0_7_4 - 0.0145464691558446*G0_0_0_7_5 + 0.00838271103896132*G0_0_0_7_6 - 0.0368181818181832*G0_0_0_7_7 + 0.020134943181819*G0_0_0_7_8 - 0.0142999188311693*G0_0_0_7_9 - 0.00214590097402608*G0_0_0_8_0 - 0.0452008928571446*G0_0_0_8_1 - 0.00168932629870136*G0_0_0_8_2 - 0.0189021915584423*G0_0_0_8_3 + 0.00945109577922113*G0_0_0_8_4 + 0.00616375811688332*G0_0_0_8_5 + 0.00123275162337666*G0_0_0_8_6 + 0.020134943181819*G0_0_0_8_7 - 0.0378043831168846*G0_0_0_8_8 + 0.00246550324675333*G0_0_0_8_9 - 0.000821834415584454*G0_0_0_9_0 - 0.00712256493506522*G0_0_0_9_1 - 0.000821834415584454*G0_0_0_9_2 + 0.00246550324675332*G0_0_0_9_3 - 0.0142999188311693*G0_0_0_9_4 - 0.00986201298701333*G0_0_0_9_5 - 0.00986201298701332*G0_0_0_9_6 - 0.0142999188311693*G0_0_0_9_7 + 0.00246550324675333*G0_0_0_9_8 - 0.104537337662341*G0_0_0_9_9;
    A[88] = -A[83] + 0.0445799512987028*G0_0_0_0_0 + 0.00914062500000034*G0_0_0_0_1 + 0.00301339285714296*G0_0_0_0_2 + 0.00213676948051956*G0_0_0_0_3 + 0.00115056818181821*G0_0_0_0_4 + 0.0295860389610399*G0_0_0_0_5 - 0.0123275162337666*G0_0_0_0_6 + 0.00156148538961039*G0_0_0_0_7 - 0.00558847402597416*G0_0_0_0_8 - 0.0039448051948053*G0_0_0_0_9 + 0.00914062500000034*G0_0_0_1_0 + 0.14683441558442*G0_0_0_1_1 + 0.00674817370129892*G0_0_0_1_2 + 0.0723214285714309*G0_0_0_1_3 - 0.0299969561688321*G0_0_0_1_4 + 0.00435572240259754*G0_0_0_1_5 + 0.00139711850649356*G0_0_0_1_6 - 0.0316406250000012*G0_0_0_1_7 + 0.053419237012989*G0_0_0_1_8 + 0.0024655032467534*G0_0_0_1_9 + 0.00301339285714296*G0_0_0_2_0 + 0.00674817370129892*G0_0_0_2_1 + 0.00462053571428591*G0_0_0_2_2 + 0.0106838474025977*G0_0_0_2_3 - 0.00805397727272751*G0_0_0_2_4 + 0.00723214285714308*G0_0_0_2_5 - 0.0065746753246755*G0_0_0_2_6 + 0.00977982954545488*G0_0_0_2_7 + 0.0100263798701302*G0_0_0_2_8 + 0.0167654220779227*G0_0_0_2_9 + 0.00213676948051956*G0_0_0_3_0 + 0.0723214285714309*G0_0_0_3_1 + 0.0106838474025977*G0_0_0_3_2 + 0.0517755681818196*G0_0_0_3_3 - 0.0510359172077939*G0_0_0_3_4 - 0.00591720779220797*G0_0_0_3_5 - 0.011834415584416*G0_0_0_3_6 - 0.0140533685064941*G0_0_0_3_7 + 0.05177556818182*G0_0_0_3_8 + 0.020710227272728*G0_0_0_3_9 + 0.00115056818181821*G0_0_0_4_0 - 0.0299969561688321*G0_0_0_4_1 - 0.00805397727272751*G0_0_0_4_2 - 0.0510359172077939*G0_0_0_4_3 + 0.0369825487012998*G0_0_0_4_4 - 0.01109476461039*G0_0_0_4_5 + 0.022929180194806*G0_0_0_4_6 - 0.012574066558442*G0_0_0_4_7 - 0.037722199675326*G0_0_0_4_8 - 0.0281067370129881*G0_0_0_4_9 + 0.0295860389610399*G0_0_0_5_0 + 0.00435572240259754*G0_0_0_5_1 + 0.00723214285714308*G0_0_0_5_2 - 0.00591720779220797*G0_0_0_5_3 - 0.01109476461039*G0_0_0_5_4 + 0.19230925324676*G0_0_0_5_5 - 0.0355032467532479*G0_0_0_5_6 + 0.057692775974028*G0_0_0_5_7 - 0.020710227272728*G0_0_0_5_8 + 0.053254870129872*G0_0_0_5_9 - 0.0123275162337666*G0_0_0_6_0 + 0.00139711850649356*G0_0_0_6_1 - 0.0065746753246755*G0_0_0_6_2 - 0.011834415584416*G0_0_0_6_3 + 0.022929180194806*G0_0_0_6_4 - 0.0355032467532479*G0_0_0_6_5 + 0.091716720779224*G0_0_0_6_6 - 0.0369825487013*G0_0_0_6_7 - 0.013313717532468*G0_0_0_6_8 - 0.026627435064936*G0_0_0_6_9 + 0.00156148538961039*G0_0_0_7_0 - 0.0316406250000012*G0_0_0_7_1 + 0.00977982954545488*G0_0_0_7_2 - 0.0140533685064941*G0_0_0_7_3 - 0.012574066558442*G0_0_0_7_4 + 0.057692775974028*G0_0_0_7_5 - 0.0369825487013*G0_0_0_7_6 + 0.174557629870136*G0_0_0_7_7 - 0.00813616071428613*G0_0_0_7_8 + 0.0857995129870161*G0_0_0_7_9 - 0.00558847402597416*G0_0_0_8_0 + 0.053419237012989*G0_0_0_8_1 + 0.0100263798701302*G0_0_0_8_2 + 0.05177556818182*G0_0_0_8_3 - 0.037722199675326*G0_0_0_8_4 - 0.020710227272728*G0_0_0_8_5 - 0.013313717532468*G0_0_0_8_6 - 0.00813616071428614*G0_0_0_8_7 + 0.15532670454546*G0_0_0_8_8 + 0.0680478896103919*G0_0_0_8_9 - 0.0039448051948053*G0_0_0_9_0 + 0.0024655032467534*G0_0_0_9_1 + 0.0167654220779227*G0_0_0_9_2 + 0.020710227272728*G0_0_0_9_3 - 0.0281067370129881*G0_0_0_9_4 + 0.053254870129872*G0_0_0_9_5 - 0.026627435064936*G0_0_0_9_6 + 0.0857995129870161*G0_0_0_9_7 + 0.0680478896103919*G0_0_0_9_8 + 0.408287337662351*G0_0_0_9_9 - 0.0017167207792208*G0_1_0_0_0 + 0.00904017857142893*G0_1_0_0_1 + 0.000127840909090921*G0_1_0_0_2 - 0.00180803571428576*G0_1_0_0_3 - 0.00205458603896112*G0_1_0_0_4 + 0.000493100649350666*G0_1_0_0_6 - 0.000904017857142899*G0_1_0_0_7 + 0.00673904220779248*G0_1_0_0_8 - 0.00690340909090933*G0_1_0_0_9 + 0.00904017857142893*G0_1_0_1_0 + 0.161627435064941*G0_1_0_1_1 + 0.00904017857142887*G0_1_0_1_2 + 0.0912236201298732*G0_1_0_1_3 - 0.0394480519480532*G0_1_0_1_4 - 0.00328733766233778*G0_1_0_1_5 - 0.00328733766233777*G0_1_0_1_6 - 0.0394480519480534*G0_1_0_1_7 + 0.0912236201298736*G0_1_0_1_8 + 0.0246550324675334*G0_1_0_1_9 + 0.000127840909090921*G0_1_0_2_0 + 0.00904017857142887*G0_1_0_2_1 - 0.0017167207792208*G0_1_0_2_2 + 0.00673904220779243*G0_1_0_2_3 - 0.000904017857142871*G0_1_0_2_4 + 0.000493100649350651*G0_1_0_2_5 - 0.00205458603896112*G0_1_0_2_7 - 0.00180803571428576*G0_1_0_2_8 - 0.00690340909090931*G0_1_0_2_9 - 0.00180803571428576*G0_1_0_3_0 + 0.0912236201298732*G0_1_0_3_1 + 0.00673904220779243*G0_1_0_3_2 - 0.0369825487012999*G0_1_0_3_4 + 0.010355113636364*G0_1_0_3_5 + 0.00443790584415597*G0_1_0_3_6 - 0.0739650974025998*G0_1_0_3_9 - 0.00205458603896112*G0_1_0_4_0 - 0.0394480519480532*G0_1_0_4_1 - 0.000904017857142873*G0_1_0_4_2 - 0.0369825487012999*G0_1_0_4_3 + 0.00147930194805201*G0_1_0_4_4 + 0.000739650974025995*G0_1_0_4_5 - 0.00517755681818197*G0_1_0_4_6 + 0.00887581168831203*G0_1_0_4_7 + 0.0192309253246759*G0_1_0_4_9 - 0.00328733766233778*G0_1_0_5_1 + 0.000493100649350651*G0_1_0_5_2 + 0.010355113636364*G0_1_0_5_3 + 0.000739650974025995*G0_1_0_5_4 - 0.011834415584416*G0_1_0_5_5 + 0.00147930194805197*G0_1_0_5_6 - 0.005177556818182*G0_1_0_5_7 + 0.00443790584415599*G0_1_0_5_8 + 0.011834415584416*G0_1_0_5_9 + 0.000493100649350666*G0_1_0_6_0 - 0.00328733766233777*G0_1_0_6_1 + 0.00443790584415596*G0_1_0_6_3 - 0.00517755681818197*G0_1_0_6_4 + 0.00147930194805197*G0_1_0_6_5 - 0.0118344155844159*G0_1_0_6_6 + 0.000739650974026004*G0_1_0_6_7 + 0.010355113636364*G0_1_0_6_8 + 0.011834415584416*G0_1_0_6_9 - 0.000904017857142899*G0_1_0_7_0 - 0.0394480519480534*G0_1_0_7_1 - 0.00205458603896112*G0_1_0_7_2 + 0.00887581168831204*G0_1_0_7_4 - 0.005177556818182*G0_1_0_7_5 + 0.000739650974026004*G0_1_0_7_6 + 0.00147930194805205*G0_1_0_7_7 - 0.0369825487013002*G0_1_0_7_8 + 0.0192309253246759*G0_1_0_7_9 + 0.00673904220779248*G0_1_0_8_0 + 0.0912236201298736*G0_1_0_8_1 - 0.00180803571428576*G0_1_0_8_2 + 0.00443790584415599*G0_1_0_8_5 + 0.010355113636364*G0_1_0_8_6 - 0.0369825487013002*G0_1_0_8_7 - 0.0739650974025998*G0_1_0_8_9 - 0.00690340909090933*G0_1_0_9_0 + 0.0246550324675334*G0_1_0_9_1 - 0.00690340909090931*G0_1_0_9_2 - 0.0739650974025998*G0_1_0_9_3 + 0.0192309253246759*G0_1_0_9_4 + 0.011834415584416*G0_1_0_9_5 + 0.011834415584416*G0_1_0_9_6 + 0.0192309253246759*G0_1_0_9_7 - 0.0739650974025998*G0_1_0_9_8 - 0.142012987012992*G0_1_0_9_9;
    A[43] = -A[63] + 0.00341517857142874*G0_1_0_0_0 - 0.00166193181818187*G0_1_0_0_1 + 0.00249289772727283*G0_1_0_0_2 + 0.0119165990259745*G0_1_0_0_3 + 0.0114234983766238*G0_1_0_0_4 - 0.00378043831168845*G0_1_0_0_5 + 0.00928672889610422*G0_1_0_0_6 - 0.00419135551948065*G0_1_0_0_7 + 0.00221895292207799*G0_1_0_0_8 + 0.0261343344155853*G0_1_0_0_9 - 0.00166193181818187*G0_1_0_1_0 - 0.00611810064935085*G0_1_0_1_1 + 0.00325994318181831*G0_1_0_1_2 - 0.0190665584415591*G0_1_0_1_3 - 0.000575284090909117*G0_1_0_1_4 - 0.00041091720779223*G0_1_0_1_5 - 0.000410917207792213*G0_1_0_1_6 + 0.00714995941558466*G0_1_0_1_7 - 0.0101085633116887*G0_1_0_1_8 - 0.0172585227272733*G0_1_0_1_9 + 0.00249289772727283*G0_1_0_2_0 + 0.00325994318181831*G0_1_0_2_1 + 0.0717735389610414*G0_1_0_2_2 - 0.0172585227272733*G0_1_0_2_3 + 0.01479301948052*G0_1_0_2_4 - 0.0123275162337667*G0_1_0_2_5 + 0.0394480519480534*G0_1_0_2_6 + 0.00156148538961044*G0_1_0_2_7 - 0.00238331980519488*G0_1_0_2_8 - 0.00493100649350665*G0_1_0_2_9 + 0.0119165990259745*G0_1_0_3_0 - 0.0190665584415591*G0_1_0_3_1 - 0.0172585227272733*G0_1_0_3_2 + 0.2218952922078*G0_1_0_3_3 + 0.0229291801948061*G0_1_0_3_4 - 0.016272321428572*G0_1_0_3_5 - 0.000739650974026018*G0_1_0_3_6 - 0.037722199675326*G0_1_0_3_7 + 0.032544642857144*G0_1_0_3_8 + 0.127219967532472*G0_1_0_3_9 + 0.0114234983766238*G0_1_0_4_0 - 0.000575284090909117*G0_1_0_4_1 + 0.01479301948052*G0_1_0_4_2 + 0.0229291801948061*G0_1_0_4_3 + 0.1479301948052*G0_1_0_4_4 - 0.036242897727274*G0_1_0_4_5 + 0.0369825487013*G0_1_0_4_6 - 0.01849127435065*G0_1_0_4_7 + 0.00517755681818198*G0_1_0_4_8 + 0.0872788149350679*G0_1_0_4_9 - 0.00378043831168845*G0_1_0_5_0 - 0.000410917207792229*G0_1_0_5_1 - 0.0123275162337667*G0_1_0_5_2 - 0.016272321428572*G0_1_0_5_3 - 0.036242897727274*G0_1_0_5_4 - 0.0325446428571439*G0_1_0_5_5 - 0.045118709415586*G0_1_0_5_6 + 0.00739650974025999*G0_1_0_5_7 - 0.000739650974026004*G0_1_0_5_8 - 0.0769237012987039*G0_1_0_5_9 + 0.00928672889610422*G0_1_0_6_0 - 0.000410917207792213*G0_1_0_6_1 + 0.0394480519480534*G0_1_0_6_2 - 0.000739650974026021*G0_1_0_6_3 + 0.0369825487013*G0_1_0_6_4 - 0.045118709415586*G0_1_0_6_5 - 0.00665685876623399*G0_1_0_6_7 + 0.00517755681818198*G0_1_0_6_8 + 0.016272321428572*G0_1_0_6_9 - 0.00419135551948065*G0_1_0_7_0 + 0.00714995941558466*G0_1_0_7_1 + 0.00156148538961044*G0_1_0_7_2 - 0.037722199675326*G0_1_0_7_3 - 0.01849127435065*G0_1_0_7_4 + 0.00739650974025999*G0_1_0_7_5 - 0.00665685876623399*G0_1_0_7_6 + 0.00591720779220799*G0_1_0_7_7 - 0.00739650974026*G0_1_0_7_8 - 0.0650892857142879*G0_1_0_7_9 + 0.00221895292207799*G0_1_0_8_0 - 0.0101085633116887*G0_1_0_8_1 - 0.00238331980519488*G0_1_0_8_2 + 0.032544642857144*G0_1_0_8_3 + 0.00517755681818198*G0_1_0_8_4 - 0.000739650974026003*G0_1_0_8_5 + 0.00517755681818198*G0_1_0_8_6 - 0.00739650974026*G0_1_0_8_7 - 0.020710227272728*G0_1_0_8_8 + 0.041420454545456*G0_1_0_8_9 + 0.0261343344155853*G0_1_0_9_0 - 0.0172585227272733*G0_1_0_9_1 - 0.00493100649350665*G0_1_0_9_2 + 0.127219967532472*G0_1_0_9_3 + 0.0872788149350679*G0_1_0_9_4 - 0.0769237012987039*G0_1_0_9_5 + 0.016272321428572*G0_1_0_9_6 - 0.0650892857142879*G0_1_0_9_7 + 0.041420454545456*G0_1_0_9_8 + 0.408287337662351*G0_1_0_9_9 + 0.00162540584415586*G0_1_1_0_0 - 0.00705864448051976*G0_1_1_0_1 - 0.000100446428571437*G0_1_1_0_2 + 0.00271205357142868*G0_1_1_0_3 + 0.00197240259740267*G0_1_1_0_4 + 0.00147930194805198*G0_1_1_0_5 - 0.000493100649350664*G0_1_1_0_6 + 0.00846489448051975*G0_1_1_0_7 - 0.0119987824675329*G0_1_1_0_8 + 0.00641030844155867*G0_1_1_0_9 - 0.00705864448051976*G0_1_1_1_0 - 0.0925933441558473*G0_1_1_1_1 - 0.00373478084415597*G0_1_1_1_2 - 0.0406808035714299*G0_1_1_1_3 + 0.0172585227272733*G0_1_1_1_4 + 0.001479301948052*G0_1_1_1_5 + 0.0345170454545467*G0_1_1_1_7 - 0.0727323457792234*G0_1_1_1_8 - 0.0172585227272733*G0_1_1_1_9 - 0.000100446428571437*G0_1_1_2_0 - 0.00373478084415597*G0_1_1_2_1 + 0.00273944805194808*G0_1_1_2_2 - 0.00476663961038975*G0_1_1_2_3 + 0.00410917207792219*G0_1_1_2_4 - 0.000657467532467542*G0_1_1_2_5 + 0.00328733766233774*G0_1_1_2_6 + 0.00221895292207799*G0_1_1_2_7 - 0.00961546266233798*G0_1_1_2_8 + 0.000493100649350658*G0_1_1_2_9 + 0.00271205357142868*G0_1_1_3_0 - 0.0406808035714299*G0_1_1_3_1 - 0.00476663961038975*G0_1_1_3_2 + 0.0976339285714323*G0_1_1_3_3 + 0.015532670454546*G0_1_1_3_4 - 0.00887581168831201*G0_1_1_3_5 + 0.00517755681818198*G0_1_1_3_6 - 0.00295860389610402*G0_1_1_3_7 - 0.0310653409090919*G0_1_1_3_8 + 0.057692775974028*G0_1_1_3_9 + 0.00197240259740267*G0_1_1_4_0 + 0.0172585227272733*G0_1_1_4_1 + 0.00410917207792219*G0_1_1_4_2 + 0.015532670454546*G0_1_1_4_3 + 0.00443790584415604*G0_1_1_4_4 - 0.000739650974025995*G0_1_1_4_5 - 0.00443790584415598*G0_1_1_4_6 - 0.00887581168831198*G0_1_1_4_7 + 0.0340239448051959*G0_1_1_4_8 + 0.00147930194805198*G0_1_1_5_0 + 0.001479301948052*G0_1_1_5_1 - 0.000657467532467542*G0_1_1_5_2 - 0.00887581168831201*G0_1_1_5_3 - 0.000739650974025995*G0_1_1_5_4 - 0.00887581168831199*G0_1_1_5_5 - 0.000739650974025976*G0_1_1_5_6 + 0.000739650974025987*G0_1_1_5_7 + 0.000739650974026*G0_1_1_5_8 - 0.020710227272728*G0_1_1_5_9 - 0.000493100649350664*G0_1_1_6_0 + 0.00328733766233774*G0_1_1_6_2 + 0.00517755681818198*G0_1_1_6_3 - 0.00443790584415598*G0_1_1_6_4 - 0.000739650974025976*G0_1_1_6_5 - 0.010355113636364*G0_1_1_6_6 - 0.00147930194805198*G0_1_1_6_7 + 0.0118344155844159*G0_1_1_6_8 - 0.011834415584416*G0_1_1_6_9 + 0.00846489448051975*G0_1_1_7_0 + 0.0345170454545467*G0_1_1_7_1 + 0.00221895292207799*G0_1_1_7_2 - 0.00295860389610402*G0_1_1_7_3 - 0.00887581168831198*G0_1_1_7_4 + 0.000739650974025986*G0_1_1_7_5 - 0.00147930194805198*G0_1_1_7_6 - 0.0162723214285722*G0_1_1_7_7 + 0.0451187094155861*G0_1_1_7_8 - 0.016272321428572*G0_1_1_7_9 - 0.0119987824675329*G0_1_1_8_0 - 0.0727323457792234*G0_1_1_8_1 - 0.00961546266233798*G0_1_1_8_2 - 0.0310653409090919*G0_1_1_8_3 + 0.0340239448051959*G0_1_1_8_4 + 0.000739650974026*G0_1_1_8_5 + 0.0118344155844159*G0_1_1_8_6 + 0.0451187094155861*G0_1_1_8_7 - 0.257398538961048*G0_1_1_8_8 - 0.016272321428572*G0_1_1_8_9 + 0.00641030844155867*G0_1_1_9_0 - 0.0172585227272733*G0_1_1_9_1 + 0.000493100649350658*G0_1_1_9_2 + 0.057692775974028*G0_1_1_9_3 - 0.020710227272728*G0_1_1_9_5 - 0.011834415584416*G0_1_1_9_6 - 0.016272321428572*G0_1_1_9_7 - 0.016272321428572*G0_1_1_9_8 + 0.0177516233766243*G0_1_1_9_9;
    A[95] = A[59] + 0.0295860389610401*G0_0_1_0_0 + 0.00372564935064948*G0_0_1_0_1 + 0.00295860389610402*G0_0_1_0_2 - 0.00147930194805198*G0_0_1_0_3 + 0.00246550324675332*G0_0_1_0_4 + 0.0468445616883133*G0_0_1_0_5 - 0.00887581168831206*G0_0_1_0_6 + 0.02218952922078*G0_0_1_0_7 - 0.0138068181818187*G0_0_1_0_8 + 0.0128206168831173*G0_0_1_0_9 + 0.00372564935064948*G0_0_1_1_0 + 0.000328733766233782*G0_0_1_1_1 + 0.00301339285714297*G0_0_1_1_2 + 0.00147930194805199*G0_0_1_1_3 - 0.00197240259740266*G0_0_1_1_4 + 0.00197240259740268*G0_0_1_1_5 - 0.0167654220779227*G0_0_1_1_6 + 0.00788961038961067*G0_0_1_1_7 - 0.00295860389610399*G0_0_1_1_8 - 0.01479301948052*G0_0_1_1_9 + 0.00295860389610402*G0_0_1_2_0 + 0.00301339285714297*G0_0_1_2_1 + 0.00986201298701339*G0_0_1_2_2 - 0.00690340909090934*G0_0_1_2_3 + 0.00739650974026003*G0_0_1_2_4 + 0.0177516233766239*G0_0_1_2_5 + 0.0123275162337667*G0_0_1_2_6 + 0.0138068181818187*G0_0_1_2_7 - 0.004437905844156*G0_0_1_2_8 + 0.0285998376623386*G0_0_1_2_9 - 0.00147930194805198*G0_0_1_3_0 + 0.00147930194805199*G0_0_1_3_1 - 0.00690340909090934*G0_0_1_3_2 + 0.0118344155844161*G0_0_1_3_3 - 0.00147930194805202*G0_0_1_3_4 + 0.00591720779220793*G0_0_1_3_5 + 0.0369825487012999*G0_0_1_3_6 - 0.00887581168831202*G0_0_1_3_7 + 0.00887581168831202*G0_0_1_3_8 + 0.0621306818181839*G0_0_1_3_9 + 0.00246550324675332*G0_0_1_4_0 - 0.00197240259740266*G0_0_1_4_1 + 0.00739650974026003*G0_0_1_4_2 - 0.00147930194805203*G0_0_1_4_3 + 0.0384618506493521*G0_0_1_4_4 - 0.020710227272728*G0_0_1_4_5 - 0.0162723214285719*G0_0_1_4_6 - 0.017751623376624*G0_0_1_4_7 - 0.0443790584415599*G0_0_1_4_9 + 0.0468445616883133*G0_0_1_5_0 + 0.00197240259740268*G0_0_1_5_1 + 0.017751623376624*G0_0_1_5_2 + 0.00591720779220793*G0_0_1_5_3 - 0.020710227272728*G0_0_1_5_4 - 0.106509740259744*G0_0_1_5_6 + 0.0739650974026*G0_0_1_5_7 - 0.0192309253246761*G0_0_1_5_8 - 0.00887581168831206*G0_0_1_6_0 - 0.0167654220779227*G0_0_1_6_1 + 0.0123275162337667*G0_0_1_6_2 + 0.0369825487012999*G0_0_1_6_3 - 0.0162723214285719*G0_0_1_6_4 - 0.106509740259744*G0_0_1_6_5 - 0.213019480519488*G0_0_1_6_6 - 0.054734172077924*G0_0_1_6_7 + 0.038461850649352*G0_0_1_6_8 - 0.159764610389616*G0_0_1_6_9 + 0.02218952922078*G0_0_1_7_0 + 0.00788961038961067*G0_0_1_7_1 + 0.0138068181818187*G0_0_1_7_2 - 0.00887581168831202*G0_0_1_7_3 - 0.017751623376624*G0_0_1_7_4 + 0.0739650974026*G0_0_1_7_5 - 0.054734172077924*G0_0_1_7_6 + 0.1479301948052*G0_0_1_7_7 - 0.0384618506493521*G0_0_1_7_8 + 0.0710064935064962*G0_0_1_7_9 - 0.0138068181818187*G0_0_1_8_0 - 0.00295860389610399*G0_0_1_8_1 - 0.004437905844156*G0_0_1_8_2 + 0.00887581168831202*G0_0_1_8_3 - 0.0192309253246761*G0_0_1_8_5 + 0.038461850649352*G0_0_1_8_6 - 0.0384618506493521*G0_0_1_8_7 + 0.0414204545454561*G0_0_1_8_8 + 0.0443790584415598*G0_0_1_8_9 + 0.0128206168831173*G0_0_1_9_0 - 0.01479301948052*G0_0_1_9_1 + 0.0285998376623386*G0_0_1_9_2 + 0.0621306818181839*G0_0_1_9_3 - 0.0443790584415599*G0_0_1_9_4 - 0.159764610389616*G0_0_1_9_6 + 0.0710064935064961*G0_0_1_9_7 + 0.0443790584415599*G0_0_1_9_8 - 0.0295860389610401*G0_1_0_0_0 - 0.00372564935064948*G0_1_0_0_1 - 0.00295860389610402*G0_1_0_0_2 + 0.00147930194805198*G0_1_0_0_3 - 0.00246550324675332*G0_1_0_0_4 - 0.0468445616883133*G0_1_0_0_5 + 0.00887581168831206*G0_1_0_0_6 - 0.02218952922078*G0_1_0_0_7 + 0.0138068181818187*G0_1_0_0_8 - 0.0128206168831173*G0_1_0_0_9 - 0.00372564935064948*G0_1_0_1_0 - 0.000328733766233782*G0_1_0_1_1 - 0.00301339285714297*G0_1_0_1_2 - 0.00147930194805199*G0_1_0_1_3 + 0.00197240259740266*G0_1_0_1_4 - 0.00197240259740268*G0_1_0_1_5 + 0.0167654220779227*G0_1_0_1_6 - 0.00788961038961067*G0_1_0_1_7 + 0.00295860389610399*G0_1_0_1_8 + 0.01479301948052*G0_1_0_1_9 - 0.00295860389610402*G0_1_0_2_0 - 0.00301339285714297*G0_1_0_2_1 - 0.00986201298701339*G0_1_0_2_2 + 0.00690340909090934*G0_1_0_2_3 - 0.00739650974026003*G0_1_0_2_4 - 0.017751623376624*G0_1_0_2_5 - 0.0123275162337667*G0_1_0_2_6 - 0.0138068181818187*G0_1_0_2_7 + 0.004437905844156*G0_1_0_2_8 - 0.0285998376623386*G0_1_0_2_9 + 0.00147930194805198*G0_1_0_3_0 - 0.00147930194805199*G0_1_0_3_1 + 0.00690340909090934*G0_1_0_3_2 - 0.0118344155844161*G0_1_0_3_3 + 0.00147930194805202*G0_1_0_3_4 - 0.00591720779220793*G0_1_0_3_5 - 0.0369825487012999*G0_1_0_3_6 + 0.00887581168831202*G0_1_0_3_7 - 0.00887581168831202*G0_1_0_3_8 - 0.0621306818181839*G0_1_0_3_9 - 0.00246550324675332*G0_1_0_4_0 + 0.00197240259740266*G0_1_0_4_1 - 0.00739650974026003*G0_1_0_4_2 + 0.00147930194805202*G0_1_0_4_3 - 0.0384618506493521*G0_1_0_4_4 + 0.020710227272728*G0_1_0_4_5 + 0.0162723214285719*G0_1_0_4_6 + 0.017751623376624*G0_1_0_4_7 + 0.04437905844156*G0_1_0_4_9 - 0.0468445616883133*G0_1_0_5_0 - 0.00197240259740268*G0_1_0_5_1 - 0.017751623376624*G0_1_0_5_2 - 0.00591720779220793*G0_1_0_5_3 + 0.020710227272728*G0_1_0_5_4 + 0.106509740259744*G0_1_0_5_6 - 0.0739650974026*G0_1_0_5_7 + 0.0192309253246761*G0_1_0_5_8 + 0.00887581168831206*G0_1_0_6_0 + 0.0167654220779227*G0_1_0_6_1 - 0.0123275162337667*G0_1_0_6_2 - 0.0369825487012999*G0_1_0_6_3 + 0.0162723214285719*G0_1_0_6_4 + 0.106509740259744*G0_1_0_6_5 + 0.213019480519488*G0_1_0_6_6 + 0.054734172077924*G0_1_0_6_7 - 0.038461850649352*G0_1_0_6_8 + 0.159764610389616*G0_1_0_6_9 - 0.02218952922078*G0_1_0_7_0 - 0.00788961038961067*G0_1_0_7_1 - 0.0138068181818187*G0_1_0_7_2 + 0.00887581168831202*G0_1_0_7_3 + 0.017751623376624*G0_1_0_7_4 - 0.0739650974026*G0_1_0_7_5 + 0.054734172077924*G0_1_0_7_6 - 0.1479301948052*G0_1_0_7_7 + 0.0384618506493521*G0_1_0_7_8 - 0.0710064935064962*G0_1_0_7_9 + 0.0138068181818187*G0_1_0_8_0 + 0.00295860389610399*G0_1_0_8_1 + 0.004437905844156*G0_1_0_8_2 - 0.00887581168831202*G0_1_0_8_3 + 0.0192309253246761*G0_1_0_8_5 - 0.038461850649352*G0_1_0_8_6 + 0.0384618506493521*G0_1_0_8_7 - 0.0414204545454561*G0_1_0_8_8 - 0.0443790584415598*G0_1_0_8_9 - 0.0128206168831173*G0_1_0_9_0 + 0.01479301948052*G0_1_0_9_1 - 0.0285998376623386*G0_1_0_9_2 - 0.0621306818181839*G0_1_0_9_3 + 0.04437905844156*G0_1_0_9_4 + 0.159764610389616*G0_1_0_9_6 - 0.0710064935064962*G0_1_0_9_7 - 0.0443790584415599*G0_1_0_9_8;
    A[52] = -A[32] - 0.00196022727272735*G0_0_1_0_0 - 0.000980113636363668*G0_0_1_0_2 - 0.00213676948051956*G0_0_1_0_3 + 0.00213676948051957*G0_0_1_0_4 - 0.00109577922077925*G0_0_1_0_5 - 0.00405438311688327*G0_0_1_0_6 - 0.00158887987012993*G0_0_1_0_7 + 0.000876623376623407*G0_0_1_0_8 - 0.00525974025974045*G0_0_1_0_9 + 0.00196022727272733*G0_0_1_1_1 + 0.00098011363636367*G0_0_1_1_2 + 0.00109577922077924*G0_0_1_1_3 + 0.00405438311688327*G0_0_1_1_4 + 0.00213676948051955*G0_0_1_1_5 - 0.00213676948051956*G0_0_1_1_6 - 0.000876623376623403*G0_0_1_1_7 + 0.00158887987012992*G0_0_1_1_8 + 0.00525974025974044*G0_0_1_1_9 - 0.000980113636363668*G0_0_1_2_0 + 0.00098011363636367*G0_0_1_2_1 - 0.00493100649350667*G0_0_1_2_3 + 0.01479301948052*G0_0_1_2_4 + 0.00493100649350665*G0_0_1_2_5 - 0.0147930194805199*G0_0_1_2_6 - 0.00016436688311689*G0_0_1_2_7 + 0.000164366883116885*G0_0_1_2_8 - 0.00213676948051956*G0_0_1_3_0 + 0.00109577922077924*G0_0_1_3_1 - 0.00493100649350667*G0_0_1_3_2 - 0.035503246753248*G0_0_1_3_3 - 0.0212033279220786*G0_0_1_3_4 + 0.00641030844155864*G0_0_1_3_6 + 0.00641030844155867*G0_0_1_3_7 - 0.005917207792208*G0_0_1_3_8 - 0.0285998376623387*G0_0_1_3_9 + 0.00213676948051957*G0_0_1_4_0 + 0.00405438311688327*G0_0_1_4_1 + 0.01479301948052*G0_0_1_4_2 - 0.0212033279220786*G0_0_1_4_3 + 0.0936891233766266*G0_0_1_4_4 - 0.00641030844155868*G0_0_1_4_5 - 0.002958603896104*G0_0_1_4_7 - 0.00049310064935066*G0_0_1_4_8 + 0.0128206168831173*G0_0_1_4_9 - 0.00109577922077925*G0_0_1_5_0 + 0.00213676948051955*G0_0_1_5_1 + 0.00493100649350665*G0_0_1_5_2 - 0.00641030844155867*G0_0_1_5_4 + 0.0355032467532479*G0_0_1_5_5 + 0.0212033279220786*G0_0_1_5_6 + 0.005917207792208*G0_0_1_5_7 - 0.00641030844155866*G0_0_1_5_8 + 0.0285998376623386*G0_0_1_5_9 - 0.00405438311688327*G0_0_1_6_0 - 0.00213676948051956*G0_0_1_6_1 - 0.01479301948052*G0_0_1_6_2 + 0.00641030844155864*G0_0_1_6_3 + 0.0212033279220786*G0_0_1_6_5 - 0.0936891233766265*G0_0_1_6_6 + 0.000493100649350656*G0_0_1_6_7 + 0.00295860389610399*G0_0_1_6_8 - 0.0128206168831173*G0_0_1_6_9 - 0.00158887987012993*G0_0_1_7_0 - 0.000876623376623403*G0_0_1_7_1 - 0.00016436688311689*G0_0_1_7_2 + 0.00641030844155866*G0_0_1_7_3 - 0.002958603896104*G0_0_1_7_4 + 0.005917207792208*G0_0_1_7_5 + 0.000493100649350656*G0_0_1_7_6 - 0.00394480519480534*G0_0_1_7_7 + 0.01479301948052*G0_0_1_7_9 + 0.000876623376623407*G0_0_1_8_0 + 0.00158887987012992*G0_0_1_8_1 + 0.000164366883116885*G0_0_1_8_2 - 0.005917207792208*G0_0_1_8_3 - 0.00049310064935066*G0_0_1_8_4 - 0.00641030844155866*G0_0_1_8_5 + 0.00295860389610399*G0_0_1_8_6 + 0.0039448051948053*G0_0_1_8_8 - 0.01479301948052*G0_0_1_8_9 - 0.00525974025974045*G0_0_1_9_0 + 0.00525974025974044*G0_0_1_9_1 - 0.0285998376623386*G0_0_1_9_3 + 0.0128206168831173*G0_0_1_9_4 + 0.0285998376623386*G0_0_1_9_5 - 0.0128206168831173*G0_0_1_9_6 + 0.01479301948052*G0_0_1_9_7 - 0.01479301948052*G0_0_1_9_8 + 0.0180560064935071*G0_1_1_0_0 + 0.00271814123376633*G0_1_1_0_1 + 0.00281554383116895*G0_1_1_0_2 - 0.00125101461038967*G0_1_1_0_3 + 0.00176237824675333*G0_1_1_0_4 + 0.00462053571428586*G0_1_1_0_5 - 0.00315949675324684*G0_1_1_0_6 + 0.0116517857142861*G0_1_1_0_7 - 0.00341517857142868*G0_1_1_0_8 - 0.000986201298701324*G0_1_1_0_9 + 0.00271814123376633*G0_1_1_1_0 + 0.0200162337662344*G0_1_1_1_1 + 0.00379565746753261*G0_1_1_1_2 + 0.00571631493506511*G0_1_1_1_3 + 0.000894886363636418*G0_1_1_1_4 + 0.000885754870129894*G0_1_1_1_5 - 0.000374391233766236*G0_1_1_1_6 - 0.00429180194805211*G0_1_1_1_7 + 0.0132406655844161*G0_1_1_1_8 + 0.00427353896103911*G0_1_1_1_9 + 0.00281554383116895*G0_1_1_2_0 + 0.00379565746753261*G0_1_1_2_1 + 0.0471185064935082*G0_1_1_2_2 - 0.0130945616883122*G0_1_1_2_3 + 0.0306818181818193*G0_1_1_2_4 - 0.00816355519480551*G0_1_1_2_5 + 0.0158887987012993*G0_1_1_2_6 + 0.000721387987013008*G0_1_1_2_7 + 0.000885754870129896*G0_1_1_2_8 + 0.00372564935064949*G0_1_1_2_9 - 0.00125101461038967*G0_1_1_3_0 + 0.00571631493506511*G0_1_1_3_1 - 0.0130945616883122*G0_1_1_3_2 - 0.0161079545454551*G0_1_1_3_3 - 0.0222717126623384*G0_1_1_3_4 + 0.00230113636363646*G0_1_1_3_5 - 0.00238331980519493*G0_1_1_3_6 + 0.000246550324675333*G0_1_1_3_7 + 0.00591720779220798*G0_1_1_3_8 - 0.013313717532468*G0_1_1_3_9 + 0.00176237824675332*G0_1_1_4_0 + 0.000894886363636417*G0_1_1_4_1 + 0.0306818181818193*G0_1_1_4_2 - 0.0222717126623384*G0_1_1_4_3 + 0.0726501623376649*G0_1_1_4_4 - 0.00879362824675359*G0_1_1_4_5 + 0.0111769480519485*G0_1_1_4_6 - 0.00197240259740267*G0_1_1_4_7 - 0.00616375811688331*G0_1_1_4_8 + 0.00641030844155868*G0_1_1_4_9 + 0.00462053571428586*G0_1_1_5_0 + 0.000885754870129895*G0_1_1_5_1 - 0.00816355519480552*G0_1_1_5_2 + 0.00230113636363646*G0_1_1_5_3 - 0.00879362824675359*G0_1_1_5_4 + 0.0193952922077929*G0_1_1_5_5 - 0.00106838474025984*G0_1_1_5_6 + 0.011834415584416*G0_1_1_5_7 - 0.00616375811688332*G0_1_1_5_8 + 0.0152861201298706*G0_1_1_5_9 - 0.00315949675324684*G0_1_1_6_0 - 0.000374391233766236*G0_1_1_6_1 + 0.0158887987012993*G0_1_1_6_2 - 0.00238331980519493*G0_1_1_6_3 + 0.0111769480519485*G0_1_1_6_4 - 0.00106838474025984*G0_1_1_6_5 - 0.0210389610389616*G0_1_1_6_6 - 0.00567065746753266*G0_1_1_6_7 + 0.000986201298701331*G0_1_1_6_8 - 0.00641030844155862*G0_1_1_6_9 + 0.0116517857142861*G0_1_1_7_0 - 0.00429180194805211*G0_1_1_7_1 + 0.000721387987013008*G0_1_1_7_2 + 0.000246550324675333*G0_1_1_7_3 - 0.00197240259740267*G0_1_1_7_4 + 0.011834415584416*G0_1_1_7_5 - 0.00567065746753266*G0_1_1_7_6 + 0.0535836038961057*G0_1_1_7_7 - 0.0201349431818189*G0_1_1_7_8 + 0.0142999188311693*G0_1_1_7_9 - 0.00341517857142868*G0_1_1_8_0 + 0.0132406655844161*G0_1_1_8_1 + 0.000885754870129896*G0_1_1_8_2 + 0.00591720779220798*G0_1_1_8_3 - 0.00616375811688331*G0_1_1_8_4 - 0.00616375811688332*G0_1_1_8_5 + 0.000986201298701331*G0_1_1_8_6 - 0.0201349431818189*G0_1_1_8_7 + 0.057528409090911*G0_1_1_8_8 - 0.000493100649350695*G0_1_1_8_9 - 0.000986201298701323*G0_1_1_9_0 + 0.00427353896103911*G0_1_1_9_1 + 0.00372564935064949*G0_1_1_9_2 - 0.013313717532468*G0_1_1_9_3 + 0.00641030844155868*G0_1_1_9_4 + 0.0152861201298706*G0_1_1_9_5 - 0.00641030844155863*G0_1_1_9_6 + 0.0142999188311693*G0_1_1_9_7 - 0.000493100649350693*G0_1_1_9_8 + 0.0374756493506506*G0_1_1_9_9;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class laplacian_f2_p3_q3_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  laplacian_f2_p3_q3_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q3_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p3_q3_tensor_finite_element_0();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p3_q3_tensor_finite_element_0();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p3_q3_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p3_q3_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p3_q3_tensor_dofmap_0();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p3_q3_tensor_dofmap_0();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p3_q3_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p3_q3_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p3_q3_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
