// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F2_P3_Q4_TENSOR_H
#define __LAPLACIAN_F2_P3_Q4_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f2_p3_q4_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p3_q4_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q4_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p3_q4_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class laplacian_f2_p3_q4_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p3_q4_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q4_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p3_q4_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p3_q4_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p3_q4_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q4_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p3_q4_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p3_q4_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p3_q4_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q4_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3*m.num_entities[1] + 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p3_q4_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f2_p3_q4_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f2_p3_q4_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p3_q4_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    1200
    // Number of operations (multiply-add pairs) for tensor contraction: 54301
    // Total number of operations (multiply-add pairs):                  55512
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3 = det*(w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4 = det*(w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5 = det*(w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_6 = det*(w[0][0]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_7 = det*(w[0][0]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_8 = det*(w[0][0]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_9 = det*(w[0][0]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3 = det*(w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4 = det*(w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5 = det*(w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_6 = det*(w[0][1]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_7 = det*(w[0][1]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_8 = det*(w[0][1]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_9 = det*(w[0][1]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3 = det*(w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4 = det*(w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5 = det*(w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_6 = det*(w[0][2]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_7 = det*(w[0][2]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_8 = det*(w[0][2]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_9 = det*(w[0][2]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0 = det*(w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1 = det*(w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2 = det*(w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3 = det*(w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4 = det*(w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5 = det*(w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_6 = det*(w[0][3]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_7 = det*(w[0][3]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_8 = det*(w[0][3]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_9 = det*(w[0][3]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0 = det*(w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1 = det*(w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2 = det*(w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3 = det*(w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4 = det*(w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5 = det*(w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_6 = det*(w[0][4]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_7 = det*(w[0][4]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_8 = det*(w[0][4]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_9 = det*(w[0][4]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0 = det*(w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1 = det*(w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2 = det*(w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3 = det*(w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4 = det*(w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5 = det*(w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_6 = det*(w[0][5]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_7 = det*(w[0][5]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_8 = det*(w[0][5]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_9 = det*(w[0][5]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_0 = det*(w[0][6]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_1 = det*(w[0][6]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_2 = det*(w[0][6]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_3 = det*(w[0][6]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_4 = det*(w[0][6]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_5 = det*(w[0][6]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_6 = det*(w[0][6]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_7 = det*(w[0][6]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_8 = det*(w[0][6]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_9 = det*(w[0][6]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_0 = det*(w[0][7]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_1 = det*(w[0][7]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_2 = det*(w[0][7]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_3 = det*(w[0][7]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_4 = det*(w[0][7]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_5 = det*(w[0][7]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_6 = det*(w[0][7]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_7 = det*(w[0][7]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_8 = det*(w[0][7]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_9 = det*(w[0][7]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_0 = det*(w[0][8]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_1 = det*(w[0][8]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_2 = det*(w[0][8]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_3 = det*(w[0][8]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_4 = det*(w[0][8]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_5 = det*(w[0][8]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_6 = det*(w[0][8]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_7 = det*(w[0][8]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_8 = det*(w[0][8]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_9 = det*(w[0][8]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_0 = det*(w[0][9]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_1 = det*(w[0][9]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_2 = det*(w[0][9]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_3 = det*(w[0][9]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_4 = det*(w[0][9]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_5 = det*(w[0][9]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_6 = det*(w[0][9]*w[1][6]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_7 = det*(w[0][9]*w[1][7]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_8 = det*(w[0][9]*w[1][8]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_9 = det*(w[0][9]*w[1][9]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3 = det*(w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4 = det*(w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5 = det*(w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_6 = det*(w[0][0]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_7 = det*(w[0][0]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_8 = det*(w[0][0]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_9 = det*(w[0][0]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3 = det*(w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4 = det*(w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5 = det*(w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_6 = det*(w[0][1]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_7 = det*(w[0][1]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_8 = det*(w[0][1]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_9 = det*(w[0][1]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3 = det*(w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4 = det*(w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5 = det*(w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_6 = det*(w[0][2]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_7 = det*(w[0][2]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_8 = det*(w[0][2]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_9 = det*(w[0][2]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0 = det*(w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1 = det*(w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2 = det*(w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3 = det*(w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4 = det*(w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5 = det*(w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_6 = det*(w[0][3]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_7 = det*(w[0][3]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_8 = det*(w[0][3]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_9 = det*(w[0][3]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0 = det*(w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1 = det*(w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2 = det*(w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3 = det*(w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4 = det*(w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5 = det*(w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_6 = det*(w[0][4]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_7 = det*(w[0][4]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_8 = det*(w[0][4]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_9 = det*(w[0][4]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0 = det*(w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1 = det*(w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2 = det*(w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3 = det*(w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4 = det*(w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5 = det*(w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_6 = det*(w[0][5]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_7 = det*(w[0][5]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_8 = det*(w[0][5]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_9 = det*(w[0][5]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_0 = det*(w[0][6]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_1 = det*(w[0][6]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_2 = det*(w[0][6]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_3 = det*(w[0][6]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_4 = det*(w[0][6]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_5 = det*(w[0][6]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_6 = det*(w[0][6]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_7 = det*(w[0][6]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_8 = det*(w[0][6]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_9 = det*(w[0][6]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_0 = det*(w[0][7]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_1 = det*(w[0][7]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_2 = det*(w[0][7]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_3 = det*(w[0][7]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_4 = det*(w[0][7]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_5 = det*(w[0][7]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_6 = det*(w[0][7]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_7 = det*(w[0][7]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_8 = det*(w[0][7]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_9 = det*(w[0][7]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_0 = det*(w[0][8]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_1 = det*(w[0][8]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_2 = det*(w[0][8]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_3 = det*(w[0][8]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_4 = det*(w[0][8]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_5 = det*(w[0][8]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_6 = det*(w[0][8]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_7 = det*(w[0][8]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_8 = det*(w[0][8]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_9 = det*(w[0][8]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_0 = det*(w[0][9]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_1 = det*(w[0][9]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_2 = det*(w[0][9]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_3 = det*(w[0][9]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_4 = det*(w[0][9]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_5 = det*(w[0][9]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_6 = det*(w[0][9]*w[1][6]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_7 = det*(w[0][9]*w[1][7]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_8 = det*(w[0][9]*w[1][8]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_9 = det*(w[0][9]*w[1][9]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3 = det*(w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4 = det*(w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5 = det*(w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_6 = det*(w[0][0]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_7 = det*(w[0][0]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_8 = det*(w[0][0]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_9 = det*(w[0][0]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3 = det*(w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4 = det*(w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5 = det*(w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_6 = det*(w[0][1]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_7 = det*(w[0][1]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_8 = det*(w[0][1]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_9 = det*(w[0][1]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3 = det*(w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4 = det*(w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5 = det*(w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_6 = det*(w[0][2]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_7 = det*(w[0][2]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_8 = det*(w[0][2]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_9 = det*(w[0][2]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0 = det*(w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1 = det*(w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2 = det*(w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3 = det*(w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4 = det*(w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5 = det*(w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_6 = det*(w[0][3]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_7 = det*(w[0][3]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_8 = det*(w[0][3]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_9 = det*(w[0][3]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0 = det*(w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1 = det*(w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2 = det*(w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3 = det*(w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4 = det*(w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5 = det*(w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_6 = det*(w[0][4]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_7 = det*(w[0][4]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_8 = det*(w[0][4]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_9 = det*(w[0][4]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0 = det*(w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1 = det*(w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2 = det*(w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3 = det*(w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4 = det*(w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5 = det*(w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_6 = det*(w[0][5]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_7 = det*(w[0][5]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_8 = det*(w[0][5]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_9 = det*(w[0][5]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_0 = det*(w[0][6]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_1 = det*(w[0][6]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_2 = det*(w[0][6]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_3 = det*(w[0][6]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_4 = det*(w[0][6]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_5 = det*(w[0][6]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_6 = det*(w[0][6]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_7 = det*(w[0][6]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_8 = det*(w[0][6]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_9 = det*(w[0][6]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_0 = det*(w[0][7]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_1 = det*(w[0][7]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_2 = det*(w[0][7]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_3 = det*(w[0][7]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_4 = det*(w[0][7]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_5 = det*(w[0][7]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_6 = det*(w[0][7]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_7 = det*(w[0][7]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_8 = det*(w[0][7]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_9 = det*(w[0][7]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_0 = det*(w[0][8]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_1 = det*(w[0][8]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_2 = det*(w[0][8]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_3 = det*(w[0][8]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_4 = det*(w[0][8]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_5 = det*(w[0][8]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_6 = det*(w[0][8]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_7 = det*(w[0][8]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_8 = det*(w[0][8]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_9 = det*(w[0][8]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_0 = det*(w[0][9]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_1 = det*(w[0][9]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_2 = det*(w[0][9]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_3 = det*(w[0][9]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_4 = det*(w[0][9]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_5 = det*(w[0][9]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_6 = det*(w[0][9]*w[1][6]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_7 = det*(w[0][9]*w[1][7]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_8 = det*(w[0][9]*w[1][8]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_9 = det*(w[0][9]*w[1][9]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3 = det*(w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4 = det*(w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5 = det*(w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_6 = det*(w[0][0]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_7 = det*(w[0][0]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_8 = det*(w[0][0]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_9 = det*(w[0][0]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3 = det*(w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4 = det*(w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5 = det*(w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_6 = det*(w[0][1]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_7 = det*(w[0][1]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_8 = det*(w[0][1]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_9 = det*(w[0][1]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3 = det*(w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4 = det*(w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5 = det*(w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_6 = det*(w[0][2]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_7 = det*(w[0][2]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_8 = det*(w[0][2]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_9 = det*(w[0][2]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0 = det*(w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1 = det*(w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2 = det*(w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3 = det*(w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4 = det*(w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5 = det*(w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_6 = det*(w[0][3]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_7 = det*(w[0][3]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_8 = det*(w[0][3]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_9 = det*(w[0][3]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0 = det*(w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1 = det*(w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2 = det*(w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3 = det*(w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4 = det*(w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5 = det*(w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_6 = det*(w[0][4]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_7 = det*(w[0][4]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_8 = det*(w[0][4]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_9 = det*(w[0][4]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0 = det*(w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1 = det*(w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2 = det*(w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3 = det*(w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4 = det*(w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5 = det*(w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_6 = det*(w[0][5]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_7 = det*(w[0][5]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_8 = det*(w[0][5]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_9 = det*(w[0][5]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_0 = det*(w[0][6]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_1 = det*(w[0][6]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_2 = det*(w[0][6]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_3 = det*(w[0][6]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_4 = det*(w[0][6]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_5 = det*(w[0][6]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_6 = det*(w[0][6]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_7 = det*(w[0][6]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_8 = det*(w[0][6]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_9 = det*(w[0][6]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_0 = det*(w[0][7]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_1 = det*(w[0][7]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_2 = det*(w[0][7]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_3 = det*(w[0][7]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_4 = det*(w[0][7]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_5 = det*(w[0][7]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_6 = det*(w[0][7]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_7 = det*(w[0][7]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_8 = det*(w[0][7]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_9 = det*(w[0][7]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_0 = det*(w[0][8]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_1 = det*(w[0][8]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_2 = det*(w[0][8]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_3 = det*(w[0][8]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_4 = det*(w[0][8]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_5 = det*(w[0][8]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_6 = det*(w[0][8]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_7 = det*(w[0][8]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_8 = det*(w[0][8]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_9 = det*(w[0][8]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_0 = det*(w[0][9]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_1 = det*(w[0][9]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_2 = det*(w[0][9]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_3 = det*(w[0][9]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_4 = det*(w[0][9]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_5 = det*(w[0][9]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_6 = det*(w[0][9]*w[1][6]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_7 = det*(w[0][9]*w[1][7]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_8 = det*(w[0][9]*w[1][8]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_9 = det*(w[0][9]*w[1][9]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[108] = 0.000455840455840541*G0_0_0_0_0 - 1.30028701457341e-05*G0_0_0_0_1 + 0.0011446754303899*G0_0_0_0_2 + 0.000453197596054839*G0_0_0_0_3 - 0.000889269460698194*G0_0_0_0_4 + 0.00500356786071156*G0_0_0_0_5 + 0.000143665857951544*G0_0_0_0_6 + 0.000244517387374569*G0_0_0_0_7 - 0.000278768850197467*G0_0_0_0_8 + 0.00189334475048793*G0_0_0_0_9 - 1.30028701457342e-05*G0_0_0_1_0 - 0.0013320013320016*G0_0_0_1_1 + 0.00100428671857259*G0_0_0_1_2 - 0.00342102342102398*G0_0_0_1_3 - 0.00229072514786841*G0_0_0_1_4 - 0.000882609454038169*G0_0_0_1_5 - 0.00342387770959257*G0_0_0_1_6 + 0.000275597418454619*G0_0_0_1_7 - 0.0010012210012212*G0_0_0_1_8 + 0.00100280671709262*G0_0_0_1_9 + 0.0011446754303899*G0_0_0_2_0 + 0.00100428671857259*G0_0_0_2_1 + 0.0645724645724752*G0_0_0_2_2 - 0.00602508602508696*G0_0_0_2_3 + 0.00539016539016618*G0_0_0_2_4 - 0.00311244311244357*G0_0_0_2_5 + 0.0140570540570562*G0_0_0_2_6 + 0.00023341737627456*G0_0_0_2_7 + 0.000370423227566156*G0_0_0_2_8 - 0.00298368298368352*G0_0_0_2_9 + 0.000453197596054839*G0_0_0_3_0 - 0.00342102342102398*G0_0_0_3_1 - 0.00602508602508696*G0_0_0_3_2 + 0.0134608248893991*G0_0_0_3_3 + 0.0226915941201693*G0_0_0_3_4 + 0.000622234907949253*G0_0_0_3_5 + 0.0103153988868291*G0_0_0_3_6 - 0.00131582703011301*G0_0_0_3_7 + 0.00238333095475999*G0_0_0_3_8 - 0.000376766091051827*G0_0_0_3_9 - 0.000889269460698194*G0_0_0_4_0 - 0.00229072514786841*G0_0_0_4_1 + 0.00539016539016618*G0_0_0_4_2 + 0.0226915941201693*G0_0_0_4_3 - 0.0685714285714402*G0_0_0_4_4 + 0.00271157414014604*G0_0_0_4_5 - 0.0130269730269752*G0_0_0_4_6 + 0.000961895247609695*G0_0_0_4_7 - 0.00106750392464698*G0_0_0_4_8 + 0.00352790067075849*G0_0_0_4_9 + 0.00500356786071156*G0_0_0_5_0 - 0.000882609454038169*G0_0_0_5_1 - 0.00311244311244357*G0_0_0_5_2 + 0.000622234907949254*G0_0_0_5_3 + 0.00271157414014605*G0_0_0_5_4 - 0.0375510204081695*G0_0_0_5_5 - 0.0131811046096782*G0_0_0_5_6 - 0.00203510774939379*G0_0_0_5_7 + 0.00269159412016599*G0_0_0_5_8 - 0.0110632224917958*G0_0_0_5_9 + 0.000143665857951544*G0_0_0_6_0 - 0.00342387770959257*G0_0_0_6_1 + 0.0140570540570562*G0_0_0_6_2 + 0.0103153988868291*G0_0_0_6_3 - 0.0130269730269752*G0_0_0_6_4 - 0.0131811046096782*G0_0_0_6_5 - 0.185894105894137*G0_0_0_6_6 - 0.000656486370772211*G0_0_0_6_7 + 0.00455829884401384*G0_0_0_6_8 - 0.0116797488226077*G0_0_0_6_9 + 0.000244517387374569*G0_0_0_7_0 + 0.000275597418454619*G0_0_0_7_1 + 0.00023341737627456*G0_0_0_7_2 - 0.00131582703011301*G0_0_0_7_3 + 0.000961895247609694*G0_0_0_7_4 - 0.00203510774939379*G0_0_0_7_5 - 0.000656486370772211*G0_0_0_7_6 - 0.00193520764949369*G0_0_0_7_7 + 0.000282574568288913*G0_0_0_7_8 - 0.00436706150991941*G0_0_0_7_9 - 0.000278768850197467*G0_0_0_8_0 - 0.0010012210012212*G0_0_0_8_1 + 0.000370423227566156*G0_0_0_8_2 + 0.00238333095475999*G0_0_0_8_3 - 0.00106750392464698*G0_0_0_8_4 + 0.00269159412016599*G0_0_0_8_5 + 0.00455829884401384*G0_0_0_8_6 + 0.000282574568288913*G0_0_0_8_7 + 0.00470957613814831*G0_0_0_8_8 - 0.000873412301983904*G0_0_0_8_9 + 0.00189334475048793*G0_0_0_9_0 + 0.00100280671709262*G0_0_0_9_1 - 0.00298368298368352*G0_0_0_9_2 - 0.000376766091051827*G0_0_0_9_3 + 0.00352790067075849*G0_0_0_9_4 - 0.0110632224917958*G0_0_0_9_5 - 0.0116797488226077*G0_0_0_9_6 - 0.00436706150991941*G0_0_0_9_7 - 0.000873412301983904*G0_0_0_9_8 + 0.063707720850589*G0_0_0_9_9 + 0.000462747129413886*G0_0_1_0_0 - 4.61619509238885e-05*G0_0_1_0_1 + 0.000221859269478351*G0_0_1_0_2 - 0.000257203114346015*G0_0_1_0_3 + 2.82257425114591e-05*G0_0_1_0_4 + 0.00140018711447308*G0_0_1_0_5 - 0.000437023294166234*G0_0_1_0_6 + 0.000917495203209666*G0_0_1_0_7 - 0.00030509173366325*G0_0_1_0_8 + 0.000875315161029594*G0_0_1_0_9 - 4.61619509238885e-05*G0_0_1_1_0 - 0.0038036038036049*G0_0_1_1_1 + 0.00014803538613063*G0_0_1_1_2 - 0.00380064380064453*G0_0_1_1_3 + 0.00187368187368223*G0_0_1_1_4 - 0.000104974390688688*G0_0_1_1_5 - 0.00126476697905291*G0_0_1_1_6 + 0.000861360861361124*G0_0_1_1_7 - 0.00108336108336153*G0_0_1_1_8 - 0.00175824175824207*G0_0_1_1_9 + 0.000221859269478351*G0_0_1_2_0 + 0.00014803538613063*G0_0_1_2_1 + 0.00382728382728434*G0_0_1_2_2 - 0.0025447568304715*G0_0_1_2_3 + 0.00475080475080547*G0_0_1_2_4 - 0.00020043448614878*G0_0_1_2_5 + 0.00208680208680239*G0_0_1_2_6 + 8.91172319743965e-05*G0_0_1_2_7 - 0.000242931671503153*G0_0_1_2_8 + 0.00148423005565886*G0_0_1_2_9 - 0.000257203114346015*G0_0_1_3_0 - 0.00380064380064453*G0_0_1_3_1 - 0.0025447568304715*G0_0_1_3_2 - 0.0037362637362642*G0_0_1_3_3 + 0.00063079777365503*G0_0_1_3_4 + 0.000693592122163651*G0_0_1_3_5 + 0.00349364920793552*G0_0_1_3_6 + 0.000470957613814849*G0_0_1_3_7 - 0.000899100899101112*G0_0_1_3_8 + 0.0043328100470965*G0_0_1_3_9 + 2.82257425114591e-05*G0_0_1_4_0 + 0.00187368187368223*G0_0_1_4_1 + 0.00475080475080547*G0_0_1_4_2 + 0.000630797773655031*G0_0_1_4_3 + 0.000990438133295299*G0_0_1_4_4 - 0.000385328956757573*G0_0_1_4_5 - 0.00310832025117795*G0_0_1_4_6 - 2.56885971171853e-05*G0_0_1_4_7 + 0.000428143285286264*G0_0_1_4_8 - 0.00368203225346144*G0_0_1_4_9 + 0.00140018711447308*G0_0_1_5_0 - 0.000104974390688688*G0_0_1_5_1 - 0.00020043448614878*G0_0_1_5_2 + 0.000693592122163651*G0_0_1_5_3 - 0.000385328956757573*G0_0_1_5_4 - 0.00306265163408073*G0_0_1_5_5 - 0.00156415013557898*G0_0_1_5_6 + 0.000553731982303515*G0_0_1_5_7 + 1.42714428428689e-05*G0_0_1_5_8 - 0.00265448836877452*G0_0_1_5_9 - 0.000437023294166234*G0_0_1_6_0 - 0.00126476697905291*G0_0_1_6_1 + 0.00208680208680239*G0_0_1_6_2 + 0.00349364920793552*G0_0_1_6_3 - 0.00310832025117795*G0_0_1_6_4 - 0.00156415013557898*G0_0_1_6_5 - 0.0174311402882861*G0_0_1_6_6 - 0.000568003425146386*G0_0_1_6_7 + 0.00241187384044569*G0_0_1_6_8 - 0.0114399885828476*G0_0_1_6_9 + 0.000917495203209666*G0_0_1_7_0 + 0.000861360861361124*G0_0_1_7_1 + 8.91172319743965e-05*G0_0_1_7_2 + 0.000470957613814849*G0_0_1_7_3 - 2.56885971171852e-05*G0_0_1_7_4 + 0.000553731982303515*G0_0_1_7_5 - 0.000568003425146386*G0_0_1_7_6 + 0.000796346510632308*G0_0_1_7_7 - 0.00148993863279588*G0_0_1_7_8 - 0.00148993863279602*G0_0_1_7_9 - 0.00030509173366325*G0_0_1_8_0 - 0.00108336108336153*G0_0_1_8_1 - 0.000242931671503153*G0_0_1_8_2 - 0.000899100899101112*G0_0_1_8_3 + 0.000428143285286264*G0_0_1_8_4 + 1.42714428428688e-05*G0_0_1_8_5 + 0.00241187384044569*G0_0_1_8_6 - 0.00148993863279588*G0_0_1_8_7 + 0.00413586413586437*G0_0_1_8_8 + 0.00441843870415368*G0_0_1_8_9 + 0.000875315161029594*G0_0_1_9_0 - 0.00175824175824207*G0_0_1_9_1 + 0.00148423005565886*G0_0_1_9_2 + 0.0043328100470965*G0_0_1_9_3 - 0.00368203225346144*G0_0_1_9_4 - 0.00265448836877452*G0_0_1_9_5 - 0.0114399885828476*G0_0_1_9_6 - 0.00148993863279602*G0_0_1_9_7 + 0.00441843870415368*G0_0_1_9_8 - 0.0101726844584003*G0_0_1_9_9 - 0.000967920967921173*G0_1_0_0_0 + 0.000150008721437312*G0_1_0_0_1 + 0.000618746333032142*G0_1_0_0_2 - 0.00102627531198977*G0_1_0_0_3 + 6.21600621600717e-05*G0_1_0_0_4 + 0.00377812663527013*G0_1_0_0_5 - 0.00440036154321945*G0_1_0_0_6 + 0.000848357991215264*G0_1_0_0_7 - 0.000649192077763621*G0_1_0_0_8 + 0.00320251177394089*G0_1_0_0_9 + 0.000150008721437312*G0_1_0_1_0 - 0.000932400932401155*G0_1_0_1_1 + 0.000536817679674903*G0_1_0_1_2 - 0.00260628260628306*G0_1_0_1_3 - 0.00109826681255271*G0_1_0_1_4 + 0.000821400821400947*G0_1_0_1_5 - 0.00209282780711388*G0_1_0_1_6 - 0.000450026164311944*G0_1_0_1_7 + 0.000900052328623914*G0_1_0_1_9 + 0.000618746333032142*G0_1_0_2_0 + 0.000536817679674903*G0_1_0_2_1 + 0.0554645354645446*G0_1_0_2_2 - 0.00453070738785096*G0_1_0_2_3 + 0.00317016317016361*G0_1_0_2_4 - 0.000783343640486573*G0_1_0_2_5 - 0.000541680541680755*G0_1_0_2_6 + 0.000199165913451664*G0_1_0_2_7 + 0.000649192077763612*G0_1_0_2_8 - 0.00529755958327478*G0_1_0_2_9 - 0.00102627531198977*G0_1_0_3_0 - 0.00260628260628307*G0_1_0_3_1 - 0.00453070738785096*G0_1_0_3_2 - 0.00394748109033879*G0_1_0_3_3 + 0.0180847723704897*G0_1_0_3_4 + 8.56286570576008e-06*G0_1_0_3_5 + 0.00687598116169655*G0_1_0_3_6 + 0.00367632367632432*G0_1_0_3_7 - 0.00232624518338848*G0_1_0_3_8 - 0.0100528043385204*G0_1_0_3_9 + 6.21600621600723e-05*G0_1_0_4_0 - 0.00109826681255271*G0_1_0_4_1 + 0.00317016317016361*G0_1_0_4_2 + 0.0180847723704897*G0_1_0_4_3 - 0.0506150991865363*G0_1_0_4_4 + 0.000411017553874756*G0_1_0_4_5 - 0.00728699871557133*G0_1_0_4_6 - 0.000690737833595111*G0_1_0_4_7 - 0.00135007849293584*G0_1_0_4_8 + 0.0150706436420749*G0_1_0_4_9 + 0.00377812663527013*G0_1_0_5_0 + 0.000821400821400947*G0_1_0_5_1 - 0.000783343640486573*G0_1_0_5_2 + 8.56286570575999e-06*G0_1_0_5_3 + 0.000411017553874756*G0_1_0_5_4 + 0.0570087055801435*G0_1_0_5_5 + 0.0132010846296583*G0_1_0_5_6 + 0.00186670472384784*G0_1_0_5_7 - 0.00186670472384784*G0_1_0_5_8 - 0.00587412587412697*G0_1_0_5_9 - 0.00440036154321945*G0_1_0_6_0 - 0.00209282780711388*G0_1_0_6_1 - 0.000541680541680751*G0_1_0_6_2 + 0.00687598116169655*G0_1_0_6_3 - 0.00728699871557134*G0_1_0_6_4 + 0.0132010846296583*G0_1_0_6_5 - 0.151753960325415*G0_1_0_6_6 + 0.00186670472384786*G0_1_0_6_8 + 0.00214071642643128*G0_1_0_6_9 + 0.000848357991215264*G0_1_0_7_0 - 0.000450026164311944*G0_1_0_7_1 + 0.000199165913451664*G0_1_0_7_2 + 0.00367632367632432*G0_1_0_7_3 - 0.000690737833595111*G0_1_0_7_4 + 0.00186670472384784*G0_1_0_7_5 - 0.00204081632653101*G0_1_0_7_7 + 0.00135007849293593*G0_1_0_7_8 - 0.00960753532182268*G0_1_0_7_9 - 0.000649192077763621*G0_1_0_8_0 + 0.000649192077763612*G0_1_0_8_2 - 0.00232624518338848*G0_1_0_8_3 - 0.00135007849293584*G0_1_0_8_4 - 0.00186670472384784*G0_1_0_8_5 + 0.00186670472384786*G0_1_0_8_6 + 0.00135007849293593*G0_1_0_8_7 + 0.00232624518338829*G0_1_0_8_8 + 0.0032025117739409*G0_1_0_9_0 + 0.000900052328623913*G0_1_0_9_1 - 0.00529755958327478*G0_1_0_9_2 - 0.0100528043385204*G0_1_0_9_3 + 0.0150706436420749*G0_1_0_9_4 - 0.00587412587412697*G0_1_0_9_5 + 0.00214071642643128*G0_1_0_9_6 - 0.00960753532182268*G0_1_0_9_7 + 0.0192150706436453*G0_1_0_9_9 - 0.0033645366978707*G0_1_1_0_0 - 0.000194197337054544*G0_1_1_0_1 - 1.42714428428837e-05*G0_1_1_0_3 - 6.08914894629235e-05*G0_1_1_0_4 - 0.000686614972329384*G0_1_1_0_5 - 0.000236588808017412*G0_1_1_0_6 - 0.00383330954759594*G0_1_1_0_7 + 0.00223966509680831*G0_1_1_0_8 - 0.000608914894629284*G0_1_1_0_9 - 0.000194197337054544*G0_1_1_1_0 + 0.000194197337054488*G0_1_1_1_2 - 0.00271728271728333*G0_1_1_1_3 + 0.00101232101232126*G0_1_1_1_4 + 0.00115979258836421*G0_1_1_1_5 - 0.00115979258836421*G0_1_1_1_6 - 0.00101232101232107*G0_1_1_1_7 + 0.0027172827172829*G0_1_1_1_8 + 0.000194197337054488*G0_1_1_2_1 + 0.00336453669787047*G0_1_1_2_2 - 0.00223966509680831*G0_1_1_2_3 + 0.00383330954759584*G0_1_1_2_4 + 0.000236588808017437*G0_1_1_2_5 + 0.000686614972329343*G0_1_1_2_6 + 6.08914894629363e-05*G0_1_1_2_7 + 1.42714428428561e-05*G0_1_1_2_8 + 0.000608914894629266*G0_1_1_2_9 - 1.42714428428838e-05*G0_1_1_3_0 - 0.00271728271728332*G0_1_1_3_1 - 0.00223966509680831*G0_1_1_3_2 - 0.00787212787212924*G0_1_1_3_3 + 0.00212073640645112*G0_1_1_3_4 - 0.001718281718282*G0_1_1_3_5 + 0.00347937776509264*G0_1_1_3_6 + 4.28143285286813e-05*G0_1_1_3_7 - 8.56286570572726e-05*G0_1_1_3_9 - 6.08914894629235e-05*G0_1_1_4_0 + 0.00101232101232125*G0_1_1_4_1 + 0.00383330954759584*G0_1_1_4_2 + 0.00212073640645111*G0_1_1_4_3 + 0.000194091622662949*G0_1_1_4_4 + 0.00018267446838879*G0_1_1_4_5 - 0.00366205223348143*G0_1_1_4_6 - 4.28143285285471e-05*G0_1_1_4_8 - 0.00219209362066538*G0_1_1_4_9 - 0.000686614972329383*G0_1_1_5_0 + 0.00115979258836421*G0_1_1_5_1 + 0.000236588808017437*G0_1_1_5_2 - 0.001718281718282*G0_1_1_5_3 + 0.00018267446838879*G0_1_1_5_4 + 0.0143684886542054*G0_1_1_5_5 + 0.0036620522334814*G0_1_1_5_7 - 0.00347937776509262*G0_1_1_5_8 + 0.00878550021407308*G0_1_1_5_9 - 0.000236588808017412*G0_1_1_6_0 - 0.00115979258836421*G0_1_1_6_1 + 0.000686614972329343*G0_1_1_6_2 + 0.00347937776509264*G0_1_1_6_3 - 0.00366205223348143*G0_1_1_6_4 - 0.0143684886542054*G0_1_1_6_6 - 0.000182674468388786*G0_1_1_6_7 + 0.00171828171828202*G0_1_1_6_8 - 0.00878550021407308*G0_1_1_6_9 - 0.00383330954759594*G0_1_1_7_0 - 0.00101232101232107*G0_1_1_7_1 + 6.08914894629363e-05*G0_1_1_7_2 + 4.28143285286812e-05*G0_1_1_7_3 + 0.0036620522334814*G0_1_1_7_5 - 0.000182674468388786*G0_1_1_7_6 - 0.000194091622663172*G0_1_1_7_7 - 0.00212073640645084*G0_1_1_7_8 + 0.00219209362066541*G0_1_1_7_9 + 0.00223966509680831*G0_1_1_8_0 + 0.0027172827172829*G0_1_1_8_1 + 1.42714428428561e-05*G0_1_1_8_2 - 4.2814328528547e-05*G0_1_1_8_4 - 0.00347937776509262*G0_1_1_8_5 + 0.00171828171828202*G0_1_1_8_6 - 0.00212073640645084*G0_1_1_8_7 + 0.0078721278721287*G0_1_1_8_8 + 8.56286570571817e-05*G0_1_1_8_9 - 0.000608914894629284*G0_1_1_9_0 + 0.000608914894629266*G0_1_1_9_2 - 8.56286570572722e-05*G0_1_1_9_3 - 0.00219209362066538*G0_1_1_9_4 + 0.00878550021407308*G0_1_1_9_5 - 0.00878550021407308*G0_1_1_9_6 + 0.00219209362066541*G0_1_1_9_7 + 8.56286570571818e-05*G0_1_1_9_8;
    A[181] = -0.00842910176243654*G0_0_0_0_0 + 0.00039586515777*G0_0_0_0_1 - 0.00075249265725469*G0_0_0_0_2 + 0.00157842157842186*G0_0_0_0_3 - 0.000864373721516731*G0_0_0_0_4 - 0.0118146932432667*G0_0_0_0_5 + 0.00621727478870442*G0_0_0_0_6 - 0.0022667808382098*G0_0_0_0_7 + 0.00154892726321325*G0_0_0_0_8 + 0.000123685837971563*G0_0_0_0_9 + 0.00039586515777*G0_0_0_1_0 + 0.016600683267353*G0_0_0_1_1 + 0.00175593366069587*G0_0_0_1_2 + 0.0206160506160542*G0_0_0_1_3 - 0.0073260073260086*G0_0_0_1_4 - 0.00237381665953134*G0_0_0_1_5 - 0.000593216307502127*G0_0_0_1_6 - 0.00293928293928348*G0_0_0_1_7 + 0.0043700743700752*G0_0_0_1_8 - 0.00254412254412295*G0_0_0_1_9 - 0.00075249265725469*G0_0_0_2_0 + 0.00175593366069587*G0_0_0_2_1 + 0.00152736152736178*G0_0_0_2_2 + 0.00362938648652997*G0_0_0_2_3 + 0.00114805829091562*G0_0_0_2_4 - 0.00327418613132954*G0_0_0_2_5 + 0.00538762824477201*G0_0_0_2_6 - 0.000916702345273929*G0_0_0_2_7 + 0.00142286285143453*G0_0_0_2_8 + 0.00415584415584486*G0_0_0_2_9 + 0.00157842157842186*G0_0_0_3_0 + 0.0206160506160542*G0_0_0_3_1 + 0.00362938648652997*G0_0_0_3_2 + 0.0461938061938142*G0_0_0_3_3 - 0.0234950763522232*G0_0_0_3_4 + 0.00162694448408759*G0_0_0_3_5 + 0.000911945197659629*G0_0_0_3_6 - 0.0056029684601123*G0_0_0_3_7 + 0.0107392607392626*G0_0_0_3_8 + 0.0188383045525935*G0_0_0_3_9 - 0.000864373721516731*G0_0_0_4_0 - 0.0073260073260086*G0_0_0_4_1 + 0.00114805829091562*G0_0_0_4_2 - 0.0234950763522232*G0_0_0_4_3 + 0.0104952190666494*G0_0_0_4_4 + 0.00172541743970345*G0_0_0_4_5 - 0.00263736263736308*G0_0_0_4_6 + 0.00310546596260936*G0_0_0_4_7 - 0.00513629227915033*G0_0_0_4_8 - 0.0159183673469415*G0_0_0_4_9 - 0.0118146932432667*G0_0_0_5_0 - 0.00237381665953134*G0_0_0_5_1 - 0.00327418613132954*G0_0_0_5_2 + 0.00162694448408759*G0_0_0_5_3 + 0.00172541743970345*G0_0_0_5_4 - 0.101121735407467*G0_0_0_5_5 + 0.00439417725132084*G0_0_0_5_6 - 0.00813614956472232*G0_0_0_5_7 + 0.00625374625374728*G0_0_0_5_8 - 0.0128785500214093*G0_0_0_5_9 + 0.00621727478870442*G0_0_0_6_0 - 0.000593216307502127*G0_0_0_6_1 + 0.005387628244772*G0_0_0_6_2 + 0.000911945197659629*G0_0_0_6_3 - 0.00263736263736308*G0_0_0_6_4 + 0.00439417725132084*G0_0_0_6_5 - 0.0190466676180994*G0_0_0_6_6 + 0.00188240331097505*G0_0_0_6_7 - 0.000810617953475236*G0_0_0_6_8 - 0.0142914228628538*G0_0_0_6_9 - 0.0022667808382098*G0_0_0_7_0 - 0.00293928293928348*G0_0_0_7_1 - 0.000916702345273929*G0_0_0_7_2 - 0.0056029684601123*G0_0_0_7_3 + 0.00310546596260936*G0_0_0_7_4 - 0.00813614956472232*G0_0_0_7_5 + 0.00188240331097505*G0_0_0_7_6 + 0.00218923933209689*G0_0_0_7_7 - 0.000610817753675044*G0_0_0_7_8 - 0.00413586413586482*G0_0_0_7_9 + 0.00154892726321325*G0_0_0_8_0 + 0.0043700743700752*G0_0_0_8_1 + 0.00142286285143453*G0_0_0_8_2 + 0.0107392607392626*G0_0_0_8_3 - 0.00513629227915033*G0_0_0_8_4 + 0.00625374625374728*G0_0_0_8_5 - 0.000810617953475237*G0_0_0_8_6 - 0.000610817753675044*G0_0_0_8_7 + 0.00645354645354764*G0_0_0_8_8 + 0.0179049521906695*G0_0_0_8_9 + 0.000123685837971563*G0_0_0_9_0 - 0.00254412254412295*G0_0_0_9_1 + 0.00415584415584486*G0_0_0_9_2 + 0.0188383045525935*G0_0_0_9_3 - 0.0159183673469415*G0_0_0_9_4 - 0.0128785500214093*G0_0_0_9_5 - 0.0142914228628539*G0_0_0_9_6 - 0.00413586413586482*G0_0_0_9_7 + 0.0179049521906695*G0_0_0_9_8 - 0.0203453689168008*G0_0_0_9_9 - 0.00237293570626946*G0_1_0_0_0 - 0.000801544134877601*G0_1_0_0_1 + 5.69448188495917e-05*G0_1_0_0_2 + 0.000133992991135881*G0_1_0_0_3 - 0.000287014572728913*G0_1_0_0_4 - 0.000945562374133963*G0_1_0_0_5 - 3.55200355200386e-05*G0_1_0_0_6 + 0.00435770578627793*G0_1_0_0_7 - 0.00223522509236831*G0_1_0_0_8 + 0.00133390419104727*G0_1_0_0_9 - 0.000801544134877601*G0_1_0_1_0 + 0.000797104130437605*G0_1_0_1_2 + 0.0109668109668129*G0_1_0_1_3 - 0.00275280275280324*G0_1_0_1_4 + 0.000498390498390584*G0_1_0_1_5 - 0.000493950493950584*G0_1_0_1_6 + 0.00674880674880786*G0_1_0_1_7 - 0.0109668109668128*G0_1_0_1_8 - 0.00399600399600465*G0_1_0_1_9 + 5.69448188495918e-05*G0_1_0_2_0 + 0.000797104130437605*G0_1_0_2_1 - 0.000273025034929846*G0_1_0_2_2 + 0.0022269793698369*G0_1_0_2_3 + 0.00142825428539738*G0_1_0_2_4 - 0.00021629164486311*G0_1_0_2_5 + 0.000408321836893339*G0_1_0_2_6 + 0.00139891854177591*G0_1_0_2_7 - 0.00124462838748573*G0_1_0_2_8 + 0.00371628371628435*G0_1_0_2_9 + 0.000133992991135881*G0_1_0_3_0 + 0.0109668109668129*G0_1_0_3_1 + 0.0022269793698369*G0_1_0_3_2 + 0.0317482517482573*G0_1_0_3_3 - 0.0173126873126903*G0_1_0_3_4 - 0.000685029256457942*G0_1_0_3_5 + 0.000954759526188252*G0_1_0_3_6 - 0.000929070929071128*G0_1_0_3_7 - 0.00227772227772259*G0_1_0_3_8 + 0.0138461538461562*G0_1_0_3_9 - 0.000287014572728913*G0_1_0_4_0 - 0.00275280275280324*G0_1_0_4_1 + 0.00142825428539738*G0_1_0_4_2 - 0.0173126873126903*G0_1_0_4_3 + 0.010383901812475*G0_1_0_4_4 + 0.00033395176252325*G0_1_0_4_5 - 0.0012887112887115*G0_1_0_4_6 - 0.00140430997573876*G0_1_0_4_7 + 0.00320679320679371*G0_1_0_4_8 - 0.0118167546738995*G0_1_0_4_9 - 0.000945562374133963*G0_1_0_5_0 + 0.000498390498390584*G0_1_0_5_1 - 0.00021629164486311*G0_1_0_5_2 - 0.000685029256457942*G0_1_0_5_3 + 0.00033395176252325*G0_1_0_5_4 + 0.000299700299700331*G0_1_0_5_5 + 0.0010275438846869*G0_1_0_5_6 + 0.00674611103182644*G0_1_0_5_7 - 0.00202226345083521*G0_1_0_5_8 + 4.28143285286209e-05*G0_1_0_5_9 - 3.55200355200387e-05*G0_1_0_6_0 - 0.000493950493950583*G0_1_0_6_1 + 0.000408321836893339*G0_1_0_6_2 + 0.000954759526188252*G0_1_0_6_3 - 0.0012887112887115*G0_1_0_6_4 + 0.0010275438846869*G0_1_0_6_5 + 0.00175538746967347*G0_1_0_6_6 - 0.00472384758099122*G0_1_0_6_7 + 0.0028714142999862*G0_1_0_6_8 - 0.0130583702012296*G0_1_0_6_9 + 0.00435770578627793*G0_1_0_7_0 + 0.00674880674880786*G0_1_0_7_1 + 0.00139891854177591*G0_1_0_7_2 - 0.000929070929071128*G0_1_0_7_3 - 0.00140430997573876*G0_1_0_7_4 + 0.00674611103182644*G0_1_0_7_5 - 0.00472384758099122*G0_1_0_7_6 + 0.0318824033109801*G0_1_0_7_7 - 0.00438561438561515*G0_1_0_7_8 + 0.00544598258884063*G0_1_0_7_9 - 0.00223522509236831*G0_1_0_8_0 - 0.0109668109668128*G0_1_0_8_1 - 0.00124462838748573*G0_1_0_8_2 - 0.00227772227772259*G0_1_0_8_3 + 0.00320679320679371*G0_1_0_8_4 - 0.00202226345083521*G0_1_0_8_5 + 0.0028714142999862*G0_1_0_8_6 - 0.00438561438561515*G0_1_0_8_7 - 0.0271928071928117*G0_1_0_8_8 + 0.00557442557442654*G0_1_0_8_9 + 0.00133390419104727*G0_1_0_9_0 - 0.00399600399600465*G0_1_0_9_1 + 0.00371628371628435*G0_1_0_9_2 + 0.0138461538461562*G0_1_0_9_3 - 0.0118167546738995*G0_1_0_9_4 + 4.28143285286217e-05*G0_1_0_9_5 - 0.0130583702012296*G0_1_0_9_6 + 0.00544598258884063*G0_1_0_9_7 + 0.00557442557442654*G0_1_0_9_8 - 0.0267161410018597*G0_1_0_9_9;
    A[176] = 0.0415815577720413*G0_0_0_0_0 + 0.0134561734561758*G0_0_0_0_1 + 0.00396118872309417*G0_0_0_0_2 + 0.0109909138480586*G0_0_0_0_3 - 0.00477110191395988*G0_0_0_0_4 + 0.0290558119129598*G0_0_0_0_5 - 0.0137813509242105*G0_0_0_0_6 + 0.00510431367574312*G0_0_0_0_7 + 0.00431526145811936*G0_0_0_0_8 + 0.00418375275518208*G0_0_0_0_9 + 0.0134561734561758*G0_0_0_1_0 + 0.338801938801997*G0_0_0_1_1 + 0.0167822301155663*G0_0_0_1_2 + 0.172020572020601*G0_0_0_1_3 - 0.0760158360158489*G0_0_0_1_4 + 0.00188256188256209*G0_0_0_1_5 - 0.0019092019092022*G0_0_0_1_6 - 0.0503822103822191*G0_0_0_1_7 + 0.0984644984645156*G0_0_0_1_8 + 0.0143323343323369*G0_0_0_1_9 + 0.00396118872309417*G0_0_0_2_0 + 0.0167822301155663*G0_0_0_2_1 + 0.00380346285108254*G0_0_0_2_2 + 0.0236352007780619*G0_0_0_2_3 - 0.011519485805202*G0_0_0_2_4 + 0.00529333100761764*G0_0_0_2_5 - 0.00530178815893191*G0_0_0_2_6 - 6.21600621600774e-05*G0_0_0_2_7 + 0.0159725988297444*G0_0_0_2_8 + 0.0120818863676027*G0_0_0_2_9 + 0.0109909138480586*G0_0_0_3_0 + 0.172020572020601*G0_0_0_3_1 + 0.0236352007780619*G0_0_0_3_2 + 0.277056277056324*G0_0_0_3_3 - 0.108238428238446*G0_0_0_3_4 - 0.0116607202321508*G0_0_0_3_5 - 0.00957138099995403*G0_0_0_3_6 - 0.0482717282717365*G0_0_0_3_7 + 0.11148851148853*G0_0_0_3_8 + 0.0535464535464627*G0_0_0_3_9 - 0.00477110191395988*G0_0_0_4_0 - 0.0760158360158489*G0_0_0_4_1 - 0.011519485805202*G0_0_0_4_2 - 0.108238428238446*G0_0_0_4_3 + 0.0509966224252024*G0_0_0_4_4 - 0.000985680985681161*G0_0_0_4_5 + 0.0105570619856352*G0_0_0_4_6 + 0.0148993863279603*G0_0_0_4_7 - 0.0632167832167939*G0_0_0_4_8 - 0.0342742971314458*G0_0_0_4_9 + 0.0290558119129598*G0_0_0_5_0 + 0.00188256188256209*G0_0_0_5_1 + 0.00529333100761764*G0_0_0_5_2 - 0.0116607202321508*G0_0_0_5_3 - 0.000985680985681161*G0_0_0_5_4 + 0.136549165120617*G0_0_0_5_5 - 0.0254260025688641*G0_0_0_5_6 + 0.0360591789163278*G0_0_0_5_7 - 0.0209466723752474*G0_0_0_5_8 + 0.0293420864849486*G0_0_0_5_9 - 0.0137813509242105*G0_0_0_6_0 - 0.0019092019092022*G0_0_0_6_1 - 0.00530178815893191*G0_0_0_6_2 - 0.00957138099995403*G0_0_0_6_3 + 0.0105570619856352*G0_0_0_6_4 - 0.0254260025688641*G0_0_0_6_5 + 0.0384529755958392*G0_0_0_6_6 - 0.0151125065410805*G0_0_0_6_7 - 0.0134456020170328*G0_0_0_6_8 - 0.0171028971029*G0_0_0_6_9 + 0.00510431367574312*G0_0_0_7_0 - 0.0503822103822191*G0_0_0_7_1 - 6.21600621600774e-05*G0_0_0_7_2 - 0.0482717282717365*G0_0_0_7_3 + 0.0148993863279603*G0_0_0_7_4 + 0.0360591789163278*G0_0_0_7_5 - 0.0151125065410805*G0_0_0_7_6 + 0.0954854669140544*G0_0_0_7_7 - 0.0563170163170259*G0_0_0_7_8 + 0.0176737548166149*G0_0_0_7_9 + 0.00431526145811936*G0_0_0_8_0 + 0.0984644984645156*G0_0_0_8_1 + 0.0159725988297444*G0_0_0_8_2 + 0.11148851148853*G0_0_0_8_3 - 0.0632167832167939*G0_0_0_8_4 - 0.0209466723752474*G0_0_0_8_5 - 0.0134456020170328*G0_0_0_8_6 - 0.0563170163170259*G0_0_0_8_7 + 0.292773892773943*G0_0_0_8_8 + 0.0834365634365776*G0_0_0_8_9 + 0.00418375275518208*G0_0_0_9_0 + 0.0143323343323369*G0_0_0_9_1 + 0.0120818863676027*G0_0_0_9_2 + 0.0535464535464627*G0_0_0_9_3 - 0.0342742971314458*G0_0_0_9_4 + 0.0293420864849486*G0_0_0_9_5 - 0.0171028971029*G0_0_0_9_6 + 0.0176737548166149*G0_0_0_9_7 + 0.0834365634365776*G0_0_0_9_8 + 0.15262451833883*G0_0_0_9_9 + 0.000165196355672512*G0_0_1_0_0 + 0.0162810029476725*G0_0_1_0_1 + 0.000959463816606838*G0_0_1_0_2 + 0.0116209716209737*G0_0_1_0_3 - 0.00473093044521698*G0_0_1_0_4 - 0.00109562395276704*G0_0_1_0_5 + 0.000342937485794701*G0_0_1_0_6 - 0.0048108505251371*G0_0_1_0_7 + 0.00829096829096977*G0_0_1_0_8 + 0.000682492111063674*G0_0_1_0_9 + 0.0162810029476725*G0_0_1_1_0 + 0.395851062517797*G0_0_1_1_1 + 0.0206549006549041*G0_0_1_1_2 + 0.208798608798644*G0_0_1_1_3 - 0.0935656935657094*G0_0_1_1_4 - 0.00377696377696454*G0_0_1_1_5 - 0.00334184334184386*G0_0_1_1_6 - 0.0714248714248838*G0_0_1_1_7 + 0.14498094498097*G0_0_1_1_8 + 0.0237984237984279*G0_0_1_1_9 + 0.000959463816606838*G0_0_1_2_0 + 0.0206549006549041*G0_0_1_2_1 + 0.00200660010183853*G0_0_1_2_2 + 0.0235941835941876*G0_0_1_2_3 - 0.00916924345495928*G0_0_1_2_4 - 0.000422434708149074*G0_0_1_2_5 - 0.00417275845847346*G0_0_1_2_7 + 0.00546712546712641*G0_0_1_2_8 + 0.00084486941629815*G0_0_1_2_9 + 0.0116209716209737*G0_0_1_3_0 + 0.208798608798644*G0_0_1_3_1 + 0.0235941835941876*G0_0_1_3_2 + 0.304095904095956*G0_0_1_3_3 - 0.112527472527492*G0_0_1_3_4 - 0.00543456543456637*G0_0_1_3_5 - 0.00263736263736309*G0_0_1_3_6 - 0.0475258075258157*G0_0_1_3_7 + 0.0765900765900898*G0_0_1_3_8 + 0.0236563436563479*G0_0_1_3_9 - 0.00473093044521698*G0_0_1_4_0 - 0.0935656935657094*G0_0_1_4_1 - 0.00916924345495928*G0_0_1_4_2 - 0.112527472527492*G0_0_1_4_3 + 0.045314685314693*G0_0_1_4_4 + 0.00152989867275609*G0_0_1_4_5 + 0.00110746396460701*G0_0_1_4_6 + 0.0196869796869831*G0_0_1_4_7 - 0.0290642690642741*G0_0_1_4_8 - 0.00559440559440663*G0_0_1_4_9 - 0.00109562395276704*G0_0_1_5_0 - 0.00377696377696453*G0_0_1_5_1 - 0.000422434708149074*G0_0_1_5_2 - 0.00543456543456637*G0_0_1_5_3 + 0.00152989867275609*G0_0_1_5_4 - 0.00300271157414069*G0_0_1_5_5 - 0.000102754388468665*G0_0_1_5_6 + 0.00147661861947602*G0_0_1_5_7 - 0.0013320013320016*G0_0_1_5_8 + 0.000616526330812119*G0_0_1_5_9 + 0.000342937485794701*G0_0_1_6_0 - 0.00334184334184386*G0_0_1_6_1 - 0.00263736263736309*G0_0_1_6_3 + 0.00110746396460701*G0_0_1_6_4 - 0.000102754388468665*G0_0_1_6_5 - 0.00110746396460699*G0_0_1_6_6 - 0.000144617287474449*G0_0_1_6_7 + 0.00314352314352367*G0_0_1_6_8 + 0.00274011702583177*G0_0_1_6_9 - 0.0048108505251371*G0_0_1_7_0 - 0.0714248714248838*G0_0_1_7_1 - 0.00417275845847346*G0_0_1_7_2 - 0.0475258075258157*G0_0_1_7_3 + 0.0196869796869831*G0_0_1_7_4 + 0.00147661861947602*G0_0_1_7_5 - 0.000144617287474449*G0_0_1_7_6 + 0.0217649017649055*G0_0_1_7_7 - 0.0354578754578817*G0_0_1_7_8 - 0.00175824175824214*G0_0_1_7_9 + 0.00829096829096977*G0_0_1_8_0 + 0.14498094498097*G0_0_1_8_1 + 0.00546712546712641*G0_0_1_8_2 + 0.0765900765900898*G0_0_1_8_3 - 0.0290642690642741*G0_0_1_8_4 - 0.0013320013320016*G0_0_1_8_5 + 0.00314352314352367*G0_0_1_8_6 - 0.0354578754578817*G0_0_1_8_7 + 0.00226440226440302*G0_0_1_8_8 - 0.0132667332667354*G0_0_1_8_9 + 0.000682492111063673*G0_0_1_9_0 + 0.0237984237984279*G0_0_1_9_1 + 0.000844869416298151*G0_0_1_9_2 + 0.0236563436563479*G0_0_1_9_3 - 0.00559440559440663*G0_0_1_9_4 + 0.000616526330812119*G0_0_1_9_5 + 0.00274011702583177*G0_0_1_9_6 - 0.00175824175824214*G0_0_1_9_7 - 0.0132667332667354*G0_0_1_9_8 - 0.00863136863137007*G0_0_1_9_9 + 0.000165196355672512*G0_1_0_0_0 + 0.0162810029476725*G0_1_0_0_1 + 0.000959463816606838*G0_1_0_0_2 + 0.0116209716209737*G0_1_0_0_3 - 0.00473093044521698*G0_1_0_0_4 - 0.00109562395276704*G0_1_0_0_5 + 0.000342937485794701*G0_1_0_0_6 - 0.0048108505251371*G0_1_0_0_7 + 0.00829096829096977*G0_1_0_0_8 + 0.000682492111063673*G0_1_0_0_9 + 0.0162810029476725*G0_1_0_1_0 + 0.395851062517797*G0_1_0_1_1 + 0.0206549006549041*G0_1_0_1_2 + 0.208798608798644*G0_1_0_1_3 - 0.0935656935657094*G0_1_0_1_4 - 0.00377696377696454*G0_1_0_1_5 - 0.00334184334184386*G0_1_0_1_6 - 0.0714248714248838*G0_1_0_1_7 + 0.14498094498097*G0_1_0_1_8 + 0.0237984237984279*G0_1_0_1_9 + 0.000959463816606838*G0_1_0_2_0 + 0.0206549006549041*G0_1_0_2_1 + 0.00200660010183853*G0_1_0_2_2 + 0.0235941835941876*G0_1_0_2_3 - 0.00916924345495928*G0_1_0_2_4 - 0.000422434708149074*G0_1_0_2_5 - 0.00417275845847346*G0_1_0_2_7 + 0.00546712546712641*G0_1_0_2_8 + 0.00084486941629815*G0_1_0_2_9 + 0.0116209716209737*G0_1_0_3_0 + 0.208798608798644*G0_1_0_3_1 + 0.0235941835941876*G0_1_0_3_2 + 0.304095904095956*G0_1_0_3_3 - 0.112527472527492*G0_1_0_3_4 - 0.00543456543456637*G0_1_0_3_5 - 0.00263736263736309*G0_1_0_3_6 - 0.0475258075258157*G0_1_0_3_7 + 0.0765900765900898*G0_1_0_3_8 + 0.0236563436563479*G0_1_0_3_9 - 0.00473093044521698*G0_1_0_4_0 - 0.0935656935657094*G0_1_0_4_1 - 0.00916924345495928*G0_1_0_4_2 - 0.112527472527492*G0_1_0_4_3 + 0.045314685314693*G0_1_0_4_4 + 0.00152989867275609*G0_1_0_4_5 + 0.00110746396460701*G0_1_0_4_6 + 0.0196869796869831*G0_1_0_4_7 - 0.0290642690642741*G0_1_0_4_8 - 0.00559440559440664*G0_1_0_4_9 - 0.00109562395276704*G0_1_0_5_0 - 0.00377696377696453*G0_1_0_5_1 - 0.000422434708149074*G0_1_0_5_2 - 0.00543456543456637*G0_1_0_5_3 + 0.00152989867275609*G0_1_0_5_4 - 0.00300271157414069*G0_1_0_5_5 - 0.000102754388468664*G0_1_0_5_6 + 0.00147661861947602*G0_1_0_5_7 - 0.0013320013320016*G0_1_0_5_8 + 0.000616526330812119*G0_1_0_5_9 + 0.000342937485794701*G0_1_0_6_0 - 0.00334184334184386*G0_1_0_6_1 - 0.00263736263736309*G0_1_0_6_3 + 0.00110746396460701*G0_1_0_6_4 - 0.000102754388468664*G0_1_0_6_5 - 0.00110746396460699*G0_1_0_6_6 - 0.000144617287474449*G0_1_0_6_7 + 0.00314352314352367*G0_1_0_6_8 + 0.00274011702583177*G0_1_0_6_9 - 0.0048108505251371*G0_1_0_7_0 - 0.0714248714248838*G0_1_0_7_1 - 0.00417275845847346*G0_1_0_7_2 - 0.0475258075258157*G0_1_0_7_3 + 0.0196869796869831*G0_1_0_7_4 + 0.00147661861947602*G0_1_0_7_5 - 0.000144617287474449*G0_1_0_7_6 + 0.0217649017649055*G0_1_0_7_7 - 0.0354578754578817*G0_1_0_7_8 - 0.00175824175824214*G0_1_0_7_9 + 0.00829096829096977*G0_1_0_8_0 + 0.14498094498097*G0_1_0_8_1 + 0.00546712546712641*G0_1_0_8_2 + 0.0765900765900898*G0_1_0_8_3 - 0.0290642690642741*G0_1_0_8_4 - 0.0013320013320016*G0_1_0_8_5 + 0.00314352314352367*G0_1_0_8_6 - 0.0354578754578817*G0_1_0_8_7 + 0.00226440226440302*G0_1_0_8_8 - 0.0132667332667354*G0_1_0_8_9 + 0.000682492111063673*G0_1_0_9_0 + 0.0237984237984279*G0_1_0_9_1 + 0.000844869416298151*G0_1_0_9_2 + 0.0236563436563479*G0_1_0_9_3 - 0.00559440559440663*G0_1_0_9_4 + 0.000616526330812119*G0_1_0_9_5 + 0.00274011702583177*G0_1_0_9_6 - 0.00175824175824214*G0_1_0_9_7 - 0.0132667332667354*G0_1_0_9_8 - 0.00863136863137007*G0_1_0_9_9 + 0.00401320020367709*G0_1_1_0_0 + 0.0281397614730997*G0_1_1_0_1 + 0.00299312680265112*G0_1_1_0_2 + 0.027291227291232*G0_1_1_0_3 - 0.0126066526066548*G0_1_1_0_4 - 0.00137470994613876*G0_1_1_0_5 - 0.00144321287178454*G0_1_1_0_6 - 0.0169637769637799*G0_1_1_0_7 + 0.039264439264446*G0_1_1_0_8 + 0.010212010212012*G0_1_1_0_9 + 0.0281397614730997*G0_1_1_1_0 + 0.497379164045916*G0_1_1_1_1 + 0.0281397614730995*G0_1_1_1_2 + 0.272616272616319*G0_1_1_1_3 - 0.125474525474547*G0_1_1_1_4 - 0.0064528064528077*G0_1_1_1_5 - 0.00645280645280747*G0_1_1_1_6 - 0.125474525474547*G0_1_1_1_7 + 0.272616272616319*G0_1_1_1_8 + 0.0433344433344508*G0_1_1_1_9 + 0.00299312680265112*G0_1_1_2_0 + 0.0281397614730995*G0_1_1_2_1 + 0.00401320020367706*G0_1_1_2_2 + 0.0392644392644459*G0_1_1_2_3 - 0.0169637769637798*G0_1_1_2_4 - 0.00144321287178454*G0_1_1_2_5 - 0.00137470994613874*G0_1_1_2_6 - 0.0126066526066547*G0_1_1_2_7 + 0.0272912272912319*G0_1_1_2_8 + 0.0102120102120119*G0_1_1_2_9 + 0.027291227291232*G0_1_1_3_0 + 0.272616272616319*G0_1_1_3_1 + 0.0392644392644459*G0_1_1_3_2 + 0.455011655011732*G0_1_1_3_3 - 0.178754578754609*G0_1_1_3_4 - 0.0153180153180179*G0_1_1_3_5 - 0.0125208125208146*G0_1_1_3_6 - 0.113752913752933*G0_1_1_3_7 + 0.227505827505866*G0_1_1_3_8 + 0.0975024975025141*G0_1_1_3_9 - 0.0126066526066548*G0_1_1_4_0 - 0.125474525474547*G0_1_1_4_1 - 0.0169637769637798*G0_1_1_4_2 - 0.178754578754609*G0_1_1_4_3 + 0.0774691974692104*G0_1_1_4_4 + 0.00594072594072695*G0_1_1_4_5 + 0.00658008658008767*G0_1_1_4_6 + 0.0537595737595828*G0_1_1_4_7 - 0.113752913752933*G0_1_1_4_8 - 0.0425174825174897*G0_1_1_4_9 - 0.00137470994613876*G0_1_1_5_0 - 0.0064528064528077*G0_1_1_5_1 - 0.00144321287178454*G0_1_1_5_2 - 0.0153180153180179*G0_1_1_5_3 + 0.00594072594072695*G0_1_1_5_4 + 0.00221492792921401*G0_1_1_5_5 + 0.000262594548308877*G0_1_1_5_6 + 0.00658008658008773*G0_1_1_5_7 - 0.0125208125208147*G0_1_1_5_8 - 0.00559440559440654*G0_1_1_5_9 - 0.00144321287178454*G0_1_1_6_0 - 0.00645280645280747*G0_1_1_6_1 - 0.00137470994613874*G0_1_1_6_2 - 0.0125208125208146*G0_1_1_6_3 + 0.00658008658008767*G0_1_1_6_4 + 0.000262594548308877*G0_1_1_6_5 + 0.002214927929214*G0_1_1_6_6 + 0.0059407259407269*G0_1_1_6_7 - 0.0153180153180178*G0_1_1_6_8 - 0.00559440559440654*G0_1_1_6_9 - 0.0169637769637799*G0_1_1_7_0 - 0.125474525474547*G0_1_1_7_1 - 0.0126066526066547*G0_1_1_7_2 - 0.113752913752933*G0_1_1_7_3 + 0.0537595737595828*G0_1_1_7_4 + 0.00658008658008773*G0_1_1_7_5 + 0.0059407259407269*G0_1_1_7_6 + 0.0774691974692106*G0_1_1_7_7 - 0.178754578754609*G0_1_1_7_8 - 0.0425174825174897*G0_1_1_7_9 + 0.039264439264446*G0_1_1_8_0 + 0.272616272616319*G0_1_1_8_1 + 0.0272912272912319*G0_1_1_8_2 + 0.227505827505866*G0_1_1_8_3 - 0.113752913752933*G0_1_1_8_4 - 0.0125208125208147*G0_1_1_8_5 - 0.0153180153180178*G0_1_1_8_6 - 0.178754578754609*G0_1_1_8_7 + 0.455011655011732*G0_1_1_8_8 + 0.097502497502514*G0_1_1_8_9 + 0.010212010212012*G0_1_1_9_0 + 0.0433344433344508*G0_1_1_9_1 + 0.0102120102120119*G0_1_1_9_2 + 0.0975024975025141*G0_1_1_9_3 - 0.0425174825174897*G0_1_1_9_4 - 0.00559440559440654*G0_1_1_9_5 - 0.00559440559440654*G0_1_1_9_6 - 0.0425174825174897*G0_1_1_9_7 + 0.097502497502514*G0_1_1_9_8 + 0.0498701298701383*G0_1_1_9_9;
    A[21] = 0.00590767257434026*G0_0_0_0_0 + 0.000158333729762331*G0_0_0_0_1 + 0.000809604857224042*G0_0_0_0_2 - 0.000425896854468357*G0_0_0_0_3 - 6.15786330072135e-06*G0_0_0_0_4 + 0.00915232915233071*G0_0_0_0_5 - 0.00428542357113859*G0_0_0_0_6 + 0.00165575165575194*G0_0_0_0_7 - 0.00112044040615488*G0_0_0_0_8 + 0.00137211994354875*G0_0_0_0_9 + 0.000158333729762331*G0_0_0_1_0 - 0.00286380286380332*G0_0_0_1_1 - 0.000317310555405849*G0_0_0_1_2 - 0.0036570836570843*G0_0_0_1_3 + 0.00112313612313632*G0_0_0_1_4 + 0.000763390049104458*G0_0_0_1_5 + 0.000146070860356599*G0_0_0_1_6 - 0.000240685240685297*G0_0_0_1_7 - 0.000510970510970555*G0_0_0_1_8 - 0.000405150405150477*G0_0_0_1_9 + 0.000809604857224042*G0_0_0_2_0 - 0.000317310555405849*G0_0_0_2_1 + 0.00448070448070521*G0_0_0_2_2 - 0.000792382220953787*G0_0_0_2_3 - 0.000245785960071719*G0_0_0_2_4 + 0.00113584827870562*G0_0_0_2_5 - 0.00107289535860984*G0_0_0_2_6 - 0.000354539640253985*G0_0_0_2_7 + 5.26721955293484e-05*G0_0_0_2_8 - 0.0016821273964134*G0_0_0_2_9 - 0.000425896854468357*G0_0_0_3_0 - 0.0036570836570843*G0_0_0_3_1 - 0.000792382220953787*G0_0_0_3_2 - 0.00836163836163987*G0_0_0_3_3 + 0.00586770372484761*G0_0_0_3_4 - 0.000685029256457926*G0_0_0_3_5 - 8.06336520622366e-05*G0_0_0_3_6 + 0.00163526949241263*G0_0_0_3_7 - 0.00183483183483215*G0_0_0_3_8 - 0.00205508776937384*G0_0_0_3_9 - 6.15786330072134e-06*G0_0_0_4_0 + 0.00112313612313632*G0_0_0_4_1 - 0.000245785960071719*G0_0_0_4_2 + 0.00586770372484761*G0_0_0_4_3 - 0.00711574140145686*G0_0_0_4_4 + 0.000376052518909719*G0_0_0_4_5 - 0.000295418866847488*G0_0_0_4_6 + 0.000362256790828278*G0_0_0_4_7 + 0.000199562342419516*G0_0_0_4_8 + 0.00429427715142075*G0_0_0_4_9 + 0.00915232915233072*G0_0_0_5_0 + 0.000763390049104458*G0_0_0_5_1 + 0.00113584827870563*G0_0_0_5_2 - 0.000685029256457926*G0_0_0_5_3 + 0.000376052518909719*G0_0_0_5_4 + 0.0569444840873507*G0_0_0_5_5 - 0.00367703724846643*G0_0_0_5_6 + 0.000511393368536292*G0_0_0_5_7 - 0.00193259121830581*G0_0_0_5_8 - 0.000251177394034597*G0_0_0_5_9 - 0.00428542357113859*G0_0_0_6_0 + 0.000146070860356599*G0_0_0_6_1 - 0.00107289535860984*G0_0_0_6_2 - 8.06336520622367e-05*G0_0_0_6_3 - 0.000295418866847488*G0_0_0_6_4 - 0.00367703724846643*G0_0_0_6_5 - 0.00410161267304196*G0_0_0_6_6 + 0.00142119784976952*G0_0_0_6_7 - 0.000476904048332704*G0_0_0_6_8 + 0.00520764949336466*G0_0_0_6_9 + 0.00165575165575194*G0_0_0_7_0 - 0.000240685240685297*G0_0_0_7_1 - 0.000354539640253985*G0_0_0_7_2 + 0.00163526949241263*G0_0_0_7_3 + 0.000362256790828278*G0_0_0_7_4 + 0.000511393368536292*G0_0_0_7_5 + 0.00142119784976952*G0_0_0_7_6 - 0.00859664145378573*G0_0_0_7_7 + 0.00317658531944296*G0_0_0_7_8 - 0.00695875553018528*G0_0_0_7_9 - 0.00112044040615488*G0_0_0_8_0 - 0.000510970510970555*G0_0_0_8_1 + 5.26721955293484e-05*G0_0_0_8_2 - 0.00183483183483215*G0_0_0_8_3 + 0.000199562342419516*G0_0_0_8_4 - 0.00193259121830581*G0_0_0_8_5 - 0.000476904048332704*G0_0_0_8_6 + 0.00317658531944296*G0_0_0_8_7 - 0.00125541125541137*G0_0_0_8_8 + 0.000816326530612394*G0_0_0_8_9 + 0.00137211994354875*G0_0_0_9_0 - 0.000405150405150477*G0_0_0_9_1 - 0.0016821273964134*G0_0_0_9_2 - 0.00205508776937384*G0_0_0_9_3 + 0.00429427715142075*G0_0_0_9_4 - 0.000251177394034597*G0_0_0_9_5 + 0.00520764949336466*G0_0_0_9_6 - 0.00695875553018528*G0_0_0_9_7 + 0.000816326530612393*G0_0_0_9_8 - 0.00645640074211614*G0_0_0_9_9 - 0.0170459170459201*G0_0_1_0_0 - 0.000135455373550635*G0_0_1_0_1 - 0.000591824401348315*G0_0_1_0_2 - 4.5880045880048e-05*G0_0_1_0_3 + 4.11757554614771e-05*G0_0_1_0_4 - 0.00662670662670778*G0_0_1_0_5 + 0.00222769294197905*G0_0_1_0_6 - 0.00212343212343252*G0_0_1_0_7 + 0.00158611230039831*G0_0_1_0_8 + 0.000466359037787679*G0_0_1_0_9 - 0.000135455373550635*G0_0_1_1_0 - 0.000140194902099685*G0_0_1_1_2 - 0.00182854182854211*G0_0_1_1_3 + 0.000292670292670329*G0_0_1_1_4 + 7.89157932015147e-05*G0_0_1_1_5 + 0.000196734482448802*G0_0_1_1_6 - 0.000627890627890758*G0_0_1_1_7 + 0.00182854182854218*G0_0_1_1_8 + 0.000335220335220394*G0_0_1_1_9 - 0.000591824401348315*G0_0_1_2_0 - 0.000140194902099685*G0_0_1_2_1 + 0.00407525455144571*G0_0_1_2_2 - 0.000426372569229783*G0_0_1_2_3 - 0.000477511906083415*G0_0_1_2_4 - 0.000730724302152997*G0_0_1_2_5 - 0.000827690827690969*G0_0_1_2_6 - 0.000111370111370133*G0_0_1_2_7 + 0.000364661793233286*G0_0_1_2_8 - 0.00128173413887721*G0_0_1_2_9 - 4.5880045880048e-05*G0_0_1_3_0 - 0.00182854182854211*G0_0_1_3_1 - 0.000426372569229783*G0_0_1_3_2 - 0.0055744255744265*G0_0_1_3_3 + 0.00410732125017908*G0_0_1_3_4 - 0.000169592312449472*G0_0_1_3_5 - 0.00035012606441184*G0_0_1_3_6 + 0.000377717520574721*G0_0_1_3_7 + 0.00047619047619057*G0_0_1_3_8 - 0.00176109604681063*G0_0_1_3_9 + 4.11757554614771e-05*G0_0_1_4_0 + 0.000292670292670329*G0_0_1_4_1 - 0.000477511906083415*G0_0_1_4_2 + 0.00410732125017908*G0_0_1_4_3 - 0.00549878692735923*G0_0_1_4_4 + 0.000116550116550132*G0_0_1_4_5 + 0.000233575947861705*G0_0_1_4_6 - 1.47471576043e-05*G0_0_1_4_7 - 0.000853907996765293*G0_0_1_4_8 + 0.00361210218353137*G0_0_1_4_9 - 0.00662670662670778*G0_0_1_5_0 + 7.89157932015147e-05*G0_0_1_5_1 - 0.000730724302152997*G0_0_1_5_2 - 0.000169592312449472*G0_0_1_5_3 + 0.000116550116550132*G0_0_1_5_4 + 0.0201679273107877*G0_0_1_5_5 + 0.00651729223157907*G0_0_1_5_6 - 0.000577517720374985*G0_0_1_5_7 + 3.33000333002002e-06*G0_0_1_5_8 - 0.0014057371200231*G0_0_1_5_9 + 0.00222769294197905*G0_0_1_6_0 + 0.000196734482448802*G0_0_1_6_1 - 0.000827690827690969*G0_0_1_6_2 - 0.00035012606441184*G0_0_1_6_3 + 0.000233575947861705*G0_0_1_6_4 + 0.00651729223157906*G0_0_1_6_5 - 0.00713334284762978*G0_0_1_6_6 + 0.000574187717044964*G0_0_1_6_7 - 0.000962133104990415*G0_0_1_6_8 + 0.00454545454545532*G0_0_1_6_9 - 0.00212343212343252*G0_0_1_7_0 - 0.000627890627890758*G0_0_1_7_1 - 0.000111370111370133*G0_0_1_7_2 + 0.000377717520574721*G0_0_1_7_3 - 1.47471576042999e-05*G0_0_1_7_4 - 0.000577517720374985*G0_0_1_7_5 + 0.000574187717044964*G0_0_1_7_6 + 0.00768041482327324*G0_0_1_7_7 - 0.0025721897150473*G0_0_1_7_8 - 0.00254745254745299*G0_0_1_7_9 + 0.00158611230039831*G0_0_1_8_0 + 0.00182854182854218*G0_0_1_8_1 + 0.000364661793233286*G0_0_1_8_2 + 0.00047619047619057*G0_0_1_8_3 - 0.000853907996765293*G0_0_1_8_4 + 3.33000333001999e-06*G0_0_1_8_5 - 0.000962133104990415*G0_0_1_8_6 - 0.0025721897150473*G0_0_1_8_7 + 0.00462204462204546*G0_0_1_8_8 + 0.000702154987869404*G0_0_1_8_9 + 0.000466359037787679*G0_0_1_9_0 + 0.000335220335220394*G0_0_1_9_1 - 0.00128173413887721*G0_0_1_9_2 - 0.00176109604681063*G0_0_1_9_3 + 0.00361210218353137*G0_0_1_9_4 - 0.00140573712002309*G0_0_1_9_5 + 0.00454545454545532*G0_0_1_9_6 - 0.00254745254745299*G0_0_1_9_7 + 0.000702154987869404*G0_0_1_9_8 - 0.00428143285286217*G0_0_1_9_9;
    A[52] = A[108] - 0.00143066809733506*G0_0_1_0_0 + 0.000196170672361201*G0_0_1_0_1 + 0.000396887063553791*G0_0_1_0_2 - 0.000769072197643758*G0_0_1_0_3 + 0.00237793952079706*G0_0_1_0_5 - 0.00396333824905322*G0_0_1_0_6 - 0.000344100344100371*G0_0_1_0_8 + 0.0023271966129113*G0_0_1_0_9 + 0.000196170672361201*G0_0_1_1_0 + 0.00287120287120375*G0_0_1_1_1 + 0.000388782293544272*G0_0_1_1_2 + 0.00119436119436146*G0_0_1_1_3 - 0.00297194868623494*G0_0_1_1_4 + 0.000926375212089635*G0_0_1_1_5 - 0.000828060828060968*G0_0_1_1_6 - 0.00131138702567307*G0_0_1_1_7 + 0.0010833610833615*G0_0_1_1_8 + 0.00265829408686599*G0_0_1_1_9 + 0.000396887063553791*G0_0_1_2_0 + 0.000388782293544272*G0_0_1_2_1 + 0.0516372516372603*G0_0_1_2_2 - 0.00198595055737946*G0_0_1_2_3 - 0.00158064158064187*G0_0_1_2_4 - 0.000582909154337792*G0_0_1_2_5 - 0.00262848262848315*G0_0_1_2_6 + 0.000110048681477268*G0_0_1_2_7 + 0.000892123749266765*G0_0_1_2_8 - 0.00678178963893365*G0_0_1_2_9 - 0.000769072197643758*G0_0_1_3_0 + 0.00119436119436146*G0_0_1_3_1 - 0.00198595055737946*G0_0_1_3_2 - 0.000211217354074582*G0_0_1_3_3 + 0.0174539745968347*G0_0_1_3_4 - 0.000685029256457893*G0_0_1_3_5 + 0.00338233195376104*G0_0_1_3_6 + 0.00320536606250947*G0_0_1_3_7 - 0.00142714428428737*G0_0_1_3_8 - 0.0143856143856169*G0_0_1_3_9 - 0.00297194868623494*G0_0_1_4_1 - 0.00158064158064186*G0_0_1_4_2 + 0.0174539745968347*G0_0_1_4_3 - 0.0516055373198316*G0_0_1_4_4 + 0.000796346510632328*G0_0_1_4_5 - 0.00417867846439339*G0_0_1_4_6 - 0.000665049236477926*G0_0_1_4_7 - 0.00177822177822211*G0_0_1_4_8 + 0.0187526758955363*G0_0_1_4_9 + 0.00237793952079706*G0_0_1_5_0 + 0.000926375212089635*G0_0_1_5_1 - 0.000582909154337793*G0_0_1_5_2 - 0.000685029256457893*G0_0_1_5_3 + 0.000796346510632329*G0_0_1_5_4 + 0.0600713572142242*G0_0_1_5_5 + 0.0147652347652373*G0_0_1_5_6 + 0.00131297274154433*G0_0_1_5_7 - 0.00188097616669071*G0_0_1_5_8 - 0.00321963750535245*G0_0_1_5_9 - 0.00396333824905322*G0_0_1_6_0 - 0.000828060828060968*G0_0_1_6_1 - 0.00262848262848315*G0_0_1_6_2 + 0.00338233195376104*G0_0_1_6_3 - 0.00417867846439339*G0_0_1_6_4 + 0.0147652347652373*G0_0_1_6_5 - 0.134322820037128*G0_0_1_6_6 + 0.000568003425146373*G0_0_1_6_7 - 0.000545169116597828*G0_0_1_6_8 + 0.0135807050092789*G0_0_1_6_9 - 0.00131138702567307*G0_0_1_7_1 + 0.000110048681477268*G0_0_1_7_2 + 0.00320536606250947*G0_0_1_7_3 - 0.000665049236477926*G0_0_1_7_4 + 0.00131297274154433*G0_0_1_7_5 + 0.000568003425146373*G0_0_1_7_6 - 0.00283716283716331*G0_0_1_7_7 + 0.00284001712573181*G0_0_1_7_8 - 0.00811759668902666*G0_0_1_7_9 - 0.000344100344100371*G0_0_1_8_0 + 0.0010833610833615*G0_0_1_8_1 + 0.000892123749266765*G0_0_1_8_2 - 0.00142714428428737*G0_0_1_8_3 - 0.00177822177822211*G0_0_1_8_4 - 0.00188097616669071*G0_0_1_8_5 - 0.000545169116597828*G0_0_1_8_6 + 0.00284001712573181*G0_0_1_8_7 - 0.00180961895247608*G0_0_1_8_8 - 0.00441843870415374*G0_0_1_8_9 + 0.0023271966129113*G0_0_1_9_0 + 0.00265829408686598*G0_0_1_9_1 - 0.00678178963893365*G0_0_1_9_2 - 0.0143856143856169*G0_0_1_9_3 + 0.0187526758955363*G0_0_1_9_4 - 0.00321963750535245*G0_0_1_9_5 + 0.0135807050092789*G0_0_1_9_6 - 0.00811759668902666*G0_0_1_9_7 - 0.00441843870415374*G0_0_1_9_8 + 0.0293877551020457*G0_0_1_9_9 + 0.00143066809733506*G0_1_0_0_0 - 0.000196170672361201*G0_1_0_0_1 - 0.000396887063553791*G0_1_0_0_2 + 0.000769072197643758*G0_1_0_0_3 - 0.00237793952079706*G0_1_0_0_5 + 0.00396333824905322*G0_1_0_0_6 + 0.000344100344100371*G0_1_0_0_8 - 0.0023271966129113*G0_1_0_0_9 - 0.000196170672361201*G0_1_0_1_0 - 0.00287120287120375*G0_1_0_1_1 - 0.000388782293544273*G0_1_0_1_2 - 0.00119436119436146*G0_1_0_1_3 + 0.00297194868623494*G0_1_0_1_4 - 0.000926375212089635*G0_1_0_1_5 + 0.000828060828060968*G0_1_0_1_6 + 0.00131138702567307*G0_1_0_1_7 - 0.0010833610833615*G0_1_0_1_8 - 0.00265829408686599*G0_1_0_1_9 - 0.000396887063553791*G0_1_0_2_0 - 0.000388782293544273*G0_1_0_2_1 - 0.0516372516372603*G0_1_0_2_2 + 0.00198595055737946*G0_1_0_2_3 + 0.00158064158064186*G0_1_0_2_4 + 0.000582909154337793*G0_1_0_2_5 + 0.00262848262848315*G0_1_0_2_6 - 0.000110048681477268*G0_1_0_2_7 - 0.000892123749266765*G0_1_0_2_8 + 0.00678178963893365*G0_1_0_2_9 + 0.000769072197643758*G0_1_0_3_0 - 0.00119436119436146*G0_1_0_3_1 + 0.00198595055737946*G0_1_0_3_2 + 0.000211217354074588*G0_1_0_3_3 - 0.0174539745968347*G0_1_0_3_4 + 0.000685029256457891*G0_1_0_3_5 - 0.00338233195376104*G0_1_0_3_6 - 0.00320536606250947*G0_1_0_3_7 + 0.00142714428428737*G0_1_0_3_8 + 0.0143856143856169*G0_1_0_3_9 + 0.00297194868623494*G0_1_0_4_1 + 0.00158064158064186*G0_1_0_4_2 - 0.0174539745968347*G0_1_0_4_3 + 0.0516055373198316*G0_1_0_4_4 - 0.000796346510632329*G0_1_0_4_5 + 0.00417867846439339*G0_1_0_4_6 + 0.000665049236477926*G0_1_0_4_7 + 0.00177822177822211*G0_1_0_4_8 - 0.0187526758955363*G0_1_0_4_9 - 0.00237793952079706*G0_1_0_5_0 - 0.000926375212089635*G0_1_0_5_1 + 0.000582909154337793*G0_1_0_5_2 + 0.000685029256457891*G0_1_0_5_3 - 0.000796346510632329*G0_1_0_5_4 - 0.0600713572142242*G0_1_0_5_5 - 0.0147652347652373*G0_1_0_5_6 - 0.00131297274154433*G0_1_0_5_7 + 0.00188097616669071*G0_1_0_5_8 + 0.00321963750535245*G0_1_0_5_9 + 0.00396333824905322*G0_1_0_6_0 + 0.000828060828060968*G0_1_0_6_1 + 0.00262848262848314*G0_1_0_6_2 - 0.00338233195376104*G0_1_0_6_3 + 0.00417867846439339*G0_1_0_6_4 - 0.0147652347652373*G0_1_0_6_5 + 0.134322820037128*G0_1_0_6_6 - 0.000568003425146374*G0_1_0_6_7 + 0.000545169116597827*G0_1_0_6_8 - 0.0135807050092789*G0_1_0_6_9 + 0.00131138702567307*G0_1_0_7_1 - 0.000110048681477268*G0_1_0_7_2 - 0.00320536606250947*G0_1_0_7_3 + 0.000665049236477925*G0_1_0_7_4 - 0.00131297274154433*G0_1_0_7_5 - 0.000568003425146373*G0_1_0_7_6 + 0.00283716283716331*G0_1_0_7_7 - 0.00284001712573181*G0_1_0_7_8 + 0.00811759668902666*G0_1_0_7_9 + 0.000344100344100371*G0_1_0_8_0 - 0.0010833610833615*G0_1_0_8_1 - 0.000892123749266765*G0_1_0_8_2 + 0.00142714428428737*G0_1_0_8_3 + 0.00177822177822211*G0_1_0_8_4 + 0.00188097616669071*G0_1_0_8_5 + 0.000545169116597828*G0_1_0_8_6 - 0.00284001712573181*G0_1_0_8_7 + 0.00180961895247608*G0_1_0_8_8 + 0.00441843870415374*G0_1_0_8_9 - 0.0023271966129113*G0_1_0_9_0 - 0.00265829408686598*G0_1_0_9_1 + 0.00678178963893365*G0_1_0_9_2 + 0.0143856143856169*G0_1_0_9_3 - 0.0187526758955363*G0_1_0_9_4 + 0.00321963750535245*G0_1_0_9_5 - 0.0135807050092789*G0_1_0_9_6 + 0.00811759668902666*G0_1_0_9_7 + 0.00441843870415374*G0_1_0_9_8 - 0.0293877551020457*G0_1_0_9_9;
    A[35] = 0.00113558399272705*G0_1_0_0_0 + 0.000944003086860395*G0_1_0_0_1 + 0.0117478200811554*G0_1_0_0_2 - 0.00417748917748989*G0_1_0_0_3 + 0.00868964368964519*G0_1_0_0_4 - 0.00592851592851695*G0_1_0_0_5 + 0.0135714285714309*G0_1_0_0_6 - 0.00052074909217775*G0_1_0_0_7 - 0.000326736755308238*G0_1_0_0_8 + 0.00253857253857297*G0_1_0_0_9 + 0.000944003086860395*G0_1_0_1_0 + 0.00113558399272705*G0_1_0_1_1 + 0.0117478200811554*G0_1_0_1_2 - 0.00592851592851693*G0_1_0_1_3 + 0.0135714285714309*G0_1_0_1_4 - 0.00417748917748989*G0_1_0_1_5 + 0.00868964368964518*G0_1_0_1_6 - 0.000326736755308242*G0_1_0_1_7 - 0.000520749092177744*G0_1_0_1_8 + 0.00253857253857297*G0_1_0_1_9 + 0.0117478200811554*G0_1_0_2_0 + 0.0117478200811554*G0_1_0_2_1 + 0.2284591951259*G0_1_0_2_2 - 0.0524753024753112*G0_1_0_2_3 + 0.113297813297832*G0_1_0_2_4 - 0.0524753024753113*G0_1_0_2_5 + 0.113297813297832*G0_1_0_2_6 - 0.00252247752247793*G0_1_0_2_7 - 0.00252247752247793*G0_1_0_2_8 + 0.0166944166944195*G0_1_0_2_9 - 0.00417748917748989*G0_1_0_3_0 - 0.00592851592851693*G0_1_0_3_1 - 0.0524753024753112*G0_1_0_3_2 + 0.0270496170496216*G0_1_0_3_3 - 0.0619963369963474*G0_1_0_3_4 + 0.017975357975361*G0_1_0_3_5 - 0.0369547119547181*G0_1_0_3_6 + 0.00164668664668692*G0_1_0_3_7 + 0.00167166167166195*G0_1_0_3_8 - 0.0109090909090927*G0_1_0_3_9 + 0.00868964368964519*G0_1_0_4_0 + 0.0135714285714309*G0_1_0_4_1 + 0.113297813297832*G0_1_0_4_2 - 0.0619963369963474*G0_1_0_4_3 + 0.147818847818873*G0_1_0_4_4 - 0.0369547119547182*G0_1_0_4_5 + 0.0739094239094364*G0_1_0_4_6 - 0.00380785880785944*G0_1_0_4_7 - 0.00331834831834887*G0_1_0_4_8 + 0.0238261738261778*G0_1_0_4_9 - 0.00592851592851695*G0_1_0_5_0 - 0.00417748917748989*G0_1_0_5_1 - 0.0524753024753113*G0_1_0_5_2 + 0.017975357975361*G0_1_0_5_3 - 0.0369547119547182*G0_1_0_5_4 + 0.0270496170496216*G0_1_0_5_5 - 0.0619963369963474*G0_1_0_5_6 + 0.00167166167166195*G0_1_0_5_7 + 0.00164668664668692*G0_1_0_5_8 - 0.0109090909090927*G0_1_0_5_9 + 0.0135714285714309*G0_1_0_6_0 + 0.00868964368964518*G0_1_0_6_1 + 0.113297813297832*G0_1_0_6_2 - 0.0369547119547181*G0_1_0_6_3 + 0.0739094239094364*G0_1_0_6_4 - 0.0619963369963474*G0_1_0_6_5 + 0.147818847818873*G0_1_0_6_6 - 0.00331834831834886*G0_1_0_6_7 - 0.00380785880785943*G0_1_0_6_8 + 0.0238261738261778*G0_1_0_6_9 - 0.00052074909217775*G0_1_0_7_0 - 0.000326736755308242*G0_1_0_7_1 - 0.00252247752247793*G0_1_0_7_2 + 0.00164668664668692*G0_1_0_7_3 - 0.00380785880785944*G0_1_0_7_4 + 0.00167166167166195*G0_1_0_7_5 - 0.00331834831834886*G0_1_0_7_6 - 0.000705484991199375*G0_1_0_7_7 + 0.000204319490033806*G0_1_0_7_8 - 0.000979020979021142*G0_1_0_7_9 - 0.000326736755308238*G0_1_0_8_0 - 0.000520749092177744*G0_1_0_8_1 - 0.00252247752247793*G0_1_0_8_2 + 0.00167166167166195*G0_1_0_8_3 - 0.00331834831834887*G0_1_0_8_4 + 0.00164668664668692*G0_1_0_8_5 - 0.00380785880785943*G0_1_0_8_6 + 0.000204319490033806*G0_1_0_8_7 - 0.00070548499119936*G0_1_0_8_8 - 0.000979020979021136*G0_1_0_8_9 + 0.00253857253857297*G0_1_0_9_0 + 0.00253857253857297*G0_1_0_9_1 + 0.0166944166944195*G0_1_0_9_2 - 0.0109090909090927*G0_1_0_9_3 + 0.0238261738261778*G0_1_0_9_4 - 0.0109090909090927*G0_1_0_9_5 + 0.0238261738261778*G0_1_0_9_6 - 0.000979020979021142*G0_1_0_9_7 - 0.000979020979021136*G0_1_0_9_8 + 0.00803196803196937*G0_1_0_9_9 - 0.00037669561479091*G0_1_1_0_0 - 0.000193677574629992*G0_1_1_0_1 + 0.00287397787397837*G0_1_1_0_2 - 0.00305205376634001*G0_1_1_0_3 + 0.00448532948533026*G0_1_1_0_4 - 0.00158185729614328*G0_1_1_0_5 + 0.00371276871276935*G0_1_1_0_6 + 0.000163751592323052*G0_1_1_0_7 - 0.00104575318861052*G0_1_1_0_8 + 0.000279561708133181*G0_1_1_0_9 - 0.000193677574629992*G0_1_1_1_0 - 0.00739334739334872*G0_1_1_1_1 + 0.00430587930588004*G0_1_1_1_2 - 0.00552621981193506*G0_1_1_1_3 + 0.0101975801975819*G0_1_1_1_4 - 0.00213091141662606*G0_1_1_1_5 + 0.00371276871276934*G0_1_1_1_6 + 0.00247958390815578*G0_1_1_1_7 - 0.00622647194075876*G0_1_1_1_8 + 0.00137766994909874*G0_1_1_1_9 + 0.00287397787397837*G0_1_1_2_0 + 0.00430587930588004*G0_1_1_2_1 + 0.04288304288305*G0_1_1_2_2 - 0.0214183964184*G0_1_1_2_3 + 0.0501683501683586*G0_1_1_2_4 - 0.0125420875420896*G0_1_1_2_5 + 0.0250841750841793*G0_1_1_2_6 - 0.00144207644207668*G0_1_1_2_7 - 0.00210252710252745*G0_1_1_2_8 + 0.00733155733155856*G0_1_1_2_9 - 0.00305205376634001*G0_1_1_3_0 - 0.00552621981193506*G0_1_1_3_1 - 0.0214183964184*G0_1_1_3_2 + 0.00337662337662391*G0_1_1_3_3 - 0.0399450549450617*G0_1_1_3_4 + 0.0100216450216467*G0_1_1_3_5 - 0.0156327006327033*G0_1_1_3_6 + 0.00466176680462474*G0_1_1_3_7 - 0.00647495361781186*G0_1_1_3_8 - 0.0134565434565457*G0_1_1_3_9 + 0.00448532948533026*G0_1_1_4_0 + 0.0101975801975819*G0_1_1_4_1 + 0.0501683501683586*G0_1_1_4_2 - 0.0399450549450617*G0_1_1_4_3 + 0.100749250749268*G0_1_1_4_4 - 0.017950382950386*G0_1_1_4_5 + 0.0335830835830893*G0_1_1_4_6 - 0.00231768231768271*G0_1_1_4_7 + 0.00181318681318713*G0_1_1_4_8 + 0.0139060939060962*G0_1_1_4_9 - 0.00158185729614328*G0_1_1_5_0 - 0.00213091141662606*G0_1_1_5_1 - 0.0125420875420896*G0_1_1_5_2 + 0.0100216450216467*G0_1_1_5_3 - 0.017950382950386*G0_1_1_5_4 + 0.00561105561105657*G0_1_1_5_5 - 0.0156327006327033*G0_1_1_5_6 - 0.00173017458731773*G0_1_1_5_7 + 0.00189833975548293*G0_1_1_5_8 - 0.0046353646353654*G0_1_1_5_9 + 0.00371276871276935*G0_1_1_6_0 + 0.00371276871276934*G0_1_1_6_1 + 0.0250841750841793*G0_1_1_6_2 - 0.0156327006327033*G0_1_1_6_3 + 0.0335830835830893*G0_1_1_6_4 - 0.0156327006327033*G0_1_1_6_5 + 0.0335830835830893*G0_1_1_6_6 - 0.000168165168165198*G0_1_1_6_7 - 0.000168165168165196*G0_1_1_6_8 + 0.0092707292707308*G0_1_1_6_9 + 0.000163751592323052*G0_1_1_7_0 + 0.00247958390815578*G0_1_1_7_1 - 0.00144207644207668*G0_1_1_7_2 + 0.00466176680462474*G0_1_1_7_3 - 0.00231768231768271*G0_1_1_7_4 - 0.00173017458731773*G0_1_1_7_5 - 0.000168165168165198*G0_1_1_7_6 - 0.0166875981161724*G0_1_1_7_7 + 0.00561509918652874*G0_1_1_7_8 - 0.00050235478806915*G0_1_1_7_9 - 0.00104575318861052*G0_1_1_8_0 - 0.00622647194075876*G0_1_1_8_1 - 0.00210252710252745*G0_1_1_8_2 - 0.00647495361781186*G0_1_1_8_3 + 0.00181318681318713*G0_1_1_8_4 + 0.00189833975548293*G0_1_1_8_5 - 0.000168165168165196*G0_1_1_8_6 + 0.00561509918652874*G0_1_1_8_7 - 0.0353617810760729*G0_1_1_8_8 - 0.00775938347367049*G0_1_1_8_9 + 0.000279561708133181*G0_1_1_9_0 + 0.00137766994909874*G0_1_1_9_1 + 0.00733155733155856*G0_1_1_9_2 - 0.0134565434565457*G0_1_1_9_3 + 0.0139060939060962*G0_1_1_9_4 - 0.0046353646353654*G0_1_1_9_5 + 0.0092707292707308*G0_1_1_9_6 - 0.00050235478806915*G0_1_1_9_7 - 0.00775938347367049*G0_1_1_9_8 - 0.0260139860139904*G0_1_1_9_9;
    A[26] = -0.00852893138607575*G0_0_0_0_0 - 0.00744194077527542*G0_0_0_0_1 - 0.00113768066149038*G0_0_0_0_2 - 0.00497687497687585*G0_0_0_0_3 + 0.00204657776086383*G0_0_0_0_4 - 0.00570572284858099*G0_0_0_0_5 + 0.002806320663464*G0_0_0_0_6 + 0.000402296116581907*G0_0_0_0_7 - 0.00337384837384897*G0_0_0_0_8 - 0.00116090258947423*G0_0_0_0_9 - 0.00744194077527542*G0_0_0_1_0 - 0.185576152242851*G0_0_0_1_1 - 0.00887384220717703*G0_0_0_1_2 - 0.0882136382136533*G0_0_0_1_3 + 0.0399332149332217*G0_0_0_1_4 + 0.000419950419950551*G0_0_0_1_5 + 0.00108040108040124*G0_0_0_1_6 + 0.0310569060569114*G0_0_0_1_7 - 0.0631294631294741*G0_0_0_1_8 - 0.009362859362861*G0_0_0_1_9 - 0.00113768066149038*G0_0_0_2_0 - 0.00887384220717703*G0_0_0_2_1 - 0.00151227960751796*G0_0_0_2_2 - 0.00985865985866152*G0_0_0_2_3 + 0.00434665863237365*G0_0_0_2_4 - 0.000719016433302273*G0_0_0_2_5 + 0.000684500684500802*G0_0_0_2_6 + 0.00112543541114989*G0_0_0_2_7 - 0.00420431420431492*G0_0_0_2_8 - 0.00225901083043979*G0_0_0_2_9 - 0.00497687497687585*G0_0_0_3_0 - 0.0882136382136533*G0_0_0_3_1 - 0.00985865985866152*G0_0_0_3_2 - 0.114235764235784*G0_0_0_3_3 + 0.0463636363636442*G0_0_0_3_4 + 0.00363969363969426*G0_0_0_3_5 + 0.00315018315018368*G0_0_0_3_6 + 0.021322011322015*G0_0_0_3_7 - 0.0403263403263473*G0_0_0_3_8 - 0.0145554445554471*G0_0_0_3_9 + 0.00204657776086383*G0_0_0_4_0 + 0.0399332149332217*G0_0_0_4_1 + 0.00434665863237365*G0_0_0_4_2 + 0.0463636363636442*G0_0_0_4_3 - 0.0214385614385651*G0_0_0_4_4 + 0.000251653108796005*G0_0_0_4_5 - 0.00340183625897969*G0_0_0_4_6 - 0.00795371295371432*G0_0_0_4_7 + 0.0190043290043323*G0_0_0_4_8 + 0.00627372627372737*G0_0_0_4_9 - 0.00570572284858099*G0_0_0_5_0 + 0.000419950419950551*G0_0_0_5_1 - 0.000719016433302273*G0_0_0_5_2 + 0.00363969363969426*G0_0_0_5_3 + 0.000251653108796006*G0_0_0_5_4 - 0.0346562960848733*G0_0_0_5_5 + 0.00541077969649491*G0_0_0_5_6 - 0.00814661528947381*G0_0_0_5_7 + 0.00513153513153602*G0_0_0_5_8 - 0.00678036249464934*G0_0_0_5_9 + 0.002806320663464*G0_0_0_6_0 + 0.00108040108040124*G0_0_0_6_1 + 0.000684500684500802*G0_0_0_6_2 + 0.00315018315018368*G0_0_0_6_3 - 0.00340183625897969*G0_0_0_6_4 + 0.00541077969649491*G0_0_0_6_5 - 0.0159821131249729*G0_0_0_6_6 + 0.00301508015793781*G0_0_0_6_7 + 0.00149017649017673*G0_0_0_6_8 + 0.000476666190952*G0_0_0_6_9 + 0.000402296116581907*G0_0_0_7_0 + 0.0310569060569114*G0_0_0_7_1 + 0.00112543541114989*G0_0_0_7_2 + 0.021322011322015*G0_0_0_7_3 - 0.00795371295371432*G0_0_0_7_4 - 0.00814661528947381*G0_0_0_7_5 + 0.00301508015793781*G0_0_0_7_6 - 0.0236729936729977*G0_0_0_7_7 + 0.0220512820512859*G0_0_0_7_8 - 0.00254745254745296*G0_0_0_7_9 - 0.00337384837384897*G0_0_0_8_0 - 0.0631294631294741*G0_0_0_8_1 - 0.00420431420431492*G0_0_0_8_2 - 0.0403263403263473*G0_0_0_8_3 + 0.0190043290043323*G0_0_0_8_4 + 0.00513153513153602*G0_0_0_8_5 + 0.00149017649017673*G0_0_0_8_6 + 0.0220512820512859*G0_0_0_8_7 - 0.0470695970696053*G0_0_0_8_8 - 0.00992007992008165*G0_0_0_8_9 - 0.00116090258947423*G0_0_0_9_0 - 0.009362859362861*G0_0_0_9_1 - 0.00225901083043979*G0_0_0_9_2 - 0.0145554445554471*G0_0_0_9_3 + 0.00627372627372737*G0_0_0_9_4 - 0.00678036249464934*G0_0_0_9_5 + 0.000476666190952*G0_0_0_9_6 - 0.00254745254745296*G0_0_0_9_7 - 0.00992007992008165*G0_0_0_9_8 - 0.0340459540459598*G0_0_0_9_9 - 0.00113558399272704*G0_0_1_0_0 - 0.0117478200811555*G0_0_1_0_1 - 0.00094400308686039*G0_0_1_0_2 - 0.00868964368964519*G0_0_1_0_3 + 0.00417748917748989*G0_0_1_0_4 + 0.000520749092177764*G0_0_1_0_5 + 0.000326736755308234*G0_0_1_0_6 + 0.00592851592851695*G0_0_1_0_7 - 0.0135714285714309*G0_0_1_0_8 - 0.00253857253857298*G0_0_1_0_9 - 0.0117478200811555*G0_0_1_1_0 - 0.228459195125901*G0_0_1_1_1 - 0.0117478200811554*G0_0_1_1_2 - 0.113297813297833*G0_0_1_1_3 + 0.0524753024753113*G0_0_1_1_4 + 0.00252247752247802*G0_0_1_1_5 + 0.00252247752247791*G0_0_1_1_6 + 0.0524753024753115*G0_0_1_1_7 - 0.113297813297833*G0_0_1_1_8 - 0.0166944166944196*G0_0_1_1_9 - 0.00094400308686039*G0_0_1_2_0 - 0.0117478200811554*G0_0_1_2_1 - 0.00113558399272704*G0_0_1_2_2 - 0.0135714285714309*G0_0_1_2_3 + 0.00592851592851692*G0_0_1_2_4 + 0.000326736755308242*G0_0_1_2_5 + 0.000520749092177748*G0_0_1_2_6 + 0.00417748917748988*G0_0_1_2_7 - 0.00868964368964515*G0_0_1_2_8 - 0.00253857253857297*G0_0_1_2_9 - 0.00868964368964519*G0_0_1_3_0 - 0.113297813297833*G0_0_1_3_1 - 0.0135714285714309*G0_0_1_3_2 - 0.147818847818873*G0_0_1_3_3 + 0.0619963369963475*G0_0_1_3_4 + 0.00380785880785946*G0_0_1_3_5 + 0.00331834831834887*G0_0_1_3_6 + 0.0369547119547182*G0_0_1_3_7 - 0.0739094239094365*G0_0_1_3_8 - 0.0238261738261779*G0_0_1_3_9 + 0.00417748917748989*G0_0_1_4_0 + 0.0524753024753113*G0_0_1_4_1 + 0.00592851592851692*G0_0_1_4_2 + 0.0619963369963475*G0_0_1_4_3 - 0.0270496170496216*G0_0_1_4_4 - 0.00164668664668693*G0_0_1_4_5 - 0.00167166167166195*G0_0_1_4_6 - 0.017975357975361*G0_0_1_4_7 + 0.0369547119547182*G0_0_1_4_8 + 0.0109090909090928*G0_0_1_4_9 + 0.000520749092177764*G0_0_1_5_0 + 0.00252247752247802*G0_0_1_5_1 + 0.000326736755308242*G0_0_1_5_2 + 0.00380785880785946*G0_0_1_5_3 - 0.00164668664668693*G0_0_1_5_4 + 0.000705484991199402*G0_0_1_5_5 - 0.000204319490033816*G0_0_1_5_6 - 0.00167166167166197*G0_0_1_5_7 + 0.00331834831834892*G0_0_1_5_8 + 0.000979020979021152*G0_0_1_5_9 + 0.000326736755308234*G0_0_1_6_0 + 0.00252247752247791*G0_0_1_6_1 + 0.000520749092177748*G0_0_1_6_2 + 0.00331834831834887*G0_0_1_6_3 - 0.00167166167166195*G0_0_1_6_4 - 0.000204319490033816*G0_0_1_6_5 + 0.000705484991199388*G0_0_1_6_6 - 0.00164668664668691*G0_0_1_6_7 + 0.00380785880785942*G0_0_1_6_8 + 0.000979020979021144*G0_0_1_6_9 + 0.00592851592851695*G0_0_1_7_0 + 0.0524753024753115*G0_0_1_7_1 + 0.00417748917748988*G0_0_1_7_2 + 0.0369547119547182*G0_0_1_7_3 - 0.017975357975361*G0_0_1_7_4 - 0.00167166167166197*G0_0_1_7_5 - 0.00164668664668691*G0_0_1_7_6 - 0.0270496170496217*G0_0_1_7_7 + 0.0619963369963475*G0_0_1_7_8 + 0.0109090909090928*G0_0_1_7_9 - 0.0135714285714309*G0_0_1_8_0 - 0.113297813297833*G0_0_1_8_1 - 0.00868964368964515*G0_0_1_8_2 - 0.0739094239094365*G0_0_1_8_3 + 0.0369547119547182*G0_0_1_8_4 + 0.00331834831834892*G0_0_1_8_5 + 0.00380785880785942*G0_0_1_8_6 + 0.0619963369963475*G0_0_1_8_7 - 0.147818847818873*G0_0_1_8_8 - 0.0238261738261779*G0_0_1_8_9 - 0.00253857253857298*G0_0_1_9_0 - 0.0166944166944196*G0_0_1_9_1 - 0.00253857253857297*G0_0_1_9_2 - 0.0238261738261779*G0_0_1_9_3 + 0.0109090909090928*G0_0_1_9_4 + 0.000979020979021152*G0_0_1_9_5 + 0.000979020979021144*G0_0_1_9_6 + 0.0109090909090928*G0_0_1_9_7 - 0.0238261738261779*G0_0_1_9_8 - 0.00803196803196939*G0_0_1_9_9;
    A[135] = A[35] - 0.185576152242851*G0_0_0_0_0 - 0.00744194077527539*G0_0_0_0_1 - 0.00887384220717706*G0_0_0_0_2 + 0.000419950419950539*G0_0_0_0_3 + 0.00108040108040126*G0_0_0_0_4 - 0.0882136382136534*G0_0_0_0_5 + 0.0399332149332218*G0_0_0_0_6 - 0.0631294631294739*G0_0_0_0_7 + 0.0310569060569114*G0_0_0_0_8 - 0.00936285936286106*G0_0_0_0_9 - 0.00744194077527539*G0_0_0_1_0 - 0.00852893138607569*G0_0_0_1_1 - 0.00113768066149037*G0_0_0_1_2 - 0.00570572284858096*G0_0_0_1_3 + 0.00280632066346399*G0_0_0_1_4 - 0.00497687497687581*G0_0_0_1_5 + 0.00204657776086382*G0_0_0_1_6 - 0.00337384837384895*G0_0_0_1_7 + 0.000402296116581898*G0_0_0_1_8 - 0.00116090258947422*G0_0_0_1_9 - 0.00887384220717706*G0_0_0_2_0 - 0.00113768066149037*G0_0_0_2_1 - 0.00151227960751792*G0_0_0_2_2 - 0.000719016433302274*G0_0_0_2_3 + 0.000684500684500816*G0_0_0_2_4 - 0.00985865985866156*G0_0_0_2_5 + 0.00434665863237368*G0_0_0_2_6 - 0.00420431420431491*G0_0_0_2_7 + 0.00112543541114989*G0_0_0_2_8 - 0.00225901083043978*G0_0_0_2_9 + 0.000419950419950539*G0_0_0_3_0 - 0.00570572284858096*G0_0_0_3_1 - 0.000719016433302274*G0_0_0_3_2 - 0.0346562960848733*G0_0_0_3_3 + 0.00541077969649489*G0_0_0_3_4 + 0.00363969363969426*G0_0_0_3_5 + 0.000251653108795998*G0_0_0_3_6 + 0.00513153513153602*G0_0_0_3_7 - 0.00814661528947381*G0_0_0_3_8 - 0.00678036249464936*G0_0_0_3_9 + 0.00108040108040126*G0_0_0_4_0 + 0.00280632066346399*G0_0_0_4_1 + 0.000684500684500816*G0_0_0_4_2 + 0.00541077969649489*G0_0_0_4_3 - 0.0159821131249729*G0_0_0_4_4 + 0.00315018315018369*G0_0_0_4_5 - 0.00340183625897969*G0_0_0_4_6 + 0.00149017649017674*G0_0_0_4_7 + 0.00301508015793781*G0_0_0_4_8 + 0.000476666190951987*G0_0_0_4_9 - 0.0882136382136533*G0_0_0_5_0 - 0.00497687497687581*G0_0_0_5_1 - 0.00985865985866156*G0_0_0_5_2 + 0.00363969363969426*G0_0_0_5_3 + 0.00315018315018369*G0_0_0_5_4 - 0.114235764235784*G0_0_0_5_5 + 0.0463636363636443*G0_0_0_5_6 - 0.0403263403263472*G0_0_0_5_7 + 0.0213220113220149*G0_0_0_5_8 - 0.0145554445554471*G0_0_0_5_9 + 0.0399332149332218*G0_0_0_6_0 + 0.00204657776086382*G0_0_0_6_1 + 0.00434665863237368*G0_0_0_6_2 + 0.000251653108795998*G0_0_0_6_3 - 0.00340183625897969*G0_0_0_6_4 + 0.0463636363636443*G0_0_0_6_5 - 0.0214385614385651*G0_0_0_6_6 + 0.0190043290043322*G0_0_0_6_7 - 0.0079537129537143*G0_0_0_6_8 + 0.00627372627372736*G0_0_0_6_9 - 0.0631294631294739*G0_0_0_7_0 - 0.00337384837384895*G0_0_0_7_1 - 0.00420431420431491*G0_0_0_7_2 + 0.00513153513153602*G0_0_0_7_3 + 0.00149017649017674*G0_0_0_7_4 - 0.0403263403263472*G0_0_0_7_5 + 0.0190043290043322*G0_0_0_7_6 - 0.0470695970696051*G0_0_0_7_7 + 0.0220512820512858*G0_0_0_7_8 - 0.00992007992008163*G0_0_0_7_9 + 0.0310569060569114*G0_0_0_8_0 + 0.000402296116581899*G0_0_0_8_1 + 0.00112543541114989*G0_0_0_8_2 - 0.00814661528947381*G0_0_0_8_3 + 0.00301508015793781*G0_0_0_8_4 + 0.0213220113220149*G0_0_0_8_5 - 0.0079537129537143*G0_0_0_8_6 + 0.0220512820512858*G0_0_0_8_7 - 0.0236729936729977*G0_0_0_8_8 - 0.00254745254745295*G0_0_0_8_9 - 0.00936285936286106*G0_0_0_9_0 - 0.00116090258947422*G0_0_0_9_1 - 0.00225901083043979*G0_0_0_9_2 - 0.00678036249464936*G0_0_0_9_3 + 0.000476666190951987*G0_0_0_9_4 - 0.0145554445554471*G0_0_0_9_5 + 0.00627372627372736*G0_0_0_9_6 - 0.00992007992008163*G0_0_0_9_7 - 0.00254745254745295*G0_0_0_9_8 - 0.0340459540459599*G0_0_0_9_9 - 0.185576152242851*G0_0_1_0_0 - 0.00744194077527539*G0_0_1_0_1 - 0.00887384220717705*G0_0_1_0_2 + 0.000419950419950539*G0_0_1_0_3 + 0.00108040108040126*G0_0_1_0_4 - 0.0882136382136533*G0_0_1_0_5 + 0.0399332149332218*G0_0_1_0_6 - 0.0631294631294738*G0_0_1_0_7 + 0.0310569060569114*G0_0_1_0_8 - 0.00936285936286106*G0_0_1_0_9 - 0.00744194077527539*G0_0_1_1_0 - 0.00852893138607569*G0_0_1_1_1 - 0.00113768066149038*G0_0_1_1_2 - 0.00570572284858095*G0_0_1_1_3 + 0.00280632066346399*G0_0_1_1_4 - 0.00497687497687581*G0_0_1_1_5 + 0.00204657776086382*G0_0_1_1_6 - 0.00337384837384895*G0_0_1_1_7 + 0.000402296116581903*G0_0_1_1_8 - 0.00116090258947422*G0_0_1_1_9 - 0.00887384220717705*G0_0_1_2_0 - 0.00113768066149038*G0_0_1_2_1 - 0.00151227960751794*G0_0_1_2_2 - 0.000719016433302268*G0_0_1_2_3 + 0.000684500684500806*G0_0_1_2_4 - 0.00985865985866155*G0_0_1_2_5 + 0.00434665863237367*G0_0_1_2_6 - 0.00420431420431491*G0_0_1_2_7 + 0.00112543541114989*G0_0_1_2_8 - 0.00225901083043979*G0_0_1_2_9 + 0.000419950419950539*G0_0_1_3_0 - 0.00570572284858095*G0_0_1_3_1 - 0.000719016433302268*G0_0_1_3_2 - 0.0346562960848733*G0_0_1_3_3 + 0.00541077969649489*G0_0_1_3_4 + 0.00363969363969426*G0_0_1_3_5 + 0.000251653108796002*G0_0_1_3_6 + 0.00513153513153602*G0_0_1_3_7 - 0.00814661528947381*G0_0_1_3_8 - 0.00678036249464936*G0_0_1_3_9 + 0.00108040108040126*G0_0_1_4_0 + 0.00280632066346399*G0_0_1_4_1 + 0.000684500684500806*G0_0_1_4_2 + 0.00541077969649489*G0_0_1_4_3 - 0.015982113124973*G0_0_1_4_4 + 0.00315018315018369*G0_0_1_4_5 - 0.0034018362589797*G0_0_1_4_6 + 0.00149017649017675*G0_0_1_4_7 + 0.0030150801579378*G0_0_1_4_8 + 0.000476666190951977*G0_0_1_4_9 - 0.0882136382136533*G0_0_1_5_0 - 0.00497687497687581*G0_0_1_5_1 - 0.00985865985866155*G0_0_1_5_2 + 0.00363969363969426*G0_0_1_5_3 + 0.0031501831501837*G0_0_1_5_4 - 0.114235764235784*G0_0_1_5_5 + 0.0463636363636443*G0_0_1_5_6 - 0.0403263403263472*G0_0_1_5_7 + 0.0213220113220149*G0_0_1_5_8 - 0.0145554445554471*G0_0_1_5_9 + 0.0399332149332218*G0_0_1_6_0 + 0.00204657776086382*G0_0_1_6_1 + 0.00434665863237367*G0_0_1_6_2 + 0.000251653108796002*G0_0_1_6_3 - 0.0034018362589797*G0_0_1_6_4 + 0.0463636363636443*G0_0_1_6_5 - 0.0214385614385651*G0_0_1_6_6 + 0.0190043290043322*G0_0_1_6_7 - 0.0079537129537143*G0_0_1_6_8 + 0.00627372627372735*G0_0_1_6_9 - 0.0631294631294738*G0_0_1_7_0 - 0.00337384837384895*G0_0_1_7_1 - 0.00420431420431491*G0_0_1_7_2 + 0.00513153513153602*G0_0_1_7_3 + 0.00149017649017675*G0_0_1_7_4 - 0.0403263403263471*G0_0_1_7_5 + 0.0190043290043322*G0_0_1_7_6 - 0.0470695970696051*G0_0_1_7_7 + 0.0220512820512858*G0_0_1_7_8 - 0.00992007992008164*G0_0_1_7_9 + 0.0310569060569114*G0_0_1_8_0 + 0.000402296116581903*G0_0_1_8_1 + 0.00112543541114989*G0_0_1_8_2 - 0.00814661528947381*G0_0_1_8_3 + 0.0030150801579378*G0_0_1_8_4 + 0.0213220113220149*G0_0_1_8_5 - 0.0079537129537143*G0_0_1_8_6 + 0.0220512820512858*G0_0_1_8_7 - 0.0236729936729977*G0_0_1_8_8 - 0.00254745254745294*G0_0_1_8_9 - 0.00936285936286105*G0_0_1_9_0 - 0.00116090258947422*G0_0_1_9_1 - 0.00225901083043979*G0_0_1_9_2 - 0.00678036249464936*G0_0_1_9_3 + 0.000476666190951978*G0_0_1_9_4 - 0.0145554445554471*G0_0_1_9_5 + 0.00627372627372735*G0_0_1_9_6 - 0.00992007992008164*G0_0_1_9_7 - 0.00254745254745294*G0_0_1_9_8 - 0.0340459540459599*G0_0_1_9_9 + 0.041747458890323*G0_1_0_0_0 + 0.00336187621901964*G0_1_0_0_1 - 0.00887384220717708*G0_1_0_0_2 + 0.00207496207496241*G0_1_0_0_3 - 0.0101317201317219*G0_1_0_0_4 + 0.0310126910126962*G0_1_0_0_5 - 0.0261135161135205*G0_1_0_0_6 + 0.0506890992605364*G0_1_0_0_7 - 0.0210916596630918*G0_1_0_0_8 + 0.00479298479298562*G0_1_0_0_9 + 0.00336187621901964*G0_1_0_1_0 - 0.0085289313860757*G0_1_0_1_1 - 0.0119414976557854*G0_1_0_1_2 - 0.000297956012241781*G0_1_0_1_3 - 0.0110918446632751*G0_1_0_1_4 + 0.00789025789025922*G0_1_0_1_5 - 0.0108205551062712*G0_1_0_1_6 + 0.0105243169528902*G0_1_0_1_7 - 0.00500547071975729*G0_1_0_1_8 - 0.00116090258947422*G0_1_0_1_9 - 0.00887384220717708*G0_1_0_2_0 - 0.0119414976557854*G0_1_0_2_1 - 0.228835890740691*G0_1_0_2_2 + 0.0514295492867007*G0_1_0_2_3 - 0.113134061705509*G0_1_0_2_4 + 0.0561880711880806*G0_1_0_2_5 - 0.114879670593976*G0_1_0_2_6 + 0.00700780700780817*G0_1_0_2_7 - 0.000529576243862064*G0_1_0_2_8 - 0.0164148549862863*G0_1_0_2_9 + 0.00207496207496241*G0_1_0_3_0 - 0.00029795601224178*G0_1_0_3_1 + 0.0514295492867007*G0_1_0_3_2 - 0.0624113981256944*G0_1_0_3_3 + 0.0676114361828761*G0_1_0_3_4 - 0.0181435231435262*G0_1_0_3_5 + 0.0388530517102011*G0_1_0_3_6 + 0.000166500166500181*G0_1_0_3_7 - 0.00814661528947379*G0_1_0_3_8 + 0.00314970743542221*G0_1_0_3_9 - 0.0101317201317219*G0_1_0_4_0 - 0.0110918446632751*G0_1_0_4_1 - 0.113134061705509*G0_1_0_4_2 + 0.0676114361828761*G0_1_0_4_3 - 0.164506445935045*G0_1_0_4_4 + 0.036786546786553*G0_1_0_4_5 - 0.0756395984967541*G0_1_0_4_6 + 0.00149017649017674*G0_1_0_4_7 + 0.0079801151229736*G0_1_0_4_8 - 0.024328528614247*G0_1_0_4_9 + 0.0310126910126962*G0_1_0_5_0 + 0.00789025789025922*G0_1_0_5_1 + 0.0561880711880806*G0_1_0_5_2 - 0.0181435231435262*G0_1_0_5_3 + 0.036786546786553*G0_1_0_5_4 + 0.00653346653346755*G0_1_0_5_5 + 0.0463636363636442*G0_1_0_5_6 + 0.0319114219114272*G0_1_0_5_7 - 0.0172793872793902*G0_1_0_5_8 + 0.0201798201798236*G0_1_0_5_9 - 0.0261135161135205*G0_1_0_6_0 - 0.0108205551062712*G0_1_0_6_1 - 0.114879670593976*G0_1_0_6_2 + 0.0388530517102011*G0_1_0_6_3 - 0.0756395984967541*G0_1_0_6_4 + 0.0463636363636442*G0_1_0_6_5 - 0.142207792207816*G0_1_0_6_6 - 0.0146320346320371*G0_1_0_6_7 + 0.0138295038295061*G0_1_0_6_8 - 0.0284615384615432*G0_1_0_6_9 + 0.0506890992605364*G0_1_0_7_0 + 0.0105243169528902*G0_1_0_7_1 + 0.00700780700780817*G0_1_0_7_2 + 0.000166500166500181*G0_1_0_7_3 + 0.00149017649017674*G0_1_0_7_4 + 0.0319114219114272*G0_1_0_7_5 - 0.0146320346320371*G0_1_0_7_6 + 0.101454735740467*G0_1_0_7_7 - 0.0401493744350955*G0_1_0_7_8 + 0.0148851148851174*G0_1_0_7_9 - 0.0210916596630918*G0_1_0_8_0 - 0.00500547071975729*G0_1_0_8_1 - 0.000529576243862064*G0_1_0_8_2 - 0.0081466152894738*G0_1_0_8_3 + 0.0079801151229736*G0_1_0_8_4 - 0.0172793872793902*G0_1_0_8_5 + 0.0138295038295061*G0_1_0_8_6 - 0.0401493744350955*G0_1_0_8_7 + 0.0040821083678233*G0_1_0_8_8 - 0.0124775224775246*G0_1_0_8_9 + 0.00479298479298561*G0_1_0_9_0 - 0.00116090258947422*G0_1_0_9_1 - 0.0164148549862863*G0_1_0_9_2 + 0.00314970743542221*G0_1_0_9_3 - 0.024328528614247*G0_1_0_9_4 + 0.0201798201798236*G0_1_0_9_5 - 0.0284615384615432*G0_1_0_9_6 + 0.0148851148851174*G0_1_0_9_7 - 0.0124775224775246*G0_1_0_9_8 - 0.0340459540459598*G0_1_0_9_9 + 0.043259738497841*G0_1_1_0_0 + 0.00449955688051003*G0_1_1_0_1 + 0.000949526663812528*G0_1_1_0_3 - 0.00592740592740695*G0_1_1_0_4 + 0.0266660323803226*G0_1_1_0_5 - 0.016254856254859*G0_1_1_0_6 + 0.0500045985760355*G0_1_1_0_7 - 0.0203726432297895*G0_1_1_0_8 + 0.00705199562342541*G0_1_1_0_9 + 0.00449955688051003*G0_1_1_1_0 - 0.00449955688051002*G0_1_1_1_2 - 0.000700252128823649*G0_1_1_1_3 - 0.00771799628942619*G0_1_1_1_4 + 0.00584368012939539*G0_1_1_1_5 - 0.0058436801293954*G0_1_1_1_6 + 0.00771799628942615*G0_1_1_1_7 + 0.000700252128823728*G0_1_1_1_8 - 0.00449955688051002*G0_1_1_2_1 - 0.0432597384978409*G0_1_1_2_2 + 0.0203726432297895*G0_1_1_2_3 - 0.0500045985760356*G0_1_1_2_4 + 0.016254856254859*G0_1_1_2_5 - 0.0266660323803226*G0_1_1_2_6 + 0.00592740592740691*G0_1_1_2_7 - 0.000949526663812536*G0_1_1_2_8 - 0.00705199562342538*G0_1_1_2_9 + 0.000949526663812528*G0_1_1_3_0 - 0.000700252128823649*G0_1_1_3_1 + 0.0203726432297895*G0_1_1_3_2 - 0.0387384044526967*G0_1_1_3_3 + 0.0455601541315904*G0_1_1_3_4 - 0.0101898101898119*G0_1_1_3_5 + 0.0175310403881862*G0_1_1_3_6 - 0.00284857999143764*G0_1_1_3_7 + 0.0056971599828752*G0_1_1_3_9 - 0.00592740592740695*G0_1_1_4_0 - 0.00771799628942619*G0_1_1_4_1 - 0.0500045985760356*G0_1_1_4_2 + 0.0455601541315904*G0_1_1_4_3 - 0.11743684886544*G0_1_1_4_4 + 0.0177822177822208*G0_1_1_4_5 - 0.035313258170407*G0_1_1_4_6 + 0.0028485799914376*G0_1_1_4_8 - 0.0144084486941654*G0_1_1_4_9 + 0.0266660323803226*G0_1_1_5_0 + 0.00584368012939539*G0_1_1_5_1 + 0.016254856254859*G0_1_1_5_2 - 0.0101898101898119*G0_1_1_5_3 + 0.0177822177822208*G0_1_1_5_4 + 0.0279720279720325*G0_1_1_5_5 + 0.0353132581704069*G0_1_1_5_7 - 0.0175310403881862*G0_1_1_5_8 + 0.0139060939060962*G0_1_1_5_9 - 0.016254856254859*G0_1_1_6_0 - 0.0058436801293954*G0_1_1_6_1 - 0.0266660323803226*G0_1_1_6_2 + 0.0175310403881862*G0_1_1_6_3 - 0.035313258170407*G0_1_1_6_4 - 0.0279720279720327*G0_1_1_6_6 - 0.0177822177822207*G0_1_1_6_7 + 0.0101898101898119*G0_1_1_6_8 - 0.0139060939060962*G0_1_1_6_9 + 0.0500045985760355*G0_1_1_7_0 + 0.00771799628942615*G0_1_1_7_1 + 0.00592740592740691*G0_1_1_7_2 - 0.00284857999143764*G0_1_1_7_3 + 0.0353132581704069*G0_1_1_7_5 - 0.0177822177822207*G0_1_1_7_6 + 0.11743684886544*G0_1_1_7_7 - 0.0455601541315904*G0_1_1_7_8 + 0.0144084486941654*G0_1_1_7_9 - 0.0203726432297895*G0_1_1_8_0 + 0.000700252128823729*G0_1_1_8_1 - 0.000949526663812536*G0_1_1_8_2 + 0.0028485799914376*G0_1_1_8_4 - 0.0175310403881862*G0_1_1_8_5 + 0.0101898101898119*G0_1_1_8_6 - 0.0455601541315904*G0_1_1_8_7 + 0.0387384044526968*G0_1_1_8_8 - 0.00569715998287523*G0_1_1_8_9 + 0.00705199562342541*G0_1_1_9_0 - 0.00705199562342538*G0_1_1_9_2 + 0.0056971599828752*G0_1_1_9_3 - 0.0144084486941654*G0_1_1_9_4 + 0.0139060939060962*G0_1_1_9_5 - 0.0139060939060962*G0_1_1_9_6 + 0.0144084486941654*G0_1_1_9_7 - 0.00569715998287523*G0_1_1_9_8;
    A[157] = -0.0185429385429419*G0_0_0_0_0 - 0.000773195058909485*G0_0_0_0_1 - 0.00185837971552291*G0_0_0_0_2 + 0.000400076114361905*G0_0_0_0_3 + 0.000412206840778337*G0_0_0_0_4 - 0.0225857475857515*G0_0_0_0_5 + 0.00657152371438202*G0_0_0_0_6 - 0.00452380952381033*G0_0_0_0_7 + 0.00193615907901658*G0_0_0_0_8 - 0.00192093620665082*G0_0_0_0_9 - 0.000773195058909485*G0_0_0_1_0 - 0.00266252266252333*G0_0_0_1_1 - 0.00016393659250806*G0_0_0_1_2 - 0.0027108605680039*G0_0_0_1_3 - 0.000933352361923944*G0_0_0_1_4 + 0.00108225108225126*G0_0_0_1_5 - 0.00137315065886519*G0_0_0_1_6 + 0.00292564578278915*G0_0_0_1_7 - 0.000695732838590118*G0_0_0_1_8 - 0.00133295276152442*G0_0_0_1_9 - 0.00185837971552291*G0_0_0_2_0 - 0.00016393659250806*G0_0_0_2_1 - 0.00124912124912165*G0_0_0_2_2 - 0.000643166357452137*G0_0_0_2_3 - 0.00330336330336394*G0_0_0_2_4 - 0.00261452832881446*G0_0_0_2_5 - 0.0017582417582421*G0_0_0_2_6 + 0.00386732315303809*G0_0_0_2_7 - 0.00193972693972726*G0_0_0_2_8 + 0.0023519337805056*G0_0_0_2_9 + 0.000400076114361905*G0_0_0_3_0 - 0.0027108605680039*G0_0_0_3_1 - 0.000643166357452137*G0_0_0_3_2 + 0.000916226630512692*G0_0_0_3_3 + 0.0129834451263045*G0_0_0_3_4 - 0.00244897959183714*G0_0_0_3_5 + 0.00457042957043038*G0_0_0_3_6 - 0.000749250749250897*G0_0_0_3_7 - 0.0055209076637657*G0_0_0_3_8 + 0.00549735978307504*G0_0_0_3_9 + 0.000412206840778337*G0_0_0_4_0 - 0.000933352361923943*G0_0_0_4_1 - 0.00330336330336394*G0_0_0_4_2 + 0.0129834451263045*G0_0_0_4_3 - 0.00253888968174736*G0_0_0_4_4 - 0.000785642928500189*G0_0_0_4_5 - 0.00378478664193019*G0_0_0_4_6 - 0.00664478378764205*G0_0_0_4_7 + 0.0062701584130166*G0_0_0_4_8 - 0.00548451548451641*G0_0_0_4_9 - 0.0225857475857515*G0_0_0_5_0 + 0.00108225108225126*G0_0_0_5_1 - 0.00261452832881446*G0_0_0_5_2 - 0.00244897959183714*G0_0_0_5_3 - 0.000785642928500189*G0_0_0_5_4 + 0.0141201655487392*G0_0_0_5_5 + 0.0255323248180434*G0_0_0_5_6 + 0.0139467675181984*G0_0_0_5_7 - 0.00279577565291896*G0_0_0_5_8 + 0.0113543599257904*G0_0_0_5_9 + 0.00657152371438202*G0_0_0_6_0 - 0.00137315065886519*G0_0_0_6_1 - 0.0017582417582421*G0_0_0_6_2 + 0.00457042957043038*G0_0_0_6_3 - 0.00378478664193019*G0_0_0_6_4 + 0.0255323248180434*G0_0_0_6_5 + 0.00843014128728536*G0_0_0_6_6 - 0.0111509918652794*G0_0_0_6_7 + 0.00474382760097126*G0_0_0_6_8 - 0.0161966604823775*G0_0_0_6_9 - 0.00452380952381033*G0_0_0_7_0 + 0.00292564578278915*G0_0_0_7_1 + 0.00386732315303809*G0_0_0_7_2 - 0.000749250749250897*G0_0_0_7_3 - 0.00664478378764205*G0_0_0_7_4 + 0.0139467675181984*G0_0_0_7_5 - 0.0111509918652794*G0_0_0_7_6 + 0.0567075781361591*G0_0_0_7_7 - 0.00919651776794794*G0_0_0_7_8 + 0.0280647923505113*G0_0_0_7_9 + 0.00193615907901658*G0_0_0_8_0 - 0.000695732838590118*G0_0_0_8_1 - 0.00193972693972726*G0_0_0_8_2 - 0.0055209076637657*G0_0_0_8_3 + 0.0062701584130166*G0_0_0_8_4 - 0.00279577565291896*G0_0_0_8_5 + 0.00474382760097126*G0_0_0_8_6 - 0.00919651776794794*G0_0_0_8_7 - 0.0128314542600276*G0_0_0_8_8 - 0.00854145854145995*G0_0_0_8_9 - 0.00192093620665082*G0_0_0_9_0 - 0.00133295276152442*G0_0_0_9_1 + 0.0023519337805056*G0_0_0_9_2 + 0.00549735978307504*G0_0_0_9_3 - 0.00548451548451642*G0_0_0_9_4 + 0.0113543599257904*G0_0_0_9_5 - 0.0161966604823775*G0_0_0_9_6 + 0.0280647923505113*G0_0_0_9_7 - 0.00854145854145994*G0_0_0_9_8 - 0.0117140002854308*G0_0_0_9_9 + 0.121480001480023*G0_0_1_0_0 + 0.00115664758521923*G0_0_1_0_1 + 0.0011566475852192*G0_0_1_0_2 + 0.000988059559488265*G0_0_1_0_3 + 0.0009880595594883*G0_0_1_0_4 + 0.00539294039294133*G0_0_1_0_5 - 0.00647875933590331*G0_0_1_0_6 + 0.00539294039294146*G0_0_1_0_7 - 0.00647875933590336*G0_0_1_0_8 - 0.00719566148137691*G0_0_1_0_9 + 0.00115664758521923*G0_0_1_1_0 - 0.00171606171606225*G0_0_1_1_1 - 0.000215340215340265*G0_0_1_1_2 - 0.0033404690547554*G0_0_1_1_3 - 0.000668141382427184*G0_0_1_1_4 - 0.00104704818990548*G0_0_1_1_5 - 0.00131321059892512*G0_0_1_1_6 - 0.00349293563579331*G0_0_1_1_7 - 0.000312544598258987*G0_0_1_1_8 + 0.00267589553303883*G0_0_1_1_9 + 0.0011566475852192*G0_0_1_2_0 - 0.000215340215340265*G0_0_1_2_1 - 0.00171606171606217*G0_0_1_2_2 - 0.000668141382427174*G0_0_1_2_3 - 0.00334046905475541*G0_0_1_2_4 - 0.00349293563579336*G0_0_1_2_5 - 0.000312544598258976*G0_0_1_2_6 - 0.00104704818990549*G0_0_1_2_7 - 0.0013132105989251*G0_0_1_2_8 + 0.00267589553303884*G0_0_1_2_9 + 0.000988059559488265*G0_0_1_3_0 - 0.0033404690547554*G0_0_1_3_1 - 0.000668141382427173*G0_0_1_3_2 + 2.35478806908133e-05*G0_0_1_3_3 + 0.011988011988014*G0_0_1_3_4 - 0.000372484658199072*G0_0_1_3_5 + 0.00486156700442499*G0_0_1_3_6 - 0.00204224347081523*G0_0_1_3_7 - 0.00281932353360966*G0_0_1_3_8 - 0.00394319965748597*G0_0_1_3_9 + 0.0009880595594883*G0_0_1_4_0 - 0.000668141382427184*G0_0_1_4_1 - 0.00334046905475541*G0_0_1_4_2 + 0.011988011988014*G0_0_1_4_3 + 2.35478806906484e-05*G0_0_1_4_4 - 0.00204224347081522*G0_0_1_4_5 - 0.00281932353360974*G0_0_1_4_6 - 0.000372484658199027*G0_0_1_4_7 + 0.00486156700442493*G0_0_1_4_8 - 0.00394319965748606*G0_0_1_4_9 + 0.00539294039294133*G0_0_1_5_0 - 0.00104704818990548*G0_0_1_5_1 - 0.00349293563579337*G0_0_1_5_2 - 0.000372484658199071*G0_0_1_5_3 - 0.00204224347081522*G0_0_1_5_4 - 0.192688026259487*G0_0_1_5_5 + 0.026756814613962*G0_0_1_5_6 - 0.00812615955473221*G0_0_1_5_7 + 0.00406307977736613*G0_0_1_5_8 + 0.0134608248893986*G0_0_1_5_9 - 0.00647875933590331*G0_0_1_6_0 - 0.00131321059892512*G0_0_1_6_1 - 0.000312544598258976*G0_0_1_6_2 + 0.00486156700442499*G0_0_1_6_3 - 0.00281932353360974*G0_0_1_6_4 + 0.026756814613962*G0_0_1_6_5 - 0.0106586270872004*G0_0_1_6_6 + 0.00406307977736611*G0_0_1_6_7 + 0.0034786641929505*G0_0_1_6_8 - 0.0177508206079665*G0_0_1_6_9 + 0.00539294039294146*G0_0_1_7_0 - 0.00349293563579332*G0_0_1_7_1 - 0.00104704818990549*G0_0_1_7_2 - 0.00204224347081523*G0_0_1_7_3 - 0.000372484658199027*G0_0_1_7_4 - 0.00812615955473222*G0_0_1_7_5 + 0.00406307977736611*G0_0_1_7_6 - 0.192688026259487*G0_0_1_7_7 + 0.0267568146139618*G0_0_1_7_8 + 0.0134608248893986*G0_0_1_7_9 - 0.00647875933590336*G0_0_1_8_0 - 0.000312544598258986*G0_0_1_8_1 - 0.0013132105989251*G0_0_1_8_2 - 0.00281932353360966*G0_0_1_8_3 + 0.00486156700442493*G0_0_1_8_4 + 0.00406307977736613*G0_0_1_8_5 + 0.0034786641929505*G0_0_1_8_6 + 0.0267568146139618*G0_0_1_8_7 - 0.0106586270871999*G0_0_1_8_8 - 0.0177508206079664*G0_0_1_8_9 - 0.00719566148137691*G0_0_1_9_0 + 0.00267589553303883*G0_0_1_9_1 + 0.00267589553303884*G0_0_1_9_2 - 0.00394319965748597*G0_0_1_9_3 - 0.00394319965748606*G0_0_1_9_4 + 0.0134608248893986*G0_0_1_9_5 - 0.0177508206079665*G0_0_1_9_6 + 0.0134608248893986*G0_0_1_9_7 - 0.0177508206079664*G0_0_1_9_8 + 0.079608962466119*G0_0_1_9_9 + 0.00246938246938288*G0_1_0_0_0 + 0.000236641665213126*G0_1_0_0_1 + 0.00023664166521313*G0_1_0_0_2 - 0.000149136577708023*G0_1_0_0_3 - 0.000149136577708032*G0_1_0_0_4 + 0.00555944055944149*G0_1_0_0_5 - 0.00172684458398773*G0_1_0_0_6 + 0.0055594405594415*G0_1_0_0_7 - 0.00172684458398773*G0_1_0_0_8 + 0.00431283002711647*G0_1_0_0_9 + 0.000236641665213126*G0_1_0_1_0 - 0.00312946312946391*G0_1_0_1_1 + 4.18364704079028e-05*G0_1_0_1_2 - 0.00273060273060322*G0_1_0_1_3 - 0.00112078397792701*G0_1_0_1_4 + 0.000240473811902417*G0_1_0_1_5 - 0.00307121449978647*G0_1_0_1_6 + 0.00234241948527705*G0_1_0_1_7 + 0.000732600732600805*G0_1_0_1_8 - 0.00114171542742993*G0_1_0_1_9 + 0.00023664166521313*G0_1_0_2_0 + 4.18364704079028e-05*G0_1_0_2_1 - 0.00312946312946367*G0_1_0_2_2 - 0.00112078397792702*G0_1_0_2_3 - 0.00273060273060318*G0_1_0_2_4 + 0.00234241948527703*G0_1_0_2_5 + 0.000732600732600865*G0_1_0_2_6 + 0.000240473811902422*G0_1_0_2_7 - 0.00307121449978644*G0_1_0_2_8 - 0.00114171542742989*G0_1_0_2_9 - 0.000149136577708023*G0_1_0_3_0 - 0.00273060273060322*G0_1_0_3_1 - 0.00112078397792702*G0_1_0_3_2 + 0.00151776794633988*G0_1_0_3_3 + 0.0143492222063674*G0_1_0_3_4 + 0.000370343941772574*G0_1_0_3_5 + 0.00819894391323106*G0_1_0_3_6 - 0.000567289853004249*G0_1_0_3_7 - 0.00763165406022675*G0_1_0_3_8 + 0.00455972598829827*G0_1_0_3_9 - 0.000149136577708032*G0_1_0_4_0 - 0.00112078397792701*G0_1_0_4_1 - 0.00273060273060318*G0_1_0_4_2 + 0.0143492222063674*G0_1_0_4_3 + 0.00151776794633967*G0_1_0_4_4 - 0.00056728985300423*G0_1_0_4_5 - 0.00763165406022683*G0_1_0_4_6 + 0.000370343941772577*G0_1_0_4_7 + 0.008198943913231*G0_1_0_4_8 + 0.00455972598829816*G0_1_0_4_9 + 0.00555944055944149*G0_1_0_5_0 + 0.000240473811902417*G0_1_0_5_1 + 0.00234241948527703*G0_1_0_5_2 + 0.000370343941772574*G0_1_0_5_3 - 0.00056728985300423*G0_1_0_5_4 - 0.00393677750820691*G0_1_0_5_5 - 0.00805337519623372*G0_1_0_5_6 + 0.00347224204367117*G0_1_0_5_7 - 0.00173612102183558*G0_1_0_5_8 - 0.00946624803767825*G0_1_0_5_9 - 0.00172684458398773*G0_1_0_6_0 - 0.00307121449978647*G0_1_0_6_1 + 0.000732600732600865*G0_1_0_6_2 + 0.00819894391323106*G0_1_0_6_3 - 0.00763165406022683*G0_1_0_6_4 - 0.00805337519623372*G0_1_0_6_5 - 0.0238069073783405*G0_1_0_6_6 - 0.0017361210218356*G0_1_0_6_7 + 0.00972099329242352*G0_1_0_6_8 - 0.0129727415441725*G0_1_0_6_9 + 0.0055594405594415*G0_1_0_7_0 + 0.00234241948527705*G0_1_0_7_1 + 0.000240473811902422*G0_1_0_7_2 - 0.000567289853004249*G0_1_0_7_3 + 0.000370343941772577*G0_1_0_7_4 + 0.00347224204367117*G0_1_0_7_5 - 0.0017361210218356*G0_1_0_7_6 - 0.00393677750820676*G0_1_0_7_7 - 0.00805337519623373*G0_1_0_7_8 - 0.00946624803767824*G0_1_0_7_9 - 0.00172684458398773*G0_1_0_8_0 + 0.000732600732600805*G0_1_0_8_1 - 0.00307121449978644*G0_1_0_8_2 - 0.00763165406022675*G0_1_0_8_3 + 0.008198943913231*G0_1_0_8_4 - 0.00173612102183558*G0_1_0_8_5 + 0.00972099329242352*G0_1_0_8_6 - 0.00805337519623373*G0_1_0_8_7 - 0.0238069073783397*G0_1_0_8_8 - 0.0129727415441722*G0_1_0_8_9 + 0.00431283002711647*G0_1_0_9_0 - 0.00114171542742993*G0_1_0_9_1 - 0.00114171542742989*G0_1_0_9_2 + 0.00455972598829827*G0_1_0_9_3 + 0.00455972598829816*G0_1_0_9_4 - 0.00946624803767825*G0_1_0_9_5 - 0.0129727415441725*G0_1_0_9_6 - 0.00946624803767824*G0_1_0_9_7 - 0.0129727415441722*G0_1_0_9_8 - 0.0410760667903596*G0_1_0_9_9 - 0.0185429385429415*G0_1_1_0_0 - 0.00185837971552289*G0_1_1_0_1 - 0.000773195058909467*G0_1_1_0_2 + 0.000412206840778354*G0_1_1_0_3 + 0.000400076114361889*G0_1_1_0_4 - 0.00452380952381021*G0_1_1_0_5 + 0.0019361590790165*G0_1_1_0_6 - 0.0225857475857513*G0_1_1_0_7 + 0.00657152371438192*G0_1_1_0_8 - 0.00192093620665082*G0_1_1_0_9 - 0.00185837971552289*G0_1_1_1_0 - 0.00124912124912174*G0_1_1_1_1 - 0.000163936592508057*G0_1_1_1_2 - 0.00330336330336394*G0_1_1_1_3 - 0.000643166357452142*G0_1_1_1_4 + 0.00386732315303811*G0_1_1_1_5 - 0.00193972693972728*G0_1_1_1_6 - 0.00261452832881443*G0_1_1_1_7 - 0.00175824175824213*G0_1_1_1_8 + 0.00235193378050558*G0_1_1_1_9 - 0.000773195058909467*G0_1_1_2_0 - 0.000163936592508057*G0_1_1_2_1 - 0.00266252266252312*G0_1_1_2_2 - 0.000933352361923945*G0_1_1_2_3 - 0.00271086056800388*G0_1_1_2_4 + 0.00292564578278915*G0_1_1_2_5 - 0.000695732838590117*G0_1_1_2_6 + 0.00108225108225128*G0_1_1_2_7 - 0.00137315065886517*G0_1_1_2_8 - 0.00133295276152439*G0_1_1_2_9 + 0.000412206840778354*G0_1_1_3_0 - 0.00330336330336394*G0_1_1_3_1 - 0.000933352361923945*G0_1_1_3_2 - 0.00253888968174718*G0_1_1_3_3 + 0.0129834451263044*G0_1_1_3_4 - 0.00664478378764206*G0_1_1_3_5 + 0.00627015841301665*G0_1_1_3_6 - 0.000785642928500213*G0_1_1_3_7 - 0.0037847866419301*G0_1_1_3_8 - 0.00548451548451632*G0_1_1_3_9 + 0.000400076114361889*G0_1_1_4_0 - 0.000643166357452142*G0_1_1_4_1 - 0.00271086056800388*G0_1_1_4_2 + 0.0129834451263044*G0_1_1_4_3 + 0.000916226630512507*G0_1_1_4_4 - 0.000749250749250871*G0_1_1_4_5 - 0.00552090766376579*G0_1_1_4_6 - 0.00244897959183716*G0_1_1_4_7 + 0.00457042957043031*G0_1_1_4_8 + 0.00549735978307492*G0_1_1_4_9 - 0.00452380952381021*G0_1_1_5_0 + 0.0038673231530381*G0_1_1_5_1 + 0.00292564578278915*G0_1_1_5_2 - 0.00664478378764206*G0_1_1_5_3 - 0.000749250749250872*G0_1_1_5_4 + 0.0567075781361593*G0_1_1_5_5 - 0.00919651776794787*G0_1_1_5_6 + 0.0139467675181985*G0_1_1_5_7 - 0.0111509918652795*G0_1_1_5_8 + 0.0280647923505115*G0_1_1_5_9 + 0.0019361590790165*G0_1_1_6_0 - 0.00193972693972728*G0_1_1_6_1 - 0.000695732838590117*G0_1_1_6_2 + 0.00627015841301665*G0_1_1_6_3 - 0.00552090766376579*G0_1_1_6_4 - 0.00919651776794787*G0_1_1_6_5 - 0.0128314542600282*G0_1_1_6_6 - 0.00279577565291901*G0_1_1_6_7 + 0.00474382760097128*G0_1_1_6_8 - 0.00854145854146012*G0_1_1_6_9 - 0.0225857475857513*G0_1_1_7_0 - 0.00261452832881443*G0_1_1_7_1 + 0.00108225108225128*G0_1_1_7_2 - 0.000785642928500212*G0_1_1_7_3 - 0.00244897959183716*G0_1_1_7_4 + 0.0139467675181985*G0_1_1_7_5 - 0.00279577565291901*G0_1_1_7_6 + 0.0141201655487397*G0_1_1_7_7 + 0.0255323248180433*G0_1_1_7_8 + 0.0113543599257905*G0_1_1_7_9 + 0.00657152371438192*G0_1_1_8_0 - 0.00175824175824213*G0_1_1_8_1 - 0.00137315065886517*G0_1_1_8_2 - 0.0037847866419301*G0_1_1_8_3 + 0.00457042957043031*G0_1_1_8_4 - 0.0111509918652795*G0_1_1_8_5 + 0.00474382760097128*G0_1_1_8_6 + 0.0255323248180433*G0_1_1_8_7 + 0.00843014128728594*G0_1_1_8_8 - 0.0161966604823774*G0_1_1_8_9 - 0.00192093620665082*G0_1_1_9_0 + 0.00235193378050558*G0_1_1_9_1 - 0.00133295276152439*G0_1_1_9_2 - 0.00548451548451632*G0_1_1_9_3 + 0.00549735978307492*G0_1_1_9_4 + 0.0280647923505115*G0_1_1_9_5 - 0.00854145854146012*G0_1_1_9_6 + 0.0113543599257905*G0_1_1_9_7 - 0.0161966604823774*G0_1_1_9_8 - 0.0117140002854306*G0_1_1_9_9;
    A[211] = -A[181] - 0.00662871520014488*G0_0_0_0_0 + 0.00135469468802827*G0_0_0_0_1 - 0.00156193013335897*G0_0_0_0_2 + 0.00424591281734213*G0_0_0_0_3 - 0.00317999460856658*G0_0_0_0_4 - 0.00683538683538802*G0_0_0_0_5 + 0.00315938030223796*G0_0_0_0_6 - 0.00254697683269156*G0_0_0_0_7 + 0.00295133437990632*G0_0_0_0_8 + 0.000563246277532078*G0_0_0_0_9 + 0.00135469468802827*G0_0_0_1_0 + 0.0332013665347058*G0_0_0_1_1 + 0.00295334295334346*G0_0_0_1_2 + 0.0359529359529421*G0_0_0_1_3 - 0.0170140970140999*G0_0_0_1_4 - 0.00247308247308289*G0_0_0_1_5 - 0.00346542346542406*G0_0_0_1_6 - 0.00751248751248885*G0_0_0_1_7 + 0.0140193140193165*G0_0_0_1_8 - 0.00109224109224124*G0_0_0_1_9 - 0.00156193013335897*G0_0_0_2_0 + 0.00295334295334346*G0_0_0_2_1 - 0.00452880452880526*G0_0_0_2_2 + 0.00741353884211152*G0_0_0_2_3 - 0.00547642833357211*G0_0_0_2_4 + 0.0029786086928949*G0_0_0_2_5 - 0.00548150262436069*G0_0_0_2_6 - 0.00149406149406175*G0_0_0_2_7 + 0.0028672914387205*G0_0_0_2_8 + 0.00294562580276916*G0_0_0_2_9 + 0.00424591281734213*G0_0_0_3_0 + 0.0359529359529421*G0_0_0_3_1 + 0.00741353884211152*G0_0_0_3_2 + 0.0798401598401735*G0_0_0_3_3 - 0.0197202797202831*G0_0_0_3_4 - 0.00205508776937386*G0_0_0_3_5 + 0.00918795490224212*G0_0_0_3_6 - 0.0139460539460563*G0_0_0_3_7 + 0.0237562437562479*G0_0_0_3_8 + 0.0311688311688365*G0_0_0_3_9 - 0.00317999460856658*G0_0_0_4_0 - 0.0170140970140999*G0_0_0_4_1 - 0.00547642833357211*G0_0_0_4_2 - 0.0197202797202831*G0_0_0_4_3 - 0.0191979449122337*G0_0_0_4_4 + 0.00833166833166973*G0_0_0_4_5 - 0.0175196232339119*G0_0_0_4_6 + 0.00761524190095748*G0_0_0_4_7 - 0.0098101898101915*G0_0_0_4_8 - 0.0255002140716469*G0_0_0_4_9 - 0.00683538683538802*G0_0_0_5_0 - 0.00247308247308289*G0_0_0_5_1 + 0.0029786086928949*G0_0_0_5_2 - 0.00205508776937386*G0_0_0_5_3 + 0.00833166833166973*G0_0_0_5_4 - 0.12192379049524*G0_0_0_5_5 + 0.00776081061795477*G0_0_0_5_6 - 0.0094848009133739*G0_0_0_5_7 + 0.00621093192521866*G0_0_0_5_8 - 0.0141116026830336*G0_0_0_5_9 + 0.00315938030223796*G0_0_0_6_0 - 0.00346542346542406*G0_0_0_6_1 - 0.00548150262436069*G0_0_0_6_2 + 0.00918795490224212*G0_0_0_6_3 - 0.0175196232339119*G0_0_0_6_4 + 0.00776081061795477*G0_0_0_6_5 - 0.120468103325266*G0_0_0_6_6 + 0.00327386898815523*G0_0_0_6_7 + 0.0015013557870703*G0_0_0_6_8 - 0.0272127872127917*G0_0_0_6_9 - 0.00254697683269156*G0_0_0_7_0 - 0.00751248751248885*G0_0_0_7_1 - 0.00149406149406175*G0_0_0_7_2 - 0.0139460539460563*G0_0_0_7_3 + 0.00761524190095748*G0_0_0_7_4 - 0.0094848009133739*G0_0_0_7_5 + 0.00327386898815524*G0_0_0_7_6 + 0.00230055658627129*G0_0_0_7_7 - 0.00679320679320798*G0_0_0_7_8 - 0.00823747680890676*G0_0_0_7_9 + 0.00295133437990632*G0_0_0_8_0 + 0.0140193140193165*G0_0_0_8_1 + 0.0028672914387205*G0_0_0_8_2 + 0.0237562437562478*G0_0_0_8_3 - 0.0098101898101915*G0_0_0_8_4 + 0.00621093192521866*G0_0_0_8_5 + 0.0015013557870703*G0_0_0_8_6 - 0.00679320679320798*G0_0_0_8_7 + 0.0208991008991046*G0_0_0_8_8 + 0.0228971028971068*G0_0_0_8_9 + 0.000563246277532077*G0_0_0_9_0 - 0.00109224109224124*G0_0_0_9_1 + 0.00294562580276916*G0_0_0_9_2 + 0.0311688311688365*G0_0_0_9_3 - 0.0255002140716469*G0_0_0_9_4 - 0.0141116026830336*G0_0_0_9_5 - 0.0272127872127917*G0_0_0_9_6 - 0.00823747680890676*G0_0_0_9_7 + 0.0228971028971068*G0_0_0_9_8 - 0.0139745968317419*G0_0_0_9_9 - 0.00209991067133959*G0_1_0_0_0 - 0.00159864826531521*G0_1_0_0_1 + 0.00137862137862162*G0_1_0_0_3 - 0.00168593311450483*G0_1_0_0_4 - 0.00135388421102729*G0_1_0_0_5 + 0.000180771609343063*G0_1_0_0_6 + 0.00292945150088056*G0_1_0_0_7 - 0.00446220446220522*G0_1_0_0_8 - 0.00238237952523707*G0_1_0_0_9 - 0.00159864826531521*G0_1_0_1_0 + 0.0015986482653152*G0_1_0_1_2 + 0.0219336219336257*G0_1_0_1_3 - 0.00950160950161111*G0_1_0_1_4 + 0.00099234099234117*G0_1_0_1_5 - 0.000992340992341169*G0_1_0_1_6 + 0.0095016095016111*G0_1_0_1_7 - 0.0219336219336256*G0_1_0_1_8 + 0.0015986482653152*G0_1_0_2_1 + 0.00209991067133959*G0_1_0_2_2 + 0.00446220446220522*G0_1_0_2_3 - 0.00292945150088056*G0_1_0_2_4 - 0.000180771609343067*G0_1_0_2_5 + 0.00135388421102729*G0_1_0_2_6 + 0.00168593311450482*G0_1_0_2_7 - 0.0013786213786216*G0_1_0_2_8 + 0.00238237952523707*G0_1_0_2_9 + 0.00137862137862162*G0_1_0_3_0 + 0.0219336219336257*G0_1_0_3_1 + 0.00446220446220522*G0_1_0_3_2 + 0.0589410589410691*G0_1_0_3_3 - 0.0129270729270752*G0_1_0_3_4 - 0.00355644355644415*G0_1_0_3_5 + 0.00297702297702347*G0_1_0_3_6 - 0.00413586413586487*G0_1_0_3_7 + 0.00827172827172971*G0_1_0_3_9 - 0.00168593311450483*G0_1_0_4_0 - 0.00950160950161111*G0_1_0_4_1 - 0.00292945150088056*G0_1_0_4_2 - 0.0129270729270752*G0_1_0_4_3 - 0.021498501498505*G0_1_0_4_4 + 0.00505779934351447*G0_1_0_4_5 - 0.00803482232053794*G0_1_0_4_6 + 0.0041358641358648*G0_1_0_4_8 - 0.0172627372627402*G0_1_0_4_9 - 0.00135388421102729*G0_1_0_5_0 + 0.000992340992341169*G0_1_0_5_1 - 0.000180771609343067*G0_1_0_5_2 - 0.00355644355644415*G0_1_0_5_3 + 0.00505779934351447*G0_1_0_5_4 - 0.00145568716997312*G0_1_0_5_5 + 0.00803482232053795*G0_1_0_5_7 - 0.00297702297702346*G0_1_0_5_8 + 0.0131011845297582*G0_1_0_5_9 + 0.000180771609343063*G0_1_0_6_0 - 0.000992340992341169*G0_1_0_6_1 + 0.00135388421102729*G0_1_0_6_2 + 0.00297702297702347*G0_1_0_6_3 - 0.00803482232053794*G0_1_0_6_4 + 0.00145568716997313*G0_1_0_6_6 - 0.00505779934351446*G0_1_0_6_7 + 0.00355644355644414*G0_1_0_6_8 - 0.0131011845297582*G0_1_0_6_9 + 0.00292945150088056*G0_1_0_7_0 + 0.0095016095016111*G0_1_0_7_1 + 0.00168593311450482*G0_1_0_7_2 - 0.00413586413586487*G0_1_0_7_3 + 0.00803482232053795*G0_1_0_7_5 - 0.00505779934351446*G0_1_0_7_6 + 0.0214985014985051*G0_1_0_7_7 + 0.0129270729270751*G0_1_0_7_8 + 0.0172627372627402*G0_1_0_7_9 - 0.00446220446220522*G0_1_0_8_0 - 0.0219336219336256*G0_1_0_8_1 - 0.0013786213786216*G0_1_0_8_2 + 0.0041358641358648*G0_1_0_8_4 - 0.00297702297702346*G0_1_0_8_5 + 0.00355644355644414*G0_1_0_8_6 + 0.0129270729270751*G0_1_0_8_7 - 0.0589410589410688*G0_1_0_8_8 - 0.00827172827172966*G0_1_0_8_9 - 0.00238237952523707*G0_1_0_9_0 + 0.00238237952523707*G0_1_0_9_2 + 0.00827172827172971*G0_1_0_9_3 - 0.0172627372627402*G0_1_0_9_4 + 0.0131011845297582*G0_1_0_9_5 - 0.0131011845297582*G0_1_0_9_6 + 0.0172627372627402*G0_1_0_9_7 - 0.00827172827172966*G0_1_0_9_8;
    A[16] = 0.00212020122734446*G0_0_0_0_0 + 0.00505480245063667*G0_0_0_0_1 + 0.000609996815354063*G0_0_0_0_2 + 0.00327664233914291*G0_0_0_0_3 - 0.00139091232841257*G0_0_0_0_4 + 0.000907706711278298*G0_0_0_0_5 - 0.000483709412280923*G0_0_0_0_6 - 0.00193059255559289*G0_0_0_0_7 + 0.0049455174455183*G0_0_0_0_8 + 0.00107184482184501*G0_0_0_0_9 + 0.00505480245063667*G0_0_0_1_0 + 0.106054978971664*G0_0_0_1_1 + 0.00505480245063664*G0_0_0_1_2 + 0.0477428821178903*G0_0_0_1_3 - 0.022224997225001*G0_0_0_1_4 - 0.00074988668738685*G0_0_0_1_5 - 0.000749886687386799*G0_0_0_1_6 - 0.0222249972250011*G0_0_0_1_7 + 0.0477428821178903*G0_0_0_1_8 + 0.00658577533577648*G0_0_0_1_9 + 0.000609996815354063*G0_0_0_2_0 + 0.00505480245063664*G0_0_0_2_1 + 0.00212020122734444*G0_0_0_2_2 + 0.00494551744551828*G0_0_0_2_3 - 0.00193059255559288*G0_0_0_2_4 - 0.000483709412280921*G0_0_0_2_5 + 0.000907706711278292*G0_0_0_2_6 - 0.00139091232841256*G0_0_0_2_7 + 0.00327664233914289*G0_0_0_2_8 + 0.00107184482184501*G0_0_0_2_9 + 0.00327664233914291*G0_0_0_3_0 + 0.0477428821178903*G0_0_0_3_1 + 0.00494551744551828*G0_0_0_3_2 + 0.0567786380286477*G0_0_0_3_3 - 0.0240733225108266*G0_0_0_3_4 - 0.00160776723276751*G0_0_0_3_5 - 0.00211507242757278*G0_0_0_3_6 - 0.0141946595071619*G0_0_0_3_7 + 0.0283893190143239*G0_0_0_3_8 + 0.0086319930069945*G0_0_0_3_9 - 0.00139091232841257*G0_0_0_4_0 - 0.022224997225001*G0_0_0_4_1 - 0.00193059255559288*G0_0_0_4_2 - 0.0240733225108266*G0_0_0_4_3 + 0.0128475690975713*G0_0_0_4_4 - 0.000191995504495532*G0_0_0_4_5 + 0.00230706793206832*G0_0_0_4_6 + 0.00635510323010431*G0_0_0_4_7 - 0.0141946595071619*G0_0_0_4_8 - 0.00283154345654395*G0_0_0_4_9 + 0.000907706711278298*G0_0_0_5_0 - 0.00074988668738685*G0_0_0_5_1 - 0.000483709412280921*G0_0_0_5_2 - 0.00160776723276751*G0_0_0_5_3 - 0.000191995504495532*G0_0_0_5_4 + 0.00947475143903874*G0_0_0_5_5 - 0.00193593608772213*G0_0_0_5_6 + 0.00230706793206833*G0_0_0_5_7 - 0.0021150724275728*G0_0_0_5_8 + 0.00101461038961056*G0_0_0_5_9 - 0.000483709412280923*G0_0_0_6_0 - 0.000749886687386799*G0_0_0_6_1 + 0.000907706711278292*G0_0_0_6_2 - 0.00211507242757278*G0_0_0_6_3 + 0.00230706793206832*G0_0_0_6_4 - 0.00193593608772213*G0_0_0_6_5 + 0.00947475143903874*G0_0_0_6_6 - 0.000191995504495541*G0_0_0_6_7 - 0.00160776723276749*G0_0_0_6_8 + 0.00101461038961055*G0_0_0_6_9 - 0.00193059255559289*G0_0_0_7_0 - 0.0222249972250011*G0_0_0_7_1 - 0.00139091232841256*G0_0_0_7_2 - 0.0141946595071619*G0_0_0_7_3 + 0.00635510323010431*G0_0_0_7_4 + 0.00230706793206833*G0_0_0_7_5 - 0.000191995504495541*G0_0_0_7_6 + 0.0128475690975713*G0_0_0_7_7 - 0.0240733225108266*G0_0_0_7_8 - 0.00283154345654395*G0_0_0_7_9 + 0.0049455174455183*G0_0_0_8_0 + 0.0477428821178903*G0_0_0_8_1 + 0.00327664233914289*G0_0_0_8_2 + 0.0283893190143239*G0_0_0_8_3 - 0.0141946595071619*G0_0_0_8_4 - 0.0021150724275728*G0_0_0_8_5 - 0.00160776723276749*G0_0_0_8_6 - 0.0240733225108266*G0_0_0_8_7 + 0.0567786380286477*G0_0_0_8_8 + 0.00863199300699449*G0_0_0_8_9 + 0.00107184482184501*G0_0_0_9_0 + 0.00658577533577648*G0_0_0_9_1 + 0.00107184482184501*G0_0_0_9_2 + 0.0086319930069945*G0_0_0_9_3 - 0.00283154345654395*G0_0_0_9_4 + 0.00101461038961056*G0_0_0_9_5 + 0.00101461038961055*G0_0_0_9_6 - 0.00283154345654395*G0_0_0_9_7 + 0.00863199300699449*G0_0_0_9_8 + 0.0118756243756264*G0_0_0_9_9;
    A[70] = A[157] + 0.0158804158804187*G0_0_0_0_0 + 0.00169444312301486*G0_0_0_0_2 + 0.00068217496788935*G0_0_0_0_3 - 0.00178535749964351*G0_0_0_0_4 + 0.0198748870177476*G0_0_0_0_5 - 0.00750487607630595*G0_0_0_0_6 + 0.00382807668522024*G0_0_0_0_7 + 0.00098948670377254*G0_0_0_0_8 + 0.000587983445126403*G0_0_0_0_9 - 0.0158804158804182*G0_0_0_1_1 - 0.00169444312301482*G0_0_0_1_2 - 0.0198748870177475*G0_0_0_1_3 + 0.00750487607630592*G0_0_0_1_4 - 0.000682174967889364*G0_0_0_1_5 + 0.00178535749964353*G0_0_0_1_6 - 0.000989486703772578*G0_0_0_1_7 - 0.0038280766852202*G0_0_0_1_8 - 0.000587983445126422*G0_0_0_1_9 + 0.00169444312301486*G0_0_0_2_0 - 0.00169444312301482*G0_0_0_2_1 - 0.00197136197136239*G0_0_0_2_3 + 0.00154512154512195*G0_0_0_2_4 + 0.00197136197136224*G0_0_0_2_5 - 0.00154512154512167*G0_0_0_2_6 - 0.00580705009276534*G0_0_0_2_7 + 0.00580705009276533*G0_0_0_2_8 + 0.00068217496788935*G0_0_0_3_0 - 0.0198748870177475*G0_0_0_3_1 - 0.00197136197136239*G0_0_0_3_2 + 0.0132039389182262*G0_0_0_3_3 + 0.012548879691739*G0_0_0_3_4 - 0.00535607249893059*G0_0_0_3_6 - 0.00204652490366804*G0_0_0_3_7 + 0.019467675181964*G0_0_0_3_8 + 0.00585700014271534*G0_0_0_3_9 - 0.00178535749964351*G0_0_0_4_0 + 0.00750487607630592*G0_0_0_4_1 + 0.00154512154512195*G0_0_0_4_2 + 0.012548879691739*G0_0_0_4_3 + 0.0109690309690328*G0_0_0_4_4 + 0.00535607249893053*G0_0_0_4_5 + 0.0113886113886133*G0_0_0_4_7 - 0.017421150278296*G0_0_0_4_8 - 0.0107121449978611*G0_0_0_4_9 + 0.0198748870177476*G0_0_0_5_0 - 0.000682174967889364*G0_0_0_5_1 + 0.00197136197136224*G0_0_0_5_2 + 0.00535607249893053*G0_0_0_5_4 - 0.0132039389182267*G0_0_0_5_5 - 0.012548879691739*G0_0_0_5_6 - 0.0194676751819641*G0_0_0_5_7 + 0.00204652490366808*G0_0_0_5_8 - 0.00585700014271535*G0_0_0_5_9 - 0.00750487607630595*G0_0_0_6_0 + 0.00178535749964353*G0_0_0_6_1 - 0.00154512154512167*G0_0_0_6_2 - 0.00535607249893059*G0_0_0_6_3 - 0.012548879691739*G0_0_0_6_5 - 0.0109690309690326*G0_0_0_6_6 + 0.017421150278296*G0_0_0_6_7 - 0.0113886113886133*G0_0_0_6_8 + 0.0107121449978611*G0_0_0_6_9 + 0.00382807668522024*G0_0_0_7_0 - 0.000989486703772578*G0_0_0_7_1 - 0.00580705009276534*G0_0_0_7_2 - 0.00204652490366804*G0_0_0_7_3 + 0.0113886113886133*G0_0_0_7_4 - 0.0194676751819641*G0_0_0_7_5 + 0.017421150278296*G0_0_0_7_6 - 0.0695390323961866*G0_0_0_7_7 - 0.0366062508919712*G0_0_0_7_9 + 0.000989486703772541*G0_0_0_8_0 - 0.0038280766852202*G0_0_0_8_1 + 0.00580705009276533*G0_0_0_8_2 + 0.019467675181964*G0_0_0_8_3 - 0.017421150278296*G0_0_0_8_4 + 0.00204652490366808*G0_0_0_8_5 - 0.0113886113886133*G0_0_0_8_6 + 0.0695390323961864*G0_0_0_8_8 + 0.0366062508919713*G0_0_0_8_9 + 0.000587983445126403*G0_0_0_9_0 - 0.000587983445126422*G0_0_0_9_1 + 0.00585700014271534*G0_0_0_9_3 - 0.0107121449978611*G0_0_0_9_4 - 0.00585700014271535*G0_0_0_9_5 + 0.0107121449978611*G0_0_0_9_6 - 0.0366062508919712*G0_0_0_9_7 + 0.0366062508919713*G0_0_0_9_8 - 0.121013061013082*G0_0_1_0_0 - 0.00216648430934184*G0_0_1_0_1 - 0.00136242064813516*G0_0_1_0_2 - 0.000146282289139432*G0_0_1_0_3 + 0.00071000428143298*G0_0_1_0_4 - 0.00537319823034201*G0_0_1_0_5 + 0.00666619095190638*G0_0_1_0_6 - 0.00682127396413238*G0_0_1_0_7 + 0.00706198563341546*G0_0_1_0_8 + 0.0070044241472824*G0_0_1_0_9 - 0.00216648430934184*G0_0_1_1_0 - 0.0192962592962622*G0_0_1_1_1 - 0.00187968116539575*G0_0_1_1_2 - 0.0248047190904375*G0_0_1_1_3 + 0.00896650968079688*G0_0_1_1_4 + 0.00159626088197542*G0_0_1_1_5 + 0.00187455401741148*G0_0_1_1_6 + 0.0071559392987976*G0_0_1_1_7 - 0.00977070548499278*G0_0_1_1_8 - 0.00890966176680614*G0_0_1_1_9 - 0.00136242064813516*G0_0_1_2_0 - 0.00187968116539575*G0_0_1_2_1 + 0.00359640359640436*G0_0_1_2_2 - 0.00428880643166434*G0_0_1_2_3 + 0.000849626563912495*G0_0_1_2_4 + 0.00397055325626822*G0_0_1_2_5 - 0.000260215974501726*G0_0_1_2_6 + 0.00217853574996467*G0_0_1_2_7 + 0.00494005994006075*G0_0_1_2_8 + 0.00081775367489666*G0_0_1_2_9 - 0.000146282289139432*G0_0_1_3_0 - 0.0248047190904375*G0_0_1_3_1 - 0.00428880643166434*G0_0_1_3_2 + 0.0180333951762548*G0_0_1_3_3 + 0.0215976880262631*G0_0_1_3_4 - 0.00244683887541063*G0_0_1_3_5 - 0.00507992007992093*G0_0_1_3_6 + 0.000982588839731899*G0_0_1_3_7 + 0.0132938490081368*G0_0_1_3_8 + 0.0247638076209545*G0_0_1_3_9 + 0.00071000428143298*G0_0_1_4_0 + 0.00896650968079688*G0_0_1_4_1 + 0.000849626563912495*G0_0_1_4_2 + 0.0215976880262631*G0_0_1_4_3 + 0.0322135007849349*G0_0_1_4_4 - 0.00158627087198544*G0_0_1_4_5 + 0.00666619095190636*G0_0_1_4_6 - 0.00460468103325323*G0_0_1_4_7 - 0.0142764378478687*G0_0_1_4_8 + 0.000719280719280897*G0_0_1_4_9 - 0.00537319823034201*G0_0_1_5_0 + 0.00159626088197542*G0_0_1_5_1 + 0.00397055325626822*G0_0_1_5_2 - 0.00244683887541063*G0_0_1_5_3 - 0.00158627087198544*G0_0_1_5_4 + 0.19208648494366*G0_0_1_5_5 - 0.028122591694025*G0_0_1_5_6 + 0.0102369059511932*G0_0_1_5_7 - 0.00424504067361277*G0_0_1_5_8 - 0.0125231910946218*G0_0_1_5_9 + 0.00666619095190638*G0_0_1_6_0 + 0.00187455401741148*G0_0_1_6_1 - 0.000260215974501726*G0_0_1_6_2 - 0.00507992007992093*G0_0_1_6_3 + 0.00666619095190636*G0_0_1_6_4 - 0.028122591694025*G0_0_1_6_5 + 0.00660196945911325*G0_0_1_6_6 - 0.0059918652775805*G0_0_1_6_7 - 0.0104937919223651*G0_0_1_6_8 + 0.00770657913515186*G0_0_1_6_9 - 0.00682127396413238*G0_0_1_7_0 + 0.0071559392987976*G0_0_1_7_1 + 0.00217853574996467*G0_0_1_7_2 + 0.0009825888397319*G0_0_1_7_3 - 0.00460468103325323*G0_0_1_7_4 + 0.0102369059511932*G0_0_1_7_5 - 0.0059918652775805*G0_0_1_7_6 + 0.203663479377799*G0_0_1_7_7 - 0.027899957185676*G0_0_1_7_8 - 0.00902954188668625*G0_0_1_7_9 + 0.00706198563341546*G0_0_1_8_0 - 0.00977070548499278*G0_0_1_8_1 + 0.00494005994006075*G0_0_1_8_2 + 0.0132938490081368*G0_0_1_8_3 - 0.0142764378478687*G0_0_1_8_4 - 0.00424504067361277*G0_0_1_8_5 - 0.0104937919223651*G0_0_1_8_6 - 0.027899957185676*G0_0_1_8_7 + 0.0713029827315654*G0_0_1_8_8 + 0.0552818609961559*G0_0_1_8_9 + 0.0070044241472824*G0_0_1_9_0 - 0.00890966176680614*G0_0_1_9_1 + 0.000817753674896661*G0_0_1_9_2 + 0.0247638076209545*G0_0_1_9_3 + 0.000719280719280895*G0_0_1_9_4 - 0.0125231910946218*G0_0_1_9_5 + 0.00770657913515185*G0_0_1_9_6 - 0.00902954188668625*G0_0_1_9_7 + 0.0552818609961559*G0_0_1_9_8 - 0.0502468959611903*G0_0_1_9_9 - 0.00341584341584407*G0_1_0_0_0 - 0.00216648430934186*G0_1_0_0_1 - 0.000185238042380928*G0_1_0_0_2 + 0.00227843584986482*G0_1_0_0_3 - 0.00492983207269004*G0_1_0_0_5 + 0.00146163360449099*G0_1_0_0_6 - 0.00594262879977266*G0_1_0_0_7 + 0.00814542600257024*G0_1_0_0_8 - 0.00832167832167972*G0_1_0_0_9 - 0.00216648430934186*G0_1_0_1_0 - 0.1368934768935*G0_1_0_1_1 - 0.00305686377115001*G0_1_0_1_2 - 0.0252480852480897*G0_1_0_1_3 + 0.0141710670282123*G0_1_0_1_4 - 0.000828457257028771*G0_1_0_1_5 + 0.0024953617810765*G0_1_0_1_6 + 0.00607249892964293*G0_1_0_1_7 - 0.0106493506493527*G0_1_0_1_8 + 0.00641644070215604*G0_1_0_1_9 - 0.000185238042380928*G0_1_0_2_0 - 0.00305686377115001*G0_1_0_2_1 + 0.00359640359640423*G0_1_0_2_2 + 0.0019991912849059*G0_1_0_2_3 + 0.00128490557062008*G0_1_0_2_4 - 0.002317444460302*G0_1_0_2_5 - 0.000695494981209386*G0_1_0_2_6 - 0.000866990152704573*G0_1_0_2_7 + 0.00798558584273002*G0_1_0_2_8 + 0.000817753674896664*G0_1_0_2_9 + 0.00227843584986482*G0_1_0_3_0 - 0.0252480852480897*G0_1_0_3_1 + 0.0019991912849059*G0_1_0_3_2 + 0.205290423861887*G0_1_0_3_3 - 0.015573712002286*G0_1_0_3_4 - 0.00244683887541067*G0_1_0_3_5 - 0.00694234337091602*G0_1_0_3_6 - 0.00629156557728089*G0_1_0_3_7 + 0.0297045811331574*G0_1_0_3_8 - 0.00666619095190632*G0_1_0_3_9 + 0.0141710670282123*G0_1_0_4_1 + 0.00128490557062008*G0_1_0_4_2 - 0.015573712002286*G0_1_0_4_3 + 0.0175710004281462*G0_1_0_4_4 + 0.000276152419009603*G0_1_0_4_5 + 0.00666619095190642*G0_1_0_4_6 + 0.000894819466248162*G0_1_0_4_7 - 0.0234130155558766*G0_1_0_4_8 - 0.00300556586270922*G0_1_0_4_9 - 0.00492983207269004*G0_1_0_5_0 - 0.000828457257028771*G0_1_0_5_1 - 0.002317444460302*G0_1_0_5_2 - 0.00244683887541068*G0_1_0_5_3 + 0.000276152419009603*G0_1_0_5_4 + 0.00482945625802884*G0_1_0_5_5 + 0.00904880833452416*G0_1_0_5_6 - 0.00617382617382718*G0_1_0_5_7 + 0.00302911374339993*G0_1_0_5_8 + 0.0189068074782393*G0_1_0_5_9 + 0.00146163360449099*G0_1_0_6_0 + 0.0024953617810765*G0_1_0_6_1 - 0.000695494981209386*G0_1_0_6_2 - 0.00694234337091602*G0_1_0_6_3 + 0.00666619095190642*G0_1_0_6_4 + 0.00904880833452416*G0_1_0_6_5 + 0.0212444698159025*G0_1_0_6_6 + 0.00314471243042722*G0_1_0_6_7 - 0.0159932924218665*G0_1_0_6_8 + 0.0114314257171421*G0_1_0_6_9 - 0.00594262879977266*G0_1_0_7_0 + 0.00607249892964294*G0_1_0_7_1 - 0.000866990152704573*G0_1_0_7_2 - 0.00629156557728089*G0_1_0_7_3 + 0.000894819466248161*G0_1_0_7_4 - 0.00617382617382718*G0_1_0_7_5 + 0.00314471243042722*G0_1_0_7_6 + 0.00176395033537945*G0_1_0_7_7 - 0.0278999571856761*G0_1_0_7_8 + 0.0186756101041847*G0_1_0_7_9 + 0.00814542600257024*G0_1_0_8_0 - 0.0106493506493527*G0_1_0_8_1 + 0.00798558584273002*G0_1_0_8_2 + 0.0297045811331574*G0_1_0_8_3 - 0.0234130155558766*G0_1_0_8_4 + 0.00302911374339993*G0_1_0_8_5 - 0.0159932924218665*G0_1_0_8_6 - 0.0278999571856761*G0_1_0_8_7 + 0.273202511773986*G0_1_0_8_8 + 0.0275767090052851*G0_1_0_8_9 - 0.00832167832167972*G0_1_0_9_0 + 0.00641644070215604*G0_1_0_9_1 + 0.000817753674896664*G0_1_0_9_2 - 0.00666619095190632*G0_1_0_9_3 - 0.00300556586270923*G0_1_0_9_4 + 0.0189068074782393*G0_1_0_9_5 + 0.0114314257171421*G0_1_0_9_6 + 0.0186756101041847*G0_1_0_9_7 + 0.0275767090052851*G0_1_0_9_8 - 0.0502468959611901*G0_1_0_9_9 + 0.0194768194768226*G0_1_1_0_0 - 0.00216648430934187*G0_1_1_0_1 + 0.000618825618825713*G0_1_1_0_2 + 0.00534394177251411*G0_1_1_0_3 + 0.00067147138575723*G0_1_1_0_4 + 0.004580657437801*G0_1_1_0_5 - 0.0017237524380384*G0_1_1_0_6 + 0.0197117168545772*G0_1_1_0_7 - 0.00510989010989093*G0_1_1_0_8 + 0.00140573712002308*G0_1_1_0_9 - 0.00216648430934187*G0_1_1_1_0 - 0.159786139786167*G0_1_1_1_1 - 0.00386092743235666*G0_1_1_1_2 - 0.0347585747585807*G0_1_1_1_3 + 0.0173564530707417*G0_1_1_1_4 - 0.00389396317967808*G0_1_1_1_5 + 0.00191308691308723*G0_1_1_1_6 + 0.0193278150421041*G0_1_1_1_7 - 0.0363036963037027*G0_1_1_1_8 - 0.00331097473954675*G0_1_1_1_9 + 0.000618825618825713*G0_1_1_2_0 - 0.00386092743235666*G0_1_1_2_1 + 0.00359640359640421*G0_1_1_2_2 + 0.00239498596641492*G0_1_1_2_3 - 0.000163170163170196*G0_1_1_2_4 - 0.00271323914181104*G0_1_1_2_5 + 0.000752580752580895*G0_1_1_2_6 + 0.00712929927215759*G0_1_1_2_8 + 0.000817753674896643*G0_1_1_2_9 + 0.00534394177251411*G0_1_1_3_0 - 0.0347585747585807*G0_1_1_3_1 + 0.00239498596641492*G0_1_1_3_2 + 0.26999143713434*G0_1_1_3_3 - 0.0153510774939371*G0_1_1_3_4 - 0.00244683887541064*G0_1_1_3_5 - 0.00519551876694823*G0_1_1_3_6 - 0.0154880833452288*G0_1_1_3_7 + 0.036332239189388*G0_1_1_3_8 + 0.0409090909090978*G0_1_1_3_9 + 0.000671471385757231*G0_1_1_4_0 + 0.0173564530707417*G0_1_1_4_1 - 0.000163170163170195*G0_1_1_4_2 - 0.0153510774939371*G0_1_1_4_3 + 0.0291479948622855*G0_1_1_4_4 - 0.00147067218495816*G0_1_1_4_5 + 0.00666619095190639*G0_1_1_4_6 - 0.00126302269159435*G0_1_1_4_7 - 0.0208441558441592*G0_1_1_4_8 + 0.000488083345226375*G0_1_1_4_9 + 0.004580657437801*G0_1_1_5_0 - 0.00389396317967808*G0_1_1_5_1 - 0.00271323914181104*G0_1_1_5_2 - 0.00244683887541064*G0_1_1_5_3 - 0.00147067218495816*G0_1_1_5_4 - 0.0598715570144245*G0_1_1_5_5 + 0.0088261738261753*G0_1_1_5_6 - 0.0128014842300579*G0_1_1_5_7 + 0.0122256315113479*G0_1_1_5_8 - 0.028668474382765*G0_1_1_5_9 - 0.0017237524380384*G0_1_1_6_0 + 0.00191308691308723*G0_1_1_6_1 + 0.000752580752580895*G0_1_1_6_2 - 0.00519551876694823*G0_1_1_6_3 + 0.00666619095190639*G0_1_1_6_4 + 0.0088261738261753*G0_1_1_6_5 + 0.009667475381763*G0_1_1_6_6 + 0.000575852718710002*G0_1_1_6_7 - 0.013835450264024*G0_1_1_6_8 + 0.00793777650920652*G0_1_1_6_9 + 0.0197117168545772*G0_1_1_7_0 + 0.0193278150421041*G0_1_1_7_1 - 0.0154880833452288*G0_1_1_7_3 - 0.00126302269159435*G0_1_1_7_4 - 0.0128014842300579*G0_1_1_7_5 + 0.000575852718710001*G0_1_1_7_6 + 0.0159440559440582*G0_1_1_7_7 - 0.027899957185676*G0_1_1_7_8 - 0.00536891679748918*G0_1_1_7_9 - 0.00510989010989093*G0_1_1_8_0 - 0.0363036963037027*G0_1_1_8_1 + 0.00712929927215759*G0_1_1_8_2 + 0.036332239189388*G0_1_1_8_3 - 0.0208441558441592*G0_1_1_8_4 + 0.0122256315113479*G0_1_1_8_5 - 0.013835450264024*G0_1_1_8_6 - 0.027899957185676*G0_1_1_8_7 + 0.259022406165307*G0_1_1_8_8 + 0.0516212359069588*G0_1_1_8_9 + 0.00140573712002308*G0_1_1_9_0 - 0.00331097473954675*G0_1_1_9_1 + 0.000817753674896644*G0_1_1_9_2 + 0.0409090909090978*G0_1_1_9_3 + 0.000488083345226374*G0_1_1_9_4 - 0.028668474382765*G0_1_1_9_5 + 0.00793777650920652*G0_1_1_9_6 - 0.00536891679748918*G0_1_1_9_7 + 0.0516212359069588*G0_1_1_9_8 - 0.0502468959611904*G0_1_1_9_9;
    A[122] = -0.00113558399272705*G0_0_1_0_0 - 0.000944003086860395*G0_0_1_0_1 - 0.0117478200811554*G0_0_1_0_2 + 0.00417748917748989*G0_0_1_0_3 - 0.00868964368964519*G0_0_1_0_4 + 0.00592851592851694*G0_0_1_0_5 - 0.0135714285714309*G0_0_1_0_6 + 0.000520749092177751*G0_0_1_0_7 + 0.000326736755308238*G0_0_1_0_8 - 0.00253857253857297*G0_0_1_0_9 - 0.000944003086860395*G0_0_1_1_0 - 0.00113558399272705*G0_0_1_1_1 - 0.0117478200811554*G0_0_1_1_2 + 0.00592851592851693*G0_0_1_1_3 - 0.0135714285714309*G0_0_1_1_4 + 0.00417748917748989*G0_0_1_1_5 - 0.00868964368964518*G0_0_1_1_6 + 0.000326736755308241*G0_0_1_1_7 + 0.000520749092177744*G0_0_1_1_8 - 0.00253857253857297*G0_0_1_1_9 - 0.0117478200811554*G0_0_1_2_0 - 0.0117478200811554*G0_0_1_2_1 - 0.2284591951259*G0_0_1_2_2 + 0.0524753024753112*G0_0_1_2_3 - 0.113297813297832*G0_0_1_2_4 + 0.0524753024753113*G0_0_1_2_5 - 0.113297813297832*G0_0_1_2_6 + 0.00252247752247793*G0_0_1_2_7 + 0.00252247752247792*G0_0_1_2_8 - 0.0166944166944195*G0_0_1_2_9 + 0.00417748917748989*G0_0_1_3_0 + 0.00592851592851693*G0_0_1_3_1 + 0.0524753024753112*G0_0_1_3_2 - 0.0270496170496216*G0_0_1_3_3 + 0.0619963369963474*G0_0_1_3_4 - 0.017975357975361*G0_0_1_3_5 + 0.0369547119547181*G0_0_1_3_6 - 0.00164668664668692*G0_0_1_3_7 - 0.00167166167166195*G0_0_1_3_8 + 0.0109090909090927*G0_0_1_3_9 - 0.00868964368964519*G0_0_1_4_0 - 0.0135714285714309*G0_0_1_4_1 - 0.113297813297832*G0_0_1_4_2 + 0.0619963369963474*G0_0_1_4_3 - 0.147818847818873*G0_0_1_4_4 + 0.0369547119547182*G0_0_1_4_5 - 0.0739094239094363*G0_0_1_4_6 + 0.00380785880785944*G0_0_1_4_7 + 0.00331834831834887*G0_0_1_4_8 - 0.0238261738261778*G0_0_1_4_9 + 0.00592851592851694*G0_0_1_5_0 + 0.00417748917748989*G0_0_1_5_1 + 0.0524753024753113*G0_0_1_5_2 - 0.017975357975361*G0_0_1_5_3 + 0.0369547119547182*G0_0_1_5_4 - 0.0270496170496216*G0_0_1_5_5 + 0.0619963369963474*G0_0_1_5_6 - 0.00167166167166195*G0_0_1_5_7 - 0.00164668664668691*G0_0_1_5_8 + 0.0109090909090927*G0_0_1_5_9 - 0.0135714285714309*G0_0_1_6_0 - 0.00868964368964517*G0_0_1_6_1 - 0.113297813297832*G0_0_1_6_2 + 0.0369547119547181*G0_0_1_6_3 - 0.0739094239094363*G0_0_1_6_4 + 0.0619963369963474*G0_0_1_6_5 - 0.147818847818873*G0_0_1_6_6 + 0.00331834831834886*G0_0_1_6_7 + 0.00380785880785943*G0_0_1_6_8 - 0.0238261738261778*G0_0_1_6_9 + 0.000520749092177751*G0_0_1_7_0 + 0.000326736755308241*G0_0_1_7_1 + 0.00252247752247793*G0_0_1_7_2 - 0.00164668664668692*G0_0_1_7_3 + 0.00380785880785944*G0_0_1_7_4 - 0.00167166167166195*G0_0_1_7_5 + 0.00331834831834886*G0_0_1_7_6 + 0.000705484991199376*G0_0_1_7_7 - 0.000204319490033806*G0_0_1_7_8 + 0.000979020979021139*G0_0_1_7_9 + 0.000326736755308238*G0_0_1_8_0 + 0.000520749092177744*G0_0_1_8_1 + 0.00252247752247792*G0_0_1_8_2 - 0.00167166167166195*G0_0_1_8_3 + 0.00331834831834887*G0_0_1_8_4 - 0.00164668664668691*G0_0_1_8_5 + 0.00380785880785943*G0_0_1_8_6 - 0.000204319490033806*G0_0_1_8_7 + 0.00070548499119936*G0_0_1_8_8 + 0.000979020979021137*G0_0_1_8_9 - 0.00253857253857297*G0_0_1_9_0 - 0.00253857253857297*G0_0_1_9_1 - 0.0166944166944195*G0_0_1_9_2 + 0.0109090909090927*G0_0_1_9_3 - 0.0238261738261778*G0_0_1_9_4 + 0.0109090909090927*G0_0_1_9_5 - 0.0238261738261778*G0_0_1_9_6 + 0.000979020979021139*G0_0_1_9_7 + 0.000979020979021137*G0_0_1_9_8 - 0.00803196803196937*G0_0_1_9_9 - 0.00852893138607569*G0_1_1_0_0 - 0.00113768066149038*G0_1_1_0_1 - 0.00744194077527538*G0_1_1_0_2 + 0.00204657776086383*G0_1_1_0_3 - 0.00497687497687584*G0_1_1_0_4 + 0.000402296116581904*G0_1_1_0_5 - 0.00337384837384895*G0_1_1_0_6 - 0.00570572284858095*G0_1_1_0_7 + 0.00280632066346399*G0_1_1_0_8 - 0.00116090258947422*G0_1_1_0_9 - 0.00113768066149038*G0_1_1_1_0 - 0.00151227960751799*G0_1_1_1_1 - 0.00887384220717705*G0_1_1_1_2 + 0.00434665863237365*G0_1_1_1_3 - 0.00985865985866154*G0_1_1_1_4 + 0.00112543541114989*G0_1_1_1_5 - 0.00420431420431492*G0_1_1_1_6 - 0.000719016433302262*G0_1_1_1_7 + 0.000684500684500779*G0_1_1_1_8 - 0.00225901083043979*G0_1_1_1_9 - 0.00744194077527538*G0_1_1_2_0 - 0.00887384220717705*G0_1_1_2_1 - 0.18557615224285*G0_1_1_2_2 + 0.0399332149332216*G0_1_1_2_3 - 0.088213638213653*G0_1_1_2_4 + 0.0310569060569112*G0_1_1_2_5 - 0.0631294631294737*G0_1_1_2_6 + 0.000419950419950483*G0_1_1_2_7 + 0.00108040108040125*G0_1_1_2_8 - 0.00936285936286091*G0_1_1_2_9 + 0.00204657776086383*G0_1_1_3_0 + 0.00434665863237365*G0_1_1_3_1 + 0.0399332149332216*G0_1_1_3_2 - 0.021438561438565*G0_1_1_3_3 + 0.0463636363636442*G0_1_1_3_4 - 0.00795371295371428*G0_1_1_3_5 + 0.0190043290043322*G0_1_1_3_6 + 0.00025165310879602*G0_1_1_3_7 - 0.00340183625897969*G0_1_1_3_8 + 0.00627372627372733*G0_1_1_3_9 - 0.00497687497687584*G0_1_1_4_0 - 0.00985865985866154*G0_1_1_4_1 - 0.088213638213653*G0_1_1_4_2 + 0.0463636363636442*G0_1_1_4_3 - 0.114235764235784*G0_1_1_4_4 + 0.0213220113220149*G0_1_1_4_5 - 0.0403263403263471*G0_1_1_4_6 + 0.00363969363969424*G0_1_1_4_7 + 0.00315018315018368*G0_1_1_4_8 - 0.014555444555447*G0_1_1_4_9 + 0.000402296116581904*G0_1_1_5_0 + 0.00112543541114989*G0_1_1_5_1 + 0.0310569060569112*G0_1_1_5_2 - 0.00795371295371428*G0_1_1_5_3 + 0.0213220113220149*G0_1_1_5_4 - 0.0236729936729976*G0_1_1_5_5 + 0.0220512820512857*G0_1_1_5_6 - 0.00814661528947378*G0_1_1_5_7 + 0.00301508015793781*G0_1_1_5_8 - 0.00254745254745297*G0_1_1_5_9 - 0.00337384837384895*G0_1_1_6_0 - 0.00420431420431492*G0_1_1_6_1 - 0.0631294631294737*G0_1_1_6_2 + 0.0190043290043322*G0_1_1_6_3 - 0.0403263403263471*G0_1_1_6_4 + 0.0220512820512857*G0_1_1_6_5 - 0.0470695970696049*G0_1_1_6_6 + 0.00513153513153598*G0_1_1_6_7 + 0.00149017649017674*G0_1_1_6_8 - 0.00992007992008161*G0_1_1_6_9 - 0.00570572284858095*G0_1_1_7_0 - 0.000719016433302262*G0_1_1_7_1 + 0.000419950419950483*G0_1_1_7_2 + 0.00025165310879602*G0_1_1_7_3 + 0.00363969363969424*G0_1_1_7_4 - 0.00814661528947378*G0_1_1_7_5 + 0.00513153513153598*G0_1_1_7_6 - 0.0346562960848734*G0_1_1_7_7 + 0.00541077969649491*G0_1_1_7_8 - 0.00678036249464935*G0_1_1_7_9 + 0.00280632066346399*G0_1_1_8_0 + 0.000684500684500779*G0_1_1_8_1 + 0.00108040108040125*G0_1_1_8_2 - 0.00340183625897969*G0_1_1_8_3 + 0.00315018315018368*G0_1_1_8_4 + 0.00301508015793781*G0_1_1_8_5 + 0.00149017649017674*G0_1_1_8_6 + 0.00541077969649491*G0_1_1_8_7 - 0.015982113124973*G0_1_1_8_8 + 0.000476666190951991*G0_1_1_8_9 - 0.00116090258947422*G0_1_1_9_0 - 0.00225901083043979*G0_1_1_9_1 - 0.00936285936286091*G0_1_1_9_2 + 0.00627372627372733*G0_1_1_9_3 - 0.014555444555447*G0_1_1_9_4 - 0.00254745254745297*G0_1_1_9_5 - 0.00992007992008161*G0_1_1_9_6 - 0.00678036249464935*G0_1_1_9_7 + 0.000476666190951992*G0_1_1_9_8 - 0.0340459540459598*G0_1_1_9_9;
    A[138] = A[181] + 0.0145464412131104*G0_0_0_0_0 - 0.00148458243696366*G0_0_0_0_1 + 0.00175480604052063*G0_0_0_0_2 - 0.00417561274704208*G0_0_0_0_3 + 0.000163698735127345*G0_0_0_0_4 + 0.0195610209895958*G0_0_0_0_5 - 0.00959506102363409*G0_0_0_0_6 + 0.00270782127925034*G0_0_0_0_7 + 0.00073281216138368*G0_0_0_0_8 + 0.00164724164724193*G0_0_0_0_9 - 0.00148458243696366*G0_0_0_1_0 - 0.0455692455692534*G0_0_0_1_1 - 0.00526128192794949*G0_0_0_1_2 - 0.0641073741073851*G0_0_0_1_3 + 0.0255824598681785*G0_0_0_1_4 + 0.00453377310520244*G0_0_0_1_5 + 0.000501456215742021*G0_0_0_1_6 + 0.00874004302575885*G0_0_0_1_7 - 0.0125959225959248*G0_0_0_1_8 - 0.00279403136546047*G0_0_0_1_9 + 0.00175480604052063*G0_0_0_2_0 - 0.00526128192794949*G0_0_0_2_1 - 0.000509120509120531*G0_0_0_2_2 - 0.0103680446537607*G0_0_0_2_3 + 0.00345432345432406*G0_0_0_2_4 + 0.00424844996273639*G0_0_0_2_5 - 0.00409368409368474*G0_0_0_2_6 + 0.00121566264423429*G0_0_0_2_7 + 0.000504944790659135*G0_0_0_2_8 + 0.00153751010893893*G0_0_0_2_9 - 0.00417561274704208*G0_0_0_3_0 - 0.0641073741073851*G0_0_0_3_1 - 0.0103680446537607*G0_0_0_3_2 - 0.26910232624523*G0_0_0_3_3 + 0.05115884115885*G0_0_0_3_4 - 0.000439560439560495*G0_0_0_3_5 - 0.00169972884258625*G0_0_0_3_6 + 0.012331478045766*G0_0_0_3_7 - 0.0106212834784284*G0_0_0_3_8 - 0.0162808619951507*G0_0_0_3_9 + 0.000163698735127345*G0_0_0_4_0 + 0.0255824598681785*G0_0_0_4_1 + 0.00345432345432406*G0_0_0_4_2 + 0.05115884115885*G0_0_0_4_3 - 0.0191494220065681*G0_0_0_4_4 - 0.000686456400742236*G0_0_0_4_5 + 0.00238618524332848*G0_0_0_4_6 - 0.00197136197136235*G0_0_0_4_7 - 0.00171019456733761*G0_0_0_4_8 - 0.00323961752533234*G0_0_0_4_9 + 0.0195610209895958*G0_0_0_5_0 + 0.00453377310520244*G0_0_0_5_1 + 0.00424844996273639*G0_0_0_5_2 - 0.000439560439560495*G0_0_0_5_3 - 0.000686456400742236*G0_0_0_5_4 + 0.139437705152014*G0_0_0_5_5 - 0.0149093763379503*G0_0_0_5_6 + 0.0176390276390306*G0_0_0_5_7 - 0.0137966795109675*G0_0_0_5_8 + 0.0226516340802093*G0_0_0_5_9 - 0.00959506102363409*G0_0_0_6_0 + 0.000501456215742022*G0_0_0_6_1 - 0.00409368409368474*G0_0_0_6_2 - 0.00169972884258625*G0_0_0_6_3 + 0.00238618524332848*G0_0_0_6_4 - 0.0149093763379503*G0_0_0_6_5 + 0.0224489795918406*G0_0_0_6_6 - 0.00384234812806306*G0_0_0_6_7 - 0.00141192141192163*G0_0_0_6_8 - 0.0012130726416443*G0_0_0_6_9 + 0.00270782127925034*G0_0_0_7_0 + 0.00874004302575885*G0_0_0_7_1 + 0.00121566264423429*G0_0_0_7_2 + 0.012331478045766*G0_0_0_7_3 - 0.00197136197136235*G0_0_0_7_4 + 0.0176390276390306*G0_0_0_7_5 - 0.00384234812806306*G0_0_0_7_6 + 0.0117777460634623*G0_0_0_7_7 - 0.0163626849341162*G0_0_0_7_8 + 0.00274297131440039*G0_0_0_7_9 + 0.00073281216138368*G0_0_0_8_0 - 0.0125959225959248*G0_0_0_8_1 + 0.000504944790659135*G0_0_0_8_2 - 0.0106212834784284*G0_0_0_8_3 - 0.00171019456733761*G0_0_0_8_4 - 0.0137966795109675*G0_0_0_8_5 - 0.00141192141192163*G0_0_0_8_6 - 0.0163626849341162*G0_0_0_8_7 + 0.0368783597355086*G0_0_0_8_8 + 0.0118024832310566*G0_0_0_8_9 + 0.00164724164724193*G0_0_0_9_0 - 0.00279403136546047*G0_0_0_9_1 + 0.00153751010893893*G0_0_0_9_2 - 0.0162808619951507*G0_0_0_9_3 - 0.00323961752533234*G0_0_0_9_4 + 0.0226516340802093*G0_0_0_9_5 - 0.0012130726416443*G0_0_0_9_6 + 0.00274297131440039*G0_0_0_9_7 + 0.0118024832310566*G0_0_0_9_8 + 0.0685714285714399*G0_0_0_9_9 + 0.00447947114613872*G0_0_1_0_0 - 0.00263003310622405*G0_0_1_0_1 + 0.000233276423752658*G0_0_1_0_2 - 0.00277986563700901*G0_0_1_0_3 + 0.00047021761307485*G0_0_1_0_4 + 0.00277944277944332*G0_0_1_0_5 - 0.00137132708561306*G0_0_1_0_6 + 0.00135864135864165*G0_0_1_0_7 + 0.00264243692815162*G0_0_1_0_8 + 0.00164153307010477*G0_0_1_0_9 - 0.00263003310622405*G0_0_1_1_0 - 0.11911051911054*G0_0_1_1_1 - 0.00690216309264045*G0_0_1_1_2 - 0.07687719687721*G0_0_1_1_3 + 0.0322936322936378*G0_0_1_1_4 + 0.00106137248994413*G0_0_1_1_5 + 0.000557749129177789*G0_0_1_1_6 + 0.0123550523550545*G0_0_1_1_7 - 0.0193820993821028*G0_0_1_1_8 - 0.00504384504384595*G0_0_1_1_9 + 0.000233276423752658*G0_0_1_2_0 - 0.00690216309264045*G0_0_1_2_1 - 0.000546331974903493*G0_0_1_2_2 - 0.00919250062107362*G0_0_1_2_3 + 0.00284498570212905*G0_0_1_2_4 + 0.00044696044696053*G0_0_1_2_5 - 0.000353508924937556*G0_0_1_2_6 + 0.000528571957143493*G0_0_1_2_7 + 0.00184408184408213*G0_0_1_2_8 + 0.00170749885035628*G0_0_1_2_9 - 0.00277986563700901*G0_0_1_3_0 - 0.07687719687721*G0_0_1_3_1 - 0.00919250062107362*G0_0_1_3_2 - 0.159920079920107*G0_0_1_3_3 + 0.0460568003425225*G0_0_1_3_4 + 0.00215403643975109*G0_0_1_3_5 - 0.000825840825840951*G0_0_1_3_6 + 0.00918700347271942*G0_0_1_3_7 - 0.00450216450216546*G0_0_1_3_8 - 0.00324247181390109*G0_0_1_3_9 + 0.00047021761307485*G0_0_1_4_0 + 0.0322936322936378*G0_0_1_4_1 + 0.00284498570212905*G0_0_1_4_2 + 0.0460568003425225*G0_0_1_4_3 - 0.0141686884544051*G0_0_1_4_4 - 0.000563246277532099*G0_0_1_4_5 + 0.00138908710337305*G0_0_1_4_6 - 0.00192188763617373*G0_0_1_4_7 - 0.00468483897055396*G0_0_1_4_8 - 0.00399600399600462*G0_0_1_4_9 + 0.00277944277944332*G0_0_1_5_0 + 0.00106137248994413*G0_0_1_5_1 + 0.00044696044696053*G0_0_1_5_2 + 0.00215403643975109*G0_0_1_5_3 - 0.000563246277532098*G0_0_1_5_4 + 0.00531658817373202*G0_0_1_5_5 - 0.00244707673279146*G0_0_1_5_6 + 0.00307502021787792*G0_0_1_5_7 - 0.00233671090813989*G0_0_1_5_8 - 0.000251177394034532*G0_0_1_5_9 - 0.00137132708561306*G0_0_1_6_0 + 0.000557749129177789*G0_0_1_6_1 - 0.000353508924937556*G0_0_1_6_2 - 0.000825840825840951*G0_0_1_6_3 + 0.00138908710337305*G0_0_1_6_4 - 0.00244707673279146*G0_0_1_6_5 + 0.00205128205128243*G0_0_1_6_6 - 0.00073830930973804*G0_0_1_6_7 - 0.0040264497407361*G0_0_1_6_8 - 0.00347081489938693*G0_0_1_6_9 + 0.00135864135864165*G0_0_1_7_0 + 0.0123550523550545*G0_0_1_7_1 + 0.000528571957143493*G0_0_1_7_2 + 0.00918700347271942*G0_0_1_7_3 - 0.00192188763617373*G0_0_1_7_4 + 0.00307502021787792*G0_0_1_7_5 - 0.00073830930973804*G0_0_1_7_6 + 0.0145873174444629*G0_0_1_7_7 - 0.0206688549545726*G0_0_1_7_8 - 0.00344798059083822*G0_0_1_7_9 + 0.00264243692815162*G0_0_1_8_0 - 0.0193820993821028*G0_0_1_8_1 + 0.00184408184408213*G0_0_1_8_2 - 0.00450216450216546*G0_0_1_8_3 - 0.00468483897055395*G0_0_1_8_4 - 0.00233671090813989*G0_0_1_8_5 - 0.0040264497407361*G0_0_1_8_6 - 0.0206688549545726*G0_0_1_8_7 + 0.0834099234099373*G0_0_1_8_8 + 0.0245012130726457*G0_0_1_8_9 + 0.00164153307010477*G0_0_1_9_0 - 0.00504384504384595*G0_0_1_9_1 + 0.00170749885035628*G0_0_1_9_2 - 0.00324247181390108*G0_0_1_9_3 - 0.00399600399600462*G0_0_1_9_4 - 0.000251177394034532*G0_0_1_9_5 - 0.00347081489938693*G0_0_1_9_6 - 0.00344798059083822*G0_0_1_9_7 + 0.0245012130726457*G0_0_1_9_8 + 0.0119195090623682*G0_0_1_9_9 + 0.00180066846733545*G0_1_0_0_0 - 0.000717078336126088*G0_1_0_0_1 - 0.000105714391428695*G0_1_0_0_2 - 0.00430379144664938*G0_1_0_0_3 + 0.000410066124351924*G0_1_0_0_4 - 0.00059067916210783*G0_1_0_0_5 + 0.000268937411794601*G0_1_0_0_6 - 0.00529010671867902*G0_1_0_0_7 + 0.00467088467088544*G0_1_0_0_8 - 0.0011968983397557*G0_1_0_0_9 - 0.000717078336126088*G0_1_0_1_0 - 0.0306064306064358*G0_1_0_1_1 - 0.00466272704368022*G0_1_0_1_2 - 0.0566455766455864*G0_1_0_1_3 + 0.0225019425019463*G0_1_0_1_4 + 0.000804433661576661*G0_1_0_1_5 + 0.000727367870225144*G0_1_0_1_6 + 0.000879120879120947*G0_1_0_1_8 - 0.00154512154512186*G0_1_0_1_9 - 0.000105714391428695*G0_1_0_2_0 - 0.00466272704368022*G0_1_0_2_1 - 0.000614975853071148*G0_1_0_2_2 - 0.00979782122639435*G0_1_0_2_3 + 0.00324009324009382*G0_1_0_2_4 + 0.000277183134326028*G0_1_0_2_5 - 0.000530104815819162*G0_1_0_2_6 - 0.000552780552780628*G0_1_0_2_7 + 0.00261976119119018*G0_1_0_2_8 + 0.00152038437752749*G0_1_0_2_9 - 0.00430379144664938*G0_1_0_3_0 - 0.0566455766455864*G0_1_0_3_1 - 0.00979782122639435*G0_1_0_3_2 - 0.277022977023025*G0_1_0_3_3 + 0.0484472670187039*G0_1_0_3_4 + 0.00494362780077149*G0_1_0_3_5 - 0.00157128585700039*G0_1_0_3_6 + 0.0135221920936231*G0_1_0_3_7 - 0.00627372627372758*G0_1_0_3_8 - 0.0224090195518807*G0_1_0_3_9 + 0.000410066124351923*G0_1_0_4_0 + 0.0225019425019463*G0_1_0_4_1 + 0.00324009324009382*G0_1_0_4_2 + 0.0484472670187039*G0_1_0_4_3 - 0.0164464107321278*G0_1_0_4_4 - 0.000619380619380734*G0_1_0_4_5 + 0.00219066647638113*G0_1_0_4_6 - 0.00724846581989551*G0_1_0_4_8 - 0.00332239189382099*G0_1_0_4_9 - 0.00059067916210783*G0_1_0_5_0 + 0.000804433661576661*G0_1_0_5_1 + 0.000277183134326028*G0_1_0_5_2 + 0.00494362780077149*G0_1_0_5_3 - 0.000619380619380733*G0_1_0_5_4 - 0.00394177251320167*G0_1_0_5_5 - 0.00164407021549909*G0_1_0_5_6 - 0.000466676180961932*G0_1_0_5_7 - 0.00180248323105498*G0_1_0_5_8 + 0.00719566148137704*G0_1_0_5_9 + 0.000268937411794601*G0_1_0_6_0 + 0.000727367870225143*G0_1_0_6_1 - 0.000530104815819162*G0_1_0_6_2 - 0.00157128585700039*G0_1_0_6_3 + 0.00219066647638113*G0_1_0_6_4 - 0.00164407021549909*G0_1_0_6_5 - 0.000853432282003791*G0_1_0_6_6 + 0.0022691594120169*G0_1_0_6_7 - 0.00532610246896048*G0_1_0_6_8 - 0.00141858141858168*G0_1_0_6_9 - 0.00529010671867902*G0_1_0_7_0 - 0.000552780552780628*G0_1_0_7_2 + 0.0135221920936231*G0_1_0_7_3 - 0.000466676180961932*G0_1_0_7_5 + 0.0022691594120169*G0_1_0_7_6 - 0.0150649350649376*G0_1_0_7_7 - 0.00988582845725862*G0_1_0_7_8 - 0.000947623804766719*G0_1_0_7_9 + 0.00467088467088544*G0_1_0_8_0 + 0.000879120879120947*G0_1_0_8_1 + 0.00261976119119018*G0_1_0_8_2 - 0.00627372627372758*G0_1_0_8_3 - 0.00724846581989551*G0_1_0_8_4 - 0.00180248323105498*G0_1_0_8_5 - 0.00532610246896048*G0_1_0_8_6 - 0.00988582845725862*G0_1_0_8_7 + 0.0649950049950157*G0_1_0_8_8 + 0.0191322962751565*G0_1_0_8_9 - 0.0011968983397557*G0_1_0_9_0 - 0.00154512154512186*G0_1_0_9_1 + 0.00152038437752749*G0_1_0_9_2 - 0.0224090195518807*G0_1_0_9_3 - 0.00332239189382099*G0_1_0_9_4 + 0.00719566148137704*G0_1_0_9_5 - 0.00141858141858168*G0_1_0_9_6 - 0.00094762380476672*G0_1_0_9_7 + 0.0191322962751565*G0_1_0_9_8 + 0.0674068788354615*G0_1_0_9_9 - 0.00221013554346926*G0_1_1_0_0 - 0.00396245729579133*G0_1_1_0_1 - 0.000418488037535731*G0_1_1_0_2 - 0.00368731797303292*G0_1_1_0_3 + 0.00113198970341848*G0_1_1_0_4 - 0.00186184186184218*G0_1_1_0_5 + 0.000913795199509645*G0_1_1_0_6 - 0.00465608465608544*G0_1_1_0_7 + 0.00426451855023355*G0_1_1_0_8 - 0.000134468705897319*G0_1_1_0_9 - 0.00396245729579133*G0_1_1_1_0 - 0.125800125800147*G0_1_1_1_1 - 0.00755392755392883*G0_1_1_1_2 - 0.0815184815184954*G0_1_1_1_3 + 0.0345787545787604*G0_1_1_1_4 + 0.000153920153920213*G0_1_1_1_5 + 0.00121952121952142*G0_1_1_1_6 + 0.0139771339771364*G0_1_1_1_7 - 0.0253968253968298*G0_1_1_1_8 - 0.00681984681984803*G0_1_1_1_9 - 0.000418488037535731*G0_1_1_2_0 - 0.00755392755392883*G0_1_1_2_1 - 0.000870522775284829*G0_1_1_2_2 - 0.0101921359064234*G0_1_1_2_3 + 0.00320399177542089*G0_1_1_2_4 - 0.000552674838389216*G0_1_1_2_5 + 0.000112057254914429*G0_1_1_2_7 + 0.00142756714185307*G0_1_1_2_8 + 0.000626674912389294*G0_1_1_2_9 - 0.00368731797303292*G0_1_1_3_0 - 0.0815184815184954*G0_1_1_3_1 - 0.0101921359064234*G0_1_1_3_2 - 0.173906093906124*G0_1_1_3_3 + 0.0513086913087001*G0_1_1_3_4 + 0.00371818657533006*G0_1_1_3_5 - 0.000494743351886274*G0_1_1_3_6 + 0.0142257742257767*G0_1_1_3_7 - 0.0131068931068955*G0_1_1_3_8 - 0.00799200799200951*G0_1_1_3_9 + 0.00113198970341848*G0_1_1_4_0 + 0.0345787545787604*G0_1_1_4_1 + 0.00320399177542089*G0_1_1_4_2 + 0.0513086913087001*G0_1_1_4_3 - 0.0163950335378934*G0_1_1_4_4 - 0.000232148803577423*G0_1_1_4_5 + 0.000726892155463701*G0_1_1_4_6 - 0.00344798059083836*G0_1_1_4_7 - 0.00111888111888121*G0_1_1_4_8 - 0.00141572713001303*G0_1_1_4_9 - 0.00186184186184218*G0_1_1_5_0 + 0.000153920153920213*G0_1_1_5_1 - 0.000552674838389216*G0_1_1_5_2 + 0.00371818657533006*G0_1_1_5_3 - 0.000232148803577423*G0_1_1_5_4 - 0.00866942581228442*G0_1_1_5_5 + 0.00280481423338613*G0_1_1_5_6 - 0.00552970838685217*G0_1_1_5_7 + 0.00270205984491745*G0_1_1_5_8 - 0.00500071357214296*G0_1_1_5_9 + 0.000913795199509645*G0_1_1_6_0 + 0.00121952121952142*G0_1_1_6_1 - 0.000494743351886275*G0_1_1_6_3 + 0.000726892155463701*G0_1_1_6_4 + 0.00280481423338613*G0_1_1_6_5 - 0.000175063032205929*G0_1_1_6_6 + 0.00282764854193472*G0_1_1_6_7 - 0.00555254269540075*G0_1_1_6_8 - 0.000890538033395338*G0_1_1_6_9 - 0.00465608465608544*G0_1_1_7_0 + 0.0139771339771364*G0_1_1_7_1 + 0.000112057254914429*G0_1_1_7_2 + 0.0142257742257767*G0_1_1_7_3 - 0.00344798059083836*G0_1_1_7_4 - 0.00552970838685217*G0_1_1_7_5 + 0.00282764854193472*G0_1_1_7_6 + 0.000228343085486029*G0_1_1_7_7 - 0.00879120879121021*G0_1_1_7_8 - 0.00525189096617749*G0_1_1_7_9 + 0.00426451855023355*G0_1_1_8_0 - 0.0253968253968298*G0_1_1_8_1 + 0.00142756714185307*G0_1_1_8_2 - 0.0131068931068955*G0_1_1_8_3 - 0.00111888111888122*G0_1_1_8_4 + 0.00270205984491745*G0_1_1_8_5 - 0.00555254269540075*G0_1_1_8_6 - 0.00879120879121021*G0_1_1_8_7 + 0.0690509490509605*G0_1_1_8_8 + 0.0226973026973064*G0_1_1_8_9 - 0.000134468705897319*G0_1_1_9_0 - 0.00681984681984803*G0_1_1_9_1 + 0.000626674912389294*G0_1_1_9_2 - 0.00799200799200951*G0_1_1_9_3 - 0.00141572713001303*G0_1_1_9_4 - 0.00500071357214296*G0_1_1_9_5 - 0.000890538033395338*G0_1_1_9_6 - 0.00525189096617749*G0_1_1_9_7 + 0.0226973026973064*G0_1_1_9_8 + 0.00602825745682986*G0_1_1_9_9;
    A[212] = 0.00151284341760561*G0_0_1_0_0 + 0.00231632564965936*G0_0_1_0_2 + 0.000520431949003478*G0_0_1_0_3 - 0.000449550449550561*G0_0_1_0_4 - 0.00243106100248998*G0_0_1_0_5 + 0.0088933288933304*G0_0_1_0_6 + 0.000586873444016426*G0_0_1_0_7 - 0.000544851973423506*G0_0_1_0_8 + 0.00207601921887671*G0_0_1_0_9 - 0.0015128434176056*G0_0_1_1_1 - 0.0023163256496594*G0_0_1_1_2 + 0.00243106100249*G0_0_1_1_3 - 0.00889332889333044*G0_0_1_1_4 - 0.000520431949003462*G0_0_1_1_5 + 0.000449550449550516*G0_0_1_1_6 + 0.000544851973423503*G0_0_1_1_7 - 0.000586873444016413*G0_0_1_1_8 - 0.00207601921887672*G0_0_1_1_9 + 0.00231632564965936*G0_0_1_2_0 - 0.0023163256496594*G0_0_1_2_1 + 0.011899211899214*G0_0_1_2_3 - 0.0381840381840449*G0_0_1_2_4 - 0.0118992118992138*G0_0_1_2_5 + 0.0381840381840445*G0_0_1_2_6 + 0.000502830502830597*G0_0_1_2_7 - 0.000502830502830581*G0_0_1_2_8 + 0.000520431949003478*G0_0_1_3_0 + 0.00243106100249*G0_0_1_3_1 + 0.011899211899214*G0_0_1_3_2 - 0.00755244755244895*G0_0_1_3_3 + 0.0445054945055022*G0_0_1_3_4 - 0.00134865134865148*G0_0_1_3_6 - 0.00156129584701039*G0_0_1_3_7 + 5.2804338518614e-05*G0_0_1_3_8 + 0.00935064935065095*G0_0_1_3_9 - 0.00044955044955056*G0_0_1_4_0 - 0.00889332889333044*G0_0_1_4_1 - 0.0381840381840449*G0_0_1_4_2 + 0.0445054945055022*G0_0_1_4_3 - 0.0998001998002173*G0_0_1_4_4 + 0.00134865134865167*G0_0_1_4_5 - 7.99200799200889e-05*G0_0_1_4_7 + 0.00150849150849177*G0_0_1_4_8 - 0.00269730269730321*G0_0_1_4_9 - 0.00243106100248998*G0_0_1_5_0 - 0.000520431949003462*G0_0_1_5_1 - 0.0118992118992138*G0_0_1_5_2 + 0.00134865134865167*G0_0_1_5_4 + 0.00755244755244878*G0_0_1_5_5 - 0.044505494505502*G0_0_1_5_6 - 5.28043385186278e-05*G0_0_1_5_7 + 0.00156129584701039*G0_0_1_5_8 - 0.00935064935065091*G0_0_1_5_9 + 0.0088933288933304*G0_0_1_6_0 + 0.000449550449550515*G0_0_1_6_1 + 0.0381840381840445*G0_0_1_6_2 - 0.00134865134865147*G0_0_1_6_3 - 0.044505494505502*G0_0_1_6_5 + 0.0998001998002165*G0_0_1_6_6 - 0.00150849150849176*G0_0_1_6_7 + 7.99200799201253e-05*G0_0_1_6_8 + 0.00269730269730304*G0_0_1_6_9 + 0.000586873444016426*G0_0_1_7_0 + 0.000544851973423503*G0_0_1_7_1 + 0.000502830502830597*G0_0_1_7_2 - 0.00156129584701039*G0_0_1_7_3 - 7.99200799200887e-05*G0_0_1_7_4 - 5.28043385186278e-05*G0_0_1_7_5 - 0.00150849150849176*G0_0_1_7_6 + 0.00235478806907428*G0_0_1_7_7 - 0.00321107463964659*G0_0_1_7_9 - 0.000544851973423506*G0_0_1_8_0 - 0.000586873444016413*G0_0_1_8_1 - 0.000502830502830581*G0_0_1_8_2 + 5.28043385186141e-05*G0_0_1_8_3 + 0.00150849150849177*G0_0_1_8_4 + 0.00156129584701039*G0_0_1_8_5 + 7.99200799201253e-05*G0_0_1_8_6 - 0.00235478806907419*G0_0_1_8_8 + 0.00321107463964661*G0_0_1_8_9 + 0.00207601921887671*G0_0_1_9_0 - 0.00207601921887672*G0_0_1_9_1 + 0.00935064935065095*G0_0_1_9_3 - 0.00269730269730322*G0_0_1_9_4 - 0.00935064935065091*G0_0_1_9_5 + 0.00269730269730304*G0_0_1_9_6 - 0.00321107463964659*G0_0_1_9_7 + 0.00321107463964661*G0_0_1_9_8 + 0.00289812480288722*G0_1_1_0_0 + 0.000136565374660638*G0_1_1_0_1 - 0.00342817676151069*G0_1_1_0_2 + 0.00392258535115745*G0_1_1_0_3 - 0.00563785420928377*G0_1_1_0_4 + 0.00219288647860115*G0_1_1_0_5 - 0.00414125556982771*G0_1_1_0_6 + 0.00249861249861295*G0_1_1_0_7 - 0.000886098028955323*G0_1_1_0_8 - 0.0017753674896535*G0_1_1_0_9 + 0.000136565374660638*G0_1_1_1_0 + 0.00138528138528163*G0_1_1_1_1 - 0.00574450241117006*G0_1_1_1_2 + 0.00462394748109114*G0_1_1_1_3 - 0.0130345844631581*G0_1_1_1_4 + 0.00340215340215398*G0_1_1_1_5 - 0.00518830375973322*G0_1_1_1_6 - 0.000341246055531836*G0_1_1_1_7 + 0.00191173905459654*G0_1_1_1_8 - 0.00385138670853022*G0_1_1_1_9 - 0.00342817676151069*G0_1_1_2_0 - 0.00574450241117006*G0_1_1_2_1 - 0.0566199232865995*G0_1_1_2_2 + 0.0276212676212723*G0_1_1_2_3 - 0.0671273171273285*G0_1_1_2_4 + 0.0157220557220584*G0_1_1_2_5 - 0.0289432789432838*G0_1_1_2_6 + 0.00305250305250356*G0_1_1_2_7 + 0.00254967254967297*G0_1_1_2_8 - 0.00438228438228512*G0_1_1_2_9 + 0.00392258535115745*G0_1_1_3_0 + 0.00462394748109114*G0_1_1_3_1 + 0.0276212676212723*G0_1_1_3_2 - 0.00675610104181653*G0_1_1_3_3 + 0.0575724275724374*G0_1_1_3_4 - 0.0134893677750843*G0_1_1_3_5 + 0.0205694305694341*G0_1_1_3_6 - 0.0067632367632379*G0_1_1_3_7 + 0.00940773512202241*G0_1_1_3_8 + 0.0250806336520664*G0_1_1_3_9 - 0.00563785420928377*G0_1_1_4_0 - 0.0130345844631581*G0_1_1_4_1 - 0.0671273171273285*G0_1_1_4_2 + 0.0575724275724374*G0_1_1_4_3 - 0.138581418581442*G0_1_1_4_4 + 0.0219180819180857*G0_1_1_4_5 - 0.0424875124875197*G0_1_1_4_6 + 0.00137576709005304*G0_1_1_4_7 - 0.00264449835878452*G0_1_1_4_8 - 0.0306893106893159*G0_1_1_4_9 + 0.00219288647860115*G0_1_1_5_0 + 0.00340215340215398*G0_1_1_5_1 + 0.0157220557220584*G0_1_1_5_2 - 0.0134893677750843*G0_1_1_5_3 + 0.0219180819180856*G0_1_1_5_4 + 0.000796346510632307*G0_1_1_5_5 + 0.0130669330669353*G0_1_1_5_6 + 0.00935493078350376*G0_1_1_5_7 - 0.0052019409162275*G0_1_1_5_8 + 0.0157299843014155*G0_1_1_5_9 - 0.00414125556982771*G0_1_1_6_0 - 0.00518830375973322*G0_1_1_6_1 - 0.0289432789432838*G0_1_1_6_2 + 0.0205694305694341*G0_1_1_6_3 - 0.0424875124875197*G0_1_1_6_4 + 0.0130669330669353*G0_1_1_6_5 - 0.0387812187812253*G0_1_1_6_6 - 0.00415298986727628*G0_1_1_6_7 + 0.00145568716997314*G0_1_1_6_8 - 0.0279920079920127*G0_1_1_6_9 + 0.00249861249861295*G0_1_1_7_0 - 0.000341246055531836*G0_1_1_7_1 + 0.00305250305250356*G0_1_1_7_2 - 0.0067632367632379*G0_1_1_7_3 + 0.00137576709005304*G0_1_1_7_4 + 0.00935493078350376*G0_1_1_7_5 - 0.00415298986727628*G0_1_1_7_6 + 0.0608648494362883*G0_1_1_7_7 - 0.00633223918938315*G0_1_1_7_8 + 0.0136320822035131*G0_1_1_7_9 - 0.000886098028955323*G0_1_1_8_0 + 0.00191173905459654*G0_1_1_8_1 + 0.00254967254967297*G0_1_1_8_2 + 0.00940773512202241*G0_1_1_8_3 - 0.00264449835878452*G0_1_1_8_4 - 0.0052019409162275*G0_1_1_8_5 + 0.00145568716997314*G0_1_1_8_6 - 0.00633223918938315*G0_1_1_8_7 + 0.0585100613672142*G0_1_1_8_8 + 0.0168431568431597*G0_1_1_8_9 - 0.0017753674896535*G0_1_1_9_0 - 0.00385138670853022*G0_1_1_9_1 - 0.00438228438228512*G0_1_1_9_2 + 0.0250806336520664*G0_1_1_9_3 - 0.0306893106893159*G0_1_1_9_4 + 0.0157299843014155*G0_1_1_9_5 - 0.0279920079920127*G0_1_1_9_6 + 0.0136320822035131*G0_1_1_9_7 + 0.0168431568431597*G0_1_1_9_8 + 0.0528157556729072*G0_1_1_9_9;
    A[1] = A[16] + 0.00869899500852035*G0_0_0_0_0 - 0.00453085384633083*G0_0_0_0_1 - 0.00304913010270206*G0_0_0_0_3 + 0.00121600951958116*G0_0_0_0_4 + 0.00568461300604257*G0_0_0_0_5 - 0.00220808952951849*G0_0_0_0_6 + 0.00382492507492575*G0_0_0_0_7 - 0.00610014985015091*G0_0_0_0_8 - 0.000780885780885911*G0_0_0_0_9 - 0.00453085384633083*G0_0_0_1_0 - 0.0952357827357991*G0_0_0_1_1 - 0.00443448636901093*G0_0_0_1_2 - 0.0411505624005694*G0_0_0_1_3 + 0.0195331982832016*G0_0_0_1_4 + 0.000977398923827694*G0_0_0_1_5 + 0.000574983878555389*G0_0_0_1_6 + 0.0210703648203685*G0_0_0_1_7 - 0.0458485495985575*G0_0_0_1_8 - 0.00629481629481739*G0_0_0_1_9 - 0.00443448636901093*G0_0_0_2_1 - 0.00274697524697571*G0_0_0_2_2 - 0.00407230335801833*G0_0_0_2_3 + 0.00179530125958728*G0_0_0_2_4 + 0.00135692349978087*G0_0_0_2_5 - 0.0010429980072839*G0_0_0_2_6 + 0.00139341148269743*G0_0_0_2_7 - 0.00327414318485802*G0_0_0_2_8 - 0.000634880992023958*G0_0_0_2_9 - 0.00304913010270206*G0_0_0_3_0 - 0.0411505624005694*G0_0_0_3_1 - 0.00407230335801833*G0_0_0_3_2 - 0.0460273060273139*G0_0_0_3_3 + 0.0192551793444683*G0_0_0_3_4 + 0.00117995100137978*G0_0_0_3_5 + 0.0021303398981974*G0_0_0_3_6 + 0.0130026818419698*G0_0_0_3_7 - 0.0266804029304075*G0_0_0_3_8 - 0.00712091479948746*G0_0_0_3_9 + 0.00121600951958116*G0_0_0_4_0 + 0.0195331982832016*G0_0_0_4_1 + 0.00179530125958728*G0_0_0_4_2 + 0.0192551793444683*G0_0_0_4_3 - 0.0102291755863202*G0_0_0_4_4 + 0.000207262975120149*G0_0_0_4_5 - 0.00233760287331755*G0_0_0_4_6 - 0.00584177727034969*G0_0_0_4_7 + 0.0136777210884377*G0_0_0_4_8 + 0.00149011702583158*G0_0_0_4_9 + 0.00568461300604257*G0_0_0_5_0 + 0.000977398923827694*G0_0_0_5_1 + 0.00135692349978087*G0_0_0_5_2 + 0.00117995100137978*G0_0_0_5_3 + 0.000207262975120149*G0_0_0_5_4 + 0.00127658056229511*G0_0_0_5_5 - 0.00288220707863615*G0_0_0_5_6 - 0.000598151848151951*G0_0_0_5_7 + 0.000923094762380647*G0_0_0_5_8 + 0.000496467817896482*G0_0_0_5_9 - 0.00220808952951849*G0_0_0_6_0 + 0.000574983878555389*G0_0_0_6_1 - 0.0010429980072839*G0_0_0_6_2 + 0.0021303398981974*G0_0_0_6_3 - 0.00233760287331755*G0_0_0_6_4 - 0.00288220707863614*G0_0_0_6_5 - 0.00685635792778765*G0_0_0_6_6 - 0.000324942914228681*G0_0_0_6_7 + 0.00212109319252211*G0_0_0_6_8 - 0.00235603682032293*G0_0_0_6_9 + 0.00382492507492575*G0_0_0_7_0 + 0.0210703648203685*G0_0_0_7_1 + 0.00139341148269743*G0_0_0_7_2 + 0.0130026818419698*G0_0_0_7_3 - 0.00584177727034969*G0_0_0_7_4 - 0.000598151848151951*G0_0_0_7_5 - 0.000324942914228681*G0_0_0_7_6 - 0.0153346653346679*G0_0_0_7_7 + 0.0248011809618995*G0_0_0_7_8 + 0.00299254317111511*G0_0_0_7_9 - 0.00610014985015091*G0_0_0_8_0 - 0.0458485495985575*G0_0_0_8_1 - 0.00327414318485802*G0_0_0_8_2 - 0.0266804029304075*G0_0_0_8_3 + 0.0136777210884377*G0_0_0_8_4 + 0.000923094762380647*G0_0_0_8_5 + 0.00212109319252211*G0_0_0_8_6 + 0.0248011809618995*G0_0_0_8_7 - 0.0592657342657443*G0_0_0_8_8 - 0.00847099329242332*G0_0_0_8_9 - 0.000780885780885911*G0_0_0_9_0 - 0.00629481629481739*G0_0_0_9_1 - 0.000634880992023958*G0_0_0_9_2 - 0.00712091479948746*G0_0_0_9_3 + 0.00149011702583158*G0_0_0_9_4 + 0.000496467817896482*G0_0_0_9_5 - 0.00235603682032293*G0_0_0_9_6 + 0.00299254317111511*G0_0_0_9_7 - 0.00847099329242332*G0_0_0_9_8 - 0.0100421007563882*G0_0_0_9_9 + 0.0108191962358648*G0_1_0_0_0 + 0.00052394860430584*G0_1_0_0_1 + 0.000620316081625713*G0_1_0_0_2 + 0.000227512236440845*G0_1_0_0_3 - 0.000174902808831411*G0_1_0_0_4 + 0.00659231971732086*G0_1_0_0_5 - 0.00269179894179941*G0_1_0_0_6 + 0.00189433251933286*G0_1_0_0_7 - 0.00115463240463261*G0_1_0_0_8 + 0.000290959040959097*G0_1_0_0_9 + 0.00052394860430584*G0_1_0_1_0 + 0.0108191962358647*G0_1_0_1_1 + 0.000620316081625708*G0_1_0_1_2 + 0.00659231971732082*G0_1_0_1_3 - 0.00269179894179939*G0_1_0_1_4 + 0.000227512236440844*G0_1_0_1_5 - 0.000174902808831409*G0_1_0_1_6 - 0.0011546324046326*G0_1_0_1_7 + 0.00189433251933285*G0_1_0_1_8 + 0.000290959040959093*G0_1_0_1_9 + 0.000620316081625713*G0_1_0_2_0 + 0.000620316081625708*G0_1_0_2_1 - 0.000626774019631271*G0_1_0_2_2 + 0.000873214087499947*G0_1_0_2_3 - 0.000135291296005604*G0_1_0_2_4 + 0.000873214087499953*G0_1_0_2_5 - 0.000135291296005607*G0_1_0_2_6 + 0.000436963829821047*G0_1_0_2_9 + 0.000227512236440845*G0_1_0_3_0 + 0.00659231971732082*G0_1_0_3_1 + 0.000873214087499947*G0_1_0_3_2 + 0.0107513320013338*G0_1_0_3_3 - 0.00481814316635825*G0_1_0_3_4 - 0.000427816231387732*G0_1_0_3_5 - 0.00119197766519215*G0_1_0_3_7 + 0.00170891608391637*G0_1_0_3_8 + 0.00151107820750704*G0_1_0_3_9 - 0.000174902808831411*G0_1_0_4_0 - 0.00269179894179939*G0_1_0_4_1 - 0.000135291296005604*G0_1_0_4_2 - 0.00481814316635825*G0_1_0_4_3 + 0.00261839351125108*G0_1_0_4_4 + 0.000513325959754617*G0_1_0_4_7 - 0.000516938418724219*G0_1_0_4_8 - 0.00134142643071238*G0_1_0_4_9 + 0.00659231971732086*G0_1_0_5_0 + 0.000227512236440844*G0_1_0_5_1 + 0.000873214087499953*G0_1_0_5_2 - 0.000427816231387732*G0_1_0_5_3 + 0.0107513320013338*G0_1_0_5_5 - 0.00481814316635827*G0_1_0_5_6 + 0.00170891608391638*G0_1_0_5_7 - 0.00119197766519216*G0_1_0_5_8 + 0.00151107820750704*G0_1_0_5_9 - 0.00269179894179941*G0_1_0_6_0 - 0.000174902808831409*G0_1_0_6_1 - 0.000135291296005607*G0_1_0_6_2 - 0.00481814316635827*G0_1_0_6_5 + 0.00261839351125109*G0_1_0_6_6 - 0.000516938418724223*G0_1_0_6_7 + 0.00051332595975462*G0_1_0_6_8 - 0.00134142643071238*G0_1_0_6_9 + 0.00189433251933286*G0_1_0_7_0 - 0.0011546324046326*G0_1_0_7_1 - 0.00119197766519215*G0_1_0_7_3 + 0.000513325959754617*G0_1_0_7_4 + 0.00170891608391638*G0_1_0_7_5 - 0.000516938418724223*G0_1_0_7_6 - 0.00248709623709664*G0_1_0_7_7 + 0.000727858451072852*G0_1_0_7_8 + 0.000160999714571173*G0_1_0_7_9 - 0.00115463240463261*G0_1_0_8_0 + 0.00189433251933285*G0_1_0_8_1 + 0.00170891608391637*G0_1_0_8_3 - 0.000516938418724219*G0_1_0_8_4 - 0.00119197766519216*G0_1_0_8_5 + 0.00051332595975462*G0_1_0_8_6 + 0.000727858451072852*G0_1_0_8_7 - 0.00248709623709665*G0_1_0_8_8 + 0.000160999714571168*G0_1_0_8_9 + 0.000290959040959097*G0_1_0_9_0 + 0.000290959040959092*G0_1_0_9_1 + 0.000436963829821047*G0_1_0_9_2 + 0.00151107820750704*G0_1_0_9_3 - 0.00134142643071238*G0_1_0_9_4 + 0.00151107820750704*G0_1_0_9_5 - 0.00134142643071238*G0_1_0_9_6 + 0.000160999714571173*G0_1_0_9_7 + 0.000160999714571168*G0_1_0_9_8 + 0.00183352361923822*G0_1_0_9_9;
    A[27] = A[181] - 0.00237293570626945*G0_0_1_0_0 - 0.0008015441348776*G0_0_1_0_1 + 0.000133992991135881*G0_0_1_0_3 - 0.000287014572728912*G0_0_1_0_4 - 0.000945562374133963*G0_0_1_0_5 + 0.00435770578627794*G0_0_1_0_7 - 0.00223522509236832*G0_0_1_0_8 + 0.00133390419104727*G0_0_1_0_9 - 0.0008015441348776*G0_0_1_1_0 + 0.000797104130437605*G0_0_1_1_2 + 0.0109668109668129*G0_0_1_1_3 - 0.00275280275280324*G0_0_1_1_4 + 0.000498390498390585*G0_0_1_1_5 - 0.000493950493950583*G0_0_1_1_6 + 0.00674880674880786*G0_0_1_1_7 - 0.0109668109668128*G0_0_1_1_8 - 0.00399600399600465*G0_0_1_1_9 + 0.000797104130437605*G0_0_1_2_1 - 0.000273025034929846*G0_0_1_2_2 + 0.0022269793698369*G0_0_1_2_3 + 0.00142825428539738*G0_0_1_2_4 - 0.000216291644863112*G0_0_1_2_5 + 0.00040832183689334*G0_0_1_2_6 + 0.00139891854177591*G0_0_1_2_7 - 0.00124462838748573*G0_0_1_2_8 + 0.00371628371628435*G0_0_1_2_9 + 0.000133992991135881*G0_0_1_3_0 + 0.0109668109668129*G0_0_1_3_1 + 0.0022269793698369*G0_0_1_3_2 + 0.0317482517482573*G0_0_1_3_3 - 0.0173126873126903*G0_0_1_3_4 - 0.000685029256457943*G0_0_1_3_5 + 0.000954759526188251*G0_0_1_3_6 - 0.000929070929071129*G0_0_1_3_7 - 0.00227772227772258*G0_0_1_3_8 + 0.0138461538461562*G0_0_1_3_9 - 0.000287014572728912*G0_0_1_4_0 - 0.00275280275280324*G0_0_1_4_1 + 0.00142825428539738*G0_0_1_4_2 - 0.0173126873126903*G0_0_1_4_3 + 0.010383901812475*G0_0_1_4_4 + 0.000333951762523247*G0_0_1_4_5 - 0.0012887112887115*G0_0_1_4_6 - 0.00140430997573876*G0_0_1_4_7 + 0.00320679320679371*G0_0_1_4_8 - 0.0118167546738995*G0_0_1_4_9 - 0.000945562374133963*G0_0_1_5_0 + 0.000498390498390585*G0_0_1_5_1 - 0.000216291644863112*G0_0_1_5_2 - 0.000685029256457943*G0_0_1_5_3 + 0.000333951762523247*G0_0_1_5_4 + 0.00029970029970032*G0_0_1_5_5 + 0.00102754388468691*G0_0_1_5_6 + 0.00674611103182645*G0_0_1_5_7 - 0.00202226345083522*G0_0_1_5_8 - 0.000493950493950583*G0_0_1_6_1 + 0.00040832183689334*G0_0_1_6_2 + 0.000954759526188251*G0_0_1_6_3 - 0.0012887112887115*G0_0_1_6_4 + 0.00102754388468691*G0_0_1_6_5 + 0.00175538746967349*G0_0_1_6_6 - 0.00472384758099122*G0_0_1_6_7 + 0.0028714142999862*G0_0_1_6_8 - 0.0130583702012296*G0_0_1_6_9 + 0.00435770578627794*G0_0_1_7_0 + 0.00674880674880786*G0_0_1_7_1 + 0.00139891854177591*G0_0_1_7_2 - 0.000929070929071129*G0_0_1_7_3 - 0.00140430997573876*G0_0_1_7_4 + 0.00674611103182645*G0_0_1_7_5 - 0.00472384758099122*G0_0_1_7_6 + 0.0318824033109801*G0_0_1_7_7 - 0.00438561438561516*G0_0_1_7_8 + 0.00544598258884064*G0_0_1_7_9 - 0.00223522509236832*G0_0_1_8_0 - 0.0109668109668128*G0_0_1_8_1 - 0.00124462838748573*G0_0_1_8_2 - 0.00227772227772258*G0_0_1_8_3 + 0.00320679320679371*G0_0_1_8_4 - 0.00202226345083522*G0_0_1_8_5 + 0.0028714142999862*G0_0_1_8_6 - 0.00438561438561516*G0_0_1_8_7 - 0.0271928071928117*G0_0_1_8_8 + 0.00557442557442654*G0_0_1_8_9 + 0.00133390419104727*G0_0_1_9_0 - 0.00399600399600465*G0_0_1_9_1 + 0.00371628371628435*G0_0_1_9_2 + 0.0138461538461562*G0_0_1_9_3 - 0.0118167546738995*G0_0_1_9_4 - 0.0130583702012296*G0_0_1_9_6 + 0.00544598258884064*G0_0_1_9_7 + 0.00557442557442654*G0_0_1_9_8 - 0.0267161410018597*G0_0_1_9_9 + 0.00237293570626945*G0_1_0_0_0 + 0.0008015441348776*G0_1_0_0_1 - 0.000133992991135881*G0_1_0_0_3 + 0.000287014572728912*G0_1_0_0_4 + 0.000945562374133963*G0_1_0_0_5 - 0.00435770578627794*G0_1_0_0_7 + 0.00223522509236832*G0_1_0_0_8 - 0.00133390419104727*G0_1_0_0_9 + 0.0008015441348776*G0_1_0_1_0 - 0.000797104130437604*G0_1_0_1_2 - 0.0109668109668129*G0_1_0_1_3 + 0.00275280275280324*G0_1_0_1_4 - 0.000498390498390585*G0_1_0_1_5 + 0.000493950493950583*G0_1_0_1_6 - 0.00674880674880786*G0_1_0_1_7 + 0.0109668109668128*G0_1_0_1_8 + 0.00399600399600465*G0_1_0_1_9 - 0.000797104130437604*G0_1_0_2_1 + 0.000273025034929846*G0_1_0_2_2 - 0.0022269793698369*G0_1_0_2_3 - 0.00142825428539738*G0_1_0_2_4 + 0.000216291644863113*G0_1_0_2_5 - 0.00040832183689334*G0_1_0_2_6 - 0.00139891854177591*G0_1_0_2_7 + 0.00124462838748573*G0_1_0_2_8 - 0.00371628371628435*G0_1_0_2_9 - 0.000133992991135881*G0_1_0_3_0 - 0.0109668109668129*G0_1_0_3_1 - 0.0022269793698369*G0_1_0_3_2 - 0.0317482517482573*G0_1_0_3_3 + 0.0173126873126903*G0_1_0_3_4 + 0.000685029256457943*G0_1_0_3_5 - 0.00095475952618825*G0_1_0_3_6 + 0.000929070929071129*G0_1_0_3_7 + 0.00227772227772258*G0_1_0_3_8 - 0.0138461538461562*G0_1_0_3_9 + 0.000287014572728912*G0_1_0_4_0 + 0.00275280275280324*G0_1_0_4_1 - 0.00142825428539738*G0_1_0_4_2 + 0.0173126873126903*G0_1_0_4_3 - 0.010383901812475*G0_1_0_4_4 - 0.000333951762523247*G0_1_0_4_5 + 0.0012887112887115*G0_1_0_4_6 + 0.00140430997573876*G0_1_0_4_7 - 0.00320679320679371*G0_1_0_4_8 + 0.0118167546738995*G0_1_0_4_9 + 0.000945562374133963*G0_1_0_5_0 - 0.000498390498390585*G0_1_0_5_1 + 0.000216291644863113*G0_1_0_5_2 + 0.000685029256457943*G0_1_0_5_3 - 0.000333951762523247*G0_1_0_5_4 - 0.00029970029970032*G0_1_0_5_5 - 0.00102754388468691*G0_1_0_5_6 - 0.00674611103182645*G0_1_0_5_7 + 0.00202226345083522*G0_1_0_5_8 + 0.000493950493950583*G0_1_0_6_1 - 0.00040832183689334*G0_1_0_6_2 - 0.000954759526188251*G0_1_0_6_3 + 0.0012887112887115*G0_1_0_6_4 - 0.00102754388468691*G0_1_0_6_5 - 0.00175538746967349*G0_1_0_6_6 + 0.00472384758099122*G0_1_0_6_7 - 0.0028714142999862*G0_1_0_6_8 + 0.0130583702012296*G0_1_0_6_9 - 0.00435770578627794*G0_1_0_7_0 - 0.00674880674880786*G0_1_0_7_1 - 0.00139891854177591*G0_1_0_7_2 + 0.000929070929071129*G0_1_0_7_3 + 0.00140430997573876*G0_1_0_7_4 - 0.00674611103182645*G0_1_0_7_5 + 0.00472384758099122*G0_1_0_7_6 - 0.0318824033109801*G0_1_0_7_7 + 0.00438561438561516*G0_1_0_7_8 - 0.00544598258884064*G0_1_0_7_9 + 0.00223522509236832*G0_1_0_8_0 + 0.0109668109668128*G0_1_0_8_1 + 0.00124462838748573*G0_1_0_8_2 + 0.00227772227772258*G0_1_0_8_3 - 0.00320679320679371*G0_1_0_8_4 + 0.00202226345083522*G0_1_0_8_5 - 0.0028714142999862*G0_1_0_8_6 + 0.00438561438561516*G0_1_0_8_7 + 0.0271928071928117*G0_1_0_8_8 - 0.00557442557442655*G0_1_0_8_9 - 0.00133390419104727*G0_1_0_9_0 + 0.00399600399600465*G0_1_0_9_1 - 0.00371628371628435*G0_1_0_9_2 - 0.0138461538461562*G0_1_0_9_3 + 0.0118167546738995*G0_1_0_9_4 + 0.0130583702012296*G0_1_0_9_6 - 0.00544598258884064*G0_1_0_9_7 - 0.00557442557442655*G0_1_0_9_8 + 0.0267161410018597*G0_1_0_9_9;
    A[46] = -0.000376695614790921*G0_0_0_0_0 + 0.00287397787397836*G0_0_0_0_1 - 0.000193677574629989*G0_0_0_0_2 + 0.00448532948533026*G0_0_0_0_3 - 0.00305205376634*G0_0_0_0_4 + 0.000163751592323045*G0_0_0_0_5 - 0.00104575318861051*G0_0_0_0_6 - 0.00158185729614328*G0_0_0_0_7 + 0.00371276871276934*G0_0_0_0_8 + 0.000279561708133184*G0_0_0_0_9 + 0.00287397787397836*G0_0_0_1_0 + 0.04288304288305*G0_0_0_1_1 + 0.00430587930588002*G0_0_0_1_2 + 0.0501683501683586*G0_0_0_1_3 - 0.0214183964184*G0_0_0_1_4 - 0.00144207644207669*G0_0_0_1_5 - 0.00210252710252746*G0_0_0_1_6 - 0.0125420875420896*G0_0_0_1_7 + 0.0250841750841793*G0_0_0_1_8 + 0.00733155733155859*G0_0_0_1_9 - 0.000193677574629989*G0_0_0_2_0 + 0.00430587930588002*G0_0_0_2_1 - 0.00739334739334863*G0_0_0_2_2 + 0.0101975801975819*G0_0_0_2_3 - 0.00552621981193502*G0_0_0_2_4 + 0.00247958390815575*G0_0_0_2_5 - 0.0062264719407587*G0_0_0_2_6 - 0.00213091141662606*G0_0_0_2_7 + 0.00371276871276933*G0_0_0_2_8 + 0.00137766994909876*G0_0_0_2_9 + 0.00448532948533026*G0_0_0_3_0 + 0.0501683501683586*G0_0_0_3_1 + 0.0101975801975819*G0_0_0_3_2 + 0.100749250749268*G0_0_0_3_3 - 0.0399450549450617*G0_0_0_3_4 - 0.00231768231768271*G0_0_0_3_5 + 0.0018131868131871*G0_0_0_3_6 - 0.017950382950386*G0_0_0_3_7 + 0.0335830835830892*G0_0_0_3_8 + 0.0139060939060963*G0_0_0_3_9 - 0.00305205376634*G0_0_0_4_0 - 0.0214183964184*G0_0_0_4_1 - 0.00552621981193502*G0_0_0_4_2 - 0.0399450549450617*G0_0_0_4_3 + 0.00337662337662395*G0_0_0_4_4 + 0.00466176680462473*G0_0_0_4_5 - 0.00647495361781184*G0_0_0_4_6 + 0.0100216450216467*G0_0_0_4_7 - 0.0156327006327033*G0_0_0_4_8 - 0.0134565434565457*G0_0_0_4_9 + 0.000163751592323045*G0_0_0_5_0 - 0.00144207644207669*G0_0_0_5_1 + 0.00247958390815575*G0_0_0_5_2 - 0.00231768231768271*G0_0_0_5_3 + 0.00466176680462473*G0_0_0_5_4 - 0.0166875981161723*G0_0_0_5_5 + 0.00561509918652871*G0_0_0_5_6 - 0.00173017458731773*G0_0_0_5_7 - 0.000168165168165199*G0_0_0_5_8 - 0.000502354788069157*G0_0_0_5_9 - 0.00104575318861051*G0_0_0_6_0 - 0.00210252710252746*G0_0_0_6_1 - 0.0062264719407587*G0_0_0_6_2 + 0.0018131868131871*G0_0_0_6_3 - 0.00647495361781184*G0_0_0_6_4 + 0.00561509918652871*G0_0_0_6_5 - 0.0353617810760727*G0_0_0_6_6 + 0.00189833975548293*G0_0_0_6_7 - 0.000168165168165197*G0_0_0_6_8 - 0.00775938347367048*G0_0_0_6_9 - 0.00158185729614328*G0_0_0_7_0 - 0.0125420875420896*G0_0_0_7_1 - 0.00213091141662606*G0_0_0_7_2 - 0.017950382950386*G0_0_0_7_3 + 0.0100216450216467*G0_0_0_7_4 - 0.00173017458731773*G0_0_0_7_5 + 0.00189833975548293*G0_0_0_7_6 + 0.00561105561105654*G0_0_0_7_7 - 0.0156327006327032*G0_0_0_7_8 - 0.00463536463536542*G0_0_0_7_9 + 0.00371276871276934*G0_0_0_8_0 + 0.0250841750841793*G0_0_0_8_1 + 0.00371276871276933*G0_0_0_8_2 + 0.0335830835830892*G0_0_0_8_3 - 0.0156327006327032*G0_0_0_8_4 - 0.000168165168165199*G0_0_0_8_5 - 0.000168165168165197*G0_0_0_8_6 - 0.0156327006327032*G0_0_0_8_7 + 0.0335830835830891*G0_0_0_8_8 + 0.00927072927073083*G0_0_0_8_9 + 0.000279561708133184*G0_0_0_9_0 + 0.00733155733155859*G0_0_0_9_1 + 0.00137766994909876*G0_0_0_9_2 + 0.0139060939060963*G0_0_0_9_3 - 0.0134565434565457*G0_0_0_9_4 - 0.000502354788069157*G0_0_0_9_5 - 0.00775938347367048*G0_0_0_9_6 - 0.00463536463536542*G0_0_0_9_7 + 0.00927072927073083*G0_0_0_9_8 - 0.0260139860139904*G0_0_0_9_9 + 0.00113558399272704*G0_1_0_0_0 + 0.0117478200811555*G0_1_0_0_1 + 0.000944003086860391*G0_1_0_0_2 + 0.00868964368964519*G0_1_0_0_3 - 0.00417748917748989*G0_1_0_0_4 - 0.000520749092177761*G0_1_0_0_5 - 0.000326736755308234*G0_1_0_0_6 - 0.00592851592851695*G0_1_0_0_7 + 0.0135714285714309*G0_1_0_0_8 + 0.00253857253857298*G0_1_0_0_9 + 0.0117478200811555*G0_1_0_1_0 + 0.228459195125901*G0_1_0_1_1 + 0.0117478200811554*G0_1_0_1_2 + 0.113297813297833*G0_1_0_1_3 - 0.0524753024753113*G0_1_0_1_4 - 0.00252247752247802*G0_1_0_1_5 - 0.00252247752247791*G0_1_0_1_6 - 0.0524753024753115*G0_1_0_1_7 + 0.113297813297833*G0_1_0_1_8 + 0.0166944166944196*G0_1_0_1_9 + 0.000944003086860391*G0_1_0_2_0 + 0.0117478200811554*G0_1_0_2_1 + 0.00113558399272705*G0_1_0_2_2 + 0.0135714285714309*G0_1_0_2_3 - 0.00592851592851692*G0_1_0_2_4 - 0.000326736755308243*G0_1_0_2_5 - 0.000520749092177745*G0_1_0_2_6 - 0.00417748917748988*G0_1_0_2_7 + 0.00868964368964515*G0_1_0_2_8 + 0.00253857253857297*G0_1_0_2_9 + 0.00868964368964519*G0_1_0_3_0 + 0.113297813297833*G0_1_0_3_1 + 0.0135714285714309*G0_1_0_3_2 + 0.147818847818873*G0_1_0_3_3 - 0.0619963369963475*G0_1_0_3_4 - 0.00380785880785946*G0_1_0_3_5 - 0.00331834831834887*G0_1_0_3_6 - 0.0369547119547183*G0_1_0_3_7 + 0.0739094239094365*G0_1_0_3_8 + 0.0238261738261779*G0_1_0_3_9 - 0.00417748917748989*G0_1_0_4_0 - 0.0524753024753113*G0_1_0_4_1 - 0.00592851592851692*G0_1_0_4_2 - 0.0619963369963475*G0_1_0_4_3 + 0.0270496170496216*G0_1_0_4_4 + 0.00164668664668693*G0_1_0_4_5 + 0.00167166167166195*G0_1_0_4_6 + 0.017975357975361*G0_1_0_4_7 - 0.0369547119547182*G0_1_0_4_8 - 0.0109090909090928*G0_1_0_4_9 - 0.000520749092177761*G0_1_0_5_0 - 0.00252247752247802*G0_1_0_5_1 - 0.000326736755308243*G0_1_0_5_2 - 0.00380785880785946*G0_1_0_5_3 + 0.00164668664668693*G0_1_0_5_4 - 0.00070548499119941*G0_1_0_5_5 + 0.00020431949003381*G0_1_0_5_6 + 0.00167166167166197*G0_1_0_5_7 - 0.00331834831834892*G0_1_0_5_8 - 0.000979020979021151*G0_1_0_5_9 - 0.000326736755308234*G0_1_0_6_0 - 0.00252247752247791*G0_1_0_6_1 - 0.000520749092177745*G0_1_0_6_2 - 0.00331834831834887*G0_1_0_6_3 + 0.00167166167166195*G0_1_0_6_4 + 0.00020431949003381*G0_1_0_6_5 - 0.000705484991199398*G0_1_0_6_6 + 0.00164668664668691*G0_1_0_6_7 - 0.00380785880785942*G0_1_0_6_8 - 0.000979020979021146*G0_1_0_6_9 - 0.00592851592851695*G0_1_0_7_0 - 0.0524753024753115*G0_1_0_7_1 - 0.00417748917748988*G0_1_0_7_2 - 0.0369547119547183*G0_1_0_7_3 + 0.017975357975361*G0_1_0_7_4 + 0.00167166167166197*G0_1_0_7_5 + 0.00164668664668691*G0_1_0_7_6 + 0.0270496170496217*G0_1_0_7_7 - 0.0619963369963475*G0_1_0_7_8 - 0.0109090909090928*G0_1_0_7_9 + 0.0135714285714309*G0_1_0_8_0 + 0.113297813297833*G0_1_0_8_1 + 0.00868964368964515*G0_1_0_8_2 + 0.0739094239094365*G0_1_0_8_3 - 0.0369547119547182*G0_1_0_8_4 - 0.00331834831834892*G0_1_0_8_5 - 0.00380785880785942*G0_1_0_8_6 - 0.0619963369963475*G0_1_0_8_7 + 0.147818847818873*G0_1_0_8_8 + 0.0238261738261779*G0_1_0_8_9 + 0.00253857253857298*G0_1_0_9_0 + 0.0166944166944196*G0_1_0_9_1 + 0.00253857253857297*G0_1_0_9_2 + 0.0238261738261779*G0_1_0_9_3 - 0.0109090909090928*G0_1_0_9_4 - 0.000979020979021151*G0_1_0_9_5 - 0.000979020979021146*G0_1_0_9_6 - 0.0109090909090928*G0_1_0_9_7 + 0.0238261738261779*G0_1_0_9_8 + 0.00803196803196939*G0_1_0_9_9;
    A[144] = A[176] + 0.297220381029956*G0_0_0_0_0 + 0.0128210413924722*G0_0_0_0_2 - 0.00910835196549648*G0_0_0_0_3 + 0.00286190000475765*G0_0_0_0_4 + 0.142964760107642*G0_0_0_0_5 - 0.0622344850916387*G0_0_0_0_6 + 0.0933601847887721*G0_0_0_0_7 - 0.0546974718403383*G0_0_0_0_8 + 0.0101485815771549*G0_0_0_0_9 - 0.297220381029956*G0_0_0_1_1 - 0.0128210413924721*G0_0_0_1_2 - 0.142964760107642*G0_0_0_1_3 + 0.0622344850916385*G0_0_0_1_4 + 0.00910835196549646*G0_0_0_1_5 - 0.00286190000475766*G0_0_0_1_6 + 0.0546974718403385*G0_0_0_1_7 - 0.0933601847887724*G0_0_0_1_8 - 0.0101485815771548*G0_0_0_1_9 + 0.0128210413924722*G0_0_0_2_0 - 0.0128210413924721*G0_0_0_2_1 - 0.0183418697704443*G0_0_0_2_3 + 0.00621769764627012*G0_0_0_2_4 + 0.0183418697704443*G0_0_0_2_5 - 0.00621769764627013*G0_0_0_2_6 + 0.0160347588919044*G0_0_0_2_7 - 0.0160347588919045*G0_0_0_2_8 - 0.00910835196549648*G0_0_0_3_0 - 0.142964760107642*G0_0_0_3_1 - 0.0183418697704443*G0_0_0_3_2 - 0.140507111935707*G0_0_0_3_3 + 0.0828124256695825*G0_0_0_3_4 + 0.00858570001427288*G0_0_0_3_6 + 0.0273250558964891*G0_0_0_3_7 - 0.0754293325722026*G0_0_0_3_8 - 0.0242043670615141*G0_0_0_3_9 + 0.00286190000475765*G0_0_0_4_0 + 0.0622344850916385*G0_0_0_4_1 + 0.00621769764627012*G0_0_0_4_2 + 0.0828124256695825*G0_0_0_4_3 - 0.0125436468293632*G0_0_0_4_4 - 0.00858570001427291*G0_0_0_4_5 - 0.0283449883449931*G0_0_0_4_7 + 0.0481042766757134*G0_0_0_4_8 + 0.0171714000285459*G0_0_0_4_9 + 0.142964760107642*G0_0_0_5_0 + 0.00910835196549646*G0_0_0_5_1 + 0.0183418697704443*G0_0_0_5_2 - 0.00858570001427291*G0_0_0_5_4 + 0.140507111935708*G0_0_0_5_5 - 0.0828124256695827*G0_0_0_5_6 + 0.0754293325722024*G0_0_0_5_7 - 0.0273250558964891*G0_0_0_5_8 + 0.0242043670615141*G0_0_0_5_9 - 0.0622344850916387*G0_0_0_6_0 - 0.00286190000475766*G0_0_0_6_1 - 0.00621769764627013*G0_0_0_6_2 + 0.00858570001427288*G0_0_0_6_3 - 0.0828124256695827*G0_0_0_6_5 + 0.0125436468293634*G0_0_0_6_6 - 0.0481042766757133*G0_0_0_6_7 + 0.0283449883449931*G0_0_0_6_8 - 0.0171714000285458*G0_0_0_6_9 + 0.0933601847887721*G0_0_0_7_0 + 0.0546974718403385*G0_0_0_7_1 + 0.0160347588919044*G0_0_0_7_2 + 0.0273250558964891*G0_0_0_7_3 - 0.0283449883449931*G0_0_0_7_4 + 0.0754293325722024*G0_0_0_7_5 - 0.0481042766757133*G0_0_0_7_6 + 0.197288425859888*G0_0_0_7_7 + 0.0657628086199625*G0_0_0_7_9 - 0.0546974718403384*G0_0_0_8_0 - 0.0933601847887725*G0_0_0_8_1 - 0.0160347588919045*G0_0_0_8_2 - 0.0754293325722026*G0_0_0_8_3 + 0.0481042766757134*G0_0_0_8_4 - 0.0273250558964891*G0_0_0_8_5 + 0.0283449883449931*G0_0_0_8_6 - 0.197288425859888*G0_0_0_8_8 - 0.0657628086199627*G0_0_0_8_9 + 0.0101485815771549*G0_0_0_9_0 - 0.0101485815771548*G0_0_0_9_1 - 0.0242043670615141*G0_0_0_9_3 + 0.0171714000285459*G0_0_0_9_4 + 0.0242043670615141*G0_0_0_9_5 - 0.0171714000285458*G0_0_0_9_6 + 0.0657628086199626*G0_0_0_9_7 - 0.0657628086199627*G0_0_0_9_8 - 0.0572143200714725*G0_0_1_0_0 - 0.0191058324391691*G0_0_1_0_1 - 0.00483213435594469*G0_0_1_0_2 - 0.005961445961447*G0_0_1_0_3 + 0.00616357187785866*G0_0_1_0_4 - 0.0356824128252759*G0_0_1_0_5 + 0.0172069200640658*G0_0_1_0_6 - 0.0417055959913172*G0_0_1_0_7 + 0.0127516927516948*G0_0_1_0_8 - 0.0101485815771547*G0_0_1_0_9 - 0.0191058324391691*G0_0_1_1_0 - 0.354434701101429*G0_0_1_1_1 - 0.0176531757484168*G0_0_1_1_2 - 0.178647172932918*G0_0_1_1_3 + 0.0794414051557043*G0_0_1_1_4 + 0.00314690600404951*G0_0_1_1_5 + 0.00330167187310096*G0_0_1_1_6 + 0.0674491645920334*G0_0_1_1_7 - 0.13506578078009*G0_0_1_1_8 - 0.0202971631543096*G0_0_1_1_9 - 0.00483213435594469*G0_0_1_2_0 - 0.0176531757484168*G0_0_1_2_1 - 0.00020973735259453*G0_0_1_2_2 - 0.0178784178784209*G0_0_1_2_3 + 0.00386745529602737*G0_0_1_2_4 + 0.000463451892023407*G0_0_1_2_5 - 0.00235024235024275*G0_0_1_2_6 + 0.0146782318210914*G0_0_1_2_7 - 0.00135652707081304*G0_0_1_2_8 + 0.0103921475350064*G0_0_1_2_9 - 0.005961445961447*G0_0_1_3_0 - 0.178647172932918*G0_0_1_3_1 - 0.0178784178784209*G0_0_1_3_2 - 0.164544027401198*G0_0_1_3_3 + 0.0872042243470962*G0_0_1_3_4 - 0.000791589363018046*G0_0_1_3_5 + 0.000121782978925874*G0_0_1_3_6 + 0.0279111364825698*G0_0_1_3_7 - 0.042007516293238*G0_0_1_3_8 + 0.00506921649778861*G0_0_1_3_9 + 0.00616357187785866*G0_0_1_4_0 + 0.0794414051557043*G0_0_1_4_1 + 0.00386745529602737*G0_0_1_4_2 + 0.0872042243470962*G0_0_1_4_3 - 0.00575424575424666*G0_0_1_4_4 - 0.00846391703534705*G0_0_1_4_5 + 0.00834213405642118*G0_0_1_4_6 - 0.0362761048475396*G0_0_1_4_7 + 0.014096379810668*G0_0_1_4_8 - 0.0142486085343251*G0_0_1_4_9 - 0.0356824128252759*G0_0_1_5_0 + 0.00314690600404951*G0_0_1_5_1 + 0.000463451892023407*G0_0_1_5_2 - 0.000791589363018047*G0_0_1_5_3 - 0.00846391703534704*G0_0_1_5_4 - 0.0240369154654909*G0_0_1_5_5 + 0.00439179867751366*G0_0_1_5_6 + 0.0334218162789647*G0_0_1_5_7 + 0.000586080586080726*G0_0_1_5_8 + 0.0292735835593027*G0_0_1_5_9 + 0.0172069200640658*G0_0_1_6_0 + 0.00330167187310096*G0_0_1_6_1 - 0.00235024235024275*G0_0_1_6_2 + 0.000121782978925874*G0_0_1_6_3 + 0.00834213405642118*G0_0_1_6_4 + 0.00439179867751366*G0_0_1_6_5 + 0.0067894010751165*G0_0_1_6_6 - 0.0340078968650454*G0_0_1_6_7 - 0.0079311165025464*G0_0_1_6_8 - 0.0314200085628709*G0_0_1_6_9 - 0.0417055959913173*G0_0_1_7_0 + 0.0674491645920334*G0_0_1_7_1 + 0.0146782318210914*G0_0_1_7_2 + 0.0279111364825698*G0_0_1_7_3 - 0.0362761048475396*G0_0_1_7_4 + 0.0334218162789647*G0_0_1_7_5 - 0.0340078968650454*G0_0_1_7_6 + 0.268744588744634*G0_0_1_7_7 + 0.0145987345987373*G0_0_1_7_8 + 0.098461538461555*G0_0_1_7_9 + 0.0127516927516948*G0_0_1_8_0 - 0.13506578078009*G0_0_1_8_1 - 0.00135652707081304*G0_0_1_8_2 - 0.042007516293238*G0_0_1_8_3 + 0.014096379810668*G0_0_1_8_4 + 0.000586080586080724*G0_0_1_8_5 - 0.0079311165025464*G0_0_1_8_6 + 0.0145987345987373*G0_0_1_8_7 + 0.071456162884746*G0_0_1_8_8 + 0.0326987298415924*G0_0_1_8_9 - 0.0101485815771547*G0_0_1_9_0 - 0.0202971631543096*G0_0_1_9_1 + 0.0103921475350064*G0_0_1_9_2 + 0.00506921649778861*G0_0_1_9_3 - 0.0142486085343251*G0_0_1_9_4 + 0.0292735835593027*G0_0_1_9_5 - 0.0314200085628709*G0_0_1_9_6 + 0.098461538461555*G0_0_1_9_7 + 0.0326987298415924*G0_0_1_9_8 + 0.16988725560157*G0_0_1_9_9 - 0.0572143200714725*G0_1_0_0_0 - 0.0191058324391691*G0_1_0_0_1 - 0.00483213435594469*G0_1_0_0_2 - 0.005961445961447*G0_1_0_0_3 + 0.00616357187785866*G0_1_0_0_4 - 0.0356824128252759*G0_1_0_0_5 + 0.0172069200640658*G0_1_0_0_6 - 0.0417055959913172*G0_1_0_0_7 + 0.0127516927516948*G0_1_0_0_8 - 0.0101485815771547*G0_1_0_0_9 - 0.0191058324391691*G0_1_0_1_0 - 0.354434701101429*G0_1_0_1_1 - 0.0176531757484168*G0_1_0_1_2 - 0.178647172932918*G0_1_0_1_3 + 0.0794414051557043*G0_1_0_1_4 + 0.00314690600404951*G0_1_0_1_5 + 0.00330167187310096*G0_1_0_1_6 + 0.0674491645920334*G0_1_0_1_7 - 0.13506578078009*G0_1_0_1_8 - 0.0202971631543096*G0_1_0_1_9 - 0.00483213435594469*G0_1_0_2_0 - 0.0176531757484168*G0_1_0_2_1 - 0.00020973735259453*G0_1_0_2_2 - 0.0178784178784209*G0_1_0_2_3 + 0.00386745529602737*G0_1_0_2_4 + 0.000463451892023406*G0_1_0_2_5 - 0.00235024235024274*G0_1_0_2_6 + 0.0146782318210914*G0_1_0_2_7 - 0.00135652707081304*G0_1_0_2_8 + 0.0103921475350064*G0_1_0_2_9 - 0.005961445961447*G0_1_0_3_0 - 0.178647172932918*G0_1_0_3_1 - 0.0178784178784209*G0_1_0_3_2 - 0.164544027401198*G0_1_0_3_3 + 0.0872042243470962*G0_1_0_3_4 - 0.000791589363018046*G0_1_0_3_5 + 0.000121782978925874*G0_1_0_3_6 + 0.0279111364825698*G0_1_0_3_7 - 0.042007516293238*G0_1_0_3_8 + 0.00506921649778861*G0_1_0_3_9 + 0.00616357187785866*G0_1_0_4_0 + 0.0794414051557043*G0_1_0_4_1 + 0.00386745529602738*G0_1_0_4_2 + 0.0872042243470962*G0_1_0_4_3 - 0.00575424575424666*G0_1_0_4_4 - 0.00846391703534704*G0_1_0_4_5 + 0.00834213405642118*G0_1_0_4_6 - 0.0362761048475395*G0_1_0_4_7 + 0.014096379810668*G0_1_0_4_8 - 0.0142486085343251*G0_1_0_4_9 - 0.0356824128252759*G0_1_0_5_0 + 0.00314690600404951*G0_1_0_5_1 + 0.000463451892023406*G0_1_0_5_2 - 0.000791589363018047*G0_1_0_5_3 - 0.00846391703534704*G0_1_0_5_4 - 0.0240369154654909*G0_1_0_5_5 + 0.00439179867751366*G0_1_0_5_6 + 0.0334218162789646*G0_1_0_5_7 + 0.000586080586080726*G0_1_0_5_8 + 0.0292735835593027*G0_1_0_5_9 + 0.0172069200640658*G0_1_0_6_0 + 0.00330167187310096*G0_1_0_6_1 - 0.00235024235024274*G0_1_0_6_2 + 0.000121782978925874*G0_1_0_6_3 + 0.00834213405642118*G0_1_0_6_4 + 0.00439179867751367*G0_1_0_6_5 + 0.00678940107511649*G0_1_0_6_6 - 0.0340078968650453*G0_1_0_6_7 - 0.0079311165025464*G0_1_0_6_8 - 0.0314200085628709*G0_1_0_6_9 - 0.0417055959913173*G0_1_0_7_0 + 0.0674491645920334*G0_1_0_7_1 + 0.0146782318210914*G0_1_0_7_2 + 0.0279111364825698*G0_1_0_7_3 - 0.0362761048475395*G0_1_0_7_4 + 0.0334218162789646*G0_1_0_7_5 - 0.0340078968650453*G0_1_0_7_6 + 0.268744588744634*G0_1_0_7_7 + 0.0145987345987374*G0_1_0_7_8 + 0.098461538461555*G0_1_0_7_9 + 0.0127516927516948*G0_1_0_8_0 - 0.13506578078009*G0_1_0_8_1 - 0.00135652707081304*G0_1_0_8_2 - 0.042007516293238*G0_1_0_8_3 + 0.014096379810668*G0_1_0_8_4 + 0.000586080586080727*G0_1_0_8_5 - 0.0079311165025464*G0_1_0_8_6 + 0.0145987345987374*G0_1_0_8_7 + 0.071456162884746*G0_1_0_8_8 + 0.0326987298415924*G0_1_0_8_9 - 0.0101485815771547*G0_1_0_9_0 - 0.0202971631543096*G0_1_0_9_1 + 0.0103921475350064*G0_1_0_9_2 + 0.00506921649778861*G0_1_0_9_3 - 0.0142486085343251*G0_1_0_9_4 + 0.0292735835593027*G0_1_0_9_5 - 0.0314200085628709*G0_1_0_9_6 + 0.098461538461555*G0_1_0_9_7 + 0.0326987298415924*G0_1_0_9_8 + 0.16988725560157*G0_1_0_9_9 + 0.0404657776086415*G0_1_1_0_0 - 0.0191058324391691*G0_1_1_0_1 + 0.000619063476206426*G0_1_1_0_2 - 0.0243075443075485*G0_1_1_0_3 + 0.0109283309283328*G0_1_1_0_4 + 0.0284143369857703*G0_1_1_0_5 - 0.0129157614871922*G0_1_1_0_6 + 0.0980826580826746*G0_1_1_0_7 - 0.0722714322714445*G0_1_1_0_8 - 0.000142080142080146*G0_1_1_0_9 - 0.0191058324391691*G0_1_1_1_0 - 0.452114798781543*G0_1_1_1_1 - 0.0231043735805679*G0_1_1_1_2 - 0.242743922743964*G0_1_1_1_3 + 0.109564086706962*G0_1_1_1_4 + 0.0214930043501509*G0_1_1_1_5 - 0.0014630871773732*G0_1_1_1_6 + 0.152472289615173*G0_1_1_1_7 - 0.274854034854082*G0_1_1_1_8 - 0.0303036645893841*G0_1_1_1_9 + 0.000619063476206426*G0_1_1_2_0 - 0.0231043735805679*G0_1_1_2_1 - 0.000209737352594521*G0_1_1_2_2 - 0.0345694517123147*G0_1_1_2_3 + 0.0102872788587091*G0_1_1_2_4 + 0.0171544857259172*G0_1_1_2_5 - 0.00877006591292452*G0_1_1_2_6 + 0.0449362277933781*G0_1_1_2_7 - 0.0316145230430998*G0_1_1_2_8 + 0.0103921475350064*G0_1_1_2_9 - 0.0243075443075485*G0_1_1_3_0 - 0.242743922743964*G0_1_1_3_1 - 0.0345694517123147*G0_1_1_3_2 - 0.31024213881362*G0_1_1_3_3 + 0.153796679510991*G0_1_1_3_4 - 0.000791589363018069*G0_1_1_3_5 + 0.0144160601303483*G0_1_1_3_6 + 0.082949431520874*G0_1_1_3_7 - 0.187819799248402*G0_1_1_3_8 - 0.0749878692735963*G0_1_1_3_9 + 0.0109283309283328*G0_1_1_4_0 + 0.109564086706962*G0_1_1_4_1 + 0.0102872788587091*G0_1_1_4_2 + 0.153796679510991*G0_1_1_4_3 - 0.034586366014943*G0_1_1_4_4 - 0.0227581941867695*G0_1_1_4_5 + 0.00834213405642121*G0_1_1_4_6 - 0.0888102373816809*G0_1_1_4_7 + 0.104870367727528*G0_1_1_4_8 + 0.0143399457685197*G0_1_1_4_9 + 0.0284143369857703*G0_1_1_5_0 + 0.0214930043501509*G0_1_1_5_1 + 0.0171544857259172*G0_1_1_5_2 - 0.000791589363018068*G0_1_1_5_3 - 0.0227581941867695*G0_1_1_5_4 + 0.12166119594693*G0_1_1_5_5 - 0.0622006564863811*G0_1_1_5_6 + 0.179234099234129*G0_1_1_5_7 - 0.0544522144522234*G0_1_1_5_8 + 0.109330669330688*G0_1_1_5_9 - 0.0129157614871922*G0_1_1_6_0 - 0.0014630871773732*G0_1_1_6_1 - 0.00877006591292452*G0_1_1_6_2 + 0.0144160601303483*G0_1_1_6_3 + 0.00834213405642121*G0_1_1_6_4 - 0.0622006564863811*G0_1_1_6_5 + 0.035621521335813*G0_1_1_6_6 - 0.124781884781906*G0_1_1_6_7 + 0.0446030160315948*G0_1_1_6_8 - 0.0600085628657158*G0_1_1_6_9 + 0.0980826580826746*G0_1_1_7_0 + 0.152472289615173*G0_1_1_7_1 + 0.0449362277933781*G0_1_1_7_2 + 0.082949431520874*G0_1_1_7_3 - 0.0888102373816809*G0_1_1_7_4 + 0.179234099234129*G0_1_1_7_5 - 0.124781884781906*G0_1_1_7_6 + 0.665787545787658*G0_1_1_7_7 + 0.0145987345987374*G0_1_1_7_8 + 0.249990009990052*G0_1_1_7_9 - 0.0722714322714445*G0_1_1_8_0 - 0.274854034854082*G0_1_1_8_1 - 0.0316145230430998*G0_1_1_8_2 - 0.187819799248402*G0_1_1_8_3 + 0.104870367727528*G0_1_1_8_4 - 0.0544522144522234*G0_1_1_8_5 + 0.0446030160315948*G0_1_1_8_6 + 0.0145987345987374*G0_1_1_8_7 - 0.325586794158278*G0_1_1_8_8 - 0.118829741686905*G0_1_1_8_9 - 0.000142080142080144*G0_1_1_9_0 - 0.0303036645893841*G0_1_1_9_1 + 0.0103921475350064*G0_1_1_9_2 - 0.0749878692735963*G0_1_1_9_3 + 0.0143399457685197*G0_1_1_9_4 + 0.109330669330688*G0_1_1_9_5 - 0.0600085628657158*G0_1_1_9_6 + 0.249990009990052*G0_1_1_9_7 - 0.118829741686905*G0_1_1_9_8 + 0.16988725560157*G0_1_1_9_9;
    A[89] = 0.000420602325364301*G0_0_0_0_0 + 0.00640149973483411*G0_0_0_0_2 + 0.00149945292802465*G0_0_0_0_3 - 0.0105494505494525*G0_0_0_0_4 - 0.0076647162361461*G0_0_0_0_5 + 0.024775224775229*G0_0_0_0_6 - 0.000339977482834675*G0_0_0_0_7 + 6.34286348572176e-05*G0_0_0_0_8 + 0.000837257980115245*G0_0_0_0_9 - 0.000420602325364321*G0_0_0_1_1 - 0.00640149973483421*G0_0_0_1_2 + 0.00766471623614616*G0_0_0_1_3 - 0.0247752247752291*G0_0_0_1_4 - 0.0014994529280246*G0_0_0_1_5 + 0.0105494505494523*G0_0_0_1_6 - 6.34286348572107e-05*G0_0_0_1_7 + 0.000339977482834681*G0_0_0_1_8 - 0.000837257980115282*G0_0_0_1_9 + 0.00640149973483411*G0_0_0_2_0 - 0.00640149973483421*G0_0_0_2_1 + 0.0333888333888393*G0_0_0_2_3 - 0.0966144966145137*G0_0_0_2_4 - 0.0333888333888388*G0_0_0_2_5 + 0.0966144966145126*G0_0_0_2_6 + 0.000213120213120266*G0_0_0_2_7 - 0.00021312021312023*G0_0_0_2_8 + 0.00149945292802465*G0_0_0_3_0 + 0.00766471623614616*G0_0_0_3_1 + 0.0333888333888393*G0_0_0_3_2 - 0.0274925074925124*G0_0_0_3_3 + 0.121158841158862*G0_0_0_3_4 - 0.0316483516483567*G0_0_0_3_6 - 0.00449835878407383*G0_0_0_3_7 + 0.00385899814471305*G0_0_0_3_8 + 0.0115084915084935*G0_0_0_3_9 - 0.0105494505494525*G0_0_0_4_0 - 0.0247752247752291*G0_0_0_4_1 - 0.0966144966145137*G0_0_0_4_2 + 0.121158841158862*G0_0_0_4_3 - 0.495504495504581*G0_0_0_4_4 + 0.0316483516483572*G0_0_0_4_5 + 0.0155044955044981*G0_0_0_4_7 + 0.000639360639360781*G0_0_0_4_8 - 0.0632967032967141*G0_0_0_4_9 - 0.0076647162361461*G0_0_0_5_0 - 0.0014994529280246*G0_0_0_5_1 - 0.0333888333888388*G0_0_0_5_2 + 0.0316483516483572*G0_0_0_5_4 + 0.027492507492512*G0_0_0_5_5 - 0.121158841158862*G0_0_0_5_6 - 0.0038589981447131*G0_0_0_5_7 + 0.00449835878407381*G0_0_0_5_8 - 0.0115084915084934*G0_0_0_5_9 + 0.024775224775229*G0_0_0_6_0 + 0.0105494505494523*G0_0_0_6_1 + 0.0966144966145126*G0_0_0_6_2 - 0.0316483516483567*G0_0_0_6_3 - 0.121158841158862*G0_0_0_6_5 + 0.495504495504579*G0_0_0_6_6 - 0.000639360639360687*G0_0_0_6_7 - 0.015504495504498*G0_0_0_6_8 + 0.0632967032967136*G0_0_0_6_9 - 0.000339977482834675*G0_0_0_7_0 - 6.34286348572107e-05*G0_0_0_7_1 + 0.000213120213120266*G0_0_0_7_2 - 0.00449835878407383*G0_0_0_7_3 + 0.0155044955044981*G0_0_0_7_4 - 0.0038589981447131*G0_0_0_7_5 - 0.000639360639360688*G0_0_0_7_6 - 0.0036991579848729*G0_0_0_7_7 - 0.00123305266162428*G0_0_0_7_9 + 6.34286348572176e-05*G0_0_0_8_0 + 0.000339977482834681*G0_0_0_8_1 - 0.00021312021312023*G0_0_0_8_2 + 0.00385899814471305*G0_0_0_8_3 + 0.000639360639360781*G0_0_0_8_4 + 0.00449835878407381*G0_0_0_8_5 - 0.015504495504498*G0_0_0_8_6 + 0.00369915798487285*G0_0_0_8_8 + 0.00123305266162431*G0_0_0_8_9 + 0.000837257980115245*G0_0_0_9_0 - 0.000837257980115282*G0_0_0_9_1 + 0.0115084915084935*G0_0_0_9_3 - 0.0632967032967141*G0_0_0_9_4 - 0.0115084915084934*G0_0_0_9_5 + 0.0632967032967136*G0_0_0_9_6 - 0.00123305266162428*G0_0_0_9_7 + 0.00123305266162431*G0_0_0_9_8 - 0.00249204058727912*G0_0_1_0_0 - 0.00204606680797193*G0_0_1_0_1 - 0.00900038233371722*G0_0_1_0_2 + 0.00926058068915372*G0_0_1_0_3 - 0.0255845741560072*G0_0_1_0_4 + 0.00812140240711809*G0_0_1_0_5 - 0.01460634603492*G0_0_1_0_6 + 0.000994560994561167*G0_0_1_0_7 + 0.00127618413332721*G0_0_1_0_8 - 0.00866181437610158*G0_0_1_0_9 - 0.00204606680797193*G0_0_1_1_0 - 0.00291264291264341*G0_0_1_1_1 - 0.0154018820685514*G0_0_1_1_2 + 0.0157861186432642*G0_0_1_1_3 - 0.039381570810149*G0_0_1_1_4 + 0.00776112776112909*G0_0_1_1_5 - 0.0150351236065548*G0_0_1_1_6 + 0.00121275549846998*G0_0_1_1_7 + 0.00133453847739586*G0_0_1_1_8 - 0.00949907235621683*G0_0_1_1_9 - 0.00900038233371722*G0_0_1_2_0 - 0.0154018820685514*G0_0_1_2_1 - 0.133358000024689*G0_0_1_2_2 + 0.0715373515373637*G0_0_1_2_3 - 0.1712065712066*G0_0_1_2_4 + 0.0381485181485246*G0_0_1_2_5 - 0.0745920745920872*G0_0_1_2_6 + 0.00360528360528421*G0_0_1_2_7 + 0.00339216339216396*G0_0_1_2_8 - 0.0230169830169869*G0_0_1_2_9 + 0.00926058068915372*G0_0_1_3_0 + 0.0157861186432642*G0_0_1_3_1 + 0.0715373515373637*G0_0_1_3_2 - 0.0626801769659019*G0_0_1_3_3 + 0.181738261738293*G0_0_1_3_4 - 0.0358270301127505*G0_0_1_3_5 + 0.0656943056943168*G0_0_1_3_6 - 0.0071928071928084*G0_0_1_3_7 - 0.00321963750535231*G0_0_1_3_8 + 0.0428828314542673*G0_0_1_3_9 - 0.0255845741560072*G0_0_1_4_0 - 0.039381570810149*G0_0_1_4_1 - 0.1712065712066*G0_0_1_4_2 + 0.181738261738293*G0_0_1_4_3 - 0.616183816183921*G0_0_1_4_4 + 0.0973426573426739*G0_0_1_4_5 - 0.163036963036991*G0_0_1_4_6 + 0.0226744683887579*G0_0_1_4_7 + 0.0104124446981607*G0_0_1_4_8 - 0.125634365634387*G0_0_1_4_9 + 0.00812140240711809*G0_0_1_5_0 + 0.00776112776112909*G0_0_1_5_1 + 0.0381485181485246*G0_0_1_5_2 - 0.0358270301127505*G0_0_1_5_3 + 0.0973426573426739*G0_0_1_5_4 - 0.0351876694733898*G0_0_1_5_5 + 0.0605794205794308*G0_0_1_5_6 - 0.00707863565006542*G0_0_1_5_7 - 0.00269444840873456*G0_0_1_5_8 + 0.0313743399457738*G0_0_1_5_9 - 0.01460634603492*G0_0_1_6_0 - 0.0150351236065548*G0_0_1_6_1 - 0.0745920745920872*G0_0_1_6_2 + 0.0656943056943168*G0_0_1_6_3 - 0.163036963036991*G0_0_1_6_4 + 0.0605794205794308*G0_0_1_6_5 - 0.120679320679341*G0_0_1_6_6 + 0.00977308405879999*G0_0_1_6_7 + 0.00716997288425979*G0_0_1_6_8 - 0.0623376623376729*G0_0_1_6_9 + 0.000994560994561166*G0_0_1_7_0 + 0.00121275549846998*G0_0_1_7_1 + 0.00360528360528421*G0_0_1_7_2 - 0.0071928071928084*G0_0_1_7_3 + 0.0226744683887579*G0_0_1_7_4 - 0.00707863565006542*G0_0_1_7_5 + 0.00977308405879999*G0_0_1_7_6 - 0.00970458113315405*G0_0_1_7_7 - 0.000867703724846723*G0_0_1_7_8 + 0.00643927501070466*G0_0_1_7_9 + 0.00127618413332721*G0_0_1_8_0 + 0.00133453847739586*G0_0_1_8_1 + 0.00339216339216396*G0_0_1_8_2 - 0.00321963750535231*G0_0_1_8_3 + 0.0104124446981607*G0_0_1_8_4 - 0.00269444840873456*G0_0_1_8_5 + 0.00716997288425979*G0_0_1_8_6 - 0.000867703724846723*G0_0_1_8_7 - 0.00600542314828106*G0_0_1_8_8 + 0.00767232767232902*G0_0_1_8_9 - 0.00866181437610158*G0_0_1_9_0 - 0.00949907235621683*G0_0_1_9_1 - 0.0230169830169869*G0_0_1_9_2 + 0.0428828314542673*G0_0_1_9_3 - 0.125634365634387*G0_0_1_9_4 + 0.0313743399457738*G0_0_1_9_5 - 0.0623376623376729*G0_0_1_9_6 + 0.00643927501070466*G0_0_1_9_7 + 0.00767232767232902*G0_0_1_9_8 - 0.0780933352362056*G0_0_1_9_9 - 0.00197220768649375*G0_1_0_0_0 - 0.000323908895337526*G0_1_0_0_1 - 0.000106560106560146*G0_1_0_0_2 + 0.00291264291264343*G0_1_0_0_3 - 0.0338810395953312*G0_1_0_0_4 + 0.0044856730571024*G0_1_0_0_5 - 0.00208299636871102*G0_1_0_0_6 + 0.00223015080157975*G0_1_0_0_7 + 0.000829646543932415*G0_1_0_0_8 - 0.0141116026830337*G0_1_0_0_9 - 0.000323908895337527*G0_1_0_1_0 + 0.00376512376512446*G0_1_0_1_1 - 0.00750064750064881*G0_1_0_1_2 + 0.0134417962989415*G0_1_0_1_3 - 0.0263964606821796*G0_1_0_1_4 + 0.0024026766883914*G0_1_0_1_5 + 0.00208299636871099*G0_1_0_1_6 - 0.00135990993133875*G0_1_0_1_7 + 0.00431822146107938*G0_1_0_1_8 + 0.000334903192046096*G0_1_0_1_9 - 0.000106560106560146*G0_1_0_2_0 - 0.00750064750064881*G0_1_0_2_1 - 0.0337440337440397*G0_1_0_2_2 + 0.038326118326125*G0_1_0_2_3 - 0.079209679209693*G0_1_0_2_4 + 0.000319680319680421*G0_1_0_2_5 - 0.00065712065712077*G0_1_0_2_7 + 0.00163392163392191*G0_1_0_2_8 - 0.00063936063936078*G0_1_0_2_9 + 0.00291264291264343*G0_1_0_3_0 + 0.0134417962989415*G0_1_0_3_1 + 0.038326118326125*G0_1_0_3_2 - 0.0758327386898944*G0_1_0_3_3 + 0.116523476523496*G0_1_0_3_4 - 0.0115769944341393*G0_1_0_3_5 + 0.000959040959041214*G0_1_0_3_6 - 0.00152989867275608*G0_1_0_3_7 - 0.000776366490652322*G0_1_0_3_8 + 0.00205508776937382*G0_1_0_3_9 - 0.0338810395953312*G0_1_0_4_0 - 0.0263964606821796*G0_1_0_4_1 - 0.079209679209693*G0_1_0_4_2 + 0.116523476523496*G0_1_0_4_3 - 0.988291708291877*G0_1_0_4_4 + 0.108851148851167*G0_1_0_4_5 - 0.109810189810209*G0_1_0_4_6 + 0.0482032253460907*G0_1_0_4_7 + 0.00230626516340843*G0_1_0_4_8 - 0.215784215784252*G0_1_0_4_9 + 0.0044856730571024*G0_1_0_5_0 + 0.0024026766883914*G0_1_0_5_1 + 0.000319680319680421*G0_1_0_5_2 - 0.0115769944341393*G0_1_0_5_3 + 0.108851148851167*G0_1_0_5_4 - 0.0106179534750981*G0_1_0_5_5 - 0.000959040959041005*G0_1_0_5_6 - 0.00917939203653646*G0_1_0_5_7 + 0.042334808049101*G0_1_0_5_9 - 0.00208299636871102*G0_1_0_6_0 + 0.002082996368711*G0_1_0_6_1 + 0.000959040959041202*G0_1_0_6_3 - 0.109810189810209*G0_1_0_6_4 - 0.000959040959041005*G0_1_0_6_5 + 0.109810189810209*G0_1_0_6_6 + 0.00917939203653649*G0_1_0_6_7 - 0.00917939203653644*G0_1_0_6_8 + 0.00223015080157975*G0_1_0_7_0 - 0.00135990993133875*G0_1_0_7_1 - 0.00065712065712077*G0_1_0_7_2 - 0.00152989867275608*G0_1_0_7_3 + 0.0482032253460907*G0_1_0_7_4 - 0.00917939203653646*G0_1_0_7_5 + 0.00917939203653649*G0_1_0_7_6 - 0.00742115027829452*G0_1_0_7_7 - 0.00248893963179723*G0_1_0_7_8 + 0.023976023976028*G0_1_0_7_9 + 0.000829646543932415*G0_1_0_8_0 + 0.00431822146107938*G0_1_0_8_1 + 0.00163392163392191*G0_1_0_8_2 - 0.000776366490652322*G0_1_0_8_3 + 0.00230626516340843*G0_1_0_8_4 - 0.00917939203653644*G0_1_0_8_6 - 0.00248893963179723*G0_1_0_8_7 + 0.0131297274154439*G0_1_0_8_8 - 0.00561723990295513*G0_1_0_8_9 - 0.0141116026830337*G0_1_0_9_0 + 0.000334903192046095*G0_1_0_9_1 - 0.00063936063936078*G0_1_0_9_2 + 0.00205508776937382*G0_1_0_9_3 - 0.215784215784252*G0_1_0_9_4 + 0.042334808049101*G0_1_0_9_5 + 0.023976023976028*G0_1_0_9_7 - 0.00561723990295513*G0_1_0_9_8 - 0.0846696160982018*G0_1_0_9_9 - 0.00571365142793813*G0_1_1_0_0 - 0.00365518079803858*G0_1_1_0_1 - 0.0045567131281425*G0_1_1_0_2 + 0.00293294007579774*G0_1_1_0_3 - 0.0386940044082968*G0_1_1_0_4 + 0.0107980907980926*G0_1_1_0_5 - 0.0144490430204741*G0_1_1_0_6 + 0.00714206428492262*G0_1_1_0_7 - 0.00246356817785434*G0_1_1_0_8 - 0.0170648399219857*G0_1_1_0_9 - 0.00365518079803858*G0_1_1_1_0 - 0.0133081733081757*G0_1_1_1_1 - 0.0111076225361959*G0_1_1_1_2 + 0.0167654567654596*G0_1_1_1_3 - 0.0365754880040657*G0_1_1_1_4 + 0.00605362891077282*G0_1_1_1_5 - 0.0123660466517631*G0_1_1_1_6 + 0.00874807731950739*G0_1_1_1_7 - 0.0112243312243332*G0_1_1_1_8 - 0.00243565957851717*G0_1_1_1_9 - 0.0045567131281425*G0_1_1_2_0 - 0.0111076225361959*G0_1_1_2_1 - 0.0595552595552697*G0_1_1_2_2 + 0.0485381285381368*G0_1_1_2_3 - 0.111834831834851*G0_1_1_2_4 + 0.0176356976357006*G0_1_1_2_5 - 0.0349517149517209*G0_1_1_2_6 + 4.82057624914855e-05*G0_1_1_2_7 - 0.0040086897229761*G0_1_1_2_8 - 0.02568098568099*G0_1_1_2_9 + 0.00293294007579774*G0_1_1_3_0 + 0.0167654567654596*G0_1_1_3_1 + 0.0485381285381368*G0_1_1_3_2 - 0.145317539603278*G0_1_1_3_3 + 0.182948480091368*G0_1_1_3_4 - 0.024775224775229*G0_1_1_3_5 + 0.0596888825460355*G0_1_1_3_6 + 0.0137919223633533*G0_1_1_3_7 - 0.0484087341230279*G0_1_1_3_8 - 0.0202768659911551*G0_1_1_3_9 - 0.0386940044082968*G0_1_1_4_0 - 0.0365754880040657*G0_1_1_4_1 - 0.111834831834851*G0_1_1_4_2 + 0.182948480091368*G0_1_1_4_3 - 1.0555844155846*G0_1_1_4_4 + 0.138672755815636*G0_1_1_4_5 - 0.198361638361672*G0_1_1_4_6 + 0.0466733266733345*G0_1_1_4_7 + 0.0346168117596747*G0_1_1_4_8 - 0.200302554588303*G0_1_1_4_9 + 0.0107980907980926*G0_1_1_5_0 + 0.00605362891077282*G0_1_1_5_1 + 0.0176356976357006*G0_1_1_5_2 - 0.024775224775229*G0_1_1_5_3 + 0.138672755815636*G0_1_1_5_4 - 0.0455316112459046*G0_1_1_5_5 + 0.0587298415869944*G0_1_1_5_6 - 0.0268759811616999*G0_1_1_5_7 + 0.00442985585842804*G0_1_1_5_8 + 0.042334808049101*G0_1_1_5_9 - 0.0144490430204741*G0_1_1_6_0 - 0.0123660466517631*G0_1_1_6_1 - 0.0349517149517209*G0_1_1_6_2 + 0.0596888825460355*G0_1_1_6_3 - 0.198361638361672*G0_1_1_6_4 + 0.0587298415869944*G0_1_1_6_5 - 0.0885514485514636*G0_1_1_6_6 + 0.0224461253032719*G0_1_1_6_7 + 0.0132667332667355*G0_1_1_6_8 - 0.042334808049101*G0_1_1_6_9 + 0.00714206428492262*G0_1_1_7_0 + 0.00874807731950739*G0_1_1_7_1 + 4.82057624914851e-05*G0_1_1_7_2 + 0.0137919223633533*G0_1_1_7_3 + 0.0466733266733345*G0_1_1_7_4 - 0.0268759811616999*G0_1_1_7_5 + 0.0224461253032719*G0_1_1_7_6 - 0.119012416155293*G0_1_1_7_7 + 0.01580134151563*G0_1_1_7_8 + 0.00630226915941309*G0_1_1_7_9 - 0.00246356817785434*G0_1_1_8_0 - 0.0112243312243332*G0_1_1_8_1 - 0.0040086897229761*G0_1_1_8_2 - 0.0484087341230279*G0_1_1_8_3 + 0.0346168117596747*G0_1_1_8_4 + 0.00442985585842804*G0_1_1_8_5 + 0.0132667332667355*G0_1_1_8_6 + 0.01580134151563*G0_1_1_8_7 - 0.214368488654239*G0_1_1_8_8 - 0.0619266447837981*G0_1_1_8_9 - 0.0170648399219857*G0_1_1_9_0 - 0.00243565957851717*G0_1_1_9_1 - 0.02568098568099*G0_1_1_9_2 - 0.0202768659911551*G0_1_1_9_3 - 0.200302554588303*G0_1_1_9_4 + 0.042334808049101*G0_1_1_9_5 - 0.042334808049101*G0_1_1_9_6 + 0.0063022691594131*G0_1_1_9_7 - 0.0619266447837981*G0_1_1_9_8 - 0.299220779220829*G0_1_1_9_9;
    A[195] = A[181] + 0.0250297850297893*G0_0_0_0_0 + 0.00250842631795056*G0_0_0_0_2 - 0.00395223823795321*G0_0_0_0_3 + 0.000271157414014602*G0_0_0_0_4 + 0.0324307438593209*G0_0_0_0_5 - 0.013543282114713*G0_0_0_0_6 + 0.00663685520828493*G0_0_0_0_7 - 0.0044882102024967*G0_0_0_0_8 - 0.00266780838209453*G0_0_0_0_9 - 0.0250297850297895*G0_0_0_1_1 - 0.00250842631795056*G0_0_0_1_2 - 0.0324307438593209*G0_0_0_1_3 + 0.013543282114713*G0_0_0_1_4 + 0.00395223823795318*G0_0_0_1_5 - 0.000271157414014599*G0_0_0_1_6 + 0.00448821020249673*G0_0_0_1_7 - 0.006636855208285*G0_0_0_1_8 + 0.00266780838209451*G0_0_0_1_9 + 0.00250842631795056*G0_0_0_2_0 - 0.00250842631795056*G0_0_0_2_1 - 0.0069035726178595*G0_0_0_2_3 + 0.00423956995385636*G0_0_0_2_4 + 0.00690357261785951*G0_0_0_2_5 - 0.00423956995385638*G0_0_0_2_6 + 0.00233956519670845*G0_0_0_2_7 - 0.00233956519670846*G0_0_0_2_8 - 0.00395223823795321*G0_0_0_3_0 - 0.0324307438593209*G0_0_0_3_1 - 0.0069035726178595*G0_0_0_3_2 - 0.147315541601281*G0_0_0_3_3 + 0.0278892536035441*G0_0_0_3_4 + 0.000813472242043821*G0_0_0_3_6 + 0.0118567147138596*G0_0_0_3_7 - 0.018875410303985*G0_0_0_3_8 - 0.0317168545740028*G0_0_0_3_9 + 0.000271157414014602*G0_0_0_4_0 + 0.013543282114713*G0_0_0_4_1 + 0.00423956995385636*G0_0_0_4_2 + 0.0278892536035441*G0_0_0_4_3 - 0.0295418866847488*G0_0_0_4_4 - 0.000813472242043812*G0_0_0_4_5 - 0.00391608391608459*G0_0_0_4_7 + 0.00701869559012539*G0_0_0_4_8 + 0.00162694448408762*G0_0_0_4_9 + 0.0324307438593209*G0_0_0_5_0 + 0.00395223823795318*G0_0_0_5_1 + 0.00690357261785951*G0_0_0_5_2 - 0.000813472242043812*G0_0_0_5_4 + 0.147315541601281*G0_0_0_5_5 - 0.027889253603544*G0_0_0_5_6 + 0.0188754103039849*G0_0_0_5_7 - 0.0118567147138595*G0_0_0_5_8 + 0.0317168545740028*G0_0_0_5_9 - 0.013543282114713*G0_0_0_6_0 - 0.000271157414014599*G0_0_0_6_1 - 0.00423956995385638*G0_0_0_6_2 + 0.000813472242043821*G0_0_0_6_3 - 0.027889253603544*G0_0_0_6_5 + 0.0295418866847488*G0_0_0_6_6 - 0.00701869559012533*G0_0_0_6_7 + 0.00391608391608459*G0_0_0_6_8 - 0.00162694448408764*G0_0_0_6_9 + 0.00663685520828493*G0_0_0_7_0 + 0.00448821020249673*G0_0_0_7_1 + 0.00233956519670845*G0_0_0_7_2 + 0.0118567147138596*G0_0_0_7_3 - 0.00391608391608459*G0_0_0_7_4 + 0.0188754103039849*G0_0_0_7_5 - 0.00701869559012533*G0_0_0_7_6 + 0.0042643071214507*G0_0_0_7_7 + 0.0220408163265343*G0_0_0_7_9 - 0.0044882102024967*G0_0_0_8_0 - 0.006636855208285*G0_0_0_8_1 - 0.00233956519670846*G0_0_0_8_2 - 0.018875410303985*G0_0_0_8_3 + 0.00701869559012539*G0_0_0_8_4 - 0.0118567147138595*G0_0_0_8_5 + 0.00391608391608459*G0_0_0_8_6 - 0.0042643071214508*G0_0_0_8_8 - 0.0220408163265344*G0_0_0_8_9 - 0.00266780838209453*G0_0_0_9_0 + 0.00266780838209451*G0_0_0_9_1 - 0.0317168545740028*G0_0_0_9_3 + 0.00162694448408762*G0_0_0_9_4 + 0.0317168545740028*G0_0_0_9_5 - 0.00162694448408764*G0_0_0_9_6 + 0.0220408163265343*G0_0_0_9_7 - 0.0220408163265344*G0_0_0_9_8 + 0.0166006832673528*G0_0_1_0_0 + 0.000395865157769986*G0_0_1_0_1 + 0.00175593366069587*G0_0_1_0_2 - 0.00237381665953135*G0_0_1_0_3 - 0.000593216307502128*G0_0_1_0_4 + 0.0206160506160541*G0_0_1_0_5 - 0.00732600732600858*G0_0_1_0_6 + 0.00437007437007513*G0_0_1_0_7 - 0.00293928293928344*G0_0_1_0_8 - 0.00254412254412297*G0_0_1_0_9 + 0.000395865157769986*G0_0_1_1_0 - 0.00842910176243652*G0_0_1_1_1 - 0.000752492657254687*G0_0_1_1_2 - 0.0118146932432667*G0_0_1_1_3 + 0.0062172747887044*G0_0_1_1_4 + 0.00157842157842184*G0_0_1_1_5 - 0.000864373721516725*G0_0_1_1_6 + 0.00154892726321325*G0_0_1_1_7 - 0.0022667808382098*G0_0_1_1_8 + 0.000123685837971563*G0_0_1_1_9 + 0.00175593366069587*G0_0_1_2_0 - 0.000752492657254687*G0_0_1_2_1 + 0.00152736152736176*G0_0_1_2_2 - 0.00327418613132953*G0_0_1_2_3 + 0.00538762824477199*G0_0_1_2_4 + 0.00362938648652996*G0_0_1_2_5 + 0.00114805829091562*G0_0_1_2_6 + 0.00142286285143452*G0_0_1_2_7 - 0.000916702345273927*G0_0_1_2_8 + 0.00415584415584486*G0_0_1_2_9 - 0.00237381665953135*G0_0_1_3_0 - 0.0118146932432667*G0_0_1_3_1 - 0.00327418613132953*G0_0_1_3_2 - 0.101121735407467*G0_0_1_3_3 + 0.00439417725132085*G0_0_1_3_4 + 0.00162694448408759*G0_0_1_3_5 + 0.00172541743970345*G0_0_1_3_6 + 0.0062537462537473*G0_0_1_3_7 - 0.00813614956472234*G0_0_1_3_8 - 0.0128785500214093*G0_0_1_3_9 - 0.000593216307502128*G0_0_1_4_0 + 0.0062172747887044*G0_0_1_4_1 + 0.00538762824477199*G0_0_1_4_2 + 0.00439417725132085*G0_0_1_4_3 - 0.0190466676180994*G0_0_1_4_4 + 0.00091194519765964*G0_0_1_4_5 - 0.00263736263736309*G0_0_1_4_6 - 0.000810617953475235*G0_0_1_4_7 + 0.00188240331097505*G0_0_1_4_8 - 0.0142914228628539*G0_0_1_4_9 + 0.0206160506160541*G0_0_1_5_0 + 0.00157842157842184*G0_0_1_5_1 + 0.00362938648652996*G0_0_1_5_2 + 0.00162694448408759*G0_0_1_5_3 + 0.00091194519765964*G0_0_1_5_4 + 0.0461938061938139*G0_0_1_5_5 - 0.0234950763522232*G0_0_1_5_6 + 0.0107392607392626*G0_0_1_5_7 - 0.00560296846011226*G0_0_1_5_8 + 0.0188383045525935*G0_0_1_5_9 - 0.00732600732600858*G0_0_1_6_0 - 0.000864373721516725*G0_0_1_6_1 + 0.00114805829091562*G0_0_1_6_2 + 0.00172541743970345*G0_0_1_6_3 - 0.00263736263736309*G0_0_1_6_4 - 0.0234950763522232*G0_0_1_6_5 + 0.0104952190666494*G0_0_1_6_6 - 0.00513629227915029*G0_0_1_6_7 + 0.00310546596260935*G0_0_1_6_8 - 0.0159183673469415*G0_0_1_6_9 + 0.00437007437007513*G0_0_1_7_0 + 0.00154892726321325*G0_0_1_7_1 + 0.00142286285143452*G0_0_1_7_2 + 0.0062537462537473*G0_0_1_7_3 - 0.000810617953475235*G0_0_1_7_4 + 0.0107392607392625*G0_0_1_7_5 - 0.00513629227915029*G0_0_1_7_6 + 0.00645354645354762*G0_0_1_7_7 - 0.000610817753675026*G0_0_1_7_8 + 0.0179049521906695*G0_0_1_7_9 - 0.00293928293928344*G0_0_1_8_0 - 0.0022667808382098*G0_0_1_8_1 - 0.000916702345273927*G0_0_1_8_2 - 0.00813614956472234*G0_0_1_8_3 + 0.00188240331097505*G0_0_1_8_4 - 0.00560296846011226*G0_0_1_8_5 + 0.00310546596260935*G0_0_1_8_6 - 0.000610817753675026*G0_0_1_8_7 + 0.00218923933209688*G0_0_1_8_8 - 0.00413586413586482*G0_0_1_8_9 - 0.00254412254412297*G0_0_1_9_0 + 0.000123685837971563*G0_0_1_9_1 + 0.00415584415584486*G0_0_1_9_2 - 0.0128785500214093*G0_0_1_9_3 - 0.0142914228628539*G0_0_1_9_4 + 0.0188383045525935*G0_0_1_9_5 - 0.0159183673469415*G0_0_1_9_6 + 0.0179049521906695*G0_0_1_9_7 - 0.00413586413586482*G0_0_1_9_8 - 0.0203453689168008*G0_0_1_9_9 + 0.0189736189736219*G0_1_0_0_0 + 0.00199895342752518*G0_1_0_0_1 + 0.000901884711408657*G0_1_0_0_2 - 0.00300620014905782*G0_1_0_0_3 + 0.000187748759177369*G0_1_0_0_4 + 0.0105948020233751*G0_1_0_0_5 - 0.00453768453768524*G0_1_0_0_6 + 0.0109791795506099*G0_1_0_0_7 - 0.00745286459572295*G0_1_0_0_8 + 0.000117977260834418*G0_1_0_0_9 + 0.00199895342752518*G0_1_0_1_0 - 0.00605616605616715*G0_1_0_1_1 - 0.00160654160654188*G0_1_0_1_2 - 0.0218359418359456*G0_1_0_1_3 + 0.00900559757702768*G0_1_0_1_4 + 0.000946038088895379*G0_1_0_1_5 - 0.0029646543932263*G0_1_0_1_7 + 0.00434232434232503*G0_1_0_1_8 + 0.00278578564292895*G0_1_0_1_9 + 0.000901884711408657*G0_1_0_2_0 - 0.00160654160654188*G0_1_0_2_1 + 0.00207341159722145*G0_1_0_2_2 - 0.00528487385630332*G0_1_0_2_3 + 0.00355105212248127*G0_1_0_2_4 + 0.00161869876155617*G0_1_0_2_5 - 0.000688517831375091*G0_1_0_2_6 + 0.00126857269714434*G0_1_0_2_7 - 0.00107099249956411*G0_1_0_2_8 - 0.00327672327672384*G0_1_0_2_9 - 0.00300620014905782*G0_1_0_3_0 - 0.0218359418359456*G0_1_0_3_1 - 0.00528487385630332*G0_1_0_3_2 - 0.133169687455424*G0_1_0_3_3 + 0.0206793206793242*G0_1_0_3_4 + 0.00299700299700348*G0_1_0_3_5 + 0.000436706150991938*G0_1_0_3_6 + 0.00920508063365364*G0_1_0_3_7 - 0.0126045383188262*G0_1_0_3_8 - 0.0267675181960942*G0_1_0_3_9 + 0.000187748759177369*G0_1_0_4_0 + 0.00900559757702768*G0_1_0_4_1 + 0.00355105212248127*G0_1_0_4_2 + 0.0206793206793242*G0_1_0_4_3 - 0.0311859569002479*G0_1_0_4_4 - 0.000376766091051871*G0_1_0_4_5 - 0.00227772227772268*G0_1_0_4_7 + 0.00339945768517257*G0_1_0_4_8 + 0.0105837020122753*G0_1_0_4_9 + 0.0105948020233751*G0_1_0_5_0 + 0.00094603808889538*G0_1_0_5_1 + 0.00161869876155617*G0_1_0_5_2 + 0.00299700299700348*G0_1_0_5_3 - 0.000376766091051871*G0_1_0_5_4 + 0.0141458541458564*G0_1_0_5_5 - 0.00720993292421979*G0_1_0_5_6 + 0.00627087198515869*G0_1_0_5_7 - 0.00265163408020592*G0_1_0_5_8 + 0.00494933637790861*G0_1_0_5_9 - 0.00453768453768524*G0_1_0_6_0 - 0.000688517831375091*G0_1_0_6_2 + 0.000436706150991938*G0_1_0_6_3 - 0.00720993292421979*G0_1_0_6_5 - 0.00164407021549905*G0_1_0_6_6 - 0.00361923790495277*G0_1_0_6_7 + 0.0016383616383619*G0_1_0_6_8 + 0.00895675752818764*G0_1_0_6_9 + 0.0109791795506099*G0_1_0_7_0 - 0.0029646543932263*G0_1_0_7_1 + 0.00126857269714434*G0_1_0_7_2 + 0.00920508063365364*G0_1_0_7_3 - 0.00227772227772268*G0_1_0_7_4 + 0.00627087198515869*G0_1_0_7_5 - 0.00361923790495277*G0_1_0_7_6 + 0.0017639503353791*G0_1_0_7_7 + 0.00816041101755533*G0_1_0_7_8 + 0.00688454402740234*G0_1_0_7_9 - 0.00745286459572295*G0_1_0_8_0 + 0.00434232434232503*G0_1_0_8_1 - 0.00107099249956411*G0_1_0_8_2 - 0.0126045383188262*G0_1_0_8_3 + 0.00339945768517257*G0_1_0_8_4 - 0.00265163408020592*G0_1_0_8_5 + 0.0016383616383619*G0_1_0_8_6 + 0.00816041101755533*G0_1_0_8_7 - 0.00250035678607162*G0_1_0_8_8 - 0.015156272299132*G0_1_0_8_9 + 0.000117977260834418*G0_1_0_9_0 + 0.00278578564292895*G0_1_0_9_1 - 0.00327672327672384*G0_1_0_9_2 - 0.0267675181960942*G0_1_0_9_3 + 0.0105837020122753*G0_1_0_9_4 + 0.00494933637790861*G0_1_0_9_5 + 0.00895675752818764*G0_1_0_9_6 + 0.00688454402740234*G0_1_0_9_7 - 0.015156272299132*G0_1_0_9_8 + 0.0330869130869186*G0_1_0_9_9 + 0.0166006832673525*G0_1_1_0_0 + 0.00119740929264758*G0_1_1_0_1 + 0.000958829530258251*G0_1_1_0_2 - 0.00287220715792193*G0_1_1_0_3 + 0.00964923964924114*G0_1_1_0_5 - 0.00457320457320528*G0_1_1_0_6 + 0.0153368853368878*G0_1_1_0_7 - 0.00968808968809127*G0_1_1_0_8 + 0.0014518814518817*G0_1_1_0_9 + 0.00119740929264758*G0_1_1_1_0 - 0.00605616605616706*G0_1_1_1_1 - 0.000809437476104277*G0_1_1_1_2 - 0.0108691308691327*G0_1_1_1_3 + 0.00625279482422443*G0_1_1_1_4 + 0.00144442858728597*G0_1_1_1_5 - 0.000577359148787815*G0_1_1_1_6 + 0.00378415235558155*G0_1_1_1_7 - 0.00662448662448772*G0_1_1_1_8 - 0.00121021835307571*G0_1_1_1_9 + 0.00095882953025825*G0_1_1_2_0 - 0.000809437476104277*G0_1_1_2_1 + 0.00180038656229161*G0_1_1_2_2 - 0.00305789448646642*G0_1_1_2_3 + 0.00497930640787866*G0_1_1_2_4 + 0.00140240711669306*G0_1_1_2_5 - 0.00028019599448175*G0_1_1_2_6 + 0.00266749123892025*G0_1_1_2_7 - 0.00231562088704983*G0_1_1_2_8 + 0.000439560439560517*G0_1_1_2_9 - 0.00287220715792193*G0_1_1_3_0 - 0.0108691308691327*G0_1_1_3_1 - 0.00305789448646642*G0_1_1_3_2 - 0.101421435707167*G0_1_1_3_3 + 0.00336663336663392*G0_1_1_3_4 + 0.00231197374054554*G0_1_1_3_5 + 0.00139146567718019*G0_1_1_3_6 + 0.00827600970458249*G0_1_1_3_7 - 0.0148822605965487*G0_1_1_3_8 - 0.0129213643499379*G0_1_1_3_9 + 0.00625279482422443*G0_1_1_4_1 + 0.00497930640787866*G0_1_1_4_2 + 0.00336663336663391*G0_1_1_4_3 - 0.0208020550877728*G0_1_1_4_4 - 0.00134865134865157*G0_1_1_4_6 - 0.00368203225346144*G0_1_1_4_7 + 0.00660625089196626*G0_1_1_4_8 - 0.0012330526616243*G0_1_1_4_9 + 0.00964923964924114*G0_1_1_5_0 + 0.00144442858728597*G0_1_1_5_1 + 0.00140240711669306*G0_1_1_5_2 + 0.00231197374054554*G0_1_1_5_3 + 0.0144455544455567*G0_1_1_5_5 - 0.00618238903953289*G0_1_1_5_6 + 0.0130169830169851*G0_1_1_5_7 - 0.00467389753104114*G0_1_1_5_8 + 0.00499215070643723*G0_1_1_5_9 - 0.00457320457320528*G0_1_1_6_0 - 0.000577359148787815*G0_1_1_6_1 - 0.000280195994481751*G0_1_1_6_2 + 0.00139146567718019*G0_1_1_6_3 - 0.00134865134865157*G0_1_1_6_4 - 0.00618238903953289*G0_1_1_6_5 + 0.000111317254174409*G0_1_1_6_6 - 0.008343085485944*G0_1_1_6_7 + 0.0045097759383481*G0_1_1_6_8 - 0.00410161267304194*G0_1_1_6_9 + 0.0153368853368878*G0_1_1_7_0 + 0.00378415235558155*G0_1_1_7_1 + 0.00266749123892025*G0_1_1_7_2 + 0.00827600970458249*G0_1_1_7_3 - 0.00368203225346144*G0_1_1_7_4 + 0.0130169830169851*G0_1_1_7_5 - 0.008343085485944*G0_1_1_7_6 + 0.0336463536463593*G0_1_1_7_7 + 0.0037747966319401*G0_1_1_7_8 + 0.012330526616243*G0_1_1_7_9 - 0.00968808968809127*G0_1_1_8_0 - 0.00662448662448772*G0_1_1_8_1 - 0.00231562088704983*G0_1_1_8_2 - 0.0148822605965487*G0_1_1_8_3 + 0.00660625089196626*G0_1_1_8_4 - 0.00467389753104114*G0_1_1_8_5 + 0.0045097759383481*G0_1_1_8_6 + 0.0037747966319401*G0_1_1_8_7 - 0.0296931639788831*G0_1_1_8_8 - 0.00958184672470544*G0_1_1_8_9 + 0.0014518814518817*G0_1_1_9_0 - 0.00121021835307571*G0_1_1_9_1 + 0.000439560439560517*G0_1_1_9_2 - 0.0129213643499379*G0_1_1_9_3 - 0.0012330526616243*G0_1_1_9_4 + 0.00499215070643723*G0_1_1_9_5 - 0.00410161267304194*G0_1_1_9_6 + 0.012330526616243*G0_1_1_9_7 - 0.00958184672470544*G0_1_1_9_8 + 0.00637077208505897*G0_1_1_9_9;
    A[14] = A[195] + 0.000562964372488289*G0_0_0_0_1 - 0.000558524368048272*G0_0_0_0_2 + 0.00227455084597981*G0_0_0_0_3 - 0.00227899085041982*G0_0_0_0_4 - 0.00527916527916617*G0_0_0_0_5 - 0.00236208236208278*G0_0_0_0_6 + 0.00527916527916626*G0_0_0_0_7 - 0.00163392163392195*G0_0_0_0_8 + 0.00399600399600469*G0_0_0_0_9 + 0.000562964372488289*G0_0_0_1_0 + 0.0102294883247282*G0_0_0_1_1 + 0.0167939996511453*G0_0_0_1_3 - 0.00927516927517084*G0_0_0_1_4 + 0.00108906966049842*G0_0_0_1_5 - 0.00145124716553312*G0_0_0_1_6 - 0.000146520146520166*G0_0_0_1_7 + 0.00198658484372804*G0_0_0_1_8 + 0.000315874601588955*G0_0_0_1_9 - 0.000558524368048272*G0_0_0_2_0 - 0.00758352758352889*G0_0_0_2_2 + 0.00952698095555399*G0_0_0_2_3 - 0.0162567591139047*G0_0_0_2_4 + 0.000154765869051604*G0_0_0_2_5 - 0.00777254491540338*G0_0_0_2_6 + 0.000339343196486109*G0_0_0_2_8 - 0.00536606250892056*G0_0_0_2_9 + 0.00227455084597981*G0_0_0_3_0 + 0.0167939996511453*G0_0_0_3_1 + 0.00952698095555399*G0_0_0_3_2 + 0.0803196803196938*G0_0_0_3_3 - 0.00102754388468689*G0_0_0_3_4 - 0.00530897673754905*G0_0_0_3_5 + 0.00488083345226282*G0_0_0_3_6 - 0.00629656058227593*G0_0_0_3_7 + 0.0067874982160708*G0_0_0_3_8 + 0.011645497359785*G0_0_0_3_9 - 0.00227899085041982*G0_0_0_4_0 - 0.00927516927517084*G0_0_0_4_1 - 0.0162567591139047*G0_0_0_4_2 - 0.00102754388468689*G0_0_0_4_3 - 0.0823747680890677*G0_0_0_4_4 + 0.00736406450692287*G0_0_0_4_5 - 0.0122448979591857*G0_0_0_4_6 + 0.00312259169402078*G0_0_0_4_7 - 0.000490937633794865*G0_0_0_4_8 + 0.00137005851291595*G0_0_0_4_9 - 0.00527916527916617*G0_0_0_5_0 + 0.00108906966049842*G0_0_0_5_1 + 0.000154765869051604*G0_0_0_5_2 - 0.00530897673754904*G0_0_0_5_3 + 0.00736406450692288*G0_0_0_5_4 - 0.0125474525474546*G0_0_0_5_5 + 0.0272698729841633*G0_0_0_5_6 + 0.00227772227772269*G0_0_0_5_7 - 0.00274011702583178*G0_0_0_5_8 - 0.00650777793635049*G0_0_0_5_9 - 0.00236208236208278*G0_0_0_6_0 - 0.00145124716553312*G0_0_0_6_1 - 0.00777254491540338*G0_0_0_6_2 + 0.00488083345226282*G0_0_0_6_3 - 0.0122448979591857*G0_0_0_6_4 + 0.0272698729841633*G0_0_0_6_5 - 0.0401883830455325*G0_0_0_6_6 + 0.000462394748109092*G0_0_0_6_7 + 0.00140430997573877*G0_0_0_6_8 + 0.00633652062223607*G0_0_0_6_9 + 0.00527916527916626*G0_0_0_7_0 - 0.000146520146520165*G0_0_0_7_1 - 0.00629656058227593*G0_0_0_7_3 + 0.00312259169402078*G0_0_0_7_4 + 0.00227772227772269*G0_0_0_7_5 + 0.000462394748109092*G0_0_0_7_6 + 0.00799200799200947*G0_0_0_7_7 - 0.00557157128585799*G0_0_0_7_8 - 0.0129128014842322*G0_0_0_7_9 - 0.00163392163392195*G0_0_0_8_0 + 0.00198658484372804*G0_0_0_8_1 + 0.000339343196486109*G0_0_0_8_2 + 0.0067874982160708*G0_0_0_8_3 - 0.000490937633794865*G0_0_0_8_4 - 0.00274011702583178*G0_0_0_8_5 + 0.00140430997573877*G0_0_0_8_6 - 0.00557157128585799*G0_0_0_8_7 - 0.0020779220779224*G0_0_0_8_8 + 0.00399600399600469*G0_0_0_9_0 + 0.000315874601588956*G0_0_0_9_1 - 0.00536606250892056*G0_0_0_9_2 + 0.011645497359785*G0_0_0_9_3 + 0.00137005851291595*G0_0_0_9_4 - 0.00650777793635049*G0_0_0_9_5 + 0.00633652062223607*G0_0_0_9_6 - 0.0129128014842322*G0_0_0_9_7 + 0.0267161410018598*G0_0_0_9_9 + 0.00136006850292589*G0_0_1_0_1 - 0.00136006850292587*G0_0_1_0_2 + 0.00178060035202922*G0_0_1_0_3 - 0.00178060035202923*G0_0_1_0_4 - 0.016245976245979*G0_0_1_0_5 + 0.00438672438672511*G0_0_1_0_6 + 0.0162459762459791*G0_0_1_0_7 - 0.00438672438672518*G0_0_1_0_8 + 0.00136006850292589*G0_0_1_1_0 + 0.00995646328979829*G0_0_1_1_1 + 0.0172023214880387*G0_0_1_1_3 - 0.00949146092003395*G0_0_1_1_4 - 0.000155558726987314*G0_0_1_1_5 + 0.00208045922331673*G0_0_1_1_7 + 0.00341483912912541*G0_0_1_1_8 + 0.0040321583178733*G0_0_1_1_9 - 0.00136006850292587*G0_0_1_2_0 - 0.00995646328979829*G0_0_1_2_2 + 0.00949146092003394*G0_0_1_2_3 - 0.0172023214880387*G0_0_1_2_4 - 0.00208045922331672*G0_0_1_2_5 - 0.00341483912912542*G0_0_1_2_6 + 0.000155558726987328*G0_0_1_2_7 - 0.00403215831787328*G0_0_1_2_9 + 0.00178060035202922*G0_0_1_3_0 + 0.0172023214880387*G0_0_1_3_1 + 0.00949146092003394*G0_0_1_3_2 + 0.0820750677893672*G0_0_1_3_3 - 0.00243756243756284*G0_0_1_3_5 + 0.000156985871271607*G0_0_1_3_6 - 0.00534180105608768*G0_0_1_3_7 + 0.00549878692735928*G0_0_1_3_8 - 0.00141287284144453*G0_0_1_3_9 - 0.00178060035202923*G0_0_1_4_0 - 0.00949146092003395*G0_0_1_4_1 - 0.0172023214880387*G0_0_1_4_2 - 0.0820750677893673*G0_0_1_4_4 + 0.00534180105608765*G0_0_1_4_5 - 0.00549878692735927*G0_0_1_4_6 + 0.00243756243756284*G0_0_1_4_7 - 0.000156985871271612*G0_0_1_4_8 + 0.00141287284144457*G0_0_1_4_9 - 0.016245976245979*G0_0_1_5_0 - 0.000155558726987314*G0_0_1_5_1 - 0.00208045922331672*G0_0_1_5_2 - 0.00243756243756283*G0_0_1_5_3 + 0.00534180105608765*G0_0_1_5_4 - 0.0397402597402664*G0_0_1_5_5 + 0.0228842585985482*G0_0_1_5_6 + 0.000466676180961945*G0_0_1_5_8 - 0.000933352361923948*G0_0_1_5_9 + 0.0043867243867251*G0_0_1_6_0 - 0.00341483912912542*G0_0_1_6_2 + 0.000156985871271607*G0_0_1_6_3 - 0.00549878692735927*G0_0_1_6_4 + 0.0228842585985482*G0_0_1_6_5 - 0.00830597973455251*G0_0_1_6_6 - 0.000466676180962003*G0_0_1_6_7 + 0.0117825032110767*G0_0_1_6_9 + 0.0162459762459791*G0_0_1_7_0 + 0.00208045922331673*G0_0_1_7_1 + 0.000155558726987328*G0_0_1_7_2 - 0.00534180105608768*G0_0_1_7_3 + 0.00243756243756284*G0_0_1_7_4 - 0.000466676180962002*G0_0_1_7_6 + 0.0397402597402666*G0_0_1_7_7 - 0.0228842585985482*G0_0_1_7_8 + 0.000933352361923975*G0_0_1_7_9 - 0.00438672438672518*G0_0_1_8_0 + 0.00341483912912541*G0_0_1_8_1 + 0.00549878692735928*G0_0_1_8_3 - 0.000156985871271613*G0_0_1_8_4 + 0.000466676180961945*G0_0_1_8_5 - 0.0228842585985482*G0_0_1_8_7 + 0.00830597973455262*G0_0_1_8_8 - 0.0117825032110767*G0_0_1_8_9 + 0.0040321583178733*G0_0_1_9_1 - 0.00403215831787328*G0_0_1_9_2 - 0.00141287284144453*G0_0_1_9_3 + 0.00141287284144457*G0_0_1_9_4 - 0.000933352361923951*G0_0_1_9_5 + 0.0117825032110767*G0_0_1_9_6 + 0.000933352361923979*G0_0_1_9_7 - 0.0117825032110767*G0_0_1_9_8 - 0.000238579762389303*G0_1_0_0_1 + 0.000238579762389345*G0_1_0_0_2 + 0.00277294134437039*G0_1_0_0_3 - 0.0027729413443704*G0_1_0_0_4 + 0.00568764568764685*G0_1_0_0_5 - 0.00511488511488609*G0_1_0_0_6 - 0.0056876456876464*G0_1_0_0_7 + 0.00511488511488587*G0_1_0_0_8 - 0.000238579762389303*G0_1_0_1_0 + 0.00785655261845871*G0_1_0_1_1 + 0.0158484372770114*G0_1_0_1_3 - 0.00931068931069089*G0_1_0_1_4 + 0.0012230626516343*G0_1_0_1_5 - 0.00173826173826204*G0_1_0_1_6 - 0.00238174523888847*G0_1_0_1_7 + 0.00634429063000598*G0_1_0_1_8 + 0.00164977879263623*G0_1_0_1_9 + 0.000238579762389345*G0_1_0_2_0 - 0.00785655261845873*G0_1_0_2_2 + 0.00931068931069089*G0_1_0_2_3 - 0.0158484372770114*G0_1_0_2_4 + 0.00238174523888851*G0_1_0_2_5 - 0.006344290630006*G0_1_0_2_6 - 0.00122306265163427*G0_1_0_2_7 + 0.00173826173826202*G0_1_0_2_8 - 0.00164977879263621*G0_1_0_2_9 + 0.00277294134437039*G0_1_0_3_0 + 0.0158484372770114*G0_1_0_3_1 + 0.00931068931069089*G0_1_0_3_2 + 0.0806193806193942*G0_1_0_3_3 - 0.00599400599400699*G0_1_0_3_5 + 0.00521478521478609*G0_1_0_3_6 - 0.00831882403311114*G0_1_0_3_7 + 0.0135336092478972*G0_1_0_3_8 + 0.0116883116883137*G0_1_0_3_9 - 0.0027729413443704*G0_1_0_4_0 - 0.00931068931069089*G0_1_0_4_1 - 0.0158484372770114*G0_1_0_4_2 - 0.0806193806193943*G0_1_0_4_4 + 0.00831882403311114*G0_1_0_4_5 - 0.0135336092478972*G0_1_0_4_6 + 0.00599400599400699*G0_1_0_4_7 - 0.00521478521478609*G0_1_0_4_8 - 0.0116883116883136*G0_1_0_4_9 + 0.00568764568764685*G0_1_0_5_0 + 0.0012230626516343*G0_1_0_5_1 + 0.00238174523888851*G0_1_0_5_2 - 0.00599400599400699*G0_1_0_5_3 + 0.00831882403311114*G0_1_0_5_4 + 0.0192007992008027*G0_1_0_5_5 + 0.00995718567147302*G0_1_0_5_6 - 0.00366918795490291*G0_1_0_5_8 + 0.00733837590980575*G0_1_0_5_9 - 0.00511488511488609*G0_1_0_6_0 - 0.00173826173826204*G0_1_0_6_1 - 0.006344290630006*G0_1_0_6_2 + 0.00521478521478609*G0_1_0_6_3 - 0.0135336092478972*G0_1_0_6_4 + 0.00995718567147302*G0_1_0_6_5 - 0.0298044812330576*G0_1_0_6_6 + 0.00366918795490279*G0_1_0_6_7 - 0.00548023405166353*G0_1_0_6_9 - 0.0056876456876464*G0_1_0_7_0 - 0.00238174523888847*G0_1_0_7_1 - 0.00122306265163427*G0_1_0_7_2 - 0.00831882403311114*G0_1_0_7_3 + 0.00599400599400699*G0_1_0_7_4 + 0.00366918795490279*G0_1_0_7_6 - 0.0192007992008021*G0_1_0_7_7 - 0.00995718567147319*G0_1_0_7_8 - 0.0073383759098057*G0_1_0_7_9 + 0.00511488511488587*G0_1_0_8_0 + 0.00634429063000598*G0_1_0_8_1 + 0.00173826173826202*G0_1_0_8_2 + 0.0135336092478972*G0_1_0_8_3 - 0.00521478521478609*G0_1_0_8_4 - 0.00366918795490291*G0_1_0_8_5 - 0.0099571856714732*G0_1_0_8_7 + 0.0298044812330578*G0_1_0_8_8 + 0.00548023405166354*G0_1_0_8_9 + 0.00164977879263622*G0_1_0_9_1 - 0.00164977879263621*G0_1_0_9_2 + 0.0116883116883137*G0_1_0_9_3 - 0.0116883116883136*G0_1_0_9_4 + 0.00733837590980575*G0_1_0_9_5 - 0.00548023405166352*G0_1_0_9_6 - 0.0073383759098057*G0_1_0_9_7 + 0.00548023405166354*G0_1_0_9_8 + 0.000558524368048299*G0_1_1_0_1 - 0.00056296437248826*G0_1_1_0_2 + 0.0022789908504198*G0_1_1_0_3 - 0.00227455084597982*G0_1_1_0_4 - 0.00527916527916596*G0_1_1_0_5 + 0.00163392163392181*G0_1_1_0_6 + 0.00527916527916645*G0_1_1_0_7 + 0.00236208236208264*G0_1_1_0_8 - 0.00399600399600464*G0_1_1_0_9 + 0.000558524368048299*G0_1_1_1_0 + 0.00758352758352883*G0_1_1_1_1 + 0.0162567591139047*G0_1_1_1_3 - 0.00952698095555399*G0_1_1_1_4 - 0.000339343196486119*G0_1_1_1_6 - 0.000154765869051561*G0_1_1_1_7 + 0.00777254491540333*G0_1_1_1_8 + 0.00536606250892057*G0_1_1_1_9 - 0.00056296437248826*G0_1_1_2_0 - 0.0102294883247282*G0_1_1_2_2 + 0.00927516927517084*G0_1_1_2_3 - 0.0167939996511454*G0_1_1_2_4 + 0.000146520146520202*G0_1_1_2_5 - 0.00198658484372806*G0_1_1_2_6 - 0.0010890696604984*G0_1_1_2_7 + 0.00145124716553311*G0_1_1_2_8 - 0.000315874601588941*G0_1_1_2_9 + 0.0022789908504198*G0_1_1_3_0 + 0.0162567591139047*G0_1_1_3_1 + 0.00927516927517084*G0_1_1_3_2 + 0.0823747680890676*G0_1_1_3_3 + 0.001027543884687*G0_1_1_3_4 - 0.00312259169402078*G0_1_1_3_5 + 0.000490937633794872*G0_1_1_3_6 - 0.00736406450692288*G0_1_1_3_7 + 0.0122448979591857*G0_1_1_3_8 - 0.00137005851291593*G0_1_1_3_9 - 0.00227455084597982*G0_1_1_4_0 - 0.00952698095555399*G0_1_1_4_1 - 0.0167939996511454*G0_1_1_4_2 + 0.001027543884687*G0_1_1_4_3 - 0.0803196803196939*G0_1_1_4_4 + 0.00629656058227592*G0_1_1_4_5 - 0.00678749821607081*G0_1_1_4_6 + 0.00530897673754904*G0_1_1_4_7 - 0.00488083345226281*G0_1_1_4_8 - 0.011645497359785*G0_1_1_4_9 - 0.00527916527916596*G0_1_1_5_0 + 0.000146520146520202*G0_1_1_5_2 - 0.00312259169402078*G0_1_1_5_3 + 0.00629656058227593*G0_1_1_5_4 - 0.00799200799200911*G0_1_1_5_5 + 0.00557157128585786*G0_1_1_5_6 - 0.00227772227772252*G0_1_1_5_7 - 0.000462394748109191*G0_1_1_5_8 + 0.0129128014842323*G0_1_1_5_9 + 0.00163392163392181*G0_1_1_6_0 - 0.000339343196486119*G0_1_1_6_1 - 0.00198658484372806*G0_1_1_6_2 + 0.000490937633794873*G0_1_1_6_3 - 0.00678749821607081*G0_1_1_6_4 + 0.00557157128585786*G0_1_1_6_5 + 0.00207792207792244*G0_1_1_6_6 + 0.0027401170258317*G0_1_1_6_7 - 0.00140430997573873*G0_1_1_6_8 + 0.00527916527916645*G0_1_1_7_0 - 0.000154765869051562*G0_1_1_7_1 - 0.0010890696604984*G0_1_1_7_2 - 0.00736406450692288*G0_1_1_7_3 + 0.00530897673754904*G0_1_1_7_4 - 0.00227772227772252*G0_1_1_7_5 + 0.0027401170258317*G0_1_1_7_6 + 0.012547452547455*G0_1_1_7_7 - 0.0272698729841634*G0_1_1_7_8 + 0.00650777793635053*G0_1_1_7_9 + 0.00236208236208264*G0_1_1_8_0 + 0.00777254491540333*G0_1_1_8_1 + 0.00145124716553311*G0_1_1_8_2 + 0.0122448979591857*G0_1_1_8_3 - 0.00488083345226281*G0_1_1_8_4 - 0.000462394748109191*G0_1_1_8_5 - 0.00140430997573873*G0_1_1_8_6 - 0.0272698729841634*G0_1_1_8_7 + 0.0401883830455325*G0_1_1_8_8 - 0.00633652062223606*G0_1_1_8_9 - 0.00399600399600464*G0_1_1_9_0 + 0.00536606250892057*G0_1_1_9_1 - 0.00031587460158894*G0_1_1_9_2 - 0.00137005851291593*G0_1_1_9_3 - 0.011645497359785*G0_1_1_9_4 + 0.0129128014842323*G0_1_1_9_5 + 0.00650777793635053*G0_1_1_9_7 - 0.00633652062223606*G0_1_1_9_8 - 0.0267161410018597*G0_1_1_9_9;
    A[56] = -A[176] + 0.0443464824417283*G0_0_0_0_0 + 0.00902406235739731*G0_0_0_0_1 + 0.00420489563346779*G0_0_0_0_2 + 0.00487808487808571*G0_0_0_0_3 - 0.00190370476084794*G0_0_0_0_4 + 0.0310191395905736*G0_0_0_0_5 - 0.0150947465233206*G0_0_0_0_6 + 0.00577454291740106*G0_0_0_0_7 + 0.00368520368520433*G0_0_0_0_8 + 0.0062642119784988*G0_0_0_0_9 + 0.00902406235739731*G0_0_0_1_0 + 0.259513326180038*G0_0_0_1_1 + 0.007976221309556*G0_0_0_1_2 + 0.0714248714248837*G0_0_0_1_3 - 0.0346468346468406*G0_0_0_1_4 + 0.00542864542864624*G0_0_0_1_5 + 0.00120176120176144*G0_0_0_1_6 - 0.0311540311540367*G0_0_0_1_7 + 0.0616864616864726*G0_0_0_1_8 + 0.00150960150960183*G0_0_0_1_9 + 0.00420489563346779*G0_0_0_2_0 + 0.007976221309556*G0_0_0_2_1 + 0.00472698377460362*G0_0_0_2_2 + 0.00770192770192898*G0_0_0_2_3 - 0.00649086363372187*G0_0_0_2_4 + 0.00474530760245129*G0_0_0_2_5 - 0.00443408443408519*G0_0_0_2_6 + 0.00224706510420834*G0_0_0_2_7 + 0.0160136160136187*G0_0_0_2_8 + 0.0139999682856849*G0_0_0_2_9 + 0.0048780848780857*G0_0_0_3_0 + 0.0714248714248838*G0_0_0_3_1 + 0.00770192770192898*G0_0_0_3_2 + 0.0101232101232116*G0_0_0_3_3 - 0.0319147519147572*G0_0_0_3_4 - 0.0100166500166517*G0_0_0_3_5 - 0.0144921744921769*G0_0_0_3_6 - 0.0255211455211499*G0_0_0_3_7 + 0.0844488844488987*G0_0_0_3_8 + 0.0465134865134943*G0_0_0_3_9 - 0.00190370476084794*G0_0_0_4_0 - 0.0346468346468406*G0_0_0_4_1 - 0.00649086363372187*G0_0_0_4_2 - 0.0319147519147572*G0_0_0_4_3 + 0.0329803529803585*G0_0_0_4_4 - 0.00517577660434893*G0_0_0_4_5 + 0.0196679510965258*G0_0_0_4_6 + 0.00492840492840576*G0_0_0_4_7 - 0.0589277389277488*G0_0_0_4_8 - 0.031648351648357*G0_0_0_4_9 + 0.0310191395905736*G0_0_0_5_0 + 0.00542864542864624*G0_0_0_5_1 + 0.00474530760245129*G0_0_0_5_2 - 0.0100166500166517*G0_0_0_5_3 - 0.00517577660434893*G0_0_0_5_4 + 0.188748394462712*G0_0_0_5_5 - 0.029661766804629*G0_0_0_5_6 + 0.0448009133723495*G0_0_0_5_7 - 0.0271728271728318*G0_0_0_5_8 + 0.0355530184101673*G0_0_0_5_9 - 0.0150947465233206*G0_0_0_6_0 + 0.00120176120176144*G0_0_0_6_1 - 0.00443408443408519*G0_0_0_6_2 - 0.0144921744921769*G0_0_0_6_3 + 0.0196679510965258*G0_0_0_6_4 - 0.029661766804629*G0_0_0_6_5 + 0.0887569573284007*G0_0_0_6_6 - 0.0176280861995177*G0_0_0_6_7 - 0.0203796203796238*G0_0_0_6_8 - 0.013015555872701*G0_0_0_6_9 + 0.00577454291740106*G0_0_0_7_0 - 0.0311540311540367*G0_0_0_7_1 + 0.00224706510420834*G0_0_0_7_2 - 0.0255211455211499*G0_0_0_7_3 + 0.00492840492840576*G0_0_0_7_4 + 0.0448009133723495*G0_0_0_7_5 - 0.0176280861995177*G0_0_0_7_6 + 0.101018981018998*G0_0_0_7_7 - 0.0570629370629467*G0_0_0_7_8 + 0.0164635364635393*G0_0_0_7_9 + 0.00368520368520433*G0_0_0_8_0 + 0.0616864616864726*G0_0_0_8_1 + 0.0160136160136187*G0_0_0_8_2 + 0.0844488844488987*G0_0_0_8_3 - 0.0589277389277488*G0_0_0_8_4 - 0.0271728271728318*G0_0_0_8_5 - 0.0203796203796238*G0_0_0_8_6 - 0.0570629370629467*G0_0_0_8_7 + 0.327672327672383*G0_0_0_8_8 + 0.113326673326692*G0_0_0_8_9 + 0.0062642119784988*G0_0_0_9_0 + 0.00150960150960183*G0_0_0_9_1 + 0.0139999682856849*G0_0_0_9_2 + 0.0465134865134943*G0_0_0_9_3 - 0.031648351648357*G0_0_0_9_4 + 0.0355530184101673*G0_0_0_9_5 - 0.013015555872701*G0_0_0_9_6 + 0.0164635364635393*G0_0_0_9_7 + 0.113326673326692*G0_0_0_9_8 + 0.258941058941103*G0_0_0_9_9 - 0.00184140374616603*G0_0_1_0_0 + 0.00879614212947705*G0_0_1_0_1 - 0.00107419916943744*G0_0_1_0_2 - 0.0102031302031319*G0_0_1_0_3 + 0.0037029637029643*G0_0_1_0_4 + 0.000279085993371709*G0_0_1_0_5 + 0.00136371564943018*G0_0_1_0_6 + 0.00298368298368343*G0_0_1_0_7 - 0.00737928737928854*G0_0_1_0_8 - 0.00868464868465014*G0_0_1_0_9 + 0.00879614212947705*G0_0_1_1_0 + 0.294322960989679*G0_0_1_1_1 + 0.00879614212947696*G0_0_1_1_2 + 0.0811632811632952*G0_0_1_1_3 - 0.0395160395160463*G0_0_1_1_4 - 0.000666000666000888*G0_0_1_1_5 - 0.000666000666000741*G0_0_1_1_6 - 0.0395160395160465*G0_0_1_1_7 + 0.0811632811632956*G0_0_1_1_8 + 0.00426240426240506*G0_0_1_1_9 - 0.00107419916943744*G0_0_1_2_0 + 0.00879614212947696*G0_0_1_2_1 - 0.00184140374616595*G0_0_1_2_2 - 0.00737928737928859*G0_0_1_2_3 + 0.00298368298368347*G0_0_1_2_4 + 0.00136371564943014*G0_0_1_2_5 + 0.000279085993371762*G0_0_1_2_6 + 0.0037029637029643*G0_0_1_2_7 - 0.0102031302031319*G0_0_1_2_8 - 0.00868464868465012*G0_0_1_2_9 - 0.0102031302031319*G0_0_1_3_0 + 0.0811632811632952*G0_0_1_3_1 - 0.0073792873792886*G0_0_1_3_2 - 0.148651348651374*G0_0_1_3_3 + 0.0307692307692358*G0_0_1_3_4 + 0.0130269730269751*G0_0_1_3_5 + 0.00855144855144997*G0_0_1_3_6 + 0.0371628371628432*G0_0_1_3_7 - 0.0743256743256864*G0_0_1_3_8 - 0.0871128871129016*G0_0_1_3_9 + 0.0037029637029643*G0_0_1_4_0 - 0.0395160395160463*G0_0_1_4_1 + 0.00298368298368347*G0_0_1_4_2 + 0.0307692307692358*G0_0_1_4_3 - 0.0103896103896121*G0_0_1_4_4 - 0.00455544455544528*G0_0_1_4_5 - 0.00399600399600465*G0_0_1_4_6 - 0.0143856143856167*G0_0_1_4_7 + 0.0371628371628432*G0_0_1_4_8 + 0.035164835164841*G0_0_1_4_9 + 0.000279085993371709*G0_0_1_5_0 - 0.000666000666000888*G0_0_1_5_1 + 0.00136371564943014*G0_0_1_5_2 + 0.0130269730269751*G0_0_1_5_3 - 0.00455544455544528*G0_0_1_5_4 - 0.0063251034679617*G0_0_1_5_5 - 0.000468103325246228*G0_0_1_5_6 - 0.00399600399600465*G0_0_1_5_7 + 0.00855144855144993*G0_0_1_5_8 + 0.0089510489510504*G0_0_1_5_9 + 0.00136371564943018*G0_0_1_6_0 - 0.000666000666000741*G0_0_1_6_1 + 0.000279085993371762*G0_0_1_6_2 + 0.00855144855144997*G0_0_1_6_3 - 0.00399600399600465*G0_0_1_6_4 - 0.000468103325246228*G0_0_1_6_5 - 0.00632510346796161*G0_0_1_6_6 - 0.0045554445554453*G0_0_1_6_7 + 0.0130269730269752*G0_0_1_6_8 + 0.00895104895105045*G0_0_1_6_9 + 0.00298368298368343*G0_0_1_7_0 - 0.0395160395160465*G0_0_1_7_1 + 0.0037029637029643*G0_0_1_7_2 + 0.0371628371628432*G0_0_1_7_3 - 0.0143856143856167*G0_0_1_7_4 - 0.00399600399600465*G0_0_1_7_5 - 0.0045554445554453*G0_0_1_7_6 - 0.010389610389612*G0_0_1_7_7 + 0.0307692307692356*G0_0_1_7_8 + 0.035164835164841*G0_0_1_7_9 - 0.00737928737928854*G0_0_1_8_0 + 0.0811632811632956*G0_0_1_8_1 - 0.0102031302031319*G0_0_1_8_2 - 0.0743256743256864*G0_0_1_8_3 + 0.0371628371628432*G0_0_1_8_4 + 0.00855144855144993*G0_0_1_8_5 + 0.0130269730269752*G0_0_1_8_6 + 0.0307692307692356*G0_0_1_8_7 - 0.148651348651373*G0_0_1_8_8 - 0.0871128871129016*G0_0_1_8_9 - 0.00868464868465014*G0_0_1_9_0 + 0.00426240426240506*G0_0_1_9_1 - 0.00868464868465012*G0_0_1_9_2 - 0.0871128871129016*G0_0_1_9_3 + 0.035164835164841*G0_0_1_9_4 + 0.0089510489510504*G0_0_1_9_5 + 0.00895104895105045*G0_0_1_9_6 + 0.035164835164841*G0_0_1_9_7 - 0.0871128871129015*G0_0_1_9_8 - 0.0671328671328785*G0_0_1_9_9;
    A[99] = A[56] - 0.0820535372916465*G0_0_0_0_0 - 0.00904971571638392*G0_0_0_0_2 + 0.00965891251605706*G0_0_0_0_3 + 0.000243565957851712*G0_0_0_0_4 - 0.102559028273331*G0_0_0_0_5 + 0.0426823969681185*G0_0_0_0_6 - 0.0374482660197009*G0_0_0_0_7 + 0.0198582370010975*G0_0_0_0_8 - 0.0149031920460517*G0_0_0_0_9 + 0.0820535372916462*G0_0_0_1_1 + 0.0090497157163839*G0_0_0_1_2 + 0.102559028273331*G0_0_0_1_3 - 0.0426823969681184*G0_0_0_1_4 - 0.00965891251605699*G0_0_0_1_5 - 0.000243565957851716*G0_0_0_1_6 - 0.0198582370010975*G0_0_0_1_7 + 0.0374482660197009*G0_0_0_1_8 + 0.0149031920460518*G0_0_0_1_9 - 0.00904971571638392*G0_0_0_2_0 + 0.0090497157163839*G0_0_0_2_1 + 0.0153852496709666*G0_0_0_2_3 - 0.00416091844663345*G0_0_0_2_4 - 0.0153852496709666*G0_0_0_2_5 + 0.00416091844663345*G0_0_0_2_6 - 0.00226820798249409*G0_0_0_2_7 + 0.0022682079824941*G0_0_0_2_8 + 0.00965891251605707*G0_0_0_3_0 + 0.102559028273331*G0_0_0_3_1 + 0.0153852496709666*G0_0_0_3_2 + 0.319132296275208*G0_0_0_3_3 - 0.0805594405594543*G0_0_0_3_4 + 0.000730697873555106*G0_0_0_3_6 - 0.0289767375481711*G0_0_0_3_7 + 0.0357813614956534*G0_0_0_3_8 + 0.0132438989581871*G0_0_0_3_9 + 0.000243565957851712*G0_0_0_4_0 - 0.0426823969681184*G0_0_0_4_1 - 0.00416091844663345*G0_0_0_4_2 - 0.0805594405594543*G0_0_0_4_3 + 0.0683202511774056*G0_0_0_4_4 - 0.000730697873555104*G0_0_0_4_5 + 0.0030369630369636*G0_0_0_4_7 - 0.00680462394748231*G0_0_0_4_8 + 0.00146139574711022*G0_0_0_4_9 - 0.102559028273331*G0_0_0_5_0 - 0.00965891251605699*G0_0_0_5_1 - 0.0153852496709666*G0_0_0_5_2 - 0.000730697873555106*G0_0_0_5_4 - 0.319132296275207*G0_0_0_5_5 + 0.0805594405594543*G0_0_0_5_6 - 0.0357813614956532*G0_0_0_5_7 + 0.028976737548171*G0_0_0_5_8 - 0.013243898958187*G0_0_0_5_9 + 0.0426823969681185*G0_0_0_6_0 - 0.000243565957851715*G0_0_0_6_1 + 0.00416091844663345*G0_0_0_6_2 + 0.000730697873555106*G0_0_0_6_3 + 0.0805594405594543*G0_0_0_6_5 - 0.0683202511774054*G0_0_0_6_6 + 0.00680462394748224*G0_0_0_6_7 - 0.00303696303696358*G0_0_0_6_8 - 0.0014613957471102*G0_0_0_6_9 - 0.0374482660197009*G0_0_0_7_0 - 0.0198582370010975*G0_0_0_7_1 - 0.00226820798249409*G0_0_0_7_2 - 0.0289767375481711*G0_0_0_7_3 + 0.0030369630369636*G0_0_0_7_4 - 0.0357813614956532*G0_0_0_7_5 + 0.00680462394748224*G0_0_0_7_6 + 0.029364920793497*G0_0_0_7_7 + 0.0311003282431905*G0_0_0_7_9 + 0.0198582370010975*G0_0_0_8_0 + 0.0374482660197009*G0_0_0_8_1 + 0.0022682079824941*G0_0_0_8_2 + 0.0357813614956534*G0_0_0_8_3 - 0.00680462394748231*G0_0_0_8_4 + 0.028976737548171*G0_0_0_8_5 - 0.00303696303696357*G0_0_0_8_6 - 0.0293649207934969*G0_0_0_8_8 - 0.0311003282431905*G0_0_0_8_9 - 0.0149031920460517*G0_0_0_9_0 + 0.0149031920460518*G0_0_0_9_1 + 0.0132438989581871*G0_0_0_9_3 + 0.00146139574711022*G0_0_0_9_4 - 0.013243898958187*G0_0_0_9_5 - 0.00146139574711019*G0_0_0_9_6 + 0.0311003282431905*G0_0_0_9_7 - 0.0311003282431905*G0_0_0_9_8 + 0.0242460890079978*G0_0_1_0_0 + 0.0105376105376123*G0_0_1_0_1 + 0.00508641270546117*G0_0_1_0_2 + 0.0222592222592261*G0_0_1_0_3 - 0.00799877371306077*G0_0_1_0_4 + 0.0256649170934927*G0_0_1_0_5 - 0.0137014308442902*G0_0_1_0_6 + 0.0192450935308109*G0_0_1_0_7 + 0.00298960298960356*G0_0_1_0_8 + 0.0160804275090017*G0_0_1_0_9 + 0.0105376105376123*G0_0_1_1_0 + 0.106299626299644*G0_0_1_1_1 + 0.0141361284218451*G0_0_1_1_2 + 0.128223945366824*G0_0_1_1_3 - 0.0563838278124087*G0_0_1_1_4 + 0.012600309743169*G0_0_1_1_5 - 0.00824233967091247*G0_0_1_1_6 - 0.016868634011494*G0_0_1_1_7 + 0.0566933595505119*G0_0_1_1_8 + 0.0309836195550534*G0_0_1_1_9 + 0.00508641270546117*G0_0_1_2_0 + 0.0141361284218451*G0_0_1_2_1 + 0.00861952861953004*G0_0_1_2_2 + 0.0286392972107306*G0_0_1_2_3 - 0.0115643087071678*G0_0_1_2_4 + 0.0132540475397641*G0_0_1_2_5 - 0.00740339026053436*G0_0_1_2_6 + 0.00783555069269485*G0_0_1_2_7 + 0.0101037586751889*G0_0_1_2_8 + 0.0209771181199788*G0_0_1_2_9 + 0.0222592222592261*G0_0_1_3_0 + 0.128223945366824*G0_0_1_3_1 + 0.0286392972107306*G0_0_1_3_2 + 0.508268873983246*G0_0_1_3_3 - 0.147167118595715*G0_0_1_3_4 - 0.035279006707584*G0_0_1_3_5 - 0.00929356357927943*G0_0_1_3_6 - 0.100798249369695*G0_0_1_3_7 + 0.165130107987279*G0_0_1_3_8 + 0.10864564007423*G0_0_1_3_9 - 0.00799877371306077*G0_0_1_4_0 - 0.0563838278124087*G0_0_1_4_1 - 0.0115643087071678*G0_0_1_4_2 - 0.147167118595715*G0_0_1_4_3 + 0.111225916940222*G0_0_1_4_4 - 0.0100242614528346*G0_0_1_4_5 + 0.019317825032114*G0_0_1_4_6 + 0.0172551258265573*G0_0_1_4_7 - 0.0643318586175836*G0_0_1_4_8 - 0.0428828314542672*G0_0_1_4_9 + 0.0256649170934927*G0_0_1_5_0 + 0.012600309743169*G0_0_1_5_1 + 0.0132540475397641*G0_0_1_5_2 - 0.035279006707584*G0_0_1_5_3 - 0.0100242614528346*G0_0_1_5_4 + 0.189136577708038*G0_0_1_5_5 - 0.0666076780362606*G0_0_1_5_6 + 0.129348746491625*G0_0_1_5_7 - 0.0718215118215238*G0_0_1_5_8 + 0.0954017411160429*G0_0_1_5_9 - 0.0137014308442902*G0_0_1_6_0 - 0.00824233967091247*G0_0_1_6_1 - 0.00740339026053436*G0_0_1_6_2 - 0.00929356357927943*G0_0_1_6_3 + 0.019317825032114*G0_0_1_6_4 - 0.0666076780362606*G0_0_1_6_5 + 0.0429056657628158*G0_0_1_6_6 - 0.0575272346701014*G0_0_1_6_7 + 0.0142181627895937*G0_0_1_6_8 - 0.0443442272013775*G0_0_1_6_9 + 0.0192450935308109*G0_0_1_7_0 - 0.016868634011494*G0_0_1_7_1 + 0.00783555069269485*G0_0_1_7_2 - 0.100798249369695*G0_0_1_7_3 + 0.0172551258265573*G0_0_1_7_4 + 0.129348746491625*G0_0_1_7_5 - 0.0575272346701014*G0_0_1_7_6 + 0.217968697968734*G0_0_1_7_7 - 0.133200133200155*G0_0_1_7_8 + 0.066813186813198*G0_0_1_7_9 + 0.00298960298960356*G0_0_1_8_0 + 0.0566933595505119*G0_0_1_8_1 + 0.0101037586751889*G0_0_1_8_2 + 0.165130107987279*G0_0_1_8_3 - 0.0643318586175836*G0_0_1_8_4 - 0.0718215118215238*G0_0_1_8_5 + 0.0142181627895937*G0_0_1_8_6 - 0.133200133200155*G0_0_1_8_7 + 0.188603777175237*G0_0_1_8_8 + 0.0357128585700074*G0_0_1_8_9 + 0.0160804275090017*G0_0_1_9_0 + 0.0309836195550534*G0_0_1_9_1 + 0.0209771181199788*G0_0_1_9_2 + 0.10864564007423*G0_0_1_9_3 - 0.0428828314542672*G0_0_1_9_4 + 0.0954017411160429*G0_0_1_9_5 - 0.0443442272013775*G0_0_1_9_6 + 0.066813186813198*G0_0_1_9_7 + 0.0357128585700073*G0_0_1_9_8 + 0.22331953760529*G0_0_1_9_9 + 0.31672764625151*G0_1_0_0_0 + 0.0281298947965664*G0_1_0_0_1 + 0.0128083556655007*G0_1_0_0_2 + 0.0113900913900933*G0_1_0_0_3 - 0.00496181067609723*G0_1_0_0_4 + 0.10710728425016*G0_1_0_0_5 - 0.0518537547109064*G0_1_0_0_6 + 0.10339205767779*G0_1_0_0_7 - 0.0439057239057313*G0_1_0_0_8 + 0.0116581830867567*G0_1_0_0_9 + 0.0281298947965664*G0_1_0_1_0 + 0.398781183543157*G0_1_0_1_1 + 0.0218580713818846*G0_1_0_1_2 + 0.209666312523491*G0_1_0_1_3 - 0.0945361516790248*G0_1_0_1_4 + 0.00173117887403619*G0_1_0_1_5 - 0.0052053766339489*G0_1_0_1_6 - 0.0637639609068291*G0_1_0_1_7 + 0.140840323697491*G0_1_0_1_8 + 0.0265613751328083*G0_1_0_1_9 + 0.0128083556655007*G0_1_0_2_0 + 0.0218580713818846*G0_1_0_2_1 + 0.0049367211271981*G0_1_0_2_2 + 0.0226237254808722*G0_1_0_2_3 - 0.00830153973011257*G0_1_0_2_4 + 0.00723847580990561*G0_1_0_2_5 - 0.00414062128347914*G0_1_0_2_6 + 0.00133538419252726*G0_1_0_2_7 + 0.00360359217502138*G0_1_0_2_8 + 0.00360782075067852*G0_1_0_2_9 + 0.0113900913900933*G0_1_0_3_0 + 0.209666312523491*G0_1_0_3_1 + 0.0226237254808722*G0_1_0_3_2 + 0.35329242186391*G0_1_0_3_3 - 0.116865991151725*G0_1_0_3_4 - 0.00922506065363368*G0_1_0_3_5 - 0.00529755958327476*G0_1_0_3_6 - 0.0550839636554017*G0_1_0_3_7 + 0.0868084296655875*G0_1_0_3_8 + 0.0304838019123788*G0_1_0_3_9 - 0.00496181067609723*G0_1_0_4_0 - 0.0945361516790248*G0_1_0_4_1 - 0.00830153973011257*G0_1_0_4_2 - 0.116865991151725*G0_1_0_4_3 + 0.0945112030826476*G0_1_0_4_4 - 0.00602825745682989*G0_1_0_4_5 + 0.0113258170401047*G0_1_0_4_6 + 0.0158964844679158*G0_1_0_4_7 - 0.0317244660101858*G0_1_0_4_8 + 0.00123305266162421*G0_1_0_4_9 + 0.10710728425016*G0_1_0_5_0 + 0.00173117887403619*G0_1_0_5_1 + 0.00723847580990561*G0_1_0_5_2 - 0.00922506065363369*G0_1_0_5_3 - 0.00602825745682989*G0_1_0_5_4 + 0.0341601255887029*G0_1_0_5_5 - 0.0363065505922711*G0_1_0_5_6 + 0.0510270681699339*G0_1_0_5_7 - 0.0261072261072306*G0_1_0_5_8 + 0.0172399029541916*G0_1_0_5_9 - 0.0518537547109064*G0_1_0_6_0 - 0.0052053766339489*G0_1_0_6_1 - 0.00414062128347914*G0_1_0_6_2 - 0.00529755958327476*G0_1_0_6_3 + 0.0113258170401047*G0_1_0_6_4 - 0.0363065505922711*G0_1_0_6_5 + 0.0261909519052421*G0_1_0_6_6 - 0.0249198420627034*G0_1_0_6_7 + 0.0128595214309522*G0_1_0_6_8 - 0.000228343085485991*G0_1_0_6_9 + 0.10339205767779*G0_1_0_7_0 - 0.0637639609068291*G0_1_0_7_1 + 0.00133538419252726*G0_1_0_7_2 - 0.0550839636554017*G0_1_0_7_3 + 0.0158964844679158*G0_1_0_7_4 + 0.0510270681699339*G0_1_0_7_5 - 0.0249198420627034*G0_1_0_7_6 + 0.0589277389277491*G0_1_0_7_7 - 0.071661671661684*G0_1_0_7_8 + 0.0148651348651373*G0_1_0_7_9 - 0.0439057239057313*G0_1_0_8_0 + 0.140840323697491*G0_1_0_8_1 + 0.00360359217502138*G0_1_0_8_2 + 0.0868084296655875*G0_1_0_8_3 - 0.0317244660101858*G0_1_0_8_4 - 0.0261072261072306*G0_1_0_8_5 + 0.0128595214309522*G0_1_0_8_6 - 0.071661671661684*G0_1_0_8_7 + 0.0295628181342524*G0_1_0_8_8 - 0.0162351933780531*G0_1_0_8_9 + 0.0116581830867567*G0_1_0_9_0 + 0.0265613751328083*G0_1_0_9_1 + 0.00360782075067852*G0_1_0_9_2 + 0.0304838019123788*G0_1_0_9_3 + 0.00123305266162421*G0_1_0_9_4 + 0.0172399029541916*G0_1_0_9_5 - 0.000228343085485991*G0_1_0_9_6 + 0.0148651348651373*G0_1_0_9_7 - 0.0162351933780531*G0_1_0_9_8 + 0.0890538033395328*G0_1_0_9_9 - 0.0752754124182822*G0_1_1_0_0 + 0.0193337526670894*G0_1_1_0_1 - 0.00143898429612738*G0_1_1_0_2 + 0.0304021904021957*G0_1_1_0_3 - 0.00906056906057061*G0_1_1_0_4 - 0.0381527467241816*G0_1_1_0_5 + 0.0177849663563979*G0_1_1_0_6 - 0.117559477559497*G0_1_1_0_7 + 0.0806334406334543*G0_1_1_0_8 - 0.00261072261072305*G0_1_1_0_9 + 0.0193337526670894*G0_1_1_1_0 + 0.498302684969437*G0_1_1_1_1 + 0.0283834683834731*G0_1_1_1_2 + 0.273483976341166*G0_1_1_1_3 - 0.126022548879713*G0_1_1_1_4 - 0.00641178926893335*G0_1_1_1_5 - 0.00414358128643906*G0_1_1_1_6 - 0.14140779855068*G0_1_1_1_7 + 0.277644894787799*G0_1_1_1_8 + 0.0452525252525331*G0_1_1_1_9 - 0.00143898429612738*G0_1_1_2_0 + 0.0283834683834731*G0_1_1_2_1 + 0.00677812487336409*G0_1_1_2_2 + 0.0379510436653357*G0_1_1_2_3 - 0.0150004492861661*G0_1_1_2_4 - 0.00207327064469955*G0_1_1_2_5 - 0.000704480704480828*G0_1_1_2_6 - 0.0187194815766276*G0_1_1_2_7 + 0.0301586244443438*G0_1_1_2_8 + 0.0122924694353287*G0_1_1_2_9 + 0.0304021904021957*G0_1_1_3_0 + 0.273483976341166*G0_1_1_3_1 + 0.0379510436653357*G0_1_1_3_2 + 0.505315636744294*G0_1_1_3_3 - 0.182990342990374*G0_1_1_3_4 - 0.0222520336806088*G0_1_1_3_5 - 0.0150363921792518*G0_1_1_3_6 - 0.118673707245156*G0_1_1_3_7 + 0.236616716616757*G0_1_1_3_8 + 0.101589838732713*G0_1_1_3_9 - 0.00906056906057061*G0_1_1_4_0 - 0.126022548879713*G0_1_1_4_1 - 0.0150004492861661*G0_1_1_4_2 - 0.182990342990374*G0_1_1_4_3 + 0.129668426811306*G0_1_1_4_4 - 0.000285428856857499*G0_1_1_4_5 + 0.0153218210361093*G0_1_1_4_6 + 0.0554036439750818*G0_1_1_4_7 - 0.117943009371601*G0_1_1_4_8 - 0.036306550592271*G0_1_1_4_9 - 0.0381527467241816*G0_1_1_5_0 - 0.00641178926893335*G0_1_1_5_1 - 0.00207327064469955*G0_1_1_5_2 - 0.0222520336806088*G0_1_1_5_3 - 0.000285428856857499*G0_1_1_5_4 + 0.0371133628276549*G0_1_1_5_5 - 0.00048332619761205*G0_1_1_5_6 - 0.0204595404595437*G0_1_1_5_7 - 0.00823176823176978*G0_1_1_5_8 + 0.0242957042957084*G0_1_1_5_9 + 0.0177849663563979*G0_1_1_6_0 - 0.00414358128643906*G0_1_1_6_1 - 0.000704480704480828*G0_1_1_6_2 - 0.0150363921792518*G0_1_1_6_3 + 0.0153218210361093*G0_1_1_6_4 - 0.00048332619761205*G0_1_1_6_5 + 0.00774844203415768*G0_1_1_6_6 + 0.0286913086913134*G0_1_1_6_7 - 0.0252889967175723*G0_1_1_6_8 - 0.00680462394748221*G0_1_1_6_9 - 0.117559477559497*G0_1_1_7_0 - 0.14140779855068*G0_1_1_7_1 - 0.0187194815766276*G0_1_1_7_2 - 0.118673707245156*G0_1_1_7_3 + 0.0554036439750818*G0_1_1_7_4 - 0.0204595404595437*G0_1_1_7_5 + 0.0286913086913134*G0_1_1_7_6 - 0.189463869463901*G0_1_1_7_7 - 0.10243090243092*G0_1_1_7_8 - 0.049550449550458*G0_1_1_7_9 + 0.0806334406334543*G0_1_1_8_0 + 0.277644894787799*G0_1_1_8_1 + 0.0301586244443438*G0_1_1_8_2 + 0.236616716616757*G0_1_1_8_3 - 0.117943009371601*G0_1_1_8_4 - 0.00823176823176978*G0_1_1_8_5 - 0.0252889967175723*G0_1_1_8_6 - 0.10243090243092*G0_1_1_8_7 + 0.436995385566888*G0_1_1_8_8 + 0.100128442985603*G0_1_1_8_9 - 0.00261072261072305*G0_1_1_9_0 + 0.0452525252525331*G0_1_1_9_1 + 0.0122924694353287*G0_1_1_9_2 + 0.101589838732713*G0_1_1_9_3 - 0.036306550592271*G0_1_1_9_4 + 0.0242957042957084*G0_1_1_9_5 - 0.00680462394748221*G0_1_1_9_6 - 0.049550449550458*G0_1_1_9_7 + 0.100128442985603*G0_1_1_9_8 + 0.156186670472411*G0_1_1_9_9;
    A[125] = A[56] - 0.00677812487336415*G0_0_0_0_0 + 0.00143898429612739*G0_0_0_0_1 - 0.0283834683834732*G0_0_0_0_2 + 0.0187194815766277*G0_0_0_0_3 - 0.0301586244443439*G0_0_0_0_4 + 0.0150004492861661*G0_0_0_0_5 - 0.0379510436653359*G0_0_0_0_6 + 0.000704480704480814*G0_0_0_0_7 + 0.00207327064469958*G0_0_0_0_8 - 0.0122924694353287*G0_0_0_0_9 + 0.00143898429612739*G0_0_0_1_0 + 0.0752754124182821*G0_0_0_1_1 - 0.0193337526670893*G0_0_0_1_2 + 0.117559477559497*G0_0_0_1_3 - 0.0806334406334543*G0_0_0_1_4 + 0.00906056906057061*G0_0_0_1_5 - 0.0304021904021956*G0_0_0_1_6 - 0.0177849663563979*G0_0_0_1_7 + 0.0381527467241817*G0_0_0_1_8 + 0.0026107226107231*G0_0_0_1_9 - 0.0283834683834732*G0_0_0_2_0 - 0.0193337526670893*G0_0_0_2_1 - 0.498302684969435*G0_0_0_2_2 + 0.141407798550679*G0_0_0_2_3 - 0.277644894787798*G0_0_0_2_4 + 0.126022548879713*G0_0_0_2_5 - 0.273483976341165*G0_0_0_2_6 + 0.00414358128643909*G0_0_0_2_7 + 0.00641178926893317*G0_0_0_2_8 - 0.0452525252525328*G0_0_0_2_9 + 0.0187194815766277*G0_0_0_3_0 + 0.117559477559497*G0_0_0_3_1 + 0.141407798550679*G0_0_0_3_2 + 0.189463869463902*G0_0_0_3_3 + 0.10243090243092*G0_0_0_3_4 - 0.0554036439750818*G0_0_0_3_5 + 0.118673707245156*G0_0_0_3_6 - 0.0286913086913136*G0_0_0_3_7 + 0.0204595404595441*G0_0_0_3_8 + 0.049550449550458*G0_0_0_3_9 - 0.0301586244443439*G0_0_0_4_0 - 0.0806334406334543*G0_0_0_4_1 - 0.277644894787798*G0_0_0_4_2 + 0.10243090243092*G0_0_0_4_3 - 0.436995385566888*G0_0_0_4_4 + 0.117943009371601*G0_0_0_4_5 - 0.236616716616756*G0_0_0_4_6 + 0.0252889967175724*G0_0_0_4_7 + 0.00823176823176952*G0_0_0_4_8 - 0.100128442985603*G0_0_0_4_9 + 0.0150004492861661*G0_0_0_5_0 + 0.00906056906057061*G0_0_0_5_1 + 0.126022548879713*G0_0_0_5_2 - 0.0554036439750818*G0_0_0_5_3 + 0.117943009371601*G0_0_0_5_4 - 0.129668426811306*G0_0_0_5_5 + 0.182990342990374*G0_0_0_5_6 - 0.0153218210361093*G0_0_0_5_7 + 0.000285428856857484*G0_0_0_5_8 + 0.0363065505922709*G0_0_0_5_9 - 0.0379510436653359*G0_0_0_6_0 - 0.0304021904021956*G0_0_0_6_1 - 0.273483976341165*G0_0_0_6_2 + 0.118673707245156*G0_0_0_6_3 - 0.236616716616756*G0_0_0_6_4 + 0.182990342990374*G0_0_0_6_5 - 0.505315636744293*G0_0_0_6_6 + 0.0150363921792518*G0_0_0_6_7 + 0.0222520336806088*G0_0_0_6_8 - 0.101589838732713*G0_0_0_6_9 + 0.000704480704480814*G0_0_0_7_0 - 0.0177849663563979*G0_0_0_7_1 + 0.00414358128643909*G0_0_0_7_2 - 0.0286913086913136*G0_0_0_7_3 + 0.0252889967175724*G0_0_0_7_4 - 0.0153218210361093*G0_0_0_7_5 + 0.0150363921792518*G0_0_0_7_6 - 0.0077484420341576*G0_0_0_7_7 + 0.000483326197611949*G0_0_0_7_8 + 0.00680462394748217*G0_0_0_7_9 + 0.00207327064469958*G0_0_0_8_0 + 0.0381527467241817*G0_0_0_8_1 + 0.00641178926893317*G0_0_0_8_2 + 0.0204595404595441*G0_0_0_8_3 + 0.00823176823176952*G0_0_0_8_4 + 0.000285428856857484*G0_0_0_8_5 + 0.0222520336806088*G0_0_0_8_6 + 0.000483326197611954*G0_0_0_8_7 - 0.0371133628276547*G0_0_0_8_8 - 0.0242957042957083*G0_0_0_8_9 - 0.0122924694353287*G0_0_0_9_0 + 0.0026107226107231*G0_0_0_9_1 - 0.0452525252525328*G0_0_0_9_2 + 0.049550449550458*G0_0_0_9_3 - 0.100128442985603*G0_0_0_9_4 + 0.0363065505922709*G0_0_0_9_5 - 0.101589838732713*G0_0_0_9_6 + 0.00680462394748217*G0_0_0_9_7 - 0.0242957042957083*G0_0_0_9_8 - 0.156186670472411*G0_0_0_9_9 + 0.00545119783215114*G0_0_1_0_1 - 0.00545119783215116*G0_0_1_0_2 + 0.0302579959722869*G0_0_1_0_3 - 0.0302579959722869*G0_0_1_0_4 + 0.00641982356268182*G0_0_1_0_5 - 0.0166910338338938*G0_0_1_0_6 - 0.00641982356268179*G0_0_1_0_7 + 0.0166910338338938*G0_0_1_0_8 + 0.00545119783215114*G0_0_1_1_0 + 0.0976800976801139*G0_0_1_1_1 + 0.139788254073992*G0_0_1_1_3 - 0.0850231250231394*G0_0_1_1_4 + 0.00476475905047414*G0_0_1_1_5 - 0.0183460983461015*G0_0_1_1_6 - 0.030122681551258*G0_0_1_1_7 + 0.0640967498110463*G0_0_1_1_8 + 0.0100065014350746*G0_0_1_1_9 - 0.00545119783215116*G0_0_1_2_0 - 0.097680097680114*G0_0_1_2_2 + 0.0850231250231393*G0_0_1_2_3 - 0.139788254073992*G0_0_1_2_4 + 0.030122681551258*G0_0_1_2_5 - 0.0640967498110463*G0_0_1_2_6 - 0.00476475905047413*G0_0_1_2_7 + 0.0183460983461014*G0_0_1_2_8 - 0.0100065014350745*G0_0_1_2_9 + 0.0302579959722869*G0_0_1_3_0 + 0.139788254073992*G0_0_1_3_1 + 0.0850231250231393*G0_0_1_3_2 + 0.397042957043025*G0_0_1_3_3 - 0.0525341325341413*G0_0_1_3_5 + 0.0550382950383043*G0_0_1_3_6 - 0.0907739879168603*G0_0_1_3_7 + 0.145812282955165*G0_0_1_3_8 + 0.151528471528497*G0_0_1_3_9 - 0.0302579959722869*G0_0_1_4_0 - 0.0850231250231394*G0_0_1_4_1 - 0.139788254073992*G0_0_1_4_2 - 0.397042957043024*G0_0_1_4_4 + 0.0907739879168604*G0_0_1_4_5 - 0.145812282955165*G0_0_1_4_6 + 0.0525341325341413*G0_0_1_4_7 - 0.0550382950383042*G0_0_1_4_8 - 0.151528471528497*G0_0_1_4_9 + 0.00641982356268182*G0_0_1_5_0 + 0.00476475905047414*G0_0_1_5_1 + 0.030122681551258*G0_0_1_5_2 - 0.0525341325341413*G0_0_1_5_3 + 0.0907739879168604*G0_0_1_5_4 - 0.0288321202606966*G0_0_1_5_5 + 0.066592455163895*G0_0_1_5_6 - 0.0142942771514224*G0_0_1_5_8 + 0.0285885543028448*G0_0_1_5_9 - 0.0166910338338938*G0_0_1_6_0 - 0.0183460983461015*G0_0_1_6_1 - 0.0640967498110463*G0_0_1_6_2 + 0.0550382950383043*G0_0_1_6_3 - 0.145812282955165*G0_0_1_6_4 + 0.066592455163895*G0_0_1_6_5 - 0.145698111412422*G0_0_1_6_6 + 0.0142942771514224*G0_0_1_6_7 - 0.0800570857713849*G0_0_1_6_9 - 0.00641982356268179*G0_0_1_7_0 - 0.030122681551258*G0_0_1_7_1 - 0.00476475905047413*G0_0_1_7_2 - 0.0907739879168603*G0_0_1_7_3 + 0.0525341325341413*G0_0_1_7_4 + 0.0142942771514224*G0_0_1_7_6 + 0.0288321202606965*G0_0_1_7_7 - 0.0665924551638948*G0_0_1_7_8 - 0.0285885543028448*G0_0_1_7_9 + 0.0166910338338938*G0_0_1_8_0 + 0.0640967498110463*G0_0_1_8_1 + 0.0183460983461014*G0_0_1_8_2 + 0.145812282955165*G0_0_1_8_3 - 0.0550382950383042*G0_0_1_8_4 - 0.0142942771514224*G0_0_1_8_5 - 0.0665924551638948*G0_0_1_8_7 + 0.145698111412422*G0_0_1_8_8 + 0.0800570857713849*G0_0_1_8_9 + 0.0100065014350746*G0_0_1_9_1 - 0.0100065014350745*G0_0_1_9_2 + 0.151528471528497*G0_0_1_9_3 - 0.151528471528497*G0_0_1_9_4 + 0.0285885543028448*G0_0_1_9_5 - 0.0800570857713849*G0_0_1_9_6 - 0.0285885543028448*G0_0_1_9_7 + 0.0800570857713849*G0_0_1_9_8 + 0.0153215391310656*G0_1_0_0_1 - 0.0153215391310656*G0_1_0_0_2 + 0.0163519020661906*G0_1_0_0_3 - 0.0163519020661906*G0_1_0_0_4 + 0.00371522657237003*G0_1_0_0_5 - 0.00794803080517498*G0_1_0_0_6 - 0.00371522657237011*G0_1_0_0_7 + 0.00794803080517508*G0_1_0_0_8 + 0.0153215391310656*G0_1_0_1_0 + 0.393844462415959*G0_1_0_1_1 + 0.217967852253604*G0_1_0_1_3 - 0.117159877159897*G0_1_0_1_4 + 0.000395794681508918*G0_1_0_1_5 - 0.00880896880897026*G0_1_0_1_6 - 0.0710024367167347*G0_1_0_1_7 + 0.14498094498097*G0_1_0_1_8 + 0.0229535543821298*G0_1_0_1_9 - 0.0153215391310656*G0_1_0_2_0 - 0.393844462415957*G0_1_0_2_2 + 0.117159877159897*G0_1_0_2_3 - 0.217967852253603*G0_1_0_2_4 + 0.0710024367167343*G0_1_0_2_5 - 0.144980944980969*G0_1_0_2_6 - 0.000395794681509068*G0_1_0_2_7 + 0.00880896880897029*G0_1_0_2_8 - 0.0229535543821296*G0_1_0_2_9 + 0.0163519020661906*G0_1_0_3_0 + 0.217967852253604*G0_1_0_3_1 + 0.117159877159897*G0_1_0_3_2 + 0.258781218781263*G0_1_0_3_3 - 0.0251215451215494*G0_1_0_3_5 + 0.0264269064269108*G0_1_0_3_6 - 0.0490557061985718*G0_1_0_3_7 + 0.0754826126254829*G0_1_0_3_8 + 0.0292507492507544*G0_1_0_3_9 - 0.0163519020661906*G0_1_0_4_0 - 0.117159877159897*G0_1_0_4_1 - 0.217967852253603*G0_1_0_4_2 - 0.258781218781263*G0_1_0_4_4 + 0.0490557061985716*G0_1_0_4_5 - 0.0754826126254825*G0_1_0_4_6 + 0.0251215451215494*G0_1_0_4_7 - 0.026426906426911*G0_1_0_4_8 - 0.0292507492507543*G0_1_0_4_9 + 0.00371522657237003*G0_1_0_5_0 + 0.000395794681508918*G0_1_0_5_1 + 0.0710024367167343*G0_1_0_5_2 - 0.0251215451215493*G0_1_0_5_3 + 0.0490557061985716*G0_1_0_5_4 - 0.0247676133390461*G0_1_0_5_5 + 0.0353551210694126*G0_1_0_5_6 - 0.00118738404452715*G0_1_0_5_8 + 0.00237476808905418*G0_1_0_5_9 - 0.00794803080517498*G0_1_0_6_0 - 0.00880896880897026*G0_1_0_6_1 - 0.144980944980969*G0_1_0_6_2 + 0.0264269064269108*G0_1_0_6_3 - 0.0754826126254825*G0_1_0_6_4 + 0.0353551210694126*G0_1_0_6_5 - 0.00337186622900926*G0_1_0_6_6 + 0.0011873840445271*G0_1_0_6_7 + 0.0160068502925673*G0_1_0_6_9 - 0.00371522657237011*G0_1_0_7_0 - 0.0710024367167347*G0_1_0_7_1 - 0.000395794681509068*G0_1_0_7_2 - 0.0490557061985718*G0_1_0_7_3 + 0.0251215451215494*G0_1_0_7_4 + 0.0011873840445271*G0_1_0_7_6 + 0.0247676133390461*G0_1_0_7_7 - 0.035355121069413*G0_1_0_7_8 - 0.00237476808905427*G0_1_0_7_9 + 0.00794803080517508*G0_1_0_8_0 + 0.14498094498097*G0_1_0_8_1 + 0.00880896880897029*G0_1_0_8_2 + 0.0754826126254829*G0_1_0_8_3 - 0.026426906426911*G0_1_0_8_4 - 0.00118738404452715*G0_1_0_8_5 - 0.035355121069413*G0_1_0_8_7 + 0.00337186622901023*G0_1_0_8_8 - 0.0160068502925671*G0_1_0_8_9 + 0.0229535543821298*G0_1_0_9_1 - 0.0229535543821296*G0_1_0_9_2 + 0.0292507492507544*G0_1_0_9_3 - 0.0292507492507543*G0_1_0_9_4 + 0.00237476808905418*G0_1_0_9_5 + 0.0160068502925673*G0_1_0_9_6 - 0.00237476808905427*G0_1_0_9_7 - 0.0160068502925671*G0_1_0_9_8 + 0.00677812487336411*G0_1_1_0_0 + 0.0283834683834733*G0_1_1_0_1 - 0.00143898429612741*G0_1_1_0_2 + 0.0301586244443439*G0_1_1_0_3 - 0.0187194815766277*G0_1_1_0_4 - 0.000704480704480836*G0_1_1_0_5 - 0.00207327064469955*G0_1_1_0_6 - 0.0150004492861662*G0_1_1_0_7 + 0.0379510436653359*G0_1_1_0_8 + 0.0122924694353287*G0_1_1_0_9 + 0.0283834683834733*G0_1_1_1_0 + 0.498302684969437*G0_1_1_1_1 + 0.0193337526670892*G0_1_1_1_2 + 0.277644894787799*G0_1_1_1_3 - 0.14140779855068*G0_1_1_1_4 - 0.00414358128643929*G0_1_1_1_5 - 0.00641178926893313*G0_1_1_1_6 - 0.126022548879713*G0_1_1_1_7 + 0.273483976341166*G0_1_1_1_8 + 0.0452525252525331*G0_1_1_1_9 - 0.00143898429612741*G0_1_1_2_0 + 0.0193337526670892*G0_1_1_2_1 - 0.0752754124182821*G0_1_1_2_2 + 0.0806334406334542*G0_1_1_2_3 - 0.117559477559497*G0_1_1_2_4 + 0.0177849663563979*G0_1_1_2_5 - 0.0381527467241817*G0_1_1_2_6 - 0.00906056906057058*G0_1_1_2_7 + 0.0304021904021955*G0_1_1_2_8 - 0.00261072261072304*G0_1_1_2_9 + 0.0301586244443439*G0_1_1_3_0 + 0.277644894787799*G0_1_1_3_1 + 0.0806334406334542*G0_1_1_3_2 + 0.436995385566888*G0_1_1_3_3 - 0.10243090243092*G0_1_1_3_4 - 0.0252889967175724*G0_1_1_3_5 - 0.0082317682317696*G0_1_1_3_6 - 0.117943009371601*G0_1_1_3_7 + 0.236616716616757*G0_1_1_3_8 + 0.100128442985603*G0_1_1_3_9 - 0.0187194815766277*G0_1_1_4_0 - 0.14140779855068*G0_1_1_4_1 - 0.117559477559497*G0_1_1_4_2 - 0.10243090243092*G0_1_1_4_3 - 0.189463869463902*G0_1_1_4_4 + 0.0286913086913136*G0_1_1_4_5 - 0.020459540459544*G0_1_1_4_6 + 0.0554036439750819*G0_1_1_4_7 - 0.118673707245156*G0_1_1_4_8 - 0.0495504495504579*G0_1_1_4_9 - 0.000704480704480836*G0_1_1_5_0 - 0.00414358128643929*G0_1_1_5_1 + 0.0177849663563979*G0_1_1_5_2 - 0.0252889967175724*G0_1_1_5_3 + 0.0286913086913136*G0_1_1_5_4 + 0.0077484420341576*G0_1_1_5_5 - 0.000483326197611992*G0_1_1_5_6 + 0.0153218210361094*G0_1_1_5_7 - 0.0150363921792519*G0_1_1_5_8 - 0.00680462394748227*G0_1_1_5_9 - 0.00207327064469956*G0_1_1_6_0 - 0.00641178926893313*G0_1_1_6_1 - 0.0381527467241817*G0_1_1_6_2 - 0.0082317682317696*G0_1_1_6_3 - 0.0204595404595439*G0_1_1_6_4 - 0.000483326197611991*G0_1_1_6_5 + 0.037113362827655*G0_1_1_6_6 - 0.000285428856857497*G0_1_1_6_7 - 0.0222520336806088*G0_1_1_6_8 + 0.0242957042957085*G0_1_1_6_9 - 0.0150004492861662*G0_1_1_7_0 - 0.126022548879713*G0_1_1_7_1 - 0.00906056906057058*G0_1_1_7_2 - 0.117943009371601*G0_1_1_7_3 + 0.0554036439750819*G0_1_1_7_4 + 0.0153218210361094*G0_1_1_7_5 - 0.000285428856857497*G0_1_1_7_6 + 0.129668426811306*G0_1_1_7_7 - 0.182990342990374*G0_1_1_7_8 - 0.036306550592271*G0_1_1_7_9 + 0.0379510436653359*G0_1_1_8_0 + 0.273483976341166*G0_1_1_8_1 + 0.0304021904021955*G0_1_1_8_2 + 0.236616716616757*G0_1_1_8_3 - 0.118673707245156*G0_1_1_8_4 - 0.0150363921792519*G0_1_1_8_5 - 0.0222520336806088*G0_1_1_8_6 - 0.182990342990374*G0_1_1_8_7 + 0.505315636744293*G0_1_1_8_8 + 0.101589838732713*G0_1_1_8_9 + 0.0122924694353287*G0_1_1_9_0 + 0.0452525252525331*G0_1_1_9_1 - 0.00261072261072304*G0_1_1_9_2 + 0.100128442985603*G0_1_1_9_3 - 0.0495504495504579*G0_1_1_9_4 - 0.00680462394748227*G0_1_1_9_5 + 0.0242957042957085*G0_1_1_9_6 - 0.036306550592271*G0_1_1_9_7 + 0.101589838732713*G0_1_1_9_8 + 0.156186670472411*G0_1_1_9_9;
    A[83] = A[125] + 0.00184140374616596*G0_0_1_0_0 + 0.00107419916943745*G0_0_1_0_1 - 0.00879614212947696*G0_0_1_0_2 - 0.00370296370296434*G0_0_1_0_3 + 0.0102031302031319*G0_0_1_0_4 - 0.00298368298368351*G0_0_1_0_5 + 0.00737928737928868*G0_0_1_0_6 - 0.000279085993371761*G0_0_1_0_7 - 0.00136371564943017*G0_0_1_0_8 + 0.00868464868465017*G0_0_1_0_9 + 0.00107419916943745*G0_0_1_1_0 + 0.00184140374616592*G0_0_1_1_1 - 0.00879614212947696*G0_0_1_1_2 - 0.0029836829836835*G0_0_1_1_3 + 0.00737928737928863*G0_0_1_1_4 - 0.00370296370296433*G0_0_1_1_5 + 0.0102031302031319*G0_0_1_1_6 - 0.00136371564943015*G0_0_1_1_7 - 0.000279085993371793*G0_0_1_1_8 + 0.00868464868465015*G0_0_1_1_9 - 0.00879614212947696*G0_0_1_2_0 - 0.00879614212947696*G0_0_1_2_1 - 0.294322960989677*G0_0_1_2_2 + 0.0395160395160461*G0_0_1_2_3 - 0.0811632811632948*G0_0_1_2_4 + 0.0395160395160461*G0_0_1_2_5 - 0.0811632811632946*G0_0_1_2_6 + 0.000666000666000764*G0_0_1_2_7 + 0.000666000666000751*G0_0_1_2_8 - 0.00426240426240495*G0_0_1_2_9 - 0.00370296370296434*G0_0_1_3_0 - 0.0029836829836835*G0_0_1_3_1 + 0.0395160395160461*G0_0_1_3_2 + 0.0103896103896121*G0_0_1_3_3 - 0.0307692307692359*G0_0_1_3_4 + 0.0143856143856168*G0_0_1_3_5 - 0.0371628371628434*G0_0_1_3_6 + 0.00455544455544532*G0_0_1_3_7 + 0.00399600399600464*G0_0_1_3_8 - 0.035164835164841*G0_0_1_3_9 + 0.0102031302031319*G0_0_1_4_0 + 0.00737928737928863*G0_0_1_4_1 - 0.0811632811632948*G0_0_1_4_2 - 0.0307692307692359*G0_0_1_4_3 + 0.148651348651374*G0_0_1_4_4 - 0.0371628371628435*G0_0_1_4_5 + 0.0743256743256869*G0_0_1_4_6 - 0.0130269730269752*G0_0_1_4_7 - 0.00855144855144997*G0_0_1_4_8 + 0.0871128871129017*G0_0_1_4_9 - 0.00298368298368351*G0_0_1_5_0 - 0.00370296370296433*G0_0_1_5_1 + 0.0395160395160461*G0_0_1_5_2 + 0.0143856143856168*G0_0_1_5_3 - 0.0371628371628435*G0_0_1_5_4 + 0.0103896103896122*G0_0_1_5_5 - 0.0307692307692362*G0_0_1_5_6 + 0.00399600399600468*G0_0_1_5_7 + 0.00455544455544532*G0_0_1_5_8 - 0.0351648351648411*G0_0_1_5_9 + 0.00737928737928868*G0_0_1_6_0 + 0.010203130203132*G0_0_1_6_1 - 0.0811632811632946*G0_0_1_6_2 - 0.0371628371628434*G0_0_1_6_3 + 0.0743256743256869*G0_0_1_6_4 - 0.0307692307692362*G0_0_1_6_5 + 0.148651348651374*G0_0_1_6_6 - 0.00855144855144998*G0_0_1_6_7 - 0.0130269730269752*G0_0_1_6_8 + 0.0871128871129018*G0_0_1_6_9 - 0.000279085993371761*G0_0_1_7_0 - 0.00136371564943015*G0_0_1_7_1 + 0.000666000666000764*G0_0_1_7_2 + 0.00455544455544532*G0_0_1_7_3 - 0.0130269730269752*G0_0_1_7_4 + 0.00399600399600468*G0_0_1_7_5 - 0.00855144855144998*G0_0_1_7_6 + 0.00632510346796155*G0_0_1_7_7 + 0.000468103325246279*G0_0_1_7_8 - 0.00895104895105044*G0_0_1_7_9 - 0.00136371564943017*G0_0_1_8_0 - 0.000279085993371793*G0_0_1_8_1 + 0.000666000666000752*G0_0_1_8_2 + 0.00399600399600464*G0_0_1_8_3 - 0.00855144855144997*G0_0_1_8_4 + 0.00455544455544532*G0_0_1_8_5 - 0.0130269730269752*G0_0_1_8_6 + 0.000468103325246279*G0_0_1_8_7 + 0.00632510346796145*G0_0_1_8_8 - 0.00895104895105047*G0_0_1_8_9 + 0.00868464868465017*G0_0_1_9_0 + 0.00868464868465015*G0_0_1_9_1 - 0.00426240426240495*G0_0_1_9_2 - 0.035164835164841*G0_0_1_9_3 + 0.0871128871129017*G0_0_1_9_4 - 0.0351648351648411*G0_0_1_9_5 + 0.0871128871129018*G0_0_1_9_6 - 0.00895104895105044*G0_0_1_9_7 - 0.00895104895105047*G0_0_1_9_8 + 0.0671328671328784*G0_0_1_9_9 - 0.00184140374616596*G0_1_0_0_0 - 0.00107419916943745*G0_1_0_0_1 + 0.00879614212947696*G0_1_0_0_2 + 0.00370296370296434*G0_1_0_0_3 - 0.0102031302031319*G0_1_0_0_4 + 0.00298368298368351*G0_1_0_0_5 - 0.00737928737928868*G0_1_0_0_6 + 0.000279085993371761*G0_1_0_0_7 + 0.00136371564943017*G0_1_0_0_8 - 0.00868464868465017*G0_1_0_0_9 - 0.00107419916943745*G0_1_0_1_0 - 0.00184140374616592*G0_1_0_1_1 + 0.00879614212947696*G0_1_0_1_2 + 0.0029836829836835*G0_1_0_1_3 - 0.00737928737928864*G0_1_0_1_4 + 0.00370296370296433*G0_1_0_1_5 - 0.0102031302031319*G0_1_0_1_6 + 0.00136371564943015*G0_1_0_1_7 + 0.000279085993371793*G0_1_0_1_8 - 0.00868464868465015*G0_1_0_1_9 + 0.00879614212947696*G0_1_0_2_0 + 0.00879614212947696*G0_1_0_2_1 + 0.294322960989677*G0_1_0_2_2 - 0.0395160395160461*G0_1_0_2_3 + 0.0811632811632948*G0_1_0_2_4 - 0.0395160395160461*G0_1_0_2_5 + 0.0811632811632946*G0_1_0_2_6 - 0.000666000666000764*G0_1_0_2_7 - 0.000666000666000751*G0_1_0_2_8 + 0.00426240426240496*G0_1_0_2_9 + 0.00370296370296434*G0_1_0_3_0 + 0.0029836829836835*G0_1_0_3_1 - 0.0395160395160461*G0_1_0_3_2 - 0.0103896103896121*G0_1_0_3_3 + 0.0307692307692359*G0_1_0_3_4 - 0.0143856143856168*G0_1_0_3_5 + 0.0371628371628434*G0_1_0_3_6 - 0.00455544455544532*G0_1_0_3_7 - 0.00399600399600464*G0_1_0_3_8 + 0.035164835164841*G0_1_0_3_9 - 0.0102031302031319*G0_1_0_4_0 - 0.00737928737928864*G0_1_0_4_1 + 0.0811632811632948*G0_1_0_4_2 + 0.0307692307692359*G0_1_0_4_3 - 0.148651348651374*G0_1_0_4_4 + 0.0371628371628435*G0_1_0_4_5 - 0.0743256743256869*G0_1_0_4_6 + 0.0130269730269752*G0_1_0_4_7 + 0.00855144855144997*G0_1_0_4_8 - 0.0871128871129017*G0_1_0_4_9 + 0.00298368298368351*G0_1_0_5_0 + 0.00370296370296433*G0_1_0_5_1 - 0.0395160395160461*G0_1_0_5_2 - 0.0143856143856168*G0_1_0_5_3 + 0.0371628371628435*G0_1_0_5_4 - 0.0103896103896122*G0_1_0_5_5 + 0.0307692307692362*G0_1_0_5_6 - 0.00399600399600468*G0_1_0_5_7 - 0.00455544455544532*G0_1_0_5_8 + 0.0351648351648411*G0_1_0_5_9 - 0.00737928737928868*G0_1_0_6_0 - 0.010203130203132*G0_1_0_6_1 + 0.0811632811632946*G0_1_0_6_2 + 0.0371628371628434*G0_1_0_6_3 - 0.0743256743256869*G0_1_0_6_4 + 0.0307692307692361*G0_1_0_6_5 - 0.148651348651374*G0_1_0_6_6 + 0.00855144855144998*G0_1_0_6_7 + 0.0130269730269752*G0_1_0_6_8 - 0.0871128871129018*G0_1_0_6_9 + 0.000279085993371761*G0_1_0_7_0 + 0.00136371564943015*G0_1_0_7_1 - 0.000666000666000764*G0_1_0_7_2 - 0.00455544455544532*G0_1_0_7_3 + 0.0130269730269752*G0_1_0_7_4 - 0.00399600399600468*G0_1_0_7_5 + 0.00855144855144998*G0_1_0_7_6 - 0.00632510346796155*G0_1_0_7_7 - 0.000468103325246279*G0_1_0_7_8 + 0.00895104895105044*G0_1_0_7_9 + 0.00136371564943017*G0_1_0_8_0 + 0.000279085993371793*G0_1_0_8_1 - 0.000666000666000752*G0_1_0_8_2 - 0.00399600399600464*G0_1_0_8_3 + 0.00855144855144997*G0_1_0_8_4 - 0.00455544455544532*G0_1_0_8_5 + 0.0130269730269752*G0_1_0_8_6 - 0.000468103325246279*G0_1_0_8_7 - 0.00632510346796145*G0_1_0_8_8 + 0.00895104895105047*G0_1_0_8_9 - 0.00868464868465017*G0_1_0_9_0 - 0.00868464868465015*G0_1_0_9_1 + 0.00426240426240495*G0_1_0_9_2 + 0.035164835164841*G0_1_0_9_3 - 0.0871128871129017*G0_1_0_9_4 + 0.0351648351648411*G0_1_0_9_5 - 0.0871128871129018*G0_1_0_9_6 + 0.00895104895105044*G0_1_0_9_7 + 0.00895104895105047*G0_1_0_9_8 - 0.0671328671328784*G0_1_0_9_9;
    A[80] = -A[125] + 0.00184140374616597*G0_1_0_0_0 + 0.00107419916943745*G0_1_0_0_1 - 0.00879614212947696*G0_1_0_0_2 - 0.00370296370296434*G0_1_0_0_3 + 0.010203130203132*G0_1_0_0_4 - 0.00298368298368351*G0_1_0_0_5 + 0.00737928737928869*G0_1_0_0_6 - 0.000279085993371762*G0_1_0_0_7 - 0.00136371564943017*G0_1_0_0_8 + 0.00868464868465017*G0_1_0_0_9 + 0.00107419916943745*G0_1_0_1_0 + 0.00184140374616593*G0_1_0_1_1 - 0.00879614212947696*G0_1_0_1_2 - 0.00298368298368351*G0_1_0_1_3 + 0.00737928737928865*G0_1_0_1_4 - 0.00370296370296434*G0_1_0_1_5 + 0.010203130203132*G0_1_0_1_6 - 0.00136371564943015*G0_1_0_1_7 - 0.000279085993371792*G0_1_0_1_8 + 0.00868464868465016*G0_1_0_1_9 - 0.00879614212947696*G0_1_0_2_0 - 0.00879614212947696*G0_1_0_2_1 - 0.294322960989677*G0_1_0_2_2 + 0.039516039516046*G0_1_0_2_3 - 0.0811632811632947*G0_1_0_2_4 + 0.0395160395160461*G0_1_0_2_5 - 0.0811632811632946*G0_1_0_2_6 + 0.000666000666000763*G0_1_0_2_7 + 0.00066600066600075*G0_1_0_2_8 - 0.00426240426240495*G0_1_0_2_9 - 0.00370296370296434*G0_1_0_3_0 - 0.00298368298368351*G0_1_0_3_1 + 0.039516039516046*G0_1_0_3_2 + 0.0103896103896121*G0_1_0_3_3 - 0.0307692307692359*G0_1_0_3_4 + 0.0143856143856168*G0_1_0_3_5 - 0.0371628371628435*G0_1_0_3_6 + 0.00455544455544532*G0_1_0_3_7 + 0.00399600399600464*G0_1_0_3_8 - 0.0351648351648411*G0_1_0_3_9 + 0.010203130203132*G0_1_0_4_0 + 0.00737928737928865*G0_1_0_4_1 - 0.0811632811632947*G0_1_0_4_2 - 0.0307692307692359*G0_1_0_4_3 + 0.148651348651374*G0_1_0_4_4 - 0.0371628371628435*G0_1_0_4_5 + 0.074325674325687*G0_1_0_4_6 - 0.0130269730269752*G0_1_0_4_7 - 0.00855144855144997*G0_1_0_4_8 + 0.0871128871129017*G0_1_0_4_9 - 0.00298368298368351*G0_1_0_5_0 - 0.00370296370296434*G0_1_0_5_1 + 0.0395160395160461*G0_1_0_5_2 + 0.0143856143856168*G0_1_0_5_3 - 0.0371628371628435*G0_1_0_5_4 + 0.0103896103896123*G0_1_0_5_5 - 0.0307692307692362*G0_1_0_5_6 + 0.00399600399600468*G0_1_0_5_7 + 0.00455544455544532*G0_1_0_5_8 - 0.0351648351648411*G0_1_0_5_9 + 0.00737928737928869*G0_1_0_6_0 + 0.010203130203132*G0_1_0_6_1 - 0.0811632811632946*G0_1_0_6_2 - 0.0371628371628435*G0_1_0_6_3 + 0.074325674325687*G0_1_0_6_4 - 0.0307692307692362*G0_1_0_6_5 + 0.148651348651374*G0_1_0_6_6 - 0.00855144855144999*G0_1_0_6_7 - 0.0130269730269752*G0_1_0_6_8 + 0.0871128871129018*G0_1_0_6_9 - 0.000279085993371762*G0_1_0_7_0 - 0.00136371564943015*G0_1_0_7_1 + 0.000666000666000763*G0_1_0_7_2 + 0.00455544455544532*G0_1_0_7_3 - 0.0130269730269752*G0_1_0_7_4 + 0.00399600399600468*G0_1_0_7_5 - 0.00855144855144999*G0_1_0_7_6 + 0.00632510346796155*G0_1_0_7_7 + 0.00046810332524628*G0_1_0_7_8 - 0.00895104895105044*G0_1_0_7_9 - 0.00136371564943017*G0_1_0_8_0 - 0.000279085993371792*G0_1_0_8_1 + 0.00066600066600075*G0_1_0_8_2 + 0.00399600399600464*G0_1_0_8_3 - 0.00855144855144997*G0_1_0_8_4 + 0.00455544455544532*G0_1_0_8_5 - 0.0130269730269752*G0_1_0_8_6 + 0.00046810332524628*G0_1_0_8_7 + 0.00632510346796145*G0_1_0_8_8 - 0.00895104895105049*G0_1_0_8_9 + 0.00868464868465017*G0_1_0_9_0 + 0.00868464868465016*G0_1_0_9_1 - 0.00426240426240494*G0_1_0_9_2 - 0.0351648351648411*G0_1_0_9_3 + 0.0871128871129017*G0_1_0_9_4 - 0.0351648351648411*G0_1_0_9_5 + 0.0871128871129018*G0_1_0_9_6 - 0.00895104895105044*G0_1_0_9_7 - 0.00895104895105049*G0_1_0_9_8 + 0.0671328671328784*G0_1_0_9_9 + 0.00656838752076957*G0_1_1_0_0 + 0.00527909480290526*G0_1_1_0_1 - 0.000819920819920959*G0_1_1_0_2 - 0.00145589859875598*G0_1_1_0_3 + 0.0262167462167507*G0_1_1_0_4 - 0.0094745466174054*G0_1_1_0_5 + 0.0150812150812177*G0_1_1_0_6 - 0.00471317042745696*G0_1_1_0_7 + 0.00338159195302115*G0_1_1_0_8 + 0.0226846169703351*G0_1_1_0_9 + 0.00527909480290526*G0_1_1_1_0 + 0.0461878861878944*G0_1_1_1_1 + 0.000227920227920274*G0_1_1_1_2 + 0.00279085993371768*G0_1_1_1_3 + 0.0110644910644929*G0_1_1_1_4 - 0.00560666846381231*G0_1_1_1_5 + 0.0150812150812177*G0_1_1_1_6 - 0.0164584621727508*G0_1_1_1_7 + 0.0307400535972019*G0_1_1_1_8 + 0.014948860663149*G0_1_1_1_9 - 0.000819920819920959*G0_1_1_2_0 + 0.000227920227920274*G0_1_1_2_1 - 0.0348096348096406*G0_1_1_2_2 + 0.00836200836200973*G0_1_1_2_3 - 0.0194768194768227*G0_1_1_2_4 + 0.00486920486920565*G0_1_1_2_5 - 0.00973840973841134*G0_1_1_2_6 + 0.00186776186776217*G0_1_1_2_7 + 0.00609464609464711*G0_1_1_2_8 - 0.00275280275280324*G0_1_1_2_9 - 0.00145589859875598*G0_1_1_3_0 + 0.00279085993371767*G0_1_1_3_1 + 0.00836200836200973*G0_1_1_3_2 + 0.11140859140861*G0_1_1_3_3 - 0.0878321678321825*G0_1_1_3_4 + 0.0193140193140226*G0_1_1_3_5 - 0.0626839826839932*G0_1_1_3_6 - 0.0130726416440725*G0_1_1_3_7 + 0.0487969173683542*G0_1_1_3_8 - 0.0187012987013018*G0_1_1_3_9 + 0.0262167462167507*G0_1_1_4_0 + 0.0110644910644929*G0_1_1_4_1 - 0.0194768194768227*G0_1_1_4_2 - 0.0878321678321825*G0_1_1_4_3 + 0.476323676323756*G0_1_1_4_4 - 0.0960905760905923*G0_1_1_4_5 + 0.158774558774586*G0_1_1_4_6 - 0.033406593406599*G0_1_1_4_7 - 0.0357242757242817*G0_1_1_4_8 + 0.200439560439594*G0_1_1_4_9 - 0.0094745466174054*G0_1_1_5_0 - 0.00560666846381231*G0_1_1_5_1 + 0.00486920486920565*G0_1_1_5_2 + 0.0193140193140226*G0_1_1_5_3 - 0.0960905760905923*G0_1_1_5_4 + 0.0433699633699707*G0_1_1_5_5 - 0.0626839826839933*G0_1_1_5_6 + 0.0236639550925305*G0_1_1_5_7 - 0.0006203320489036*G0_1_1_5_8 - 0.0668131868131981*G0_1_1_5_9 + 0.0150812150812177*G0_1_1_6_0 + 0.0150812150812177*G0_1_1_6_1 - 0.00973840973841134*G0_1_1_6_2 - 0.0626839826839932*G0_1_1_6_3 + 0.158774558774586*G0_1_1_6_4 - 0.0626839826839933*G0_1_1_6_5 + 0.158774558774586*G0_1_1_6_6 - 0.0230436230436269*G0_1_1_6_7 - 0.0230436230436269*G0_1_1_6_8 + 0.133626373626396*G0_1_1_6_9 - 0.00471317042745696*G0_1_1_7_0 - 0.0164584621727508*G0_1_1_7_1 + 0.00186776186776217*G0_1_1_7_2 - 0.0130726416440725*G0_1_1_7_3 - 0.033406593406599*G0_1_1_7_4 + 0.0236639550925305*G0_1_1_7_5 - 0.0230436230436269*G0_1_1_7_6 + 0.0950820607963624*G0_1_1_7_7 - 0.0291936634793829*G0_1_1_7_8 - 0.0219666048237514*G0_1_1_7_9 + 0.00338159195302115*G0_1_1_8_0 + 0.0307400535972019*G0_1_1_8_1 + 0.00609464609464711*G0_1_1_8_2 + 0.0487969173683542*G0_1_1_8_3 - 0.0357242757242817*G0_1_1_8_4 - 0.0006203320489036*G0_1_1_8_5 - 0.0230436230436269*G0_1_1_8_6 - 0.0291936634793829*G0_1_1_8_7 + 0.195073497930674*G0_1_1_8_8 + 0.0266019694591168*G0_1_1_8_9 + 0.0226846169703352*G0_1_1_9_0 + 0.014948860663149*G0_1_1_9_1 - 0.00275280275280324*G0_1_1_9_2 - 0.0187012987013018*G0_1_1_9_3 + 0.200439560439594*G0_1_1_9_4 - 0.0668131868131981*G0_1_1_9_5 + 0.133626373626396*G0_1_1_9_6 - 0.0219666048237514*G0_1_1_9_7 + 0.0266019694591168*G0_1_1_9_8 + 0.326073926073981*G0_1_1_9_9;
    A[31] = 0.000626774019631273*G0_1_0_0_0 - 0.000620316081625717*G0_1_0_0_1 - 0.000620316081625712*G0_1_0_0_2 - 2.49915428487123e-06*G0_1_0_0_3 - 2.49915428486798e-06*G0_1_0_0_4 + 0.000135291296005608*G0_1_0_0_5 - 0.000873214087499952*G0_1_0_0_6 + 0.000135291296005611*G0_1_0_0_7 - 0.000873214087499958*G0_1_0_0_8 - 0.000436963829821046*G0_1_0_0_9 - 0.000620316081625717*G0_1_0_1_0 - 0.0108191962358648*G0_1_0_1_1 - 0.000523948604305839*G0_1_0_1_2 - 0.00189433251933287*G0_1_0_1_3 + 0.00115463240463261*G0_1_0_1_4 + 0.000174902808831416*G0_1_0_1_5 - 0.000227512236440849*G0_1_0_1_6 + 0.00269179894179942*G0_1_0_1_7 - 0.00659231971732089*G0_1_0_1_8 - 0.000290959040959097*G0_1_0_1_9 - 0.000620316081625712*G0_1_0_2_0 - 0.000523948604305839*G0_1_0_2_1 - 0.0108191962358647*G0_1_0_2_2 + 0.00115463240463259*G0_1_0_2_3 - 0.00189433251933284*G0_1_0_2_4 + 0.00269179894179939*G0_1_0_2_5 - 0.00659231971732082*G0_1_0_2_6 + 0.00017490280883141*G0_1_0_2_7 - 0.000227512236440849*G0_1_0_2_8 - 0.000290959040959089*G0_1_0_2_9 - 2.49915428487122e-06*G0_1_0_3_0 - 0.00189433251933287*G0_1_0_3_1 + 0.00115463240463259*G0_1_0_3_2 + 0.00248709623709665*G0_1_0_3_3 - 0.000727858451072852*G0_1_0_3_4 - 0.000513325959754615*G0_1_0_3_5 + 0.00119197766519215*G0_1_0_3_6 + 0.000516938418724228*G0_1_0_3_7 - 0.00170891608391639*G0_1_0_3_8 - 0.000160999714571169*G0_1_0_3_9 - 2.49915428486797e-06*G0_1_0_4_0 + 0.00115463240463261*G0_1_0_4_1 - 0.00189433251933284*G0_1_0_4_2 - 0.000727858451072852*G0_1_0_4_3 + 0.00248709623709665*G0_1_0_4_4 + 0.000516938418724219*G0_1_0_4_5 - 0.00170891608391637*G0_1_0_4_6 - 0.000513325959754622*G0_1_0_4_7 + 0.00119197766519216*G0_1_0_4_8 - 0.000160999714571171*G0_1_0_4_9 + 0.000135291296005608*G0_1_0_5_0 + 0.000174902808831416*G0_1_0_5_1 + 0.00269179894179939*G0_1_0_5_2 - 0.000513325959754615*G0_1_0_5_3 + 0.000516938418724219*G0_1_0_5_4 - 0.00261839351125108*G0_1_0_5_5 + 0.00481814316635826*G0_1_0_5_6 + 3.0534941249232e-05*G0_1_0_5_7 - 1.52674706246116e-05*G0_1_0_5_8 + 0.00134142643071237*G0_1_0_5_9 - 0.000873214087499952*G0_1_0_6_0 - 0.000227512236440849*G0_1_0_6_1 - 0.00659231971732082*G0_1_0_6_2 + 0.00119197766519215*G0_1_0_6_3 - 0.00170891608391637*G0_1_0_6_4 + 0.00481814316635826*G0_1_0_6_5 - 0.0107513320013338*G0_1_0_6_6 - 1.52674706246164e-05*G0_1_0_6_7 + 0.000427816231387729*G0_1_0_6_8 - 0.00151107820750703*G0_1_0_6_9 + 0.000135291296005611*G0_1_0_7_0 + 0.00269179894179942*G0_1_0_7_1 + 0.00017490280883141*G0_1_0_7_2 + 0.000516938418724228*G0_1_0_7_3 - 0.000513325959754622*G0_1_0_7_4 + 3.0534941249232e-05*G0_1_0_7_5 - 1.52674706246164e-05*G0_1_0_7_6 - 0.0026183935112511*G0_1_0_7_7 + 0.00481814316635829*G0_1_0_7_8 + 0.00134142643071237*G0_1_0_7_9 - 0.000873214087499958*G0_1_0_8_0 - 0.00659231971732089*G0_1_0_8_1 - 0.000227512236440849*G0_1_0_8_2 - 0.00170891608391639*G0_1_0_8_3 + 0.00119197766519216*G0_1_0_8_4 - 1.52674706246116e-05*G0_1_0_8_5 + 0.000427816231387729*G0_1_0_8_6 + 0.00481814316635829*G0_1_0_8_7 - 0.0107513320013339*G0_1_0_8_8 - 0.00151107820750704*G0_1_0_8_9 - 0.000436963829821046*G0_1_0_9_0 - 0.000290959040959097*G0_1_0_9_1 - 0.000290959040959088*G0_1_0_9_2 - 0.000160999714571169*G0_1_0_9_3 - 0.000160999714571171*G0_1_0_9_4 + 0.00134142643071237*G0_1_0_9_5 - 0.00151107820750703*G0_1_0_9_6 + 0.00134142643071237*G0_1_0_9_7 - 0.00151107820750704*G0_1_0_9_8 - 0.00183352361923822*G0_1_0_9_9;
    A[110] = A[31] + 0.00119386786053473*G0_0_0_0_0 + 0.000674493055445552*G0_0_0_0_1 + 0.0106520639853991*G0_0_0_0_2 - 0.00329162900591528*G0_0_0_0_3 + 0.010238650238652*G0_0_0_0_4 - 0.00064538635967217*G0_0_0_0_5 - 0.00200022200022241*G0_0_0_0_6 + 0.000241345955631709*G0_0_0_0_7 - 0.000724989296418001*G0_0_0_0_9 + 0.000674493055445552*G0_0_0_1_0 + 0.00161447018589903*G0_0_0_1_1 + 0.0170535637202333*G0_0_0_1_2 - 0.00831010259581829*G0_0_0_1_3 + 0.0227750027750067*G0_0_0_1_4 - 0.00179217607789066*G0_0_0_1_5 - 0.000310800310800391*G0_0_0_1_6 + 0.00011226868369727*G0_0_0_1_9 + 0.0106520639853991*G0_0_0_2_0 + 0.0170535637202333*G0_0_0_2_1 + 0.298264698264748*G0_0_0_2_2 - 0.0782994782994914*G0_0_0_2_3 + 0.180308580308611*G0_0_0_2_4 - 0.0449106449106523*G0_0_0_2_5 + 0.0836940836940974*G0_0_0_2_6 - 0.00254856254856296*G0_0_0_2_7 - 0.0023354423354427*G0_0_0_2_8 + 0.0175824175824205*G0_0_0_2_9 - 0.00329162900591528*G0_0_0_3_0 - 0.00831010259581829*G0_0_0_3_1 - 0.0782994782994914*G0_0_0_3_2 + 0.039400599400606*G0_0_0_3_3 - 0.110329670329689*G0_0_0_3_4 + 0.0118681318681338*G0_0_0_3_5 - 0.00755244755244876*G0_0_0_3_6 + 0.0013900385328959*G0_0_0_3_7 - 0.00311688311688362*G0_0_0_3_9 + 0.010238650238652*G0_0_0_4_0 + 0.0227750027750067*G0_0_0_4_1 + 0.180308580308611*G0_0_0_4_2 - 0.110329670329689*G0_0_0_4_3 + 0.341258741258799*G0_0_0_4_4 - 0.0392007992008058*G0_0_0_4_5 + 0.0467532467532545*G0_0_0_4_6 - 0.00729270729270851*G0_0_0_4_7 - 0.00147852147852171*G0_0_0_4_8 + 0.0256543456543499*G0_0_0_4_9 - 0.00064538635967217*G0_0_0_5_0 - 0.00179217607789066*G0_0_0_5_1 - 0.0449106449106523*G0_0_0_5_2 + 0.0118681318681338*G0_0_0_5_3 - 0.0392007992008058*G0_0_0_5_4 + 0.0119080919080938*G0_0_0_5_5 + 0.0108291708291729*G0_0_0_5_6 + 0.00394748109033889*G0_0_0_5_7 - 0.00310832025117792*G0_0_0_5_8 + 0.00839160839160985*G0_0_0_5_9 - 0.00200022200022241*G0_0_0_6_0 - 0.000310800310800391*G0_0_0_6_1 + 0.0836940836940974*G0_0_0_6_2 - 0.00755244755244876*G0_0_0_6_3 + 0.0467532467532545*G0_0_0_6_4 + 0.0108291708291729*G0_0_0_6_5 - 0.154245754245781*G0_0_0_6_6 - 0.00083916083916098*G0_0_0_6_7 + 0.00821178821178959*G0_0_0_6_8 - 0.037642357642364*G0_0_0_6_9 + 0.000241345955631709*G0_0_0_7_0 - 0.00254856254856296*G0_0_0_7_2 + 0.0013900385328959*G0_0_0_7_3 - 0.00729270729270851*G0_0_0_7_4 + 0.00394748109033889*G0_0_0_7_5 - 0.000839160839160979*G0_0_0_7_6 + 0.00489225060653712*G0_0_0_7_7 - 0.0015042100756389*G0_0_0_7_8 + 0.00385328956757592*G0_0_0_7_9 - 0.0023354423354427*G0_0_0_8_2 - 0.00147852147852171*G0_0_0_8_4 - 0.00310832025117792*G0_0_0_8_5 + 0.00821178821178959*G0_0_0_8_6 - 0.0015042100756389*G0_0_0_8_7 + 0.00119309262166424*G0_0_0_8_8 + 0.00262023690595162*G0_0_0_8_9 - 0.000724989296418*G0_0_0_9_0 + 0.000112268683697269*G0_0_0_9_1 + 0.0175824175824205*G0_0_0_9_2 - 0.00311688311688362*G0_0_0_9_3 + 0.0256543456543499*G0_0_0_9_4 + 0.00839160839160985*G0_0_0_9_5 - 0.037642357642364*G0_0_0_9_6 + 0.00385328956757592*G0_0_0_9_7 + 0.00262023690595162*G0_0_0_9_8 - 0.00287712287712333*G0_0_0_9_9 + 0.000541680541680631*G0_0_1_0_0 + 0.000339766054051818*G0_0_1_0_1 + 0.0034942834942841*G0_0_1_0_2 - 0.00163297020439906*G0_0_1_0_3 + 0.010469213326358*G0_0_1_0_4 - 0.000261643118786011*G0_0_1_0_5 - 0.00105418391132696*G0_0_1_0_6 + 0.000266083123226038*G0_0_1_0_7 - 0.00092478949621824*G0_0_1_0_9 + 0.000339766054051818*G0_0_1_1_0 + 0.000488400488400421*G0_0_1_1_1 + 0.00862322862323008*G0_0_1_1_2 - 0.00576946862661251*G0_0_1_1_3 + 0.0165015936444536*G0_0_1_1_4 - 0.00108684965827841*G0_0_1_1_5 - 0.00313718028003798*G0_0_1_1_6 + 0.000565783422926272*G0_0_1_1_8 - 0.00441463298606233*G0_0_1_1_9 + 0.00349428349428409*G0_0_1_2_0 + 0.00862322862323008*G0_0_1_2_1 + 0.067710067710079*G0_0_1_2_2 - 0.0402974802974871*G0_0_1_2_3 + 0.0957264957265119*G0_0_1_2_4 - 0.0141902541902565*G0_0_1_2_5 + 0.0280608280608327*G0_0_1_2_6 - 0.00168054168054195*G0_0_1_2_7 - 0.00192696192696225*G0_0_1_2_8 + 0.0141724941724965*G0_0_1_2_9 - 0.00163297020439906*G0_0_1_3_0 - 0.00576946862661251*G0_0_1_3_1 - 0.0402974802974871*G0_0_1_3_2 + 0.0333009847295616*G0_0_1_3_3 - 0.0812187812187949*G0_0_1_3_4 + 0.0062879977165702*G0_0_1_3_5 + 0.00499500499500588*G0_0_1_3_6 + 0.000482374768089158*G0_0_1_3_7 - 0.00184672470386794*G0_0_1_3_8 + 0.0122791494220087*G0_0_1_3_9 + 0.010469213326358*G0_0_1_4_0 + 0.0165015936444536*G0_0_1_4_1 + 0.0957264957265119*G0_0_1_4_2 - 0.0812187812187949*G0_0_1_4_3 + 0.421918081918153*G0_0_1_4_4 - 0.0358241758241819*G0_0_1_4_5 + 0.030829170829176*G0_0_1_4_6 - 0.01097473954617*G0_0_1_4_7 + 0.00136434993577878*G0_0_1_4_8 + 0.0291308691308739*G0_0_1_4_9 - 0.000261643118786011*G0_0_1_5_0 - 0.00108684965827841*G0_0_1_5_1 - 0.0141902541902566*G0_0_1_5_2 + 0.0062879977165702*G0_0_1_5_3 - 0.0358241758241819*G0_0_1_5_4 - 0.000665049236478024*G0_0_1_5_5 + 0.005954045954047*G0_0_1_5_6 + 0.000530897673754896*G0_0_1_5_7 - 0.00115598687027278*G0_0_1_5_8 + 0.00508634222920026*G0_0_1_5_9 - 0.00105418391132696*G0_0_1_6_0 - 0.00313718028003798*G0_0_1_6_1 + 0.0280608280608327*G0_0_1_6_2 + 0.00499500499500588*G0_0_1_6_3 + 0.030829170829176*G0_0_1_6_4 + 0.005954045954047*G0_0_1_6_5 - 0.0789810189810328*G0_0_1_6_6 + 0.000625089196517868*G0_0_1_6_7 + 0.00980448123305435*G0_0_1_6_8 - 0.0525074925075015*G0_0_1_6_9 + 0.000266083123226038*G0_0_1_7_0 - 0.00168054168054195*G0_0_1_7_2 + 0.000482374768089158*G0_0_1_7_3 - 0.01097473954617*G0_0_1_7_4 + 0.000530897673754896*G0_0_1_7_5 + 0.000625089196517868*G0_0_1_7_6 + 0.00595690024261552*G0_0_1_7_7 - 0.000165548736977264*G0_0_1_7_8 + 0.00152419009561895*G0_0_1_7_9 + 0.000565783422926272*G0_0_1_8_1 - 0.00192696192696225*G0_0_1_8_2 - 0.00184672470386794*G0_0_1_8_3 + 0.00136434993577878*G0_0_1_8_4 - 0.00115598687027278*G0_0_1_8_5 + 0.00980448123305435*G0_0_1_8_6 - 0.000165548736977264*G0_0_1_8_7 + 0.00224061652633092*G0_0_1_8_8 + 0.0105151990866294*G0_0_1_8_9 - 0.00092478949621824*G0_0_1_9_0 - 0.00441463298606233*G0_0_1_9_1 + 0.0141724941724965*G0_0_1_9_2 + 0.0122791494220087*G0_0_1_9_3 + 0.0291308691308739*G0_0_1_9_4 + 0.00508634222920027*G0_0_1_9_5 - 0.0525074925075015*G0_0_1_9_6 + 0.00152419009561895*G0_0_1_9_7 + 0.0105151990866294*G0_0_1_9_8 - 0.0619608962466212*G0_0_1_9_9 - 0.00321282993902097*G0_1_0_0_0 + 0.000579616040925671*G0_1_0_0_1 + 0.00748974295105375*G0_1_0_0_2 - 0.000970496104424846*G0_1_0_0_3 + 0.00502921846671935*G0_1_0_0_4 + 0.00196324508824543*G0_1_0_0_5 - 0.0074368885083184*G0_1_0_0_6 - 0.00166106710749595*G0_1_0_0_7 + 0.00208374958374994*G0_1_0_0_8 - 0.00232027892742218*G0_1_0_0_9 + 0.000579616040925671*G0_1_0_1_0 + 0.0118310943906203*G0_1_0_1_1 + 0.0149317630121227*G0_1_0_1_2 - 0.00394617617831968*G0_1_0_1_3 + 0.0161940506583391*G0_1_0_1_4 - 0.000386754449254519*G0_1_0_1_5 - 0.00459591830127624*G0_1_0_1_6 - 0.00286844768987677*G0_1_0_1_7 + 0.00723485178842449*G0_1_0_1_8 - 0.00270984967413585*G0_1_0_1_9 + 0.00748974295105375*G0_1_0_2_0 + 0.0149317630121227*G0_1_0_2_1 + 0.274367993118039*G0_1_0_2_2 - 0.0680255392755506*G0_1_0_2_3 + 0.158493289118316*G0_1_0_2_4 - 0.0312898675398727*G0_1_0_2_5 + 0.0538783670033758*G0_1_0_2_6 - 0.00211074474467366*G0_1_0_2_7 - 0.00110226909334069*G0_1_0_2_8 + 0.0115330502830522*G0_1_0_2_9 - 0.000970496104424846*G0_1_0_3_0 - 0.00394617617831968*G0_1_0_3_1 - 0.0680255392755506*G0_1_0_3_2 + 0.026914930307792*G0_1_0_3_3 - 0.0856657479425481*G0_1_0_3_4 + 0.00366160625089257*G0_1_0_3_5 + 0.0105362940630816*G0_1_0_3_6 - 0.000339972527472588*G0_1_0_3_7 + 0.000284626088197573*G0_1_0_3_8 + 0.0088094940773527*G0_1_0_3_9 + 0.00502921846671935*G0_1_0_4_0 + 0.0161940506583391*G0_1_0_4_1 + 0.158493289118316*G0_1_0_4_2 - 0.0856657479425481*G0_1_0_4_3 + 0.27693348318353*G0_1_0_4_4 - 0.018339116240905*G0_1_0_4_5 + 0.00780282217782346*G0_1_0_4_6 - 0.00275198016269491*G0_1_0_4_7 + 0.0020790816326534*G0_1_0_4_9 + 0.00196324508824543*G0_1_0_5_0 - 0.000386754449254519*G0_1_0_5_1 - 0.0312898675398727*G0_1_0_5_2 + 0.00366160625089257*G0_1_0_5_3 - 0.018339116240905*G0_1_0_5_4 - 0.0113761833404712*G0_1_0_5_5 + 0.0366403982921904*G0_1_0_5_6 - 0.00098957590029037*G0_1_0_5_7 - 0.00209119749298354*G0_1_0_5_8 + 0.0111432317682336*G0_1_0_5_9 - 0.0074368885083184*G0_1_0_6_0 - 0.00459591830127625*G0_1_0_6_1 + 0.0538783670033758*G0_1_0_6_2 + 0.0105362940630816*G0_1_0_6_3 + 0.00780282217782346*G0_1_0_6_4 + 0.0366403982921904*G0_1_0_6_5 - 0.201935980686015*G0_1_0_6_6 + 0.0030807733932739*G0_1_0_6_7 + 0.0101730115122989*G0_1_0_6_8 - 0.0556717389753197*G0_1_0_6_9 - 0.00166106710749595*G0_1_0_7_0 - 0.00286844768987677*G0_1_0_7_1 - 0.00211074474467366*G0_1_0_7_2 - 0.000339972527472588*G0_1_0_7_3 - 0.00275198016269491*G0_1_0_7_4 - 0.00098957590029037*G0_1_0_7_5 + 0.00308077339327389*G0_1_0_7_6 - 0.00220820845820872*G0_1_0_7_7 - 0.00443852278673784*G0_1_0_7_8 + 0.000799289995718681*G0_1_0_7_9 + 0.00208374958374994*G0_1_0_8_0 + 0.00723485178842449*G0_1_0_8_1 - 0.00110226909334069*G0_1_0_8_2 + 0.000284626088197573*G0_1_0_8_3 - 0.00209119749298354*G0_1_0_8_5 + 0.0101730115122989*G0_1_0_8_6 - 0.00443852278673785*G0_1_0_8_7 + 0.00991502545074146*G0_1_0_8_8 + 0.0080188561438575*G0_1_0_8_9 - 0.00232027892742218*G0_1_0_9_0 - 0.00270984967413585*G0_1_0_9_1 + 0.0115330502830522*G0_1_0_9_2 + 0.0088094940773527*G0_1_0_9_3 + 0.0020790816326534*G0_1_0_9_4 + 0.0111432317682336*G0_1_0_9_5 - 0.0556717389753197*G0_1_0_9_6 + 0.000799289995718682*G0_1_0_9_7 + 0.0080188561438575*G0_1_0_9_8 - 0.0245743542172155*G0_1_0_9_9 - 0.00564176564176654*G0_1_1_0_0 - 0.000735032163603724*G0_1_1_0_1 + 0.00248851677423149*G0_1_1_0_2 + 0.00073926073926086*G0_1_1_0_3 + 0.00346130060415837*G0_1_1_0_4 + 0.000981558124415456*G0_1_1_0_5 - 0.00512376512376602*G0_1_1_0_6 - 0.00621632335918153*G0_1_1_0_7 + 0.00461379889951394*G0_1_1_0_8 - 0.00372579801151295*G0_1_1_0_9 - 0.000735032163603724*G0_1_1_1_0 + 0.000970880970880988*G0_1_1_1_1 + 0.00719587291015984*G0_1_1_1_2 - 0.00303188874617502*G0_1_1_1_3 + 0.0113385027670762*G0_1_1_1_4 - 0.000529946244232036*G0_1_1_1_5 - 0.00532705389848339*G0_1_1_1_6 - 0.00211344211344243*G0_1_1_1_7 + 0.00431061002489636*G0_1_1_1_8 - 0.00730697873555142*G0_1_1_1_9 + 0.00248851677423149*G0_1_1_2_0 + 0.00719587291015984*G0_1_1_2_1 + 0.0594664594664693*G0_1_1_2_2 - 0.0339216339216396*G0_1_1_2_3 + 0.0847663447663591*G0_1_1_2_4 - 0.0113664113664133*G0_1_1_2_5 + 0.0182639582639613*G0_1_1_2_6 - 0.00383806669521018*G0_1_1_2_7 - 0.000910518053375351*G0_1_1_2_8 + 0.00945720945721105*G0_1_1_2_9 + 0.00073926073926086*G0_1_1_3_0 - 0.00303188874617502*G0_1_1_3_1 - 0.0339216339216396*G0_1_1_3_2 + 0.0273954616811805*G0_1_1_3_3 - 0.0603653489367877*G0_1_1_3_4 - 0.000707863565006557*G0_1_1_3_5 + 0.0167689453403768*G0_1_1_3_6 - 0.00142999857285593*G0_1_1_3_7 - 0.00208933923219676*G0_1_1_3_8 + 0.0247809333523661*G0_1_1_3_9 + 0.00346130060415837*G0_1_1_4_0 + 0.0113385027670762*G0_1_1_4_1 + 0.0847663447663591*G0_1_1_4_2 - 0.0603653489367877*G0_1_1_4_3 + 0.332147852147909*G0_1_1_4_4 - 0.00959611816754833*G0_1_1_4_5 - 0.00717282717282842*G0_1_1_4_6 + 0.000171257314114483*G0_1_1_4_7 + 0.00351933780505271*G0_1_1_4_8 - 0.00917939203653656*G0_1_1_4_9 + 0.000981558124415456*G0_1_1_5_0 - 0.000529946244232036*G0_1_1_5_1 - 0.0113664113664133*G0_1_1_5_2 - 0.000707863565006557*G0_1_1_5_3 - 0.00959611816754833*G0_1_1_5_4 - 0.0238561438561478*G0_1_1_5_5 + 0.0301755387469725*G0_1_1_5_6 - 0.01467960610818*G0_1_1_5_7 + 0.00237762237762275*G0_1_1_5_8 + 0.00642214927929331*G0_1_1_5_9 - 0.00512376512376602*G0_1_1_6_0 - 0.00532705389848339*G0_1_1_6_1 + 0.0182639582639613*G0_1_1_6_2 + 0.0167689453403768*G0_1_1_6_3 - 0.00717282717282841*G0_1_1_6_4 + 0.0301755387469725*G0_1_1_6_5 - 0.103216783216801*G0_1_1_6_6 + 0.0123019837305572*G0_1_1_6_7 + 0.00896246610532477*G0_1_1_6_8 - 0.0619095190523867*G0_1_1_6_9 - 0.00621632335918153*G0_1_1_7_0 - 0.00211344211344243*G0_1_1_7_1 - 0.00383806669521019*G0_1_1_7_2 - 0.00142999857285593*G0_1_1_7_3 + 0.000171257314114484*G0_1_1_7_4 - 0.01467960610818*G0_1_1_7_5 + 0.0123019837305572*G0_1_1_7_6 - 0.0654659626088307*G0_1_1_7_7 + 0.00326816041101818*G0_1_1_7_8 - 0.0134265734265757*G0_1_1_7_9 + 0.00461379889951394*G0_1_1_8_0 + 0.00431061002489636*G0_1_1_8_1 - 0.000910518053375351*G0_1_1_8_2 - 0.00208933923219676*G0_1_1_8_3 + 0.00351933780505271*G0_1_1_8_4 + 0.00237762237762275*G0_1_1_8_5 + 0.00896246610532478*G0_1_1_8_6 + 0.00326816041101818*G0_1_1_8_7 - 0.0112287712287733*G0_1_1_8_8 + 0.0148822605965488*G0_1_1_8_9 - 0.00372579801151295*G0_1_1_9_0 - 0.00730697873555142*G0_1_1_9_1 + 0.00945720945721105*G0_1_1_9_2 + 0.0247809333523661*G0_1_1_9_3 - 0.00917939203653656*G0_1_1_9_4 + 0.00642214927929331*G0_1_1_9_5 - 0.0619095190523867*G0_1_1_9_6 - 0.0134265734265757*G0_1_1_9_7 + 0.0148822605965488*G0_1_1_9_8 - 0.122072213500805*G0_1_1_9_9;
    A[117] = -A[110] + 0.0168937235603931*G0_0_0_0_0 + 0.00333426714379152*G0_0_0_0_1 + 0.0120377682282465*G0_0_0_0_2 - 0.00732759304188*G0_0_0_0_3 + 0.0198062255205147*G0_0_0_0_4 + 0.0394078936936146*G0_0_0_0_5 + 0.00342482913911539*G0_0_0_0_6 + 0.0127088784231663*G0_0_0_0_7 - 0.00822447393876104*G0_0_0_0_8 + 0.0206593406593442*G0_0_0_0_9 + 0.00333426714379152*G0_0_0_1_0 + 0.00265131693703166*G0_0_0_1_1 + 0.0203624241719515*G0_0_0_1_2 - 0.0176969062683378*G0_0_0_1_3 + 0.033311133311139*G0_0_0_1_4 - 0.00821432535718391*G0_0_0_1_5 + 0.00261199118342017*G0_0_0_1_6 + 0.00211058782487389*G0_0_0_1_7 - 0.00155241583813039*G0_0_0_1_8 + 0.011746348889208*G0_0_0_1_9 + 0.0120377682282465*G0_0_0_2_0 + 0.0203624241719515*G0_0_0_2_1 + 0.312827912827965*G0_0_0_2_2 - 0.0938039738039896*G0_0_0_2_3 + 0.209399489399525*G0_0_0_2_4 - 0.0282339882339929*G0_0_0_2_5 + 0.0918992118992272*G0_0_0_2_6 + 0.000842332270903857*G0_0_0_2_7 - 0.00556649699506933*G0_0_0_2_8 + 0.00895104895105042*G0_0_0_2_9 - 0.00732759304188*G0_0_0_3_0 - 0.0176969062683378*G0_0_0_3_1 - 0.0938039738039896*G0_0_0_3_2 + 0.0926273726273886*G0_0_0_3_3 - 0.145471671185982*G0_0_0_3_4 + 0.0336520622234964*G0_0_0_3_5 - 0.0285143428000619*G0_0_0_3_6 + 0.00130440987583863*G0_0_0_3_7 + 0.00267446838875457*G0_0_0_3_8 - 0.0378478664193012*G0_0_0_3_9 + 0.0198062255205147*G0_0_0_4_0 + 0.0333111333111391*G0_0_0_4_1 + 0.209399489399525*G0_0_0_4_2 - 0.145471671185982*G0_0_0_4_3 + 0.637602397602507*G0_0_0_4_4 - 0.0800970458113451*G0_0_0_4_5 + 0.108611388611407*G0_0_0_4_6 - 0.020633652062227*G0_0_0_4_7 - 0.00397887826459321*G0_0_0_4_8 + 0.133340944769539*G0_0_0_4_9 + 0.0394078936936146*G0_0_0_5_0 - 0.00821432535718391*G0_0_0_5_1 - 0.0282339882339929*G0_0_0_5_2 + 0.0336520622234964*G0_0_0_5_3 - 0.0800970458113451*G0_0_0_5_4 - 0.105163408020569*G0_0_0_5_5 - 0.134808049093786*G0_0_0_5_6 + 0.0192407592407624*G0_0_0_5_7 + 0.00396460682175036*G0_0_0_5_8 - 0.0699072356215332*G0_0_0_5_9 + 0.00342482913911538*G0_0_0_6_0 + 0.00261199118342017*G0_0_0_6_1 + 0.0918992118992272*G0_0_0_6_2 - 0.0285143428000619*G0_0_0_6_3 + 0.108611388611407*G0_0_0_6_4 - 0.134808049093786*G0_0_0_6_5 - 0.181098901098933*G0_0_0_6_6 - 0.0232053660625128*G0_0_0_6_7 + 0.0147709433423744*G0_0_0_6_8 + 0.0301755387469724*G0_0_0_6_9 + 0.0127088784231663*G0_0_0_7_0 + 0.00211058782487389*G0_0_0_7_1 + 0.000842332270903857*G0_0_0_7_2 + 0.00130440987583863*G0_0_0_7_3 - 0.020633652062227*G0_0_0_7_4 + 0.0192407592407624*G0_0_0_7_5 - 0.0232053660625128*G0_0_0_7_6 + 0.0204081632653096*G0_0_0_7_7 - 0.0119851576994454*G0_0_0_7_8 - 0.0155672898530068*G0_0_0_7_9 - 0.00822447393876104*G0_0_0_8_0 - 0.00155241583813039*G0_0_0_8_1 - 0.00556649699506933*G0_0_0_8_2 + 0.00267446838875458*G0_0_0_8_3 - 0.00397887826459321*G0_0_0_8_4 + 0.00396460682175036*G0_0_0_8_5 + 0.0147709433423744*G0_0_0_8_6 - 0.0119851576994454*G0_0_0_8_7 - 0.00322534608248948*G0_0_0_8_8 - 0.0272812901384376*G0_0_0_8_9 + 0.0206593406593442*G0_0_0_9_0 + 0.011746348889208*G0_0_0_9_1 + 0.00895104895105041*G0_0_0_9_2 - 0.0378478664193012*G0_0_0_9_3 + 0.133340944769539*G0_0_0_9_4 - 0.0699072356215332*G0_0_0_9_5 + 0.0301755387469724*G0_0_0_9_6 - 0.0155672898530068*G0_0_0_9_7 - 0.0272812901384376*G0_0_0_9_8 + 0.233868988154742*G0_0_0_9_9 + 0.0120679320679342*G0_0_1_0_0 + 0.00187600759029363*G0_0_1_0_1 + 0.00596060024631556*G0_0_1_0_2 - 0.00280893709465188*G0_0_1_0_3 + 0.0206533149390329*G0_0_1_0_4 + 0.00228247942533697*G0_0_1_0_5 - 0.00236905951191701*G0_0_1_0_6 + 0.0116147344718794*G0_0_1_0_7 - 0.00637774923489322*G0_0_1_0_8 + 0.00431568431568513*G0_0_1_0_9 + 0.00187600759029363*G0_0_1_1_0 + 0.00381544381544435*G0_0_1_1_1 + 0.0116126201840508*G0_0_1_1_2 - 0.0195613909899658*G0_0_1_1_3 + 0.0309671281099906*G0_0_1_1_4 + 0.00375973233116151*G0_0_1_1_5 + 0.0119106290534882*G0_0_1_1_6 + 0.00635428063999604*G0_0_1_1_7 - 0.0067411953126251*G0_0_1_1_8 + 0.0217306503020825*G0_0_1_1_9 + 0.00596060024631556*G0_0_1_2_0 + 0.0116126201840507*G0_0_1_2_1 + 0.100992340992358*G0_0_1_2_2 - 0.0571492000063526*G0_0_1_2_3 + 0.133209013209036*G0_0_1_2_4 - 0.0175088403659862*G0_0_1_2_5 + 0.0244111444111486*G0_0_1_2_6 + 0.00539238539238631*G0_0_1_2_7 - 0.00171574457288772*G0_0_1_2_8 - 0.000875315161029589*G0_0_1_2_9 - 0.00280893709465188*G0_0_1_3_0 - 0.0195613909899658*G0_0_1_3_1 - 0.0571492000063526*G0_0_1_3_2 + 0.0993549307835192*G0_0_1_3_3 - 0.131277294134459*G0_0_1_3_4 + 0.00486656200942003*G0_0_1_3_5 - 0.0483173968888335*G0_0_1_3_6 - 0.00415869844441346*G0_0_1_3_7 + 0.0115969744541192*G0_0_1_3_8 - 0.0568745540174206*G0_0_1_3_9 + 0.0206533149390329*G0_0_1_4_0 + 0.0309671281099906*G0_0_1_4_1 + 0.133209013209036*G0_0_1_4_2 - 0.131277294134459*G0_0_1_4_3 + 0.753900385329086*G0_0_1_4_4 - 0.0745454545454673*G0_0_1_4_5 + 0.122862851434301*G0_0_1_4_6 - 0.032775795632944*G0_0_1_4_7 - 0.0074382760097058*G0_0_1_4_8 + 0.151716854574023*G0_0_1_4_9 + 0.00228247942533697*G0_0_1_5_0 + 0.00375973233116152*G0_0_1_5_1 - 0.0175088403659862*G0_0_1_5_2 + 0.00486656200942002*G0_0_1_5_3 - 0.0745454545454673*G0_0_1_5_4 + 0.0763493649208061*G0_0_1_5_5 - 0.0164977879263622*G0_0_1_5_6 + 0.0526273726273815*G0_0_1_5_7 - 0.0238647067218536*G0_0_1_5_8 + 0.0347823604966519*G0_0_1_5_9 - 0.00236905951191701*G0_0_1_6_0 + 0.0119106290534882*G0_0_1_6_1 + 0.0244111444111486*G0_0_1_6_2 - 0.0483173968888336*G0_0_1_6_3 + 0.122862851434301*G0_0_1_6_4 - 0.0164977879263622*G0_0_1_6_5 + 0.102431853860442*G0_0_1_6_6 - 0.0287626659055279*G0_0_1_6_7 - 0.00899957185671619*G0_0_1_6_8 + 0.0992607392607559*G0_0_1_6_9 + 0.0116147344718794*G0_0_1_7_0 + 0.00635428063999605*G0_0_1_7_1 + 0.00539238539238631*G0_0_1_7_2 - 0.00415869844441345*G0_0_1_7_3 - 0.032775795632944*G0_0_1_7_4 + 0.0526273726273815*G0_0_1_7_5 - 0.0287626659055279*G0_0_1_7_6 + 0.121812473241066*G0_0_1_7_7 - 0.0253403739118068*G0_0_1_7_8 + 0.0445782788640007*G0_0_1_7_9 - 0.00637774923489322*G0_0_1_8_0 - 0.0067411953126251*G0_0_1_8_1 - 0.00171574457288772*G0_0_1_8_2 + 0.0115969744541192*G0_0_1_8_3 - 0.0074382760097058*G0_0_1_8_4 - 0.0238647067218536*G0_0_1_8_5 - 0.00899957185671619*G0_0_1_8_6 - 0.0253403739118068*G0_0_1_8_7 + 0.0222263450834915*G0_0_1_8_8 - 0.0503153988868359*G0_0_1_8_9 + 0.00431568431568512*G0_0_1_9_0 + 0.0217306503020825*G0_0_1_9_1 - 0.000875315161029592*G0_0_1_9_2 - 0.0568745540174206*G0_0_1_9_3 + 0.151716854574023*G0_0_1_9_4 + 0.034782360496652*G0_0_1_9_5 + 0.0992607392607559*G0_0_1_9_6 + 0.0445782788640007*G0_0_1_9_7 - 0.0503153988868359*G0_0_1_9_8 + 0.359126587698077*G0_0_1_9_9 - 0.0290070423403803*G0_1_0_0_0 - 0.000586820586820675*G0_1_0_0_1 + 0.00886214314785897*G0_1_0_0_2 - 0.00366744366744428*G0_1_0_0_3 + 0.0151708608851493*G0_1_0_0_4 + 0.0231574774431958*G0_1_0_0_5 - 0.00725401582544572*G0_1_0_0_6 - 0.0169503512360683*G0_1_0_0_7 + 0.00626262626262726*G0_1_0_0_8 + 0.0139917225631535*G0_1_0_0_9 - 0.000586820586820675*G0_1_0_1_0 + 0.00355919213062129*G0_1_0_1_1 + 0.0179412122269296*G0_1_0_1_2 - 0.0175564118421291*G0_1_0_1_3 + 0.0285412999698763*G0_1_0_1_4 + 0.0222742337028089*G0_1_0_1_5 + 0.000165865880151606*G0_1_0_1_6 + 0.004150452721882*G0_1_0_1_7 - 0.00514025656882888*G0_1_0_1_8 + 0.0185319442462331*G0_1_0_1_9 + 0.00886214314785897*G0_1_0_2_0 + 0.0179412122269296*G0_1_0_2_1 + 0.282267855601236*G0_1_0_2_2 - 0.0825009910724335*G0_1_0_2_3 + 0.185689865689897*G0_1_0_2_4 - 0.00831739688882671*G0_1_0_2_5 + 0.0473926073926152*G0_1_0_2_6 + 0.00227708799137412*G0_1_0_2_7 - 0.00530865959437476*G0_1_0_2_8 + 0.00286190000475764*G0_1_0_2_9 - 0.00366744366744428*G0_1_0_3_0 - 0.0175564118421291*G0_1_0_3_1 - 0.0825009910724335*G0_1_0_3_2 + 0.07812473241046*G0_1_0_3_3 - 0.125269016697609*G0_1_0_3_4 - 0.0190637933495107*G0_1_0_3_5 - 0.018190381047527*G0_1_0_3_6 - 0.00669045240473924*G0_1_0_3_7 + 0.00845725702868705*G0_1_0_3_8 - 0.0422149279292206*G0_1_0_3_9 + 0.0151708608851493*G0_1_0_4_0 + 0.0285412999698763*G0_1_0_4_1 + 0.185689865689897*G0_1_0_4_2 - 0.125269016697609*G0_1_0_4_3 + 0.562320536606347*G0_1_0_4_4 - 0.0632053660625197*G0_1_0_4_5 + 0.0813957471100466*G0_1_0_4_6 - 0.0173255316112488*G0_1_0_4_7 - 0.00176680462394778*G0_1_0_4_8 + 0.117825032110766*G0_1_0_4_9 + 0.0231574774431958*G0_1_0_5_0 + 0.0222742337028089*G0_1_0_5_1 - 0.00831739688882671*G0_1_0_5_2 - 0.0190637933495107*G0_1_0_5_3 - 0.0632053660625197*G0_1_0_5_4 + 0.733389467675305*G0_1_0_5_5 - 0.110463821892412*G0_1_0_5_6 + 0.109039531896693*G0_1_0_5_7 - 0.0845154845154987*G0_1_0_5_8 + 0.127055801341537*G0_1_0_5_9 - 0.00725401582544572*G0_1_0_6_0 + 0.000165865880151603*G0_1_0_6_1 + 0.0473926073926152*G0_1_0_6_2 - 0.018190381047527*G0_1_0_6_3 + 0.0813957471100466*G0_1_0_6_4 - 0.110463821892412*G0_1_0_6_5 - 0.103613529327833*G0_1_0_6_6 - 0.0245240473811944*G0_1_0_6_7 + 0.0165605822748708*G0_1_0_6_8 + 0.0277950620807809*G0_1_0_6_9 - 0.0169503512360683*G0_1_0_7_0 + 0.004150452721882*G0_1_0_7_1 + 0.00227708799137412*G0_1_0_7_2 - 0.00669045240473924*G0_1_0_7_3 - 0.0173255316112488*G0_1_0_7_4 + 0.109039531896693*G0_1_0_7_5 - 0.0245240473811944*G0_1_0_7_6 + 0.00337662337662415*G0_1_0_7_7 - 0.0112487512487532*G0_1_0_7_8 + 0.00707292707292828*G0_1_0_7_9 + 0.00626262626262726*G0_1_0_8_0 - 0.00514025656882888*G0_1_0_8_1 - 0.00530865959437476*G0_1_0_8_2 + 0.00845725702868705*G0_1_0_8_3 - 0.00176680462394778*G0_1_0_8_4 - 0.0845154845154988*G0_1_0_8_5 + 0.0165605822748708*G0_1_0_8_6 - 0.0112487512487532*G0_1_0_8_7 + 0.0096275153418028*G0_1_0_8_8 - 0.0520622234908036*G0_1_0_8_9 + 0.0139917225631536*G0_1_0_9_0 + 0.0185319442462331*G0_1_0_9_1 + 0.00286190000475763*G0_1_0_9_2 - 0.0422149279292206*G0_1_0_9_3 + 0.117825032110766*G0_1_0_9_4 + 0.127055801341537*G0_1_0_9_5 + 0.027795062080781*G0_1_0_9_6 + 0.00707292707292829*G0_1_0_9_7 - 0.0520622234908036*G0_1_0_9_8 + 0.162865705722877*G0_1_0_9_9 - 0.0889244089244239*G0_1_1_0_0 - 0.0097366125937571*G0_1_1_0_1 - 0.00109319252176409*G0_1_1_0_3 + 0.0152609295466465*G0_1_1_0_4 - 0.0221286649858115*G0_1_1_0_5 + 0.0151397808540691*G0_1_1_0_6 - 0.121594278737156*G0_1_1_0_7 + 0.0507714507714593*G0_1_1_0_8 + 0.0051909994767146*G0_1_1_0_9 - 0.0097366125937571*G0_1_1_1_0 + 0.00973661259375712*G0_1_1_1_2 - 0.0128201956773408*G0_1_1_1_3 + 0.0246128474699946*G0_1_1_1_4 - 0.00815089672232665*G0_1_1_1_5 + 0.00815089672232667*G0_1_1_1_6 - 0.0246128474699945*G0_1_1_1_7 + 0.0128201956773406*G0_1_1_1_8 + 0.00973661259375712*G0_1_1_2_1 + 0.088924408924424*G0_1_1_2_2 - 0.0507714507714594*G0_1_1_2_3 + 0.121594278737157*G0_1_1_2_4 - 0.0151397808540691*G0_1_1_2_5 + 0.0221286649858116*G0_1_1_2_6 - 0.0152609295466463*G0_1_1_2_7 + 0.00109319252176413*G0_1_1_2_8 - 0.00519099947671461*G0_1_1_2_9 - 0.00109319252176409*G0_1_1_3_0 - 0.0128201956773408*G0_1_1_3_1 - 0.0507714507714594*G0_1_1_3_2 + 0.0771285857000275*G0_1_1_3_3 - 0.105936920222653*G0_1_1_3_4 + 0.0138661338661362*G0_1_1_3_5 - 0.02445269016698*G0_1_1_3_6 + 0.00327957756529253*G0_1_1_3_7 - 0.00655915513058462*G0_1_1_3_9 + 0.0152609295466465*G0_1_1_4_0 + 0.0246128474699946*G0_1_1_4_1 + 0.121594278737157*G0_1_1_4_2 - 0.105936920222653*G0_1_1_4_3 + 0.63208791208802*G0_1_1_4_4 - 0.0457827886399393*G0_1_1_4_5 + 0.0702354788069193*G0_1_1_4_6 - 0.0032795775652924*G0_1_1_4_8 + 0.107138575710022*G0_1_1_4_9 - 0.0221286649858115*G0_1_1_5_0 - 0.00815089672232665*G0_1_1_5_1 - 0.0151397808540691*G0_1_1_5_2 + 0.0138661338661362*G0_1_1_5_3 - 0.0457827886399393*G0_1_1_5_4 - 0.0260824889396358*G0_1_1_5_5 - 0.070235478806919*G0_1_1_5_7 + 0.0244526901669799*G0_1_1_5_8 - 0.0644783787641038*G0_1_1_5_9 + 0.0151397808540691*G0_1_1_6_0 + 0.00815089672232667*G0_1_1_6_1 + 0.0221286649858116*G0_1_1_6_2 - 0.02445269016698*G0_1_1_6_3 + 0.0702354788069193*G0_1_1_6_4 + 0.026082488939636*G0_1_1_6_6 + 0.0457827886399391*G0_1_1_6_7 - 0.0138661338661362*G0_1_1_6_8 + 0.0644783787641039*G0_1_1_6_9 - 0.121594278737156*G0_1_1_7_0 - 0.0246128474699945*G0_1_1_7_1 - 0.0152609295466463*G0_1_1_7_2 + 0.00327957756529252*G0_1_1_7_3 - 0.070235478806919*G0_1_1_7_5 + 0.0457827886399391*G0_1_1_7_6 - 0.632087912088018*G0_1_1_7_7 + 0.105936920222652*G0_1_1_7_8 - 0.107138575710022*G0_1_1_7_9 + 0.0507714507714593*G0_1_1_8_0 + 0.0128201956773406*G0_1_1_8_1 + 0.00109319252176413*G0_1_1_8_2 - 0.0032795775652924*G0_1_1_8_4 + 0.0244526901669799*G0_1_1_8_5 - 0.0138661338661362*G0_1_1_8_6 + 0.105936920222652*G0_1_1_8_7 - 0.0771285857000273*G0_1_1_8_8 + 0.00655915513058493*G0_1_1_8_9 + 0.00519099947671459*G0_1_1_9_0 - 0.00519099947671461*G0_1_1_9_2 - 0.00655915513058462*G0_1_1_9_3 + 0.107138575710022*G0_1_1_9_4 - 0.0644783787641038*G0_1_1_9_5 + 0.0644783787641039*G0_1_1_9_6 - 0.107138575710022*G0_1_1_9_7 + 0.00655915513058492*G0_1_1_9_8;
    A[65] = -A[110] - 0.000420602325364306*G0_0_0_0_0 - 0.00640149973483414*G0_0_0_0_2 - 0.00149945292802463*G0_0_0_0_3 + 0.0105494505494524*G0_0_0_0_4 + 0.00766471623614613*G0_0_0_0_5 - 0.0247752247752291*G0_0_0_0_6 + 0.000339977482834678*G0_0_0_0_7 - 0.000837257980115262*G0_0_0_0_9 + 0.000420602325364315*G0_0_0_1_1 + 0.00640149973483418*G0_0_0_1_2 - 0.00766471623614614*G0_0_0_1_3 + 0.0247752247752291*G0_0_0_1_4 + 0.00149945292802462*G0_0_0_1_5 - 0.0105494505494524*G0_0_0_1_6 - 0.000339977482834679*G0_0_0_1_8 + 0.000837257980115266*G0_0_0_1_9 - 0.00640149973483414*G0_0_0_2_0 + 0.00640149973483418*G0_0_0_2_1 - 0.0333888333888392*G0_0_0_2_3 + 0.0966144966145133*G0_0_0_2_4 + 0.033388833388839*G0_0_0_2_5 - 0.0966144966145129*G0_0_0_2_6 - 0.000213120213120258*G0_0_0_2_7 + 0.000213120213120237*G0_0_0_2_8 - 0.00149945292802463*G0_0_0_3_0 - 0.00766471623614614*G0_0_0_3_1 - 0.0333888333888392*G0_0_0_3_2 + 0.0274925074925123*G0_0_0_3_3 - 0.121158841158862*G0_0_0_3_4 + 0.0316483516483568*G0_0_0_3_6 + 0.00449835878407382*G0_0_0_3_7 - 0.00385899814471306*G0_0_0_3_8 - 0.0115084915084934*G0_0_0_3_9 + 0.0105494505494524*G0_0_0_4_0 + 0.0247752247752291*G0_0_0_4_1 + 0.0966144966145133*G0_0_0_4_2 - 0.121158841158862*G0_0_0_4_3 + 0.49550449550458*G0_0_0_4_4 - 0.0316483516483571*G0_0_0_4_5 - 0.0155044955044981*G0_0_0_4_7 - 0.00063936063936076*G0_0_0_4_8 + 0.063296703296714*G0_0_0_4_9 + 0.00766471623614613*G0_0_0_5_0 + 0.00149945292802462*G0_0_0_5_1 + 0.033388833388839*G0_0_0_5_2 - 0.0316483516483571*G0_0_0_5_4 - 0.0274925074925122*G0_0_0_5_5 + 0.121158841158862*G0_0_0_5_6 + 0.00385899814471309*G0_0_0_5_7 - 0.00449835878407382*G0_0_0_5_8 + 0.0115084915084934*G0_0_0_5_9 - 0.0247752247752291*G0_0_0_6_0 - 0.0105494505494524*G0_0_0_6_1 - 0.0966144966145129*G0_0_0_6_2 + 0.0316483516483568*G0_0_0_6_3 + 0.121158841158862*G0_0_0_6_5 - 0.495504495504579*G0_0_0_6_6 + 0.000639360639360703*G0_0_0_6_7 + 0.015504495504498*G0_0_0_6_8 - 0.0632967032967138*G0_0_0_6_9 + 0.000339977482834678*G0_0_0_7_0 - 0.000213120213120258*G0_0_0_7_2 + 0.00449835878407382*G0_0_0_7_3 - 0.0155044955044981*G0_0_0_7_4 + 0.00385899814471309*G0_0_0_7_5 + 0.000639360639360705*G0_0_0_7_6 + 0.0036991579848729*G0_0_0_7_7 + 0.00123305266162429*G0_0_0_7_9 - 0.000339977482834679*G0_0_0_8_1 + 0.000213120213120236*G0_0_0_8_2 - 0.00385899814471306*G0_0_0_8_3 - 0.000639360639360759*G0_0_0_8_4 - 0.00449835878407382*G0_0_0_8_5 + 0.015504495504498*G0_0_0_8_6 - 0.00369915798487286*G0_0_0_8_8 - 0.0012330526616243*G0_0_0_8_9 - 0.000837257980115262*G0_0_0_9_0 + 0.000837257980115266*G0_0_0_9_1 - 0.0115084915084934*G0_0_0_9_3 + 0.063296703296714*G0_0_0_9_4 + 0.0115084915084934*G0_0_0_9_5 - 0.0632967032967138*G0_0_0_9_6 + 0.00123305266162429*G0_0_0_9_7 - 0.0012330526616243*G0_0_0_9_8 + 0.00197220768649375*G0_0_1_0_0 + 0.000323908895337523*G0_0_1_0_1 + 0.000106560106560137*G0_0_1_0_2 - 0.00291264291264341*G0_0_1_0_3 + 0.0338810395953312*G0_0_1_0_4 - 0.00448567305710239*G0_0_1_0_5 + 0.002082996368711*G0_0_1_0_6 - 0.00223015080157974*G0_0_1_0_7 - 0.000829646543932412*G0_0_1_0_8 + 0.0141116026830337*G0_0_1_0_9 + 0.000323908895337523*G0_0_1_1_0 - 0.00376512376512446*G0_0_1_1_1 + 0.00750064750064879*G0_0_1_1_2 - 0.0134417962989415*G0_0_1_1_3 + 0.0263964606821796*G0_0_1_1_4 - 0.00240267668839139*G0_0_1_1_5 - 0.00208299636871102*G0_0_1_1_6 + 0.00135990993133875*G0_0_1_1_7 - 0.00431822146107938*G0_0_1_1_8 - 0.000334903192046116*G0_0_1_1_9 + 0.000106560106560137*G0_0_1_2_0 + 0.00750064750064879*G0_0_1_2_1 + 0.0337440337440396*G0_0_1_2_2 - 0.0383261183261249*G0_0_1_2_3 + 0.0792096792096929*G0_0_1_2_4 - 0.00031968031968038*G0_0_1_2_5 + 0.000657120657120772*G0_0_1_2_7 - 0.00163392163392191*G0_0_1_2_8 + 0.000639360639360757*G0_0_1_2_9 - 0.00291264291264341*G0_0_1_3_0 - 0.0134417962989415*G0_0_1_3_1 - 0.0383261183261249*G0_0_1_3_2 + 0.0758327386898944*G0_0_1_3_3 - 0.116523476523496*G0_0_1_3_4 + 0.0115769944341393*G0_0_1_3_5 - 0.00095904095904112*G0_0_1_3_6 + 0.00152989867275606*G0_0_1_3_7 + 0.000776366490652331*G0_0_1_3_8 - 0.00205508776937371*G0_0_1_3_9 + 0.0338810395953312*G0_0_1_4_0 + 0.0263964606821796*G0_0_1_4_1 + 0.0792096792096929*G0_0_1_4_2 - 0.116523476523496*G0_0_1_4_3 + 0.988291708291876*G0_0_1_4_4 - 0.108851148851167*G0_0_1_4_5 + 0.109810189810208*G0_0_1_4_6 - 0.0482032253460906*G0_0_1_4_7 - 0.00230626516340841*G0_0_1_4_8 + 0.215784215784252*G0_0_1_4_9 - 0.00448567305710239*G0_0_1_5_0 - 0.00240267668839139*G0_0_1_5_1 - 0.000319680319680387*G0_0_1_5_2 + 0.0115769944341393*G0_0_1_5_3 - 0.108851148851167*G0_0_1_5_4 + 0.010617953475098*G0_0_1_5_5 + 0.000959040959041123*G0_0_1_5_6 + 0.00917939203653645*G0_0_1_5_7 - 0.0423348080491009*G0_0_1_5_9 + 0.002082996368711*G0_0_1_6_0 - 0.00208299636871102*G0_0_1_6_1 - 0.000959040959041123*G0_0_1_6_3 + 0.109810189810208*G0_0_1_6_4 + 0.00095904095904112*G0_0_1_6_5 - 0.109810189810209*G0_0_1_6_6 - 0.00917939203653647*G0_0_1_6_7 + 0.00917939203653645*G0_0_1_6_8 - 0.00223015080157974*G0_0_1_7_0 + 0.00135990993133875*G0_0_1_7_1 + 0.000657120657120772*G0_0_1_7_2 + 0.00152989867275606*G0_0_1_7_3 - 0.0482032253460906*G0_0_1_7_4 + 0.00917939203653645*G0_0_1_7_5 - 0.00917939203653647*G0_0_1_7_6 + 0.00742115027829452*G0_0_1_7_7 + 0.00248893963179722*G0_0_1_7_8 - 0.023976023976028*G0_0_1_7_9 - 0.000829646543932412*G0_0_1_8_0 - 0.00431822146107938*G0_0_1_8_1 - 0.00163392163392191*G0_0_1_8_2 + 0.000776366490652331*G0_0_1_8_3 - 0.00230626516340842*G0_0_1_8_4 + 0.00917939203653645*G0_0_1_8_6 + 0.00248893963179722*G0_0_1_8_7 - 0.0131297274154439*G0_0_1_8_8 + 0.00561723990295516*G0_0_1_8_9 + 0.0141116026830337*G0_0_1_9_0 - 0.000334903192046117*G0_0_1_9_1 + 0.000639360639360757*G0_0_1_9_2 - 0.00205508776937371*G0_0_1_9_3 + 0.215784215784252*G0_0_1_9_4 - 0.0423348080491009*G0_0_1_9_5 - 0.023976023976028*G0_0_1_9_7 + 0.00561723990295517*G0_0_1_9_8 + 0.0846696160982018*G0_0_1_9_9 - 0.00318862795053325*G0_1_0_0_0 - 0.000755893136845639*G0_1_0_0_1 + 0.00422367755701162*G0_1_0_0_2 + 0.00060732917875785*G0_1_0_0_3 + 0.000514089085517789*G0_1_0_0_4 + 0.00456813028241679*G0_1_0_0_5 - 0.0137364223078533*G0_1_0_0_6 - 0.000784612213183764*G0_1_0_0_7 + 0.000980289551718294*G0_1_0_0_8 - 0.00587032015603543*G0_1_0_0_9 - 0.000755893136845639*G0_1_0_1_0 - 0.00276802562516886*G0_1_0_1_1 + 0.0106251772918458*G0_1_0_1_2 - 0.00309658595372933*G0_1_0_1_3 + 0.0110388024673758*G0_1_0_1_4 + 0.00210678210678246*G0_1_0_1_5 - 0.0100353614639346*G0_1_0_1_6 + 0.00104371818657548*G0_1_0_1_7 - 0.00112458969601839*G0_1_0_1_8 - 0.00503306217592017*G0_1_0_1_9 + 0.00422367755701162*G0_1_0_2_0 + 0.0106251772918458*G0_1_0_2_1 + 0.228832895499601*G0_1_0_2_2 - 0.0505583305583391*G0_1_0_2_3 + 0.120190920190941*G0_1_0_2_4 - 0.0171694971695*G0_1_0_2_5 + 0.0235764235764274*G0_1_0_2_6 - 0.00093018093018108*G0_1_0_2_7 - 0.000717060717060819*G0_1_0_2_8 + 0.00490176490176572*G0_1_0_2_9 + 0.00060732917875785*G0_1_0_3_0 - 0.00309658595372933*G0_1_0_3_1 - 0.0505583305583391*G0_1_0_3_2 + 0.00349935778507289*G0_1_0_3_3 - 0.0557642357642454*G0_1_0_3_4 - 0.00557157128585793*G0_1_0_3_5 + 0.0331068931068986*G0_1_0_3_6 + 0.00117882117882136*G0_1_0_3_7 - 0.00633081204509876*G0_1_0_3_8 + 0.0127415441701177*G0_1_0_3_9 + 0.000514089085517788*G0_1_0_4_0 + 0.0110388024673758*G0_1_0_4_1 + 0.120190920190941*G0_1_0_4_2 - 0.0557642357642454*G0_1_0_4_3 + 0.220979020979059*G0_1_0_4_4 + 0.00145854145854165*G0_1_0_4_5 - 0.0345654345654403*G0_1_0_4_6 - 0.000876266590552465*G0_1_0_4_7 + 0.00515199086627742*G0_1_0_4_8 - 0.0176223776223805*G0_1_0_4_9 + 0.00456813028241679*G0_1_0_5_0 + 0.00210678210678246*G0_1_0_5_1 - 0.0171694971695*G0_1_0_5_2 - 0.00557157128585793*G0_1_0_5_3 + 0.00145854145854165*G0_1_0_5_4 - 0.0239931497074397*G0_1_0_5_5 + 0.0653946053946166*G0_1_0_5_6 - 0.00247181390038575*G0_1_0_5_7 - 0.00331953760525243*G0_1_0_5_8 + 0.0242500356786111*G0_1_0_5_9 - 0.0137364223078533*G0_1_0_6_0 - 0.0100353614639346*G0_1_0_6_1 + 0.0235764235764274*G0_1_0_6_2 + 0.0331068931068986*G0_1_0_6_3 - 0.0345654345654403*G0_1_0_6_4 + 0.0653946053946166*G0_1_0_6_5 - 0.274525474525521*G0_1_0_6_6 + 0.00579135150563817*G0_1_0_6_7 + 0.0146282289139456*G0_1_0_6_8 - 0.0809190809190945*G0_1_0_6_9 - 0.000784612213183764*G0_1_0_7_0 + 0.00104371818657548*G0_1_0_7_1 - 0.00093018093018108*G0_1_0_7_2 + 0.00117882117882136*G0_1_0_7_3 - 0.000876266590552465*G0_1_0_7_4 - 0.00247181390038575*G0_1_0_7_5 + 0.00579135150563817*G0_1_0_7_6 - 0.00685600114171644*G0_1_0_7_7 + 0.00226345083487973*G0_1_0_7_8 + 0.00602825745682986*G0_1_0_7_9 + 0.000980289551718294*G0_1_0_8_0 - 0.00112458969601839*G0_1_0_8_1 - 0.000717060717060819*G0_1_0_8_2 - 0.00633081204509877*G0_1_0_8_3 + 0.00515199086627742*G0_1_0_8_4 - 0.00331953760525243*G0_1_0_8_5 + 0.0146282289139456*G0_1_0_8_6 + 0.00226345083487973*G0_1_0_8_7 - 0.0105551591265892*G0_1_0_8_8 + 0.00479520479520564*G0_1_0_8_9 - 0.00587032015603543*G0_1_0_9_0 - 0.00503306217592017*G0_1_0_9_1 + 0.00490176490176572*G0_1_0_9_2 + 0.0127415441701177*G0_1_0_9_3 - 0.0176223776223805*G0_1_0_9_4 + 0.0242500356786111*G0_1_0_9_5 - 0.0809190809190945*G0_1_0_9_6 + 0.00602825745682986*G0_1_0_9_7 + 0.00479520479520564*G0_1_0_9_8 - 0.049938632795784*G0_1_0_9_9 - 0.00707525278953965*G0_1_1_0_0 - 0.00744620458906304*G0_1_1_0_1 - 0.0054044368330092*G0_1_1_0_3 + 0.00746079317508024*G0_1_1_0_4 + 0.00261452832881451*G0_1_1_0_5 - 0.00731363874221144*G0_1_1_0_6 + 0.000473811902383455*G0_1_1_0_7 - 0.00811664525950386*G0_1_1_0_8 - 0.00877027734170742*G0_1_1_0_9 - 0.00744620458906304*G0_1_1_1_0 - 0.0927280127280291*G0_1_1_1_1 + 0.002688634117206*G0_1_1_1_2 - 0.0309417566560478*G0_1_1_1_3 + 0.0146640660926401*G0_1_1_1_4 + 0.00229643372500559*G0_1_1_1_5 - 0.00939663511092245*G0_1_1_1_6 + 0.0275679875679924*G0_1_1_1_7 - 0.0618188161045412*G0_1_1_1_8 - 0.0132743447029184*G0_1_1_1_9 + 0.002688634117206*G0_1_1_2_1 + 0.0469456469456548*G0_1_1_2_2 - 0.0366722166722229*G0_1_1_2_3 + 0.0588655788655889*G0_1_1_2_4 - 0.00439338439338513*G0_1_1_2_5 + 0.00846708846708987*G0_1_1_2_6 + 0.000446854732569106*G0_1_1_2_7 - 0.00862978291549865*G0_1_1_2_8 - 0.00355644355644413*G0_1_1_2_9 - 0.0054044368330092*G0_1_1_3_0 - 0.0309417566560478*G0_1_1_3_1 - 0.0366722166722229*G0_1_1_3_2 - 0.115661481375787*G0_1_1_3_3 + 0.0338547167118651*G0_1_1_3_4 - 0.00173826173826203*G0_1_1_3_5 + 0.0409904381333022*G0_1_1_3_6 + 0.0290138432995625*G0_1_1_3_7 - 0.0677037248465935*G0_1_1_3_8 - 0.0182046524903699*G0_1_1_3_9 + 0.00746079317508024*G0_1_1_4_0 + 0.0146640660926401*G0_1_1_4_1 + 0.0588655788655889*G0_1_1_4_2 + 0.0338547167118652*G0_1_1_4_3 + 0.366273726273789*G0_1_1_4_4 - 0.00958184672470556*G0_1_1_4_5 - 0.0314085914085966*G0_1_1_4_6 - 0.0182617382617414*G0_1_1_4_7 + 0.0386898815470309*G0_1_1_4_8 + 0.0298330241187435*G0_1_1_4_9 + 0.00261452832881451*G0_1_1_5_0 + 0.00229643372500559*G0_1_1_5_1 - 0.00439338439338513*G0_1_1_5_2 - 0.00173826173826203*G0_1_1_5_3 - 0.00958184672470556*G0_1_1_5_4 - 0.0286342229199419*G0_1_1_5_5 + 0.0419494790923433*G0_1_1_5_6 - 0.0173712002283459*G0_1_1_5_7 + 0.00591123162551836*G0_1_1_5_8 + 0.0144883687740856*G0_1_1_5_9 - 0.00731363874221144*G0_1_1_6_0 - 0.00939663511092245*G0_1_1_6_1 + 0.00846708846708987*G0_1_1_6_2 + 0.0409904381333022*G0_1_1_6_3 - 0.0314085914085966*G0_1_1_6_4 + 0.0419494790923433*G0_1_1_6_5 - 0.141218781218805*G0_1_1_6_6 + 0.0114599686028276*G0_1_1_6_7 + 0.0206393606393641*G0_1_1_6_8 - 0.071311545597272*G0_1_1_6_9 + 0.000473811902383454*G0_1_1_7_0 + 0.0275679875679924*G0_1_1_7_1 + 0.000446854732569105*G0_1_1_7_2 + 0.0290138432995625*G0_1_1_7_3 - 0.0182617382617414*G0_1_1_7_4 - 0.0173712002283459*G0_1_1_7_5 + 0.0114599686028276*G0_1_1_7_6 - 0.0996146710432591*G0_1_1_7_7 + 0.0587384044527003*G0_1_1_7_8 + 0.00339089481946685*G0_1_1_7_9 - 0.00811664525950386*G0_1_1_8_0 - 0.0618188161045412*G0_1_1_8_1 - 0.00862978291549865*G0_1_1_8_2 - 0.0677037248465935*G0_1_1_8_3 + 0.0386898815470309*G0_1_1_8_4 + 0.00591123162551835*G0_1_1_8_5 + 0.0206393606393641*G0_1_1_8_6 + 0.0587384044527003*G0_1_1_8_7 - 0.242837162837204*G0_1_1_8_8 - 0.0375567289853067*G0_1_1_8_9 - 0.00877027734170741*G0_1_1_9_0 - 0.0132743447029184*G0_1_1_9_1 - 0.00355644355644413*G0_1_1_9_2 - 0.0182046524903698*G0_1_1_9_3 + 0.0298330241187435*G0_1_1_9_4 + 0.0144883687740856*G0_1_1_9_5 - 0.071311545597272*G0_1_1_9_6 + 0.00339089481946685*G0_1_1_9_7 - 0.0375567289853067*G0_1_1_9_8 - 0.195644355644388*G0_1_1_9_9;
    A[202] = -A[65] - 0.00524935382078331*G0_0_0_0_0 - 0.000932436170531563*G0_0_0_0_1 - 0.0150767046005167*G0_0_0_0_2 + 0.00109002109002123*G0_0_0_0_3 - 0.000648240648240729*G0_0_0_0_4 - 0.0108459794174098*G0_0_0_0_5 - 0.0255931370217127*G0_0_0_0_6 - 0.00281654853083472*G0_0_0_0_7 + 0.00146678718107314*G0_0_0_0_8 - 0.0103762903762922*G0_0_0_0_9 - 0.000932436170531564*G0_0_0_1_0 + 0.000534773868107354*G0_0_0_1_1 - 0.00825403873023059*G0_0_0_1_2 + 0.00676307819165072*G0_0_0_1_3 + 0.0064852607709762*G0_0_0_1_4 + 0.00659689516832487*G0_0_0_1_5 - 0.00359386645100991*G0_0_0_1_6 - 0.000132882990025886*G0_0_0_1_7 + 0.000580689152117857*G0_0_0_1_8 - 0.00686741829599089*G0_0_0_1_9 - 0.0150767046005167*G0_0_0_2_0 - 0.00825403873023059*G0_0_0_2_1 - 0.283701483701531*G0_0_0_2_2 + 0.0367587967588027*G0_0_0_2_3 - 0.0520457320457404*G0_0_0_2_4 + 0.0614097014097116*G0_0_0_2_5 - 0.174660894660924*G0_0_0_2_6 + 0.00278071135214037*G0_0_0_2_7 + 0.00258281401138584*G0_0_0_2_8 + 0.00109002109002123*G0_0_0_3_0 + 0.00676307819165071*G0_0_0_3_1 + 0.0367587967588027*G0_0_0_3_2 - 0.0444469815898468*G0_0_0_3_3 - 0.0538490081347316*G0_0_0_3_4 - 0.0158413015555898*G0_0_0_3_5 + 0.0194034536891711*G0_0_0_3_6 + 0.00535179106607774*G0_0_0_3_7 - 0.00622520336806161*G0_0_0_3_8 + 0.00989867275581711*G0_0_0_3_9 - 0.000648240648240729*G0_0_0_4_0 + 0.0064852607709762*G0_0_0_4_1 - 0.0520457320457404*G0_0_0_4_2 - 0.0538490081347316*G0_0_0_4_3 + 0.158081918081945*G0_0_0_4_4 + 0.0105665762808637*G0_0_0_4_5 - 0.0299700299700348*G0_0_0_4_6 - 0.00750963322392021*G0_0_0_4_7 + 0.000873412301983871*G0_0_0_4_8 - 0.0211331525617276*G0_0_0_4_9 - 0.0108459794174098*G0_0_0_5_0 + 0.00659689516832486*G0_0_0_5_1 + 0.0614097014097116*G0_0_0_5_2 - 0.0158413015555898*G0_0_0_5_3 + 0.0105665762808637*G0_0_0_5_4 + 0.0810960468103464*G0_0_0_5_5 + 0.174927929213673*G0_0_0_5_6 + 0.0108891108891127*G0_0_0_5_7 - 0.011168831168833*G0_0_0_5_8 + 0.0534665334665425*G0_0_0_5_9 - 0.0255931370217127*G0_0_0_6_0 - 0.00359386645100991*G0_0_0_6_1 - 0.174660894660924*G0_0_0_6_2 + 0.0194034536891711*G0_0_0_6_3 - 0.0299700299700348*G0_0_0_6_4 + 0.174927929213673*G0_0_0_6_5 + 0.014545454545458*G0_0_0_6_6 + 0.000279720279720332*G0_0_0_6_7 - 0.00279434850863472*G0_0_0_6_8 - 0.0388069073783425*G0_0_0_6_9 - 0.00281654853083472*G0_0_0_7_0 - 0.000132882990025886*G0_0_0_7_1 + 0.00278071135214037*G0_0_0_7_2 + 0.00535179106607774*G0_0_0_7_3 - 0.00750963322392021*G0_0_0_7_4 + 0.0108891108891127*G0_0_0_7_5 + 0.000279720279720334*G0_0_0_7_6 + 0.0232282003710614*G0_0_0_7_7 + 0.0305694305694358*G0_0_0_7_9 + 0.00146678718107314*G0_0_0_8_0 + 0.000580689152117857*G0_0_0_8_1 + 0.00258281401138584*G0_0_0_8_2 - 0.00622520336806161*G0_0_0_8_3 + 0.000873412301983872*G0_0_0_8_4 - 0.011168831168833*G0_0_0_8_5 - 0.00279434850863472*G0_0_0_8_6 - 0.000405308976737547*G0_0_0_8_8 + 0.0188554302840049*G0_0_0_8_9 - 0.0103762903762922*G0_0_0_9_0 - 0.00686741829599089*G0_0_0_9_1 + 0.00989867275581712*G0_0_0_9_3 - 0.0211331525617276*G0_0_0_9_4 + 0.0534665334665425*G0_0_0_9_5 - 0.0388069073783425*G0_0_0_9_6 + 0.0305694305694358*G0_0_0_9_7 + 0.0188554302840049*G0_0_0_9_8 - 0.224004566861748*G0_0_0_9_9 + 0.00737421308850005*G0_0_1_0_0 - 0.000618640618640704*G0_0_1_0_1 - 0.00261452832881448*G0_0_1_0_2 + 0.000493791922363428*G0_0_1_0_3 + 0.021217829789262*G0_0_1_0_4 - 0.0196771482485802*G0_0_1_0_5 + 0.0112033997748303*G0_0_1_0_6 - 0.00618397475540432*G0_0_1_0_7 + 0.00166627023769908*G0_0_1_0_8 - 0.00543456543456633*G0_0_1_0_9 - 0.000618640618640704*G0_0_1_1_0 - 0.00300440300440335*G0_0_1_1_1 + 0.00150251864537606*G0_0_1_1_2 - 0.00253651110794007*G0_0_1_1_3 + 0.0117025831311566*G0_0_1_1_4 - 0.00521097949669466*G0_0_1_1_5 + 0.00302174016459784*G0_0_1_1_6 + 0.00283779712351186*G0_0_1_1_7 - 0.00495821638678856*G0_0_1_1_8 + 0.00172779601351062*G0_0_1_1_9 - 0.00261452832881448*G0_0_1_2_0 + 0.00150251864537606*G0_0_1_2_1 - 0.0187042587042619*G0_0_1_2_2 - 0.00616145759003009*G0_0_1_2_3 + 0.0124675324675347*G0_0_1_2_4 + 0.000942549513978187*G0_0_1_2_5 - 0.00738816738816855*G0_0_1_2_6 + 0.00304933162076071*G0_0_1_2_7 - 0.000519480519480601*G0_0_1_2_8 + 0.0101917130488576*G0_0_1_2_9 + 0.000493791922363427*G0_0_1_3_0 - 0.00253651110794007*G0_0_1_3_1 - 0.00616145759003009*G0_0_1_3_2 + 0.0333694876552075*G0_0_1_3_3 - 0.0673298130441101*G0_0_1_3_4 + 0.00869701726844726*G0_0_1_3_5 - 0.0123076923076944*G0_0_1_3_6 - 0.00472384758099127*G0_0_1_3_7 + 0.00640787783645042*G0_0_1_3_8 + 0.00426430712145073*G0_0_1_3_9 + 0.021217829789262*G0_0_1_4_0 + 0.0117025831311566*G0_0_1_4_1 + 0.0124675324675347*G0_0_1_4_2 - 0.0673298130441101*G0_0_1_4_3 + 0.550326816041195*G0_0_1_4_4 - 0.0668959611816868*G0_0_1_4_5 + 0.0792036534893812*G0_0_1_4_6 - 0.0347795062080835*G0_0_1_4_7 - 0.00168403025545915*G0_0_1_4_8 + 0.103216783216801*G0_0_1_4_9 - 0.0196771482485802*G0_0_1_5_0 - 0.00521097949669466*G0_0_1_5_1 + 0.000942549513978184*G0_0_1_5_2 + 0.00869701726844726*G0_0_1_5_3 - 0.0668959611816868*G0_0_1_5_4 - 0.260861995147753*G0_0_1_5_5 + 0.00420151277294199*G0_0_1_5_6 + 0.012390466676183*G0_0_1_5_8 - 0.00847723704866714*G0_0_1_5_9 + 0.0112033997748303*G0_0_1_6_0 + 0.00302174016459784*G0_0_1_6_1 - 0.00738816738816855*G0_0_1_6_2 - 0.0123076923076944*G0_0_1_6_3 + 0.0792036534893812*G0_0_1_6_4 + 0.00420151277294199*G0_0_1_6_5 + 0.197439703154023*G0_0_1_6_6 - 0.0123904666761831*G0_0_1_6_7 - 0.00213215356072534*G0_0_1_6_8 - 0.00595975453118412*G0_0_1_6_9 - 0.00618397475540432*G0_0_1_7_0 + 0.00283779712351186*G0_0_1_7_1 + 0.00304933162076071*G0_0_1_7_2 - 0.00472384758099127*G0_0_1_7_3 - 0.0347795062080835*G0_0_1_7_4 - 0.0123904666761831*G0_0_1_7_6 + 0.00247466818895473*G0_0_1_7_7 - 0.00383616383616462*G0_0_1_7_8 + 0.0410846296560652*G0_0_1_7_9 + 0.00166627023769908*G0_0_1_8_0 - 0.00495821638678856*G0_0_1_8_1 - 0.000519480519480601*G0_0_1_8_2 + 0.00640787783645042*G0_0_1_8_3 - 0.00168403025545916*G0_0_1_8_4 + 0.012390466676183*G0_0_1_8_5 - 0.00213215356072534*G0_0_1_8_6 - 0.00383616383616462*G0_0_1_8_7 - 0.0120993292421881*G0_0_1_8_8 - 0.00181532752961353*G0_0_1_8_9 - 0.00543456543456633*G0_0_1_9_0 + 0.00172779601351062*G0_0_1_9_1 + 0.0101917130488576*G0_0_1_9_2 + 0.00426430712145074*G0_0_1_9_3 + 0.103216783216801*G0_0_1_9_4 - 0.00847723704866714*G0_0_1_9_5 - 0.00595975453118412*G0_0_1_9_6 + 0.0410846296560652*G0_0_1_9_7 - 0.00181532752961353*G0_0_1_9_8 + 0.158344512630253*G0_0_1_9_9 - 0.00353889496746697*G0_1_0_0_0 - 0.000746061698442784*G0_1_0_0_1 - 0.00187255425350695*G0_1_0_0_2 - 0.00520527091955752*G0_1_0_0_4 - 0.00166151309008477*G0_1_0_0_5 - 0.00428270142555933*G0_1_0_0_6 - 0.00483801912373421*G0_1_0_0_7 + 0.00130916702345293*G0_1_0_0_8 - 0.00723467009181417*G0_1_0_0_9 - 0.000746061698442784*G0_1_0_1_0 - 0.00253080253080295*G0_1_0_1_1 - 0.00172945220564297*G0_1_0_1_2 + 0.00796536796536926*G0_1_0_1_3 - 0.000232148803577393*G0_1_0_1_4 + 0.000946672375243978*G0_1_0_1_5 - 0.00576756576756674*G0_1_0_1_6 - 0.00159967017109898*G0_1_0_1_7 - 0.00192696192696234*G0_1_0_1_8 - 0.00438418724133085*G0_1_0_1_9 - 0.00187255425350695*G0_1_0_2_0 - 0.00172945220564297*G0_1_0_2_1 - 0.0105741172407856*G0_1_0_2_2 + 0.00913499199213635*G0_1_0_2_3 - 0.0055322455322464*G0_1_0_2_4 + 0.00542314828029204*G0_1_0_2_5 - 0.0143589743589768*G0_1_0_2_6 + 0.000215974501688832*G0_1_0_2_7 + 0.00312259169402077*G0_1_0_2_8 + 0.00103515532086979*G0_1_0_2_9 + 0.00796536796536926*G0_1_0_3_1 + 0.00913499199213635*G0_1_0_3_2 - 0.0596574853717817*G0_1_0_3_3 - 0.0173055515912688*G0_1_0_3_4 - 0.00411302982731621*G0_1_0_3_5 + 0.0225945483088378*G0_1_0_3_6 + 0.00519765948337472*G0_1_0_3_7 - 0.00112173540744998*G0_1_0_3_8 + 0.00275724275724309*G0_1_0_3_9 - 0.00520527091955752*G0_1_0_4_0 - 0.000232148803577391*G0_1_0_4_1 - 0.00553224553224641*G0_1_0_4_2 - 0.0173055515912688*G0_1_0_4_3 - 0.078016269444854*G0_1_0_4_4 + 0.0209076637648101*G0_1_0_4_5 - 0.0435022120736479*G0_1_0_4_6 + 0.00483801912373419*G0_1_0_4_7 - 0.00407592407592472*G0_1_0_4_8 - 0.0449207934922296*G0_1_0_4_9 - 0.00166151309008477*G0_1_0_5_0 + 0.000946672375243978*G0_1_0_5_1 + 0.00542314828029204*G0_1_0_5_2 - 0.00411302982731621*G0_1_0_5_3 + 0.0209076637648101*G0_1_0_5_4 - 0.0170372484658226*G0_1_0_5_5 + 0.0331325817040159*G0_1_0_5_6 - 0.00709576138147681*G0_1_0_5_7 + 0.00245183388040571*G0_1_0_5_8 + 0.0168003425146311*G0_1_0_5_9 - 0.00428270142555933*G0_1_0_6_0 - 0.00576756576756674*G0_1_0_6_1 - 0.0143589743589768*G0_1_0_6_2 + 0.0225945483088378*G0_1_0_6_3 - 0.0435022120736479*G0_1_0_6_4 + 0.0331325817040159*G0_1_0_6_5 - 0.0986756101041977*G0_1_0_6_6 + 0.0046439275010711*G0_1_0_6_7 + 0.00132153560725011*G0_1_0_6_8 - 0.0482945625802849*G0_1_0_6_9 - 0.00483801912373421*G0_1_0_7_0 - 0.00159967017109898*G0_1_0_7_1 + 0.000215974501688832*G0_1_0_7_2 + 0.00519765948337472*G0_1_0_7_3 + 0.00483801912373419*G0_1_0_7_4 - 0.00709576138147681*G0_1_0_7_5 + 0.0046439275010711*G0_1_0_7_6 + 0.00250891965177725*G0_1_0_7_7 + 0.0113029827315562*G0_1_0_7_8 + 0.0124161552733003*G0_1_0_7_9 + 0.00130916702345293*G0_1_0_8_0 - 0.00192696192696234*G0_1_0_8_1 + 0.00312259169402078*G0_1_0_8_2 - 0.00112173540744998*G0_1_0_8_3 - 0.00407592407592472*G0_1_0_8_4 + 0.00245183388040571*G0_1_0_8_5 + 0.00132153560725011*G0_1_0_8_6 + 0.0113029827315562*G0_1_0_8_7 + 0.0181447124304294*G0_1_0_8_8 + 0.021304409875842*G0_1_0_8_9 - 0.00723467009181417*G0_1_0_9_0 - 0.00438418724133085*G0_1_0_9_1 + 0.00103515532086979*G0_1_0_9_2 + 0.00275724275724309*G0_1_0_9_3 - 0.0449207934922296*G0_1_0_9_4 + 0.0168003425146311*G0_1_0_9_5 - 0.0482945625802849*G0_1_0_9_6 + 0.0124161552733003*G0_1_0_9_7 + 0.021304409875842*G0_1_0_9_8 - 0.0118167546738994*G0_1_0_9_9 + 0.0197719740576913*G0_1_1_0_0 - 0.00468885611742841*G0_1_1_0_1 - 0.000842437985295291*G0_1_1_0_2 - 0.00518275375418324*G0_1_1_0_3 + 0.00251716537430871*G0_1_1_0_4 + 0.00685251256679933*G0_1_1_0_5 - 0.00705167848025103*G0_1_1_0_6 + 0.0319867434153201*G0_1_1_0_7 - 0.0183686155114758*G0_1_1_0_8 - 0.00179059036201923*G0_1_1_0_9 - 0.00468885611742841*G0_1_1_1_0 - 0.0912006512006672*G0_1_1_1_1 - 0.00248492248492292*G0_1_1_1_2 - 0.0228482628482669*G0_1_1_1_3 + 0.00658325801183063*G0_1_1_1_4 + 0.000898783755926808*G0_1_1_1_5 - 0.00599717742574987*G0_1_1_1_6 + 0.0329391243677015*G0_1_1_1_7 - 0.0610678210678318*G0_1_1_1_8 - 0.0106712335283782*G0_1_1_1_9 - 0.000842437985295291*G0_1_1_2_0 - 0.00248492248492292*G0_1_1_2_1 + 0.00868464868464996*G0_1_1_2_2 - 0.00838875410304123*G0_1_1_2_3 - 0.000604157747015041*G0_1_1_2_4 + 0.00211122211122248*G0_1_1_2_5 - 0.00457732743447108*G0_1_1_2_6 + 0.00280259423116613*G0_1_1_2_7 - 0.00675832104403648*G0_1_1_2_8 - 0.00975976404547998*G0_1_1_2_9 - 0.00518275375418324*G0_1_1_3_0 - 0.0228482628482669*G0_1_1_3_1 - 0.00838875410304123*G0_1_1_3_2 - 0.148948194662506*G0_1_1_3_3 + 0.0557042957043051*G0_1_1_3_4 + 0.000870558013415303*G0_1_1_3_5 + 0.0291023262451882*G0_1_1_3_6 + 0.0266590552304884*G0_1_1_3_7 - 0.0580448123305365*G0_1_1_3_8 - 0.0213044098758421*G0_1_1_3_9 + 0.00251716537430871*G0_1_1_4_0 + 0.00658325801183063*G0_1_1_4_1 - 0.000604157747015038*G0_1_1_4_2 + 0.0557042957043051*G0_1_1_4_3 + 0.0190894819466286*G0_1_1_4_4 + 0.00355929784501263*G0_1_1_4_5 - 0.0326616240902008*G0_1_1_4_6 - 0.0135350363921816*G0_1_1_4_7 + 0.0313857571000482*G0_1_1_4_8 + 0.0221606964464147*G0_1_1_4_9 + 0.00685251256679933*G0_1_1_5_0 + 0.000898783755926808*G0_1_1_5_1 + 0.00211122211122248*G0_1_1_5_2 + 0.000870558013415304*G0_1_1_5_3 + 0.00355929784501263*G0_1_1_5_4 - 0.0486542029399255*G0_1_1_5_5 + 0.0301669758812666*G0_1_1_5_6 - 0.0111174539745987*G0_1_1_5_7 + 0.00841444270015847*G0_1_1_5_8 - 0.0114571143142592*G0_1_1_5_9 - 0.00705167848025103*G0_1_1_6_0 - 0.00599717742574987*G0_1_1_6_1 - 0.00457732743447108*G0_1_1_6_2 + 0.0291023262451882*G0_1_1_6_3 - 0.0326616240902009*G0_1_1_6_4 + 0.0301669758812666*G0_1_1_6_5 - 0.0818781218781352*G0_1_1_6_6 + 0.00270301127444029*G0_1_1_6_7 + 0.0135778507207101*G0_1_1_6_8 - 0.0289253603539365*G0_1_1_6_9 + 0.0319867434153201*G0_1_1_7_0 + 0.0329391243677015*G0_1_1_7_1 + 0.00280259423116613*G0_1_1_7_2 + 0.0266590552304884*G0_1_1_7_3 - 0.0135350363921816*G0_1_1_7_4 - 0.0111174539745987*G0_1_1_7_5 + 0.00270301127444029*G0_1_1_7_6 - 0.0491851006136806*G0_1_1_7_7 + 0.0169544740973345*G0_1_1_7_8 - 0.0183686155114758*G0_1_1_8_0 - 0.0610678210678318*G0_1_1_8_1 - 0.00675832104403648*G0_1_1_8_2 - 0.0580448123305365*G0_1_1_8_3 + 0.0313857571000482*G0_1_1_8_4 + 0.00841444270015847*G0_1_1_8_5 + 0.0135778507207101*G0_1_1_8_6 + 0.0169544740973345*G0_1_1_8_7 - 0.23749964321397*G0_1_1_8_8 - 0.0307578136149618*G0_1_1_8_9 - 0.00179059036201922*G0_1_1_9_0 - 0.0106712335283782*G0_1_1_9_1 - 0.00975976404547998*G0_1_1_9_2 - 0.0213044098758421*G0_1_1_9_3 + 0.0221606964464147*G0_1_1_9_4 - 0.0114571143142592*G0_1_1_9_5 - 0.0289253603539365*G0_1_1_9_6 - 0.0307578136149618*G0_1_1_9_8 - 0.050144141572721*G0_1_1_9_9;
    A[164] = A[202] + 0.0248403448403494*G0_0_0_0_0 + 0.00180433323290498*G0_0_0_0_1 - 0.000780172208743735*G0_0_0_0_3 + 0.00191998477712797*G0_0_0_0_4 + 0.0444526901669835*G0_0_0_0_5 - 0.00282003710575199*G0_0_0_0_6 + 0.00813472242043809*G0_0_0_0_7 - 0.00638218923933319*G0_0_0_0_8 + 0.0135179106607701*G0_0_0_0_9 + 0.00180433323290498*G0_0_0_1_0 + 0.0194768194768228*G0_0_0_1_1 - 0.000375708947137564*G0_0_0_1_2 + 0.0191789163217767*G0_0_0_1_3 - 0.0101232101232118*G0_0_0_1_4 - 0.00478759335902276*G0_0_0_1_5 - 0.00568383996955523*G0_0_0_1_6 - 0.00471909043337697*G0_0_0_1_7 + 0.00439750725465087*G0_0_0_1_8 + 0.0108462965605841*G0_0_0_1_9 - 0.000375708947137564*G0_0_0_2_1 - 0.0120649720649738*G0_0_0_2_2 + 0.0114095428381161*G0_0_0_2_3 - 0.0265867465867509*G0_0_0_2_4 + 0.0201474715760464*G0_0_0_2_5 - 0.000586080586080737*G0_0_0_2_6 - 0.0023728652300085*G0_0_0_2_7 - 0.0019618476761337*G0_0_0_2_8 - 0.0222862851434317*G0_0_0_2_9 - 0.000780172208743735*G0_0_0_3_0 + 0.0191789163217767*G0_0_0_3_1 + 0.0114095428381161*G0_0_0_3_2 + 0.0175024975025013*G0_0_0_3_3 + 0.00450406736121071*G0_0_0_3_4 + 0.0088711288711303*G0_0_0_3_5 + 0.0160125588697043*G0_0_0_3_6 + 0.00130155558727*G0_0_0_3_7 - 0.00614813757670985*G0_0_0_3_8 - 0.0351420008562923*G0_0_0_3_9 + 0.00191998477712797*G0_0_0_4_0 - 0.0101232101232118*G0_0_0_4_1 - 0.0265867465867509*G0_0_0_4_2 + 0.00450406736121072*G0_0_0_4_3 - 0.00972741544170199*G0_0_0_4_4 - 0.00679891537034515*G0_0_0_4_5 - 0.00921364349935916*G0_0_0_4_6 + 0.00119880119880141*G0_0_0_4_7 + 0.00484658198943986*G0_0_0_4_8 + 0.0804566861709856*G0_0_0_4_9 + 0.0444526901669835*G0_0_0_5_0 - 0.00478759335902276*G0_0_0_5_1 + 0.0201474715760464*G0_0_0_5_2 + 0.0088711288711303*G0_0_0_5_3 - 0.00679891537034515*G0_0_0_5_4 - 0.135533038390204*G0_0_0_5_5 - 0.103114028828332*G0_0_0_5_6 - 0.0194034536891712*G0_0_0_5_7 + 0.013323819038107*G0_0_0_5_8 - 0.0672013700585244*G0_0_0_5_9 - 0.00282003710575199*G0_0_0_6_0 - 0.00568383996955523*G0_0_0_6_1 - 0.000586080586080737*G0_0_0_6_2 + 0.0160125588697043*G0_0_0_6_3 - 0.00921364349935916*G0_0_0_6_4 - 0.103114028828332*G0_0_0_6_5 - 0.361695447409795*G0_0_0_6_6 + 0.00607963465106423*G0_0_0_6_7 + 0.0119880119880139*G0_0_0_6_8 + 0.0348337376908867*G0_0_0_6_9 + 0.00813472242043809*G0_0_0_7_0 - 0.00471909043337697*G0_0_0_7_1 - 0.0023728652300085*G0_0_0_7_2 + 0.00130155558727*G0_0_0_7_3 + 0.00119880119880141*G0_0_0_7_4 - 0.0194034536891712*G0_0_0_7_5 + 0.00607963465106423*G0_0_0_7_6 - 0.0682974168688574*G0_0_0_7_7 + 0.0199686028257491*G0_0_0_7_8 - 0.0527130012844389*G0_0_0_7_9 - 0.00638218923933319*G0_0_0_8_0 + 0.00439750725465087*G0_0_0_8_1 - 0.0019618476761337*G0_0_0_8_2 - 0.00614813757670985*G0_0_0_8_3 + 0.00484658198943986*G0_0_0_8_4 + 0.013323819038107*G0_0_0_8_5 + 0.0119880119880139*G0_0_0_8_6 + 0.0199686028257491*G0_0_0_8_7 - 0.0483630655059306*G0_0_0_8_8 - 0.0422320536606321*G0_0_0_8_9 + 0.0135179106607701*G0_0_0_9_0 + 0.0108462965605841*G0_0_0_9_1 - 0.0222862851434317*G0_0_0_9_2 - 0.0351420008562923*G0_0_0_9_3 + 0.0804566861709856*G0_0_0_9_4 - 0.0672013700585244*G0_0_0_9_5 + 0.0348337376908867*G0_0_0_9_6 - 0.0527130012844389*G0_0_0_9_7 - 0.0422320536606321*G0_0_0_9_8 + 0.250309690309733*G0_0_0_9_9 + 0.0013759785188359*G0_0_1_0_1 - 0.00137597851883588*G0_0_1_0_2 - 0.00396746111031891*G0_0_1_0_3 + 0.00396746111031894*G0_0_1_0_4 + 0.0117653774796653*G0_0_1_0_5 - 0.00557157128585803*G0_0_1_0_6 - 0.0117653774796652*G0_0_1_0_7 + 0.00557157128585794*G0_0_1_0_8 + 0.0013759785188359*G0_0_1_1_0 + 0.0140126540126561*G0_0_1_1_1 + 0.0238485324199649*G0_0_1_1_3 - 0.00994053565482298*G0_0_1_1_4 + 0.00460682174967966*G0_0_1_1_5 - 0.00278007706579182*G0_0_1_1_6 - 0.0143780029494339*G0_0_1_1_7 + 0.020746872175447*G0_0_1_1_8 + 0.0260767803624991*G0_0_1_1_9 - 0.00137597851883588*G0_0_1_2_0 - 0.0140126540126561*G0_0_1_2_2 + 0.00994053565482296*G0_0_1_2_3 - 0.0238485324199648*G0_0_1_2_4 + 0.0143780029494339*G0_0_1_2_5 - 0.0207468721754471*G0_0_1_2_6 - 0.00460682174967967*G0_0_1_2_7 + 0.00278007706579182*G0_0_1_2_8 - 0.026076780362499*G0_0_1_2_9 - 0.00396746111031891*G0_0_1_3_0 + 0.0238485324199649*G0_0_1_3_1 + 0.00994053565482296*G0_0_1_3_2 - 0.00688454402740174*G0_0_1_3_3 - 0.000959040959041064*G0_0_1_3_5 + 0.00834023119737537*G0_0_1_3_6 + 0.0119023833309568*G0_0_1_3_7 - 0.00356215213358126*G0_0_1_3_8 - 0.102035107749411*G0_0_1_3_9 + 0.00396746111031894*G0_0_1_4_0 - 0.00994053565482298*G0_0_1_4_1 - 0.0238485324199648*G0_0_1_4_2 + 0.00688454402740297*G0_0_1_4_4 - 0.0119023833309569*G0_0_1_4_5 + 0.00356215213358142*G0_0_1_4_6 + 0.000959040959041097*G0_0_1_4_7 - 0.00834023119737549*G0_0_1_4_8 + 0.102035107749411*G0_0_1_4_9 + 0.0117653774796653*G0_0_1_5_0 + 0.00460682174967966*G0_0_1_5_1 + 0.0143780029494339*G0_0_1_5_2 - 0.000959040959041067*G0_0_1_5_3 - 0.0119023833309569*G0_0_1_5_4 + 0.273155416012605*G0_0_1_5_5 - 0.0156871699728869*G0_0_1_5_6 - 0.013820465249039*G0_0_1_5_8 + 0.027640930498078*G0_0_1_5_9 - 0.00557157128585803*G0_0_1_6_0 - 0.00278007706579183*G0_0_1_6_1 - 0.0207468721754471*G0_0_1_6_2 + 0.00834023119737538*G0_0_1_6_3 + 0.00356215213358142*G0_0_1_6_4 - 0.0156871699728869*G0_0_1_6_5 - 0.224997859283612*G0_0_1_6_6 + 0.013820465249039*G0_0_1_6_7 + 0.0615498786927463*G0_0_1_6_9 - 0.0117653774796652*G0_0_1_7_0 - 0.0143780029494339*G0_0_1_7_1 - 0.00460682174967967*G0_0_1_7_2 + 0.0119023833309568*G0_0_1_7_3 + 0.000959040959041097*G0_0_1_7_4 + 0.0138204652490389*G0_0_1_7_6 - 0.273155416012605*G0_0_1_7_7 + 0.015687169972887*G0_0_1_7_8 - 0.0276409304980782*G0_0_1_7_9 + 0.00557157128585794*G0_0_1_8_0 + 0.020746872175447*G0_0_1_8_1 + 0.00278007706579182*G0_0_1_8_2 - 0.00356215213358126*G0_0_1_8_3 - 0.00834023119737549*G0_0_1_8_4 - 0.013820465249039*G0_0_1_8_5 + 0.015687169972887*G0_0_1_8_7 + 0.224997859283612*G0_0_1_8_8 - 0.061549878692746*G0_0_1_8_9 + 0.0260767803624991*G0_0_1_9_1 - 0.026076780362499*G0_0_1_9_2 - 0.102035107749411*G0_0_1_9_3 + 0.102035107749411*G0_0_1_9_4 + 0.027640930498078*G0_0_1_9_5 + 0.0615498786927463*G0_0_1_9_6 - 0.0276409304980782*G0_0_1_9_7 - 0.061549878692746*G0_0_1_9_8 + 0.000804063661206675*G0_1_0_0_1 - 0.000804063661206644*G0_1_0_0_2 + 0.000856286570572459*G0_1_0_0_3 - 0.000856286570572425*G0_1_0_0_4 - 0.0014480757337903*G0_1_0_0_5 + 0.000395794681509067*G0_1_0_0_6 + 0.0014480757337902*G0_1_0_0_7 - 0.000395794681508989*G0_1_0_0_8 + 0.000804063661206675*G0_1_0_1_0 + 0.0228926628926669*G0_1_0_1_1 + 0.02565434565435*G0_1_0_1_3 - 0.0132553161124612*G0_1_0_1_4 + 0.000582274867989244*G0_1_0_1_5 + 0.00306550592264933*G0_1_0_1_6 - 0.00318538604252954*G0_1_0_1_7 + 0.00951048951049131*G0_1_0_1_8 + 0.00972741544170285*G0_1_0_1_9 - 0.000804063661206644*G0_1_0_2_0 - 0.0228926628926664*G0_1_0_2_2 + 0.0132553161124611*G0_1_0_2_3 - 0.0256543456543498*G0_1_0_2_4 + 0.00318538604252936*G0_1_0_2_5 - 0.00951048951049098*G0_1_0_2_6 - 0.000582274867989266*G0_1_0_2_7 - 0.00306550592264926*G0_1_0_2_8 - 0.00972741544170276*G0_1_0_2_9 + 0.000856286570572459*G0_1_0_3_0 + 0.02565434565435*G0_1_0_3_1 + 0.0132553161124611*G0_1_0_3_2 + 0.0141801056086803*G0_1_0_3_3 - 0.00215784215784254*G0_1_0_3_5 - 0.00919651776794797*G0_1_0_3_6 - 0.00256885971171741*G0_1_0_3_7 - 0.00662765805623033*G0_1_0_3_8 - 0.0240445269016737*G0_1_0_3_9 - 0.000856286570572424*G0_1_0_4_0 - 0.0132553161124612*G0_1_0_4_1 - 0.0256543456543498*G0_1_0_4_2 - 0.0141801056086789*G0_1_0_4_4 + 0.00256885971171724*G0_1_0_4_5 + 0.00662765805623073*G0_1_0_4_6 + 0.00215784215784255*G0_1_0_4_7 + 0.00919651776794775*G0_1_0_4_8 + 0.0240445269016738*G0_1_0_4_9 - 0.0014480757337903*G0_1_0_5_0 + 0.000582274867989244*G0_1_0_5_1 + 0.00318538604252936*G0_1_0_5_2 - 0.00215784215784254*G0_1_0_5_3 + 0.00256885971171724*G0_1_0_5_4 + 0.0115769944341393*G0_1_0_5_5 + 0.0002226345083488*G0_1_0_5_6 - 0.00174682460396777*G0_1_0_5_8 + 0.00349364920793554*G0_1_0_5_9 + 0.000395794681509067*G0_1_0_6_0 + 0.00306550592264933*G0_1_0_6_1 - 0.00951048951049098*G0_1_0_6_2 - 0.00919651776794797*G0_1_0_6_3 + 0.00662765805623073*G0_1_0_6_4 + 0.0002226345083488*G0_1_0_6_5 + 0.064701013272453*G0_1_0_6_6 + 0.00174682460396777*G0_1_0_6_7 + 0.0475752818610043*G0_1_0_6_9 + 0.0014480757337902*G0_1_0_7_0 - 0.00318538604252954*G0_1_0_7_1 - 0.000582274867989266*G0_1_0_7_2 - 0.00256885971171741*G0_1_0_7_3 + 0.00215784215784255*G0_1_0_7_4 + 0.00174682460396777*G0_1_0_7_6 - 0.0115769944341391*G0_1_0_7_7 - 0.000222634508348959*G0_1_0_7_8 - 0.00349364920793551*G0_1_0_7_9 - 0.00039579468150899*G0_1_0_8_0 + 0.00951048951049131*G0_1_0_8_1 - 0.00306550592264926*G0_1_0_8_2 - 0.00662765805623033*G0_1_0_8_3 + 0.00919651776794775*G0_1_0_8_4 - 0.00174682460396777*G0_1_0_8_5 - 0.000222634508348959*G0_1_0_8_7 - 0.0647010132724518*G0_1_0_8_8 - 0.047575281861004*G0_1_0_8_9 + 0.00972741544170285*G0_1_0_9_1 - 0.00972741544170276*G0_1_0_9_2 - 0.0240445269016737*G0_1_0_9_3 + 0.0240445269016738*G0_1_0_9_4 + 0.00349364920793554*G0_1_0_9_5 + 0.0475752818610043*G0_1_0_9_6 - 0.00349364920793551*G0_1_0_9_7 - 0.047575281861004*G0_1_0_9_8 - 0.0248403448403487*G0_1_1_0_0 - 0.00180433323290495*G0_1_1_0_2 - 0.00191998477712793*G0_1_1_0_3 + 0.000780172208743746*G0_1_1_0_4 - 0.00813472242043797*G0_1_1_0_5 + 0.0063821892393331*G0_1_1_0_6 - 0.0444526901669832*G0_1_1_0_7 + 0.00282003710575186*G0_1_1_0_8 - 0.0135179106607701*G0_1_1_0_9 + 0.012064972064974*G0_1_1_1_1 + 0.000375708947137587*G0_1_1_1_2 + 0.026586746586751*G0_1_1_1_3 - 0.0114095428381162*G0_1_1_1_4 + 0.00237286523000849*G0_1_1_1_5 + 0.00196184767613371*G0_1_1_1_6 - 0.0201474715760464*G0_1_1_1_7 + 0.000586080586080753*G0_1_1_1_8 + 0.0222862851434318*G0_1_1_1_9 - 0.00180433323290495*G0_1_1_2_0 + 0.000375708947137587*G0_1_1_2_1 - 0.0194768194768225*G0_1_1_2_2 + 0.0101232101232118*G0_1_1_2_3 - 0.0191789163217766*G0_1_1_2_4 + 0.00471909043337692*G0_1_1_2_5 - 0.00439750725465082*G0_1_1_2_6 + 0.00478759335902274*G0_1_1_2_7 + 0.00568383996955523*G0_1_1_2_8 - 0.0108462965605841*G0_1_1_2_9 - 0.00191998477712793*G0_1_1_3_0 + 0.026586746586751*G0_1_1_3_1 + 0.0101232101232118*G0_1_1_3_2 + 0.00972741544170333*G0_1_1_3_3 - 0.00450406736121103*G0_1_1_3_4 - 0.00119880119880141*G0_1_1_3_5 - 0.00484658198943991*G0_1_1_3_6 + 0.00679891537034502*G0_1_1_3_7 + 0.00921364349935944*G0_1_1_3_8 - 0.0804566861709854*G0_1_1_3_9 + 0.000780172208743746*G0_1_1_4_0 - 0.0114095428381162*G0_1_1_4_1 - 0.0191789163217766*G0_1_1_4_2 - 0.00450406736121103*G0_1_1_4_3 - 0.0175024975025002*G0_1_1_4_4 - 0.00130155558727007*G0_1_1_4_5 + 0.00614813757670998*G0_1_1_4_6 - 0.00887112887113035*G0_1_1_4_7 - 0.0160125588697045*G0_1_1_4_8 + 0.0351420008562924*G0_1_1_4_9 - 0.00813472242043797*G0_1_1_5_0 + 0.00237286523000849*G0_1_1_5_1 + 0.00471909043337692*G0_1_1_5_2 - 0.00119880119880141*G0_1_1_5_3 - 0.00130155558727007*G0_1_1_5_4 + 0.068297416868857*G0_1_1_5_5 - 0.0199686028257489*G0_1_1_5_6 + 0.0194034536891713*G0_1_1_5_7 - 0.0060796346510643*G0_1_1_5_8 + 0.0527130012844389*G0_1_1_5_9 + 0.0063821892393331*G0_1_1_6_0 + 0.00196184767613371*G0_1_1_6_1 - 0.00439750725465082*G0_1_1_6_2 - 0.00484658198943991*G0_1_1_6_3 + 0.00614813757670998*G0_1_1_6_4 - 0.0199686028257489*G0_1_1_6_5 + 0.0483630655059303*G0_1_1_6_6 - 0.013323819038107*G0_1_1_6_7 - 0.011988011988014*G0_1_1_6_8 + 0.0422320536606321*G0_1_1_6_9 - 0.0444526901669832*G0_1_1_7_0 - 0.0201474715760464*G0_1_1_7_1 + 0.00478759335902274*G0_1_1_7_2 + 0.00679891537034501*G0_1_1_7_3 - 0.00887112887113034*G0_1_1_7_4 + 0.0194034536891713*G0_1_1_7_5 - 0.013323819038107*G0_1_1_7_6 + 0.135533038390205*G0_1_1_7_7 + 0.103114028828332*G0_1_1_7_8 + 0.0672013700585243*G0_1_1_7_9 + 0.00282003710575186*G0_1_1_8_0 + 0.000586080586080752*G0_1_1_8_1 + 0.00568383996955523*G0_1_1_8_2 + 0.00921364349935944*G0_1_1_8_3 - 0.0160125588697045*G0_1_1_8_4 - 0.0060796346510643*G0_1_1_8_5 - 0.011988011988014*G0_1_1_8_6 + 0.103114028828332*G0_1_1_8_7 + 0.361695447409796*G0_1_1_8_8 - 0.0348337376908862*G0_1_1_8_9 - 0.0135179106607701*G0_1_1_9_0 + 0.0222862851434318*G0_1_1_9_1 - 0.0108462965605841*G0_1_1_9_2 - 0.0804566861709854*G0_1_1_9_3 + 0.0351420008562924*G0_1_1_9_4 + 0.0527130012844389*G0_1_1_9_5 + 0.0422320536606321*G0_1_1_9_6 + 0.0672013700585243*G0_1_1_9_7 - 0.0348337376908862*G0_1_1_9_8 - 0.250309690309733*G0_1_1_9_9;
    A[113] = -A[110] + 0.00360133693467096*G0_0_1_0_0 - 0.000318869842679432*G0_0_1_0_1 - 0.00603519936853373*G0_0_1_0_2 + 0.0029744858316292*G0_0_1_0_3 - 0.000823620823620978*G0_0_1_0_4 + 0.00805607091321517*G0_0_1_0_5 - 0.00894882894883057*G0_0_1_0_6 + 0.00490874205160009*G0_0_1_0_7 - 0.00137925566497022*G0_0_1_0_8 - 0.00427952999381648*G0_0_1_0_9 - 0.000318869842679432*G0_0_1_1_0 - 0.00255659684231173*G0_0_1_1_1 - 0.00504261170927924*G0_0_1_1_2 + 0.00676466390752216*G0_0_1_1_3 - 0.00941058941059099*G0_0_1_1_4 + 0.00198499912785661*G0_0_1_1_5 - 0.0262382062382108*G0_0_1_1_6 + 0.000746872175443786*G0_0_1_1_7 + 0.00316064887493501*G0_0_1_1_8 - 0.0195632938490115*G0_0_1_1_9 - 0.00603519936853373*G0_0_1_2_0 - 0.00504261170927924*G0_0_1_2_1 - 0.19658859658863*G0_0_1_2_2 + 0.0241314241314281*G0_0_1_2_3 - 0.056521256521266*G0_0_1_2_4 + 0.0287490287490335*G0_0_1_2_5 - 0.0391164391164456*G0_0_1_2_6 + 0.00057498057498067*G0_0_1_2_7 - 0.00192918192918228*G0_0_1_2_8 + 0.0101232101232119*G0_0_1_2_9 + 0.0029744858316292*G0_0_1_3_0 + 0.00676466390752216*G0_0_1_3_1 + 0.0241314241314281*G0_0_1_3_2 - 0.0173826173826204*G0_0_1_3_3 + 0.0341058941058999*G0_0_1_3_4 - 0.0108691308691327*G0_0_1_3_5 + 0.08557442557444*G0_0_1_3_6 - 0.00206365063507952*G0_0_1_3_7 - 0.0105837020122753*G0_0_1_3_8 + 0.0628171828171934*G0_0_1_3_9 - 0.000823620823620976*G0_0_1_4_0 - 0.009410589410591*G0_0_1_4_1 - 0.056521256521266*G0_0_1_4_2 + 0.0341058941058999*G0_0_1_4_3 + 0.11148851148853*G0_0_1_4_4 + 0.00933066933067096*G0_0_1_4_5 - 0.0949050949051111*G0_0_1_4_6 - 0.00305694305694358*G0_0_1_4_7 + 0.0126473526473548*G0_0_1_4_8 - 0.0490309690309774*G0_0_1_4_9 + 0.00805607091321517*G0_0_1_5_0 + 0.00198499912785661*G0_0_1_5_1 + 0.0287490287490335*G0_0_1_5_2 - 0.0108691308691327*G0_0_1_5_3 + 0.00933066933067094*G0_0_1_5_4 - 0.0551048951049046*G0_0_1_5_5 + 0.0304295704295755*G0_0_1_5_6 - 0.0060396746111042*G0_0_1_5_7 + 0.000904809476238202*G0_0_1_5_8 + 0.0110289710289729*G0_0_1_5_9 - 0.00894882894883057*G0_0_1_6_0 - 0.0262382062382108*G0_0_1_6_1 - 0.0391164391164456*G0_0_1_6_2 + 0.08557442557444*G0_0_1_6_3 - 0.094905094905111*G0_0_1_6_4 + 0.0304295704295755*G0_0_1_6_5 - 0.491108891108975*G0_0_1_6_6 + 0.00513486513486594*G0_0_1_6_7 + 0.0388211788211854*G0_0_1_6_8 - 0.201518481518516*G0_0_1_6_9 + 0.00490874205160009*G0_0_1_7_0 + 0.000746872175443786*G0_0_1_7_1 + 0.00057498057498067*G0_0_1_7_2 - 0.00206365063507952*G0_0_1_7_3 - 0.00305694305694358*G0_0_1_7_4 - 0.0060396746111042*G0_0_1_7_5 + 0.00513486513486594*G0_0_1_7_6 + 0.0164349935778536*G0_0_1_7_7 - 0.00131582703011292*G0_0_1_7_8 + 0.00256885971171732*G0_0_1_7_9 - 0.00137925566497022*G0_0_1_8_0 + 0.00316064887493501*G0_0_1_8_1 - 0.00192918192918228*G0_0_1_8_2 - 0.0105837020122753*G0_0_1_8_3 + 0.0126473526473548*G0_0_1_8_4 + 0.000904809476238202*G0_0_1_8_5 + 0.0388211788211854*G0_0_1_8_6 - 0.00131582703011292*G0_0_1_8_7 - 0.000416726131012232*G0_0_1_8_8 + 0.0333951762523247*G0_0_1_8_9 - 0.00427952999381648*G0_0_1_9_0 - 0.0195632938490115*G0_0_1_9_1 + 0.0101232101232119*G0_0_1_9_2 + 0.0628171828171934*G0_0_1_9_3 - 0.0490309690309774*G0_0_1_9_4 + 0.0110289710289729*G0_0_1_9_5 - 0.201518481518516*G0_0_1_9_6 + 0.00256885971171732*G0_0_1_9_7 + 0.0333951762523247*G0_0_1_9_8 - 0.205714285714321*G0_0_1_9_9 - 0.0925010791677615*G0_1_1_0_0 - 0.00738964738964866*G0_1_1_0_1 - 0.00776556776556909*G0_1_1_0_2 + 0.00585446299732118*G0_1_1_0_3 - 0.00668918383204213*G0_1_1_0_4 - 0.0213545184973792*G0_1_1_0_5 - 0.00338296624010977*G0_1_1_0_6 - 0.0659359687931227*G0_1_1_0_7 + 0.0316968745540227*G0_1_1_0_8 - 0.011015651015653*G0_1_1_0_9 - 0.00738964738964866*G0_1_1_1_0 - 0.0029050314764607*G0_1_1_1_1 - 0.00621304621304727*G0_1_1_1_2 + 0.00866562009419295*G0_1_1_1_3 - 0.011337234194379*G0_1_1_1_4 - 0.0051821194678346*G0_1_1_1_5 - 0.0199159570588176*G0_1_1_1_6 - 0.0138388595531476*G0_1_1_1_7 + 0.0128544471401635*G0_1_1_1_8 - 0.0243870415299029*G0_1_1_1_9 - 0.00776556776556909*G0_1_1_2_0 - 0.00621304621304727*G0_1_1_2_1 - 0.18263711597048*G0_1_1_2_2 + 0.0260517260517304*G0_1_1_2_3 - 0.0535686535686626*G0_1_1_2_4 + 0.0125097125097146*G0_1_1_2_5 - 0.0384060384060448*G0_1_1_2_6 - 0.00991452991453157*G0_1_1_2_7 + 0.00236652236652275*G0_1_1_2_8 - 0.00126540126540145*G0_1_1_2_9 + 0.00585446299732118*G0_1_1_3_0 + 0.00866562009419295*G0_1_1_3_1 + 0.0260517260517304*G0_1_1_3_2 - 0.0180676466390783*G0_1_1_3_3 + 0.04279720279721*G0_1_1_3_4 - 0.010175538746969*G0_1_1_3_5 + 0.0780819180819312*G0_1_1_3_6 + 0.000770657913515266*G0_1_1_3_7 - 0.0120051377194255*G0_1_1_3_8 + 0.071619808762678*G0_1_1_3_9 - 0.00668918383204213*G0_1_1_4_0 - 0.011337234194379*G0_1_1_4_1 - 0.0535686535686626*G0_1_1_4_2 + 0.04279720279721*G0_1_1_4_3 + 0.0455544455544532*G0_1_1_4_4 + 0.0384015984016049*G0_1_1_4_5 - 0.116483516483536*G0_1_1_4_6 + 0.0157385471671212*G0_1_1_4_7 + 0.0112344798059103*G0_1_1_4_8 - 0.0730069930070054*G0_1_1_4_9 - 0.0213545184973792*G0_1_1_5_0 - 0.0051821194678346*G0_1_1_5_1 + 0.0125097125097146*G0_1_1_5_2 - 0.010175538746969*G0_1_1_5_3 + 0.0384015984016049*G0_1_1_5_4 - 0.195450264021725*G0_1_1_5_5 + 0.118241758241778*G0_1_1_5_6 - 0.0819580419580556*G0_1_1_5_7 + 0.0338804053089824*G0_1_1_5_8 - 0.0347138575710062*G0_1_1_5_9 - 0.00338296624010977*G0_1_1_6_0 - 0.0199159570588176*G0_1_1_6_1 - 0.0384060384060448*G0_1_1_6_2 + 0.0780819180819312*G0_1_1_6_3 - 0.116483516483536*G0_1_1_6_4 + 0.118241758241778*G0_1_1_6_5 - 0.422777222777295*G0_1_1_6_6 + 0.0480776366490732*G0_1_1_6_7 + 0.0171571285857029*G0_1_1_6_8 - 0.152367632367658*G0_1_1_6_9 - 0.0659359687931227*G0_1_1_7_0 - 0.0138388595531476*G0_1_1_7_1 - 0.00991452991453157*G0_1_1_7_2 + 0.000770657913515266*G0_1_1_7_3 + 0.0157385471671212*G0_1_1_7_4 - 0.0819580419580556*G0_1_1_7_5 + 0.0480776366490732*G0_1_1_7_6 - 0.276877408306026*G0_1_1_7_7 + 0.0557042957043052*G0_1_1_7_8 - 0.0631083202511881*G0_1_1_7_9 + 0.0316968745540227*G0_1_1_8_0 + 0.0128544471401635*G0_1_1_8_1 + 0.00236652236652275*G0_1_1_8_2 - 0.0120051377194255*G0_1_1_8_3 + 0.0112344798059103*G0_1_1_8_4 + 0.0338804053089824*G0_1_1_8_5 + 0.0171571285857029*G0_1_1_8_6 + 0.0557042957043052*G0_1_1_8_7 - 0.0460054231482883*G0_1_1_8_8 + 0.0506921649778879*G0_1_1_8_9 - 0.011015651015653*G0_1_1_9_0 - 0.0243870415299029*G0_1_1_9_1 - 0.00126540126540145*G0_1_1_9_2 + 0.071619808762678*G0_1_1_9_3 - 0.0730069930070054*G0_1_1_9_4 - 0.0347138575710062*G0_1_1_9_5 - 0.152367632367658*G0_1_1_9_6 - 0.0631083202511881*G0_1_1_9_7 + 0.0506921649778879*G0_1_1_9_8 - 0.315866990152758*G0_1_1_9_9;
    A[97] = A[113] - 0.0113269446602799*G0_0_0_0_0 - 0.00171433504766867*G0_0_0_0_1 + 0.00614482519244528*G0_0_0_0_2 + 0.000993292421864013*G0_0_0_0_3 + 0.00251938537652866*G0_0_0_0_4 - 0.0265461522604424*G0_0_0_0_5 - 0.00475080475080565*G0_0_0_0_6 - 0.00955552384123973*G0_0_0_0_7 + 0.00696319553462528*G0_0_0_0_8 - 0.0137386423100732*G0_0_0_0_9 - 0.00171433504766867*G0_0_0_1_0 + 0.000180983038125925*G0_0_0_1_1 + 0.010342391294774*G0_0_0_1_2 - 0.00161996733425332*G0_0_0_1_3 + 0.0100445586159889*G0_0_0_1_4 + 0.00220731649303117*G0_0_0_1_5 - 0.00645449788307045*G0_0_0_1_6 - 0.00213627642199106*G0_0_0_1_7 + 0.00153433867719608*G0_0_0_1_8 - 0.00493221064649721*G0_0_0_1_9 + 0.00614482519244528*G0_0_0_2_0 + 0.010342391294774*G0_0_0_2_1 + 0.204565804565839*G0_0_0_2_2 - 0.0486180486180567*G0_0_0_2_3 + 0.114179154179173*G0_0_0_2_4 - 0.0415850815850884*G0_0_0_2_5 + 0.0557842157842248*G0_0_0_2_6 - 0.006618143761002*G0_0_0_2_7 + 0.000490937633794874*G0_0_0_2_8 + 0.0116150516150535*G0_0_0_2_9 + 0.000993292421864013*G0_0_0_3_0 - 0.00161996733425332*G0_0_0_3_1 - 0.0486180486180567*G0_0_0_3_2 + 0.00525189096617747*G0_0_0_3_3 - 0.0548594262880069*G0_0_0_3_4 - 0.00656486370772197*G0_0_0_3_5 + 0.0228913943199697*G0_0_0_3_6 + 0.000548023405166363*G0_0_0_3_7 - 0.0026031111745402*G0_0_0_3_8 + 0.0137005851291589*G0_0_0_3_9 + 0.00251938537652866*G0_0_0_4_0 + 0.0100445586159889*G0_0_0_4_1 + 0.114179154179173*G0_0_0_4_2 - 0.0548594262880069*G0_0_0_4_3 + 0.109650349650368*G0_0_0_4_4 - 0.00403025545882749*G0_0_0_4_5 - 0.0188611388611422*G0_0_0_4_6 + 0.00438418724133085*G0_0_0_4_7 + 0.00205508776937384*G0_0_0_4_8 - 0.0267846439275057*G0_0_0_4_9 - 0.0265461522604424*G0_0_0_5_0 + 0.00220731649303117*G0_0_0_5_1 - 0.0415850815850884*G0_0_0_5_2 - 0.00656486370772197*G0_0_0_5_3 - 0.00403025545882749*G0_0_0_5_4 + 0.0460339660339737*G0_0_0_5_5 + 0.105049236477826*G0_0_0_5_6 - 0.0202882831454294*G0_0_0_5_7 - 0.00309404880833506*G0_0_0_5_8 + 0.0474040245468897*G0_0_0_5_9 - 0.00475080475080565*G0_0_0_6_0 - 0.00645449788307045*G0_0_0_6_1 + 0.0557842157842248*G0_0_0_6_2 + 0.0228913943199697*G0_0_0_6_3 - 0.0188611388611422*G0_0_0_6_4 + 0.105049236477826*G0_0_0_6_5 - 0.297302697302748*G0_0_0_6_6 + 0.0233823319537644*G0_0_0_6_7 + 0.0071813900385341*G0_0_0_6_8 - 0.0806279434850999*G0_0_0_6_9 - 0.00955552384123973*G0_0_0_7_0 - 0.00213627642199106*G0_0_0_7_1 - 0.006618143761002*G0_0_0_7_2 + 0.000548023405166363*G0_0_0_7_3 + 0.00438418724133085*G0_0_0_7_4 - 0.0202882831454294*G0_0_0_7_5 + 0.0233823319537644*G0_0_0_7_6 - 0.0331097473954672*G0_0_0_7_7 + 0.010269730269732*G0_0_0_7_8 - 0.00554873697730934*G0_0_0_7_9 + 0.00696319553462528*G0_0_0_8_0 + 0.00153433867719608*G0_0_0_8_1 + 0.000490937633794875*G0_0_0_8_2 - 0.0026031111745402*G0_0_0_8_3 + 0.00205508776937384*G0_0_0_8_4 - 0.00309404880833506*G0_0_0_8_5 + 0.0071813900385341*G0_0_0_8_6 + 0.010269730269732*G0_0_0_8_7 - 0.00358498644212991*G0_0_0_8_8 + 0.0106864564007439*G0_0_0_8_9 - 0.0137386423100732*G0_0_0_9_0 - 0.00493221064649721*G0_0_0_9_1 + 0.0116150516150535*G0_0_0_9_2 + 0.0137005851291589*G0_0_0_9_3 - 0.0267846439275057*G0_0_0_9_4 + 0.0474040245468897*G0_0_0_9_5 - 0.0806279434850999*G0_0_0_9_6 - 0.00554873697730935*G0_0_0_9_7 + 0.0106864564007439*G0_0_0_9_8 - 0.0764492650207065*G0_0_0_9_9 + 0.0183855650522346*G0_0_1_0_0 + 0.00165753118134098*G0_0_1_0_1 + 0.00614482519244528*G0_0_1_0_2 - 0.0026601969459117*G0_0_1_0_3 + 0.0032805289948153*G0_0_1_0_4 - 0.0177016634159523*G0_0_1_0_5 + 0.00317270031555808*G0_0_1_0_6 + 0.0136212993355871*G0_0_1_0_7 - 0.00551955980527494*G0_0_1_0_8 + 0.0038742210170788*G0_0_1_0_9 + 0.00165753118134098*G0_0_1_1_0 + 0.000180983038125945*G0_0_1_1_1 + 0.00697052506576435*G0_0_1_1_2 - 0.00334776334776392*G0_0_1_1_3 + 0.0140101168672621*G0_0_1_1_4 - 0.0224841824841863*G0_0_1_1_5 + 0.0182370010941471*G0_0_1_1_6 - 0.0061018346732643*G0_0_1_1_7 + 0.00326213469070669*G0_0_1_1_8 - 0.00493221064649717*G0_0_1_1_9 + 0.00614482519244528*G0_0_1_2_0 + 0.00697052506576435*G0_0_1_2_1 + 0.174853294853324*G0_0_1_2_2 - 0.0361352932781565*G0_0_1_2_3 + 0.0910023310023464*G0_0_1_2_4 - 0.0495085866514521*G0_0_1_2_5 + 0.0469397269397347*G0_0_1_2_6 - 0.00737928737928864*G0_0_1_2_7 + 0.00414442700157058*G0_0_1_2_8 - 0.00599781171209848*G0_0_1_2_9 - 0.0026601969459117*G0_0_1_3_0 - 0.00334776334776392*G0_0_1_3_1 - 0.0361352932781565*G0_0_1_3_2 + 0.0150706436420747*G0_0_1_3_3 - 0.0625089196517874*G0_0_1_3_4 + 0.0359526188097676*G0_0_1_3_5 - 0.0511831026116827*G0_0_1_3_6 + 0.0115084915084934*G0_0_1_3_7 - 0.00260311117454017*G0_0_1_3_8 - 0.00822035107749537*G0_0_1_3_9 + 0.0032805289948153*G0_0_1_4_0 + 0.0140101168672621*G0_0_1_4_1 + 0.0910023310023464*G0_0_1_4_2 - 0.0625089196517874*G0_0_1_4_3 + 0.0941915227629675*G0_0_1_4_4 - 0.00631368631368737*G0_0_1_4_5 + 0.0574967889253701*G0_0_1_4_6 + 0.00438418724133087*G0_0_1_4_7 - 0.00890538033395328*G0_0_1_4_8 + 0.0306208077636701*G0_0_1_4_9 - 0.0177016634159523*G0_0_1_5_0 - 0.0224841824841863*G0_0_1_5_1 - 0.0495085866514521*G0_0_1_5_2 + 0.0359526188097676*G0_0_1_5_3 - 0.00631368631368737*G0_0_1_5_4 - 0.477807906379415*G0_0_1_5_5 + 0.105049236477826*G0_0_1_5_6 - 0.0966462109319415*G0_0_1_5_7 + 0.0709804481233172*G0_0_1_5_8 - 0.153583559297871*G0_0_1_5_9 + 0.00317270031555808*G0_0_1_6_0 + 0.0182370010941471*G0_0_1_6_1 + 0.0469397269397347*G0_0_1_6_2 - 0.0511831026116827*G0_0_1_6_3 + 0.0574967889253701*G0_0_1_6_4 + 0.105049236477826*G0_0_1_6_5 + 0.226539175110642*G0_0_1_6_6 + 0.0256657628086243*G0_0_1_6_7 - 0.0353360924789556*G0_0_1_6_8 + 0.120359640359661*G0_0_1_6_9 + 0.0136212993355871*G0_0_1_7_0 - 0.0061018346732643*G0_0_1_7_1 - 0.00737928737928864*G0_0_1_7_2 + 0.0115084915084934*G0_0_1_7_3 + 0.00438418724133087*G0_0_1_7_4 - 0.0966462109319415*G0_0_1_7_5 + 0.0256657628086243*G0_0_1_7_6 - 0.0176509205080668*G0_0_1_7_7 + 0.0179192236335125*G0_0_1_7_8 - 0.0629541886684851*G0_0_1_7_9 - 0.00551955980527494*G0_0_1_8_0 + 0.0032621346907067*G0_0_1_8_1 + 0.00414442700157058*G0_0_1_8_2 - 0.00260311117454017*G0_0_1_8_3 - 0.00890538033395328*G0_0_1_8_4 + 0.0709804481233172*G0_0_1_8_5 - 0.0353360924789556*G0_0_1_8_6 + 0.0179192236335125*G0_0_1_8_7 - 0.0134037391180271*G0_0_1_8_8 + 0.0326073926073982*G0_0_1_8_9 + 0.0038742210170788*G0_0_1_9_0 - 0.00493221064649717*G0_0_1_9_1 - 0.00599781171209848*G0_0_1_9_2 - 0.00822035107749537*G0_0_1_9_3 + 0.0306208077636701*G0_0_1_9_4 - 0.153583559297871*G0_0_1_9_5 + 0.120359640359661*G0_0_1_9_6 - 0.0629541886684851*G0_0_1_9_7 + 0.0326073926073982*G0_0_1_9_8 - 0.0764492650207066*G0_0_1_9_9 + 0.0196090329423699*G0_1_0_0_0 + 0.000216221168602167*G0_1_0_0_1 + 0.00614482519244528*G0_1_0_0_2 + 0.0023062651634084*G0_1_0_0_3 - 0.00330526616240959*G0_1_0_0_4 + 0.0126058068915234*G0_1_0_0_5 - 0.0273732616589807*G0_1_0_0_6 + 0.012386978101266*G0_1_0_0_7 - 0.00324500895929528*G0_1_0_0_8 - 0.00943056943057102*G0_1_0_0_9 + 0.000216221168602167*G0_1_0_1_0 + 0.000180983038125914*G0_1_0_1_1 + 0.00841183507850316*G0_1_0_1_2 + 0.000108462965605837*G0_1_0_1_3 + 0.00484848484848567*G0_1_0_1_4 + 0.00830027115741543*G0_1_0_1_5 - 0.0125474525474547*G0_1_0_1_6 + 0.00305979734551217*G0_1_0_1_7 - 0.000194091622663102*G0_1_0_1_8 - 0.0049322106464972*G0_1_0_1_9 + 0.00614482519244528*G0_1_0_2_0 + 0.00841183507850316*G0_1_0_2_1 + 0.173629826963189*G0_1_0_2_2 - 0.0384098441241362*G0_1_0_2_3 + 0.0922366522366676*G0_1_0_2_4 - 0.0189626246769134*G0_1_0_2_5 + 0.0166322566322591*G0_1_0_2_6 - 0.000793492222063768*G0_1_0_2_7 - 0.000822035107749524*G0_1_0_2_8 + 0.00730697873555137*G0_1_0_2_9 + 0.0023062651634084*G0_1_0_3_0 + 0.000108462965605838*G0_1_0_3_1 - 0.0384098441241362*G0_1_0_3_2 - 0.00271728271728326*G0_1_0_3_3 - 0.0328071928071983*G0_1_0_3_4 - 0.0176737548166149*G0_1_0_3_5 + 0.0411702583131224*G0_1_0_3_6 - 0.00339089481946681*G0_1_0_3_7 - 0.00260311117454019*G0_1_0_3_8 + 0.0215784215784252*G0_1_0_3_9 - 0.00330526616240959*G0_1_0_4_0 + 0.00484848484848567*G0_1_0_4_1 + 0.0922366522366676*G0_1_0_4_2 - 0.0328071928071983*G0_1_0_4_3 + 0.0575310403881929*G0_1_0_4_4 + 0.0134436991579872*G0_1_0_4_5 - 0.0546139574711096*G0_1_0_4_6 + 0.00438418724133083*G0_1_0_4_7 + 0.00599400599400701*G0_1_0_4_8 - 0.0488083345226285*G0_1_0_4_9 + 0.0126058068915234*G0_1_0_5_0 + 0.00830027115741543*G0_1_0_5_1 - 0.0189626246769134*G0_1_0_5_2 - 0.0176737548166149*G0_1_0_5_3 + 0.0134436991579872*G0_1_0_5_4 + 0.078572855715726*G0_1_0_5_5 + 0.105049236477826*G0_1_0_5_6 + 0.0154645354645381*G0_1_0_5_7 - 0.0213729128014878*G0_1_0_5_8 + 0.0710375338946887*G0_1_0_5_9 - 0.0273732616589807*G0_1_0_6_0 - 0.0125474525474547*G0_1_0_6_1 + 0.0166322566322591*G0_1_0_6_2 + 0.0411702583131224*G0_1_0_6_3 - 0.0546139574711096*G0_1_0_6_4 + 0.105049236477826*G0_1_0_6_5 - 0.3298415869845*G0_1_0_6_6 + 0.00590837733694971*G0_1_0_6_7 + 0.0182902811474271*G0_1_0_6_8 - 0.104261452832899*G0_1_0_6_9 + 0.012386978101266*G0_1_0_7_0 + 0.00305979734551217*G0_1_0_7_1 - 0.000793492222063768*G0_1_0_7_2 - 0.00339089481946681*G0_1_0_7_3 + 0.00438418724133083*G0_1_0_7_4 + 0.0154645354645381*G0_1_0_7_5 + 0.00590837733694971*G0_1_0_7_6 + 0.0190095618667082*G0_1_0_7_7 - 0.0117825032110767*G0_1_0_7_8 + 0.0164749536178136*G0_1_0_7_9 - 0.00324500895929528*G0_1_0_8_0 - 0.000194091622663102*G0_1_0_8_1 - 0.000822035107749524*G0_1_0_8_2 - 0.00260311117454019*G0_1_0_8_3 + 0.00599400599400701*G0_1_0_8_4 - 0.0213729128014878*G0_1_0_8_5 + 0.0182902811474271*G0_1_0_8_6 - 0.0117825032110767*G0_1_0_8_7 + 0.00438418724133086*G0_1_0_8_8 + 0.00280861995147754*G0_1_0_8_9 - 0.00943056943057102*G0_1_0_9_0 - 0.0049322106464972*G0_1_0_9_1 + 0.00730697873555137*G0_1_0_9_2 + 0.0215784215784252*G0_1_0_9_3 - 0.0488083345226285*G0_1_0_9_4 + 0.0710375338946887*G0_1_0_9_5 - 0.104261452832899*G0_1_0_9_6 + 0.0164749536178136*G0_1_0_9_7 + 0.00280861995147754*G0_1_0_9_8 - 0.0764492650207065*G0_1_0_9_9 - 0.155244261910955*G0_1_1_0_0 - 0.0067543038971622*G0_1_1_0_1 - 0.0018381618381621*G0_1_1_0_3 + 0.00407402121687905*G0_1_1_0_4 - 0.0343339200482115*G0_1_1_0_5 + 0.0221353249924716*G0_1_1_0_6 - 0.0786153529010804*G0_1_1_0_7 + 0.0328902843188613*G0_1_1_0_8 - 0.00343275771847265*G0_1_1_0_9 - 0.0067543038971622*G0_1_1_1_0 + 0.00675430389716218*G0_1_1_1_2 - 0.00315367172510084*G0_1_1_1_3 + 0.01095031952175*G0_1_1_1_4 - 0.0099367299367316*G0_1_1_1_5 + 0.00993672993673164*G0_1_1_1_6 - 0.0109503195217499*G0_1_1_1_7 + 0.00315367172510083*G0_1_1_1_8 + 0.00675430389716218*G0_1_1_2_1 + 0.155244261910955*G0_1_1_2_2 - 0.0328902843188612*G0_1_1_2_3 + 0.0786153529010804*G0_1_1_2_4 - 0.0221353249924715*G0_1_1_2_5 + 0.0343339200482114*G0_1_1_2_6 - 0.00407402121687903*G0_1_1_2_7 + 0.00183816183816215*G0_1_1_2_8 + 0.00343275771847255*G0_1_1_2_9 - 0.0018381618381621*G0_1_1_3_0 - 0.00315367172510084*G0_1_1_3_1 - 0.0328902843188612*G0_1_1_3_2 + 0.0106864564007439*G0_1_1_3_3 - 0.0507264164407107*G0_1_1_3_4 + 0.0176623376623406*G0_1_1_3_5 - 0.0298101898101948*G0_1_1_3_6 + 0.00551448551448648*G0_1_1_3_7 - 0.0110289710289729*G0_1_1_3_9 + 0.00407402121687905*G0_1_1_4_0 + 0.01095031952175*G0_1_1_4_1 + 0.0786153529010804*G0_1_1_4_2 - 0.0507264164407107*G0_1_1_4_3 + 0.0751819608962595*G0_1_1_4_4 - 0.0122220636506371*G0_1_1_4_5 + 0.042032253460832*G0_1_1_4_6 - 0.00551448551448643*G0_1_1_4_8 + 0.0141458541458566*G0_1_1_4_9 - 0.0343339200482115*G0_1_1_5_0 - 0.0099367299367316*G0_1_1_5_1 - 0.0221353249924715*G0_1_1_5_2 + 0.0176623376623406*G0_1_1_5_3 - 0.0122220636506371*G0_1_1_5_4 - 0.147966319394915*G0_1_1_5_5 - 0.0420322534608319*G0_1_1_5_7 + 0.0298101898101948*G0_1_1_5_8 - 0.0493221064649719*G0_1_1_5_9 + 0.0221353249924716*G0_1_1_6_0 + 0.00993672993673164*G0_1_1_6_1 + 0.0343339200482114*G0_1_1_6_2 - 0.0298101898101948*G0_1_1_6_3 + 0.042032253460832*G0_1_1_6_4 + 0.147966319394916*G0_1_1_6_6 + 0.0122220636506371*G0_1_1_6_7 - 0.0176623376623406*G0_1_1_6_8 + 0.049322106464972*G0_1_1_6_9 - 0.0786153529010804*G0_1_1_7_0 - 0.0109503195217499*G0_1_1_7_1 - 0.00407402121687903*G0_1_1_7_2 + 0.00551448551448648*G0_1_1_7_3 - 0.0420322534608319*G0_1_1_7_5 + 0.0122220636506371*G0_1_1_7_6 - 0.0751819608962592*G0_1_1_7_7 + 0.0507264164407107*G0_1_1_7_8 - 0.0141458541458566*G0_1_1_7_9 + 0.0328902843188613*G0_1_1_8_0 + 0.00315367172510083*G0_1_1_8_1 + 0.00183816183816215*G0_1_1_8_2 - 0.00551448551448643*G0_1_1_8_4 + 0.0298101898101948*G0_1_1_8_5 - 0.0176623376623406*G0_1_1_8_6 + 0.0507264164407107*G0_1_1_8_7 - 0.0106864564007439*G0_1_1_8_8 + 0.0110289710289729*G0_1_1_8_9 - 0.00343275771847266*G0_1_1_9_0 + 0.00343275771847255*G0_1_1_9_2 - 0.0110289710289729*G0_1_1_9_3 + 0.0141458541458566*G0_1_1_9_4 - 0.0493221064649719*G0_1_1_9_5 + 0.049322106464972*G0_1_1_9_6 - 0.0141458541458566*G0_1_1_9_7 + 0.0110289710289729*G0_1_1_9_8;
    A[111] = A[97] + 0.000749867416534628*G0_0_1_0_0 - 0.000741974075307513*G0_0_1_0_1 + 0.00266005599338979*G0_0_1_0_2 + 0.00133200133200156*G0_0_1_0_3 - 0.000319680319680389*G0_0_1_0_4 + 0.0198912198912235*G0_0_1_0_5 - 0.0143412143412168*G0_0_1_0_6 - 0.00435120435120481*G0_0_1_0_7 + 0.00244200244200274*G0_0_1_0_8 - 0.00719280719280836*G0_0_1_0_9 - 0.000741974075307513*G0_0_1_1_0 + 0.00203309917595665*G0_0_1_1_1 + 0.000699335937431286*G0_0_1_1_2 - 0.00323739752311236*G0_0_1_1_3 - 0.000598132026703566*G0_0_1_1_4 + 0.0279244564958898*G0_0_1_1_5 - 0.00285999714571191*G0_0_1_1_6 + 0.0085634999920729*G0_0_1_1_7 - 0.00669362383648214*G0_0_1_1_8 + 0.0181494695780441*G0_0_1_1_9 + 0.00266005599338979*G0_0_1_2_0 + 0.000699335937431286*G0_0_1_2_1 - 0.000473600473600774*G0_0_1_2_2 + 0.000167451596023091*G0_0_1_2_3 - 0.00311688311688374*G0_0_1_2_4 + 0.0162047476333219*G0_0_1_2_5 - 0.0104162504162522*G0_0_1_2_6 + 0.00626611483754449*G0_0_1_2_7 - 0.00363446077731854*G0_0_1_2_8 + 0.00611198325484144*G0_0_1_2_9 + 0.00133200133200156*G0_0_1_3_0 - 0.00323739752311236*G0_0_1_3_1 + 0.000167451596023091*G0_0_1_3_2 + 0.00349364920793545*G0_0_1_3_3 + 0.000770657913515251*G0_0_1_3_4 - 0.0396175253318176*G0_0_1_3_5 - 0.0125303268160432*G0_0_1_3_7 + 0.0101612673041261*G0_0_1_3_8 - 0.0293877551020457*G0_0_1_3_9 - 0.000319680319680389*G0_0_1_4_0 - 0.000598132026703562*G0_0_1_4_1 - 0.00311688311688374*G0_0_1_4_2 + 0.000770657913515251*G0_0_1_4_3 - 0.00565149136577806*G0_0_1_4_4 - 0.00757528186099746*G0_0_1_4_5 + 0.0075296132439002*G0_0_1_4_6 - 0.0046524903667769*G0_0_1_4_7 + 0.00236905951191707*G0_0_1_4_8 - 0.00318538604252948*G0_0_1_4_9 + 0.0198912198912235*G0_0_1_5_0 + 0.0279244564958898*G0_0_1_5_1 + 0.0162047476333219*G0_0_1_5_2 - 0.0396175253318176*G0_0_1_5_3 - 0.00757528186099746*G0_0_1_5_4 + 0.624815184815289*G0_0_1_5_5 - 0.065934065934077*G0_0_1_5_6 + 0.11964035964038*G0_0_1_5_7 - 0.0923076923077079*G0_0_1_5_8 + 0.206193806193841*G0_0_1_5_9 - 0.0143412143412168*G0_0_1_6_0 - 0.00285999714571191*G0_0_1_6_1 - 0.0104162504162522*G0_0_1_6_2 + 0.00752961324390019*G0_0_1_6_4 - 0.065934065934077*G0_0_1_6_5 + 0.0684344227201486*G0_0_1_6_6 - 0.027332667332672*G0_0_1_6_7 + 0.014008848294565*G0_0_1_6_8 - 0.0184272869987187*G0_0_1_6_9 - 0.00435120435120481*G0_0_1_7_0 + 0.00856349999207289*G0_0_1_7_1 + 0.00626611483754449*G0_0_1_7_2 - 0.0125303268160432*G0_0_1_7_3 - 0.0046524903667769*G0_0_1_7_4 + 0.11964035964038*G0_0_1_7_5 - 0.027332667332672*G0_0_1_7_6 + 0.0310089910089968*G0_0_1_7_7 - 0.028931068931074*G0_0_1_7_8 + 0.0762437562437692*G0_0_1_7_9 + 0.00244200244200274*G0_0_1_8_0 - 0.00669362383648214*G0_0_1_8_1 - 0.00363446077731854*G0_0_1_8_2 + 0.0101612673041261*G0_0_1_8_3 + 0.00236905951191707*G0_0_1_8_4 - 0.0923076923077079*G0_0_1_8_5 + 0.014008848294565*G0_0_1_8_6 - 0.028931068931074*G0_0_1_8_7 + 0.0212815755672935*G0_0_1_8_8 - 0.0591865277579664*G0_0_1_8_9 - 0.00719280719280836*G0_0_1_9_0 + 0.0181494695780441*G0_0_1_9_1 + 0.00611198325484144*G0_0_1_9_2 - 0.0293877551020457*G0_0_1_9_3 - 0.00318538604252949*G0_0_1_9_4 + 0.206193806193841*G0_0_1_9_5 - 0.0184272869987187*G0_0_1_9_6 + 0.0762437562437692*G0_0_1_9_7 - 0.0591865277579664*G0_0_1_9_8 + 0.170161267304153*G0_0_1_9_9 - 0.000749867416534631*G0_1_0_0_0 + 0.000741974075307513*G0_1_0_0_1 - 0.00266005599338979*G0_1_0_0_2 - 0.00133200133200156*G0_1_0_0_3 + 0.000319680319680389*G0_1_0_0_4 - 0.0198912198912235*G0_1_0_0_5 + 0.0143412143412168*G0_1_0_0_6 + 0.00435120435120481*G0_1_0_0_7 - 0.00244200244200273*G0_1_0_0_8 + 0.00719280719280836*G0_1_0_0_9 + 0.000741974075307513*G0_1_0_1_0 - 0.00203309917595665*G0_1_0_1_1 - 0.000699335937431284*G0_1_0_1_2 + 0.00323739752311236*G0_1_0_1_3 + 0.000598132026703562*G0_1_0_1_4 - 0.0279244564958898*G0_1_0_1_5 + 0.00285999714571191*G0_1_0_1_6 - 0.0085634999920729*G0_1_0_1_7 + 0.00669362383648214*G0_1_0_1_8 - 0.0181494695780441*G0_1_0_1_9 - 0.00266005599338979*G0_1_0_2_0 - 0.000699335937431284*G0_1_0_2_1 + 0.000473600473600774*G0_1_0_2_2 - 0.000167451596023094*G0_1_0_2_3 + 0.00311688311688373*G0_1_0_2_4 - 0.0162047476333219*G0_1_0_2_5 + 0.0104162504162522*G0_1_0_2_6 - 0.00626611483754449*G0_1_0_2_7 + 0.00363446077731854*G0_1_0_2_8 - 0.00611198325484144*G0_1_0_2_9 - 0.00133200133200156*G0_1_0_3_0 + 0.00323739752311236*G0_1_0_3_1 - 0.000167451596023091*G0_1_0_3_2 - 0.00349364920793545*G0_1_0_3_3 - 0.000770657913515251*G0_1_0_3_4 + 0.0396175253318176*G0_1_0_3_5 + 0.0125303268160432*G0_1_0_3_7 - 0.0101612673041261*G0_1_0_3_8 + 0.0293877551020457*G0_1_0_3_9 + 0.000319680319680389*G0_1_0_4_0 + 0.000598132026703566*G0_1_0_4_1 + 0.00311688311688374*G0_1_0_4_2 - 0.000770657913515251*G0_1_0_4_3 + 0.00565149136577808*G0_1_0_4_4 + 0.00757528186099747*G0_1_0_4_5 - 0.00752961324390021*G0_1_0_4_6 + 0.00465249036677689*G0_1_0_4_7 - 0.00236905951191707*G0_1_0_4_8 + 0.00318538604252948*G0_1_0_4_9 - 0.0198912198912235*G0_1_0_5_0 - 0.0279244564958898*G0_1_0_5_1 - 0.0162047476333219*G0_1_0_5_2 + 0.0396175253318176*G0_1_0_5_3 + 0.00757528186099747*G0_1_0_5_4 - 0.624815184815289*G0_1_0_5_5 + 0.065934065934077*G0_1_0_5_6 - 0.11964035964038*G0_1_0_5_7 + 0.0923076923077079*G0_1_0_5_8 - 0.206193806193841*G0_1_0_5_9 + 0.0143412143412168*G0_1_0_6_0 + 0.00285999714571191*G0_1_0_6_1 + 0.0104162504162522*G0_1_0_6_2 - 0.00752961324390019*G0_1_0_6_4 + 0.065934065934077*G0_1_0_6_5 - 0.0684344227201486*G0_1_0_6_6 + 0.027332667332672*G0_1_0_6_7 - 0.014008848294565*G0_1_0_6_8 + 0.0184272869987187*G0_1_0_6_9 + 0.00435120435120481*G0_1_0_7_0 - 0.00856349999207289*G0_1_0_7_1 - 0.00626611483754449*G0_1_0_7_2 + 0.0125303268160432*G0_1_0_7_3 + 0.00465249036677689*G0_1_0_7_4 - 0.11964035964038*G0_1_0_7_5 + 0.027332667332672*G0_1_0_7_6 - 0.0310089910089968*G0_1_0_7_7 + 0.028931068931074*G0_1_0_7_8 - 0.0762437562437692*G0_1_0_7_9 - 0.00244200244200273*G0_1_0_8_0 + 0.00669362383648214*G0_1_0_8_1 + 0.00363446077731854*G0_1_0_8_2 - 0.0101612673041261*G0_1_0_8_3 - 0.00236905951191707*G0_1_0_8_4 + 0.0923076923077079*G0_1_0_8_5 - 0.014008848294565*G0_1_0_8_6 + 0.028931068931074*G0_1_0_8_7 - 0.0212815755672935*G0_1_0_8_8 + 0.0591865277579664*G0_1_0_8_9 + 0.00719280719280836*G0_1_0_9_0 - 0.0181494695780441*G0_1_0_9_1 - 0.00611198325484144*G0_1_0_9_2 + 0.0293877551020457*G0_1_0_9_3 + 0.00318538604252948*G0_1_0_9_4 - 0.206193806193841*G0_1_0_9_5 + 0.0184272869987187*G0_1_0_9_6 - 0.0762437562437692*G0_1_0_9_7 + 0.0591865277579664*G0_1_0_9_8 - 0.170161267304153*G0_1_0_9_9;
    A[72] = A[202] + 0.00536352536352632*G0_0_0_0_0 + 0.000421166135451921*G0_0_0_0_2 + 0.00400742115027902*G0_0_0_0_3 + 0.00760382474668326*G0_0_0_0_4 + 0.0252737738452067*G0_0_0_0_5 + 0.00730317301745989*G0_0_0_0_6 + 0.00373721516578724*G0_0_0_0_7 - 0.00166309880595623*G0_0_0_0_8 + 0.00267161410018601*G0_0_0_0_9 - 0.00536352536352634*G0_0_0_1_1 - 0.000421166135451907*G0_0_0_1_2 - 0.0252737738452067*G0_0_0_1_3 - 0.00730317301745988*G0_0_0_1_4 - 0.00400742115027899*G0_0_0_1_5 - 0.00760382474668321*G0_0_0_1_6 + 0.00166309880595626*G0_0_0_1_7 - 0.00373721516578728*G0_0_0_1_8 - 0.002671614100186*G0_0_0_1_9 + 0.000421166135451921*G0_0_0_2_0 - 0.000421166135451907*G0_0_0_2_1 - 0.00873792873793029*G0_0_0_2_3 - 0.0260006660006702*G0_0_0_2_4 + 0.00873792873793022*G0_0_0_2_5 + 0.0260006660006703*G0_0_0_2_6 - 0.000411017553874763*G0_0_0_2_7 + 0.000411017553874765*G0_0_0_2_8 + 0.00400742115027902*G0_0_0_3_0 - 0.0252737738452067*G0_0_0_3_1 - 0.00873792873793029*G0_0_0_3_2 + 0.153035535892705*G0_0_0_3_3 + 0.107618096189543*G0_0_0_3_4 + 0.0228114742400495*G0_0_0_3_6 - 0.0120222634508369*G0_0_0_3_7 + 0.0132553161124612*G0_0_0_3_8 + 0.0320593692022319*G0_0_0_3_9 + 0.00760382474668326*G0_0_0_4_0 - 0.00730317301745988*G0_0_0_4_1 - 0.0260006660006702*G0_0_0_4_2 + 0.107618096189543*G0_0_0_4_3 + 0.351968031968093*G0_0_0_4_4 - 0.0228114742400496*G0_0_0_4_5 - 0.0107892107892127*G0_0_0_4_7 - 0.00123305266162431*G0_0_0_4_8 + 0.0456229484800993*G0_0_0_4_9 + 0.0252737738452067*G0_0_0_5_0 - 0.00400742115027898*G0_0_0_5_1 + 0.00873792873793022*G0_0_0_5_2 - 0.0228114742400496*G0_0_0_5_4 - 0.153035535892705*G0_0_0_5_5 - 0.107618096189543*G0_0_0_5_6 - 0.0132553161124612*G0_0_0_5_7 + 0.0120222634508369*G0_0_0_5_8 - 0.0320593692022318*G0_0_0_5_9 + 0.00730317301745989*G0_0_0_6_0 - 0.0076038247466832*G0_0_0_6_1 + 0.0260006660006703*G0_0_0_6_2 + 0.0228114742400495*G0_0_0_6_3 - 0.107618096189543*G0_0_0_6_5 - 0.351968031968092*G0_0_0_6_6 + 0.00123305266162425*G0_0_0_6_7 + 0.0107892107892126*G0_0_0_6_8 - 0.045622948480099*G0_0_0_6_9 + 0.00373721516578724*G0_0_0_7_0 + 0.00166309880595626*G0_0_0_7_1 - 0.000411017553874762*G0_0_0_7_2 - 0.0120222634508369*G0_0_0_7_3 - 0.0107892107892127*G0_0_0_7_4 - 0.0132553161124612*G0_0_0_7_5 + 0.00123305266162425*G0_0_0_7_6 - 0.0199343513629261*G0_0_0_7_7 - 0.0104809476238066*G0_0_0_7_9 - 0.00166309880595623*G0_0_0_8_0 - 0.00373721516578728*G0_0_0_8_1 + 0.000411017553874766*G0_0_0_8_2 + 0.0132553161124612*G0_0_0_8_3 - 0.00123305266162431*G0_0_0_8_4 + 0.0120222634508369*G0_0_0_8_5 + 0.0107892107892126*G0_0_0_8_6 + 0.0199343513629261*G0_0_0_8_8 + 0.0104809476238065*G0_0_0_8_9 + 0.00267161410018601*G0_0_0_9_0 - 0.002671614100186*G0_0_0_9_1 + 0.0320593692022319*G0_0_0_9_3 + 0.0456229484800993*G0_0_0_9_4 - 0.0320593692022318*G0_0_0_9_5 - 0.045622948480099*G0_0_0_9_6 - 0.0104809476238066*G0_0_0_9_7 + 0.0104809476238065*G0_0_0_9_8 - 0.0054641654641663*G0_0_1_0_0 + 0.000375708947137578*G0_0_1_0_1 - 0.000428354714069075*G0_0_1_0_2 + 0.00290376290376342*G0_0_1_0_3 + 0.00939441510870252*G0_0_1_0_4 + 0.0163493649207963*G0_0_1_0_5 - 0.00965891251605704*G0_0_1_0_6 + 0.00466961609818838*G0_0_1_0_7 + 0.000182674468388728*G0_0_1_0_8 + 0.015230483801915*G0_0_1_0_9 + 0.000375708947137578*G0_0_1_1_0 - 0.00194768194768239*G0_0_1_1_1 - 0.00142143570715023*G0_0_1_1_2 - 0.0201607915893665*G0_0_1_1_3 - 0.00576946862661235*G0_0_1_1_4 + 0.00474192474192553*G0_0_1_1_5 - 0.00223395651967119*G0_0_1_1_6 - 0.00146900718329309*G0_0_1_1_7 + 0.00273821416678595*G0_0_1_1_8 - 0.00379049521906733*G0_0_1_1_9 - 0.000428354714069075*G0_0_1_2_0 - 0.00142143570715023*G0_0_1_2_1 - 0.0248403448403488*G0_0_1_2_2 - 0.0027515341801062*G0_0_1_2_3 - 0.032687312687318*G0_0_1_2_4 + 0.0119537605251911*G0_0_1_2_5 - 0.0199000999001032*G0_0_1_2_6 - 0.00318728890157512*G0_0_1_2_7 + 0.00204747633319095*G0_0_1_2_8 - 0.0135179106607701*G0_0_1_2_9 + 0.00290376290376342*G0_0_1_3_0 - 0.0201607915893665*G0_0_1_3_1 - 0.0027515341801062*G0_0_1_3_2 + 0.136697588126183*G0_0_1_3_3 + 0.0874268588554449*G0_0_1_3_4 - 0.0119880119880139*G0_0_1_3_5 + 0.00774083059797472*G0_0_1_3_6 - 0.00767232767232894*G0_0_1_3_7 + 0.0127757956329406*G0_0_1_3_8 + 0.0267161410018599*G0_0_1_3_9 + 0.00939441510870252*G0_0_1_4_0 - 0.00576946862661235*G0_0_1_4_1 - 0.032687312687318*G0_0_1_4_2 + 0.087426858855445*G0_0_1_4_3 + 0.408688454402811*G0_0_1_4_4 - 0.0271442842871462*G0_0_1_4_5 + 0.0194034536891715*G0_0_1_4_6 - 0.00983016983017161*G0_0_1_4_7 - 0.00510346796061166*G0_0_1_4_8 + 0.0948423005566025*G0_0_1_4_9 + 0.0163493649207963*G0_0_1_5_0 + 0.00474192474192553*G0_0_1_5_1 + 0.0119537605251911*G0_0_1_5_2 - 0.0119880119880139*G0_0_1_5_3 - 0.0271442842871462*G0_0_1_5_4 + 0.273360924789542*G0_0_1_5_5 - 0.0042814328528622*G0_0_1_5_6 + 0.00258598544312882*G0_0_1_5_7 - 0.0131868131868154*G0_0_1_5_8 - 0.0193178250321139*G0_0_1_5_9 - 0.00965891251605704*G0_0_1_6_0 - 0.00223395651967119*G0_0_1_6_1 - 0.0199000999001032*G0_0_1_6_2 + 0.00774083059797472*G0_0_1_6_3 + 0.0194034536891715*G0_0_1_6_4 - 0.00428143285286221*G0_0_1_6_5 - 0.204857999143749*G0_0_1_6_6 + 0.0106008277436866*G0_0_1_6_7 - 0.000239760239760288*G0_0_1_6_8 + 0.0250720707863607*G0_0_1_6_9 + 0.00466961609818838*G0_0_1_7_0 - 0.00146900718329309*G0_0_1_7_1 - 0.00318728890157512*G0_0_1_7_2 - 0.00767232767232894*G0_0_1_7_3 - 0.00983016983017161*G0_0_1_7_4 + 0.00258598544312881*G0_0_1_7_5 + 0.0106008277436866*G0_0_1_7_6 - 0.024387041529902*G0_0_1_7_7 - 0.00450406736121093*G0_0_1_7_8 - 0.0668931068931181*G0_0_1_7_9 + 0.000182674468388727*G0_0_1_8_0 + 0.00273821416678595*G0_0_1_8_1 + 0.00204747633319095*G0_0_1_8_2 + 0.0127757956329406*G0_0_1_8_3 - 0.00510346796061166*G0_0_1_8_4 - 0.0131868131868154*G0_0_1_8_5 - 0.000239760239760289*G0_0_1_8_6 - 0.00450406736121093*G0_0_1_8_7 + 0.0166119594691051*G0_0_1_8_8 + 0.0215784215784253*G0_0_1_8_9 + 0.015230483801915*G0_0_1_9_0 - 0.00379049521906733*G0_0_1_9_1 - 0.0135179106607701*G0_0_1_9_2 + 0.0267161410018599*G0_0_1_9_3 + 0.0948423005566025*G0_0_1_9_4 - 0.0193178250321139*G0_0_1_9_5 + 0.0250720707863607*G0_0_1_9_6 - 0.0668931068931181*G0_0_1_9_7 + 0.0215784215784253*G0_0_1_9_8 - 0.250309690309732*G0_0_1_9_9 + 0.00341584341584399*G0_1_0_0_0 + 0.000375708947137579*G0_1_0_0_1 - 0.00100026957169832*G0_1_0_0_2 + 0.00874934589220461*G0_1_0_0_3 + 0.00536986822701204*G0_1_0_0_4 + 0.00511298225584021*G0_1_0_0_5 + 0.00153370439084755*G0_1_0_0_6 + 0.00647542933257327*G0_1_0_0_7 - 0.00313210598924934*G0_1_0_0_8 - 0.0011188811188813*G0_1_0_0_9 + 0.000375708947137579*G0_1_0_1_0 - 0.0108276908276929*G0_1_0_1_1 - 0.000849520849520983*G0_1_0_1_2 - 0.00892440892441043*G0_1_0_1_3 - 0.0169620855335169*G0_1_0_1_4 - 0.00110365824651561*G0_1_0_1_5 + 0.00179059036201923*G0_1_0_1_6 + 0.00184577327434501*G0_1_0_1_7 + 0.000932400932401127*G0_1_0_1_8 + 0.0125588697017289*G0_1_0_1_9 - 0.00100026957169832*G0_1_0_2_0 - 0.000849520849520983*G0_1_0_2_1 - 0.0248403448403487*G0_1_0_2_2 + 0.00321583178726081*G0_1_0_2_3 - 0.0459007659007735*G0_1_0_2_4 + 0.00598639455782408*G0_1_0_2_5 - 0.00668664668664771*G0_1_0_2_6 + 0.00163645877931618*G0_1_0_2_7 - 0.00277627134770037*G0_1_0_2_8 - 0.0135179106607701*G0_1_0_2_9 + 0.00874934589220461*G0_1_0_3_0 - 0.00892440892441043*G0_1_0_3_1 + 0.00321583178726081*G0_1_0_3_2 + 0.426396460682248*G0_1_0_3_3 + 0.103336663336681*G0_1_0_3_4 - 0.011988011988014*G0_1_0_3_5 - 0.00433281004709645*G0_1_0_3_6 - 0.0252090766376525*G0_1_0_3_7 + 0.0158413015555901*G0_1_0_3_8 + 0.0127415441701182*G0_1_0_3_9 + 0.00536986822701204*G0_1_0_4_0 - 0.0169620855335169*G0_1_0_4_1 - 0.0459007659007735*G0_1_0_4_2 + 0.103336663336681*G0_1_0_4_3 + 0.147110032824344*G0_1_0_4_4 - 0.0150706436420748*G0_1_0_4_5 + 0.0194034536891713*G0_1_0_4_6 - 0.0110289710289729*G0_1_0_4_7 + 0.00936777508206231*G0_1_0_4_8 + 0.0706950192664598*G0_1_0_4_9 + 0.00511298225584021*G0_1_0_5_0 - 0.00110365824651561*G0_1_0_5_1 + 0.00598639455782408*G0_1_0_5_2 - 0.011988011988014*G0_1_0_5_3 - 0.0150706436420748*G0_1_0_5_4 - 0.0163379477665228*G0_1_0_5_5 - 0.0201912373340979*G0_1_0_5_6 - 0.000479520479520692*G0_1_0_5_7 + 0.00434993577850803*G0_1_0_5_8 - 0.00534322820037211*G0_1_0_5_9 + 0.00153370439084755*G0_1_0_6_0 + 0.00179059036201923*G0_1_0_6_1 - 0.00668664668664771*G0_1_0_6_2 - 0.00433281004709645*G0_1_0_6_3 + 0.0194034536891713*G0_1_0_6_4 - 0.0201912373340979*G0_1_0_6_5 + 0.0567204224347171*G0_1_0_6_6 - 0.00387041529898733*G0_1_0_6_7 + 0.000959040959041109*G0_1_0_6_8 + 0.0492193520765031*G0_1_0_6_9 + 0.00647542933257327*G0_1_0_7_0 + 0.00184577327434501*G0_1_0_7_1 + 0.00163645877931618*G0_1_0_7_2 - 0.0252090766376525*G0_1_0_7_3 - 0.0110289710289729*G0_1_0_7_4 - 0.000479520479520693*G0_1_0_7_5 - 0.00387041529898733*G0_1_0_7_6 - 0.00332239189382104*G0_1_0_7_7 - 0.00450406736121112*G0_1_0_7_8 + 0.0110974739546186*G0_1_0_7_9 - 0.00313210598924934*G0_1_0_8_0 + 0.000932400932401126*G0_1_0_8_1 - 0.00277627134770037*G0_1_0_8_2 + 0.0158413015555901*G0_1_0_8_3 + 0.00936777508206231*G0_1_0_8_4 + 0.00434993577850803*G0_1_0_8_5 + 0.000959040959041109*G0_1_0_8_6 - 0.00450406736121112*G0_1_0_8_7 - 0.00445269016697592*G0_1_0_8_8 - 0.0564121592693114*G0_1_0_8_9 - 0.0011188811188813*G0_1_0_9_0 + 0.0125588697017289*G0_1_0_9_1 - 0.0135179106607701*G0_1_0_9_2 + 0.0127415441701182*G0_1_0_9_3 + 0.0706950192664598*G0_1_0_9_4 - 0.00534322820037211*G0_1_0_9_5 + 0.0492193520765031*G0_1_0_9_6 + 0.0110974739546186*G0_1_0_9_7 - 0.0564121592693114*G0_1_0_9_8 - 0.250309690309732*G0_1_0_9_9 - 0.0194768194768223*G0_1_1_0_0 + 0.000375708947137613*G0_1_1_0_1 - 0.00180433323290495*G0_1_1_0_2 + 0.00568383996955531*G0_1_1_0_3 + 0.00478759335902278*G0_1_1_0_4 - 0.00439750725465074*G0_1_1_0_5 + 0.00471909043337688*G0_1_1_0_6 - 0.0191789163217764*G0_1_1_0_7 + 0.0101232101232117*G0_1_1_0_8 - 0.0108462965605841*G0_1_1_0_9 + 0.000375708947137613*G0_1_1_1_0 + 0.0120649720649741*G0_1_1_1_1 + 0.000586080586080688*G0_1_1_1_3 - 0.0201474715760464*G0_1_1_1_4 + 0.00196184767613372*G0_1_1_1_5 + 0.00237286523000849*G0_1_1_1_6 - 0.0114095428381162*G0_1_1_1_7 + 0.0265867465867511*G0_1_1_1_8 + 0.0222862851434318*G0_1_1_1_9 - 0.00180433323290495*G0_1_1_2_0 - 0.0248403448403487*G0_1_1_2_2 + 0.00282003710575178*G0_1_1_2_3 - 0.0444526901669832*G0_1_1_2_4 + 0.00638218923933314*G0_1_1_2_5 - 0.00813472242043804*G0_1_1_2_6 + 0.000780172208743786*G0_1_1_2_7 - 0.00191998477712794*G0_1_1_2_8 - 0.01351791066077*G0_1_1_2_9 + 0.00568383996955531*G0_1_1_3_0 + 0.000586080586080691*G0_1_1_3_1 + 0.00282003710575178*G0_1_1_3_2 + 0.361695447409795*G0_1_1_3_3 + 0.103114028828332*G0_1_1_3_4 - 0.011988011988014*G0_1_1_3_5 - 0.00607963465106421*G0_1_1_3_6 - 0.0160125588697045*G0_1_1_3_7 + 0.0092136434993595*G0_1_1_3_8 - 0.034833737690886*G0_1_1_3_9 + 0.00478759335902278*G0_1_1_4_0 - 0.0201474715760464*G0_1_1_4_1 - 0.0444526901669832*G0_1_1_4_2 + 0.103114028828332*G0_1_1_4_3 + 0.135533038390205*G0_1_1_4_4 - 0.013323819038107*G0_1_1_4_5 + 0.0194034536891713*G0_1_1_4_6 - 0.00887112887113041*G0_1_1_4_7 + 0.00679891537034502*G0_1_1_4_8 + 0.0672013700585243*G0_1_1_4_9 - 0.00439750725465074*G0_1_1_5_0 + 0.00196184767613372*G0_1_1_5_1 + 0.00638218923933314*G0_1_1_5_2 - 0.011988011988014*G0_1_1_5_3 - 0.013323819038107*G0_1_1_5_4 + 0.0483630655059309*G0_1_1_5_5 - 0.019968602825749*G0_1_1_5_6 + 0.00614813757671014*G0_1_1_5_7 - 0.00484658198944*G0_1_1_5_8 + 0.0422320536606323*G0_1_1_5_9 + 0.00471909043337688*G0_1_1_6_0 + 0.00237286523000849*G0_1_1_6_1 - 0.00813472242043804*G0_1_1_6_2 - 0.00607963465106421*G0_1_1_6_3 + 0.0194034536891713*G0_1_1_6_4 - 0.019968602825749*G0_1_1_6_5 + 0.0682974168688565*G0_1_1_6_6 - 0.00130155558727015*G0_1_1_6_7 - 0.0011988011988014*G0_1_1_6_8 + 0.0527130012844386*G0_1_1_6_9 - 0.0191789163217764*G0_1_1_7_0 - 0.0114095428381162*G0_1_1_7_1 + 0.000780172208743786*G0_1_1_7_2 - 0.0160125588697045*G0_1_1_7_3 - 0.00887112887113041*G0_1_1_7_4 + 0.00614813757671014*G0_1_1_7_5 - 0.00130155558727015*G0_1_1_7_6 - 0.0175024975024994*G0_1_1_7_7 - 0.00450406736121128*G0_1_1_7_8 + 0.0351420008562925*G0_1_1_7_9 + 0.0101232101232117*G0_1_1_8_0 + 0.0265867465867511*G0_1_1_8_1 - 0.00191998477712794*G0_1_1_8_2 + 0.0092136434993595*G0_1_1_8_3 + 0.00679891537034502*G0_1_1_8_4 - 0.00484658198944*G0_1_1_8_5 - 0.0011988011988014*G0_1_1_8_6 - 0.00450406736121128*G0_1_1_8_7 + 0.0097274154417035*G0_1_1_8_8 - 0.0804566861709853*G0_1_1_8_9 - 0.0108462965605841*G0_1_1_9_0 + 0.0222862851434318*G0_1_1_9_1 - 0.01351791066077*G0_1_1_9_2 - 0.034833737690886*G0_1_1_9_3 + 0.0672013700585243*G0_1_1_9_4 + 0.0422320536606323*G0_1_1_9_5 + 0.0527130012844386*G0_1_1_9_6 + 0.0351420008562925*G0_1_1_9_7 - 0.0804566861709853*G0_1_1_9_8 - 0.250309690309732*G0_1_1_9_9;
    A[42] = -0.00237293570626942*G0_1_0_0_0 + 5.69448188495904e-05*G0_1_0_0_1 - 0.000801544134877597*G0_1_0_0_2 - 0.000287014572728907*G0_1_0_0_3 + 0.000133992991135886*G0_1_0_0_4 + 0.00435770578627795*G0_1_0_0_5 - 0.00223522509236832*G0_1_0_0_6 - 0.00094556237413396*G0_1_0_0_7 - 3.55200355200428e-05*G0_1_0_0_8 + 0.00133390419104728*G0_1_0_0_9 + 5.69448188495904e-05*G0_1_0_1_0 - 0.000273025034929867*G0_1_0_1_1 + 0.000797104130437608*G0_1_0_1_2 + 0.00142825428539736*G0_1_0_1_3 + 0.00222697936983692*G0_1_0_1_4 + 0.00139891854177591*G0_1_0_1_5 - 0.00124462838748573*G0_1_0_1_6 - 0.000216291644863107*G0_1_0_1_7 + 0.00040832183689332*G0_1_0_1_8 + 0.00371628371628434*G0_1_0_1_9 - 0.000801544134877597*G0_1_0_2_0 + 0.000797104130437608*G0_1_0_2_1 - 0.00275280275280327*G0_1_0_2_3 + 0.0109668109668129*G0_1_0_2_4 + 0.00674880674880786*G0_1_0_2_5 - 0.0109668109668128*G0_1_0_2_6 + 0.00049839049839058*G0_1_0_2_7 - 0.000493950493950576*G0_1_0_2_8 - 0.00399600399600465*G0_1_0_2_9 - 0.000287014572728907*G0_1_0_3_0 + 0.00142825428539736*G0_1_0_3_1 - 0.00275280275280327*G0_1_0_3_2 + 0.0103839018124751*G0_1_0_3_3 - 0.0173126873126903*G0_1_0_3_4 - 0.00140430997573875*G0_1_0_3_5 + 0.0032067932067937*G0_1_0_3_6 + 0.000333951762523241*G0_1_0_3_7 - 0.00128871128871148*G0_1_0_3_8 - 0.0118167546738995*G0_1_0_3_9 + 0.000133992991135886*G0_1_0_4_0 + 0.00222697936983692*G0_1_0_4_1 + 0.0109668109668129*G0_1_0_4_2 - 0.0173126873126903*G0_1_0_4_3 + 0.0317482517482574*G0_1_0_4_4 - 0.000929070929071135*G0_1_0_4_5 - 0.00227772227772257*G0_1_0_4_6 - 0.000685029256457951*G0_1_0_4_7 + 0.000954759526188242*G0_1_0_4_8 + 0.0138461538461562*G0_1_0_4_9 + 0.00435770578627795*G0_1_0_5_0 + 0.00139891854177591*G0_1_0_5_1 + 0.00674880674880786*G0_1_0_5_2 - 0.00140430997573875*G0_1_0_5_3 - 0.000929070929071135*G0_1_0_5_4 + 0.0318824033109799*G0_1_0_5_5 - 0.00438561438561515*G0_1_0_5_6 + 0.00674611103182643*G0_1_0_5_7 - 0.00472384758099121*G0_1_0_5_8 + 0.00544598258884059*G0_1_0_5_9 - 0.00223522509236832*G0_1_0_6_0 - 0.00124462838748573*G0_1_0_6_1 - 0.0109668109668128*G0_1_0_6_2 + 0.0032067932067937*G0_1_0_6_3 - 0.00227772227772257*G0_1_0_6_4 - 0.00438561438561515*G0_1_0_6_5 - 0.0271928071928118*G0_1_0_6_6 - 0.00202226345083522*G0_1_0_6_7 + 0.0028714142999862*G0_1_0_6_8 + 0.00557442557442655*G0_1_0_6_9 - 0.00094556237413396*G0_1_0_7_0 - 0.000216291644863107*G0_1_0_7_1 + 0.00049839049839058*G0_1_0_7_2 + 0.000333951762523241*G0_1_0_7_3 - 0.000685029256457951*G0_1_0_7_4 + 0.00674611103182643*G0_1_0_7_5 - 0.00202226345083522*G0_1_0_7_6 + 0.000299700299700355*G0_1_0_7_7 + 0.00102754388468691*G0_1_0_7_8 + 4.28143285286054e-05*G0_1_0_7_9 - 3.55200355200428e-05*G0_1_0_8_0 + 0.000408321836893321*G0_1_0_8_1 - 0.000493950493950576*G0_1_0_8_2 - 0.00128871128871148*G0_1_0_8_3 + 0.000954759526188242*G0_1_0_8_4 - 0.00472384758099121*G0_1_0_8_5 + 0.0028714142999862*G0_1_0_8_6 + 0.00102754388468691*G0_1_0_8_7 + 0.00175538746967354*G0_1_0_8_8 - 0.0130583702012295*G0_1_0_8_9 + 0.00133390419104728*G0_1_0_9_0 + 0.00371628371628434*G0_1_0_9_1 - 0.00399600399600465*G0_1_0_9_2 - 0.0118167546738995*G0_1_0_9_3 + 0.0138461538461562*G0_1_0_9_4 + 0.00544598258884059*G0_1_0_9_5 + 0.00557442557442655*G0_1_0_9_6 + 4.28143285286063e-05*G0_1_0_9_7 - 0.0130583702012295*G0_1_0_9_8 - 0.0267161410018595*G0_1_0_9_9 - 0.00842910176243652*G0_1_1_0_0 - 0.000752492657254688*G0_1_1_0_1 + 0.000395865157769994*G0_1_1_0_2 - 0.000864373721516721*G0_1_1_0_3 + 0.00157842157842186*G0_1_1_0_4 - 0.0022667808382098*G0_1_1_0_5 + 0.00154892726321324*G0_1_1_0_6 - 0.0118146932432667*G0_1_1_0_7 + 0.00621727478870442*G0_1_1_0_8 + 0.000123685837971572*G0_1_1_0_9 - 0.000752492657254688*G0_1_1_1_0 + 0.00152736152736179*G0_1_1_1_1 + 0.00175593366069587*G0_1_1_1_2 + 0.00114805829091562*G0_1_1_1_3 + 0.00362938648652998*G0_1_1_1_4 - 0.000916702345273931*G0_1_1_1_5 + 0.00142286285143453*G0_1_1_1_6 - 0.00327418613132954*G0_1_1_1_7 + 0.00538762824477202*G0_1_1_1_8 + 0.00415584415584486*G0_1_1_1_9 + 0.000395865157769994*G0_1_1_2_0 + 0.00175593366069587*G0_1_1_2_1 + 0.0166006832673528*G0_1_1_2_2 - 0.0073260073260086*G0_1_1_2_3 + 0.0206160506160542*G0_1_1_2_4 - 0.00293928293928344*G0_1_1_2_5 + 0.00437007437007512*G0_1_1_2_6 - 0.00237381665953134*G0_1_1_2_7 - 0.000593216307502118*G0_1_1_2_8 - 0.00254412254412296*G0_1_1_2_9 - 0.000864373721516721*G0_1_1_3_0 + 0.00114805829091562*G0_1_1_3_1 - 0.0073260073260086*G0_1_1_3_2 + 0.0104952190666496*G0_1_1_3_3 - 0.0234950763522233*G0_1_1_3_4 + 0.00310546596260935*G0_1_1_3_5 - 0.00513629227915032*G0_1_1_3_6 + 0.00172541743970345*G0_1_1_3_7 - 0.00263736263736305*G0_1_1_3_8 - 0.0159183673469414*G0_1_1_3_9 + 0.00157842157842186*G0_1_1_4_0 + 0.00362938648652998*G0_1_1_4_1 + 0.0206160506160542*G0_1_1_4_2 - 0.0234950763522233*G0_1_1_4_3 + 0.0461938061938143*G0_1_1_4_4 - 0.0056029684601123*G0_1_1_4_5 + 0.0107392607392626*G0_1_1_4_6 + 0.00162694448408761*G0_1_1_4_7 + 0.000911945197659622*G0_1_1_4_8 + 0.0188383045525935*G0_1_1_4_9 - 0.0022667808382098*G0_1_1_5_0 - 0.000916702345273931*G0_1_1_5_1 - 0.00293928293928344*G0_1_1_5_2 + 0.00310546596260935*G0_1_1_5_3 - 0.0056029684601123*G0_1_1_5_4 + 0.00218923933209686*G0_1_1_5_5 - 0.000610817753675007*G0_1_1_5_6 - 0.00813614956472235*G0_1_1_5_7 + 0.00188240331097505*G0_1_1_5_8 - 0.00413586413586483*G0_1_1_5_9 + 0.00154892726321324*G0_1_1_6_0 + 0.00142286285143453*G0_1_1_6_1 + 0.00437007437007512*G0_1_1_6_2 - 0.00513629227915032*G0_1_1_6_3 + 0.0107392607392626*G0_1_1_6_4 - 0.000610817753675007*G0_1_1_6_5 + 0.00645354645354755*G0_1_1_6_6 + 0.0062537462537473*G0_1_1_6_7 - 0.000810617953475244*G0_1_1_6_8 + 0.0179049521906695*G0_1_1_6_9 - 0.0118146932432667*G0_1_1_7_0 - 0.00327418613132955*G0_1_1_7_1 - 0.00237381665953134*G0_1_1_7_2 + 0.00172541743970345*G0_1_1_7_3 + 0.00162694448408761*G0_1_1_7_4 - 0.00813614956472235*G0_1_1_7_5 + 0.0062537462537473*G0_1_1_7_6 - 0.101121735407467*G0_1_1_7_7 + 0.00439417725132084*G0_1_1_7_8 - 0.0128785500214094*G0_1_1_7_9 + 0.00621727478870442*G0_1_1_8_0 + 0.00538762824477202*G0_1_1_8_1 - 0.000593216307502118*G0_1_1_8_2 - 0.00263736263736305*G0_1_1_8_3 + 0.000911945197659622*G0_1_1_8_4 + 0.00188240331097505*G0_1_1_8_5 - 0.000810617953475244*G0_1_1_8_6 + 0.00439417725132084*G0_1_1_8_7 - 0.0190466676180994*G0_1_1_8_8 - 0.0142914228628538*G0_1_1_8_9 + 0.000123685837971572*G0_1_1_9_0 + 0.00415584415584486*G0_1_1_9_1 - 0.00254412254412296*G0_1_1_9_2 - 0.0159183673469414*G0_1_1_9_3 + 0.0188383045525935*G0_1_1_9_4 - 0.00413586413586484*G0_1_1_9_5 + 0.0179049521906695*G0_1_1_9_6 - 0.0128785500214094*G0_1_1_9_7 - 0.0142914228628538*G0_1_1_9_8 - 0.0203453689168006*G0_1_1_9_9;
    A[107] = -0.000546983880317323*G0_0_1_0_0 + 0.000270961401913831*G0_0_1_0_1 + 0.00480046188379603*G0_0_1_0_2 - 0.00165729112157712*G0_0_1_0_3 + 0.00393675768675837*G0_0_1_0_4 - 0.00153616225044823*G0_0_1_0_5 + 0.000815712065712192*G0_0_1_0_6 - 0.000921657707372161*G0_0_1_0_7 + 0.000340235161663799*G0_0_1_0_8 + 0.00040304933162083*G0_0_1_0_9 + 0.000270961401913831*G0_0_1_1_0 + 0.000965859537288304*G0_0_1_1_1 + 0.00711678753345541*G0_0_1_1_2 - 0.0039672232529382*G0_0_1_1_3 + 0.00970904095904261*G0_0_1_1_4 - 0.00113685917257365*G0_0_1_1_5 + 0.00348720723720783*G0_0_1_1_6 - 0.000204616811759713*G0_0_1_1_7 - 0.000334784263355727*G0_0_1_1_8 + 0.00247906855049755*G0_0_1_1_9 + 0.00480046188379603*G0_0_1_2_0 + 0.00711678753345541*G0_0_1_2_1 + 0.139942464942488*G0_0_1_2_2 - 0.0327852702852757*G0_0_1_2_3 + 0.0754273504273631*G0_0_1_2_4 - 0.0208860583860618*G0_0_1_2_5 + 0.0372433122433184*G0_0_1_2_6 - 0.00115398490398509*G0_0_1_2_7 - 0.000651154401154497*G0_0_1_2_8 + 0.00532800532800619*G0_0_1_2_9 - 0.00165729112157712*G0_0_1_3_0 - 0.0039672232529382*G0_0_1_3_1 - 0.0327852702852757*G0_0_1_3_2 + 0.0172752247752277*G0_0_1_3_3 - 0.0454857642357719*G0_0_1_3_4 + 0.00624375624375728*G0_0_1_3_5 - 0.0145666833166858*G0_0_1_3_6 + 0.00086681175966904*G0_0_1_3_7 + 0.00128478664192973*G0_0_1_3_8 - 0.00917082917083071*G0_0_1_3_9 + 0.00393675768675837*G0_0_1_4_0 + 0.00970904095904261*G0_0_1_4_1 + 0.0754273504273631*G0_0_1_4_2 - 0.0454857642357719*G0_0_1_4_3 + 0.110864135864155*G0_0_1_4_4 - 0.0159153346653373*G0_0_1_4_5 + 0.0304820179820231*G0_0_1_4_6 - 0.00212162837162872*G0_0_1_4_7 - 0.00215159840159876*G0_0_1_4_8 + 0.015846653346656*G0_0_1_4_9 - 0.00153616225044823*G0_0_1_5_0 - 0.00113685917257365*G0_0_1_5_1 - 0.0208860583860618*G0_0_1_5_2 + 0.00624375624375728*G0_0_1_5_3 - 0.0159153346653373*G0_0_1_5_4 + 0.00972277722277885*G0_0_1_5_5 - 0.000980269730269788*G0_0_1_5_6 + 0.00133759098044835*G0_0_1_5_7 - 0.000694484087341352*G0_0_1_5_8 + 0.000179820179820223*G0_0_1_5_9 + 0.000815712065712192*G0_0_1_6_0 + 0.00348720723720783*G0_0_1_6_1 + 0.0372433122433184*G0_0_1_6_2 - 0.0145666833166858*G0_0_1_6_3 + 0.0304820179820231*G0_0_1_6_4 - 0.000980269730269788*G0_0_1_6_5 + 0.0110639360639378*G0_0_1_6_6 - 0.000643106893106993*G0_0_1_6_7 - 0.00220154845154883*G0_0_1_6_8 + 0.0131493506493529*G0_0_1_6_9 - 0.000921657707372161*G0_0_1_7_0 - 0.000204616811759713*G0_0_1_7_1 - 0.00115398490398509*G0_0_1_7_2 + 0.00086681175966904*G0_0_1_7_3 - 0.00212162837162872*G0_0_1_7_4 + 0.00133759098044835*G0_0_1_7_5 - 0.000643106893106993*G0_0_1_7_6 - 0.0027426145283293*G0_0_1_7_7 + 8.0455259026692e-05*G0_0_1_7_8 + 7.70657913515116e-05*G0_0_1_7_9 + 0.000340235161663799*G0_0_1_8_0 - 0.000334784263355727*G0_0_1_8_1 - 0.000651154401154497*G0_0_1_8_2 + 0.00128478664192973*G0_0_1_8_3 - 0.00215159840159876*G0_0_1_8_4 - 0.000694484087341352*G0_0_1_8_5 - 0.00220154845154883*G0_0_1_8_6 + 8.0455259026692e-05*G0_0_1_8_7 - 0.000387826459255041*G0_0_1_8_8 - 0.0031340088482951*G0_0_1_8_9 + 0.00040304933162083*G0_0_1_9_0 + 0.00247906855049755*G0_0_1_9_1 + 0.00532800532800619*G0_0_1_9_2 - 0.00917082917083071*G0_0_1_9_3 + 0.015846653346656*G0_0_1_9_4 + 0.000179820179820223*G0_0_1_9_5 + 0.0131493506493529*G0_0_1_9_6 + 7.70657913515116e-05*G0_0_1_9_7 - 0.0031340088482951*G0_0_1_9_8 + 0.0220279720279758*G0_0_1_9_9 + 0.016843588510258*G0_1_1_0_0 + 0.00134550634550658*G0_1_1_0_1 + 0.0038430088430095*G0_1_1_0_2 - 0.00122552051123502*G0_1_1_0_3 + 0.00276037454608932*G0_1_1_0_4 + 0.00496566925138437*G0_1_1_0_5 - 0.00325057878629363*G0_1_1_0_6 + 0.0123289805432683*G0_1_1_0_7 - 0.00560861757290423*G0_1_1_0_8 + 0.000501998001998106*G0_1_1_0_9 + 0.00134550634550658*G0_1_1_1_0 + 0.00082467796753528*G0_1_1_1_1 + 0.00630628630628737*G0_1_1_1_2 - 0.00342597878312221*G0_1_1_1_3 + 0.0080091337234208*G0_1_1_1_4 + 0.00100831707974582*G0_1_1_1_5 + 0.000902232687947125*G0_1_1_1_6 + 0.00255062397919583*G0_1_1_1_7 - 0.00200398807541696*G0_1_1_1_8 + 0.00253032681604153*G0_1_1_1_9 + 0.0038430088430095*G0_1_1_2_0 + 0.00630628630628737*G0_1_1_2_1 + 0.125027133360488*G0_1_1_2_2 - 0.0287769175269223*G0_1_1_2_3 + 0.0661602286602398*G0_1_1_2_4 - 0.0123794261294282*G0_1_1_2_5 + 0.0233294483294521*G0_1_1_2_6 + 0.0010275835275837*G0_1_1_2_7 - 0.000957930957931108*G0_1_1_2_8 + 0.00467615717615794*G0_1_1_2_9 - 0.00122552051123502*G0_1_1_3_0 - 0.00342597878312221*G0_1_1_3_1 - 0.0287769175269223*G0_1_1_3_2 + 0.0135478806907401*G0_1_1_3_3 - 0.0379545454545519*G0_1_1_3_4 + 0.00225292564578317*G0_1_1_3_5 - 0.00656093906094016*G0_1_1_3_6 - 0.000177679463393792*G0_1_1_3_7 + 0.00115812758669921*G0_1_1_3_8 - 0.00723562152133703*G0_1_1_3_9 + 0.00276037454608932*G0_1_1_4_0 + 0.0080091337234208*G0_1_1_4_1 + 0.0661602286602398*G0_1_1_4_2 - 0.0379545454545519*G0_1_1_4_3 + 0.0972252747252912*G0_1_1_4_4 - 0.0121353646353667*G0_1_1_4_5 + 0.0186963036963068*G0_1_1_4_6 - 0.00375481661196009*G0_1_1_4_7 - 0.000980448123305432*G0_1_1_4_8 + 0.0102422577422595*G0_1_1_4_9 + 0.00496566925138437*G0_1_1_5_0 + 0.00100831707974582*G0_1_1_5_1 - 0.0123794261294282*G0_1_1_5_2 + 0.00225292564578317*G0_1_1_5_3 - 0.0121353646353667*G0_1_1_5_4 + 0.027726202369064*G0_1_1_5_5 - 0.00227272727272756*G0_1_1_5_6 + 0.0138161838161861*G0_1_1_5_7 - 0.00687919223633623*G0_1_1_5_8 + 0.0122523904666782*G0_1_1_5_9 - 0.00325057878629363*G0_1_1_6_0 + 0.000902232687947125*G0_1_1_6_1 + 0.0233294483294521*G0_1_1_6_2 - 0.00656093906094016*G0_1_1_6_3 + 0.0186963036963068*G0_1_1_6_4 - 0.00227272727272756*G0_1_1_6_5 - 0.0187337662337695*G0_1_1_6_6 - 0.00693699157984988*G0_1_1_6_7 + 0.00201066790352537*G0_1_1_6_8 - 0.000906593406593514*G0_1_1_6_9 + 0.0123289805432683*G0_1_1_7_0 + 0.00255062397919583*G0_1_1_7_1 + 0.0010275835275837*G0_1_1_7_2 - 0.000177679463393792*G0_1_1_7_3 - 0.00375481661196009*G0_1_1_7_4 + 0.0138161838161861*G0_1_1_7_5 - 0.00693699157984988*G0_1_1_7_6 + 0.0506953760525274*G0_1_1_7_7 - 0.0102722277722295*G0_1_1_7_8 + 0.0123679891537055*G0_1_1_7_9 - 0.00560861757290423*G0_1_1_8_0 - 0.00200398807541696*G0_1_1_8_1 - 0.000957930957931108*G0_1_1_8_2 + 0.00115812758669921*G0_1_1_8_3 - 0.000980448123305432*G0_1_1_8_4 - 0.00687919223633623*G0_1_1_8_5 + 0.00201066790352537*G0_1_1_8_6 - 0.0102722277722295*G0_1_1_8_7 + 0.00786499215070781*G0_1_1_8_8 - 0.00563008420151373*G0_1_1_8_9 + 0.000501998001998106*G0_1_1_9_0 + 0.00253032681604153*G0_1_1_9_1 + 0.00467615717615794*G0_1_1_9_2 - 0.00723562152133703*G0_1_1_9_3 + 0.0102422577422595*G0_1_1_9_4 + 0.0122523904666782*G0_1_1_9_5 - 0.000906593406593514*G0_1_1_9_6 + 0.0123679891537055*G0_1_1_9_7 - 0.00563008420151373*G0_1_1_9_8 + 0.0352704438418783*G0_1_1_9_9;
    A[7] = A[107] - 0.0149153315820009*G0_0_0_0_0 - 0.000810501227168036*G0_0_0_0_1 - 0.000957453040786538*G0_0_0_0_2 - 0.000306776556776606*G0_0_0_0_3 + 0.00218156843156881*G0_0_0_0_4 - 0.0139138639138663*G0_0_0_0_5 + 0.00850663225663372*G0_0_0_0_6 - 0.00926712176712339*G0_0_0_0_7 + 0.00400835275835347*G0_0_0_0_8 - 0.000651848151848271*G0_0_0_0_9 - 0.000810501227168036*G0_0_0_1_0 - 0.000141181569753039*G0_0_0_1_1 + 0.00107454494359275*G0_0_0_1_2 - 0.00166920381206124*G0_0_0_1_3 + 0.00275524079095555*G0_0_0_1_4 - 0.0025849745492607*G0_0_0_1_5 + 0.00214517625231947*G0_0_0_1_6 - 0.00169990723562181*G0_0_0_1_7 + 0.000541244469815992*G0_0_0_1_8 - 0.000957453040786538*G0_0_0_2_0 + 0.00107454494359275*G0_0_0_2_1 + 0.0173905723905753*G0_0_0_2_2 - 0.00594885273456802*G0_0_0_2_3 + 0.0132506382506405*G0_0_0_2_4 - 0.00406629085200583*G0_0_0_2_5 + 0.00650183150183261*G0_0_0_2_6 - 0.00117638314066905*G0_0_0_2_7 + 0.000431770610342114*G0_0_0_2_8 - 0.000306776556776606*G0_0_0_3_0 - 0.00166920381206124*G0_0_0_3_1 - 0.00594885273456802*G0_0_0_3_2 + 0.00825281860996289*G0_0_0_3_3 - 0.0103526830312562*G0_0_0_3_4 + 0.00421221635507421*G0_0_0_3_5 - 0.0061847081489949*G0_0_0_3_6 + 0.00117115027829333*G0_0_0_3_7 - 0.000126659055230504*G0_0_0_3_8 - 0.00249607535321862*G0_0_0_3_9 + 0.00218156843156881*G0_0_0_4_0 + 0.00275524079095555*G0_0_0_4_1 + 0.0132506382506405*G0_0_0_4_2 - 0.0103526830312562*G0_0_0_4_3 + 0.0534379905808568*G0_0_0_4_4 - 0.00629388468674289*G0_0_0_4_5 + 0.0124785928357378*G0_0_0_4_6 - 0.00163318824033137*G0_0_0_4_7 - 0.00104449122306283*G0_0_0_4_8 + 0.012290923362354*G0_0_0_4_9 - 0.0139138639138663*G0_0_0_5_0 - 0.0025849745492607*G0_0_0_5_1 - 0.00406629085200583*G0_0_0_5_2 + 0.00421221635507421*G0_0_0_5_3 - 0.00629388468674289*G0_0_0_5_4 - 0.0297977022977074*G0_0_0_5_5 - 0.00129245754245776*G0_0_0_5_6 - 0.0117857142857163*G0_0_0_5_7 + 0.00800574425574561*G0_0_0_5_8 - 0.0140559440559465*G0_0_0_5_9 + 0.00850663225663372*G0_0_0_6_0 + 0.00214517625231947*G0_0_0_6_1 + 0.00650183150183261*G0_0_0_6_2 - 0.0061847081489949*G0_0_0_6_3 + 0.0124785928357378*G0_0_0_6_4 - 0.00129245754245776*G0_0_0_6_5 + 0.0180034251462853*G0_0_0_6_6 + 0.00377997002997068*G0_0_0_6_7 - 0.00399083059797413*G0_0_0_6_8 + 0.012072570286858*G0_0_0_6_9 - 0.00926712176712339*G0_0_0_7_0 - 0.00169990723562181*G0_0_0_7_1 - 0.00117638314066905*G0_0_0_7_2 + 0.00117115027829333*G0_0_0_7_3 - 0.00163318824033137*G0_0_0_7_4 - 0.0117857142857163*G0_0_0_7_5 + 0.00377997002997068*G0_0_0_7_6 - 0.0136388611388635*G0_0_0_7_7 + 0.00753121878122008*G0_0_0_7_8 - 0.00560439560439657*G0_0_0_7_9 + 0.00400835275835347*G0_0_0_8_0 + 0.000541244469815992*G0_0_0_8_1 + 0.000431770610342114*G0_0_0_8_2 - 0.000126659055230504*G0_0_0_8_3 - 0.00104449122306283*G0_0_0_8_4 + 0.00800574425574561*G0_0_0_8_5 - 0.00399083059797413*G0_0_0_8_6 + 0.00753121878122008*G0_0_0_8_7 - 0.00372734408448757*G0_0_0_8_8 + 0.0019352076494937*G0_0_0_8_9 - 0.000651848151848271*G0_0_0_9_0 - 0.00249607535321862*G0_0_0_9_3 + 0.012290923362354*G0_0_0_9_4 - 0.0140559440559465*G0_0_0_9_5 + 0.012072570286858*G0_0_0_9_6 - 0.00560439560439657*G0_0_0_9_7 + 0.0019352076494937*G0_0_0_9_8 + 0.0132424718139026*G0_0_0_9_9 + 0.125574117240805*G0_0_1_0_0 + 0.00603532490437356*G0_0_1_0_1 - 0.000957453040786546*G0_0_1_0_2 + 0.000699360163645949*G0_0_1_0_3 - 0.00290917415917465*G0_0_1_0_4 + 0.0248656105799005*G0_0_1_0_5 - 0.0131951381951404*G0_0_1_0_6 + 0.067081886367612*G0_0_1_0_7 - 0.0291171526885862*G0_0_1_0_8 + 0.0042731078445372*G0_0_1_0_9 + 0.00603532490437356*G0_0_1_1_0 - 0.000141181569753073*G0_0_1_1_1 - 0.00577128118794883*G0_0_1_1_2 + 0.00196323517752121*G0_0_1_1_3 - 0.00715841697984676*G0_0_1_1_4 + 0.00203909186052077*G0_0_1_1_5 - 0.002478890157462*G0_0_1_1_6 + 0.00821375053518052*G0_0_1_1_7 - 0.0030911945197665*G0_0_1_1_8 - 0.000957453040786546*G0_0_1_2_0 - 0.00577128118794883*G0_0_1_2_1 - 0.12309887643223*G0_0_1_2_2 + 0.0271766527123715*G0_0_1_2_3 - 0.0630983698840947*G0_0_1_2_4 + 0.0176354795997682*G0_0_1_2_5 - 0.032277642991934*G0_0_1_2_6 + 0.00391435945007438*G0_0_1_2_7 - 0.000574366110080501*G0_0_1_2_8 - 0.00482600732600811*G0_0_1_2_9 + 0.00069936016364595*G0_0_1_3_0 + 0.00196323517752121*G0_0_1_3_1 + 0.0271766527123715*G0_0_1_3_2 - 0.00941023262451993*G0_0_1_3_3 + 0.0352135364635424*G0_0_1_3_4 - 0.00423308834023191*G0_0_1_3_5 + 0.00768749108034952*G0_0_1_3_6 - 0.00184725988297452*G0_0_1_3_7 - 0.000126659055230494*G0_0_1_3_8 + 0.00354074496931701*G0_0_1_3_9 - 0.00290917415917465*G0_0_1_4_0 - 0.00715841697984676*G0_0_1_4_1 - 0.0630983698840947*G0_0_1_4_2 + 0.0352135364635424*G0_0_1_4_3 - 0.0601687598116272*G0_0_1_4_4 + 0.00897834308548744*G0_0_1_4_5 - 0.016665834165837*G0_0_1_4_6 - 0.00163318824033136*G0_0_1_4_7 + 0.00197391893820498*G0_0_1_4_8 - 0.0034786641929505*G0_0_1_4_9 + 0.0248656105799005*G0_0_1_5_0 + 0.00203909186052078*G0_0_1_5_1 + 0.0176354795997682*G0_0_1_5_2 - 0.00423308834023191*G0_0_1_5_3 + 0.00897834308548744*G0_0_1_5_4 - 0.0284565434565483*G0_0_1_5_5 - 0.00129245754245784*G0_0_1_5_6 + 0.0173587127158584*G0_0_1_5_7 - 0.0058664549735988*G0_0_1_5_8 - 0.00108641358641378*G0_0_1_5_9 - 0.0131951381951404*G0_0_1_6_0 - 0.002478890157462*G0_0_1_6_1 - 0.032277642991934*G0_0_1_6_2 + 0.00768749108034952*G0_0_1_6_3 - 0.016665834165837*G0_0_1_6_4 - 0.00129245754245784*G0_0_1_6_5 + 0.0166622663051264*G0_0_1_6_6 - 0.0114922577422597*G0_0_1_6_7 + 0.00445447409733199*G0_0_1_6_8 - 0.000896960182674674*G0_0_1_6_9 + 0.067081886367612*G0_0_1_7_0 + 0.00821375053518052*G0_0_1_7_1 + 0.00391435945007438*G0_0_1_7_2 - 0.00184725988297452*G0_0_1_7_3 - 0.00163318824033136*G0_0_1_7_4 + 0.0173587127158584*G0_0_1_7_5 - 0.0114922577422597*G0_0_1_7_6 + 0.0999678892536204*G0_0_1_7_7 - 0.0380350007135785*G0_0_1_7_8 + 0.010165191950908*G0_0_1_7_9 - 0.0291171526885862*G0_0_1_8_0 - 0.0030911945197665*G0_0_1_8_1 - 0.000574366110080501*G0_0_1_8_2 - 0.000126659055230494*G0_0_1_8_3 + 0.00197391893820498*G0_0_1_8_4 - 0.0058664549735988*G0_0_1_8_5 + 0.00445447409733199*G0_0_1_8_6 - 0.0380350007135785*G0_0_1_8_7 + 0.0139357071499952*G0_0_1_8_8 - 0.00410161267304194*G0_0_1_8_9 + 0.00427310784453721*G0_0_1_9_0 - 0.00482600732600811*G0_0_1_9_2 + 0.00354074496931701*G0_0_1_9_3 - 0.0034786641929505*G0_0_1_9_4 - 0.00108641358641378*G0_0_1_9_5 - 0.000896960182674673*G0_0_1_9_6 + 0.010165191950908*G0_0_1_9_7 - 0.00410161267304194*G0_0_1_9_8 + 0.0132424718139026*G0_0_1_9_9 - 0.0149153315820009*G0_1_0_0_0 - 0.000810501227168036*G0_1_0_0_1 - 0.000957453040786535*G0_1_0_0_2 - 0.000306776556776608*G0_1_0_0_3 + 0.00218156843156881*G0_1_0_0_4 - 0.0139138639138663*G0_1_0_0_5 + 0.00850663225663373*G0_1_0_0_6 - 0.00926712176712339*G0_1_0_0_7 + 0.00400835275835347*G0_1_0_0_8 - 0.000651848151848269*G0_1_0_0_9 - 0.000810501227168036*G0_1_0_1_0 - 0.000141181569753038*G0_1_0_1_1 + 0.00107454494359275*G0_1_0_1_2 - 0.00166920381206124*G0_1_0_1_3 + 0.00275524079095556*G0_1_0_1_4 - 0.00258497454926071*G0_1_0_1_5 + 0.00214517625231948*G0_1_0_1_6 - 0.00169990723562182*G0_1_0_1_7 + 0.000541244469815991*G0_1_0_1_8 - 0.000957453040786535*G0_1_0_2_0 + 0.00107454494359275*G0_1_0_2_1 + 0.0173905723905754*G0_1_0_2_2 - 0.00594885273456804*G0_1_0_2_3 + 0.0132506382506405*G0_1_0_2_4 - 0.00406629085200584*G0_1_0_2_5 + 0.00650183150183263*G0_1_0_2_6 - 0.00117638314066905*G0_1_0_2_7 + 0.000431770610342114*G0_1_0_2_8 - 0.000306776556776608*G0_1_0_3_0 - 0.00166920381206124*G0_1_0_3_1 - 0.00594885273456804*G0_1_0_3_2 + 0.0082528186099629*G0_1_0_3_3 - 0.0103526830312562*G0_1_0_3_4 + 0.00421221635507422*G0_1_0_3_5 - 0.00618470814899491*G0_1_0_3_6 + 0.00117115027829333*G0_1_0_3_7 - 0.000126659055230502*G0_1_0_3_8 - 0.00249607535321862*G0_1_0_3_9 + 0.00218156843156881*G0_1_0_4_0 + 0.00275524079095556*G0_1_0_4_1 + 0.0132506382506405*G0_1_0_4_2 - 0.0103526830312562*G0_1_0_4_3 + 0.0534379905808568*G0_1_0_4_4 - 0.0062938846867429*G0_1_0_4_5 + 0.0124785928357378*G0_1_0_4_6 - 0.00163318824033137*G0_1_0_4_7 - 0.00104449122306283*G0_1_0_4_8 + 0.012290923362354*G0_1_0_4_9 - 0.0139138639138663*G0_1_0_5_0 - 0.00258497454926071*G0_1_0_5_1 - 0.00406629085200584*G0_1_0_5_2 + 0.00421221635507421*G0_1_0_5_3 - 0.0062938846867429*G0_1_0_5_4 - 0.0297977022977074*G0_1_0_5_5 - 0.00129245754245778*G0_1_0_5_6 - 0.0117857142857163*G0_1_0_5_7 + 0.00800574425574562*G0_1_0_5_8 - 0.0140559440559465*G0_1_0_5_9 + 0.00850663225663373*G0_1_0_6_0 + 0.00214517625231948*G0_1_0_6_1 + 0.00650183150183263*G0_1_0_6_2 - 0.00618470814899491*G0_1_0_6_3 + 0.0124785928357378*G0_1_0_6_4 - 0.00129245754245778*G0_1_0_6_5 + 0.0180034251462853*G0_1_0_6_6 + 0.00377997002997067*G0_1_0_6_7 - 0.00399083059797413*G0_1_0_6_8 + 0.012072570286858*G0_1_0_6_9 - 0.00926712176712339*G0_1_0_7_0 - 0.00169990723562182*G0_1_0_7_1 - 0.00117638314066905*G0_1_0_7_2 + 0.00117115027829333*G0_1_0_7_3 - 0.00163318824033137*G0_1_0_7_4 - 0.0117857142857163*G0_1_0_7_5 + 0.00377997002997067*G0_1_0_7_6 - 0.0136388611388635*G0_1_0_7_7 + 0.00753121878122008*G0_1_0_7_8 - 0.00560439560439657*G0_1_0_7_9 + 0.00400835275835347*G0_1_0_8_0 + 0.000541244469815991*G0_1_0_8_1 + 0.000431770610342114*G0_1_0_8_2 - 0.000126659055230502*G0_1_0_8_3 - 0.00104449122306283*G0_1_0_8_4 + 0.00800574425574562*G0_1_0_8_5 - 0.00399083059797413*G0_1_0_8_6 + 0.00753121878122008*G0_1_0_8_7 - 0.00372734408448756*G0_1_0_8_8 + 0.00193520764949371*G0_1_0_8_9 - 0.000651848151848268*G0_1_0_9_0 - 0.00249607535321862*G0_1_0_9_3 + 0.012290923362354*G0_1_0_9_4 - 0.0140559440559465*G0_1_0_9_5 + 0.012072570286858*G0_1_0_9_6 - 0.00560439560439657*G0_1_0_9_7 + 0.00193520764949371*G0_1_0_9_8 + 0.0132424718139026*G0_1_0_9_9 + 0.10818354485023*G0_1_1_0_0 + 0.00496077996078081*G0_1_1_0_1 + 0.000267589553303846*G0_1_1_0_3 - 0.00173279101850559*G0_1_1_0_4 + 0.0183637790780679*G0_1_1_0_5 - 0.00912884734313456*G0_1_1_0_6 + 0.0538312481169715*G0_1_1_0_7 - 0.0231682999540181*G0_1_1_0_8 + 0.00417415917415993*G0_1_1_0_9 + 0.00496077996078081*G0_1_1_1_0 - 0.0049607799607808*G0_1_1_1_2 + 0.00142199070770522*G0_1_1_1_3 - 0.00545850974422494*G0_1_1_1_4 - 0.000106084391798686*G0_1_1_1_5 + 0.0001060843917987*G0_1_1_1_6 + 0.00545850974422497*G0_1_1_1_7 - 0.00142199070770526*G0_1_1_1_8 - 0.0049607799607808*G0_1_1_2_1 - 0.10818354485023*G0_1_1_2_2 + 0.0231682999540181*G0_1_1_2_3 - 0.0538312481169714*G0_1_1_2_4 + 0.00912884734313452*G0_1_1_2_5 - 0.0183637790780677*G0_1_1_2_6 + 0.00173279101850558*G0_1_1_2_7 - 0.000267589553303891*G0_1_1_2_8 - 0.00417415917415985*G0_1_1_2_9 + 0.000267589553303846*G0_1_1_3_0 + 0.00142199070770522*G0_1_1_3_1 + 0.0231682999540181*G0_1_1_3_2 - 0.00568288854003233*G0_1_1_3_3 + 0.0276823176823223*G0_1_1_3_4 - 0.000242257742257806*G0_1_1_3_5 - 0.000318253175396086*G0_1_1_3_6 - 0.000802768659911685*G0_1_1_3_7 + 0.00160553731982331*G0_1_1_3_9 - 0.00173279101850559*G0_1_1_4_0 - 0.00545850974422494*G0_1_1_4_1 - 0.0538312481169714*G0_1_1_4_2 + 0.0276823176823223*G0_1_1_4_3 - 0.0465298986727637*G0_1_1_4_4 + 0.00519837305551677*G0_1_1_4_5 - 0.00488011988012068*G0_1_1_4_6 + 0.000802768659911645*G0_1_1_4_8 + 0.00212573141144604*G0_1_1_4_9 + 0.0183637790780679*G0_1_1_5_0 - 0.000106084391798686*G0_1_1_5_1 + 0.00912884734313452*G0_1_1_5_2 - 0.000242257742257807*G0_1_1_5_3 + 0.00519837305551677*G0_1_1_5_4 - 0.0464599686028334*G0_1_1_5_5 + 0.00488011988012071*G0_1_1_5_7 + 0.000318253175396062*G0_1_1_5_8 - 0.0131589838732717*G0_1_1_5_9 - 0.00912884734313456*G0_1_1_6_0 + 0.000106084391798701*G0_1_1_6_1 - 0.0183637790780677*G0_1_1_6_2 - 0.000318253175396086*G0_1_1_6_3 - 0.00488011988012068*G0_1_1_6_4 + 0.0464599686028337*G0_1_1_6_6 - 0.00519837305551679*G0_1_1_6_7 + 0.00024225774225779*G0_1_1_6_8 + 0.0131589838732718*G0_1_1_6_9 + 0.0538312481169715*G0_1_1_7_0 + 0.00545850974422497*G0_1_1_7_1 + 0.00173279101850559*G0_1_1_7_2 - 0.000802768659911685*G0_1_1_7_3 + 0.00488011988012071*G0_1_1_7_5 - 0.00519837305551679*G0_1_1_7_6 + 0.0465298986727637*G0_1_1_7_7 - 0.0276823176823224*G0_1_1_7_8 - 0.00212573141144599*G0_1_1_7_9 - 0.0231682999540182*G0_1_1_8_0 - 0.00142199070770526*G0_1_1_8_1 - 0.000267589553303891*G0_1_1_8_2 + 0.000802768659911645*G0_1_1_8_4 + 0.000318253175396062*G0_1_1_8_5 + 0.00024225774225779*G0_1_1_8_6 - 0.0276823176823224*G0_1_1_8_7 + 0.00568288854003235*G0_1_1_8_8 - 0.00160553731982332*G0_1_1_8_9 + 0.00417415917415993*G0_1_1_9_0 - 0.00417415917415985*G0_1_1_9_2 + 0.00160553731982331*G0_1_1_9_3 + 0.00212573141144604*G0_1_1_9_4 - 0.0131589838732717*G0_1_1_9_5 + 0.0131589838732718*G0_1_1_9_6 - 0.00212573141144599*G0_1_1_9_7 - 0.00160553731982332*G0_1_1_9_8;
    A[182] = A[42] - 0.00237293570626943*G0_0_1_0_0 - 0.000801544134877597*G0_0_1_0_2 - 0.000287014572728908*G0_0_1_0_3 + 0.000133992991135885*G0_0_1_0_4 + 0.00435770578627795*G0_0_1_0_5 - 0.00223522509236832*G0_0_1_0_6 - 0.000945562374133961*G0_0_1_0_7 + 0.00133390419104728*G0_0_1_0_9 - 0.000273025034929867*G0_0_1_1_1 + 0.000797104130437608*G0_0_1_1_2 + 0.00142825428539737*G0_0_1_1_3 + 0.00222697936983692*G0_0_1_1_4 + 0.00139891854177591*G0_0_1_1_5 - 0.00124462838748573*G0_0_1_1_6 - 0.000216291644863108*G0_0_1_1_7 + 0.000408321836893321*G0_0_1_1_8 + 0.00371628371628434*G0_0_1_1_9 - 0.000801544134877597*G0_0_1_2_0 + 0.000797104130437608*G0_0_1_2_1 - 0.00275280275280327*G0_0_1_2_3 + 0.0109668109668129*G0_0_1_2_4 + 0.00674880674880786*G0_0_1_2_5 - 0.0109668109668128*G0_0_1_2_6 + 0.00049839049839058*G0_0_1_2_7 - 0.000493950493950576*G0_0_1_2_8 - 0.00399600399600465*G0_0_1_2_9 - 0.000287014572728908*G0_0_1_3_0 + 0.00142825428539737*G0_0_1_3_1 - 0.00275280275280327*G0_0_1_3_2 + 0.0103839018124751*G0_0_1_3_3 - 0.0173126873126903*G0_0_1_3_4 - 0.00140430997573875*G0_0_1_3_5 + 0.0032067932067937*G0_0_1_3_6 + 0.000333951762523244*G0_0_1_3_7 - 0.00128871128871149*G0_0_1_3_8 - 0.0118167546738995*G0_0_1_3_9 + 0.000133992991135885*G0_0_1_4_0 + 0.00222697936983692*G0_0_1_4_1 + 0.0109668109668129*G0_0_1_4_2 - 0.0173126873126903*G0_0_1_4_3 + 0.0317482517482574*G0_0_1_4_4 - 0.000929070929071133*G0_0_1_4_5 - 0.00227772227772258*G0_0_1_4_6 - 0.000685029256457951*G0_0_1_4_7 + 0.000954759526188244*G0_0_1_4_8 + 0.0138461538461562*G0_0_1_4_9 + 0.00435770578627795*G0_0_1_5_0 + 0.00139891854177591*G0_0_1_5_1 + 0.00674880674880786*G0_0_1_5_2 - 0.00140430997573875*G0_0_1_5_3 - 0.000929070929071133*G0_0_1_5_4 + 0.0318824033109799*G0_0_1_5_5 - 0.00438561438561515*G0_0_1_5_6 + 0.00674611103182643*G0_0_1_5_7 - 0.00472384758099121*G0_0_1_5_8 + 0.0054459825888406*G0_0_1_5_9 - 0.00223522509236832*G0_0_1_6_0 - 0.00124462838748573*G0_0_1_6_1 - 0.0109668109668128*G0_0_1_6_2 + 0.0032067932067937*G0_0_1_6_3 - 0.00227772227772258*G0_0_1_6_4 - 0.00438561438561515*G0_0_1_6_5 - 0.0271928071928118*G0_0_1_6_6 - 0.00202226345083522*G0_0_1_6_7 + 0.00287141429998619*G0_0_1_6_8 + 0.00557442557442655*G0_0_1_6_9 - 0.000945562374133961*G0_0_1_7_0 - 0.000216291644863108*G0_0_1_7_1 + 0.00049839049839058*G0_0_1_7_2 + 0.000333951762523244*G0_0_1_7_3 - 0.00068502925645795*G0_0_1_7_4 + 0.00674611103182643*G0_0_1_7_5 - 0.00202226345083522*G0_0_1_7_6 + 0.000299700299700353*G0_0_1_7_7 + 0.00102754388468692*G0_0_1_7_8 + 0.000408321836893321*G0_0_1_8_1 - 0.000493950493950576*G0_0_1_8_2 - 0.00128871128871149*G0_0_1_8_3 + 0.000954759526188244*G0_0_1_8_4 - 0.00472384758099121*G0_0_1_8_5 + 0.00287141429998619*G0_0_1_8_6 + 0.00102754388468692*G0_0_1_8_7 + 0.00175538746967353*G0_0_1_8_8 - 0.0130583702012295*G0_0_1_8_9 + 0.00133390419104728*G0_0_1_9_0 + 0.00371628371628434*G0_0_1_9_1 - 0.00399600399600465*G0_0_1_9_2 - 0.0118167546738995*G0_0_1_9_3 + 0.0138461538461562*G0_0_1_9_4 + 0.0054459825888406*G0_0_1_9_5 + 0.00557442557442655*G0_0_1_9_6 - 0.0130583702012295*G0_0_1_9_8 - 0.0267161410018596*G0_0_1_9_9 + 0.00237293570626943*G0_1_0_0_0 + 0.000801544134877597*G0_1_0_0_2 + 0.000287014572728908*G0_1_0_0_3 - 0.000133992991135885*G0_1_0_0_4 - 0.00435770578627794*G0_1_0_0_5 + 0.00223522509236832*G0_1_0_0_6 + 0.000945562374133962*G0_1_0_0_7 - 0.00133390419104728*G0_1_0_0_9 + 0.000273025034929867*G0_1_0_1_1 - 0.000797104130437608*G0_1_0_1_2 - 0.00142825428539737*G0_1_0_1_3 - 0.00222697936983692*G0_1_0_1_4 - 0.00139891854177591*G0_1_0_1_5 + 0.00124462838748573*G0_1_0_1_6 + 0.000216291644863108*G0_1_0_1_7 - 0.000408321836893321*G0_1_0_1_8 - 0.00371628371628434*G0_1_0_1_9 + 0.000801544134877597*G0_1_0_2_0 - 0.000797104130437608*G0_1_0_2_1 + 0.00275280275280327*G0_1_0_2_3 - 0.0109668109668129*G0_1_0_2_4 - 0.00674880674880786*G0_1_0_2_5 + 0.0109668109668128*G0_1_0_2_6 - 0.00049839049839058*G0_1_0_2_7 + 0.000493950493950576*G0_1_0_2_8 + 0.00399600399600465*G0_1_0_2_9 + 0.000287014572728908*G0_1_0_3_0 - 0.00142825428539737*G0_1_0_3_1 + 0.00275280275280327*G0_1_0_3_2 - 0.0103839018124751*G0_1_0_3_3 + 0.0173126873126903*G0_1_0_3_4 + 0.00140430997573875*G0_1_0_3_5 - 0.0032067932067937*G0_1_0_3_6 - 0.000333951762523244*G0_1_0_3_7 + 0.00128871128871149*G0_1_0_3_8 + 0.0118167546738995*G0_1_0_3_9 - 0.000133992991135885*G0_1_0_4_0 - 0.00222697936983692*G0_1_0_4_1 - 0.0109668109668129*G0_1_0_4_2 + 0.0173126873126903*G0_1_0_4_3 - 0.0317482517482574*G0_1_0_4_4 + 0.000929070929071133*G0_1_0_4_5 + 0.00227772227772258*G0_1_0_4_6 + 0.000685029256457951*G0_1_0_4_7 - 0.000954759526188244*G0_1_0_4_8 - 0.0138461538461562*G0_1_0_4_9 - 0.00435770578627795*G0_1_0_5_0 - 0.00139891854177591*G0_1_0_5_1 - 0.00674880674880786*G0_1_0_5_2 + 0.00140430997573875*G0_1_0_5_3 + 0.000929070929071133*G0_1_0_5_4 - 0.0318824033109799*G0_1_0_5_5 + 0.00438561438561515*G0_1_0_5_6 - 0.00674611103182643*G0_1_0_5_7 + 0.00472384758099121*G0_1_0_5_8 - 0.0054459825888406*G0_1_0_5_9 + 0.00223522509236832*G0_1_0_6_0 + 0.00124462838748573*G0_1_0_6_1 + 0.0109668109668128*G0_1_0_6_2 - 0.0032067932067937*G0_1_0_6_3 + 0.00227772227772258*G0_1_0_6_4 + 0.00438561438561515*G0_1_0_6_5 + 0.0271928071928118*G0_1_0_6_6 + 0.00202226345083522*G0_1_0_6_7 - 0.00287141429998619*G0_1_0_6_8 - 0.00557442557442655*G0_1_0_6_9 + 0.000945562374133962*G0_1_0_7_0 + 0.000216291644863108*G0_1_0_7_1 - 0.00049839049839058*G0_1_0_7_2 - 0.000333951762523244*G0_1_0_7_3 + 0.000685029256457951*G0_1_0_7_4 - 0.00674611103182643*G0_1_0_7_5 + 0.00202226345083522*G0_1_0_7_6 - 0.000299700299700353*G0_1_0_7_7 - 0.00102754388468692*G0_1_0_7_8 - 0.000408321836893321*G0_1_0_8_1 + 0.000493950493950576*G0_1_0_8_2 + 0.00128871128871149*G0_1_0_8_3 - 0.000954759526188244*G0_1_0_8_4 + 0.00472384758099121*G0_1_0_8_5 - 0.00287141429998619*G0_1_0_8_6 - 0.00102754388468692*G0_1_0_8_7 - 0.00175538746967353*G0_1_0_8_8 + 0.0130583702012295*G0_1_0_8_9 - 0.00133390419104728*G0_1_0_9_0 - 0.00371628371628434*G0_1_0_9_1 + 0.00399600399600465*G0_1_0_9_2 + 0.0118167546738995*G0_1_0_9_3 - 0.0138461538461562*G0_1_0_9_4 - 0.0054459825888406*G0_1_0_9_5 - 0.00557442557442655*G0_1_0_9_6 + 0.0130583702012295*G0_1_0_9_8 + 0.0267161410018596*G0_1_0_9_9;
    A[198] = A[89] - 0.00613425375330242*G0_0_0_0_0 - 0.00455671312814248*G0_0_0_0_1 - 0.0100566805328727*G0_0_0_0_2 - 0.0401934573363214*G0_0_0_0_3 + 0.0134823906252501*G0_0_0_0_4 + 0.0148067805210687*G0_0_0_0_5 - 0.0272387929530834*G0_0_0_0_6 + 0.0111380682809273*G0_0_0_0_7 - 0.0145124716553313*G0_0_0_0_8 - 0.017902097902101*G0_0_0_0_9 - 0.00455671312814248*G0_0_0_1_0 - 0.0591346572299053*G0_0_0_1_1 - 0.00470612280136162*G0_0_0_1_2 - 0.119499548070997*G0_0_0_1_3 + 0.0733133533133658*G0_0_0_1_4 + 0.00154765869051609*G0_0_0_1_5 - 0.0145581402724285*G0_0_0_1_6 + 0.0176991262705578*G0_0_0_1_7 - 0.0352916924345555*G0_0_0_1_8 - 0.0248437277008748*G0_0_0_1_9 - 0.0100566805328727*G0_0_0_2_0 - 0.00470612280136162*G0_0_0_2_1 - 0.0133081733081747*G0_0_0_2_2 - 0.0699643213929049*G0_0_0_2_3 + 0.113379953379973*G0_0_0_2_4 + 0.0421369107083462*G0_0_0_2_5 - 0.107838827838846*G0_0_0_2_6 + 0.00584050869765251*G0_0_0_2_7 - 0.0121529264386428*G0_0_0_2_8 - 0.00243565957851703*G0_0_0_2_9 - 0.0401934573363214*G0_0_0_3_0 - 0.119499548070997*G0_0_0_3_1 - 0.0699643213929049*G0_0_0_3_2 - 1.02809190809208*G0_0_0_3_3 + 0.0617896389325059*G0_0_0_3_4 + 0.0466733266733345*G0_0_0_3_5 + 0.0662651634080313*G0_0_0_3_6 + 0.14317111459971*G0_0_0_3_7 - 0.202220636506385*G0_0_0_3_8 - 0.211811046096797*G0_0_0_3_9 + 0.0134823906252501*G0_0_0_4_0 + 0.0733133533133658*G0_0_0_4_1 + 0.113379953379973*G0_0_0_4_2 + 0.0617896389325058*G0_0_0_4_3 + 0.350186955901303*G0_0_0_4_4 - 0.0178564292850039*G0_0_0_4_5 - 0.0484087341230275*G0_0_0_4_6 - 0.040279720279727*G0_0_0_4_7 + 0.0590495219066746*G0_0_0_4_8 + 0.0430198373055589*G0_0_0_4_9 + 0.0148067805210687*G0_0_0_5_0 + 0.00154765869051609*G0_0_0_5_1 + 0.0421369107083462*G0_0_0_5_2 + 0.0466733266733345*G0_0_0_5_3 - 0.0178564292850039*G0_0_0_5_4 - 0.146504923647805*G0_0_0_5_5 + 0.136960182674492*G0_0_0_5_6 - 0.0230169830169869*G0_0_0_5_7 + 0.0179477665191981*G0_0_0_5_8 + 0.0178107606679064*G0_0_0_5_9 - 0.0272387929530834*G0_0_0_6_0 - 0.0145581402724285*G0_0_0_6_1 - 0.107838827838846*G0_0_0_6_2 + 0.0662651634080313*G0_0_0_6_3 - 0.0484087341230275*G0_0_0_6_4 + 0.136960182674492*G0_0_0_6_5 - 0.709872984158818*G0_0_0_6_6 + 0.00506921649778872*G0_0_0_6_7 + 0.0287712287712335*G0_0_0_6_8 - 0.125223348080512*G0_0_0_6_9 + 0.0111380682809273*G0_0_0_7_0 + 0.0176991262705578*G0_0_0_7_1 + 0.00584050869765251*G0_0_0_7_2 + 0.14317111459971*G0_0_0_7_3 - 0.040279720279727*G0_0_0_7_4 - 0.0230169830169869*G0_0_0_7_5 + 0.00506921649778872*G0_0_0_7_6 - 0.0418324532610317*G0_0_0_7_7 + 0.0587298415869943*G0_0_0_7_8 + 0.0435678607107251*G0_0_0_7_9 - 0.0145124716553313*G0_0_0_8_0 - 0.0352916924345555*G0_0_0_8_1 - 0.0121529264386428*G0_0_0_8_2 - 0.202220636506385*G0_0_0_8_3 + 0.0590495219066746*G0_0_0_8_4 + 0.0179477665191981*G0_0_0_8_5 + 0.0287712287712335*G0_0_0_8_6 + 0.0587298415869943*G0_0_0_8_7 - 0.0922506065363363*G0_0_0_8_8 - 0.0435678607107252*G0_0_0_8_9 - 0.017902097902101*G0_0_0_9_0 - 0.0248437277008748*G0_0_0_9_1 - 0.00243565957851702*G0_0_0_9_2 - 0.211811046096797*G0_0_0_9_3 + 0.043019837305559*G0_0_0_9_4 + 0.0178107606679064*G0_0_0_9_5 - 0.125223348080512*G0_0_0_9_6 + 0.0435678607107251*G0_0_0_9_7 - 0.0435678607107252*G0_0_0_9_8 - 0.29922077922083*G0_0_0_9_9 - 0.00695431552574531*G0_0_1_0_1 + 0.0069543155257453*G0_0_1_0_2 - 0.0348451548451608*G0_0_1_0_3 + 0.0348451548451609*G0_0_1_0_4 - 0.00712684141255694*G0_0_1_0_5 + 0.0158825301682472*G0_0_1_0_6 + 0.00712684141255692*G0_0_1_0_7 - 0.0158825301682472*G0_0_1_0_8 - 0.00695431552574531*G0_0_1_1_0 - 0.130445357112046*G0_0_1_1_1 - 0.186992689849864*G0_0_1_1_3 + 0.110918922347513*G0_0_1_1_4 - 0.00415584415584486*G0_0_1_1_5 + 0.0184272869987187*G0_0_1_1_6 + 0.0369357626500547*G0_0_1_1_7 - 0.0759266130694832*G0_0_1_1_8 - 0.0135179106607702*G0_0_1_1_9 + 0.0069543155257453*G0_0_1_2_0 + 0.130445357112046*G0_0_1_2_2 - 0.110918922347513*G0_0_1_2_3 + 0.186992689849865*G0_0_1_2_4 - 0.0369357626500546*G0_0_1_2_5 + 0.075926613069483*G0_0_1_2_6 + 0.00415584415584485*G0_0_1_2_7 - 0.0184272869987187*G0_0_1_2_8 + 0.0135179106607701*G0_0_1_2_9 - 0.0348451548451608*G0_0_1_3_0 - 0.186992689849865*G0_0_1_3_1 - 0.110918922347513*G0_0_1_3_2 - 0.553503639218019*G0_0_1_3_3 + 0.0585014985015083*G0_0_1_3_5 - 0.0552818609961561*G0_0_1_3_6 + 0.104535464535482*G0_0_1_3_7 - 0.159817325531638*G0_0_1_3_8 - 0.168517197088654*G0_0_1_3_9 + 0.0348451548451609*G0_0_1_4_0 + 0.110918922347513*G0_0_1_4_1 + 0.186992689849865*G0_0_1_4_2 + 0.55350363921802*G0_0_1_4_4 - 0.104535464535482*G0_0_1_4_5 + 0.159817325531638*G0_0_1_4_6 - 0.0585014985015084*G0_0_1_4_7 + 0.0552818609961561*G0_0_1_4_8 + 0.168517197088654*G0_0_1_4_9 - 0.00712684141255694*G0_0_1_5_0 - 0.00415584415584486*G0_0_1_5_1 - 0.0369357626500546*G0_0_1_5_2 + 0.0585014985015083*G0_0_1_5_3 - 0.104535464535482*G0_0_1_5_4 + 0.0254830883402355*G0_0_1_5_5 - 0.0614471243042775*G0_0_1_5_6 + 0.0124675324675346*G0_0_1_5_8 - 0.0249350649350692*G0_0_1_5_9 + 0.0158825301682472*G0_0_1_6_0 + 0.0184272869987187*G0_0_1_6_1 + 0.075926613069483*G0_0_1_6_2 - 0.0552818609961561*G0_0_1_6_3 + 0.159817325531638*G0_0_1_6_4 - 0.0614471243042776*G0_0_1_6_5 + 0.11467389753106*G0_0_1_6_6 - 0.0124675324675345*G0_0_1_6_7 + 0.0700099900100018*G0_0_1_6_9 + 0.00712684141255692*G0_0_1_7_0 + 0.0369357626500547*G0_0_1_7_1 + 0.00415584415584485*G0_0_1_7_2 + 0.104535464535482*G0_0_1_7_3 - 0.0585014985015084*G0_0_1_7_4 - 0.0124675324675345*G0_0_1_7_6 - 0.0254830883402357*G0_0_1_7_7 + 0.0614471243042776*G0_0_1_7_8 + 0.0249350649350691*G0_0_1_7_9 - 0.0158825301682472*G0_0_1_8_0 - 0.0759266130694832*G0_0_1_8_1 - 0.0184272869987187*G0_0_1_8_2 - 0.159817325531638*G0_0_1_8_3 + 0.055281860996156*G0_0_1_8_4 + 0.0124675324675346*G0_0_1_8_5 + 0.0614471243042776*G0_0_1_8_7 - 0.11467389753106*G0_0_1_8_8 - 0.0700099900100019*G0_0_1_8_9 - 0.0135179106607702*G0_0_1_9_1 + 0.0135179106607701*G0_0_1_9_2 - 0.168517197088654*G0_0_1_9_3 + 0.168517197088654*G0_0_1_9_4 - 0.0249350649350692*G0_0_1_9_5 + 0.0700099900100018*G0_0_1_9_6 + 0.0249350649350691*G0_0_1_9_7 - 0.0700099900100019*G0_0_1_9_8 + 0.00021734878877738*G0_1_0_0_1 - 0.000217348788777385*G0_1_0_0_2 - 0.0367936825079746*G0_1_0_0_3 + 0.0367936825079746*G0_1_0_0_4 - 0.00225552225552264*G0_1_0_0_5 + 0.00291264291264341*G0_1_0_0_6 + 0.00225552225552266*G0_1_0_0_7 - 0.00291264291264346*G0_1_0_0_8 + 0.00021734878877738*G0_1_0_1_0 - 0.037509157509164*G0_1_0_1_1 - 0.0926514755086342*G0_1_0_1_3 + 0.0647225790083044*G0_1_0_1_4 - 0.00305979734551217*G0_1_0_1_5 - 0.00044907473478908*G0_1_0_1_6 + 0.00167959025101919*G0_1_0_1_7 - 0.00431822146107953*G0_1_0_1_8 - 0.000974263831406932*G0_1_0_1_9 - 0.000217348788777385*G0_1_0_2_0 + 0.0375091575091639*G0_1_0_2_2 - 0.0647225790083043*G0_1_0_2_3 + 0.0926514755086344*G0_1_0_2_4 - 0.00167959025101911*G0_1_0_2_5 + 0.00431822146107933*G0_1_0_2_6 + 0.00305979734551216*G0_1_0_2_7 + 0.000449074734789063*G0_1_0_2_8 + 0.000974263831406876*G0_1_0_2_9 - 0.0367936825079746*G0_1_0_3_0 - 0.0926514755086342*G0_1_0_3_1 - 0.0647225790083043*G0_1_0_3_2 - 0.912458969601982*G0_1_0_3_3 + 0.0597802197802298*G0_1_0_3_5 + 0.00134722420436723*G0_1_0_3_6 + 0.110381047523923*G0_1_0_3_7 - 0.109033823319556*G0_1_0_3_8 - 0.217839303553626*G0_1_0_3_9 + 0.0367936825079746*G0_1_0_4_0 + 0.0647225790083044*G0_1_0_4_1 + 0.0926514755086344*G0_1_0_4_2 + 0.912458969601983*G0_1_0_4_4 - 0.110381047523923*G0_1_0_4_5 + 0.109033823319556*G0_1_0_4_6 - 0.0597802197802299*G0_1_0_4_7 - 0.00134722420436722*G0_1_0_4_8 + 0.217839303553626*G0_1_0_4_9 - 0.00225552225552264*G0_1_0_5_0 - 0.00305979734551217*G0_1_0_5_1 - 0.00167959025101911*G0_1_0_5_2 + 0.0597802197802298*G0_1_0_5_3 - 0.110381047523923*G0_1_0_5_4 + 0.00319680319680366*G0_1_0_5_5 - 0.00152989867275614*G0_1_0_5_6 + 0.00917939203653644*G0_1_0_5_8 - 0.018358784073073*G0_1_0_5_9 + 0.00291264291264341*G0_1_0_6_0 - 0.000449074734789082*G0_1_0_6_1 + 0.00431822146107934*G0_1_0_6_2 + 0.00134722420436724*G0_1_0_6_3 + 0.109033823319556*G0_1_0_6_4 - 0.00152989867275614*G0_1_0_6_5 - 0.0966804623947651*G0_1_0_6_6 - 0.00917939203653649*G0_1_0_6_7 - 0.00561723990295513*G0_1_0_6_9 + 0.00225552225552266*G0_1_0_7_0 + 0.00167959025101919*G0_1_0_7_1 + 0.00305979734551216*G0_1_0_7_2 + 0.110381047523923*G0_1_0_7_3 - 0.0597802197802299*G0_1_0_7_4 - 0.00917939203653649*G0_1_0_7_6 - 0.00319680319680367*G0_1_0_7_7 + 0.00152989867275627*G0_1_0_7_8 + 0.0183587840730729*G0_1_0_7_9 - 0.00291264291264346*G0_1_0_8_0 - 0.00431822146107953*G0_1_0_8_1 + 0.000449074734789063*G0_1_0_8_2 - 0.109033823319556*G0_1_0_8_3 - 0.00134722420436722*G0_1_0_8_4 + 0.00917939203653644*G0_1_0_8_5 + 0.00152989867275628*G0_1_0_8_7 + 0.0966804623947639*G0_1_0_8_8 + 0.00561723990295501*G0_1_0_8_9 - 0.00097426383140693*G0_1_0_9_1 + 0.000974263831406877*G0_1_0_9_2 - 0.217839303553626*G0_1_0_9_3 + 0.217839303553626*G0_1_0_9_4 - 0.018358784073073*G0_1_0_9_5 - 0.00561723990295515*G0_1_0_9_6 + 0.0183587840730729*G0_1_0_9_7 + 0.00561723990295501*G0_1_0_9_8 + 0.00613425375330243*G0_1_1_0_0 + 0.0100566805328727*G0_1_1_0_1 + 0.00455671312814249*G0_1_1_0_2 - 0.0134823906252501*G0_1_1_0_3 + 0.0401934573363215*G0_1_1_0_4 - 0.0111380682809273*G0_1_1_0_5 + 0.0145124716553313*G0_1_1_0_6 - 0.0148067805210687*G0_1_1_0_7 + 0.0272387929530833*G0_1_1_0_8 + 0.017902097902101*G0_1_1_0_9 + 0.0100566805328727*G0_1_1_1_0 + 0.0133081733081755*G0_1_1_1_1 + 0.00470612280136171*G0_1_1_1_2 - 0.113379953379973*G0_1_1_1_3 + 0.0699643213929048*G0_1_1_1_4 - 0.00584050869765261*G0_1_1_1_5 + 0.0121529264386429*G0_1_1_1_6 - 0.0421369107083463*G0_1_1_1_7 + 0.107838827838846*G0_1_1_1_8 + 0.00243565957851709*G0_1_1_1_9 + 0.00455671312814249*G0_1_1_2_0 + 0.00470612280136171*G0_1_1_2_1 + 0.0591346572299053*G0_1_1_2_2 - 0.0733133533133658*G0_1_1_2_3 + 0.119499548070997*G0_1_1_2_4 - 0.0176991262705578*G0_1_1_2_5 + 0.0352916924345556*G0_1_1_2_6 - 0.00154765869051608*G0_1_1_2_7 + 0.0145581402724283*G0_1_1_2_8 + 0.0248437277008747*G0_1_1_2_9 - 0.0134823906252501*G0_1_1_3_0 - 0.113379953379973*G0_1_1_3_1 - 0.0733133533133658*G0_1_1_3_2 - 0.350186955901301*G0_1_1_3_3 - 0.0617896389325065*G0_1_1_3_4 + 0.0402797202797271*G0_1_1_3_5 - 0.0590495219066747*G0_1_1_3_6 + 0.0178564292850039*G0_1_1_3_7 + 0.0484087341230275*G0_1_1_3_8 - 0.0430198373055591*G0_1_1_3_9 + 0.0401934573363215*G0_1_1_4_0 + 0.0699643213929048*G0_1_1_4_1 + 0.119499548070997*G0_1_1_4_2 - 0.0617896389325065*G0_1_1_4_3 + 1.02809190809208*G0_1_1_4_4 - 0.14317111459971*G0_1_1_4_5 + 0.202220636506385*G0_1_1_4_6 - 0.0466733266733346*G0_1_1_4_7 - 0.0662651634080315*G0_1_1_4_8 + 0.211811046096796*G0_1_1_4_9 - 0.0111380682809273*G0_1_1_5_0 - 0.00584050869765261*G0_1_1_5_1 - 0.0176991262705578*G0_1_1_5_2 + 0.040279720279727*G0_1_1_5_3 - 0.14317111459971*G0_1_1_5_4 + 0.0418324532610317*G0_1_1_5_5 - 0.0587298415869944*G0_1_1_5_6 + 0.0230169830169869*G0_1_1_5_7 - 0.00506921649778887*G0_1_1_5_8 - 0.0435678607107253*G0_1_1_5_9 + 0.0145124716553313*G0_1_1_6_0 + 0.0121529264386429*G0_1_1_6_1 + 0.0352916924345556*G0_1_1_6_2 - 0.0590495219066747*G0_1_1_6_3 + 0.202220636506385*G0_1_1_6_4 - 0.0587298415869944*G0_1_1_6_5 + 0.0922506065363364*G0_1_1_6_6 - 0.0179477665191981*G0_1_1_6_7 - 0.0287712287712334*G0_1_1_6_8 + 0.0435678607107253*G0_1_1_6_9 - 0.0148067805210687*G0_1_1_7_0 - 0.0421369107083463*G0_1_1_7_1 - 0.00154765869051608*G0_1_1_7_2 + 0.0178564292850039*G0_1_1_7_3 - 0.0466733266733346*G0_1_1_7_4 + 0.0230169830169869*G0_1_1_7_5 - 0.0179477665191981*G0_1_1_7_6 + 0.146504923647805*G0_1_1_7_7 - 0.136960182674491*G0_1_1_7_8 - 0.0178107606679065*G0_1_1_7_9 + 0.0272387929530833*G0_1_1_8_0 + 0.107838827838846*G0_1_1_8_1 + 0.0145581402724283*G0_1_1_8_2 + 0.0484087341230275*G0_1_1_8_3 - 0.0662651634080315*G0_1_1_8_4 - 0.00506921649778887*G0_1_1_8_5 - 0.0287712287712334*G0_1_1_8_6 - 0.136960182674491*G0_1_1_8_7 + 0.709872984158817*G0_1_1_8_8 + 0.125223348080512*G0_1_1_8_9 + 0.017902097902101*G0_1_1_9_0 + 0.00243565957851709*G0_1_1_9_1 + 0.0248437277008747*G0_1_1_9_2 - 0.0430198373055591*G0_1_1_9_3 + 0.211811046096796*G0_1_1_9_4 - 0.0435678607107253*G0_1_1_9_5 + 0.0435678607107253*G0_1_1_9_6 - 0.0178107606679066*G0_1_1_9_7 + 0.125223348080512*G0_1_1_9_8 + 0.299220779220829*G0_1_1_9_9;
    A[186] = A[198] - 0.0538416081273315*G0_0_0_0_0 - 0.00745244173815728*G0_0_0_0_2 + 0.0387422101707882*G0_0_0_0_3 - 0.00694162979877385*G0_0_0_0_4 - 0.118976896119773*G0_0_0_0_5 + 0.0510016967159911*G0_0_0_0_6 - 0.0457498057498133*G0_0_0_0_7 + 0.0320847406561746*G0_0_0_0_8 - 0.00861614575900435*G0_0_0_0_9 + 0.0538416081273315*G0_0_0_1_1 + 0.00745244173815726*G0_0_0_1_2 + 0.118976896119773*G0_0_0_1_3 - 0.051001696715991*G0_0_0_1_4 - 0.0387422101707881*G0_0_0_1_5 + 0.00694162979877381*G0_0_0_1_6 - 0.0320847406561746*G0_0_0_1_7 + 0.0457498057498135*G0_0_0_1_8 + 0.00861614575900442*G0_0_0_1_9 - 0.00745244173815728*G0_0_0_2_0 + 0.00745244173815727*G0_0_0_2_1 + 0.045323565323573*G0_0_0_2_3 - 0.0279897879897928*G0_0_0_2_4 - 0.045323565323573*G0_0_0_2_5 + 0.0279897879897927*G0_0_0_2_6 - 0.0184196755625358*G0_0_0_2_7 + 0.0184196755625358*G0_0_0_2_8 + 0.0387422101707882*G0_0_0_3_0 + 0.118976896119773*G0_0_0_3_1 + 0.045323565323573*G0_0_0_3_2 + 0.936571999429302*G0_0_0_3_3 - 0.167147138575738*G0_0_0_3_4 - 0.0208248893963214*G0_0_0_3_6 - 0.116226630512364*G0_0_0_3_7 + 0.171485657199972*G0_0_0_3_8 + 0.206604823747716*G0_0_0_3_9 - 0.00694162979877385*G0_0_0_4_0 - 0.051001696715991*G0_0_0_4_1 - 0.0279897879897928*G0_0_0_4_2 - 0.167147138575738*G0_0_0_4_3 - 0.0690509490509614*G0_0_0_4_4 + 0.0208248893963215*G0_0_0_4_5 + 0.0380419580419644*G0_0_0_4_7 - 0.0552590266876074*G0_0_0_4_8 - 0.0416497787926429*G0_0_0_4_9 - 0.118976896119773*G0_0_0_5_0 - 0.0387422101707881*G0_0_0_5_1 - 0.045323565323573*G0_0_0_5_2 + 0.0208248893963215*G0_0_0_5_4 - 0.936571999429301*G0_0_0_5_5 + 0.167147138575738*G0_0_0_5_6 - 0.171485657199972*G0_0_0_5_7 + 0.116226630512364*G0_0_0_5_8 - 0.206604823747716*G0_0_0_5_9 + 0.0510016967159911*G0_0_0_6_0 + 0.00694162979877381*G0_0_0_6_1 + 0.0279897879897927*G0_0_0_6_2 - 0.0208248893963214*G0_0_0_6_3 + 0.167147138575738*G0_0_0_6_5 + 0.0690509490509607*G0_0_0_6_6 + 0.0552590266876073*G0_0_0_6_7 - 0.0380419580419644*G0_0_0_6_8 + 0.0416497787926429*G0_0_0_6_9 - 0.0457498057498133*G0_0_0_7_0 - 0.0320847406561746*G0_0_0_7_1 - 0.0184196755625358*G0_0_0_7_2 - 0.116226630512364*G0_0_0_7_3 + 0.0380419580419644*G0_0_0_7_4 - 0.171485657199972*G0_0_0_7_5 + 0.0552590266876073*G0_0_0_7_6 - 0.0430198373055587*G0_0_0_7_7 - 0.0846696160982018*G0_0_0_7_9 + 0.0320847406561746*G0_0_0_8_0 + 0.0457498057498135*G0_0_0_8_1 + 0.0184196755625358*G0_0_0_8_2 + 0.171485657199972*G0_0_0_8_3 - 0.0552590266876074*G0_0_0_8_4 + 0.116226630512364*G0_0_0_8_5 - 0.0380419580419644*G0_0_0_8_6 + 0.0430198373055587*G0_0_0_8_8 + 0.0846696160982018*G0_0_0_8_9 - 0.00861614575900435*G0_0_0_9_0 + 0.00861614575900442*G0_0_0_9_1 + 0.206604823747716*G0_0_0_9_3 - 0.0416497787926429*G0_0_0_9_4 - 0.206604823747716*G0_0_0_9_5 + 0.0416497787926429*G0_0_0_9_6 - 0.0846696160982018*G0_0_0_9_7 + 0.0846696160982018*G0_0_0_9_8 + 0.0762947810566986*G0_0_1_0_0 + 0.0134440515392919*G0_0_1_0_1 + 0.00634032634032741*G0_0_1_0_2 + 0.0220274963132144*G0_0_1_0_3 - 0.0166614338042938*G0_0_1_0_4 + 0.0583771783771882*G0_0_1_0_5 - 0.0242754071325541*G0_0_1_0_6 + 0.0315189572332481*G0_0_1_0_7 - 0.00590647447790395*G0_0_1_0_8 + 0.00599781171209845*G0_0_1_0_9 + 0.0134440515392919*G0_0_1_1_0 + 0.13013638918403*G0_0_1_1_1 + 0.0137927680784847*G0_0_1_1_2 + 0.177354074496962*G0_0_1_1_3 - 0.0752771038485451*G0_0_1_1_4 - 0.0167147138575738*G0_0_1_1_5 - 0.00971980400551993*G0_0_1_1_6 - 0.0379912151340788*G0_0_1_1_7 + 0.0772687629830619*G0_0_1_1_8 + 0.0146139574711029*G0_0_1_1_9 + 0.00634032634032741*G0_0_1_2_0 + 0.0137927680784847*G0_0_1_2_1 - 0.00748288748288884*G0_0_1_2_2 + 0.0469168926311863*G0_0_1_2_3 - 0.0283449883449932*G0_0_1_2_4 + 0.00159332730761329*G0_0_1_2_5 - 0.000355200355200446*G0_0_1_2_6 - 0.00509205080633739*G0_0_1_2_7 + 0.0133276247561984*G0_0_1_2_8 + 0.0165624851339165*G0_0_1_2_9 + 0.0220274963132144*G0_0_1_3_0 + 0.177354074496962*G0_0_1_3_1 + 0.0469168926311863*G0_0_1_3_2 + 0.506875981161782*G0_0_1_3_3 - 0.165069216497816*G0_0_1_3_4 + 0.00132438989581863*G0_0_1_3_5 + 0.0105722848580009*G0_0_1_3_6 - 0.0846696160982019*G0_0_1_3_7 + 0.143239617525356*G0_0_1_3_8 + 0.125497359783095*G0_0_1_3_9 - 0.0166614338042938*G0_0_1_4_0 - 0.0752771038485452*G0_0_1_4_1 - 0.0283449883449932*G0_0_1_4_2 - 0.165069216497816*G0_0_1_4_3 - 0.145682888540056*G0_0_1_4_4 + 0.0313971742543224*G0_0_1_4_5 - 0.0419694591123233*G0_0_1_4_6 + 0.0419237904952262*G0_0_1_4_7 - 0.0585700014271542*G0_0_1_4_8 - 0.112481803910394*G0_0_1_4_9 + 0.0583771783771882*G0_0_1_5_0 - 0.0167147138575738*G0_0_1_5_1 + 0.00159332730761329*G0_0_1_5_2 + 0.00132438989581863*G0_0_1_5_3 + 0.0313971742543224*G0_0_1_5_4 - 0.429696018267519*G0_0_1_5_5 + 0.00207792207792232*G0_0_1_5_6 - 0.0282460396746159*G0_0_1_5_7 + 0.0315570144141626*G0_0_1_5_8 - 0.0811074639646206*G0_0_1_5_9 - 0.0242754071325541*G0_0_1_6_0 - 0.00971980400551993*G0_0_1_6_1 - 0.000355200355200446*G0_0_1_6_2 + 0.0105722848580009*G0_0_1_6_3 - 0.0419694591123233*G0_0_1_6_4 + 0.00207792207792233*G0_0_1_6_5 - 0.0766319394890952*G0_0_1_6_6 - 0.00331097473954669*G0_0_1_6_7 + 0.00388183245326165*G0_0_1_6_8 - 0.0708320251177513*G0_0_1_6_9 + 0.0315189572332481*G0_0_1_7_0 - 0.0379912151340788*G0_0_1_7_1 - 0.00509205080633739*G0_0_1_7_2 - 0.0846696160982019*G0_0_1_7_3 + 0.0419237904952262*G0_0_1_7_4 - 0.0282460396746159*G0_0_1_7_5 - 0.00331097473954669*G0_0_1_7_6 + 0.0673155416012672*G0_0_1_7_7 - 0.0624289995718672*G0_0_1_7_8 - 0.0113714856572019*G0_0_1_7_9 - 0.00590647447790395*G0_0_1_8_0 + 0.0772687629830619*G0_0_1_8_1 + 0.0133276247561984*G0_0_1_8_2 + 0.143239617525356*G0_0_1_8_3 - 0.0585700014271542*G0_0_1_8_4 + 0.0315570144141626*G0_0_1_8_5 + 0.00388183245326165*G0_0_1_8_6 - 0.0624289995718672*G0_0_1_8_7 + 0.110335378906826*G0_0_1_8_8 + 0.073298130441*G0_0_1_8_9 + 0.00599781171209845*G0_0_1_9_0 + 0.0146139574711029*G0_0_1_9_1 + 0.0165624851339165*G0_0_1_9_2 + 0.125497359783095*G0_0_1_9_3 - 0.112481803910394*G0_0_1_9_4 - 0.0811074639646206*G0_0_1_9_5 - 0.0708320251177513*G0_0_1_9_6 - 0.0113714856572019*G0_0_1_9_7 + 0.073298130441*G0_0_1_9_8 - 0.143034108748418*G0_0_1_9_9 - 0.0238390181247363*G0_1_0_0_0 - 0.00434359291502219*G0_1_0_0_1 - 0.00328306614020954*G0_1_0_0_2 + 0.0345863660149434*G0_1_0_0_3 - 0.00855525426954148*G0_1_0_0_4 - 0.0348553034267377*G0_1_0_0_5 + 0.00938236366807947*G0_1_0_0_6 - 0.0394373880088231*G0_1_0_0_7 + 0.0193990136847312*G0_1_0_0_8 - 0.0109300223585956*G0_1_0_0_9 - 0.00434359291502219*G0_1_0_1_0 + 0.0300025900025951*G0_1_0_1_1 + 0.00416937559794773*G0_1_0_1_2 + 0.0841215926930356*G0_1_0_1_3 - 0.0416193330479116*G0_1_0_1_4 - 0.00415584415584484*G0_1_0_1_5 - 0.00161362447076763*G0_1_0_1_6 - 0.0126857269714434*G0_1_0_1_7 + 0.00631241774099034*G0_1_0_1_8 - 0.00231387659959121*G0_1_0_1_9 - 0.00328306614020953*G0_1_0_2_0 + 0.00416937559794773*G0_1_0_2_1 - 0.0208384208384243*G0_1_0_2_2 + 0.0365044479330255*G0_1_0_2_3 - 0.028984348984354*G0_1_0_2_4 - 0.00881911739054746*G0_1_0_2_5 - 0.000994560994561094*G0_1_0_2_6 - 0.0168517197088654*G0_1_0_2_7 + 0.00156795585367042*G0_1_0_2_8 - 0.00310546596260933*G0_1_0_2_9 + 0.0345863660149434*G0_1_0_3_0 + 0.0841215926930356*G0_1_0_3_1 + 0.0365044479330255*G0_1_0_3_2 + 0.876700442414877*G0_1_0_3_3 - 0.0982331953760689*G0_1_0_3_4 - 0.0497331240188466*G0_1_0_3_5 + 0.0130155558727009*G0_1_0_3_6 - 0.0955844155844318*G0_1_0_3_7 + 0.0921136006850451*G0_1_0_3_8 + 0.198110460967638*G0_1_0_3_9 - 0.00855525426954148*G0_1_0_4_0 - 0.0416193330479116*G0_1_0_4_1 - 0.028984348984354*G0_1_0_4_2 - 0.0982331953760689*G0_1_0_4_3 - 0.151665477379789*G0_1_0_4_4 + 0.0338404452690224*G0_1_0_4_5 - 0.0468560011417234*G0_1_0_4_6 + 0.0340231197374112*G0_1_0_4_7 + 0.00347081489938683*G0_1_0_4_8 - 0.0583644926502168*G0_1_0_4_9 - 0.0348553034267377*G0_1_0_5_0 - 0.00415584415584484*G0_1_0_5_1 - 0.00881911739054745*G0_1_0_5_2 - 0.0497331240188466*G0_1_0_5_3 + 0.0338404452690224*G0_1_0_5_4 - 0.0598715570144242*G0_1_0_5_5 + 0.0689139431996689*G0_1_0_5_6 - 0.0793720565149268*G0_1_0_5_7 + 0.0206422149279327*G0_1_0_5_8 - 0.00849436278007849*G0_1_0_5_9 + 0.00938236366807948*G0_1_0_6_0 - 0.00161362447076763*G0_1_0_6_1 - 0.000994560994561093*G0_1_0_6_2 + 0.0130155558727009*G0_1_0_6_3 - 0.0468560011417234*G0_1_0_6_4 + 0.0689139431996689*G0_1_0_6_5 - 0.0826145283288276*G0_1_0_6_6 + 0.0587298415869942*G0_1_0_6_7 - 0.00401883830455328*G0_1_0_6_8 - 0.0167147138575738*G0_1_0_6_9 - 0.0394373880088231*G0_1_0_7_0 - 0.0126857269714434*G0_1_0_7_1 - 0.0168517197088654*G0_1_0_7_2 - 0.0955844155844318*G0_1_0_7_3 + 0.0340231197374112*G0_1_0_7_4 - 0.0793720565149268*G0_1_0_7_5 + 0.0587298415869942*G0_1_0_7_6 - 0.187743684886573*G0_1_0_7_7 + 0.0606479235050763*G0_1_0_7_8 - 0.0846696160982017*G0_1_0_7_9 + 0.0193990136847312*G0_1_0_8_0 + 0.00631241774099034*G0_1_0_8_1 + 0.00156795585367042*G0_1_0_8_2 + 0.0921136006850451*G0_1_0_8_3 + 0.00347081489938683*G0_1_0_8_4 + 0.0206422149279327*G0_1_0_8_5 - 0.00401883830455328*G0_1_0_8_6 + 0.0606479235050763*G0_1_0_8_7 - 0.144723847581014*G0_1_0_8_8 - 0.0109300223585956*G0_1_0_9_0 - 0.00231387659959121*G0_1_0_9_1 - 0.00310546596260933*G0_1_0_9_2 + 0.198110460967638*G0_1_0_9_3 - 0.0583644926502168*G0_1_0_9_4 - 0.00849436278007849*G0_1_0_9_5 - 0.0167147138575738*G0_1_0_9_6 - 0.0846696160982017*G0_1_0_9_7 - 0.129881547024426*G0_1_0_9_9 + 0.107126171888095*G0_1_1_0_0 + 0.00455022931213486*G0_1_1_0_1 + 0.0053934072981701*G0_1_1_0_2 + 0.00786261357690063*G0_1_1_0_3 - 0.0107473478902069*G0_1_1_0_4 + 0.0423068994497637*G0_1_1_0_5 - 0.0279999365713698*G0_1_1_0_6 + 0.143919572491025*G0_1_1_0_7 - 0.0789965589965724*G0_1_1_0_8 - 0.00286190000475758*G0_1_1_0_9 + 0.00455022931213486*G0_1_1_1_0 - 0.000828800828800818*G0_1_1_1_1 + 0.00511629464010503*G0_1_1_1_2 + 0.10019187162046*G0_1_1_1_3 - 0.0378948036090958*G0_1_1_1_4 + 0.0100090385804689*G0_1_1_1_5 - 0.00752771038485456*G0_1_1_1_6 + 0.0604043575472248*G0_1_1_1_7 - 0.106088197516787*G0_1_1_1_8 + 0.00654583511726488*G0_1_1_1_9 + 0.0053934072981701*G0_1_1_2_0 + 0.00511629464010503*G0_1_1_2_1 - 0.0141606541606566*G0_1_1_2_2 + 0.0336070278927479*G0_1_1_2_3 - 0.0242018299161198*G0_1_1_2_4 + 0.00449074734789096*G0_1_1_2_5 - 0.00513771942343459*G0_1_1_2_6 + 0.0126349840635576*G0_1_1_2_7 - 0.0161590790162245*G0_1_1_2_8 + 0.00672850958565361*G0_1_1_2_9 + 0.00786261357690063*G0_1_1_3_0 + 0.10019187162046*G0_1_1_3_1 + 0.0336070278927479*G0_1_1_3_2 + 0.389918652775862*G0_1_1_3_3 - 0.102000856286588*G0_1_1_3_4 - 0.0242043670615139*G0_1_1_3_5 + 0.0173769088054831*G0_1_1_3_6 - 0.0287940630797825*G0_1_1_3_7 - 0.0144769516198107*G0_1_1_3_8 + 0.0379506208077703*G0_1_1_3_9 - 0.0107473478902069*G0_1_1_4_0 - 0.0378948036090958*G0_1_1_4_1 - 0.0242018299161198*G0_1_1_4_2 - 0.102000856286588*G0_1_1_4_3 - 0.190301127444017*G0_1_1_4_4 + 0.0270358213215402*G0_1_1_4_5 - 0.0444127301270234*G0_1_1_4_6 - 0.000228343085485884*G0_1_1_4_7 + 0.0432710146995932*G0_1_1_4_8 - 0.0742571714000412*G0_1_1_4_9 + 0.0423068994497637*G0_1_1_5_0 + 0.0100090385804689*G0_1_1_5_1 + 0.00449074734789096*G0_1_1_5_2 - 0.0242043670615139*G0_1_1_5_3 + 0.0270358213215402*G0_1_1_5_4 + 0.0570857713714949*G0_1_1_5_5 + 0.00584558298844117*G0_1_1_5_6 + 0.0783445126302399*G0_1_1_5_7 - 0.0352333380904867*G0_1_1_5_8 + 0.0790523761952466*G0_1_1_5_9 - 0.0279999365713698*G0_1_1_6_0 - 0.00752771038485455*G0_1_1_6_1 - 0.00513771942343459*G0_1_1_6_2 + 0.0173769088054831*G0_1_1_6_3 - 0.0444127301270234*G0_1_1_6_4 + 0.00584558298844117*G0_1_1_6_5 - 0.0379962894248673*G0_1_1_6_6 - 0.0431111745397531*G0_1_1_6_7 + 0.0381332952761586*G0_1_1_6_8 - 0.0549393463679271*G0_1_1_6_9 + 0.143919572491025*G0_1_1_7_0 + 0.0604043575472248*G0_1_1_7_1 + 0.0126349840635576*G0_1_1_7_2 - 0.0287940630797825*G0_1_1_7_3 - 0.000228343085485881*G0_1_1_7_4 + 0.0783445126302399*G0_1_1_7_5 - 0.0431111745397531*G0_1_1_7_6 + 0.390329670329736*G0_1_1_7_7 - 0.000890538033395463*G0_1_1_7_8 + 0.0948080490937796*G0_1_1_7_9 - 0.0789965589965724*G0_1_1_8_0 - 0.106088197516787*G0_1_1_8_1 - 0.0161590790162245*G0_1_1_8_2 - 0.0144769516198107*G0_1_1_8_3 + 0.0432710146995932*G0_1_1_8_4 - 0.0352333380904867*G0_1_1_8_5 + 0.0381332952761587*G0_1_1_8_6 - 0.000890538033395463*G0_1_1_8_7 - 0.467737976309483*G0_1_1_8_8 - 0.106179534750981*G0_1_1_8_9 - 0.00286190000475758*G0_1_1_9_0 + 0.00654583511726488*G0_1_1_9_1 + 0.00672850958565362*G0_1_1_9_2 + 0.0379506208077703*G0_1_1_9_3 - 0.0742571714000412*G0_1_1_9_4 + 0.0790523761952466*G0_1_1_9_5 - 0.0549393463679271*G0_1_1_9_6 + 0.0948080490937796*G0_1_1_9_7 - 0.106179534750981*G0_1_1_9_8 - 0.136457827886422*G0_1_1_9_9;
    A[32] = 0.00212020122734445*G0_1_1_0_0 + 0.000609996815354065*G0_1_1_0_1 + 0.00505480245063665*G0_1_1_0_2 - 0.00139091232841257*G0_1_1_0_3 + 0.0032766423391429*G0_1_1_0_4 - 0.00193059255559289*G0_1_1_0_5 + 0.00494551744551829*G0_1_1_0_6 + 0.000907706711278292*G0_1_1_0_7 - 0.000483709412280919*G0_1_1_0_8 + 0.00107184482184501*G0_1_1_0_9 + 0.000609996815354065*G0_1_1_1_0 + 0.00212020122734446*G0_1_1_1_1 + 0.00505480245063664*G0_1_1_1_2 - 0.00193059255559288*G0_1_1_1_3 + 0.00494551744551828*G0_1_1_1_4 - 0.00139091232841257*G0_1_1_1_5 + 0.0032766423391429*G0_1_1_1_6 - 0.000483709412280929*G0_1_1_1_7 + 0.000907706711278309*G0_1_1_1_8 + 0.00107184482184501*G0_1_1_1_9 + 0.00505480245063665*G0_1_1_2_0 + 0.00505480245063664*G0_1_1_2_1 + 0.106054978971663*G0_1_1_2_2 - 0.0222249972250009*G0_1_1_2_3 + 0.0477428821178901*G0_1_1_2_4 - 0.0222249972250009*G0_1_1_2_5 + 0.0477428821178901*G0_1_1_2_6 - 0.000749886687386808*G0_1_1_2_7 - 0.000749886687386804*G0_1_1_2_8 + 0.00658577533577643*G0_1_1_2_9 - 0.00139091232841257*G0_1_1_3_0 - 0.00193059255559288*G0_1_1_3_1 - 0.0222249972250009*G0_1_1_3_2 + 0.0128475690975713*G0_1_1_3_3 - 0.0240733225108266*G0_1_1_3_4 + 0.00635510323010429*G0_1_1_3_5 - 0.0141946595071619*G0_1_1_3_6 - 0.000191995504495541*G0_1_1_3_7 + 0.00230706793206832*G0_1_1_3_8 - 0.00283154345654393*G0_1_1_3_9 + 0.0032766423391429*G0_1_1_4_0 + 0.00494551744551828*G0_1_1_4_1 + 0.0477428821178901*G0_1_1_4_2 - 0.0240733225108266*G0_1_1_4_3 + 0.0567786380286476*G0_1_1_4_4 - 0.0141946595071619*G0_1_1_4_5 + 0.0283893190143238*G0_1_1_4_6 - 0.0016077672327675*G0_1_1_4_7 - 0.00211507242757278*G0_1_1_4_8 + 0.00863199300699446*G0_1_1_4_9 - 0.00193059255559289*G0_1_1_5_0 - 0.00139091232841257*G0_1_1_5_1 - 0.0222249972250009*G0_1_1_5_2 + 0.00635510323010429*G0_1_1_5_3 - 0.0141946595071619*G0_1_1_5_4 + 0.0128475690975712*G0_1_1_5_5 - 0.0240733225108266*G0_1_1_5_6 + 0.00230706793206831*G0_1_1_5_7 - 0.000191995504495538*G0_1_1_5_8 - 0.00283154345654393*G0_1_1_5_9 + 0.00494551744551829*G0_1_1_6_0 + 0.0032766423391429*G0_1_1_6_1 + 0.0477428821178901*G0_1_1_6_2 - 0.0141946595071619*G0_1_1_6_3 + 0.0283893190143238*G0_1_1_6_4 - 0.0240733225108266*G0_1_1_6_5 + 0.0567786380286476*G0_1_1_6_6 - 0.00211507242757278*G0_1_1_6_7 - 0.0016077672327675*G0_1_1_6_8 + 0.00863199300699445*G0_1_1_6_9 + 0.000907706711278292*G0_1_1_7_0 - 0.000483709412280929*G0_1_1_7_1 - 0.000749886687386808*G0_1_1_7_2 - 0.000191995504495541*G0_1_1_7_3 - 0.0016077672327675*G0_1_1_7_4 + 0.00230706793206831*G0_1_1_7_5 - 0.00211507242757278*G0_1_1_7_6 + 0.00947475143903876*G0_1_1_7_7 - 0.00193593608772214*G0_1_1_7_8 + 0.00101461038961056*G0_1_1_7_9 - 0.000483709412280919*G0_1_1_8_0 + 0.000907706711278308*G0_1_1_8_1 - 0.000749886687386804*G0_1_1_8_2 + 0.00230706793206832*G0_1_1_8_3 - 0.00211507242757278*G0_1_1_8_4 - 0.000191995504495538*G0_1_1_8_5 - 0.0016077672327675*G0_1_1_8_6 - 0.00193593608772214*G0_1_1_8_7 + 0.00947475143903879*G0_1_1_8_8 + 0.00101461038961056*G0_1_1_8_9 + 0.00107184482184501*G0_1_1_9_0 + 0.00107184482184501*G0_1_1_9_1 + 0.00658577533577643*G0_1_1_9_2 - 0.00283154345654393*G0_1_1_9_3 + 0.00863199300699446*G0_1_1_9_4 - 0.00283154345654393*G0_1_1_9_5 + 0.00863199300699445*G0_1_1_9_6 + 0.00101461038961056*G0_1_1_9_7 + 0.00101461038961056*G0_1_1_9_8 + 0.0118756243756264*G0_1_1_9_9;
    A[41] = A[32] - 0.00407525455144574*G0_1_0_0_0 + 0.000591824401348319*G0_1_0_0_1 + 0.000140194902099688*G0_1_0_0_2 + 0.000111370111370133*G0_1_0_0_3 - 0.000364661793233285*G0_1_0_0_4 + 0.000477511906083408*G0_1_0_0_5 + 0.000426372569229787*G0_1_0_0_6 + 0.000827690827690953*G0_1_0_0_7 + 0.000730724302153005*G0_1_0_0_8 + 0.00128173413887721*G0_1_0_0_9 + 0.000591824401348319*G0_1_0_1_0 + 0.0170459170459201*G0_1_0_1_1 + 0.00013545537355064*G0_1_0_1_2 + 0.00212343212343253*G0_1_0_1_3 - 0.0015861123003983*G0_1_0_1_4 - 0.00222769294197907*G0_1_0_1_7 + 0.00662670662670783*G0_1_0_1_8 - 0.000466359037787676*G0_1_0_1_9 + 0.000140194902099688*G0_1_0_2_0 + 0.00013545537355064*G0_1_0_2_1 + 0.00062789062789073*G0_1_0_2_3 - 0.00182854182854213*G0_1_0_2_4 - 0.000292670292670344*G0_1_0_2_5 + 0.00182854182854214*G0_1_0_2_6 - 0.000196734482448802*G0_1_0_2_7 - 0.000335220335220396*G0_1_0_2_9 + 0.000111370111370133*G0_1_0_3_0 + 0.00212343212343253*G0_1_0_3_1 + 0.00062789062789073*G0_1_0_3_2 - 0.00768041482327328*G0_1_0_3_3 + 0.00257218971504728*G0_1_0_3_4 - 0.000377717520574723*G0_1_0_3_6 - 0.000574187717044964*G0_1_0_3_7 + 0.000577517720374971*G0_1_0_3_8 + 0.00254745254745296*G0_1_0_3_9 - 0.000364661793233285*G0_1_0_4_0 - 0.0015861123003983*G0_1_0_4_1 - 0.00182854182854213*G0_1_0_4_2 + 0.00257218971504728*G0_1_0_4_3 - 0.00462204462204539*G0_1_0_4_4 + 0.000853907996765285*G0_1_0_4_5 - 0.000476190476190561*G0_1_0_4_6 + 0.000962133104990412*G0_1_0_4_7 - 0.000702154987869381*G0_1_0_4_9 + 0.000477511906083408*G0_1_0_5_0 - 0.000292670292670344*G0_1_0_5_2 + 0.000853907996765286*G0_1_0_5_4 + 0.00549878692735923*G0_1_0_5_5 - 0.00410732125017908*G0_1_0_5_6 - 0.000233575947861706*G0_1_0_5_7 - 0.000116550116550134*G0_1_0_5_8 - 0.00361210218353136*G0_1_0_5_9 + 0.000426372569229787*G0_1_0_6_0 + 0.00182854182854214*G0_1_0_6_2 - 0.000377717520574723*G0_1_0_6_3 - 0.000476190476190561*G0_1_0_6_4 - 0.00410732125017908*G0_1_0_6_5 + 0.0055744255744265*G0_1_0_6_6 + 0.000350126064411839*G0_1_0_6_7 + 0.000169592312449485*G0_1_0_6_8 + 0.00176109604681063*G0_1_0_6_9 + 0.000827690827690953*G0_1_0_7_0 - 0.00222769294197907*G0_1_0_7_1 - 0.000196734482448802*G0_1_0_7_2 - 0.000574187717044964*G0_1_0_7_3 + 0.000962133104990413*G0_1_0_7_4 - 0.000233575947861707*G0_1_0_7_5 + 0.000350126064411839*G0_1_0_7_6 + 0.00713334284762976*G0_1_0_7_7 - 0.00651729223157906*G0_1_0_7_8 - 0.0045454545454553*G0_1_0_7_9 + 0.000730724302153005*G0_1_0_8_0 + 0.00662670662670783*G0_1_0_8_1 + 0.000577517720374972*G0_1_0_8_3 - 0.000116550116550134*G0_1_0_8_5 + 0.000169592312449485*G0_1_0_8_6 - 0.00651729223157906*G0_1_0_8_7 - 0.0201679273107879*G0_1_0_8_8 + 0.00140573712002304*G0_1_0_8_9 + 0.00128173413887721*G0_1_0_9_0 - 0.000466359037787676*G0_1_0_9_1 - 0.000335220335220396*G0_1_0_9_2 + 0.00254745254745296*G0_1_0_9_3 - 0.000702154987869381*G0_1_0_9_4 - 0.00361210218353136*G0_1_0_9_5 + 0.00176109604681063*G0_1_0_9_6 - 0.0045454545454553*G0_1_0_9_7 + 0.00140573712002304*G0_1_0_9_8 + 0.00428143285286216*G0_1_0_9_9 - 0.00171475129808491*G0_1_1_0_0 + 0.000791432443218303*G0_1_1_0_1 - 0.00523191810394281*G0_1_1_0_2 + 0.00114774279952872*G0_1_1_0_3 - 0.00358863193684684*G0_1_1_0_4 + 0.00216231850160459*G0_1_1_0_5 - 0.00531152709724229*G0_1_1_0_6 - 0.00115291124219715*G0_1_1_0_7 + 0.00235028199313955*G0_1_1_0_8 - 0.00147223807938119*G0_1_1_0_9 + 0.000791432443218303*G0_1_1_1_0 + 0.0208333883929159*G0_1_1_1_1 - 0.00476101334732368*G0_1_1_1_2 + 0.00570977633477735*G0_1_1_1_3 - 0.00765207015207147*G0_1_1_1_4 + 0.00134357870965036*G0_1_1_1_5 - 0.0036566591477312*G0_1_1_1_6 - 0.00602940710083674*G0_1_1_1_7 + 0.0148713290677603*G0_1_1_1_8 - 0.000166083916083934*G0_1_1_1_9 - 0.00523191810394281*G0_1_1_2_0 - 0.00476101334732368*G0_1_1_2_1 - 0.108918781835467*G0_1_1_2_2 + 0.0226122026122064*G0_1_1_2_3 - 0.0500823944574029*G0_1_1_2_4 + 0.0230554630554669*G0_1_1_2_5 - 0.0495714239464322*G0_1_1_2_6 + 0.000699223065294603*G0_1_1_2_7 + 0.00143436094328975*G0_1_1_2_8 - 0.00732614607614729*G0_1_1_2_9 + 0.00114774279952872*G0_1_1_3_0 + 0.00570977633477735*G0_1_1_3_1 + 0.0226122026122064*G0_1_1_3_2 - 0.0291246253746303*G0_1_1_3_3 + 0.0298220975453168*G0_1_1_3_4 - 0.00597809928167172*G0_1_1_3_5 + 0.0154522114789998*G0_1_1_3_6 + 0.00103900563722008*G0_1_1_3_7 - 0.00121815684315699*G0_1_1_3_8 - 0.00157975952618835*G0_1_1_3_9 - 0.00358863193684684*G0_1_1_4_0 - 0.00765207015207147*G0_1_1_4_1 - 0.0500823944574029*G0_1_1_4_2 + 0.0298220975453168*G0_1_1_4_3 - 0.0626560939061045*G0_1_1_4_4 + 0.0152481298463467*G0_1_1_4_5 - 0.0307003413253465*G0_1_1_4_6 + 0.00209299628942522*G0_1_1_4_7 + 0.000179151205936915*G0_1_1_4_8 - 0.00851782146425148*G0_1_1_4_9 + 0.00216231850160459*G0_1_1_5_0 + 0.00134357870965036*G0_1_1_5_1 + 0.0230554630554669*G0_1_1_5_2 - 0.00597809928167172*G0_1_1_5_3 + 0.0152481298463467*G0_1_1_5_4 - 0.0144645235716688*G0_1_1_5_5 + 0.025833704985495*G0_1_1_5_6 - 0.00283606274677749*G0_1_1_5_7 + 0.000451497906855109*G0_1_1_5_8 + 0.00351371842443331*G0_1_1_5_9 - 0.00531152709724229*G0_1_1_6_0 - 0.0036566591477312*G0_1_1_6_1 - 0.0495714239464322*G0_1_1_6_2 + 0.0154522114789998*G0_1_1_6_3 - 0.0307003413253465*G0_1_1_6_4 + 0.025833704985495*G0_1_1_6_5 - 0.0595658508158609*G0_1_1_6_6 + 0.00238456483992237*G0_1_1_6_7 + 0.00109233028875904*G0_1_1_6_8 - 0.00892598472955766*G0_1_1_6_9 - 0.00115291124219715*G0_1_1_7_0 - 0.00602940710083674*G0_1_1_7_1 + 0.000699223065294603*G0_1_1_7_2 + 0.00103900563722008*G0_1_1_7_3 + 0.00209299628942522*G0_1_1_7_4 - 0.00283606274677749*G0_1_1_7_5 + 0.00238456483992237*G0_1_1_7_6 - 0.00644302126445088*G0_1_1_7_7 - 0.00825839339232343*G0_1_1_7_8 - 0.000352415441701223*G0_1_1_7_9 + 0.00235028199313955*G0_1_1_8_0 + 0.0148713290677603*G0_1_1_8_1 + 0.00143436094328975*G0_1_1_8_2 - 0.00121815684315699*G0_1_1_8_3 + 0.000179151205936915*G0_1_1_8_4 + 0.000451497906855109*G0_1_1_8_5 + 0.00109233028875904*G0_1_1_8_6 - 0.00825839339232343*G0_1_1_8_7 + 0.0273018053375244*G0_1_1_8_8 + 0.000139949336377971*G0_1_1_8_9 - 0.00147223807938119*G0_1_1_9_0 - 0.000166083916083934*G0_1_1_9_1 - 0.00732614607614729*G0_1_1_9_2 - 0.00157975952618835*G0_1_1_9_3 - 0.00851782146425148*G0_1_1_9_4 + 0.00351371842443331*G0_1_1_9_5 - 0.00892598472955766*G0_1_1_9_6 - 0.000352415441701223*G0_1_1_9_7 + 0.000139949336377971*G0_1_1_9_8 - 0.0140505922648803*G0_1_1_9_9;
    A[25] = 0.0168435885102581*G0_0_0_0_0 + 0.00384300884300953*G0_0_0_0_1 + 0.00134550634550658*G0_0_0_0_2 + 0.00276037454608932*G0_0_0_0_3 - 0.00122552051123502*G0_0_0_0_4 + 0.0123289805432684*G0_0_0_0_5 - 0.00560861757290427*G0_0_0_0_6 + 0.00496566925138438*G0_0_0_0_7 - 0.00325057878629362*G0_0_0_0_8 + 0.000501998001998108*G0_0_0_0_9 + 0.00384300884300953*G0_0_0_1_0 + 0.125027133360488*G0_0_0_1_1 + 0.00630628630628737*G0_0_0_1_2 + 0.06616022866024*G0_0_0_1_3 - 0.0287769175269224*G0_0_0_1_4 + 0.00102758352758367*G0_0_0_1_5 - 0.000957930957931112*G0_0_0_1_6 - 0.0123794261294283*G0_0_0_1_7 + 0.0233294483294525*G0_0_0_1_8 + 0.00467615717615802*G0_0_0_1_9 + 0.00134550634550658*G0_0_0_2_0 + 0.00630628630628737*G0_0_0_2_1 + 0.000824677967535265*G0_0_0_2_2 + 0.0080091337234208*G0_0_0_2_3 - 0.00342597878312222*G0_0_0_2_4 + 0.00255062397919584*G0_0_0_2_5 - 0.00200398807541698*G0_0_0_2_6 + 0.00100831707974581*G0_0_0_2_7 + 0.00090223268794714*G0_0_0_2_8 + 0.00253032681604154*G0_0_0_2_9 + 0.00276037454608932*G0_0_0_3_0 + 0.06616022866024*G0_0_0_3_1 + 0.0080091337234208*G0_0_0_3_2 + 0.0972252747252914*G0_0_0_3_3 - 0.0379545454545519*G0_0_0_3_4 - 0.0037548166119601*G0_0_0_3_5 - 0.000980448123305437*G0_0_0_3_6 - 0.0121353646353668*G0_0_0_3_7 + 0.018696303696307*G0_0_0_3_8 + 0.0102422577422596*G0_0_0_3_9 - 0.00122552051123502*G0_0_0_4_0 - 0.0287769175269224*G0_0_0_4_1 - 0.00342597878312222*G0_0_0_4_2 - 0.0379545454545519*G0_0_0_4_3 + 0.0135478806907401*G0_0_0_4_4 - 0.000177679463393778*G0_0_0_4_5 + 0.00115812758669921*G0_0_0_4_6 + 0.0022529256457832*G0_0_0_4_7 - 0.00656093906094023*G0_0_0_4_8 - 0.00723562152133707*G0_0_0_4_9 + 0.0123289805432684*G0_0_0_5_0 + 0.00102758352758367*G0_0_0_5_1 + 0.00255062397919584*G0_0_0_5_2 - 0.0037548166119601*G0_0_0_5_3 - 0.000177679463393778*G0_0_0_5_4 + 0.0506953760525274*G0_0_0_5_5 - 0.0102722277722295*G0_0_0_5_6 + 0.0138161838161861*G0_0_0_5_7 - 0.0069369915798499*G0_0_0_5_8 + 0.0123679891537055*G0_0_0_5_9 - 0.00560861757290426*G0_0_0_6_0 - 0.000957930957931112*G0_0_0_6_1 - 0.00200398807541698*G0_0_0_6_2 - 0.000980448123305438*G0_0_0_6_3 + 0.00115812758669921*G0_0_0_6_4 - 0.0102722277722295*G0_0_0_6_5 + 0.00786499215070777*G0_0_0_6_6 - 0.00687919223633624*G0_0_0_6_7 + 0.00201066790352538*G0_0_0_6_8 - 0.00563008420151373*G0_0_0_6_9 + 0.00496566925138438*G0_0_0_7_0 - 0.0123794261294283*G0_0_0_7_1 + 0.00100831707974581*G0_0_0_7_2 - 0.0121353646353668*G0_0_0_7_3 + 0.0022529256457832*G0_0_0_7_4 + 0.0138161838161861*G0_0_0_7_5 - 0.00687919223633624*G0_0_0_7_6 + 0.0277262023690642*G0_0_0_7_7 - 0.00227272727272772*G0_0_0_7_8 + 0.0122523904666782*G0_0_0_7_9 - 0.00325057878629362*G0_0_0_8_0 + 0.0233294483294525*G0_0_0_8_1 + 0.000902232687947141*G0_0_0_8_2 + 0.018696303696307*G0_0_0_8_3 - 0.00656093906094023*G0_0_0_8_4 - 0.0069369915798499*G0_0_0_8_5 + 0.00201066790352538*G0_0_0_8_6 - 0.00227272727272772*G0_0_0_8_7 - 0.0187337662337692*G0_0_0_8_8 - 0.000906593406593503*G0_0_0_8_9 + 0.000501998001998108*G0_0_0_9_0 + 0.00467615717615802*G0_0_0_9_1 + 0.00253032681604154*G0_0_0_9_2 + 0.0102422577422596*G0_0_0_9_3 - 0.00723562152133707*G0_0_0_9_4 + 0.0123679891537055*G0_0_0_9_5 - 0.00563008420151373*G0_0_0_9_6 + 0.0122523904666782*G0_0_0_9_7 - 0.000906593406593503*G0_0_0_9_8 + 0.0352704438418784*G0_0_0_9_9 - 0.000546983880317294*G0_0_1_0_0 + 0.00480046188379607*G0_0_1_0_1 + 0.000270961401913831*G0_0_1_0_2 + 0.00393675768675838*G0_0_1_0_3 - 0.00165729112157713*G0_0_1_0_4 - 0.000921657707372145*G0_0_1_0_5 + 0.000340235161663788*G0_0_1_0_6 - 0.00153616225044824*G0_0_1_0_7 + 0.000815712065712223*G0_0_1_0_8 + 0.000403049331620834*G0_0_1_0_9 + 0.00480046188379607*G0_0_1_1_0 + 0.139942464942489*G0_0_1_1_1 + 0.0071167875334554*G0_0_1_1_2 + 0.0754273504273633*G0_0_1_1_3 - 0.0327852702852758*G0_0_1_1_4 - 0.00115398490398514*G0_0_1_1_5 - 0.0006511544011545*G0_0_1_1_6 - 0.020886058386062*G0_0_1_1_7 + 0.0372433122433187*G0_0_1_1_8 + 0.00532800532800628*G0_0_1_1_9 + 0.000270961401913831*G0_0_1_2_0 + 0.0071167875334554*G0_0_1_2_1 + 0.000965859537288271*G0_0_1_2_2 + 0.0097090409590426*G0_0_1_2_3 - 0.00396722325293821*G0_0_1_2_4 - 0.000204616811759701*G0_0_1_2_5 - 0.000334784263355752*G0_0_1_2_6 - 0.00113685917257365*G0_0_1_2_7 + 0.00348720723720784*G0_0_1_2_8 + 0.00247906855049755*G0_0_1_2_9 + 0.00393675768675838*G0_0_1_3_0 + 0.0754273504273633*G0_0_1_3_1 + 0.0097090409590426*G0_0_1_3_2 + 0.110864135864155*G0_0_1_3_3 - 0.0454857642357719*G0_0_1_3_4 - 0.00212162837162874*G0_0_1_3_5 - 0.00215159840159877*G0_0_1_3_6 - 0.0159153346653374*G0_0_1_3_7 + 0.0304820179820233*G0_0_1_3_8 + 0.0158466533466561*G0_0_1_3_9 - 0.00165729112157713*G0_0_1_4_0 - 0.0327852702852758*G0_0_1_4_1 - 0.00396722325293821*G0_0_1_4_2 - 0.0454857642357719*G0_0_1_4_3 + 0.0172752247752277*G0_0_1_4_4 + 0.000866811759669051*G0_0_1_4_5 + 0.00128478664192972*G0_0_1_4_6 + 0.00624375624375732*G0_0_1_4_7 - 0.0145666833166858*G0_0_1_4_8 - 0.00917082917083076*G0_0_1_4_9 - 0.000921657707372145*G0_0_1_5_0 - 0.00115398490398514*G0_0_1_5_1 - 0.000204616811759701*G0_0_1_5_2 - 0.00212162837162874*G0_0_1_5_3 + 0.000866811759669051*G0_0_1_5_4 - 0.00274261452832929*G0_0_1_5_5 + 8.04552590266941e-05*G0_0_1_5_6 + 0.00133759098044836*G0_0_1_5_7 - 0.000643106893107013*G0_0_1_5_8 + 7.70657913515203e-05*G0_0_1_5_9 + 0.000340235161663788*G0_0_1_6_0 - 0.0006511544011545*G0_0_1_6_1 - 0.000334784263355752*G0_0_1_6_2 - 0.00215159840159877*G0_0_1_6_3 + 0.00128478664192972*G0_0_1_6_4 + 8.04552590266941e-05*G0_0_1_6_5 - 0.000387826459255136*G0_0_1_6_6 - 0.000694484087341349*G0_0_1_6_7 - 0.00220154845154883*G0_0_1_6_8 - 0.00313400884829511*G0_0_1_6_9 - 0.00153616225044824*G0_0_1_7_0 - 0.020886058386062*G0_0_1_7_1 - 0.00113685917257365*G0_0_1_7_2 - 0.0159153346653374*G0_0_1_7_3 + 0.00624375624375732*G0_0_1_7_4 + 0.00133759098044836*G0_0_1_7_5 - 0.000694484087341349*G0_0_1_7_6 + 0.00972277722277889*G0_0_1_7_7 - 0.000980269730269952*G0_0_1_7_8 + 0.000179820179820203*G0_0_1_7_9 + 0.000815712065712223*G0_0_1_8_0 + 0.0372433122433187*G0_0_1_8_1 + 0.00348720723720784*G0_0_1_8_2 + 0.0304820179820233*G0_0_1_8_3 - 0.0145666833166858*G0_0_1_8_4 - 0.000643106893107013*G0_0_1_8_5 - 0.00220154845154883*G0_0_1_8_6 - 0.000980269730269952*G0_0_1_8_7 + 0.0110639360639381*G0_0_1_8_8 + 0.0131493506493529*G0_0_1_8_9 + 0.000403049331620834*G0_0_1_9_0 + 0.00532800532800628*G0_0_1_9_1 + 0.00247906855049755*G0_0_1_9_2 + 0.0158466533466561*G0_0_1_9_3 - 0.00917082917083076*G0_0_1_9_4 + 7.70657913515199e-05*G0_0_1_9_5 - 0.00313400884829511*G0_0_1_9_6 + 0.000179820179820203*G0_0_1_9_7 + 0.0131493506493529*G0_0_1_9_8 + 0.0220279720279758*G0_0_1_9_9;
    A[61] = -0.000141181569753028*G0_0_0_0_0 - 0.000810501227168027*G0_0_0_0_1 + 0.00107454494359275*G0_0_0_0_2 - 0.0025849745492607*G0_0_0_0_3 + 0.00214517625231947*G0_0_0_0_4 - 0.00166920381206124*G0_0_0_0_5 + 0.00275524079095555*G0_0_0_0_6 + 0.00054124446981599*G0_0_0_0_7 - 0.0016999072356218*G0_0_0_0_8 + 5.12582655439897e-05*G0_0_0_0_9 - 0.000810501227168027*G0_0_0_1_0 - 0.0149153315820006*G0_0_0_1_1 - 0.00095745304078653*G0_0_0_1_2 - 0.0139138639138662*G0_0_0_1_3 + 0.00850663225663368*G0_0_0_1_4 - 0.000306776556776607*G0_0_0_1_5 + 0.0021815684315688*G0_0_0_1_6 + 0.00400835275835341*G0_0_0_1_7 - 0.00926712176712326*G0_0_0_1_8 - 0.000651848151848267*G0_0_0_1_9 + 0.00107454494359275*G0_0_0_2_0 - 0.00095745304078653*G0_0_0_2_1 + 0.0173905723905753*G0_0_0_2_2 - 0.00406629085200581*G0_0_0_2_3 + 0.00650183150183259*G0_0_0_2_4 - 0.00594885273456801*G0_0_0_2_5 + 0.0132506382506405*G0_0_0_2_6 + 0.000431770610342112*G0_0_0_2_7 - 0.00117638314066905*G0_0_0_2_8 + 9.89486703772557e-05*G0_0_0_2_9 - 0.0025849745492607*G0_0_0_3_0 - 0.0139138639138662*G0_0_0_3_1 - 0.00406629085200581*G0_0_0_3_2 - 0.0297977022977074*G0_0_0_3_3 - 0.00129245754245775*G0_0_0_3_4 + 0.0042122163550742*G0_0_0_3_5 - 0.00629388468674287*G0_0_0_3_6 + 0.00800574425574561*G0_0_0_3_7 - 0.0117857142857163*G0_0_0_3_8 - 0.0140559440559464*G0_0_0_3_9 + 0.00214517625231947*G0_0_0_4_0 + 0.00850663225663368*G0_0_0_4_1 + 0.00650183150183259*G0_0_0_4_2 - 0.00129245754245775*G0_0_0_4_3 + 0.0180034251462852*G0_0_0_4_4 - 0.00618470814899489*G0_0_0_4_5 + 0.0124785928357378*G0_0_0_4_6 - 0.00399083059797412*G0_0_0_4_7 + 0.00377997002997066*G0_0_0_4_8 + 0.012072570286858*G0_0_0_4_9 - 0.00166920381206124*G0_0_0_5_0 - 0.000306776556776607*G0_0_0_5_1 - 0.00594885273456802*G0_0_0_5_2 + 0.0042122163550742*G0_0_0_5_3 - 0.00618470814899489*G0_0_0_5_4 + 0.00825281860996285*G0_0_0_5_5 - 0.0103526830312562*G0_0_0_5_6 - 0.000126659055230504*G0_0_0_5_7 + 0.00117115027829333*G0_0_0_5_8 - 0.00249607535321863*G0_0_0_5_9 + 0.00275524079095555*G0_0_0_6_0 + 0.0021815684315688*G0_0_0_6_1 + 0.0132506382506405*G0_0_0_6_2 - 0.00629388468674287*G0_0_0_6_3 + 0.0124785928357378*G0_0_0_6_4 - 0.0103526830312562*G0_0_0_6_5 + 0.0534379905808567*G0_0_0_6_6 - 0.00104449122306282*G0_0_0_6_7 - 0.00163318824033137*G0_0_0_6_8 + 0.012290923362354*G0_0_0_6_9 + 0.00054124446981599*G0_0_0_7_0 + 0.00400835275835341*G0_0_0_7_1 + 0.000431770610342112*G0_0_0_7_2 + 0.00800574425574561*G0_0_0_7_3 - 0.00399083059797412*G0_0_0_7_4 - 0.000126659055230504*G0_0_0_7_5 - 0.00104449122306282*G0_0_0_7_6 - 0.00372734408448753*G0_0_0_7_7 + 0.00753121878122*G0_0_0_7_8 + 0.00193520764949369*G0_0_0_7_9 - 0.0016999072356218*G0_0_0_8_0 - 0.00926712176712326*G0_0_0_8_1 - 0.00117638314066905*G0_0_0_8_2 - 0.0117857142857163*G0_0_0_8_3 + 0.00377997002997065*G0_0_0_8_4 + 0.00117115027829333*G0_0_0_8_5 - 0.00163318824033137*G0_0_0_8_6 + 0.00753121878122*G0_0_0_8_7 - 0.0136388611388633*G0_0_0_8_8 - 0.00560439560439653*G0_0_0_8_9 + 5.12582655439898e-05*G0_0_0_9_0 - 0.000651848151848267*G0_0_0_9_1 + 9.89486703772558e-05*G0_0_0_9_2 - 0.0140559440559464*G0_0_0_9_3 + 0.012072570286858*G0_0_0_9_4 - 0.00249607535321863*G0_0_0_9_5 + 0.012290923362354*G0_0_0_9_6 + 0.00193520764949369*G0_0_0_9_7 - 0.00560439560439653*G0_0_0_9_8 + 0.0132424718139026*G0_0_0_9_9 - 0.000965859537288285*G0_1_0_0_0 - 0.00711678753345545*G0_1_0_0_1 - 0.000270961401913829*G0_1_0_0_2 - 0.00348720723720784*G0_1_0_0_3 + 0.00113685917257365*G0_1_0_0_4 + 0.000334784263355753*G0_1_0_0_5 + 0.000204616811759701*G0_1_0_0_6 + 0.00396722325293823*G0_1_0_0_7 - 0.00970904095904264*G0_1_0_0_8 - 0.00247906855049755*G0_1_0_0_9 - 0.00711678753345545*G0_1_0_1_0 - 0.139942464942489*G0_1_0_1_1 - 0.00480046188379603*G0_1_0_1_2 - 0.0372433122433187*G0_1_0_1_3 + 0.020886058386062*G0_1_0_1_4 + 0.000651154401154568*G0_1_0_1_5 + 0.00115398490398507*G0_1_0_1_6 + 0.0327852702852759*G0_1_0_1_7 - 0.0754273504273634*G0_1_0_1_8 - 0.00532800532800627*G0_1_0_1_9 - 0.000270961401913829*G0_1_0_2_0 - 0.00480046188379603*G0_1_0_2_1 + 0.000546983880317293*G0_1_0_2_2 - 0.000815712065712203*G0_1_0_2_3 + 0.00153616225044823*G0_1_0_2_4 - 0.000340235161663788*G0_1_0_2_5 + 0.000921657707372143*G0_1_0_2_6 + 0.00165729112157712*G0_1_0_2_7 - 0.00393675768675835*G0_1_0_2_8 - 0.000403049331620827*G0_1_0_2_9 - 0.00348720723720784*G0_1_0_3_0 - 0.0372433122433187*G0_1_0_3_1 - 0.000815712065712203*G0_1_0_3_2 - 0.011063936063938*G0_1_0_3_3 + 0.000980269730269882*G0_1_0_3_4 + 0.00220154845154884*G0_1_0_3_5 + 0.000643106893106989*G0_1_0_3_6 + 0.0145666833166858*G0_1_0_3_7 - 0.0304820179820232*G0_1_0_3_8 - 0.0131493506493529*G0_1_0_3_9 + 0.00113685917257365*G0_1_0_4_0 + 0.020886058386062*G0_1_0_4_1 + 0.00153616225044823*G0_1_0_4_2 + 0.000980269730269882*G0_1_0_4_3 - 0.00972277722277888*G0_1_0_4_4 + 0.000694484087341338*G0_1_0_4_5 - 0.00133759098044834*G0_1_0_4_6 - 0.00624375624375731*G0_1_0_4_7 + 0.0159153346653374*G0_1_0_4_8 - 0.000179820179820211*G0_1_0_4_9 + 0.000334784263355753*G0_1_0_5_0 + 0.000651154401154568*G0_1_0_5_1 - 0.000340235161663788*G0_1_0_5_2 + 0.00220154845154884*G0_1_0_5_3 + 0.000694484087341338*G0_1_0_5_4 + 0.000387826459255132*G0_1_0_5_5 - 8.04552590266982e-05*G0_1_0_5_6 - 0.00128478664192973*G0_1_0_5_7 + 0.00215159840159881*G0_1_0_5_8 + 0.00313400884829509*G0_1_0_5_9 + 0.000204616811759701*G0_1_0_6_0 + 0.00115398490398507*G0_1_0_6_1 + 0.000921657707372143*G0_1_0_6_2 + 0.000643106893106989*G0_1_0_6_3 - 0.00133759098044834*G0_1_0_6_4 - 8.04552590266983e-05*G0_1_0_6_5 + 0.0027426145283293*G0_1_0_6_6 - 0.000866811759669037*G0_1_0_6_7 + 0.0021216283716287*G0_1_0_6_8 - 7.70657913515176e-05*G0_1_0_6_9 + 0.00396722325293823*G0_1_0_7_0 + 0.0327852702852759*G0_1_0_7_1 + 0.00165729112157712*G0_1_0_7_2 + 0.0145666833166858*G0_1_0_7_3 - 0.00624375624375731*G0_1_0_7_4 - 0.00128478664192973*G0_1_0_7_5 - 0.000866811759669037*G0_1_0_7_6 - 0.0172752247752277*G0_1_0_7_7 + 0.045485764235772*G0_1_0_7_8 + 0.00917082917083073*G0_1_0_7_9 - 0.00970904095904264*G0_1_0_8_0 - 0.0754273504273634*G0_1_0_8_1 - 0.00393675768675835*G0_1_0_8_2 - 0.0304820179820232*G0_1_0_8_3 + 0.0159153346653374*G0_1_0_8_4 + 0.00215159840159881*G0_1_0_8_5 + 0.0021216283716287*G0_1_0_8_6 + 0.045485764235772*G0_1_0_8_7 - 0.110864135864155*G0_1_0_8_8 - 0.015846653346656*G0_1_0_8_9 - 0.00247906855049755*G0_1_0_9_0 - 0.00532800532800627*G0_1_0_9_1 - 0.000403049331620827*G0_1_0_9_2 - 0.0131493506493529*G0_1_0_9_3 - 0.000179820179820211*G0_1_0_9_4 + 0.00313400884829509*G0_1_0_9_5 - 7.70657913515175e-05*G0_1_0_9_6 + 0.00917082917083073*G0_1_0_9_7 - 0.015846653346656*G0_1_0_9_8 - 0.0220279720279758*G0_1_0_9_9;
    A[159] = A[97] - 0.229582762916136*G0_0_0_0_0 - 0.0078652564366864*G0_0_0_0_1 - 0.00890168033025331*G0_0_0_0_2 - 0.0103613846471007*G0_0_0_0_3 + 0.0109963052820215*G0_0_0_0_4 - 0.112434232434252*G0_0_0_0_5 + 0.0627239427239536*G0_0_0_0_6 - 0.046873126873135*G0_0_0_0_7 + 0.0169030969030999*G0_0_0_0_8 + 0.00229104229104251*G0_0_0_0_9 - 0.0078652564366864*G0_0_0_1_0 - 0.0854258263782219*G0_0_0_1_1 - 0.0664097806955063*G0_0_0_1_3 + 0.0398135198135266*G0_0_0_1_4 - 0.0141499770071222*G0_0_0_1_5 + 0.0112588998303303*G0_0_0_1_6 + 0.00393067250210179*G0_0_0_1_7 - 0.0239690468261938*G0_0_0_1_8 - 0.00224537367394551*G0_0_0_1_9 - 0.00890168033025331*G0_0_0_2_0 + 0.0898229812515675*G0_0_0_2_2 - 0.0414068471211398*G0_0_0_2_3 + 0.0746732632447044*G0_0_0_2_4 - 0.026001300287019*G0_0_0_2_5 + 0.0396073767502405*G0_0_0_2_6 - 0.0105193219478951*G0_0_0_2_7 - 0.00747855319284014*G0_0_0_2_8 - 0.0111126968269844*G0_0_0_2_9 - 0.0103613846471007*G0_0_0_3_0 - 0.0664097806955063*G0_0_0_3_1 - 0.0414068471211398*G0_0_0_3_2 - 0.177262737262767*G0_0_0_3_3 - 0.00303410874839493*G0_0_0_3_4 + 0.0340002854288625*G0_0_0_3_5 - 0.0282431853860473*G0_0_0_3_6 + 0.0366176680462457*G0_0_0_3_7 - 0.0645868417297098*G0_0_0_3_8 - 0.0664992150706549*G0_0_0_3_9 + 0.0109963052820215*G0_0_0_4_0 + 0.0398135198135266*G0_0_0_4_1 + 0.0746732632447044*G0_0_0_4_2 - 0.00303410874839494*G0_0_0_4_3 + 0.196831739688916*G0_0_0_4_4 - 0.0274554017411207*G0_0_0_4_5 + 0.055698587127168*G0_0_0_4_6 - 0.00348223205366125*G0_0_0_4_7 + 0.0279691736834641*G0_0_0_4_8 + 0.0882488939631946*G0_0_0_4_9 - 0.112434232434252*G0_0_0_5_0 - 0.0141499770071222*G0_0_0_5_1 - 0.026001300287019*G0_0_0_5_2 + 0.0340002854288625*G0_0_0_5_3 - 0.0274554017411207*G0_0_0_5_4 - 0.320719280719336*G0_0_0_5_5 + 0.0089424860853449*G0_0_0_5_6 - 0.0850749250749394*G0_0_0_5_7 + 0.0479834451263104*G0_0_0_5_8 - 0.102840017125749*G0_0_0_5_9 + 0.0627239427239536*G0_0_0_6_0 + 0.0112588998303303*G0_0_0_6_1 + 0.0396073767502405*G0_0_0_6_2 - 0.0282431853860473*G0_0_0_6_3 + 0.055698587127168*G0_0_0_6_4 + 0.0089424860853449*G0_0_0_6_5 + 0.0975938347367085*G0_0_0_6_6 + 0.037091479948629*G0_0_0_6_7 - 0.00843727700870705*G0_0_0_6_8 + 0.0898244612530478*G0_0_0_6_9 - 0.046873126873135*G0_0_0_7_0 + 0.00393067250210179*G0_0_0_7_1 - 0.0105193219478951*G0_0_0_7_2 + 0.0366176680462457*G0_0_0_7_3 - 0.00348223205366125*G0_0_0_7_4 - 0.0850749250749394*G0_0_0_7_5 + 0.037091479948629*G0_0_0_7_6 - 0.281558441558489*G0_0_0_7_7 + 0.0762922791494349*G0_0_0_7_8 - 0.081056086770386*G0_0_0_7_9 + 0.0169030969030999*G0_0_0_8_0 - 0.0239690468261938*G0_0_0_8_1 - 0.00747855319284014*G0_0_0_8_2 - 0.0645868417297098*G0_0_0_8_3 + 0.0279691736834641*G0_0_0_8_4 + 0.0479834451263104*G0_0_0_8_5 - 0.00843727700870705*G0_0_0_8_6 + 0.0762922791494349*G0_0_0_8_7 - 0.166816041101784*G0_0_0_8_8 - 0.0492022263450918*G0_0_0_8_9 + 0.00229104229104251*G0_0_0_9_0 - 0.00224537367394551*G0_0_0_9_1 - 0.0111126968269844*G0_0_0_9_2 - 0.0664992150706549*G0_0_0_9_3 + 0.0882488939631945*G0_0_0_9_4 - 0.102840017125749*G0_0_0_9_5 + 0.0898244612530478*G0_0_0_9_6 - 0.081056086770386*G0_0_0_9_7 - 0.0492022263450918*G0_0_0_9_8 - 0.120222634508369*G0_0_0_9_9 - 0.00438355295498227*G0_0_1_0_1 + 0.00438355295498229*G0_0_1_0_2 - 0.00995956424528025*G0_0_1_0_3 + 0.00995956424528025*G0_0_1_0_4 + 0.0276479076479124*G0_0_1_0_5 - 0.00217560217560255*G0_0_1_0_6 - 0.0276479076479121*G0_0_1_0_7 + 0.00217560217560242*G0_0_1_0_8 - 0.00438355295498227*G0_0_1_1_0 - 0.0865813551527985*G0_0_1_1_1 - 0.0704317904318025*G0_0_1_1_3 + 0.0401956773385413*G0_0_1_1_4 + 0.0142885685742853*G0_0_1_1_5 + 0.00900623186337625*G0_0_1_1_6 - 0.0012422498136785*G0_0_1_1_7 - 0.0260945403802592*G0_0_1_1_8 + 0.0100337757480631*G0_0_1_1_9 + 0.00438355295498229*G0_0_1_2_0 + 0.086581355152798*G0_0_1_2_2 - 0.0401956773385412*G0_0_1_2_3 + 0.0704317904318023*G0_0_1_2_4 + 0.00124224981367867*G0_0_1_2_5 + 0.026094540380259*G0_0_1_2_6 - 0.0142885685742852*G0_0_1_2_7 - 0.00900623186337624*G0_0_1_2_8 - 0.0100337757480631*G0_0_1_2_9 - 0.00995956424528025*G0_0_1_3_0 - 0.0704317904318025*G0_0_1_3_1 - 0.0401956773385412*G0_0_1_3_2 - 0.180625089196549*G0_0_1_3_3 - 0.00649350649350749*G0_0_1_3_5 - 0.0270186955901287*G0_0_1_3_6 + 0.0298786927358408*G0_0_1_3_7 - 0.0568973883259694*G0_0_1_3_8 - 0.0898587127158708*G0_0_1_3_9 + 0.00995956424528025*G0_0_1_4_0 + 0.0401956773385413*G0_0_1_4_1 + 0.0704317904318023*G0_0_1_4_2 + 0.180625089196549*G0_0_1_4_4 - 0.0298786927358407*G0_0_1_4_5 + 0.0568973883259694*G0_0_1_4_6 + 0.00649350649350752*G0_0_1_4_7 + 0.0270186955901287*G0_0_1_4_8 + 0.0898587127158707*G0_0_1_4_9 + 0.0276479076479124*G0_0_1_5_0 + 0.0142885685742853*G0_0_1_5_1 + 0.00124224981367867*G0_0_1_5_2 - 0.00649350649350749*G0_0_1_5_3 - 0.0298786927358407*G0_0_1_5_4 + 0.525074925075013*G0_0_1_5_5 - 0.112755815612978*G0_0_1_5_6 - 0.0428657057228558*G0_0_1_5_8 + 0.0857314114457118*G0_0_1_5_9 - 0.00217560217560255*G0_0_1_6_0 + 0.00900623186337625*G0_0_1_6_1 + 0.026094540380259*G0_0_1_6_2 - 0.0270186955901287*G0_0_1_6_3 + 0.0568973883259694*G0_0_1_6_4 - 0.112755815612978*G0_0_1_6_5 + 0.16952761524193*G0_0_1_6_6 + 0.0428657057228556*G0_0_1_6_7 + 0.0841387184244468*G0_0_1_6_9 - 0.0276479076479121*G0_0_1_7_0 - 0.0012422498136785*G0_0_1_7_1 - 0.0142885685742852*G0_0_1_7_2 + 0.0298786927358408*G0_0_1_7_3 + 0.00649350649350751*G0_0_1_7_4 + 0.0428657057228556*G0_0_1_7_6 - 0.525074925075012*G0_0_1_7_7 + 0.112755815612977*G0_0_1_7_8 - 0.0857314114457115*G0_0_1_7_9 + 0.00217560217560242*G0_0_1_8_0 - 0.0260945403802592*G0_0_1_8_1 - 0.00900623186337624*G0_0_1_8_2 - 0.0568973883259694*G0_0_1_8_3 + 0.0270186955901287*G0_0_1_8_4 - 0.0428657057228558*G0_0_1_8_5 + 0.112755815612977*G0_0_1_8_7 - 0.169527615241929*G0_0_1_8_8 - 0.084138718424447*G0_0_1_8_9 + 0.0100337757480631*G0_0_1_9_1 - 0.0100337757480631*G0_0_1_9_2 - 0.0898587127158708*G0_0_1_9_3 + 0.0898587127158707*G0_0_1_9_4 + 0.0857314114457118*G0_0_1_9_5 + 0.0841387184244468*G0_0_1_9_6 - 0.0857314114457115*G0_0_1_9_7 - 0.084138718424447*G0_0_1_9_8 - 0.000981522886284997*G0_1_0_0_1 + 0.000981522886284954*G0_1_0_0_2 - 0.0116112458969622*G0_1_0_0_3 + 0.0116112458969622*G0_1_0_0_4 + 0.00340548340548377*G0_1_0_0_5 + 0.0146076146076172*G0_1_0_0_6 - 0.00340548340548418*G0_1_0_0_7 - 0.014607614607617*G0_1_0_0_8 - 0.000981522886284997*G0_1_0_1_0 - 0.0890880548023557*G0_1_0_1_1 - 0.0703112760255737*G0_1_0_1_3 + 0.0409612609612679*G0_1_0_1_4 - 0.00736977308406004*G0_1_0_1_5 + 0.00823176823176964*G0_1_0_1_6 + 0.00639899782757037*G0_1_0_1_7 - 0.0298171669600292*G0_1_0_1_8 - 0.00200371057513952*G0_1_0_1_9 + 0.000981522886284954*G0_1_0_2_0 + 0.0890880548023555*G0_1_0_2_2 - 0.0409612609612678*G0_1_0_2_3 + 0.0703112760255736*G0_1_0_2_4 - 0.00639899782757035*G0_1_0_2_5 + 0.0298171669600291*G0_1_0_2_6 + 0.00736977308406003*G0_1_0_2_7 - 0.0082317682317696*G0_1_0_2_8 + 0.00200371057513946*G0_1_0_2_9 - 0.0116112458969622*G0_1_0_3_0 - 0.0703112760255737*G0_1_0_3_1 - 0.0409612609612679*G0_1_0_3_2 - 0.189770229770262*G0_1_0_3_3 + 0.0284715284715332*G0_1_0_3_5 - 0.0246953046953089*G0_1_0_3_6 + 0.0348337376908864*G0_1_0_3_7 - 0.0595290423861953*G0_1_0_3_8 - 0.0636563436563545*G0_1_0_3_9 + 0.0116112458969622*G0_1_0_4_0 + 0.0409612609612679*G0_1_0_4_1 + 0.0703112760255736*G0_1_0_4_2 + 0.189770229770262*G0_1_0_4_4 - 0.0348337376908864*G0_1_0_4_5 + 0.0595290423861953*G0_1_0_4_6 - 0.0284715284715333*G0_1_0_4_7 + 0.0246953046953089*G0_1_0_4_8 + 0.0636563436563544*G0_1_0_4_9 + 0.00340548340548377*G0_1_0_5_0 - 0.00736977308406004*G0_1_0_5_1 - 0.00639899782757035*G0_1_0_5_2 + 0.0284715284715332*G0_1_0_5_3 - 0.0348337376908864*G0_1_0_5_4 - 0.0687312687312804*G0_1_0_5_5 - 0.0757528186099743*G0_1_0_5_6 + 0.0221093192521801*G0_1_0_5_8 - 0.0442186385043603*G0_1_0_5_9 + 0.0146076146076172*G0_1_0_6_0 + 0.00823176823176964*G0_1_0_6_1 + 0.0298171669600292*G0_1_0_6_2 - 0.0246953046953089*G0_1_0_6_3 + 0.0595290423861953*G0_1_0_6_4 - 0.0757528186099743*G0_1_0_6_5 + 0.122374768089075*G0_1_0_6_6 - 0.02210931925218*G0_1_0_6_7 + 0.0433794776651993*G0_1_0_6_9 - 0.00340548340548418*G0_1_0_7_0 + 0.00639899782757037*G0_1_0_7_1 + 0.00736977308406003*G0_1_0_7_2 + 0.0348337376908864*G0_1_0_7_3 - 0.0284715284715333*G0_1_0_7_4 - 0.0221093192521801*G0_1_0_7_6 + 0.0687312687312802*G0_1_0_7_7 + 0.0757528186099743*G0_1_0_7_8 + 0.0442186385043603*G0_1_0_7_9 - 0.014607614607617*G0_1_0_8_0 - 0.0298171669600292*G0_1_0_8_1 - 0.00823176823176961*G0_1_0_8_2 - 0.0595290423861953*G0_1_0_8_3 + 0.0246953046953089*G0_1_0_8_4 + 0.0221093192521801*G0_1_0_8_5 + 0.0757528186099743*G0_1_0_8_7 - 0.122374768089075*G0_1_0_8_8 - 0.0433794776651993*G0_1_0_8_9 - 0.00200371057513952*G0_1_0_9_1 + 0.00200371057513946*G0_1_0_9_2 - 0.0636563436563545*G0_1_0_9_3 + 0.0636563436563544*G0_1_0_9_4 - 0.0442186385043603*G0_1_0_9_5 + 0.0433794776651993*G0_1_0_9_6 + 0.0442186385043603*G0_1_0_9_7 - 0.0433794776651993*G0_1_0_9_8 + 0.229582762916135*G0_1_1_0_0 + 0.00890168033025328*G0_1_1_0_1 + 0.00786525643668634*G0_1_1_0_2 - 0.0109963052820216*G0_1_1_0_3 + 0.0103613846471008*G0_1_1_0_4 + 0.0468731268731348*G0_1_1_0_5 - 0.0169030969030997*G0_1_1_0_6 + 0.112434232434251*G0_1_1_0_7 - 0.0627239427239534*G0_1_1_0_8 - 0.00229104229104253*G0_1_1_0_9 + 0.00890168033025328*G0_1_1_1_0 - 0.089822981251568*G0_1_1_1_1 - 0.0746732632447046*G0_1_1_1_3 + 0.0414068471211399*G0_1_1_1_4 + 0.0105193219478952*G0_1_1_1_5 + 0.00747855319284018*G0_1_1_1_6 + 0.026001300287019*G0_1_1_1_7 - 0.0396073767502407*G0_1_1_1_8 + 0.0111126968269844*G0_1_1_1_9 + 0.00786525643668634*G0_1_1_2_0 + 0.0854258263782217*G0_1_1_2_2 - 0.0398135198135265*G0_1_1_2_3 + 0.0664097806955062*G0_1_1_2_4 - 0.00393067250210173*G0_1_1_2_5 + 0.0239690468261937*G0_1_1_2_6 + 0.0141499770071222*G0_1_1_2_7 - 0.0112588998303303*G0_1_1_2_8 + 0.00224537367394548*G0_1_1_2_9 - 0.0109963052820216*G0_1_1_3_0 - 0.0746732632447045*G0_1_1_3_1 - 0.0398135198135265*G0_1_1_3_2 - 0.196831739688916*G0_1_1_3_3 + 0.00303410874839501*G0_1_1_3_4 + 0.00348223205366124*G0_1_1_3_5 - 0.0279691736834641*G0_1_1_3_6 + 0.0274554017411206*G0_1_1_3_7 - 0.055698587127168*G0_1_1_3_8 - 0.0882488939631947*G0_1_1_3_9 + 0.0103613846471008*G0_1_1_4_0 + 0.0414068471211399*G0_1_1_4_1 + 0.0664097806955062*G0_1_1_4_2 + 0.00303410874839501*G0_1_1_4_3 + 0.177262737262767*G0_1_1_4_4 - 0.0366176680462457*G0_1_1_4_5 + 0.0645868417297098*G0_1_1_4_6 - 0.0340002854288626*G0_1_1_4_7 + 0.0282431853860473*G0_1_1_4_8 + 0.0664992150706548*G0_1_1_4_9 + 0.0468731268731348*G0_1_1_5_0 + 0.0105193219478952*G0_1_1_5_1 - 0.00393067250210173*G0_1_1_5_2 + 0.00348223205366124*G0_1_1_5_3 - 0.0366176680462457*G0_1_1_5_4 + 0.281558441558488*G0_1_1_5_5 - 0.0762922791494349*G0_1_1_5_6 + 0.0850749250749393*G0_1_1_5_7 - 0.037091479948629*G0_1_1_5_8 + 0.0810560867703861*G0_1_1_5_9 - 0.0169030969030997*G0_1_1_6_0 + 0.00747855319284018*G0_1_1_6_1 + 0.0239690468261937*G0_1_1_6_2 - 0.0279691736834641*G0_1_1_6_3 + 0.0645868417297098*G0_1_1_6_4 - 0.0762922791494349*G0_1_1_6_5 + 0.166816041101784*G0_1_1_6_6 - 0.0479834451263103*G0_1_1_6_7 + 0.00843727700870699*G0_1_1_6_8 + 0.0492022263450918*G0_1_1_6_9 + 0.112434232434251*G0_1_1_7_0 + 0.026001300287019*G0_1_1_7_1 + 0.0141499770071222*G0_1_1_7_2 + 0.0274554017411206*G0_1_1_7_3 - 0.0340002854288626*G0_1_1_7_4 + 0.0850749250749393*G0_1_1_7_5 - 0.0479834451263103*G0_1_1_7_6 + 0.320719280719335*G0_1_1_7_7 - 0.00894248608534479*G0_1_1_7_8 + 0.102840017125749*G0_1_1_7_9 - 0.0627239427239534*G0_1_1_8_0 - 0.0396073767502407*G0_1_1_8_1 - 0.0112588998303303*G0_1_1_8_2 - 0.055698587127168*G0_1_1_8_3 + 0.0282431853860473*G0_1_1_8_4 - 0.037091479948629*G0_1_1_8_5 + 0.00843727700870698*G0_1_1_8_6 - 0.00894248608534479*G0_1_1_8_7 - 0.0975938347367084*G0_1_1_8_8 - 0.0898244612530479*G0_1_1_8_9 - 0.00229104229104253*G0_1_1_9_0 + 0.0111126968269844*G0_1_1_9_1 + 0.00224537367394548*G0_1_1_9_2 - 0.0882488939631947*G0_1_1_9_3 + 0.0664992150706548*G0_1_1_9_4 + 0.0810560867703861*G0_1_1_9_5 + 0.0492022263450918*G0_1_1_9_6 + 0.102840017125749*G0_1_1_9_7 - 0.0898244612530479*G0_1_1_9_8 + 0.120222634508369*G0_1_1_9_9;
    A[79] = A[65] - 0.00203309917595668*G0_0_1_0_0 - 0.000699335937431298*G0_0_1_0_1 + 0.000741974075307536*G0_0_1_0_2 + 0.00285999714571192*G0_0_1_0_3 - 0.0279244564958899*G0_0_1_0_4 + 0.00669362383648212*G0_0_1_0_5 - 0.00856349999207289*G0_0_1_0_6 + 0.00323739752311236*G0_0_1_0_7 + 0.000598132026703567*G0_0_1_0_8 - 0.0181494695780441*G0_0_1_0_9 - 0.000699335937431298*G0_0_1_1_0 + 0.000473600473600564*G0_0_1_1_1 - 0.00266005599338978*G0_0_1_1_2 + 0.0104162504162522*G0_0_1_1_3 - 0.0162047476333219*G0_0_1_1_4 + 0.00363446077731854*G0_0_1_1_5 - 0.00626611483754448*G0_0_1_1_6 - 0.000167451596023058*G0_0_1_1_7 + 0.00311688311688366*G0_0_1_1_8 - 0.00611198325484144*G0_0_1_1_9 + 0.000741974075307535*G0_0_1_2_0 - 0.00266005599338978*G0_0_1_2_1 - 0.000749867416534079*G0_0_1_2_2 + 0.0143412143412168*G0_0_1_2_3 - 0.0198912198912233*G0_0_1_2_4 - 0.00244200244200288*G0_0_1_2_5 + 0.00435120435120512*G0_0_1_2_6 - 0.00133200133200156*G0_0_1_2_7 + 0.000319680319680372*G0_0_1_2_8 + 0.00719280719280841*G0_0_1_2_9 + 0.00285999714571192*G0_0_1_3_0 + 0.0104162504162522*G0_0_1_3_1 + 0.0143412143412168*G0_0_1_3_2 - 0.0684344227201485*G0_0_1_3_3 + 0.065934065934077*G0_0_1_3_4 - 0.0140088482945649*G0_0_1_3_5 + 0.0273326673326719*G0_0_1_3_6 - 0.00752961324390022*G0_0_1_3_8 + 0.0184272869987186*G0_0_1_3_9 - 0.0279244564958899*G0_0_1_4_0 - 0.0162047476333219*G0_0_1_4_1 - 0.0198912198912233*G0_0_1_4_2 + 0.065934065934077*G0_0_1_4_3 - 0.62481518481529*G0_0_1_4_4 + 0.0923076923077079*G0_0_1_4_5 - 0.11964035964038*G0_0_1_4_6 + 0.0396175253318177*G0_0_1_4_7 + 0.00757528186099743*G0_0_1_4_8 - 0.206193806193841*G0_0_1_4_9 + 0.00669362383648212*G0_0_1_5_0 + 0.00363446077731854*G0_0_1_5_1 - 0.00244200244200288*G0_0_1_5_2 - 0.0140088482945649*G0_0_1_5_3 + 0.0923076923077079*G0_0_1_5_4 - 0.0212815755672934*G0_0_1_5_5 + 0.0289310689310738*G0_0_1_5_6 - 0.0101612673041262*G0_0_1_5_7 - 0.00236905951191706*G0_0_1_5_8 + 0.0591865277579663*G0_0_1_5_9 - 0.00856349999207289*G0_0_1_6_0 - 0.00626611483754448*G0_0_1_6_1 + 0.00435120435120512*G0_0_1_6_2 + 0.0273326673326719*G0_0_1_6_3 - 0.11964035964038*G0_0_1_6_4 + 0.0289310689310738*G0_0_1_6_5 - 0.0310089910089962*G0_0_1_6_6 + 0.0125303268160432*G0_0_1_6_7 + 0.00465249036677687*G0_0_1_6_8 - 0.0762437562437691*G0_0_1_6_9 + 0.00323739752311236*G0_0_1_7_0 - 0.000167451596023057*G0_0_1_7_1 - 0.00133200133200156*G0_0_1_7_2 + 0.0396175253318177*G0_0_1_7_4 - 0.0101612673041262*G0_0_1_7_5 + 0.0125303268160432*G0_0_1_7_6 - 0.00349364920793561*G0_0_1_7_7 - 0.000770657913515202*G0_0_1_7_8 + 0.0293877551020458*G0_0_1_7_9 + 0.000598132026703566*G0_0_1_8_0 + 0.00311688311688366*G0_0_1_8_1 + 0.000319680319680372*G0_0_1_8_2 - 0.00752961324390022*G0_0_1_8_3 + 0.00757528186099743*G0_0_1_8_4 - 0.00236905951191706*G0_0_1_8_5 + 0.00465249036677687*G0_0_1_8_6 - 0.000770657913515202*G0_0_1_8_7 + 0.00565149136577805*G0_0_1_8_8 + 0.00318538604252943*G0_0_1_8_9 - 0.0181494695780441*G0_0_1_9_0 - 0.00611198325484144*G0_0_1_9_1 + 0.00719280719280841*G0_0_1_9_2 + 0.0184272869987186*G0_0_1_9_3 - 0.206193806193841*G0_0_1_9_4 + 0.0591865277579663*G0_0_1_9_5 - 0.0762437562437691*G0_0_1_9_6 + 0.0293877551020458*G0_0_1_9_7 + 0.00318538604252942*G0_0_1_9_8 - 0.170161267304153*G0_0_1_9_9 + 0.00203309917595668*G0_1_0_0_0 + 0.000699335937431298*G0_1_0_0_1 - 0.000741974075307536*G0_1_0_0_2 - 0.00285999714571192*G0_1_0_0_3 + 0.0279244564958899*G0_1_0_0_4 - 0.00669362383648212*G0_1_0_0_5 + 0.00856349999207289*G0_1_0_0_6 - 0.00323739752311236*G0_1_0_0_7 - 0.000598132026703567*G0_1_0_0_8 + 0.0181494695780441*G0_1_0_0_9 + 0.000699335937431298*G0_1_0_1_0 - 0.000473600473600564*G0_1_0_1_1 + 0.00266005599338978*G0_1_0_1_2 - 0.0104162504162522*G0_1_0_1_3 + 0.0162047476333219*G0_1_0_1_4 - 0.00363446077731854*G0_1_0_1_5 + 0.00626611483754448*G0_1_0_1_6 + 0.000167451596023058*G0_1_0_1_7 - 0.00311688311688366*G0_1_0_1_8 + 0.00611198325484144*G0_1_0_1_9 - 0.000741974075307537*G0_1_0_2_0 + 0.00266005599338978*G0_1_0_2_1 + 0.000749867416534079*G0_1_0_2_2 - 0.0143412143412168*G0_1_0_2_3 + 0.0198912198912233*G0_1_0_2_4 + 0.00244200244200288*G0_1_0_2_5 - 0.00435120435120513*G0_1_0_2_6 + 0.00133200133200156*G0_1_0_2_7 - 0.000319680319680372*G0_1_0_2_8 - 0.00719280719280841*G0_1_0_2_9 - 0.00285999714571192*G0_1_0_3_0 - 0.0104162504162522*G0_1_0_3_1 - 0.0143412143412168*G0_1_0_3_2 + 0.0684344227201485*G0_1_0_3_3 - 0.065934065934077*G0_1_0_3_4 + 0.0140088482945649*G0_1_0_3_5 - 0.0273326673326719*G0_1_0_3_6 + 0.00752961324390022*G0_1_0_3_8 - 0.0184272869987186*G0_1_0_3_9 + 0.0279244564958899*G0_1_0_4_0 + 0.0162047476333219*G0_1_0_4_1 + 0.0198912198912233*G0_1_0_4_2 - 0.065934065934077*G0_1_0_4_3 + 0.62481518481529*G0_1_0_4_4 - 0.0923076923077079*G0_1_0_4_5 + 0.11964035964038*G0_1_0_4_6 - 0.0396175253318177*G0_1_0_4_7 - 0.00757528186099743*G0_1_0_4_8 + 0.206193806193841*G0_1_0_4_9 - 0.00669362383648212*G0_1_0_5_0 - 0.00363446077731854*G0_1_0_5_1 + 0.00244200244200288*G0_1_0_5_2 + 0.0140088482945649*G0_1_0_5_3 - 0.0923076923077079*G0_1_0_5_4 + 0.0212815755672934*G0_1_0_5_5 - 0.0289310689310738*G0_1_0_5_6 + 0.0101612673041262*G0_1_0_5_7 + 0.00236905951191706*G0_1_0_5_8 - 0.0591865277579663*G0_1_0_5_9 + 0.00856349999207289*G0_1_0_6_0 + 0.00626611483754448*G0_1_0_6_1 - 0.00435120435120512*G0_1_0_6_2 - 0.0273326673326719*G0_1_0_6_3 + 0.11964035964038*G0_1_0_6_4 - 0.0289310689310738*G0_1_0_6_5 + 0.0310089910089962*G0_1_0_6_6 - 0.0125303268160432*G0_1_0_6_7 - 0.00465249036677687*G0_1_0_6_8 + 0.0762437562437691*G0_1_0_6_9 - 0.00323739752311236*G0_1_0_7_0 + 0.000167451596023057*G0_1_0_7_1 + 0.00133200133200156*G0_1_0_7_2 - 0.0396175253318177*G0_1_0_7_4 + 0.0101612673041262*G0_1_0_7_5 - 0.0125303268160432*G0_1_0_7_6 + 0.00349364920793561*G0_1_0_7_7 + 0.000770657913515202*G0_1_0_7_8 - 0.0293877551020458*G0_1_0_7_9 - 0.000598132026703566*G0_1_0_8_0 - 0.00311688311688366*G0_1_0_8_1 - 0.000319680319680372*G0_1_0_8_2 + 0.00752961324390022*G0_1_0_8_3 - 0.00757528186099743*G0_1_0_8_4 + 0.00236905951191706*G0_1_0_8_5 - 0.00465249036677687*G0_1_0_8_6 + 0.000770657913515201*G0_1_0_8_7 - 0.00565149136577805*G0_1_0_8_8 - 0.00318538604252942*G0_1_0_8_9 + 0.0181494695780441*G0_1_0_9_0 + 0.00611198325484144*G0_1_0_9_1 - 0.00719280719280841*G0_1_0_9_2 - 0.0184272869987186*G0_1_0_9_3 + 0.206193806193841*G0_1_0_9_4 - 0.0591865277579663*G0_1_0_9_5 + 0.0762437562437691*G0_1_0_9_6 - 0.0293877551020458*G0_1_0_9_7 - 0.00318538604252942*G0_1_0_9_8 + 0.170161267304153*G0_1_0_9_9;
    A[154] = A[70] - 0.00141340141340175*G0_0_1_0_0 - 0.000920005920006119*G0_0_1_0_1 + 0.000257176685748161*G0_0_1_0_2 + 0.00128752200180796*G0_0_1_0_3 - 0.00175800390086135*G0_0_1_0_4 + 0.000609866324152135*G0_0_1_0_5 - 0.000452642595499803*G0_0_1_0_6 + 0.00104514533085976*G0_0_1_0_7 + 0.00583535512107041*G0_0_1_0_8 - 0.00381761096046875*G0_0_1_0_9 - 0.000920005920006119*G0_0_1_1_0 - 0.11901061901064*G0_0_1_1_1 - 0.00092000592000609*G0_0_1_1_2 + 0.000166500166500001*G0_0_1_1_3 + 0.00475191475191563*G0_0_1_1_4 - 0.00113719613719629*G0_0_1_1_5 - 0.00113719613719633*G0_0_1_1_6 + 0.0047519147519157*G0_0_1_1_7 + 0.000166500166499847*G0_0_1_1_8 + 0.0115084915084934*G0_0_1_1_9 + 0.000257176685748161*G0_0_1_2_0 - 0.000920005920006089*G0_0_1_2_1 - 0.00141340141340163*G0_0_1_2_2 + 0.00583535512107039*G0_0_1_2_3 + 0.00104514533085981*G0_0_1_2_4 - 0.000452642595499831*G0_0_1_2_5 + 0.000609866324152181*G0_0_1_2_6 - 0.00175800390086133*G0_0_1_2_7 + 0.00128752200180793*G0_0_1_2_8 - 0.00381761096046873*G0_0_1_2_9 + 0.00128752200180796*G0_0_1_3_0 + 0.000166500166499998*G0_0_1_3_1 + 0.00583535512107039*G0_0_1_3_2 + 0.188751248751281*G0_0_1_3_3 - 0.0348101898101957*G0_0_1_3_4 + 0.000742828599971603*G0_0_1_3_5 + 0.00147495361781098*G0_0_1_3_6 - 0.0057992007992018*G0_0_1_3_7 + 0.0115984015984035*G0_0_1_3_8 - 0.0229270729270766*G0_0_1_3_9 - 0.00175800390086135*G0_0_1_4_0 + 0.00475191475191563*G0_0_1_4_1 + 0.00104514533085981*G0_0_1_4_2 - 0.0348101898101957*G0_0_1_4_3 - 0.0131482802911397*G0_0_1_4_4 + 0.00333737690880604*G0_0_1_4_5 - 0.00481233052661703*G0_0_1_4_6 + 0.00624232909947299*G0_0_1_4_7 - 0.00579920079920176*G0_0_1_4_8 + 0.0047780790637941*G0_0_1_4_9 + 0.000609866324152135*G0_0_1_5_0 - 0.00113719613719629*G0_0_1_5_1 - 0.000452642595499831*G0_0_1_5_2 + 0.000742828599971602*G0_0_1_5_3 + 0.00333737690880604*G0_0_1_5_4 + 0.0014942200656491*G0_0_1_5_5 + 0.00236121021835344*G0_0_1_5_6 - 0.00481233052661703*G0_0_1_5_7 + 0.00147495361781099*G0_0_1_5_8 + 0.00850292564578422*G0_0_1_5_9 - 0.000452642595499803*G0_0_1_6_0 - 0.00113719613719633*G0_0_1_6_1 + 0.000609866324152181*G0_0_1_6_2 + 0.00147495361781098*G0_0_1_6_3 - 0.00481233052661703*G0_0_1_6_4 + 0.00236121021835344*G0_0_1_6_5 + 0.00149422006564917*G0_0_1_6_6 + 0.00333737690880602*G0_0_1_6_7 + 0.000742828599971591*G0_0_1_6_8 + 0.00850292564578424*G0_0_1_6_9 + 0.00104514533085976*G0_0_1_7_0 + 0.0047519147519157*G0_0_1_7_1 - 0.00175800390086133*G0_0_1_7_2 - 0.0057992007992018*G0_0_1_7_3 + 0.00624232909947299*G0_0_1_7_4 - 0.00481233052661703*G0_0_1_7_5 + 0.00333737690880602*G0_0_1_7_6 - 0.0131482802911393*G0_0_1_7_7 - 0.0348101898101956*G0_0_1_7_8 + 0.00477807906379417*G0_0_1_7_9 + 0.00583535512107041*G0_0_1_8_0 + 0.000166500166499842*G0_0_1_8_1 + 0.00128752200180793*G0_0_1_8_2 + 0.0115984015984035*G0_0_1_8_3 - 0.00579920079920176*G0_0_1_8_4 + 0.00147495361781099*G0_0_1_8_5 + 0.00074282859997159*G0_0_1_8_6 - 0.0348101898101956*G0_0_1_8_7 + 0.188751248751281*G0_0_1_8_8 - 0.0229270729270767*G0_0_1_8_9 - 0.00381761096046875*G0_0_1_9_0 + 0.0115084915084934*G0_0_1_9_1 - 0.00381761096046873*G0_0_1_9_2 - 0.0229270729270766*G0_0_1_9_3 + 0.0047780790637941*G0_0_1_9_4 + 0.00850292564578422*G0_0_1_9_5 + 0.00850292564578424*G0_0_1_9_6 + 0.00477807906379417*G0_0_1_9_7 - 0.0229270729270767*G0_0_1_9_8 - 0.120685029256478*G0_0_1_9_9 + 0.00141340141340175*G0_1_0_0_0 + 0.000920005920006119*G0_1_0_0_1 - 0.000257176685748161*G0_1_0_0_2 - 0.00128752200180796*G0_1_0_0_3 + 0.00175800390086135*G0_1_0_0_4 - 0.000609866324152135*G0_1_0_0_5 + 0.000452642595499803*G0_1_0_0_6 - 0.00104514533085976*G0_1_0_0_7 - 0.00583535512107041*G0_1_0_0_8 + 0.00381761096046875*G0_1_0_0_9 + 0.000920005920006119*G0_1_0_1_0 + 0.11901061901064*G0_1_0_1_1 + 0.000920005920006089*G0_1_0_1_2 - 0.000166500166500005*G0_1_0_1_3 - 0.00475191475191563*G0_1_0_1_4 + 0.00113719613719629*G0_1_0_1_5 + 0.00113719613719633*G0_1_0_1_6 - 0.0047519147519157*G0_1_0_1_7 - 0.00016650016649985*G0_1_0_1_8 - 0.0115084915084934*G0_1_0_1_9 - 0.000257176685748161*G0_1_0_2_0 + 0.000920005920006089*G0_1_0_2_1 + 0.00141340141340163*G0_1_0_2_2 - 0.00583535512107039*G0_1_0_2_3 - 0.00104514533085981*G0_1_0_2_4 + 0.000452642595499831*G0_1_0_2_5 - 0.000609866324152181*G0_1_0_2_6 + 0.00175800390086133*G0_1_0_2_7 - 0.00128752200180793*G0_1_0_2_8 + 0.00381761096046873*G0_1_0_2_9 - 0.00128752200180796*G0_1_0_3_0 - 0.000166500166500001*G0_1_0_3_1 - 0.00583535512107039*G0_1_0_3_2 - 0.188751248751281*G0_1_0_3_3 + 0.0348101898101957*G0_1_0_3_4 - 0.000742828599971602*G0_1_0_3_5 - 0.00147495361781098*G0_1_0_3_6 + 0.0057992007992018*G0_1_0_3_7 - 0.0115984015984035*G0_1_0_3_8 + 0.0229270729270766*G0_1_0_3_9 + 0.00175800390086135*G0_1_0_4_0 - 0.00475191475191563*G0_1_0_4_1 - 0.00104514533085981*G0_1_0_4_2 + 0.0348101898101957*G0_1_0_4_3 + 0.0131482802911397*G0_1_0_4_4 - 0.00333737690880604*G0_1_0_4_5 + 0.00481233052661703*G0_1_0_4_6 - 0.00624232909947299*G0_1_0_4_7 + 0.00579920079920176*G0_1_0_4_8 - 0.0047780790637941*G0_1_0_4_9 - 0.000609866324152135*G0_1_0_5_0 + 0.00113719613719629*G0_1_0_5_1 + 0.000452642595499831*G0_1_0_5_2 - 0.000742828599971602*G0_1_0_5_3 - 0.00333737690880604*G0_1_0_5_4 - 0.0014942200656491*G0_1_0_5_5 - 0.00236121021835344*G0_1_0_5_6 + 0.00481233052661703*G0_1_0_5_7 - 0.00147495361781099*G0_1_0_5_8 - 0.00850292564578422*G0_1_0_5_9 + 0.000452642595499803*G0_1_0_6_0 + 0.00113719613719633*G0_1_0_6_1 - 0.000609866324152181*G0_1_0_6_2 - 0.00147495361781098*G0_1_0_6_3 + 0.00481233052661703*G0_1_0_6_4 - 0.00236121021835344*G0_1_0_6_5 - 0.00149422006564917*G0_1_0_6_6 - 0.00333737690880602*G0_1_0_6_7 - 0.00074282859997159*G0_1_0_6_8 - 0.00850292564578424*G0_1_0_6_9 - 0.00104514533085976*G0_1_0_7_0 - 0.0047519147519157*G0_1_0_7_1 + 0.00175800390086133*G0_1_0_7_2 + 0.0057992007992018*G0_1_0_7_3 - 0.00624232909947299*G0_1_0_7_4 + 0.00481233052661703*G0_1_0_7_5 - 0.00333737690880602*G0_1_0_7_6 + 0.0131482802911393*G0_1_0_7_7 + 0.0348101898101956*G0_1_0_7_8 - 0.00477807906379417*G0_1_0_7_9 - 0.00583535512107041*G0_1_0_8_0 - 0.000166500166499845*G0_1_0_8_1 - 0.00128752200180793*G0_1_0_8_2 - 0.0115984015984035*G0_1_0_8_3 + 0.00579920079920176*G0_1_0_8_4 - 0.00147495361781099*G0_1_0_8_5 - 0.00074282859997159*G0_1_0_8_6 + 0.0348101898101956*G0_1_0_8_7 - 0.188751248751281*G0_1_0_8_8 + 0.0229270729270767*G0_1_0_8_9 + 0.00381761096046875*G0_1_0_9_0 - 0.0115084915084934*G0_1_0_9_1 + 0.00381761096046873*G0_1_0_9_2 + 0.0229270729270766*G0_1_0_9_3 - 0.0047780790637941*G0_1_0_9_4 - 0.00850292564578422*G0_1_0_9_5 - 0.00850292564578424*G0_1_0_9_6 - 0.00477807906379417*G0_1_0_9_7 + 0.0229270729270767*G0_1_0_9_8 + 0.120685029256478*G0_1_0_9_9;
    A[106] = -0.00165920499253863*G0_0_0_0_0 - 0.000148328303090244*G0_0_0_0_1 - 0.000265107467488465*G0_0_0_0_2 - 8.25166896595651e-05*G0_0_0_0_3 + 0.00017044463473038*G0_0_0_0_4 - 0.00331010259581745*G0_0_0_0_5 + 0.000302653695510907*G0_0_0_0_6 - 0.000261048475334231*G0_0_0_0_7 + 0.000297500118928729*G0_0_0_0_8 - 0.000490818705104504*G0_0_0_0_9 - 0.000148328303090244*G0_0_0_1_0 - 0.00168535168535219*G0_0_0_1_1 - 0.00023995625186106*G0_0_0_1_2 - 0.00142302142302171*G0_0_0_1_3 + 0.00118145743145765*G0_0_0_1_4 + 0.000406042370328154*G0_0_0_1_5 + 0.000690638726353132*G0_0_0_1_6 + 0.000564851814851961*G0_0_0_1_7 - 0.00038211788211806*G0_0_0_1_8 - 0.000800033300033447*G0_0_0_1_9 - 0.000265107467488465*G0_0_0_2_0 - 0.00023995625186106*G0_0_0_2_1 - 0.0113344063344082*G0_0_0_2_2 + 0.000282138496424254*G0_0_0_2_3 + 0.000122655122655149*G0_0_0_2_4 - 0.000303942089656438*G0_0_0_2_5 - 0.00238150738150775*G0_0_0_2_6 + 0.000145588538445707*G0_0_0_2_7 - 0.000268045446616927*G0_0_0_2_8 + 0.00111126968269844*G0_0_0_2_9 - 8.2516689659565e-05*G0_0_0_3_0 - 0.00142302142302171*G0_0_0_3_1 + 0.000282138496424254*G0_0_0_3_2 - 0.00384865134865198*G0_0_0_3_3 - 0.00248233908948236*G0_0_0_3_4 - 0.000530184101612756*G0_0_0_3_5 - 0.00198212501783962*G0_0_0_3_6 + 0.000337341230198442*G0_0_0_3_7 - 0.00123126873126897*G0_0_0_3_8 + 0.00172541743970345*G0_0_0_3_9 + 0.00017044463473038*G0_0_0_4_0 + 0.00118145743145765*G0_0_0_4_1 + 0.000122655122655149*G0_0_0_4_2 - 0.00248233908948236*G0_0_0_4_3 + 0.0116897388325979*G0_0_0_4_4 - 0.000421542742971383*G0_0_0_4_5 + 0.00240366776081101*G0_0_0_4_6 - 0.000518945340374003*G0_0_0_4_7 + 0.00089392750107053*G0_0_0_4_8 - 0.00249072356215257*G0_0_0_4_9 - 0.00331010259581745*G0_0_0_5_0 + 0.000406042370328154*G0_0_0_5_1 - 0.000303942089656438*G0_0_0_5_2 - 0.000530184101612756*G0_0_0_5_3 - 0.000421542742971383*G0_0_0_5_4 + 0.01254923647781*G0_0_0_5_5 + 0.00698604966462226*G0_0_0_5_6 + 0.00147531040388208*G0_0_0_5_7 - 0.00112833594976471*G0_0_0_5_8 + 0.00372912801484293*G0_0_0_5_9 + 0.000302653695510907*G0_0_0_6_0 + 0.000690638726353132*G0_0_0_6_1 - 0.00238150738150775*G0_0_0_6_2 - 0.00198212501783962*G0_0_0_6_3 + 0.00240366776081101*G0_0_0_6_4 + 0.00698604966462226*G0_0_0_6_5 + 0.0479834451263104*G0_0_0_6_6 - 0.000346974454117365*G0_0_0_6_7 - 0.000678785500214172*G0_0_0_6_8 + 0.000630440987583918*G0_0_0_6_9 - 0.000261048475334231*G0_0_0_7_0 + 0.000564851814851961*G0_0_0_7_1 + 0.000145588538445707*G0_0_0_7_2 + 0.000337341230198442*G0_0_0_7_3 - 0.000518945340374003*G0_0_0_7_4 + 0.00147531040388208*G0_0_0_7_5 - 0.000346974454117365*G0_0_0_7_6 + 0.00361602683031313*G0_0_0_7_7 - 0.00134882974168705*G0_0_0_7_8 + 0.00216640502354825*G0_0_0_7_9 + 0.000297500118928729*G0_0_0_8_0 - 0.00038211788211806*G0_0_0_8_1 - 0.000268045446616927*G0_0_0_8_2 - 0.00123126873126897*G0_0_0_8_3 + 0.00089392750107053*G0_0_0_8_4 - 0.00112833594976471*G0_0_0_8_5 - 0.000678785500214172*G0_0_0_8_6 - 0.00134882974168705*G0_0_0_8_7 - 0.000806693306693603*G0_0_0_8_8 + 0.000612244897959275*G0_0_0_8_9 - 0.000490818705104504*G0_0_0_9_0 - 0.000800033300033447*G0_0_0_9_1 + 0.00111126968269844*G0_0_0_9_2 + 0.00172541743970345*G0_0_0_9_3 - 0.00249072356215257*G0_0_0_9_4 + 0.00372912801484292*G0_0_0_9_5 + 0.000630440987583918*G0_0_0_9_6 + 0.00216640502354825*G0_0_0_9_7 + 0.000612244897959275*G0_0_0_9_8 - 0.0196132438989615*G0_0_0_9_9 + 0.00967520134186971*G0_1_0_0_0 + 9.16279487708138e-05*G0_1_0_0_1 + 0.000185528756957352*G0_1_0_0_3 + 2.48560962846742e-05*G0_1_0_0_4 - 0.000928595214309647*G0_1_0_0_5 + 0.000606595785167318*G0_1_0_0_6 - 0.000383703597989344*G0_1_0_0_7 + 1.53616225044576e-05*G0_1_0_0_8 - 0.00160208838780294*G0_1_0_0_9 + 9.16279487708137e-05*G0_1_0_1_0 - 9.16279487708291e-05*G0_1_0_1_2 - 0.00104090354090379*G0_1_0_1_3 + 0.000616605616605755*G0_1_0_1_4 - 0.000284596356024968*G0_1_0_1_5 + 0.000284596356024978*G0_1_0_1_6 - 0.000616605616605663*G0_1_0_1_7 + 0.0010409035409036*G0_1_0_1_8 - 9.16279487708291e-05*G0_1_0_2_1 - 0.00967520134186962*G0_1_0_2_2 - 1.5361622504488e-05*G0_1_0_2_3 + 0.00038370359798938*G0_1_0_2_4 - 0.000606595785167326*G0_1_0_2_5 + 0.000928595214309676*G0_1_0_2_6 - 2.4856096284667e-05*G0_1_0_2_7 - 0.000185528756957367*G0_1_0_2_8 + 0.00160208838780294*G0_1_0_2_9 + 0.000185528756957352*G0_1_0_3_0 - 0.00104090354090379*G0_1_0_3_1 - 1.53616225044881e-05*G0_1_0_3_2 - 0.00304195804195858*G0_1_0_3_3 - 0.00113350934779523*G0_1_0_3_4 + 0.000148601398601409*G0_1_0_3_5 - 0.000853789068074915*G0_1_0_3_6 - 0.000556586270872061*G0_1_0_3_7 + 0.00111317254174416*G0_1_0_3_9 + 2.48560962846743e-05*G0_1_0_4_0 + 0.000616605616605755*G0_1_0_4_1 + 0.000383703597989381*G0_1_0_4_2 - 0.00113350934779523*G0_1_0_4_3 + 0.00807371200228473*G0_1_0_4_4 - 7.45682888540108e-05*G0_1_0_4_5 + 0.000928357356928934*G0_1_0_4_6 + 0.000556586270872105*G0_1_0_4_8 - 0.00465712858570081*G0_1_0_4_9 - 0.000928595214309648*G0_1_0_5_0 - 0.000284596356024968*G0_1_0_5_1 - 0.000606595785167326*G0_1_0_5_2 + 0.000148601398601409*G0_1_0_5_3 - 7.45682888540108e-05*G0_1_0_5_4 - 0.0354342086485002*G0_1_0_5_5 - 0.000928357356928912*G0_1_0_5_7 + 0.000853789068074908*G0_1_0_5_8 + 0.003098687027259*G0_1_0_5_9 + 0.000606595785167318*G0_1_0_6_0 + 0.000284596356024978*G0_1_0_6_1 + 0.000928595214309677*G0_1_0_6_2 - 0.000853789068074915*G0_1_0_6_3 + 0.000928357356928934*G0_1_0_6_4 + 0.0354342086485004*G0_1_0_6_6 + 7.4568288854009e-05*G0_1_0_6_7 - 0.000148601398601409*G0_1_0_6_8 - 0.003098687027259*G0_1_0_6_9 - 0.000383703597989344*G0_1_0_7_0 - 0.000616605616605663*G0_1_0_7_1 - 2.48560962846669e-05*G0_1_0_7_2 - 0.000556586270872061*G0_1_0_7_3 - 0.000928357356928911*G0_1_0_7_5 + 7.45682888540088e-05*G0_1_0_7_6 - 0.00807371200228477*G0_1_0_7_7 + 0.00113350934779529*G0_1_0_7_8 + 0.00465712858570081*G0_1_0_7_9 + 1.5361622504458e-05*G0_1_0_8_0 + 0.0010409035409036*G0_1_0_8_1 - 0.000185528756957367*G0_1_0_8_2 + 0.000556586270872105*G0_1_0_8_4 + 0.000853789068074908*G0_1_0_8_5 - 0.000148601398601409*G0_1_0_8_6 + 0.00113350934779529*G0_1_0_8_7 + 0.00304195804195841*G0_1_0_8_8 - 0.00111317254174417*G0_1_0_8_9 - 0.00160208838780294*G0_1_0_9_0 + 0.00160208838780294*G0_1_0_9_2 + 0.00111317254174416*G0_1_0_9_3 - 0.00465712858570081*G0_1_0_9_4 + 0.003098687027259*G0_1_0_9_5 - 0.003098687027259*G0_1_0_9_6 + 0.00465712858570081*G0_1_0_9_7 - 0.00111317254174417*G0_1_0_9_8;
    A[60] = A[106] + 0.000488559059987719*G0_0_0_0_3 + 0.000520194091622755*G0_0_0_0_4 + 0.00188708117279576*G0_0_0_0_5 + 0.000878803735946738*G0_0_0_0_6 - 0.000121069406783779*G0_0_0_0_7 + 0.000267351695923207*G0_0_0_0_8 - 0.000309214594928942*G0_0_0_0_9 - 0.00188708117279573*G0_0_0_1_3 - 0.000878803735946758*G0_0_0_1_4 - 0.000488559059987717*G0_0_0_1_5 - 0.000520194091622753*G0_0_0_1_6 - 0.000267351695923229*G0_0_0_1_7 + 0.000121069406783827*G0_0_0_1_8 + 0.00030921459492894*G0_0_0_1_9 - 0.000586080586080695*G0_0_0_2_3 - 0.0025041625041629*G0_0_0_2_4 + 0.00058608058608069*G0_0_0_2_5 + 0.0025041625041629*G0_0_0_2_6 - 0.000413633985062631*G0_0_0_2_7 + 0.000413633985062633*G0_0_0_2_8 + 0.000488559059987719*G0_0_0_3_0 - 0.00188708117279573*G0_0_0_3_1 - 0.000586080586080695*G0_0_0_3_2 + 0.0163978878264619*G0_0_0_3_3 + 0.00946838875410462*G0_0_0_3_4 + 0.00156058227486824*G0_0_0_3_6 - 0.00146567717996315*G0_0_0_3_7 + 0.00270657913515104*G0_0_0_3_8 + 0.00200371057513948*G0_0_0_3_9 + 0.000520194091622754*G0_0_0_4_0 - 0.000878803735946758*G0_0_0_4_1 - 0.0025041625041629*G0_0_0_4_2 + 0.00946838875410462*G0_0_0_4_3 + 0.0362937062937125*G0_0_0_4_4 - 0.00156058227486824*G0_0_0_4_5 - 0.000159840159840177*G0_0_0_4_7 - 0.0012409019551879*G0_0_0_4_8 + 0.00312116454973649*G0_0_0_4_9 + 0.00188708117279576*G0_0_0_5_0 - 0.000488559059987717*G0_0_0_5_1 + 0.00058608058608069*G0_0_0_5_2 - 0.00156058227486824*G0_0_0_5_4 - 0.016397887826462*G0_0_0_5_5 - 0.00946838875410461*G0_0_0_5_6 - 0.00270657913515104*G0_0_0_5_7 + 0.00146567717996314*G0_0_0_5_8 - 0.00200371057513947*G0_0_0_5_9 + 0.000878803735946738*G0_0_0_6_0 - 0.000520194091622753*G0_0_0_6_1 + 0.0025041625041629*G0_0_0_6_2 + 0.00156058227486824*G0_0_0_6_3 - 0.00946838875410462*G0_0_0_6_5 - 0.0362937062937125*G0_0_0_6_6 + 0.00124090195518789*G0_0_0_6_7 + 0.000159840159840172*G0_0_0_6_8 - 0.0031211645497365*G0_0_0_6_9 - 0.000121069406783779*G0_0_0_7_0 - 0.000267351695923229*G0_0_0_7_1 - 0.000413633985062631*G0_0_0_7_2 - 0.00146567717996315*G0_0_0_7_3 - 0.000159840159840177*G0_0_0_7_4 - 0.00270657913515104*G0_0_0_7_5 + 0.00124090195518789*G0_0_0_7_6 - 0.00442272013700668*G0_0_0_7_7 - 0.00155416012558896*G0_0_0_7_9 + 0.000267351695923207*G0_0_0_8_0 + 0.000121069406783827*G0_0_0_8_1 + 0.000413633985062633*G0_0_0_8_2 + 0.00270657913515104*G0_0_0_8_3 - 0.0012409019551879*G0_0_0_8_4 + 0.00146567717996314*G0_0_0_8_5 + 0.000159840159840172*G0_0_0_8_6 + 0.00442272013700673*G0_0_0_8_8 + 0.00155416012558898*G0_0_0_8_9 - 0.000309214594928942*G0_0_0_9_0 + 0.00030921459492894*G0_0_0_9_1 + 0.00200371057513948*G0_0_0_9_3 + 0.00312116454973649*G0_0_0_9_4 - 0.00200371057513947*G0_0_0_9_5 - 0.0031211645497365*G0_0_0_9_6 - 0.00155416012558897*G0_0_0_9_7 + 0.00155416012558898*G0_0_0_9_8 - 0.00168535168535206*G0_0_1_0_0 - 0.000148328303090239*G0_0_1_0_1 - 0.000239956251861062*G0_0_1_0_2 + 0.000406042370328155*G0_0_1_0_3 + 0.000690638726353132*G0_0_1_0_4 - 0.00142302142302168*G0_0_1_0_5 + 0.00118145743145764*G0_0_1_0_6 - 0.000382117882118006*G0_0_1_0_7 + 0.000564851814851934*G0_0_1_0_8 - 0.000800033300033447*G0_0_1_0_9 - 0.000148328303090239*G0_0_1_1_0 - 0.0016592049925386*G0_0_1_1_1 - 0.000265107467488467*G0_0_1_1_2 - 0.00331010259581743*G0_0_1_1_3 + 0.000302653695510894*G0_0_1_1_4 + 0.000170444634730375*G0_0_1_1_6 + 0.000297500118928733*G0_0_1_1_7 - 0.000261048475334232*G0_0_1_1_8 - 0.000490818705104506*G0_0_1_1_9 - 0.000239956251861062*G0_0_1_2_0 - 0.000265107467488467*G0_0_1_2_1 - 0.0113344063344083*G0_0_1_2_2 - 0.00030394208965642*G0_0_1_2_3 - 0.00238150738150779*G0_0_1_2_4 + 0.000282138496424275*G0_0_1_2_5 + 0.000122655122655106*G0_0_1_2_6 - 0.000268045446616923*G0_0_1_2_7 + 0.000145588538445705*G0_0_1_2_8 + 0.00111126968269844*G0_0_1_2_9 + 0.000406042370328155*G0_0_1_3_0 - 0.00331010259581743*G0_0_1_3_1 - 0.00030394208965642*G0_0_1_3_2 + 0.0125492364778099*G0_0_1_3_3 + 0.00698604966462226*G0_0_1_3_4 - 0.000530184101612761*G0_0_1_3_5 - 0.000421542742971366*G0_0_1_3_6 - 0.0011283359497647*G0_0_1_3_7 + 0.00147531040388207*G0_0_1_3_8 + 0.00372912801484292*G0_0_1_3_9 + 0.000690638726353132*G0_0_1_4_0 + 0.000302653695510894*G0_0_1_4_1 - 0.00238150738150779*G0_0_1_4_2 + 0.00698604966462226*G0_0_1_4_3 + 0.0479834451263103*G0_0_1_4_4 - 0.00198212501783962*G0_0_1_4_5 + 0.00240366776081099*G0_0_1_4_6 - 0.00067878550021418*G0_0_1_4_7 - 0.000346974454117365*G0_0_1_4_8 + 0.000630440987583905*G0_0_1_4_9 - 0.00142302142302168*G0_0_1_5_0 + 0.000282138496424275*G0_0_1_5_2 - 0.000530184101612761*G0_0_1_5_3 - 0.00198212501783962*G0_0_1_5_4 - 0.00384865134865202*G0_0_1_5_5 - 0.00248233908948235*G0_0_1_5_6 - 0.00123126873126896*G0_0_1_5_7 + 0.000337341230198437*G0_0_1_5_8 + 0.00172541743970346*G0_0_1_5_9 + 0.00118145743145764*G0_0_1_6_0 + 0.000170444634730375*G0_0_1_6_1 + 0.000122655122655106*G0_0_1_6_2 - 0.000421542742971366*G0_0_1_6_3 + 0.00240366776081099*G0_0_1_6_4 - 0.00248233908948235*G0_0_1_6_5 + 0.0116897388325978*G0_0_1_6_6 + 0.000893927501070522*G0_0_1_6_7 - 0.000518945340373995*G0_0_1_6_8 - 0.0024907235621526*G0_0_1_6_9 - 0.000382117882118007*G0_0_1_7_0 + 0.000297500118928733*G0_0_1_7_1 - 0.000268045446616923*G0_0_1_7_2 - 0.0011283359497647*G0_0_1_7_3 - 0.000678785500214179*G0_0_1_7_4 - 0.00123126873126896*G0_0_1_7_5 + 0.000893927501070522*G0_0_1_7_6 - 0.000806693306693547*G0_0_1_7_7 - 0.00134882974168706*G0_0_1_7_8 + 0.000612244897959291*G0_0_1_7_9 + 0.000564851814851935*G0_0_1_8_0 - 0.000261048475334232*G0_0_1_8_1 + 0.000145588538445705*G0_0_1_8_2 + 0.00147531040388207*G0_0_1_8_3 - 0.000346974454117365*G0_0_1_8_4 + 0.000337341230198437*G0_0_1_8_5 - 0.000518945340373995*G0_0_1_8_6 - 0.00134882974168706*G0_0_1_8_7 + 0.00361602683031311*G0_0_1_8_8 + 0.00216640502354824*G0_0_1_8_9 - 0.000800033300033447*G0_0_1_9_0 - 0.000490818705104506*G0_0_1_9_1 + 0.00111126968269844*G0_0_1_9_2 + 0.00372912801484292*G0_0_1_9_3 + 0.000630440987583905*G0_0_1_9_4 + 0.00172541743970346*G0_0_1_9_5 - 0.0024907235621526*G0_0_1_9_6 + 0.000612244897959291*G0_0_1_9_7 + 0.00216640502354824*G0_0_1_9_8 - 0.0196132438989615*G0_0_1_9_9 - 0.0113605530272218*G0_1_0_0_0 - 0.000331584200631876*G0_1_0_0_1 - 0.000148328303090237*G0_1_0_0_2 + 0.000505109969395781*G0_1_0_0_3 + 0.000381186274043483*G0_1_0_0_4 + 0.00054647733219169*G0_1_0_0_5 - 0.00103931782503237*G0_1_0_0_7 + 0.00116609580895319*G0_1_0_0_8 + 0.0008020550877695*G0_1_0_0_9 - 0.000331584200631876*G0_1_0_1_0 - 0.0113344063344081*G0_1_0_1_1 - 0.000173479518717636*G0_1_0_1_2 - 0.00134060384060401*G0_1_0_1_3 - 0.000920547706262171*G0_1_0_1_4 - 0.000139007817579272*G0_1_0_1_6 + 0.000898744113029926*G0_1_0_1_7 - 0.000918248418248477*G0_1_0_1_8 + 0.00111126968269845*G0_1_0_1_9 - 0.000148328303090237*G0_1_0_2_0 - 0.000173479518717636*G0_1_0_2_1 + 0.00801599634933103*G0_1_0_2_2 + 0.000318015318015366*G0_1_0_2_3 - 0.0036938061938068*G0_1_0_2_4 + 0.000904095904096065*G0_1_0_2_5 - 0.0011896436896439*G0_1_0_2_6 + 0.000355973391687744*G0_1_0_2_8 - 0.00209290709290744*G0_1_0_2_9 + 0.000505109969395781*G0_1_0_3_0 - 0.00134060384060401*G0_1_0_3_1 + 0.000318015318015367*G0_1_0_3_2 + 0.0510254031682689*G0_1_0_3_3 + 0.0081195590124175*G0_1_0_3_4 - 0.000827386898815579*G0_1_0_3_5 + 0.000506814613957546*G0_1_0_3_6 - 0.00142553874696757*G0_1_0_3_7 + 0.00240366776081105*G0_1_0_3_8 - 0.000482731554160203*G0_1_0_3_9 + 0.000381186274043483*G0_1_0_4_0 - 0.000920547706262171*G0_1_0_4_1 - 0.0036938061938068*G0_1_0_4_2 + 0.0081195590124175*G0_1_0_4_3 + 0.00447552447552535*G0_1_0_4_4 - 0.0010537676609107*G0_1_0_4_5 + 0.000546953046953155*G0_1_0_4_6 - 0.000530184101612755*G0_1_0_4_7 - 0.000978129013843487*G0_1_0_4_8 + 0.00838625660054374*G0_1_0_4_9 + 0.00054647733219169*G0_1_0_5_0 + 0.000904095904096065*G0_1_0_5_2 - 0.000827386898815579*G0_1_0_5_3 - 0.0010537676609107*G0_1_0_5_4 + 0.0346275153418068*G0_1_0_5_5 - 0.00134882974168711*G0_1_0_5_6 - 0.00030291137434004*G0_1_0_5_7 - 0.00248644212929971*G0_1_0_5_9 - 0.000139007817579272*G0_1_0_6_1 - 0.0011896436896439*G0_1_0_6_2 + 0.000506814613957546*G0_1_0_6_3 + 0.000546953046953155*G0_1_0_6_4 - 0.0013488297416871*G0_1_0_6_5 - 0.0318181818181872*G0_1_0_6_6 + 0.000262772941344426*G0_1_0_6_7 - 0.00037034394177259*G0_1_0_6_8 + 0.00526509205080724*G0_1_0_6_9 - 0.00103931782503237*G0_1_0_7_0 + 0.000898744113029926*G0_1_0_7_1 - 0.00142553874696757*G0_1_0_7_3 - 0.000530184101612755*G0_1_0_7_4 - 0.00030291137434004*G0_1_0_7_5 + 0.000262772941344426*G0_1_0_7_6 + 0.0042250606536327*G0_1_0_7_7 - 0.00361584843727762*G0_1_0_7_8 - 0.00293171114599737*G0_1_0_7_9 + 0.00116609580895319*G0_1_0_8_0 - 0.000918248418248476*G0_1_0_8_1 + 0.000355973391687744*G0_1_0_8_2 + 0.00240366776081105*G0_1_0_8_3 - 0.000978129013843487*G0_1_0_8_4 - 0.00037034394177259*G0_1_0_8_6 - 0.00361584843727762*G0_1_0_8_7 + 0.00864778079063953*G0_1_0_8_8 - 0.00137755102040837*G0_1_0_8_9 + 0.0008020550877695*G0_1_0_9_0 + 0.00111126968269845*G0_1_0_9_1 - 0.00209290709290744*G0_1_0_9_2 - 0.000482731554160203*G0_1_0_9_3 + 0.00838625660054374*G0_1_0_9_4 - 0.00248644212929971*G0_1_0_9_5 + 0.00526509205080724*G0_1_0_9_6 - 0.00293171114599737*G0_1_0_9_7 - 0.00137755102040837*G0_1_0_9_8 - 0.0196132438989615*G0_1_0_9_9 - 0.00168535168535209*G0_1_1_0_0 - 0.000239956251861065*G0_1_1_0_1 - 0.000148328303090237*G0_1_1_0_2 + 0.000690638726353131*G0_1_1_0_3 + 0.000406042370328157*G0_1_1_0_4 - 0.000382117882117966*G0_1_1_0_5 + 0.000564851814851924*G0_1_1_0_6 - 0.00142302142302173*G0_1_1_0_7 + 0.00118145743145766*G0_1_1_0_8 - 0.000800033300033443*G0_1_1_0_9 - 0.000239956251861065*G0_1_1_1_0 - 0.0113344063344083*G0_1_1_1_1 - 0.000265107467488468*G0_1_1_1_2 - 0.0023815073815078*G0_1_1_1_3 - 0.000303942089656416*G0_1_1_1_4 - 0.00026804544661692*G0_1_1_1_5 + 0.000145588538445706*G0_1_1_1_6 + 0.000282138496424264*G0_1_1_1_7 + 0.000122655122655107*G0_1_1_1_8 + 0.00111126968269844*G0_1_1_1_9 - 0.000148328303090237*G0_1_1_2_0 - 0.000265107467488468*G0_1_1_2_1 - 0.00165920499253864*G0_1_1_2_2 + 0.000302653695510889*G0_1_1_2_3 - 0.00331010259581744*G0_1_1_2_4 + 0.000297500118928745*G0_1_1_2_5 - 0.000261048475334241*G0_1_1_2_6 + 0.000170444634730375*G0_1_1_2_8 - 0.000490818705104501*G0_1_1_2_9 + 0.000690638726353131*G0_1_1_3_0 - 0.0023815073815078*G0_1_1_3_1 + 0.00030265369551089*G0_1_1_3_2 + 0.0479834451263103*G0_1_1_3_3 + 0.00698604966462228*G0_1_1_3_4 - 0.000678785500214169*G0_1_1_3_5 - 0.000346974454117364*G0_1_1_3_6 - 0.00198212501783962*G0_1_1_3_7 + 0.00240366776081099*G0_1_1_3_8 + 0.00063044098758394*G0_1_1_3_9 + 0.000406042370328157*G0_1_1_4_0 - 0.000303942089656416*G0_1_1_4_1 - 0.00331010259581744*G0_1_1_4_2 + 0.00698604966462228*G0_1_1_4_3 + 0.0125492364778101*G0_1_1_4_4 - 0.00112833594976471*G0_1_1_4_5 + 0.00147531040388208*G0_1_1_4_6 - 0.000530184101612767*G0_1_1_4_7 - 0.000421542742971375*G0_1_1_4_8 + 0.00372912801484293*G0_1_1_4_9 - 0.000382117882117966*G0_1_1_5_0 - 0.00026804544661692*G0_1_1_5_1 + 0.000297500118928746*G0_1_1_5_2 - 0.000678785500214169*G0_1_1_5_3 - 0.00112833594976471*G0_1_1_5_4 - 0.000806693306693451*G0_1_1_5_5 - 0.00134882974168712*G0_1_1_5_6 - 0.00123126873126896*G0_1_1_5_7 + 0.000893927501070521*G0_1_1_5_8 + 0.000612244897959286*G0_1_1_5_9 + 0.000564851814851924*G0_1_1_6_0 + 0.000145588538445706*G0_1_1_6_1 - 0.000261048475334241*G0_1_1_6_2 - 0.000346974454117364*G0_1_1_6_3 + 0.00147531040388208*G0_1_1_6_4 - 0.00134882974168712*G0_1_1_6_5 + 0.00361602683031312*G0_1_1_6_6 + 0.000337341230198439*G0_1_1_6_7 - 0.000518945340373998*G0_1_1_6_8 + 0.00216640502354823*G0_1_1_6_9 - 0.00142302142302173*G0_1_1_7_0 + 0.000282138496424264*G0_1_1_7_1 - 0.00198212501783962*G0_1_1_7_3 - 0.000530184101612767*G0_1_1_7_4 - 0.00123126873126896*G0_1_1_7_5 + 0.000337341230198439*G0_1_1_7_6 - 0.00384865134865211*G0_1_1_7_7 - 0.00248233908948229*G0_1_1_7_8 + 0.00172541743970344*G0_1_1_7_9 + 0.00118145743145766*G0_1_1_8_0 + 0.000122655122655108*G0_1_1_8_1 + 0.000170444634730375*G0_1_1_8_2 + 0.00240366776081099*G0_1_1_8_3 - 0.000421542742971375*G0_1_1_8_4 + 0.000893927501070521*G0_1_1_8_5 - 0.000518945340373998*G0_1_1_8_6 - 0.00248233908948229*G0_1_1_8_7 + 0.0116897388325979*G0_1_1_8_8 - 0.00249072356215256*G0_1_1_8_9 - 0.000800033300033443*G0_1_1_9_0 + 0.00111126968269844*G0_1_1_9_1 - 0.000490818705104501*G0_1_1_9_2 + 0.00063044098758394*G0_1_1_9_3 + 0.00372912801484293*G0_1_1_9_4 + 0.000612244897959285*G0_1_1_9_5 + 0.00216640502354823*G0_1_1_9_6 + 0.00172541743970344*G0_1_1_9_7 - 0.00249072356215256*G0_1_1_9_8 - 0.0196132438989615*G0_1_1_9_9;
    A[4] = A[60] + 0.000284596356024978*G0_0_1_0_3 - 0.000284596356024974*G0_0_1_0_4 + 0.00104090354090373*G0_0_1_0_5 - 0.000616605616605722*G0_0_1_0_6 - 0.0010409035409037*G0_0_1_0_7 + 0.000616605616605714*G0_0_1_0_8 - 0.00967520134186971*G0_0_1_1_1 + 0.000928595214309638*G0_0_1_1_3 - 0.000606595785167312*G0_0_1_1_4 - 0.000185528756957357*G0_0_1_1_5 + 0.000383703597989352*G0_0_1_1_8 + 0.00160208838780294*G0_0_1_1_9 + 0.00967520134186971*G0_0_1_2_2 + 0.000606595785167307*G0_0_1_2_3 - 0.000928595214309652*G0_0_1_2_4 - 0.000383703597989346*G0_0_1_2_6 + 0.000185528756957362*G0_0_1_2_7 - 0.00160208838780294*G0_0_1_2_9 + 0.000284596356024978*G0_0_1_3_0 + 0.000928595214309639*G0_0_1_3_1 + 0.000606595785167308*G0_0_1_3_2 + 0.0354342086485004*G0_0_1_3_3 - 0.000148601398601411*G0_0_1_3_5 - 0.000853789068074924*G0_0_1_3_7 + 0.000928357356928937*G0_0_1_3_8 - 0.00309868702725897*G0_0_1_3_9 - 0.000284596356024975*G0_0_1_4_0 - 0.000606595785167312*G0_0_1_4_1 - 0.000928595214309652*G0_0_1_4_2 - 0.0354342086485003*G0_0_1_4_4 + 0.000853789068074903*G0_0_1_4_5 - 0.000928357356928914*G0_0_1_4_6 + 0.000148601398601413*G0_0_1_4_7 + 0.00309868702725903*G0_0_1_4_9 + 0.00104090354090373*G0_0_1_5_0 - 0.000185528756957357*G0_0_1_5_1 - 0.000148601398601411*G0_0_1_5_3 + 0.000853789068074903*G0_0_1_5_4 + 0.00304195804195859*G0_0_1_5_5 + 0.00113350934779522*G0_0_1_5_6 + 0.000556586270872077*G0_0_1_5_8 - 0.00111317254174418*G0_0_1_5_9 - 0.000616605616605722*G0_0_1_6_0 - 0.000383703597989346*G0_0_1_6_2 - 0.000928357356928913*G0_0_1_6_4 + 0.00113350934779522*G0_0_1_6_5 - 0.00807371200228474*G0_0_1_6_6 - 0.00055658627087209*G0_0_1_6_7 + 0.00465712858570082*G0_0_1_6_9 - 0.0010409035409037*G0_0_1_7_0 + 0.000185528756957362*G0_0_1_7_2 - 0.000853789068074924*G0_0_1_7_3 + 0.000148601398601413*G0_0_1_7_4 - 0.000556586270872089*G0_0_1_7_6 - 0.00304195804195851*G0_0_1_7_7 - 0.00113350934779527*G0_0_1_7_8 + 0.00111317254174415*G0_0_1_7_9 + 0.000616605616605715*G0_0_1_8_0 + 0.000383703597989353*G0_0_1_8_1 + 0.000928357356928937*G0_0_1_8_3 + 0.000556586270872077*G0_0_1_8_5 - 0.00113350934779527*G0_0_1_8_7 + 0.00807371200228484*G0_0_1_8_8 - 0.00465712858570079*G0_0_1_8_9 + 0.00160208838780294*G0_0_1_9_1 - 0.00160208838780294*G0_0_1_9_2 - 0.00309868702725897*G0_0_1_9_3 + 0.00309868702725903*G0_0_1_9_4 - 0.00111317254174418*G0_0_1_9_5 + 0.00465712858570082*G0_0_1_9_6 + 0.00111317254174415*G0_0_1_9_7 - 0.00465712858570079*G0_0_1_9_8 - 0.000284596356024978*G0_1_0_0_3 + 0.000284596356024974*G0_1_0_0_4 - 0.00104090354090373*G0_1_0_0_5 + 0.000616605616605722*G0_1_0_0_6 + 0.0010409035409037*G0_1_0_0_7 - 0.000616605616605714*G0_1_0_0_8 + 0.00967520134186971*G0_1_0_1_1 - 0.000928595214309639*G0_1_0_1_3 + 0.000606595785167312*G0_1_0_1_4 + 0.000185528756957356*G0_1_0_1_5 - 0.000383703597989352*G0_1_0_1_8 - 0.00160208838780294*G0_1_0_1_9 - 0.00967520134186971*G0_1_0_2_2 - 0.000606595785167307*G0_1_0_2_3 + 0.000928595214309652*G0_1_0_2_4 + 0.000383703597989346*G0_1_0_2_6 - 0.000185528756957362*G0_1_0_2_7 + 0.00160208838780294*G0_1_0_2_9 - 0.000284596356024978*G0_1_0_3_0 - 0.000928595214309639*G0_1_0_3_1 - 0.000606595785167308*G0_1_0_3_2 - 0.0354342086485004*G0_1_0_3_3 + 0.000148601398601411*G0_1_0_3_5 + 0.000853789068074924*G0_1_0_3_7 - 0.000928357356928938*G0_1_0_3_8 + 0.00309868702725897*G0_1_0_3_9 + 0.000284596356024975*G0_1_0_4_0 + 0.000606595785167312*G0_1_0_4_1 + 0.000928595214309652*G0_1_0_4_2 + 0.0354342086485003*G0_1_0_4_4 - 0.000853789068074903*G0_1_0_4_5 + 0.000928357356928914*G0_1_0_4_6 - 0.000148601398601413*G0_1_0_4_7 - 0.00309868702725903*G0_1_0_4_9 - 0.00104090354090373*G0_1_0_5_0 + 0.000185528756957357*G0_1_0_5_1 + 0.000148601398601411*G0_1_0_5_3 - 0.000853789068074903*G0_1_0_5_4 - 0.00304195804195859*G0_1_0_5_5 - 0.00113350934779522*G0_1_0_5_6 - 0.000556586270872077*G0_1_0_5_8 + 0.00111317254174418*G0_1_0_5_9 + 0.000616605616605722*G0_1_0_6_0 + 0.000383703597989346*G0_1_0_6_2 + 0.000928357356928913*G0_1_0_6_4 - 0.00113350934779522*G0_1_0_6_5 + 0.00807371200228474*G0_1_0_6_6 + 0.000556586270872089*G0_1_0_6_7 - 0.00465712858570082*G0_1_0_6_9 + 0.0010409035409037*G0_1_0_7_0 - 0.000185528756957362*G0_1_0_7_2 + 0.000853789068074924*G0_1_0_7_3 - 0.000148601398601413*G0_1_0_7_4 + 0.00055658627087209*G0_1_0_7_6 + 0.00304195804195851*G0_1_0_7_7 + 0.00113350934779527*G0_1_0_7_8 - 0.00111317254174415*G0_1_0_7_9 - 0.000616605616605715*G0_1_0_8_0 - 0.000383703597989353*G0_1_0_8_1 - 0.000928357356928937*G0_1_0_8_3 - 0.000556586270872077*G0_1_0_8_5 + 0.00113350934779527*G0_1_0_8_7 - 0.00807371200228484*G0_1_0_8_8 + 0.00465712858570079*G0_1_0_8_9 - 0.00160208838780294*G0_1_0_9_1 + 0.00160208838780294*G0_1_0_9_2 + 0.00309868702725897*G0_1_0_9_3 - 0.00309868702725902*G0_1_0_9_4 + 0.00111317254174418*G0_1_0_9_5 - 0.00465712858570082*G0_1_0_9_6 - 0.00111317254174415*G0_1_0_9_7 + 0.00465712858570079*G0_1_0_9_8;
    A[187] = A[117] - 0.0379472379472442*G0_0_1_0_0 - 0.00208236208236244*G0_0_1_0_1 - 0.000473600473600535*G0_0_1_0_2 - 0.00151848151848175*G0_0_1_0_3 + 0.0185148185148218*G0_0_1_0_5 + 0.00237096237096268*G0_0_1_0_6 - 0.0267732267732313*G0_0_1_0_7 + 0.0114285714285733*G0_0_1_0_8 + 0.0115084915084934*G0_0_1_0_9 - 0.00208236208236244*G0_0_1_1_0 - 0.000779749351178105*G0_0_1_1_1 + 0.000544006258292058*G0_0_1_1_2 + 0.00207601921887669*G0_0_1_1_3 - 0.0032729175586324*G0_0_1_1_4 + 0.017639503353792*G0_0_1_1_5 - 0.0100585129156575*G0_0_1_1_6 - 0.00205508776937382*G0_0_1_1_7 + 0.00152419009561888*G0_0_1_1_8 - 0.00461253032681684*G0_0_1_1_9 - 0.000473600473600535*G0_0_1_2_0 + 0.000544006258292058*G0_0_1_2_1 - 0.014563214563217*G0_0_1_2_2 + 0.00122163550735001*G0_0_1_2_3 - 0.00839160839160984*G0_0_1_2_4 + 0.0235992578849762*G0_0_1_2_5 + 0.0037562437562444*G0_0_1_2_6 - 0.0028599971457119*G0_0_1_2_7 - 0.00419009561866775*G0_0_1_2_8 + 0.00666761809619067*G0_0_1_2_9 - 0.00151848151848175*G0_0_1_3_0 + 0.00207601921887669*G0_0_1_3_1 + 0.00122163550735002*G0_0_1_3_2 - 0.0173312401883862*G0_0_1_3_3 + 0.011183102611676*G0_0_1_3_4 - 0.0207906379334985*G0_0_1_3_5 + 0.0233937491080388*G0_0_1_3_6 - 0.00222634508348827*G0_0_1_3_7 - 0.0035621521335813*G0_0_1_3_8 + 0.0182902811474271*G0_0_1_3_9 - 0.00327291755863239*G0_0_1_4_1 - 0.00839160839160983*G0_0_1_4_2 + 0.011183102611676*G0_0_1_4_3 - 0.049082346225212*G0_0_1_4_4 - 0.00666190951905347*G0_0_1_4_5 - 0.0167318395889854*G0_0_1_4_6 + 0.00774083059797477*G0_0_1_4_7 + 0.00578849721706962*G0_0_1_4_8 - 0.00667903525046509*G0_0_1_4_9 + 0.0185148185148218*G0_0_1_5_0 + 0.017639503353792*G0_0_1_5_1 + 0.0235992578849762*G0_0_1_5_2 - 0.0207906379334985*G0_0_1_5_3 - 0.00666190951905348*G0_0_1_5_4 + 0.670369630369743*G0_0_1_5_5 - 0.129470529470551*G0_0_1_5_6 + 0.0579020979021076*G0_0_1_5_7 - 0.0597002997003098*G0_0_1_5_8 + 0.0848751248751395*G0_0_1_5_9 + 0.00237096237096268*G0_0_1_6_0 - 0.0100585129156575*G0_0_1_6_1 + 0.0037562437562444*G0_0_1_6_2 + 0.0233937491080388*G0_0_1_6_3 - 0.0167318395889854*G0_0_1_6_4 - 0.129470529470551*G0_0_1_6_5 - 0.0723390894819592*G0_0_1_6_6 + 0.00179820179820209*G0_0_1_6_7 + 0.0247638076209547*G0_0_1_6_8 - 0.0667903525046497*G0_0_1_6_9 - 0.0267732267732313*G0_0_1_7_0 - 0.00205508776937383*G0_0_1_7_1 - 0.0028599971457119*G0_0_1_7_2 - 0.00222634508348827*G0_0_1_7_3 + 0.00774083059797477*G0_0_1_7_4 + 0.0579020979021076*G0_0_1_7_5 + 0.00179820179820209*G0_0_1_7_6 - 0.107652347652366*G0_0_1_7_7 + 0.0135464535464559*G0_0_1_7_8 - 0.0381218781218846*G0_0_1_7_9 + 0.0114285714285733*G0_0_1_8_0 + 0.00152419009561888*G0_0_1_8_1 - 0.00419009561866775*G0_0_1_8_2 - 0.0035621521335813*G0_0_1_8_3 + 0.00578849721706962*G0_0_1_8_4 - 0.0597002997003098*G0_0_1_8_5 + 0.0247638076209547*G0_0_1_8_6 + 0.0135464535464559*G0_0_1_8_7 - 0.00952190666476539*G0_0_1_8_8 + 0.00226059654631124*G0_0_1_8_9 + 0.0115084915084934*G0_0_1_9_0 - 0.00461253032681684*G0_0_1_9_1 + 0.00666761809619067*G0_0_1_9_2 + 0.0182902811474271*G0_0_1_9_3 - 0.00667903525046508*G0_0_1_9_4 + 0.0848751248751395*G0_0_1_9_5 - 0.0667903525046497*G0_0_1_9_6 - 0.0381218781218846*G0_0_1_9_7 + 0.00226059654631126*G0_0_1_9_8 - 0.231813900385367*G0_0_1_9_9 + 0.0379472379472442*G0_1_0_0_0 + 0.00208236208236244*G0_1_0_0_1 + 0.000473600473600535*G0_1_0_0_2 + 0.00151848151848174*G0_1_0_0_3 - 0.0185148185148218*G0_1_0_0_5 - 0.00237096237096268*G0_1_0_0_6 + 0.0267732267732313*G0_1_0_0_7 - 0.0114285714285733*G0_1_0_0_8 - 0.0115084915084934*G0_1_0_0_9 + 0.00208236208236244*G0_1_0_1_0 + 0.000779749351178104*G0_1_0_1_1 - 0.000544006258292058*G0_1_0_1_2 - 0.00207601921887669*G0_1_0_1_3 + 0.0032729175586324*G0_1_0_1_4 - 0.017639503353792*G0_1_0_1_5 + 0.0100585129156575*G0_1_0_1_6 + 0.00205508776937383*G0_1_0_1_7 - 0.00152419009561888*G0_1_0_1_8 + 0.00461253032681684*G0_1_0_1_9 + 0.000473600473600535*G0_1_0_2_0 - 0.000544006258292058*G0_1_0_2_1 + 0.014563214563217*G0_1_0_2_2 - 0.00122163550735002*G0_1_0_2_3 + 0.00839160839160984*G0_1_0_2_4 - 0.0235992578849762*G0_1_0_2_5 - 0.0037562437562444*G0_1_0_2_6 + 0.0028599971457119*G0_1_0_2_7 + 0.00419009561866775*G0_1_0_2_8 - 0.00666761809619067*G0_1_0_2_9 + 0.00151848151848174*G0_1_0_3_0 - 0.00207601921887669*G0_1_0_3_1 - 0.00122163550735002*G0_1_0_3_2 + 0.0173312401883862*G0_1_0_3_3 - 0.011183102611676*G0_1_0_3_4 + 0.0207906379334985*G0_1_0_3_5 - 0.0233937491080388*G0_1_0_3_6 + 0.00222634508348827*G0_1_0_3_7 + 0.0035621521335813*G0_1_0_3_8 - 0.0182902811474271*G0_1_0_3_9 + 0.0032729175586324*G0_1_0_4_1 + 0.00839160839160983*G0_1_0_4_2 - 0.011183102611676*G0_1_0_4_3 + 0.049082346225212*G0_1_0_4_4 + 0.00666190951905347*G0_1_0_4_5 + 0.0167318395889854*G0_1_0_4_6 - 0.00774083059797477*G0_1_0_4_7 - 0.00578849721706962*G0_1_0_4_8 + 0.00667903525046507*G0_1_0_4_9 - 0.0185148185148218*G0_1_0_5_0 - 0.017639503353792*G0_1_0_5_1 - 0.0235992578849762*G0_1_0_5_2 + 0.0207906379334985*G0_1_0_5_3 + 0.00666190951905347*G0_1_0_5_4 - 0.670369630369743*G0_1_0_5_5 + 0.129470529470551*G0_1_0_5_6 - 0.0579020979021076*G0_1_0_5_7 + 0.0597002997003098*G0_1_0_5_8 - 0.0848751248751395*G0_1_0_5_9 - 0.00237096237096268*G0_1_0_6_0 + 0.0100585129156575*G0_1_0_6_1 - 0.0037562437562444*G0_1_0_6_2 - 0.0233937491080388*G0_1_0_6_3 + 0.0167318395889854*G0_1_0_6_4 + 0.129470529470551*G0_1_0_6_5 + 0.0723390894819592*G0_1_0_6_6 - 0.00179820179820209*G0_1_0_6_7 - 0.0247638076209547*G0_1_0_6_8 + 0.0667903525046497*G0_1_0_6_9 + 0.0267732267732313*G0_1_0_7_0 + 0.00205508776937383*G0_1_0_7_1 + 0.0028599971457119*G0_1_0_7_2 + 0.00222634508348827*G0_1_0_7_3 - 0.00774083059797477*G0_1_0_7_4 - 0.0579020979021076*G0_1_0_7_5 - 0.00179820179820209*G0_1_0_7_6 + 0.107652347652366*G0_1_0_7_7 - 0.0135464535464559*G0_1_0_7_8 + 0.0381218781218846*G0_1_0_7_9 - 0.0114285714285733*G0_1_0_8_0 - 0.00152419009561888*G0_1_0_8_1 + 0.00419009561866775*G0_1_0_8_2 + 0.0035621521335813*G0_1_0_8_3 - 0.00578849721706962*G0_1_0_8_4 + 0.0597002997003098*G0_1_0_8_5 - 0.0247638076209547*G0_1_0_8_6 - 0.0135464535464559*G0_1_0_8_7 + 0.00952190666476539*G0_1_0_8_8 - 0.00226059654631126*G0_1_0_8_9 - 0.0115084915084934*G0_1_0_9_0 + 0.00461253032681684*G0_1_0_9_1 - 0.00666761809619067*G0_1_0_9_2 - 0.0182902811474271*G0_1_0_9_3 + 0.00667903525046505*G0_1_0_9_4 - 0.0848751248751395*G0_1_0_9_5 + 0.0667903525046497*G0_1_0_9_6 + 0.0381218781218846*G0_1_0_9_7 - 0.00226059654631126*G0_1_0_9_8 + 0.231813900385367*G0_1_0_9_9;
    A[15] = A[1] + 0.0108191962358648*G0_0_1_0_0 + 0.00052394860430584*G0_0_1_0_1 + 0.000620316081625712*G0_0_1_0_2 + 0.000227512236440846*G0_0_1_0_3 - 0.000174902808831411*G0_0_1_0_4 + 0.00659231971732086*G0_0_1_0_5 - 0.00269179894179941*G0_0_1_0_6 + 0.00189433251933284*G0_0_1_0_7 - 0.0011546324046326*G0_0_1_0_8 + 0.000290959040959096*G0_0_1_0_9 + 0.00052394860430584*G0_0_1_1_0 + 0.0108191962358648*G0_0_1_1_1 + 0.000620316081625709*G0_0_1_1_2 + 0.00659231971732083*G0_0_1_1_3 - 0.00269179894179939*G0_0_1_1_4 + 0.000227512236440843*G0_0_1_1_5 - 0.000174902808831409*G0_0_1_1_6 - 0.00115463240463261*G0_0_1_1_7 + 0.00189433251933286*G0_0_1_1_8 + 0.000290959040959094*G0_0_1_1_9 + 0.000620316081625712*G0_0_1_2_0 + 0.000620316081625709*G0_0_1_2_1 - 0.000626774019631279*G0_0_1_2_2 + 0.00087321408749995*G0_0_1_2_3 - 0.000135291296005608*G0_0_1_2_4 + 0.000873214087499953*G0_0_1_2_5 - 0.000135291296005609*G0_0_1_2_6 + 0.000436963829821046*G0_0_1_2_9 + 0.000227512236440846*G0_0_1_3_0 + 0.00659231971732083*G0_0_1_3_1 + 0.00087321408749995*G0_0_1_3_2 + 0.0107513320013338*G0_0_1_3_3 - 0.00481814316635826*G0_0_1_3_4 - 0.000427816231387733*G0_0_1_3_5 - 0.00119197766519216*G0_0_1_3_7 + 0.00170891608391638*G0_0_1_3_8 + 0.00151107820750704*G0_0_1_3_9 - 0.000174902808831411*G0_0_1_4_0 - 0.0026917989417994*G0_0_1_4_1 - 0.000135291296005608*G0_0_1_4_2 - 0.00481814316635826*G0_0_1_4_3 + 0.00261839351125108*G0_0_1_4_4 + 0.000513325959754621*G0_0_1_4_7 - 0.000516938418724224*G0_0_1_4_8 - 0.00134142643071238*G0_0_1_4_9 + 0.00659231971732086*G0_0_1_5_0 + 0.000227512236440843*G0_0_1_5_1 + 0.000873214087499953*G0_0_1_5_2 - 0.000427816231387733*G0_0_1_5_3 + 0.0107513320013338*G0_0_1_5_5 - 0.00481814316635827*G0_0_1_5_6 + 0.00170891608391637*G0_0_1_5_7 - 0.00119197766519215*G0_0_1_5_8 + 0.00151107820750704*G0_0_1_5_9 - 0.00269179894179941*G0_0_1_6_0 - 0.000174902808831409*G0_0_1_6_1 - 0.000135291296005609*G0_0_1_6_2 - 0.00481814316635827*G0_0_1_6_5 + 0.00261839351125109*G0_0_1_6_6 - 0.000516938418724218*G0_0_1_6_7 + 0.000513325959754618*G0_0_1_6_8 - 0.00134142643071238*G0_0_1_6_9 + 0.00189433251933284*G0_0_1_7_0 - 0.00115463240463261*G0_0_1_7_1 - 0.00119197766519216*G0_0_1_7_3 + 0.000513325959754621*G0_0_1_7_4 + 0.00170891608391637*G0_0_1_7_5 - 0.000516938418724218*G0_0_1_7_6 - 0.00248709623709666*G0_0_1_7_7 + 0.000727858451072848*G0_0_1_7_8 + 0.000160999714571166*G0_0_1_7_9 - 0.0011546324046326*G0_0_1_8_0 + 0.00189433251933286*G0_0_1_8_1 + 0.00170891608391638*G0_0_1_8_3 - 0.000516938418724224*G0_0_1_8_4 - 0.00119197766519215*G0_0_1_8_5 + 0.000513325959754618*G0_0_1_8_6 + 0.000727858451072848*G0_0_1_8_7 - 0.00248709623709663*G0_0_1_8_8 + 0.000160999714571174*G0_0_1_8_9 + 0.000290959040959096*G0_0_1_9_0 + 0.000290959040959094*G0_0_1_9_1 + 0.000436963829821046*G0_0_1_9_2 + 0.00151107820750704*G0_0_1_9_3 - 0.00134142643071238*G0_0_1_9_4 + 0.00151107820750704*G0_0_1_9_5 - 0.00134142643071238*G0_0_1_9_6 + 0.000160999714571166*G0_0_1_9_7 + 0.000160999714571174*G0_0_1_9_8 + 0.00183352361923822*G0_0_1_9_9 - 0.0108191962358648*G0_1_0_0_0 - 0.00052394860430584*G0_1_0_0_1 - 0.000620316081625712*G0_1_0_0_2 - 0.000227512236440846*G0_1_0_0_3 + 0.000174902808831411*G0_1_0_0_4 - 0.00659231971732086*G0_1_0_0_5 + 0.00269179894179941*G0_1_0_0_6 - 0.00189433251933284*G0_1_0_0_7 + 0.0011546324046326*G0_1_0_0_8 - 0.000290959040959096*G0_1_0_0_9 - 0.00052394860430584*G0_1_0_1_0 - 0.0108191962358648*G0_1_0_1_1 - 0.000620316081625709*G0_1_0_1_2 - 0.00659231971732083*G0_1_0_1_3 + 0.00269179894179939*G0_1_0_1_4 - 0.000227512236440843*G0_1_0_1_5 + 0.000174902808831409*G0_1_0_1_6 + 0.00115463240463261*G0_1_0_1_7 - 0.00189433251933286*G0_1_0_1_8 - 0.000290959040959094*G0_1_0_1_9 - 0.000620316081625712*G0_1_0_2_0 - 0.000620316081625709*G0_1_0_2_1 + 0.000626774019631279*G0_1_0_2_2 - 0.00087321408749995*G0_1_0_2_3 + 0.000135291296005608*G0_1_0_2_4 - 0.000873214087499953*G0_1_0_2_5 + 0.00013529129600561*G0_1_0_2_6 - 0.000436963829821046*G0_1_0_2_9 - 0.000227512236440846*G0_1_0_3_0 - 0.00659231971732083*G0_1_0_3_1 - 0.000873214087499949*G0_1_0_3_2 - 0.0107513320013338*G0_1_0_3_3 + 0.00481814316635826*G0_1_0_3_4 + 0.000427816231387733*G0_1_0_3_5 + 0.00119197766519216*G0_1_0_3_7 - 0.00170891608391638*G0_1_0_3_8 - 0.00151107820750704*G0_1_0_3_9 + 0.000174902808831411*G0_1_0_4_0 + 0.00269179894179939*G0_1_0_4_1 + 0.000135291296005608*G0_1_0_4_2 + 0.00481814316635826*G0_1_0_4_3 - 0.00261839351125108*G0_1_0_4_4 - 0.00051332595975462*G0_1_0_4_7 + 0.000516938418724224*G0_1_0_4_8 + 0.00134142643071238*G0_1_0_4_9 - 0.00659231971732086*G0_1_0_5_0 - 0.000227512236440843*G0_1_0_5_1 - 0.000873214087499953*G0_1_0_5_2 + 0.000427816231387733*G0_1_0_5_3 - 0.0107513320013338*G0_1_0_5_5 + 0.00481814316635827*G0_1_0_5_6 - 0.00170891608391637*G0_1_0_5_7 + 0.00119197766519215*G0_1_0_5_8 - 0.00151107820750704*G0_1_0_5_9 + 0.00269179894179941*G0_1_0_6_0 + 0.000174902808831409*G0_1_0_6_1 + 0.00013529129600561*G0_1_0_6_2 + 0.00481814316635827*G0_1_0_6_5 - 0.00261839351125109*G0_1_0_6_6 + 0.000516938418724218*G0_1_0_6_7 - 0.000513325959754618*G0_1_0_6_8 + 0.00134142643071238*G0_1_0_6_9 - 0.00189433251933284*G0_1_0_7_0 + 0.00115463240463261*G0_1_0_7_1 + 0.00119197766519216*G0_1_0_7_3 - 0.00051332595975462*G0_1_0_7_4 - 0.00170891608391637*G0_1_0_7_5 + 0.000516938418724218*G0_1_0_7_6 + 0.00248709623709666*G0_1_0_7_7 - 0.000727858451072849*G0_1_0_7_8 - 0.000160999714571166*G0_1_0_7_9 + 0.0011546324046326*G0_1_0_8_0 - 0.00189433251933286*G0_1_0_8_1 - 0.00170891608391638*G0_1_0_8_3 + 0.000516938418724224*G0_1_0_8_4 + 0.00119197766519215*G0_1_0_8_5 - 0.000513325959754618*G0_1_0_8_6 - 0.000727858451072849*G0_1_0_8_7 + 0.00248709623709663*G0_1_0_8_8 - 0.000160999714571174*G0_1_0_8_9 - 0.000290959040959096*G0_1_0_9_0 - 0.000290959040959094*G0_1_0_9_1 - 0.000436963829821046*G0_1_0_9_2 - 0.00151107820750704*G0_1_0_9_3 + 0.00134142643071238*G0_1_0_9_4 - 0.00151107820750704*G0_1_0_9_5 + 0.00134142643071238*G0_1_0_9_6 - 0.000160999714571166*G0_1_0_9_7 - 0.000160999714571174*G0_1_0_9_8 - 0.00183352361923822*G0_1_0_9_9;
    A[37] = -0.000546983880317323*G0_1_0_0_0 + 0.000270961401913831*G0_1_0_0_1 + 0.00480046188379603*G0_1_0_0_2 - 0.00165729112157712*G0_1_0_0_3 + 0.00393675768675837*G0_1_0_0_4 - 0.00153616225044823*G0_1_0_0_5 + 0.000815712065712192*G0_1_0_0_6 - 0.000921657707372161*G0_1_0_0_7 + 0.000340235161663799*G0_1_0_0_8 + 0.00040304933162083*G0_1_0_0_9 + 0.000270961401913831*G0_1_0_1_0 + 0.000965859537288304*G0_1_0_1_1 + 0.0071167875334554*G0_1_0_1_2 - 0.0039672232529382*G0_1_0_1_3 + 0.00970904095904261*G0_1_0_1_4 - 0.00113685917257365*G0_1_0_1_5 + 0.00348720723720783*G0_1_0_1_6 - 0.000204616811759713*G0_1_0_1_7 - 0.000334784263355727*G0_1_0_1_8 + 0.00247906855049755*G0_1_0_1_9 + 0.00480046188379603*G0_1_0_2_0 + 0.00711678753345541*G0_1_0_2_1 + 0.139942464942488*G0_1_0_2_2 - 0.0327852702852757*G0_1_0_2_3 + 0.0754273504273631*G0_1_0_2_4 - 0.0208860583860618*G0_1_0_2_5 + 0.0372433122433184*G0_1_0_2_6 - 0.00115398490398509*G0_1_0_2_7 - 0.000651154401154497*G0_1_0_2_8 + 0.00532800532800619*G0_1_0_2_9 - 0.00165729112157712*G0_1_0_3_0 - 0.0039672232529382*G0_1_0_3_1 - 0.0327852702852757*G0_1_0_3_2 + 0.0172752247752277*G0_1_0_3_3 - 0.0454857642357719*G0_1_0_3_4 + 0.00624375624375728*G0_1_0_3_5 - 0.0145666833166858*G0_1_0_3_6 + 0.00086681175966904*G0_1_0_3_7 + 0.00128478664192973*G0_1_0_3_8 - 0.00917082917083071*G0_1_0_3_9 + 0.00393675768675837*G0_1_0_4_0 + 0.00970904095904261*G0_1_0_4_1 + 0.0754273504273631*G0_1_0_4_2 - 0.0454857642357719*G0_1_0_4_3 + 0.110864135864155*G0_1_0_4_4 - 0.0159153346653373*G0_1_0_4_5 + 0.0304820179820231*G0_1_0_4_6 - 0.00212162837162872*G0_1_0_4_7 - 0.00215159840159876*G0_1_0_4_8 + 0.015846653346656*G0_1_0_4_9 - 0.00153616225044823*G0_1_0_5_0 - 0.00113685917257365*G0_1_0_5_1 - 0.0208860583860618*G0_1_0_5_2 + 0.00624375624375728*G0_1_0_5_3 - 0.0159153346653373*G0_1_0_5_4 + 0.00972277722277885*G0_1_0_5_5 - 0.000980269730269788*G0_1_0_5_6 + 0.00133759098044835*G0_1_0_5_7 - 0.000694484087341352*G0_1_0_5_8 + 0.000179820179820223*G0_1_0_5_9 + 0.000815712065712192*G0_1_0_6_0 + 0.00348720723720783*G0_1_0_6_1 + 0.0372433122433184*G0_1_0_6_2 - 0.0145666833166858*G0_1_0_6_3 + 0.0304820179820231*G0_1_0_6_4 - 0.000980269730269788*G0_1_0_6_5 + 0.0110639360639378*G0_1_0_6_6 - 0.000643106893106993*G0_1_0_6_7 - 0.00220154845154883*G0_1_0_6_8 + 0.0131493506493529*G0_1_0_6_9 - 0.000921657707372161*G0_1_0_7_0 - 0.000204616811759713*G0_1_0_7_1 - 0.00115398490398509*G0_1_0_7_2 + 0.00086681175966904*G0_1_0_7_3 - 0.00212162837162872*G0_1_0_7_4 + 0.00133759098044835*G0_1_0_7_5 - 0.000643106893106993*G0_1_0_7_6 - 0.0027426145283293*G0_1_0_7_7 + 8.04552590266921e-05*G0_1_0_7_8 + 7.70657913515118e-05*G0_1_0_7_9 + 0.000340235161663799*G0_1_0_8_0 - 0.000334784263355727*G0_1_0_8_1 - 0.000651154401154497*G0_1_0_8_2 + 0.00128478664192973*G0_1_0_8_3 - 0.00215159840159876*G0_1_0_8_4 - 0.000694484087341352*G0_1_0_8_5 - 0.00220154845154883*G0_1_0_8_6 + 8.0455259026692e-05*G0_1_0_8_7 - 0.000387826459255041*G0_1_0_8_8 - 0.0031340088482951*G0_1_0_8_9 + 0.00040304933162083*G0_1_0_9_0 + 0.00247906855049755*G0_1_0_9_1 + 0.00532800532800619*G0_1_0_9_2 - 0.00917082917083071*G0_1_0_9_3 + 0.015846653346656*G0_1_0_9_4 + 0.000179820179820223*G0_1_0_9_5 + 0.0131493506493529*G0_1_0_9_6 + 7.70657913515117e-05*G0_1_0_9_7 - 0.0031340088482951*G0_1_0_9_8 + 0.0220279720279758*G0_1_0_9_9 + 0.016843588510258*G0_1_1_0_0 + 0.00134550634550658*G0_1_1_0_1 + 0.0038430088430095*G0_1_1_0_2 - 0.00122552051123502*G0_1_1_0_3 + 0.00276037454608932*G0_1_1_0_4 + 0.00496566925138437*G0_1_1_0_5 - 0.00325057878629363*G0_1_1_0_6 + 0.0123289805432683*G0_1_1_0_7 - 0.00560861757290423*G0_1_1_0_8 + 0.000501998001998106*G0_1_1_0_9 + 0.00134550634550658*G0_1_1_1_0 + 0.00082467796753528*G0_1_1_1_1 + 0.00630628630628737*G0_1_1_1_2 - 0.00342597878312221*G0_1_1_1_3 + 0.0080091337234208*G0_1_1_1_4 + 0.00100831707974582*G0_1_1_1_5 + 0.000902232687947126*G0_1_1_1_6 + 0.00255062397919583*G0_1_1_1_7 - 0.00200398807541696*G0_1_1_1_8 + 0.00253032681604153*G0_1_1_1_9 + 0.0038430088430095*G0_1_1_2_0 + 0.00630628630628737*G0_1_1_2_1 + 0.125027133360488*G0_1_1_2_2 - 0.0287769175269223*G0_1_1_2_3 + 0.0661602286602398*G0_1_1_2_4 - 0.0123794261294282*G0_1_1_2_5 + 0.0233294483294521*G0_1_1_2_6 + 0.0010275835275837*G0_1_1_2_7 - 0.000957930957931108*G0_1_1_2_8 + 0.00467615717615794*G0_1_1_2_9 - 0.00122552051123502*G0_1_1_3_0 - 0.00342597878312221*G0_1_1_3_1 - 0.0287769175269223*G0_1_1_3_2 + 0.0135478806907401*G0_1_1_3_3 - 0.0379545454545519*G0_1_1_3_4 + 0.00225292564578317*G0_1_1_3_5 - 0.00656093906094016*G0_1_1_3_6 - 0.000177679463393792*G0_1_1_3_7 + 0.00115812758669921*G0_1_1_3_8 - 0.00723562152133703*G0_1_1_3_9 + 0.00276037454608932*G0_1_1_4_0 + 0.0080091337234208*G0_1_1_4_1 + 0.0661602286602398*G0_1_1_4_2 - 0.0379545454545519*G0_1_1_4_3 + 0.0972252747252913*G0_1_1_4_4 - 0.0121353646353667*G0_1_1_4_5 + 0.0186963036963068*G0_1_1_4_6 - 0.00375481661196009*G0_1_1_4_7 - 0.000980448123305432*G0_1_1_4_8 + 0.0102422577422595*G0_1_1_4_9 + 0.00496566925138437*G0_1_1_5_0 + 0.00100831707974582*G0_1_1_5_1 - 0.0123794261294282*G0_1_1_5_2 + 0.00225292564578317*G0_1_1_5_3 - 0.0121353646353667*G0_1_1_5_4 + 0.027726202369064*G0_1_1_5_5 - 0.00227272727272756*G0_1_1_5_6 + 0.0138161838161861*G0_1_1_5_7 - 0.00687919223633623*G0_1_1_5_8 + 0.0122523904666782*G0_1_1_5_9 - 0.00325057878629363*G0_1_1_6_0 + 0.000902232687947125*G0_1_1_6_1 + 0.0233294483294521*G0_1_1_6_2 - 0.00656093906094016*G0_1_1_6_3 + 0.0186963036963068*G0_1_1_6_4 - 0.00227272727272756*G0_1_1_6_5 - 0.0187337662337695*G0_1_1_6_6 - 0.00693699157984988*G0_1_1_6_7 + 0.00201066790352537*G0_1_1_6_8 - 0.000906593406593513*G0_1_1_6_9 + 0.0123289805432683*G0_1_1_7_0 + 0.00255062397919583*G0_1_1_7_1 + 0.0010275835275837*G0_1_1_7_2 - 0.000177679463393792*G0_1_1_7_3 - 0.00375481661196009*G0_1_1_7_4 + 0.0138161838161861*G0_1_1_7_5 - 0.00693699157984988*G0_1_1_7_6 + 0.0506953760525274*G0_1_1_7_7 - 0.0102722277722295*G0_1_1_7_8 + 0.0123679891537055*G0_1_1_7_9 - 0.00560861757290423*G0_1_1_8_0 - 0.00200398807541696*G0_1_1_8_1 - 0.000957930957931108*G0_1_1_8_2 + 0.00115812758669921*G0_1_1_8_3 - 0.000980448123305432*G0_1_1_8_4 - 0.00687919223633623*G0_1_1_8_5 + 0.00201066790352537*G0_1_1_8_6 - 0.0102722277722295*G0_1_1_8_7 + 0.00786499215070781*G0_1_1_8_8 - 0.00563008420151373*G0_1_1_8_9 + 0.000501998001998106*G0_1_1_9_0 + 0.00253032681604153*G0_1_1_9_1 + 0.00467615717615794*G0_1_1_9_2 - 0.00723562152133703*G0_1_1_9_3 + 0.0102422577422595*G0_1_1_9_4 + 0.0122523904666782*G0_1_1_9_5 - 0.000906593406593512*G0_1_1_9_6 + 0.0123679891537055*G0_1_1_9_7 - 0.00563008420151373*G0_1_1_9_8 + 0.0352704438418783*G0_1_1_9_9;
    A[160] = 0.1870921670922*G0_0_0_0_0 + 0.0128221513935822*G0_0_0_0_1 + 0.0124117416974581*G0_0_0_0_2 + 0.0124389895818488*G0_0_0_0_3 - 0.00620879120879228*G0_0_0_0_4 + 0.119565434565455*G0_0_0_0_5 - 0.0526709005280525*G0_0_0_0_6 + 0.0507109557109644*G0_0_0_0_7 - 0.00998691784406245*G0_0_0_0_8 + 0.0128343085485966*G0_0_0_0_9 + 0.0128221513935822*G0_0_0_1_0 + 0.187092167092199*G0_0_0_1_1 + 0.0124117416974581*G0_0_0_1_2 + 0.119565434565455*G0_0_0_1_3 - 0.0526709005280523*G0_0_0_1_4 + 0.0124389895818488*G0_0_0_1_5 - 0.00620879120879224*G0_0_0_1_6 - 0.00998691784406254*G0_0_0_1_7 + 0.0507109557109645*G0_0_0_1_8 + 0.0128343085485965*G0_0_0_1_9 + 0.0124117416974581*G0_0_0_2_0 + 0.0124117416974581*G0_0_0_2_1 + 0.00610246895961284*G0_0_0_2_2 + 0.0238413966985436*G0_0_0_2_3 - 0.0148113790970959*G0_0_0_2_4 + 0.0238413966985436*G0_0_0_2_5 - 0.0148113790970959*G0_0_0_2_6 + 0.0173305266162438*G0_0_0_2_7 + 0.0173305266162438*G0_0_0_2_8 + 0.0290994719566197*G0_0_0_2_9 + 0.0124389895818488*G0_0_0_3_0 + 0.119565434565455*G0_0_0_3_1 + 0.0238413966985436*G0_0_0_3_2 + 0.350084201512833*G0_0_0_3_3 - 0.107371913800503*G0_0_0_3_4 - 0.0236249464820933*G0_0_0_3_5 - 0.0087576709005295*G0_0_0_3_6 - 0.0647010132724529*G0_0_0_3_7 + 0.144076637648091*G0_0_0_3_8 + 0.0908991008991164*G0_0_0_3_9 - 0.00620879120879228*G0_0_0_4_0 - 0.0526709005280523*G0_0_0_4_1 - 0.0148113790970959*G0_0_0_4_2 - 0.107371913800503*G0_0_0_4_3 + 0.0588268873983259*G0_0_0_4_4 - 0.00875767090052954*G0_0_0_4_5 + 0.017515341801059*G0_0_0_4_6 - 0.00299058084772416*G0_0_0_4_7 - 0.0793756243756377*G0_0_0_4_8 - 0.0697830740688001*G0_0_0_4_9 + 0.119565434565455*G0_0_0_5_0 + 0.0124389895818488*G0_0_0_5_1 + 0.0238413966985436*G0_0_0_5_2 - 0.0236249464820933*G0_0_0_5_3 - 0.00875767090052954*G0_0_0_5_4 + 0.350084201512833*G0_0_0_5_5 - 0.107371913800504*G0_0_0_5_6 + 0.14407663764809*G0_0_0_5_7 - 0.0647010132724528*G0_0_0_5_8 + 0.0908991008991163*G0_0_0_5_9 - 0.0526709005280525*G0_0_0_6_0 - 0.00620879120879224*G0_0_0_6_1 - 0.0148113790970959*G0_0_0_6_2 - 0.0087576709005295*G0_0_0_6_3 + 0.017515341801059*G0_0_0_6_4 - 0.107371913800504*G0_0_0_6_5 + 0.058826887398326*G0_0_0_6_6 - 0.0793756243756376*G0_0_0_6_7 - 0.00299058084772415*G0_0_0_6_8 - 0.0697830740688001*G0_0_0_6_9 + 0.0507109557109644*G0_0_0_7_0 - 0.00998691784406254*G0_0_0_7_1 + 0.0173305266162438*G0_0_0_7_2 - 0.0647010132724529*G0_0_0_7_3 - 0.00299058084772416*G0_0_0_7_4 + 0.14407663764809*G0_0_0_7_5 - 0.0793756243756376*G0_0_0_7_6 + 0.482162123590776*G0_0_0_7_7 - 0.171586984444156*G0_0_0_7_8 + 0.120248323105486*G0_0_0_7_9 - 0.00998691784406245*G0_0_0_8_0 + 0.0507109557109645*G0_0_0_8_1 + 0.0173305266162438*G0_0_0_8_2 + 0.144076637648091*G0_0_0_8_3 - 0.0793756243756377*G0_0_0_8_4 - 0.0647010132724528*G0_0_0_8_5 - 0.00299058084772414*G0_0_0_8_6 - 0.171586984444156*G0_0_0_8_7 + 0.482162123590777*G0_0_0_8_8 + 0.120248323105486*G0_0_0_8_9 + 0.0128343085485966*G0_0_0_9_0 + 0.0128343085485965*G0_0_0_9_1 + 0.0290994719566197*G0_0_0_9_2 + 0.0908991008991164*G0_0_0_9_3 - 0.0697830740688001*G0_0_0_9_4 + 0.0908991008991163*G0_0_0_9_5 - 0.0697830740688001*G0_0_0_9_6 + 0.120248323105486*G0_0_0_9_7 + 0.120248323105486*G0_0_0_9_8 + 0.317048665620148*G0_0_0_9_9 - 0.0097924297924313*G0_0_1_0_0 + 0.00641107569679112*G0_0_1_0_1 + 0.000941254512683251*G0_0_1_0_2 + 0.0135064935064958*G0_0_1_0_3 - 0.00592264877979265*G0_0_1_0_4 - 0.00836663336663473*G0_0_1_0_5 + 0.001484943627801*G0_0_1_0_6 - 0.00337495837495897*G0_0_1_0_7 + 0.0176354597783199*G0_0_1_0_8 + 0.0102768659911535*G0_0_1_0_9 + 0.00641107569679112*G0_0_1_1_0 + 0.196884596884631*G0_0_1_1_1 + 0.0114704871847748*G0_0_1_1_2 + 0.12793206793209*G0_0_1_1_3 - 0.0541558441558533*G0_0_1_1_4 - 0.00106750392464701*G0_0_1_1_5 - 0.000286142428999603*G0_0_1_1_6 - 0.0276223776223824*G0_0_1_1_7 + 0.0540859140859235*G0_0_1_1_8 + 0.00255744255744306*G0_0_1_1_9 + 0.000941254512683251*G0_0_1_2_0 + 0.0114704871847748*G0_0_1_2_1 + 0.00305123447980642*G0_0_1_2_2 + 0.0259480995195325*G0_0_1_2_3 - 0.0128466771323936*G0_0_1_2_4 - 0.00210670282098889*G0_0_1_2_5 - 0.00196470196470229*G0_0_1_2_6 - 0.00786213786213918*G0_0_1_2_7 + 0.025192664478383*G0_0_1_2_8 + 0.0145497359783099*G0_0_1_2_9 + 0.0135064935064958*G0_0_1_3_0 + 0.12793206793209*G0_0_1_3_1 + 0.0259480995195325*G0_0_1_3_2 + 0.368016983017045*G0_0_1_3_3 - 0.113072641644089*G0_0_1_3_4 - 0.0118124732410467*G0_0_1_3_5 - 0.0128335949764543*G0_0_1_3_6 - 0.0542115027829406*G0_0_1_3_7 + 0.143481518481543*G0_0_1_3_8 + 0.100750677893552*G0_0_1_3_9 - 0.00592264877979265*G0_0_1_4_0 - 0.0541558441558533*G0_0_1_4_1 - 0.0128466771323936*G0_0_1_4_2 - 0.113072641644089*G0_0_1_4_3 + 0.0572748679891633*G0_0_1_4_4 + 0.00407592407592476*G0_0_1_4_5 + 0.00875767090052952*G0_0_1_4_6 + 0.0275231910946243*G0_0_1_4_7 - 0.0892700156986022*G0_0_1_4_8 - 0.0518010560867792*G0_0_1_4_9 - 0.00836663336663473*G0_0_1_5_0 - 0.00106750392464701*G0_0_1_5_1 - 0.00210670282098889*G0_0_1_5_2 - 0.0118124732410467*G0_0_1_5_3 + 0.00407592407592476*G0_0_1_5_4 - 0.0179327815042131*G0_0_1_5_5 + 0.00570072784358592*G0_0_1_5_6 + 0.000595119166547848*G0_0_1_5_7 - 0.0104895104895123*G0_0_1_5_8 - 0.00985157699443579*G0_0_1_5_9 + 0.001484943627801*G0_0_1_6_0 - 0.000286142428999603*G0_0_1_6_1 - 0.00196470196470229*G0_0_1_6_2 - 0.0128335949764543*G0_0_1_6_3 + 0.00875767090052952*G0_0_1_6_4 + 0.00570072784358592*G0_0_1_6_5 + 0.00155201940916253*G0_0_1_6_6 + 0.00989439132296441*G0_0_1_6_7 - 0.0305137719423485*G0_0_1_6_8 - 0.017982017982021*G0_0_1_6_9 - 0.00337495837495897*G0_0_1_7_0 - 0.0276223776223824*G0_0_1_7_1 - 0.00786213786213918*G0_0_1_7_2 - 0.0542115027829406*G0_0_1_7_3 + 0.0275231910946243*G0_0_1_7_4 + 0.000595119166547846*G0_0_1_7_5 + 0.00989439132296441*G0_0_1_7_6 - 0.0180526616240934*G0_0_1_7_7 - 0.085793492222078*G0_0_1_7_8 - 0.0506193806193892*G0_0_1_7_9 + 0.0176354597783199*G0_0_1_8_0 + 0.0540859140859234*G0_0_1_8_1 + 0.025192664478383*G0_0_1_8_2 + 0.143481518481543*G0_0_1_8_3 - 0.0892700156986022*G0_0_1_8_4 - 0.0104895104895123*G0_0_1_8_5 - 0.0305137719423485*G0_0_1_8_6 - 0.085793492222078*G0_0_1_8_7 + 0.50021478521487*G0_0_1_8_8 + 0.170867703724876*G0_0_1_8_9 + 0.0102768659911535*G0_0_1_9_0 + 0.00255744255744306*G0_0_1_9_1 + 0.0145497359783099*G0_0_1_9_2 + 0.100750677893552*G0_0_1_9_3 - 0.0518010560867792*G0_0_1_9_4 - 0.00985157699443579*G0_0_1_9_5 - 0.017982017982021*G0_0_1_9_6 - 0.0506193806193892*G0_0_1_9_7 + 0.170867703724876*G0_0_1_9_8 + 0.158524332810074*G0_0_1_9_9 - 0.0097924297924313*G0_1_0_0_0 + 0.00641107569679112*G0_1_0_0_1 + 0.000941254512683251*G0_1_0_0_2 + 0.0135064935064958*G0_1_0_0_3 - 0.00592264877979265*G0_1_0_0_4 - 0.00836663336663473*G0_1_0_0_5 + 0.001484943627801*G0_1_0_0_6 - 0.00337495837495897*G0_1_0_0_7 + 0.0176354597783199*G0_1_0_0_8 + 0.0102768659911535*G0_1_0_0_9 + 0.00641107569679112*G0_1_0_1_0 + 0.196884596884631*G0_1_0_1_1 + 0.0114704871847748*G0_1_0_1_2 + 0.12793206793209*G0_1_0_1_3 - 0.0541558441558533*G0_1_0_1_4 - 0.00106750392464701*G0_1_0_1_5 - 0.000286142428999603*G0_1_0_1_6 - 0.0276223776223824*G0_1_0_1_7 + 0.0540859140859234*G0_1_0_1_8 + 0.00255744255744307*G0_1_0_1_9 + 0.000941254512683251*G0_1_0_2_0 + 0.0114704871847748*G0_1_0_2_1 + 0.00305123447980642*G0_1_0_2_2 + 0.0259480995195325*G0_1_0_2_3 - 0.0128466771323936*G0_1_0_2_4 - 0.00210670282098889*G0_1_0_2_5 - 0.00196470196470229*G0_1_0_2_6 - 0.00786213786213918*G0_1_0_2_7 + 0.025192664478383*G0_1_0_2_8 + 0.0145497359783099*G0_1_0_2_9 + 0.0135064935064958*G0_1_0_3_0 + 0.12793206793209*G0_1_0_3_1 + 0.0259480995195325*G0_1_0_3_2 + 0.368016983017046*G0_1_0_3_3 - 0.113072641644089*G0_1_0_3_4 - 0.0118124732410467*G0_1_0_3_5 - 0.0128335949764543*G0_1_0_3_6 - 0.0542115027829406*G0_1_0_3_7 + 0.143481518481543*G0_1_0_3_8 + 0.100750677893552*G0_1_0_3_9 - 0.00592264877979265*G0_1_0_4_0 - 0.0541558441558533*G0_1_0_4_1 - 0.0128466771323936*G0_1_0_4_2 - 0.113072641644089*G0_1_0_4_3 + 0.0572748679891633*G0_1_0_4_4 + 0.00407592407592476*G0_1_0_4_5 + 0.00875767090052952*G0_1_0_4_6 + 0.0275231910946243*G0_1_0_4_7 - 0.0892700156986022*G0_1_0_4_8 - 0.0518010560867792*G0_1_0_4_9 - 0.00836663336663473*G0_1_0_5_0 - 0.00106750392464701*G0_1_0_5_1 - 0.00210670282098889*G0_1_0_5_2 - 0.0118124732410467*G0_1_0_5_3 + 0.00407592407592476*G0_1_0_5_4 - 0.0179327815042131*G0_1_0_5_5 + 0.00570072784358592*G0_1_0_5_6 + 0.000595119166547848*G0_1_0_5_7 - 0.0104895104895123*G0_1_0_5_8 - 0.00985157699443579*G0_1_0_5_9 + 0.001484943627801*G0_1_0_6_0 - 0.000286142428999603*G0_1_0_6_1 - 0.00196470196470229*G0_1_0_6_2 - 0.0128335949764543*G0_1_0_6_3 + 0.00875767090052952*G0_1_0_6_4 + 0.00570072784358592*G0_1_0_6_5 + 0.00155201940916253*G0_1_0_6_6 + 0.00989439132296441*G0_1_0_6_7 - 0.0305137719423485*G0_1_0_6_8 - 0.017982017982021*G0_1_0_6_9 - 0.00337495837495897*G0_1_0_7_0 - 0.0276223776223824*G0_1_0_7_1 - 0.00786213786213918*G0_1_0_7_2 - 0.0542115027829406*G0_1_0_7_3 + 0.0275231910946243*G0_1_0_7_4 + 0.000595119166547846*G0_1_0_7_5 + 0.00989439132296441*G0_1_0_7_6 - 0.0180526616240934*G0_1_0_7_7 - 0.085793492222078*G0_1_0_7_8 - 0.0506193806193892*G0_1_0_7_9 + 0.0176354597783199*G0_1_0_8_0 + 0.0540859140859234*G0_1_0_8_1 + 0.025192664478383*G0_1_0_8_2 + 0.143481518481543*G0_1_0_8_3 - 0.0892700156986022*G0_1_0_8_4 - 0.0104895104895123*G0_1_0_8_5 - 0.0305137719423485*G0_1_0_8_6 - 0.085793492222078*G0_1_0_8_7 + 0.50021478521487*G0_1_0_8_8 + 0.170867703724876*G0_1_0_8_9 + 0.0102768659911535*G0_1_0_9_0 + 0.00255744255744307*G0_1_0_9_1 + 0.0145497359783099*G0_1_0_9_2 + 0.100750677893552*G0_1_0_9_3 - 0.0518010560867792*G0_1_0_9_4 - 0.00985157699443579*G0_1_0_9_5 - 0.017982017982021*G0_1_0_9_6 - 0.0506193806193892*G0_1_0_9_7 + 0.170867703724876*G0_1_0_9_8 + 0.158524332810074*G0_1_0_9_9 + 0.00704628704628819*G0_1_1_0_0 + 0.00958670958671126*G0_1_1_0_1 + 0.000827558684701683*G0_1_1_0_2 + 0.0135616764188216*G0_1_1_0_3 - 0.00361186432615067*G0_1_1_0_4 + 0.000597735597735664*G0_1_1_0_5 - 0.000339898197041102*G0_1_1_0_6 - 0.01273892773893*G0_1_1_0_7 + 0.00259716474002241*G0_1_1_0_8 + 0.000366776081061882*G0_1_1_0_9 + 0.00958670958671126*G0_1_1_1_0 + 0.21372331372335*G0_1_1_1_1 + 0.0113567913567933*G0_1_1_1_2 + 0.13689643689646*G0_1_1_1_3 - 0.0559806859806955*G0_1_1_1_4 - 0.00101232101232124*G0_1_1_1_5 + 0.00202464202464239*G0_1_1_1_6 - 0.04266067266068*G0_1_1_1_7 + 0.0447219447219525*G0_1_1_1_8 - 0.00735264735264852*G0_1_1_1_9 + 0.000827558684701683*G0_1_1_2_0 + 0.0113567913567933*G0_1_1_2_1 + 0.00487449058877712*G0_1_1_2_2 + 0.029690071832934*G0_1_1_2_3 - 0.0172715379858266*G0_1_1_2_4 + 0.00163526949241262*G0_1_1_2_5 - 0.00638956281813532*G0_1_1_2_6 + 0.00256481613624514*G0_1_1_2_7 + 0.0356196184767673*G0_1_1_2_8 + 0.0292521763950385*G0_1_1_2_9 + 0.0135616764188216*G0_1_1_3_0 + 0.13689643689646*G0_1_1_3_1 + 0.029690071832934*G0_1_1_3_2 + 0.407712287712357*G0_1_1_3_3 - 0.126623376623398*G0_1_1_3_4 - 0.0132574568288876*G0_1_1_3_5 - 0.017207078635653*G0_1_1_3_6 - 0.0518181818181907*G0_1_1_3_7 + 0.169810189810219*G0_1_1_3_8 + 0.125694305694327*G0_1_1_3_9 - 0.00361186432615067*G0_1_1_4_0 - 0.0559806859806954*G0_1_1_4_1 - 0.0172715379858266*G0_1_1_4_2 - 0.126623376623398*G0_1_1_4_3 + 0.0707035821321655*G0_1_1_4_4 - 0.00029755958327392*G0_1_1_4_5 + 0.0175046382189269*G0_1_1_4_6 + 0.0071371485657212*G0_1_1_4_7 - 0.117992007992028*G0_1_1_4_8 - 0.0871614100185677*G0_1_1_4_9 + 0.000597735597735665*G0_1_1_5_0 - 0.00101232101232124*G0_1_1_5_1 + 0.00163526949241262*G0_1_1_5_2 - 0.0132574568288876*G0_1_1_5_3 - 0.000297559583273921*G0_1_1_5_4 + 0.0217625231910983*G0_1_1_5_5 - 0.00785000713572272*G0_1_1_5_6 + 0.0269237904952236*G0_1_1_5_7 - 0.00809618952476234*G0_1_1_5_8 + 0.0150920508063391*G0_1_1_5_9 - 0.000339898197041102*G0_1_1_6_0 + 0.00202464202464239*G0_1_1_6_1 - 0.00638956281813532*G0_1_1_6_2 - 0.017207078635653*G0_1_1_6_3 + 0.0175046382189269*G0_1_1_6_4 - 0.00785000713572272*G0_1_1_6_5 + 0.0149807335521647*G0_1_1_6_6 - 0.0188276009704613*G0_1_1_6_7 - 0.0508998144712516*G0_1_1_6_8 - 0.0533423719138095*G0_1_1_6_9 - 0.01273892773893*G0_1_1_7_0 - 0.04266067266068*G0_1_1_7_1 + 0.00256481613624514*G0_1_1_7_2 - 0.0518181818181907*G0_1_1_7_3 + 0.00713714856572119*G0_1_1_7_4 + 0.0269237904952236*G0_1_1_7_5 - 0.0188276009704613*G0_1_1_7_6 + 0.157976309404908*G0_1_1_7_7 + 0.00380619380619453*G0_1_1_7_8 + 0.0365548736977371*G0_1_1_7_9 + 0.00259716474002241*G0_1_1_8_0 + 0.0447219447219525*G0_1_1_8_1 + 0.0356196184767673*G0_1_1_8_2 + 0.169810189810219*G0_1_1_8_3 - 0.117992007992028*G0_1_1_8_4 - 0.00809618952476234*G0_1_1_8_5 - 0.0508998144712516*G0_1_1_8_6 + 0.00380619380619453*G0_1_1_8_7 + 0.676243756243871*G0_1_1_8_8 + 0.258041958042002*G0_1_1_8_9 + 0.000366776081061882*G0_1_1_9_0 - 0.00735264735264852*G0_1_1_9_1 + 0.0292521763950385*G0_1_1_9_2 + 0.125694305694327*G0_1_1_9_3 - 0.0871614100185677*G0_1_1_9_4 + 0.0150920508063391*G0_1_1_9_5 - 0.0533423719138095*G0_1_1_9_6 + 0.0365548736977371*G0_1_1_9_7 + 0.258041958042002*G0_1_1_9_8 + 0.313503639217978*G0_1_1_9_9;
    A[91] = A[21] + 0.0170459170459201*G0_0_1_0_0 + 0.000135455373550636*G0_0_1_0_1 + 0.000591824401348315*G0_0_1_0_2 + 0.00662670662670778*G0_0_1_0_5 - 0.00222769294197905*G0_0_1_0_6 + 0.00212343212343253*G0_0_1_0_7 - 0.00158611230039831*G0_0_1_0_8 - 0.000466359037787678*G0_0_1_0_9 + 0.000135455373550636*G0_0_1_1_0 + 0.000140194902099684*G0_0_1_1_2 + 0.00182854182854211*G0_0_1_1_3 - 0.00029267029267033*G0_0_1_1_4 - 0.000196734482448803*G0_0_1_1_6 + 0.00062789062789076*G0_0_1_1_7 - 0.00182854182854219*G0_0_1_1_8 - 0.000335220335220393*G0_0_1_1_9 + 0.000591824401348315*G0_0_1_2_0 + 0.000140194902099684*G0_0_1_2_1 - 0.00407525455144573*G0_0_1_2_2 + 0.000426372569229787*G0_0_1_2_3 + 0.000477511906083406*G0_0_1_2_4 + 0.000730724302153*G0_0_1_2_5 + 0.000827690827690963*G0_0_1_2_6 + 0.000111370111370135*G0_0_1_2_7 - 0.000364661793233286*G0_0_1_2_8 + 0.00128173413887721*G0_0_1_2_9 + 0.00182854182854211*G0_0_1_3_1 + 0.000426372569229787*G0_0_1_3_2 + 0.0055744255744265*G0_0_1_3_3 - 0.00410732125017907*G0_0_1_3_4 + 0.00016959231244947*G0_0_1_3_5 + 0.000350126064411842*G0_0_1_3_6 - 0.000377717520574722*G0_0_1_3_7 - 0.00047619047619057*G0_0_1_3_8 + 0.00176109604681063*G0_0_1_3_9 - 0.00029267029267033*G0_0_1_4_1 + 0.000477511906083406*G0_0_1_4_2 - 0.00410732125017907*G0_0_1_4_3 + 0.00549878692735925*G0_0_1_4_4 - 0.000116550116550132*G0_0_1_4_5 - 0.000233575947861707*G0_0_1_4_6 + 0.000853907996765294*G0_0_1_4_8 - 0.00361210218353137*G0_0_1_4_9 + 0.00662670662670779*G0_0_1_5_0 + 0.000730724302153*G0_0_1_5_2 + 0.00016959231244947*G0_0_1_5_3 - 0.000116550116550132*G0_0_1_5_4 - 0.0201679273107878*G0_0_1_5_5 - 0.00651729223157906*G0_0_1_5_6 + 0.000577517720374995*G0_0_1_5_7 + 0.0014057371200231*G0_0_1_5_9 - 0.00222769294197905*G0_0_1_6_0 - 0.000196734482448803*G0_0_1_6_1 + 0.000827690827690963*G0_0_1_6_2 + 0.000350126064411842*G0_0_1_6_3 - 0.000233575947861707*G0_0_1_6_4 - 0.00651729223157906*G0_0_1_6_5 + 0.00713334284762978*G0_0_1_6_6 - 0.000574187717044969*G0_0_1_6_7 + 0.000962133104990418*G0_0_1_6_8 - 0.00454545454545532*G0_0_1_6_9 + 0.00212343212343253*G0_0_1_7_0 + 0.00062789062789076*G0_0_1_7_1 + 0.000111370111370135*G0_0_1_7_2 - 0.000377717520574722*G0_0_1_7_3 + 0.000577517720374995*G0_0_1_7_5 - 0.00057418771704497*G0_0_1_7_6 - 0.00768041482327322*G0_0_1_7_7 + 0.00257218971504729*G0_0_1_7_8 + 0.00254745254745299*G0_0_1_7_9 - 0.00158611230039831*G0_0_1_8_0 - 0.00182854182854219*G0_0_1_8_1 - 0.000364661793233286*G0_0_1_8_2 - 0.00047619047619057*G0_0_1_8_3 + 0.000853907996765294*G0_0_1_8_4 + 0.000962133104990418*G0_0_1_8_6 + 0.00257218971504729*G0_0_1_8_7 - 0.00462204462204545*G0_0_1_8_8 - 0.000702154987869406*G0_0_1_8_9 - 0.000466359037787678*G0_0_1_9_0 - 0.000335220335220394*G0_0_1_9_1 + 0.00128173413887721*G0_0_1_9_2 + 0.00176109604681063*G0_0_1_9_3 - 0.00361210218353137*G0_0_1_9_4 + 0.0014057371200231*G0_0_1_9_5 - 0.00454545454545532*G0_0_1_9_6 + 0.00254745254745299*G0_0_1_9_7 - 0.000702154987869406*G0_0_1_9_8 + 0.00428143285286217*G0_0_1_9_9 - 0.0170459170459201*G0_1_0_0_0 - 0.000135455373550635*G0_1_0_0_1 - 0.000591824401348315*G0_1_0_0_2 - 0.00662670662670778*G0_1_0_0_5 + 0.00222769294197905*G0_1_0_0_6 - 0.00212343212343253*G0_1_0_0_7 + 0.00158611230039831*G0_1_0_0_8 + 0.000466359037787678*G0_1_0_0_9 - 0.000135455373550635*G0_1_0_1_0 - 0.000140194902099684*G0_1_0_1_2 - 0.00182854182854211*G0_1_0_1_3 + 0.00029267029267033*G0_1_0_1_4 + 0.000196734482448803*G0_1_0_1_6 - 0.00062789062789076*G0_1_0_1_7 + 0.00182854182854219*G0_1_0_1_8 + 0.000335220335220394*G0_1_0_1_9 - 0.000591824401348315*G0_1_0_2_0 - 0.000140194902099684*G0_1_0_2_1 + 0.00407525455144573*G0_1_0_2_2 - 0.000426372569229786*G0_1_0_2_3 - 0.000477511906083406*G0_1_0_2_4 - 0.000730724302153*G0_1_0_2_5 - 0.000827690827690963*G0_1_0_2_6 - 0.000111370111370135*G0_1_0_2_7 + 0.000364661793233286*G0_1_0_2_8 - 0.00128173413887721*G0_1_0_2_9 - 0.00182854182854211*G0_1_0_3_1 - 0.000426372569229786*G0_1_0_3_2 - 0.0055744255744265*G0_1_0_3_3 + 0.00410732125017907*G0_1_0_3_4 - 0.00016959231244947*G0_1_0_3_5 - 0.000350126064411842*G0_1_0_3_6 + 0.000377717520574722*G0_1_0_3_7 + 0.00047619047619057*G0_1_0_3_8 - 0.00176109604681063*G0_1_0_3_9 + 0.00029267029267033*G0_1_0_4_1 - 0.000477511906083406*G0_1_0_4_2 + 0.00410732125017907*G0_1_0_4_3 - 0.00549878692735925*G0_1_0_4_4 + 0.000116550116550132*G0_1_0_4_5 + 0.000233575947861707*G0_1_0_4_6 - 0.000853907996765294*G0_1_0_4_8 + 0.00361210218353137*G0_1_0_4_9 - 0.00662670662670778*G0_1_0_5_0 - 0.000730724302153*G0_1_0_5_2 - 0.000169592312449471*G0_1_0_5_3 + 0.000116550116550132*G0_1_0_5_4 + 0.0201679273107878*G0_1_0_5_5 + 0.00651729223157906*G0_1_0_5_6 - 0.000577517720374995*G0_1_0_5_7 - 0.0014057371200231*G0_1_0_5_9 + 0.00222769294197905*G0_1_0_6_0 + 0.000196734482448803*G0_1_0_6_1 - 0.000827690827690963*G0_1_0_6_2 - 0.000350126064411842*G0_1_0_6_3 + 0.000233575947861707*G0_1_0_6_4 + 0.00651729223157906*G0_1_0_6_5 - 0.00713334284762978*G0_1_0_6_6 + 0.00057418771704497*G0_1_0_6_7 - 0.000962133104990418*G0_1_0_6_8 + 0.00454545454545532*G0_1_0_6_9 - 0.00212343212343253*G0_1_0_7_0 - 0.00062789062789076*G0_1_0_7_1 - 0.000111370111370135*G0_1_0_7_2 + 0.000377717520574722*G0_1_0_7_3 - 0.000577517720374995*G0_1_0_7_5 + 0.00057418771704497*G0_1_0_7_6 + 0.00768041482327321*G0_1_0_7_7 - 0.00257218971504729*G0_1_0_7_8 - 0.00254745254745299*G0_1_0_7_9 + 0.00158611230039831*G0_1_0_8_0 + 0.00182854182854219*G0_1_0_8_1 + 0.000364661793233286*G0_1_0_8_2 + 0.00047619047619057*G0_1_0_8_3 - 0.000853907996765294*G0_1_0_8_4 - 0.000962133104990418*G0_1_0_8_6 - 0.00257218971504729*G0_1_0_8_7 + 0.00462204462204545*G0_1_0_8_8 + 0.000702154987869406*G0_1_0_8_9 + 0.000466359037787677*G0_1_0_9_0 + 0.000335220335220394*G0_1_0_9_1 - 0.00128173413887721*G0_1_0_9_2 - 0.00176109604681063*G0_1_0_9_3 + 0.00361210218353137*G0_1_0_9_4 - 0.0014057371200231*G0_1_0_9_5 + 0.00454545454545532*G0_1_0_9_6 - 0.00254745254745299*G0_1_0_9_7 + 0.000702154987869406*G0_1_0_9_8 - 0.00428143285286217*G0_1_0_9_9;
    A[82] = A[110] - 0.00312773646107032*G0_0_1_0_0 - 0.000380466094751864*G0_0_1_0_1 + 0.00337514337514395*G0_0_1_0_2 + 0.000659974945689347*G0_0_1_0_3 - 0.00544249401392352*G0_0_1_0_4 + 0.00236017950303705*G0_0_1_0_5 - 0.00725591868449139*G0_0_1_0_6 - 0.00179185893471638*G0_0_1_0_7 + 0.00121180406894714*G0_0_1_0_8 - 0.00183245326102498*G0_0_1_0_9 - 0.000380466094751864*G0_0_1_1_0 + 0.000523497666355045*G0_0_1_1_1 + 0.00578458578458677*G0_0_1_1_2 + 0.000847089418518104*G0_0_1_1_4 + 0.000874998017855309*G0_0_1_1_5 - 0.00168625025767911*G0_0_1_1_6 - 0.000148740148740217*G0_0_1_1_7 + 0.00141382427096739*G0_0_1_1_9 + 0.00337514337514395*G0_0_1_2_0 + 0.00578458578458677*G0_0_1_2_1 + 0.195838729172095*G0_0_1_2_2 - 0.026573426573431*G0_0_1_2_3 + 0.060872460872471*G0_0_1_2_4 - 0.0144078144078167*G0_0_1_2_5 + 0.0192252192252222*G0_0_1_2_6 - 0.000255300255300292*G0_0_1_2_7 + 0.000597180597180718*G0_0_1_2_8 - 0.00293040293040345*G0_0_1_2_9 + 0.000659974945689348*G0_0_1_3_0 - 0.026573426573431*G0_0_1_3_2 - 0.003898958184673*G0_0_1_3_3 - 0.00517482517482608*G0_0_1_3_4 - 0.00313971742543224*G0_0_1_3_5 + 0.00673326673326782*G0_0_1_3_6 - 0.000305408876837518*G0_0_1_3_7 + 0.000422434708149126*G0_0_1_3_8 - 0.00363065505922712*G0_0_1_3_9 - 0.00544249401392352*G0_0_1_4_0 + 0.000847089418518111*G0_0_1_4_1 + 0.060872460872471*G0_0_1_4_2 - 0.00517482517482609*G0_0_1_4_3 - 0.142497502497527*G0_0_1_4_4 + 0.018001998002001*G0_0_1_4_5 - 0.0247352647352689*G0_0_1_4_6 + 0.00770943342372044*G0_0_1_4_7 - 0.0001170258313116*G0_0_1_4_8 - 0.0272127872127917*G0_0_1_4_9 + 0.00236017950303705*G0_0_1_5_0 + 0.000874998017855309*G0_0_1_5_1 - 0.0144078144078167*G0_0_1_5_2 - 0.00313971742543224*G0_0_1_5_3 + 0.0180019980020011*G0_0_1_5_4 - 0.0133295276152443*G0_0_1_5_5 + 0.0355044955045016*G0_0_1_5_6 - 0.00148993863279603*G0_0_1_5_7 - 0.000950478093335379*G0_0_1_5_8 + 0.0073983159697457*G0_0_1_5_9 - 0.00725591868449139*G0_0_1_6_0 - 0.00168625025767912*G0_0_1_6_1 + 0.0192252192252222*G0_0_1_6_2 + 0.00673326673326783*G0_0_1_6_3 - 0.0247352647352689*G0_0_1_6_4 + 0.0355044955045016*G0_0_1_6_5 - 0.133706293706316*G0_0_1_6_6 + 0.00244041672613141*G0_0_1_6_7 + 0.000796346510632309*G0_0_1_6_8 - 0.00467532467532526*G0_0_1_6_9 - 0.00179185893471637*G0_0_1_7_0 - 0.000148740148740217*G0_0_1_7_1 - 0.000255300255300292*G0_0_1_7_2 - 0.000305408876837517*G0_0_1_7_3 + 0.00770943342372044*G0_0_1_7_4 - 0.00148993863279603*G0_0_1_7_5 + 0.00244041672613141*G0_0_1_7_6 - 0.0107835022120753*G0_0_1_7_7 + 0.000545169116597711*G0_0_1_7_8 + 0.000616526330812105*G0_0_1_7_9 + 0.00121180406894714*G0_0_1_8_0 + 0.000597180597180718*G0_0_1_8_2 + 0.000422434708149126*G0_0_1_8_3 - 0.000117025831311599*G0_0_1_8_4 - 0.000950478093335379*G0_0_1_8_5 + 0.000796346510632309*G0_0_1_8_6 + 0.000545169116597711*G0_0_1_8_7 - 0.00307692307692333*G0_0_1_8_8 - 0.00400742115027895*G0_0_1_8_9 - 0.00183245326102499*G0_0_1_9_0 + 0.00141382427096739*G0_0_1_9_1 - 0.00293040293040345*G0_0_1_9_2 - 0.00363065505922712*G0_0_1_9_3 - 0.0272127872127917*G0_0_1_9_4 + 0.0073983159697457*G0_0_1_9_5 - 0.00467532467532525*G0_0_1_9_6 + 0.000616526330812105*G0_0_1_9_7 - 0.00400742115027895*G0_0_1_9_8 + 0.0355530184101675*G0_0_1_9_9 + 0.00312773646107032*G0_1_0_0_0 + 0.000380466094751864*G0_1_0_0_1 - 0.00337514337514395*G0_1_0_0_2 - 0.000659974945689347*G0_1_0_0_3 + 0.00544249401392352*G0_1_0_0_4 - 0.00236017950303705*G0_1_0_0_5 + 0.00725591868449139*G0_1_0_0_6 + 0.00179185893471638*G0_1_0_0_7 - 0.00121180406894714*G0_1_0_0_8 + 0.00183245326102499*G0_1_0_0_9 + 0.000380466094751864*G0_1_0_1_0 - 0.000523497666355045*G0_1_0_1_1 - 0.00578458578458677*G0_1_0_1_2 - 0.000847089418518104*G0_1_0_1_4 - 0.000874998017855309*G0_1_0_1_5 + 0.00168625025767911*G0_1_0_1_6 + 0.000148740148740217*G0_1_0_1_7 - 0.00141382427096739*G0_1_0_1_9 - 0.00337514337514395*G0_1_0_2_0 - 0.00578458578458676*G0_1_0_2_1 - 0.195838729172095*G0_1_0_2_2 + 0.0265734265734309*G0_1_0_2_3 - 0.060872460872471*G0_1_0_2_4 + 0.0144078144078167*G0_1_0_2_5 - 0.0192252192252222*G0_1_0_2_6 + 0.000255300255300292*G0_1_0_2_7 - 0.000597180597180718*G0_1_0_2_8 + 0.00293040293040345*G0_1_0_2_9 - 0.000659974945689347*G0_1_0_3_0 + 0.026573426573431*G0_1_0_3_2 + 0.003898958184673*G0_1_0_3_3 + 0.00517482517482608*G0_1_0_3_4 + 0.00313971742543224*G0_1_0_3_5 - 0.00673326673326782*G0_1_0_3_6 + 0.000305408876837517*G0_1_0_3_7 - 0.000422434708149126*G0_1_0_3_8 + 0.00363065505922712*G0_1_0_3_9 + 0.00544249401392352*G0_1_0_4_0 - 0.000847089418518108*G0_1_0_4_1 - 0.060872460872471*G0_1_0_4_2 + 0.00517482517482609*G0_1_0_4_3 + 0.142497502497527*G0_1_0_4_4 - 0.0180019980020011*G0_1_0_4_5 + 0.0247352647352689*G0_1_0_4_6 - 0.00770943342372044*G0_1_0_4_7 + 0.0001170258313116*G0_1_0_4_8 + 0.0272127872127917*G0_1_0_4_9 - 0.00236017950303705*G0_1_0_5_0 - 0.000874998017855308*G0_1_0_5_1 + 0.0144078144078167*G0_1_0_5_2 + 0.00313971742543224*G0_1_0_5_3 - 0.0180019980020011*G0_1_0_5_4 + 0.0133295276152443*G0_1_0_5_5 - 0.0355044955045016*G0_1_0_5_6 + 0.00148993863279603*G0_1_0_5_7 + 0.000950478093335379*G0_1_0_5_8 - 0.0073983159697457*G0_1_0_5_9 + 0.00725591868449139*G0_1_0_6_0 + 0.00168625025767912*G0_1_0_6_1 - 0.0192252192252222*G0_1_0_6_2 - 0.00673326673326782*G0_1_0_6_3 + 0.0247352647352689*G0_1_0_6_4 - 0.0355044955045016*G0_1_0_6_5 + 0.133706293706316*G0_1_0_6_6 - 0.00244041672613141*G0_1_0_6_7 - 0.000796346510632309*G0_1_0_6_8 + 0.00467532467532526*G0_1_0_6_9 + 0.00179185893471638*G0_1_0_7_0 + 0.000148740148740217*G0_1_0_7_1 + 0.000255300255300292*G0_1_0_7_2 + 0.000305408876837517*G0_1_0_7_3 - 0.00770943342372044*G0_1_0_7_4 + 0.00148993863279603*G0_1_0_7_5 - 0.00244041672613141*G0_1_0_7_6 + 0.0107835022120753*G0_1_0_7_7 - 0.000545169116597711*G0_1_0_7_8 - 0.000616526330812105*G0_1_0_7_9 - 0.00121180406894714*G0_1_0_8_0 - 0.000597180597180718*G0_1_0_8_2 - 0.000422434708149125*G0_1_0_8_3 + 0.000117025831311599*G0_1_0_8_4 + 0.000950478093335379*G0_1_0_8_5 - 0.000796346510632307*G0_1_0_8_6 - 0.000545169116597711*G0_1_0_8_7 + 0.00307692307692333*G0_1_0_8_8 + 0.00400742115027895*G0_1_0_8_9 + 0.00183245326102498*G0_1_0_9_0 - 0.00141382427096739*G0_1_0_9_1 + 0.00293040293040345*G0_1_0_9_2 + 0.00363065505922712*G0_1_0_9_3 + 0.0272127872127917*G0_1_0_9_4 - 0.00739831596974569*G0_1_0_9_5 + 0.00467532467532525*G0_1_0_9_6 - 0.000616526330812105*G0_1_0_9_7 + 0.00400742115027895*G0_1_0_9_8 - 0.0355530184101675*G0_1_0_9_9;
    A[153] = A[82] - 0.00683563350230137*G0_0_0_0_0 + 0.00181402371878595*G0_0_0_0_1 - 0.0113870961490028*G0_0_0_0_2 + 0.00675292961007369*G0_0_0_0_3 - 0.00949938949939117*G0_0_0_0_4 - 0.00557093699950942*G0_0_0_0_5 + 0.00661402089973638*G0_0_0_0_6 + 0.000740212168783703*G0_0_0_0_7 - 0.00511393368536309*G0_0_0_0_8 - 0.00300080871509492*G0_0_0_0_9 + 0.00181402371878595*G0_0_0_1_0 + 0.0578519892805704*G0_0_0_1_1 - 0.00985769081007344*G0_0_0_1_2 + 0.0930764473621775*G0_0_0_1_3 - 0.0566966366966463*G0_0_0_1_4 - 0.00204589061731955*G0_0_0_1_5 - 0.000599717742574963*G0_0_0_1_6 - 0.0114200085628677*G0_0_0_1_7 + 0.0183625897911644*G0_0_0_1_8 + 0.00934494077351384*G0_0_0_1_9 - 0.0113870961490028*G0_0_0_2_0 - 0.00985769081007344*G0_0_0_2_1 - 0.297293817293867*G0_0_0_2_2 + 0.0896379810665675*G0_0_0_2_3 - 0.183340469054786*G0_0_0_2_4 + 0.0427972027972098*G0_0_0_2_5 - 0.079383473669201*G0_0_0_2_6 + 0.0020186163043309*G0_0_0_2_7 - 0.00299161156304063*G0_0_0_2_8 - 0.0248893963179719*G0_0_0_2_9 + 0.00675292961007369*G0_0_0_3_0 + 0.0930764473621775*G0_0_0_3_1 + 0.0896379810665675*G0_0_0_3_2 + 0.292747252747303*G0_0_0_3_3 + 0.0499643213929011*G0_0_0_3_4 - 0.0116968745540193*G0_0_0_3_5 + 0.0110717853575014*G0_0_0_3_6 - 0.0109861567004444*G0_0_0_3_7 - 0.00726131011845391*G0_0_0_3_8 - 0.00606250891965251*G0_0_0_3_9 - 0.00949938949939117*G0_0_0_4_0 - 0.0566966366966463*G0_0_0_4_1 - 0.183340469054786*G0_0_0_4_2 + 0.0499643213929011*G0_0_0_4_3 - 0.313863279577619*G0_0_0_4_4 + 0.0377708006279498*G0_0_0_4_5 - 0.0488425859854513*G0_0_0_4_6 + 0.00658484372770203*G0_0_0_4_7 + 0.0182474668188983*G0_0_0_4_8 - 0.00087341230198389*G0_0_0_4_9 - 0.00557093699950941*G0_0_0_5_0 - 0.00204589061731955*G0_0_0_5_1 + 0.0427972027972098*G0_0_0_5_2 - 0.0116968745540193*G0_0_0_5_3 + 0.0377708006279498*G0_0_0_5_4 - 0.0773740545169245*G0_0_0_5_5 - 0.0075610104181548*G0_0_0_5_6 - 0.0186270871985189*G0_0_0_5_7 + 0.0154103039817351*G0_0_0_5_8 - 0.0218181818181856*G0_0_0_5_9 + 0.00661402089973638*G0_0_0_6_0 - 0.000599717742574963*G0_0_0_6_1 - 0.079383473669201*G0_0_0_6_2 + 0.0110717853575014*G0_0_0_6_3 - 0.0488425859854513*G0_0_0_6_4 - 0.0075610104181548*G0_0_0_6_5 + 0.143016983017008*G0_0_0_6_6 + 0.00321678321678378*G0_0_0_6_7 + 0.000750677893535133*G0_0_0_6_8 + 0.0525246182389128*G0_0_0_6_9 + 0.000740212168783703*G0_0_0_7_0 - 0.0114200085628677*G0_0_0_7_1 + 0.0020186163043309*G0_0_0_7_2 - 0.0109861567004444*G0_0_0_7_3 + 0.00658484372770203*G0_0_0_7_4 - 0.0186270871985189*G0_0_0_7_5 + 0.00321678321678378*G0_0_0_7_6 - 0.028748394462685*G0_0_0_7_7 + 0.0316797488226112*G0_0_0_7_8 + 0.00256885971171719*G0_0_0_7_9 - 0.00511393368536309*G0_0_0_8_0 + 0.0183625897911644*G0_0_0_8_1 - 0.00299161156304062*G0_0_0_8_2 - 0.0072613101184539*G0_0_0_8_3 + 0.0182474668188983*G0_0_0_8_4 + 0.0154103039817351*G0_0_0_8_5 + 0.000750677893535133*G0_0_0_8_6 + 0.0316797488226112*G0_0_0_8_7 - 0.104409875838465*G0_0_0_8_8 - 0.0645297559583381*G0_0_0_8_9 - 0.00300080871509492*G0_0_0_9_0 + 0.00934494077351385*G0_0_0_9_1 - 0.0248893963179719*G0_0_0_9_2 - 0.00606250891965251*G0_0_0_9_3 - 0.000873412301983883*G0_0_0_9_4 - 0.0218181818181856*G0_0_0_9_5 + 0.0525246182389128*G0_0_0_9_6 + 0.00256885971171719*G0_0_0_9_7 - 0.0645297559583381*G0_0_0_9_8 - 0.119195090623682*G0_0_0_9_9 + 0.00691012691012816*G0_0_1_0_1 - 0.00691012691012809*G0_0_1_0_2 + 0.00599971457114424*G0_0_1_0_3 - 0.00599971457114422*G0_0_1_0_4 - 0.00362431219574145*G0_0_1_0_5 + 0.00952063809206836*G0_0_1_0_6 + 0.00362431219574132*G0_0_1_0_7 - 0.00952063809206821*G0_0_1_0_8 + 0.00691012691012815*G0_0_1_1_0 + 0.26253689872742*G0_0_1_1_1 + 0.162439465296636*G0_0_1_1_3 - 0.08421958993389*G0_0_1_1_4 - 0.00172399029541923*G0_0_1_1_5 + 0.00349364920793555*G0_0_1_1_6 - 0.0284214198499963*G0_0_1_1_7 + 0.0466435152149522*G0_0_1_1_8 + 0.0142428999571882*G0_0_1_1_9 - 0.00691012691012809*G0_0_1_2_0 - 0.262536898727419*G0_0_1_2_2 + 0.0842195899338898*G0_0_1_2_3 - 0.162439465296635*G0_0_1_2_4 + 0.0284214198499959*G0_0_1_2_5 - 0.0466435152149514*G0_0_1_2_6 + 0.00172399029541911*G0_0_1_2_7 - 0.00349364920793547*G0_0_1_2_8 - 0.014242899957188*G0_0_1_2_9 + 0.00599971457114424*G0_0_1_3_0 + 0.162439465296636*G0_0_1_3_1 + 0.0842195899338898*G0_0_1_3_2 + 0.250018552875739*G0_0_1_3_3 - 0.0064135864135875*G0_0_1_3_5 - 0.0104809476238066*G0_0_1_3_6 - 0.0179991437134327*G0_0_1_3_7 + 0.00751819608962642*G0_0_1_3_8 - 0.00673041244469897*G0_0_1_3_9 - 0.00599971457114422*G0_0_1_4_0 - 0.08421958993389*G0_0_1_4_1 - 0.162439465296635*G0_0_1_4_2 - 0.250018552875738*G0_0_1_4_4 + 0.0179991437134325*G0_0_1_4_5 - 0.00751819608962589*G0_0_1_4_6 + 0.00641358641358759*G0_0_1_4_7 + 0.0104809476238063*G0_0_1_4_8 + 0.00673041244469919*G0_0_1_4_9 - 0.00362431219574145*G0_0_1_5_0 - 0.00172399029541923*G0_0_1_5_1 + 0.0284214198499959*G0_0_1_5_2 - 0.0064135864135875*G0_0_1_5_3 + 0.0179991437134325*G0_0_1_5_4 + 0.00916797488226225*G0_0_1_5_5 - 0.0410789210789282*G0_0_1_5_6 + 0.00517197088625745*G0_0_1_5_8 - 0.0103439417725149*G0_0_1_5_9 + 0.00952063809206836*G0_0_1_6_0 + 0.00349364920793555*G0_0_1_6_1 - 0.0466435152149514*G0_0_1_6_2 - 0.0104809476238066*G0_0_1_6_3 - 0.00751819608962589*G0_0_1_6_4 - 0.0410789210789282*G0_0_1_6_5 + 0.211851006136757*G0_0_1_6_6 - 0.00517197088625742*G0_0_1_6_7 + 0.0636905951191772*G0_0_1_6_9 + 0.00362431219574132*G0_0_1_7_0 - 0.0284214198499963*G0_0_1_7_1 + 0.00172399029541911*G0_0_1_7_2 - 0.0179991437134327*G0_0_1_7_3 + 0.00641358641358759*G0_0_1_7_4 - 0.00517197088625742*G0_0_1_7_6 - 0.0091679748822622*G0_0_1_7_7 + 0.0410789210789278*G0_0_1_7_8 + 0.0103439417725148*G0_0_1_7_9 - 0.00952063809206821*G0_0_1_8_0 + 0.0466435152149522*G0_0_1_8_1 - 0.00349364920793546*G0_0_1_8_2 + 0.00751819608962642*G0_0_1_8_3 + 0.0104809476238063*G0_0_1_8_4 + 0.00517197088625745*G0_0_1_8_5 + 0.0410789210789278*G0_0_1_8_7 - 0.211851006136755*G0_0_1_8_8 - 0.0636905951191771*G0_0_1_8_9 + 0.0142428999571882*G0_0_1_9_1 - 0.014242899957188*G0_0_1_9_2 - 0.00673041244469897*G0_0_1_9_3 + 0.00673041244469919*G0_0_1_9_4 - 0.0103439417725149*G0_0_1_9_5 + 0.0636905951191772*G0_0_1_9_6 + 0.0103439417725148*G0_0_1_9_7 - 0.0636905951191771*G0_0_1_9_8 + 0.00315451744023228*G0_1_0_0_1 - 0.00315451744023227*G0_1_0_0_2 + 0.0121021835307571*G0_1_0_0_3 - 0.0121021835307571*G0_1_0_0_4 + 0.000527726242012031*G0_1_0_0_5 + 0.00105291533862982*G0_1_0_0_6 - 0.000527726242012066*G0_1_0_0_7 - 0.00105291533862977*G0_1_0_0_8 + 0.00315451744023228*G0_1_0_1_0 + 0.0672216672216786*G0_1_0_1_1 + 0.101495964353124*G0_1_0_1_3 - 0.0567990739419407*G0_1_0_1_4 - 0.00059369202226356*G0_1_0_1_5 + 0.00121021835307573*G0_1_0_1_6 - 0.0141623455909195*G0_1_0_1_7 + 0.0274950446379066*G0_1_0_1_8 + 0.018587127158559*G0_1_0_1_9 - 0.00315451744023227*G0_1_0_2_0 - 0.0672216672216784*G0_1_0_2_2 + 0.0567990739419407*G0_1_0_2_3 - 0.101495964353124*G0_1_0_2_4 + 0.0141623455909194*G0_1_0_2_5 - 0.0274950446379064*G0_1_0_2_6 + 0.000593692022263534*G0_1_0_2_7 - 0.00121021835307568*G0_1_0_2_8 - 0.0185871271585588*G0_1_0_2_9 + 0.0121021835307571*G0_1_0_3_0 + 0.101495964353124*G0_1_0_3_1 + 0.0567990739419407*G0_1_0_3_2 + 0.388617097188592*G0_1_0_3_3 - 0.0172627372627401*G0_1_0_3_5 - 0.00363065505922717*G0_1_0_3_6 - 0.0363065505922711*G0_1_0_3_7 + 0.0326758955330441*G0_1_0_3_8 + 0.0168517197088656*G0_1_0_3_9 - 0.0121021835307571*G0_1_0_4_0 - 0.0567990739419407*G0_1_0_4_1 - 0.101495964353124*G0_1_0_4_2 - 0.388617097188592*G0_1_0_4_4 + 0.036306550592271*G0_1_0_4_5 - 0.0326758955330438*G0_1_0_4_6 + 0.0172627372627402*G0_1_0_4_7 + 0.00363065505922698*G0_1_0_4_8 - 0.0168517197088653*G0_1_0_4_9 + 0.00052772624201203*G0_1_0_5_0 - 0.000593692022263561*G0_1_0_5_1 + 0.0141623455909194*G0_1_0_5_2 - 0.0172627372627401*G0_1_0_5_3 + 0.036306550592271*G0_1_0_5_4 + 0.00662194947909359*G0_1_0_5_5 - 0.00611959469102433*G0_1_0_5_6 + 0.00178107606679065*G0_1_0_5_8 - 0.00356215213358134*G0_1_0_5_9 + 0.00105291533862982*G0_1_0_6_0 + 0.00121021835307573*G0_1_0_6_1 - 0.0274950446379064*G0_1_0_6_2 - 0.00363065505922717*G0_1_0_6_3 - 0.0326758955330438*G0_1_0_6_4 - 0.00611959469102433*G0_1_0_6_5 + 0.0812216355073642*G0_1_0_6_6 - 0.00178107606679064*G0_1_0_6_7 + 0.0630226915941309*G0_1_0_6_9 - 0.000527726242012067*G0_1_0_7_0 - 0.0141623455909195*G0_1_0_7_1 + 0.000593692022263534*G0_1_0_7_2 - 0.0363065505922711*G0_1_0_7_3 + 0.0172627372627402*G0_1_0_7_4 - 0.00178107606679064*G0_1_0_7_6 - 0.00662194947909341*G0_1_0_7_7 + 0.00611959469102415*G0_1_0_7_8 + 0.00356215213358125*G0_1_0_7_9 - 0.00105291533862977*G0_1_0_8_0 + 0.0274950446379066*G0_1_0_8_1 - 0.00121021835307568*G0_1_0_8_2 + 0.0326758955330441*G0_1_0_8_3 + 0.00363065505922698*G0_1_0_8_4 + 0.00178107606679065*G0_1_0_8_5 + 0.00611959469102415*G0_1_0_8_7 - 0.081221635507363*G0_1_0_8_8 - 0.0630226915941307*G0_1_0_8_9 + 0.018587127158559*G0_1_0_9_1 - 0.0185871271585588*G0_1_0_9_2 + 0.0168517197088656*G0_1_0_9_3 - 0.0168517197088653*G0_1_0_9_4 - 0.00356215213358134*G0_1_0_9_5 + 0.0630226915941309*G0_1_0_9_6 + 0.00356215213358125*G0_1_0_9_7 - 0.0630226915941307*G0_1_0_9_8 + 0.00683563350230129*G0_1_1_0_0 + 0.0113870961490029*G0_1_1_0_1 - 0.00181402371878594*G0_1_1_0_2 + 0.00949938949939118*G0_1_1_0_3 - 0.00675292961007367*G0_1_1_0_4 - 0.000740212168783746*G0_1_1_0_5 + 0.00511393368536315*G0_1_1_0_6 + 0.00557093699950932*G0_1_1_0_7 - 0.00661402089973625*G0_1_1_0_8 + 0.00300080871509498*G0_1_1_0_9 + 0.0113870961490029*G0_1_1_1_0 + 0.297293817293868*G0_1_1_1_1 + 0.00985769081007342*G0_1_1_1_2 + 0.183340469054786*G0_1_1_1_3 - 0.0896379810665677*G0_1_1_1_4 - 0.00201861630433102*G0_1_1_1_5 + 0.00299161156304068*G0_1_1_1_6 - 0.0427972027972103*G0_1_1_1_7 + 0.0793834736692019*G0_1_1_1_8 + 0.0248893963179721*G0_1_1_1_9 - 0.00181402371878594*G0_1_1_2_0 + 0.00985769081007342*G0_1_1_2_1 - 0.0578519892805703*G0_1_1_2_2 + 0.0566966366966463*G0_1_1_2_3 - 0.0930764473621774*G0_1_1_2_4 + 0.0114200085628676*G0_1_1_2_5 - 0.0183625897911643*G0_1_1_2_6 + 0.00204589061731951*G0_1_1_2_7 + 0.000599717742575037*G0_1_1_2_8 - 0.00934494077351375*G0_1_1_2_9 + 0.00949938949939118*G0_1_1_3_0 + 0.183340469054786*G0_1_1_3_1 + 0.0566966366966463*G0_1_1_3_2 + 0.313863279577619*G0_1_1_3_3 - 0.0499643213929013*G0_1_1_3_4 - 0.00658484372770197*G0_1_1_3_5 - 0.0182474668188985*G0_1_1_3_6 - 0.03777080062795*G0_1_1_3_7 + 0.0488425859854518*G0_1_1_3_8 + 0.000873412301984126*G0_1_1_3_9 - 0.00675292961007367*G0_1_1_4_0 - 0.0896379810665677*G0_1_1_4_1 - 0.0930764473621774*G0_1_1_4_2 - 0.0499643213929013*G0_1_1_4_3 - 0.292747252747302*G0_1_1_4_4 + 0.0109861567004443*G0_1_1_4_5 + 0.00726131011845423*G0_1_1_4_6 + 0.0116968745540194*G0_1_1_4_7 - 0.0110717853575017*G0_1_1_4_8 + 0.00606250891965279*G0_1_1_4_9 - 0.000740212168783746*G0_1_1_5_0 - 0.00201861630433102*G0_1_1_5_1 + 0.0114200085628676*G0_1_1_5_2 - 0.00658484372770197*G0_1_1_5_3 + 0.0109861567004442*G0_1_1_5_4 + 0.0287483944626849*G0_1_1_5_5 - 0.0316797488226113*G0_1_1_5_6 + 0.0186270871985189*G0_1_1_5_7 - 0.00321678321678375*G0_1_1_5_8 - 0.00256885971171738*G0_1_1_5_9 + 0.00511393368536315*G0_1_1_6_0 + 0.00299161156304068*G0_1_1_6_1 - 0.0183625897911643*G0_1_1_6_2 - 0.0182474668188985*G0_1_1_6_3 + 0.00726131011845424*G0_1_1_6_4 - 0.0316797488226113*G0_1_1_6_5 + 0.104409875838465*G0_1_1_6_6 - 0.0154103039817351*G0_1_1_6_7 - 0.000750677893535239*G0_1_1_6_8 + 0.0645297559583383*G0_1_1_6_9 + 0.00557093699950932*G0_1_1_7_0 - 0.0427972027972103*G0_1_1_7_1 + 0.00204589061731951*G0_1_1_7_2 - 0.03777080062795*G0_1_1_7_3 + 0.0116968745540194*G0_1_1_7_4 + 0.0186270871985189*G0_1_1_7_5 - 0.0154103039817351*G0_1_1_7_6 + 0.0773740545169248*G0_1_1_7_7 + 0.00756101041815432*G0_1_1_7_8 + 0.0218181818181854*G0_1_1_7_9 - 0.00661402089973625*G0_1_1_8_0 + 0.0793834736692019*G0_1_1_8_1 + 0.000599717742575037*G0_1_1_8_2 + 0.0488425859854518*G0_1_1_8_3 - 0.0110717853575017*G0_1_1_8_4 - 0.00321678321678375*G0_1_1_8_5 - 0.000750677893535239*G0_1_1_8_6 + 0.00756101041815431*G0_1_1_8_7 - 0.143016983017006*G0_1_1_8_8 - 0.0525246182389126*G0_1_1_8_9 + 0.00300080871509498*G0_1_1_9_0 + 0.0248893963179721*G0_1_1_9_1 - 0.00934494077351375*G0_1_1_9_2 + 0.000873412301984126*G0_1_1_9_3 + 0.00606250891965279*G0_1_1_9_4 - 0.00256885971171738*G0_1_1_9_5 + 0.0645297559583383*G0_1_1_9_6 + 0.0218181818181854*G0_1_1_9_7 - 0.0525246182389126*G0_1_1_9_8 + 0.119195090623682*G0_1_1_9_9;
    A[100] = A[153] + 0.0651082251082363*G0_0_0_0_0 + 0.00793090507376358*G0_0_0_0_2 - 0.00729936729936863*G0_0_0_0_3 - 0.0016497787926362*G0_0_0_0_4 + 0.0909826681255408*G0_0_0_0_5 - 0.0385354328211537*G0_0_0_0_6 + 0.017282400139546*G0_0_0_0_7 - 0.00624264624264737*G0_0_0_0_8 + 0.013183007468724*G0_0_0_0_9 - 0.065108225108236*G0_0_0_1_1 - 0.00793090507376355*G0_0_0_1_2 - 0.0909826681255408*G0_0_0_1_3 + 0.0385354328211537*G0_0_0_1_4 + 0.00729936729936852*G0_0_0_1_5 + 0.00164977879263622*G0_0_0_1_6 + 0.00624264624264737*G0_0_0_1_7 - 0.017282400139546*G0_0_0_1_8 - 0.0131830074687241*G0_0_0_1_9 + 0.00793090507376358*G0_0_0_2_0 - 0.00793090507376355*G0_0_0_2_1 - 0.0134519448805187*G0_0_0_2_3 + 0.00734249877107151*G0_0_0_2_4 + 0.0134519448805186*G0_0_0_2_5 - 0.00734249877107138*G0_0_0_2_6 - 0.00479710765425128*G0_0_0_2_7 + 0.00479710765425127*G0_0_0_2_8 - 0.00729936729936863*G0_0_0_3_0 - 0.0909826681255408*G0_0_0_3_1 - 0.0134519448805187*G0_0_0_3_2 - 0.39761381475674*G0_0_0_3_3 + 0.0636335093478061*G0_0_0_3_4 - 0.00494933637790862*G0_0_0_3_6 + 0.0218981018981058*G0_0_0_3_7 - 0.007506778935352*G0_0_0_3_8 - 0.00424718139003961*G0_0_0_3_9 - 0.0016497787926362*G0_0_0_4_0 + 0.0385354328211537*G0_0_0_4_1 + 0.00734249877107151*G0_0_0_4_2 + 0.0636335093478061*G0_0_0_4_3 - 0.0386242329099538*G0_0_0_4_4 + 0.00494933637790859*G0_0_0_4_5 + 0.0096703296703312*G0_0_0_4_7 - 0.0143913229627538*G0_0_0_4_8 - 0.0098986727558172*G0_0_0_4_9 + 0.0909826681255408*G0_0_0_5_0 + 0.00729936729936852*G0_0_0_5_1 + 0.0134519448805186*G0_0_0_5_2 + 0.00494933637790859*G0_0_0_5_4 + 0.397613814756739*G0_0_0_5_5 - 0.063633509347806*G0_0_0_5_6 + 0.00750677893535166*G0_0_0_5_7 - 0.0218981018981056*G0_0_0_5_8 + 0.00424718139003937*G0_0_0_5_9 - 0.0385354328211537*G0_0_0_6_0 + 0.00164977879263622*G0_0_0_6_1 - 0.00734249877107138*G0_0_0_6_2 - 0.00494933637790862*G0_0_0_6_3 - 0.063633509347806*G0_0_0_6_5 + 0.0386242329099538*G0_0_0_6_6 + 0.0143913229627539*G0_0_0_6_7 - 0.00967032967033123*G0_0_0_6_8 + 0.00989867275581723*G0_0_0_6_9 + 0.017282400139546*G0_0_0_7_0 + 0.00624264624264737*G0_0_0_7_1 - 0.00479710765425128*G0_0_0_7_2 + 0.0218981018981058*G0_0_0_7_3 + 0.00967032967033121*G0_0_0_7_4 + 0.00750677893535166*G0_0_0_7_5 + 0.0143913229627539*G0_0_0_7_6 - 0.0793606393606524*G0_0_0_7_7 - 0.0683316683316796*G0_0_0_7_9 - 0.00624264624264737*G0_0_0_8_0 - 0.017282400139546*G0_0_0_8_1 + 0.00479710765425126*G0_0_0_8_2 - 0.00750677893535201*G0_0_0_8_3 - 0.0143913229627538*G0_0_0_8_4 - 0.0218981018981056*G0_0_0_8_5 - 0.00967032967033123*G0_0_0_8_6 + 0.079360639360652*G0_0_0_8_8 + 0.0683316683316796*G0_0_0_8_9 + 0.013183007468724*G0_0_0_9_0 - 0.0131830074687241*G0_0_0_9_1 - 0.00424718139003962*G0_0_0_9_3 - 0.0098986727558172*G0_0_0_9_4 + 0.00424718139003937*G0_0_0_9_5 + 0.00989867275581723*G0_0_0_9_6 - 0.0683316683316796*G0_0_0_9_7 + 0.0683316683316796*G0_0_0_9_8 - 0.00565755232421976*G0_0_1_0_0 - 0.00787519358948071*G0_0_1_0_1 - 0.00138665567237019*G0_0_1_0_2 - 0.00718424432710279*G0_0_1_0_3 + 0.00198943913229664*G0_0_1_0_4 - 0.00943437514866233*G0_0_1_0_5 + 0.00516531087959742*G0_0_1_0_6 - 0.0118954061811223*G0_0_1_0_7 + 0.0111339454196615*G0_0_1_0_8 - 0.0019580419580423*G0_0_1_0_9 - 0.00787519358948071*G0_0_1_1_0 - 0.269732243065623*G0_0_1_1_1 - 0.0154826126254724*G0_0_1_1_2 - 0.163081363081391*G0_0_1_1_3 + 0.0714859743431294*G0_0_1_1_4 - 0.00507207078635728*G0_0_1_1_5 + 0.00370201227344146*G0_0_1_1_6 + 0.0245284873856346*G0_0_1_1_7 - 0.0460428460428543*G0_0_1_1_8 - 0.014043099757388*G0_0_1_1_9 - 0.00138665567237019*G0_0_1_2_0 - 0.0154826126254724*G0_0_1_2_1 - 0.000529417672274901*G0_0_1_2_2 - 0.0194342165770771*G0_0_1_2_3 + 0.00958533529962265*G0_0_1_2_4 - 0.0049864421293001*G0_0_1_2_5 + 0.00209504780933389*G0_0_1_2_6 - 0.00197802197802228*G0_0_1_2_7 + 0.00538033395176335*G0_0_1_2_8 + 0.000108462965605804*G0_0_1_2_9 - 0.00718424432710279*G0_0_1_3_0 - 0.163081363081391*G0_0_1_3_1 - 0.0194342165770771*G0_0_1_3_2 - 0.350843442272074*G0_0_1_3_3 + 0.0898273155416167*G0_0_1_3_4 + 0.014411302982734*G0_0_1_3_5 - 0.00315969744541224*G0_0_1_3_6 + 0.0294990723562205*G0_0_1_3_7 - 0.0213044098758426*G0_0_1_3_8 - 0.0168688454402773*G0_0_1_3_9 + 0.00198943913229664*G0_0_1_4_0 + 0.0714859743431294*G0_0_1_4_1 + 0.00958533529962265*G0_0_1_4_2 + 0.0898273155416167*G0_0_1_4_3 - 0.0428714142999931*G0_0_1_4_4 + 0.0019780219780223*G0_0_1_4_5 + 0.00118167546738995*G0_0_1_4_6 - 0.00399029541886762*G0_0_1_4_7 - 0.00819466248037788*G0_0_1_4_8 - 0.00428143285286199*G0_0_1_4_9 - 0.00943437514866233*G0_0_1_5_0 - 0.00507207078635728*G0_0_1_5_1 - 0.0049864421293001*G0_0_1_5_2 + 0.014411302982734*G0_0_1_5_3 + 0.0019780219780223*G0_0_1_5_4 - 0.084943627800785*G0_0_1_5_5 + 0.0204738119023866*G0_0_1_5_6 - 0.0370429570429632*G0_0_1_5_7 + 0.0231625517339842*G0_0_1_5_8 - 0.0404509775938416*G0_0_1_5_9 + 0.00516531087959742*G0_0_1_6_0 + 0.00370201227344146*G0_0_1_6_1 + 0.00209504780933389*G0_0_1_6_2 - 0.00315969744541224*G0_0_1_6_3 + 0.00118167546738995*G0_0_1_6_4 + 0.0204738119023866*G0_0_1_6_5 - 0.00506921649778867*G0_0_1_6_6 + 0.013880405308979*G0_0_1_6_7 - 0.0175966890252633*G0_0_1_6_8 + 0.00599400599400705*G0_0_1_6_9 - 0.0118954061811223*G0_0_1_7_0 + 0.0245284873856346*G0_0_1_7_1 - 0.00197802197802228*G0_0_1_7_2 + 0.0294990723562205*G0_0_1_7_3 - 0.00399029541886762*G0_0_1_7_4 - 0.0370429570429632*G0_0_1_7_5 + 0.013880405308979*G0_0_1_7_6 - 0.0102411873840462*G0_0_1_7_7 - 0.0172370486656228*G0_0_1_7_8 - 0.0218866847438312*G0_0_1_7_9 + 0.0111339454196615*G0_0_1_8_0 - 0.0460428460428543*G0_0_1_8_1 + 0.00538033395176335*G0_0_1_8_2 - 0.0213044098758426*G0_0_1_8_3 - 0.00819466248037788*G0_0_1_8_4 + 0.0231625517339842*G0_0_1_8_5 - 0.0175966890252633*G0_0_1_8_6 - 0.0172370486656228*G0_0_1_8_7 + 0.189496218067677*G0_0_1_8_8 + 0.0585186242329195*G0_0_1_8_9 - 0.0019580419580423*G0_0_1_9_0 - 0.014043099757388*G0_0_1_9_1 + 0.000108462965605803*G0_0_1_9_2 - 0.0168688454402773*G0_0_1_9_3 - 0.00428143285286199*G0_0_1_9_4 - 0.0404509775938416*G0_0_1_9_5 + 0.00599400599400705*G0_0_1_9_6 - 0.0218866847438312*G0_0_1_9_7 + 0.0585186242329195*G0_0_1_9_8 - 0.033703439417731*G0_0_1_9_9 - 0.204624017957387*G0_1_0_0_0 - 0.00787519358948069*G0_1_0_0_1 - 0.00755170755170886*G0_1_0_0_2 - 0.0123714380857259*G0_1_0_0_3 + 0.00205223348080527*G0_1_0_0_4 - 0.0720986949558503*G0_1_0_0_5 + 0.0329505415219758*G0_1_0_0_6 - 0.0287604459033081*G0_1_0_0_7 + 0.0182858411429872*G0_1_0_0_8 - 0.000860092288663996*G0_1_0_0_9 - 0.00787519358948069*G0_1_0_1_0 - 0.0707657774324558*G0_1_0_1_1 - 0.00931756074613373*G0_1_0_1_2 - 0.100417043274203*G0_1_0_1_3 + 0.0437007437007511*G0_1_0_1_4 + 0.000115122972265838*G0_1_0_1_5 + 0.00363921792493283*G0_1_0_1_6 + 0.0173765916623089*G0_1_0_1_7 - 0.0291778063206684*G0_1_0_1_8 - 0.0151410494267663*G0_1_0_1_9 - 0.00755170755170885*G0_1_0_2_0 - 0.00931756074613373*G0_1_0_2_1 - 0.000529417672274834*G0_1_0_2_2 - 0.0184383870098187*G0_1_0_2_3 + 0.00943754658040535*G0_1_0_2_4 - 0.00598227169655844*G0_1_0_2_5 + 0.00224283652855121*G0_1_0_2_6 + 0.000583226297512104*G0_1_0_2_7 + 0.00281908567622899*G0_1_0_2_8 + 0.000108462965605825*G0_1_0_2_9 - 0.0123714380857259*G0_1_0_3_0 - 0.100417043274203*G0_1_0_3_1 - 0.0184383870098187*G0_1_0_3_2 - 0.482557442557525*G0_1_0_3_3 + 0.0841073212501926*G0_1_0_3_4 + 0.014411302982734*G0_1_0_3_5 - 0.00297131439988631*G0_1_0_3_6 + 0.0450606536320899*G0_1_0_3_7 - 0.0445497359783151*G0_1_0_3_8 - 0.0446981589838811*G0_1_0_3_9 + 0.00205223348080527*G0_1_0_4_0 + 0.0437007437007511*G0_1_0_4_1 + 0.00943754658040535*G0_1_0_4_2 + 0.0841073212501926*G0_1_0_4_3 - 0.0436934494077424*G0_1_0_4_4 + 0.00178963893249638*G0_1_0_4_5 + 0.00118167546738994*G0_1_0_4_6 - 0.00792635935493214*G0_1_0_4_7 - 0.000510917653774803*G0_1_0_4_8 - 0.00390466676181021*G0_1_0_4_9 - 0.0720986949558503*G0_1_0_5_0 + 0.000115122972265838*G0_1_0_5_1 - 0.00598227169655844*G0_1_0_5_2 + 0.014411302982734*G0_1_0_5_3 + 0.00178963893249638*G0_1_0_5_4 + 0.0467703724846657*G0_1_0_5_5 + 0.0261938061938107*G0_1_0_5_6 - 0.0137976309404905*G0_1_0_5_7 + 0.00760097045811467*G0_1_0_5_8 - 0.0126216640502377*G0_1_0_5_9 + 0.0329505415219758*G0_1_0_6_0 + 0.00363921792493283*G0_1_0_6_1 + 0.00224283652855121*G0_1_0_6_2 - 0.00297131439988632*G0_1_0_6_3 + 0.00118167546738994*G0_1_0_6_4 + 0.0261938061938107*G0_1_0_6_5 - 0.00424718139003946*G0_1_0_6_6 + 0.00619666048237586*G0_1_0_6_7 - 0.0136606250891988*G0_1_0_6_8 + 0.00561723990295515*G0_1_0_6_9 - 0.0287604459033081*G0_1_0_7_0 + 0.0173765916623089*G0_1_0_7_1 + 0.000583226297512103*G0_1_0_7_2 + 0.0450606536320899*G0_1_0_7_3 - 0.00792635935493214*G0_1_0_7_4 - 0.0137976309404905*G0_1_0_7_5 + 0.00619666048237586*G0_1_0_7_6 + 0.110135578707026*G0_1_0_7_7 - 0.0172370486656228*G0_1_0_7_8 - 0.00981304409875999*G0_1_0_7_9 + 0.0182858411429872*G0_1_0_8_0 - 0.0291778063206684*G0_1_0_8_1 + 0.00281908567622899*G0_1_0_8_2 - 0.0445497359783151*G0_1_0_8_3 - 0.0005109176537748*G0_1_0_8_4 + 0.00760097045811466*G0_1_0_8_5 - 0.0136606250891988*G0_1_0_8_6 - 0.0172370486656228*G0_1_0_8_7 + 0.0691194519766061*G0_1_0_8_8 + 0.0464449835878485*G0_1_0_8_9 - 0.000860092288663997*G0_1_0_9_0 - 0.0151410494267663*G0_1_0_9_1 + 0.000108462965605826*G0_1_0_9_2 - 0.0446981589838811*G0_1_0_9_3 - 0.00390466676181021*G0_1_0_9_4 - 0.0126216640502377*G0_1_0_9_5 + 0.00561723990295515*G0_1_0_9_6 - 0.00981304409875999*G0_1_0_9_7 + 0.0464449835878485*G0_1_0_9_8 - 0.033703439417731*G0_1_0_9_9 + 0.0252784252784292*G0_1_1_0_0 - 0.00787519358948073*G0_1_1_0_1 + 0.000543900543900617*G0_1_1_0_2 - 0.013008895866041*G0_1_1_0_3 + 0.00330241187384103*G0_1_1_0_4 + 0.0125081267938431*G0_1_1_0_5 - 0.00504289361432297*G0_1_1_0_6 + 0.0272565529708432*G0_1_1_0_7 - 0.0114885114885134*G0_1_1_0_8 + 0.00235003092145988*G0_1_1_0_9 - 0.00787519358948073*G0_1_1_1_0 - 0.300668220668272*G0_1_1_1_1 - 0.0174131688417432*G0_1_1_1_2 - 0.185023865023897*G0_1_1_1_3 + 0.0816941788370498*G0_1_1_1_4 + 0.000752580752580941*G0_1_1_1_5 + 0.00238903953189706*G0_1_1_1_6 + 0.0471509442938096*G0_1_1_1_7 - 0.08519480519482*G0_1_1_1_8 - 0.0183511726368901*G0_1_1_1_9 + 0.000543900543900617*G0_1_1_2_0 - 0.0174131688417432*G0_1_1_2_1 - 0.000529417672274901*G0_1_1_2_2 - 0.0246302903445802*G0_1_1_2_3 + 0.0113137655994818*G0_1_1_2_4 + 0.00020963163820309*G0_1_1_2_5 + 0.000366617509474736*G0_1_1_2_6 + 0.00411493268636194*G0_1_1_2_7 - 0.00071262071262088*G0_1_1_2_8 + 0.000108462965605802*G0_1_1_2_9 - 0.013008895866041*G0_1_1_3_0 - 0.185023865023897*G0_1_1_3_1 - 0.0246302903445802*G0_1_1_3_2 - 0.402962751534249*G0_1_1_3_3 + 0.111879549022425*G0_1_1_3_4 + 0.014411302982734*G0_1_1_3_5 + 0.000779220779220925*G0_1_1_3_6 + 0.046973026973035*G0_1_1_3_7 - 0.0570572284858099*G0_1_1_3_8 - 0.0388925360354*G0_1_1_3_9 + 0.00330241187384103*G0_1_1_4_0 + 0.0816941788370498*G0_1_1_4_1 + 0.0113137655994818*G0_1_1_4_2 + 0.111879549022425*G0_1_1_4_3 - 0.0508405879834537*G0_1_1_4_4 - 0.00196089624661087*G0_1_1_4_5 + 0.00118167546738995*G0_1_1_4_6 - 0.0150991865277605*G0_1_1_4_7 + 0.0100842015127748*G0_1_1_4_8 + 0.00359640359640435*G0_1_1_4_9 + 0.0125081267938431*G0_1_1_5_0 + 0.00075258075258094*G0_1_1_5_1 + 0.00020963163820309*G0_1_1_5_2 + 0.014411302982734*G0_1_1_5_3 - 0.00196089624661087*G0_1_1_5_4 - 0.0328243185386101*G0_1_1_5_5 - 0.00157842157842184*G0_1_1_5_6 - 0.00129013843299594*G0_1_1_5_7 + 0.00568859711716959*G0_1_1_5_8 - 0.0184272869987188*G0_1_1_5_9 - 0.00504289361432297*G0_1_1_6_0 + 0.00238903953189706*G0_1_1_6_1 + 0.000366617509474736*G0_1_1_6_2 + 0.000779220779220925*G0_1_1_6_3 + 0.00118167546738995*G0_1_1_6_4 - 0.00157842157842184*G0_1_1_6_5 + 0.00289995718567199*G0_1_1_6_6 - 0.00439845868417365*G0_1_1_6_7 - 0.00648779791637039*G0_1_1_6_8 - 0.00188383045525927*G0_1_1_6_9 + 0.0272565529708432*G0_1_1_7_0 + 0.0471509442938096*G0_1_1_7_1 + 0.00411493268636194*G0_1_1_7_2 + 0.046973026973035*G0_1_1_7_3 - 0.0150991865277605*G0_1_1_7_4 - 0.00129013843299594*G0_1_1_7_5 - 0.00439845868417365*G0_1_1_7_6 + 0.0222977022977056*G0_1_1_7_7 - 0.0172370486656227*G0_1_1_7_8 + 0.00174682460396773*G0_1_1_7_9 - 0.0114885114885134*G0_1_1_8_0 - 0.08519480519482*G0_1_1_8_1 - 0.00071262071262088*G0_1_1_8_2 - 0.0570572284858099*G0_1_1_8_3 + 0.0100842015127748*G0_1_1_8_4 + 0.00568859711716959*G0_1_1_8_5 - 0.00648779791637039*G0_1_1_8_6 - 0.0172370486656227*G0_1_1_8_7 + 0.156957328385925*G0_1_1_8_8 + 0.0348851148851206*G0_1_1_8_9 + 0.00235003092145988*G0_1_1_9_0 - 0.0183511726368901*G0_1_1_9_1 + 0.000108462965605802*G0_1_1_9_2 - 0.0388925360354*G0_1_1_9_3 + 0.00359640359640435*G0_1_1_9_4 - 0.0184272869987188*G0_1_1_9_5 - 0.00188383045525927*G0_1_1_9_6 + 0.00174682460396773*G0_1_1_9_7 + 0.0348851148851206*G0_1_1_9_8 - 0.0337034394177311*G0_1_1_9_9;
    A[163] = -A[153] + 0.0238161838161879*G0_0_0_0_0 + 0.00180570751999355*G0_0_0_0_2 - 0.0079615622472779*G0_0_0_0_3 + 0.00274297131440034*G0_0_0_0_4 + 0.0306116106116159*G0_0_0_0_5 - 0.0122360179503058*G0_0_0_0_6 + 0.00484626484626566*G0_0_0_0_7 - 0.00889713461142182*G0_0_0_0_8 - 0.0183740069454386*G0_0_0_0_9 - 0.0238161838161881*G0_0_0_1_1 - 0.00180570751999354*G0_0_0_1_2 - 0.0306116106116159*G0_0_0_1_3 + 0.0122360179503057*G0_0_0_1_4 + 0.00796156224727787*G0_0_0_1_5 - 0.00274297131440035*G0_0_0_1_6 + 0.00889713461142184*G0_0_0_1_7 - 0.00484626484626571*G0_0_0_1_8 + 0.0183740069454386*G0_0_0_1_9 + 0.00180570751999355*G0_0_0_2_0 - 0.00180570751999355*G0_0_0_2_1 - 0.0111609025894759*G0_0_0_2_3 + 0.00547769690626923*G0_0_0_2_4 + 0.0111609025894759*G0_0_0_2_5 - 0.00547769690626929*G0_0_0_2_6 + 0.012948004376578*G0_0_0_2_7 - 0.012948004376578*G0_0_0_2_8 - 0.0079615622472779*G0_0_0_3_0 - 0.0306116106116159*G0_0_0_3_1 - 0.0111609025894759*G0_0_0_3_2 - 0.23447409733128*G0_0_0_3_3 + 0.0423034108748466*G0_0_0_3_4 + 0.00822891394320105*G0_0_0_3_6 + 0.0238846867418336*G0_0_0_3_7 - 0.0627286998715675*G0_0_0_3_8 - 0.102891394319983*G0_0_0_3_9 + 0.00274297131440034*G0_0_0_4_0 + 0.0122360179503057*G0_0_0_4_1 + 0.00547769690626923*G0_0_0_4_2 + 0.0423034108748466*G0_0_0_4_3 - 0.0385043527900735*G0_0_0_4_4 - 0.00822891394320105*G0_0_0_4_5 - 0.0235364635364675*G0_0_0_4_7 + 0.0388440131297339*G0_0_0_4_8 + 0.0164578278864021*G0_0_0_4_9 + 0.0306116106116159*G0_0_0_5_0 + 0.00796156224727787*G0_0_0_5_1 + 0.0111609025894759*G0_0_0_5_2 - 0.00822891394320105*G0_0_0_5_4 + 0.23447409733128*G0_0_0_5_5 - 0.0423034108748466*G0_0_0_5_6 + 0.0627286998715674*G0_0_0_5_7 - 0.0238846867418336*G0_0_0_5_8 + 0.102891394319983*G0_0_0_5_9 - 0.0122360179503058*G0_0_0_6_0 - 0.00274297131440035*G0_0_0_6_1 - 0.00547769690626929*G0_0_0_6_2 + 0.00822891394320105*G0_0_0_6_3 - 0.0423034108748466*G0_0_0_6_5 + 0.0385043527900735*G0_0_0_6_6 - 0.0388440131297339*G0_0_0_6_7 + 0.0235364635364675*G0_0_0_6_8 - 0.0164578278864021*G0_0_0_6_9 + 0.00484626484626566*G0_0_0_7_0 + 0.00889713461142184*G0_0_0_7_1 + 0.012948004376578*G0_0_0_7_2 + 0.0238846867418336*G0_0_0_7_3 - 0.0235364635364675*G0_0_0_7_4 + 0.0627286998715674*G0_0_0_7_5 - 0.0388440131297339*G0_0_0_7_6 + 0.105443128300288*G0_0_0_7_7 + 0.132810047095784*G0_0_0_7_9 - 0.00889713461142182*G0_0_0_8_0 - 0.0048462648462657*G0_0_0_8_1 - 0.012948004376578*G0_0_0_8_2 - 0.0627286998715675*G0_0_0_8_3 + 0.0388440131297339*G0_0_0_8_4 - 0.0238846867418336*G0_0_0_8_5 + 0.0235364635364675*G0_0_0_8_6 - 0.105443128300289*G0_0_0_8_8 - 0.132810047095784*G0_0_0_8_9 - 0.0183740069454386*G0_0_0_9_0 + 0.0183740069454386*G0_0_0_9_1 - 0.102891394319983*G0_0_0_9_3 + 0.0164578278864021*G0_0_0_9_4 + 0.102891394319983*G0_0_0_9_5 - 0.0164578278864021*G0_0_0_9_6 + 0.132810047095784*G0_0_0_9_7 - 0.132810047095784*G0_0_0_9_8 + 0.00815283481950244*G0_0_1_0_0 + 0.00238819381676571*G0_0_1_0_1 - 0.00103335817621551*G0_0_1_0_2 - 0.0106090734662181*G0_0_1_0_3 + 0.00500959358102298*G0_0_1_0_4 + 0.00621124906839276*G0_0_1_0_5 + 0.00585668299954106*G0_0_1_0_7 - 0.0323641437927207*G0_0_1_0_8 - 0.00902526045383341*G0_0_1_0_9 + 0.0023881938167657*G0_0_1_1_0 + 0.206687140020509*G0_0_1_1_1 + 0.00595235452378411*G0_0_1_1_2 + 0.0566455766455864*G0_0_1_1_3 - 0.0257653457653502*G0_0_1_1_4 - 0.000280354566068966*G0_0_1_1_5 - 0.000467786182071971*G0_0_1_1_6 - 0.00939060939061118*G0_0_1_1_7 + 0.00311688311688419*G0_0_1_1_8 + 0.00340992340992407*G0_0_1_1_9 - 0.00103335817621551*G0_0_1_2_0 + 0.00595235452378411*G0_0_1_2_1 - 0.00250627679199152*G0_0_1_2_2 - 0.0094778237635396*G0_0_1_2_3 + 0.00845186559472412*G0_0_1_2_4 + 0.00190507904793649*G0_0_1_2_5 + 0.00257012828441441*G0_0_1_2_6 + 0.00827680256251821*G0_0_1_2_7 - 0.0349304663590436*G0_0_1_2_8 - 0.0172265829408715*G0_0_1_2_9 - 0.0106090734662181*G0_0_1_3_0 + 0.0566455766455864*G0_0_1_3_1 - 0.0094778237635396*G0_0_1_3_2 - 0.295404595404645*G0_0_1_3_3 + 0.0279035250463868*G0_0_1_3_4 + 0.0106236620522352*G0_0_1_3_5 + 0.0128243185386064*G0_0_1_3_6 + 0.0432481803910446*G0_0_1_3_7 - 0.159460539460566*G0_0_1_3_8 - 0.0967261310118616*G0_0_1_3_9 + 0.00500959358102298*G0_0_1_4_0 - 0.0257653457653502*G0_0_1_4_1 + 0.00845186559472412*G0_0_1_4_2 + 0.0279035250463867*G0_0_1_4_3 - 0.0469616098187605*G0_0_1_4_4 - 0.00360782075067848*G0_0_1_4_5 - 0.0092164977879279*G0_0_1_4_6 - 0.025640074211507*G0_0_1_4_7 + 0.116212359069521*G0_0_1_4_8 + 0.0588953903239716*G0_0_1_4_9 + 0.00621124906839276*G0_0_1_5_0 - 0.000280354566068966*G0_0_1_5_1 + 0.00190507904793649*G0_0_1_5_2 + 0.0106236620522352*G0_0_1_5_3 - 0.00360782075067848*G0_0_1_5_4 + 0.0122135007849313*G0_0_1_5_5 - 0.00631654060225584*G0_0_1_5_6 + 0.00114742400456705*G0_0_1_5_7 + 0.0122620236905972*G0_0_1_5_8 + 0.00255173398030582*G0_0_1_5_9 - 0.000467786182071971*G0_0_1_6_1 + 0.00257012828441441*G0_0_1_6_2 + 0.0128243185386064*G0_0_1_6_3 - 0.0092164977879279*G0_0_1_6_4 - 0.00631654060225584*G0_0_1_6_5 + 0.000174111602683039*G0_0_1_6_6 - 0.0134094476951642*G0_0_1_6_7 + 0.0473868988154781*G0_0_1_6_8 + 0.0260311117454018*G0_0_1_6_9 + 0.00585668299954106*G0_0_1_7_0 - 0.00939060939061118*G0_0_1_7_1 + 0.00827680256251821*G0_0_1_7_2 + 0.0432481803910446*G0_0_1_7_3 - 0.025640074211507*G0_0_1_7_4 + 0.00114742400456705*G0_0_1_7_5 - 0.0134094476951642*G0_0_1_7_6 + 0.006230911945199*G0_0_1_7_7 + 0.163205366062536*G0_0_1_7_8 + 0.0538946767518286*G0_0_1_7_9 - 0.0323641437927207*G0_0_1_8_0 + 0.0031168831168842*G0_0_1_8_1 - 0.0349304663590436*G0_0_1_8_2 - 0.159460539460566*G0_0_1_8_3 + 0.116212359069521*G0_0_1_8_4 + 0.0122620236905972*G0_0_1_8_5 + 0.0473868988154781*G0_0_1_8_6 + 0.163205366062536*G0_0_1_8_7 - 0.962297702297864*G0_0_1_8_8 - 0.242654488368815*G0_0_1_8_9 - 0.00902526045383341*G0_0_1_9_0 + 0.00340992340992407*G0_0_1_9_1 - 0.0172265829408715*G0_0_1_9_2 - 0.0967261310118616*G0_0_1_9_3 + 0.0588953903239716*G0_0_1_9_4 + 0.00255173398030582*G0_0_1_9_5 + 0.0260311117454019*G0_0_1_9_6 + 0.0538946767518286*G0_0_1_9_7 - 0.242654488368815*G0_0_1_9_8 - 0.093609247894978*G0_0_1_9_9 - 0.00328264328264382*G0_1_0_0_0 - 0.00146055003197886*G0_1_0_0_1 - 0.000108885823171557*G0_1_0_0_2 - 0.00802657659800656*G0_1_0_0_3 + 0.000159523016665906*G0_1_0_0_4 - 0.000388500388500436*G0_1_0_0_5 + 0.00725274725274847*G0_1_0_0_7 - 0.00150896722325321*G0_1_0_0_8 - 0.000525189096617777*G0_1_0_0_9 - 0.00146055003197886*G0_1_0_1_0 - 0.0270988270988319*G0_1_0_1_1 - 0.0019145933431651*G0_1_0_1_2 - 0.0310001110001163*G0_1_0_1_3 + 0.0122366522366543*G0_1_0_1_4 - 0.00258344829773445*G0_1_0_1_6 + 0.00738816738816868*G0_1_0_1_7 + 0.00240648240648272*G0_1_0_1_8 + 0.0178488178488208*G0_1_0_1_9 - 0.000108885823171557*G0_1_0_2_0 - 0.0019145933431651*G0_1_0_2_1 - 0.00380952380952445*G0_1_0_2_2 - 0.0123800009514316*G0_1_0_2_3 + 0.0100470957613832*G0_1_0_2_4 - 0.00121909836195571*G0_1_0_2_5 + 0.00456939885511392*G0_1_0_2_6 - 0.00265670837099453*G0_1_0_2_7 - 0.0156047127475725*G0_1_0_2_8 - 0.0232529375386557*G0_1_0_2_9 - 0.00802657659800656*G0_1_0_3_0 - 0.0310001110001163*G0_1_0_3_1 - 0.0123800009514316*G0_1_0_3_2 - 0.260559440559484*G0_1_0_3_3 + 0.0466248037676687*G0_1_0_3_4 + 0.0106550592264896*G0_1_0_3_5 + 0.0107149992864297*G0_1_0_3_6 + 0.0270443841872459*G0_1_0_3_7 - 0.0768231768231897*G0_1_0_3_8 - 0.107635221920954*G0_1_0_3_9 + 0.000159523016665906*G0_1_0_4_0 + 0.0122366522366543*G0_1_0_4_1 + 0.0100470957613832*G0_1_0_4_2 + 0.0466248037676687*G0_1_0_4_3 - 0.0525845582988528*G0_1_0_4_4 + 0.00248608534322862*G0_1_0_4_5 - 0.0132010846296583*G0_1_0_4_6 + 0.00226345083487979*G0_1_0_4_7 + 0.0497787926359439*G0_1_0_4_8 + 0.06478664192951*G0_1_0_4_9 - 0.000388500388500435*G0_1_0_5_0 - 0.00121909836195571*G0_1_0_5_2 + 0.0106550592264896*G0_1_0_5_3 + 0.00248608534322862*G0_1_0_5_4 - 0.0260853432282049*G0_1_0_5_5 + 0.00432139289282213*G0_1_0_5_6 - 0.0140944769516222*G0_1_0_5_7 + 0.00315969744541228*G0_1_0_5_8 - 0.00474382760097131*G0_1_0_5_9 - 0.00258344829773445*G0_1_0_6_1 + 0.00456939885511392*G0_1_0_6_2 + 0.0107149992864297*G0_1_0_6_3 - 0.0132010846296583*G0_1_0_6_4 + 0.00432139289282213*G0_1_0_6_5 - 0.0140802055087795*G0_1_0_6_6 + 0.0109347795062099*G0_1_0_6_7 + 0.0257999143713473*G0_1_0_6_8 + 0.0483288140431079*G0_1_0_6_9 + 0.00725274725274847*G0_1_0_7_0 + 0.00738816738816868*G0_1_0_7_1 - 0.00265670837099453*G0_1_0_7_2 + 0.0270443841872459*G0_1_0_7_3 + 0.00226345083487979*G0_1_0_7_4 - 0.0140944769516222*G0_1_0_7_5 + 0.0109347795062099*G0_1_0_7_6 - 0.0527786499215159*G0_1_0_7_7 - 0.00176965891251636*G0_1_0_7_8 - 0.0202939917225666*G0_1_0_7_9 - 0.00150896722325321*G0_1_0_8_0 + 0.00240648240648272*G0_1_0_8_1 - 0.0156047127475725*G0_1_0_8_2 - 0.0768231768231897*G0_1_0_8_3 + 0.0497787926359439*G0_1_0_8_4 + 0.00315969744541228*G0_1_0_8_5 + 0.0257999143713473*G0_1_0_8_6 - 0.00176965891251636*G0_1_0_8_7 - 0.158221778221805*G0_1_0_8_8 - 0.15310403881835*G0_1_0_8_9 - 0.000525189096617779*G0_1_0_9_0 + 0.0178488178488208*G0_1_0_9_1 - 0.0232529375386557*G0_1_0_9_2 - 0.107635221920954*G0_1_0_9_3 + 0.06478664192951*G0_1_0_9_4 - 0.00474382760097131*G0_1_0_9_5 + 0.0483288140431079*G0_1_0_9_6 - 0.0202939917225666*G0_1_0_9_7 - 0.15310403881835*G0_1_0_9_8 - 0.360976166690513*G0_1_0_9_9 - 0.00678630011963452*G0_1_1_0_0 + 0.00509021842355269*G0_1_1_0_1 - 0.00907917479346205*G0_1_1_0_3 - 0.000751312179883752*G0_1_1_0_4 - 0.000413237556094727*G0_1_1_0_5 + 0.000117660117660122*G0_1_1_0_6 + 0.0149675721104318*G0_1_1_0_7 - 0.00605902034473573*G0_1_1_0_8 - 0.000576566290852106*G0_1_1_0_9 + 0.00509021842355269*G0_1_1_1_0 + 0.245576645576688*G0_1_1_1_1 + 0.0097216363883047*G0_1_1_1_2 + 0.0814740814740954*G0_1_1_1_3 - 0.0390320790320857*G0_1_1_1_4 - 0.00150960150960184*G0_1_1_1_5 - 0.00433344433344504*G0_1_1_1_6 - 0.0189632589632624*G0_1_1_1_7 + 0.0770340770340905*G0_1_1_1_8 + 0.0258941058941104*G0_1_1_1_9 + 0.0097216363883047*G0_1_1_2_1 - 0.00419390133675917*G0_1_1_2_2 - 0.00837670266241832*G0_1_1_2_3 + 0.0118354661211824*G0_1_1_2_4 - 0.00179407893693638*G0_1_1_2_5 + 0.00623408337694157*G0_1_1_2_6 - 0.00542853971425493*G0_1_1_2_7 - 0.0416865674008601*G0_1_1_2_8 - 0.0286247086247134*G0_1_1_2_9 - 0.00907917479346205*G0_1_1_3_0 + 0.0814740814740954*G0_1_1_3_1 - 0.00837670266241832*G0_1_1_3_2 - 0.33390609390615*G0_1_1_3_3 + 0.0186613386613416*G0_1_1_3_4 + 0.0150563721992318*G0_1_1_3_5 + 0.0146539175110628*G0_1_1_3_6 + 0.0288911088911137*G0_1_1_3_7 - 0.155604395604421*G0_1_1_3_8 - 0.135464535464558*G0_1_1_3_9 - 0.000751312179883751*G0_1_1_4_0 - 0.0390320790320857*G0_1_1_4_1 + 0.0118354661211824*G0_1_1_4_2 + 0.0186613386613416*G0_1_1_4_3 - 0.0613672042243573*G0_1_1_4_4 + 0.00390752105037886*G0_1_1_4_5 - 0.0185614385614417*G0_1_1_4_6 + 0.00844298558584425*G0_1_1_4_7 + 0.126713286713308*G0_1_1_4_8 + 0.0780590837733827*G0_1_1_4_9 - 0.000413237556094727*G0_1_1_5_0 - 0.00150960150960184*G0_1_1_5_1 - 0.00179407893693638*G0_1_1_5_2 + 0.0150563721992318*G0_1_1_5_3 + 0.00390752105037887*G0_1_1_5_4 - 0.0137062937062959*G0_1_1_5_5 + 0.00671614100185637*G0_1_1_5_6 - 0.0241215926930252*G0_1_1_5_7 + 0.00618238903953291*G0_1_1_5_8 - 0.0106350792065096*G0_1_1_5_9 + 0.000117660117660122*G0_1_1_6_0 - 0.00433344433344504*G0_1_1_6_1 + 0.00623408337694157*G0_1_1_6_2 + 0.0146539175110628*G0_1_1_6_3 - 0.0185614385614417*G0_1_1_6_4 + 0.00671614100185637*G0_1_1_6_5 - 0.0106236620522352*G0_1_1_6_6 + 0.0179392036534924*G0_1_1_6_7 + 0.0682032253460938*G0_1_1_6_8 + 0.0565662908520147*G0_1_1_6_9 + 0.0149675721104318*G0_1_1_7_0 - 0.0189632589632624*G0_1_1_7_1 - 0.00542853971425493*G0_1_1_7_2 + 0.0288911088911137*G0_1_1_7_3 + 0.00844298558584425*G0_1_1_7_4 - 0.0241215926930252*G0_1_1_7_5 + 0.0179392036534924*G0_1_1_7_6 - 0.176132438989611*G0_1_1_7_7 + 0.0093906093906106*G0_1_1_7_8 - 0.0341487084344286*G0_1_1_7_9 - 0.00605902034473572*G0_1_1_8_0 + 0.0770340770340905*G0_1_1_8_1 - 0.0416865674008601*G0_1_1_8_2 - 0.155604395604421*G0_1_1_8_3 + 0.126713286713308*G0_1_1_8_4 + 0.00618238903953291*G0_1_1_8_5 + 0.0682032253460938*G0_1_1_8_6 + 0.00939060939061061*G0_1_1_8_7 - 1.09794205794224*G0_1_1_8_8 - 0.331108891108947*G0_1_1_8_9 - 0.000576566290852106*G0_1_1_9_0 + 0.0258941058941104*G0_1_1_9_1 - 0.0286247086247134*G0_1_1_9_2 - 0.135464535464558*G0_1_1_9_3 + 0.0780590837733827*G0_1_1_9_4 - 0.0106350792065096*G0_1_1_9_5 + 0.0565662908520147*G0_1_1_9_6 - 0.0341487084344286*G0_1_1_9_7 - 0.331108891108947*G0_1_1_9_8 - 0.25441986584848*G0_1_1_9_9;
    A[205] = A[163] - 0.0145632145632167*G0_0_1_0_0 - 0.000473600473600558*G0_0_1_0_1 + 0.000544006258292078*G0_0_1_0_2 - 0.00285999714571194*G0_0_1_0_3 - 0.00419009561866775*G0_0_1_0_4 - 0.00839160839160962*G0_0_1_0_5 + 0.00122163550734994*G0_0_1_0_6 + 0.00375624375624442*G0_0_1_0_7 + 0.0235992578849762*G0_0_1_0_8 + 0.00666761809619064*G0_0_1_0_9 - 0.000473600473600558*G0_0_1_1_0 - 0.0379472379472444*G0_0_1_1_1 - 0.00208236208236243*G0_0_1_1_2 - 0.0267732267732313*G0_0_1_1_3 + 0.0114285714285734*G0_0_1_1_4 - 0.00151848151848177*G0_0_1_1_6 + 0.00237096237096281*G0_0_1_1_7 + 0.0185148185148215*G0_0_1_1_8 + 0.0115084915084934*G0_0_1_1_9 + 0.000544006258292078*G0_0_1_2_0 - 0.00208236208236243*G0_0_1_2_1 - 0.000779749351178036*G0_0_1_2_2 - 0.00205508776937382*G0_0_1_2_3 + 0.00152419009561895*G0_0_1_2_4 - 0.00327291755863238*G0_0_1_2_5 + 0.00207601921887672*G0_0_1_2_6 - 0.0100585129156575*G0_0_1_2_7 + 0.017639503353792*G0_0_1_2_8 - 0.00461253032681683*G0_0_1_2_9 - 0.00285999714571194*G0_0_1_3_0 - 0.0267732267732313*G0_0_1_3_1 - 0.00205508776937383*G0_0_1_3_2 - 0.107652347652365*G0_0_1_3_3 + 0.0135464535464557*G0_0_1_3_4 + 0.00774083059797476*G0_0_1_3_5 - 0.0022263450834883*G0_0_1_3_6 + 0.00179820179820218*G0_0_1_3_7 + 0.0579020979021074*G0_0_1_3_8 - 0.0381218781218846*G0_0_1_3_9 - 0.00419009561866775*G0_0_1_4_0 + 0.0114285714285734*G0_0_1_4_1 + 0.00152419009561895*G0_0_1_4_2 + 0.0135464535464557*G0_0_1_4_3 - 0.00952190666476538*G0_0_1_4_4 + 0.00578849721706962*G0_0_1_4_5 - 0.00356215213358132*G0_0_1_4_6 + 0.0247638076209546*G0_0_1_4_7 - 0.0597002997003097*G0_0_1_4_8 + 0.00226059654631122*G0_0_1_4_9 - 0.00839160839160962*G0_0_1_5_0 - 0.00327291755863238*G0_0_1_5_2 + 0.00774083059797477*G0_0_1_5_3 + 0.00578849721706962*G0_0_1_5_4 - 0.0490823462252118*G0_0_1_5_5 + 0.0111831026116758*G0_0_1_5_6 - 0.0167318395889853*G0_0_1_5_7 - 0.00666190951905351*G0_0_1_5_8 - 0.00667903525046503*G0_0_1_5_9 + 0.00122163550734994*G0_0_1_6_0 - 0.00151848151848177*G0_0_1_6_1 + 0.00207601921887672*G0_0_1_6_2 - 0.0022263450834883*G0_0_1_6_3 - 0.00356215213358132*G0_0_1_6_4 + 0.0111831026116758*G0_0_1_6_5 - 0.0173312401883863*G0_0_1_6_6 + 0.0233937491080387*G0_0_1_6_7 - 0.0207906379334985*G0_0_1_6_8 + 0.0182902811474271*G0_0_1_6_9 + 0.00375624375624442*G0_0_1_7_0 + 0.0023709623709628*G0_0_1_7_1 - 0.0100585129156575*G0_0_1_7_2 + 0.00179820179820218*G0_0_1_7_3 + 0.0247638076209546*G0_0_1_7_4 - 0.0167318395889853*G0_0_1_7_5 + 0.0233937491080387*G0_0_1_7_6 - 0.0723390894819591*G0_0_1_7_7 - 0.129470529470551*G0_0_1_7_8 - 0.0667903525046495*G0_0_1_7_9 + 0.0235992578849761*G0_0_1_8_0 + 0.0185148185148215*G0_0_1_8_1 + 0.017639503353792*G0_0_1_8_2 + 0.0579020979021074*G0_0_1_8_3 - 0.0597002997003097*G0_0_1_8_4 - 0.00666190951905351*G0_0_1_8_5 - 0.0207906379334985*G0_0_1_8_6 - 0.129470529470551*G0_0_1_8_7 + 0.670369630369744*G0_0_1_8_8 + 0.0848751248751393*G0_0_1_8_9 + 0.00666761809619065*G0_0_1_9_0 + 0.0115084915084934*G0_0_1_9_1 - 0.00461253032681683*G0_0_1_9_2 - 0.0381218781218846*G0_0_1_9_3 + 0.00226059654631122*G0_0_1_9_4 - 0.00667903525046503*G0_0_1_9_5 + 0.0182902811474271*G0_0_1_9_6 - 0.0667903525046495*G0_0_1_9_7 + 0.0848751248751394*G0_0_1_9_8 - 0.231813900385368*G0_0_1_9_9 + 0.0145632145632167*G0_1_0_0_0 + 0.000473600473600558*G0_1_0_0_1 - 0.000544006258292078*G0_1_0_0_2 + 0.00285999714571194*G0_1_0_0_3 + 0.00419009561866775*G0_1_0_0_4 + 0.00839160839160962*G0_1_0_0_5 - 0.00122163550734994*G0_1_0_0_6 - 0.00375624375624442*G0_1_0_0_7 - 0.0235992578849761*G0_1_0_0_8 - 0.00666761809619065*G0_1_0_0_9 + 0.000473600473600558*G0_1_0_1_0 + 0.0379472379472444*G0_1_0_1_1 + 0.00208236208236243*G0_1_0_1_2 + 0.0267732267732313*G0_1_0_1_3 - 0.0114285714285734*G0_1_0_1_4 + 0.00151848151848177*G0_1_0_1_6 - 0.00237096237096281*G0_1_0_1_7 - 0.0185148185148215*G0_1_0_1_8 - 0.0115084915084934*G0_1_0_1_9 - 0.000544006258292078*G0_1_0_2_0 + 0.00208236208236243*G0_1_0_2_1 + 0.000779749351178038*G0_1_0_2_2 + 0.00205508776937384*G0_1_0_2_3 - 0.00152419009561895*G0_1_0_2_4 + 0.00327291755863238*G0_1_0_2_5 - 0.00207601921887672*G0_1_0_2_6 + 0.0100585129156575*G0_1_0_2_7 - 0.017639503353792*G0_1_0_2_8 + 0.00461253032681682*G0_1_0_2_9 + 0.00285999714571194*G0_1_0_3_0 + 0.0267732267732313*G0_1_0_3_1 + 0.00205508776937384*G0_1_0_3_2 + 0.107652347652366*G0_1_0_3_3 - 0.0135464535464558*G0_1_0_3_4 - 0.00774083059797477*G0_1_0_3_5 + 0.0022263450834883*G0_1_0_3_6 - 0.00179820179820219*G0_1_0_3_7 - 0.0579020979021074*G0_1_0_3_8 + 0.0381218781218846*G0_1_0_3_9 + 0.00419009561866775*G0_1_0_4_0 - 0.0114285714285734*G0_1_0_4_1 - 0.00152419009561895*G0_1_0_4_2 - 0.0135464535464558*G0_1_0_4_3 + 0.00952190666476538*G0_1_0_4_4 - 0.00578849721706962*G0_1_0_4_5 + 0.00356215213358132*G0_1_0_4_6 - 0.0247638076209546*G0_1_0_4_7 + 0.0597002997003097*G0_1_0_4_8 - 0.00226059654631125*G0_1_0_4_9 + 0.00839160839160962*G0_1_0_5_0 + 0.00327291755863238*G0_1_0_5_2 - 0.00774083059797477*G0_1_0_5_3 - 0.00578849721706962*G0_1_0_5_4 + 0.0490823462252118*G0_1_0_5_5 - 0.0111831026116758*G0_1_0_5_6 + 0.0167318395889853*G0_1_0_5_7 + 0.0066619095190535*G0_1_0_5_8 + 0.00667903525046503*G0_1_0_5_9 - 0.00122163550734994*G0_1_0_6_0 + 0.00151848151848177*G0_1_0_6_1 - 0.00207601921887672*G0_1_0_6_2 + 0.0022263450834883*G0_1_0_6_3 + 0.00356215213358132*G0_1_0_6_4 - 0.0111831026116758*G0_1_0_6_5 + 0.0173312401883863*G0_1_0_6_6 - 0.0233937491080387*G0_1_0_6_7 + 0.0207906379334985*G0_1_0_6_8 - 0.0182902811474271*G0_1_0_6_9 - 0.00375624375624442*G0_1_0_7_0 - 0.0023709623709628*G0_1_0_7_1 + 0.0100585129156575*G0_1_0_7_2 - 0.00179820179820219*G0_1_0_7_3 - 0.0247638076209546*G0_1_0_7_4 + 0.0167318395889853*G0_1_0_7_5 - 0.0233937491080387*G0_1_0_7_6 + 0.0723390894819591*G0_1_0_7_7 + 0.129470529470551*G0_1_0_7_8 + 0.0667903525046495*G0_1_0_7_9 - 0.0235992578849761*G0_1_0_8_0 - 0.0185148185148215*G0_1_0_8_1 - 0.017639503353792*G0_1_0_8_2 - 0.0579020979021074*G0_1_0_8_3 + 0.0597002997003097*G0_1_0_8_4 + 0.00666190951905351*G0_1_0_8_5 + 0.0207906379334985*G0_1_0_8_6 + 0.129470529470551*G0_1_0_8_7 - 0.670369630369744*G0_1_0_8_8 - 0.0848751248751393*G0_1_0_8_9 - 0.00666761809619065*G0_1_0_9_0 - 0.0115084915084934*G0_1_0_9_1 + 0.00461253032681682*G0_1_0_9_2 + 0.0381218781218846*G0_1_0_9_3 - 0.00226059654631124*G0_1_0_9_4 + 0.00667903525046503*G0_1_0_9_5 - 0.0182902811474271*G0_1_0_9_6 + 0.0667903525046495*G0_1_0_9_7 - 0.0848751248751393*G0_1_0_9_8 + 0.231813900385368*G0_1_0_9_9;
    A[168] = -A[176] + 0.0443464824417283*G0_0_0_0_0 + 0.00902406235739731*G0_0_0_0_1 + 0.00420489563346779*G0_0_0_0_2 + 0.00487808487808571*G0_0_0_0_3 - 0.00190370476084794*G0_0_0_0_4 + 0.0310191395905736*G0_0_0_0_5 - 0.0150947465233206*G0_0_0_0_6 + 0.00577454291740106*G0_0_0_0_7 + 0.00368520368520433*G0_0_0_0_8 + 0.0062642119784988*G0_0_0_0_9 + 0.00902406235739731*G0_0_0_1_0 + 0.259513326180038*G0_0_0_1_1 + 0.007976221309556*G0_0_0_1_2 + 0.0714248714248837*G0_0_0_1_3 - 0.0346468346468406*G0_0_0_1_4 + 0.00542864542864624*G0_0_0_1_5 + 0.00120176120176144*G0_0_0_1_6 - 0.0311540311540367*G0_0_0_1_7 + 0.0616864616864726*G0_0_0_1_8 + 0.00150960150960183*G0_0_0_1_9 + 0.00420489563346779*G0_0_0_2_0 + 0.007976221309556*G0_0_0_2_1 + 0.00472698377460362*G0_0_0_2_2 + 0.00770192770192898*G0_0_0_2_3 - 0.00649086363372187*G0_0_0_2_4 + 0.00474530760245129*G0_0_0_2_5 - 0.00443408443408519*G0_0_0_2_6 + 0.00224706510420834*G0_0_0_2_7 + 0.0160136160136187*G0_0_0_2_8 + 0.0139999682856849*G0_0_0_2_9 + 0.0048780848780857*G0_0_0_3_0 + 0.0714248714248838*G0_0_0_3_1 + 0.00770192770192898*G0_0_0_3_2 + 0.0101232101232116*G0_0_0_3_3 - 0.0319147519147572*G0_0_0_3_4 - 0.0100166500166517*G0_0_0_3_5 - 0.0144921744921769*G0_0_0_3_6 - 0.0255211455211499*G0_0_0_3_7 + 0.0844488844488987*G0_0_0_3_8 + 0.0465134865134943*G0_0_0_3_9 - 0.00190370476084794*G0_0_0_4_0 - 0.0346468346468406*G0_0_0_4_1 - 0.00649086363372187*G0_0_0_4_2 - 0.0319147519147572*G0_0_0_4_3 + 0.0329803529803585*G0_0_0_4_4 - 0.00517577660434893*G0_0_0_4_5 + 0.0196679510965258*G0_0_0_4_6 + 0.00492840492840576*G0_0_0_4_7 - 0.0589277389277488*G0_0_0_4_8 - 0.031648351648357*G0_0_0_4_9 + 0.0310191395905736*G0_0_0_5_0 + 0.00542864542864624*G0_0_0_5_1 + 0.00474530760245129*G0_0_0_5_2 - 0.0100166500166517*G0_0_0_5_3 - 0.00517577660434893*G0_0_0_5_4 + 0.188748394462712*G0_0_0_5_5 - 0.029661766804629*G0_0_0_5_6 + 0.0448009133723495*G0_0_0_5_7 - 0.0271728271728318*G0_0_0_5_8 + 0.0355530184101673*G0_0_0_5_9 - 0.0150947465233206*G0_0_0_6_0 + 0.00120176120176144*G0_0_0_6_1 - 0.00443408443408519*G0_0_0_6_2 - 0.0144921744921769*G0_0_0_6_3 + 0.0196679510965258*G0_0_0_6_4 - 0.029661766804629*G0_0_0_6_5 + 0.0887569573284007*G0_0_0_6_6 - 0.0176280861995177*G0_0_0_6_7 - 0.0203796203796238*G0_0_0_6_8 - 0.013015555872701*G0_0_0_6_9 + 0.00577454291740106*G0_0_0_7_0 - 0.0311540311540367*G0_0_0_7_1 + 0.00224706510420834*G0_0_0_7_2 - 0.0255211455211499*G0_0_0_7_3 + 0.00492840492840576*G0_0_0_7_4 + 0.0448009133723495*G0_0_0_7_5 - 0.0176280861995177*G0_0_0_7_6 + 0.101018981018998*G0_0_0_7_7 - 0.0570629370629467*G0_0_0_7_8 + 0.0164635364635393*G0_0_0_7_9 + 0.00368520368520433*G0_0_0_8_0 + 0.0616864616864726*G0_0_0_8_1 + 0.0160136160136187*G0_0_0_8_2 + 0.0844488844488987*G0_0_0_8_3 - 0.0589277389277488*G0_0_0_8_4 - 0.0271728271728318*G0_0_0_8_5 - 0.0203796203796238*G0_0_0_8_6 - 0.0570629370629467*G0_0_0_8_7 + 0.327672327672383*G0_0_0_8_8 + 0.113326673326692*G0_0_0_8_9 + 0.0062642119784988*G0_0_0_9_0 + 0.00150960150960183*G0_0_0_9_1 + 0.0139999682856849*G0_0_0_9_2 + 0.0465134865134943*G0_0_0_9_3 - 0.031648351648357*G0_0_0_9_4 + 0.0355530184101673*G0_0_0_9_5 - 0.013015555872701*G0_0_0_9_6 + 0.0164635364635393*G0_0_0_9_7 + 0.113326673326692*G0_0_0_9_8 + 0.258941058941103*G0_0_0_9_9 - 0.00184140374616603*G0_1_0_0_0 + 0.00879614212947705*G0_1_0_0_1 - 0.00107419916943744*G0_1_0_0_2 - 0.0102031302031319*G0_1_0_0_3 + 0.0037029637029643*G0_1_0_0_4 + 0.000279085993371709*G0_1_0_0_5 + 0.00136371564943018*G0_1_0_0_6 + 0.00298368298368343*G0_1_0_0_7 - 0.00737928737928854*G0_1_0_0_8 - 0.00868464868465014*G0_1_0_0_9 + 0.00879614212947705*G0_1_0_1_0 + 0.294322960989679*G0_1_0_1_1 + 0.00879614212947696*G0_1_0_1_2 + 0.0811632811632952*G0_1_0_1_3 - 0.0395160395160463*G0_1_0_1_4 - 0.000666000666000888*G0_1_0_1_5 - 0.000666000666000741*G0_1_0_1_6 - 0.0395160395160465*G0_1_0_1_7 + 0.0811632811632956*G0_1_0_1_8 + 0.00426240426240506*G0_1_0_1_9 - 0.00107419916943744*G0_1_0_2_0 + 0.00879614212947696*G0_1_0_2_1 - 0.00184140374616595*G0_1_0_2_2 - 0.00737928737928859*G0_1_0_2_3 + 0.00298368298368347*G0_1_0_2_4 + 0.00136371564943014*G0_1_0_2_5 + 0.000279085993371762*G0_1_0_2_6 + 0.0037029637029643*G0_1_0_2_7 - 0.0102031302031319*G0_1_0_2_8 - 0.00868464868465012*G0_1_0_2_9 - 0.0102031302031319*G0_1_0_3_0 + 0.0811632811632952*G0_1_0_3_1 - 0.00737928737928859*G0_1_0_3_2 - 0.148651348651374*G0_1_0_3_3 + 0.0307692307692358*G0_1_0_3_4 + 0.0130269730269751*G0_1_0_3_5 + 0.00855144855144997*G0_1_0_3_6 + 0.0371628371628432*G0_1_0_3_7 - 0.0743256743256864*G0_1_0_3_8 - 0.0871128871129016*G0_1_0_3_9 + 0.0037029637029643*G0_1_0_4_0 - 0.0395160395160463*G0_1_0_4_1 + 0.00298368298368347*G0_1_0_4_2 + 0.0307692307692358*G0_1_0_4_3 - 0.0103896103896121*G0_1_0_4_4 - 0.00455544455544528*G0_1_0_4_5 - 0.00399600399600465*G0_1_0_4_6 - 0.0143856143856167*G0_1_0_4_7 + 0.0371628371628432*G0_1_0_4_8 + 0.035164835164841*G0_1_0_4_9 + 0.000279085993371708*G0_1_0_5_0 - 0.000666000666000888*G0_1_0_5_1 + 0.00136371564943014*G0_1_0_5_2 + 0.0130269730269751*G0_1_0_5_3 - 0.00455544455544528*G0_1_0_5_4 - 0.0063251034679617*G0_1_0_5_5 - 0.000468103325246228*G0_1_0_5_6 - 0.00399600399600465*G0_1_0_5_7 + 0.00855144855144993*G0_1_0_5_8 + 0.00895104895105041*G0_1_0_5_9 + 0.00136371564943018*G0_1_0_6_0 - 0.000666000666000741*G0_1_0_6_1 + 0.000279085993371762*G0_1_0_6_2 + 0.00855144855144997*G0_1_0_6_3 - 0.00399600399600465*G0_1_0_6_4 - 0.000468103325246228*G0_1_0_6_5 - 0.00632510346796161*G0_1_0_6_6 - 0.0045554445554453*G0_1_0_6_7 + 0.0130269730269752*G0_1_0_6_8 + 0.00895104895105045*G0_1_0_6_9 + 0.00298368298368343*G0_1_0_7_0 - 0.0395160395160465*G0_1_0_7_1 + 0.0037029637029643*G0_1_0_7_2 + 0.0371628371628432*G0_1_0_7_3 - 0.0143856143856167*G0_1_0_7_4 - 0.00399600399600465*G0_1_0_7_5 - 0.0045554445554453*G0_1_0_7_6 - 0.010389610389612*G0_1_0_7_7 + 0.0307692307692356*G0_1_0_7_8 + 0.035164835164841*G0_1_0_7_9 - 0.00737928737928854*G0_1_0_8_0 + 0.0811632811632956*G0_1_0_8_1 - 0.0102031302031319*G0_1_0_8_2 - 0.0743256743256864*G0_1_0_8_3 + 0.0371628371628432*G0_1_0_8_4 + 0.00855144855144993*G0_1_0_8_5 + 0.0130269730269752*G0_1_0_8_6 + 0.0307692307692356*G0_1_0_8_7 - 0.148651348651373*G0_1_0_8_8 - 0.0871128871129016*G0_1_0_8_9 - 0.00868464868465014*G0_1_0_9_0 + 0.00426240426240506*G0_1_0_9_1 - 0.00868464868465012*G0_1_0_9_2 - 0.0871128871129016*G0_1_0_9_3 + 0.035164835164841*G0_1_0_9_4 + 0.0089510489510504*G0_1_0_9_5 + 0.00895104895105045*G0_1_0_9_6 + 0.035164835164841*G0_1_0_9_7 - 0.0871128871129015*G0_1_0_9_8 - 0.0671328671328785*G0_1_0_9_9;
    A[109] = A[70] + 0.0035964035964043*G0_0_0_0_0 + 0.000618825618825734*G0_0_0_0_1 - 0.00386092743235664*G0_0_0_0_2 + 0.00712929927215767*G0_0_0_0_4 - 0.000163170163170189*G0_0_0_0_5 + 0.00239498596641502*G0_0_0_0_6 + 0.000752580752580876*G0_0_0_0_7 - 0.00271323914181102*G0_0_0_0_8 + 0.000817753674896675*G0_0_0_0_9 + 0.000618825618825734*G0_0_0_1_0 + 0.0194768194768227*G0_0_0_1_1 - 0.00216648430934179*G0_0_0_1_2 + 0.0197117168545773*G0_0_0_1_3 - 0.00510989010989091*G0_0_0_1_4 + 0.000671471385757194*G0_0_0_1_5 + 0.00534394177251414*G0_0_0_1_6 - 0.00172375243803847*G0_0_0_1_7 + 0.00458065743780111*G0_0_0_1_8 + 0.0014057371200231*G0_0_0_1_9 - 0.00386092743235664*G0_0_0_2_0 - 0.00216648430934179*G0_0_0_2_1 - 0.159786139786166*G0_0_0_2_2 + 0.0193278150421038*G0_0_0_2_3 - 0.036303696303702*G0_0_0_2_4 + 0.0173564530707415*G0_0_0_2_5 - 0.0347585747585802*G0_0_0_2_6 + 0.00191308691308721*G0_0_0_2_7 - 0.00389396317967812*G0_0_0_2_8 - 0.00331097473954668*G0_0_0_2_9 + 0.0197117168545773*G0_0_0_3_1 + 0.0193278150421038*G0_0_0_3_2 + 0.0159440559440592*G0_0_0_3_3 - 0.0278999571856764*G0_0_0_3_4 - 0.0012630226915943*G0_0_0_3_5 - 0.0154880833452288*G0_0_0_3_6 + 0.000575852718709907*G0_0_0_3_7 - 0.0128014842300577*G0_0_0_3_8 - 0.00536891679748907*G0_0_0_3_9 + 0.00712929927215767*G0_0_0_4_0 - 0.00510989010989091*G0_0_0_4_1 - 0.036303696303702*G0_0_0_4_2 - 0.0278999571856764*G0_0_0_4_3 + 0.259022406165308*G0_0_0_4_4 - 0.0208441558441595*G0_0_0_4_5 + 0.0363322391893884*G0_0_0_4_6 - 0.013835450264024*G0_0_0_4_7 + 0.0122256315113478*G0_0_0_4_8 + 0.0516212359069589*G0_0_0_4_9 - 0.000163170163170188*G0_0_0_5_0 + 0.000671471385757194*G0_0_0_5_1 + 0.0173564530707415*G0_0_0_5_2 - 0.0012630226915943*G0_0_0_5_3 - 0.0208441558441595*G0_0_0_5_4 + 0.0291479948622855*G0_0_0_5_5 - 0.0153510774939374*G0_0_0_5_6 + 0.00666619095190631*G0_0_0_5_7 - 0.00147067218495814*G0_0_0_5_8 + 0.000488083345226291*G0_0_0_5_9 + 0.00239498596641502*G0_0_0_6_0 + 0.00534394177251414*G0_0_0_6_1 - 0.0347585747585802*G0_0_0_6_2 - 0.0154880833452288*G0_0_0_6_3 + 0.0363322391893884*G0_0_0_6_4 - 0.0153510774939374*G0_0_0_6_5 + 0.269991437134341*G0_0_0_6_6 - 0.00519551876694815*G0_0_0_6_7 - 0.00244683887541071*G0_0_0_6_8 + 0.0409090909090977*G0_0_0_6_9 + 0.000752580752580876*G0_0_0_7_0 - 0.00172375243803847*G0_0_0_7_1 + 0.00191308691308721*G0_0_0_7_2 + 0.000575852718709906*G0_0_0_7_3 - 0.013835450264024*G0_0_0_7_4 + 0.00666619095190631*G0_0_0_7_5 - 0.00519551876694815*G0_0_0_7_6 + 0.00966747538176234*G0_0_0_7_7 + 0.00882617382617528*G0_0_0_7_8 + 0.00793777650920636*G0_0_0_7_9 - 0.00271323914181102*G0_0_0_8_0 + 0.00458065743780111*G0_0_0_8_1 - 0.00389396317967812*G0_0_0_8_2 - 0.0128014842300577*G0_0_0_8_3 + 0.0122256315113478*G0_0_0_8_4 - 0.00147067218495814*G0_0_0_8_5 - 0.00244683887541071*G0_0_0_8_6 + 0.00882617382617528*G0_0_0_8_7 - 0.0598715570144238*G0_0_0_8_8 - 0.0286684743827649*G0_0_0_8_9 + 0.000817753674896675*G0_0_0_9_0 + 0.0014057371200231*G0_0_0_9_1 - 0.00331097473954668*G0_0_0_9_2 - 0.00536891679748907*G0_0_0_9_3 + 0.0516212359069589*G0_0_0_9_4 + 0.000488083345226289*G0_0_0_9_5 + 0.0409090909090977*G0_0_0_9_6 + 0.00793777650920636*G0_0_0_9_7 - 0.0286684743827649*G0_0_0_9_8 - 0.0502468959611904*G0_0_0_9_9 + 0.000804063661206678*G0_0_1_0_1 - 0.000804063661206644*G0_0_1_0_2 + 0.00085628657057246*G0_0_1_0_3 - 0.000856286570572421*G0_0_1_0_4 - 0.00144807573379029*G0_0_1_0_5 + 0.00039579468150906*G0_0_1_0_6 + 0.00144807573379022*G0_0_1_0_7 - 0.000395794681508998*G0_0_1_0_8 + 0.000804063661206678*G0_0_1_1_0 + 0.022892662892667*G0_0_1_1_1 + 0.0256543456543501*G0_0_1_1_3 - 0.0132553161124612*G0_0_1_1_4 + 0.000582274867989244*G0_0_1_1_5 + 0.00306550592264933*G0_0_1_1_6 - 0.00318538604252954*G0_0_1_1_7 + 0.00951048951049131*G0_0_1_1_8 + 0.00972741544170286*G0_0_1_1_9 - 0.000804063661206644*G0_0_1_2_0 - 0.0228926628926665*G0_0_1_2_2 + 0.0132553161124611*G0_0_1_2_3 - 0.0256543456543498*G0_0_1_2_4 + 0.00318538604252936*G0_0_1_2_5 - 0.009510489510491*G0_0_1_2_6 - 0.000582274867989264*G0_0_1_2_7 - 0.00306550592264927*G0_0_1_2_8 - 0.00972741544170277*G0_0_1_2_9 + 0.000856286570572461*G0_0_1_3_0 + 0.0256543456543501*G0_0_1_3_1 + 0.0132553161124611*G0_0_1_3_2 + 0.0141801056086804*G0_0_1_3_3 - 0.00215784215784254*G0_0_1_3_5 - 0.009196517767948*G0_0_1_3_6 - 0.00256885971171741*G0_0_1_3_7 - 0.00662765805623034*G0_0_1_3_8 - 0.0240445269016737*G0_0_1_3_9 - 0.000856286570572421*G0_0_1_4_0 - 0.0132553161124612*G0_0_1_4_1 - 0.0256543456543498*G0_0_1_4_2 - 0.0141801056086788*G0_0_1_4_4 + 0.00256885971171722*G0_0_1_4_5 + 0.00662765805623077*G0_0_1_4_6 + 0.00215784215784254*G0_0_1_4_7 + 0.00919651776794777*G0_0_1_4_8 + 0.0240445269016739*G0_0_1_4_9 - 0.00144807573379029*G0_0_1_5_0 + 0.000582274867989244*G0_0_1_5_1 + 0.00318538604252936*G0_0_1_5_2 - 0.00215784215784254*G0_0_1_5_3 + 0.00256885971171722*G0_0_1_5_4 + 0.0115769944341394*G0_0_1_5_5 + 0.000222634508348814*G0_0_1_5_6 - 0.00174682460396777*G0_0_1_5_8 + 0.00349364920793555*G0_0_1_5_9 + 0.00039579468150906*G0_0_1_6_0 + 0.00306550592264933*G0_0_1_6_1 - 0.009510489510491*G0_0_1_6_2 - 0.009196517767948*G0_0_1_6_3 + 0.00662765805623077*G0_0_1_6_4 + 0.000222634508348814*G0_0_1_6_5 + 0.0647010132724535*G0_0_1_6_6 + 0.00174682460396776*G0_0_1_6_7 + 0.0475752818610043*G0_0_1_6_9 + 0.00144807573379022*G0_0_1_7_0 - 0.00318538604252954*G0_0_1_7_1 - 0.000582274867989264*G0_0_1_7_2 - 0.00256885971171741*G0_0_1_7_3 + 0.00215784215784254*G0_0_1_7_4 + 0.00174682460396776*G0_0_1_7_6 - 0.011576994434139*G0_0_1_7_7 - 0.000222634508348961*G0_0_1_7_8 - 0.0034936492079355*G0_0_1_7_9 - 0.000395794681508998*G0_0_1_8_0 + 0.00951048951049132*G0_0_1_8_1 - 0.00306550592264927*G0_0_1_8_2 - 0.00662765805623034*G0_0_1_8_3 + 0.00919651776794777*G0_0_1_8_4 - 0.00174682460396777*G0_0_1_8_5 - 0.000222634508348964*G0_0_1_8_7 - 0.0647010132724519*G0_0_1_8_8 - 0.0475752818610041*G0_0_1_8_9 + 0.00972741544170286*G0_0_1_9_1 - 0.00972741544170277*G0_0_1_9_2 - 0.0240445269016737*G0_0_1_9_3 + 0.0240445269016739*G0_0_1_9_4 + 0.00349364920793555*G0_0_1_9_5 + 0.0475752818610043*G0_0_1_9_6 - 0.00349364920793551*G0_0_1_9_7 - 0.0475752818610041*G0_0_1_9_8 + 0.00198124626696093*G0_1_0_0_1 - 0.00198124626696087*G0_1_0_0_2 - 0.00218923933209687*G0_1_0_0_3 + 0.00218923933209688*G0_1_0_0_4 - 0.00101279672708267*G0_1_0_0_5 + 0.00668379239807933*G0_1_0_0_6 + 0.00101279672708249*G0_1_0_0_7 - 0.00668379239807919*G0_1_0_0_8 + 0.00198124626696093*G0_1_0_1_0 + 0.140489880489905*G0_1_0_1_1 + 0.0265329908187098*G0_1_0_1_3 - 0.0121718757433064*G0_1_0_1_4 + 0.0054902240616536*G0_1_0_1_6 - 0.00838994338994499*G0_1_0_1_7 + 0.00995385566814342*G0_1_0_1_8 - 0.00559868702725935*G0_1_0_1_9 - 0.00198124626696087*G0_1_0_2_0 - 0.140489880489904*G0_1_0_2_2 + 0.0121718757433062*G0_1_0_2_3 - 0.0265329908187092*G0_1_0_2_4 + 0.00838994338994463*G0_1_0_2_5 - 0.00995385566814274*G0_1_0_2_6 - 0.00549022406165354*G0_1_0_2_8 + 0.00559868702725944*G0_1_0_2_9 - 0.00218923933209687*G0_1_0_3_0 + 0.0265329908187098*G0_1_0_3_1 + 0.0121718757433062*G0_1_0_3_2 - 0.187719423433741*G0_1_0_3_3 + 0.00334165834165889*G0_1_0_3_5 - 0.0164706721849607*G0_1_0_3_6 + 0.0065677179962905*G0_1_0_3_7 - 0.0230383901812511*G0_1_0_3_8 + 0.00366062508919703*G0_1_0_3_9 + 0.00218923933209688*G0_1_0_4_0 - 0.0121718757433064*G0_1_0_4_1 - 0.0265329908187092*G0_1_0_4_2 + 0.187719423433741*G0_1_0_4_4 - 0.00656771799629056*G0_1_0_4_5 + 0.0230383901812513*G0_1_0_4_6 - 0.00334165834165885*G0_1_0_4_7 + 0.0164706721849606*G0_1_0_4_8 - 0.00366062508919722*G0_1_0_4_9 - 0.00101279672708267*G0_1_0_5_0 + 0.00838994338994463*G0_1_0_5_2 + 0.00334165834165889*G0_1_0_5_3 - 0.00656771799629057*G0_1_0_5_4 - 0.0030655059226494*G0_1_0_5_5 - 0.0369487655202004*G0_1_0_5_6 + 0.000115598687027302*G0_1_0_5_8 - 0.000231197374054489*G0_1_0_5_9 + 0.00668379239807933*G0_1_0_6_0 + 0.0054902240616536*G0_1_0_6_1 - 0.00995385566814273*G0_1_0_6_2 - 0.0164706721849607*G0_1_0_6_3 + 0.0230383901812513*G0_1_0_6_4 - 0.0369487655202004*G0_1_0_6_5 + 0.251958041958085*G0_1_0_6_6 - 0.000115598687027184*G0_1_0_6_7 + 0.016145283288143*G0_1_0_6_9 + 0.00101279672708249*G0_1_0_7_0 - 0.00838994338994499*G0_1_0_7_1 + 0.0065677179962905*G0_1_0_7_3 - 0.00334165834165885*G0_1_0_7_4 - 0.000115598687027185*G0_1_0_7_6 + 0.00306550592264863*G0_1_0_7_7 + 0.0369487655202003*G0_1_0_7_8 + 0.000231197374054542*G0_1_0_7_9 - 0.00668379239807919*G0_1_0_8_0 + 0.00995385566814343*G0_1_0_8_1 - 0.00549022406165354*G0_1_0_8_2 - 0.0230383901812511*G0_1_0_8_3 + 0.0164706721849606*G0_1_0_8_4 + 0.000115598687027302*G0_1_0_8_5 + 0.0369487655202003*G0_1_0_8_7 - 0.251958041958084*G0_1_0_8_8 - 0.0161452832881432*G0_1_0_8_9 - 0.00559868702725935*G0_1_0_9_1 + 0.00559868702725944*G0_1_0_9_2 + 0.00366062508919703*G0_1_0_9_3 - 0.00366062508919722*G0_1_0_9_4 - 0.000231197374054491*G0_1_0_9_5 + 0.016145283288143*G0_1_0_9_6 + 0.000231197374054542*G0_1_0_9_7 - 0.0161452832881432*G0_1_0_9_8 - 0.00359640359640434*G0_1_1_0_0 + 0.00386092743235672*G0_1_1_0_1 - 0.000618825618825719*G0_1_1_0_2 - 0.00712929927215763*G0_1_1_0_3 - 0.000752580752580928*G0_1_1_0_5 + 0.00271323914181107*G0_1_1_0_6 + 0.00016317016317007*G0_1_1_0_7 - 0.00239498596641488*G0_1_1_0_8 - 0.000817753674896684*G0_1_1_0_9 + 0.00386092743235672*G0_1_1_1_0 + 0.159786139786168*G0_1_1_1_1 + 0.00216648430934185*G0_1_1_1_2 + 0.0363036963037027*G0_1_1_1_3 - 0.0193278150421041*G0_1_1_1_4 - 0.00191308691308731*G0_1_1_1_5 + 0.00389396317967816*G0_1_1_1_6 - 0.017356453070742*G0_1_1_1_7 + 0.0347585747585812*G0_1_1_1_8 + 0.0033109747395468*G0_1_1_1_9 - 0.000618825618825719*G0_1_1_2_0 + 0.00216648430934185*G0_1_1_2_1 - 0.0194768194768225*G0_1_1_2_2 + 0.00510989010989092*G0_1_1_2_3 - 0.0197117168545772*G0_1_1_2_4 + 0.00172375243803838*G0_1_1_2_5 - 0.00458065743780098*G0_1_1_2_6 - 0.000671471385757239*G0_1_1_2_7 - 0.00534394177251406*G0_1_1_2_8 - 0.00140573712002306*G0_1_1_2_9 - 0.00712929927215763*G0_1_1_3_0 + 0.0363036963037027*G0_1_1_3_1 + 0.00510989010989092*G0_1_1_3_2 - 0.259022406165307*G0_1_1_3_3 + 0.027899957185676*G0_1_1_3_4 + 0.013835450264024*G0_1_1_3_5 - 0.0122256315113479*G0_1_1_3_6 + 0.0208441558441593*G0_1_1_3_7 - 0.0363322391893879*G0_1_1_3_8 - 0.051621235906959*G0_1_1_3_9 - 0.0193278150421041*G0_1_1_4_1 - 0.0197117168545772*G0_1_1_4_2 + 0.027899957185676*G0_1_1_4_3 - 0.0159440559440581*G0_1_1_4_4 - 0.000575852718709973*G0_1_1_4_5 + 0.0128014842300579*G0_1_1_4_6 + 0.00126302269159439*G0_1_1_4_7 + 0.0154880833452287*G0_1_1_4_8 + 0.00536891679748915*G0_1_1_4_9 - 0.000752580752580928*G0_1_1_5_0 - 0.00191308691308731*G0_1_1_5_1 + 0.00172375243803838*G0_1_1_5_2 + 0.013835450264024*G0_1_1_5_3 - 0.000575852718709973*G0_1_1_5_4 - 0.00966747538176297*G0_1_1_5_5 - 0.00882617382617532*G0_1_1_5_6 - 0.00666619095190643*G0_1_1_5_7 + 0.00519551876694826*G0_1_1_5_8 - 0.0079377765092065*G0_1_1_5_9 + 0.00271323914181107*G0_1_1_6_0 + 0.00389396317967817*G0_1_1_6_1 - 0.00458065743780098*G0_1_1_6_2 - 0.0122256315113479*G0_1_1_6_3 + 0.0128014842300579*G0_1_1_6_4 - 0.00882617382617532*G0_1_1_6_5 + 0.0598715570144246*G0_1_1_6_6 + 0.00147067218495819*G0_1_1_6_7 + 0.00244683887541063*G0_1_1_6_8 + 0.028668474382765*G0_1_1_6_9 + 0.00016317016317007*G0_1_1_7_0 - 0.017356453070742*G0_1_1_7_1 - 0.000671471385757239*G0_1_1_7_2 + 0.0208441558441593*G0_1_1_7_3 + 0.00126302269159439*G0_1_1_7_4 - 0.00666619095190643*G0_1_1_7_5 + 0.00147067218495819*G0_1_1_7_6 - 0.0291479948622856*G0_1_1_7_7 + 0.0153510774939371*G0_1_1_7_8 - 0.000488083345226331*G0_1_1_7_9 - 0.00239498596641488*G0_1_1_8_0 + 0.0347585747585812*G0_1_1_8_1 - 0.00534394177251406*G0_1_1_8_2 - 0.0363322391893879*G0_1_1_8_3 + 0.0154880833452287*G0_1_1_8_4 + 0.00519551876694826*G0_1_1_8_5 + 0.00244683887541063*G0_1_1_8_6 + 0.0153510774939371*G0_1_1_8_7 - 0.269991437134339*G0_1_1_8_8 - 0.0409090909090978*G0_1_1_8_9 - 0.000817753674896685*G0_1_1_9_0 + 0.0033109747395468*G0_1_1_9_1 - 0.00140573712002306*G0_1_1_9_2 - 0.051621235906959*G0_1_1_9_3 + 0.00536891679748915*G0_1_1_9_4 - 0.0079377765092065*G0_1_1_9_5 + 0.028668474382765*G0_1_1_9_6 - 0.000488083345226332*G0_1_1_9_7 - 0.0409090909090978*G0_1_1_9_8 + 0.0502468959611898*G0_1_1_9_9;
    A[184] = A[72] + 0.000571914857629219*G0_0_1_0_1 - 0.000571914857629251*G0_0_1_0_2 + 0.00252319109462015*G0_0_1_0_3 - 0.00252319109462015*G0_0_1_0_4 + 0.00427001569858786*G0_0_1_0_6 - 0.00427001569858779*G0_0_1_0_8 + 0.000571914857629219*G0_0_1_1_0 - 0.00888000888001064*G0_0_1_1_1 + 0.0113220113220132*G0_0_1_1_3 - 0.00692260120831669*G0_0_1_1_4 - 0.00332239189382104*G0_0_1_1_5 + 0.00150135578707032*G0_0_1_1_6 - 0.000955235240949678*G0_0_1_1_7 - 0.00189144189144227*G0_0_1_1_8 + 0.0163493649207962*G0_0_1_1_9 - 0.000571914857629251*G0_0_1_2_0 + 0.00888000888001036*G0_0_1_2_2 + 0.0069226012083167*G0_0_1_2_3 - 0.0113220113220133*G0_0_1_2_4 + 0.0009552352409497*G0_0_1_2_5 + 0.00189144189144217*G0_0_1_2_6 + 0.00332239189382099*G0_0_1_2_7 - 0.00150135578707031*G0_0_1_2_8 - 0.0163493649207963*G0_0_1_2_9 + 0.00252319109462015*G0_0_1_3_0 + 0.0113220113220132*G0_0_1_3_1 + 0.0069226012083167*G0_0_1_3_2 + 0.265106322249225*G0_0_1_3_3 + 0.00119880119880143*G0_0_1_3_5 - 0.00450406736121094*G0_0_1_3_6 - 0.00756957328386035*G0_0_1_3_7 + 0.00306550592264936*G0_0_1_3_8 - 0.0339089481946679*G0_0_1_3_9 - 0.00252319109462015*G0_0_1_4_0 - 0.00692260120831669*G0_0_1_4_1 - 0.0113220113220133*G0_0_1_4_2 - 0.265106322249225*G0_0_1_4_4 + 0.00756957328386035*G0_0_1_4_5 - 0.00306550592264945*G0_0_1_4_6 - 0.00119880119880133*G0_0_1_4_7 + 0.00450406736121097*G0_0_1_4_8 + 0.0339089481946681*G0_0_1_4_9 - 0.00332239189382104*G0_0_1_5_1 + 0.0009552352409497*G0_0_1_5_2 + 0.00119880119880143*G0_0_1_5_3 + 0.00756957328386035*G0_0_1_5_4 - 0.0245925503068408*G0_0_1_5_5 - 0.0159098044812356*G0_0_1_5_6 + 0.00996717568146317*G0_0_1_5_8 - 0.0199343513629263*G0_0_1_5_9 + 0.00427001569858786*G0_0_1_6_0 + 0.00150135578707032*G0_0_1_6_1 + 0.00189144189144217*G0_0_1_6_2 - 0.00450406736121094*G0_0_1_6_3 - 0.00306550592264945*G0_0_1_6_4 - 0.0159098044812356*G0_0_1_6_5 - 0.00352790067075863*G0_0_1_6_6 - 0.00996717568146295*G0_0_1_6_7 + 0.0580562294848107*G0_0_1_6_9 - 0.000955235240949678*G0_0_1_7_1 + 0.00332239189382099*G0_0_1_7_2 - 0.00756957328386035*G0_0_1_7_3 - 0.00119880119880133*G0_0_1_7_4 - 0.00996717568146295*G0_0_1_7_6 + 0.0245925503068391*G0_0_1_7_7 + 0.0159098044812358*G0_0_1_7_8 + 0.019934351362926*G0_0_1_7_9 - 0.00427001569858779*G0_0_1_8_0 - 0.00189144189144227*G0_0_1_8_1 - 0.00150135578707031*G0_0_1_8_2 + 0.00306550592264936*G0_0_1_8_3 + 0.00450406736121097*G0_0_1_8_4 + 0.00996717568146317*G0_0_1_8_5 + 0.0159098044812358*G0_0_1_8_7 + 0.00352790067075841*G0_0_1_8_8 - 0.0580562294848106*G0_0_1_8_9 + 0.0163493649207962*G0_0_1_9_1 - 0.0163493649207963*G0_0_1_9_2 - 0.0339089481946679*G0_0_1_9_3 + 0.0339089481946681*G0_0_1_9_4 - 0.0199343513629263*G0_0_1_9_5 + 0.0580562294848107*G0_0_1_9_6 + 0.019934351362926*G0_0_1_9_7 - 0.0580562294848106*G0_0_1_9_8 - 0.000571914857629219*G0_1_0_0_1 + 0.000571914857629251*G0_1_0_0_2 - 0.00252319109462015*G0_1_0_0_3 + 0.00252319109462015*G0_1_0_0_4 - 0.00427001569858786*G0_1_0_0_6 + 0.00427001569858779*G0_1_0_0_8 - 0.000571914857629219*G0_1_0_1_0 + 0.00888000888001064*G0_1_0_1_1 - 0.0113220113220132*G0_1_0_1_3 + 0.00692260120831669*G0_1_0_1_4 + 0.00332239189382104*G0_1_0_1_5 - 0.00150135578707032*G0_1_0_1_6 + 0.000955235240949678*G0_1_0_1_7 + 0.00189144189144227*G0_1_0_1_8 - 0.0163493649207962*G0_1_0_1_9 + 0.000571914857629251*G0_1_0_2_0 - 0.00888000888001036*G0_1_0_2_2 - 0.00692260120831671*G0_1_0_2_3 + 0.0113220113220133*G0_1_0_2_4 - 0.0009552352409497*G0_1_0_2_5 - 0.00189144189144217*G0_1_0_2_6 - 0.00332239189382099*G0_1_0_2_7 + 0.00150135578707031*G0_1_0_2_8 + 0.0163493649207963*G0_1_0_2_9 - 0.00252319109462014*G0_1_0_3_0 - 0.0113220113220132*G0_1_0_3_1 - 0.00692260120831671*G0_1_0_3_2 - 0.265106322249225*G0_1_0_3_3 - 0.00119880119880143*G0_1_0_3_5 + 0.00450406736121095*G0_1_0_3_6 + 0.00756957328386035*G0_1_0_3_7 - 0.00306550592264936*G0_1_0_3_8 + 0.0339089481946679*G0_1_0_3_9 + 0.00252319109462015*G0_1_0_4_0 + 0.00692260120831669*G0_1_0_4_1 + 0.0113220113220133*G0_1_0_4_2 + 0.265106322249225*G0_1_0_4_4 - 0.00756957328386035*G0_1_0_4_5 + 0.00306550592264945*G0_1_0_4_6 + 0.00119880119880133*G0_1_0_4_7 - 0.00450406736121097*G0_1_0_4_8 - 0.0339089481946681*G0_1_0_4_9 + 0.00332239189382104*G0_1_0_5_1 - 0.000955235240949699*G0_1_0_5_2 - 0.00119880119880143*G0_1_0_5_3 - 0.00756957328386035*G0_1_0_5_4 + 0.0245925503068408*G0_1_0_5_5 + 0.0159098044812356*G0_1_0_5_6 - 0.00996717568146317*G0_1_0_5_8 + 0.0199343513629263*G0_1_0_5_9 - 0.00427001569858786*G0_1_0_6_0 - 0.00150135578707032*G0_1_0_6_1 - 0.00189144189144217*G0_1_0_6_2 + 0.00450406736121095*G0_1_0_6_3 + 0.00306550592264945*G0_1_0_6_4 + 0.0159098044812356*G0_1_0_6_5 + 0.00352790067075862*G0_1_0_6_6 + 0.00996717568146295*G0_1_0_6_7 - 0.0580562294848107*G0_1_0_6_9 + 0.000955235240949679*G0_1_0_7_1 - 0.00332239189382099*G0_1_0_7_2 + 0.00756957328386035*G0_1_0_7_3 + 0.00119880119880133*G0_1_0_7_4 + 0.00996717568146295*G0_1_0_7_6 - 0.0245925503068391*G0_1_0_7_7 - 0.0159098044812358*G0_1_0_7_8 - 0.0199343513629259*G0_1_0_7_9 + 0.00427001569858779*G0_1_0_8_0 + 0.00189144189144227*G0_1_0_8_1 + 0.00150135578707031*G0_1_0_8_2 - 0.00306550592264936*G0_1_0_8_3 - 0.00450406736121096*G0_1_0_8_4 - 0.00996717568146317*G0_1_0_8_5 - 0.0159098044812358*G0_1_0_8_7 - 0.00352790067075841*G0_1_0_8_8 + 0.0580562294848106*G0_1_0_8_9 - 0.0163493649207962*G0_1_0_9_1 + 0.0163493649207963*G0_1_0_9_2 + 0.0339089481946679*G0_1_0_9_3 - 0.0339089481946681*G0_1_0_9_4 + 0.0199343513629263*G0_1_0_9_5 - 0.0580562294848107*G0_1_0_9_6 - 0.0199343513629259*G0_1_0_9_7 + 0.0580562294848106*G0_1_0_9_8;
    A[18] = -A[26] - 0.00890562700086667*G0_0_0_0_0 - 0.00456796290129706*G0_0_0_0_1 - 0.00133135823612037*G0_0_0_0_2 - 0.000491545491545589*G0_0_0_0_3 - 0.00100547600547617*G0_0_0_0_4 - 0.00554197125625794*G0_0_0_0_5 + 0.00176056747485349*G0_0_0_0_6 - 0.00117956117956137*G0_0_0_0_7 + 0.00033892033892037*G0_0_0_0_8 - 0.000881340881341046*G0_0_0_0_9 - 0.00456796290129706*G0_0_0_1_0 - 0.142693109359801*G0_0_0_1_1 - 0.00456796290129701*G0_0_0_1_2 - 0.0380452880452946*G0_0_0_1_3 + 0.0185148185148217*G0_0_0_1_4 - 0.00102212602212614*G0_0_0_1_5 - 0.00102212602212621*G0_0_0_1_6 + 0.0185148185148218*G0_0_0_1_7 - 0.0380452880452948*G0_0_0_1_8 - 0.00203130203130241*G0_0_0_1_9 - 0.00133135823612037*G0_0_0_2_0 - 0.00456796290129701*G0_0_0_2_1 - 0.00890562700086659*G0_0_0_2_2 + 0.00033892033892039*G0_0_0_2_3 - 0.00117956117956137*G0_0_0_2_4 + 0.00176056747485348*G0_0_0_2_5 - 0.0055419712562579*G0_0_0_2_6 - 0.00100547600547617*G0_0_0_2_7 - 0.00049154549154559*G0_0_0_2_8 - 0.000881340881341034*G0_0_0_2_9 - 0.000491545491545589*G0_0_0_3_0 - 0.0380452880452946*G0_0_0_3_1 + 0.00033892033892039*G0_0_0_3_2 - 0.0134865134865158*G0_0_0_3_3 + 0.0064185814185825*G0_0_0_3_4 + 0.00132201132201155*G0_0_0_3_5 + 0.00496336996337078*G0_0_0_3_6 + 0.00337162837162901*G0_0_0_3_7 - 0.00674325674325801*G0_0_0_3_8 - 0.000649350649350797*G0_0_0_3_9 - 0.00100547600547617*G0_0_0_4_0 + 0.0185148185148217*G0_0_0_4_1 - 0.00117956117956137*G0_0_0_4_2 + 0.0064185814185825*G0_0_0_4_3 - 0.0180619380619411*G0_0_0_4_4 + 0.00491341991342074*G0_0_0_4_5 - 0.00987678987679153*G0_0_0_4_6 + 0.00206793206793239*G0_0_0_4_7 + 0.00337162837162901*G0_0_0_4_8 - 0.00718281718281836*G0_0_0_4_9 - 0.00554197125625794*G0_0_0_5_0 - 0.00102212602212614*G0_0_0_5_1 + 0.00176056747485348*G0_0_0_5_2 + 0.00132201132201155*G0_0_0_5_3 + 0.00491341991342074*G0_0_0_5_4 - 0.0513438942010457*G0_0_0_5_5 + 0.0110258788830236*G0_0_0_5_6 - 0.00987678987679154*G0_0_0_5_7 + 0.00496336996337082*G0_0_0_5_8 - 0.0072827172827185*G0_0_0_5_9 + 0.00176056747485349*G0_0_0_6_0 - 0.00102212602212621*G0_0_0_6_1 - 0.0055419712562579*G0_0_0_6_2 + 0.00496336996337078*G0_0_0_6_3 - 0.00987678987679153*G0_0_0_6_4 + 0.0110258788830236*G0_0_0_6_5 - 0.0513438942010456*G0_0_0_6_6 + 0.00491341991342074*G0_0_0_6_7 + 0.00132201132201154*G0_0_0_6_8 - 0.00728271728271848*G0_0_0_6_9 - 0.00117956117956137*G0_0_0_7_0 + 0.0185148185148218*G0_0_0_7_1 - 0.00100547600547617*G0_0_0_7_2 + 0.00337162837162901*G0_0_0_7_3 + 0.00206793206793239*G0_0_0_7_4 - 0.00987678987679154*G0_0_0_7_5 + 0.00491341991342074*G0_0_0_7_6 - 0.0180619380619412*G0_0_0_7_7 + 0.00641858141858263*G0_0_0_7_8 - 0.00718281718281838*G0_0_0_7_9 + 0.00033892033892037*G0_0_0_8_0 - 0.0380452880452948*G0_0_0_8_1 - 0.00049154549154559*G0_0_0_8_2 - 0.00674325674325801*G0_0_0_8_3 + 0.00337162837162901*G0_0_0_8_4 + 0.00496336996337082*G0_0_0_8_5 + 0.00132201132201154*G0_0_0_8_6 + 0.00641858141858263*G0_0_0_8_7 - 0.0134865134865161*G0_0_0_8_8 - 0.000649350649350821*G0_0_0_8_9 - 0.000881340881341046*G0_0_0_9_0 - 0.00203130203130242*G0_0_0_9_1 - 0.000881340881341034*G0_0_0_9_2 - 0.000649350649350799*G0_0_0_9_3 - 0.00718281718281836*G0_0_0_9_4 - 0.0072827172827185*G0_0_0_9_5 - 0.00728271728271848*G0_0_0_9_6 - 0.00718281718281838*G0_0_0_9_7 - 0.000649350649350821*G0_0_0_9_8 - 0.0600599400599502*G0_0_0_9_9;
    A[68] = -A[65] + 0.00255659684231164*G0_0_1_0_0 + 0.000318869842679434*G0_0_1_0_1 + 0.00504261170927922*G0_0_1_0_2 - 0.00198499912785659*G0_0_1_0_3 + 0.0262382062382107*G0_0_1_0_4 - 0.00676466390752218*G0_0_1_0_5 + 0.00941058941059096*G0_0_1_0_6 - 0.00316064887493507*G0_0_1_0_7 - 0.000746872175443755*G0_0_1_0_8 + 0.0195632938490115*G0_0_1_0_9 + 0.000318869842679434*G0_0_1_1_0 - 0.00360133693467081*G0_0_1_1_1 + 0.00603519936853371*G0_0_1_1_2 - 0.0080560709132151*G0_0_1_1_3 + 0.00894882894883048*G0_0_1_1_4 - 0.00297448583162919*G0_0_1_1_5 + 0.000823620823620947*G0_0_1_1_6 + 0.00137925566497017*G0_0_1_1_7 - 0.00490874205159998*G0_0_1_1_8 + 0.00427952999381645*G0_0_1_1_9 + 0.00504261170927922*G0_0_1_2_0 + 0.00603519936853371*G0_0_1_2_1 + 0.196588596588629*G0_0_1_2_2 - 0.0287490287490334*G0_0_1_2_3 + 0.0391164391164455*G0_0_1_2_4 - 0.024131424131428*G0_0_1_2_5 + 0.0565212565212658*G0_0_1_2_6 + 0.00192918192918227*G0_0_1_2_7 - 0.000574980574980646*G0_0_1_2_8 - 0.0101232101232119*G0_0_1_2_9 - 0.00198499912785659*G0_0_1_3_0 - 0.0080560709132151*G0_0_1_3_1 - 0.0287490287490334*G0_0_1_3_2 + 0.0551048951049044*G0_0_1_3_3 - 0.0304295704295755*G0_0_1_3_4 + 0.0108691308691327*G0_0_1_3_5 - 0.00933066933067087*G0_0_1_3_6 - 0.000904809476238232*G0_0_1_3_7 + 0.00603967461110425*G0_0_1_3_8 - 0.0110289710289728*G0_0_1_3_9 + 0.0262382062382107*G0_0_1_4_0 + 0.00894882894883048*G0_0_1_4_1 + 0.0391164391164455*G0_0_1_4_2 - 0.0304295704295755*G0_0_1_4_3 + 0.491108891108974*G0_0_1_4_4 - 0.08557442557444*G0_0_1_4_5 + 0.0949050949051109*G0_0_1_4_6 - 0.0388211788211854*G0_0_1_4_7 - 0.00513486513486604*G0_0_1_4_8 + 0.201518481518515*G0_0_1_4_9 - 0.00676466390752218*G0_0_1_5_0 - 0.00297448583162919*G0_0_1_5_1 - 0.024131424131428*G0_0_1_5_2 + 0.0108691308691327*G0_0_1_5_3 - 0.0855744255744399*G0_0_1_5_4 + 0.0173826173826203*G0_0_1_5_5 - 0.0341058941058997*G0_0_1_5_6 + 0.0105837020122753*G0_0_1_5_7 + 0.00206365063507955*G0_0_1_5_8 - 0.0628171828171934*G0_0_1_5_9 + 0.00941058941059096*G0_0_1_6_0 + 0.000823620823620947*G0_0_1_6_1 + 0.0565212565212658*G0_0_1_6_2 - 0.00933066933067087*G0_0_1_6_3 + 0.0949050949051109*G0_0_1_6_4 - 0.0341058941058997*G0_0_1_6_5 - 0.111488511488531*G0_0_1_6_6 - 0.0126473526473548*G0_0_1_6_7 + 0.00305694305694355*G0_0_1_6_8 + 0.0490309690309774*G0_0_1_6_9 - 0.00316064887493507*G0_0_1_7_0 + 0.00137925566497017*G0_0_1_7_1 + 0.00192918192918227*G0_0_1_7_2 - 0.000904809476238232*G0_0_1_7_3 - 0.0388211788211854*G0_0_1_7_4 + 0.0105837020122753*G0_0_1_7_5 - 0.0126473526473548*G0_0_1_7_6 + 0.000416726131012351*G0_0_1_7_7 + 0.00131582703011289*G0_0_1_7_8 - 0.0333951762523247*G0_0_1_7_9 - 0.000746872175443755*G0_0_1_8_0 - 0.00490874205159998*G0_0_1_8_1 - 0.000574980574980646*G0_0_1_8_2 + 0.00603967461110426*G0_0_1_8_3 - 0.00513486513486604*G0_0_1_8_4 + 0.00206365063507955*G0_0_1_8_5 + 0.00305694305694355*G0_0_1_8_6 + 0.00131582703011289*G0_0_1_8_7 - 0.0164349935778531*G0_0_1_8_8 - 0.00256885971171724*G0_0_1_8_9 + 0.0195632938490115*G0_0_1_9_0 + 0.00427952999381645*G0_0_1_9_1 - 0.0101232101232119*G0_0_1_9_2 - 0.0110289710289728*G0_0_1_9_3 + 0.201518481518515*G0_0_1_9_4 - 0.0628171828171934*G0_0_1_9_5 + 0.0490309690309773*G0_0_1_9_6 - 0.0333951762523247*G0_0_1_9_7 - 0.00256885971171724*G0_0_1_9_8 + 0.205714285714321*G0_0_1_9_9 - 0.000348434634148923*G0_1_1_0_0 - 0.00707077754696928*G0_1_1_0_1 - 0.00117043450376804*G0_1_1_0_2 - 0.00716711859569126*G0_1_1_0_3 + 0.00632224917939315*G0_1_1_0_4 + 0.00190095618667082*G0_1_1_0_5 - 0.00192664478378799*G0_1_1_0_6 + 0.00969379826522854*G0_1_1_0_7 - 0.0145857317285914*G0_1_1_0_8 - 0.00482374768089135*G0_1_1_0_9 - 0.00707077754696928*G0_1_1_1_0 - 0.0961024161024332*G0_1_1_1_1 - 0.00173036839703538*G0_1_1_1_2 - 0.0294105894105946*G0_1_1_1_3 + 0.0055658627087209*G0_1_1_1_4 + 0.00287997716569199*G0_1_1_1_5 - 0.00586556300842118*G0_1_1_1_6 + 0.0330761302189932*G0_1_1_1_7 - 0.0708447108447233*G0_1_1_1_8 - 0.00673612102183652*G0_1_1_1_9 - 0.00117043450376804*G0_1_1_2_0 - 0.00173036839703538*G0_1_1_2_1 + 0.0139514806181494*G0_1_1_2_2 - 0.0162393162393189*G0_1_1_2_3 + 0.000710400710400738*G0_1_1_2_4 + 0.00192030192030229*G0_1_1_2_5 + 0.00295260295260338*G0_1_1_2_6 + 0.00429570429570503*G0_1_1_2_7 - 0.0104895104895122*G0_1_1_2_8 - 0.0113886113886133*G0_1_1_2_9 - 0.00716711859569126*G0_1_1_3_0 - 0.0294105894105946*G0_1_1_3_1 - 0.0162393162393189*G0_1_1_3_2 - 0.140345368916822*G0_1_1_3_3 + 0.0878121878122027*G0_1_1_3_4 + 0.000693592122163668*G0_1_1_3_5 + 0.029070929070934*G0_1_1_3_6 + 0.0329755958327443*G0_1_1_3_7 - 0.0759183673469517*G0_1_1_3_8 - 0.0457428285999792*G0_1_1_3_9 + 0.00632224917939315*G0_1_1_4_0 + 0.0055658627087209*G0_1_1_4_1 + 0.000710400710400742*G0_1_1_4_2 + 0.0878121878122027*G0_1_1_4_3 + 0.0683316683316803*G0_1_1_4_4 - 0.00749250749250881*G0_1_1_4_5 - 0.0215784215784252*G0_1_1_4_6 - 0.0216640502354825*G0_1_1_4_7 + 0.0429427715142073*G0_1_1_4_8 + 0.0491508491508575*G0_1_1_4_9 + 0.00190095618667082*G0_1_1_5_0 + 0.00287997716569199*G0_1_1_5_1 + 0.00192030192030229*G0_1_1_5_2 + 0.000693592122163668*G0_1_1_5_3 - 0.00749250749250881*G0_1_1_5_4 - 0.000685029256457868*G0_1_1_5_5 + 0.00869130869131011*G0_1_1_5_6 - 0.00142143570715018*G0_1_1_5_7 + 0.00283430854859477*G0_1_1_5_8 + 0.00880262594548458*G0_1_1_5_9 - 0.00192664478378799*G0_1_1_6_0 - 0.00586556300842118*G0_1_1_6_1 + 0.00295260295260338*G0_1_1_6_2 + 0.029070929070934*G0_1_1_6_3 - 0.0215784215784252*G0_1_1_6_4 + 0.00869130869131011*G0_1_1_6_5 - 0.0659340659340773*G0_1_1_6_6 - 0.00141287284144455*G0_1_1_6_7 + 0.0187954902240648*G0_1_1_6_8 - 0.0239760239760281*G0_1_1_6_9 + 0.00969379826522854*G0_1_1_7_0 + 0.0330761302189932*G0_1_1_7_1 + 0.00429570429570503*G0_1_1_7_2 + 0.0329755958327443*G0_1_1_7_3 - 0.0216640502354825*G0_1_1_7_4 - 0.00142143570715018*G0_1_1_7_5 - 0.00141287284144455*G0_1_1_7_6 - 0.0455886970172759*G0_1_1_7_7 + 0.0570201227344183*G0_1_1_7_8 + 0.0172969887255631*G0_1_1_7_9 - 0.0145857317285915*G0_1_1_8_0 - 0.0708447108447233*G0_1_1_8_1 - 0.0104895104895122*G0_1_1_8_2 - 0.0759183673469517*G0_1_1_8_3 + 0.0429427715142073*G0_1_1_8_4 + 0.00283430854859477*G0_1_1_8_5 + 0.0187954902240648*G0_1_1_8_6 + 0.0570201227344183*G0_1_1_8_7 - 0.29331240188388*G0_1_1_8_8 - 0.0656771799629053*G0_1_1_8_9 - 0.00482374768089135*G0_1_1_9_0 - 0.00673612102183651*G0_1_1_9_1 - 0.0113886113886133*G0_1_1_9_2 - 0.0457428285999792*G0_1_1_9_3 + 0.0491508491508576*G0_1_1_9_4 + 0.00880262594548458*G0_1_1_9_5 - 0.0239760239760281*G0_1_1_9_6 + 0.0172969887255631*G0_1_1_9_7 - 0.0656771799629053*G0_1_1_9_8 - 0.110152704438437*G0_1_1_9_9;
    A[169] = A[68] - 0.00052941767227487*G0_0_0_0_0 + 0.000543900543900634*G0_0_0_0_1 - 0.0174131688417432*G0_0_0_0_2 + 0.00411493268636195*G0_0_0_0_3 - 0.00071262071262079*G0_0_0_0_4 + 0.0113137655994818*G0_0_0_0_5 - 0.0246302903445803*G0_0_0_0_6 + 0.000366617509474702*G0_0_0_0_7 + 0.000209631638203097*G0_0_0_0_8 + 0.000108462965605845*G0_0_0_0_9 + 0.000543900543900634*G0_0_0_1_0 + 0.0252784252784293*G0_0_0_1_1 - 0.00787519358948061*G0_0_0_1_2 + 0.0272565529708432*G0_0_0_1_3 - 0.0114885114885133*G0_0_0_1_4 + 0.003302411873841*G0_0_0_1_5 - 0.0130088958660409*G0_0_0_1_6 - 0.00504289361432303*G0_0_0_1_7 + 0.0125081267938431*G0_0_0_1_8 + 0.00235003092145991*G0_0_0_1_9 - 0.0174131688417432*G0_0_0_2_0 - 0.00787519358948061*G0_0_0_2_1 - 0.30066822066827*G0_0_0_2_2 + 0.0471509442938091*G0_0_0_2_3 - 0.085194805194819*G0_0_0_2_4 + 0.0816941788370495*G0_0_0_2_5 - 0.185023865023896*G0_0_0_2_6 + 0.00238903953189704*G0_0_0_2_7 + 0.000752580752580848*G0_0_0_2_8 - 0.0183511726368899*G0_0_0_2_9 + 0.00411493268636195*G0_0_0_3_0 + 0.0272565529708432*G0_0_0_3_1 + 0.0471509442938091*G0_0_0_3_2 + 0.0222977022977065*G0_0_0_3_3 - 0.0172370486656233*G0_0_0_3_4 - 0.0150991865277604*G0_0_0_3_5 + 0.0469730269730346*G0_0_0_3_6 - 0.00439845868417373*G0_0_0_3_7 - 0.00129013843299571*G0_0_0_3_8 + 0.00174682460396776*G0_0_0_3_9 - 0.00071262071262079*G0_0_0_4_0 - 0.0114885114885133*G0_0_0_4_1 - 0.085194805194819*G0_0_0_4_2 - 0.0172