// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F3_P2_Q3_TENSOR_H
#define __LAPLACIAN_F3_P2_Q3_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f3_p2_q3_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f3_p2_q3_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q3_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f3_p2_q3_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class laplacian_f3_p2_q3_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f3_p2_q3_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q3_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f3_p2_q3_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f3_p2_q3_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f3_p2_q3_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q3_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f3_p2_q3_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f3_p2_q3_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f3_p2_q3_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q3_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f3_p2_q3_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f3_p2_q3_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f3_p2_q3_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f3_p2_q3_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    3024
    // Number of operations (multiply-add pairs) for tensor contraction: 45199
    // Total number of operations (multiply-add pairs):                  48234
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_3 = det*(w[2][0]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_4 = det*(w[2][0]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_5 = det*(w[2][0]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_3 = det*(w[2][0]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_4 = det*(w[2][0]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1_5 = det*(w[2][0]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_3 = det*(w[2][0]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_4 = det*(w[2][0]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2_5 = det*(w[2][0]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_0 = det*(w[2][0]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_1 = det*(w[2][0]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_2 = det*(w[2][0]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_3 = det*(w[2][0]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_4 = det*(w[2][0]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_3_5 = det*(w[2][0]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_0 = det*(w[2][0]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_1 = det*(w[2][0]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_2 = det*(w[2][0]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_3 = det*(w[2][0]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_4 = det*(w[2][0]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_4_5 = det*(w[2][0]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_0 = det*(w[2][0]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_1 = det*(w[2][0]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_2 = det*(w[2][0]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_3 = det*(w[2][0]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_4 = det*(w[2][0]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_5_5 = det*(w[2][0]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_3 = det*(w[2][1]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_4 = det*(w[2][1]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_5 = det*(w[2][1]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_3 = det*(w[2][1]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_4 = det*(w[2][1]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1_5 = det*(w[2][1]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_3 = det*(w[2][1]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_4 = det*(w[2][1]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2_5 = det*(w[2][1]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_0 = det*(w[2][1]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_1 = det*(w[2][1]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_2 = det*(w[2][1]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_3 = det*(w[2][1]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_4 = det*(w[2][1]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_3_5 = det*(w[2][1]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_0 = det*(w[2][1]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_1 = det*(w[2][1]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_2 = det*(w[2][1]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_3 = det*(w[2][1]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_4 = det*(w[2][1]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_4_5 = det*(w[2][1]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_0 = det*(w[2][1]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_1 = det*(w[2][1]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_2 = det*(w[2][1]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_3 = det*(w[2][1]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_4 = det*(w[2][1]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_5_5 = det*(w[2][1]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_3 = det*(w[2][2]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_4 = det*(w[2][2]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_5 = det*(w[2][2]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_3 = det*(w[2][2]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_4 = det*(w[2][2]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1_5 = det*(w[2][2]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_3 = det*(w[2][2]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_4 = det*(w[2][2]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2_5 = det*(w[2][2]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_0 = det*(w[2][2]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_1 = det*(w[2][2]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_2 = det*(w[2][2]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_3 = det*(w[2][2]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_4 = det*(w[2][2]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_3_5 = det*(w[2][2]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_0 = det*(w[2][2]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_1 = det*(w[2][2]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_2 = det*(w[2][2]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_3 = det*(w[2][2]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_4 = det*(w[2][2]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_4_5 = det*(w[2][2]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_0 = det*(w[2][2]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_1 = det*(w[2][2]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_2 = det*(w[2][2]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_3 = det*(w[2][2]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_4 = det*(w[2][2]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_5_5 = det*(w[2][2]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_0 = det*(w[2][3]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_1 = det*(w[2][3]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_2 = det*(w[2][3]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_3 = det*(w[2][3]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_4 = det*(w[2][3]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_5 = det*(w[2][3]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_0 = det*(w[2][3]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_1 = det*(w[2][3]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_2 = det*(w[2][3]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_3 = det*(w[2][3]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_4 = det*(w[2][3]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_1_5 = det*(w[2][3]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_0 = det*(w[2][3]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_1 = det*(w[2][3]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_2 = det*(w[2][3]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_3 = det*(w[2][3]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_4 = det*(w[2][3]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_2_5 = det*(w[2][3]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_0 = det*(w[2][3]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_1 = det*(w[2][3]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_2 = det*(w[2][3]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_3 = det*(w[2][3]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_4 = det*(w[2][3]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_3_5 = det*(w[2][3]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_0 = det*(w[2][3]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_1 = det*(w[2][3]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_2 = det*(w[2][3]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_3 = det*(w[2][3]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_4 = det*(w[2][3]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_4_5 = det*(w[2][3]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_0 = det*(w[2][3]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_1 = det*(w[2][3]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_2 = det*(w[2][3]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_3 = det*(w[2][3]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_4 = det*(w[2][3]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_5_5 = det*(w[2][3]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_0 = det*(w[2][4]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_1 = det*(w[2][4]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_2 = det*(w[2][4]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_3 = det*(w[2][4]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_4 = det*(w[2][4]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_5 = det*(w[2][4]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_0 = det*(w[2][4]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_1 = det*(w[2][4]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_2 = det*(w[2][4]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_3 = det*(w[2][4]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_4 = det*(w[2][4]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_1_5 = det*(w[2][4]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_0 = det*(w[2][4]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_1 = det*(w[2][4]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_2 = det*(w[2][4]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_3 = det*(w[2][4]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_4 = det*(w[2][4]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_2_5 = det*(w[2][4]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_0 = det*(w[2][4]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_1 = det*(w[2][4]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_2 = det*(w[2][4]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_3 = det*(w[2][4]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_4 = det*(w[2][4]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_3_5 = det*(w[2][4]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_0 = det*(w[2][4]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_1 = det*(w[2][4]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_2 = det*(w[2][4]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_3 = det*(w[2][4]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_4 = det*(w[2][4]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_4_5 = det*(w[2][4]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_0 = det*(w[2][4]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_1 = det*(w[2][4]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_2 = det*(w[2][4]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_3 = det*(w[2][4]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_4 = det*(w[2][4]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_5_5 = det*(w[2][4]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_0 = det*(w[2][5]*w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_1 = det*(w[2][5]*w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_2 = det*(w[2][5]*w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_3 = det*(w[2][5]*w[0][0]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_4 = det*(w[2][5]*w[0][0]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_5 = det*(w[2][5]*w[0][0]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_0 = det*(w[2][5]*w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_1 = det*(w[2][5]*w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_2 = det*(w[2][5]*w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_3 = det*(w[2][5]*w[0][1]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_4 = det*(w[2][5]*w[0][1]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_1_5 = det*(w[2][5]*w[0][1]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_0 = det*(w[2][5]*w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_1 = det*(w[2][5]*w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_2 = det*(w[2][5]*w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_3 = det*(w[2][5]*w[0][2]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_4 = det*(w[2][5]*w[0][2]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_2_5 = det*(w[2][5]*w[0][2]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_0 = det*(w[2][5]*w[0][3]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_1 = det*(w[2][5]*w[0][3]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_2 = det*(w[2][5]*w[0][3]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_3 = det*(w[2][5]*w[0][3]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_4 = det*(w[2][5]*w[0][3]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_3_5 = det*(w[2][5]*w[0][3]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_0 = det*(w[2][5]*w[0][4]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_1 = det*(w[2][5]*w[0][4]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_2 = det*(w[2][5]*w[0][4]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_3 = det*(w[2][5]*w[0][4]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_4 = det*(w[2][5]*w[0][4]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_4_5 = det*(w[2][5]*w[0][4]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_0 = det*(w[2][5]*w[0][5]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_1 = det*(w[2][5]*w[0][5]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_2 = det*(w[2][5]*w[0][5]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_3 = det*(w[2][5]*w[0][5]*w[1][3]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_4 = det*(w[2][5]*w[0][5]*w[1][4]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_5_5 = det*(w[2][5]*w[0][5]*w[1][5]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_3 = det*(w[2][0]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_4 = det*(w[2][0]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_5 = det*(w[2][0]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_3 = det*(w[2][0]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_4 = det*(w[2][0]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1_5 = det*(w[2][0]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_3 = det*(w[2][0]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_4 = det*(w[2][0]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2_5 = det*(w[2][0]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_0 = det*(w[2][0]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_1 = det*(w[2][0]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_2 = det*(w[2][0]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_3 = det*(w[2][0]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_4 = det*(w[2][0]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_3_5 = det*(w[2][0]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_0 = det*(w[2][0]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_1 = det*(w[2][0]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_2 = det*(w[2][0]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_3 = det*(w[2][0]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_4 = det*(w[2][0]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_4_5 = det*(w[2][0]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_0 = det*(w[2][0]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_1 = det*(w[2][0]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_2 = det*(w[2][0]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_3 = det*(w[2][0]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_4 = det*(w[2][0]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_5_5 = det*(w[2][0]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_3 = det*(w[2][1]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_4 = det*(w[2][1]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_5 = det*(w[2][1]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_3 = det*(w[2][1]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_4 = det*(w[2][1]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1_5 = det*(w[2][1]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_3 = det*(w[2][1]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_4 = det*(w[2][1]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2_5 = det*(w[2][1]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_0 = det*(w[2][1]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_1 = det*(w[2][1]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_2 = det*(w[2][1]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_3 = det*(w[2][1]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_4 = det*(w[2][1]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_3_5 = det*(w[2][1]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_0 = det*(w[2][1]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_1 = det*(w[2][1]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_2 = det*(w[2][1]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_3 = det*(w[2][1]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_4 = det*(w[2][1]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_4_5 = det*(w[2][1]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_0 = det*(w[2][1]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_1 = det*(w[2][1]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_2 = det*(w[2][1]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_3 = det*(w[2][1]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_4 = det*(w[2][1]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_5_5 = det*(w[2][1]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_3 = det*(w[2][2]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_4 = det*(w[2][2]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_5 = det*(w[2][2]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_3 = det*(w[2][2]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_4 = det*(w[2][2]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1_5 = det*(w[2][2]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_3 = det*(w[2][2]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_4 = det*(w[2][2]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2_5 = det*(w[2][2]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_0 = det*(w[2][2]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_1 = det*(w[2][2]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_2 = det*(w[2][2]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_3 = det*(w[2][2]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_4 = det*(w[2][2]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_3_5 = det*(w[2][2]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_0 = det*(w[2][2]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_1 = det*(w[2][2]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_2 = det*(w[2][2]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_3 = det*(w[2][2]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_4 = det*(w[2][2]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_4_5 = det*(w[2][2]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_0 = det*(w[2][2]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_1 = det*(w[2][2]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_2 = det*(w[2][2]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_3 = det*(w[2][2]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_4 = det*(w[2][2]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_5_5 = det*(w[2][2]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_0 = det*(w[2][3]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_1 = det*(w[2][3]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_2 = det*(w[2][3]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_3 = det*(w[2][3]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_4 = det*(w[2][3]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_5 = det*(w[2][3]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_0 = det*(w[2][3]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_1 = det*(w[2][3]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_2 = det*(w[2][3]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_3 = det*(w[2][3]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_4 = det*(w[2][3]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_1_5 = det*(w[2][3]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_0 = det*(w[2][3]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_1 = det*(w[2][3]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_2 = det*(w[2][3]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_3 = det*(w[2][3]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_4 = det*(w[2][3]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_2_5 = det*(w[2][3]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_0 = det*(w[2][3]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_1 = det*(w[2][3]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_2 = det*(w[2][3]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_3 = det*(w[2][3]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_4 = det*(w[2][3]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_3_5 = det*(w[2][3]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_0 = det*(w[2][3]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_1 = det*(w[2][3]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_2 = det*(w[2][3]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_3 = det*(w[2][3]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_4 = det*(w[2][3]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_4_5 = det*(w[2][3]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_0 = det*(w[2][3]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_1 = det*(w[2][3]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_2 = det*(w[2][3]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_3 = det*(w[2][3]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_4 = det*(w[2][3]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_5_5 = det*(w[2][3]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_0 = det*(w[2][4]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_1 = det*(w[2][4]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_2 = det*(w[2][4]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_3 = det*(w[2][4]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_4 = det*(w[2][4]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_5 = det*(w[2][4]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_0 = det*(w[2][4]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_1 = det*(w[2][4]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_2 = det*(w[2][4]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_3 = det*(w[2][4]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_4 = det*(w[2][4]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_1_5 = det*(w[2][4]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_0 = det*(w[2][4]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_1 = det*(w[2][4]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_2 = det*(w[2][4]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_3 = det*(w[2][4]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_4 = det*(w[2][4]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_2_5 = det*(w[2][4]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_0 = det*(w[2][4]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_1 = det*(w[2][4]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_2 = det*(w[2][4]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_3 = det*(w[2][4]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_4 = det*(w[2][4]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_3_5 = det*(w[2][4]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_0 = det*(w[2][4]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_1 = det*(w[2][4]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_2 = det*(w[2][4]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_3 = det*(w[2][4]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_4 = det*(w[2][4]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_4_5 = det*(w[2][4]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_0 = det*(w[2][4]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_1 = det*(w[2][4]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_2 = det*(w[2][4]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_3 = det*(w[2][4]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_4 = det*(w[2][4]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_5_5 = det*(w[2][4]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_0 = det*(w[2][5]*w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_1 = det*(w[2][5]*w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_2 = det*(w[2][5]*w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_3 = det*(w[2][5]*w[0][0]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_4 = det*(w[2][5]*w[0][0]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_5 = det*(w[2][5]*w[0][0]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_0 = det*(w[2][5]*w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_1 = det*(w[2][5]*w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_2 = det*(w[2][5]*w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_3 = det*(w[2][5]*w[0][1]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_4 = det*(w[2][5]*w[0][1]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_1_5 = det*(w[2][5]*w[0][1]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_0 = det*(w[2][5]*w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_1 = det*(w[2][5]*w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_2 = det*(w[2][5]*w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_3 = det*(w[2][5]*w[0][2]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_4 = det*(w[2][5]*w[0][2]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_2_5 = det*(w[2][5]*w[0][2]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_0 = det*(w[2][5]*w[0][3]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_1 = det*(w[2][5]*w[0][3]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_2 = det*(w[2][5]*w[0][3]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_3 = det*(w[2][5]*w[0][3]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_4 = det*(w[2][5]*w[0][3]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_3_5 = det*(w[2][5]*w[0][3]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_0 = det*(w[2][5]*w[0][4]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_1 = det*(w[2][5]*w[0][4]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_2 = det*(w[2][5]*w[0][4]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_3 = det*(w[2][5]*w[0][4]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_4 = det*(w[2][5]*w[0][4]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_4_5 = det*(w[2][5]*w[0][4]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_0 = det*(w[2][5]*w[0][5]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_1 = det*(w[2][5]*w[0][5]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_2 = det*(w[2][5]*w[0][5]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_3 = det*(w[2][5]*w[0][5]*w[1][3]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_4 = det*(w[2][5]*w[0][5]*w[1][4]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_5_5 = det*(w[2][5]*w[0][5]*w[1][5]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_3 = det*(w[2][0]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_4 = det*(w[2][0]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_5 = det*(w[2][0]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_3 = det*(w[2][0]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_4 = det*(w[2][0]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1_5 = det*(w[2][0]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_3 = det*(w[2][0]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_4 = det*(w[2][0]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2_5 = det*(w[2][0]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_0 = det*(w[2][0]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_1 = det*(w[2][0]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_2 = det*(w[2][0]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_3 = det*(w[2][0]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_4 = det*(w[2][0]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_3_5 = det*(w[2][0]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_0 = det*(w[2][0]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_1 = det*(w[2][0]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_2 = det*(w[2][0]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_3 = det*(w[2][0]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_4 = det*(w[2][0]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_4_5 = det*(w[2][0]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_0 = det*(w[2][0]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_1 = det*(w[2][0]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_2 = det*(w[2][0]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_3 = det*(w[2][0]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_4 = det*(w[2][0]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_5_5 = det*(w[2][0]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_3 = det*(w[2][1]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_4 = det*(w[2][1]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_5 = det*(w[2][1]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_3 = det*(w[2][1]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_4 = det*(w[2][1]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1_5 = det*(w[2][1]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_3 = det*(w[2][1]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_4 = det*(w[2][1]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2_5 = det*(w[2][1]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_0 = det*(w[2][1]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_1 = det*(w[2][1]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_2 = det*(w[2][1]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_3 = det*(w[2][1]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_4 = det*(w[2][1]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_3_5 = det*(w[2][1]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_0 = det*(w[2][1]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_1 = det*(w[2][1]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_2 = det*(w[2][1]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_3 = det*(w[2][1]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_4 = det*(w[2][1]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_4_5 = det*(w[2][1]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_0 = det*(w[2][1]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_1 = det*(w[2][1]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_2 = det*(w[2][1]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_3 = det*(w[2][1]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_4 = det*(w[2][1]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_5_5 = det*(w[2][1]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_3 = det*(w[2][2]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_4 = det*(w[2][2]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_5 = det*(w[2][2]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_3 = det*(w[2][2]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_4 = det*(w[2][2]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1_5 = det*(w[2][2]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_3 = det*(w[2][2]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_4 = det*(w[2][2]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2_5 = det*(w[2][2]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_0 = det*(w[2][2]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_1 = det*(w[2][2]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_2 = det*(w[2][2]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_3 = det*(w[2][2]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_4 = det*(w[2][2]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_3_5 = det*(w[2][2]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_0 = det*(w[2][2]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_1 = det*(w[2][2]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_2 = det*(w[2][2]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_3 = det*(w[2][2]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_4 = det*(w[2][2]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_4_5 = det*(w[2][2]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_0 = det*(w[2][2]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_1 = det*(w[2][2]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_2 = det*(w[2][2]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_3 = det*(w[2][2]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_4 = det*(w[2][2]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_5_5 = det*(w[2][2]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_0 = det*(w[2][3]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_1 = det*(w[2][3]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_2 = det*(w[2][3]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_3 = det*(w[2][3]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_4 = det*(w[2][3]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_5 = det*(w[2][3]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_0 = det*(w[2][3]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_1 = det*(w[2][3]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_2 = det*(w[2][3]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_3 = det*(w[2][3]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_4 = det*(w[2][3]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_1_5 = det*(w[2][3]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_0 = det*(w[2][3]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_1 = det*(w[2][3]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_2 = det*(w[2][3]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_3 = det*(w[2][3]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_4 = det*(w[2][3]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_2_5 = det*(w[2][3]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_0 = det*(w[2][3]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_1 = det*(w[2][3]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_2 = det*(w[2][3]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_3 = det*(w[2][3]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_4 = det*(w[2][3]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_3_5 = det*(w[2][3]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_0 = det*(w[2][3]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_1 = det*(w[2][3]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_2 = det*(w[2][3]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_3 = det*(w[2][3]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_4 = det*(w[2][3]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_4_5 = det*(w[2][3]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_0 = det*(w[2][3]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_1 = det*(w[2][3]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_2 = det*(w[2][3]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_3 = det*(w[2][3]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_4 = det*(w[2][3]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_5_5 = det*(w[2][3]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_0 = det*(w[2][4]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_1 = det*(w[2][4]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_2 = det*(w[2][4]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_3 = det*(w[2][4]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_4 = det*(w[2][4]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_5 = det*(w[2][4]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_0 = det*(w[2][4]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_1 = det*(w[2][4]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_2 = det*(w[2][4]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_3 = det*(w[2][4]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_4 = det*(w[2][4]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_1_5 = det*(w[2][4]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_0 = det*(w[2][4]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_1 = det*(w[2][4]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_2 = det*(w[2][4]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_3 = det*(w[2][4]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_4 = det*(w[2][4]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_2_5 = det*(w[2][4]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_0 = det*(w[2][4]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_1 = det*(w[2][4]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_2 = det*(w[2][4]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_3 = det*(w[2][4]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_4 = det*(w[2][4]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_3_5 = det*(w[2][4]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_0 = det*(w[2][4]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_1 = det*(w[2][4]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_2 = det*(w[2][4]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_3 = det*(w[2][4]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_4 = det*(w[2][4]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_4_5 = det*(w[2][4]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_0 = det*(w[2][4]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_1 = det*(w[2][4]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_2 = det*(w[2][4]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_3 = det*(w[2][4]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_4 = det*(w[2][4]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_5_5 = det*(w[2][4]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_0 = det*(w[2][5]*w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_1 = det*(w[2][5]*w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_2 = det*(w[2][5]*w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_3 = det*(w[2][5]*w[0][0]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_4 = det*(w[2][5]*w[0][0]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_5 = det*(w[2][5]*w[0][0]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_0 = det*(w[2][5]*w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_1 = det*(w[2][5]*w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_2 = det*(w[2][5]*w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_3 = det*(w[2][5]*w[0][1]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_4 = det*(w[2][5]*w[0][1]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_1_5 = det*(w[2][5]*w[0][1]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_0 = det*(w[2][5]*w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_1 = det*(w[2][5]*w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_2 = det*(w[2][5]*w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_3 = det*(w[2][5]*w[0][2]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_4 = det*(w[2][5]*w[0][2]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_2_5 = det*(w[2][5]*w[0][2]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_0 = det*(w[2][5]*w[0][3]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_1 = det*(w[2][5]*w[0][3]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_2 = det*(w[2][5]*w[0][3]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_3 = det*(w[2][5]*w[0][3]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_4 = det*(w[2][5]*w[0][3]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_3_5 = det*(w[2][5]*w[0][3]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_0 = det*(w[2][5]*w[0][4]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_1 = det*(w[2][5]*w[0][4]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_2 = det*(w[2][5]*w[0][4]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_3 = det*(w[2][5]*w[0][4]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_4 = det*(w[2][5]*w[0][4]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_4_5 = det*(w[2][5]*w[0][4]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_0 = det*(w[2][5]*w[0][5]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_1 = det*(w[2][5]*w[0][5]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_2 = det*(w[2][5]*w[0][5]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_3 = det*(w[2][5]*w[0][5]*w[1][3]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_4 = det*(w[2][5]*w[0][5]*w[1][4]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_5_5 = det*(w[2][5]*w[0][5]*w[1][5]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0_0 = det*(w[2][0]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_1 = det*(w[2][0]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_2 = det*(w[2][0]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_3 = det*(w[2][0]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_4 = det*(w[2][0]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_5 = det*(w[2][0]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_0 = det*(w[2][0]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_1 = det*(w[2][0]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_2 = det*(w[2][0]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_3 = det*(w[2][0]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_4 = det*(w[2][0]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1_5 = det*(w[2][0]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_0 = det*(w[2][0]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_1 = det*(w[2][0]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_2 = det*(w[2][0]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_3 = det*(w[2][0]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_4 = det*(w[2][0]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2_5 = det*(w[2][0]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_0 = det*(w[2][0]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_1 = det*(w[2][0]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_2 = det*(w[2][0]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_3 = det*(w[2][0]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_4 = det*(w[2][0]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_3_5 = det*(w[2][0]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_0 = det*(w[2][0]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_1 = det*(w[2][0]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_2 = det*(w[2][0]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_3 = det*(w[2][0]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_4 = det*(w[2][0]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_4_5 = det*(w[2][0]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_0 = det*(w[2][0]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_1 = det*(w[2][0]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_2 = det*(w[2][0]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_3 = det*(w[2][0]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_4 = det*(w[2][0]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_5_5 = det*(w[2][0]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_0 = det*(w[2][1]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_1 = det*(w[2][1]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_2 = det*(w[2][1]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_3 = det*(w[2][1]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_4 = det*(w[2][1]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_5 = det*(w[2][1]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_0 = det*(w[2][1]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_1 = det*(w[2][1]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_2 = det*(w[2][1]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_3 = det*(w[2][1]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_4 = det*(w[2][1]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1_5 = det*(w[2][1]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_0 = det*(w[2][1]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_1 = det*(w[2][1]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_2 = det*(w[2][1]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_3 = det*(w[2][1]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_4 = det*(w[2][1]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2_5 = det*(w[2][1]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_0 = det*(w[2][1]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_1 = det*(w[2][1]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_2 = det*(w[2][1]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_3 = det*(w[2][1]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_4 = det*(w[2][1]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_3_5 = det*(w[2][1]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_0 = det*(w[2][1]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_1 = det*(w[2][1]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_2 = det*(w[2][1]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_3 = det*(w[2][1]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_4 = det*(w[2][1]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_4_5 = det*(w[2][1]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_0 = det*(w[2][1]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_1 = det*(w[2][1]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_2 = det*(w[2][1]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_3 = det*(w[2][1]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_4 = det*(w[2][1]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_5_5 = det*(w[2][1]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_0 = det*(w[2][2]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_1 = det*(w[2][2]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_2 = det*(w[2][2]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_3 = det*(w[2][2]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_4 = det*(w[2][2]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_5 = det*(w[2][2]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_0 = det*(w[2][2]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_1 = det*(w[2][2]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_2 = det*(w[2][2]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_3 = det*(w[2][2]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_4 = det*(w[2][2]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1_5 = det*(w[2][2]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_0 = det*(w[2][2]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_1 = det*(w[2][2]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_2 = det*(w[2][2]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_3 = det*(w[2][2]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_4 = det*(w[2][2]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2_5 = det*(w[2][2]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_0 = det*(w[2][2]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_1 = det*(w[2][2]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_2 = det*(w[2][2]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_3 = det*(w[2][2]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_4 = det*(w[2][2]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_3_5 = det*(w[2][2]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_0 = det*(w[2][2]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_1 = det*(w[2][2]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_2 = det*(w[2][2]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_3 = det*(w[2][2]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_4 = det*(w[2][2]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_4_5 = det*(w[2][2]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_0 = det*(w[2][2]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_1 = det*(w[2][2]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_2 = det*(w[2][2]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_3 = det*(w[2][2]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_4 = det*(w[2][2]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_5_5 = det*(w[2][2]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_0 = det*(w[2][3]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_1 = det*(w[2][3]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_2 = det*(w[2][3]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_3 = det*(w[2][3]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_4 = det*(w[2][3]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_5 = det*(w[2][3]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_0 = det*(w[2][3]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_1 = det*(w[2][3]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_2 = det*(w[2][3]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_3 = det*(w[2][3]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_4 = det*(w[2][3]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_1_5 = det*(w[2][3]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_0 = det*(w[2][3]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_1 = det*(w[2][3]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_2 = det*(w[2][3]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_3 = det*(w[2][3]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_4 = det*(w[2][3]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_2_5 = det*(w[2][3]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_0 = det*(w[2][3]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_1 = det*(w[2][3]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_2 = det*(w[2][3]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_3 = det*(w[2][3]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_4 = det*(w[2][3]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_3_5 = det*(w[2][3]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_0 = det*(w[2][3]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_1 = det*(w[2][3]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_2 = det*(w[2][3]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_3 = det*(w[2][3]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_4 = det*(w[2][3]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_4_5 = det*(w[2][3]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_0 = det*(w[2][3]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_1 = det*(w[2][3]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_2 = det*(w[2][3]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_3 = det*(w[2][3]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_4 = det*(w[2][3]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_5_5 = det*(w[2][3]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_0 = det*(w[2][4]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_1 = det*(w[2][4]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_2 = det*(w[2][4]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_3 = det*(w[2][4]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_4 = det*(w[2][4]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_5 = det*(w[2][4]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_0 = det*(w[2][4]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_1 = det*(w[2][4]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_2 = det*(w[2][4]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_3 = det*(w[2][4]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_4 = det*(w[2][4]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_1_5 = det*(w[2][4]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_0 = det*(w[2][4]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_1 = det*(w[2][4]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_2 = det*(w[2][4]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_3 = det*(w[2][4]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_4 = det*(w[2][4]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_2_5 = det*(w[2][4]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_0 = det*(w[2][4]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_1 = det*(w[2][4]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_2 = det*(w[2][4]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_3 = det*(w[2][4]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_4 = det*(w[2][4]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_3_5 = det*(w[2][4]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_0 = det*(w[2][4]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_1 = det*(w[2][4]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_2 = det*(w[2][4]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_3 = det*(w[2][4]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_4 = det*(w[2][4]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_4_5 = det*(w[2][4]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_0 = det*(w[2][4]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_1 = det*(w[2][4]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_2 = det*(w[2][4]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_3 = det*(w[2][4]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_4 = det*(w[2][4]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_5_5 = det*(w[2][4]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_0 = det*(w[2][5]*w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_1 = det*(w[2][5]*w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_2 = det*(w[2][5]*w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_3 = det*(w[2][5]*w[0][0]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_4 = det*(w[2][5]*w[0][0]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_5 = det*(w[2][5]*w[0][0]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_0 = det*(w[2][5]*w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_1 = det*(w[2][5]*w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_2 = det*(w[2][5]*w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_3 = det*(w[2][5]*w[0][1]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_4 = det*(w[2][5]*w[0][1]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_1_5 = det*(w[2][5]*w[0][1]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_0 = det*(w[2][5]*w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_1 = det*(w[2][5]*w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_2 = det*(w[2][5]*w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_3 = det*(w[2][5]*w[0][2]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_4 = det*(w[2][5]*w[0][2]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_2_5 = det*(w[2][5]*w[0][2]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_0 = det*(w[2][5]*w[0][3]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_1 = det*(w[2][5]*w[0][3]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_2 = det*(w[2][5]*w[0][3]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_3 = det*(w[2][5]*w[0][3]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_4 = det*(w[2][5]*w[0][3]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_3_5 = det*(w[2][5]*w[0][3]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_0 = det*(w[2][5]*w[0][4]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_1 = det*(w[2][5]*w[0][4]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_2 = det*(w[2][5]*w[0][4]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_3 = det*(w[2][5]*w[0][4]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_4 = det*(w[2][5]*w[0][4]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_4_5 = det*(w[2][5]*w[0][4]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_0 = det*(w[2][5]*w[0][5]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_1 = det*(w[2][5]*w[0][5]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_2 = det*(w[2][5]*w[0][5]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_3 = det*(w[2][5]*w[0][5]*w[1][3]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_4 = det*(w[2][5]*w[0][5]*w[1][4]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_5_5 = det*(w[2][5]*w[0][5]*w[1][5]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[73] = -0.00730519480519515*G0_0_0_0_0_0 + 0.000535714285714308*G0_0_0_0_0_1 + 0.00155844155844161*G0_0_0_0_0_2 - 0.00112012987012991*G0_0_0_0_0_3 - 0.00657467532467557*G0_0_0_0_0_4 - 0.00316558441558454*G0_0_0_0_0_5 + 0.000535714285714308*G0_0_0_0_1_0 - 0.000937500000000032*G0_0_0_0_1_1 + 0.000255681818181826*G0_0_0_0_1_2 - 0.00150974025974031*G0_0_0_0_1_3 + 4.87012987013039e-05*G0_0_0_0_1_4 + 0.00155844155844161*G0_0_0_0_2_0 + 0.000255681818181826*G0_0_0_0_2_1 - 0.000547889610389629*G0_0_0_0_2_2 - 0.000633116883116902*G0_0_0_0_2_3 + 0.000389610389610409*G0_0_0_0_2_4 - 0.0010227272727273*G0_0_0_0_2_5 - 0.00112012987012991*G0_0_0_0_3_0 - 0.00150974025974031*G0_0_0_0_3_1 - 0.000633116883116902*G0_0_0_0_3_2 - 0.0015584415584416*G0_0_0_0_3_3 + 0.00214285714285721*G0_0_0_0_3_4 + 0.00428571428571442*G0_0_0_0_3_5 - 0.00657467532467557*G0_0_0_0_4_0 + 4.87012987013038e-05*G0_0_0_0_4_1 + 0.000389610389610409*G0_0_0_0_4_2 + 0.00214285714285721*G0_0_0_0_4_3 - 0.00759740259740288*G0_0_0_0_4_4 + 0.001948051948052*G0_0_0_0_4_5 - 0.00316558441558454*G0_0_0_0_5_0 - 0.0010227272727273*G0_0_0_0_5_2 + 0.00428571428571442*G0_0_0_0_5_3 + 0.001948051948052*G0_0_0_0_5_4 + 0.00759740259740283*G0_0_0_0_5_5 + 0.000535714285714308*G0_0_0_1_0_0 - 0.000937500000000032*G0_0_0_1_0_1 + 0.000255681818181826*G0_0_0_1_0_2 - 0.00150974025974031*G0_0_0_1_0_3 + 4.87012987013039e-05*G0_0_0_1_0_4 - 0.000937500000000032*G0_0_0_1_1_0 + 0.0210024350649358*G0_0_0_1_1_1 - 0.00309253246753258*G0_0_0_1_1_2 + 0.0168019480519486*G0_0_0_1_1_3 - 4.87012987012988e-05*G0_0_0_1_1_4 + 0.00243506493506504*G0_0_0_1_1_5 + 0.000255681818181826*G0_0_0_1_2_0 - 0.00309253246753258*G0_0_0_1_2_1 + 0.000767045454545482*G0_0_0_1_2_2 - 0.00594155844155865*G0_0_0_1_2_3 - 0.00112012987012991*G0_0_0_1_2_4 - 0.00131493506493511*G0_0_0_1_2_5 - 0.00150974025974031*G0_0_0_1_3_0 + 0.0168019480519486*G0_0_0_1_3_1 - 0.00594155844155865*G0_0_0_1_3_2 + 0.0268831168831178*G0_0_0_1_3_3 + 0.00311688311688322*G0_0_0_1_3_4 + 0.00564935064935086*G0_0_0_1_3_5 + 4.87012987013038e-05*G0_0_0_1_4_0 - 4.87012987012985e-05*G0_0_0_1_4_1 - 0.00112012987012991*G0_0_0_1_4_2 + 0.00311688311688322*G0_0_0_1_4_3 + 0.00331168831168842*G0_0_0_1_4_4 + 0.00272727272727282*G0_0_0_1_4_5 + 0.00243506493506504*G0_0_0_1_5_1 - 0.00131493506493511*G0_0_0_1_5_2 + 0.00564935064935086*G0_0_0_1_5_3 + 0.00272727272727282*G0_0_0_1_5_4 + 0.00175324675324681*G0_0_0_1_5_5 + 0.00155844155844161*G0_0_0_2_0_0 + 0.000255681818181826*G0_0_0_2_0_1 - 0.000547889610389629*G0_0_0_2_0_2 - 0.000633116883116902*G0_0_0_2_0_3 + 0.000389610389610409*G0_0_0_2_0_4 - 0.0010227272727273*G0_0_0_2_0_5 + 0.000255681818181826*G0_0_0_2_1_0 - 0.00309253246753258*G0_0_0_2_1_1 + 0.000767045454545482*G0_0_0_2_1_2 - 0.00594155844155865*G0_0_0_2_1_3 - 0.00112012987012991*G0_0_0_2_1_4 - 0.00131493506493511*G0_0_0_2_1_5 - 0.000547889610389629*G0_0_0_2_2_0 + 0.000767045454545482*G0_0_0_2_2_1 + 0.0021915584415585*G0_0_0_2_2_2 + 0.00224025974025982*G0_0_0_2_2_3 + 0.000681818181818203*G0_0_0_2_2_4 - 0.00131493506493511*G0_0_0_2_2_5 - 0.000633116883116902*G0_0_0_2_3_0 - 0.00594155844155865*G0_0_0_2_3_1 + 0.00224025974025982*G0_0_0_2_3_2 - 0.00467532467532485*G0_0_0_2_3_3 + 0.00350649350649362*G0_0_0_2_3_4 + 0.00389610389610402*G0_0_0_2_3_5 + 0.000389610389610409*G0_0_0_2_4_0 - 0.00112012987012991*G0_0_0_2_4_1 + 0.000681818181818202*G0_0_0_2_4_2 + 0.00350649350649362*G0_0_0_2_4_3 + 0.00935064935064966*G0_0_0_2_4_4 + 0.00487012987013003*G0_0_0_2_4_5 - 0.0010227272727273*G0_0_0_2_5_0 - 0.00131493506493511*G0_0_0_2_5_1 - 0.00131493506493511*G0_0_0_2_5_2 + 0.00389610389610402*G0_0_0_2_5_3 + 0.00487012987013003*G0_0_0_2_5_4 + 0.00935064935064966*G0_0_0_2_5_5 - 0.00112012987012991*G0_0_0_3_0_0 - 0.00150974025974031*G0_0_0_3_0_1 - 0.000633116883116902*G0_0_0_3_0_2 - 0.0015584415584416*G0_0_0_3_0_3 + 0.00214285714285721*G0_0_0_3_0_4 + 0.00428571428571442*G0_0_0_3_0_5 - 0.00150974025974031*G0_0_0_3_1_0 + 0.0168019480519486*G0_0_0_3_1_1 - 0.00594155844155865*G0_0_0_3_1_2 + 0.0268831168831178*G0_0_0_3_1_3 + 0.00311688311688322*G0_0_0_3_1_4 + 0.00564935064935085*G0_0_0_3_1_5 - 0.000633116883116902*G0_0_0_3_2_0 - 0.00594155844155865*G0_0_0_3_2_1 + 0.00224025974025982*G0_0_0_3_2_2 - 0.00467532467532485*G0_0_0_3_2_3 + 0.00350649350649362*G0_0_0_3_2_4 + 0.00389610389610402*G0_0_0_3_2_5 - 0.0015584415584416*G0_0_0_3_3_0 + 0.0268831168831178*G0_0_0_3_3_1 - 0.00467532467532485*G0_0_0_3_3_2 + 0.15428571428572*G0_0_0_3_3_3 - 0.00311688311688319*G0_0_0_3_3_4 - 0.00467532467532476*G0_0_0_3_3_5 + 0.00214285714285721*G0_0_0_3_4_0 + 0.00311688311688322*G0_0_0_3_4_1 + 0.00350649350649362*G0_0_0_3_4_2 - 0.00311688311688319*G0_0_0_3_4_3 - 0.0109090909090912*G0_0_0_3_4_4 - 0.0140259740259745*G0_0_0_3_4_5 + 0.00428571428571442*G0_0_0_3_5_0 + 0.00564935064935086*G0_0_0_3_5_1 + 0.00389610389610402*G0_0_0_3_5_2 - 0.00467532467532476*G0_0_0_3_5_3 - 0.0140259740259745*G0_0_0_3_5_4 - 0.0272727272727281*G0_0_0_3_5_5 - 0.00657467532467557*G0_0_0_4_0_0 + 4.8701298701304e-05*G0_0_0_4_0_1 + 0.000389610389610409*G0_0_0_4_0_2 + 0.00214285714285721*G0_0_0_4_0_3 - 0.00759740259740288*G0_0_0_4_0_4 + 0.001948051948052*G0_0_0_4_0_5 + 4.87012987013039e-05*G0_0_0_4_1_0 - 4.87012987012985e-05*G0_0_0_4_1_1 - 0.00112012987012991*G0_0_0_4_1_2 + 0.00311688311688322*G0_0_0_4_1_3 + 0.00331168831168842*G0_0_0_4_1_4 + 0.00272727272727282*G0_0_0_4_1_5 + 0.000389610389610409*G0_0_0_4_2_0 - 0.00112012987012991*G0_0_0_4_2_1 + 0.000681818181818203*G0_0_0_4_2_2 + 0.00350649350649362*G0_0_0_4_2_3 + 0.00935064935064966*G0_0_0_4_2_4 + 0.00487012987013003*G0_0_0_4_2_5 + 0.00214285714285721*G0_0_0_4_3_0 + 0.00311688311688322*G0_0_0_4_3_1 + 0.00350649350649362*G0_0_0_4_3_2 - 0.00311688311688319*G0_0_0_4_3_3 - 0.0109090909090912*G0_0_0_4_3_4 - 0.0140259740259745*G0_0_0_4_3_5 - 0.00759740259740288*G0_0_0_4_4_0 + 0.00331168831168842*G0_0_0_4_4_1 + 0.00935064935064966*G0_0_0_4_4_2 - 0.0109090909090912*G0_0_0_4_4_3 - 0.0420779220779235*G0_0_0_4_4_4 - 0.0163636363636369*G0_0_0_4_4_5 + 0.001948051948052*G0_0_0_4_5_0 + 0.00272727272727282*G0_0_0_4_5_1 + 0.00487012987013003*G0_0_0_4_5_2 - 0.0140259740259745*G0_0_0_4_5_3 - 0.0163636363636369*G0_0_0_4_5_4 - 0.024155844155845*G0_0_0_4_5_5 - 0.00316558441558454*G0_0_0_5_0_0 - 0.0010227272727273*G0_0_0_5_0_2 + 0.00428571428571442*G0_0_0_5_0_3 + 0.001948051948052*G0_0_0_5_0_4 + 0.00759740259740283*G0_0_0_5_0_5 + 0.00243506493506504*G0_0_0_5_1_1 - 0.00131493506493511*G0_0_0_5_1_2 + 0.00564935064935086*G0_0_0_5_1_3 + 0.00272727272727282*G0_0_0_5_1_4 + 0.00175324675324681*G0_0_0_5_1_5 - 0.0010227272727273*G0_0_0_5_2_0 - 0.00131493506493511*G0_0_0_5_2_1 - 0.00131493506493511*G0_0_0_5_2_2 + 0.00389610389610402*G0_0_0_5_2_3 + 0.00487012987013003*G0_0_0_5_2_4 + 0.00935064935064966*G0_0_0_5_2_5 + 0.00428571428571442*G0_0_0_5_3_0 + 0.00564935064935086*G0_0_0_5_3_1 + 0.00389610389610402*G0_0_0_5_3_2 - 0.00467532467532476*G0_0_0_5_3_3 - 0.0140259740259745*G0_0_0_5_3_4 - 0.0272727272727281*G0_0_0_5_3_5 + 0.001948051948052*G0_0_0_5_4_0 + 0.00272727272727282*G0_0_0_5_4_1 + 0.00487012987013003*G0_0_0_5_4_2 - 0.0140259740259745*G0_0_0_5_4_3 - 0.0163636363636369*G0_0_0_5_4_4 - 0.024155844155845*G0_0_0_5_4_5 + 0.00759740259740283*G0_0_0_5_5_0 + 0.00175324675324681*G0_0_0_5_5_1 + 0.00935064935064966*G0_0_0_5_5_2 - 0.0272727272727281*G0_0_0_5_5_3 - 0.024155844155845*G0_0_0_5_5_4 - 0.0701298701298725*G0_0_0_5_5_5 - 0.00566152597402608*G0_0_1_0_0_0 + 0.000523538961038974*G0_0_1_0_0_1 + 0.0006818181818182*G0_0_1_0_0_2 - 0.000535714285714301*G0_0_1_0_0_3 - 0.002435064935065*G0_0_1_0_0_4 - 0.00462662337662351*G0_0_1_0_0_5 + 0.000523538961038974*G0_0_1_0_1_0 - 0.00410308441558455*G0_0_1_0_1_1 + 0.000280032467532478*G0_0_1_0_1_2 - 0.00175324675324681*G0_0_1_0_1_3 + 0.000438311688311701*G0_0_1_0_1_4 + 0.0018019480519481*G0_0_1_0_1_5 + 0.0006818181818182*G0_0_1_0_2_0 + 0.000280032467532478*G0_0_1_0_2_1 - 7.30519480519499e-05*G0_0_1_0_2_2 + 9.74025974026008e-05*G0_0_1_0_2_3 + 0.0001461038961039*G0_0_1_0_2_4 - 0.000730519480519505*G0_0_1_0_2_5 - 0.000535714285714301*G0_0_1_0_3_0 - 0.00175324675324681*G0_0_1_0_3_1 + 9.74025974026008e-05*G0_0_1_0_3_2 - 0.00214285714285721*G0_0_1_0_3_3 + 0.000194805194805204*G0_0_1_0_3_4 + 0.00253246753246761*G0_0_1_0_3_5 - 0.002435064935065*G0_0_1_0_4_0 + 0.000438311688311701*G0_0_1_0_4_1 + 0.0001461038961039*G0_0_1_0_4_2 + 0.000194805194805204*G0_0_1_0_4_3 - 0.00214285714285721*G0_0_1_0_4_4 + 0.000584415584415608*G0_0_1_0_4_5 - 0.00462662337662351*G0_0_1_0_5_0 + 0.0018019480519481*G0_0_1_0_5_1 - 0.000730519480519505*G0_0_1_0_5_2 + 0.00253246753246761*G0_0_1_0_5_3 + 0.000584415584415608*G0_0_1_0_5_4 + 0.0116883116883121*G0_0_1_0_5_5 + 0.000523538961038974*G0_0_1_1_0_0 - 0.00410308441558455*G0_0_1_1_0_1 + 0.000280032467532478*G0_0_1_1_0_2 - 0.00175324675324681*G0_0_1_1_0_3 + 0.000438311688311701*G0_0_1_1_0_4 + 0.0018019480519481*G0_0_1_1_0_5 - 0.00410308441558455*G0_0_1_1_1_0 + 0.111404220779225*G0_0_1_1_1_1 - 0.00848620129870159*G0_0_1_1_1_2 + 0.0389610389610403*G0_0_1_1_1_3 + 0.0012662337662338*G0_0_1_1_1_4 + 0.0136363636363642*G0_0_1_1_1_5 + 0.000280032467532478*G0_0_1_1_2_0 - 0.00848620129870159*G0_0_1_1_2_1 + 0.00137581168831174*G0_0_1_1_2_2 - 0.00676948051948075*G0_0_1_1_2_3 - 0.000292207792207802*G0_0_1_1_2_4 - 0.000974025974026016*G0_0_1_1_2_5 - 0.00175324675324681*G0_0_1_1_3_0 + 0.0389610389610403*G0_0_1_1_3_1 - 0.00676948051948075*G0_0_1_1_3_2 + 0.0354545454545467*G0_0_1_1_3_3 + 0.00097402597402601*G0_0_1_1_3_4 + 0.00545454545454568*G0_0_1_1_3_5 + 0.000438311688311701*G0_0_1_1_4_0 + 0.0012662337662338*G0_0_1_1_4_1 - 0.000292207792207802*G0_0_1_1_4_2 + 0.00097402597402601*G0_0_1_1_4_3 - 0.000194805194805199*G0_0_1_1_4_4 - 0.000584415584415601*G0_0_1_1_4_5 + 0.0018019480519481*G0_0_1_1_5_0 + 0.0136363636363642*G0_0_1_1_5_1 - 0.000974025974026016*G0_0_1_1_5_2 + 0.00545454545454568*G0_0_1_1_5_3 - 0.000584415584415601*G0_0_1_1_5_4 - 0.0112987012987017*G0_0_1_1_5_5 + 0.0006818181818182*G0_0_1_2_0_0 + 0.000280032467532478*G0_0_1_2_0_1 - 7.30519480519499e-05*G0_0_1_2_0_2 + 9.74025974026007e-05*G0_0_1_2_0_3 + 0.0001461038961039*G0_0_1_2_0_4 - 0.000730519480519505*G0_0_1_2_0_5 + 0.000280032467532478*G0_0_1_2_1_0 - 0.00848620129870159*G0_0_1_2_1_1 + 0.00137581168831174*G0_0_1_2_1_2 - 0.00676948051948075*G0_0_1_2_1_3 - 0.000292207792207802*G0_0_1_2_1_4 - 0.000974025974026016*G0_0_1_2_1_5 - 7.30519480519499e-05*G0_0_1_2_2_0 + 0.00137581168831174*G0_0_1_2_2_1 - 0.00032873376623378*G0_0_1_2_2_2 + 0.00136363636363641*G0_0_1_2_2_3 - 0.000146103896103903*G0_0_1_2_2_4 - 0.000584415584415603*G0_0_1_2_2_5 + 9.74025974026008e-05*G0_0_1_2_3_0 - 0.00676948051948075*G0_0_1_2_3_1 + 0.00136363636363641*G0_0_1_2_3_2 - 0.0105194805194809*G0_0_1_2_3_3 + 0.000389610389610402*G0_0_1_2_3_4 + 0.000974025974026*G0_0_1_2_3_5 + 0.0001461038961039*G0_0_1_2_4_0 - 0.000292207792207802*G0_0_1_2_4_1 - 0.000146103896103903*G0_0_1_2_4_2 + 0.000389610389610402*G0_0_1_2_4_3 + 0.00136363636363641*G0_0_1_2_4_4 + 0.00175324675324681*G0_0_1_2_4_5 - 0.000730519480519505*G0_0_1_2_5_0 - 0.000974025974026016*G0_0_1_2_5_1 - 0.000584415584415603*G0_0_1_2_5_2 + 0.000974025974026*G0_0_1_2_5_3 + 0.00175324675324681*G0_0_1_2_5_4 + 0.00759740259740285*G0_0_1_2_5_5 - 0.000535714285714301*G0_0_1_3_0_0 - 0.00175324675324681*G0_0_1_3_0_1 + 9.74025974026008e-05*G0_0_1_3_0_2 - 0.00214285714285721*G0_0_1_3_0_3 + 0.000194805194805204*G0_0_1_3_0_4 + 0.00253246753246761*G0_0_1_3_0_5 - 0.00175324675324681*G0_0_1_3_1_0 + 0.0389610389610403*G0_0_1_3_1_1 - 0.00676948051948075*G0_0_1_3_1_2 + 0.0354545454545467*G0_0_1_3_1_3 + 0.00097402597402601*G0_0_1_3_1_4 + 0.00545454545454568*G0_0_1_3_1_5 + 9.74025974026009e-05*G0_0_1_3_2_0 - 0.00676948051948075*G0_0_1_3_2_1 + 0.00136363636363641*G0_0_1_3_2_2 - 0.0105194805194809*G0_0_1_3_2_3 + 0.000389610389610402*G0_0_1_3_2_4 + 0.000974025974026*G0_0_1_3_2_5 - 0.00214285714285721*G0_0_1_3_3_0 + 0.0354545454545467*G0_0_1_3_3_1 - 0.0105194805194809*G0_0_1_3_3_2 + 0.0818181818181846*G0_0_1_3_3_3 + 0.00233766233766241*G0_0_1_3_3_4 + 0.00233766233766246*G0_0_1_3_3_5 + 0.000194805194805204*G0_0_1_3_4_0 + 0.00097402597402601*G0_0_1_3_4_1 + 0.000389610389610402*G0_0_1_3_4_2 + 0.00233766233766241*G0_0_1_3_4_3 - 0.00389610389610403*G0_0_1_3_4_5 + 0.00253246753246761*G0_0_1_3_5_0 + 0.00545454545454568*G0_0_1_3_5_1 + 0.000974025974026*G0_0_1_3_5_2 + 0.00233766233766245*G0_0_1_3_5_3 - 0.00389610389610403*G0_0_1_3_5_4 - 0.0202597402597409*G0_0_1_3_5_5 - 0.002435064935065*G0_0_1_4_0_0 + 0.000438311688311701*G0_0_1_4_0_1 + 0.0001461038961039*G0_0_1_4_0_2 + 0.000194805194805204*G0_0_1_4_0_3 - 0.00214285714285721*G0_0_1_4_0_4 + 0.000584415584415608*G0_0_1_4_0_5 + 0.000438311688311701*G0_0_1_4_1_0 + 0.0012662337662338*G0_0_1_4_1_1 - 0.000292207792207802*G0_0_1_4_1_2 + 0.00097402597402601*G0_0_1_4_1_3 - 0.000194805194805199*G0_0_1_4_1_4 - 0.000584415584415601*G0_0_1_4_1_5 + 0.0001461038961039*G0_0_1_4_2_0 - 0.000292207792207802*G0_0_1_4_2_1 - 0.000146103896103903*G0_0_1_4_2_2 + 0.000389610389610402*G0_0_1_4_2_3 + 0.00136363636363641*G0_0_1_4_2_4 + 0.00175324675324681*G0_0_1_4_2_5 + 0.000194805194805204*G0_0_1_4_3_0 + 0.00097402597402601*G0_0_1_4_3_1 + 0.000389610389610402*G0_0_1_4_3_2 + 0.00233766233766241*G0_0_1_4_3_3 - 0.00389610389610403*G0_0_1_4_3_5 - 0.00214285714285721*G0_0_1_4_4_0 - 0.000194805194805199*G0_0_1_4_4_1 + 0.00136363636363641*G0_0_1_4_4_2 - 0.00233766233766243*G0_0_1_4_4_4 - 0.00311688311688323*G0_0_1_4_4_5 + 0.000584415584415608*G0_0_1_4_5_0 - 0.000584415584415601*G0_0_1_4_5_1 + 0.00175324675324681*G0_0_1_4_5_2 - 0.00389610389610403*G0_0_1_4_5_3 - 0.00311688311688323*G0_0_1_4_5_4 - 0.0140259740259745*G0_0_1_4_5_5 - 0.00462662337662351*G0_0_1_5_0_0 + 0.0018019480519481*G0_0_1_5_0_1 - 0.000730519480519505*G0_0_1_5_0_2 + 0.00253246753246761*G0_0_1_5_0_3 + 0.000584415584415608*G0_0_1_5_0_4 + 0.0116883116883121*G0_0_1_5_0_5 + 0.0018019480519481*G0_0_1_5_1_0 + 0.0136363636363642*G0_0_1_5_1_1 - 0.000974025974026016*G0_0_1_5_1_2 + 0.00545454545454568*G0_0_1_5_1_3 - 0.000584415584415601*G0_0_1_5_1_4 - 0.0112987012987017*G0_0_1_5_1_5 - 0.000730519480519505*G0_0_1_5_2_0 - 0.000974025974026016*G0_0_1_5_2_1 - 0.000584415584415603*G0_0_1_5_2_2 + 0.000974025974026*G0_0_1_5_2_3 + 0.00175324675324681*G0_0_1_5_2_4 + 0.00759740259740286*G0_0_1_5_2_5 + 0.00253246753246761*G0_0_1_5_3_0 + 0.00545454545454568*G0_0_1_5_3_1 + 0.000974025974025999*G0_0_1_5_3_2 + 0.00233766233766246*G0_0_1_5_3_3 - 0.00389610389610403*G0_0_1_5_3_4 - 0.0202597402597409*G0_0_1_5_3_5 + 0.000584415584415608*G0_0_1_5_4_0 - 0.000584415584415601*G0_0_1_5_4_1 + 0.00175324675324681*G0_0_1_5_4_2 - 0.00389610389610403*G0_0_1_5_4_3 - 0.00311688311688323*G0_0_1_5_4_4 - 0.0140259740259745*G0_0_1_5_4_5 + 0.0116883116883121*G0_0_1_5_5_0 - 0.0112987012987017*G0_0_1_5_5_1 + 0.00759740259740285*G0_0_1_5_5_2 - 0.0202597402597409*G0_0_1_5_5_3 - 0.0140259740259745*G0_0_1_5_5_4 - 0.121558441558446*G0_0_1_5_5_5 + 0.00109577922077927*G0_1_0_0_0_0 + 0.000121753246753249*G0_1_0_0_0_1 + 4.87012987012977e-05*G0_1_0_0_0_2 - 0.000292207792207801*G0_1_0_0_0_3 + 0.000243506493506507*G0_1_0_0_0_4 - 0.0012175324675325*G0_1_0_0_0_5 + 0.000121753246753249*G0_1_0_0_1_0 - 0.00121753246753251*G0_1_0_0_1_1 + 0.000413961038961052*G0_1_0_0_1_2 - 0.00170454545454551*G0_1_0_0_1_3 - 0.000487012987013003*G0_1_0_0_1_4 - 0.000340909090909103*G0_1_0_0_1_5 + 4.87012987012977e-05*G0_1_0_0_2_0 + 0.000413961038961052*G0_1_0_0_2_1 + 0.000170454545454555*G0_1_0_0_2_2 - 0.000243506493506498*G0_1_0_0_2_3 - 0.000925324675324701*G0_1_0_0_2_4 - 0.00107142857142861*G0_1_0_0_2_5 - 0.000292207792207801*G0_1_0_0_3_0 - 0.00170454545454551*G0_1_0_0_3_1 - 0.000243506493506498*G0_1_0_0_3_2 - 0.00525974025974042*G0_1_0_0_3_3 + 0.00155844155844161*G0_1_0_0_3_4 + 0.00272727272727281*G0_1_0_0_3_5 + 0.000243506493506507*G0_1_0_0_4_0 - 0.000487012987013003*G0_1_0_0_4_1 - 0.000925324675324701*G0_1_0_0_4_2 + 0.00155844155844161*G0_1_0_0_4_3 + 0.00292207792207803*G0_1_0_0_4_4 + 0.00311688311688322*G0_1_0_0_4_5 - 0.0012175324675325*G0_1_0_0_5_0 - 0.000340909090909103*G0_1_0_0_5_1 - 0.0010714285714286*G0_1_0_0_5_2 + 0.00272727272727281*G0_1_0_0_5_3 + 0.00311688311688322*G0_1_0_0_5_4 + 0.00642857142857163*G0_1_0_0_5_5 + 0.000121753246753249*G0_1_0_1_0_0 - 0.00121753246753251*G0_1_0_1_0_1 + 0.000413961038961052*G0_1_0_1_0_2 - 0.00170454545454551*G0_1_0_1_0_3 - 0.000487012987013003*G0_1_0_1_0_4 - 0.000340909090909103*G0_1_0_1_0_5 - 0.00121753246753251*G0_1_0_1_1_0 + 0.0226461038961047*G0_1_0_1_1_1 - 0.00340909090909103*G0_1_0_1_1_2 + 0.0185064935064942*G0_1_0_1_1_3 + 0.000243506493506504*G0_1_0_1_1_4 + 0.00340909090909105*G0_1_0_1_1_5 + 0.000413961038961052*G0_1_0_1_2_0 - 0.00340909090909103*G0_1_0_1_2_1 + 0.00104707792207796*G0_1_0_1_2_2 - 0.00657467532467555*G0_1_0_1_2_3 - 0.000925324675324704*G0_1_0_1_2_4 - 0.00180194805194812*G0_1_0_1_2_5 - 0.00170454545454551*G0_1_0_1_3_0 + 0.0185064935064942*G0_1_0_1_3_1 - 0.00657467532467555*G0_1_0_1_3_2 + 0.0280519480519491*G0_1_0_1_3_3 + 0.00292207792207802*G0_1_0_1_3_4 + 0.00701298701298727*G0_1_0_1_3_5 - 0.000487012987013003*G0_1_0_1_4_0 + 0.000243506493506504*G0_1_0_1_4_1 - 0.000925324675324704*G0_1_0_1_4_2 + 0.00292207792207802*G0_1_0_1_4_3 + 0.00155844155844161*G0_1_0_1_4_4 + 0.00311688311688322*G0_1_0_1_4_5 - 0.000340909090909103*G0_1_0_1_5_0 + 0.00340909090909105*G0_1_0_1_5_1 - 0.00180194805194812*G0_1_0_1_5_2 + 0.00701298701298727*G0_1_0_1_5_3 + 0.00311688311688322*G0_1_0_1_5_4 + 0.00467532467532483*G0_1_0_1_5_5 + 4.87012987012977e-05*G0_1_0_2_0_0 + 0.000413961038961052*G0_1_0_2_0_1 + 0.000170454545454555*G0_1_0_2_0_2 - 0.000243506493506498*G0_1_0_2_0_3 - 0.000925324675324701*G0_1_0_2_0_4 - 0.0010714285714286*G0_1_0_2_0_5 + 0.000413961038961052*G0_1_0_2_1_0 - 0.00340909090909103*G0_1_0_2_1_1 + 0.00104707792207796*G0_1_0_2_1_2 - 0.00657467532467555*G0_1_0_2_1_3 - 0.000925324675324704*G0_1_0_2_1_4 - 0.00180194805194812*G0_1_0_2_1_5 + 0.000170454545454555*G0_1_0_2_2_0 + 0.00104707792207796*G0_1_0_2_2_1 - 0.00146103896103906*G0_1_0_2_2_2 + 0.00214285714285721*G0_1_0_2_2_3 - 0.000681818181818222*G0_1_0_2_2_4 - 0.00121753246753251*G0_1_0_2_2_5 - 0.000243506493506498*G0_1_0_2_3_0 - 0.00657467532467555*G0_1_0_2_3_1 + 0.00214285714285721*G0_1_0_2_3_2 - 0.00701298701298729*G0_1_0_2_3_3 + 0.00233766233766241*G0_1_0_2_3_4 + 0.00292207792207801*G0_1_0_2_3_5 - 0.000925324675324701*G0_1_0_2_4_0 - 0.000925324675324704*G0_1_0_2_4_1 - 0.000681818181818222*G0_1_0_2_4_2 + 0.00233766233766241*G0_1_0_2_4_3 + 0.00233766233766239*G0_1_0_2_4_4 + 0.00428571428571442*G0_1_0_2_4_5 - 0.0010714285714286*G0_1_0_2_5_0 - 0.00180194805194812*G0_1_0_2_5_1 - 0.00121753246753251*G0_1_0_2_5_2 + 0.00292207792207801*G0_1_0_2_5_3 + 0.00428571428571442*G0_1_0_2_5_4 + 0.00974025974026006*G0_1_0_2_5_5 - 0.000292207792207801*G0_1_0_3_0_0 - 0.00170454545454551*G0_1_0_3_0_1 - 0.000243506493506498*G0_1_0_3_0_2 - 0.00525974025974042*G0_1_0_3_0_3 + 0.00155844155844161*G0_1_0_3_0_4 + 0.00272727272727281*G0_1_0_3_0_5 - 0.00170454545454551*G0_1_0_3_1_0 + 0.0185064935064942*G0_1_0_3_1_1 - 0.00657467532467555*G0_1_0_3_1_2 + 0.0280519480519491*G0_1_0_3_1_3 + 0.00292207792207802*G0_1_0_3_1_4 + 0.00701298701298727*G0_1_0_3_1_5 - 0.000243506493506498*G0_1_0_3_2_0 - 0.00657467532467555*G0_1_0_3_2_1 + 0.00214285714285721*G0_1_0_3_2_2 - 0.00701298701298729*G0_1_0_3_2_3 + 0.00233766233766241*G0_1_0_3_2_4 + 0.00292207792207801*G0_1_0_3_2_5 - 0.00525974025974042*G0_1_0_3_3_0 + 0.0280519480519491*G0_1_0_3_3_1 - 0.00701298701298729*G0_1_0_3_3_2 + 0.187012987012994*G0_1_0_3_3_3 + 0.00467532467532485*G0_1_0_3_3_4 + 0.00467532467532491*G0_1_0_3_3_5 + 0.00155844155844161*G0_1_0_3_4_0 + 0.00292207792207802*G0_1_0_3_4_1 + 0.00233766233766241*G0_1_0_3_4_2 + 0.00467532467532485*G0_1_0_3_4_3 - 0.00623376623376643*G0_1_0_3_4_4 - 0.0116883116883121*G0_1_0_3_4_5 + 0.00272727272727281*G0_1_0_3_5_0 + 0.00701298701298727*G0_1_0_3_5_1 + 0.00292207792207801*G0_1_0_3_5_2 + 0.00467532467532491*G0_1_0_3_5_3 - 0.0116883116883121*G0_1_0_3_5_4 - 0.0249350649350657*G0_1_0_3_5_5 + 0.000243506493506507*G0_1_0_4_0_0 - 0.000487012987013003*G0_1_0_4_0_1 - 0.000925324675324701*G0_1_0_4_0_2 + 0.00155844155844161*G0_1_0_4_0_3 + 0.00292207792207803*G0_1_0_4_0_4 + 0.00311688311688322*G0_1_0_4_0_5 - 0.000487012987013003*G0_1_0_4_1_0 + 0.000243506493506503*G0_1_0_4_1_1 - 0.000925324675324704*G0_1_0_4_1_2 + 0.00292207792207802*G0_1_0_4_1_3 + 0.00155844155844161*G0_1_0_4_1_4 + 0.00311688311688322*G0_1_0_4_1_5 - 0.000925324675324701*G0_1_0_4_2_0 - 0.000925324675324704*G0_1_0_4_2_1 - 0.000681818181818223*G0_1_0_4_2_2 + 0.00233766233766241*G0_1_0_4_2_3 + 0.00233766233766239*G0_1_0_4_2_4 + 0.00428571428571442*G0_1_0_4_2_5 + 0.00155844155844161*G0_1_0_4_3_0 + 0.00292207792207802*G0_1_0_4_3_1 + 0.00233766233766241*G0_1_0_4_3_2 + 0.00467532467532485*G0_1_0_4_3_3 - 0.00623376623376643*G0_1_0_4_3_4 - 0.0116883116883121*G0_1_0_4_3_5 + 0.00292207792207803*G0_1_0_4_4_0 + 0.00155844155844161*G0_1_0_4_4_1 + 0.00233766233766239*G0_1_0_4_4_2 - 0.00623376623376643*G0_1_0_4_4_3 + 0.00467532467532478*G0_1_0_4_4_4 - 0.0116883116883121*G0_1_0_4_4_5 + 0.00311688311688322*G0_1_0_4_5_0 + 0.00311688311688322*G0_1_0_4_5_1 + 0.00428571428571442*G0_1_0_4_5_2 - 0.0116883116883121*G0_1_0_4_5_3 - 0.0116883116883121*G0_1_0_4_5_4 - 0.0257142857142866*G0_1_0_4_5_5 - 0.0012175324675325*G0_1_0_5_0_0 - 0.000340909090909103*G0_1_0_5_0_1 - 0.00107142857142861*G0_1_0_5_0_2 + 0.00272727272727281*G0_1_0_5_0_3 + 0.00311688311688322*G0_1_0_5_0_4 + 0.00642857142857163*G0_1_0_5_0_5 - 0.000340909090909103*G0_1_0_5_1_0 + 0.00340909090909105*G0_1_0_5_1_1 - 0.00180194805194812*G0_1_0_5_1_2 + 0.00701298701298727*G0_1_0_5_1_3 + 0.00311688311688322*G0_1_0_5_1_4 + 0.00467532467532483*G0_1_0_5_1_5 - 0.00107142857142861*G0_1_0_5_2_0 - 0.00180194805194812*G0_1_0_5_2_1 - 0.00121753246753251*G0_1_0_5_2_2 + 0.00292207792207801*G0_1_0_5_2_3 + 0.00428571428571442*G0_1_0_5_2_4 + 0.00974025974026006*G0_1_0_5_2_5 + 0.00272727272727281*G0_1_0_5_3_0 + 0.00701298701298727*G0_1_0_5_3_1 + 0.00292207792207801*G0_1_0_5_3_2 + 0.00467532467532491*G0_1_0_5_3_3 - 0.0116883116883121*G0_1_0_5_3_4 - 0.0249350649350657*G0_1_0_5_3_5 + 0.00311688311688322*G0_1_0_5_4_0 + 0.00311688311688322*G0_1_0_5_4_1 + 0.00428571428571442*G0_1_0_5_4_2 - 0.0116883116883121*G0_1_0_5_4_3 - 0.0116883116883121*G0_1_0_5_4_4 - 0.0257142857142866*G0_1_0_5_4_5 + 0.00642857142857163*G0_1_0_5_5_0 + 0.00467532467532483*G0_1_0_5_5_1 + 0.00974025974026006*G0_1_0_5_5_2 - 0.0249350649350657*G0_1_0_5_5_3 - 0.0257142857142866*G0_1_0_5_5_4 - 0.0794805194805222*G0_1_0_5_5_5 + 0.00273944805194813*G0_1_1_0_0_0 - 0.000365259740259749*G0_1_1_0_0_1 - 0.000206980519480525*G0_1_1_0_0_2 + 0.0001461038961039*G0_1_1_0_0_3 + 0.000974025974026001*G0_1_1_0_0_4 + 0.000730519480519493*G0_1_1_0_0_5 - 0.000365259740259749*G0_1_1_0_1_0 - 0.00499188311688328*G0_1_1_0_1_1 + 0.000584415584415604*G0_1_1_0_1_2 - 0.00253246753246762*G0_1_1_0_1_3 - 0.000340909090909102*G0_1_1_0_1_4 - 0.000389610389610403*G0_1_1_0_1_5 - 0.000206980519480525*G0_1_1_0_2_0 + 0.000584415584415604*G0_1_1_0_2_1 + 8.52272727272753e-05*G0_1_1_0_2_2 + 0.000340909090909103*G0_1_1_0_2_3 - 0.000487012987013002*G0_1_1_0_2_4 - 0.0011201298701299*G0_1_1_0_2_5 + 0.0001461038961039*G0_1_1_0_3_0 - 0.00253246753246762*G0_1_1_0_3_1 + 0.000340909090909103*G0_1_1_0_3_2 - 0.00350649350649362*G0_1_1_0_3_3 + 0.000389610389610403*G0_1_1_0_3_4 + 0.00194805194805201*G0_1_1_0_3_5 + 0.000974025974026001*G0_1_1_0_4_0 - 0.000340909090909102*G0_1_1_0_4_1 - 0.000487012987013002*G0_1_1_0_4_2 + 0.000389610389610403*G0_1_1_0_4_3 + 0.00136363636363641*G0_1_1_0_4_4 + 0.00292207792207801*G0_1_1_0_4_5 + 0.000730519480519493*G0_1_1_0_5_0 - 0.000389610389610403*G0_1_1_0_5_1 - 0.0011201298701299*G0_1_1_0_5_2 + 0.00194805194805201*G0_1_1_0_5_3 + 0.00292207792207801*G0_1_1_0_5_4 + 0.0151948051948057*G0_1_1_0_5_5 - 0.000365259740259749*G0_1_1_1_0_0 - 0.00499188311688328*G0_1_1_1_0_1 + 0.000584415584415604*G0_1_1_1_0_2 - 0.00253246753246762*G0_1_1_1_0_3 - 0.000340909090909102*G0_1_1_1_0_4 - 0.000389610389610403*G0_1_1_1_0_5 - 0.00499188311688328*G0_1_1_1_1_0 + 0.119805194805199*G0_1_1_1_1_1 - 0.00937500000000032*G0_1_1_1_1_2 + 0.0423701298701313*G0_1_1_1_1_3 + 0.001948051948052*G0_1_1_1_1_4 + 0.0189935064935072*G0_1_1_1_1_5 + 0.000584415584415604*G0_1_1_1_2_0 - 0.00937500000000032*G0_1_1_1_2_1 + 0.00153409090909096*G0_1_1_1_2_2 - 0.00740259740259766*G0_1_1_1_2_3 - 4.87012987013017e-05*G0_1_1_1_2_4 - 0.00136363636363642*G0_1_1_1_2_5 - 0.00253246753246762*G0_1_1_1_3_0 + 0.0423701298701313*G0_1_1_1_3_1 - 0.00740259740259766*G0_1_1_1_3_2 + 0.0389610389610403*G0_1_1_1_3_3 + 0.00116883116883121*G0_1_1_1_3_4 + 0.0077922077922081*G0_1_1_1_3_5 - 0.000340909090909102*G0_1_1_1_4_0 + 0.001948051948052*G0_1_1_1_4_1 - 4.87012987013016e-05*G0_1_1_1_4_2 + 0.00116883116883121*G0_1_1_1_4_3 - 0.00155844155844161*G0_1_1_1_4_4 - 0.0011688311688312*G0_1_1_1_4_5 - 0.000389610389610403*G0_1_1_1_5_0 + 0.0189935064935072*G0_1_1_1_5_1 - 0.00136363636363642*G0_1_1_1_5_2 + 0.0077922077922081*G0_1_1_1_5_3 - 0.0011688311688312*G0_1_1_1_5_4 - 0.00779220779220803*G0_1_1_1_5_5 - 0.000206980519480525*G0_1_1_2_0_0 + 0.000584415584415604*G0_1_1_2_0_1 + 8.52272727272752e-05*G0_1_1_2_0_2 + 0.000340909090909103*G0_1_1_2_0_3 - 0.000487012987013002*G0_1_1_2_0_4 - 0.0011201298701299*G0_1_1_2_0_5 + 0.000584415584415604*G0_1_1_2_1_0 - 0.00937500000000032*G0_1_1_2_1_1 + 0.00153409090909096*G0_1_1_2_1_2 - 0.00740259740259766*G0_1_1_2_1_3 - 4.87012987013017e-05*G0_1_1_2_1_4 - 0.00136363636363642*G0_1_1_2_1_5 + 8.52272727272752e-05*G0_1_1_2_2_0 + 0.00153409090909096*G0_1_1_2_2_1 - 0.000767045454545481*G0_1_1_2_2_2 + 0.00160714285714291*G0_1_1_2_2_3 + 9.74025974025993e-05*G0_1_1_2_2_4 - 0.000146103896103901*G0_1_1_2_2_5 + 0.000340909090909103*G0_1_1_2_3_0 - 0.00740259740259766*G0_1_1_2_3_1 + 0.00160714285714291*G0_1_1_2_3_2 - 0.0128571428571433*G0_1_1_2_3_3 - 0.000584415584415603*G0_1_1_2_3_4 - 0.000389610389610411*G0_1_1_2_3_5 - 0.000487012987013002*G0_1_1_2_4_0 - 4.87012987013016e-05*G0_1_1_2_4_1 + 9.74025974025993e-05*G0_1_1_2_4_2 - 0.000584415584415604*G0_1_1_2_4_3 - 0.000974025974026004*G0_1_1_2_4_4 + 0.000389610389610407*G0_1_1_2_4_5 - 0.0011201298701299*G0_1_1_2_5_0 - 0.00136363636363642*G0_1_1_2_5_1 - 0.000146103896103901*G0_1_1_2_5_2 - 0.00038961038961041*G0_1_1_2_5_3 + 0.000389610389610407*G0_1_1_2_5_4 + 0.00584415584415605*G0_1_1_2_5_5 + 0.0001461038961039*G0_1_1_3_0_0 - 0.00253246753246762*G0_1_1_3_0_1 + 0.000340909090909103*G0_1_1_3_0_2 - 0.00350649350649362*G0_1_1_3_0_3 + 0.000389610389610403*G0_1_1_3_0_4 + 0.00194805194805201*G0_1_1_3_0_5 - 0.00253246753246762*G0_1_1_3_1_0 + 0.0423701298701313*G0_1_1_3_1_1 - 0.00740259740259766*G0_1_1_3_1_2 + 0.0389610389610403*G0_1_1_3_1_3 + 0.00116883116883121*G0_1_1_3_1_4 + 0.0077922077922081*G0_1_1_3_1_5 + 0.000340909090909103*G0_1_1_3_2_0 - 0.00740259740259766*G0_1_1_3_2_1 + 0.00160714285714291*G0_1_1_3_2_2 - 0.0128571428571433*G0_1_1_3_2_3 - 0.000584415584415604*G0_1_1_3_2_4 - 0.000389610389610411*G0_1_1_3_2_5 - 0.00350649350649362*G0_1_1_3_3_0 + 0.0389610389610403*G0_1_1_3_3_1 - 0.0128571428571433*G0_1_1_3_3_2 + 0.0935064935064968*G0_1_1_3_3_3 + 0.00467532467532483*G0_1_1_3_3_4 + 0.0077922077922081*G0_1_1_3_3_5 + 0.000389610389610403*G0_1_1_3_4_0 + 0.00116883116883121*G0_1_1_3_4_1 - 0.000584415584415604*G0_1_1_3_4_2 + 0.00467532467532483*G0_1_1_3_4_3 + 0.0023376623376624*G0_1_1_3_4_4 - 0.00155844155844162*G0_1_1_3_4_5 + 0.00194805194805201*G0_1_1_3_5_0 + 0.0077922077922081*G0_1_1_3_5_1 - 0.000389610389610411*G0_1_1_3_5_2 + 0.0077922077922081*G0_1_1_3_5_3 - 0.00155844155844162*G0_1_1_3_5_4 - 0.0155844155844161*G0_1_1_3_5_5 + 0.000974025974026001*G0_1_1_4_0_0 - 0.000340909090909102*G0_1_1_4_0_1 - 0.000487012987013002*G0_1_1_4_0_2 + 0.000389610389610403*G0_1_1_4_0_3 + 0.00136363636363641*G0_1_1_4_0_4 + 0.00292207792207801*G0_1_1_4_0_5 - 0.000340909090909102*G0_1_1_4_1_0 + 0.001948051948052*G0_1_1_4_1_1 - 4.87012987013017e-05*G0_1_1_4_1_2 + 0.00116883116883121*G0_1_1_4_1_3 - 0.00155844155844161*G0_1_1_4_1_4 - 0.0011688311688312*G0_1_1_4_1_5 - 0.000487012987013002*G0_1_1_4_2_0 - 4.87012987013016e-05*G0_1_1_4_2_1 + 9.74025974025992e-05*G0_1_1_4_2_2 - 0.000584415584415603*G0_1_1_4_2_3 - 0.000974025974026004*G0_1_1_4_2_4 + 0.000389610389610407*G0_1_1_4_2_5 + 0.000389610389610403*G0_1_1_4_3_0 + 0.00116883116883121*G0_1_1_4_3_1 - 0.000584415584415603*G0_1_1_4_3_2 + 0.00467532467532483*G0_1_1_4_3_3 + 0.0023376623376624*G0_1_1_4_3_4 - 0.00155844155844162*G0_1_1_4_3_5 + 0.00136363636363641*G0_1_1_4_4_0 - 0.00155844155844161*G0_1_1_4_4_1 - 0.000974025974026004*G0_1_1_4_4_2 + 0.0023376623376624*G0_1_1_4_4_3 + 0.00935064935064963*G0_1_1_4_4_4 + 0.0023376623376624*G0_1_1_4_4_5 + 0.00292207792207801*G0_1_1_4_5_0 - 0.0011688311688312*G0_1_1_4_5_1 + 0.000389610389610407*G0_1_1_4_5_2 - 0.00155844155844162*G0_1_1_4_5_3 + 0.0023376623376624*G0_1_1_4_5_4 - 0.0093506493506497*G0_1_1_4_5_5 + 0.000730519480519493*G0_1_1_5_0_0 - 0.000389610389610403*G0_1_1_5_0_1 - 0.0011201298701299*G0_1_1_5_0_2 + 0.00194805194805201*G0_1_1_5_0_3 + 0.00292207792207801*G0_1_1_5_0_4 + 0.0151948051948057*G0_1_1_5_0_5 - 0.000389610389610403*G0_1_1_5_1_0 + 0.0189935064935072*G0_1_1_5_1_1 - 0.00136363636363642*G0_1_1_5_1_2 + 0.0077922077922081*G0_1_1_5_1_3 - 0.0011688311688312*G0_1_1_5_1_4 - 0.00779220779220803*G0_1_1_5_1_5 - 0.0011201298701299*G0_1_1_5_2_0 - 0.00136363636363642*G0_1_1_5_2_1 - 0.000146103896103901*G0_1_1_5_2_2 - 0.000389610389610411*G0_1_1_5_2_3 + 0.000389610389610407*G0_1_1_5_2_4 + 0.00584415584415605*G0_1_1_5_2_5 + 0.00194805194805201*G0_1_1_5_3_0 + 0.0077922077922081*G0_1_1_5_3_1 - 0.000389610389610411*G0_1_1_5_3_2 + 0.0077922077922081*G0_1_1_5_3_3 - 0.00155844155844162*G0_1_1_5_3_4 - 0.0155844155844161*G0_1_1_5_3_5 + 0.00292207792207801*G0_1_1_5_4_0 - 0.0011688311688312*G0_1_1_5_4_1 + 0.000389610389610407*G0_1_1_5_4_2 - 0.00155844155844162*G0_1_1_5_4_3 + 0.0023376623376624*G0_1_1_5_4_4 - 0.0093506493506497*G0_1_1_5_4_5 + 0.0151948051948057*G0_1_1_5_5_0 - 0.00779220779220803*G0_1_1_5_5_1 + 0.00584415584415605*G0_1_1_5_5_2 - 0.0155844155844161*G0_1_1_5_5_3 - 0.0093506493506497*G0_1_1_5_5_4 - 0.116883116883121*G0_1_1_5_5_5;
    A[69] = 0.00350649350649364*G0_0_0_0_0_0 - 0.000292207792207803*G0_0_0_0_0_1 - 0.00189935064935071*G0_0_0_0_0_2 + 0.000292207792207798*G0_0_0_0_0_3 - 0.000876623376623396*G0_0_0_0_0_4 + 0.000876623376623412*G0_0_0_0_0_5 - 0.000292207792207803*G0_0_0_0_1_0 + 0.000292207792207804*G0_0_0_0_1_1 + 0.001461038961039*G0_0_0_0_1_3 - 0.00146103896103901*G0_0_0_0_1_4 - 0.00189935064935071*G0_0_0_0_2_0 + 0.00438311688311703*G0_0_0_0_2_2 - 0.0011688311688312*G0_0_0_0_2_3 + 0.00701298701298724*G0_0_0_0_2_4 - 0.000292207792207802*G0_0_0_0_2_5 + 0.000292207792207798*G0_0_0_0_3_0 + 0.001461038961039*G0_0_0_0_3_1 - 0.0011688311688312*G0_0_0_0_3_2 - 0.00935064935064963*G0_0_0_0_3_3 + 0.00233766233766242*G0_0_0_0_3_4 - 0.000876623376623396*G0_0_0_0_4_0 - 0.00146103896103901*G0_0_0_0_4_1 + 0.00701298701298724*G0_0_0_0_4_2 + 0.00233766233766242*G0_0_0_0_4_3 + 0.0280519480519489*G0_0_0_0_4_4 + 0.00350649350649363*G0_0_0_0_4_5 + 0.000876623376623412*G0_0_0_0_5_0 - 0.000292207792207802*G0_0_0_0_5_2 + 0.00350649350649363*G0_0_0_0_5_4 + 0.00233766233766242*G0_0_0_0_5_5 - 0.000292207792207803*G0_0_0_1_0_0 + 0.000292207792207804*G0_0_0_1_0_1 + 0.001461038961039*G0_0_0_1_0_3 - 0.00146103896103901*G0_0_0_1_0_4 + 0.000292207792207804*G0_0_0_1_1_0 - 0.00350649350649363*G0_0_0_1_1_1 + 0.00189935064935071*G0_0_0_1_1_2 + 0.000876623376623404*G0_0_0_1_1_3 - 0.000292207792207802*G0_0_0_1_1_4 - 0.000876623376623412*G0_0_0_1_1_5 + 0.00189935064935071*G0_0_0_1_2_1 - 0.00438311688311703*G0_0_0_1_2_2 - 0.00701298701298725*G0_0_0_1_2_3 + 0.00116883116883121*G0_0_0_1_2_4 + 0.000292207792207802*G0_0_0_1_2_5 + 0.001461038961039*G0_0_0_1_3_0 + 0.000876623376623404*G0_0_0_1_3_1 - 0.00701298701298725*G0_0_0_1_3_2 - 0.028051948051949*G0_0_0_1_3_3 - 0.00233766233766241*G0_0_0_1_3_4 - 0.00350649350649363*G0_0_0_1_3_5 - 0.00146103896103901*G0_0_0_1_4_0 - 0.000292207792207802*G0_0_0_1_4_1 + 0.00116883116883121*G0_0_0_1_4_2 - 0.00233766233766241*G0_0_0_1_4_3 + 0.00935064935064965*G0_0_0_1_4_4 - 0.000876623376623412*G0_0_0_1_5_1 + 0.000292207792207802*G0_0_0_1_5_2 - 0.00350649350649363*G0_0_0_1_5_3 - 0.00233766233766242*G0_0_0_1_5_5 - 0.00189935064935071*G0_0_0_2_0_0 + 0.00438311688311703*G0_0_0_2_0_2 - 0.0011688311688312*G0_0_0_2_0_3 + 0.00701298701298724*G0_0_0_2_0_4 - 0.000292207792207802*G0_0_0_2_0_5 + 0.00189935064935071*G0_0_0_2_1_1 - 0.00438311688311703*G0_0_0_2_1_2 - 0.00701298701298725*G0_0_0_2_1_3 + 0.00116883116883121*G0_0_0_2_1_4 + 0.000292207792207802*G0_0_0_2_1_5 + 0.00438311688311703*G0_0_0_2_2_0 - 0.00438311688311703*G0_0_0_2_2_1 + 0.0233766233766242*G0_0_0_2_2_3 - 0.0233766233766242*G0_0_0_2_2_4 - 0.0011688311688312*G0_0_0_2_3_0 - 0.00701298701298725*G0_0_0_2_3_1 + 0.0233766233766242*G0_0_0_2_3_2 + 0.0467532467532483*G0_0_0_2_3_3 + 0.00233766233766242*G0_0_0_2_3_5 + 0.00701298701298724*G0_0_0_2_4_0 + 0.00116883116883121*G0_0_0_2_4_1 - 0.0233766233766242*G0_0_0_2_4_2 - 0.0467532467532483*G0_0_0_2_4_4 - 0.00233766233766242*G0_0_0_2_4_5 - 0.000292207792207802*G0_0_0_2_5_0 + 0.000292207792207802*G0_0_0_2_5_1 + 0.00233766233766242*G0_0_0_2_5_3 - 0.00233766233766242*G0_0_0_2_5_4 + 0.000292207792207798*G0_0_0_3_0_0 + 0.001461038961039*G0_0_0_3_0_1 - 0.0011688311688312*G0_0_0_3_0_2 - 0.00935064935064963*G0_0_0_3_0_3 + 0.00233766233766242*G0_0_0_3_0_4 + 0.001461038961039*G0_0_0_3_1_0 + 0.000876623376623404*G0_0_0_3_1_1 - 0.00701298701298725*G0_0_0_3_1_2 - 0.028051948051949*G0_0_0_3_1_3 - 0.00233766233766241*G0_0_0_3_1_4 - 0.00350649350649363*G0_0_0_3_1_5 - 0.0011688311688312*G0_0_0_3_2_0 - 0.00701298701298725*G0_0_0_3_2_1 + 0.0233766233766242*G0_0_0_3_2_2 + 0.0467532467532483*G0_0_0_3_2_3 + 0.00233766233766242*G0_0_0_3_2_5 - 0.00935064935064963*G0_0_0_3_3_0 - 0.028051948051949*G0_0_0_3_3_1 + 0.0467532467532483*G0_0_0_3_3_2 + 0.210389610389618*G0_0_0_3_3_3 + 0.0233766233766242*G0_0_0_3_3_4 + 0.0140259740259745*G0_0_0_3_3_5 + 0.00233766233766242*G0_0_0_3_4_0 - 0.00233766233766241*G0_0_0_3_4_1 + 0.0233766233766242*G0_0_0_3_4_3 - 0.0233766233766241*G0_0_0_3_4_4 - 0.00350649350649363*G0_0_0_3_5_1 + 0.00233766233766242*G0_0_0_3_5_2 + 0.0140259740259745*G0_0_0_3_5_3 - 0.000876623376623396*G0_0_0_4_0_0 - 0.00146103896103901*G0_0_0_4_0_1 + 0.00701298701298724*G0_0_0_4_0_2 + 0.00233766233766242*G0_0_0_4_0_3 + 0.028051948051949*G0_0_0_4_0_4 + 0.00350649350649363*G0_0_0_4_0_5 - 0.00146103896103901*G0_0_0_4_1_0 - 0.000292207792207802*G0_0_0_4_1_1 + 0.00116883116883121*G0_0_0_4_1_2 - 0.00233766233766241*G0_0_0_4_1_3 + 0.00935064935064965*G0_0_0_4_1_4 + 0.00701298701298724*G0_0_0_4_2_0 + 0.00116883116883121*G0_0_0_4_2_1 - 0.0233766233766241*G0_0_0_4_2_2 - 0.0467532467532483*G0_0_0_4_2_4 - 0.00233766233766242*G0_0_0_4_2_5 + 0.00233766233766242*G0_0_0_4_3_0 - 0.00233766233766241*G0_0_0_4_3_1 + 0.0233766233766242*G0_0_0_4_3_3 - 0.0233766233766241*G0_0_0_4_3_4 + 0.0280519480519489*G0_0_0_4_4_0 + 0.00935064935064965*G0_0_0_4_4_1 - 0.0467532467532483*G0_0_0_4_4_2 - 0.0233766233766241*G0_0_0_4_4_3 - 0.210389610389617*G0_0_0_4_4_4 - 0.0140259740259745*G0_0_0_4_4_5 + 0.00350649350649363*G0_0_0_4_5_0 - 0.00233766233766242*G0_0_0_4_5_2 - 0.0140259740259745*G0_0_0_4_5_4 + 0.000876623376623412*G0_0_0_5_0_0 - 0.000292207792207802*G0_0_0_5_0_2 + 0.00350649350649363*G0_0_0_5_0_4 + 0.00233766233766242*G0_0_0_5_0_5 - 0.000876623376623412*G0_0_0_5_1_1 + 0.000292207792207802*G0_0_0_5_1_2 - 0.00350649350649363*G0_0_0_5_1_3 - 0.00233766233766242*G0_0_0_5_1_5 - 0.000292207792207802*G0_0_0_5_2_0 + 0.000292207792207802*G0_0_0_5_2_1 + 0.00233766233766242*G0_0_0_5_2_3 - 0.00233766233766242*G0_0_0_5_2_4 - 0.00350649350649363*G0_0_0_5_3_1 + 0.00233766233766242*G0_0_0_5_3_2 + 0.0140259740259745*G0_0_0_5_3_3 + 0.00350649350649363*G0_0_0_5_4_0 - 0.00233766233766242*G0_0_0_5_4_2 - 0.0140259740259745*G0_0_0_5_4_4 + 0.00233766233766242*G0_0_0_5_5_0 - 0.00233766233766242*G0_0_0_5_5_1 + 0.00131493506493514*G0_0_1_0_0_0 - 0.000803571428571458*G0_0_1_0_0_1 + 0.000657467532467552*G0_0_1_0_0_2 + 0.00262987012987021*G0_0_1_0_0_3 + 0.00321428571428583*G0_0_1_0_0_4 + 0.00262987012987024*G0_0_1_0_0_5 - 0.000803571428571458*G0_0_1_0_1_0 - 0.000511363636363654*G0_0_1_0_1_1 + 0.00124188311688316*G0_0_1_0_1_2 + 0.00292207792207801*G0_0_1_0_1_3 + 0.00146103896103901*G0_0_1_0_1_4 - 0.000292207792207814*G0_0_1_0_1_5 + 0.000657467532467552*G0_0_1_0_2_0 + 0.00124188311688316*G0_0_1_0_2_1 - 0.00504058441558459*G0_0_1_0_2_2 - 0.00525974025974043*G0_0_1_0_2_3 - 0.00438311688311703*G0_0_1_0_2_4 - 0.000876623376623409*G0_0_1_0_2_5 + 0.00262987012987021*G0_0_1_0_3_0 + 0.00292207792207801*G0_0_1_0_3_1 - 0.00525974025974043*G0_0_1_0_3_2 - 0.0175324675324681*G0_0_1_0_3_3 - 0.00818181818181845*G0_0_1_0_3_4 - 0.00350649350649362*G0_0_1_0_3_5 + 0.00321428571428583*G0_0_1_0_4_0 + 0.00146103896103901*G0_0_1_0_4_1 - 0.00438311688311703*G0_0_1_0_4_2 - 0.00818181818181845*G0_0_1_0_4_3 - 0.00701298701298725*G0_0_1_0_4_4 - 0.0011688311688312*G0_0_1_0_4_5 + 0.00262987012987024*G0_0_1_0_5_0 - 0.000292207792207814*G0_0_1_0_5_1 - 0.000876623376623409*G0_0_1_0_5_2 - 0.00350649350649362*G0_0_1_0_5_3 - 0.0011688311688312*G0_0_1_0_5_4 - 0.000803571428571458*G0_0_1_1_0_0 - 0.000511363636363654*G0_0_1_1_0_1 + 0.00124188311688316*G0_0_1_1_0_2 + 0.00292207792207801*G0_0_1_1_0_3 + 0.00146103896103901*G0_0_1_1_0_4 - 0.000292207792207814*G0_0_1_1_0_5 - 0.000511363636363654*G0_0_1_1_1_0 - 0.0021915584415585*G0_0_1_1_1_1 + 0.00255681818181827*G0_0_1_1_1_2 + 0.00409090909090924*G0_0_1_1_1_3 + 0.00233766233766242*G0_0_1_1_1_4 + 0.00175324675324683*G0_0_1_1_1_5 + 0.00124188311688316*G0_0_1_1_2_0 + 0.00255681818181827*G0_0_1_1_2_1 - 0.00942370129870163*G0_0_1_1_2_2 - 0.0113961038961043*G0_0_1_1_2_3 - 0.00409090909090923*G0_0_1_1_2_4 - 0.000584415584415607*G0_0_1_1_2_5 + 0.00292207792207801*G0_0_1_1_3_0 + 0.00409090909090924*G0_0_1_1_3_1 - 0.0113961038961043*G0_0_1_1_3_2 - 0.0350649350649362*G0_0_1_1_3_3 - 0.0105194805194809*G0_0_1_1_3_4 - 0.00467532467532483*G0_0_1_1_3_5 + 0.00146103896103901*G0_0_1_1_4_0 + 0.00233766233766242*G0_0_1_1_4_1 - 0.00409090909090923*G0_0_1_1_4_2 - 0.0105194805194809*G0_0_1_1_4_3 - 0.00818181818181846*G0_0_1_1_4_4 - 0.00350649350649363*G0_0_1_1_4_5 - 0.000292207792207814*G0_0_1_1_5_0 + 0.00175324675324683*G0_0_1_1_5_1 - 0.000584415584415607*G0_0_1_1_5_2 - 0.00467532467532483*G0_0_1_1_5_3 - 0.00350649350649363*G0_0_1_1_5_4 - 0.00233766233766241*G0_0_1_1_5_5 + 0.000657467532467552*G0_0_1_2_0_0 + 0.00124188311688316*G0_0_1_2_0_1 - 0.00504058441558459*G0_0_1_2_0_2 - 0.00525974025974043*G0_0_1_2_0_3 - 0.00438311688311703*G0_0_1_2_0_4 - 0.000876623376623409*G0_0_1_2_0_5 + 0.00124188311688316*G0_0_1_2_1_0 + 0.00255681818181827*G0_0_1_2_1_1 - 0.00942370129870163*G0_0_1_2_1_2 - 0.0113961038961043*G0_0_1_2_1_3 - 0.00409090909090923*G0_0_1_2_1_4 - 0.000584415584415607*G0_0_1_2_1_5 - 0.00504058441558459*G0_0_1_2_2_0 - 0.00942370129870163*G0_0_1_2_2_1 + 0.0591720779220801*G0_0_1_2_2_2 + 0.0438311688311704*G0_0_1_2_2_3 + 0.0204545454545462*G0_0_1_2_2_4 + 0.00350649350649364*G0_0_1_2_2_5 - 0.00525974025974043*G0_0_1_2_3_0 - 0.0113961038961043*G0_0_1_2_3_1 + 0.0438311688311704*G0_0_1_2_3_2 + 0.0631168831168853*G0_0_1_2_3_3 + 0.0187012987012993*G0_0_1_2_3_4 + 0.00350649350649364*G0_0_1_2_3_5 - 0.00438311688311703*G0_0_1_2_4_0 - 0.00409090909090923*G0_0_1_2_4_1 + 0.0204545454545462*G0_0_1_2_4_2 + 0.0187012987012994*G0_0_1_2_4_3 + 0.016363636363637*G0_0_1_2_4_4 + 0.00116883116883121*G0_0_1_2_4_5 - 0.000876623376623409*G0_0_1_2_5_0 - 0.000584415584415607*G0_0_1_2_5_1 + 0.00350649350649364*G0_0_1_2_5_2 + 0.00350649350649364*G0_0_1_2_5_3 + 0.00116883116883121*G0_0_1_2_5_4 - 0.00350649350649364*G0_0_1_2_5_5 + 0.00262987012987021*G0_0_1_3_0_0 + 0.00292207792207801*G0_0_1_3_0_1 - 0.00525974025974043*G0_0_1_3_0_2 - 0.0175324675324681*G0_0_1_3_0_3 - 0.00818181818181845*G0_0_1_3_0_4 - 0.00350649350649362*G0_0_1_3_0_5 + 0.00292207792207801*G0_0_1_3_1_0 + 0.00409090909090924*G0_0_1_3_1_1 - 0.0113961038961043*G0_0_1_3_1_2 - 0.0350649350649362*G0_0_1_3_1_3 - 0.0105194805194809*G0_0_1_3_1_4 - 0.00467532467532483*G0_0_1_3_1_5 - 0.00525974025974043*G0_0_1_3_2_0 - 0.0113961038961043*G0_0_1_3_2_1 + 0.0438311688311704*G0_0_1_3_2_2 + 0.0631168831168853*G0_0_1_3_2_3 + 0.0187012987012993*G0_0_1_3_2_4 + 0.00350649350649364*G0_0_1_3_2_5 - 0.0175324675324681*G0_0_1_3_3_0 - 0.0350649350649362*G0_0_1_3_3_1 + 0.0631168831168853*G0_0_1_3_3_2 + 0.252467532467541*G0_0_1_3_3_3 + 0.056103896103898*G0_0_1_3_3_4 + 0.028051948051949*G0_0_1_3_3_5 - 0.00818181818181845*G0_0_1_3_4_0 - 0.0105194805194809*G0_0_1_3_4_1 + 0.0187012987012994*G0_0_1_3_4_2 + 0.056103896103898*G0_0_1_3_4_3 + 0.0327272727272738*G0_0_1_3_4_4 + 0.0140259740259745*G0_0_1_3_4_5 - 0.00350649350649362*G0_0_1_3_5_0 - 0.00467532467532483*G0_0_1_3_5_1 + 0.00350649350649364*G0_0_1_3_5_2 + 0.028051948051949*G0_0_1_3_5_3 + 0.0140259740259745*G0_0_1_3_5_4 + 0.0140259740259745*G0_0_1_3_5_5 + 0.00321428571428583*G0_0_1_4_0_0 + 0.00146103896103901*G0_0_1_4_0_1 - 0.00438311688311703*G0_0_1_4_0_2 - 0.00818181818181845*G0_0_1_4_0_3 - 0.00701298701298725*G0_0_1_4_0_4 - 0.0011688311688312*G0_0_1_4_0_5 + 0.00146103896103901*G0_0_1_4_1_0 + 0.00233766233766242*G0_0_1_4_1_1 - 0.00409090909090923*G0_0_1_4_1_2 - 0.0105194805194809*G0_0_1_4_1_3 - 0.00818181818181846*G0_0_1_4_1_4 - 0.00350649350649363*G0_0_1_4_1_5 - 0.00438311688311703*G0_0_1_4_2_0 - 0.00409090909090923*G0_0_1_4_2_1 + 0.0204545454545462*G0_0_1_4_2_2 + 0.0187012987012993*G0_0_1_4_2_3 + 0.016363636363637*G0_0_1_4_2_4 + 0.00116883116883121*G0_0_1_4_2_5 - 0.00818181818181844*G0_0_1_4_3_0 - 0.0105194805194809*G0_0_1_4_3_1 + 0.0187012987012993*G0_0_1_4_3_2 + 0.056103896103898*G0_0_1_4_3_3 + 0.0327272727272738*G0_0_1_4_3_4 + 0.0140259740259745*G0_0_1_4_3_5 - 0.00701298701298724*G0_0_1_4_4_0 - 0.00818181818181846*G0_0_1_4_4_1 + 0.016363636363637*G0_0_1_4_4_2 + 0.0327272727272738*G0_0_1_4_4_3 + 0.0420779220779236*G0_0_1_4_4_4 + 0.0140259740259745*G0_0_1_4_4_5 - 0.0011688311688312*G0_0_1_4_5_0 - 0.00350649350649363*G0_0_1_4_5_1 + 0.00116883116883121*G0_0_1_4_5_2 + 0.0140259740259745*G0_0_1_4_5_3 + 0.0140259740259745*G0_0_1_4_5_4 + 0.0140259740259745*G0_0_1_4_5_5 + 0.00262987012987024*G0_0_1_5_0_0 - 0.000292207792207814*G0_0_1_5_0_1 - 0.000876623376623409*G0_0_1_5_0_2 - 0.00350649350649362*G0_0_1_5_0_3 - 0.0011688311688312*G0_0_1_5_0_4 - 0.000292207792207814*G0_0_1_5_1_0 + 0.00175324675324683*G0_0_1_5_1_1 - 0.000584415584415607*G0_0_1_5_1_2 - 0.00467532467532483*G0_0_1_5_1_3 - 0.00350649350649363*G0_0_1_5_1_4 - 0.00233766233766241*G0_0_1_5_1_5 - 0.000876623376623409*G0_0_1_5_2_0 - 0.000584415584415607*G0_0_1_5_2_1 + 0.00350649350649364*G0_0_1_5_2_2 + 0.00350649350649364*G0_0_1_5_2_3 + 0.00116883116883121*G0_0_1_5_2_4 - 0.00350649350649364*G0_0_1_5_2_5 - 0.00350649350649362*G0_0_1_5_3_0 - 0.00467532467532483*G0_0_1_5_3_1 + 0.00350649350649364*G0_0_1_5_3_2 + 0.028051948051949*G0_0_1_5_3_3 + 0.0140259740259745*G0_0_1_5_3_4 + 0.0140259740259745*G0_0_1_5_3_5 - 0.0011688311688312*G0_0_1_5_4_0 - 0.00350649350649363*G0_0_1_5_4_1 + 0.00116883116883121*G0_0_1_5_4_2 + 0.0140259740259745*G0_0_1_5_4_3 + 0.0140259740259745*G0_0_1_5_4_4 + 0.0140259740259745*G0_0_1_5_4_5 - 0.00233766233766241*G0_0_1_5_5_1 - 0.00350649350649364*G0_0_1_5_5_2 + 0.0140259740259745*G0_0_1_5_5_3 + 0.0140259740259745*G0_0_1_5_5_4 + 0.0420779220779239*G0_0_1_5_5_5 - 0.00964285714285752*G0_1_0_0_0_0 + 0.000365259740259755*G0_1_0_0_0_1 - 0.000365259740259753*G0_1_0_0_0_2 + 0.0002922077922078*G0_1_0_0_0_3 + 0.00613636363636384*G0_1_0_0_0_4 - 0.00321428571428584*G0_1_0_0_0_5 + 0.000365259740259755*G0_1_0_0_1_0 - 0.000146103896103899*G0_1_0_0_1_1 + 0.000365259740259751*G0_1_0_0_1_2 + 0.00146103896103901*G0_1_0_0_1_3 + 0.000292207792207796*G0_1_0_0_1_4 + 0.000876623376623408*G0_1_0_0_1_5 - 0.000365259740259753*G0_1_0_0_2_0 + 0.000365259740259751*G0_1_0_0_2_1 + 0.00146103896103902*G0_1_0_0_2_2 - 0.00262987012987021*G0_1_0_0_2_3 - 0.00438311688311702*G0_1_0_0_2_4 - 0.000876623376623405*G0_1_0_0_2_5 + 0.0002922077922078*G0_1_0_0_3_0 + 0.00146103896103901*G0_1_0_0_3_1 - 0.00262987012987021*G0_1_0_0_3_2 - 0.00233766233766238*G0_1_0_0_3_3 - 0.0011688311688312*G0_1_0_0_3_4 + 0.00116883116883121*G0_1_0_0_3_5 + 0.00613636363636383*G0_1_0_0_4_0 + 0.000292207792207796*G0_1_0_0_4_1 - 0.00438311688311702*G0_1_0_0_4_2 - 0.0011688311688312*G0_1_0_0_4_3 + 0.0140259740259746*G0_1_0_0_4_4 + 0.00116883116883121*G0_1_0_0_4_5 - 0.00321428571428584*G0_1_0_0_5_0 + 0.000876623376623407*G0_1_0_0_5_1 - 0.000876623376623405*G0_1_0_0_5_2 + 0.00116883116883121*G0_1_0_0_5_3 + 0.00116883116883121*G0_1_0_0_5_4 - 0.00233766233766242*G0_1_0_0_5_5 + 0.000365259740259755*G0_1_0_1_0_0 - 0.000146103896103899*G0_1_0_1_0_1 + 0.000365259740259751*G0_1_0_1_0_2 + 0.00146103896103901*G0_1_0_1_0_3 + 0.000292207792207796*G0_1_0_1_0_4 + 0.000876623376623408*G0_1_0_1_0_5 - 0.000146103896103899*G0_1_0_1_1_0 - 0.00284902597402607*G0_1_0_1_1_1 + 0.00153409090909096*G0_1_0_1_1_2 + 0.000876623376623399*G0_1_0_1_1_3 + 0.00321428571428582*G0_1_0_1_1_4 + 0.0005844155844156*G0_1_0_1_1_5 + 0.000365259740259751*G0_1_0_1_2_0 + 0.00153409090909096*G0_1_0_1_2_1 - 0.00511363636363653*G0_1_0_1_2_2 - 0.00555194805194823*G0_1_0_1_2_3 + 0.00146103896103901*G0_1_0_1_2_4 + 0.000876623376623406*G0_1_0_1_2_5 + 0.001461038961039*G0_1_0_1_3_0 + 0.000876623376623399*G0_1_0_1_3_1 - 0.00555194805194823*G0_1_0_1_3_2 - 0.0245454545454554*G0_1_0_1_3_3 - 0.00935064935064966*G0_1_0_1_3_4 - 0.00467532467532484*G0_1_0_1_3_5 + 0.000292207792207796*G0_1_0_1_4_0 + 0.00321428571428582*G0_1_0_1_4_1 + 0.00146103896103901*G0_1_0_1_4_2 - 0.00935064935064966*G0_1_0_1_4_3 - 0.0292207792207802*G0_1_0_1_4_4 - 0.00818181818181847*G0_1_0_1_4_5 + 0.000876623376623407*G0_1_0_1_5_0 + 0.000584415584415599*G0_1_0_1_5_1 + 0.000876623376623407*G0_1_0_1_5_2 - 0.00467532467532484*G0_1_0_1_5_3 - 0.00818181818181847*G0_1_0_1_5_4 - 0.00233766233766242*G0_1_0_1_5_5 - 0.000365259740259753*G0_1_0_2_0_0 + 0.000365259740259751*G0_1_0_2_0_1 + 0.00146103896103902*G0_1_0_2_0_2 - 0.00262987012987021*G0_1_0_2_0_3 - 0.00438311688311702*G0_1_0_2_0_4 - 0.000876623376623405*G0_1_0_2_0_5 + 0.000365259740259751*G0_1_0_2_1_0 + 0.00153409090909096*G0_1_0_2_1_1 - 0.00511363636363653*G0_1_0_2_1_2 - 0.00555194805194823*G0_1_0_2_1_3 + 0.00146103896103901*G0_1_0_2_1_4 + 0.000876623376623406*G0_1_0_2_1_5 + 0.00146103896103902*G0_1_0_2_2_0 - 0.00511363636363653*G0_1_0_2_2_1 + 0.0109577922077926*G0_1_0_2_2_2 + 0.0233766233766242*G0_1_0_2_2_3 + 0.00146103896103901*G0_1_0_2_2_5 - 0.00262987012987021*G0_1_0_2_3_0 - 0.00555194805194823*G0_1_0_2_3_1 + 0.0233766233766242*G0_1_0_2_3_2 + 0.0444155844155859*G0_1_0_2_3_3 + 0.00233766233766241*G0_1_0_2_3_4 + 0.00233766233766242*G0_1_0_2_3_5 - 0.00438311688311702*G0_1_0_2_4_0 + 0.00146103896103901*G0_1_0_2_4_1 + 0.00233766233766241*G0_1_0_2_4_3 - 0.0257142857142866*G0_1_0_2_4_4 - 0.00584415584415605*G0_1_0_2_4_5 - 0.000876623376623405*G0_1_0_2_5_0 + 0.000876623376623407*G0_1_0_2_5_1 + 0.00146103896103901*G0_1_0_2_5_2 + 0.00233766233766242*G0_1_0_2_5_3 - 0.00584415584415605*G0_1_0_2_5_4 - 0.00116883116883121*G0_1_0_2_5_5 + 0.0002922077922078*G0_1_0_3_0_0 + 0.00146103896103901*G0_1_0_3_0_1 - 0.00262987012987021*G0_1_0_3_0_2 - 0.00233766233766238*G0_1_0_3_0_3 - 0.0011688311688312*G0_1_0_3_0_4 + 0.00116883116883121*G0_1_0_3_0_5 + 0.00146103896103901*G0_1_0_3_1_0 + 0.000876623376623399*G0_1_0_3_1_1 - 0.00555194805194823*G0_1_0_3_1_2 - 0.0245454545454554*G0_1_0_3_1_3 - 0.00935064935064966*G0_1_0_3_1_4 - 0.00467532467532484*G0_1_0_3_1_5 - 0.00262987012987021*G0_1_0_3_2_0 - 0.00555194805194823*G0_1_0_3_2_1 + 0.0233766233766242*G0_1_0_3_2_2 + 0.0444155844155859*G0_1_0_3_2_3 + 0.00233766233766241*G0_1_0_3_2_4 + 0.00233766233766242*G0_1_0_3_2_5 - 0.00233766233766238*G0_1_0_3_3_0 - 0.0245454545454554*G0_1_0_3_3_1 + 0.0444155844155859*G0_1_0_3_3_2 + 0.12623376623377*G0_1_0_3_3_3 + 0.0233766233766241*G0_1_0_3_3_4 - 0.0011688311688312*G0_1_0_3_4_0 - 0.00935064935064966*G0_1_0_3_4_1 + 0.00233766233766241*G0_1_0_3_4_2 + 0.0233766233766241*G0_1_0_3_4_3 + 0.0607792207792227*G0_1_0_3_4_4 + 0.0140259740259745*G0_1_0_3_4_5 + 0.00116883116883121*G0_1_0_3_5_0 - 0.00467532467532484*G0_1_0_3_5_1 + 0.00233766233766242*G0_1_0_3_5_2 + 0.0140259740259745*G0_1_0_3_5_4 + 0.00613636363636384*G0_1_0_4_0_0 + 0.000292207792207796*G0_1_0_4_0_1 - 0.00438311688311702*G0_1_0_4_0_2 - 0.0011688311688312*G0_1_0_4_0_3 + 0.0140259740259746*G0_1_0_4_0_4 + 0.00116883116883121*G0_1_0_4_0_5 + 0.000292207792207796*G0_1_0_4_1_0 + 0.00321428571428582*G0_1_0_4_1_1 + 0.00146103896103901*G0_1_0_4_1_2 - 0.00935064935064966*G0_1_0_4_1_3 - 0.0292207792207802*G0_1_0_4_1_4 - 0.00818181818181847*G0_1_0_4_1_5 - 0.00438311688311702*G0_1_0_4_2_0 + 0.00146103896103901*G0_1_0_4_2_1 + 0.00233766233766241*G0_1_0_4_2_3 - 0.0257142857142866*G0_1_0_4_2_4 - 0.00584415584415604*G0_1_0_4_2_5 - 0.0011688311688312*G0_1_0_4_3_0 - 0.00935064935064966*G0_1_0_4_3_1 + 0.00233766233766241*G0_1_0_4_3_2 + 0.0233766233766241*G0_1_0_4_3_3 + 0.0607792207792227*G0_1_0_4_3_4 + 0.0140259740259745*G0_1_0_4_3_5 + 0.0140259740259746*G0_1_0_4_4_0 - 0.0292207792207802*G0_1_0_4_4_1 - 0.0257142857142866*G0_1_0_4_4_2 + 0.0607792207792227*G0_1_0_4_4_3 + 0.462857142857158*G0_1_0_4_4_4 + 0.0701298701298725*G0_1_0_4_4_5 + 0.00116883116883121*G0_1_0_4_5_0 - 0.00818181818181847*G0_1_0_4_5_1 - 0.00584415584415605*G0_1_0_4_5_2 + 0.0140259740259745*G0_1_0_4_5_3 + 0.0701298701298725*G0_1_0_4_5_4 + 0.0187012987012993*G0_1_0_4_5_5 - 0.00321428571428584*G0_1_0_5_0_0 + 0.000876623376623407*G0_1_0_5_0_1 - 0.000876623376623405*G0_1_0_5_0_2 + 0.00116883116883121*G0_1_0_5_0_3 + 0.00116883116883121*G0_1_0_5_0_4 - 0.00233766233766242*G0_1_0_5_0_5 + 0.000876623376623407*G0_1_0_5_1_0 + 0.0005844155844156*G0_1_0_5_1_1 + 0.000876623376623407*G0_1_0_5_1_2 - 0.00467532467532484*G0_1_0_5_1_3 - 0.00818181818181847*G0_1_0_5_1_4 - 0.00233766233766243*G0_1_0_5_1_5 - 0.000876623376623405*G0_1_0_5_2_0 + 0.000876623376623407*G0_1_0_5_2_1 + 0.00146103896103901*G0_1_0_5_2_2 + 0.00233766233766242*G0_1_0_5_2_3 - 0.00584415584415604*G0_1_0_5_2_4 - 0.00116883116883121*G0_1_0_5_2_5 + 0.00116883116883121*G0_1_0_5_3_0 - 0.00467532467532484*G0_1_0_5_3_1 + 0.00233766233766242*G0_1_0_5_3_2 + 0.0140259740259745*G0_1_0_5_3_4 + 0.00116883116883121*G0_1_0_5_4_0 - 0.00818181818181847*G0_1_0_5_4_1 - 0.00584415584415604*G0_1_0_5_4_2 + 0.0140259740259745*G0_1_0_5_4_3 + 0.0701298701298725*G0_1_0_5_4_4 + 0.0187012987012993*G0_1_0_5_4_5 - 0.00233766233766242*G0_1_0_5_5_0 - 0.00233766233766243*G0_1_0_5_5_1 - 0.00116883116883121*G0_1_0_5_5_2 + 0.0187012987012993*G0_1_0_5_5_4 - 0.0249837662337672*G0_1_1_0_0_0 + 0.00379870129870144*G0_1_1_0_0_1 + 0.00175324675324682*G0_1_1_0_0_2 - 0.000876623376623407*G0_1_1_0_0_3 - 0.00438311688311705*G0_1_1_0_0_4 - 0.0219155844155852*G0_1_1_0_0_5 + 0.00379870129870144*G0_1_1_0_1_0 - 0.000365259740259755*G0_1_1_0_1_1 + 0.0002922077922078*G0_1_1_0_1_2 + 0.00146103896103901*G0_1_1_0_1_3 + 0.000876623376623407*G0_1_1_0_1_4 + 0.00759740259740287*G0_1_1_0_1_5 + 0.00175324675324682*G0_1_1_0_2_0 + 0.0002922077922078*G0_1_1_0_2_1 - 0.00328733766233778*G0_1_1_0_2_2 - 0.00350649350649362*G0_1_1_0_2_3 - 0.00175324675324681*G0_1_1_0_2_4 + 0.000876623376623412*G0_1_1_0_2_5 - 0.000876623376623407*G0_1_1_0_3_0 + 0.00146103896103901*G0_1_1_0_3_1 - 0.00350649350649362*G0_1_1_0_3_2 - 0.0035064935064936*G0_1_1_0_3_3 - 0.00438311688311705*G0_1_1_0_4_0 + 0.000876623376623407*G0_1_1_0_4_1 - 0.00175324675324681*G0_1_1_0_4_2 + 0.00233766233766241*G0_1_1_0_4_4 - 0.00350649350649364*G0_1_1_0_4_5 - 0.0219155844155852*G0_1_1_0_5_0 + 0.00759740259740287*G0_1_1_0_5_1 + 0.000876623376623412*G0_1_1_0_5_2 - 0.00350649350649364*G0_1_1_0_5_4 - 0.0280519480519492*G0_1_1_0_5_5 + 0.00379870129870144*G0_1_1_1_0_0 - 0.000365259740259755*G0_1_1_1_0_1 + 0.0002922077922078*G0_1_1_1_0_2 + 0.00146103896103901*G0_1_1_1_0_3 + 0.000876623376623407*G0_1_1_1_0_4 + 0.00759740259740287*G0_1_1_1_0_5 - 0.000365259740259755*G0_1_1_1_1_0 - 0.00438311688311703*G0_1_1_1_1_1 + 0.00226461038961047*G0_1_1_1_1_2 + 0.000584415584415603*G0_1_1_1_1_3 + 0.000292207792207803*G0_1_1_1_1_4 - 0.00642857142857165*G0_1_1_1_1_5 + 0.0002922077922078*G0_1_1_1_2_0 + 0.00226461038961047*G0_1_1_1_2_1 - 0.00759740259740287*G0_1_1_1_2_2 - 0.00818181818181847*G0_1_1_1_2_3 - 0.00175324675324681*G0_1_1_1_2_4 - 0.000292207792207804*G0_1_1_1_2_5 + 0.00146103896103901*G0_1_1_1_3_0 + 0.000584415584415603*G0_1_1_1_3_1 - 0.00818181818181847*G0_1_1_1_3_2 - 0.0233766233766242*G0_1_1_1_3_3 - 0.00350649350649363*G0_1_1_1_3_4 - 0.00233766233766243*G0_1_1_1_3_5 + 0.000876623376623407*G0_1_1_1_4_0 + 0.000292207792207803*G0_1_1_1_4_1 - 0.00175324675324681*G0_1_1_1_4_2 - 0.00350649350649363*G0_1_1_1_4_3 - 0.00233766233766242*G0_1_1_1_4_4 + 0.00759740259740287*G0_1_1_1_5_0 - 0.00642857142857165*G0_1_1_1_5_1 - 0.000292207792207804*G0_1_1_1_5_2 - 0.00233766233766242*G0_1_1_1_5_3 + 0.00467532467532484*G0_1_1_1_5_5 + 0.00175324675324682*G0_1_1_2_0_0 + 0.0002922077922078*G0_1_1_2_0_1 - 0.00328733766233777*G0_1_1_2_0_2 - 0.00350649350649362*G0_1_1_2_0_3 - 0.00175324675324681*G0_1_1_2_0_4 + 0.000876623376623412*G0_1_1_2_0_5 + 0.0002922077922078*G0_1_1_2_1_0 + 0.00226461038961047*G0_1_1_2_1_1 - 0.00759740259740287*G0_1_1_2_1_2 - 0.00818181818181847*G0_1_1_2_1_3 - 0.00175324675324681*G0_1_1_2_1_4 - 0.000292207792207804*G0_1_1_2_1_5 - 0.00328733766233778*G0_1_1_2_2_0 - 0.00759740259740286*G0_1_1_2_2_1 + 0.0493100649350668*G0_1_1_2_2_2 + 0.0350649350649363*G0_1_1_2_2_3 + 0.0131493506493511*G0_1_1_2_2_4 + 0.00175324675324683*G0_1_1_2_2_5 - 0.00350649350649362*G0_1_1_2_3_0 - 0.00818181818181847*G0_1_1_2_3_1 + 0.0350649350649363*G0_1_1_2_3_2 + 0.0525974025974044*G0_1_1_2_3_3 + 0.0105194805194809*G0_1_1_2_3_4 + 0.00350649350649364*G0_1_1_2_3_5 - 0.00175324675324681*G0_1_1_2_4_0 - 0.00175324675324681*G0_1_1_2_4_1 + 0.0131493506493511*G0_1_1_2_4_2 + 0.0105194805194809*G0_1_1_2_4_3 + 0.00233766233766244*G0_1_1_2_4_4 + 0.000876623376623412*G0_1_1_2_5_0 - 0.000292207792207804*G0_1_1_2_5_1 + 0.00175324675324683*G0_1_1_2_5_2 + 0.00350649350649364*G0_1_1_2_5_3 + 0.00701298701298726*G0_1_1_2_5_5 - 0.000876623376623407*G0_1_1_3_0_0 + 0.00146103896103901*G0_1_1_3_0_1 - 0.00350649350649362*G0_1_1_3_0_2 - 0.00350649350649359*G0_1_1_3_0_3 + 0.00146103896103901*G0_1_1_3_1_0 + 0.000584415584415603*G0_1_1_3_1_1 - 0.00818181818181847*G0_1_1_3_1_2 - 0.0233766233766242*G0_1_1_3_1_3 - 0.00350649350649363*G0_1_1_3_1_4 - 0.00233766233766243*G0_1_1_3_1_5 - 0.00350649350649362*G0_1_1_3_2_0 - 0.00818181818181847*G0_1_1_3_2_1 + 0.0350649350649363*G0_1_1_3_2_2 + 0.0525974025974044*G0_1_1_3_2_3 + 0.0105194805194809*G0_1_1_3_2_4 + 0.00350649350649364*G0_1_1_3_2_5 - 0.00350649350649359*G0_1_1_3_3_0 - 0.0233766233766242*G0_1_1_3_3_1 + 0.0525974025974044*G0_1_1_3_3_2 + 0.140259740259745*G0_1_1_3_3_3 + 0.0140259740259745*G0_1_1_3_3_4 - 0.00350649350649363*G0_1_1_3_4_1 + 0.0105194805194809*G0_1_1_3_4_2 + 0.0140259740259745*G0_1_1_3_4_3 + 0.00467532467532483*G0_1_1_3_4_4 - 0.00233766233766243*G0_1_1_3_5_1 + 0.00350649350649364*G0_1_1_3_5_2 - 0.0140259740259745*G0_1_1_3_5_5 - 0.00438311688311705*G0_1_1_4_0_0 + 0.000876623376623407*G0_1_1_4_0_1 - 0.00175324675324681*G0_1_1_4_0_2 + 0.00233766233766241*G0_1_1_4_0_4 - 0.00350649350649364*G0_1_1_4_0_5 + 0.000876623376623407*G0_1_1_4_1_0 + 0.000292207792207803*G0_1_1_4_1_1 - 0.00175324675324681*G0_1_1_4_1_2 - 0.00350649350649363*G0_1_1_4_1_3 - 0.00233766233766242*G0_1_1_4_1_4 - 0.00175324675324681*G0_1_1_4_2_0 - 0.00175324675324681*G0_1_1_4_2_1 + 0.0131493506493511*G0_1_1_4_2_2 + 0.0105194805194809*G0_1_1_4_2_3 + 0.00233766233766244*G0_1_1_4_2_4 - 0.00350649350649363*G0_1_1_4_3_1 + 0.0105194805194809*G0_1_1_4_3_2 + 0.0140259740259745*G0_1_1_4_3_3 + 0.00467532467532483*G0_1_1_4_3_4 + 0.00233766233766241*G0_1_1_4_4_0 - 0.00233766233766242*G0_1_1_4_4_1 + 0.00233766233766244*G0_1_1_4_4_2 + 0.00467532467532483*G0_1_1_4_4_3 + 0.0140259740259745*G0_1_1_4_4_4 + 0.00467532467532484*G0_1_1_4_4_5 - 0.00350649350649364*G0_1_1_4_5_0 + 0.00467532467532484*G0_1_1_4_5_4 - 0.0140259740259745*G0_1_1_4_5_5 - 0.0219155844155852*G0_1_1_5_0_0 + 0.00759740259740287*G0_1_1_5_0_1 + 0.000876623376623412*G0_1_1_5_0_2 - 0.00350649350649364*G0_1_1_5_0_4 - 0.0280519480519492*G0_1_1_5_0_5 + 0.00759740259740287*G0_1_1_5_1_0 - 0.00642857142857165*G0_1_1_5_1_1 - 0.000292207792207804*G0_1_1_5_1_2 - 0.00233766233766242*G0_1_1_5_1_3 + 0.00467532467532484*G0_1_1_5_1_5 + 0.000876623376623412*G0_1_1_5_2_0 - 0.000292207792207804*G0_1_1_5_2_1 + 0.00175324675324683*G0_1_1_5_2_2 + 0.00350649350649364*G0_1_1_5_2_3 + 0.00701298701298726*G0_1_1_5_2_5 - 0.00233766233766243*G0_1_1_5_3_1 + 0.00350649350649364*G0_1_1_5_3_2 - 0.0140259740259745*G0_1_1_5_3_5 - 0.00350649350649364*G0_1_1_5_4_0 + 0.00467532467532484*G0_1_1_5_4_4 - 0.0140259740259745*G0_1_1_5_4_5 - 0.0280519480519492*G0_1_1_5_5_0 + 0.00467532467532484*G0_1_1_5_5_1 + 0.00701298701298726*G0_1_1_5_5_2 - 0.0140259740259745*G0_1_1_5_5_3 - 0.0140259740259745*G0_1_1_5_5_4 - 0.238441558441567*G0_1_1_5_5_5;
    A[11] = 0.00262987012987022*G0_0_0_0_0_0 + 0.000618686868686889*G0_0_0_0_0_1 - 0.000328282828282839*G0_0_0_0_0_2 + 0.000537518037518054*G0_0_0_0_0_3 + 0.00163419913419919*G0_0_0_0_0_4 + 0.00139610389610394*G0_0_0_0_0_5 + 0.000618686868686889*G0_0_0_0_1_0 - 0.00585317460317481*G0_0_0_0_1_1 + 0.000523989898989917*G0_0_0_0_1_2 - 0.00189393939393946*G0_0_0_0_1_3 - 0.000227272727272735*G0_0_0_0_1_4 - 0.00353535353535366*G0_0_0_0_1_5 - 0.000328282828282839*G0_0_0_0_2_0 + 0.000523989898989917*G0_0_0_0_2_1 - 0.00032828282828284*G0_0_0_0_2_2 + 0.000335497835497847*G0_0_0_0_2_3 - 0.000548340548340567*G0_0_0_0_2_4 + 0.000335497835497847*G0_0_0_0_2_5 + 0.000537518037518054*G0_0_0_0_3_0 - 0.00189393939393946*G0_0_0_0_3_1 + 0.000335497835497847*G0_0_0_0_3_2 - 0.00236652236652245*G0_0_0_0_3_3 - 0.00062049062049064*G0_0_0_0_3_4 - 0.00174603174603181*G0_0_0_0_3_5 + 0.00163419913419919*G0_0_0_0_4_0 - 0.000227272727272735*G0_0_0_0_4_1 - 0.000548340548340567*G0_0_0_0_4_2 - 0.00062049062049064*G0_0_0_0_4_3 + 0.000692640692640716*G0_0_0_0_4_4 - 0.000216450216450222*G0_0_0_0_4_5 + 0.00139610389610394*G0_0_0_0_5_0 - 0.00353535353535366*G0_0_0_0_5_1 + 0.000335497835497847*G0_0_0_0_5_2 - 0.00174603174603181*G0_0_0_0_5_3 - 0.000216450216450222*G0_0_0_0_5_4 - 0.00337662337662349*G0_0_0_0_5_5 + 0.00061868686868689*G0_0_0_1_0_0 - 0.00585317460317481*G0_0_0_1_0_1 + 0.000523989898989917*G0_0_0_1_0_2 - 0.00189393939393946*G0_0_0_1_0_3 - 0.000227272727272735*G0_0_0_1_0_4 - 0.00353535353535366*G0_0_0_1_0_5 - 0.00585317460317481*G0_0_0_1_1_0 + 0.0918019480519513*G0_0_0_1_1_1 - 0.00585317460317481*G0_0_0_1_1_2 + 0.0250541125541134*G0_0_0_1_1_3 + 0.00164141414141419*G0_0_0_1_1_4 + 0.0250541125541135*G0_0_0_1_1_5 + 0.000523989898989917*G0_0_0_1_2_0 - 0.00585317460317481*G0_0_0_1_2_1 + 0.000618686868686891*G0_0_0_1_2_2 - 0.00353535353535366*G0_0_0_1_2_3 - 0.000227272727272735*G0_0_0_1_2_4 - 0.00189393939393947*G0_0_0_1_2_5 - 0.00189393939393946*G0_0_0_1_3_0 + 0.0250541125541134*G0_0_0_1_3_1 - 0.00353535353535366*G0_0_0_1_3_2 + 0.0151515151515157*G0_0_0_1_3_3 + 0.000505050505050524*G0_0_0_1_3_4 + 0.00757575757575787*G0_0_0_1_3_5 - 0.000227272727272735*G0_0_0_1_4_0 + 0.00164141414141419*G0_0_0_1_4_1 - 0.000227272727272735*G0_0_0_1_4_2 + 0.000505050505050524*G0_0_0_1_4_3 - 0.000808080808080834*G0_0_0_1_4_4 + 0.000505050505050522*G0_0_0_1_4_5 - 0.00353535353535366*G0_0_0_1_5_0 + 0.0250541125541135*G0_0_0_1_5_1 - 0.00189393939393947*G0_0_0_1_5_2 + 0.00757575757575787*G0_0_0_1_5_3 + 0.000505050505050522*G0_0_0_1_5_4 + 0.0151515151515157*G0_0_0_1_5_5 - 0.000328282828282839*G0_0_0_2_0_0 + 0.000523989898989917*G0_0_0_2_0_1 - 0.00032828282828284*G0_0_0_2_0_2 + 0.000335497835497847*G0_0_0_2_0_3 - 0.000548340548340567*G0_0_0_2_0_4 + 0.000335497835497847*G0_0_0_2_0_5 + 0.000523989898989917*G0_0_0_2_1_0 - 0.00585317460317481*G0_0_0_2_1_1 + 0.000618686868686891*G0_0_0_2_1_2 - 0.00353535353535366*G0_0_0_2_1_3 - 0.000227272727272735*G0_0_0_2_1_4 - 0.00189393939393947*G0_0_0_2_1_5 - 0.00032828282828284*G0_0_0_2_2_0 + 0.000618686868686891*G0_0_0_2_2_1 + 0.00262987012987024*G0_0_0_2_2_2 + 0.00139610389610395*G0_0_0_2_2_3 + 0.00163419913419919*G0_0_0_2_2_4 + 0.000537518037518057*G0_0_0_2_2_5 + 0.000335497835497847*G0_0_0_2_3_0 - 0.00353535353535366*G0_0_0_2_3_1 + 0.00139610389610395*G0_0_0_2_3_2 - 0.0033766233766235*G0_0_0_2_3_3 - 0.000216450216450223*G0_0_0_2_3_4 - 0.00174603174603181*G0_0_0_2_3_5 - 0.000548340548340567*G0_0_0_2_4_0 - 0.000227272727272735*G0_0_0_2_4_1 + 0.00163419913419919*G0_0_0_2_4_2 - 0.000216450216450223*G0_0_0_2_4_3 + 0.000692640692640721*G0_0_0_2_4_4 - 0.00062049062049064*G0_0_0_2_4_5 + 0.000335497835497847*G0_0_0_2_5_0 - 0.00189393939393947*G0_0_0_2_5_1 + 0.000537518037518057*G0_0_0_2_5_2 - 0.00174603174603181*G0_0_0_2_5_3 - 0.00062049062049064*G0_0_0_2_5_4 - 0.00236652236652245*G0_0_0_2_5_5 + 0.000537518037518054*G0_0_0_3_0_0 - 0.00189393939393946*G0_0_0_3_0_1 + 0.000335497835497847*G0_0_0_3_0_2 - 0.00236652236652245*G0_0_0_3_0_3 - 0.00062049062049064*G0_0_0_3_0_4 - 0.00174603174603181*G0_0_0_3_0_5 - 0.00189393939393946*G0_0_0_3_1_0 + 0.0250541125541134*G0_0_0_3_1_1 - 0.00353535353535366*G0_0_0_3_1_2 + 0.0151515151515157*G0_0_0_3_1_3 + 0.000505050505050524*G0_0_0_3_1_4 + 0.00757575757575787*G0_0_0_3_1_5 + 0.000335497835497847*G0_0_0_3_2_0 - 0.00353535353535366*G0_0_0_3_2_1 + 0.00139610389610395*G0_0_0_3_2_2 - 0.0033766233766235*G0_0_0_3_2_3 - 0.000216450216450223*G0_0_0_3_2_4 - 0.00174603174603181*G0_0_0_3_2_5 - 0.00236652236652245*G0_0_0_3_3_0 + 0.0151515151515157*G0_0_0_3_3_1 - 0.0033766233766235*G0_0_0_3_3_2 + 0.0246753246753255*G0_0_0_3_3_3 + 0.00372294372294385*G0_0_0_3_3_4 + 0.00822510822510852*G0_0_0_3_3_5 - 0.00062049062049064*G0_0_0_3_4_0 + 0.000505050505050524*G0_0_0_3_4_1 - 0.000216450216450223*G0_0_0_3_4_2 + 0.00372294372294385*G0_0_0_3_4_3 + 0.00285714285714295*G0_0_0_3_4_4 + 0.00248196248196256*G0_0_0_3_4_5 - 0.00174603174603181*G0_0_0_3_5_0 + 0.00757575757575787*G0_0_0_3_5_1 - 0.00174603174603181*G0_0_0_3_5_2 + 0.00822510822510852*G0_0_0_3_5_3 + 0.00248196248196256*G0_0_0_3_5_4 + 0.00822510822510852*G0_0_0_3_5_5 + 0.00163419913419919*G0_0_0_4_0_0 - 0.000227272727272735*G0_0_0_4_0_1 - 0.000548340548340567*G0_0_0_4_0_2 - 0.00062049062049064*G0_0_0_4_0_3 + 0.000692640692640716*G0_0_0_4_0_4 - 0.000216450216450222*G0_0_0_4_0_5 - 0.000227272727272735*G0_0_0_4_1_0 + 0.00164141414141419*G0_0_0_4_1_1 - 0.000227272727272735*G0_0_0_4_1_2 + 0.000505050505050524*G0_0_0_4_1_3 - 0.000808080808080834*G0_0_0_4_1_4 + 0.000505050505050522*G0_0_0_4_1_5 - 0.000548340548340567*G0_0_0_4_2_0 - 0.000227272727272735*G0_0_0_4_2_1 + 0.00163419913419919*G0_0_0_4_2_2 - 0.000216450216450223*G0_0_0_4_2_3 + 0.000692640692640721*G0_0_0_4_2_4 - 0.00062049062049064*G0_0_0_4_2_5 - 0.00062049062049064*G0_0_0_4_3_0 + 0.000505050505050524*G0_0_0_4_3_1 - 0.000216450216450223*G0_0_0_4_3_2 + 0.00372294372294385*G0_0_0_4_3_3 + 0.00285714285714295*G0_0_0_4_3_4 + 0.00248196248196256*G0_0_0_4_3_5 + 0.000692640692640716*G0_0_0_4_4_0 - 0.000808080808080834*G0_0_0_4_4_1 + 0.000692640692640721*G0_0_0_4_4_2 + 0.00285714285714295*G0_0_0_4_4_3 + 0.0168831168831174*G0_0_0_4_4_4 + 0.00285714285714295*G0_0_0_4_4_5 - 0.000216450216450222*G0_0_0_4_5_0 + 0.000505050505050522*G0_0_0_4_5_1 - 0.00062049062049064*G0_0_0_4_5_2 + 0.00248196248196256*G0_0_0_4_5_3 + 0.00285714285714295*G0_0_0_4_5_4 + 0.00372294372294385*G0_0_0_4_5_5 + 0.00139610389610394*G0_0_0_5_0_0 - 0.00353535353535366*G0_0_0_5_0_1 + 0.000335497835497847*G0_0_0_5_0_2 - 0.0017460317460318*G0_0_0_5_0_3 - 0.000216450216450222*G0_0_0_5_0_4 - 0.00337662337662349*G0_0_0_5_0_5 - 0.00353535353535366*G0_0_0_5_1_0 + 0.0250541125541135*G0_0_0_5_1_1 - 0.00189393939393947*G0_0_0_5_1_2 + 0.00757575757575787*G0_0_0_5_1_3 + 0.000505050505050522*G0_0_0_5_1_4 + 0.0151515151515157*G0_0_0_5_1_5 + 0.000335497835497847*G0_0_0_5_2_0 - 0.00189393939393947*G0_0_0_5_2_1 + 0.000537518037518057*G0_0_0_5_2_2 - 0.00174603174603181*G0_0_0_5_2_3 - 0.00062049062049064*G0_0_0_5_2_4 - 0.00236652236652245*G0_0_0_5_2_5 - 0.00174603174603181*G0_0_0_5_3_0 + 0.00757575757575787*G0_0_0_5_3_1 - 0.00174603174603181*G0_0_0_5_3_2 + 0.00822510822510852*G0_0_0_5_3_3 + 0.00248196248196256*G0_0_0_5_3_4 + 0.00822510822510852*G0_0_0_5_3_5 - 0.000216450216450222*G0_0_0_5_4_0 + 0.000505050505050522*G0_0_0_5_4_1 - 0.00062049062049064*G0_0_0_5_4_2 + 0.00248196248196256*G0_0_0_5_4_3 + 0.00285714285714295*G0_0_0_5_4_4 + 0.00372294372294385*G0_0_0_5_4_5 - 0.00337662337662349*G0_0_0_5_5_0 + 0.0151515151515157*G0_0_0_5_5_1 - 0.00236652236652245*G0_0_0_5_5_2 + 0.00822510822510852*G0_0_0_5_5_3 + 0.00372294372294385*G0_0_0_5_5_4 + 0.0246753246753255*G0_0_0_5_5_5;
    A[16] = A[11] - 0.0018303571428572*G0_0_0_0_0_0 - 0.000584866522366542*G0_0_0_0_0_1 - 0.000134379509379515*G0_0_0_0_0_2 - 0.00034812409812411*G0_0_0_0_0_3 - 0.0015963203463204*G0_0_0_0_0_4 - 0.00119047619047623*G0_0_0_0_0_5 - 0.000584866522366541*G0_0_0_0_1_0 + 0.00543650793650812*G0_0_0_0_1_1 - 0.000537518037518056*G0_0_0_0_1_2 + 0.00185064935064941*G0_0_0_0_1_3 + 0.000135281385281389*G0_0_0_0_1_4 + 0.00330808080808092*G0_0_0_0_1_5 - 0.000134379509379515*G0_0_0_0_2_0 - 0.000537518037518056*G0_0_0_0_2_1 + 0.00238861832611841*G0_0_0_0_2_2 + 0.00226911976911985*G0_0_0_0_2_4 - 0.000221861471861479*G0_0_0_0_2_5 - 0.00034812409812411*G0_0_0_0_3_0 + 0.00185064935064941*G0_0_0_0_3_1 + 0.000591630591630615*G0_0_0_0_3_3 + 0.000425685425685441*G0_0_0_0_3_4 + 0.00113997113997118*G0_0_0_0_3_5 - 0.0015963203463204*G0_0_0_0_4_0 + 0.000135281385281389*G0_0_0_0_4_1 + 0.00226911976911985*G0_0_0_0_4_2 + 0.00042568542568544*G0_0_0_0_4_3 + 0.00287878787878797*G0_0_0_0_4_4 + 0.000173160173160177*G0_0_0_0_4_5 - 0.00119047619047623*G0_0_0_0_5_0 + 0.00330808080808092*G0_0_0_0_5_1 - 0.000221861471861479*G0_0_0_0_5_2 + 0.00113997113997118*G0_0_0_0_5_3 + 0.000173160173160178*G0_0_0_0_5_4 + 0.00268398268398276*G0_0_0_0_5_5 - 0.000584866522366542*G0_0_0_1_0_0 + 0.00543650793650812*G0_0_0_1_0_1 - 0.000537518037518056*G0_0_0_1_0_2 + 0.00185064935064941*G0_0_0_1_0_3 + 0.000135281385281389*G0_0_0_1_0_4 + 0.00330808080808092*G0_0_0_1_0_5 + 0.00543650793650812*G0_0_0_1_1_0 - 0.0874594155844186*G0_0_0_1_1_1 + 0.00534181096681115*G0_0_0_1_1_2 - 0.0222402597402605*G0_0_0_1_1_3 - 0.00140331890331894*G0_0_0_1_1_4 - 0.0234848484848494*G0_0_0_1_1_5 - 0.000537518037518056*G0_0_0_1_2_0 + 0.00534181096681115*G0_0_0_1_2_1 + 0.000345869408369422*G0_0_0_1_2_2 + 0.00272366522366532*G0_0_0_1_2_3 + 0.000611471861471883*G0_0_0_1_2_4 + 0.00156926406926413*G0_0_0_1_2_5 + 0.00185064935064941*G0_0_0_1_3_0 - 0.0222402597402605*G0_0_0_1_3_1 + 0.00272366522366532*G0_0_0_1_3_2 - 0.0156709956709962*G0_0_0_1_3_3 - 0.000894660894660925*G0_0_0_1_3_4 - 0.0068398268398271*G0_0_0_1_3_5 + 0.000135281385281389*G0_0_0_1_4_0 - 0.00140331890331894*G0_0_0_1_4_1 + 0.000611471861471883*G0_0_0_1_4_2 - 0.000894660894660925*G0_0_0_1_4_3 + 0.00156565656565662*G0_0_0_1_4_4 - 0.000331890331890342*G0_0_0_1_4_5 + 0.00330808080808092*G0_0_0_1_5_0 - 0.0234848484848494*G0_0_0_1_5_1 + 0.00156926406926413*G0_0_0_1_5_2 - 0.0068398268398271*G0_0_0_1_5_3 - 0.000331890331890342*G0_0_0_1_5_4 - 0.013506493506494*G0_0_0_1_5_5 - 0.000134379509379515*G0_0_0_2_0_0 - 0.000537518037518056*G0_0_0_2_0_1 + 0.00238861832611841*G0_0_0_2_0_2 + 0.00226911976911985*G0_0_0_2_0_4 - 0.000221861471861478*G0_0_0_2_0_5 - 0.000537518037518056*G0_0_0_2_1_0 + 0.00534181096681115*G0_0_0_2_1_1 + 0.000345869408369422*G0_0_0_2_1_2 + 0.00272366522366532*G0_0_0_2_1_3 + 0.000611471861471883*G0_0_0_2_1_4 + 0.00156926406926413*G0_0_0_2_1_5 + 0.00238861832611841*G0_0_0_2_2_0 + 0.000345869408369422*G0_0_0_2_2_1 - 0.0278733766233777*G0_0_0_2_2_2 - 0.00415584415584432*G0_0_0_2_2_3 - 0.0112121212121216*G0_0_0_2_2_4 - 0.000802669552669587*G0_0_0_2_2_5 + 0.00272366522366532*G0_0_0_2_3_1 - 0.00415584415584432*G0_0_0_2_3_2 + 0.00536796536796555*G0_0_0_2_3_3 - 0.00112554112554117*G0_0_0_2_3_4 + 0.00170274170274176*G0_0_0_2_3_5 + 0.00226911976911985*G0_0_0_2_4_0 + 0.000611471861471883*G0_0_0_2_4_1 - 0.0112121212121216*G0_0_0_2_4_2 - 0.00112554112554117*G0_0_0_2_4_3 - 0.0103896103896108*G0_0_0_2_4_4 + 0.000382395382395392*G0_0_0_2_4_5 - 0.000221861471861478*G0_0_0_2_5_0 + 0.00156926406926413*G0_0_0_2_5_1 - 0.000802669552669586*G0_0_0_2_5_2 + 0.00170274170274176*G0_0_0_2_5_3 + 0.000382395382395392*G0_0_0_2_5_4 + 0.00240981240981249*G0_0_0_2_5_5 - 0.00034812409812411*G0_0_0_3_0_0 + 0.00185064935064941*G0_0_0_3_0_1 + 0.000591630591630615*G0_0_0_3_0_3 + 0.00042568542568544*G0_0_0_3_0_4 + 0.00113997113997118*G0_0_0_3_0_5 + 0.00185064935064941*G0_0_0_3_1_0 - 0.0222402597402605*G0_0_0_3_1_1 + 0.00272366522366532*G0_0_0_3_1_2 - 0.0156709956709962*G0_0_0_3_1_3 - 0.000894660894660925*G0_0_0_3_1_4 - 0.0068398268398271*G0_0_0_3_1_5 + 0.00272366522366532*G0_0_0_3_2_1 - 0.00415584415584432*G0_0_0_3_2_2 + 0.00536796536796555*G0_0_0_3_2_3 - 0.00112554112554117*G0_0_0_3_2_4 + 0.00170274170274176*G0_0_0_3_2_5 + 0.000591630591630615*G0_0_0_3_3_0 - 0.0156709956709962*G0_0_0_3_3_1 + 0.00536796536796555*G0_0_0_3_3_2 - 0.00233766233766245*G0_0_0_3_3_3 + 0.000606060606060625*G0_0_0_3_3_4 - 0.00458874458874476*G0_0_0_3_3_5 + 0.00042568542568544*G0_0_0_3_4_0 - 0.000894660894660925*G0_0_0_3_4_1 - 0.00112554112554117*G0_0_0_3_4_2 + 0.000606060606060626*G0_0_0_3_4_3 - 0.00398268398268411*G0_0_0_3_4_4 - 0.00161616161616167*G0_0_0_3_4_5 + 0.00113997113997118*G0_0_0_3_5_0 - 0.0068398268398271*G0_0_0_3_5_1 + 0.00170274170274176*G0_0_0_3_5_2 - 0.00458874458874476*G0_0_0_3_5_3 - 0.00161616161616167*G0_0_0_3_5_4 - 0.00709956709956735*G0_0_0_3_5_5 - 0.0015963203463204*G0_0_0_4_0_0 + 0.000135281385281389*G0_0_0_4_0_1 + 0.00226911976911985*G0_0_0_4_0_2 + 0.000425685425685441*G0_0_0_4_0_3 + 0.00287878787878797*G0_0_0_4_0_4 + 0.000173160173160177*G0_0_0_4_0_5 + 0.000135281385281389*G0_0_0_4_1_0 - 0.00140331890331894*G0_0_0_4_1_1 + 0.000611471861471883*G0_0_0_4_1_2 - 0.000894660894660925*G0_0_0_4_1_3 + 0.00156565656565662*G0_0_0_4_1_4 - 0.000331890331890342*G0_0_0_4_1_5 + 0.00226911976911985*G0_0_0_4_2_0 + 0.000611471861471883*G0_0_0_4_2_1 - 0.0112121212121216*G0_0_0_4_2_2 - 0.00112554112554117*G0_0_0_4_2_3 - 0.0103896103896108*G0_0_0_4_2_4 + 0.000382395382395392*G0_0_0_4_2_5 + 0.000425685425685441*G0_0_0_4_3_0 - 0.000894660894660925*G0_0_0_4_3_1 - 0.00112554112554117*G0_0_0_4_3_2 + 0.000606060606060625*G0_0_0_4_3_3 - 0.00398268398268411*G0_0_0_4_3_4 - 0.00161616161616167*G0_0_0_4_3_5 + 0.00287878787878797*G0_0_0_4_4_0 + 0.00156565656565662*G0_0_0_4_4_1 - 0.0103896103896108*G0_0_0_4_4_2 - 0.00398268398268411*G0_0_0_4_4_3 - 0.0436363636363651*G0_0_0_4_4_4 - 0.00389610389610403*G0_0_0_4_4_5 + 0.000173160173160177*G0_0_0_4_5_0 - 0.000331890331890342*G0_0_0_4_5_1 + 0.000382395382395392*G0_0_0_4_5_2 - 0.00161616161616167*G0_0_0_4_5_3 - 0.00389610389610403*G0_0_0_4_5_4 - 0.00415584415584429*G0_0_0_4_5_5 - 0.00119047619047623*G0_0_0_5_0_0 + 0.00330808080808092*G0_0_0_5_0_1 - 0.000221861471861478*G0_0_0_5_0_2 + 0.00113997113997118*G0_0_0_5_0_3 + 0.000173160173160177*G0_0_0_5_0_4 + 0.00268398268398276*G0_0_0_5_0_5 + 0.00330808080808092*G0_0_0_5_1_0 - 0.0234848484848494*G0_0_0_5_1_1 + 0.00156926406926413*G0_0_0_5_1_2 - 0.0068398268398271*G0_0_0_5_1_3 - 0.000331890331890342*G0_0_0_5_1_4 - 0.013506493506494*G0_0_0_5_1_5 - 0.000221861471861479*G0_0_0_5_2_0 + 0.00156926406926413*G0_0_0_5_2_1 - 0.000802669552669587*G0_0_0_5_2_2 + 0.00170274170274176*G0_0_0_5_2_3 + 0.000382395382395392*G0_0_0_5_2_4 + 0.00240981240981249*G0_0_0_5_2_5 + 0.00113997113997118*G0_0_0_5_3_0 - 0.0068398268398271*G0_0_0_5_3_1 + 0.00170274170274176*G0_0_0_5_3_2 - 0.00458874458874476*G0_0_0_5_3_3 - 0.00161616161616167*G0_0_0_5_3_4 - 0.00709956709956735*G0_0_0_5_3_5 + 0.000173160173160177*G0_0_0_5_4_0 - 0.000331890331890342*G0_0_0_5_4_1 + 0.000382395382395392*G0_0_0_5_4_2 - 0.00161616161616167*G0_0_0_5_4_3 - 0.00389610389610403*G0_0_0_5_4_4 - 0.00415584415584429*G0_0_0_5_4_5 + 0.00268398268398277*G0_0_0_5_5_0 - 0.013506493506494*G0_0_0_5_5_1 + 0.00240981240981249*G0_0_0_5_5_2 - 0.00709956709956735*G0_0_0_5_5_3 - 0.00415584415584429*G0_0_0_5_5_4 - 0.0249350649350658*G0_0_0_5_5_5 - 0.00756087662337687*G0_0_1_0_0_0 + 0.000116341991341994*G0_0_1_0_0_1 - 0.000129870129870133*G0_0_1_0_0_3 - 0.000351731601731612*G0_0_1_0_0_4 - 0.000703463203463223*G0_0_1_0_0_5 + 0.000116341991341994*G0_0_1_0_1_0 + 0.000346320346320358*G0_0_1_0_1_1 - 0.00027056277056278*G0_0_1_0_1_3 - 0.000281385281385291*G0_0_1_0_1_4 + 0.00127299783549788*G0_0_1_0_2_2 - 0.000162337662337664*G0_0_1_0_2_4 - 0.000238095238095246*G0_0_1_0_2_5 - 0.000129870129870133*G0_0_1_0_3_0 - 0.00027056277056278*G0_0_1_0_3_1 + 0.000129870129870134*G0_0_1_0_3_3 + 0.000822510822510849*G0_0_1_0_3_4 + 0.000735930735930759*G0_0_1_0_3_5 - 0.000351731601731612*G0_0_1_0_4_0 - 0.000281385281385291*G0_0_1_0_4_1 - 0.000162337662337664*G0_0_1_0_4_2 + 0.000822510822510849*G0_0_1_0_4_3 + 0.00339826839826852*G0_0_1_0_4_4 + 0.00103896103896107*G0_0_1_0_4_5 - 0.000703463203463223*G0_0_1_0_5_0 - 0.000238095238095246*G0_0_1_0_5_2 + 0.000735930735930759*G0_0_1_0_5_3 + 0.00103896103896107*G0_0_1_0_5_4 + 0.00380952380952394*G0_0_1_0_5_5 + 0.000116341991341994*G0_0_1_1_0_0 + 0.000346320346320358*G0_0_1_1_0_1 - 0.00027056277056278*G0_0_1_1_0_3 - 0.000281385281385291*G0_0_1_1_0_4 + 0.000346320346320358*G0_0_1_1_1_0 - 0.000248917748917757*G0_0_1_1_1_2 + 0.00156926406926412*G0_0_1_1_1_3 - 0.00156926406926412*G0_0_1_1_1_5 - 0.000248917748917757*G0_0_1_1_2_1 + 0.000735930735930763*G0_0_1_1_2_2 - 0.000844155844155872*G0_0_1_1_2_3 - 0.00018398268398269*G0_0_1_1_2_5 - 0.00027056277056278*G0_0_1_1_3_0 + 0.00156926406926412*G0_0_1_1_3_1 - 0.000844155844155872*G0_0_1_1_3_2 + 0.00147186147186152*G0_0_1_1_3_3 + 0.000735930735930761*G0_0_1_1_3_4 + 0.000909090909090941*G0_0_1_1_3_5 - 0.000281385281385291*G0_0_1_1_4_0 + 0.000735930735930761*G0_0_1_1_4_3 - 0.000389610389610399*G0_0_1_1_4_4 + 0.000562770562770582*G0_0_1_1_4_5 - 0.00156926406926412*G0_0_1_1_5_1 - 0.00018398268398269*G0_0_1_1_5_2 + 0.000909090909090941*G0_0_1_1_5_3 + 0.000562770562770582*G0_0_1_1_5_4 - 0.0032900432900434*G0_0_1_1_5_5 + 0.00127299783549788*G0_0_1_2_0_2 - 0.000162337662337664*G0_0_1_2_0_4 - 0.000238095238095246*G0_0_1_2_0_5 - 0.000248917748917757*G0_0_1_2_1_1 + 0.000735930735930763*G0_0_1_2_1_2 - 0.000844155844155871*G0_0_1_2_1_3 - 0.00018398268398269*G0_0_1_2_1_5 + 0.00127299783549788*G0_0_1_2_2_0 + 0.000735930735930763*G0_0_1_2_2_1 - 0.0201501623376631*G0_0_1_2_2_2 - 0.00213744588744597*G0_0_1_2_2_3 - 0.00492424242424262*G0_0_1_2_2_4 - 0.000243506493506505*G0_0_1_2_2_5 - 0.000844155844155871*G0_0_1_2_3_1 - 0.00213744588744597*G0_0_1_2_3_2 + 0.0020346320346321*G0_0_1_2_3_3 + 0.00056277056277058*G0_0_1_2_3_5 - 0.000162337662337664*G0_0_1_2_4_0 - 0.00492424242424262*G0_0_1_2_4_2 - 0.00313852813852826*G0_0_1_2_4_4 + 0.000476190476190491*G0_0_1_2_4_5 - 0.000238095238095246*G0_0_1_2_5_0 - 0.00018398268398269*G0_0_1_2_5_1 - 0.000243506493506506*G0_0_1_2_5_2 + 0.00056277056277058*G0_0_1_2_5_3 + 0.000476190476190491*G0_0_1_2_5_4 + 0.000519480519480536*G0_0_1_2_5_5 - 0.000129870129870133*G0_0_1_3_0_0 - 0.00027056277056278*G0_0_1_3_0_1 + 0.000129870129870134*G0_0_1_3_0_3 + 0.000822510822510849*G0_0_1_3_0_4 + 0.000735930735930759*G0_0_1_3_0_5 - 0.00027056277056278*G0_0_1_3_1_0 + 0.00156926406926412*G0_0_1_3_1_1 - 0.000844155844155871*G0_0_1_3_1_2 + 0.00147186147186152*G0_0_1_3_1_3 + 0.000735930735930761*G0_0_1_3_1_4 + 0.000909090909090941*G0_0_1_3_1_5 - 0.000844155844155871*G0_0_1_3_2_1 - 0.00213744588744598*G0_0_1_3_2_2 + 0.0020346320346321*G0_0_1_3_2_3 + 0.00056277056277058*G0_0_1_3_2_5 + 0.000129870129870134*G0_0_1_3_3_0 + 0.00147186147186152*G0_0_1_3_3_1 + 0.0020346320346321*G0_0_1_3_3_2 + 0.0109090909090913*G0_0_1_3_3_3 - 0.00173160173160179*G0_0_1_3_3_4 - 0.00138528138528142*G0_0_1_3_3_5 + 0.000822510822510849*G0_0_1_3_4_0 + 0.000735930735930761*G0_0_1_3_4_1 - 0.00173160173160179*G0_0_1_3_4_3 - 0.000865800865800902*G0_0_1_3_4_4 - 0.00259740259740268*G0_0_1_3_4_5 + 0.000735930735930759*G0_0_1_3_5_0 + 0.000909090909090941*G0_0_1_3_5_1 + 0.00056277056277058*G0_0_1_3_5_2 - 0.00138528138528142*G0_0_1_3_5_3 - 0.00259740259740268*G0_0_1_3_5_4 - 0.00251082251082259*G0_0_1_3_5_5 - 0.000351731601731612*G0_0_1_4_0_0 - 0.000281385281385291*G0_0_1_4_0_1 - 0.000162337662337664*G0_0_1_4_0_2 + 0.000822510822510849*G0_0_1_4_0_3 + 0.00339826839826852*G0_0_1_4_0_4 + 0.00103896103896107*G0_0_1_4_0_5 - 0.000281385281385291*G0_0_1_4_1_0 + 0.000735930735930761*G0_0_1_4_1_3 - 0.000389610389610399*G0_0_1_4_1_4 + 0.000562770562770582*G0_0_1_4_1_5 - 0.000162337662337664*G0_0_1_4_2_0 - 0.00492424242424262*G0_0_1_4_2_2 - 0.00313852813852826*G0_0_1_4_2_4 + 0.000476190476190491*G0_0_1_4_2_5 + 0.000822510822510849*G0_0_1_4_3_0 + 0.000735930735930761*G0_0_1_4_3_1 - 0.00173160173160179*G0_0_1_4_3_3 - 0.000865800865800903*G0_0_1_4_3_4 - 0.00259740259740268*G0_0_1_4_3_5 + 0.00339826839826852*G0_0_1_4_4_0 - 0.000389610389610399*G0_0_1_4_4_1 - 0.00313852813852825*G0_0_1_4_4_2 - 0.000865800865800903*G0_0_1_4_4_3 + 0.039740259740261*G0_0_1_4_4_4 - 0.000173160173160184*G0_0_1_4_4_5 + 0.00103896103896107*G0_0_1_4_5_0 + 0.000562770562770582*G0_0_1_4_5_1 + 0.000476190476190491*G0_0_1_4_5_2 - 0.00259740259740268*G0_0_1_4_5_3 - 0.000173160173160182*G0_0_1_4_5_4 - 0.00216450216450223*G0_0_1_4_5_5 - 0.000703463203463223*G0_0_1_5_0_0 - 0.000238095238095246*G0_0_1_5_0_2 + 0.000735930735930759*G0_0_1_5_0_3 + 0.00103896103896107*G0_0_1_5_0_4 + 0.00380952380952394*G0_0_1_5_0_5 - 0.00156926406926412*G0_0_1_5_1_1 - 0.00018398268398269*G0_0_1_5_1_2 + 0.000909090909090941*G0_0_1_5_1_3 + 0.000562770562770582*G0_0_1_5_1_4 - 0.0032900432900434*G0_0_1_5_1_5 - 0.000238095238095246*G0_0_1_5_2_0 - 0.00018398268398269*G0_0_1_5_2_1 - 0.000243506493506505*G0_0_1_5_2_2 + 0.00056277056277058*G0_0_1_5_2_3 + 0.000476190476190491*G0_0_1_5_2_4 + 0.000519480519480536*G0_0_1_5_2_5 + 0.000735930735930759*G0_0_1_5_3_0 + 0.000909090909090941*G0_0_1_5_3_1 + 0.00056277056277058*G0_0_1_5_3_2 - 0.00138528138528142*G0_0_1_5_3_3 - 0.00259740259740268*G0_0_1_5_3_4 - 0.00251082251082259*G0_0_1_5_3_5 + 0.00103896103896107*G0_0_1_5_4_0 + 0.000562770562770582*G0_0_1_5_4_1 + 0.000476190476190491*G0_0_1_5_4_2 - 0.00259740259740268*G0_0_1_5_4_3 - 0.000173160173160182*G0_0_1_5_4_4 - 0.00216450216450223*G0_0_1_5_4_5 + 0.00380952380952394*G0_0_1_5_5_0 - 0.0032900432900434*G0_0_1_5_5_1 + 0.000519480519480536*G0_0_1_5_5_2 - 0.00251082251082259*G0_0_1_5_5_3 - 0.00216450216450223*G0_0_1_5_5_4 + 0.000779220779220838*G0_0_1_5_5_5;
    A[45] = A[73] + 0.0100446428571433*G0_0_0_0_0_0 - 0.000742694805194835*G0_0_0_0_0_1 - 0.00192370129870137*G0_0_0_0_0_2 + 0.00126623376623381*G0_0_0_0_0_3 + 0.00730519480519508*G0_0_0_0_0_4 + 0.00413961038961055*G0_0_0_0_0_5 - 0.000742694805194835*G0_0_0_0_1_0 + 0.00102272727272731*G0_0_0_0_1_1 + 0.000328733766233777*G0_0_0_0_1_2 + 0.00185064935064941*G0_0_0_0_1_3 - 0.00116883116883121*G0_0_0_0_1_4 - 0.000487012987013007*G0_0_0_0_1_5 - 0.00192370129870137*G0_0_0_0_2_0 + 0.000328733766233777*G0_0_0_0_2_1 - 0.00444399350649366*G0_0_0_0_2_2 - 0.00189935064935071*G0_0_0_0_2_3 - 0.000779220779220819*G0_0_0_0_2_4 + 0.000681818181818198*G0_0_0_0_2_5 + 0.00126623376623381*G0_0_0_0_3_0 + 0.00185064935064941*G0_0_0_0_3_1 - 0.00189935064935071*G0_0_0_0_3_2 - 0.00194805194805201*G0_0_0_0_3_3 - 0.000194805194805196*G0_0_0_0_3_4 - 0.00389610389610401*G0_0_0_0_3_5 + 0.00730519480519508*G0_0_0_0_4_0 - 0.00116883116883121*G0_0_0_0_4_1 - 0.000779220779220819*G0_0_0_0_4_2 - 0.000194805194805196*G0_0_0_0_4_3 + 0.0227922077922086*G0_0_0_0_4_4 + 0.000974025974026026*G0_0_0_0_4_5 + 0.00413961038961055*G0_0_0_0_5_0 - 0.000487012987013007*G0_0_0_0_5_1 + 0.000681818181818198*G0_0_0_0_5_2 - 0.00389610389610401*G0_0_0_0_5_3 + 0.000974025974026025*G0_0_0_0_5_4 - 0.00623376623376641*G0_0_0_0_5_5 - 0.000742694805194835*G0_0_0_1_0_0 + 0.00102272727272731*G0_0_0_1_0_1 + 0.000328733766233777*G0_0_0_1_0_2 + 0.00185064935064941*G0_0_0_1_0_3 - 0.00116883116883121*G0_0_0_1_0_4 - 0.000487012987013007*G0_0_0_1_0_5 + 0.00102272727272731*G0_0_0_1_1_0 - 0.0217694805194813*G0_0_0_1_1_1 + 0.00462662337662354*G0_0_0_1_1_2 - 0.0151948051948057*G0_0_0_1_1_3 - 0.00233766233766244*G0_0_0_1_1_5 + 0.000328733766233777*G0_0_0_1_2_0 + 0.00462662337662354*G0_0_0_1_2_1 - 0.0101420454545458*G0_0_0_1_2_2 - 0.00146103896103901*G0_0_0_1_2_3 - 0.000243506493506505*G0_0_0_1_2_4 + 0.00126623376623381*G0_0_0_1_2_5 + 0.00185064935064941*G0_0_0_1_3_0 - 0.0151948051948057*G0_0_0_1_3_1 - 0.00146103896103901*G0_0_0_1_3_2 - 0.0397402597402611*G0_0_0_1_3_3 - 0.00350649350649362*G0_0_0_1_3_4 - 0.00623376623376646*G0_0_0_1_3_5 - 0.00116883116883121*G0_0_0_1_4_0 - 0.000243506493506505*G0_0_0_1_4_2 - 0.00350649350649362*G0_0_0_1_4_3 + 0.00253246753246761*G0_0_0_1_4_4 - 0.00233766233766241*G0_0_0_1_4_5 - 0.000487012987013007*G0_0_0_1_5_0 - 0.00233766233766244*G0_0_0_1_5_1 + 0.00126623376623381*G0_0_0_1_5_2 - 0.00623376623376646*G0_0_0_1_5_3 - 0.00233766233766241*G0_0_0_1_5_4 - 0.00272727272727282*G0_0_0_1_5_5 - 0.00192370129870137*G0_0_0_2_0_0 + 0.000328733766233777*G0_0_0_2_0_1 - 0.00444399350649366*G0_0_0_2_0_2 - 0.00189935064935071*G0_0_0_2_0_3 - 0.000779220779220819*G0_0_0_2_0_4 + 0.000681818181818197*G0_0_0_2_0_5 + 0.000328733766233777*G0_0_0_2_1_0 + 0.00462662337662354*G0_0_0_2_1_1 - 0.0101420454545458*G0_0_0_2_1_2 - 0.00146103896103901*G0_0_0_2_1_3 - 0.000243506493506505*G0_0_0_2_1_4 + 0.00126623376623381*G0_0_0_2_1_5 - 0.00444399350649366*G0_0_0_2_2_0 - 0.0101420454545458*G0_0_0_2_2_1 + 0.11761363636364*G0_0_0_2_2_2 + 0.0401298701298715*G0_0_0_2_2_3 + 0.018311688311689*G0_0_0_2_2_4 + 0.00326298701298714*G0_0_0_2_2_5 - 0.00189935064935071*G0_0_0_2_3_0 - 0.00146103896103901*G0_0_0_2_3_1 + 0.0401298701298715*G0_0_0_2_3_2 + 0.0436363636363652*G0_0_0_2_3_3 + 0.00428571428571445*G0_0_0_2_3_4 - 0.0027272727272728*G0_0_0_2_3_5 - 0.000779220779220819*G0_0_0_2_4_0 - 0.000243506493506505*G0_0_0_2_4_1 + 0.018311688311689*G0_0_0_2_4_2 + 0.00428571428571445*G0_0_0_2_4_3 - 0.0171428571428577*G0_0_0_2_4_4 - 0.00603896103896123*G0_0_0_2_4_5 + 0.000681818181818198*G0_0_0_2_5_0 + 0.00126623376623381*G0_0_0_2_5_1 + 0.00326298701298714*G0_0_0_2_5_2 - 0.0027272727272728*G0_0_0_2_5_3 - 0.00603896103896123*G0_0_0_2_5_4 - 0.0109090909090913*G0_0_0_2_5_5 + 0.00126623376623381*G0_0_0_3_0_0 + 0.00185064935064941*G0_0_0_3_0_1 - 0.00189935064935071*G0_0_0_3_0_2 - 0.00194805194805201*G0_0_0_3_0_3 - 0.000194805194805197*G0_0_0_3_0_4 - 0.00389610389610401*G0_0_0_3_0_5 + 0.00185064935064941*G0_0_0_3_1_0 - 0.0151948051948057*G0_0_0_3_1_1 - 0.00146103896103901*G0_0_0_3_1_2 - 0.0397402597402611*G0_0_0_3_1_3 - 0.00350649350649362*G0_0_0_3_1_4 - 0.00623376623376646*G0_0_0_3_1_5 - 0.00189935064935071*G0_0_0_3_2_0 - 0.00146103896103901*G0_0_0_3_2_1 + 0.0401298701298715*G0_0_0_3_2_2 + 0.0436363636363652*G0_0_0_3_2_3 + 0.00428571428571445*G0_0_0_3_2_4 - 0.0027272727272728*G0_0_0_3_2_5 - 0.00194805194805201*G0_0_0_3_3_0 - 0.0397402597402611*G0_0_0_3_3_1 + 0.0436363636363652*G0_0_0_3_3_2 - 0.0607792207792228*G0_0_0_3_3_3 + 0.0109090909090913*G0_0_0_3_3_4 + 0.00935064935064961*G0_0_0_3_3_5 - 0.000194805194805197*G0_0_0_3_4_0 - 0.00350649350649362*G0_0_0_3_4_1 + 0.00428571428571445*G0_0_0_3_4_2 + 0.0109090909090913*G0_0_0_3_4_3 - 0.00467532467532483*G0_0_0_3_4_4 + 0.0124675324675329*G0_0_0_3_4_5 - 0.00389610389610401*G0_0_0_3_5_0 - 0.00623376623376646*G0_0_0_3_5_1 - 0.0027272727272728*G0_0_0_3_5_2 + 0.00935064935064961*G0_0_0_3_5_3 + 0.0124675324675329*G0_0_0_3_5_4 + 0.0296103896103906*G0_0_0_3_5_5 + 0.00730519480519508*G0_0_0_4_0_0 - 0.00116883116883121*G0_0_0_4_0_1 - 0.000779220779220819*G0_0_0_4_0_2 - 0.000194805194805196*G0_0_0_4_0_3 + 0.0227922077922086*G0_0_0_4_0_4 + 0.000974025974026026*G0_0_0_4_0_5 - 0.00116883116883121*G0_0_0_4_1_0 - 0.000243506493506505*G0_0_0_4_1_2 - 0.00350649350649362*G0_0_0_4_1_3 + 0.00253246753246761*G0_0_0_4_1_4 - 0.00233766233766241*G0_0_0_4_1_5 - 0.000779220779220819*G0_0_0_4_2_0 - 0.000243506493506505*G0_0_0_4_2_1 + 0.018311688311689*G0_0_0_4_2_2 + 0.00428571428571445*G0_0_0_4_2_3 - 0.0171428571428577*G0_0_0_4_2_4 - 0.00603896103896123*G0_0_0_4_2_5 - 0.000194805194805196*G0_0_0_4_3_0 - 0.00350649350649362*G0_0_0_4_3_1 + 0.00428571428571445*G0_0_0_4_3_2 + 0.0109090909090913*G0_0_0_4_3_3 - 0.00467532467532483*G0_0_0_4_3_4 + 0.0124675324675329*G0_0_0_4_3_5 + 0.0227922077922086*G0_0_0_4_4_0 + 0.00253246753246761*G0_0_0_4_4_1 - 0.0171428571428577*G0_0_0_4_4_2 - 0.00467532467532483*G0_0_0_4_4_3 - 0.0748051948051971*G0_0_0_4_4_4 + 0.00701298701298723*G0_0_0_4_4_5 + 0.000974025974026026*G0_0_0_4_5_0 - 0.00233766233766241*G0_0_0_4_5_1 - 0.00603896103896123*G0_0_0_4_5_2 + 0.0124675324675329*G0_0_0_4_5_3 + 0.00701298701298724*G0_0_0_4_5_4 + 0.0264935064935074*G0_0_0_4_5_5 + 0.00413961038961055*G0_0_0_5_0_0 - 0.000487012987013007*G0_0_0_5_0_1 + 0.000681818181818197*G0_0_0_5_0_2 - 0.00389610389610401*G0_0_0_5_0_3 + 0.000974025974026026*G0_0_0_5_0_4 - 0.00623376623376641*G0_0_0_5_0_5 - 0.000487012987013007*G0_0_0_5_1_0 - 0.00233766233766244*G0_0_0_5_1_1 + 0.00126623376623381*G0_0_0_5_1_2 - 0.00623376623376646*G0_0_0_5_1_3 - 0.00233766233766241*G0_0_0_5_1_4 - 0.00272727272727282*G0_0_0_5_1_5 + 0.000681818181818197*G0_0_0_5_2_0 + 0.00126623376623381*G0_0_0_5_2_1 + 0.00326298701298714*G0_0_0_5_2_2 - 0.0027272727272728*G0_0_0_5_2_3 - 0.00603896103896123*G0_0_0_5_2_4 - 0.0109090909090913*G0_0_0_5_2_5 - 0.00389610389610401*G0_0_0_5_3_0 - 0.00623376623376646*G0_0_0_5_3_1 - 0.0027272727272728*G0_0_0_5_3_2 + 0.00935064935064961*G0_0_0_5_3_3 + 0.0124675324675329*G0_0_0_5_3_4 + 0.0296103896103906*G0_0_0_5_3_5 + 0.000974025974026026*G0_0_0_5_4_0 - 0.00233766233766241*G0_0_0_5_4_1 - 0.00603896103896123*G0_0_0_5_4_2 + 0.0124675324675329*G0_0_0_5_4_3 + 0.00701298701298723*G0_0_0_5_4_4 + 0.0264935064935074*G0_0_0_5_4_5 - 0.00623376623376641*G0_0_0_5_5_0 - 0.00272727272727282*G0_0_0_5_5_1 - 0.0109090909090913*G0_0_0_5_5_2 + 0.0296103896103906*G0_0_0_5_5_3 + 0.0264935064935074*G0_0_0_5_5_4 + 0.0794805194805222*G0_0_0_5_5_5 + 0.000158279220779237*G0_0_1_0_0_1 - 0.000158279220779216*G0_0_1_0_0_2 - 0.00219155844155854*G0_0_1_0_0_4 + 0.00219155844155846*G0_0_1_0_0_5 + 0.000158279220779237*G0_0_1_0_1_0 + 0.0040300324675326*G0_0_1_0_1_1 + 0.00185064935064941*G0_0_1_0_1_3 - 0.0011688311688312*G0_0_1_0_1_4 - 0.0016558441558442*G0_0_1_0_1_5 - 0.000158279220779216*G0_0_1_0_2_0 - 0.00403003246753261*G0_0_1_0_2_2 - 0.00185064935064941*G0_0_1_0_2_3 + 0.0016558441558442*G0_0_1_0_2_4 + 0.00116883116883121*G0_0_1_0_2_5 + 0.00185064935064941*G0_0_1_0_3_1 - 0.00185064935064941*G0_0_1_0_3_2 + 0.00233766233766241*G0_0_1_0_3_4 - 0.00233766233766241*G0_0_1_0_3_5 - 0.00219155844155854*G0_0_1_0_4_0 - 0.0011688311688312*G0_0_1_0_4_1 + 0.0016558441558442*G0_0_1_0_4_2 + 0.00233766233766241*G0_0_1_0_4_3 + 0.0138311688311693*G0_0_1_0_4_4 + 0.00219155844155846*G0_0_1_0_5_0 - 0.0016558441558442*G0_0_1_0_5_1 + 0.00116883116883121*G0_0_1_0_5_2 - 0.00233766233766241*G0_0_1_0_5_3 - 0.0138311688311693*G0_0_1_0_5_5 + 0.000158279220779237*G0_0_1_1_0_0 + 0.0040300324675326*G0_0_1_1_0_1 + 0.00185064935064941*G0_0_1_1_0_3 - 0.0011688311688312*G0_0_1_1_0_4 - 0.0016558441558442*G0_0_1_1_0_5 + 0.0040300324675326*G0_0_1_1_1_0 - 0.111732954545458*G0_0_1_1_1_1 + 0.00986201298701333*G0_0_1_1_1_2 - 0.0375974025974039*G0_0_1_1_1_3 - 0.0018506493506494*G0_0_1_1_1_4 - 0.0137824675324681*G0_0_1_1_1_5 + 0.00986201298701333*G0_0_1_1_2_1 - 0.00986201298701333*G0_0_1_1_2_2 - 0.000681818181818209*G0_0_1_1_2_4 + 0.000681818181818211*G0_0_1_1_2_5 + 0.00185064935064941*G0_0_1_1_3_0 - 0.0375974025974039*G0_0_1_1_3_1 - 0.0459740259740276*G0_0_1_1_3_3 - 0.00506493506493528*G0_0_1_1_3_5 - 0.0011688311688312*G0_0_1_1_4_0 - 0.0018506493506494*G0_0_1_1_4_1 - 0.000681818181818209*G0_0_1_1_4_2 + 0.00779220779220804*G0_0_1_1_4_4 + 0.00233766233766241*G0_0_1_1_4_5 - 0.0016558441558442*G0_0_1_1_5_0 - 0.0137824675324681*G0_0_1_1_5_1 + 0.000681818181818211*G0_0_1_1_5_2 - 0.00506493506493528*G0_0_1_1_5_3 + 0.00233766233766241*G0_0_1_1_5_4 + 0.0126623376623381*G0_0_1_1_5_5 - 0.000158279220779216*G0_0_1_2_0_0 - 0.00403003246753261*G0_0_1_2_0_2 - 0.00185064935064941*G0_0_1_2_0_3 + 0.00165584415584421*G0_0_1_2_0_4 + 0.00116883116883121*G0_0_1_2_0_5 + 0.00986201298701333*G0_0_1_2_1_1 - 0.00986201298701333*G0_0_1_2_1_2 - 0.000681818181818209*G0_0_1_2_1_4 + 0.000681818181818211*G0_0_1_2_1_5 - 0.00403003246753261*G0_0_1_2_2_0 - 0.00986201298701333*G0_0_1_2_2_1 + 0.111732954545458*G0_0_1_2_2_2 + 0.0375974025974039*G0_0_1_2_2_3 + 0.0137824675324681*G0_0_1_2_2_4 + 0.00185064935064943*G0_0_1_2_2_5 - 0.00185064935064941*G0_0_1_2_3_0 + 0.0375974025974039*G0_0_1_2_3_2 + 0.0459740259740276*G0_0_1_2_3_3 + 0.00506493506493525*G0_0_1_2_3_4 + 0.0016558441558442*G0_0_1_2_4_0 - 0.000681818181818208*G0_0_1_2_4_1 + 0.0137824675324681*G0_0_1_2_4_2 + 0.00506493506493525*G0_0_1_2_4_3 - 0.012662337662338*G0_0_1_2_4_4 - 0.00233766233766241*G0_0_1_2_4_5 + 0.00116883116883121*G0_0_1_2_5_0 + 0.000681818181818211*G0_0_1_2_5_1 + 0.00185064935064943*G0_0_1_2_5_2 - 0.00233766233766241*G0_0_1_2_5_4 - 0.00779220779220805*G0_0_1_2_5_5 + 0.00185064935064941*G0_0_1_3_0_1 - 0.00185064935064941*G0_0_1_3_0_2 + 0.00233766233766241*G0_0_1_3_0_4 - 0.00233766233766241*G0_0_1_3_0_5 + 0.00185064935064941*G0_0_1_3_1_0 - 0.0375974025974039*G0_0_1_3_1_1 - 0.0459740259740276*G0_0_1_3_1_3 - 0.00506493506493528*G0_0_1_3_1_5 - 0.00185064935064941*G0_0_1_3_2_0 + 0.0375974025974039*G0_0_1_3_2_2 + 0.0459740259740276*G0_0_1_3_2_3 + 0.00506493506493525*G0_0_1_3_2_4 - 0.0459740259740276*G0_0_1_3_3_1 + 0.0459740259740276*G0_0_1_3_3_2 + 0.00233766233766241*G0_0_1_3_4_0 + 0.00506493506493525*G0_0_1_3_4_2 - 0.0202597402597409*G0_0_1_3_4_4 - 0.00233766233766241*G0_0_1_3_5_0 - 0.00506493506493528*G0_0_1_3_5_1 + 0.0202597402597409*G0_0_1_3_5_5 - 0.00219155844155854*G0_0_1_4_0_0 - 0.0011688311688312*G0_0_1_4_0_1 + 0.0016558441558442*G0_0_1_4_0_2 + 0.00233766233766241*G0_0_1_4_0_3 + 0.0138311688311693*G0_0_1_4_0_4 - 0.0011688311688312*G0_0_1_4_1_0 - 0.0018506493506494*G0_0_1_4_1_1 - 0.000681818181818209*G0_0_1_4_1_2 + 0.00779220779220804*G0_0_1_4_1_4 + 0.00233766233766241*G0_0_1_4_1_5 + 0.0016558441558442*G0_0_1_4_2_0 - 0.000681818181818208*G0_0_1_4_2_1 + 0.0137824675324681*G0_0_1_4_2_2 + 0.00506493506493525*G0_0_1_4_2_3 - 0.012662337662338*G0_0_1_4_2_4 - 0.00233766233766241*G0_0_1_4_2_5 + 0.00233766233766241*G0_0_1_4_3_0 + 0.00506493506493525*G0_0_1_4_3_2 - 0.0202597402597409*G0_0_1_4_3_4 + 0.0138311688311692*G0_0_1_4_4_0 + 0.00779220779220804*G0_0_1_4_4_1 - 0.012662337662338*G0_0_1_4_4_2 - 0.0202597402597409*G0_0_1_4_4_3 - 0.119220779220783*G0_0_1_4_4_4 - 0.0109090909090913*G0_0_1_4_4_5 + 0.00233766233766241*G0_0_1_4_5_1 - 0.00233766233766241*G0_0_1_4_5_2 - 0.0109090909090913*G0_0_1_4_5_4 + 0.0109090909090913*G0_0_1_4_5_5 + 0.00219155844155846*G0_0_1_5_0_0 - 0.0016558441558442*G0_0_1_5_0_1 + 0.00116883116883121*G0_0_1_5_0_2 - 0.00233766233766241*G0_0_1_5_0_3 - 0.0138311688311693*G0_0_1_5_0_5 - 0.0016558441558442*G0_0_1_5_1_0 - 0.0137824675324681*G0_0_1_5_1_1 + 0.000681818181818211*G0_0_1_5_1_2 - 0.00506493506493528*G0_0_1_5_1_3 + 0.00233766233766241*G0_0_1_5_1_4 + 0.0126623376623381*G0_0_1_5_1_5 + 0.00116883116883121*G0_0_1_5_2_0 + 0.000681818181818211*G0_0_1_5_2_1 + 0.00185064935064943*G0_0_1_5_2_2 - 0.00233766233766241*G0_0_1_5_2_4 - 0.00779220779220805*G0_0_1_5_2_5 - 0.00233766233766241*G0_0_1_5_3_0 - 0.00506493506493528*G0_0_1_5_3_1 + 0.0202597402597409*G0_0_1_5_3_5 + 0.00233766233766241*G0_0_1_5_4_1 - 0.00233766233766241*G0_0_1_5_4_2 - 0.0109090909090913*G0_0_1_5_4_4 + 0.0109090909090913*G0_0_1_5_4_5 - 0.0138311688311693*G0_0_1_5_5_0 + 0.0126623376623381*G0_0_1_5_5_1 - 0.00779220779220805*G0_0_1_5_5_2 + 0.0202597402597409*G0_0_1_5_5_3 + 0.0109090909090913*G0_0_1_5_5_4 + 0.119220779220783*G0_0_1_5_5_5 - 0.001461038961039*G0_1_0_0_0_4 + 0.00146103896103902*G0_1_0_0_0_5 + 0.00138798701298706*G0_1_0_0_1_1 + 0.00146103896103901*G0_1_0_0_1_3 - 0.000584415584415603*G0_1_0_0_1_4 - 0.000584415584415608*G0_1_0_0_1_5 - 0.00138798701298706*G0_1_0_0_2_2 - 0.00146103896103901*G0_1_0_0_2_3 + 0.000584415584415595*G0_1_0_0_2_4 + 0.000584415584415601*G0_1_0_0_2_5 + 0.00146103896103901*G0_1_0_0_3_1 - 0.00146103896103901*G0_1_0_0_3_2 + 0.00116883116883121*G0_1_0_0_3_4 - 0.0011688311688312*G0_1_0_0_3_5 - 0.001461038961039*G0_1_0_0_4_0 - 0.000584415584415603*G0_1_0_0_4_1 + 0.000584415584415595*G0_1_0_0_4_2 + 0.00116883116883121*G0_1_0_0_4_3 + 0.00350649350649361*G0_1_0_0_4_4 + 0.00146103896103902*G0_1_0_0_5_0 - 0.000584415584415608*G0_1_0_0_5_1 + 0.000584415584415601*G0_1_0_0_5_2 - 0.0011688311688312*G0_1_0_0_5_3 - 0.0035064935064936*G0_1_0_0_5_5 + 0.00138798701298706*G0_1_0_1_0_1 + 0.00146103896103901*G0_1_0_1_0_3 - 0.000584415584415603*G0_1_0_1_0_4 - 0.000584415584415608*G0_1_0_1_0_5 + 0.00138798701298706*G0_1_0_1_1_0 - 0.0241071428571436*G0_1_0_1_1_1 + 0.00445616883116898*G0_1_0_1_1_2 - 0.0163636363636369*G0_1_0_1_1_3 - 0.00146103896103901*G0_1_0_1_1_4 - 0.00409090909090923*G0_1_0_1_1_5 + 0.00445616883116898*G0_1_0_1_2_1 - 0.00445616883116899*G0_1_0_1_2_2 - 0.000876623376623408*G0_1_0_1_2_4 + 0.000876623376623409*G0_1_0_1_2_5 + 0.00146103896103901*G0_1_0_1_3_0 - 0.0163636363636369*G0_1_0_1_3_1 - 0.0350649350649363*G0_1_0_1_3_3 - 0.00467532467532485*G0_1_0_1_3_5 - 0.000584415584415603*G0_1_0_1_4_0 - 0.00146103896103901*G0_1_0_1_4_1 - 0.000876623376623408*G0_1_0_1_4_2 + 0.00818181818181844*G0_1_0_1_4_4 + 0.00116883116883121*G0_1_0_1_4_5 - 0.000584415584415608*G0_1_0_1_5_0 - 0.00409090909090923*G0_1_0_1_5_1 + 0.000876623376623409*G0_1_0_1_5_2 - 0.00467532467532485*G0_1_0_1_5_3 + 0.0011688311688312*G0_1_0_1_5_4 - 0.00233766233766241*G0_1_0_1_5_5 - 0.00138798701298706*G0_1_0_2_0_2 - 0.00146103896103901*G0_1_0_2_0_3 + 0.000584415584415596*G0_1_0_2_0_4 + 0.000584415584415601*G0_1_0_2_0_5 + 0.00445616883116898*G0_1_0_2_1_1 - 0.00445616883116899*G0_1_0_2_1_2 - 0.000876623376623408*G0_1_0_2_1_4 + 0.000876623376623409*G0_1_0_2_1_5 - 0.00138798701298706*G0_1_0_2_2_0 - 0.00445616883116899*G0_1_0_2_2_1 + 0.0241071428571438*G0_1_0_2_2_2 + 0.0163636363636369*G0_1_0_2_2_3 + 0.00409090909090926*G0_1_0_2_2_4 + 0.00146103896103902*G0_1_0_2_2_5 - 0.00146103896103901*G0_1_0_2_3_0 + 0.0163636363636369*G0_1_0_2_3_2 + 0.0350649350649363*G0_1_0_2_3_3 + 0.00467532467532484*G0_1_0_2_3_4 + 0.000584415584415596*G0_1_0_2_4_0 - 0.000876623376623407*G0_1_0_2_4_1 + 0.00409090909090926*G0_1_0_2_4_2 + 0.00467532467532484*G0_1_0_2_4_3 + 0.00233766233766244*G0_1_0_2_4_4 - 0.00116883116883121*G0_1_0_2_4_5 + 0.0005844155844156*G0_1_0_2_5_0 + 0.000876623376623409*G0_1_0_2_5_1 + 0.00146103896103902*G0_1_0_2_5_2 - 0.00116883116883121*G0_1_0_2_5_4 - 0.00818181818181846*G0_1_0_2_5_5 + 0.00146103896103901*G0_1_0_3_0_1 - 0.00146103896103901*G0_1_0_3_0_2 + 0.00116883116883121*G0_1_0_3_0_4 - 0.0011688311688312*G0_1_0_3_0_5 + 0.00146103896103901*G0_1_0_3_1_0 - 0.0163636363636369*G0_1_0_3_1_1 - 0.0350649350649363*G0_1_0_3_1_3 - 0.00467532467532485*G0_1_0_3_1_5 - 0.00146103896103901*G0_1_0_3_2_0 + 0.0163636363636369*G0_1_0_3_2_2 + 0.0350649350649363*G0_1_0_3_2_3 + 0.00467532467532484*G0_1_0_3_2_4 - 0.0350649350649363*G0_1_0_3_3_1 + 0.0350649350649363*G0_1_0_3_3_2 + 0.00116883116883121*G0_1_0_3_4_0 + 0.00467532467532484*G0_1_0_3_4_2 - 0.0187012987012993*G0_1_0_3_4_4 - 0.0011688311688312*G0_1_0_3_5_0 - 0.00467532467532485*G0_1_0_3_5_1 + 0.0187012987012993*G0_1_0_3_5_5 - 0.001461038961039*G0_1_0_4_0_0 - 0.000584415584415603*G0_1_0_4_0_1 + 0.000584415584415596*G0_1_0_4_0_2 + 0.00116883116883121*G0_1_0_4_0_3 + 0.00350649350649361*G0_1_0_4_0_4 - 0.000584415584415603*G0_1_0_4_1_0 - 0.00146103896103901*G0_1_0_4_1_1 - 0.000876623376623407*G0_1_0_4_1_2 + 0.00818181818181844*G0_1_0_4_1_4 + 0.00116883116883121*G0_1_0_4_1_5 + 0.000584415584415596*G0_1_0_4_2_0 - 0.000876623376623408*G0_1_0_4_2_1 + 0.00409090909090926*G0_1_0_4_2_2 + 0.00467532467532484*G0_1_0_4_2_3 + 0.00233766233766243*G0_1_0_4_2_4 - 0.00116883116883121*G0_1_0_4_2_5 + 0.00116883116883121*G0_1_0_4_3_0 + 0.00467532467532484*G0_1_0_4_3_2 - 0.0187012987012993*G0_1_0_4_3_4 + 0.00350649350649361*G0_1_0_4_4_0 + 0.00818181818181844*G0_1_0_4_4_1 + 0.00233766233766244*G0_1_0_4_4_2 - 0.0187012987012993*G0_1_0_4_4_3 - 0.0841558441558467*G0_1_0_4_4_4 - 0.0140259740259745*G0_1_0_4_4_5 + 0.00116883116883121*G0_1_0_4_5_1 - 0.00116883116883121*G0_1_0_4_5_2 - 0.0140259740259745*G0_1_0_4_5_4 + 0.0140259740259745*G0_1_0_4_5_5 + 0.00146103896103902*G0_1_0_5_0_0 - 0.000584415584415608*G0_1_0_5_0_1 + 0.000584415584415601*G0_1_0_5_0_2 - 0.0011688311688312*G0_1_0_5_0_3 - 0.0035064935064936*G0_1_0_5_0_5 - 0.000584415584415608*G0_1_0_5_1_0 - 0.00409090909090923*G0_1_0_5_1_1 + 0.000876623376623409*G0_1_0_5_1_2 - 0.00467532467532485*G0_1_0_5_1_3 + 0.0011688311688312*G0_1_0_5_1_4 - 0.00233766233766241*G0_1_0_5_1_5 + 0.000584415584415601*G0_1_0_5_2_0 + 0.000876623376623409*G0_1_0_5_2_1 + 0.00146103896103902*G0_1_0_5_2_2 - 0.00116883116883121*G0_1_0_5_2_4 - 0.00818181818181846*G0_1_0_5_2_5 - 0.0011688311688312*G0_1_0_5_3_0 - 0.00467532467532485*G0_1_0_5_3_1 + 0.0187012987012993*G0_1_0_5_3_5 + 0.00116883116883121*G0_1_0_5_4_1 - 0.00116883116883121*G0_1_0_5_4_2 - 0.0140259740259745*G0_1_0_5_4_4 + 0.0140259740259745*G0_1_0_5_4_5 - 0.0035064935064936*G0_1_0_5_5_0 - 0.00233766233766241*G0_1_0_5_5_1 - 0.00818181818181846*G0_1_0_5_5_2 + 0.0187012987012993*G0_1_0_5_5_3 + 0.0140259740259745*G0_1_0_5_5_4 + 0.0841558441558471*G0_1_0_5_5_5 - 0.0100446428571433*G0_1_1_0_0_0 + 0.00192370129870137*G0_1_1_0_0_1 + 0.000742694805194837*G0_1_1_0_0_2 - 0.00126623376623381*G0_1_1_0_0_3 - 0.00413961038961055*G0_1_1_0_0_4 - 0.0073051948051951*G0_1_1_0_0_5 + 0.00192370129870137*G0_1_1_0_1_0 + 0.00444399350649365*G0_1_1_0_1_1 - 0.000328733766233779*G0_1_1_0_1_2 + 0.00189935064935072*G0_1_1_0_1_3 - 0.000681818181818198*G0_1_1_0_1_4 + 0.000779220779220817*G0_1_1_0_1_5 + 0.000742694805194837*G0_1_1_0_2_0 - 0.000328733766233779*G0_1_1_0_2_1 - 0.00102272727272731*G0_1_1_0_2_2 - 0.00185064935064941*G0_1_1_0_2_3 + 0.000487012987013005*G0_1_1_0_2_4 + 0.00116883116883121*G0_1_1_0_2_5 - 0.00126623376623381*G0_1_1_0_3_0 + 0.00189935064935072*G0_1_1_0_3_1 - 0.00185064935064941*G0_1_1_0_3_2 + 0.00194805194805202*G0_1_1_0_3_3 + 0.00389610389610401*G0_1_1_0_3_4 + 0.000194805194805197*G0_1_1_0_3_5 - 0.00413961038961055*G0_1_1_0_4_0 - 0.000681818181818199*G0_1_1_0_4_1 + 0.000487012987013005*G0_1_1_0_4_2 + 0.00389610389610401*G0_1_1_0_4_3 + 0.0062337662337664*G0_1_1_0_4_4 - 0.000974025974026021*G0_1_1_0_4_5 - 0.0073051948051951*G0_1_1_0_5_0 + 0.000779220779220817*G0_1_1_0_5_1 + 0.00116883116883121*G0_1_1_0_5_2 + 0.000194805194805197*G0_1_1_0_5_3 - 0.00097402597402602*G0_1_1_0_5_4 - 0.0227922077922086*G0_1_1_0_5_5 + 0.00192370129870137*G0_1_1_1_0_0 + 0.00444399350649365*G0_1_1_1_0_1 - 0.000328733766233779*G0_1_1_1_0_2 + 0.00189935064935072*G0_1_1_1_0_3 - 0.000681818181818198*G0_1_1_1_0_4 + 0.000779220779220817*G0_1_1_1_0_5 + 0.00444399350649365*G0_1_1_1_1_0 - 0.11761363636364*G0_1_1_1_1_1 + 0.0101420454545458*G0_1_1_1_1_2 - 0.0401298701298715*G0_1_1_1_1_3 - 0.00326298701298711*G0_1_1_1_1_4 - 0.018311688311689*G0_1_1_1_1_5 - 0.000328733766233779*G0_1_1_1_2_0 + 0.0101420454545458*G0_1_1_1_2_1 - 0.00462662337662354*G0_1_1_1_2_2 + 0.00146103896103901*G0_1_1_1_2_3 - 0.00126623376623381*G0_1_1_1_2_4 + 0.000243506493506512*G0_1_1_1_2_5 + 0.00189935064935072*G0_1_1_1_3_0 - 0.0401298701298715*G0_1_1_1_3_1 + 0.00146103896103901*G0_1_1_1_3_2 - 0.0436363636363652*G0_1_1_1_3_3 + 0.0027272727272728*G0_1_1_1_3_4 - 0.00428571428571449*G0_1_1_1_3_5 - 0.000681818181818199*G0_1_1_1_4_0 - 0.00326298701298711*G0_1_1_1_4_1 - 0.00126623376623381*G0_1_1_1_4_2 + 0.0027272727272728*G0_1_1_1_4_3 + 0.0109090909090912*G0_1_1_1_4_4 + 0.00603896103896123*G0_1_1_1_4_5 + 0.000779220779220817*G0_1_1_1_5_0 - 0.018311688311689*G0_1_1_1_5_1 + 0.000243506493506512*G0_1_1_1_5_2 - 0.00428571428571449*G0_1_1_1_5_3 + 0.00603896103896123*G0_1_1_1_5_4 + 0.0171428571428577*G0_1_1_1_5_5 + 0.000742694805194837*G0_1_1_2_0_0 - 0.000328733766233779*G0_1_1_2_0_1 - 0.00102272727272731*G0_1_1_2_0_2 - 0.00185064935064941*G0_1_1_2_0_3 + 0.000487012987013005*G0_1_1_2_0_4 + 0.00116883116883121*G0_1_1_2_0_5 - 0.000328733766233779*G0_1_1_2_1_0 + 0.0101420454545458*G0_1_1_2_1_1 - 0.00462662337662354*G0_1_1_2_1_2 + 0.00146103896103901*G0_1_1_2_1_3 - 0.00126623376623381*G0_1_1_2_1_4 + 0.000243506493506512*G0_1_1_2_1_5 - 0.00102272727272731*G0_1_1_2_2_0 - 0.00462662337662354*G0_1_1_2_2_1 + 0.0217694805194813*G0_1_1_2_2_2 + 0.0151948051948057*G0_1_1_2_2_3 + 0.00233766233766243*G0_1_1_2_2_4 - 0.00185064935064941*G0_1_1_2_3_0 + 0.00146103896103901*G0_1_1_2_3_1 + 0.0151948051948057*G0_1_1_2_3_2 + 0.0397402597402611*G0_1_1_2_3_3 + 0.00623376623376644*G0_1_1_2_3_4 + 0.00350649350649363*G0_1_1_2_3_5 + 0.000487012987013005*G0_1_1_2_4_0 - 0.00126623376623381*G0_1_1_2_4_1 + 0.00233766233766243*G0_1_1_2_4_2 + 0.00623376623376645*G0_1_1_2_4_3 + 0.00272727272727282*G0_1_1_2_4_4 + 0.00233766233766241*G0_1_1_2_4_5 + 0.00116883116883121*G0_1_1_2_5_0 + 0.000243506493506511*G0_1_1_2_5_1 + 0.00350649350649363*G0_1_1_2_5_3 + 0.00233766233766241*G0_1_1_2_5_4 - 0.00253246753246763*G0_1_1_2_5_5 - 0.00126623376623381*G0_1_1_3_0_0 + 0.00189935064935072*G0_1_1_3_0_1 - 0.00185064935064941*G0_1_1_3_0_2 + 0.00194805194805201*G0_1_1_3_0_3 + 0.00389610389610401*G0_1_1_3_0_4 + 0.000194805194805197*G0_1_1_3_0_5 + 0.00189935064935072*G0_1_1_3_1_0 - 0.0401298701298715*G0_1_1_3_1_1 + 0.00146103896103901*G0_1_1_3_1_2 - 0.0436363636363652*G0_1_1_3_1_3 + 0.0027272727272728*G0_1_1_3_1_4 - 0.00428571428571448*G0_1_1_3_1_5 - 0.00185064935064941*G0_1_1_3_2_0 + 0.00146103896103901*G0_1_1_3_2_1 + 0.0151948051948057*G0_1_1_3_2_2 + 0.0397402597402611*G0_1_1_3_2_3 + 0.00623376623376645*G0_1_1_3_2_4 + 0.00350649350649363*G0_1_1_3_2_5 + 0.00194805194805201*G0_1_1_3_3_0 - 0.0436363636363652*G0_1_1_3_3_1 + 0.0397402597402611*G0_1_1_3_3_2 + 0.0607792207792231*G0_1_1_3_3_3 - 0.0093506493506496*G0_1_1_3_3_4 - 0.0109090909090913*G0_1_1_3_3_5 + 0.00389610389610401*G0_1_1_3_4_0 + 0.0027272727272728*G0_1_1_3_4_1 + 0.00623376623376645*G0_1_1_3_4_2 - 0.0093506493506496*G0_1_1_3_4_3 - 0.0296103896103905*G0_1_1_3_4_4 - 0.0124675324675328*G0_1_1_3_4_5 + 0.000194805194805197*G0_1_1_3_5_0 - 0.00428571428571449*G0_1_1_3_5_1 + 0.00350649350649363*G0_1_1_3_5_2 - 0.0109090909090913*G0_1_1_3_5_3 - 0.0124675324675328*G0_1_1_3_5_4 + 0.00467532467532485*G0_1_1_3_5_5 - 0.00413961038961055*G0_1_1_4_0_0 - 0.000681818181818199*G0_1_1_4_0_1 + 0.000487012987013005*G0_1_1_4_0_2 + 0.00389610389610401*G0_1_1_4_0_3 + 0.0062337662337664*G0_1_1_4_0_4 - 0.00097402597402602*G0_1_1_4_0_5 - 0.000681818181818199*G0_1_1_4_1_0 - 0.00326298701298711*G0_1_1_4_1_1 - 0.00126623376623381*G0_1_1_4_1_2 + 0.0027272727272728*G0_1_1_4_1_3 + 0.0109090909090912*G0_1_1_4_1_4 + 0.00603896103896123*G0_1_1_4_1_5 + 0.000487012987013005*G0_1_1_4_2_0 - 0.00126623376623381*G0_1_1_4_2_1 + 0.00233766233766243*G0_1_1_4_2_2 + 0.00623376623376644*G0_1_1_4_2_3 + 0.00272727272727282*G0_1_1_4_2_4 + 0.00233766233766241*G0_1_1_4_2_5 + 0.00389610389610401*G0_1_1_4_3_0 + 0.0027272727272728*G0_1_1_4_3_1 + 0.00623376623376645*G0_1_1_4_3_2 - 0.0093506493506496*G0_1_1_4_3_3 - 0.0296103896103905*G0_1_1_4_3_4 - 0.0124675324675328*G0_1_1_4_3_5 + 0.00623376623376641*G0_1_1_4_4_0 + 0.0109090909090912*G0_1_1_4_4_1 + 0.00272727272727282*G0_1_1_4_4_2 - 0.0296103896103905*G0_1_1_4_4_3 - 0.0794805194805219*G0_1_1_4_4_4 - 0.0264935064935073*G0_1_1_4_4_5 - 0.00097402597402602*G0_1_1_4_5_0 + 0.00603896103896123*G0_1_1_4_5_1 + 0.00233766233766241*G0_1_1_4_5_2 - 0.0124675324675328*G0_1_1_4_5_3 - 0.0264935064935073*G0_1_1_4_5_4 - 0.00701298701298722*G0_1_1_4_5_5 - 0.00730519480519509*G0_1_1_5_0_0 + 0.000779220779220817*G0_1_1_5_0_1 + 0.00116883116883121*G0_1_1_5_0_2 + 0.000194805194805197*G0_1_1_5_0_3 - 0.00097402597402602*G0_1_1_5_0_4 - 0.0227922077922086*G0_1_1_5_0_5 + 0.000779220779220817*G0_1_1_5_1_0 - 0.018311688311689*G0_1_1_5_1_1 + 0.000243506493506512*G0_1_1_5_1_2 - 0.00428571428571448*G0_1_1_5_1_3 + 0.00603896103896123*G0_1_1_5_1_4 + 0.0171428571428577*G0_1_1_5_1_5 + 0.00116883116883121*G0_1_1_5_2_0 + 0.000243506493506512*G0_1_1_5_2_1 + 0.00350649350649363*G0_1_1_5_2_3 + 0.00233766233766241*G0_1_1_5_2_4 - 0.00253246753246763*G0_1_1_5_2_5 + 0.000194805194805197*G0_1_1_5_3_0 - 0.00428571428571448*G0_1_1_5_3_1 + 0.00350649350649363*G0_1_1_5_3_2 - 0.0109090909090913*G0_1_1_5_3_3 - 0.0124675324675328*G0_1_1_5_3_4 + 0.00467532467532486*G0_1_1_5_3_5 - 0.00097402597402602*G0_1_1_5_4_0 + 0.00603896103896123*G0_1_1_5_4_1 + 0.00233766233766241*G0_1_1_5_4_2 - 0.0124675324675328*G0_1_1_5_4_3 - 0.0264935064935073*G0_1_1_5_4_4 - 0.00701298701298722*G0_1_1_5_4_5 - 0.0227922077922086*G0_1_1_5_5_0 + 0.0171428571428577*G0_1_1_5_5_1 - 0.00253246753246763*G0_1_1_5_5_2 + 0.00467532467532485*G0_1_1_5_5_3 - 0.00701298701298722*G0_1_1_5_5_4 + 0.0748051948051975*G0_1_1_5_5_5;
    A[75] = -A[73] - 0.0493100649350667*G0_0_0_0_0_0 + 0.00328733766233778*G0_0_0_0_0_1 + 0.00759740259740286*G0_0_0_0_0_2 - 0.00175324675324681*G0_0_0_0_0_3 - 0.0350649350649363*G0_0_0_0_0_4 - 0.0131493506493511*G0_0_0_0_0_5 + 0.00328733766233778*G0_0_0_0_1_0 - 0.00175324675324681*G0_0_0_0_1_1 - 0.000292207792207803*G0_0_0_0_1_2 - 0.000876623376623407*G0_0_0_0_1_3 + 0.00350649350649363*G0_0_0_0_1_4 + 0.00175324675324681*G0_0_0_0_1_5 + 0.00759740259740286*G0_0_0_0_2_0 - 0.000292207792207803*G0_0_0_0_2_1 - 0.00226461038961046*G0_0_0_0_2_2 + 0.000292207792207803*G0_0_0_0_2_3 + 0.00818181818181846*G0_0_0_0_2_4 + 0.00175324675324682*G0_0_0_0_2_5 - 0.00175324675324681*G0_0_0_0_3_0 - 0.000876623376623407*G0_0_0_0_3_1 + 0.000292207792207803*G0_0_0_0_3_2 - 0.00701298701298722*G0_0_0_0_3_3 - 0.00350649350649362*G0_0_0_0_3_4 - 0.0350649350649363*G0_0_0_0_4_0 + 0.00350649350649363*G0_0_0_0_4_1 + 0.00818181818181846*G0_0_0_0_4_2 - 0.00350649350649362*G0_0_0_0_4_3 - 0.0525974025974044*G0_0_0_0_4_4 - 0.0105194805194809*G0_0_0_0_4_5 - 0.0131493506493511*G0_0_0_0_5_0 + 0.00175324675324681*G0_0_0_0_5_1 + 0.00175324675324682*G0_0_0_0_5_2 - 0.0105194805194809*G0_0_0_0_5_4 - 0.00233766233766243*G0_0_0_0_5_5 + 0.00328733766233778*G0_0_0_1_0_0 - 0.00175324675324681*G0_0_0_1_0_1 - 0.000292207792207803*G0_0_0_1_0_2 - 0.000876623376623407*G0_0_0_1_0_3 + 0.00350649350649363*G0_0_0_1_0_4 + 0.00175324675324681*G0_0_0_1_0_5 - 0.00175324675324681*G0_0_0_1_1_0 + 0.024983766233767*G0_0_0_1_1_1 - 0.00379870129870143*G0_0_0_1_1_2 + 0.0219155844155852*G0_0_0_1_1_3 + 0.000876623376623406*G0_0_0_1_1_4 + 0.00438311688311705*G0_0_0_1_1_5 - 0.000292207792207803*G0_0_0_1_2_0 - 0.00379870129870143*G0_0_0_1_2_1 + 0.000365259740259755*G0_0_0_1_2_2 - 0.00759740259740286*G0_0_0_1_2_3 - 0.00146103896103901*G0_0_0_1_2_4 - 0.000876623376623411*G0_0_0_1_2_5 - 0.000876623376623407*G0_0_0_1_3_0 + 0.0219155844155852*G0_0_0_1_3_1 - 0.00759740259740286*G0_0_0_1_3_2 + 0.028051948051949*G0_0_0_1_3_3 + 0.00350649350649365*G0_0_0_1_3_5 + 0.00350649350649363*G0_0_0_1_4_0 + 0.000876623376623406*G0_0_0_1_4_1 - 0.00146103896103901*G0_0_0_1_4_2 + 0.00350649350649363*G0_0_0_1_4_4 + 0.00175324675324681*G0_0_0_1_5_0 + 0.00438311688311705*G0_0_0_1_5_1 - 0.000876623376623411*G0_0_0_1_5_2 + 0.00350649350649365*G0_0_0_1_5_3 - 0.00233766233766241*G0_0_0_1_5_5 + 0.00759740259740286*G0_0_0_2_0_0 - 0.000292207792207803*G0_0_0_2_0_1 - 0.00226461038961046*G0_0_0_2_0_2 + 0.000292207792207803*G0_0_0_2_0_3 + 0.00818181818181846*G0_0_0_2_0_4 + 0.00175324675324682*G0_0_0_2_0_5 - 0.000292207792207803*G0_0_0_2_1_0 - 0.00379870129870143*G0_0_0_2_1_1 + 0.000365259740259755*G0_0_0_2_1_2 - 0.00759740259740286*G0_0_0_2_1_3 - 0.00146103896103901*G0_0_0_2_1_4 - 0.000876623376623411*G0_0_0_2_1_5 - 0.00226461038961046*G0_0_0_2_2_0 + 0.000365259740259755*G0_0_0_2_2_1 + 0.00438311688311703*G0_0_0_2_2_2 + 0.00642857142857165*G0_0_0_2_2_3 - 0.000584415584415606*G0_0_0_2_2_4 - 0.000292207792207799*G0_0_0_2_2_5 + 0.000292207792207803*G0_0_0_2_3_0 - 0.00759740259740286*G0_0_0_2_3_1 + 0.00642857142857165*G0_0_0_2_3_2 - 0.00467532467532485*G0_0_0_2_3_3 + 0.00233766233766241*G0_0_0_2_3_4 + 0.00818181818181846*G0_0_0_2_4_0 - 0.00146103896103901*G0_0_0_2_4_1 - 0.000584415584415606*G0_0_0_2_4_2 + 0.00233766233766241*G0_0_0_2_4_3 + 0.0233766233766242*G0_0_0_2_4_4 + 0.00350649350649362*G0_0_0_2_4_5 + 0.00175324675324682*G0_0_0_2_5_0 - 0.000876623376623411*G0_0_0_2_5_1 - 0.000292207792207799*G0_0_0_2_5_2 + 0.00350649350649362*G0_0_0_2_5_4 + 0.00233766233766241*G0_0_0_2_5_5 - 0.00175324675324681*G0_0_0_3_0_0 - 0.000876623376623407*G0_0_0_3_0_1 + 0.000292207792207803*G0_0_0_3_0_2 - 0.00701298701298722*G0_0_0_3_0_3 - 0.00350649350649362*G0_0_0_3_0_4 - 0.000876623376623407*G0_0_0_3_1_0 + 0.0219155844155852*G0_0_0_3_1_1 - 0.00759740259740286*G0_0_0_3_1_2 + 0.028051948051949*G0_0_0_3_1_3 + 0.00350649350649365*G0_0_0_3_1_5 + 0.000292207792207803*G0_0_0_3_2_0 - 0.00759740259740286*G0_0_0_3_2_1 + 0.00642857142857165*G0_0_0_3_2_2 - 0.00467532467532485*G0_0_0_3_2_3 + 0.00233766233766241*G0_0_0_3_2_4 - 0.00701298701298722*G0_0_0_3_3_0 + 0.028051948051949*G0_0_0_3_3_1 - 0.00467532467532485*G0_0_0_3_3_2 + 0.238441558441567*G0_0_0_3_3_3 + 0.0140259740259745*G0_0_0_3_3_4 + 0.0140259740259746*G0_0_0_3_3_5 - 0.00350649350649362*G0_0_0_3_4_0 + 0.00233766233766241*G0_0_0_3_4_2 + 0.0140259740259745*G0_0_0_3_4_3 + 0.00350649350649365*G0_0_0_3_5_1 + 0.0140259740259746*G0_0_0_3_5_3 - 0.0046753246753248*G0_0_0_3_5_5 - 0.0350649350649363*G0_0_0_4_0_0 + 0.00350649350649363*G0_0_0_4_0_1 + 0.00818181818181846*G0_0_0_4_0_2 - 0.00350649350649362*G0_0_0_4_0_3 - 0.0525974025974044*G0_0_0_4_0_4 - 0.0105194805194809*G0_0_0_4_0_5 + 0.00350649350649363*G0_0_0_4_1_0 + 0.000876623376623407*G0_0_0_4_1_1 - 0.00146103896103901*G0_0_0_4_1_2 + 0.00350649350649363*G0_0_0_4_1_4 + 0.00818181818181846*G0_0_0_4_2_0 - 0.00146103896103901*G0_0_0_4_2_1 - 0.000584415584415606*G0_0_0_4_2_2 + 0.00233766233766241*G0_0_0_4_2_3 + 0.0233766233766242*G0_0_0_4_2_4 + 0.00350649350649362*G0_0_0_4_2_5 - 0.00350649350649362*G0_0_0_4_3_0 + 0.00233766233766241*G0_0_0_4_3_2 + 0.0140259740259745*G0_0_0_4_3_3 - 0.0525974025974044*G0_0_0_4_4_0 + 0.00350649350649363*G0_0_0_4_4_1 + 0.0233766233766242*G0_0_0_4_4_2 - 0.140259740259745*G0_0_0_4_4_4 - 0.0140259740259745*G0_0_0_4_4_5 - 0.0105194805194809*G0_0_0_4_5_0 + 0.00350649350649362*G0_0_0_4_5_2 - 0.0140259740259745*G0_0_0_4_5_4 - 0.00467532467532482*G0_0_0_4_5_5 - 0.0131493506493511*G0_0_0_5_0_0 + 0.00175324675324681*G0_0_0_5_0_1 + 0.00175324675324682*G0_0_0_5_0_2 - 0.0105194805194809*G0_0_0_5_0_4 - 0.00233766233766243*G0_0_0_5_0_5 + 0.00175324675324681*G0_0_0_5_1_0 + 0.00438311688311705*G0_0_0_5_1_1 - 0.000876623376623411*G0_0_0_5_1_2 + 0.00350649350649365*G0_0_0_5_1_3 - 0.00233766233766241*G0_0_0_5_1_5 + 0.00175324675324682*G0_0_0_5_2_0 - 0.000876623376623411*G0_0_0_5_2_1 - 0.000292207792207799*G0_0_0_5_2_2 + 0.00350649350649362*G0_0_0_5_2_4 + 0.00233766233766241*G0_0_0_5_2_5 + 0.00350649350649365*G0_0_0_5_3_1 + 0.0140259740259746*G0_0_0_5_3_3 - 0.0046753246753248*G0_0_0_5_3_5 - 0.0105194805194809*G0_0_0_5_4_0 + 0.00350649350649362*G0_0_0_5_4_2 - 0.0140259740259745*G0_0_0_5_4_4 - 0.00467532467532482*G0_0_0_5_4_5 - 0.00233766233766243*G0_0_0_5_5_0 - 0.00233766233766241*G0_0_0_5_5_1 + 0.00233766233766241*G0_0_0_5_5_2 - 0.0046753246753248*G0_0_0_5_5_3 - 0.00467532467532482*G0_0_0_5_5_4 - 0.0140259740259744*G0_0_0_5_5_5 + 0.204728084415591*G0_0_1_0_0_0 - 0.0112134740259744*G0_0_1_0_0_1 - 0.0110551948051952*G0_0_1_0_0_2 + 0.00297077922077929*G0_0_1_0_0_3 + 0.0469967532467548*G0_0_1_0_0_4 + 0.0448051948051964*G0_0_1_0_0_5 - 0.0112134740259744*G0_0_1_0_1_0 - 0.00325081168831179*G0_0_1_0_1_1 + 0.00105925324675328*G0_0_1_0_1_2 - 0.00155844155844161*G0_0_1_0_1_3 - 0.00180194805194811*G0_0_1_0_1_4 - 0.00292207792207803*G0_0_1_0_1_5 - 0.0110551948051952*G0_0_1_0_2_0 + 0.00105925324675328*G0_0_1_0_2_1 + 0.000779220779220806*G0_0_1_0_2_2 + 0.000292207792207803*G0_0_1_0_2_3 - 0.00457792207792223*G0_0_1_0_2_4 - 0.00297077922077932*G0_0_1_0_2_5 + 0.00297077922077929*G0_0_1_0_3_0 - 0.00155844155844161*G0_0_1_0_3_1 + 0.000292207792207803*G0_0_1_0_3_2 - 0.00740259740259762*G0_0_1_0_3_3 - 0.00233766233766241*G0_0_1_0_3_4 + 0.0469967532467548*G0_0_1_0_4_0 - 0.00180194805194811*G0_0_1_0_4_1 - 0.00457792207792223*G0_0_1_0_4_2 - 0.00233766233766241*G0_0_1_0_4_3 + 0.0132467532467537*G0_0_1_0_4_4 + 0.00954545454545488*G0_0_1_0_4_5 + 0.0448051948051964*G0_0_1_0_5_0 - 0.00292207792207803*G0_0_1_0_5_1 - 0.00297077922077932*G0_0_1_0_5_2 + 0.00954545454545487*G0_0_1_0_5_4 + 0.027077922077923*G0_0_1_0_5_5 - 0.0112134740259744*G0_0_1_1_0_0 - 0.00325081168831179*G0_0_1_1_0_1 + 0.00105925324675328*G0_0_1_1_0_2 - 0.00155844155844161*G0_0_1_1_0_3 - 0.00180194805194811*G0_0_1_1_0_4 - 0.00292207792207803*G0_0_1_1_0_5 - 0.00325081168831179*G0_0_1_1_1_0 + 0.113267045454549*G0_0_1_1_1_1 - 0.00910714285714317*G0_0_1_1_1_2 + 0.0431493506493521*G0_0_1_1_1_3 + 0.00272727272727281*G0_0_1_1_1_4 + 0.0155357142857149*G0_0_1_1_1_5 + 0.00105925324675328*G0_0_1_1_2_0 - 0.00910714285714317*G0_0_1_1_2_1 + 0.000754870129870157*G0_0_1_1_2_2 - 0.00827922077922107*G0_0_1_1_2_3 + 0.000292207792207801*G0_0_1_1_2_4 - 0.000389610389610413*G0_0_1_1_2_5 - 0.00155844155844161*G0_0_1_1_3_0 + 0.0431493506493521*G0_0_1_1_3_1 - 0.00827922077922107*G0_0_1_1_3_2 + 0.0358441558441571*G0_0_1_1_3_3 - 0.00233766233766241*G0_0_1_1_3_4 + 0.00389610389610408*G0_0_1_1_3_5 - 0.00180194805194811*G0_0_1_1_4_0 + 0.00272727272727281*G0_0_1_1_4_1 + 0.000292207792207801*G0_0_1_1_4_2 - 0.00233766233766241*G0_0_1_1_4_3 - 0.00545454545454563*G0_0_1_1_4_4 - 0.00467532467532482*G0_0_1_1_4_5 - 0.00292207792207803*G0_0_1_1_5_0 + 0.0155357142857149*G0_0_1_1_5_1 - 0.000389610389610413*G0_0_1_1_5_2 + 0.00389610389610407*G0_0_1_1_5_3 - 0.00467532467532482*G0_0_1_1_5_4 - 0.0130519480519485*G0_0_1_1_5_5 - 0.0110551948051952*G0_0_1_2_0_0 + 0.00105925324675328*G0_0_1_2_0_1 + 0.000779220779220806*G0_0_1_2_0_2 + 0.000292207792207803*G0_0_1_2_0_3 - 0.00457792207792223*G0_0_1_2_0_4 - 0.00297077922077932*G0_0_1_2_0_5 + 0.00105925324675328*G0_0_1_2_1_0 - 0.00910714285714317*G0_0_1_2_1_1 + 0.000754870129870157*G0_0_1_2_1_2 - 0.00827922077922107*G0_0_1_2_1_3 + 0.000292207792207801*G0_0_1_2_1_4 - 0.000389610389610414*G0_0_1_2_1_5 + 0.000779220779220806*G0_0_1_2_2_0 + 0.000754870129870157*G0_0_1_2_2_1 + 0.00153409090909097*G0_0_1_2_2_2 + 0.00555194805194824*G0_0_1_2_2_3 + 0.00175324675324681*G0_0_1_2_2_4 + 0.000876623376623407*G0_0_1_2_2_5 + 0.000292207792207803*G0_0_1_2_3_0 - 0.00827922077922107*G0_0_1_2_3_1 + 0.00555194805194824*G0_0_1_2_3_2 - 0.0101298701298705*G0_0_1_2_3_3 - 0.00116883116883121*G0_0_1_2_3_4 - 0.00233766233766242*G0_0_1_2_3_5 - 0.00457792207792223*G0_0_1_2_4_0 + 0.000292207792207801*G0_0_1_2_4_1 + 0.00175324675324681*G0_0_1_2_4_2 - 0.0011688311688312*G0_0_1_2_4_3 - 0.000389610389610402*G0_0_1_2_4_4 - 0.00233766233766241*G0_0_1_2_4_5 - 0.00297077922077932*G0_0_1_2_5_0 - 0.000389610389610413*G0_0_1_2_5_1 + 0.000876623376623407*G0_0_1_2_5_2 - 0.00233766233766242*G0_0_1_2_5_3 - 0.00233766233766241*G0_0_1_2_5_4 + 0.00233766233766242*G0_0_1_2_5_5 + 0.00297077922077929*G0_0_1_3_0_0 - 0.00155844155844161*G0_0_1_3_0_1 + 0.000292207792207803*G0_0_1_3_0_2 - 0.00740259740259762*G0_0_1_3_0_3 - 0.00233766233766241*G0_0_1_3_0_4 - 0.00155844155844161*G0_0_1_3_1_0 + 0.0431493506493521*G0_0_1_3_1_1 - 0.00827922077922107*G0_0_1_3_1_2 + 0.0358441558441571*G0_0_1_3_1_3 - 0.00233766233766241*G0_0_1_3_1_4 + 0.00389610389610407*G0_0_1_3_1_5 + 0.000292207792207803*G0_0_1_3_2_0 - 0.00827922077922107*G0_0_1_3_2_1 + 0.00555194805194824*G0_0_1_3_2_2 - 0.0101298701298705*G0_0_1_3_2_3 - 0.00116883116883121*G0_0_1_3_2_4 - 0.00233766233766242*G0_0_1_3_2_5 - 0.00740259740259762*G0_0_1_3_3_0 + 0.0358441558441571*G0_0_1_3_3_1 - 0.0101298701298705*G0_0_1_3_3_2 + 0.161298701298707*G0_0_1_3_3_3 + 0.0194805194805201*G0_0_1_3_3_4 + 0.0194805194805202*G0_0_1_3_3_5 - 0.00233766233766241*G0_0_1_3_4_0 - 0.00233766233766241*G0_0_1_3_4_1 - 0.00116883116883121*G0_0_1_3_4_2 + 0.0194805194805201*G0_0_1_3_4_3 + 0.0155844155844161*G0_0_1_3_4_4 + 0.00935064935064965*G0_0_1_3_4_5 + 0.00389610389610407*G0_0_1_3_5_1 - 0.00233766233766242*G0_0_1_3_5_2 + 0.0194805194805202*G0_0_1_3_5_3 + 0.00935064935064965*G0_0_1_3_5_4 - 0.00467532467532485*G0_0_1_3_5_5 + 0.0469967532467548*G0_0_1_4_0_0 - 0.00180194805194811*G0_0_1_4_0_1 - 0.00457792207792223*G0_0_1_4_0_2 - 0.00233766233766241*G0_0_1_4_0_3 + 0.0132467532467537*G0_0_1_4_0_4 + 0.00954545454545488*G0_0_1_4_0_5 - 0.00180194805194811*G0_0_1_4_1_0 + 0.00272727272727281*G0_0_1_4_1_1 + 0.000292207792207801*G0_0_1_4_1_2 - 0.00233766233766241*G0_0_1_4_1_3 - 0.00545454545454563*G0_0_1_4_1_4 - 0.00467532467532482*G0_0_1_4_1_5 - 0.00457792207792223*G0_0_1_4_2_0 + 0.000292207792207801*G0_0_1_4_2_1 + 0.00175324675324681*G0_0_1_4_2_2 - 0.00116883116883121*G0_0_1_4_2_3 - 0.000389610389610403*G0_0_1_4_2_4 - 0.00233766233766241*G0_0_1_4_2_5 - 0.00233766233766241*G0_0_1_4_3_0 - 0.00233766233766241*G0_0_1_4_3_1 - 0.00116883116883121*G0_0_1_4_3_2 + 0.0194805194805201*G0_0_1_4_3_3 + 0.0155844155844161*G0_0_1_4_3_4 + 0.00935064935064965*G0_0_1_4_3_5 + 0.0132467532467537*G0_0_1_4_4_0 - 0.00545454545454563*G0_0_1_4_4_1 - 0.000389610389610403*G0_0_1_4_4_2 + 0.0155844155844161*G0_0_1_4_4_3 + 0.0155844155844161*G0_0_1_4_4_5 + 0.00954545454545488*G0_0_1_4_5_0 - 0.00467532467532482*G0_0_1_4_5_1 - 0.00233766233766241*G0_0_1_4_5_2 + 0.00935064935064965*G0_0_1_4_5_3 + 0.0155844155844161*G0_0_1_4_5_4 + 0.0046753246753248*G0_0_1_4_5_5 + 0.0448051948051964*G0_0_1_5_0_0 - 0.00292207792207803*G0_0_1_5_0_1 - 0.00297077922077932*G0_0_1_5_0_2 + 0.00954545454545487*G0_0_1_5_0_4 + 0.027077922077923*G0_0_1_5_0_5 - 0.00292207792207803*G0_0_1_5_1_0 + 0.0155357142857149*G0_0_1_5_1_1 - 0.000389610389610413*G0_0_1_5_1_2 + 0.00389610389610408*G0_0_1_5_1_3 - 0.00467532467532482*G0_0_1_5_1_4 - 0.0130519480519485*G0_0_1_5_1_5 - 0.00297077922077932*G0_0_1_5_2_0 - 0.000389610389610413*G0_0_1_5_2_1 + 0.000876623376623407*G0_0_1_5_2_2 - 0.00233766233766242*G0_0_1_5_2_3 - 0.00233766233766241*G0_0_1_5_2_4 + 0.00233766233766242*G0_0_1_5_2_5 + 0.00389610389610408*G0_0_1_5_3_1 - 0.00233766233766242*G0_0_1_5_3_2 + 0.0194805194805202*G0_0_1_5_3_3 + 0.00935064935064965*G0_0_1_5_3_4 - 0.00467532467532485*G0_0_1_5_3_5 + 0.00954545454545488*G0_0_1_5_4_0 - 0.00467532467532482*G0_0_1_5_4_1 - 0.00233766233766241*G0_0_1_5_4_2 + 0.00935064935064965*G0_0_1_5_4_3 + 0.0155844155844161*G0_0_1_5_4_4 + 0.0046753246753248*G0_0_1_5_4_5 + 0.027077922077923*G0_0_1_5_5_0 - 0.0130519480519485*G0_0_1_5_5_1 + 0.00233766233766242*G0_0_1_5_5_2 - 0.00467532467532485*G0_0_1_5_5_3 + 0.0046753246753248*G0_0_1_5_5_4 - 0.119220779220784*G0_0_1_5_5_5 + 0.00986201298701335*G0_1_0_0_0_0 - 0.00175324675324682*G0_1_0_0_0_1 - 0.00182629870129877*G0_1_0_0_0_2 + 0.00175324675324681*G0_1_0_0_0_3 + 0.00876623376623407*G0_1_0_0_0_4 + 0.00730519480519508*G0_1_0_0_0_5 - 0.00175324675324682*G0_1_0_0_1_0 - 0.00109577922077925*G0_1_0_0_1_1 + 0.000949675324675357*G0_1_0_0_1_2 - 0.00175324675324682*G0_1_0_0_1_3 - 0.00175324675324682*G0_1_0_0_1_4 - 0.00262987012987023*G0_1_0_0_1_5 - 0.00182629870129877*G0_1_0_0_2_0 + 0.000949675324675357*G0_1_0_0_2_1 + 0.000292207792207807*G0_1_0_0_2_2 - 0.000292207792207799*G0_1_0_0_2_3 - 0.00321428571428582*G0_1_0_0_2_4 - 0.00233766233766242*G0_1_0_0_2_5 + 0.00175324675324681*G0_1_0_0_3_0 - 0.00175324675324682*G0_1_0_0_3_1 - 0.000292207792207799*G0_1_0_0_3_2 - 0.0105194805194808*G0_1_0_0_3_3 + 0.00116883116883121*G0_1_0_0_3_5 + 0.00876623376623407*G0_1_0_0_4_0 - 0.00175324675324682*G0_1_0_0_4_1 - 0.00321428571428582*G0_1_0_0_4_2 + 0.0105194805194809*G0_1_0_0_4_4 + 0.00818181818181847*G0_1_0_0_4_5 + 0.00730519480519508*G0_1_0_0_5_0 - 0.00262987012987023*G0_1_0_0_5_1 - 0.00233766233766242*G0_1_0_0_5_2 + 0.00116883116883121*G0_1_0_0_5_3 + 0.00818181818181847*G0_1_0_0_5_4 + 0.0140259740259745*G0_1_0_0_5_5 - 0.00175324675324682*G0_1_0_1_0_0 - 0.00109577922077925*G0_1_0_1_0_1 + 0.000949675324675357*G0_1_0_1_0_2 - 0.00175324675324682*G0_1_0_1_0_3 - 0.00175324675324682*G0_1_0_1_0_4 - 0.00262987012987023*G0_1_0_1_0_5 - 0.00109577922077925*G0_1_0_1_1_0 + 0.0262987012987021*G0_1_0_1_1_1 - 0.00460227272727289*G0_1_0_1_1_2 + 0.0245454545454554*G0_1_0_1_1_3 + 0.00350649350649363*G0_1_0_1_1_4 + 0.00759740259740288*G0_1_0_1_1_5 + 0.000949675324675357*G0_1_0_1_2_0 - 0.00460227272727289*G0_1_0_1_2_1 - 0.000146103896103897*G0_1_0_1_2_2 - 0.00788961038961066*G0_1_0_1_2_3 + 0.00146103896103901*G0_1_0_1_2_4 + 0.0005844155844156*G0_1_0_1_2_5 - 0.00175324675324682*G0_1_0_1_3_0 + 0.0245454545454554*G0_1_0_1_3_1 - 0.00788961038961066*G0_1_0_1_3_2 + 0.0280519480519491*G0_1_0_1_3_3 - 0.00350649350649362*G0_1_0_1_3_4 + 0.00233766233766244*G0_1_0_1_3_5 - 0.00175324675324682*G0_1_0_1_4_0 + 0.00350649350649363*G0_1_0_1_4_1 + 0.00146103896103901*G0_1_0_1_4_2 - 0.00350649350649362*G0_1_0_1_4_3 - 0.0140259740259745*G0_1_0_1_4_4 - 0.00818181818181846*G0_1_0_1_4_5 - 0.00262987012987023*G0_1_0_1_5_0 + 0.00759740259740288*G0_1_0_1_5_1 + 0.0005844155844156*G0_1_0_1_5_2 + 0.00233766233766244*G0_1_0_1_5_3 - 0.00818181818181846*G0_1_0_1_5_4 - 0.00935064935064968*G0_1_0_1_5_5 - 0.00182629870129877*G0_1_0_2_0_0 + 0.000949675324675357*G0_1_0_2_0_1 + 0.000292207792207807*G0_1_0_2_0_2 - 0.000292207792207799*G0_1_0_2_0_3 - 0.00321428571428582*G0_1_0_2_0_4 - 0.00233766233766242*G0_1_0_2_0_5 + 0.000949675324675357*G0_1_0_2_1_0 - 0.00460227272727289*G0_1_0_2_1_1 - 0.000146103896103897*G0_1_0_2_1_2 - 0.00788961038961066*G0_1_0_2_1_3 + 0.00146103896103901*G0_1_0_2_1_4 + 0.0005844155844156*G0_1_0_2_1_5 + 0.000292207792207807*G0_1_0_2_2_0 - 0.000146103896103897*G0_1_0_2_2_1 + 0.0021915584415585*G0_1_0_2_2_2 + 0.00818181818181845*G0_1_0_2_2_3 + 0.00350649350649361*G0_1_0_2_2_4 + 0.00204545454545462*G0_1_0_2_2_5 - 0.000292207792207799*G0_1_0_2_3_0 - 0.00788961038961066*G0_1_0_2_3_1 + 0.00818181818181845*G0_1_0_2_3_2 - 0.0070129870129873*G0_1_0_2_3_3 - 0.00233766233766243*G0_1_0_2_3_4 - 0.00350649350649364*G0_1_0_2_3_5 - 0.00321428571428582*G0_1_0_2_4_0 + 0.00146103896103901*G0_1_0_2_4_1 + 0.00350649350649361*G0_1_0_2_4_2 - 0.00233766233766243*G0_1_0_2_4_3 - 0.0116883116883121*G0_1_0_2_4_4 - 0.00701298701298726*G0_1_0_2_4_5 - 0.00233766233766242*G0_1_0_2_5_0 + 0.0005844155844156*G0_1_0_2_5_1 + 0.00204545454545462*G0_1_0_2_5_2 - 0.00350649350649364*G0_1_0_2_5_3 - 0.00701298701298726*G0_1_0_2_5_4 - 0.00584415584415606*G0_1_0_2_5_5 + 0.00175324675324681*G0_1_0_3_0_0 - 0.00175324675324682*G0_1_0_3_0_1 - 0.000292207792207799*G0_1_0_3_0_2 - 0.0105194805194808*G0_1_0_3_0_3 + 0.00116883116883121*G0_1_0_3_0_5 - 0.00175324675324682*G0_1_0_3_1_0 + 0.0245454545454554*G0_1_0_3_1_1 - 0.00788961038961066*G0_1_0_3_1_2 + 0.0280519480519491*G0_1_0_3_1_3 - 0.00350649350649362*G0_1_0_3_1_4 + 0.00233766233766244*G0_1_0_3_1_5 - 0.000292207792207799*G0_1_0_3_2_0 - 0.00788961038961066*G0_1_0_3_2_1 + 0.00818181818181845*G0_1_0_3_2_2 - 0.0070129870129873*G0_1_0_3_2_3 - 0.00233766233766242*G0_1_0_3_2_4 - 0.00350649350649364*G0_1_0_3_2_5 - 0.0105194805194808*G0_1_0_3_3_0 + 0.0280519480519491*G0_1_0_3_3_1 - 0.0070129870129873*G0_1_0_3_3_2 + 0.28051948051949*G0_1_0_3_3_3 + 0.028051948051949*G0_1_0_3_3_4 + 0.0280519480519491*G0_1_0_3_3_5 - 0.00350649350649362*G0_1_0_3_4_1 - 0.00233766233766242*G0_1_0_3_4_2 + 0.028051948051949*G0_1_0_3_4_3 + 0.028051948051949*G0_1_0_3_4_4 + 0.0140259740259745*G0_1_0_3_4_5 + 0.00116883116883121*G0_1_0_3_5_0 + 0.00233766233766244*G0_1_0_3_5_1 - 0.00350649350649364*G0_1_0_3_5_2 + 0.0280519480519491*G0_1_0_3_5_3 + 0.0140259740259745*G0_1_0_3_5_4 + 0.00935064935064971*G0_1_0_3_5_5 + 0.00876623376623407*G0_1_0_4_0_0 - 0.00175324675324682*G0_1_0_4_0_1 - 0.00321428571428582*G0_1_0_4_0_2 + 0.0105194805194809*G0_1_0_4_0_4 + 0.00818181818181847*G0_1_0_4_0_5 - 0.00175324675324682*G0_1_0_4_1_0 + 0.00350649350649363*G0_1_0_4_1_1 + 0.00146103896103901*G0_1_0_4_1_2 - 0.00350649350649362*G0_1_0_4_1_3 - 0.0140259740259745*G0_1_0_4_1_4 - 0.00818181818181846*G0_1_0_4_1_5 - 0.00321428571428582*G0_1_0_4_2_0 + 0.00146103896103901*G0_1_0_4_2_1 + 0.00350649350649361*G0_1_0_4_2_2 - 0.00233766233766242*G0_1_0_4_2_3 - 0.0116883116883121*G0_1_0_4_2_4 - 0.00701298701298726*G0_1_0_4_2_5 - 0.00350649350649362*G0_1_0_4_3_1 - 0.00233766233766243*G0_1_0_4_3_2 + 0.028051948051949*G0_1_0_4_3_3 + 0.028051948051949*G0_1_0_4_3_4 + 0.0140259740259745*G0_1_0_4_3_5 + 0.0105194805194809*G0_1_0_4_4_0 - 0.0140259740259745*G0_1_0_4_4_1 - 0.0116883116883121*G0_1_0_4_4_2 + 0.028051948051949*G0_1_0_4_4_3 + 0.112207792207796*G0_1_0_4_4_4 + 0.0420779220779235*G0_1_0_4_4_5 + 0.00818181818181847*G0_1_0_4_5_0 - 0.00818181818181846*G0_1_0_4_5_1 - 0.00701298701298726*G0_1_0_4_5_2 + 0.0140259740259745*G0_1_0_4_5_3 + 0.0420779220779235*G0_1_0_4_5_4 + 0.028051948051949*G0_1_0_4_5_5 + 0.00730519480519508*G0_1_0_5_0_0 - 0.00262987012987023*G0_1_0_5_0_1 - 0.00233766233766242*G0_1_0_5_0_2 + 0.00116883116883121*G0_1_0_5_0_3 + 0.00818181818181847*G0_1_0_5_0_4 + 0.0140259740259745*G0_1_0_5_0_5 - 0.00262987012987023*G0_1_0_5_1_0 + 0.00759740259740288*G0_1_0_5_1_1 + 0.0005844155844156*G0_1_0_5_1_2 + 0.00233766233766244*G0_1_0_5_1_3 - 0.00818181818181846*G0_1_0_5_1_4 - 0.00935064935064968*G0_1_0_5_1_5 - 0.00233766233766242*G0_1_0_5_2_0 + 0.0005844155844156*G0_1_0_5_2_1 + 0.00204545454545462*G0_1_0_5_2_2 - 0.00350649350649364*G0_1_0_5_2_3 - 0.00701298701298726*G0_1_0_5_2_4 - 0.00584415584415606*G0_1_0_5_2_5 + 0.00116883116883121*G0_1_0_5_3_0 + 0.00233766233766244*G0_1_0_5_3_1 - 0.00350649350649364*G0_1_0_5_3_2 + 0.0280519480519491*G0_1_0_5_3_3 + 0.0140259740259745*G0_1_0_5_3_4 + 0.00935064935064972*G0_1_0_5_3_5 + 0.00818181818181847*G0_1_0_5_4_0 - 0.00818181818181846*G0_1_0_5_4_1 - 0.00701298701298727*G0_1_0_5_4_2 + 0.0140259740259745*G0_1_0_5_4_3 + 0.0420779220779235*G0_1_0_5_4_4 + 0.0280519480519491*G0_1_0_5_4_5 + 0.0140259740259745*G0_1_0_5_5_0 - 0.00935064935064968*G0_1_0_5_5_1 - 0.00584415584415606*G0_1_0_5_5_2 + 0.00935064935064972*G0_1_0_5_5_3 + 0.028051948051949*G0_1_0_5_5_4 + 0.0280519480519491*G0_1_0_5_5_5 - 0.0392654220779235*G0_1_1_0_0_0 + 0.0056737012987015*G0_1_1_0_0_1 + 0.00254464285714295*G0_1_1_0_0_2 - 0.000487012987013005*G0_1_1_0_0_3 - 0.00900974025974057*G0_1_1_0_0_4 - 0.0277597402597413*G0_1_1_0_0_5 + 0.0056737012987015*G0_1_1_0_1_0 - 0.00670860389610412*G0_1_1_0_1_1 - 0.00160714285714291*G0_1_1_0_1_3 + 0.00243506493506502*G0_1_1_0_1_4 + 0.00740259740259766*G0_1_1_0_1_5 + 0.00254464285714295*G0_1_1_0_2_0 - 0.000730519480519505*G0_1_1_0_2_2 + 0.000974025974026007*G0_1_1_0_2_3 + 0.00126623376623381*G0_1_1_0_2_4 + 0.00233766233766242*G0_1_1_0_2_5 - 0.000487012987013005*G0_1_1_0_3_0 - 0.00160714285714291*G0_1_1_0_3_1 + 0.000974025974026007*G0_1_1_0_3_2 - 0.00896103896103924*G0_1_1_0_3_3 - 0.00389610389610401*G0_1_1_0_3_4 - 0.00370129870129883*G0_1_1_0_3_5 - 0.00900974025974057*G0_1_1_0_4_0 + 0.00243506493506502*G0_1_1_0_4_1 + 0.00126623376623381*G0_1_1_0_4_2 - 0.00389610389610401*G0_1_1_0_4_3 - 0.00857142857142884*G0_1_1_0_4_4 - 0.00954545454545488*G0_1_1_0_4_5 - 0.0277597402597413*G0_1_1_0_5_0 + 0.00740259740259766*G0_1_1_0_5_1 + 0.00233766233766242*G0_1_1_0_5_2 - 0.00370129870129883*G0_1_1_0_5_3 - 0.00954545454545487*G0_1_1_0_5_4 - 0.029805194805196*G0_1_1_0_5_5 + 0.0056737012987015*G0_1_1_1_0_0 - 0.00670860389610412*G0_1_1_1_0_1 - 0.00160714285714291*G0_1_1_1_0_3 + 0.00243506493506502*G0_1_1_1_0_4 + 0.00740259740259766*G0_1_1_1_0_5 - 0.00670860389610412*G0_1_1_1_1_0 + 0.121996753246757*G0_1_1_1_1_1 - 0.00977678571428605*G0_1_1_1_1_2 + 0.0465584415584432*G0_1_1_1_1_3 + 0.00297077922077931*G0_1_1_1_1_4 + 0.0177272727272734*G0_1_1_1_1_5 - 0.00977678571428605*G0_1_1_1_2_1 + 0.000827922077922109*G0_1_1_1_2_2 - 0.00905844155844187*G0_1_1_1_2_3 + 0.000389610389610401*G0_1_1_1_2_4 - 0.00170454545454553*G0_1_1_1_2_5 - 0.00160714285714291*G0_1_1_1_3_0 + 0.0465584415584432*G0_1_1_1_3_1 - 0.00905844155844187*G0_1_1_1_3_2 + 0.0389610389610403*G0_1_1_1_3_3 - 0.00272727272727281*G0_1_1_1_3_4 + 0.0066233766233769*G0_1_1_1_3_5 + 0.00243506493506502*G0_1_1_1_4_0 + 0.00297077922077931*G0_1_1_1_4_1 + 0.000389610389610401*G0_1_1_1_4_2 - 0.00272727272727281*G0_1_1_1_4_3 - 0.00857142857142884*G0_1_1_1_4_4 - 0.0025324675324676*G0_1_1_1_4_5 + 0.00740259740259766*G0_1_1_1_5_0 + 0.0177272727272734*G0_1_1_1_5_1 - 0.00170454545454553*G0_1_1_1_5_2 + 0.0066233766233769*G0_1_1_1_5_3 - 0.0025324675324676*G0_1_1_1_5_4 + 0.0062337662337665*G0_1_1_1_5_5 + 0.00254464285714295*G0_1_1_2_0_0 - 0.000730519480519505*G0_1_1_2_0_2 + 0.000974025974026007*G0_1_1_2_0_3 + 0.00126623376623381*G0_1_1_2_0_4 + 0.00233766233766242*G0_1_1_2_0_5 - 0.00977678571428605*G0_1_1_2_1_1 + 0.000827922077922109*G0_1_1_2_1_2 - 0.00905844155844187*G0_1_1_2_1_3 + 0.000389610389610401*G0_1_1_2_1_4 - 0.00170454545454553*G0_1_1_2_1_5 - 0.000730519480519505*G0_1_1_2_2_0 + 0.000827922077922109*G0_1_1_2_2_1 + 0.00321428571428585*G0_1_1_2_2_2 + 0.00672077922077945*G0_1_1_2_2_3 + 0.00204545454545461*G0_1_1_2_2_4 + 0.000779220779220805*G0_1_1_2_2_5 + 0.000974025974026007*G0_1_1_2_3_0 - 0.00905844155844187*G0_1_1_2_3_1 + 0.00672077922077945*G0_1_1_2_3_2 - 0.0116883116883121*G0_1_1_2_3_3 - 0.00272727272727282*G0_1_1_2_3_4 - 0.00350649350649363*G0_1_1_2_3_5 + 0.00126623376623381*G0_1_1_2_4_0 + 0.000389610389610401*G0_1_1_2_4_1 + 0.00204545454545461*G0_1_1_2_4_2 - 0.00272727272727282*G0_1_1_2_4_3 - 0.00506493506493524*G0_1_1_2_4_4 - 0.00233766233766241*G0_1_1_2_4_5 + 0.00233766233766242*G0_1_1_2_5_0 - 0.00170454545454553*G0_1_1_2_5_1 + 0.000779220779220805*G0_1_1_2_5_2 - 0.00350649350649363*G0_1_1_2_5_3 - 0.00233766233766241*G0_1_1_2_5_4 + 0.00603896103896127*G0_1_1_2_5_5 - 0.000487012987013005*G0_1_1_3_0_0 - 0.00160714285714291*G0_1_1_3_0_1 + 0.000974025974026007*G0_1_1_3_0_2 - 0.00896103896103924*G0_1_1_3_0_3 - 0.00389610389610401*G0_1_1_3_0_4 - 0.00370129870129883*G0_1_1_3_0_5 - 0.00160714285714291*G0_1_1_3_1_0 + 0.0465584415584431*G0_1_1_3_1_1 - 0.00905844155844187*G0_1_1_3_1_2 + 0.0389610389610403*G0_1_1_3_1_3 - 0.00272727272727281*G0_1_1_3_1_4 + 0.0066233766233769*G0_1_1_3_1_5 + 0.000974025974026007*G0_1_1_3_2_0 - 0.00905844155844187*G0_1_1_3_2_1 + 0.00672077922077945*G0_1_1_3_2_2 - 0.0116883116883121*G0_1_1_3_2_3 - 0.00272727272727282*G0_1_1_3_2_4 - 0.00350649350649363*G0_1_1_3_2_5 - 0.00896103896103924*G0_1_1_3_3_0 + 0.0389610389610403*G0_1_1_3_3_1 - 0.0116883116883121*G0_1_1_3_3_2 + 0.177662337662344*G0_1_1_3_3_3 + 0.0233766233766241*G0_1_1_3_3_4 + 0.0249350649350658*G0_1_1_3_3_5 - 0.00389610389610401*G0_1_1_3_4_0 - 0.00272727272727281*G0_1_1_3_4_1 - 0.00272727272727282*G0_1_1_3_4_2 + 0.0233766233766241*G0_1_1_3_4_3 + 0.0249350649350657*G0_1_1_3_4_4 + 0.0124675324675329*G0_1_1_3_4_5 - 0.00370129870129883*G0_1_1_3_5_0 + 0.0066233766233769*G0_1_1_3_5_1 - 0.00350649350649363*G0_1_1_3_5_2 + 0.0249350649350658*G0_1_1_3_5_3 + 0.0124675324675329*G0_1_1_3_5_4 - 0.00467532467532484*G0_1_1_3_5_5 - 0.00900974025974057*G0_1_1_4_0_0 + 0.00243506493506502*G0_1_1_4_0_1 + 0.00126623376623381*G0_1_1_4_0_2 - 0.00389610389610401*G0_1_1_4_0_3 - 0.00857142857142884*G0_1_1_4_0_4 - 0.00954545454545487*G0_1_1_4_0_5 + 0.00243506493506502*G0_1_1_4_1_0 + 0.00297077922077931*G0_1_1_4_1_1 + 0.000389610389610401*G0_1_1_4_1_2 - 0.00272727272727281*G0_1_1_4_1_3 - 0.00857142857142884*G0_1_1_4_1_4 - 0.0025324675324676*G0_1_1_4_1_5 + 0.00126623376623381*G0_1_1_4_2_0 + 0.000389610389610401*G0_1_1_4_2_1 + 0.00204545454545461*G0_1_1_4_2_2 - 0.00272727272727282*G0_1_1_4_2_3 - 0.00506493506493524*G0_1_1_4_2_4 - 0.00233766233766241*G0_1_1_4_2_5 - 0.00389610389610401*G0_1_1_4_3_0 - 0.00272727272727281*G0_1_1_4_3_1 - 0.00272727272727282*G0_1_1_4_3_2 + 0.0233766233766241*G0_1_1_4_3_3 + 0.0249350649350657*G0_1_1_4_3_4 + 0.0124675324675329*G0_1_1_4_3_5 - 0.00857142857142884*G0_1_1_4_4_0 - 0.00857142857142884*G0_1_1_4_4_1 - 0.00506493506493524*G0_1_1_4_4_2 + 0.0249350649350657*G0_1_1_4_4_3 + 0.0654545454545475*G0_1_1_4_4_4 + 0.0218181818181825*G0_1_1_4_4_5 - 0.00954545454545487*G0_1_1_4_5_0 - 0.0025324675324676*G0_1_1_4_5_1 - 0.00233766233766241*G0_1_1_4_5_2 + 0.0124675324675329*G0_1_1_4_5_3 + 0.0218181818181825*G0_1_1_4_5_4 - 0.00701298701298731*G0_1_1_4_5_5 - 0.0277597402597413*G0_1_1_5_0_0 + 0.00740259740259766*G0_1_1_5_0_1 + 0.00233766233766242*G0_1_1_5_0_2 - 0.00370129870129883*G0_1_1_5_0_3 - 0.00954545454545487*G0_1_1_5_0_4 - 0.029805194805196*G0_1_1_5_0_5 + 0.00740259740259766*G0_1_1_5_1_0 + 0.0177272727272734*G0_1_1_5_1_1 - 0.00170454545454553*G0_1_1_5_1_2 + 0.0066233766233769*G0_1_1_5_1_3 - 0.0025324675324676*G0_1_1_5_1_4 + 0.0062337662337665*G0_1_1_5_1_5 + 0.00233766233766242*G0_1_1_5_2_0 - 0.00170454545454553*G0_1_1_5_2_1 + 0.000779220779220805*G0_1_1_5_2_2 - 0.00350649350649363*G0_1_1_5_2_3 - 0.00233766233766241*G0_1_1_5_2_4 + 0.00603896103896127*G0_1_1_5_2_5 - 0.00370129870129883*G0_1_1_5_3_0 + 0.0066233766233769*G0_1_1_5_3_1 - 0.00350649350649363*G0_1_1_5_3_2 + 0.0249350649350658*G0_1_1_5_3_3 + 0.0124675324675329*G0_1_1_5_3_4 - 0.00467532467532484*G0_1_1_5_3_5 - 0.00954545454545487*G0_1_1_5_4_0 - 0.0025324675324676*G0_1_1_5_4_1 - 0.00233766233766241*G0_1_1_5_4_2 + 0.0124675324675329*G0_1_1_5_4_3 + 0.0218181818181825*G0_1_1_5_4_4 - 0.00701298701298731*G0_1_1_5_4_5 - 0.029805194805196*G0_1_1_5_5_0 + 0.0062337662337665*G0_1_1_5_5_1 + 0.00603896103896127*G0_1_1_5_5_2 - 0.00467532467532484*G0_1_1_5_5_3 - 0.00701298701298731*G0_1_1_5_5_4 - 0.215064935064943*G0_1_1_5_5_5;
    A[99] = 0.023668831168832*G0_0_0_0_0_0 - 0.00262987012987022*G0_0_0_0_0_1 - 0.00525974025974045*G0_0_0_0_0_2 + 0.00876623376623403*G0_0_0_0_0_3 + 0.0403246753246767*G0_0_0_0_0_4 + 0.0122727272727277*G0_0_0_0_0_5 - 0.00262987012987022*G0_0_0_0_1_0 - 0.00262987012987021*G0_0_0_0_1_1 + 0.00262987012987022*G0_0_0_0_1_2 - 0.00175324675324683*G0_0_0_0_1_3 - 0.00175324675324683*G0_0_0_0_1_4 - 0.00350649350649363*G0_0_0_0_1_5 - 0.00525974025974045*G0_0_0_0_2_0 + 0.00262987012987022*G0_0_0_0_2_1 - 0.00350649350649361*G0_0_0_0_2_2 - 0.0210389610389617*G0_0_0_0_2_4 - 0.00175324675324682*G0_0_0_0_2_5 + 0.00876623376623403*G0_0_0_0_3_0 - 0.00175324675324683*G0_0_0_0_3_1 - 0.0561038961038978*G0_0_0_0_3_3 - 0.0140259740259744*G0_0_0_0_3_4 - 0.0140259740259745*G0_0_0_0_3_5 + 0.0403246753246767*G0_0_0_0_4_0 - 0.00175324675324683*G0_0_0_0_4_1 - 0.0210389610389617*G0_0_0_0_4_2 - 0.0140259740259744*G0_0_0_0_4_3 + 0.0280519480519492*G0_0_0_0_4_4 + 0.00701298701298728*G0_0_0_0_4_5 + 0.0122727272727277*G0_0_0_0_5_0 - 0.00350649350649363*G0_0_0_0_5_1 - 0.00175324675324682*G0_0_0_0_5_2 - 0.0140259740259745*G0_0_0_0_5_3 + 0.00701298701298728*G0_0_0_0_5_4 - 0.00262987012987022*G0_0_0_1_0_0 - 0.00262987012987021*G0_0_0_1_0_1 + 0.00262987012987022*G0_0_0_1_0_2 - 0.00175324675324683*G0_0_0_1_0_3 - 0.00175324675324683*G0_0_0_1_0_4 - 0.00350649350649363*G0_0_0_1_0_5 - 0.00262987012987021*G0_0_0_1_1_0 + 0.023668831168832*G0_0_0_1_1_1 - 0.00525974025974045*G0_0_0_1_1_2 + 0.0403246753246767*G0_0_0_1_1_3 + 0.00876623376623406*G0_0_0_1_1_4 + 0.0122727272727277*G0_0_0_1_1_5 + 0.00262987012987022*G0_0_0_1_2_0 - 0.00525974025974045*G0_0_0_1_2_1 - 0.00350649350649361*G0_0_0_1_2_2 - 0.0210389610389618*G0_0_0_1_2_3 - 0.00175324675324682*G0_0_0_1_2_5 - 0.00175324675324683*G0_0_0_1_3_0 + 0.0403246753246767*G0_0_0_1_3_1 - 0.0210389610389618*G0_0_0_1_3_2 + 0.0280519480519492*G0_0_0_1_3_3 - 0.0140259740259745*G0_0_0_1_3_4 + 0.0070129870129873*G0_0_0_1_3_5 - 0.00175324675324683*G0_0_0_1_4_0 + 0.00876623376623406*G0_0_0_1_4_1 - 0.0140259740259745*G0_0_0_1_4_3 - 0.0561038961038979*G0_0_0_1_4_4 - 0.0140259740259745*G0_0_0_1_4_5 - 0.00350649350649363*G0_0_0_1_5_0 + 0.0122727272727277*G0_0_0_1_5_1 - 0.00175324675324682*G0_0_0_1_5_2 + 0.0070129870129873*G0_0_0_1_5_3 - 0.0140259740259745*G0_0_0_1_5_4 - 0.00525974025974045*G0_0_0_2_0_0 + 0.00262987012987022*G0_0_0_2_0_1 - 0.00350649350649361*G0_0_0_2_0_2 - 0.0210389610389617*G0_0_0_2_0_4 - 0.00175324675324682*G0_0_0_2_0_5 + 0.00262987012987022*G0_0_0_2_1_0 - 0.00525974025974045*G0_0_0_2_1_1 - 0.00350649350649361*G0_0_0_2_1_2 - 0.0210389610389618*G0_0_0_2_1_3 - 0.00175324675324682*G0_0_0_2_1_5 - 0.00350649350649361*G0_0_0_2_2_0 - 0.00350649350649361*G0_0_0_2_2_1 + 0.0262987012987021*G0_0_0_2_2_2 + 0.0350649350649362*G0_0_0_2_2_3 + 0.0350649350649362*G0_0_0_2_2_4 + 0.00701298701298726*G0_0_0_2_2_5 - 0.0210389610389618*G0_0_0_2_3_1 + 0.0350649350649362*G0_0_0_2_3_2 - 0.0140259740259745*G0_0_0_2_3_5 - 0.0210389610389617*G0_0_0_2_4_0 + 0.0350649350649362*G0_0_0_2_4_2 - 0.0140259740259745*G0_0_0_2_4_5 - 0.00175324675324682*G0_0_0_2_5_0 - 0.00175324675324682*G0_0_0_2_5_1 + 0.00701298701298726*G0_0_0_2_5_2 - 0.0140259740259745*G0_0_0_2_5_3 - 0.0140259740259745*G0_0_0_2_5_4 - 0.0140259740259745*G0_0_0_2_5_5 + 0.00876623376623403*G0_0_0_3_0_0 - 0.00175324675324683*G0_0_0_3_0_1 - 0.0561038961038978*G0_0_0_3_0_3 - 0.0140259740259744*G0_0_0_3_0_4 - 0.0140259740259745*G0_0_0_3_0_5 - 0.00175324675324683*G0_0_0_3_1_0 + 0.0403246753246767*G0_0_0_3_1_1 - 0.0210389610389618*G0_0_0_3_1_2 + 0.0280519480519492*G0_0_0_3_1_3 - 0.0140259740259745*G0_0_0_3_1_4 + 0.0070129870129873*G0_0_0_3_1_5 - 0.0210389610389618*G0_0_0_3_2_1 + 0.0350649350649362*G0_0_0_3_2_2 - 0.0140259740259745*G0_0_0_3_2_5 - 0.0561038961038978*G0_0_0_3_3_0 + 0.0280519480519492*G0_0_0_3_3_1 + 0.981818181818215*G0_0_0_3_3_3 + 0.140259740259745*G0_0_0_3_3_4 + 0.140259740259745*G0_0_0_3_3_5 - 0.0140259740259744*G0_0_0_3_4_0 - 0.0140259740259745*G0_0_0_3_4_1 + 0.140259740259745*G0_0_0_3_4_3 + 0.140259740259745*G0_0_0_3_4_4 + 0.056103896103898*G0_0_0_3_4_5 - 0.0140259740259745*G0_0_0_3_5_0 + 0.0070129870129873*G0_0_0_3_5_1 - 0.0140259740259745*G0_0_0_3_5_2 + 0.140259740259745*G0_0_0_3_5_3 + 0.056103896103898*G0_0_0_3_5_4 + 0.056103896103898*G0_0_0_3_5_5 + 0.0403246753246767*G0_0_0_4_0_0 - 0.00175324675324683*G0_0_0_4_0_1 - 0.0210389610389617*G0_0_0_4_0_2 - 0.0140259740259744*G0_0_0_4_0_3 + 0.0280519480519492*G0_0_0_4_0_4 + 0.00701298701298728*G0_0_0_4_0_5 - 0.00175324675324683*G0_0_0_4_1_0 + 0.00876623376623406*G0_0_0_4_1_1 - 0.0140259740259745*G0_0_0_4_1_3 - 0.0561038961038979*G0_0_0_4_1_4 - 0.0140259740259745*G0_0_0_4_1_5 - 0.0210389610389617*G0_0_0_4_2_0 + 0.0350649350649362*G0_0_0_4_2_2 - 0.0140259740259745*G0_0_0_4_2_5 - 0.0140259740259744*G0_0_0_4_3_0 - 0.0140259740259745*G0_0_0_4_3_1 + 0.140259740259745*G0_0_0_4_3_3 + 0.140259740259745*G0_0_0_4_3_4 + 0.056103896103898*G0_0_0_4_3_5 + 0.0280519480519492*G0_0_0_4_4_0 - 0.0561038961038979*G0_0_0_4_4_1 + 0.140259740259745*G0_0_0_4_4_3 + 0.981818181818214*G0_0_0_4_4_4 + 0.140259740259745*G0_0_0_4_4_5 + 0.00701298701298728*G0_0_0_4_5_0 - 0.0140259740259745*G0_0_0_4_5_1 - 0.0140259740259745*G0_0_0_4_5_2 + 0.056103896103898*G0_0_0_4_5_3 + 0.140259740259745*G0_0_0_4_5_4 + 0.056103896103898*G0_0_0_4_5_5 + 0.0122727272727277*G0_0_0_5_0_0 - 0.00350649350649363*G0_0_0_5_0_1 - 0.00175324675324682*G0_0_0_5_0_2 - 0.0140259740259745*G0_0_0_5_0_3 + 0.00701298701298728*G0_0_0_5_0_4 - 0.00350649350649363*G0_0_0_5_1_0 + 0.0122727272727277*G0_0_0_5_1_1 - 0.00175324675324682*G0_0_0_5_1_2 + 0.0070129870129873*G0_0_0_5_1_3 - 0.0140259740259745*G0_0_0_5_1_4 - 0.00175324675324682*G0_0_0_5_2_0 - 0.00175324675324682*G0_0_0_5_2_1 + 0.00701298701298726*G0_0_0_5_2_2 - 0.0140259740259745*G0_0_0_5_2_3 - 0.0140259740259745*G0_0_0_5_2_4 - 0.0140259740259745*G0_0_0_5_2_5 - 0.0140259740259745*G0_0_0_5_3_0 + 0.0070129870129873*G0_0_0_5_3_1 - 0.0140259740259745*G0_0_0_5_3_2 + 0.140259740259745*G0_0_0_5_3_3 + 0.056103896103898*G0_0_0_5_3_4 + 0.056103896103898*G0_0_0_5_3_5 + 0.00701298701298728*G0_0_0_5_4_0 - 0.0140259740259745*G0_0_0_5_4_1 - 0.0140259740259745*G0_0_0_5_4_2 + 0.056103896103898*G0_0_0_5_4_3 + 0.140259740259745*G0_0_0_5_4_4 + 0.0561038961038981*G0_0_0_5_4_5 - 0.0140259740259745*G0_0_0_5_5_2 + 0.056103896103898*G0_0_0_5_5_3 + 0.0561038961038981*G0_0_0_5_5_4 + 0.0561038961038981*G0_0_0_5_5_5 + 0.0105194805194809*G0_0_1_0_0_0 - 0.00219155844155852*G0_0_1_0_0_1 - 0.00219155844155852*G0_0_1_0_0_2 + 0.00525974025974042*G0_0_1_0_0_3 + 0.00876623376623409*G0_0_1_0_0_4 + 0.00876623376623409*G0_0_1_0_0_5 - 0.00219155844155852*G0_0_1_0_1_0 - 0.0004383116883117*G0_0_1_0_1_1 + 0.00131493506493511*G0_0_1_0_1_2 - 0.00175324675324682*G0_0_1_0_1_4 - 0.00175324675324683*G0_0_1_0_1_5 - 0.00219155844155852*G0_0_1_0_2_0 + 0.00131493506493511*G0_0_1_0_2_1 - 0.000438311688311693*G0_0_1_0_2_2 - 0.00175324675324681*G0_0_1_0_2_4 - 0.00175324675324682*G0_0_1_0_2_5 + 0.00525974025974042*G0_0_1_0_3_0 - 0.0490909090909106*G0_0_1_0_3_3 - 0.00701298701298721*G0_0_1_0_3_4 - 0.00701298701298723*G0_0_1_0_3_5 + 0.00876623376623409*G0_0_1_0_4_0 - 0.00175324675324682*G0_0_1_0_4_1 - 0.00175324675324681*G0_0_1_0_4_2 - 0.00701298701298721*G0_0_1_0_4_3 + 0.0140259740259745*G0_0_1_0_4_4 + 0.00701298701298728*G0_0_1_0_4_5 + 0.00876623376623409*G0_0_1_0_5_0 - 0.00175324675324683*G0_0_1_0_5_1 - 0.00175324675324682*G0_0_1_0_5_2 - 0.00701298701298723*G0_0_1_0_5_3 + 0.00701298701298728*G0_0_1_0_5_4 + 0.0140259740259745*G0_0_1_0_5_5 - 0.00219155844155852*G0_0_1_1_0_0 - 0.0004383116883117*G0_0_1_1_0_1 + 0.00131493506493511*G0_0_1_1_0_2 - 0.00175324675324682*G0_0_1_1_0_4 - 0.00175324675324683*G0_0_1_1_0_5 - 0.0004383116883117*G0_0_1_1_1_0 + 0.0131493506493511*G0_0_1_1_1_1 - 0.00306818181818193*G0_0_1_1_1_2 + 0.0315584415584427*G0_0_1_1_1_3 + 0.00350649350649363*G0_0_1_1_1_4 + 0.00350649350649365*G0_0_1_1_1_5 + 0.00131493506493511*G0_0_1_1_2_0 - 0.00306818181818193*G0_0_1_1_2_1 - 0.00306818181818192*G0_0_1_1_2_2 - 0.019285714285715*G0_0_1_1_2_3 + 0.0315584415584427*G0_0_1_1_3_1 - 0.019285714285715*G0_0_1_1_3_2 + 0.0140259740259747*G0_0_1_1_3_3 - 0.00701298701298723*G0_0_1_1_3_4 - 0.00175324675324682*G0_0_1_1_4_0 + 0.00350649350649363*G0_0_1_1_4_1 - 0.00701298701298723*G0_0_1_1_4_3 - 0.00701298701298724*G0_0_1_1_4_4 - 0.00701298701298725*G0_0_1_1_4_5 - 0.00175324675324683*G0_0_1_1_5_0 + 0.00350649350649365*G0_0_1_1_5_1 - 0.00701298701298725*G0_0_1_1_5_4 - 0.0140259740259745*G0_0_1_1_5_5 - 0.00219155844155853*G0_0_1_2_0_0 + 0.00131493506493511*G0_0_1_2_0_1 - 0.000438311688311693*G0_0_1_2_0_2 - 0.00175324675324681*G0_0_1_2_0_4 - 0.00175324675324682*G0_0_1_2_0_5 + 0.00131493506493511*G0_0_1_2_1_0 - 0.00306818181818193*G0_0_1_2_1_1 - 0.00306818181818192*G0_0_1_2_1_2 - 0.019285714285715*G0_0_1_2_1_3 - 0.000438311688311693*G0_0_1_2_2_0 - 0.00306818181818192*G0_0_1_2_2_1 + 0.0131493506493511*G0_0_1_2_2_2 + 0.0315584415584426*G0_0_1_2_2_3 + 0.00350649350649361*G0_0_1_2_2_4 + 0.00350649350649363*G0_0_1_2_2_5 - 0.019285714285715*G0_0_1_2_3_1 + 0.0315584415584426*G0_0_1_2_3_2 + 0.0140259740259745*G0_0_1_2_3_3 - 0.00701298701298726*G0_0_1_2_3_5 - 0.00175324675324681*G0_0_1_2_4_0 + 0.00350649350649361*G0_0_1_2_4_2 - 0.0140259740259745*G0_0_1_2_4_4 - 0.00701298701298726*G0_0_1_2_4_5 - 0.00175324675324682*G0_0_1_2_5_0 + 0.00350649350649363*G0_0_1_2_5_2 - 0.00701298701298726*G0_0_1_2_5_3 - 0.00701298701298726*G0_0_1_2_5_4 - 0.00701298701298726*G0_0_1_2_5_5 + 0.00525974025974042*G0_0_1_3_0_0 - 0.0490909090909106*G0_0_1_3_0_3 - 0.00701298701298721*G0_0_1_3_0_4 - 0.00701298701298723*G0_0_1_3_0_5 + 0.0315584415584427*G0_0_1_3_1_1 - 0.019285714285715*G0_0_1_3_1_2 + 0.0140259740259747*G0_0_1_3_1_3 - 0.00701298701298723*G0_0_1_3_1_4 - 0.019285714285715*G0_0_1_3_2_1 + 0.0315584415584426*G0_0_1_3_2_2 + 0.0140259740259745*G0_0_1_3_2_3 - 0.00701298701298726*G0_0_1_3_2_5 - 0.0490909090909106*G0_0_1_3_3_0 + 0.0140259740259747*G0_0_1_3_3_1 + 0.0140259740259745*G0_0_1_3_3_2 + 0.953766233766267*G0_0_1_3_3_3 + 0.112207792207796*G0_0_1_3_3_4 + 0.112207792207796*G0_0_1_3_3_5 - 0.00701298701298721*G0_0_1_3_4_0 - 0.00701298701298723*G0_0_1_3_4_1 + 0.112207792207796*G0_0_1_3_4_3 + 0.0280519480519489*G0_0_1_3_4_4 + 0.028051948051949*G0_0_1_3_4_5 - 0.00701298701298723*G0_0_1_3_5_0 - 0.00701298701298726*G0_0_1_3_5_2 + 0.112207792207796*G0_0_1_3_5_3 + 0.028051948051949*G0_0_1_3_5_4 + 0.028051948051949*G0_0_1_3_5_5 + 0.00876623376623409*G0_0_1_4_0_0 - 0.00175324675324682*G0_0_1_4_0_1 - 0.00175324675324681*G0_0_1_4_0_2 - 0.00701298701298721*G0_0_1_4_0_3 + 0.0140259740259745*G0_0_1_4_0_4 + 0.00701298701298728*G0_0_1_4_0_5 - 0.00175324675324682*G0_0_1_4_1_0 + 0.00350649350649363*G0_0_1_4_1_1 - 0.00701298701298723*G0_0_1_4_1_3 - 0.00701298701298724*G0_0_1_4_1_4 - 0.00701298701298725*G0_0_1_4_1_5 - 0.00175324675324681*G0_0_1_4_2_0 + 0.00350649350649361*G0_0_1_4_2_2 - 0.0140259740259745*G0_0_1_4_2_4 - 0.00701298701298726*G0_0_1_4_2_5 - 0.00701298701298721*G0_0_1_4_3_0 - 0.00701298701298723*G0_0_1_4_3_1 + 0.112207792207796*G0_0_1_4_3_3 + 0.0280519480519489*G0_0_1_4_3_4 + 0.028051948051949*G0_0_1_4_3_5 + 0.0140259740259745*G0_0_1_4_4_0 - 0.00701298701298724*G0_0_1_4_4_1 - 0.0140259740259745*G0_0_1_4_4_2 + 0.0280519480519489*G0_0_1_4_4_3 + 0.0280519480519488*G0_0_1_4_4_4 + 0.028051948051949*G0_0_1_4_4_5 + 0.00701298701298728*G0_0_1_4_5_0 - 0.00701298701298725*G0_0_1_4_5_1 - 0.00701298701298726*G0_0_1_4_5_2 + 0.028051948051949*G0_0_1_4_5_3 + 0.028051948051949*G0_0_1_4_5_4 + 0.028051948051949*G0_0_1_4_5_5 + 0.00876623376623409*G0_0_1_5_0_0 - 0.00175324675324683*G0_0_1_5_0_1 - 0.00175324675324682*G0_0_1_5_0_2 - 0.00701298701298723*G0_0_1_5_0_3 + 0.00701298701298728*G0_0_1_5_0_4 + 0.0140259740259745*G0_0_1_5_0_5 - 0.00175324675324683*G0_0_1_5_1_0 + 0.00350649350649365*G0_0_1_5_1_1 - 0.00701298701298725*G0_0_1_5_1_4 - 0.0140259740259745*G0_0_1_5_1_5 - 0.00175324675324682*G0_0_1_5_2_0 + 0.00350649350649363*G0_0_1_5_2_2 - 0.00701298701298726*G0_0_1_5_2_3 - 0.00701298701298726*G0_0_1_5_2_4 - 0.00701298701298726*G0_0_1_5_2_5 - 0.00701298701298723*G0_0_1_5_3_0 - 0.00701298701298726*G0_0_1_5_3_2 + 0.112207792207796*G0_0_1_5_3_3 + 0.028051948051949*G0_0_1_5_3_4 + 0.028051948051949*G0_0_1_5_3_5 + 0.00701298701298728*G0_0_1_5_4_0 - 0.00701298701298725*G0_0_1_5_4_1 - 0.00701298701298726*G0_0_1_5_4_2 + 0.028051948051949*G0_0_1_5_4_3 + 0.028051948051949*G0_0_1_5_4_4 + 0.028051948051949*G0_0_1_5_4_5 + 0.0140259740259745*G0_0_1_5_5_0 - 0.0140259740259745*G0_0_1_5_5_1 - 0.00701298701298726*G0_0_1_5_5_2 + 0.028051948051949*G0_0_1_5_5_3 + 0.028051948051949*G0_0_1_5_5_4 + 0.0280519480519491*G0_0_1_5_5_5 + 0.0105194805194809*G0_1_0_0_0_0 - 0.00219155844155852*G0_1_0_0_0_1 - 0.00219155844155852*G0_1_0_0_0_2 + 0.00525974025974042*G0_1_0_0_0_3 + 0.00876623376623409*G0_1_0_0_0_4 + 0.0087662337662341*G0_1_0_0_0_5 - 0.00219155844155852*G0_1_0_0_1_0 - 0.0004383116883117*G0_1_0_0_1_1 + 0.00131493506493511*G0_1_0_0_1_2 - 0.00175324675324682*G0_1_0_0_1_4 - 0.00175324675324683*G0_1_0_0_1_5 - 0.00219155844155852*G0_1_0_0_2_0 + 0.00131493506493511*G0_1_0_0_2_1 - 0.000438311688311693*G0_1_0_0_2_2 - 0.00175324675324681*G0_1_0_0_2_4 - 0.00175324675324682*G0_1_0_0_2_5 + 0.00525974025974042*G0_1_0_0_3_0 - 0.0490909090909106*G0_1_0_0_3_3 - 0.00701298701298721*G0_1_0_0_3_4 - 0.00701298701298723*G0_1_0_0_3_5 + 0.00876623376623409*G0_1_0_0_4_0 - 0.00175324675324682*G0_1_0_0_4_1 - 0.00175324675324681*G0_1_0_0_4_2 - 0.00701298701298721*G0_1_0_0_4_3 + 0.0140259740259745*G0_1_0_0_4_4 + 0.00701298701298728*G0_1_0_0_4_5 + 0.0087662337662341*G0_1_0_0_5_0 - 0.00175324675324683*G0_1_0_0_5_1 - 0.00175324675324682*G0_1_0_0_5_2 - 0.00701298701298723*G0_1_0_0_5_3 + 0.00701298701298728*G0_1_0_0_5_4 + 0.0140259740259745*G0_1_0_0_5_5 - 0.00219155844155852*G0_1_0_1_0_0 - 0.0004383116883117*G0_1_0_1_0_1 + 0.00131493506493511*G0_1_0_1_0_2 - 0.00175324675324682*G0_1_0_1_0_4 - 0.00175324675324683*G0_1_0_1_0_5 - 0.0004383116883117*G0_1_0_1_1_0 + 0.0131493506493511*G0_1_0_1_1_1 - 0.00306818181818193*G0_1_0_1_1_2 + 0.0315584415584427*G0_1_0_1_1_3 + 0.00350649350649363*G0_1_0_1_1_4 + 0.00350649350649365*G0_1_0_1_1_5 + 0.00131493506493511*G0_1_0_1_2_0 - 0.00306818181818193*G0_1_0_1_2_1 - 0.00306818181818192*G0_1_0_1_2_2 - 0.019285714285715*G0_1_0_1_2_3 + 0.0315584415584427*G0_1_0_1_3_1 - 0.019285714285715*G0_1_0_1_3_2 + 0.0140259740259747*G0_1_0_1_3_3 - 0.00701298701298723*G0_1_0_1_3_4 - 0.00175324675324682*G0_1_0_1_4_0 + 0.00350649350649363*G0_1_0_1_4_1 - 0.00701298701298723*G0_1_0_1_4_3 - 0.00701298701298724*G0_1_0_1_4_4 - 0.00701298701298725*G0_1_0_1_4_5 - 0.00175324675324683*G0_1_0_1_5_0 + 0.00350649350649365*G0_1_0_1_5_1 - 0.00701298701298725*G0_1_0_1_5_4 - 0.0140259740259745*G0_1_0_1_5_5 - 0.00219155844155853*G0_1_0_2_0_0 + 0.00131493506493511*G0_1_0_2_0_1 - 0.000438311688311693*G0_1_0_2_0_2 - 0.00175324675324681*G0_1_0_2_0_4 - 0.00175324675324682*G0_1_0_2_0_5 + 0.00131493506493511*G0_1_0_2_1_0 - 0.00306818181818193*G0_1_0_2_1_1 - 0.00306818181818192*G0_1_0_2_1_2 - 0.019285714285715*G0_1_0_2_1_3 - 0.000438311688311693*G0_1_0_2_2_0 - 0.00306818181818192*G0_1_0_2_2_1 + 0.0131493506493511*G0_1_0_2_2_2 + 0.0315584415584426*G0_1_0_2_2_3 + 0.00350649350649361*G0_1_0_2_2_4 + 0.00350649350649363*G0_1_0_2_2_5 - 0.019285714285715*G0_1_0_2_3_1 + 0.0315584415584426*G0_1_0_2_3_2 + 0.0140259740259745*G0_1_0_2_3_3 - 0.00701298701298726*G0_1_0_2_3_5 - 0.00175324675324681*G0_1_0_2_4_0 + 0.00350649350649361*G0_1_0_2_4_2 - 0.0140259740259745*G0_1_0_2_4_4 - 0.00701298701298726*G0_1_0_2_4_5 - 0.00175324675324682*G0_1_0_2_5_0 + 0.00350649350649363*G0_1_0_2_5_2 - 0.00701298701298726*G0_1_0_2_5_3 - 0.00701298701298726*G0_1_0_2_5_4 - 0.00701298701298727*G0_1_0_2_5_5 + 0.00525974025974042*G0_1_0_3_0_0 - 0.0490909090909106*G0_1_0_3_0_3 - 0.00701298701298721*G0_1_0_3_0_4 - 0.00701298701298723*G0_1_0_3_0_5 + 0.0315584415584427*G0_1_0_3_1_1 - 0.019285714285715*G0_1_0_3_1_2 + 0.0140259740259747*G0_1_0_3_1_3 - 0.00701298701298723*G0_1_0_3_1_4 - 0.019285714285715*G0_1_0_3_2_1 + 0.0315584415584426*G0_1_0_3_2_2 + 0.0140259740259745*G0_1_0_3_2_3 - 0.00701298701298726*G0_1_0_3_2_5 - 0.0490909090909106*G0_1_0_3_3_0 + 0.0140259740259747*G0_1_0_3_3_1 + 0.0140259740259745*G0_1_0_3_3_2 + 0.953766233766267*G0_1_0_3_3_3 + 0.112207792207796*G0_1_0_3_3_4 + 0.112207792207796*G0_1_0_3_3_5 - 0.00701298701298721*G0_1_0_3_4_0 - 0.00701298701298723*G0_1_0_3_4_1 + 0.112207792207796*G0_1_0_3_4_3 + 0.0280519480519489*G0_1_0_3_4_4 + 0.028051948051949*G0_1_0_3_4_5 - 0.00701298701298723*G0_1_0_3_5_0 - 0.00701298701298726*G0_1_0_3_5_2 + 0.112207792207796*G0_1_0_3_5_3 + 0.028051948051949*G0_1_0_3_5_4 + 0.028051948051949*G0_1_0_3_5_5 + 0.00876623376623409*G0_1_0_4_0_0 - 0.00175324675324682*G0_1_0_4_0_1 - 0.00175324675324681*G0_1_0_4_0_2 - 0.00701298701298721*G0_1_0_4_0_3 + 0.0140259740259745*G0_1_0_4_0_4 + 0.00701298701298728*G0_1_0_4_0_5 - 0.00175324675324682*G0_1_0_4_1_0 + 0.00350649350649363*G0_1_0_4_1_1 - 0.00701298701298723*G0_1_0_4_1_3 - 0.00701298701298724*G0_1_0_4_1_4 - 0.00701298701298725*G0_1_0_4_1_5 - 0.00175324675324681*G0_1_0_4_2_0 + 0.00350649350649361*G0_1_0_4_2_2 - 0.0140259740259745*G0_1_0_4_2_4 - 0.00701298701298726*G0_1_0_4_2_5 - 0.00701298701298721*G0_1_0_4_3_0 - 0.00701298701298723*G0_1_0_4_3_1 + 0.112207792207796*G0_1_0_4_3_3 + 0.0280519480519489*G0_1_0_4_3_4 + 0.028051948051949*G0_1_0_4_3_5 + 0.0140259740259745*G0_1_0_4_4_0 - 0.00701298701298724*G0_1_0_4_4_1 - 0.0140259740259745*G0_1_0_4_4_2 + 0.0280519480519489*G0_1_0_4_4_3 + 0.0280519480519488*G0_1_0_4_4_4 + 0.028051948051949*G0_1_0_4_4_5 + 0.00701298701298728*G0_1_0_4_5_0 - 0.00701298701298725*G0_1_0_4_5_1 - 0.00701298701298726*G0_1_0_4_5_2 + 0.028051948051949*G0_1_0_4_5_3 + 0.028051948051949*G0_1_0_4_5_4 + 0.028051948051949*G0_1_0_4_5_5 + 0.00876623376623409*G0_1_0_5_0_0 - 0.00175324675324683*G0_1_0_5_0_1 - 0.00175324675324682*G0_1_0_5_0_2 - 0.00701298701298723*G0_1_0_5_0_3 + 0.00701298701298728*G0_1_0_5_0_4 + 0.0140259740259745*G0_1_0_5_0_5 - 0.00175324675324683*G0_1_0_5_1_0 + 0.00350649350649365*G0_1_0_5_1_1 - 0.00701298701298725*G0_1_0_5_1_4 - 0.0140259740259745*G0_1_0_5_1_5 - 0.00175324675324682*G0_1_0_5_2_0 + 0.00350649350649363*G0_1_0_5_2_2 - 0.00701298701298726*G0_1_0_5_2_3 - 0.00701298701298726*G0_1_0_5_2_4 - 0.00701298701298726*G0_1_0_5_2_5 - 0.00701298701298723*G0_1_0_5_3_0 - 0.00701298701298726*G0_1_0_5_3_2 + 0.112207792207796*G0_1_0_5_3_3 + 0.028051948051949*G0_1_0_5_3_4 + 0.028051948051949*G0_1_0_5_3_5 + 0.00701298701298728*G0_1_0_5_4_0 - 0.00701298701298725*G0_1_0_5_4_1 - 0.00701298701298726*G0_1_0_5_4_2 + 0.028051948051949*G0_1_0_5_4_3 + 0.028051948051949*G0_1_0_5_4_4 + 0.028051948051949*G0_1_0_5_4_5 + 0.0140259740259745*G0_1_0_5_5_0 - 0.0140259740259745*G0_1_0_5_5_1 - 0.00701298701298726*G0_1_0_5_5_2 + 0.028051948051949*G0_1_0_5_5_3 + 0.028051948051949*G0_1_0_5_5_4 + 0.0280519480519491*G0_1_0_5_5_5 + 0.0236688311688321*G0_1_1_0_0_0 - 0.00525974025974047*G0_1_1_0_0_1 - 0.00262987012987023*G0_1_1_0_0_2 + 0.00876623376623404*G0_1_1_0_0_3 + 0.0122727272727277*G0_1_1_0_0_4 + 0.0403246753246769*G0_1_1_0_0_5 - 0.00525974025974047*G0_1_1_0_1_0 - 0.00350649350649362*G0_1_1_0_1_1 + 0.00262987012987022*G0_1_1_0_1_2 - 0.00175324675324683*G0_1_1_0_1_4 - 0.0210389610389618*G0_1_1_0_1_5 - 0.00262987012987023*G0_1_1_0_2_0 + 0.00262987012987022*G0_1_1_0_2_1 - 0.00262987012987021*G0_1_1_0_2_2 - 0.00175324675324681*G0_1_1_0_2_3 - 0.00350649350649363*G0_1_1_0_2_4 - 0.00175324675324684*G0_1_1_0_2_5 + 0.00876623376623404*G0_1_1_0_3_0 - 0.00175324675324681*G0_1_1_0_3_2 - 0.0561038961038978*G0_1_1_0_3_3 - 0.0140259740259745*G0_1_1_0_3_4 - 0.0140259740259745*G0_1_1_0_3_5 + 0.0122727272727277*G0_1_1_0_4_0 - 0.00175324675324683*G0_1_1_0_4_1 - 0.00350649350649363*G0_1_1_0_4_2 - 0.0140259740259745*G0_1_1_0_4_3 + 0.00701298701298733*G0_1_1_0_4_5 + 0.0403246753246769*G0_1_1_0_5_0 - 0.0210389610389618*G0_1_1_0_5_1 - 0.00175324675324684*G0_1_1_0_5_2 - 0.0140259740259745*G0_1_1_0_5_3 + 0.00701298701298733*G0_1_1_0_5_4 + 0.0280519480519494*G0_1_1_0_5_5 - 0.00525974025974047*G0_1_1_1_0_0 - 0.00350649350649362*G0_1_1_1_0_1 + 0.00262987012987022*G0_1_1_1_0_2 - 0.00175324675324683*G0_1_1_1_0_4 - 0.0210389610389618*G0_1_1_1_0_5 - 0.00350649350649362*G0_1_1_1_1_0 + 0.0262987012987023*G0_1_1_1_1_1 - 0.00350649350649363*G0_1_1_1_1_2 + 0.0350649350649363*G0_1_1_1_1_3 + 0.00701298701298725*G0_1_1_1_1_4 + 0.0350649350649364*G0_1_1_1_1_5 + 0.00262987012987022*G0_1_1_1_2_0 - 0.00350649350649363*G0_1_1_1_2_1 - 0.00525974025974044*G0_1_1_1_2_2 - 0.0210389610389618*G0_1_1_1_2_3 - 0.00175324675324681*G0_1_1_1_2_4 + 0.0350649350649363*G0_1_1_1_3_1 - 0.0210389610389618*G0_1_1_1_3_2 - 0.0140259740259745*G0_1_1_1_3_4 - 0.00175324675324683*G0_1_1_1_4_0 + 0.00701298701298725*G0_1_1_1_4_1 - 0.00175324675324681*G0_1_1_1_4_2 - 0.0140259740259745*G0_1_1_1_4_3 - 0.0140259740259745*G0_1_1_1_4_4 - 0.0140259740259745*G0_1_1_1_4_5 - 0.0210389610389618*G0_1_1_1_5_0 + 0.0350649350649364*G0_1_1_1_5_1 - 0.0140259740259745*G0_1_1_1_5_4 - 0.00262987012987023*G0_1_1_2_0_0 + 0.00262987012987022*G0_1_1_2_0_1 - 0.00262987012987021*G0_1_1_2_0_2 - 0.00175324675324681*G0_1_1_2_0_3 - 0.00350649350649363*G0_1_1_2_0_4 - 0.00175324675324684*G0_1_1_2_0_5 + 0.00262987012987022*G0_1_1_2_1_0 - 0.00350649350649363*G0_1_1_2_1_1 - 0.00525974025974044*G0_1_1_2_1_2 - 0.0210389610389618*G0_1_1_2_1_3 - 0.00175324675324681*G0_1_1_2_1_4 - 0.00262987012987021*G0_1_1_2_2_0 - 0.00525974025974044*G0_1_1_2_2_1 + 0.023668831168832*G0_1_1_2_2_2 + 0.0403246753246767*G0_1_1_2_2_3 + 0.0122727272727277*G0_1_1_2_2_4 + 0.00876623376623408*G0_1_1_2_2_5 - 0.00175324675324681*G0_1_1_2_3_0 - 0.0210389610389618*G0_1_1_2_3_1 + 0.0403246753246767*G0_1_1_2_3_2 + 0.028051948051949*G0_1_1_2_3_3 + 0.00701298701298725*G0_1_1_2_3_4 - 0.0140259740259745*G0_1_1_2_3_5 - 0.00350649350649363*G0_1_1_2_4_0 - 0.00175324675324681*G0_1_1_2_4_1 + 0.0122727272727277*G0_1_1_2_4_2 + 0.00701298701298725*G0_1_1_2_4_3 - 0.0140259740259745*G0_1_1_2_4_5 - 0.00175324675324684*G0_1_1_2_5_0 + 0.00876623376623408*G0_1_1_2_5_2 - 0.0140259740259745*G0_1_1_2_5_3 - 0.0140259740259745*G0_1_1_2_5_4 - 0.0561038961038981*G0_1_1_2_5_5 + 0.00876623376623404*G0_1_1_3_0_0 - 0.00175324675324681*G0_1_1_3_0_2 - 0.0561038961038978*G0_1_1_3_0_3 - 0.0140259740259745*G0_1_1_3_0_4 - 0.0140259740259745*G0_1_1_3_0_5 + 0.0350649350649363*G0_1_1_3_1_1 - 0.0210389610389618*G0_1_1_3_1_2 - 0.0140259740259745*G0_1_1_3_1_4 - 0.00175324675324681*G0_1_1_3_2_0 - 0.0210389610389618*G0_1_1_3_2_1 + 0.0403246753246767*G0_1_1_3_2_2 + 0.028051948051949*G0_1_1_3_2_3 + 0.00701298701298725*G0_1_1_3_2_4 - 0.0140259740259745*G0_1_1_3_2_5 - 0.0561038961038978*G0_1_1_3_3_0 + 0.028051948051949*G0_1_1_3_3_2 + 0.981818181818216*G0_1_1_3_3_3 + 0.140259740259745*G0_1_1_3_3_4 + 0.140259740259745*G0_1_1_3_3_5 - 0.0140259740259745*G0_1_1_3_4_0 - 0.0140259740259745*G0_1_1_3_4_1 + 0.00701298701298725*G0_1_1_3_4_2 + 0.140259740259745*G0_1_1_3_4_3 + 0.056103896103898*G0_1_1_3_4_4 + 0.056103896103898*G0_1_1_3_4_5 - 0.0140259740259745*G0_1_1_3_5_0 - 0.0140259740259745*G0_1_1_3_5_2 + 0.140259740259745*G0_1_1_3_5_3 + 0.056103896103898*G0_1_1_3_5_4 + 0.140259740259745*G0_1_1_3_5_5 + 0.0122727272727277*G0_1_1_4_0_0 - 0.00175324675324683*G0_1_1_4_0_1 - 0.00350649350649363*G0_1_1_4_0_2 - 0.0140259740259745*G0_1_1_4_0_3 + 0.00701298701298733*G0_1_1_4_0_5 - 0.00175324675324683*G0_1_1_4_1_0 + 0.00701298701298725*G0_1_1_4_1_1 - 0.00175324675324681*G0_1_1_4_1_2 - 0.0140259740259745*G0_1_1_4_1_3 - 0.0140259740259745*G0_1_1_4_1_4 - 0.0140259740259745*G0_1_1_4_1_5 - 0.00350649350649363*G0_1_1_4_2_0 - 0.00175324675324681*G0_1_1_4_2_1 + 0.0122727272727277*G0_1_1_4_2_2 + 0.00701298701298725*G0_1_1_4_2_3 - 0.0140259740259745*G0_1_1_4_2_5 - 0.0140259740259745*G0_1_1_4_3_0 - 0.0140259740259745*G0_1_1_4_3_1 + 0.00701298701298725*G0_1_1_4_3_2 + 0.140259740259745*G0_1_1_4_3_3 + 0.056103896103898*G0_1_1_4_3_4 + 0.056103896103898*G0_1_1_4_3_5 - 0.0140259740259745*G0_1_1_4_4_1 + 0.056103896103898*G0_1_1_4_4_3 + 0.056103896103898*G0_1_1_4_4_4 + 0.0561038961038981*G0_1_1_4_4_5 + 0.00701298701298733*G0_1_1_4_5_0 - 0.0140259740259745*G0_1_1_4_5_1 - 0.0140259740259745*G0_1_1_4_5_2 + 0.056103896103898*G0_1_1_4_5_3 + 0.0561038961038981*G0_1_1_4_5_4 + 0.140259740259745*G0_1_1_4_5_5 + 0.0403246753246769*G0_1_1_5_0_0 - 0.0210389610389618*G0_1_1_5_0_1 - 0.00175324675324684*G0_1_1_5_0_2 - 0.0140259740259745*G0_1_1_5_0_3 + 0.00701298701298733*G0_1_1_5_0_4 + 0.0280519480519494*G0_1_1_5_0_5 - 0.0210389610389618*G0_1_1_5_1_0 + 0.0350649350649364*G0_1_1_5_1_1 - 0.0140259740259745*G0_1_1_5_1_4 - 0.00175324675324684*G0_1_1_5_2_0 + 0.00876623376623408*G0_1_1_5_2_2 - 0.0140259740259745*G0_1_1_5_2_3 - 0.0140259740259745*G0_1_1_5_2_4 - 0.0561038961038981*G0_1_1_5_2_5 - 0.0140259740259745*G0_1_1_5_3_0 - 0.0140259740259745*G0_1_1_5_3_2 + 0.140259740259745*G0_1_1_5_3_3 + 0.056103896103898*G0_1_1_5_3_4 + 0.140259740259745*G0_1_1_5_3_5 + 0.00701298701298733*G0_1_1_5_4_0 - 0.0140259740259745*G0_1_1_5_4_1 - 0.0140259740259745*G0_1_1_5_4_2 + 0.056103896103898*G0_1_1_5_4_3 + 0.0561038961038981*G0_1_1_5_4_4 + 0.140259740259745*G0_1_1_5_4_5 + 0.0280519480519494*G0_1_1_5_5_0 - 0.0561038961038981*G0_1_1_5_5_2 + 0.140259740259745*G0_1_1_5_5_3 + 0.140259740259745*G0_1_1_5_5_4 + 0.981818181818217*G0_1_1_5_5_5;
    A[78] = -A[73] - 0.109760551948056*G0_0_0_0_0_0 + 0.0045170454545456*G0_0_0_0_0_1 + 0.00976461038961071*G0_0_0_0_0_2 - 0.0037500000000001*G0_0_0_0_0_3 - 0.0431006493506508*G0_0_0_0_0_4 - 0.0224025974025982*G0_0_0_0_0_5 + 0.0045170454545456*G0_0_0_0_1_0 + 0.00304383116883126*G0_0_0_0_1_1 - 0.000560064935064955*G0_0_0_0_1_2 + 0.000243506493506504*G0_0_0_0_1_3 + 0.00180194805194812*G0_0_0_0_1_4 + 0.00340909090909104*G0_0_0_0_1_5 + 0.00976461038961071*G0_0_0_0_2_0 - 0.000560064935064955*G0_0_0_0_2_1 - 0.00152191558441564*G0_0_0_0_2_2 - 0.00175324675324681*G0_0_0_0_2_3 + 0.00584415584415604*G0_0_0_0_2_4 - 0.000925324675324697*G0_0_0_0_2_5 - 0.0037500000000001*G0_0_0_0_3_0 + 0.000243506493506504*G0_0_0_0_3_1 - 0.00175324675324681*G0_0_0_0_3_2 + 0.00487012987013002*G0_0_0_0_3_3 + 0.00389610389610401*G0_0_0_0_3_4 + 0.00935064935064964*G0_0_0_0_3_5 - 0.0431006493506508*G0_0_0_0_4_0 + 0.00180194805194812*G0_0_0_0_4_1 + 0.00584415584415604*G0_0_0_0_4_2 + 0.00389610389610402*G0_0_0_0_4_3 - 0.0374025974025987*G0_0_0_0_4_4 - 0.00175324675324684*G0_0_0_0_4_5 - 0.0224025974025982*G0_0_0_0_5_0 + 0.00340909090909104*G0_0_0_0_5_1 - 0.000925324675324697*G0_0_0_0_5_2 + 0.00935064935064964*G0_0_0_0_5_3 - 0.00175324675324684*G0_0_0_0_5_4 + 0.010714285714286*G0_0_0_0_5_5 + 0.0045170454545456*G0_0_0_1_0_0 + 0.00304383116883126*G0_0_0_1_0_1 - 0.000560064935064955*G0_0_0_1_0_2 + 0.000243506493506504*G0_0_0_1_0_3 + 0.00180194805194812*G0_0_0_1_0_4 + 0.00340909090909104*G0_0_0_1_0_5 + 0.00304383116883126*G0_0_0_1_1_0 - 0.0814529220779248*G0_0_0_1_1_1 + 0.00511363636363653*G0_0_0_1_1_2 - 0.0197240259740266*G0_0_0_1_1_3 - 0.00267857142857151*G0_0_0_1_1_4 - 0.0168019480519487*G0_0_0_1_1_5 - 0.000560064935064955*G0_0_0_1_2_0 + 0.00511363636363653*G0_0_0_1_2_1 - 0.000206980519480525*G0_0_0_1_2_2 - 0.000487012987013005*G0_0_0_1_2_3 - 0.00224025974025981*G0_0_0_1_2_4 - 0.0012175324675325*G0_0_0_1_2_5 + 0.000243506493506504*G0_0_0_1_3_0 - 0.0197240259740266*G0_0_0_1_3_1 - 0.000487012987013004*G0_0_0_1_3_2 - 0.002922077922078*G0_0_0_1_3_3 + 0.00487012987013002*G0_0_0_1_3_4 + 0.00194805194805199*G0_0_0_1_3_5 + 0.00180194805194812*G0_0_0_1_4_0 - 0.00267857142857151*G0_0_0_1_4_1 - 0.00224025974025981*G0_0_0_1_4_2 + 0.00487012987013002*G0_0_0_1_4_3 + 0.00974025974026006*G0_0_0_1_4_4 + 0.00779220779220805*G0_0_0_1_4_5 + 0.00340909090909104*G0_0_0_1_5_0 - 0.0168019480519487*G0_0_0_1_5_1 - 0.0012175324675325*G0_0_0_1_5_2 + 0.00194805194805199*G0_0_0_1_5_3 + 0.00779220779220805*G0_0_0_1_5_4 + 0.00487012987012997*G0_0_0_1_5_5 + 0.00976461038961071*G0_0_0_2_0_0 - 0.000560064935064955*G0_0_0_2_0_1 - 0.00152191558441564*G0_0_0_2_0_2 - 0.00175324675324681*G0_0_0_2_0_3 + 0.00584415584415604*G0_0_0_2_0_4 - 0.000925324675324697*G0_0_0_2_0_5 - 0.000560064935064955*G0_0_0_2_1_0 + 0.00511363636363653*G0_0_0_2_1_1 - 0.000206980519480525*G0_0_0_2_1_2 - 0.000487012987013004*G0_0_0_2_1_3 - 0.00224025974025981*G0_0_0_2_1_4 - 0.0012175324675325*G0_0_0_2_1_5 - 0.00152191558441564*G0_0_0_2_2_0 - 0.000206980519480525*G0_0_0_2_2_1 + 0.00372564935064946*G0_0_0_2_2_2 - 0.000438311688311701*G0_0_0_2_2_3 - 0.00199675324675331*G0_0_0_2_2_4 - 0.00438311688311703*G0_0_0_2_2_5 - 0.00175324675324681*G0_0_0_2_3_0 - 0.000487012987013004*G0_0_0_2_3_1 - 0.000438311688311701*G0_0_0_2_3_2 + 0.00974025974026005*G0_0_0_2_3_3 + 0.00798701298701325*G0_0_0_2_3_4 + 0.0122727272727277*G0_0_0_2_3_5 + 0.00584415584415604*G0_0_0_2_4_0 - 0.00224025974025981*G0_0_0_2_4_1 - 0.00199675324675331*G0_0_0_2_4_2 + 0.00798701298701325*G0_0_0_2_4_3 + 0.0237662337662346*G0_0_0_2_4_4 + 0.0132467532467537*G0_0_0_2_4_5 - 0.000925324675324697*G0_0_0_2_5_0 - 0.0012175324675325*G0_0_0_2_5_1 - 0.00438311688311703*G0_0_0_2_5_2 + 0.0122727272727277*G0_0_0_2_5_3 + 0.0132467532467537*G0_0_0_2_5_4 + 0.0292207792207802*G0_0_0_2_5_5 - 0.0037500000000001*G0_0_0_3_0_0 + 0.000243506493506504*G0_0_0_3_0_1 - 0.00175324675324681*G0_0_0_3_0_2 + 0.00487012987013003*G0_0_0_3_0_3 + 0.00389610389610401*G0_0_0_3_0_4 + 0.00935064935064964*G0_0_0_3_0_5 + 0.000243506493506504*G0_0_0_3_1_0 - 0.0197240259740266*G0_0_0_3_1_1 - 0.000487012987013005*G0_0_0_3_1_2 - 0.002922077922078*G0_0_0_3_1_3 + 0.00487012987013002*G0_0_0_3_1_4 + 0.00194805194805199*G0_0_0_3_1_5 - 0.00175324675324681*G0_0_0_3_2_0 - 0.000487012987013006*G0_0_0_3_2_1 - 0.0004383116883117*G0_0_0_3_2_2 + 0.00974025974026005*G0_0_0_3_2_3 + 0.00798701298701325*G0_0_0_3_2_4 + 0.0122727272727277*G0_0_0_3_2_5 + 0.00487012987013002*G0_0_0_3_3_0 - 0.002922077922078*G0_0_0_3_3_1 + 0.00974025974026005*G0_0_0_3_3_2 + 0.0677922077922102*G0_0_0_3_3_3 - 0.0194805194805201*G0_0_0_3_3_4 - 0.0342857142857154*G0_0_0_3_3_5 + 0.00389610389610401*G0_0_0_3_4_0 + 0.00487012987013002*G0_0_0_3_4_1 + 0.00798701298701325*G0_0_0_3_4_2 - 0.0194805194805201*G0_0_0_3_4_3 - 0.0272727272727281*G0_0_0_3_4_4 - 0.0342857142857154*G0_0_0_3_4_5 + 0.00935064935064964*G0_0_0_3_5_0 + 0.00194805194805199*G0_0_0_3_5_1 + 0.0122727272727277*G0_0_0_3_5_2 - 0.0342857142857154*G0_0_0_3_5_3 - 0.0342857142857154*G0_0_0_3_5_4 - 0.0771428571428597*G0_0_0_3_5_5 - 0.0431006493506508*G0_0_0_4_0_0 + 0.00180194805194812*G0_0_0_4_0_1 + 0.00584415584415604*G0_0_0_4_0_2 + 0.00389610389610401*G0_0_0_4_0_3 - 0.0374025974025987*G0_0_0_4_0_4 - 0.00175324675324684*G0_0_0_4_0_5 + 0.00180194805194812*G0_0_0_4_1_0 - 0.00267857142857151*G0_0_0_4_1_1 - 0.00224025974025981*G0_0_0_4_1_2 + 0.00487012987013002*G0_0_0_4_1_3 + 0.00974025974026006*G0_0_0_4_1_4 + 0.00779220779220805*G0_0_0_4_1_5 + 0.00584415584415604*G0_0_0_4_2_0 - 0.00224025974025981*G0_0_0_4_2_1 - 0.00199675324675331*G0_0_0_4_2_2 + 0.00798701298701325*G0_0_0_4_2_3 + 0.0237662337662346*G0_0_0_4_2_4 + 0.0132467532467537*G0_0_0_4_2_5 + 0.00389610389610401*G0_0_0_4_3_0 + 0.00487012987013002*G0_0_0_4_3_1 + 0.00798701298701325*G0_0_0_4_3_2 - 0.0194805194805201*G0_0_0_4_3_3 - 0.0272727272727281*G0_0_0_4_3_4 - 0.0342857142857154*G0_0_0_4_3_5 - 0.0374025974025987*G0_0_0_4_4_0 + 0.00974025974026006*G0_0_0_4_4_1 + 0.0237662337662346*G0_0_0_4_4_2 - 0.0272727272727281*G0_0_0_4_4_3 - 0.128571428571433*G0_0_0_4_4_4 - 0.0459740259740275*G0_0_0_4_4_5 - 0.00175324675324684*G0_0_0_4_5_0 + 0.00779220779220805*G0_0_0_4_5_1 + 0.0132467532467537*G0_0_0_4_5_2 - 0.0342857142857154*G0_0_0_4_5_3 - 0.0459740259740275*G0_0_0_4_5_4 - 0.0740259740259765*G0_0_0_4_5_5 - 0.0224025974025982*G0_0_0_5_0_0 + 0.00340909090909104*G0_0_0_5_0_1 - 0.000925324675324697*G0_0_0_5_0_2 + 0.00935064935064964*G0_0_0_5_0_3 - 0.00175324675324684*G0_0_0_5_0_4 + 0.010714285714286*G0_0_0_5_0_5 + 0.00340909090909104*G0_0_0_5_1_0 - 0.0168019480519487*G0_0_0_5_1_1 - 0.0012175324675325*G0_0_0_5_1_2 + 0.00194805194805199*G0_0_0_5_1_3 + 0.00779220779220805*G0_0_0_5_1_4 + 0.00487012987012998*G0_0_0_5_1_5 - 0.000925324675324697*G0_0_0_5_2_0 - 0.0012175324675325*G0_0_0_5_2_1 - 0.00438311688311703*G0_0_0_5_2_2 + 0.0122727272727277*G0_0_0_5_2_3 + 0.0132467532467537*G0_0_0_5_2_4 + 0.0292207792207802*G0_0_0_5_2_5 + 0.00935064935064964*G0_0_0_5_3_0 + 0.00194805194805199*G0_0_0_5_3_1 + 0.0122727272727277*G0_0_0_5_3_2 - 0.0342857142857154*G0_0_0_5_3_3 - 0.0342857142857154*G0_0_0_5_3_4 - 0.0771428571428597*G0_0_0_5_3_5 - 0.00175324675324684*G0_0_0_5_4_0 + 0.00779220779220805*G0_0_0_5_4_1 + 0.0132467532467537*G0_0_0_5_4_2 - 0.0342857142857154*G0_0_0_5_4_3 - 0.0459740259740275*G0_0_0_5_4_4 - 0.0740259740259765*G0_0_0_5_4_5 + 0.010714285714286*G0_0_0_5_5_0 + 0.00487012987012998*G0_0_0_5_5_1 + 0.0292207792207802*G0_0_0_5_5_2 - 0.0771428571428597*G0_0_0_5_5_3 - 0.0740259740259765*G0_0_0_5_5_4 - 0.317922077922089*G0_0_0_5_5_5 + 0.0100446428571432*G0_1_0_0_0_0 - 0.000231331168831178*G0_1_0_0_0_2 - 0.00165584415584421*G0_1_0_0_0_3 + 0.00267857142857152*G0_1_0_0_0_4 - 0.00681818181818207*G0_1_0_0_0_5 + 0.00328733766233776*G0_1_0_0_1_1 - 0.000121753246753253*G0_1_0_0_1_2 + 0.000487012987013005*G0_1_0_0_1_3 - 0.000487012987012999*G0_1_0_0_1_4 + 0.00487012987013006*G0_1_0_0_1_5 - 0.000231331168831178*G0_1_0_0_2_0 - 0.000121753246753253*G0_1_0_0_2_1 + 0.000572240259740282*G0_1_0_0_2_2 - 0.0016558441558442*G0_1_0_0_2_3 - 0.0022402597402598*G0_1_0_0_2_4 - 0.001948051948052*G0_1_0_0_2_5 - 0.00165584415584421*G0_1_0_0_3_0 + 0.000487012987013005*G0_1_0_0_3_1 - 0.0016558441558442*G0_1_0_0_3_2 + 0.000974025974026009*G0_1_0_0_3_3 + 0.00428571428571442*G0_1_0_0_3_4 + 0.00720779220779242*G0_1_0_0_3_5 + 0.00267857142857152*G0_1_0_0_4_0 - 0.000487012987012999*G0_1_0_0_4_1 - 0.00224025974025981*G0_1_0_0_4_2 + 0.00428571428571442*G0_1_0_0_4_3 + 0.00857142857142885*G0_1_0_0_4_4 + 0.00487012987013*G0_1_0_0_4_5 - 0.00681818181818207*G0_1_0_0_5_0 + 0.00487012987013006*G0_1_0_0_5_1 - 0.001948051948052*G0_1_0_0_5_2 + 0.00720779220779242*G0_1_0_0_5_3 + 0.00487012987013*G0_1_0_0_5_4 - 0.00175324675324698*G0_1_0_0_5_5 + 0.00328733766233776*G0_1_0_1_0_1 - 0.000121753246753253*G0_1_0_1_0_2 + 0.000487012987013005*G0_1_0_1_0_3 - 0.000487012987012999*G0_1_0_1_0_4 + 0.00487012987013006*G0_1_0_1_0_5 + 0.00328733766233776*G0_1_0_1_1_0 - 0.085470779220782*G0_1_0_1_1_1 + 0.00547889610389628*G0_1_0_1_1_2 - 0.0204545454545461*G0_1_0_1_1_3 - 0.00292207792207801*G0_1_0_1_1_4 - 0.0204545454545462*G0_1_0_1_1_5 - 0.000121753246753253*G0_1_0_1_2_0 + 0.00547889610389628*G0_1_0_1_2_1 - 0.000974025974026008*G0_1_0_1_2_3 - 0.00194805194805201*G0_1_0_1_2_4 - 0.00243506493506501*G0_1_0_1_2_5 + 0.000487012987013005*G0_1_0_1_3_0 - 0.0204545454545461*G0_1_0_1_3_1 - 0.000974025974026008*G0_1_0_1_3_2 - 0.00389610389610399*G0_1_0_1_3_3 + 0.00487012987013003*G0_1_0_1_3_4 + 0.00389610389610401*G0_1_0_1_3_5 - 0.000487012987012999*G0_1_0_1_4_0 - 0.00292207792207801*G0_1_0_1_4_1 - 0.00194805194805201*G0_1_0_1_4_2 + 0.00487012987013003*G0_1_0_1_4_3 + 0.00584415584415604*G0_1_0_1_4_4 + 0.0107142857142861*G0_1_0_1_4_5 + 0.00487012987013006*G0_1_0_1_5_0 - 0.0204545454545462*G0_1_0_1_5_1 - 0.00243506493506501*G0_1_0_1_5_2 + 0.00389610389610401*G0_1_0_1_5_3 + 0.0107142857142861*G0_1_0_1_5_4 + 0.0194805194805201*G0_1_0_1_5_5 - 0.000231331168831178*G0_1_0_2_0_0 - 0.000121753246753253*G0_1_0_2_0_1 + 0.000572240259740282*G0_1_0_2_0_2 - 0.0016558441558442*G0_1_0_2_0_3 - 0.0022402597402598*G0_1_0_2_0_4 - 0.001948051948052*G0_1_0_2_0_5 - 0.000121753246753253*G0_1_0_2_1_0 + 0.00547889610389628*G0_1_0_2_1_1 - 0.000974025974026008*G0_1_0_2_1_3 - 0.00194805194805201*G0_1_0_2_1_4 - 0.00243506493506501*G0_1_0_2_1_5 + 0.000572240259740282*G0_1_0_2_2_0 - 0.00025568181818188*G0_1_0_2_2_2 - 0.000681818181818211*G0_1_0_2_2_3 - 0.00199675324675334*G0_1_0_2_2_4 - 0.00487012987013003*G0_1_0_2_2_5 - 0.0016558441558442*G0_1_0_2_3_0 - 0.000974025974026007*G0_1_0_2_3_1 - 0.000681818181818211*G0_1_0_2_3_2 + 0.00876623376623403*G0_1_0_2_3_3 + 0.00720779220779244*G0_1_0_2_3_4 + 0.0130519480519485*G0_1_0_2_3_5 - 0.0022402597402598*G0_1_0_2_4_0 - 0.00194805194805201*G0_1_0_2_4_1 - 0.00199675324675334*G0_1_0_2_4_2 + 0.00720779220779244*G0_1_0_2_4_3 + 0.00623376623376641*G0_1_0_2_4_4 + 0.0136363636363641*G0_1_0_2_4_5 - 0.001948051948052*G0_1_0_2_5_0 - 0.00243506493506501*G0_1_0_2_5_1 - 0.00487012987013003*G0_1_0_2_5_2 + 0.0130519480519485*G0_1_0_2_5_3 + 0.0136363636363641*G0_1_0_2_5_4 + 0.0372077922077935*G0_1_0_2_5_5 - 0.00165584415584421*G0_1_0_3_0_0 + 0.000487012987013005*G0_1_0_3_0_1 - 0.0016558441558442*G0_1_0_3_0_2 + 0.00097402597402601*G0_1_0_3_0_3 + 0.00428571428571442*G0_1_0_3_0_4 + 0.00720779220779242*G0_1_0_3_0_5 + 0.000487012987013005*G0_1_0_3_1_0 - 0.0204545454545461*G0_1_0_3_1_1 - 0.000974025974026007*G0_1_0_3_1_2 - 0.00389610389610399*G0_1_0_3_1_3 + 0.00487012987013003*G0_1_0_3_1_4 + 0.00389610389610401*G0_1_0_3_1_5 - 0.0016558441558442*G0_1_0_3_2_0 - 0.000974025974026007*G0_1_0_3_2_1 - 0.000681818181818212*G0_1_0_3_2_2 + 0.00876623376623403*G0_1_0_3_2_3 + 0.00720779220779244*G0_1_0_3_2_4 + 0.0130519480519485*G0_1_0_3_2_5 + 0.000974025974026011*G0_1_0_3_3_0 - 0.00389610389610399*G0_1_0_3_3_1 + 0.00876623376623403*G0_1_0_3_3_2 + 0.0981818181818216*G0_1_0_3_3_3 - 0.0116883116883121*G0_1_0_3_3_4 - 0.0280519480519489*G0_1_0_3_3_5 + 0.00428571428571442*G0_1_0_3_4_0 + 0.00487012987013003*G0_1_0_3_4_1 + 0.00720779220779244*G0_1_0_3_4_2 - 0.0116883116883121*G0_1_0_3_4_3 - 0.0202597402597409*G0_1_0_3_4_4 - 0.035844155844157*G0_1_0_3_4_5 + 0.00720779220779242*G0_1_0_3_5_0 + 0.00389610389610401*G0_1_0_3_5_1 + 0.0130519480519485*G0_1_0_3_5_2 - 0.0280519480519489*G0_1_0_3_5_3 - 0.035844155844157*G0_1_0_3_5_4 - 0.0888311688311719*G0_1_0_3_5_5 + 0.00267857142857152*G0_1_0_4_0_0 - 0.000487012987012999*G0_1_0_4_0_1 - 0.0022402597402598*G0_1_0_4_0_2 + 0.00428571428571442*G0_1_0_4_0_3 + 0.00857142857142885*G0_1_0_4_0_4 + 0.00487012987013*G0_1_0_4_0_5 - 0.000487012987012999*G0_1_0_4_1_0 - 0.00292207792207801*G0_1_0_4_1_1 - 0.00194805194805201*G0_1_0_4_1_2 + 0.00487012987013003*G0_1_0_4_1_3 + 0.00584415584415604*G0_1_0_4_1_4 + 0.0107142857142861*G0_1_0_4_1_5 - 0.0022402597402598*G0_1_0_4_2_0 - 0.00194805194805201*G0_1_0_4_2_1 - 0.00199675324675334*G0_1_0_4_2_2 + 0.00720779220779244*G0_1_0_4_2_3 + 0.00623376623376641*G0_1_0_4_2_4 + 0.0136363636363641*G0_1_0_4_2_5 + 0.00428571428571442*G0_1_0_4_3_0 + 0.00487012987013003*G0_1_0_4_3_1 + 0.00720779220779244*G0_1_0_4_3_2 - 0.0116883116883121*G0_1_0_4_3_3 - 0.0202597402597409*G0_1_0_4_3_4 - 0.035844155844157*G0_1_0_4_3_5 + 0.00857142857142885*G0_1_0_4_4_0 + 0.00584415584415604*G0_1_0_4_4_1 + 0.00623376623376641*G0_1_0_4_4_2 - 0.0202597402597409*G0_1_0_4_4_3 - 0.0389610389610403*G0_1_0_4_4_5 + 0.00487012987013*G0_1_0_4_5_0 + 0.0107142857142861*G0_1_0_4_5_1 + 0.0136363636363641*G0_1_0_4_5_2 - 0.035844155844157*G0_1_0_4_5_3 - 0.0389610389610402*G0_1_0_4_5_4 - 0.0958441558441591*G0_1_0_4_5_5 - 0.00681818181818207*G0_1_0_5_0_0 + 0.00487012987013006*G0_1_0_5_0_1 - 0.001948051948052*G0_1_0_5_0_2 + 0.00720779220779242*G0_1_0_5_0_3 + 0.00487012987013*G0_1_0_5_0_4 - 0.00175324675324698*G0_1_0_5_0_5 + 0.00487012987013006*G0_1_0_5_1_0 - 0.0204545454545462*G0_1_0_5_1_1 - 0.00243506493506501*G0_1_0_5_1_2 + 0.00389610389610401*G0_1_0_5_1_3 + 0.0107142857142861*G0_1_0_5_1_4 + 0.0194805194805201*G0_1_0_5_1_5 - 0.001948051948052*G0_1_0_5_2_0 - 0.00243506493506501*G0_1_0_5_2_1 - 0.00487012987013003*G0_1_0_5_2_2 + 0.0130519480519485*G0_1_0_5_2_3 + 0.0136363636363641*G0_1_0_5_2_4 + 0.0372077922077935*G0_1_0_5_2_5 + 0.00720779220779242*G0_1_0_5_3_0 + 0.00389610389610401*G0_1_0_5_3_1 + 0.0130519480519485*G0_1_0_5_3_2 - 0.0280519480519489*G0_1_0_5_3_3 - 0.035844155844157*G0_1_0_5_3_4 - 0.0888311688311718*G0_1_0_5_3_5 + 0.00487012987013*G0_1_0_5_4_0 + 0.0107142857142861*G0_1_0_5_4_1 + 0.0136363636363641*G0_1_0_5_4_2 - 0.035844155844157*G0_1_0_5_4_3 - 0.0389610389610403*G0_1_0_5_4_4 - 0.0958441558441591*G0_1_0_5_4_5 - 0.00175324675324698*G0_1_0_5_5_0 + 0.0194805194805201*G0_1_0_5_5_1 + 0.0372077922077935*G0_1_0_5_5_2 - 0.0888311688311718*G0_1_0_5_5_3 - 0.0958441558441591*G0_1_0_5_5_4 - 0.448831168831185*G0_1_0_5_5_5;
    A[21] = 0.00153409090909096*G0_1_0_0_0_0 + 0.000120851370851375*G0_1_0_0_0_1 + 0.000120851370851375*G0_1_0_0_0_2 + 9.92063492063519e-05*G0_1_0_0_0_3 + 0.000297619047619057*G0_1_0_0_0_4 + 0.000297619047619056*G0_1_0_0_0_5 + 0.000120851370851375*G0_1_0_0_1_0 - 0.00109397546897551*G0_1_0_0_1_1 + 7.35028860028885e-05*G0_1_0_0_1_2 - 9.74025974026005e-05*G0_1_0_0_1_3 + 0.000102813852813856*G0_1_0_0_1_4 - 0.000678210678210701*G0_1_0_0_1_5 + 0.000120851370851375*G0_1_0_0_2_0 + 7.35028860028885e-05*G0_1_0_0_2_1 - 0.00109397546897551*G0_1_0_0_2_2 - 9.74025974026016e-05*G0_1_0_0_2_3 - 0.000678210678210702*G0_1_0_0_2_4 + 0.000102813852813856*G0_1_0_0_2_5 + 9.92063492063519e-05*G0_1_0_0_3_0 - 9.74025974026004e-05*G0_1_0_0_3_1 - 9.74025974026016e-05*G0_1_0_0_3_2 - 2.88600288600292e-05*G0_1_0_0_3_3 - 0.000404040404040417*G0_1_0_0_3_4 - 0.000404040404040417*G0_1_0_0_3_5 + 0.000297619047619057*G0_1_0_0_4_0 + 0.000102813852813856*G0_1_0_0_4_1 - 0.000678210678210702*G0_1_0_0_4_2 - 0.000404040404040417*G0_1_0_0_4_3 - 0.00212121212121219*G0_1_0_0_4_4 - 0.000411255411255424*G0_1_0_0_4_5 + 0.000297619047619056*G0_1_0_0_5_0 - 0.0006782106782107*G0_1_0_0_5_1 + 0.000102813852813856*G0_1_0_0_5_2 - 0.000404040404040417*G0_1_0_0_5_3 - 0.000411255411255424*G0_1_0_0_5_4 - 0.00212121212121219*G0_1_0_0_5_5 + 0.000120851370851375*G0_1_0_1_0_0 - 0.00109397546897551*G0_1_0_1_0_1 + 7.35028860028885e-05*G0_1_0_1_0_2 - 9.74025974026005e-05*G0_1_0_1_0_3 + 0.000102813852813856*G0_1_0_1_0_4 - 0.000678210678210701*G0_1_0_1_0_5 - 0.00109397546897551*G0_1_0_1_1_0 + 0.0141233766233771*G0_1_0_1_1_1 - 0.00049873737373739*G0_1_0_1_1_2 + 0.00173160173160179*G0_1_0_1_1_3 + 0.000212842712842718*G0_1_0_1_1_4 + 0.00487012987013005*G0_1_0_1_1_5 + 7.35028860028885e-05*G0_1_0_1_2_0 - 0.00049873737373739*G0_1_0_1_2_1 - 0.000498737373737392*G0_1_0_1_2_2 + 0.000165945165945172*G0_1_0_1_2_3 - 0.00018398268398269*G0_1_0_1_2_4 - 0.00018398268398269*G0_1_0_1_2_5 - 9.74025974026004e-05*G0_1_0_1_3_0 + 0.00173160173160179*G0_1_0_1_3_1 + 0.000165945165945172*G0_1_0_1_3_2 - 0.000346320346320361*G0_1_0_1_3_3 - 0.000230880230880239*G0_1_0_1_3_4 + 0.000562770562770582*G0_1_0_1_3_5 + 0.000102813852813856*G0_1_0_1_4_0 + 0.000212842712842718*G0_1_0_1_4_1 - 0.00018398268398269*G0_1_0_1_4_2 - 0.000230880230880239*G0_1_0_1_4_3 - 0.000418470418470432*G0_1_0_1_4_4 - 5.77200577200606e-05*G0_1_0_1_4_5 - 0.0006782106782107*G0_1_0_1_5_0 + 0.00487012987013005*G0_1_0_1_5_1 - 0.00018398268398269*G0_1_0_1_5_2 + 0.000562770562770583*G0_1_0_1_5_3 - 5.77200577200606e-05*G0_1_0_1_5_4 + 0.00441558441558457*G0_1_0_1_5_5 + 0.000120851370851375*G0_1_0_2_0_0 + 7.35028860028885e-05*G0_1_0_2_0_1 - 0.00109397546897551*G0_1_0_2_0_2 - 9.74025974026016e-05*G0_1_0_2_0_3 - 0.000678210678210702*G0_1_0_2_0_4 + 0.000102813852813856*G0_1_0_2_0_5 + 7.35028860028885e-05*G0_1_0_2_1_0 - 0.00049873737373739*G0_1_0_2_1_1 - 0.000498737373737392*G0_1_0_2_1_2 + 0.000165945165945172*G0_1_0_2_1_3 - 0.00018398268398269*G0_1_0_2_1_4 - 0.00018398268398269*G0_1_0_2_1_5 - 0.00109397546897551*G0_1_0_2_2_0 - 0.000498737373737392*G0_1_0_2_2_1 + 0.0141233766233772*G0_1_0_2_2_2 + 0.0017316017316018*G0_1_0_2_2_3 + 0.00487012987013005*G0_1_0_2_2_4 + 0.000212842712842723*G0_1_0_2_2_5 - 9.74025974026017e-05*G0_1_0_2_3_0 + 0.000165945165945172*G0_1_0_2_3_1 + 0.0017316017316018*G0_1_0_2_3_2 - 0.000346320346320354*G0_1_0_2_3_3 + 0.000562770562770585*G0_1_0_2_3_4 - 0.000230880230880237*G0_1_0_2_3_5 - 0.000678210678210702*G0_1_0_2_4_0 - 0.00018398268398269*G0_1_0_2_4_1 + 0.00487012987013005*G0_1_0_2_4_2 + 0.000562770562770585*G0_1_0_2_4_3 + 0.00441558441558457*G0_1_0_2_4_4 - 5.77200577200582e-05*G0_1_0_2_4_5 + 0.000102813852813856*G0_1_0_2_5_0 - 0.00018398268398269*G0_1_0_2_5_1 + 0.000212842712842723*G0_1_0_2_5_2 - 0.000230880230880237*G0_1_0_2_5_3 - 5.77200577200583e-05*G0_1_0_2_5_4 - 0.000418470418470432*G0_1_0_2_5_5 + 9.92063492063519e-05*G0_1_0_3_0_0 - 9.74025974026004e-05*G0_1_0_3_0_1 - 9.74025974026016e-05*G0_1_0_3_0_2 - 2.88600288600292e-05*G0_1_0_3_0_3 - 0.000404040404040417*G0_1_0_3_0_4 - 0.000404040404040417*G0_1_0_3_0_5 - 9.74025974026004e-05*G0_1_0_3_1_0 + 0.00173160173160179*G0_1_0_3_1_1 + 0.000165945165945172*G0_1_0_3_1_2 - 0.000346320346320361*G0_1_0_3_1_3 - 0.000230880230880239*G0_1_0_3_1_4 + 0.000562770562770582*G0_1_0_3_1_5 - 9.74025974026017e-05*G0_1_0_3_2_0 + 0.000165945165945172*G0_1_0_3_2_1 + 0.0017316017316018*G0_1_0_3_2_2 - 0.000346320346320354*G0_1_0_3_2_3 + 0.000562770562770585*G0_1_0_3_2_4 - 0.000230880230880237*G0_1_0_3_2_5 - 2.88600288600292e-05*G0_1_0_3_3_0 - 0.000346320346320361*G0_1_0_3_3_1 - 0.000346320346320354*G0_1_0_3_3_2 - 0.00571428571428593*G0_1_0_3_3_3 + 0.000519480519480535*G0_1_0_3_3_4 + 0.000519480519480531*G0_1_0_3_3_5 - 0.000404040404040417*G0_1_0_3_4_0 - 0.000230880230880239*G0_1_0_3_4_1 + 0.000562770562770585*G0_1_0_3_4_2 + 0.000519480519480534*G0_1_0_3_4_3 + 0.0016450216450217*G0_1_0_3_4_4 + 0.000923520923520953*G0_1_0_3_4_5 - 0.000404040404040417*G0_1_0_3_5_0 + 0.000562770562770583*G0_1_0_3_5_1 - 0.000230880230880237*G0_1_0_3_5_2 + 0.000519480519480531*G0_1_0_3_5_3 + 0.000923520923520953*G0_1_0_3_5_4 + 0.0016450216450217*G0_1_0_3_5_5 + 0.000297619047619057*G0_1_0_4_0_0 + 0.000102813852813856*G0_1_0_4_0_1 - 0.000678210678210702*G0_1_0_4_0_2 - 0.000404040404040417*G0_1_0_4_0_3 - 0.00212121212121219*G0_1_0_4_0_4 - 0.000411255411255424*G0_1_0_4_0_5 + 0.000102813852813856*G0_1_0_4_1_0 + 0.000212842712842718*G0_1_0_4_1_1 - 0.00018398268398269*G0_1_0_4_1_2 - 0.000230880230880239*G0_1_0_4_1_3 - 0.000418470418470432*G0_1_0_4_1_4 - 5.77200577200606e-05*G0_1_0_4_1_5 - 0.000678210678210702*G0_1_0_4_2_0 - 0.00018398268398269*G0_1_0_4_2_1 + 0.00487012987013005*G0_1_0_4_2_2 + 0.000562770562770585*G0_1_0_4_2_3 + 0.00441558441558457*G0_1_0_4_2_4 - 5.77200577200582e-05*G0_1_0_4_2_5 - 0.000404040404040417*G0_1_0_4_3_0 - 0.000230880230880239*G0_1_0_4_3_1 + 0.000562770562770585*G0_1_0_4_3_2 + 0.000519480519480534*G0_1_0_4_3_3 + 0.0016450216450217*G0_1_0_4_3_4 + 0.000923520923520953*G0_1_0_4_3_5 - 0.00212121212121219*G0_1_0_4_4_0 - 0.000418470418470432*G0_1_0_4_4_1 + 0.00441558441558457*G0_1_0_4_4_2 + 0.0016450216450217*G0_1_0_4_4_3 + 0.00441558441558457*G0_1_0_4_4_4 + 0.000952380952380986*G0_1_0_4_4_5 - 0.000411255411255424*G0_1_0_4_5_0 - 5.77200577200606e-05*G0_1_0_4_5_1 - 5.77200577200582e-05*G0_1_0_4_5_2 + 0.000923520923520953*G0_1_0_4_5_3 + 0.000952380952380985*G0_1_0_4_5_4 + 0.000952380952380983*G0_1_0_4_5_5 + 0.000297619047619056*G0_1_0_5_0_0 - 0.000678210678210701*G0_1_0_5_0_1 + 0.000102813852813856*G0_1_0_5_0_2 - 0.000404040404040417*G0_1_0_5_0_3 - 0.000411255411255424*G0_1_0_5_0_4 - 0.00212121212121219*G0_1_0_5_0_5 - 0.0006782106782107*G0_1_0_5_1_0 + 0.00487012987013005*G0_1_0_5_1_1 - 0.00018398268398269*G0_1_0_5_1_2 + 0.000562770562770583*G0_1_0_5_1_3 - 5.77200577200606e-05*G0_1_0_5_1_4 + 0.00441558441558457*G0_1_0_5_1_5 + 0.000102813852813856*G0_1_0_5_2_0 - 0.00018398268398269*G0_1_0_5_2_1 + 0.000212842712842723*G0_1_0_5_2_2 - 0.000230880230880237*G0_1_0_5_2_3 - 5.77200577200583e-05*G0_1_0_5_2_4 - 0.000418470418470432*G0_1_0_5_2_5 - 0.000404040404040417*G0_1_0_5_3_0 + 0.000562770562770583*G0_1_0_5_3_1 - 0.000230880230880237*G0_1_0_5_3_2 + 0.000519480519480531*G0_1_0_5_3_3 + 0.000923520923520953*G0_1_0_5_3_4 + 0.0016450216450217*G0_1_0_5_3_5 - 0.000411255411255424*G0_1_0_5_4_0 - 5.77200577200606e-05*G0_1_0_5_4_1 - 5.77200577200582e-05*G0_1_0_5_4_2 + 0.000923520923520953*G0_1_0_5_4_3 + 0.000952380952380985*G0_1_0_5_4_4 + 0.000952380952380983*G0_1_0_5_4_5 - 0.00212121212121219*G0_1_0_5_5_0 + 0.00441558441558457*G0_1_0_5_5_1 - 0.000418470418470432*G0_1_0_5_5_2 + 0.0016450216450217*G0_1_0_5_5_3 + 0.000952380952380983*G0_1_0_5_5_4 + 0.00441558441558456*G0_1_0_5_5_5;
    A[1] = -A[21] - 0.0141233766233771*G0_0_0_0_0_0 + 0.000498737373737389*G0_0_0_0_0_1 + 0.00109397546897551*G0_0_0_0_0_2 - 0.000212842712842718*G0_0_0_0_0_3 - 0.00487012987013003*G0_0_0_0_0_4 - 0.00173160173160179*G0_0_0_0_0_5 + 0.000498737373737389*G0_0_0_0_1_0 + 0.000498737373737392*G0_0_0_0_1_1 + 0.000183982683982691*G0_0_0_0_1_3 + 0.00018398268398269*G0_0_0_0_1_4 - 0.00016594516594517*G0_0_0_0_1_5 + 0.00109397546897551*G0_0_0_0_2_0 - 0.000120851370851374*G0_0_0_0_2_2 - 0.000102813852813856*G0_0_0_0_2_3 + 0.000678210678210701*G0_0_0_0_2_4 - 0.000212842712842718*G0_0_0_0_3_0 + 0.000183982683982691*G0_0_0_0_3_1 - 0.000102813852813856*G0_0_0_0_3_2 + 0.000418470418470433*G0_0_0_0_3_3 + 0.000230880230880239*G0_0_0_0_3_5 - 0.00487012987013003*G0_0_0_0_4_0 + 0.00018398268398269*G0_0_0_0_4_1 + 0.000678210678210701*G0_0_0_0_4_2 - 0.00441558441558456*G0_0_0_0_4_4 - 0.000562770562770582*G0_0_0_0_4_5 - 0.00173160173160179*G0_0_0_0_5_0 - 0.00016594516594517*G0_0_0_0_5_1 + 0.000230880230880239*G0_0_0_0_5_3 - 0.000562770562770582*G0_0_0_0_5_4 + 0.000346320346320361*G0_0_0_0_5_5 + 0.000498737373737389*G0_0_0_1_0_0 + 0.000498737373737391*G0_0_0_1_0_1 + 0.000183982683982691*G0_0_0_1_0_3 + 0.00018398268398269*G0_0_0_1_0_4 - 0.00016594516594517*G0_0_0_1_0_5 + 0.000498737373737391*G0_0_0_1_1_0 - 0.0141233766233771*G0_0_0_1_1_1 + 0.00109397546897551*G0_0_0_1_1_2 - 0.00487012987013004*G0_0_0_1_1_3 - 0.000212842712842719*G0_0_0_1_1_4 - 0.00173160173160181*G0_0_0_1_1_5 + 0.00109397546897551*G0_0_0_1_2_1 - 0.000120851370851375*G0_0_0_1_2_2 + 0.000678210678210703*G0_0_0_1_2_3 - 0.000102813852813856*G0_0_0_1_2_4 + 0.000183982683982691*G0_0_0_1_3_0 - 0.00487012987013004*G0_0_0_1_3_1 + 0.000678210678210703*G0_0_0_1_3_2 - 0.00441558441558457*G0_0_0_1_3_3 - 0.000562770562770589*G0_0_0_1_3_5 + 0.00018398268398269*G0_0_0_1_4_0 - 0.000212842712842719*G0_0_0_1_4_1 - 0.000102813852813856*G0_0_0_1_4_2 + 0.000418470418470432*G0_0_0_1_4_4 + 0.000230880230880237*G0_0_0_1_4_5 - 0.00016594516594517*G0_0_0_1_5_0 - 0.00173160173160181*G0_0_0_1_5_1 - 0.000562770562770589*G0_0_0_1_5_3 + 0.000230880230880237*G0_0_0_1_5_4 + 0.000346320346320349*G0_0_0_1_5_5 + 0.00109397546897551*G0_0_0_2_0_0 - 0.000120851370851374*G0_0_0_2_0_2 - 0.000102813852813856*G0_0_0_2_0_3 + 0.000678210678210701*G0_0_0_2_0_4 + 0.00109397546897551*G0_0_0_2_1_1 - 0.000120851370851375*G0_0_0_2_1_2 + 0.000678210678210703*G0_0_0_2_1_3 - 0.000102813852813856*G0_0_0_2_1_4 - 0.000120851370851374*G0_0_0_2_2_0 - 0.000120851370851375*G0_0_0_2_2_1 - 0.00153409090909097*G0_0_0_2_2_2 - 0.00029761904761906*G0_0_0_2_2_3 - 0.000297619047619059*G0_0_0_2_2_4 - 0.000102813852813856*G0_0_0_2_3_0 + 0.000678210678210703*G0_0_0_2_3_1 - 0.00029761904761906*G0_0_0_2_3_2 + 0.00212121212121219*G0_0_0_2_3_3 + 0.000411255411255424*G0_0_0_2_3_4 + 0.000404040404040418*G0_0_0_2_3_5 + 0.000678210678210701*G0_0_0_2_4_0 - 0.000102813852813856*G0_0_0_2_4_1 - 0.000297619047619059*G0_0_0_2_4_2 + 0.000411255411255424*G0_0_0_2_4_3 + 0.00212121212121219*G0_0_0_2_4_4 + 0.000404040404040417*G0_0_0_2_4_5 + 0.000404040404040418*G0_0_0_2_5_3 + 0.000404040404040417*G0_0_0_2_5_4 - 0.000212842712842718*G0_0_0_3_0_0 + 0.000183982683982691*G0_0_0_3_0_1 - 0.000102813852813856*G0_0_0_3_0_2 + 0.000418470418470433*G0_0_0_3_0_3 + 0.000230880230880239*G0_0_0_3_0_5 + 0.000183982683982691*G0_0_0_3_1_0 - 0.00487012987013004*G0_0_0_3_1_1 + 0.000678210678210703*G0_0_0_3_1_2 - 0.00441558441558457*G0_0_0_3_1_3 - 0.000562770562770589*G0_0_0_3_1_5 - 0.000102813852813856*G0_0_0_3_2_0 + 0.000678210678210703*G0_0_0_3_2_1 - 0.00029761904761906*G0_0_0_3_2_2 + 0.00212121212121219*G0_0_0_3_2_3 + 0.000411255411255424*G0_0_0_3_2_4 + 0.000404040404040418*G0_0_0_3_2_5 + 0.000418470418470433*G0_0_0_3_3_0 - 0.00441558441558457*G0_0_0_3_3_1 + 0.00212121212121219*G0_0_0_3_3_2 - 0.00441558441558457*G0_0_0_3_3_3 - 0.000952380952380982*G0_0_0_3_3_4 - 0.0016450216450217*G0_0_0_3_3_5 + 0.000411255411255424*G0_0_0_3_4_2 - 0.000952380952380982*G0_0_0_3_4_3 - 0.000952380952380981*G0_0_0_3_4_4 - 0.000923520923520952*G0_0_0_3_4_5 + 0.000230880230880239*G0_0_0_3_5_0 - 0.000562770562770589*G0_0_0_3_5_1 + 0.000404040404040418*G0_0_0_3_5_2 - 0.0016450216450217*G0_0_0_3_5_3 - 0.000923520923520952*G0_0_0_3_5_4 - 0.000519480519480538*G0_0_0_3_5_5 - 0.00487012987013003*G0_0_0_4_0_0 + 0.00018398268398269*G0_0_0_4_0_1 + 0.000678210678210701*G0_0_0_4_0_2 - 0.00441558441558456*G0_0_0_4_0_4 - 0.000562770562770582*G0_0_0_4_0_5 + 0.00018398268398269*G0_0_0_4_1_0 - 0.000212842712842719*G0_0_0_4_1_1 - 0.000102813852813856*G0_0_0_4_1_2 + 0.000418470418470432*G0_0_0_4_1_4 + 0.000230880230880237*G0_0_0_4_1_5 + 0.000678210678210701*G0_0_0_4_2_0 - 0.000102813852813856*G0_0_0_4_2_1 - 0.000297619047619059*G0_0_0_4_2_2 + 0.000411255411255424*G0_0_0_4_2_3 + 0.00212121212121219*G0_0_0_4_2_4 + 0.000404040404040417*G0_0_0_4_2_5 + 0.000411255411255424*G0_0_0_4_3_2 - 0.000952380952380982*G0_0_0_4_3_3 - 0.000952380952380981*G0_0_0_4_3_4 - 0.000923520923520952*G0_0_0_4_3_5 - 0.00441558441558456*G0_0_0_4_4_0 + 0.000418470418470432*G0_0_0_4_4_1 + 0.00212121212121219*G0_0_0_4_4_2 - 0.00095238095238098*G0_0_0_4_4_3 - 0.00441558441558455*G0_0_0_4_4_4 - 0.0016450216450217*G0_0_0_4_4_5 - 0.000562770562770583*G0_0_0_4_5_0 + 0.000230880230880237*G0_0_0_4_5_1 + 0.000404040404040417*G0_0_0_4_5_2 - 0.000923520923520952*G0_0_0_4_5_3 - 0.0016450216450217*G0_0_0_4_5_4 - 0.000519480519480535*G0_0_0_4_5_5 - 0.00173160173160179*G0_0_0_5_0_0 - 0.00016594516594517*G0_0_0_5_0_1 + 0.000230880230880239*G0_0_0_5_0_3 - 0.000562770562770583*G0_0_0_5_0_4 + 0.000346320346320361*G0_0_0_5_0_5 - 0.00016594516594517*G0_0_0_5_1_0 - 0.00173160173160181*G0_0_0_5_1_1 - 0.000562770562770589*G0_0_0_5_1_3 + 0.000230880230880237*G0_0_0_5_1_4 + 0.000346320346320349*G0_0_0_5_1_5 + 0.000404040404040418*G0_0_0_5_2_3 + 0.000404040404040417*G0_0_0_5_2_4 + 0.000230880230880239*G0_0_0_5_3_0 - 0.000562770562770589*G0_0_0_5_3_1 + 0.000404040404040418*G0_0_0_5_3_2 - 0.0016450216450217*G0_0_0_5_3_3 - 0.000923520923520952*G0_0_0_5_3_4 - 0.000519480519480538*G0_0_0_5_3_5 - 0.000562770562770583*G0_0_0_5_4_0 + 0.000230880230880237*G0_0_0_5_4_1 + 0.000404040404040417*G0_0_0_5_4_2 - 0.000923520923520952*G0_0_0_5_4_3 - 0.0016450216450217*G0_0_0_5_4_4 - 0.000519480519480535*G0_0_0_5_4_5 + 0.000346320346320361*G0_0_0_5_5_0 + 0.000346320346320349*G0_0_0_5_5_1 - 0.000519480519480538*G0_0_0_5_5_3 - 0.000519480519480535*G0_0_0_5_5_4 + 0.00571428571428592*G0_0_0_5_5_5 - 0.0125892857142861*G0_1_0_0_0_0 + 0.000619588744588763*G0_1_0_0_0_1 + 0.00121482683982688*G0_1_0_0_0_2 - 0.000113636363636366*G0_1_0_0_0_3 - 0.00457251082251097*G0_1_0_0_0_4 - 0.00143398268398273*G0_1_0_0_0_5 + 0.000619588744588763*G0_1_0_0_1_0 - 0.000595238095238114*G0_1_0_0_1_1 + 0.000286796536796547*G0_1_0_0_1_4 - 0.000844155844155871*G0_1_0_0_1_5 + 0.00121482683982688*G0_1_0_0_2_0 - 0.00121482683982688*G0_1_0_0_2_2 - 0.000200216450216458*G0_1_0_0_2_3 + 0.000200216450216456*G0_1_0_0_2_5 - 0.000113636363636366*G0_1_0_0_3_0 - 0.000200216450216458*G0_1_0_0_3_2 + 0.000389610389610403*G0_1_0_0_3_3 - 0.000346320346320357*G0_1_0_0_3_4 - 0.000173160173160178*G0_1_0_0_3_5 - 0.00457251082251097*G0_1_0_0_4_0 + 0.000286796536796547*G0_1_0_0_4_1 - 0.000346320346320357*G0_1_0_0_4_3 - 0.00653679653679675*G0_1_0_0_4_4 - 0.000974025974026007*G0_1_0_0_4_5 - 0.00143398268398273*G0_1_0_0_5_0 - 0.000844155844155871*G0_1_0_0_5_1 + 0.000200216450216456*G0_1_0_0_5_2 - 0.000173160173160178*G0_1_0_0_5_3 - 0.000974025974026006*G0_1_0_0_5_4 - 0.00177489177489183*G0_1_0_0_5_5 + 0.000619588744588763*G0_1_0_1_0_0 - 0.000595238095238114*G0_1_0_1_0_1 + 0.000286796536796547*G0_1_0_1_0_4 - 0.000844155844155871*G0_1_0_1_0_5 - 0.000595238095238114*G0_1_0_1_1_0 + 0.000595238095238116*G0_1_0_1_1_2 - 0.00313852813852825*G0_1_0_1_1_3 + 0.00313852813852824*G0_1_0_1_1_5 + 0.000595238095238116*G0_1_0_1_2_1 - 0.000619588744588767*G0_1_0_1_2_2 + 0.000844155844155874*G0_1_0_1_2_3 - 0.000286796536796546*G0_1_0_1_2_4 - 0.00313852813852825*G0_1_0_1_3_1 + 0.000844155844155874*G0_1_0_1_3_2 - 0.00476190476190493*G0_1_0_1_3_3 - 0.00017316017316018*G0_1_0_1_3_4 + 0.000286796536796547*G0_1_0_1_4_0 - 0.000286796536796546*G0_1_0_1_4_2 - 0.00017316017316018*G0_1_0_1_4_3 + 0.000173160173160177*G0_1_0_1_4_5 - 0.000844155844155871*G0_1_0_1_5_0 + 0.00313852813852824*G0_1_0_1_5_1 + 0.000173160173160177*G0_1_0_1_5_4 + 0.00476190476190492*G0_1_0_1_5_5 + 0.00121482683982688*G0_1_0_2_0_0 - 0.00121482683982688*G0_1_0_2_0_2 - 0.000200216450216458*G0_1_0_2_0_3 + 0.000200216450216456*G0_1_0_2_0_5 + 0.000595238095238116*G0_1_0_2_1_1 - 0.000619588744588767*G0_1_0_2_1_2 + 0.000844155844155874*G0_1_0_2_1_3 - 0.000286796536796546*G0_1_0_2_1_4 - 0.00121482683982688*G0_1_0_2_2_0 - 0.000619588744588767*G0_1_0_2_2_1 + 0.0125892857142862*G0_1_0_2_2_2 + 0.00143398268398274*G0_1_0_2_2_3 + 0.00457251082251099*G0_1_0_2_2_4 + 0.00011363636363637*G0_1_0_2_2_5 - 0.000200216450216458*G0_1_0_2_3_0 + 0.000844155844155874*G0_1_0_2_3_1 + 0.00143398268398274*G0_1_0_2_3_2 + 0.00177489177489184*G0_1_0_2_3_3 + 0.000974025974026009*G0_1_0_2_3_4 + 0.000173160173160181*G0_1_0_2_3_5 - 0.000286796536796546*G0_1_0_2_4_1 + 0.00457251082251099*G0_1_0_2_4_2 + 0.000974025974026009*G0_1_0_2_4_3 + 0.00653679653679676*G0_1_0_2_4_4 + 0.000346320346320359*G0_1_0_2_4_5 + 0.000200216450216456*G0_1_0_2_5_0 + 0.00011363636363637*G0_1_0_2_5_2 + 0.000173160173160181*G0_1_0_2_5_3 + 0.000346320346320359*G0_1_0_2_5_4 - 0.000389610389610403*G0_1_0_2_5_5 - 0.000113636363636366*G0_1_0_3_0_0 - 0.000200216450216458*G0_1_0_3_0_2 + 0.000389610389610403*G0_1_0_3_0_3 - 0.000346320346320357*G0_1_0_3_0_4 - 0.000173160173160178*G0_1_0_3_0_5 - 0.00313852813852825*G0_1_0_3_1_1 + 0.000844155844155874*G0_1_0_3_1_2 - 0.00476190476190493*G0_1_0_3_1_3 - 0.00017316017316018*G0_1_0_3_1_4 - 0.000200216450216458*G0_1_0_3_2_0 + 0.000844155844155874*G0_1_0_3_2_1 + 0.00143398268398274*G0_1_0_3_2_2 + 0.00177489177489184*G0_1_0_3_2_3 + 0.000974025974026009*G0_1_0_3_2_4 + 0.000173160173160181*G0_1_0_3_2_5 + 0.000389610389610403*G0_1_0_3_3_0 - 0.00476190476190493*G0_1_0_3_3_1 + 0.00177489177489184*G0_1_0_3_3_2 - 0.0101298701298705*G0_1_0_3_3_3 - 0.000432900432900447*G0_1_0_3_3_4 - 0.00112554112554117*G0_1_0_3_3_5 - 0.000346320346320357*G0_1_0_3_4_0 - 0.00017316017316018*G0_1_0_3_4_1 + 0.000974025974026009*G0_1_0_3_4_2 - 0.000432900432900447*G0_1_0_3_4_3 + 0.000692640692640719*G0_1_0_3_4_4 - 0.000173160173160178*G0_1_0_3_5_0 + 0.000173160173160181*G0_1_0_3_5_2 - 0.00112554112554117*G0_1_0_3_5_3 + 0.00112554112554116*G0_1_0_3_5_5 - 0.00457251082251097*G0_1_0_4_0_0 + 0.000286796536796547*G0_1_0_4_0_1 - 0.000346320346320357*G0_1_0_4_0_3 - 0.00653679653679675*G0_1_0_4_0_4 - 0.000974025974026007*G0_1_0_4_0_5 + 0.000286796536796547*G0_1_0_4_1_0 - 0.000286796536796546*G0_1_0_4_1_2 - 0.00017316017316018*G0_1_0_4_1_3 + 0.000173160173160177*G0_1_0_4_1_5 - 0.000286796536796546*G0_1_0_4_2_1 + 0.00457251082251099*G0_1_0_4_2_2 + 0.000974025974026009*G0_1_0_4_2_3 + 0.00653679653679676*G0_1_0_4_2_4 + 0.000346320346320359*G0_1_0_4_2_5 - 0.000346320346320357*G0_1_0_4_3_0 - 0.00017316017316018*G0_1_0_4_3_1 + 0.000974025974026009*G0_1_0_4_3_2 - 0.000432900432900447*G0_1_0_4_3_3 + 0.000692640692640719*G0_1_0_4_3_4 - 0.00653679653679675*G0_1_0_4_4_0 + 0.00653679653679676*G0_1_0_4_4_2 + 0.000692640692640719*G0_1_0_4_4_3 - 0.000692640692640712*G0_1_0_4_4_5 - 0.000974025974026007*G0_1_0_4_5_0 + 0.000173160173160177*G0_1_0_4_5_1 + 0.000346320346320359*G0_1_0_4_5_2 - 0.000692640692640712*G0_1_0_4_5_4 + 0.000432900432900448*G0_1_0_4_5_5 - 0.00143398268398273*G0_1_0_5_0_0 - 0.000844155844155871*G0_1_0_5_0_1 + 0.000200216450216456*G0_1_0_5_0_2 - 0.000173160173160178*G0_1_0_5_0_3 - 0.000974025974026007*G0_1_0_5_0_4 - 0.00177489177489183*G0_1_0_5_0_5 - 0.000844155844155871*G0_1_0_5_1_0 + 0.00313852813852824*G0_1_0_5_1_1 + 0.000173160173160177*G0_1_0_5_1_4 + 0.00476190476190492*G0_1_0_5_1_5 + 0.000200216450216456*G0_1_0_5_2_0 + 0.00011363636363637*G0_1_0_5_2_2 + 0.000173160173160181*G0_1_0_5_2_3 + 0.000346320346320359*G0_1_0_5_2_4 - 0.000389610389610403*G0_1_0_5_2_5 - 0.000173160173160178*G0_1_0_5_3_0 + 0.000173160173160181*G0_1_0_5_3_2 - 0.00112554112554117*G0_1_0_5_3_3 + 0.00112554112554116*G0_1_0_5_3_5 - 0.000974025974026007*G0_1_0_5_4_0 + 0.000173160173160177*G0_1_0_5_4_1 + 0.000346320346320359*G0_1_0_5_4_2 - 0.000692640692640712*G0_1_0_5_4_4 + 0.000432900432900448*G0_1_0_5_4_5 - 0.00177489177489183*G0_1_0_5_5_0 + 0.00476190476190492*G0_1_0_5_5_1 - 0.000389610389610403*G0_1_0_5_5_2 + 0.00112554112554116*G0_1_0_5_5_3 + 0.000432900432900448*G0_1_0_5_5_4 + 0.0101298701298705*G0_1_0_5_5_5;
    A[15] = -A[16] - 0.00429383116883131*G0_0_0_0_0_0 + 0.000262445887445896*G0_0_0_0_0_1 + 0.000324675324675336*G0_0_0_0_0_2 + 0.000167748917748923*G0_0_0_0_0_3 - 0.00461580086580102*G0_0_0_0_0_4 - 0.000416666666666682*G0_0_0_0_0_5 + 0.000262445887445896*G0_0_0_0_1_0 - 0.000679112554112577*G0_0_0_0_1_1 - 0.000183982683982692*G0_0_0_0_1_3 + 0.000286796536796547*G0_0_0_0_1_4 - 0.000194805194805203*G0_0_0_0_1_5 + 0.000324675324675336*G0_0_0_0_2_0 + 0.00153950216450222*G0_0_0_0_2_2 + 0.00063852813852816*G0_0_0_0_2_3 + 0.00360389610389623*G0_0_0_0_2_4 + 0.000438311688311703*G0_0_0_0_2_5 + 0.000167748917748923*G0_0_0_0_3_0 - 0.000183982683982691*G0_0_0_0_3_1 + 0.00063852813852816*G0_0_0_0_3_2 - 0.00225108225108232*G0_0_0_0_3_3 - 0.000909090909090936*G0_0_0_0_3_4 - 0.00121212121212125*G0_0_0_0_3_5 - 0.00461580086580102*G0_0_0_0_4_0 + 0.000286796536796547*G0_0_0_0_4_1 + 0.00360389610389623*G0_0_0_0_4_2 - 0.000909090909090936*G0_0_0_0_4_3 - 0.0029870129870131*G0_0_0_0_4_4 - 0.0014502164502165*G0_0_0_0_4_5 - 0.000416666666666681*G0_0_0_0_5_0 - 0.000194805194805203*G0_0_0_0_5_1 + 0.000438311688311703*G0_0_0_0_5_2 - 0.00121212121212125*G0_0_0_0_5_3 - 0.0014502164502165*G0_0_0_0_5_4 - 0.00073593073593076*G0_0_0_0_5_5 + 0.000262445887445896*G0_0_0_1_0_0 - 0.000679112554112577*G0_0_0_1_0_1 - 0.000183982683982692*G0_0_0_1_0_3 + 0.000286796536796547*G0_0_0_1_0_4 - 0.000194805194805203*G0_0_0_1_0_5 - 0.000679112554112577*G0_0_0_1_1_0 + 0.00868506493506521*G0_0_0_1_1_1 - 0.00127435064935069*G0_0_0_1_1_2 + 0.00595238095238116*G0_0_0_1_1_3 + 0.000573593073593093*G0_0_0_1_1_4 + 0.00281385281385292*G0_0_0_1_1_5 - 0.00127435064935069*G0_0_0_1_2_1 + 0.000882034632034664*G0_0_0_1_2_2 - 0.00103896103896108*G0_0_0_1_2_3 + 0.000573593073593093*G0_0_0_1_2_4 - 0.000183982683982691*G0_0_0_1_3_0 + 0.00595238095238116*G0_0_0_1_3_1 - 0.00103896103896108*G0_0_0_1_3_2 + 0.00441558441558457*G0_0_0_1_3_3 - 0.000779220779220803*G0_0_0_1_3_4 + 0.000562770562770591*G0_0_0_1_3_5 + 0.000286796536796547*G0_0_0_1_4_0 + 0.000573593073593093*G0_0_0_1_4_1 + 0.000573593073593093*G0_0_0_1_4_2 - 0.000779220779220803*G0_0_0_1_4_3 + 0.00190476190476196*G0_0_0_1_4_4 - 0.000952380952380983*G0_0_0_1_4_5 - 0.000194805194805203*G0_0_0_1_5_0 + 0.00281385281385292*G0_0_0_1_5_1 + 0.000562770562770591*G0_0_0_1_5_3 - 0.000952380952380983*G0_0_0_1_5_4 - 0.000346320346320349*G0_0_0_1_5_5 + 0.000324675324675336*G0_0_0_2_0_0 + 0.00153950216450222*G0_0_0_2_0_2 + 0.00063852813852816*G0_0_0_2_0_3 + 0.00360389610389623*G0_0_0_2_0_4 + 0.000438311688311703*G0_0_0_2_0_5 - 0.00127435064935069*G0_0_0_2_1_1 + 0.000882034632034664*G0_0_0_2_1_2 - 0.00103896103896108*G0_0_0_2_1_3 + 0.000573593073593093*G0_0_0_2_1_4 + 0.00153950216450222*G0_0_0_2_2_0 + 0.000882034632034664*G0_0_0_2_2_1 - 0.0168831168831175*G0_0_0_2_2_2 - 0.00185064935064942*G0_0_0_2_2_3 - 0.00918831168831202*G0_0_0_2_2_4 + 0.00063852813852816*G0_0_0_2_3_0 - 0.00103896103896108*G0_0_0_2_3_1 - 0.00185064935064942*G0_0_0_2_3_2 - 0.0025108225108226*G0_0_0_2_3_3 - 0.00242424242424251*G0_0_0_2_3_4 - 0.00138528138528143*G0_0_0_2_3_5 + 0.00360389610389623*G0_0_0_2_4_0 + 0.000573593073593093*G0_0_0_2_4_1 - 0.00918831168831202*G0_0_0_2_4_2 - 0.00242424242424251*G0_0_0_2_4_3 - 0.00952380952380985*G0_0_0_2_4_4 - 0.0012554112554113*G0_0_0_2_4_5 + 0.000438311688311703*G0_0_0_2_5_0 - 0.00138528138528143*G0_0_0_2_5_3 - 0.0012554112554113*G0_0_0_2_5_4 - 0.00186147186147192*G0_0_0_2_5_5 + 0.000167748917748923*G0_0_0_3_0_0 - 0.000183982683982691*G0_0_0_3_0_1 + 0.00063852813852816*G0_0_0_3_0_2 - 0.00225108225108232*G0_0_0_3_0_3 - 0.000909090909090936*G0_0_0_3_0_4 - 0.00121212121212125*G0_0_0_3_0_5 - 0.000183982683982692*G0_0_0_3_1_0 + 0.00595238095238116*G0_0_0_3_1_1 - 0.00103896103896108*G0_0_0_3_1_2 + 0.00441558441558458*G0_0_0_3_1_3 - 0.000779220779220803*G0_0_0_3_1_4 + 0.000562770562770591*G0_0_0_3_1_5 + 0.00063852813852816*G0_0_0_3_2_0 - 0.00103896103896108*G0_0_0_3_2_1 - 0.00185064935064942*G0_0_0_3_2_2 - 0.0025108225108226*G0_0_0_3_2_3 - 0.00242424242424251*G0_0_0_3_2_4 - 0.00138528138528143*G0_0_0_3_2_5 - 0.00225108225108232*G0_0_0_3_3_0 + 0.00441558441558458*G0_0_0_3_3_1 - 0.0025108225108226*G0_0_0_3_3_2 + 0.021298701298702*G0_0_0_3_3_3 + 0.00606060606060626*G0_0_0_3_3_4 + 0.00727272727272752*G0_0_0_3_3_5 - 0.000909090909090936*G0_0_0_3_4_0 - 0.000779220779220803*G0_0_0_3_4_1 - 0.00242424242424251*G0_0_0_3_4_2 + 0.00606060606060626*G0_0_0_3_4_3 - 0.00199134199134205*G0_0_0_3_4_4 + 0.00432900432900447*G0_0_0_3_4_5 - 0.00121212121212125*G0_0_0_3_5_0 + 0.000562770562770591*G0_0_0_3_5_1 - 0.00138528138528143*G0_0_0_3_5_2 + 0.00727272727272752*G0_0_0_3_5_3 + 0.00432900432900447*G0_0_0_3_5_4 + 0.00614718614718636*G0_0_0_3_5_5 - 0.00461580086580102*G0_0_0_4_0_0 + 0.000286796536796547*G0_0_0_4_0_1 + 0.00360389610389623*G0_0_0_4_0_2 - 0.000909090909090936*G0_0_0_4_0_3 - 0.00298701298701309*G0_0_0_4_0_4 - 0.0014502164502165*G0_0_0_4_0_5 + 0.000286796536796547*G0_0_0_4_1_0 + 0.000573593073593093*G0_0_0_4_1_1 + 0.000573593073593093*G0_0_0_4_1_2 - 0.000779220779220803*G0_0_0_4_1_3 + 0.00190476190476196*G0_0_0_4_1_4 - 0.000952380952380983*G0_0_0_4_1_5 + 0.00360389610389623*G0_0_0_4_2_0 + 0.000573593073593093*G0_0_0_4_2_1 - 0.00918831168831202*G0_0_0_4_2_2 - 0.00242424242424251*G0_0_0_4_2_3 - 0.00952380952380986*G0_0_0_4_2_4 - 0.0012554112554113*G0_0_0_4_2_5 - 0.000909090909090936*G0_0_0_4_3_0 - 0.000779220779220803*G0_0_0_4_3_1 - 0.00242424242424251*G0_0_0_4_3_2 + 0.00606060606060626*G0_0_0_4_3_3 - 0.00199134199134205*G0_0_0_4_3_4 + 0.00432900432900447*G0_0_0_4_3_5 - 0.00298701298701309*G0_0_0_4_4_0 + 0.00190476190476196*G0_0_0_4_4_1 - 0.00952380952380986*G0_0_0_4_4_2 - 0.00199134199134205*G0_0_0_4_4_3 - 0.0932467532467563*G0_0_0_4_4_4 - 0.00129870129870134*G0_0_0_4_4_5 - 0.0014502164502165*G0_0_0_4_5_0 - 0.000952380952380983*G0_0_0_4_5_1 - 0.0012554112554113*G0_0_0_4_5_2 + 0.00432900432900447*G0_0_0_4_5_3 - 0.00129870129870134*G0_0_0_4_5_4 + 0.00562770562770581*G0_0_0_4_5_5 - 0.000416666666666681*G0_0_0_5_0_0 - 0.000194805194805203*G0_0_0_5_0_1 + 0.000438311688311703*G0_0_0_5_0_2 - 0.00121212121212125*G0_0_0_5_0_3 - 0.0014502164502165*G0_0_0_5_0_4 - 0.00073593073593076*G0_0_0_5_0_5 - 0.000194805194805203*G0_0_0_5_1_0 + 0.00281385281385292*G0_0_0_5_1_1 + 0.000562770562770591*G0_0_0_5_1_3 - 0.000952380952380983*G0_0_0_5_1_4 - 0.000346320346320349*G0_0_0_5_1_5 + 0.000438311688311703*G0_0_0_5_2_0 - 0.00138528138528143*G0_0_0_5_2_3 - 0.0012554112554113*G0_0_0_5_2_4 - 0.00186147186147192*G0_0_0_5_2_5 - 0.00121212121212125*G0_0_0_5_3_0 + 0.000562770562770591*G0_0_0_5_3_1 - 0.00138528138528143*G0_0_0_5_3_2 + 0.00727272727272752*G0_0_0_5_3_3 + 0.00432900432900447*G0_0_0_5_3_4 + 0.00614718614718636*G0_0_0_5_3_5 - 0.0014502164502165*G0_0_0_5_4_0 - 0.000952380952380983*G0_0_0_5_4_1 - 0.0012554112554113*G0_0_0_5_4_2 + 0.00432900432900447*G0_0_0_5_4_3 - 0.00129870129870134*G0_0_0_5_4_4 + 0.00562770562770581*G0_0_0_5_4_5 - 0.00073593073593076*G0_0_0_5_5_0 - 0.000346320346320349*G0_0_0_5_5_1 - 0.00186147186147192*G0_0_0_5_5_2 + 0.00614718614718636*G0_0_0_5_5_3 + 0.00562770562770581*G0_0_0_5_5_4 + 0.0111688311688316*G0_0_0_5_5_5 + 0.0125892857142861*G0_0_1_0_0_0 - 0.000619588744588764*G0_0_1_0_0_1 - 0.00121482683982688*G0_0_1_0_0_2 + 0.000113636363636366*G0_0_1_0_0_3 + 0.00457251082251097*G0_0_1_0_0_4 + 0.00143398268398273*G0_0_1_0_0_5 - 0.000619588744588764*G0_0_1_0_1_0 + 0.000595238095238116*G0_0_1_0_1_1 - 0.000286796536796547*G0_0_1_0_1_4 + 0.000844155844155871*G0_0_1_0_1_5 - 0.00121482683982688*G0_0_1_0_2_0 + 0.00121482683982688*G0_0_1_0_2_2 + 0.000200216450216458*G0_0_1_0_2_3 - 0.000200216450216457*G0_0_1_0_2_5 + 0.000113636363636366*G0_0_1_0_3_0 + 0.000200216450216458*G0_0_1_0_3_2 - 0.000389610389610402*G0_0_1_0_3_3 + 0.000346320346320358*G0_0_1_0_3_4 + 0.000173160173160179*G0_0_1_0_3_5 + 0.00457251082251097*G0_0_1_0_4_0 - 0.000286796536796547*G0_0_1_0_4_1 + 0.000346320346320358*G0_0_1_0_4_3 + 0.00653679653679675*G0_0_1_0_4_4 + 0.000974025974026007*G0_0_1_0_4_5 + 0.00143398268398273*G0_0_1_0_5_0 + 0.000844155844155871*G0_0_1_0_5_1 - 0.000200216450216457*G0_0_1_0_5_2 + 0.000173160173160179*G0_0_1_0_5_3 + 0.000974025974026008*G0_0_1_0_5_4 + 0.00177489177489183*G0_0_1_0_5_5 - 0.000619588744588764*G0_0_1_1_0_0 + 0.000595238095238116*G0_0_1_1_0_1 - 0.000286796536796547*G0_0_1_1_0_4 + 0.000844155844155871*G0_0_1_1_0_5 + 0.000595238095238116*G0_0_1_1_1_0 - 0.000595238095238115*G0_0_1_1_1_2 + 0.00313852813852824*G0_0_1_1_1_3 - 0.00313852813852825*G0_0_1_1_1_5 - 0.000595238095238115*G0_0_1_1_2_1 + 0.000619588744588767*G0_0_1_1_2_2 - 0.000844155844155874*G0_0_1_1_2_3 + 0.000286796536796546*G0_0_1_1_2_4 + 0.00313852813852824*G0_0_1_1_3_1 - 0.000844155844155874*G0_0_1_1_3_2 + 0.00476190476190493*G0_0_1_1_3_3 + 0.000173160173160181*G0_0_1_1_3_4 - 0.000286796536796547*G0_0_1_1_4_0 + 0.000286796536796546*G0_0_1_1_4_2 + 0.000173160173160181*G0_0_1_1_4_3 - 0.000173160173160177*G0_0_1_1_4_5 + 0.000844155844155871*G0_0_1_1_5_0 - 0.00313852813852825*G0_0_1_1_5_1 - 0.000173160173160177*G0_0_1_1_5_4 - 0.00476190476190492*G0_0_1_1_5_5 - 0.00121482683982688*G0_0_1_2_0_0 + 0.00121482683982688*G0_0_1_2_0_2 + 0.000200216450216458*G0_0_1_2_0_3 - 0.000200216450216457*G0_0_1_2_0_5 - 0.000595238095238115*G0_0_1_2_1_1 + 0.000619588744588767*G0_0_1_2_1_2 - 0.000844155844155873*G0_0_1_2_1_3 + 0.000286796536796547*G0_0_1_2_1_4 + 0.00121482683982688*G0_0_1_2_2_0 + 0.000619588744588767*G0_0_1_2_2_1 - 0.0125892857142862*G0_0_1_2_2_2 - 0.00143398268398274*G0_0_1_2_2_3 - 0.00457251082251099*G0_0_1_2_2_4 - 0.00011363636363637*G0_0_1_2_2_5 + 0.000200216450216458*G0_0_1_2_3_0 - 0.000844155844155873*G0_0_1_2_3_1 - 0.00143398268398274*G0_0_1_2_3_2 - 0.00177489177489184*G0_0_1_2_3_3 - 0.00097402597402601*G0_0_1_2_3_4 - 0.00017316017316018*G0_0_1_2_3_5 + 0.000286796536796547*G0_0_1_2_4_1 - 0.00457251082251099*G0_0_1_2_4_2 - 0.000974025974026009*G0_0_1_2_4_3 - 0.00653679653679676*G0_0_1_2_4_4 - 0.000346320346320359*G0_0_1_2_4_5 - 0.000200216450216457*G0_0_1_2_5_0 - 0.00011363636363637*G0_0_1_2_5_2 - 0.00017316017316018*G0_0_1_2_5_3 - 0.000346320346320359*G0_0_1_2_5_4 + 0.000389610389610404*G0_0_1_2_5_5 + 0.000113636363636365*G0_0_1_3_0_0 + 0.000200216450216458*G0_0_1_3_0_2 - 0.000389610389610402*G0_0_1_3_0_3 + 0.000346320346320358*G0_0_1_3_0_4 + 0.000173160173160179*G0_0_1_3_0_5 + 0.00313852813852824*G0_0_1_3_1_1 - 0.000844155844155873*G0_0_1_3_1_2 + 0.00476190476190493*G0_0_1_3_1_3 + 0.000173160173160181*G0_0_1_3_1_4 + 0.000200216450216458*G0_0_1_3_2_0 - 0.000844155844155873*G0_0_1_3_2_1 - 0.00143398268398274*G0_0_1_3_2_2 - 0.00177489177489184*G0_0_1_3_2_3 - 0.000974025974026009*G0_0_1_3_2_4 - 0.00017316017316018*G0_0_1_3_2_5 - 0.000389610389610402*G0_0_1_3_3_0 + 0.00476190476190493*G0_0_1_3_3_1 - 0.00177489177489184*G0_0_1_3_3_2 + 0.0101298701298705*G0_0_1_3_3_3 + 0.000432900432900445*G0_0_1_3_3_4 + 0.00112554112554117*G0_0_1_3_3_5 + 0.000346320346320358*G0_0_1_3_4_0 + 0.000173160173160181*G0_0_1_3_4_1 - 0.000974025974026009*G0_0_1_3_4_2 + 0.000432900432900443*G0_0_1_3_4_3 - 0.000692640692640723*G0_0_1_3_4_4 + 0.000173160173160179*G0_0_1_3_5_0 - 0.00017316017316018*G0_0_1_3_5_2 + 0.00112554112554117*G0_0_1_3_5_3 - 0.00112554112554116*G0_0_1_3_5_5 + 0.00457251082251097*G0_0_1_4_0_0 - 0.000286796536796547*G0_0_1_4_0_1 + 0.000346320346320358*G0_0_1_4_0_3 + 0.00653679653679675*G0_0_1_4_0_4 + 0.000974025974026008*G0_0_1_4_0_5 - 0.000286796536796547*G0_0_1_4_1_0 + 0.000286796536796547*G0_0_1_4_1_2 + 0.000173160173160181*G0_0_1_4_1_3 - 0.000173160173160177*G0_0_1_4_1_5 + 0.000286796536796547*G0_0_1_4_2_1 - 0.00457251082251099*G0_0_1_4_2_2 - 0.000974025974026009*G0_0_1_4_2_3 - 0.00653679653679676*G0_0_1_4_2_4 - 0.000346320346320359*G0_0_1_4_2_5 + 0.000346320346320358*G0_0_1_4_3_0 + 0.000173160173160181*G0_0_1_4_3_1 - 0.000974025974026009*G0_0_1_4_3_2 + 0.000432900432900443*G0_0_1_4_3_3 - 0.000692640692640723*G0_0_1_4_3_4 + 0.00653679653679675*G0_0_1_4_4_0 - 0.00653679653679676*G0_0_1_4_4_2 - 0.000692640692640723*G0_0_1_4_4_3 + 0.000692640692640709*G0_0_1_4_4_5 + 0.000974025974026008*G0_0_1_4_5_0 - 0.000173160173160177*G0_0_1_4_5_1 - 0.000346320346320359*G0_0_1_4_5_2 + 0.00069264069264071*G0_0_1_4_5_4 - 0.00043290043290045*G0_0_1_4_5_5 + 0.00143398268398273*G0_0_1_5_0_0 + 0.000844155844155871*G0_0_1_5_0_1 - 0.000200216450216457*G0_0_1_5_0_2 + 0.000173160173160179*G0_0_1_5_0_3 + 0.000974025974026008*G0_0_1_5_0_4 + 0.00177489177489183*G0_0_1_5_0_5 + 0.000844155844155871*G0_0_1_5_1_0 - 0.00313852813852825*G0_0_1_5_1_1 - 0.000173160173160177*G0_0_1_5_1_4 - 0.00476190476190492*G0_0_1_5_1_5 - 0.000200216450216457*G0_0_1_5_2_0 - 0.00011363636363637*G0_0_1_5_2_2 - 0.00017316017316018*G0_0_1_5_2_3 - 0.000346320346320359*G0_0_1_5_2_4 + 0.000389610389610404*G0_0_1_5_2_5 + 0.000173160173160179*G0_0_1_5_3_0 - 0.00017316017316018*G0_0_1_5_3_2 + 0.00112554112554117*G0_0_1_5_3_3 - 0.00112554112554116*G0_0_1_5_3_5 + 0.000974025974026008*G0_0_1_5_4_0 - 0.000173160173160177*G0_0_1_5_4_1 - 0.000346320346320359*G0_0_1_5_4_2 + 0.00069264069264071*G0_0_1_5_4_4 - 0.00043290043290045*G0_0_1_5_4_5 + 0.00177489177489183*G0_0_1_5_5_0 - 0.00476190476190492*G0_0_1_5_5_1 + 0.000389610389610404*G0_0_1_5_5_2 - 0.00112554112554116*G0_0_1_5_5_3 - 0.00043290043290045*G0_0_1_5_5_4 - 0.0101298701298705*G0_0_1_5_5_5;
    A[51] = A[15] - 0.020150162337663*G0_0_1_0_0_0 + 0.000735930735930758*G0_0_1_0_0_1 + 0.00127299783549788*G0_0_1_0_0_2 - 0.000243506493506498*G0_0_1_0_0_3 - 0.00492424242424259*G0_0_1_0_0_4 - 0.00213744588744596*G0_0_1_0_0_5 + 0.000735930735930758*G0_0_1_0_1_0 - 0.000248917748917759*G0_0_1_0_1_1 - 0.00018398268398269*G0_0_1_0_1_3 - 0.000844155844155873*G0_0_1_0_1_5 + 0.00127299783549788*G0_0_1_0_2_0 - 0.000238095238095244*G0_0_1_0_2_3 - 0.000162337662337665*G0_0_1_0_2_4 - 0.000243506493506498*G0_0_1_0_3_0 - 0.00018398268398269*G0_0_1_0_3_1 - 0.000238095238095245*G0_0_1_0_3_2 + 0.000519480519480535*G0_0_1_0_3_3 + 0.000476190476190491*G0_0_1_0_3_4 + 0.00056277056277058*G0_0_1_0_3_5 - 0.00492424242424259*G0_0_1_0_4_0 - 0.000162337662337665*G0_0_1_0_4_2 + 0.000476190476190491*G0_0_1_0_4_3 - 0.00313852813852824*G0_0_1_0_4_4 - 0.00213744588744596*G0_0_1_0_5_0 - 0.000844155844155873*G0_0_1_0_5_1 + 0.00056277056277058*G0_0_1_0_5_3 + 0.00203463203463211*G0_0_1_0_5_5 + 0.000735930735930758*G0_0_1_1_0_0 - 0.000248917748917759*G0_0_1_1_0_1 - 0.00018398268398269*G0_0_1_1_0_3 - 0.000844155844155873*G0_0_1_1_0_5 - 0.000248917748917759*G0_0_1_1_1_0 + 0.000346320346320357*G0_0_1_1_1_2 - 0.00156926406926412*G0_0_1_1_1_3 + 0.00156926406926413*G0_0_1_1_1_5 + 0.000346320346320357*G0_0_1_1_2_1 + 0.000116341991341997*G0_0_1_1_2_2 - 0.00028138528138529*G0_0_1_1_2_4 - 0.000270562770562779*G0_0_1_1_2_5 - 0.00018398268398269*G0_0_1_1_3_0 - 0.00156926406926412*G0_0_1_1_3_1 - 0.0032900432900434*G0_0_1_1_3_3 + 0.000562770562770581*G0_0_1_1_3_4 + 0.000909090909090937*G0_0_1_1_3_5 - 0.00028138528138529*G0_0_1_1_4_2 + 0.000562770562770581*G0_0_1_1_4_3 - 0.000389610389610397*G0_0_1_1_4_4 + 0.00073593073593076*G0_0_1_1_4_5 - 0.000844155844155873*G0_0_1_1_5_0 + 0.00156926406926413*G0_0_1_1_5_1 - 0.000270562770562779*G0_0_1_1_5_2 + 0.000909090909090937*G0_0_1_1_5_3 + 0.00073593073593076*G0_0_1_1_5_4 + 0.00147186147186152*G0_0_1_1_5_5 + 0.00127299783549788*G0_0_1_2_0_0 - 0.000238095238095244*G0_0_1_2_0_3 - 0.000162337662337665*G0_0_1_2_0_4 + 0.000346320346320357*G0_0_1_2_1_1 + 0.000116341991341997*G0_0_1_2_1_2 - 0.00028138528138529*G0_0_1_2_1_4 - 0.000270562770562779*G0_0_1_2_1_5 + 0.000116341991341997*G0_0_1_2_2_1 - 0.00756087662337692*G0_0_1_2_2_2 - 0.000703463203463238*G0_0_1_2_2_3 - 0.000351731601731626*G0_0_1_2_2_4 - 0.000129870129870136*G0_0_1_2_2_5 - 0.000238095238095245*G0_0_1_2_3_0 - 0.000703463203463238*G0_0_1_2_3_2 + 0.00380952380952393*G0_0_1_2_3_3 + 0.00103896103896107*G0_0_1_2_3_4 + 0.00073593073593076*G0_0_1_2_3_5 - 0.000162337662337665*G0_0_1_2_4_0 - 0.00028138528138529*G0_0_1_2_4_1 - 0.000351731601731626*G0_0_1_2_4_2 + 0.00103896103896107*G0_0_1_2_4_3 + 0.00339826839826851*G0_0_1_2_4_4 + 0.000822510822510851*G0_0_1_2_4_5 - 0.000270562770562779*G0_0_1_2_5_1 - 0.000129870129870136*G0_0_1_2_5_2 + 0.00073593073593076*G0_0_1_2_5_3 + 0.000822510822510851*G0_0_1_2_5_4 + 0.000129870129870133*G0_0_1_2_5_5 - 0.000243506493506498*G0_0_1_3_0_0 - 0.00018398268398269*G0_0_1_3_0_1 - 0.000238095238095244*G0_0_1_3_0_2 + 0.000519480519480535*G0_0_1_3_0_3 + 0.000476190476190491*G0_0_1_3_0_4 + 0.00056277056277058*G0_0_1_3_0_5 - 0.00018398268398269*G0_0_1_3_1_0 - 0.00156926406926412*G0_0_1_3_1_1 - 0.0032900432900434*G0_0_1_3_1_3 + 0.000562770562770581*G0_0_1_3_1_4 + 0.000909090909090937*G0_0_1_3_1_5 - 0.000238095238095245*G0_0_1_3_2_0 - 0.000703463203463238*G0_0_1_3_2_2 + 0.00380952380952393*G0_0_1_3_2_3 + 0.00103896103896107*G0_0_1_3_2_4 + 0.00073593073593076*G0_0_1_3_2_5 + 0.000519480519480535*G0_0_1_3_3_0 - 0.0032900432900434*G0_0_1_3_3_1 + 0.00380952380952393*G0_0_1_3_3_2 + 0.000779220779220825*G0_0_1_3_3_3 - 0.00216450216450223*G0_0_1_3_3_4 - 0.00251082251082259*G0_0_1_3_3_5 + 0.000476190476190491*G0_0_1_3_4_0 + 0.000562770562770581*G0_0_1_3_4_1 + 0.00103896103896107*G0_0_1_3_4_2 - 0.00216450216450223*G0_0_1_3_4_3 - 0.000173160173160185*G0_0_1_3_4_4 - 0.00259740259740268*G0_0_1_3_4_5 + 0.00056277056277058*G0_0_1_3_5_0 + 0.000909090909090937*G0_0_1_3_5_1 + 0.00073593073593076*G0_0_1_3_5_2 - 0.00251082251082259*G0_0_1_3_5_3 - 0.00259740259740268*G0_0_1_3_5_4 - 0.00138528138528143*G0_0_1_3_5_5 - 0.00492424242424259*G0_0_1_4_0_0 - 0.000162337662337665*G0_0_1_4_0_2 + 0.000476190476190491*G0_0_1_4_0_3 - 0.00313852813852824*G0_0_1_4_0_4 - 0.00028138528138529*G0_0_1_4_1_2 + 0.000562770562770581*G0_0_1_4_1_3 - 0.000389610389610397*G0_0_1_4_1_4 + 0.00073593073593076*G0_0_1_4_1_5 - 0.000162337662337665*G0_0_1_4_2_0 - 0.00028138528138529*G0_0_1_4_2_1 - 0.000351731601731626*G0_0_1_4_2_2 + 0.00103896103896107*G0_0_1_4_2_3 + 0.00339826839826851*G0_0_1_4_2_4 + 0.000822510822510851*G0_0_1_4_2_5 + 0.000476190476190491*G0_0_1_4_3_0 + 0.000562770562770581*G0_0_1_4_3_1 + 0.00103896103896107*G0_0_1_4_3_2 - 0.00216450216450223*G0_0_1_4_3_3 - 0.000173160173160185*G0_0_1_4_3_4 - 0.00259740259740268*G0_0_1_4_3_5 - 0.00313852813852824*G0_0_1_4_4_0 - 0.000389610389610397*G0_0_1_4_4_1 + 0.00339826839826851*G0_0_1_4_4_2 - 0.000173160173160185*G0_0_1_4_4_3 + 0.0397402597402609*G0_0_1_4_4_4 - 0.000865800865800901*G0_0_1_4_4_5 + 0.00073593073593076*G0_0_1_4_5_1 + 0.000822510822510851*G0_0_1_4_5_2 - 0.00259740259740268*G0_0_1_4_5_3 - 0.000865800865800901*G0_0_1_4_5_4 - 0.00173160173160179*G0_0_1_4_5_5 - 0.00213744588744596*G0_0_1_5_0_0 - 0.000844155844155873*G0_0_1_5_0_1 + 0.00056277056277058*G0_0_1_5_0_3 + 0.00203463203463211*G0_0_1_5_0_5 - 0.000844155844155873*G0_0_1_5_1_0 + 0.00156926406926413*G0_0_1_5_1_1 - 0.000270562770562779*G0_0_1_5_1_2 + 0.000909090909090937*G0_0_1_5_1_3 + 0.00073593073593076*G0_0_1_5_1_4 + 0.00147186147186152*G0_0_1_5_1_5 - 0.000270562770562779*G0_0_1_5_2_1 - 0.000129870129870136*G0_0_1_5_2_2 + 0.00073593073593076*G0_0_1_5_2_3 + 0.000822510822510851*G0_0_1_5_2_4 + 0.000129870129870133*G0_0_1_5_2_5 + 0.00056277056277058*G0_0_1_5_3_0 + 0.000909090909090937*G0_0_1_5_3_1 + 0.00073593073593076*G0_0_1_5_3_2 - 0.00251082251082259*G0_0_1_5_3_3 - 0.00259740259740268*G0_0_1_5_3_4 - 0.00138528138528143*G0_0_1_5_3_5 + 0.00073593073593076*G0_0_1_5_4_1 + 0.000822510822510851*G0_0_1_5_4_2 - 0.00259740259740268*G0_0_1_5_4_3 - 0.000865800865800901*G0_0_1_5_4_4 - 0.00173160173160179*G0_0_1_5_4_5 + 0.00203463203463211*G0_0_1_5_5_0 + 0.00147186147186152*G0_0_1_5_5_1 + 0.000129870129870133*G0_0_1_5_5_2 - 0.00138528138528143*G0_0_1_5_5_3 - 0.00173160173160179*G0_0_1_5_5_4 + 0.0109090909090913*G0_0_1_5_5_5 + 0.020150162337663*G0_1_0_0_0_0 - 0.000735930735930758*G0_1_0_0_0_1 - 0.00127299783549788*G0_1_0_0_0_2 + 0.000243506493506498*G0_1_0_0_0_3 + 0.00492424242424259*G0_1_0_0_0_4 + 0.00213744588744596*G0_1_0_0_0_5 - 0.000735930735930758*G0_1_0_0_1_0 + 0.000248917748917759*G0_1_0_0_1_1 + 0.00018398268398269*G0_1_0_0_1_3 + 0.000844155844155873*G0_1_0_0_1_5 - 0.00127299783549788*G0_1_0_0_2_0 + 0.000238095238095244*G0_1_0_0_2_3 + 0.000162337662337665*G0_1_0_0_2_4 + 0.000243506493506498*G0_1_0_0_3_0 + 0.00018398268398269*G0_1_0_0_3_1 + 0.000238095238095244*G0_1_0_0_3_2 - 0.000519480519480535*G0_1_0_0_3_3 - 0.000476190476190491*G0_1_0_0_3_4 - 0.00056277056277058*G0_1_0_0_3_5 + 0.00492424242424259*G0_1_0_0_4_0 + 0.000162337662337665*G0_1_0_0_4_2 - 0.000476190476190491*G0_1_0_0_4_3 + 0.00313852813852824*G0_1_0_0_4_4 + 0.00213744588744596*G0_1_0_0_5_0 + 0.000844155844155873*G0_1_0_0_5_1 - 0.00056277056277058*G0_1_0_0_5_3 - 0.00203463203463211*G0_1_0_0_5_5 - 0.000735930735930758*G0_1_0_1_0_0 + 0.000248917748917759*G0_1_0_1_0_1 + 0.00018398268398269*G0_1_0_1_0_3 + 0.000844155844155873*G0_1_0_1_0_5 + 0.000248917748917759*G0_1_0_1_1_0 - 0.000346320346320357*G0_1_0_1_1_2 + 0.00156926406926412*G0_1_0_1_1_3 - 0.00156926406926413*G0_1_0_1_1_5 - 0.000346320346320357*G0_1_0_1_2_1 - 0.000116341991341997*G0_1_0_1_2_2 + 0.00028138528138529*G0_1_0_1_2_4 + 0.000270562770562779*G0_1_0_1_2_5 + 0.00018398268398269*G0_1_0_1_3_0 + 0.00156926406926412*G0_1_0_1_3_1 + 0.0032900432900434*G0_1_0_1_3_3 - 0.000562770562770581*G0_1_0_1_3_4 - 0.000909090909090938*G0_1_0_1_3_5 + 0.00028138528138529*G0_1_0_1_4_2 - 0.000562770562770581*G0_1_0_1_4_3 + 0.000389610389610397*G0_1_0_1_4_4 - 0.00073593073593076*G0_1_0_1_4_5 + 0.000844155844155873*G0_1_0_1_5_0 - 0.00156926406926413*G0_1_0_1_5_1 + 0.000270562770562779*G0_1_0_1_5_2 - 0.000909090909090938*G0_1_0_1_5_3 - 0.00073593073593076*G0_1_0_1_5_4 - 0.00147186147186152*G0_1_0_1_5_5 - 0.00127299783549788*G0_1_0_2_0_0 + 0.000238095238095244*G0_1_0_2_0_3 + 0.000162337662337665*G0_1_0_2_0_4 - 0.000346320346320357*G0_1_0_2_1_1 - 0.000116341991341997*G0_1_0_2_1_2 + 0.00028138528138529*G0_1_0_2_1_4 + 0.000270562770562779*G0_1_0_2_1_5 - 0.000116341991341997*G0_1_0_2_2_1 + 0.00756087662337692*G0_1_0_2_2_2 + 0.000703463203463238*G0_1_0_2_2_3 + 0.000351731601731626*G0_1_0_2_2_4 + 0.000129870129870136*G0_1_0_2_2_5 + 0.000238095238095244*G0_1_0_2_3_0 + 0.000703463203463238*G0_1_0_2_3_2 - 0.00380952380952393*G0_1_0_2_3_3 - 0.00103896103896107*G0_1_0_2_3_4 - 0.00073593073593076*G0_1_0_2_3_5 + 0.000162337662337665*G0_1_0_2_4_0 + 0.00028138528138529*G0_1_0_2_4_1 + 0.000351731601731626*G0_1_0_2_4_2 - 0.00103896103896107*G0_1_0_2_4_3 - 0.00339826839826851*G0_1_0_2_4_4 - 0.000822510822510851*G0_1_0_2_4_5 + 0.000270562770562779*G0_1_0_2_5_1 + 0.000129870129870136*G0_1_0_2_5_2 - 0.00073593073593076*G0_1_0_2_5_3 - 0.000822510822510851*G0_1_0_2_5_4 - 0.000129870129870133*G0_1_0_2_5_5 + 0.000243506493506498*G0_1_0_3_0_0 + 0.00018398268398269*G0_1_0_3_0_1 + 0.000238095238095244*G0_1_0_3_0_2 - 0.000519480519480535*G0_1_0_3_0_3 - 0.000476190476190491*G0_1_0_3_0_4 - 0.00056277056277058*G0_1_0_3_0_5 + 0.00018398268398269*G0_1_0_3_1_0 + 0.00156926406926412*G0_1_0_3_1_1 + 0.0032900432900434*G0_1_0_3_1_3 - 0.000562770562770581*G0_1_0_3_1_4 - 0.000909090909090937*G0_1_0_3_1_5 + 0.000238095238095244*G0_1_0_3_2_0 + 0.000703463203463238*G0_1_0_3_2_2 - 0.00380952380952393*G0_1_0_3_2_3 - 0.00103896103896107*G0_1_0_3_2_4 - 0.00073593073593076*G0_1_0_3_2_5 - 0.000519480519480535*G0_1_0_3_3_0 + 0.0032900432900434*G0_1_0_3_3_1 - 0.00380952380952393*G0_1_0_3_3_2 - 0.000779220779220826*G0_1_0_3_3_3 + 0.00216450216450223*G0_1_0_3_3_4 + 0.00251082251082259*G0_1_0_3_3_5 - 0.000476190476190491*G0_1_0_3_4_0 - 0.000562770562770581*G0_1_0_3_4_1 - 0.00103896103896107*G0_1_0_3_4_2 + 0.00216450216450223*G0_1_0_3_4_3 + 0.000173160173160186*G0_1_0_3_4_4 + 0.00259740259740268*G0_1_0_3_4_5 - 0.00056277056277058*G0_1_0_3_5_0 - 0.000909090909090938*G0_1_0_3_5_1 - 0.00073593073593076*G0_1_0_3_5_2 + 0.00251082251082259*G0_1_0_3_5_3 + 0.00259740259740268*G0_1_0_3_5_4 + 0.00138528138528143*G0_1_0_3_5_5 + 0.00492424242424259*G0_1_0_4_0_0 + 0.000162337662337665*G0_1_0_4_0_2 - 0.000476190476190491*G0_1_0_4_0_3 + 0.00313852813852824*G0_1_0_4_0_4 + 0.00028138528138529*G0_1_0_4_1_2 - 0.000562770562770581*G0_1_0_4_1_3 + 0.000389610389610397*G0_1_0_4_1_4 - 0.00073593073593076*G0_1_0_4_1_5 + 0.000162337662337665*G0_1_0_4_2_0 + 0.00028138528138529*G0_1_0_4_2_1 + 0.000351731601731626*G0_1_0_4_2_2 - 0.00103896103896107*G0_1_0_4_2_3 - 0.00339826839826851*G0_1_0_4_2_4 - 0.000822510822510851*G0_1_0_4_2_5 - 0.000476190476190491*G0_1_0_4_3_0 - 0.000562770562770581*G0_1_0_4_3_1 - 0.00103896103896107*G0_1_0_4_3_2 + 0.00216450216450223*G0_1_0_4_3_3 + 0.000173160173160186*G0_1_0_4_3_4 + 0.00259740259740268*G0_1_0_4_3_5 + 0.00313852813852824*G0_1_0_4_4_0 + 0.000389610389610397*G0_1_0_4_4_1 - 0.00339826839826851*G0_1_0_4_4_2 + 0.000173160173160186*G0_1_0_4_4_3 - 0.0397402597402609*G0_1_0_4_4_4 + 0.000865800865800902*G0_1_0_4_4_5 - 0.00073593073593076*G0_1_0_4_5_1 - 0.000822510822510851*G0_1_0_4_5_2 + 0.00259740259740268*G0_1_0_4_5_3 + 0.000865800865800902*G0_1_0_4_5_4 + 0.00173160173160179*G0_1_0_4_5_5 + 0.00213744588744596*G0_1_0_5_0_0 + 0.000844155844155873*G0_1_0_5_0_1 - 0.00056277056277058*G0_1_0_5_0_3 - 0.00203463203463211*G0_1_0_5_0_5 + 0.000844155844155873*G0_1_0_5_1_0 - 0.00156926406926413*G0_1_0_5_1_1 + 0.000270562770562779*G0_1_0_5_1_2 - 0.000909090909090938*G0_1_0_5_1_3 - 0.00073593073593076*G0_1_0_5_1_4 - 0.00147186147186152*G0_1_0_5_1_5 + 0.000270562770562779*G0_1_0_5_2_1 + 0.000129870129870136*G0_1_0_5_2_2 - 0.00073593073593076*G0_1_0_5_2_3 - 0.000822510822510851*G0_1_0_5_2_4 - 0.000129870129870133*G0_1_0_5_2_5 - 0.00056277056277058*G0_1_0_5_3_0 - 0.000909090909090938*G0_1_0_5_3_1 - 0.00073593073593076*G0_1_0_5_3_2 + 0.00251082251082259*G0_1_0_5_3_3 + 0.00259740259740268*G0_1_0_5_3_4 + 0.00138528138528143*G0_1_0_5_3_5 - 0.00073593073593076*G0_1_0_5_4_1 - 0.000822510822510851*G0_1_0_5_4_2 + 0.00259740259740268*G0_1_0_5_4_3 + 0.000865800865800902*G0_1_0_5_4_4 + 0.00173160173160179*G0_1_0_5_4_5 - 0.00203463203463211*G0_1_0_5_5_0 - 0.00147186147186152*G0_1_0_5_5_1 - 0.000129870129870133*G0_1_0_5_5_2 + 0.00138528138528143*G0_1_0_5_5_3 + 0.00173160173160179*G0_1_0_5_5_4 - 0.0109090909090913*G0_1_0_5_5_5;
    A[31] = -A[51] - 0.00611201298701321*G0_0_0_0_0_0 + 0.000771103896103921*G0_0_0_0_0_1 + 0.000698051948051973*G0_0_0_0_0_2 - 0.000162337662337665*G0_0_0_0_0_3 - 0.00633116883116904*G0_0_0_0_0_4 - 0.000649350649350674*G0_0_0_0_0_5 + 0.000771103896103921*G0_0_0_0_1_0 - 0.00230519480519488*G0_0_0_0_1_1 + 0.000292207792207803*G0_0_0_0_1_2 - 0.00246753246753255*G0_0_0_0_1_3 - 0.000162337662337666*G0_0_0_0_1_4 - 0.00175324675324681*G0_0_0_0_1_5 + 0.000698051948051973*G0_0_0_0_2_0 + 0.000292207792207803*G0_0_0_0_2_1 + 0.000511363636363653*G0_0_0_0_2_2 + 0.00113636363636367*G0_0_0_0_2_3 + 0.00337662337662349*G0_0_0_0_2_4 + 0.000681818181818205*G0_0_0_0_2_5 - 0.000162337662337665*G0_0_0_0_3_0 - 0.00246753246753255*G0_0_0_0_3_1 + 0.00113636363636367*G0_0_0_0_3_2 - 0.000259740259740283*G0_0_0_0_3_3 + 0.000649350649350666*G0_0_0_0_3_4 - 0.00103896103896108*G0_0_0_0_3_5 - 0.00633116883116905*G0_0_0_0_4_0 - 0.000162337662337665*G0_0_0_0_4_1 + 0.00337662337662349*G0_0_0_0_4_2 + 0.000649350649350666*G0_0_0_0_4_3 - 0.00506493506493525*G0_0_0_0_4_4 - 0.00103896103896108*G0_0_0_0_4_5 - 0.000649350649350674*G0_0_0_0_5_0 - 0.00175324675324681*G0_0_0_0_5_1 + 0.000681818181818205*G0_0_0_0_5_2 - 0.00103896103896108*G0_0_0_0_5_3 - 0.00103896103896108*G0_0_0_0_5_4 - 0.00155844155844161*G0_0_0_0_5_5 + 0.000771103896103921*G0_0_0_1_0_0 - 0.00230519480519488*G0_0_0_1_0_1 + 0.000292207792207802*G0_0_0_1_0_2 - 0.00246753246753255*G0_0_0_1_0_3 - 0.000162337662337666*G0_0_0_1_0_4 - 0.00175324675324681*G0_0_0_1_0_5 - 0.00230519480519488*G0_0_0_1_1_0 + 0.0304383116883127*G0_0_0_1_1_1 - 0.0044967532467534*G0_0_0_1_1_2 + 0.0194805194805202*G0_0_0_1_1_3 + 0.00103896103896107*G0_0_0_1_1_4 + 0.00941558441558475*G0_0_0_1_1_5 + 0.000292207792207802*G0_0_0_1_2_0 - 0.0044967532467534*G0_0_0_1_2_1 + 0.00138798701298706*G0_0_0_1_2_2 - 0.0039610389610391*G0_0_0_1_2_3 - 0.00155844155844162*G0_0_0_1_2_5 - 0.00246753246753255*G0_0_0_1_3_0 + 0.0194805194805202*G0_0_0_1_3_1 - 0.0039610389610391*G0_0_0_1_3_2 + 0.0296103896103907*G0_0_0_1_3_3 + 0.00285714285714295*G0_0_0_1_3_4 + 0.00805194805194835*G0_0_0_1_3_5 - 0.000162337662337666*G0_0_0_1_4_0 + 0.00103896103896107*G0_0_0_1_4_1 + 0.00285714285714295*G0_0_0_1_4_3 + 0.00376623376623388*G0_0_0_1_4_4 + 0.00103896103896107*G0_0_0_1_4_5 - 0.00175324675324681*G0_0_0_1_5_0 + 0.00941558441558475*G0_0_0_1_5_1 - 0.00155844155844162*G0_0_0_1_5_2 + 0.00805194805194835*G0_0_0_1_5_3 + 0.00103896103896107*G0_0_0_1_5_4 + 0.00623376623376645*G0_0_0_1_5_5 + 0.000698051948051973*G0_0_0_2_0_0 + 0.000292207792207803*G0_0_0_2_0_1 + 0.000511363636363653*G0_0_0_2_0_2 + 0.00113636363636367*G0_0_0_2_0_3 + 0.00337662337662349*G0_0_0_2_0_4 + 0.000681818181818205*G0_0_0_2_0_5 + 0.000292207792207803*G0_0_0_2_1_0 - 0.0044967532467534*G0_0_0_2_1_1 + 0.00138798701298706*G0_0_0_2_1_2 - 0.0039610389610391*G0_0_0_2_1_3 - 0.00155844155844162*G0_0_0_2_1_5 + 0.000511363636363653*G0_0_0_2_2_0 + 0.00138798701298706*G0_0_0_2_2_1 - 0.00438311688311702*G0_0_0_2_2_2 - 0.000454545454545464*G0_0_0_2_2_3 - 0.00538961038961057*G0_0_0_2_2_4 + 0.000292207792207803*G0_0_0_2_2_5 + 0.00113636363636367*G0_0_0_2_3_0 - 0.0039610389610391*G0_0_0_2_3_1 - 0.000454545454545464*G0_0_0_2_3_2 - 0.0140259740259745*G0_0_0_2_3_3 - 0.00233766233766242*G0_0_0_2_3_4 - 0.00285714285714296*G0_0_0_2_3_5 + 0.00337662337662349*G0_0_0_2_4_0 - 0.00538961038961057*G0_0_0_2_4_2 - 0.00233766233766242*G0_0_0_2_4_3 - 0.00467532467532484*G0_0_0_2_4_4 - 0.000649350649350675*G0_0_0_2_4_5 + 0.000681818181818205*G0_0_0_2_5_0 - 0.00155844155844162*G0_0_0_2_5_1 + 0.000292207792207803*G0_0_0_2_5_2 - 0.00285714285714296*G0_0_0_2_5_3 - 0.000649350649350675*G0_0_0_2_5_4 - 0.00233766233766242*G0_0_0_2_5_5 - 0.000162337662337665*G0_0_0_3_0_0 - 0.00246753246753255*G0_0_0_3_0_1 + 0.00113636363636367*G0_0_0_3_0_2 - 0.000259740259740283*G0_0_0_3_0_3 + 0.000649350649350666*G0_0_0_3_0_4 - 0.00103896103896108*G0_0_0_3_0_5 - 0.00246753246753255*G0_0_0_3_1_0 + 0.0194805194805202*G0_0_0_3_1_1 - 0.00396103896103911*G0_0_0_3_1_2 + 0.0296103896103907*G0_0_0_3_1_3 + 0.00285714285714295*G0_0_0_3_1_4 + 0.00805194805194835*G0_0_0_3_1_5 + 0.00113636363636367*G0_0_0_3_2_0 - 0.0039610389610391*G0_0_0_3_2_1 - 0.000454545454545464*G0_0_0_3_2_2 - 0.0140259740259745*G0_0_0_3_2_3 - 0.00233766233766242*G0_0_0_3_2_4 - 0.00285714285714296*G0_0_0_3_2_5 - 0.000259740259740283*G0_0_0_3_3_0 + 0.0296103896103907*G0_0_0_3_3_1 - 0.0140259740259745*G0_0_0_3_3_2 + 0.0093506493506498*G0_0_0_3_3_3 - 0.00519480519480534*G0_0_0_3_3_4 + 0.0062337662337665*G0_0_0_3_3_5 + 0.000649350649350666*G0_0_0_3_4_0 + 0.00285714285714295*G0_0_0_3_4_1 - 0.00233766233766242*G0_0_0_3_4_2 - 0.00519480519480534*G0_0_0_3_4_3 - 0.0088311688311691*G0_0_0_3_4_4 - 0.00103896103896108*G0_0_0_3_5_0 + 0.00805194805194835*G0_0_0_3_5_1 - 0.00285714285714296*G0_0_0_3_5_2 + 0.00623376623376649*G0_0_0_3_5_3 + 0.00675324675324701*G0_0_0_3_5_5 - 0.00633116883116904*G0_0_0_4_0_0 - 0.000162337662337665*G0_0_0_4_0_1 + 0.00337662337662349*G0_0_0_4_0_2 + 0.000649350649350666*G0_0_0_4_0_3 - 0.00506493506493525*G0_0_0_4_0_4 - 0.00103896103896108*G0_0_0_4_0_5 - 0.000162337662337665*G0_0_0_4_1_0 + 0.00103896103896107*G0_0_0_4_1_1 + 0.00285714285714295*G0_0_0_4_1_3 + 0.00376623376623388*G0_0_0_4_1_4 + 0.00103896103896107*G0_0_0_4_1_5 + 0.00337662337662349*G0_0_0_4_2_0 - 0.00538961038961057*G0_0_0_4_2_2 - 0.00233766233766242*G0_0_0_4_2_3 - 0.00467532467532484*G0_0_0_4_2_4 - 0.000649350649350675*G0_0_0_4_2_5 + 0.000649350649350666*G0_0_0_4_3_0 + 0.00285714285714295*G0_0_0_4_3_1 - 0.00233766233766242*G0_0_0_4_3_2 - 0.00519480519480534*G0_0_0_4_3_3 - 0.0088311688311691*G0_0_0_4_3_4 - 0.00506493506493525*G0_0_0_4_4_0 + 0.00376623376623388*G0_0_0_4_4_1 - 0.00467532467532484*G0_0_0_4_4_2 - 0.0088311688311691*G0_0_0_4_4_3 - 0.107532467532471*G0_0_0_4_4_4 - 0.00623376623376643*G0_0_0_4_4_5 - 0.00103896103896107*G0_0_0_4_5_0 + 0.00103896103896107*G0_0_0_4_5_1 - 0.000649350649350675*G0_0_0_4_5_2 - 0.00623376623376643*G0_0_0_4_5_4 + 0.00259740259740269*G0_0_0_4_5_5 - 0.000649350649350674*G0_0_0_5_0_0 - 0.00175324675324681*G0_0_0_5_0_1 + 0.000681818181818205*G0_0_0_5_0_2 - 0.00103896103896108*G0_0_0_5_0_3 - 0.00103896103896108*G0_0_0_5_0_4 - 0.00155844155844161*G0_0_0_5_0_5 - 0.00175324675324681*G0_0_0_5_1_0 + 0.00941558441558475*G0_0_0_5_1_1 - 0.00155844155844162*G0_0_0_5_1_2 + 0.00805194805194835*G0_0_0_5_1_3 + 0.00103896103896107*G0_0_0_5_1_4 + 0.00623376623376645*G0_0_0_5_1_5 + 0.000681818181818205*G0_0_0_5_2_0 - 0.00155844155844162*G0_0_0_5_2_1 + 0.000292207792207803*G0_0_0_5_2_2 - 0.00285714285714296*G0_0_0_5_2_3 - 0.000649350649350675*G0_0_0_5_2_4 - 0.00233766233766242*G0_0_0_5_2_5 - 0.00103896103896108*G0_0_0_5_3_0 + 0.00805194805194835*G0_0_0_5_3_1 - 0.00285714285714296*G0_0_0_5_3_2 + 0.00623376623376649*G0_0_0_5_3_3 + 0.00675324675324701*G0_0_0_5_3_5 - 0.00103896103896108*G0_0_0_5_4_0 + 0.00103896103896107*G0_0_0_5_4_1 - 0.000649350649350675*G0_0_0_5_4_2 - 0.00623376623376643*G0_0_0_5_4_4 + 0.00259740259740269*G0_0_0_5_4_5 - 0.00155844155844161*G0_0_0_5_5_0 + 0.00623376623376645*G0_0_0_5_5_1 - 0.00233766233766242*G0_0_0_5_5_2 + 0.00675324675324701*G0_0_0_5_5_3 + 0.00259740259740269*G0_0_0_5_5_4 + 0.0140259740259745*G0_0_0_5_5_5 + 0.01935064935065*G0_1_0_0_0_0 + 0.000919913419913453*G0_1_0_0_0_1 - 0.00145292207792212*G0_1_0_0_0_2 + 0.00107683982683986*G0_1_0_0_0_3 + 0.00486471861471877*G0_1_0_0_0_4 + 0.00390151515151528*G0_1_0_0_0_5 + 0.000919913419913453*G0_1_0_0_1_0 - 0.0111011904761909*G0_1_0_0_1_1 + 0.00101596320346324*G0_1_0_0_1_2 - 0.00414502164502179*G0_1_0_0_1_3 - 0.000557359307359325*G0_1_0_0_1_4 - 0.00662337662337685*G0_1_0_0_1_5 - 0.00145292207792212*G0_1_0_0_2_0 + 0.00101596320346324*G0_1_0_0_2_1 - 0.000238095238095249*G0_1_0_0_2_2 + 0.0011580086580087*G0_1_0_0_2_3 + 0.0003896103896104*G0_1_0_0_2_4 + 0.00095779220779224*G0_1_0_0_2_5 + 0.00107683982683986*G0_1_0_0_3_0 - 0.00414502164502179*G0_1_0_0_3_1 + 0.0011580086580087*G0_1_0_0_3_2 - 0.00458874458874474*G0_1_0_0_3_3 - 0.00103896103896107*G0_1_0_0_3_4 - 0.00406926406926421*G0_1_0_0_3_5 + 0.00486471861471877*G0_1_0_0_4_0 - 0.000557359307359325*G0_1_0_0_4_1 + 0.0003896103896104*G0_1_0_0_4_2 - 0.00103896103896107*G0_1_0_0_4_3 + 0.00285714285714294*G0_1_0_0_4_4 - 0.000800865800865824*G0_1_0_0_4_5 + 0.00390151515151528*G0_1_0_0_5_0 - 0.00662337662337685*G0_1_0_0_5_1 + 0.00095779220779224*G0_1_0_0_5_2 - 0.00406926406926421*G0_1_0_0_5_3 - 0.000800865800865824*G0_1_0_0_5_4 - 0.0108658008658012*G0_1_0_0_5_5 + 0.000919913419913453*G0_1_0_1_0_0 - 0.0111011904761909*G0_1_0_1_0_1 + 0.00101596320346324*G0_1_0_1_0_2 - 0.00414502164502179*G0_1_0_1_0_3 - 0.000557359307359325*G0_1_0_1_0_4 - 0.00662337662337685*G0_1_0_1_0_5 - 0.0111011904761909*G0_1_0_1_1_0 + 0.166233766233772*G0_1_0_1_1_1 - 0.011696428571429*G0_1_0_1_1_2 + 0.0501082251082269*G0_1_0_1_1_3 + 0.00323593073593083*G0_1_0_1_1_4 + 0.0469696969696988*G0_1_0_1_1_5 + 0.00101596320346324*G0_1_0_1_2_0 - 0.011696428571429*G0_1_0_1_2_1 + 0.00153950216450222*G0_1_0_1_2_2 - 0.00746753246753273*G0_1_0_1_2_3 - 0.000270562770562781*G0_1_0_1_2_4 - 0.00405844155844171*G0_1_0_1_2_5 - 0.00414502164502179*G0_1_0_1_3_0 + 0.0501082251082269*G0_1_0_1_3_1 - 0.00746753246753273*G0_1_0_1_3_2 + 0.0379220779220793*G0_1_0_1_3_3 + 0.00181818181818188*G0_1_0_1_3_4 + 0.016406926406927*G0_1_0_1_3_5 - 0.000557359307359325*G0_1_0_1_4_0 + 0.00323593073593083*G0_1_0_1_4_1 - 0.000270562770562781*G0_1_0_1_4_2 + 0.00181818181818188*G0_1_0_1_4_3 + 0.000735930735930758*G0_1_0_1_4_4 + 0.0016450216450217*G0_1_0_1_4_5 - 0.00662337662337685*G0_1_0_1_5_0 + 0.0469696969696987*G0_1_0_1_5_1 - 0.00405844155844171*G0_1_0_1_5_2 + 0.016406926406927*G0_1_0_1_5_3 + 0.0016450216450217*G0_1_0_1_5_4 + 0.0331601731601744*G0_1_0_1_5_5 - 0.00145292207792212*G0_1_0_2_0_0 + 0.00101596320346324*G0_1_0_2_0_1 - 0.000238095238095249*G0_1_0_2_0_2 + 0.0011580086580087*G0_1_0_2_0_3 + 0.0003896103896104*G0_1_0_2_0_4 + 0.00095779220779224*G0_1_0_2_0_5 + 0.00101596320346324*G0_1_0_2_1_0 - 0.011696428571429*G0_1_0_2_1_1 + 0.00153950216450222*G0_1_0_2_1_2 - 0.00746753246753273*G0_1_0_2_1_3 - 0.000270562770562781*G0_1_0_2_1_4 - 0.00405844155844171*G0_1_0_2_1_5 - 0.000238095238095249*G0_1_0_2_2_0 + 0.00153950216450222*G0_1_0_2_2_1 + 0.00676136363636391*G0_1_0_2_2_2 + 0.00246753246753256*G0_1_0_2_2_3 + 0.000292207792207817*G0_1_0_2_2_4 + 0.000963203463203499*G0_1_0_2_2_5 + 0.0011580086580087*G0_1_0_2_3_0 - 0.00746753246753273*G0_1_0_2_3_1 + 0.00246753246753256*G0_1_0_2_3_2 - 0.0126406926406931*G0_1_0_2_3_3 - 0.00177489177489183*G0_1_0_2_3_4 - 0.0042424242424244*G0_1_0_2_3_5 + 0.0003896103896104*G0_1_0_2_4_0 - 0.000270562770562781*G0_1_0_2_4_1 + 0.000292207792207817*G0_1_0_2_4_2 - 0.00177489177489183*G0_1_0_2_4_3 - 0.00367965367965379*G0_1_0_2_4_4 - 0.00138528138528143*G0_1_0_2_4_5 + 0.00095779220779224*G0_1_0_2_5_0 - 0.00405844155844171*G0_1_0_2_5_1 + 0.000963203463203499*G0_1_0_2_5_2 - 0.0042424242424244*G0_1_0_2_5_3 - 0.00138528138528143*G0_1_0_2_5_4 - 0.00419913419913435*G0_1_0_2_5_5 + 0.00107683982683986*G0_1_0_3_0_0 - 0.00414502164502179*G0_1_0_3_0_1 + 0.0011580086580087*G0_1_0_3_0_2 - 0.00458874458874474*G0_1_0_3_0_3 - 0.00103896103896107*G0_1_0_3_0_4 - 0.00406926406926421*G0_1_0_3_0_5 - 0.00414502164502179*G0_1_0_3_1_0 + 0.0501082251082269*G0_1_0_3_1_1 - 0.00746753246753273*G0_1_0_3_1_2 + 0.0379220779220793*G0_1_0_3_1_3 + 0.00181818181818188*G0_1_0_3_1_4 + 0.016406926406927*G0_1_0_3_1_5 + 0.0011580086580087*G0_1_0_3_2_0 - 0.00746753246753273*G0_1_0_3_2_1 + 0.00246753246753256*G0_1_0_3_2_2 - 0.0126406926406931*G0_1_0_3_2_3 - 0.00177489177489183*G0_1_0_3_2_4 - 0.0042424242424244*G0_1_0_3_2_5 - 0.00458874458874474*G0_1_0_3_3_0 + 0.0379220779220793*G0_1_0_3_3_1 - 0.0126406926406931*G0_1_0_3_3_2 + 0.0446753246753263*G0_1_0_3_3_3 + 0.00554112554112573*G0_1_0_3_3_4 + 0.0176623376623383*G0_1_0_3_3_5 - 0.00103896103896107*G0_1_0_3_4_0 + 0.00181818181818188*G0_1_0_3_4_1 - 0.00177489177489183*G0_1_0_3_4_2 + 0.00554112554112573*G0_1_0_3_4_3 + 0.000606060606060627*G0_1_0_3_4_4 + 0.00484848484848501*G0_1_0_3_4_5 - 0.00406926406926421*G0_1_0_3_5_0 + 0.016406926406927*G0_1_0_3_5_1 - 0.0042424242424244*G0_1_0_3_5_2 + 0.0176623376623383*G0_1_0_3_5_3 + 0.00484848484848501*G0_1_0_3_5_4 + 0.0165367965367971*G0_1_0_3_5_5 + 0.00486471861471877*G0_1_0_4_0_0 - 0.000557359307359325*G0_1_0_4_0_1 + 0.0003896103896104*G0_1_0_4_0_2 - 0.00103896103896107*G0_1_0_4_0_3 + 0.00285714285714294*G0_1_0_4_0_4 - 0.000800865800865824*G0_1_0_4_0_5 - 0.000557359307359325*G0_1_0_4_1_0 + 0.00323593073593083*G0_1_0_4_1_1 - 0.000270562770562781*G0_1_0_4_1_2 + 0.00181818181818188*G0_1_0_4_1_3 + 0.000735930735930758*G0_1_0_4_1_4 + 0.0016450216450217*G0_1_0_4_1_5 + 0.0003896103896104*G0_1_0_4_2_0 - 0.000270562770562781*G0_1_0_4_2_1 + 0.000292207792207817*G0_1_0_4_2_2 - 0.00177489177489183*G0_1_0_4_2_3 - 0.00367965367965379*G0_1_0_4_2_4 - 0.00138528138528143*G0_1_0_4_2_5 - 0.00103896103896107*G0_1_0_4_3_0 + 0.00181818181818188*G0_1_0_4_3_1 - 0.00177489177489183*G0_1_0_4_3_2 + 0.00554112554112573*G0_1_0_4_3_3 + 0.000606060606060628*G0_1_0_4_3_4 + 0.00484848484848501*G0_1_0_4_3_5 + 0.00285714285714294*G0_1_0_4_4_0 + 0.000735930735930758*G0_1_0_4_4_1 - 0.00367965367965379*G0_1_0_4_4_2 + 0.000606060606060628*G0_1_0_4_4_3 - 0.0418181818181831*G0_1_0_4_4_4 + 0.00129870129870134*G0_1_0_4_4_5 - 0.000800865800865824*G0_1_0_4_5_0 + 0.0016450216450217*G0_1_0_4_5_1 - 0.00138528138528143*G0_1_0_4_5_2 + 0.00484848484848501*G0_1_0_4_5_3 + 0.00129870129870134*G0_1_0_4_5_4 + 0.00510822510822526*G0_1_0_4_5_5 + 0.00390151515151528*G0_1_0_5_0_0 - 0.00662337662337685*G0_1_0_5_0_1 + 0.00095779220779224*G0_1_0_5_0_2 - 0.00406926406926421*G0_1_0_5_0_3 - 0.000800865800865824*G0_1_0_5_0_4 - 0.0108658008658012*G0_1_0_5_0_5 - 0.00662337662337685*G0_1_0_5_1_0 + 0.0469696969696987*G0_1_0_5_1_1 - 0.00405844155844171*G0_1_0_5_1_2 + 0.016406926406927*G0_1_0_5_1_3 + 0.0016450216450217*G0_1_0_5_1_4 + 0.0331601731601744*G0_1_0_5_1_5 + 0.00095779220779224*G0_1_0_5_2_0 - 0.00405844155844171*G0_1_0_5_2_1 + 0.000963203463203499*G0_1_0_5_2_2 - 0.0042424242424244*G0_1_0_5_2_3 - 0.00138528138528143*G0_1_0_5_2_4 - 0.00419913419913435*G0_1_0_5_2_5 - 0.00406926406926421*G0_1_0_5_3_0 + 0.016406926406927*G0_1_0_5_3_1 - 0.0042424242424244*G0_1_0_5_3_2 + 0.0176623376623383*G0_1_0_5_3_3 + 0.00484848484848501*G0_1_0_5_3_4 + 0.0165367965367971*G0_1_0_5_3_5 - 0.000800865800865824*G0_1_0_5_4_0 + 0.0016450216450217*G0_1_0_5_4_1 - 0.00138528138528143*G0_1_0_5_4_2 + 0.00484848484848501*G0_1_0_5_4_3 + 0.00129870129870134*G0_1_0_5_4_4 + 0.00510822510822526*G0_1_0_5_4_5 - 0.0108658008658012*G0_1_0_5_5_0 + 0.0331601731601744*G0_1_0_5_5_1 - 0.00419913419913435*G0_1_0_5_5_2 + 0.0165367965367971*G0_1_0_5_5_3 + 0.00510822510822526*G0_1_0_5_5_4 + 0.0345454545454557*G0_1_0_5_5_5;
    A[22] = 0.00262987012987022*G0_1_1_0_0_0 - 0.000328282828282839*G0_1_1_0_0_1 + 0.000618686868686889*G0_1_1_0_0_2 + 0.000537518037518054*G0_1_1_0_0_3 + 0.00139610389610394*G0_1_1_0_0_4 + 0.00163419913419919*G0_1_1_0_0_5 - 0.000328282828282839*G0_1_1_0_1_0 - 0.000328282828282839*G0_1_1_0_1_1 + 0.000523989898989916*G0_1_1_0_1_2 + 0.000335497835497846*G0_1_1_0_1_3 + 0.000335497835497846*G0_1_1_0_1_4 - 0.000548340548340566*G0_1_1_0_1_5 + 0.000618686868686889*G0_1_1_0_2_0 + 0.000523989898989916*G0_1_1_0_2_1 - 0.0058531746031748*G0_1_1_0_2_2 - 0.00189393939393946*G0_1_1_0_2_3 - 0.00353535353535365*G0_1_1_0_2_4 - 0.000227272727272736*G0_1_1_0_2_5 + 0.000537518037518054*G0_1_1_0_3_0 + 0.000335497835497846*G0_1_1_0_3_1 - 0.00189393939393946*G0_1_1_0_3_2 - 0.00236652236652244*G0_1_1_0_3_3 - 0.0017460317460318*G0_1_1_0_3_4 - 0.000620490620490641*G0_1_1_0_3_5 + 0.00139610389610394*G0_1_1_0_4_0 + 0.000335497835497846*G0_1_1_0_4_1 - 0.00353535353535366*G0_1_1_0_4_2 - 0.0017460317460318*G0_1_1_0_4_3 - 0.00337662337662349*G0_1_1_0_4_4 - 0.000216450216450224*G0_1_1_0_4_5 + 0.00163419913419919*G0_1_1_0_5_0 - 0.000548340548340566*G0_1_1_0_5_1 - 0.000227272727272736*G0_1_1_0_5_2 - 0.000620490620490641*G0_1_1_0_5_3 - 0.000216450216450224*G0_1_1_0_5_4 + 0.000692640692640719*G0_1_1_0_5_5 - 0.000328282828282839*G0_1_1_1_0_0 - 0.000328282828282839*G0_1_1_1_0_1 + 0.000523989898989916*G0_1_1_1_0_2 + 0.000335497835497846*G0_1_1_1_0_3 + 0.000335497835497846*G0_1_1_1_0_4 - 0.000548340548340566*G0_1_1_1_0_5 - 0.000328282828282839*G0_1_1_1_1_0 + 0.00262987012987022*G0_1_1_1_1_1 + 0.00061868686868689*G0_1_1_1_1_2 + 0.00139610389610394*G0_1_1_1_1_3 + 0.000537518037518055*G0_1_1_1_1_4 + 0.00163419913419919*G0_1_1_1_1_5 + 0.000523989898989916*G0_1_1_1_2_0 + 0.00061868686868689*G0_1_1_1_2_1 - 0.0058531746031748*G0_1_1_1_2_2 - 0.00353535353535366*G0_1_1_1_2_3 - 0.00189393939393946*G0_1_1_1_2_4 - 0.000227272727272736*G0_1_1_1_2_5 + 0.000335497835497846*G0_1_1_1_3_0 + 0.00139610389610394*G0_1_1_1_3_1 - 0.00353535353535366*G0_1_1_1_3_2 - 0.00337662337662349*G0_1_1_1_3_3 - 0.00174603174603181*G0_1_1_1_3_4 - 0.000216450216450224*G0_1_1_1_3_5 + 0.000335497835497846*G0_1_1_1_4_0 + 0.000537518037518055*G0_1_1_1_4_1 - 0.00189393939393946*G0_1_1_1_4_2 - 0.00174603174603181*G0_1_1_1_4_3 - 0.00236652236652245*G0_1_1_1_4_4 - 0.000620490620490642*G0_1_1_1_4_5 - 0.000548340548340566*G0_1_1_1_5_0 + 0.00163419913419919*G0_1_1_1_5_1 - 0.000227272727272736*G0_1_1_1_5_2 - 0.000216450216450224*G0_1_1_1_5_3 - 0.000620490620490642*G0_1_1_1_5_4 + 0.000692640692640716*G0_1_1_1_5_5 + 0.000618686868686889*G0_1_1_2_0_0 + 0.000523989898989916*G0_1_1_2_0_1 - 0.0058531746031748*G0_1_1_2_0_2 - 0.00189393939393946*G0_1_1_2_0_3 - 0.00353535353535365*G0_1_1_2_0_4 - 0.000227272727272736*G0_1_1_2_0_5 + 0.000523989898989916*G0_1_1_2_1_0 + 0.00061868686868689*G0_1_1_2_1_1 - 0.0058531746031748*G0_1_1_2_1_2 - 0.00353535353535366*G0_1_1_2_1_3 - 0.00189393939393946*G0_1_1_2_1_4 - 0.000227272727272736*G0_1_1_2_1_5 - 0.0058531746031748*G0_1_1_2_2_0 - 0.0058531746031748*G0_1_1_2_2_1 + 0.0918019480519512*G0_1_1_2_2_2 + 0.0250541125541134*G0_1_1_2_2_3 + 0.0250541125541134*G0_1_1_2_2_4 + 0.00164141414141421*G0_1_1_2_2_5 - 0.00189393939393946*G0_1_1_2_3_0 - 0.00353535353535366*G0_1_1_2_3_1 + 0.0250541125541134*G0_1_1_2_3_2 + 0.0151515151515157*G0_1_1_2_3_3 + 0.00757575757575784*G0_1_1_2_3_4 + 0.000505050505050528*G0_1_1_2_3_5 - 0.00353535353535366*G0_1_1_2_4_0 - 0.00189393939393946*G0_1_1_2_4_1 + 0.0250541125541134*G0_1_1_2_4_2 + 0.00757575757575784*G0_1_1_2_4_3 + 0.0151515151515157*G0_1_1_2_4_4 + 0.000505050505050527*G0_1_1_2_4_5 - 0.000227272727272736*G0_1_1_2_5_0 - 0.000227272727272736*G0_1_1_2_5_1 + 0.00164141414141421*G0_1_1_2_5_2 + 0.000505050505050528*G0_1_1_2_5_3 + 0.000505050505050527*G0_1_1_2_5_4 - 0.000808080808080834*G0_1_1_2_5_5 + 0.000537518037518054*G0_1_1_3_0_0 + 0.000335497835497846*G0_1_1_3_0_1 - 0.00189393939393946*G0_1_1_3_0_2 - 0.00236652236652244*G0_1_1_3_0_3 - 0.0017460317460318*G0_1_1_3_0_4 - 0.000620490620490641*G0_1_1_3_0_5 + 0.000335497835497846*G0_1_1_3_1_0 + 0.00139610389610394*G0_1_1_3_1_1 - 0.00353535353535366*G0_1_1_3_1_2 - 0.00337662337662349*G0_1_1_3_1_3 - 0.00174603174603181*G0_1_1_3_1_4 - 0.000216450216450224*G0_1_1_3_1_5 - 0.00189393939393946*G0_1_1_3_2_0 - 0.00353535353535366*G0_1_1_3_2_1 + 0.0250541125541134*G0_1_1_3_2_2 + 0.0151515151515157*G0_1_1_3_2_3 + 0.00757575757575784*G0_1_1_3_2_4 + 0.000505050505050528*G0_1_1_3_2_5 - 0.00236652236652244*G0_1_1_3_3_0 - 0.00337662337662349*G0_1_1_3_3_1 + 0.0151515151515157*G0_1_1_3_3_2 + 0.0246753246753255*G0_1_1_3_3_3 + 0.0082251082251085*G0_1_1_3_3_4 + 0.00372294372294385*G0_1_1_3_3_5 - 0.0017460317460318*G0_1_1_3_4_0 - 0.00174603174603181*G0_1_1_3_4_1 + 0.00757575757575784*G0_1_1_3_4_2 + 0.0082251082251085*G0_1_1_3_4_3 + 0.0082251082251085*G0_1_1_3_4_4 + 0.00248196248196257*G0_1_1_3_4_5 - 0.000620490620490641*G0_1_1_3_5_0 - 0.000216450216450224*G0_1_1_3_5_1 + 0.000505050505050528*G0_1_1_3_5_2 + 0.00372294372294385*G0_1_1_3_5_3 + 0.00248196248196257*G0_1_1_3_5_4 + 0.00285714285714295*G0_1_1_3_5_5 + 0.00139610389610394*G0_1_1_4_0_0 + 0.000335497835497846*G0_1_1_4_0_1 - 0.00353535353535366*G0_1_1_4_0_2 - 0.0017460317460318*G0_1_1_4_0_3 - 0.00337662337662349*G0_1_1_4_0_4 - 0.000216450216450224*G0_1_1_4_0_5 + 0.000335497835497846*G0_1_1_4_1_0 + 0.000537518037518055*G0_1_1_4_1_1 - 0.00189393939393946*G0_1_1_4_1_2 - 0.00174603174603181*G0_1_1_4_1_3 - 0.00236652236652245*G0_1_1_4_1_4 - 0.000620490620490642*G0_1_1_4_1_5 - 0.00353535353535366*G0_1_1_4_2_0 - 0.00189393939393946*G0_1_1_4_2_1 + 0.0250541125541134*G0_1_1_4_2_2 + 0.00757575757575784*G0_1_1_4_2_3 + 0.0151515151515157*G0_1_1_4_2_4 + 0.000505050505050527*G0_1_1_4_2_5 - 0.0017460317460318*G0_1_1_4_3_0 - 0.00174603174603181*G0_1_1_4_3_1 + 0.00757575757575784*G0_1_1_4_3_2 + 0.0082251082251085*G0_1_1_4_3_3 + 0.0082251082251085*G0_1_1_4_3_4 + 0.00248196248196257*G0_1_1_4_3_5 - 0.00337662337662349*G0_1_1_4_4_0 - 0.00236652236652245*G0_1_1_4_4_1 + 0.0151515151515157*G0_1_1_4_4_2 + 0.0082251082251085*G0_1_1_4_4_3 + 0.0246753246753255*G0_1_1_4_4_4 + 0.00372294372294385*G0_1_1_4_4_5 - 0.000216450216450224*G0_1_1_4_5_0 - 0.000620490620490642*G0_1_1_4_5_1 + 0.000505050505050527*G0_1_1_4_5_2 + 0.00248196248196257*G0_1_1_4_5_3 + 0.00372294372294385*G0_1_1_4_5_4 + 0.00285714285714295*G0_1_1_4_5_5 + 0.00163419913419919*G0_1_1_5_0_0 - 0.000548340548340566*G0_1_1_5_0_1 - 0.000227272727272736*G0_1_1_5_0_2 - 0.000620490620490641*G0_1_1_5_0_3 - 0.000216450216450224*G0_1_1_5_0_4 + 0.000692640692640719*G0_1_1_5_0_5 - 0.000548340548340566*G0_1_1_5_1_0 + 0.00163419913419919*G0_1_1_5_1_1 - 0.000227272727272736*G0_1_1_5_1_2 - 0.000216450216450224*G0_1_1_5_1_3 - 0.000620490620490642*G0_1_1_5_1_4 + 0.000692640692640716*G0_1_1_5_1_5 - 0.000227272727272736*G0_1_1_5_2_0 - 0.000227272727272736*G0_1_1_5_2_1 + 0.00164141414141421*G0_1_1_5_2_2 + 0.000505050505050528*G0_1_1_5_2_3 + 0.000505050505050527*G0_1_1_5_2_4 - 0.000808080808080834*G0_1_1_5_2_5 - 0.000620490620490641*G0_1_1_5_3_0 - 0.000216450216450224*G0_1_1_5_3_1 + 0.000505050505050528*G0_1_1_5_3_2 + 0.00372294372294385*G0_1_1_5_3_3 + 0.00248196248196257*G0_1_1_5_3_4 + 0.00285714285714295*G0_1_1_5_3_5 - 0.000216450216450224*G0_1_1_5_4_0 - 0.000620490620490642*G0_1_1_5_4_1 + 0.000505050505050527*G0_1_1_5_4_2 + 0.00248196248196257*G0_1_1_5_4_3 + 0.00372294372294385*G0_1_1_5_4_4 + 0.00285714285714295*G0_1_1_5_4_5 + 0.000692640692640719*G0_1_1_5_5_0 + 0.000692640692640716*G0_1_1_5_5_1 - 0.000808080808080834*G0_1_1_5_5_2 + 0.00285714285714295*G0_1_1_5_5_3 + 0.00285714285714295*G0_1_1_5_5_4 + 0.0168831168831174*G0_1_1_5_5_5;
    A[82] = A[22] - 0.00756087662337686*G0_0_1_0_0_0 + 0.000116341991341994*G0_0_1_0_0_2 - 0.000129870129870133*G0_0_1_0_0_3 - 0.000703463203463223*G0_0_1_0_0_4 - 0.000351731601731606*G0_0_1_0_0_5 + 0.00127299783549788*G0_0_1_0_1_1 - 0.000238095238095247*G0_0_1_0_1_4 - 0.000162337662337669*G0_0_1_0_1_5 + 0.000116341991341994*G0_0_1_0_2_0 + 0.000346320346320364*G0_0_1_0_2_2 - 0.000270562770562777*G0_0_1_0_2_3 - 0.000281385281385291*G0_0_1_0_2_5 - 0.000129870129870133*G0_0_1_0_3_0 - 0.000270562770562777*G0_0_1_0_3_2 + 0.000129870129870135*G0_0_1_0_3_3 + 0.000735930735930761*G0_0_1_0_3_4 + 0.000822510822510849*G0_0_1_0_3_5 - 0.000703463203463223*G0_0_1_0_4_0 - 0.000238095238095247*G0_0_1_0_4_1 + 0.00073593073593076*G0_0_1_0_4_3 + 0.00380952380952394*G0_0_1_0_4_4 + 0.00103896103896107*G0_0_1_0_4_5 - 0.000351731601731606*G0_0_1_0_5_0 - 0.000162337662337669*G0_0_1_0_5_1 - 0.000281385281385291*G0_0_1_0_5_2 + 0.000822510822510849*G0_0_1_0_5_3 + 0.00103896103896107*G0_0_1_0_5_4 + 0.00339826839826852*G0_0_1_0_5_5 + 0.00127299783549788*G0_0_1_1_0_1 - 0.000238095238095247*G0_0_1_1_0_4 - 0.000162337662337669*G0_0_1_1_0_5 + 0.00127299783549788*G0_0_1_1_1_0 - 0.020150162337663*G0_0_1_1_1_1 + 0.000735930735930759*G0_0_1_1_1_2 - 0.00213744588744595*G0_0_1_1_1_3 - 0.000243506493506499*G0_0_1_1_1_4 - 0.0049242424242426*G0_0_1_1_1_5 + 0.000735930735930759*G0_0_1_1_2_1 - 0.000248917748917752*G0_0_1_1_2_2 - 0.000844155844155871*G0_0_1_1_2_3 - 0.000183982683982689*G0_0_1_1_2_4 - 0.00213744588744595*G0_0_1_1_3_1 - 0.000844155844155871*G0_0_1_1_3_2 + 0.00203463203463211*G0_0_1_1_3_3 + 0.000562770562770583*G0_0_1_1_3_4 - 0.000238095238095247*G0_0_1_1_4_0 - 0.000243506493506499*G0_0_1_1_4_1 - 0.000183982683982689*G0_0_1_1_4_2 + 0.000562770562770583*G0_0_1_1_4_3 + 0.000519480519480538*G0_0_1_1_4_4 + 0.000476190476190493*G0_0_1_1_4_5 - 0.000162337662337669*G0_0_1_1_5_0 - 0.0049242424242426*G0_0_1_1_5_1 + 0.000476190476190493*G0_0_1_1_5_4 - 0.00313852813852825*G0_0_1_1_5_5 + 0.000116341991341994*G0_0_1_2_0_0 + 0.000346320346320364*G0_0_1_2_0_2 - 0.000270562770562777*G0_0_1_2_0_3 - 0.000281385281385291*G0_0_1_2_0_5 + 0.000735930735930759*G0_0_1_2_1_1 - 0.000248917748917752*G0_0_1_2_1_2 - 0.000844155844155871*G0_0_1_2_1_3 - 0.000183982683982689*G0_0_1_2_1_4 + 0.000346320346320364*G0_0_1_2_2_0 - 0.000248917748917752*G0_0_1_2_2_1 + 0.0015692640692641*G0_0_1_2_2_3 - 0.00156926406926415*G0_0_1_2_2_4 - 0.000270562770562777*G0_0_1_2_3_0 - 0.000844155844155871*G0_0_1_2_3_1 + 0.0015692640692641*G0_0_1_2_3_2 + 0.00147186147186151*G0_0_1_2_3_3 + 0.000909090909090932*G0_0_1_2_3_4 + 0.00073593073593076*G0_0_1_2_3_5 - 0.000183982683982689*G0_0_1_2_4_1 - 0.00156926406926415*G0_0_1_2_4_2 + 0.000909090909090932*G0_0_1_2_4_3 - 0.00329004329004341*G0_0_1_2_4_4 + 0.000562770562770581*G0_0_1_2_4_5 - 0.000281385281385291*G0_0_1_2_5_0 + 0.00073593073593076*G0_0_1_2_5_3 + 0.000562770562770581*G0_0_1_2_5_4 - 0.000389610389610402*G0_0_1_2_5_5 - 0.000129870129870133*G0_0_1_3_0_0 - 0.000270562770562777*G0_0_1_3_0_2 + 0.000129870129870135*G0_0_1_3_0_3 + 0.000735930735930761*G0_0_1_3_0_4 + 0.000822510822510849*G0_0_1_3_0_5 - 0.00213744588744595*G0_0_1_3_1_1 - 0.000844155844155871*G0_0_1_3_1_2 + 0.00203463203463211*G0_0_1_3_1_3 + 0.000562770562770583*G0_0_1_3_1_4 - 0.000270562770562777*G0_0_1_3_2_0 - 0.000844155844155871*G0_0_1_3_2_1 + 0.0015692640692641*G0_0_1_3_2_2 + 0.00147186147186151*G0_0_1_3_2_3 + 0.000909090909090932*G0_0_1_3_2_4 + 0.00073593073593076*G0_0_1_3_2_5 + 0.000129870129870135*G0_0_1_3_3_0 + 0.00203463203463211*G0_0_1_3_3_1 + 0.00147186147186151*G0_0_1_3_3_2 + 0.0109090909090913*G0_0_1_3_3_3 - 0.00138528138528143*G0_0_1_3_3_4 - 0.00173160173160178*G0_0_1_3_3_5 + 0.000735930735930761*G0_0_1_3_4_0 + 0.000562770562770583*G0_0_1_3_4_1 + 0.000909090909090932*G0_0_1_3_4_2 - 0.00138528138528143*G0_0_1_3_4_3 - 0.0025108225108226*G0_0_1_3_4_4 - 0.00259740259740268*G0_0_1_3_4_5 + 0.000822510822510849*G0_0_1_3_5_0 + 0.00073593073593076*G0_0_1_3_5_2 - 0.00173160173160178*G0_0_1_3_5_3 - 0.00259740259740268*G0_0_1_3_5_4 - 0.000865800865800898*G0_0_1_3_5_5 - 0.000703463203463223*G0_0_1_4_0_0 - 0.000238095238095247*G0_0_1_4_0_1 + 0.000735930735930761*G0_0_1_4_0_3 + 0.00380952380952394*G0_0_1_4_0_4 + 0.00103896103896107*G0_0_1_4_0_5 - 0.000238095238095247*G0_0_1_4_1_0 - 0.000243506493506499*G0_0_1_4_1_1 - 0.000183982683982689*G0_0_1_4_1_2 + 0.000562770562770583*G0_0_1_4_1_3 + 0.000519480519480538*G0_0_1_4_1_4 + 0.000476190476190493*G0_0_1_4_1_5 - 0.000183982683982689*G0_0_1_4_2_1 - 0.00156926406926415*G0_0_1_4_2_2 + 0.000909090909090932*G0_0_1_4_2_3 - 0.00329004329004341*G0_0_1_4_2_4 + 0.000562770562770581*G0_0_1_4_2_5 + 0.000735930735930761*G0_0_1_4_3_0 + 0.000562770562770583*G0_0_1_4_3_1 + 0.000909090909090932*G0_0_1_4_3_2 - 0.00138528138528143*G0_0_1_4_3_3 - 0.0025108225108226*G0_0_1_4_3_4 - 0.00259740259740268*G0_0_1_4_3_5 + 0.00380952380952394*G0_0_1_4_4_0 + 0.000519480519480538*G0_0_1_4_4_1 - 0.00329004329004342*G0_0_1_4_4_2 - 0.0025108225108226*G0_0_1_4_4_3 + 0.000779220779220778*G0_0_1_4_4_4 - 0.00216450216450224*G0_0_1_4_4_5 + 0.00103896103896107*G0_0_1_4_5_0 + 0.000476190476190493*G0_0_1_4_5_1 + 0.000562770562770581*G0_0_1_4_5_2 - 0.00259740259740268*G0_0_1_4_5_3 - 0.00216450216450224*G0_0_1_4_5_4 - 0.000173160173160184*G0_0_1_4_5_5 - 0.000351731601731606*G0_0_1_5_0_0 - 0.000162337662337669*G0_0_1_5_0_1 - 0.000281385281385291*G0_0_1_5_0_2 + 0.000822510822510849*G0_0_1_5_0_3 + 0.00103896103896107*G0_0_1_5_0_4 + 0.00339826839826852*G0_0_1_5_0_5 - 0.000162337662337669*G0_0_1_5_1_0 - 0.0049242424242426*G0_0_1_5_1_1 + 0.000476190476190493*G0_0_1_5_1_4 - 0.00313852813852824*G0_0_1_5_1_5 - 0.000281385281385291*G0_0_1_5_2_0 + 0.00073593073593076*G0_0_1_5_2_3 + 0.000562770562770581*G0_0_1_5_2_4 - 0.000389610389610402*G0_0_1_5_2_5 + 0.000822510822510849*G0_0_1_5_3_0 + 0.00073593073593076*G0_0_1_5_3_2 - 0.00173160173160178*G0_0_1_5_3_3 - 0.00259740259740268*G0_0_1_5_3_4 - 0.000865800865800898*G0_0_1_5_3_5 + 0.00103896103896107*G0_0_1_5_4_0 + 0.000476190476190493*G0_0_1_5_4_1 + 0.000562770562770581*G0_0_1_5_4_2 - 0.00259740259740268*G0_0_1_5_4_3 - 0.00216450216450224*G0_0_1_5_4_4 - 0.000173160173160184*G0_0_1_5_4_5 + 0.00339826839826852*G0_0_1_5_5_0 - 0.00313852813852824*G0_0_1_5_5_1 - 0.000389610389610402*G0_0_1_5_5_2 - 0.000865800865800898*G0_0_1_5_5_3 - 0.000173160173160184*G0_0_1_5_5_4 + 0.0397402597402611*G0_0_1_5_5_5 - 0.00183035714285721*G0_1_1_0_0_0 - 0.000134379509379512*G0_1_1_0_0_1 - 0.000584866522366542*G0_1_1_0_0_2 - 0.000348124098124109*G0_1_1_0_0_3 - 0.00119047619047623*G0_1_1_0_0_4 - 0.0015963203463204*G0_1_1_0_0_5 - 0.000134379509379512*G0_1_1_0_1_0 + 0.0023886183261184*G0_1_1_0_1_1 - 0.000537518037518055*G0_1_1_0_1_2 - 0.000221861471861479*G0_1_1_0_1_4 + 0.00226911976911984*G0_1_1_0_1_5 - 0.000584866522366542*G0_1_1_0_2_0 - 0.000537518037518055*G0_1_1_0_2_1 + 0.00543650793650812*G0_1_1_0_2_2 + 0.00185064935064941*G0_1_1_0_2_3 + 0.00330808080808092*G0_1_1_0_2_4 + 0.000135281385281392*G0_1_1_0_2_5 - 0.000348124098124109*G0_1_1_0_3_0 + 0.00185064935064941*G0_1_1_0_3_2 + 0.000591630591630609*G0_1_1_0_3_3 + 0.00113997113997118*G0_1_1_0_3_4 + 0.000425685425685439*G0_1_1_0_3_5 - 0.00119047619047623*G0_1_1_0_4_0 - 0.000221861471861479*G0_1_1_0_4_1 + 0.00330808080808092*G0_1_1_0_4_2 + 0.00113997113997118*G0_1_1_0_4_3 + 0.00268398268398277*G0_1_1_0_4_4 + 0.000173160173160177*G0_1_1_0_4_5 - 0.0015963203463204*G0_1_1_0_5_0 + 0.00226911976911984*G0_1_1_0_5_1 + 0.000135281385281392*G0_1_1_0_5_2 + 0.000425685425685439*G0_1_1_0_5_3 + 0.000173160173160177*G0_1_1_0_5_4 + 0.00287878787878796*G0_1_1_0_5_5 - 0.000134379509379512*G0_1_1_1_0_0 + 0.0023886183261184*G0_1_1_1_0_1 - 0.000537518037518055*G0_1_1_1_0_2 - 0.000221861471861479*G0_1_1_1_0_4 + 0.00226911976911984*G0_1_1_1_0_5 + 0.0023886183261184*G0_1_1_1_1_0 - 0.0278733766233776*G0_1_1_1_1_1 + 0.00034586940836942*G0_1_1_1_1_2 - 0.00415584415584429*G0_1_1_1_1_3 - 0.000802669552669576*G0_1_1_1_1_4 - 0.0112121212121216*G0_1_1_1_1_5 - 0.000537518037518055*G0_1_1_1_2_0 + 0.00034586940836942*G0_1_1_1_2_1 + 0.00534181096681115*G0_1_1_1_2_2 + 0.00272366522366532*G0_1_1_1_2_3 + 0.00156926406926412*G0_1_1_1_2_4 + 0.000611471861471883*G0_1_1_1_2_5 - 0.00415584415584429*G0_1_1_1_3_1 + 0.00272366522366532*G0_1_1_1_3_2 + 0.00536796536796556*G0_1_1_1_3_3 + 0.00170274170274176*G0_1_1_1_3_4 - 0.00112554112554116*G0_1_1_1_3_5 - 0.000221861471861479*G0_1_1_1_4_0 - 0.000802669552669576*G0_1_1_1_4_1 + 0.00156926406926412*G0_1_1_1_4_2 + 0.00170274170274176*G0_1_1_1_4_3 + 0.00240981240981249*G0_1_1_1_4_4 + 0.000382395382395398*G0_1_1_1_4_5 + 0.00226911976911984*G0_1_1_1_5_0 - 0.0112121212121216*G0_1_1_1_5_1 + 0.000611471861471883*G0_1_1_1_5_2 - 0.00112554112554116*G0_1_1_1_5_3 + 0.000382395382395398*G0_1_1_1_5_4 - 0.0103896103896107*G0_1_1_1_5_5 - 0.000584866522366542*G0_1_1_2_0_0 - 0.000537518037518055*G0_1_1_2_0_1 + 0.00543650793650812*G0_1_1_2_0_2 + 0.00185064935064941*G0_1_1_2_0_3 + 0.00330808080808092*G0_1_1_2_0_4 + 0.000135281385281392*G0_1_1_2_0_5 - 0.000537518037518055*G0_1_1_2_1_0 + 0.00034586940836942*G0_1_1_2_1_1 + 0.00534181096681115*G0_1_1_2_1_2 + 0.00272366522366532*G0_1_1_2_1_3 + 0.00156926406926412*G0_1_1_2_1_4 + 0.000611471861471883*G0_1_1_2_1_5 + 0.00543650793650812*G0_1_1_2_2_0 + 0.00534181096681115*G0_1_1_2_2_1 - 0.0874594155844187*G0_1_1_2_2_2 - 0.0222402597402605*G0_1_1_2_2_3 - 0.0234848484848493*G0_1_1_2_2_4 - 0.00140331890331897*G0_1_1_2_2_5 + 0.00185064935064941*G0_1_1_2_3_0 + 0.00272366522366532*G0_1_1_2_3_1 - 0.0222402597402605*G0_1_1_2_3_2 - 0.0156709956709962*G0_1_1_2_3_3 - 0.00683982683982708*G0_1_1_2_3_4 - 0.000894660894660932*G0_1_1_2_3_5 + 0.00330808080808092*G0_1_1_2_4_0 + 0.00156926406926412*G0_1_1_2_4_1 - 0.0234848484848493*G0_1_1_2_4_2 - 0.00683982683982708*G0_1_1_2_4_3 - 0.013506493506494*G0_1_1_2_4_4 - 0.000331890331890349*G0_1_1_2_4_5 + 0.000135281385281392*G0_1_1_2_5_0 + 0.000611471861471883*G0_1_1_2_5_1 - 0.00140331890331897*G0_1_1_2_5_2 - 0.000894660894660932*G0_1_1_2_5_3 - 0.000331890331890349*G0_1_1_2_5_4 + 0.00156565656565662*G0_1_1_2_5_5 - 0.000348124098124109*G0_1_1_3_0_0 + 0.00185064935064941*G0_1_1_3_0_2 + 0.00059163059163061*G0_1_1_3_0_3 + 0.00113997113997118*G0_1_1_3_0_4 + 0.000425685425685439*G0_1_1_3_0_5 - 0.00415584415584429*G0_1_1_3_1_1 + 0.00272366522366532*G0_1_1_3_1_2 + 0.00536796536796556*G0_1_1_3_1_3 + 0.00170274170274176*G0_1_1_3_1_4 - 0.00112554112554116*G0_1_1_3_1_5 + 0.00185064935064941*G0_1_1_3_2_0 + 0.00272366522366532*G0_1_1_3_2_1 - 0.0222402597402605*G0_1_1_3_2_2 - 0.0156709956709962*G0_1_1_3_2_3 - 0.00683982683982708*G0_1_1_3_2_4 - 0.000894660894660932*G0_1_1_3_2_5 + 0.00059163059163061*G0_1_1_3_3_0 + 0.00536796536796556*G0_1_1_3_3_1 - 0.0156709956709962*G0_1_1_3_3_2 - 0.0023376623376624*G0_1_1_3_3_3 - 0.00458874458874474*G0_1_1_3_3_4 + 0.000606060606060629*G0_1_1_3_3_5 + 0.00113997113997118*G0_1_1_3_4_0 + 0.00170274170274176*G0_1_1_3_4_1 - 0.00683982683982708*G0_1_1_3_4_2 - 0.00458874458874474*G0_1_1_3_4_3 - 0.00709956709956735*G0_1_1_3_4_4 - 0.00161616161616167*G0_1_1_3_4_5 + 0.000425685425685438*G0_1_1_3_5_0 - 0.00112554112554116*G0_1_1_3_5_1 - 0.000894660894660932*G0_1_1_3_5_2 + 0.000606060606060629*G0_1_1_3_5_3 - 0.00161616161616167*G0_1_1_3_5_4 - 0.00398268398268411*G0_1_1_3_5_5 - 0.00119047619047623*G0_1_1_4_0_0 - 0.000221861471861479*G0_1_1_4_0_1 + 0.00330808080808092*G0_1_1_4_0_2 + 0.00113997113997118*G0_1_1_4_0_3 + 0.00268398268398277*G0_1_1_4_0_4 + 0.000173160173160177*G0_1_1_4_0_5 - 0.000221861471861479*G0_1_1_4_1_0 - 0.000802669552669576*G0_1_1_4_1_1 + 0.00156926406926412*G0_1_1_4_1_2 + 0.00170274170274176*G0_1_1_4_1_3 + 0.00240981240981249*G0_1_1_4_1_4 + 0.000382395382395398*G0_1_1_4_1_5 + 0.00330808080808092*G0_1_1_4_2_0 + 0.00156926406926412*G0_1_1_4_2_1 - 0.0234848484848493*G0_1_1_4_2_2 - 0.00683982683982708*G0_1_1_4_2_3 - 0.013506493506494*G0_1_1_4_2_4 - 0.000331890331890349*G0_1_1_4_2_5 + 0.00113997113997118*G0_1_1_4_3_0 + 0.00170274170274176*G0_1_1_4_3_1 - 0.00683982683982708*G0_1_1_4_3_2 - 0.00458874458874474*G0_1_1_4_3_3 - 0.00709956709956735*G0_1_1_4_3_4 - 0.00161616161616167*G0_1_1_4_3_5 + 0.00268398268398277*G0_1_1_4_4_0 + 0.00240981240981249*G0_1_1_4_4_1 - 0.013506493506494*G0_1_1_4_4_2 - 0.00709956709956735*G0_1_1_4_4_3 - 0.0249350649350658*G0_1_1_4_4_4 - 0.0041558441558443*G0_1_1_4_4_5 + 0.000173160173160177*G0_1_1_4_5_0 + 0.000382395382395398*G0_1_1_4_5_1 - 0.000331890331890349*G0_1_1_4_5_2 - 0.00161616161616167*G0_1_1_4_5_3 - 0.0041558441558443*G0_1_1_4_5_4 - 0.00389610389610402*G0_1_1_4_5_5 - 0.0015963203463204*G0_1_1_5_0_0 + 0.00226911976911984*G0_1_1_5_0_1 + 0.000135281385281392*G0_1_1_5_0_2 + 0.000425685425685439*G0_1_1_5_0_3 + 0.000173160173160177*G0_1_1_5_0_4 + 0.00287878787878796*G0_1_1_5_0_5 + 0.00226911976911984*G0_1_1_5_1_0 - 0.0112121212121216*G0_1_1_5_1_1 + 0.000611471861471883*G0_1_1_5_1_2 - 0.00112554112554116*G0_1_1_5_1_3 + 0.000382395382395398*G0_1_1_5_1_4 - 0.0103896103896107*G0_1_1_5_1_5 + 0.000135281385281392*G0_1_1_5_2_0 + 0.000611471861471883*G0_1_1_5_2_1 - 0.00140331890331897*G0_1_1_5_2_2 - 0.000894660894660932*G0_1_1_5_2_3 - 0.000331890331890349*G0_1_1_5_2_4 + 0.00156565656565662*G0_1_1_5_2_5 + 0.000425685425685439*G0_1_1_5_3_0 - 0.00112554112554116*G0_1_1_5_3_1 - 0.000894660894660932*G0_1_1_5_3_2 + 0.00060606060606063*G0_1_1_5_3_3 - 0.00161616161616167*G0_1_1_5_3_4 - 0.00398268398268411*G0_1_1_5_3_5 + 0.000173160173160177*G0_1_1_5_4_0 + 0.000382395382395398*G0_1_1_5_4_1 - 0.000331890331890349*G0_1_1_5_4_2 - 0.00161616161616167*G0_1_1_5_4_3 - 0.0041558441558443*G0_1_1_5_4_4 - 0.00389610389610402*G0_1_1_5_4_5 + 0.00287878787878796*G0_1_1_5_5_0 - 0.0103896103896107*G0_1_1_5_5_1 + 0.00156565656565662*G0_1_1_5_5_2 - 0.00398268398268411*G0_1_1_5_5_3 - 0.00389610389610402*G0_1_1_5_5_4 - 0.0436363636363651*G0_1_1_5_5_5;
    A[32] = -A[82] - 0.00748376623376648*G0_0_1_0_0_0 + 0.000162337662337666*G0_0_1_0_0_1 - 0.000533008658008677*G0_0_1_0_0_2 - 0.00085497835497838*G0_0_1_0_0_3 - 0.00160173160173165*G0_0_1_0_0_4 - 0.000670995670995687*G0_0_1_0_0_5 + 0.000162337662337666*G0_0_1_0_1_0 + 0.00119047619047623*G0_0_1_0_1_1 - 0.000201569264069271*G0_0_1_0_1_2 - 0.000681818181818205*G0_0_1_0_1_4 - 0.000487012987013004*G0_0_1_0_1_5 - 0.000533008658008677*G0_0_1_0_2_0 - 0.000201569264069271*G0_0_1_0_2_1 + 0.00531114718614737*G0_0_1_0_2_2 + 0.00305194805194816*G0_0_1_0_2_4 - 0.000508658008658024*G0_0_1_0_2_5 - 0.00085497835497838*G0_0_1_0_3_0 + 0.00385281385281397*G0_0_1_0_3_3 + 0.00307359307359317*G0_0_1_0_3_4 + 0.00272727272727282*G0_0_1_0_3_5 - 0.00160173160173165*G0_0_1_0_4_0 - 0.000681818181818205*G0_0_1_0_4_1 + 0.00305194805194816*G0_0_1_0_4_2 + 0.00307359307359317*G0_0_1_0_4_3 + 0.0105627705627709*G0_0_1_0_4_4 + 0.00238095238095246*G0_0_1_0_4_5 - 0.000670995670995687*G0_0_1_0_5_0 - 0.000487012987013004*G0_0_1_0_5_1 - 0.000508658008658025*G0_0_1_0_5_2 + 0.00272727272727282*G0_0_1_0_5_3 + 0.00238095238095246*G0_0_1_0_5_4 + 0.00441558441558458*G0_0_1_0_5_5 + 0.000162337662337666*G0_0_1_1_0_0 + 0.00119047619047623*G0_0_1_1_0_1 - 0.000201569264069271*G0_0_1_1_0_2 - 0.000681818181818204*G0_0_1_1_0_4 - 0.000487012987013004*G0_0_1_1_0_5 + 0.00119047619047623*G0_0_1_1_1_0 - 0.0183441558441565*G0_0_1_1_1_1 + 0.000703463203463227*G0_0_1_1_1_2 - 0.00284090909090919*G0_0_1_1_1_3 - 0.000514069264069279*G0_0_1_1_1_4 - 0.00430194805194821*G0_0_1_1_1_5 - 0.000201569264069271*G0_0_1_1_2_0 + 0.000703463203463227*G0_0_1_1_2_1 + 0.00252435064935074*G0_0_1_1_2_2 + 0.000974025974026008*G0_0_1_1_2_4 - 0.00284090909090919*G0_0_1_1_3_1 - 0.00367965367965381*G0_0_1_1_3_3 + 0.00108225108225112*G0_0_1_1_3_4 + 0.000108225108225108*G0_0_1_1_3_5 - 0.000681818181818205*G0_0_1_1_4_0 - 0.000514069264069279*G0_0_1_1_4_1 + 0.000974025974026008*G0_0_1_1_4_2 + 0.00108225108225112*G0_0_1_1_4_3 + 0.00216450216450223*G0_0_1_1_4_4 + 0.00108225108225112*G0_0_1_1_4_5 - 0.000487012987013004*G0_0_1_1_5_0 - 0.00430194805194821*G0_0_1_1_5_1 + 0.000108225108225108*G0_0_1_1_5_3 + 0.00108225108225112*G0_0_1_1_5_4 - 0.00173160173160179*G0_0_1_1_5_5 - 0.000533008658008677*G0_0_1_2_0_0 - 0.000201569264069271*G0_0_1_2_0_1 + 0.00531114718614737*G0_0_1_2_0_2 + 0.00305194805194816*G0_0_1_2_0_4 - 0.000508658008658025*G0_0_1_2_0_5 - 0.000201569264069271*G0_0_1_2_1_0 + 0.000703463203463227*G0_0_1_2_1_1 + 0.00252435064935074*G0_0_1_2_1_2 + 0.000974025974026008*G0_0_1_2_1_4 + 0.00531114718614737*G0_0_1_2_2_0 + 0.00252435064935074*G0_0_1_2_2_1 - 0.0668019480519504*G0_0_1_2_2_2 - 0.010119047619048*G0_0_1_2_2_3 - 0.0233225108225116*G0_0_1_2_2_4 - 0.0013419913419914*G0_0_1_2_2_5 - 0.010119047619048*G0_0_1_2_3_2 + 0.00753246753246777*G0_0_1_2_3_3 - 0.00190476190476198*G0_0_1_2_3_4 + 0.00272727272727282*G0_0_1_2_3_5 + 0.00305194805194815*G0_0_1_2_4_0 + 0.000974025974026008*G0_0_1_2_4_1 - 0.0233225108225116*G0_0_1_2_4_2 - 0.00190476190476198*G0_0_1_2_4_3 - 0.0206060606060613*G0_0_1_2_4_4 + 0.000735930735930755*G0_0_1_2_4_5 - 0.000508658008658024*G0_0_1_2_5_0 - 0.0013419913419914*G0_0_1_2_5_2 + 0.00272727272727282*G0_0_1_2_5_3 + 0.000735930735930755*G0_0_1_2_5_4 + 0.000735930735930762*G0_0_1_2_5_5 - 0.00085497835497838*G0_0_1_3_0_0 + 0.00385281385281397*G0_0_1_3_0_3 + 0.00307359307359317*G0_0_1_3_0_4 + 0.00272727272727282*G0_0_1_3_0_5 - 0.00284090909090919*G0_0_1_3_1_1 - 0.00367965367965381*G0_0_1_3_1_3 + 0.00108225108225112*G0_0_1_3_1_4 + 0.000108225108225108*G0_0_1_3_1_5 - 0.010119047619048*G0_0_1_3_2_2 + 0.00753246753246777*G0_0_1_3_2_3 - 0.00190476190476198*G0_0_1_3_2_4 + 0.00272727272727282*G0_0_1_3_2_5 + 0.00385281385281397*G0_0_1_3_3_0 - 0.00367965367965381*G0_0_1_3_3_1 + 0.00753246753246777*G0_0_1_3_3_2 - 0.0161038961038966*G0_0_1_3_3_3 - 0.00987012987013019*G0_0_1_3_3_4 - 0.0131601731601736*G0_0_1_3_3_5 + 0.00307359307359317*G0_0_1_3_4_0 + 0.00108225108225112*G0_0_1_3_4_1 - 0.00190476190476198*G0_0_1_3_4_2 - 0.00987012987013019*G0_0_1_3_4_3 - 0.0104761904761908*G0_0_1_3_4_4 - 0.00761904761904787*G0_0_1_3_4_5 + 0.00272727272727282*G0_0_1_3_5_0 + 0.000108225108225108*G0_0_1_3_5_1 + 0.00272727272727282*G0_0_1_3_5_2 - 0.0131601731601736*G0_0_1_3_5_3 - 0.00761904761904787*G0_0_1_3_5_4 - 0.00692640692640716*G0_0_1_3_5_5 - 0.00160173160173165*G0_0_1_4_0_0 - 0.000681818181818205*G0_0_1_4_0_1 + 0.00305194805194816*G0_0_1_4_0_2 + 0.00307359307359317*G0_0_1_4_0_3 + 0.0105627705627709*G0_0_1_4_0_4 + 0.00238095238095246*G0_0_1_4_0_5 - 0.000681818181818204*G0_0_1_4_1_0 - 0.000514069264069279*G0_0_1_4_1_1 + 0.000974025974026008*G0_0_1_4_1_2 + 0.00108225108225112*G0_0_1_4_1_3 + 0.00216450216450223*G0_0_1_4_1_4 + 0.00108225108225112*G0_0_1_4_1_5 + 0.00305194805194816*G0_0_1_4_2_0 + 0.000974025974026008*G0_0_1_4_2_1 - 0.0233225108225116*G0_0_1_4_2_2 - 0.00190476190476198*G0_0_1_4_2_3 - 0.0206060606060613*G0_0_1_4_2_4 + 0.000735930735930755*G0_0_1_4_2_5 + 0.00307359307359317*G0_0_1_4_3_0 + 0.00108225108225112*G0_0_1_4_3_1 - 0.00190476190476198*G0_0_1_4_3_2 - 0.00987012987013019*G0_0_1_4_3_3 - 0.0104761904761908*G0_0_1_4_3_4 - 0.00761904761904787*G0_0_1_4_3_5 + 0.0105627705627709*G0_0_1_4_4_0 + 0.00216450216450223*G0_0_1_4_4_1 - 0.0206060606060613*G0_0_1_4_4_2 - 0.0104761904761908*G0_0_1_4_4_3 - 0.0215584415584423*G0_0_1_4_4_4 - 0.005800865800866*G0_0_1_4_4_5 + 0.00238095238095246*G0_0_1_4_5_0 + 0.00108225108225112*G0_0_1_4_5_1 + 0.000735930735930755*G0_0_1_4_5_2 - 0.00761904761904787*G0_0_1_4_5_3 - 0.005800865800866*G0_0_1_4_5_4 - 0.00363636363636376*G0_0_1_4_5_5 - 0.000670995670995687*G0_0_1_5_0_0 - 0.000487012987013004*G0_0_1_5_0_1 - 0.000508658008658025*G0_0_1_5_0_2 + 0.00272727272727282*G0_0_1_5_0_3 + 0.00238095238095246*G0_0_1_5_0_4 + 0.00441558441558458*G0_0_1_5_0_5 - 0.000487012987013004*G0_0_1_5_1_0 - 0.00430194805194821*G0_0_1_5_1_1 + 0.000108225108225109*G0_0_1_5_1_3 + 0.00108225108225112*G0_0_1_5_1_4 - 0.00173160173160179*G0_0_1_5_1_5 - 0.000508658008658024*G0_0_1_5_2_0 - 0.0013419913419914*G0_0_1_5_2_2 + 0.00272727272727282*G0_0_1_5_2_3 + 0.000735930735930755*G0_0_1_5_2_4 + 0.000735930735930762*G0_0_1_5_2_5 + 0.00272727272727282*G0_0_1_5_3_0 + 0.000108225108225108*G0_0_1_5_3_1 + 0.00272727272727282*G0_0_1_5_3_2 - 0.0131601731601736*G0_0_1_5_3_3 - 0.00761904761904787*G0_0_1_5_3_4 - 0.00692640692640716*G0_0_1_5_3_5 + 0.00238095238095246*G0_0_1_5_4_0 + 0.00108225108225112*G0_0_1_5_4_1 + 0.000735930735930755*G0_0_1_5_4_2 - 0.00761904761904787*G0_0_1_5_4_3 - 0.005800865800866*G0_0_1_5_4_4 - 0.00363636363636376*G0_0_1_5_4_5 + 0.00441558441558458*G0_0_1_5_5_0 - 0.00173160173160179*G0_0_1_5_5_1 + 0.000735930735930762*G0_0_1_5_5_2 - 0.00692640692640716*G0_0_1_5_5_3 - 0.00363636363636376*G0_0_1_5_5_4 + 0.0400000000000013*G0_0_1_5_5_5;
    A[72] = -A[82] + 0.0125892857142861*G0_0_1_0_0_0 - 0.00121482683982688*G0_0_1_0_0_1 - 0.000619588744588766*G0_0_1_0_0_2 + 0.000113636363636366*G0_0_1_0_0_3 + 0.00143398268398273*G0_0_1_0_0_4 + 0.00457251082251098*G0_0_1_0_0_5 - 0.00121482683982688*G0_0_1_0_1_0 + 0.00121482683982688*G0_0_1_0_1_1 + 0.000200216450216456*G0_0_1_0_1_3 - 0.000200216450216457*G0_0_1_0_1_4 - 0.000619588744588766*G0_0_1_0_2_0 + 0.00059523809523812*G0_0_1_0_2_2 + 0.000844155844155875*G0_0_1_0_2_4 - 0.000286796536796546*G0_0_1_0_2_5 + 0.000113636363636366*G0_0_1_0_3_0 + 0.000200216450216456*G0_0_1_0_3_1 - 0.000389610389610401*G0_0_1_0_3_3 + 0.000173160173160179*G0_0_1_0_3_4 + 0.000346320346320356*G0_0_1_0_3_5 + 0.00143398268398273*G0_0_1_0_4_0 - 0.000200216450216457*G0_0_1_0_4_1 + 0.000844155844155875*G0_0_1_0_4_2 + 0.000173160173160179*G0_0_1_0_4_3 + 0.00177489177489184*G0_0_1_0_4_4 + 0.000974025974026006*G0_0_1_0_4_5 + 0.00457251082251098*G0_0_1_0_5_0 - 0.000286796536796546*G0_0_1_0_5_2 + 0.000346320346320356*G0_0_1_0_5_3 + 0.000974025974026006*G0_0_1_0_5_4 + 0.00653679653679676*G0_0_1_0_5_5 - 0.00121482683982688*G0_0_1_1_0_0 + 0.00121482683982688*G0_0_1_1_0_1 + 0.000200216450216456*G0_0_1_1_0_3 - 0.000200216450216457*G0_0_1_1_0_4 + 0.00121482683982688*G0_0_1_1_1_0 - 0.0125892857142861*G0_0_1_1_1_1 + 0.000619588744588765*G0_0_1_1_1_2 - 0.00143398268398273*G0_0_1_1_1_3 - 0.000113636363636366*G0_0_1_1_1_4 - 0.00457251082251099*G0_0_1_1_1_5 + 0.000619588744588765*G0_0_1_1_2_1 - 0.000595238095238112*G0_0_1_1_2_2 - 0.000844155844155871*G0_0_1_1_2_3 + 0.000286796536796547*G0_0_1_1_2_5 + 0.000200216450216456*G0_0_1_1_3_0 - 0.00143398268398273*G0_0_1_1_3_1 - 0.000844155844155872*G0_0_1_1_3_2 - 0.00177489177489183*G0_0_1_1_3_3 - 0.000173160173160178*G0_0_1_1_3_4 - 0.000974025974026007*G0_0_1_1_3_5 - 0.000200216450216457*G0_0_1_1_4_0 - 0.000113636363636366*G0_0_1_1_4_1 - 0.000173160173160177*G0_0_1_1_4_3 + 0.000389610389610403*G0_0_1_1_4_4 - 0.000346320346320356*G0_0_1_1_4_5 - 0.00457251082251099*G0_0_1_1_5_1 + 0.000286796536796547*G0_0_1_1_5_2 - 0.000974025974026007*G0_0_1_1_5_3 - 0.000346320346320357*G0_0_1_1_5_4 - 0.00653679653679676*G0_0_1_1_5_5 - 0.000619588744588766*G0_0_1_2_0_0 + 0.00059523809523812*G0_0_1_2_0_2 + 0.000844155844155875*G0_0_1_2_0_4 - 0.000286796536796546*G0_0_1_2_0_5 + 0.000619588744588765*G0_0_1_2_1_1 - 0.000595238095238112*G0_0_1_2_1_2 - 0.000844155844155872*G0_0_1_2_1_3 + 0.000286796536796547*G0_0_1_2_1_5 + 0.00059523809523812*G0_0_1_2_2_0 - 0.000595238095238112*G0_0_1_2_2_1 + 0.00313852813852823*G0_0_1_2_2_3 - 0.00313852813852826*G0_0_1_2_2_4 - 0.000844155844155871*G0_0_1_2_3_1 + 0.00313852813852823*G0_0_1_2_3_2 + 0.00476190476190491*G0_0_1_2_3_3 + 0.000173160173160179*G0_0_1_2_3_5 + 0.000844155844155875*G0_0_1_2_4_0 - 0.00313852813852826*G0_0_1_2_4_2 - 0.00476190476190493*G0_0_1_2_4_4 - 0.000173160173160181*G0_0_1_2_4_5 - 0.000286796536796546*G0_0_1_2_5_0 + 0.000286796536796547*G0_0_1_2_5_1 + 0.000173160173160178*G0_0_1_2_5_3 - 0.000173160173160181*G0_0_1_2_5_4 + 0.000113636363636366*G0_0_1_3_0_0 + 0.000200216450216456*G0_0_1_3_0_1 - 0.000389610389610401*G0_0_1_3_0_3 + 0.000173160173160179*G0_0_1_3_0_4 + 0.000346320346320357*G0_0_1_3_0_5 + 0.000200216450216456*G0_0_1_3_1_0 - 0.00143398268398273*G0_0_1_3_1_1 - 0.000844155844155872*G0_0_1_3_1_2 - 0.00177489177489183*G0_0_1_3_1_3 - 0.000173160173160177*G0_0_1_3_1_4 - 0.000974025974026007*G0_0_1_3_1_5 - 0.000844155844155871*G0_0_1_3_2_1 + 0.00313852813852823*G0_0_1_3_2_2 + 0.00476190476190491*G0_0_1_3_2_3 + 0.000173160173160179*G0_0_1_3_2_5 - 0.000389610389610401*G0_0_1_3_3_0 - 0.00177489177489183*G0_0_1_3_3_1 + 0.00476190476190491*G0_0_1_3_3_2 + 0.0101298701298705*G0_0_1_3_3_3 + 0.00112554112554116*G0_0_1_3_3_4 + 0.000432900432900452*G0_0_1_3_3_5 + 0.000173160173160179*G0_0_1_3_4_0 - 0.000173160173160178*G0_0_1_3_4_1 + 0.00112554112554116*G0_0_1_3_4_3 - 0.00112554112554117*G0_0_1_3_4_4 + 0.000346320346320356*G0_0_1_3_5_0 - 0.000974025974026008*G0_0_1_3_5_1 + 0.000173160173160179*G0_0_1_3_5_2 + 0.000432900432900452*G0_0_1_3_5_3 - 0.000692640692640715*G0_0_1_3_5_5 + 0.00143398268398273*G0_0_1_4_0_0 - 0.000200216450216457*G0_0_1_4_0_1 + 0.000844155844155875*G0_0_1_4_0_2 + 0.000173160173160179*G0_0_1_4_0_3 + 0.00177489177489184*G0_0_1_4_0_4 + 0.000974025974026006*G0_0_1_4_0_5 - 0.000200216450216457*G0_0_1_4_1_0 - 0.000113636363636366*G0_0_1_4_1_1 - 0.000173160173160178*G0_0_1_4_1_3 + 0.000389610389610403*G0_0_1_4_1_4 - 0.000346320346320357*G0_0_1_4_1_5 + 0.000844155844155875*G0_0_1_4_2_0 - 0.00313852813852826*G0_0_1_4_2_2 - 0.00476190476190493*G0_0_1_4_2_4 - 0.000173160173160181*G0_0_1_4_2_5 + 0.000173160173160179*G0_0_1_4_3_0 - 0.000173160173160178*G0_0_1_4_3_1 + 0.00112554112554116*G0_0_1_4_3_3 - 0.00112554112554117*G0_0_1_4_3_4 + 0.00177489177489184*G0_0_1_4_4_0 + 0.000389610389610403*G0_0_1_4_4_1 - 0.00476190476190493*G0_0_1_4_4_2 - 0.00112554112554117*G0_0_1_4_4_3 - 0.0101298701298705*G0_0_1_4_4_4 - 0.000432900432900452*G0_0_1_4_4_5 + 0.000974025974026006*G0_0_1_4_5_0 - 0.000346320346320357*G0_0_1_4_5_1 - 0.000173160173160181*G0_0_1_4_5_2 - 0.000432900432900451*G0_0_1_4_5_4 + 0.000692640692640716*G0_0_1_4_5_5 + 0.00457251082251098*G0_0_1_5_0_0 - 0.000286796536796546*G0_0_1_5_0_2 + 0.000346320346320356*G0_0_1_5_0_3 + 0.000974025974026006*G0_0_1_5_0_4 + 0.00653679653679676*G0_0_1_5_0_5 - 0.00457251082251099*G0_0_1_5_1_1 + 0.000286796536796547*G0_0_1_5_1_2 - 0.000974025974026007*G0_0_1_5_1_3 - 0.000346320346320356*G0_0_1_5_1_4 - 0.00653679653679676*G0_0_1_5_1_5 - 0.000286796536796546*G0_0_1_5_2_0 + 0.000286796536796547*G0_0_1_5_2_1 + 0.000173160173160179*G0_0_1_5_2_3 - 0.000173160173160181*G0_0_1_5_2_4 + 0.000346320346320356*G0_0_1_5_3_0 - 0.000974025974026007*G0_0_1_5_3_1 + 0.000173160173160179*G0_0_1_5_3_2 + 0.000432900432900452*G0_0_1_5_3_3 - 0.000692640692640716*G0_0_1_5_3_5 + 0.000974025974026006*G0_0_1_5_4_0 - 0.000346320346320356*G0_0_1_5_4_1 - 0.000173160173160181*G0_0_1_5_4_2 - 0.000432900432900453*G0_0_1_5_4_4 + 0.000692640692640716*G0_0_1_5_4_5 + 0.00653679653679676*G0_0_1_5_5_0 - 0.00653679653679676*G0_0_1_5_5_1 - 0.000692640692640715*G0_0_1_5_5_3 + 0.000692640692640716*G0_0_1_5_5_4 - 0.00429383116883133*G0_1_1_0_0_0 + 0.000324675324675338*G0_1_1_0_0_1 + 0.000262445887445897*G0_1_1_0_0_2 + 0.000167748917748923*G0_1_1_0_0_3 - 0.000416666666666683*G0_1_1_0_0_4 - 0.00461580086580103*G0_1_1_0_0_5 + 0.000324675324675338*G0_1_1_0_1_0 + 0.00153950216450222*G0_1_1_0_1_1 + 0.000638528138528159*G0_1_1_0_1_3 + 0.000438311688311702*G0_1_1_0_1_4 + 0.00360389610389623*G0_1_1_0_1_5 + 0.000262445887445897*G0_1_1_0_2_0 - 0.000679112554112575*G0_1_1_0_2_2 - 0.000183982683982689*G0_1_1_0_2_3 - 0.000194805194805201*G0_1_1_0_2_4 + 0.000286796536796548*G0_1_1_0_2_5 + 0.000167748917748923*G0_1_1_0_3_0 + 0.000638528138528159*G0_1_1_0_3_1 - 0.000183982683982689*G0_1_1_0_3_2 - 0.00225108225108232*G0_1_1_0_3_3 - 0.00121212121212125*G0_1_1_0_3_4 - 0.00090909090909094*G0_1_1_0_3_5 - 0.000416666666666683*G0_1_1_0_4_0 + 0.000438311688311702*G0_1_1_0_4_1 - 0.000194805194805201*G0_1_1_0_4_2 - 0.00121212121212125*G0_1_1_0_4_3 - 0.00073593073593076*G0_1_1_0_4_4 - 0.0014502164502165*G0_1_1_0_4_5 - 0.00461580086580103*G0_1_1_0_5_0 + 0.00360389610389623*G0_1_1_0_5_1 + 0.000286796536796548*G0_1_1_0_5_2 - 0.00090909090909094*G0_1_1_0_5_3 - 0.0014502164502165*G0_1_1_0_5_4 - 0.00298701298701312*G0_1_1_0_5_5 + 0.000324675324675339*G0_1_1_1_0_0 + 0.00153950216450222*G0_1_1_1_0_1 + 0.000638528138528159*G0_1_1_1_0_3 + 0.000438311688311702*G0_1_1_1_0_4 + 0.00360389610389623*G0_1_1_1_0_5 + 0.00153950216450222*G0_1_1_1_1_0 - 0.0168831168831175*G0_1_1_1_1_1 + 0.000882034632034662*G0_1_1_1_1_2 - 0.00185064935064941*G0_1_1_1_1_3 - 0.00918831168831202*G0_1_1_1_1_5 + 0.000882034632034662*G0_1_1_1_2_1 - 0.00127435064935069*G0_1_1_1_2_2 - 0.00103896103896107*G0_1_1_1_2_3 + 0.000573593073593093*G0_1_1_1_2_5 + 0.000638528138528159*G0_1_1_1_3_0 - 0.00185064935064941*G0_1_1_1_3_1 - 0.00103896103896107*G0_1_1_1_3_2 - 0.00251082251082259*G0_1_1_1_3_3 - 0.00138528138528143*G0_1_1_1_3_4 - 0.00242424242424251*G0_1_1_1_3_5 + 0.000438311688311702*G0_1_1_1_4_0 - 0.00138528138528143*G0_1_1_1_4_3 - 0.00186147186147192*G0_1_1_1_4_4 - 0.0012554112554113*G0_1_1_1_4_5 + 0.00360389610389623*G0_1_1_1_5_0 - 0.00918831168831202*G0_1_1_1_5_1 + 0.000573593073593093*G0_1_1_1_5_2 - 0.00242424242424251*G0_1_1_1_5_3 - 0.0012554112554113*G0_1_1_1_5_4 - 0.00952380952380986*G0_1_1_1_5_5 + 0.000262445887445897*G0_1_1_2_0_0 - 0.000679112554112575*G0_1_1_2_0_2 - 0.000183982683982689*G0_1_1_2_0_3 - 0.000194805194805201*G0_1_1_2_0_4 + 0.000286796536796548*G0_1_1_2_0_5 + 0.000882034632034662*G0_1_1_2_1_1 - 0.00127435064935069*G0_1_1_2_1_2 - 0.00103896103896107*G0_1_1_2_1_3 + 0.000573593073593093*G0_1_1_2_1_5 - 0.000679112554112575*G0_1_1_2_2_0 - 0.00127435064935069*G0_1_1_2_2_1 + 0.00868506493506522*G0_1_1_2_2_2 + 0.00595238095238115*G0_1_1_2_2_3 + 0.00281385281385291*G0_1_1_2_2_4 + 0.000573593073593095*G0_1_1_2_2_5 - 0.000183982683982689*G0_1_1_2_3_0 - 0.00103896103896107*G0_1_1_2_3_1 + 0.00595238095238115*G0_1_1_2_3_2 + 0.00441558441558457*G0_1_1_2_3_3 + 0.000562770562770582*G0_1_1_2_3_4 - 0.000779220779220806*G0_1_1_2_3_5 - 0.000194805194805201*G0_1_1_2_4_0 + 0.00281385281385291*G0_1_1_2_4_2 + 0.000562770562770581*G0_1_1_2_4_3 - 0.000346320346320358*G0_1_1_2_4_4 - 0.000952380952380986*G0_1_1_2_4_5 + 0.000286796536796548*G0_1_1_2_5_0 + 0.000573593073593093*G0_1_1_2_5_1 + 0.000573593073593095*G0_1_1_2_5_2 - 0.000779220779220806*G0_1_1_2_5_3 - 0.000952380952380986*G0_1_1_2_5_4 + 0.00190476190476197*G0_1_1_2_5_5 + 0.000167748917748923*G0_1_1_3_0_0 + 0.000638528138528159*G0_1_1_3_0_1 - 0.000183982683982689*G0_1_1_3_0_2 - 0.00225108225108232*G0_1_1_3_0_3 - 0.00121212121212125*G0_1_1_3_0_4 - 0.00090909090909094*G0_1_1_3_0_5 + 0.000638528138528159*G0_1_1_3_1_0 - 0.00185064935064941*G0_1_1_3_1_1 - 0.00103896103896107*G0_1_1_3_1_2 - 0.00251082251082259*G0_1_1_3_1_3 - 0.00138528138528143*G0_1_1_3_1_4 - 0.00242424242424251*G0_1_1_3_1_5 - 0.000183982683982689*G0_1_1_3_2_0 - 0.00103896103896107*G0_1_1_3_2_1 + 0.00595238095238116*G0_1_1_3_2_2 + 0.00441558441558457*G0_1_1_3_2_3 + 0.000562770562770582*G0_1_1_3_2_4 - 0.000779220779220806*G0_1_1_3_2_5 - 0.00225108225108232*G0_1_1_3_3_0 - 0.00251082251082259*G0_1_1_3_3_1 + 0.00441558441558457*G0_1_1_3_3_2 + 0.021298701298702*G0_1_1_3_3_3 + 0.00727272727272751*G0_1_1_3_3_4 + 0.00606060606060627*G0_1_1_3_3_5 - 0.00121212121212125*G0_1_1_3_4_0 - 0.00138528138528143*G0_1_1_3_4_1 + 0.000562770562770581*G0_1_1_3_4_2 + 0.00727272727272752*G0_1_1_3_4_3 + 0.00614718614718635*G0_1_1_3_4_4 + 0.00432900432900448*G0_1_1_3_4_5 - 0.00090909090909094*G0_1_1_3_5_0 - 0.00242424242424251*G0_1_1_3_5_1 - 0.000779220779220806*G0_1_1_3_5_2 + 0.00606060606060627*G0_1_1_3_5_3 + 0.00432900432900448*G0_1_1_3_5_4 - 0.00199134199134205*G0_1_1_3_5_5 - 0.000416666666666683*G0_1_1_4_0_0 + 0.000438311688311702*G0_1_1_4_0_1 - 0.000194805194805201*G0_1_1_4_0_2 - 0.00121212121212125*G0_1_1_4_0_3 - 0.000735930735930761*G0_1_1_4_0_4 - 0.0014502164502165*G0_1_1_4_0_5 + 0.000438311688311702*G0_1_1_4_1_0 - 0.00138528138528143*G0_1_1_4_1_3 - 0.00186147186147192*G0_1_1_4_1_4 - 0.0012554112554113*G0_1_1_4_1_5 - 0.000194805194805201*G0_1_1_4_2_0 + 0.00281385281385291*G0_1_1_4_2_2 + 0.000562770562770582*G0_1_1_4_2_3 - 0.000346320346320357*G0_1_1_4_2_4 - 0.000952380952380986*G0_1_1_4_2_5 - 0.00121212121212125*G0_1_1_4_3_0 - 0.00138528138528143*G0_1_1_4_3_1 + 0.000562770562770582*G0_1_1_4_3_2 + 0.00727272727272752*G0_1_1_4_3_3 + 0.00614718614718635*G0_1_1_4_3_4 + 0.00432900432900448*G0_1_1_4_3_5 - 0.00073593073593076*G0_1_1_4_4_0 - 0.00186147186147192*G0_1_1_4_4_1 - 0.000346320346320357*G0_1_1_4_4_2 + 0.00614718614718635*G0_1_1_4_4_3 + 0.0111688311688315*G0_1_1_4_4_4 + 0.00562770562770582*G0_1_1_4_4_5 - 0.0014502164502165*G0_1_1_4_5_0 - 0.0012554112554113*G0_1_1_4_5_1 - 0.000952380952380986*G0_1_1_4_5_2 + 0.00432900432900448*G0_1_1_4_5_3 + 0.00562770562770582*G0_1_1_4_5_4 - 0.00129870129870133*G0_1_1_4_5_5 - 0.00461580086580103*G0_1_1_5_0_0 + 0.00360389610389623*G0_1_1_5_0_1 + 0.000286796536796548*G0_1_1_5_0_2 - 0.00090909090909094*G0_1_1_5_0_3 - 0.0014502164502165*G0_1_1_5_0_4 - 0.00298701298701312*G0_1_1_5_0_5 + 0.00360389610389623*G0_1_1_5_1_0 - 0.00918831168831202*G0_1_1_5_1_1 + 0.000573593073593093*G0_1_1_5_1_2 - 0.00242424242424251*G0_1_1_5_1_3 - 0.0012554112554113*G0_1_1_5_1_4 - 0.00952380952380986*G0_1_1_5_1_5 + 0.000286796536796548*G0_1_1_5_2_0 + 0.000573593073593093*G0_1_1_5_2_1 + 0.000573593073593095*G0_1_1_5_2_2 - 0.000779220779220806*G0_1_1_5_2_3 - 0.000952380952380986*G0_1_1_5_2_4 + 0.00190476190476197*G0_1_1_5_2_5 - 0.00090909090909094*G0_1_1_5_3_0 - 0.00242424242424251*G0_1_1_5_3_1 - 0.000779220779220806*G0_1_1_5_3_2 + 0.00606060606060627*G0_1_1_5_3_3 + 0.00432900432900448*G0_1_1_5_3_4 - 0.00199134199134205*G0_1_1_5_3_5 - 0.0014502164502165*G0_1_1_5_4_0 - 0.0012554112554113*G0_1_1_5_4_1 - 0.000952380952380986*G0_1_1_5_4_2 + 0.00432900432900448*G0_1_1_5_4_3 + 0.00562770562770582*G0_1_1_5_4_4 - 0.00129870129870133*G0_1_1_5_4_5 - 0.00298701298701312*G0_1_1_5_5_0 - 0.00952380952380986*G0_1_1_5_5_1 + 0.00190476190476197*G0_1_1_5_5_2 - 0.00199134199134205*G0_1_1_5_5_3 - 0.00129870129870133*G0_1_1_5_5_4 - 0.0932467532467564*G0_1_1_5_5_5;
    A[27] = A[72] - 0.020150162337663*G0_0_1_0_0_0 + 0.00127299783549787*G0_0_1_0_0_1 + 0.00073593073593076*G0_0_1_0_0_2 - 0.000243506493506498*G0_0_1_0_0_3 - 0.00213744588744595*G0_0_1_0_0_4 - 0.00492424242424259*G0_0_1_0_0_5 + 0.00127299783549787*G0_0_1_0_1_0 - 0.000238095238095245*G0_0_1_0_1_3 - 0.000162337662337668*G0_0_1_0_1_5 + 0.00073593073593076*G0_0_1_0_2_0 - 0.000248917748917757*G0_0_1_0_2_2 - 0.000183982683982691*G0_0_1_0_2_3 - 0.000844155844155872*G0_0_1_0_2_4 - 0.000243506493506498*G0_0_1_0_3_0 - 0.000238095238095245*G0_0_1_0_3_1 - 0.000183982683982691*G0_0_1_0_3_2 + 0.000519480519480536*G0_0_1_0_3_3 + 0.000562770562770581*G0_0_1_0_3_4 + 0.000476190476190492*G0_0_1_0_3_5 - 0.00213744588744595*G0_0_1_0_4_0 - 0.000844155844155872*G0_0_1_0_4_2 + 0.000562770562770581*G0_0_1_0_4_3 + 0.0020346320346321*G0_0_1_0_4_4 - 0.00492424242424259*G0_0_1_0_5_0 - 0.000162337662337668*G0_0_1_0_5_1 + 0.000476190476190492*G0_0_1_0_5_3 - 0.00313852813852823*G0_0_1_0_5_5 + 0.00127299783549787*G0_0_1_1_0_0 - 0.000238095238095245*G0_0_1_1_0_3 - 0.000162337662337668*G0_0_1_1_0_5 - 0.00756087662337687*G0_0_1_1_1_1 + 0.000116341991341995*G0_0_1_1_1_2 - 0.000703463203463225*G0_0_1_1_1_3 - 0.000129870129870133*G0_0_1_1_1_4 - 0.000351731601731617*G0_0_1_1_1_5 + 0.000116341991341995*G0_0_1_1_2_1 + 0.000346320346320359*G0_0_1_1_2_2 - 0.000270562770562779*G0_0_1_1_2_4 - 0.000281385281385291*G0_0_1_1_2_5 - 0.000238095238095245*G0_0_1_1_3_0 - 0.000703463203463225*G0_0_1_1_3_1 + 0.00380952380952394*G0_0_1_1_3_3 + 0.00073593073593076*G0_0_1_1_3_4 + 0.00103896103896107*G0_0_1_1_3_5 - 0.000129870129870133*G0_0_1_1_4_1 - 0.000270562770562779*G0_0_1_1_4_2 + 0.000735930735930759*G0_0_1_1_4_3 + 0.000129870129870133*G0_0_1_1_4_4 + 0.000822510822510848*G0_0_1_1_4_5 - 0.000162337662337669*G0_0_1_1_5_0 - 0.000351731601731617*G0_0_1_1_5_1 - 0.000281385281385291*G0_0_1_1_5_2 + 0.00103896103896107*G0_0_1_1_5_3 + 0.000822510822510849*G0_0_1_1_5_4 + 0.00339826839826851*G0_0_1_1_5_5 + 0.000735930735930759*G0_0_1_2_0_0 - 0.000248917748917757*G0_0_1_2_0_2 - 0.000183982683982691*G0_0_1_2_0_3 - 0.000844155844155872*G0_0_1_2_0_4 + 0.000116341991341995*G0_0_1_2_1_1 + 0.000346320346320359*G0_0_1_2_1_2 - 0.000270562770562779*G0_0_1_2_1_4 - 0.000281385281385291*G0_0_1_2_1_5 - 0.000248917748917757*G0_0_1_2_2_0 + 0.000346320346320359*G0_0_1_2_2_1 - 0.00156926406926412*G0_0_1_2_2_3 + 0.00156926406926412*G0_0_1_2_2_4 - 0.000183982683982691*G0_0_1_2_3_0 - 0.00156926406926412*G0_0_1_2_3_2 - 0.0032900432900434*G0_0_1_2_3_3 + 0.000909090909090938*G0_0_1_2_3_4 + 0.00056277056277058*G0_0_1_2_3_5 - 0.000844155844155872*G0_0_1_2_4_0 - 0.000270562770562779*G0_0_1_2_4_1 + 0.00156926406926412*G0_0_1_2_4_2 + 0.000909090909090938*G0_0_1_2_4_3 + 0.00147186147186152*G0_0_1_2_4_4 + 0.000735930735930761*G0_0_1_2_4_5 - 0.000281385281385291*G0_0_1_2_5_1 + 0.00056277056277058*G0_0_1_2_5_3 + 0.000735930735930761*G0_0_1_2_5_4 - 0.000389610389610403*G0_0_1_2_5_5 - 0.000243506493506498*G0_0_1_3_0_0 - 0.000238095238095245*G0_0_1_3_0_1 - 0.000183982683982691*G0_0_1_3_0_2 + 0.000519480519480536*G0_0_1_3_0_3 + 0.000562770562770581*G0_0_1_3_0_4 + 0.000476190476190492*G0_0_1_3_0_5 - 0.000238095238095245*G0_0_1_3_1_0 - 0.000703463203463225*G0_0_1_3_1_1 + 0.00380952380952394*G0_0_1_3_1_3 + 0.00073593073593076*G0_0_1_3_1_4 + 0.00103896103896107*G0_0_1_3_1_5 - 0.000183982683982691*G0_0_1_3_2_0 - 0.00156926406926412*G0_0_1_3_2_2 - 0.0032900432900434*G0_0_1_3_2_3 + 0.000909090909090938*G0_0_1_3_2_4 + 0.00056277056277058*G0_0_1_3_2_5 + 0.000519480519480536*G0_0_1_3_3_0 + 0.00380952380952394*G0_0_1_3_3_1 - 0.0032900432900434*G0_0_1_3_3_2 + 0.000779220779220799*G0_0_1_3_3_3 - 0.00251082251082259*G0_0_1_3_3_4 - 0.00216450216450223*G0_0_1_3_3_5 + 0.000562770562770581*G0_0_1_3_4_0 + 0.00073593073593076*G0_0_1_3_4_1 + 0.000909090909090938*G0_0_1_3_4_2 - 0.00251082251082259*G0_0_1_3_4_3 - 0.00138528138528143*G0_0_1_3_4_4 - 0.00259740259740268*G0_0_1_3_4_5 + 0.000476190476190492*G0_0_1_3_5_0 + 0.00103896103896107*G0_0_1_3_5_1 + 0.00056277056277058*G0_0_1_3_5_2 - 0.00216450216450223*G0_0_1_3_5_3 - 0.00259740259740268*G0_0_1_3_5_4 - 0.000173160173160179*G0_0_1_3_5_5 - 0.00213744588744595*G0_0_1_4_0_0 - 0.000844155844155872*G0_0_1_4_0_2 + 0.000562770562770581*G0_0_1_4_0_3 + 0.0020346320346321*G0_0_1_4_0_4 - 0.000129870129870133*G0_0_1_4_1_1 - 0.000270562770562779*G0_0_1_4_1_2 + 0.00073593073593076*G0_0_1_4_1_3 + 0.000129870129870133*G0_0_1_4_1_4 + 0.000822510822510849*G0_0_1_4_1_5 - 0.000844155844155872*G0_0_1_4_2_0 - 0.000270562770562779*G0_0_1_4_2_1 + 0.00156926406926412*G0_0_1_4_2_2 + 0.000909090909090939*G0_0_1_4_2_3 + 0.00147186147186152*G0_0_1_4_2_4 + 0.000735930735930761*G0_0_1_4_2_5 + 0.000562770562770581*G0_0_1_4_3_0 + 0.00073593073593076*G0_0_1_4_3_1 + 0.000909090909090939*G0_0_1_4_3_2 - 0.00251082251082259*G0_0_1_4_3_3 - 0.00138528138528143*G0_0_1_4_3_4 - 0.00259740259740268*G0_0_1_4_3_5 + 0.0020346320346321*G0_0_1_4_4_0 + 0.000129870129870133*G0_0_1_4_4_1 + 0.00147186147186152*G0_0_1_4_4_2 - 0.00138528138528143*G0_0_1_4_4_3 + 0.0109090909090913*G0_0_1_4_4_4 - 0.00173160173160179*G0_0_1_4_4_5 + 0.000822510822510849*G0_0_1_4_5_1 + 0.000735930735930761*G0_0_1_4_5_2 - 0.00259740259740268*G0_0_1_4_5_3 - 0.00173160173160179*G0_0_1_4_5_4 - 0.000865800865800894*G0_0_1_4_5_5 - 0.00492424242424259*G0_0_1_5_0_0 - 0.000162337662337668*G0_0_1_5_0_1 + 0.000476190476190492*G0_0_1_5_0_3 - 0.00313852813852823*G0_0_1_5_0_5 - 0.000162337662337668*G0_0_1_5_1_0 - 0.000351731601731617*G0_0_1_5_1_1 - 0.000281385281385291*G0_0_1_5_1_2 + 0.00103896103896107*G0_0_1_5_1_3 + 0.000822510822510848*G0_0_1_5_1_4 + 0.00339826839826851*G0_0_1_5_1_5 - 0.000281385281385291*G0_0_1_5_2_1 + 0.00056277056277058*G0_0_1_5_2_3 + 0.000735930735930761*G0_0_1_5_2_4 - 0.000389610389610403*G0_0_1_5_2_5 + 0.000476190476190492*G0_0_1_5_3_0 + 0.00103896103896107*G0_0_1_5_3_1 + 0.00056277056277058*G0_0_1_5_3_2 - 0.00216450216450223*G0_0_1_5_3_3 - 0.00259740259740268*G0_0_1_5_3_4 - 0.000173160173160178*G0_0_1_5_3_5 + 0.000822510822510849*G0_0_1_5_4_1 + 0.00073593073593076*G0_0_1_5_4_2 - 0.00259740259740268*G0_0_1_5_4_3 - 0.00173160173160179*G0_0_1_5_4_4 - 0.000865800865800894*G0_0_1_5_4_5 - 0.00313852813852823*G0_0_1_5_5_0 + 0.00339826839826851*G0_0_1_5_5_1 - 0.000389610389610403*G0_0_1_5_5_2 - 0.000173160173160178*G0_0_1_5_5_3 - 0.000865800865800894*G0_0_1_5_5_4 + 0.0397402597402611*G0_0_1_5_5_5 + 0.020150162337663*G0_1_0_0_0_0 - 0.00127299783549787*G0_1_0_0_0_1 - 0.00073593073593076*G0_1_0_0_0_2 + 0.000243506493506498*G0_1_0_0_0_3 + 0.00213744588744595*G0_1_0_0_0_4 + 0.00492424242424259*G0_1_0_0_0_5 - 0.00127299783549787*G0_1_0_0_1_0 + 0.000238095238095245*G0_1_0_0_1_3 + 0.000162337662337668*G0_1_0_0_1_5 - 0.00073593073593076*G0_1_0_0_2_0 + 0.000248917748917757*G0_1_0_0_2_2 + 0.000183982683982691*G0_1_0_0_2_3 + 0.000844155844155872*G0_1_0_0_2_4 + 0.000243506493506498*G0_1_0_0_3_0 + 0.000238095238095245*G0_1_0_0_3_1 + 0.000183982683982691*G0_1_0_0_3_2 - 0.000519480519480536*G0_1_0_0_3_3 - 0.000562770562770581*G0_1_0_0_3_4 - 0.000476190476190492*G0_1_0_0_3_5 + 0.00213744588744595*G0_1_0_0_4_0 + 0.000844155844155872*G0_1_0_0_4_2 - 0.000562770562770581*G0_1_0_0_4_3 - 0.0020346320346321*G0_1_0_0_4_4 + 0.00492424242424259*G0_1_0_0_5_0 + 0.000162337662337668*G0_1_0_0_5_1 - 0.000476190476190492*G0_1_0_0_5_3 + 0.00313852813852824*G0_1_0_0_5_5 - 0.00127299783549787*G0_1_0_1_0_0 + 0.000238095238095245*G0_1_0_1_0_3 + 0.000162337662337668*G0_1_0_1_0_5 + 0.00756087662337687*G0_1_0_1_1_1 - 0.000116341991341995*G0_1_0_1_1_2 + 0.000703463203463225*G0_1_0_1_1_3 + 0.000129870129870133*G0_1_0_1_1_4 + 0.000351731601731617*G0_1_0_1_1_5 - 0.000116341991341995*G0_1_0_1_2_1 - 0.000346320346320359*G0_1_0_1_2_2 + 0.000270562770562779*G0_1_0_1_2_4 + 0.000281385281385291*G0_1_0_1_2_5 + 0.000238095238095245*G0_1_0_1_3_0 + 0.000703463203463225*G0_1_0_1_3_1 - 0.00380952380952394*G0_1_0_1_3_3 - 0.00073593073593076*G0_1_0_1_3_4 - 0.00103896103896107*G0_1_0_1_3_5 + 0.000129870129870133*G0_1_0_1_4_1 + 0.000270562770562779*G0_1_0_1_4_2 - 0.00073593073593076*G0_1_0_1_4_3 - 0.000129870129870133*G0_1_0_1_4_4 - 0.000822510822510849*G0_1_0_1_4_5 + 0.000162337662337668*G0_1_0_1_5_0 + 0.000351731601731617*G0_1_0_1_5_1 + 0.000281385281385291*G0_1_0_1_5_2 - 0.00103896103896107*G0_1_0_1_5_3 - 0.000822510822510849*G0_1_0_1_5_4 - 0.00339826839826851*G0_1_0_1_5_5 - 0.00073593073593076*G0_1_0_2_0_0 + 0.000248917748917757*G0_1_0_2_0_2 + 0.000183982683982691*G0_1_0_2_0_3 + 0.000844155844155872*G0_1_0_2_0_4 - 0.000116341991341995*G0_1_0_2_1_1 - 0.000346320346320359*G0_1_0_2_1_2 + 0.000270562770562779*G0_1_0_2_1_4 + 0.000281385281385291*G0_1_0_2_1_5 + 0.000248917748917757*G0_1_0_2_2_0 - 0.000346320346320359*G0_1_0_2_2_1 + 0.00156926406926412*G0_1_0_2_2_3 - 0.00156926406926412*G0_1_0_2_2_4 + 0.000183982683982691*G0_1_0_2_3_0 + 0.00156926406926412*G0_1_0_2_3_2 + 0.0032900432900434*G0_1_0_2_3_3 - 0.000909090909090938*G0_1_0_2_3_4 - 0.000562770562770581*G0_1_0_2_3_5 + 0.000844155844155872*G0_1_0_2_4_0 + 0.000270562770562779*G0_1_0_2_4_1 - 0.00156926406926412*G0_1_0_2_4_2 - 0.000909090909090938*G0_1_0_2_4_3 - 0.00147186147186152*G0_1_0_2_4_4 - 0.000735930735930761*G0_1_0_2_4_5 + 0.000281385281385291*G0_1_0_2_5_1 - 0.000562770562770581*G0_1_0_2_5_3 - 0.000735930735930761*G0_1_0_2_5_4 + 0.000389610389610403*G0_1_0_2_5_5 + 0.000243506493506498*G0_1_0_3_0_0 + 0.000238095238095245*G0_1_0_3_0_1 + 0.000183982683982691*G0_1_0_3_0_2 - 0.000519480519480536*G0_1_0_3_0_3 - 0.000562770562770581*G0_1_0_3_0_4 - 0.000476190476190492*G0_1_0_3_0_5 + 0.000238095238095245*G0_1_0_3_1_0 + 0.000703463203463225*G0_1_0_3_1_1 - 0.00380952380952394*G0_1_0_3_1_3 - 0.00073593073593076*G0_1_0_3_1_4 - 0.00103896103896107*G0_1_0_3_1_5 + 0.000183982683982691*G0_1_0_3_2_0 + 0.00156926406926412*G0_1_0_3_2_2 + 0.0032900432900434*G0_1_0_3_2_3 - 0.000909090909090938*G0_1_0_3_2_4 - 0.000562770562770581*G0_1_0_3_2_5 - 0.000519480519480536*G0_1_0_3_3_0 - 0.00380952380952394*G0_1_0_3_3_1 + 0.0032900432900434*G0_1_0_3_3_2 - 0.000779220779220799*G0_1_0_3_3_3 + 0.00251082251082259*G0_1_0_3_3_4 + 0.00216450216450223*G0_1_0_3_3_5 - 0.000562770562770581*G0_1_0_3_4_0 - 0.00073593073593076*G0_1_0_3_4_1 - 0.000909090909090939*G0_1_0_3_4_2 + 0.00251082251082259*G0_1_0_3_4_3 + 0.00138528138528143*G0_1_0_3_4_4 + 0.00259740259740268*G0_1_0_3_4_5 - 0.000476190476190492*G0_1_0_3_5_0 - 0.00103896103896107*G0_1_0_3_5_1 - 0.00056277056277058*G0_1_0_3_5_2 + 0.00216450216450223*G0_1_0_3_5_3 + 0.00259740259740268*G0_1_0_3_5_4 + 0.000173160173160179*G0_1_0_3_5_5 + 0.00213744588744595*G0_1_0_4_0_0 + 0.000844155844155872*G0_1_0_4_0_2 - 0.000562770562770581*G0_1_0_4_0_3 - 0.0020346320346321*G0_1_0_4_0_4 + 0.000129870129870133*G0_1_0_4_1_1 + 0.000270562770562779*G0_1_0_4_1_2 - 0.00073593073593076*G0_1_0_4_1_3 - 0.000129870129870133*G0_1_0_4_1_4 - 0.000822510822510849*G0_1_0_4_1_5 + 0.000844155844155872*G0_1_0_4_2_0 + 0.000270562770562779*G0_1_0_4_2_1 - 0.00156926406926412*G0_1_0_4_2_2 - 0.000909090909090939*G0_1_0_4_2_3 - 0.00147186147186152*G0_1_0_4_2_4 - 0.000735930735930761*G0_1_0_4_2_5 - 0.000562770562770581*G0_1_0_4_3_0 - 0.00073593073593076*G0_1_0_4_3_1 - 0.000909090909090939*G0_1_0_4_3_2 + 0.00251082251082259*G0_1_0_4_3_3 + 0.00138528138528143*G0_1_0_4_3_4 + 0.00259740259740268*G0_1_0_4_3_5 - 0.0020346320346321*G0_1_0_4_4_0 - 0.000129870129870133*G0_1_0_4_4_1 - 0.00147186147186152*G0_1_0_4_4_2 + 0.00138528138528143*G0_1_0_4_4_3 - 0.0109090909090913*G0_1_0_4_4_4 + 0.00173160173160179*G0_1_0_4_4_5 - 0.000822510822510849*G0_1_0_4_5_1 - 0.000735930735930761*G0_1_0_4_5_2 + 0.00259740259740268*G0_1_0_4_5_3 + 0.00173160173160179*G0_1_0_4_5_4 + 0.000865800865800895*G0_1_0_4_5_5 + 0.00492424242424259*G0_1_0_5_0_0 + 0.000162337662337668*G0_1_0_5_0_1 - 0.000476190476190492*G0_1_0_5_0_3 + 0.00313852813852824*G0_1_0_5_0_5 + 0.000162337662337668*G0_1_0_5_1_0 + 0.000351731601731617*G0_1_0_5_1_1 + 0.000281385281385291*G0_1_0_5_1_2 - 0.00103896103896107*G0_1_0_5_1_3 - 0.000822510822510849*G0_1_0_5_1_4 - 0.00339826839826851*G0_1_0_5_1_5 + 0.000281385281385291*G0_1_0_5_2_1 - 0.00056277056277058*G0_1_0_5_2_3 - 0.000735930735930761*G0_1_0_5_2_4 + 0.000389610389610403*G0_1_0_5_2_5 - 0.000476190476190492*G0_1_0_5_3_0 - 0.00103896103896107*G0_1_0_5_3_1 - 0.000562770562770581*G0_1_0_5_3_2 + 0.00216450216450223*G0_1_0_5_3_3 + 0.00259740259740268*G0_1_0_5_3_4 + 0.000173160173160178*G0_1_0_5_3_5 - 0.000822510822510849*G0_1_0_5_4_1 - 0.000735930735930761*G0_1_0_5_4_2 + 0.00259740259740268*G0_1_0_5_4_3 + 0.00173160173160179*G0_1_0_5_4_4 + 0.000865800865800894*G0_1_0_5_4_5 + 0.00313852813852823*G0_1_0_5_5_0 - 0.00339826839826851*G0_1_0_5_5_1 + 0.000389610389610403*G0_1_0_5_5_2 + 0.000173160173160179*G0_1_0_5_5_3 + 0.000865800865800894*G0_1_0_5_5_4 - 0.0397402597402611*G0_1_0_5_5_5;
    A[92] = 0.00172889610389617*G0_0_1_0_0_0 - 0.000186688311688318*G0_0_1_0_0_1 + 0.000616883116883137*G0_0_1_0_0_2 + 0.000454545454545469*G0_0_1_0_0_3 + 0.000194805194805198*G0_0_1_0_0_4 + 0.000941558441558476*G0_0_1_0_0_5 - 0.000186688311688318*G0_0_1_0_1_0 + 0.000186688311688316*G0_0_1_0_1_1 - 0.000454545454545468*G0_0_1_0_1_3 + 0.00045454545454547*G0_0_1_0_1_4 + 0.000616883116883137*G0_0_1_0_2_0 - 0.00219155844155851*G0_0_1_0_2_2 + 0.000909090909090935*G0_0_1_0_2_3 - 0.00220779220779228*G0_0_1_0_2_4 + 0.000194805194805201*G0_0_1_0_2_5 + 0.000454545454545468*G0_0_1_0_3_0 - 0.000454545454545468*G0_0_1_0_3_1 + 0.000909090909090935*G0_0_1_0_3_2 - 0.00207792207792215*G0_0_1_0_3_3 - 0.00181818181818188*G0_0_1_0_3_4 - 0.00129870129870134*G0_0_1_0_3_5 + 0.000194805194805198*G0_0_1_0_4_0 + 0.00045454545454547*G0_0_1_0_4_1 - 0.00220779220779228*G0_0_1_0_4_2 - 0.00181818181818188*G0_0_1_0_4_3 - 0.0124675324675329*G0_0_1_0_4_4 - 0.00129870129870134*G0_0_1_0_4_5 + 0.000941558441558476*G0_0_1_0_5_0 + 0.000194805194805201*G0_0_1_0_5_2 - 0.00129870129870134*G0_0_1_0_5_3 - 0.00129870129870134*G0_0_1_0_5_4 + 0.000389610389610402*G0_0_1_0_5_5 - 0.000186688311688318*G0_0_1_1_0_0 + 0.000186688311688316*G0_0_1_1_0_1 - 0.000454545454545468*G0_0_1_1_0_3 + 0.00045454545454547*G0_0_1_1_0_4 + 0.000186688311688316*G0_0_1_1_1_0 - 0.00172889610389614*G0_0_1_1_1_1 - 0.000616883116883139*G0_0_1_1_1_2 - 0.000194805194805193*G0_0_1_1_1_3 - 0.000454545454545469*G0_0_1_1_1_4 - 0.000941558441558469*G0_0_1_1_1_5 - 0.000616883116883139*G0_0_1_1_2_1 + 0.00219155844155852*G0_0_1_1_2_2 + 0.00220779220779228*G0_0_1_1_2_3 - 0.000909090909090939*G0_0_1_1_2_4 - 0.000194805194805202*G0_0_1_1_2_5 - 0.000454545454545468*G0_0_1_1_3_0 - 0.000194805194805193*G0_0_1_1_3_1 + 0.00220779220779228*G0_0_1_1_3_2 + 0.0124675324675329*G0_0_1_1_3_3 + 0.00181818181818188*G0_0_1_1_3_4 + 0.00129870129870135*G0_0_1_1_3_5 + 0.00045454545454547*G0_0_1_1_4_0 - 0.000454545454545469*G0_0_1_1_4_1 - 0.000909090909090939*G0_0_1_1_4_2 + 0.00181818181818188*G0_0_1_1_4_3 + 0.00207792207792215*G0_0_1_1_4_4 + 0.00129870129870134*G0_0_1_1_4_5 - 0.000941558441558469*G0_0_1_1_5_1 - 0.000194805194805202*G0_0_1_1_5_2 + 0.00129870129870135*G0_0_1_1_5_3 + 0.00129870129870134*G0_0_1_1_5_4 - 0.000389610389610397*G0_0_1_1_5_5 + 0.000616883116883137*G0_0_1_2_0_0 - 0.00219155844155851*G0_0_1_2_0_2 + 0.000909090909090935*G0_0_1_2_0_3 - 0.00220779220779228*G0_0_1_2_0_4 + 0.000194805194805201*G0_0_1_2_0_5 - 0.000616883116883139*G0_0_1_2_1_1 + 0.00219155844155852*G0_0_1_2_1_2 + 0.00220779220779228*G0_0_1_2_1_3 - 0.000909090909090939*G0_0_1_2_1_4 - 0.000194805194805202*G0_0_1_2_1_5 - 0.00219155844155851*G0_0_1_2_2_0 + 0.00219155844155852*G0_0_1_2_2_1 - 0.0100649350649354*G0_0_1_2_2_3 + 0.0100649350649354*G0_0_1_2_2_4 + 0.000909090909090935*G0_0_1_2_3_0 + 0.00220779220779228*G0_0_1_2_3_1 - 0.0100649350649354*G0_0_1_2_3_2 - 0.0233766233766242*G0_0_1_2_3_3 - 0.00181818181818188*G0_0_1_2_3_5 - 0.00220779220779228*G0_0_1_2_4_0 - 0.000909090909090939*G0_0_1_2_4_1 + 0.0100649350649354*G0_0_1_2_4_2 + 0.0233766233766241*G0_0_1_2_4_4 + 0.00181818181818188*G0_0_1_2_4_5 + 0.000194805194805201*G0_0_1_2_5_0 - 0.000194805194805202*G0_0_1_2_5_1 - 0.00181818181818188*G0_0_1_2_5_3 + 0.00181818181818188*G0_0_1_2_5_4 + 0.000454545454545469*G0_0_1_3_0_0 - 0.000454545454545468*G0_0_1_3_0_1 + 0.000909090909090935*G0_0_1_3_0_2 - 0.00207792207792215*G0_0_1_3_0_3 - 0.00181818181818188*G0_0_1_3_0_4 - 0.00129870129870134*G0_0_1_3_0_5 - 0.000454545454545468*G0_0_1_3_1_0 - 0.000194805194805193*G0_0_1_3_1_1 + 0.00220779220779228*G0_0_1_3_1_2 + 0.0124675324675329*G0_0_1_3_1_3 + 0.00181818181818188*G0_0_1_3_1_4 + 0.00129870129870135*G0_0_1_3_1_5 + 0.000909090909090935*G0_0_1_3_2_0 + 0.00220779220779228*G0_0_1_3_2_1 - 0.0100649350649354*G0_0_1_3_2_2 - 0.0233766233766242*G0_0_1_3_2_3 - 0.00181818181818188*G0_0_1_3_2_5 - 0.00207792207792215*G0_0_1_3_3_0 + 0.0124675324675329*G0_0_1_3_3_1 - 0.0233766233766242*G0_0_1_3_3_2 + 0.00467532467532479*G0_0_1_3_3_3 + 0.000519480519480532*G0_0_1_3_3_4 + 0.00779220779220805*G0_0_1_3_3_5 - 0.00181818181818188*G0_0_1_3_4_0 + 0.00181818181818188*G0_0_1_3_4_1 + 0.000519480519480531*G0_0_1_3_4_3 - 0.000519480519480539*G0_0_1_3_4_4 - 0.00129870129870134*G0_0_1_3_5_0 + 0.00129870129870135*G0_0_1_3_5_1 - 0.00181818181818188*G0_0_1_3_5_2 + 0.00779220779220805*G0_0_1_3_5_3 + 0.00259740259740269*G0_0_1_3_5_5 + 0.000194805194805198*G0_0_1_4_0_0 + 0.00045454545454547*G0_0_1_4_0_1 - 0.00220779220779228*G0_0_1_4_0_2 - 0.00181818181818188*G0_0_1_4_0_3 - 0.0124675324675329*G0_0_1_4_0_4 - 0.00129870129870134*G0_0_1_4_0_5 + 0.00045454545454547*G0_0_1_4_1_0 - 0.000454545454545469*G0_0_1_4_1_1 - 0.000909090909090939*G0_0_1_4_1_2 + 0.00181818181818188*G0_0_1_4_1_3 + 0.00207792207792215*G0_0_1_4_1_4 + 0.00129870129870134*G0_0_1_4_1_5 - 0.00220779220779228*G0_0_1_4_2_0 - 0.000909090909090939*G0_0_1_4_2_1 + 0.0100649350649354*G0_0_1_4_2_2 + 0.0233766233766241*G0_0_1_4_2_4 + 0.00181818181818188*G0_0_1_4_2_5 - 0.00181818181818188*G0_0_1_4_3_0 + 0.00181818181818188*G0_0_1_4_3_1 + 0.000519480519480532*G0_0_1_4_3_3 - 0.000519480519480537*G0_0_1_4_3_4 - 0.0124675324675329*G0_0_1_4_4_0 + 0.00207792207792215*G0_0_1_4_4_1 + 0.0233766233766241*G0_0_1_4_4_2 - 0.000519480519480537*G0_0_1_4_4_3 - 0.00467532467532485*G0_0_1_4_4_4 - 0.00779220779220806*G0_0_1_4_4_5 - 0.00129870129870134*G0_0_1_4_5_0 + 0.00129870129870134*G0_0_1_4_5_1 + 0.00181818181818188*G0_0_1_4_5_2 - 0.00779220779220806*G0_0_1_4_5_4 - 0.00259740259740269*G0_0_1_4_5_5 + 0.000941558441558476*G0_0_1_5_0_0 + 0.000194805194805201*G0_0_1_5_0_2 - 0.00129870129870134*G0_0_1_5_0_3 - 0.00129870129870134*G0_0_1_5_0_4 + 0.000389610389610402*G0_0_1_5_0_5 - 0.000941558441558469*G0_0_1_5_1_1 - 0.000194805194805202*G0_0_1_5_1_2 + 0.00129870129870135*G0_0_1_5_1_3 + 0.00129870129870134*G0_0_1_5_1_4 - 0.000389610389610397*G0_0_1_5_1_5 + 0.000194805194805201*G0_0_1_5_2_0 - 0.000194805194805202*G0_0_1_5_2_1 - 0.00181818181818188*G0_0_1_5_2_3 + 0.00181818181818188*G0_0_1_5_2_4 - 0.00129870129870134*G0_0_1_5_3_0 + 0.00129870129870135*G0_0_1_5_3_1 - 0.00181818181818188*G0_0_1_5_3_2 + 0.00779220779220805*G0_0_1_5_3_3 + 0.00259740259740269*G0_0_1_5_3_5 - 0.00129870129870134*G0_0_1_5_4_0 + 0.00129870129870134*G0_0_1_5_4_1 + 0.00181818181818188*G0_0_1_5_4_2 - 0.00779220779220806*G0_0_1_5_4_4 - 0.00259740259740269*G0_0_1_5_4_5 + 0.000389610389610402*G0_0_1_5_5_0 - 0.000389610389610397*G0_0_1_5_5_1 + 0.00259740259740269*G0_0_1_5_5_3 - 0.00259740259740269*G0_0_1_5_5_4 + 0.00611201298701322*G0_1_1_0_0_0 - 0.000698051948051976*G0_1_1_0_0_1 - 0.000771103896103923*G0_1_1_0_0_2 + 0.000162337662337667*G0_1_1_0_0_3 + 0.000649350649350674*G0_1_1_0_0_4 + 0.00633116883116906*G0_1_1_0_0_5 - 0.000698051948051976*G0_1_1_0_1_0 - 0.000511363636363655*G0_1_1_0_1_1 - 0.000292207792207801*G0_1_1_0_1_2 - 0.00113636363636367*G0_1_1_0_1_3 - 0.000681818181818204*G0_1_1_0_1_4 - 0.00337662337662349*G0_1_1_0_1_5 - 0.000771103896103923*G0_1_1_0_2_0 - 0.000292207792207801*G0_1_1_0_2_1 + 0.00230519480519488*G0_1_1_0_2_2 + 0.00246753246753255*G0_1_1_0_2_3 + 0.00175324675324681*G0_1_1_0_2_4 + 0.000162337662337667*G0_1_1_0_2_5 + 0.000162337662337667*G0_1_1_0_3_0 - 0.00113636363636367*G0_1_1_0_3_1 + 0.00246753246753255*G0_1_1_0_3_2 + 0.000259740259740269*G0_1_1_0_3_3 + 0.00103896103896107*G0_1_1_0_3_4 - 0.000649350649350669*G0_1_1_0_3_5 + 0.000649350649350674*G0_1_1_0_4_0 - 0.000681818181818204*G0_1_1_0_4_1 + 0.00175324675324681*G0_1_1_0_4_2 + 0.00103896103896107*G0_1_1_0_4_3 + 0.00155844155844161*G0_1_1_0_4_4 + 0.00103896103896108*G0_1_1_0_4_5 + 0.00633116883116906*G0_1_1_0_5_0 - 0.00337662337662349*G0_1_1_0_5_1 + 0.000162337662337667*G0_1_1_0_5_2 - 0.000649350649350669*G0_1_1_0_5_3 + 0.00103896103896108*G0_1_1_0_5_4 + 0.00506493506493528*G0_1_1_0_5_5 - 0.000698051948051976*G0_1_1_1_0_0 - 0.000511363636363655*G0_1_1_1_0_1 - 0.000292207792207801*G0_1_1_1_0_2 - 0.00113636363636367*G0_1_1_1_0_3 - 0.000681818181818204*G0_1_1_1_0_4 - 0.00337662337662349*G0_1_1_1_0_5 - 0.000511363636363655*G0_1_1_1_1_0 + 0.00438311688311706*G0_1_1_1_1_1 - 0.00138798701298706*G0_1_1_1_1_2 + 0.000454545454545477*G0_1_1_1_1_3 - 0.000292207792207803*G0_1_1_1_1_4 + 0.00538961038961058*G0_1_1_1_1_5 - 0.000292207792207801*G0_1_1_1_2_0 - 0.00138798701298706*G0_1_1_1_2_1 + 0.00449675324675341*G0_1_1_1_2_2 + 0.0039610389610391*G0_1_1_1_2_3 + 0.00155844155844161*G0_1_1_1_2_4 - 3.24675324675334e-05*G0_1_1_1_2_5 - 0.00113636363636367*G0_1_1_1_3_0 + 0.000454545454545477*G0_1_1_1_3_1 + 0.0039610389610391*G0_1_1_1_3_2 + 0.0140259740259745*G0_1_1_1_3_3 + 0.00285714285714296*G0_1_1_1_3_4 + 0.00233766233766242*G0_1_1_1_3_5 - 0.000681818181818204*G0_1_1_1_4_0 - 0.000292207792207803*G0_1_1_1_4_1 + 0.00155844155844161*G0_1_1_1_4_2 + 0.00285714285714296*G0_1_1_1_4_3 + 0.00233766233766242*G0_1_1_1_4_4 + 0.000649350649350672*G0_1_1_1_4_5 - 0.00337662337662349*G0_1_1_1_5_0 + 0.00538961038961058*G0_1_1_1_5_1 - 3.24675324675334e-05*G0_1_1_1_5_2 + 0.00233766233766242*G0_1_1_1_5_3 + 0.000649350649350672*G0_1_1_1_5_4 + 0.00467532467532485*G0_1_1_1_5_5 - 0.000771103896103923*G0_1_1_2_0_0 - 0.000292207792207801*G0_1_1_2_0_1 + 0.00230519480519488*G0_1_1_2_0_2 + 0.00246753246753255*G0_1_1_2_0_3 + 0.00175324675324681*G0_1_1_2_0_4 + 0.000162337662337667*G0_1_1_2_0_5 - 0.000292207792207801*G0_1_1_2_1_0 - 0.00138798701298706*G0_1_1_2_1_1 + 0.00449675324675341*G0_1_1_2_1_2 + 0.0039610389610391*G0_1_1_2_1_3 + 0.00155844155844161*G0_1_1_2_1_4 - 3.24675324675334e-05*G0_1_1_2_1_5 + 0.00230519480519488*G0_1_1_2_2_0 + 0.00449675324675341*G0_1_1_2_2_1 - 0.0304383116883128*G0_1_1_2_2_2 - 0.0194805194805202*G0_1_1_2_2_3 - 0.00941558441558476*G0_1_1_2_2_4 - 0.00103896103896108*G0_1_1_2_2_5 + 0.00246753246753255*G0_1_1_2_3_0 + 0.0039610389610391*G0_1_1_2_3_1 - 0.0194805194805202*G0_1_1_2_3_2 - 0.0296103896103906*G0_1_1_2_3_3 - 0.00805194805194833*G0_1_1_2_3_4 - 0.00285714285714296*G0_1_1_2_3_5 + 0.00175324675324681*G0_1_1_2_4_0 + 0.00155844155844161*G0_1_1_2_4_1 - 0.00941558441558476*G0_1_1_2_4_2 - 0.00805194805194833*G0_1_1_2_4_3 - 0.00623376623376646*G0_1_1_2_4_4 - 0.00103896103896108*G0_1_1_2_4_5 + 0.000162337662337667*G0_1_1_2_5_0 - 3.24675324675334e-05*G0_1_1_2_5_1 - 0.00103896103896108*G0_1_1_2_5_2 - 0.00285714285714296*G0_1_1_2_5_3 - 0.00103896103896108*G0_1_1_2_5_4 - 0.00376623376623389*G0_1_1_2_5_5 + 0.000162337662337667*G0_1_1_3_0_0 - 0.00113636363636367*G0_1_1_3_0_1 + 0.00246753246753255*G0_1_1_3_0_2 + 0.000259740259740269*G0_1_1_3_0_3 + 0.00103896103896107*G0_1_1_3_0_4 - 0.000649350649350669*G0_1_1_3_0_5 - 0.00113636363636367*G0_1_1_3_1_0 + 0.000454545454545477*G0_1_1_3_1_1 + 0.0039610389610391*G0_1_1_3_1_2 + 0.0140259740259745*G0_1_1_3_1_3 + 0.00285714285714296*G0_1_1_3_1_4 + 0.00233766233766242*G0_1_1_3_1_5 + 0.00246753246753255*G0_1_1_3_2_0 + 0.0039610389610391*G0_1_1_3_2_1 - 0.0194805194805202*G0_1_1_3_2_2 - 0.0296103896103906*G0_1_1_3_2_3 - 0.00805194805194833*G0_1_1_3_2_4 - 0.00285714285714296*G0_1_1_3_2_5 + 0.000259740259740269*G0_1_1_3_3_0 + 0.0140259740259745*G0_1_1_3_3_1 - 0.0296103896103906*G0_1_1_3_3_2 - 0.00935064935064974*G0_1_1_3_3_3 - 0.00623376623376645*G0_1_1_3_3_4 + 0.00519480519480536*G0_1_1_3_3_5 + 0.00103896103896107*G0_1_1_3_4_0 + 0.00285714285714296*G0_1_1_3_4_1 - 0.00805194805194833*G0_1_1_3_4_2 - 0.00623376623376645*G0_1_1_3_4_3 - 0.00675324675324699*G0_1_1_3_4_4 - 0.000649350649350669*G0_1_1_3_5_0 + 0.00233766233766242*G0_1_1_3_5_1 - 0.00285714285714296*G0_1_1_3_5_2 + 0.00519480519480536*G0_1_1_3_5_3 + 0.00883116883116912*G0_1_1_3_5_5 + 0.000649350649350674*G0_1_1_4_0_0 - 0.000681818181818204*G0_1_1_4_0_1 + 0.00175324675324681*G0_1_1_4_0_2 + 0.00103896103896107*G0_1_1_4_0_3 + 0.00155844155844161*G0_1_1_4_0_4 + 0.00103896103896108*G0_1_1_4_0_5 - 0.000681818181818204*G0_1_1_4_1_0 - 0.000292207792207803*G0_1_1_4_1_1 + 0.00155844155844161*G0_1_1_4_1_2 + 0.00285714285714296*G0_1_1_4_1_3 + 0.00233766233766242*G0_1_1_4_1_4 + 0.000649350649350672*G0_1_1_4_1_5 + 0.00175324675324681*G0_1_1_4_2_0 + 0.00155844155844161*G0_1_1_4_2_1 - 0.00941558441558476*G0_1_1_4_2_2 - 0.00805194805194833*G0_1_1_4_2_3 - 0.00623376623376646*G0_1_1_4_2_4 - 0.00103896103896108*G0_1_1_4_2_5 + 0.00103896103896107*G0_1_1_4_3_0 + 0.00285714285714296*G0_1_1_4_3_1 - 0.00805194805194833*G0_1_1_4_3_2 - 0.00623376623376645*G0_1_1_4_3_3 - 0.00675324675324699*G0_1_1_4_3_4 + 0.00155844155844161*G0_1_1_4_4_0 + 0.00233766233766242*G0_1_1_4_4_1 - 0.00623376623376646*G0_1_1_4_4_2 - 0.00675324675324699*G0_1_1_4_4_3 - 0.0140259740259745*G0_1_1_4_4_4 - 0.00259740259740269*G0_1_1_4_4_5 + 0.00103896103896108*G0_1_1_4_5_0 + 0.000649350649350672*G0_1_1_4_5_1 - 0.00103896103896108*G0_1_1_4_5_2 - 0.00259740259740269*G0_1_1_4_5_4 + 0.00623376623376643*G0_1_1_4_5_5 + 0.00633116883116906*G0_1_1_5_0_0 - 0.00337662337662349*G0_1_1_5_0_1 + 0.000162337662337667*G0_1_1_5_0_2 - 0.000649350649350669*G0_1_1_5_0_3 + 0.00103896103896108*G0_1_1_5_0_4 + 0.00506493506493527*G0_1_1_5_0_5 - 0.00337662337662349*G0_1_1_5_1_0 + 0.00538961038961058*G0_1_1_5_1_1 - 3.24675324675334e-05*G0_1_1_5_1_2 + 0.00233766233766242*G0_1_1_5_1_3 + 0.000649350649350672*G0_1_1_5_1_4 + 0.00467532467532485*G0_1_1_5_1_5 + 0.000162337662337667*G0_1_1_5_2_0 - 3.24675324675334e-05*G0_1_1_5_2_1 - 0.00103896103896108*G0_1_1_5_2_2 - 0.00285714285714296*G0_1_1_5_2_3 - 0.00103896103896108*G0_1_1_5_2_4 - 0.00376623376623389*G0_1_1_5_2_5 - 0.000649350649350669*G0_1_1_5_3_0 + 0.00233766233766242*G0_1_1_5_3_1 - 0.00285714285714296*G0_1_1_5_3_2 + 0.00519480519480536*G0_1_1_5_3_3 + 0.00883116883116912*G0_1_1_5_3_5 + 0.00103896103896108*G0_1_1_5_4_0 + 0.000649350649350672*G0_1_1_5_4_1 - 0.00103896103896108*G0_1_1_5_4_2 - 0.00259740259740269*G0_1_1_5_4_4 + 0.00623376623376643*G0_1_1_5_4_5 + 0.00506493506493528*G0_1_1_5_5_0 + 0.00467532467532485*G0_1_1_5_5_1 - 0.00376623376623389*G0_1_1_5_5_2 + 0.00883116883116912*G0_1_1_5_5_3 + 0.00623376623376643*G0_1_1_5_5_4 + 0.107532467532471*G0_1_1_5_5_5;
    A[90] = A[92] - 0.0304383116883128*G0_0_0_0_0_0 + 0.00230519480519489*G0_0_0_0_0_1 + 0.00449675324675341*G0_0_0_0_0_2 - 0.00103896103896107*G0_0_0_0_0_3 - 0.0194805194805202*G0_0_0_0_0_4 - 0.00941558441558476*G0_0_0_0_0_5 + 0.00230519480519489*G0_0_0_0_1_0 - 0.000771103896103922*G0_0_0_0_1_1 - 0.000292207792207803*G0_0_0_0_1_2 + 0.000162337662337667*G0_0_0_0_1_3 + 0.00246753246753255*G0_0_0_0_1_4 + 0.00175324675324681*G0_0_0_0_1_5 + 0.00449675324675341*G0_0_0_0_2_0 - 0.000292207792207803*G0_0_0_0_2_1 - 0.00138798701298706*G0_0_0_0_2_2 + 0.0039610389610391*G0_0_0_0_2_4 + 0.00155844155844161*G0_0_0_0_2_5 - 0.00103896103896107*G0_0_0_0_3_0 + 0.000162337662337667*G0_0_0_0_3_1 - 0.00376623376623387*G0_0_0_0_3_3 - 0.00285714285714295*G0_0_0_0_3_4 - 0.00103896103896107*G0_0_0_0_3_5 - 0.0194805194805202*G0_0_0_0_4_0 + 0.00246753246753255*G0_0_0_0_4_1 + 0.0039610389610391*G0_0_0_0_4_2 - 0.00285714285714295*G0_0_0_0_4_3 - 0.0296103896103906*G0_0_0_0_4_4 - 0.00805194805194833*G0_0_0_0_4_5 - 0.00941558441558476*G0_0_0_0_5_0 + 0.00175324675324681*G0_0_0_0_5_1 + 0.00155844155844161*G0_0_0_0_5_2 - 0.00103896103896107*G0_0_0_0_5_3 - 0.00805194805194833*G0_0_0_0_5_4 - 0.00623376623376646*G0_0_0_0_5_5 + 0.00230519480519489*G0_0_0_1_0_0 - 0.000771103896103922*G0_0_0_1_0_1 - 0.000292207792207803*G0_0_0_1_0_2 + 0.000162337662337667*G0_0_0_1_0_3 + 0.00246753246753255*G0_0_0_1_0_4 + 0.00175324675324681*G0_0_0_1_0_5 - 0.000771103896103922*G0_0_0_1_1_0 + 0.00611201298701319*G0_0_0_1_1_1 - 0.000698051948051973*G0_0_0_1_1_2 + 0.00633116883116905*G0_0_0_1_1_3 + 0.000162337662337667*G0_0_0_1_1_4 + 0.000649350649350677*G0_0_0_1_1_5 - 0.000292207792207803*G0_0_0_1_2_0 - 0.000698051948051973*G0_0_0_1_2_1 - 0.000511363636363653*G0_0_0_1_2_2 - 0.00337662337662349*G0_0_0_1_2_3 - 0.00113636363636367*G0_0_0_1_2_4 - 0.000681818181818207*G0_0_0_1_2_5 + 0.000162337662337667*G0_0_0_1_3_0 + 0.00633116883116905*G0_0_0_1_3_1 - 0.00337662337662349*G0_0_0_1_3_2 + 0.00506493506493525*G0_0_0_1_3_3 - 0.00064935064935067*G0_0_0_1_3_4 + 0.00103896103896108*G0_0_0_1_3_5 + 0.00246753246753255*G0_0_0_1_4_0 + 0.000162337662337667*G0_0_0_1_4_1 - 0.00113636363636367*G0_0_0_1_4_2 - 0.00064935064935067*G0_0_0_1_4_3 + 0.000259740259740274*G0_0_0_1_4_4 + 0.00103896103896108*G0_0_0_1_4_5 + 0.00175324675324681*G0_0_0_1_5_0 + 0.000649350649350677*G0_0_0_1_5_1 - 0.000681818181818207*G0_0_0_1_5_2 + 0.00103896103896108*G0_0_0_1_5_3 + 0.00103896103896107*G0_0_0_1_5_4 + 0.00155844155844162*G0_0_0_1_5_5 + 0.00449675324675341*G0_0_0_2_0_0 - 0.000292207792207803*G0_0_0_2_0_1 - 0.00138798701298706*G0_0_0_2_0_2 + 0.0039610389610391*G0_0_0_2_0_4 + 0.00155844155844161*G0_0_0_2_0_5 - 0.000292207792207803*G0_0_0_2_1_0 - 0.000698051948051973*G0_0_0_2_1_1 - 0.000511363636363653*G0_0_0_2_1_2 - 0.00337662337662349*G0_0_0_2_1_3 - 0.00113636363636367*G0_0_0_2_1_4 - 0.000681818181818207*G0_0_0_2_1_5 - 0.00138798701298706*G0_0_0_2_2_0 - 0.000511363636363653*G0_0_0_2_2_1 + 0.00438311688311703*G0_0_0_2_2_2 + 0.00538961038961057*G0_0_0_2_2_3 + 0.000454545454545464*G0_0_0_2_2_4 - 0.000292207792207801*G0_0_0_2_2_5 - 0.00337662337662349*G0_0_0_2_3_1 + 0.00538961038961057*G0_0_0_2_3_2 + 0.00467532467532484*G0_0_0_2_3_3 + 0.00233766233766241*G0_0_0_2_3_4 + 0.000649350649350672*G0_0_0_2_3_5 + 0.0039610389610391*G0_0_0_2_4_0 - 0.00113636363636367*G0_0_0_2_4_1 + 0.000454545454545464*G0_0_0_2_4_2 + 0.00233766233766241*G0_0_0_2_4_3 + 0.0140259740259745*G0_0_0_2_4_4 + 0.00285714285714295*G0_0_0_2_4_5 + 0.00155844155844161*G0_0_0_2_5_0 - 0.000681818181818207*G0_0_0_2_5_1 - 0.000292207792207801*G0_0_0_2_5_2 + 0.000649350649350672*G0_0_0_2_5_3 + 0.00285714285714295*G0_0_0_2_5_4 + 0.00233766233766242*G0_0_0_2_5_5 - 0.00103896103896107*G0_0_0_3_0_0 + 0.000162337662337667*G0_0_0_3_0_1 - 0.00376623376623387*G0_0_0_3_0_3 - 0.00285714285714295*G0_0_0_3_0_4 - 0.00103896103896107*G0_0_0_3_0_5 + 0.000162337662337667*G0_0_0_3_1_0 + 0.00633116883116905*G0_0_0_3_1_1 - 0.00337662337662349*G0_0_0_3_1_2 + 0.00506493506493525*G0_0_0_3_1_3 - 0.00064935064935067*G0_0_0_3_1_4 + 0.00103896103896108*G0_0_0_3_1_5 - 0.00337662337662349*G0_0_0_3_2_1 + 0.00538961038961057*G0_0_0_3_2_2 + 0.00467532467532484*G0_0_0_3_2_3 + 0.00233766233766241*G0_0_0_3_2_4 + 0.000649350649350672*G0_0_0_3_2_5 - 0.00376623376623387*G0_0_0_3_3_0 + 0.00506493506493525*G0_0_0_3_3_1 + 0.00467532467532484*G0_0_0_3_3_2 + 0.107532467532471*G0_0_0_3_3_3 + 0.00883116883116912*G0_0_0_3_3_4 + 0.00623376623376645*G0_0_0_3_3_5 - 0.00285714285714295*G0_0_0_3_4_0 - 0.00064935064935067*G0_0_0_3_4_1 + 0.00233766233766241*G0_0_0_3_4_2 + 0.00883116883116912*G0_0_0_3_4_3 + 0.00519480519480536*G0_0_0_3_4_4 - 0.00103896103896107*G0_0_0_3_5_0 + 0.00103896103896108*G0_0_0_3_5_1 + 0.000649350649350672*G0_0_0_3_5_2 + 0.00623376623376645*G0_0_0_3_5_3 - 0.00259740259740268*G0_0_0_3_5_5 - 0.0194805194805202*G0_0_0_4_0_0 + 0.00246753246753255*G0_0_0_4_0_1 + 0.0039610389610391*G0_0_0_4_0_2 - 0.00285714285714295*G0_0_0_4_0_3 - 0.0296103896103906*G0_0_0_4_0_4 - 0.00805194805194833*G0_0_0_4_0_5 + 0.00246753246753255*G0_0_0_4_1_0 + 0.000162337662337667*G0_0_0_4_1_1 - 0.00113636363636367*G0_0_0_4_1_2 - 0.00064935064935067*G0_0_0_4_1_3 + 0.000259740259740274*G0_0_0_4_1_4 + 0.00103896103896108*G0_0_0_4_1_5 + 0.0039610389610391*G0_0_0_4_2_0 - 0.00113636363636367*G0_0_0_4_2_1 + 0.000454545454545464*G0_0_0_4_2_2 + 0.00233766233766241*G0_0_0_4_2_3 + 0.0140259740259745*G0_0_0_4_2_4 + 0.00285714285714295*G0_0_0_4_2_5 - 0.00285714285714295*G0_0_0_4_3_0 - 0.00064935064935067*G0_0_0_4_3_1 + 0.00233766233766241*G0_0_0_4_3_2 + 0.00883116883116912*G0_0_0_4_3_3 + 0.00519480519480536*G0_0_0_4_3_4 - 0.0296103896103906*G0_0_0_4_4_0 + 0.000259740259740274*G0_0_0_4_4_1 + 0.0140259740259745*G0_0_0_4_4_2 + 0.00519480519480537*G0_0_0_4_4_3 - 0.00935064935064967*G0_0_0_4_4_4 - 0.00623376623376644*G0_0_0_4_4_5 - 0.00805194805194833*G0_0_0_4_5_0 + 0.00103896103896108*G0_0_0_4_5_1 + 0.00285714285714295*G0_0_0_4_5_2 - 0.00623376623376644*G0_0_0_4_5_4 - 0.00675324675324699*G0_0_0_4_5_5 - 0.00941558441558476*G0_0_0_5_0_0 + 0.00175324675324681*G0_0_0_5_0_1 + 0.00155844155844161*G0_0_0_5_0_2 - 0.00103896103896107*G0_0_0_5_0_3 - 0.00805194805194833*G0_0_0_5_0_4 - 0.00623376623376646*G0_0_0_5_0_5 + 0.00175324675324681*G0_0_0_5_1_0 + 0.000649350649350677*G0_0_0_5_1_1 - 0.000681818181818207*G0_0_0_5_1_2 + 0.00103896103896108*G0_0_0_5_1_3 + 0.00103896103896107*G0_0_0_5_1_4 + 0.00155844155844162*G0_0_0_5_1_5 + 0.00155844155844161*G0_0_0_5_2_0 - 0.000681818181818207*G0_0_0_5_2_1 - 0.000292207792207801*G0_0_0_5_2_2 + 0.000649350649350672*G0_0_0_5_2_3 + 0.00285714285714295*G0_0_0_5_2_4 + 0.00233766233766242*G0_0_0_5_2_5 - 0.00103896103896107*G0_0_0_5_3_0 + 0.00103896103896108*G0_0_0_5_3_1 + 0.000649350649350672*G0_0_0_5_3_2 + 0.00623376623376645*G0_0_0_5_3_3 - 0.00259740259740268*G0_0_0_5_3_5 - 0.00805194805194833*G0_0_0_5_4_0 + 0.00103896103896107*G0_0_0_5_4_1 + 0.00285714285714295*G0_0_0_5_4_2 - 0.00623376623376644*G0_0_0_5_4_4 - 0.00675324675324699*G0_0_0_5_4_5 - 0.00623376623376646*G0_0_0_5_5_0 + 0.00155844155844162*G0_0_0_5_5_1 + 0.00233766233766242*G0_0_0_5_5_2 - 0.00259740259740268*G0_0_0_5_5_3 - 0.00675324675324699*G0_0_0_5_5_4 - 0.0140259740259745*G0_0_0_5_5_5 - 0.032167207792209*G0_0_1_0_0_0 + 0.00249188311688321*G0_0_1_0_0_1 + 0.00387987012987027*G0_0_1_0_0_2 - 0.00149350649350654*G0_0_1_0_0_3 - 0.0196753246753254*G0_0_1_0_0_4 - 0.0103571428571432*G0_0_1_0_0_5 + 0.00249188311688321*G0_0_1_0_1_0 - 0.000957792207792239*G0_0_1_0_1_1 - 0.000292207792207804*G0_0_1_0_1_2 + 0.000616883116883135*G0_0_1_0_1_3 + 0.00201298701298708*G0_0_1_0_1_4 + 0.00175324675324682*G0_0_1_0_1_5 + 0.00387987012987027*G0_0_1_0_2_0 - 0.000292207792207804*G0_0_1_0_2_1 + 0.000803571428571455*G0_0_1_0_2_2 - 0.000941558441558467*G0_0_1_0_2_3 + 0.00616883116883138*G0_0_1_0_2_4 + 0.00136363636363641*G0_0_1_0_2_5 - 0.00149350649350654*G0_0_1_0_3_0 + 0.000616883116883135*G0_0_1_0_3_1 - 0.000941558441558467*G0_0_1_0_3_2 - 0.00168831168831173*G0_0_1_0_3_3 - 0.00103896103896107*G0_0_1_0_3_4 + 0.000259740259740266*G0_0_1_0_3_5 - 0.0196753246753254*G0_0_1_0_4_0 + 0.00201298701298708*G0_0_1_0_4_1 + 0.00616883116883137*G0_0_1_0_4_2 - 0.00103896103896107*G0_0_1_0_4_3 - 0.0171428571428577*G0_0_1_0_4_4 - 0.00675324675324699*G0_0_1_0_4_5 - 0.0103571428571432*G0_0_1_0_5_0 + 0.00175324675324682*G0_0_1_0_5_1 + 0.00136363636363641*G0_0_1_0_5_2 + 0.000259740259740266*G0_0_1_0_5_3 - 0.00675324675324699*G0_0_1_0_5_4 - 0.00662337662337686*G0_0_1_0_5_5 + 0.00249188311688321*G0_0_1_1_0_0 - 0.000957792207792239*G0_0_1_1_0_1 - 0.000292207792207803*G0_0_1_1_0_2 + 0.000616883116883135*G0_0_1_1_0_3 + 0.00201298701298708*G0_0_1_1_0_4 + 0.00175324675324682*G0_0_1_1_0_5 - 0.000957792207792239*G0_0_1_1_1_0 + 0.00784090909090933*G0_0_1_1_1_1 + 0.00652597402597424*G0_0_1_1_1_3 + 0.000616883116883137*G0_0_1_1_1_4 + 0.00159090909090915*G0_0_1_1_1_5 - 0.000292207792207804*G0_0_1_1_2_0 - 0.00270292207792217*G0_0_1_1_2_2 - 0.00558441558441577*G0_0_1_1_2_3 - 0.000227272727272736*G0_0_1_1_2_4 - 0.000487012987013005*G0_0_1_1_2_5 + 0.000616883116883135*G0_0_1_1_3_0 + 0.00652597402597424*G0_0_1_1_3_1 - 0.00558441558441577*G0_0_1_1_3_2 - 0.00740259740259766*G0_0_1_1_3_3 - 0.00246753246753255*G0_0_1_1_3_4 - 0.000259740259740269*G0_0_1_1_3_5 + 0.00201298701298708*G0_0_1_1_4_0 + 0.000616883116883137*G0_0_1_1_4_1 - 0.000227272727272736*G0_0_1_1_4_2 - 0.00246753246753255*G0_0_1_1_4_3 - 0.00181818181818188*G0_0_1_1_4_4 - 0.000259740259740269*G0_0_1_1_4_5 + 0.00175324675324682*G0_0_1_1_5_0 + 0.00159090909090915*G0_0_1_1_5_1 - 0.000487012987013005*G0_0_1_1_5_2 - 0.000259740259740269*G0_0_1_1_5_3 - 0.000259740259740269*G0_0_1_1_5_4 + 0.00194805194805201*G0_0_1_1_5_5 + 0.00387987012987027*G0_0_1_2_0_0 - 0.000292207792207804*G0_0_1_2_0_1 + 0.000803571428571454*G0_0_1_2_0_2 - 0.000941558441558467*G0_0_1_2_0_3 + 0.00616883116883137*G0_0_1_2_0_4 + 0.00136363636363641*G0_0_1_2_0_5 - 0.000292207792207804*G0_0_1_2_1_0 - 0.00270292207792217*G0_0_1_2_1_2 - 0.00558441558441577*G0_0_1_2_1_3 - 0.000227272727272736*G0_0_1_2_1_4 - 0.000487012987013005*G0_0_1_2_1_5 + 0.000803571428571454*G0_0_1_2_2_0 - 0.00270292207792217*G0_0_1_2_2_1 + 0.00438311688311705*G0_0_1_2_2_2 + 0.015454545454546*G0_0_1_2_2_3 - 0.00961038961038993*G0_0_1_2_2_4 - 0.000292207792207801*G0_0_1_2_2_5 - 0.000941558441558467*G0_0_1_2_3_0 - 0.00558441558441577*G0_0_1_2_3_1 + 0.015454545454546*G0_0_1_2_3_2 + 0.028051948051949*G0_0_1_2_3_3 + 0.00233766233766242*G0_0_1_2_3_4 + 0.00246753246753255*G0_0_1_2_3_5 + 0.00616883116883137*G0_0_1_2_4_0 - 0.000227272727272736*G0_0_1_2_4_1 - 0.00961038961038993*G0_0_1_2_4_2 + 0.00233766233766241*G0_0_1_2_4_3 - 0.00935064935064965*G0_0_1_2_4_4 + 0.00103896103896107*G0_0_1_2_4_5 + 0.00136363636363641*G0_0_1_2_5_0 - 0.000487012987013005*G0_0_1_2_5_1 - 0.000292207792207801*G0_0_1_2_5_2 + 0.00246753246753255*G0_0_1_2_5_3 + 0.00103896103896107*G0_0_1_2_5_4 + 0.00233766233766242*G0_0_1_2_5_5 - 0.00149350649350654*G0_0_1_3_0_0 + 0.000616883116883135*G0_0_1_3_0_1 - 0.000941558441558467*G0_0_1_3_0_2 - 0.00168831168831173*G0_0_1_3_0_3 - 0.00103896103896107*G0_0_1_3_0_4 + 0.000259740259740266*G0_0_1_3_0_5 + 0.000616883116883135*G0_0_1_3_1_0 + 0.00652597402597424*G0_0_1_3_1_1 - 0.00558441558441577*G0_0_1_3_1_2 - 0.00740259740259766*G0_0_1_3_1_3 - 0.00246753246753255*G0_0_1_3_1_4 - 0.000259740259740269*G0_0_1_3_1_5 - 0.000941558441558467*G0_0_1_3_2_0 - 0.00558441558441577*G0_0_1_3_2_1 + 0.015454545454546*G0_0_1_3_2_2 + 0.028051948051949*G0_0_1_3_2_3 + 0.00233766233766242*G0_0_1_3_2_4 + 0.00246753246753255*G0_0_1_3_2_5 - 0.00168831168831173*G0_0_1_3_3_0 - 0.00740259740259765*G0_0_1_3_3_1 + 0.028051948051949*G0_0_1_3_3_2 + 0.102857142857146*G0_0_1_3_3_3 + 0.0083116883116886*G0_0_1_3_3_4 - 0.00155844155844158*G0_0_1_3_3_5 - 0.00103896103896107*G0_0_1_3_4_0 - 0.00246753246753255*G0_0_1_3_4_1 + 0.00233766233766242*G0_0_1_3_4_2 + 0.0083116883116886*G0_0_1_3_4_3 + 0.00571428571428591*G0_0_1_3_4_4 + 0.000259740259740267*G0_0_1_3_5_0 - 0.000259740259740269*G0_0_1_3_5_1 + 0.00246753246753255*G0_0_1_3_5_2 - 0.00155844155844158*G0_0_1_3_5_3 - 0.00519480519480537*G0_0_1_3_5_5 - 0.0196753246753254*G0_0_1_4_0_0 + 0.00201298701298708*G0_0_1_4_0_1 + 0.00616883116883137*G0_0_1_4_0_2 - 0.00103896103896107*G0_0_1_4_0_3 - 0.0171428571428577*G0_0_1_4_0_4 - 0.00675324675324699*G0_0_1_4_0_5 + 0.00201298701298708*G0_0_1_4_1_0 + 0.000616883116883137*G0_0_1_4_1_1 - 0.000227272727272736*G0_0_1_4_1_2 - 0.00246753246753255*G0_0_1_4_1_3 - 0.00181818181818188*G0_0_1_4_1_4 - 0.000259740259740269*G0_0_1_4_1_5 + 0.00616883116883138*G0_0_1_4_2_0 - 0.000227272727272736*G0_0_1_4_2_1 - 0.00961038961038993*G0_0_1_4_2_2 + 0.00233766233766242*G0_0_1_4_2_3 - 0.00935064935064965*G0_0_1_4_2_4 + 0.00103896103896107*G0_0_1_4_2_5 - 0.00103896103896107*G0_0_1_4_3_0 - 0.00246753246753255*G0_0_1_4_3_1 + 0.00233766233766242*G0_0_1_4_3_2 + 0.0083116883116886*G0_0_1_4_3_3 + 0.00571428571428591*G0_0_1_4_3_4 - 0.0171428571428577*G0_0_1_4_4_0 - 0.00181818181818188*G0_0_1_4_4_1 - 0.00935064935064965*G0_0_1_4_4_2 + 0.00571428571428591*G0_0_1_4_4_3 - 0.00467532467532481*G0_0_1_4_4_4 + 0.00155844155844161*G0_0_1_4_4_5 - 0.00675324675324699*G0_0_1_4_5_0 - 0.000259740259740269*G0_0_1_4_5_1 + 0.00103896103896107*G0_0_1_4_5_2 + 0.00155844155844161*G0_0_1_4_5_4 - 0.00415584415584431*G0_0_1_4_5_5 - 0.0103571428571432*G0_0_1_5_0_0 + 0.00175324675324682*G0_0_1_5_0_1 + 0.00136363636363641*G0_0_1_5_0_2 + 0.000259740259740266*G0_0_1_5_0_3 - 0.00675324675324699*G0_0_1_5_0_4 - 0.00662337662337686*G0_0_1_5_0_5 + 0.00175324675324682*G0_0_1_5_1_0 + 0.00159090909090915*G0_0_1_5_1_1 - 0.000487012987013005*G0_0_1_5_1_2 - 0.000259740259740269*G0_0_1_5_1_3 - 0.00025974025974027*G0_0_1_5_1_4 + 0.00194805194805201*G0_0_1_5_1_5 + 0.00136363636363641*G0_0_1_5_2_0 - 0.000487012987013005*G0_0_1_5_2_1 - 0.000292207792207801*G0_0_1_5_2_2 + 0.00246753246753255*G0_0_1_5_2_3 + 0.00103896103896107*G0_0_1_5_2_4 + 0.00233766233766242*G0_0_1_5_2_5 + 0.000259740259740266*G0_0_1_5_3_0 - 0.000259740259740269*G0_0_1_5_3_1 + 0.00246753246753255*G0_0_1_5_3_2 - 0.00155844155844158*G0_0_1_5_3_3 - 0.00519480519480537*G0_0_1_5_3_5 - 0.00675324675324699*G0_0_1_5_4_0 - 0.00025974025974027*G0_0_1_5_4_1 + 0.00103896103896107*G0_0_1_5_4_2 + 0.00155844155844161*G0_0_1_5_4_4 - 0.0041558441558443*G0_0_1_5_4_5 - 0.00662337662337686*G0_0_1_5_5_0 + 0.00194805194805201*G0_0_1_5_5_1 + 0.00233766233766242*G0_0_1_5_5_2 - 0.00519480519480537*G0_0_1_5_5_3 - 0.0041558441558443*G0_0_1_5_5_4 - 0.0140259740259745*G0_0_1_5_5_5 - 0.0304383116883129*G0_1_0_0_0_0 + 0.00449675324675342*G0_1_0_0_0_1 + 0.00230519480519489*G0_1_0_0_0_2 - 0.00103896103896108*G0_1_0_0_0_3 - 0.00941558441558477*G0_1_0_0_0_4 - 0.0194805194805202*G0_1_0_0_0_5 + 0.00449675324675342*G0_1_0_0_1_0 - 0.00138798701298706*G0_1_0_0_1_1 - 0.000292207792207804*G0_1_0_0_1_2 + 0.00155844155844161*G0_1_0_0_1_4 + 0.00396103896103911*G0_1_0_0_1_5 + 0.00230519480519489*G0_1_0_0_2_0 - 0.000292207792207804*G0_1_0_0_2_1 - 0.000771103896103924*G0_1_0_0_2_2 + 0.000162337662337668*G0_1_0_0_2_3 + 0.00175324675324682*G0_1_0_0_2_4 + 0.00246753246753256*G0_1_0_0_2_5 - 0.00103896103896108*G0_1_0_0_3_0 + 0.000162337662337668*G0_1_0_0_3_2 - 0.00376623376623387*G0_1_0_0_3_3 - 0.00103896103896107*G0_1_0_0_3_4 - 0.00285714285714295*G0_1_0_0_3_5 - 0.00941558441558477*G0_1_0_0_4_0 + 0.00155844155844161*G0_1_0_0_4_1 + 0.00175324675324682*G0_1_0_0_4_2 - 0.00103896103896107*G0_1_0_0_4_3 - 0.00623376623376646*G0_1_0_0_4_4 - 0.00805194805194834*G0_1_0_0_4_5 - 0.0194805194805202*G0_1_0_0_5_0 + 0.00396103896103911*G0_1_0_0_5_1 + 0.00246753246753256*G0_1_0_0_5_2 - 0.00285714285714295*G0_1_0_0_5_3 - 0.00805194805194834*G0_1_0_0_5_4 - 0.0296103896103907*G0_1_0_0_5_5 + 0.00449675324675342*G0_1_0_1_0_0 - 0.00138798701298706*G0_1_0_1_0_1 - 0.000292207792207804*G0_1_0_1_0_2 + 0.00155844155844161*G0_1_0_1_0_4 + 0.00396103896103911*G0_1_0_1_0_5 - 0.00138798701298706*G0_1_0_1_1_0 + 0.00438311688311701*G0_1_0_1_1_1 - 0.000511363636363653*G0_1_0_1_1_2 + 0.00538961038961057*G0_1_0_1_1_3 - 0.000292207792207803*G0_1_0_1_1_4 + 0.000454545454545468*G0_1_0_1_1_5 - 0.000292207792207804*G0_1_0_1_2_0 - 0.000511363636363653*G0_1_0_1_2_1 - 0.000698051948051974*G0_1_0_1_2_2 - 0.00337662337662349*G0_1_0_1_2_3 - 0.000681818181818206*G0_1_0_1_2_4 - 0.00113636363636368*G0_1_0_1_2_5 + 0.00538961038961057*G0_1_0_1_3_1 - 0.00337662337662349*G0_1_0_1_3_2 + 0.00467532467532484*G0_1_0_1_3_3 + 0.000649350649350671*G0_1_0_1_3_4 + 0.00233766233766242*G0_1_0_1_3_5 + 0.00155844155844161*G0_1_0_1_4_0 - 0.000292207792207803*G0_1_0_1_4_1 - 0.000681818181818206*G0_1_0_1_4_2 + 0.000649350649350671*G0_1_0_1_4_3 + 0.00233766233766242*G0_1_0_1_4_4 + 0.00285714285714296*G0_1_0_1_4_5 + 0.00396103896103911*G0_1_0_1_5_0 + 0.000454545454545468*G0_1_0_1_5_1 - 0.00113636363636368*G0_1_0_1_5_2 + 0.00233766233766242*G0_1_0_1_5_3 + 0.00285714285714296*G0_1_0_1_5_4 + 0.0140259740259745*G0_1_0_1_5_5 + 0.00230519480519489*G0_1_0_2_0_0 - 0.000292207792207804*G0_1_0_2_0_1 - 0.000771103896103924*G0_1_0_2_0_2 + 0.000162337662337668*G0_1_0_2_0_3 + 0.00175324675324682*G0_1_0_2_0_4 + 0.00246753246753256*G0_1_0_2_0_5 - 0.000292207792207804*G0_1_0_2_1_0 - 0.000511363636363653*G0_1_0_2_1_1 - 0.000698051948051974*G0_1_0_2_1_2 - 0.00337662337662349*G0_1_0_2_1_3 - 0.000681818181818206*G0_1_0_2_1_4 - 0.00113636363636368*G0_1_0_2_1_5 - 0.000771103896103924*G0_1_0_2_2_0 - 0.000698051948051974*G0_1_0_2_2_1 + 0.00611201298701322*G0_1_0_2_2_2 + 0.00633116883116906*G0_1_0_2_2_3 + 0.000649350649350676*G0_1_0_2_2_4 + 0.000162337662337669*G0_1_0_2_2_5 + 0.000162337662337668*G0_1_0_2_3_0 - 0.00337662337662349*G0_1_0_2_3_1 + 0.00633116883116906*G0_1_0_2_3_2 + 0.00506493506493525*G0_1_0_2_3_3 + 0.00103896103896108*G0_1_0_2_3_4 - 0.000649350649350669*G0_1_0_2_3_5 + 0.00175324675324682*G0_1_0_2_4_0 - 0.000681818181818206*G0_1_0_2_4_1 + 0.000649350649350676*G0_1_0_2_4_2 + 0.00103896103896108*G0_1_0_2_4_3 + 0.00155844155844162*G0_1_0_2_4_4 + 0.00103896103896108*G0_1_0_2_4_5 + 0.00246753246753256*G0_1_0_2_5_0 - 0.00113636363636368*G0_1_0_2_5_1 + 0.000162337662337669*G0_1_0_2_5_2 - 0.000649350649350669*G0_1_0_2_5_3 + 0.00103896103896108*G0_1_0_2_5_4 + 0.000259740259740273*G0_1_0_2_5_5 - 0.00103896103896108*G0_1_0_3_0_0 + 0.000162337662337668*G0_1_0_3_0_2 - 0.00376623376623387*G0_1_0_3_0_3 - 0.00103896103896107*G0_1_0_3_0_4 - 0.00285714285714295*G0_1_0_3_0_5 + 0.00538961038961057*G0_1_0_3_1_1 - 0.00337662337662349*G0_1_0_3_1_2 + 0.00467532467532484*G0_1_0_3_1_3 + 0.000649350649350671*G0_1_0_3_1_4 + 0.00233766233766242*G0_1_0_3_1_5 + 0.000162337662337668*G0_1_0_3_2_0 - 0.00337662337662349*G0_1_0_3_2_1 + 0.00633116883116906*G0_1_0_3_2_2 + 0.00506493506493525*G0_1_0_3_2_3 + 0.00103896103896108*G0_1_0_3_2_4 - 0.000649350649350669*G0_1_0_3_2_5 - 0.00376623376623387*G0_1_0_3_3_0 + 0.00467532467532483*G0_1_0_3_3_1 + 0.00506493506493526*G0_1_0_3_3_2 + 0.107532467532471*G0_1_0_3_3_3 + 0.00623376623376644*G0_1_0_3_3_4 + 0.00883116883116914*G0_1_0_3_3_5 - 0.00103896103896107*G0_1_0_3_4_0 + 0.000649350649350671*G0_1_0_3_4_1 + 0.00103896103896108*G0_1_0_3_4_2 + 0.00623376623376644*G0_1_0_3_4_3 - 0.00259740259740269*G0_1_0_3_4_4 - 0.00285714285714295*G0_1_0_3_5_0 + 0.00233766233766242*G0_1_0_3_5_1 - 0.000649350649350669*G0_1_0_3_5_2 + 0.00883116883116914*G0_1_0_3_5_3 + 0.00519480519480537*G0_1_0_3_5_5 - 0.00941558441558477*G0_1_0_4_0_0 + 0.00155844155844161*G0_1_0_4_0_1 + 0.00175324675324682*G0_1_0_4_0_2 - 0.00103896103896107*G0_1_0_4_0_3 - 0.00623376623376646*G0_1_0_4_0_4 - 0.00805194805194834*G0_1_0_4_0_5 + 0.00155844155844161*G0_1_0_4_1_0 - 0.000292207792207803*G0_1_0_4_1_1 - 0.000681818181818206*G0_1_0_4_1_2 + 0.000649350649350671*G0_1_0_4_1_3 + 0.00233766233766242*G0_1_0_4_1_4 + 0.00285714285714296*G0_1_0_4_1_5 + 0.00175324675324682*G0_1_0_4_2_0 - 0.000681818181818206*G0_1_0_4_2_1 + 0.000649350649350676*G0_1_0_4_2_2 + 0.00103896103896108*G0_1_0_4_2_3 + 0.00155844155844162*G0_1_0_4_2_4 + 0.00103896103896108*G0_1_0_4_2_5 - 0.00103896103896107*G0_1_0_4_3_0 + 0.000649350649350671*G0_1_0_4_3_1 + 0.00103896103896108*G0_1_0_4_3_2 + 0.00623376623376644*G0_1_0_4_3_3 - 0.00259740259740269*G0_1_0_4_3_4 - 0.00623376623376646*G0_1_0_4_4_0 + 0.00233766233766242*G0_1_0_4_4_1 + 0.00155844155844161*G0_1_0_4_4_2 - 0.00259740259740269*G0_1_0_4_4_3 - 0.0140259740259745*G0_1_0_4_4_4 - 0.00675324675324699*G0_1_0_4_4_5 - 0.00805194805194834*G0_1_0_4_5_0 + 0.00285714285714296*G0_1_0_4_5_1 + 0.00103896103896108*G0_1_0_4_5_2 - 0.00675324675324699*G0_1_0_4_5_4 - 0.00623376623376646*G0_1_0_4_5_5 - 0.0194805194805202*G0_1_0_5_0_0 + 0.00396103896103911*G0_1_0_5_0_1 + 0.00246753246753256*G0_1_0_5_0_2 - 0.00285714285714295*G0_1_0_5_0_3 - 0.00805194805194834*G0_1_0_5_0_4 - 0.0296103896103907*G0_1_0_5_0_5 + 0.00396103896103911*G0_1_0_5_1_0 + 0.000454545454545468*G0_1_0_5_1_1 - 0.00113636363636368*G0_1_0_5_1_2 + 0.00233766233766242*G0_1_0_5_1_3 + 0.00285714285714296*G0_1_0_5_1_4 + 0.0140259740259745*G0_1_0_5_1_5 + 0.00246753246753256*G0_1_0_5_2_0 - 0.00113636363636368*G0_1_0_5_2_1 + 0.000162337662337669*G0_1_0_5_2_2 - 0.000649350649350669*G0_1_0_5_2_3 + 0.00103896103896108*G0_1_0_5_2_4 + 0.000259740259740273*G0_1_0_5_2_5 - 0.00285714285714295*G0_1_0_5_3_0 + 0.00233766233766242*G0_1_0_5_3_1 - 0.000649350649350669*G0_1_0_5_3_2 + 0.00883116883116914*G0_1_0_5_3_3 + 0.00519480519480537*G0_1_0_5_3_5 - 0.00805194805194834*G0_1_0_5_4_0 + 0.00285714285714296*G0_1_0_5_4_1 + 0.00103896103896108*G0_1_0_5_4_2 - 0.00675324675324699*G0_1_0_5_4_4 - 0.00623376623376646*G0_1_0_5_4_5 - 0.0296103896103907*G0_1_0_5_5_0 + 0.0140259740259745*G0_1_0_5_5_1 + 0.000259740259740273*G0_1_0_5_5_2 + 0.00519480519480537*G0_1_0_5_5_3 - 0.00623376623376646*G0_1_0_5_5_4 - 0.00935064935064973*G0_1_0_5_5_5 - 0.0365503246753262*G0_1_1_0_0_0 + 0.00519480519480539*G0_1_1_0_0_1 + 0.00307629870129882*G0_1_1_0_0_2 - 0.00120129870129874*G0_1_1_0_0_3 - 0.0100649350649354*G0_1_1_0_0_4 - 0.0258116883116893*G0_1_1_0_0_5 + 0.00519480519480539*G0_1_1_0_1_0 - 0.000876623376623406*G0_1_1_0_1_1 + 0.00110389610389614*G0_1_1_0_1_3 + 0.00224025974025982*G0_1_1_0_1_4 + 0.0073376623376626*G0_1_1_0_1_5 + 0.00307629870129882*G0_1_1_0_2_0 - 0.00307629870129881*G0_1_1_0_2_2 - 0.00230519480519488*G0_1_1_0_2_3 + 0.00230519480519489*G0_1_1_0_2_5 - 0.00120129870129874*G0_1_1_0_3_0 + 0.00110389610389614*G0_1_1_0_3_1 - 0.00230519480519488*G0_1_1_0_3_2 - 0.00402597402597415*G0_1_1_0_3_3 - 0.00207792207792215*G0_1_1_0_3_4 - 0.00220779220779228*G0_1_1_0_3_5 - 0.0100649350649354*G0_1_1_0_4_0 + 0.00224025974025982*G0_1_1_0_4_1 - 0.00207792207792215*G0_1_1_0_4_3 - 0.00779220779220808*G0_1_1_0_4_4 - 0.00909090909090942*G0_1_1_0_4_5 - 0.0258116883116893*G0_1_1_0_5_0 + 0.0073376623376626*G0_1_1_0_5_1 + 0.00230519480519489*G0_1_1_0_5_2 - 0.00220779220779228*G0_1_1_0_5_3 - 0.00909090909090942*G0_1_1_0_5_4 - 0.034675324675326*G0_1_1_0_5_5 + 0.00519480519480539*G0_1_1_1_0_0 - 0.000876623376623406*G0_1_1_1_0_1 + 0.00110389610389614*G0_1_1_1_0_3 + 0.00224025974025982*G0_1_1_1_0_4 + 0.0073376623376626*G0_1_1_1_0_5 - 0.000876623376623406*G0_1_1_1_1_0 + 0.000876623376623411*G0_1_1_1_1_2 + 0.00493506493506509*G0_1_1_1_1_3 - 0.00493506493506512*G0_1_1_1_1_5 + 0.000876623376623411*G0_1_1_1_2_1 - 0.00519480519480538*G0_1_1_1_2_2 - 0.00733766233766259*G0_1_1_1_2_3 - 0.00224025974025982*G0_1_1_1_2_4 - 0.00110389610389614*G0_1_1_1_2_5 + 0.00110389610389614*G0_1_1_1_3_0 + 0.00493506493506509*G0_1_1_1_3_1 - 0.00733766233766259*G0_1_1_1_3_2 - 0.00935064935064968*G0_1_1_1_3_3 - 0.00220779220779228*G0_1_1_1_3_4 + 0.00224025974025982*G0_1_1_1_4_0 - 0.00224025974025982*G0_1_1_1_4_2 - 0.00220779220779228*G0_1_1_1_4_3 + 0.00220779220779229*G0_1_1_1_4_5 + 0.0073376623376626*G0_1_1_1_5_0 - 0.00493506493506512*G0_1_1_1_5_1 - 0.00110389610389614*G0_1_1_1_5_2 + 0.00220779220779229*G0_1_1_1_5_4 + 0.00935064935064969*G0_1_1_1_5_5 + 0.00307629870129882*G0_1_1_2_0_0 - 0.00307629870129881*G0_1_1_2_0_2 - 0.00230519480519488*G0_1_1_2_0_3 + 0.00230519480519489*G0_1_1_2_0_5 + 0.000876623376623411*G0_1_1_2_1_1 - 0.00519480519480538*G0_1_1_2_1_2 - 0.00733766233766259*G0_1_1_2_1_3 - 0.00224025974025982*G0_1_1_2_1_4 - 0.00110389610389614*G0_1_1_2_1_5 - 0.00307629870129881*G0_1_1_2_2_0 - 0.00519480519480538*G0_1_1_2_2_1 + 0.036550324675326*G0_1_1_2_2_2 + 0.0258116883116892*G0_1_1_2_2_3 + 0.0100649350649354*G0_1_1_2_2_4 + 0.00120129870129875*G0_1_1_2_2_5 - 0.00230519480519488*G0_1_1_2_3_0 - 0.00733766233766259*G0_1_1_2_3_1 + 0.0258116883116892*G0_1_1_2_3_2 + 0.0346753246753259*G0_1_1_2_3_3 + 0.00909090909090941*G0_1_1_2_3_4 + 0.00220779220779229*G0_1_1_2_3_5 - 0.00224025974025982*G0_1_1_2_4_1 + 0.0100649350649354*G0_1_1_2_4_2 + 0.00909090909090941*G0_1_1_2_4_3 + 0.00779220779220808*G0_1_1_2_4_4 + 0.00207792207792216*G0_1_1_2_4_5 + 0.00230519480519489*G0_1_1_2_5_0 - 0.00110389610389614*G0_1_1_2_5_1 + 0.00120129870129875*G0_1_1_2_5_2 + 0.00220779220779229*G0_1_1_2_5_3 + 0.00207792207792216*G0_1_1_2_5_4 + 0.00402597402597417*G0_1_1_2_5_5 - 0.00120129870129874*G0_1_1_3_0_0 + 0.00110389610389614*G0_1_1_3_0_1 - 0.00230519480519488*G0_1_1_3_0_2 - 0.00402597402597415*G0_1_1_3_0_3 - 0.00207792207792215*G0_1_1_3_0_4 - 0.00220779220779228*G0_1_1_3_0_5 + 0.00110389610389614*G0_1_1_3_1_0 + 0.00493506493506509*G0_1_1_3_1_1 - 0.00733766233766259*G0_1_1_3_1_2 - 0.00935064935064969*G0_1_1_3_1_3 - 0.00220779220779228*G0_1_1_3_1_4 - 0.00230519480519488*G0_1_1_3_2_0 - 0.00733766233766259*G0_1_1_3_2_1 + 0.0258116883116892*G0_1_1_3_2_2 + 0.0346753246753259*G0_1_1_3_2_3 + 0.00909090909090941*G0_1_1_3_2_4 + 0.00220779220779229*G0_1_1_3_2_5 - 0.00402597402597414*G0_1_1_3_3_0 - 0.00935064935064968*G0_1_1_3_3_1 + 0.0346753246753259*G0_1_1_3_3_2 + 0.116883116883121*G0_1_1_3_3_3 + 0.0124675324675329*G0_1_1_3_3_4 + 0.00363636363636378*G0_1_1_3_3_5 - 0.00207792207792215*G0_1_1_3_4_0 - 0.00220779220779228*G0_1_1_3_4_1 + 0.00909090909090941*G0_1_1_3_4_2 + 0.0124675324675329*G0_1_1_3_4_3 + 0.0041558441558443*G0_1_1_3_4_4 - 0.00220779220779228*G0_1_1_3_5_0 + 0.00220779220779229*G0_1_1_3_5_2 + 0.00363636363636378*G0_1_1_3_5_3 - 0.00363636363636376*G0_1_1_3_5_5 - 0.0100649350649354*G0_1_1_4_0_0 + 0.00224025974025982*G0_1_1_4_0_1 - 0.00207792207792215*G0_1_1_4_0_3 - 0.00779220779220808*G0_1_1_4_0_4 - 0.00909090909090942*G0_1_1_4_0_5 + 0.00224025974025982*G0_1_1_4_1_0 - 0.00224025974025982*G0_1_1_4_1_2 - 0.00220779220779228*G0_1_1_4_1_3 + 0.00220779220779229*G0_1_1_4_1_5 - 0.00224025974025982*G0_1_1_4_2_1 + 0.0100649350649354*G0_1_1_4_2_2 + 0.00909090909090941*G0_1_1_4_2_3 + 0.00779220779220807*G0_1_1_4_2_4 + 0.00207792207792216*G0_1_1_4_2_5 - 0.00207792207792215*G0_1_1_4_3_0 - 0.00220779220779228*G0_1_1_4_3_1 + 0.00909090909090941*G0_1_1_4_3_2 + 0.0124675324675329*G0_1_1_4_3_3 + 0.0041558441558443*G0_1_1_4_3_4 - 0.00779220779220808*G0_1_1_4_4_0 + 0.00779220779220807*G0_1_1_4_4_2 + 0.0041558441558443*G0_1_1_4_4_3 - 0.00415584415584431*G0_1_1_4_4_5 - 0.00909090909090942*G0_1_1_4_5_0 + 0.00220779220779229*G0_1_1_4_5_1 + 0.00207792207792216*G0_1_1_4_5_2 - 0.00415584415584431*G0_1_1_4_5_4 - 0.0124675324675329*G0_1_1_4_5_5 - 0.0258116883116893*G0_1_1_5_0_0 + 0.0073376623376626*G0_1_1_5_0_1 + 0.00230519480519489*G0_1_1_5_0_2 - 0.00220779220779228*G0_1_1_5_0_3 - 0.00909090909090942*G0_1_1_5_0_4 - 0.034675324675326*G0_1_1_5_0_5 + 0.0073376623376626*G0_1_1_5_1_0 - 0.00493506493506512*G0_1_1_5_1_1 - 0.00110389610389614*G0_1_1_5_1_2 + 0.00220779220779229*G0_1_1_5_1_4 + 0.00935064935064969*G0_1_1_5_1_5 + 0.00230519480519489*G0_1_1_5_2_0 - 0.00110389610389614*G0_1_1_5_2_1 + 0.00120129870129875*G0_1_1_5_2_2 + 0.00220779220779229*G0_1_1_5_2_3 + 0.00207792207792215*G0_1_1_5_2_4 + 0.00402597402597417*G0_1_1_5_2_5 - 0.00220779220779228*G0_1_1_5_3_0 + 0.00220779220779229*G0_1_1_5_3_2 + 0.00363636363636378*G0_1_1_5_3_3 - 0.00363636363636376*G0_1_1_5_3_5 - 0.00909090909090942*G0_1_1_5_4_0 + 0.00220779220779229*G0_1_1_5_4_1 + 0.00207792207792216*G0_1_1_5_4_2 - 0.0041558441558443*G0_1_1_5_4_4 - 0.0124675324675329*G0_1_1_5_4_5 - 0.034675324675326*G0_1_1_5_5_0 + 0.00935064935064968*G0_1_1_5_5_1 + 0.00402597402597417*G0_1_1_5_5_2 - 0.00363636363636376*G0_1_1_5_5_3 - 0.0124675324675329*G0_1_1_5_5_4 - 0.116883116883121*G0_1_1_5_5_5;
    A[61] = -A[51] - 0.00429383116883131*G0_0_0_0_0_0 + 0.000262445887445896*G0_0_0_0_0_1 + 0.000324675324675336*G0_0_0_0_0_2 + 0.000167748917748923*G0_0_0_0_0_3 - 0.00461580086580102*G0_0_0_0_0_4 - 0.000416666666666682*G0_0_0_0_0_5 + 0.000262445887445897*G0_0_0_0_1_0 - 0.000679112554112577*G0_0_0_0_1_1 - 0.000183982683982691*G0_0_0_0_1_3 + 0.000286796536796547*G0_0_0_0_1_4 - 0.000194805194805203*G0_0_0_0_1_5 + 0.000324675324675336*G0_0_0_0_2_0 + 0.00153950216450222*G0_0_0_0_2_2 + 0.00063852813852816*G0_0_0_0_2_3 + 0.00360389610389623*G0_0_0_0_2_4 + 0.000438311688311703*G0_0_0_0_2_5 + 0.000167748917748923*G0_0_0_0_3_0 - 0.000183982683982691*G0_0_0_0_3_1 + 0.00063852813852816*G0_0_0_0_3_2 - 0.00225108225108232*G0_0_0_0_3_3 - 0.000909090909090936*G0_0_0_0_3_4 - 0.00121212121212125*G0_0_0_0_3_5 - 0.00461580086580102*G0_0_0_0_4_0 + 0.000286796536796547*G0_0_0_0_4_1 + 0.00360389610389623*G0_0_0_0_4_2 - 0.000909090909090936*G0_0_0_0_4_3 - 0.00298701298701309*G0_0_0_0_4_4 - 0.0014502164502165*G0_0_0_0_4_5 - 0.000416666666666682*G0_0_0_0_5_0 - 0.000194805194805203*G0_0_0_0_5_1 + 0.000438311688311703*G0_0_0_0_5_2 - 0.00121212121212125*G0_0_0_0_5_3 - 0.0014502164502165*G0_0_0_0_5_4 - 0.000735930735930759*G0_0_0_0_5_5 + 0.000262445887445897*G0_0_0_1_0_0 - 0.000679112554112577*G0_0_0_1_0_1 - 0.000183982683982691*G0_0_0_1_0_3 + 0.000286796536796547*G0_0_0_1_0_4 - 0.000194805194805203*G0_0_0_1_0_5 - 0.000679112554112577*G0_0_0_1_1_0 + 0.00868506493506521*G0_0_0_1_1_1 - 0.00127435064935069*G0_0_0_1_1_2 + 0.00595238095238116*G0_0_0_1_1_3 + 0.000573593073593093*G0_0_0_1_1_4 + 0.00281385281385292*G0_0_0_1_1_5 - 0.00127435064935069*G0_0_0_1_2_1 + 0.000882034632034664*G0_0_0_1_2_2 - 0.00103896103896108*G0_0_0_1_2_3 + 0.000573593073593093*G0_0_0_1_2_4 - 0.000183982683982691*G0_0_0_1_3_0 + 0.00595238095238116*G0_0_0_1_3_1 - 0.00103896103896108*G0_0_0_1_3_2 + 0.00441558441558457*G0_0_0_1_3_3 - 0.000779220779220803*G0_0_0_1_3_4 + 0.000562770562770591*G0_0_0_1_3_5 + 0.000286796536796547*G0_0_0_1_4_0 + 0.000573593073593093*G0_0_0_1_4_1 + 0.000573593073593093*G0_0_0_1_4_2 - 0.000779220779220803*G0_0_0_1_4_3 + 0.00190476190476196*G0_0_0_1_4_4 - 0.000952380952380983*G0_0_0_1_4_5 - 0.000194805194805203*G0_0_0_1_5_0 + 0.00281385281385292*G0_0_0_1_5_1 + 0.000562770562770591*G0_0_0_1_5_3 - 0.000952380952380983*G0_0_0_1_5_4 - 0.000346320346320349*G0_0_0_1_5_5 + 0.000324675324675336*G0_0_0_2_0_0 + 0.00153950216450222*G0_0_0_2_0_2 + 0.00063852813852816*G0_0_0_2_0_3 + 0.00360389610389623*G0_0_0_2_0_4 + 0.000438311688311703*G0_0_0_2_0_5 - 0.00127435064935069*G0_0_0_2_1_1 + 0.000882034632034664*G0_0_0_2_1_2 - 0.00103896103896108*G0_0_0_2_1_3 + 0.000573593073593093*G0_0_0_2_1_4 + 0.00153950216450222*G0_0_0_2_2_0 + 0.000882034632034663*G0_0_0_2_2_1 - 0.0168831168831175*G0_0_0_2_2_2 - 0.00185064935064942*G0_0_0_2_2_3 - 0.00918831168831202*G0_0_0_2_2_4 + 0.00063852813852816*G0_0_0_2_3_0 - 0.00103896103896108*G0_0_0_2_3_1 - 0.00185064935064942*G0_0_0_2_3_2 - 0.0025108225108226*G0_0_0_2_3_3 - 0.00242424242424251*G0_0_0_2_3_4 - 0.00138528138528143*G0_0_0_2_3_5 + 0.00360389610389623*G0_0_0_2_4_0 + 0.000573593073593093*G0_0_0_2_4_1 - 0.00918831168831202*G0_0_0_2_4_2 - 0.00242424242424251*G0_0_0_2_4_3 - 0.00952380952380985*G0_0_0_2_4_4 - 0.0012554112554113*G0_0_0_2_4_5 + 0.000438311688311703*G0_0_0_2_5_0 - 0.00138528138528143*G0_0_0_2_5_3 - 0.0012554112554113*G0_0_0_2_5_4 - 0.00186147186147192*G0_0_0_2_5_5 + 0.000167748917748923*G0_0_0_3_0_0 - 0.000183982683982691*G0_0_0_3_0_1 + 0.00063852813852816*G0_0_0_3_0_2 - 0.00225108225108232*G0_0_0_3_0_3 - 0.000909090909090936*G0_0_0_3_0_4 - 0.00121212121212125*G0_0_0_3_0_5 - 0.000183982683982691*G0_0_0_3_1_0 + 0.00595238095238116*G0_0_0_3_1_1 - 0.00103896103896108*G0_0_0_3_1_2 + 0.00441558441558457*G0_0_0_3_1_3 - 0.000779220779220803*G0_0_0_3_1_4 + 0.000562770562770591*G0_0_0_3_1_5 + 0.00063852813852816*G0_0_0_3_2_0 - 0.00103896103896108*G0_0_0_3_2_1 - 0.00185064935064942*G0_0_0_3_2_2 - 0.0025108225108226*G0_0_0_3_2_3 - 0.00242424242424251*G0_0_0_3_2_4 - 0.00138528138528143*G0_0_0_3_2_5 - 0.00225108225108232*G0_0_0_3_3_0 + 0.00441558441558457*G0_0_0_3_3_1 - 0.0025108225108226*G0_0_0_3_3_2 + 0.021298701298702*G0_0_0_3_3_3 + 0.00606060606060626*G0_0_0_3_3_4 + 0.00727272727272752*G0_0_0_3_3_5 - 0.000909090909090936*G0_0_0_3_4_0 - 0.000779220779220803*G0_0_0_3_4_1 - 0.00242424242424251*G0_0_0_3_4_2 + 0.00606060606060626*G0_0_0_3_4_3 - 0.00199134199134205*G0_0_0_3_4_4 + 0.00432900432900447*G0_0_0_3_4_5 - 0.00121212121212125*G0_0_0_3_5_0 + 0.000562770562770591*G0_0_0_3_5_1 - 0.00138528138528143*G0_0_0_3_5_2 + 0.00727272727272752*G0_0_0_3_5_3 + 0.00432900432900447*G0_0_0_3_5_4 + 0.00614718614718636*G0_0_0_3_5_5 - 0.00461580086580102*G0_0_0_4_0_0 + 0.000286796536796547*G0_0_0_4_0_1 + 0.00360389610389623*G0_0_0_4_0_2 - 0.000909090909090936*G0_0_0_4_0_3 - 0.00298701298701309*G0_0_0_4_0_4 - 0.0014502164502165*G0_0_0_4_0_5 + 0.000286796536796547*G0_0_0_4_1_0 + 0.000573593073593093*G0_0_0_4_1_1 + 0.000573593073593093*G0_0_0_4_1_2 - 0.000779220779220803*G0_0_0_4_1_3 + 0.00190476190476196*G0_0_0_4_1_4 - 0.000952380952380983*G0_0_0_4_1_5 + 0.00360389610389623*G0_0_0_4_2_0 + 0.000573593073593093*G0_0_0_4_2_1 - 0.00918831168831202*G0_0_0_4_2_2 - 0.00242424242424251*G0_0_0_4_2_3 - 0.00952380952380986*G0_0_0_4_2_4 - 0.0012554112554113*G0_0_0_4_2_5 - 0.000909090909090936*G0_0_0_4_3_0 - 0.000779220779220803*G0_0_0_4_3_1 - 0.00242424242424251*G0_0_0_4_3_2 + 0.00606060606060626*G0_0_0_4_3_3 - 0.00199134199134205*G0_0_0_4_3_4 + 0.00432900432900447*G0_0_0_4_3_5 - 0.00298701298701309*G0_0_0_4_4_0 + 0.00190476190476196*G0_0_0_4_4_1 - 0.00952380952380986*G0_0_0_4_4_2 - 0.00199134199134205*G0_0_0_4_4_3 - 0.0932467532467563*G0_0_0_4_4_4 - 0.00129870129870134*G0_0_0_4_4_5 - 0.0014502164502165*G0_0_0_4_5_0 - 0.000952380952380983*G0_0_0_4_5_1 - 0.0012554112554113*G0_0_0_4_5_2 + 0.00432900432900447*G0_0_0_4_5_3 - 0.00129870129870134*G0_0_0_4_5_4 + 0.00562770562770581*G0_0_0_4_5_5 - 0.000416666666666681*G0_0_0_5_0_0 - 0.000194805194805203*G0_0_0_5_0_1 + 0.000438311688311703*G0_0_0_5_0_2 - 0.00121212121212125*G0_0_0_5_0_3 - 0.0014502164502165*G0_0_0_5_0_4 - 0.00073593073593076*G0_0_0_5_0_5 - 0.000194805194805203*G0_0_0_5_1_0 + 0.00281385281385292*G0_0_0_5_1_1 + 0.000562770562770591*G0_0_0_5_1_3 - 0.000952380952380983*G0_0_0_5_1_4 - 0.000346320346320349*G0_0_0_5_1_5 + 0.000438311688311703*G0_0_0_5_2_0 - 0.00138528138528143*G0_0_0_5_2_3 - 0.0012554112554113*G0_0_0_5_2_4 - 0.00186147186147192*G0_0_0_5_2_5 - 0.00121212121212125*G0_0_0_5_3_0 + 0.000562770562770591*G0_0_0_5_3_1 - 0.00138528138528143*G0_0_0_5_3_2 + 0.00727272727272752*G0_0_0_5_3_3 + 0.00432900432900447*G0_0_0_5_3_4 + 0.00614718614718636*G0_0_0_5_3_5 - 0.0014502164502165*G0_0_0_5_4_0 - 0.000952380952380983*G0_0_0_5_4_1 - 0.0012554112554113*G0_0_0_5_4_2 + 0.00432900432900447*G0_0_0_5_4_3 - 0.00129870129870134*G0_0_0_5_4_4 + 0.00562770562770581*G0_0_0_5_4_5 - 0.00073593073593076*G0_0_0_5_5_0 - 0.000346320346320349*G0_0_0_5_5_1 - 0.00186147186147192*G0_0_0_5_5_2 + 0.00614718614718636*G0_0_0_5_5_3 + 0.00562770562770581*G0_0_0_5_5_4 + 0.0111688311688316*G0_0_0_5_5_5 + 0.0125892857142861*G0_1_0_0_0_0 - 0.000619588744588764*G0_1_0_0_0_1 - 0.00121482683982688*G0_1_0_0_0_2 + 0.000113636363636366*G0_1_0_0_0_3 + 0.00457251082251097*G0_1_0_0_0_4 + 0.00143398268398273*G0_1_0_0_0_5 - 0.000619588744588764*G0_1_0_0_1_0 + 0.000595238095238116*G0_1_0_0_1_1 - 0.000286796536796547*G0_1_0_0_1_4 + 0.000844155844155872*G0_1_0_0_1_5 - 0.00121482683982688*G0_1_0_0_2_0 + 0.00121482683982688*G0_1_0_0_2_2 + 0.000200216450216458*G0_1_0_0_2_3 - 0.000200216450216457*G0_1_0_0_2_5 + 0.000113636363636366*G0_1_0_0_3_0 + 0.000200216450216458*G0_1_0_0_3_2 - 0.000389610389610402*G0_1_0_0_3_3 + 0.000346320346320358*G0_1_0_0_3_4 + 0.000173160173160179*G0_1_0_0_3_5 + 0.00457251082251097*G0_1_0_0_4_0 - 0.000286796536796547*G0_1_0_0_4_1 + 0.000346320346320358*G0_1_0_0_4_3 + 0.00653679653679675*G0_1_0_0_4_4 + 0.000974025974026008*G0_1_0_0_4_5 + 0.00143398268398273*G0_1_0_0_5_0 + 0.000844155844155872*G0_1_0_0_5_1 - 0.000200216450216457*G0_1_0_0_5_2 + 0.000173160173160179*G0_1_0_0_5_3 + 0.000974025974026008*G0_1_0_0_5_4 + 0.00177489177489183*G0_1_0_0_5_5 - 0.000619588744588764*G0_1_0_1_0_0 + 0.000595238095238116*G0_1_0_1_0_1 - 0.000286796536796547*G0_1_0_1_0_4 + 0.000844155844155872*G0_1_0_1_0_5 + 0.000595238095238116*G0_1_0_1_1_0 - 0.000595238095238115*G0_1_0_1_1_2 + 0.00313852813852824*G0_1_0_1_1_3 - 0.00313852813852825*G0_1_0_1_1_5 - 0.000595238095238115*G0_1_0_1_2_1 + 0.000619588744588767*G0_1_0_1_2_2 - 0.000844155844155873*G0_1_0_1_2_3 + 0.000286796536796547*G0_1_0_1_2_4 + 0.00313852813852824*G0_1_0_1_3_1 - 0.000844155844155873*G0_1_0_1_3_2 + 0.00476190476190493*G0_1_0_1_3_3 + 0.000173160173160181*G0_1_0_1_3_4 - 0.000286796536796547*G0_1_0_1_4_0 + 0.000286796536796547*G0_1_0_1_4_2 + 0.000173160173160181*G0_1_0_1_4_3 - 0.000173160173160177*G0_1_0_1_4_5 + 0.000844155844155871*G0_1_0_1_5_0 - 0.00313852813852825*G0_1_0_1_5_1 - 0.000173160173160177*G0_1_0_1_5_4 - 0.00476190476190492*G0_1_0_1_5_5 - 0.00121482683982688*G0_1_0_2_0_0 + 0.00121482683982688*G0_1_0_2_0_2 + 0.000200216450216458*G0_1_0_2_0_3 - 0.000200216450216457*G0_1_0_2_0_5 - 0.000595238095238115*G0_1_0_2_1_1 + 0.000619588744588767*G0_1_0_2_1_2 - 0.000844155844155873*G0_1_0_2_1_3 + 0.000286796536796547*G0_1_0_2_1_4 + 0.00121482683982688*G0_1_0_2_2_0 + 0.000619588744588767*G0_1_0_2_2_1 - 0.0125892857142862*G0_1_0_2_2_2 - 0.00143398268398274*G0_1_0_2_2_3 - 0.00457251082251099*G0_1_0_2_2_4 - 0.00011363636363637*G0_1_0_2_2_5 + 0.000200216450216458*G0_1_0_2_3_0 - 0.000844155844155873*G0_1_0_2_3_1 - 0.00143398268398274*G0_1_0_2_3_2 - 0.00177489177489184*G0_1_0_2_3_3 - 0.00097402597402601*G0_1_0_2_3_4 - 0.00017316017316018*G0_1_0_2_3_5 + 0.000286796536796547*G0_1_0_2_4_1 - 0.00457251082251099*G0_1_0_2_4_2 - 0.00097402597402601*G0_1_0_2_4_3 - 0.00653679653679676*G0_1_0_2_4_4 - 0.000346320346320359*G0_1_0_2_4_5 - 0.000200216450216457*G0_1_0_2_5_0 - 0.00011363636363637*G0_1_0_2_5_2 - 0.00017316017316018*G0_1_0_2_5_3 - 0.000346320346320359*G0_1_0_2_5_4 + 0.000389610389610404*G0_1_0_2_5_5 + 0.000113636363636365*G0_1_0_3_0_0 + 0.000200216450216458*G0_1_0_3_0_2 - 0.000389610389610402*G0_1_0_3_0_3 + 0.000346320346320358*G0_1_0_3_0_4 + 0.000173160173160179*G0_1_0_3_0_5 + 0.00313852813852824*G0_1_0_3_1_1 - 0.000844155844155873*G0_1_0_3_1_2 + 0.00476190476190493*G0_1_0_3_1_3 + 0.000173160173160181*G0_1_0_3_1_4 + 0.000200216450216458*G0_1_0_3_2_0 - 0.000844155844155873*G0_1_0_3_2_1 - 0.00143398268398274*G0_1_0_3_2_2 - 0.00177489177489184*G0_1_0_3_2_3 - 0.000974025974026009*G0_1_0_3_2_4 - 0.00017316017316018*G0_1_0_3_2_5 - 0.000389610389610401*G0_1_0_3_3_0 + 0.00476190476190493*G0_1_0_3_3_1 - 0.00177489177489184*G0_1_0_3_3_2 + 0.0101298701298705*G0_1_0_3_3_3 + 0.000432900432900444*G0_1_0_3_3_4 + 0.00112554112554117*G0_1_0_3_3_5 + 0.000346320346320358*G0_1_0_3_4_0 + 0.000173160173160181*G0_1_0_3_4_1 - 0.000974025974026009*G0_1_0_3_4_2 + 0.000432900432900444*G0_1_0_3_4_3 - 0.000692640692640722*G0_1_0_3_4_4 + 0.000173160173160179*G0_1_0_3_5_0 - 0.00017316017316018*G0_1_0_3_5_2 + 0.00112554112554117*G0_1_0_3_5_3 - 0.00112554112554116*G0_1_0_3_5_5 + 0.00457251082251097*G0_1_0_4_0_0 - 0.000286796536796547*G0_1_0_4_0_1 + 0.000346320346320358*G0_1_0_4_0_3 + 0.00653679653679675*G0_1_0_4_0_4 + 0.000974025974026008*G0_1_0_4_0_5 - 0.000286796536796547*G0_1_0_4_1_0 + 0.000286796536796547*G0_1_0_4_1_2 + 0.000173160173160181*G0_1_0_4_1_3 - 0.000173160173160177*G0_1_0_4_1_5 + 0.000286796536796547*G0_1_0_4_2_1 - 0.00457251082251099*G0_1_0_4_2_2 - 0.000974025974026009*G0_1_0_4_2_3 - 0.00653679653679676*G0_1_0_4_2_4 - 0.000346320346320359*G0_1_0_4_2_5 + 0.000346320346320358*G0_1_0_4_3_0 + 0.000173160173160181*G0_1_0_4_3_1 - 0.000974025974026009*G0_1_0_4_3_2 + 0.000432900432900444*G0_1_0_4_3_3 - 0.000692640692640722*G0_1_0_4_3_4 + 0.00653679653679675*G0_1_0_4_4_0 - 0.00653679653679676*G0_1_0_4_4_2 - 0.000692640692640722*G0_1_0_4_4_3 + 0.00069264069264071*G0_1_0_4_4_5 + 0.000974025974026008*G0_1_0_4_5_0 - 0.000173160173160177*G0_1_0_4_5_1 - 0.000346320346320359*G0_1_0_4_5_2 + 0.00069264069264071*G0_1_0_4_5_4 - 0.00043290043290045*G0_1_0_4_5_5 + 0.00143398268398273*G0_1_0_5_0_0 + 0.000844155844155871*G0_1_0_5_0_1 - 0.000200216450216457*G0_1_0_5_0_2 + 0.000173160173160179*G0_1_0_5_0_3 + 0.000974025974026008*G0_1_0_5_0_4 + 0.00177489177489183*G0_1_0_5_0_5 + 0.000844155844155871*G0_1_0_5_1_0 - 0.00313852813852825*G0_1_0_5_1_1 - 0.000173160173160177*G0_1_0_5_1_4 - 0.00476190476190492*G0_1_0_5_1_5 - 0.000200216450216457*G0_1_0_5_2_0 - 0.00011363636363637*G0_1_0_5_2_2 - 0.00017316017316018*G0_1_0_5_2_3 - 0.000346320346320359*G0_1_0_5_2_4 + 0.000389610389610404*G0_1_0_5_2_5 + 0.000173160173160179*G0_1_0_5_3_0 - 0.00017316017316018*G0_1_0_5_3_2 + 0.00112554112554117*G0_1_0_5_3_3 - 0.00112554112554116*G0_1_0_5_3_5 + 0.000974025974026008*G0_1_0_5_4_0 - 0.000173160173160177*G0_1_0_5_4_1 - 0.000346320346320359*G0_1_0_5_4_2 + 0.00069264069264071*G0_1_0_5_4_4 - 0.00043290043290045*G0_1_0_5_4_5 + 0.00177489177489183*G0_1_0_5_5_0 - 0.00476190476190492*G0_1_0_5_5_1 + 0.000389610389610404*G0_1_0_5_5_2 - 0.00112554112554116*G0_1_0_5_5_3 - 0.00043290043290045*G0_1_0_5_5_4 - 0.0101298701298705*G0_1_0_5_5_5;
    A[41] = -A[61] - 0.00748376623376649*G0_1_0_0_0_0 - 0.000533008658008677*G0_1_0_0_0_1 + 0.000162337662337667*G0_1_0_0_0_2 - 0.000854978354978379*G0_1_0_0_0_3 - 0.000670995670995693*G0_1_0_0_0_4 - 0.00160173160173165*G0_1_0_0_0_5 - 0.000533008658008677*G0_1_0_0_1_0 + 0.00531114718614737*G0_1_0_0_1_1 - 0.000201569264069271*G0_1_0_0_1_2 - 0.000508658008658026*G0_1_0_0_1_4 + 0.00305194805194815*G0_1_0_0_1_5 + 0.000162337662337667*G0_1_0_0_2_0 - 0.000201569264069271*G0_1_0_0_2_1 + 0.00119047619047623*G0_1_0_0_2_2 - 0.000487012987012999*G0_1_0_0_2_4 - 0.000681818181818204*G0_1_0_0_2_5 - 0.000854978354978379*G0_1_0_0_3_0 + 0.00385281385281397*G0_1_0_0_3_3 + 0.00272727272727281*G0_1_0_0_3_4 + 0.00307359307359317*G0_1_0_0_3_5 - 0.000670995670995693*G0_1_0_0_4_0 - 0.000508658008658026*G0_1_0_0_4_1 - 0.000487012987012999*G0_1_0_0_4_2 + 0.00272727272727281*G0_1_0_0_4_3 + 0.00441558441558456*G0_1_0_0_4_4 + 0.00238095238095246*G0_1_0_0_4_5 - 0.00160173160173165*G0_1_0_0_5_0 + 0.00305194805194815*G0_1_0_0_5_1 - 0.000681818181818204*G0_1_0_0_5_2 + 0.00307359307359317*G0_1_0_0_5_3 + 0.00238095238095246*G0_1_0_0_5_4 + 0.0105627705627709*G0_1_0_0_5_5 - 0.000533008658008677*G0_1_0_1_0_0 + 0.00531114718614737*G0_1_0_1_0_1 - 0.000201569264069271*G0_1_0_1_0_2 - 0.000508658008658026*G0_1_0_1_0_4 + 0.00305194805194815*G0_1_0_1_0_5 + 0.00531114718614737*G0_1_0_1_1_0 - 0.0668019480519504*G0_1_0_1_1_1 + 0.00252435064935074*G0_1_0_1_1_2 - 0.010119047619048*G0_1_0_1_1_3 - 0.00134199134199138*G0_1_0_1_1_4 - 0.0233225108225117*G0_1_0_1_1_5 - 0.000201569264069271*G0_1_0_1_2_0 + 0.00252435064935074*G0_1_0_1_2_1 + 0.000703463203463229*G0_1_0_1_2_2 + 0.00097402597402601*G0_1_0_1_2_5 - 0.010119047619048*G0_1_0_1_3_1 + 0.00753246753246781*G0_1_0_1_3_3 + 0.00272727272727282*G0_1_0_1_3_4 - 0.00190476190476198*G0_1_0_1_3_5 - 0.000508658008658026*G0_1_0_1_4_0 - 0.00134199134199138*G0_1_0_1_4_1 + 0.00272727272727282*G0_1_0_1_4_3 + 0.000735930735930763*G0_1_0_1_4_4 + 0.000735930735930762*G0_1_0_1_4_5 + 0.00305194805194815*G0_1_0_1_5_0 - 0.0233225108225117*G0_1_0_1_5_1 + 0.00097402597402601*G0_1_0_1_5_2 - 0.00190476190476198*G0_1_0_1_5_3 + 0.000735930735930762*G0_1_0_1_5_4 - 0.0206060606060613*G0_1_0_1_5_5 + 0.000162337662337667*G0_1_0_2_0_0 - 0.000201569264069271*G0_1_0_2_0_1 + 0.00119047619047623*G0_1_0_2_0_2 - 0.000487012987012999*G0_1_0_2_0_4 - 0.000681818181818204*G0_1_0_2_0_5 - 0.000201569264069271*G0_1_0_2_1_0 + 0.00252435064935073*G0_1_0_2_1_1 + 0.000703463203463229*G0_1_0_2_1_2 + 0.00097402597402601*G0_1_0_2_1_5 + 0.00119047619047623*G0_1_0_2_2_0 + 0.000703463203463229*G0_1_0_2_2_1 - 0.0183441558441565*G0_1_0_2_2_2 - 0.0028409090909092*G0_1_0_2_2_3 - 0.00430194805194822*G0_1_0_2_2_4 - 0.000514069264069284*G0_1_0_2_2_5 - 0.0028409090909092*G0_1_0_2_3_2 - 0.00367965367965383*G0_1_0_2_3_3 + 0.000108225108225104*G0_1_0_2_3_4 + 0.00108225108225111*G0_1_0_2_3_5 - 0.000487012987012999*G0_1_0_2_4_0 - 0.00430194805194822*G0_1_0_2_4_2 + 0.000108225108225104*G0_1_0_2_4_3 - 0.0017316017316018*G0_1_0_2_4_4 + 0.00108225108225111*G0_1_0_2_4_5 - 0.000681818181818204*G0_1_0_2_5_0 + 0.00097402597402601*G0_1_0_2_5_1 - 0.000514069264069284*G0_1_0_2_5_2 + 0.00108225108225111*G0_1_0_2_5_3 + 0.00108225108225111*G0_1_0_2_5_4 + 0.00216450216450223*G0_1_0_2_5_5 - 0.000854978354978378*G0_1_0_3_0_0 + 0.00385281385281397*G0_1_0_3_0_3 + 0.00272727272727281*G0_1_0_3_0_4 + 0.00307359307359317*G0_1_0_3_0_5 - 0.010119047619048*G0_1_0_3_1_1 + 0.00753246753246781*G0_1_0_3_1_3 + 0.00272727272727282*G0_1_0_3_1_4 - 0.00190476190476198*G0_1_0_3_1_5 - 0.0028409090909092*G0_1_0_3_2_2 - 0.00367965367965383*G0_1_0_3_2_3 + 0.000108225108225104*G0_1_0_3_2_4 + 0.00108225108225111*G0_1_0_3_2_5 + 0.00385281385281397*G0_1_0_3_3_0 + 0.00753246753246781*G0_1_0_3_3_1 - 0.00367965367965383*G0_1_0_3_3_2 - 0.0161038961038965*G0_1_0_3_3_3 - 0.0131601731601736*G0_1_0_3_3_4 - 0.00987012987013017*G0_1_0_3_3_5 + 0.00272727272727281*G0_1_0_3_4_0 + 0.00272727272727282*G0_1_0_3_4_1 + 0.000108225108225104*G0_1_0_3_4_2 - 0.0131601731601736*G0_1_0_3_4_3 - 0.00692640692640715*G0_1_0_3_4_4 - 0.00761904761904786*G0_1_0_3_4_5 + 0.00307359307359317*G0_1_0_3_5_0 - 0.00190476190476198*G0_1_0_3_5_1 + 0.00108225108225111*G0_1_0_3_5_2 - 0.00987012987013017*G0_1_0_3_5_3 - 0.00761904761904786*G0_1_0_3_5_4 - 0.0104761904761908*G0_1_0_3_5_5 - 0.000670995670995693*G0_1_0_4_0_0 - 0.000508658008658026*G0_1_0_4_0_1 - 0.000487012987012999*G0_1_0_4_0_2 + 0.00272727272727281*G0_1_0_4_0_3 + 0.00441558441558456*G0_1_0_4_0_4 + 0.00238095238095246*G0_1_0_4_0_5 - 0.000508658008658026*G0_1_0_4_1_0 - 0.00134199134199138*G0_1_0_4_1_1 + 0.00272727272727282*G0_1_0_4_1_3 + 0.000735930735930763*G0_1_0_4_1_4 + 0.000735930735930762*G0_1_0_4_1_5 - 0.000487012987012999*G0_1_0_4_2_0 - 0.00430194805194822*G0_1_0_4_2_2 + 0.000108225108225104*G0_1_0_4_2_3 - 0.0017316017316018*G0_1_0_4_2_4 + 0.00108225108225111*G0_1_0_4_2_5 + 0.00272727272727281*G0_1_0_4_3_0 + 0.00272727272727282*G0_1_0_4_3_1 + 0.000108225108225104*G0_1_0_4_3_2 - 0.0131601731601736*G0_1_0_4_3_3 - 0.00692640692640715*G0_1_0_4_3_4 - 0.00761904761904786*G0_1_0_4_3_5 + 0.00441558441558456*G0_1_0_4_4_0 + 0.000735930735930763*G0_1_0_4_4_1 - 0.0017316017316018*G0_1_0_4_4_2 - 0.00692640692640715*G0_1_0_4_4_3 + 0.0400000000000012*G0_1_0_4_4_4 - 0.00363636363636375*G0_1_0_4_4_5 + 0.00238095238095246*G0_1_0_4_5_0 + 0.000735930735930762*G0_1_0_4_5_1 + 0.00108225108225111*G0_1_0_4_5_2 - 0.00761904761904786*G0_1_0_4_5_3 - 0.00363636363636375*G0_1_0_4_5_4 - 0.00580086580086598*G0_1_0_4_5_5 - 0.00160173160173165*G0_1_0_5_0_0 + 0.00305194805194815*G0_1_0_5_0_1 - 0.000681818181818204*G0_1_0_5_0_2 + 0.00307359307359317*G0_1_0_5_0_3 + 0.00238095238095246*G0_1_0_5_0_4 + 0.0105627705627709*G0_1_0_5_0_5 + 0.00305194805194815*G0_1_0_5_1_0 - 0.0233225108225117*G0_1_0_5_1_1 + 0.00097402597402601*G0_1_0_5_1_2 - 0.00190476190476198*G0_1_0_5_1_3 + 0.000735930735930762*G0_1_0_5_1_4 - 0.0206060606060613*G0_1_0_5_1_5 - 0.000681818181818204*G0_1_0_5_2_0 + 0.00097402597402601*G0_1_0_5_2_1 - 0.000514069264069284*G0_1_0_5_2_2 + 0.00108225108225111*G0_1_0_5_2_3 + 0.00108225108225111*G0_1_0_5_2_4 + 0.00216450216450223*G0_1_0_5_2_5 + 0.00307359307359317*G0_1_0_5_3_0 - 0.00190476190476198*G0_1_0_5_3_1 + 0.00108225108225111*G0_1_0_5_3_2 - 0.00987012987013017*G0_1_0_5_3_3 - 0.00761904761904786*G0_1_0_5_3_4 - 0.0104761904761908*G0_1_0_5_3_5 + 0.00238095238095246*G0_1_0_5_4_0 + 0.000735930735930762*G0_1_0_5_4_1 + 0.00108225108225111*G0_1_0_5_4_2 - 0.00761904761904786*G0_1_0_5_4_3 - 0.00363636363636375*G0_1_0_5_4_4 - 0.00580086580086598*G0_1_0_5_4_5 + 0.0105627705627709*G0_1_0_5_5_0 - 0.0206060606060613*G0_1_0_5_5_1 + 0.00216450216450223*G0_1_0_5_5_2 - 0.0104761904761908*G0_1_0_5_5_3 - 0.00580086580086598*G0_1_0_5_5_4 - 0.0215584415584422*G0_1_0_5_5_5;
    A[40] = -A[41] + 0.00354301948051965*G0_0_0_0_0_0 - 0.000450487012987032*G0_0_0_0_0_1 + 0.00277597402597413*G0_0_0_0_0_4 + 0.00136363636363643*G0_0_0_0_0_5 - 0.000450487012987032*G0_0_0_0_1_0 + 0.000450487012987032*G0_0_0_0_1_1 - 0.00109577922077926*G0_0_0_0_2_2 - 0.00253246753246762*G0_0_0_0_2_4 - 0.000438311688311705*G0_0_0_0_2_5 + 0.00253246753246761*G0_0_0_0_3_3 - 0.000194805194805202*G0_0_0_0_3_4 + 0.000779220779220806*G0_0_0_0_3_5 + 0.00277597402597413*G0_0_0_0_4_0 - 0.00253246753246762*G0_0_0_0_4_2 - 0.000194805194805202*G0_0_0_0_4_3 - 0.00409090909090922*G0_0_0_0_4_4 + 0.000779220779220809*G0_0_0_0_4_5 + 0.00136363636363643*G0_0_0_0_5_0 - 0.000438311688311705*G0_0_0_0_5_2 + 0.000779220779220806*G0_0_0_0_5_3 + 0.000779220779220809*G0_0_0_0_5_4 + 0.00233766233766244*G0_0_0_0_5_5 - 0.000450487012987032*G0_0_0_1_0_0 + 0.000450487012987032*G0_0_0_1_0_1 + 0.000450487012987032*G0_0_0_1_1_0 - 0.00354301948051964*G0_0_0_1_1_1 - 0.00277597402597413*G0_0_0_1_1_3 - 0.00136363636363643*G0_0_0_1_1_5 + 0.00109577922077926*G0_0_0_1_2_2 + 0.00253246753246762*G0_0_0_1_2_3 + 0.000438311688311705*G0_0_0_1_2_5 - 0.00277597402597413*G0_0_0_1_3_1 + 0.00253246753246762*G0_0_0_1_3_2 + 0.00409090909090924*G0_0_0_1_3_3 + 0.000194805194805202*G0_0_0_1_3_4 - 0.000779220779220808*G0_0_0_1_3_5 + 0.000194805194805202*G0_0_0_1_4_3 - 0.00253246753246761*G0_0_0_1_4_4 - 0.000779220779220806*G0_0_0_1_4_5 - 0.00136363636363643*G0_0_0_1_5_1 + 0.000438311688311705*G0_0_0_1_5_2 - 0.000779220779220809*G0_0_0_1_5_3 - 0.000779220779220806*G0_0_0_1_5_4 - 0.00233766233766244*G0_0_0_1_5_5 - 0.00109577922077926*G0_0_0_2_0_2 - 0.00253246753246762*G0_0_0_2_0_4 - 0.000438311688311705*G0_0_0_2_0_5 + 0.00109577922077926*G0_0_0_2_1_2 + 0.00253246753246762*G0_0_0_2_1_3 + 0.000438311688311705*G0_0_0_2_1_5 - 0.00109577922077926*G0_0_0_2_2_0 + 0.00109577922077926*G0_0_0_2_2_1 - 0.00681818181818205*G0_0_0_2_2_3 + 0.00681818181818206*G0_0_0_2_2_4 + 0.00253246753246762*G0_0_0_2_3_1 - 0.00681818181818206*G0_0_0_2_3_2 - 0.0116883116883121*G0_0_0_2_3_3 - 0.000194805194805204*G0_0_0_2_3_5 - 0.00253246753246762*G0_0_0_2_4_0 + 0.00681818181818206*G0_0_0_2_4_2 + 0.0116883116883121*G0_0_0_2_4_4 + 0.000194805194805202*G0_0_0_2_4_5 - 0.000438311688311705*G0_0_0_2_5_0 + 0.000438311688311705*G0_0_0_2_5_1 - 0.000194805194805204*G0_0_0_2_5_3 + 0.000194805194805202*G0_0_0_2_5_4 + 0.00253246753246761*G0_0_0_3_0_3 - 0.000194805194805202*G0_0_0_3_0_4 + 0.000779220779220806*G0_0_0_3_0_5 - 0.00277597402597413*G0_0_0_3_1_1 + 0.00253246753246762*G0_0_0_3_1_2 + 0.00409090909090924*G0_0_0_3_1_3 + 0.000194805194805202*G0_0_0_3_1_4 - 0.000779220779220808*G0_0_0_3_1_5 + 0.00253246753246762*G0_0_0_3_2_1 - 0.00681818181818206*G0_0_0_3_2_2 - 0.0116883116883121*G0_0_0_3_2_3 - 0.000194805194805204*G0_0_0_3_2_5 + 0.00253246753246761*G0_0_0_3_3_0 + 0.00409090909090924*G0_0_0_3_3_1 - 0.0116883116883121*G0_0_0_3_3_2 - 0.0490909090909108*G0_0_0_3_3_3 - 0.00545454545454564*G0_0_0_3_3_4 - 0.00467532467532484*G0_0_0_3_3_5 - 0.000194805194805202*G0_0_0_3_4_0 + 0.000194805194805202*G0_0_0_3_4_1 - 0.00545454545454564*G0_0_0_3_4_3 + 0.00545454545454563*G0_0_0_3_4_4 + 0.000779220779220806*G0_0_0_3_5_0 - 0.000779220779220808*G0_0_0_3_5_1 - 0.000194805194805204*G0_0_0_3_5_2 - 0.00467532467532484*G0_0_0_3_5_3 - 0.00155844155844161*G0_0_0_3_5_5 + 0.00277597402597413*G0_0_0_4_0_0 - 0.00253246753246762*G0_0_0_4_0_2 - 0.000194805194805202*G0_0_0_4_0_3 - 0.00409090909090922*G0_0_0_4_0_4 + 0.000779220779220809*G0_0_0_4_0_5 + 0.000194805194805202*G0_0_0_4_1_3 - 0.00253246753246761*G0_0_0_4_1_4 - 0.000779220779220806*G0_0_0_4_1_5 - 0.00253246753246762*G0_0_0_4_2_0 + 0.00681818181818206*G0_0_0_4_2_2 + 0.0116883116883121*G0_0_0_4_2_4 + 0.000194805194805202*G0_0_0_4_2_5 - 0.000194805194805202*G0_0_0_4_3_0 + 0.000194805194805202*G0_0_0_4_3_1 - 0.00545454545454564*G0_0_0_4_3_3 + 0.00545454545454563*G0_0_0_4_3_4 - 0.00409090909090922*G0_0_0_4_4_0 - 0.00253246753246761*G0_0_0_4_4_1 + 0.0116883116883121*G0_0_0_4_4_2 + 0.00545454545454563*G0_0_0_4_4_3 + 0.0490909090909107*G0_0_0_4_4_4 + 0.00467532467532484*G0_0_0_4_4_5 + 0.000779220779220809*G0_0_0_4_5_0 - 0.000779220779220806*G0_0_0_4_5_1 + 0.000194805194805202*G0_0_0_4_5_2 + 0.00467532467532484*G0_0_0_4_5_4 + 0.00155844155844162*G0_0_0_4_5_5 + 0.00136363636363643*G0_0_0_5_0_0 - 0.000438311688311705*G0_0_0_5_0_2 + 0.000779220779220806*G0_0_0_5_0_3 + 0.000779220779220809*G0_0_0_5_0_4 + 0.00233766233766244*G0_0_0_5_0_5 - 0.00136363636363643*G0_0_0_5_1_1 + 0.000438311688311705*G0_0_0_5_1_2 - 0.000779220779220809*G0_0_0_5_1_3 - 0.000779220779220806*G0_0_0_5_1_4 - 0.00233766233766244*G0_0_0_5_1_5 - 0.000438311688311705*G0_0_0_5_2_0 + 0.000438311688311705*G0_0_0_5_2_1 - 0.000194805194805204*G0_0_0_5_2_3 + 0.000194805194805202*G0_0_0_5_2_4 + 0.000779220779220806*G0_0_0_5_3_0 - 0.000779220779220809*G0_0_0_5_3_1 - 0.000194805194805204*G0_0_0_5_3_2 - 0.00467532467532484*G0_0_0_5_3_3 - 0.00155844155844161*G0_0_0_5_3_5 + 0.000779220779220809*G0_0_0_5_4_0 - 0.000779220779220806*G0_0_0_5_4_1 + 0.000194805194805202*G0_0_0_5_4_2 + 0.00467532467532484*G0_0_0_5_4_4 + 0.00155844155844162*G0_0_0_5_4_5 + 0.00233766233766244*G0_0_0_5_5_0 - 0.00233766233766244*G0_0_0_5_5_1 - 0.00155844155844161*G0_0_0_5_5_3 + 0.00155844155844162*G0_0_0_5_5_4 + 0.00434253246753267*G0_0_1_0_0_0 - 0.000416666666666684*G0_0_1_0_0_1 - 0.000511363636363657*G0_0_1_0_0_2 + 0.000238095238095246*G0_0_1_0_0_3 + 0.00281385281385292*G0_0_1_0_0_4 + 0.00156926406926414*G0_0_1_0_0_5 - 0.000416666666666684*G0_0_1_0_1_0 - 0.000227272727272737*G0_0_1_0_1_5 - 0.000511363636363657*G0_0_1_0_2_0 + 0.000964556277056313*G0_0_1_0_2_2 + 0.000384199134199148*G0_0_1_0_2_3 - 0.000811688311688337*G0_0_1_0_2_4 - 0.000324675324675336*G0_0_1_0_2_5 + 0.000238095238095246*G0_0_1_0_3_0 + 0.000384199134199148*G0_0_1_0_3_2 + 0.000757575757575782*G0_0_1_0_3_3 - 0.000389610389610402*G0_0_1_0_3_4 + 0.000173160173160179*G0_0_1_0_3_5 + 0.00281385281385292*G0_0_1_0_4_0 - 0.000811688311688337*G0_0_1_0_4_2 - 0.000389610389610401*G0_0_1_0_4_3 - 0.000519480519480529*G0_0_1_0_4_4 + 0.000735930735930764*G0_0_1_0_4_5 + 0.00156926406926414*G0_0_1_0_5_0 - 0.000227272727272737*G0_0_1_0_5_1 - 0.000324675324675336*G0_0_1_0_5_2 + 0.000173160173160179*G0_0_1_0_5_3 + 0.000735930735930764*G0_0_1_0_5_4 + 0.00164502164502171*G0_0_1_0_5_5 - 0.000416666666666684*G0_0_1_1_0_0 - 0.000227272727272737*G0_0_1_1_0_5 + 0.000799512987013018*G0_0_1_1_1_1 - 0.000462662337662354*G0_0_1_1_1_2 + 0.000189393939393945*G0_0_1_1_1_4 + 0.000205627705627714*G0_0_1_1_1_5 - 0.000462662337662354*G0_0_1_1_2_1 + 0.00206033549783557*G0_0_1_1_2_2 + 0.00172077922077929*G0_0_1_1_2_3 + 0.000286796536796549*G0_0_1_1_2_4 + 0.000113636363636369*G0_0_1_1_2_5 + 0.00172077922077929*G0_0_1_1_3_2 + 0.0035714285714287*G0_0_1_1_3_3 - 0.0001948051948052*G0_0_1_1_3_4 + 0.000189393939393945*G0_0_1_1_4_1 + 0.000286796536796549*G0_0_1_1_4_2 - 0.0001948051948052*G0_0_1_1_4_3 - 0.00177489177489183*G0_0_1_1_4_4 - 0.000606060606060628*G0_0_1_1_4_5 - 0.000227272727272737*G0_0_1_1_5_0 + 0.000205627705627714*G0_0_1_1_5_1 + 0.000113636363636369*G0_0_1_1_5_2 - 0.000606060606060628*G0_0_1_1_5_4 - 0.000692640692640721*G0_0_1_1_5_5 - 0.000511363636363657*G0_0_1_2_0_0 + 0.000964556277056313*G0_0_1_2_0_2 + 0.000384199134199148*G0_0_1_2_0_3 - 0.000811688311688337*G0_0_1_2_0_4 - 0.000324675324675336*G0_0_1_2_0_5 - 0.000462662337662354*G0_0_1_2_1_1 + 0.00206033549783557*G0_0_1_2_1_2 + 0.00172077922077929*G0_0_1_2_1_3 + 0.000286796536796549*G0_0_1_2_1_4 + 0.000113636363636369*G0_0_1_2_1_5 + 0.000964556277056313*G0_0_1_2_2_0 + 0.00206033549783557*G0_0_1_2_2_1 - 0.0252435064935074*G0_0_1_2_2_2 - 0.00957792207792243*G0_0_1_2_2_3 - 0.00275974025974038*G0_0_1_2_2_4 - 0.00026515151515153*G0_0_1_2_2_5 + 0.000384199134199148*G0_0_1_2_3_0 + 0.00172077922077929*G0_0_1_2_3_1 - 0.00957792207792243*G0_0_1_2_3_2 - 0.00969696969697005*G0_0_1_2_3_3 - 0.0013419913419914*G0_0_1_2_3_4 - 0.00023809523809525*G0_0_1_2_3_5 - 0.000811688311688337*G0_0_1_2_4_0 + 0.000286796536796549*G0_0_1_2_4_1 - 0.00275974025974038*G0_0_1_2_4_2 - 0.0013419913419914*G0_0_1_2_4_3 + 0.00199134199134204*G0_0_1_2_4_4 - 0.000324675324675336*G0_0_1_2_5_0 + 0.000113636363636369*G0_0_1_2_5_1 - 0.00026515151515153*G0_0_1_2_5_2 - 0.00023809523809525*G0_0_1_2_5_3 + 0.000238095238095246*G0_0_1_3_0_0 + 0.000384199134199148*G0_0_1_3_0_2 + 0.000757575757575782*G0_0_1_3_0_3 - 0.000389610389610402*G0_0_1_3_0_4 + 0.000173160173160179*G0_0_1_3_0_5 + 0.00172077922077929*G0_0_1_3_1_2 + 0.0035714285714287*G0_0_1_3_1_3 - 0.0001948051948052*G0_0_1_3_1_4 + 0.000384199134199148*G0_0_1_3_2_0 + 0.00172077922077929*G0_0_1_3_2_1 - 0.00957792207792243*G0_0_1_3_2_2 - 0.00969696969697005*G0_0_1_3_2_3 - 0.0013419913419914*G0_0_1_3_2_4 - 0.00023809523809525*G0_0_1_3_2_5 + 0.000757575757575782*G0_0_1_3_3_0 + 0.0035714285714287*G0_0_1_3_3_1 - 0.00969696969697005*G0_0_1_3_3_2 - 0.0267532467532478*G0_0_1_3_3_3 - 0.00112554112554118*G0_0_1_3_3_4 - 0.00103896103896108*G0_0_1_3_3_5 - 0.000389610389610402*G0_0_1_3_4_0 - 0.0001948051948052*G0_0_1_3_4_1 - 0.0013419913419914*G0_0_1_3_4_2 - 0.00112554112554118*G0_0_1_3_4_3 + 0.00432900432900447*G0_0_1_3_4_4 + 0.000865800865800896*G0_0_1_3_4_5 + 0.000173160173160179*G0_0_1_3_5_0 - 0.00023809523809525*G0_0_1_3_5_2 - 0.00103896103896108*G0_0_1_3_5_3 + 0.000865800865800895*G0_0_1_3_5_4 - 0.000432900432900444*G0_0_1_3_5_5 + 0.00281385281385292*G0_0_1_4_0_0 - 0.000811688311688337*G0_0_1_4_0_2 - 0.000389610389610402*G0_0_1_4_0_3 - 0.000519480519480529*G0_0_1_4_0_4 + 0.000735930735930764*G0_0_1_4_0_5 + 0.000189393939393945*G0_0_1_4_1_1 + 0.000286796536796549*G0_0_1_4_1_2 - 0.0001948051948052*G0_0_1_4_1_3 - 0.00177489177489183*G0_0_1_4_1_4 - 0.000606060606060628*G0_0_1_4_1_5 - 0.000811688311688337*G0_0_1_4_2_0 + 0.000286796536796549*G0_0_1_4_2_1 - 0.00275974025974038*G0_0_1_4_2_2 - 0.0013419913419914*G0_0_1_4_2_3 + 0.00199134199134205*G0_0_1_4_2_4 - 0.000389610389610402*G0_0_1_4_3_0 - 0.0001948051948052*G0_0_1_4_3_1 - 0.0013419913419914*G0_0_1_4_3_2 - 0.00112554112554117*G0_0_1_4_3_3 + 0.00432900432900447*G0_0_1_4_3_4 + 0.000865800865800896*G0_0_1_4_3_5 - 0.000519480519480529*G0_0_1_4_4_0 - 0.00177489177489183*G0_0_1_4_4_1 + 0.00199134199134205*G0_0_1_4_4_2 + 0.00432900432900447*G0_0_1_4_4_3 + 0.0223376623376631*G0_0_1_4_4_4 + 0.00363636363636376*G0_0_1_4_4_5 + 0.000735930735930764*G0_0_1_4_5_0 - 0.000606060606060628*G0_0_1_4_5_1 + 0.000865800865800896*G0_0_1_4_5_3 + 0.00363636363636376*G0_0_1_4_5_4 + 0.00112554112554117*G0_0_1_4_5_5 + 0.00156926406926414*G0_0_1_5_0_0 - 0.000227272727272737*G0_0_1_5_0_1 - 0.000324675324675336*G0_0_1_5_0_2 + 0.000173160173160179*G0_0_1_5_0_3 + 0.000735930735930764*G0_0_1_5_0_4 + 0.00164502164502171*G0_0_1_5_0_5 - 0.000227272727272737*G0_0_1_5_1_0 + 0.000205627705627714*G0_0_1_5_1_1 + 0.000113636363636369*G0_0_1_5_1_2 - 0.000606060606060628*G0_0_1_5_1_4 - 0.000692640692640721*G0_0_1_5_1_5 - 0.000324675324675336*G0_0_1_5_2_0 + 0.000113636363636369*G0_0_1_5_2_1 - 0.00026515151515153*G0_0_1_5_2_2 - 0.00023809523809525*G0_0_1_5_2_3 + 0.000173160173160179*G0_0_1_5_3_0 - 0.00023809523809525*G0_0_1_5_3_2 - 0.00103896103896108*G0_0_1_5_3_3 + 0.000865800865800896*G0_0_1_5_3_4 - 0.000432900432900444*G0_0_1_5_3_5 + 0.000735930735930764*G0_0_1_5_4_0 - 0.000606060606060628*G0_0_1_5_4_1 + 0.000865800865800896*G0_0_1_5_4_3 + 0.00363636363636376*G0_0_1_5_4_4 + 0.00112554112554117*G0_0_1_5_4_5 + 0.00164502164502171*G0_0_1_5_5_0 - 0.000692640692640721*G0_0_1_5_5_1 - 0.000432900432900444*G0_0_1_5_5_3 + 0.00112554112554117*G0_0_1_5_5_4 - 0.000259740259740247*G0_0_1_5_5_5 + 0.0044196428571431*G0_1_0_0_0_0 - 0.00141233766233772*G0_1_0_0_0_1 - 0.000158279220779232*G0_1_0_0_0_2 - 0.000389610389610398*G0_1_0_0_0_3 + 0.000925324675324727*G0_1_0_0_0_4 + 0.00224025974025985*G0_1_0_0_0_5 - 0.00141233766233772*G0_1_0_0_1_0 + 0.00488230519480536*G0_1_0_0_1_1 - 0.000304383116883126*G0_1_0_0_1_2 + 0.000438311688311704*G0_1_0_0_1_3 + 0.00282467532467541*G0_1_0_0_1_5 - 0.000158279220779232*G0_1_0_0_2_0 - 0.000304383116883126*G0_1_0_0_2_1 + 0.0001461038961039*G0_1_0_0_2_2 + 0.000389610389610402*G0_1_0_0_2_3 - 0.000292207792207804*G0_1_0_0_2_4 - 0.000584415584415606*G0_1_0_0_2_5 - 0.000389610389610398*G0_1_0_0_3_0 + 0.000438311688311704*G0_1_0_0_3_1 + 0.000389610389610401*G0_1_0_0_3_2 + 0.00487012987013001*G0_1_0_0_3_3 + 0.000779220779220802*G0_1_0_0_3_4 + 0.00194805194805201*G0_1_0_0_3_5 + 0.000925324675324727*G0_1_0_0_4_0 - 0.000292207792207804*G0_1_0_0_4_2 + 0.000779220779220802*G0_1_0_0_4_3 - 0.000974025974025994*G0_1_0_0_4_4 + 0.00116883116883122*G0_1_0_0_4_5 + 0.00224025974025985*G0_1_0_0_5_0 + 0.00282467532467541*G0_1_0_0_5_1 - 0.000584415584415606*G0_1_0_0_5_2 + 0.00194805194805201*G0_1_0_0_5_3 + 0.00116883116883122*G0_1_0_0_5_4 + 0.0116883116883121*G0_1_0_0_5_5 - 0.00141233766233772*G0_1_0_1_0_0 + 0.00488230519480536*G0_1_0_1_0_1 - 0.000304383116883126*G0_1_0_1_0_2 + 0.000438311688311704*G0_1_0_1_0_3 + 0.00282467532467541*G0_1_0_1_0_5 + 0.00488230519480536*G0_1_0_1_1_0 - 0.0584415584415605*G0_1_0_1_1_1 + 0.00225243506493514*G0_1_0_1_1_2 - 0.0112987012987017*G0_1_0_1_1_3 - 0.000925324675324699*G0_1_0_1_1_4 - 0.0208441558441566*G0_1_0_1_1_5 - 0.000304383116883126*G0_1_0_1_2_0 + 0.00225243506493514*G0_1_0_1_2_1 + 0.000754870129870157*G0_1_0_1_2_2 + 0.00272727272727282*G0_1_0_1_2_3 + 0.000292207792207802*G0_1_0_1_2_4 + 0.00150974025974031*G0_1_0_1_2_5 + 0.000438311688311704*G0_1_0_1_3_0 - 0.0112987012987017*G0_1_0_1_3_1 + 0.00272727272727282*G0_1_0_1_3_2 + 0.00623376623376646*G0_1_0_1_3_3 + 0.000974025974026007*G0_1_0_1_3_4 - 0.00389610389610404*G0_1_0_1_3_5 - 0.000925324675324698*G0_1_0_1_4_1 + 0.000292207792207802*G0_1_0_1_4_2 + 0.000974025974026007*G0_1_0_1_4_3 - 0.000779220779220805*G0_1_0_1_4_4 - 0.00116883116883121*G0_1_0_1_4_5 + 0.00282467532467541*G0_1_0_1_5_0 - 0.0208441558441566*G0_1_0_1_5_1 + 0.00150974025974031*G0_1_0_1_5_2 - 0.00389610389610404*G0_1_0_1_5_3 - 0.00116883116883121*G0_1_0_1_5_4 - 0.0218181818181826*G0_1_0_1_5_5 - 0.000158279220779232*G0_1_0_2_0_0 - 0.000304383116883126*G0_1_0_2_0_1 + 0.0001461038961039*G0_1_0_2_0_2 + 0.000389610389610401*G0_1_0_2_0_3 - 0.000292207792207804*G0_1_0_2_0_4 - 0.000584415584415606*G0_1_0_2_0_5 - 0.000304383116883126*G0_1_0_2_1_0 + 0.00225243506493514*G0_1_0_2_1_1 + 0.000754870129870157*G0_1_0_2_1_2 + 0.00272727272727282*G0_1_0_2_1_3 + 0.000292207792207802*G0_1_0_2_1_4 + 0.00150974025974031*G0_1_0_2_1_5 + 0.0001461038961039*G0_1_0_2_2_0 + 0.000754870129870157*G0_1_0_2_2_1 - 0.00328733766233778*G0_1_0_2_2_2 - 0.00535714285714304*G0_1_0_2_2_3 - 0.000292207792207802*G0_1_0_2_2_5 + 0.000389610389610401*G0_1_0_2_3_0 + 0.00272727272727282*G0_1_0_2_3_1 - 0.00535714285714304*G0_1_0_2_3_2 - 0.0122727272727277*G0_1_0_2_3_3 - 0.00136363636363641*G0_1_0_2_3_4 - 0.000194805194805207*G0_1_0_2_3_5 - 0.000292207792207804*G0_1_0_2_4_0 + 0.000292207792207802*G0_1_0_2_4_1 - 0.00136363636363641*G0_1_0_2_4_3 + 0.00136363636363641*G0_1_0_2_4_4 - 0.000584415584415606*G0_1_0_2_5_0 + 0.00150974025974031*G0_1_0_2_5_1 - 0.000292207792207802*G0_1_0_2_5_2 - 0.000194805194805207*G0_1_0_2_5_3 + 0.0011688311688312*G0_1_0_2_5_5 - 0.000389610389610398*G0_1_0_3_0_0 + 0.000438311688311704*G0_1_0_3_0_1 + 0.000389610389610401*G0_1_0_3_0_2 + 0.00487012987013001*G0_1_0_3_0_3 + 0.000779220779220802*G0_1_0_3_0_4 + 0.00194805194805201*G0_1_0_3_0_5 + 0.000438311688311704*G0_1_0_3_1_0 - 0.0112987012987017*G0_1_0_3_1_1 + 0.00272727272727282*G0_1_0_3_1_2 + 0.00623376623376646*G0_1_0_3_1_3 + 0.000974025974026007*G0_1_0_3_1_4 - 0.00389610389610404*G0_1_0_3_1_5 + 0.000389610389610401*G0_1_0_3_2_0 + 0.00272727272727282*G0_1_0_3_2_1 - 0.00535714285714304*G0_1_0_3_2_2 - 0.0122727272727277*G0_1_0_3_2_3 - 0.00136363636363641*G0_1_0_3_2_4 - 0.000194805194805207*G0_1_0_3_2_5 + 0.00487012987013001*G0_1_0_3_3_0 + 0.00623376623376646*G0_1_0_3_3_1 - 0.0122727272727277*G0_1_0_3_3_2 - 0.0935064935064967*G0_1_0_3_3_3 - 0.0116883116883121*G0_1_0_3_3_4 - 0.00935064935064966*G0_1_0_3_3_5 + 0.000779220779220802*G0_1_0_3_4_0 + 0.000974025974026007*G0_1_0_3_4_1 - 0.00136363636363641*G0_1_0_3_4_2 - 0.0116883116883121*G0_1_0_3_4_3 - 0.0015584415584416*G0_1_0_3_4_5 + 0.00194805194805201*G0_1_0_3_5_0 - 0.00389610389610404*G0_1_0_3_5_1 - 0.000194805194805207*G0_1_0_3_5_2 - 0.00935064935064966*G0_1_0_3_5_3 - 0.0015584415584416*G0_1_0_3_5_4 - 0.00623376623376644*G0_1_0_3_5_5 + 0.000925324675324727*G0_1_0_4_0_0 - 0.000292207792207804*G0_1_0_4_0_2 + 0.000779220779220802*G0_1_0_4_0_3 - 0.000974025974025994*G0_1_0_4_0_4 + 0.00116883116883122*G0_1_0_4_0_5 - 0.000925324675324699*G0_1_0_4_1_1 + 0.000292207792207802*G0_1_0_4_1_2 + 0.000974025974026007*G0_1_0_4_1_3 - 0.000779220779220805*G0_1_0_4_1_4 - 0.00116883116883121*G0_1_0_4_1_5 - 0.000292207792207804*G0_1_0_4_2_0 + 0.000292207792207802*G0_1_0_4_2_1 - 0.00136363636363641*G0_1_0_4_2_3 + 0.00136363636363641*G0_1_0_4_2_4 + 0.000779220779220802*G0_1_0_4_3_0 + 0.000974025974026007*G0_1_0_4_3_1 - 0.00136363636363641*G0_1_0_4_3_2 - 0.0116883116883121*G0_1_0_4_3_3 - 0.0015584415584416*G0_1_0_4_3_5 - 0.000974025974025994*G0_1_0_4_4_0 - 0.000779220779220805*G0_1_0_4_4_1 + 0.00136363636363641*G0_1_0_4_4_2 + 0.0116883116883121*G0_1_0_4_4_4 + 0.00155844155844162*G0_1_0_4_4_5 + 0.00116883116883122*G0_1_0_4_5_0 - 0.00116883116883121*G0_1_0_4_5_1 - 0.0015584415584416*G0_1_0_4_5_3 + 0.00155844155844162*G0_1_0_4_5_4 + 0.00224025974025985*G0_1_0_5_0_0 + 0.00282467532467541*G0_1_0_5_0_1 - 0.000584415584415606*G0_1_0_5_0_2 + 0.00194805194805201*G0_1_0_5_0_3 + 0.00116883116883122*G0_1_0_5_0_4 + 0.0116883116883121*G0_1_0_5_0_5 + 0.00282467532467541*G0_1_0_5_1_0 - 0.0208441558441566*G0_1_0_5_1_1 + 0.00150974025974031*G0_1_0_5_1_2 - 0.00389610389610404*G0_1_0_5_1_3 - 0.00116883116883121*G0_1_0_5_1_4 - 0.0218181818181826*G0_1_0_5_1_5 - 0.000584415584415606*G0_1_0_5_2_0 + 0.00150974025974031*G0_1_0_5_2_1 - 0.000292207792207802*G0_1_0_5_2_2 - 0.000194805194805207*G0_1_0_5_2_3 + 0.0011688311688312*G0_1_0_5_2_5 + 0.00194805194805201*G0_1_0_5_3_0 - 0.00389610389610404*G0_1_0_5_3_1 - 0.000194805194805207*G0_1_0_5_3_2 - 0.00935064935064966*G0_1_0_5_3_3 - 0.0015584415584416*G0_1_0_5_3_4 - 0.00623376623376644*G0_1_0_5_3_5 + 0.00116883116883122*G0_1_0_5_4_0 - 0.00116883116883121*G0_1_0_5_4_1 - 0.0015584415584416*G0_1_0_5_4_3 + 0.00155844155844162*G0_1_0_5_4_4 + 0.0116883116883121*G0_1_0_5_5_0 - 0.0218181818181826*G0_1_0_5_5_1 + 0.0011688311688312*G0_1_0_5_5_2 - 0.00623376623376644*G0_1_0_5_5_3 - 0.0233766233766241*G0_1_0_5_5_5 + 0.00434253246753272*G0_1_1_0_0_0 - 0.000762987012987046*G0_1_1_0_0_1 - 0.000262445887445902*G0_1_1_0_0_2 + 0.000335497835497848*G0_1_1_0_0_3 + 0.00124458874458881*G0_1_1_0_0_4 + 0.00313852813852828*G0_1_1_0_0_5 - 0.000762987012987046*G0_1_1_0_1_0 + 0.000189393939393945*G0_1_1_0_1_3 + 0.000227272727272732*G0_1_1_0_1_4 - 0.000227272727272743*G0_1_1_0_1_5 - 0.000262445887445903*G0_1_1_0_2_0 + 0.00022862554112555*G0_1_1_0_2_2 + 0.000378787878787891*G0_1_1_0_2_3 - 0.000140692640692648*G0_1_1_0_2_5 + 0.000335497835497848*G0_1_1_0_3_0 + 0.000189393939393945*G0_1_1_0_3_1 + 0.000378787878787891*G0_1_1_0_3_2 + 0.00114718614718618*G0_1_1_0_3_3 - 0.00112554112554116*G0_1_1_0_3_4 - 0.0003896103896104*G0_1_1_0_3_5 + 0.00124458874458881*G0_1_1_0_4_0 + 0.000227272727272732*G0_1_1_0_4_1 - 0.00112554112554116*G0_1_1_0_4_3 - 0.00199134199134204*G0_1_1_0_4_4 - 0.000173160173160168*G0_1_1_0_4_5 + 0.00313852813852828*G0_1_1_0_5_0 - 0.000227272727272743*G0_1_1_0_5_1 - 0.000140692640692648*G0_1_1_0_5_2 - 0.0003896103896104*G0_1_1_0_5_3 - 0.000173160173160168*G0_1_1_0_5_4 + 0.00493506493506513*G0_1_1_0_5_5 - 0.000762987012987046*G0_1_1_1_0_0 + 0.000189393939393945*G0_1_1_1_0_3 + 0.000227272727272732*G0_1_1_1_0_4 - 0.000227272727272743*G0_1_1_1_0_5 + 0.00836038961038989*G0_1_1_1_1_1 - 0.000520833333333351*G0_1_1_1_1_2 + 0.000389610389610397*G0_1_1_1_1_3 + 0.000319264069264079*G0_1_1_1_1_4 + 0.000909090909090949*G0_1_1_1_1_5 - 0.000520833333333351*G0_1_1_1_2_1 + 0.000787337662337692*G0_1_1_1_2_2 + 0.00188311688311695*G0_1_1_1_2_3 + 0.000324675324675337*G0_1_1_1_2_4 + 0.000351731601731614*G0_1_1_1_2_5 + 0.000189393939393945*G0_1_1_1_3_0 + 0.000389610389610397*G0_1_1_1_3_1 + 0.00188311688311695*G0_1_1_1_3_2 + 0.000173160173160185*G0_1_1_1_3_3 - 0.00101731601731605*G0_1_1_1_3_4 - 0.00108225108225112*G0_1_1_1_3_5 + 0.000227272727272732*G0_1_1_1_4_0 + 0.000319264069264079*G0_1_1_1_4_1 + 0.000324675324675337*G0_1_1_1_4_2 - 0.00101731601731605*G0_1_1_1_4_3 - 0.00190476190476197*G0_1_1_1_4_4 - 0.00134199134199139*G0_1_1_1_4_5 - 0.000227272727272743*G0_1_1_1_5_0 + 0.000909090909090949*G0_1_1_1_5_1 + 0.000351731601731614*G0_1_1_1_5_2 - 0.00108225108225112*G0_1_1_1_5_3 - 0.00134199134199139*G0_1_1_1_5_4 - 0.00450216450216466*G0_1_1_1_5_5 - 0.000262445887445903*G0_1_1_2_0_0 + 0.00022862554112555*G0_1_1_2_0_2 + 0.000378787878787891*G0_1_1_2_0_3 - 0.000140692640692648*G0_1_1_2_0_5 - 0.000520833333333351*G0_1_1_2_1_1 + 0.000787337662337692*G0_1_1_2_1_2 + 0.00188311688311695*G0_1_1_2_1_3 + 0.000324675324675337*G0_1_1_2_1_4 + 0.000351731601731614*G0_1_1_2_1_5 + 0.00022862554112555*G0_1_1_2_2_0 + 0.000787337662337692*G0_1_1_2_2_1 - 0.00509334415584435*G0_1_1_2_2_2 - 0.00465367965367983*G0_1_1_2_2_3 - 0.000622294372294398*G0_1_1_2_2_4 + 0.000378787878787891*G0_1_1_2_3_0 + 0.00188311688311695*G0_1_1_2_3_1 - 0.00465367965367983*G0_1_1_2_3_2 - 0.0065584415584418*G0_1_1_2_3_3 - 0.00140692640692646*G0_1_1_2_3_4 - 0.000714285714285741*G0_1_1_2_3_5 + 0.000324675324675337*G0_1_1_2_4_1 - 0.000622294372294398*G0_1_1_2_4_2 - 0.00140692640692646*G0_1_1_2_4_3 - 0.000606060606060629*G0_1_1_2_4_5 - 0.000140692640692648*G0_1_1_2_5_0 + 0.000351731601731614*G0_1_1_2_5_1 - 0.000714285714285741*G0_1_1_2_5_3 - 0.000606060606060629*G0_1_1_2_5_4 - 0.000476190476190496*G0_1_1_2_5_5 + 0.000335497835497848*G0_1_1_3_0_0 + 0.000189393939393945*G0_1_1_3_0_1 + 0.000378787878787891*G0_1_1_3_0_2 + 0.00114718614718618*G0_1_1_3_0_3 - 0.00112554112554116*G0_1_1_3_0_4 - 0.0003896103896104*G0_1_1_3_0_5 + 0.000189393939393945*G0_1_1_3_1_0 + 0.000389610389610398*G0_1_1_3_1_1 + 0.00188311688311695*G0_1_1_3_1_2 + 0.000173160173160186*G0_1_1_3_1_3 - 0.00101731601731605*G0_1_1_3_1_4 - 0.00108225108225112*G0_1_1_3_1_5 + 0.000378787878787891*G0_1_1_3_2_0 + 0.00188311688311695*G0_1_1_3_2_1 - 0.00465367965367983*G0_1_1_3_2_2 - 0.0065584415584418*G0_1_1_3_2_3 - 0.00140692640692646*G0_1_1_3_2_4 - 0.000714285714285741*G0_1_1_3_2_5 + 0.00114718614718618*G0_1_1_3_3_0 + 0.000173160173160185*G0_1_1_3_3_1 - 0.0065584415584418*G0_1_1_3_3_2 - 0.0664935064935089*G0_1_1_3_3_3 - 0.000259740259740287*G0_1_1_3_3_4 - 0.000865800865800911*G0_1_1_3_3_5 - 0.00112554112554116*G0_1_1_3_4_0 - 0.00101731601731605*G0_1_1_3_4_1 - 0.00140692640692646*G0_1_1_3_4_2 - 0.000259740259740285*G0_1_1_3_4_3 + 0.00606060606060625*G0_1_1_3_4_4 + 0.00346320346320358*G0_1_1_3_4_5 - 0.000389610389610401*G0_1_1_3_5_0 - 0.00108225108225112*G0_1_1_3_5_1 - 0.000714285714285741*G0_1_1_3_5_2 - 0.00086580086580091*G0_1_1_3_5_3 + 0.00346320346320358*G0_1_1_3_5_4 + 0.00173160173160179*G0_1_1_3_5_5 + 0.00124458874458881*G0_1_1_4_0_0 + 0.000227272727272732*G0_1_1_4_0_1 - 0.00112554112554116*G0_1_1_4_0_3 - 0.00199134199134204*G0_1_1_4_0_4 - 0.000173160173160168*G0_1_1_4_0_5 + 0.000227272727272732*G0_1_1_4_1_0 + 0.000319264069264079*G0_1_1_4_1_1 + 0.000324675324675337*G0_1_1_4_1_2 - 0.00101731601731605*G0_1_1_4_1_3 - 0.00190476190476197*G0_1_1_4_1_4 - 0.00134199134199139*G0_1_1_4_1_5 + 0.000324675324675337*G0_1_1_4_2_1 - 0.000622294372294398*G0_1_1_4_2_2 - 0.00140692640692646*G0_1_1_4_2_3 - 0.000606060606060629*G0_1_1_4_2_5 - 0.00112554112554116*G0_1_1_4_3_0 - 0.00101731601731605*G0_1_1_4_3_1 - 0.00140692640692646*G0_1_1_4_3_2 - 0.000259740259740284*G0_1_1_4_3_3 + 0.00606060606060625*G0_1_1_4_3_4 + 0.00346320346320358*G0_1_1_4_3_5 - 0.00199134199134204*G0_1_1_4_4_0 - 0.00190476190476197*G0_1_1_4_4_1 + 0.00606060606060625*G0_1_1_4_4_3 + 0.0114285714285718*G0_1_1_4_4_4 + 0.00502164502164519*G0_1_1_4_4_5 - 0.000173160173160168*G0_1_1_4_5_0 - 0.00134199134199139*G0_1_1_4_5_1 - 0.000606060606060629*G0_1_1_4_5_2 + 0.00346320346320358*G0_1_1_4_5_3 + 0.00502164502164519*G0_1_1_4_5_4 + 0.00363636363636377*G0_1_1_4_5_5 + 0.00313852813852828*G0_1_1_5_0_0 - 0.000227272727272743*G0_1_1_5_0_1 - 0.000140692640692648*G0_1_1_5_0_2 - 0.0003896103896104*G0_1_1_5_0_3 - 0.000173160173160168*G0_1_1_5_0_4 + 0.00493506493506513*G0_1_1_5_0_5 - 0.000227272727272743*G0_1_1_5_1_0 + 0.000909090909090949*G0_1_1_5_1_1 + 0.000351731601731614*G0_1_1_5_1_2 - 0.00108225108225112*G0_1_1_5_1_3 - 0.00134199134199139*G0_1_1_5_1_4 - 0.00450216450216466*G0_1_1_5_1_5 - 0.000140692640692648*G0_1_1_5_2_0 + 0.000351731601731614*G0_1_1_5_2_1 - 0.000714285714285741*G0_1_1_5_2_3 - 0.000606060606060629*G0_1_1_5_2_4 - 0.000476190476190496*G0_1_1_5_2_5 - 0.000389610389610401*G0_1_1_5_3_0 - 0.00108225108225112*G0_1_1_5_3_1 - 0.000714285714285741*G0_1_1_5_3_2 - 0.00086580086580091*G0_1_1_5_3_3 + 0.00346320346320358*G0_1_1_5_3_4 + 0.00173160173160179*G0_1_1_5_3_5 - 0.000173160173160168*G0_1_1_5_4_0 - 0.00134199134199139*G0_1_1_5_4_1 - 0.000606060606060629*G0_1_1_5_4_2 + 0.00346320346320358*G0_1_1_5_4_3 + 0.00502164502164519*G0_1_1_5_4_4 + 0.00363636363636377*G0_1_1_5_4_5 + 0.00493506493506513*G0_1_1_5_5_0 - 0.00450216450216466*G0_1_1_5_5_1 - 0.000476190476190496*G0_1_1_5_5_2 + 0.00173160173160179*G0_1_1_5_5_3 + 0.00363636363636377*G0_1_1_5_5_4 - 0.00103896103896102*G0_1_1_5_5_5;
    A[4] = A[40] - 0.000346320346320361*G0_0_1_0_0_1 + 0.000248917748917754*G0_0_1_0_0_2 - 0.00156926406926411*G0_0_1_0_0_4 + 0.00156926406926414*G0_0_1_0_0_5 - 0.000346320346320361*G0_0_1_0_1_0 - 0.000116341991341995*G0_0_1_0_1_1 + 0.00028138528138529*G0_0_1_0_1_3 + 0.000270562770562778*G0_0_1_0_1_4 + 0.000248917748917754*G0_0_1_0_2_0 - 0.000735930735930762*G0_0_1_0_2_2 + 0.000844155844155869*G0_0_1_0_2_4 + 0.000183982683982688*G0_0_1_0_2_5 + 0.00028138528138529*G0_0_1_0_3_1 + 0.000389610389610395*G0_0_1_0_3_3 - 0.000735930735930758*G0_0_1_0_3_4 - 0.000562770562770579*G0_0_1_0_3_5 - 0.00156926406926411*G0_0_1_0_4_0 + 0.000270562770562778*G0_0_1_0_4_1 + 0.000844155844155868*G0_0_1_0_4_2 - 0.000735930735930758*G0_0_1_0_4_3 - 0.00147186147186151*G0_0_1_0_4_4 - 0.000909090909090932*G0_0_1_0_4_5 + 0.00156926406926414*G0_0_1_0_5_0 + 0.000183982683982688*G0_0_1_0_5_2 - 0.000562770562770579*G0_0_1_0_5_3 - 0.000909090909090932*G0_0_1_0_5_4 + 0.00329004329004342*G0_0_1_0_5_5 - 0.000346320346320361*G0_0_1_1_0_0 - 0.000116341991341995*G0_0_1_1_0_1 + 0.00028138528138529*G0_0_1_1_0_3 + 0.000270562770562778*G0_0_1_1_0_4 - 0.000116341991341995*G0_0_1_1_1_0 + 0.00756087662337688*G0_0_1_1_1_1 + 0.000351731601731613*G0_0_1_1_1_3 + 0.000129870129870133*G0_0_1_1_1_4 + 0.000703463203463235*G0_0_1_1_1_5 - 0.00127299783549788*G0_0_1_1_2_2 + 0.000162337662337666*G0_0_1_1_2_3 + 0.000238095238095246*G0_0_1_1_2_5 + 0.00028138528138529*G0_0_1_1_3_0 + 0.000351731601731613*G0_0_1_1_3_1 + 0.000162337662337666*G0_0_1_1_3_2 - 0.00339826839826852*G0_0_1_1_3_3 - 0.000822510822510849*G0_0_1_1_3_4 - 0.00103896103896107*G0_0_1_1_3_5 + 0.000270562770562778*G0_0_1_1_4_0 + 0.000129870129870133*G0_0_1_1_4_1 - 0.000822510822510849*G0_0_1_1_4_3 - 0.000129870129870133*G0_0_1_1_4_4 - 0.00073593073593076*G0_0_1_1_4_5 + 0.000703463203463235*G0_0_1_1_5_1 + 0.000238095238095246*G0_0_1_1_5_2 - 0.00103896103896107*G0_0_1_1_5_3 - 0.00073593073593076*G0_0_1_1_5_4 - 0.00380952380952394*G0_0_1_1_5_5 + 0.000248917748917754*G0_0_1_2_0_0 - 0.000735930735930762*G0_0_1_2_0_2 + 0.000844155844155869*G0_0_1_2_0_4 + 0.000183982683982688*G0_0_1_2_0_5 - 0.00127299783549788*G0_0_1_2_1_2 + 0.000162337662337666*G0_0_1_2_1_3 + 0.000238095238095246*G0_0_1_2_1_5 - 0.000735930735930762*G0_0_1_2_2_0 - 0.00127299783549788*G0_0_1_2_2_1 + 0.0201501623376631*G0_0_1_2_2_2 + 0.00492424242424261*G0_0_1_2_2_3 + 0.00213744588744598*G0_0_1_2_2_4 + 0.000243506493506506*G0_0_1_2_2_5 + 0.000162337662337666*G0_0_1_2_3_1 + 0.00492424242424261*G0_0_1_2_3_2 + 0.00313852813852826*G0_0_1_2_3_3 - 0.000476190476190489*G0_0_1_2_3_5 + 0.000844155844155868*G0_0_1_2_4_0 + 0.00213744588744598*G0_0_1_2_4_2 - 0.0020346320346321*G0_0_1_2_4_4 - 0.000562770562770581*G0_0_1_2_4_5 + 0.000183982683982688*G0_0_1_2_5_0 + 0.000238095238095246*G0_0_1_2_5_1 + 0.000243506493506506*G0_0_1_2_5_2 - 0.000476190476190489*G0_0_1_2_5_3 - 0.000562770562770581*G0_0_1_2_5_4 - 0.000519480519480537*G0_0_1_2_5_5 + 0.00028138528138529*G0_0_1_3_0_1 + 0.000389610389610395*G0_0_1_3_0_3 - 0.000735930735930758*G0_0_1_3_0_4 - 0.000562770562770579*G0_0_1_3_0_5 + 0.00028138528138529*G0_0_1_3_1_0 + 0.000351731601731613*G0_0_1_3_1_1 + 0.000162337662337666*G0_0_1_3_1_2 - 0.00339826839826852*G0_0_1_3_1_3 - 0.00082251082251085*G0_0_1_3_1_4 - 0.00103896103896107*G0_0_1_3_1_5 + 0.000162337662337666*G0_0_1_3_2_1 + 0.00492424242424261*G0_0_1_3_2_2 + 0.00313852813852826*G0_0_1_3_2_3 - 0.000476190476190489*G0_0_1_3_2_5 + 0.000389610389610395*G0_0_1_3_3_0 - 0.00339826839826852*G0_0_1_3_3_1 + 0.00313852813852826*G0_0_1_3_3_2 - 0.0397402597402611*G0_0_1_3_3_3 + 0.000865800865800894*G0_0_1_3_3_4 + 0.000173160173160172*G0_0_1_3_3_5 - 0.000735930735930758*G0_0_1_3_4_0 - 0.00082251082251085*G0_0_1_3_4_1 + 0.000865800865800894*G0_0_1_3_4_3 + 0.00173160173160178*G0_0_1_3_4_4 + 0.00259740259740268*G0_0_1_3_4_5 - 0.000562770562770579*G0_0_1_3_5_0 - 0.00103896103896107*G0_0_1_3_5_1 - 0.000476190476190489*G0_0_1_3_5_2 + 0.000173160173160172*G0_0_1_3_5_3 + 0.00259740259740268*G0_0_1_3_5_4 + 0.00216450216450223*G0_0_1_3_5_5 - 0.00156926406926411*G0_0_1_4_0_0 + 0.000270562770562778*G0_0_1_4_0_1 + 0.000844155844155869*G0_0_1_4_0_2 - 0.000735930735930758*G0_0_1_4_0_3 - 0.00147186147186151*G0_0_1_4_0_4 - 0.000909090909090932*G0_0_1_4_0_5 + 0.000270562770562778*G0_0_1_4_1_0 + 0.000129870129870133*G0_0_1_4_1_1 - 0.000822510822510849*G0_0_1_4_1_3 - 0.000129870129870133*G0_0_1_4_1_4 - 0.00073593073593076*G0_0_1_4_1_5 + 0.000844155844155868*G0_0_1_4_2_0 + 0.00213744588744598*G0_0_1_4_2_2 - 0.0020346320346321*G0_0_1_4_2_4 - 0.000562770562770581*G0_0_1_4_2_5 - 0.000735930735930758*G0_0_1_4_3_0 - 0.000822510822510849*G0_0_1_4_3_1 + 0.000865800865800892*G0_0_1_4_3_3 + 0.00173160173160178*G0_0_1_4_3_4 + 0.00259740259740268*G0_0_1_4_3_5 - 0.00147186147186151*G0_0_1_4_4_0 - 0.000129870129870133*G0_0_1_4_4_1 - 0.0020346320346321*G0_0_1_4_4_2 + 0.00173160173160178*G0_0_1_4_4_3 - 0.0109090909090913*G0_0_1_4_4_4 + 0.00138528138528143*G0_0_1_4_4_5 - 0.000909090909090932*G0_0_1_4_5_0 - 0.00073593073593076*G0_0_1_4_5_1 - 0.000562770562770581*G0_0_1_4_5_2 + 0.00259740259740268*G0_0_1_4_5_3 + 0.00138528138528143*G0_0_1_4_5_4 + 0.00251082251082259*G0_0_1_4_5_5 + 0.00156926406926414*G0_0_1_5_0_0 + 0.000183982683982688*G0_0_1_5_0_2 - 0.000562770562770579*G0_0_1_5_0_3 - 0.000909090909090932*G0_0_1_5_0_4 + 0.00329004329004342*G0_0_1_5_0_5 + 0.000703463203463235*G0_0_1_5_1_1 + 0.000238095238095246*G0_0_1_5_1_2 - 0.00103896103896107*G0_0_1_5_1_3 - 0.00073593073593076*G0_0_1_5_1_4 - 0.00380952380952394*G0_0_1_5_1_5 + 0.000183982683982688*G0_0_1_5_2_0 + 0.000238095238095246*G0_0_1_5_2_1 + 0.000243506493506506*G0_0_1_5_2_2 - 0.000476190476190489*G0_0_1_5_2_3 - 0.000562770562770581*G0_0_1_5_2_4 - 0.000519480519480537*G0_0_1_5_2_5 - 0.000562770562770579*G0_0_1_5_3_0 - 0.00103896103896107*G0_0_1_5_3_1 - 0.000476190476190489*G0_0_1_5_3_2 + 0.000173160173160171*G0_0_1_5_3_3 + 0.00259740259740268*G0_0_1_5_3_4 + 0.00216450216450223*G0_0_1_5_3_5 - 0.000909090909090932*G0_0_1_5_4_0 - 0.00073593073593076*G0_0_1_5_4_1 - 0.000562770562770581*G0_0_1_5_4_2 + 0.00259740259740268*G0_0_1_5_4_3 + 0.00138528138528143*G0_0_1_5_4_4 + 0.00251082251082259*G0_0_1_5_4_5 + 0.00329004329004342*G0_0_1_5_5_0 - 0.00380952380952394*G0_0_1_5_5_1 - 0.000519480519480537*G0_0_1_5_5_2 + 0.00216450216450223*G0_0_1_5_5_3 + 0.00251082251082259*G0_0_1_5_5_4 - 0.000779220779220806*G0_0_1_5_5_5 + 0.000346320346320361*G0_1_0_0_0_1 - 0.000248917748917754*G0_1_0_0_0_2 + 0.00156926406926411*G0_1_0_0_0_4 - 0.00156926406926414*G0_1_0_0_0_5 + 0.000346320346320361*G0_1_0_0_1_0 + 0.000116341991341995*G0_1_0_0_1_1 - 0.00028138528138529*G0_1_0_0_1_3 - 0.000270562770562778*G0_1_0_0_1_4 - 0.000248917748917754*G0_1_0_0_2_0 + 0.000735930735930763*G0_1_0_0_2_2 - 0.000844155844155869*G0_1_0_0_2_4 - 0.000183982683982688*G0_1_0_0_2_5 - 0.00028138528138529*G0_1_0_0_3_1 - 0.000389610389610395*G0_1_0_0_3_3 + 0.000735930735930757*G0_1_0_0_3_4 + 0.000562770562770579*G0_1_0_0_3_5 + 0.00156926406926411*G0_1_0_0_4_0 - 0.000270562770562778*G0_1_0_0_4_1 - 0.000844155844155869*G0_1_0_0_4_2 + 0.000735930735930757*G0_1_0_0_4_3 + 0.00147186147186151*G0_1_0_0_4_4 + 0.000909090909090932*G0_1_0_0_4_5 - 0.00156926406926414*G0_1_0_0_5_0 - 0.000183982683982688*G0_1_0_0_5_2 + 0.000562770562770579*G0_1_0_0_5_3 + 0.000909090909090932*G0_1_0_0_5_4 - 0.00329004329004342*G0_1_0_0_5_5 + 0.000346320346320361*G0_1_0_1_0_0 + 0.000116341991341995*G0_1_0_1_0_1 - 0.00028138528138529*G0_1_0_1_0_3 - 0.000270562770562778*G0_1_0_1_0_4 + 0.000116341991341995*G0_1_0_1_1_0 - 0.00756087662337688*G0_1_0_1_1_1 - 0.000351731601731613*G0_1_0_1_1_3 - 0.000129870129870133*G0_1_0_1_1_4 - 0.000703463203463235*G0_1_0_1_1_5 + 0.00127299783549788*G0_1_0_1_2_2 - 0.000162337662337666*G0_1_0_1_2_3 - 0.000238095238095246*G0_1_0_1_2_5 - 0.00028138528138529*G0_1_0_1_3_0 - 0.000351731601731613*G0_1_0_1_3_1 - 0.000162337662337666*G0_1_0_1_3_2 + 0.00339826839826852*G0_1_0_1_3_3 + 0.000822510822510849*G0_1_0_1_3_4 + 0.00103896103896107*G0_1_0_1_3_5 - 0.000270562770562778*G0_1_0_1_4_0 - 0.000129870129870133*G0_1_0_1_4_1 + 0.000822510822510849*G0_1_0_1_4_3 + 0.000129870129870133*G0_1_0_1_4_4 + 0.00073593073593076*G0_1_0_1_4_5 - 0.000703463203463235*G0_1_0_1_5_1 - 0.000238095238095246*G0_1_0_1_5_2 + 0.00103896103896107*G0_1_0_1_5_3 + 0.00073593073593076*G0_1_0_1_5_4 + 0.00380952380952394*G0_1_0_1_5_5 - 0.000248917748917754*G0_1_0_2_0_0 + 0.000735930735930762*G0_1_0_2_0_2 - 0.000844155844155868*G0_1_0_2_0_4 - 0.000183982683982688*G0_1_0_2_0_5 + 0.00127299783549788*G0_1_0_2_1_2 - 0.000162337662337666*G0_1_0_2_1_3 - 0.000238095238095246*G0_1_0_2_1_5 + 0.000735930735930763*G0_1_0_2_2_0 + 0.00127299783549788*G0_1_0_2_2_1 - 0.0201501623376631*G0_1_0_2_2_2 - 0.00492424242424261*G0_1_0_2_2_3 - 0.00213744588744598*G0_1_0_2_2_4 - 0.000243506493506506*G0_1_0_2_2_5 - 0.000162337662337666*G0_1_0_2_3_1 - 0.00492424242424261*G0_1_0_2_3_2 - 0.00313852813852826*G0_1_0_2_3_3 + 0.000476190476190489*G0_1_0_2_3_5 - 0.000844155844155868*G0_1_0_2_4_0 - 0.00213744588744598*G0_1_0_2_4_2 + 0.0020346320346321*G0_1_0_2_4_4 + 0.000562770562770581*G0_1_0_2_4_5 - 0.000183982683982688*G0_1_0_2_5_0 - 0.000238095238095246*G0_1_0_2_5_1 - 0.000243506493506506*G0_1_0_2_5_2 + 0.000476190476190489*G0_1_0_2_5_3 + 0.000562770562770581*G0_1_0_2_5_4 + 0.000519480519480537*G0_1_0_2_5_5 - 0.00028138528138529*G0_1_0_3_0_1 - 0.000389610389610395*G0_1_0_3_0_3 + 0.000735930735930758*G0_1_0_3_0_4 + 0.000562770562770579*G0_1_0_3_0_5 - 0.00028138528138529*G0_1_0_3_1_0 - 0.000351731601731613*G0_1_0_3_1_1 - 0.000162337662337666*G0_1_0_3_1_2 + 0.00339826839826852*G0_1_0_3_1_3 + 0.00082251082251085*G0_1_0_3_1_4 + 0.00103896103896107*G0_1_0_3_1_5 - 0.000162337662337666*G0_1_0_3_2_1 - 0.00492424242424261*G0_1_0_3_2_2 - 0.00313852813852826*G0_1_0_3_2_3 + 0.000476190476190489*G0_1_0_3_2_5 - 0.000389610389610396*G0_1_0_3_3_0 + 0.00339826839826852*G0_1_0_3_3_1 - 0.00313852813852826*G0_1_0_3_3_2 + 0.0397402597402611*G0_1_0_3_3_3 - 0.000865800865800894*G0_1_0_3_3_4 - 0.000173160173160172*G0_1_0_3_3_5 + 0.000735930735930758*G0_1_0_3_4_0 + 0.000822510822510849*G0_1_0_3_4_1 - 0.000865800865800896*G0_1_0_3_4_3 - 0.00173160173160178*G0_1_0_3_4_4 - 0.00259740259740268*G0_1_0_3_4_5 + 0.000562770562770579*G0_1_0_3_5_0 + 0.00103896103896107*G0_1_0_3_5_1 + 0.000476190476190489*G0_1_0_3_5_2 - 0.000173160173160173*G0_1_0_3_5_3 - 0.00259740259740268*G0_1_0_3_5_4 - 0.00216450216450223*G0_1_0_3_5_5 + 0.00156926406926411*G0_1_0_4_0_0 - 0.000270562770562778*G0_1_0_4_0_1 - 0.000844155844155869*G0_1_0_4_0_2 + 0.000735930735930758*G0_1_0_4_0_3 + 0.00147186147186151*G0_1_0_4_0_4 + 0.000909090909090932*G0_1_0_4_0_5 - 0.000270562770562778*G0_1_0_4_1_0 - 0.000129870129870133*G0_1_0_4_1_1 + 0.000822510822510849*G0_1_0_4_1_3 + 0.000129870129870133*G0_1_0_4_1_4 + 0.00073593073593076*G0_1_0_4_1_5 - 0.000844155844155868*G0_1_0_4_2_0 - 0.00213744588744598*G0_1_0_4_2_2 + 0.0020346320346321*G0_1_0_4_2_4 + 0.000562770562770581*G0_1_0_4_2_5 + 0.000735930735930758*G0_1_0_4_3_0 + 0.000822510822510849*G0_1_0_4_3_1 - 0.000865800865800891*G0_1_0_4_3_3 - 0.00173160173160178*G0_1_0_4_3_4 - 0.00259740259740268*G0_1_0_4_3_5 + 0.00147186147186151*G0_1_0_4_4_0 + 0.000129870129870133*G0_1_0_4_4_1 + 0.0020346320346321*G0_1_0_4_4_2 - 0.00173160173160178*G0_1_0_4_4_3 + 0.0109090909090913*G0_1_0_4_4_4 - 0.00138528138528143*G0_1_0_4_4_5 + 0.000909090909090932*G0_1_0_4_5_0 + 0.00073593073593076*G0_1_0_4_5_1 + 0.000562770562770581*G0_1_0_4_5_2 - 0.00259740259740268*G0_1_0_4_5_3 - 0.00138528138528143*G0_1_0_4_5_4 - 0.00251082251082259*G0_1_0_4_5_5 - 0.00156926406926414*G0_1_0_5_0_0 - 0.000183982683982688*G0_1_0_5_0_2 + 0.000562770562770579*G0_1_0_5_0_3 + 0.000909090909090932*G0_1_0_5_0_4 - 0.00329004329004342*G0_1_0_5_0_5 - 0.000703463203463235*G0_1_0_5_1_1 - 0.000238095238095246*G0_1_0_5_1_2 + 0.00103896103896107*G0_1_0_5_1_3 + 0.00073593073593076*G0_1_0_5_1_4 + 0.00380952380952394*G0_1_0_5_1_5 - 0.000183982683982688*G0_1_0_5_2_0 - 0.000238095238095246*G0_1_0_5_2_1 - 0.000243506493506506*G0_1_0_5_2_2 + 0.000476190476190489*G0_1_0_5_2_3 + 0.000562770562770581*G0_1_0_5_2_4 + 0.000519480519480537*G0_1_0_5_2_5 + 0.000562770562770579*G0_1_0_5_3_0 + 0.00103896103896107*G0_1_0_5_3_1 + 0.000476190476190489*G0_1_0_5_3_2 - 0.000173160173160171*G0_1_0_5_3_3 - 0.00259740259740268*G0_1_0_5_3_4 - 0.00216450216450223*G0_1_0_5_3_5 + 0.000909090909090932*G0_1_0_5_4_0 + 0.00073593073593076*G0_1_0_5_4_1 + 0.000562770562770581*G0_1_0_5_4_2 - 0.00259740259740268*G0_1_0_5_4_3 - 0.00138528138528143*G0_1_0_5_4_4 - 0.00251082251082259*G0_1_0_5_4_5 - 0.00329004329004342*G0_1_0_5_5_0 + 0.00380952380952394*G0_1_0_5_5_1 + 0.000519480519480537*G0_1_0_5_5_2 - 0.00216450216450223*G0_1_0_5_5_3 - 0.00251082251082259*G0_1_0_5_5_4 + 0.000779220779220809*G0_1_0_5_5_5;
    A[60] = -A[40] + 0.0668019480519504*G0_1_0_0_0_0 - 0.00531114718614737*G0_1_0_0_0_1 - 0.00252435064935074*G0_1_0_0_0_2 + 0.00134199134199138*G0_1_0_0_0_3 + 0.010119047619048*G0_1_0_0_0_4 + 0.0233225108225117*G0_1_0_0_0_5 - 0.00531114718614737*G0_1_0_0_1_0 + 0.000533008658008677*G0_1_0_0_1_1 + 0.000201569264069272*G0_1_0_0_1_2 + 0.000508658008658024*G0_1_0_0_1_3 - 0.00305194805194816*G0_1_0_0_1_5 - 0.00252435064935074*G0_1_0_0_2_0 + 0.000201569264069272*G0_1_0_0_2_1 - 0.000703463203463227*G0_1_0_0_2_2 - 0.000974025974026011*G0_1_0_0_2_5 + 0.00134199134199138*G0_1_0_0_3_0 + 0.000508658008658024*G0_1_0_0_3_1 - 0.000735930735930764*G0_1_0_0_3_3 - 0.00272727272727281*G0_1_0_0_3_4 - 0.000735930735930759*G0_1_0_0_3_5 + 0.010119047619048*G0_1_0_0_4_0 - 0.00272727272727281*G0_1_0_0_4_3 - 0.00753246753246776*G0_1_0_0_4_4 + 0.00190476190476198*G0_1_0_0_4_5 + 0.0233225108225117*G0_1_0_0_5_0 - 0.00305194805194816*G0_1_0_0_5_1 - 0.000974025974026011*G0_1_0_0_5_2 - 0.000735930735930759*G0_1_0_0_5_3 + 0.00190476190476198*G0_1_0_0_5_4 + 0.0206060606060614*G0_1_0_0_5_5 - 0.00531114718614737*G0_1_0_1_0_0 + 0.000533008658008677*G0_1_0_1_0_1 + 0.000201569264069272*G0_1_0_1_0_2 + 0.000508658008658024*G0_1_0_1_0_3 - 0.00305194805194816*G0_1_0_1_0_5 + 0.000533008658008677*G0_1_0_1_1_0 + 0.0074837662337665*G0_1_0_1_1_1 - 0.000162337662337668*G0_1_0_1_1_2 + 0.00067099567099569*G0_1_0_1_1_3 + 0.000854978354978382*G0_1_0_1_1_4 + 0.00160173160173167*G0_1_0_1_1_5 + 0.000201569264069272*G0_1_0_1_2_0 - 0.000162337662337668*G0_1_0_1_2_1 - 0.00119047619047623*G0_1_0_1_2_2 + 0.000487012987013005*G0_1_0_1_2_3 + 0.000681818181818205*G0_1_0_1_2_5 + 0.000508658008658024*G0_1_0_1_3_0 + 0.00067099567099569*G0_1_0_1_3_1 + 0.000487012987013005*G0_1_0_1_3_2 - 0.00441558441558457*G0_1_0_1_3_3 - 0.00272727272727282*G0_1_0_1_3_4 - 0.00238095238095246*G0_1_0_1_3_5 + 0.000854978354978382*G0_1_0_1_4_1 - 0.00272727272727282*G0_1_0_1_4_3 - 0.00385281385281398*G0_1_0_1_4_4 - 0.00307359307359318*G0_1_0_1_4_5 - 0.00305194805194816*G0_1_0_1_5_0 + 0.00160173160173166*G0_1_0_1_5_1 + 0.000681818181818205*G0_1_0_1_5_2 - 0.00238095238095246*G0_1_0_1_5_3 - 0.00307359307359318*G0_1_0_1_5_4 - 0.0105627705627709*G0_1_0_1_5_5 - 0.00252435064935074*G0_1_0_2_0_0 + 0.000201569264069272*G0_1_0_2_0_1 - 0.000703463203463227*G0_1_0_2_0_2 - 0.000974025974026011*G0_1_0_2_0_5 + 0.000201569264069272*G0_1_0_2_1_0 - 0.000162337662337668*G0_1_0_2_1_1 - 0.00119047619047623*G0_1_0_2_1_2 + 0.000487012987013005*G0_1_0_2_1_3 + 0.000681818181818205*G0_1_0_2_1_5 - 0.000703463203463227*G0_1_0_2_2_0 - 0.00119047619047623*G0_1_0_2_2_1 + 0.0183441558441565*G0_1_0_2_2_2 + 0.0043019480519482*G0_1_0_2_2_3 + 0.0028409090909092*G0_1_0_2_2_4 + 0.000514069264069285*G0_1_0_2_2_5 + 0.000487012987013005*G0_1_0_2_3_1 + 0.0043019480519482*G0_1_0_2_3_2 + 0.00173160173160179*G0_1_0_2_3_3 - 0.000108225108225109*G0_1_0_2_3_4 - 0.00108225108225112*G0_1_0_2_3_5 + 0.0028409090909092*G0_1_0_2_4_2 - 0.000108225108225109*G0_1_0_2_4_3 + 0.0036796536796538*G0_1_0_2_4_4 - 0.00108225108225112*G0_1_0_2_4_5 - 0.000974025974026011*G0_1_0_2_5_0 + 0.000681818181818205*G0_1_0_2_5_1 + 0.000514069264069285*G0_1_0_2_5_2 - 0.00108225108225112*G0_1_0_2_5_3 - 0.00108225108225112*G0_1_0_2_5_4 - 0.00216450216450224*G0_1_0_2_5_5 + 0.00134199134199138*G0_1_0_3_0_0 + 0.000508658008658024*G0_1_0_3_0_1 - 0.000735930735930764*G0_1_0_3_0_3 - 0.00272727272727281*G0_1_0_3_0_4 - 0.000735930735930759*G0_1_0_3_0_5 + 0.000508658008658024*G0_1_0_3_1_0 + 0.00067099567099569*G0_1_0_3_1_1 + 0.000487012987013005*G0_1_0_3_1_2 - 0.00441558441558457*G0_1_0_3_1_3 - 0.00272727272727282*G0_1_0_3_1_4 - 0.00238095238095246*G0_1_0_3_1_5 + 0.000487012987013005*G0_1_0_3_2_1 + 0.0043019480519482*G0_1_0_3_2_2 + 0.00173160173160179*G0_1_0_3_2_3 - 0.000108225108225109*G0_1_0_3_2_4 - 0.00108225108225112*G0_1_0_3_2_5 - 0.000735930735930763*G0_1_0_3_3_0 - 0.00441558441558457*G0_1_0_3_3_1 + 0.00173160173160179*G0_1_0_3_3_2 - 0.0400000000000014*G0_1_0_3_3_3 + 0.00692640692640714*G0_1_0_3_3_4 + 0.00363636363636374*G0_1_0_3_3_5 - 0.00272727272727281*G0_1_0_3_4_0 - 0.00272727272727282*G0_1_0_3_4_1 - 0.000108225108225109*G0_1_0_3_4_2 + 0.00692640692640715*G0_1_0_3_4_3 + 0.0131601731601736*G0_1_0_3_4_4 + 0.00761904761904787*G0_1_0_3_4_5 - 0.000735930735930759*G0_1_0_3_5_0 - 0.00238095238095246*G0_1_0_3_5_1 - 0.00108225108225112*G0_1_0_3_5_2 + 0.00363636363636374*G0_1_0_3_5_3 + 0.00761904761904787*G0_1_0_3_5_4 + 0.00580086580086599*G0_1_0_3_5_5 + 0.010119047619048*G0_1_0_4_0_0 - 0.00272727272727281*G0_1_0_4_0_3 - 0.00753246753246776*G0_1_0_4_0_4 + 0.00190476190476198*G0_1_0_4_0_5 + 0.000854978354978382*G0_1_0_4_1_1 - 0.00272727272727282*G0_1_0_4_1_3 - 0.00385281385281398*G0_1_0_4_1_4 - 0.00307359307359318*G0_1_0_4_1_5 + 0.0028409090909092*G0_1_0_4_2_2 - 0.000108225108225109*G0_1_0_4_2_3 + 0.0036796536796538*G0_1_0_4_2_4 - 0.00108225108225112*G0_1_0_4_2_5 - 0.00272727272727281*G0_1_0_4_3_0 - 0.00272727272727282*G0_1_0_4_3_1 - 0.000108225108225109*G0_1_0_4_3_2 + 0.00692640692640714*G0_1_0_4_3_3 + 0.0131601731601736*G0_1_0_4_3_4 + 0.00761904761904787*G0_1_0_4_3_5 - 0.00753246753246776*G0_1_0_4_4_0 - 0.00385281385281398*G0_1_0_4_4_1 + 0.0036796536796538*G0_1_0_4_4_2 + 0.0131601731601736*G0_1_0_4_4_3 + 0.0161038961038966*G0_1_0_4_4_4 + 0.0098701298701302*G0_1_0_4_4_5 + 0.00190476190476198*G0_1_0_4_5_0 - 0.00307359307359318*G0_1_0_4_5_1 - 0.00108225108225112*G0_1_0_4_5_2 + 0.00761904761904787*G0_1_0_4_5_3 + 0.0098701298701302*G0_1_0_4_5_4 + 0.0104761904761908*G0_1_0_4_5_5 + 0.0233225108225117*G0_1_0_5_0_0 - 0.00305194805194816*G0_1_0_5_0_1 - 0.000974025974026011*G0_1_0_5_0_2 - 0.000735930735930759*G0_1_0_5_0_3 + 0.00190476190476198*G0_1_0_5_0_4 + 0.0206060606060614*G0_1_0_5_0_5 - 0.00305194805194816*G0_1_0_5_1_0 + 0.00160173160173166*G0_1_0_5_1_1 + 0.000681818181818205*G0_1_0_5_1_2 - 0.00238095238095246*G0_1_0_5_1_3 - 0.00307359307359318*G0_1_0_5_1_4 - 0.0105627705627709*G0_1_0_5_1_5 - 0.000974025974026011*G0_1_0_5_2_0 + 0.000681818181818205*G0_1_0_5_2_1 + 0.000514069264069285*G0_1_0_5_2_2 - 0.00108225108225112*G0_1_0_5_2_3 - 0.00108225108225112*G0_1_0_5_2_4 - 0.00216450216450224*G0_1_0_5_2_5 - 0.000735930735930759*G0_1_0_5_3_0 - 0.00238095238095246*G0_1_0_5_3_1 - 0.00108225108225112*G0_1_0_5_3_2 + 0.00363636363636374*G0_1_0_5_3_3 + 0.00761904761904787*G0_1_0_5_3_4 + 0.00580086580086599*G0_1_0_5_3_5 + 0.00190476190476198*G0_1_0_5_4_0 - 0.00307359307359318*G0_1_0_5_4_1 - 0.00108225108225112*G0_1_0_5_4_2 + 0.00761904761904787*G0_1_0_5_4_3 + 0.0098701298701302*G0_1_0_5_4_4 + 0.0104761904761908*G0_1_0_5_4_5 + 0.0206060606060614*G0_1_0_5_5_0 - 0.0105627705627709*G0_1_0_5_5_1 - 0.00216450216450224*G0_1_0_5_5_2 + 0.00580086580086599*G0_1_0_5_5_3 + 0.0104761904761908*G0_1_0_5_5_4 + 0.0215584415584423*G0_1_0_5_5_5 + 0.0668019480519504*G0_1_1_0_0_0 - 0.00531114718614737*G0_1_1_0_0_1 - 0.00252435064935074*G0_1_1_0_0_2 + 0.00134199134199138*G0_1_1_0_0_3 + 0.010119047619048*G0_1_1_0_0_4 + 0.0233225108225117*G0_1_1_0_0_5 - 0.00531114718614737*G0_1_1_0_1_0 + 0.000533008658008677*G0_1_1_0_1_1 + 0.000201569264069272*G0_1_1_0_1_2 + 0.000508658008658024*G0_1_1_0_1_3 - 0.00305194805194817*G0_1_1_0_1_5 - 0.00252435064935074*G0_1_1_0_2_0 + 0.000201569264069272*G0_1_1_0_2_1 - 0.000703463203463227*G0_1_1_0_2_2 - 0.000974025974026011*G0_1_1_0_2_5 + 0.00134199134199138*G0_1_1_0_3_0 + 0.000508658008658024*G0_1_1_0_3_1 - 0.000735930735930762*G0_1_1_0_3_3 - 0.00272727272727281*G0_1_1_0_3_4 - 0.000735930735930759*G0_1_1_0_3_5 + 0.010119047619048*G0_1_1_0_4_0 - 0.00272727272727281*G0_1_1_0_4_3 - 0.00753246753246776*G0_1_1_0_4_4 + 0.00190476190476198*G0_1_1_0_4_5 + 0.0233225108225117*G0_1_1_0_5_0 - 0.00305194805194817*G0_1_1_0_5_1 - 0.000974025974026011*G0_1_1_0_5_2 - 0.000735930735930759*G0_1_1_0_5_3 + 0.00190476190476198*G0_1_1_0_5_4 + 0.0206060606060614*G0_1_1_0_5_5 - 0.00531114718614737*G0_1_1_1_0_0 + 0.000533008658008677*G0_1_1_1_0_1 + 0.000201569264069272*G0_1_1_1_0_2 + 0.000508658008658024*G0_1_1_1_0_3 - 0.00305194805194817*G0_1_1_1_0_5 + 0.000533008658008677*G0_1_1_1_1_0 + 0.00748376623376649*G0_1_1_1_1_1 - 0.000162337662337667*G0_1_1_1_1_2 + 0.000670995670995688*G0_1_1_1_1_3 + 0.000854978354978383*G0_1_1_1_1_4 + 0.00160173160173167*G0_1_1_1_1_5 + 0.000201569264069272*G0_1_1_1_2_0 - 0.000162337662337667*G0_1_1_1_2_1 - 0.00119047619047623*G0_1_1_1_2_2 + 0.000487012987013005*G0_1_1_1_2_3 + 0.000681818181818205*G0_1_1_1_2_5 + 0.000508658008658024*G0_1_1_1_3_0 + 0.000670995670995689*G0_1_1_1_3_1 + 0.000487012987013005*G0_1_1_1_3_2 - 0.00441558441558457*G0_1_1_1_3_3 - 0.00272727272727282*G0_1_1_1_3_4 - 0.00238095238095246*G0_1_1_1_3_5 + 0.000854978354978383*G0_1_1_1_4_1 - 0.00272727272727282*G0_1_1_1_4_3 - 0.00385281385281398*G0_1_1_1_4_4 - 0.00307359307359318*G0_1_1_1_4_5 - 0.00305194805194817*G0_1_1_1_5_0 + 0.00160173160173167*G0_1_1_1_5_1 + 0.000681818181818205*G0_1_1_1_5_2 - 0.00238095238095246*G0_1_1_1_5_3 - 0.00307359307359318*G0_1_1_1_5_4 - 0.0105627705627709*G0_1_1_1_5_5 - 0.00252435064935074*G0_1_1_2_0_0 + 0.000201569264069272*G0_1_1_2_0_1 - 0.000703463203463227*G0_1_1_2_0_2 - 0.000974025974026011*G0_1_1_2_0_5 + 0.000201569264069272*G0_1_1_2_1_0 - 0.000162337662337667*G0_1_1_2_1_1 - 0.00119047619047623*G0_1_1_2_1_2 + 0.000487012987013005*G0_1_1_2_1_3 + 0.000681818181818205*G0_1_1_2_1_5 - 0.000703463203463227*G0_1_1_2_2_0 - 0.00119047619047623*G0_1_1_2_2_1 + 0.0183441558441565*G0_1_1_2_2_2 + 0.0043019480519482*G0_1_1_2_2_3 + 0.0028409090909092*G0_1_1_2_2_4 + 0.000514069264069285*G0_1_1_2_2_5 + 0.000487012987013005*G0_1_1_2_3_1 + 0.0043019480519482*G0_1_1_2_3_2 + 0.00173160173160179*G0_1_1_2_3_3 - 0.000108225108225109*G0_1_1_2_3_4 - 0.00108225108225112*G0_1_1_2_3_5 + 0.0028409090909092*G0_1_1_2_4_2 - 0.000108225108225109*G0_1_1_2_4_3 + 0.0036796536796538*G0_1_1_2_4_4 - 0.00108225108225112*G0_1_1_2_4_5 - 0.000974025974026011*G0_1_1_2_5_0 + 0.000681818181818205*G0_1_1_2_5_1 + 0.000514069264069285*G0_1_1_2_5_2 - 0.00108225108225112*G0_1_1_2_5_3 - 0.00108225108225112*G0_1_1_2_5_4 - 0.00216450216450224*G0_1_1_2_5_5 + 0.00134199134199138*G0_1_1_3_0_0 + 0.000508658008658024*G0_1_1_3_0_1 - 0.000735930735930762*G0_1_1_3_0_3 - 0.00272727272727281*G0_1_1_3_0_4 - 0.000735930735930759*G0_1_1_3_0_5 + 0.000508658008658024*G0_1_1_3_1_0 + 0.000670995670995689*G0_1_1_3_1_1 + 0.000487012987013005*G0_1_1_3_1_2 - 0.00441558441558457*G0_1_1_3_1_3 - 0.00272727272727282*G0_1_1_3_1_4 - 0.00238095238095246*G0_1_1_3_1_5 + 0.000487012987013005*G0_1_1_3_2_1 + 0.0043019480519482*G0_1_1_3_2_2 + 0.00173160173160179*G0_1_1_3_2_3 - 0.000108225108225109*G0_1_1_3_2_4 - 0.00108225108225112*G0_1_1_3_2_5 - 0.000735930735930762*G0_1_1_3_3_0 - 0.00441558441558457*G0_1_1_3_3_1 + 0.00173160173160179*G0_1_1_3_3_2 - 0.0400000000000015*G0_1_1_3_3_3 + 0.00692640692640714*G0_1_1_3_3_4 + 0.00363636363636374*G0_1_1_3_3_5 - 0.00272727272727281*G0_1_1_3_4_0 - 0.00272727272727282*G0_1_1_3_4_1 - 0.000108225108225109*G0_1_1_3_4_2 + 0.00692640692640714*G0_1_1_3_4_3 + 0.0131601731601736*G0_1_1_3_4_4 + 0.00761904761904787*G0_1_1_3_4_5 - 0.000735930735930759*G0_1_1_3_5_0 - 0.00238095238095246*G0_1_1_3_5_1 - 0.00108225108225112*G0_1_1_3_5_2 + 0.00363636363636374*G0_1_1_3_5_3 + 0.00761904761904787*G0_1_1_3_5_4 + 0.00580086580086599*G0_1_1_3_5_5 + 0.010119047619048*G0_1_1_4_0_0 - 0.00272727272727281*G0_1_1_4_0_3 - 0.00753246753246776*G0_1_1_4_0_4 + 0.00190476190476198*G0_1_1_4_0_5 + 0.000854978354978383*G0_1_1_4_1_1 - 0.00272727272727282*G0_1_1_4_1_3 - 0.00385281385281398*G0_1_1_4_1_4 - 0.00307359307359318*G0_1_1_4_1_5 + 0.0028409090909092*G0_1_1_4_2_2 - 0.000108225108225109*G0_1_1_4_2_3 + 0.0036796536796538*G0_1_1_4_2_4 - 0.00108225108225112*G0_1_1_4_2_5 - 0.00272727272727281*G0_1_1_4_3_0 - 0.00272727272727282*G0_1_1_4_3_1 - 0.000108225108225109*G0_1_1_4_3_2 + 0.00692640692640714*G0_1_1_4_3_3 + 0.0131601731601736*G0_1_1_4_3_4 + 0.00761904761904787*G0_1_1_4_3_5 - 0.00753246753246776*G0_1_1_4_4_0 - 0.00385281385281398*G0_1_1_4_4_1 + 0.0036796536796538*G0_1_1_4_4_2 + 0.0131601731601736*G0_1_1_4_4_3 + 0.0161038961038966*G0_1_1_4_4_4 + 0.00987012987013021*G0_1_1_4_4_5 + 0.00190476190476198*G0_1_1_4_5_0 - 0.00307359307359318*G0_1_1_4_5_1 - 0.00108225108225112*G0_1_1_4_5_2 + 0.00761904761904787*G0_1_1_4_5_3 + 0.00987012987013021*G0_1_1_4_5_4 + 0.0104761904761908*G0_1_1_4_5_5 + 0.0233225108225117*G0_1_1_5_0_0 - 0.00305194805194817*G0_1_1_5_0_1 - 0.000974025974026011*G0_1_1_5_0_2 - 0.000735930735930759*G0_1_1_5_0_3 + 0.00190476190476198*G0_1_1_5_0_4 + 0.0206060606060614*G0_1_1_5_0_5 - 0.00305194805194817*G0_1_1_5_1_0 + 0.00160173160173167*G0_1_1_5_1_1 + 0.000681818181818205*G0_1_1_5_1_2 - 0.00238095238095246*G0_1_1_5_1_3 - 0.00307359307359318*G0_1_1_5_1_4 - 0.0105627705627709*G0_1_1_5_1_5 - 0.000974025974026011*G0_1_1_5_2_0 + 0.000681818181818205*G0_1_1_5_2_1 + 0.000514069264069285*G0_1_1_5_2_2 - 0.00108225108225112*G0_1_1_5_2_3 - 0.00108225108225112*G0_1_1_5_2_4 - 0.00216450216450224*G0_1_1_5_2_5 - 0.000735930735930759*G0_1_1_5_3_0 - 0.00238095238095246*G0_1_1_5_3_1 - 0.00108225108225112*G0_1_1_5_3_2 + 0.00363636363636374*G0_1_1_5_3_3 + 0.00761904761904787*G0_1_1_5_3_4 + 0.00580086580086599*G0_1_1_5_3_5 + 0.00190476190476198*G0_1_1_5_4_0 - 0.00307359307359318*G0_1_1_5_4_1 - 0.00108225108225112*G0_1_1_5_4_2 + 0.00761904761904787*G0_1_1_5_4_3 + 0.00987012987013021*G0_1_1_5_4_4 + 0.0104761904761908*G0_1_1_5_4_5 + 0.0206060606060614*G0_1_1_5_5_0 - 0.0105627705627709*G0_1_1_5_5_1 - 0.00216450216450224*G0_1_1_5_5_2 + 0.00580086580086599*G0_1_1_5_5_3 + 0.0104761904761908*G0_1_1_5_5_4 + 0.0215584415584424*G0_1_1_5_5_5;
    A[71] = -A[41] + 0.0226379870129877*G0_0_0_0_0_0 - 0.00096590909090912*G0_0_0_0_0_1 - 0.00151515151515156*G0_0_0_0_0_2 + 0.000346320346320355*G0_0_0_0_0_3 + 0.00891774891774921*G0_0_0_0_0_4 + 0.00325757575757587*G0_0_0_0_0_5 - 0.00096590909090912*G0_0_0_0_1_0 - 0.00184523809523815*G0_0_0_0_1_1 + 0.000273268398268408*G0_0_0_0_1_2 - 0.000790043290043317*G0_0_0_0_1_3 - 0.000259740259740269*G0_0_0_0_1_4 + 0.000194805194805199*G0_0_0_0_1_5 - 0.00151515151515156*G0_0_0_0_2_0 + 0.000273268398268408*G0_0_0_0_2_1 - 0.00170183982683989*G0_0_0_0_2_2 - 0.00311688311688322*G0_0_0_0_2_4 - 0.000411255411255426*G0_0_0_0_2_5 + 0.000346320346320355*G0_0_0_0_3_0 - 0.000790043290043317*G0_0_0_0_3_1 - 0.000173160173160179*G0_0_0_0_3_4 + 0.000129870129870136*G0_0_0_0_3_5 + 0.00891774891774921*G0_0_0_0_4_0 - 0.000259740259740269*G0_0_0_0_4_1 - 0.00311688311688322*G0_0_0_0_4_2 - 0.000173160173160179*G0_0_0_0_4_3 + 0.00471861471861487*G0_0_0_0_4_4 + 0.00134199134199139*G0_0_0_0_4_5 + 0.00325757575757586*G0_0_0_0_5_0 + 0.000194805194805198*G0_0_0_0_5_1 - 0.000411255411255426*G0_0_0_0_5_2 + 0.000129870129870136*G0_0_0_0_5_3 + 0.00134199134199139*G0_0_0_0_5_4 + 0.00441558441558458*G0_0_0_0_5_5 - 0.00096590909090912*G0_0_0_1_0_0 - 0.00184523809523815*G0_0_0_1_0_1 + 0.000273268398268408*G0_0_0_1_0_2 - 0.000790043290043316*G0_0_0_1_0_3 - 0.000259740259740269*G0_0_0_1_0_4 + 0.000194805194805199*G0_0_0_1_0_5 - 0.00184523809523815*G0_0_0_1_1_0 + 0.058116883116885*G0_0_0_1_1_1 - 0.00403679653679667*G0_0_0_1_1_2 + 0.0173701298701305*G0_0_0_1_1_3 + 0.000768398268398289*G0_0_0_1_1_4 + 0.00730519480519508*G0_0_0_1_1_5 + 0.000273268398268408*G0_0_0_1_2_0 - 0.00403679653679667*G0_0_0_1_2_1 - 0.000349025974025987*G0_0_0_1_2_2 - 0.00201298701298708*G0_0_0_1_2_3 + 0.000119047619047619*G0_0_0_1_2_5 - 0.000790043290043317*G0_0_0_1_3_0 + 0.0173701298701305*G0_0_0_1_3_1 - 0.00201298701298708*G0_0_0_1_3_2 + 0.0161904761904768*G0_0_0_1_3_3 + 0.00134199134199141*G0_0_0_1_3_5 - 0.000259740259740269*G0_0_0_1_4_0 + 0.000768398268398289*G0_0_0_1_4_1 - 0.00264069264069273*G0_0_0_1_4_4 - 0.00177489177489183*G0_0_0_1_4_5 + 0.000194805194805199*G0_0_0_1_5_0 + 0.00730519480519508*G0_0_0_1_5_1 + 0.000119047619047619*G0_0_0_1_5_2 + 0.00134199134199141*G0_0_0_1_5_3 - 0.00177489177489183*G0_0_0_1_5_4 - 0.00718614718614743*G0_0_0_1_5_5 - 0.00151515151515156*G0_0_0_2_0_0 + 0.000273268398268408*G0_0_0_2_0_1 - 0.00170183982683989*G0_0_0_2_0_2 - 0.00311688311688322*G0_0_0_2_0_4 - 0.000411255411255427*G0_0_0_2_0_5 + 0.000273268398268408*G0_0_0_2_1_0 - 0.00403679653679667*G0_0_0_2_1_1 - 0.000349025974025987*G0_0_0_2_1_2 - 0.00201298701298709*G0_0_0_2_1_3 + 0.000119047619047619*G0_0_0_2_1_5 - 0.00170183982683989*G0_0_0_2_2_0 - 0.000349025974025987*G0_0_0_2_2_1 + 0.024366883116884*G0_0_0_2_2_2 + 0.00345238095238109*G0_0_0_2_2_3 + 0.00985930735930772*G0_0_0_2_2_4 + 0.000800865800865833*G0_0_0_2_2_5 - 0.00201298701298709*G0_0_0_2_3_1 + 0.00345238095238109*G0_0_0_2_3_2 - 0.00805194805194833*G0_0_0_2_3_3 - 0.00168831168831175*G0_0_0_2_3_5 - 0.00311688311688322*G0_0_0_2_4_0 + 0.00985930735930772*G0_0_0_2_4_2 + 0.0051082251082253*G0_0_0_2_4_4 - 0.00147186147186152*G0_0_0_2_4_5 - 0.000411255411255427*G0_0_0_2_5_0 + 0.000119047619047619*G0_0_0_2_5_1 + 0.000800865800865833*G0_0_0_2_5_2 - 0.00168831168831175*G0_0_0_2_5_3 - 0.00147186147186152*G0_0_0_2_5_4 - 0.00199134199134206*G0_0_0_2_5_5 + 0.000346320346320355*G0_0_0_3_0_0 - 0.000790043290043317*G0_0_0_3_0_1 - 0.000173160173160179*G0_0_0_3_0_4 + 0.000129870129870136*G0_0_0_3_0_5 - 0.000790043290043316*G0_0_0_3_1_0 + 0.0173701298701305*G0_0_0_3_1_1 - 0.00201298701298708*G0_0_0_3_1_2 + 0.0161904761904768*G0_0_0_3_1_3 + 0.00134199134199141*G0_0_0_3_1_5 - 0.00201298701298709*G0_0_0_3_2_1 + 0.00345238095238109*G0_0_0_3_2_2 - 0.00805194805194833*G0_0_0_3_2_3 - 0.00168831168831175*G0_0_0_3_2_5 + 0.0161904761904768*G0_0_0_3_3_1 - 0.00805194805194833*G0_0_0_3_3_2 + 0.000259740259740272*G0_0_0_3_3_3 - 0.000259740259740274*G0_0_0_3_3_4 + 0.00320346320346332*G0_0_0_3_3_5 - 0.000173160173160179*G0_0_0_3_4_0 - 0.000259740259740276*G0_0_0_3_4_3 + 0.00562770562770581*G0_0_0_3_4_4 + 0.00329004329004339*G0_0_0_3_4_5 + 0.000129870129870136*G0_0_0_3_5_0 + 0.00134199134199141*G0_0_0_3_5_1 - 0.00168831168831175*G0_0_0_3_5_2 + 0.00320346320346332*G0_0_0_3_5_3 + 0.00329004329004339*G0_0_0_3_5_4 + 0.00372294372294384*G0_0_0_3_5_5 + 0.00891774891774921*G0_0_0_4_0_0 - 0.000259740259740269*G0_0_0_4_0_1 - 0.00311688311688322*G0_0_0_4_0_2 - 0.000173160173160179*G0_0_0_4_0_3 + 0.00471861471861487*G0_0_0_4_0_4 + 0.00134199134199139*G0_0_0_4_0_5 - 0.000259740259740269*G0_0_0_4_1_0 + 0.000768398268398288*G0_0_0_4_1_1 - 0.00264069264069273*G0_0_0_4_1_4 - 0.00177489177489183*G0_0_0_4_1_5 - 0.00311688311688322*G0_0_0_4_2_0 + 0.00985930735930772*G0_0_0_4_2_2 + 0.0051082251082253*G0_0_0_4_2_4 - 0.00147186147186152*G0_0_0_4_2_5 - 0.000173160173160179*G0_0_0_4_3_0 - 0.000259740259740275*G0_0_0_4_3_3 + 0.00562770562770581*G0_0_0_4_3_4 + 0.00329004329004339*G0_0_0_4_3_5 + 0.00471861471861487*G0_0_0_4_4_0 - 0.00264069264069273*G0_0_0_4_4_1 + 0.0051082251082253*G0_0_0_4_4_2 + 0.00562770562770581*G0_0_0_4_4_3 + 0.053246753246755*G0_0_0_4_4_4 + 0.00822510822510849*G0_0_0_4_4_5 + 0.00134199134199139*G0_0_0_4_5_0 - 0.00177489177489183*G0_0_0_4_5_1 - 0.00147186147186152*G0_0_0_4_5_2 + 0.00329004329004339*G0_0_0_4_5_3 + 0.00822510822510849*G0_0_0_4_5_4 + 0.00753246753246778*G0_0_0_4_5_5 + 0.00325757575757586*G0_0_0_5_0_0 + 0.000194805194805198*G0_0_0_5_0_1 - 0.000411255411255427*G0_0_0_5_0_2 + 0.000129870129870136*G0_0_0_5_0_3 + 0.00134199134199139*G0_0_0_5_0_4 + 0.00441558441558458*G0_0_0_5_0_5 + 0.000194805194805198*G0_0_0_5_1_0 + 0.00730519480519508*G0_0_0_5_1_1 + 0.000119047619047619*G0_0_0_5_1_2 + 0.00134199134199141*G0_0_0_5_1_3 - 0.00177489177489183*G0_0_0_5_1_4 - 0.00718614718614743*G0_0_0_5_1_5 - 0.000411255411255427*G0_0_0_5_2_0 + 0.000119047619047619*G0_0_0_5_2_1 + 0.000800865800865833*G0_0_0_5_2_2 - 0.00168831168831175*G0_0_0_5_2_3 - 0.00147186147186152*G0_0_0_5_2_4 - 0.00199134199134206*G0_0_0_5_2_5 + 0.000129870129870136*G0_0_0_5_3_0 + 0.00134199134199141*G0_0_0_5_3_1 - 0.00168831168831175*G0_0_0_5_3_2 + 0.00320346320346332*G0_0_0_5_3_3 + 0.00329004329004339*G0_0_0_5_3_4 + 0.00372294372294384*G0_0_0_5_3_5 + 0.00134199134199139*G0_0_0_5_4_0 - 0.00177489177489183*G0_0_0_5_4_1 - 0.00147186147186152*G0_0_0_5_4_2 + 0.00329004329004339*G0_0_0_5_4_3 + 0.00822510822510849*G0_0_0_5_4_4 + 0.00753246753246778*G0_0_0_5_4_5 + 0.00441558441558458*G0_0_0_5_5_0 - 0.00718614718614743*G0_0_0_5_5_1 - 0.00199134199134206*G0_0_0_5_5_2 + 0.00372294372294384*G0_0_0_5_5_3 + 0.00753246753246778*G0_0_0_5_5_4 + 0.0049350649350651*G0_0_0_5_5_5 - 0.00172889610389617*G0_1_0_0_0_0 - 0.000616883116883138*G0_1_0_0_0_1 + 0.000186688311688319*G0_1_0_0_0_2 - 0.000454545454545466*G0_1_0_0_0_3 - 0.000941558441558474*G0_1_0_0_0_4 - 0.000194805194805194*G0_1_0_0_0_5 - 0.000616883116883138*G0_1_0_0_1_0 + 0.00219155844155852*G0_1_0_0_1_1 - 0.000909090909090939*G0_1_0_0_1_3 - 0.000194805194805202*G0_1_0_0_1_4 + 0.00220779220779228*G0_1_0_0_1_5 + 0.000186688311688319*G0_1_0_0_2_0 - 0.00018668831168832*G0_1_0_0_2_2 + 0.000454545454545469*G0_1_0_0_2_3 - 0.000454545454545471*G0_1_0_0_2_5 - 0.000454545454545466*G0_1_0_0_3_0 - 0.000909090909090939*G0_1_0_0_3_1 + 0.000454545454545469*G0_1_0_0_3_2 + 0.00207792207792213*G0_1_0_0_3_3 + 0.00129870129870134*G0_1_0_0_3_4 + 0.00181818181818188*G0_1_0_0_3_5 - 0.000941558441558474*G0_1_0_0_4_0 - 0.000194805194805202*G0_1_0_0_4_1 + 0.00129870129870134*G0_1_0_0_4_3 - 0.000389610389610407*G0_1_0_0_4_4 + 0.00129870129870134*G0_1_0_0_4_5 - 0.000194805194805194*G0_1_0_0_5_0 + 0.00220779220779228*G0_1_0_0_5_1 - 0.000454545454545471*G0_1_0_0_5_2 + 0.00181818181818188*G0_1_0_0_5_3 + 0.00129870129870134*G0_1_0_0_5_4 + 0.0124675324675329*G0_1_0_0_5_5 - 0.000616883116883138*G0_1_0_1_0_0 + 0.00219155844155852*G0_1_0_1_0_1 - 0.000909090909090939*G0_1_0_1_0_3 - 0.000194805194805202*G0_1_0_1_0_4 + 0.00220779220779228*G0_1_0_1_0_5 + 0.00219155844155852*G0_1_0_1_1_0 - 0.00219155844155852*G0_1_0_1_1_2 + 0.0100649350649354*G0_1_0_1_1_3 - 0.0100649350649354*G0_1_0_1_1_5 - 0.00219155844155852*G0_1_0_1_2_1 + 0.000616883116883138*G0_1_0_1_2_2 - 0.00220779220779229*G0_1_0_1_2_3 + 0.0001948051948052*G0_1_0_1_2_4 + 0.000909090909090938*G0_1_0_1_2_5 - 0.000909090909090939*G0_1_0_1_3_0 + 0.0100649350649354*G0_1_0_1_3_1 - 0.00220779220779229*G0_1_0_1_3_2 + 0.0233766233766242*G0_1_0_1_3_3 + 0.00181818181818188*G0_1_0_1_3_4 - 0.000194805194805202*G0_1_0_1_4_0 + 0.0001948051948052*G0_1_0_1_4_2 + 0.00181818181818188*G0_1_0_1_4_3 - 0.00181818181818188*G0_1_0_1_4_5 + 0.00220779220779228*G0_1_0_1_5_0 - 0.0100649350649354*G0_1_0_1_5_1 + 0.000909090909090938*G0_1_0_1_5_2 - 0.00181818181818188*G0_1_0_1_5_4 - 0.0233766233766242*G0_1_0_1_5_5 + 0.000186688311688319*G0_1_0_2_0_0 - 0.00018668831168832*G0_1_0_2_0_2 + 0.000454545454545469*G0_1_0_2_0_3 - 0.000454545454545471*G0_1_0_2_0_5 - 0.00219155844155852*G0_1_0_2_1_1 + 0.000616883116883138*G0_1_0_2_1_2 - 0.00220779220779229*G0_1_0_2_1_3 + 0.0001948051948052*G0_1_0_2_1_4 + 0.000909090909090938*G0_1_0_2_1_5 - 0.00018668831168832*G0_1_0_2_2_0 + 0.000616883116883138*G0_1_0_2_2_1 + 0.00172889610389619*G0_1_0_2_2_2 + 0.00019480519480521*G0_1_0_2_2_3 + 0.000941558441558483*G0_1_0_2_2_4 + 0.000454545454545472*G0_1_0_2_2_5 + 0.000454545454545469*G0_1_0_2_3_0 - 0.00220779220779229*G0_1_0_2_3_1 + 0.00019480519480521*G0_1_0_2_3_2 - 0.0124675324675329*G0_1_0_2_3_3 - 0.00129870129870134*G0_1_0_2_3_4 - 0.00181818181818189*G0_1_0_2_3_5 + 0.0001948051948052*G0_1_0_2_4_1 + 0.000941558441558483*G0_1_0_2_4_2 - 0.00129870129870134*G0_1_0_2_4_3 + 0.00038961038961041*G0_1_0_2_4_4 - 0.00129870129870134*G0_1_0_2_4_5 - 0.000454545454545471*G0_1_0_2_5_0 + 0.000909090909090938*G0_1_0_2_5_1 + 0.000454545454545472*G0_1_0_2_5_2 - 0.00181818181818189*G0_1_0_2_5_3 - 0.00129870129870134*G0_1_0_2_5_4 - 0.00207792207792215*G0_1_0_2_5_5 - 0.000454545454545466*G0_1_0_3_0_0 - 0.000909090909090939*G0_1_0_3_0_1 + 0.000454545454545469*G0_1_0_3_0_2 + 0.00207792207792213*G0_1_0_3_0_3 + 0.00129870129870134*G0_1_0_3_0_4 + 0.00181818181818188*G0_1_0_3_0_5 - 0.000909090909090939*G0_1_0_3_1_0 + 0.0100649350649354*G0_1_0_3_1_1 - 0.00220779220779229*G0_1_0_3_1_2 + 0.0233766233766242*G0_1_0_3_1_3 + 0.00181818181818188*G0_1_0_3_1_4 + 0.000454545454545469*G0_1_0_3_2_0 - 0.00220779220779229*G0_1_0_3_2_1 + 0.00019480519480521*G0_1_0_3_2_2 - 0.0124675324675329*G0_1_0_3_2_3 - 0.00129870129870134*G0_1_0_3_2_4 - 0.00181818181818189*G0_1_0_3_2_5 + 0.00207792207792213*G0_1_0_3_3_0 + 0.0233766233766242*G0_1_0_3_3_1 - 0.0124675324675329*G0_1_0_3_3_2 - 0.00467532467532471*G0_1_0_3_3_3 - 0.00779220779220803*G0_1_0_3_3_4 - 0.000519480519480501*G0_1_0_3_3_5 + 0.00129870129870134*G0_1_0_3_4_0 + 0.00181818181818188*G0_1_0_3_4_1 - 0.00129870129870134*G0_1_0_3_4_2 - 0.00779220779220803*G0_1_0_3_4_3 - 0.00259740259740268*G0_1_0_3_4_4 + 0.00181818181818188*G0_1_0_3_5_0 - 0.00181818181818189*G0_1_0_3_5_2 - 0.000519480519480501*G0_1_0_3_5_3 + 0.000519480519480552*G0_1_0_3_5_5 - 0.000941558441558475*G0_1_0_4_0_0 - 0.000194805194805202*G0_1_0_4_0_1 + 0.00129870129870134*G0_1_0_4_0_3 - 0.000389610389610407*G0_1_0_4_0_4 + 0.00129870129870134*G0_1_0_4_0_5 - 0.000194805194805202*G0_1_0_4_1_0 + 0.0001948051948052*G0_1_0_4_1_2 + 0.00181818181818188*G0_1_0_4_1_3 - 0.00181818181818188*G0_1_0_4_1_5 + 0.0001948051948052*G0_1_0_4_2_1 + 0.000941558441558483*G0_1_0_4_2_2 - 0.00129870129870134*G0_1_0_4_2_3 + 0.00038961038961041*G0_1_0_4_2_4 - 0.00129870129870134*G0_1_0_4_2_5 + 0.00129870129870134*G0_1_0_4_3_0 + 0.00181818181818188*G0_1_0_4_3_1 - 0.00129870129870134*G0_1_0_4_3_2 - 0.00779220779220803*G0_1_0_4_3_3 - 0.00259740259740267*G0_1_0_4_3_4 - 0.000389610389610407*G0_1_0_4_4_0 + 0.00038961038961041*G0_1_0_4_4_2 - 0.00259740259740268*G0_1_0_4_4_3 + 0.00259740259740269*G0_1_0_4_4_5 + 0.00129870129870134*G0_1_0_4_5_0 - 0.00181818181818188*G0_1_0_4_5_1 - 0.00129870129870134*G0_1_0_4_5_2 + 0.00259740259740269*G0_1_0_4_5_4 + 0.00779220779220808*G0_1_0_4_5_5 - 0.000194805194805194*G0_1_0_5_0_0 + 0.00220779220779228*G0_1_0_5_0_1 - 0.000454545454545471*G0_1_0_5_0_2 + 0.00181818181818188*G0_1_0_5_0_3 + 0.00129870129870134*G0_1_0_5_0_4 + 0.0124675324675329*G0_1_0_5_0_5 + 0.00220779220779228*G0_1_0_5_1_0 - 0.0100649350649354*G0_1_0_5_1_1 + 0.000909090909090938*G0_1_0_5_1_2 - 0.00181818181818188*G0_1_0_5_1_4 - 0.0233766233766242*G0_1_0_5_1_5 - 0.000454545454545471*G0_1_0_5_2_0 + 0.000909090909090938*G0_1_0_5_2_1 + 0.000454545454545472*G0_1_0_5_2_2 - 0.00181818181818189*G0_1_0_5_2_3 - 0.00129870129870134*G0_1_0_5_2_4 - 0.00207792207792215*G0_1_0_5_2_5 + 0.00181818181818188*G0_1_0_5_3_0 - 0.00181818181818189*G0_1_0_5_3_2 - 0.0005194805194805*G0_1_0_5_3_3 + 0.000519480519480552*G0_1_0_5_3_5 + 0.00129870129870134*G0_1_0_5_4_0 - 0.00181818181818188*G0_1_0_5_4_1 - 0.00129870129870134*G0_1_0_5_4_2 + 0.00259740259740269*G0_1_0_5_4_4 + 0.00779220779220808*G0_1_0_5_4_5 + 0.0124675324675329*G0_1_0_5_5_0 - 0.0233766233766242*G0_1_0_5_5_1 - 0.00207792207792215*G0_1_0_5_5_2 + 0.000519480519480552*G0_1_0_5_5_3 + 0.00779220779220808*G0_1_0_5_5_4 + 0.00467532467532491*G0_1_0_5_5_5;
    A[57] = A[75] - 0.201623376623383*G0_0_1_0_0_0 + 0.0098620129870133*G0_0_1_0_0_1 + 0.00986201298701332*G0_0_1_0_0_2 - 0.00146103896103898*G0_0_1_0_0_3 - 0.0409090909090922*G0_0_1_0_0_4 - 0.0409090909090923*G0_0_1_0_0_5 + 0.0098620129870133*G0_0_1_0_1_0 - 0.000730519480519502*G0_0_1_0_1_1 - 0.000243506493506501*G0_0_1_0_1_2 - 0.000243506493506505*G0_0_1_0_1_3 + 0.000974025974025999*G0_0_1_0_1_4 + 0.00243506493506501*G0_0_1_0_1_5 + 0.00986201298701332*G0_0_1_0_2_0 - 0.000243506493506501*G0_0_1_0_2_1 - 0.000730519480519504*G0_0_1_0_2_2 - 0.000243506493506503*G0_0_1_0_2_3 + 0.00243506493506501*G0_0_1_0_2_4 + 0.000974025974026002*G0_0_1_0_2_5 - 0.00146103896103898*G0_0_1_0_3_0 - 0.000243506493506505*G0_0_1_0_3_1 - 0.000243506493506503*G0_0_1_0_3_2 + 0.000974025974026015*G0_0_1_0_3_4 + 0.000974025974026019*G0_0_1_0_3_5 - 0.0409090909090922*G0_0_1_0_4_0 + 0.000974025974025999*G0_0_1_0_4_1 + 0.00243506493506501*G0_0_1_0_4_2 + 0.000974025974026015*G0_0_1_0_4_3 - 0.00779220779220801*G0_0_1_0_4_4 - 0.00389610389610401*G0_0_1_0_4_5 - 0.0409090909090923*G0_0_1_0_5_0 + 0.00243506493506501*G0_0_1_0_5_1 + 0.000974025974026002*G0_0_1_0_5_2 + 0.000974025974026019*G0_0_1_0_5_3 - 0.00389610389610401*G0_0_1_0_5_4 - 0.007792207792208*G0_0_1_0_5_5 + 0.0098620129870133*G0_0_1_1_0_0 - 0.000730519480519502*G0_0_1_1_0_1 - 0.000243506493506501*G0_0_1_1_0_2 - 0.000243506493506505*G0_0_1_1_0_3 + 0.000974025974025999*G0_0_1_1_0_4 + 0.00243506493506501*G0_0_1_1_0_5 - 0.000730519480519502*G0_0_1_1_1_0 + 0.00178977272727275*G0_0_1_1_1_1 - 0.000572240259740279*G0_0_1_1_1_2 + 0.00185064935064941*G0_0_1_1_1_3 + 0.00180194805194811*G0_0_1_1_1_4 + 0.00228896103896112*G0_0_1_1_1_5 - 0.000243506493506501*G0_0_1_1_2_0 - 0.000572240259740279*G0_0_1_1_2_1 - 0.000572240259740279*G0_0_1_1_2_2 + 0.000194805194805202*G0_0_1_1_2_3 + 0.00180194805194812*G0_0_1_1_2_4 + 0.00180194805194811*G0_0_1_1_2_5 - 0.000243506493506505*G0_0_1_1_3_0 + 0.00185064935064941*G0_0_1_1_3_1 + 0.000194805194805202*G0_0_1_1_3_2 - 0.000389610389610381*G0_0_1_1_3_3 - 0.00311688311688322*G0_0_1_1_3_4 - 0.00311688311688322*G0_0_1_1_3_5 + 0.000974025974026*G0_0_1_1_4_0 + 0.00180194805194811*G0_0_1_1_4_1 + 0.00180194805194812*G0_0_1_1_4_2 - 0.00311688311688322*G0_0_1_1_4_3 - 0.0103246753246757*G0_0_1_1_4_4 - 0.00720779220779246*G0_0_1_1_4_5 + 0.00243506493506501*G0_0_1_1_5_0 + 0.00228896103896112*G0_0_1_1_5_1 + 0.00180194805194811*G0_0_1_1_5_2 - 0.00311688311688322*G0_0_1_1_5_3 - 0.00720779220779246*G0_0_1_1_5_4 - 0.0122727272727277*G0_0_1_1_5_5 + 0.00986201298701332*G0_0_1_2_0_0 - 0.000243506493506501*G0_0_1_2_0_1 - 0.000730519480519504*G0_0_1_2_0_2 - 0.000243506493506503*G0_0_1_2_0_3 + 0.00243506493506501*G0_0_1_2_0_4 + 0.000974025974026002*G0_0_1_2_0_5 - 0.000243506493506501*G0_0_1_2_1_0 - 0.000572240259740279*G0_0_1_2_1_1 - 0.000572240259740279*G0_0_1_2_1_2 + 0.000194805194805202*G0_0_1_2_1_3 + 0.00180194805194812*G0_0_1_2_1_4 + 0.00180194805194811*G0_0_1_2_1_5 - 0.000730519480519504*G0_0_1_2_2_0 - 0.000572240259740279*G0_0_1_2_2_1 + 0.00178977272727281*G0_0_1_2_2_2 + 0.00185064935064941*G0_0_1_2_2_3 + 0.00228896103896112*G0_0_1_2_2_4 + 0.00180194805194811*G0_0_1_2_2_5 - 0.000243506493506503*G0_0_1_2_3_0 + 0.000194805194805202*G0_0_1_2_3_1 + 0.00185064935064941*G0_0_1_2_3_2 - 0.000389610389610427*G0_0_1_2_3_3 - 0.00311688311688322*G0_0_1_2_3_4 - 0.00311688311688323*G0_0_1_2_3_5 + 0.00243506493506501*G0_0_1_2_4_0 + 0.00180194805194812*G0_0_1_2_4_1 + 0.00228896103896112*G0_0_1_2_4_2 - 0.00311688311688322*G0_0_1_2_4_3 - 0.0122727272727277*G0_0_1_2_4_4 - 0.00720779220779246*G0_0_1_2_4_5 + 0.000974025974026002*G0_0_1_2_5_0 + 0.00180194805194811*G0_0_1_2_5_1 + 0.00180194805194812*G0_0_1_2_5_2 - 0.00311688311688323*G0_0_1_2_5_3 - 0.00720779220779246*G0_0_1_2_5_4 - 0.0103246753246757*G0_0_1_2_5_5 - 0.00146103896103898*G0_0_1_3_0_0 - 0.000243506493506505*G0_0_1_3_0_1 - 0.000243506493506503*G0_0_1_3_0_2 + 0.000974025974026015*G0_0_1_3_0_4 + 0.000974025974026019*G0_0_1_3_0_5 - 0.000243506493506505*G0_0_1_3_1_0 + 0.00185064935064941*G0_0_1_3_1_1 + 0.000194805194805203*G0_0_1_3_1_2 - 0.000389610389610383*G0_0_1_3_1_3 - 0.00311688311688322*G0_0_1_3_1_4 - 0.00311688311688322*G0_0_1_3_1_5 - 0.000243506493506503*G0_0_1_3_2_0 + 0.000194805194805202*G0_0_1_3_2_1 + 0.00185064935064941*G0_0_1_3_2_2 - 0.000389610389610423*G0_0_1_3_2_3 - 0.00311688311688322*G0_0_1_3_2_4 - 0.00311688311688323*G0_0_1_3_2_5 - 0.000389610389610384*G0_0_1_3_3_1 - 0.000389610389610426*G0_0_1_3_3_2 + 0.0140259740259746*G0_0_1_3_3_3 + 0.00623376623376645*G0_0_1_3_3_4 + 0.00623376623376646*G0_0_1_3_3_5 + 0.000974025974026015*G0_0_1_3_4_0 - 0.00311688311688322*G0_0_1_3_4_1 - 0.00311688311688322*G0_0_1_3_4_2 + 0.00623376623376645*G0_0_1_3_4_3 + 0.0187012987012993*G0_0_1_3_4_4 + 0.0124675324675329*G0_0_1_3_4_5 + 0.000974025974026019*G0_0_1_3_5_0 - 0.00311688311688322*G0_0_1_3_5_1 - 0.00311688311688323*G0_0_1_3_5_2 + 0.00623376623376646*G0_0_1_3_5_3 + 0.0124675324675329*G0_0_1_3_5_4 + 0.0187012987012994*G0_0_1_3_5_5 - 0.0409090909090922*G0_0_1_4_0_0 + 0.000974025974025999*G0_0_1_4_0_1 + 0.00243506493506501*G0_0_1_4_0_2 + 0.000974025974026015*G0_0_1_4_0_3 - 0.00779220779220801*G0_0_1_4_0_4 - 0.00389610389610401*G0_0_1_4_0_5 + 0.000974025974025999*G0_0_1_4_1_0 + 0.00180194805194811*G0_0_1_4_1_1 + 0.00180194805194811*G0_0_1_4_1_2 - 0.00311688311688322*G0_0_1_4_1_3 - 0.0103246753246757*G0_0_1_4_1_4 - 0.00720779220779246*G0_0_1_4_1_5 + 0.00243506493506501*G0_0_1_4_2_0 + 0.00180194805194812*G0_0_1_4_2_1 + 0.00228896103896112*G0_0_1_4_2_2 - 0.00311688311688322*G0_0_1_4_2_3 - 0.0122727272727277*G0_0_1_4_2_4 - 0.00720779220779246*G0_0_1_4_2_5 + 0.000974025974026015*G0_0_1_4_3_0 - 0.00311688311688322*G0_0_1_4_3_1 - 0.00311688311688322*G0_0_1_4_3_2 + 0.00623376623376645*G0_0_1_4_3_3 + 0.0187012987012993*G0_0_1_4_3_4 + 0.0124675324675329*G0_0_1_4_3_5 - 0.00779220779220801*G0_0_1_4_4_0 - 0.0103246753246757*G0_0_1_4_4_1 - 0.0122727272727277*G0_0_1_4_4_2 + 0.0187012987012993*G0_0_1_4_4_3 + 0.105194805194809*G0_0_1_4_4_4 + 0.0350649350649363*G0_0_1_4_4_5 - 0.00389610389610401*G0_0_1_4_5_0 - 0.00720779220779246*G0_0_1_4_5_1 - 0.00720779220779246*G0_0_1_4_5_2 + 0.0124675324675329*G0_0_1_4_5_3 + 0.0350649350649363*G0_0_1_4_5_4 + 0.0350649350649363*G0_0_1_4_5_5 - 0.0409090909090923*G0_0_1_5_0_0 + 0.00243506493506501*G0_0_1_5_0_1 + 0.000974025974026002*G0_0_1_5_0_2 + 0.000974025974026018*G0_0_1_5_0_3 - 0.00389610389610401*G0_0_1_5_0_4 - 0.007792207792208*G0_0_1_5_0_5 + 0.00243506493506501*G0_0_1_5_1_0 + 0.00228896103896112*G0_0_1_5_1_1 + 0.00180194805194811*G0_0_1_5_1_2 - 0.00311688311688322*G0_0_1_5_1_3 - 0.00720779220779246*G0_0_1_5_1_4 - 0.0122727272727277*G0_0_1_5_1_5 + 0.000974025974026002*G0_0_1_5_2_0 + 0.00180194805194811*G0_0_1_5_2_1 + 0.00180194805194812*G0_0_1_5_2_2 - 0.00311688311688323*G0_0_1_5_2_3 - 0.00720779220779246*G0_0_1_5_2_4 - 0.0103246753246757*G0_0_1_5_2_5 + 0.000974025974026019*G0_0_1_5_3_0 - 0.00311688311688322*G0_0_1_5_3_1 - 0.00311688311688323*G0_0_1_5_3_2 + 0.00623376623376646*G0_0_1_5_3_3 + 0.0124675324675329*G0_0_1_5_3_4 + 0.0187012987012994*G0_0_1_5_3_5 - 0.00389610389610401*G0_0_1_5_4_0 - 0.00720779220779246*G0_0_1_5_4_1 - 0.00720779220779246*G0_0_1_5_4_2 + 0.0124675324675329*G0_0_1_5_4_3 + 0.0350649350649363*G0_0_1_5_4_4 + 0.0350649350649363*G0_0_1_5_4_5 - 0.007792207792208*G0_0_1_5_5_0 - 0.0122727272727277*G0_0_1_5_5_1 - 0.0103246753246757*G0_0_1_5_5_2 + 0.0187012987012994*G0_0_1_5_5_3 + 0.0350649350649363*G0_0_1_5_5_4 + 0.105194805194809*G0_0_1_5_5_5 + 0.201623376623383*G0_1_0_0_0_0 - 0.0098620129870133*G0_1_0_0_0_1 - 0.00986201298701332*G0_1_0_0_0_2 + 0.00146103896103898*G0_1_0_0_0_3 + 0.0409090909090922*G0_1_0_0_0_4 + 0.0409090909090923*G0_1_0_0_0_5 - 0.0098620129870133*G0_1_0_0_1_0 + 0.000730519480519502*G0_1_0_0_1_1 + 0.000243506493506501*G0_1_0_0_1_2 + 0.000243506493506505*G0_1_0_0_1_3 - 0.000974025974026*G0_1_0_0_1_4 - 0.00243506493506501*G0_1_0_0_1_5 - 0.00986201298701332*G0_1_0_0_2_0 + 0.000243506493506501*G0_1_0_0_2_1 + 0.000730519480519504*G0_1_0_0_2_2 + 0.000243506493506503*G0_1_0_0_2_3 - 0.00243506493506501*G0_1_0_0_2_4 - 0.000974025974026003*G0_1_0_0_2_5 + 0.00146103896103898*G0_1_0_0_3_0 + 0.000243506493506505*G0_1_0_0_3_1 + 0.000243506493506503*G0_1_0_0_3_2 - 0.000974025974026015*G0_1_0_0_3_4 - 0.000974025974026019*G0_1_0_0_3_5 + 0.0409090909090922*G0_1_0_0_4_0 - 0.000974025974026*G0_1_0_0_4_1 - 0.00243506493506501*G0_1_0_0_4_2 - 0.000974025974026015*G0_1_0_0_4_3 + 0.00779220779220801*G0_1_0_0_4_4 + 0.00389610389610401*G0_1_0_0_4_5 + 0.0409090909090923*G0_1_0_0_5_0 - 0.00243506493506501*G0_1_0_0_5_1 - 0.000974025974026002*G0_1_0_0_5_2 - 0.000974025974026019*G0_1_0_0_5_3 + 0.00389610389610401*G0_1_0_0_5_4 + 0.007792207792208*G0_1_0_0_5_5 - 0.0098620129870133*G0_1_0_1_0_0 + 0.000730519480519502*G0_1_0_1_0_1 + 0.000243506493506501*G0_1_0_1_0_2 + 0.000243506493506505*G0_1_0_1_0_3 - 0.000974025974026*G0_1_0_1_0_4 - 0.00243506493506501*G0_1_0_1_0_5 + 0.000730519480519502*G0_1_0_1_1_0 - 0.00178977272727275*G0_1_0_1_1_1 + 0.000572240259740279*G0_1_0_1_1_2 - 0.00185064935064941*G0_1_0_1_1_3 - 0.00180194805194811*G0_1_0_1_1_4 - 0.00228896103896112*G0_1_0_1_1_5 + 0.000243506493506501*G0_1_0_1_2_0 + 0.000572240259740279*G0_1_0_1_2_1 + 0.000572240259740279*G0_1_0_1_2_2 - 0.000194805194805202*G0_1_0_1_2_3 - 0.00180194805194812*G0_1_0_1_2_4 - 0.00180194805194811*G0_1_0_1_2_5 + 0.000243506493506505*G0_1_0_1_3_0 - 0.00185064935064941*G0_1_0_1_3_1 - 0.000194805194805203*G0_1_0_1_3_2 + 0.000389610389610383*G0_1_0_1_3_3 + 0.00311688311688322*G0_1_0_1_3_4 + 0.00311688311688322*G0_1_0_1_3_5 - 0.000974025974026*G0_1_0_1_4_0 - 0.00180194805194811*G0_1_0_1_4_1 - 0.00180194805194811*G0_1_0_1_4_2 + 0.00311688311688322*G0_1_0_1_4_3 + 0.0103246753246757*G0_1_0_1_4_4 + 0.00720779220779246*G0_1_0_1_4_5 - 0.00243506493506501*G0_1_0_1_5_0 - 0.00228896103896112*G0_1_0_1_5_1 - 0.00180194805194811*G0_1_0_1_5_2 + 0.00311688311688322*G0_1_0_1_5_3 + 0.00720779220779246*G0_1_0_1_5_4 + 0.0122727272727277*G0_1_0_1_5_5 - 0.00986201298701332*G0_1_0_2_0_0 + 0.000243506493506501*G0_1_0_2_0_1 + 0.000730519480519504*G0_1_0_2_0_2 + 0.000243506493506503*G0_1_0_2_0_3 - 0.00243506493506501*G0_1_0_2_0_4 - 0.000974025974026003*G0_1_0_2_0_5 + 0.000243506493506501*G0_1_0_2_1_0 + 0.000572240259740279*G0_1_0_2_1_1 + 0.000572240259740278*G0_1_0_2_1_2 - 0.000194805194805202*G0_1_0_2_1_3 - 0.00180194805194811*G0_1_0_2_1_4 - 0.00180194805194811*G0_1_0_2_1_5 + 0.000730519480519504*G0_1_0_2_2_0 + 0.000572240259740278*G0_1_0_2_2_1 - 0.00178977272727281*G0_1_0_2_2_2 - 0.00185064935064941*G0_1_0_2_2_3 - 0.00228896103896112*G0_1_0_2_2_4 - 0.00180194805194811*G0_1_0_2_2_5 + 0.000243506493506503*G0_1_0_2_3_0 - 0.000194805194805203*G0_1_0_2_3_1 - 0.00185064935064941*G0_1_0_2_3_2 + 0.000389610389610427*G0_1_0_2_3_3 + 0.00311688311688322*G0_1_0_2_3_4 + 0.00311688311688323*G0_1_0_2_3_5 - 0.00243506493506501*G0_1_0_2_4_0 - 0.00180194805194811*G0_1_0_2_4_1 - 0.00228896103896112*G0_1_0_2_4_2 + 0.00311688311688322*G0_1_0_2_4_3 + 0.0122727272727277*G0_1_0_2_4_4 + 0.00720779220779246*G0_1_0_2_4_5 - 0.000974025974026003*G0_1_0_2_5_0 - 0.00180194805194811*G0_1_0_2_5_1 - 0.00180194805194811*G0_1_0_2_5_2 + 0.00311688311688323*G0_1_0_2_5_3 + 0.00720779220779246*G0_1_0_2_5_4 + 0.0103246753246757*G0_1_0_2_5_5 + 0.00146103896103898*G0_1_0_3_0_0 + 0.000243506493506505*G0_1_0_3_0_1 + 0.000243506493506503*G0_1_0_3_0_2 - 0.000974025974026015*G0_1_0_3_0_4 - 0.000974025974026019*G0_1_0_3_0_5 + 0.000243506493506505*G0_1_0_3_1_0 - 0.00185064935064941*G0_1_0_3_1_1 - 0.000194805194805202*G0_1_0_3_1_2 + 0.000389610389610383*G0_1_0_3_1_3 + 0.00311688311688322*G0_1_0_3_1_4 + 0.00311688311688322*G0_1_0_3_1_5 + 0.000243506493506503*G0_1_0_3_2_0 - 0.000194805194805202*G0_1_0_3_2_1 - 0.00185064935064941*G0_1_0_3_2_2 + 0.000389610389610425*G0_1_0_3_2_3 + 0.00311688311688322*G0_1_0_3_2_4 + 0.00311688311688323*G0_1_0_3_2_5 + 0.000389610389610384*G0_1_0_3_3_1 + 0.000389610389610426*G0_1_0_3_3_2 - 0.0140259740259745*G0_1_0_3_3_3 - 0.00623376623376645*G0_1_0_3_3_4 - 0.00623376623376646*G0_1_0_3_3_5 - 0.000974025974026015*G0_1_0_3_4_0 + 0.00311688311688322*G0_1_0_3_4_1 + 0.00311688311688322*G0_1_0_3_4_2 - 0.00623376623376645*G0_1_0_3_4_3 - 0.0187012987012993*G0_1_0_3_4_4 - 0.0124675324675329*G0_1_0_3_4_5 - 0.000974025974026019*G0_1_0_3_5_0 + 0.00311688311688322*G0_1_0_3_5_1 + 0.00311688311688323*G0_1_0_3_5_2 - 0.00623376623376646*G0_1_0_3_5_3 - 0.0124675324675329*G0_1_0_3_5_4 - 0.0187012987012994*G0_1_0_3_5_5 + 0.0409090909090922*G0_1_0_4_0_0 - 0.000974025974026*G0_1_0_4_0_1 - 0.00243506493506501*G0_1_0_4_0_2 - 0.000974025974026015*G0_1_0_4_0_3 + 0.00779220779220802*G0_1_0_4_0_4 + 0.00389610389610401*G0_1_0_4_0_5 - 0.000974025974026*G0_1_0_4_1_0 - 0.00180194805194811*G0_1_0_4_1_1 - 0.00180194805194812*G0_1_0_4_1_2 + 0.00311688311688322*G0_1_0_4_1_3 + 0.0103246753246757*G0_1_0_4_1_4 + 0.00720779220779246*G0_1_0_4_1_5 - 0.00243506493506501*G0_1_0_4_2_0 - 0.00180194805194811*G0_1_0_4_2_1 - 0.00228896103896112*G0_1_0_4_2_2 + 0.00311688311688322*G0_1_0_4_2_3 + 0.0122727272727277*G0_1_0_4_2_4 + 0.00720779220779246*G0_1_0_4_2_5 - 0.000974025974026016*G0_1_0_4_3_0 + 0.00311688311688322*G0_1_0_4_3_1 + 0.00311688311688322*G0_1_0_4_3_2 - 0.00623376623376645*G0_1_0_4_3_3 - 0.0187012987012993*G0_1_0_4_3_4 - 0.0124675324675329*G0_1_0_4_3_5 + 0.00779220779220801*G0_1_0_4_4_0 + 0.0103246753246757*G0_1_0_4_4_1 + 0.0122727272727277*G0_1_0_4_4_2 - 0.0187012987012993*G0_1_0_4_4_3 - 0.105194805194809*G0_1_0_4_4_4 - 0.0350649350649363*G0_1_0_4_4_5 + 0.00389610389610401*G0_1_0_4_5_0 + 0.00720779220779246*G0_1_0_4_5_1 + 0.00720779220779246*G0_1_0_4_5_2 - 0.0124675324675329*G0_1_0_4_5_3 - 0.0350649350649363*G0_1_0_4_5_4 - 0.0350649350649363*G0_1_0_4_5_5 + 0.0409090909090923*G0_1_0_5_0_0 - 0.00243506493506501*G0_1_0_5_0_1 - 0.000974025974026002*G0_1_0_5_0_2 - 0.000974025974026019*G0_1_0_5_0_3 + 0.00389610389610401*G0_1_0_5_0_4 + 0.007792207792208*G0_1_0_5_0_5 - 0.00243506493506501*G0_1_0_5_1_0 - 0.00228896103896112*G0_1_0_5_1_1 - 0.00180194805194811*G0_1_0_5_1_2 + 0.00311688311688322*G0_1_0_5_1_3 + 0.00720779220779246*G0_1_0_5_1_4 + 0.0122727272727277*G0_1_0_5_1_5 - 0.000974025974026003*G0_1_0_5_2_0 - 0.00180194805194811*G0_1_0_5_2_1 - 0.00180194805194811*G0_1_0_5_2_2 + 0.00311688311688323*G0_1_0_5_2_3 + 0.00720779220779246*G0_1_0_5_2_4 + 0.0103246753246757*G0_1_0_5_2_5 - 0.000974025974026018*G0_1_0_5_3_0 + 0.00311688311688322*G0_1_0_5_3_1 + 0.00311688311688323*G0_1_0_5_3_2 - 0.00623376623376646*G0_1_0_5_3_3 - 0.0124675324675329*G0_1_0_5_3_4 - 0.0187012987012994*G0_1_0_5_3_5 + 0.00389610389610401*G0_1_0_5_4_0 + 0.00720779220779246*G0_1_0_5_4_1 + 0.00720779220779246*G0_1_0_5_4_2 - 0.0124675324675329*G0_1_0_5_4_3 - 0.0350649350649363*G0_1_0_5_4_4 - 0.0350649350649363*G0_1_0_5_4_5 + 0.007792207792208*G0_1_0_5_5_0 + 0.0122727272727277*G0_1_0_5_5_1 + 0.0103246753246757*G0_1_0_5_5_2 - 0.0187012987012994*G0_1_0_5_5_3 - 0.0350649350649363*G0_1_0_5_5_4 - 0.105194805194809*G0_1_0_5_5_5;
    A[13] = -A[15] - 0.0061120129870132*G0_0_0_0_0_0 + 0.000771103896103921*G0_0_0_0_0_1 + 0.000698051948051973*G0_0_0_0_0_2 - 0.000162337662337665*G0_0_0_0_0_3 - 0.00633116883116904*G0_0_0_0_0_4 - 0.000649350649350674*G0_0_0_0_0_5 + 0.000771103896103921*G0_0_0_0_1_0 - 0.00230519480519488*G0_0_0_0_1_1 + 0.000292207792207803*G0_0_0_0_1_2 - 0.00246753246753255*G0_0_0_0_1_3 - 0.000162337662337665*G0_0_0_0_1_4 - 0.00175324675324681*G0_0_0_0_1_5 + 0.000698051948051973*G0_0_0_0_2_0 + 0.000292207792207803*G0_0_0_0_2_1 + 0.000511363636363653*G0_0_0_0_2_2 + 0.00113636363636367*G0_0_0_0_2_3 + 0.00337662337662349*G0_0_0_0_2_4 + 0.000681818181818205*G0_0_0_0_2_5 - 0.000162337662337665*G0_0_0_0_3_0 - 0.00246753246753255*G0_0_0_0_3_1 + 0.00113636363636367*G0_0_0_0_3_2 - 0.000259740259740283*G0_0_0_0_3_3 + 0.000649350649350666*G0_0_0_0_3_4 - 0.00103896103896108*G0_0_0_0_3_5 - 0.00633116883116904*G0_0_0_0_4_0 - 0.000162337662337665*G0_0_0_0_4_1 + 0.00337662337662349*G0_0_0_0_4_2 + 0.000649350649350666*G0_0_0_0_4_3 - 0.00506493506493525*G0_0_0_0_4_4 - 0.00103896103896108*G0_0_0_0_4_5 - 0.000649350649350674*G0_0_0_0_5_0 - 0.00175324675324681*G0_0_0_0_5_1 + 0.000681818181818205*G0_0_0_0_5_2 - 0.00103896103896108*G0_0_0_0_5_3 - 0.00103896103896108*G0_0_0_0_5_4 - 0.00155844155844161*G0_0_0_0_5_5 + 0.000771103896103921*G0_0_0_1_0_0 - 0.00230519480519488*G0_0_0_1_0_1 + 0.000292207792207803*G0_0_0_1_0_2 - 0.00246753246753255*G0_0_0_1_0_3 - 0.000162337662337666*G0_0_0_1_0_4 - 0.00175324675324681*G0_0_0_1_0_5 - 0.00230519480519488*G0_0_0_1_1_0 + 0.0304383116883127*G0_0_0_1_1_1 - 0.0044967532467534*G0_0_0_1_1_2 + 0.0194805194805202*G0_0_0_1_1_3 + 0.00103896103896107*G0_0_0_1_1_4 + 0.00941558441558475*G0_0_0_1_1_5 + 0.000292207792207803*G0_0_0_1_2_0 - 0.0044967532467534*G0_0_0_1_2_1 + 0.00138798701298706*G0_0_0_1_2_2 - 0.0039610389610391*G0_0_0_1_2_3 - 0.00155844155844162*G0_0_0_1_2_5 - 0.00246753246753255*G0_0_0_1_3_0 + 0.0194805194805202*G0_0_0_1_3_1 - 0.0039610389610391*G0_0_0_1_3_2 + 0.0296103896103907*G0_0_0_1_3_3 + 0.00285714285714295*G0_0_0_1_3_4 + 0.00805194805194835*G0_0_0_1_3_5 - 0.000162337662337665*G0_0_0_1_4_0 + 0.00103896103896107*G0_0_0_1_4_1 + 0.00285714285714295*G0_0_0_1_4_3 + 0.00376623376623388*G0_0_0_1_4_4 + 0.00103896103896107*G0_0_0_1_4_5 - 0.00175324675324681*G0_0_0_1_5_0 + 0.00941558441558475*G0_0_0_1_5_1 - 0.00155844155844162*G0_0_0_1_5_2 + 0.00805194805194835*G0_0_0_1_5_3 + 0.00103896103896107*G0_0_0_1_5_4 + 0.00623376623376645*G0_0_0_1_5_5 + 0.000698051948051973*G0_0_0_2_0_0 + 0.000292207792207803*G0_0_0_2_0_1 + 0.000511363636363653*G0_0_0_2_0_2 + 0.00113636363636367*G0_0_0_2_0_3 + 0.00337662337662349*G0_0_0_2_0_4 + 0.000681818181818205*G0_0_0_2_0_5 + 0.000292207792207803*G0_0_0_2_1_0 - 0.0044967532467534*G0_0_0_2_1_1 + 0.00138798701298706*G0_0_0_2_1_2 - 0.00396103896103911*G0_0_0_2_1_3 - 0.00155844155844162*G0_0_0_2_1_5 + 0.000511363636363653*G0_0_0_2_2_0 + 0.00138798701298706*G0_0_0_2_2_1 - 0.00438311688311702*G0_0_0_2_2_2 - 0.000454545454545464*G0_0_0_2_2_3 - 0.00538961038961057*G0_0_0_2_2_4 + 0.000292207792207803*G0_0_0_2_2_5 + 0.00113636363636367*G0_0_0_2_3_0 - 0.00396103896103911*G0_0_0_2_3_1 - 0.000454545454545464*G0_0_0_2_3_2 - 0.0140259740259745*G0_0_0_2_3_3 - 0.00233766233766242*G0_0_0_2_3_4 - 0.00285714285714296*G0_0_0_2_3_5 + 0.00337662337662349*G0_0_0_2_4_0 - 0.00538961038961057*G0_0_0_2_4_2 - 0.00233766233766242*G0_0_0_2_4_3 - 0.00467532467532484*G0_0_0_2_4_4 - 0.000649350649350675*G0_0_0_2_4_5 + 0.000681818181818205*G0_0_0_2_5_0 - 0.00155844155844162*G0_0_0_2_5_1 + 0.000292207792207803*G0_0_0_2_5_2 - 0.00285714285714296*G0_0_0_2_5_3 - 0.000649350649350675*G0_0_0_2_5_4 - 0.00233766233766242*G0_0_0_2_5_5 - 0.000162337662337665*G0_0_0_3_0_0 - 0.00246753246753255*G0_0_0_3_0_1 + 0.00113636363636367*G0_0_0_3_0_2 - 0.000259740259740283*G0_0_0_3_0_3 + 0.000649350649350666*G0_0_0_3_0_4 - 0.00103896103896108*G0_0_0_3_0_5 - 0.00246753246753255*G0_0_0_3_1_0 + 0.0194805194805202*G0_0_0_3_1_1 - 0.00396103896103911*G0_0_0_3_1_2 + 0.0296103896103907*G0_0_0_3_1_3 + 0.00285714285714295*G0_0_0_3_1_4 + 0.00805194805194835*G0_0_0_3_1_5 + 0.00113636363636367*G0_0_0_3_2_0 - 0.00396103896103911*G0_0_0_3_2_1 - 0.000454545454545464*G0_0_0_3_2_2 - 0.0140259740259745*G0_0_0_3_2_3 - 0.00233766233766242*G0_0_0_3_2_4 - 0.00285714285714296*G0_0_0_3_2_5 - 0.000259740259740283*G0_0_0_3_3_0 + 0.0296103896103907*G0_0_0_3_3_1 - 0.0140259740259745*G0_0_0_3_3_2 + 0.00935064935064981*G0_0_0_3_3_3 - 0.00519480519480534*G0_0_0_3_3_4 + 0.00623376623376649*G0_0_0_3_3_5 + 0.000649350649350667*G0_0_0_3_4_0 + 0.00285714285714295*G0_0_0_3_4_1 - 0.00233766233766242*G0_0_0_3_4_2 - 0.00519480519480534*G0_0_0_3_4_3 - 0.0088311688311691*G0_0_0_3_4_4 - 0.00103896103896108*G0_0_0_3_5_0 + 0.00805194805194835*G0_0_0_3_5_1 - 0.00285714285714296*G0_0_0_3_5_2 + 0.00623376623376649*G0_0_0_3_5_3 + 0.006753246753247*G0_0_0_3_5_5 - 0.00633116883116904*G0_0_0_4_0_0 - 0.000162337662337666*G0_0_0_4_0_1 + 0.00337662337662349*G0_0_0_4_0_2 + 0.000649350649350667*G0_0_0_4_0_3 - 0.00506493506493525*G0_0_0_4_0_4 - 0.00103896103896108*G0_0_0_4_0_5 - 0.000162337662337665*G0_0_0_4_1_0 + 0.00103896103896107*G0_0_0_4_1_1 + 0.00285714285714295*G0_0_0_4_1_3 + 0.00376623376623388*G0_0_0_4_1_4 + 0.00103896103896107*G0_0_0_4_1_5 + 0.00337662337662349*G0_0_0_4_2_0 - 0.00538961038961057*G0_0_0_4_2_2 - 0.00233766233766242*G0_0_0_4_2_3 - 0.00467532467532484*G0_0_0_4_2_4 - 0.000649350649350674*G0_0_0_4_2_5 + 0.000649350649350667*G0_0_0_4_3_0 + 0.00285714285714295*G0_0_0_4_3_1 - 0.00233766233766242*G0_0_0_4_3_2 - 0.00519480519480534*G0_0_0_4_3_3 - 0.0088311688311691*G0_0_0_4_3_4 - 0.00506493506493525*G0_0_0_4_4_0 + 0.00376623376623388*G0_0_0_4_4_1 - 0.00467532467532484*G0_0_0_4_4_2 - 0.0088311688311691*G0_0_0_4_4_3 - 0.107532467532471*G0_0_0_4_4_4 - 0.00623376623376643*G0_0_0_4_4_5 - 0.00103896103896107*G0_0_0_4_5_0 + 0.00103896103896107*G0_0_0_4_5_1 - 0.000649350649350675*G0_0_0_4_5_2 - 0.00623376623376643*G0_0_0_4_5_4 + 0.00259740259740269*G0_0_0_4_5_5 - 0.000649350649350674*G0_0_0_5_0_0 - 0.00175324675324681*G0_0_0_5_0_1 + 0.000681818181818205*G0_0_0_5_0_2 - 0.00103896103896108*G0_0_0_5_0_3 - 0.00103896103896107*G0_0_0_5_0_4 - 0.00155844155844161*G0_0_0_5_0_5 - 0.00175324675324681*G0_0_0_5_1_0 + 0.00941558441558475*G0_0_0_5_1_1 - 0.00155844155844162*G0_0_0_5_1_2 + 0.00805194805194835*G0_0_0_5_1_3 + 0.00103896103896107*G0_0_0_5_1_4 + 0.00623376623376645*G0_0_0_5_1_5 + 0.000681818181818205*G0_0_0_5_2_0 - 0.00155844155844162*G0_0_0_5_2_1 + 0.000292207792207803*G0_0_0_5_2_2 - 0.00285714285714296*G0_0_0_5_2_3 - 0.000649350649350675*G0_0_0_5_2_4 - 0.00233766233766242*G0_0_0_5_2_5 - 0.00103896103896108*G0_0_0_5_3_0 + 0.00805194805194835*G0_0_0_5_3_1 - 0.00285714285714296*G0_0_0_5_3_2 + 0.00623376623376649*G0_0_0_5_3_3 + 0.00675324675324701*G0_0_0_5_3_5 - 0.00103896103896108*G0_0_0_5_4_0 + 0.00103896103896107*G0_0_0_5_4_1 - 0.000649350649350675*G0_0_0_5_4_2 - 0.00623376623376643*G0_0_0_5_4_4 + 0.00259740259740269*G0_0_0_5_4_5 - 0.00155844155844161*G0_0_0_5_5_0 + 0.00623376623376645*G0_0_0_5_5_1 - 0.00233766233766242*G0_0_0_5_5_2 + 0.00675324675324701*G0_0_0_5_5_3 + 0.00259740259740269*G0_0_0_5_5_4 + 0.0140259740259745*G0_0_0_5_5_5 + 0.01935064935065*G0_0_1_0_0_0 + 0.000919913419913453*G0_0_1_0_0_1 - 0.00145292207792212*G0_0_1_0_0_2 + 0.00107683982683986*G0_0_1_0_0_3 + 0.00486471861471877*G0_0_1_0_0_4 + 0.00390151515151528*G0_0_1_0_0_5 + 0.000919913419913453*G0_0_1_0_1_0 - 0.0111011904761909*G0_0_1_0_1_1 + 0.00101596320346324*G0_0_1_0_1_2 - 0.00414502164502179*G0_0_1_0_1_3 - 0.000557359307359325*G0_0_1_0_1_4 - 0.00662337662337685*G0_0_1_0_1_5 - 0.00145292207792212*G0_0_1_0_2_0 + 0.00101596320346324*G0_0_1_0_2_1 - 0.000238095238095249*G0_0_1_0_2_2 + 0.0011580086580087*G0_0_1_0_2_3 + 0.0003896103896104*G0_0_1_0_2_4 + 0.00095779220779224*G0_0_1_0_2_5 + 0.00107683982683986*G0_0_1_0_3_0 - 0.00414502164502179*G0_0_1_0_3_1 + 0.0011580086580087*G0_0_1_0_3_2 - 0.00458874458874474*G0_0_1_0_3_3 - 0.00103896103896107*G0_0_1_0_3_4 - 0.00406926406926421*G0_0_1_0_3_5 + 0.00486471861471877*G0_0_1_0_4_0 - 0.000557359307359325*G0_0_1_0_4_1 + 0.0003896103896104*G0_0_1_0_4_2 - 0.00103896103896107*G0_0_1_0_4_3 + 0.00285714285714294*G0_0_1_0_4_4 - 0.000800865800865825*G0_0_1_0_4_5 + 0.00390151515151528*G0_0_1_0_5_0 - 0.00662337662337685*G0_0_1_0_5_1 + 0.00095779220779224*G0_0_1_0_5_2 - 0.00406926406926421*G0_0_1_0_5_3 - 0.000800865800865824*G0_0_1_0_5_4 - 0.0108658008658012*G0_0_1_0_5_5 + 0.000919913419913452*G0_0_1_1_0_0 - 0.0111011904761909*G0_0_1_1_0_1 + 0.00101596320346324*G0_0_1_1_0_2 - 0.00414502164502179*G0_0_1_1_0_3 - 0.000557359307359325*G0_0_1_1_0_4 - 0.00662337662337685*G0_0_1_1_0_5 - 0.0111011904761909*G0_0_1_1_1_0 + 0.166233766233772*G0_0_1_1_1_1 - 0.011696428571429*G0_0_1_1_1_2 + 0.0501082251082269*G0_0_1_1_1_3 + 0.00323593073593083*G0_0_1_1_1_4 + 0.0469696969696987*G0_0_1_1_1_5 + 0.00101596320346324*G0_0_1_1_2_0 - 0.011696428571429*G0_0_1_1_2_1 + 0.00153950216450222*G0_0_1_1_2_2 - 0.00746753246753273*G0_0_1_1_2_3 - 0.000270562770562781*G0_0_1_1_2_4 - 0.00405844155844171*G0_0_1_1_2_5 - 0.00414502164502179*G0_0_1_1_3_0 + 0.0501082251082269*G0_0_1_1_3_1 - 0.00746753246753273*G0_0_1_1_3_2 + 0.0379220779220793*G0_0_1_1_3_3 + 0.00181818181818188*G0_0_1_1_3_4 + 0.016406926406927*G0_0_1_1_3_5 - 0.000557359307359325*G0_0_1_1_4_0 + 0.00323593073593083*G0_0_1_1_4_1 - 0.000270562770562781*G0_0_1_1_4_2 + 0.00181818181818188*G0_0_1_1_4_3 + 0.000735930735930758*G0_0_1_1_4_4 + 0.0016450216450217*G0_0_1_1_4_5 - 0.00662337662337685*G0_0_1_1_5_0 + 0.0469696969696987*G0_0_1_1_5_1 - 0.00405844155844171*G0_0_1_1_5_2 + 0.016406926406927*G0_0_1_1_5_3 + 0.0016450216450217*G0_0_1_1_5_4 + 0.0331601731601744*G0_0_1_1_5_5 - 0.00145292207792212*G0_0_1_2_0_0 + 0.00101596320346324*G0_0_1_2_0_1 - 0.000238095238095249*G0_0_1_2_0_2 + 0.0011580086580087*G0_0_1_2_0_3 + 0.0003896103896104*G0_0_1_2_0_4 + 0.00095779220779224*G0_0_1_2_0_5 + 0.00101596320346324*G0_0_1_2_1_0 - 0.011696428571429*G0_0_1_2_1_1 + 0.00153950216450222*G0_0_1_2_1_2 - 0.00746753246753273*G0_0_1_2_1_3 - 0.000270562770562781*G0_0_1_2_1_4 - 0.00405844155844171*G0_0_1_2_1_5 - 0.000238095238095249*G0_0_1_2_2_0 + 0.00153950216450222*G0_0_1_2_2_1 + 0.00676136363636391*G0_0_1_2_2_2 + 0.00246753246753256*G0_0_1_2_2_3 + 0.000292207792207817*G0_0_1_2_2_4 + 0.000963203463203499*G0_0_1_2_2_5 + 0.0011580086580087*G0_0_1_2_3_0 - 0.00746753246753273*G0_0_1_2_3_1 + 0.00246753246753256*G0_0_1_2_3_2 - 0.0126406926406931*G0_0_1_2_3_3 - 0.00177489177489183*G0_0_1_2_3_4 - 0.0042424242424244*G0_0_1_2_3_5 + 0.0003896103896104*G0_0_1_2_4_0 - 0.000270562770562781*G0_0_1_2_4_1 + 0.000292207792207817*G0_0_1_2_4_2 - 0.00177489177489183*G0_0_1_2_4_3 - 0.00367965367965379*G0_0_1_2_4_4 - 0.00138528138528143*G0_0_1_2_4_5 + 0.00095779220779224*G0_0_1_2_5_0 - 0.00405844155844171*G0_0_1_2_5_1 + 0.000963203463203499*G0_0_1_2_5_2 - 0.0042424242424244*G0_0_1_2_5_3 - 0.00138528138528143*G0_0_1_2_5_4 - 0.00419913419913435*G0_0_1_2_5_5 + 0.00107683982683986*G0_0_1_3_0_0 - 0.00414502164502179*G0_0_1_3_0_1 + 0.0011580086580087*G0_0_1_3_0_2 - 0.00458874458874474*G0_0_1_3_0_3 - 0.00103896103896107*G0_0_1_3_0_4 - 0.00406926406926421*G0_0_1_3_0_5 - 0.00414502164502179*G0_0_1_3_1_0 + 0.0501082251082269*G0_0_1_3_1_1 - 0.00746753246753273*G0_0_1_3_1_2 + 0.0379220779220793*G0_0_1_3_1_3 + 0.00181818181818188*G0_0_1_3_1_4 + 0.016406926406927*G0_0_1_3_1_5 + 0.0011580086580087*G0_0_1_3_2_0 - 0.00746753246753273*G0_0_1_3_2_1 + 0.00246753246753256*G0_0_1_3_2_2 - 0.0126406926406931*G0_0_1_3_2_3 - 0.00177489177489183*G0_0_1_3_2_4 - 0.0042424242424244*G0_0_1_3_2_5 - 0.00458874458874474*G0_0_1_3_3_0 + 0.0379220779220793*G0_0_1_3_3_1 - 0.0126406926406931*G0_0_1_3_3_2 + 0.0446753246753263*G0_0_1_3_3_3 + 0.00554112554112573*G0_0_1_3_3_4 + 0.0176623376623383*G0_0_1_3_3_5 - 0.00103896103896107*G0_0_1_3_4_0 + 0.00181818181818188*G0_0_1_3_4_1 - 0.00177489177489183*G0_0_1_3_4_2 + 0.00554112554112573*G0_0_1_3_4_3 + 0.000606060606060627*G0_0_1_3_4_4 + 0.00484848484848501*G0_0_1_3_4_5 - 0.00406926406926421*G0_0_1_3_5_0 + 0.016406926406927*G0_0_1_3_5_1 - 0.0042424242424244*G0_0_1_3_5_2 + 0.0176623376623383*G0_0_1_3_5_3 + 0.00484848484848501*G0_0_1_3_5_4 + 0.0165367965367971*G0_0_1_3_5_5 + 0.00486471861471877*G0_0_1_4_0_0 - 0.000557359307359325*G0_0_1_4_0_1 + 0.0003896103896104*G0_0_1_4_0_2 - 0.00103896103896107*G0_0_1_4_0_3 + 0.00285714285714294*G0_0_1_4_0_4 - 0.000800865800865824*G0_0_1_4_0_5 - 0.000557359307359325*G0_0_1_4_1_0 + 0.00323593073593083*G0_0_1_4_1_1 - 0.000270562770562781*G0_0_1_4_1_2 + 0.00181818181818188*G0_0_1_4_1_3 + 0.000735930735930758*G0_0_1_4_1_4 + 0.0016450216450217*G0_0_1_4_1_5 + 0.0003896103896104*G0_0_1_4_2_0 - 0.000270562770562781*G0_0_1_4_2_1 + 0.000292207792207817*G0_0_1_4_2_2 - 0.00177489177489183*G0_0_1_4_2_3 - 0.00367965367965379*G0_0_1_4_2_4 - 0.00138528138528143*G0_0_1_4_2_5 - 0.00103896103896107*G0_0_1_4_3_0 + 0.00181818181818188*G0_0_1_4_3_1 - 0.00177489177489183*G0_0_1_4_3_2 + 0.00554112554112573*G0_0_1_4_3_3 + 0.000606060606060627*G0_0_1_4_3_4 + 0.00484848484848501*G0_0_1_4_3_5 + 0.00285714285714294*G0_0_1_4_4_0 + 0.000735930735930758*G0_0_1_4_4_1 - 0.00367965367965379*G0_0_1_4_4_2 + 0.000606060606060627*G0_0_1_4_4_3 - 0.0418181818181831*G0_0_1_4_4_4 + 0.00129870129870134*G0_0_1_4_4_5 - 0.000800865800865825*G0_0_1_4_5_0 + 0.0016450216450217*G0_0_1_4_5_1 - 0.00138528138528143*G0_0_1_4_5_2 + 0.00484848484848501*G0_0_1_4_5_3 + 0.00129870129870134*G0_0_1_4_5_4 + 0.00510822510822526*G0_0_1_4_5_5 + 0.00390151515151528*G0_0_1_5_0_0 - 0.00662337662337685*G0_0_1_5_0_1 + 0.00095779220779224*G0_0_1_5_0_2 - 0.00406926406926421*G0_0_1_5_0_3 - 0.000800865800865824*G0_0_1_5_0_4 - 0.0108658008658012*G0_0_1_5_0_5 - 0.00662337662337685*G0_0_1_5_1_0 + 0.0469696969696987*G0_0_1_5_1_1 - 0.00405844155844171*G0_0_1_5_1_2 + 0.016406926406927*G0_0_1_5_1_3 + 0.0016450216450217*G0_0_1_5_1_4 + 0.0331601731601744*G0_0_1_5_1_5 + 0.00095779220779224*G0_0_1_5_2_0 - 0.00405844155844171*G0_0_1_5_2_1 + 0.000963203463203499*G0_0_1_5_2_2 - 0.0042424242424244*G0_0_1_5_2_3 - 0.00138528138528143*G0_0_1_5_2_4 - 0.00419913419913434*G0_0_1_5_2_5 - 0.00406926406926421*G0_0_1_5_3_0 + 0.016406926406927*G0_0_1_5_3_1 - 0.0042424242424244*G0_0_1_5_3_2 + 0.0176623376623383*G0_0_1_5_3_3 + 0.00484848484848501*G0_0_1_5_3_4 + 0.0165367965367971*G0_0_1_5_3_5 - 0.000800865800865825*G0_0_1_5_4_0 + 0.0016450216450217*G0_0_1_5_4_1 - 0.00138528138528143*G0_0_1_5_4_2 + 0.00484848484848501*G0_0_1_5_4_3 + 0.00129870129870134*G0_0_1_5_4_4 + 0.00510822510822526*G0_0_1_5_4_5 - 0.0108658008658012*G0_0_1_5_5_0 + 0.0331601731601744*G0_0_1_5_5_1 - 0.00419913419913434*G0_0_1_5_5_2 + 0.0165367965367971*G0_0_1_5_5_3 + 0.00510822510822526*G0_0_1_5_5_4 + 0.0345454545454557*G0_0_1_5_5_5;
    A[30] = A[4] + 0.000154220779220785*G0_0_0_0_0_1 - 0.000251623376623386*G0_0_0_0_0_2 + 0.000324675324675341*G0_0_0_0_0_4 - 0.000324675324675343*G0_0_0_0_0_5 + 0.000154220779220785*G0_0_0_0_1_0 + 0.000194805194805202*G0_0_0_0_1_1 + 0.000470779220779236*G0_0_0_0_1_3 + 0.00025974025974027*G0_0_0_0_1_5 - 0.000251623376623385*G0_0_0_0_2_0 - 0.00104707792207796*G0_0_0_0_2_2 - 0.000194805194805202*G0_0_0_0_2_3 + 0.000584415584415599*G0_0_0_0_2_4 + 0.000551948051948069*G0_0_0_0_2_5 + 0.000470779220779236*G0_0_0_0_3_1 - 0.000194805194805202*G0_0_0_0_3_2 + 0.000389610389610395*G0_0_0_0_3_3 - 0.00129870129870134*G0_0_0_0_3_5 + 0.000324675324675341*G0_0_0_0_4_0 + 0.000584415584415599*G0_0_0_0_4_2 + 0.00545454545454564*G0_0_0_0_4_4 - 0.000909090909090937*G0_0_0_0_4_5 - 0.000324675324675343*G0_0_0_0_5_0 + 0.00025974025974027*G0_0_0_0_5_1 + 0.000551948051948069*G0_0_0_0_5_2 - 0.00129870129870134*G0_0_0_0_5_3 - 0.000909090909090936*G0_0_0_0_5_4 - 0.00363636363636376*G0_0_0_0_5_5 + 0.000154220779220785*G0_0_0_1_0_0 + 0.000194805194805202*G0_0_0_1_0_1 + 0.000470779220779236*G0_0_0_1_0_3 + 0.00025974025974027*G0_0_0_1_0_5 + 0.000194805194805202*G0_0_0_1_1_0 - 0.00589285714285735*G0_0_0_1_1_1 + 0.00125000000000004*G0_0_0_1_1_2 - 0.00469155844155861*G0_0_0_1_1_3 - 0.000211038961038968*G0_0_0_1_1_4 - 0.000827922077922114*G0_0_0_1_1_5 + 0.00125000000000004*G0_0_0_1_2_1 - 0.00258116883116892*G0_0_0_1_2_2 + 0.000162337662337665*G0_0_0_1_2_3 + 0.000211038961038968*G0_0_0_1_2_5 + 0.000470779220779236*G0_0_0_1_3_0 - 0.00469155844155861*G0_0_0_1_3_1 + 0.000162337662337665*G0_0_0_1_3_2 - 0.0101298701298705*G0_0_0_1_3_3 - 0.000519480519480537*G0_0_0_1_3_4 - 0.00136363636363641*G0_0_0_1_3_5 - 0.000211038961038968*G0_0_0_1_4_1 - 0.000519480519480537*G0_0_0_1_4_3 + 0.00129870129870134*G0_0_0_1_4_4 + 0.00025974025974027*G0_0_0_1_5_0 - 0.000827922077922114*G0_0_0_1_5_1 + 0.000211038961038968*G0_0_0_1_5_2 - 0.00136363636363642*G0_0_0_1_5_3 + 0.000649350649350674*G0_0_0_1_5_5 - 0.000251623376623385*G0_0_0_2_0_0 - 0.00104707792207796*G0_0_0_2_0_2 - 0.000194805194805202*G0_0_0_2_0_3 + 0.000584415584415599*G0_0_0_2_0_4 + 0.000551948051948069*G0_0_0_2_0_5 + 0.00125000000000004*G0_0_0_2_1_1 - 0.00258116883116892*G0_0_0_2_1_2 + 0.000162337662337665*G0_0_0_2_1_3 + 0.000211038961038968*G0_0_0_2_1_5 - 0.00104707792207796*G0_0_0_2_2_0 - 0.00258116883116892*G0_0_0_2_2_1 + 0.0336038961038973*G0_0_0_2_2_2 + 0.00996753246753283*G0_0_0_2_2_3 + 0.00366883116883132*G0_0_0_2_2_4 + 0.00058441558441561*G0_0_0_2_2_5 - 0.000194805194805202*G0_0_0_2_3_0 + 0.000162337662337665*G0_0_0_2_3_1 + 0.00996753246753283*G0_0_0_2_3_2 + 0.00987012987013023*G0_0_0_2_3_3 + 0.000259740259740279*G0_0_0_2_3_4 - 0.0007792207792208*G0_0_0_2_3_5 + 0.000584415584415599*G0_0_0_2_4_0 + 0.00366883116883132*G0_0_0_2_4_2 + 0.000259740259740279*G0_0_0_2_4_3 - 0.0064935064935067*G0_0_0_2_4_4 - 0.00129870129870134*G0_0_0_2_4_5 + 0.000551948051948069*G0_0_0_2_5_0 + 0.000211038961038968*G0_0_0_2_5_1 + 0.00058441558441561*G0_0_0_2_5_2 - 0.000779220779220799*G0_0_0_2_5_3 - 0.00129870129870134*G0_0_0_2_5_4 - 0.00194805194805201*G0_0_0_2_5_5 + 0.000470779220779236*G0_0_0_3_0_1 - 0.000194805194805202*G0_0_0_3_0_2 + 0.000389610389610395*G0_0_0_3_0_3 - 0.00129870129870134*G0_0_0_3_0_5 + 0.000470779220779236*G0_0_0_3_1_0 - 0.00469155844155861*G0_0_0_3_1_1 + 0.000162337662337665*G0_0_0_3_1_2 - 0.0101298701298705*G0_0_0_3_1_3 - 0.000519480519480537*G0_0_0_3_1_4 - 0.00136363636363641*G0_0_0_3_1_5 - 0.000194805194805202*G0_0_0_3_2_0 + 0.000162337662337665*G0_0_0_3_2_1 + 0.00996753246753283*G0_0_0_3_2_2 + 0.00987012987013023*G0_0_0_3_2_3 + 0.000259740259740279*G0_0_0_3_2_4 - 0.000779220779220799*G0_0_0_3_2_5 + 0.000389610389610395*G0_0_0_3_3_0 - 0.0101298701298705*G0_0_0_3_3_1 + 0.00987012987013023*G0_0_0_3_3_2 - 0.039740259740261*G0_0_0_3_3_3 + 0.000259740259740273*G0_0_0_3_3_4 + 0.000779220779220794*G0_0_0_3_3_5 - 0.000519480519480537*G0_0_0_3_4_1 + 0.000259740259740279*G0_0_0_3_4_2 + 0.000259740259740272*G0_0_0_3_4_3 - 0.00259740259740268*G0_0_0_3_4_4 + 0.00259740259740268*G0_0_0_3_4_5 - 0.00129870129870134*G0_0_0_3_5_0 - 0.00136363636363641*G0_0_0_3_5_1 - 0.000779220779220799*G0_0_0_3_5_2 + 0.000779220779220793*G0_0_0_3_5_3 + 0.00259740259740268*G0_0_0_3_5_4 + 0.0064935064935067*G0_0_0_3_5_5 + 0.000324675324675341*G0_0_0_4_0_0 + 0.000584415584415599*G0_0_0_4_0_2 + 0.00545454545454564*G0_0_0_4_0_4 - 0.000909090909090936*G0_0_0_4_0_5 - 0.000211038961038968*G0_0_0_4_1_1 - 0.000519480519480537*G0_0_0_4_1_3 + 0.00129870129870134*G0_0_0_4_1_4 + 0.000584415584415599*G0_0_0_4_2_0 + 0.00366883116883132*G0_0_0_4_2_2 + 0.000259740259740279*G0_0_0_4_2_3 - 0.0064935064935067*G0_0_0_4_2_4 - 0.00129870129870134*G0_0_0_4_2_5 - 0.000519480519480537*G0_0_0_4_3_1 + 0.000259740259740279*G0_0_0_4_3_2 + 0.000259740259740272*G0_0_0_4_3_3 - 0.00259740259740269*G0_0_0_4_3_4 + 0.00259740259740268*G0_0_0_4_3_5 + 0.00545454545454564*G0_0_0_4_4_0 + 0.00129870129870134*G0_0_0_4_4_1 - 0.0064935064935067*G0_0_0_4_4_2 - 0.00259740259740268*G0_0_0_4_4_3 - 0.0233766233766241*G0_0_0_4_4_4 - 0.000909090909090937*G0_0_0_4_5_0 - 0.00129870129870134*G0_0_0_4_5_2 + 0.00259740259740268*G0_0_0_4_5_3 + 0.00389610389610402*G0_0_0_4_5_5 - 0.000324675324675343*G0_0_0_5_0_0 + 0.00025974025974027*G0_0_0_5_0_1 + 0.000551948051948069*G0_0_0_5_0_2 - 0.00129870129870134*G0_0_0_5_0_3 - 0.000909090909090937*G0_0_0_5_0_4 - 0.00363636363636376*G0_0_0_5_0_5 + 0.00025974025974027*G0_0_0_5_1_0 - 0.000827922077922114*G0_0_0_5_1_1 + 0.000211038961038969*G0_0_0_5_1_2 - 0.00136363636363641*G0_0_0_5_1_3 + 0.000649350649350674*G0_0_0_5_1_5 + 0.000551948051948069*G0_0_0_5_2_0 + 0.000211038961038968*G0_0_0_5_2_1 + 0.00058441558441561*G0_0_0_5_2_2 - 0.000779220779220799*G0_0_0_5_2_3 - 0.00129870129870134*G0_0_0_5_2_4 - 0.00194805194805201*G0_0_0_5_2_5 - 0.00129870129870134*G0_0_0_5_3_0 - 0.00136363636363641*G0_0_0_5_3_1 - 0.000779220779220799*G0_0_0_5_3_2 + 0.000779220779220793*G0_0_0_5_3_3 + 0.00259740259740268*G0_0_0_5_3_4 + 0.0064935064935067*G0_0_0_5_3_5 - 0.000909090909090936*G0_0_0_5_4_0 - 0.00129870129870134*G0_0_0_5_4_2 + 0.00259740259740268*G0_0_0_5_4_3 + 0.00389610389610402*G0_0_0_5_4_5 - 0.00363636363636376*G0_0_0_5_5_0 + 0.000649350649350674*G0_0_0_5_5_1 - 0.00194805194805201*G0_0_0_5_5_2 + 0.0064935064935067*G0_0_0_5_5_3 + 0.00389610389610402*G0_0_0_5_5_4 + 0.0116883116883121*G0_0_0_5_5_5 + 0.000500541125541146*G0_0_1_0_0_1 - 0.00050054112554114*G0_0_1_0_0_2 + 0.00189393939393945*G0_0_1_0_0_4 - 0.00189393939393948*G0_0_1_0_0_5 + 0.000500541125541146*G0_0_1_0_1_0 + 0.000311147186147197*G0_0_1_0_1_1 + 0.000189393939393946*G0_0_1_0_1_3 - 0.000367965367965379*G0_0_1_0_1_4 + 0.000259740259740275*G0_0_1_0_1_5 - 0.00050054112554114*G0_0_1_0_2_0 - 0.000311147186147198*G0_0_1_0_2_2 - 0.000189393939393946*G0_0_1_0_2_3 - 0.000259740259740269*G0_0_1_0_2_4 + 0.000367965367965381*G0_0_1_0_2_5 + 0.000189393939393946*G0_0_1_0_3_1 - 0.000189393939393946*G0_0_1_0_3_2 + 0.000735930735930759*G0_0_1_0_3_4 - 0.000735930735930759*G0_0_1_0_3_5 + 0.00189393939393945*G0_0_1_0_4_0 - 0.000367965367965379*G0_0_1_0_4_1 - 0.000259740259740269*G0_0_1_0_4_2 + 0.000735930735930759*G0_0_1_0_4_3 + 0.00692640692640715*G0_0_1_0_4_4 - 0.00189393939393948*G0_0_1_0_5_0 + 0.000259740259740275*G0_0_1_0_5_1 + 0.000367965367965381*G0_0_1_0_5_2 - 0.00073593073593076*G0_0_1_0_5_3 - 0.00692640692640718*G0_0_1_0_5_5 + 0.000500541125541146*G0_0_1_1_0_0 + 0.000311147186147197*G0_0_1_1_0_1 + 0.000189393939393946*G0_0_1_1_0_3 - 0.000367965367965379*G0_0_1_1_0_4 + 0.000259740259740275*G0_0_1_1_0_5 + 0.000311147186147197*G0_0_1_1_1_0 - 0.0134537337662342*G0_0_1_1_1_1 + 0.00130817099567104*G0_0_1_1_1_2 - 0.00504329004329022*G0_0_1_1_1_3 - 0.000340909090909102*G0_0_1_1_1_4 - 0.00153138528138535*G0_0_1_1_1_5 + 0.00130817099567104*G0_0_1_1_2_1 - 0.00130817099567104*G0_0_1_1_2_2 + 0.000189393939393946*G0_0_1_1_3_0 - 0.00504329004329022*G0_0_1_1_3_1 - 0.00673160173160197*G0_0_1_1_3_3 + 0.000303030303030312*G0_0_1_1_3_4 - 0.000324675324675342*G0_0_1_1_3_5 - 0.000367965367965379*G0_0_1_1_4_0 - 0.000340909090909102*G0_0_1_1_4_1 + 0.000303030303030312*G0_0_1_1_4_3 + 0.00142857142857147*G0_0_1_1_4_4 + 0.000735930735930761*G0_0_1_1_4_5 + 0.000259740259740275*G0_0_1_1_5_0 - 0.00153138528138535*G0_0_1_1_5_1 - 0.000324675324675342*G0_0_1_1_5_3 + 0.000735930735930761*G0_0_1_1_5_4 + 0.00445887445887461*G0_0_1_1_5_5 - 0.00050054112554114*G0_0_1_2_0_0 - 0.000311147186147198*G0_0_1_2_0_2 - 0.000189393939393946*G0_0_1_2_0_3 - 0.000259740259740269*G0_0_1_2_0_4 + 0.000367965367965381*G0_0_1_2_0_5 + 0.00130817099567104*G0_0_1_2_1_1 - 0.00130817099567104*G0_0_1_2_1_2 - 0.000311147186147198*G0_0_1_2_2_0 - 0.00130817099567104*G0_0_1_2_2_1 + 0.0134537337662343*G0_0_1_2_2_2 + 0.00504329004329023*G0_0_1_2_2_3 + 0.00153138528138534*G0_0_1_2_2_4 + 0.000340909090909105*G0_0_1_2_2_5 - 0.000189393939393946*G0_0_1_2_3_0 + 0.00504329004329023*G0_0_1_2_3_2 + 0.00673160173160197*G0_0_1_2_3_3 + 0.00032467532467534*G0_0_1_2_3_4 - 0.00030303030303031*G0_0_1_2_3_5 - 0.000259740259740269*G0_0_1_2_4_0 + 0.00153138528138534*G0_0_1_2_4_2 + 0.00032467532467534*G0_0_1_2_4_3 - 0.0044588744588746*G0_0_1_2_4_4 - 0.000735930735930759*G0_0_1_2_4_5 + 0.000367965367965381*G0_0_1_2_5_0 + 0.000340909090909104*G0_0_1_2_5_2 - 0.00030303030303031*G0_0_1_2_5_3 - 0.000735930735930759*G0_0_1_2_5_4 - 0.00142857142857147*G0_0_1_2_5_5 + 0.000189393939393946*G0_0_1_3_0_1 - 0.000189393939393946*G0_0_1_3_0_2 + 0.000735930735930759*G0_0_1_3_0_4 - 0.00073593073593076*G0_0_1_3_0_5 + 0.000189393939393946*G0_0_1_3_1_0 - 0.00504329004329022*G0_0_1_3_1_1 - 0.00673160173160197*G0_0_1_3_1_3 + 0.000303030303030313*G0_0_1_3_1_4 - 0.000324675324675342*G0_0_1_3_1_5 - 0.000189393939393946*G0_0_1_3_2_0 + 0.00504329004329023*G0_0_1_3_2_2 + 0.00673160173160197*G0_0_1_3_2_3 + 0.00032467532467534*G0_0_1_3_2_4 - 0.00030303030303031*G0_0_1_3_2_5 - 0.00673160173160197*G0_0_1_3_3_1 + 0.00673160173160197*G0_0_1_3_3_2 - 0.000606060606060623*G0_0_1_3_3_4 + 0.00060606060606062*G0_0_1_3_3_5 + 0.000735930735930759*G0_0_1_3_4_0 + 0.000303030303030312*G0_0_1_3_4_1 + 0.00032467532467534*G0_0_1_3_4_2 - 0.000606060606060624*G0_0_1_3_4_3 - 0.00432900432900447*G0_0_1_3_4_4 - 0.00073593073593076*G0_0_1_3_5_0 - 0.000324675324675342*G0_0_1_3_5_1 - 0.00030303030303031*G0_0_1_3_5_2 + 0.000606060606060618*G0_0_1_3_5_3 + 0.00432900432900447*G0_0_1_3_5_5 + 0.00189393939393945*G0_0_1_4_0_0 - 0.000367965367965379*G0_0_1_4_0_1 - 0.000259740259740269*G0_0_1_4_0_2 + 0.000735930735930759*G0_0_1_4_0_3 + 0.00692640692640715*G0_0_1_4_0_4 - 0.000367965367965379*G0_0_1_4_1_0 - 0.000340909090909102*G0_0_1_4_1_1 + 0.000303030303030312*G0_0_1_4_1_3 + 0.00142857142857147*G0_0_1_4_1_4 + 0.000735930735930761*G0_0_1_4_1_5 - 0.000259740259740269*G0_0_1_4_2_0 + 0.00153138528138534*G0_0_1_4_2_2 + 0.000324675324675341*G0_0_1_4_2_3 - 0.0044588744588746*G0_0_1_4_2_4 - 0.000735930735930759*G0_0_1_4_2_5 + 0.000735930735930759*G0_0_1_4_3_0 + 0.000303030303030312*G0_0_1_4_3_1 + 0.000324675324675341*G0_0_1_4_3_2 - 0.000606060606060623*G0_0_1_4_3_3 - 0.00432900432900447*G0_0_1_4_3_4 + 0.00692640692640715*G0_0_1_4_4_0 + 0.00142857142857147*G0_0_1_4_4_1 - 0.0044588744588746*G0_0_1_4_4_2 - 0.00432900432900447*G0_0_1_4_4_3 - 0.0124675324675329*G0_0_1_4_4_4 - 0.00138528138528144*G0_0_1_4_4_5 + 0.000735930735930762*G0_0_1_4_5_1 - 0.000735930735930759*G0_0_1_4_5_2 - 0.00138528138528144*G0_0_1_4_5_4 + 0.00138528138528142*G0_0_1_4_5_5 - 0.00189393939393948*G0_0_1_5_0_0 + 0.000259740259740275*G0_0_1_5_0_1 + 0.000367965367965381*G0_0_1_5_0_2 - 0.00073593073593076*G0_0_1_5_0_3 - 0.00692640692640718*G0_0_1_5_0_5 + 0.000259740259740275*G0_0_1_5_1_0 - 0.00153138528138535*G0_0_1_5_1_1 - 0.000324675324675343*G0_0_1_5_1_3 + 0.000735930735930761*G0_0_1_5_1_4 + 0.00445887445887461*G0_0_1_5_1_5 + 0.000367965367965381*G0_0_1_5_2_0 + 0.000340909090909105*G0_0_1_5_2_2 - 0.00030303030303031*G0_0_1_5_2_3 - 0.000735930735930759*G0_0_1_5_2_4 - 0.00142857142857147*G0_0_1_5_2_5 - 0.00073593073593076*G0_0_1_5_3_0 - 0.000324675324675342*G0_0_1_5_3_1 - 0.00030303030303031*G0_0_1_5_3_2 + 0.00060606060606062*G0_0_1_5_3_3 + 0.00432900432900447*G0_0_1_5_3_5 + 0.000735930735930761*G0_0_1_5_4_1 - 0.000735930735930759*G0_0_1_5_4_2 - 0.00138528138528144*G0_0_1_5_4_4 + 0.00138528138528142*G0_0_1_5_4_5 - 0.00692640692640718*G0_0_1_5_5_0 + 0.00445887445887461*G0_0_1_5_5_1 - 0.00142857142857147*G0_0_1_5_5_2 + 0.00432900432900447*G0_0_1_5_5_3 + 0.00138528138528142*G0_0_1_5_5_4 + 0.0124675324675329*G0_0_1_5_5_5 - 0.00124458874458881*G0_1_0_0_0_4 + 0.00124458874458875*G0_1_0_0_0_5 + 0.000930735930735962*G0_1_0_0_1_1 + 0.000476190476190493*G0_1_0_0_1_3 - 0.000281385281385288*G0_1_0_0_1_4 - 0.000584415584415595*G0_1_0_0_1_5 - 0.000930735930735965*G0_1_0_0_2_2 - 0.000476190476190492*G0_1_0_0_2_3 + 0.000584415584415604*G0_1_0_0_2_4 + 0.000281385281385292*G0_1_0_0_2_5 + 0.000476190476190493*G0_1_0_0_3_1 - 0.000476190476190492*G0_1_0_0_3_2 + 0.000562770562770579*G0_1_0_0_3_4 - 0.000562770562770582*G0_1_0_0_3_5 - 0.00124458874458881*G0_1_0_0_4_0 - 0.000281385281385288*G0_1_0_0_4_1 + 0.000584415584415604*G0_1_0_0_4_2 + 0.000562770562770579*G0_1_0_0_4_3 + 0.00216450216450222*G0_1_0_0_4_4 + 0.00124458874458875*G0_1_0_0_5_0 - 0.000584415584415595*G0_1_0_0_5_1 + 0.000281385281385292*G0_1_0_0_5_2 - 0.000562770562770582*G0_1_0_0_5_3 - 0.00216450216450226*G0_1_0_0_5_5 + 0.000930735930735962*G0_1_0_1_0_1 + 0.000476190476190493*G0_1_0_1_0_3 - 0.000281385281385288*G0_1_0_1_0_4 - 0.000584415584415595*G0_1_0_1_0_5 + 0.000930735930735963*G0_1_0_1_1_0 - 0.0260430194805204*G0_1_0_1_1_1 + 0.00252299783549793*G0_1_0_1_1_2 - 0.0096158008658012*G0_1_0_1_1_3 - 0.000454545454545469*G0_1_0_1_1_4 - 0.0029653679653681*G0_1_0_1_1_5 + 0.00252299783549793*G0_1_0_1_2_1 - 0.00252299783549793*G0_1_0_1_2_2 - 0.000173160173160181*G0_1_0_1_2_4 + 0.000173160173160181*G0_1_0_1_2_5 + 0.000476190476190493*G0_1_0_1_3_0 - 0.0096158008658012*G0_1_0_1_3_1 - 0.0132683982683987*G0_1_0_1_3_3 - 0.00129870129870136*G0_1_0_1_3_5 - 0.000281385281385288*G0_1_0_1_4_0 - 0.000454545454545469*G0_1_0_1_4_1 - 0.000173160173160181*G0_1_0_1_4_2 + 0.00181818181818188*G0_1_0_1_4_4 + 0.000562770562770583*G0_1_0_1_4_5 - 0.000584415584415595*G0_1_0_1_5_0 - 0.0029653679653681*G0_1_0_1_5_1 + 0.000173160173160181*G0_1_0_1_5_2 - 0.00129870129870136*G0_1_0_1_5_3 + 0.000562770562770583*G0_1_0_1_5_4 + 0.00268398268398277*G0_1_0_1_5_5 - 0.000930735930735965*G0_1_0_2_0_2 - 0.000476190476190492*G0_1_0_2_0_3 + 0.000584415584415604*G0_1_0_2_0_4 + 0.000281385281385292*G0_1_0_2_0_5 + 0.00252299783549793*G0_1_0_2_1_1 - 0.00252299783549793*G0_1_0_2_1_2 - 0.000173160173160181*G0_1_0_2_1_4 + 0.000173160173160181*G0_1_0_2_1_5 - 0.000930735930735965*G0_1_0_2_2_0 - 0.00252299783549793*G0_1_0_2_2_1 + 0.0260430194805204*G0_1_0_2_2_2 + 0.00961580086580122*G0_1_0_2_2_3 + 0.00296536796536808*G0_1_0_2_2_4 + 0.000454545454545474*G0_1_0_2_2_5 - 0.000476190476190492*G0_1_0_2_3_0 + 0.00961580086580122*G0_1_0_2_3_2 + 0.0132683982683987*G0_1_0_2_3_3 + 0.00129870129870135*G0_1_0_2_3_4 + 0.000584415584415604*G0_1_0_2_4_0 - 0.000173160173160181*G0_1_0_2_4_1 + 0.00296536796536808*G0_1_0_2_4_2 + 0.00129870129870135*G0_1_0_2_4_3 - 0.00268398268398276*G0_1_0_2_4_4 - 0.000562770562770579*G0_1_0_2_4_5 + 0.000281385281385292*G0_1_0_2_5_0 + 0.000173160173160181*G0_1_0_2_5_1 + 0.000454545454545475*G0_1_0_2_5_2 - 0.000562770562770579*G0_1_0_2_5_4 - 0.00181818181818187*G0_1_0_2_5_5 + 0.000476190476190493*G0_1_0_3_0_1 - 0.000476190476190492*G0_1_0_3_0_2 + 0.000562770562770579*G0_1_0_3_0_4 - 0.000562770562770582*G0_1_0_3_0_5 + 0.000476190476190493*G0_1_0_3_1_0 - 0.0096158008658012*G0_1_0_3_1_1 - 0.0132683982683987*G0_1_0_3_1_3 - 0.00129870129870136*G0_1_0_3_1_5 - 0.000476190476190492*G0_1_0_3_2_0 + 0.00961580086580122*G0_1_0_3_2_2 + 0.0132683982683987*G0_1_0_3_2_3 + 0.00129870129870135*G0_1_0_3_2_4 - 0.0132683982683987*G0_1_0_3_3_1 + 0.0132683982683987*G0_1_0_3_3_2 + 0.000562770562770579*G0_1_0_3_4_0 + 0.00129870129870135*G0_1_0_3_4_2 - 0.00476190476190491*G0_1_0_3_4_4 - 0.000562770562770582*G0_1_0_3_5_0 - 0.00129870129870136*G0_1_0_3_5_1 + 0.00476190476190491*G0_1_0_3_5_5 - 0.00124458874458881*G0_1_0_4_0_0 - 0.000281385281385288*G0_1_0_4_0_1 + 0.000584415584415604*G0_1_0_4_0_2 + 0.000562770562770579*G0_1_0_4_0_3 + 0.00216450216450222*G0_1_0_4_0_4 - 0.000281385281385288*G0_1_0_4_1_0 - 0.000454545454545469*G0_1_0_4_1_1 - 0.000173160173160181*G0_1_0_4_1_2 + 0.00181818181818188*G0_1_0_4_1_4 + 0.000562770562770583*G0_1_0_4_1_5 + 0.000584415584415604*G0_1_0_4_2_0 - 0.000173160173160181*G0_1_0_4_2_1 + 0.00296536796536808*G0_1_0_4_2_2 + 0.00129870129870135*G0_1_0_4_2_3 - 0.00268398268398276*G0_1_0_4_2_4 - 0.000562770562770579*G0_1_0_4_2_5 + 0.000562770562770579*G0_1_0_4_3_0 + 0.00129870129870135*G0_1_0_4_3_2 - 0.00476190476190491*G0_1_0_4_3_4 + 0.00216450216450222*G0_1_0_4_4_0 + 0.00181818181818188*G0_1_0_4_4_1 - 0.00268398268398276*G0_1_0_4_4_2 - 0.00476190476190491*G0_1_0_4_4_3 - 0.0225974025974033*G0_1_0_4_4_4 - 0.0025108225108226*G0_1_0_4_4_5 + 0.000562770562770583*G0_1_0_4_5_1 - 0.000562770562770579*G0_1_0_4_5_2 - 0.0025108225108226*G0_1_0_4_5_4 + 0.00251082251082258*G0_1_0_4_5_5 + 0.00124458874458875*G0_1_0_5_0_0 - 0.000584415584415595*G0_1_0_5_0_1 + 0.000281385281385292*G0_1_0_5_0_2 - 0.000562770562770582*G0_1_0_5_0_3 - 0.00216450216450226*G0_1_0_5_0_5 - 0.000584415584415595*G0_1_0_5_1_0 - 0.0029653679653681*G0_1_0_5_1_1 + 0.000173160173160181*G0_1_0_5_1_2 - 0.00129870129870136*G0_1_0_5_1_3 + 0.000562770562770583*G0_1_0_5_1_4 + 0.00268398268398277*G0_1_0_5_1_5 + 0.000281385281385292*G0_1_0_5_2_0 + 0.000173160173160181*G0_1_0_5_2_1 + 0.000454545454545475*G0_1_0_5_2_2 - 0.000562770562770579*G0_1_0_5_2_4 - 0.00181818181818187*G0_1_0_5_2_5 - 0.000562770562770582*G0_1_0_5_3_0 - 0.00129870129870136*G0_1_0_5_3_1 + 0.00476190476190491*G0_1_0_5_3_5 + 0.000562770562770583*G0_1_0_5_4_1 - 0.000562770562770579*G0_1_0_5_4_2 - 0.0025108225108226*G0_1_0_5_4_4 + 0.00251082251082258*G0_1_0_5_4_5 - 0.00216450216450226*G0_1_0_5_5_0 + 0.00268398268398277*G0_1_0_5_5_1 - 0.00181818181818187*G0_1_0_5_5_2 + 0.00476190476190491*G0_1_0_5_5_3 + 0.00251082251082258*G0_1_0_5_5_4 + 0.0225974025974033*G0_1_0_5_5_5 + 0.000251623376623396*G0_1_1_0_0_1 - 0.000154220779220775*G0_1_1_0_0_2 + 0.000324675324675303*G0_1_1_0_0_4 - 0.000324675324675391*G0_1_1_0_0_5 + 0.000251623376623396*G0_1_1_0_1_0 + 0.00104707792207796*G0_1_1_0_1_1 + 0.000194805194805203*G0_1_1_0_1_3 - 0.000551948051948066*G0_1_1_0_1_4 - 0.00058441558441559*G0_1_1_0_1_5 - 0.000154220779220775*G0_1_1_0_2_0 - 0.000194805194805202*G0_1_1_0_2_2 - 0.000470779220779235*G0_1_1_0_2_3 - 0.000259740259740265*G0_1_1_0_2_4 + 0.000194805194805203*G0_1_1_0_3_1 - 0.000470779220779235*G0_1_1_0_3_2 - 0.0003896103896104*G0_1_1_0_3_3 + 0.00129870129870134*G0_1_1_0_3_4 + 0.000324675324675302*G0_1_1_0_4_0 - 0.000551948051948065*G0_1_1_0_4_1 - 0.000259740259740265*G0_1_1_0_4_2 + 0.00129870129870134*G0_1_1_0_4_3 + 0.00363636363636373*G0_1_1_0_4_4 + 0.000909090909090924*G0_1_1_0_4_5 - 0.000324675324675391*G0_1_1_0_5_0 - 0.00058441558441559*G0_1_1_0_5_1 + 0.000909090909090924*G0_1_1_0_5_4 - 0.00545454545454568*G0_1_1_0_5_5 + 0.000251623376623396*G0_1_1_1_0_0 + 0.00104707792207796*G0_1_1_1_0_1 + 0.000194805194805203*G0_1_1_1_0_3 - 0.000551948051948066*G0_1_1_1_0_4 - 0.00058441558441559*G0_1_1_1_0_5 + 0.00104707792207796*G0_1_1_1_1_0 - 0.0336038961038973*G0_1_1_1_1_1 + 0.00258116883116892*G0_1_1_1_1_2 - 0.00996753246753281*G0_1_1_1_1_3 - 0.000584415584415602*G0_1_1_1_1_4 - 0.00366883116883133*G0_1_1_1_1_5 + 0.00258116883116892*G0_1_1_1_2_1 - 0.00125000000000004*G0_1_1_1_2_2 - 0.000162337662337671*G0_1_1_1_2_3 - 0.000211038961038969*G0_1_1_1_2_4 + 0.000194805194805203*G0_1_1_1_3_0 - 0.00996753246753281*G0_1_1_1_3_1 - 0.00016233766233767*G0_1_1_1_3_2 - 0.00987012987013021*G0_1_1_1_3_3 + 0.000779220779220802*G0_1_1_1_3_4 - 0.000259740259740283*G0_1_1_1_3_5 - 0.000551948051948065*G0_1_1_1_4_0 - 0.000584415584415602*G0_1_1_1_4_1 - 0.000211038961038969*G0_1_1_1_4_2 + 0.000779220779220802*G0_1_1_1_4_3 + 0.00194805194805201*G0_1_1_1_4_4 + 0.00129870129870134*G0_1_1_1_4_5 - 0.00058441558441559*G0_1_1_1_5_0 - 0.00366883116883133*G0_1_1_1_5_1 - 0.000259740259740283*G0_1_1_1_5_3 + 0.00129870129870134*G0_1_1_1_5_4 + 0.00649350649350671*G0_1_1_1_5_5 - 0.000154220779220775*G0_1_1_2_0_0 - 0.000194805194805202*G0_1_1_2_0_2 - 0.000470779220779236*G0_1_1_2_0_3 - 0.000259740259740265*G0_1_1_2_0_4 + 0.00258116883116892*G0_1_1_2_1_1 - 0.00125000000000004*G0_1_1_2_1_2 - 0.000162337662337671*G0_1_1_2_1_3 - 0.000211038961038969*G0_1_1_2_1_4 - 0.000194805194805202*G0_1_1_2_2_0 - 0.00125000000000004*G0_1_1_2_2_1 + 0.00589285714285736*G0_1_1_2_2_2 + 0.00469155844155861*G0_1_1_2_2_3 + 0.00082792207792211*G0_1_1_2_2_4 + 0.000211038961038969*G0_1_1_2_2_5 - 0.000470779220779235*G0_1_1_2_3_0 - 0.000162337662337671*G0_1_1_2_3_1 + 0.00469155844155861*G0_1_1_2_3_2 + 0.0101298701298705*G0_1_1_2_3_3 + 0.00136363636363641*G0_1_1_2_3_4 + 0.000519480519480541*G0_1_1_2_3_5 - 0.000259740259740265*G0_1_1_2_4_0 - 0.000211038961038969*G0_1_1_2_4_1 + 0.00082792207792211*G0_1_1_2_4_2 + 0.00136363636363641*G0_1_1_2_4_3 - 0.000649350649350664*G0_1_1_2_4_4 + 0.000211038961038969*G0_1_1_2_5_2 + 0.000519480519480541*G0_1_1_2_5_3 - 0.00129870129870134*G0_1_1_2_5_5 + 0.000194805194805203*G0_1_1_3_0_1 - 0.000470779220779235*G0_1_1_3_0_2 - 0.0003896103896104*G0_1_1_3_0_3 + 0.00129870129870134*G0_1_1_3_0_4 + 0.000194805194805203*G0_1_1_3_1_0 - 0.00996753246753281*G0_1_1_3_1_1 - 0.000162337662337671*G0_1_1_3_1_2 - 0.00987012987013021*G0_1_1_3_1_3 + 0.000779220779220802*G0_1_1_3_1_4 - 0.000259740259740283*G0_1_1_3_1_5 - 0.000470779220779235*G0_1_1_3_2_0 - 0.000162337662337671*G0_1_1_3_2_1 + 0.00469155844155861*G0_1_1_3_2_2 + 0.0101298701298705*G0_1_1_3_2_3 + 0.00136363636363641*G0_1_1_3_2_4 + 0.000519480519480541*G0_1_1_3_2_5 - 0.0003896103896104*G0_1_1_3_3_0 - 0.00987012987013021*G0_1_1_3_3_1 + 0.0101298701298705*G0_1_1_3_3_2 + 0.0397402597402612*G0_1_1_3_3_3 - 0.000779220779220784*G0_1_1_3_3_4 - 0.000259740259740258*G0_1_1_3_3_5 + 0.00129870129870134*G0_1_1_3_4_0 + 0.000779220779220802*G0_1_1_3_4_1 + 0.00136363636363641*G0_1_1_3_4_2 - 0.000779220779220783*G0_1_1_3_4_3 - 0.0064935064935067*G0_1_1_3_4_4 - 0.00259740259740268*G0_1_1_3_4_5 - 0.000259740259740283*G0_1_1_3_5_1 + 0.000519480519480541*G0_1_1_3_5_2 - 0.000259740259740258*G0_1_1_3_5_3 - 0.00259740259740268*G0_1_1_3_5_4 + 0.00259740259740268*G0_1_1_3_5_5 + 0.000324675324675302*G0_1_1_4_0_0 - 0.000551948051948066*G0_1_1_4_0_1 - 0.000259740259740265*G0_1_1_4_0_2 + 0.00129870129870134*G0_1_1_4_0_3 + 0.00363636363636373*G0_1_1_4_0_4 + 0.000909090909090924*G0_1_1_4_0_5 - 0.000551948051948066*G0_1_1_4_1_0 - 0.000584415584415602*G0_1_1_4_1_1 - 0.000211038961038969*G0_1_1_4_1_2 + 0.000779220779220802*G0_1_1_4_1_3 + 0.00194805194805201*G0_1_1_4_1_4 + 0.00129870129870134*G0_1_1_4_1_5 - 0.000259740259740265*G0_1_1_4_2_0 - 0.000211038961038969*G0_1_1_4_2_1 + 0.00082792207792211*G0_1_1_4_2_2 + 0.00136363636363641*G0_1_1_4_2_3 - 0.000649350649350664*G0_1_1_4_2_4 + 0.00129870129870134*G0_1_1_4_3_0 + 0.000779220779220802*G0_1_1_4_3_1 + 0.00136363636363641*G0_1_1_4_3_2 - 0.000779220779220786*G0_1_1_4_3_3 - 0.0064935064935067*G0_1_1_4_3_4 - 0.00259740259740268*G0_1_1_4_3_5 + 0.00363636363636373*G0_1_1_4_4_0 + 0.00194805194805201*G0_1_1_4_4_1 - 0.000649350649350664*G0_1_1_4_4_2 - 0.0064935064935067*G0_1_1_4_4_3 - 0.0116883116883121*G0_1_1_4_4_4 - 0.00389610389610403*G0_1_1_4_4_5 + 0.000909090909090924*G0_1_1_4_5_0 + 0.00129870129870134*G0_1_1_4_5_1 - 0.00259740259740268*G0_1_1_4_5_3 - 0.00389610389610403*G0_1_1_4_5_4 - 0.000324675324675392*G0_1_1_5_0_0 - 0.00058441558441559*G0_1_1_5_0_1 + 0.000909090909090924*G0_1_1_5_0_4 - 0.00545454545454568*G0_1_1_5_0_5 - 0.00058441558441559*G0_1_1_5_1_0 - 0.00366883116883133*G0_1_1_5_1_1 - 0.000259740259740283*G0_1_1_5_1_3 + 0.00129870129870134*G0_1_1_5_1_4 + 0.00649350649350671*G0_1_1_5_1_5 + 0.000211038961038969*G0_1_1_5_2_2 + 0.000519480519480541*G0_1_1_5_2_3 - 0.00129870129870134*G0_1_1_5_2_5 - 0.000259740259740283*G0_1_1_5_3_1 + 0.000519480519480541*G0_1_1_5_3_2 - 0.000259740259740259*G0_1_1_5_3_3 - 0.00259740259740268*G0_1_1_5_3_4 + 0.00259740259740268*G0_1_1_5_3_5 + 0.000909090909090923*G0_1_1_5_4_0 + 0.00129870129870134*G0_1_1_5_4_1 - 0.00259740259740268*G0_1_1_5_4_3 - 0.00389610389610403*G0_1_1_5_4_4 - 0.00545454545454568*G0_1_1_5_5_0 + 0.00649350649350671*G0_1_1_5_5_1 - 0.00129870129870134*G0_1_1_5_5_2 + 0.00259740259740268*G0_1_1_5_5_3 + 0.0233766233766241*G0_1_1_5_5_5;
    A[28] = -A[27] + 0.0125892857142861*G0_1_0_0_0_0 - 0.00121482683982688*G0_1_0_0_0_1 - 0.000619588744588766*G0_1_0_0_0_2 + 0.000113636363636366*G0_1_0_0_0_3 + 0.00143398268398273*G0_1_0_0_0_4 + 0.00457251082251098*G0_1_0_0_0_5 - 0.00121482683982688*G0_1_0_0_1_0 + 0.00121482683982688*G0_1_0_0_1_1 + 0.000200216450216456*G0_1_0_0_1_3 - 0.000200216450216457*G0_1_0_0_1_4 - 0.000619588744588766*G0_1_0_0_2_0 + 0.00059523809523812*G0_1_0_0_2_2 + 0.000844155844155875*G0_1_0_0_2_4 - 0.000286796536796546*G0_1_0_0_2_5 + 0.000113636363636366*G0_1_0_0_3_0 + 0.000200216450216456*G0_1_0_0_3_1 - 0.000389610389610401*G0_1_0_0_3_3 + 0.000173160173160179*G0_1_0_0_3_4 + 0.000346320346320356*G0_1_0_0_3_5 + 0.00143398268398273*G0_1_0_0_4_0 - 0.000200216450216457*G0_1_0_0_4_1 + 0.000844155844155875*G0_1_0_0_4_2 + 0.000173160173160179*G0_1_0_0_4_3 + 0.00177489177489184*G0_1_0_0_4_4 + 0.000974025974026006*G0_1_0_0_4_5 + 0.00457251082251098*G0_1_0_0_5_0 - 0.000286796536796546*G0_1_0_0_5_2 + 0.000346320346320356*G0_1_0_0_5_3 + 0.000974025974026006*G0_1_0_0_5_4 + 0.00653679653679676*G0_1_0_0_5_5 - 0.00121482683982688*G0_1_0_1_0_0 + 0.00121482683982688*G0_1_0_1_0_1 + 0.000200216450216456*G0_1_0_1_0_3 - 0.000200216450216457*G0_1_0_1_0_4 + 0.00121482683982688*G0_1_0_1_1_0 - 0.0125892857142861*G0_1_0_1_1_1 + 0.000619588744588765*G0_1_0_1_1_2 - 0.00143398268398273*G0_1_0_1_1_3 - 0.000113636363636366*G0_1_0_1_1_4 - 0.00457251082251099*G0_1_0_1_1_5 + 0.000619588744588765*G0_1_0_1_2_1 - 0.000595238095238112*G0_1_0_1_2_2 - 0.000844155844155872*G0_1_0_1_2_3 + 0.000286796536796547*G0_1_0_1_2_5 + 0.000200216450216456*G0_1_0_1_3_0 - 0.00143398268398273*G0_1_0_1_3_1 - 0.000844155844155872*G0_1_0_1_3_2 - 0.00177489177489183*G0_1_0_1_3_3 - 0.000173160173160177*G0_1_0_1_3_4 - 0.000974025974026007*G0_1_0_1_3_5 - 0.000200216450216457*G0_1_0_1_4_0 - 0.000113636363636366*G0_1_0_1_4_1 - 0.000173160173160177*G0_1_0_1_4_3 + 0.000389610389610404*G0_1_0_1_4_4 - 0.000346320346320357*G0_1_0_1_4_5 - 0.00457251082251099*G0_1_0_1_5_1 + 0.000286796536796547*G0_1_0_1_5_2 - 0.000974025974026007*G0_1_0_1_5_3 - 0.000346320346320356*G0_1_0_1_5_4 - 0.00653679653679676*G0_1_0_1_5_5 - 0.000619588744588766*G0_1_0_2_0_0 + 0.00059523809523812*G0_1_0_2_0_2 + 0.000844155844155875*G0_1_0_2_0_4 - 0.000286796536796546*G0_1_0_2_0_5 + 0.000619588744588765*G0_1_0_2_1_1 - 0.000595238095238112*G0_1_0_2_1_2 - 0.000844155844155872*G0_1_0_2_1_3 + 0.000286796536796547*G0_1_0_2_1_5 + 0.00059523809523812*G0_1_0_2_2_0 - 0.000595238095238112*G0_1_0_2_2_1 + 0.00313852813852823*G0_1_0_2_2_3 - 0.00313852813852826*G0_1_0_2_2_4 - 0.000844155844155871*G0_1_0_2_3_1 + 0.00313852813852823*G0_1_0_2_3_2 + 0.00476190476190492*G0_1_0_2_3_3 + 0.000173160173160179*G0_1_0_2_3_5 + 0.000844155844155875*G0_1_0_2_4_0 - 0.00313852813852826*G0_1_0_2_4_2 - 0.00476190476190493*G0_1_0_2_4_4 - 0.000173160173160181*G0_1_0_2_4_5 - 0.000286796536796546*G0_1_0_2_5_0 + 0.000286796536796547*G0_1_0_2_5_1 + 0.000173160173160178*G0_1_0_2_5_3 - 0.000173160173160181*G0_1_0_2_5_4 + 0.000113636363636366*G0_1_0_3_0_0 + 0.000200216450216456*G0_1_0_3_0_1 - 0.000389610389610401*G0_1_0_3_0_3 + 0.000173160173160179*G0_1_0_3_0_4 + 0.000346320346320357*G0_1_0_3_0_5 + 0.000200216450216456*G0_1_0_3_1_0 - 0.00143398268398273*G0_1_0_3_1_1 - 0.000844155844155872*G0_1_0_3_1_2 - 0.00177489177489183*G0_1_0_3_1_3 - 0.000173160173160177*G0_1_0_3_1_4 - 0.000974025974026007*G0_1_0_3_1_5 - 0.000844155844155872*G0_1_0_3_2_1 + 0.00313852813852823*G0_1_0_3_2_2 + 0.00476190476190492*G0_1_0_3_2_3 + 0.000173160173160179*G0_1_0_3_2_5 - 0.000389610389610401*G0_1_0_3_3_0 - 0.00177489177489183*G0_1_0_3_3_1 + 0.00476190476190492*G0_1_0_3_3_2 + 0.0101298701298705*G0_1_0_3_3_3 + 0.00112554112554116*G0_1_0_3_3_4 + 0.000432900432900453*G0_1_0_3_3_5 + 0.000173160173160179*G0_1_0_3_4_0 - 0.000173160173160177*G0_1_0_3_4_1 + 0.00112554112554116*G0_1_0_3_4_3 - 0.00112554112554117*G0_1_0_3_4_4 + 0.000346320346320357*G0_1_0_3_5_0 - 0.000974025974026007*G0_1_0_3_5_1 + 0.000173160173160179*G0_1_0_3_5_2 + 0.000432900432900452*G0_1_0_3_5_3 - 0.000692640692640715*G0_1_0_3_5_5 + 0.00143398268398273*G0_1_0_4_0_0 - 0.000200216450216457*G0_1_0_4_0_1 + 0.000844155844155875*G0_1_0_4_0_2 + 0.000173160173160179*G0_1_0_4_0_3 + 0.00177489177489183*G0_1_0_4_0_4 + 0.000974025974026006*G0_1_0_4_0_5 - 0.000200216450216457*G0_1_0_4_1_0 - 0.000113636363636366*G0_1_0_4_1_1 - 0.000173160173160177*G0_1_0_4_1_3 + 0.000389610389610404*G0_1_0_4_1_4 - 0.000346320346320357*G0_1_0_4_1_5 + 0.000844155844155875*G0_1_0_4_2_0 - 0.00313852813852826*G0_1_0_4_2_2 - 0.00476190476190493*G0_1_0_4_2_4 - 0.000173160173160181*G0_1_0_4_2_5 + 0.000173160173160179*G0_1_0_4_3_0 - 0.000173160173160177*G0_1_0_4_3_1 + 0.00112554112554116*G0_1_0_4_3_3 - 0.00112554112554117*G0_1_0_4_3_4 + 0.00177489177489183*G0_1_0_4_4_0 + 0.000389610389610404*G0_1_0_4_4_1 - 0.00476190476190493*G0_1_0_4_4_2 - 0.00112554112554117*G0_1_0_4_4_3 - 0.0101298701298705*G0_1_0_4_4_4 - 0.000432900432900452*G0_1_0_4_4_5 + 0.000974025974026006*G0_1_0_4_5_0 - 0.000346320346320357*G0_1_0_4_5_1 - 0.000173160173160181*G0_1_0_4_5_2 - 0.000432900432900451*G0_1_0_4_5_4 + 0.000692640692640717*G0_1_0_4_5_5 + 0.00457251082251098*G0_1_0_5_0_0 - 0.000286796536796546*G0_1_0_5_0_2 + 0.000346320346320356*G0_1_0_5_0_3 + 0.000974025974026006*G0_1_0_5_0_4 + 0.00653679653679676*G0_1_0_5_0_5 - 0.00457251082251099*G0_1_0_5_1_1 + 0.000286796536796547*G0_1_0_5_1_2 - 0.000974025974026007*G0_1_0_5_1_3 - 0.000346320346320356*G0_1_0_5_1_4 - 0.00653679653679676*G0_1_0_5_1_5 - 0.000286796536796546*G0_1_0_5_2_0 + 0.000286796536796547*G0_1_0_5_2_1 + 0.000173160173160179*G0_1_0_5_2_3 - 0.000173160173160181*G0_1_0_5_2_4 + 0.000346320346320356*G0_1_0_5_3_0 - 0.000974025974026007*G0_1_0_5_3_1 + 0.000173160173160179*G0_1_0_5_3_2 + 0.000432900432900452*G0_1_0_5_3_3 - 0.000692640692640715*G0_1_0_5_3_5 + 0.000974025974026006*G0_1_0_5_4_0 - 0.000346320346320357*G0_1_0_5_4_1 - 0.000173160173160181*G0_1_0_5_4_2 - 0.000432900432900453*G0_1_0_5_4_4 + 0.000692640692640716*G0_1_0_5_4_5 + 0.00653679653679676*G0_1_0_5_5_0 - 0.00653679653679676*G0_1_0_5_5_1 - 0.000692640692640715*G0_1_0_5_5_3 + 0.000692640692640717*G0_1_0_5_5_4 - 0.00429383116883133*G0_1_1_0_0_0 + 0.000324675324675338*G0_1_1_0_0_1 + 0.000262445887445897*G0_1_1_0_0_2 + 0.000167748917748923*G0_1_1_0_0_3 - 0.000416666666666683*G0_1_1_0_0_4 - 0.00461580086580103*G0_1_1_0_0_5 + 0.000324675324675338*G0_1_1_0_1_0 + 0.00153950216450222*G0_1_1_0_1_1 + 0.000638528138528159*G0_1_1_0_1_3 + 0.000438311688311702*G0_1_1_0_1_4 + 0.00360389610389623*G0_1_1_0_1_5 + 0.000262445887445897*G0_1_1_0_2_0 - 0.000679112554112575*G0_1_1_0_2_2 - 0.000183982683982689*G0_1_1_0_2_3 - 0.000194805194805201*G0_1_1_0_2_4 + 0.000286796536796548*G0_1_1_0_2_5 + 0.000167748917748923*G0_1_1_0_3_0 + 0.000638528138528159*G0_1_1_0_3_1 - 0.000183982683982689*G0_1_1_0_3_2 - 0.00225108225108232*G0_1_1_0_3_3 - 0.00121212121212125*G0_1_1_0_3_4 - 0.00090909090909094*G0_1_1_0_3_5 - 0.000416666666666683*G0_1_1_0_4_0 + 0.000438311688311702*G0_1_1_0_4_1 - 0.000194805194805201*G0_1_1_0_4_2 - 0.00121212121212125*G0_1_1_0_4_3 - 0.00073593073593076*G0_1_1_0_4_4 - 0.0014502164502165*G0_1_1_0_4_5 - 0.00461580086580103*G0_1_1_0_5_0 + 0.00360389610389623*G0_1_1_0_5_1 + 0.000286796536796548*G0_1_1_0_5_2 - 0.00090909090909094*G0_1_1_0_5_3 - 0.0014502164502165*G0_1_1_0_5_4 - 0.00298701298701312*G0_1_1_0_5_5 + 0.000324675324675338*G0_1_1_1_0_0 + 0.00153950216450222*G0_1_1_1_0_1 + 0.000638528138528159*G0_1_1_1_0_3 + 0.000438311688311702*G0_1_1_1_0_4 + 0.00360389610389623*G0_1_1_1_0_5 + 0.00153950216450222*G0_1_1_1_1_0 - 0.0168831168831175*G0_1_1_1_1_1 + 0.000882034632034662*G0_1_1_1_1_2 - 0.00185064935064941*G0_1_1_1_1_3 - 0.00918831168831202*G0_1_1_1_1_5 + 0.000882034632034662*G0_1_1_1_2_1 - 0.00127435064935069*G0_1_1_1_2_2 - 0.00103896103896107*G0_1_1_1_2_3 + 0.000573593073593093*G0_1_1_1_2_5 + 0.000638528138528159*G0_1_1_1_3_0 - 0.00185064935064941*G0_1_1_1_3_1 - 0.00103896103896107*G0_1_1_1_3_2 - 0.00251082251082259*G0_1_1_1_3_3 - 0.00138528138528143*G0_1_1_1_3_4 - 0.00242424242424251*G0_1_1_1_3_5 + 0.000438311688311702*G0_1_1_1_4_0 - 0.00138528138528143*G0_1_1_1_4_3 - 0.00186147186147192*G0_1_1_1_4_4 - 0.0012554112554113*G0_1_1_1_4_5 + 0.00360389610389623*G0_1_1_1_5_0 - 0.00918831168831202*G0_1_1_1_5_1 + 0.000573593073593093*G0_1_1_1_5_2 - 0.00242424242424251*G0_1_1_1_5_3 - 0.0012554112554113*G0_1_1_1_5_4 - 0.00952380952380986*G0_1_1_1_5_5 + 0.000262445887445897*G0_1_1_2_0_0 - 0.000679112554112575*G0_1_1_2_0_2 - 0.000183982683982689*G0_1_1_2_0_3 - 0.000194805194805201*G0_1_1_2_0_4 + 0.000286796536796548*G0_1_1_2_0_5 + 0.000882034632034662*G0_1_1_2_1_1 - 0.00127435064935069*G0_1_1_2_1_2 - 0.00103896103896107*G0_1_1_2_1_3 + 0.000573593073593093*G0_1_1_2_1_5 - 0.000679112554112575*G0_1_1_2_2_0 - 0.00127435064935069*G0_1_1_2_2_1 + 0.00868506493506522*G0_1_1_2_2_2 + 0.00595238095238115*G0_1_1_2_2_3 + 0.00281385281385291*G0_1_1_2_2_4 + 0.000573593073593095*G0_1_1_2_2_5 - 0.000183982683982689*G0_1_1_2_3_0 - 0.00103896103896107*G0_1_1_2_3_1 + 0.00595238095238115*G0_1_1_2_3_2 + 0.00441558441558457*G0_1_1_2_3_3 + 0.000562770562770582*G0_1_1_2_3_4 - 0.000779220779220806*G0_1_1_2_3_5 - 0.000194805194805201*G0_1_1_2_4_0 + 0.00281385281385291*G0_1_1_2_4_2 + 0.000562770562770582*G0_1_1_2_4_3 - 0.000346320346320358*G0_1_1_2_4_4 - 0.000952380952380986*G0_1_1_2_4_5 + 0.000286796536796548*G0_1_1_2_5_0 + 0.000573593073593093*G0_1_1_2_5_1 + 0.000573593073593095*G0_1_1_2_5_2 - 0.000779220779220806*G0_1_1_2_5_3 - 0.000952380952380986*G0_1_1_2_5_4 + 0.00190476190476197*G0_1_1_2_5_5 + 0.000167748917748923*G0_1_1_3_0_0 + 0.000638528138528159*G0_1_1_3_0_1 - 0.000183982683982689*G0_1_1_3_0_2 - 0.00225108225108232*G0_1_1_3_0_3 - 0.00121212121212125*G0_1_1_3_0_4 - 0.00090909090909094*G0_1_1_3_0_5 + 0.000638528138528159*G0_1_1_3_1_0 - 0.00185064935064941*G0_1_1_3_1_1 - 0.00103896103896107*G0_1_1_3_1_2 - 0.00251082251082259*G0_1_1_3_1_3 - 0.00138528138528143*G0_1_1_3_1_4 - 0.00242424242424251*G0_1_1_3_1_5 - 0.000183982683982689*G0_1_1_3_2_0 - 0.00103896103896107*G0_1_1_3_2_1 + 0.00595238095238116*G0_1_1_3_2_2 + 0.00441558441558457*G0_1_1_3_2_3 + 0.000562770562770582*G0_1_1_3_2_4 - 0.000779220779220806*G0_1_1_3_2_5 - 0.00225108225108232*G0_1_1_3_3_0 - 0.00251082251082259*G0_1_1_3_3_1 + 0.00441558441558457*G0_1_1_3_3_2 + 0.021298701298702*G0_1_1_3_3_3 + 0.00727272727272751*G0_1_1_3_3_4 + 0.00606060606060627*G0_1_1_3_3_5 - 0.00121212121212125*G0_1_1_3_4_0 - 0.00138528138528143*G0_1_1_3_4_1 + 0.000562770562770582*G0_1_1_3_4_2 + 0.00727272727272751*G0_1_1_3_4_3 + 0.00614718614718635*G0_1_1_3_4_4 + 0.00432900432900448*G0_1_1_3_4_5 - 0.00090909090909094*G0_1_1_3_5_0 - 0.00242424242424251*G0_1_1_3_5_1 - 0.000779220779220806*G0_1_1_3_5_2 + 0.00606060606060627*G0_1_1_3_5_3 + 0.00432900432900448*G0_1_1_3_5_4 - 0.00199134199134205*G0_1_1_3_5_5 - 0.000416666666666683*G0_1_1_4_0_0 + 0.000438311688311702*G0_1_1_4_0_1 - 0.000194805194805201*G0_1_1_4_0_2 - 0.00121212121212125*G0_1_1_4_0_3 - 0.000735930735930761*G0_1_1_4_0_4 - 0.0014502164502165*G0_1_1_4_0_5 + 0.000438311688311702*G0_1_1_4_1_0 - 0.00138528138528143*G0_1_1_4_1_3 - 0.00186147186147192*G0_1_1_4_1_4 - 0.0012554112554113*G0_1_1_4_1_5 - 0.000194805194805201*G0_1_1_4_2_0 + 0.00281385281385291*G0_1_1_4_2_2 + 0.000562770562770582*G0_1_1_4_2_3 - 0.000346320346320357*G0_1_1_4_2_4 - 0.000952380952380986*G0_1_1_4_2_5 - 0.00121212121212125*G0_1_1_4_3_0 - 0.00138528138528143*G0_1_1_4_3_1 + 0.000562770562770582*G0_1_1_4_3_2 + 0.00727272727272752*G0_1_1_4_3_3 + 0.00614718614718635*G0_1_1_4_3_4 + 0.00432900432900448*G0_1_1_4_3_5 - 0.00073593073593076*G0_1_1_4_4_0 - 0.00186147186147192*G0_1_1_4_4_1 - 0.000346320346320357*G0_1_1_4_4_2 + 0.00614718614718635*G0_1_1_4_4_3 + 0.0111688311688315*G0_1_1_4_4_4 + 0.00562770562770582*G0_1_1_4_4_5 - 0.0014502164502165*G0_1_1_4_5_0 - 0.0012554112554113*G0_1_1_4_5_1 - 0.000952380952380986*G0_1_1_4_5_2 + 0.00432900432900448*G0_1_1_4_5_3 + 0.00562770562770582*G0_1_1_4_5_4 - 0.00129870129870133*G0_1_1_4_5_5 - 0.00461580086580103*G0_1_1_5_0_0 + 0.00360389610389623*G0_1_1_5_0_1 + 0.000286796536796548*G0_1_1_5_0_2 - 0.00090909090909094*G0_1_1_5_0_3 - 0.0014502164502165*G0_1_1_5_0_4 - 0.00298701298701312*G0_1_1_5_0_5 + 0.00360389610389623*G0_1_1_5_1_0 - 0.00918831168831202*G0_1_1_5_1_1 + 0.000573593073593093*G0_1_1_5_1_2 - 0.00242424242424251*G0_1_1_5_1_3 - 0.0012554112554113*G0_1_1_5_1_4 - 0.00952380952380986*G0_1_1_5_1_5 + 0.000286796536796548*G0_1_1_5_2_0 + 0.000573593073593093*G0_1_1_5_2_1 + 0.000573593073593095*G0_1_1_5_2_2 - 0.000779220779220806*G0_1_1_5_2_3 - 0.000952380952380986*G0_1_1_5_2_4 + 0.00190476190476197*G0_1_1_5_2_5 - 0.00090909090909094*G0_1_1_5_3_0 - 0.00242424242424251*G0_1_1_5_3_1 - 0.000779220779220806*G0_1_1_5_3_2 + 0.00606060606060627*G0_1_1_5_3_3 + 0.00432900432900448*G0_1_1_5_3_4 - 0.00199134199134205*G0_1_1_5_3_5 - 0.0014502164502165*G0_1_1_5_4_0 - 0.0012554112554113*G0_1_1_5_4_1 - 0.000952380952380986*G0_1_1_5_4_2 + 0.00432900432900448*G0_1_1_5_4_3 + 0.00562770562770582*G0_1_1_5_4_4 - 0.00129870129870133*G0_1_1_5_4_5 - 0.00298701298701312*G0_1_1_5_5_0 - 0.00952380952380986*G0_1_1_5_5_1 + 0.00190476190476197*G0_1_1_5_5_2 - 0.00199134199134205*G0_1_1_5_5_3 - 0.00129870129870133*G0_1_1_5_5_4 - 0.0932467532467564*G0_1_1_5_5_5;
    A[80] = -A[30] + 0.0668019480519503*G0_0_0_0_0_0 - 0.00252435064935073*G0_0_0_0_0_1 - 0.00531114718614736*G0_0_0_0_0_2 + 0.00134199134199138*G0_0_0_0_0_3 + 0.0233225108225116*G0_0_0_0_0_4 + 0.010119047619048*G0_0_0_0_0_5 - 0.00252435064935073*G0_0_0_0_1_0 - 0.000703463203463227*G0_0_0_0_1_1 + 0.000201569264069271*G0_0_0_0_1_2 - 0.000974025974026008*G0_0_0_0_1_4 - 0.00531114718614736*G0_0_0_0_2_0 + 0.000201569264069271*G0_0_0_0_2_1 + 0.000533008658008674*G0_0_0_0_2_2 + 0.000508658008658024*G0_0_0_0_2_3 - 0.00305194805194815*G0_0_0_0_2_4 + 0.00134199134199138*G0_0_0_0_3_0 + 0.000508658008658024*G0_0_0_0_3_2 - 0.000735930735930766*G0_0_0_0_3_3 - 0.00073593073593076*G0_0_0_0_3_4 - 0.00272727272727282*G0_0_0_0_3_5 + 0.0233225108225116*G0_0_0_0_4_0 - 0.000974025974026007*G0_0_0_0_4_1 - 0.00305194805194815*G0_0_0_0_4_2 - 0.00073593073593076*G0_0_0_0_4_3 + 0.0206060606060613*G0_0_0_0_4_4 + 0.00190476190476198*G0_0_0_0_4_5 + 0.010119047619048*G0_0_0_0_5_0 - 0.00272727272727282*G0_0_0_0_5_3 + 0.00190476190476198*G0_0_0_0_5_4 - 0.0075324675324678*G0_0_0_0_5_5 - 0.00252435064935073*G0_0_0_1_0_0 - 0.000703463203463227*G0_0_0_1_0_1 + 0.000201569264069271*G0_0_0_1_0_2 - 0.000974025974026008*G0_0_0_1_0_4 - 0.000703463203463227*G0_0_0_1_1_0 + 0.0183441558441565*G0_0_0_1_1_1 - 0.00119047619047623*G0_0_0_1_1_2 + 0.0043019480519482*G0_0_0_1_1_3 + 0.000514069264069279*G0_0_0_1_1_4 + 0.0028409090909092*G0_0_0_1_1_5 + 0.000201569264069271*G0_0_0_1_2_0 - 0.00119047619047623*G0_0_0_1_2_1 - 0.000162337662337669*G0_0_0_1_2_2 + 0.000487012987013003*G0_0_0_1_2_3 + 0.000681818181818204*G0_0_0_1_2_4 + 0.0043019480519482*G0_0_0_1_3_1 + 0.000487012987013003*G0_0_0_1_3_2 + 0.00173160173160179*G0_0_0_1_3_3 - 0.00108225108225112*G0_0_0_1_3_4 - 0.000108225108225105*G0_0_0_1_3_5 - 0.000974025974026008*G0_0_0_1_4_0 + 0.000514069264069279*G0_0_0_1_4_1 + 0.000681818181818204*G0_0_0_1_4_2 - 0.00108225108225112*G0_0_0_1_4_3 - 0.00216450216450224*G0_0_0_1_4_4 - 0.00108225108225112*G0_0_0_1_4_5 + 0.0028409090909092*G0_0_0_1_5_1 - 0.000108225108225105*G0_0_0_1_5_3 - 0.00108225108225112*G0_0_0_1_5_4 + 0.00367965367965382*G0_0_0_1_5_5 - 0.00531114718614736*G0_0_0_2_0_0 + 0.000201569264069271*G0_0_0_2_0_1 + 0.000533008658008674*G0_0_0_2_0_2 + 0.000508658008658024*G0_0_0_2_0_3 - 0.00305194805194815*G0_0_0_2_0_4 + 0.000201569264069271*G0_0_0_2_1_0 - 0.00119047619047623*G0_0_0_2_1_1 - 0.000162337662337669*G0_0_0_2_1_2 + 0.000487012987013002*G0_0_0_2_1_3 + 0.000681818181818204*G0_0_0_2_1_4 + 0.000533008658008674*G0_0_0_2_2_0 - 0.000162337662337669*G0_0_0_2_2_1 + 0.00748376623376652*G0_0_0_2_2_2 + 0.000670995670995701*G0_0_0_2_2_3 + 0.00160173160173167*G0_0_0_2_2_4 + 0.000854978354978385*G0_0_0_2_2_5 + 0.000508658008658024*G0_0_0_2_3_0 + 0.000487012987013002*G0_0_0_2_3_1 + 0.000670995670995701*G0_0_0_2_3_2 - 0.00441558441558456*G0_0_0_2_3_3 - 0.00238095238095245*G0_0_0_2_3_4 - 0.00272727272727282*G0_0_0_2_3_5 - 0.00305194805194815*G0_0_0_2_4_0 + 0.000681818181818204*G0_0_0_2_4_1 + 0.00160173160173167*G0_0_0_2_4_2 - 0.00238095238095245*G0_0_0_2_4_3 - 0.0105627705627709*G0_0_0_2_4_4 - 0.00307359307359318*G0_0_0_2_4_5 + 0.000854978354978385*G0_0_0_2_5_2 - 0.00272727272727282*G0_0_0_2_5_3 - 0.00307359307359318*G0_0_0_2_5_4 - 0.00385281385281398*G0_0_0_2_5_5 + 0.00134199134199138*G0_0_0_3_0_0 + 0.000508658008658024*G0_0_0_3_0_2 - 0.000735930735930766*G0_0_0_3_0_3 - 0.00073593073593076*G0_0_0_3_0_4 - 0.00272727272727282*G0_0_0_3_0_5 + 0.0043019480519482*G0_0_0_3_1_1 + 0.000487012987013003*G0_0_0_3_1_2 + 0.00173160173160178*G0_0_0_3_1_3 - 0.00108225108225112*G0_0_0_3_1_4 - 0.000108225108225104*G0_0_0_3_1_5 + 0.000508658008658024*G0_0_0_3_2_0 + 0.000487012987013002*G0_0_0_3_2_1 + 0.000670995670995701*G0_0_0_3_2_2 - 0.00441558441558456*G0_0_0_3_2_3 - 0.00238095238095245*G0_0_0_3_2_4 - 0.00272727272727282*G0_0_0_3_2_5 - 0.000735930735930766*G0_0_0_3_3_0 + 0.00173160173160178*G0_0_0_3_3_1 - 0.00441558441558456*G0_0_0_3_3_2 - 0.0400000000000013*G0_0_0_3_3_3 + 0.00363636363636375*G0_0_0_3_3_4 + 0.00692640692640714*G0_0_0_3_3_5 - 0.00073593073593076*G0_0_0_3_4_0 - 0.00108225108225112*G0_0_0_3_4_1 - 0.00238095238095245*G0_0_0_3_4_2 + 0.00363636363636375*G0_0_0_3_4_3 + 0.00580086580086598*G0_0_0_3_4_4 + 0.00761904761904786*G0_0_0_3_4_5 - 0.00272727272727282*G0_0_0_3_5_0 - 0.000108225108225105*G0_0_0_3_5_1 - 0.00272727272727282*G0_0_0_3_5_2 + 0.00692640692640714*G0_0_0_3_5_3 + 0.00761904761904786*G0_0_0_3_5_4 + 0.0131601731601736*G0_0_0_3_5_5 + 0.0233225108225116*G0_0_0_4_0_0 - 0.000974025974026008*G0_0_0_4_0_1 - 0.00305194805194815*G0_0_0_4_0_2 - 0.00073593073593076*G0_0_0_4_0_3 + 0.0206060606060613*G0_0_0_4_0_4 + 0.00190476190476198*G0_0_0_4_0_5 - 0.000974025974026008*G0_0_0_4_1_0 + 0.000514069264069279*G0_0_0_4_1_1 + 0.000681818181818204*G0_0_0_4_1_2 - 0.00108225108225112*G0_0_0_4_1_3 - 0.00216450216450224*G0_0_0_4_1_4 - 0.00108225108225112*G0_0_0_4_1_5 - 0.00305194805194815*G0_0_0_4_2_0 + 0.000681818181818204*G0_0_0_4_2_1 + 0.00160173160173166*G0_0_0_4_2_2 - 0.00238095238095245*G0_0_0_4_2_3 - 0.0105627705627709*G0_0_0_4_2_4 - 0.00307359307359318*G0_0_0_4_2_5 - 0.00073593073593076*G0_0_0_4_3_0 - 0.00108225108225112*G0_0_0_4_3_1 - 0.00238095238095245*G0_0_0_4_3_2 + 0.00363636363636375*G0_0_0_4_3_3 + 0.00580086580086598*G0_0_0_4_3_4 + 0.00761904761904786*G0_0_0_4_3_5 + 0.0206060606060613*G0_0_0_4_4_0 - 0.00216450216450224*G0_0_0_4_4_1 - 0.0105627705627709*G0_0_0_4_4_2 + 0.00580086580086598*G0_0_0_4_4_3 + 0.0215584415584423*G0_0_0_4_4_4 + 0.0104761904761908*G0_0_0_4_4_5 + 0.00190476190476198*G0_0_0_4_5_0 - 0.00108225108225112*G0_0_0_4_5_1 - 0.00307359307359318*G0_0_0_4_5_2 + 0.00761904761904786*G0_0_0_4_5_3 + 0.0104761904761908*G0_0_0_4_5_4 + 0.00987012987013018*G0_0_0_4_5_5 + 0.010119047619048*G0_0_0_5_0_0 - 0.00272727272727282*G0_0_0_5_0_3 + 0.00190476190476198*G0_0_0_5_0_4 - 0.0075324675324678*G0_0_0_5_0_5 + 0.0028409090909092*G0_0_0_5_1_1 - 0.000108225108225105*G0_0_0_5_1_3 - 0.00108225108225112*G0_0_0_5_1_4 + 0.00367965367965382*G0_0_0_5_1_5 + 0.000854978354978385*G0_0_0_5_2_2 - 0.00272727272727282*G0_0_0_5_2_3 - 0.00307359307359318*G0_0_0_5_2_4 - 0.00385281385281398*G0_0_0_5_2_5 - 0.00272727272727282*G0_0_0_5_3_0 - 0.000108225108225105*G0_0_0_5_3_1 - 0.00272727272727282*G0_0_0_5_3_2 + 0.00692640692640714*G0_0_0_5_3_3 + 0.00761904761904786*G0_0_0_5_3_4 + 0.0131601731601736*G0_0_0_5_3_5 + 0.00190476190476198*G0_0_0_5_4_0 - 0.00108225108225112*G0_0_0_5_4_1 - 0.00307359307359318*G0_0_0_5_4_2 + 0.00761904761904786*G0_0_0_5_4_3 + 0.0104761904761908*G0_0_0_5_4_4 + 0.00987012987013018*G0_0_0_5_4_5 - 0.0075324675324678*G0_0_0_5_5_0 + 0.00367965367965383*G0_0_0_5_5_1 - 0.00385281385281398*G0_0_0_5_5_2 + 0.0131601731601736*G0_0_0_5_5_3 + 0.00987012987013019*G0_0_0_5_5_4 + 0.0161038961038966*G0_0_0_5_5_5 + 0.0668019480519503*G0_0_1_0_0_0 - 0.00252435064935073*G0_0_1_0_0_1 - 0.00531114718614736*G0_0_1_0_0_2 + 0.00134199134199138*G0_0_1_0_0_3 + 0.0233225108225116*G0_0_1_0_0_4 + 0.010119047619048*G0_0_1_0_0_5 - 0.00252435064935073*G0_0_1_0_1_0 - 0.000703463203463227*G0_0_1_0_1_1 + 0.000201569264069271*G0_0_1_0_1_2 - 0.000974025974026008*G0_0_1_0_1_4 - 0.00531114718614736*G0_0_1_0_2_0 + 0.000201569264069271*G0_0_1_0_2_1 + 0.000533008658008674*G0_0_1_0_2_2 + 0.000508658008658024*G0_0_1_0_2_3 - 0.00305194805194815*G0_0_1_0_2_4 + 0.00134199134199138*G0_0_1_0_3_0 + 0.000508658008658024*G0_0_1_0_3_2 - 0.000735930735930763*G0_0_1_0_3_3 - 0.000735930735930759*G0_0_1_0_3_4 - 0.00272727272727282*G0_0_1_0_3_5 + 0.0233225108225116*G0_0_1_0_4_0 - 0.000974025974026007*G0_0_1_0_4_1 - 0.00305194805194815*G0_0_1_0_4_2 - 0.000735930735930759*G0_0_1_0_4_3 + 0.0206060606060613*G0_0_1_0_4_4 + 0.00190476190476198*G0_0_1_0_4_5 + 0.010119047619048*G0_0_1_0_5_0 - 0.00272727272727282*G0_0_1_0_5_3 + 0.00190476190476198*G0_0_1_0_5_4 - 0.0075324675324678*G0_0_1_0_5_5 - 0.00252435064935073*G0_0_1_1_0_0 - 0.000703463203463227*G0_0_1_1_0_1 + 0.000201569264069271*G0_0_1_1_0_2 - 0.000974025974026008*G0_0_1_1_0_4 - 0.000703463203463227*G0_0_1_1_1_0 + 0.0183441558441565*G0_0_1_1_1_1 - 0.00119047619047623*G0_0_1_1_1_2 + 0.00430194805194819*G0_0_1_1_1_3 + 0.000514069264069279*G0_0_1_1_1_4 + 0.0028409090909092*G0_0_1_1_1_5 + 0.000201569264069271*G0_0_1_1_2_0 - 0.00119047619047623*G0_0_1_1_2_1 - 0.000162337662337669*G0_0_1_1_2_2 + 0.000487012987013003*G0_0_1_1_2_3 + 0.000681818181818204*G0_0_1_1_2_4 + 0.00430194805194819*G0_0_1_1_3_1 + 0.000487012987013004*G0_0_1_1_3_2 + 0.00173160173160178*G0_0_1_1_3_3 - 0.00108225108225112*G0_0_1_1_3_4 - 0.000108225108225105*G0_0_1_1_3_5 - 0.000974025974026008*G0_0_1_1_4_0 + 0.000514069264069279*G0_0_1_1_4_1 + 0.000681818181818204*G0_0_1_1_4_2 - 0.00108225108225112*G0_0_1_1_4_3 - 0.00216450216450224*G0_0_1_1_4_4 - 0.00108225108225112*G0_0_1_1_4_5 + 0.0028409090909092*G0_0_1_1_5_1 - 0.000108225108225105*G0_0_1_1_5_3 - 0.00108225108225112*G0_0_1_1_5_4 + 0.00367965367965383*G0_0_1_1_5_5 - 0.00531114718614736*G0_0_1_2_0_0 + 0.000201569264069271*G0_0_1_2_0_1 + 0.000533008658008674*G0_0_1_2_0_2 + 0.000508658008658024*G0_0_1_2_0_3 - 0.00305194805194815*G0_0_1_2_0_4 + 0.000201569264069271*G0_0_1_2_1_0 - 0.00119047619047623*G0_0_1_2_1_1 - 0.000162337662337669*G0_0_1_2_1_2 + 0.000487012987013004*G0_0_1_2_1_3 + 0.000681818181818204*G0_0_1_2_1_4 + 0.000533008658008674*G0_0_1_2_2_0 - 0.000162337662337669*G0_0_1_2_2_1 + 0.00748376623376652*G0_0_1_2_2_2 + 0.000670995670995699*G0_0_1_2_2_3 + 0.00160173160173166*G0_0_1_2_2_4 + 0.000854978354978384*G0_0_1_2_2_5 + 0.000508658008658024*G0_0_1_2_3_0 + 0.000487012987013004*G0_0_1_2_3_1 + 0.000670995670995699*G0_0_1_2_3_2 - 0.00441558441558456*G0_0_1_2_3_3 - 0.00238095238095246*G0_0_1_2_3_4 - 0.00272727272727282*G0_0_1_2_3_5 - 0.00305194805194815*G0_0_1_2_4_0 + 0.000681818181818204*G0_0_1_2_4_1 + 0.00160173160173166*G0_0_1_2_4_2 - 0.00238095238095246*G0_0_1_2_4_3 - 0.0105627705627709*G0_0_1_2_4_4 - 0.00307359307359318*G0_0_1_2_4_5 + 0.000854978354978384*G0_0_1_2_5_2 - 0.00272727272727282*G0_0_1_2_5_3 - 0.00307359307359318*G0_0_1_2_5_4 - 0.00385281385281398*G0_0_1_2_5_5 + 0.00134199134199138*G0_0_1_3_0_0 + 0.000508658008658024*G0_0_1_3_0_2 - 0.000735930735930763*G0_0_1_3_0_3 - 0.000735930735930759*G0_0_1_3_0_4 - 0.00272727272727282*G0_0_1_3_0_5 + 0.00430194805194819*G0_0_1_3_1_1 + 0.000487012987013003*G0_0_1_3_1_2 + 0.00173160173160178*G0_0_1_3_1_3 - 0.00108225108225112*G0_0_1_3_1_4 - 0.000108225108225105*G0_0_1_3_1_5 + 0.000508658008658024*G0_0_1_3_2_0 + 0.000487012987013003*G0_0_1_3_2_1 + 0.000670995670995699*G0_0_1_3_2_2 - 0.00441558441558456*G0_0_1_3_2_3 - 0.00238095238095246*G0_0_1_3_2_4 - 0.00272727272727282*G0_0_1_3_2_5 - 0.000735930735930763*G0_0_1_3_3_0 + 0.00173160173160178*G0_0_1_3_3_1 - 0.00441558441558456*G0_0_1_3_3_2 - 0.0400000000000014*G0_0_1_3_3_3 + 0.00363636363636374*G0_0_1_3_3_4 + 0.00692640692640714*G0_0_1_3_3_5 - 0.000735930735930759*G0_0_1_3_4_0 - 0.00108225108225112*G0_0_1_3_4_1 - 0.00238095238095246*G0_0_1_3_4_2 + 0.00363636363636374*G0_0_1_3_4_3 + 0.00580086580086597*G0_0_1_3_4_4 + 0.00761904761904786*G0_0_1_3_4_5 - 0.00272727272727282*G0_0_1_3_5_0 - 0.000108225108225105*G0_0_1_3_5_1 - 0.00272727272727282*G0_0_1_3_5_2 + 0.00692640692640714*G0_0_1_3_5_3 + 0.00761904761904786*G0_0_1_3_5_4 + 0.0131601731601736*G0_0_1_3_5_5 + 0.0233225108225116*G0_0_1_4_0_0 - 0.000974025974026008*G0_0_1_4_0_1 - 0.00305194805194815*G0_0_1_4_0_2 - 0.000735930735930759*G0_0_1_4_0_3 + 0.0206060606060613*G0_0_1_4_0_4 + 0.00190476190476198*G0_0_1_4_0_5 - 0.000974025974026008*G0_0_1_4_1_0 + 0.000514069264069279*G0_0_1_4_1_1 + 0.000681818181818204*G0_0_1_4_1_2 - 0.00108225108225112*G0_0_1_4_1_3 - 0.00216450216450224*G0_0_1_4_1_4 - 0.00108225108225111*G0_0_1_4_1_5 - 0.00305194805194815*G0_0_1_4_2_0 + 0.000681818181818204*G0_0_1_4_2_1 + 0.00160173160173166*G0_0_1_4_2_2 - 0.00238095238095245*G0_0_1_4_2_3 - 0.0105627705627709*G0_0_1_4_2_4 - 0.00307359307359318*G0_0_1_4_2_5 - 0.000735930735930759*G0_0_1_4_3_0 - 0.00108225108225112*G0_0_1_4_3_1 - 0.00238095238095246*G0_0_1_4_3_2 + 0.00363636363636374*G0_0_1_4_3_3 + 0.00580086580086597*G0_0_1_4_3_4 + 0.00761904761904786*G0_0_1_4_3_5 + 0.0206060606060613*G0_0_1_4_4_0 - 0.00216450216450224*G0_0_1_4_4_1 - 0.0105627705627709*G0_0_1_4_4_2 + 0.00580086580086597*G0_0_1_4_4_3 + 0.0215584415584423*G0_0_1_4_4_4 + 0.0104761904761908*G0_0_1_4_4_5 + 0.00190476190476198*G0_0_1_4_5_0 - 0.00108225108225111*G0_0_1_4_5_1 - 0.00307359307359318*G0_0_1_4_5_2 + 0.00761904761904786*G0_0_1_4_5_3 + 0.0104761904761908*G0_0_1_4_5_4 + 0.00987012987013018*G0_0_1_4_5_5 + 0.010119047619048*G0_0_1_5_0_0 - 0.00272727272727282*G0_0_1_5_0_3 + 0.00190476190476198*G0_0_1_5_0_4 - 0.0075324675324678*G0_0_1_5_0_5 + 0.0028409090909092*G0_0_1_5_1_1 - 0.000108225108225105*G0_0_1_5_1_3 - 0.00108225108225112*G0_0_1_5_1_4 + 0.00367965367965383*G0_0_1_5_1_5 + 0.000854978354978384*G0_0_1_5_2_2 - 0.00272727272727282*G0_0_1_5_2_3 - 0.00307359307359318*G0_0_1_5_2_4 - 0.00385281385281398*G0_0_1_5_2_5 - 0.00272727272727282*G0_0_1_5_3_0 - 0.000108225108225105*G0_0_1_5_3_1 - 0.00272727272727282*G0_0_1_5_3_2 + 0.00692640692640714*G0_0_1_5_3_3 + 0.00761904761904786*G0_0_1_5_3_4 + 0.0131601731601736*G0_0_1_5_3_5 + 0.00190476190476198*G0_0_1_5_4_0 - 0.00108225108225112*G0_0_1_5_4_1 - 0.00307359307359318*G0_0_1_5_4_2 + 0.00761904761904786*G0_0_1_5_4_3 + 0.0104761904761908*G0_0_1_5_4_4 + 0.00987012987013018*G0_0_1_5_4_5 - 0.0075324675324678*G0_0_1_5_5_0 + 0.00367965367965383*G0_0_1_5_5_1 - 0.00385281385281398*G0_0_1_5_5_2 + 0.0131601731601736*G0_0_1_5_5_3 + 0.00987012987013018*G0_0_1_5_5_4 + 0.0161038961038966*G0_0_1_5_5_5;
    A[14] = -A[16] - 0.00748376623376649*G0_0_1_0_0_0 - 0.000533008658008677*G0_0_1_0_0_1 + 0.000162337662337667*G0_0_1_0_0_2 - 0.000854978354978379*G0_0_1_0_0_3 - 0.000670995670995693*G0_0_1_0_0_4 - 0.00160173160173165*G0_0_1_0_0_5 - 0.000533008658008677*G0_0_1_0_1_0 + 0.00531114718614737*G0_0_1_0_1_1 - 0.000201569264069271*G0_0_1_0_1_2 - 0.000508658008658026*G0_0_1_0_1_4 + 0.00305194805194815*G0_0_1_0_1_5 + 0.000162337662337667*G0_0_1_0_2_0 - 0.000201569264069271*G0_0_1_0_2_1 + 0.00119047619047623*G0_0_1_0_2_2 - 0.000487012987012999*G0_0_1_0_2_4 - 0.000681818181818204*G0_0_1_0_2_5 - 0.000854978354978379*G0_0_1_0_3_0 + 0.00385281385281396*G0_0_1_0_3_3 + 0.00272727272727281*G0_0_1_0_3_4 + 0.00307359307359317*G0_0_1_0_3_5 - 0.000670995670995693*G0_0_1_0_4_0 - 0.000508658008658026*G0_0_1_0_4_1 - 0.000487012987012999*G0_0_1_0_4_2 + 0.00272727272727281*G0_0_1_0_4_3 + 0.00441558441558456*G0_0_1_0_4_4 + 0.00238095238095246*G0_0_1_0_4_5 - 0.00160173160173165*G0_0_1_0_5_0 + 0.00305194805194815*G0_0_1_0_5_1 - 0.000681818181818204*G0_0_1_0_5_2 + 0.00307359307359317*G0_0_1_0_5_3 + 0.00238095238095246*G0_0_1_0_5_4 + 0.0105627705627709*G0_0_1_0_5_5 - 0.000533008658008677*G0_0_1_1_0_0 + 0.00531114718614737*G0_0_1_1_0_1 - 0.000201569264069271*G0_0_1_1_0_2 - 0.000508658008658026*G0_0_1_1_0_4 + 0.00305194805194815*G0_0_1_1_0_5 + 0.00531114718614737*G0_0_1_1_1_0 - 0.0668019480519504*G0_0_1_1_1_1 + 0.00252435064935074*G0_0_1_1_1_2 - 0.010119047619048*G0_0_1_1_1_3 - 0.00134199134199138*G0_0_1_1_1_4 - 0.0233225108225117*G0_0_1_1_1_5 - 0.000201569264069271*G0_0_1_1_2_0 + 0.00252435064935074*G0_0_1_1_2_1 + 0.000703463203463229*G0_0_1_1_2_2 + 0.00097402597402601*G0_0_1_1_2_5 - 0.010119047619048*G0_0_1_1_3_1 + 0.00753246753246781*G0_0_1_1_3_3 + 0.00272727272727282*G0_0_1_1_3_4 - 0.00190476190476198*G0_0_1_1_3_5 - 0.000508658008658026*G0_0_1_1_4_0 - 0.00134199134199138*G0_0_1_1_4_1 + 0.00272727272727282*G0_0_1_1_4_3 + 0.000735930735930763*G0_0_1_1_4_4 + 0.000735930735930762*G0_0_1_1_4_5 + 0.00305194805194815*G0_0_1_1_5_0 - 0.0233225108225117*G0_0_1_1_5_1 + 0.00097402597402601*G0_0_1_1_5_2 - 0.00190476190476198*G0_0_1_1_5_3 + 0.000735930735930762*G0_0_1_1_5_4 - 0.0206060606060613*G0_0_1_1_5_5 + 0.000162337662337667*G0_0_1_2_0_0 - 0.000201569264069271*G0_0_1_2_0_1 + 0.00119047619047623*G0_0_1_2_0_2 - 0.000487012987012999*G0_0_1_2_0_4 - 0.000681818181818204*G0_0_1_2_0_5 - 0.000201569264069271*G0_0_1_2_1_0 + 0.00252435064935073*G0_0_1_2_1_1 + 0.000703463203463229*G0_0_1_2_1_2 + 0.00097402597402601*G0_0_1_2_1_5 + 0.00119047619047623*G0_0_1_2_2_0 + 0.000703463203463229*G0_0_1_2_2_1 - 0.0183441558441565*G0_0_1_2_2_2 - 0.0028409090909092*G0_0_1_2_2_3 - 0.00430194805194822*G0_0_1_2_2_4 - 0.000514069264069284*G0_0_1_2_2_5 - 0.0028409090909092*G0_0_1_2_3_2 - 0.00367965367965383*G0_0_1_2_3_3 + 0.000108225108225104*G0_0_1_2_3_4 + 0.00108225108225111*G0_0_1_2_3_5 - 0.000487012987012999*G0_0_1_2_4_0 - 0.00430194805194822*G0_0_1_2_4_2 + 0.000108225108225104*G0_0_1_2_4_3 - 0.0017316017316018*G0_0_1_2_4_4 + 0.00108225108225111*G0_0_1_2_4_5 - 0.000681818181818204*G0_0_1_2_5_0 + 0.00097402597402601*G0_0_1_2_5_1 - 0.000514069264069284*G0_0_1_2_5_2 + 0.00108225108225111*G0_0_1_2_5_3 + 0.00108225108225111*G0_0_1_2_5_4 + 0.00216450216450223*G0_0_1_2_5_5 - 0.000854978354978379*G0_0_1_3_0_0 + 0.00385281385281396*G0_0_1_3_0_3 + 0.00272727272727281*G0_0_1_3_0_4 + 0.00307359307359317*G0_0_1_3_0_5 - 0.010119047619048*G0_0_1_3_1_1 + 0.00753246753246781*G0_0_1_3_1_3 + 0.00272727272727282*G0_0_1_3_1_4 - 0.00190476190476198*G0_0_1_3_1_5 - 0.0028409090909092*G0_0_1_3_2_2 - 0.00367965367965383*G0_0_1_3_2_3 + 0.000108225108225104*G0_0_1_3_2_4 + 0.00108225108225111*G0_0_1_3_2_5 + 0.00385281385281396*G0_0_1_3_3_0 + 0.00753246753246781*G0_0_1_3_3_1 - 0.00367965367965383*G0_0_1_3_3_2 - 0.0161038961038965*G0_0_1_3_3_3 - 0.0131601731601736*G0_0_1_3_3_4 - 0.00987012987013017*G0_0_1_3_3_5 + 0.00272727272727281*G0_0_1_3_4_0 + 0.00272727272727282*G0_0_1_3_4_1 + 0.000108225108225104*G0_0_1_3_4_2 - 0.0131601731601736*G0_0_1_3_4_3 - 0.00692640692640715*G0_0_1_3_4_4 - 0.00761904761904786*G0_0_1_3_4_5 + 0.00307359307359317*G0_0_1_3_5_0 - 0.00190476190476198*G0_0_1_3_5_1 + 0.00108225108225111*G0_0_1_3_5_2 - 0.00987012987013017*G0_0_1_3_5_3 - 0.00761904761904786*G0_0_1_3_5_4 - 0.0104761904761908*G0_0_1_3_5_5 - 0.000670995670995693*G0_0_1_4_0_0 - 0.000508658008658026*G0_0_1_4_0_1 - 0.000487012987012999*G0_0_1_4_0_2 + 0.00272727272727281*G0_0_1_4_0_3 + 0.00441558441558456*G0_0_1_4_0_4 + 0.00238095238095246*G0_0_1_4_0_5 - 0.000508658008658026*G0_0_1_4_1_0 - 0.00134199134199138*G0_0_1_4_1_1 + 0.00272727272727282*G0_0_1_4_1_3 + 0.000735930735930763*G0_0_1_4_1_4 + 0.000735930735930762*G0_0_1_4_1_5 - 0.000487012987012999*G0_0_1_4_2_0 - 0.00430194805194822*G0_0_1_4_2_2 + 0.000108225108225104*G0_0_1_4_2_3 - 0.0017316017316018*G0_0_1_4_2_4 + 0.00108225108225111*G0_0_1_4_2_5 + 0.00272727272727281*G0_0_1_4_3_0 + 0.00272727272727282*G0_0_1_4_3_1 + 0.000108225108225104*G0_0_1_4_3_2 - 0.0131601731601736*G0_0_1_4_3_3 - 0.00692640692640715*G0_0_1_4_3_4 - 0.00761904761904786*G0_0_1_4_3_5 + 0.00441558441558456*G0_0_1_4_4_0 + 0.000735930735930763*G0_0_1_4_4_1 - 0.0017316017316018*G0_0_1_4_4_2 - 0.00692640692640715*G0_0_1_4_4_3 + 0.0400000000000012*G0_0_1_4_4_4 - 0.00363636363636375*G0_0_1_4_4_5 + 0.00238095238095246*G0_0_1_4_5_0 + 0.000735930735930762*G0_0_1_4_5_1 + 0.00108225108225111*G0_0_1_4_5_2 - 0.00761904761904786*G0_0_1_4_5_3 - 0.00363636363636375*G0_0_1_4_5_4 - 0.00580086580086598*G0_0_1_4_5_5 - 0.00160173160173165*G0_0_1_5_0_0 + 0.00305194805194815*G0_0_1_5_0_1 - 0.000681818181818204*G0_0_1_5_0_2 + 0.00307359307359317*G0_0_1_5_0_3 + 0.00238095238095246*G0_0_1_5_0_4 + 0.0105627705627709*G0_0_1_5_0_5 + 0.00305194805194815*G0_0_1_5_1_0 - 0.0233225108225117*G0_0_1_5_1_1 + 0.00097402597402601*G0_0_1_5_1_2 - 0.00190476190476198*G0_0_1_5_1_3 + 0.000735930735930762*G0_0_1_5_1_4 - 0.0206060606060613*G0_0_1_5_1_5 - 0.000681818181818204*G0_0_1_5_2_0 + 0.00097402597402601*G0_0_1_5_2_1 - 0.000514069264069284*G0_0_1_5_2_2 + 0.00108225108225111*G0_0_1_5_2_3 + 0.00108225108225111*G0_0_1_5_2_4 + 0.00216450216450223*G0_0_1_5_2_5 + 0.00307359307359317*G0_0_1_5_3_0 - 0.00190476190476198*G0_0_1_5_3_1 + 0.00108225108225111*G0_0_1_5_3_2 - 0.00987012987013017*G0_0_1_5_3_3 - 0.00761904761904786*G0_0_1_5_3_4 - 0.0104761904761908*G0_0_1_5_3_5 + 0.00238095238095246*G0_0_1_5_4_0 + 0.000735930735930762*G0_0_1_5_4_1 + 0.00108225108225111*G0_0_1_5_4_2 - 0.00761904761904786*G0_0_1_5_4_3 - 0.00363636363636375*G0_0_1_5_4_4 - 0.00580086580086598*G0_0_1_5_4_5 + 0.0105627705627709*G0_0_1_5_5_0 - 0.0206060606060613*G0_0_1_5_5_1 + 0.00216450216450223*G0_0_1_5_5_2 - 0.0104761904761908*G0_0_1_5_5_3 - 0.00580086580086598*G0_0_1_5_5_4 - 0.0215584415584422*G0_0_1_5_5_5;
    A[23] = -A[28] - 0.00748376623376648*G0_1_0_0_0_0 + 0.000162337662337666*G0_1_0_0_0_1 - 0.000533008658008677*G0_1_0_0_0_2 - 0.00085497835497838*G0_1_0_0_0_3 - 0.00160173160173165*G0_1_0_0_0_4 - 0.000670995670995687*G0_1_0_0_0_5 + 0.000162337662337666*G0_1_0_0_1_0 + 0.00119047619047623*G0_1_0_0_1_1 - 0.000201569264069271*G0_1_0_0_1_2 - 0.000681818181818205*G0_1_0_0_1_4 - 0.000487012987013004*G0_1_0_0_1_5 - 0.000533008658008677*G0_1_0_0_2_0 - 0.000201569264069271*G0_1_0_0_2_1 + 0.00531114718614737*G0_1_0_0_2_2 + 0.00305194805194816*G0_1_0_0_2_4 - 0.000508658008658025*G0_1_0_0_2_5 - 0.00085497835497838*G0_1_0_0_3_0 + 0.00385281385281397*G0_1_0_0_3_3 + 0.00307359307359317*G0_1_0_0_3_4 + 0.00272727272727282*G0_1_0_0_3_5 - 0.00160173160173165*G0_1_0_0_4_0 - 0.000681818181818205*G0_1_0_0_4_1 + 0.00305194805194816*G0_1_0_0_4_2 + 0.00307359307359317*G0_1_0_0_4_3 + 0.0105627705627709*G0_1_0_0_4_4 + 0.00238095238095246*G0_1_0_0_4_5 - 0.000670995670995687*G0_1_0_0_5_0 - 0.000487012987013004*G0_1_0_0_5_1 - 0.000508658008658025*G0_1_0_0_5_2 + 0.00272727272727282*G0_1_0_0_5_3 + 0.00238095238095246*G0_1_0_0_5_4 + 0.00441558441558458*G0_1_0_0_5_5 + 0.000162337662337666*G0_1_0_1_0_0 + 0.00119047619047623*G0_1_0_1_0_1 - 0.000201569264069271*G0_1_0_1_0_2 - 0.000681818181818205*G0_1_0_1_0_4 - 0.000487012987013004*G0_1_0_1_0_5 + 0.00119047619047623*G0_1_0_1_1_0 - 0.0183441558441565*G0_1_0_1_1_1 + 0.000703463203463227*G0_1_0_1_1_2 - 0.00284090909090919*G0_1_0_1_1_3 - 0.000514069264069279*G0_1_0_1_1_4 - 0.00430194805194821*G0_1_0_1_1_5 - 0.000201569264069271*G0_1_0_1_2_0 + 0.000703463203463227*G0_1_0_1_2_1 + 0.00252435064935074*G0_1_0_1_2_2 + 0.000974025974026008*G0_1_0_1_2_4 - 0.00284090909090919*G0_1_0_1_3_1 - 0.00367965367965381*G0_1_0_1_3_3 + 0.00108225108225112*G0_1_0_1_3_4 + 0.000108225108225108*G0_1_0_1_3_5 - 0.000681818181818205*G0_1_0_1_4_0 - 0.000514069264069279*G0_1_0_1_4_1 + 0.000974025974026008*G0_1_0_1_4_2 + 0.00108225108225112*G0_1_0_1_4_3 + 0.00216450216450224*G0_1_0_1_4_4 + 0.00108225108225112*G0_1_0_1_4_5 - 0.000487012987013004*G0_1_0_1_5_0 - 0.00430194805194821*G0_1_0_1_5_1 + 0.000108225108225109*G0_1_0_1_5_3 + 0.00108225108225112*G0_1_0_1_5_4 - 0.00173160173160179*G0_1_0_1_5_5 - 0.000533008658008677*G0_1_0_2_0_0 - 0.000201569264069271*G0_1_0_2_0_1 + 0.00531114718614737*G0_1_0_2_0_2 + 0.00305194805194816*G0_1_0_2_0_4 - 0.000508658008658025*G0_1_0_2_0_5 - 0.000201569264069271*G0_1_0_2_1_0 + 0.000703463203463227*G0_1_0_2_1_1 + 0.00252435064935074*G0_1_0_2_1_2 + 0.000974025974026008*G0_1_0_2_1_4 + 0.00531114718614737*G0_1_0_2_2_0 + 0.00252435064935074*G0_1_0_2_2_1 - 0.0668019480519504*G0_1_0_2_2_2 - 0.010119047619048*G0_1_0_2_2_3 - 0.0233225108225116*G0_1_0_2_2_4 - 0.0013419913419914*G0_1_0_2_2_5 - 0.010119047619048*G0_1_0_2_3_2 + 0.00753246753246777*G0_1_0_2_3_3 - 0.00190476190476198*G0_1_0_2_3_4 + 0.00272727272727282*G0_1_0_2_3_5 + 0.00305194805194816*G0_1_0_2_4_0 + 0.000974025974026008*G0_1_0_2_4_1 - 0.0233225108225116*G0_1_0_2_4_2 - 0.00190476190476198*G0_1_0_2_4_3 - 0.0206060606060613*G0_1_0_2_4_4 + 0.000735930735930755*G0_1_0_2_4_5 - 0.000508658008658024*G0_1_0_2_5_0 - 0.0013419913419914*G0_1_0_2_5_2 + 0.00272727272727282*G0_1_0_2_5_3 + 0.000735930735930755*G0_1_0_2_5_4 + 0.000735930735930762*G0_1_0_2_5_5 - 0.00085497835497838*G0_1_0_3_0_0 + 0.00385281385281397*G0_1_0_3_0_3 + 0.00307359307359317*G0_1_0_3_0_4 + 0.00272727272727282*G0_1_0_3_0_5 - 0.00284090909090919*G0_1_0_3_1_1 - 0.00367965367965381*G0_1_0_3_1_3 + 0.00108225108225112*G0_1_0_3_1_4 + 0.000108225108225108*G0_1_0_3_1_5 - 0.010119047619048*G0_1_0_3_2_2 + 0.00753246753246777*G0_1_0_3_2_3 - 0.00190476190476198*G0_1_0_3_2_4 + 0.00272727272727282*G0_1_0_3_2_5 + 0.00385281385281397*G0_1_0_3_3_0 - 0.00367965367965381*G0_1_0_3_3_1 + 0.00753246753246777*G0_1_0_3_3_2 - 0.0161038961038966*G0_1_0_3_3_3 - 0.00987012987013019*G0_1_0_3_3_4 - 0.0131601731601736*G0_1_0_3_3_5 + 0.00307359307359317*G0_1_0_3_4_0 + 0.00108225108225112*G0_1_0_3_4_1 - 0.00190476190476198*G0_1_0_3_4_2 - 0.00987012987013019*G0_1_0_3_4_3 - 0.0104761904761908*G0_1_0_3_4_4 - 0.00761904761904787*G0_1_0_3_4_5 + 0.00272727272727282*G0_1_0_3_5_0 + 0.000108225108225108*G0_1_0_3_5_1 + 0.00272727272727282*G0_1_0_3_5_2 - 0.0131601731601736*G0_1_0_3_5_3 - 0.00761904761904787*G0_1_0_3_5_4 - 0.00692640692640716*G0_1_0_3_5_5 - 0.00160173160173165*G0_1_0_4_0_0 - 0.000681818181818205*G0_1_0_4_0_1 + 0.00305194805194816*G0_1_0_4_0_2 + 0.00307359307359317*G0_1_0_4_0_3 + 0.0105627705627709*G0_1_0_4_0_4 + 0.00238095238095246*G0_1_0_4_0_5 - 0.000681818181818205*G0_1_0_4_1_0 - 0.000514069264069279*G0_1_0_4_1_1 + 0.000974025974026008*G0_1_0_4_1_2 + 0.00108225108225112*G0_1_0_4_1_3 + 0.00216450216450224*G0_1_0_4_1_4 + 0.00108225108225112*G0_1_0_4_1_5 + 0.00305194805194816*G0_1_0_4_2_0 + 0.000974025974026008*G0_1_0_4_2_1 - 0.0233225108225116*G0_1_0_4_2_2 - 0.00190476190476198*G0_1_0_4_2_3 - 0.0206060606060613*G0_1_0_4_2_4 + 0.000735930735930755*G0_1_0_4_2_5 + 0.00307359307359317*G0_1_0_4_3_0 + 0.00108225108225112*G0_1_0_4_3_1 - 0.00190476190476198*G0_1_0_4_3_2 - 0.00987012987013019*G0_1_0_4_3_3 - 0.0104761904761908*G0_1_0_4_3_4 - 0.00761904761904787*G0_1_0_4_3_5 + 0.0105627705627709*G0_1_0_4_4_0 + 0.00216450216450224*G0_1_0_4_4_1 - 0.0206060606060613*G0_1_0_4_4_2 - 0.0104761904761908*G0_1_0_4_4_3 - 0.0215584415584423*G0_1_0_4_4_4 - 0.005800865800866*G0_1_0_4_4_5 + 0.00238095238095246*G0_1_0_4_5_0 + 0.00108225108225112*G0_1_0_4_5_1 + 0.000735930735930755*G0_1_0_4_5_2 - 0.00761904761904787*G0_1_0_4_5_3 - 0.005800865800866*G0_1_0_4_5_4 - 0.00363636363636376*G0_1_0_4_5_5 - 0.000670995670995687*G0_1_0_5_0_0 - 0.000487012987013004*G0_1_0_5_0_1 - 0.000508658008658025*G0_1_0_5_0_2 + 0.00272727272727282*G0_1_0_5_0_3 + 0.00238095238095246*G0_1_0_5_0_4 + 0.00441558441558458*G0_1_0_5_0_5 - 0.000487012987013004*G0_1_0_5_1_0 - 0.00430194805194821*G0_1_0_5_1_1 + 0.000108225108225109*G0_1_0_5_1_3 + 0.00108225108225112*G0_1_0_5_1_4 - 0.00173160173160179*G0_1_0_5_1_5 - 0.000508658008658024*G0_1_0_5_2_0 - 0.0013419913419914*G0_1_0_5_2_2 + 0.00272727272727282*G0_1_0_5_2_3 + 0.000735930735930755*G0_1_0_5_2_4 + 0.000735930735930762*G0_1_0_5_2_5 + 0.00272727272727282*G0_1_0_5_3_0 + 0.000108225108225108*G0_1_0_5_3_1 + 0.00272727272727282*G0_1_0_5_3_2 - 0.0131601731601736*G0_1_0_5_3_3 - 0.00761904761904787*G0_1_0_5_3_4 - 0.00692640692640716*G0_1_0_5_3_5 + 0.00238095238095246*G0_1_0_5_4_0 + 0.00108225108225112*G0_1_0_5_4_1 + 0.000735930735930755*G0_1_0_5_4_2 - 0.00761904761904787*G0_1_0_5_4_3 - 0.005800865800866*G0_1_0_5_4_4 - 0.00363636363636376*G0_1_0_5_4_5 + 0.00441558441558458*G0_1_0_5_5_0 - 0.00173160173160179*G0_1_0_5_5_1 + 0.000735930735930762*G0_1_0_5_5_2 - 0.00692640692640716*G0_1_0_5_5_3 - 0.00363636363636376*G0_1_0_5_5_4 + 0.0400000000000013*G0_1_0_5_5_5;
    A[25] = -A[23] - 0.00172889610389617*G0_1_0_0_0_0 + 0.000186688311688318*G0_1_0_0_0_1 - 0.000616883116883137*G0_1_0_0_0_2 - 0.000454545454545469*G0_1_0_0_0_3 - 0.000194805194805198*G0_1_0_0_0_4 - 0.000941558441558476*G0_1_0_0_0_5 + 0.000186688311688318*G0_1_0_0_1_0 - 0.000186688311688316*G0_1_0_0_1_1 + 0.000454545454545468*G0_1_0_0_1_3 - 0.00045454545454547*G0_1_0_0_1_4 - 0.000616883116883137*G0_1_0_0_2_0 + 0.00219155844155851*G0_1_0_0_2_2 - 0.000909090909090935*G0_1_0_0_2_3 + 0.00220779220779228*G0_1_0_0_2_4 - 0.000194805194805201*G0_1_0_0_2_5 - 0.000454545454545468*G0_1_0_0_3_0 + 0.000454545454545468*G0_1_0_0_3_1 - 0.000909090909090935*G0_1_0_0_3_2 + 0.00207792207792215*G0_1_0_0_3_3 + 0.00181818181818188*G0_1_0_0_3_4 + 0.00129870129870134*G0_1_0_0_3_5 - 0.000194805194805198*G0_1_0_0_4_0 - 0.00045454545454547*G0_1_0_0_4_1 + 0.00220779220779228*G0_1_0_0_4_2 + 0.00181818181818188*G0_1_0_0_4_3 + 0.0124675324675329*G0_1_0_0_4_4 + 0.00129870129870134*G0_1_0_0_4_5 - 0.000941558441558476*G0_1_0_0_5_0 - 0.000194805194805201*G0_1_0_0_5_2 + 0.00129870129870134*G0_1_0_0_5_3 + 0.00129870129870134*G0_1_0_0_5_4 - 0.000389610389610403*G0_1_0_0_5_5 + 0.000186688311688318*G0_1_0_1_0_0 - 0.000186688311688316*G0_1_0_1_0_1 + 0.000454545454545468*G0_1_0_1_0_3 - 0.00045454545454547*G0_1_0_1_0_4 - 0.000186688311688316*G0_1_0_1_1_0 + 0.00172889610389614*G0_1_0_1_1_1 + 0.000616883116883139*G0_1_0_1_1_2 + 0.000194805194805194*G0_1_0_1_1_3 + 0.000454545454545469*G0_1_0_1_1_4 + 0.000941558441558469*G0_1_0_1_1_5 + 0.000616883116883139*G0_1_0_1_2_1 - 0.00219155844155852*G0_1_0_1_2_2 - 0.00220779220779228*G0_1_0_1_2_3 + 0.000909090909090939*G0_1_0_1_2_4 + 0.000194805194805202*G0_1_0_1_2_5 + 0.000454545454545468*G0_1_0_1_3_0 + 0.000194805194805194*G0_1_0_1_3_1 - 0.00220779220779228*G0_1_0_1_3_2 - 0.0124675324675329*G0_1_0_1_3_3 - 0.00181818181818188*G0_1_0_1_3_4 - 0.00129870129870135*G0_1_0_1_3_5 - 0.00045454545454547*G0_1_0_1_4_0 + 0.000454545454545469*G0_1_0_1_4_1 + 0.000909090909090939*G0_1_0_1_4_2 - 0.00181818181818188*G0_1_0_1_4_3 - 0.00207792207792215*G0_1_0_1_4_4 - 0.00129870129870135*G0_1_0_1_4_5 + 0.000941558441558469*G0_1_0_1_5_1 + 0.000194805194805202*G0_1_0_1_5_2 - 0.00129870129870135*G0_1_0_1_5_3 - 0.00129870129870134*G0_1_0_1_5_4 + 0.000389610389610396*G0_1_0_1_5_5 - 0.000616883116883137*G0_1_0_2_0_0 + 0.00219155844155852*G0_1_0_2_0_2 - 0.000909090909090935*G0_1_0_2_0_3 + 0.00220779220779228*G0_1_0_2_0_4 - 0.000194805194805201*G0_1_0_2_0_5 + 0.000616883116883139*G0_1_0_2_1_1 - 0.00219155844155852*G0_1_0_2_1_2 - 0.00220779220779228*G0_1_0_2_1_3 + 0.000909090909090939*G0_1_0_2_1_4 + 0.000194805194805202*G0_1_0_2_1_5 + 0.00219155844155852*G0_1_0_2_2_0 - 0.00219155844155852*G0_1_0_2_2_1 + 0.0100649350649354*G0_1_0_2_2_3 - 0.0100649350649354*G0_1_0_2_2_4 - 0.000909090909090935*G0_1_0_2_3_0 - 0.00220779220779228*G0_1_0_2_3_1 + 0.0100649350649354*G0_1_0_2_3_2 + 0.0233766233766242*G0_1_0_2_3_3 + 0.00181818181818188*G0_1_0_2_3_5 + 0.00220779220779228*G0_1_0_2_4_0 + 0.000909090909090939*G0_1_0_2_4_1 - 0.0100649350649354*G0_1_0_2_4_2 - 0.0233766233766241*G0_1_0_2_4_4 - 0.00181818181818188*G0_1_0_2_4_5 - 0.000194805194805201*G0_1_0_2_5_0 + 0.000194805194805202*G0_1_0_2_5_1 + 0.00181818181818188*G0_1_0_2_5_3 - 0.00181818181818188*G0_1_0_2_5_4 - 0.000454545454545468*G0_1_0_3_0_0 + 0.000454545454545468*G0_1_0_3_0_1 - 0.000909090909090935*G0_1_0_3_0_2 + 0.00207792207792214*G0_1_0_3_0_3 + 0.00181818181818188*G0_1_0_3_0_4 + 0.00129870129870134*G0_1_0_3_0_5 + 0.000454545454545468*G0_1_0_3_1_0 + 0.000194805194805194*G0_1_0_3_1_1 - 0.00220779220779228*G0_1_0_3_1_2 - 0.0124675324675329*G0_1_0_3_1_3 - 0.00181818181818188*G0_1_0_3_1_4 - 0.00129870129870135*G0_1_0_3_1_5 - 0.000909090909090935*G0_1_0_3_2_0 - 0.00220779220779228*G0_1_0_3_2_1 + 0.0100649350649354*G0_1_0_3_2_2 + 0.0233766233766242*G0_1_0_3_2_3 + 0.00181818181818188*G0_1_0_3_2_5 + 0.00207792207792214*G0_1_0_3_3_0 - 0.0124675324675329*G0_1_0_3_3_1 + 0.0233766233766242*G0_1_0_3_3_2 - 0.00467532467532478*G0_1_0_3_3_3 - 0.000519480519480531*G0_1_0_3_3_4 - 0.00779220779220804*G0_1_0_3_3_5 + 0.00181818181818188*G0_1_0_3_4_0 - 0.00181818181818188*G0_1_0_3_4_1 - 0.000519480519480531*G0_1_0_3_4_3 + 0.000519480519480538*G0_1_0_3_4_4 + 0.00129870129870134*G0_1_0_3_5_0 - 0.00129870129870135*G0_1_0_3_5_1 + 0.00181818181818188*G0_1_0_3_5_2 - 0.00779220779220804*G0_1_0_3_5_3 - 0.00259740259740269*G0_1_0_3_5_5 - 0.000194805194805198*G0_1_0_4_0_0 - 0.00045454545454547*G0_1_0_4_0_1 + 0.00220779220779228*G0_1_0_4_0_2 + 0.00181818181818188*G0_1_0_4_0_3 + 0.0124675324675329*G0_1_0_4_0_4 + 0.00129870129870134*G0_1_0_4_0_5 - 0.00045454545454547*G0_1_0_4_1_0 + 0.000454545454545469*G0_1_0_4_1_1 + 0.000909090909090939*G0_1_0_4_1_2 - 0.00181818181818188*G0_1_0_4_1_3 - 0.00207792207792215*G0_1_0_4_1_4 - 0.00129870129870135*G0_1_0_4_1_5 + 0.00220779220779228*G0_1_0_4_2_0 + 0.000909090909090939*G0_1_0_4_2_1 - 0.0100649350649354*G0_1_0_4_2_2 - 0.0233766233766241*G0_1_0_4_2_4 - 0.00181818181818188*G0_1_0_4_2_5 + 0.00181818181818188*G0_1_0_4_3_0 - 0.00181818181818188*G0_1_0_4_3_1 - 0.000519480519480531*G0_1_0_4_3_3 + 0.000519480519480538*G0_1_0_4_3_4 + 0.0124675324675329*G0_1_0_4_4_0 - 0.00207792207792215*G0_1_0_4_4_1 - 0.0233766233766241*G0_1_0_4_4_2 + 0.000519480519480538*G0_1_0_4_4_3 + 0.00467532467532487*G0_1_0_4_4_4 + 0.00779220779220806*G0_1_0_4_4_5 + 0.00129870129870134*G0_1_0_4_5_0 - 0.00129870129870135*G0_1_0_4_5_1 - 0.00181818181818188*G0_1_0_4_5_2 + 0.00779220779220806*G0_1_0_4_5_4 + 0.00259740259740269*G0_1_0_4_5_5 - 0.000941558441558476*G0_1_0_5_0_0 - 0.000194805194805201*G0_1_0_5_0_2 + 0.00129870129870134*G0_1_0_5_0_3 + 0.00129870129870134*G0_1_0_5_0_4 - 0.000389610389610403*G0_1_0_5_0_5 + 0.000941558441558469*G0_1_0_5_1_1 + 0.000194805194805202*G0_1_0_5_1_2 - 0.00129870129870135*G0_1_0_5_1_3 - 0.00129870129870134*G0_1_0_5_1_4 + 0.000389610389610396*G0_1_0_5_1_5 - 0.000194805194805201*G0_1_0_5_2_0 + 0.000194805194805202*G0_1_0_5_2_1 + 0.00181818181818188*G0_1_0_5_2_3 - 0.00181818181818188*G0_1_0_5_2_4 + 0.00129870129870134*G0_1_0_5_3_0 - 0.00129870129870135*G0_1_0_5_3_1 + 0.00181818181818188*G0_1_0_5_3_2 - 0.00779220779220804*G0_1_0_5_3_3 - 0.00259740259740269*G0_1_0_5_3_5 + 0.00129870129870134*G0_1_0_5_4_0 - 0.00129870129870135*G0_1_0_5_4_1 - 0.00181818181818188*G0_1_0_5_4_2 + 0.00779220779220805*G0_1_0_5_4_4 + 0.00259740259740269*G0_1_0_5_4_5 - 0.000389610389610403*G0_1_0_5_5_0 + 0.000389610389610396*G0_1_0_5_5_1 - 0.00259740259740269*G0_1_0_5_5_3 + 0.00259740259740269*G0_1_0_5_5_4 + 0.0226379870129878*G0_1_1_0_0_0 - 0.00151515151515157*G0_1_1_0_0_1 - 0.000965909090909123*G0_1_1_0_0_2 + 0.000346320346320355*G0_1_1_0_0_3 + 0.00325757575757587*G0_1_1_0_0_4 + 0.00891774891774922*G0_1_1_0_0_5 - 0.00151515151515157*G0_1_1_0_1_0 - 0.00170183982683988*G0_1_1_0_1_1 + 0.000273268398268407*G0_1_1_0_1_2 - 0.000411255411255424*G0_1_1_0_1_4 - 0.00311688311688322*G0_1_1_0_1_5 - 0.000965909090909122*G0_1_1_0_2_0 + 0.000273268398268407*G0_1_1_0_2_1 - 0.00184523809523816*G0_1_1_0_2_2 - 0.000790043290043316*G0_1_1_0_2_3 + 0.000194805194805194*G0_1_1_0_2_4 - 0.00025974025974027*G0_1_1_0_2_5 + 0.000346320346320355*G0_1_1_0_3_0 - 0.000790043290043316*G0_1_1_0_3_2 + 0.000129870129870134*G0_1_1_0_3_4 - 0.000173160173160177*G0_1_1_0_3_5 + 0.00325757575757587*G0_1_1_0_4_0 - 0.000411255411255424*G0_1_1_0_4_1 + 0.000194805194805194*G0_1_1_0_4_2 + 0.000129870129870134*G0_1_1_0_4_3 + 0.00441558441558455*G0_1_1_0_4_4 + 0.00134199134199139*G0_1_1_0_4_5 + 0.00891774891774922*G0_1_1_0_5_0 - 0.00311688311688322*G0_1_1_0_5_1 - 0.00025974025974027*G0_1_1_0_5_2 - 0.000173160173160177*G0_1_1_0_5_3 + 0.00134199134199139*G0_1_1_0_5_4 + 0.0047186147186149*G0_1_1_0_5_5 - 0.00151515151515157*G0_1_1_1_0_0 - 0.00170183982683988*G0_1_1_1_0_1 + 0.000273268398268407*G0_1_1_1_0_2 - 0.000411255411255424*G0_1_1_1_0_4 - 0.00311688311688322*G0_1_1_1_0_5 - 0.00170183982683988*G0_1_1_1_1_0 + 0.0243668831168839*G0_1_1_1_1_1 - 0.000349025974025985*G0_1_1_1_1_2 + 0.00345238095238106*G0_1_1_1_1_3 + 0.000800865800865824*G0_1_1_1_1_4 + 0.00985930735930771*G0_1_1_1_1_5 + 0.000273268398268407*G0_1_1_1_2_0 - 0.000349025974025985*G0_1_1_1_2_1 - 0.00403679653679668*G0_1_1_1_2_2 - 0.00201298701298708*G0_1_1_1_2_3 + 0.000119047619047621*G0_1_1_1_2_4 + 0.00345238095238106*G0_1_1_1_3_1 - 0.00201298701298708*G0_1_1_1_3_2 - 0.00805194805194834*G0_1_1_1_3_3 - 0.00168831168831175*G0_1_1_1_3_4 - 0.000411255411255424*G0_1_1_1_4_0 + 0.000800865800865824*G0_1_1_1_4_1 + 0.000119047619047621*G0_1_1_1_4_2 - 0.00168831168831175*G0_1_1_1_4_3 - 0.00199134199134206*G0_1_1_1_4_4 - 0.00147186147186152*G0_1_1_1_4_5 - 0.00311688311688322*G0_1_1_1_5_0 + 0.00985930735930771*G0_1_1_1_5_1 - 0.00147186147186152*G0_1_1_1_5_4 + 0.00510822510822529*G0_1_1_1_5_5 - 0.000965909090909122*G0_1_1_2_0_0 + 0.000273268398268407*G0_1_1_2_0_1 - 0.00184523809523816*G0_1_1_2_0_2 - 0.000790043290043316*G0_1_1_2_0_3 + 0.000194805194805194*G0_1_1_2_0_4 - 0.00025974025974027*G0_1_1_2_0_5 + 0.000273268398268407*G0_1_1_2_1_0 - 0.000349025974025985*G0_1_1_2_1_1 - 0.00403679653679668*G0_1_1_2_1_2 - 0.00201298701298708*G0_1_1_2_1_3 + 0.000119047619047621*G0_1_1_2_1_4 - 0.00184523809523816*G0_1_1_2_2_0 - 0.00403679653679668*G0_1_1_2_2_1 + 0.0581168831168852*G0_1_1_2_2_2 + 0.0173701298701305*G0_1_1_2_2_3 + 0.0073051948051951*G0_1_1_2_2_4 + 0.000768398268398305*G0_1_1_2_2_5 - 0.000790043290043316*G0_1_1_2_3_0 - 0.00201298701298708*G0_1_1_2_3_1 + 0.0173701298701305*G0_1_1_2_3_2 + 0.0161904761904768*G0_1_1_2_3_3 + 0.0013419913419914*G0_1_1_2_3_4 + 0.000194805194805194*G0_1_1_2_4_0 + 0.000119047619047621*G0_1_1_2_4_1 + 0.0073051948051951*G0_1_1_2_4_2 + 0.0013419913419914*G0_1_1_2_4_3 - 0.00718614718614739*G0_1_1_2_4_4 - 0.00177489177489183*G0_1_1_2_4_5 - 0.00025974025974027*G0_1_1_2_5_0 + 0.000768398268398305*G0_1_1_2_5_2 - 0.00177489177489183*G0_1_1_2_5_4 - 0.00264069264069273*G0_1_1_2_5_5 + 0.000346320346320355*G0_1_1_3_0_0 - 0.000790043290043316*G0_1_1_3_0_2 + 0.000129870129870134*G0_1_1_3_0_4 - 0.000173160173160177*G0_1_1_3_0_5 + 0.00345238095238106*G0_1_1_3_1_1 - 0.00201298701298708*G0_1_1_3_1_2 - 0.00805194805194834*G0_1_1_3_1_3 - 0.00168831168831175*G0_1_1_3_1_4 - 0.000790043290043316*G0_1_1_3_2_0 - 0.00201298701298708*G0_1_1_3_2_1 + 0.0173701298701305*G0_1_1_3_2_2 + 0.0161904761904768*G0_1_1_3_2_3 + 0.0013419913419914*G0_1_1_3_2_4 - 0.00805194805194834*G0_1_1_3_3_1 + 0.0161904761904768*G0_1_1_3_3_2 + 0.000259740259740279*G0_1_1_3_3_3 + 0.00320346320346331*G0_1_1_3_3_4 - 0.000259740259740276*G0_1_1_3_3_5 + 0.000129870129870134*G0_1_1_3_4_0 - 0.00168831168831175*G0_1_1_3_4_1 + 0.0013419913419914*G0_1_1_3_4_2 + 0.00320346320346331*G0_1_1_3_4_3 + 0.00372294372294385*G0_1_1_3_4_4 + 0.00329004329004339*G0_1_1_3_4_5 - 0.000173160173160177*G0_1_1_3_5_0 - 0.000259740259740276*G0_1_1_3_5_3 + 0.00329004329004339*G0_1_1_3_5_4 + 0.00562770562770581*G0_1_1_3_5_5 + 0.00325757575757587*G0_1_1_4_0_0 - 0.000411255411255424*G0_1_1_4_0_1 + 0.000194805194805194*G0_1_1_4_0_2 + 0.000129870129870134*G0_1_1_4_0_3 + 0.00441558441558455*G0_1_1_4_0_4 + 0.00134199134199139*G0_1_1_4_0_5 - 0.000411255411255424*G0_1_1_4_1_0 + 0.000800865800865824*G0_1_1_4_1_1 + 0.000119047619047621*G0_1_1_4_1_2 - 0.00168831168831175*G0_1_1_4_1_3 - 0.00199134199134206*G0_1_1_4_1_4 - 0.00147186147186152*G0_1_1_4_1_5 + 0.000194805194805194*G0_1_1_4_2_0 + 0.000119047619047621*G0_1_1_4_2_1 + 0.0073051948051951*G0_1_1_4_2_2 + 0.0013419913419914*G0_1_1_4_2_3 - 0.00718614718614739*G0_1_1_4_2_4 - 0.00177489177489183*G0_1_1_4_2_5 + 0.000129870129870134*G0_1_1_4_3_0 - 0.00168831168831175*G0_1_1_4_3_1 + 0.0013419913419914*G0_1_1_4_3_2 + 0.00320346320346331*G0_1_1_4_3_3 + 0.00372294372294385*G0_1_1_4_3_4 + 0.00329004329004339*G0_1_1_4_3_5 + 0.00441558441558455*G0_1_1_4_4_0 - 0.00199134199134206*G0_1_1_4_4_1 - 0.00718614718614739*G0_1_1_4_4_2 + 0.00372294372294385*G0_1_1_4_4_3 + 0.00493506493506513*G0_1_1_4_4_4 + 0.00753246753246778*G0_1_1_4_4_5 + 0.00134199134199139*G0_1_1_4_5_0 - 0.00147186147186152*G0_1_1_4_5_1 - 0.00177489177489183*G0_1_1_4_5_2 + 0.00329004329004339*G0_1_1_4_5_3 + 0.00753246753246778*G0_1_1_4_5_4 + 0.00822510822510849*G0_1_1_4_5_5 + 0.00891774891774922*G0_1_1_5_0_0 - 0.00311688311688322*G0_1_1_5_0_1 - 0.00025974025974027*G0_1_1_5_0_2 - 0.000173160173160177*G0_1_1_5_0_3 + 0.00134199134199139*G0_1_1_5_0_4 + 0.0047186147186149*G0_1_1_5_0_5 - 0.00311688311688322*G0_1_1_5_1_0 + 0.00985930735930771*G0_1_1_5_1_1 - 0.00147186147186152*G0_1_1_5_1_4 + 0.00510822510822529*G0_1_1_5_1_5 - 0.00025974025974027*G0_1_1_5_2_0 + 0.000768398268398305*G0_1_1_5_2_2 - 0.00177489177489183*G0_1_1_5_2_4 - 0.00264069264069273*G0_1_1_5_2_5 - 0.000173160173160177*G0_1_1_5_3_0 - 0.000259740259740276*G0_1_1_5_3_3 + 0.00329004329004339*G0_1_1_5_3_4 + 0.00562770562770581*G0_1_1_5_3_5 + 0.00134199134199139*G0_1_1_5_4_0 - 0.00147186147186152*G0_1_1_5_4_1 - 0.00177489177489183*G0_1_1_5_4_2 + 0.00329004329004339*G0_1_1_5_4_3 + 0.00753246753246778*G0_1_1_5_4_4 + 0.00822510822510849*G0_1_1_5_4_5 + 0.0047186147186149*G0_1_1_5_5_0 + 0.00510822510822529*G0_1_1_5_5_1 - 0.00264069264069273*G0_1_1_5_5_2 + 0.00562770562770581*G0_1_1_5_5_3 + 0.00822510822510849*G0_1_1_5_5_4 + 0.053246753246755*G0_1_1_5_5_5;
    A[87] = A[78] + 0.00328733766233783*G0_0_1_0_0_0 + 0.00040178571428573*G0_0_1_0_0_1 + 0.000401785714285726*G0_0_1_0_0_2 - 0.00189935064935071*G0_0_1_0_0_3 - 0.0102272727272731*G0_0_1_0_0_5 + 0.000401785714285729*G0_0_1_0_1_0 + 0.000401785714285722*G0_0_1_0_1_1 - 0.000255681818181828*G0_0_1_0_1_2 + 0.000438311688311704*G0_0_1_0_1_3 + 0.000438311688311706*G0_0_1_0_1_4 + 0.00701298701298727*G0_0_1_0_1_5 + 0.000401785714285726*G0_0_1_0_2_0 - 0.000255681818181828*G0_0_1_0_2_1 + 0.000328733766233777*G0_0_1_0_2_2 - 0.0013149350649351*G0_0_1_0_2_3 - 0.0011688311688312*G0_0_1_0_2_4 - 0.0016071428571429*G0_0_1_0_2_5 - 0.00189935064935071*G0_0_1_0_3_0 + 0.000438311688311704*G0_0_1_0_3_1 - 0.00131493506493511*G0_0_1_0_3_2 + 0.00409090909090922*G0_0_1_0_3_3 + 0.00292207792207801*G0_0_1_0_3_4 + 0.00701298701298723*G0_0_1_0_3_5 + 0.000438311688311706*G0_0_1_0_4_1 - 0.0011688311688312*G0_0_1_0_4_2 + 0.00292207792207801*G0_0_1_0_4_3 + 0.00350649350649361*G0_0_1_0_4_4 + 0.00233766233766239*G0_0_1_0_4_5 - 0.0102272727272731*G0_0_1_0_5_0 + 0.00701298701298727*G0_0_1_0_5_1 - 0.0016071428571429*G0_0_1_0_5_2 + 0.00701298701298723*G0_0_1_0_5_3 + 0.00233766233766239*G0_0_1_0_5_4 + 0.00350649350649347*G0_0_1_0_5_5 + 0.000401785714285729*G0_0_1_1_0_0 + 0.000401785714285723*G0_0_1_1_0_1 - 0.000255681818181828*G0_0_1_1_0_2 + 0.000438311688311704*G0_0_1_1_0_3 + 0.000438311688311706*G0_0_1_1_0_4 + 0.00701298701298727*G0_0_1_1_0_5 + 0.000401785714285722*G0_0_1_1_1_0 + 0.00328733766233787*G0_0_1_1_1_1 + 0.000401785714285723*G0_0_1_1_1_2 - 0.00189935064935071*G0_0_1_1_1_4 - 0.0102272727272731*G0_0_1_1_1_5 - 0.000255681818181828*G0_0_1_1_2_0 + 0.000401785714285721*G0_0_1_1_2_1 + 0.000328733766233779*G0_0_1_1_2_2 - 0.00116883116883121*G0_0_1_1_2_3 - 0.00131493506493511*G0_0_1_1_2_4 - 0.00160714285714291*G0_0_1_1_2_5 + 0.000438311688311704*G0_0_1_1_3_0 - 0.00116883116883121*G0_0_1_1_3_2 + 0.00350649350649364*G0_0_1_1_3_3 + 0.00292207792207802*G0_0_1_1_3_4 + 0.00233766233766242*G0_0_1_1_3_5 + 0.000438311688311706*G0_0_1_1_4_0 - 0.00189935064935071*G0_0_1_1_4_1 - 0.00131493506493511*G0_0_1_1_4_2 + 0.00292207792207802*G0_0_1_1_4_3 + 0.00409090909090923*G0_0_1_1_4_4 + 0.00701298701298725*G0_0_1_1_4_5 + 0.00701298701298727*G0_0_1_1_5_0 - 0.0102272727272731*G0_0_1_1_5_1 - 0.00160714285714291*G0_0_1_1_5_2 + 0.00233766233766242*G0_0_1_1_5_3 + 0.00701298701298725*G0_0_1_1_5_4 + 0.00350649350649361*G0_0_1_1_5_5 + 0.000401785714285725*G0_0_1_2_0_0 - 0.000255681818181828*G0_0_1_2_0_1 + 0.000328733766233777*G0_0_1_2_0_2 - 0.0013149350649351*G0_0_1_2_0_3 - 0.0011688311688312*G0_0_1_2_0_4 - 0.0016071428571429*G0_0_1_2_0_5 - 0.000255681818181828*G0_0_1_2_1_0 + 0.000401785714285719*G0_0_1_2_1_1 + 0.000328733766233779*G0_0_1_2_1_2 - 0.00116883116883121*G0_0_1_2_1_3 - 0.00131493506493511*G0_0_1_2_1_4 - 0.00160714285714291*G0_0_1_2_1_5 + 0.000328733766233777*G0_0_1_2_2_0 + 0.000328733766233779*G0_0_1_2_2_1 + 0.000876623376623398*G0_0_1_2_2_2 - 0.00146103896103901*G0_0_1_2_2_3 - 0.00146103896103902*G0_0_1_2_2_4 - 0.00423701298701313*G0_0_1_2_2_5 - 0.0013149350649351*G0_0_1_2_3_0 - 0.00116883116883121*G0_0_1_2_3_1 - 0.00146103896103901*G0_0_1_2_3_2 + 0.00525974025974043*G0_0_1_2_3_3 + 0.00525974025974043*G0_0_1_2_3_4 + 0.0111038961038965*G0_0_1_2_3_5 - 0.0011688311688312*G0_0_1_2_4_0 - 0.00131493506493511*G0_0_1_2_4_1 - 0.00146103896103902*G0_0_1_2_4_2 + 0.00525974025974043*G0_0_1_2_4_3 + 0.00525974025974043*G0_0_1_2_4_4 + 0.0111038961038965*G0_0_1_2_4_5 - 0.0016071428571429*G0_0_1_2_5_0 - 0.00160714285714291*G0_0_1_2_5_1 - 0.00423701298701313*G0_0_1_2_5_2 + 0.0111038961038965*G0_0_1_2_5_3 + 0.0111038961038965*G0_0_1_2_5_4 + 0.0350649350649363*G0_0_1_2_5_5 - 0.00189935064935071*G0_0_1_3_0_0 + 0.000438311688311704*G0_0_1_3_0_1 - 0.0013149350649351*G0_0_1_3_0_2 + 0.00409090909090922*G0_0_1_3_0_3 + 0.00292207792207801*G0_0_1_3_0_4 + 0.00701298701298723*G0_0_1_3_0_5 + 0.000438311688311704*G0_0_1_3_1_0 - 0.00116883116883121*G0_0_1_3_1_2 + 0.00350649350649364*G0_0_1_3_1_3 + 0.00292207792207802*G0_0_1_3_1_4 + 0.00233766233766242*G0_0_1_3_1_5 - 0.0013149350649351*G0_0_1_3_2_0 - 0.00116883116883121*G0_0_1_3_2_1 - 0.00146103896103901*G0_0_1_3_2_2 + 0.00525974025974043*G0_0_1_3_2_3 + 0.00525974025974043*G0_0_1_3_2_4 + 0.0111038961038965*G0_0_1_3_2_5 + 0.00409090909090922*G0_0_1_3_3_0 + 0.00350649350649365*G0_0_1_3_3_1 + 0.00525974025974043*G0_0_1_3_3_2 - 0.00701298701298726*G0_0_1_3_3_3 - 0.0140259740259745*G0_0_1_3_3_4 - 0.0303896103896114*G0_0_1_3_3_5 + 0.00292207792207801*G0_0_1_3_4_0 + 0.00292207792207802*G0_0_1_3_4_1 + 0.00525974025974043*G0_0_1_3_4_2 - 0.0140259740259745*G0_0_1_3_4_3 - 0.0140259740259745*G0_0_1_3_4_4 - 0.028051948051949*G0_0_1_3_4_5 + 0.00701298701298723*G0_0_1_3_5_0 + 0.00233766233766242*G0_0_1_3_5_1 + 0.0111038961038965*G0_0_1_3_5_2 - 0.0303896103896114*G0_0_1_3_5_3 - 0.028051948051949*G0_0_1_3_5_4 - 0.0841558441558471*G0_0_1_3_5_5 + 0.000438311688311706*G0_0_1_4_0_1 - 0.0011688311688312*G0_0_1_4_0_2 + 0.00292207792207801*G0_0_1_4_0_3 + 0.00350649350649361*G0_0_1_4_0_4 + 0.00233766233766239*G0_0_1_4_0_5 + 0.000438311688311706*G0_0_1_4_1_0 - 0.00189935064935071*G0_0_1_4_1_1 - 0.00131493506493511*G0_0_1_4_1_2 + 0.00292207792207802*G0_0_1_4_1_3 + 0.00409090909090923*G0_0_1_4_1_4 + 0.00701298701298725*G0_0_1_4_1_5 - 0.0011688311688312*G0_0_1_4_2_0 - 0.00131493506493511*G0_0_1_4_2_1 - 0.00146103896103902*G0_0_1_4_2_2 + 0.00525974025974043*G0_0_1_4_2_3 + 0.00525974025974043*G0_0_1_4_2_4 + 0.0111038961038965*G0_0_1_4_2_5 + 0.00292207792207801*G0_0_1_4_3_0 + 0.00292207792207802*G0_0_1_4_3_1 + 0.00525974025974043*G0_0_1_4_3_2 - 0.0140259740259745*G0_0_1_4_3_3 - 0.0140259740259745*G0_0_1_4_3_4 - 0.028051948051949*G0_0_1_4_3_5 + 0.00350649350649361*G0_0_1_4_4_0 + 0.00409090909090923*G0_0_1_4_4_1 + 0.00525974025974043*G0_0_1_4_4_2 - 0.0140259740259745*G0_0_1_4_4_3 - 0.00701298701298734*G0_0_1_4_4_4 - 0.0303896103896114*G0_0_1_4_4_5 + 0.00233766233766239*G0_0_1_4_5_0 + 0.00701298701298725*G0_0_1_4_5_1 + 0.0111038961038965*G0_0_1_4_5_2 - 0.028051948051949*G0_0_1_4_5_3 - 0.0303896103896114*G0_0_1_4_5_4 - 0.084155844155847*G0_0_1_4_5_5 - 0.0102272727272731*G0_0_1_5_0_0 + 0.00701298701298727*G0_0_1_5_0_1 - 0.0016071428571429*G0_0_1_5_0_2 + 0.00701298701298723*G0_0_1_5_0_3 + 0.00233766233766239*G0_0_1_5_0_4 + 0.00350649350649347*G0_0_1_5_0_5 + 0.00701298701298727*G0_0_1_5_1_0 - 0.0102272727272731*G0_0_1_5_1_1 - 0.00160714285714291*G0_0_1_5_1_2 + 0.00233766233766242*G0_0_1_5_1_3 + 0.00701298701298725*G0_0_1_5_1_4 + 0.00350649350649361*G0_0_1_5_1_5 - 0.0016071428571429*G0_0_1_5_2_0 - 0.00160714285714291*G0_0_1_5_2_1 - 0.00423701298701313*G0_0_1_5_2_2 + 0.0111038961038965*G0_0_1_5_2_3 + 0.0111038961038965*G0_0_1_5_2_4 + 0.0350649350649363*G0_0_1_5_2_5 + 0.00701298701298723*G0_0_1_5_3_0 + 0.00233766233766242*G0_0_1_5_3_1 + 0.0111038961038965*G0_0_1_5_3_2 - 0.0303896103896114*G0_0_1_5_3_3 - 0.028051948051949*G0_0_1_5_3_4 - 0.084155844155847*G0_0_1_5_3_5 + 0.00233766233766239*G0_0_1_5_4_0 + 0.00701298701298725*G0_0_1_5_4_1 + 0.0111038961038965*G0_0_1_5_4_2 - 0.028051948051949*G0_0_1_5_4_3 - 0.0303896103896114*G0_0_1_5_4_4 - 0.084155844155847*G0_0_1_5_4_5 + 0.00350649350649347*G0_0_1_5_5_0 + 0.00350649350649361*G0_0_1_5_5_1 + 0.0350649350649363*G0_0_1_5_5_2 - 0.0841558441558471*G0_0_1_5_5_3 - 0.084155844155847*G0_0_1_5_5_4 - 0.490909090909108*G0_0_1_5_5_5 - 0.00328733766233783*G0_1_0_0_0_0 - 0.000401785714285729*G0_1_0_0_0_1 - 0.000401785714285726*G0_1_0_0_0_2 + 0.00189935064935071*G0_1_0_0_0_3 + 0.0102272727272731*G0_1_0_0_0_5 - 0.00040178571428573*G0_1_0_0_1_0 - 0.000401785714285722*G0_1_0_0_1_1 + 0.000255681818181828*G0_1_0_0_1_2 - 0.000438311688311704*G0_1_0_0_1_3 - 0.000438311688311706*G0_1_0_0_1_4 - 0.00701298701298727*G0_1_0_0_1_5 - 0.000401785714285726*G0_1_0_0_2_0 + 0.000255681818181828*G0_1_0_0_2_1 - 0.000328733766233777*G0_1_0_0_2_2 + 0.0013149350649351*G0_1_0_0_2_3 + 0.0011688311688312*G0_1_0_0_2_4 + 0.0016071428571429*G0_1_0_0_2_5 + 0.00189935064935071*G0_1_0_0_3_0 - 0.000438311688311704*G0_1_0_0_3_1 + 0.00131493506493511*G0_1_0_0_3_2 - 0.00409090909090922*G0_1_0_0_3_3 - 0.00292207792207801*G0_1_0_0_3_4 - 0.00701298701298723*G0_1_0_0_3_5 - 0.000438311688311706*G0_1_0_0_4_1 + 0.0011688311688312*G0_1_0_0_4_2 - 0.00292207792207801*G0_1_0_0_4_3 - 0.00350649350649361*G0_1_0_0_4_4 - 0.00233766233766239*G0_1_0_0_4_5 + 0.0102272727272731*G0_1_0_0_5_0 - 0.00701298701298727*G0_1_0_0_5_1 + 0.0016071428571429*G0_1_0_0_5_2 - 0.00701298701298723*G0_1_0_0_5_3 - 0.00233766233766239*G0_1_0_0_5_4 - 0.00350649350649348*G0_1_0_0_5_5 - 0.00040178571428573*G0_1_0_1_0_0 - 0.000401785714285723*G0_1_0_1_0_1 + 0.000255681818181828*G0_1_0_1_0_2 - 0.000438311688311704*G0_1_0_1_0_3 - 0.000438311688311706*G0_1_0_1_0_4 - 0.00701298701298727*G0_1_0_1_0_5 - 0.000401785714285722*G0_1_0_1_1_0 - 0.00328733766233787*G0_1_0_1_1_1 - 0.000401785714285723*G0_1_0_1_1_2 + 0.00189935064935071*G0_1_0_1_1_4 + 0.0102272727272731*G0_1_0_1_1_5 + 0.000255681818181828*G0_1_0_1_2_0 - 0.000401785714285721*G0_1_0_1_2_1 - 0.000328733766233779*G0_1_0_1_2_2 + 0.00116883116883121*G0_1_0_1_2_3 + 0.00131493506493511*G0_1_0_1_2_4 + 0.00160714285714291*G0_1_0_1_2_5 - 0.000438311688311704*G0_1_0_1_3_0 + 0.00116883116883121*G0_1_0_1_3_2 - 0.00350649350649364*G0_1_0_1_3_3 - 0.00292207792207802*G0_1_0_1_3_4 - 0.00233766233766242*G0_1_0_1_3_5 - 0.000438311688311706*G0_1_0_1_4_0 + 0.00189935064935071*G0_1_0_1_4_1 + 0.00131493506493511*G0_1_0_1_4_2 - 0.00292207792207802*G0_1_0_1_4_3 - 0.00409090909090923*G0_1_0_1_4_4 - 0.00701298701298725*G0_1_0_1_4_5 - 0.00701298701298727*G0_1_0_1_5_0 + 0.0102272727272731*G0_1_0_1_5_1 + 0.00160714285714291*G0_1_0_1_5_2 - 0.00233766233766242*G0_1_0_1_5_3 - 0.00701298701298725*G0_1_0_1_5_4 - 0.00350649350649361*G0_1_0_1_5_5 - 0.000401785714285726*G0_1_0_2_0_0 + 0.000255681818181828*G0_1_0_2_0_1 - 0.000328733766233777*G0_1_0_2_0_2 + 0.0013149350649351*G0_1_0_2_0_3 + 0.0011688311688312*G0_1_0_2_0_4 + 0.0016071428571429*G0_1_0_2_0_5 + 0.000255681818181828*G0_1_0_2_1_0 - 0.000401785714285719*G0_1_0_2_1_1 - 0.000328733766233779*G0_1_0_2_1_2 + 0.00116883116883121*G0_1_0_2_1_3 + 0.00131493506493511*G0_1_0_2_1_4 + 0.00160714285714291*G0_1_0_2_1_5 - 0.000328733766233777*G0_1_0_2_2_0 - 0.000328733766233779*G0_1_0_2_2_1 - 0.000876623376623398*G0_1_0_2_2_2 + 0.00146103896103901*G0_1_0_2_2_3 + 0.00146103896103902*G0_1_0_2_2_4 + 0.00423701298701313*G0_1_0_2_2_5 + 0.0013149350649351*G0_1_0_2_3_0 + 0.00116883116883121*G0_1_0_2_3_1 + 0.00146103896103901*G0_1_0_2_3_2 - 0.00525974025974043*G0_1_0_2_3_3 - 0.00525974025974043*G0_1_0_2_3_4 - 0.0111038961038965*G0_1_0_2_3_5 + 0.0011688311688312*G0_1_0_2_4_0 + 0.00131493506493511*G0_1_0_2_4_1 + 0.00146103896103902*G0_1_0_2_4_2 - 0.00525974025974043*G0_1_0_2_4_3 - 0.00525974025974043*G0_1_0_2_4_4 - 0.0111038961038965*G0_1_0_2_4_5 + 0.0016071428571429*G0_1_0_2_5_0 + 0.00160714285714291*G0_1_0_2_5_1 + 0.00423701298701313*G0_1_0_2_5_2 - 0.0111038961038965*G0_1_0_2_5_3 - 0.0111038961038965*G0_1_0_2_5_4 - 0.0350649350649363*G0_1_0_2_5_5 + 0.00189935064935071*G0_1_0_3_0_0 - 0.000438311688311704*G0_1_0_3_0_1 + 0.00131493506493511*G0_1_0_3_0_2 - 0.00409090909090922*G0_1_0_3_0_3 - 0.00292207792207801*G0_1_0_3_0_4 - 0.00701298701298723*G0_1_0_3_0_5 - 0.000438311688311704*G0_1_0_3_1_0 + 0.00116883116883121*G0_1_0_3_1_2 - 0.00350649350649365*G0_1_0_3_1_3 - 0.00292207792207802*G0_1_0_3_1_4 - 0.00233766233766242*G0_1_0_3_1_5 + 0.0013149350649351*G0_1_0_3_2_0 + 0.00116883116883121*G0_1_0_3_2_1 + 0.00146103896103901*G0_1_0_3_2_2 - 0.00525974025974043*G0_1_0_3_2_3 - 0.00525974025974043*G0_1_0_3_2_4 - 0.0111038961038965*G0_1_0_3_2_5 - 0.00409090909090922*G0_1_0_3_3_0 - 0.00350649350649365*G0_1_0_3_3_1 - 0.00525974025974042*G0_1_0_3_3_2 + 0.00701298701298725*G0_1_0_3_3_3 + 0.0140259740259745*G0_1_0_3_3_4 + 0.0303896103896114*G0_1_0_3_3_5 - 0.00292207792207801*G0_1_0_3_4_0 - 0.00292207792207802*G0_1_0_3_4_1 - 0.00525974025974043*G0_1_0_3_4_2 + 0.0140259740259745*G0_1_0_3_4_3 + 0.0140259740259745*G0_1_0_3_4_4 + 0.028051948051949*G0_1_0_3_4_5 - 0.00701298701298723*G0_1_0_3_5_0 - 0.00233766233766242*G0_1_0_3_5_1 - 0.0111038961038965*G0_1_0_3_5_2 + 0.0303896103896114*G0_1_0_3_5_3 + 0.028051948051949*G0_1_0_3_5_4 + 0.0841558441558471*G0_1_0_3_5_5 - 0.000438311688311706*G0_1_0_4_0_1 + 0.0011688311688312*G0_1_0_4_0_2 - 0.00292207792207801*G0_1_0_4_0_3 - 0.00350649350649361*G0_1_0_4_0_4 - 0.00233766233766239*G0_1_0_4_0_5 - 0.000438311688311706*G0_1_0_4_1_0 + 0.00189935064935071*G0_1_0_4_1_1 + 0.00131493506493511*G0_1_0_4_1_2 - 0.00292207792207802*G0_1_0_4_1_3 - 0.00409090909090923*G0_1_0_4_1_4 - 0.00701298701298725*G0_1_0_4_1_5 + 0.0011688311688312*G0_1_0_4_2_0 + 0.00131493506493511*G0_1_0_4_2_1 + 0.00146103896103902*G0_1_0_4_2_2 - 0.00525974025974043*G0_1_0_4_2_3 - 0.00525974025974043*G0_1_0_4_2_4 - 0.0111038961038965*G0_1_0_4_2_5 - 0.00292207792207801*G0_1_0_4_3_0 - 0.00292207792207802*G0_1_0_4_3_1 - 0.00525974025974043*G0_1_0_4_3_2 + 0.0140259740259745*G0_1_0_4_3_3 + 0.0140259740259745*G0_1_0_4_3_4 + 0.028051948051949*G0_1_0_4_3_5 - 0.00350649350649361*G0_1_0_4_4_0 - 0.00409090909090923*G0_1_0_4_4_1 - 0.00525974025974043*G0_1_0_4_4_2 + 0.0140259740259745*G0_1_0_4_4_3 + 0.00701298701298734*G0_1_0_4_4_4 + 0.0303896103896114*G0_1_0_4_4_5 - 0.00233766233766239*G0_1_0_4_5_0 - 0.00701298701298725*G0_1_0_4_5_1 - 0.0111038961038965*G0_1_0_4_5_2 + 0.028051948051949*G0_1_0_4_5_3 + 0.0303896103896114*G0_1_0_4_5_4 + 0.084155844155847*G0_1_0_4_5_5 + 0.0102272727272731*G0_1_0_5_0_0 - 0.00701298701298727*G0_1_0_5_0_1 + 0.0016071428571429*G0_1_0_5_0_2 - 0.00701298701298723*G0_1_0_5_0_3 - 0.00233766233766239*G0_1_0_5_0_4 - 0.00350649350649348*G0_1_0_5_0_5 - 0.00701298701298727*G0_1_0_5_1_0 + 0.0102272727272731*G0_1_0_5_1_1 + 0.00160714285714291*G0_1_0_5_1_2 - 0.00233766233766242*G0_1_0_5_1_3 - 0.00701298701298725*G0_1_0_5_1_4 - 0.00350649350649361*G0_1_0_5_1_5 + 0.0016071428571429*G0_1_0_5_2_0 + 0.00160714285714291*G0_1_0_5_2_1 + 0.00423701298701313*G0_1_0_5_2_2 - 0.0111038961038965*G0_1_0_5_2_3 - 0.0111038961038965*G0_1_0_5_2_4 - 0.0350649350649363*G0_1_0_5_2_5 - 0.00701298701298723*G0_1_0_5_3_0 - 0.00233766233766242*G0_1_0_5_3_1 - 0.0111038961038965*G0_1_0_5_3_2 + 0.0303896103896114*G0_1_0_5_3_3 + 0.028051948051949*G0_1_0_5_3_4 + 0.084155844155847*G0_1_0_5_3_5 - 0.00233766233766239*G0_1_0_5_4_0 - 0.00701298701298725*G0_1_0_5_4_1 - 0.0111038961038965*G0_1_0_5_4_2 + 0.028051948051949*G0_1_0_5_4_3 + 0.0303896103896114*G0_1_0_5_4_4 + 0.084155844155847*G0_1_0_5_4_5 - 0.00350649350649348*G0_1_0_5_5_0 - 0.00350649350649361*G0_1_0_5_5_1 - 0.0350649350649363*G0_1_0_5_5_2 + 0.0841558441558471*G0_1_0_5_5_3 + 0.084155844155847*G0_1_0_5_5_4 + 0.490909090909108*G0_1_0_5_5_5;
    A[37] = -A[87] - 0.109760551948056*G0_0_0_0_0_0 + 0.0045170454545456*G0_0_0_0_0_1 + 0.00976461038961071*G0_0_0_0_0_2 - 0.0037500000000001*G0_0_0_0_0_3 - 0.0431006493506508*G0_0_0_0_0_4 - 0.0224025974025982*G0_0_0_0_0_5 + 0.0045170454545456*G0_0_0_0_1_0 + 0.00304383116883126*G0_0_0_0_1_1 - 0.000560064935064955*G0_0_0_0_1_2 + 0.000243506493506504*G0_0_0_0_1_3 + 0.00180194805194812*G0_0_0_0_1_4 + 0.00340909090909104*G0_0_0_0_1_5 + 0.00976461038961071*G0_0_0_0_2_0 - 0.000560064935064955*G0_0_0_0_2_1 - 0.00152191558441564*G0_0_0_0_2_2 - 0.00175324675324681*G0_0_0_0_2_3 + 0.00584415584415604*G0_0_0_0_2_4 - 0.000925324675324697*G0_0_0_0_2_5 - 0.0037500000000001*G0_0_0_0_3_0 + 0.000243506493506504*G0_0_0_0_3_1 - 0.00175324675324681*G0_0_0_0_3_2 + 0.00487012987013002*G0_0_0_0_3_3 + 0.00389610389610401*G0_0_0_0_3_4 + 0.00935064935064964*G0_0_0_0_3_5 - 0.0431006493506508*G0_0_0_0_4_0 + 0.00180194805194812*G0_0_0_0_4_1 + 0.00584415584415604*G0_0_0_0_4_2 + 0.00389610389610402*G0_0_0_0_4_3 - 0.0374025974025987*G0_0_0_0_4_4 - 0.00175324675324684*G0_0_0_0_4_5 - 0.0224025974025982*G0_0_0_0_5_0 + 0.00340909090909104*G0_0_0_0_5_1 - 0.000925324675324697*G0_0_0_0_5_2 + 0.00935064935064964*G0_0_0_0_5_3 - 0.00175324675324684*G0_0_0_0_5_4 + 0.010714285714286*G0_0_0_0_5_5 + 0.0045170454545456*G0_0_0_1_0_0 + 0.00304383116883126*G0_0_0_1_0_1 - 0.000560064935064955*G0_0_0_1_0_2 + 0.000243506493506504*G0_0_0_1_0_3 + 0.00180194805194812*G0_0_0_1_0_4 + 0.00340909090909104*G0_0_0_1_0_5 + 0.00304383116883126*G0_0_0_1_1_0 - 0.0814529220779248*G0_0_0_1_1_1 + 0.00511363636363653*G0_0_0_1_1_2 - 0.0197240259740266*G0_0_0_1_1_3 - 0.00267857142857151*G0_0_0_1_1_4 - 0.0168019480519487*G0_0_0_1_1_5 - 0.000560064935064955*G0_0_0_1_2_0 + 0.00511363636363653*G0_0_0_1_2_1 - 0.000206980519480525*G0_0_0_1_2_2 - 0.000487012987013005*G0_0_0_1_2_3 - 0.00224025974025981*G0_0_0_1_2_4 - 0.0012175324675325*G0_0_0_1_2_5 + 0.000243506493506504*G0_0_0_1_3_0 - 0.0197240259740266*G0_0_0_1_3_1 - 0.000487012987013005*G0_0_0_1_3_2 - 0.002922077922078*G0_0_0_1_3_3 + 0.00487012987013002*G0_0_0_1_3_4 + 0.00194805194805199*G0_0_0_1_3_5 + 0.00180194805194812*G0_0_0_1_4_0 - 0.00267857142857151*G0_0_0_1_4_1 - 0.00224025974025981*G0_0_0_1_4_2 + 0.00487012987013002*G0_0_0_1_4_3 + 0.00974025974026006*G0_0_0_1_4_4 + 0.00779220779220805*G0_0_0_1_4_5 + 0.00340909090909104*G0_0_0_1_5_0 - 0.0168019480519487*G0_0_0_1_5_1 - 0.0012175324675325*G0_0_0_1_5_2 + 0.00194805194805199*G0_0_0_1_5_3 + 0.00779220779220805*G0_0_0_1_5_4 + 0.00487012987012998*G0_0_0_1_5_5 + 0.00976461038961071*G0_0_0_2_0_0 - 0.000560064935064955*G0_0_0_2_0_1 - 0.00152191558441564*G0_0_0_2_0_2 - 0.00175324675324681*G0_0_0_2_0_3 + 0.00584415584415604*G0_0_0_2_0_4 - 0.000925324675324697*G0_0_0_2_0_5 - 0.000560064935064955*G0_0_0_2_1_0 + 0.00511363636363653*G0_0_0_2_1_1 - 0.000206980519480525*G0_0_0_2_1_2 - 0.000487012987013005*G0_0_0_2_1_3 - 0.00224025974025981*G0_0_0_2_1_4 - 0.0012175324675325*G0_0_0_2_1_5 - 0.00152191558441564*G0_0_0_2_2_0 - 0.000206980519480525*G0_0_0_2_2_1 + 0.00372564935064946*G0_0_0_2_2_2 - 0.000438311688311701*G0_0_0_2_2_3 - 0.00199675324675331*G0_0_0_2_2_4 - 0.00438311688311703*G0_0_0_2_2_5 - 0.00175324675324681*G0_0_0_2_3_0 - 0.000487012987013005*G0_0_0_2_3_1 - 0.000438311688311701*G0_0_0_2_3_2 + 0.00974025974026005*G0_0_0_2_3_3 + 0.00798701298701325*G0_0_0_2_3_4 + 0.0122727272727277*G0_0_0_2_3_5 + 0.00584415584415604*G0_0_0_2_4_0 - 0.00224025974025981*G0_0_0_2_4_1 - 0.00199675324675331*G0_0_0_2_4_2 + 0.00798701298701325*G0_0_0_2_4_3 + 0.0237662337662346*G0_0_0_2_4_4 + 0.0132467532467537*G0_0_0_2_4_5 - 0.000925324675324697*G0_0_0_2_5_0 - 0.0012175324675325*G0_0_0_2_5_1 - 0.00438311688311703*G0_0_0_2_5_2 + 0.0122727272727277*G0_0_0_2_5_3 + 0.0132467532467537*G0_0_0_2_5_4 + 0.0292207792207802*G0_0_0_2_5_5 - 0.0037500000000001*G0_0_0_3_0_0 + 0.000243506493506504*G0_0_0_3_0_1 - 0.00175324675324681*G0_0_0_3_0_2 + 0.00487012987013003*G0_0_0_3_0_3 + 0.00389610389610401*G0_0_0_3_0_4 + 0.00935064935064964*G0_0_0_3_0_5 + 0.000243506493506504*G0_0_0_3_1_0 - 0.0197240259740266*G0_0_0_3_1_1 - 0.000487012987013005*G0_0_0_3_1_2 - 0.002922077922078*G0_0_0_3_1_3 + 0.00487012987013002*G0_0_0_3_1_4 + 0.00194805194805199*G0_0_0_3_1_5 - 0.00175324675324681*G0_0_0_3_2_0 - 0.000487012987013005*G0_0_0_3_2_1 - 0.000438311688311701*G0_0_0_3_2_2 + 0.00974025974026005*G0_0_0_3_2_3 + 0.00798701298701325*G0_0_0_3_2_4 + 0.0122727272727277*G0_0_0_3_2_5 + 0.00487012987013002*G0_0_0_3_3_0 - 0.002922077922078*G0_0_0_3_3_1 + 0.00974025974026005*G0_0_0_3_3_2 + 0.0677922077922102*G0_0_0_3_3_3 - 0.0194805194805201*G0_0_0_3_3_4 - 0.0342857142857154*G0_0_0_3_3_5 + 0.00389610389610401*G0_0_0_3_4_0 + 0.00487012987013002*G0_0_0_3_4_1 + 0.00798701298701325*G0_0_0_3_4_2 - 0.0194805194805201*G0_0_0_3_4_3 - 0.0272727272727281*G0_0_0_3_4_4 - 0.0342857142857154*G0_0_0_3_4_5 + 0.00935064935064964*G0_0_0_3_5_0 + 0.00194805194805199*G0_0_0_3_5_1 + 0.0122727272727277*G0_0_0_3_5_2 - 0.0342857142857154*G0_0_0_3_5_3 - 0.0342857142857154*G0_0_0_3_5_4 - 0.0771428571428597*G0_0_0_3_5_5 - 0.0431006493506508*G0_0_0_4_0_0 + 0.00180194805194812*G0_0_0_4_0_1 + 0.00584415584415604*G0_0_0_4_0_2 + 0.00389610389610401*G0_0_0_4_0_3 - 0.0374025974025987*G0_0_0_4_0_4 - 0.00175324675324684*G0_0_0_4_0_5 + 0.00180194805194812*G0_0_0_4_1_0 - 0.00267857142857151*G0_0_0_4_1_1 - 0.00224025974025981*G0_0_0_4_1_2 + 0.00487012987013002*G0_0_0_4_1_3 + 0.00974025974026006*G0_0_0_4_1_4 + 0.00779220779220805*G0_0_0_4_1_5 + 0.00584415584415604*G0_0_0_4_2_0 - 0.00224025974025981*G0_0_0_4_2_1 - 0.00199675324675331*G0_0_0_4_2_2 + 0.00798701298701325*G0_0_0_4_2_3 + 0.0237662337662346*G0_0_0_4_2_4 + 0.0132467532467537*G0_0_0_4_2_5 + 0.00389610389610401*G0_0_0_4_3_0 + 0.00487012987013002*G0_0_0_4_3_1 + 0.00798701298701325*G0_0_0_4_3_2 - 0.0194805194805201*G0_0_0_4_3_3 - 0.0272727272727281*G0_0_0_4_3_4 - 0.0342857142857154*G0_0_0_4_3_5 - 0.0374025974025987*G0_0_0_4_4_0 + 0.00974025974026006*G0_0_0_4_4_1 + 0.0237662337662346*G0_0_0_4_4_2 - 0.0272727272727281*G0_0_0_4_4_3 - 0.128571428571433*G0_0_0_4_4_4 - 0.0459740259740275*G0_0_0_4_4_5 - 0.00175324675324684*G0_0_0_4_5_0 + 0.00779220779220805*G0_0_0_4_5_1 + 0.0132467532467537*G0_0_0_4_5_2 - 0.0342857142857154*G0_0_0_4_5_3 - 0.0459740259740275*G0_0_0_4_5_4 - 0.0740259740259765*G0_0_0_4_5_5 - 0.0224025974025982*G0_0_0_5_0_0 + 0.00340909090909104*G0_0_0_5_0_1 - 0.000925324675324697*G0_0_0_5_0_2 + 0.00935064935064964*G0_0_0_5_0_3 - 0.00175324675324684*G0_0_0_5_0_4 + 0.010714285714286*G0_0_0_5_0_5 + 0.00340909090909104*G0_0_0_5_1_0 - 0.0168019480519487*G0_0_0_5_1_1 - 0.0012175324675325*G0_0_0_5_1_2 + 0.00194805194805199*G0_0_0_5_1_3 + 0.00779220779220805*G0_0_0_5_1_4 + 0.00487012987012998*G0_0_0_5_1_5 - 0.000925324675324697*G0_0_0_5_2_0 - 0.0012175324675325*G0_0_0_5_2_1 - 0.00438311688311703*G0_0_0_5_2_2 + 0.0122727272727277*G0_0_0_5_2_3 + 0.0132467532467537*G0_0_0_5_2_4 + 0.0292207792207802*G0_0_0_5_2_5 + 0.00935064935064964*G0_0_0_5_3_0 + 0.00194805194805199*G0_0_0_5_3_1 + 0.0122727272727277*G0_0_0_5_3_2 - 0.0342857142857154*G0_0_0_5_3_3 - 0.0342857142857154*G0_0_0_5_3_4 - 0.0771428571428597*G0_0_0_5_3_5 - 0.00175324675324684*G0_0_0_5_4_0 + 0.00779220779220805*G0_0_0_5_4_1 + 0.0132467532467537*G0_0_0_5_4_2 - 0.0342857142857154*G0_0_0_5_4_3 - 0.0459740259740275*G0_0_0_5_4_4 - 0.0740259740259765*G0_0_0_5_4_5 + 0.010714285714286*G0_0_0_5_5_0 + 0.00487012987012998*G0_0_0_5_5_1 + 0.0292207792207802*G0_0_0_5_5_2 - 0.0771428571428597*G0_0_0_5_5_3 - 0.0740259740259765*G0_0_0_5_5_4 - 0.317922077922089*G0_0_0_5_5_5 + 0.0100446428571432*G0_0_1_0_0_0 - 0.000231331168831178*G0_0_1_0_0_2 - 0.00165584415584421*G0_0_1_0_0_3 + 0.00267857142857152*G0_0_1_0_0_4 - 0.00681818181818207*G0_0_1_0_0_5 + 0.00328733766233776*G0_0_1_0_1_1 - 0.000121753246753253*G0_0_1_0_1_2 + 0.000487012987013005*G0_0_1_0_1_3 - 0.000487012987012999*G0_0_1_0_1_4 + 0.00487012987013006*G0_0_1_0_1_5 - 0.000231331168831178*G0_0_1_0_2_0 - 0.000121753246753253*G0_0_1_0_2_1 + 0.000572240259740282*G0_0_1_0_2_2 - 0.0016558441558442*G0_0_1_0_2_3 - 0.0022402597402598*G0_0_1_0_2_4 - 0.001948051948052*G0_0_1_0_2_5 - 0.00165584415584421*G0_0_1_0_3_0 + 0.000487012987013005*G0_0_1_0_3_1 - 0.0016558441558442*G0_0_1_0_3_2 + 0.000974025974026009*G0_0_1_0_3_3 + 0.00428571428571442*G0_0_1_0_3_4 + 0.00720779220779242*G0_0_1_0_3_5 + 0.00267857142857152*G0_0_1_0_4_0 - 0.000487012987012999*G0_0_1_0_4_1 - 0.0022402597402598*G0_0_1_0_4_2 + 0.00428571428571442*G0_0_1_0_4_3 + 0.00857142857142885*G0_0_1_0_4_4 + 0.00487012987013*G0_0_1_0_4_5 - 0.00681818181818207*G0_0_1_0_5_0 + 0.00487012987013006*G0_0_1_0_5_1 - 0.001948051948052*G0_0_1_0_5_2 + 0.00720779220779242*G0_0_1_0_5_3 + 0.00487012987013*G0_0_1_0_5_4 - 0.00175324675324698*G0_0_1_0_5_5 + 0.00328733766233776*G0_0_1_1_0_1 - 0.000121753246753253*G0_0_1_1_0_2 + 0.000487012987013005*G0_0_1_1_0_3 - 0.000487012987012999*G0_0_1_1_0_4 + 0.00487012987013006*G0_0_1_1_0_5 + 0.00328733766233776*G0_0_1_1_1_0 - 0.085470779220782*G0_0_1_1_1_1 + 0.00547889610389628*G0_0_1_1_1_2 - 0.0204545454545461*G0_0_1_1_1_3 - 0.00292207792207801*G0_0_1_1_1_4 - 0.0204545454545462*G0_0_1_1_1_5 - 0.000121753246753253*G0_0_1_1_2_0 + 0.00547889610389628*G0_0_1_1_2_1 - 0.000974025974026008*G0_0_1_1_2_3 - 0.00194805194805201*G0_0_1_1_2_4 - 0.00243506493506501*G0_0_1_1_2_5 + 0.000487012987013005*G0_0_1_1_3_0 - 0.0204545454545461*G0_0_1_1_3_1 - 0.000974025974026006*G0_0_1_1_3_2 - 0.00389610389610399*G0_0_1_1_3_3 + 0.00487012987013003*G0_0_1_1_3_4 + 0.00389610389610401*G0_0_1_1_3_5 - 0.000487012987012999*G0_0_1_1_4_0 - 0.00292207792207801*G0_0_1_1_4_1 - 0.00194805194805201*G0_0_1_1_4_2 + 0.00487012987013003*G0_0_1_1_4_3 + 0.00584415584415604*G0_0_1_1_4_4 + 0.0107142857142861*G0_0_1_1_4_5 + 0.00487012987013006*G0_0_1_1_5_0 - 0.0204545454545462*G0_0_1_1_5_1 - 0.00243506493506501*G0_0_1_1_5_2 + 0.00389610389610401*G0_0_1_1_5_3 + 0.0107142857142861*G0_0_1_1_5_4 + 0.0194805194805201*G0_0_1_1_5_5 - 0.000231331168831178*G0_0_1_2_0_0 - 0.000121753246753253*G0_0_1_2_0_1 + 0.000572240259740282*G0_0_1_2_0_2 - 0.0016558441558442*G0_0_1_2_0_3 - 0.0022402597402598*G0_0_1_2_0_4 - 0.001948051948052*G0_0_1_2_0_5 - 0.000121753246753253*G0_0_1_2_1_0 + 0.00547889610389628*G0_0_1_2_1_1 - 0.000974025974026008*G0_0_1_2_1_3 - 0.00194805194805201*G0_0_1_2_1_4 - 0.00243506493506501*G0_0_1_2_1_5 + 0.000572240259740282*G0_0_1_2_2_0 - 0.000255681818181881*G0_0_1_2_2_2 - 0.000681818181818211*G0_0_1_2_2_3 - 0.00199675324675334*G0_0_1_2_2_4 - 0.00487012987013003*G0_0_1_2_2_5 - 0.0016558441558442*G0_0_1_2_3_0 - 0.000974025974026007*G0_0_1_2_3_1 - 0.000681818181818211*G0_0_1_2_3_2 + 0.00876623376623403*G0_0_1_2_3_3 + 0.00720779220779244*G0_0_1_2_3_4 + 0.0130519480519485*G0_0_1_2_3_5 - 0.0022402597402598*G0_0_1_2_4_0 - 0.00194805194805201*G0_0_1_2_4_1 - 0.00199675324675334*G0_0_1_2_4_2 + 0.00720779220779244*G0_0_1_2_4_3 + 0.00623376623376641*G0_0_1_2_4_4 + 0.0136363636363641*G0_0_1_2_4_5 - 0.001948051948052*G0_0_1_2_5_0 - 0.00243506493506501*G0_0_1_2_5_1 - 0.00487012987013003*G0_0_1_2_5_2 + 0.0130519480519485*G0_0_1_2_5_3 + 0.0136363636363641*G0_0_1_2_5_4 + 0.0372077922077935*G0_0_1_2_5_5 - 0.00165584415584421*G0_0_1_3_0_0 + 0.000487012987013005*G0_0_1_3_0_1 - 0.0016558441558442*G0_0_1_3_0_2 + 0.00097402597402601*G0_0_1_3_0_3 + 0.00428571428571442*G0_0_1_3_0_4 + 0.00720779220779242*G0_0_1_3_0_5 + 0.000487012987013005*G0_0_1_3_1_0 - 0.0204545454545461*G0_0_1_3_1_1 - 0.000974025974026007*G0_0_1_3_1_2 - 0.00389610389610399*G0_0_1_3_1_3 + 0.00487012987013003*G0_0_1_3_1_4 + 0.00389610389610401*G0_0_1_3_1_5 - 0.0016558441558442*G0_0_1_3_2_0 - 0.000974025974026007*G0_0_1_3_2_1 - 0.000681818181818211*G0_0_1_3_2_2 + 0.00876623376623403*G0_0_1_3_2_3 + 0.00720779220779244*G0_0_1_3_2_4 + 0.0130519480519485*G0_0_1_3_2_5 + 0.000974025974026012*G0_0_1_3_3_0 - 0.00389610389610399*G0_0_1_3_3_1 + 0.00876623376623403*G0_0_1_3_3_2 + 0.0981818181818216*G0_0_1_3_3_3 - 0.0116883116883121*G0_0_1_3_3_4 - 0.0280519480519489*G0_0_1_3_3_5 + 0.00428571428571442*G0_0_1_3_4_0 + 0.00487012987013003*G0_0_1_3_4_1 + 0.00720779220779244*G0_0_1_3_4_2 - 0.0116883116883121*G0_0_1_3_4_3 - 0.0202597402597409*G0_0_1_3_4_4 - 0.035844155844157*G0_0_1_3_4_5 + 0.00720779220779242*G0_0_1_3_5_0 + 0.00389610389610401*G0_0_1_3_5_1 + 0.0130519480519485*G0_0_1_3_5_2 - 0.0280519480519489*G0_0_1_3_5_3 - 0.035844155844157*G0_0_1_3_5_4 - 0.0888311688311718*G0_0_1_3_5_5 + 0.00267857142857152*G0_0_1_4_0_0 - 0.000487012987012999*G0_0_1_4_0_1 - 0.0022402597402598*G0_0_1_4_0_2 + 0.00428571428571442*G0_0_1_4_0_3 + 0.00857142857142885*G0_0_1_4_0_4 + 0.00487012987013*G0_0_1_4_0_5 - 0.000487012987012999*G0_0_1_4_1_0 - 0.00292207792207801*G0_0_1_4_1_1 - 0.00194805194805201*G0_0_1_4_1_2 + 0.00487012987013003*G0_0_1_4_1_3 + 0.00584415584415604*G0_0_1_4_1_4 + 0.0107142857142861*G0_0_1_4_1_5 - 0.0022402597402598*G0_0_1_4_2_0 - 0.00194805194805201*G0_0_1_4_2_1 - 0.00199675324675334*G0_0_1_4_2_2 + 0.00720779220779244*G0_0_1_4_2_3 + 0.00623376623376641*G0_0_1_4_2_4 + 0.0136363636363641*G0_0_1_4_2_5 + 0.00428571428571442*G0_0_1_4_3_0 + 0.00487012987013003*G0_0_1_4_3_1 + 0.00720779220779244*G0_0_1_4_3_2 - 0.0116883116883121*G0_0_1_4_3_3 - 0.0202597402597409*G0_0_1_4_3_4 - 0.035844155844157*G0_0_1_4_3_5 + 0.00857142857142885*G0_0_1_4_4_0 + 0.00584415584415604*G0_0_1_4_4_1 + 0.00623376623376641*G0_0_1_4_4_2 - 0.0202597402597409*G0_0_1_4_4_3 - 0.0389610389610403*G0_0_1_4_4_5 + 0.00487012987013*G0_0_1_4_5_0 + 0.0107142857142861*G0_0_1_4_5_1 + 0.0136363636363641*G0_0_1_4_5_2 - 0.035844155844157*G0_0_1_4_5_3 - 0.0389610389610402*G0_0_1_4_5_4 - 0.0958441558441591*G0_0_1_4_5_5 - 0.00681818181818207*G0_0_1_5_0_0 + 0.00487012987013006*G0_0_1_5_0_1 - 0.001948051948052*G0_0_1_5_0_2 + 0.00720779220779242*G0_0_1_5_0_3 + 0.00487012987013*G0_0_1_5_0_4 - 0.00175324675324698*G0_0_1_5_0_5 + 0.00487012987013006*G0_0_1_5_1_0 - 0.0204545454545462*G0_0_1_5_1_1 - 0.00243506493506501*G0_0_1_5_1_2 + 0.00389610389610401*G0_0_1_5_1_3 + 0.0107142857142861*G0_0_1_5_1_4 + 0.0194805194805201*G0_0_1_5_1_5 - 0.001948051948052*G0_0_1_5_2_0 - 0.00243506493506501*G0_0_1_5_2_1 - 0.00487012987013003*G0_0_1_5_2_2 + 0.0130519480519485*G0_0_1_5_2_3 + 0.0136363636363641*G0_0_1_5_2_4 + 0.0372077922077935*G0_0_1_5_2_5 + 0.00720779220779242*G0_0_1_5_3_0 + 0.00389610389610401*G0_0_1_5_3_1 + 0.0130519480519485*G0_0_1_5_3_2 - 0.0280519480519489*G0_0_1_5_3_3 - 0.035844155844157*G0_0_1_5_3_4 - 0.0888311688311718*G0_0_1_5_3_5 + 0.00487012987013*G0_0_1_5_4_0 + 0.0107142857142861*G0_0_1_5_4_1 + 0.0136363636363641*G0_0_1_5_4_2 - 0.035844155844157*G0_0_1_5_4_3 - 0.0389610389610403*G0_0_1_5_4_4 - 0.0958441558441591*G0_0_1_5_4_5 - 0.00175324675324698*G0_0_1_5_5_0 + 0.0194805194805201*G0_0_1_5_5_1 + 0.0372077922077935*G0_0_1_5_5_2 - 0.0888311688311718*G0_0_1_5_5_3 - 0.0958441558441591*G0_0_1_5_5_4 - 0.448831168831185*G0_0_1_5_5_5;
    A[42] = -A[72] + 0.01935064935065*G0_0_1_0_0_0 - 0.00145292207792212*G0_0_1_0_0_1 + 0.000919913419913451*G0_0_1_0_0_2 + 0.00107683982683986*G0_0_1_0_0_3 + 0.00390151515151527*G0_0_1_0_0_4 + 0.00486471861471877*G0_0_1_0_0_5 - 0.00145292207792212*G0_0_1_0_1_0 - 0.000238095238095245*G0_0_1_0_1_1 + 0.00101596320346324*G0_0_1_0_1_2 + 0.0011580086580087*G0_0_1_0_1_3 + 0.00095779220779224*G0_0_1_0_1_4 + 0.000389610389610405*G0_0_1_0_1_5 + 0.000919913419913451*G0_0_1_0_2_0 + 0.00101596320346324*G0_0_1_0_2_1 - 0.0111011904761909*G0_0_1_0_2_2 - 0.00414502164502178*G0_0_1_0_2_3 - 0.00662337662337685*G0_0_1_0_2_4 - 0.000557359307359328*G0_0_1_0_2_5 + 0.00107683982683986*G0_0_1_0_3_0 + 0.0011580086580087*G0_0_1_0_3_1 - 0.00414502164502178*G0_0_1_0_3_2 - 0.00458874458874473*G0_0_1_0_3_3 - 0.0040692640692642*G0_0_1_0_3_4 - 0.00103896103896107*G0_0_1_0_3_5 + 0.00390151515151527*G0_0_1_0_4_0 + 0.00095779220779224*G0_0_1_0_4_1 - 0.00662337662337685*G0_0_1_0_4_2 - 0.0040692640692642*G0_0_1_0_4_3 - 0.0108658008658012*G0_0_1_0_4_4 - 0.000800865800865831*G0_0_1_0_4_5 + 0.00486471861471877*G0_0_1_0_5_0 + 0.000389610389610405*G0_0_1_0_5_1 - 0.000557359307359328*G0_0_1_0_5_2 - 0.00103896103896107*G0_0_1_0_5_3 - 0.000800865800865831*G0_0_1_0_5_4 + 0.00285714285714294*G0_0_1_0_5_5 - 0.00145292207792212*G0_0_1_1_0_0 - 0.000238095238095245*G0_0_1_1_0_1 + 0.00101596320346324*G0_0_1_1_0_2 + 0.0011580086580087*G0_0_1_1_0_3 + 0.00095779220779224*G0_0_1_1_0_4 + 0.000389610389610405*G0_0_1_1_0_5 - 0.000238095238095245*G0_0_1_1_1_0 + 0.00676136363636384*G0_0_1_1_1_1 + 0.00153950216450222*G0_0_1_1_1_2 + 0.00246753246753255*G0_0_1_1_1_3 + 0.000963203463203494*G0_0_1_1_1_4 + 0.000292207792207802*G0_0_1_1_1_5 + 0.00101596320346324*G0_0_1_1_2_0 + 0.00153950216450222*G0_0_1_1_2_1 - 0.011696428571429*G0_0_1_1_2_2 - 0.00746753246753273*G0_0_1_1_2_3 - 0.0040584415584417*G0_0_1_1_2_4 - 0.000270562770562782*G0_0_1_1_2_5 + 0.0011580086580087*G0_0_1_1_3_0 + 0.00246753246753255*G0_0_1_1_3_1 - 0.00746753246753273*G0_0_1_1_3_2 - 0.0126406926406931*G0_0_1_1_3_3 - 0.00424242424242439*G0_0_1_1_3_4 - 0.00177489177489184*G0_0_1_1_3_5 + 0.000957792207792239*G0_0_1_1_4_0 + 0.000963203463203494*G0_0_1_1_4_1 - 0.0040584415584417*G0_0_1_1_4_2 - 0.00424242424242439*G0_0_1_1_4_3 - 0.00419913419913434*G0_0_1_1_4_4 - 0.00138528138528143*G0_0_1_1_4_5 + 0.000389610389610405*G0_0_1_1_5_0 + 0.000292207792207802*G0_0_1_1_5_1 - 0.000270562770562782*G0_0_1_1_5_2 - 0.00177489177489184*G0_0_1_1_5_3 - 0.00138528138528143*G0_0_1_1_5_4 - 0.00367965367965381*G0_0_1_1_5_5 + 0.000919913419913451*G0_0_1_2_0_0 + 0.00101596320346324*G0_0_1_2_0_1 - 0.0111011904761909*G0_0_1_2_0_2 - 0.00414502164502178*G0_0_1_2_0_3 - 0.00662337662337685*G0_0_1_2_0_4 - 0.000557359307359328*G0_0_1_2_0_5 + 0.00101596320346324*G0_0_1_2_1_0 + 0.00153950216450222*G0_0_1_2_1_1 - 0.011696428571429*G0_0_1_2_1_2 - 0.00746753246753273*G0_0_1_2_1_3 - 0.0040584415584417*G0_0_1_2_1_4 - 0.000270562770562782*G0_0_1_2_1_5 - 0.0111011904761909*G0_0_1_2_2_0 - 0.011696428571429*G0_0_1_2_2_1 + 0.166233766233772*G0_0_1_2_2_2 + 0.0501082251082269*G0_0_1_2_2_3 + 0.0469696969696986*G0_0_1_2_2_4 + 0.00323593073593088*G0_0_1_2_2_5 - 0.00414502164502178*G0_0_1_2_3_0 - 0.00746753246753273*G0_0_1_2_3_1 + 0.0501082251082269*G0_0_1_2_3_2 + 0.0379220779220793*G0_0_1_2_3_3 + 0.016406926406927*G0_0_1_2_3_4 + 0.00181818181818189*G0_0_1_2_3_5 - 0.00662337662337685*G0_0_1_2_4_0 - 0.0040584415584417*G0_0_1_2_4_1 + 0.0469696969696986*G0_0_1_2_4_2 + 0.016406926406927*G0_0_1_2_4_3 + 0.0331601731601743*G0_0_1_2_4_4 + 0.00164502164502171*G0_0_1_2_4_5 - 0.000557359307359328*G0_0_1_2_5_0 - 0.000270562770562782*G0_0_1_2_5_1 + 0.00323593073593088*G0_0_1_2_5_2 + 0.00181818181818189*G0_0_1_2_5_3 + 0.00164502164502171*G0_0_1_2_5_4 + 0.000735930735930763*G0_0_1_2_5_5 + 0.00107683982683986*G0_0_1_3_0_0 + 0.0011580086580087*G0_0_1_3_0_1 - 0.00414502164502178*G0_0_1_3_0_2 - 0.00458874458874473*G0_0_1_3_0_3 - 0.0040692640692642*G0_0_1_3_0_4 - 0.00103896103896107*G0_0_1_3_0_5 + 0.0011580086580087*G0_0_1_3_1_0 + 0.00246753246753255*G0_0_1_3_1_1 - 0.00746753246753273*G0_0_1_3_1_2 - 0.0126406926406931*G0_0_1_3_1_3 - 0.00424242424242439*G0_0_1_3_1_4 - 0.00177489177489184*G0_0_1_3_1_5 - 0.00414502164502178*G0_0_1_3_2_0 - 0.00746753246753273*G0_0_1_3_2_1 + 0.0501082251082269*G0_0_1_3_2_2 + 0.0379220779220793*G0_0_1_3_2_3 + 0.016406926406927*G0_0_1_3_2_4 + 0.00181818181818189*G0_0_1_3_2_5 - 0.00458874458874473*G0_0_1_3_3_0 - 0.0126406926406931*G0_0_1_3_3_1 + 0.0379220779220793*G0_0_1_3_3_2 + 0.0446753246753262*G0_0_1_3_3_3 + 0.0176623376623383*G0_0_1_3_3_4 + 0.00554112554112573*G0_0_1_3_3_5 - 0.0040692640692642*G0_0_1_3_4_0 - 0.00424242424242439*G0_0_1_3_4_1 + 0.016406926406927*G0_0_1_3_4_2 + 0.0176623376623383*G0_0_1_3_4_3 + 0.0165367965367971*G0_0_1_3_4_4 + 0.00484848484848502*G0_0_1_3_4_5 - 0.00103896103896107*G0_0_1_3_5_0 - 0.00177489177489184*G0_0_1_3_5_1 + 0.00181818181818189*G0_0_1_3_5_2 + 0.00554112554112573*G0_0_1_3_5_3 + 0.00484848484848502*G0_0_1_3_5_4 + 0.000606060606060628*G0_0_1_3_5_5 + 0.00390151515151527*G0_0_1_4_0_0 + 0.00095779220779224*G0_0_1_4_0_1 - 0.00662337662337685*G0_0_1_4_0_2 - 0.0040692640692642*G0_0_1_4_0_3 - 0.0108658008658012*G0_0_1_4_0_4 - 0.000800865800865831*G0_0_1_4_0_5 + 0.00095779220779224*G0_0_1_4_1_0 + 0.000963203463203495*G0_0_1_4_1_1 - 0.0040584415584417*G0_0_1_4_1_2 - 0.00424242424242439*G0_0_1_4_1_3 - 0.00419913419913434*G0_0_1_4_1_4 - 0.00138528138528143*G0_0_1_4_1_5 - 0.00662337662337685*G0_0_1_4_2_0 - 0.0040584415584417*G0_0_1_4_2_1 + 0.0469696969696986*G0_0_1_4_2_2 + 0.016406926406927*G0_0_1_4_2_3 + 0.0331601731601743*G0_0_1_4_2_4 + 0.00164502164502171*G0_0_1_4_2_5 - 0.0040692640692642*G0_0_1_4_3_0 - 0.00424242424242439*G0_0_1_4_3_1 + 0.016406926406927*G0_0_1_4_3_2 + 0.0176623376623383*G0_0_1_4_3_3 + 0.0165367965367971*G0_0_1_4_3_4 + 0.00484848484848502*G0_0_1_4_3_5 - 0.0108658008658012*G0_0_1_4_4_0 - 0.00419913419913434*G0_0_1_4_4_1 + 0.0331601731601743*G0_0_1_4_4_2 + 0.0165367965367971*G0_0_1_4_4_3 + 0.0345454545454557*G0_0_1_4_4_4 + 0.00510822510822529*G0_0_1_4_4_5 - 0.00080086580086583*G0_0_1_4_5_0 - 0.00138528138528143*G0_0_1_4_5_1 + 0.00164502164502171*G0_0_1_4_5_2 + 0.00484848484848502*G0_0_1_4_5_3 + 0.00510822510822529*G0_0_1_4_5_4 + 0.00129870129870135*G0_0_1_4_5_5 + 0.00486471861471877*G0_0_1_5_0_0 + 0.000389610389610405*G0_0_1_5_0_1 - 0.000557359307359328*G0_0_1_5_0_2 - 0.00103896103896107*G0_0_1_5_0_3 - 0.00080086580086583*G0_0_1_5_0_4 + 0.00285714285714294*G0_0_1_5_0_5 + 0.000389610389610405*G0_0_1_5_1_0 + 0.000292207792207802*G0_0_1_5_1_1 - 0.000270562770562782*G0_0_1_5_1_2 - 0.00177489177489184*G0_0_1_5_1_3 - 0.00138528138528143*G0_0_1_5_1_4 - 0.00367965367965381*G0_0_1_5_1_5 - 0.000557359307359328*G0_0_1_5_2_0 - 0.000270562770562782*G0_0_1_5_2_1 + 0.00323593073593088*G0_0_1_5_2_2 + 0.00181818181818189*G0_0_1_5_2_3 + 0.00164502164502171*G0_0_1_5_2_4 + 0.000735930735930763*G0_0_1_5_2_5 - 0.00103896103896107*G0_0_1_5_3_0 - 0.00177489177489184*G0_0_1_5_3_1 + 0.00181818181818189*G0_0_1_5_3_2 + 0.00554112554112573*G0_0_1_5_3_3 + 0.00484848484848502*G0_0_1_5_3_4 + 0.000606060606060627*G0_0_1_5_3_5 - 0.00080086580086583*G0_0_1_5_4_0 - 0.00138528138528143*G0_0_1_5_4_1 + 0.00164502164502171*G0_0_1_5_4_2 + 0.00484848484848502*G0_0_1_5_4_3 + 0.00510822510822529*G0_0_1_5_4_4 + 0.00129870129870135*G0_0_1_5_4_5 + 0.00285714285714294*G0_0_1_5_5_0 - 0.00367965367965381*G0_0_1_5_5_1 + 0.000735930735930763*G0_0_1_5_5_2 + 0.000606060606060627*G0_0_1_5_5_3 + 0.00129870129870135*G0_0_1_5_5_4 - 0.0418181818181833*G0_0_1_5_5_5 - 0.00611201298701322*G0_1_1_0_0_0 + 0.000698051948051975*G0_1_1_0_0_1 + 0.000771103896103923*G0_1_1_0_0_2 - 0.000162337662337667*G0_1_1_0_0_3 - 0.000649350649350673*G0_1_1_0_0_4 - 0.00633116883116906*G0_1_1_0_0_5 + 0.000698051948051975*G0_1_1_0_1_0 + 0.000511363636363654*G0_1_1_0_1_1 + 0.000292207792207801*G0_1_1_0_1_2 + 0.00113636363636367*G0_1_1_0_1_3 + 0.000681818181818204*G0_1_1_0_1_4 + 0.00337662337662349*G0_1_1_0_1_5 + 0.000771103896103923*G0_1_1_0_2_0 + 0.000292207792207801*G0_1_1_0_2_1 - 0.00230519480519489*G0_1_1_0_2_2 - 0.00246753246753255*G0_1_1_0_2_3 - 0.00175324675324681*G0_1_1_0_2_4 - 0.000162337662337667*G0_1_1_0_2_5 - 0.000162337662337667*G0_1_1_0_3_0 + 0.00113636363636367*G0_1_1_0_3_1 - 0.00246753246753255*G0_1_1_0_3_2 - 0.00025974025974027*G0_1_1_0_3_3 - 0.00103896103896107*G0_1_1_0_3_4 + 0.000649350649350668*G0_1_1_0_3_5 - 0.000649350649350672*G0_1_1_0_4_0 + 0.000681818181818204*G0_1_1_0_4_1 - 0.00175324675324681*G0_1_1_0_4_2 - 0.00103896103896107*G0_1_1_0_4_3 - 0.00155844155844161*G0_1_1_0_4_4 - 0.00103896103896108*G0_1_1_0_4_5 - 0.00633116883116906*G0_1_1_0_5_0 + 0.00337662337662349*G0_1_1_0_5_1 - 0.000162337662337667*G0_1_1_0_5_2 + 0.000649350649350668*G0_1_1_0_5_3 - 0.00103896103896108*G0_1_1_0_5_4 - 0.00506493506493527*G0_1_1_0_5_5 + 0.000698051948051975*G0_1_1_1_0_0 + 0.000511363636363654*G0_1_1_1_0_1 + 0.000292207792207801*G0_1_1_1_0_2 + 0.00113636363636367*G0_1_1_1_0_3 + 0.000681818181818204*G0_1_1_1_0_4 + 0.00337662337662349*G0_1_1_1_0_5 + 0.000511363636363654*G0_1_1_1_1_0 - 0.00438311688311705*G0_1_1_1_1_1 + 0.00138798701298706*G0_1_1_1_1_2 - 0.000454545454545476*G0_1_1_1_1_3 + 0.000292207792207803*G0_1_1_1_1_4 - 0.00538961038961058*G0_1_1_1_1_5 + 0.000292207792207801*G0_1_1_1_2_0 + 0.00138798701298706*G0_1_1_1_2_1 - 0.00449675324675341*G0_1_1_1_2_2 - 0.0039610389610391*G0_1_1_1_2_3 - 0.00155844155844161*G0_1_1_1_2_4 + 0.00113636363636367*G0_1_1_1_3_0 - 0.000454545454545476*G0_1_1_1_3_1 - 0.0039610389610391*G0_1_1_1_3_2 - 0.0140259740259745*G0_1_1_1_3_3 - 0.00285714285714296*G0_1_1_1_3_4 - 0.00233766233766242*G0_1_1_1_3_5 + 0.000681818181818204*G0_1_1_1_4_0 + 0.000292207792207803*G0_1_1_1_4_1 - 0.00155844155844161*G0_1_1_1_4_2 - 0.00285714285714296*G0_1_1_1_4_3 - 0.00233766233766242*G0_1_1_1_4_4 - 0.000649350649350673*G0_1_1_1_4_5 + 0.00337662337662349*G0_1_1_1_5_0 - 0.00538961038961058*G0_1_1_1_5_1 - 0.00233766233766242*G0_1_1_1_5_3 - 0.000649350649350673*G0_1_1_1_5_4 - 0.00467532467532484*G0_1_1_1_5_5 + 0.000771103896103923*G0_1_1_2_0_0 + 0.000292207792207801*G0_1_1_2_0_1 - 0.00230519480519489*G0_1_1_2_0_2 - 0.00246753246753255*G0_1_1_2_0_3 - 0.00175324675324681*G0_1_1_2_0_4 - 0.000162337662337667*G0_1_1_2_0_5 + 0.000292207792207801*G0_1_1_2_1_0 + 0.00138798701298706*G0_1_1_2_1_1 - 0.00449675324675341*G0_1_1_2_1_2 - 0.0039610389610391*G0_1_1_2_1_3 - 0.00155844155844161*G0_1_1_2_1_4 - 0.00230519480519489*G0_1_1_2_2_0 - 0.00449675324675341*G0_1_1_2_2_1 + 0.0304383116883128*G0_1_1_2_2_2 + 0.0194805194805202*G0_1_1_2_2_3 + 0.00941558441558477*G0_1_1_2_2_4 + 0.00103896103896108*G0_1_1_2_2_5 - 0.00246753246753255*G0_1_1_2_3_0 - 0.0039610389610391*G0_1_1_2_3_1 + 0.0194805194805202*G0_1_1_2_3_2 + 0.0296103896103906*G0_1_1_2_3_3 + 0.00805194805194833*G0_1_1_2_3_4 + 0.00285714285714296*G0_1_1_2_3_5 - 0.00175324675324681*G0_1_1_2_4_0 - 0.00155844155844161*G0_1_1_2_4_1 + 0.00941558441558477*G0_1_1_2_4_2 + 0.00805194805194833*G0_1_1_2_4_3 + 0.00623376623376647*G0_1_1_2_4_4 + 0.00103896103896107*G0_1_1_2_4_5 - 0.000162337662337667*G0_1_1_2_5_0 + 0.00103896103896108*G0_1_1_2_5_2 + 0.00285714285714296*G0_1_1_2_5_3 + 0.00103896103896107*G0_1_1_2_5_4 + 0.00376623376623389*G0_1_1_2_5_5 - 0.000162337662337667*G0_1_1_3_0_0 + 0.00113636363636367*G0_1_1_3_0_1 - 0.00246753246753255*G0_1_1_3_0_2 - 0.00025974025974027*G0_1_1_3_0_3 - 0.00103896103896107*G0_1_1_3_0_4 + 0.000649350649350668*G0_1_1_3_0_5 + 0.00113636363636367*G0_1_1_3_1_0 - 0.000454545454545475*G0_1_1_3_1_1 - 0.0039610389610391*G0_1_1_3_1_2 - 0.0140259740259745*G0_1_1_3_1_3 - 0.00285714285714296*G0_1_1_3_1_4 - 0.00233766233766242*G0_1_1_3_1_5 - 0.00246753246753255*G0_1_1_3_2_0 - 0.0039610389610391*G0_1_1_3_2_1 + 0.0194805194805202*G0_1_1_3_2_2 + 0.0296103896103906*G0_1_1_3_2_3 + 0.00805194805194833*G0_1_1_3_2_4 + 0.00285714285714296*G0_1_1_3_2_5 - 0.00025974025974027*G0_1_1_3_3_0 - 0.0140259740259745*G0_1_1_3_3_1 + 0.0296103896103906*G0_1_1_3_3_2 + 0.00935064935064974*G0_1_1_3_3_3 + 0.00623376623376646*G0_1_1_3_3_4 - 0.00519480519480536*G0_1_1_3_3_5 - 0.00103896103896107*G0_1_1_3_4_0 - 0.00285714285714296*G0_1_1_3_4_1 + 0.00805194805194833*G0_1_1_3_4_2 + 0.00623376623376646*G0_1_1_3_4_3 + 0.00675324675324699*G0_1_1_3_4_4 + 0.000649350649350668*G0_1_1_3_5_0 - 0.00233766233766242*G0_1_1_3_5_1 + 0.00285714285714296*G0_1_1_3_5_2 - 0.00519480519480536*G0_1_1_3_5_3 - 0.00883116883116911*G0_1_1_3_5_5 - 0.000649350649350672*G0_1_1_4_0_0 + 0.000681818181818204*G0_1_1_4_0_1 - 0.00175324675324681*G0_1_1_4_0_2 - 0.00103896103896107*G0_1_1_4_0_3 - 0.00155844155844161*G0_1_1_4_0_4 - 0.00103896103896108*G0_1_1_4_0_5 + 0.000681818181818204*G0_1_1_4_1_0 + 0.000292207792207803*G0_1_1_4_1_1 - 0.00155844155844161*G0_1_1_4_1_2 - 0.00285714285714296*G0_1_1_4_1_3 - 0.00233766233766242*G0_1_1_4_1_4 - 0.000649350649350673*G0_1_1_4_1_5 - 0.00175324675324681*G0_1_1_4_2_0 - 0.00155844155844161*G0_1_1_4_2_1 + 0.00941558441558477*G0_1_1_4_2_2 + 0.00805194805194833*G0_1_1_4_2_3 + 0.00623376623376647*G0_1_1_4_2_4 + 0.00103896103896107*G0_1_1_4_2_5 - 0.00103896103896107*G0_1_1_4_3_0 - 0.00285714285714296*G0_1_1_4_3_1 + 0.00805194805194833*G0_1_1_4_3_2 + 0.00623376623376646*G0_1_1_4_3_3 + 0.00675324675324699*G0_1_1_4_3_4 - 0.00155844155844161*G0_1_1_4_4_0 - 0.00233766233766242*G0_1_1_4_4_1 + 0.00623376623376647*G0_1_1_4_4_2 + 0.00675324675324699*G0_1_1_4_4_3 + 0.0140259740259745*G0_1_1_4_4_4 + 0.0025974025974027*G0_1_1_4_4_5 - 0.00103896103896108*G0_1_1_4_5_0 - 0.000649350649350673*G0_1_1_4_5_1 + 0.00103896103896107*G0_1_1_4_5_2 + 0.0025974025974027*G0_1_1_4_5_4 - 0.00623376623376642*G0_1_1_4_5_5 - 0.00633116883116906*G0_1_1_5_0_0 + 0.00337662337662349*G0_1_1_5_0_1 - 0.000162337662337667*G0_1_1_5_0_2 + 0.000649350649350668*G0_1_1_5_0_3 - 0.00103896103896108*G0_1_1_5_0_4 - 0.00506493506493527*G0_1_1_5_0_5 + 0.00337662337662349*G0_1_1_5_1_0 - 0.00538961038961058*G0_1_1_5_1_1 - 0.00233766233766242*G0_1_1_5_1_3 - 0.000649350649350673*G0_1_1_5_1_4 - 0.00467532467532484*G0_1_1_5_1_5 - 0.000162337662337667*G0_1_1_5_2_0 + 0.00103896103896108*G0_1_1_5_2_2 + 0.00285714285714296*G0_1_1_5_2_3 + 0.00103896103896107*G0_1_1_5_2_4 + 0.00376623376623389*G0_1_1_5_2_5 + 0.000649350649350668*G0_1_1_5_3_0 - 0.00233766233766242*G0_1_1_5_3_1 + 0.00285714285714296*G0_1_1_5_3_2 - 0.00519480519480536*G0_1_1_5_3_3 - 0.00883116883116911*G0_1_1_5_3_5 - 0.00103896103896108*G0_1_1_5_4_0 - 0.000649350649350673*G0_1_1_5_4_1 + 0.00103896103896107*G0_1_1_5_4_2 + 0.0025974025974027*G0_1_1_5_4_4 - 0.00623376623376642*G0_1_1_5_4_5 - 0.00506493506493527*G0_1_1_5_5_0 - 0.00467532467532484*G0_1_1_5_5_1 + 0.00376623376623389*G0_1_1_5_5_2 - 0.00883116883116911*G0_1_1_5_5_3 - 0.00623376623376642*G0_1_1_5_5_4 - 0.107532467532471*G0_1_1_5_5_5;
    A[62] = -A[42] - 0.0129626623376628*G0_1_1_0_0_0 + 0.00112283549783554*G0_1_1_0_0_1 + 0.000357142857142869*G0_1_1_0_0_2 - 0.00100108225108228*G0_1_1_0_0_3 - 0.00315476190476201*G0_1_1_0_0_4 - 0.0073971861471864*G0_1_1_0_0_5 + 0.00112283549783554*G0_1_1_0_1_0 + 0.00112283549783553*G0_1_1_0_1_1 - 0.000359848484848497*G0_1_1_0_1_2 + 0.000221861471861479*G0_1_1_0_1_3 + 0.000221861471861479*G0_1_1_0_1_4 + 0.00275974025974035*G0_1_1_0_1_5 + 0.000357142857142869*G0_1_1_0_2_0 - 0.000359848484848497*G0_1_1_0_2_1 + 0.00557359307359326*G0_1_1_0_2_2 + 0.000216450216450225*G0_1_1_0_2_3 + 0.00194805194805202*G0_1_1_0_2_4 - 0.000146103896103898*G0_1_1_0_2_5 - 0.00100108225108228*G0_1_1_0_3_0 + 0.000221861471861479*G0_1_1_0_3_1 + 0.000216450216450225*G0_1_1_0_3_2 + 0.00385281385281397*G0_1_1_0_3_3 + 0.00155844155844161*G0_1_1_0_3_4 + 0.00229437229437237*G0_1_1_0_3_5 - 0.00315476190476201*G0_1_1_0_4_0 + 0.000221861471861479*G0_1_1_0_4_1 + 0.00194805194805202*G0_1_1_0_4_2 + 0.00155844155844161*G0_1_1_0_4_3 - 0.00220779220779228*G0_1_1_0_4_4 - 0.000151515151515161*G0_1_1_0_4_5 - 0.0073971861471864*G0_1_1_0_5_0 + 0.00275974025974035*G0_1_1_0_5_1 - 0.000146103896103898*G0_1_1_0_5_2 + 0.00229437229437237*G0_1_1_0_5_3 - 0.000151515151515161*G0_1_1_0_5_4 - 0.00307359307359321*G0_1_1_0_5_5 + 0.00112283549783554*G0_1_1_1_0_0 + 0.00112283549783553*G0_1_1_1_0_1 - 0.000359848484848497*G0_1_1_1_0_2 + 0.00022186147186148*G0_1_1_1_0_3 + 0.000221861471861479*G0_1_1_1_0_4 + 0.00275974025974035*G0_1_1_1_0_5 + 0.00112283549783553*G0_1_1_1_1_0 - 0.0129626623376628*G0_1_1_1_1_1 + 0.00035714285714287*G0_1_1_1_1_2 - 0.00315476190476201*G0_1_1_1_1_3 - 0.00100108225108228*G0_1_1_1_1_4 - 0.00739718614718641*G0_1_1_1_1_5 - 0.000359848484848497*G0_1_1_1_2_0 + 0.000357142857142871*G0_1_1_1_2_1 + 0.00557359307359325*G0_1_1_1_2_2 + 0.00194805194805201*G0_1_1_1_2_3 + 0.000216450216450225*G0_1_1_1_2_4 - 0.0001461038961039*G0_1_1_1_2_5 + 0.000221861471861479*G0_1_1_1_3_0 - 0.00315476190476201*G0_1_1_1_3_1 + 0.00194805194805201*G0_1_1_1_3_2 - 0.0022077922077923*G0_1_1_1_3_3 + 0.00155844155844161*G0_1_1_1_3_4 - 0.000151515151515161*G0_1_1_1_3_5 + 0.000221861471861479*G0_1_1_1_4_0 - 0.00100108225108228*G0_1_1_1_4_1 + 0.000216450216450225*G0_1_1_1_4_2 + 0.00155844155844161*G0_1_1_1_4_3 + 0.00385281385281398*G0_1_1_1_4_4 + 0.00229437229437237*G0_1_1_1_4_5 + 0.00275974025974035*G0_1_1_1_5_0 - 0.00739718614718641*G0_1_1_1_5_1 - 0.0001461038961039*G0_1_1_1_5_2 - 0.000151515151515161*G0_1_1_1_5_3 + 0.00229437229437237*G0_1_1_1_5_4 - 0.00307359307359318*G0_1_1_1_5_5 + 0.000357142857142869*G0_1_1_2_0_0 - 0.000359848484848497*G0_1_1_2_0_1 + 0.00557359307359326*G0_1_1_2_0_2 + 0.000216450216450225*G0_1_1_2_0_3 + 0.00194805194805202*G0_1_1_2_0_4 - 0.000146103896103898*G0_1_1_2_0_5 - 0.000359848484848497*G0_1_1_2_1_0 + 0.000357142857142871*G0_1_1_2_1_1 + 0.00557359307359326*G0_1_1_2_1_2 + 0.00194805194805201*G0_1_1_2_1_3 + 0.000216450216450225*G0_1_1_2_1_4 - 0.000146103896103899*G0_1_1_2_1_5 + 0.00557359307359326*G0_1_1_2_2_0 + 0.00557359307359326*G0_1_1_2_2_1 - 0.114042207792212*G0_1_1_2_2_2 - 0.0240259740259749*G0_1_1_2_2_3 - 0.0240259740259749*G0_1_1_2_2_4 - 0.00173160173160181*G0_1_1_2_2_5 + 0.000216450216450225*G0_1_1_2_3_0 + 0.00194805194805201*G0_1_1_2_3_1 - 0.0240259740259749*G0_1_1_2_3_2 - 0.00173160173160179*G0_1_1_2_3_3 - 0.000865800865800901*G0_1_1_2_3_4 + 0.00303030303030313*G0_1_1_2_3_5 + 0.00194805194805202*G0_1_1_2_4_0 + 0.000216450216450225*G0_1_1_2_4_1 - 0.0240259740259749*G0_1_1_2_4_2 - 0.000865800865800901*G0_1_1_2_4_3 - 0.00173160173160182*G0_1_1_2_4_4 + 0.00303030303030313*G0_1_1_2_4_5 - 0.000146103896103898*G0_1_1_2_5_0 - 0.0001461038961039*G0_1_1_2_5_1 - 0.00173160173160181*G0_1_1_2_5_2 + 0.00303030303030313*G0_1_1_2_5_3 + 0.00303030303030313*G0_1_1_2_5_4 + 0.00489177489177506*G0_1_1_2_5_5 - 0.00100108225108228*G0_1_1_3_0_0 + 0.000221861471861479*G0_1_1_3_0_1 + 0.000216450216450225*G0_1_1_3_0_2 + 0.00385281385281397*G0_1_1_3_0_3 + 0.00155844155844161*G0_1_1_3_0_4 + 0.00229437229437237*G0_1_1_3_0_5 + 0.000221861471861479*G0_1_1_3_1_0 - 0.00315476190476201*G0_1_1_3_1_1 + 0.00194805194805201*G0_1_1_3_1_2 - 0.0022077922077923*G0_1_1_3_1_3 + 0.00155844155844161*G0_1_1_3_1_4 - 0.000151515151515161*G0_1_1_3_1_5 + 0.000216450216450225*G0_1_1_3_2_0 + 0.00194805194805201*G0_1_1_3_2_1 - 0.0240259740259749*G0_1_1_3_2_2 - 0.00173160173160179*G0_1_1_3_2_3 - 0.000865800865800901*G0_1_1_3_2_4 + 0.00303030303030313*G0_1_1_3_2_5 + 0.00385281385281397*G0_1_1_3_3_0 - 0.0022077922077923*G0_1_1_3_3_1 - 0.00173160173160179*G0_1_1_3_3_2 - 0.0324675324675335*G0_1_1_3_3_3 - 0.0108225108225112*G0_1_1_3_3_4 - 0.0137662337662342*G0_1_1_3_3_5 + 0.00155844155844161*G0_1_1_3_4_0 + 0.00155844155844161*G0_1_1_3_4_1 - 0.000865800865800901*G0_1_1_3_4_2 - 0.0108225108225112*G0_1_1_3_4_3 - 0.0108225108225112*G0_1_1_3_4_4 - 0.00917748917748948*G0_1_1_3_4_5 + 0.00229437229437237*G0_1_1_3_5_0 - 0.000151515151515161*G0_1_1_3_5_1 + 0.00303030303030313*G0_1_1_3_5_2 - 0.0137662337662342*G0_1_1_3_5_3 - 0.00917748917748948*G0_1_1_3_5_4 - 0.0143722943722948*G0_1_1_3_5_5 - 0.00315476190476201*G0_1_1_4_0_0 + 0.000221861471861479*G0_1_1_4_0_1 + 0.00194805194805202*G0_1_1_4_0_2 + 0.00155844155844161*G0_1_1_4_0_3 - 0.00220779220779228*G0_1_1_4_0_4 - 0.000151515151515161*G0_1_1_4_0_5 + 0.000221861471861479*G0_1_1_4_1_0 - 0.00100108225108228*G0_1_1_4_1_1 + 0.000216450216450225*G0_1_1_4_1_2 + 0.00155844155844161*G0_1_1_4_1_3 + 0.00385281385281398*G0_1_1_4_1_4 + 0.00229437229437237*G0_1_1_4_1_5 + 0.00194805194805202*G0_1_1_4_2_0 + 0.000216450216450225*G0_1_1_4_2_1 - 0.0240259740259749*G0_1_1_4_2_2 - 0.000865800865800901*G0_1_1_4_2_3 - 0.00173160173160182*G0_1_1_4_2_4 + 0.00303030303030313*G0_1_1_4_2_5 + 0.00155844155844161*G0_1_1_4_3_0 + 0.00155844155844161*G0_1_1_4_3_1 - 0.000865800865800901*G0_1_1_4_3_2 - 0.0108225108225112*G0_1_1_4_3_3 - 0.0108225108225112*G0_1_1_4_3_4 - 0.00917748917748948*G0_1_1_4_3_5 - 0.00220779220779228*G0_1_1_4_4_0 + 0.00385281385281398*G0_1_1_4_4_1 - 0.00173160173160182*G0_1_1_4_4_2 - 0.0108225108225112*G0_1_1_4_4_3 - 0.0324675324675336*G0_1_1_4_4_4 - 0.0137662337662342*G0_1_1_4_4_5 - 0.000151515151515161*G0_1_1_4_5_0 + 0.00229437229437237*G0_1_1_4_5_1 + 0.00303030303030313*G0_1_1_4_5_2 - 0.00917748917748948*G0_1_1_4_5_3 - 0.0137662337662342*G0_1_1_4_5_4 - 0.0143722943722948*G0_1_1_4_5_5 - 0.00739718614718641*G0_1_1_5_0_0 + 0.00275974025974035*G0_1_1_5_0_1 - 0.000146103896103898*G0_1_1_5_0_2 + 0.00229437229437237*G0_1_1_5_0_3 - 0.000151515151515161*G0_1_1_5_0_4 - 0.00307359307359321*G0_1_1_5_0_5 + 0.00275974025974035*G0_1_1_5_1_0 - 0.00739718614718641*G0_1_1_5_1_1 - 0.0001461038961039*G0_1_1_5_1_2 - 0.000151515151515161*G0_1_1_5_1_3 + 0.00229437229437237*G0_1_1_5_1_4 - 0.00307359307359318*G0_1_1_5_1_5 - 0.000146103896103898*G0_1_1_5_2_0 - 0.000146103896103899*G0_1_1_5_2_1 - 0.00173160173160181*G0_1_1_5_2_2 + 0.00303030303030313*G0_1_1_5_2_3 + 0.00303030303030313*G0_1_1_5_2_4 + 0.00489177489177506*G0_1_1_5_2_5 + 0.00229437229437237*G0_1_1_5_3_0 - 0.000151515151515161*G0_1_1_5_3_1 + 0.00303030303030313*G0_1_1_5_3_2 - 0.0137662337662342*G0_1_1_5_3_3 - 0.00917748917748948*G0_1_1_5_3_4 - 0.0143722943722948*G0_1_1_5_3_5 - 0.000151515151515161*G0_1_1_5_4_0 + 0.00229437229437237*G0_1_1_5_4_1 + 0.00303030303030313*G0_1_1_5_4_2 - 0.00917748917748948*G0_1_1_5_4_3 - 0.0137662337662342*G0_1_1_5_4_4 - 0.0143722943722948*G0_1_1_5_4_5 - 0.00307359307359321*G0_1_1_5_5_0 - 0.00307359307359318*G0_1_1_5_5_1 + 0.00489177489177506*G0_1_1_5_5_2 - 0.0143722943722948*G0_1_1_5_5_3 - 0.0143722943722948*G0_1_1_5_5_4 - 0.0800000000000027*G0_1_1_5_5_5;
    A[65] = -A[45] + 0.0100446428571432*G0_1_0_0_0_0 - 0.000231331168831181*G0_1_0_0_0_1 - 0.00165584415584421*G0_1_0_0_0_3 - 0.00681818181818203*G0_1_0_0_0_4 + 0.00267857142857155*G0_1_0_0_0_5 - 0.000231331168831181*G0_1_0_0_1_0 + 0.000572240259740274*G0_1_0_0_1_1 - 0.00012175324675325*G0_1_0_0_1_2 - 0.00165584415584421*G0_1_0_0_1_3 - 0.00194805194805201*G0_1_0_0_1_4 - 0.00224025974025982*G0_1_0_0_1_5 - 0.00012175324675325*G0_1_0_0_2_1 + 0.00328733766233777*G0_1_0_0_2_2 + 0.000487012987013004*G0_1_0_0_2_3 + 0.00487012987013003*G0_1_0_0_2_4 - 0.000487012987013003*G0_1_0_0_2_5 - 0.00165584415584421*G0_1_0_0_3_0 - 0.00165584415584421*G0_1_0_0_3_1 + 0.000487012987013004*G0_1_0_0_3_2 + 0.000974025974026006*G0_1_0_0_3_3 + 0.00720779220779243*G0_1_0_0_3_4 + 0.00428571428571442*G0_1_0_0_3_5 - 0.00681818181818203*G0_1_0_0_4_0 - 0.00194805194805201*G0_1_0_0_4_1 + 0.00487012987013003*G0_1_0_0_4_2 + 0.00720779220779243*G0_1_0_0_4_3 - 0.00175324675324687*G0_1_0_0_4_4 + 0.00487012987013003*G0_1_0_0_4_5 + 0.00267857142857155*G0_1_0_0_5_0 - 0.00224025974025982*G0_1_0_0_5_1 - 0.000487012987013003*G0_1_0_0_5_2 + 0.00428571428571442*G0_1_0_0_5_3 + 0.00487012987013003*G0_1_0_0_5_4 + 0.00857142857142888*G0_1_0_0_5_5 - 0.000231331168831181*G0_1_0_1_0_0 + 0.000572240259740274*G0_1_0_1_0_1 - 0.00012175324675325*G0_1_0_1_0_2 - 0.00165584415584421*G0_1_0_1_0_3 - 0.00194805194805201*G0_1_0_1_0_4 - 0.00224025974025982*G0_1_0_1_0_5 + 0.000572240259740274*G0_1_0_1_1_0 - 0.000255681818181765*G0_1_0_1_1_1 - 0.000681818181818186*G0_1_0_1_1_3 - 0.00487012987013003*G0_1_0_1_1_4 - 0.00199675324675329*G0_1_0_1_1_5 - 0.00012175324675325*G0_1_0_1_2_0 + 0.00547889610389629*G0_1_0_1_2_2 - 0.000974025974026013*G0_1_0_1_2_3 - 0.00243506493506502*G0_1_0_1_2_4 - 0.00194805194805201*G0_1_0_1_2_5 - 0.00165584415584421*G0_1_0_1_3_0 - 0.000681818181818186*G0_1_0_1_3_1 - 0.000974025974026013*G0_1_0_1_3_2 + 0.00876623376623407*G0_1_0_1_3_3 + 0.0130519480519485*G0_1_0_1_3_4 + 0.00720779220779245*G0_1_0_1_3_5 - 0.00194805194805201*G0_1_0_1_4_0 - 0.00487012987013003*G0_1_0_1_4_1 - 0.00243506493506502*G0_1_0_1_4_2 + 0.0130519480519485*G0_1_0_1_4_3 + 0.0372077922077934*G0_1_0_1_4_4 + 0.0136363636363641*G0_1_0_1_4_5 - 0.00224025974025982*G0_1_0_1_5_0 - 0.00199675324675329*G0_1_0_1_5_1 - 0.00194805194805201*G0_1_0_1_5_2 + 0.00720779220779245*G0_1_0_1_5_3 + 0.0136363636363641*G0_1_0_1_5_4 + 0.00623376623376645*G0_1_0_1_5_5 - 0.00012175324675325*G0_1_0_2_0_1 + 0.00328733766233777*G0_1_0_2_0_2 + 0.000487012987013004*G0_1_0_2_0_3 + 0.00487012987013003*G0_1_0_2_0_4 - 0.000487012987013003*G0_1_0_2_0_5 - 0.00012175324675325*G0_1_0_2_1_0 + 0.00547889610389629*G0_1_0_2_1_2 - 0.000974025974026012*G0_1_0_2_1_3 - 0.00243506493506502*G0_1_0_2_1_4 - 0.00194805194805201*G0_1_0_2_1_5 + 0.00328733766233777*G0_1_0_2_2_0 + 0.00547889610389629*G0_1_0_2_2_1 - 0.0854707792207822*G0_1_0_2_2_2 - 0.0204545454545462*G0_1_0_2_2_3 - 0.0204545454545462*G0_1_0_2_2_4 - 0.00292207792207803*G0_1_0_2_2_5 + 0.000487012987013004*G0_1_0_2_3_0 - 0.000974025974026012*G0_1_0_2_3_1 - 0.0204545454545462*G0_1_0_2_3_2 - 0.00389610389610403*G0_1_0_2_3_3 + 0.00389610389610401*G0_1_0_2_3_4 + 0.00487012987013003*G0_1_0_2_3_5 + 0.00487012987013003*G0_1_0_2_4_0 - 0.00243506493506502*G0_1_0_2_4_1 - 0.0204545454545462*G0_1_0_2_4_2 + 0.00389610389610402*G0_1_0_2_4_3 + 0.0194805194805201*G0_1_0_2_4_4 + 0.0107142857142861*G0_1_0_2_4_5 - 0.000487012987013003*G0_1_0_2_5_0 - 0.00194805194805201*G0_1_0_2_5_1 - 0.00292207792207803*G0_1_0_2_5_2 + 0.00487012987013003*G0_1_0_2_5_3 + 0.0107142857142861*G0_1_0_2_5_4 + 0.00584415584415603*G0_1_0_2_5_5 - 0.00165584415584421*G0_1_0_3_0_0 - 0.00165584415584421*G0_1_0_3_0_1 + 0.000487012987013004*G0_1_0_3_0_2 + 0.000974025974026006*G0_1_0_3_0_3 + 0.00720779220779243*G0_1_0_3_0_4 + 0.00428571428571442*G0_1_0_3_0_5 - 0.00165584415584421*G0_1_0_3_1_0 - 0.000681818181818186*G0_1_0_3_1_1 - 0.000974025974026013*G0_1_0_3_1_2 + 0.00876623376623407*G0_1_0_3_1_3 + 0.0130519480519485*G0_1_0_3_1_4 + 0.00720779220779245*G0_1_0_3_1_5 + 0.000487012987013004*G0_1_0_3_2_0 - 0.000974025974026013*G0_1_0_3_2_1 - 0.0204545454545462*G0_1_0_3_2_2 - 0.00389610389610403*G0_1_0_3_2_3 + 0.00389610389610402*G0_1_0_3_2_4 + 0.00487012987013003*G0_1_0_3_2_5 + 0.000974025974026006*G0_1_0_3_3_0 + 0.00876623376623407*G0_1_0_3_3_1 - 0.00389610389610403*G0_1_0_3_3_2 + 0.0981818181818218*G0_1_0_3_3_3 - 0.0280519480519489*G0_1_0_3_3_4 - 0.011688311688312*G0_1_0_3_3_5 + 0.00720779220779243*G0_1_0_3_4_0 + 0.0130519480519485*G0_1_0_3_4_1 + 0.00389610389610402*G0_1_0_3_4_2 - 0.0280519480519489*G0_1_0_3_4_3 - 0.0888311688311717*G0_1_0_3_4_4 - 0.035844155844157*G0_1_0_3_4_5 + 0.00428571428571442*G0_1_0_3_5_0 + 0.00720779220779246*G0_1_0_3_5_1 + 0.00487012987013002*G0_1_0_3_5_2 - 0.011688311688312*G0_1_0_3_5_3 - 0.035844155844157*G0_1_0_3_5_4 - 0.0202597402597409*G0_1_0_3_5_5 - 0.00681818181818203*G0_1_0_4_0_0 - 0.00194805194805201*G0_1_0_4_0_1 + 0.00487012987013003*G0_1_0_4_0_2 + 0.00720779220779243*G0_1_0_4_0_3 - 0.00175324675324687*G0_1_0_4_0_4 + 0.00487012987013003*G0_1_0_4_0_5 - 0.00194805194805201*G0_1_0_4_1_0 - 0.00487012987013003*G0_1_0_4_1_1 - 0.00243506493506502*G0_1_0_4_1_2 + 0.0130519480519485*G0_1_0_4_1_3 + 0.0372077922077934*G0_1_0_4_1_4 + 0.0136363636363641*G0_1_0_4_1_5 + 0.00487012987013003*G0_1_0_4_2_0 - 0.00243506493506502*G0_1_0_4_2_1 - 0.0204545454545462*G0_1_0_4_2_2 + 0.00389610389610402*G0_1_0_4_2_3 + 0.0194805194805201*G0_1_0_4_2_4 + 0.0107142857142861*G0_1_0_4_2_5 + 0.00720779220779243*G0_1_0_4_3_0 + 0.0130519480519485*G0_1_0_4_3_1 + 0.00389610389610402*G0_1_0_4_3_2 - 0.0280519480519489*G0_1_0_4_3_3 - 0.0888311688311717*G0_1_0_4_3_4 - 0.035844155844157*G0_1_0_4_3_5 - 0.00175324675324687*G0_1_0_4_4_0 + 0.0372077922077934*G0_1_0_4_4_1 + 0.0194805194805201*G0_1_0_4_4_2 - 0.0888311688311717*G0_1_0_4_4_3 - 0.448831168831183*G0_1_0_4_4_4 - 0.095844155844159*G0_1_0_4_4_5 + 0.00487012987013003*G0_1_0_4_5_0 + 0.0136363636363641*G0_1_0_4_5_1 + 0.0107142857142861*G0_1_0_4_5_2 - 0.035844155844157*G0_1_0_4_5_3 - 0.095844155844159*G0_1_0_4_5_4 - 0.0389610389610403*G0_1_0_4_5_5 + 0.00267857142857155*G0_1_0_5_0_0 - 0.00224025974025982*G0_1_0_5_0_1 - 0.000487012987013003*G0_1_0_5_0_2 + 0.00428571428571442*G0_1_0_5_0_3 + 0.00487012987013003*G0_1_0_5_0_4 + 0.00857142857142888*G0_1_0_5_0_5 - 0.00224025974025982*G0_1_0_5_1_0 - 0.00199675324675329*G0_1_0_5_1_1 - 0.00194805194805201*G0_1_0_5_1_2 + 0.00720779220779245*G0_1_0_5_1_3 + 0.0136363636363641*G0_1_0_5_1_4 + 0.00623376623376645*G0_1_0_5_1_5 - 0.000487012987013003*G0_1_0_5_2_0 - 0.00194805194805201*G0_1_0_5_2_1 - 0.00292207792207803*G0_1_0_5_2_2 + 0.00487012987013003*G0_1_0_5_2_3 + 0.0107142857142861*G0_1_0_5_2_4 + 0.00584415584415603*G0_1_0_5_2_5 + 0.00428571428571442*G0_1_0_5_3_0 + 0.00720779220779246*G0_1_0_5_3_1 + 0.00487012987013003*G0_1_0_5_3_2 - 0.011688311688312*G0_1_0_5_3_3 - 0.035844155844157*G0_1_0_5_3_4 - 0.0202597402597409*G0_1_0_5_3_5 + 0.00487012987013003*G0_1_0_5_4_0 + 0.0136363636363641*G0_1_0_5_4_1 + 0.0107142857142861*G0_1_0_5_4_2 - 0.035844155844157*G0_1_0_5_4_3 - 0.095844155844159*G0_1_0_5_4_4 - 0.0389610389610403*G0_1_0_5_4_5 + 0.00857142857142888*G0_1_0_5_5_0 + 0.00623376623376645*G0_1_0_5_5_1 + 0.00584415584415603*G0_1_0_5_5_2 - 0.0202597402597409*G0_1_0_5_5_3 - 0.0389610389610403*G0_1_0_5_5_4 - 0.109760551948056*G0_1_1_0_0_0 + 0.00976461038961073*G0_1_1_0_0_1 + 0.00451704545454562*G0_1_1_0_0_2 - 0.00375000000000011*G0_1_1_0_0_3 - 0.0224025974025982*G0_1_1_0_0_4 - 0.0431006493506509*G0_1_1_0_0_5 + 0.00976461038961073*G0_1_1_0_1_0 - 0.00152191558441564*G0_1_1_0_1_1 - 0.000560064935064955*G0_1_1_0_1_2 - 0.00175324675324681*G0_1_1_0_1_3 - 0.000925324675324697*G0_1_1_0_1_4 + 0.00584415584415606*G0_1_1_0_1_5 + 0.00451704545454562*G0_1_1_0_2_0 - 0.000560064935064955*G0_1_1_0_2_1 + 0.00304383116883127*G0_1_1_0_2_2 + 0.000243506493506502*G0_1_1_0_2_3 + 0.00340909090909103*G0_1_1_0_2_4 + 0.00180194805194812*G0_1_1_0_2_5 - 0.00375000000000011*G0_1_1_0_3_0 - 0.00175324675324681*G0_1_1_0_3_1 + 0.000243506493506502*G0_1_1_0_3_2 + 0.00487012987013002*G0_1_1_0_3_3 + 0.00935064935064964*G0_1_1_0_3_4 + 0.00389610389610401*G0_1_1_0_3_5 - 0.0224025974025982*G0_1_1_0_4_0 - 0.000925324675324697*G0_1_1_0_4_1 + 0.00340909090909103*G0_1_1_0_4_2 + 0.00935064935064964*G0_1_1_0_4_3 + 0.010714285714286*G0_1_1_0_4_4 - 0.00175324675324684*G0_1_1_0_4_5 - 0.0431006493506509*G0_1_1_0_5_0 + 0.00584415584415606*G0_1_1_0_5_1 + 0.00180194805194812*G0_1_1_0_5_2 + 0.00389610389610401*G0_1_1_0_5_3 - 0.00175324675324684*G0_1_1_0_5_4 - 0.0374025974025988*G0_1_1_0_5_5 + 0.00976461038961073*G0_1_1_1_0_0 - 0.00152191558441564*G0_1_1_1_0_1 - 0.000560064935064955*G0_1_1_1_0_2 - 0.00175324675324681*G0_1_1_1_0_3 - 0.000925324675324696*G0_1_1_1_0_4 + 0.00584415584415606*G0_1_1_1_0_5 - 0.00152191558441564*G0_1_1_1_1_0 + 0.00372564935064949*G0_1_1_1_1_1 - 0.000206980519480527*G0_1_1_1_1_2 - 0.000438311688311691*G0_1_1_1_1_3 - 0.00438311688311703*G0_1_1_1_1_4 - 0.00199675324675331*G0_1_1_1_1_5 - 0.000560064935064955*G0_1_1_1_2_0 - 0.000206980519480528*G0_1_1_1_2_1 + 0.00511363636363653*G0_1_1_1_2_2 - 0.000487012987013006*G0_1_1_1_2_3 - 0.00121753246753251*G0_1_1_1_2_4 - 0.00224025974025982*G0_1_1_1_2_5 - 0.00175324675324681*G0_1_1_1_3_0 - 0.000438311688311691*G0_1_1_1_3_1 - 0.000487012987013006*G0_1_1_1_3_2 + 0.00974025974026006*G0_1_1_1_3_3 + 0.0122727272727277*G0_1_1_1_3_4 + 0.00798701298701325*G0_1_1_1_3_5 - 0.000925324675324697*G0_1_1_1_4_0 - 0.00438311688311703*G0_1_1_1_4_1 - 0.00121753246753251*G0_1_1_1_4_2 + 0.0122727272727277*G0_1_1_1_4_3 + 0.0292207792207802*G0_1_1_1_4_4 + 0.0132467532467537*G0_1_1_1_4_5 + 0.00584415584415606*G0_1_1_1_5_0 - 0.00199675324675331*G0_1_1_1_5_1 - 0.00224025974025982*G0_1_1_1_5_2 + 0.00798701298701325*G0_1_1_1_5_3 + 0.0132467532467537*G0_1_1_1_5_4 + 0.0237662337662346*G0_1_1_1_5_5 + 0.00451704545454562*G0_1_1_2_0_0 - 0.000560064935064955*G0_1_1_2_0_1 + 0.00304383116883127*G0_1_1_2_0_2 + 0.000243506493506502*G0_1_1_2_0_3 + 0.00340909090909103*G0_1_1_2_0_4 + 0.00180194805194812*G0_1_1_2_0_5 - 0.000560064935064955*G0_1_1_2_1_0 - 0.000206980519480528*G0_1_1_2_1_1 + 0.00511363636363653*G0_1_1_2_1_2 - 0.000487012987013006*G0_1_1_2_1_3 - 0.00121753246753251*G0_1_1_2_1_4 - 0.00224025974025982*G0_1_1_2_1_5 + 0.00304383116883127*G0_1_1_2_2_0 + 0.00511363636363653*G0_1_1_2_2_1 - 0.0814529220779249*G0_1_1_2_2_2 - 0.0197240259740266*G0_1_1_2_2_3 - 0.0168019480519486*G0_1_1_2_2_4 - 0.00267857142857153*G0_1_1_2_2_5 + 0.000243506493506502*G0_1_1_2_3_0 - 0.000487012987013006*G0_1_1_2_3_1 - 0.0197240259740266*G0_1_1_2_3_2 - 0.00292207792207803*G0_1_1_2_3_3 + 0.001948051948052*G0_1_1_2_3_4 + 0.00487012987013003*G0_1_1_2_3_5 + 0.00340909090909103*G0_1_1_2_4_0 - 0.00121753246753251*G0_1_1_2_4_1 - 0.0168019480519486*G0_1_1_2_4_2 + 0.001948051948052*G0_1_1_2_4_3 + 0.00487012987013001*G0_1_1_2_4_4 + 0.00779220779220805*G0_1_1_2_4_5 + 0.00180194805194812*G0_1_1_2_5_0 - 0.00224025974025982*G0_1_1_2_5_1 - 0.00267857142857153*G0_1_1_2_5_2 + 0.00487012987013002*G0_1_1_2_5_3 + 0.00779220779220805*G0_1_1_2_5_4 + 0.00974025974026008*G0_1_1_2_5_5 - 0.00375000000000011*G0_1_1_3_0_0 - 0.00175324675324681*G0_1_1_3_0_1 + 0.000243506493506502*G0_1_1_3_0_2 + 0.00487012987013002*G0_1_1_3_0_3 + 0.00935064935064964*G0_1_1_3_0_4 + 0.00389610389610401*G0_1_1_3_0_5 - 0.00175324675324681*G0_1_1_3_1_0 - 0.00043831168831169*G0_1_1_3_1_1 - 0.000487012987013006*G0_1_1_3_1_2 + 0.00974025974026006*G0_1_1_3_1_3 + 0.0122727272727277*G0_1_1_3_1_4 + 0.00798701298701325*G0_1_1_3_1_5 + 0.000243506493506502*G0_1_1_3_2_0 - 0.000487012987013006*G0_1_1_3_2_1 - 0.0197240259740266*G0_1_1_3_2_2 - 0.00292207792207802*G0_1_1_3_2_3 + 0.001948051948052*G0_1_1_3_2_4 + 0.00487012987013003*G0_1_1_3_2_5 + 0.00487012987013002*G0_1_1_3_3_0 + 0.00974025974026006*G0_1_1_3_3_1 - 0.00292207792207802*G0_1_1_3_3_2 + 0.0677922077922104*G0_1_1_3_3_3 - 0.0342857142857153*G0_1_1_3_3_4 - 0.0194805194805201*G0_1_1_3_3_5 + 0.00935064935064964*G0_1_1_3_4_0 + 0.0122727272727277*G0_1_1_3_4_1 + 0.001948051948052*G0_1_1_3_4_2 - 0.0342857142857153*G0_1_1_3_4_3 - 0.0771428571428596*G0_1_1_3_4_4 - 0.0342857142857154*G0_1_1_3_4_5 + 0.00389610389610401*G0_1_1_3_5_0 + 0.00798701298701325*G0_1_1_3_5_1 + 0.00487012987013002*G0_1_1_3_5_2 - 0.0194805194805201*G0_1_1_3_5_3 - 0.0342857142857154*G0_1_1_3_5_4 - 0.0272727272727282*G0_1_1_3_5_5 - 0.0224025974025982*G0_1_1_4_0_0 - 0.000925324675324697*G0_1_1_4_0_1 + 0.00340909090909103*G0_1_1_4_0_2 + 0.00935064935064964*G0_1_1_4_0_3 + 0.010714285714286*G0_1_1_4_0_4 - 0.00175324675324684*G0_1_1_4_0_5 - 0.000925324675324697*G0_1_1_4_1_0 - 0.00438311688311703*G0_1_1_4_1_1 - 0.00121753246753251*G0_1_1_4_1_2 + 0.0122727272727277*G0_1_1_4_1_3 + 0.0292207792207802*G0_1_1_4_1_4 + 0.0132467532467537*G0_1_1_4_1_5 + 0.00340909090909103*G0_1_1_4_2_0 - 0.00121753246753251*G0_1_1_4_2_1 - 0.0168019480519486*G0_1_1_4_2_2 + 0.001948051948052*G0_1_1_4_2_3 + 0.00487012987013001*G0_1_1_4_2_4 + 0.00779220779220805*G0_1_1_4_2_5 + 0.00935064935064964*G0_1_1_4_3_0 + 0.0122727272727277*G0_1_1_4_3_1 + 0.001948051948052*G0_1_1_4_3_2 - 0.0342857142857153*G0_1_1_4_3_3 - 0.0771428571428596*G0_1_1_4_3_4 - 0.0342857142857154*G0_1_1_4_3_5 + 0.010714285714286*G0_1_1_4_4_0 + 0.0292207792207802*G0_1_1_4_4_1 + 0.00487012987013002*G0_1_1_4_4_2 - 0.0771428571428596*G0_1_1_4_4_3 - 0.317922077922088*G0_1_1_4_4_4 - 0.0740259740259765*G0_1_1_4_4_5 - 0.00175324675324684*G0_1_1_4_5_0 + 0.0132467532467537*G0_1_1_4_5_1 + 0.00779220779220805*G0_1_1_4_5_2 - 0.0342857142857154*G0_1_1_4_5_3 - 0.0740259740259765*G0_1_1_4_5_4 - 0.0459740259740275*G0_1_1_4_5_5 - 0.0431006493506509*G0_1_1_5_0_0 + 0.00584415584415606*G0_1_1_5_0_1 + 0.00180194805194812*G0_1_1_5_0_2 + 0.00389610389610401*G0_1_1_5_0_3 - 0.00175324675324684*G0_1_1_5_0_4 - 0.0374025974025988*G0_1_1_5_0_5 + 0.00584415584415606*G0_1_1_5_1_0 - 0.00199675324675331*G0_1_1_5_1_1 - 0.00224025974025982*G0_1_1_5_1_2 + 0.00798701298701325*G0_1_1_5_1_3 + 0.0132467532467537*G0_1_1_5_1_4 + 0.0237662337662346*G0_1_1_5_1_5 + 0.00180194805194812*G0_1_1_5_2_0 - 0.00224025974025982*G0_1_1_5_2_1 - 0.00267857142857153*G0_1_1_5_2_2 + 0.00487012987013002*G0_1_1_5_2_3 + 0.00779220779220805*G0_1_1_5_2_4 + 0.00974025974026008*G0_1_1_5_2_5 + 0.00389610389610401*G0_1_1_5_3_0 + 0.00798701298701325*G0_1_1_5_3_1 + 0.00487012987013003*G0_1_1_5_3_2 - 0.0194805194805201*G0_1_1_5_3_3 - 0.0342857142857154*G0_1_1_5_3_4 - 0.0272727272727282*G0_1_1_5_3_5 - 0.00175324675324684*G0_1_1_5_4_0 + 0.0132467532467537*G0_1_1_5_4_1 + 0.00779220779220805*G0_1_1_5_4_2 - 0.0342857142857154*G0_1_1_5_4_3 - 0.0740259740259765*G0_1_1_5_4_4 - 0.0459740259740275*G0_1_1_5_4_5 - 0.0374025974025988*G0_1_1_5_5_0 + 0.0237662337662346*G0_1_1_5_5_1 + 0.00974025974026008*G0_1_1_5_5_2 - 0.0272727272727282*G0_1_1_5_5_3 - 0.0459740259740275*G0_1_1_5_5_4 - 0.128571428571433*G0_1_1_5_5_5;
    A[6] = -A[4] + 0.0668019480519504*G0_0_1_0_0_0 - 0.00531114718614737*G0_0_1_0_0_1 - 0.00252435064935074*G0_0_1_0_0_2 + 0.00134199134199138*G0_0_1_0_0_3 + 0.010119047619048*G0_0_1_0_0_4 + 0.0233225108225117*G0_0_1_0_0_5 - 0.00531114718614737*G0_0_1_0_1_0 + 0.000533008658008677*G0_0_1_0_1_1 + 0.000201569264069272*G0_0_1_0_1_2 + 0.000508658008658024*G0_0_1_0_1_3 - 0.00305194805194816*G0_0_1_0_1_5 - 0.00252435064935074*G0_0_1_0_2_0 + 0.000201569264069272*G0_0_1_0_2_1 - 0.000703463203463227*G0_0_1_0_2_2 - 0.000974025974026011*G0_0_1_0_2_5 + 0.00134199134199138*G0_0_1_0_3_0 + 0.000508658008658024*G0_0_1_0_3_1 - 0.000735930735930764*G0_0_1_0_3_3 - 0.00272727272727281*G0_0_1_0_3_4 - 0.000735930735930759*G0_0_1_0_3_5 + 0.010119047619048*G0_0_1_0_4_0 - 0.00272727272727281*G0_0_1_0_4_3 - 0.00753246753246776*G0_0_1_0_4_4 + 0.00190476190476198*G0_0_1_0_4_5 + 0.0233225108225117*G0_0_1_0_5_0 - 0.00305194805194816*G0_0_1_0_5_1 - 0.000974025974026011*G0_0_1_0_5_2 - 0.000735930735930759*G0_0_1_0_5_3 + 0.00190476190476198*G0_0_1_0_5_4 + 0.0206060606060614*G0_0_1_0_5_5 - 0.00531114718614737*G0_0_1_1_0_0 + 0.000533008658008677*G0_0_1_1_0_1 + 0.000201569264069272*G0_0_1_1_0_2 + 0.000508658008658024*G0_0_1_1_0_3 - 0.00305194805194816*G0_0_1_1_0_5 + 0.000533008658008677*G0_0_1_1_1_0 + 0.0074837662337665*G0_0_1_1_1_1 - 0.000162337662337668*G0_0_1_1_1_2 + 0.00067099567099569*G0_0_1_1_1_3 + 0.000854978354978382*G0_0_1_1_1_4 + 0.00160173160173167*G0_0_1_1_1_5 + 0.000201569264069272*G0_0_1_1_2_0 - 0.000162337662337668*G0_0_1_1_2_1 - 0.00119047619047623*G0_0_1_1_2_2 + 0.000487012987013005*G0_0_1_1_2_3 + 0.000681818181818205*G0_0_1_1_2_5 + 0.000508658008658024*G0_0_1_1_3_0 + 0.00067099567099569*G0_0_1_1_3_1 + 0.000487012987013005*G0_0_1_1_3_2 - 0.00441558441558457*G0_0_1_1_3_3 - 0.00272727272727282*G0_0_1_1_3_4 - 0.00238095238095246*G0_0_1_1_3_5 + 0.000854978354978382*G0_0_1_1_4_1 - 0.00272727272727282*G0_0_1_1_4_3 - 0.00385281385281398*G0_0_1_1_4_4 - 0.00307359307359318*G0_0_1_1_4_5 - 0.00305194805194816*G0_0_1_1_5_0 + 0.00160173160173167*G0_0_1_1_5_1 + 0.000681818181818205*G0_0_1_1_5_2 - 0.00238095238095246*G0_0_1_1_5_3 - 0.00307359307359318*G0_0_1_1_5_4 - 0.0105627705627709*G0_0_1_1_5_5 - 0.00252435064935074*G0_0_1_2_0_0 + 0.000201569264069272*G0_0_1_2_0_1 - 0.000703463203463227*G0_0_1_2_0_2 - 0.000974025974026011*G0_0_1_2_0_5 + 0.000201569264069272*G0_0_1_2_1_0 - 0.000162337662337668*G0_0_1_2_1_1 - 0.00119047619047623*G0_0_1_2_1_2 + 0.000487012987013005*G0_0_1_2_1_3 + 0.000681818181818205*G0_0_1_2_1_5 - 0.000703463203463227*G0_0_1_2_2_0 - 0.00119047619047623*G0_0_1_2_2_1 + 0.0183441558441565*G0_0_1_2_2_2 + 0.0043019480519482*G0_0_1_2_2_3 + 0.0028409090909092*G0_0_1_2_2_4 + 0.000514069264069285*G0_0_1_2_2_5 + 0.000487012987013005*G0_0_1_2_3_1 + 0.0043019480519482*G0_0_1_2_3_2 + 0.00173160173160179*G0_0_1_2_3_3 - 0.000108225108225109*G0_0_1_2_3_4 - 0.00108225108225112*G0_0_1_2_3_5 + 0.0028409090909092*G0_0_1_2_4_2 - 0.000108225108225109*G0_0_1_2_4_3 + 0.0036796536796538*G0_0_1_2_4_4 - 0.00108225108225112*G0_0_1_2_4_5 - 0.000974025974026011*G0_0_1_2_5_0 + 0.000681818181818205*G0_0_1_2_5_1 + 0.000514069264069285*G0_0_1_2_5_2 - 0.00108225108225112*G0_0_1_2_5_3 - 0.00108225108225112*G0_0_1_2_5_4 - 0.00216450216450224*G0_0_1_2_5_5 + 0.00134199134199138*G0_0_1_3_0_0 + 0.000508658008658024*G0_0_1_3_0_1 - 0.000735930735930764*G0_0_1_3_0_3 - 0.00272727272727281*G0_0_1_3_0_4 - 0.000735930735930759*G0_0_1_3_0_5 + 0.000508658008658024*G0_0_1_3_1_0 + 0.00067099567099569*G0_0_1_3_1_1 + 0.000487012987013005*G0_0_1_3_1_2 - 0.00441558441558457*G0_0_1_3_1_3 - 0.00272727272727282*G0_0_1_3_1_4 - 0.00238095238095246*G0_0_1_3_1_5 + 0.000487012987013005*G0_0_1_3_2_1 + 0.0043019480519482*G0_0_1_3_2_2 + 0.00173160173160179*G0_0_1_3_2_3 - 0.000108225108225109*G0_0_1_3_2_4 - 0.00108225108225112*G0_0_1_3_2_5 - 0.000735930735930764*G0_0_1_3_3_0 - 0.00441558441558457*G0_0_1_3_3_1 + 0.00173160173160179*G0_0_1_3_3_2 - 0.0400000000000014*G0_0_1_3_3_3 + 0.00692640692640714*G0_0_1_3_3_4 + 0.00363636363636374*G0_0_1_3_3_5 - 0.00272727272727281*G0_0_1_3_4_0 - 0.00272727272727282*G0_0_1_3_4_1 - 0.000108225108225109*G0_0_1_3_4_2 + 0.00692640692640714*G0_0_1_3_4_3 + 0.0131601731601736*G0_0_1_3_4_4 + 0.00761904761904787*G0_0_1_3_4_5 - 0.000735930735930759*G0_0_1_3_5_0 - 0.00238095238095246*G0_0_1_3_5_1 - 0.00108225108225112*G0_0_1_3_5_2 + 0.00363636363636374*G0_0_1_3_5_3 + 0.00761904761904787*G0_0_1_3_5_4 + 0.00580086580086599*G0_0_1_3_5_5 + 0.010119047619048*G0_0_1_4_0_0 - 0.00272727272727281*G0_0_1_4_0_3 - 0.00753246753246776*G0_0_1_4_0_4 + 0.00190476190476198*G0_0_1_4_0_5 + 0.000854978354978382*G0_0_1_4_1_1 - 0.00272727272727282*G0_0_1_4_1_3 - 0.00385281385281398*G0_0_1_4_1_4 - 0.00307359307359318*G0_0_1_4_1_5 + 0.0028409090909092*G0_0_1_4_2_2 - 0.000108225108225109*G0_0_1_4_2_3 + 0.0036796536796538*G0_0_1_4_2_4 - 0.00108225108225112*G0_0_1_4_2_5 - 0.00272727272727281*G0_0_1_4_3_0 - 0.00272727272727282*G0_0_1_4_3_1 - 0.000108225108225109*G0_0_1_4_3_2 + 0.00692640692640714*G0_0_1_4_3_3 + 0.0131601731601736*G0_0_1_4_3_4 + 0.00761904761904787*G0_0_1_4_3_5 - 0.00753246753246776*G0_0_1_4_4_0 - 0.00385281385281398*G0_0_1_4_4_1 + 0.0036796536796538*G0_0_1_4_4_2 + 0.0131601731601736*G0_0_1_4_4_3 + 0.0161038961038966*G0_0_1_4_4_4 + 0.0098701298701302*G0_0_1_4_4_5 + 0.00190476190476198*G0_0_1_4_5_0 - 0.00307359307359318*G0_0_1_4_5_1 - 0.00108225108225112*G0_0_1_4_5_2 + 0.00761904761904787*G0_0_1_4_5_3 + 0.0098701298701302*G0_0_1_4_5_4 + 0.0104761904761908*G0_0_1_4_5_5 + 0.0233225108225117*G0_0_1_5_0_0 - 0.00305194805194816*G0_0_1_5_0_1 - 0.000974025974026011*G0_0_1_5_0_2 - 0.000735930735930759*G0_0_1_5_0_3 + 0.00190476190476198*G0_0_1_5_0_4 + 0.0206060606060614*G0_0_1_5_0_5 - 0.00305194805194816*G0_0_1_5_1_0 + 0.00160173160173167*G0_0_1_5_1_1 + 0.000681818181818205*G0_0_1_5_1_2 - 0.00238095238095246*G0_0_1_5_1_3 - 0.00307359307359318*G0_0_1_5_1_4 - 0.0105627705627709*G0_0_1_5_1_5 - 0.000974025974026011*G0_0_1_5_2_0 + 0.000681818181818205*G0_0_1_5_2_1 + 0.000514069264069285*G0_0_1_5_2_2 - 0.00108225108225112*G0_0_1_5_2_3 - 0.00108225108225112*G0_0_1_5_2_4 - 0.00216450216450224*G0_0_1_5_2_5 - 0.000735930735930759*G0_0_1_5_3_0 - 0.00238095238095246*G0_0_1_5_3_1 - 0.00108225108225112*G0_0_1_5_3_2 + 0.00363636363636374*G0_0_1_5_3_3 + 0.00761904761904787*G0_0_1_5_3_4 + 0.00580086580086599*G0_0_1_5_3_5 + 0.00190476190476198*G0_0_1_5_4_0 - 0.00307359307359318*G0_0_1_5_4_1 - 0.00108225108225112*G0_0_1_5_4_2 + 0.00761904761904787*G0_0_1_5_4_3 + 0.0098701298701302*G0_0_1_5_4_4 + 0.0104761904761908*G0_0_1_5_4_5 + 0.0206060606060614*G0_0_1_5_5_0 - 0.0105627705627709*G0_0_1_5_5_1 - 0.00216450216450224*G0_0_1_5_5_2 + 0.00580086580086599*G0_0_1_5_5_3 + 0.0104761904761908*G0_0_1_5_5_4 + 0.0215584415584423*G0_0_1_5_5_5 + 0.0668019480519504*G0_1_1_0_0_0 - 0.00531114718614737*G0_1_1_0_0_1 - 0.00252435064935074*G0_1_1_0_0_2 + 0.00134199134199138*G0_1_1_0_0_3 + 0.010119047619048*G0_1_1_0_0_4 + 0.0233225108225117*G0_1_1_0_0_5 - 0.00531114718614737*G0_1_1_0_1_0 + 0.000533008658008677*G0_1_1_0_1_1 + 0.000201569264069272*G0_1_1_0_1_2 + 0.000508658008658024*G0_1_1_0_1_3 - 0.00305194805194817*G0_1_1_0_1_5 - 0.00252435064935074*G0_1_1_0_2_0 + 0.000201569264069272*G0_1_1_0_2_1 - 0.000703463203463227*G0_1_1_0_2_2 - 0.000974025974026011*G0_1_1_0_2_5 + 0.00134199134199138*G0_1_1_0_3_0 + 0.000508658008658024*G0_1_1_0_3_1 - 0.000735930735930762*G0_1_1_0_3_3 - 0.00272727272727281*G0_1_1_0_3_4 - 0.000735930735930759*G0_1_1_0_3_5 + 0.010119047619048*G0_1_1_0_4_0 - 0.00272727272727281*G0_1_1_0_4_3 - 0.00753246753246776*G0_1_1_0_4_4 + 0.00190476190476198*G0_1_1_0_4_5 + 0.0233225108225117*G0_1_1_0_5_0 - 0.00305194805194817*G0_1_1_0_5_1 - 0.000974025974026011*G0_1_1_0_5_2 - 0.000735930735930759*G0_1_1_0_5_3 + 0.00190476190476198*G0_1_1_0_5_4 + 0.0206060606060614*G0_1_1_0_5_5 - 0.00531114718614737*G0_1_1_1_0_0 + 0.000533008658008677*G0_1_1_1_0_1 + 0.000201569264069272*G0_1_1_1_0_2 + 0.000508658008658024*G0_1_1_1_0_3 - 0.00305194805194817*G0_1_1_1_0_5 + 0.000533008658008677*G0_1_1_1_1_0 + 0.00748376623376649*G0_1_1_1_1_1 - 0.000162337662337667*G0_1_1_1_1_2 + 0.000670995670995688*G0_1_1_1_1_3 + 0.000854978354978383*G0_1_1_1_1_4 + 0.00160173160173167*G0_1_1_1_1_5 + 0.000201569264069272*G0_1_1_1_2_0 - 0.000162337662337667*G0_1_1_1_2_1 - 0.00119047619047623*G0_1_1_1_2_2 + 0.000487012987013005*G0_1_1_1_2_3 + 0.000681818181818205*G0_1_1_1_2_5 + 0.000508658008658024*G0_1_1_1_3_0 + 0.000670995670995689*G0_1_1_1_3_1 + 0.000487012987013005*G0_1_1_1_3_2 - 0.00441558441558457*G0_1_1_1_3_3 - 0.00272727272727282*G0_1_1_1_3_4 - 0.00238095238095246*G0_1_1_1_3_5 + 0.000854978354978383*G0_1_1_1_4_1 - 0.00272727272727282*G0_1_1_1_4_3 - 0.00385281385281398*G0_1_1_1_4_4 - 0.00307359307359318*G0_1_1_1_4_5 - 0.00305194805194817*G0_1_1_1_5_0 + 0.00160173160173167*G0_1_1_1_5_1 + 0.000681818181818205*G0_1_1_1_5_2 - 0.00238095238095246*G0_1_1_1_5_3 - 0.00307359307359318*G0_1_1_1_5_4 - 0.0105627705627709*G0_1_1_1_5_5 - 0.00252435064935074*G0_1_1_2_0_0 + 0.000201569264069272*G0_1_1_2_0_1 - 0.000703463203463227*G0_1_1_2_0_2 - 0.000974025974026011*G0_1_1_2_0_5 + 0.000201569264069272*G0_1_1_2_1_0 - 0.000162337662337667*G0_1_1_2_1_1 - 0.00119047619047623*G0_1_1_2_1_2 + 0.000487012987013005*G0_1_1_2_1_3 + 0.000681818181818205*G0_1_1_2_1_5 - 0.000703463203463227*G0_1_1_2_2_0 - 0.00119047619047623*G0_1_1_2_2_1 + 0.0183441558441565*G0_1_1_2_2_2 + 0.0043019480519482*G0_1_1_2_2_3 + 0.0028409090909092*G0_1_1_2_2_4 + 0.000514069264069285*G0_1_1_2_2_5 + 0.000487012987013005*G0_1_1_2_3_1 + 0.0043019480519482*G0_1_1_2_3_2 + 0.00173160173160179*G0_1_1_2_3_3 - 0.00010822510822511*G0_1_1_2_3_4 - 0.00108225108225112*G0_1_1_2_3_5 + 0.0028409090909092*G0_1_1_2_4_2 - 0.000108225108225109*G0_1_1_2_4_3 + 0.0036796536796538*G0_1_1_2_4_4 - 0.00108225108225112*G0_1_1_2_4_5 - 0.000974025974026011*G0_1_1_2_5_0 + 0.000681818181818205*G0_1_1_2_5_1 + 0.000514069264069285*G0_1_1_2_5_2 - 0.00108225108225112*G0_1_1_2_5_3 - 0.00108225108225112*G0_1_1_2_5_4 - 0.00216450216450224*G0_1_1_2_5_5 + 0.00134199134199138*G0_1_1_3_0_0 + 0.000508658008658024*G0_1_1_3_0_1 - 0.000735930735930762*G0_1_1_3_0_3 - 0.00272727272727281*G0_1_1_3_0_4 - 0.000735930735930759*G0_1_1_3_0_5 + 0.000508658008658024*G0_1_1_3_1_0 + 0.000670995670995689*G0_1_1_3_1_1 + 0.000487012987013005*G0_1_1_3_1_2 - 0.00441558441558457*G0_1_1_3_1_3 - 0.00272727272727282*G0_1_1_3_1_4 - 0.00238095238095246*G0_1_1_3_1_5 + 0.000487012987013005*G0_1_1_3_2_1 + 0.0043019480519482*G0_1_1_3_2_2 + 0.00173160173160179*G0_1_1_3_2_3 - 0.000108225108225109*G0_1_1_3_2_4 - 0.00108225108225112*G0_1_1_3_2_5 - 0.000735930735930762*G0_1_1_3_3_0 - 0.00441558441558457*G0_1_1_3_3_1 + 0.00173160173160179*G0_1_1_3_3_2 - 0.0400000000000015*G0_1_1_3_3_3 + 0.00692640692640714*G0_1_1_3_3_4 + 0.00363636363636374*G0_1_1_3_3_5 - 0.00272727272727281*G0_1_1_3_4_0 - 0.00272727272727282*G0_1_1_3_4_1 - 0.00010822510822511*G0_1_1_3_4_2 + 0.00692640692640714*G0_1_1_3_4_3 + 0.0131601731601736*G0_1_1_3_4_4 + 0.00761904761904787*G0_1_1_3_4_5 - 0.000735930735930759*G0_1_1_3_5_0 - 0.00238095238095246*G0_1_1_3_5_1 - 0.00108225108225112*G0_1_1_3_5_2 + 0.00363636363636374*G0_1_1_3_5_3 + 0.00761904761904787*G0_1_1_3_5_4 + 0.00580086580086599*G0_1_1_3_5_5 + 0.010119047619048*G0_1_1_4_0_0 - 0.00272727272727281*G0_1_1_4_0_3 - 0.00753246753246776*G0_1_1_4_0_4 + 0.00190476190476198*G0_1_1_4_0_5 + 0.000854978354978383*G0_1_1_4_1_1 - 0.00272727272727282*G0_1_1_4_1_3 - 0.00385281385281398*G0_1_1_4_1_4 - 0.00307359307359318*G0_1_1_4_1_5 + 0.0028409090909092*G0_1_1_4_2_2 - 0.000108225108225109*G0_1_1_4_2_3 + 0.0036796536796538*G0_1_1_4_2_4 - 0.00108225108225112*G0_1_1_4_2_5 - 0.00272727272727281*G0_1_1_4_3_0 - 0.00272727272727282*G0_1_1_4_3_1 - 0.00010822510822511*G0_1_1_4_3_2 + 0.00692640692640714*G0_1_1_4_3_3 + 0.0131601731601736*G0_1_1_4_3_4 + 0.00761904761904787*G0_1_1_4_3_5 - 0.00753246753246776*G0_1_1_4_4_0 - 0.00385281385281398*G0_1_1_4_4_1 + 0.0036796536796538*G0_1_1_4_4_2 + 0.0131601731601736*G0_1_1_4_4_3 + 0.0161038961038966*G0_1_1_4_4_4 + 0.00987012987013021*G0_1_1_4_4_5 + 0.00190476190476198*G0_1_1_4_5_0 - 0.00307359307359318*G0_1_1_4_5_1 - 0.00108225108225112*G0_1_1_4_5_2 + 0.00761904761904787*G0_1_1_4_5_3 + 0.00987012987013021*G0_1_1_4_5_4 + 0.0104761904761908*G0_1_1_4_5_5 + 0.0233225108225117*G0_1_1_5_0_0 - 0.00305194805194817*G0_1_1_5_0_1 - 0.000974025974026011*G0_1_1_5_0_2 - 0.000735930735930759*G0_1_1_5_0_3 + 0.00190476190476198*G0_1_1_5_0_4 + 0.0206060606060614*G0_1_1_5_0_5 - 0.00305194805194817*G0_1_1_5_1_0 + 0.00160173160173167*G0_1_1_5_1_1 + 0.000681818181818205*G0_1_1_5_1_2 - 0.00238095238095246*G0_1_1_5_1_3 - 0.00307359307359318*G0_1_1_5_1_4 - 0.0105627705627709*G0_1_1_5_1_5 - 0.000974025974026011*G0_1_1_5_2_0 + 0.000681818181818205*G0_1_1_5_2_1 + 0.000514069264069285*G0_1_1_5_2_2 - 0.00108225108225112*G0_1_1_5_2_3 - 0.00108225108225112*G0_1_1_5_2_4 - 0.00216450216450224*G0_1_1_5_2_5 - 0.000735930735930759*G0_1_1_5_3_0 - 0.00238095238095246*G0_1_1_5_3_1 - 0.00108225108225112*G0_1_1_5_3_2 + 0.00363636363636374*G0_1_1_5_3_3 + 0.00761904761904787*G0_1_1_5_3_4 + 0.00580086580086599*G0_1_1_5_3_5 + 0.00190476190476198*G0_1_1_5_4_0 - 0.00307359307359318*G0_1_1_5_4_1 - 0.00108225108225112*G0_1_1_5_4_2 + 0.00761904761904787*G0_1_1_5_4_3 + 0.00987012987013021*G0_1_1_5_4_4 + 0.0104761904761908*G0_1_1_5_4_5 + 0.0206060606060614*G0_1_1_5_5_0 - 0.0105627705627709*G0_1_1_5_5_1 - 0.00216450216450224*G0_1_1_5_5_2 + 0.00580086580086599*G0_1_1_5_5_3 + 0.0104761904761908*G0_1_1_5_5_4 + 0.0215584415584424*G0_1_1_5_5_5;
    A[17] = -A[14] + 0.0226379870129877*G0_0_0_0_0_0 - 0.00096590909090912*G0_0_0_0_0_1 - 0.00151515151515156*G0_0_0_0_0_2 + 0.000346320346320355*G0_0_0_0_0_3 + 0.00891774891774921*G0_0_0_0_0_4 + 0.00325757575757587*G0_0_0_0_0_5 - 0.00096590909090912*G0_0_0_0_1_0 - 0.00184523809523815*G0_0_0_0_1_1 + 0.000273268398268408*G0_0_0_0_1_2 - 0.000790043290043317*G0_0_0_0_1_3 - 0.000259740259740269*G0_0_0_0_1_4 + 0.000194805194805198*G0_0_0_0_1_5 - 0.00151515151515156*G0_0_0_0_2_0 + 0.000273268398268408*G0_0_0_0_2_1 - 0.00170183982683989*G0_0_0_0_2_2 - 0.00311688311688322*G0_0_0_0_2_4 - 0.000411255411255426*G0_0_0_0_2_5 + 0.000346320346320355*G0_0_0_0_3_0 - 0.000790043290043317*G0_0_0_0_3_1 - 0.000173160173160179*G0_0_0_0_3_4 + 0.000129870129870136*G0_0_0_0_3_5 + 0.00891774891774921*G0_0_0_0_4_0 - 0.000259740259740269*G0_0_0_0_4_1 - 0.00311688311688322*G0_0_0_0_4_2 - 0.000173160173160179*G0_0_0_0_4_3 + 0.00471861471861487*G0_0_0_0_4_4 + 0.00134199134199139*G0_0_0_0_4_5 + 0.00325757575757587*G0_0_0_0_5_0 + 0.000194805194805198*G0_0_0_0_5_1 - 0.000411255411255427*G0_0_0_0_5_2 + 0.000129870129870136*G0_0_0_0_5_3 + 0.00134199134199139*G0_0_0_0_5_4 + 0.00441558441558458*G0_0_0_0_5_5 - 0.00096590909090912*G0_0_0_1_0_0 - 0.00184523809523815*G0_0_0_1_0_1 + 0.000273268398268408*G0_0_0_1_0_2 - 0.000790043290043317*G0_0_0_1_0_3 - 0.000259740259740269*G0_0_0_1_0_4 + 0.000194805194805198*G0_0_0_1_0_5 - 0.00184523809523815*G0_0_0_1_1_0 + 0.058116883116885*G0_0_0_1_1_1 - 0.00403679653679667*G0_0_0_1_1_2 + 0.0173701298701305*G0_0_0_1_1_3 + 0.000768398268398288*G0_0_0_1_1_4 + 0.00730519480519508*G0_0_0_1_1_5 + 0.000273268398268408*G0_0_0_1_2_0 - 0.00403679653679667*G0_0_0_1_2_1 - 0.000349025974025987*G0_0_0_1_2_2 - 0.00201298701298708*G0_0_0_1_2_3 + 0.000119047619047619*G0_0_0_1_2_5 - 0.000790043290043317*G0_0_0_1_3_0 + 0.0173701298701305*G0_0_0_1_3_1 - 0.00201298701298708*G0_0_0_1_3_2 + 0.0161904761904768*G0_0_0_1_3_3 + 0.00134199134199141*G0_0_0_1_3_5 - 0.000259740259740269*G0_0_0_1_4_0 + 0.000768398268398288*G0_0_0_1_4_1 - 0.00264069264069273*G0_0_0_1_4_4 - 0.00177489177489183*G0_0_0_1_4_5 + 0.000194805194805198*G0_0_0_1_5_0 + 0.00730519480519508*G0_0_0_1_5_1 + 0.000119047619047619*G0_0_0_1_5_2 + 0.00134199134199141*G0_0_0_1_5_3 - 0.00177489177489183*G0_0_0_1_5_4 - 0.00718614718614743*G0_0_0_1_5_5 - 0.00151515151515156*G0_0_0_2_0_0 + 0.000273268398268408*G0_0_0_2_0_1 - 0.00170183982683989*G0_0_0_2_0_2 - 0.00311688311688322*G0_0_0_2_0_4 - 0.000411255411255427*G0_0_0_2_0_5 + 0.000273268398268408*G0_0_0_2_1_0 - 0.00403679653679667*G0_0_0_2_1_1 - 0.000349025974025987*G0_0_0_2_1_2 - 0.00201298701298709*G0_0_0_2_1_3 + 0.000119047619047619*G0_0_0_2_1_5 - 0.00170183982683989*G0_0_0_2_2_0 - 0.000349025974025987*G0_0_0_2_2_1 + 0.024366883116884*G0_0_0_2_2_2 + 0.00345238095238109*G0_0_0_2_2_3 + 0.00985930735930772*G0_0_0_2_2_4 + 0.000800865800865833*G0_0_0_2_2_5 - 0.00201298701298709*G0_0_0_2_3_1 + 0.00345238095238109*G0_0_0_2_3_2 - 0.00805194805194833*G0_0_0_2_3_3 - 0.00168831168831175*G0_0_0_2_3_5 - 0.00311688311688322*G0_0_0_2_4_0 + 0.00985930735930772*G0_0_0_2_4_2 + 0.0051082251082253*G0_0_0_2_4_4 - 0.00147186147186152*G0_0_0_2_4_5 - 0.000411255411255427*G0_0_0_2_5_0 + 0.000119047619047619*G0_0_0_2_5_1 + 0.000800865800865833*G0_0_0_2_5_2 - 0.00168831168831175*G0_0_0_2_5_3 - 0.00147186147186152*G0_0_0_2_5_4 - 0.00199134199134206*G0_0_0_2_5_5 + 0.000346320346320355*G0_0_0_3_0_0 - 0.000790043290043317*G0_0_0_3_0_1 - 0.000173160173160179*G0_0_0_3_0_4 + 0.000129870129870136*G0_0_0_3_0_5 - 0.000790043290043317*G0_0_0_3_1_0 + 0.0173701298701305*G0_0_0_3_1_1 - 0.00201298701298708*G0_0_0_3_1_2 + 0.0161904761904768*G0_0_0_3_1_3 + 0.00134199134199141*G0_0_0_3_1_5 - 0.00201298701298709*G0_0_0_3_2_1 + 0.00345238095238109*G0_0_0_3_2_2 - 0.00805194805194833*G0_0_0_3_2_3 - 0.00168831168831175*G0_0_0_3_2_5 + 0.0161904761904768*G0_0_0_3_3_1 - 0.00805194805194833*G0_0_0_3_3_2 + 0.000259740259740276*G0_0_0_3_3_3 - 0.000259740259740275*G0_0_0_3_3_4 + 0.00320346320346332*G0_0_0_3_3_5 - 0.000173160173160179*G0_0_0_3_4_0 - 0.000259740259740276*G0_0_0_3_4_3 + 0.00562770562770581*G0_0_0_3_4_4 + 0.00329004329004339*G0_0_0_3_4_5 + 0.000129870129870136*G0_0_0_3_5_0 + 0.00134199134199141*G0_0_0_3_5_1 - 0.00168831168831175*G0_0_0_3_5_2 + 0.00320346320346331*G0_0_0_3_5_3 + 0.00329004329004339*G0_0_0_3_5_4 + 0.00372294372294384*G0_0_0_3_5_5 + 0.00891774891774921*G0_0_0_4_0_0 - 0.000259740259740269*G0_0_0_4_0_1 - 0.00311688311688322*G0_0_0_4_0_2 - 0.000173160173160179*G0_0_0_4_0_3 + 0.00471861471861487*G0_0_0_4_0_4 + 0.00134199134199139*G0_0_0_4_0_5 - 0.000259740259740269*G0_0_0_4_1_0 + 0.000768398268398288*G0_0_0_4_1_1 - 0.00264069264069273*G0_0_0_4_1_4 - 0.00177489177489183*G0_0_0_4_1_5 - 0.00311688311688322*G0_0_0_4_2_0 + 0.00985930735930772*G0_0_0_4_2_2 + 0.0051082251082253*G0_0_0_4_2_4 - 0.00147186147186152*G0_0_0_4_2_5 - 0.000173160173160179*G0_0_0_4_3_0 - 0.000259740259740274*G0_0_0_4_3_3 + 0.00562770562770581*G0_0_0_4_3_4 + 0.00329004329004339*G0_0_0_4_3_5 + 0.00471861471861487*G0_0_0_4_4_0 - 0.00264069264069273*G0_0_0_4_4_1 + 0.0051082251082253*G0_0_0_4_4_2 + 0.00562770562770581*G0_0_0_4_4_3 + 0.053246753246755*G0_0_0_4_4_4 + 0.00822510822510849*G0_0_0_4_4_5 + 0.00134199134199139*G0_0_0_4_5_0 - 0.00177489177489183*G0_0_0_4_5_1 - 0.00147186147186152*G0_0_0_4_5_2 + 0.00329004329004339*G0_0_0_4_5_3 + 0.00822510822510849*G0_0_0_4_5_4 + 0.00753246753246778*G0_0_0_4_5_5 + 0.00325757575757587*G0_0_0_5_0_0 + 0.000194805194805198*G0_0_0_5_0_1 - 0.000411255411255427*G0_0_0_5_0_2 + 0.000129870129870136*G0_0_0_5_0_3 + 0.00134199134199139*G0_0_0_5_0_4 + 0.00441558441558458*G0_0_0_5_0_5 + 0.000194805194805198*G0_0_0_5_1_0 + 0.00730519480519508*G0_0_0_5_1_1 + 0.000119047619047619*G0_0_0_5_1_2 + 0.00134199134199141*G0_0_0_5_1_3 - 0.00177489177489183*G0_0_0_5_1_4 - 0.00718614718614743*G0_0_0_5_1_5 - 0.000411255411255427*G0_0_0_5_2_0 + 0.000119047619047619*G0_0_0_5_2_1 + 0.000800865800865833*G0_0_0_5_2_2 - 0.00168831168831175*G0_0_0_5_2_3 - 0.00147186147186152*G0_0_0_5_2_4 - 0.00199134199134206*G0_0_0_5_2_5 + 0.000129870129870136*G0_0_0_5_3_0 + 0.00134199134199141*G0_0_0_5_3_1 - 0.00168831168831175*G0_0_0_5_3_2 + 0.00320346320346332*G0_0_0_5_3_3 + 0.00329004329004339*G0_0_0_5_3_4 + 0.00372294372294384*G0_0_0_5_3_5 + 0.00134199134199139*G0_0_0_5_4_0 - 0.00177489177489183*G0_0_0_5_4_1 - 0.00147186147186152*G0_0_0_5_4_2 + 0.00329004329004339*G0_0_0_5_4_3 + 0.00822510822510849*G0_0_0_5_4_4 + 0.00753246753246778*G0_0_0_5_4_5 + 0.00441558441558458*G0_0_0_5_5_0 - 0.00718614718614743*G0_0_0_5_5_1 - 0.00199134199134206*G0_0_0_5_5_2 + 0.00372294372294385*G0_0_0_5_5_3 + 0.00753246753246778*G0_0_0_5_5_4 + 0.0049350649350651*G0_0_0_5_5_5 - 0.00172889610389617*G0_0_1_0_0_0 - 0.000616883116883138*G0_0_1_0_0_1 + 0.000186688311688319*G0_0_1_0_0_2 - 0.000454545454545466*G0_0_1_0_0_3 - 0.000941558441558474*G0_0_1_0_0_4 - 0.000194805194805194*G0_0_1_0_0_5 - 0.000616883116883138*G0_0_1_0_1_0 + 0.00219155844155852*G0_0_1_0_1_1 - 0.000909090909090939*G0_0_1_0_1_3 - 0.000194805194805202*G0_0_1_0_1_4 + 0.00220779220779228*G0_0_1_0_1_5 + 0.000186688311688319*G0_0_1_0_2_0 - 0.00018668831168832*G0_0_1_0_2_2 + 0.000454545454545469*G0_0_1_0_2_3 - 0.000454545454545471*G0_0_1_0_2_5 - 0.000454545454545466*G0_0_1_0_3_0 - 0.000909090909090939*G0_0_1_0_3_1 + 0.000454545454545469*G0_0_1_0_3_2 + 0.00207792207792213*G0_0_1_0_3_3 + 0.00129870129870134*G0_0_1_0_3_4 + 0.00181818181818188*G0_0_1_0_3_5 - 0.000941558441558474*G0_0_1_0_4_0 - 0.000194805194805202*G0_0_1_0_4_1 + 0.00129870129870134*G0_0_1_0_4_3 - 0.000389610389610407*G0_0_1_0_4_4 + 0.00129870129870134*G0_0_1_0_4_5 - 0.000194805194805193*G0_0_1_0_5_0 + 0.00220779220779228*G0_0_1_0_5_1 - 0.000454545454545471*G0_0_1_0_5_2 + 0.00181818181818188*G0_0_1_0_5_3 + 0.00129870129870134*G0_0_1_0_5_4 + 0.0124675324675329*G0_0_1_0_5_5 - 0.000616883116883138*G0_0_1_1_0_0 + 0.00219155844155852*G0_0_1_1_0_1 - 0.000909090909090939*G0_0_1_1_0_3 - 0.000194805194805202*G0_0_1_1_0_4 + 0.00220779220779228*G0_0_1_1_0_5 + 0.00219155844155852*G0_0_1_1_1_0 - 0.00219155844155852*G0_0_1_1_1_2 + 0.0100649350649354*G0_0_1_1_1_3 - 0.0100649350649354*G0_0_1_1_1_5 - 0.00219155844155852*G0_0_1_1_2_1 + 0.000616883116883138*G0_0_1_1_2_2 - 0.00220779220779229*G0_0_1_1_2_3 + 0.0001948051948052*G0_0_1_1_2_4 + 0.000909090909090938*G0_0_1_1_2_5 - 0.000909090909090939*G0_0_1_1_3_0 + 0.0100649350649354*G0_0_1_1_3_1 - 0.00220779220779229*G0_0_1_1_3_2 + 0.0233766233766242*G0_0_1_1_3_3 + 0.00181818181818188*G0_0_1_1_3_4 - 0.000194805194805202*G0_0_1_1_4_0 + 0.0001948051948052*G0_0_1_1_4_2 + 0.00181818181818188*G0_0_1_1_4_3 - 0.00181818181818188*G0_0_1_1_4_5 + 0.00220779220779228*G0_0_1_1_5_0 - 0.0100649350649354*G0_0_1_1_5_1 + 0.000909090909090938*G0_0_1_1_5_2 - 0.00181818181818188*G0_0_1_1_5_4 - 0.0233766233766242*G0_0_1_1_5_5 + 0.000186688311688319*G0_0_1_2_0_0 - 0.00018668831168832*G0_0_1_2_0_2 + 0.000454545454545469*G0_0_1_2_0_3 - 0.000454545454545471*G0_0_1_2_0_5 - 0.00219155844155852*G0_0_1_2_1_1 + 0.000616883116883138*G0_0_1_2_1_2 - 0.00220779220779229*G0_0_1_2_1_3 + 0.0001948051948052*G0_0_1_2_1_4 + 0.000909090909090938*G0_0_1_2_1_5 - 0.00018668831168832*G0_0_1_2_2_0 + 0.000616883116883138*G0_0_1_2_2_1 + 0.00172889610389619*G0_0_1_2_2_2 + 0.000194805194805211*G0_0_1_2_2_3 + 0.000941558441558483*G0_0_1_2_2_4 + 0.000454545454545472*G0_0_1_2_2_5 + 0.000454545454545469*G0_0_1_2_3_0 - 0.00220779220779229*G0_0_1_2_3_1 + 0.000194805194805211*G0_0_1_2_3_2 - 0.0124675324675329*G0_0_1_2_3_3 - 0.00129870129870134*G0_0_1_2_3_4 - 0.00181818181818189*G0_0_1_2_3_5 + 0.0001948051948052*G0_0_1_2_4_1 + 0.000941558441558483*G0_0_1_2_4_2 - 0.00129870129870134*G0_0_1_2_4_3 + 0.00038961038961041*G0_0_1_2_4_4 - 0.00129870129870134*G0_0_1_2_4_5 - 0.000454545454545471*G0_0_1_2_5_0 + 0.000909090909090937*G0_0_1_2_5_1 + 0.000454545454545472*G0_0_1_2_5_2 - 0.00181818181818189*G0_0_1_2_5_3 - 0.00129870129870134*G0_0_1_2_5_4 - 0.00207792207792216*G0_0_1_2_5_5 - 0.000454545454545466*G0_0_1_3_0_0 - 0.000909090909090939*G0_0_1_3_0_1 + 0.000454545454545469*G0_0_1_3_0_2 + 0.00207792207792213*G0_0_1_3_0_3 + 0.00129870129870134*G0_0_1_3_0_4 + 0.00181818181818188*G0_0_1_3_0_5 - 0.000909090909090939*G0_0_1_3_1_0 + 0.0100649350649354*G0_0_1_3_1_1 - 0.00220779220779229*G0_0_1_3_1_2 + 0.0233766233766242*G0_0_1_3_1_3 + 0.00181818181818188*G0_0_1_3_1_4 + 0.000454545454545469*G0_0_1_3_2_0 - 0.00220779220779229*G0_0_1_3_2_1 + 0.000194805194805211*G0_0_1_3_2_2 - 0.0124675324675329*G0_0_1_3_2_3 - 0.00129870129870134*G0_0_1_3_2_4 - 0.00181818181818189*G0_0_1_3_2_5 + 0.00207792207792213*G0_0_1_3_3_0 + 0.0233766233766242*G0_0_1_3_3_1 - 0.0124675324675329*G0_0_1_3_3_2 - 0.0046753246753247*G0_0_1_3_3_3 - 0.00779220779220803*G0_0_1_3_3_4 - 0.000519480519480498*G0_0_1_3_3_5 + 0.00129870129870134*G0_0_1_3_4_0 + 0.00181818181818188*G0_0_1_3_4_1 - 0.00129870129870134*G0_0_1_3_4_2 - 0.00779220779220803*G0_0_1_3_4_3 - 0.00259740259740267*G0_0_1_3_4_4 + 0.00181818181818188*G0_0_1_3_5_0 - 0.00181818181818189*G0_0_1_3_5_2 - 0.0005194805194805*G0_0_1_3_5_3 + 0.000519480519480552*G0_0_1_3_5_5 - 0.000941558441558474*G0_0_1_4_0_0 - 0.000194805194805202*G0_0_1_4_0_1 + 0.00129870129870134*G0_0_1_4_0_3 - 0.000389610389610407*G0_0_1_4_0_4 + 0.00129870129870134*G0_0_1_4_0_5 - 0.000194805194805202*G0_0_1_4_1_0 + 0.0001948051948052*G0_0_1_4_1_2 + 0.00181818181818188*G0_0_1_4_1_3 - 0.00181818181818188*G0_0_1_4_1_5 + 0.0001948051948052*G0_0_1_4_2_1 + 0.000941558441558483*G0_0_1_4_2_2 - 0.00129870129870134*G0_0_1_4_2_3 + 0.00038961038961041*G0_0_1_4_2_4 - 0.00129870129870134*G0_0_1_4_2_5 + 0.00129870129870134*G0_0_1_4_3_0 + 0.00181818181818188*G0_0_1_4_3_1 - 0.00129870129870134*G0_0_1_4_3_2 - 0.00779220779220803*G0_0_1_4_3_3 - 0.00259740259740267*G0_0_1_4_3_4 - 0.000389610389610407*G0_0_1_4_4_0 + 0.00038961038961041*G0_0_1_4_4_2 - 0.00259740259740267*G0_0_1_4_4_3 + 0.00259740259740269*G0_0_1_4_4_5 + 0.00129870129870134*G0_0_1_4_5_0 - 0.00181818181818188*G0_0_1_4_5_1 - 0.00129870129870134*G0_0_1_4_5_2 + 0.00259740259740269*G0_0_1_4_5_4 + 0.00779220779220808*G0_0_1_4_5_5 - 0.000194805194805193*G0_0_1_5_0_0 + 0.00220779220779228*G0_0_1_5_0_1 - 0.000454545454545471*G0_0_1_5_0_2 + 0.00181818181818188*G0_0_1_5_0_3 + 0.00129870129870134*G0_0_1_5_0_4 + 0.0124675324675329*G0_0_1_5_0_5 + 0.00220779220779228*G0_0_1_5_1_0 - 0.0100649350649354*G0_0_1_5_1_1 + 0.000909090909090938*G0_0_1_5_1_2 - 0.00181818181818188*G0_0_1_5_1_4 - 0.0233766233766242*G0_0_1_5_1_5 - 0.000454545454545471*G0_0_1_5_2_0 + 0.000909090909090938*G0_0_1_5_2_1 + 0.000454545454545472*G0_0_1_5_2_2 - 0.00181818181818189*G0_0_1_5_2_3 - 0.00129870129870134*G0_0_1_5_2_4 - 0.00207792207792215*G0_0_1_5_2_5 + 0.00181818181818188*G0_0_1_5_3_0 - 0.00181818181818189*G0_0_1_5_3_2 - 0.0005194805194805*G0_0_1_5_3_3 + 0.000519480519480552*G0_0_1_5_3_5 + 0.00129870129870134*G0_0_1_5_4_0 - 0.00181818181818188*G0_0_1_5_4_1 - 0.00129870129870134*G0_0_1_5_4_2 + 0.00259740259740269*G0_0_1_5_4_4 + 0.00779220779220808*G0_0_1_5_4_5 + 0.0124675324675329*G0_0_1_5_5_0 - 0.0233766233766242*G0_0_1_5_5_1 - 0.00207792207792216*G0_0_1_5_5_2 + 0.000519480519480552*G0_0_1_5_5_3 + 0.00779220779220808*G0_0_1_5_5_4 + 0.00467532467532492*G0_0_1_5_5_5;
    A[9] = A[90] + 0.00219155844155853*G0_0_1_0_0_1 - 0.00219155844155851*G0_0_1_0_0_2 + 0.0100649350649354*G0_0_1_0_0_4 - 0.0100649350649355*G0_0_1_0_0_5 + 0.00219155844155853*G0_0_1_0_1_0 - 0.000616883116883138*G0_0_1_0_1_1 - 0.000194805194805201*G0_0_1_0_1_3 - 0.00090909090909094*G0_0_1_0_1_4 + 0.00220779220779229*G0_0_1_0_1_5 - 0.00219155844155851*G0_0_1_0_2_0 + 0.000616883116883136*G0_0_1_0_2_2 + 0.000194805194805201*G0_0_1_0_2_3 - 0.00220779220779228*G0_0_1_0_2_4 + 0.000909090909090942*G0_0_1_0_2_5 - 0.000194805194805201*G0_0_1_0_3_1 + 0.000194805194805201*G0_0_1_0_3_2 + 0.00181818181818188*G0_0_1_0_3_4 - 0.00181818181818188*G0_0_1_0_3_5 + 0.0100649350649354*G0_0_1_0_4_0 - 0.00090909090909094*G0_0_1_0_4_1 - 0.00220779220779228*G0_0_1_0_4_2 + 0.00181818181818188*G0_0_1_0_4_3 + 0.0233766233766241*G0_0_1_0_4_4 - 0.0100649350649355*G0_0_1_0_5_0 + 0.00220779220779229*G0_0_1_0_5_1 + 0.000909090909090942*G0_0_1_0_5_2 - 0.00181818181818188*G0_0_1_0_5_3 - 0.0233766233766242*G0_0_1_0_5_5 + 0.00219155844155853*G0_0_1_1_0_0 - 0.000616883116883138*G0_0_1_1_0_1 - 0.000194805194805201*G0_0_1_1_0_3 - 0.000909090909090939*G0_0_1_1_0_4 + 0.00220779220779229*G0_0_1_1_0_5 - 0.000616883116883138*G0_0_1_1_1_0 - 0.00172889610389617*G0_0_1_1_1_1 + 0.000186688311688319*G0_0_1_1_1_2 - 0.000941558441558476*G0_0_1_1_1_3 - 0.00045454545454547*G0_0_1_1_1_4 - 0.000194805194805209*G0_0_1_1_1_5 + 0.000186688311688319*G0_0_1_1_2_1 - 0.00018668831168832*G0_0_1_1_2_2 + 0.00045454545454547*G0_0_1_1_2_4 - 0.000454545454545471*G0_0_1_1_2_5 - 0.000194805194805201*G0_0_1_1_3_0 - 0.000941558441558477*G0_0_1_1_3_1 - 0.000389610389610406*G0_0_1_1_3_3 + 0.00129870129870134*G0_0_1_1_3_4 + 0.00129870129870134*G0_0_1_1_3_5 - 0.000909090909090939*G0_0_1_1_4_0 - 0.00045454545454547*G0_0_1_1_4_1 + 0.00045454545454547*G0_0_1_1_4_2 + 0.00129870129870134*G0_0_1_1_4_3 + 0.00207792207792215*G0_0_1_1_4_4 + 0.00181818181818188*G0_0_1_1_4_5 + 0.00220779220779229*G0_0_1_1_5_0 - 0.000194805194805209*G0_0_1_1_5_1 - 0.000454545454545471*G0_0_1_1_5_2 + 0.00129870129870134*G0_0_1_1_5_3 + 0.00181818181818188*G0_0_1_1_5_4 + 0.0124675324675329*G0_0_1_1_5_5 - 0.00219155844155851*G0_0_1_2_0_0 + 0.000616883116883136*G0_0_1_2_0_2 + 0.000194805194805201*G0_0_1_2_0_3 - 0.00220779220779228*G0_0_1_2_0_4 + 0.000909090909090942*G0_0_1_2_0_5 + 0.000186688311688319*G0_0_1_2_1_1 - 0.00018668831168832*G0_0_1_2_1_2 + 0.00045454545454547*G0_0_1_2_1_4 - 0.000454545454545471*G0_0_1_2_1_5 + 0.000616883116883136*G0_0_1_2_2_0 - 0.00018668831168832*G0_0_1_2_2_1 + 0.00172889610389619*G0_0_1_2_2_2 + 0.000941558441558482*G0_0_1_2_2_3 + 0.000194805194805207*G0_0_1_2_2_4 + 0.00045454545454547*G0_0_1_2_2_5 + 0.000194805194805201*G0_0_1_2_3_0 + 0.000941558441558482*G0_0_1_2_3_2 + 0.000389610389610411*G0_0_1_2_3_3 - 0.00129870129870134*G0_0_1_2_3_4 - 0.00129870129870134*G0_0_1_2_3_5 - 0.00220779220779228*G0_0_1_2_4_0 + 0.00045454545454547*G0_0_1_2_4_1 + 0.000194805194805207*G0_0_1_2_4_2 - 0.00129870129870134*G0_0_1_2_4_3 - 0.0124675324675329*G0_0_1_2_4_4 - 0.00181818181818188*G0_0_1_2_4_5 + 0.000909090909090942*G0_0_1_2_5_0 - 0.000454545454545471*G0_0_1_2_5_1 + 0.00045454545454547*G0_0_1_2_5_2 - 0.00129870129870134*G0_0_1_2_5_3 - 0.00181818181818188*G0_0_1_2_5_4 - 0.00207792207792214*G0_0_1_2_5_5 - 0.000194805194805201*G0_0_1_3_0_1 + 0.000194805194805201*G0_0_1_3_0_2 + 0.00181818181818188*G0_0_1_3_0_4 - 0.00181818181818188*G0_0_1_3_0_5 - 0.000194805194805201*G0_0_1_3_1_0 - 0.000941558441558477*G0_0_1_3_1_1 - 0.000389610389610405*G0_0_1_3_1_3 + 0.00129870129870134*G0_0_1_3_1_4 + 0.00129870129870134*G0_0_1_3_1_5 + 0.000194805194805201*G0_0_1_3_2_0 + 0.000941558441558482*G0_0_1_3_2_2 + 0.000389610389610411*G0_0_1_3_2_3 - 0.00129870129870134*G0_0_1_3_2_4 - 0.00129870129870134*G0_0_1_3_2_5 - 0.000389610389610408*G0_0_1_3_3_1 + 0.000389610389610414*G0_0_1_3_3_2 - 0.00259740259740269*G0_0_1_3_3_4 + 0.00259740259740267*G0_0_1_3_3_5 + 0.00181818181818188*G0_0_1_3_4_0 + 0.00129870129870134*G0_0_1_3_4_1 - 0.00129870129870134*G0_0_1_3_4_2 - 0.00259740259740269*G0_0_1_3_4_3 - 0.00779220779220806*G0_0_1_3_4_4 - 0.00181818181818188*G0_0_1_3_5_0 + 0.00129870129870134*G0_0_1_3_5_1 - 0.00129870129870134*G0_0_1_3_5_2 + 0.00259740259740268*G0_0_1_3_5_3 + 0.00779220779220805*G0_0_1_3_5_5 + 0.0100649350649354*G0_0_1_4_0_0 - 0.00090909090909094*G0_0_1_4_0_1 - 0.00220779220779228*G0_0_1_4_0_2 + 0.00181818181818188*G0_0_1_4_0_3 + 0.0233766233766241*G0_0_1_4_0_4 - 0.00090909090909094*G0_0_1_4_1_0 - 0.00045454545454547*G0_0_1_4_1_1 + 0.00045454545454547*G0_0_1_4_1_2 + 0.00129870129870134*G0_0_1_4_1_3 + 0.00207792207792215*G0_0_1_4_1_4 + 0.00181818181818188*G0_0_1_4_1_5 - 0.00220779220779228*G0_0_1_4_2_0 + 0.00045454545454547*G0_0_1_4_2_1 + 0.000194805194805207*G0_0_1_4_2_2 - 0.00129870129870134*G0_0_1_4_2_3 - 0.0124675324675329*G0_0_1_4_2_4 - 0.00181818181818188*G0_0_1_4_2_5 + 0.00181818181818188*G0_0_1_4_3_0 + 0.00129870129870134*G0_0_1_4_3_1 - 0.00129870129870134*G0_0_1_4_3_2 - 0.00259740259740269*G0_0_1_4_3_3 - 0.00779220779220806*G0_0_1_4_3_4 + 0.0233766233766241*G0_0_1_4_4_0 + 0.00207792207792215*G0_0_1_4_4_1 - 0.0124675324675329*G0_0_1_4_4_2 - 0.00779220779220806*G0_0_1_4_4_3 - 0.00467532467532485*G0_0_1_4_4_4 - 0.000519480519480548*G0_0_1_4_4_5 + 0.00181818181818188*G0_0_1_4_5_1 - 0.00181818181818188*G0_0_1_4_5_2 - 0.000519480519480549*G0_0_1_4_5_4 + 0.000519480519480527*G0_0_1_4_5_5 - 0.0100649350649355*G0_0_1_5_0_0 + 0.00220779220779229*G0_0_1_5_0_1 + 0.000909090909090942*G0_0_1_5_0_2 - 0.00181818181818188*G0_0_1_5_0_3 - 0.0233766233766242*G0_0_1_5_0_5 + 0.00220779220779229*G0_0_1_5_1_0 - 0.000194805194805209*G0_0_1_5_1_1 - 0.000454545454545471*G0_0_1_5_1_2 + 0.00129870129870134*G0_0_1_5_1_3 + 0.00181818181818188*G0_0_1_5_1_4 + 0.0124675324675329*G0_0_1_5_1_5 + 0.000909090909090942*G0_0_1_5_2_0 - 0.000454545454545471*G0_0_1_5_2_1 + 0.00045454545454547*G0_0_1_5_2_2 - 0.00129870129870134*G0_0_1_5_2_3 - 0.00181818181818188*G0_0_1_5_2_4 - 0.00207792207792214*G0_0_1_5_2_5 - 0.00181818181818188*G0_0_1_5_3_0 + 0.00129870129870134*G0_0_1_5_3_1 - 0.00129870129870134*G0_0_1_5_3_2 + 0.00259740259740268*G0_0_1_5_3_3 + 0.00779220779220805*G0_0_1_5_3_5 + 0.00181818181818188*G0_0_1_5_4_1 - 0.00181818181818188*G0_0_1_5_4_2 - 0.000519480519480551*G0_0_1_5_4_4 + 0.000519480519480525*G0_0_1_5_4_5 - 0.0233766233766242*G0_0_1_5_5_0 + 0.0124675324675329*G0_0_1_5_5_1 - 0.00207792207792214*G0_0_1_5_5_2 + 0.00779220779220805*G0_0_1_5_5_3 + 0.000519480519480526*G0_0_1_5_5_4 + 0.00467532467532477*G0_0_1_5_5_5 - 0.00219155844155853*G0_1_0_0_0_1 + 0.00219155844155851*G0_1_0_0_0_2 - 0.0100649350649354*G0_1_0_0_0_4 + 0.0100649350649355*G0_1_0_0_0_5 - 0.00219155844155853*G0_1_0_0_1_0 + 0.000616883116883138*G0_1_0_0_1_1 + 0.0001948051948052*G0_1_0_0_1_3 + 0.00090909090909094*G0_1_0_0_1_4 - 0.00220779220779229*G0_1_0_0_1_5 + 0.00219155844155851*G0_1_0_0_2_0 - 0.000616883116883136*G0_1_0_0_2_2 - 0.000194805194805201*G0_1_0_0_2_3 + 0.00220779220779228*G0_1_0_0_2_4 - 0.000909090909090942*G0_1_0_0_2_5 + 0.0001948051948052*G0_1_0_0_3_1 - 0.000194805194805201*G0_1_0_0_3_2 - 0.00181818181818188*G0_1_0_0_3_4 + 0.00181818181818188*G0_1_0_0_3_5 - 0.0100649350649354*G0_1_0_0_4_0 + 0.00090909090909094*G0_1_0_0_4_1 + 0.00220779220779228*G0_1_0_0_4_2 - 0.00181818181818188*G0_1_0_0_4_3 - 0.0233766233766241*G0_1_0_0_4_4 + 0.0100649350649355*G0_1_0_0_5_0 - 0.00220779220779229*G0_1_0_0_5_1 - 0.000909090909090942*G0_1_0_0_5_2 + 0.00181818181818188*G0_1_0_0_5_3 + 0.0233766233766242*G0_1_0_0_5_5 - 0.00219155844155853*G0_1_0_1_0_0 + 0.000616883116883138*G0_1_0_1_0_1 + 0.000194805194805201*G0_1_0_1_0_3 + 0.000909090909090939*G0_1_0_1_0_4 - 0.00220779220779229*G0_1_0_1_0_5 + 0.000616883116883138*G0_1_0_1_1_0 + 0.00172889610389617*G0_1_0_1_1_1 - 0.000186688311688319*G0_1_0_1_1_2 + 0.000941558441558477*G0_1_0_1_1_3 + 0.00045454545454547*G0_1_0_1_1_4 + 0.000194805194805209*G0_1_0_1_1_5 - 0.000186688311688319*G0_1_0_1_2_1 + 0.00018668831168832*G0_1_0_1_2_2 - 0.00045454545454547*G0_1_0_1_2_4 + 0.000454545454545471*G0_1_0_1_2_5 + 0.000194805194805201*G0_1_0_1_3_0 + 0.000941558441558478*G0_1_0_1_3_1 + 0.000389610389610406*G0_1_0_1_3_3 - 0.00129870129870134*G0_1_0_1_3_4 - 0.00129870129870134*G0_1_0_1_3_5 + 0.000909090909090939*G0_1_0_1_4_0 + 0.00045454545454547*G0_1_0_1_4_1 - 0.00045454545454547*G0_1_0_1_4_2 - 0.00129870129870134*G0_1_0_1_4_3 - 0.00207792207792215*G0_1_0_1_4_4 - 0.00181818181818188*G0_1_0_1_4_5 - 0.00220779220779229*G0_1_0_1_5_0 + 0.000194805194805209*G0_1_0_1_5_1 + 0.000454545454545471*G0_1_0_1_5_2 - 0.00129870129870134*G0_1_0_1_5_3 - 0.00181818181818188*G0_1_0_1_5_4 - 0.0124675324675329*G0_1_0_1_5_5 + 0.00219155844155851*G0_1_0_2_0_0 - 0.000616883116883136*G0_1_0_2_0_2 - 0.000194805194805201*G0_1_0_2_0_3 + 0.00220779220779228*G0_1_0_2_0_4 - 0.000909090909090942*G0_1_0_2_0_5 - 0.000186688311688319*G0_1_0_2_1_1 + 0.00018668831168832*G0_1_0_2_1_2 - 0.00045454545454547*G0_1_0_2_1_4 + 0.000454545454545471*G0_1_0_2_1_5 - 0.000616883116883136*G0_1_0_2_2_0 + 0.00018668831168832*G0_1_0_2_2_1 - 0.00172889610389619*G0_1_0_2_2_2 - 0.000941558441558482*G0_1_0_2_2_3 - 0.000194805194805207*G0_1_0_2_2_4 - 0.00045454545454547*G0_1_0_2_2_5 - 0.000194805194805201*G0_1_0_2_3_0 - 0.000941558441558482*G0_1_0_2_3_2 - 0.000389610389610412*G0_1_0_2_3_3 + 0.00129870129870134*G0_1_0_2_3_4 + 0.00129870129870134*G0_1_0_2_3_5 + 0.00220779220779228*G0_1_0_2_4_0 - 0.00045454545454547*G0_1_0_2_4_1 - 0.000194805194805208*G0_1_0_2_4_2 + 0.00129870129870134*G0_1_0_2_4_3 + 0.0124675324675329*G0_1_0_2_4_4 + 0.00181818181818188*G0_1_0_2_4_5 - 0.000909090909090942*G0_1_0_2_5_0 + 0.000454545454545471*G0_1_0_2_5_1 - 0.00045454545454547*G0_1_0_2_5_2 + 0.00129870129870134*G0_1_0_2_5_3 + 0.00181818181818188*G0_1_0_2_5_4 + 0.00207792207792214*G0_1_0_2_5_5 + 0.000194805194805201*G0_1_0_3_0_1 - 0.000194805194805201*G0_1_0_3_0_2 - 0.00181818181818188*G0_1_0_3_0_4 + 0.00181818181818188*G0_1_0_3_0_5 + 0.000194805194805201*G0_1_0_3_1_0 + 0.000941558441558478*G0_1_0_3_1_1 + 0.000389610389610406*G0_1_0_3_1_3 - 0.00129870129870134*G0_1_0_3_1_4 - 0.00129870129870134*G0_1_0_3_1_5 - 0.000194805194805201*G0_1_0_3_2_0 - 0.000941558441558482*G0_1_0_3_2_2 - 0.000389610389610412*G0_1_0_3_2_3 + 0.00129870129870134*G0_1_0_3_2_4 + 0.00129870129870134*G0_1_0_3_2_5 + 0.000389610389610409*G0_1_0_3_3_1 - 0.000389610389610415*G0_1_0_3_3_2 + 0.00259740259740269*G0_1_0_3_3_4 - 0.00259740259740267*G0_1_0_3_3_5 - 0.00181818181818188*G0_1_0_3_4_0 - 0.00129870129870134*G0_1_0_3_4_1 + 0.00129870129870134*G0_1_0_3_4_2 + 0.00259740259740269*G0_1_0_3_4_3 + 0.00779220779220806*G0_1_0_3_4_4 + 0.00181818181818188*G0_1_0_3_5_0 - 0.00129870129870134*G0_1_0_3_5_1 + 0.00129870129870134*G0_1_0_3_5_2 - 0.00259740259740268*G0_1_0_3_5_3 - 0.00779220779220805*G0_1_0_3_5_5 - 0.0100649350649354*G0_1_0_4_0_0 + 0.00090909090909094*G0_1_0_4_0_1 + 0.00220779220779228*G0_1_0_4_0_2 - 0.00181818181818188*G0_1_0_4_0_3 - 0.0233766233766241*G0_1_0_4_0_4 + 0.00090909090909094*G0_1_0_4_1_0 + 0.00045454545454547*G0_1_0_4_1_1 - 0.000454545454545469*G0_1_0_4_1_2 - 0.00129870129870134*G0_1_0_4_1_3 - 0.00207792207792215*G0_1_0_4_1_4 - 0.00181818181818188*G0_1_0_4_1_5 + 0.00220779220779228*G0_1_0_4_2_0 - 0.000454545454545469*G0_1_0_4_2_1 - 0.000194805194805208*G0_1_0_4_2_2 + 0.00129870129870134*G0_1_0_4_2_3 + 0.0124675324675329*G0_1_0_4_2_4 + 0.00181818181818188*G0_1_0_4_2_5 - 0.00181818181818188*G0_1_0_4_3_0 - 0.00129870129870134*G0_1_0_4_3_1 + 0.00129870129870134*G0_1_0_4_3_2 + 0.00259740259740269*G0_1_0_4_3_3 + 0.00779220779220806*G0_1_0_4_3_4 - 0.0233766233766241*G0_1_0_4_4_0 - 0.00207792207792215*G0_1_0_4_4_1 + 0.0124675324675329*G0_1_0_4_4_2 + 0.00779220779220806*G0_1_0_4_4_3 + 0.00467532467532486*G0_1_0_4_4_4 + 0.000519480519480553*G0_1_0_4_4_5 - 0.00181818181818188*G0_1_0_4_5_1 + 0.00181818181818188*G0_1_0_4_5_2 + 0.000519480519480553*G0_1_0_4_5_4 - 0.000519480519480525*G0_1_0_4_5_5 + 0.0100649350649355*G0_1_0_5_0_0 - 0.00220779220779229*G0_1_0_5_0_1 - 0.000909090909090942*G0_1_0_5_0_2 + 0.00181818181818188*G0_1_0_5_0_3 + 0.0233766233766242*G0_1_0_5_0_5 - 0.00220779220779229*G0_1_0_5_1_0 + 0.000194805194805209*G0_1_0_5_1_1 + 0.000454545454545471*G0_1_0_5_1_2 - 0.00129870129870134*G0_1_0_5_1_3 - 0.00181818181818188*G0_1_0_5_1_4 - 0.0124675324675329*G0_1_0_5_1_5 - 0.000909090909090942*G0_1_0_5_2_0 + 0.000454545454545471*G0_1_0_5_2_1 - 0.00045454545454547*G0_1_0_5_2_2 + 0.00129870129870134*G0_1_0_5_2_3 + 0.00181818181818188*G0_1_0_5_2_4 + 0.00207792207792214*G0_1_0_5_2_5 + 0.00181818181818188*G0_1_0_5_3_0 - 0.00129870129870134*G0_1_0_5_3_1 + 0.00129870129870134*G0_1_0_5_3_2 - 0.00259740259740268*G0_1_0_5_3_3 - 0.00779220779220805*G0_1_0_5_3_5 - 0.00181818181818188*G0_1_0_5_4_1 + 0.00181818181818188*G0_1_0_5_4_2 + 0.000519480519480554*G0_1_0_5_4_4 - 0.000519480519480523*G0_1_0_5_4_5 + 0.0233766233766242*G0_1_0_5_5_0 - 0.0124675324675329*G0_1_0_5_5_1 + 0.00207792207792214*G0_1_0_5_5_2 - 0.00779220779220805*G0_1_0_5_5_3 - 0.000519480519480526*G0_1_0_5_5_4 - 0.00467532467532478*G0_1_0_5_5_5;
    A[34] = -A[37] - 0.00653814935064966*G0_0_0_0_0_0 + 0.000450487012987032*G0_0_0_0_0_1 - 0.000974025974026005*G0_0_0_0_0_3 - 0.00818181818181847*G0_0_0_0_0_4 - 0.00326298701298714*G0_0_0_0_0_5 + 0.000450487012987032*G0_0_0_0_1_0 - 0.000730519480519505*G0_0_0_0_1_1 - 0.000328733766233778*G0_0_0_0_1_2 - 0.000389610389610405*G0_0_0_0_1_3 - 0.000292207792207799*G0_0_0_0_1_4 + 0.000487012987013004*G0_0_0_0_1_5 - 0.000328733766233778*G0_0_0_0_2_1 + 0.00882711038961068*G0_0_0_0_2_2 + 0.000730519480519513*G0_0_0_0_2_3 + 0.00779220779220806*G0_0_0_0_2_4 - 0.000974025974025998*G0_0_0_0_2_5 - 0.000974025974026005*G0_0_0_0_3_0 - 0.000389610389610405*G0_0_0_0_3_1 + 0.000730519480519513*G0_0_0_0_3_2 - 0.00740259740259763*G0_0_0_0_3_3 + 0.00253246753246761*G0_0_0_0_3_4 + 0.00389610389610401*G0_0_0_0_3_5 - 0.00818181818181847*G0_0_0_0_4_0 - 0.000292207792207799*G0_0_0_0_4_1 + 0.00779220779220806*G0_0_0_0_4_2 + 0.00253246753246761*G0_0_0_0_4_3 + 0.0052597402597404*G0_0_0_0_4_4 + 0.0025324675324676*G0_0_0_0_4_5 - 0.00326298701298714*G0_0_0_0_5_0 + 0.000487012987013005*G0_0_0_0_5_1 - 0.000974025974025998*G0_0_0_0_5_2 + 0.00389610389610401*G0_0_0_0_5_3 + 0.0025324675324676*G0_0_0_0_5_4 + 0.00857142857142883*G0_0_0_0_5_5 + 0.000450487012987032*G0_0_0_1_0_0 - 0.000730519480519505*G0_0_0_1_0_1 - 0.000328733766233778*G0_0_0_1_0_2 - 0.000389610389610405*G0_0_0_1_0_3 - 0.000292207792207799*G0_0_0_1_0_4 + 0.000487012987013005*G0_0_0_1_0_5 - 0.000730519480519505*G0_0_0_1_1_0 + 0.0182629870129876*G0_0_0_1_1_1 - 0.00272727272727282*G0_0_0_1_1_2 + 0.0160714285714291*G0_0_0_1_1_3 - 0.0001948051948052*G0_0_0_1_1_4 + 0.00146103896103903*G0_0_0_1_1_5 - 0.000328733766233778*G0_0_0_1_2_0 - 0.00272727272727282*G0_0_0_1_2_1 + 0.00575892857142876*G0_0_0_1_2_2 - 0.00555194805194825*G0_0_0_1_2_3 + 0.00141233766233771*G0_0_0_1_2_4 - 0.000974025974026009*G0_0_0_1_2_5 - 0.000389610389610406*G0_0_0_1_3_0 + 0.0160714285714291*G0_0_0_1_3_1 - 0.00555194805194825*G0_0_0_1_3_2 + 0.0116883116883121*G0_0_0_1_3_3 + 0.00116883116883121*G0_0_0_1_3_4 + 0.00272727272727284*G0_0_0_1_3_5 - 0.000292207792207799*G0_0_0_1_4_0 - 0.0001948051948052*G0_0_0_1_4_1 + 0.00141233766233771*G0_0_0_1_4_2 + 0.00116883116883121*G0_0_0_1_4_3 + 0.00681818181818204*G0_0_0_1_4_4 + 0.00233766233766241*G0_0_0_1_4_5 + 0.000487012987013004*G0_0_0_1_5_0 + 0.00146103896103903*G0_0_0_1_5_1 - 0.000974025974026009*G0_0_0_1_5_2 + 0.00272727272727284*G0_0_0_1_5_3 + 0.00233766233766241*G0_0_0_1_5_4 + 0.0003896103896104*G0_0_0_1_5_5 - 0.000328733766233778*G0_0_0_2_0_1 + 0.00882711038961068*G0_0_0_2_0_2 + 0.000730519480519513*G0_0_0_2_0_3 + 0.00779220779220806*G0_0_0_2_0_4 - 0.000974025974025998*G0_0_0_2_0_5 - 0.000328733766233778*G0_0_0_2_1_0 - 0.00272727272727282*G0_0_0_2_1_1 + 0.00575892857142876*G0_0_0_2_1_2 - 0.00555194805194825*G0_0_0_2_1_3 + 0.00141233766233771*G0_0_0_2_1_4 - 0.000974025974026009*G0_0_0_2_1_5 + 0.00882711038961068*G0_0_0_2_2_0 + 0.00575892857142876*G0_0_0_2_2_1 - 0.11761363636364*G0_0_0_2_2_2 - 0.0167532467532473*G0_0_0_2_2_3 - 0.0416883116883131*G0_0_0_2_2_4 - 0.00326298701298714*G0_0_0_2_2_5 + 0.000730519480519513*G0_0_0_2_3_0 - 0.00555194805194825*G0_0_0_2_3_1 - 0.0167532467532473*G0_0_0_2_3_2 + 0.00311688311688318*G0_0_0_2_3_3 - 0.00428571428571445*G0_0_0_2_3_4 + 0.00506493506493521*G0_0_0_2_3_5 + 0.00779220779220806*G0_0_0_2_4_0 + 0.00141233766233771*G0_0_0_2_4_1 - 0.0416883116883131*G0_0_0_2_4_2 - 0.00428571428571445*G0_0_0_2_4_3 - 0.0296103896103906*G0_0_0_2_4_4 + 0.00370129870129881*G0_0_0_2_4_5 - 0.000974025974025998*G0_0_0_2_5_0 - 0.000974025974026009*G0_0_0_2_5_1 - 0.00326298701298714*G0_0_0_2_5_2 + 0.00506493506493521*G0_0_0_2_5_3 + 0.00370129870129881*G0_0_0_2_5_4 + 0.0109090909090913*G0_0_0_2_5_5 - 0.000974025974026005*G0_0_0_3_0_0 - 0.000389610389610405*G0_0_0_3_0_1 + 0.000730519480519514*G0_0_0_3_0_2 - 0.00740259740259763*G0_0_0_3_0_3 + 0.00253246753246761*G0_0_0_3_0_4 + 0.00389610389610401*G0_0_0_3_0_5 - 0.000389610389610405*G0_0_0_3_1_0 + 0.0160714285714291*G0_0_0_3_1_1 - 0.00555194805194825*G0_0_0_3_1_2 + 0.0116883116883121*G0_0_0_3_1_3 + 0.00116883116883121*G0_0_0_3_1_4 + 0.00272727272727284*G0_0_0_3_1_5 + 0.000730519480519513*G0_0_0_3_2_0 - 0.00555194805194825*G0_0_0_3_2_1 - 0.0167532467532473*G0_0_0_3_2_2 + 0.00311688311688318*G0_0_0_3_2_3 - 0.00428571428571445*G0_0_0_3_2_4 + 0.00506493506493521*G0_0_0_3_2_5 - 0.00740259740259763*G0_0_0_3_3_0 + 0.0116883116883121*G0_0_0_3_3_1 + 0.00311688311688318*G0_0_0_3_3_2 + 0.271168831168841*G0_0_0_3_3_3 + 0.0124675324675329*G0_0_0_3_3_4 + 0.00467532467532496*G0_0_0_3_3_5 + 0.00253246753246761*G0_0_0_3_4_0 + 0.00116883116883121*G0_0_0_3_4_1 - 0.00428571428571445*G0_0_0_3_4_2 + 0.0124675324675329*G0_0_0_3_4_3 - 0.0187012987012993*G0_0_0_3_4_4 - 0.0124675324675329*G0_0_0_3_4_5 + 0.00389610389610401*G0_0_0_3_5_0 + 0.00272727272727284*G0_0_0_3_5_1 + 0.00506493506493521*G0_0_0_3_5_2 + 0.00467532467532496*G0_0_0_3_5_3 - 0.0124675324675329*G0_0_0_3_5_4 - 0.0296103896103905*G0_0_0_3_5_5 - 0.00818181818181847*G0_0_0_4_0_0 - 0.000292207792207799*G0_0_0_4_0_1 + 0.00779220779220806*G0_0_0_4_0_2 + 0.00253246753246761*G0_0_0_4_0_3 + 0.0052597402597404*G0_0_0_4_0_4 + 0.0025324675324676*G0_0_0_4_0_5 - 0.000292207792207799*G0_0_0_4_1_0 - 0.0001948051948052*G0_0_0_4_1_1 + 0.00141233766233771*G0_0_0_4_1_2 + 0.00116883116883121*G0_0_0_4_1_3 + 0.00681818181818204*G0_0_0_4_1_4 + 0.00233766233766241*G0_0_0_4_1_5 + 0.00779220779220806*G0_0_0_4_2_0 + 0.00141233766233771*G0_0_0_4_2_1 - 0.0416883116883131*G0_0_0_4_2_2 - 0.00428571428571445*G0_0_0_4_2_3 - 0.0296103896103906*G0_0_0_4_2_4 + 0.00370129870129881*G0_0_0_4_2_5 + 0.00253246753246761*G0_0_0_4_3_0 + 0.00116883116883121*G0_0_0_4_3_1 - 0.00428571428571445*G0_0_0_4_3_2 + 0.0124675324675329*G0_0_0_4_3_3 - 0.0187012987012993*G0_0_0_4_3_4 - 0.0124675324675329*G0_0_0_4_3_5 + 0.0052597402597404*G0_0_0_4_4_0 + 0.00681818181818204*G0_0_0_4_4_1 - 0.0296103896103906*G0_0_0_4_4_2 - 0.0187012987012993*G0_0_0_4_4_3 - 0.13558441558442*G0_0_0_4_4_4 - 0.0210389610389617*G0_0_0_4_4_5 + 0.0025324675324676*G0_0_0_4_5_0 + 0.00233766233766241*G0_0_0_4_5_1 + 0.00370129870129881*G0_0_0_4_5_2 - 0.0124675324675329*G0_0_0_4_5_3 - 0.0210389610389617*G0_0_0_4_5_4 - 0.0264935064935074*G0_0_0_4_5_5 - 0.00326298701298714*G0_0_0_5_0_0 + 0.000487012987013004*G0_0_0_5_0_1 - 0.000974025974025998*G0_0_0_5_0_2 + 0.00389610389610401*G0_0_0_5_0_3 + 0.0025324675324676*G0_0_0_5_0_4 + 0.00857142857142883*G0_0_0_5_0_5 + 0.000487012987013004*G0_0_0_5_1_0 + 0.00146103896103903*G0_0_0_5_1_1 - 0.000974025974026009*G0_0_0_5_1_2 + 0.00272727272727284*G0_0_0_5_1_3 + 0.00233766233766241*G0_0_0_5_1_4 + 0.0003896103896104*G0_0_0_5_1_5 - 0.000974025974025998*G0_0_0_5_2_0 - 0.000974025974026009*G0_0_0_5_2_1 - 0.00326298701298714*G0_0_0_5_2_2 + 0.00506493506493521*G0_0_0_5_2_3 + 0.00370129870129881*G0_0_0_5_2_4 + 0.0109090909090913*G0_0_0_5_2_5 + 0.00389610389610401*G0_0_0_5_3_0 + 0.00272727272727284*G0_0_0_5_3_1 + 0.00506493506493521*G0_0_0_5_3_2 + 0.00467532467532496*G0_0_0_5_3_3 - 0.0124675324675329*G0_0_0_5_3_4 - 0.0296103896103905*G0_0_0_5_3_5 + 0.0025324675324676*G0_0_0_5_4_0 + 0.00233766233766241*G0_0_0_5_4_1 + 0.00370129870129881*G0_0_0_5_4_2 - 0.0124675324675329*G0_0_0_5_4_3 - 0.0210389610389617*G0_0_0_5_4_4 - 0.0264935064935074*G0_0_0_5_4_5 + 0.00857142857142883*G0_0_0_5_5_0 + 0.000389610389610401*G0_0_0_5_5_1 + 0.0109090909090913*G0_0_0_5_5_2 - 0.0296103896103905*G0_0_0_5_5_3 - 0.0264935064935074*G0_0_0_5_5_4 - 0.0794805194805222*G0_0_0_5_5_5 + 0.000657467532467575*G0_0_1_0_0_0 - 0.000365259740259752*G0_0_1_0_0_1 - 0.000438311688311706*G0_0_1_0_0_2 + 0.00350649350649361*G0_0_1_0_0_3 + 0.00146103896103901*G0_0_1_0_0_4 - 0.000365259740259752*G0_0_1_0_1_0 - 0.000730519480519504*G0_0_1_0_1_1 + 0.000365259740259752*G0_0_1_0_1_2 + 0.000292207792207791*G0_0_1_0_1_3 + 0.000584415584415599*G0_0_1_0_1_4 + 0.00146103896103901*G0_0_1_0_1_5 - 0.000438311688311706*G0_0_1_0_2_0 + 0.000365259740259752*G0_0_1_0_2_1 + 0.000657467532467562*G0_0_1_0_2_2 + 0.00175324675324682*G0_0_1_0_2_3 + 0.000876623376623411*G0_0_1_0_2_4 + 0.00350649350649361*G0_0_1_0_3_0 + 0.000292207792207791*G0_0_1_0_3_1 + 0.00175324675324682*G0_0_1_0_3_2 - 0.0385714285714297*G0_0_1_0_3_3 - 0.00818181818181843*G0_0_1_0_3_4 - 0.00701298701298724*G0_0_1_0_3_5 + 0.00146103896103901*G0_0_1_0_4_0 + 0.000584415584415599*G0_0_1_0_4_1 + 0.000876623376623411*G0_0_1_0_4_2 - 0.00818181818181843*G0_0_1_0_4_3 - 0.0011688311688312*G0_0_1_0_4_5 + 0.00146103896103901*G0_0_1_0_5_1 - 0.00701298701298724*G0_0_1_0_5_3 - 0.0011688311688312*G0_0_1_0_5_4 + 0.00350649350649361*G0_0_1_0_5_5 - 0.000365259740259752*G0_0_1_1_0_0 - 0.000730519480519504*G0_0_1_1_0_1 + 0.000365259740259752*G0_0_1_1_0_2 + 0.000292207792207791*G0_0_1_1_0_3 + 0.000584415584415599*G0_0_1_1_0_4 + 0.00146103896103901*G0_0_1_1_0_5 - 0.000730519480519505*G0_0_1_1_1_0 + 0.0109577922077926*G0_0_1_1_1_1 - 0.00292207792207803*G0_0_1_1_1_2 + 0.0233766233766242*G0_0_1_1_1_3 + 0.00146103896103901*G0_0_1_1_1_4 + 0.000365259740259752*G0_0_1_1_2_0 - 0.00292207792207803*G0_0_1_1_2_1 + 0.00153409090909097*G0_0_1_1_2_2 - 0.0113961038961043*G0_0_1_1_2_3 - 0.000584415584415602*G0_0_1_1_2_4 - 0.00146103896103902*G0_0_1_1_2_5 + 0.000292207792207791*G0_0_1_1_3_0 + 0.0233766233766242*G0_0_1_1_3_1 - 0.0113961038961043*G0_0_1_1_3_2 + 0.0210389610389619*G0_0_1_1_3_3 - 0.0035064935064936*G0_0_1_1_3_4 + 0.00233766233766246*G0_0_1_1_3_5 + 0.000584415584415599*G0_0_1_1_4_0 + 0.00146103896103901*G0_0_1_1_4_1 - 0.000584415584415602*G0_0_1_1_4_2 - 0.0035064935064936*G0_0_1_1_4_3 - 0.0011688311688312*G0_0_1_1_4_4 + 0.00146103896103901*G0_0_1_1_5_0 - 0.00146103896103902*G0_0_1_1_5_2 + 0.00233766233766246*G0_0_1_1_5_3 - 0.00233766233766241*G0_0_1_1_5_5 - 0.000438311688311706*G0_0_1_2_0_0 + 0.000365259740259752*G0_0_1_2_0_1 + 0.000657467532467562*G0_0_1_2_0_2 + 0.00175324675324682*G0_0_1_2_0_3 + 0.000876623376623411*G0_0_1_2_0_4 + 0.000365259740259752*G0_0_1_2_1_0 - 0.00292207792207803*G0_0_1_2_1_1 + 0.00153409090909097*G0_0_1_2_1_2 - 0.0113961038961043*G0_0_1_2_1_3 - 0.000584415584415602*G0_0_1_2_1_4 - 0.00146103896103902*G0_0_1_2_1_5 + 0.000657467532467562*G0_0_1_2_2_0 + 0.00153409090909097*G0_0_1_2_2_1 - 0.0131493506493512*G0_0_1_2_2_2 + 0.00701298701298724*G0_0_1_2_2_3 - 0.00409090909090926*G0_0_1_2_2_4 + 0.00175324675324682*G0_0_1_2_3_0 - 0.0113961038961043*G0_0_1_2_3_1 + 0.00701298701298724*G0_0_1_2_3_2 - 0.0140259740259745*G0_0_1_2_3_3 - 0.00233766233766243*G0_0_1_2_3_4 - 0.00350649350649364*G0_0_1_2_3_5 + 0.000876623376623411*G0_0_1_2_4_0 - 0.000584415584415602*G0_0_1_2_4_1 - 0.00409090909090926*G0_0_1_2_4_2 - 0.00233766233766243*G0_0_1_2_4_3 - 0.00467532467532486*G0_0_1_2_4_4 + 0.0011688311688312*G0_0_1_2_4_5 - 0.00146103896103902*G0_0_1_2_5_1 - 0.00350649350649364*G0_0_1_2_5_3 + 0.0011688311688312*G0_0_1_2_5_4 + 0.00701298701298724*G0_0_1_2_5_5 + 0.00350649350649361*G0_0_1_3_0_0 + 0.000292207792207791*G0_0_1_3_0_1 + 0.00175324675324682*G0_0_1_3_0_2 - 0.0385714285714297*G0_0_1_3_0_3 - 0.00818181818181843*G0_0_1_3_0_4 - 0.00701298701298724*G0_0_1_3_0_5 + 0.000292207792207792*G0_0_1_3_1_0 + 0.0233766233766242*G0_0_1_3_1_1 - 0.0113961038961043*G0_0_1_3_1_2 + 0.0210389610389619*G0_0_1_3_1_3 - 0.0035064935064936*G0_0_1_3_1_4 + 0.00233766233766246*G0_0_1_3_1_5 + 0.00175324675324682*G0_0_1_3_2_0 - 0.0113961038961043*G0_0_1_3_2_1 + 0.00701298701298724*G0_0_1_3_2_2 - 0.0140259740259745*G0_0_1_3_2_3 - 0.00233766233766243*G0_0_1_3_2_4 - 0.00350649350649364*G0_0_1_3_2_5 - 0.0385714285714297*G0_0_1_3_3_0 + 0.0210389610389619*G0_0_1_3_3_1 - 0.0140259740259745*G0_0_1_3_3_2 + 0.673246753246777*G0_0_1_3_3_3 + 0.0841558441558469*G0_0_1_3_3_4 + 0.0841558441558471*G0_0_1_3_3_5 - 0.00818181818181843*G0_0_1_3_4_0 - 0.0035064935064936*G0_0_1_3_4_1 - 0.00233766233766243*G0_0_1_3_4_2 + 0.0841558441558469*G0_0_1_3_4_3 + 0.0187012987012993*G0_0_1_3_4_4 + 0.0140259740259745*G0_0_1_3_4_5 - 0.00701298701298724*G0_0_1_3_5_0 + 0.00233766233766246*G0_0_1_3_5_1 - 0.00350649350649364*G0_0_1_3_5_2 + 0.0841558441558471*G0_0_1_3_5_3 + 0.0140259740259745*G0_0_1_3_5_4 + 0.00146103896103901*G0_0_1_4_0_0 + 0.000584415584415599*G0_0_1_4_0_1 + 0.00087662337662341*G0_0_1_4_0_2 - 0.00818181818181843*G0_0_1_4_0_3 - 0.0011688311688312*G0_0_1_4_0_5 + 0.000584415584415599*G0_0_1_4_1_0 + 0.00146103896103901*G0_0_1_4_1_1 - 0.000584415584415603*G0_0_1_4_1_2 - 0.0035064935064936*G0_0_1_4_1_3 - 0.0011688311688312*G0_0_1_4_1_4 + 0.000876623376623411*G0_0_1_4_2_0 - 0.000584415584415603*G0_0_1_4_2_1 - 0.00409090909090926*G0_0_1_4_2_2 - 0.00233766233766243*G0_0_1_4_2_3 - 0.00467532467532486*G0_0_1_4_2_4 + 0.0011688311688312*G0_0_1_4_2_5 - 0.00818181818181843*G0_0_1_4_3_0 - 0.0035064935064936*G0_0_1_4_3_1 - 0.00233766233766243*G0_0_1_4_3_2 + 0.0841558441558469*G0_0_1_4_3_3 + 0.0187012987012993*G0_0_1_4_3_4 + 0.0140259740259745*G0_0_1_4_3_5 - 0.0011688311688312*G0_0_1_4_4_1 - 0.00467532467532486*G0_0_1_4_4_2 + 0.0187012987012993*G0_0_1_4_4_3 - 0.0011688311688312*G0_0_1_4_5_0 + 0.0011688311688312*G0_0_1_4_5_2 + 0.0140259740259745*G0_0_1_4_5_3 - 0.0140259740259745*G0_0_1_4_5_5 + 0.00146103896103901*G0_0_1_5_0_1 - 0.00701298701298724*G0_0_1_5_0_3 - 0.0011688311688312*G0_0_1_5_0_4 + 0.00350649350649361*G0_0_1_5_0_5 + 0.00146103896103901*G0_0_1_5_1_0 - 0.00146103896103902*G0_0_1_5_1_2 + 0.00233766233766246*G0_0_1_5_1_3 - 0.00233766233766241*G0_0_1_5_1_5 - 0.00146103896103902*G0_0_1_5_2_1 - 0.00350649350649364*G0_0_1_5_2_3 + 0.0011688311688312*G0_0_1_5_2_4 + 0.00701298701298724*G0_0_1_5_2_5 - 0.00701298701298724*G0_0_1_5_3_0 + 0.00233766233766246*G0_0_1_5_3_1 - 0.00350649350649364*G0_0_1_5_3_2 + 0.0841558441558471*G0_0_1_5_3_3 + 0.0140259740259745*G0_0_1_5_3_4 - 0.0011688311688312*G0_0_1_5_4_0 + 0.0011688311688312*G0_0_1_5_4_2 + 0.0140259740259745*G0_0_1_5_4_3 - 0.0140259740259745*G0_0_1_5_4_5 + 0.00350649350649361*G0_0_1_5_5_0 - 0.00233766233766241*G0_0_1_5_5_1 + 0.00701298701298724*G0_0_1_5_5_2 - 0.0140259740259745*G0_0_1_5_5_4 - 0.084155844155847*G0_0_1_5_5_5 - 0.00522321428571438*G0_1_0_0_0_0 + 0.000365259740259747*G0_1_0_0_0_1 + 0.000523538961038976*G0_1_0_0_0_2 - 0.000974025974026002*G0_1_0_0_0_3 - 0.0026785714285715*G0_1_0_0_0_4 - 0.00487012987013001*G0_1_0_0_0_5 + 0.000365259740259747*G0_1_0_0_1_0 - 0.00321428571428581*G0_1_0_0_1_1 - 0.00136363636363641*G0_1_0_0_1_3 + 0.0001948051948052*G0_1_0_0_1_4 + 0.00243506493506501*G0_1_0_0_1_5 + 0.000523538961038976*G0_1_0_0_2_0 + 0.000815746753246772*G0_1_0_0_2_2 + 0.000487012987013002*G0_1_0_0_2_3 + 0.000779220779220798*G0_1_0_0_2_4 - 0.000974025974026006*G0_1_0_0_2_5 - 0.000974025974026002*G0_1_0_0_3_0 - 0.00136363636363641*G0_1_0_0_3_1 + 0.000487012987013002*G0_1_0_0_3_2 - 0.000389610389610404*G0_1_0_0_3_3 + 0.00155844155844161*G0_1_0_0_3_4 + 0.00389610389610402*G0_1_0_0_3_5 - 0.0026785714285715*G0_1_0_0_4_0 + 0.0001948051948052*G0_1_0_0_4_1 + 0.000779220779220798*G0_1_0_0_4_2 + 0.00155844155844161*G0_1_0_0_4_3 + 0.000194805194805196*G0_1_0_0_4_4 + 0.00155844155844161*G0_1_0_0_4_5 - 0.00487012987013001*G0_1_0_0_5_0 + 0.00243506493506501*G0_1_0_0_5_1 - 0.000974025974026006*G0_1_0_0_5_2 + 0.00389610389610402*G0_1_0_0_5_3 + 0.00155844155844161*G0_1_0_0_5_4 + 0.0140259740259745*G0_1_0_0_5_5 + 0.000365259740259747*G0_1_0_1_0_0 - 0.00321428571428581*G0_1_0_1_0_1 - 0.00136363636363641*G0_1_0_1_0_3 + 0.0001948051948052*G0_1_0_1_0_4 + 0.00243506493506501*G0_1_0_1_0_5 - 0.00321428571428581*G0_1_0_1_1_0 + 0.10300324675325*G0_1_0_1_1_1 - 0.00759740259740286*G0_1_0_1_1_2 + 0.0336038961038972*G0_1_0_1_1_3 + 0.000584415584415596*G0_1_0_1_1_4 + 0.0102272727272731*G0_1_0_1_1_5 - 0.00759740259740286*G0_1_0_1_2_1 + 0.00226461038961046*G0_1_0_1_2_2 - 0.00457792207792224*G0_1_0_1_2_3 + 0.000487012987013*G0_1_0_1_2_4 - 0.000194805194805208*G0_1_0_1_2_5 - 0.00136363636363641*G0_1_0_1_3_0 + 0.0336038961038972*G0_1_0_1_3_1 - 0.00457792207792224*G0_1_0_1_3_2 + 0.0319480519480531*G0_1_0_1_3_3 + 0.00155844155844161*G0_1_0_1_3_4 + 0.00311688311688326*G0_1_0_1_3_5 + 0.0001948051948052*G0_1_0_1_4_0 + 0.000584415584415596*G0_1_0_1_4_1 + 0.000487012987013*G0_1_0_1_4_2 + 0.00155844155844161*G0_1_0_1_4_3 + 0.00116883116883121*G0_1_0_1_4_4 - 0.000779220779220803*G0_1_0_1_4_5 + 0.00243506493506501*G0_1_0_1_5_0 + 0.0102272727272731*G0_1_0_1_5_1 - 0.000194805194805208*G0_1_0_1_5_2 + 0.00311688311688326*G0_1_0_1_5_3 - 0.000779220779220803*G0_1_0_1_5_4 - 0.0148051948051953*G0_1_0_1_5_5 + 0.000523538961038975*G0_1_0_2_0_0 + 0.000815746753246772*G0_1_0_2_0_2 + 0.000487012987013002*G0_1_0_2_0_3 + 0.000779220779220798*G0_1_0_2_0_4 - 0.000974025974026006*G0_1_0_2_0_5 - 0.00759740259740286*G0_1_0_2_1_1 + 0.00226461038961046*G0_1_0_2_1_2 - 0.00457792207792224*G0_1_0_2_1_3 + 0.000487012987013*G0_1_0_2_1_4 - 0.000194805194805209*G0_1_0_2_1_5 + 0.000815746753246772*G0_1_0_2_2_0 + 0.00226461038961046*G0_1_0_2_2_1 - 0.00872970779220799*G0_1_0_2_2_2 - 0.00399350649350661*G0_1_0_2_2_3 - 0.00355519480519489*G0_1_0_2_2_4 - 0.00126623376623381*G0_1_0_2_2_5 + 0.000487012987013002*G0_1_0_2_3_0 - 0.00457792207792224*G0_1_0_2_3_1 - 0.00399350649350661*G0_1_0_2_3_2 - 0.0140259740259745*G0_1_0_2_3_3 - 0.00194805194805201*G0_1_0_2_3_4 + 0.0015584415584416*G0_1_0_2_3_5 + 0.000779220779220798*G0_1_0_2_4_0 + 0.000487012987013*G0_1_0_2_4_1 - 0.00355519480519489*G0_1_0_2_4_2 - 0.00194805194805201*G0_1_0_2_4_3 - 0.00214285714285718*G0_1_0_2_4_4 + 0.00155844155844161*G0_1_0_2_4_5 - 0.000974025974026006*G0_1_0_2_5_0 - 0.000194805194805208*G0_1_0_2_5_1 - 0.00126623376623381*G0_1_0_2_5_2 + 0.0015584415584416*G0_1_0_2_5_3 + 0.00155844155844161*G0_1_0_2_5_4 + 0.00896103896103926*G0_1_0_2_5_5 - 0.000974025974026002*G0_1_0_3_0_0 - 0.00136363636363641*G0_1_0_3_0_1 + 0.000487012987013002*G0_1_0_3_0_2 - 0.000389610389610404*G0_1_0_3_0_3 + 0.00155844155844161*G0_1_0_3_0_4 + 0.00389610389610402*G0_1_0_3_0_5 - 0.00136363636363641*G0_1_0_3_1_0 + 0.0336038961038972*G0_1_0_3_1_1 - 0.00457792207792224*G0_1_0_3_1_2 + 0.0319480519480531*G0_1_0_3_1_3 + 0.00155844155844161*G0_1_0_3_1_4 + 0.00311688311688326*G0_1_0_3_1_5 + 0.000487012987013002*G0_1_0_3_2_0 - 0.00457792207792224*G0_1_0_3_2_1 - 0.00399350649350662*G0_1_0_3_2_2 - 0.0140259740259745*G0_1_0_3_2_3 - 0.00194805194805201*G0_1_0_3_2_4 + 0.0015584415584416*G0_1_0_3_2_5 - 0.000389610389610404*G0_1_0_3_3_0 + 0.0319480519480531*G0_1_0_3_3_1 - 0.0140259740259745*G0_1_0_3_3_2 + 0.0771428571428599*G0_1_0_3_3_3 - 0.0023376623376624*G0_1_0_3_3_4 - 0.00233766233766236*G0_1_0_3_3_5 + 0.00155844155844161*G0_1_0_3_4_0 + 0.00155844155844161*G0_1_0_3_4_1 - 0.00194805194805201*G0_1_0_3_4_2 - 0.0023376623376624*G0_1_0_3_4_3 - 0.00545454545454563*G0_1_0_3_4_4 - 0.00623376623376644*G0_1_0_3_4_5 + 0.00389610389610402*G0_1_0_3_5_0 + 0.00311688311688326*G0_1_0_3_5_1 + 0.0015584415584416*G0_1_0_3_5_2 - 0.00233766233766236*G0_1_0_3_5_3 - 0.00623376623376644*G0_1_0_3_5_4 - 0.0257142857142866*G0_1_0_3_5_5 - 0.0026785714285715*G0_1_0_4_0_0 + 0.0001948051948052*G0_1_0_4_0_1 + 0.000779220779220798*G0_1_0_4_0_2 + 0.00155844155844161*G0_1_0_4_0_3 + 0.000194805194805196*G0_1_0_4_0_4 + 0.00155844155844161*G0_1_0_4_0_5 + 0.0001948051948052*G0_1_0_4_1_0 + 0.000584415584415596*G0_1_0_4_1_1 + 0.000487012987013*G0_1_0_4_1_2 + 0.00155844155844161*G0_1_0_4_1_3 + 0.00116883116883121*G0_1_0_4_1_4 - 0.000779220779220803*G0_1_0_4_1_5 + 0.000779220779220798*G0_1_0_4_2_0 + 0.000487012987013001*G0_1_0_4_2_1 - 0.00355519480519489*G0_1_0_4_2_2 - 0.00194805194805201*G0_1_0_4_2_3 - 0.00214285714285718*G0_1_0_4_2_4 + 0.00155844155844161*G0_1_0_4_2_5 + 0.00155844155844161*G0_1_0_4_3_0 + 0.00155844155844161*G0_1_0_4_3_1 - 0.00194805194805201*G0_1_0_4_3_2 - 0.0023376623376624*G0_1_0_4_3_3 - 0.00545454545454563*G0_1_0_4_3_4 - 0.00623376623376644*G0_1_0_4_3_5 + 0.000194805194805195*G0_1_0_4_4_0 + 0.00116883116883121*G0_1_0_4_4_1 - 0.00214285714285718*G0_1_0_4_4_2 - 0.00545454545454563*G0_1_0_4_4_3 - 0.0140259740259744*G0_1_0_4_4_4 - 0.00545454545454564*G0_1_0_4_4_5 + 0.00155844155844161*G0_1_0_4_5_0 - 0.000779220779220803*G0_1_0_4_5_1 + 0.00155844155844161*G0_1_0_4_5_2 - 0.00623376623376644*G0_1_0_4_5_3 - 0.00545454545454564*G0_1_0_4_5_4 - 0.0163636363636369*G0_1_0_4_5_5 - 0.00487012987013001*G0_1_0_5_0_0 + 0.00243506493506501*G0_1_0_5_0_1 - 0.000974025974026006*G0_1_0_5_0_2 + 0.00389610389610402*G0_1_0_5_0_3 + 0.00155844155844161*G0_1_0_5_0_4 + 0.0140259740259745*G0_1_0_5_0_5 + 0.00243506493506501*G0_1_0_5_1_0 + 0.0102272727272731*G0_1_0_5_1_1 - 0.000194805194805208*G0_1_0_5_1_2 + 0.00311688311688326*G0_1_0_5_1_3 - 0.000779220779220803*G0_1_0_5_1_4 - 0.0148051948051953*G0_1_0_5_1_5 - 0.000974025974026006*G0_1_0_5_2_0 - 0.000194805194805208*G0_1_0_5_2_1 - 0.00126623376623381*G0_1_0_5_2_2 + 0.0015584415584416*G0_1_0_5_2_3 + 0.00155844155844161*G0_1_0_5_2_4 + 0.00896103896103926*G0_1_0_5_2_5 + 0.00389610389610402*G0_1_0_5_3_0 + 0.00311688311688326*G0_1_0_5_3_1 + 0.0015584415584416*G0_1_0_5_3_2 - 0.00233766233766236*G0_1_0_5_3_3 - 0.00623376623376644*G0_1_0_5_3_4 - 0.0257142857142866*G0_1_0_5_3_5 + 0.00155844155844161*G0_1_0_5_4_0 - 0.000779220779220803*G0_1_0_5_4_1 + 0.00155844155844161*G0_1_0_5_4_2 - 0.00623376623376644*G0_1_0_5_4_3 - 0.00545454545454564*G0_1_0_5_4_4 - 0.0163636363636369*G0_1_0_5_4_5 + 0.0140259740259745*G0_1_0_5_5_0 - 0.0148051948051953*G0_1_0_5_5_1 + 0.00896103896103926*G0_1_0_5_5_2 - 0.0257142857142866*G0_1_0_5_5_3 - 0.0163636363636369*G0_1_0_5_5_4 - 0.133246753246758*G0_1_0_5_5_5 + 0.00350649350649361*G0_1_1_0_0_0 - 0.00189935064935071*G0_1_1_0_0_1 - 0.000292207792207801*G0_1_1_0_0_2 + 0.000292207792207801*G0_1_1_0_0_3 + 0.000876623376623403*G0_1_1_0_0_4 - 0.000876623376623414*G0_1_1_0_0_5 - 0.00189935064935071*G0_1_1_0_1_0 + 0.00438311688311704*G0_1_1_0_1_1 - 0.00116883116883121*G0_1_1_0_1_3 - 0.000292207792207802*G0_1_1_0_1_4 + 0.00701298701298725*G0_1_1_0_1_5 - 0.000292207792207801*G0_1_1_0_2_0 + 0.0002922077922078*G0_1_1_0_2_2 + 0.00146103896103901*G0_1_1_0_2_3 - 0.00146103896103901*G0_1_1_0_2_5 + 0.000292207792207801*G0_1_1_0_3_0 - 0.00116883116883121*G0_1_1_0_3_1 + 0.00146103896103901*G0_1_1_0_3_2 - 0.00935064935064965*G0_1_1_0_3_3 + 0.00233766233766241*G0_1_1_0_3_5 + 0.000876623376623403*G0_1_1_0_4_0 - 0.000292207792207802*G0_1_1_0_4_1 + 0.00233766233766241*G0_1_1_0_4_4 + 0.00350649350649361*G0_1_1_0_4_5 - 0.000876623376623414*G0_1_1_0_5_0 + 0.00701298701298725*G0_1_1_0_5_1 - 0.00146103896103901*G0_1_1_0_5_2 + 0.00233766233766241*G0_1_1_0_5_3 + 0.00350649350649361*G0_1_1_0_5_4 + 0.028051948051949*G0_1_1_0_5_5 - 0.00189935064935071*G0_1_1_1_0_0 + 0.00438311688311704*G0_1_1_1_0_1 - 0.00116883116883121*G0_1_1_1_0_3 - 0.000292207792207802*G0_1_1_1_0_4 + 0.00701298701298725*G0_1_1_1_0_5 + 0.00438311688311704*G0_1_1_1_1_0 - 0.00438311688311703*G0_1_1_1_1_2 + 0.0233766233766242*G0_1_1_1_1_3 - 0.0233766233766242*G0_1_1_1_1_5 - 0.00438311688311703*G0_1_1_1_2_1 + 0.00189935064935072*G0_1_1_1_2_2 - 0.00701298701298727*G0_1_1_1_2_3 + 0.0002922077922078*G0_1_1_1_2_4 + 0.0011688311688312*G0_1_1_1_2_5 - 0.00116883116883121*G0_1_1_1_3_0 + 0.0233766233766242*G0_1_1_1_3_1 - 0.00701298701298727*G0_1_1_1_3_2 + 0.0467532467532484*G0_1_1_1_3_3 + 0.00233766233766242*G0_1_1_1_3_4 - 0.000292207792207802*G0_1_1_1_4_0 + 0.0002922077922078*G0_1_1_1_4_2 + 0.00233766233766242*G0_1_1_1_4_3 - 0.0023376623376624*G0_1_1_1_4_5 + 0.00701298701298725*G0_1_1_1_5_0 - 0.0233766233766242*G0_1_1_1_5_1 + 0.0011688311688312*G0_1_1_1_5_2 - 0.0023376623376624*G0_1_1_1_5_4 - 0.0467532467532484*G0_1_1_1_5_5 - 0.000292207792207801*G0_1_1_2_0_0 + 0.0002922077922078*G0_1_1_2_0_2 + 0.00146103896103901*G0_1_1_2_0_3 - 0.00146103896103901*G0_1_1_2_0_5 - 0.00438311688311703*G0_1_1_2_1_1 + 0.00189935064935072*G0_1_1_2_1_2 - 0.00701298701298727*G0_1_1_2_1_3 + 0.0002922077922078*G0_1_1_2_1_4 + 0.0011688311688312*G0_1_1_2_1_5 + 0.0002922077922078*G0_1_1_2_2_0 + 0.00189935064935072*G0_1_1_2_2_1 - 0.00350649350649362*G0_1_1_2_2_2 + 0.00087662337662341*G0_1_1_2_2_3 - 0.000876623376623403*G0_1_1_2_2_4 - 0.000292207792207801*G0_1_1_2_2_5 + 0.00146103896103901*G0_1_1_2_3_0 - 0.00701298701298727*G0_1_1_2_3_1 + 0.00087662337662341*G0_1_1_2_3_2 - 0.0280519480519491*G0_1_1_2_3_3 - 0.00350649350649363*G0_1_1_2_3_4 - 0.00233766233766243*G0_1_1_2_3_5 + 0.0002922077922078*G0_1_1_2_4_1 - 0.000876623376623403*G0_1_1_2_4_2 - 0.00350649350649363*G0_1_1_2_4_3 - 0.00233766233766241*G0_1_1_2_4_4 - 0.00146103896103901*G0_1_1_2_5_0 + 0.0011688311688312*G0_1_1_2_5_1 - 0.000292207792207801*G0_1_1_2_5_2 - 0.00233766233766243*G0_1_1_2_5_3 + 0.00935064935064968*G0_1_1_2_5_5 + 0.000292207792207801*G0_1_1_3_0_0 - 0.00116883116883121*G0_1_1_3_0_1 + 0.00146103896103901*G0_1_1_3_0_2 - 0.00935064935064965*G0_1_1_3_0_3 + 0.00233766233766241*G0_1_1_3_0_5 - 0.00116883116883121*G0_1_1_3_1_0 + 0.0233766233766242*G0_1_1_3_1_1 - 0.00701298701298727*G0_1_1_3_1_2 + 0.0467532467532484*G0_1_1_3_1_3 + 0.00233766233766242*G0_1_1_3_1_4 + 0.00146103896103901*G0_1_1_3_2_0 - 0.00701298701298727*G0_1_1_3_2_1 + 0.00087662337662341*G0_1_1_3_2_2 - 0.0280519480519491*G0_1_1_3_2_3 - 0.00350649350649363*G0_1_1_3_2_4 - 0.00233766233766243*G0_1_1_3_2_5 - 0.00935064935064965*G0_1_1_3_3_0 + 0.0467532467532484*G0_1_1_3_3_1 - 0.0280519480519491*G0_1_1_3_3_2 + 0.210389610389618*G0_1_1_3_3_3 + 0.0140259740259745*G0_1_1_3_3_4 + 0.0233766233766243*G0_1_1_3_3_5 + 0.00233766233766242*G0_1_1_3_4_1 - 0.00350649350649363*G0_1_1_3_4_2 + 0.0140259740259745*G0_1_1_3_4_3 + 0.00233766233766241*G0_1_1_3_5_0 - 0.00233766233766243*G0_1_1_3_5_2 + 0.0233766233766243*G0_1_1_3_5_3 - 0.0233766233766242*G0_1_1_3_5_5 + 0.000876623376623403*G0_1_1_4_0_0 - 0.000292207792207802*G0_1_1_4_0_1 + 0.00233766233766241*G0_1_1_4_0_4 + 0.00350649350649361*G0_1_1_4_0_5 - 0.000292207792207802*G0_1_1_4_1_0 + 0.000292207792207799*G0_1_1_4_1_2 + 0.00233766233766242*G0_1_1_4_1_3 - 0.0023376623376624*G0_1_1_4_1_5 + 0.0002922077922078*G0_1_1_4_2_1 - 0.000876623376623403*G0_1_1_4_2_2 - 0.00350649350649363*G0_1_1_4_2_3 - 0.00233766233766241*G0_1_1_4_2_4 + 0.00233766233766242*G0_1_1_4_3_1 - 0.00350649350649363*G0_1_1_4_3_2 + 0.0140259740259745*G0_1_1_4_3_3 + 0.00233766233766241*G0_1_1_4_4_0 - 0.00233766233766241*G0_1_1_4_4_2 + 0.00350649350649361*G0_1_1_4_5_0 - 0.0023376623376624*G0_1_1_4_5_1 - 0.0140259740259745*G0_1_1_4_5_5 - 0.000876623376623414*G0_1_1_5_0_0 + 0.00701298701298725*G0_1_1_5_0_1 - 0.00146103896103901*G0_1_1_5_0_2 + 0.00233766233766241*G0_1_1_5_0_3 + 0.00350649350649361*G0_1_1_5_0_4 + 0.028051948051949*G0_1_1_5_0_5 + 0.00701298701298725*G0_1_1_5_1_0 - 0.0233766233766242*G0_1_1_5_1_1 + 0.0011688311688312*G0_1_1_5_1_2 - 0.0023376623376624*G0_1_1_5_1_4 - 0.0467532467532484*G0_1_1_5_1_5 - 0.00146103896103901*G0_1_1_5_2_0 + 0.0011688311688312*G0_1_1_5_2_1 - 0.000292207792207801*G0_1_1_5_2_2 - 0.00233766233766243*G0_1_1_5_2_3 + 0.00935064935064968*G0_1_1_5_2_5 + 0.00233766233766241*G0_1_1_5_3_0 - 0.00233766233766243*G0_1_1_5_3_2 + 0.0233766233766243*G0_1_1_5_3_3 - 0.0233766233766242*G0_1_1_5_3_5 + 0.00350649350649361*G0_1_1_5_4_0 - 0.0023376623376624*G0_1_1_5_4_1 - 0.0140259740259745*G0_1_1_5_4_5 + 0.028051948051949*G0_1_1_5_5_0 - 0.0467532467532484*G0_1_1_5_5_1 + 0.00935064935064968*G0_1_1_5_5_2 - 0.0233766233766242*G0_1_1_5_5_3 - 0.0140259740259745*G0_1_1_5_5_4 - 0.210389610389618*G0_1_1_5_5_5;
    A[36] = -A[34] + 0.000255681818181874*G0_0_1_0_0_0 - 0.000572240259740278*G0_0_1_0_0_1 + 0.00487012987013001*G0_0_1_0_0_3 + 0.000681818181818204*G0_0_1_0_0_4 + 0.00199675324675332*G0_0_1_0_0_5 - 0.000572240259740278*G0_0_1_0_1_0 + 0.000231331168831177*G0_0_1_0_1_1 + 0.000121753246753251*G0_0_1_0_1_2 + 0.001948051948052*G0_0_1_0_1_3 + 0.00165584415584421*G0_0_1_0_1_4 + 0.00224025974025981*G0_0_1_0_1_5 + 0.000121753246753251*G0_0_1_0_2_1 - 0.00547889610389629*G0_0_1_0_2_2 + 0.00243506493506501*G0_0_1_0_2_3 + 0.000974025974026*G0_0_1_0_2_4 + 0.00194805194805201*G0_0_1_0_2_5 + 0.00487012987013001*G0_0_1_0_3_0 + 0.001948051948052*G0_0_1_0_3_1 + 0.00243506493506501*G0_0_1_0_3_2 - 0.0372077922077934*G0_0_1_0_3_3 - 0.0130519480519485*G0_0_1_0_3_4 - 0.0136363636363641*G0_0_1_0_3_5 + 0.000681818181818204*G0_0_1_0_4_0 + 0.00165584415584421*G0_0_1_0_4_1 + 0.000974025974026*G0_0_1_0_4_2 - 0.0130519480519485*G0_0_1_0_4_3 - 0.00876623376623406*G0_0_1_0_4_4 - 0.00720779220779243*G0_0_1_0_4_5 + 0.00199675324675332*G0_0_1_0_5_0 + 0.00224025974025981*G0_0_1_0_5_1 + 0.00194805194805201*G0_0_1_0_5_2 - 0.0136363636363641*G0_0_1_0_5_3 - 0.00720779220779243*G0_0_1_0_5_4 - 0.00623376623376644*G0_0_1_0_5_5 - 0.000572240259740278*G0_0_1_1_0_0 + 0.000231331168831177*G0_0_1_1_0_1 + 0.000121753246753251*G0_0_1_1_0_2 + 0.001948051948052*G0_0_1_1_0_3 + 0.00165584415584421*G0_0_1_1_0_4 + 0.00224025974025981*G0_0_1_1_0_5 + 0.000231331168831177*G0_0_1_1_1_0 - 0.0100446428571432*G0_0_1_1_1_1 + 0.00681818181818207*G0_0_1_1_1_3 + 0.00165584415584421*G0_0_1_1_1_4 - 0.00267857142857152*G0_0_1_1_1_5 + 0.000121753246753251*G0_0_1_1_2_0 - 0.00328733766233777*G0_0_1_1_2_2 - 0.00487012987013005*G0_0_1_1_2_3 - 0.000487012987013007*G0_0_1_1_2_4 + 0.000487012987012999*G0_0_1_1_2_5 + 0.001948051948052*G0_0_1_1_3_0 + 0.00681818181818207*G0_0_1_1_3_1 - 0.00487012987013005*G0_0_1_1_3_2 + 0.00175324675324692*G0_0_1_1_3_3 - 0.00720779220779242*G0_0_1_1_3_4 - 0.00487012987013001*G0_0_1_1_3_5 + 0.00165584415584421*G0_0_1_1_4_0 + 0.00165584415584421*G0_0_1_1_4_1 - 0.000487012987013006*G0_0_1_1_4_2 - 0.00720779220779242*G0_0_1_1_4_3 - 0.000974025974025998*G0_0_1_1_4_4 - 0.00428571428571442*G0_0_1_1_4_5 + 0.00224025974025981*G0_0_1_1_5_0 - 0.00267857142857152*G0_0_1_1_5_1 + 0.000487012987012999*G0_0_1_1_5_2 - 0.00487012987013001*G0_0_1_1_5_3 - 0.00428571428571442*G0_0_1_1_5_4 - 0.00857142857142885*G0_0_1_1_5_5 + 0.000121753246753251*G0_0_1_2_0_1 - 0.00547889610389629*G0_0_1_2_0_2 + 0.00243506493506501*G0_0_1_2_0_3 + 0.000974025974026*G0_0_1_2_0_4 + 0.00194805194805201*G0_0_1_2_0_5 + 0.000121753246753251*G0_0_1_2_1_0 - 0.00328733766233777*G0_0_1_2_1_2 - 0.00487012987013005*G0_0_1_2_1_3 - 0.000487012987013007*G0_0_1_2_1_4 + 0.000487012987012999*G0_0_1_2_1_5 - 0.00547889610389629*G0_0_1_2_2_0 - 0.00328733766233777*G0_0_1_2_2_1 + 0.0854707792207821*G0_0_1_2_2_2 + 0.0204545454545462*G0_0_1_2_2_3 + 0.0204545454545462*G0_0_1_2_2_4 + 0.00292207792207803*G0_0_1_2_2_5 + 0.00243506493506501*G0_0_1_2_3_0 - 0.00487012987013005*G0_0_1_2_3_1 + 0.0204545454545462*G0_0_1_2_3_2 - 0.0194805194805201*G0_0_1_2_3_3 - 0.00389610389610401*G0_0_1_2_3_4 - 0.0107142857142861*G0_0_1_2_3_5 + 0.000974025974026*G0_0_1_2_4_0 - 0.000487012987013007*G0_0_1_2_4_1 + 0.0204545454545462*G0_0_1_2_4_2 - 0.00389610389610401*G0_0_1_2_4_3 + 0.00389610389610406*G0_0_1_2_4_4 - 0.00487012987013003*G0_0_1_2_4_5 + 0.00194805194805201*G0_0_1_2_5_0 + 0.000487012987012999*G0_0_1_2_5_1 + 0.00292207792207804*G0_0_1_2_5_2 - 0.0107142857142861*G0_0_1_2_5_3 - 0.00487012987013003*G0_0_1_2_5_4 - 0.00584415584415604*G0_0_1_2_5_5 + 0.00487012987013001*G0_0_1_3_0_0 + 0.001948051948052*G0_0_1_3_0_1 + 0.00243506493506501*G0_0_1_3_0_2 - 0.0372077922077934*G0_0_1_3_0_3 - 0.0130519480519485*G0_0_1_3_0_4 - 0.0136363636363641*G0_0_1_3_0_5 + 0.001948051948052*G0_0_1_3_1_0 + 0.00681818181818207*G0_0_1_3_1_1 - 0.00487012987013005*G0_0_1_3_1_2 + 0.00175324675324692*G0_0_1_3_1_3 - 0.00720779220779242*G0_0_1_3_1_4 - 0.00487012987013001*G0_0_1_3_1_5 + 0.00243506493506501*G0_0_1_3_2_0 - 0.00487012987013005*G0_0_1_3_2_1 + 0.0204545454545462*G0_0_1_3_2_2 - 0.0194805194805201*G0_0_1_3_2_3 - 0.00389610389610401*G0_0_1_3_2_4 - 0.0107142857142861*G0_0_1_3_2_5 - 0.0372077922077934*G0_0_1_3_3_0 + 0.00175324675324692*G0_0_1_3_3_1 - 0.0194805194805201*G0_0_1_3_3_2 + 0.448831168831184*G0_0_1_3_3_3 + 0.0888311688311717*G0_0_1_3_3_4 + 0.0958441558441591*G0_0_1_3_3_5 - 0.0130519480519485*G0_0_1_3_4_0 - 0.00720779220779242*G0_0_1_3_4_1 - 0.00389610389610401*G0_0_1_3_4_2 + 0.0888311688311717*G0_0_1_3_4_3 + 0.0280519480519489*G0_0_1_3_4_4 + 0.035844155844157*G0_0_1_3_4_5 - 0.0136363636363641*G0_0_1_3_5_0 - 0.00487012987013001*G0_0_1_3_5_1 - 0.0107142857142861*G0_0_1_3_5_2 + 0.0958441558441591*G0_0_1_3_5_3 + 0.035844155844157*G0_0_1_3_5_4 + 0.0389610389610403*G0_0_1_3_5_5 + 0.000681818181818204*G0_0_1_4_0_0 + 0.00165584415584421*G0_0_1_4_0_1 + 0.000974025974026*G0_0_1_4_0_2 - 0.0130519480519485*G0_0_1_4_0_3 - 0.00876623376623406*G0_0_1_4_0_4 - 0.00720779220779243*G0_0_1_4_0_5 + 0.00165584415584421*G0_0_1_4_1_0 + 0.00165584415584421*G0_0_1_4_1_1 - 0.000487012987013007*G0_0_1_4_1_2 - 0.00720779220779242*G0_0_1_4_1_3 - 0.000974025974025998*G0_0_1_4_1_4 - 0.00428571428571442*G0_0_1_4_1_5 + 0.000974025974026*G0_0_1_4_2_0 - 0.000487012987013007*G0_0_1_4_2_1 + 0.0204545454545462*G0_0_1_4_2_2 - 0.00389610389610401*G0_0_1_4_2_3 + 0.00389610389610406*G0_0_1_4_2_4 - 0.00487012987013003*G0_0_1_4_2_5 - 0.0130519480519485*G0_0_1_4_3_0 - 0.00720779220779242*G0_0_1_4_3_1 - 0.00389610389610401*G0_0_1_4_3_2 + 0.0888311688311717*G0_0_1_4_3_3 + 0.0280519480519489*G0_0_1_4_3_4 + 0.035844155844157*G0_0_1_4_3_5 - 0.00876623376623406*G0_0_1_4_4_0 - 0.000974025974025998*G0_0_1_4_4_1 + 0.00389610389610406*G0_0_1_4_4_2 + 0.0280519480519489*G0_0_1_4_4_3 - 0.0981818181818213*G0_0_1_4_4_4 + 0.011688311688312*G0_0_1_4_4_5 - 0.00720779220779243*G0_0_1_4_5_0 - 0.00428571428571442*G0_0_1_4_5_1 - 0.00487012987013002*G0_0_1_4_5_2 + 0.035844155844157*G0_0_1_4_5_3 + 0.011688311688312*G0_0_1_4_5_4 + 0.0202597402597409*G0_0_1_4_5_5 + 0.00199675324675332*G0_0_1_5_0_0 + 0.00224025974025981*G0_0_1_5_0_1 + 0.00194805194805201*G0_0_1_5_0_2 - 0.0136363636363641*G0_0_1_5_0_3 - 0.00720779220779243*G0_0_1_5_0_4 - 0.00623376623376644*G0_0_1_5_0_5 + 0.00224025974025981*G0_0_1_5_1_0 - 0.00267857142857152*G0_0_1_5_1_1 + 0.000487012987012999*G0_0_1_5_1_2 - 0.00487012987013001*G0_0_1_5_1_3 - 0.00428571428571442*G0_0_1_5_1_4 - 0.00857142857142885*G0_0_1_5_1_5 + 0.00194805194805201*G0_0_1_5_2_0 + 0.000487012987012999*G0_0_1_5_2_1 + 0.00292207792207804*G0_0_1_5_2_2 - 0.0107142857142861*G0_0_1_5_2_3 - 0.00487012987013003*G0_0_1_5_2_4 - 0.00584415584415604*G0_0_1_5_2_5 - 0.0136363636363641*G0_0_1_5_3_0 - 0.00487012987013001*G0_0_1_5_3_1 - 0.0107142857142861*G0_0_1_5_3_2 + 0.0958441558441591*G0_0_1_5_3_3 + 0.035844155844157*G0_0_1_5_3_4 + 0.0389610389610403*G0_0_1_5_3_5 - 0.00720779220779243*G0_0_1_5_4_0 - 0.00428571428571442*G0_0_1_5_4_1 - 0.00487012987013003*G0_0_1_5_4_2 + 0.035844155844157*G0_0_1_5_4_3 + 0.011688311688312*G0_0_1_5_4_4 + 0.0202597402597409*G0_0_1_5_4_5 - 0.00623376623376644*G0_0_1_5_5_0 - 0.00857142857142885*G0_0_1_5_5_1 - 0.00584415584415604*G0_0_1_5_5_2 + 0.0389610389610403*G0_0_1_5_5_3 + 0.0202597402597409*G0_0_1_5_5_4 + 0.00398133116883126*G0_1_1_0_0_0 - 0.00209415584415591*G0_1_1_0_0_1 - 0.000206980519480525*G0_1_1_0_0_2 + 0.000487012987013003*G0_1_1_0_0_3 + 0.000243506493506497*G0_1_1_0_0_4 - 0.00209415584415591*G0_1_1_0_1_0 + 0.00999594155844189*G0_1_1_0_1_1 - 0.000438311688311703*G0_1_1_0_1_2 + 0.00102272727272731*G0_1_1_0_1_3 + 0.00808441558441586*G0_1_1_0_1_5 - 0.000206980519480525*G0_1_1_0_2_0 - 0.000438311688311703*G0_1_1_0_2_1 - 0.000365259740259749*G0_1_1_0_2_2 + 0.00121753246753251*G0_1_1_0_2_3 + 0.000487012987013006*G0_1_1_0_2_4 - 0.000292207792207799*G0_1_1_0_2_5 + 0.000487012987013003*G0_1_1_0_3_0 + 0.00102272727272731*G0_1_1_0_3_1 + 0.00121753246753251*G0_1_1_0_3_2 - 0.00798701298701325*G0_1_1_0_3_3 - 0.000779220779220811*G0_1_1_0_3_4 - 0.00038961038961041*G0_1_1_0_3_5 + 0.000243506493506497*G0_1_1_0_4_0 + 0.000487012987013006*G0_1_1_0_4_2 - 0.000779220779220811*G0_1_1_0_4_3 + 0.000974025974025991*G0_1_1_0_4_4 + 0.000779220779220793*G0_1_1_0_4_5 + 0.00808441558441586*G0_1_1_0_5_1 - 0.0002922077922078*G0_1_1_0_5_2 - 0.000389610389610409*G0_1_1_0_5_3 + 0.000779220779220793*G0_1_1_0_5_4 + 0.0175324675324681*G0_1_1_0_5_5 - 0.00209415584415591*G0_1_1_1_0_0 + 0.0099959415584419*G0_1_1_1_0_1 - 0.000438311688311703*G0_1_1_1_0_2 + 0.00102272727272731*G0_1_1_1_0_3 + 0.00808441558441586*G0_1_1_1_0_5 + 0.0099959415584419*G0_1_1_1_1_0 - 0.119805194805199*G0_1_1_1_1_1 + 0.00451704545454561*G0_1_1_1_1_2 - 0.0155844155844161*G0_1_1_1_1_3 - 0.0020941558441559*G0_1_1_1_1_4 - 0.0457792207792225*G0_1_1_1_1_5 - 0.000438311688311703*G0_1_1_1_2_0 + 0.00451704545454561*G0_1_1_1_2_1 - 0.000243506493506497*G0_1_1_1_2_2 - 0.00146103896103902*G0_1_1_1_2_3 - 0.000243506493506502*G0_1_1_1_2_4 + 0.00228896103896112*G0_1_1_1_2_5 + 0.00102272727272731*G0_1_1_1_3_0 - 0.0155844155844161*G0_1_1_1_3_1 - 0.00146103896103902*G0_1_1_1_3_2 + 0.012467532467533*G0_1_1_1_3_3 + 0.00214285714285722*G0_1_1_1_3_4 - 0.00662337662337686*G0_1_1_1_3_5 - 0.0020941558441559*G0_1_1_1_4_1 - 0.000243506493506502*G0_1_1_1_4_2 + 0.00214285714285722*G0_1_1_1_4_3 + 0.00389610389610402*G0_1_1_1_4_4 - 0.000389610389610398*G0_1_1_1_4_5 + 0.00808441558441586*G0_1_1_1_5_0 - 0.0457792207792225*G0_1_1_1_5_1 + 0.00228896103896112*G0_1_1_1_5_2 - 0.00662337662337686*G0_1_1_1_5_3 - 0.000389610389610397*G0_1_1_1_5_4 - 0.0459740259740276*G0_1_1_1_5_5 - 0.000206980519480525*G0_1_1_2_0_0 - 0.000438311688311703*G0_1_1_2_0_1 - 0.000365259740259749*G0_1_1_2_0_2 + 0.00121753246753251*G0_1_1_2_0_3 + 0.000487012987013006*G0_1_1_2_0_4 - 0.0002922077922078*G0_1_1_2_0_5 - 0.000438311688311703*G0_1_1_2_1_0 + 0.00451704545454561*G0_1_1_2_1_1 - 0.000243506493506497*G0_1_1_2_1_2 - 0.00146103896103902*G0_1_1_2_1_3 - 0.000243506493506502*G0_1_1_2_1_4 + 0.00228896103896112*G0_1_1_2_1_5 - 0.000365259740259749*G0_1_1_2_2_0 - 0.000243506493506497*G0_1_1_2_2_1 + 0.0040178571428572*G0_1_1_2_2_2 + 0.00365259740259752*G0_1_1_2_2_3 + 0.000730519480519491*G0_1_1_2_2_4 + 0.000243506493506504*G0_1_1_2_2_5 + 0.00121753246753251*G0_1_1_2_3_0 - 0.00146103896103902*G0_1_1_2_3_1 + 0.00365259740259752*G0_1_1_2_3_2 - 0.0146103896103901*G0_1_1_2_3_3 - 0.00194805194805202*G0_1_1_2_3_4 - 0.00292207792207803*G0_1_1_2_3_5 + 0.000487012987013006*G0_1_1_2_4_0 - 0.000243506493506502*G0_1_1_2_4_1 + 0.000730519480519491*G0_1_1_2_4_2 - 0.00194805194805202*G0_1_1_2_4_3 + 0.000974025974025999*G0_1_1_2_4_4 - 0.000292207792207799*G0_1_1_2_5_0 + 0.00228896103896112*G0_1_1_2_5_1 + 0.000243506493506504*G0_1_1_2_5_2 - 0.00292207792207803*G0_1_1_2_5_3 + 0.00389610389610403*G0_1_1_2_5_5 + 0.000487012987013003*G0_1_1_3_0_0 + 0.00102272727272731*G0_1_1_3_0_1 + 0.00121753246753251*G0_1_1_3_0_2 - 0.00798701298701325*G0_1_1_3_0_3 - 0.000779220779220811*G0_1_1_3_0_4 - 0.000389610389610409*G0_1_1_3_0_5 + 0.00102272727272731*G0_1_1_3_1_0 - 0.0155844155844161*G0_1_1_3_1_1 - 0.00146103896103902*G0_1_1_3_1_2 + 0.0124675324675329*G0_1_1_3_1_3 + 0.00214285714285722*G0_1_1_3_1_4 - 0.00662337662337686*G0_1_1_3_1_5 + 0.00121753246753251*G0_1_1_3_2_0 - 0.00146103896103902*G0_1_1_3_2_1 + 0.00365259740259752*G0_1_1_3_2_2 - 0.0146103896103901*G0_1_1_3_2_3 - 0.00194805194805202*G0_1_1_3_2_4 - 0.00292207792207803*G0_1_1_3_2_5 - 0.00798701298701325*G0_1_1_3_3_0 + 0.0124675324675329*G0_1_1_3_3_1 - 0.0146103896103901*G0_1_1_3_3_2 + 0.130909090909095*G0_1_1_3_3_3 + 0.0116883116883121*G0_1_1_3_3_4 + 0.0218181818181826*G0_1_1_3_3_5 - 0.000779220779220811*G0_1_1_3_4_0 + 0.00214285714285722*G0_1_1_3_4_1 - 0.00194805194805202*G0_1_1_3_4_2 + 0.0116883116883121*G0_1_1_3_4_3 - 0.00623376623376641*G0_1_1_3_4_4 + 0.00155844155844163*G0_1_1_3_4_5 - 0.00038961038961041*G0_1_1_3_5_0 - 0.00662337662337686*G0_1_1_3_5_1 - 0.00292207792207803*G0_1_1_3_5_2 + 0.0218181818181826*G0_1_1_3_5_3 + 0.00155844155844164*G0_1_1_3_5_4 - 0.00701298701298723*G0_1_1_3_5_5 + 0.000243506493506497*G0_1_1_4_0_0 + 0.000487012987013006*G0_1_1_4_0_2 - 0.000779220779220811*G0_1_1_4_0_3 + 0.000974025974025991*G0_1_1_4_0_4 + 0.000779220779220793*G0_1_1_4_0_5 - 0.0020941558441559*G0_1_1_4_1_1 - 0.000243506493506502*G0_1_1_4_1_2 + 0.00214285714285722*G0_1_1_4_1_3 + 0.00389610389610402*G0_1_1_4_1_4 - 0.000389610389610398*G0_1_1_4_1_5 + 0.000487012987013006*G0_1_1_4_2_0 - 0.000243506493506502*G0_1_1_4_2_1 + 0.000730519480519491*G0_1_1_4_2_2 - 0.00194805194805202*G0_1_1_4_2_3 + 0.000974025974025999*G0_1_1_4_2_4 - 0.000779220779220811*G0_1_1_4_3_0 + 0.00214285714285722*G0_1_1_4_3_1 - 0.00194805194805202*G0_1_1_4_3_2 + 0.0116883116883121*G0_1_1_4_3_3 - 0.00623376623376641*G0_1_1_4_3_4 + 0.00155844155844163*G0_1_1_4_3_5 + 0.000974025974025991*G0_1_1_4_4_0 + 0.00389610389610402*G0_1_1_4_4_1 + 0.000974025974025999*G0_1_1_4_4_2 - 0.00623376623376641*G0_1_1_4_4_3 - 0.0303896103896113*G0_1_1_4_4_4 - 0.00779220779220803*G0_1_1_4_4_5 + 0.000779220779220793*G0_1_1_4_5_0 - 0.000389610389610397*G0_1_1_4_5_1 + 0.00155844155844164*G0_1_1_4_5_3 - 0.00779220779220803*G0_1_1_4_5_4 - 0.00701298701298722*G0_1_1_4_5_5 + 0.00808441558441586*G0_1_1_5_0_1 - 0.000292207792207799*G0_1_1_5_0_2 - 0.000389610389610409*G0_1_1_5_0_3 + 0.000779220779220793*G0_1_1_5_0_4 + 0.0175324675324681*G0_1_1_5_0_5 + 0.00808441558441586*G0_1_1_5_1_0 - 0.0457792207792225*G0_1_1_5_1_1 + 0.00228896103896112*G0_1_1_5_1_2 - 0.00662337662337686*G0_1_1_5_1_3 - 0.000389610389610398*G0_1_1_5_1_4 - 0.0459740259740276*G0_1_1_5_1_5 - 0.000292207792207799*G0_1_1_5_2_0 + 0.00228896103896112*G0_1_1_5_2_1 + 0.000243506493506504*G0_1_1_5_2_2 - 0.00292207792207803*G0_1_1_5_2_3 + 0.00389610389610403*G0_1_1_5_2_5 - 0.00038961038961041*G0_1_1_5_3_0 - 0.00662337662337686*G0_1_1_5_3_1 - 0.00292207792207803*G0_1_1_5_3_2 + 0.0218181818181826*G0_1_1_5_3_3 + 0.00155844155844164*G0_1_1_5_3_4 - 0.00701298701298723*G0_1_1_5_3_5 + 0.000779220779220793*G0_1_1_5_4_0 - 0.000389610389610398*G0_1_1_5_4_1 + 0.00155844155844163*G0_1_1_5_4_3 - 0.00779220779220803*G0_1_1_5_4_4 - 0.00701298701298722*G0_1_1_5_4_5 + 0.0175324675324681*G0_1_1_5_5_0 - 0.0459740259740276*G0_1_1_5_5_1 + 0.00389610389610403*G0_1_1_5_5_2 - 0.00701298701298723*G0_1_1_5_5_3 - 0.00701298701298722*G0_1_1_5_5_4 - 0.128571428571433*G0_1_1_5_5_5;
    A[86] = -A[36] - 0.00398133116883133*G0_0_0_0_0_0 + 0.000206980519480526*G0_0_0_0_0_1 + 0.00209415584415592*G0_0_0_0_0_2 - 0.000487012987012998*G0_0_0_0_0_3 - 0.000243506493506502*G0_0_0_0_0_5 + 0.000206980519480526*G0_0_0_0_1_0 + 0.000365259740259755*G0_0_0_0_1_1 + 0.000438311688311704*G0_0_0_0_1_2 - 0.0012175324675325*G0_0_0_0_1_3 + 0.000292207792207804*G0_0_0_0_1_4 - 0.000487012987013003*G0_0_0_0_1_5 + 0.00209415584415592*G0_0_0_0_2_0 + 0.000438311688311704*G0_0_0_0_2_1 - 0.0099959415584419*G0_0_0_0_2_2 - 0.00102272727272732*G0_0_0_0_2_3 - 0.00808441558441586*G0_0_0_0_2_4 - 0.000487012987012998*G0_0_0_0_3_0 - 0.0012175324675325*G0_0_0_0_3_1 - 0.00102272727272732*G0_0_0_0_3_2 + 0.00798701298701322*G0_0_0_0_3_3 + 0.00038961038961039*G0_0_0_0_3_4 + 0.000779220779220803*G0_0_0_0_3_5 + 0.000292207792207804*G0_0_0_0_4_1 - 0.00808441558441586*G0_0_0_0_4_2 + 0.000389610389610391*G0_0_0_0_4_3 - 0.0175324675324681*G0_0_0_0_4_4 - 0.000779220779220809*G0_0_0_0_4_5 - 0.000243506493506502*G0_0_0_0_5_0 - 0.000487012987013003*G0_0_0_0_5_1 + 0.000779220779220803*G0_0_0_0_5_3 - 0.000779220779220809*G0_0_0_0_5_4 - 0.000974025974025994*G0_0_0_0_5_5 + 0.000206980519480526*G0_0_0_1_0_0 + 0.000365259740259755*G0_0_0_1_0_1 + 0.000438311688311704*G0_0_0_1_0_2 - 0.0012175324675325*G0_0_0_1_0_3 + 0.000292207792207804*G0_0_0_1_0_4 - 0.000487012987013003*G0_0_0_1_0_5 + 0.000365259740259755*G0_0_0_1_1_0 - 0.00401785714285734*G0_0_0_1_1_1 + 0.000243506493506505*G0_0_0_1_1_2 - 0.00365259740259753*G0_0_0_1_1_3 - 0.000243506493506499*G0_0_0_1_1_4 - 0.00073051948051952*G0_0_0_1_1_5 + 0.000438311688311704*G0_0_0_1_2_0 + 0.000243506493506505*G0_0_0_1_2_1 - 0.00451704545454561*G0_0_0_1_2_2 + 0.00146103896103901*G0_0_0_1_2_3 - 0.00228896103896112*G0_0_0_1_2_4 + 0.000243506493506502*G0_0_0_1_2_5 - 0.0012175324675325*G0_0_0_1_3_0 - 0.00365259740259753*G0_0_0_1_3_1 + 0.00146103896103901*G0_0_0_1_3_2 + 0.0146103896103901*G0_0_0_1_3_3 + 0.00292207792207801*G0_0_0_1_3_4 + 0.00194805194805201*G0_0_0_1_3_5 + 0.000292207792207804*G0_0_0_1_4_0 - 0.000243506493506499*G0_0_0_1_4_1 - 0.00228896103896112*G0_0_0_1_4_2 + 0.00292207792207801*G0_0_0_1_4_3 - 0.00389610389610403*G0_0_0_1_4_4 - 0.000487012987013003*G0_0_0_1_5_0 - 0.00073051948051952*G0_0_0_1_5_1 + 0.000243506493506502*G0_0_0_1_5_2 + 0.00194805194805201*G0_0_0_1_5_3 - 0.000974025974026021*G0_0_0_1_5_5 + 0.00209415584415592*G0_0_0_2_0_0 + 0.000438311688311704*G0_0_0_2_0_1 - 0.0099959415584419*G0_0_0_2_0_2 - 0.00102272727272732*G0_0_0_2_0_3 - 0.00808441558441586*G0_0_0_2_0_4 + 0.000438311688311704*G0_0_0_2_1_0 + 0.000243506493506505*G0_0_0_2_1_1 - 0.00451704545454561*G0_0_0_2_1_2 + 0.00146103896103901*G0_0_0_2_1_3 - 0.00228896103896112*G0_0_0_2_1_4 + 0.000243506493506502*G0_0_0_2_1_5 - 0.0099959415584419*G0_0_0_2_2_0 - 0.00451704545454561*G0_0_0_2_2_1 + 0.119805194805199*G0_0_0_2_2_2 + 0.0155844155844162*G0_0_0_2_2_3 + 0.0457792207792224*G0_0_0_2_2_4 + 0.00209415584415594*G0_0_0_2_2_5 - 0.00102272727272732*G0_0_0_2_3_0 + 0.00146103896103901*G0_0_0_2_3_1 + 0.0155844155844162*G0_0_0_2_3_2 - 0.0124675324675329*G0_0_0_2_3_3 + 0.00662337662337687*G0_0_0_2_3_4 - 0.00214285714285721*G0_0_0_2_3_5 - 0.00808441558441586*G0_0_0_2_4_0 - 0.00228896103896112*G0_0_0_2_4_1 + 0.0457792207792224*G0_0_0_2_4_2 + 0.00662337662337687*G0_0_0_2_4_3 + 0.0459740259740276*G0_0_0_2_4_4 + 0.000389610389610415*G0_0_0_2_4_5 + 0.000243506493506502*G0_0_0_2_5_1 + 0.00209415584415594*G0_0_0_2_5_2 - 0.00214285714285721*G0_0_0_2_5_3 + 0.000389610389610415*G0_0_0_2_5_4 - 0.00389610389610403*G0_0_0_2_5_5 - 0.000487012987012998*G0_0_0_3_0_0 - 0.0012175324675325*G0_0_0_3_0_1 - 0.00102272727272732*G0_0_0_3_0_2 + 0.00798701298701322*G0_0_0_3_0_3 + 0.00038961038961039*G0_0_0_3_0_4 + 0.000779220779220803*G0_0_0_3_0_5 - 0.0012175324675325*G0_0_0_3_1_0 - 0.00365259740259753*G0_0_0_3_1_1 + 0.00146103896103901*G0_0_0_3_1_2 + 0.0146103896103901*G0_0_0_3_1_3 + 0.00292207792207801*G0_0_0_3_1_4 + 0.00194805194805201*G0_0_0_3_1_5 - 0.00102272727272732*G0_0_0_3_2_0 + 0.00146103896103901*G0_0_0_3_2_1 + 0.0155844155844162*G0_0_0_3_2_2 - 0.0124675324675329*G0_0_0_3_2_3 + 0.00662337662337687*G0_0_0_3_2_4 - 0.00214285714285721*G0_0_0_3_2_5 + 0.00798701298701322*G0_0_0_3_3_0 + 0.0146103896103901*G0_0_0_3_3_1 - 0.0124675324675329*G0_0_0_3_3_2 - 0.130909090909095*G0_0_0_3_3_3 - 0.0218181818181825*G0_0_0_3_3_4 - 0.0116883116883121*G0_0_0_3_3_5 + 0.00038961038961039*G0_0_0_3_4_0 + 0.00292207792207801*G0_0_0_3_4_1 + 0.00662337662337687*G0_0_0_3_4_2 - 0.0218181818181825*G0_0_0_3_4_3 + 0.00701298701298729*G0_0_0_3_4_4 - 0.0015584415584416*G0_0_0_3_4_5 + 0.000779220779220803*G0_0_0_3_5_0 + 0.00194805194805201*G0_0_0_3_5_1 - 0.00214285714285721*G0_0_0_3_5_2 - 0.0116883116883121*G0_0_0_3_5_3 - 0.0015584415584416*G0_0_0_3_5_4 + 0.00623376623376646*G0_0_0_3_5_5 + 0.000292207792207804*G0_0_0_4_0_1 - 0.00808441558441586*G0_0_0_4_0_2 + 0.000389610389610391*G0_0_0_4_0_3 - 0.0175324675324681*G0_0_0_4_0_4 - 0.000779220779220809*G0_0_0_4_0_5 + 0.000292207792207804*G0_0_0_4_1_0 - 0.000243506493506499*G0_0_0_4_1_1 - 0.00228896103896112*G0_0_0_4_1_2 + 0.00292207792207801*G0_0_0_4_1_3 - 0.00389610389610403*G0_0_0_4_1_4 - 0.00808441558441586*G0_0_0_4_2_0 - 0.00228896103896112*G0_0_0_4_2_1 + 0.0457792207792224*G0_0_0_4_2_2 + 0.00662337662337687*G0_0_0_4_2_3 + 0.0459740259740276*G0_0_0_4_2_4 + 0.000389610389610414*G0_0_0_4_2_5 + 0.00038961038961039*G0_0_0_4_3_0 + 0.00292207792207801*G0_0_0_4_3_1 + 0.00662337662337687*G0_0_0_4_3_2 - 0.0218181818181825*G0_0_0_4_3_3 + 0.00701298701298729*G0_0_0_4_3_4 - 0.0015584415584416*G0_0_0_4_3_5 - 0.0175324675324681*G0_0_0_4_4_0 - 0.00389610389610403*G0_0_0_4_4_1 + 0.0459740259740276*G0_0_0_4_4_2 + 0.00701298701298729*G0_0_0_4_4_3 + 0.128571428571433*G0_0_0_4_4_4 + 0.00701298701298728*G0_0_0_4_4_5 - 0.000779220779220809*G0_0_0_4_5_0 + 0.000389610389610414*G0_0_0_4_5_2 - 0.0015584415584416*G0_0_0_4_5_3 + 0.00701298701298728*G0_0_0_4_5_4 + 0.00779220779220808*G0_0_0_4_5_5 - 0.000243506493506502*G0_0_0_5_0_0 - 0.000487012987013003*G0_0_0_5_0_1 + 0.000779220779220803*G0_0_0_5_0_3 - 0.000779220779220809*G0_0_0_5_0_4 - 0.000974025974025994*G0_0_0_5_0_5 - 0.000487012987013003*G0_0_0_5_1_0 - 0.00073051948051952*G0_0_0_5_1_1 + 0.000243506493506502*G0_0_0_5_1_2 + 0.00194805194805201*G0_0_0_5_1_3 - 0.00097402597402602*G0_0_0_5_1_5 + 0.000243506493506502*G0_0_0_5_2_1 + 0.00209415584415594*G0_0_0_5_2_2 - 0.00214285714285721*G0_0_0_5_2_3 + 0.000389610389610415*G0_0_0_5_2_4 - 0.00389610389610403*G0_0_0_5_2_5 + 0.000779220779220803*G0_0_0_5_3_0 + 0.00194805194805201*G0_0_0_5_3_1 - 0.00214285714285721*G0_0_0_5_3_2 - 0.0116883116883121*G0_0_0_5_3_3 - 0.0015584415584416*G0_0_0_5_3_4 + 0.00623376623376646*G0_0_0_5_3_5 - 0.000779220779220809*G0_0_0_5_4_0 + 0.000389610389610414*G0_0_0_5_4_2 - 0.0015584415584416*G0_0_0_5_4_3 + 0.00701298701298728*G0_0_0_5_4_4 + 0.00779220779220808*G0_0_0_5_4_5 - 0.000974025974025994*G0_0_0_5_5_0 - 0.000974025974026021*G0_0_0_5_5_1 - 0.00389610389610403*G0_0_0_5_5_2 + 0.00623376623376646*G0_0_0_5_5_3 + 0.00779220779220808*G0_0_0_5_5_4 + 0.0303896103896116*G0_0_0_5_5_5 + 0.0361972402597415*G0_0_1_0_0_0 - 0.00104707792207795*G0_0_1_0_0_1 - 0.000474837662337675*G0_0_1_0_0_2 + 0.0015097402597403*G0_0_1_0_0_3 + 0.0021428571428572*G0_0_1_0_0_4 + 0.0034577922077923*G0_0_1_0_0_5 - 0.00104707792207795*G0_0_1_0_1_0 - 0.000608766233766255*G0_0_1_0_1_1 - 0.000109577922077925*G0_0_1_0_1_2 + 0.000730519480519505*G0_0_1_0_1_3 + 0.00141233766233771*G0_0_1_0_1_4 + 0.00243506493506502*G0_0_1_0_1_5 - 0.000474837662337675*G0_0_1_0_2_0 - 0.000109577922077925*G0_0_1_0_2_1 - 0.00631899350649373*G0_0_1_0_2_2 + 0.0012175324675325*G0_0_1_0_2_3 + 0.0011688311688312*G0_0_1_0_2_4 + 0.00170454545454551*G0_0_1_0_2_5 + 0.0015097402597403*G0_0_1_0_3_0 + 0.000730519480519505*G0_0_1_0_3_1 + 0.0012175324675325*G0_0_1_0_3_2 - 0.00564935064935084*G0_0_1_0_3_3 - 0.00584415584415603*G0_0_1_0_3_4 - 0.00642857142857164*G0_0_1_0_3_5 + 0.0021428571428572*G0_0_1_0_4_0 + 0.00141233766233771*G0_0_1_0_4_1 + 0.0011688311688312*G0_0_1_0_4_2 - 0.00584415584415603*G0_0_1_0_4_3 - 0.0167532467532473*G0_0_1_0_4_4 - 0.00623376623376644*G0_0_1_0_4_5 + 0.0034577922077923*G0_0_1_0_5_0 + 0.00243506493506502*G0_0_1_0_5_1 + 0.00170454545454551*G0_0_1_0_5_2 - 0.00642857142857164*G0_0_1_0_5_3 - 0.00623376623376644*G0_0_1_0_5_4 - 0.0142207792207797*G0_0_1_0_5_5 - 0.00104707792207795*G0_0_1_1_0_0 - 0.000608766233766255*G0_0_1_1_0_1 - 0.000109577922077925*G0_0_1_1_0_2 + 0.000730519480519505*G0_0_1_1_0_3 + 0.00141233766233771*G0_0_1_1_0_4 + 0.00243506493506502*G0_0_1_1_0_5 - 0.000608766233766255*G0_0_1_1_1_0 - 0.00012175324675325*G0_0_1_1_1_2 - 0.000730519480519503*G0_0_1_1_1_3 + 0.000730519480519504*G0_0_1_1_1_4 + 0.000730519480519501*G0_0_1_1_1_5 - 0.000109577922077925*G0_0_1_1_2_0 - 0.00012175324675325*G0_0_1_1_2_1 - 0.00340909090909103*G0_0_1_1_2_2 + 0.00194805194805201*G0_0_1_1_2_3 - 0.000243506493506506*G0_0_1_1_2_4 + 0.000730519480519504*G0_0_1_1_2_5 + 0.000730519480519505*G0_0_1_1_3_0 - 0.000730519480519503*G0_0_1_1_3_1 + 0.00194805194805201*G0_0_1_1_3_2 + 0.00389610389610403*G0_0_1_1_3_3 - 0.00292207792207802*G0_0_1_1_3_4 - 0.00292207792207802*G0_0_1_1_3_5 + 0.00141233766233771*G0_0_1_1_4_0 + 0.000730519480519504*G0_0_1_1_4_1 - 0.000243506493506506*G0_0_1_1_4_2 - 0.00292207792207802*G0_0_1_1_4_3 + 0.00233766233766241*G0_0_1_1_4_4 - 0.00292207792207802*G0_0_1_1_4_5 + 0.00243506493506502*G0_0_1_1_5_0 + 0.000730519480519501*G0_0_1_1_5_1 + 0.000730519480519504*G0_0_1_1_5_2 - 0.00292207792207802*G0_0_1_1_5_3 - 0.00292207792207802*G0_0_1_1_5_4 + 0.00194805194805202*G0_0_1_1_5_5 - 0.000474837662337675*G0_0_1_2_0_0 - 0.000109577922077925*G0_0_1_2_0_1 - 0.00631899350649373*G0_0_1_2_0_2 + 0.0012175324675325*G0_0_1_2_0_3 + 0.0011688311688312*G0_0_1_2_0_4 + 0.00170454545454551*G0_0_1_2_0_5 - 0.000109577922077925*G0_0_1_2_1_0 - 0.00012175324675325*G0_0_1_2_1_1 - 0.00340909090909103*G0_0_1_2_1_2 + 0.00194805194805201*G0_0_1_2_1_3 - 0.000243506493506506*G0_0_1_2_1_4 + 0.000730519480519504*G0_0_1_2_1_5 - 0.00631899350649373*G0_0_1_2_2_0 - 0.00340909090909103*G0_0_1_2_2_1 + 0.0955154220779255*G0_0_1_2_2_2 + 0.0129058441558446*G0_0_1_2_2_3 + 0.0238636363636372*G0_0_1_2_2_4 + 0.00199675324675333*G0_0_1_2_2_5 + 0.0012175324675325*G0_0_1_2_3_0 + 0.00194805194805201*G0_0_1_2_3_1 + 0.0129058441558446*G0_0_1_2_3_2 - 0.0173376623376629*G0_0_1_2_3_3 - 0.00194805194805199*G0_0_1_2_3_4 - 0.00642857142857164*G0_0_1_2_3_5 + 0.0011688311688312*G0_0_1_2_4_0 - 0.000243506493506506*G0_0_1_2_4_1 + 0.0238636363636372*G0_0_1_2_4_2 - 0.00194805194805199*G0_0_1_2_4_3 + 0.0144155844155849*G0_0_1_2_4_4 - 0.00350649350649362*G0_0_1_2_4_5 + 0.00170454545454551*G0_0_1_2_5_0 + 0.000730519480519504*G0_0_1_2_5_1 + 0.00199675324675333*G0_0_1_2_5_2 - 0.00642857142857164*G0_0_1_2_5_3 - 0.00350649350649362*G0_0_1_2_5_4 - 0.00253246753246761*G0_0_1_2_5_5 + 0.0015097402597403*G0_0_1_3_0_0 + 0.000730519480519505*G0_0_1_3_0_1 + 0.0012175324675325*G0_0_1_3_0_2 - 0.00564935064935084*G0_0_1_3_0_3 - 0.00584415584415603*G0_0_1_3_0_4 - 0.00642857142857164*G0_0_1_3_0_5 + 0.000730519480519505*G0_0_1_3_1_0 - 0.000730519480519502*G0_0_1_3_1_1 + 0.00194805194805201*G0_0_1_3_1_2 + 0.00389610389610403*G0_0_1_3_1_3 - 0.00292207792207802*G0_0_1_3_1_4 - 0.00292207792207802*G0_0_1_3_1_5 + 0.0012175324675325*G0_0_1_3_2_0 + 0.00194805194805201*G0_0_1_3_2_1 + 0.0129058441558446*G0_0_1_3_2_2 - 0.0173376623376629*G0_0_1_3_2_3 - 0.00194805194805199*G0_0_1_3_2_4 - 0.00642857142857164*G0_0_1_3_2_5 - 0.00564935064935084*G0_0_1_3_3_0 + 0.00389610389610403*G0_0_1_3_3_1 - 0.0173376623376629*G0_0_1_3_3_2 - 0.0350649350649363*G0_0_1_3_3_3 + 0.0171428571428577*G0_0_1_3_3_4 + 0.0241558441558449*G0_0_1_3_3_5 - 0.00584415584415603*G0_0_1_3_4_0 - 0.00292207792207802*G0_0_1_3_4_1 - 0.00194805194805199*G0_0_1_3_4_2 + 0.0171428571428577*G0_0_1_3_4_3 + 0.00701298701298726*G0_0_1_3_4_4 + 0.0187012987012993*G0_0_1_3_4_5 - 0.00642857142857164*G0_0_1_3_5_0 - 0.00292207792207802*G0_0_1_3_5_1 - 0.00642857142857164*G0_0_1_3_5_2 + 0.0241558441558449*G0_0_1_3_5_3 + 0.0187012987012993*G0_0_1_3_5_4 + 0.0179220779220785*G0_0_1_3_5_5 + 0.0021428571428572*G0_0_1_4_0_0 + 0.00141233766233771*G0_0_1_4_0_1 + 0.0011688311688312*G0_0_1_4_0_2 - 0.00584415584415603*G0_0_1_4_0_3 - 0.0167532467532473*G0_0_1_4_0_4 - 0.00623376623376644*G0_0_1_4_0_5 + 0.00141233766233771*G0_0_1_4_1_0 + 0.000730519480519504*G0_0_1_4_1_1 - 0.000243506493506506*G0_0_1_4_1_2 - 0.00292207792207802*G0_0_1_4_1_3 + 0.00233766233766241*G0_0_1_4_1_4 - 0.00292207792207802*G0_0_1_4_1_5 + 0.0011688311688312*G0_0_1_4_2_0 - 0.000243506493506506*G0_0_1_4_2_1 + 0.0238636363636372*G0_0_1_4_2_2 - 0.00194805194805199*G0_0_1_4_2_3 + 0.0144155844155849*G0_0_1_4_2_4 - 0.00350649350649362*G0_0_1_4_2_5 - 0.00584415584415603*G0_0_1_4_3_0 - 0.00292207792207802*G0_0_1_4_3_1 - 0.00194805194805199*G0_0_1_4_3_2 + 0.0171428571428577*G0_0_1_4_3_3 + 0.00701298701298726*G0_0_1_4_3_4 + 0.0187012987012993*G0_0_1_4_3_5 - 0.0167532467532473*G0_0_1_4_4_0 + 0.00233766233766241*G0_0_1_4_4_1 + 0.0144155844155849*G0_0_1_4_4_2 + 0.00701298701298726*G0_0_1_4_4_3 - 0.189350649350655*G0_0_1_4_4_4 + 0.0023376623376624*G0_0_1_4_4_5 - 0.00623376623376644*G0_0_1_4_5_0 - 0.00292207792207802*G0_0_1_4_5_1 - 0.00350649350649362*G0_0_1_4_5_2 + 0.0187012987012993*G0_0_1_4_5_3 + 0.0023376623376624*G0_0_1_4_5_4 + 0.0109090909090913*G0_0_1_4_5_5 + 0.0034577922077923*G0_0_1_5_0_0 + 0.00243506493506502*G0_0_1_5_0_1 + 0.00170454545454551*G0_0_1_5_0_2 - 0.00642857142857164*G0_0_1_5_0_3 - 0.00623376623376644*G0_0_1_5_0_4 - 0.0142207792207797*G0_0_1_5_0_5 + 0.00243506493506502*G0_0_1_5_1_0 + 0.000730519480519501*G0_0_1_5_1_1 + 0.000730519480519504*G0_0_1_5_1_2 - 0.00292207792207802*G0_0_1_5_1_3 - 0.00292207792207802*G0_0_1_5_1_4 + 0.00194805194805202*G0_0_1_5_1_5 + 0.00170454545454551*G0_0_1_5_2_0 + 0.000730519480519504*G0_0_1_5_2_1 + 0.00199675324675333*G0_0_1_5_2_2 - 0.00642857142857164*G0_0_1_5_2_3 - 0.00350649350649362*G0_0_1_5_2_4 - 0.00253246753246762*G0_0_1_5_2_5 - 0.00642857142857164*G0_0_1_5_3_0 - 0.00292207792207802*G0_0_1_5_3_1 - 0.00642857142857164*G0_0_1_5_3_2 + 0.0241558441558449*G0_0_1_5_3_3 + 0.0187012987012993*G0_0_1_5_3_4 + 0.0179220779220785*G0_0_1_5_3_5 - 0.00623376623376644*G0_0_1_5_4_0 - 0.00292207792207802*G0_0_1_5_4_1 - 0.00350649350649362*G0_0_1_5_4_2 + 0.0187012987012993*G0_0_1_5_4_3 + 0.0023376623376624*G0_0_1_5_4_4 + 0.0109090909090913*G0_0_1_5_4_5 - 0.0142207792207797*G0_0_1_5_5_0 + 0.00194805194805202*G0_0_1_5_5_1 - 0.00253246753246761*G0_0_1_5_5_2 + 0.0179220779220785*G0_0_1_5_5_3 + 0.0109090909090913*G0_0_1_5_5_4 - 0.0911688311688344*G0_0_1_5_5_5;
    A[35] = A[36] + 0.00405438311688328*G0_0_0_0_0_0 - 0.000255681818181828*G0_0_0_0_0_1 - 0.00211850649350657*G0_0_0_0_0_2 + 0.000292207792207799*G0_0_0_0_0_3 + 0.00350649350649364*G0_0_0_0_0_4 + 0.000146103896103909*G0_0_0_0_0_5 - 0.000255681818181828*G0_0_0_0_1_0 - 0.000292207792207802*G0_0_0_0_1_2 + 0.000584415584415599*G0_0_0_0_1_3 - 0.000876623376623408*G0_0_0_0_1_4 - 0.00211850649350657*G0_0_0_0_2_0 - 0.000292207792207802*G0_0_0_0_2_1 + 0.0111769480519484*G0_0_0_0_2_2 + 0.000876623376623415*G0_0_0_0_2_3 + 0.00409090909090923*G0_0_0_0_2_4 - 0.000876623376623402*G0_0_0_0_2_5 + 0.000292207792207799*G0_0_0_0_3_0 + 0.000584415584415599*G0_0_0_0_3_1 + 0.000876623376623416*G0_0_0_0_3_2 - 0.0105194805194808*G0_0_0_0_3_3 + 0.00116883116883121*G0_0_0_0_3_4 + 0.0011688311688312*G0_0_0_0_3_5 + 0.00350649350649364*G0_0_0_0_4_0 - 0.000876623376623408*G0_0_0_0_4_1 + 0.00409090909090923*G0_0_0_0_4_2 + 0.00116883116883121*G0_0_0_0_4_3 + 0.0175324675324681*G0_0_0_0_4_4 + 0.00350649350649363*G0_0_0_0_4_5 + 0.000146103896103909*G0_0_0_0_5_0 - 0.000876623376623402*G0_0_0_0_5_2 + 0.0011688311688312*G0_0_0_0_5_3 + 0.00350649350649363*G0_0_0_0_5_4 + 0.00409090909090922*G0_0_0_0_5_5 - 0.000255681818181828*G0_0_0_1_0_0 - 0.000292207792207802*G0_0_0_1_0_2 + 0.000584415584415599*G0_0_0_1_0_3 - 0.000876623376623408*G0_0_0_1_0_4 + 0.000547889610389616*G0_0_0_1_1_1 - 0.000219155844155853*G0_0_0_1_1_2 + 0.00438311688311704*G0_0_0_1_1_3 - 0.000730519480519509*G0_0_0_1_1_5 - 0.000292207792207802*G0_0_0_1_2_0 - 0.000219155844155853*G0_0_0_1_2_1 + 0.0067938311688314*G0_0_0_1_2_2 - 0.00292207792207802*G0_0_0_1_2_3 + 0.00204545454545462*G0_0_0_1_2_4 - 0.000584415584415602*G0_0_0_1_2_5 + 0.000584415584415599*G0_0_0_1_3_0 + 0.00438311688311704*G0_0_0_1_3_1 - 0.00292207792207802*G0_0_0_1_3_2 - 0.0105194805194808*G0_0_0_1_3_3 - 0.0011688311688312*G0_0_0_1_3_4 - 0.000876623376623408*G0_0_0_1_4_0 + 0.00204545454545462*G0_0_0_1_4_2 - 0.0011688311688312*G0_0_0_1_4_3 - 0.00116883116883121*G0_0_0_1_4_4 + 0.0011688311688312*G0_0_0_1_4_5 - 0.000730519480519509*G0_0_0_1_5_1 - 0.000584415584415602*G0_0_0_1_5_2 + 0.0011688311688312*G0_0_0_1_5_4 + 0.0017532467532468*G0_0_0_1_5_5 - 0.00211850649350657*G0_0_0_2_0_0 - 0.000292207792207802*G0_0_0_2_0_1 + 0.0111769480519484*G0_0_0_2_0_2 + 0.000876623376623415*G0_0_0_2_0_3 + 0.00409090909090923*G0_0_0_2_0_4 - 0.000876623376623402*G0_0_0_2_0_5 - 0.000292207792207802*G0_0_0_2_1_0 - 0.000219155844155853*G0_0_0_2_1_1 + 0.0067938311688314*G0_0_0_2_1_2 - 0.00292207792207802*G0_0_0_2_1_3 + 0.00204545454545462*G0_0_0_2_1_4 - 0.000584415584415602*G0_0_0_2_1_5 + 0.0111769480519484*G0_0_0_2_2_0 + 0.0067938311688314*G0_0_0_2_2_1 - 0.16217532467533*G0_0_0_2_2_2 - 0.0233766233766242*G0_0_0_2_2_3 - 0.0467532467532484*G0_0_0_2_2_4 - 0.00262987012987025*G0_0_0_2_2_5 + 0.000876623376623415*G0_0_0_2_3_0 - 0.00292207792207802*G0_0_0_2_3_1 - 0.0233766233766242*G0_0_0_2_3_2 + 0.011688311688312*G0_0_0_2_3_3 - 0.00584415584415606*G0_0_0_2_3_4 + 0.00350649350649361*G0_0_0_2_3_5 + 0.00409090909090923*G0_0_0_2_4_0 + 0.00204545454545462*G0_0_0_2_4_1 - 0.0467532467532484*G0_0_0_2_4_2 - 0.00584415584415606*G0_0_0_2_4_3 - 0.0350649350649363*G0_0_0_2_4_4 + 0.00116883116883119*G0_0_0_2_4_5 - 0.000876623376623402*G0_0_0_2_5_0 - 0.000584415584415602*G0_0_0_2_5_1 - 0.00262987012987025*G0_0_0_2_5_2 + 0.00350649350649361*G0_0_0_2_5_3 + 0.00116883116883119*G0_0_0_2_5_4 + 0.00584415584415603*G0_0_0_2_5_5 + 0.000292207792207799*G0_0_0_3_0_0 + 0.000584415584415599*G0_0_0_3_0_1 + 0.000876623376623415*G0_0_0_3_0_2 - 0.0105194805194808*G0_0_0_3_0_3 + 0.00116883116883121*G0_0_0_3_0_4 + 0.0011688311688312*G0_0_0_3_0_5 + 0.000584415584415599*G0_0_0_3_1_0 + 0.00438311688311704*G0_0_0_3_1_1 - 0.00292207792207802*G0_0_0_3_1_2 - 0.0105194805194808*G0_0_0_3_1_3 - 0.0011688311688312*G0_0_0_3_1_4 + 0.000876623376623416*G0_0_0_3_2_0 - 0.00292207792207802*G0_0_0_3_2_1 - 0.0233766233766242*G0_0_0_3_2_2 + 0.011688311688312*G0_0_0_3_2_3 - 0.00584415584415606*G0_0_0_3_2_4 + 0.00350649350649361*G0_0_0_3_2_5 - 0.0105194805194808*G0_0_0_3_3_0 - 0.0105194805194808*G0_0_0_3_3_1 + 0.011688311688312*G0_0_0_3_3_2 + 0.28051948051949*G0_0_0_3_3_3 + 0.0233766233766242*G0_0_0_3_3_4 + 0.0140259740259746*G0_0_0_3_3_5 + 0.00116883116883121*G0_0_0_3_4_0 - 0.0011688311688312*G0_0_0_3_4_1 - 0.00584415584415606*G0_0_0_3_4_2 + 0.0233766233766242*G0_0_0_3_4_3 - 0.00467532467532481*G0_0_0_3_4_5 + 0.0011688311688312*G0_0_0_3_5_0 + 0.00350649350649361*G0_0_0_3_5_2 + 0.0140259740259746*G0_0_0_3_5_3 - 0.00467532467532482*G0_0_0_3_5_4 - 0.0140259740259745*G0_0_0_3_5_5 + 0.00350649350649364*G0_0_0_4_0_0 - 0.000876623376623408*G0_0_0_4_0_1 + 0.00409090909090923*G0_0_0_4_0_2 + 0.00116883116883121*G0_0_0_4_0_3 + 0.0175324675324681*G0_0_0_4_0_4 + 0.00350649350649363*G0_0_0_4_0_5 - 0.000876623376623408*G0_0_0_4_1_0 + 0.00204545454545462*G0_0_0_4_1_2 - 0.0011688311688312*G0_0_0_4_1_3 - 0.00116883116883121*G0_0_0_4_1_4 + 0.0011688311688312*G0_0_0_4_1_5 + 0.00409090909090923*G0_0_0_4_2_0 + 0.00204545454545462*G0_0_0_4_2_1 - 0.0467532467532484*G0_0_0_4_2_2 - 0.00584415584415606*G0_0_0_4_2_3 - 0.0350649350649363*G0_0_0_4_2_4 + 0.00116883116883119*G0_0_0_4_2_5 + 0.00116883116883121*G0_0_0_4_3_0 - 0.0011688311688312*G0_0_0_4_3_1 - 0.00584415584415606*G0_0_0_4_3_2 + 0.0233766233766242*G0_0_0_4_3_3 - 0.00467532467532481*G0_0_0_4_3_5 + 0.0175324675324681*G0_0_0_4_4_0 - 0.00116883116883121*G0_0_0_4_4_1 - 0.0350649350649363*G0_0_0_4_4_2 + 0.0701298701298723*G0_0_0_4_4_4 + 0.00350649350649363*G0_0_0_4_5_0 + 0.0011688311688312*G0_0_0_4_5_1 + 0.00116883116883119*G0_0_0_4_5_2 - 0.00467532467532482*G0_0_0_4_5_3 - 0.0140259740259745*G0_0_0_4_5_5 + 0.000146103896103909*G0_0_0_5_0_0 - 0.000876623376623402*G0_0_0_5_0_2 + 0.0011688311688312*G0_0_0_5_0_3 + 0.00350649350649363*G0_0_0_5_0_4 + 0.00409090909090922*G0_0_0_5_0_5 - 0.000730519480519509*G0_0_0_5_1_1 - 0.000584415584415602*G0_0_0_5_1_2 + 0.0011688311688312*G0_0_0_5_1_4 + 0.0017532467532468*G0_0_0_5_1_5 - 0.000876623376623402*G0_0_0_5_2_0 - 0.000584415584415602*G0_0_0_5_2_1 - 0.00262987012987025*G0_0_0_5_2_2 + 0.00350649350649361*G0_0_0_5_2_3 + 0.00116883116883119*G0_0_0_5_2_4 + 0.00584415584415603*G0_0_0_5_2_5 + 0.0011688311688312*G0_0_0_5_3_0 + 0.00350649350649361*G0_0_0_5_3_2 + 0.0140259740259746*G0_0_0_5_3_3 - 0.00467532467532482*G0_0_0_5_3_4 - 0.0140259740259745*G0_0_0_5_3_5 + 0.00350649350649363*G0_0_0_5_4_0 + 0.0011688311688312*G0_0_0_5_4_1 + 0.00116883116883119*G0_0_0_5_4_2 - 0.00467532467532481*G0_0_0_5_4_3 - 0.0140259740259745*G0_0_0_5_4_5 + 0.00409090909090922*G0_0_0_5_5_0 + 0.0017532467532468*G0_0_0_5_5_1 + 0.00584415584415603*G0_0_0_5_5_2 - 0.0140259740259745*G0_0_0_5_5_3 - 0.0140259740259745*G0_0_0_5_5_4 - 0.0350649350649362*G0_0_0_5_5_5 - 0.00580762987013019*G0_0_1_0_0_0 + 0.000328733766233783*G0_0_1_0_0_1 + 0.000438311688311705*G0_0_1_0_0_2 - 0.00175324675324681*G0_0_1_0_0_3 - 0.00116883116883123*G0_0_1_0_0_4 - 0.00248376623376634*G0_0_1_0_0_5 + 0.000328733766233783*G0_0_1_0_1_0 + 0.000365259740259752*G0_0_1_0_1_1 - 0.000292207792207802*G0_0_1_0_1_3 - 0.000584415584415602*G0_0_1_0_1_4 - 0.0005844155844156*G0_0_1_0_1_5 + 0.000438311688311705*G0_0_1_0_2_0 + 0.00704951298701323*G0_0_1_0_2_2 - 0.0013149350649351*G0_0_1_0_2_3 - 0.00116883116883119*G0_0_1_0_2_4 - 0.00175324675324681*G0_0_1_0_2_5 - 0.00175324675324681*G0_0_1_0_3_0 - 0.000292207792207802*G0_0_1_0_3_1 - 0.0013149350649351*G0_0_1_0_3_2 + 0.00292207792207804*G0_0_1_0_3_3 + 0.00467532467532482*G0_0_1_0_3_4 + 0.00701298701298723*G0_0_1_0_3_5 - 0.00116883116883123*G0_0_1_0_4_0 - 0.000584415584415602*G0_0_1_0_4_1 - 0.00116883116883119*G0_0_1_0_4_2 + 0.00467532467532482*G0_0_1_0_4_3 + 0.00467532467532482*G0_0_1_0_4_5 - 0.00248376623376634*G0_0_1_0_5_0 - 0.0005844155844156*G0_0_1_0_5_1 - 0.00175324675324681*G0_0_1_0_5_2 + 0.00701298701298723*G0_0_1_0_5_3 + 0.00467532467532482*G0_0_1_0_5_4 + 0.00759740259740284*G0_0_1_0_5_5 + 0.000328733766233783*G0_0_1_1_0_0 + 0.000365259740259752*G0_0_1_1_0_1 - 0.000292207792207802*G0_0_1_1_0_3 - 0.000584415584415602*G0_0_1_1_0_4 - 0.0005844155844156*G0_0_1_1_0_5 + 0.000365259740259752*G0_0_1_1_1_0 + 0.000219155844155851*G0_0_1_1_1_2 + 0.00146103896103901*G0_0_1_1_1_3 - 0.000584415584415602*G0_0_1_1_1_4 - 0.00146103896103901*G0_0_1_1_1_5 + 0.00021915584415585*G0_0_1_1_2_1 + 0.00529626623376641*G0_0_1_1_2_2 - 0.00262987012987021*G0_0_1_1_2_3 + 0.000146103896103906*G0_0_1_1_2_4 - 0.000584415584415602*G0_0_1_1_2_5 - 0.000292207792207802*G0_0_1_1_3_0 + 0.00146103896103901*G0_0_1_1_3_1 - 0.00262987012987021*G0_0_1_1_3_2 - 0.00525974025974044*G0_0_1_1_3_3 + 0.00175324675324681*G0_0_1_1_3_4 + 0.0017532467532468*G0_0_1_1_3_5 - 0.000584415584415602*G0_0_1_1_4_0 - 0.000584415584415602*G0_0_1_1_4_1 + 0.000146103896103906*G0_0_1_1_4_2 + 0.00175324675324681*G0_0_1_1_4_3 - 0.00467532467532483*G0_0_1_1_4_4 + 0.00233766233766241*G0_0_1_1_4_5 - 0.0005844155844156*G0_0_1_1_5_0 - 0.00146103896103901*G0_0_1_1_5_1 - 0.000584415584415602*G0_0_1_1_5_2 + 0.0017532467532468*G0_0_1_1_5_3 + 0.00233766233766241*G0_0_1_1_5_4 + 0.00175324675324681*G0_0_1_1_5_5 + 0.000438311688311705*G0_0_1_2_0_0 + 0.00704951298701323*G0_0_1_2_0_2 - 0.0013149350649351*G0_0_1_2_0_3 - 0.00116883116883119*G0_0_1_2_0_4 - 0.00175324675324681*G0_0_1_2_0_5 + 0.000219155844155851*G0_0_1_2_1_1 + 0.00529626623376641*G0_0_1_2_1_2 - 0.00262987012987021*G0_0_1_2_1_3 + 0.000146103896103906*G0_0_1_2_1_4 - 0.000584415584415602*G0_0_1_2_1_5 + 0.00704951298701323*G0_0_1_2_2_0 + 0.00529626623376641*G0_0_1_2_2_1 - 0.135876623376628*G0_0_1_2_2_2 - 0.0198701298701306*G0_0_1_2_2_3 - 0.0268831168831179*G0_0_1_2_2_4 - 0.00248376623376634*G0_0_1_2_2_5 - 0.0013149350649351*G0_0_1_2_3_0 - 0.00262987012987021*G0_0_1_2_3_1 - 0.0198701298701306*G0_0_1_2_3_2 + 0.0187012987012993*G0_0_1_2_3_3 + 0.00233766233766239*G0_0_1_2_3_4 + 0.00759740259740284*G0_0_1_2_3_5 - 0.00116883116883119*G0_0_1_2_4_0 + 0.000146103896103906*G0_0_1_2_4_1 - 0.0268831168831179*G0_0_1_2_4_2 + 0.00233766233766239*G0_0_1_2_4_3 + 0.00467532467532482*G0_0_1_2_4_5 - 0.00175324675324681*G0_0_1_2_5_0 - 0.000584415584415602*G0_0_1_2_5_1 - 0.00248376623376634*G0_0_1_2_5_2 + 0.00759740259740284*G0_0_1_2_5_3 + 0.00467532467532482*G0_0_1_2_5_4 + 0.00701298701298725*G0_0_1_2_5_5 - 0.00175324675324681*G0_0_1_3_0_0 - 0.000292207792207802*G0_0_1_3_0_1 - 0.0013149350649351*G0_0_1_3_0_2 + 0.00292207792207804*G0_0_1_3_0_3 + 0.00467532467532482*G0_0_1_3_0_4 + 0.00701298701298723*G0_0_1_3_0_5 - 0.000292207792207802*G0_0_1_3_1_0 + 0.00146103896103901*G0_0_1_3_1_1 - 0.00262987012987021*G0_0_1_3_1_2 - 0.00525974025974044*G0_0_1_3_1_3 + 0.0017532467532468*G0_0_1_3_1_4 + 0.0017532467532468*G0_0_1_3_1_5 - 0.0013149350649351*G0_0_1_3_2_0 - 0.00262987012987021*G0_0_1_3_2_1 - 0.0198701298701306*G0_0_1_3_2_2 + 0.0187012987012993*G0_0_1_3_2_3 + 0.00233766233766239*G0_0_1_3_2_4 + 0.00759740259740284*G0_0_1_3_2_5 + 0.00292207792207804*G0_0_1_3_3_0 - 0.00525974025974044*G0_0_1_3_3_1 + 0.0187012987012993*G0_0_1_3_3_2 + 0.168311688311694*G0_0_1_3_3_3 - 0.00935064935064963*G0_0_1_3_3_4 - 0.0210389610389617*G0_0_1_3_3_5 + 0.00467532467532482*G0_0_1_3_4_0 + 0.0017532467532468*G0_0_1_3_4_1 + 0.00233766233766239*G0_0_1_3_4_2 - 0.00935064935064963*G0_0_1_3_4_3 - 0.0187012987012993*G0_0_1_3_4_5 + 0.00701298701298723*G0_0_1_3_5_0 + 0.0017532467532468*G0_0_1_3_5_1 + 0.00759740259740284*G0_0_1_3_5_2 - 0.0210389610389617*G0_0_1_3_5_3 - 0.0187012987012993*G0_0_1_3_5_4 - 0.028051948051949*G0_0_1_3_5_5 - 0.00116883116883123*G0_0_1_4_0_0 - 0.000584415584415602*G0_0_1_4_0_1 - 0.00116883116883119*G0_0_1_4_0_2 + 0.00467532467532482*G0_0_1_4_0_3 + 0.00467532467532482*G0_0_1_4_0_5 - 0.000584415584415602*G0_0_1_4_1_0 - 0.000584415584415602*G0_0_1_4_1_1 + 0.000146103896103906*G0_0_1_4_1_2 + 0.00175324675324681*G0_0_1_4_1_3 - 0.00467532467532483*G0_0_1_4_1_4 + 0.00233766233766241*G0_0_1_4_1_5 - 0.00116883116883119*G0_0_1_4_2_0 + 0.000146103896103906*G0_0_1_4_2_1 - 0.0268831168831179*G0_0_1_4_2_2 + 0.00233766233766239*G0_0_1_4_2_3 + 0.00467532467532482*G0_0_1_4_2_5 + 0.00467532467532482*G0_0_1_4_3_0 + 0.0017532467532468*G0_0_1_4_3_1 + 0.00233766233766239*G0_0_1_4_3_2 - 0.00935064935064963*G0_0_1_4_3_3 - 0.0187012987012993*G0_0_1_4_3_5 - 0.00467532467532483*G0_0_1_4_4_1 + 0.210389610389617*G0_0_1_4_4_4 + 0.00467532467532481*G0_0_1_4_5_0 + 0.00233766233766241*G0_0_1_4_5_1 + 0.00467532467532482*G0_0_1_4_5_2 - 0.0187012987012993*G0_0_1_4_5_3 - 0.0187012987012993*G0_0_1_4_5_5 - 0.00248376623376634*G0_0_1_5_0_0 - 0.0005844155844156*G0_0_1_5_0_1 - 0.00175324675324681*G0_0_1_5_0_2 + 0.00701298701298723*G0_0_1_5_0_3 + 0.00467532467532482*G0_0_1_5_0_4 + 0.00759740259740284*G0_0_1_5_0_5 - 0.0005844155844156*G0_0_1_5_1_0 - 0.00146103896103901*G0_0_1_5_1_1 - 0.000584415584415602*G0_0_1_5_1_2 + 0.0017532467532468*G0_0_1_5_1_3 + 0.00233766233766241*G0_0_1_5_1_4 + 0.00175324675324681*G0_0_1_5_1_5 - 0.00175324675324681*G0_0_1_5_2_0 - 0.000584415584415602*G0_0_1_5_2_1 - 0.00248376623376634*G0_0_1_5_2_2 + 0.00759740259740284*G0_0_1_5_2_3 + 0.00467532467532482*G0_0_1_5_2_4 + 0.00701298701298725*G0_0_1_5_2_5 + 0.00701298701298723*G0_0_1_5_3_0 + 0.0017532467532468*G0_0_1_5_3_1 + 0.00759740259740284*G0_0_1_5_3_2 - 0.0210389610389617*G0_0_1_5_3_3 - 0.0187012987012993*G0_0_1_5_3_4 - 0.028051948051949*G0_0_1_5_3_5 + 0.00467532467532482*G0_0_1_5_4_0 + 0.00233766233766241*G0_0_1_5_4_1 + 0.00467532467532482*G0_0_1_5_4_2 - 0.0187012987012993*G0_0_1_5_4_3 - 0.0187012987012993*G0_0_1_5_4_5 + 0.00759740259740284*G0_0_1_5_5_0 + 0.00175324675324681*G0_0_1_5_5_1 + 0.00701298701298725*G0_0_1_5_5_2 - 0.028051948051949*G0_0_1_5_5_3 - 0.0187012987012993*G0_0_1_5_5_4 - 0.0210389610389617*G0_0_1_5_5_5 + 0.00208198051948058*G0_1_0_0_0_0 - 0.000438311688311704*G0_1_0_0_0_1 - 0.000474837662337676*G0_1_0_0_0_2 - 0.000146103896103901*G0_1_0_0_0_3 + 0.00146103896103901*G0_1_0_0_0_4 + 0.0007305194805195*G0_1_0_0_0_5 - 0.000438311688311704*G0_1_0_0_1_0 + 0.000474837662337692*G0_1_0_0_1_1 - 0.000146103896103901*G0_1_0_0_1_2 - 0.000146103896103899*G0_1_0_0_1_3 - 0.000438311688311702*G0_1_0_0_1_4 + 0.000292207792207812*G0_1_0_0_1_5 - 0.000474837662337676*G0_1_0_0_2_0 - 0.000146103896103901*G0_1_0_0_2_1 + 0.0011688311688312*G0_1_0_0_2_2 + 0.000584415584415602*G0_1_0_0_2_3 - 0.000730519480519505*G0_1_0_0_2_5 - 0.000146103896103901*G0_1_0_0_3_0 - 0.000146103896103899*G0_1_0_0_3_1 + 0.000584415584415602*G0_1_0_0_3_2 + 0.00116883116883121*G0_1_0_0_3_4 + 0.00175324675324681*G0_1_0_0_3_5 + 0.00146103896103901*G0_1_0_0_4_0 - 0.000438311688311702*G0_1_0_0_4_1 + 0.00116883116883121*G0_1_0_0_4_3 + 0.00350649350649362*G0_1_0_0_4_4 + 0.00233766233766241*G0_1_0_0_4_5 + 0.0007305194805195*G0_1_0_0_5_0 + 0.000292207792207812*G0_1_0_0_5_1 - 0.000730519480519505*G0_1_0_0_5_2 + 0.00175324675324681*G0_1_0_0_5_3 + 0.00233766233766241*G0_1_0_0_5_4 + 0.00525974025974044*G0_1_0_0_5_5 - 0.000438311688311704*G0_1_0_1_0_0 + 0.000474837662337692*G0_1_0_1_0_1 - 0.000146103896103901*G0_1_0_1_0_2 - 0.000146103896103899*G0_1_0_1_0_3 - 0.000438311688311702*G0_1_0_1_0_4 + 0.000292207792207812*G0_1_0_1_0_5 + 0.000474837662337692*G0_1_0_1_1_0 - 0.000620941558441572*G0_1_0_1_1_2 + 0.00146103896103898*G0_1_0_1_1_3 + 0.000146103896103898*G0_1_0_1_1_4 - 0.00146103896103907*G0_1_0_1_1_5 - 0.000146103896103901*G0_1_0_1_2_0 - 0.000620941558441572*G0_1_0_1_2_1 + 0.00160714285714291*G0_1_0_1_2_2 + 0.000876623376623405*G0_1_0_1_2_3 + 0.0011688311688312*G0_1_0_1_2_4 + 0.000730519480519507*G0_1_0_1_2_5 - 0.000146103896103899*G0_1_0_1_3_0 + 0.00146103896103899*G0_1_0_1_3_1 + 0.000876623376623405*G0_1_0_1_3_2 + 0.00701298701298728*G0_1_0_1_3_3 - 0.00116883116883121*G0_1_0_1_3_5 - 0.000438311688311702*G0_1_0_1_4_0 + 0.000146103896103898*G0_1_0_1_4_1 + 0.0011688311688312*G0_1_0_1_4_2 - 0.00233766233766241*G0_1_0_1_4_4 - 0.00175324675324681*G0_1_0_1_4_5 + 0.000292207792207812*G0_1_0_1_5_0 - 0.00146103896103908*G0_1_0_1_5_1 + 0.000730519480519507*G0_1_0_1_5_2 - 0.00116883116883121*G0_1_0_1_5_3 - 0.00175324675324681*G0_1_0_1_5_4 - 0.00467532467532488*G0_1_0_1_5_5 - 0.000474837662337676*G0_1_0_2_0_0 - 0.000146103896103901*G0_1_0_2_0_1 + 0.0011688311688312*G0_1_0_2_0_2 + 0.000584415584415602*G0_1_0_2_0_3 - 0.000730519480519505*G0_1_0_2_0_5 - 0.000146103896103901*G0_1_0_2_1_0 - 0.000620941558441572*G0_1_0_2_1_1 + 0.00160714285714291*G0_1_0_2_1_2 + 0.000876623376623405*G0_1_0_2_1_3 + 0.00116883116883121*G0_1_0_2_1_4 + 0.000730519480519507*G0_1_0_2_1_5 + 0.0011688311688312*G0_1_0_2_2_0 + 0.00160714285714291*G0_1_0_2_2_1 - 0.0120535714285717*G0_1_0_2_2_2 - 0.00672077922077943*G0_1_0_2_2_3 - 0.00350649350649359*G0_1_0_2_2_4 - 0.000584415584415606*G0_1_0_2_2_5 + 0.000584415584415602*G0_1_0_2_3_0 + 0.000876623376623405*G0_1_0_2_3_1 - 0.00672077922077943*G0_1_0_2_3_2 - 0.0105194805194809*G0_1_0_2_3_3 - 0.00350649350649362*G0_1_0_2_3_4 + 0.00116883116883121*G0_1_0_2_4_1 - 0.00350649350649359*G0_1_0_2_4_2 - 0.00350649350649362*G0_1_0_2_4_3 - 0.00584415584415601*G0_1_0_2_4_4 - 0.0011688311688312*G0_1_0_2_4_5 - 0.000730519480519505*G0_1_0_2_5_0 + 0.000730519480519507*G0_1_0_2_5_1 - 0.000584415584415606*G0_1_0_2_5_2 - 0.0011688311688312*G0_1_0_2_5_4 + 0.00175324675324682*G0_1_0_2_5_5 - 0.000146103896103901*G0_1_0_3_0_0 - 0.000146103896103899*G0_1_0_3_0_1 + 0.000584415584415602*G0_1_0_3_0_2 + 0.00116883116883121*G0_1_0_3_0_4 + 0.00175324675324681*G0_1_0_3_0_5 - 0.000146103896103899*G0_1_0_3_1_0 + 0.00146103896103898*G0_1_0_3_1_1 + 0.000876623376623405*G0_1_0_3_1_2 + 0.00701298701298728*G0_1_0_3_1_3 - 0.00116883116883121*G0_1_0_3_1_5 + 0.000584415584415602*G0_1_0_3_2_0 + 0.000876623376623405*G0_1_0_3_2_1 - 0.00672077922077943*G0_1_0_3_2_2 - 0.0105194805194809*G0_1_0_3_2_3 - 0.00350649350649362*G0_1_0_3_2_4 + 0.00701298701298728*G0_1_0_3_3_1 - 0.0105194805194809*G0_1_0_3_3_2 + 0.0420779220779236*G0_1_0_3_3_3 + 0.00116883116883121*G0_1_0_3_4_0 - 0.00350649350649362*G0_1_0_3_4_2 + 0.00233766233766241*G0_1_0_3_4_4 + 0.00175324675324681*G0_1_0_3_5_0 - 0.00116883116883121*G0_1_0_3_5_1 - 0.00701298701298727*G0_1_0_3_5_5 + 0.00146103896103901*G0_1_0_4_0_0 - 0.000438311688311702*G0_1_0_4_0_1 + 0.00116883116883121*G0_1_0_4_0_3 + 0.00350649350649362*G0_1_0_4_0_4 + 0.00233766233766241*G0_1_0_4_0_5 - 0.000438311688311702*G0_1_0_4_1_0 + 0.000146103896103898*G0_1_0_4_1_1 + 0.0011688311688312*G0_1_0_4_1_2 - 0.00233766233766241*G0_1_0_4_1_4 - 0.00175324675324681*G0_1_0_4_1_5 + 0.0011688311688312*G0_1_0_4_2_1 - 0.00350649350649359*G0_1_0_4_2_2 - 0.00350649350649362*G0_1_0_4_2_3 - 0.00584415584415601*G0_1_0_4_2_4 - 0.0011688311688312*G0_1_0_4_2_5 + 0.00116883116883121*G0_1_0_4_3_0 - 0.00350649350649362*G0_1_0_4_3_2 + 0.00233766233766241*G0_1_0_4_3_4 + 0.00350649350649362*G0_1_0_4_4_0 - 0.00233766233766241*G0_1_0_4_4_1 - 0.00584415584415601*G0_1_0_4_4_2 + 0.00233766233766241*G0_1_0_4_4_3 + 0.0210389610389617*G0_1_0_4_4_4 + 0.00701298701298723*G0_1_0_4_4_5 + 0.00233766233766241*G0_1_0_4_5_0 - 0.00175324675324681*G0_1_0_4_5_1 - 0.0011688311688312*G0_1_0_4_5_2 + 0.00701298701298723*G0_1_0_4_5_4 + 0.0007305194805195*G0_1_0_5_0_0 + 0.000292207792207812*G0_1_0_5_0_1 - 0.000730519480519505*G0_1_0_5_0_2 + 0.00175324675324681*G0_1_0_5_0_3 + 0.00233766233766241*G0_1_0_5_0_4 + 0.00525974025974044*G0_1_0_5_0_5 + 0.000292207792207812*G0_1_0_5_1_0 - 0.00146103896103907*G0_1_0_5_1_1 + 0.000730519480519507*G0_1_0_5_1_2 - 0.00116883116883121*G0_1_0_5_1_3 - 0.00175324675324681*G0_1_0_5_1_4 - 0.00467532467532488*G0_1_0_5_1_5 - 0.000730519480519505*G0_1_0_5_2_0 + 0.000730519480519507*G0_1_0_5_2_1 - 0.000584415584415606*G0_1_0_5_2_2 - 0.0011688311688312*G0_1_0_5_2_4 + 0.00175324675324682*G0_1_0_5_2_5 + 0.00175324675324681*G0_1_0_5_3_0 - 0.00116883116883121*G0_1_0_5_3_1 - 0.00701298701298727*G0_1_0_5_3_5 + 0.00233766233766241*G0_1_0_5_4_0 - 0.00175324675324681*G0_1_0_5_4_1 - 0.0011688311688312*G0_1_0_5_4_2 + 0.00701298701298723*G0_1_0_5_4_4 + 0.00525974025974044*G0_1_0_5_5_0 - 0.00467532467532488*G0_1_0_5_5_1 + 0.00175324675324682*G0_1_0_5_5_2 - 0.00701298701298727*G0_1_0_5_5_3 - 0.0210389610389619*G0_1_0_5_5_5 - 0.00997159090909111*G0_1_1_0_0_0 + 0.0011688311688312*G0_1_1_0_0_1 + 0.000693993506493524*G0_1_1_0_0_2 - 0.000730519480519502*G0_1_1_0_0_3 - 0.00204545454545459*G0_1_1_0_0_4 - 0.00599025974025989*G0_1_1_0_0_5 + 0.0011688311688312*G0_1_1_0_1_0 - 0.000146103896103895*G0_1_1_0_1_1 - 0.000292207792207801*G0_1_1_0_1_2 + 0.000584415584415603*G0_1_1_0_1_3 + 0.0007305194805195*G0_1_1_0_1_4 + 0.0011688311688312*G0_1_1_0_1_5 + 0.000693993506493524*G0_1_1_0_2_0 - 0.000292207792207801*G0_1_1_0_2_1 + 0.000693993506493524*G0_1_1_0_2_2 - 0.000146103896103903*G0_1_1_0_2_3 - 0.000146103896103904*G0_1_1_0_2_5 - 0.000730519480519502*G0_1_1_0_3_0 + 0.000584415584415603*G0_1_1_0_3_1 - 0.000146103896103903*G0_1_1_0_3_2 + 0.00175324675324682*G0_1_1_0_3_3 + 0.00175324675324682*G0_1_1_0_3_5 - 0.00204545454545459*G0_1_1_0_4_0 + 0.0007305194805195*G0_1_1_0_4_1 - 0.00233766233766239*G0_1_1_0_4_4 - 0.00116883116883119*G0_1_1_0_4_5 - 0.00599025974025989*G0_1_1_0_5_0 + 0.0011688311688312*G0_1_1_0_5_1 - 0.000146103896103904*G0_1_1_0_5_2 + 0.00175324675324682*G0_1_1_0_5_3 - 0.00116883116883119*G0_1_1_0_5_4 - 0.00525974025974038*G0_1_1_0_5_5 + 0.0011688311688312*G0_1_1_1_0_0 - 0.000146103896103895*G0_1_1_1_0_1 - 0.000292207792207801*G0_1_1_1_0_2 + 0.000584415584415603*G0_1_1_1_0_3 + 0.0007305194805195*G0_1_1_1_0_4 + 0.0011688311688312*G0_1_1_1_0_5 - 0.000146103896103895*G0_1_1_1_1_0 - 0.0001461038961039*G0_1_1_1_1_2 + 0.0002922077922078*G0_1_1_1_1_4 - 0.000292207792207801*G0_1_1_1_2_0 - 0.0001461038961039*G0_1_1_1_2_1 + 0.00116883116883121*G0_1_1_1_2_2 + 0.00116883116883121*G0_1_1_1_2_3 + 0.000730519480519504*G0_1_1_1_2_4 + 0.000584415584415605*G0_1_1_1_2_5 + 0.000584415584415603*G0_1_1_1_3_0 + 0.00116883116883121*G0_1_1_1_3_2 + 0.00233766233766243*G0_1_1_1_3_3 - 0.00175324675324681*G0_1_1_1_3_4 - 0.00233766233766242*G0_1_1_1_3_5 + 0.0007305194805195*G0_1_1_1_4_0 + 0.0002922077922078*G0_1_1_1_4_1 + 0.000730519480519504*G0_1_1_1_4_2 - 0.00175324675324681*G0_1_1_1_4_3 - 0.00467532467532482*G0_1_1_1_4_4 - 0.00175324675324681*G0_1_1_1_4_5 + 0.0011688311688312*G0_1_1_1_5_0 + 0.000584415584415605*G0_1_1_1_5_2 - 0.00233766233766242*G0_1_1_1_5_3 - 0.00175324675324681*G0_1_1_1_5_4 + 0.00233766233766239*G0_1_1_1_5_5 + 0.000693993506493524*G0_1_1_2_0_0 - 0.000292207792207801*G0_1_1_2_0_1 + 0.000693993506493524*G0_1_1_2_0_2 - 0.000146103896103903*G0_1_1_2_0_3 - 0.000146103896103904*G0_1_1_2_0_5 - 0.000292207792207801*G0_1_1_2_1_0 - 0.0001461038961039*G0_1_1_2_1_1 + 0.00116883116883121*G0_1_1_2_1_2 + 0.00116883116883121*G0_1_1_2_1_3 + 0.000730519480519504*G0_1_1_2_1_4 + 0.000584415584415605*G0_1_1_2_1_5 + 0.000693993506493524*G0_1_1_2_2_0 + 0.00116883116883121*G0_1_1_2_2_1 - 0.00997159090909113*G0_1_1_2_2_2 - 0.00599025974025994*G0_1_1_2_2_3 - 0.0020454545454546*G0_1_1_2_2_4 - 0.000730519480519507*G0_1_1_2_2_5 - 0.000146103896103903*G0_1_1_2_3_0 + 0.00116883116883121*G0_1_1_2_3_1 - 0.00599025974025994*G0_1_1_2_3_2 - 0.00525974025974045*G0_1_1_2_3_3 - 0.0011688311688312*G0_1_1_2_3_4 + 0.00175324675324681*G0_1_1_2_3_5 + 0.000730519480519504*G0_1_1_2_4_1 - 0.00204545454545459*G0_1_1_2_4_2 - 0.0011688311688312*G0_1_1_2_4_3 - 0.00233766233766241*G0_1_1_2_4_4 - 0.000146103896103904*G0_1_1_2_5_0 + 0.000584415584415605*G0_1_1_2_5_1 - 0.000730519480519507*G0_1_1_2_5_2 + 0.00175324675324681*G0_1_1_2_5_3 + 0.00175324675324681*G0_1_1_2_5_5 - 0.000730519480519502*G0_1_1_3_0_0 + 0.000584415584415603*G0_1_1_3_0_1 - 0.000146103896103903*G0_1_1_3_0_2 + 0.00175324675324682*G0_1_1_3_0_3 + 0.00175324675324682*G0_1_1_3_0_5 + 0.000584415584415603*G0_1_1_3_1_0 + 0.00116883116883121*G0_1_1_3_1_2 + 0.00233766233766243*G0_1_1_3_1_3 - 0.00175324675324681*G0_1_1_3_1_4 - 0.00233766233766242*G0_1_1_3_1_5 - 0.000146103896103903*G0_1_1_3_2_0 + 0.00116883116883121*G0_1_1_3_2_1 - 0.00599025974025994*G0_1_1_3_2_2 - 0.00525974025974045*G0_1_1_3_2_3 - 0.0011688311688312*G0_1_1_3_2_4 + 0.00175324675324681*G0_1_1_3_2_5 + 0.00175324675324682*G0_1_1_3_3_0 + 0.00233766233766243*G0_1_1_3_3_1 - 0.00525974025974045*G0_1_1_3_3_2 + 0.0210389610389617*G0_1_1_3_3_3 - 0.00701298701298726*G0_1_1_3_3_5 - 0.00175324675324681*G0_1_1_3_4_1 - 0.0011688311688312*G0_1_1_3_4_2 + 0.00935064935064963*G0_1_1_3_4_4 + 0.00175324675324682*G0_1_1_3_5_0 - 0.00233766233766242*G0_1_1_3_5_1 + 0.00175324675324681*G0_1_1_3_5_2 - 0.00701298701298726*G0_1_1_3_5_3 - 0.00701298701298726*G0_1_1_3_5_5 - 0.00204545454545459*G0_1_1_4_0_0 + 0.0007305194805195*G0_1_1_4_0_1 - 0.00233766233766239*G0_1_1_4_0_4 - 0.00116883116883119*G0_1_1_4_0_5 + 0.0007305194805195*G0_1_1_4_1_0 + 0.0002922077922078*G0_1_1_4_1_1 + 0.000730519480519504*G0_1_1_4_1_2 - 0.00175324675324681*G0_1_1_4_1_3 - 0.00467532467532482*G0_1_1_4_1_4 - 0.00175324675324681*G0_1_1_4_1_5 + 0.000730519480519504*G0_1_1_4_2_1 - 0.0020454545454546*G0_1_1_4_2_2 - 0.0011688311688312*G0_1_1_4_2_3 - 0.00233766233766241*G0_1_1_4_2_4 - 0.00175324675324681*G0_1_1_4_3_1 - 0.0011688311688312*G0_1_1_4_3_2 + 0.00935064935064963*G0_1_1_4_3_4 - 0.00233766233766239*G0_1_1_4_4_0 - 0.00467532467532482*G0_1_1_4_4_1 - 0.00233766233766241*G0_1_1_4_4_2 + 0.00935064935064963*G0_1_1_4_4_3 + 0.0420779220779234*G0_1_1_4_4_4 + 0.00935064935064964*G0_1_1_4_4_5 - 0.00116883116883119*G0_1_1_4_5_0 - 0.00175324675324681*G0_1_1_4_5_1 + 0.00935064935064964*G0_1_1_4_5_4 - 0.00599025974025989*G0_1_1_5_0_0 + 0.0011688311688312*G0_1_1_5_0_1 - 0.000146103896103904*G0_1_1_5_0_2 + 0.00175324675324682*G0_1_1_5_0_3 - 0.00116883116883119*G0_1_1_5_0_4 - 0.00525974025974038*G0_1_1_5_0_5 + 0.0011688311688312*G0_1_1_5_1_0 + 0.000584415584415605*G0_1_1_5_1_2 - 0.00233766233766242*G0_1_1_5_1_3 - 0.00175324675324681*G0_1_1_5_1_4 + 0.00233766233766239*G0_1_1_5_1_5 - 0.000146103896103904*G0_1_1_5_2_0 + 0.000584415584415605*G0_1_1_5_2_1 - 0.000730519480519507*G0_1_1_5_2_2 + 0.00175324675324681*G0_1_1_5_2_3 + 0.00175324675324681*G0_1_1_5_2_5 + 0.00175324675324682*G0_1_1_5_3_0 - 0.00233766233766242*G0_1_1_5_3_1 + 0.00175324675324681*G0_1_1_5_3_2 - 0.00701298701298726*G0_1_1_5_3_3 - 0.00701298701298726*G0_1_1_5_3_5 - 0.00116883116883119*G0_1_1_5_4_0 - 0.00175324675324681*G0_1_1_5_4_1 + 0.00935064935064964*G0_1_1_5_4_4 - 0.00525974025974038*G0_1_1_5_5_0 + 0.00233766233766239*G0_1_1_5_5_1 + 0.00175324675324681*G0_1_1_5_5_2 - 0.00701298701298726*G0_1_1_5_5_3 + 0.0210389610389618*G0_1_1_5_5_5;
    A[85] = -A[35] + 0.0242897727272736*G0_0_0_0_0_0 - 0.00110795454545458*G0_0_0_0_0_1 - 0.00367694805194818*G0_0_0_0_0_2 + 0.0219155844155852*G0_0_0_0_0_4 + 0.00267857142857153*G0_0_0_0_0_5 - 0.00110795454545458*G0_0_0_0_1_0 + 0.000365259740259747*G0_0_0_0_1_1 + 0.000547889610389628*G0_0_0_0_1_2 - 0.000487012987013004*G0_0_0_0_1_3 - 0.00204545454545462*G0_0_0_0_1_4 - 0.000487012987013*G0_0_0_0_1_5 - 0.00367694805194818*G0_0_0_0_2_0 + 0.000547889610389628*G0_0_0_0_2_1 + 0.0025689935064936*G0_0_0_0_2_2 - 0.0016071428571429*G0_0_0_0_2_3 - 0.00925324675324705*G0_0_0_0_2_4 - 0.00224025974025981*G0_0_0_0_2_5 - 0.000487012987013004*G0_0_0_0_3_1 - 0.0016071428571429*G0_0_0_0_3_2 - 0.0013636363636364*G0_0_0_0_3_3 + 0.00389610389610401*G0_0_0_0_3_4 + 0.00428571428571441*G0_0_0_0_3_5 + 0.0219155844155852*G0_0_0_0_4_0 - 0.00204545454545462*G0_0_0_0_4_1 - 0.00925324675324705*G0_0_0_0_4_2 + 0.00389610389610401*G0_0_0_0_4_3 + 0.0315584415584427*G0_0_0_0_4_4 + 0.00857142857142885*G0_0_0_0_4_5 + 0.00267857142857153*G0_0_0_0_5_0 - 0.000487012987013*G0_0_0_0_5_1 - 0.00224025974025981*G0_0_0_0_5_2 + 0.00428571428571441*G0_0_0_0_5_3 + 0.00857142857142885*G0_0_0_0_5_4 + 0.00487012987013*G0_0_0_0_5_5 - 0.00110795454545458*G0_0_0_1_0_0 + 0.000365259740259747*G0_0_0_1_0_1 + 0.000547889610389628*G0_0_0_1_0_2 - 0.000487012987013004*G0_0_0_1_0_3 - 0.00204545454545461*G0_0_0_1_0_4 - 0.000487012987013*G0_0_0_1_0_5 + 0.000365259740259747*G0_0_0_1_1_0 - 0.00401785714285718*G0_0_0_1_1_1 + 0.000974025974026001*G0_0_0_1_1_2 - 0.00146103896103899*G0_0_0_1_1_3 - 0.000974025974026004*G0_0_0_1_1_4 - 0.002922077922078*G0_0_0_1_1_5 + 0.000547889610389628*G0_0_0_1_2_0 + 0.000974025974026001*G0_0_0_1_2_1 + 0.00125405844155849*G0_0_0_1_2_2 - 0.00292207792207802*G0_0_0_1_2_3 - 0.0011201298701299*G0_0_0_1_2_4 - 0.00194805194805201*G0_0_0_1_2_5 - 0.000487012987013004*G0_0_0_1_3_0 - 0.00146103896103899*G0_0_0_1_3_1 - 0.00292207792207802*G0_0_0_1_3_2 - 0.002922077922078*G0_0_0_1_3_3 + 0.00292207792207802*G0_0_0_1_3_4 + 0.00487012987013003*G0_0_0_1_3_5 - 0.00204545454545461*G0_0_0_1_4_0 - 0.000974025974026004*G0_0_0_1_4_1 - 0.0011201298701299*G0_0_0_1_4_2 + 0.00292207792207802*G0_0_0_1_4_3 - 0.00623376623376644*G0_0_0_1_4_4 + 0.00584415584415603*G0_0_0_1_4_5 - 0.000487012987013*G0_0_0_1_5_0 - 0.002922077922078*G0_0_0_1_5_1 - 0.00194805194805201*G0_0_0_1_5_2 + 0.00487012987013003*G0_0_0_1_5_3 + 0.00584415584415603*G0_0_0_1_5_4 + 0.0107142857142861*G0_0_0_1_5_5 - 0.00367694805194818*G0_0_0_2_0_0 + 0.000547889610389628*G0_0_0_2_0_1 + 0.0025689935064936*G0_0_0_2_0_2 - 0.0016071428571429*G0_0_0_2_0_3 - 0.00925324675324705*G0_0_0_2_0_4 - 0.00224025974025981*G0_0_0_2_0_5 + 0.000547889610389628*G0_0_0_2_1_0 + 0.000974025974026001*G0_0_0_2_1_1 + 0.00125405844155849*G0_0_0_2_1_2 - 0.00292207792207802*G0_0_0_2_1_3 - 0.0011201298701299*G0_0_0_2_1_4 - 0.00194805194805201*G0_0_0_2_1_5 + 0.0025689935064936*G0_0_0_2_2_0 + 0.00125405844155849*G0_0_0_2_2_1 - 0.0401785714285729*G0_0_0_2_2_2 - 0.00370129870129885*G0_0_0_2_2_3 - 0.00214285714285726*G0_0_0_2_2_4 - 0.00199675324675332*G0_0_0_2_2_5 - 0.0016071428571429*G0_0_0_2_3_0 - 0.00292207792207802*G0_0_0_2_3_1 - 0.00370129870129885*G0_0_0_2_3_2 + 0.0132467532467537*G0_0_0_2_3_3 + 0.00545454545454562*G0_0_0_2_3_4 + 0.00720779220779244*G0_0_0_2_3_5 - 0.00925324675324705*G0_0_0_2_4_0 - 0.0011201298701299*G0_0_0_2_4_1 - 0.00214285714285726*G0_0_0_2_4_2 + 0.00545454545454562*G0_0_0_2_4_3 - 0.000779220779220836*G0_0_0_2_4_4 + 0.00623376623376643*G0_0_0_2_4_5 - 0.00224025974025981*G0_0_0_2_5_0 - 0.00194805194805201*G0_0_0_2_5_1 - 0.00199675324675332*G0_0_0_2_5_2 + 0.00720779220779244*G0_0_0_2_5_3 + 0.00623376623376643*G0_0_0_2_5_4 + 0.0136363636363641*G0_0_0_2_5_5 - 0.000487012987013004*G0_0_0_3_0_1 - 0.0016071428571429*G0_0_0_3_0_2 - 0.0013636363636364*G0_0_0_3_0_3 + 0.00389610389610401*G0_0_0_3_0_4 + 0.00428571428571441*G0_0_0_3_0_5 - 0.000487012987013004*G0_0_0_3_1_0 - 0.00146103896103899*G0_0_0_3_1_1 - 0.00292207792207802*G0_0_0_3_1_2 - 0.002922077922078*G0_0_0_3_1_3 + 0.00292207792207802*G0_0_0_3_1_4 + 0.00487012987013003*G0_0_0_3_1_5 - 0.0016071428571429*G0_0_0_3_2_0 - 0.00292207792207802*G0_0_0_3_2_1 - 0.00370129870129885*G0_0_0_3_2_2 + 0.0132467532467537*G0_0_0_3_2_3 + 0.00545454545454562*G0_0_0_3_2_4 + 0.00720779220779244*G0_0_0_3_2_5 - 0.0013636363636364*G0_0_0_3_3_0 - 0.002922077922078*G0_0_0_3_3_1 + 0.0132467532467537*G0_0_0_3_3_2 + 0.121558441558446*G0_0_0_3_3_3 - 0.0031168831168832*G0_0_0_3_3_4 - 0.011688311688312*G0_0_0_3_3_5 + 0.00389610389610402*G0_0_0_3_4_0 + 0.00292207792207802*G0_0_0_3_4_1 + 0.00545454545454562*G0_0_0_3_4_2 - 0.0031168831168832*G0_0_0_3_4_3 + 0.00467532467532483*G0_0_0_3_4_4 - 0.0202597402597409*G0_0_0_3_4_5 + 0.00428571428571441*G0_0_0_3_5_0 + 0.00487012987013003*G0_0_0_3_5_1 + 0.00720779220779244*G0_0_0_3_5_2 - 0.011688311688312*G0_0_0_3_5_3 - 0.0202597402597409*G0_0_0_3_5_4 - 0.035844155844157*G0_0_0_3_5_5 + 0.0219155844155852*G0_0_0_4_0_0 - 0.00204545454545461*G0_0_0_4_0_1 - 0.00925324675324705*G0_0_0_4_0_2 + 0.00389610389610401*G0_0_0_4_0_3 + 0.0315584415584427*G0_0_0_4_0_4 + 0.00857142857142885*G0_0_0_4_0_5 - 0.00204545454545462*G0_0_0_4_1_0 - 0.000974025974026004*G0_0_0_4_1_1 - 0.0011201298701299*G0_0_0_4_1_2 + 0.00292207792207802*G0_0_0_4_1_3 - 0.00623376623376644*G0_0_0_4_1_4 + 0.00584415584415603*G0_0_0_4_1_5 - 0.00925324675324706*G0_0_0_4_2_0 - 0.0011201298701299*G0_0_0_4_2_1 - 0.00214285714285726*G0_0_0_4_2_2 + 0.00545454545454562*G0_0_0_4_2_3 - 0.000779220779220838*G0_0_0_4_2_4 + 0.00623376623376644*G0_0_0_4_2_5 + 0.00389610389610401*G0_0_0_4_3_0 + 0.00292207792207802*G0_0_0_4_3_1 + 0.00545454545454562*G0_0_0_4_3_2 - 0.0031168831168832*G0_0_0_4_3_3 + 0.00467532467532483*G0_0_0_4_3_4 - 0.0202597402597409*G0_0_0_4_3_5 + 0.0315584415584427*G0_0_0_4_4_0 - 0.00623376623376644*G0_0_0_4_4_1 - 0.000779220779220834*G0_0_0_4_4_2 + 0.00467532467532483*G0_0_0_4_4_3 + 0.317922077922088*G0_0_0_4_4_4 + 0.00857142857142885*G0_0_0_4_5_0 + 0.00584415584415603*G0_0_0_4_5_1 + 0.00623376623376643*G0_0_0_4_5_2 - 0.0202597402597409*G0_0_0_4_5_3 - 0.0389610389610403*G0_0_0_4_5_5 + 0.00267857142857153*G0_0_0_5_0_0 - 0.000487012987013*G0_0_0_5_0_1 - 0.00224025974025981*G0_0_0_5_0_2 + 0.00428571428571441*G0_0_0_5_0_3 + 0.00857142857142885*G0_0_0_5_0_4 + 0.00487012987013*G0_0_0_5_0_5 - 0.000487012987013*G0_0_0_5_1_0 - 0.002922077922078*G0_0_0_5_1_1 - 0.00194805194805201*G0_0_0_5_1_2 + 0.00487012987013003*G0_0_0_5_1_3 + 0.00584415584415603*G0_0_0_5_1_4 + 0.0107142857142861*G0_0_0_5_1_5 - 0.00224025974025981*G0_0_0_5_2_0 - 0.00194805194805201*G0_0_0_5_2_1 - 0.00199675324675332*G0_0_0_5_2_2 + 0.00720779220779244*G0_0_0_5_2_3 + 0.00623376623376644*G0_0_0_5_2_4 + 0.0136363636363641*G0_0_0_5_2_5 + 0.00428571428571441*G0_0_0_5_3_0 + 0.00487012987013003*G0_0_0_5_3_1 + 0.00720779220779244*G0_0_0_5_3_2 - 0.011688311688312*G0_0_0_5_3_3 - 0.0202597402597409*G0_0_0_5_3_4 - 0.035844155844157*G0_0_0_5_3_5 + 0.00857142857142885*G0_0_0_5_4_0 + 0.00584415584415603*G0_0_0_5_4_1 + 0.00623376623376643*G0_0_0_5_4_2 - 0.0202597402597409*G0_0_0_5_4_3 - 0.0389610389610402*G0_0_0_5_4_5 + 0.00487012987013*G0_0_0_5_5_0 + 0.0107142857142861*G0_0_0_5_5_1 + 0.0136363636363641*G0_0_0_5_5_2 - 0.035844155844157*G0_0_0_5_5_3 - 0.0389610389610402*G0_0_0_5_5_4 - 0.0958441558441591*G0_0_0_5_5_5 - 0.0955154220779253*G0_0_1_0_0_0 + 0.00340909090909101*G0_0_1_0_0_1 + 0.00631899350649372*G0_0_1_0_0_2 - 0.00199675324675329*G0_0_1_0_0_3 - 0.0238636363636371*G0_0_1_0_0_4 - 0.0129058441558446*G0_0_1_0_0_5 + 0.00340909090909101*G0_0_1_0_1_0 + 0.00012175324675325*G0_0_1_0_1_1 + 0.000109577922077925*G0_0_1_0_1_2 - 0.000730519480519504*G0_0_1_0_1_3 + 0.000243506493506503*G0_0_1_0_1_4 - 0.00194805194805202*G0_0_1_0_1_5 + 0.00631899350649372*G0_0_1_0_2_0 + 0.000109577922077925*G0_0_1_0_2_1 + 0.000474837662337684*G0_0_1_0_2_2 - 0.0017045454545455*G0_0_1_0_2_3 - 0.0011688311688312*G0_0_1_0_2_4 - 0.00121753246753251*G0_0_1_0_2_5 - 0.00199675324675329*G0_0_1_0_3_0 - 0.000730519480519504*G0_0_1_0_3_1 - 0.0017045454545455*G0_0_1_0_3_2 + 0.00253246753246762*G0_0_1_0_3_3 + 0.00350649350649361*G0_0_1_0_3_4 + 0.00642857142857163*G0_0_1_0_3_5 - 0.0238636363636371*G0_0_1_0_4_0 + 0.000243506493506503*G0_0_1_0_4_1 - 0.0011688311688312*G0_0_1_0_4_2 + 0.00350649350649361*G0_0_1_0_4_3 - 0.0144155844155849*G0_0_1_0_4_4 + 0.001948051948052*G0_0_1_0_4_5 - 0.0129058441558446*G0_0_1_0_5_0 - 0.00194805194805202*G0_0_1_0_5_1 - 0.00121753246753251*G0_0_1_0_5_2 + 0.00642857142857163*G0_0_1_0_5_3 + 0.001948051948052*G0_0_1_0_5_4 + 0.017337662337663*G0_0_1_0_5_5 + 0.00340909090909101*G0_0_1_1_0_0 + 0.00012175324675325*G0_0_1_1_0_1 + 0.000109577922077925*G0_0_1_1_0_2 - 0.000730519480519504*G0_0_1_1_0_3 + 0.000243506493506503*G0_0_1_1_0_4 - 0.00194805194805202*G0_0_1_1_0_5 + 0.00012175324675325*G0_0_1_1_1_0 + 0.000608766233766252*G0_0_1_1_1_2 - 0.000730519480519495*G0_0_1_1_1_3 - 0.000730519480519502*G0_0_1_1_1_4 + 0.000730519480519517*G0_0_1_1_1_5 + 0.000109577922077925*G0_0_1_1_2_0 + 0.000608766233766251*G0_0_1_1_2_1 + 0.00104707792207796*G0_0_1_1_2_2 - 0.00243506493506501*G0_0_1_1_2_3 - 0.00141233766233771*G0_0_1_1_2_4 - 0.000730519480519503*G0_0_1_1_2_5 - 0.000730519480519504*G0_0_1_1_3_0 - 0.000730519480519495*G0_0_1_1_3_1 - 0.00243506493506501*G0_0_1_1_3_2 - 0.00194805194805202*G0_0_1_1_3_3 + 0.00292207792207801*G0_0_1_1_3_4 + 0.00292207792207801*G0_0_1_1_3_5 + 0.000243506493506503*G0_0_1_1_4_0 - 0.000730519480519502*G0_0_1_1_4_1 - 0.00141233766233771*G0_0_1_1_4_2 + 0.00292207792207801*G0_0_1_1_4_3 - 0.00233766233766242*G0_0_1_1_4_4 + 0.00292207792207801*G0_0_1_1_4_5 - 0.00194805194805202*G0_0_1_1_5_0 + 0.000730519480519517*G0_0_1_1_5_1 - 0.000730519480519503*G0_0_1_1_5_2 + 0.00292207792207801*G0_0_1_1_5_3 + 0.00292207792207801*G0_0_1_1_5_4 - 0.00389610389610405*G0_0_1_1_5_5 + 0.00631899350649372*G0_0_1_2_0_0 + 0.000109577922077925*G0_0_1_2_0_1 + 0.000474837662337684*G0_0_1_2_0_2 - 0.0017045454545455*G0_0_1_2_0_3 - 0.0011688311688312*G0_0_1_2_0_4 - 0.00121753246753251*G0_0_1_2_0_5 + 0.000109577922077925*G0_0_1_2_1_0 + 0.000608766233766252*G0_0_1_2_1_1 + 0.00104707792207796*G0_0_1_2_1_2 - 0.00243506493506501*G0_0_1_2_1_3 - 0.00141233766233771*G0_0_1_2_1_4 - 0.000730519480519503*G0_0_1_2_1_5 + 0.000474837662337684*G0_0_1_2_2_0 + 0.00104707792207796*G0_0_1_2_2_1 - 0.0361972402597416*G0_0_1_2_2_2 - 0.00345779220779234*G0_0_1_2_2_3 - 0.00214285714285725*G0_0_1_2_2_4 - 0.00150974025974031*G0_0_1_2_2_5 - 0.0017045454545455*G0_0_1_2_3_0 - 0.00243506493506501*G0_0_1_2_3_1 - 0.00345779220779234*G0_0_1_2_3_2 + 0.0142207792207797*G0_0_1_2_3_3 + 0.00623376623376643*G0_0_1_2_3_4 + 0.00642857142857164*G0_0_1_2_3_5 - 0.0011688311688312*G0_0_1_2_4_0 - 0.00141233766233771*G0_0_1_2_4_1 - 0.00214285714285725*G0_0_1_2_4_2 + 0.00623376623376643*G0_0_1_2_4_3 + 0.0167532467532473*G0_0_1_2_4_4 + 0.00584415584415603*G0_0_1_2_4_5 - 0.00121753246753251*G0_0_1_2_5_0 - 0.000730519480519503*G0_0_1_2_5_1 - 0.00150974025974031*G0_0_1_2_5_2 + 0.00642857142857164*G0_0_1_2_5_3 + 0.00584415584415603*G0_0_1_2_5_4 + 0.00564935064935083*G0_0_1_2_5_5 - 0.00199675324675329*G0_0_1_3_0_0 - 0.000730519480519504*G0_0_1_3_0_1 - 0.0017045454545455*G0_0_1_3_0_2 + 0.00253246753246762*G0_0_1_3_0_3 + 0.00350649350649361*G0_0_1_3_0_4 + 0.00642857142857163*G0_0_1_3_0_5 - 0.000730519480519504*G0_0_1_3_1_0 - 0.000730519480519495*G0_0_1_3_1_1 - 0.00243506493506501*G0_0_1_3_1_2 - 0.00194805194805202*G0_0_1_3_1_3 + 0.00292207792207801*G0_0_1_3_1_4 + 0.00292207792207801*G0_0_1_3_1_5 - 0.0017045454545455*G0_0_1_3_2_0 - 0.00243506493506501*G0_0_1_3_2_1 - 0.00345779220779234*G0_0_1_3_2_2 + 0.0142207792207797*G0_0_1_3_2_3 + 0.00623376623376643*G0_0_1_3_2_4 + 0.00642857142857164*G0_0_1_3_2_5 + 0.00253246753246762*G0_0_1_3_3_0 - 0.00194805194805202*G0_0_1_3_3_1 + 0.0142207792207797*G0_0_1_3_3_2 + 0.0911688311688344*G0_0_1_3_3_3 - 0.0109090909090912*G0_0_1_3_3_4 - 0.0179220779220785*G0_0_1_3_3_5 + 0.00350649350649361*G0_0_1_3_4_0 + 0.00292207792207801*G0_0_1_3_4_1 + 0.00623376623376643*G0_0_1_3_4_2 - 0.0109090909090912*G0_0_1_3_4_3 - 0.00233766233766239*G0_0_1_3_4_4 - 0.0187012987012993*G0_0_1_3_4_5 + 0.00642857142857163*G0_0_1_3_5_0 + 0.00292207792207801*G0_0_1_3_5_1 + 0.00642857142857164*G0_0_1_3_5_2 - 0.0179220779220785*G0_0_1_3_5_3 - 0.0187012987012993*G0_0_1_3_5_4 - 0.0241558441558449*G0_0_1_3_5_5 - 0.0238636363636371*G0_0_1_4_0_0 + 0.000243506493506503*G0_0_1_4_0_1 - 0.0011688311688312*G0_0_1_4_0_2 + 0.00350649350649361*G0_0_1_4_0_3 - 0.0144155844155849*G0_0_1_4_0_4 + 0.001948051948052*G0_0_1_4_0_5 + 0.000243506493506503*G0_0_1_4_1_0 - 0.000730519480519502*G0_0_1_4_1_1 - 0.00141233766233771*G0_0_1_4_1_2 + 0.00292207792207801*G0_0_1_4_1_3 - 0.00233766233766242*G0_0_1_4_1_4 + 0.00292207792207801*G0_0_1_4_1_5 - 0.0011688311688312*G0_0_1_4_2_0 - 0.00141233766233771*G0_0_1_4_2_1 - 0.00214285714285725*G0_0_1_4_2_2 + 0.00623376623376643*G0_0_1_4_2_3 + 0.0167532467532473*G0_0_1_4_2_4 + 0.00584415584415604*G0_0_1_4_2_5 + 0.00350649350649361*G0_0_1_4_3_0 + 0.00292207792207801*G0_0_1_4_3_1 + 0.00623376623376643*G0_0_1_4_3_2 - 0.0109090909090912*G0_0_1_4_3_3 - 0.00233766233766239*G0_0_1_4_3_4 - 0.0187012987012993*G0_0_1_4_3_5 - 0.0144155844155849*G0_0_1_4_4_0 - 0.00233766233766242*G0_0_1_4_4_1 + 0.0167532467532473*G0_0_1_4_4_2 - 0.00233766233766239*G0_0_1_4_4_3 + 0.189350649350655*G0_0_1_4_4_4 - 0.00701298701298721*G0_0_1_4_4_5 + 0.001948051948052*G0_0_1_4_5_0 + 0.00292207792207801*G0_0_1_4_5_1 + 0.00584415584415603*G0_0_1_4_5_2 - 0.0187012987012993*G0_0_1_4_5_3 - 0.00701298701298721*G0_0_1_4_5_4 - 0.0171428571428577*G0_0_1_4_5_5 - 0.0129058441558446*G0_0_1_5_0_0 - 0.00194805194805202*G0_0_1_5_0_1 - 0.00121753246753251*G0_0_1_5_0_2 + 0.00642857142857163*G0_0_1_5_0_3 + 0.001948051948052*G0_0_1_5_0_4 + 0.017337662337663*G0_0_1_5_0_5 - 0.00194805194805202*G0_0_1_5_1_0 + 0.000730519480519517*G0_0_1_5_1_1 - 0.000730519480519503*G0_0_1_5_1_2 + 0.00292207792207801*G0_0_1_5_1_3 + 0.00292207792207801*G0_0_1_5_1_4 - 0.00389610389610405*G0_0_1_5_1_5 - 0.00121753246753251*G0_0_1_5_2_0 - 0.000730519480519503*G0_0_1_5_2_1 - 0.00150974025974031*G0_0_1_5_2_2 + 0.00642857142857164*G0_0_1_5_2_3 + 0.00584415584415603*G0_0_1_5_2_4 + 0.00564935064935083*G0_0_1_5_2_5 + 0.00642857142857163*G0_0_1_5_3_0 + 0.00292207792207801*G0_0_1_5_3_1 + 0.00642857142857164*G0_0_1_5_3_2 - 0.0179220779220785*G0_0_1_5_3_3 - 0.0187012987012993*G0_0_1_5_3_4 - 0.0241558441558449*G0_0_1_5_3_5 + 0.001948051948052*G0_0_1_5_4_0 + 0.00292207792207801*G0_0_1_5_4_1 + 0.00584415584415603*G0_0_1_5_4_2 - 0.0187012987012993*G0_0_1_5_4_3 - 0.00701298701298721*G0_0_1_5_4_4 - 0.0171428571428577*G0_0_1_5_4_5 + 0.017337662337663*G0_0_1_5_5_0 - 0.00389610389610405*G0_0_1_5_5_1 + 0.00564935064935083*G0_0_1_5_5_2 - 0.0241558441558449*G0_0_1_5_5_3 - 0.0171428571428577*G0_0_1_5_5_4 + 0.0350649350649364*G0_0_1_5_5_5;
    A[58] = A[85] + 0.0887581168831198*G0_0_1_0_0_0 - 0.00288555194805203*G0_0_1_0_0_1 - 0.00507711038961056*G0_0_1_0_0_2 + 0.00102272727272729*G0_0_1_0_0_3 + 0.0204545454545461*G0_0_1_0_0_4 + 0.010227272727273*G0_0_1_0_0_5 - 0.00288555194805203*G0_0_1_0_1_0 + 0.000401785714285721*G0_0_1_0_1_1 - 0.000133928571428576*G0_0_1_0_1_2 + 0.000925324675324706*G0_0_1_0_1_3 + 0.00214285714285722*G0_0_1_0_1_5 - 0.00507711038961055*G0_0_1_0_2_0 - 0.000133928571428576*G0_0_1_0_2_1 + 0.000328733766233776*G0_0_1_0_2_2 + 0.000633116883116903*G0_0_1_0_2_3 - 0.000194805194805198*G0_0_1_0_2_4 + 0.000827922077922107*G0_0_1_0_2_5 + 0.00102272727272729*G0_0_1_0_3_0 + 0.000925324675324706*G0_0_1_0_3_1 + 0.000633116883116903*G0_0_1_0_3_2 - 0.0017532467532468*G0_0_1_0_3_3 - 0.00194805194805201*G0_0_1_0_3_4 - 0.00370129870129882*G0_0_1_0_3_5 + 0.0204545454545461*G0_0_1_0_4_0 - 0.000194805194805198*G0_0_1_0_4_2 - 0.00194805194805201*G0_0_1_0_4_3 + 0.00740259740259761*G0_0_1_0_4_4 - 0.00155844155844161*G0_0_1_0_4_5 + 0.010227272727273*G0_0_1_0_5_0 + 0.00214285714285722*G0_0_1_0_5_1 + 0.000827922077922107*G0_0_1_0_5_2 - 0.00370129870129882*G0_0_1_0_5_3 - 0.00155844155844161*G0_0_1_0_5_4 - 0.0159740259740266*G0_0_1_0_5_5 - 0.00288555194805203*G0_0_1_1_0_0 + 0.000401785714285721*G0_0_1_1_0_1 - 0.000133928571428576*G0_0_1_1_0_2 + 0.000925324675324706*G0_0_1_1_0_3 + 0.00214285714285722*G0_0_1_1_0_5 + 0.000401785714285721*G0_0_1_1_1_0 - 0.00675730519480533*G0_0_1_1_1_1 + 0.000633116883116904*G0_0_1_1_1_2 - 0.00267857142857152*G0_0_1_1_1_3 - 0.000243506493506502*G0_0_1_1_1_4 - 0.00340909090909101*G0_0_1_1_1_5 - 0.000133928571428576*G0_0_1_1_2_0 + 0.000633116883116904*G0_0_1_1_2_1 - 0.000243506493506504*G0_0_1_1_2_2 + 0.00107142857142861*G0_0_1_1_2_3 + 0.000340909090909101*G0_0_1_1_2_4 + 0.000340909090909101*G0_0_1_1_2_5 + 0.000925324675324706*G0_0_1_1_3_0 - 0.00267857142857152*G0_0_1_1_3_1 + 0.00107142857142861*G0_0_1_1_3_2 - 0.00506493506493526*G0_0_1_1_3_3 - 0.00136363636363641*G0_0_1_1_3_4 - 0.00253246753246762*G0_0_1_1_3_5 - 0.000243506493506502*G0_0_1_1_4_1 + 0.000340909090909101*G0_0_1_1_4_2 - 0.00136363636363641*G0_0_1_1_4_3 + 0.00311688311688323*G0_0_1_1_4_4 - 0.000194805194805194*G0_0_1_1_4_5 + 0.00214285714285722*G0_0_1_1_5_0 - 0.00340909090909101*G0_0_1_1_5_1 + 0.000340909090909101*G0_0_1_1_5_2 - 0.00253246753246762*G0_0_1_1_5_3 - 0.000194805194805194*G0_0_1_1_5_4 + 0.00525974025974048*G0_0_1_1_5_5 - 0.00507711038961056*G0_0_1_2_0_0 - 0.000133928571428576*G0_0_1_2_0_1 + 0.000328733766233776*G0_0_1_2_0_2 + 0.000633116883116902*G0_0_1_2_0_3 - 0.000194805194805198*G0_0_1_2_0_4 + 0.000827922077922107*G0_0_1_2_0_5 - 0.000133928571428576*G0_0_1_2_1_0 + 0.000633116883116904*G0_0_1_2_1_1 - 0.000243506493506504*G0_0_1_2_1_2 + 0.00107142857142861*G0_0_1_2_1_3 + 0.000340909090909101*G0_0_1_2_1_4 + 0.000340909090909101*G0_0_1_2_1_5 + 0.000328733766233776*G0_0_1_2_2_0 - 0.000243506493506504*G0_0_1_2_2_1 + 0.00113230519480525*G0_0_1_2_2_2 + 0.000535714285714311*G0_0_1_2_2_3 - 0.000779220779220803*G0_0_1_2_2_4 + 0.000633116883116903*G0_0_1_2_2_5 + 0.000633116883116902*G0_0_1_2_3_0 + 0.00107142857142861*G0_0_1_2_3_1 + 0.000535714285714311*G0_0_1_2_3_2 - 0.000974025974025976*G0_0_1_2_3_3 - 0.00194805194805201*G0_0_1_2_3_4 - 0.00253246753246761*G0_0_1_2_3_5 - 0.000194805194805198*G0_0_1_2_4_0 + 0.000340909090909101*G0_0_1_2_4_1 - 0.000779220779220803*G0_0_1_2_4_2 - 0.00194805194805201*G0_0_1_2_4_3 - 0.00350649350649361*G0_0_1_2_4_4 - 0.00194805194805201*G0_0_1_2_4_5 + 0.000827922077922107*G0_0_1_2_5_0 + 0.000340909090909101*G0_0_1_2_5_1 + 0.000633116883116903*G0_0_1_2_5_2 - 0.00253246753246761*G0_0_1_2_5_3 - 0.00194805194805201*G0_0_1_2_5_4 - 0.00214285714285721*G0_0_1_2_5_5 + 0.00102272727272729*G0_0_1_3_0_0 + 0.000925324675324706*G0_0_1_3_0_1 + 0.000633116883116902*G0_0_1_3_0_2 - 0.0017532467532468*G0_0_1_3_0_3 - 0.00194805194805201*G0_0_1_3_0_4 - 0.00370129870129882*G0_0_1_3_0_5 + 0.000925324675324706*G0_0_1_3_1_0 - 0.00267857142857152*G0_0_1_3_1_1 + 0.00107142857142861*G0_0_1_3_1_2 - 0.00506493506493526*G0_0_1_3_1_3 - 0.00136363636363641*G0_0_1_3_1_4 - 0.00253246753246762*G0_0_1_3_1_5 + 0.000633116883116902*G0_0_1_3_2_0 + 0.00107142857142861*G0_0_1_3_2_1 + 0.000535714285714311*G0_0_1_3_2_2 - 0.000974025974025976*G0_0_1_3_2_3 - 0.00194805194805201*G0_0_1_3_2_4 - 0.00253246753246761*G0_0_1_3_2_5 - 0.0017532467532468*G0_0_1_3_3_0 - 0.00506493506493526*G0_0_1_3_3_1 - 0.000974025974025978*G0_0_1_3_3_2 - 0.00701298701298728*G0_0_1_3_3_3 + 0.00623376623376642*G0_0_1_3_3_4 + 0.00857142857142883*G0_0_1_3_3_5 - 0.00194805194805201*G0_0_1_3_4_0 - 0.00136363636363641*G0_0_1_3_4_1 - 0.00194805194805201*G0_0_1_3_4_2 + 0.00623376623376642*G0_0_1_3_4_3 - 0.00233766233766243*G0_0_1_3_4_4 + 0.00779220779220803*G0_0_1_3_4_5 - 0.00370129870129882*G0_0_1_3_5_0 - 0.00253246753246762*G0_0_1_3_5_1 - 0.00253246753246761*G0_0_1_3_5_2 + 0.00857142857142883*G0_0_1_3_5_3 + 0.00779220779220803*G0_0_1_3_5_4 + 0.0116883116883121*G0_0_1_3_5_5 + 0.0204545454545461*G0_0_1_4_0_0 - 0.000194805194805198*G0_0_1_4_0_2 - 0.00194805194805201*G0_0_1_4_0_3 + 0.00740259740259761*G0_0_1_4_0_4 - 0.00155844155844161*G0_0_1_4_0_5 - 0.000243506493506502*G0_0_1_4_1_1 + 0.000340909090909101*G0_0_1_4_1_2 - 0.00136363636363641*G0_0_1_4_1_3 + 0.00311688311688323*G0_0_1_4_1_4 - 0.000194805194805194*G0_0_1_4_1_5 - 0.000194805194805198*G0_0_1_4_2_0 + 0.0003409090909091*G0_0_1_4_2_1 - 0.000779220779220803*G0_0_1_4_2_2 - 0.00194805194805201*G0_0_1_4_2_3 - 0.00350649350649361*G0_0_1_4_2_4 - 0.00194805194805201*G0_0_1_4_2_5 - 0.00194805194805201*G0_0_1_4_3_0 - 0.00136363636363641*G0_0_1_4_3_1 - 0.00194805194805201*G0_0_1_4_3_2 + 0.00623376623376642*G0_0_1_4_3_3 - 0.00233766233766243*G0_0_1_4_3_4 + 0.00779220779220803*G0_0_1_4_3_5 + 0.00740259740259762*G0_0_1_4_4_0 + 0.00311688311688323*G0_0_1_4_4_1 - 0.00350649350649361*G0_0_1_4_4_2 - 0.00233766233766243*G0_0_1_4_4_3 - 0.105194805194809*G0_0_1_4_4_4 - 0.00233766233766245*G0_0_1_4_4_5 - 0.00155844155844161*G0_0_1_4_5_0 - 0.000194805194805194*G0_0_1_4_5_1 - 0.00194805194805201*G0_0_1_4_5_2 + 0.00779220779220803*G0_0_1_4_5_3 - 0.00233766233766245*G0_0_1_4_5_4 + 0.0046753246753248*G0_0_1_4_5_5 + 0.010227272727273*G0_0_1_5_0_0 + 0.00214285714285722*G0_0_1_5_0_1 + 0.000827922077922107*G0_0_1_5_0_2 - 0.00370129870129882*G0_0_1_5_0_3 - 0.00155844155844161*G0_0_1_5_0_4 - 0.0159740259740266*G0_0_1_5_0_5 + 0.00214285714285722*G0_0_1_5_1_0 - 0.00340909090909101*G0_0_1_5_1_1 + 0.000340909090909101*G0_0_1_5_1_2 - 0.00253246753246762*G0_0_1_5_1_3 - 0.000194805194805194*G0_0_1_5_1_4 + 0.00525974025974048*G0_0_1_5_1_5 + 0.000827922077922107*G0_0_1_5_2_0 + 0.000340909090909101*G0_0_1_5_2_1 + 0.000633116883116903*G0_0_1_5_2_2 - 0.00253246753246761*G0_0_1_5_2_3 - 0.00194805194805201*G0_0_1_5_2_4 - 0.00214285714285721*G0_0_1_5_2_5 - 0.00370129870129882*G0_0_1_5_3_0 - 0.00253246753246762*G0_0_1_5_3_1 - 0.00253246753246761*G0_0_1_5_3_2 + 0.00857142857142883*G0_0_1_5_3_3 + 0.00779220779220803*G0_0_1_5_3_4 + 0.0116883116883121*G0_0_1_5_3_5 - 0.00155844155844161*G0_0_1_5_4_0 - 0.000194805194805194*G0_0_1_5_4_1 - 0.00194805194805201*G0_0_1_5_4_2 + 0.00779220779220803*G0_0_1_5_4_3 - 0.00233766233766244*G0_0_1_5_4_4 + 0.0046753246753248*G0_0_1_5_4_5 - 0.0159740259740266*G0_0_1_5_5_0 + 0.00525974025974048*G0_0_1_5_5_1 - 0.00214285714285721*G0_0_1_5_5_2 + 0.0116883116883121*G0_0_1_5_5_3 + 0.0046753246753248*G0_0_1_5_5_4 - 0.0420779220779236*G0_0_1_5_5_5 - 0.0887581168831198*G0_1_0_0_0_0 + 0.00288555194805203*G0_1_0_0_0_1 + 0.00507711038961056*G0_1_0_0_0_2 - 0.00102272727272729*G0_1_0_0_0_3 - 0.0204545454545461*G0_1_0_0_0_4 - 0.010227272727273*G0_1_0_0_0_5 + 0.00288555194805203*G0_1_0_0_1_0 - 0.000401785714285721*G0_1_0_0_1_1 + 0.000133928571428576*G0_1_0_0_1_2 - 0.000925324675324706*G0_1_0_0_1_3 - 0.00214285714285722*G0_1_0_0_1_5 + 0.00507711038961055*G0_1_0_0_2_0 + 0.000133928571428576*G0_1_0_0_2_1 - 0.000328733766233776*G0_1_0_0_2_2 - 0.000633116883116903*G0_1_0_0_2_3 + 0.000194805194805198*G0_1_0_0_2_4 - 0.000827922077922106*G0_1_0_0_2_5 - 0.00102272727272729*G0_1_0_0_3_0 - 0.000925324675324706*G0_1_0_0_3_1 - 0.000633116883116903*G0_1_0_0_3_2 + 0.0017532467532468*G0_1_0_0_3_3 + 0.00194805194805201*G0_1_0_0_3_4 + 0.00370129870129882*G0_1_0_0_3_5 - 0.0204545454545461*G0_1_0_0_4_0 + 0.000194805194805198*G0_1_0_0_4_2 + 0.00194805194805201*G0_1_0_0_4_3 - 0.00740259740259761*G0_1_0_0_4_4 + 0.00155844155844161*G0_1_0_0_4_5 - 0.010227272727273*G0_1_0_0_5_0 - 0.00214285714285722*G0_1_0_0_5_1 - 0.000827922077922107*G0_1_0_0_5_2 + 0.00370129870129882*G0_1_0_0_5_3 + 0.00155844155844161*G0_1_0_0_5_4 + 0.0159740259740266*G0_1_0_0_5_5 + 0.00288555194805203*G0_1_0_1_0_0 - 0.000401785714285721*G0_1_0_1_0_1 + 0.000133928571428576*G0_1_0_1_0_2 - 0.000925324675324706*G0_1_0_1_0_3 - 0.00214285714285722*G0_1_0_1_0_5 - 0.000401785714285721*G0_1_0_1_1_0 + 0.00675730519480533*G0_1_0_1_1_1 - 0.000633116883116904*G0_1_0_1_1_2 + 0.00267857142857152*G0_1_0_1_1_3 + 0.000243506493506502*G0_1_0_1_1_4 + 0.00340909090909101*G0_1_0_1_1_5 + 0.000133928571428576*G0_1_0_1_2_0 - 0.000633116883116905*G0_1_0_1_2_1 + 0.000243506493506504*G0_1_0_1_2_2 - 0.00107142857142861*G0_1_0_1_2_3 - 0.0003409090909091*G0_1_0_1_2_4 - 0.000340909090909101*G0_1_0_1_2_5 - 0.000925324675324706*G0_1_0_1_3_0 + 0.00267857142857152*G0_1_0_1_3_1 - 0.00107142857142861*G0_1_0_1_3_2 + 0.00506493506493526*G0_1_0_1_3_3 + 0.00136363636363641*G0_1_0_1_3_4 + 0.00253246753246762*G0_1_0_1_3_5 + 0.000243506493506502*G0_1_0_1_4_1 - 0.000340909090909101*G0_1_0_1_4_2 + 0.00136363636363641*G0_1_0_1_4_3 - 0.00311688311688323*G0_1_0_1_4_4 + 0.000194805194805194*G0_1_0_1_4_5 - 0.00214285714285722*G0_1_0_1_5_0 + 0.00340909090909101*G0_1_0_1_5_1 - 0.000340909090909101*G0_1_0_1_5_2 + 0.00253246753246762*G0_1_0_1_5_3 + 0.000194805194805194*G0_1_0_1_5_4 - 0.00525974025974048*G0_1_0_1_5_5 + 0.00507711038961056*G0_1_0_2_0_0 + 0.000133928571428576*G0_1_0_2_0_1 - 0.000328733766233776*G0_1_0_2_0_2 - 0.000633116883116902*G0_1_0_2_0_3 + 0.000194805194805198*G0_1_0_2_0_4 - 0.000827922077922107*G0_1_0_2_0_5 + 0.000133928571428576*G0_1_0_2_1_0 - 0.000633116883116905*G0_1_0_2_1_1 + 0.000243506493506504*G0_1_0_2_1_2 - 0.00107142857142861*G0_1_0_2_1_3 - 0.0003409090909091*G0_1_0_2_1_4 - 0.000340909090909101*G0_1_0_2_1_5 - 0.000328733766233776*G0_1_0_2_2_0 + 0.000243506493506504*G0_1_0_2_2_1 - 0.00113230519480525*G0_1_0_2_2_2 - 0.000535714285714311*G0_1_0_2_2_3 + 0.000779220779220803*G0_1_0_2_2_4 - 0.000633116883116903*G0_1_0_2_2_5 - 0.000633116883116902*G0_1_0_2_3_0 - 0.00107142857142861*G0_1_0_2_3_1 - 0.000535714285714311*G0_1_0_2_3_2 + 0.000974025974025974*G0_1_0_2_3_3 + 0.00194805194805201*G0_1_0_2_3_4 + 0.00253246753246761*G0_1_0_2_3_5 + 0.000194805194805198*G0_1_0_2_4_0 - 0.0003409090909091*G0_1_0_2_4_1 + 0.000779220779220803*G0_1_0_2_4_2 + 0.00194805194805201*G0_1_0_2_4_3 + 0.00350649350649361*G0_1_0_2_4_4 + 0.00194805194805201*G0_1_0_2_4_5 - 0.000827922077922107*G0_1_0_2_5_0 - 0.000340909090909101*G0_1_0_2_5_1 - 0.000633116883116903*G0_1_0_2_5_2 + 0.00253246753246761*G0_1_0_2_5_3 + 0.00194805194805201*G0_1_0_2_5_4 + 0.00214285714285721*G0_1_0_2_5_5 - 0.00102272727272729*G0_1_0_3_0_0 - 0.000925324675324706*G0_1_0_3_0_1 - 0.000633116883116902*G0_1_0_3_0_2 + 0.0017532467532468*G0_1_0_3_0_3 + 0.00194805194805201*G0_1_0_3_0_4 + 0.00370129870129882*G0_1_0_3_0_5 - 0.000925324675324706*G0_1_0_3_1_0 + 0.00267857142857152*G0_1_0_3_1_1 - 0.00107142857142861*G0_1_0_3_1_2 + 0.00506493506493526*G0_1_0_3_1_3 + 0.00136363636363641*G0_1_0_3_1_4 + 0.00253246753246762*G0_1_0_3_1_5 - 0.000633116883116902*G0_1_0_3_2_0 - 0.00107142857142861*G0_1_0_3_2_1 - 0.000535714285714311*G0_1_0_3_2_2 + 0.000974025974025974*G0_1_0_3_2_3 + 0.00194805194805201*G0_1_0_3_2_4 + 0.00253246753246761*G0_1_0_3_2_5 + 0.0017532467532468*G0_1_0_3_3_0 + 0.00506493506493526*G0_1_0_3_3_1 + 0.000974025974025976*G0_1_0_3_3_2 + 0.00701298701298729*G0_1_0_3_3_3 - 0.00623376623376642*G0_1_0_3_3_4 - 0.00857142857142883*G0_1_0_3_3_5 + 0.00194805194805201*G0_1_0_3_4_0 + 0.00136363636363641*G0_1_0_3_4_1 + 0.00194805194805201*G0_1_0_3_4_2 - 0.00623376623376642*G0_1_0_3_4_3 + 0.00233766233766243*G0_1_0_3_4_4 - 0.00779220779220803*G0_1_0_3_4_5 + 0.00370129870129882*G0_1_0_3_5_0 + 0.00253246753246762*G0_1_0_3_5_1 + 0.00253246753246761*G0_1_0_3_5_2 - 0.00857142857142883*G0_1_0_3_5_3 - 0.00779220779220803*G0_1_0_3_5_4 - 0.0116883116883121*G0_1_0_3_5_5 - 0.0204545454545461*G0_1_0_4_0_0 + 0.000194805194805198*G0_1_0_4_0_2 + 0.00194805194805201*G0_1_0_4_0_3 - 0.00740259740259761*G0_1_0_4_0_4 + 0.00155844155844161*G0_1_0_4_0_5 + 0.000243506493506502*G0_1_0_4_1_1 - 0.000340909090909101*G0_1_0_4_1_2 + 0.00136363636363641*G0_1_0_4_1_3 - 0.00311688311688323*G0_1_0_4_1_4 + 0.000194805194805194*G0_1_0_4_1_5 + 0.000194805194805198*G0_1_0_4_2_0 - 0.0003409090909091*G0_1_0_4_2_1 + 0.000779220779220803*G0_1_0_4_2_2 + 0.00194805194805201*G0_1_0_4_2_3 + 0.00350649350649361*G0_1_0_4_2_4 + 0.00194805194805201*G0_1_0_4_2_5 + 0.00194805194805201*G0_1_0_4_3_0 + 0.00136363636363641*G0_1_0_4_3_1 + 0.00194805194805201*G0_1_0_4_3_2 - 0.00623376623376642*G0_1_0_4_3_3 + 0.00233766233766243*G0_1_0_4_3_4 - 0.00779220779220803*G0_1_0_4_3_5 - 0.00740259740259762*G0_1_0_4_4_0 - 0.00311688311688323*G0_1_0_4_4_1 + 0.00350649350649361*G0_1_0_4_4_2 + 0.00233766233766243*G0_1_0_4_4_3 + 0.105194805194809*G0_1_0_4_4_4 + 0.00233766233766245*G0_1_0_4_4_5 + 0.00155844155844161*G0_1_0_4_5_0 + 0.000194805194805194*G0_1_0_4_5_1 + 0.00194805194805201*G0_1_0_4_5_2 - 0.00779220779220803*G0_1_0_4_5_3 + 0.00233766233766245*G0_1_0_4_5_4 - 0.0046753246753248*G0_1_0_4_5_5 - 0.010227272727273*G0_1_0_5_0_0 - 0.00214285714285722*G0_1_0_5_0_1 - 0.0008279220779221