// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'quadrature'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __MASS_MATRIX_F2_P3_Q4_QUADRATURE_H
#define __MASS_MATRIX_F2_P3_Q4_QUADRATURE_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class mass_matrix_f2_p3_q4_quadrature_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  mass_matrix_f2_p3_q4_quadrature_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_quadrature_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, -0.0288675134594813, -0.0166666666666667, 0.0782460796435952, 0.0606091526731326, 0.0349927106111882, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333333, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807677, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, -0.0288675134594813, -0.0166666666666667, 0.0782460796435952, 0.0606091526731326, 0.0349927106111882, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333333, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807677, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new mass_matrix_f2_p3_q4_quadrature_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class mass_matrix_f2_p3_q4_quadrature_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  mass_matrix_f2_p3_q4_quadrature_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_quadrature_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233824, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421162, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.0388807895679869, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968254, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977598, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0109971479845644, 0.00634920634920633, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406278, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977598, 0.026770604530526, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527351, -0.0109971479845643, 0.00634920634920644, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382571, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984127, -0.243432247780074, 0.0, 0.0544331053951818, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.0518410527573159, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924092, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087791, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233824, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421162, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.0388807895679869, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968254, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977598, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0109971479845644, 0.00634920634920633, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406278, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977598, 0.026770604530526, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527351, -0.0109971479845643, 0.00634920634920644, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382571, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984127, -0.243432247780074, 0.0, 0.0544331053951818, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.0518410527573159, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924092, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087791, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999964, 0.0, 17.7482393492989, 0.0, 0.553283335172491, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933239, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285715, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206987, 8.87411967464942, -1.07142857142857, 0.276641667586245, -0.0958314847499915, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306815, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.0623058987491, 8.50420064270761, -2.1957751641342, 0.760638829255664, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.4230748895809, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393186, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696594, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new mass_matrix_f2_p3_q4_quadrature_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class mass_matrix_f2_p3_q4_quadrature_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  mass_matrix_f2_p3_q4_quadrature_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_quadrature_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new mass_matrix_f2_p3_q4_quadrature_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class mass_matrix_f2_p3_q4_quadrature_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  mass_matrix_f2_p3_q4_quadrature_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_quadrature_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3*m.num_entities[1] + 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[12] = offset + 3*c.entity_indices[2][0];
    dofs[13] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[14] = offset + 3*c.entity_indices[2][0] + 2;
    offset += 3*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 12;
      dofs[1] = 13;
      dofs[2] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75*x[1][0] + 0.25*x[2][0];
    coordinates[3][1] = 0.75*x[1][1] + 0.25*x[2][1];
    coordinates[4][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.25*x[1][0] + 0.75*x[2][0];
    coordinates[5][1] = 0.25*x[1][1] + 0.75*x[2][1];
    coordinates[6][0] = 0.75*x[0][0] + 0.25*x[2][0];
    coordinates[6][1] = 0.75*x[0][1] + 0.25*x[2][1];
    coordinates[7][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[7][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[8][0] = 0.25*x[0][0] + 0.75*x[2][0];
    coordinates[8][1] = 0.25*x[0][1] + 0.75*x[2][1];
    coordinates[9][0] = 0.75*x[0][0] + 0.25*x[1][0];
    coordinates[9][1] = 0.75*x[0][1] + 0.25*x[1][1];
    coordinates[10][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[10][1] = 0.5*x[0][1] + 0.5*x[1][1];
    coordinates[11][0] = 0.25*x[0][0] + 0.75*x[1][0];
    coordinates[11][1] = 0.25*x[0][1] + 0.75*x[1][1];
    coordinates[12][0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    coordinates[12][1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    coordinates[13][0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    coordinates[13][1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    coordinates[14][0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    coordinates[14][1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new mass_matrix_f2_p3_q4_quadrature_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class mass_matrix_f2_p3_q4_quadrature_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  mass_matrix_f2_p3_q4_quadrature_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_quadrature_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    // Facet Area.
    
    // Array of quadrature weights.
    static const double W64[64] = {0.00225490635804067, 0.00461192269546131, 0.00569439870231093, 0.00536750948658183, 0.00400862976569763, 0.00229987790174679, 0.000903105459518999, 0.000166783703247789, 0.00495362697982869, 0.0101315713673239, 0.0125095780341758, 0.011791460746211, 0.00880624443170159, 0.00505242143815854, 0.00198396157514547, 0.000366394040824771, 0.00698794170371612, 0.0142923216403241, 0.0176469084969194, 0.016633880716434, 0.0124227203558096, 0.00712730825639973, 0.00279871857246886, 0.000516861727436939, 0.00807892713920297, 0.016523696115099, 0.020402014502064, 0.0192308287687631, 0.0143622051929694, 0.00824005215605507, 0.00323566572086397, 0.000597556249615681, 0.00807892713920296, 0.0165236961150989, 0.020402014502064, 0.0192308287687631, 0.0143622051929694, 0.00824005215605507, 0.00323566572086397, 0.000597556249615681, 0.00698794170371612, 0.0142923216403241, 0.0176469084969194, 0.016633880716434, 0.0124227203558096, 0.00712730825639973, 0.00279871857246886, 0.000516861727436939, 0.00495362697982869, 0.0101315713673239, 0.0125095780341758, 0.011791460746211, 0.00880624443170159, 0.00505242143815854, 0.00198396157514547, 0.000366394040824771, 0.00225490635804067, 0.00461192269546132, 0.00569439870231094, 0.00536750948658184, 0.00400862976569764, 0.00229987790174679, 0.000903105459519001, 0.000166783703247789};
    // Quadrature points on the UFC reference element: (0.0195020502602501, 0.0177799151473634), (0.0180418349638001, 0.0913236078997939), (0.0155999615159342, 0.214308479395631), (0.01247033193684, 0.371932164583272), (0.00903035100664362, 0.545186684803427), (0.00569492613313233, 0.71317524285557), (0.00286640239202857, 0.855633742957854), (0.000886210384823616, 0.95536604471003), (0.0998591349040865, 0.0177799151473634), (0.0923821858484057, 0.0913236078997939), (0.0798787122753652, 0.214308479395631), (0.0638536226992409, 0.371932164583272), (0.0462393967490529, 0.545186684803427), (0.0291605441175791, 0.71317524285557), (0.0146772497934947, 0.855633742957854), (0.00453778967803614, 0.95536604471003), (0.233015798295905, 0.0177799151473634), (0.215568748962855, 0.0913236078997939), (0.186392581165165, 0.214308479395631), (0.148998916139621, 0.371932164583272), (0.107897088799642, 0.545186684803427), (0.0680445256493261, 0.71317524285557), (0.0342485550340933, 0.855633742957854), (0.0105886826011672, 0.95536604471003), (0.401023447367823, 0.0177799151473634), (0.370996831485534, 0.0913236078997939), (0.320784238705222, 0.214308479395631), (0.256429218282022, 0.371932164583272), (0.185692398660614, 0.545186684803427), (0.11710558017937, 0.71317524285557), (0.0589422421465923, 0.855633742957854), (0.0182232708290937, 0.95536604471003), (0.581196637484813, 0.0177799151473634), (0.537679560614672, 0.0913236078997939), (0.464907281899148, 0.214308479395631), (0.371638617134706, 0.371932164583272), (0.269120916535959, 0.545186684803427), (0.16971917696506, 0.71317524285557), (0.0854240148955533, 0.855633742957854), (0.0264106844608761, 0.95536604471003), (0.749204286556732, 0.0177799151473634), (0.693107643137351, 0.0913236078997939), (0.599298939439204, 0.214308479395631), (0.479068919277106, 0.371932164583272), (0.346916226396932, 0.545186684803427), (0.218780231495104, 0.71317524285557), (0.110117702008052, 0.855633742957854), (0.0340452726888027, 0.95536604471003), (0.88236094994855, 0.0177799151473634), (0.8162942062518, 0.0913236078997939), (0.705812808329004, 0.214308479395631), (0.564214212717487, 0.371932164583272), (0.408573918447521, 0.545186684803427), (0.257664213026851, 0.71317524285557), (0.129689007248651, 0.855633742957854), (0.0400961656119337, 0.95536604471003), (0.962718034592386, 0.0177799151473634), (0.890634557136406, 0.0913236078997939), (0.770091559088435, 0.214308479395631), (0.615597503479888, 0.371932164583272), (0.44578296418993, 0.545186684803427), (0.281129831011298, 0.71317524285557), (0.141499854650117, 0.855633742957854), (0.0437477449051463, 0.95536604471003)
    
    // Value of basis functions at quadrature points.
    static const double FE0[64][10] = \
    {{0.807225505302963, 0.0178239428840214, 0.0163826439966072, -0.00146906142904908, -0.00147712283785834, 0.145438284135968, -0.0729181176510951, 0.159525211648987, -0.0795443577738006, 0.00901307172325663},
    {0.500250823188824, 0.0166034772356766, 0.0572209773438471, -0.00701309618780693, -0.00538307404933874, 0.611936513747061, -0.265735263712635, 0.120893795626887, -0.0683953028250487, 0.0396211496325331},
    {0.15653845670491, 0.0145219306646567, 0.0519244590621585, -0.0143403411079553, -0.00537197901507225, 0.973097999074361, -0.265187557730946, 0.0708338343849126, -0.0515302785630722, 0.069513476526047},
    {-0.039932257114608, 0.0117792672629172, -0.019040633081034, -0.0200907042934335, 0.00241684987468035, 0.872469210295006, 0.119307710225706, 0.0292525941370027, -0.0332528040968106, 0.0770907667905736},
    {-0.0498261910535888, 0.00866670223065465, -0.0631390163152936, -0.0215543327434722, 0.0140805292558371, 0.368944049909013, 0.695084838276183, 0.0061111071956796, -0.0176243378815928, 0.0592566511265803},
    {0.0254615574022666, 0.00554981245166036, 0.056694991855783, -0.0179644087649839, 0.0208267259844173, -0.14129819024666, 1.02811060576433, -0.00112830999710279, -0.00708147296321746, 0.0308286885135042},
    {0.0641490431525104, 0.00282953519001736, 0.380020414290623, -0.0109417512274318, 0.0172933525657739, -0.313546579737132, 0.853685749521881, -0.00105039179855638, -0.00180948474863445, 0.00937011279094874},
    {0.0355121243622528, 0.000882679357024949, 0.772042818658422, -0.00379981964675363, 0.00710973852518115, -0.163394030616098, 0.350971995666499, -0.000151566499094355, -0.000173999841748748, 0.00100006003431413},
    {0.47020973746355, 0.0594668341845099, 0.0163826439966072, -0.00559616028351829, -0.00756352315613956, 0.116279705326824, -0.0668317173328138, 0.653073464333186, -0.277719733919075, 0.0422987493868698},
    {0.265449988133646, 0.0575250264178156, 0.0572209773438471, -0.0274431564798025, -0.0275637233274521, 0.486043893400969, -0.243554614434521, 0.491677873041549, -0.245300094366671, 0.185943830270621},
    {0.0463119810525849, 0.0534595098590293, 0.0519244590621585, -0.058573933810599, -0.0275069118379525, 0.760615208731617, -0.243052624908065, 0.283502377422861, -0.192909925143069, 0.326229859571435},
    {-0.0600574472839972, 0.0466774120250636, -0.019040633081034, -0.0863990804381065, 0.0123753417952441, 0.654077930981418, 0.109349218305142, 0.112292642040204, -0.131065806592769, 0.361790422248835},
    {-0.0357035269576087, 0.0370629148556119, -0.0631390163152936, -0.0977046399747995, 0.0720985461382729, 0.226256889805529, 0.637066821393747, 0.0191897241560415, -0.0732218315628921, 0.278094118461392},
    {0.0358848566633488, 0.0254456094649719, 0.0566949918557829, -0.0853976678869873, 0.106642061318412, -0.187716658943997, 0.942295270430337, -0.00767542054996665, -0.0308534586847473, 0.144680416332845},
    {0.0638181501493886, 0.0137220804056573, 0.380020414290623, -0.0540242282227647, 0.0885496244632998, -0.305068349063997, 0.782429477624355, -0.00523303855201277, -0.00818849020769617, 0.0439743591131469},
    {0.0331515865514707, 0.00444554825005743, 0.772042818658422, -0.0192430476716599, 0.0364050101935159, -0.151644069101048, 0.321676723998165, -0.000720277735756419, -0.000807619687337058, 0.00469332654417076},
    {0.115723962596159, 0.0456157640261118, 0.0163826439966073, -0.00561081141250939, -0.0176490652342445, 0.0747863424539101, -0.0567461752547091, 0.980117123399934, -0.236426547960034, 0.0838067633887748},
    {0.0296702250286437, 0.0515328119766076, 0.0572209773438471, -0.0312980539051096, -0.0643184321727071, 0.307431005789668, -0.206799905589266, 0.725688776807737, -0.237539020586649, 0.368411615307229},
    {-0.0483207200592166, 0.0591932994851923, 0.0519244590621585, -0.0792399156192371, -0.0641858656870188, 0.461149891737979, -0.206373671058999, 0.401080343939162, -0.221588980173731, 0.64636115837371},
    {-0.0589391326283225, 0.0639813152458781, -0.019040633081034, -0.137907233247907, 0.0288771793424126, 0.350558993625728, 0.0928473807579736, 0.140436657721587, -0.177632040150641, 0.716817512414326},
    {-0.00678016964142761, 0.0611615854552766, -0.0631390163152936, -0.179024503117915, 0.168237991451859, 0.0346813427943663, 0.540927376080161, 0.00686373315321105, -0.113917868475907, 0.550989528615669},
    {0.0505120918391691, 0.0486269923200345, 0.0566949918557829, -0.173796948096037, 0.248843383971813, -0.241293130595103, 0.800093947776937, -0.0230219385463298, -0.053315558719267, 0.286656168193001},
    {0.0615598618813391, 0.0291509945612395, 0.380020414290623, -0.118320020229917, 0.206625677790385, -0.283924856835237, 0.66435342429727, -0.0113646944909555, -0.0152274601562861, 0.0871266588915391},
    {0.0290069854895284, 0.0100894841280526, 0.772042818658422, -0.0440762414470225, 0.0849490887374542, -0.131416464538955, 0.273132645454226, -0.00145653829678759, -0.00157069394235881, 0.00929891575743996},
    {-0.055406624637136, -0.0324493693177595, 0.0163826439966072, 0.00651566075631112, -0.0303742880732422, 0.0345779132432746, -0.0440209524157112, 0.779899895847354, 0.212986400169712, 0.111888720430589},
    {-0.0637747792964597, -0.0185913269258039, 0.0572209773438471, 0.0172269218752282, -0.110692921200296, 0.135458724130567, -0.160425416561678, 0.550293167399344, 0.101425732049258, 0.491858921185992},
    {-0.0555370126851502, 0.00626565428530698, 0.0519244590621585, -0.0116465833510272, -0.110464772424612, 0.176973964593192, -0.160094764321406, 0.264900664046378, -0.0252653624551276, 0.862943753250288},
    {-0.0188997187595525, 0.0364053242476599, -0.019040633081034, -0.0990181011248814, 0.0496980294677158, 0.0714787626404375, 0.0720265306326704, 0.0492811457922452, -0.0989399510918513, 0.957008611276591},
    {0.0309147755718756, 0.0593383230002561, -0.0631390163152936, -0.201780837875702, 0.289539935934244, -0.127187806685882, 0.419625431597776, -0.0433205901064875, -0.0996052279744915, 0.735615012853705},
    {0.0620975991120015, 0.0626206415759849, 0.0566949918557829, -0.243791776902441, 0.428262943649539, -0.267351005358985, 0.620674388099211, -0.0438998617909714, -0.0580167920034083, 0.382708871763287},
    {0.0553914609549912, 0.0442298904674371, 0.380020414290623, -0.186817833236612, 0.355605680937512, -0.244621430931155, 0.515373421150143, -0.0168512938332078, -0.0186513557938836, 0.116321045994153},
    {0.0233547247376187, 0.0167561093806047, 0.772042818658422, -0.0740614433569781, 0.146198569648003, -0.104547141852547, 0.211883164543677, -0.0019941999100094, -0.00204739682977932, 0.0124147949809879},
    {-0.0324493693177595, -0.055406624637136, 0.0163826439966073, 0.0345779132432747, -0.0440209524157113, 0.00651566075631127, -0.0303742880732423, 0.212986400169712, 0.779899895847354, 0.11188872043059},
    {-0.0185913269258039, -0.0637747792964597, 0.0572209773438471, 0.135458724130567, -0.160425416561678, 0.0172269218752281, -0.110692921200296, 0.101425732049258, 0.550293167399345, 0.491858921185992},
    {0.00626565428530702, -0.0555370126851502, 0.0519244590621585, 0.176973964593192, -0.160094764321406, -0.0116465833510272, -0.110464772424612, -0.0252653624551277, 0.264900664046378, 0.862943753250288},
    {0.0364053242476599, -0.0188997187595525, -0.019040633081034, 0.0714787626404375, 0.0720265306326704, -0.0990181011248815, 0.0496980294677158, -0.0989399510918514, 0.0492811457922453, 0.957008611276591},
    {0.0593383230002561, 0.0309147755718756, -0.0631390163152936, -0.127187806685882, 0.419625431597776, -0.201780837875702, 0.289539935934244, -0.0996052279744917, -0.0433205901064873, 0.735615012853705},
    {0.0626206415759849, 0.0620975991120015, 0.0566949918557829, -0.267351005358985, 0.620674388099211, -0.243791776902441, 0.428262943649538, -0.0580167920034085, -0.0438998617909712, 0.382708871763286},
    {0.0442298904674371, 0.0553914609549912, 0.380020414290623, -0.244621430931155, 0.515373421150143, -0.186817833236612, 0.355605680937512, -0.0186513557938838, -0.0168512938332075, 0.116321045994153},
    {0.0167561093806048, 0.0233547247376186, 0.772042818658422, -0.104547141852547, 0.211883164543676, -0.0740614433569786, 0.146198569648004, -0.00204739682977956, -0.0019941999100092, 0.012414794980988},
    {0.0456157640261118, 0.115723962596159, 0.0163826439966072, 0.0747863424539099, -0.0567461752547089, -0.00561081141250942, -0.0176490652342444, -0.236426547960034, 0.980117123399934, 0.0838067633887746},
    {0.0515328119766076, 0.0296702250286437, 0.0572209773438471, 0.307431005789668, -0.206799905589266, -0.0312980539051096, -0.0643184321727071, -0.237539020586649, 0.725688776807737, 0.368411615307229},
    {0.0591932994851924, -0.0483207200592166, 0.0519244590621585, 0.461149891737979, -0.206373671058999, -0.0792399156192371, -0.0641858656870188, -0.221588980173731, 0.401080343939162, 0.64636115837371},
    {0.0639813152458782, -0.0589391326283225, -0.019040633081034, 0.350558993625728, 0.0928473807579736, -0.137907233247907, 0.0288771793424127, -0.177632040150641, 0.140436657721587, 0.716817512414326},
    {0.0611615854552767, -0.00678016964142762, -0.0631390163152936, 0.0346813427943663, 0.540927376080161, -0.179024503117915, 0.168237991451859, -0.113917868475908, 0.00686373315321122, 0.550989528615669},
    {0.0486269923200345, 0.0505120918391691, 0.0566949918557829, -0.241293130595103, 0.800093947776937, -0.173796948096037, 0.248843383971813, -0.0533155587192672, -0.0230219385463296, 0.286656168193},
    {0.0291509945612394, 0.0615598618813391, 0.380020414290623, -0.283924856835237, 0.66435342429727, -0.118320020229917, 0.206625677790385, -0.0152274601562863, -0.0113646944909553, 0.0871266588915391},
    {0.0100894841280527, 0.0290069854895284, 0.772042818658422, -0.131416464538955, 0.273132645454226, -0.0440762414470229, 0.0849490887374547, -0.00157069394235899, -0.00145653829678739, 0.00929891575744002},
    {0.05946683418451, 0.47020973746355, 0.0163826439966072, 0.116279705326824, -0.0668317173328137, -0.00559616028351832, -0.00756352315613959, -0.277719733919075, 0.653073464333186, 0.0422987493868697},
    {0.0575250264178156, 0.265449988133646, 0.0572209773438471, 0.486043893400969, -0.243554614434521, -0.0274431564798025, -0.0275637233274521, -0.245300094366671, 0.491677873041549, 0.18594383027062},
    {0.0534595098590293, 0.0463119810525849, 0.0519244590621585, 0.760615208731617, -0.243052624908065, -0.058573933810599, -0.0275069118379525, -0.192909925143069, 0.283502377422862, 0.326229859571435},
    {0.0466774120250636, -0.0600574472839972, -0.019040633081034, 0.654077930981418, 0.109349218305142, -0.0863990804381065, 0.0123753417952442, -0.131065806592769, 0.112292642040204, 0.361790422248835},
    {0.0370629148556119, -0.0357035269576087, -0.0631390163152936, 0.226256889805529, 0.637066821393747, -0.0977046399747994, 0.0720985461382728, -0.0732218315628921, 0.0191897241560417, 0.278094118461391},
    {0.0254456094649719, 0.0358848566633488, 0.0566949918557829, -0.187716658943997, 0.942295270430337, -0.0853976678869872, 0.106642061318412, -0.0308534586847474, -0.00767542054996641, 0.144680416332845},
    {0.0137220804056572, 0.0638181501493887, 0.380020414290623, -0.305068349063997, 0.782429477624355, -0.0540242282227645, 0.0885496244632994, -0.0081884902076963, -0.00523303855201251, 0.0439743591131468},
    {0.00444554825005747, 0.0331515865514706, 0.772042818658422, -0.151644069101048, 0.321676723998164, -0.0192430476716602, 0.0364050101935163, -0.000807619687337252, -0.000720277735756183, 0.00469332654417076},
    {0.0178239428840215, 0.807225505302963, 0.0163826439966072, 0.145438284135968, -0.0729181176510951, -0.00146906142904918, -0.00147712283785831, -0.0795443577738011, 0.159525211648988, 0.00901307172325663},
    {0.0166034772356767, 0.500250823188824, 0.0572209773438471, 0.611936513747061, -0.265735263712635, -0.00701309618780697, -0.00538307404933874, -0.0683953028250491, 0.120893795626888, 0.0396211496325332},
    {0.0145219306646567, 0.15653845670491, 0.0519244590621585, 0.973097999074361, -0.265187557730946, -0.0143403411079553, -0.00537197901507222, -0.0515302785630723, 0.0708338343849127, 0.069513476526047},
    {0.0117792672629172, -0.039932257114608, -0.019040633081034, 0.872469210295006, 0.119307710225706, -0.0200907042934334, 0.00241684987468039, -0.0332528040968106, 0.0292525941370028, 0.0770907667905735},
    {0.00866670223065463, -0.0498261910535888, -0.0631390163152936, 0.368944049909013, 0.695084838276183, -0.021554332743472, 0.0140805292558371, -0.0176243378815928, 0.0061111071956797, 0.0592566511265796},
    {0.00554981245166034, 0.0254615574022665, 0.0566949918557829, -0.14129819024666, 1.02811060576433, -0.0179644087649838, 0.0208267259844171, -0.0070814729632175, -0.00112830999710254, 0.0308286885135037},
    {0.00282953519001743, 0.0641490431525105, 0.380020414290623, -0.313546579737132, 0.853685749521881, -0.010941751227432, 0.0172933525657741, -0.00180948474863467, -0.00105039179855613, 0.00937011279094882},
    {0.000882679357025046, 0.0355121243622528, 0.772042818658422, -0.163394030616098, 0.350971995666499, -0.00379981964675408, 0.00710973852518171, -0.000173999841748956, -0.000151566499094147, 0.00100006003431419}};
    
    static const double FE1[64][15] = \
    {{0.720387747630081, -0.0168300963375383, -0.015550527284872, 0.00163854086057334, 0.00118783679893825, 0.00165669951402109, 0.240852789949979, -0.181311893435648, 0.081782914040552, 0.264181419089758, -0.197398645310535, 0.0887210554052762, 0.0304534696971366, -0.00984886306639675, -0.00992244755132476},
    {0.334350007538137, -0.0157476116392644, -0.041607895510836, 0.00785907599312747, 0.00388119731430558, 0.00455873502072224, 0.868465037653299, -0.529157865026806, 0.225041796160404, 0.171573410660296, -0.152820018526424, 0.0766457307985556, 0.120332694035309, -0.043569536784057, -0.0298047576867686},
    {0.0231833153588187, -0.0138754408101468, -0.0124866302613435, 0.0161962116837833, 0.00179005174576421, 0.00145450091366685, 0.989147938202103, -0.196067923056882, 0.0718013871481121, 0.0720021429531595, -0.0937310210810572, 0.0581991246546323, 0.171393765376422, -0.0772454474565525, -0.0117619753704807},
    {-0.0372979176398618, -0.0113607013577723, 0.0234218149212636, 0.0229165574221674, -0.00859721664442312, -0.00309021587419028, 0.412858260863228, 0.653223900573648, -0.152548399433187, 0.0138425230353485, -0.0426654097549133, 0.0379299691739386, 0.133613946690294, -0.0868093356871081, 0.0445622237115678},
    {0.0153548787387587, -0.00844404938870885, -0.0158869085152141, 0.0248516699640842, -0.0224124304330252, 0.00280185612278432, -0.110069778477085, 0.89891855540164, 0.138313530307914, -0.00182317133300847, -0.0121547300476419, 0.020320472620592, 0.0549994325595515, -0.0676932950399705, 0.0829239675193287},
    {0.00957969305354466, -0.00546003408216049, -0.0276596689577737, 0.0209266940090266, -0.0294131916469231, 0.0171102034388012, -0.0582847907315524, 0.18501428650562, 0.844644599222123, -0.000465422182312679, -0.000779263349280848, 0.00824918981599346, 0.00454965031691995, -0.0357053867828633, 0.0676934413708371},
    {-0.0357244095644531, -0.00280652589685835, 0.207650183826703, 0.0128563794508787, -0.0234934550144674, 0.0225385929518186, 0.200933462410377, -0.509171697014143, 1.11261685922732, 0.000673133992239074, 0.000696041664133325, 0.00212611510310175, -0.00481971484331965, -0.0109779896131299, 0.0269030233197961},
    {-0.0310132994081584, -0.00088046214273825, 0.672205957376832, 0.00449151328668965, -0.00952135873936943, 0.0116030067386997, 0.167810030907446, -0.389151493856983, 0.572782025160269, 0.000155662840323034, 0.000127487896077555, 0.000205673603947132, -0.000977847169457868, -0.00118105479106664, 0.0033441582974893},
    {0.301212821143164, -0.0416040690416377, -0.015550527284872, 0.0045511171935714, 0.00396183286832819, 0.00848303527364849, 0.161846478234107, -0.147441846167928, 0.0749565782809246, 0.908994737588923, -0.535399560105175, 0.225857550891767, 0.12680570000079, -0.0301073579871757, -0.0465664908884351},
    {0.103391388541423, -0.0416340810050223, -0.041607895510836, 0.0231269555486489, 0.0135042007708598, 0.0233427423963804, 0.569707379345283, -0.42871056307971, 0.206257788784746, 0.576311144601667, -0.43078675369888, 0.206719820392112, 0.499194850467653, -0.138941914463906, -0.139875063090418},
    {-0.0312085494098578, -0.0408081157499809, -0.0124866302613435, 0.0522026408865433, 0.00665233476823637, 0.00744768888489726, 0.605447553034706, -0.157492704094436, 0.0658081991768817, 0.225667089902693, -0.27979873733087, 0.171926433663422, 0.704946955624449, -0.263104681739943, -0.0551994773553985},
    {-0.0225601623417477, -0.037941797179199, 0.0234218149212636, 0.0822668469579536, -0.0344986519838966, -0.0158232739504572, 0.180656446025266, 0.514555047338839, -0.13981534135692, 0.0310152485886992, -0.134862110463046, 0.124797284852033, 0.538925950557131, -0.319269814251769, 0.20913251228585},
    {0.021572373044133, -0.032093186406357, -0.0158869085152141, 0.0994473280876234, -0.0970407971089643, 0.0143467443070456, -0.137786433769746, 0.667304994998036, 0.126768642123653, -0.0116862017274203, -0.0390674215703635, 0.0745278372499994, 0.209059432588477, -0.268632297899773, 0.389165894598872},
    {0.0025132133211552, -0.0233137650114745, -0.0276596689577737, 0.0922635401725182, -0.136142544211903, 0.0876118198153854, -0.0145621063354509, 0.0417487273917892, 0.774142982845539, -0.000595420197901868, -0.000813905413033122, 0.0333340405570383, 0.00525682503864158, -0.151472092064178, 0.317688353049649},
    {-0.0382307908207458, -0.0131475847004944, 0.207650183826703, 0.0611949901181771, -0.114547744464186, 0.115407578387356, 0.21093648204494, -0.517471477951854, 1.01974787379179, 0.00361833256696031, 0.00344903062892843, 0.00927536762351407, -0.0250813572764778, -0.0490579774818332, 0.126257093707226},
    {-0.0293101803798725, -0.00438827560495148, 0.672205957376832, 0.0224956245923683, -0.048038930350579, 0.0594125335413836, 0.157778841261754, -0.362984048658182, 0.524972498357585, 0.000749416625443686, 0.000599973671381315, 0.000944128477450075, -0.00467032764518738, -0.00546149597532369, 0.0156942847098986},
    {-0.000791078327532018, -0.00582669203954899, -0.015550527284872, 0.000801557105315896, 0.00104577906383194, 0.0197946961803756, 0.0707053809756933, -0.0988298182782798, 0.0636449173741977, 0.926633825601262, -0.094730327579658, 0.0337757528225179, 0.198336926938653, -0.00674792757836945, -0.0922624649735873},
    {-0.0359908448726913, -0.0120347337036228, -0.041607895510836, 0.00822598079580996, 0.00688357353176852, 0.0544690053557198, 0.23109000831666, -0.2848297056581, 0.175131525825407, 0.545486376811778, -0.145891002076937, 0.0624317226727732, 0.773906975114481, -0.0601356933292724, -0.277135293272937},
    {-0.0334141500459977, -0.0223526052072552, -0.0124866302613435, 0.0339977982717186, 0.00580391140949369, 0.0173787723340557, 0.190069948015166, -0.102476705755877, 0.0558771157277232, 0.165311369444572, -0.158839000302599, 0.0950725071866869, 1.07033252558048, -0.194907804061609, -0.109367052335214},
    {0.00663809354630194, -0.0338626997514491, 0.0234218149212636, 0.0838243228201285, -0.0436788442948979, -0.0369227393644254, -0.036450901015783, 0.31851226322517, -0.118715875942952, -0.0146025142777031, -0.105694717009156, 0.107970300948746, 0.778432535171098, -0.343226527686862, 0.41435548871052},
    {0.0221296379144453, -0.0411761873776797, -0.0158869085152141, 0.139844929513345, -0.157919107269212, 0.0334773386617496, -0.119724828639292, 0.346292501382224, 0.107638047768948, -0.0236945633987251, -0.0329923906302845, 0.0889869040822356, 0.253154730181475, -0.371186802048947, 0.771056698374932},
    {-0.0108839504063844, -0.0389029059491852, -0.0276596689577737, 0.162735488996636, -0.261745900143559, 0.204437362230779, 0.0584478548013947, -0.144397384397703, 0.657317440430145, 0.00557654881464668, 0.00541222754468843, 0.0499222432520186, -0.0424264970025999, -0.2472706799839, 0.629437820770797},
    {-0.040990407386457, -0.0262749037685394, 0.207650183826703, 0.125639672349686, -0.245060834007854, 0.269297235882888, 0.219245169353835, -0.51085522435261, 0.865858216296254, 0.00877575283861117, 0.00728443442551398, 0.0161694791890338, -0.0577776699833318, -0.0891150343153835, 0.25015392965165},
    {-0.0261623974581368, -0.00978532900005473, 0.672205957376832, 0.0505730482776807, -0.109332916192516, 0.138635878883036, 0.139643836272053, -0.317090957616473, 0.445749153015932, 0.00154772536420102, 0.00119285076434308, 0.00180221311909855, -0.00952009394577891, -0.010554148370344, 0.0310951795101257},
    {-0.028142124080269, 0.0223136923296902, -0.015550527284872, -0.00454741790821049, -0.0160038172338055, 0.0340669489361074, 0.0118567443386973, -0.0508649297870856, 0.0493726646184657, 0.267427175543548, 0.746110465066622, -0.14864772838255, 0.175678425974943, 0.0801081850358625, -0.123177757167144},
    {-0.01319954290128, 0.0234107938090704, -0.041607895510836, -0.0225640135181179, -0.0416312594983321, 0.0937419199135526, 0.0227096342464765, -0.143452422322423, 0.135858611267574, 0.0922565647962882, 0.444382252950585, -0.132848549823364, 0.670804187644173, 0.282137462525146, -0.369997743578514},
    {0.0106622616521446, 0.0186307429382647, -0.0124866302613435, -0.0372095020654963, -0.0111156270524488, 0.0299091102122326, -0.0320599290898916, -0.0489104726683462, 0.0433467778495464, -0.0479883949298086, 0.145193455464034, -0.0807199440492284, 0.879184101655078, 0.289577797306066, -0.146013746960803},
    {0.0234186698704818, 0.00211411708289207, 0.0234218149212636, -0.00637240429901968, 0.00478506316089386, -0.0635445507749753, -0.0920829341581127, 0.13120618404595, -0.0920940645324021, -0.0634867243862504, 0.00476977576875405, -0.00636737487913779, 0.551865856292455, 0.0291689114532588, 0.553197660433949},
    {0.00609404082734274, -0.0225920658504383, -0.0158869085152141, 0.0873062383326183, -0.122992439315374, 0.0576149679850738, -0.0276359694564604, 0.0530002766997203, 0.0835004184456243, -0.00941290314075061, -0.00393271586282033, 0.043097044616658, 0.0666815206559956, -0.224263760525573, 1.0294222551036},
    {-0.0278543503198826, -0.0402275295776552, -0.0276596689577737, 0.181321100503017, -0.329007581775416, 0.351839559257954, 0.136933927611599, -0.288047628350919, 0.50991524340297, 0.0224849743451396, 0.0135708497672736, 0.0431502190409087, -0.145655387059816, -0.24111347424327, 0.840349746355869},
    {-0.0413165406002055, -0.0366125404747618, 0.207650183826703, 0.1813273908851, -0.373481651168546, 0.463464308815837, 0.212778234978009, -0.466255946436086, 0.671691143363305, 0.0146577041319606, 0.0101325264391238, 0.0181032058020456, -0.0907550849558157, -0.105358403502487, 0.333975468895817},
    {-0.0215850703270563, -0.0158836129776581, 0.672205957376832, 0.0829469640192732, -0.182163131970903, 0.238594286246385, 0.113996394475687, -0.254680109677888, 0.345790745652583, 0.0021744410758299, 0.00159627178167121, 0.00229303323666444, -0.013159421688214, -0.0136412945731352, 0.0415145473499274},
    {0.0223136923296901, -0.028142124080269, -0.015550527284872, 0.0118567443386973, -0.0508649297870857, 0.0493726646184658, -0.00454741790821032, -0.0160038172338055, 0.0340669489361075, -0.14864772838255, 0.746110465066622, 0.267427175543548, 0.0801081850358624, 0.175678425974943, -0.123177757167144},
    {0.0234107938090704, -0.0131995429012799, -0.041607895510836, 0.0227096342464765, -0.143452422322423, 0.135858611267574, -0.0225640135181178, -0.0416312594983319, 0.0937419199135526, -0.132848549823364, 0.444382252950585, 0.0922565647962883, 0.282137462525146, 0.670804187644173, -0.369997743578514},
    {0.0186307429382647, 0.0106622616521446, -0.0124866302613435, -0.0320599290898917, -0.0489104726683462, 0.0433467778495464, -0.0372095020654962, -0.0111156270524487, 0.0299091102122326, -0.0807199440492285, 0.145193455464034, -0.0479883949298086, 0.289577797306066, 0.879184101655078, -0.146013746960803},
    {0.00211411708289209, 0.0234186698704818, 0.0234218149212636, -0.0920829341581127, 0.13120618404595, -0.092094064532402, -0.00637240429901968, 0.00478506316089407, -0.0635445507749753, -0.00636737487913791, 0.00476977576875408, -0.0634867243862504, 0.0291689114532588, 0.551865856292455, 0.553197660433949},
    {-0.0225920658504383, 0.00609404082734276, -0.0158869085152141, -0.0276359694564603, 0.0530002766997201, 0.0835004184456244, 0.0873062383326183, -0.122992439315374, 0.0576149679850737, 0.043097044616658, -0.00393271586282032, -0.00941290314075057, -0.224263760525573, 0.0666815206559958, 1.0294222551036},
    {-0.0402275295776552, -0.0278543503198826, -0.0276596689577737, 0.136933927611599, -0.288047628350919, 0.50991524340297, 0.181321100503017, -0.329007581775415, 0.351839559257954, 0.0431502190409087, 0.0135708497672736, 0.0224849743451396, -0.24111347424327, -0.145655387059815, 0.840349746355869},
    {-0.0366125404747618, -0.0413165406002055, 0.207650183826703, 0.212778234978009, -0.466255946436086, 0.671691143363305, 0.1813273908851, -0.373481651168546, 0.463464308815837, 0.0181032058020455, 0.0101325264391238, 0.0146577041319607, -0.105358403502488, -0.0907550849558154, 0.333975468895817},
    {-0.0158836129776582, -0.0215850703270562, 0.672205957376832, 0.113996394475687, -0.254680109677887, 0.345790745652582, 0.0829469640192736, -0.182163131970904, 0.238594286246387, 0.00229303323666434, 0.00159627178167124, 0.00217444107582999, -0.0136412945731355, -0.0131594216882138, 0.0415145473499275},
    {-0.00582669203954894, -0.000791078327532056, -0.015550527284872, 0.070705380975693, -0.0988298182782797, 0.0636449173741976, 0.000801557105315896, 0.00104577906383212, 0.0197946961803756, 0.0337757528225177, -0.0947303275796572, 0.926633825601262, -0.0067479275783695, 0.198336926938653, -0.0922624649735873},
    {-0.0120347337036227, -0.0359908448726912, -0.041607895510836, 0.23109000831666, -0.2848297056581, 0.175131525825407, 0.00822598079581002, 0.00688357353176863, 0.0544690053557199, 0.0624317226727732, -0.145891002076937, 0.545486376811778, -0.0601356933292724, 0.773906975114481, -0.277135293272937},
    {-0.0223526052072551, -0.0334141500459977, -0.0124866302613435, 0.190069948015166, -0.102476705755877, 0.0558771157277233, 0.0339977982717186, 0.00580391140949392, 0.0173787723340557, 0.0950725071866868, -0.158839000302599, 0.165311369444572, -0.19490780406161, 1.07033252558048, -0.109367052335214},
    {-0.0338626997514491, 0.00663809354630199, 0.0234218149212636, -0.0364509010157831, 0.31851226322517, -0.118715875942952, 0.0838243228201285, -0.0436788442948977, -0.0369227393644254, 0.107970300948746, -0.105694717009156, -0.0146025142777032, -0.343226527686862, 0.778432535171098, 0.41435548871052},
    {-0.0411761873776797, 0.0221296379144453, -0.0158869085152141, -0.119724828639292, 0.346292501382224, 0.107638047768949, 0.139844929513345, -0.157919107269212, 0.0334773386617496, 0.0889869040822355, -0.0329923906302844, -0.0236945633987251, -0.371186802048947, 0.253154730181475, 0.771056698374932},
    {-0.0389029059491852, -0.0108839504063844, -0.0276596689577737, 0.0584478548013946, -0.144397384397703, 0.657317440430146, 0.162735488996636, -0.261745900143559, 0.204437362230779, 0.0499222432520185, 0.0054122275446885, 0.00557654881464667, -0.2472706799839, -0.0424264970025996, 0.629437820770797},
    {-0.0262749037685394, -0.040990407386457, 0.207650183826703, 0.219245169353835, -0.51085522435261, 0.865858216296254, 0.125639672349686, -0.245060834007854, 0.269297235882889, 0.0161694791890337, 0.00728443442551409, 0.00877575283861122, -0.0891150343153837, -0.0577776699833316, 0.25015392965165},
    {-0.00978532900005478, -0.0261623974581368, 0.672205957376832, 0.139643836272053, -0.317090957616473, 0.445749153015931, 0.0505730482776808, -0.109332916192516, 0.138635878883037, 0.00180221311909846, 0.00119285076434313, 0.00154772536420111, -0.0105541483703442, -0.00952009394577874, 0.0310951795101259},
    {-0.0416040690416377, 0.301212821143164, -0.015550527284872, 0.161846478234107, -0.147441846167928, 0.0749565782809247, 0.00455111719357149, 0.00396183286832821, 0.00848303527364846, 0.225857550891767, -0.535399560105175, 0.908994737588923, -0.0301073579871758, 0.12680570000079, -0.0465664908884351},
    {-0.0416340810050223, 0.103391388541424, -0.041607895510836, 0.569707379345283, -0.42871056307971, 0.206257788784746, 0.0231269555486489, 0.0135042007708601, 0.0233427423963804, 0.206719820392112, -0.43078675369888, 0.576311144601667, -0.138941914463906, 0.499194850467653, -0.139875063090418},
    {-0.0408081157499809, -0.0312085494098577, -0.0124866302613435, 0.605447553034706, -0.157492704094436, 0.0658081991768818, 0.0522026408865433, 0.00665233476823669, 0.00744768888489729, 0.171926433663422, -0.27979873733087, 0.225667089902693, -0.263104681739943, 0.704946955624449, -0.0551994773553983},
    {-0.037941797179199, -0.0225601623417476, 0.0234218149212636, 0.180656446025266, 0.514555047338839, -0.13981534135692, 0.0822668469579536, -0.0344986519838963, -0.0158232739504572, 0.124797284852033, -0.134862110463046, 0.0310152485886991, -0.319269814251769, 0.538925950557131, 0.20913251228585},
    {-0.032093186406357, 0.021572373044133, -0.0158869085152141, -0.137786433769746, 0.667304994998037, 0.126768642123653, 0.0994473280876233, -0.0970407971089639, 0.0143467443070456, 0.0745278372499993, -0.0390674215703635, -0.0116862017274203, -0.268632297899774, 0.209059432588477, 0.389165894598872},
    {-0.0233137650114745, 0.00251321332115522, -0.0276596689577737, -0.014562106335451, 0.0417487273917892, 0.774142982845539, 0.0922635401725181, -0.136142544211903, 0.0876118198153852, 0.0333340405570382, -0.000813905413033007, -0.000595420197901859, -0.151472092064178, 0.00525682503864178, 0.317688353049648},
    {-0.0131475847004944, -0.0382307908207458, 0.207650183826703, 0.21093648204494, -0.517471477951854, 1.01974787379179, 0.0611949901181769, -0.114547744464185, 0.115407578387356, 0.00927536762351387, 0.0034490306289286, 0.00361833256696033, -0.0490579774818333, -0.0250813572764775, 0.126257093707225},
    {-0.00438827560495154, -0.0293101803798724, 0.672205957376832, 0.157778841261754, -0.362984048658182, 0.524972498357584, 0.0224956245923686, -0.0480389303505794, 0.0594125335413844, 0.000944128477449964, 0.000599973671381385, 0.000749416625443734, -0.00546149597532394, -0.00467032764518721, 0.0156942847098986},
    {-0.0168300963375383, 0.72038774763008, -0.015550527284872, 0.240852789949979, -0.181311893435649, 0.0817829140405521, 0.00163854086057324, 0.00118783679893848, 0.00165669951402107, 0.0887210554052764, -0.197398645310535, 0.264181419089759, -0.00984886306639687, 0.0304534696971369, -0.00992244755132479},
    {-0.0157476116392645, 0.334350007538137, -0.041607895510836, 0.868465037653298, -0.529157865026806, 0.225041796160404, 0.00785907599312748, 0.003881197314306, 0.00455873502072222, 0.076645730798556, -0.152820018526425, 0.171573410660297, -0.0435695367840574, 0.12033269403531, -0.0298047576867687},
    {-0.0138754408101468, 0.0231833153588188, -0.0124866302613435, 0.989147938202103, -0.196067923056882, 0.0718013871481122, 0.0161962116837832, 0.00179005174576466, 0.00145450091366683, 0.0581991246546323, -0.0937310210810572, 0.0720021429531596, -0.0772454474565528, 0.171393765376422, -0.0117619753704805},
    {-0.0113607013577723, -0.0372979176398618, 0.0234218149212636, 0.412858260863228, 0.653223900573648, -0.152548399433187, 0.0229165574221675, -0.0085972166444228, -0.00309021587419031, 0.0379299691739386, -0.0426654097549133, 0.0138425230353484, -0.0868093356871082, 0.133613946690294, 0.044562223711568},
    {-0.00844404938870877, 0.0153548787387587, -0.0158869085152141, -0.110069778477085, 0.898918555401641, 0.138313530307914, 0.0248516699640842, -0.0224124304330248, 0.00280185612278437, 0.0203204726205919, -0.0121547300476418, -0.00182317133300843, -0.0676932950399702, 0.0549994325595512, 0.0829239675193281},
    {-0.00546003408216042, 0.00957969305354466, -0.0276596689577737, -0.0582847907315525, 0.185014286505621, 0.844644599222124, 0.0209266940090264, -0.0294131916469225, 0.0171102034388011, 0.00824918981599329, -0.000779263349280709, -0.000465422182312696, -0.0357053867828632, 0.00454965031692008, 0.0676934413708362},
    {-0.0028065258968584, -0.0357244095644531, 0.207650183826703, 0.200933462410377, -0.509171697014143, 1.11261685922732, 0.0128563794508789, -0.0234934550144674, 0.0225385929518193, 0.00212611510310159, 0.000696041664133532, 0.000673133992239113, -0.0109779896131303, -0.00481971484331942, 0.0269030233197963},
    {-0.000880462142738327, -0.0310132994081584, 0.672205957376832, 0.167810030907446, -0.389151493856983, 0.572782025160268, 0.00449151328668998, -0.00952135873936982, 0.0116030067387005, 0.000205673603947069, 0.000127487896077673, 0.000155662840323118, -0.00118105479106689, -0.000977847169457674, 0.00334415829748941}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 225; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 45952
    for (unsigned int ip = 0; ip < 64; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      
      // Total number of operations to compute function values = 40
      for (unsigned int r = 0; r < 10; r++)
      {
        F0 += FE0[ip][r]*w[0][r];
        F1 += FE0[ip][r]*w[1][r];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 3
      double I[1];
      // Number of operations: 3
      I[0] = F0*F1*W64[ip]*det;
      
      
      // Number of operations for primary indices: 675
      for (unsigned int j = 0; j < 15; j++)
      {
        for (unsigned int k = 0; k < 15; k++)
        {
          // Number of operations to compute entry: 3
          A[j*15 + k] += FE1[ip][j]*FE1[ip][k]*I[0];
        }// end loop over 'k'
      }// end loop over 'j'
    }// end loop over 'ip'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0).");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class mass_matrix_f2_p3_q4_quadrature_form_0: public ufc::form
{
public:

  /// Constructor
  mass_matrix_f2_p3_q4_quadrature_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_matrix_f2_p3_q4_quadrature_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Product(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 0), Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None), 1)), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q4_quadrature_finite_element_1();
        break;
      }
    case 1:
      {
        return new mass_matrix_f2_p3_q4_quadrature_finite_element_1();
        break;
      }
    case 2:
      {
        return new mass_matrix_f2_p3_q4_quadrature_finite_element_0();
        break;
      }
    case 3:
      {
        return new mass_matrix_f2_p3_q4_quadrature_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q4_quadrature_dofmap_1();
        break;
      }
    case 1:
      {
        return new mass_matrix_f2_p3_q4_quadrature_dofmap_1();
        break;
      }
    case 2:
      {
        return new mass_matrix_f2_p3_q4_quadrature_dofmap_0();
        break;
      }
    case 3:
      {
        return new mass_matrix_f2_p3_q4_quadrature_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_matrix_f2_p3_q4_quadrature_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
