// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __LAPLACIAN_F2_P1_Q3_TENSOR_H
#define __LAPLACIAN_F2_P1_Q3_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class laplacian_f2_p1_q3_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p1_q3_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q3_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 3;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p1_q3_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class laplacian_f2_p1_q3_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  laplacian_f2_p1_q3_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q3_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new laplacian_f2_p1_q3_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p1_q3_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p1_q3_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q3_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 3;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 2;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p1_q3_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class laplacian_f2_p1_q3_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  laplacian_f2_p1_q3_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q3_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new laplacian_f2_p1_q3_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class laplacian_f2_p1_q3_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  laplacian_f2_p1_q3_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q3_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    108
    // Number of operations (multiply-add pairs) for tensor contraction: 1854
    // Total number of operations (multiply-add pairs):                  1973
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0 = det*(w[0][0]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_1 = det*(w[0][0]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_2 = det*(w[0][0]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0 = det*(w[0][1]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_1 = det*(w[0][1]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_2 = det*(w[0][1]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0 = det*(w[0][2]*w[1][0]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_1 = det*(w[0][2]*w[1][1]*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_2 = det*(w[0][2]*w[1][2]*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0 = det*(w[0][0]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_1 = det*(w[0][0]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_2 = det*(w[0][0]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0 = det*(w[0][1]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_1 = det*(w[0][1]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_2 = det*(w[0][1]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0 = det*(w[0][2]*w[1][0]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_1 = det*(w[0][2]*w[1][1]*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_2 = det*(w[0][2]*w[1][2]*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[73] = -0.0803571428571437*G0_0_0_0_0 - 0.0361607142857141*G0_0_0_0_1 - 0.0281250000000002*G0_0_0_0_2 - 0.0361607142857141*G0_0_0_1_0 + 0.0924107142857175*G0_0_0_1_1 + 0.0401785714285733*G0_0_0_1_2 - 0.0281250000000002*G0_0_0_2_0 + 0.0401785714285733*G0_0_0_2_1 + 0.0361607142857157*G0_0_0_2_2 - 0.0522321428571434*G0_0_1_0_0 - 0.0381696428571436*G0_0_1_0_1 - 0.00602678571428574*G0_0_1_0_2 - 0.0381696428571436*G0_0_1_1_0 + 0.216964285714288*G0_0_1_1_1 + 0.0381696428571437*G0_0_1_1_2 - 0.00602678571428574*G0_0_1_2_0 + 0.0381696428571437*G0_0_1_2_1 + 0.0160714285714289*G0_0_1_2_2 - 0.0321428571428569*G0_1_0_0_0 - 0.032142857142857*G0_1_0_0_1 - 0.00803571428571412*G0_1_0_0_2 - 0.032142857142857*G0_1_0_1_0 + 0.120535714285717*G0_1_0_1_1 + 0.0562500000000018*G0_1_0_1_2 - 0.00803571428571412*G0_1_0_2_0 + 0.0562500000000018*G0_1_0_2_1 + 0.0482142857142871*G0_1_0_2_2 - 0.00401785714285787*G0_1_1_0_0 - 0.0241071428571437*G0_1_1_0_1 + 0.00401785714285708*G0_1_1_0_2 - 0.0241071428571437*G0_1_1_1_0 + 0.265178571428573*G0_1_1_1_1 + 0.0482142857142865*G0_1_1_1_2 + 0.00401785714285708*G0_1_1_2_0 + 0.0482142857142865*G0_1_1_2_1 + 0.0200892857142861*G0_1_1_2_2;
    A[69] = -0.0241071428571438*G0_0_0_0_0 - 0.0723214285714303*G0_0_0_0_2 + 0.0241071428571439*G0_0_0_1_1 + 0.0723214285714301*G0_0_0_1_2 - 0.0723214285714303*G0_0_0_2_0 + 0.0723214285714301*G0_0_0_2_1 + 0.0482142857142858*G0_0_1_0_0 + 0.0361607142857143*G0_0_1_0_1 + 0.0602678571428569*G0_0_1_0_2 + 0.0361607142857143*G0_0_1_1_0 + 0.0723214285714296*G0_0_1_1_1 + 0.132589285714287*G0_0_1_1_2 + 0.0602678571428569*G0_0_1_2_0 + 0.132589285714287*G0_0_1_2_1 + 0.433928571428575*G0_0_1_2_2 + 0.192857142857146*G0_1_0_0_0 + 0.0241071428571429*G0_1_0_0_1 + 0.168750000000003*G0_1_0_0_2 + 0.0241071428571429*G0_1_0_1_0 + 0.0723214285714302*G0_1_0_1_2 + 0.168750000000003*G0_1_0_2_0 + 0.0723214285714302*G0_1_0_2_1 + 0.28928571428572*G0_1_0_2_2 - 0.168750000000004*G0_1_1_0_0 - 0.0843750000000025*G0_1_1_0_1 + 0.0120535714285713*G0_1_1_0_2 - 0.0843750000000025*G0_1_1_1_0 - 0.0723214285714301*G0_1_1_1_1 + 0.0602678571428587*G0_1_1_1_2 + 0.0120535714285713*G0_1_1_2_0 + 0.0602678571428587*G0_1_1_2_1 + 0.265178571428575*G0_1_1_2_2;
    A[16] = -0.00401785714285728*G0_0_0_0_0 + 0.00200892857142856*G0_0_0_0_1 - 0.0113839285714289*G0_0_0_0_2 + 0.00200892857142856*G0_0_0_1_0 + 0.024107142857143*G0_0_0_1_1 + 0.00870535714285718*G0_0_0_1_2 - 0.0113839285714289*G0_0_0_2_0 + 0.00870535714285718*G0_0_0_2_1 - 0.0562500000000012*G0_0_0_2_2 + 0.00803571428571493*G0_0_1_0_0 - 0.00200892857142853*G0_0_1_0_1 + 0.00736607142857182*G0_0_1_0_2 - 0.00200892857142852*G0_0_1_1_0 + 0.0020089285714287*G0_0_1_1_2 + 0.00736607142857182*G0_0_1_2_0 + 0.0020089285714287*G0_0_1_2_1 - 0.0227678571428572*G0_0_1_2_2;
    A[37] = A[73] + 0.0200892857142865*G0_0_1_0_0 + 0.00602678571428659*G0_0_1_0_1 - 0.00200892857142839*G0_0_1_0_2 + 0.00602678571428658*G0_0_1_1_0 - 0.0964285714285708*G0_0_1_1_1 + 0.0180803571428581*G0_0_1_1_2 - 0.00200892857142839*G0_0_1_2_0 + 0.018080357142858*G0_0_1_2_1 + 0.0321428571428582*G0_0_1_2_2 - 0.0200892857142865*G0_1_0_0_0 - 0.00602678571428659*G0_1_0_0_1 + 0.00200892857142838*G0_1_0_0_2 - 0.00602678571428659*G0_1_0_1_0 + 0.0964285714285708*G0_1_0_1_1 - 0.0180803571428581*G0_1_0_1_2 + 0.00200892857142838*G0_1_0_2_0 - 0.0180803571428581*G0_1_0_2_1 - 0.0321428571428582*G0_1_0_2_2;
    A[11] = 0.0217261904761908*G0_0_0_0_0 + 0.026934523809524*G0_0_0_0_1 + 0.0108630952380954*G0_0_0_0_2 + 0.026934523809524*G0_0_0_1_0 + 0.252083333333335*G0_0_0_1_1 + 0.026934523809524*G0_0_0_1_2 + 0.0108630952380954*G0_0_0_2_0 + 0.026934523809524*G0_0_0_2_1 + 0.0217261904761908*G0_0_0_2_2;
    A[82] = 0.00803571428571495*G0_0_1_0_0 + 0.00736607142857186*G0_0_1_0_1 - 0.00200892857142855*G0_0_1_0_2 + 0.00736607142857186*G0_0_1_1_0 - 0.0227678571428568*G0_0_1_1_1 + 0.0020089285714287*G0_0_1_1_2 - 0.00200892857142855*G0_0_1_2_0 + 0.0020089285714287*G0_0_1_2_1 - 0.00401785714285731*G0_1_1_0_0 - 0.0113839285714289*G0_1_1_0_1 + 0.00200892857142853*G0_1_1_0_2 - 0.0113839285714289*G0_1_1_1_0 - 0.0562500000000008*G0_1_1_1_1 + 0.0087053571428572*G0_1_1_1_2 + 0.00200892857142853*G0_1_1_2_0 + 0.00870535714285719*G0_1_1_2_1 + 0.0241071428571428*G0_1_1_2_2;
    A[32] = -A[82] + 0.00401785714285786*G0_0_1_0_0 + 0.000669642857143376*G0_0_1_0_1 - 0.0261160714285716*G0_0_1_0_2 + 0.000669642857143375*G0_0_1_1_0 - 0.045535714285714*G0_0_1_1_1 - 0.0194196428571427*G0_0_1_1_2 - 0.0261160714285716*G0_0_1_2_0 - 0.0194196428571427*G0_0_1_2_1 - 0.168750000000002*G0_0_1_2_2;
    A[45] = A[73] + 0.0763392857142861*G0_0_0_0_0 + 0.0401785714285712*G0_0_0_0_1 + 0.00401785714285668*G0_0_0_0_2 + 0.0401785714285712*G0_0_0_1_0 - 0.0723214285714313*G0_0_0_1_1 + 0.00803571428571336*G0_0_0_1_2 + 0.00401785714285668*G0_0_0_2_0 + 0.00803571428571335*G0_0_0_2_1 + 0.229017857142859*G0_0_0_2_2 + 0.0321428571428578*G0_0_1_0_1 - 0.0321428571428577*G0_0_1_0_2 + 0.0321428571428578*G0_0_1_1_0 - 0.200892857142859*G0_0_1_1_1 - 0.0321428571428577*G0_0_1_2_0 + 0.20089285714286*G0_0_1_2_2 + 0.0241071428571429*G0_1_0_0_1 - 0.0241071428571429*G0_1_0_0_2 + 0.0241071428571429*G0_1_0_1_0 - 0.0723214285714299*G0_1_0_1_1 - 0.0241071428571429*G0_1_0_2_0 + 0.0723214285714302*G0_1_0_2_2 - 0.076339285714286*G0_1_1_0_0 - 0.00401785714285653*G0_1_1_0_1 - 0.0401785714285712*G0_1_1_0_2 - 0.00401785714285653*G0_1_1_1_0 - 0.229017857142858*G0_1_1_1_1 - 0.0080357142857132*G0_1_1_1_2 - 0.0401785714285712*G0_1_1_2_0 - 0.0080357142857132*G0_1_1_2_1 + 0.0723214285714316*G0_1_1_2_2;
    A[1] = -0.0324404761904765*G0_0_0_0_0 - 0.000818452380952324*G0_0_0_0_1 - 0.00483630952380956*G0_0_0_0_2 - 0.000818452380952324*G0_0_0_1_0 - 0.0324404761904766*G0_0_0_1_1 - 0.00483630952380957*G0_0_0_1_2 - 0.00483630952380956*G0_0_0_2_0 - 0.00483630952380957*G0_0_0_2_1 - 0.00163690476190473*G0_0_0_2_2 - 0.0324404761904765*G0_1_0_0_0 - 0.000818452380952321*G0_1_0_0_1 - 0.00483630952380956*G0_1_0_0_2 - 0.000818452380952322*G0_1_0_1_0 - 0.0324404761904765*G0_1_0_1_1 - 0.00483630952380956*G0_1_0_1_2 - 0.00483630952380956*G0_1_0_2_0 - 0.00483630952380956*G0_1_0_2_1 - 0.00163690476190472*G0_1_0_2_2;
    A[78] = -A[73] - 0.462053571428577*G0_0_0_0_0 - 0.158705357142858*G0_0_0_0_1 - 0.102455357142858*G0_0_0_0_2 - 0.158705357142858*G0_0_0_1_0 - 0.289285714285716*G0_0_0_1_1 - 0.0341517857142846*G0_0_0_1_2 - 0.102455357142858*G0_0_0_2_0 - 0.0341517857142846*G0_0_0_2_1 - 0.00803571428571341*G0_0_0_2_2 - 0.196875000000002*G0_1_0_0_0 - 0.192857142857145*G0_1_0_0_1 - 0.0441964285714283*G0_1_0_0_2 - 0.192857142857145*G0_1_0_1_0 - 0.313392857142859*G0_1_0_1_1 - 0.0241071428571418*G0_1_0_1_2 - 0.0441964285714283*G0_1_0_2_0 - 0.0241071428571418*G0_1_0_2_1 + 0.0200892857142868*G0_1_0_2_2;
    A[21] = 0.0016369047619047*G0_1_0_0_0 + 0.00483630952380956*G0_1_0_0_1 + 0.00483630952380958*G0_1_0_0_2 + 0.00483630952380956*G0_1_0_1_0 + 0.0324404761904765*G0_1_0_1_1 + 0.000818452380952328*G0_1_0_1_2 + 0.00483630952380958*G0_1_0_2_0 + 0.000818452380952326*G0_1_0_2_1 + 0.0324404761904767*G0_1_0_2_2;
    A[72] = A[82] + 0.0147321428571419*G0_0_1_0_0 - 0.0147321428571437*G0_0_1_0_1 - 0.0147321428571437*G0_0_1_1_0 + 0.0147321428571418*G0_0_1_1_1 - 0.0294642857142866*G0_1_1_0_0 - 0.00736607142857184*G0_1_1_0_1 + 0.00468750000000001*G0_1_1_0_2 - 0.00736607142857183*G0_1_1_1_0 + 0.0441964285714286*G0_1_1_1_1 - 0.0046875000000001*G0_1_1_1_2 + 0.00468750000000001*G0_1_1_2_0 - 0.0046875000000001*G0_1_1_2_1;
    A[15] = A[16] - 0.0294642857142866*G0_0_0_0_0 + 0.00468749999999994*G0_0_0_0_1 - 0.0073660714285718*G0_0_0_0_2 + 0.00468749999999994*G0_0_0_1_0 - 0.00468750000000008*G0_0_0_1_2 - 0.00736607142857179*G0_0_0_2_0 - 0.00468750000000008*G0_0_0_2_1 + 0.0441964285714291*G0_0_0_2_2 + 0.0147321428571419*G0_0_1_0_0 - 0.0147321428571437*G0_0_1_0_2 - 0.0147321428571437*G0_0_1_2_0 + 0.0147321428571424*G0_0_1_2_2;
    A[51] = A[15] - 0.0227678571428569*G0_0_1_0_0 + 0.00200892857142871*G0_0_1_0_1 + 0.00736607142857182*G0_0_1_0_2 + 0.00200892857142872*G0_0_1_1_0 - 0.00200892857142853*G0_0_1_1_2 + 0.00736607142857182*G0_0_1_2_0 - 0.00200892857142853*G0_0_1_2_1 + 0.00803571428571477*G0_0_1_2_2 + 0.0227678571428569*G0_1_0_0_0 - 0.00200892857142872*G0_1_0_0_1 - 0.00736607142857183*G0_1_0_0_2 - 0.00200892857142872*G0_1_0_1_0 + 0.00200892857142853*G0_1_0_1_2 - 0.00736607142857183*G0_1_0_2_0 + 0.00200892857142853*G0_1_0_2_1 - 0.00803571428571477*G0_1_0_2_2;
    A[31] = -A[51] - 0.05357142857143*G0_0_0_0_0 + 0.0120535714285714*G0_0_0_0_1 - 0.0388392857142868*G0_0_0_0_2 + 0.0120535714285713*G0_0_0_1_0 + 0.150000000000001*G0_0_0_1_1 + 0.0147321428571431*G0_0_0_1_2 - 0.0388392857142868*G0_0_0_2_0 + 0.0147321428571431*G0_0_0_2_1 - 0.07232142857143*G0_0_0_2_2 + 0.0308035714285712*G0_1_0_0_0 + 0.047544642857143*G0_1_0_0_1 - 0.00334821428571474*G0_1_0_0_2 + 0.047544642857143*G0_1_0_1_0 + 0.490178571428575*G0_1_0_1_1 + 0.0515625000000002*G0_1_0_1_2 - 0.00334821428571474*G0_1_0_2_0 + 0.0515625000000002*G0_1_0_2_1;
    A[22] = 0.0217261904761908*G0_1_1_0_0 + 0.0108630952380954*G0_1_1_0_1 + 0.026934523809524*G0_1_1_0_2 + 0.0108630952380954*G0_1_1_1_0 + 0.0217261904761908*G0_1_1_1_1 + 0.026934523809524*G0_1_1_1_2 + 0.026934523809524*G0_1_1_2_0 + 0.026934523809524*G0_1_1_2_1 + 0.252083333333336*G0_1_1_2_2;
    A[54] = A[45] + 0.0200892857142867*G0_0_1_0_0 - 0.00200892857142833*G0_0_1_0_1 + 0.00602678571428644*G0_0_1_0_2 - 0.00200892857142833*G0_0_1_1_0 + 0.0321428571428585*G0_0_1_1_1 + 0.0180803571428579*G0_0_1_1_2 + 0.00602678571428644*G0_0_1_2_0 + 0.0180803571428579*G0_0_1_2_1 - 0.0964285714285717*G0_0_1_2_2 - 0.0200892857142867*G0_1_0_0_0 + 0.00200892857142833*G0_1_0_0_1 - 0.00602678571428644*G0_1_0_0_2 + 0.00200892857142833*G0_1_0_1_0 - 0.0321428571428584*G0_1_0_1_1 - 0.0180803571428579*G0_1_0_1_2 - 0.00602678571428644*G0_1_0_2_0 - 0.0180803571428579*G0_1_0_2_1 + 0.0964285714285717*G0_1_0_2_2;
    A[10] = -0.0324404761904765*G0_0_0_0_0 - 0.000818452380952324*G0_0_0_0_1 - 0.00483630952380956*G0_0_0_0_2 - 0.000818452380952324*G0_0_0_1_0 - 0.0324404761904766*G0_0_0_1_1 - 0.00483630952380957*G0_0_0_1_2 - 0.00483630952380956*G0_0_0_2_0 - 0.00483630952380957*G0_0_0_2_1 - 0.00163690476190473*G0_0_0_2_2 - 0.0324404761904765*G0_0_1_0_0 - 0.000818452380952322*G0_0_1_0_1 - 0.00483630952380956*G0_0_1_0_2 - 0.000818452380952323*G0_0_1_1_0 - 0.0324404761904765*G0_0_1_1_1 - 0.00483630952380956*G0_0_1_1_2 - 0.00483630952380956*G0_0_1_2_0 - 0.00483630952380956*G0_0_1_2_1 - 0.00163690476190472*G0_0_1_2_2;
    A[27] = A[72] - 0.0227678571428568*G0_0_1_0_0 + 0.00736607142857186*G0_0_1_0_1 + 0.00200892857142872*G0_0_1_0_2 + 0.00736607142857186*G0_0_1_1_0 + 0.00803571428571496*G0_0_1_1_1 - 0.00200892857142853*G0_0_1_1_2 + 0.00200892857142872*G0_0_1_2_0 - 0.00200892857142853*G0_0_1_2_1 + 0.0227678571428568*G0_1_0_0_0 - 0.00736607142857186*G0_1_0_0_1 - 0.00200892857142872*G0_1_0_0_2 - 0.00736607142857186*G0_1_0_1_0 - 0.00803571428571496*G0_1_0_1_1 + 0.00200892857142853*G0_1_0_1_2 - 0.00200892857142871*G0_1_0_2_0 + 0.00200892857142853*G0_1_0_2_1;
    A[26] = A[27] - 0.0308035714285711*G0_1_0_0_0 + 0.00334821428571475*G0_1_0_0_1 - 0.0475446428571431*G0_1_0_0_2 + 0.00334821428571475*G0_1_0_1_0 - 0.0515625000000003*G0_1_0_1_2 - 0.0475446428571431*G0_1_0_2_0 - 0.0515625000000003*G0_1_0_2_1 - 0.490178571428576*G0_1_0_2_2 - 0.0348214285714284*G0_1_1_0_0 - 0.00535714285714248*G0_1_1_0_1 - 0.0455357142857144*G0_1_1_0_2 - 0.00535714285714248*G0_1_1_1_0 - 0.0160714285714282*G0_1_1_1_1 - 0.0482142857142861*G0_1_1_1_2 - 0.0455357142857144*G0_1_1_2_0 - 0.0482142857142861*G0_1_1_2_1 - 0.388392857142861*G0_1_1_2_2;
    A[92] = -0.0187500000000002*G0_0_1_0_0 + 0.00267857142857161*G0_0_1_0_2 + 0.0187500000000001*G0_0_1_1_1 - 0.00267857142857171*G0_0_1_1_2 + 0.00267857142857161*G0_0_1_2_0 - 0.00267857142857171*G0_0_1_2_1 + 0.0535714285714301*G0_1_1_0_0 + 0.0388392857142868*G0_1_1_0_1 - 0.0120535714285714*G0_1_1_0_2 + 0.0388392857142868*G0_1_1_1_0 + 0.0723214285714302*G0_1_1_1_1 - 0.0147321428571431*G0_1_1_1_2 - 0.0120535714285714*G0_1_1_2_0 - 0.0147321428571431*G0_1_1_2_1 - 0.150000000000001*G0_1_1_2_2;
    A[61] = A[51] + 0.0294642857142866*G0_0_0_0_0 - 0.00468749999999994*G0_0_0_0_1 + 0.00736607142857179*G0_0_0_0_2 - 0.00468749999999994*G0_0_0_1_0 + 0.00468750000000008*G0_0_0_1_2 + 0.00736607142857179*G0_0_0_2_0 + 0.00468750000000008*G0_0_0_2_1 - 0.0441964285714291*G0_0_0_2_2 - 0.0147321428571419*G0_1_0_0_0 + 0.0147321428571437*G0_1_0_0_2 + 0.0147321428571437*G0_1_0_2_0 - 0.0147321428571423*G0_1_0_2_2;
    A[41] = -A[61] + 0.00401785714285786*G0_1_0_0_0 - 0.0261160714285715*G0_1_0_0_1 + 0.000669642857143349*G0_1_0_0_2 - 0.0261160714285715*G0_1_0_1_0 - 0.168750000000001*G0_1_0_1_1 - 0.0194196428571426*G0_1_0_1_2 + 0.000669642857143353*G0_1_0_2_0 - 0.0194196428571426*G0_1_0_2_1 - 0.0455357142857143*G0_1_0_2_2;
    A[40] = -A[41] + 0.0281250000000003*G0_0_0_0_0 + 0.0200892857142861*G0_0_0_0_2 - 0.0281250000000003*G0_0_0_1_1 - 0.0200892857142861*G0_0_0_1_2 + 0.0200892857142861*G0_0_0_2_0 - 0.0200892857142861*G0_0_0_2_1 + 0.0241071428571431*G0_0_1_0_0 + 0.00200892857142857*G0_0_1_0_1 + 0.00870535714285721*G0_0_1_0_2 + 0.00200892857142857*G0_0_1_1_0 - 0.0040178571428573*G0_0_1_1_1 - 0.0113839285714289*G0_0_1_1_2 + 0.00870535714285721*G0_0_1_2_0 - 0.0113839285714289*G0_0_1_2_1 - 0.0562500000000012*G0_0_1_2_2 + 0.0200892857142862*G0_1_0_0_0 - 0.0200892857142859*G0_1_0_0_1 - 0.0200892857142859*G0_1_0_1_0 - 0.180803571428573*G0_1_0_1_1 - 0.0401785714285721*G0_1_0_1_2 - 0.0401785714285721*G0_1_0_2_1 - 0.0562500000000011*G0_1_0_2_2 + 0.0241071428571433*G0_1_1_0_0 + 0.00401785714285713*G0_1_1_0_1 + 0.00669642857142852*G0_1_1_0_2 + 0.00401785714285713*G0_1_1_1_0 - 0.0120535714285722*G0_1_1_1_1 - 0.0187500000000008*G0_1_1_1_2 + 0.00669642857142852*G0_1_1_2_0 - 0.0187500000000008*G0_1_1_2_1 - 0.0334821428571441*G0_1_1_2_2;
    A[4] = A[40] + 0.00200892857142854*G0_0_1_0_1 - 0.0020089285714287*G0_0_1_0_2 + 0.00200892857142854*G0_0_1_1_0 - 0.00803571428571491*G0_0_1_1_1 - 0.00736607142857184*G0_0_1_1_2 - 0.0020089285714287*G0_0_1_2_0 - 0.00736607142857184*G0_0_1_2_1 + 0.0227678571428571*G0_0_1_2_2 - 0.00200892857142854*G0_1_0_0_1 + 0.0020089285714287*G0_1_0_0_2 - 0.00200892857142854*G0_1_0_1_0 + 0.00803571428571491*G0_1_0_1_1 + 0.00736607142857184*G0_1_0_1_2 + 0.0020089285714287*G0_1_0_2_0 + 0.00736607142857184*G0_1_0_2_1 - 0.0227678571428571*G0_1_0_2_2;
    A[60] = -A[40] + 0.168750000000002*G0_1_0_0_0 + 0.0261160714285716*G0_1_0_0_1 + 0.0194196428571427*G0_1_0_0_2 + 0.0261160714285716*G0_1_0_1_0 - 0.00401785714285783*G0_1_0_1_1 - 0.000669642857143358*G0_1_0_1_2 + 0.0194196428571427*G0_1_0_2_0 - 0.000669642857143358*G0_1_0_2_1 + 0.0455357142857143*G0_1_0_2_2 + 0.168750000000002*G0_1_1_0_0 + 0.0261160714285716*G0_1_1_0_1 + 0.0194196428571427*G0_1_1_0_2 + 0.0261160714285716*G0_1_1_1_0 - 0.00401785714285785*G0_1_1_1_1 - 0.000669642857143365*G0_1_1_1_2 + 0.0194196428571427*G0_1_1_2_0 - 0.000669642857143361*G0_1_1_2_1 + 0.0455357142857142*G0_1_1_2_2;
    A[71] = -A[41] + 0.0830357142857152*G0_0_0_0_0 + 0.0107142857142856*G0_0_0_0_1 + 0.0294642857142862*G0_0_0_0_2 + 0.0107142857142856*G0_0_0_1_0 + 0.120535714285715*G0_0_0_1_1 + 0.0133928571428573*G0_0_0_1_2 + 0.0294642857142862*G0_0_0_2_0 + 0.0133928571428573*G0_0_0_2_1 + 0.0642857142857154*G0_0_0_2_2 + 0.0187500000000002*G0_1_0_0_0 - 0.00267857142857162*G0_1_0_0_1 - 0.00267857142857163*G0_1_0_1_0 + 0.00267857142857173*G0_1_0_1_2 + 0.00267857142857173*G0_1_0_2_1 - 0.01875*G0_1_0_2_2;
    A[13] = A[16] - 0.0160714285714288*G0_0_0_0_0 + 0.0033482142857143*G0_0_0_0_1 - 0.00870535714285715*G0_0_0_0_2 + 0.0033482142857143*G0_0_0_1_0 + 0.101785714285715*G0_0_0_1_1 + 0.00200892857142878*G0_0_0_1_2 - 0.00870535714285715*G0_0_0_2_0 + 0.00200892857142878*G0_0_0_2_1 - 0.00401785714285684*G0_0_0_2_2 + 0.0515625000000003*G0_0_1_0_1 - 0.00334821428571471*G0_0_1_0_2 + 0.0515625000000002*G0_0_1_1_0 + 0.490178571428575*G0_0_1_1_1 + 0.047544642857143*G0_0_1_1_2 - 0.0033482142857147*G0_0_1_2_0 + 0.047544642857143*G0_0_1_2_1 + 0.0308035714285716*G0_0_1_2_2;
    A[30] = A[4] + 0.00468749999999994*G0_0_0_0_1 - 0.00468750000000011*G0_0_0_0_2 + 0.00468749999999994*G0_0_0_1_0 - 0.0294642857142867*G0_0_0_1_1 - 0.00736607142857181*G0_0_0_1_2 - 0.00468750000000011*G0_0_0_2_0 - 0.00736607142857181*G0_0_0_2_1 + 0.044196428571429*G0_0_0_2_2 + 0.0026785714285714*G0_0_1_0_1 - 0.00267857142857141*G0_0_1_0_2 + 0.0026785714285714*G0_0_1_1_0 - 0.0214285714285717*G0_0_1_1_1 - 0.00267857142857142*G0_0_1_2_0 + 0.0214285714285719*G0_0_1_2_2 + 0.00669642857142864*G0_1_0_0_1 - 0.00669642857142865*G0_1_0_0_2 + 0.00669642857142864*G0_1_0_1_0 - 0.0522321428571436*G0_1_0_1_1 - 0.00669642857142865*G0_1_0_2_0 + 0.0522321428571438*G0_1_0_2_2 + 0.0046875000000001*G0_1_1_0_1 - 0.00468749999999995*G0_1_1_0_2 + 0.00468750000000009*G0_1_1_1_0 - 0.0441964285714286*G0_1_1_1_1 + 0.00736607142857191*G0_1_1_1_2 - 0.00468749999999995*G0_1_1_2_0 + 0.00736607142857191*G0_1_1_2_1 + 0.0294642857142868*G0_1_1_2_2;
    A[28] = A[27] - 0.0147321428571419*G0_1_0_0_0 + 0.0147321428571437*G0_1_0_0_1 + 0.0147321428571437*G0_1_0_1_0 - 0.0147321428571418*G0_1_0_1_1 + 0.0294642857142866*G0_1_1_0_0 + 0.00736607142857184*G0_1_1_0_1 - 0.00468750000000001*G0_1_1_0_2 + 0.00736607142857184*G0_1_1_1_0 - 0.0441964285714286*G0_1_1_1_1 + 0.0046875000000001*G0_1_1_1_2 - 0.00468750000000001*G0_1_1_2_0 + 0.0046875000000001*G0_1_1_2_1;
    A[80] = -A[30] + 0.168750000000001*G0_0_0_0_0 + 0.0194196428571427*G0_0_0_0_1 + 0.0261160714285716*G0_0_0_0_2 + 0.0194196428571427*G0_0_0_1_0 + 0.0455357142857142*G0_0_0_1_1 - 0.000669642857143354*G0_0_0_1_2 + 0.0261160714285716*G0_0_0_2_0 - 0.000669642857143358*G0_0_0_2_1 - 0.00401785714285774*G0_0_0_2_2 + 0.168750000000001*G0_0_1_0_0 + 0.0194196428571427*G0_0_1_0_1 + 0.0261160714285716*G0_0_1_0_2 + 0.0194196428571427*G0_0_1_1_0 + 0.0455357142857141*G0_0_1_1_1 - 0.000669642857143368*G0_0_1_1_2 + 0.0261160714285716*G0_0_1_2_0 - 0.000669642857143368*G0_0_1_2_1 - 0.00401785714285778*G0_0_1_2_2;
    A[62] = -A[82] + 0.00334821428571475*G0_0_1_0_1 - 0.0515625000000003*G0_0_1_0_2 + 0.00334821428571475*G0_0_1_1_0 - 0.0308035714285711*G0_0_1_1_1 - 0.0475446428571431*G0_0_1_1_2 - 0.0515625000000003*G0_0_1_2_0 - 0.0475446428571431*G0_0_1_2_1 - 0.490178571428576*G0_0_1_2_2 - 0.0723214285714296*G0_1_1_0_0 - 0.0354910714285721*G0_1_1_0_1 - 0.0368303571428574*G0_1_1_0_2 - 0.0354910714285721*G0_1_1_1_0 - 0.0843750000000012*G0_1_1_1_1 - 0.0354910714285718*G0_1_1_1_2 - 0.0368303571428574*G0_1_1_2_0 - 0.0354910714285718*G0_1_1_2_1 - 0.340178571428575*G0_1_1_2_2;
    A[14] = -A[16] + 0.00401785714285785*G0_0_1_0_0 - 0.0261160714285715*G0_0_1_0_1 + 0.000669642857143351*G0_0_1_0_2 - 0.0261160714285715*G0_0_1_1_0 - 0.168750000000001*G0_0_1_1_1 - 0.0194196428571426*G0_0_1_1_2 + 0.00066964285714335*G0_0_1_2_0 - 0.0194196428571426*G0_0_1_2_1 - 0.0455357142857143*G0_0_1_2_2;
    A[23] = -A[28] + 0.00401785714285786*G0_1_0_0_0 + 0.000669642857143374*G0_1_0_0_1 - 0.0261160714285716*G0_1_0_0_2 + 0.000669642857143375*G0_1_0_1_0 - 0.045535714285714*G0_1_0_1_1 - 0.0194196428571427*G0_1_0_1_2 - 0.0261160714285716*G0_1_0_2_0 - 0.0194196428571427*G0_1_0_2_1 - 0.168750000000002*G0_1_0_2_2;
    A[25] = -A[23] + 0.0187500000000002*G0_1_0_0_0 - 0.0026785714285716*G0_1_0_0_2 - 0.0187500000000001*G0_1_0_1_1 + 0.00267857142857172*G0_1_0_1_2 - 0.00267857142857162*G0_1_0_2_0 + 0.00267857142857171*G0_1_0_2_1 + 0.0830357142857153*G0_1_1_0_0 + 0.0294642857142863*G0_1_1_0_1 + 0.0107142857142857*G0_1_1_0_2 + 0.0294642857142863*G0_1_1_1_0 + 0.0642857142857151*G0_1_1_1_1 + 0.0133928571428573*G0_1_1_1_2 + 0.0107142857142857*G0_1_1_2_0 + 0.0133928571428573*G0_1_1_2_1 + 0.120535714285716*G0_1_1_2_2;
    A[19] = 0.05357142857143*G0_0_0_0_0 - 0.0120535714285714*G0_0_0_0_1 + 0.0388392857142868*G0_0_0_0_2 - 0.0120535714285714*G0_0_0_1_0 - 0.150000000000001*G0_0_0_1_1 - 0.0147321428571431*G0_0_0_1_2 + 0.0388392857142868*G0_0_0_2_0 - 0.0147321428571431*G0_0_0_2_1 + 0.07232142857143*G0_0_0_2_2 - 0.0187500000000002*G0_0_1_0_0 + 0.00267857142857165*G0_0_1_0_1 + 0.00267857142857165*G0_0_1_1_0 - 0.00267857142857172*G0_0_1_1_2 - 0.00267857142857172*G0_0_1_2_1 + 0.01875*G0_0_1_2_2;
    A[87] = -A[37] - 0.462053571428577*G0_0_0_0_0 - 0.158705357142858*G0_0_0_0_1 - 0.102455357142858*G0_0_0_0_2 - 0.158705357142858*G0_0_0_1_0 - 0.289285714285716*G0_0_0_1_1 - 0.0341517857142845*G0_0_0_1_2 - 0.102455357142858*G0_0_0_2_0 - 0.0341517857142845*G0_0_0_2_1 - 0.0080357142857134*G0_0_0_2_2 - 0.196875000000002*G0_0_1_0_0 - 0.192857142857145*G0_0_1_0_1 - 0.0441964285714283*G0_0_1_0_2 - 0.192857142857145*G0_0_1_1_0 - 0.313392857142859*G0_0_1_1_1 - 0.0241071428571418*G0_0_1_1_2 - 0.0441964285714283*G0_0_1_2_0 - 0.0241071428571418*G0_0_1_2_1 + 0.0200892857142868*G0_0_1_2_2;
    A[42] = -A[62] - 0.0883928571428584*G0_1_1_0_0 - 0.0441964285714293*G0_1_1_0_1 - 0.0334821428571431*G0_1_1_0_2 - 0.0441964285714293*G0_1_1_1_0 - 0.0883928571428583*G0_1_1_1_1 - 0.033482142857143*G0_1_1_1_2 - 0.0334821428571431*G0_1_1_2_0 - 0.033482142857143*G0_1_1_2_1 - 0.23839285714286*G0_1_1_2_2;
    A[65] = -A[45] - 0.196875000000002*G0_1_0_0_0 - 0.0441964285714282*G0_1_0_0_1 - 0.192857142857145*G0_1_0_0_2 - 0.0441964285714282*G0_1_0_1_0 + 0.0200892857142872*G0_1_0_1_1 - 0.0241071428571419*G0_1_0_1_2 - 0.192857142857145*G0_1_0_2_0 - 0.0241071428571419*G0_1_0_2_1 - 0.31339285714286*G0_1_0_2_2 - 0.462053571428577*G0_1_1_0_0 - 0.102455357142858*G0_1_1_0_1 - 0.158705357142858*G0_1_1_0_2 - 0.102455357142858*G0_1_1_1_0 - 0.0080357142857134*G0_1_1_1_1 - 0.0341517857142846*G0_1_1_1_2 - 0.158705357142858*G0_1_1_2_0 - 0.0341517857142846*G0_1_1_2_1 - 0.289285714285716*G0_1_1_2_2;
    A[6] = -A[4] + 0.168750000000002*G0_0_1_0_0 + 0.0261160714285716*G0_0_1_0_1 + 0.0194196428571427*G0_0_1_0_2 + 0.0261160714285716*G0_0_1_1_0 - 0.00401785714285784*G0_0_1_1_1 - 0.000669642857143361*G0_0_1_1_2 + 0.0194196428571427*G0_0_1_2_0 - 0.000669642857143358*G0_0_1_2_1 + 0.0455357142857143*G0_0_1_2_2 + 0.168750000000002*G0_1_1_0_0 + 0.0261160714285716*G0_1_1_0_1 + 0.0194196428571427*G0_1_1_0_2 + 0.0261160714285716*G0_1_1_1_0 - 0.00401785714285785*G0_1_1_1_1 - 0.000669642857143361*G0_1_1_1_2 + 0.0194196428571427*G0_1_1_2_0 - 0.000669642857143361*G0_1_1_2_1 + 0.0455357142857143*G0_1_1_2_2;
    A[17] = -A[14] + 0.0830357142857152*G0_0_0_0_0 + 0.0107142857142856*G0_0_0_0_1 + 0.0294642857142862*G0_0_0_0_2 + 0.0107142857142856*G0_0_0_1_0 + 0.120535714285715*G0_0_0_1_1 + 0.0133928571428573*G0_0_0_1_2 + 0.0294642857142862*G0_0_0_2_0 + 0.0133928571428573*G0_0_0_2_1 + 0.0642857142857154*G0_0_0_2_2 + 0.0187500000000002*G0_0_1_0_0 - 0.00267857142857161*G0_0_1_0_1 - 0.00267857142857162*G0_0_1_1_0 + 0.00267857142857174*G0_0_1_1_2 + 0.00267857142857174*G0_0_1_2_1 - 0.01875*G0_0_1_2_2;
    A[34] = -A[37] - 0.10044642857143*G0_0_0_0_0 - 0.0401785714285712*G0_0_0_0_1 - 0.0763392857142869*G0_0_0_0_2 - 0.0401785714285712*G0_0_0_1_0 + 0.0964285714285754*G0_0_0_1_1 + 0.0642857142857169*G0_0_0_1_2 - 0.0763392857142869*G0_0_0_2_0 + 0.0642857142857169*G0_0_0_2_1 - 0.229017857142859*G0_0_0_2_2 - 0.0241071428571429*G0_0_1_0_0 + 0.0241071428571426*G0_0_1_0_2 + 0.28928571428572*G0_0_1_1_1 + 0.241071428571432*G0_0_1_1_2 + 0.0241071428571426*G0_0_1_2_0 + 0.241071428571432*G0_0_1_2_1 + 0.216964285714289*G0_0_1_2_2 - 0.0562500000000005*G0_1_0_0_0 - 0.0482142857142864*G0_1_0_0_1 - 0.0160714285714285*G0_1_0_0_2 - 0.0482142857142864*G0_1_0_1_0 + 0.168750000000002*G0_1_0_1_1 + 0.0241071428571439*G0_1_0_1_2 - 0.0160714285714285*G0_1_0_2_0 + 0.0241071428571439*G0_1_0_2_1 - 0.0321428571428564*G0_1_0_2_2 - 0.024107142857144*G0_1_1_0_0 - 0.0723214285714304*G0_1_1_0_1 - 0.0723214285714304*G0_1_1_1_0 + 0.0723214285714301*G0_1_1_1_2 + 0.0723214285714301*G0_1_1_2_1 + 0.0241071428571438*G0_1_1_2_2;
    A[36] = -A[34] - 0.0200892857142871*G0_0_1_0_0 + 0.044196428571428*G0_0_1_0_1 + 0.0241071428571416*G0_0_1_0_2 + 0.044196428571428*G0_0_1_1_0 + 0.196875000000002*G0_0_1_1_1 + 0.192857142857144*G0_0_1_1_2 + 0.0241071428571416*G0_0_1_2_0 + 0.192857142857144*G0_0_1_2_1 + 0.313392857142859*G0_0_1_2_2 - 0.0281250000000007*G0_1_1_0_0 - 0.05825892857143*G0_1_1_0_1 - 0.0100446428571429*G0_1_1_0_2 - 0.05825892857143*G0_1_1_1_0 - 0.265178571428575*G0_1_1_1_1 + 0.0341517857142863*G0_1_1_1_2 - 0.0100446428571429*G0_1_1_2_0 + 0.0341517857142863*G0_1_1_2_1 + 0.0241071428571433*G0_1_1_2_2;
    A[86] = -A[36] + 0.0281250000000006*G0_0_0_0_0 + 0.0100446428571429*G0_0_0_0_1 + 0.0582589285714301*G0_0_0_0_2 + 0.0100446428571429*G0_0_0_1_0 - 0.0241071428571435*G0_0_0_1_1 - 0.0341517857142862*G0_0_0_1_2 + 0.0582589285714301*G0_0_0_2_0 - 0.0341517857142862*G0_0_0_2_1 + 0.265178571428576*G0_0_0_2_2 - 0.0562500000000038*G0_0_1_0_0 - 0.0100446428571442*G0_0_1_0_1 - 0.0301339285714305*G0_0_1_0_2 - 0.0100446428571442*G0_0_1_1_0 + 0.0100446428571418*G0_0_1_1_2 - 0.0301339285714305*G0_0_1_2_0 + 0.0100446428571418*G0_0_1_2_1 + 0.116517857142856*G0_0_1_2_2;
    A[35] = A[36] + 0.0361607142857158*G0_0_0_0_0 - 0.0120535714285712*G0_0_0_0_1 - 0.0120535714285712*G0_0_0_1_0 + 0.0602678571428596*G0_0_0_1_1 + 0.0723214285714307*G0_0_0_1_2 + 0.0723214285714308*G0_0_0_2_1 - 0.216964285714286*G0_0_0_2_2 + 0.0361607142857162*G0_0_1_0_0 - 0.0241071428571424*G0_0_1_0_1 + 0.0361607142857163*G0_0_1_0_2 - 0.0241071428571424*G0_0_1_1_0 + 0.0241071428571454*G0_0_1_1_2 + 0.0361607142857163*G0_0_1_2_0 + 0.0241071428571454*G0_0_1_2_1 - 0.10848214285714*G0_0_1_2_2 + 0.0241071428571427*G0_1_0_0_0 - 0.00602678571428579*G0_1_0_0_1 + 0.00602678571428577*G0_1_0_0_2 - 0.00602678571428578*G0_1_0_1_0 + 0.00602678571428621*G0_1_0_1_2 + 0.00602678571428578*G0_1_0_2_0 + 0.00602678571428622*G0_1_0_2_1 - 0.0361607142857137*G0_1_0_2_2 - 0.0120535714285711*G0_1_1_0_0 + 0.0120535714285715*G0_1_1_0_2 + 0.0120535714285715*G0_1_1_2_0 - 0.0120535714285712*G0_1_1_2_2;
    A[85] = -A[35] + 0.148660714285719*G0_0_0_0_0 - 0.0441964285714282*G0_0_0_0_1 + 0.0883928571428604*G0_0_0_0_2 - 0.0441964285714282*G0_0_0_1_0 - 0.0241071428571416*G0_0_0_1_1 + 0.020089285714287*G0_0_0_1_2 + 0.0883928571428605*G0_0_0_2_0 + 0.020089285714287*G0_0_0_2_1 + 0.0843750000000038*G0_0_0_2_2 - 0.116517857142855*G0_0_1_0_0 - 0.0100446428571418*G0_0_1_0_1 + 0.0301339285714306*G0_0_1_0_2 - 0.0100446428571418*G0_0_1_1_0 + 0.0100446428571443*G0_0_1_1_2 + 0.0301339285714306*G0_0_1_2_0 + 0.0100446428571443*G0_0_1_2_1 + 0.0562500000000034*G0_0_1_2_2;
    A[58] = A[85] + 0.0964285714285705*G0_0_1_0_0 - 0.0060267857142865*G0_0_1_0_1 - 0.0180803571428581*G0_0_1_0_2 - 0.00602678571428651*G0_0_1_1_0 - 0.0200892857142862*G0_0_1_1_1 + 0.00200892857142841*G0_0_1_1_2 - 0.0180803571428581*G0_0_1_2_0 + 0.00200892857142841*G0_0_1_2_1 - 0.0321428571428583*G0_0_1_2_2 - 0.0964285714285705*G0_1_0_0_0 + 0.0060267857142865*G0_1_0_0_1 + 0.0180803571428581*G0_1_0_0_2 + 0.00602678571428651*G0_1_0_1_0 + 0.0200892857142861*G0_1_0_1_1 - 0.00200892857142841*G0_1_0_1_2 + 0.0180803571428581*G0_1_0_2_0 - 0.00200892857142841*G0_1_0_2_1 + 0.0321428571428583*G0_1_0_2_2;
    A[67] = A[58] - 0.0723214285714314*G0_0_0_0_0 + 0.0301339285714284*G0_0_0_0_1 - 0.0301339285714304*G0_0_0_0_2 + 0.0301339285714284*G0_0_0_1_0 + 0.0723214285714289*G0_0_0_1_1 + 0.0180803571428569*G0_0_0_1_2 - 0.0301339285714304*G0_0_0_2_0 + 0.0180803571428569*G0_0_0_2_1 - 0.0361607142857166*G0_0_0_2_2 - 0.0120535714285716*G0_0_1_0_1 + 0.0120535714285714*G0_0_1_0_2 - 0.0120535714285716*G0_0_1_1_0 + 0.0361607142857147*G0_0_1_1_1 + 0.0120535714285714*G0_0_1_2_0 - 0.0361607142857152*G0_0_1_2_2 + 0.0482142857142869*G0_1_0_1_1 - 0.0482142857142869*G0_1_0_2_2 + 0.0723214285714318*G0_1_1_0_0 + 0.0301339285714304*G0_1_1_0_1 - 0.0301339285714284*G0_1_1_0_2 + 0.0301339285714304*G0_1_1_1_0 + 0.0361607142857166*G0_1_1_1_1 - 0.0180803571428569*G0_1_1_1_2 - 0.0301339285714284*G0_1_1_2_0 - 0.0180803571428569*G0_1_1_2_1 - 0.0723214285714292*G0_1_1_2_2;
    A[7] = A[67] - 0.384375000000003*G0_0_0_0_0 - 0.0328125000000001*G0_0_0_0_1 - 0.0542410714285717*G0_0_0_0_2 - 0.0328125000000001*G0_0_0_1_0 - 0.0602678571428578*G0_0_0_1_1 - 0.0140624999999998*G0_0_0_1_2 - 0.0542410714285717*G0_0_0_2_0 - 0.0140624999999998*G0_0_0_2_1 - 0.0281249999999994*G0_0_0_2_2 + 0.154017857142858*G0_0_1_0_0 + 0.0267857142857146*G0_0_1_0_1 + 0.00937500000000004*G0_0_1_0_2 + 0.0267857142857146*G0_0_1_1_0 - 0.0482142857142863*G0_0_1_1_1 + 0.00937500000000004*G0_0_1_2_0 + 0.0281250000000008*G0_0_1_2_2 - 0.239732142857147*G0_1_0_0_0 - 0.0408482142857153*G0_1_0_0_1 - 0.0462053571428582*G0_1_0_0_2 - 0.0408482142857153*G0_1_0_1_0 - 0.088392857142859*G0_1_0_1_1 - 0.00200892857142866*G0_1_0_1_2 - 0.0462053571428582*G0_1_0_2_0 - 0.00200892857142867*G0_1_0_2_1 + 0.0334821428571407*G0_1_1_0_0 - 0.0294642857142873*G0_1_1_0_1 + 0.041517857142857*G0_1_1_0_2 - 0.0294642857142873*G0_1_1_1_0 - 0.0964285714285736*G0_1_1_1_1 + 0.00803571428571415*G0_1_1_1_2 + 0.041517857142857*G0_1_1_2_0 + 0.00803571428571415*G0_1_1_2_1 + 0.0602678571428576*G0_1_1_2_2;
    A[76] = A[67] - 0.0964285714285706*G0_0_1_0_0 + 0.0180803571428581*G0_0_1_0_1 + 0.00602678571428655*G0_0_1_0_2 + 0.0180803571428581*G0_0_1_1_0 + 0.0321428571428584*G0_0_1_1_1 - 0.00200892857142838*G0_0_1_1_2 + 0.00602678571428655*G0_0_1_2_0 - 0.00200892857142838*G0_0_1_2_1 + 0.0200892857142866*G0_0_1_2_2 + 0.0964285714285706*G0_1_0_0_0 - 0.0180803571428581*G0_1_0_0_1 - 0.00602678571428655*G0_1_0_0_2 - 0.0180803571428581*G0_1_0_1_0 - 0.0321428571428584*G0_1_0_1_1 + 0.00200892857142838*G0_1_0_1_2 - 0.00602678571428655*G0_1_0_2_0 + 0.00200892857142837*G0_1_0_2_1 - 0.0200892857142866*G0_1_0_2_2;
    A[74] = -A[76] - 0.116517857142856*G0_0_1_0_0 + 0.0301339285714307*G0_0_1_0_1 - 0.0100446428571418*G0_0_1_0_2 + 0.0301339285714307*G0_0_1_1_0 + 0.0562500000000041*G0_0_1_1_1 + 0.0100446428571443*G0_0_1_1_2 - 0.0100446428571418*G0_0_1_2_0 + 0.0100446428571443*G0_0_1_2_1 + 0.148660714285719*G0_1_1_0_0 + 0.0883928571428606*G0_1_1_0_1 - 0.0441964285714282*G0_1_1_0_2 + 0.0883928571428606*G0_1_1_1_0 + 0.0843750000000047*G0_1_1_1_1 + 0.0200892857142871*G0_1_1_1_2 - 0.0441964285714282*G0_1_1_2_0 + 0.0200892857142871*G0_1_1_2_1 - 0.0241071428571419*G0_1_1_2_2;
    A[53] = -A[58] + 0.148660714285719*G0_0_0_0_0 - 0.0441964285714282*G0_0_0_0_1 + 0.0883928571428605*G0_0_0_0_2 - 0.0441964285714282*G0_0_0_1_0 - 0.0241071428571416*G0_0_0_1_1 + 0.020089285714287*G0_0_0_1_2 + 0.0883928571428605*G0_0_0_2_0 + 0.020089285714287*G0_0_0_2_1 + 0.0843750000000038*G0_0_0_2_2 - 0.116517857142855*G0_1_0_0_0 - 0.0100446428571418*G0_1_0_0_1 + 0.0301339285714306*G0_1_0_0_2 - 0.0100446428571418*G0_1_0_1_0 + 0.0100446428571443*G0_1_0_1_2 + 0.0301339285714306*G0_1_0_2_0 + 0.0100446428571443*G0_1_0_2_1 + 0.0562500000000034*G0_1_0_2_2;
    A[70] = A[7] - 0.490178571428575*G0_0_1_0_0 - 0.0495535714285718*G0_0_1_0_1 - 0.0495535714285717*G0_0_1_0_2 - 0.0495535714285718*G0_0_1_1_0 - 0.00803571428571431*G0_0_1_1_1 - 0.00401785714285712*G0_0_1_1_2 - 0.0495535714285717*G0_0_1_2_0 - 0.00401785714285712*G0_0_1_2_1 - 0.00803571428571437*G0_0_1_2_2 + 0.490178571428575*G0_1_0_0_0 + 0.0495535714285717*G0_1_0_0_1 + 0.0495535714285717*G0_1_0_0_2 + 0.0495535714285717*G0_1_0_1_0 + 0.0080357142857143*G0_1_0_1_1 + 0.00401785714285712*G0_1_0_1_2 + 0.0495535714285717*G0_1_0_2_0 + 0.00401785714285712*G0_1_0_2_1 + 0.00803571428571437*G0_1_0_2_2;
    A[5] = A[70] + 0.490178571428575*G0_0_0_0_0 + 0.0441964285714287*G0_0_0_0_1 + 0.0549107142857148*G0_0_0_0_2 + 0.0441964285714287*G0_0_0_1_0 + 0.0482142857142863*G0_0_0_1_1 + 0.0040178571428571*G0_0_0_1_2 + 0.0549107142857148*G0_0_0_2_0 + 0.0040178571428571*G0_0_0_2_1 - 0.0321428571428577*G0_0_0_2_2 - 0.00535714285714309*G0_0_1_0_1 + 0.00535714285714305*G0_0_1_0_2 - 0.00535714285714309*G0_0_1_1_0 + 0.0401785714285719*G0_0_1_1_1 + 0.00535714285714303*G0_0_1_2_0 - 0.040178571428572*G0_0_1_2_2 - 0.00535714285714307*G0_1_0_0_1 + 0.00535714285714304*G0_1_0_0_2 - 0.00535714285714306*G0_1_0_1_0 + 0.0401785714285719*G0_1_0_1_1 + 0.00535714285714304*G0_1_0_2_0 - 0.040178571428572*G0_1_0_2_2 - 0.490178571428576*G0_1_1_0_0 - 0.0549107142857149*G0_1_1_0_1 - 0.0441964285714287*G0_1_1_0_2 - 0.0549107142857149*G0_1_1_1_0 + 0.0321428571428575*G0_1_1_1_1 - 0.00401785714285714*G0_1_1_1_2 - 0.0441964285714287*G0_1_1_2_0 - 0.00401785714285714*G0_1_1_2_1 - 0.0482142857142864*G0_1_1_2_2;
    A[50] = A[5] + 0.490178571428576*G0_0_1_0_0 + 0.0495535714285718*G0_0_1_0_1 + 0.0495535714285717*G0_0_1_0_2 + 0.0495535714285718*G0_0_1_1_0 + 0.00803571428571437*G0_0_1_1_1 + 0.00401785714285711*G0_0_1_1_2 + 0.0495535714285717*G0_0_1_2_0 + 0.00401785714285711*G0_0_1_2_1 + 0.00803571428571433*G0_0_1_2_2 - 0.490178571428576*G0_1_0_0_0 - 0.0495535714285718*G0_1_0_0_1 - 0.0495535714285717*G0_1_0_0_2 - 0.0495535714285718*G0_1_0_1_0 - 0.00803571428571438*G0_1_0_1_1 - 0.00401785714285711*G0_1_0_1_2 - 0.0495535714285717*G0_1_0_2_0 - 0.00401785714285711*G0_1_0_2_1 - 0.00803571428571433*G0_1_0_2_2;
    A[24] = -A[26] - 0.0883928571428584*G0_1_1_0_0 - 0.0441964285714293*G0_1_1_0_1 - 0.0334821428571431*G0_1_1_0_2 - 0.0441964285714293*G0_1_1_1_0 - 0.0883928571428583*G0_1_1_1_1 - 0.033482142857143*G0_1_1_1_2 - 0.0334821428571431*G0_1_1_2_0 - 0.033482142857143*G0_1_1_2_1 - 0.23839285714286*G0_1_1_2_2;
    A[84] = -A[86] - 0.0562500000000039*G0_0_1_0_0 - 0.0301339285714308*G0_0_1_0_1 - 0.0100446428571442*G0_0_1_0_2 - 0.0301339285714307*G0_0_1_1_0 + 0.116517857142855*G0_0_1_1_1 + 0.0100446428571416*G0_0_1_1_2 - 0.0100446428571442*G0_0_1_2_0 + 0.0100446428571416*G0_0_1_2_1 + 0.0281250000000007*G0_1_1_0_0 + 0.05825892857143*G0_1_1_0_1 + 0.0100446428571429*G0_1_1_0_2 + 0.05825892857143*G0_1_1_1_0 + 0.265178571428575*G0_1_1_1_1 - 0.0341517857142863*G0_1_1_1_2 + 0.0100446428571429*G0_1_1_2_0 - 0.0341517857142863*G0_1_1_2_1 - 0.0241071428571433*G0_1_1_2_2;
    A[48] = A[84] + 0.0321428571428584*G0_0_1_0_0 + 0.0180803571428582*G0_0_1_0_1 - 0.00200892857142836*G0_0_1_0_2 + 0.0180803571428582*G0_0_1_1_0 - 0.0964285714285702*G0_0_1_1_1 + 0.00602678571428667*G0_0_1_1_2 - 0.00200892857142836*G0_0_1_2_0 + 0.00602678571428667*G0_0_1_2_1 + 0.0200892857142864*G0_0_1_2_2 - 0.0321428571428584*G0_1_0_0_0 - 0.0180803571428582*G0_1_0_0_1 + 0.00200892857142837*G0_1_0_0_2 - 0.0180803571428582*G0_1_0_1_0 + 0.0964285714285703*G0_1_0_1_1 - 0.00602678571428666*G0_1_0_1_2 + 0.00200892857142836*G0_1_0_2_0 - 0.00602678571428666*G0_1_0_2_1 - 0.0200892857142864*G0_1_0_2_2;
    A[68] = -A[48] - 0.0562500000000039*G0_1_0_0_0 - 0.0301339285714308*G0_1_0_0_1 - 0.0100446428571442*G0_1_0_0_2 - 0.0301339285714308*G0_1_0_1_0 + 0.116517857142855*G0_1_0_1_1 + 0.0100446428571416*G0_1_0_1_2 - 0.0100446428571442*G0_1_0_2_0 + 0.0100446428571416*G0_1_0_2_1 + 0.0281250000000007*G0_1_1_0_0 + 0.05825892857143*G0_1_1_0_1 + 0.0100446428571429*G0_1_1_0_2 + 0.05825892857143*G0_1_1_1_0 + 0.265178571428575*G0_1_1_1_1 - 0.0341517857142863*G0_1_1_1_2 + 0.0100446428571429*G0_1_1_2_0 - 0.0341517857142863*G0_1_1_2_1 - 0.0241071428571433*G0_1_1_2_2;
    A[47] = -A[67] - 0.116517857142856*G0_1_0_0_0 + 0.0301339285714307*G0_1_0_0_1 - 0.0100446428571418*G0_1_0_0_2 + 0.0301339285714307*G0_1_0_1_0 + 0.0562500000000041*G0_1_0_1_1 + 0.0100446428571443*G0_1_0_1_2 - 0.0100446428571418*G0_1_0_2_0 + 0.0100446428571443*G0_1_0_2_1 + 0.148660714285719*G0_1_1_0_0 + 0.0883928571428606*G0_1_1_0_1 - 0.0441964285714282*G0_1_1_0_2 + 0.0883928571428606*G0_1_1_1_0 + 0.0843750000000047*G0_1_1_1_1 + 0.0200892857142871*G0_1_1_1_2 - 0.0441964285714282*G0_1_1_2_0 + 0.0200892857142871*G0_1_1_2_1 - 0.0241071428571419*G0_1_1_2_2;
    A[91] = A[19] + 0.0187500000000002*G0_0_1_0_0 - 0.00267857142857165*G0_0_1_0_1 - 0.00267857142857165*G0_0_1_1_0 + 0.00267857142857171*G0_0_1_1_2 + 0.00267857142857171*G0_0_1_2_1 - 0.0187499999999999*G0_0_1_2_2 - 0.0187500000000002*G0_1_0_0_0 + 0.00267857142857164*G0_1_0_0_1 + 0.00267857142857164*G0_1_0_1_0 - 0.00267857142857171*G0_1_0_1_2 - 0.0026785714285717*G0_1_0_2_1 + 0.0187499999999999*G0_1_0_2_2;
    A[89] = -A[91] - 0.115178571428574*G0_0_0_0_0 - 0.0455357142857156*G0_0_0_0_2 + 0.115178571428574*G0_0_0_1_1 + 0.0455357142857157*G0_0_0_1_2 - 0.0455357142857156*G0_0_0_2_0 + 0.0455357142857157*G0_0_0_2_1 + 0.192857142857146*G0_0_1_0_0 + 0.168750000000003*G0_0_1_0_1 + 0.024107142857143*G0_0_1_0_2 + 0.168750000000003*G0_0_1_1_0 + 0.28928571428572*G0_0_1_1_1 + 0.0723214285714304*G0_0_1_1_2 + 0.024107142857143*G0_0_1_2_0 + 0.0723214285714304*G0_0_1_2_1 + 0.0294642857142855*G0_1_0_0_0 + 0.0629464285714285*G0_1_0_0_1 + 0.0361607142857142*G0_1_0_0_2 + 0.0629464285714284*G0_1_0_1_0 + 0.433928571428574*G0_1_0_1_1 + 0.129910714285715*G0_1_0_1_2 + 0.0361607142857142*G0_1_0_2_0 + 0.129910714285715*G0_1_0_2_1 + 0.0910714285714292*G0_1_0_2_2 - 0.0241071428571439*G0_1_1_0_0 - 0.0723214285714304*G0_1_1_0_1 - 0.0723214285714304*G0_1_1_1_0 + 0.07232142857143*G0_1_1_1_2 + 0.07232142857143*G0_1_1_2_1 + 0.0241071428571438*G0_1_1_2_2;
    A[39] = -A[89] - 0.289285714285721*G0_0_0_0_0 - 0.0602678571428568*G0_0_0_0_1 - 0.229017857142862*G0_0_0_0_2 - 0.0602678571428568*G0_0_0_1_0 - 0.192857142857144*G0_0_0_1_1 - 0.229017857142859*G0_0_0_1_2 - 0.229017857142862*G0_0_0_2_0 - 0.229017857142859*G0_0_0_2_1 - 0.506250000000009*G0_0_0_2_2 + 0.216964285714289*G0_0_1_0_0 + 0.168750000000003*G0_0_1_0_1 + 0.168750000000003*G0_0_1_1_0 - 0.168750000000002*G0_0_1_1_2 - 0.168750000000002*G0_0_1_2_1 - 0.216964285714288*G0_0_1_2_2;
    A[93] = A[39] - 0.0723214285714284*G0_0_1_0_0 - 0.060267857142857*G0_0_1_0_1 - 0.0120535714285715*G0_0_1_0_2 - 0.060267857142857*G0_0_1_1_0 - 0.144642857142854*G0_0_1_1_1 + 0.108482142857145*G0_0_1_1_2 - 0.0120535714285715*G0_0_1_2_0 + 0.108482142857145*G0_0_1_2_1 + 0.14464285714286*G0_0_1_2_2 + 0.0723214285714285*G0_1_0_0_0 + 0.060267857142857*G0_1_0_0_1 + 0.0120535714285715*G0_1_0_0_2 + 0.060267857142857*G0_1_0_1_0 + 0.144642857142854*G0_1_0_1_1 - 0.108482142857145*G0_1_0_1_2 + 0.0120535714285715*G0_1_0_2_0 - 0.108482142857145*G0_1_0_2_1 - 0.14464285714286*G0_1_0_2_2;
    A[98] = -A[93] - 0.289285714285721*G0_0_0_0_0 - 0.0602678571428568*G0_0_0_0_1 - 0.229017857142862*G0_0_0_0_2 - 0.0602678571428568*G0_0_0_1_0 - 0.192857142857144*G0_0_0_1_1 - 0.229017857142859*G0_0_0_1_2 - 0.229017857142862*G0_0_0_2_0 - 0.229017857142859*G0_0_0_2_1 - 0.506250000000009*G0_0_0_2_2 + 0.216964285714289*G0_1_0_0_0 + 0.168750000000003*G0_1_0_0_1 + 0.168750000000003*G0_1_0_1_0 - 0.168750000000002*G0_1_0_1_2 - 0.168750000000002*G0_1_0_2_1 - 0.216964285714288*G0_1_0_2_2;
    A[66] = 0.0401785714285718*G0_0_0_0_0 + 0.0200892857142857*G0_0_0_0_1 + 0.132589285714287*G0_0_0_0_2 + 0.0200892857142857*G0_0_0_1_0 + 0.0401785714285718*G0_0_0_1_1 + 0.132589285714287*G0_0_0_1_2 + 0.132589285714287*G0_0_0_2_0 + 0.132589285714287*G0_0_0_2_1 + 1.03660714285715*G0_0_0_2_2 - 0.0200892857142862*G0_0_1_0_0 + 0.0200892857142856*G0_0_1_0_2 + 0.020089285714286*G0_0_1_1_1 + 0.0763392857142868*G0_0_1_1_2 + 0.0200892857142856*G0_0_1_2_0 + 0.0763392857142868*G0_0_1_2_1 + 0.650892857142864*G0_0_1_2_2 - 0.0200892857142862*G0_1_0_0_0 + 0.0200892857142856*G0_1_0_0_2 + 0.020089285714286*G0_1_0_1_1 + 0.0763392857142868*G0_1_0_1_2 + 0.0200892857142856*G0_1_0_2_0 + 0.0763392857142868*G0_1_0_2_1 + 0.650892857142864*G0_1_0_2_2 + 0.305357142857147*G0_1_1_0_0 + 0.0763392857142866*G0_1_1_0_1 + 0.148660714285716*G0_1_1_0_2 + 0.0763392857142867*G0_1_1_1_0 + 0.0642857142857153*G0_1_1_1_1 + 0.10044642857143*G0_1_1_1_2 + 0.148660714285716*G0_1_1_2_0 + 0.10044642857143*G0_1_1_2_1 + 0.666964285714294*G0_1_1_2_2;
    A[55] = A[66] + 0.361607142857146*G0_0_0_0_0 + 0.060267857142857*G0_0_0_0_1 + 0.108482142857145*G0_0_0_0_2 + 0.060267857142857*G0_0_0_1_0 + 0.0241071428571431*G0_0_0_1_1 - 0.0361607142857143*G0_0_0_1_2 + 0.108482142857145*G0_0_0_2_0 - 0.0361607142857143*G0_0_0_2_1 - 0.650892857142861*G0_0_0_2_2 + 0.0361607142857158*G0_0_1_0_0 + 0.0241071428571428*G0_0_1_0_1 + 0.108482142857145*G0_0_1_0_2 + 0.0241071428571428*G0_0_1_1_0 + 0.0241071428571432*G0_0_1_1_1 + 0.108482142857145*G0_0_1_2_0 - 0.325446428571431*G0_0_1_2_2 + 0.0361607142857158*G0_1_0_0_0 + 0.0241071428571428*G0_1_0_0_1 + 0.108482142857145*G0_1_0_0_2 + 0.0241071428571428*G0_1_0_1_0 + 0.0241071428571432*G0_1_0_1_1 + 0.108482142857145*G0_1_0_2_0 - 0.325446428571431*G0_1_0_2_2 + 0.361607142857145*G0_1_1_0_0 + 0.0241071428571428*G0_1_1_0_1 + 0.0241071428571428*G0_1_1_1_0 - 0.0241071428571429*G0_1_1_1_2 - 0.0241071428571429*G0_1_1_2_1 - 0.361607142857147*G0_1_1_2_2;
    A[64] = -A[66] - 0.0401785714285719*G0_0_1_0_0 - 0.0200892857142858*G0_0_1_0_1 - 0.0361607142857142*G0_0_1_0_2 - 0.0200892857142858*G0_0_1_1_0 - 0.0401785714285719*G0_0_1_1_1 - 0.0361607142857142*G0_0_1_1_2 - 0.0361607142857142*G0_0_1_2_0 - 0.0361607142857142*G0_0_1_2_1 + 0.265178571428576*G0_0_1_2_2 + 0.381696428571434*G0_1_1_0_0 + 0.120535714285716*G0_1_1_0_1 + 0.172767857142858*G0_1_1_0_2 + 0.120535714285716*G0_1_1_1_0 + 0.10044642857143*G0_1_1_1_1 + 0.068303571428571*G0_1_1_1_2 + 0.172767857142858*G0_1_1_2_0 + 0.068303571428571*G0_1_1_2_1 + 0.482142857142862*G0_1_1_2_2;
    A[75] = A[64] - 0.14464285714286*G0_0_0_0_0 + 0.0441964285714284*G0_0_0_0_1 + 0.100446428571428*G0_0_0_0_2 + 0.0441964285714284*G0_0_0_1_0 + 0.116517857142858*G0_0_0_1_1 + 0.176785714285716*G0_0_0_1_2 + 0.100446428571428*G0_0_0_2_0 + 0.176785714285716*G0_0_0_2_1 + 1.07276785714287*G0_0_0_2_2 + 0.486160714285717*G0_0_1_0_0 + 0.0642857142857139*G0_0_1_0_1 + 0.100446428571428*G0_0_1_0_2 + 0.0642857142857139*G0_0_1_1_0 + 0.116517857142859*G0_0_1_1_1 + 0.15669642857143*G0_0_1_1_2 + 0.100446428571428*G0_0_1_2_0 + 0.15669642857143*G0_0_1_2_1 + 0.441964285714289*G0_0_1_2_2 + 0.180803571428571*G0_1_0_0_0 + 0.0803571428571426*G0_1_0_0_1 + 0.100446428571428*G0_1_0_0_2 + 0.0803571428571426*G0_1_0_1_0 + 0.116517857142858*G0_1_0_1_1 + 0.140625000000002*G0_1_0_1_2 + 0.100446428571428*G0_1_0_2_0 + 0.140625000000002*G0_1_0_2_1 + 0.747321428571436*G0_1_0_2_2 - 0.261160714285718*G0_1_1_0_0 - 0.0763392857142877*G0_1_1_0_1 - 0.0763392857142877*G0_1_1_1_0 + 0.0763392857142877*G0_1_1_1_2 + 0.0763392857142877*G0_1_1_2_1 + 0.261160714285718*G0_1_1_2_2;
    A[46] = -A[66] - 0.0401785714285719*G0_1_0_0_0 - 0.0200892857142858*G0_1_0_0_1 - 0.0361607142857142*G0_1_0_0_2 - 0.0200892857142858*G0_1_0_1_0 - 0.0401785714285719*G0_1_0_1_1 - 0.0361607142857142*G0_1_0_1_2 - 0.0361607142857142*G0_1_0_2_0 - 0.0361607142857142*G0_1_0_2_1 + 0.265178571428577*G0_1_0_2_2 + 0.381696428571434*G0_1_1_0_0 + 0.120535714285716*G0_1_1_0_1 + 0.172767857142858*G0_1_1_0_2 + 0.120535714285716*G0_1_1_1_0 + 0.10044642857143*G0_1_1_1_1 + 0.068303571428571*G0_1_1_1_2 + 0.172767857142858*G0_1_1_2_0 + 0.068303571428571*G0_1_1_2_1 + 0.482142857142862*G0_1_1_2_2;
    A[83] = A[46] + 0.116517857142858*G0_0_0_0_0 + 0.0441964285714284*G0_0_0_0_1 + 0.176785714285716*G0_0_0_0_2 + 0.0441964285714284*G0_0_0_1_0 - 0.14464285714286*G0_0_0_1_1 + 0.100446428571428*G0_0_0_1_2 + 0.176785714285716*G0_0_0_2_0 + 0.100446428571428*G0_0_0_2_1 + 1.07276785714287*G0_0_0_2_2 - 0.0200892857142854*G0_0_1_0_1 + 0.0200892857142857*G0_0_1_0_2 - 0.0200892857142854*G0_0_1_1_0 - 0.630803571428576*G0_0_1_1_1 + 0.0200892857142856*G0_0_1_2_0 + 0.630803571428578*G0_0_1_2_2 - 0.036160714285714*G0_1_0_0_1 + 0.0361607142857141*G0_1_0_0_2 - 0.036160714285714*G0_1_0_1_0 - 0.32544642857143*G0_1_0_1_1 + 0.0361607142857141*G0_1_0_2_0 + 0.32544642857143*G0_1_0_2_2 - 0.116517857142859*G0_1_1_0_0 - 0.176785714285716*G0_1_1_0_1 - 0.0441964285714284*G0_1_1_0_2 - 0.176785714285716*G0_1_1_1_0 - 1.07276785714286*G0_1_1_1_1 - 0.100446428571428*G0_1_1_1_2 - 0.0441964285714284*G0_1_1_2_0 - 0.100446428571428*G0_1_1_2_1 + 0.14464285714286*G0_1_1_2_2;
    A[57] = A[75] - 0.265178571428574*G0_0_1_0_0 + 0.0361607142857145*G0_0_1_0_1 + 0.0361607142857144*G0_0_1_0_2 + 0.0361607142857145*G0_0_1_1_0 + 0.0401785714285717*G0_0_1_1_1 + 0.0200892857142857*G0_0_1_1_2 + 0.0361607142857144*G0_0_1_2_0 + 0.0200892857142857*G0_0_1_2_1 + 0.0401785714285717*G0_0_1_2_2 + 0.265178571428574*G0_1_0_0_0 - 0.0361607142857145*G0_1_0_0_1 - 0.0361607142857144*G0_1_0_0_2 - 0.0361607142857145*G0_1_0_1_0 - 0.0401785714285717*G0_1_0_1_1 - 0.0200892857142857*G0_1_0_1_2 - 0.0361607142857144*G0_1_0_2_0 - 0.0200892857142857*G0_1_0_2_1 - 0.0401785714285717*G0_1_0_2_2;
    A[56] = -A[54] - 0.196875000000002*G0_0_1_0_0 - 0.0441964285714282*G0_0_1_0_1 - 0.192857142857145*G0_0_1_0_2 - 0.0441964285714282*G0_0_1_1_0 + 0.0200892857142872*G0_0_1_1_1 - 0.0241071428571418*G0_0_1_1_2 - 0.192857142857145*G0_0_1_2_0 - 0.0241071428571418*G0_0_1_2_1 - 0.31339285714286*G0_0_1_2_2 - 0.462053571428577*G0_1_1_0_0 - 0.102455357142858*G0_1_1_0_1 - 0.158705357142858*G0_1_1_0_2 - 0.102455357142858*G0_1_1_1_0 - 0.0080357142857134*G0_1_1_1_1 - 0.0341517857142846*G0_1_1_1_2 - 0.158705357142858*G0_1_1_2_0 - 0.0341517857142846*G0_1_1_2_1 - 0.289285714285716*G0_1_1_2_2;
    A[3] = A[30] + 0.0020089285714287*G0_0_1_0_1 - 0.00200892857142853*G0_0_1_0_2 + 0.0020089285714287*G0_0_1_1_0 - 0.022767857142857*G0_0_1_1_1 + 0.00736607142857187*G0_0_1_1_2 - 0.00200892857142853*G0_0_1_2_0 + 0.00736607142857187*G0_0_1_2_1 + 0.00803571428571489*G0_0_1_2_2 - 0.0020089285714287*G0_1_0_0_1 + 0.00200892857142853*G0_1_0_0_2 - 0.0020089285714287*G0_1_0_1_0 + 0.022767857142857*G0_1_0_1_1 - 0.00736607142857187*G0_1_0_1_2 + 0.00200892857142853*G0_1_0_2_0 - 0.00736607142857187*G0_1_0_2_1 - 0.00803571428571488*G0_1_0_2_2;
    A[8] = -A[3] + 0.168750000000001*G0_0_0_0_0 + 0.0194196428571427*G0_0_0_0_1 + 0.0261160714285716*G0_0_0_0_2 + 0.0194196428571427*G0_0_0_1_0 + 0.0455357142857142*G0_0_0_1_1 - 0.000669642857143361*G0_0_0_1_2 + 0.0261160714285716*G0_0_0_2_0 - 0.000669642857143358*G0_0_0_2_1 - 0.00401785714285775*G0_0_0_2_2 + 0.168750000000001*G0_1_0_0_0 + 0.0194196428571427*G0_1_0_0_1 + 0.0261160714285716*G0_1_0_0_2 + 0.0194196428571427*G0_1_0_1_0 + 0.0455357142857141*G0_1_0_1_1 - 0.000669642857143372*G0_1_0_1_2 + 0.0261160714285716*G0_1_0_2_0 - 0.000669642857143372*G0_1_0_2_1 - 0.00401785714285777*G0_1_0_2_2;
    A[12] = 0.0016369047619047*G0_0_1_0_0 + 0.00483630952380956*G0_0_1_0_1 + 0.00483630952380958*G0_0_1_0_2 + 0.00483630952380956*G0_0_1_1_0 + 0.0324404761904765*G0_0_1_1_1 + 0.000818452380952329*G0_0_1_1_2 + 0.00483630952380958*G0_0_1_2_0 + 0.000818452380952328*G0_0_1_2_1 + 0.0324404761904767*G0_0_1_2_2;
    A[2] = -A[12] - 0.0308035714285718*G0_0_1_0_0 + 0.00401785714285724*G0_0_1_0_2 + 0.0308035714285718*G0_0_1_1_1 - 0.00401785714285725*G0_0_1_1_2 + 0.00401785714285724*G0_0_1_2_0 - 0.00401785714285725*G0_0_1_2_1 - 0.0324404761904765*G0_1_1_0_0 - 0.00483630952380957*G0_1_1_0_1 - 0.000818452380952339*G0_1_1_0_2 - 0.00483630952380957*G0_1_1_1_0 - 0.00163690476190471*G0_1_1_1_1 - 0.00483630952380959*G0_1_1_1_2 - 0.00081845238095234*G0_1_1_2_0 - 0.00483630952380959*G0_1_1_2_1 - 0.0324404761904767*G0_1_1_2_2;
    A[49] = -A[69] + 0.216964285714289*G0_1_0_0_0 + 0.168750000000003*G0_1_0_0_2 - 0.216964285714289*G0_1_0_1_1 - 0.168750000000002*G0_1_0_1_2 + 0.168750000000003*G0_1_0_2_0 - 0.168750000000002*G0_1_0_2_1 - 0.289285714285721*G0_1_1_0_0 - 0.229017857142862*G0_1_1_0_1 - 0.0602678571428569*G0_1_1_0_2 - 0.229017857142862*G0_1_1_1_0 - 0.50625000000001*G0_1_1_1_1 - 0.229017857142859*G0_1_1_1_2 - 0.0602678571428569*G0_1_1_2_0 - 0.229017857142859*G0_1_1_2_1 - 0.192857142857144*G0_1_1_2_2;
    A[94] = A[49] + 0.0723214285714286*G0_0_1_0_0 + 0.0120535714285716*G0_0_1_0_1 + 0.0602678571428572*G0_0_1_0_2 + 0.0120535714285716*G0_0_1_1_0 - 0.14464285714286*G0_0_1_1_1 - 0.108482142857145*G0_0_1_1_2 + 0.0602678571428571*G0_0_1_2_0 - 0.108482142857145*G0_0_1_2_1 + 0.144642857142855*G0_0_1_2_2 - 0.0723214285714286*G0_1_0_0_0 - 0.0120535714285716*G0_1_0_0_1 - 0.0602678571428572*G0_1_0_0_2 - 0.0120535714285716*G0_1_0_1_0 + 0.14464285714286*G0_1_0_1_1 + 0.108482142857145*G0_1_0_1_2 - 0.0602678571428572*G0_1_0_2_0 + 0.108482142857145*G0_1_0_2_1 - 0.144642857142855*G0_1_0_2_2;
    A[97] = A[94] + 0.241071428571431*G0_0_0_0_0 + 0.0120535714285713*G0_0_0_0_1 - 0.0120535714285715*G0_0_0_0_2 + 0.0120535714285713*G0_0_0_1_0 - 0.14464285714286*G0_0_0_1_1 - 0.0120535714285723*G0_0_0_1_2 - 0.0120535714285715*G0_0_0_2_0 - 0.0120535714285723*G0_0_0_2_1 - 0.0723214285714302*G0_0_0_2_2 - 0.192857142857143*G0_0_1_0_0 - 0.0241071428571429*G0_0_1_0_1 - 0.0723214285714287*G0_0_1_0_2 - 0.0241071428571429*G0_0_1_1_0 + 0.120535714285716*G0_0_1_1_2 - 0.0723214285714287*G0_0_1_2_0 + 0.120535714285716*G0_0_1_2_1 + 0.14464285714286*G0_0_1_2_2 + 0.0241071428571412*G0_1_0_0_0 - 0.120535714285717*G0_1_0_0_1 + 0.0482142857142854*G0_1_0_0_2 - 0.120535714285717*G0_1_0_1_0 - 0.289285714285721*G0_1_0_1_1 + 0.0241071428571417*G0_1_0_1_2 + 0.0482142857142854*G0_1_0_2_0 + 0.0241071428571417*G0_1_0_2_1 + 0.361607142857144*G0_1_0_2_2 - 0.337500000000003*G0_1_1_0_0 - 0.144642857142859*G0_1_1_0_1 - 0.144642857142859*G0_1_1_1_0 + 0.144642857142858*G0_1_1_1_2 + 0.144642857142858*G0_1_1_2_1 + 0.337500000000002*G0_1_1_2_2;
    A[99] = -A[97] + 0.843750000000012*G0_0_0_0_0 + 0.156696428571428*G0_0_0_0_1 + 0.494196428571436*G0_0_0_0_2 + 0.156696428571428*G0_0_0_1_0 + 0.409821428571431*G0_0_0_1_1 + 0.349553571428575*G0_0_0_1_2 + 0.494196428571436*G0_0_0_2_0 + 0.349553571428575*G0_0_0_2_1 + 0.795535714285728*G0_0_0_2_2 - 0.0241071428571429*G0_0_1_0_0 + 0.0241071428571427*G0_0_1_0_1 + 0.0241071428571427*G0_0_1_1_0 + 0.21696428571429*G0_0_1_1_1 + 0.241071428571432*G0_0_1_1_2 + 0.241071428571432*G0_0_1_2_1 + 0.289285714285719*G0_0_1_2_2 + 0.120535714285712*G0_1_0_0_0 - 0.084375000000003*G0_1_0_0_1 + 0.0602678571428567*G0_1_0_0_2 - 0.084375000000003*G0_1_0_1_0 + 0.0723214285714289*G0_1_0_1_1 + 0.253125000000003*G0_1_0_1_2 + 0.0602678571428567*G0_1_0_2_0 + 0.253125000000003*G0_1_0_2_1 + 0.361607142857147*G0_1_0_2_2 + 0.120535714285717*G0_1_1_0_0 + 0.14464285714286*G0_1_1_0_1 + 0.0723214285714283*G0_1_1_0_2 + 0.14464285714286*G0_1_1_1_0 + 0.43392857142858*G0_1_1_1_1 + 0.289285714285718*G0_1_1_1_2 + 0.0723214285714283*G0_1_1_2_0 + 0.289285714285718*G0_1_1_2_1 + 0.458035714285719*G0_1_1_2_2;
    A[96] = -A[94] + 0.216964285714289*G0_0_1_0_0 + 0.168750000000003*G0_0_1_0_2 - 0.216964285714289*G0_0_1_1_1 - 0.168750000000002*G0_0_1_1_2 + 0.168750000000003*G0_0_1_2_0 - 0.168750000000002*G0_0_1_2_1 - 0.289285714285721*G0_1_1_0_0 - 0.229017857142862*G0_1_1_0_1 - 0.0602678571428569*G0_1_1_0_2 - 0.229017857142862*G0_1_1_1_0 - 0.50625000000001*G0_1_1_1_1 - 0.229017857142859*G0_1_1_1_2 - 0.0602678571428569*G0_1_1_2_0 - 0.229017857142859*G0_1_1_2_1 - 0.192857142857144*G0_1_1_2_2;
    A[59] = A[97] - 0.723214285714295*G0_0_0_0_0 - 0.0843749999999999*G0_0_0_0_1 - 0.349553571428577*G0_0_0_0_2 - 0.0843749999999999*G0_0_0_1_0 + 0.0482142857142873*G0_0_0_1_1 - 0.060267857142857*G0_0_0_1_2 - 0.349553571428577*G0_0_0_2_0 - 0.060267857142857*G0_0_0_2_1 - 0.361607142857149*G0_0_0_2_2 - 0.0241071428571429*G0_0_1_0_1 + 0.0241071428571429*G0_0_1_0_2 - 0.0241071428571429*G0_0_1_1_0 + 0.0723214285714298*G0_0_1_1_1 + 0.0241071428571429*G0_0_1_2_0 - 0.0723214285714302*G0_0_1_2_2 + 0.14464285714286*G0_1_0_0_1 - 0.14464285714286*G0_1_0_0_2 + 0.14464285714286*G0_1_0_1_0 + 0.289285714285719*G0_1_0_1_1 - 0.14464285714286*G0_1_0_2_0 - 0.289285714285719*G0_1_0_2_2 + 0.723214285714296*G0_1_1_0_0 + 0.349553571428577*G0_1_1_0_1 + 0.084375*G0_1_1_0_2 + 0.349553571428577*G0_1_1_1_0 + 0.36160714285715*G0_1_1_1_1 + 0.0602678571428571*G0_1_1_1_2 + 0.084375*G0_1_1_2_0 + 0.0602678571428571*G0_1_1_2_1 - 0.0482142857142875*G0_1_1_2_2;
    A[33] = -A[83] + 0.140625000000001*G0_0_0_0_0 + 0.104464285714285*G0_0_0_0_1 + 0.140625000000001*G0_0_0_0_2 + 0.104464285714285*G0_0_0_1_0 + 0.216964285714285*G0_0_0_1_1 + 0.208928571428572*G0_0_0_1_2 + 0.140625000000001*G0_0_0_2_0 + 0.208928571428572*G0_0_0_2_1 + 0.421875000000005*G0_0_0_2_2 + 0.0401785714285718*G0_0_1_0_0 + 0.0361607142857144*G0_0_1_0_1 + 0.0200892857142857*G0_0_1_0_2 + 0.0361607142857144*G0_0_1_1_0 - 0.265178571428575*G0_0_1_1_1 + 0.0361607142857142*G0_0_1_1_2 + 0.0200892857142857*G0_0_1_2_0 + 0.0361607142857142*G0_0_1_2_1 + 0.0401785714285715*G0_0_1_2_2;
    A[29] = A[92] + 0.0187500000000002*G0_0_1_0_0 - 0.00267857142857161*G0_0_1_0_2 - 0.0187500000000001*G0_0_1_1_1 + 0.00267857142857171*G0_0_1_1_2 - 0.00267857142857161*G0_0_1_2_0 + 0.00267857142857171*G0_0_1_2_1 - 0.0187500000000002*G0_1_0_0_0 + 0.00267857142857161*G0_1_0_0_2 + 0.0187500000000001*G0_1_0_1_1 - 0.00267857142857171*G0_1_0_1_2 + 0.00267857142857161*G0_1_0_2_0 - 0.00267857142857171*G0_1_0_2_1;
    A[81] = -A[31] - 0.0883928571428584*G0_0_0_0_0 - 0.033482142857143*G0_0_0_0_1 - 0.0441964285714292*G0_0_0_0_2 - 0.033482142857143*G0_0_0_1_0 - 0.238392857142859*G0_0_0_1_1 - 0.0334821428571429*G0_0_0_1_2 - 0.0441964285714292*G0_0_0_2_0 - 0.0334821428571429*G0_0_0_2_1 - 0.0883928571428584*G0_0_0_2_2;
    A[44] = -A[64] + 0.0401785714285719*G0_1_0_0_0 + 0.0200892857142858*G0_1_0_0_1 + 0.0361607142857142*G0_1_0_0_2 + 0.0200892857142858*G0_1_0_1_0 + 0.040178571428572*G0_1_0_1_1 + 0.0361607142857143*G0_1_0_1_2 + 0.0361607142857142*G0_1_0_2_0 + 0.0361607142857142*G0_1_0_2_1 - 0.265178571428576*G0_1_0_2_2 + 0.140625000000002*G0_1_1_0_0 + 0.140625000000001*G0_1_1_0_1 + 0.104464285714285*G0_1_1_0_2 + 0.140625000000001*G0_1_1_1_0 + 0.421875000000005*G0_1_1_1_1 + 0.208928571428572*G0_1_1_1_2 + 0.104464285714285*G0_1_1_2_0 + 0.208928571428572*G0_1_1_2_1 + 0.216964285714285*G0_1_1_2_2;
    A[63] = -A[68] + 0.0281250000000006*G0_0_0_0_0 + 0.0100446428571429*G0_0_0_0_1 + 0.0582589285714301*G0_0_0_0_2 + 0.0100446428571429*G0_0_0_1_0 - 0.0241071428571435*G0_0_0_1_1 - 0.0341517857142862*G0_0_0_1_2 + 0.0582589285714301*G0_0_0_2_0 - 0.0341517857142862*G0_0_0_2_1 + 0.265178571428576*G0_0_0_2_2 - 0.0562500000000038*G0_1_0_0_0 - 0.0100446428571442*G0_1_0_0_1 - 0.0301339285714305*G0_1_0_0_2 - 0.0100446428571442*G0_1_0_1_0 + 0.0100446428571418*G0_1_0_1_2 - 0.0301339285714305*G0_1_0_2_0 + 0.0100446428571418*G0_1_0_2_1 + 0.116517857142856*G0_1_0_2_2;
    A[0] = A[22] + 0.252083333333335*G0_0_0_0_0 + 0.026934523809524*G0_0_0_0_1 + 0.026934523809524*G0_0_0_0_2 + 0.026934523809524*G0_0_0_1_0 + 0.0217261904761908*G0_0_0_1_1 + 0.0108630952380954*G0_0_0_1_2 + 0.026934523809524*G0_0_0_2_0 + 0.0108630952380954*G0_0_0_2_1 + 0.0217261904761908*G0_0_0_2_2 + 0.252083333333335*G0_0_1_0_0 + 0.026934523809524*G0_0_1_0_1 + 0.026934523809524*G0_0_1_0_2 + 0.026934523809524*G0_0_1_1_0 + 0.0217261904761908*G0_0_1_1_1 + 0.0108630952380954*G0_0_1_1_2 + 0.026934523809524*G0_0_1_2_0 + 0.0108630952380954*G0_0_1_2_1 + 0.0217261904761908*G0_0_1_2_2 + 0.252083333333335*G0_1_0_0_0 + 0.026934523809524*G0_1_0_0_1 + 0.026934523809524*G0_1_0_0_2 + 0.026934523809524*G0_1_0_1_0 + 0.0217261904761908*G0_1_0_1_1 + 0.0108630952380954*G0_1_0_1_2 + 0.026934523809524*G0_1_0_2_0 + 0.0108630952380954*G0_1_0_2_1 + 0.0217261904761908*G0_1_0_2_2 + 0.230357142857145*G0_1_1_0_0 + 0.0160714285714286*G0_1_1_0_1 + 0.0160714285714286*G0_1_1_1_0 - 0.0160714285714286*G0_1_1_1_2 - 0.0160714285714286*G0_1_1_2_1 - 0.230357142857145*G0_1_1_2_2;
    A[79] = A[97] + 0.144642857142855*G0_0_1_0_0 - 0.108482142857146*G0_0_1_0_1 + 0.0602678571428569*G0_0_1_0_2 - 0.108482142857146*G0_0_1_1_0 - 0.144642857142861*G0_0_1_1_1 + 0.0120535714285712*G0_0_1_1_2 + 0.0602678571428569*G0_0_1_2_0 + 0.0120535714285712*G0_0_1_2_1 + 0.0723214285714282*G0_0_1_2_2 - 0.144642857142855*G0_1_0_0_0 + 0.108482142857146*G0_1_0_0_1 - 0.0602678571428569*G0_1_0_0_2 + 0.108482142857146*G0_1_0_1_0 + 0.144642857142861*G0_1_0_1_1 - 0.0120535714285712*G0_1_0_1_2 - 0.0602678571428569*G0_1_0_2_0 - 0.0120535714285712*G0_1_0_2_1 - 0.0723214285714281*G0_1_0_2_2;
    A[90] = -A[79] + 0.115178571428574*G0_0_0_0_0 + 0.0455357142857156*G0_0_0_0_2 - 0.115178571428574*G0_0_0_1_1 - 0.0455357142857157*G0_0_0_1_2 + 0.0455357142857156*G0_0_0_2_0 - 0.0455357142857157*G0_0_0_2_1 - 0.174107142857146*G0_0_1_0_0 - 0.168750000000003*G0_0_1_0_1 - 0.0267857142857145*G0_0_1_0_2 - 0.168750000000003*G0_0_1_1_0 - 0.30803571428572*G0_0_1_1_1 - 0.0696428571428586*G0_0_1_1_2 - 0.0267857142857145*G0_0_1_2_0 - 0.0696428571428586*G0_0_1_2_1 - 0.318750000000001*G0_1_0_0_0 - 0.0629464285714287*G0_1_0_0_1 - 0.0843749999999999*G0_1_0_0_2 - 0.0629464285714287*G0_1_0_1_0 - 0.144642857142859*G0_1_0_1_1 - 0.0816964285714298*G0_1_0_1_2 - 0.0843749999999999*G0_1_0_2_0 - 0.0816964285714299*G0_1_0_2_1 - 0.0910714285714292*G0_1_0_2_2 - 0.608035714285722*G0_1_1_0_0 - 0.304017857142862*G0_1_1_0_1 - 0.084375*G0_1_1_0_2 - 0.304017857142862*G0_1_1_1_0 - 0.36160714285715*G0_1_1_1_1 - 0.105803571428573*G0_1_1_1_2 - 0.0843749999999999*G0_1_1_2_0 - 0.105803571428573*G0_1_1_2_1 - 0.0669642857142866*G0_1_1_2_2;
    A[9] = A[90] - 0.00267857142857168*G0_0_1_0_1 + 0.00267857142857161*G0_0_1_0_2 - 0.00267857142857168*G0_0_1_1_0 + 0.0187500000000001*G0_0_1_1_1 + 0.00267857142857161*G0_0_1_2_0 - 0.0187500000000001*G0_0_1_2_2 + 0.00267857142857169*G0_1_0_0_1 - 0.00267857142857161*G0_1_0_0_2 + 0.00267857142857169*G0_1_0_1_0 - 0.0187500000000001*G0_1_0_1_1 - 0.00267857142857161*G0_1_0_2_0 + 0.0187500000000001*G0_1_0_2_2;
    A[38] = A[83] - 0.0401785714285718*G0_0_1_0_0 - 0.0361607142857144*G0_0_1_0_1 - 0.0200892857142857*G0_0_1_0_2 - 0.0361607142857144*G0_0_1_1_0 + 0.265178571428575*G0_0_1_1_1 - 0.0361607142857142*G0_0_1_1_2 - 0.0200892857142857*G0_0_1_2_0 - 0.0361607142857142*G0_0_1_2_1 - 0.0401785714285715*G0_0_1_2_2 + 0.0401785714285718*G0_1_0_0_0 + 0.0361607142857144*G0_1_0_0_1 + 0.0200892857142857*G0_1_0_0_2 + 0.0361607142857144*G0_1_0_1_0 - 0.265178571428575*G0_1_0_1_1 + 0.0361607142857142*G0_1_0_1_2 + 0.0200892857142857*G0_1_0_2_0 + 0.0361607142857142*G0_1_0_2_1 + 0.0401785714285715*G0_1_0_2_2;
    A[20] = -A[21] - 0.0308035714285718*G0_1_0_0_0 + 0.00401785714285724*G0_1_0_0_2 + 0.0308035714285718*G0_1_0_1_1 - 0.00401785714285725*G0_1_0_1_2 + 0.00401785714285724*G0_1_0_2_0 - 0.00401785714285726*G0_1_0_2_1 - 0.0324404761904765*G0_1_1_0_0 - 0.00483630952380957*G0_1_1_0_1 - 0.000818452380952342*G0_1_1_0_2 - 0.00483630952380957*G0_1_1_1_0 - 0.00163690476190472*G0_1_1_1_1 - 0.00483630952380959*G0_1_1_1_2 - 0.000818452380952341*G0_1_1_2_0 - 0.00483630952380959*G0_1_1_2_1 - 0.0324404761904767*G0_1_1_2_2;
    A[18] = -A[13] - 0.0883928571428584*G0_0_0_0_0 - 0.033482142857143*G0_0_0_0_1 - 0.0441964285714292*G0_0_0_0_2 - 0.033482142857143*G0_0_0_1_0 - 0.238392857142859*G0_0_0_1_1 - 0.0334821428571429*G0_0_0_1_2 - 0.0441964285714292*G0_0_0_2_0 - 0.0334821428571429*G0_0_0_2_1 - 0.0883928571428584*G0_0_0_2_2;
    A[88] = -A[83] + 0.381696428571434*G0_0_0_0_0 + 0.172767857142858*G0_0_0_0_1 + 0.120535714285716*G0_0_0_0_2 + 0.172767857142858*G0_0_0_1_0 + 0.48214285714286*G0_0_0_1_1 + 0.0683035714285708*G0_0_0_1_2 + 0.120535714285716*G0_0_0_2_0 + 0.0683035714285708*G0_0_0_2_1 + 0.10044642857143*G0_0_0_2_2 - 0.0401785714285718*G0_1_0_0_0 - 0.0361607142857143*G0_1_0_0_1 - 0.0200892857142857*G0_1_0_0_2 - 0.0361607142857143*G0_1_0_1_0 + 0.265178571428575*G0_1_0_1_1 - 0.0361607142857142*G0_1_0_1_2 - 0.0200892857142857*G0_1_0_2_0 - 0.0361607142857142*G0_1_0_2_1 - 0.0401785714285715*G0_1_0_2_2;
    A[77] = A[88] + 0.361607142857145*G0_0_0_0_0 + 0.0241071428571428*G0_0_0_0_2 - 0.361607142857145*G0_0_0_1_1 - 0.0241071428571428*G0_0_0_1_2 + 0.0241071428571428*G0_0_0_2_0 - 0.0241071428571428*G0_0_0_2_1 + 0.0361607142857159*G0_0_1_0_0 + 0.108482142857145*G0_0_1_0_1 + 0.0241071428571428*G0_0_1_0_2 + 0.108482142857145*G0_0_1_1_0 - 0.325446428571429*G0_0_1_1_1 + 0.0241071428571428*G0_0_1_2_0 + 0.0241071428571431*G0_0_1_2_2 + 0.0361607142857159*G0_1_0_0_0 + 0.108482142857145*G0_1_0_0_1 + 0.0241071428571428*G0_1_0_0_2 + 0.108482142857145*G0_1_0_1_0 - 0.325446428571429*G0_1_0_1_1 + 0.0241071428571428*G0_1_0_2_0 + 0.0241071428571432*G0_1_0_2_2 + 0.361607142857146*G0_1_1_0_0 + 0.108482142857145*G0_1_1_0_1 + 0.060267857142857*G0_1_1_0_2 + 0.108482142857145*G0_1_1_1_0 - 0.65089285714286*G0_1_1_1_1 - 0.036160714285714*G0_1_1_1_2 + 0.060267857142857*G0_1_1_2_0 - 0.0361607142857141*G0_1_1_2_1 + 0.0241071428571432*G0_1_1_2_2;
    A[43] = A[34] - 0.0120535714285712*G0_0_1_0_0 - 0.0421874999999996*G0_0_1_0_1 - 0.0421874999999995*G0_0_1_0_2 - 0.0421874999999996*G0_0_1_1_0 - 0.216964285714288*G0_0_1_1_1 - 0.19888392857143*G0_0_1_1_2 - 0.0421874999999995*G0_0_1_2_0 - 0.19888392857143*G0_0_1_2_1 - 0.216964285714287*G0_0_1_2_2 + 0.0120535714285712*G0_1_0_0_0 + 0.0421874999999996*G0_1_0_0_1 + 0.0421874999999995*G0_1_0_0_2 + 0.0421874999999996*G0_1_0_1_0 + 0.216964285714288*G0_1_0_1_1 + 0.19888392857143*G0_1_0_1_2 + 0.0421874999999995*G0_1_0_2_0 + 0.19888392857143*G0_1_0_2_1 + 0.216964285714287*G0_1_0_2_2;
    A[95] = A[59] + 0.144642857142855*G0_0_1_0_0 + 0.060267857142857*G0_0_1_0_1 - 0.108482142857146*G0_0_1_0_2 + 0.060267857142857*G0_0_1_1_0 + 0.0723214285714285*G0_0_1_1_1 + 0.0120535714285712*G0_0_1_1_2 - 0.108482142857146*G0_0_1_2_0 + 0.0120535714285713*G0_0_1_2_1 - 0.14464285714286*G0_0_1_2_2 - 0.144642857142855*G0_1_0_0_0 - 0.060267857142857*G0_1_0_0_1 + 0.108482142857146*G0_1_0_0_2 - 0.060267857142857*G0_1_0_1_0 - 0.0723214285714285*G0_1_0_1_1 - 0.0120535714285713*G0_1_0_1_2 + 0.108482142857146*G0_1_0_2_0 - 0.0120535714285713*G0_1_0_2_1 + 0.14464285714286*G0_1_0_2_2;
    A[52] = -A[32] + 0.0187500000000002*G0_0_1_0_0 - 0.0026785714285716*G0_0_1_0_2 - 0.0187500000000001*G0_0_1_1_1 + 0.00267857142857172*G0_0_1_1_2 - 0.00267857142857161*G0_0_1_2_0 + 0.00267857142857171*G0_0_1_2_1 + 0.0830357142857153*G0_1_1_0_0 + 0.0294642857142863*G0_1_1_0_1 + 0.0107142857142857*G0_1_1_0_2 + 0.0294642857142863*G0_1_1_1_0 + 0.0642857142857151*G0_1_1_1_1 + 0.0133928571428573*G0_1_1_1_2 + 0.0107142857142857*G0_1_1_2_0 + 0.0133928571428573*G0_1_1_2_1 + 0.120535714285716*G0_1_1_2_2;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class laplacian_f2_p1_q3_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  laplacian_f2_p1_q3_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~laplacian_f2_p1_q3_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p1_q3_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p1_q3_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p1_q3_tensor_finite_element_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p1_q3_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p1_q3_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new laplacian_f2_p1_q3_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new laplacian_f2_p1_q3_tensor_dofmap_0();
        break;
      }
    case 3:
      {
        return new laplacian_f2_p1_q3_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new laplacian_f2_p1_q3_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
